/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.local;

import java.io.IOException;
import java.util.Map;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import mx4j.tools.remote.AbstractConnectionManager;
import mx4j.tools.remote.Connection;
import mx4j.tools.remote.local.LocalConnection;
import mx4j.tools.remote.local.LocalConnectionHandler;
import mx4j.tools.remote.local.LocalConnectorServer;
import mx4j.tools.remote.local.LocalServerInvoker;
import mx4j.tools.remote.local.LocalSubjectInvoker;

class LocalConnectionManager
extends AbstractConnectionManager {
    private final MBeanServer mbeanServer;

    LocalConnectionManager(LocalConnectorServer server, Map environment) {
        super(server, environment);
        this.mbeanServer = server.getMBeanServer();
    }

    @Override
    public String getProtocol() {
        return "local";
    }

    @Override
    public Connection doConnect(String connectionId, Subject subject) throws IOException {
        LocalServerInvoker serverInvoker = new LocalServerInvoker(this.mbeanServer);
        LocalConnection subjectInvoker = LocalSubjectInvoker.newInstance(serverInvoker, subject, this.getSecurityContext(), this.getEnvironment());
        return new LocalConnectionHandler(connectionId, this, subjectInvoker);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    protected void doCloseConnection(Connection connection) throws IOException {
    }
}

