# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define major_version 8
%define minor_version 0
%define micro_version 18
%define packdname apache-tomcat-%{version}-src
%define jspspec 2.3
%define servletspec 3.2
%define elspec 2.2
%define tcuid 91

%define patchnumber 00
%define patchlevel -patch-%{patchnumber}
%define release_patchlevel _patch_%{patchnumber}

# Sync with the RHEL release version
%define brew_arch noarch
%define brew_release 25_patch_00.ep7.el7

Name: tomcat8
Epoch: 0
Version: %{major_version}.%{minor_version}.%{micro_version}
Release: 25%{release_patchlevel}%{?dist}
Summary: Apache Servlet/JSP Engine, RI for Servlet %{servletspec}/JSP %{jspspec} API
Group: Networking/Daemons
License: ASL 2.0
URL: http://tomcat.apache.org/
Source0: http://www.apache.org/dist/tomcat/tomcat-8/v%{version}/src/%{packdname}.tar.gz
Source1: %{name}-%{major_version}.%{minor_version}.conf
Source2: %{name}-%{major_version}.%{minor_version}.init
Source3: %{name}-%{major_version}.%{minor_version}.wrapper
Source4: %{name}-%{major_version}.%{minor_version}.logrotate
Source5: %{name}-%{major_version}.%{minor_version}-log4j.properties
Source6: %{name}-component-info.xml
Source7: %{name}-8.0.policy
Source8: %{name}-8.0.JBossPublicKey.RSA

# EWS scripts
Source20: %{name}-8.0.catalina.script
Source21: %{name}-8.0.service
Source22: %{name}-8.0.winscripts.tar

Source99: sign-unsigned-jars

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: noarch
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: jakarta-commons-daemon
#rpm-buildrequires: tomcat8-zip
#rpm-buildrequires: tomcat8-docs-webapp
#rpm-buildrequires: tomcat8-javadoc
#rpm-buildrequires: tomcat8-src-zip

%description
Tomcat is the servlet container that is used in the official Reference
Implementation for the Java Servlet and JavaServer Pages technologies.
The Java Servlet and JavaServer Pages specifications are developed by
Sun under the Java Community Process.

Tomcat is developed in an open and participatory environment and
released under the Apache Software License version 2.0. Tomcat is intended
to be a collaboration of the best-of-breed developers from around the world.


%prep
%setup -q -c -T -a 0

%build

%install
rm -rf $RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc

%changelog
* Fri Aug 14 2015 Jean-Frederic Clere <jclere@redhat.com> 0:8.0.18-25_patch_00
- Sync with upstream build.

* Wed Aug 12 2015 Jean-Frederic Clere <jclere@redhat.com> 0:8.0.18-22_patch_00
- Fix for JWS-155

* Tue Jul 14 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-21_patch_00
- Sync with upstream build.

* Wed Jul 1 2015 Jean-Frederic Clere <jclere@redhat.com> 0:8.0.18-20_patch_00
- Sync with upstream build.

* Thu Apr 9 2015 Jean-Frederic Clere <jclere@redhat.com> 0:8.0.18-13_patch_00
- Sync with upstream build.

* Thu Apr 2 2015 Jean-Frederic Clere <jclere@redhat.com> 0:8.0.18-11_patch_00
- Sync with upstream build.

* Mon Mar 30 2015 Maxime Beck <maxbeck@redhat.com> 0:8.0.18-7_patch_00
- Fix JWS-57

* Tue Mar 17 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-6_patch_00
- Sync with upstream build.

* Wed Mar 11 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-4_patch_00
- Sync with upstream build.

* Fri Mar  6 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-3_patch_00
- Sync with upstream build.

* Tue Feb 24 2015 Maxime Beck <maxbeck@redhat.com> 0:8.0.18-2_patch_02
- Sync with upstream build.

* Fri Feb 20 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-2_patch_01
- Fix windows typos.

* Thu Feb 19 2015 Mladen Turk <mturk@redhat.com> 0:8.0.18-2_patch_00
- Sync with upstream build.

* Tue Jan 13 2015 Mladen Turk <mturk@redhat.com> 0:8.0.15-5_patch_00
- Sync with upstream build.

