/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashSetOfInt;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            StringLiteral literal1 = (StringLiteral)o1;
            StringLiteral literal2 = (StringLiteral)o2;
            return literal1.sourceStart - literal2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;
    private HashSetOfInt stringLiteralsStart;
    public boolean[] validIdentityComparisonLines;
    IrritantSet[] suppressWarningIrritants;
    Annotation[] suppressWarningAnnotations;
    long[] suppressWarningScopePositions;
    int suppressWarningsCount;
    public int functionalExpressionsCount;
    public FunctionalExpression[] functionalExpressions;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = sourceLength - 1;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, problem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].analyseCode(this.scope);
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        if (this.types != null) {
            int i;
            int max = this.types.length;
            for (i = 0; i < max; ++i) {
                this.cleanUp(this.types[i]);
            }
            max = this.localTypeCount;
            for (i = 0; i < max; ++i) {
                LocalTypeBinding localType = this.localTypes[i];
                localType.scope = null;
                localType.enclosingCase = null;
            }
        }
        this.compilationResult.recoveryScannerData = null;
        for (ClassFile classFile : this.compilationResult.getClassFiles()) {
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
            classFile.bootstrapMethods = null;
            classFile.missingTypes = null;
            classFile.visitedTypes = null;
        }
        this.suppressWarningAnnotations = null;
    }

    private void cleanUp(TypeDeclaration type) {
        if (type.memberTypes != null) {
            int max = type.memberTypes.length;
            for (int i = 0; i < max; ++i) {
                this.cleanUp(type.memberTypes[i]);
            }
        }
        if (type.binding != null && type.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (type.binding != null) {
            type.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            for (ImportBinding importBinding : this.scope.imports) {
                ImportReference importReference = importBinding.reference;
                if (importReference == null || (importReference.bits & 2) != 0) continue;
                this.scope.problemReporter().unusedImport(importReference);
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void createPackageInfoType() {
        TypeDeclaration declaration = new TypeDeclaration(this.compilationResult);
        declaration.name = TypeConstants.PACKAGE_INFO_NAME;
        declaration.modifiers = 512;
        declaration.javadoc = this.javadoc;
        this.types[0] = declaration;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        for (int i = 0; i < this.types.length; ++i) {
            TypeDeclaration typeDecl = this.types[i].declarationOfType(typeName);
            if (typeDecl == null) continue;
            return typeDecl;
        }
        return null;
    }

    public void finalizeProblems() {
        int severity;
        CategorizedProblem problem;
        if (this.suppressWarningsCount == 0) {
            return;
        }
        int removed = 0;
        CategorizedProblem[] problems = this.compilationResult.problems;
        int problemCount = this.compilationResult.problemCount;
        IrritantSet[] foundIrritants = new IrritantSet[this.suppressWarningsCount];
        CompilerOptions options = this.scope.compilerOptions();
        boolean hasMandatoryErrors = false;
        int length = problemCount;
        block0: for (int iProblem = 0; iProblem < length; ++iProblem) {
            problem = problems[iProblem];
            int problemID = problem.getID();
            int irritant = ProblemReporter.getIrritant(problemID);
            boolean isError = problem.isError();
            if (isError) {
                if (irritant == 0) {
                    hasMandatoryErrors = true;
                    continue;
                }
                if (!options.suppressOptionalErrors) continue;
            }
            int start = problem.getSourceStart();
            int end = problem.getSourceEnd();
            int suppressCount = this.suppressWarningsCount;
            for (int iSuppress = 0; iSuppress < suppressCount; ++iSuppress) {
                long position = this.suppressWarningScopePositions[iSuppress];
                int startSuppress = (int)(position >>> 32);
                int endSuppress = (int)position;
                if (start < startSuppress || end > endSuppress || !this.suppressWarningIrritants[iSuppress].isSet(irritant)) continue;
                ++removed;
                problems[iProblem] = null;
                this.compilationResult.removeProblem(problem);
                if (foundIrritants[iSuppress] == null) {
                    foundIrritants[iSuppress] = new IrritantSet(irritant);
                    continue block0;
                }
                foundIrritants[iSuppress].set(irritant);
                continue block0;
            }
        }
        if (removed > 0) {
            int index = 0;
            for (int i = 0; i < problemCount; ++i) {
                problem = problems[i];
                if (problem == null) continue;
                if (i > index) {
                    problems[index++] = problem;
                    continue;
                }
                ++index;
            }
        }
        if (!hasMandatoryErrors && (severity = options.getSeverity(0x22000000)) != 256) {
            boolean unusedWarningTokenIsWarning = (severity & 1) == 0;
            int suppressCount = this.suppressWarningsCount;
            block3: for (int iSuppress = 0; iSuppress < suppressCount; ++iSuppress) {
                Annotation annotation = this.suppressWarningAnnotations[iSuppress];
                if (annotation == null) continue;
                IrritantSet irritants = this.suppressWarningIrritants[iSuppress];
                if (unusedWarningTokenIsWarning && irritants.areAllSet() || irritants == foundIrritants[iSuppress]) continue;
                for (MemberValuePair pair : annotation.memberValuePairs()) {
                    IrritantSet tokenIrritants;
                    if (!CharOperation.equals(pair.name, TypeConstants.VALUE)) continue;
                    Expression value = pair.value;
                    if (value instanceof ArrayInitializer) {
                        ArrayInitializer initializer = (ArrayInitializer)value;
                        Expression[] inits = initializer.expressions;
                        if (inits == null) continue block3;
                        int tokenCount = inits.length;
                        for (int iToken = 0; iToken < tokenCount; ++iToken) {
                            IrritantSet tokenIrritants2;
                            Constant cst = inits[iToken].constant;
                            if (cst == Constant.NotAConstant || cst.typeID() != 11 || (tokenIrritants2 = CompilerOptions.warningTokenToIrritants(cst.stringValue())) == null || tokenIrritants2.areAllSet() || !options.isAnyEnabled(tokenIrritants2) || foundIrritants[iSuppress] != null && foundIrritants[iSuppress].isAnySet(tokenIrritants2)) continue;
                            if (unusedWarningTokenIsWarning) {
                                int start = value.sourceStart;
                                int end = value.sourceEnd;
                                for (int jSuppress = iSuppress - 1; jSuppress >= 0; --jSuppress) {
                                    long position = this.suppressWarningScopePositions[jSuppress];
                                    int startSuppress = (int)(position >>> 32);
                                    int endSuppress = (int)position;
                                    if (start >= startSuppress && end <= endSuppress && this.suppressWarningIrritants[jSuppress].areAllSet()) continue block3;
                                }
                            }
                            this.scope.problemReporter().unusedWarningToken(inits[iToken]);
                        }
                        continue block3;
                    }
                    Constant cst = value.constant;
                    if (cst == Constant.NotAConstant || cst.typeID() != 11 || (tokenIrritants = CompilerOptions.warningTokenToIrritants(cst.stringValue())) == null || tokenIrritants.areAllSet() || !options.isAnyEnabled(tokenIrritants) || foundIrritants[iSuppress] != null && foundIrritants[iSuppress].isAnySet(tokenIrritants)) continue block3;
                    if (unusedWarningTokenIsWarning) {
                        int start = value.sourceStart;
                        int end = value.sourceEnd;
                        for (int jSuppress = iSuppress - 1; jSuppress >= 0; --jSuppress) {
                            long position = this.suppressWarningScopePositions[jSuppress];
                            int startSuppress = (int)(position >>> 32);
                            int endSuppress = (int)position;
                            if (start >= startSuppress && end <= endSuppress && this.suppressWarningIrritants[jSuppress].areAllSet()) continue block3;
                        }
                    }
                    this.scope.problemReporter().unusedWarningToken(value);
                    continue block3;
                }
            }
        }
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].ignoreFurtherInvestigation = true;
                    this.types[i].generateCode(this.scope);
                }
            }
            return;
        }
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = 0; i < count; ++i) {
                    this.types[i].generateCode(this.scope);
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this;
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int end;
            char[] fileName = this.compilationResult.getFileName();
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean isSuppressed(CategorizedProblem problem) {
        if (this.suppressWarningsCount == 0) {
            return false;
        }
        int irritant = ProblemReporter.getIrritant(problem.getID());
        if (irritant == 0) {
            return false;
        }
        int start = problem.getSourceStart();
        int end = problem.getSourceEnd();
        int suppressCount = this.suppressWarningsCount;
        for (int iSuppress = 0; iSuppress < suppressCount; ++iSuppress) {
            long position = this.suppressWarningScopePositions[iSuppress];
            int startSuppress = (int)(position >>> 32);
            int endSuppress = (int)position;
            if (start < startSuppress || end > endSuppress || !this.suppressWarningIrritants[iSuppress].isSet(irritant)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFunctionalTypes() {
        return this.compilationResult.hasFunctionalTypes;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(indent, output).append("package ");
            this.currentPackage.print(0, output, false).append(";\n");
        }
        if (this.imports != null) {
            for (i = 0; i < this.imports.length; ++i) {
                CompilationUnitDeclaration.printIndent(indent, output).append("import ");
                ImportReference currentImport = this.imports[i];
                if (currentImport.isStatic()) {
                    output.append("static ");
                }
                currentImport.print(0, output).append(";\n");
            }
        }
        if (this.types != null) {
            for (i = 0; i < this.types.length; ++i) {
                this.types[i].print(indent, output).append("\n");
            }
        }
        return output;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int max = this.localTypeCount;
        for (int i = 0; i < max; ++i) {
            LocalTypeBinding localType = this.localTypes[i];
            if ((localType.scope.referenceType().bits & Integer.MIN_VALUE) == 0) continue;
            localType.updateInnerEmulationDependents();
        }
    }

    public void recordStringLiteral(StringLiteral literal, boolean fromRecovery) {
        if (this.stringLiteralsStart != null) {
            if (this.stringLiteralsStart.contains(literal.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(literal.sourceStart);
        } else if (fromRecovery) {
            this.stringLiteralsStart = new HashSetOfInt(this.stringLiteralsPtr + 10);
            for (int i = 0; i < this.stringLiteralsPtr; ++i) {
                this.stringLiteralsStart.add(this.stringLiterals[i].sourceStart);
            }
            if (this.stringLiteralsStart.contains(literal.sourceStart)) {
                return;
            }
            this.stringLiteralsStart.add(literal.sourceStart);
        }
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            int stackLength = this.stringLiterals.length;
            if (this.stringLiteralsPtr == stackLength) {
                this.stringLiterals = new StringLiteral[stackLength + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stackLength);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = literal;
    }

    public void recordSuppressWarnings(IrritantSet irritants, Annotation annotation, int scopeStart, int scopeEnd, ReferenceContext context) {
        if (context instanceof LambdaExpression && context != ((LambdaExpression)context).original()) {
            return;
        }
        if (this.suppressWarningIrritants == null) {
            this.suppressWarningIrritants = new IrritantSet[3];
            this.suppressWarningAnnotations = new Annotation[3];
            this.suppressWarningScopePositions = new long[3];
        } else if (this.suppressWarningIrritants.length == this.suppressWarningsCount) {
            this.suppressWarningIrritants = new IrritantSet[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningIrritants, 0, this.suppressWarningIrritants, 0, this.suppressWarningsCount);
            this.suppressWarningAnnotations = new Annotation[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningAnnotations, 0, this.suppressWarningAnnotations, 0, this.suppressWarningsCount);
            this.suppressWarningScopePositions = new long[2 * this.suppressWarningsCount];
            System.arraycopy(this.suppressWarningScopePositions, 0, this.suppressWarningScopePositions, 0, this.suppressWarningsCount);
        }
        long scopePositions = ((long)scopeStart << 32) + (long)scopeEnd;
        int max = this.suppressWarningsCount;
        for (int i = 0; i < max; ++i) {
            if (this.suppressWarningAnnotations[i] != annotation || this.suppressWarningScopePositions[i] != scopePositions || !this.suppressWarningIrritants[i].hasSameIrritants(irritants)) continue;
            return;
        }
        this.suppressWarningIrritants[this.suppressWarningsCount] = irritants;
        this.suppressWarningAnnotations[this.suppressWarningsCount] = annotation;
        this.suppressWarningScopePositions[this.suppressWarningsCount++] = scopePositions;
    }

    public void record(LocalTypeBinding localType) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localType;
    }

    public int record(FunctionalExpression expression) {
        if (this.functionalExpressionsCount == 0) {
            this.functionalExpressions = new FunctionalExpression[5];
        } else if (this.functionalExpressionsCount == this.functionalExpressions.length) {
            this.functionalExpressions = new FunctionalExpression[this.functionalExpressionsCount * 2];
            System.arraycopy(this.functionalExpressions, 0, this.functionalExpressions, 0, this.functionalExpressionsCount);
        }
        this.functionalExpressions[this.functionalExpressionsCount] = expression;
        return ++this.functionalExpressionsCount;
    }

    public void resolve() {
        int startingTypeIndex = 0;
        boolean isPackageInfo = this.isPackageInfo();
        if (this.types != null && isPackageInfo) {
            TypeDeclaration syntheticTypeDeclaration = this.types[0];
            if (syntheticTypeDeclaration.javadoc == null) {
                syntheticTypeDeclaration.javadoc = new Javadoc(syntheticTypeDeclaration.declarationSourceStart, syntheticTypeDeclaration.declarationSourceStart);
            }
            syntheticTypeDeclaration.resolve(this.scope);
            if (this.javadoc != null && syntheticTypeDeclaration.staticInitializerScope != null) {
                this.javadoc.resolve(syntheticTypeDeclaration.staticInitializerScope);
            }
            startingTypeIndex = 1;
        } else if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !isPackageInfo) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int count = this.types.length;
                for (int i = startingTypeIndex; i < count; ++i) {
                    this.types[i].resolve(this.scope);
                }
            }
            if (!this.compilationResult.hasMandatoryErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    private void reportNLSProblems() {
        block20: {
            int nlsTagsLength;
            int stringLiteralsLength;
            block21: {
                if (this.nlsTags == null && this.stringLiterals == null) break block20;
                stringLiteralsLength = this.stringLiteralsPtr;
                int n = nlsTagsLength = this.nlsTags == null ? 0 : this.nlsTags.length;
                if (stringLiteralsLength != 0) break block21;
                if (nlsTagsLength == 0) break block20;
                for (int i = 0; i < nlsTagsLength; ++i) {
                    NLSTag tag = this.nlsTags[i];
                    if (tag == null) continue;
                    this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
                }
                break block20;
            }
            if (nlsTagsLength == 0) {
                if (this.stringLiterals.length != stringLiteralsLength) {
                    this.stringLiterals = new StringLiteral[stringLiteralsLength];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stringLiteralsLength);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                for (int i = 0; i < stringLiteralsLength; ++i) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                }
            } else {
                int i;
                if (this.stringLiterals.length != stringLiteralsLength) {
                    this.stringLiterals = new StringLiteral[stringLiteralsLength];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stringLiteralsLength);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                int indexInLine = 1;
                int lastLineNumber = -1;
                StringLiteral literal = null;
                int index = 0;
                block2: for (i = 0; i < stringLiteralsLength; ++i) {
                    literal = this.stringLiterals[i];
                    int literalLineNumber = literal.lineNumber;
                    if (lastLineNumber != literalLineNumber) {
                        indexInLine = 1;
                        lastLineNumber = literalLineNumber;
                    } else {
                        ++indexInLine;
                    }
                    if (index >= nlsTagsLength) break;
                    while (index < nlsTagsLength) {
                        NLSTag tag = this.nlsTags[index];
                        if (tag != null) {
                            int tagLineNumber = tag.lineNumber;
                            if (literalLineNumber < tagLineNumber) {
                                this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                                continue block2;
                            }
                            if (literalLineNumber == tagLineNumber) {
                                if (tag.index == indexInLine) {
                                    this.nlsTags[index] = null;
                                    ++index;
                                    continue block2;
                                }
                                for (int index2 = index + 1; index2 < nlsTagsLength; ++index2) {
                                    NLSTag tag2 = this.nlsTags[index2];
                                    if (tag2 == null) continue;
                                    int tagLineNumber2 = tag2.lineNumber;
                                    if (literalLineNumber == tagLineNumber2) {
                                        if (tag2.index != indexInLine) continue;
                                        this.nlsTags[index2] = null;
                                        continue block2;
                                    }
                                    this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                                    continue block2;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                                continue block2;
                            }
                            this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
                        }
                        ++index;
                    }
                    break block2;
                }
                while (i < stringLiteralsLength) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                    ++i;
                }
                if (index < nlsTagsLength) {
                    while (index < nlsTagsLength) {
                        NLSTag tag = this.nlsTags[index];
                        if (tag != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        this.traverse(visitor, unitScope, true);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope, boolean skipOnError) {
        if (skipOnError && this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, this.scope)) {
                if (this.types != null && this.isPackageInfo()) {
                    Annotation[] annotations;
                    TypeDeclaration syntheticTypeDeclaration = this.types[0];
                    MethodScope methodScope = syntheticTypeDeclaration.staticInitializerScope;
                    if (this.javadoc != null && methodScope != null) {
                        this.javadoc.traverse(visitor, methodScope);
                    }
                    if (this.currentPackage != null && methodScope != null && (annotations = this.currentPackage.annotations) != null) {
                        int annotationsLength = annotations.length;
                        for (int i = 0; i < annotationsLength; ++i) {
                            annotations[i].traverse(visitor, methodScope);
                        }
                    }
                }
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(visitor, this.scope);
                }
                if (this.imports != null) {
                    int importLength = this.imports.length;
                    for (int i = 0; i < importLength; ++i) {
                        this.imports[i].traverse(visitor, this.scope);
                    }
                }
                if (this.types != null) {
                    int typesLength = this.types.length;
                    for (int i = 0; i < typesLength; ++i) {
                        this.types[i].traverse(visitor, this.scope);
                    }
                }
            }
            visitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit e) {
            // empty catch block
        }
    }
}

