/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tomcat.dbcp.collections.KeyValue;

public class SequencedHashMap
implements Map,
Cloneable,
Externalizable {
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;
    private transient long modCount = 0L;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;

    private static final Entry createSentinel() {
        Entry entry;
        entry.prev = entry = new Entry(null, null);
        entry.next = entry;
        return entry;
    }

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int n) {
        this.entries = new HashMap(n);
    }

    public SequencedHashMap(int n, float f) {
        this.entries = new HashMap(n, f);
    }

    public SequencedHashMap(Map map) {
        this();
        this.putAll(map);
    }

    private void removeEntry(Entry entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private void insertEntry(Entry entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.entries.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.sentinel.next;
            while (entry != this.sentinel) {
                if (object.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getFirst() {
        return this.isEmpty() ? null : this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry getLast() {
        return this.isEmpty() ? null : this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    public Object put(Object object, Object object2) {
        ++this.modCount;
        Object object3 = null;
        Entry entry = (Entry)this.entries.get(object);
        if (entry != null) {
            this.removeEntry(entry);
            object3 = entry.setValue(object2);
        } else {
            entry = new Entry(object, object2);
            this.entries.put(object, entry);
        }
        this.insertEntry(entry);
        return object3;
    }

    public Object remove(Object object) {
        Entry entry = this.removeImpl(object);
        return entry == null ? null : entry.getValue();
    }

    private Entry removeImpl(Object object) {
        Entry entry = (Entry)this.entries.remove(object);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(entry);
        return entry;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)object).entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Entry entry = this.sentinel.next;
        while (entry != this.sentinel) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(entry.getValue());
            if (entry.next != this.sentinel) {
                stringBuffer.append(',');
            }
            entry = entry.next;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new OrderedIterator(0);
            }

            @Override
            public boolean remove(Object object) {
                Entry entry = SequencedHashMap.this.removeImpl(object);
                return entry != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return SequencedHashMap.this.containsKey(object);
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return new OrderedIterator(1);
            }

            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    Entry entry = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (entry != SequencedHashMap.this.sentinel) {
                        if (entry.getValue() == null) {
                            SequencedHashMap.this.removeImpl(entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                } else {
                    Entry entry = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (entry != SequencedHashMap.this.sentinel) {
                        if (object.equals(entry.getValue())) {
                            SequencedHashMap.this.removeImpl(entry.getKey());
                            return true;
                        }
                        entry = entry.next;
                    }
                }
                return false;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return SequencedHashMap.this.containsValue(object);
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            private Entry findEntry(Object object) {
                if (object == null) {
                    return null;
                }
                if (!(object instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry entry = (Map.Entry)object;
                Entry entry2 = (Entry)SequencedHashMap.this.entries.get(entry.getKey());
                if (entry2 != null && entry2.equals(entry)) {
                    return entry2;
                }
                return null;
            }

            @Override
            public Iterator iterator() {
                return new OrderedIterator(2);
            }

            @Override
            public boolean remove(Object object) {
                Entry entry = this.findEntry(object);
                if (entry == null) {
                    return false;
                }
                return SequencedHashMap.this.removeImpl(entry.getKey()) != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return this.findEntry(object) != null;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap sequencedHashMap = (SequencedHashMap)super.clone();
        sequencedHashMap.sentinel = SequencedHashMap.createSentinel();
        sequencedHashMap.entries = new HashMap();
        sequencedHashMap.putAll((Map)this);
        return sequencedHashMap;
    }

    private Map.Entry getEntry(int n) {
        int n2;
        Entry entry = this.sentinel;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
        for (n2 = -1; n2 < n - 1 && entry.next != this.sentinel; ++n2) {
            entry = entry.next;
        }
        if (entry.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + (n2 + 1));
        }
        return entry.next;
    }

    public Object get(int n) {
        return this.getEntry(n).getKey();
    }

    public Object getValue(int n) {
        return this.getEntry(n).getValue();
    }

    public int indexOf(Object object) {
        Entry entry = (Entry)this.entries.get(object);
        if (entry == null) {
            return -1;
        }
        int n = 0;
        while (entry.prev != this.sentinel) {
            ++n;
            entry = entry.prev;
        }
        return n;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public List sequence() {
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Object remove(int n) {
        return this.remove(this.get(n));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Entry entry = this.sentinel.next;
        while (entry != this.sentinel) {
            objectOutput.writeObject(entry.getKey());
            objectOutput.writeObject(entry.getValue());
            entry = entry.next;
        }
    }

    private class OrderedIterator
    implements Iterator {
        private int returnType;
        private Entry pos;
        private transient long expectedModCount;

        public OrderedIterator(int n) {
            this.pos = SequencedHashMap.this.sentinel;
            this.expectedModCount = SequencedHashMap.this.modCount;
            this.returnType = n | Integer.MIN_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.this.sentinel;
        }

        public Object next() {
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.next == SequencedHashMap.this.sentinel) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error("bad iterator type: " + this.returnType);
        }

        @Override
        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException("remove() must follow next()");
            }
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.this.removeImpl(this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }

    private static class Entry
    implements Map.Entry,
    KeyValue {
        private final Object key;
        private Object value;
        Entry next = null;
        Entry prev = null;

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }
}

