/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public TypeBinding receiver;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public long tagBits;
    public Boolean[] parameterNonNullness;
    public int defaultNullness;
    public char[][] parameterNames = Binding.NO_PARAMETER_NAMES;

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.parameters = parameters == null || parameters.length == 0 ? Binding.NO_PARAMETERS : parameters;
        this.thrownExceptions = thrownExceptions == null || thrownExceptions.length == 0 ? Binding.NO_EXCEPTIONS : thrownExceptions;
        this.declaringClass = declaringClass;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] parameters, ReferenceBinding[] thrownExceptions, ReferenceBinding declaringClass) {
        this(modifiers, TypeConstants.INIT, TypeBinding.VOID, parameters, thrownExceptions, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.thrownExceptions = initialMethodBinding.thrownExceptions;
        this.declaringClass = declaringClass;
        declaringClass.storeAnnotationHolder(this, initialMethodBinding.declaringClass.retrieveAnnotationHolder(initialMethodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!TypeBinding.notEquals(this.parameters[i], args[i]) || !TypeBinding.notEquals(this.parameters[i].erasure(), args[i].erasure())) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] arguments) {
        int argLength;
        int paramLength = this.parameters.length;
        int lastIndex = argLength = arguments.length;
        if (this.isVarargs()) {
            TypeBinding varArgType;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                varArgType = this.parameters[lastIndex];
                TypeBinding lastArgument = arguments[lastIndex];
                if (TypeBinding.notEquals(varArgType, lastArgument) && !lastArgument.isCompatibleWith(varArgType)) {
                    return false;
                }
            } else if (paramLength < argLength) {
                varArgType = ((ArrayBinding)this.parameters[lastIndex]).elementsType();
                for (int i = lastIndex; i < argLength; ++i) {
                    if (!TypeBinding.notEquals(varArgType, arguments[i]) || arguments[i].isCompatibleWith(varArgType)) continue;
                    return false;
                }
            } else if (lastIndex != argLength) {
                return false;
            }
        }
        for (int i = 0; i < lastIndex; ++i) {
            if (!TypeBinding.notEquals(this.parameters[i], arguments[i]) || arguments[i].isCompatibleWith(this.parameters[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!TypeBinding.notEquals(this.parameters[i], args[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding method) {
        TypeVariableBinding[] vars = method.typeVariables;
        if (this.typeVariables == vars) {
            return true;
        }
        int length = this.typeVariables.length;
        if (length != vars.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!TypeBinding.notEquals(this.typeVariables[i], vars[i]) || !TypeBinding.notEquals(this.typeVariables[i].erasure(), vars[i].erasure())) continue;
            return false;
        }
        return true;
    }

    public MethodBinding asRawMethod(LookupEnvironment env) {
        if (this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return this;
        }
        int length = this.typeVariables.length;
        TypeBinding[] arguments = new TypeBinding[length];
        for (int i = 0; i < length; ++i) {
            int s;
            TypeVariableBinding var = this.typeVariables[i];
            if (var.boundsCount() <= 1) {
                arguments[i] = env.convertToRawType(var.upperBound(), false);
                continue;
            }
            ReferenceBinding[] itsSuperinterfaces = var.superInterfaces();
            int superLength = itsSuperinterfaces.length;
            TypeBinding rawFirstBound = null;
            TypeBinding[] rawOtherBounds = null;
            if (var.boundsCount() == superLength) {
                rawFirstBound = env.convertToRawType(itsSuperinterfaces[0], false);
                rawOtherBounds = new TypeBinding[superLength - 1];
                for (s = 1; s < superLength; ++s) {
                    rawOtherBounds[s - 1] = env.convertToRawType(itsSuperinterfaces[s], false);
                }
            } else {
                rawFirstBound = env.convertToRawType(var.superclass(), false);
                rawOtherBounds = new TypeBinding[superLength];
                for (s = 0; s < superLength; ++s) {
                    rawOtherBounds[s] = env.convertToRawType(itsSuperinterfaces[s], false);
                }
            }
            arguments[i] = env.createWildcard(null, 0, rawFirstBound, rawOtherBounds, 1);
        }
        return env.createParameterizedGenericMethod(this, arguments);
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(invocationType, this.declaringClass)) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding temp;
            ReferenceBinding outerInvocationType = invocationType;
            for (temp = outerInvocationType.enclosingType(); temp != null; temp = temp.enclosingType()) {
                outerInvocationType = temp;
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
            for (temp = outerDeclaringClass.enclosingType(); temp != null; temp = temp.enclosingType()) {
                outerDeclaringClass = temp;
            }
            return TypeBinding.equalsEquals(outerInvocationType, outerDeclaringClass);
        }
        return invocationType.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (this.declaringClass.isInterface() && this.isStatic()) {
            if (scope.compilerOptions().sourceLevel < 0x340000L) {
                return false;
            }
            return (invocationSite.isTypeAccess() || invocationSite.receiverIsImplicitThis()) && TypeBinding.equalsEquals(receiverType, this.declaringClass);
        }
        if (this.isPublic()) {
            return true;
        }
        if (TypeBinding.equalsEquals(invocationType, this.declaringClass) && TypeBinding.equalsEquals(invocationType, receiverType)) {
            return true;
        }
        if (invocationType == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (TypeBinding.equalsEquals(invocationType, this.declaringClass)) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            TypeBinding receiverErasure = receiverType.erasure();
            ReferenceBinding declaringErasure = (ReferenceBinding)this.declaringClass.erasure();
            int depth = 0;
            do {
                if (currentType.findSuperTypeOriginatingFrom(declaringErasure) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (TypeBinding.equalsEquals(currentType, receiverErasure) || receiverErasure.findSuperTypeOriginatingFrom(currentType) != null) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(!TypeBinding.notEquals(receiverType, this.declaringClass) || scope.compilerOptions().complianceLevel <= 0x320000L && receiverType.isTypeVariable() && ((TypeVariableBinding)receiverType).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (TypeBinding.notEquals(invocationType, this.declaringClass)) {
                ReferenceBinding temp;
                ReferenceBinding outerInvocationType = invocationType;
                for (temp = outerInvocationType.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerInvocationType = temp;
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.declaringClass.erasure();
                for (temp = outerDeclaringClass.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerDeclaringClass = temp;
                }
                if (TypeBinding.notEquals(outerInvocationType, outerDeclaringClass)) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        if (invocationType.fPackage != declaringPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        TypeBinding originalDeclaringClass = this.declaringClass.original();
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        do {
            if (currentType.isCapture() ? TypeBinding.equalsEquals(originalDeclaringClass, currentType.erasure().original()) : TypeBinding.equalsEquals(originalDeclaringClass, currentType.original())) {
                return true;
            }
            PackageBinding currentPackage = currentType.fPackage;
            if (currentPackage == null || currentPackage == declaringPackage) continue;
            return false;
        } while ((currentType = currentType.superclass()) != null);
        return false;
    }

    public List collectMissingTypes(List missingTypes) {
        if ((this.tagBits & 0x80L) != 0L) {
            int i;
            missingTypes = this.returnType.collectMissingTypes(missingTypes);
            int max = this.parameters.length;
            for (i = 0; i < max; ++i) {
                missingTypes = this.parameters[i].collectMissingTypes(missingTypes);
            }
            max = this.thrownExceptions.length;
            for (i = 0; i < max; ++i) {
                missingTypes = this.thrownExceptions[i].collectMissingTypes(missingTypes);
            }
            for (TypeVariableBinding variable : this.typeVariables) {
                missingTypes = variable.superclass().collectMissingTypes(missingTypes);
                ReferenceBinding[] interfaces = variable.superInterfaces();
                int length = interfaces.length;
                for (int j = 0; j < length; ++j) {
                    missingTypes = interfaces[j].collectMissingTypes(missingTypes);
                }
            }
        }
        return missingTypes;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding method, LookupEnvironment env) {
        int length = this.typeVariables.length;
        TypeVariableBinding[] vars = method.typeVariables;
        if (length != vars.length) {
            return null;
        }
        ParameterizedGenericMethodBinding substitute = env.createParameterizedGenericMethod(method, this.typeVariables);
        for (int i = 0; i < length; ++i) {
            if (this.typeVariables[i].isInterchangeableWith(vars[i], substitute)) continue;
            return null;
        }
        return substitute;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        boolean addThrownExceptions;
        boolean isGeneric;
        char[] declaringKey = this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int selectorLength = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] sig = this.genericSignature();
        boolean bl = isGeneric = sig != null;
        if (!isGeneric) {
            sig = this.signature();
        }
        int signatureLength = sig.length;
        int thrownExceptionsLength = this.thrownExceptions.length;
        int thrownExceptionsSignatureLength = 0;
        Object thrownExceptionsSignatures = null;
        boolean bl2 = addThrownExceptions = thrownExceptionsLength > 0 && (!isGeneric || CharOperation.lastIndexOf('^', sig) < 0);
        if (addThrownExceptions) {
            thrownExceptionsSignatures = new char[thrownExceptionsLength][];
            for (int i = 0; i < thrownExceptionsLength; ++i) {
                if (this.thrownExceptions[i] == null) continue;
                thrownExceptionsSignatures[i] = this.thrownExceptions[i].signature();
                thrownExceptionsSignatureLength += thrownExceptionsSignatures[i].length + 1;
            }
        }
        char[] uniqueKey = new char[declaringLength + 1 + selectorLength + signatureLength + thrownExceptionsSignatureLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index = declaringLength;
        uniqueKey[index++] = 46;
        System.arraycopy(this.selector, 0, uniqueKey, index, selectorLength);
        System.arraycopy(sig, 0, uniqueKey, index += selectorLength, signatureLength);
        if (thrownExceptionsSignatureLength > 0) {
            index += signatureLength;
            for (int i = 0; i < thrownExceptionsLength; ++i) {
                char[] thrownExceptionSignature = thrownExceptionsSignatures[i];
                if (thrownExceptionSignature == null) continue;
                uniqueKey[index++] = 124;
                int length = thrownExceptionSignature.length;
                System.arraycopy(thrownExceptionSignature, 0, uniqueKey, index, length);
                index += length;
            }
        }
        return uniqueKey;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    protected void fillInDefaultNonNullness(AbstractMethodDeclaration sourceMethod) {
        if (this.parameterNonNullness == null) {
            this.parameterNonNullness = new Boolean[this.parameters.length];
        }
        boolean added = false;
        int length = this.parameterNonNullness.length;
        for (int i = 0; i < length; ++i) {
            if (this.parameters[i].isBaseType()) continue;
            if (this.parameterNonNullness[i] == null) {
                added = true;
                this.parameterNonNullness[i] = Boolean.TRUE;
                if (sourceMethod == null) continue;
                sourceMethod.arguments[i].binding.tagBits |= 0x100000000000000L;
                continue;
            }
            if (sourceMethod == null || !this.parameterNonNullness[i].booleanValue()) continue;
            sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, i);
        }
        if (added) {
            this.tagBits |= 0x400L;
        }
        if (this.returnType != null && !this.returnType.isBaseType() && (this.tagBits & 0x180000000000000L) == 0L) {
            this.tagBits |= 0x100000000000000L;
        } else if (sourceMethod != null && (this.tagBits & 0x100000000000000L) != 0L) {
            sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, -1);
        }
    }

    protected void fillInDefaultNonNullness18(AbstractMethodDeclaration sourceMethod, LookupEnvironment env) {
        if (this.hasNonNullDefaultFor(8, true)) {
            boolean added = false;
            int length = this.parameters.length;
            for (int i = 0; i < length; ++i) {
                TypeBinding parameter = this.parameters[i];
                if (parameter.isBaseType()) continue;
                long existing = parameter.tagBits & 0x180000000000000L;
                if (existing == 0L) {
                    added = true;
                    if (parameter.isBaseType()) continue;
                    this.parameters[i] = env.createAnnotatedType(parameter, new AnnotationBinding[]{env.getNonNullAnnotation()});
                    if (sourceMethod == null) continue;
                    sourceMethod.arguments[i].binding.type = this.parameters[i];
                    continue;
                }
                if (sourceMethod == null || (parameter.tagBits & 0x100000000000000L) == 0L) continue;
                sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, i);
            }
            if (added) {
                this.tagBits |= 0x400L;
            }
        }
        if (this.returnType != null && this.hasNonNullDefaultFor(16, true)) {
            if (!this.returnType.isBaseType() && (this.returnType.tagBits & 0x180000000000000L) == 0L) {
                this.returnType = env.createAnnotatedType(this.returnType, new AnnotationBinding[]{env.getNonNullAnnotation()});
            } else if (sourceMethod != null && (this.returnType.tagBits & 0x100000000000000L) != 0L) {
                sourceMethod.scope.problemReporter().nullAnnotationIsRedundant(sourceMethod, -1);
            }
        }
    }

    public MethodBinding findOriginalInheritedMethod(MethodBinding inheritedMethod) {
        MethodBinding inheritedOriginal = inheritedMethod.original();
        TypeBinding superType = this.declaringClass.findSuperTypeOriginatingFrom(inheritedOriginal.declaringClass);
        if (superType == null || !(superType instanceof ReferenceBinding)) {
            return null;
        }
        if (TypeBinding.notEquals(inheritedOriginal.declaringClass, superType)) {
            MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(inheritedOriginal.selector, inheritedOriginal.parameters.length);
            int l = superMethods.length;
            for (int m = 0; m < l; ++m) {
                if (superMethods[m].original() != inheritedOriginal) continue;
                return superMethods[m];
            }
        }
        return inheritedOriginal;
    }

    public char[] genericSignature() {
        int i;
        int i2;
        int length;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer sig = new StringBuffer(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            sig.append('<');
            length = this.typeVariables.length;
            for (i2 = 0; i2 < length; ++i2) {
                sig.append(this.typeVariables[i2].genericSignature());
            }
            sig.append('>');
        }
        sig.append('(');
        length = this.parameters.length;
        for (i2 = 0; i2 < length; ++i2) {
            sig.append(this.parameters[i2].genericTypeSignature());
        }
        sig.append(')');
        if (this.returnType != null) {
            sig.append(this.returnType.genericTypeSignature());
        }
        boolean needExceptionSignatures = false;
        length = this.thrownExceptions.length;
        for (i = 0; i < length; ++i) {
            if ((this.thrownExceptions[i].modifiers & 0x40000000) == 0) continue;
            needExceptionSignatures = true;
            break;
        }
        if (needExceptionSignatures) {
            for (i = 0; i < length; ++i) {
                sig.append('^');
                sig.append(this.thrownExceptions[i].genericTypeSignature());
            }
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0x1FFFF;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        MethodBinding originalMethod = this.original();
        return originalMethod.declaringClass.retrieveAnnotations(originalMethod);
    }

    @Override
    public long getAnnotationTagBits() {
        ClassScope scope;
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x200000000L) == 0L && originalMethod.declaringClass instanceof SourceTypeBinding && (scope = ((SourceTypeBinding)originalMethod.declaringClass).scope) != null) {
            TypeDeclaration typeDecl = scope.referenceContext;
            AbstractMethodDeclaration methodDecl = typeDecl.declarationOf(originalMethod);
            if (methodDecl != null) {
                ASTNode.resolveAnnotations((BlockScope)methodDecl.scope, methodDecl.annotations, originalMethod);
            }
            CompilerOptions options = scope.compilerOptions();
            if (options.isAnnotationBasedNullAnalysisEnabled) {
                SourceTypeBinding declaringSourceType;
                long nullDefaultBits;
                boolean isJdk18 = options.sourceLevel >= 0x340000L;
                long l = nullDefaultBits = isJdk18 ? (long)this.defaultNullness : this.tagBits & 0x600000000000000L;
                if (nullDefaultBits != 0L && this.declaringClass instanceof SourceTypeBinding && (declaringSourceType = (SourceTypeBinding)this.declaringClass).checkRedundantNullnessDefaultOne(methodDecl, methodDecl.annotations, nullDefaultBits, isJdk18)) {
                    declaringSourceType.checkRedundantNullnessDefaultRecurse(methodDecl, methodDecl.annotations, nullDefaultBits, isJdk18);
                }
            }
        }
        return originalMethod.tagBits;
    }

    public Object getDefaultValue() {
        AnnotationHolder holder;
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x800000000000000L) == 0L) {
            if (originalMethod.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration methodDeclaration;
                SourceTypeBinding sourceType = (SourceTypeBinding)originalMethod.declaringClass;
                if (sourceType.scope != null && (methodDeclaration = originalMethod.sourceMethod()) != null && methodDeclaration.isAnnotationMethod()) {
                    methodDeclaration.resolve(sourceType.scope);
                }
            }
            originalMethod.tagBits |= 0x800000000000000L;
        }
        return (holder = originalMethod.declaringClass.retrieveAnnotationHolder(originalMethod, true)) == null ? null : holder.getDefaultValue();
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        AnnotationBinding[][] allParameterAnnotations;
        int length = this.parameters.length;
        if (length == 0) {
            return null;
        }
        MethodBinding originalMethod = this.original();
        AnnotationHolder holder = originalMethod.declaringClass.retrieveAnnotationHolder(originalMethod, true);
        AnnotationBinding[][] annotationBindingArray = allParameterAnnotations = holder == null ? (AnnotationBinding[][])null : holder.getParameterAnnotations();
        if (allParameterAnnotations == null && (this.tagBits & 0x400L) != 0L) {
            allParameterAnnotations = new AnnotationBinding[length][];
            if (this.declaringClass instanceof SourceTypeBinding) {
                SourceTypeBinding sourceType = (SourceTypeBinding)this.declaringClass;
                if (sourceType.scope != null) {
                    AbstractMethodDeclaration methodDecl = sourceType.scope.referenceType().declarationOf(this);
                    for (int i = 0; i < length; ++i) {
                        Argument argument = methodDecl.arguments[i];
                        if (argument.annotations != null) {
                            ASTNode.resolveAnnotations((BlockScope)methodDecl.scope, argument.annotations, argument.binding);
                            allParameterAnnotations[i] = argument.binding.getAnnotations();
                            continue;
                        }
                        allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    allParameterAnnotations[i] = Binding.NO_ANNOTATIONS;
                }
            }
            this.setParameterAnnotations(allParameterAnnotations);
        }
        return allParameterAnnotations;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        int i = this.typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(this.typeVariables[i].sourceName, variableName)) continue;
            return this.typeVariables[i];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding paramType;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (paramType = this.parameters[0]).dimensions() == 1 && paramType.leafComponentType().id == 11;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if ((this.modifiers & 2) != 0) {
            return true;
        }
        return this.declaringClass != null && this.declaringClass.isOrEnclosedByPrivateType();
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPolymorphic() {
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public MethodBinding original() {
        return this;
    }

    public MethodBinding shallowOriginal() {
        return this.original();
    }

    public MethodBinding genericMethod() {
        return this;
    }

    @Override
    public char[] readableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int length = this.parameters.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations) {
        this.declaringClass.storeAnnotations(this, annotations);
    }

    public void setAnnotations(AnnotationBinding[] annotations, AnnotationBinding[][] parameterAnnotations, Object defaultValue, LookupEnvironment optionalEnv) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotations, parameterAnnotations, defaultValue, optionalEnv));
    }

    public void setDefaultValue(Object defaultValue) {
        MethodBinding originalMethod = this.original();
        originalMethod.tagBits |= 0x800000000000000L;
        AnnotationHolder holder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (holder == null) {
            this.setAnnotations(null, null, defaultValue, null);
        } else {
            this.setAnnotations(holder.getAnnotations(), holder.getParameterAnnotations(), defaultValue, null);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] parameterAnnotations) {
        AnnotationHolder holder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (holder == null) {
            this.setAnnotations(null, parameterAnnotations, null, null);
        } else {
            this.setAnnotations(holder.getAnnotations(), parameterAnnotations, holder.getDefaultValue(), null);
        }
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int length = this.parameters.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
            }
        }
        buffer.append(')');
        int nameLength = buffer.length();
        char[] shortReadableName = new char[nameLength];
        buffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    public final char[] signature() {
        boolean needSynthetics;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        if (isConstructor && this.declaringClass.isEnum()) {
            buffer.append(ConstantPool.JavaLangStringSignature);
            buffer.append(TypeBinding.INT.signature());
        }
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType();
        if (needSynthetics) {
            ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (syntheticArgumentTypes != null) {
                int count = syntheticArgumentTypes.length;
                for (int i = 0; i < count; ++i) {
                    buffer.append(syntheticArgumentTypes[i].signature());
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (targetParameters != Binding.NO_PARAMETERS) {
            for (int i = 0; i < targetParameters.length; ++i) {
                buffer.append(targetParameters[i].signature());
            }
        }
        if (needSynthetics) {
            int i;
            SyntheticArgumentBinding[] syntheticOuterArguments = this.declaringClass.syntheticOuterLocalVariables();
            int count = syntheticOuterArguments == null ? 0 : syntheticOuterArguments.length;
            for (i = 0; i < count; ++i) {
                buffer.append(syntheticOuterArguments[i].type.signature());
            }
            int extraLength = this.parameters.length;
            for (i = targetParameters.length; i < extraLength; ++i) {
                buffer.append(this.parameters[i].signature());
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public final char[] signature(ClassFile classFile) {
        boolean needSynthetics;
        if (this.signature != null) {
            if ((this.tagBits & 0x800L) != 0L) {
                boolean needSynthetics2;
                boolean isConstructor = this.isConstructor();
                TypeBinding[] targetParameters = this.parameters;
                boolean bl = needSynthetics2 = isConstructor && this.declaringClass.isNestedType();
                if (needSynthetics2) {
                    ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
                    if (syntheticArgumentTypes != null) {
                        for (ReferenceBinding syntheticArgumentType : syntheticArgumentTypes) {
                            if ((syntheticArgumentType.tagBits & 0x800L) == 0L) continue;
                            Util.recordNestedType(classFile, syntheticArgumentType);
                        }
                    }
                    if (this instanceof SyntheticMethodBinding) {
                        targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
                    }
                }
                if (targetParameters != Binding.NO_PARAMETERS) {
                    for (TypeBinding targetParameter : targetParameters) {
                        TypeBinding leafTargetParameterType = targetParameter.leafComponentType();
                        if ((leafTargetParameterType.tagBits & 0x800L) == 0L) continue;
                        Util.recordNestedType(classFile, leafTargetParameterType);
                    }
                }
                if (needSynthetics2) {
                    int extraLength = this.parameters.length;
                    for (int i = targetParameters.length; i < extraLength; ++i) {
                        TypeBinding parameter = this.parameters[i];
                        TypeBinding leafParameterType = parameter.leafComponentType();
                        if ((leafParameterType.tagBits & 0x800L) == 0L) continue;
                        Util.recordNestedType(classFile, leafParameterType);
                    }
                }
                if (this.returnType != null) {
                    TypeBinding ret = this.returnType.leafComponentType();
                    if ((ret.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, ret);
                    }
                }
            }
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer((this.parameters.length + 1) * 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        if (isConstructor && this.declaringClass.isEnum()) {
            buffer.append(ConstantPool.JavaLangStringSignature);
            buffer.append(TypeBinding.INT.signature());
        }
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType();
        if (needSynthetics) {
            ReferenceBinding[] syntheticArgumentTypes = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (syntheticArgumentTypes != null) {
                for (ReferenceBinding syntheticArgumentType : syntheticArgumentTypes) {
                    if ((syntheticArgumentType.tagBits & 0x800L) != 0L) {
                        this.tagBits |= 0x800L;
                        Util.recordNestedType(classFile, syntheticArgumentType);
                    }
                    buffer.append(syntheticArgumentType.signature());
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                targetParameters = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (targetParameters != Binding.NO_PARAMETERS) {
            for (TypeBinding targetParameter : targetParameters) {
                TypeBinding leafTargetParameterType = targetParameter.leafComponentType();
                if ((leafTargetParameterType.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, leafTargetParameterType);
                }
                buffer.append(targetParameter.signature());
            }
        }
        if (needSynthetics) {
            int i;
            SyntheticArgumentBinding[] syntheticOuterArguments = this.declaringClass.syntheticOuterLocalVariables();
            int count = syntheticOuterArguments == null ? 0 : syntheticOuterArguments.length;
            for (i = 0; i < count; ++i) {
                buffer.append(syntheticOuterArguments[i].type.signature());
            }
            int extraLength = this.parameters.length;
            for (i = targetParameters.length; i < extraLength; ++i) {
                TypeBinding parameter = this.parameters[i];
                TypeBinding leafParameterType = parameter.leafComponentType();
                if ((leafParameterType.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, leafParameterType);
                }
                buffer.append(parameter.signature());
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            TypeBinding ret = this.returnType.leafComponentType();
            if ((ret.tagBits & 0x800L) != 0L) {
                this.tagBits |= 0x800L;
                Util.recordNestedType(classFile, ret);
            }
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return method.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        AbstractMethodDeclaration[] methods;
        SourceTypeBinding sourceType;
        if (this.isSynthetic()) {
            return null;
        }
        try {
            sourceType = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException e) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods = sourceType.scope != null ? sourceType.scope.referenceContext.methods : null;
        if (methods != null) {
            int i = methods.length;
            while (--i >= 0) {
                if (this != methods[i].binding) continue;
                return methods[i];
            }
        }
        return null;
    }

    public LambdaExpression sourceLambda() {
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration method = this.sourceMethod();
        if (method == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return method.sourceStart;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public String toString() {
        int i;
        int length;
        StringBuffer output = new StringBuffer(10);
        if ((this.modifiers & 0x2000000) != 0) {
            output.append("[unresolved] ");
        }
        ASTNode.printModifiers(this.modifiers, output);
        output.append(this.returnType != null ? this.returnType.debugName() : "<no type>");
        output.append(" ");
        output.append(this.selector != null ? new String(this.selector) : "<no selector>");
        output.append("(");
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                length = this.parameters.length;
                for (i = 0; i < length; ++i) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(this.parameters[i] != null ? this.parameters[i].debugName() : "<no argument type>");
                }
            }
        } else {
            output.append("<no argument types>");
        }
        output.append(") ");
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                output.append("throws ");
                length = this.thrownExceptions.length;
                for (i = 0; i < length; ++i) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    output.append(this.thrownExceptions[i] != null ? this.thrownExceptions[i].debugName() : "<no exception type>");
                }
            }
        } else {
            output.append("<no exception types>");
        }
        return output.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }

    public boolean hasNonNullDefaultFor(int location, boolean useTypeAnnotations) {
        if (useTypeAnnotations) {
            if (this.defaultNullness != 0) {
                return (this.defaultNullness & location) != 0;
            }
        } else {
            if ((this.tagBits & 0x200000000000000L) != 0L) {
                return true;
            }
            if ((this.tagBits & 0x400000000000000L) != 0L) {
                return false;
            }
        }
        return this.declaringClass.hasNonNullDefaultFor(location, useTypeAnnotations);
    }

    public boolean redeclaresPublicObjectMethod(Scope scope) {
        int length;
        ReferenceBinding javaLangObject = scope.getJavaLangObject();
        MethodBinding[] methods = javaLangObject.getMethods(this.selector);
        int n = length = methods == null ? 0 : methods.length;
        for (int i = 0; i < length; ++i) {
            MethodBinding method = methods[i];
            if (!method.isPublic() || method.isStatic() || method.parameters.length != this.parameters.length || !MethodVerifier.doesMethodOverride(this, method, scope.environment())) continue;
            return true;
        }
        return false;
    }

    public boolean isVoidMethod() {
        return this.returnType == TypeBinding.VOID;
    }
}

