<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1480916 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htaccess.xml.meta">
<parentdocument href="./">Recettes / Tutoriels</parentdocument>

<title>Tutoriel du serveur HTTP Apache : fichiers .htaccess</title>

<summary>
<p>Les fichiers <code>.htaccess</code> fournissent une m&eacute;thode pour
modifier la configuration du serveur au niveau de chaque r&eacute;pertoire.</p>
</summary>

<section id="related"><title>Fichiers .htaccess</title>
    
    <related>
        <modulelist>
            <module>core</module>
            <module>mod_authn_file</module>
            <module>mod_authz_groupfile</module>
            <module>mod_cgi</module>
            <module>mod_include</module>
            <module>mod_mime</module>
        </modulelist>

        <directivelist>
            <directive module="core">AccessFileName</directive>
            <directive module="core">AllowOverride</directive>
            <directive module="core">Options</directive>
            <directive module="mod_mime">AddHandler</directive>
            <directive module="core">SetHandler</directive>
            <directive module="core">AuthType</directive>
            <directive module="core">AuthName</directive>
            <directive module="mod_authn_file">AuthUserFile</directive>
            <directive module="mod_authz_groupfile">AuthGroupFile</directive>
            <directive module="core">Require</directive>
        </directivelist>

    </related>
    <note>Les fichiers <code>.htaccess</code> ne doivent &ecirc;tre utilis&eacute;s
    que si vous n'avez pas acc&egrave;s au fichier de configuration du serveur
    principal. L'utilisation des fichiers <code>.htaccess</code>
    ralentit le fonctionnement de votre serveur HTTP Apache. Il est toujours
    pr&eacute;f&eacute;rable de d&eacute;finir les directives que vous pouvez inclure dans un
    fichier <code>.htaccess</code> dans une section <directive
    module="core">Directory</directive>, car elles produiront le
    m&ecirc;me effet avec de meilleures performances.</note>
</section>

<section id="what">
<title>Que sont ce fichiers, comment les utiliser ?</title>

    <p>Les fichiers <code>.htaccess</code> (ou "fichiers de
    configuration distribu&eacute;s") fournissent une m&eacute;thode pour modifier la
    configuration du serveur au niveau d'un r&eacute;pertoire. Un fichier,
    contenant une ou plusieurs directives de configuration, est plac&eacute;
    dans un r&eacute;pertoire de documents particulier, et ses directives
    s'appliquent &agrave; ce r&eacute;pertoire et &agrave; tous ses sous-r&eacute;pertoires.</p>

    <note><title>Note :</title>
      <p>Si vous voulez donner un autre nom &agrave; votre fichier
      <code>.htaccess</code>, vous pouvez le faire en utilisant la
      directive <directive module="core">AccessFileName</directive>. Par
      exemple, si vous pr&eacute;f&eacute;rez nommer votre fichier
      <code>.config</code>, vous pouvez mettre ceci dans le fichier de
      configuration de votre serveur :</p>

      <highlight language="config">
        AccessFileName .config
      </highlight>
    </note>

    <p>En g&eacute;n&eacute;ral, les fichiers <code>.htaccess</code> utilisent la m&ecirc;me
    syntaxe que les <a href="../configuring.html#syntax">fichiers de
    configuration principaux</a>. Ce que vous pouvez mettre dans ces
    fichier est d&eacute;termin&eacute; par la directive <directive
    module="core">AllowOverride</directive>. Cette directive sp&eacute;cifie,
    sous forme de cat&eacute;gories, quelles directives seront trait&eacute;es si
    elles se trouvent dans un fichier <code>.htaccess</code>. Si une
    directive est permise dans un fichier <code>.htaccess</code> file,
    la documentation de cette directive contiendra une section Override,
    sp&eacute;cifiant quelle valeur doit prendre <directive
    module="core">AllowOverride</directive> pour que cette directive
    soit trait&eacute;e.</p>

    <p>Par exemple, si vous regardez la documentation de la directive
    <directive module="core">AddDefaultCharset</directive>, vous verrez
    que cette derni&egrave;re est permise dans les fichiers
    <code>.htaccess</code> (Voir la ligne de contexte dans le r&eacute;sum&eacute; de
    la directive). La ligne <a
    href="../mod/directive-dict.html#Context">Override</a> indique
    <code>FileInfo</code>. Vous devez donc avoir au moins
    <code>AllowOverride FileInfo</code> pour que cette directive soit
    trait&eacute;e dans les fichiers <code>.htaccess</code>.</p>

    <example><title>Exemple :</title>
      <table>
        <tr>
          <td><a
          href="../mod/directive-dict.html#Context">Contexte :</a></td>
          <td>configuration du serveur, serveur virtuel, directory, .htaccess</td>
        </tr>

        <tr>
          <td><a
          href="../mod/directive-dict.html#Override">Override:</a></td>
          <td>FileInfo</td>
        </tr>
      </table>
    </example>

    <p>Si vous n'&ecirc;tes pas s&ucirc;r qu'une directive particuli&egrave;re soit permise
    dans un fichier <code>.htaccess</code>, lisez la documentation de
    cette directive, et consultez la ligne de contexte pour
    ".htaccess".</p>
    </section>

    <section id="when"><title>Quand doit-on (ne doit-on pas) utiliser
    les fichiers .htaccess ?</title>

    <p>En principe, vous ne devriez utiliser les fichiers
    <code>.htaccess</code> que lorsque vous n'avez pas acc&egrave;s au fichier de
    configuration du serveur principal. Par exemple, la fausse
    id&eacute;e
    selon laquelle l'authentification de l'utilisateur devrait toujours
    &ecirc;tre faite dans les fichiers <code>.htaccess</code> est tr&egrave;s
    r&eacute;pandue. Il est aussi souvent avanc&eacute;, ces derni&egrave;res
    ann&eacute;es, que les directives de <module>mod_rewrite</module> doivent
    &ecirc;tre d&eacute;finies dans les fichiers <code>.htaccess</code>. Ceci est
    tout simplement faux. Vous pouvez configurer
    l'authentification des utilisateurs au niveau de la configuration du
    serveur principal, et c'est en fait cette m&eacute;thode qui doit &ecirc;tre
    privil&eacute;gi&eacute;e. De m&ecirc;me, les directives de
    <code>mod_rewrite</code> fonctionneront mieux, &agrave; de nombreux &eacute;gards,
    dans le contexte du serveur principal.</p>

    <p>Les fichiers <code>.htaccess</code> ne devraient &ecirc;tre utilis&eacute;s
    que dans le cas o&ugrave; les fournisseurs de contenu ont besoin de
    modifier la configuration du serveur au niveau d'un r&eacute;pertoire, mais
    ne poss&egrave;dent pas l'acc&egrave;s root sur le syst&egrave;me du serveur. Si
    l'administrateur du serveur ne souhaite pas effectuer des
    modifications de configuration incessantes, il peut &ecirc;tre int&eacute;ressant
    de permettre aux utilisateurs isol&eacute;s d'effectuer eux-m&ecirc;mes ces
    modifications par le biais de fichiers <code>.htaccess</code>. Ceci
    est particuli&egrave;rement vrai dans le cas o&ugrave; le fournisseur d'acc&egrave;s &agrave;
    Internet h&eacute;berge de nombreux sites d'utilisateurs sur un seul
    serveur, et souhaite que ces utilisateurs puissent modifier
    eux-m&ecirc;mes leurs configurations.</p>

    <p>Cependant et d'une mani&egrave;re g&eacute;n&eacute;rale, il vaut mieux &eacute;viter
    d'utiliser les fichiers <code>.htaccess</code>. Tout &eacute;l&eacute;ment de
    configuration que vous pourriez vouloir mettre dans un fichier
    <code>.htaccess</code>, peut aussi &ecirc;tre mis, et avec la m&ecirc;me
    efficacit&eacute;, dans une section <directive module="core"
    type="section">Directory</directive> du fichier de configuration de
    votre serveur principal.</p>

    <p>Il y a deux raisons principales d'&eacute;viter l'utilisation des
    fichiers <code>.htaccess</code>.</p>

    <p>La premi&egrave;re est li&eacute;e aux performances. Lorsque la directive
    <directive module="core">AllowOverride</directive> est d&eacute;finie de
    fa&ccedil;on &agrave; autoriser l'utilisation des fichiers <code>.htaccess</code>,
    httpd va rechercher leur pr&eacute;sence dans chaque r&eacute;pertoire. Ainsi,
    permettre l'utilisation des fichiers <code>.htaccess</code> est d&eacute;j&agrave;
    en soi une cause de d&eacute;gradation des performances, que vous utilisiez
    effectivement ces fichiers ou non ! De plus, le fichier
    <code>.htaccess</code> est charg&eacute; en m&eacute;moire chaque fois qu'un
    document fait l'objet d'une requ&ecirc;te.</p>

    <p>Notez aussi que httpd doit rechercher les fichiers
    <code>.htaccess</code> dans tous les r&eacute;pertoires de niveau
    sup&eacute;rieur, afin de rassembler toutes les directives qui s'appliquent
    au r&eacute;pertoire courant (Voir la section <a href="#how">comment sont
    appliqu&eacute;es les directives</a>). Ainsi, si un fichier fait l'objet
    d'une requ&ecirc;te &agrave; partir d'un r&eacute;pertoire
    <code>/www/htdocs/exemple</code>, httpd doit rechercher les
    fichiers suivants :</p>

    <example>
      /.htaccess<br />
      /www/.htaccess<br />
      /www/htdocs/.htaccess<br />
      /www/htdocs/exemple/.htaccess
    </example>

    <p>En cons&eacute;quence, chaque acc&egrave;s &agrave; un fichier de ce r&eacute;pertoire
    n&eacute;cessite 4 acc&egrave;s au syst&egrave;me de fichiers suppl&eacute;mentaires pour
    rechercher des fichiers <code>.htaccess</code>, m&ecirc;me si
    aucun de ces fichiers n'est pr&eacute;sent. Notez que cet exemple ne peut
    se produire que si les fichiers <code>.htaccess</code> ont &eacute;t&eacute;
    autoris&eacute;s pour le r&eacute;pertoire <code>/</code>, ce qui est rarement le
    cas.</p>

    <p>La seconde raison d'&eacute;viter l'utilisation des fichiers
    <code>.htaccess</code> est li&eacute;e &agrave; la s&eacute;curit&eacute;. Si vous permettez aux
    utilisateurs de modifier la configuration du serveur, il peut en
    r&eacute;sulter des cons&eacute;quences sur lesquelles vous n'aurez aucun
    contr&ocirc;le. R&eacute;fl&eacute;chissez bien avant de donner ce privil&egrave;ge &agrave; vos
    utilisateurs. Notez aussi que ne pas donner aux utilisateurs les
    privil&egrave;ges dont ils ont besoin va entra&icirc;ner une augmentation des
    demandes de support technique. Assurez-vous d'avoir inform&eacute;
    clairement vos utilisateurs du niveau de privil&egrave;ges que vous leur
    avez attribu&eacute;. Indiquer exactement comment vous avez d&eacute;fini la
    directive <directive module="core">AllowOverride</directive> et
    diriger les utilisateurs vers la documentation correspondante vous
    &eacute;vitera bien des confusions ult&eacute;rieures.</p>

    <p>Notez que mettre un fichier <code>.htaccess</code> contenant une
    directive dans un r&eacute;pertoire <code>/www/htdocs/exemple</code>
    revient exactement au m&ecirc;me que mettre la m&ecirc;me directive dans une
    section Directory <code>&lt;Directory /www/htdocs/exemple&gt;</code>
    du fichier de configuration de votre serveur principal :</p>

    <p>Fichier <code>.htaccess</code> dans
    <code>/www/htdocs/exemple</code> :</p>

    <example><title>Contenu du fichier .htaccess dans
    <code>/www/htdocs/exemple</code></title>
    	<highlight language="config">AddType text/example .exm</highlight>
    </example>

    <example><title>Section de votre fichier
    <code>httpd.conf</code></title>
      <highlight language="config">
&lt;Directory /www/htdocs/example&gt;
    AddType text/example .exm
&lt;/Directory&gt;
    </highlight>
    </example>

    <p>Cependant, la perte de performances sera moindre si vous
    d&eacute;finissez cette directive dans la configuration de
    votre serveur principal, car cette derni&egrave;re ne sera charg&eacute;e qu'une
    seule fois au moment du d&eacute;marrage du serveur, alors qu'elle le sera
    &agrave; chaque acc&egrave;s dans le cas d'un fichier <code>.htaccess</code>.</p>

    <p>L'utilisation des fichiers <code>.htaccess</code> peut &ecirc;tre
    enti&egrave;rement d&eacute;sactiv&eacute;e en d&eacute;finissant la directive <directive
    module="core">AllowOverride</directive> &agrave; <code>none</code> :</p>

    <highlight language="config">AllowOverride None</highlight>
</section>

<section id="how"><title>Comment sont appliqu&eacute;es les directives ?</title>

    <p>Les directives de configuration situ&eacute;es dans un fichier
    <code>.htaccess</code> s'appliquent au r&eacute;pertoire dans lequel ce
    fichier <code>.htaccess</code> se trouve, ainsi qu'&agrave; tous ses
    sous-r&eacute;pertoires. Cependant, il est important de garder &agrave; l'esprit
    qu'il peut y avoir des fichiers <code>.htaccess</code> dans les
    r&eacute;pertoires de niveau sup&eacute;rieur. Les directives sont appliqu&eacute;es
    selon l'ordre dans lequel elles sont rencontr&eacute;es. Ainsi, les
    directives d'un fichier <code>.htaccess</code> situ&eacute; dans un
    r&eacute;pertoire particulier peuvent &eacute;craser les directives se trouvant
    dans des fichiers <code>.htaccess</code> situ&eacute;s &agrave; un niveau
    sup&eacute;rieur dans l'arborescence des r&eacute;pertoires. Et ces derni&egrave;res
    peuvent elles-m&ecirc;mes avoir &eacute;cras&eacute; des directives d'un fichier
    <code>.htaccess</code> situ&eacute; &agrave; un niveau encore plus haut, ou dans
    le fichier de configuration du serveur principal.</p>

    <p>Exemple :</p>

    <p>Dans le r&eacute;pertoire <code>/www/htdocs/exemple1</code> se trouve un
    fichier <code>.htaccess</code> contenant ce qui suit :</p>

    <highlight language="config">Options +ExecCGI</highlight>

    <p>Note : "<code>AllowOverride Options</code>" doit &ecirc;tre pr&eacute;sent
    pour permettre l'utilisation de la directive "<directive
    module="core">Options</directive>"  dans les fichiers
    <code>.htaccess</code>.</p>

    <p>Dans le r&eacute;pertoire <code>/www/htdocs/exemple1/exemple2</code> se
    trouve un fichier <code>.htaccess</code> contenant ce qui suit
    :</p>

    <highlight language="config">Options Includes</highlight>

    <p>Ainsi, &agrave; cause de ce second fichier <code>.htaccess</code> du
    r&eacute;pertoire <code>/www/htdocs/exemple1/exemple2</code>, l'ex&eacute;cution
    des CGI est interdite, car la derni&egrave;re d&eacute;finition d'options
    <code>Options Includes</code> &eacute;crase toute autre d&eacute;finition
    d'options d'un fichier <code>.htaccess</code> situ&eacute; dans un
    r&eacute;pertoire de niveau sup&eacute;rieur.</p>

    <section id="merge"><title>Interactions entre les fichiers .htaccess
    et les fichiers de configuration du serveur principal</title>

    <p>Comme indiqu&eacute; dans la documentation sur les <a
    href="../sections.html">Sections de configuration</a>, les fichiers
    <code>.htaccess</code> peuvent &eacute;craser les directives des sections
    <directive type="section" module="core">Directory</directive> pour
    le r&eacute;pertoire correspondant, mais peuvent eux-m&ecirc;mes &ecirc;tre &eacute;cras&eacute;s
    par d'autres types de sections des fichiers de la
    configuration principale. Cette possibilit&eacute; peut s'av&eacute;rer utile pour
    forcer certaines configurations, m&ecirc;me en cas de pr&eacute;sence de l'option
    lib&eacute;rale <directive module="core">AllowOverride</directive>. Par
    exemple, pour interdire l'ex&eacute;cution de scripts en autorisant la
    d&eacute;finition de toute autre option dans les fichiers
    <code>.htaccess</code>, vous pouvez utiliser :</p>

    <highlight language="config">
&lt;Directory /www/htdocs&gt;
    AllowOverride All
&lt;/Directory&gt;

&lt;Location /&gt;
    Options +IncludesNoExec -ExecCGI<br />
&lt;/Location&gt;
    </highlight>

    <note>Dans cet exemple, on consid&egrave;re que le chemin d&eacute;fini par la
    directive <directive module="core">DocumentRoot</directive> est
    <code>/www/htdocs</code>.</note>
</section>

</section>

<section id="auth"><title>Exemple d'authentification</title>

    <p>Si vous acc&eacute;dez directement &agrave; ce point du document pour apprendre
    &agrave; effectuer une authentification, il est important de noter ceci. Il
    existe une fausse id&eacute;e selon laquelle il serait n&eacute;cessaire
    d'utiliser les fichiers <code>.htaccess</code> pour impl&eacute;menter
    l'authentification par mot de passe. Ceci est tout simplement faux.
    Pour y parvenir, il est pr&eacute;f&eacute;rable de mettre les directives
    d'authentification dans une section <directive module="core"
    type="section">Directory</directive> du fichier de configuration de
    votre serveur principal, et les fichiers <code>.htaccess</code> ne
    devraient &ecirc;tre utilis&eacute;s que dans le cas o&ugrave; vous n'avez pas acc&egrave;s au
    fichier de configuration du serveur principal. Voir <a
    href="#when">ci-dessus</a> pour savoir dans quels cas vous devez ou
    ne devez pas utiliser les fichiers <code>.htaccess</code>.</p>

    <p>Ceci &eacute;tant dit, si vous pensez que vous devez quand-m&ecirc;me utiliser
    un fichier <code>.htaccess</code>, vous pouvez utiliser la
    configuration suivante :</p>

    <p>Contenu du fichier <code>.htaccess</code> :</p>

    <highlight language="config">
AuthType Basic
AuthName "Password Required"
AuthUserFile /www/passwords/password.file
AuthGroupFile /www/passwords/group.file
Require Group admins
    </highlight>

    <p>Notez que <code>AllowOverride AuthConfig</code> doit &ecirc;tre pr&eacute;sent
    pour que ces directives produisent leur effet.</p>

    <p>Vous pouvez vous r&eacute;f&eacute;rer au <a href="auth.html">tutoriel sur
    l'authentification</a> pour une description plus d&eacute;taill&eacute;e de
    l'authentification et de l'autorisation.</p>
</section>

<section id="ssi"><title>Exemple d'Inclusion C&ocirc;t&eacute; Serveur (Server Side
Includes - SSI)</title>

    <p>Les fichiers <code>.htaccess</code> sont aussi couramment
    utilis&eacute;s pour activer les SSI pour un r&eacute;pertoire particulier. Pour y
    parvenir, on utilise les directives de configuration suivantes,
    plac&eacute;es dans un fichier <code>.htaccess</code> enregistr&eacute; dans le
    r&eacute;pertoire consid&eacute;r&eacute; :</p>

    <highlight language="config">
Options +Includes
AddType text/html shtml
AddHandler server-parsed shtml
    </highlight>

    <p>Notez que <code>AllowOverride Options</code> et <code>AllowOverride
    FileInfo</code> doivent &ecirc;tre tous les deux pr&eacute;sents pour que ces
    directives puissent produire leur effet.</p>

    <p>Vous pouvez vous r&eacute;f&eacute;rer au <a href="ssi.html">tutoriel SSI</a>
    pour une description plus d&eacute;taill&eacute;e des SSI.</p>
</section>

<section id="cgi"><title>Exemple de CGI</title>

    <p>En fin de compte, vous avez d&eacute;cid&eacute; d'utiliser un fichier
    <code>.htaccess</code> pour permettre l'ex&eacute;cution des programmes CGI
    dans un r&eacute;pertoire particulier. Pour y parvenir, vous pouvez
    utiliser la configuration suivante :</p>

    <highlight language="config">
Options +ExecCGI
AddHandler cgi-script cgi pl
    </highlight>

    <p>Alternativement, si vous souhaitez que tous les fichiers d'un
    r&eacute;pertoire donn&eacute; soient consid&eacute;r&eacute;s comme des programmes CGI, vous
    pouvez utiliser la configuration suivante :</p>

    <highlight language="config">
Options +ExecCGI
SetHandler cgi-script
    </highlight>

    <p>Notez que <code>AllowOverride Options</code> et <code>AllowOverride
    FileInfo</code> doivent &ecirc;tre tous les deux pr&eacute;sents pour que ces
    directives puissent produire leur effet.</p>

    <p>Vous pouvez vous r&eacute;f&eacute;rer au <a href="cgi.html">tutoriel CGI</a>
    pour une description plus d&eacute;taill&eacute;e de la configuration et de la
    proprammation CGI.</p>

</section>

<section id="troubleshoot"><title>R&eacute;solution des probl&egrave;mes</title>

    <p>De nombreuses raisons peuvent &ecirc;tre &agrave; l'origine du fait que
    les directives que vous avez mises dans un fichier
    <code>.htaccess</code> ne produisent pas l'effet d&eacute;sir&eacute;.</p>

    <p>Le plus souvent, le probl&egrave;me vient du fait que la d&eacute;finition de
    la directive <directive module="core">AllowOverride</directive>
    ne permet pas l'activation des directives de votre fichier
    <code>.htaccess</code>. V&eacute;rifiez si une directive
    <code>AllowOverride None</code> n'affecte pas le r&eacute;pertoire o&ugrave; se
    trouve votre fichier. Un bon test consiste &agrave; mettre des directives
    dont la syntaxe est erron&eacute;e dans votre ficher <code>.htaccess</code>
    et de recharger la page. Si aucune erreur n'est g&eacute;n&eacute;r&eacute;e par le
    serveur, il est pratiquement certain qu'une directive
    <code>AllowOverride None</code> affecte votre r&eacute;pertoire.</p>

    <p>Par contre, si vous obtenez des erreurs de serveur lorsque vous
    tentez d'acc&eacute;der &agrave; des documents, consultez votre journal des
    erreurs de httpd. Il vous indiquera probablement que la directive
    utilis&eacute;e dans votre fichier <code>.htaccess</code> n'est pas
    permise.</p>

<example>
	[Fri Sep 17 18:43:16 2010] [alert] [client 192.168.200.51] /var/www/html/.htaccess: DirectoryIndex not allowed here
</example>
	<p>Cela signifie soit que vous utilisez une directive qui n'est
	jamais permise dans les fichiers <code>.htaccess</code>, soit
	que vous n'avez tout simplement pas d&eacute;fini la directive
	<directive module="core">AllowOverride</directive> &agrave; un niveau
	suffisant pour la directive que vous utilisez. Consultez la
	documentation de cette directive pour d&eacute;terminer quel cas
	s'applique.</p>

	<p>Le journal des erreurs peut aussi vous signaler une erreur de
	syntaxe dans l'usage de la directive elle-m&ecirc;me.</p>

    <example>
    [Sat Aug 09 16:22:34 2008] [alert] [client 192.168.200.51] /var/www/html/.htaccess: RewriteCond: bad flag delimiters
    </example>

	<p>Dans ce cas, le message d'erreur sera sp&eacute;cifique &agrave; l'erreur
	de syntaxe que vous avez commise.</p>
</section>

</manualpage>
