<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1387659 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authn_dbd.xml.meta">

<name>mod_authn_dbd</name>
<description>Authentification utilisateur &agrave; l'aide d'une base de donn&eacute;es
SQL</description>
<status>Extension</status>
<sourcefile>mod_authn_dbd.c</sourcefile>
<identifier>authn_dbd_module</identifier>
<compatibility>Disponible depuis la version 2.1 d'Apache</compatibility>

<summary>
    <p>Ce module permet aux frontaux d'authentification comme
    <module>mod_auth_digest</module> et <module>mod_auth_basic</module>
    d'authentifier les utilisateurs en les recherchant dans une base de
    donn&eacute;es SQL. <module>mod_authn_file</module>, par exemple, fournit
    une fonctionnalit&eacute; similaire.</p>
    <p>Ce module s'appuie sur <module>mod_dbd</module> pour sp&eacute;cifier le
    pilote de la base de donn&eacute;es sous-jacente et les param&egrave;tres de
    connexion, mais aussi pour g&eacute;rer les connexions &agrave; la base de
    donn&eacute;es.</p>

    <p>Si l'on utilise <module>mod_auth_basic</module> ou
    <module>mod_auth_digest</module>, on peut invoquer ce module en
    affectant la valeur <code>dbd</code> &agrave; la directive <directive
    module="mod_auth_basic">AuthBasicProvider</directive> ou <directive
    module="mod_auth_digest">AuthDigestProvider</directive>.</p>
</summary>

<seealso><directive module="mod_authn_core">AuthName</directive></seealso>
<seealso><directive module="mod_authn_core">AuthType</directive></seealso>
<seealso>
  <directive module="mod_auth_basic">AuthBasicProvider</directive>
</seealso>
<seealso>
  <directive module="mod_auth_digest">AuthDigestProvider</directive>
</seealso>
<seealso><directive module="mod_dbd">DBDriver</directive></seealso>
<seealso><directive module="mod_dbd">DBDParams</directive></seealso>
<seealso><a href="../misc/password_encryptions.html">Formats de mots de
passe</a></seealso>

<section id="socache">
<title>Performances et mise en cache</title>
<p>Certains utilisateurs de l'authentification DBD sous HTTPD 2.2/2.4 ont
signal&eacute; une charge probl&eacute;matique au niveau de la base de donn&eacute;es. Cela
se produit en g&eacute;n&eacute;ral lorsqu'une page HTML contient des centaines d'objets
(comme des images, des scripts, etc...), chacun d'entre eux n&eacute;cessitant
une authentification. Les utilisateurs qui rencontrent ce genre de
probl&egrave;me peuvent utiliser le module <module>mod_authn_socache</module>
qui permet de mettre les donn&eacute;es d'authentification en cache, et
soulager ainsi la base de donn&eacute;es de la plus grande partie de la charge.</p>
</section>

<section id="example">
<title>Exemple de configuration</title>
<p>Voici un exemple simple d'utilisation de ce module dans un contexte
d'authentification et de bases de donn&eacute;es.</p>
<highlight language="config">
# configuration de mod_dbd
# MISE &Agrave; JOUR pour inclure la mise en cache de l'authentification
DBDriver pgsql
DBDParams "dbname=apacheauth user=apache password=xxxxxx"

DBDMin  4
DBDKeep 8
DBDMax  20
DBDExptime 300

&lt;Directory /usr/www/mon-serveur/private&gt;
  # configuration de mod_authn_core et mod_auth_basic
  # pour mod_authn_dbd
  AuthType Basic
  AuthName "Mon serveur"

  # Pour mettre en cache les donn&eacute;es d'authentification, placez socache
  # avant dbd
  AuthBasicProvider socache dbd

  # Aussi n&eacute;cessaire &agrave; la mise en cache : dire au cache de mettre en
  # cache les recherches dbd !
  AuthnCacheProvideFor dbd
  AuthnCacheContext mon-serveur

  # configuration de mod_authz_core
  Require valid-user

  # la requ&ecirc;te SQL de mod_authn_dbd pour authentifier un utilisateur
  AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"
&lt;/Directory&gt;
</highlight>
</section>

<section id="exposed">
<title>Mise &agrave; disposition des informations de connexion</title>
<p>
Si httpd a &eacute;t&eacute; compil&eacute; avec la version 1.3.0 ou sup&eacute;rieure de
l'<glossary>APR</glossary>, pour chaque requ&ecirc;te envoy&eacute;e au serveur de
base de donn&eacute;es, toutes les valeurs de colonnes du premier
enregistrement renvoy&eacute; par la requ&ecirc;te sont affect&eacute;es &agrave; des variables
d'environnement avec le pr&eacute;fixe "AUTHENTICATE_".
</p>
<p>Par exemple, si une requ&ecirc;te renvoie un nom d'utilisateur, un nom
complet et un num&eacute;ro de t&eacute;l&eacute;phone, un programme CGI pourra acc&eacute;der &agrave; ces
informations sans avoir besoin d'effectuer une deuxi&egrave;me requ&ecirc;te vers la
base de donn&eacute;es.</p>
<p>Ceci va entra&icirc;ner une simplification consid&eacute;rable du code et de la
configuration n&eacute;cessaire de certaines applications web.
</p>
</section>

<directivesynopsis>
<name>AuthDBDUserPWQuery</name>
<description>Requ&ecirc;te SQL servant &agrave; v&eacute;rifier le mot de passe d'un
utilisateur</description>
<syntax>AuthDBDUserPWQuery <var>requ&ecirc;te</var></syntax>
<contextlist><context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive>AuthDBDUserPWQuery</directive> permet de
    sp&eacute;cifier une requ&ecirc;te servant &agrave; v&eacute;rifier le mot de passe d'un
    utilisateur donn&eacute;. L'identifiant utilisateur sera transmis comme
    param&egrave;tre sous forme d'une seule cha&icirc;ne de caract&egrave;res lorsque la
    requ&ecirc;te sera ex&eacute;cut&eacute;e. Cet identifiant est r&eacute;f&eacute;renc&eacute; dans la requ&ecirc;te
    en utilisant le sp&eacute;cificateur de format <code>%s</code>.</p>
    <highlight language="config">
AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"
</highlight>
    <p>La premi&egrave;re colonne du premier enregistrement renvoy&eacute; par la
    requ&ecirc;te se pr&eacute;sentera sous la forme d'une cha&icirc;ne de caract&egrave;res
    contenant le mot de passe chiffr&eacute;. Les enregistrements suivants sont
    ignor&eacute;s. Si aucun enregistrement n'est renvoy&eacute;, l'utilisateur ne
    sera pas authentifi&eacute; par <module>mod_authn_dbd</module>.</p>
    <p>Si httpd a &eacute;t&eacute; compil&eacute; avec la version 1.3.0 ou sup&eacute;rieure de
    l'<glossary>APR</glossary>, toute valeur de colonne suppl&eacute;mentaire
    du premier enregistrement renvoy&eacute; par la requ&ecirc;te sera stock&eacute;e dans
    une variable d'environnement dont le nom aura la forme
    <code>AUTHENTICATE_<var>valeur-colonne</var></code>.
    </p>
    <p>Le format du mot de passe chiffr&eacute; d&eacute;pend du frontal
    d'authentification utilis&eacute; (par exemple
    <module>mod_auth_basic</module> ou
    <module>mod_auth_digest</module>). Voir la documentation sur les <a
    href="../misc/password_encryptions.html">Formats de mots de passe</a> pour
    plus de d&eacute;tails.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthDBDUserRealmQuery</name>
<description>Requ&ecirc;te SQL servant &agrave; v&eacute;rifier une empreinte de mot de
passe pour un utilisateur et un identifiant d'authentification.
</description>
<syntax>AuthDBDUserRealmQuery <var>requ&ecirc;te</var></syntax>
<contextlist><context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive>AuthDBDUserRealmQuery</directive> permet
    de sp&eacute;cifier une requ&ecirc;te SQL servant &agrave; v&eacute;rifier une empreinte de mot
    de passe pour un utilisateur et un identifiant d'authentification
    donn&eacute;s au cours d'un processus d'authentification digest. Les
    identifiants de l'utilisateur et de l'authentification
    sont pass&eacute;s dans cet ordre comme param&egrave;tres &agrave; l'ex&eacute;cution de la
    requ&ecirc;te. Ils sont r&eacute;f&eacute;renc&eacute;s dans la cha&icirc;ne de la requ&ecirc;te en
    utilisant des sp&eacute;cificateurs de format <code>%s</code>.</p>
    <highlight language="config">
AuthDBDUserRealmQuery "SELECT password FROM authn WHERE user = %s AND realm = %s"
</highlight>
    <p>La premi&egrave;re colonne du premier enregistrement renvoy&eacute; par la
    requ&ecirc;te se pr&eacute;sentera sous la forme d'une cha&icirc;ne de caract&egrave;res
    contenant le mot de passe chiffr&eacute;. Les enregistrements suivants
    seront ignor&eacute;s. Si aucun enregistrement n'est renvoy&eacute;, l'utilisateur
    ne sera pas authentifi&eacute; par <module>mod_authn_dbd</module>.</p>
    <p>Si httpd a &eacute;t&eacute; compil&eacute; avec une version 1.3.0 ou sup&eacute;rieure de
    l'<glossary>APR</glossary>, toute valeur de colonne suppl&eacute;mentaire
    du premier enregistrement renvoy&eacute; par la requ&ecirc;te sera stock&eacute;e dans
    une variable d'environnement avec un nom de la forme
    <code>AUTHENTICATE_<var>COLONNE</var></code>.
    </p>
    <p>Le format du mot de passe chiffr&eacute; d&eacute;pend du frontal
    d'authentification utilis&eacute; (par exemple
    <module>mod_auth_basic</module> ou
    <module>mod_auth_digest</module>). Voir la documentation sur les <a
    href="../misc/password_encryptions.html">Formats de mots de passe</a> pour
    plus de d&eacute;tails.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
