<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1021924 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mpm_netware.xml.meta">
<name>mpm_netware</name>
<description>Module multi-processus impl&eacute;mentant un serveur web bas&eacute;
exclusivement sur les threads et optimis&eacute; pour Novell
NetWare</description>
<status>MPM</status>
<sourcefile>mpm_netware.c</sourcefile>
<identifier>mpm_netware_module</identifier>

<summary>
    <p>Ce module multi-processus (MPM) impl&eacute;mente un serveur web bas&eacute;
    exclusivement sur les threads et optimis&eacute; pour Novell NetWare.</p>

    <p>Le thread ma&icirc;tre est charg&eacute; du lancement de threads esclaves qui
    attendent les connexions et les traitent au fur et &agrave; mesure de leur
    arriv&eacute;e. Le serveur HTTP Apache essaie toujours de maintenir
    plusieurs threads
    esclaves en <dfn>spare</dfn> (en r&eacute;serve) ou inactifs. De cette
    fa&ccedil;on, les clients n'ont pas besoin d'attendre le lancement d'un
    nouveau thread enfant pour que leurs requ&ecirc;tes soient trait&eacute;es.</p>

    <p>Les directives <directive
    module="mpm_common">StartThreads</directive>, <directive
    module="mpm_common">MinSpareThreads</directive>, <directive
    module="mpm_common">MaxSpareThreads</directive>, et <directive
    module="mpm_netware">MaxThreads</directive> contr&ocirc;lent
    la mani&egrave;re dont le thread ma&icirc;tre cr&eacute;e les threads esclaves afin de
    traiter les requ&ecirc;tes. En g&eacute;n&eacute;ral, Apache httpd s'auto-r&eacute;gule correctement,
    et la plupart des sites ne n&eacute;cessitent aucune modification des
    valeurs par d&eacute;faut de ces directives. Pour les sites dont le serveur
    est limit&eacute; en m&eacute;moire, il peut s'av&eacute;rer n&eacute;cessaire de diminuer la
    valeur de la directive <directive
    module="mpm_netware">MaxThreads</directive> afin d'&eacute;viter une
    hyper-activit&eacute; du serveur (arr&ecirc;ts de threads inactifs et lancement incessant
    de nouveau threads). Vous trouverez plus d'informations &agrave;
    propos du contr&ocirc;le de la cr&eacute;ation de processus dans le document <a
    href="../misc/perf-tuning.html">conseils en mati&egrave;re de
    performances</a>.</p>

    <p>La directive <directive
    module="mpm_common">MaxRequestsPerChild</directive>
    contr&ocirc;le la fr&eacute;quence &agrave; laquelle le serveur recycle ses processus
    en arr&ecirc;tant les anciens et en en lan&ccedil;ant de nouveaux. Sous le
    syst&egrave;me d'exploitation NetWare, il est vivement recommand&eacute; de
    laisser cette directive &agrave; 0, ce qui permet aux threads esclaves de
    continuer &agrave; traiter les requ&ecirc;tes ind&eacute;finiment.</p>
</summary>
<seealso><a href="../bind.html">D&eacute;finition des adresses et ports
qu'utilise Apache httpd</a>
</seealso>

<directivesynopsis location="mpm_common"><name>Listen</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ListenBacklog</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxMemFree</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxRequestsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ReceiveBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>SendBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxSpareThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MinSpareThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>StartThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadStackSize</name>
</directivesynopsis>

<directivesynopsis>
<name>MaxThreads</name>
<description>D&eacute;finit le nombre maximum de threads esclaves</description>
<syntax>MaxThreads <var>nombre</var></syntax>
<default>MaxThreads 2048</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>MaxThreads</directive> d&eacute;finit
    le nombre maximum de threads esclaves que l'on d&eacute;sire autoriser. La
    valeur par d&eacute;faut correspondant &agrave; la valeur cod&eacute;e en dur &agrave; la
    compilation, la valeur de cette directive ne peut donc qu'&ecirc;tre
    diminu&eacute;e, comme dans l'exemple suivant :</p>

    <example>
      MaxThreads 512
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
