<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1174747 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="netware.xml.meta">
  <parentdocument href="./">Notes sp&eacute;cifiques &agrave; un syst&egrave;me</parentdocument>

  <title>Utilisation d'Apache avec Novell NetWare</title>

  <summary>

    <p>Ce document explique l'installation, la configuration et le
    lancement d'Apache 2.0 sous Novell NetWare 6.0 et les versions
    ult&eacute;rieures. Si vous trouvez une bogue, ou voulez tout simplement
    contribuer de quelque mani&egrave;re que ce soit, utilisez s'il vous plait
    notre <a href="http://httpd.apache.org/bug_report.html">page des
    rapports de bogues.</a></p>

    <p>La page des rapports de bogues et la liste de diffusion dev-httpd
    ne doivent pas &ecirc;tre utilis&eacute;es pour poser des questions &agrave; propos de
    la configuration ou du lancement d'Apache. Avant de soumettre un
    rapport de bogue ou une question, consultez ce document, la <a
    href="../faq/">Foire aux questions</a> ou tout autre sujet de la
    documentation en rapport avec votre probl&egrave;me. Si vous n'avez
    toujours pas r&eacute;solu votre probl&egrave;me, postez votre question dans le
    newsgroup <a
    href="news://developer-forums.novell.com/novell.devsup.webserver">
    novell.devsup.webserver</a>, o&ugrave; de nombreux utilisateurs d'Apache
    sont pr&ecirc;ts &agrave; r&eacute;pondre &agrave; toutes les nouvelles et obscures questions &agrave;
    propos de l'utilisation d'Apache sous Netware.</p>

    <p>Dans la majeure partie de ce document, vous &ecirc;tes sens&eacute; avoir
    install&eacute; Apache &agrave; partir d'une distribution binaire. Si vous voulez
    compiler Apache vous-m&ecirc;me (par exemple pour aider au d&eacute;veloppement,
    ou pour rechercher des bogues), reportez-vous &agrave; la section traitant
    de la <a href="#comp">Compilation d'Apache pour Netware</a>
    ci-dessous.</p>

  </summary>

  <section id="req">

    <title>Pr&eacute;requis</title>

    <p>Apache 2.0 n&eacute;cessite NetWare 6.0 service pack 3 et sup&eacute;rieurs
    pour fonctionner. Si vous utilisez un service pack ant&eacute;rieur &agrave; SP3,
    vous devez installer les derni&egrave;res <a
    href="http://developer.novell.com/ndk/libc.htm">Biblioth&egrave;ques
    Netware pour C (LibC)</a>.</p>

    <p>Vous trouverez les service packs Netware <a
    href="http://support.novell.com/misc/patlst.htm#nw">ici</a>.</p>

    <p>Apache 2.0 pour NetWare peut aussi fonctionner dans un
    environnement NetWare 5.1, &agrave; partir du moment o&ugrave; le dernier service
    pack ou la derni&egrave;re version des <a
    href="http://developer.novell.com/ndk/libc.htm">Biblioth&egrave;ques
    Netware pour C (LibC)</a> ont &eacute;t&eacute; install&eacute;s. <strong>ATTENTION
    :</strong> Apache 2.0 pour NetWare n'a pas &eacute;t&eacute; test&eacute; dans cet
    environnement car il n'a pas &eacute;t&eacute; con&ccedil;u pour ce dernier.</p>

  </section>

  <section id="down">

    <title>T&eacute;l&eacute;chargement d'Apache pour NetWare</title>

    <p>Les informations &agrave; propos de la derni&egrave;re version
    d'Apache sont disponibles sur le site web d'Apache &agrave; <a
    href="http://www.apache.org/">http://www.apache.org/</a>. Vous y
    trouverez la version courante, des versions alpha ou b&ecirc;ta-test plus
    r&eacute;centes, ainsi que des sites miroirs et des sites FTP anonymes. Les
    distributions binaires des derni&egrave;res versions d'Apache 2.0 pour
    NetWare sont disponibles <a
    href="http://www.apache.org/dist/httpd/binaries/netware">ici</a>.</p>

  </section>

  <section id="inst">

    <title>Installation d'Apache pour NetWare</title>

    <p>Il n'existe pas actuellement de programme d'installation d'Apache
    pour Netware. Si vous installez Apache 2.0 pour NetWare &agrave; partir des
    sources, vous devrez copier les fichiers sur le serveur
    manuellement.</p>

    <p>Suivez ces instructions pour installer Apache sous Netware &agrave;
    partir de la distribution binaire (en supposant que vous effectuez
    l'installation dans <code>sys:/apache2</code>) :</p>

    <ul>
      <li>D&eacute;compressez le fichier binaire t&eacute;l&eacute;charg&eacute; &agrave; la racine du
      volume <code>SYS:</code> (vous pouvez cependant l'installer dans
      tout volume)</li>

      <li>Editez le fichier <code>httpd.conf</code> et d&eacute;finissez les
      directives <directive module="core">ServerRoot</directive> et
      <directive module="core">ServerName</directive> avec les valeurs
      correctes des chemins de fichiers qui correspondent &agrave; la
      configuration de votre serveur.</li>

      <li>Ajoutez <code>SYS:/APACHE2</code> au chemin de recherche, par
      une commande du style : <example>SEARCH ADD
      SYS:\APACHE2</example></li>

    </ul>

    <p>Suivez ces instructions pour installer Apache pour Netware
    manuellement &agrave; partir de votre propre r&eacute;pertoire de sources (en
    supposant que vous effectuez l'installation dans
    <code>sys:/apache2</code>) :</p>

    <ul>
      <li>Cr&eacute;ez un r&eacute;pertoire que vous appellerez <code>Apache2</code>
      dans un volume Netware.</li>

      <li>Copiez <code>APACHE2.NLM</code>, <code>APRLIB.NLM</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Cr&eacute;ez un r&eacute;pertoire que vous appellerez <code>BIN</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Copiez <code>HTDIGEST.NLM</code>, <code>HTPASSWD.NLM</code>,
      <code>HTDBM.NLM</code>, <code>LOGRES.NLM</code>,
      <code>ROTLOGS.NLM</code> dans <code>SYS:/APACHE2/BIN</code>.</li>

      <li>Cr&eacute;ez un r&eacute;pertoire que vous appellerez <code>CONF</code> dans
      <code>SYS:/APACHE2</code>.</li>

      <li>Copiez le fichier <code>HTTPD-STD.CONF</code> dans le
      r&eacute;pertoire <code>SYS:/APACHE2/CONF</code> et renommez-le en
      <code>HTTPD.CONF</code>.</li>

      <li>Copiez les fichiers <code>MIME.TYPES</code>,
      <code>CHARSET.CONV</code> et <code>MAGIC</code> dans le r&eacute;pertoire
      <code>SYS:/APACHE2/CONF</code>.</li>

      <li>Copiez tous les fichiers et sous-r&eacute;pertoires de
      <code>\HTTPD-2.0\DOCS\ICONS</code> dans
      <code>SYS:/APACHE2/ICONS</code>.</li>

      <li>Copiez tous les fichiers et sous-r&eacute;pertoires de
      <code>\HTTPD-2.0\DOCS\MANUAL</code> dans
      <code>SYS:/APACHE2/MANUAL</code>.</li>

      <li>Copiez tous les fichiers et sous-r&eacute;pertoires de
      <code>\HTTPD-2.0\DOCS\ERROR</code> dans
      <code>SYS:/APACHE2/ERROR</code>.</li>

      <li>Copiez tous les fichiers et sous-r&eacute;pertoires de
      <code>\HTTPD-2.0\DOCS\DOCROOT</code> dans
      <code>SYS:/APACHE2/HTDOCS</code>.</li>

      <li>Cr&eacute;ez le r&eacute;pertoire <code>SYS:/APACHE2/LOGS</code> sur le
      serveur.</li>

      <li>Cr&eacute;ez le r&eacute;pertoire <code>SYS:/APACHE2/CGI-BIN</code> sur le
      serveur.</li>

      <li>Cr&eacute;ez le r&eacute;pertoire <code>SYS:/APACHE2/MODULES</code> et
      copiez tous les modules nlm dans le r&eacute;pertoire
      <code>modules</code>.</li>

      <li>Editez le fichier <code>HTTPD.CONF</code>, et recherchez
      toutes les marques <code>@@Value@@</code> afin de les remplacer
      par les valeurs appropri&eacute;es.</li>

      <li>Ajoutez <code>SYS:/APACHE2</code> au chemin de recherche, par
      une commande du style : <example>SEARCH ADD
      SYS:\APACHE2</example>.</li>
    </ul>

    <p>Outre le volume par d&eacute;faut <code>SYS</code>, Apache peut &ecirc;tre
    install&eacute; dans tout autre volume.</p>

    <p>Au cours du processus d'installation, l'ajout du mot-cl&eacute;
    "install" &agrave; la ligne de commande du makefile va provoquer la
    construction d'une distribution compl&egrave;te sous forme d'un paquetage
    dans le sous-r&eacute;pertoire <code>DIST</code>. Vous pouvez simplement
    installer Apache en copiant la distribution cr&eacute;&eacute;e pr&eacute;c&eacute;demment &agrave; la
    racine d'un volume Netware (voir <a href="#comp">Compilation
    d'Apache pour NetWare</a> ci-dessous).</p>

  </section>

  <section id="run">

    <title>Ex&eacute;cuter Apache pour NetWare</title>

    <p>Pour d&eacute;marrer Apache, tapez simplement <code>apache</code> dans
    la console. Ceci aura pour effet de charger Apache dans l'espace
    d'adressage du syst&egrave;me d'exploitation. Si vous pr&eacute;f&eacute;rez charger
    Apache dans un espace d'adressage prot&eacute;g&eacute;, vous pouvez sp&eacute;cifier cet
    espace d'adressage &agrave; l'aide de l'instruction de chargement suivante
    :</p>

    <example>
      load address space = apache2 apache2
    </example>

    <p>Cette instruction va charger Apache dans un espace d'adressage
    appel&eacute; apache2. Il est possible d'ex&eacute;cuter plusieurs instances
    simultan&eacute;es d'Apache sous Netware, en chargeant chacune d'entre
    elles dans son propre espace d'adressage prot&eacute;g&eacute;.</p>

    <p>Une fois d&eacute;marr&eacute;, Apache &eacute;coute sur le port 80 (&agrave; moins que vous
    n'ayez modifi&eacute; la directive <directive
    module="mpm_common">Listen</directive> dans les fichiers de
    configuration). Pour vous connecter au serveur et afficher la page
    par d&eacute;faut, lancez un navigateur et entrez le nom du serveur ou son
    adresse IP. Vous devriez voir une page de bienvenue, et un lien vers
    le manuel Apache. Si rien ne se produit, ou si vous obtenez un
    message d'erreur, consultez le fichier <code>error_log</code> dans
    le r&eacute;pertoire <code>logs</code>.</p>

    <p>Lorsque votre installation de base fonctionne, vous devez la
    configurer correctement en &eacute;ditant les fichiers du r&eacute;pertoire
    <code>conf</code>.</p>

    <p>Pour arr&ecirc;ter une instance d'Apache s'ex&eacute;cutant dans l'espace
    d'adressage du syst&egrave;me d'exploitation, entrez simplement dans la
    console :</p>

    <example>
      unload apache2
    </example>

    <p>ou</p>

    <example>
      apache2 shutdown
    </example>

    <p>Si Apache s'ex&eacute;cute dans un espace d'adressage prot&eacute;g&eacute;, sp&eacute;cifiez
    cet espace d'adressage dans l'instruction d'arr&ecirc;t :</p>

    <example>
      unload address space = apache2 apache2
    </example>

    <p>Lorsqu'on travaille avec Apache, il est important de savoir
    comment il trouve ses fichiers de configuration. Vous pouvez
    sp&eacute;cifier un fichier de configuration sur la ligne de commande de
    deux mani&egrave;res :</p>

    <ul>
      <li><code>-f</code> sp&eacute;cifie un chemin vers un fichier de
      configuration particulier</li>
    </ul>

    <example>
      apache2 -f "vol:/nom-serveur/conf/fich-conf.conf"
    </example>

    <example>
      apache -f test/test.conf
    </example>

    <p>Dans ces cas, la directive <directive
    module="core">ServerRoot</directive> doit &ecirc;tre correctement d&eacute;finie
    dans le fichier de configuration.</p>

    <p>Si vous ne sp&eacute;cifiez pas de nom de fichier de configuration avec
    l'option <code>-f</code>, Apache utilisera le nom de fichier cod&eacute; en
    dur dans le serveur, en g&eacute;n&eacute;ral <code>conf/httpd.conf</code>.
    L'invocation d'Apache avec l'option <code>-V</code> indiquera ce nom
    comme valeur de l'&eacute;tiquette <code>SERVER_CONFIG_FILE</code>. Apache
    va ensuite d&eacute;terminer son <directive
    module="core">ServerRoot</directive> en effectuant les tests
    suivants, dans cet ordre </p>

    <ul>
      <li>Une directive <code>ServerRoot</code> via une option
      <code>-C</code> switch.</li>

      <li>L'option de ligne de commande <code>-d</code>.</li>

      <li>Le contenu du r&eacute;pertoire courant.</li>

      <li>La racine du r&eacute;pertoire d'installation cod&eacute;e en dur dans le
      serveur.</li>
    </ul>

    <p>La racine du r&eacute;pertoire d'installation cod&eacute;e en dur dans le
      serveur est en g&eacute;n&eacute;ral <code>sys:/apache2</code>. L'invocation
      d'Apache avec l'option <code>-V</code> indiquera ce chemin comme
      valeur de l'&eacute;tiquette <code>HTTPD_ROOT</code>.</p>

    <p>Apache 2.0 pour Netware comporte un jeu d'options de ligne de
    commande permettant d'afficher ou de modifier certaines
    caract&eacute;ristiques de l'instance du serveur web en cours d'ex&eacute;cution.
    Ces options ne sont disponibles que lorsqu'Apache est en cours
    d'ex&eacute;cution. Chacune de ces options doit &ecirc;tre pr&eacute;c&eacute;d&eacute;e du mot-cl&eacute;
    <code>APACHE2</code>.</p>

    <dl>
      <dt>RESTART</dt>
      <dd>Demande &agrave; Apache d'arr&ecirc;ter chacun des threads worker en cours
      d'ex&eacute;cution lorsqu'il devient inactif, de recharger le fichier de
      configuration, et de red&eacute;marrer chaque thread worker en fonction
      de la nouvelle configuration.</dd>

      <dt>VERSION</dt>
      <dd>Affiche des informations &agrave; propos de la version de l'instance
      d'Apache en cours d'ex&eacute;cution.</dd>

      <dt>MODULES</dt>
      <dd>Affiche la liste des modules charg&eacute;s (int&eacute;gr&eacute;s et
      externes). </dd>

      <dt>DIRECTIVES</dt>
      <dd>Affiche la liste des directives disponibles.</dd>

      <dt>SETTINGS</dt>
      <dd>Active ou d&eacute;sactive l'affichage du statut des threads sur la
      console. En cas d'activation, l'&eacute;tat de chaque thread en cours
      d'ex&eacute;cution s'affiche sur l'&eacute;cran de la console Apache.</dd>

      <dt>SHUTDOWN</dt>
      <dd>Arr&ecirc;te l'instance du serveur web Apache en cours
      d'ex&eacute;cution.</dd>

      <dt>HELP</dt>
      <dd>D&eacute;crit chacune des options disponibles au cours de l'ex&eacute;cution
      d'Apache.</dd>
    </dl>

    <p>Par d&eacute;faut, ces options sont pass&eacute;es &agrave; l'instance d'apache
    s'ex&eacute;cutant dans l'espace d'adressage du syst&egrave;me d'exploitation.
    Pour passer une option &agrave; une instance d'Apache sp&eacute;cifique
    s'ex&eacute;cutant dans un espace d'adressage prot&eacute;g&eacute;, ajouter le param&egrave;tre
    -p suivi du nom de l'espace d'adressage. Pour plus d'informations,
    tapez "apache2 Help" sur la ligne de commande.</p>

  </section>

  <section id="use">

    <title>Configuration d'Apache pour NetWare</title>

    <p>Apache lit en g&eacute;n&eacute;ral ses fichiers de configuration dans le
    r&eacute;pertoire <code>conf</code>. Ces fichiers sont les m&ecirc;mes que ceux
    de la version Unix, mais quelques directives sont diff&eacute;rentes sous
    Netware. Voir la <a href="../">Documentation Apache</a> pour
    l'ensemble des directives disponibles.</p>

    <p>Les principales diff&eacute;rences propres &agrave; Apache pour NetWare sont
    : </p>

    <ul>
      <li>
        <p>Comme Apache pour Netware est une application multithread,
	elle n'utilise pas de processus s&eacute;par&eacute; pour chaque requ&ecirc;te,
	comme c'est le cas pour certaines impl&eacute;mentations sous Unix. Il
	n'y a que des threads en cours d'ex&eacute;cution : un thread parent,
	et plusieurs threads enfants ou worker qui traitent les
	requ&ecirc;tes.</p>

        <p>En cons&eacute;quence, les directives de gestion des "processus"
	sont diff&eacute;rentes :</p>

        <p><directive
	module="mpm_common">MaxConnectionsPerChild</directive> - comme sous
	Unix, cette directive contr&ocirc;le le nombre maximum de connexions
	qu'un thread worker peut traiter avant de s'arr&ecirc;ter. Avec la
	valeur par d&eacute;faut <code>MaxConnectionsPerChild 0</code>,
	le thread va pouvoir traiter un nombre illimit&eacute; de requ&ecirc;tes.
	Cette valeur est recommand&eacute;e sous Netware, &agrave; moins que vous
	n'ayez des raisons particuli&egrave;res de la modifier.</p>

        <p><directive module="mpm_common">StartThreads</directive> -
	Cette directive indique au serveur le nombre de threads qu'il
	doit lancer au d&eacute;marrage. Il est recommand&eacute; de conserver la
	valeur par d&eacute;faut <code>StartThreads 50</code>.</p>

        <p><directive module="mpm_common">MinSpareThreads</directive> -
	Cette directive indique au serveur le nombre de worker threads
	additionnels qu'il doit lancer si le nombre de threads inactifs
	tombe en dessous de cette valeur. Il est recommand&eacute; de conserver la
	valeur par d&eacute;faut <code>MinSpareThreads 10</code>.</p>

        <p><directive module="mpm_common">MaxSpareThreads</directive> -
	Cette directive indique au serveur qu'il doit commencer &agrave;
	arr&ecirc;ter des worker threads si le nombre de threads inactifs
	passe au dessus de cette valeur. Il est recommand&eacute; de conserver
	la valeur par d&eacute;faut <code>MaxSpareThreads 100</code>.</p>

        <p><directive module="mpm_netware">MaxThreads</directive> -
	Cette directive impose un nombre maximum de worker threads. Il
	est recommand&eacute; de conserver la valeur par d&eacute;faut
	<code>ThreadsPerChild 250</code>.</p>

        <p><directive module="mpm_common">ThreadStackSize</directive> -
	Cette directive indique au serveur la taille de la pile &agrave;
	utiliser pour un thread worker individuel. Il est recommand&eacute; de
	conserver la valeur par d&eacute;faut <code>ThreadStackSize
	65536</code>.</p>
      </li>

      <li>
        <p>Les directives qui acceptent des noms de fichiers comme
	arguments ne doivent pas utiliser des noms de fichiers Unix,
	mais des noms de fichiers Netware. Cependant, comme Apache
	utilise des noms de style Unix en interne, on doit utiliser des
	slashes et non des antislashes. Il est recommand&eacute; de pr&eacute;fixer
	tous les chemins de fichiers racines par un nom de volume. Si ce
	dernier est omis, Apache supposera que le volume est
	<code>SYS:</code>, ce qui n'est pas forc&eacute;ment correct.</p>
      </li>

      <li>
        <p>Apache pour Netware peut charger des modules
	en cours d'ex&eacute;cution, sans avoir &agrave; recompiler le serveur. Si
	Apache est compil&eacute; avec les options par d&eacute;faut, il va installer
	de nombreux modules optionnels dans le r&eacute;pertoire
	<code>\Apache2\modules</code>. Pour les activer, ou en activer
	d'autres, on doit utiliser la directive <directive
        module="mod_so">LoadModule</directive>. Par exemple, pour
	activer le module status, ajoutez la ligne suivante :</p>

        <example>
          LoadModule status_module modules/status.nlm
        </example>

        <p>Des informations &agrave; propos de la  <a
        href="../mod/mod_so.html#creating">cr&eacute;ation de modules
	chargeables</a> sont aussi disponibles.</p>
      </li>
    </ul>

    <section id="use-add">

      <title>Autres directives sp&eacute;cifiques &agrave; Netware :</title>

      <ul>
        <li><directive module="core">CGIMapExtension</directive> -
        Cette directive associe une extension de fichier CGI &agrave; un
	interpr&eacute;teur de script.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">SecureListen</directive> -
        Cette directive active le chiffrement SSL pour un port
	sp&eacute;cifique.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">NWSSLTrustedCerts</directive> -
        Cette directive ajoute des certificats de confiance
	pouvant &ecirc;tre utilis&eacute;s pour cr&eacute;er des connexions s&eacute;curis&eacute;es vers
	des serveurs mandataires.</li>
      </ul>
      <ul>
        <li><directive module="mod_nw_ssl">NWSSLUpgradeable</directive> -
        Cette directive active le chiffrement  SSL sur une connexion
	initialis&eacute;e sur les adresse IP et Port sp&eacute;cifi&eacute;s.</li>
      </ul>

    </section>

  </section>

  <section id="comp">

    <title>Compilation d'Apache pour NetWare</title>

    <p>La compilation d'Apache n&eacute;cessite MetroWerks CodeWarrior 6.x ou
    sup&eacute;rieur. Une fois compil&eacute;, Apache peut &ecirc;tre install&eacute; &agrave; la racine
    de tout volume Netware. Le r&eacute;pertoire d'installation par d&eacute;faut est
    <code>sys:/Apache2</code>.</p>

    <p>Avant de d&eacute;marrer Apache, vous devez renseigner le r&eacute;pertoire
    <code>conf</code>. Copiez le fichier <code>HTTPD-STD.CONF</code>
    depuis le r&eacute;pertoire <code>conf</code> de la distribution et
    renommez-le en <code>HTTPD.CONF</code>. &Eacute;ditez le fichier
    <code>HTTPD.CONF</code> en recherchant les rep&egrave;res
    <code>@@Value@@</code>, et remplacez ces derniers par la valeur
    appropri&eacute;e. Copiez de m&ecirc;me les fichiers <code>conf/magic</code> et
    <code>conf/mime.types</code>. Vous pouvez aussi construire une
    distribution compl&egrave;te en ajoutant le mot-cl&eacute; <code>install</code>
    lors de l'invocation des makefiles.</p>

    <section id="comp-req">

      <title>Pr&eacute;requis :</title>

      <p>Les outils de d&eacute;veloppement suivants sont n&eacute;cessaires pour la
      compilation d'Apache pour Netware :</p>

      <ul>
        <li>Metrowerks CodeWarrior 6.0 ou sup&eacute;rieur avec le <a
	href="http://developer.novell.com/ndk/cwpdk.htm">NetWare PDK
	3.0</a> ou sup&eacute;rieur.</li>

        <li>Les <a
	href="http://developer.novell.com/ndk/libc.htm">Biblioth&egrave;ques
	Netware pour C (LibC)</a></li>

        <li>Les <a
	href="http://developer.novell.com/ndk/cldap.htm">Biblioth&egrave;ques
	LDAP pour C</a></li>

        <li>Le <a href="http://www.gzip.org/zlib/">Code source de la
	biblioth&egrave;que de compression ZLIB</a></li>

        <li>L'utilitaire AWK (awk, gawk ou similaire). AWK peut &ecirc;tre
	t&eacute;l&eacute;charg&eacute; &agrave; <a
	href="http://developer.novell.com/ndk/apache.htm"
	>http://developer.novell.com/ndk/apache.htm</a>.
	L'utilitaire doit se trouver dans votre chemin windows et avoir
	pour nom <code>awk.exe</code>.</li>

        <li>Pour utiliser les makefiles, vous devez disposer de GNU make
	version 3.78.1 (GMake) disponible &agrave; <a
	href="http://developer.novell.com/ndk/apache.htm"
	>http://developer.novell.com/ndk/apache.htm</a>.</li>
      </ul>

    </section>

    <section id="comp-make">

      <title>Compiler Apache en utilisant les makefiles Netware
      :</title>

      <ul>
        <li>D&eacute;finissez la variable d'environnement
	<code>NOVELLLIBC</code> avec le chemin des biblioth&egrave;ques Netware
	pour C SDK ; par exemple : <example>Set
	NOVELLLIBC=c:\novell\ndk\libc</example></li>

        <li>D&eacute;finissez la variable d'environnement
	<code>METROWERKS</code> avec le chemin de votre compilateur
	Metrowerks CodeWarrior ; par exemple : <example>Set
	METROWERKS=C:\Program Files\Metrowerks\CodeWarrior</example>. Si
	vous l'avez install&eacute; dans le r&eacute;pertoire par d&eacute;faut
	<code>C:\Program Files\Metrowerks\CodeWarrior</code>, vous
	n'avez pas besoin de d&eacute;finir cette variable.</li>

        <li>D&eacute;finissez la variable d'environnement <code>LDAPSDK</code>
	avec le chemin des biblioth&egrave;ques LDAP pour C ; par exemple :
	<example>Set
	LDAPSDK=c:\Novell\NDK\cldapsdk\NetWare\libc</example></li>

        <li>D&eacute;finissez la variable d'environnement <code>ZLIBSDK</code>
	avec le chemin du code source de la biblioth&egrave;que Zlib ; par
	exemple : <example>Set ZLIBSDK=D:\NOVELL\zlib</example></li>

	<li>D&eacute;finissez la variable d'environnement <code>PCRESDK</code>
	avec le chemin d'installation du code source de la biblioth&egrave;que
	PCRE ; par exemple :
	<example>Set PCRESDK=D:\NOVELL\pcre</example>
	</li>

        <li>D&eacute;finissez la variable d'environnement <code>AP_WORK</code>
	avec le chemin du code source de <code>httpd</code>.
	<example>Set AP_WORK=D:\httpd-2.0.x</example></li>

        <li>D&eacute;finissez la variable d'environnement <code>APR_WORK</code>
	avec le chemin du code source d'<code>apr</code> ; en g&eacute;n&eacute;ral
	<code>\httpd\srclib\apr</code>, mais le projet APR peut se
	trouver en dehors de la structure des r&eacute;pertoires de httpd.
	<example>Set APR_WORK=D:\apr-1.x.x</example></li>

        <li>D&eacute;finissez la variable d'environnement <code>APU_WORK</code>
	avec le chemin du code source d'<code>apr-util</code> ; en
	g&eacute;n&eacute;ral <code>\httpd\srclib\apr-util</code>, mais le projet
	APR-UTIL peut se trouver en dehors de la structure des
	r&eacute;pertoires de httpd. <example>Set
	APU_WORK=D:\apr-util-1.x.x</example></li>

        <li>V&eacute;rifiez que les chemins des utilitaires AWK et GNU make
	(<code>gmake.exe</code>) ont bien &eacute;t&eacute; inclus dans la variable
	d'environnement syst&egrave;me <code>PATH</code>.</li>

        <li>T&eacute;l&eacute;chargez le code source et d&eacute;compressez-le dans un
	r&eacute;pertoire de votre choix sur votre station de travail.</li>

        <li>Positionnez-vous dans le r&eacute;pertoire <code>\httpd-2.0</code>
	et compilez les utilitaires pr&eacute;compil&eacute;s &agrave; l'aide de la commande
	"<code>gmake -f nwgnumakefile prebuild</code>". Cette cible va
	cr&eacute;er le r&eacute;pertoire <code>\httpd-2.0\nwprebuild</code>, et y
	copier tous les utilitaires n&eacute;cessaires au franchissement des
	&eacute;tapes suivantes de la compilation.</li>

        <li>Copiez les fichiers
	<code>\httpd-2.0\nwprebuild\GENCHARS.nlm</code> et
	<code>\httpd-2.0\nwprebuild\DFTABLES.nlm</code> vers le volume
	<code>SYS:</code> d'un serveur Netware et ex&eacute;cutez-les &agrave; l'aide
	des commandes suivantes :
          <example>
            SYS:\genchars &gt; sys:\test_char.h<br />
            SYS:\dftables sys:\chartables.c<br />
          </example>
        </li>

        <li>Copiez les fichiers <code>test_char.h</code> et
	<code>chartables.c</code> vers le r&eacute;pertoire
	<code>\httpd-2.0\os\netware</code> de la machine o&ugrave; s'effectue
	la compilation.</li>

        <li>Positionnez-vous dans le r&eacute;pertoire <code>\httpd-2.0</code>
	et compilez Apache &agrave; l'aide de la commande "<code>gmake -f
	nwgnumakefile</code>". Vous pouvez cr&eacute;er un r&eacute;pertoire pour la
	distribution en ajoutant le param&egrave;tre install &agrave; la commande ;
	par exemple :
        <example>gmake -f nwgnumakefile install</example>
        </li>
      </ul>

    </section>

    <section id="comp-add">

      <title>Options de make suppl&eacute;mentaires</title>

      <ul>
        <li><code>gmake -f nwgnumakefile</code><p>Compile les versions
	de distribution de tous les binaires et les copie dans un
	r&eacute;pertoire <code>\release</code>.</p></li>

        <li><code>gmake -f nwgnumakefile DEBUG=1</code><p>Compile les versions
	de d&eacute;bogage de tous les binaires et les copie dans un
	r&eacute;pertoire <code>\debug</code>.</p></li>

        <li><code>gmake -f nwgnumakefile install</code><p>Cr&eacute;e une
	distribution compl&egrave;te d'Apache avec les binaires, la
	documentation et les fichiers support dans un r&eacute;pertoire
	<code>\dist\Apache2</code>.</p></li>

        <li><code>gmake -f nwgnumakefile prebuild</code><p>Compile tous
	les utilitaires pr&eacute;compil&eacute;s et les copie dans le r&eacute;pertoire
	<code>\nwprebuild</code>.</p></li>

        <li><code>gmake -f nwgnumakefile installdev</code><p>M&ecirc;me effet
	que l'option install, mais en plus, les r&eacute;pertoires
	<code>\lib</code> et <code>\include</code> sont cr&eacute;&eacute;s dans le
	r&eacute;pertoire de destination, et les en-t&ecirc;tes et fichiers d'import
	y sont copi&eacute;s.</p></li>

        <li><code>gmake -f nwgnumakefile clean</code><p>Supprime tous
	les fichiers objets et les binaires de la zone de compilation
	<code>\release.o</code>, ou <code>\debug.o</code> si
	<code>DEBUG</code> a &eacute;t&eacute; d&eacute;fini.</p></li>

        <li><code>gmake -f nwgnumakefile clobber_all</code><p>M&ecirc;me effet
	que clean, mais en plus, le r&eacute;pertoire de la distribution est
	supprim&eacute; s'il existe.</p></li>
      </ul>

    </section>

    <section id="comp-add-env">

      <title>Variables d'environnement suppl&eacute;mentaires</title>

      <ul>
        <li>Pour compiler tous les modules exp&eacute;rimentaux, d&eacute;finissez la
	variable d'environnement <code>EXPERIMENTAL</code> :
        <example>Set EXPERIMENTAL=1</example>
        </li>

        <li>Pour compiler Apache en utilisant les sockets de style BSD
	standard, plut&ocirc;t que Winsock, d&eacute;finissez la variable
	d'environnement <code>USE_STDSOCKETS</code> :
        <example>Set USE_STDSOCKETS=1</example>
        </li>

      </ul>

    </section>

    <section id="comp-mod_ssl">

      <title>Compilation de mod_ssl pour la plate-forme Netware</title>

      <p>Pour fournir les services SSL, Apache pour Netware utilise par
      d&eacute;faut le module int&eacute;gr&eacute; <module>mod_nw_ssl</module>. Ce module ne
      fournit que les services SSL impl&eacute;ment&eacute;s par le syst&egrave;me
      d'exploitation Netware lui-m&ecirc;me pour g&eacute;rer le chiffrement
      pour un port donn&eacute;. Cependant, on peut aussi utiliser mod_ssl de
      la m&ecirc;me mani&egrave;re que sur les autres plate-formes.</p>

      <p>Afin de pouvoir compiler mod_ssl pour la plate-forme Netware,
      les biblioth&egrave;ques OpenSSL doivent &ecirc;tre disponibles. Elles peuvent
      &ecirc;tre install&eacute;es de la mani&egrave;re suivante :</p>

      <ul>
          <li>T&eacute;l&eacute;chargez la derni&egrave;re distribution du code source
	  d'OpenSSL 0.9.8 depuis la page <a
	  href="http://www.openssl.org/source/">OpenSSL Source</a> (les
	  versions 0.9.7 doivent &ecirc;tre patch&eacute;es, et ne sont donc pas
	  recommand&eacute;es).</li>

          <li>Editez le fichier <code>NetWare/set_env.bat</code>, et
	  effectuez toutes modifications n&eacute;cessaires des chemins des
	  outils et utilitaires en fonction de votre environnement de
	  d&eacute;veloppement.</li>

          <li>Ex&eacute;cutez les scripts suivants depuis la racine du
	  r&eacute;pertoire des sources d'OpenSSL :
          <example>
              Netware\set_env netware-libc<br />
              Netware\build netware-libc
          </example>
          Pour des raisons de performances, vous devez activer la
	  compilation avec le code ASM. T&eacute;l&eacute;charger NASM depuis le <a
	  href="http://nasm.sourceforge.net/">site SF</a>. Configurez
	  ensuite OpenSSL pour utiliser le code ASM :
          <example>
              Netware\build netware-libc nw-nasm enable-mdc2 enable-md5
          </example>
          Attention : n'utilisez pas l'Assembleur CodeWarrior - il
	  produit un code de mauvaise qualit&eacute; !</li>

          <li>Avant de compiler Apache, d&eacute;finissez la variable
	  d'environnement <code>OSSLSDK</code> avec le chemin absolu de
	  la racine du r&eacute;pertoire du code source d'openssl, et
	  d&eacute;finissez WITH_MOD_SSL &agrave; 1.
          <example>
              Set OSSLSDK=d:\openssl-0.9.8x<br />
              Set WITH_MOD_SSL=1
          </example></li>

      </ul>

    </section>

  </section>

</manualpage>

