<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1500327 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htpasswd.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>htpasswd - Gestion des fichiers d'utilisateurs pour
l'authentification de base</title>

<summary>
    <p><code>htpasswd</code> permet de cr&eacute;er et de maintenir les
    fichiers textes o&ugrave; sont stock&eacute;s les noms d'utilisateurs et mots de
    passe pour l'authentification de base des utilisateurs HTTP. Si
    <code>htpasswd</code> rencontre un probl&egrave;me d'acc&egrave;s &agrave; un fichier,
    que ce soit pour &eacute;crire dans le fichier de sortie, ou pour lire le
    fichier d'entr&eacute;e dans le but de le mettre &agrave; jour, il renvoie un code
    d'erreur et n'effectue aucune modification.</p>

    <p>Il est possible de limiter l'acc&egrave;s aux ressources du serveur HTTP
    Apache aux seuls utilisateurs pr&eacute;sents dans les fichiers cr&eacute;&eacute;s par
    <code>htpasswd</code>. Ce programme ne sait g&eacute;rer les noms
    d'utilisateurs et mots de passe que s'ils sont stock&eacute;s dans des
    fichiers textes. Il peut cependant chiffrer et afficher les mots de
    passe &agrave; des fins d'utilisation dans d'autres types de bases de
    donn&eacute;es. Pour utiliser une base de donn&eacute;es DBM, voir le programme
    <program>dbmmanage</program> ou <program>htdbm</program>.</p>

    <p><code>htpasswd</code> chiffre les mots de passe en utilisant soit
    bcrypt,
    une version de MD5 modifi&eacute;e pour Apache, soit SHA1, soit la routine
    <code>crypt()</code> du syst&egrave;me. Les fichiers g&eacute;r&eacute;s par
    <code>htpasswd</code> peuvent contenir deux types de mots de passe ;
    certaines entr&eacute;es peuvent contenir des mots de passe chiffr&eacute;s en
    MD5 ou bcrypt, alors que d'autres entr&eacute;es du m&ecirc;me fichier contiendront des
    mots de passe chiffr&eacute;s avec <code>crypt()</code>.</p>

    <p>Cette page de manuel ne d&eacute;crit que les arguments de la ligne de
    commande. Pour plus de d&eacute;tails &agrave; propos des directives n&eacute;cessaires &agrave;
    la configuration de l'authentification des utilisateurs dans
    <program>httpd</program>, voir le manuel Apache qui est fourni avec
    la distribution ou peut &ecirc;tre consult&eacute; &agrave; <a
    href="http://httpd.apache.org">http://httpd.apache.org/</a>.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>htdbm</program></seealso>
<seealso>Les scripts fournis avec la distibution d'Apache et situ&eacute;s dans
support/SHA1.</seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>htpasswd</strong>
    [ -<strong>c</strong> ]
    [ -<strong>i</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]  <var>fichier-mots-de-passe</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>b</strong>
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]  <var>fichier-mots-de-passe</var> <var>nom-utilisateur</var>
    <var>mot-de-passe</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>n</strong>
    [ -<strong>i</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ] <var>nom-utilisateur</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>nb</strong>
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ] <var>nom-utilisateur</var>
    <var>mot-de-passe</var></code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-b</code></dt>
    <dd>Utilise le mode batch ; c'est &agrave; dire, extrait le mot de passe de
    la ligne de commande au lieu de le demander &agrave; l'op&eacute;rateur. Cette
    option doit &ecirc;tre utilis&eacute;e avec la plus grande prudence, car
    <strong>le mot de passe est visible en clair</strong> dans la ligne
    de commande. Pour utiliser un script, voir l'option
    <code>-i</code>.</dd>

    <dt><code>-i</code></dt>
    <dd>Lit le mot de passe depuis stdin sans v&eacute;rification (&agrave; utiliser
    dans les scripts).</dd>

    <dt><code>-c</code></dt>
    <dd>Cr&eacute;e le <var>fichier-mots-de-passe</var>. Si
    <var>fichier-mots-de-passe</var> existe d&eacute;j&agrave;, il est r&eacute;&eacute;crit et
    tronqu&eacute;. Cette option ne peut pas &ecirc;tre combin&eacute;e avec l'option
    <code>-n</code>.</dd>

    <dt><code>-n</code></dt>
    <dd>Affiche le r&eacute;sultat du traitement sur la sortie standard au lieu
    de mettre &agrave; jour le fichier. Ceci peut s'av&eacute;rer utile pour g&eacute;n&eacute;rer
    des enregistrements de mots de passe qu'Apache pourra utiliser &agrave; des
    fins d'inclusion dans des fichiers de donn&eacute;es au format autre que
    texte. Cette option modifie la syntaxe de la ligne de commande, car
    l'argument <var>fichier-mots-de-passe</var> (en g&eacute;n&eacute;ral le premier)
    est omis. Elle ne peut pas &ecirc;tre combin&eacute;e avec l'option
    <code>-c</code> option.</dd>

    <dt><code>-m</code></dt>
    <dd>Utilise le chiffrement MD5 pour les mots de passe. C'est le
    comportement par d&eacute;faut (depuis la version 2.2.18).</dd>

    <dt><code>-B</code></dt>
    <dd>Utilise bcrypt pour chiffrer les mots de passe. c'est un
    algorythme de chiffrement actuellement consid&eacute;r&eacute; comme s&ucirc;r.</dd>

    <dt><code>-C</code></dt>
    <dd>Ce drapeau n'est autoris&eacute; qu'en conjonction avec le drapeau
    <code>-B</code> (chiffrement bcrypt). Il permet de d&eacute;finir la dur&eacute;e
    de traitement pour l'algorytme bcrypt (plus elle est longue,
    meilleure sera la s&eacute;curit&eacute;, mais inf&eacute;rieure la rapidit&eacute;). La valeur
    par d&eacute;faut est 5 et les valeurs autoris&eacute;es vont de 4 &agrave; 31.</dd>


    <dt><code>-d</code></dt>
    <dd>Utilise le chiffrement <code>crypt()</code> pour les mots de
    passe. Cette option n'est pas support&eacute;e par le
    serveur <program>httpd</program> sous Windows ou Netware. Cet
    algorithme limite la longueur des mots de passe &agrave; 8 caract&egrave;res ; il
    est consid&eacute;r&eacute; comme <strong>non sur</strong> du point de vue des
    standards actuels. C'&eacute;tait l'algorithme par d&eacute;faut jusqu'&agrave; la
    version 2.2.17.</dd>

    <dt><code>-s</code></dt>
    <dd>Utilise le chiffrement SHA pour les mots de passe. Facilite la
    migration vers/depuis les serveurs Netscape qui utilisent le format
    LDAP Directory Interchange (ldif). Cet algorithme
    est consid&eacute;r&eacute; comme <strong>non sur</strong> du point de vue des
    standards actuels.</dd>

    <dt><code>-p</code></dt>
    <dd>Enregistre les mots de passe en clair. Bien que
    <code>htpasswd</code> supporte la cr&eacute;ation des mots de passe en
    clair sur toutes les plates-formes, le d&eacute;mon
    <program>httpd</program> n'accepte les mots de passe en clair que
    sous Windows et Netware.</dd>

    <dt><code>-D</code></dt>
    <dd>Supprime un utilisateur, sous r&eacute;serve qu'il existe dans le
    fichier sp&eacute;cifi&eacute; par htpasswd.</dd>

    <dt><code>-v</code></dt>
    <dd>V&eacute;rifie si le mot de passe fourni correspond au mot de passe de
    l'utilisateur enregistr&eacute; dans le fichier de mots de passe sp&eacute;cifi&eacute;.</dd>

    <dt><code><var>fichier-mots-de-passe</var></code></dt>
    <dd>Le nom du fichier contenant les noms d'utilisateurs et mots de
    passe. Avec l'option <code>-c</code>, le fichier est cr&eacute;&eacute; s'il
    n'existe pas, ou r&eacute;&eacute;crit et tronqu&eacute; s'il existe d&eacute;j&agrave;.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>Le nom d'utilisateur &agrave; cr&eacute;er ou mettre &agrave; jour dans le
    <var>fichier-mots-de-passe</var>. Si <var>nom-utilisateur</var>
    n'existe pas, une nouvelle entr&eacute;e est ajout&eacute;e. Dans le cas
    contraire, le mot de passe est modifi&eacute;.</dd>

    <dt><code><var>mot-de-passe</var></code></dt>
    <dd>Le mot de passe en clair et destin&eacute; &agrave; &ecirc;tre chiffr&eacute; puis stock&eacute;
    dans le fichier. Cet argument ne s'utilise qu'avec l'option
    <code>-b</code>.</dd>
    </dl>
</section>

<section id="exit"><title>Valeur renvoy&eacute;e</title>
    <p><code>htpasswd</code> renvoie 0 ("true") si le nom d'utilisateur
    et le mot de passe ont &eacute;t&eacute; enregistr&eacute;s ou mis &agrave; jour avec succ&egrave;s
    dans le <var>fichier-mots-de-passe</var>. <code>htpasswd</code>
    renvoie <code>1</code> s'il a rencontr&eacute; un probl&egrave;me d'acc&egrave;s aux
    fichiers, <code>2</code> si la ligne de commande comportait une
    erreur de syntaxe, <code>3</code> si le mot de passe entr&eacute;
    interactivement ne correspondait pas au nom d'utilisateur,
    <code>4</code> si l'op&eacute;ration a &eacute;t&eacute; interrompue, <code>5</code> si
    une valeur &eacute;tait trop longue (nom-utilisateur, nom-fichier,
    mot-de-passe, ou l'enregistrement r&eacute;sultant), <code>6</code> si le
    nom d'utilisateur contenait des caract&egrave;res ill&eacute;gaux (voir la section
    <a href="#restrictions">Restrictions</a>), et <code>7</code> si le
    fichier sp&eacute;cifi&eacute; n'&eacute;tait pas un fichier de mots de passe
    valide.</p>
</section>

<section id="examples"><title>Exemples</title>
    <example>
      htpasswd /usr/local/etc/apache/.utilisateurs-htpasswd jsmith
    </example>

    <p>Ajoute ou modifie le mot de passe de l'utilisateur
    <code>jsmith</code>. Le mot de passe est demand&eacute; &agrave; l'op&eacute;rateur. Le
    mot de passe sera chiffr&eacute; en utilisant l'algorithme MD5
    modifi&eacute; pour Apache. Si le fichier sp&eacute;cifi&eacute;
    n'existe pas, <code>htpasswd</code> renverra un code d'erreur.</p>

    <example>
      htpasswd -c /home/doe/public_html/.htpasswd jane
    </example>

    <p>Cr&eacute;e un nouveau fichier de mots de passe et y enregistre une
    entr&eacute;e pour l'utilisateur <code>jane</code>. Le mot de passe est
    demand&eacute; &agrave; l'op&eacute;rateur. Si le fichier existe et ne peut &ecirc;tre ni lu ni
    &eacute;crit, il n'est pas modifi&eacute; et <code>htpasswd</code> affichera un
    message et renverra un code d'erreur.</p>

    <example>
      htpasswd -db /usr/web/.htpasswd-tous jones Pwd4Steve
    </example>

    <p>Chiffre le mot de passe sp&eacute;cifi&eacute; dans la ligne de commande
    (<code>Pwd4Steve</code>) en utilisant l'algorithme
    <code>crypt()</code>, et le stocke dans le fichier sp&eacute;cifi&eacute;.</p>
</section>

<section id="security"><title>Consid&eacute;rations &agrave; propos de s&eacute;curit&eacute;</title>
    <p>Les fichiers de mots de passe Web comme ceux que g&egrave;re
    <code>htpasswd</code> ne doivent <em>pas</em> &ecirc;tre situ&eacute;s dans
    l'espace d'URI du serveur Web -- en d'autres termes, il ne doit pas
    &ecirc;tre possible d'y acc&eacute;der &agrave; partir d'un navigateur.</p>

    <p>En tant qu'ex&eacute;cutable setuid, ce programme n'est pas s&ucirc;r, et il
    ne faut par cons&eacute;quent <em>pas</em> lui attribuer de permissions
    setuid.</p>

    <p>L'utilisation de l'option <code>-b</code> est d&eacute;conseill&eacute;e, car
    avec elle, les mots de passe apparaissent en clair dans la ligne de
    commande.</p>

    <p>Notez qu'avec l'algorithme <code>crypt()</code>, seuls les huit
    premiers caract&egrave;res du mot de passe sp&eacute;cifi&eacute; sont pris en compte. Si
    le mot de passe sp&eacute;cifi&eacute; est plus long, les caract&egrave;res
    suppl&eacute;mentaires sont ignor&eacute;s.</p>

    <p>Le format de chiffrement SHA n'utilise pas d'amor&ccedil;age al&eacute;atoire
    (salting) : &agrave; un mot de passe donn&eacute; correspond une seule
    repr&eacute;sentation chiffr&eacute;e. Les formats <code>crypt()</code> et MD5
    permutent la repr&eacute;sentation en la pr&eacute;fixant par une cha&icirc;ne d'amorce
    al&eacute;atoire, afin de rendre les attaques de mots de passe &agrave; base de
    dictionnaires plus difficiles.</p>

    <p>Les algorithmes de chiffrement SHA et <code>crypt()</code> 
    sont consid&eacute;r&eacute;s comme <strong>non surs</strong> du point de vue des
    standards actuels.</p>
</section>

<section id="restrictions"><title>Restrictions</title>
    <p>Sur les plates-formes Windows, la taille des mots de passe
    chiffr&eacute;s avec <code>htpasswd</code> est limit&eacute;e &agrave; <code>255</code>
    caract&egrave;res. Les mots de passe dont la taille est sup&eacute;rieure seront
    tronqu&eacute;s.</p>

    <p>L'algorithme MD5 utilis&eacute; par <code>htpasswd</code> est sp&eacute;cifique
    &agrave; Apache ; les mots de passe chiffr&eacute;s en utilisant cet algorithme
    seront inutilisables sur d'autres serveurs Web.</p>

    <p>La taille des noms d'utilisateurs est limit&eacute;e &agrave; <code>255</code>
    octets et ceux-ci ne doivent pas contenir de caract&egrave;re
    <code>:</code>.</p>
</section>

</manualpage>
