<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Utilisation de RewriteMap - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Utilisation de RewriteMap</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/rewritemap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/rewritemap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>


    <p>Ce document est un complment  la <a href="../mod/mod_rewrite.html">documentation de rfrence</a> du
    module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Il dcrit l'utilisation de la
    directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>, et
    fournit des exemples pour chacun des diffrents types de
    <code>RewriteMap</code>.</p>

    <div class="warning">Notez que la plupart de ces exemples ne
    fonctionneront pas en l'tat dans le contexte de votre configuration
    particulire ; vous devez donc vous attacher  les
    comprendre, plutt que de simplement les insrer dans votre
    configuration par copier/coller.</div>

  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#txt">txt: tables de correspondances au format texte</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rnd">rnd: Fichier texte  valeurs de substitution multiples
    choisies de manire alatoire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbm">dbm: Fichier condens DBM</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#int">int: Fonction interne</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#prg">prg: Programme de rcriture externe</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbd">dbd ou fastdbd: requte SQL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#summary">Rsum</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module
  mod_rewrite</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="remapping.html">Redirection et remise en
  correspondance</a></li><li><a href="access.html">Contrle d'accs</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Mise en cache</a></li><li><a href="advanced.html">Techniques avances</a></li><li><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></li></ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
    

   <p>
   La directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>
   dfinit une fonction externe qui peut tre appele depuis une
   directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> ou
   <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> pour
   accomplir une rcriture trop complique, ou trop spcialise pour
   tre effectue  partir d'expressions rationnelles. Vous trouverez
   ci-dessous les diffrents types disponibles pour la source de
   donnes, ceux-ci tant par ailleurs numrs dans la documentation de
   rfrence de <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>.</p>

   <p>La syntaxe de la directive <code>RewriteMap</code> est la suivante
   :</p>

<pre class="prettyprint lang-config">RewriteMap <em>MapName</em> <em>MapType</em>:<em>MapSource</em></pre>


    <p>L'argument <a id="mapfunc" name="mapfunc"><em>MapName</em></a>
    est un nom arbitraire que vous associez  la table de
    correspondances, et que vous
    pourrez utilisez par la suite dans les directives de rcriture. Les
    recherches dans la table de correspondance s'effectuent en
    respectant cette syntaxe :</p>

    <p class="indent">
      <strong>
        <code>${</code> <em>nom-map</em> <code>:</code>
	<em>cl-recherche</em>
        <code>}</code> <br /> <code>${</code> <em>nom-map</em> <code>:</code>
        <em>cl-recherche</em> <code>|</code> <em>DefaultValue</em> <code>}</code>
      </strong>
    </p>

    <p>Lorsque cette syntaxe est employe, la table de correspondances
    <em>nom-map</em> est consulte et la cl <em>cl-recherche</em>
    recherche. Si la cl est trouve, la fonction de recherche dans la
    table de correspondance est remplace par <em>SubstValue</em>, ou
    par <em>DefaultValue</em> dans le cas contraire, ou par la chane
    vide si aucune <em>DefaultValue</em> n'a t spcifie.</p>

    <p>Par exemple, vous pouvez dfinir une directive
    <code class="directive">RewriteMap</code> comme suit :</p>
    <pre class="prettyprint lang-config">RewriteMap examplemap txt:/path/to/file/map.txt</pre>

    <p>Vous pourrez par la suite utiliser cette table de correspondances
    dans une directive <code class="directive">RewriteRule</code> comme suit :</p>
<pre class="prettyprint lang-config">RewriteRule ^/ex/(.*) ${examplemap:$1}</pre>


<p>Il est possible de spcifier une valeur par dfaut qui sera utilise
si la recherche dans la table de correspondances est infructueuse :</p>

<pre class="prettyprint lang-config">RewriteRule ^/ex/(.*) ${examplemap:$1|/not_found.html}</pre>


<div class="note"><h3>Contexte de rpertoire et fichiers.htaccess</h3>
<p>
Vous ne pouvez utiliser la directive <code>RewriteMap</code> ni dans
les sections &lt;Directory&gt;, ni dans les fichiers
<code>.htaccess</code>. Vous devez dclarer la table de correspondances
au niveau du serveur principal ou dans un contexte de serveur virtuel.
En revanche, si vous ne pouvez pas dclarer la table dans une section
&lt;Directory&gt; ou dans un fichier <code>.htaccess</code>, vous
pourrez y faire rfrence dans ces contextes, une fois cette table
cre.
</p>
</div>

<p>Les sections suivantes dcrivent les diffrents types de tables de
correspondances <em>type-map</em> disponibles, et fournissent des
exemples pour chacun d'entre eux.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="txt" id="txt">txt: tables de correspondances au format texte</a></h2>
    

    <p>Lorsqu'un type-map <code>txt</code> est utilis, la source-map
    est un chemin du systme de fichiers vers un fichier de
    correspondances au format texte, contenant sur chaque ligne une
    paire cl/valeur spares par un espace. Il est possible d'insrer
    des commentaires sous la forme de chanes commenant par le caractre
    '#'.</p>

    <p>Voici un exemple d'entres valides dans un fichier de
    correspondances :</p>

    <p class="indent">
      # Ligne de commentaires<br />
      <strong><em>cl</em> <em>valeur-substitution</em></strong><br />
      <strong><em>cl</em> <em>valeur-substitution</em></strong> # commentaire<br />
    </p>

    <p>Lorsque la table de correspondance fait l'objet d'une recherche,
    la valeur spcifie est recherche dans le premier champ, et si elle
    est trouve, la valeur de substitution est renvoye.</p>

    <p>Par exemple, nous pourrions utiliser un fichier de
    correspondances pour traduire des noms de produits en identifiants
    produits pour obtenir des URLs plus simples  mmoriser, en
    utilisant la recette suivante :</p>

    <p><strong>Product to ID configuration</strong></p>
    <pre class="prettyprint lang-config">
RewriteMap product2id txt:/etc/apache2/productmap.txt
RewriteRule ^/product/(.*) /prods.php?id=${product2id:$1|NOTFOUND} [PT]
    </pre>


    <p>Nous supposons ici que le script <code>prods.php</code> sait quoi
    faire lorsqu'il reoit un argument <code>id=NON-TROUVE</code>, dans
    le cas o le produit ne se trouve pas dans la table de
    correspondances.</p>

    <p>Le fichier <code>/etc/apache2/map-produit.txt</code> contient ce
    qui suit :</p>

    <div class="example"><h3>Fichier de correspondances Produit - Identifiant</h3><p><code>
##<br />
##  map-produit.txt - Fichier de correspondances Produit - Identifiant<br />
##<br />
<br />
TELEVISION 993<br />
STEREO     198<br />
CANNE-A-PECHE 043<br />
BALLON-BASKET 418<br />
TELEPHONE  328
    </code></p></div>

    <p>Ainsi, lorsqu'une requte pour
    <code>http://example.com/produit/TELEVISION</code> arrive, elle est
    transforme en interne en <code>/prods.php?id=993</code>.</p>

    <div class="note"><h3>Note: fichiers .htaccess</h3>
    L'exemple donn est conu pour tre utilis dans un contexte de
    serveur principal ou de serveur virtuel. Si vous voulez l'utiliser
    dans un fichier <code>.htaccess</code>, vous devrez supprimer le
    slash de dbut dans le modle de rcriture afin que ce dernier
    puisse correspondre  toute URL :
    <pre class="prettyprint lang-config">RewriteRule ^product/(.*) /prods.php?id=${product2id:$1|NOTFOUND} [PT]</pre>

    </div>

    <div class="note"><h3>Recherches mises en cache</h3>
    <p>
    Les cls de recherche sont mises en cache par httpd jusqu' ce que
    le <code>mtime</code> (date de modification) du fichier de
    correspondances soit modifi, ou que le serveur httpd soit
    redmarr, ce qui amliore les performances pour les tables de
    correspondances consultes par de nombreuses requtes.
    </p>
    </div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rnd" id="rnd">rnd: Fichier texte  valeurs de substitution multiples
    choisies de manire alatoire</a></h2>
    

    <p>Lorsque le type-map spcifi est <code>rnd</code>, la source est
    un chemin du systme de fichiers vers un fichier de correspondances
    au format texte dont chaque ligne contient une cl, et une ou
    plusieurs valeurs spares par le caractre <code>|</code>. Si une
    cl convient, une des valeurs correspondantes sera choisie de
    manire alatoire.</p>

    <p>Par exemple, vous pouvez utiliser le fichier de correspondances
    et les directives suivants pour implmenter une rpartition de
    charge alatoire entre plusieurs serveurs d'arrire-plan, par
    l'intermdiaire d'un mandataire inverse. Les images sont envoyes
    vers un des serveurs de l'ensemble 'statique', tandis que tout le
    reste est envoy vers un des serveurs de l'ensemble 'dynamique'.</p>

    <div class="example"><h3>Fichier de correspondances</h3><p><code>
##<br />
##  map.txt -- table de rcriture<br />
##<br />
<br />
statique   www1|www2|www3|www4<br />
dynamique  www5|www6
    </code></p></div>
<p><strong>Directives de configuration</strong></p>
    <pre class="prettyprint lang-config">
RewriteMap servers rnd:/path/to/file/map.txt

RewriteRule ^/(.*\.(png|gif|jpg)) http://${servers:static}/$1 [NC,P,L]
RewriteRule ^/(.*) http://${servers:dynamic}/$1 [P,L]
    </pre>



    <p>Ainsi, lorsqu'une image est demande et que la premire rgle
    convient, <code>RewriteMap</code> recherche la chane
    <code>statique</code> dans le fichier de correspondances qui
    renvoie un des noms de serveurs spcifis de manire alatoire,
    ce dernier tant utilis dans la cible de la rgle
    <code>RewriteRule</code>.</p>

    <p>Si vous voulez qu'un des serveurs soit plus souvent sollicit que
    les autres (par exemple s'il possde plus de mmoire, et peut donc
    traiter d'avantage de requtes), spcifiez-le plusieurs fois dans la
    liste des serveurs.</p>

    <div class="example"><p><code>
statique   www1|www1|www2|www3|www4
    </code></p></div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dbm" id="dbm">dbm: Fichier condens DBM</a></h2>
    

    <p>Lorsque le type-map <code>dbm</code> est utilis, la source est
    un chemin du systme de fichiers vers un fichier de donnes DBM
    contenant des paires cl/valeur permettant d'effectuer la
    correspondance. Le fonctionnement est identique  celui du type-map
    <code>txt</code>, mais beaucoup plus rapide car un fichier DBM est
    index, alors qu'un fichier texte ne l'est pas. L'accs  la cl
    recherche est donc plus rapide.</p>

    <p>Vous pouvez ventuellement spcifier un type dbm particulier :</p>

 <pre class="prettyprint lang-config">
RewriteMap examplemap dbm=sdbm:/etc/apache/mapfile.dbm
 </pre>


    <p>Ce type peut tre choisi parmi sdbm, gdbm, ndbm ou db. Il est
    cependant recommand d'utiliser l'utilitaire <a href="../programs/httxt2dbm.html">httxt2dbm</a> fourni avec le
    serveur HTTP Apache, car il utilise la bibliothque DBM approprie,
     savoir celle qui a t utilise lors de la compilation de httpd.</p>

    <p>Pour crer un fichier dbm, crez tout d'abord un fichier de
    correspondances au format texte comme dcrit dans la section <a href="#txt">txt</a>. Traitez ensuite ce fichier avec
    <code>httxt2dbm</code> :</p>

<div class="example"><p><code>
$ httxt2dbm -i fichier-map.txt -o fichier-map.map
</code></p></div>

<p>Vous pouvez alors faire rfrence au fichier obtenu dans votre
directive <code>RewriteMap</code> :</p>
<pre class="prettyprint lang-config">
RewriteMap mapname dbm:/etc/apache/mapfile.map
</pre>


<div class="note">
<p>Notez qu'avec certains types dbm, plusieurs fichiers possdant le
mme nom de base sont crs. Par exemple, vous pouvez obtenir deux
fichiers nomms <code>fichier-map.map.dir</code> et
<code>fichier-map.map.pag</code>. Ceci est tout  fait normal, et vous
ne devez utiliser que le nom de base <code>fichier-map.map</code> dans votre
directive <code>RewriteMap</code>.</p>
</div>

<div class="note"><h3>Mise en cache des recherches</h3>
<p>
    Les cls de recherche sont mises en cache par httpd jusqu' ce que
    le <code>mtime</code> (date de modification) du fichier de
    correspondances soit modifi, ou que le serveur httpd soit
    redmarr, ce qui amliore les performances pour les tables de
    correspondances consultes par de nombreuses requtes.
</p>
</div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="int" id="int">int: Fonction interne</a></h2>
    

    <p>Lorsque le type-map <code>int</code> est spcifi, la source est
    une des fonctions RewriteMap internes disponibles. Les dveloppeurs
    de modules peuvent fournir des fonctions internes supplmentaires en
    les enregistrant via l'API <code>ap_register_rewrite_mapfunc</code>.
    Les fonctions fournies par dfaut sont :
    </p>

    <ul>
      <li><strong>toupper</strong>:<br />
             Met tous les caractres de la cl en majuscules.</li>
      <li><strong>tolower</strong>:<br />
             Met tous les caractres de la cl en minuscules.</li>
      <li><strong>escape</strong>:<br />
             Protge les caractres spciaux de la cl en les
	     transformant en leur code hexadcimal.</li>
      <li><strong>unescape</strong>:<br />
             Retraduit les codes hexadcimaux de la cl en caractres
	     spciaux.</li>
    </ul>

    <p>
    Pour utiliser une de ces fonctions, crez une
    <code>RewriteMap</code> faisant rfrence  cette fonction int, et
    utilisez-la dans votre rgle <code>RewriteRule</code> :
    </p>

    <p> <strong>Redirige un URI vers son quivalent en minuscules</strong></p>
    <pre class="prettyprint lang-config">

RewriteMap lc int:tolower
RewriteRule (.*?[A-Z]+.*) ${lc:$1} [R]
    </pre>


    <div class="note">
    <p>Notez que cet exemple n'est fourni qu' titre d'illustration,
    et ne constitue en aucun cas une recommandation. Si vous voulez
    rendre des URLs insensibles  la casse, vous devez plutt vous
    tourner vers <code class="module"><a href="../mod/mod_speling.html">mod_speling</a></code>.
    </p>
    </div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="prg" id="prg">prg: Programme de rcriture externe</a></h2>

    <p>Lorque le type-map <code>prg</code> est spcifi, la source est
    un chemin du systme de fichiers vers un programme excutable
    destin  effectuer la mise en correspondance. Il peut s'agir d'un
    fichier binaire compil, ou d'un programme en langage interprt
    comme Perl ou Python.</p>

    <p>Ce programme est lanc une fois au dmarrage du serveur HTTP
    Apache, puis communique avec le moteur de rcriture via
    <code>STDIN</code> et <code>STDOUT</code>. En d'autres termes, pour
    chaque recherche de correspondance, il reoit un argument via
    <code>STDIN</code>, et doit renvoyer en guise de rponse une chane
    termine par un caractre nouvelle-ligne sur <code>STDOUT</code>. Si
    la recherche de correspondance est infructueuse, le programme doit
    l'indiquer en retournant la chane de quatre caractres
    "<code>NULL</code>".</p>

    <p>Les programmes de rcriture externes ne sont pas lancs s'il
    n'ont pas t dfinis dans un contexte o la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriteengine">RewriteEngine</a></code> est dfinie 
    <code>on</code>.</p>

    <p>Cette fonctionnalit utilise le mutex <code>rewrite-map</code>
    ncessaire  la fiabilit des communications avec le programme. Le
    mcanisme de mutex et le fichier verrou peuvent tre dfinis via la
    directive <code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code>.</p>

    <p>Voici un exemple simple qui remplace tous les tirets par des
    caractres de soulignement dans l'URI de la requte.</p>

    <p><strong>Configuration de la rcriture</strong></p>
    <pre class="prettyprint lang-config">

RewriteMap d2u prg:/www/bin/dash2under.pl<br />
RewriteRule - ${d2u:%{REQUEST_URI}}
    </pre>


    <p><strong>dash2under.pl</strong></p>
    <pre class="prettyprint lang-perl">
    #!/usr/bin/perl
    $| = 1; # Turn off I/O buffering
    while (&lt;STDIN&gt;) {
        s/-/_/g; # Remplace tous les tirets par des caractres de soulignement
        print $_;
    }
    </pre>


<div class="note"><h3>Mises en garde !</h3>
<ul>
<li>Votre programme doit tre le plus
simple possible. Si le programme se bloque, httpd va attendre
indfiniment une rponse de sa part, et par consquent ne rpondra plus
aux requtes.</li>
<li>Assurez-vous de bien dsactiver la mise en tampon dans votre
programme. En Perl, ceci est effectu  la seconde ligne du script de
l'exemple - <code>$| = 1;</code> - La syntaxe sera bien entendu
diffrente dans
d'autres langages. Si les entres/sorties sont mises en tampon, httpd va
attendre une sortie, et va par consquent se bloquer.</li>
<li>Rappelez-vous qu'il n'existe qu'une copie du programme lanc au
dmarrage du serveur, et que toutes les requtes vont devoir passer par
ce goulot d'tranglement. Ceci peut provoquer des ralentissements
significatifs si de nombreuses requtes doivent tre traites, ou si le
script lui-mme est trs lent.</li>
</ul>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dbd" id="dbd">dbd ou fastdbd: requte SQL</a></h2>
    

    <p>Lorsque le type-map <code>dbd</code> ou <code>fastdbd</code> est
    spcifi, la source est une requte SQL SELECT qui reoit un
    argument et renvoie une seule valeur.</p>

    <p>Pour que cette requte puisse tre excute,
    <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> doit tre configur pour attaquer la base
    de donnes concerne.</p>

    <p>Ce type-map existe sous deux formes. Avec le type-map
    <code>dbd</code>, la requte est excute  chaque demande, tandis
    qu'avec le type-map <code>fastdbd</code>, les recherches dans la
    base de donnes sont mises en cache en interne. <code>fastdbd</code>
    est donc plus efficace et donc plus rapide ; par contre, il ne
    tiendra pas compte des modifications apportes  la base de donnes
    jusqu' ce que le serveur soit redmarr.</p>

    <p>Si une requte renvoie plusieurs enregistrements, un de ceux-ci
    sera slectionn alatoirement.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">
RewriteMap ma-requete "fastdbd:SELECT destination FROM rewrite WHERE source = %s"
    </pre>
</div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="summary" id="summary">Rsum</a></h2>
    

    <p>La directive <code class="directive">RewriteMap</code> peut apparatre
    plusieurs fois. Utilisez une directive
    <code class="directive">RewriteMap</code> pour chaque fonction de mise en
    correspondance pour dclarer son fichier de correspondances.</p>

    <p>Bien que l'on ne puisse pas <strong>dclarer</strong> de fonction
    de mise en correspondance dans un contexte de rpertoire (fichier
    <code>.htaccess</code> ou section &lt;Directory&gt;), il est
    possible d'utiliser cette fonction dans un tel contexte.</p>

  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/rewritemap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/rewritemap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/rewrite/rewritemap.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>