<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision : 1361160 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="custom-error.xml.meta">

  <title>Messages d'erreur personnalis&eacute;s</title>

  <summary>
    <p>Le serveur HTTP Apache fournit des messages d'erreur g&eacute;n&eacute;riques
    pour les codes de statut 4xx ou 5xx ; ces messages sont cependant
    relativement aust&egrave;res, impr&eacute;cis, et peuvent s'av&eacute;rer intimidants
    pour les visiteurs du site. Si vous le souhaitez, vous pouvez
    afficher des messages d'erreur plus conviviaux, dans un langage
    autre que l'anglais, ou m&ecirc;me sous une forme plus en ad&eacute;quation avec
    le style de votre site.</p>

    <p>Il est possible de d&eacute;finir des messages d'erreur personnalis&eacute;s
    pour chaque code de statut HTTP associ&eacute; &agrave; une condition d'erreur -
    c'est &agrave; dire tout code de statut 4xx ou 5xx.</p>

    <p>De plus, il est possible de
    personnaliser le message d'erreur en fonction d'un jeu de valeurs
    fourni, en utilisant les <a href="howto/ssi.html">Inclusions C&ocirc;t&eacute;
    Serveur (SSI)</a>. Un programme CGI ou un autre gestionnaire
    dynamique (PHP, mod_perl, etc...) peut aussi utiliser ces variables
    pour g&eacute;rer les conditions d'erreur.</p>


  </summary>

  <section id="configuration"><title>Configuration</title>

    <p>Les messages d'erreur personnalis&eacute;s sont configur&eacute;s via la
    directive <directive module="core">ErrorDocument</directive>, qui
    peut &ecirc;tre utilis&eacute;e dans un contexte global, serveur virtuel ou
    r&eacute;pertoire. On peut utiliser cette directive dans les fichiers
    .htaccess si <directive module="core">AllowOverride</directive> est
    d&eacute;finie &agrave; FileInfo.</p>

    <highlight language="config">
ErrorDocument 500 "D&eacute;sol&eacute;, notre script s'est
crash&eacute; ; comme c'est dommage !"<br />
ErrorDocument 500 /cgi-bin/crash-recover<br />
ErrorDocument 500 http://error.example.com/server_error.html<br />
ErrorDocument 404 /errors/not_found.html <br />
ErrorDocument 401 /subscription/how_to_subscribe.html
    </highlight>

<p>La syntaxe de la directive <code>ErrorDocument</code> est :</p>
      <highlight language="config">
      ErrorDocument &lt;code_3_chiffres&gt; &lt;action&gt;
    </highlight>
      <p>o&ugrave; action peut &ecirc;tre trait&eacute;e comme :</p>
        <ol>
      <li>Une URL de redirection local (si l'action commence par un "/").</li>
      <li>Une URL de redirection externe (si action est une URL valide).</li>
      <li>Le texte &agrave; afficher (si l'action ne r&eacute;pond &agrave; aucune des
      deux conditions pr&eacute;c&eacute;dentes). Entourez le texte de guillemets (")
      s'il contient plusieurs mots.</li>
        </ol>

    <p>Dans le cas d'une redirection vers une URL locale, des variables
    d'environnement suppl&eacute;mentaires sont d&eacute;finies de fa&ccedil;on &agrave; ce que la
    r&eacute;ponse puisse &ecirc;tre personnalis&eacute;e par la suite. Elles ne sont pas
    envoy&eacute;es aux URLs externes.</p>

  </section>

        <section id="variables"><title>Variables disponibles</title>

      <p>La redirection vers une autre URL peut &ecirc;tre utile, mais
      seulement s'il est possible de transmettre certaines informations
      qui pourront &ecirc;tre utilis&eacute;es pour expliquer ou journaliser
      la condition d'erreur ou le probl&egrave;me plus clairement.</p>

	<p>Pour y parvenir, lorsque la redirection d'erreur est envoy&eacute;e,
	des variables d'environnement suppl&eacute;mentaires sont d&eacute;finies &agrave;
	partir des en-t&ecirc;tes de la requ&ecirc;te originale en pr&eacute;fixant le nom
	d'origine de l'en-t&ecirc;te par 'REDIRECT_', ce qui permet de fournir au
	message d'erreur le contexte de la requ&ecirc;te originelle.</p>

      <p>Par exemple, en plus des variables d'environnement habituelles,
      vous pouvez recevoir ce qui suit :</p>


      <example>
        REDIRECT_HTTP_ACCEPT=*/*, image/gif, image/jpeg, image/png<br />
        REDIRECT_HTTP_USER_AGENT=Mozilla/5.0 Fedora/3.5.8-1.fc12 Firefox/3.5.8<br />
        REDIRECT_PATH=.:/bin:/usr/local/bin:/sbin<br />
        REDIRECT_QUERY_STRING=<br />
        REDIRECT_REMOTE_ADDR=121.345.78.123<br />
        REDIRECT_REMOTE_HOST=client.example.com<br />
        REDIRECT_SERVER_NAME=www.example.edu<br />
        REDIRECT_SERVER_PORT=80<br />
        REDIRECT_SERVER_SOFTWARE=Apache/2.2.15<br />
        REDIRECT_URL=/cgi-bin/buggy.pl
      </example>

      <p>Les variables d'environnement <code>REDIRECT_</code> sont
      cr&eacute;&eacute;es &agrave; partir des variables d'environnement pr&eacute;existantes &agrave; la
      redirection qui sont pr&eacute;fix&eacute;es par la cha&icirc;ne <code>REDIRECT_</code> ;
      par exemple, <code>HTTP_USER_AGENT</code> devient
      <code>REDIRECT_HTTP_USER_AGENT</code>.</p>

      <p><code>REDIRECT_URL</code>, <code>REDIRECT_STATUS</code>, et
      <code>REDIRECT_QUERY_STRING</code> sont syst&eacute;matiquement d&eacute;finies,
      les autres variables n'&eacute;tant d&eacute;finies que si l'en-t&ecirc;te
      correspondant existait avant la condition d'erreur.</p>

      <p><strong>Aucune</strong> d'entre elles ne sera d&eacute;finie si votre
      directive <directive module="core">ErrorDocument</directive>
      sp&eacute;cifie une redirection <em>externe</em> (toute URL commen&ccedil;ant
      par un protocole du style <code>http:</code>, m&ecirc;me si elle fait
      r&eacute;f&eacute;rence au m&ecirc;me h&ocirc;te que le serveur).</p>

  </section>

  <section id="custom"><title>Personnalisation des messages d'erreur</title>


	<p>Si vous faites pointer votre directive
	<code>ErrorDocument</code> vers certains gestionnaires
	dynamiques comme les inclusions c&ocirc;t&eacute; serveur, les scripts CGI ou
	d'autres gestionnaires, vous pouvez utiliser les variables
	d'environnement suppl&eacute;mentaires disponibles pour personnaliser
	le message.</p>


      <p>Si la directive ErrorDname-basedocument sp&eacute;cifie une redirection locale
      vers un script CGI, ce dernier doit ajouter un en-t&ecirc;te
      "<code>Status:</code>" dans sa sortie afin de s'assurer du bon
      acheminement jusqu'au client de la condition d'erreur qui a
      provoqu&eacute; cette redirection. Par exemple, un script Perl sp&eacute;cifi&eacute;
      par une directive ErrorDocument pourrait contenir ce qui suit
      :</p>

      <highlight language="perl">
...
print  "Content-type: text/html\n"; <br />
printf "Status: %s Condition Intercepted\n", $ENV{"REDIRECT_STATUS"}; <br />
...
      </highlight>

      <p>Si un script est d&eacute;di&eacute; &agrave; la gestion d'une condition d'erreur
      sp&eacute;cifique, telle que <code>404&nbsp;Not&nbsp;Found</code>, il
      peut utiliser le code et le texte de l'erreur sp&eacute;cifiques &agrave; la
      place.</p>

      <p>Notez que si la r&eacute;ponse contient un en-t&ecirc;te
      <code>Location:</code> (afin d'initier une redirection c&ocirc;t&eacute;
      client), le script <em>doit</em> &eacute;mettre un en-t&ecirc;te appropri&eacute;
      (comme <code>302&nbsp;Found</code>). Dans le cas contraire,
      l'en-t&ecirc;te <code>Location:</code> ne produira aucun effet.</p>
  </section>

  <section id="multi-lang"><title>Messages d'erreur personnalis&eacute;s
  multilingues</title>

    <p>Vous trouverez dans la distribution du serveur HTTP Apache un
    r&eacute;pertoire contenant des messages d'erreur personnalis&eacute;s traduits en
    16 langues diff&eacute;rentes. Pour activer cette fonctionnalit&eacute;, vous
    pouvez aussi inclure un fichier de configuration qui se trouve dans
    le r&eacute;pertoire de configuration <code>conf/extra</code>.</p>

    <p>Dans le fichier de configuration de votre serveur, vous trouverez
    un groupe de lignes du style :</p>

    <highlight language="config">
    # Multi-language error messages<br />
    #Include conf/extra/httpd-multilang-errordoc.conf
    </highlight>

    <p>D&eacute;commentez la ligne <code>Include</code> pour activer cette
    fonctionnalit&eacute;, et pr&eacute;senter des messages d'erreur dont le langage
    sera n&eacute;goci&eacute; en fonction du langage pr&eacute;f&eacute;r&eacute; d&eacute;fini au niveau du
    navigateur du client.</p>

    <p>De plus, ces documents contiennent diverses variables
    <code>REDIRECT_</code>, de fa&ccedil;on &agrave; ce que l'utilisateur final
    dispose d'informations suppl&eacute;mentaires &agrave; propos de ce qui a pu se
    produire, et de ce qu'il est susceptible de faire maintenant.</p>

    <p>Ces documents peuvent &ecirc;tre personnalis&eacute;s en fournissant autant
    d'informations utiles que vous le souhaitez aux utilisateurs &agrave;
    propos de votre site, et de ce qu'ils sont susceptibles d'y trouver.</p>

    <p>Pour pouvoir utiliser cette fonctionnalit&eacute;, vous devez activer
    <module>mod_include</module> et <module>mod_negotiation</module>.</p>

 </section>


</manualpage>
