<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.en.xsl"?>
<!-- English Revision : 1334024 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_reflector.xml.meta">

<name>mod_reflector</name>
<description>R&eacute;fl&eacute;chit un corps de requ&ecirc;te comme r&eacute;ponse via la pile de
filtres en sortie.</description>
<status>Base</status>
<sourcefile>mod_reflector.c</sourcefile>
<identifier>reflector_module</identifier>
<compatibility>Versions 2.3 et ult&eacute;rieures</compatibility>

<summary>
    <p>Ce module permet de renvoyer un corps de requ&ecirc;te au client, apr&egrave;s
    l'avoir fait passer par la pile de filtres en sortie. Une cha&icirc;ne de
    filtres configur&eacute;e de mani&egrave;re appropri&eacute;e peut &ecirc;tre utilis&eacute;e pour
    transformer la requ&ecirc;te en r&eacute;ponse. Ce module peut ainsi &ecirc;tre utilis&eacute;
    pour transformer un filtre en sortie en service HTTP.</p>
</summary>

<section id="examples"><title>Exemples</title>
    <dl>
    <dt>Service de compression</dt>
    <dd>Fait passer le corps de la requ&ecirc;te par le filtre DEFLATE pour le
    compresser. Cette requ&ecirc;te n&eacute;cessite un en-t&ecirc;te Content-Encoding
    contenant la valeur "gzip" pour que le filtre renvoie les donn&eacute;es
    compress&eacute;es.
    <highlight language="config">
&lt;Location /compress&gt;
    SetHandler reflector
    SetOutputFilter DEFLATE
&lt;/Location&gt;
    </highlight>
    </dd>

    <dt>Service d'abaissement de l'&eacute;chantillonnage d'image</dt>
    <dd>Fait passer le corps de la requ&ecirc;te par un filtre d'abaissement
    de l'&eacute;chantillonnage d'image, et renvoie le r&eacute;sultat au client.
    <highlight language="config">
&lt;Location /downsample&gt;
    SetHandler reflector
    SetOutputFilter DOWNSAMPLE
&lt;/Location&gt;
    </highlight>
    </dd>
    </dl>
</section>

<directivesynopsis>
<name>ReflectorHeader</name>
<description>R&eacute;fl&eacute;chit un en-t&ecirc;te d'entr&eacute;e dans les en-t&ecirc;tes de sortie</description>
<syntax>ReflectorHeader <var>en-t&ecirc;te-entr&eacute;e</var> <var>[en-t&ecirc;te-sortie]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
    <p>Cette directive permet de contr&ocirc;ler la r&eacute;percution des en-t&ecirc;tes
    de la requ&ecirc;te dans la r&eacute;ponse. Le premier argument correspond au nom
    de l'en-t&ecirc;te &agrave; copier. Si le second argument (optionnel) est
    sp&eacute;cifi&eacute;, il d&eacute;finit le nom sous lequel l'en-t&ecirc;te sera r&eacute;percut&eacute;
    dans la r&eacute;ponse ; dans le cas contraire, c'est le nom de l'en-t&ecirc;te
    original qui sera utilis&eacute;.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
