<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1296925 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="configure.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

  <title>configure - Configure l'arborescence des sources</title>

<summary>
    <p>Le script <code>configure</code> permet de configurer
    l'arborescence des sources afin de compiler et installer le serveur
    HTTP Apache sur votre plate-forme sp&eacute;cifique. De nombreuses options
    vous permettent de compiler un serveur correspondant &agrave; vos propres
    besoins.</p>

    <p>Ce script, situ&eacute; dans le r&eacute;pertoire racine de la distribution des
    sources, ne concerne que la compilation sur les syst&egrave;mes Unix et
    apparent&eacute;s. Pour les autres plates-formes, voir la <a
    href="../platform/">documentation sp&eacute;cifique</a> de ces
    derni&egrave;res.</p>
</summary>

<seealso><a href="../install.html">Compilation et installation</a></seealso>

<section id="synopsis"><title>R&eacute;sum&eacute;</title>
    <p>Vous devez appeler le script <code>configure</code> depuis le
    r&eacute;pertoire racine de la distribution.</p>

    <p><code><strong>./configure</strong> [<var>OPTION</var>]...
    [<var>VARIABLE</var>=<var>VALEUR</var>]...</code></p>

    <p>Pour d&eacute;finir des variables d'environnement (par exemple
    <code>CC</code>,<code>CFLAGS</code>, etc...), utilisez la clause
    <code><var>VARIABLE</var>=<var>VALEUR</var></code>. Voir <a
    href="#env">ci-dessous</a> pour la description de quelques variables
    usuelles.</p>
</section>

<section id="options"><title>Options</title>
  <ul>
    <li><a href="#configurationoptions">Options de Configuration</a></li>
    <li><a href="#installationdirectories">R&eacute;pertoires d'installation</a></li>
    <li><a href="#systemtypes">Types de Syst&egrave;mes</a></li>
    <li><a href="#optionalfeatures">Fonctionnalit&eacute;s optionnelles</a></li>
    <li><a href="#supportopt">Options pour les programmes support</a></li>
  </ul>

  <section id="configurationoptions"><title>Options de Configuration</title>

    <p>Les options suivantes affectent le comportement du script
    <code>configure</code>.</p>

    <dl>
      <dt><code>-C</code></dt>
      <dt><code>--config-cache</code></dt>
      <dd>C'est un alias pour <code>--cache-file=config.cache</code></dd>

      <dt><code>--cache-file=<var>FICHIER</var></code></dt>
      <dd>Les r&eacute;sultats des tests seront mis en cache dans le fichier
      <var>FICHIER</var>. Cette option est d&eacute;sactiv&eacute;e par d&eacute;faut.</dd>

      <dt><code>-h</code></dt>
      <dt><code>--help [short|recursive]</code></dt>
      <dd>Affichage de l'aide et sortie du script. Avec l'argument
      <code>short</code>, seules les options sp&eacute;cifiques &agrave; ce paquet
      seront affich&eacute;es. L'argument <code>recursive</code> permet
      d'afficher l'aide de tous les paquets inclus.</dd>

      <dt><code>-n</code></dt>
      <dt><code>--no-create</code></dt>
      <dd>Le script <code>configure</code> s'ex&eacute;cute normalement, mais
      ne cr&eacute;e pas les fichiers r&eacute;sultants. Ceci permet de v&eacute;rifier les
      r&eacute;sultats des tests avant de g&eacute;n&eacute;rer les fichiers makefile pour la
      compilation.</dd>

      <dt><code>-q</code></dt>
      <dt><code>--quiet</code></dt>
      <dd>Les messages <code>checking ...</code> ne sont pas affich&eacute;s au
      cours du processus de configuration.</dd>

      <dt><code>--srcdir=<var>DIR</var></code></dt>
      <dd>D&eacute;finit le r&eacute;pertoire <var>DIR</var> comme r&eacute;pertoire des
      fichiers sources. Par d&eacute;faut, c'est le r&eacute;pertoire o&ugrave; se situe le
      script <code>configure</code>, ou le r&eacute;pertoire parent.</dd>

      <dt><code>--silent</code></dt>
      <dd>Identique &agrave; <code>--quiet</code></dd>

      <dt>-V</dt>
      <dt>--version</dt>
      <dd>Affichage des informations de copyright et sortie du
      script.</dd>
    </dl>
  </section>

  <section id="installationdirectories"><title>R&eacute;pertoires
  d'installation</title>

    <p>Ces options permettent de sp&eacute;cifier le r&eacute;pertoire d'installation.
    L'arborescence de l'installation d&eacute;pend de l'organisation (layout)
    s&eacute;lectionn&eacute;e.</p>

    <dl>
      <dt><code>--prefix=<var>PREFIX</var></code></dt>
      <dd>Installe les fichiers ind&eacute;pendants de l'architecture dans
      <var>PREFIX</var>. Par d&eacute;faut, le r&eacute;pertoire d'installation est
      <code>/usr/local/apache2</code>.</dd>

      <dt><code>--exec-prefix=<var>EPREFIX</var></code></dt>
      <dd>Installe les fichiers d&eacute;pendants de l'architecture dans
      <var>EPREFIX</var>. La valeur par d&eacute;faut de cette option
      correspond &agrave; la valeur d&eacute;finie par l'option
      <code>--prefix</code>.</dd>
    </dl>

    <p>Par d&eacute;faut, <code>make install</code> va installer tous les
    fichiers dans <code>/usr/local/apache2/bin</code>,
    <code>/usr/local/apache2/lib</code>, etc... Vous pouvez cependant
    sp&eacute;cifier un pr&eacute;fixe d'installation autre que
    <code>/usr/local/apache2</code> en utilisant l'option
    <code>--prefix</code> (par exemple <code>--prefix=$HOME</code>).</p>

    <section id="layout"><title>Sp&eacute;cifier une organisation (layout) des
    r&eacute;pertoires</title>
      <dl>
        <dt><code>--enable-layout=<var>LAYOUT</var></code></dt>
        <dd>Configure le code source et les scripts de compilation de
	fa&ccedil;on &agrave; ce que l'arborescence d'installation adopte
	l'organisation <var>LAYOUT</var>. Ceci vous permet de sp&eacute;cifier
	des chemins s&eacute;par&eacute;s pour chaque type de fichier de
	l'installation du serveur HTTP Apache. Le fichier
	<code>config.layout</code> contient de nombreux exemples de
	configurations, et vous pouvez cr&eacute;er vos propres configurations
	personnalis&eacute;es en vous basant sur ces exemples. Les diff&eacute;rentes
	organisations contenues dans ce fichier sont enregistr&eacute;es sous
	forme de sections <code>&lt;Layout
	FOO&gt;...&lt;/Layout&gt;</code> et r&eacute;f&eacute;renc&eacute;es dans ce cas par
	le nom <code>FOO</code>. L'organisation par d&eacute;faut
	est <code>Apache</code>.</dd>
      </dl>
    </section>

    <section id="directoryfinetuning"><title>Configuration avanc&eacute;e des
    r&eacute;pertoires d'installation</title>

      <p>Pour une d&eacute;finition plus pr&eacute;cise des r&eacute;pertoires
      d'installation, utilisez les options ci-dessous. Notez que les
      r&eacute;pertoires par d&eacute;faut sont d&eacute;finis par <code>autoconf</code>, et
      que leurs valeurs sont &eacute;cras&eacute;es par les valeurs correspondantes
      d&eacute;finies lors du choix de l'organisation des r&eacute;pertoires
      (layout).</p>

      <dl>
        <dt><code>--bindir=<var>DIR</var></code></dt>
        <dd>Installe les ex&eacute;cutables utilisateur dans <var>DIR</var>.
	Les ex&eacute;cutables utilisateur sont des programmes support comme
	<program>htpasswd</program>, <program>dbmmanage</program>,
	etc..., et destin&eacute;s aux administrateurs du site. Par d&eacute;faut,
	<var>DIR</var> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/bin</code>.</dd>

        <dt><code>--datadir=<var>DIR</var></code></dt>
        <dd>Installe les donn&eacute;es non modifiables ind&eacute;pendantes de
	l'architecture dans <var>DIR</var>. Par d&eacute;faut,
	<code>datadir</code> est d&eacute;fini &agrave;
	<code><var>PREFIX</var>/share</code>. Cette option est fournie
	par autoconf et actuellement inutilis&eacute;e.</dd>

        <dt><code>--includedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-t&ecirc;tes C dans <var>DIR</var>. Par
	d&eacute;faut, <code>includedir</code> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/include</code>.</dd>

        <dt><code>--infodir=<var>DIR</var></code></dt>
        <dd>Installe la documentation info dans <var>DIR</var>. Par
	d&eacute;faut, <code>infodir</code> est d&eacute;fini &agrave;
	<code><var>PREFIX</var>/info</code>. Cette option est
	actuellement inutilis&eacute;e.</dd>

        <dt><code>--libdir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers objet des biblioth&egrave;ques dans
	<var>DIR</var>. Par d&eacute;faut, <code>libdir</code> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/lib</code>.</dd>

        <dt><code>--libexecdir=<var>DIR</var></code></dt>
        <dd>Installe les ex&eacute;cutables du programme (autrement dit les
	modules partag&eacute;s) dans <var>DIR</var>. Par d&eacute;faut,
	<code>libexecdir</code> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/modules</code>.</dd>

        <dt><code>--localstatedir=<var>DIR</var></code></dt>
        <dd>Installe les donn&eacute;es temporaires modifiables sp&eacute;cifiques &agrave;
	la machine dans
	<var>DIR</var>. Par d&eacute;faut, <code>localstatedir</code> est
	d&eacute;fini &agrave; <code><var>PREFIX</var>/var</code>. Cette option est
	fournie par <code>autoconf</code> et est actuellement
	inutilis&eacute;e.</dd>

        <dt><code>--mandir=<var>DIR</var></code></dt>
        <dd>Installe les pages de manuel dans  <var>DIR</var>. Par
	d&eacute;faut, <code>mandir</code> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/man</code>.</dd>

        <dt><code>--oldincludedir=<var>DIR</var></code></dt>
        <dd>Installe les fichiers d'en-t&ecirc;tes C pour les programmes
	autres que gcc dans <var>DIR</var>. Par d&eacute;faut,
	<code>oldincludedir</code> est d&eacute;fini &agrave;
	<code>/usr/include</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilis&eacute;e.</dd>

        <dt><code>--sbindir=<var>DIR</var></code></dt>
        <dd>Installe les ex&eacute;cutables de l'administrateur syst&egrave;me dans
	<var>DIR</var>. Ce sont les programmes du serveur comme
	<program>httpd</program>, <program>apachectl</program>,
	<program>suexec</program>, etc..., qui sont n&eacute;cessaires &agrave;
	l'ex&eacute;cution du serveur HTTP Apache. Par d&eacute;faut,
	<code>sbindir</code> est d&eacute;fini &agrave;
	<code><var>EPREFIX</var>/sbin</code>.</dd>

        <dt><code>--sharedstatedir=<var>DIR</var></code></dt>
        <dd>Installe les donn&eacute;es modifiables ind&eacute;pendantes de
	l'architecture dans <var>DIR</var>. Par d&eacute;faut,
	<code>sharedstatedir</code> est d&eacute;fini &agrave;
	<code><var>PREFIX</var>/com</code>. Cette option est fournie par
	<code>autoconf</code> et est actuellement inutilis&eacute;e.</dd>

        <dt><code>--sysconfdir=<var>DIR</var></code></dt>
        <dd>Installe les donn&eacute;es non modifiables sp&eacute;cifiques &agrave; la
	machine comme les fichiers de configuration du serveur
	<code>httpd.conf</code>, <code>mime.types</code>, etc... dans
	<var>DIR</var>. Par d&eacute;faut, <code>sysconfdir</code> est d&eacute;fini &agrave;
	<code><var>PREFIX</var>/conf</code>.</dd>
      </dl>
    </section>
  </section>

  <section id="systemtypes"><title>Types de syst&egrave;mes</title>

    <p>Ces options sont utilis&eacute;es pour la compilation crois&eacute;e du serveur
    HTTP Apache afin de pouvoir l'utiliser sur une autre plateforme mat&eacute;rielle.
    Dans le cas g&eacute;n&eacute;ral o&ugrave; la compilation et l'ex&eacute;cution du serveur ont lieu sur
    le m&ecirc;me syst&egrave;me, ces options ne sont pas utilis&eacute;es.</p>

    <dl>
      <dt><code>--build=<var>BUILD</var></code></dt>
      <dd>D&eacute;finit le type du syst&egrave;me sur lequel les outils sont
      compil&eacute;s. Par d&eacute;faut, il s'agit de la cha&icirc;ne renvoy&eacute;e par le
      script <code>config.guess</code>.</dd>

      <dt><code>--host=<var>HOST</var></code></dt>
      <dd>D&eacute;finit le type du syst&egrave;me sur lequel le serveur s'ex&eacute;cutera.
      Par d&eacute;faut, <var>HOST</var> est identique &agrave; <var>BUILD</var>.</dd>

      <dt><code>--target=<var>TARGET</var></code></dt>
      <dd>Configure les compilateurs de build pour le type de
      syst&egrave;me <var>TARGET</var>. Par d&eacute;faut, <var>TARGET</var> est
      identique &agrave; <var>HOST</var>. Cette option est fournie par
	<code>autoconf</code> et n'est pas requise par le serveur HTTP
	Apache.</dd>
    </dl>
  </section>

  <section id="optionalfeatures"><title>Fonctionnalit&eacute;s
  optionnelles</title>

    <p>Ces options vous permettent de configurer avec pr&eacute;cision les
    fonctionnalit&eacute;s de votre futur serveur HTTP.</p>

    <section id="generaloptfeat"><title>Syntaxe g&eacute;n&eacute;rale</title>
      <p>D'une mani&egrave;re g&eacute;n&eacute;rale, vous pouvez utiliser la syntaxe
      suivante pour activer ou d&eacute;sactiver une fonctionnalit&eacute; :</p>

      <dl>
        <dt><code>--disable-<var>FONCTIONNALITE</var></code></dt>
        <dd>D&eacute;sactive la fonctionnalit&eacute; <var>FONCTIONNALITE</var>.
	Identique &agrave;
	<code>--enable-<var>FONCTIONNALITE</var>=no</code>.</dd>

        <dt><code>--enable-<var>FONCTIONNALITE</var>[=<var>ARG</var>]</code></dt>
        <dd>Active la fonctionnalit&eacute; <var>FONCTIONNALITE</var>. La
	valeur par d&eacute;faut de <var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--enable-<var>MODULE</var>=shared</code></dt>
        <dd>Le module sp&eacute;cifi&eacute; sera compil&eacute; en tant que module DSO. Par
	d&eacute;faut, les modules activ&eacute;s sont li&eacute;s dynamiquement.</dd>

        <dt><code>--enable-<var>MODULE</var>=static</code></dt>
        <dd>Le module correspondant sera li&eacute; statiquement.</dd>
      </dl>

      <note><title>Note</title>
        Si vous sp&eacute;cifiez <code>--enable-<var>foo</var></code>, et si
	<var>foo</var> n'existe pas, <code>configure</code> ne le
	signalera pas ; vous devez donc prendre soin de taper les
	options correctement.
      </note>
    </section>

    <section id="choosemodules"><title>Choix des modules &agrave; compiler</title>
      <p>La plupart des modules sont compil&eacute;s par d&eacute;faut et ils doivent &ecirc;tre
      d&eacute;sactiv&eacute;s de mani&egrave;re explicite ou via les mots-cl&eacute;s
      <code>few</code> ou <code>none</code> (voir ci-dessous
      <code>--enable-modules</code>, <code>--enable-mods-shared</code>
      et <code>--enable-mods-static</code> pour une explication plus
      d&eacute;taill&eacute;e).</p>

      <p>Par d&eacute;faut, les autres modules ne sont pas compil&eacute;s et doivent
      &ecirc;tre activ&eacute;s explicitement, ou en utilisant les mots-cl&eacute;s
      <code>all</code> ou <code>reallyall</code> pour &ecirc;tre disponibles.</p>

      <p>Pour d&eacute;terminer quels modules sont compil&eacute;s par d&eacute;faut,
      ex&eacute;cutez la commande <code>./configure -h</code> ou
      <code>./configure --help</code>, et consultez les <code>Optional
      Features</code>. Par exemple, supposons que vous soyez int&eacute;ress&eacute;
      par les modules <module>mod_example1</module> et
      <module>mod_example2</module>, et que vous voyiez ceci :</p>

        <example><pre>Optional Features:
  ...
  --disable-example1     example module 1
  --enable-example2      example module 2
  ...</pre></example>

        <p>Le module <code>mod_example1</code> est ici activ&eacute; par
	d&eacute;faut, et vous devez sp&eacute;cifier <code>--disable-example1</code>
	si vous ne voulez pas le compiler. Par contre, le module
	<code>mod_example2</code> est d&eacute;sactiv&eacute; par d&eacute;faut, et vous
	devez sp&eacute;cifier <code>--enable-example2</code> si vous voulez le
	compiler.</p>

    </section>

    <section id="mpms"><title>Modules Multi-Processus</title>
      <p>Les <a href="../mpm.html">Modules Multi-Processus</a>, ou MPMs,
      constituent le coeur du serveur. Un et un seul MPM doit &ecirc;tre actif pour
      que le serveur puisse fonctionner. Vous trouverez la liste des
      MPMs disponibles &agrave; la <a href="../mod/">page d'index des modules</a>.</p>

      <p>Les MPMs peuvent &ecirc;tre compil&eacute;s en tant que modules DSO pour un
      chargement dynamique, ou li&eacute;s statiquement avec le serveur, et
      sont activ&eacute;s via les options suivantes :</p>

      <dl>
        <dt><code>--with-mpm=MPM</code></dt>
        <dd>
          <p>S&eacute;lectionne le MPM par d&eacute;faut pour votre serveur. Si les
	  MPMs sont compil&eacute;s en tant que modules DSO (voir
	  <code>--enable-mpms-shared</code>), cette option sp&eacute;cifie le
	  MPM qui sera charg&eacute; par d&eacute;faut selon le fichier de
	  configuration. Dans le cas contraire, cette option sp&eacute;cifie le
	  seul MPM disponible qui sera li&eacute; statiquement avec le
	  serveur.</p>
          <p>Si cette option est omise, c'est le <a
	  href="../mpm.html#defaults">MPM par d&eacute;faut</a> pour votre
	  syst&egrave;me d'exploitation qui sera utilis&eacute;.</p>
        </dd>

        <dt><code>--enable-mpms-shared=<var>Liste de MPM</var></code></dt>
        <dd>
          <p>D&eacute;finit une liste de MPMs &agrave; compiler en tant que modules
	  dynamiquement partag&eacute;s (DSO). Un de ces modules doit &ecirc;tre
	  charg&eacute; dynamiquement via la directive <directive
	  module="mod_so">LoadModule</directive>.</p>
          <p><var>Liste de MPM</var> est une liste, entour&eacute;e
	  d'apostrophes,  de noms de MPM s&eacute;par&eacute;s par des espaces. Par
	  exemple :</p>
          <example>
            --enable-mpms-shared='prefork worker'
          </example>
          <p>Vous pouvez aussi utiliser le mot-cl&eacute; <code>all</code>, ce
	  qui aura pour effet de sp&eacute;cifier tous les MPMs qui supportent
	  le chargement dynamique sur la plate-forme consid&eacute;r&eacute;e, et de
	  les compiler en tant que modules DSO. Par exemple :</p>
          <example>
            --enable-mpms-shared=all
          </example>
	</dd>
      </dl>
    </section>

    <section id="modules"><title>Modules tiers</title>
      <p>Pour ajouter des modules tiers, utilisez les options suivantes
      :</p>

      <dl>
        <dt><code>--with-module=<var>type-module</var>:<var>fichier-module</var>[,
          <var>type-module</var>:<var>fichier-module</var>]</code></dt>
        <dd><p>Ajoute un ou plusieurs modules tiers &agrave; la liste des
	modules li&eacute;s statiquement. Le fichier source du module
	<var>fichier-module</var> sera recherch&eacute; dans le sous-r&eacute;pertoire
	<var>type-module</var> de l'arborescence des sources de votre
	serveur HTTP Apache. S'il ne l'y trouve pas,
	<code>configure</code> consid&egrave;rera <var>fichier-module</var>
	comme un chemin de fichier absolu et essaiera de copier le
	fichier source dans le sous-r&eacute;pertoire <var>type-module</var>.
	Si ce sous-r&eacute;pertoire n'existe pas, il sera cr&eacute;&eacute; et un fichier
	<code>Makefile.in</code> standard y sera enregistr&eacute;.</p>
          <p>Cette option est con&ccedil;ue pour ajouter de petits modules
	  externes ne comportant qu'un seul fichier source. Pour des
	  modules plus complexes, vous devrez lire la documentation du
	  fournisseur du module.</p>
          <note><title>Note</title>
            Si vous voulez compiler un module DSO (li&eacute; de mani&egrave;re
	    dynamique au lieu de statique), utilisez le programme
	    <program>apxs</program>.</note>
        </dd>

      </dl>
    </section>

    <section id="otheroptfeat"><title>Options cumulatives et autres
    options</title>
      <dl>
        <dt><code>--enable-maintainer-mode</code></dt>
        <dd>Active les avertissements de d&eacute;bogage et de compilation et
	charge tous les modules compil&eacute;s.</dd>

        <dt><code>--enable-mods-shared=<var>LISTE-MODULES</var></code></dt>
        <dd>
          <p>D&eacute;finit une liste de modules &agrave; activer et &agrave; compiler en
	  tant que modules dynamiques partag&eacute;s. Cela signifie que ces
	  modules doivent &ecirc;tre charg&eacute;s dynamiquement en utilisant la
	  directive <directive
	  module="mod_so">LoadModule</directive>.</p>
          <p><var>LISTE-MODULES</var> est une liste, entour&eacute;e
	  d'apostrophes, de noms de modules
	  s&eacute;par&eacute;s par des espaces. Les noms
	  des modules sont sp&eacute;cifi&eacute;s sans le pr&eacute;fixe <code>mod_</code>.
	  Par exemple :</p>
          <example>
            --enable-mods-shared='headers rewrite dav'
          </example>
          <p>Vous pouvez aussi utiliser les mots-cl&eacute;s <code>reallyall</code>,
	  <code>all</code>, <code>most</code>, <code>few</code> et
	  <code>none</code>. Par exemple,</p>
          <example>
            --enable-mods-shared=most
          </example>
          <p>va compiler la plupart des modules en tant que modules DSO,</p>
	  <example>
            --enable-mods-shared=few
          </example>
          <p>ne compilera qu'un jeu de modules de base.</p>
          <p>Le jeu par d&eacute;faut correspond au mot-cl&eacute; <code>most</code>.</p>
            <!-- See <a href="../install/enabledmodules.html">Overview of
              enabled modules</a> for further information. -->
	  <p>Les directives <directive
	  module="mod_so">LoadModule</directive> correspondant aux
	  diff&eacute;rents modules choisis sont automatiquement g&eacute;n&eacute;r&eacute;es dans
	  le fichier de configuration principal. Par d&eacute;faut, toutes ces
	  directives sont mises en commentaire, sauf pour les modules
	  requis ou ceux explicitement s&eacute;lectionn&eacute;s par un argument
	  <code>--enable-nom-module</code> du script configure. Vous
	  pouvez modifier le jeu de modules charg&eacute; en activant ou
	  d&eacute;sactivant les directives <directive
	  module="mod_so">LoadModule</directive> dans le fichier
	  <code>httpd.conf</code>. En outre, les directives <directive
	  module="mod_so">LoadModule</directive> peuvent &ecirc;tre activ&eacute;es
	  pour tous les modules compil&eacute;s via l'option
	  <code>--enable-load-all-modules</code> du script configure.</p>
          <p><strong>Avertissement :</strong>
          <code>--enable-mods-shared=all</code> ne compile pas vraiment
	  tous les modules. En fait, pour compiler tous les modules, il
	  faut utiliser :</p>
          <example>
            ./configure \<br />
            <indent>
                --with-ldap \<br />
                --enable-mods-shared="all ssl ldap cache proxy authn_alias file_cache authnz_ldap charset_lite dav_lock disk_cache"
            </indent>
          </example>
        </dd>

        <dt><code>--enable-mods-static=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option produit le m&ecirc;me effet que l'option
	<code>--enable-mods-shared</code>, &agrave; l'exception que les modules
	seront li&eacute;s statiquement. Cela signifie que les modules
	sp&eacute;cifi&eacute;s seront toujours disponibles au cours du fonctionnement
	de <program>httpd</program>. Ils n'ont pas besoin d'&ecirc;tre charg&eacute;s
	via la directive <directive
	module="mod_so">LoadModule</directive>.</dd>

	<dt><code>--enable-modules=<var>MODULE-LIST</var></code></dt>
        <dd>Cette option se comporte comme
	<code>--enable-mods-shared</code>, et va &eacute;galement lier les modules
	concern&eacute;s dynamiquement. Le mot-cl&eacute; sp&eacute;cial <code>none</code>
	d&eacute;sactive la compilation de tous les modules.</dd>

        <dt><code>--enable-v4-mapped</code></dt>
        <dd>Permet aux sockets IPv6 de traiter les connexions IPv4.</dd>

        <dt><code>--with-port=<var>PORT</var></code></dt>
        <dd>Permet de d&eacute;finir le port TCP sur lequel le programme
	<program>httpd</program> va &eacute;couter. Ce num&eacute;ro de port est
	utilis&eacute; lors de la g&eacute;n&eacute;ration du fichier de configuration
	<code>httpd.conf</code>. Sa valeur par d&eacute;faut est 80.</dd>

        <dt><code>--with-program-name</code></dt>
        <dd>Permet de d&eacute;finir un nom d'ex&eacute;cutable alternatif. Le nom par
	d&eacute;faut est <code>httpd</code>.</dd>
      </dl>
    </section>
  </section>

  <section id="packages"><title>Paquets optionnels</title>
    <p>Ces options permettent de d&eacute;finir des paquets optionnels.</p>

    <section id="generalpackages"><title>Syntaxe g&eacute;n&eacute;rale</title>
      <p>D'une mani&egrave;re g&eacute;n&eacute;rale, vous pouvez utiliser la syntaxe
      suivante pour d&eacute;finir un paquet optionnel :</p>

      <dl>
        <dt><code>--with-<var>PAQUET</var>[=<var>ARG</var>]</code></dt>
        <dd>Utilise le paquet <var>PAQUET</var>. La valeur par d&eacute;faut de
	<var>ARG</var> est <code>yes</code>.</dd>

        <dt><code>--without-<var>PAQUET</var></code></dt>
        <dd>N'utilise pas le paquet <var>PAQUET</var>. Cette option est
	identique &agrave; <code>--with-<var>PAQUET</var>=no</code>. Elle est
	fournie par <code>autoconf</code> mais n'est pas tr&egrave;s utile pour
	le serveur HTTP Apache.</dd>
      </dl>
    </section>

    <!-- options not known are passed to packages?
    are there other important options for packages? -->

    <section id="packageopt"><title>Paquets sp&eacute;cifiques</title>
      <dl>
        <dt><code>--with-apr=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>La <glossary ref="apr">Biblioth&egrave;que pour la portabilit&eacute;
	d'Apache ou
	Apache Portable Runtime</glossary> (APR) fait partie de la
	distribution des sources de httpd et est compil&eacute;e
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	une APR d&eacute;j&agrave; install&eacute;e &agrave; la place, vous devez indiquer &agrave;
	<code>configure</code> le chemin du script
	<code>apr-config</code>. Vous pouvez sp&eacute;cifier le chemin absolu
	et le nom ou le r&eacute;pertoire d'installation de l'APR.
	<code>apr-config</code> doit se trouver dans ce r&eacute;pertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-apr-util=<var>REP</var>|<var>FICHIER</var></code></dt>
        <dd>Les utilitaires pour la Biblioth&egrave;que pour la portabilit&eacute;
	d'Apache ou Apache Portable Runtime Utilities (APU) font partie de la
	distribution des sources de httpd et sont compil&eacute;s
	automatiquement avec le serveur HTTP. Si vous voulez utiliser
	des APU d&eacute;j&agrave; install&eacute;s &agrave; la place, vous devez indiquer &agrave;
	<code>configure</code> le chemin du script
	<code>apu-config</code>. Vous pouvez sp&eacute;cifier le chemin absolu
	et le nom ou le r&eacute;pertoire d'installation des APU.
	<code>apu-config</code> doit se trouver dans ce r&eacute;pertoire ou
	dans le sous-repertoire <code>bin</code>.</dd>

        <dt><code>--with-ssl=<var>REP</var></code></dt>
        <dd>Si <module>mod_ssl</module> a &eacute;t&eacute; activ&eacute;,
	<code>configure</code> recherche une installation d'OpenSSL.
	Vous pouvez d&eacute;finir le r&eacute;pertoire de la bo&icirc;te &agrave; outils SSL/TLS &agrave;
	la place.</dd>

        <dt><code>--with-z=<var>REP</var></code></dt>
        <dd><code>configure</code> recherche automatiquement une
	biblioth&egrave;que <code>zlib</code> install&eacute;e si la configuration de
	vos sources en n&eacute;cessite une (par exemple lorsque
	<module>mod_deflate</module> est activ&eacute;). Vous pouvez d&eacute;finir le
	r&eacute;pertoire de la biblioth&egrave;que de compression &agrave; la place.</dd>
      </dl>

      <p>De nombreuses fonctionnalit&eacute;s du serveur HTTP Apache, y compris
      les directives <directive
      module="mod_rewrite">RewriteMap</directive> DBM de
      <module>mod_rewrite</module> et <module>mod_authn_dbm</module>
      utilisent une base de donn&eacute;es simple
      de la forme cl&eacute;/valeur pour une recherche rapide d'informations.
      SDBM, inclus dans les APU, est donc toujours disponible. Si vous
      souhaitez utiliser d'autres types de bases de donn&eacute;es, utilisez
      les options suivantes afin de les activer :</p>

      <dl>
        <dt><code>--with-gdbm[=<var>chemin</var>]</code></dt>
        <dd>Si aucun <var>chemin</var> n'est sp&eacute;cifi&eacute;,
	<code>configure</code> va rechercher les fichiers d'en-t&ecirc;tes et
	les biblioth&egrave;ques d'une installation DBM GNU dans les chemins
	standards. Avec un <var>chemin</var> explicite,
	<code>configure</code> recherchera les fichiers concern&eacute;s dans
	<code><var>chemin</var>/lib</code> et
	<code><var>chemin</var>/include</code>. En fait,
	<var>chemin</var> permet de sp&eacute;cifier plusieurs chemins
	d'en-t&ecirc;tes et biblioth&egrave;ques sp&eacute;cifiques en les s&eacute;parant par des
	caract&egrave;res ':'.</dd>

        <dt><code>--with-ndbm[=<var>chemin</var>]</code></dt>
        <dd>Identique &agrave; <code>--with-gdbm</code>, mais recherche une
	installation de New DBM.</dd>

        <dt><code>--with-berkeley-db[=<var>chemin</var>]</code></dt>
        <dd>Identique &agrave; <code>--with-gdbm</code>, mais recherche une
	installation de Berkeley DB.</dd>
      </dl>

      <note><title>Note</title>
        <p>Les options DBM sont fournies par les APU et pass&eacute;es en
	param&egrave;tres &agrave; son script de configuration. Elles sont inutiles
	lorsqu'on utilise des APU d&eacute;j&agrave; install&eacute;s d&eacute;finis par
	<code>--with-apr-util</code>.</p>
        <p>Vous pouvez utiliser plusieurs impl&eacute;mentations DBM avec votre
	serveur HTTP. Le type DBM appropri&eacute; sera choisi au cours de la
	configuration de l'ex&eacute;cution &agrave; chaque d&eacute;marrage.</p>
      </note>
    </section>
  </section>

  <section id="supportopt"><title>Options pour les programmes de
  support</title>
    <dl>
      <dt><code>--enable-static-support</code></dt>
      <dd>Permet de compiler une version des binaires de support li&eacute;s
      statiquement. En d'autres termes, la compilation produira un
      ex&eacute;cutable ind&eacute;pendant comportant toutes les biblioth&egrave;ques
      n&eacute;cessaires. Sans cette option, les binaires de supports sont li&eacute;s
      dynamiquement.</dd>

      <dt><code>--enable-suexec</code></dt>
      <dd>Utilisez cette option pour activer la programme
      <program>suexec</program>, qui vous permet de d&eacute;finir un uid et un
      gid pour les processus lanc&eacute;s. <strong>N'utilisez cette option que
      si vous ma&icirc;trisez toutes les implications en mati&egrave;re de s&eacute;curit&eacute;
      de l'ex&eacute;cution d'un binaire suid sur votre serveur.</strong>
      D'autres options permettent de configurer
      <program>suexec</program> comme d&eacute;crit <a
      href="#suexec">ci-dessous</a>.</dd>
    </dl>

    <p>Il est possible de lier statiquement le binaire d'un programme
    support particulier en utilisant les options suivantes :</p>

    <dl>
      <dt><code>--enable-static-ab</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme
      <program>ab</program>.</dd>

      <!-- missing documentation for chechgid -->
      <dt><code>--enable-static-checkgid</code></dt>
      <dd>>Compile une version li&eacute;e statiquement du programme
      <code>checkgid</code>.</dd>

      <dt><code>--enable-static-htdbm</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme <program>
        htdbm</program>.</dd>

      <dt><code>--enable-static-htdigest</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme <program>
        htdigest</program>.</dd>

      <dt><code>--enable-static-htpasswd</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme <program>
        htpasswd</program>.</dd>

      <dt><code>--enable-static-logresolve</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme <program>
        logresolve</program>.</dd>

      <dt><code>--enable-static-rotatelogs</code></dt>
      <dd>Compile une version li&eacute;e statiquement du programme <program>
        rotatelogs</program>.</dd>
    </dl>

    <section id="suexec">
      <title>Options de configuration de <code>suexec</code></title>
      <p>Les options suivantes permettent de d&eacute;finir avec pr&eacute;cision le
      comportement du programme <program>suexec</program>. Voir <a
        href="suexec.html#install">Configurer et installer suEXEC</a>
	pour plus de d&eacute;tails.</p>

      <dl>
        <dt><code>--with-suexec-bin</code></dt>
        <dd>D&eacute;finit le chemin du binaire <program>suexec</program>. La
	valeur par d&eacute;faut est <code>--sbindir</code> (voir <a
	href="#directoryfinetuning">D&eacute;finition pr&eacute;cise des r&eacute;pertoires
	d'installation</a>).</dd>

        <dt><code>--with-suexec-caller</code></dt>
        <dd>D&eacute;finit l'utilisateur qui a l'autorisation d'appeler
	<program>suexec</program>. Il est en g&eacute;n&eacute;ral souhaitable que ce
	soit le m&ecirc;me que celui sous lequel <program>httpd</program>
	s'ex&eacute;cute.</dd>

        <dt><code>--with-suexec-docroot</code></dt>
        <dd>D&eacute;finit l'arborescence des r&eacute;pertoires dans laquelle le
	lancement des ex&eacute;cutables via <program>suexec</program> est
	autoris&eacute;. La valeur par d&eacute;faut est
	<code>--datadir/htdocs</code>.</dd>

        <dt><code>--with-suexec-gidmin</code></dt>
        <dd>D&eacute;finit la valeur de GID la plus basse autoris&eacute;e comme
	valeur cible pour <program>suexec</program>. La valeur par
	d&eacute;faut est 100.</dd>

        <dt><code>--with-suexec-logfile</code></dt>
        <dd>D&eacute;finit le nom du fichier journal de
	<program>suexec</program>. La valeur par d&eacute;faut est
	<code>--logfiledir/suexec_log</code>.</dd>

        <dt><code>--with-suexec-safepath</code></dt>
        <dd>D&eacute;finit la valeur de la variable d'environnement
	<code>PATH</code> pour les processus lanc&eacute;s par
	<program>suexec</program>. La valeur par d&eacute;faut est
	<code>/usr/local/bin:/usr/bin:/bin</code>.</dd>

        <dt><code>--with-suexec-userdir</code></dt>
        <dd>D&eacute;finit le sous-r&eacute;pertoire du r&eacute;pertoire utilisateur qui
	contient tous les ex&eacute;cutables pouvant &ecirc;tre lanc&eacute;s par
	<program>suexec</program>. Cette option est n&eacute;cessaire si vous
	souhaitez utiliser <program>suexec</program> avec des
	r&eacute;pertoires utilisateurs (d&eacute;finis via
	<module>mod_userdir</module>). La valeur par d&eacute;faut est
	<code>public_html</code>.</dd>

        <dt><code>--with-suexec-uidmin</code></dt>
        <dd>D&eacute;finit la valeur d'UID la plus basse autoris&eacute;e comme
	valeur cible pour <program>suexec</program>. La valeur par
	d&eacute;faut est 100.</dd>

        <dt><code>--with-suexec-umask</code></dt>
        <dd>D&eacute;finit le masque de permissions <code>umask</code> pour les
	processus lanc&eacute;s par <program>suexec</program>. Il correspond
	par d&eacute;faut au masque d&eacute;fini par la configuration de votre
	syst&egrave;me.</dd>
      </dl>
    </section>
  </section>
</section>

<section id="env"><title>Variables d'environnement</title>
  <p>Certaines variables d'environnement permettent de modifier les
  choix effectu&eacute;s par <code>configure</code>, ou d'aider ce dernier &agrave;
  trouver les biblioth&egrave;ques et programmes poss&eacute;dant des noms et chemins
  non standards.</p>

  <!-- are these all useful variables? -->
  <dl>
    <dt><code>CC</code></dt>
    <dd>D&eacute;finit la commande du compilateur C &agrave; utiliser pour la
    compilation.</dd>

    <dt><code>CFLAGS</code></dt>
    <dd>D&eacute;finit les param&egrave;tres du compilateur C que vous voulez utiliser
    pour la compilation.</dd>

    <dt><code>CPP</code></dt>
    <dd>D&eacute;finit la commande du pr&eacute;processeur C &agrave; utiliser.</dd>

    <dt><code>CPPFLAGS</code></dt>
    <dd>D&eacute;finit les param&egrave;tres du pr&eacute;processeur C/C++, par exemple
    <code>-I<var>r&eacute;pertoire-include</var></code>, si certains de vos
    fichiers d'en-t&ecirc;tes se trouvent dans le r&eacute;pertoire non standard
    <var>r&eacute;pertoire-include</var>.</dd>

    <dt><code>LDFLAGS</code></dt>
    <dd>D&eacute;finit les param&egrave;tres de l'&eacute;diteur de liens, par exemple
    <code>-L<var>r&eacute;pertoire-lib</var></code>, si certaines de vos
    biblioth&egrave;ques se trouvent dans le r&eacute;pertoire non standard
    <var>r&eacute;pertoire-lib</var>.</dd>
  </dl>
</section>
</manualpage>
