<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1420732 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2013010601 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htdbm.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>htdbm - Manipuler des bases de donn&eacute;es DBM de mots de
passe</title>

<summary>
    <p><code>htdbm</code> permet de manipuler des fichiers au format DBM
    ou sont stock&eacute;s des nom d'utilisateurs et mots de passe &agrave; des fins
    d'authentification de base des utilisateurs HTTP via le module
    <module>mod_authn_dbm</module>. Voir la documentation de
    <program>dbmmanage</program> pour plus de d&eacute;tails &agrave; propos de ces
    fichiers DBM.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>dbmmanage</program></seealso>
<seealso><module>mod_authn_dbm</module></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>htdbm</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>b</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
    -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>n</strong>
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>nb</strong>
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>v</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>vb</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>x</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>l</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    </code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-b</code></dt>
    <dd>Utilise le mode batch ; en d'autres termes, le mot de passe est
    extrait de la ligne de commande au lieu d'&ecirc;tre demand&eacute; &agrave;
    l'op&eacute;rateur. Cette option doit &ecirc;tre utilis&eacute;e avec la plus grande
    prudence, car <strong>le mot de passe est visible en clair</strong>
    dans la ligne de commande. Pour utiliser un script, voir l'option
    <code>-i</code>.</dd>

    <dt><code>-i</code></dt>
    <dd>Lit le mot de passe depuis stdin sans v&eacute;rification (&agrave; utiliser
    dans le cadre d'un script).</dd>

    <dt><code>-c</code></dt>
    <dd>Cr&eacute;e le <var>fichier-mots-de-passe</var>. Si
    <var>fichier-mots-de-passe</var> existe d&eacute;j&agrave;, il est r&eacute;&eacute;crit et
    tronqu&eacute;. Cette option ne peut pas &ecirc;tre combin&eacute;e avec l'option
    <code>-n</code>.</dd>

    <dt><code>-n</code></dt>
    <dd>Affiche les r&eacute;sultats sur la sortie standard et ne met pas &agrave;
    jour la base de donn&eacute;es. Cette option modifie la syntaxe de la ligne
    de commande, car l'argument <var>fichier-mots-de-passe</var> (en
    g&eacute;n&eacute;ral le premier) est omis. Elle ne peut pas &ecirc;tre combin&eacute;e avec
    l'option <code>-c</code>.</dd>

    <dt><code>-m</code></dt>
    <dd>Utilise un chiffrement MD5 pour les mots de passe. Sous Windows
    et Netware, c'est l'option par d&eacute;faut..</dd>

    <dt><code>-B</code></dt>
    <dd>Utilise l'algorythme de chiffrement bcrypt pour les mots de
    passe. C'est un algorythme actuellement consid&eacute;r&eacute; comme s&ucirc;r.</dd>

    <dt><code>-C</code></dt>
    <dd>Ce drapeau n'est autoris&eacute; qu'en conjonction avec le drapeau
    <code>-B</code> (chiffrement bcrypt). Il permet de d&eacute;finir la dur&eacute;e
    de traitement pour l'algorythme de chiffrement bcrypt (plus elle est
    longue, plus la s&eacute;curit&eacute; est &eacute;lev&eacute;e, mais la rapidit&eacute; est diminu&eacute;e
    d'autant) ; la valeur par d&eacute;faut est 5, les valeurs valides vont de
    4 &agrave; 31.</dd>


    <dt><code>-d</code></dt>
    <dd>Utilise un chiffrement <code>crypt()</code> pour les mots de
    passe. C'est l'option par d&eacute;faut sur toutes les plates-formes, sauf
    Windows et Netware. Bien que <code>htdbm</code> supporte ce
    chiffrement sur toutes les plates-formes, il n'est pas support&eacute; par
    le serveur <program>httpd</program> sous Windows et Netware. Cet
    algorythme est consid&eacute;r&eacute; comme <strong>non s&ucirc;r</strong> selon les
    standards actuels.</dd>

    <dt><code>-s</code></dt>
    <dd>Utilise le chiffrement SHA pour les mots de passe. Facilite la
    migration vers/depuis les serveurs Netscape qui utilisent le format
    LDAP Directory Interchange (ldif). Cet
    algorythme est consid&eacute;r&eacute; comme <strong>non s&ucirc;r</strong> selon les
    standards actuels.</dd>

    <dt><code>-p</code></dt>
    <dd>Utilise des mots de passe au format texte en clair. Bien que
    <code>htdbm</code> supporte ce format sur toutes les plates-formes,
    le d&eacute;mon <program>httpd</program> n'accepte les mots de passe au
    format texte en clair que sous Windows et Netware.</dd>

    <dt><code>-l</code></dt>
    <dd>Affiche chaque nom d'utilisateur de la base de donn&eacute;es
    accompagn&eacute; de son commentaire sur la sortie standard.</dd>

    <dt><code>-v</code></dt>
    <dd>V&eacute;rifie une association nom d'utilisateur/mot de passe. Le
    programme affichera un message indiquant si le mot de passe fourni
    est valide. Si le mot de passe n'est pas valide, le programme
    s'arr&ecirc;te et renvoie un code d'erreur 3.</dd>

    <dt><code>-x</code></dt>
    <dd>Supprime l'utilisateur. Si le nom d'utilisateur existe dans le
    fichier DBM sp&eacute;cifi&eacute;, il sera supprim&eacute;.</dd>

    <dt><code>-t</code></dt>
    <dd>Interpr&egrave;te le dernier param&egrave;tre en tant que commentaire. Avec
    cette option, il est possible d'ajouter une cha&icirc;ne suppl&eacute;mentaire &agrave;
    la fin de la ligne de commande ; le contenu de cette cha&icirc;ne sera
    stock&eacute; dans la base de donn&eacute;es dans le champ "Comment" associ&eacute; au
    nom d'utilisateur sp&eacute;cifi&eacute;.</dd>

    <dt><code><var>nom-fichier</var></code></dt>
    <dd>Le nom du fichier au format DBM en g&eacute;n&eacute;ral sans l'extension
    <code>.db</code>, <code>.pag</code>, ou <code>.dir</code>. Avec
    l'option <code>-c</code>, le fichier DBM est mis &agrave; jour s'il existe
    ou cr&eacute;&eacute; dans le cas contraire.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>Le nom d'utilisateur &agrave; cr&eacute;er ou mettre &agrave; jour dans le
    <var>fichier-mots-de-passe</var>. Si <var>nom-utilisateur</var>
    n'existe pas dans ce fichier, une entr&eacute;e est ajout&eacute;e. S'il existe,
    son mot de passe est modifi&eacute;.</dd>

    <dt><code><var>mot-de-passe</var></code></dt>
    <dd>Le mot de passe en clair destin&eacute; &agrave; &ecirc;tre chiffr&eacute; et stock&eacute; dans
    le fichier DBM. Ne s'utilise qu'avec l'option <code>-b</code>.</dd>

    <dt><code>-T<var>DBTYPE</var></code></dt>
    <dd>Type de fichier DBM (SDBM, GDBM, DB, ou "default").</dd>
    </dl>
</section>

<section id="bugs"><title>Bugs</title>
    <p>Vous devez garder &agrave; l'esprit qu'il existe de nombreux formats de
    fichiers DBM diff&eacute;rents, et que selon toute vraisemblance, des
    biblioth&egrave;ques pour plus d'un format sont pr&eacute;sentes sur votre
    syst&egrave;me. Les trois exemples de base sont SDBM, NDBM, le projet GNU
    GDBM, et Berkeley/Sleepycat DB 2/3/4. Malheureusement, toutes ces
    biblioth&egrave;ques
    utilisent des formats de fichiers diff&eacute;rents, et vous devez vous
    assurer que le format de fichier utilis&eacute; par <var>nom-fichier</var>
    correspond au format attendu par <code>htdbm</code>.
    Actuellement, <code>htdbm</code> n'a aucun moyen de savoir &agrave;
    quel type de fichier DBM il a &agrave; faire. S'il est utilis&eacute; avec un
    format inappropri&eacute;, il ne renverra rien, ou pourra cr&eacute;er un fichier
    DBM diff&eacute;rent avec un nom diff&eacute;rent, ou au pire, va corrompre le
    fichier DBM si vous avez tent&eacute; de le modifier.</p>

    <p>Vous pouvez utiliser le programme <code>file</code> fourni par la
    plupart des syst&egrave;mes Unix pour d&eacute;terminer le format d'un fichier
    DBM.</p>
</section>

<section id="exit"><title>Valeur renvoy&eacute;e</title>
    <p><code>htdbm</code> renvoie 0 ("true") si les nom d'utilisateur et
    mot de passe ont &eacute;t&eacute; cr&eacute;&eacute;s ou mis &agrave; jour avec succ&egrave;s dans le fichier
    DBM. <code>htdbm</code> renvoie <code>1</code> s'il a rencontr&eacute; un
    probl&egrave;me d'acc&egrave;s aux fichiers, <code>2</code> si la ligne de
    commande comportait une erreur de syntaxe, <code>3</code> si le mot
    de passe a &eacute;t&eacute; fourni interactivement et s'il est invalide pour
    l'entr&eacute;e consid&eacute;r&eacute;e, <code>4</code> si l'op&eacute;ration a &eacute;t&eacute;
    interrompue, <code>5</code> si une valeur est trop longue (nom
    utilisateur, nom fichier, mot de passe, ou l'enregistrement apr&egrave;s
    son &eacute;laboration), <code>6</code> si le nom d'utilisateur contient
    des caract&egrave;res ill&eacute;gaux (voir la section <a
    href="#restrictions">Restrictions</a>), et <code>7</code> si le
    fichier n'est pas un fichier de mots de passe DBM valide.</p>
</section>

<section id="examples"><title>Exemples</title>
    <example>
      htdbm /usr/local/etc/apache/.utilisateurs-htdbm jsmith
    </example>

    <p>Ajoute ou modifie le mot de passe de l'utilisateur
    <code>jsmith</code>. Le mot de passe est demand&eacute; &agrave; l'op&eacute;rateur. Sous
    Windows, le mot de passe sera chiffr&eacute; en utilisant l'algorithme MD5
    Apache modifi&eacute; ; dans les autres cas, c'est la routine
    <code>crypt()</code> du syst&egrave;me qui sera utilis&eacute;e. Si le fichier
    n'existe pas, <code>htdbm</code> s'arr&ecirc;tera et renverra une
    erreur.</p>

    <example>
      htdbm -c /home/doe/public_html/.htdbm jane
    </example>

    <p>Cr&eacute;e un nouveau fichier et y enregistre une entr&eacute;e pour
    l'utilisateur <code>jane</code>. Le mot de passe est demand&eacute; &agrave;
    l'op&eacute;rateur. Si le fichier existe et ne peut pas &ecirc;tre lu, ou ne peut
    pas &ecirc;tre &eacute;crit, il ne sera pas modifi&eacute; et
    <code>htdbm</code> affichera un message et renverra un code
    d'erreur.</p>

    <example>
      htdbm -mb /usr/web/.htdbm-tous jones Pwd4Steve
    </example>

    <p>Chiffre le mot de passe entr&eacute; avec la ligne de commande
    (<code>Pwd4Steve</code>) &agrave; l'aide de l'algorithme MD5, et
    l'enregistre dans le fichier sp&eacute;cifi&eacute;.</p>
</section>

<section id="security"><title>Consid&eacute;rations &agrave; propos de s&eacute;curit&eacute;</title>
    <p>Les fichiers de mots de passe Web tels que ceux que g&egrave;re
    <code>htdbm</code> ne doivent <em>pas</em> &ecirc;tre stock&eacute;s dans
    l'espace d'URI du serveur Web -- en d'autres termes, il ne doit pas
    &ecirc;tre possible d'y acc&eacute;der &agrave; l'aide d'un navigateur.</p>

    <p>L'utilisation de l'option <code>-b</code> est d&eacute;conseill&eacute;e, car
    lorsqu'il est utilis&eacute;, le mot de passe appara&icirc;t en clair dans la
    ligne de commande.</p>

    <p>Notez que lorsque vous utilisez l'algorythme
    <code>crypt()</code>, seuls les 8 premiers caract&egrave;res du mot de
    passe sont pris en compte. Si le mot de passe fourni est plus long,
    les caract&egrave;res suppl&eacute;mentaires seront ignor&eacute;s sans avertissement.</p>

    <p>L'algorythme SHA ne permet pas de sp&eacute;cifier une valeur
    d'initialisation pour la g&eacute;n&eacute;ration de nombres al&eacute;atoires (salting)
    : un mot de passe donn&eacute; ne poss&egrave;de ainsi qu'une r&eacute;pr&eacute;sentation
    chiffr&eacute;e. Les algorythmes <code>crypt()</code> et MD5 permettent quant &agrave;
    eux des repr&eacute;sentations chiffr&eacute;es multiples en acceptant comme
    param&egrave;tre une cha&icirc;ne d'initialisation (salt), rendant les attaques &agrave;
    base de dictionnaires contre les mots de passe plus difficiles.</p>

    <p>Les algorythmes SHA et <code>crypt()</code> sont consid&eacute;r&eacute;s comme
    non s&ucirc;rs selon les standards actuels.</p>
</section>

<section id="restrictions"><title>Restrictions</title>
    <p>Sur la plate-forme Windows, les mots de passe chiffr&eacute;s avec
    <code>htdbm</code> ont une taille limit&eacute;e &agrave; <code>255</code>
    caract&egrave;res. Si le mot de passe fourni est plus long, il sera tronqu&eacute;
    &agrave; 255 caract&egrave;res.</p>

    <p>L'algorithme MD5 utilis&eacute; par <code>htdbm</code> est sp&eacute;cifique &agrave;
    Apache ; les mots de passe chiffr&eacute;s en utilisant cet algorithme
    seront inutilisables sur d'autres serveurs Web.</p>

    <p>Les noms d'utilisateurs ont une taille limit&eacute;e &agrave; <code>255</code>
    octets et ne doivent pas contenir de caract&egrave;re <code>:</code>.</p>
</section>

</manualpage>
