%define apxs apxs24
%define httpd httpd24

%define reltag GA

Name: mod_security
Summary: Open Source Web Application Firewall
Version: 2.8.0
Release: 6.%{reltag}%{?dist}
License: Apache License, Version 2.0

# https://www.modsecurity.org/tarball/2.8.0/modsecurity-2.8.0.tar.gz
# mv mod_security-2.8.0.tar.gz mod_security-2.8.0.tar.gz.orig
# mv modsecurity-2.8.0 mod_security-2.8.0
# tar czf mod_security-2.8.0.tgz mod_security-2.8.0
Source0: %{name}-%{version}.tgz

Group: Development/Libraries

BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

%if "%{?rhel}" == "7"
# 64 bit only natives on RHEL7
ExcludeArch: i386 i686
%endif

%if "%{?rhel}" == "6"
BuildRequires: perl
BuildRequires: zip
%endif

BuildRequires: libtool
BuildRequires: %{httpd}-devel
BuildRequires: curl-devel
BuildRequires: libxml2-devel
BuildRequires: apr-devel
BuildRequires: apr-util-devel
BuildRequires: pcre-devel

Requires: %{httpd}
#win-buildrequires: xbuild
#win-buildrequires: httpd
#win-buildrequires: curl
#win-buildrequires: pcre
#win-buildrequires: libxml2
#win-buildrequires: lua

#unx-buildrequires: httpd
#unx-buildrequires: openssl
#unx-buildrequires: curl
#unx-buildrequires: pcre
#unx-buildrequires: libxml2
#unx-buildrequires: lua

%description
Open Source Web Application Firewall

%if %with zip
%package src-zip
Summary:     Container for the source distribution of mod_security
Group:       Development

%description src-zip
Container for the source distribution of mod_security.
%endif

%prep
%setup -q -n %{name}-%{version}

#Create src zip to include any patches
%if %with zip
zip -q -r %{name}-%{version}-src.zip *
%endif

%build
APXS=`which %{apxs}` sh ./configure
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_libdir}/%{httpd}/modules/ \
         $RPM_BUILD_ROOT%{_sysconfdir}/%{httpd}/conf.d
mkdir -p $RPM_BUILD_ROOT%{_bindir}

# cp apache2/.libs/*.so $RPM_BUILD_ROOT%{_libdir}/%{httpd}/modules/
cp apache2/.libs/*.so $RPM_BUILD_ROOT%{_libdir}/%{httpd}/modules/
cp mlogc/mlogc $RPM_BUILD_ROOT%{_bindir}
cp mlogc/mlogc-batch-load.pl $RPM_BUILD_ROOT%{_bindir}

%if %with zip
mkdir -p $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev
cp %{name}-%{version}-src.zip $RPM_BUILD_ROOT%{_javadir}/jbossas-fordev/
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post

%preun

%files
%defattr(-,root,root,-)

# %config(noreplace) %{_sysconfdir}/httpd/conf.d/mod_snmp.conf.sample
# %config(noreplace) %{_sysconfdir}/httpd/conf.d/snmpd/snmpd.conf.sample
%{_libdir}/%{httpd}/modules/*.so
%{_bindir}/*

%if %with zip
%files src-zip
%defattr(-,root,root,-)
%{_javadir}/jbossas-fordev/*
%endif

%changelog
* Fri Apr  1 2016  Honza Fnukal <mturk@redhat.com> - 0:2.8.0-6
- Build for JWS 3.0.3.CR1

* Tue Aug 18 2015 Jean-Frederic Clere <jclere@redhat.com> - 0:2.8.0-5
- JWS-199 Apache HTTP rules updater is obsolete

* Mon Jul 13 2015 Mladen Turk <mturk@redhat.com> - 0:2.8.0-4
- ER2 rebuild.

* Mon Feb 23 2015 Mladen Turk <mturk@redhat.com> - 0:2.8.0-3
- Fix JWS-19

* Mon Nov 17 2014 Weinan Li <weli@redhat.com> - 0:2.8.0-2
- Rebuild to enable zip across all platforms

* Tue Oct 21 2014 Weinan Li <weli@redhat.com> - 0:2.8.0-1
- Initial import
