package org.apache.catalina.filters;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.annotation.WebFilter;

/*
 *  This is a sample servlet filter to disallow requests with "Proxy" http header
 */
public class PoxyFilter implements Filter {

    protected FilterConfig filterConfig;
    
    public void init(FilterConfig fConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {

        HttpServletRequest httpRequest = (HttpServletRequest) req;
        Enumeration<String> headerNames = httpRequest.getHeaderNames();


        if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = headerNames.nextElement();
                    if(headerName.equalsIgnoreCase("Proxy"))
                        ((HttpServletResponse) res).sendError(HttpServletResponse.SC_BAD_REQUEST);
                }
        }

        chain.doFilter(req, res);
    }
}
