package org.jboss.errai.cdi.event.client;

import org.jboss.errai.cdi.client.event.FinishEvent;
import org.jboss.errai.cdi.client.event.StartEvent;
import org.jboss.errai.cdi.client.qualifier.A;
import org.jboss.errai.cdi.client.qualifier.B;
import org.jboss.errai.cdi.client.qualifier.C;
import org.jboss.errai.enterprise.client.cdi.events.BusReadyEvent;

import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Test module used by {@see EventObserverIntegrationTest}.
 * 
 * @author Christian Sadilek <csadilek@redhat.com>
 */
@Dependent
public class DependentEventObserverTestModule extends EventTestObserverSuperClass {
  private final Map<String, List<String>> receivedQualifiedEvents = new HashMap<String, List<String>>();

  private int busReadyEventsReceived = 0;
  private Runnable verifier;
  private boolean destroyed;

  @Inject
  private Event<StartEvent> startEvent;

  @PreDestroy
  private void destroy() {
    destroyed = true;
  }

  public int getBusReadyEventsReceived() {
    return busReadyEventsReceived;
  }

  public Map<String, List<String>> getReceivedQualifiedEvents() {
    return receivedQualifiedEvents;
  }

  public Event<StartEvent> getStartEvent() {
    return startEvent;
  }

  public boolean isDestroyed() {
    return destroyed;
  }

  /**
   * count the {@link org.jboss.errai.enterprise.client.cdi.events.BusReadyEvent}
   */
  public void onBusReady(@Observes BusReadyEvent event) {
    busReadyEventsReceived++;
  }

  /**
   * start the event producers on the server
   */
  public void start() {
    startEvent.fire(new StartEvent());
  }

  @SuppressWarnings("unused")
  private void onEvent(@Observes String event) {
    addQualifiedReceivedEvent("", event);
  }
  
  public void onEventA(@Observes @A String event) {
    addQualifiedReceivedEvent("A", event);
  }

  public void onEventB(@Observes @B String event) {
    addQualifiedReceivedEvent("B", event);
  }

  public void onEventC(@Observes @C String event) {
    addQualifiedReceivedEvent("C", event);
  }

  public void onEventAB(@Observes @A @B String event) {
    addQualifiedReceivedEvent("AB", event);
  }

  public void onEventBA(@Observes @B @A String event) {
    addQualifiedReceivedEvent("BA", event);
  }

  public void onEventAC(@Observes @A @C String event) {
    addQualifiedReceivedEvent("AC", event);
  }

  public void onEventBC(@Observes @B @C String event) {
    addQualifiedReceivedEvent("BC", event);
  }

  public void onEventABC(@Observes @A @B @C String event) {
    addQualifiedReceivedEvent("ABC", event);
  }

  public void onFinish(@Observes FinishEvent event) {
    if (verifier != null) {
      verifier.run();
    }
  }

  public void setResultVerifier(Runnable verifier) {
    this.verifier = verifier;
  }
  
  private void addQualifiedReceivedEvent(String receiver, String event) {
    List<String> events = receivedQualifiedEvents.get(receiver);
    if (events == null)
      events = new ArrayList<String>();

    if (events.contains(event))
      throw new RuntimeException(receiver + " received " + event + " twice!");

    events.add(event);
    receivedQualifiedEvents.put(receiver, events);
  }
}