/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.model.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.sonatype.aether.ant.org.apache.maven.model.InputSource;
import org.sonatype.aether.ant.org.apache.maven.model.Model;
import org.sonatype.aether.ant.org.apache.maven.model.io.ModelParseException;
import org.sonatype.aether.ant.org.apache.maven.model.io.ModelReader;
import org.sonatype.aether.ant.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.sonatype.aether.ant.org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import org.sonatype.aether.ant.org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.ant.org.codehaus.plexus.util.IOUtil;
import org.sonatype.aether.ant.org.codehaus.plexus.util.ReaderFactory;
import org.sonatype.aether.ant.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelReader.class)
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input file missing");
        }
        Model model = this.read(new FileInputStream(input), options);
        model.setPomFile(input);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input reader missing");
        }
        try {
            Model model = this.read(input, this.isStrict(options), this.getSource(options));
            return model;
        }
        finally {
            IOUtil.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream missing");
        }
        try {
            Model model = this.read(ReaderFactory.newXmlReader(input), this.isStrict(options), this.getSource(options));
            return model;
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.sonatype.aether.ant.org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("org.sonatype.aether.ant.org.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private Model read(Reader reader, boolean strict, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict, source);
            }
            return new MavenXpp3Reader().read(reader, strict);
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }
}

