/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.jboss.netty.channel.group;

import java.net.SocketAddress;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.sonatype.aether.ant.org.jboss.netty.buffer.ChannelBuffer;
import org.sonatype.aether.ant.org.jboss.netty.channel.Channel;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFutureListener;
import org.sonatype.aether.ant.org.jboss.netty.channel.ServerChannel;
import org.sonatype.aether.ant.org.jboss.netty.channel.group.ChannelGroup;
import org.sonatype.aether.ant.org.jboss.netty.channel.group.ChannelGroupFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.group.CombinedIterator;
import org.sonatype.aether.ant.org.jboss.netty.channel.group.DefaultChannelGroupFuture;
import org.sonatype.aether.ant.org.jboss.netty.util.internal.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final ConcurrentMap<Integer, Channel> serverChannels = new ConcurrentHashMap<Integer, Channel>();
    private final ConcurrentMap<Integer, Channel> nonServerChannels = new ConcurrentHashMap<Integer, Channel>();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            DefaultChannelGroup.this.remove(future.getChannel());
        }
    };

    public DefaultChannelGroup() {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()));
    }

    public DefaultChannelGroup(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public Channel find(Integer id) {
        Channel c = (Channel)this.nonServerChannels.get(id);
        if (c != null) {
            return c;
        }
        return (Channel)this.serverChannels.get(id);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.nonServerChannels.containsKey(o) || this.serverChannels.containsKey(o);
        }
        if (o instanceof Channel) {
            Channel c = (Channel)o;
            if (o instanceof ServerChannel) {
                return this.serverChannels.containsKey(c.getId());
            }
            return this.nonServerChannels.containsKey(c.getId());
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        boolean added;
        ConcurrentMap<Integer, Channel> map = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl = added = map.putIfAbsent(channel.getId(), channel) == null;
        if (added) {
            channel.getCloseFuture().addListener(this.remover);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        Channel c = null;
        if (o instanceof Integer) {
            c = (Channel)this.nonServerChannels.remove(o);
            if (c == null) {
                c = (Channel)this.serverChannels.remove(o);
            }
        } else if (o instanceof Channel) {
            c = (Channel)o;
            c = c instanceof ServerChannel ? (Channel)this.serverChannels.remove(c.getId()) : (Channel)this.nonServerChannels.remove(c.getId());
        }
        if (c == null) {
            return false;
        }
        c.getCloseFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray(a);
    }

    @Override
    public ChannelGroupFuture close() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.getId(), c.close().awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.getId(), c.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture disconnect() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.getId(), c.disconnect().awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.getId(), c.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture setInterestOps(int interestOps) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.getId(), c.setInterestOps(interestOps).awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.getId(), c.setInterestOps(interestOps));
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture setReadable(boolean readable) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.getId(), c.setReadable(readable).awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.getId(), c.setReadable(readable));
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture unbind() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            futures.put(c.getId(), c.unbind().awaitUninterruptibly());
        }
        for (Channel c : this.nonServerChannels.values()) {
            futures.put(c.getId(), c.unbind());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture write(Object message) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)message;
            for (Channel c : this.nonServerChannels.values()) {
                futures.put(c.getId(), c.write(buf.duplicate()));
            }
        } else {
            for (Channel c : this.nonServerChannels.values()) {
                futures.put(c.getId(), c.write(message));
            }
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture write(Object message, SocketAddress remoteAddress) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)message;
            for (Channel c : this.nonServerChannels.values()) {
                futures.put(c.getId(), c.write(buf.duplicate(), remoteAddress));
            }
        } else {
            for (Channel c : this.nonServerChannels.values()) {
                futures.put(c.getId(), c.write(message, remoteAddress));
            }
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int compareTo(ChannelGroup o) {
        int v = this.getName().compareTo(o.getName());
        if (v != 0) {
            return v;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(name: " + this.getName() + ", size: " + this.size() + ')';
    }
}

