/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.execution;

import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMemoryAwareThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    private final ConcurrentMap<Object, Executor> childExecutors = this.newChildExecutorMap();

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, threadFactory);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, objectSizeEstimator, threadFactory);
    }

    protected ConcurrentMap<Object, Executor> newChildExecutorMap() {
        return new ConcurrentIdentityWeakKeyHashMap<Object, Executor>();
    }

    protected Object getChildExecutorKey(ChannelEvent e) {
        return e.getChannel();
    }

    protected Set<Object> getChildExecutorKeySet() {
        return this.childExecutors.keySet();
    }

    protected boolean removeChildExecutor(Object key) {
        return this.childExecutors.remove(key) != null;
    }

    @Override
    protected void doExecute(Runnable task) {
        if (!(task instanceof ChannelEventRunnable)) {
            this.doUnorderedExecute(task);
        } else {
            ChannelEventRunnable r = (ChannelEventRunnable)task;
            this.getChildExecutor(r.getEvent()).execute(task);
        }
    }

    private Executor getChildExecutor(ChannelEvent e) {
        Executor oldExecutor;
        Object key = this.getChildExecutorKey(e);
        Executor executor = (Executor)this.childExecutors.get(key);
        if (executor == null && (oldExecutor = this.childExecutors.putIfAbsent(key, executor = new ChildExecutor())) != null) {
            executor = oldExecutor;
        }
        if (e instanceof ChannelStateEvent) {
            Channel channel = e.getChannel();
            ChannelStateEvent se = (ChannelStateEvent)e;
            if (se.getState() == ChannelState.OPEN && !channel.isOpen()) {
                this.childExecutors.remove(channel);
            }
        }
        return executor;
    }

    @Override
    protected boolean shouldCount(Runnable task) {
        if (task instanceof ChildExecutor) {
            return false;
        }
        return super.shouldCount(task);
    }

    void onAfterExecute(Runnable r, Throwable t) {
        this.afterExecute(r, t);
    }

    private final class ChildExecutor
    implements Executor,
    Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();

        ChildExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable command) {
            boolean needsExecution;
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                needsExecution = this.tasks.isEmpty();
                this.tasks.add(command);
            }
            if (needsExecution) {
                OrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread = Thread.currentThread();
            while (true) {
                LinkedList<Runnable> linkedList;
                Object var6_5;
                Runnable task;
                LinkedList<Runnable> linkedList2 = this.tasks;
                synchronized (linkedList2) {
                    task = this.tasks.getFirst();
                }
                boolean ran = false;
                OrderedMemoryAwareThreadPoolExecutor.this.beforeExecute(thread, task);
                try {
                    try {
                        task.run();
                        ran = true;
                        OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task, null);
                    }
                    catch (RuntimeException e) {
                        if (ran) throw e;
                        OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task, e);
                        throw e;
                    }
                    var6_5 = null;
                    linkedList = this.tasks;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    linkedList = this.tasks;
                    synchronized (linkedList) {
                        this.tasks.removeFirst();
                        if (!this.tasks.isEmpty()) throw throwable;
                        return;
                    }
                }
                synchronized (linkedList) {
                    this.tasks.removeFirst();
                    if (this.tasks.isEmpty()) {
                        return;
                    }
                }
            }
        }
    }
}

