/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

final class BehaviorStack {
    private static final String BEHAVIOR_STACK = "org.richfaces.BehaviorStack";
    private LinkedList<BehaviorInfoImpl> behaviorStack = new LinkedList();

    public static BehaviorStack getBehaviorStack(FacesContext context, boolean createIfNull) {
        Map attributes = context.getAttributes();
        BehaviorStack behaviorStack = (BehaviorStack)attributes.get(BEHAVIOR_STACK);
        if (behaviorStack == null && createIfNull) {
            behaviorStack = new BehaviorStack();
            attributes.put(BEHAVIOR_STACK, behaviorStack);
        }
        return behaviorStack;
    }

    public boolean isEmpty() {
        return this.behaviorStack.isEmpty();
    }

    public void addBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        for (BehaviorInfoImpl behaviorInfo : this.behaviorStack) {
            behaviorInfo.addBehavior(context, behaviorHolder);
        }
    }

    void markWrapping() {
        if (!this.behaviorStack.isEmpty()) {
            BehaviorInfoImpl behaviorInfo = this.behaviorStack.getFirst();
            behaviorInfo.markWrapping();
        }
    }

    public void pushBehavior(FacesContext context, ClientBehavior clientBehavior, String behaviorId, String eventName) {
        Object behaviorState = ((StateHolder)clientBehavior).saveState(context);
        this.behaviorStack.addFirst(new BehaviorInfoImpl(behaviorId, eventName, behaviorState));
    }

    public BehaviorInfo popBehavior() {
        if (!this.behaviorStack.isEmpty()) {
            return this.behaviorStack.removeFirst();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BehaviorInfoImpl
    implements BehaviorInfo {
        private String behaviorId;
        private Object behaviorState;
        private String eventName;
        private List<ClientBehavior> behaviors;
        private boolean wrapping = false;

        public BehaviorInfoImpl(String behaviorId, String eventName, Object behaviorState) {
            this.behaviorId = behaviorId;
            this.eventName = eventName;
            this.behaviorState = behaviorState;
        }

        private void addBehavior(FacesContext context, ClientBehaviorHolder behaviorHolder) {
            String eventName = this.eventName;
            if (eventName == null && (eventName = behaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(behaviorHolder, eventName)) {
                ClientBehavior behavior = this.createBehavior(context);
                behaviorHolder.addClientBehavior(eventName, behavior);
            }
        }

        @Override
        public List<ClientBehavior> getBehaviors() {
            return this.behaviors;
        }

        @Override
        public boolean isWrapping() {
            return this.wrapping;
        }

        private void markWrapping() {
            this.wrapping = true;
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder behaviorHolder, String eventName) {
            if (!behaviorHolder.getEventNames().contains(eventName)) {
                return false;
            }
            Map clientBehaviorsMap = behaviorHolder.getClientBehaviors();
            List clientBehaviors = (List)clientBehaviorsMap.get(eventName);
            if (clientBehaviors == null || clientBehaviors.isEmpty()) {
                return true;
            }
            for (ClientBehavior behavior : clientBehaviors) {
                Set hints = behavior.getHints();
                if (!hints.contains(ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext context) {
            Application application = context.getApplication();
            ClientBehavior behavior = (ClientBehavior)application.createBehavior(this.behaviorId);
            ((StateHolder)behavior).restoreState(context, this.behaviorState);
            if (this.behaviors == null) {
                this.behaviors = new ArrayList<ClientBehavior>();
            }
            this.behaviors.add(behavior);
            return behavior;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface BehaviorInfo {
        public List<ClientBehavior> getBehaviors();

        public boolean isWrapping();
    }
}

