/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionBuildListener
implements BuildListener {
    private Document results;
    private Stack elementStack;
    private ThreadGroup group = Thread.currentThread().getThreadGroup();

    public ConnectionBuildListener() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.results = documentBuilder.newDocument();
        this.elementStack = new Stack();
        Element element = this.results.createElement("results");
        this.elementStack.push(element);
        this.results.appendChild(element);
    }

    public Document getDocument() {
        return this.results;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element element = (Element)this.elementStack.peek();
        Element element2 = this.results.createElement("target");
        element2.setAttribute("name", buildEvent.getTarget().getName());
        element.appendChild(element2);
        this.elementStack.push(element2);
    }

    public void targetFinished(BuildEvent buildEvent) {
        Throwable throwable;
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element element = (Element)this.elementStack.peek();
        String string = buildEvent.getMessage();
        if (string != null) {
            element.setAttribute("message", string);
        }
        if ((throwable = buildEvent.getException()) != null) {
            element.setAttribute("status", "failure");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            String string2 = throwable.getMessage();
            String string3 = byteArrayOutputStream.toString();
            Element element2 = this.results.createElement("error");
            Element element3 = this.results.createElement("message");
            element3.appendChild(this.results.createTextNode(string2));
            Element element4 = this.results.createElement("stack");
            element4.appendChild(this.results.createCDATASection(string3));
            element2.appendChild(element3);
            element2.appendChild(element4);
            element.appendChild(element2);
        } else {
            element.setAttribute("status", "success");
        }
        this.elementStack.pop();
    }

    public void taskStarted(BuildEvent buildEvent) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element element = (Element)this.elementStack.peek();
        Element element2 = this.results.createElement("task");
        element2.setAttribute("name", buildEvent.getTask().getTaskName());
        element.appendChild(element2);
        this.elementStack.push(element2);
    }

    public void taskFinished(BuildEvent buildEvent) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element element = (Element)this.elementStack.peek();
        Throwable throwable = buildEvent.getException();
        if (throwable != null) {
            element.setAttribute("status", "failure");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            String string = throwable.getMessage();
            String string2 = byteArrayOutputStream.toString();
            Element element2 = this.results.createElement("error");
            Element element3 = this.results.createElement("message");
            element3.appendChild(this.results.createTextNode(string));
            Element element4 = this.results.createElement("stack");
            element4.appendChild(this.results.createCDATASection(string2));
            element2.appendChild(element3);
            element2.appendChild(element4);
            element.appendChild(element2);
        } else {
            element.setAttribute("status", "success");
        }
        this.elementStack.pop();
    }

    public void messageLogged(BuildEvent buildEvent) {
    }
}

