/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.ant.org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.ant.org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.ant.org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.ant.org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.ant.org.sonatype.aether.util.artifact.DefaultArtifactType;
import org.sonatype.aether.ant.types.Exclusion;
import org.sonatype.aether.ant.types.Proxy;
import org.sonatype.aether.ant.types.RemoteRepositories;
import org.sonatype.aether.ant.types.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterUtils {
    private static Artifact toArtifact(org.sonatype.aether.ant.types.Dependency dependency, ArtifactTypeRegistry types) {
        ArtifactType type = types.get(dependency.getType());
        if (type == null) {
            type = new DefaultArtifactType(dependency.getType());
        }
        Map<String, String> props = null;
        if ("system".equals(dependency.getScope()) && dependency.getSystemPath() != null) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath().getPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, type);
        return artifact;
    }

    static Authentication toAuthentication(org.sonatype.aether.ant.types.Authentication auth) {
        if (auth == null) {
            return null;
        }
        return new Authentication(auth.getUsername(), auth.getPassword(), auth.getPrivateKeyFile(), auth.getPassphrase());
    }

    public static Dependency toDependency(org.sonatype.aether.ant.types.Dependency dependency, List<Exclusion> exclusions, RepositorySystemSession session) {
        return new Dependency(ConverterUtils.toArtifact(dependency, session.getArtifactTypeRegistry()), dependency.getScope(), false, ConverterUtils.toExclusions(dependency.getExclusions(), exclusions));
    }

    public static RemoteRepository toDistRepository(org.sonatype.aether.ant.types.RemoteRepository repo, RepositorySystemSession session) {
        RemoteRepository result = ConverterUtils.toRepository(repo);
        result.setAuthentication(session.getAuthenticationSelector().getAuthentication(result));
        result.setProxy(session.getProxySelector().getProxy(result));
        return result;
    }

    private static org.sonatype.aether.ant.org.sonatype.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.sonatype.aether.ant.org.sonatype.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), exclusion.getClassifier(), exclusion.getExtension());
    }

    private static Collection<org.sonatype.aether.ant.org.sonatype.aether.graph.Exclusion> toExclusions(Collection<Exclusion> exclusions1, Collection<Exclusion> exclusions2) {
        LinkedHashSet<org.sonatype.aether.ant.org.sonatype.aether.graph.Exclusion> results = new LinkedHashSet<org.sonatype.aether.ant.org.sonatype.aether.graph.Exclusion>();
        if (exclusions1 != null) {
            for (Exclusion exclusion : exclusions1) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        if (exclusions2 != null) {
            for (Exclusion exclusion : exclusions2) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        return results;
    }

    private static RepositoryPolicy toPolicy(RemoteRepository.Policy policy, boolean enabled, String updates, String checksums) {
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getChecksums() != null) {
                checksums = policy.getChecksums();
            }
            if (policy.getUpdates() != null) {
                updates = policy.getUpdates();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    static Properties addProperties(Properties props, Map<?, ?> map) {
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    static org.sonatype.aether.ant.org.sonatype.aether.repository.Proxy toProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        return new org.sonatype.aether.ant.org.sonatype.aether.repository.Proxy(proxy.getType(), proxy.getHost(), proxy.getPort(), ConverterUtils.toAuthentication(proxy.getAuthentication()));
    }

    private static RemoteRepository toRepository(org.sonatype.aether.ant.types.RemoteRepository repo) {
        RemoteRepository result = new RemoteRepository();
        result.setId(repo.getId());
        result.setContentType(repo.getType());
        result.setUrl(repo.getUrl());
        result.setPolicy(true, ConverterUtils.toPolicy(repo.getSnapshotPolicy(), repo.isSnapshots(), repo.getUpdates(), repo.getChecksums()));
        result.setPolicy(false, ConverterUtils.toPolicy(repo.getReleasePolicy(), repo.isReleases(), repo.getUpdates(), repo.getChecksums()));
        result.setAuthentication(ConverterUtils.toAuthentication(repo.getAuthentication()));
        return result;
    }

    static List<RemoteRepository> toRepositories(Project project, RepositorySystemSession session, RemoteRepositories repos, RemoteRepositoryManager remoteRepositoryManager) {
        List<org.sonatype.aether.ant.types.RemoteRepository> repositories = repos != null ? repos.getRepositories() : new ArrayList<org.sonatype.aether.ant.types.RemoteRepository>();
        List<RemoteRepository> results = new ArrayList<RemoteRepository>();
        for (org.sonatype.aether.ant.types.RemoteRepository repo : repositories) {
            results.add(ConverterUtils.toRepository(repo));
        }
        results = remoteRepositoryManager.aggregateRepositories(session, Collections.<RemoteRepository>emptyList(), results, true);
        return results;
    }
}

