/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.ant.org.apache.maven.model.Model;
import org.sonatype.aether.ant.org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.ant.org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.aether.ant.org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.ant.types.Artifact;
import org.sonatype.aether.ant.types.Pom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectWorkspaceReader
implements WorkspaceReader {
    private static ProjectWorkspaceReader instance;
    private static Object lock;
    private Map<String, File> artifacts = Collections.synchronizedMap(new HashMap());

    public void addPom(Pom pom) {
        if (pom.getFile() != null) {
            Model model = pom.getModel(pom);
            String coords = this.coords(new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, "pom", model.getVersion()));
            this.artifacts.put(coords, pom.getFile());
        }
    }

    public void addArtifact(Artifact artifact) {
        if (artifact.getPom() != null) {
            DefaultArtifact aetherArtifact;
            Pom pom = artifact.getPom();
            if (pom.getFile() != null) {
                Model model = pom.getModel(pom);
                aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), artifact.getClassifier(), artifact.getType(), model.getVersion());
            } else {
                aetherArtifact = new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), artifact.getClassifier(), artifact.getType(), pom.getVersion());
            }
            String coords = this.coords(aetherArtifact);
            this.artifacts.put(coords, artifact.getFile());
        }
    }

    private String coords(org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        buffer.append(':').append(artifact.getExtension());
        buffer.append(':').append(artifact.getClassifier());
        buffer.append(':').append(artifact.getVersion());
        return buffer.toString();
    }

    @Override
    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository("ant");
    }

    @Override
    public File findArtifact(org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact artifact) {
        return this.artifacts.get(this.coords(artifact));
    }

    @Override
    public List<String> findVersions(org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact artifact) {
        return Collections.emptyList();
    }

    ProjectWorkspaceReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectWorkspaceReader getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ProjectWorkspaceReader();
            }
            return instance;
        }
    }

    public static void dropInstance() {
        instance = null;
    }

    static {
        lock = new Object();
    }
}

