/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.consumers;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.sonatype.aether.ant.com.ning.http.client.BodyConsumer;

public class AppendableBodyConsumer
implements BodyConsumer {
    private final Appendable appendable;
    private final String encoding;

    public AppendableBodyConsumer(Appendable appendable, String encoding) {
        this.appendable = appendable;
        this.encoding = encoding;
    }

    public AppendableBodyConsumer(Appendable appendable) {
        this.appendable = appendable;
        this.encoding = "UTF-8";
    }

    public void consume(ByteBuffer byteBuffer) throws IOException {
        this.appendable.append(new String(byteBuffer.array(), this.encoding));
    }

    public void close() throws IOException {
        if (Closeable.class.isAssignableFrom(this.appendable.getClass())) {
            ((Closeable)Closeable.class.cast(this.appendable)).close();
        }
    }
}

