/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sonatype.aether.ant.org.apache.maven.settings.Activation;
import org.sonatype.aether.ant.org.apache.maven.settings.IdentifiableBase;
import org.sonatype.aether.ant.org.apache.maven.settings.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends IdentifiableBase
implements Serializable,
Cloneable {
    private Activation activation;
    private Properties properties;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;

    public void addPluginRepository(Repository repository) {
        this.getPluginRepositories().add(repository);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    @Override
    public Profile clone() {
        try {
            Profile copy = (Profile)super.clone();
            if (this.activation != null) {
                copy.activation = this.activation.clone();
            }
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            if (this.repositories != null) {
                copy.repositories = new ArrayList<Repository>();
                for (Repository item : this.repositories) {
                    copy.repositories.add(item.clone());
                }
            }
            if (this.pluginRepositories != null) {
                copy.pluginRepositories = new ArrayList<Repository>();
                for (Repository item : this.pluginRepositories) {
                    copy.pluginRepositories.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Activation getActivation() {
        return this.activation;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            this.pluginRepositories = new ArrayList<Repository>();
        }
        return this.pluginRepositories;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void removePluginRepository(Repository repository) {
        this.getPluginRepositories().remove(repository);
    }

    public void removeRepository(Repository repository) {
        this.getRepositories().remove(repository);
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

