/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelPipeline;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelSink;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.ServerSocketChannel;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.nio.NioServerSocketPipelineSink;
import org.sonatype.aether.ant.org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.sonatype.aether.ant.org.jboss.netty.util.internal.ExecutorUtil;

public class NioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;

    public NioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new NioServerSocketPipelineSink(workerExecutor, workerCount);
    }

    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new NioServerSocketChannel(this, pipeline, this.sink);
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

