/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.connector.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.PathUtils;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.TransferEventCatapult;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.TransferWrapper;
import org.sonatype.aether.ant.org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.ArtifactTransfer;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.ArtifactUpload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.MetadataTransfer;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.MetadataUpload;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.Transfer;
import org.sonatype.aether.ant.org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.ant.org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.ant.org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.ChecksumFailureException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.MetadataTransferException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.ant.org.sonatype.aether.transfer.TransferResource;
import org.sonatype.aether.ant.org.sonatype.aether.util.ChecksumUtils;
import org.sonatype.aether.ant.org.sonatype.aether.util.layout.MavenDefaultLayout;
import org.sonatype.aether.ant.org.sonatype.aether.util.layout.RepositoryLayout;
import org.sonatype.aether.ant.org.sonatype.aether.util.listener.DefaultTransferEvent;
import org.sonatype.aether.ant.org.sonatype.aether.util.listener.DefaultTransferResource;

class FileRepositoryWorker
implements Runnable {
    private Logger logger = NullLogger.INSTANCE;
    private FileProcessor fileProcessor;
    private static LinkedHashMap<String, String> checksumAlgos = new LinkedHashMap(4);
    private final RepositoryLayout layout = new MavenDefaultLayout();
    private TransferWrapper transfer;
    private final RemoteRepository repository;
    private final TransferEventCatapult catapult;
    private final Direction direction;
    private TransferResource resource;

    private FileRepositoryWorker(ArtifactTransfer transfer, RemoteRepository repository, Direction direction, RepositorySystemSession session) {
        this(session, repository, direction);
        if (transfer == null) {
            throw new IllegalArgumentException("Transfer may not be null.");
        }
        this.transfer = new TransferWrapper(transfer);
    }

    private FileRepositoryWorker(MetadataTransfer transfer, RemoteRepository repository, Direction direction, RepositorySystemSession session) {
        this(session, repository, direction);
        if (transfer == null) {
            throw new IllegalArgumentException("Transfer may not be null.");
        }
        this.transfer = new TransferWrapper(transfer);
    }

    public FileRepositoryWorker(ArtifactUpload transfer, RemoteRepository repository, RepositorySystemSession session) {
        this(transfer, repository, Direction.UPLOAD, session);
    }

    public FileRepositoryWorker(ArtifactDownload transfer, RemoteRepository repository, RepositorySystemSession session) {
        this(transfer, repository, Direction.DOWNLOAD, session);
    }

    public FileRepositoryWorker(MetadataDownload transfer, RemoteRepository repository, RepositorySystemSession session) {
        this(transfer, repository, Direction.DOWNLOAD, session);
    }

    public FileRepositoryWorker(MetadataUpload transfer, RemoteRepository repository, RepositorySystemSession session) {
        this(transfer, repository, Direction.UPLOAD, session);
    }

    private FileRepositoryWorker(RepositorySystemSession session, RemoteRepository repository, Direction direction) {
        if (repository == null) {
            throw new IllegalArgumentException("RemoteRepository may not be null.");
        }
        if (session == null) {
            throw new IllegalArgumentException("RepositorySystemSession may not be null.");
        }
        this.catapult = new TransferEventCatapult(session.getTransferListener());
        this.direction = direction;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block41: {
            target = null;
            totalTransferred = -1L;
            try {
                try {
                    this.transfer.setState(Transfer.State.ACTIVE);
                    this.resource = this.newResource(this.transfer, this.repository);
                    event = this.newEvent(this.transfer);
                    this.catapult.fireInitiated(event);
                    baseDir = new File(PathUtils.basedir(this.repository.getUrl()));
                    localFile = this.transfer.getFile();
                    repoFile = new File(baseDir, this.transfer.getRelativePath());
                    src = null;
                    switch (2.$SwitchMap$org$sonatype$aether$connector$file$FileRepositoryWorker$Direction[this.direction.ordinal()]) {
                        case 1: {
                            src = localFile;
                            target = repoFile;
                            break;
                        }
                        case 2: {
                            src = repoFile;
                            target = localFile;
                            break;
                        }
                    }
                    if (this.transfer.isExistenceCheck()) {
                        if (!src.exists()) {
                            throw new FileNotFoundException(src.getAbsolutePath());
                        }
                    } else {
                        tmp = this.tmpfile(target);
                        totalTransferred = this.copy(src, tmp);
                        this.fileProcessor.move(tmp, target);
                        switch (2.$SwitchMap$org$sonatype$aether$connector$file$FileRepositoryWorker$Direction[this.direction.ordinal()]) {
                            case 1: {
                                this.writeChecksum(src, target.getPath());
                                ** break;
                            }
                            case 2: {
                                this.verifyChecksum(src);
                                break;
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    switch (2.$SwitchMap$org$sonatype$aether$connector$file$TransferWrapper$Type[this.transfer.getType().ordinal()]) {
                        case 1: {
                            artEx /* !! */  = Direction.DOWNLOAD.equals((Object)this.direction) != false ? new ArtifactNotFoundException(this.transfer.getArtifact(), this.repository) : new ArtifactTransferException(this.transfer.getArtifact(), this.repository, e);
                            this.transfer.setException(artEx /* !! */ );
                            break;
                        }
                        case 2: {
                            mdEx /* !! */  = Direction.DOWNLOAD.equals((Object)this.direction) != false ? new MetadataNotFoundException(this.transfer.getMetadata(), this.repository) : new MetadataTransferException(this.transfer.getMetadata(), this.repository, e);
                            this.transfer.setException(mdEx /* !! */ );
                            break;
                        }
                    }
                    var11_14 = null;
                    this.transfer.setState(Transfer.State.DONE);
                    if (this.transfer.getException() == null) {
                        event = this.newEvent(this.transfer);
                        event.setTransferredBytes((int)totalTransferred);
                        this.catapult.fireSucceeded(event);
                        return;
                    }
                    if (this.direction.equals((Object)Direction.UPLOAD)) {
                        for (String ext : FileRepositoryWorker.checksumAlgos.values()) {
                            new File(target.getPath() + ext).delete();
                        }
                    }
                    if (target != null) {
                        target.delete();
                    }
                    event = this.newEvent(this.transfer);
                    this.catapult.fireFailed(event);
                    return;
                }
                catch (Throwable t) {
                    this.logger.debug(t.getMessage(), t);
                    switch (2.$SwitchMap$org$sonatype$aether$connector$file$TransferWrapper$Type[this.transfer.getType().ordinal()]) {
                        case 1: {
                            this.transfer.setException(new ArtifactTransferException(this.transfer.getArtifact(), this.repository, t));
                            break;
                        }
                        case 2: {
                            this.transfer.setException(new MetadataTransferException(this.transfer.getMetadata(), this.repository, t));
                            break;
                        }
                    }
                    var11_15 = null;
                    this.transfer.setState(Transfer.State.DONE);
                    if (this.transfer.getException() == null) {
                        event = this.newEvent(this.transfer);
                        event.setTransferredBytes((int)totalTransferred);
                        this.catapult.fireSucceeded(event);
                        return;
                    }
                    if (this.direction.equals((Object)Direction.UPLOAD)) {
                        for (String ext : FileRepositoryWorker.checksumAlgos.values()) {
                            new File(target.getPath() + ext).delete();
                        }
                    }
                    if (target != null) {
                        target.delete();
                    }
                    event = this.newEvent(this.transfer);
                    this.catapult.fireFailed(event);
                    return;
                }
lbl96:
                // 1 sources

                var11_13 = null;
                this.transfer.setState(Transfer.State.DONE);
                if (this.transfer.getException() != null) break block41;
                event = this.newEvent(this.transfer);
                event.setTransferredBytes((int)totalTransferred);
            }
            catch (Throwable var10_29) {
                var11_16 = null;
                this.transfer.setState(Transfer.State.DONE);
                if (this.transfer.getException() == null) {
                    event = this.newEvent(this.transfer);
                    event.setTransferredBytes((int)totalTransferred);
                    this.catapult.fireSucceeded(event);
                    throw var10_29;
                }
                if (this.direction.equals((Object)Direction.UPLOAD)) {
                    for (String ext : FileRepositoryWorker.checksumAlgos.values()) {
                        new File(target.getPath() + ext).delete();
                    }
                }
                if (target != null) {
                    target.delete();
                }
                event = this.newEvent(this.transfer);
                this.catapult.fireFailed(event);
                throw var10_29;
            }
            this.catapult.fireSucceeded(event);
            return;
        }
        if (this.direction.equals((Object)Direction.UPLOAD)) {
            for (String ext : FileRepositoryWorker.checksumAlgos.values()) {
                new File(target.getPath() + ext).delete();
            }
        }
        if (target != null) {
            target.delete();
        }
        event = this.newEvent(this.transfer);
        this.catapult.fireFailed(event);
    }

    private void writeChecksum(File src, String targetPath) throws IOException, Throwable {
        Map<String, Object> crcs = ChecksumUtils.calc(src, checksumAlgos.keySet());
        for (Map.Entry<String, Object> crc : crcs.entrySet()) {
            String name = crc.getKey();
            Object sum = crc.getValue();
            if (sum instanceof Throwable) {
                throw (Throwable)sum;
            }
            File crcTarget = new File(targetPath + checksumAlgos.get(name));
            FileWriter crcWriter = new FileWriter(crcTarget);
            crcWriter.write(sum.toString());
            crcWriter.close();
        }
    }

    private void verifyChecksum(File src) throws ChecksumFailureException, IOException, TransferCancelledException {
        if ("ignore".equals(this.transfer.getChecksumPolicy())) {
            return;
        }
        Map<String, Object> crcs = ChecksumUtils.calc(src, checksumAlgos.keySet());
        boolean verified = false;
        try {
            for (Map.Entry<String, String> entry : checksumAlgos.entrySet()) {
                try {
                    String sum = ChecksumUtils.read(new File(src.getPath() + entry.getValue()));
                    verified = sum.equalsIgnoreCase(crcs.get(entry.getKey()).toString());
                    if (!verified) {
                        throw new ChecksumFailureException(sum, crcs.get(entry.getKey()).toString());
                    }
                    break;
                }
                catch (IOException e) {
                }
            }
            if (!verified) {
                throw new ChecksumFailureException("no supported algorithms found");
            }
        }
        catch (ChecksumFailureException e) {
            if ("fail".equals(this.transfer.getChecksumPolicy())) {
                throw e;
            }
            DefaultTransferEvent event = this.newEvent(this.transfer);
            event.setException(e);
            this.catapult.fireCorrupted(event);
        }
    }

    private long copy(File src, File target) throws TransferCancelledException, IOException {
        if (src == null) {
            throw new IllegalArgumentException("source file not specified");
        }
        if (!src.isFile()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (target == null) {
            throw new IllegalArgumentException("target file not specified");
        }
        DefaultTransferEvent event = this.newEvent(this.transfer);
        this.catapult.fireStarted(event);
        return this.fileProcessor.copy(src, target, new FileProcessor.ProgressListener(){
            int total = 0;

            public void progressed(ByteBuffer buffer) throws IOException {
                this.total += buffer.remaining();
                DefaultTransferEvent event = FileRepositoryWorker.this.newEvent(FileRepositoryWorker.this.transfer);
                event.setDataBuffer(buffer).setTransferredBytes(this.total);
                try {
                    FileRepositoryWorker.this.catapult.fireProgressed(event);
                }
                catch (TransferCancelledException e) {
                    throw new IOException("Transfer was cancelled: " + e.getMessage());
                }
            }
        });
    }

    private DefaultTransferEvent newEvent(TransferWrapper transfer) {
        DefaultTransferEvent event = new DefaultTransferEvent();
        event.setResource(this.resource);
        event.setRequestType(this.direction.getType());
        event.setException(transfer.getException());
        return event;
    }

    private DefaultTransferResource newResource(TransferWrapper transfer, RemoteRepository repository) {
        String resourceName = null;
        switch (transfer.getType()) {
            case ARTIFACT: {
                Artifact artifact = transfer.getArtifact();
                resourceName = this.layout.getPath(artifact).getPath();
                break;
            }
            case METADATA: {
                Metadata metadata = transfer.getMetadata();
                resourceName = this.layout.getPath(metadata).getPath();
            }
        }
        return new DefaultTransferResource(PathUtils.decode(repository.getUrl()), resourceName, transfer.getFile(), transfer.getTrace());
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }

    private File tmpfile(File target) {
        return new File(target.getAbsolutePath() + ".tmp" + UUID.randomUUID().toString().replace("-", "").substring(0, 16));
    }

    static {
        checksumAlgos.put("SHA-1", ".sha1");
        checksumAlgos.put("MD5", ".md5");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        UPLOAD(TransferEvent.RequestType.PUT),
        DOWNLOAD(TransferEvent.RequestType.GET);

        TransferEvent.RequestType type;

        private Direction(TransferEvent.RequestType type) {
            this.type = type;
        }

        public TransferEvent.RequestType getType() {
            return this.type;
        }
    }
}

