// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

package cispolicy

import (
	"time"

	"k8s.io/apimachinery/pkg/types"
	"sigs.k8s.io/controller-runtime/pkg/client"
	"sigs.k8s.io/controller-runtime/pkg/reconcile"
)

var c client.Client

var LabelsMap = make(map[string]string)

var expectedRequest = reconcile.Request{NamespacedName: types.NamespacedName{Name: "foo", Namespace: "default"}}
var depKey = types.NamespacedName{Name: "foo-deployment", Namespace: "default"}

const timeout = time.Second * 5

/* func TestReconcile(t *testing.T) {
	os.Setenv("USE_FAKE", "true")
	LabelsMap["cluster-namespace"] = "managed-cluster"
	g := gomega.NewGomegaWithT(t)
	instance := &cisv1alpha1.CisPolicy{ObjectMeta: metav1.ObjectMeta{Name: "foo", Namespace: "default", Labels: LabelsMap}}

	expectedStatus := make(map[string]*cisv1alpha1.CisPerClusterStatus)

	masterNodeResults := make(map[string]cisv1alpha1.Result)
	masterNodeResults["1.1.1 Ensure that the --anonymous-auth argument is set to false"] = cisv1alpha1.Failed

	expectedStatus["managed-cluster"] = &cisv1alpha1.CisPerClusterStatus{
		ClusterName: "managed-cluster",
		Compliancy:  "NonCompliant",
		Risk: cisv1alpha1.RiskScore{
			HighestRiskScore:    6.4,
			CumulativeRiskScore: 6.4,
			RiskCategory:        "medium",
		},
	}

	// Setup the Manager and Controller.  Wrap the Controller Reconcile function so it writes each request to a
	// channel when it is finished.
	mgr, err := manager.New(cfg, manager.Options{})
	g.Expect(err).NotTo(gomega.HaveOccurred())
	c = mgr.GetClient()

	recFn, requests := SetupTestReconcile(newReconciler(mgr))
	g.Expect(add(mgr, recFn)).NotTo(gomega.HaveOccurred())

	stopMgr, mgrStopped := StartTestManager(mgr, g)

	defer func() {
		close(stopMgr)
		mgrStopped.Wait()
	}()

	// Create the CisPolicy object and expect the Reconcile and status to be updated
	err = c.Create(context.TODO(), instance)
	// The instance object may not be a valid object because it might be missing some required fields.
	// Please modify the instance object by adding required fields and then remove the following if statement.
	if apierrors.IsInvalid(err) {
		t.Logf("failed to create object, got an invalid object error: %v", err)
		return
	}
	g.Expect(err).NotTo(gomega.HaveOccurred())
	defer c.Delete(context.TODO(), instance)
	g.Eventually(requests, timeout).Should(gomega.Receive(gomega.Equal(expectedRequest)))

	// Create the CisPolicy object and expect the Reconcile and status to be updated
	err = c.Get(context.TODO(), types.NamespacedName{Name: "foo", Namespace: "default"}, instance)

	g.Expect(instance.Status.CisPolicyStatus["managed-cluster"]).To(gomega.Equal(expectedStatus["managed-cluster"]))
	/*
		deploy := &appsv1.Deployment{}
		g.Eventually(func() error { return c.Get(context.TODO(), depKey, deploy) }, timeout).
			Should(gomega.Succeed())

		// Delete the Deployment and expect Reconcile to be called for Deployment deletion
		g.Expect(c.Delete(context.TODO(), deploy)).NotTo(gomega.HaveOccurred())
		g.Eventually(requests, timeout).Should(gomega.Receive(gomega.Equal(expectedRequest)))
		g.Eventually(func() error { return c.Get(context.TODO(), depKey, deploy) }, timeout).
			Should(gomega.Succeed())

		// Manually delete Deployment since GC isn't enabled in the test control plane
		g.Expect(c.Delete(context.TODO(), deploy)).To(gomega.Succeed())

} */
