// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInstallationMediaInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies one or more installation media to describe. Supported
	// filters include the following:
	//
	//    * custom-availability-zone-id - Accepts custom Availability Zone (AZ)
	//    identifiers. The results list includes information about only the custom
	//    AZs identified by these identifiers.
	//
	//    * engine - Accepts database engines. The results list includes information
	//    about only the database engines identified by these identifiers. For more
	//    information about the valid engines for installation media, see ImportInstallationMedia.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// The installation medium ID.
	InstallationMediaId *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// An optional pagination token provided by a previous DescribeInstallationMedia
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeInstallationMediaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstallationMediaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstallationMediaInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeInstallationMediaOutput struct {
	_ struct{} `type:"structure"`

	// The list of InstallationMedia objects for the AWS account.
	InstallationMedia []InstallationMedia `locationNameList:"InstallationMedia" type:"list"`

	// An optional pagination token provided by a previous DescribeInstallationMedia
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstallationMediaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstallationMedia = "DescribeInstallationMedia"

// DescribeInstallationMediaRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Describes the available installation media for a DB engine that requires
// an on-premises customer provided license, such as Microsoft SQL Server.
//
//    // Example sending a request using DescribeInstallationMediaRequest.
//    req := client.DescribeInstallationMediaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeInstallationMedia
func (c *Client) DescribeInstallationMediaRequest(input *DescribeInstallationMediaInput) DescribeInstallationMediaRequest {
	op := &aws.Operation{
		Name:       opDescribeInstallationMedia,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstallationMediaInput{}
	}

	req := c.newRequest(op, input, &DescribeInstallationMediaOutput{})
	return DescribeInstallationMediaRequest{Request: req, Input: input, Copy: c.DescribeInstallationMediaRequest}
}

// DescribeInstallationMediaRequest is the request type for the
// DescribeInstallationMedia API operation.
type DescribeInstallationMediaRequest struct {
	*aws.Request
	Input *DescribeInstallationMediaInput
	Copy  func(*DescribeInstallationMediaInput) DescribeInstallationMediaRequest
}

// Send marshals and sends the DescribeInstallationMedia API request.
func (r DescribeInstallationMediaRequest) Send(ctx context.Context) (*DescribeInstallationMediaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstallationMediaResponse{
		DescribeInstallationMediaOutput: r.Request.Data.(*DescribeInstallationMediaOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeInstallationMediaRequestPaginator returns a paginator for DescribeInstallationMedia.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeInstallationMediaRequest(input)
//   p := rds.NewDescribeInstallationMediaRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeInstallationMediaPaginator(req DescribeInstallationMediaRequest) DescribeInstallationMediaPaginator {
	return DescribeInstallationMediaPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeInstallationMediaInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeInstallationMediaPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeInstallationMediaPaginator struct {
	aws.Pager
}

func (p *DescribeInstallationMediaPaginator) CurrentPage() *DescribeInstallationMediaOutput {
	return p.Pager.CurrentPage().(*DescribeInstallationMediaOutput)
}

// DescribeInstallationMediaResponse is the response type for the
// DescribeInstallationMedia API operation.
type DescribeInstallationMediaResponse struct {
	*DescribeInstallationMediaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstallationMedia request.
func (r *DescribeInstallationMediaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
