// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RejectPortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The type of shared portfolios to reject. The default is to reject imported
	// portfolios.
	//
	//    * AWS_ORGANIZATIONS - Reject portfolios shared by the master account of
	//    your organization.
	//
	//    * IMPORTED - Reject imported portfolios.
	//
	//    * AWS_SERVICECATALOG - Not supported. (Throws ResourceNotFoundException.)
	//
	// For example, aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk"
	// --portfolio-share-type AWS_ORGANIZATIONS
	PortfolioShareType PortfolioShareType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RejectPortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectPortfolioShareInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectPortfolioShareInput"}

	if s.PortfolioId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RejectPortfolioShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectPortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectPortfolioShare = "RejectPortfolioShare"

// RejectPortfolioShareRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Rejects an offer to share the specified portfolio.
//
//    // Example sending a request using RejectPortfolioShareRequest.
//    req := client.RejectPortfolioShareRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare
func (c *Client) RejectPortfolioShareRequest(input *RejectPortfolioShareInput) RejectPortfolioShareRequest {
	op := &aws.Operation{
		Name:       opRejectPortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectPortfolioShareInput{}
	}

	req := c.newRequest(op, input, &RejectPortfolioShareOutput{})
	return RejectPortfolioShareRequest{Request: req, Input: input, Copy: c.RejectPortfolioShareRequest}
}

// RejectPortfolioShareRequest is the request type for the
// RejectPortfolioShare API operation.
type RejectPortfolioShareRequest struct {
	*aws.Request
	Input *RejectPortfolioShareInput
	Copy  func(*RejectPortfolioShareInput) RejectPortfolioShareRequest
}

// Send marshals and sends the RejectPortfolioShare API request.
func (r RejectPortfolioShareRequest) Send(ctx context.Context) (*RejectPortfolioShareResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectPortfolioShareResponse{
		RejectPortfolioShareOutput: r.Request.Data.(*RejectPortfolioShareOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectPortfolioShareResponse is the response type for the
// RejectPortfolioShare API operation.
type RejectPortfolioShareResponse struct {
	*RejectPortfolioShareOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectPortfolioShare request.
func (r *RejectPortfolioShareResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
