/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package converters

import (
	"github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2018-10-01/compute"
	"sigs.k8s.io/cluster-api-provider-azure/pkg/apis/azureprovider/v1beta1"
)

// SDKToVM converts azure representation to internal representation
func SDKToVM(v compute.VirtualMachine) *v1beta1.VM {
	i := &v1beta1.VM{
		ID:   *v.ID,
		Name: *v.Name,

		// TODO: Add more conversions once types are updated.
		//Identity: string(v.Identity),
		//Tags: v.Tags,
		//State:    v1alpha1.VMState(*v.State.Name),
	}

	if v.VirtualMachineProperties != nil && v.VirtualMachineProperties.HardwareProfile != nil {
		i.VMSize = string(v.VirtualMachineProperties.HardwareProfile.VMSize)
	}

	/*
		if len(v.Tags) > 0 {
			i.Tags = TagsToMap(v.Tags)
		}
	*/

	return i
}
