// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterDeploymentLister helps list ClusterDeployments.
// All objects returned here must be treated as read-only.
type ClusterDeploymentLister interface {
	// List lists all ClusterDeployments in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterDeployment, err error)
	// ClusterDeployments returns an object that can list and get ClusterDeployments.
	ClusterDeployments(namespace string) ClusterDeploymentNamespaceLister
	ClusterDeploymentListerExpansion
}

// clusterDeploymentLister implements the ClusterDeploymentLister interface.
type clusterDeploymentLister struct {
	indexer cache.Indexer
}

// NewClusterDeploymentLister returns a new ClusterDeploymentLister.
func NewClusterDeploymentLister(indexer cache.Indexer) ClusterDeploymentLister {
	return &clusterDeploymentLister{indexer: indexer}
}

// List lists all ClusterDeployments in the indexer.
func (s *clusterDeploymentLister) List(selector labels.Selector) (ret []*v1.ClusterDeployment, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterDeployment))
	})
	return ret, err
}

// ClusterDeployments returns an object that can list and get ClusterDeployments.
func (s *clusterDeploymentLister) ClusterDeployments(namespace string) ClusterDeploymentNamespaceLister {
	return clusterDeploymentNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterDeploymentNamespaceLister helps list and get ClusterDeployments.
// All objects returned here must be treated as read-only.
type ClusterDeploymentNamespaceLister interface {
	// List lists all ClusterDeployments in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterDeployment, err error)
	// Get retrieves the ClusterDeployment from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.ClusterDeployment, error)
	ClusterDeploymentNamespaceListerExpansion
}

// clusterDeploymentNamespaceLister implements the ClusterDeploymentNamespaceLister
// interface.
type clusterDeploymentNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterDeployments in the indexer for a given namespace.
func (s clusterDeploymentNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterDeployment, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterDeployment))
	})
	return ret, err
}

// Get retrieves the ClusterDeployment from the indexer for a given namespace and name.
func (s clusterDeploymentNamespaceLister) Get(name string) (*v1.ClusterDeployment, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterdeployment"), name)
	}
	return obj.(*v1.ClusterDeployment), nil
}
