package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	etcdMetricServingCAConfigMapFileName = "etcd-metric-serving-ca-configmap.yaml.template"
)

var _ asset.WritableAsset = (*EtcdMetricServingCAConfigMap)(nil)

// EtcdMetricServingCAConfigMap is an asset for the etcd metric serving CA
type EtcdMetricServingCAConfigMap struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *EtcdMetricServingCAConfigMap) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *EtcdMetricServingCAConfigMap) Name() string {
	return "EtcdMetricServingCAConfigMap"
}

// Generate generates the actual files by this asset
func (t *EtcdMetricServingCAConfigMap) Generate(parents asset.Parents) error {
	fileName := etcdMetricServingCAConfigMapFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *EtcdMetricServingCAConfigMap) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *EtcdMetricServingCAConfigMap) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, etcdMetricServingCAConfigMapFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
