// Code generated by protoc-gen-go.
// source: api.proto
// DO NOT EDIT!

/*
Package v1alpha is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	ImageFormat
	Image
	Network
	App
	Pod
	KeyValue
	PodFilter
	ImageFilter
	GlobalFlags
	Info
	Event
	EventFilter
	GetInfoRequest
	GetInfoResponse
	ListPodsRequest
	ListPodsResponse
	InspectPodRequest
	InspectPodResponse
	ListImagesRequest
	ListImagesResponse
	InspectImageRequest
	InspectImageResponse
	ListenEventsRequest
	ListenEventsResponse
	GetLogsRequest
	GetLogsResponse
*/
package v1alpha

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// ImageType defines the supported image type.
type ImageType int32

const (
	ImageType_IMAGE_TYPE_UNDEFINED ImageType = 0
	ImageType_IMAGE_TYPE_APPC      ImageType = 1
	ImageType_IMAGE_TYPE_DOCKER    ImageType = 2
	ImageType_IMAGE_TYPE_OCI       ImageType = 3
)

var ImageType_name = map[int32]string{
	0: "IMAGE_TYPE_UNDEFINED",
	1: "IMAGE_TYPE_APPC",
	2: "IMAGE_TYPE_DOCKER",
	3: "IMAGE_TYPE_OCI",
}
var ImageType_value = map[string]int32{
	"IMAGE_TYPE_UNDEFINED": 0,
	"IMAGE_TYPE_APPC":      1,
	"IMAGE_TYPE_DOCKER":    2,
	"IMAGE_TYPE_OCI":       3,
}

func (x ImageType) String() string {
	return proto.EnumName(ImageType_name, int32(x))
}
func (ImageType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// AppState defines the possible states of the app.
type AppState int32

const (
	AppState_APP_STATE_UNDEFINED AppState = 0
	AppState_APP_STATE_RUNNING   AppState = 1
	AppState_APP_STATE_EXITED    AppState = 2
)

var AppState_name = map[int32]string{
	0: "APP_STATE_UNDEFINED",
	1: "APP_STATE_RUNNING",
	2: "APP_STATE_EXITED",
}
var AppState_value = map[string]int32{
	"APP_STATE_UNDEFINED": 0,
	"APP_STATE_RUNNING":   1,
	"APP_STATE_EXITED":    2,
}

func (x AppState) String() string {
	return proto.EnumName(AppState_name, int32(x))
}
func (AppState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// PodState defines the possible states of the pod.
// See https://github.com/coreos/rkt/blob/master/Documentation/devel/pod-lifecycle.md for a detailed
// explanation of each state.
type PodState int32

const (
	PodState_POD_STATE_UNDEFINED PodState = 0
	// States before the pod is running.
	PodState_POD_STATE_EMBRYO    PodState = 1
	PodState_POD_STATE_PREPARING PodState = 2
	PodState_POD_STATE_PREPARED  PodState = 3
	// State that indicates the pod is running.
	PodState_POD_STATE_RUNNING PodState = 4
	// States that indicates the pod is exited, and will never run.
	PodState_POD_STATE_ABORTED_PREPARE PodState = 5
	PodState_POD_STATE_EXITED          PodState = 6
	PodState_POD_STATE_DELETING        PodState = 7
	PodState_POD_STATE_GARBAGE         PodState = 8
)

var PodState_name = map[int32]string{
	0: "POD_STATE_UNDEFINED",
	1: "POD_STATE_EMBRYO",
	2: "POD_STATE_PREPARING",
	3: "POD_STATE_PREPARED",
	4: "POD_STATE_RUNNING",
	5: "POD_STATE_ABORTED_PREPARE",
	6: "POD_STATE_EXITED",
	7: "POD_STATE_DELETING",
	8: "POD_STATE_GARBAGE",
}
var PodState_value = map[string]int32{
	"POD_STATE_UNDEFINED":       0,
	"POD_STATE_EMBRYO":          1,
	"POD_STATE_PREPARING":       2,
	"POD_STATE_PREPARED":        3,
	"POD_STATE_RUNNING":         4,
	"POD_STATE_ABORTED_PREPARE": 5,
	"POD_STATE_EXITED":          6,
	"POD_STATE_DELETING":        7,
	"POD_STATE_GARBAGE":         8,
}

func (x PodState) String() string {
	return proto.EnumName(PodState_name, int32(x))
}
func (PodState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// EventType defines the type of the events that will be received via ListenEvents().
type EventType int32

const (
	EventType_EVENT_TYPE_UNDEFINED EventType = 0
	// Pod events.
	EventType_EVENT_TYPE_POD_PREPARED          EventType = 1
	EventType_EVENT_TYPE_POD_PREPARE_ABORTED   EventType = 2
	EventType_EVENT_TYPE_POD_STARTED           EventType = 3
	EventType_EVENT_TYPE_POD_EXITED            EventType = 4
	EventType_EVENT_TYPE_POD_GARBAGE_COLLECTED EventType = 5
	// App events.
	EventType_EVENT_TYPE_APP_STARTED EventType = 6
	EventType_EVENT_TYPE_APP_EXITED  EventType = 7
	// Image events.
	EventType_EVENT_TYPE_IMAGE_IMPORTED EventType = 8
	EventType_EVENT_TYPE_IMAGE_REMOVED  EventType = 9
)

var EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNDEFINED",
	1: "EVENT_TYPE_POD_PREPARED",
	2: "EVENT_TYPE_POD_PREPARE_ABORTED",
	3: "EVENT_TYPE_POD_STARTED",
	4: "EVENT_TYPE_POD_EXITED",
	5: "EVENT_TYPE_POD_GARBAGE_COLLECTED",
	6: "EVENT_TYPE_APP_STARTED",
	7: "EVENT_TYPE_APP_EXITED",
	8: "EVENT_TYPE_IMAGE_IMPORTED",
	9: "EVENT_TYPE_IMAGE_REMOVED",
}
var EventType_value = map[string]int32{
	"EVENT_TYPE_UNDEFINED":             0,
	"EVENT_TYPE_POD_PREPARED":          1,
	"EVENT_TYPE_POD_PREPARE_ABORTED":   2,
	"EVENT_TYPE_POD_STARTED":           3,
	"EVENT_TYPE_POD_EXITED":            4,
	"EVENT_TYPE_POD_GARBAGE_COLLECTED": 5,
	"EVENT_TYPE_APP_STARTED":           6,
	"EVENT_TYPE_APP_EXITED":            7,
	"EVENT_TYPE_IMAGE_IMPORTED":        8,
	"EVENT_TYPE_IMAGE_REMOVED":         9,
}

func (x EventType) String() string {
	return proto.EnumName(EventType_name, int32(x))
}
func (EventType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// ImageFormat defines the format of the image.
type ImageFormat struct {
	// Type of the image, required.
	Type ImageType `protobuf:"varint,1,opt,name=type,enum=v1alpha.ImageType" json:"type,omitempty"`
	// Version of the image format, required.
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *ImageFormat) Reset()                    { *m = ImageFormat{} }
func (m *ImageFormat) String() string            { return proto.CompactTextString(m) }
func (*ImageFormat) ProtoMessage()               {}
func (*ImageFormat) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ImageFormat) GetType() ImageType {
	if m != nil {
		return m.Type
	}
	return ImageType_IMAGE_TYPE_UNDEFINED
}

func (m *ImageFormat) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// Image describes the image's information.
type Image struct {
	// Base format of the image, required. This indicates the original format
	// for the image as nowadays all the image formats will be transformed to
	// ACI.
	BaseFormat *ImageFormat `protobuf:"bytes,1,opt,name=base_format,json=baseFormat" json:"base_format,omitempty"`
	// ID of the image, a string that can be used to uniquely identify the image,
	// e.g. sha512 hash of the ACIs, required.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Name of the image in the image manifest, e.g. 'coreos.com/etcd', optional.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Version of the image, e.g. 'latest', '2.0.10', optional.
	Version string `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	// Timestamp of when the image is imported, it is the seconds since epoch, optional.
	ImportTimestamp int64 `protobuf:"varint,5,opt,name=import_timestamp,json=importTimestamp" json:"import_timestamp,omitempty"`
	// JSON-encoded byte array that represents the image manifest, optional.
	Manifest []byte `protobuf:"bytes,6,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Size is the size in bytes of this image in the store.
	Size int64 `protobuf:"varint,7,opt,name=size" json:"size,omitempty"`
	// Annotations on this image.
	Annotations []*KeyValue `protobuf:"bytes,8,rep,name=annotations" json:"annotations,omitempty"`
	// Labels of this image.
	Labels []*KeyValue `protobuf:"bytes,9,rep,name=labels" json:"labels,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Image) GetBaseFormat() *ImageFormat {
	if m != nil {
		return m.BaseFormat
	}
	return nil
}

func (m *Image) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Image) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Image) GetImportTimestamp() int64 {
	if m != nil {
		return m.ImportTimestamp
	}
	return 0
}

func (m *Image) GetManifest() []byte {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *Image) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Image) GetAnnotations() []*KeyValue {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Image) GetLabels() []*KeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Network describes the network information of a pod.
type Network struct {
	// Name of the network that a pod belongs to, required.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Pod's IPv4 address within the network, optional if IPv6 address is given.
	Ipv4 string `protobuf:"bytes,2,opt,name=ipv4" json:"ipv4,omitempty"`
	// Pod's IPv6 address within the network, optional if IPv4 address is given.
	Ipv6 string `protobuf:"bytes,3,opt,name=ipv6" json:"ipv6,omitempty"`
}

func (m *Network) Reset()                    { *m = Network{} }
func (m *Network) String() string            { return proto.CompactTextString(m) }
func (*Network) ProtoMessage()               {}
func (*Network) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Network) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Network) GetIpv4() string {
	if m != nil {
		return m.Ipv4
	}
	return ""
}

func (m *Network) GetIpv6() string {
	if m != nil {
		return m.Ipv6
	}
	return ""
}

// App describes the information of an app that's running in a pod.
type App struct {
	// Name of the app, required.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Image used by the app, required. However, this may only contain the image id
	// if it is returned by ListPods().
	Image *Image `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// State of the app. optional, non-empty only if it's returned by InspectPod().
	State AppState `protobuf:"varint,3,opt,name=state,enum=v1alpha.AppState" json:"state,omitempty"`
	// Exit code of the app. optional, only valid if it's returned by InspectPod() and
	// the app has already exited.
	ExitCode int32 `protobuf:"zigzag32,4,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
	// Annotations for this app.
	Annotations []*KeyValue `protobuf:"bytes,5,rep,name=annotations" json:"annotations,omitempty"`
}

func (m *App) Reset()                    { *m = App{} }
func (m *App) String() string            { return proto.CompactTextString(m) }
func (*App) ProtoMessage()               {}
func (*App) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *App) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *App) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *App) GetState() AppState {
	if m != nil {
		return m.State
	}
	return AppState_APP_STATE_UNDEFINED
}

func (m *App) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *App) GetAnnotations() []*KeyValue {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// Pod describes a pod's information.
// If a pod is in Embryo, Preparing, AbortedPrepare state,
// only id and state will be returned.
//
// If a pod is in other states, the pod manifest and
// apps will be returned when 'detailed' is true in the request.
//
// A valid pid of the stage1 process of the pod will be returned
// if the pod is Running has run once.
//
// Networks are only returned when a pod is in Running.
type Pod struct {
	// ID of the pod, in the form of a UUID.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// PID of the stage1 process of the pod.
	Pid int32 `protobuf:"zigzag32,2,opt,name=pid" json:"pid,omitempty"`
	// State of the pod.
	State PodState `protobuf:"varint,3,opt,name=state,enum=v1alpha.PodState" json:"state,omitempty"`
	// List of apps in the pod.
	Apps []*App `protobuf:"bytes,4,rep,name=apps" json:"apps,omitempty"`
	// Network information of the pod.
	// Note that a pod can be in multiple networks.
	Networks []*Network `protobuf:"bytes,5,rep,name=networks" json:"networks,omitempty"`
	// JSON-encoded byte array that represents the pod manifest of the pod.
	Manifest []byte `protobuf:"bytes,6,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Annotations on this pod.
	Annotations []*KeyValue `protobuf:"bytes,7,rep,name=annotations" json:"annotations,omitempty"`
	// Cgroup of the pod, empty if the pod is not running.
	Cgroup string `protobuf:"bytes,8,opt,name=cgroup" json:"cgroup,omitempty"`
	// Timestamp of when the pod is created, nanoseconds since epoch.
	// Zero if the pod is not created.
	CreatedAt int64 `protobuf:"varint,9,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Timestamp of when the pod is started, nanoseconds since epoch.
	// Zero if the pod is not started.
	StartedAt int64 `protobuf:"varint,10,opt,name=started_at,json=startedAt" json:"started_at,omitempty"`
	// Timestamp of when the pod is moved to exited-garbage/garbage,
	// in nanoseconds since epoch.
	// Zero if the pod is not moved to exited-garbage/garbage yet.
	GcMarkedAt int64 `protobuf:"varint,11,opt,name=gc_marked_at,json=gcMarkedAt" json:"gc_marked_at,omitempty"`
}

func (m *Pod) Reset()                    { *m = Pod{} }
func (m *Pod) String() string            { return proto.CompactTextString(m) }
func (*Pod) ProtoMessage()               {}
func (*Pod) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Pod) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Pod) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Pod) GetState() PodState {
	if m != nil {
		return m.State
	}
	return PodState_POD_STATE_UNDEFINED
}

func (m *Pod) GetApps() []*App {
	if m != nil {
		return m.Apps
	}
	return nil
}

func (m *Pod) GetNetworks() []*Network {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *Pod) GetManifest() []byte {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *Pod) GetAnnotations() []*KeyValue {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Pod) GetCgroup() string {
	if m != nil {
		return m.Cgroup
	}
	return ""
}

func (m *Pod) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *Pod) GetStartedAt() int64 {
	if m != nil {
		return m.StartedAt
	}
	return 0
}

func (m *Pod) GetGcMarkedAt() int64 {
	if m != nil {
		return m.GcMarkedAt
	}
	return 0
}

type KeyValue struct {
	// Key part of the key-value pair.
	Key string `protobuf:"bytes,1,opt,name=Key" json:"Key,omitempty"`
	// Value part of the key-value pair.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// PodFilter defines the condition that the returned pods need to satisfy in ListPods().
// The conditions are combined by 'AND', and different filters are combined by 'OR'.
type PodFilter struct {
	// If not empty, the pods that have any of the ids will be returned.
	Ids []string `protobuf:"bytes,1,rep,name=ids" json:"ids,omitempty"`
	// If not empty, the pods that have any of the states will be returned.
	States []PodState `protobuf:"varint,2,rep,packed,name=states,enum=v1alpha.PodState" json:"states,omitempty"`
	// If not empty, the pods that all of the apps will be returned.
	AppNames []string `protobuf:"bytes,3,rep,name=app_names,json=appNames" json:"app_names,omitempty"`
	// If not empty, the pods that have all of the images(in the apps) will be returned
	ImageIds []string `protobuf:"bytes,4,rep,name=image_ids,json=imageIds" json:"image_ids,omitempty"`
	// If not empty, the pods that are in all of the networks will be returned.
	NetworkNames []string `protobuf:"bytes,5,rep,name=network_names,json=networkNames" json:"network_names,omitempty"`
	// If not empty, the pods that have all of the annotations will be returned.
	Annotations []*KeyValue `protobuf:"bytes,6,rep,name=annotations" json:"annotations,omitempty"`
	// If not empty, the pods whose cgroup are listed will be returned.
	Cgroups []string `protobuf:"bytes,7,rep,name=cgroups" json:"cgroups,omitempty"`
	// If not empty, the pods whose these cgroup belong to will be returned.
	// i.e. the pod's cgroup is a prefix of the specified cgroup
	PodSubCgroups []string `protobuf:"bytes,8,rep,name=pod_sub_cgroups,json=podSubCgroups" json:"pod_sub_cgroups,omitempty"`
}

func (m *PodFilter) Reset()                    { *m = PodFilter{} }
func (m *PodFilter) String() string            { return proto.CompactTextString(m) }
func (*PodFilter) ProtoMessage()               {}
func (*PodFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *PodFilter) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *PodFilter) GetStates() []PodState {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *PodFilter) GetAppNames() []string {
	if m != nil {
		return m.AppNames
	}
	return nil
}

func (m *PodFilter) GetImageIds() []string {
	if m != nil {
		return m.ImageIds
	}
	return nil
}

func (m *PodFilter) GetNetworkNames() []string {
	if m != nil {
		return m.NetworkNames
	}
	return nil
}

func (m *PodFilter) GetAnnotations() []*KeyValue {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodFilter) GetCgroups() []string {
	if m != nil {
		return m.Cgroups
	}
	return nil
}

func (m *PodFilter) GetPodSubCgroups() []string {
	if m != nil {
		return m.PodSubCgroups
	}
	return nil
}

// ImageFilter defines the condition that the returned images need to satisfy in ListImages().
// The conditions are combined by 'AND', and different filters are combined by 'OR'.
type ImageFilter struct {
	// If not empty, the images that have any of the ids will be returned.
	Ids []string `protobuf:"bytes,1,rep,name=ids" json:"ids,omitempty"`
	// if not empty, the images that have any of the prefixes in the name will be returned.
	Prefixes []string `protobuf:"bytes,2,rep,name=prefixes" json:"prefixes,omitempty"`
	// If not empty, the images that have any of the base names will be returned.
	// For example, both 'coreos.com/etcd' and 'k8s.io/etcd' will be returned if 'etcd' is included,
	// however 'k8s.io/etcd-backup' will not be returned.
	BaseNames []string `protobuf:"bytes,3,rep,name=base_names,json=baseNames" json:"base_names,omitempty"`
	// If not empty, the images that have any of the keywords in the name will be returned.
	// For example, both 'kubernetes-etcd', 'etcd:latest' will be returned if 'etcd' is included,
	Keywords []string `protobuf:"bytes,4,rep,name=keywords" json:"keywords,omitempty"`
	// If not empty, the images that have all of the labels will be returned.
	Labels []*KeyValue `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	// If set, the images that are imported after this timestamp will be returned.
	ImportedAfter int64 `protobuf:"varint,6,opt,name=imported_after,json=importedAfter" json:"imported_after,omitempty"`
	// If set, the images that are imported before this timestamp will be returned.
	ImportedBefore int64 `protobuf:"varint,7,opt,name=imported_before,json=importedBefore" json:"imported_before,omitempty"`
	// If not empty, the images that have all of the annotations will be returned.
	Annotations []*KeyValue `protobuf:"bytes,8,rep,name=annotations" json:"annotations,omitempty"`
	// If not empty, the images that have any of the exact full names will be returned.
	FullNames []string `protobuf:"bytes,9,rep,name=full_names,json=fullNames" json:"full_names,omitempty"`
}

func (m *ImageFilter) Reset()                    { *m = ImageFilter{} }
func (m *ImageFilter) String() string            { return proto.CompactTextString(m) }
func (*ImageFilter) ProtoMessage()               {}
func (*ImageFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ImageFilter) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *ImageFilter) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

func (m *ImageFilter) GetBaseNames() []string {
	if m != nil {
		return m.BaseNames
	}
	return nil
}

func (m *ImageFilter) GetKeywords() []string {
	if m != nil {
		return m.Keywords
	}
	return nil
}

func (m *ImageFilter) GetLabels() []*KeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ImageFilter) GetImportedAfter() int64 {
	if m != nil {
		return m.ImportedAfter
	}
	return 0
}

func (m *ImageFilter) GetImportedBefore() int64 {
	if m != nil {
		return m.ImportedBefore
	}
	return 0
}

func (m *ImageFilter) GetAnnotations() []*KeyValue {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ImageFilter) GetFullNames() []string {
	if m != nil {
		return m.FullNames
	}
	return nil
}

// GlobalFlags describes the flags that passed to rkt api service when it is launched.
type GlobalFlags struct {
	// Data directory.
	Dir string `protobuf:"bytes,1,opt,name=dir" json:"dir,omitempty"`
	// System configuration directory.
	SystemConfigDir string `protobuf:"bytes,2,opt,name=system_config_dir,json=systemConfigDir" json:"system_config_dir,omitempty"`
	// Local configuration directory.
	LocalConfigDir string `protobuf:"bytes,3,opt,name=local_config_dir,json=localConfigDir" json:"local_config_dir,omitempty"`
	// User configuration directory.
	UserConfigDir string `protobuf:"bytes,4,opt,name=user_config_dir,json=userConfigDir" json:"user_config_dir,omitempty"`
	// Insecure flags configurates what security features to disable.
	InsecureFlags string `protobuf:"bytes,5,opt,name=insecure_flags,json=insecureFlags" json:"insecure_flags,omitempty"`
	// Whether to automatically trust gpg keys fetched from https
	TrustKeysFromHttps bool `protobuf:"varint,6,opt,name=trust_keys_from_https,json=trustKeysFromHttps" json:"trust_keys_from_https,omitempty"`
}

func (m *GlobalFlags) Reset()                    { *m = GlobalFlags{} }
func (m *GlobalFlags) String() string            { return proto.CompactTextString(m) }
func (*GlobalFlags) ProtoMessage()               {}
func (*GlobalFlags) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GlobalFlags) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *GlobalFlags) GetSystemConfigDir() string {
	if m != nil {
		return m.SystemConfigDir
	}
	return ""
}

func (m *GlobalFlags) GetLocalConfigDir() string {
	if m != nil {
		return m.LocalConfigDir
	}
	return ""
}

func (m *GlobalFlags) GetUserConfigDir() string {
	if m != nil {
		return m.UserConfigDir
	}
	return ""
}

func (m *GlobalFlags) GetInsecureFlags() string {
	if m != nil {
		return m.InsecureFlags
	}
	return ""
}

func (m *GlobalFlags) GetTrustKeysFromHttps() bool {
	if m != nil {
		return m.TrustKeysFromHttps
	}
	return false
}

// Info describes the information of rkt on the machine.
type Info struct {
	// Version of rkt, required, in the form of Semantic Versioning 2.0.0 (http://semver.org/).
	RktVersion string `protobuf:"bytes,1,opt,name=rkt_version,json=rktVersion" json:"rkt_version,omitempty"`
	// Version of appc, required, in the form of Semantic Versioning 2.0.0 (http://semver.org/).
	AppcVersion string `protobuf:"bytes,2,opt,name=appc_version,json=appcVersion" json:"appc_version,omitempty"`
	// Latest version of the api that's supported by the service, required, in the form of Semantic Versioning 2.0.0 (http://semver.org/).
	ApiVersion string `protobuf:"bytes,3,opt,name=api_version,json=apiVersion" json:"api_version,omitempty"`
	// The global flags that passed to the rkt api service when it's launched.
	GlobalFlags *GlobalFlags `protobuf:"bytes,4,opt,name=global_flags,json=globalFlags" json:"global_flags,omitempty"`
}

func (m *Info) Reset()                    { *m = Info{} }
func (m *Info) String() string            { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()               {}
func (*Info) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Info) GetRktVersion() string {
	if m != nil {
		return m.RktVersion
	}
	return ""
}

func (m *Info) GetAppcVersion() string {
	if m != nil {
		return m.AppcVersion
	}
	return ""
}

func (m *Info) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *Info) GetGlobalFlags() *GlobalFlags {
	if m != nil {
		return m.GlobalFlags
	}
	return nil
}

// Event describes the events that will be received via ListenEvents().
type Event struct {
	// Type of the event, required.
	Type EventType `protobuf:"varint,1,opt,name=type,enum=v1alpha.EventType" json:"type,omitempty"`
	// ID of the subject that causes the event, required.
	// If the event is a pod or app event, the id is the pod's uuid.
	// If the event is an image event, the id is the image's id.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Name of the subject that causes the event, required.
	// If the event is a pod event, the name is the pod's name.
	// If the event is an app event, the name is the app's name.
	// If the event is an image event, the name is the image's name.
	From string `protobuf:"bytes,3,opt,name=from" json:"from,omitempty"`
	// Timestamp of when the event happens, it is the seconds since epoch, required.
	Time int64 `protobuf:"varint,4,opt,name=time" json:"time,omitempty"`
	// Data of the event, in the form of key-value pairs, optional.
	Data []*KeyValue `protobuf:"bytes,5,rep,name=data" json:"data,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Event) GetType() EventType {
	if m != nil {
		return m.Type
	}
	return EventType_EVENT_TYPE_UNDEFINED
}

func (m *Event) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Event) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

func (m *Event) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *Event) GetData() []*KeyValue {
	if m != nil {
		return m.Data
	}
	return nil
}

// EventFilter defines the condition that the returned events needs to satisfy in ListImages().
// The condition are combined by 'AND'.
type EventFilter struct {
	// If not empty, then only returns the events that have the listed types.
	Types []EventType `protobuf:"varint,1,rep,packed,name=types,enum=v1alpha.EventType" json:"types,omitempty"`
	// If not empty, then only returns the events whose 'id' is included in the listed ids.
	Ids []string `protobuf:"bytes,2,rep,name=ids" json:"ids,omitempty"`
	// If not empty, then only returns the events whose 'from' is included in the listed names.
	Names []string `protobuf:"bytes,3,rep,name=names" json:"names,omitempty"`
	// If set, then only returns the events after this timestamp.
	// If the server starts after since_time, then only the events happened after the start of the server will be returned.
	// If since_time is a future timestamp, then no events will be returned until that time.
	SinceTime int64 `protobuf:"varint,4,opt,name=since_time,json=sinceTime" json:"since_time,omitempty"`
	// If set, then only returns the events before this timestamp.
	// If it is a future timestamp, then the event stream will be closed at that moment.
	UntilTime int64 `protobuf:"varint,5,opt,name=until_time,json=untilTime" json:"until_time,omitempty"`
}

func (m *EventFilter) Reset()                    { *m = EventFilter{} }
func (m *EventFilter) String() string            { return proto.CompactTextString(m) }
func (*EventFilter) ProtoMessage()               {}
func (*EventFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *EventFilter) GetTypes() []EventType {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *EventFilter) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *EventFilter) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *EventFilter) GetSinceTime() int64 {
	if m != nil {
		return m.SinceTime
	}
	return 0
}

func (m *EventFilter) GetUntilTime() int64 {
	if m != nil {
		return m.UntilTime
	}
	return 0
}

// Request for GetInfo().
type GetInfoRequest struct {
}

func (m *GetInfoRequest) Reset()                    { *m = GetInfoRequest{} }
func (m *GetInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInfoRequest) ProtoMessage()               {}
func (*GetInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// Response for GetInfo().
type GetInfoResponse struct {
	Info *Info `protobuf:"bytes,1,opt,name=info" json:"info,omitempty"`
}

func (m *GetInfoResponse) Reset()                    { *m = GetInfoResponse{} }
func (m *GetInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*GetInfoResponse) ProtoMessage()               {}
func (*GetInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetInfoResponse) GetInfo() *Info {
	if m != nil {
		return m.Info
	}
	return nil
}

// Request for ListPods().
type ListPodsRequest struct {
	Filters []*PodFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
	Detail  bool         `protobuf:"varint,2,opt,name=detail" json:"detail,omitempty"`
}

func (m *ListPodsRequest) Reset()                    { *m = ListPodsRequest{} }
func (m *ListPodsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPodsRequest) ProtoMessage()               {}
func (*ListPodsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListPodsRequest) GetFilters() []*PodFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *ListPodsRequest) GetDetail() bool {
	if m != nil {
		return m.Detail
	}
	return false
}

// Response for ListPods().
type ListPodsResponse struct {
	Pods []*Pod `protobuf:"bytes,1,rep,name=pods" json:"pods,omitempty"`
}

func (m *ListPodsResponse) Reset()                    { *m = ListPodsResponse{} }
func (m *ListPodsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPodsResponse) ProtoMessage()               {}
func (*ListPodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListPodsResponse) GetPods() []*Pod {
	if m != nil {
		return m.Pods
	}
	return nil
}

// Request for InspectPod().
type InspectPodRequest struct {
	// ID of the pod which we are querying status for, required.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *InspectPodRequest) Reset()                    { *m = InspectPodRequest{} }
func (m *InspectPodRequest) String() string            { return proto.CompactTextString(m) }
func (*InspectPodRequest) ProtoMessage()               {}
func (*InspectPodRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *InspectPodRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Response for InspectPod().
type InspectPodResponse struct {
	Pod *Pod `protobuf:"bytes,1,opt,name=pod" json:"pod,omitempty"`
}

func (m *InspectPodResponse) Reset()                    { *m = InspectPodResponse{} }
func (m *InspectPodResponse) String() string            { return proto.CompactTextString(m) }
func (*InspectPodResponse) ProtoMessage()               {}
func (*InspectPodResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *InspectPodResponse) GetPod() *Pod {
	if m != nil {
		return m.Pod
	}
	return nil
}

// Request for ListImages().
type ListImagesRequest struct {
	Filters []*ImageFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
	Detail  bool           `protobuf:"varint,2,opt,name=detail" json:"detail,omitempty"`
}

func (m *ListImagesRequest) Reset()                    { *m = ListImagesRequest{} }
func (m *ListImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListImagesRequest) ProtoMessage()               {}
func (*ListImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListImagesRequest) GetFilters() []*ImageFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *ListImagesRequest) GetDetail() bool {
	if m != nil {
		return m.Detail
	}
	return false
}

// Response for ListImages().
type ListImagesResponse struct {
	Images []*Image `protobuf:"bytes,1,rep,name=images" json:"images,omitempty"`
}

func (m *ListImagesResponse) Reset()                    { *m = ListImagesResponse{} }
func (m *ListImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListImagesResponse) ProtoMessage()               {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ListImagesResponse) GetImages() []*Image {
	if m != nil {
		return m.Images
	}
	return nil
}

// Request for InspectImage().
type InspectImageRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *InspectImageRequest) Reset()                    { *m = InspectImageRequest{} }
func (m *InspectImageRequest) String() string            { return proto.CompactTextString(m) }
func (*InspectImageRequest) ProtoMessage()               {}
func (*InspectImageRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *InspectImageRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Response for InspectImage().
type InspectImageResponse struct {
	Image *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
}

func (m *InspectImageResponse) Reset()                    { *m = InspectImageResponse{} }
func (m *InspectImageResponse) String() string            { return proto.CompactTextString(m) }
func (*InspectImageResponse) ProtoMessage()               {}
func (*InspectImageResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *InspectImageResponse) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// Request for ListenEvents().
type ListenEventsRequest struct {
	Filter *EventFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListenEventsRequest) Reset()                    { *m = ListenEventsRequest{} }
func (m *ListenEventsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListenEventsRequest) ProtoMessage()               {}
func (*ListenEventsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ListenEventsRequest) GetFilter() *EventFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Response for ListenEvents().
type ListenEventsResponse struct {
	// Aggregate multiple events to reduce round trips, optional as the response can contain no events.
	Events []*Event `protobuf:"bytes,1,rep,name=events" json:"events,omitempty"`
}

func (m *ListenEventsResponse) Reset()                    { *m = ListenEventsResponse{} }
func (m *ListenEventsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListenEventsResponse) ProtoMessage()               {}
func (*ListenEventsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListenEventsResponse) GetEvents() []*Event {
	if m != nil {
		return m.Events
	}
	return nil
}

// Request for GetLogs().
type GetLogsRequest struct {
	// ID of the pod which we will get logs from, required.
	PodId string `protobuf:"bytes,1,opt,name=pod_id,json=podId" json:"pod_id,omitempty"`
	// Name of the app within the pod which we will get logs
	// from, optional. If not set, then the logs of all the
	// apps within the pod will be returned.
	AppName string `protobuf:"bytes,2,opt,name=app_name,json=appName" json:"app_name,omitempty"`
	// Number of most recent lines to return, optional.
	Lines int32 `protobuf:"varint,3,opt,name=lines" json:"lines,omitempty"`
	// If true, then a response stream will not be closed,
	// and new log response will be sent via the stream, default is false.
	Follow bool `protobuf:"varint,4,opt,name=follow" json:"follow,omitempty"`
	// If set, then only the logs after the timestamp will
	// be returned, optional.
	SinceTime int64 `protobuf:"varint,5,opt,name=since_time,json=sinceTime" json:"since_time,omitempty"`
	// If set, then only the logs before the timestamp will
	// be returned, optional.
	UntilTime int64 `protobuf:"varint,6,opt,name=until_time,json=untilTime" json:"until_time,omitempty"`
}

func (m *GetLogsRequest) Reset()                    { *m = GetLogsRequest{} }
func (m *GetLogsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLogsRequest) ProtoMessage()               {}
func (*GetLogsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *GetLogsRequest) GetPodId() string {
	if m != nil {
		return m.PodId
	}
	return ""
}

func (m *GetLogsRequest) GetAppName() string {
	if m != nil {
		return m.AppName
	}
	return ""
}

func (m *GetLogsRequest) GetLines() int32 {
	if m != nil {
		return m.Lines
	}
	return 0
}

func (m *GetLogsRequest) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

func (m *GetLogsRequest) GetSinceTime() int64 {
	if m != nil {
		return m.SinceTime
	}
	return 0
}

func (m *GetLogsRequest) GetUntilTime() int64 {
	if m != nil {
		return m.UntilTime
	}
	return 0
}

// Response for GetLogs().
type GetLogsResponse struct {
	// List of the log lines that returned, optional as the response can contain no logs.
	Lines []string `protobuf:"bytes,1,rep,name=lines" json:"lines,omitempty"`
}

func (m *GetLogsResponse) Reset()                    { *m = GetLogsResponse{} }
func (m *GetLogsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetLogsResponse) ProtoMessage()               {}
func (*GetLogsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *GetLogsResponse) GetLines() []string {
	if m != nil {
		return m.Lines
	}
	return nil
}

func init() {
	proto.RegisterType((*ImageFormat)(nil), "v1alpha.ImageFormat")
	proto.RegisterType((*Image)(nil), "v1alpha.Image")
	proto.RegisterType((*Network)(nil), "v1alpha.Network")
	proto.RegisterType((*App)(nil), "v1alpha.App")
	proto.RegisterType((*Pod)(nil), "v1alpha.Pod")
	proto.RegisterType((*KeyValue)(nil), "v1alpha.KeyValue")
	proto.RegisterType((*PodFilter)(nil), "v1alpha.PodFilter")
	proto.RegisterType((*ImageFilter)(nil), "v1alpha.ImageFilter")
	proto.RegisterType((*GlobalFlags)(nil), "v1alpha.GlobalFlags")
	proto.RegisterType((*Info)(nil), "v1alpha.Info")
	proto.RegisterType((*Event)(nil), "v1alpha.Event")
	proto.RegisterType((*EventFilter)(nil), "v1alpha.EventFilter")
	proto.RegisterType((*GetInfoRequest)(nil), "v1alpha.GetInfoRequest")
	proto.RegisterType((*GetInfoResponse)(nil), "v1alpha.GetInfoResponse")
	proto.RegisterType((*ListPodsRequest)(nil), "v1alpha.ListPodsRequest")
	proto.RegisterType((*ListPodsResponse)(nil), "v1alpha.ListPodsResponse")
	proto.RegisterType((*InspectPodRequest)(nil), "v1alpha.InspectPodRequest")
	proto.RegisterType((*InspectPodResponse)(nil), "v1alpha.InspectPodResponse")
	proto.RegisterType((*ListImagesRequest)(nil), "v1alpha.ListImagesRequest")
	proto.RegisterType((*ListImagesResponse)(nil), "v1alpha.ListImagesResponse")
	proto.RegisterType((*InspectImageRequest)(nil), "v1alpha.InspectImageRequest")
	proto.RegisterType((*InspectImageResponse)(nil), "v1alpha.InspectImageResponse")
	proto.RegisterType((*ListenEventsRequest)(nil), "v1alpha.ListenEventsRequest")
	proto.RegisterType((*ListenEventsResponse)(nil), "v1alpha.ListenEventsResponse")
	proto.RegisterType((*GetLogsRequest)(nil), "v1alpha.GetLogsRequest")
	proto.RegisterType((*GetLogsResponse)(nil), "v1alpha.GetLogsResponse")
	proto.RegisterEnum("v1alpha.ImageType", ImageType_name, ImageType_value)
	proto.RegisterEnum("v1alpha.AppState", AppState_name, AppState_value)
	proto.RegisterEnum("v1alpha.PodState", PodState_name, PodState_value)
	proto.RegisterEnum("v1alpha.EventType", EventType_name, EventType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PublicAPI service

type PublicAPIClient interface {
	// GetInfo gets the rkt's information on the machine.
	GetInfo(ctx context.Context, in *GetInfoRequest, opts ...grpc.CallOption) (*GetInfoResponse, error)
	// ListPods lists rkt pods on the machine.
	ListPods(ctx context.Context, in *ListPodsRequest, opts ...grpc.CallOption) (*ListPodsResponse, error)
	// InspectPod gets detailed pod information of the specified pod.
	InspectPod(ctx context.Context, in *InspectPodRequest, opts ...grpc.CallOption) (*InspectPodResponse, error)
	// ListImages lists the images on the machine.
	ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// InspectImage gets the detailed image information of the specified image.
	InspectImage(ctx context.Context, in *InspectImageRequest, opts ...grpc.CallOption) (*InspectImageResponse, error)
	// ListenEvents listens for the events, it will return a response stream
	// that will contain event objects.
	ListenEvents(ctx context.Context, in *ListenEventsRequest, opts ...grpc.CallOption) (PublicAPI_ListenEventsClient, error)
	// GetLogs gets the logs for a pod, if the app is also specified, then only the logs
	// of the app will be returned.
	//
	// If 'follow' in the 'GetLogsRequest' is set to 'true', then the response stream
	// will not be closed after the first response, the future logs will be sent via
	// the stream.
	GetLogs(ctx context.Context, in *GetLogsRequest, opts ...grpc.CallOption) (PublicAPI_GetLogsClient, error)
}

type publicAPIClient struct {
	cc *grpc.ClientConn
}

func NewPublicAPIClient(cc *grpc.ClientConn) PublicAPIClient {
	return &publicAPIClient{cc}
}

func (c *publicAPIClient) GetInfo(ctx context.Context, in *GetInfoRequest, opts ...grpc.CallOption) (*GetInfoResponse, error) {
	out := new(GetInfoResponse)
	err := grpc.Invoke(ctx, "/v1alpha.PublicAPI/GetInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publicAPIClient) ListPods(ctx context.Context, in *ListPodsRequest, opts ...grpc.CallOption) (*ListPodsResponse, error) {
	out := new(ListPodsResponse)
	err := grpc.Invoke(ctx, "/v1alpha.PublicAPI/ListPods", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publicAPIClient) InspectPod(ctx context.Context, in *InspectPodRequest, opts ...grpc.CallOption) (*InspectPodResponse, error) {
	out := new(InspectPodResponse)
	err := grpc.Invoke(ctx, "/v1alpha.PublicAPI/InspectPod", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publicAPIClient) ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := grpc.Invoke(ctx, "/v1alpha.PublicAPI/ListImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publicAPIClient) InspectImage(ctx context.Context, in *InspectImageRequest, opts ...grpc.CallOption) (*InspectImageResponse, error) {
	out := new(InspectImageResponse)
	err := grpc.Invoke(ctx, "/v1alpha.PublicAPI/InspectImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publicAPIClient) ListenEvents(ctx context.Context, in *ListenEventsRequest, opts ...grpc.CallOption) (PublicAPI_ListenEventsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_PublicAPI_serviceDesc.Streams[0], c.cc, "/v1alpha.PublicAPI/ListenEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &publicAPIListenEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PublicAPI_ListenEventsClient interface {
	Recv() (*ListenEventsResponse, error)
	grpc.ClientStream
}

type publicAPIListenEventsClient struct {
	grpc.ClientStream
}

func (x *publicAPIListenEventsClient) Recv() (*ListenEventsResponse, error) {
	m := new(ListenEventsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *publicAPIClient) GetLogs(ctx context.Context, in *GetLogsRequest, opts ...grpc.CallOption) (PublicAPI_GetLogsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_PublicAPI_serviceDesc.Streams[1], c.cc, "/v1alpha.PublicAPI/GetLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &publicAPIGetLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PublicAPI_GetLogsClient interface {
	Recv() (*GetLogsResponse, error)
	grpc.ClientStream
}

type publicAPIGetLogsClient struct {
	grpc.ClientStream
}

func (x *publicAPIGetLogsClient) Recv() (*GetLogsResponse, error) {
	m := new(GetLogsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for PublicAPI service

type PublicAPIServer interface {
	// GetInfo gets the rkt's information on the machine.
	GetInfo(context.Context, *GetInfoRequest) (*GetInfoResponse, error)
	// ListPods lists rkt pods on the machine.
	ListPods(context.Context, *ListPodsRequest) (*ListPodsResponse, error)
	// InspectPod gets detailed pod information of the specified pod.
	InspectPod(context.Context, *InspectPodRequest) (*InspectPodResponse, error)
	// ListImages lists the images on the machine.
	ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// InspectImage gets the detailed image information of the specified image.
	InspectImage(context.Context, *InspectImageRequest) (*InspectImageResponse, error)
	// ListenEvents listens for the events, it will return a response stream
	// that will contain event objects.
	ListenEvents(*ListenEventsRequest, PublicAPI_ListenEventsServer) error
	// GetLogs gets the logs for a pod, if the app is also specified, then only the logs
	// of the app will be returned.
	//
	// If 'follow' in the 'GetLogsRequest' is set to 'true', then the response stream
	// will not be closed after the first response, the future logs will be sent via
	// the stream.
	GetLogs(*GetLogsRequest, PublicAPI_GetLogsServer) error
}

func RegisterPublicAPIServer(s *grpc.Server, srv PublicAPIServer) {
	s.RegisterService(&_PublicAPI_serviceDesc, srv)
}

func _PublicAPI_GetInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicAPIServer).GetInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha.PublicAPI/GetInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicAPIServer).GetInfo(ctx, req.(*GetInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublicAPI_ListPods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicAPIServer).ListPods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha.PublicAPI/ListPods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicAPIServer).ListPods(ctx, req.(*ListPodsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublicAPI_InspectPod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectPodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicAPIServer).InspectPod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha.PublicAPI/InspectPod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicAPIServer).InspectPod(ctx, req.(*InspectPodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublicAPI_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicAPIServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha.PublicAPI/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicAPIServer).ListImages(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublicAPI_InspectImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicAPIServer).InspectImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha.PublicAPI/InspectImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicAPIServer).InspectImage(ctx, req.(*InspectImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublicAPI_ListenEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListenEventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PublicAPIServer).ListenEvents(m, &publicAPIListenEventsServer{stream})
}

type PublicAPI_ListenEventsServer interface {
	Send(*ListenEventsResponse) error
	grpc.ServerStream
}

type publicAPIListenEventsServer struct {
	grpc.ServerStream
}

func (x *publicAPIListenEventsServer) Send(m *ListenEventsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _PublicAPI_GetLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PublicAPIServer).GetLogs(m, &publicAPIGetLogsServer{stream})
}

type PublicAPI_GetLogsServer interface {
	Send(*GetLogsResponse) error
	grpc.ServerStream
}

type publicAPIGetLogsServer struct {
	grpc.ServerStream
}

func (x *publicAPIGetLogsServer) Send(m *GetLogsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _PublicAPI_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha.PublicAPI",
	HandlerType: (*PublicAPIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetInfo",
			Handler:    _PublicAPI_GetInfo_Handler,
		},
		{
			MethodName: "ListPods",
			Handler:    _PublicAPI_ListPods_Handler,
		},
		{
			MethodName: "InspectPod",
			Handler:    _PublicAPI_InspectPod_Handler,
		},
		{
			MethodName: "ListImages",
			Handler:    _PublicAPI_ListImages_Handler,
		},
		{
			MethodName: "InspectImage",
			Handler:    _PublicAPI_InspectImage_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListenEvents",
			Handler:       _PublicAPI_ListenEvents_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLogs",
			Handler:       _PublicAPI_GetLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api.proto",
}

func init() { proto.RegisterFile("api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1800 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x4f, 0x73, 0xdb, 0xc6,
	0x15, 0x37, 0xf8, 0x17, 0x78, 0xd4, 0x1f, 0x68, 0x2d, 0xd9, 0x30, 0x1d, 0x27, 0x0c, 0x12, 0xdb,
	0x8a, 0x26, 0xe3, 0x69, 0x14, 0xb7, 0xbd, 0x64, 0x32, 0xa5, 0x49, 0x48, 0xe5, 0x58, 0x12, 0x39,
	0x6b, 0xc6, 0x6d, 0xa6, 0x07, 0x0c, 0x44, 0x2c, 0x19, 0x8c, 0x40, 0x00, 0x05, 0x96, 0x72, 0xd4,
	0x63, 0x3f, 0x40, 0xbf, 0x41, 0x7b, 0xea, 0xb9, 0xd7, 0xcc, 0xf4, 0xde, 0x8f, 0xd2, 0x43, 0x3f,
	0x41, 0xaf, 0x9d, 0xfd, 0x03, 0x60, 0x09, 0x51, 0xae, 0x27, 0xb7, 0xdd, 0xf7, 0xfb, 0xe1, 0xed,
	0xfb, 0xb7, 0xef, 0x2d, 0x09, 0x86, 0x97, 0x04, 0x2f, 0x92, 0x34, 0xa6, 0x31, 0x6a, 0x5f, 0x7f,
	0xe5, 0x85, 0xc9, 0x0f, 0x9e, 0x3d, 0x86, 0xce, 0x68, 0xe9, 0x2d, 0xc8, 0x49, 0x9c, 0x2e, 0x3d,
	0x8a, 0x9e, 0x41, 0x83, 0xde, 0x24, 0xc4, 0xd2, 0x7a, 0xda, 0xe1, 0xce, 0x31, 0x7a, 0x21, 0x69,
	0x2f, 0x38, 0x67, 0x7a, 0x93, 0x10, 0xcc, 0x71, 0x64, 0x41, 0xfb, 0x9a, 0xa4, 0x59, 0x10, 0x47,
	0x56, 0xad, 0xa7, 0x1d, 0x1a, 0x38, 0xdf, 0xda, 0x3f, 0xd5, 0xa0, 0xc9, 0xd9, 0xe8, 0x97, 0xd0,
	0xb9, 0xf4, 0x32, 0xe2, 0xce, 0xb9, 0x6a, 0xae, 0xb2, 0x73, 0xbc, 0xbf, 0xae, 0x52, 0x1c, 0x8b,
	0x81, 0x11, 0xa5, 0x09, 0x3b, 0x50, 0x0b, 0x7c, 0xa9, 0xb5, 0x16, 0xf8, 0x08, 0x41, 0x23, 0xf2,
	0x96, 0xc4, 0xaa, 0x73, 0x09, 0x5f, 0xab, 0xc7, 0x37, 0xd6, 0x8e, 0x47, 0x5f, 0x80, 0x19, 0x2c,
	0x93, 0x38, 0xa5, 0x2e, 0x0d, 0x96, 0x24, 0xa3, 0xde, 0x32, 0xb1, 0x9a, 0x3d, 0xed, 0xb0, 0x8e,
	0x77, 0x85, 0x7c, 0x9a, 0x8b, 0x51, 0x17, 0xf4, 0xa5, 0x17, 0x05, 0x73, 0x92, 0x51, 0xab, 0xd5,
	0xd3, 0x0e, 0xb7, 0x70, 0xb1, 0x67, 0x87, 0x66, 0xc1, 0x9f, 0x88, 0xd5, 0xe6, 0x9f, 0xf2, 0x35,
	0xfa, 0x1a, 0x3a, 0x5e, 0x14, 0xc5, 0xd4, 0xa3, 0x41, 0x1c, 0x65, 0x96, 0xde, 0xab, 0x1f, 0x76,
	0x8e, 0xf7, 0x0a, 0x7f, 0x5e, 0x93, 0x9b, 0xb7, 0x5e, 0xb8, 0x22, 0x58, 0x65, 0xa1, 0x2f, 0xa0,
	0x15, 0x7a, 0x97, 0x24, 0xcc, 0x2c, 0xe3, 0x2e, 0xbe, 0x24, 0xd8, 0x0e, 0xb4, 0x2f, 0x08, 0x7d,
	0x17, 0xa7, 0x57, 0x85, 0xcf, 0x9a, 0xe2, 0x33, 0x82, 0x46, 0x90, 0x5c, 0xbf, 0x94, 0x91, 0xe1,
	0x6b, 0x29, 0xfb, 0x55, 0x1e, 0x1b, 0xb6, 0xb6, 0xff, 0xa9, 0x41, 0xbd, 0x9f, 0x24, 0x1b, 0x75,
	0x7c, 0x0e, 0xcd, 0x80, 0x85, 0x9d, 0x2b, 0xe9, 0x1c, 0xef, 0xac, 0x27, 0x03, 0x0b, 0x10, 0x3d,
	0x87, 0x66, 0x46, 0x3d, 0x2a, 0x42, 0xbe, 0xa3, 0x98, 0xdc, 0x4f, 0x92, 0x37, 0x0c, 0xc0, 0x02,
	0x47, 0x8f, 0xc1, 0x20, 0x3f, 0x06, 0xd4, 0x9d, 0xc5, 0x3e, 0xe1, 0x89, 0xd8, 0xc3, 0x3a, 0x13,
	0x0c, 0x62, 0xff, 0x56, 0xb8, 0x9a, 0x1f, 0x12, 0x2e, 0xfb, 0x3f, 0x35, 0xa8, 0x4f, 0x62, 0x5f,
	0x16, 0x81, 0x56, 0x14, 0x81, 0x09, 0xf5, 0x44, 0x56, 0xc5, 0x1e, 0x66, 0xcb, 0xbb, 0x8d, 0x9c,
	0xc4, 0xfe, 0x9a, 0x91, 0x3d, 0x68, 0x78, 0x49, 0x92, 0x59, 0x0d, 0x6e, 0xc0, 0x96, 0xea, 0x0c,
	0xe6, 0x08, 0xfa, 0x12, 0xf4, 0x48, 0x04, 0x3e, 0x37, 0xd3, 0x2c, 0x58, 0x32, 0x23, 0xb8, 0x60,
	0xbc, 0xb7, 0x6c, 0x2a, 0x3e, 0xb7, 0x3f, 0xa8, 0x44, 0x1e, 0x40, 0x6b, 0xb6, 0x48, 0xe3, 0x55,
	0x62, 0xe9, 0xdc, 0x5f, 0xb9, 0x43, 0x4f, 0x00, 0x66, 0x29, 0xf1, 0x28, 0xf1, 0x5d, 0x8f, 0x5a,
	0x06, 0xaf, 0x44, 0x43, 0x4a, 0xfa, 0x94, 0xc1, 0x19, 0xf5, 0x52, 0x09, 0x83, 0x80, 0xa5, 0xa4,
	0x4f, 0x51, 0x0f, 0xb6, 0x16, 0x33, 0x77, 0xe9, 0xa5, 0x57, 0x82, 0xd0, 0xe1, 0x04, 0x58, 0xcc,
	0xce, 0xb9, 0xa8, 0x4f, 0xed, 0x63, 0xd0, 0x73, 0x83, 0x58, 0x7c, 0x5f, 0x93, 0x1b, 0x19, 0x70,
	0xb6, 0x44, 0xfb, 0xd0, 0xbc, 0x66, 0x90, 0xac, 0x37, 0xb1, 0xb1, 0xff, 0x56, 0x03, 0x63, 0x12,
	0xfb, 0x27, 0x41, 0x48, 0x49, 0xca, 0xbe, 0x0a, 0xfc, 0xcc, 0xd2, 0x7a, 0x75, 0xf6, 0x55, 0xe0,
	0xf3, 0x72, 0xe7, 0x51, 0xcf, 0xac, 0x5a, 0xaf, 0xbe, 0x39, 0x2d, 0x92, 0xc0, 0x8a, 0xc7, 0x4b,
	0x12, 0x97, 0xd5, 0x65, 0x66, 0xd5, 0xb9, 0x0a, 0xdd, 0x4b, 0x92, 0x0b, 0xb6, 0x67, 0x20, 0xaf,
	0x45, 0x97, 0xe9, 0x6f, 0x08, 0x90, 0x0b, 0x46, 0x7e, 0x86, 0x3e, 0x83, 0x6d, 0x99, 0x0d, 0xf9,
	0x75, 0x93, 0x13, 0xb6, 0xa4, 0x50, 0x68, 0xa8, 0xa4, 0xa2, 0xf5, 0x41, 0xa9, 0xb0, 0xa0, 0x2d,
	0x82, 0x2f, 0x72, 0x67, 0xe0, 0x7c, 0x8b, 0x9e, 0xc1, 0x6e, 0x12, 0xfb, 0x6e, 0xb6, 0xba, 0x74,
	0x73, 0x86, 0xce, 0x19, 0xdb, 0x49, 0xec, 0xbf, 0x59, 0x5d, 0x0e, 0x84, 0xd0, 0xfe, 0x57, 0x2d,
	0x6f, 0xa8, 0x77, 0x85, 0xa8, 0x0b, 0x7a, 0x92, 0x92, 0x79, 0xf0, 0xa3, 0x0c, 0x92, 0x81, 0x8b,
	0x3d, 0xcb, 0x29, 0x6f, 0x99, 0x6a, 0x50, 0x0c, 0x26, 0x11, 0x3e, 0x75, 0x41, 0xbf, 0x22, 0x37,
	0xef, 0xe2, 0xb4, 0x0c, 0x4a, 0xbe, 0x57, 0x1a, 0x4d, 0xf3, 0xff, 0x34, 0x1a, 0xf4, 0x14, 0x76,
	0x44, 0x2f, 0x64, 0x95, 0x31, 0xa7, 0x24, 0xe5, 0x75, 0x5c, 0xc7, 0xdb, 0xb9, 0xb4, 0xcf, 0x84,
	0xe8, 0x39, 0xec, 0x16, 0xb4, 0x4b, 0x32, 0x8f, 0xd3, 0xbc, 0x1d, 0x16, 0x5f, 0xbf, 0xe2, 0xd2,
	0x9f, 0xd7, 0x18, 0x9f, 0x00, 0xcc, 0x57, 0x61, 0x28, 0x5d, 0x35, 0x84, 0xab, 0x4c, 0xc2, 0x5d,
	0xb5, 0xff, 0xab, 0x41, 0xe7, 0x34, 0x8c, 0x2f, 0xbd, 0xf0, 0x24, 0xf4, 0x16, 0x19, 0x8b, 0xa3,
	0x1f, 0xa4, 0x79, 0x81, 0xfa, 0x41, 0x8a, 0x8e, 0x60, 0x2f, 0xbb, 0xc9, 0x28, 0x59, 0xba, 0xb3,
	0x38, 0x9a, 0x07, 0x0b, 0x97, 0xe1, 0xa2, 0x58, 0x77, 0x05, 0x30, 0xe0, 0xf2, 0x61, 0x90, 0xa2,
	0x43, 0x30, 0xc3, 0x78, 0xe6, 0x85, 0x2a, 0x55, 0xf4, 0xcc, 0x1d, 0x2e, 0x2f, 0x99, 0xcf, 0x60,
	0x77, 0x95, 0x91, 0x54, 0x25, 0x8a, 0x09, 0xb3, 0xcd, 0xc4, 0x25, 0x8f, 0xc5, 0x30, 0xca, 0xc8,
	0x6c, 0x95, 0x12, 0x77, 0xce, 0x2c, 0xe4, 0x53, 0xc6, 0xc0, 0xdb, 0xb9, 0x54, 0x98, 0xfd, 0x15,
	0x1c, 0xd0, 0x74, 0x95, 0x51, 0xf7, 0x8a, 0xdc, 0x64, 0xee, 0x3c, 0x8d, 0x97, 0xee, 0x0f, 0x94,
	0x26, 0x19, 0x8f, 0xb8, 0x8e, 0x11, 0x07, 0x5f, 0x93, 0x9b, 0xec, 0x24, 0x8d, 0x97, 0xbf, 0x65,
	0x88, 0xfd, 0x77, 0x0d, 0x1a, 0xa3, 0x68, 0x1e, 0xa3, 0x4f, 0xa0, 0x93, 0x5e, 0x51, 0x37, 0x1f,
	0x74, 0xc2, 0x75, 0x48, 0xaf, 0xe8, 0x5b, 0x39, 0xeb, 0x3e, 0x85, 0x2d, 0x2f, 0x49, 0x66, 0xee,
	0xfa, 0x24, 0xee, 0x30, 0x59, 0x4e, 0xf9, 0x04, 0x3a, 0x5e, 0x12, 0x14, 0x0c, 0xe1, 0x33, 0x78,
	0x49, 0x90, 0x13, 0x7e, 0x0d, 0x5b, 0x0b, 0x1e, 0x66, 0xe9, 0x45, 0xa3, 0x32, 0xa5, 0x95, 0x1c,
	0xe0, 0xce, 0xa2, 0xdc, 0xd8, 0x7f, 0xd1, 0xa0, 0xe9, 0x5c, 0x93, 0xe8, 0xee, 0x37, 0x03, 0x47,
	0x95, 0x37, 0xc3, 0x86, 0xc1, 0xce, 0x02, 0x92, 0x0f, 0x2f, 0xb6, 0x66, 0x32, 0x36, 0xb7, 0xb9,
	0x19, 0x75, 0xcc, 0xd7, 0xe8, 0x29, 0x34, 0x7c, 0x8f, 0x7a, 0x77, 0xd7, 0x35, 0x87, 0xed, 0xbf,
	0x6a, 0xd0, 0xe1, 0x47, 0xca, 0x9b, 0x77, 0x08, 0x4d, 0x76, 0xac, 0xb8, 0x7b, 0x9b, 0xed, 0x12,
	0x84, 0xfc, 0x8e, 0xd6, 0xca, 0x3b, 0xba, 0x0f, 0x4d, 0xf5, 0x0a, 0x8a, 0x0d, 0xef, 0xb8, 0x41,
	0x34, 0x23, 0xae, 0x62, 0xa2, 0xc1, 0x25, 0xec, 0x51, 0xc1, 0xe0, 0x55, 0x44, 0x83, 0x50, 0xc0,
	0xe2, 0xd1, 0x61, 0x70, 0x09, 0x83, 0x6d, 0x13, 0x76, 0x4e, 0x09, 0x65, 0x99, 0xc5, 0xe4, 0x8f,
	0x2b, 0x92, 0x51, 0xfb, 0x25, 0xec, 0x16, 0x92, 0x2c, 0x89, 0xa3, 0x8c, 0xa0, 0x4f, 0xa1, 0x11,
	0x44, 0xf3, 0x58, 0x3e, 0x96, 0xb6, 0xcb, 0xf9, 0xcc, 0x48, 0x1c, 0xb2, 0x7f, 0x07, 0xbb, 0x67,
	0x41, 0x46, 0x27, 0xb1, 0x9f, 0x49, 0x45, 0xe8, 0x4b, 0x68, 0xcf, 0xb9, 0xd3, 0xc2, 0xd9, 0x8e,
	0xe2, 0x6c, 0xd1, 0xac, 0x71, 0x4e, 0x61, 0xf3, 0xc6, 0x27, 0xd4, 0x0b, 0x42, 0x9e, 0x0b, 0x1d,
	0xcb, 0x9d, 0xfd, 0x12, 0xcc, 0x52, 0xb1, 0xb4, 0xa7, 0x07, 0x8d, 0x24, 0xf6, 0x73, 0xb5, 0x5b,
	0xaa, 0x5a, 0xcc, 0x11, 0xfb, 0x33, 0xd8, 0x1b, 0x45, 0x59, 0x42, 0x66, 0xec, 0xc3, 0xdc, 0xa0,
	0xca, 0xf8, 0xb6, 0x5f, 0x02, 0x52, 0x49, 0x52, 0xf9, 0xc7, 0x50, 0x4f, 0x62, 0x5f, 0xfa, 0xba,
	0xae, 0x9b, 0x01, 0xf6, 0x1f, 0x60, 0x8f, 0x19, 0xc4, 0xdb, 0x69, 0xe1, 0xeb, 0x8b, 0xaa, 0xaf,
	0xd5, 0x17, 0xe5, 0x07, 0x7a, 0xfb, 0x0d, 0x20, 0x55, 0xb9, 0x34, 0xe9, 0x19, 0xb4, 0xf8, 0x98,
	0xc9, 0x95, 0x57, 0x5f, 0x48, 0x12, 0xb5, 0x9f, 0xc2, 0x7d, 0xe9, 0x90, 0x90, 0xdf, 0xe1, 0xf7,
	0x37, 0xb0, 0xbf, 0x4e, 0x93, 0xc7, 0x14, 0xef, 0x30, 0xed, 0x3d, 0xef, 0x30, 0x7b, 0x00, 0xf7,
	0x99, 0x89, 0x24, 0xe2, 0x15, 0xab, 0x64, 0xbb, 0x25, 0x9c, 0xbb, 0xf5, 0xa4, 0x56, 0xca, 0x1f,
	0x4b, 0x8e, 0xfd, 0x2d, 0xec, 0xaf, 0x2b, 0x29, 0x3d, 0x25, 0x5c, 0x72, 0xcb, 0x53, 0x4e, 0xc4,
	0x12, 0xb5, 0xff, 0xa1, 0xf1, 0xba, 0x3d, 0x8b, 0x17, 0x85, 0x01, 0x07, 0xd0, 0x62, 0xb3, 0xb0,
	0xf0, 0xb4, 0x99, 0xc4, 0xfe, 0xc8, 0x47, 0x8f, 0x40, 0xcf, 0x07, 0x7a, 0xfe, 0xa3, 0x40, 0xce,
	0x73, 0x76, 0x9f, 0xc2, 0x20, 0xe2, 0xf7, 0x49, 0x3b, 0x6c, 0x62, 0xb1, 0x61, 0xa9, 0x99, 0xc7,
	0x61, 0x18, 0xbf, 0xe3, 0x77, 0x49, 0xc7, 0x72, 0x57, 0xb9, 0x67, 0xcd, 0xf7, 0xdf, 0xb3, 0x56,
	0xf5, 0x9e, 0x3d, 0xe7, 0xb7, 0x4a, 0xd8, 0x2b, 0x7d, 0x2d, 0x8e, 0x17, 0x63, 0x58, 0x6c, 0x8e,
	0x08, 0x18, 0xc5, 0xcf, 0x1a, 0x64, 0xc1, 0xfe, 0xe8, 0xbc, 0x7f, 0xea, 0xb8, 0xd3, 0xef, 0x27,
	0x8e, 0xfb, 0xdd, 0xc5, 0xd0, 0x39, 0x19, 0x5d, 0x38, 0x43, 0xf3, 0x1e, 0xba, 0x0f, 0xbb, 0x0a,
	0xd2, 0x9f, 0x4c, 0x06, 0xa6, 0x86, 0x0e, 0x60, 0x4f, 0x11, 0x0e, 0xc7, 0x83, 0xd7, 0x0e, 0x36,
	0x6b, 0x08, 0xc1, 0x8e, 0x22, 0x1e, 0x0f, 0x46, 0x66, 0xfd, 0x68, 0x02, 0x7a, 0xfe, 0x6e, 0x46,
	0x0f, 0xe1, 0x7e, 0x7f, 0x32, 0x71, 0xdf, 0x4c, 0xfb, 0xd3, 0xf5, 0x43, 0x0e, 0x60, 0xaf, 0x04,
	0xf0, 0x77, 0x17, 0x17, 0xa3, 0x8b, 0x53, 0x53, 0x43, 0xfb, 0x60, 0x96, 0x62, 0xe7, 0xf7, 0xa3,
	0xa9, 0x33, 0x34, 0x6b, 0x47, 0xff, 0xd6, 0x40, 0xcf, 0x9f, 0x53, 0x4c, 0xe5, 0x64, 0x3c, 0xdc,
	0xa0, 0x72, 0x1f, 0xcc, 0x12, 0x70, 0xce, 0x5f, 0xe1, 0xef, 0xc7, 0xa6, 0xb6, 0x4e, 0x9f, 0x60,
	0x67, 0xd2, 0xc7, 0xec, 0xa8, 0x1a, 0x7a, 0x00, 0xa8, 0x0a, 0x38, 0x43, 0xb3, 0xce, 0x2c, 0x2b,
	0xe5, 0xb9, 0x65, 0x0d, 0xf4, 0x04, 0x1e, 0x95, 0xe2, 0xfe, 0xab, 0x31, 0x9e, 0x3a, 0xc3, 0xfc,
	0x33, 0xb3, 0x59, 0x39, 0x5c, 0x18, 0xde, 0x5a, 0x3f, 0x63, 0xe8, 0x9c, 0x39, 0x53, 0xa6, 0xac,
	0xbd, 0x7e, 0xc6, 0x69, 0x1f, 0xbf, 0xea, 0x9f, 0x3a, 0xa6, 0x7e, 0xf4, 0x53, 0x0d, 0x8c, 0xa2,
	0x59, 0xb3, 0x0c, 0x39, 0x6f, 0x9d, 0x8b, 0xe9, 0xed, 0x0c, 0x3d, 0x86, 0x87, 0x0a, 0xc2, 0x34,
	0x15, 0xf6, 0x6b, 0xc8, 0x86, 0x8f, 0x37, 0x83, 0xb9, 0xd5, 0x66, 0x0d, 0x75, 0xe1, 0x41, 0x85,
	0xf3, 0x66, 0xda, 0xe7, 0x58, 0x1d, 0x3d, 0x82, 0x83, 0x0a, 0x26, 0xdd, 0x69, 0xa0, 0xcf, 0xa1,
	0x57, 0x81, 0xa4, 0xed, 0xee, 0x60, 0x7c, 0x76, 0xe6, 0x0c, 0x18, 0xab, 0x59, 0x51, 0x2e, 0xd3,
	0x89, 0x45, 0x40, 0xd6, 0x95, 0x33, 0x4c, 0x2a, 0x6f, 0xb3, 0x00, 0x2b, 0x90, 0xa8, 0xaa, 0xd1,
	0xf9, 0x44, 0x98, 0xac, 0xa3, 0x8f, 0xc0, 0xba, 0x05, 0x63, 0xe7, 0x7c, 0xfc, 0xd6, 0x19, 0x9a,
	0xc6, 0xf1, 0x9f, 0x1b, 0x60, 0x4c, 0x56, 0x97, 0x61, 0x30, 0xeb, 0x4f, 0x46, 0xe8, 0x5b, 0x68,
	0xcb, 0x39, 0x83, 0x1e, 0x96, 0x83, 0x7d, 0x6d, 0x16, 0x75, 0xad, 0xdb, 0x80, 0xb8, 0x3c, 0xf6,
	0x3d, 0xd4, 0x07, 0x3d, 0x1f, 0x0c, 0xa8, 0xe4, 0x55, 0x86, 0x50, 0xf7, 0xd1, 0x06, 0xa4, 0x50,
	0x71, 0x0a, 0x50, 0x0e, 0x00, 0xd4, 0x55, 0xe6, 0x5a, 0x65, 0x74, 0x74, 0x1f, 0x6f, 0xc4, 0x54,
	0x45, 0x65, 0xdb, 0x56, 0x14, 0xdd, 0x1a, 0x14, 0x8a, 0xa2, 0xdb, 0x7d, 0xde, 0xbe, 0x87, 0xce,
	0x61, 0x4b, 0x6d, 0xcd, 0xe8, 0xa3, 0xea, 0xb9, 0x6a, 0x63, 0xef, 0x3e, 0xb9, 0x03, 0x2d, 0xd4,
	0x8d, 0x61, 0x4b, 0x6d, 0xb3, 0x8a, 0xba, 0x0d, 0x2d, 0x5c, 0x51, 0xb7, 0xa9, 0x37, 0xdb, 0xf7,
	0x7e, 0xa1, 0xa1, 0xdf, 0xf0, 0xa4, 0xb1, 0x36, 0xb6, 0x9e, 0x34, 0xa5, 0x11, 0xaf, 0x27, 0x4d,
	0xed, 0x78, 0x4c, 0xc3, 0x65, 0x8b, 0xff, 0xd5, 0xf3, 0xf5, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x12, 0x12, 0x68, 0x59, 0xf7, 0x11, 0x00, 0x00,
}
