// generated by go run maketables.go; DO NOT EDIT

// Package japanese provides Japanese encodings such as EUC-JP and Shift JIS.
package japanese

// jis0208Decode is the decoding table from JIS 0208 code to Unicode.
// It is defined at http://encoding.spec.whatwg.org/index-jis0208.txt
var jis0208Decode = [...]uint16{
	0:     0x3000,
	1:     0x3001,
	2:     0x3002,
	3:     0xFF0C,
	4:     0xFF0E,
	5:     0x30FB,
	6:     0xFF1A,
	7:     0xFF1B,
	8:     0xFF1F,
	9:     0xFF01,
	10:    0x309B,
	11:    0x309C,
	12:    0x00B4,
	13:    0xFF40,
	14:    0x00A8,
	15:    0xFF3E,
	16:    0xFFE3,
	17:    0xFF3F,
	18:    0x30FD,
	19:    0x30FE,
	20:    0x309D,
	21:    0x309E,
	22:    0x3003,
	23:    0x4EDD,
	24:    0x3005,
	25:    0x3006,
	26:    0x3007,
	27:    0x30FC,
	28:    0x2015,
	29:    0x2010,
	30:    0xFF0F,
	31:    0xFF3C,
	32:    0xFF5E,
	33:    0x2225,
	34:    0xFF5C,
	35:    0x2026,
	36:    0x2025,
	37:    0x2018,
	38:    0x2019,
	39:    0x201C,
	40:    0x201D,
	41:    0xFF08,
	42:    0xFF09,
	43:    0x3014,
	44:    0x3015,
	45:    0xFF3B,
	46:    0xFF3D,
	47:    0xFF5B,
	48:    0xFF5D,
	49:    0x3008,
	50:    0x3009,
	51:    0x300A,
	52:    0x300B,
	53:    0x300C,
	54:    0x300D,
	55:    0x300E,
	56:    0x300F,
	57:    0x3010,
	58:    0x3011,
	59:    0xFF0B,
	60:    0xFF0D,
	61:    0x00B1,
	62:    0x00D7,
	63:    0x00F7,
	64:    0xFF1D,
	65:    0x2260,
	66:    0xFF1C,
	67:    0xFF1E,
	68:    0x2266,
	69:    0x2267,
	70:    0x221E,
	71:    0x2234,
	72:    0x2642,
	73:    0x2640,
	74:    0x00B0,
	75:    0x2032,
	76:    0x2033,
	77:    0x2103,
	78:    0xFFE5,
	79:    0xFF04,
	80:    0xFFE0,
	81:    0xFFE1,
	82:    0xFF05,
	83:    0xFF03,
	84:    0xFF06,
	85:    0xFF0A,
	86:    0xFF20,
	87:    0x00A7,
	88:    0x2606,
	89:    0x2605,
	90:    0x25CB,
	91:    0x25CF,
	92:    0x25CE,
	93:    0x25C7,
	94:    0x25C6,
	95:    0x25A1,
	96:    0x25A0,
	97:    0x25B3,
	98:    0x25B2,
	99:    0x25BD,
	100:   0x25BC,
	101:   0x203B,
	102:   0x3012,
	103:   0x2192,
	104:   0x2190,
	105:   0x2191,
	106:   0x2193,
	107:   0x3013,
	119:   0x2208,
	120:   0x220B,
	121:   0x2286,
	122:   0x2287,
	123:   0x2282,
	124:   0x2283,
	125:   0x222A,
	126:   0x2229,
	135:   0x2227,
	136:   0x2228,
	137:   0xFFE2,
	138:   0x21D2,
	139:   0x21D4,
	140:   0x2200,
	141:   0x2203,
	153:   0x2220,
	154:   0x22A5,
	155:   0x2312,
	156:   0x2202,
	157:   0x2207,
	158:   0x2261,
	159:   0x2252,
	160:   0x226A,
	161:   0x226B,
	162:   0x221A,
	163:   0x223D,
	164:   0x221D,
	165:   0x2235,
	166:   0x222B,
	167:   0x222C,
	175:   0x212B,
	176:   0x2030,
	177:   0x266F,
	178:   0x266D,
	179:   0x266A,
	180:   0x2020,
	181:   0x2021,
	182:   0x00B6,
	187:   0x25EF,
	203:   0xFF10,
	204:   0xFF11,
	205:   0xFF12,
	206:   0xFF13,
	207:   0xFF14,
	208:   0xFF15,
	209:   0xFF16,
	210:   0xFF17,
	211:   0xFF18,
	212:   0xFF19,
	220:   0xFF21,
	221:   0xFF22,
	222:   0xFF23,
	223:   0xFF24,
	224:   0xFF25,
	225:   0xFF26,
	226:   0xFF27,
	227:   0xFF28,
	228:   0xFF29,
	229:   0xFF2A,
	230:   0xFF2B,
	231:   0xFF2C,
	232:   0xFF2D,
	233:   0xFF2E,
	234:   0xFF2F,
	235:   0xFF30,
	236:   0xFF31,
	237:   0xFF32,
	238:   0xFF33,
	239:   0xFF34,
	240:   0xFF35,
	241:   0xFF36,
	242:   0xFF37,
	243:   0xFF38,
	244:   0xFF39,
	245:   0xFF3A,
	252:   0xFF41,
	253:   0xFF42,
	254:   0xFF43,
	255:   0xFF44,
	256:   0xFF45,
	257:   0xFF46,
	258:   0xFF47,
	259:   0xFF48,
	260:   0xFF49,
	261:   0xFF4A,
	262:   0xFF4B,
	263:   0xFF4C,
	264:   0xFF4D,
	265:   0xFF4E,
	266:   0xFF4F,
	267:   0xFF50,
	268:   0xFF51,
	269:   0xFF52,
	270:   0xFF53,
	271:   0xFF54,
	272:   0xFF55,
	273:   0xFF56,
	274:   0xFF57,
	275:   0xFF58,
	276:   0xFF59,
	277:   0xFF5A,
	282:   0x3041,
	283:   0x3042,
	284:   0x3043,
	285:   0x3044,
	286:   0x3045,
	287:   0x3046,
	288:   0x3047,
	289:   0x3048,
	290:   0x3049,
	291:   0x304A,
	292:   0x304B,
	293:   0x304C,
	294:   0x304D,
	295:   0x304E,
	296:   0x304F,
	297:   0x3050,
	298:   0x3051,
	299:   0x3052,
	300:   0x3053,
	301:   0x3054,
	302:   0x3055,
	303:   0x3056,
	304:   0x3057,
	305:   0x3058,
	306:   0x3059,
	307:   0x305A,
	308:   0x305B,
	309:   0x305C,
	310:   0x305D,
	311:   0x305E,
	312:   0x305F,
	313:   0x3060,
	314:   0x3061,
	315:   0x3062,
	316:   0x3063,
	317:   0x3064,
	318:   0x3065,
	319:   0x3066,
	320:   0x3067,
	321:   0x3068,
	322:   0x3069,
	323:   0x306A,
	324:   0x306B,
	325:   0x306C,
	326:   0x306D,
	327:   0x306E,
	328:   0x306F,
	329:   0x3070,
	330:   0x3071,
	331:   0x3072,
	332:   0x3073,
	333:   0x3074,
	334:   0x3075,
	335:   0x3076,
	336:   0x3077,
	337:   0x3078,
	338:   0x3079,
	339:   0x307A,
	340:   0x307B,
	341:   0x307C,
	342:   0x307D,
	343:   0x307E,
	344:   0x307F,
	345:   0x3080,
	346:   0x3081,
	347:   0x3082,
	348:   0x3083,
	349:   0x3084,
	350:   0x3085,
	351:   0x3086,
	352:   0x3087,
	353:   0x3088,
	354:   0x3089,
	355:   0x308A,
	356:   0x308B,
	357:   0x308C,
	358:   0x308D,
	359:   0x308E,
	360:   0x308F,
	361:   0x3090,
	362:   0x3091,
	363:   0x3092,
	364:   0x3093,
	376:   0x30A1,
	377:   0x30A2,
	378:   0x30A3,
	379:   0x30A4,
	380:   0x30A5,
	381:   0x30A6,
	382:   0x30A7,
	383:   0x30A8,
	384:   0x30A9,
	385:   0x30AA,
	386:   0x30AB,
	387:   0x30AC,
	388:   0x30AD,
	389:   0x30AE,
	390:   0x30AF,
	391:   0x30B0,
	392:   0x30B1,
	393:   0x30B2,
	394:   0x30B3,
	395:   0x30B4,
	396:   0x30B5,
	397:   0x30B6,
	398:   0x30B7,
	399:   0x30B8,
	400:   0x30B9,
	401:   0x30BA,
	402:   0x30BB,
	403:   0x30BC,
	404:   0x30BD,
	405:   0x30BE,
	406:   0x30BF,
	407:   0x30C0,
	408:   0x30C1,
	409:   0x30C2,
	410:   0x30C3,
	411:   0x30C4,
	412:   0x30C5,
	413:   0x30C6,
	414:   0x30C7,
	415:   0x30C8,
	416:   0x30C9,
	417:   0x30CA,
	418:   0x30CB,
	419:   0x30CC,
	420:   0x30CD,
	421:   0x30CE,
	422:   0x30CF,
	423:   0x30D0,
	424:   0x30D1,
	425:   0x30D2,
	426:   0x30D3,
	427:   0x30D4,
	428:   0x30D5,
	429:   0x30D6,
	430:   0x30D7,
	431:   0x30D8,
	432:   0x30D9,
	433:   0x30DA,
	434:   0x30DB,
	435:   0x30DC,
	436:   0x30DD,
	437:   0x30DE,
	438:   0x30DF,
	439:   0x30E0,
	440:   0x30E1,
	441:   0x30E2,
	442:   0x30E3,
	443:   0x30E4,
	444:   0x30E5,
	445:   0x30E6,
	446:   0x30E7,
	447:   0x30E8,
	448:   0x30E9,
	449:   0x30EA,
	450:   0x30EB,
	451:   0x30EC,
	452:   0x30ED,
	453:   0x30EE,
	454:   0x30EF,
	455:   0x30F0,
	456:   0x30F1,
	457:   0x30F2,
	458:   0x30F3,
	459:   0x30F4,
	460:   0x30F5,
	461:   0x30F6,
	470:   0x0391,
	471:   0x0392,
	472:   0x0393,
	473:   0x0394,
	474:   0x0395,
	475:   0x0396,
	476:   0x0397,
	477:   0x0398,
	478:   0x0399,
	479:   0x039A,
	480:   0x039B,
	481:   0x039C,
	482:   0x039D,
	483:   0x039E,
	484:   0x039F,
	485:   0x03A0,
	486:   0x03A1,
	487:   0x03A3,
	488:   0x03A4,
	489:   0x03A5,
	490:   0x03A6,
	491:   0x03A7,
	492:   0x03A8,
	493:   0x03A9,
	502:   0x03B1,
	503:   0x03B2,
	504:   0x03B3,
	505:   0x03B4,
	506:   0x03B5,
	507:   0x03B6,
	508:   0x03B7,
	509:   0x03B8,
	510:   0x03B9,
	511:   0x03BA,
	512:   0x03BB,
	513:   0x03BC,
	514:   0x03BD,
	515:   0x03BE,
	516:   0x03BF,
	517:   0x03C0,
	518:   0x03C1,
	519:   0x03C3,
	520:   0x03C4,
	521:   0x03C5,
	522:   0x03C6,
	523:   0x03C7,
	524:   0x03C8,
	525:   0x03C9,
	564:   0x0410,
	565:   0x0411,
	566:   0x0412,
	567:   0x0413,
	568:   0x0414,
	569:   0x0415,
	570:   0x0401,
	571:   0x0416,
	572:   0x0417,
	573:   0x0418,
	574:   0x0419,
	575:   0x041A,
	576:   0x041B,
	577:   0x041C,
	578:   0x041D,
	579:   0x041E,
	580:   0x041F,
	581:   0x0420,
	582:   0x0421,
	583:   0x0422,
	584:   0x0423,
	585:   0x0424,
	586:   0x0425,
	587:   0x0426,
	588:   0x0427,
	589:   0x0428,
	590:   0x0429,
	591:   0x042A,
	592:   0x042B,
	593:   0x042C,
	594:   0x042D,
	595:   0x042E,
	596:   0x042F,
	612:   0x0430,
	613:   0x0431,
	614:   0x0432,
	615:   0x0433,
	616:   0x0434,
	617:   0x0435,
	618:   0x0451,
	619:   0x0436,
	620:   0x0437,
	621:   0x0438,
	622:   0x0439,
	623:   0x043A,
	624:   0x043B,
	625:   0x043C,
	626:   0x043D,
	627:   0x043E,
	628:   0x043F,
	629:   0x0440,
	630:   0x0441,
	631:   0x0442,
	632:   0x0443,
	633:   0x0444,
	634:   0x0445,
	635:   0x0446,
	636:   0x0447,
	637:   0x0448,
	638:   0x0449,
	639:   0x044A,
	640:   0x044B,
	641:   0x044C,
	642:   0x044D,
	643:   0x044E,
	644:   0x044F,
	658:   0x2500,
	659:   0x2502,
	660:   0x250C,
	661:   0x2510,
	662:   0x2518,
	663:   0x2514,
	664:   0x251C,
	665:   0x252C,
	666:   0x2524,
	667:   0x2534,
	668:   0x253C,
	669:   0x2501,
	670:   0x2503,
	671:   0x250F,
	672:   0x2513,
	673:   0x251B,
	674:   0x2517,
	675:   0x2523,
	676:   0x2533,
	677:   0x252B,
	678:   0x253B,
	679:   0x254B,
	680:   0x2520,
	681:   0x252F,
	682:   0x2528,
	683:   0x2537,
	684:   0x253F,
	685:   0x251D,
	686:   0x2530,
	687:   0x2525,
	688:   0x2538,
	689:   0x2542,
	1128:  0x2460,
	1129:  0x2461,
	1130:  0x2462,
	1131:  0x2463,
	1132:  0x2464,
	1133:  0x2465,
	1134:  0x2466,
	1135:  0x2467,
	1136:  0x2468,
	1137:  0x2469,
	1138:  0x246A,
	1139:  0x246B,
	1140:  0x246C,
	1141:  0x246D,
	1142:  0x246E,
	1143:  0x246F,
	1144:  0x2470,
	1145:  0x2471,
	1146:  0x2472,
	1147:  0x2473,
	1148:  0x2160,
	1149:  0x2161,
	1150:  0x2162,
	1151:  0x2163,
	1152:  0x2164,
	1153:  0x2165,
	1154:  0x2166,
	1155:  0x2167,
	1156:  0x2168,
	1157:  0x2169,
	1159:  0x3349,
	1160:  0x3314,
	1161:  0x3322,
	1162:  0x334D,
	1163:  0x3318,
	1164:  0x3327,
	1165:  0x3303,
	1166:  0x3336,
	1167:  0x3351,
	1168:  0x3357,
	1169:  0x330D,
	1170:  0x3326,
	1171:  0x3323,
	1172:  0x332B,
	1173:  0x334A,
	1174:  0x333B,
	1175:  0x339C,
	1176:  0x339D,
	1177:  0x339E,
	1178:  0x338E,
	1179:  0x338F,
	1180:  0x33C4,
	1181:  0x33A1,
	1190:  0x337B,
	1191:  0x301D,
	1192:  0x301F,
	1193:  0x2116,
	1194:  0x33CD,
	1195:  0x2121,
	1196:  0x32A4,
	1197:  0x32A5,
	1198:  0x32A6,
	1199:  0x32A7,
	1200:  0x32A8,
	1201:  0x3231,
	1202:  0x3232,
	1203:  0x3239,
	1204:  0x337E,
	1205:  0x337D,
	1206:  0x337C,
	1207:  0x2252,
	1208:  0x2261,
	1209:  0x222B,
	1210:  0x222E,
	1211:  0x2211,
	1212:  0x221A,
	1213:  0x22A5,
	1214:  0x2220,
	1215:  0x221F,
	1216:  0x22BF,
	1217:  0x2235,
	1218:  0x2229,
	1219:  0x222A,
	1410:  0x4E9C,
	1411:  0x5516,
	1412:  0x5A03,
	1413:  0x963F,
	1414:  0x54C0,
	1415:  0x611B,
	1416:  0x6328,
	1417:  0x59F6,
	1418:  0x9022,
	1419:  0x8475,
	1420:  0x831C,
	1421:  0x7A50,
	1422:  0x60AA,
	1423:  0x63E1,
	1424:  0x6E25,
	1425:  0x65ED,
	1426:  0x8466,
	1427:  0x82A6,
	1428:  0x9BF5,
	1429:  0x6893,
	1430:  0x5727,
	1431:  0x65A1,
	1432:  0x6271,
	1433:  0x5B9B,
	1434:  0x59D0,
	1435:  0x867B,
	1436:  0x98F4,
	1437:  0x7D62,
	1438:  0x7DBE,
	1439:  0x9B8E,
	1440:  0x6216,
	1441:  0x7C9F,
	1442:  0x88B7,
	1443:  0x5B89,
	1444:  0x5EB5,
	1445:  0x6309,
	1446:  0x6697,
	1447:  0x6848,
	1448:  0x95C7,
	1449:  0x978D,
	1450:  0x674F,
	1451:  0x4EE5,
	1452:  0x4F0A,
	1453:  0x4F4D,
	1454:  0x4F9D,
	1455:  0x5049,
	1456:  0x56F2,
	1457:  0x5937,
	1458:  0x59D4,
	1459:  0x5A01,
	1460:  0x5C09,
	1461:  0x60DF,
	1462:  0x610F,
	1463:  0x6170,
	1464:  0x6613,
	1465:  0x6905,
	1466:  0x70BA,
	1467:  0x754F,
	1468:  0x7570,
	1469:  0x79FB,
	1470:  0x7DAD,
	1471:  0x7DEF,
	1472:  0x80C3,
	1473:  0x840E,
	1474:  0x8863,
	1475:  0x8B02,
	1476:  0x9055,
	1477:  0x907A,
	1478:  0x533B,
	1479:  0x4E95,
	1480:  0x4EA5,
	1481:  0x57DF,
	1482:  0x80B2,
	1483:  0x90C1,
	1484:  0x78EF,
	1485:  0x4E00,
	1486:  0x58F1,
	1487:  0x6EA2,
	1488:  0x9038,
	1489:  0x7A32,
	1490:  0x8328,
	1491:  0x828B,
	1492:  0x9C2F,
	1493:  0x5141,
	1494:  0x5370,
	1495:  0x54BD,
	1496:  0x54E1,
	1497:  0x56E0,
	1498:  0x59FB,
	1499:  0x5F15,
	1500:  0x98F2,
	1501:  0x6DEB,
	1502:  0x80E4,
	1503:  0x852D,
	1504:  0x9662,
	1505:  0x9670,
	1506:  0x96A0,
	1507:  0x97FB,
	1508:  0x540B,
	1509:  0x53F3,
	1510:  0x5B87,
	1511:  0x70CF,
	1512:  0x7FBD,
	1513:  0x8FC2,
	1514:  0x96E8,
	1515:  0x536F,
	1516:  0x9D5C,
	1517:  0x7ABA,
	1518:  0x4E11,
	1519:  0x7893,
	1520:  0x81FC,
	1521:  0x6E26,
	1522:  0x5618,
	1523:  0x5504,
	1524:  0x6B1D,
	1525:  0x851A,
	1526:  0x9C3B,
	1527:  0x59E5,
	1528:  0x53A9,
	1529:  0x6D66,
	1530:  0x74DC,
	1531:  0x958F,
	1532:  0x5642,
	1533:  0x4E91,
	1534:  0x904B,
	1535:  0x96F2,
	1536:  0x834F,
	1537:  0x990C,
	1538:  0x53E1,
	1539:  0x55B6,
	1540:  0x5B30,
	1541:  0x5F71,
	1542:  0x6620,
	1543:  0x66F3,
	1544:  0x6804,
	1545:  0x6C38,
	1546:  0x6CF3,
	1547:  0x6D29,
	1548:  0x745B,
	1549:  0x76C8,
	1550:  0x7A4E,
	1551:  0x9834,
	1552:  0x82F1,
	1553:  0x885B,
	1554:  0x8A60,
	1555:  0x92ED,
	1556:  0x6DB2,
	1557:  0x75AB,
	1558:  0x76CA,
	1559:  0x99C5,
	1560:  0x60A6,
	1561:  0x8B01,
	1562:  0x8D8A,
	1563:  0x95B2,
	1564:  0x698E,
	1565:  0x53AD,
	1566:  0x5186,
	1567:  0x5712,
	1568:  0x5830,
	1569:  0x5944,
	1570:  0x5BB4,
	1571:  0x5EF6,
	1572:  0x6028,
	1573:  0x63A9,
	1574:  0x63F4,
	1575:  0x6CBF,
	1576:  0x6F14,
	1577:  0x708E,
	1578:  0x7114,
	1579:  0x7159,
	1580:  0x71D5,
	1581:  0x733F,
	1582:  0x7E01,
	1583:  0x8276,
	1584:  0x82D1,
	1585:  0x8597,
	1586:  0x9060,
	1587:  0x925B,
	1588:  0x9D1B,
	1589:  0x5869,
	1590:  0x65BC,
	1591:  0x6C5A,
	1592:  0x7525,
	1593:  0x51F9,
	1594:  0x592E,
	1595:  0x5965,
	1596:  0x5F80,
	1597:  0x5FDC,
	1598:  0x62BC,
	1599:  0x65FA,
	1600:  0x6A2A,
	1601:  0x6B27,
	1602:  0x6BB4,
	1603:  0x738B,
	1604:  0x7FC1,
	1605:  0x8956,
	1606:  0x9D2C,
	1607:  0x9D0E,
	1608:  0x9EC4,
	1609:  0x5CA1,
	1610:  0x6C96,
	1611:  0x837B,
	1612:  0x5104,
	1613:  0x5C4B,
	1614:  0x61B6,
	1615:  0x81C6,
	1616:  0x6876,
	1617:  0x7261,
	1618:  0x4E59,
	1619:  0x4FFA,
	1620:  0x5378,
	1621:  0x6069,
	1622:  0x6E29,
	1623:  0x7A4F,
	1624:  0x97F3,
	1625:  0x4E0B,
	1626:  0x5316,
	1627:  0x4EEE,
	1628:  0x4F55,
	1629:  0x4F3D,
	1630:  0x4FA1,
	1631:  0x4F73,
	1632:  0x52A0,
	1633:  0x53EF,
	1634:  0x5609,
	1635:  0x590F,
	1636:  0x5AC1,
	1637:  0x5BB6,
	1638:  0x5BE1,
	1639:  0x79D1,
	1640:  0x6687,
	1641:  0x679C,
	1642:  0x67B6,
	1643:  0x6B4C,
	1644:  0x6CB3,
	1645:  0x706B,
	1646:  0x73C2,
	1647:  0x798D,
	1648:  0x79BE,
	1649:  0x7A3C,
	1650:  0x7B87,
	1651:  0x82B1,
	1652:  0x82DB,
	1653:  0x8304,
	1654:  0x8377,
	1655:  0x83EF,
	1656:  0x83D3,
	1657:  0x8766,
	1658:  0x8AB2,
	1659:  0x5629,
	1660:  0x8CA8,
	1661:  0x8FE6,
	1662:  0x904E,
	1663:  0x971E,
	1664:  0x868A,
	1665:  0x4FC4,
	1666:  0x5CE8,
	1667:  0x6211,
	1668:  0x7259,
	1669:  0x753B,
	1670:  0x81E5,
	1671:  0x82BD,
	1672:  0x86FE,
	1673:  0x8CC0,
	1674:  0x96C5,
	1675:  0x9913,
	1676:  0x99D5,
	1677:  0x4ECB,
	1678:  0x4F1A,
	1679:  0x89E3,
	1680:  0x56DE,
	1681:  0x584A,
	1682:  0x58CA,
	1683:  0x5EFB,
	1684:  0x5FEB,
	1685:  0x602A,
	1686:  0x6094,
	1687:  0x6062,
	1688:  0x61D0,
	1689:  0x6212,
	1690:  0x62D0,
	1691:  0x6539,
	1692:  0x9B41,
	1693:  0x6666,
	1694:  0x68B0,
	1695:  0x6D77,
	1696:  0x7070,
	1697:  0x754C,
	1698:  0x7686,
	1699:  0x7D75,
	1700:  0x82A5,
	1701:  0x87F9,
	1702:  0x958B,
	1703:  0x968E,
	1704:  0x8C9D,
	1705:  0x51F1,
	1706:  0x52BE,
	1707:  0x5916,
	1708:  0x54B3,
	1709:  0x5BB3,
	1710:  0x5D16,
	1711:  0x6168,
	1712:  0x6982,
	1713:  0x6DAF,
	1714:  0x788D,
	1715:  0x84CB,
	1716:  0x8857,
	1717:  0x8A72,
	1718:  0x93A7,
	1719:  0x9AB8,
	1720:  0x6D6C,
	1721:  0x99A8,
	1722:  0x86D9,
	1723:  0x57A3,
	1724:  0x67FF,
	1725:  0x86CE,
	1726:  0x920E,
	1727:  0x5283,
	1728:  0x5687,
	1729:  0x5404,
	1730:  0x5ED3,
	1731:  0x62E1,
	1732:  0x64B9,
	1733:  0x683C,
	1734:  0x6838,
	1735:  0x6BBB,
	1736:  0x7372,
	1737:  0x78BA,
	1738:  0x7A6B,
	1739:  0x899A,
	1740:  0x89D2,
	1741:  0x8D6B,
	1742:  0x8F03,
	1743:  0x90ED,
	1744:  0x95A3,
	1745:  0x9694,
	1746:  0x9769,
	1747:  0x5B66,
	1748:  0x5CB3,
	1749:  0x697D,
	1750:  0x984D,
	1751:  0x984E,
	1752:  0x639B,
	1753:  0x7B20,
	1754:  0x6A2B,
	1755:  0x6A7F,
	1756:  0x68B6,
	1757:  0x9C0D,
	1758:  0x6F5F,
	1759:  0x5272,
	1760:  0x559D,
	1761:  0x6070,
	1762:  0x62EC,
	1763:  0x6D3B,
	1764:  0x6E07,
	1765:  0x6ED1,
	1766:  0x845B,
	1767:  0x8910,
	1768:  0x8F44,
	1769:  0x4E14,
	1770:  0x9C39,
	1771:  0x53F6,
	1772:  0x691B,
	1773:  0x6A3A,
	1774:  0x9784,
	1775:  0x682A,
	1776:  0x515C,
	1777:  0x7AC3,
	1778:  0x84B2,
	1779:  0x91DC,
	1780:  0x938C,
	1781:  0x565B,
	1782:  0x9D28,
	1783:  0x6822,
	1784:  0x8305,
	1785:  0x8431,
	1786:  0x7CA5,
	1787:  0x5208,
	1788:  0x82C5,
	1789:  0x74E6,
	1790:  0x4E7E,
	1791:  0x4F83,
	1792:  0x51A0,
	1793:  0x5BD2,
	1794:  0x520A,
	1795:  0x52D8,
	1796:  0x52E7,
	1797:  0x5DFB,
	1798:  0x559A,
	1799:  0x582A,
	1800:  0x59E6,
	1801:  0x5B8C,
	1802:  0x5B98,
	1803:  0x5BDB,
	1804:  0x5E72,
	1805:  0x5E79,
	1806:  0x60A3,
	1807:  0x611F,
	1808:  0x6163,
	1809:  0x61BE,
	1810:  0x63DB,
	1811:  0x6562,
	1812:  0x67D1,
	1813:  0x6853,
	1814:  0x68FA,
	1815:  0x6B3E,
	1816:  0x6B53,
	1817:  0x6C57,
	1818:  0x6F22,
	1819:  0x6F97,
	1820:  0x6F45,
	1821:  0x74B0,
	1822:  0x7518,
	1823:  0x76E3,
	1824:  0x770B,
	1825:  0x7AFF,
	1826:  0x7BA1,
	1827:  0x7C21,
	1828:  0x7DE9,
	1829:  0x7F36,
	1830:  0x7FF0,
	1831:  0x809D,
	1832:  0x8266,
	1833:  0x839E,
	1834:  0x89B3,
	1835:  0x8ACC,
	1836:  0x8CAB,
	1837:  0x9084,
	1838:  0x9451,
	1839:  0x9593,
	1840:  0x9591,
	1841:  0x95A2,
	1842:  0x9665,
	1843:  0x97D3,
	1844:  0x9928,
	1845:  0x8218,
	1846:  0x4E38,
	1847:  0x542B,
	1848:  0x5CB8,
	1849:  0x5DCC,
	1850:  0x73A9,
	1851:  0x764C,
	1852:  0x773C,
	1853:  0x5CA9,
	1854:  0x7FEB,
	1855:  0x8D0B,
	1856:  0x96C1,
	1857:  0x9811,
	1858:  0x9854,
	1859:  0x9858,
	1860:  0x4F01,
	1861:  0x4F0E,
	1862:  0x5371,
	1863:  0x559C,
	1864:  0x5668,
	1865:  0x57FA,
	1866:  0x5947,
	1867:  0x5B09,
	1868:  0x5BC4,
	1869:  0x5C90,
	1870:  0x5E0C,
	1871:  0x5E7E,
	1872:  0x5FCC,
	1873:  0x63EE,
	1874:  0x673A,
	1875:  0x65D7,
	1876:  0x65E2,
	1877:  0x671F,
	1878:  0x68CB,
	1879:  0x68C4,
	1880:  0x6A5F,
	1881:  0x5E30,
	1882:  0x6BC5,
	1883:  0x6C17,
	1884:  0x6C7D,
	1885:  0x757F,
	1886:  0x7948,
	1887:  0x5B63,
	1888:  0x7A00,
	1889:  0x7D00,
	1890:  0x5FBD,
	1891:  0x898F,
	1892:  0x8A18,
	1893:  0x8CB4,
	1894:  0x8D77,
	1895:  0x8ECC,
	1896:  0x8F1D,
	1897:  0x98E2,
	1898:  0x9A0E,
	1899:  0x9B3C,
	1900:  0x4E80,
	1901:  0x507D,
	1902:  0x5100,
	1903:  0x5993,
	1904:  0x5B9C,
	1905:  0x622F,
	1906:  0x6280,
	1907:  0x64EC,
	1908:  0x6B3A,
	1909:  0x72A0,
	1910:  0x7591,
	1911:  0x7947,
	1912:  0x7FA9,
	1913:  0x87FB,
	1914:  0x8ABC,
	1915:  0x8B70,
	1916:  0x63AC,
	1917:  0x83CA,
	1918:  0x97A0,
	1919:  0x5409,
	1920:  0x5403,
	1921:  0x55AB,
	1922:  0x6854,
	1923:  0x6A58,
	1924:  0x8A70,
	1925:  0x7827,
	1926:  0x6775,
	1927:  0x9ECD,
	1928:  0x5374,
	1929:  0x5BA2,
	1930:  0x811A,
	1931:  0x8650,
	1932:  0x9006,
	1933:  0x4E18,
	1934:  0x4E45,
	1935:  0x4EC7,
	1936:  0x4F11,
	1937:  0x53CA,
	1938:  0x5438,
	1939:  0x5BAE,
	1940:  0x5F13,
	1941:  0x6025,
	1942:  0x6551,
	1943:  0x673D,
	1944:  0x6C42,
	1945:  0x6C72,
	1946:  0x6CE3,
	1947:  0x7078,
	1948:  0x7403,
	1949:  0x7A76,
	1950:  0x7AAE,
	1951:  0x7B08,
	1952:  0x7D1A,
	1953:  0x7CFE,
	1954:  0x7D66,
	1955:  0x65E7,
	1956:  0x725B,
	1957:  0x53BB,
	1958:  0x5C45,
	1959:  0x5DE8,
	1960:  0x62D2,
	1961:  0x62E0,
	1962:  0x6319,
	1963:  0x6E20,
	1964:  0x865A,
	1965:  0x8A31,
	1966:  0x8DDD,
	1967:  0x92F8,
	1968:  0x6F01,
	1969:  0x79A6,
	1970:  0x9B5A,
	1971:  0x4EA8,
	1972:  0x4EAB,
	1973:  0x4EAC,
	1974:  0x4F9B,
	1975:  0x4FA0,
	1976:  0x50D1,
	1977:  0x5147,
	1978:  0x7AF6,
	1979:  0x5171,
	1980:  0x51F6,
	1981:  0x5354,
	1982:  0x5321,
	1983:  0x537F,
	1984:  0x53EB,
	1985:  0x55AC,
	1986:  0x5883,
	1987:  0x5CE1,
	1988:  0x5F37,
	1989:  0x5F4A,
	1990:  0x602F,
	1991:  0x6050,
	1992:  0x606D,
	1993:  0x631F,
	1994:  0x6559,
	1995:  0x6A4B,
	1996:  0x6CC1,
	1997:  0x72C2,
	1998:  0x72ED,
	1999:  0x77EF,
	2000:  0x80F8,
	2001:  0x8105,
	2002:  0x8208,
	2003:  0x854E,
	2004:  0x90F7,
	2005:  0x93E1,
	2006:  0x97FF,
	2007:  0x9957,
	2008:  0x9A5A,
	2009:  0x4EF0,
	2010:  0x51DD,
	2011:  0x5C2D,
	2012:  0x6681,
	2013:  0x696D,
	2014:  0x5C40,
	2015:  0x66F2,
	2016:  0x6975,
	2017:  0x7389,
	2018:  0x6850,
	2019:  0x7C81,
	2020:  0x50C5,
	2021:  0x52E4,
	2022:  0x5747,
	2023:  0x5DFE,
	2024:  0x9326,
	2025:  0x65A4,
	2026:  0x6B23,
	2027:  0x6B3D,
	2028:  0x7434,
	2029:  0x7981,
	2030:  0x79BD,
	2031:  0x7B4B,
	2032:  0x7DCA,
	2033:  0x82B9,
	2034:  0x83CC,
	2035:  0x887F,
	2036:  0x895F,
	2037:  0x8B39,
	2038:  0x8FD1,
	2039:  0x91D1,
	2040:  0x541F,
	2041:  0x9280,
	2042:  0x4E5D,
	2043:  0x5036,
	2044:  0x53E5,
	2045:  0x533A,
	2046:  0x72D7,
	2047:  0x7396,
	2048:  0x77E9,
	2049:  0x82E6,
	2050:  0x8EAF,
	2051:  0x99C6,
	2052:  0x99C8,
	2053:  0x99D2,
	2054:  0x5177,
	2055:  0x611A,
	2056:  0x865E,
	2057:  0x55B0,
	2058:  0x7A7A,
	2059:  0x5076,
	2060:  0x5BD3,
	2061:  0x9047,
	2062:  0x9685,
	2063:  0x4E32,
	2064:  0x6ADB,
	2065:  0x91E7,
	2066:  0x5C51,
	2067:  0x5C48,
	2068:  0x6398,
	2069:  0x7A9F,
	2070:  0x6C93,
	2071:  0x9774,
	2072:  0x8F61,
	2073:  0x7AAA,
	2074:  0x718A,
	2075:  0x9688,
	2076:  0x7C82,
	2077:  0x6817,
	2078:  0x7E70,
	2079:  0x6851,
	2080:  0x936C,
	2081:  0x52F2,
	2082:  0x541B,
	2083:  0x85AB,
	2084:  0x8A13,
	2085:  0x7FA4,
	2086:  0x8ECD,
	2087:  0x90E1,
	2088:  0x5366,
	2089:  0x8888,
	2090:  0x7941,
	2091:  0x4FC2,
	2092:  0x50BE,
	2093:  0x5211,
	2094:  0x5144,
	2095:  0x5553,
	2096:  0x572D,
	2097:  0x73EA,
	2098:  0x578B,
	2099:  0x5951,
	2100:  0x5F62,
	2101:  0x5F84,
	2102:  0x6075,
	2103:  0x6176,
	2104:  0x6167,
	2105:  0x61A9,
	2106:  0x63B2,
	2107:  0x643A,
	2108:  0x656C,
	2109:  0x666F,
	2110:  0x6842,
	2111:  0x6E13,
	2112:  0x7566,
	2113:  0x7A3D,
	2114:  0x7CFB,
	2115:  0x7D4C,
	2116:  0x7D99,
	2117:  0x7E4B,
	2118:  0x7F6B,
	2119:  0x830E,
	2120:  0x834A,
	2121:  0x86CD,
	2122:  0x8A08,
	2123:  0x8A63,
	2124:  0x8B66,
	2125:  0x8EFD,
	2126:  0x981A,
	2127:  0x9D8F,
	2128:  0x82B8,
	2129:  0x8FCE,
	2130:  0x9BE8,
	2131:  0x5287,
	2132:  0x621F,
	2133:  0x6483,
	2134:  0x6FC0,
	2135:  0x9699,
	2136:  0x6841,
	2137:  0x5091,
	2138:  0x6B20,
	2139:  0x6C7A,
	2140:  0x6F54,
	2141:  0x7A74,
	2142:  0x7D50,
	2143:  0x8840,
	2144:  0x8A23,
	2145:  0x6708,
	2146:  0x4EF6,
	2147:  0x5039,
	2148:  0x5026,
	2149:  0x5065,
	2150:  0x517C,
	2151:  0x5238,
	2152:  0x5263,
	2153:  0x55A7,
	2154:  0x570F,
	2155:  0x5805,
	2156:  0x5ACC,
	2157:  0x5EFA,
	2158:  0x61B2,
	2159:  0x61F8,
	2160:  0x62F3,
	2161:  0x6372,
	2162:  0x691C,
	2163:  0x6A29,
	2164:  0x727D,
	2165:  0x72AC,
	2166:  0x732E,
	2167:  0x7814,
	2168:  0x786F,
	2169:  0x7D79,
	2170:  0x770C,
	2171:  0x80A9,
	2172:  0x898B,
	2173:  0x8B19,
	2174:  0x8CE2,
	2175:  0x8ED2,
	2176:  0x9063,
	2177:  0x9375,
	2178:  0x967A,
	2179:  0x9855,
	2180:  0x9A13,
	2181:  0x9E78,
	2182:  0x5143,
	2183:  0x539F,
	2184:  0x53B3,
	2185:  0x5E7B,
	2186:  0x5F26,
	2187:  0x6E1B,
	2188:  0x6E90,
	2189:  0x7384,
	2190:  0x73FE,
	2191:  0x7D43,
	2192:  0x8237,
	2193:  0x8A00,
	2194:  0x8AFA,
	2195:  0x9650,
	2196:  0x4E4E,
	2197:  0x500B,
	2198:  0x53E4,
	2199:  0x547C,
	2200:  0x56FA,
	2201:  0x59D1,
	2202:  0x5B64,
	2203:  0x5DF1,
	2204:  0x5EAB,
	2205:  0x5F27,
	2206:  0x6238,
	2207:  0x6545,
	2208:  0x67AF,
	2209:  0x6E56,
	2210:  0x72D0,
	2211:  0x7CCA,
	2212:  0x88B4,
	2213:  0x80A1,
	2214:  0x80E1,
	2215:  0x83F0,
	2216:  0x864E,
	2217:  0x8A87,
	2218:  0x8DE8,
	2219:  0x9237,
	2220:  0x96C7,
	2221:  0x9867,
	2222:  0x9F13,
	2223:  0x4E94,
	2224:  0x4E92,
	2225:  0x4F0D,
	2226:  0x5348,
	2227:  0x5449,
	2228:  0x543E,
	2229:  0x5A2F,
	2230:  0x5F8C,
	2231:  0x5FA1,
	2232:  0x609F,
	2233:  0x68A7,
	2234:  0x6A8E,
	2235:  0x745A,
	2236:  0x7881,
	2237:  0x8A9E,
	2238:  0x8AA4,
	2239:  0x8B77,
	2240:  0x9190,
	2241:  0x4E5E,
	2242:  0x9BC9,
	2243:  0x4EA4,
	2244:  0x4F7C,
	2245:  0x4FAF,
	2246:  0x5019,
	2247:  0x5016,
	2248:  0x5149,
	2249:  0x516C,
	2250:  0x529F,
	2251:  0x52B9,
	2252:  0x52FE,
	2253:  0x539A,
	2254:  0x53E3,
	2255:  0x5411,
	2256:  0x540E,
	2257:  0x5589,
	2258:  0x5751,
	2259:  0x57A2,
	2260:  0x597D,
	2261:  0x5B54,
	2262:  0x5B5D,
	2263:  0x5B8F,
	2264:  0x5DE5,
	2265:  0x5DE7,
	2266:  0x5DF7,
	2267:  0x5E78,
	2268:  0x5E83,
	2269:  0x5E9A,
	2270:  0x5EB7,
	2271:  0x5F18,
	2272:  0x6052,
	2273:  0x614C,
	2274:  0x6297,
	2275:  0x62D8,
	2276:  0x63A7,
	2277:  0x653B,
	2278:  0x6602,
	2279:  0x6643,
	2280:  0x66F4,
	2281:  0x676D,
	2282:  0x6821,
	2283:  0x6897,
	2284:  0x69CB,
	2285:  0x6C5F,
	2286:  0x6D2A,
	2287:  0x6D69,
	2288:  0x6E2F,
	2289:  0x6E9D,
	2290:  0x7532,
	2291:  0x7687,
	2292:  0x786C,
	2293:  0x7A3F,
	2294:  0x7CE0,
	2295:  0x7D05,
	2296:  0x7D18,
	2297:  0x7D5E,
	2298:  0x7DB1,
	2299:  0x8015,
	2300:  0x8003,
	2301:  0x80AF,
	2302:  0x80B1,
	2303:  0x8154,
	2304:  0x818F,
	2305:  0x822A,
	2306:  0x8352,
	2307:  0x884C,
	2308:  0x8861,
	2309:  0x8B1B,
	2310:  0x8CA2,
	2311:  0x8CFC,
	2312:  0x90CA,
	2313:  0x9175,
	2314:  0x9271,
	2315:  0x783F,
	2316:  0x92FC,
	2317:  0x95A4,
	2318:  0x964D,
	2319:  0x9805,
	2320:  0x9999,
	2321:  0x9AD8,
	2322:  0x9D3B,
	2323:  0x525B,
	2324:  0x52AB,
	2325:  0x53F7,
	2326:  0x5408,
	2327:  0x58D5,
	2328:  0x62F7,
	2329:  0x6FE0,
	2330:  0x8C6A,
	2331:  0x8F5F,
	2332:  0x9EB9,
	2333:  0x514B,
	2334:  0x523B,
	2335:  0x544A,
	2336:  0x56FD,
	2337:  0x7A40,
	2338:  0x9177,
	2339:  0x9D60,
	2340:  0x9ED2,
	2341:  0x7344,
	2342:  0x6F09,
	2343:  0x8170,
	2344:  0x7511,
	2345:  0x5FFD,
	2346:  0x60DA,
	2347:  0x9AA8,
	2348:  0x72DB,
	2349:  0x8FBC,
	2350:  0x6B64,
	2351:  0x9803,
	2352:  0x4ECA,
	2353:  0x56F0,
	2354:  0x5764,
	2355:  0x58BE,
	2356:  0x5A5A,
	2357:  0x6068,
	2358:  0x61C7,
	2359:  0x660F,
	2360:  0x6606,
	2361:  0x6839,
	2362:  0x68B1,
	2363:  0x6DF7,
	2364:  0x75D5,
	2365:  0x7D3A,
	2366:  0x826E,
	2367:  0x9B42,
	2368:  0x4E9B,
	2369:  0x4F50,
	2370:  0x53C9,
	2371:  0x5506,
	2372:  0x5D6F,
	2373:  0x5DE6,
	2374:  0x5DEE,
	2375:  0x67FB,
	2376:  0x6C99,
	2377:  0x7473,
	2378:  0x7802,
	2379:  0x8A50,
	2380:  0x9396,
	2381:  0x88DF,
	2382:  0x5750,
	2383:  0x5EA7,
	2384:  0x632B,
	2385:  0x50B5,
	2386:  0x50AC,
	2387:  0x518D,
	2388:  0x6700,
	2389:  0x54C9,
	2390:  0x585E,
	2391:  0x59BB,
	2392:  0x5BB0,
	2393:  0x5F69,
	2394:  0x624D,
	2395:  0x63A1,
	2396:  0x683D,
	2397:  0x6B73,
	2398:  0x6E08,
	2399:  0x707D,
	2400:  0x91C7,
	2401:  0x7280,
	2402:  0x7815,
	2403:  0x7826,
	2404:  0x796D,
	2405:  0x658E,
	2406:  0x7D30,
	2407:  0x83DC,
	2408:  0x88C1,
	2409:  0x8F09,
	2410:  0x969B,
	2411:  0x5264,
	2412:  0x5728,
	2413:  0x6750,
	2414:  0x7F6A,
	2415:  0x8CA1,
	2416:  0x51B4,
	2417:  0x5742,
	2418:  0x962A,
	2419:  0x583A,
	2420:  0x698A,
	2421:  0x80B4,
	2422:  0x54B2,
	2423:  0x5D0E,
	2424:  0x57FC,
	2425:  0x7895,
	2426:  0x9DFA,
	2427:  0x4F5C,
	2428:  0x524A,
	2429:  0x548B,
	2430:  0x643E,
	2431:  0x6628,
	2432:  0x6714,
	2433:  0x67F5,
	2434:  0x7A84,
	2435:  0x7B56,
	2436:  0x7D22,
	2437:  0x932F,
	2438:  0x685C,
	2439:  0x9BAD,
	2440:  0x7B39,
	2441:  0x5319,
	2442:  0x518A,
	2443:  0x5237,
	2444:  0x5BDF,
	2445:  0x62F6,
	2446:  0x64AE,
	2447:  0x64E6,
	2448:  0x672D,
	2449:  0x6BBA,
	2450:  0x85A9,
	2451:  0x96D1,
	2452:  0x7690,
	2453:  0x9BD6,
	2454:  0x634C,
	2455:  0x9306,
	2456:  0x9BAB,
	2457:  0x76BF,
	2458:  0x6652,
	2459:  0x4E09,
	2460:  0x5098,
	2461:  0x53C2,
	2462:  0x5C71,
	2463:  0x60E8,
	2464:  0x6492,
	2465:  0x6563,
	2466:  0x685F,
	2467:  0x71E6,
	2468:  0x73CA,
	2469:  0x7523,
	2470:  0x7B97,
	2471:  0x7E82,
	2472:  0x8695,
	2473:  0x8B83,
	2474:  0x8CDB,
	2475:  0x9178,
	2476:  0x9910,
	2477:  0x65AC,
	2478:  0x66AB,
	2479:  0x6B8B,
	2480:  0x4ED5,
	2481:  0x4ED4,
	2482:  0x4F3A,
	2483:  0x4F7F,
	2484:  0x523A,
	2485:  0x53F8,
	2486:  0x53F2,
	2487:  0x55E3,
	2488:  0x56DB,
	2489:  0x58EB,
	2490:  0x59CB,
	2491:  0x59C9,
	2492:  0x59FF,
	2493:  0x5B50,
	2494:  0x5C4D,
	2495:  0x5E02,
	2496:  0x5E2B,
	2497:  0x5FD7,
	2498:  0x601D,
	2499:  0x6307,
	2500:  0x652F,
	2501:  0x5B5C,
	2502:  0x65AF,
	2503:  0x65BD,
	2504:  0x65E8,
	2505:  0x679D,
	2506:  0x6B62,
	2507:  0x6B7B,
	2508:  0x6C0F,
	2509:  0x7345,
	2510:  0x7949,
	2511:  0x79C1,
	2512:  0x7CF8,
	2513:  0x7D19,
	2514:  0x7D2B,
	2515:  0x80A2,
	2516:  0x8102,
	2517:  0x81F3,
	2518:  0x8996,
	2519:  0x8A5E,
	2520:  0x8A69,
	2521:  0x8A66,
	2522:  0x8A8C,
	2523:  0x8AEE,
	2524:  0x8CC7,
	2525:  0x8CDC,
	2526:  0x96CC,
	2527:  0x98FC,
	2528:  0x6B6F,
	2529:  0x4E8B,
	2530:  0x4F3C,
	2531:  0x4F8D,
	2532:  0x5150,
	2533:  0x5B57,
	2534:  0x5BFA,
	2535:  0x6148,
	2536:  0x6301,
	2537:  0x6642,
	2538:  0x6B21,
	2539:  0x6ECB,
	2540:  0x6CBB,
	2541:  0x723E,
	2542:  0x74BD,
	2543:  0x75D4,
	2544:  0x78C1,
	2545:  0x793A,
	2546:  0x800C,
	2547:  0x8033,
	2548:  0x81EA,
	2549:  0x8494,
	2550:  0x8F9E,
	2551:  0x6C50,
	2552:  0x9E7F,
	2553:  0x5F0F,
	2554:  0x8B58,
	2555:  0x9D2B,
	2556:  0x7AFA,
	2557:  0x8EF8,
	2558:  0x5B8D,
	2559:  0x96EB,
	2560:  0x4E03,
	2561:  0x53F1,
	2562:  0x57F7,
	2563:  0x5931,
	2564:  0x5AC9,
	2565:  0x5BA4,
	2566:  0x6089,
	2567:  0x6E7F,
	2568:  0x6F06,
	2569:  0x75BE,
	2570:  0x8CEA,
	2571:  0x5B9F,
	2572:  0x8500,
	2573:  0x7BE0,
	2574:  0x5072,
	2575:  0x67F4,
	2576:  0x829D,
	2577:  0x5C61,
	2578:  0x854A,
	2579:  0x7E1E,
	2580:  0x820E,
	2581:  0x5199,
	2582:  0x5C04,
	2583:  0x6368,
	2584:  0x8D66,
	2585:  0x659C,
	2586:  0x716E,
	2587:  0x793E,
	2588:  0x7D17,
	2589:  0x8005,
	2590:  0x8B1D,
	2591:  0x8ECA,
	2592:  0x906E,
	2593:  0x86C7,
	2594:  0x90AA,
	2595:  0x501F,
	2596:  0x52FA,
	2597:  0x5C3A,
	2598:  0x6753,
	2599:  0x707C,
	2600:  0x7235,
	2601:  0x914C,
	2602:  0x91C8,
	2603:  0x932B,
	2604:  0x82E5,
	2605:  0x5BC2,
	2606:  0x5F31,
	2607:  0x60F9,
	2608:  0x4E3B,
	2609:  0x53D6,
	2610:  0x5B88,
	2611:  0x624B,
	2612:  0x6731,
	2613:  0x6B8A,
	2614:  0x72E9,
	2615:  0x73E0,
	2616:  0x7A2E,
	2617:  0x816B,
	2618:  0x8DA3,
	2619:  0x9152,
	2620:  0x9996,
	2621:  0x5112,
	2622:  0x53D7,
	2623:  0x546A,
	2624:  0x5BFF,
	2625:  0x6388,
	2626:  0x6A39,
	2627:  0x7DAC,
	2628:  0x9700,
	2629:  0x56DA,
	2630:  0x53CE,
	2631:  0x5468,
	2632:  0x5B97,
	2633:  0x5C31,
	2634:  0x5DDE,
	2635:  0x4FEE,
	2636:  0x6101,
	2637:  0x62FE,
	2638:  0x6D32,
	2639:  0x79C0,
	2640:  0x79CB,
	2641:  0x7D42,
	2642:  0x7E4D,
	2643:  0x7FD2,
	2644:  0x81ED,
	2645:  0x821F,
	2646:  0x8490,
	2647:  0x8846,
	2648:  0x8972,
	2649:  0x8B90,
	2650:  0x8E74,
	2651:  0x8F2F,
	2652:  0x9031,
	2653:  0x914B,
	2654:  0x916C,
	2655:  0x96C6,
	2656:  0x919C,
	2657:  0x4EC0,
	2658:  0x4F4F,
	2659:  0x5145,
	2660:  0x5341,
	2661:  0x5F93,
	2662:  0x620E,
	2663:  0x67D4,
	2664:  0x6C41,
	2665:  0x6E0B,
	2666:  0x7363,
	2667:  0x7E26,
	2668:  0x91CD,
	2669:  0x9283,
	2670:  0x53D4,
	2671:  0x5919,
	2672:  0x5BBF,
	2673:  0x6DD1,
	2674:  0x795D,
	2675:  0x7E2E,
	2676:  0x7C9B,
	2677:  0x587E,
	2678:  0x719F,
	2679:  0x51FA,
	2680:  0x8853,
	2681:  0x8FF0,
	2682:  0x4FCA,
	2683:  0x5CFB,
	2684:  0x6625,
	2685:  0x77AC,
	2686:  0x7AE3,
	2687:  0x821C,
	2688:  0x99FF,
	2689:  0x51C6,
	2690:  0x5FAA,
	2691:  0x65EC,
	2692:  0x696F,
	2693:  0x6B89,
	2694:  0x6DF3,
	2695:  0x6E96,
	2696:  0x6F64,
	2697:  0x76FE,
	2698:  0x7D14,
	2699:  0x5DE1,
	2700:  0x9075,
	2701:  0x9187,
	2702:  0x9806,
	2703:  0x51E6,
	2704:  0x521D,
	2705:  0x6240,
	2706:  0x6691,
	2707:  0x66D9,
	2708:  0x6E1A,
	2709:  0x5EB6,
	2710:  0x7DD2,
	2711:  0x7F72,
	2712:  0x66F8,
	2713:  0x85AF,
	2714:  0x85F7,
	2715:  0x8AF8,
	2716:  0x52A9,
	2717:  0x53D9,
	2718:  0x5973,
	2719:  0x5E8F,
	2720:  0x5F90,
	2721:  0x6055,
	2722:  0x92E4,
	2723:  0x9664,
	2724:  0x50B7,
	2725:  0x511F,
	2726:  0x52DD,
	2727:  0x5320,
	2728:  0x5347,
	2729:  0x53EC,
	2730:  0x54E8,
	2731:  0x5546,
	2732:  0x5531,
	2733:  0x5617,
	2734:  0x5968,
	2735:  0x59BE,
	2736:  0x5A3C,
	2737:  0x5BB5,
	2738:  0x5C06,
	2739:  0x5C0F,
	2740:  0x5C11,
	2741:  0x5C1A,
	2742:  0x5E84,
	2743:  0x5E8A,
	2744:  0x5EE0,
	2745:  0x5F70,
	2746:  0x627F,
	2747:  0x6284,
	2748:  0x62DB,
	2749:  0x638C,
	2750:  0x6377,
	2751:  0x6607,
	2752:  0x660C,
	2753:  0x662D,
	2754:  0x6676,
	2755:  0x677E,
	2756:  0x68A2,
	2757:  0x6A1F,
	2758:  0x6A35,
	2759:  0x6CBC,
	2760:  0x6D88,
	2761:  0x6E09,
	2762:  0x6E58,
	2763:  0x713C,
	2764:  0x7126,
	2765:  0x7167,
	2766:  0x75C7,
	2767:  0x7701,
	2768:  0x785D,
	2769:  0x7901,
	2770:  0x7965,
	2771:  0x79F0,
	2772:  0x7AE0,
	2773:  0x7B11,
	2774:  0x7CA7,
	2775:  0x7D39,
	2776:  0x8096,
	2777:  0x83D6,
	2778:  0x848B,
	2779:  0x8549,
	2780:  0x885D,
	2781:  0x88F3,
	2782:  0x8A1F,
	2783:  0x8A3C,
	2784:  0x8A54,
	2785:  0x8A73,
	2786:  0x8C61,
	2787:  0x8CDE,
	2788:  0x91A4,
	2789:  0x9266,
	2790:  0x937E,
	2791:  0x9418,
	2792:  0x969C,
	2793:  0x9798,
	2794:  0x4E0A,
	2795:  0x4E08,
	2796:  0x4E1E,
	2797:  0x4E57,
	2798:  0x5197,
	2799:  0x5270,
	2800:  0x57CE,
	2801:  0x5834,
	2802:  0x58CC,
	2803:  0x5B22,
	2804:  0x5E38,
	2805:  0x60C5,
	2806:  0x64FE,
	2807:  0x6761,
	2808:  0x6756,
	2809:  0x6D44,
	2810:  0x72B6,
	2811:  0x7573,
	2812:  0x7A63,
	2813:  0x84B8,
	2814:  0x8B72,
	2815:  0x91B8,
	2816:  0x9320,
	2817:  0x5631,
	2818:  0x57F4,
	2819:  0x98FE,
	2820:  0x62ED,
	2821:  0x690D,
	2822:  0x6B96,
	2823:  0x71ED,
	2824:  0x7E54,
	2825:  0x8077,
	2826:  0x8272,
	2827:  0x89E6,
	2828:  0x98DF,
	2829:  0x8755,
	2830:  0x8FB1,
	2831:  0x5C3B,
	2832:  0x4F38,
	2833:  0x4FE1,
	2834:  0x4FB5,
	2835:  0x5507,
	2836:  0x5A20,
	2837:  0x5BDD,
	2838:  0x5BE9,
	2839:  0x5FC3,
	2840:  0x614E,
	2841:  0x632F,
	2842:  0x65B0,
	2843:  0x664B,
	2844:  0x68EE,
	2845:  0x699B,
	2846:  0x6D78,
	2847:  0x6DF1,
	2848:  0x7533,
	2849:  0x75B9,
	2850:  0x771F,
	2851:  0x795E,
	2852:  0x79E6,
	2853:  0x7D33,
	2854:  0x81E3,
	2855:  0x82AF,
	2856:  0x85AA,
	2857:  0x89AA,
	2858:  0x8A3A,
	2859:  0x8EAB,
	2860:  0x8F9B,
	2861:  0x9032,
	2862:  0x91DD,
	2863:  0x9707,
	2864:  0x4EBA,
	2865:  0x4EC1,
	2866:  0x5203,
	2867:  0x5875,
	2868:  0x58EC,
	2869:  0x5C0B,
	2870:  0x751A,
	2871:  0x5C3D,
	2872:  0x814E,
	2873:  0x8A0A,
	2874:  0x8FC5,
	2875:  0x9663,
	2876:  0x976D,
	2877:  0x7B25,
	2878:  0x8ACF,
	2879:  0x9808,
	2880:  0x9162,
	2881:  0x56F3,
	2882:  0x53A8,
	2883:  0x9017,
	2884:  0x5439,
	2885:  0x5782,
	2886:  0x5E25,
	2887:  0x63A8,
	2888:  0x6C34,
	2889:  0x708A,
	2890:  0x7761,
	2891:  0x7C8B,
	2892:  0x7FE0,
	2893:  0x8870,
	2894:  0x9042,
	2895:  0x9154,
	2896:  0x9310,
	2897:  0x9318,
	2898:  0x968F,
	2899:  0x745E,
	2900:  0x9AC4,
	2901:  0x5D07,
	2902:  0x5D69,
	2903:  0x6570,
	2904:  0x67A2,
	2905:  0x8DA8,
	2906:  0x96DB,
	2907:  0x636E,
	2908:  0x6749,
	2909:  0x6919,
	2910:  0x83C5,
	2911:  0x9817,
	2912:  0x96C0,
	2913:  0x88FE,
	2914:  0x6F84,
	2915:  0x647A,
	2916:  0x5BF8,
	2917:  0x4E16,
	2918:  0x702C,
	2919:  0x755D,
	2920:  0x662F,
	2921:  0x51C4,
	2922:  0x5236,
	2923:  0x52E2,
	2924:  0x59D3,
	2925:  0x5F81,
	2926:  0x6027,
	2927:  0x6210,
	2928:  0x653F,
	2929:  0x6574,
	2930:  0x661F,
	2931:  0x6674,
	2932:  0x68F2,
	2933:  0x6816,
	2934:  0x6B63,
	2935:  0x6E05,
	2936:  0x7272,
	2937:  0x751F,
	2938:  0x76DB,
	2939:  0x7CBE,
	2940:  0x8056,
	2941:  0x58F0,
	2942:  0x88FD,
	2943:  0x897F,
	2944:  0x8AA0,
	2945:  0x8A93,
	2946:  0x8ACB,
	2947:  0x901D,
	2948:  0x9192,
	2949:  0x9752,
	2950:  0x9759,
	2951:  0x6589,
	2952:  0x7A0E,
	2953:  0x8106,
	2954:  0x96BB,
	2955:  0x5E2D,
	2956:  0x60DC,
	2957:  0x621A,
	2958:  0x65A5,
	2959:  0x6614,
	2960:  0x6790,
	2961:  0x77F3,
	2962:  0x7A4D,
	2963:  0x7C4D,
	2964:  0x7E3E,
	2965:  0x810A,
	2966:  0x8CAC,
	2967:  0x8D64,
	2968:  0x8DE1,
	2969:  0x8E5F,
	2970:  0x78A9,
	2971:  0x5207,
	2972:  0x62D9,
	2973:  0x63A5,
	2974:  0x6442,
	2975:  0x6298,
	2976:  0x8A2D,
	2977:  0x7A83,
	2978:  0x7BC0,
	2979:  0x8AAC,
	2980:  0x96EA,
	2981:  0x7D76,
	2982:  0x820C,
	2983:  0x8749,
	2984:  0x4ED9,
	2985:  0x5148,
	2986:  0x5343,
	2987:  0x5360,
	2988:  0x5BA3,
	2989:  0x5C02,
	2990:  0x5C16,
	2991:  0x5DDD,
	2992:  0x6226,
	2993:  0x6247,
	2994:  0x64B0,
	2995:  0x6813,
	2996:  0x6834,
	2997:  0x6CC9,
	2998:  0x6D45,
	2999:  0x6D17,
	3000:  0x67D3,
	3001:  0x6F5C,
	3002:  0x714E,
	3003:  0x717D,
	3004:  0x65CB,
	3005:  0x7A7F,
	3006:  0x7BAD,
	3007:  0x7DDA,
	3008:  0x7E4A,
	3009:  0x7FA8,
	3010:  0x817A,
	3011:  0x821B,
	3012:  0x8239,
	3013:  0x85A6,
	3014:  0x8A6E,
	3015:  0x8CCE,
	3016:  0x8DF5,
	3017:  0x9078,
	3018:  0x9077,
	3019:  0x92AD,
	3020:  0x9291,
	3021:  0x9583,
	3022:  0x9BAE,
	3023:  0x524D,
	3024:  0x5584,
	3025:  0x6F38,
	3026:  0x7136,
	3027:  0x5168,
	3028:  0x7985,
	3029:  0x7E55,
	3030:  0x81B3,
	3031:  0x7CCE,
	3032:  0x564C,
	3033:  0x5851,
	3034:  0x5CA8,
	3035:  0x63AA,
	3036:  0x66FE,
	3037:  0x66FD,
	3038:  0x695A,
	3039:  0x72D9,
	3040:  0x758F,
	3041:  0x758E,
	3042:  0x790E,
	3043:  0x7956,
	3044:  0x79DF,
	3045:  0x7C97,
	3046:  0x7D20,
	3047:  0x7D44,
	3048:  0x8607,
	3049:  0x8A34,
	3050:  0x963B,
	3051:  0x9061,
	3052:  0x9F20,
	3053:  0x50E7,
	3054:  0x5275,
	3055:  0x53CC,
	3056:  0x53E2,
	3057:  0x5009,
	3058:  0x55AA,
	3059:  0x58EE,
	3060:  0x594F,
	3061:  0x723D,
	3062:  0x5B8B,
	3063:  0x5C64,
	3064:  0x531D,
	3065:  0x60E3,
	3066:  0x60F3,
	3067:  0x635C,
	3068:  0x6383,
	3069:  0x633F,
	3070:  0x63BB,
	3071:  0x64CD,
	3072:  0x65E9,
	3073:  0x66F9,
	3074:  0x5DE3,
	3075:  0x69CD,
	3076:  0x69FD,
	3077:  0x6F15,
	3078:  0x71E5,
	3079:  0x4E89,
	3080:  0x75E9,
	3081:  0x76F8,
	3082:  0x7A93,
	3083:  0x7CDF,
	3084:  0x7DCF,
	3085:  0x7D9C,
	3086:  0x8061,
	3087:  0x8349,
	3088:  0x8358,
	3089:  0x846C,
	3090:  0x84BC,
	3091:  0x85FB,
	3092:  0x88C5,
	3093:  0x8D70,
	3094:  0x9001,
	3095:  0x906D,
	3096:  0x9397,
	3097:  0x971C,
	3098:  0x9A12,
	3099:  0x50CF,
	3100:  0x5897,
	3101:  0x618E,
	3102:  0x81D3,
	3103:  0x8535,
	3104:  0x8D08,
	3105:  0x9020,
	3106:  0x4FC3,
	3107:  0x5074,
	3108:  0x5247,
	3109:  0x5373,
	3110:  0x606F,
	3111:  0x6349,
	3112:  0x675F,
	3113:  0x6E2C,
	3114:  0x8DB3,
	3115:  0x901F,
	3116:  0x4FD7,
	3117:  0x5C5E,
	3118:  0x8CCA,
	3119:  0x65CF,
	3120:  0x7D9A,
	3121:  0x5352,
	3122:  0x8896,
	3123:  0x5176,
	3124:  0x63C3,
	3125:  0x5B58,
	3126:  0x5B6B,
	3127:  0x5C0A,
	3128:  0x640D,
	3129:  0x6751,
	3130:  0x905C,
	3131:  0x4ED6,
	3132:  0x591A,
	3133:  0x592A,
	3134:  0x6C70,
	3135:  0x8A51,
	3136:  0x553E,
	3137:  0x5815,
	3138:  0x59A5,
	3139:  0x60F0,
	3140:  0x6253,
	3141:  0x67C1,
	3142:  0x8235,
	3143:  0x6955,
	3144:  0x9640,
	3145:  0x99C4,
	3146:  0x9A28,
	3147:  0x4F53,
	3148:  0x5806,
	3149:  0x5BFE,
	3150:  0x8010,
	3151:  0x5CB1,
	3152:  0x5E2F,
	3153:  0x5F85,
	3154:  0x6020,
	3155:  0x614B,
	3156:  0x6234,
	3157:  0x66FF,
	3158:  0x6CF0,
	3159:  0x6EDE,
	3160:  0x80CE,
	3161:  0x817F,
	3162:  0x82D4,
	3163:  0x888B,
	3164:  0x8CB8,
	3165:  0x9000,
	3166:  0x902E,
	3167:  0x968A,
	3168:  0x9EDB,
	3169:  0x9BDB,
	3170:  0x4EE3,
	3171:  0x53F0,
	3172:  0x5927,
	3173:  0x7B2C,
	3174:  0x918D,
	3175:  0x984C,
	3176:  0x9DF9,
	3177:  0x6EDD,
	3178:  0x7027,
	3179:  0x5353,
	3180:  0x5544,
	3181:  0x5B85,
	3182:  0x6258,
	3183:  0x629E,
	3184:  0x62D3,
	3185:  0x6CA2,
	3186:  0x6FEF,
	3187:  0x7422,
	3188:  0x8A17,
	3189:  0x9438,
	3190:  0x6FC1,
	3191:  0x8AFE,
	3192:  0x8338,
	3193:  0x51E7,
	3194:  0x86F8,
	3195:  0x53EA,
	3196:  0x53E9,
	3197:  0x4F46,
	3198:  0x9054,
	3199:  0x8FB0,
	3200:  0x596A,
	3201:  0x8131,
	3202:  0x5DFD,
	3203:  0x7AEA,
	3204:  0x8FBF,
	3205:  0x68DA,
	3206:  0x8C37,
	3207:  0x72F8,
	3208:  0x9C48,
	3209:  0x6A3D,
	3210:  0x8AB0,
	3211:  0x4E39,
	3212:  0x5358,
	3213:  0x5606,
	3214:  0x5766,
	3215:  0x62C5,
	3216:  0x63A2,
	3217:  0x65E6,
	3218:  0x6B4E,
	3219:  0x6DE1,
	3220:  0x6E5B,
	3221:  0x70AD,
	3222:  0x77ED,
	3223:  0x7AEF,
	3224:  0x7BAA,
	3225:  0x7DBB,
	3226:  0x803D,
	3227:  0x80C6,
	3228:  0x86CB,
	3229:  0x8A95,
	3230:  0x935B,
	3231:  0x56E3,
	3232:  0x58C7,
	3233:  0x5F3E,
	3234:  0x65AD,
	3235:  0x6696,
	3236:  0x6A80,
	3237:  0x6BB5,
	3238:  0x7537,
	3239:  0x8AC7,
	3240:  0x5024,
	3241:  0x77E5,
	3242:  0x5730,
	3243:  0x5F1B,
	3244:  0x6065,
	3245:  0x667A,
	3246:  0x6C60,
	3247:  0x75F4,
	3248:  0x7A1A,
	3249:  0x7F6E,
	3250:  0x81F4,
	3251:  0x8718,
	3252:  0x9045,
	3253:  0x99B3,
	3254:  0x7BC9,
	3255:  0x755C,
	3256:  0x7AF9,
	3257:  0x7B51,
	3258:  0x84C4,
	3259:  0x9010,
	3260:  0x79E9,
	3261:  0x7A92,
	3262:  0x8336,
	3263:  0x5AE1,
	3264:  0x7740,
	3265:  0x4E2D,
	3266:  0x4EF2,
	3267:  0x5B99,
	3268:  0x5FE0,
	3269:  0x62BD,
	3270:  0x663C,
	3271:  0x67F1,
	3272:  0x6CE8,
	3273:  0x866B,
	3274:  0x8877,
	3275:  0x8A3B,
	3276:  0x914E,
	3277:  0x92F3,
	3278:  0x99D0,
	3279:  0x6A17,
	3280:  0x7026,
	3281:  0x732A,
	3282:  0x82E7,
	3283:  0x8457,
	3284:  0x8CAF,
	3285:  0x4E01,
	3286:  0x5146,
	3287:  0x51CB,
	3288:  0x558B,
	3289:  0x5BF5,
	3290:  0x5E16,
	3291:  0x5E33,
	3292:  0x5E81,
	3293:  0x5F14,
	3294:  0x5F35,
	3295:  0x5F6B,
	3296:  0x5FB4,
	3297:  0x61F2,
	3298:  0x6311,
	3299:  0x66A2,
	3300:  0x671D,
	3301:  0x6F6E,
	3302:  0x7252,
	3303:  0x753A,
	3304:  0x773A,
	3305:  0x8074,
	3306:  0x8139,
	3307:  0x8178,
	3308:  0x8776,
	3309:  0x8ABF,
	3310:  0x8ADC,
	3311:  0x8D85,
	3312:  0x8DF3,
	3313:  0x929A,
	3314:  0x9577,
	3315:  0x9802,
	3316:  0x9CE5,
	3317:  0x52C5,
	3318:  0x6357,
	3319:  0x76F4,
	3320:  0x6715,
	3321:  0x6C88,
	3322:  0x73CD,
	3323:  0x8CC3,
	3324:  0x93AE,
	3325:  0x9673,
	3326:  0x6D25,
	3327:  0x589C,
	3328:  0x690E,
	3329:  0x69CC,
	3330:  0x8FFD,
	3331:  0x939A,
	3332:  0x75DB,
	3333:  0x901A,
	3334:  0x585A,
	3335:  0x6802,
	3336:  0x63B4,
	3337:  0x69FB,
	3338:  0x4F43,
	3339:  0x6F2C,
	3340:  0x67D8,
	3341:  0x8FBB,
	3342:  0x8526,
	3343:  0x7DB4,
	3344:  0x9354,
	3345:  0x693F,
	3346:  0x6F70,
	3347:  0x576A,
	3348:  0x58F7,
	3349:  0x5B2C,
	3350:  0x7D2C,
	3351:  0x722A,
	3352:  0x540A,
	3353:  0x91E3,
	3354:  0x9DB4,
	3355:  0x4EAD,
	3356:  0x4F4E,
	3357:  0x505C,
	3358:  0x5075,
	3359:  0x5243,
	3360:  0x8C9E,
	3361:  0x5448,
	3362:  0x5824,
	3363:  0x5B9A,
	3364:  0x5E1D,
	3365:  0x5E95,
	3366:  0x5EAD,
	3367:  0x5EF7,
	3368:  0x5F1F,
	3369:  0x608C,
	3370:  0x62B5,
	3371:  0x633A,
	3372:  0x63D0,
	3373:  0x68AF,
	3374:  0x6C40,
	3375:  0x7887,
	3376:  0x798E,
	3377:  0x7A0B,
	3378:  0x7DE0,
	3379:  0x8247,
	3380:  0x8A02,
	3381:  0x8AE6,
	3382:  0x8E44,
	3383:  0x9013,
	3384:  0x90B8,
	3385:  0x912D,
	3386:  0x91D8,
	3387:  0x9F0E,
	3388:  0x6CE5,
	3389:  0x6458,
	3390:  0x64E2,
	3391:  0x6575,
	3392:  0x6EF4,
	3393:  0x7684,
	3394:  0x7B1B,
	3395:  0x9069,
	3396:  0x93D1,
	3397:  0x6EBA,
	3398:  0x54F2,
	3399:  0x5FB9,
	3400:  0x64A4,
	3401:  0x8F4D,
	3402:  0x8FED,
	3403:  0x9244,
	3404:  0x5178,
	3405:  0x586B,
	3406:  0x5929,
	3407:  0x5C55,
	3408:  0x5E97,
	3409:  0x6DFB,
	3410:  0x7E8F,
	3411:  0x751C,
	3412:  0x8CBC,
	3413:  0x8EE2,
	3414:  0x985B,
	3415:  0x70B9,
	3416:  0x4F1D,
	3417:  0x6BBF,
	3418:  0x6FB1,
	3419:  0x7530,
	3420:  0x96FB,
	3421:  0x514E,
	3422:  0x5410,
	3423:  0x5835,
	3424:  0x5857,
	3425:  0x59AC,
	3426:  0x5C60,
	3427:  0x5F92,
	3428:  0x6597,
	3429:  0x675C,
	3430:  0x6E21,
	3431:  0x767B,
	3432:  0x83DF,
	3433:  0x8CED,
	3434:  0x9014,
	3435:  0x90FD,
	3436:  0x934D,
	3437:  0x7825,
	3438:  0x783A,
	3439:  0x52AA,
	3440:  0x5EA6,
	3441:  0x571F,
	3442:  0x5974,
	3443:  0x6012,
	3444:  0x5012,
	3445:  0x515A,
	3446:  0x51AC,
	3447:  0x51CD,
	3448:  0x5200,
	3449:  0x5510,
	3450:  0x5854,
	3451:  0x5858,
	3452:  0x5957,
	3453:  0x5B95,
	3454:  0x5CF6,
	3455:  0x5D8B,
	3456:  0x60BC,
	3457:  0x6295,
	3458:  0x642D,
	3459:  0x6771,
	3460:  0x6843,
	3461:  0x68BC,
	3462:  0x68DF,
	3463:  0x76D7,
	3464:  0x6DD8,
	3465:  0x6E6F,
	3466:  0x6D9B,
	3467:  0x706F,
	3468:  0x71C8,
	3469:  0x5F53,
	3470:  0x75D8,
	3471:  0x7977,
	3472:  0x7B49,
	3473:  0x7B54,
	3474:  0x7B52,
	3475:  0x7CD6,
	3476:  0x7D71,
	3477:  0x5230,
	3478:  0x8463,
	3479:  0x8569,
	3480:  0x85E4,
	3481:  0x8A0E,
	3482:  0x8B04,
	3483:  0x8C46,
	3484:  0x8E0F,
	3485:  0x9003,
	3486:  0x900F,
	3487:  0x9419,
	3488:  0x9676,
	3489:  0x982D,
	3490:  0x9A30,
	3491:  0x95D8,
	3492:  0x50CD,
	3493:  0x52D5,
	3494:  0x540C,
	3495:  0x5802,
	3496:  0x5C0E,
	3497:  0x61A7,
	3498:  0x649E,
	3499:  0x6D1E,
	3500:  0x77B3,
	3501:  0x7AE5,
	3502:  0x80F4,
	3503:  0x8404,
	3504:  0x9053,
	3505:  0x9285,
	3506:  0x5CE0,
	3507:  0x9D07,
	3508:  0x533F,
	3509:  0x5F97,
	3510:  0x5FB3,
	3511:  0x6D9C,
	3512:  0x7279,
	3513:  0x7763,
	3514:  0x79BF,
	3515:  0x7BE4,
	3516:  0x6BD2,
	3517:  0x72EC,
	3518:  0x8AAD,
	3519:  0x6803,
	3520:  0x6A61,
	3521:  0x51F8,
	3522:  0x7A81,
	3523:  0x6934,
	3524:  0x5C4A,
	3525:  0x9CF6,
	3526:  0x82EB,
	3527:  0x5BC5,
	3528:  0x9149,
	3529:  0x701E,
	3530:  0x5678,
	3531:  0x5C6F,
	3532:  0x60C7,
	3533:  0x6566,
	3534:  0x6C8C,
	3535:  0x8C5A,
	3536:  0x9041,
	3537:  0x9813,
	3538:  0x5451,
	3539:  0x66C7,
	3540:  0x920D,
	3541:  0x5948,
	3542:  0x90A3,
	3543:  0x5185,
	3544:  0x4E4D,
	3545:  0x51EA,
	3546:  0x8599,
	3547:  0x8B0E,
	3548:  0x7058,
	3549:  0x637A,
	3550:  0x934B,
	3551:  0x6962,
	3552:  0x99B4,
	3553:  0x7E04,
	3554:  0x7577,
	3555:  0x5357,
	3556:  0x6960,
	3557:  0x8EDF,
	3558:  0x96E3,
	3559:  0x6C5D,
	3560:  0x4E8C,
	3561:  0x5C3C,
	3562:  0x5F10,
	3563:  0x8FE9,
	3564:  0x5302,
	3565:  0x8CD1,
	3566:  0x8089,
	3567:  0x8679,
	3568:  0x5EFF,
	3569:  0x65E5,
	3570:  0x4E73,
	3571:  0x5165,
	3572:  0x5982,
	3573:  0x5C3F,
	3574:  0x97EE,
	3575:  0x4EFB,
	3576:  0x598A,
	3577:  0x5FCD,
	3578:  0x8A8D,
	3579:  0x6FE1,
	3580:  0x79B0,
	3581:  0x7962,
	3582:  0x5BE7,
	3583:  0x8471,
	3584:  0x732B,
	3585:  0x71B1,
	3586:  0x5E74,
	3587:  0x5FF5,
	3588:  0x637B,
	3589:  0x649A,
	3590:  0x71C3,
	3591:  0x7C98,
	3592:  0x4E43,
	3593:  0x5EFC,
	3594:  0x4E4B,
	3595:  0x57DC,
	3596:  0x56A2,
	3597:  0x60A9,
	3598:  0x6FC3,
	3599:  0x7D0D,
	3600:  0x80FD,
	3601:  0x8133,
	3602:  0x81BF,
	3603:  0x8FB2,
	3604:  0x8997,
	3605:  0x86A4,
	3606:  0x5DF4,
	3607:  0x628A,
	3608:  0x64AD,
	3609:  0x8987,
	3610:  0x6777,
	3611:  0x6CE2,
	3612:  0x6D3E,
	3613:  0x7436,
	3614:  0x7834,
	3615:  0x5A46,
	3616:  0x7F75,
	3617:  0x82AD,
	3618:  0x99AC,
	3619:  0x4FF3,
	3620:  0x5EC3,
	3621:  0x62DD,
	3622:  0x6392,
	3623:  0x6557,
	3624:  0x676F,
	3625:  0x76C3,
	3626:  0x724C,
	3627:  0x80CC,
	3628:  0x80BA,
	3629:  0x8F29,
	3630:  0x914D,
	3631:  0x500D,
	3632:  0x57F9,
	3633:  0x5A92,
	3634:  0x6885,
	3635:  0x6973,
	3636:  0x7164,
	3637:  0x72FD,
	3638:  0x8CB7,
	3639:  0x58F2,
	3640:  0x8CE0,
	3641:  0x966A,
	3642:  0x9019,
	3643:  0x877F,
	3644:  0x79E4,
	3645:  0x77E7,
	3646:  0x8429,
	3647:  0x4F2F,
	3648:  0x5265,
	3649:  0x535A,
	3650:  0x62CD,
	3651:  0x67CF,
	3652:  0x6CCA,
	3653:  0x767D,
	3654:  0x7B94,
	3655:  0x7C95,
	3656:  0x8236,
	3657:  0x8584,
	3658:  0x8FEB,
	3659:  0x66DD,
	3660:  0x6F20,
	3661:  0x7206,
	3662:  0x7E1B,
	3663:  0x83AB,
	3664:  0x99C1,
	3665:  0x9EA6,
	3666:  0x51FD,
	3667:  0x7BB1,
	3668:  0x7872,
	3669:  0x7BB8,
	3670:  0x8087,
	3671:  0x7B48,
	3672:  0x6AE8,
	3673:  0x5E61,
	3674:  0x808C,
	3675:  0x7551,
	3676:  0x7560,
	3677:  0x516B,
	3678:  0x9262,
	3679:  0x6E8C,
	3680:  0x767A,
	3681:  0x9197,
	3682:  0x9AEA,
	3683:  0x4F10,
	3684:  0x7F70,
	3685:  0x629C,
	3686:  0x7B4F,
	3687:  0x95A5,
	3688:  0x9CE9,
	3689:  0x567A,
	3690:  0x5859,
	3691:  0x86E4,
	3692:  0x96BC,
	3693:  0x4F34,
	3694:  0x5224,
	3695:  0x534A,
	3696:  0x53CD,
	3697:  0x53DB,
	3698:  0x5E06,
	3699:  0x642C,
	3700:  0x6591,
	3701:  0x677F,
	3702:  0x6C3E,
	3703:  0x6C4E,
	3704:  0x7248,
	3705:  0x72AF,
	3706:  0x73ED,
	3707:  0x7554,
	3708:  0x7E41,
	3709:  0x822C,
	3710:  0x85E9,
	3711:  0x8CA9,
	3712:  0x7BC4,
	3713:  0x91C6,
	3714:  0x7169,
	3715:  0x9812,
	3716:  0x98EF,
	3717:  0x633D,
	3718:  0x6669,
	3719:  0x756A,
	3720:  0x76E4,
	3721:  0x78D0,
	3722:  0x8543,
	3723:  0x86EE,
	3724:  0x532A,
	3725:  0x5351,
	3726:  0x5426,
	3727:  0x5983,
	3728:  0x5E87,
	3729:  0x5F7C,
	3730:  0x60B2,
	3731:  0x6249,
	3732:  0x6279,
	3733:  0x62AB,
	3734:  0x6590,
	3735:  0x6BD4,
	3736:  0x6CCC,
	3737:  0x75B2,
	3738:  0x76AE,
	3739:  0x7891,
	3740:  0x79D8,
	3741:  0x7DCB,
	3742:  0x7F77,
	3743:  0x80A5,
	3744:  0x88AB,
	3745:  0x8AB9,
	3746:  0x8CBB,
	3747:  0x907F,
	3748:  0x975E,
	3749:  0x98DB,
	3750:  0x6A0B,
	3751:  0x7C38,
	3752:  0x5099,
	3753:  0x5C3E,
	3754:  0x5FAE,
	3755:  0x6787,
	3756:  0x6BD8,
	3757:  0x7435,
	3758:  0x7709,
	3759:  0x7F8E,
	3760:  0x9F3B,
	3761:  0x67CA,
	3762:  0x7A17,
	3763:  0x5339,
	3764:  0x758B,
	3765:  0x9AED,
	3766:  0x5F66,
	3767:  0x819D,
	3768:  0x83F1,
	3769:  0x8098,
	3770:  0x5F3C,
	3771:  0x5FC5,
	3772:  0x7562,
	3773:  0x7B46,
	3774:  0x903C,
	3775:  0x6867,
	3776:  0x59EB,
	3777:  0x5A9B,
	3778:  0x7D10,
	3779:  0x767E,
	3780:  0x8B2C,
	3781:  0x4FF5,
	3782:  0x5F6A,
	3783:  0x6A19,
	3784:  0x6C37,
	3785:  0x6F02,
	3786:  0x74E2,
	3787:  0x7968,
	3788:  0x8868,
	3789:  0x8A55,
	3790:  0x8C79,
	3791:  0x5EDF,
	3792:  0x63CF,
	3793:  0x75C5,
	3794:  0x79D2,
	3795:  0x82D7,
	3796:  0x9328,
	3797:  0x92F2,
	3798:  0x849C,
	3799:  0x86ED,
	3800:  0x9C2D,
	3801:  0x54C1,
	3802:  0x5F6C,
	3803:  0x658C,
	3804:  0x6D5C,
	3805:  0x7015,
	3806:  0x8CA7,
	3807:  0x8CD3,
	3808:  0x983B,
	3809:  0x654F,
	3810:  0x74F6,
	3811:  0x4E0D,
	3812:  0x4ED8,
	3813:  0x57E0,
	3814:  0x592B,
	3815:  0x5A66,
	3816:  0x5BCC,
	3817:  0x51A8,
	3818:  0x5E03,
	3819:  0x5E9C,
	3820:  0x6016,
	3821:  0x6276,
	3822:  0x6577,
	3823:  0x65A7,
	3824:  0x666E,
	3825:  0x6D6E,
	3826:  0x7236,
	3827:  0x7B26,
	3828:  0x8150,
	3829:  0x819A,
	3830:  0x8299,
	3831:  0x8B5C,
	3832:  0x8CA0,
	3833:  0x8CE6,
	3834:  0x8D74,
	3835:  0x961C,
	3836:  0x9644,
	3837:  0x4FAE,
	3838:  0x64AB,
	3839:  0x6B66,
	3840:  0x821E,
	3841:  0x8461,
	3842:  0x856A,
	3843:  0x90E8,
	3844:  0x5C01,
	3845:  0x6953,
	3846:  0x98A8,
	3847:  0x847A,
	3848:  0x8557,
	3849:  0x4F0F,
	3850:  0x526F,
	3851:  0x5FA9,
	3852:  0x5E45,
	3853:  0x670D,
	3854:  0x798F,
	3855:  0x8179,
	3856:  0x8907,
	3857:  0x8986,
	3858:  0x6DF5,
	3859:  0x5F17,
	3860:  0x6255,
	3861:  0x6CB8,
	3862:  0x4ECF,
	3863:  0x7269,
	3864:  0x9B92,
	3865:  0x5206,
	3866:  0x543B,
	3867:  0x5674,
	3868:  0x58B3,
	3869:  0x61A4,
	3870:  0x626E,
	3871:  0x711A,
	3872:  0x596E,
	3873:  0x7C89,
	3874:  0x7CDE,
	3875:  0x7D1B,
	3876:  0x96F0,
	3877:  0x6587,
	3878:  0x805E,
	3879:  0x4E19,
	3880:  0x4F75,
	3881:  0x5175,
	3882:  0x5840,
	3883:  0x5E63,
	3884:  0x5E73,
	3885:  0x5F0A,
	3886:  0x67C4,
	3887:  0x4E26,
	3888:  0x853D,
	3889:  0x9589,
	3890:  0x965B,
	3891:  0x7C73,
	3892:  0x9801,
	3893:  0x50FB,
	3894:  0x58C1,
	3895:  0x7656,
	3896:  0x78A7,
	3897:  0x5225,
	3898:  0x77A5,
	3899:  0x8511,
	3900:  0x7B86,
	3901:  0x504F,
	3902:  0x5909,
	3903:  0x7247,
	3904:  0x7BC7,
	3905:  0x7DE8,
	3906:  0x8FBA,
	3907:  0x8FD4,
	3908:  0x904D,
	3909:  0x4FBF,
	3910:  0x52C9,
	3911:  0x5A29,
	3912:  0x5F01,
	3913:  0x97AD,
	3914:  0x4FDD,
	3915:  0x8217,
	3916:  0x92EA,
	3917:  0x5703,
	3918:  0x6355,
	3919:  0x6B69,
	3920:  0x752B,
	3921:  0x88DC,
	3922:  0x8F14,
	3923:  0x7A42,
	3924:  0x52DF,
	3925:  0x5893,
	3926:  0x6155,
	3927:  0x620A,
	3928:  0x66AE,
	3929:  0x6BCD,
	3930:  0x7C3F,
	3931:  0x83E9,
	3932:  0x5023,
	3933:  0x4FF8,
	3934:  0x5305,
	3935:  0x5446,
	3936:  0x5831,
	3937:  0x5949,
	3938:  0x5B9D,
	3939:  0x5CF0,
	3940:  0x5CEF,
	3941:  0x5D29,
	3942:  0x5E96,
	3943:  0x62B1,
	3944:  0x6367,
	3945:  0x653E,
	3946:  0x65B9,
	3947:  0x670B,
	3948:  0x6CD5,
	3949:  0x6CE1,
	3950:  0x70F9,
	3951:  0x7832,
	3952:  0x7E2B,
	3953:  0x80DE,
	3954:  0x82B3,
	3955:  0x840C,
	3956:  0x84EC,
	3957:  0x8702,
	3958:  0x8912,
	3959:  0x8A2A,
	3960:  0x8C4A,
	3961:  0x90A6,
	3962:  0x92D2,
	3963:  0x98FD,
	3964:  0x9CF3,
	3965:  0x9D6C,
	3966:  0x4E4F,
	3967:  0x4EA1,
	3968:  0x508D,
	3969:  0x5256,
	3970:  0x574A,
	3971:  0x59A8,
	3972:  0x5E3D,
	3973:  0x5FD8,
	3974:  0x5FD9,
	3975:  0x623F,
	3976:  0x66B4,
	3977:  0x671B,
	3978:  0x67D0,
	3979:  0x68D2,
	3980:  0x5192,
	3981:  0x7D21,
	3982:  0x80AA,
	3983:  0x81A8,
	3984:  0x8B00,
	3985:  0x8C8C,
	3986:  0x8CBF,
	3987:  0x927E,
	3988:  0x9632,
	3989:  0x5420,
	3990:  0x982C,
	3991:  0x5317,
	3992:  0x50D5,
	3993:  0x535C,
	3994:  0x58A8,
	3995:  0x64B2,
	3996:  0x6734,
	3997:  0x7267,
	3998:  0x7766,
	3999:  0x7A46,
	4000:  0x91E6,
	4001:  0x52C3,
	4002:  0x6CA1,
	4003:  0x6B86,
	4004:  0x5800,
	4005:  0x5E4C,
	4006:  0x5954,
	4007:  0x672C,
	4008:  0x7FFB,
	4009:  0x51E1,
	4010:  0x76C6,
	4011:  0x6469,
	4012:  0x78E8,
	4013:  0x9B54,
	4014:  0x9EBB,
	4015:  0x57CB,
	4016:  0x59B9,
	4017:  0x6627,
	4018:  0x679A,
	4019:  0x6BCE,
	4020:  0x54E9,
	4021:  0x69D9,
	4022:  0x5E55,
	4023:  0x819C,
	4024:  0x6795,
	4025:  0x9BAA,
	4026:  0x67FE,
	4027:  0x9C52,
	4028:  0x685D,
	4029:  0x4EA6,
	4030:  0x4FE3,
	4031:  0x53C8,
	4032:  0x62B9,
	4033:  0x672B,
	4034:  0x6CAB,
	4035:  0x8FC4,
	4036:  0x4FAD,
	4037:  0x7E6D,
	4038:  0x9EBF,
	4039:  0x4E07,
	4040:  0x6162,
	4041:  0x6E80,
	4042:  0x6F2B,
	4043:  0x8513,
	4044:  0x5473,
	4045:  0x672A,
	4046:  0x9B45,
	4047:  0x5DF3,
	4048:  0x7B95,
	4049:  0x5CAC,
	4050:  0x5BC6,
	4051:  0x871C,
	4052:  0x6E4A,
	4053:  0x84D1,
	4054:  0x7A14,
	4055:  0x8108,
	4056:  0x5999,
	4057:  0x7C8D,
	4058:  0x6C11,
	4059:  0x7720,
	4060:  0x52D9,
	4061:  0x5922,
	4062:  0x7121,
	4063:  0x725F,
	4064:  0x77DB,
	4065:  0x9727,
	4066:  0x9D61,
	4067:  0x690B,
	4068:  0x5A7F,
	4069:  0x5A18,
	4070:  0x51A5,
	4071:  0x540D,
	4072:  0x547D,
	4073:  0x660E,
	4074:  0x76DF,
	4075:  0x8FF7,
	4076:  0x9298,
	4077:  0x9CF4,
	4078:  0x59EA,
	4079:  0x725D,
	4080:  0x6EC5,
	4081:  0x514D,
	4082:  0x68C9,
	4083:  0x7DBF,
	4084:  0x7DEC,
	4085:  0x9762,
	4086:  0x9EBA,
	4087:  0x6478,
	4088:  0x6A21,
	4089:  0x8302,
	4090:  0x5984,
	4091:  0x5B5F,
	4092:  0x6BDB,
	4093:  0x731B,
	4094:  0x76F2,
	4095:  0x7DB2,
	4096:  0x8017,
	4097:  0x8499,
	4098:  0x5132,
	4099:  0x6728,
	4100:  0x9ED9,
	4101:  0x76EE,
	4102:  0x6762,
	4103:  0x52FF,
	4104:  0x9905,
	4105:  0x5C24,
	4106:  0x623B,
	4107:  0x7C7E,
	4108:  0x8CB0,
	4109:  0x554F,
	4110:  0x60B6,
	4111:  0x7D0B,
	4112:  0x9580,
	4113:  0x5301,
	4114:  0x4E5F,
	4115:  0x51B6,
	4116:  0x591C,
	4117:  0x723A,
	4118:  0x8036,
	4119:  0x91CE,
	4120:  0x5F25,
	4121:  0x77E2,
	4122:  0x5384,
	4123:  0x5F79,
	4124:  0x7D04,
	4125:  0x85AC,
	4126:  0x8A33,
	4127:  0x8E8D,
	4128:  0x9756,
	4129:  0x67F3,
	4130:  0x85AE,
	4131:  0x9453,
	4132:  0x6109,
	4133:  0x6108,
	4134:  0x6CB9,
	4135:  0x7652,
	4136:  0x8AED,
	4137:  0x8F38,
	4138:  0x552F,
	4139:  0x4F51,
	4140:  0x512A,
	4141:  0x52C7,
	4142:  0x53CB,
	4143:  0x5BA5,
	4144:  0x5E7D,
	4145:  0x60A0,
	4146:  0x6182,
	4147:  0x63D6,
	4148:  0x6709,
	4149:  0x67DA,
	4150:  0x6E67,
	4151:  0x6D8C,
	4152:  0x7336,
	4153:  0x7337,
	4154:  0x7531,
	4155:  0x7950,
	4156:  0x88D5,
	4157:  0x8A98,
	4158:  0x904A,
	4159:  0x9091,
	4160:  0x90F5,
	4161:  0x96C4,
	4162:  0x878D,
	4163:  0x5915,
	4164:  0x4E88,
	4165:  0x4F59,
	4166:  0x4E0E,
	4167:  0x8A89,
	4168:  0x8F3F,
	4169:  0x9810,
	4170:  0x50AD,
	4171:  0x5E7C,
	4172:  0x5996,
	4173:  0x5BB9,
	4174:  0x5EB8,
	4175:  0x63DA,
	4176:  0x63FA,
	4177:  0x64C1,
	4178:  0x66DC,
	4179:  0x694A,
	4180:  0x69D8,
	4181:  0x6D0B,
	4182:  0x6EB6,
	4183:  0x7194,
	4184:  0x7528,
	4185:  0x7AAF,
	4186:  0x7F8A,
	4187:  0x8000,
	4188:  0x8449,
	4189:  0x84C9,
	4190:  0x8981,
	4191:  0x8B21,
	4192:  0x8E0A,
	4193:  0x9065,
	4194:  0x967D,
	4195:  0x990A,
	4196:  0x617E,
	4197:  0x6291,
	4198:  0x6B32,
	4199:  0x6C83,
	4200:  0x6D74,
	4201:  0x7FCC,
	4202:  0x7FFC,
	4203:  0x6DC0,
	4204:  0x7F85,
	4205:  0x87BA,
	4206:  0x88F8,
	4207:  0x6765,
	4208:  0x83B1,
	4209:  0x983C,
	4210:  0x96F7,
	4211:  0x6D1B,
	4212:  0x7D61,
	4213:  0x843D,
	4214:  0x916A,
	4215:  0x4E71,
	4216:  0x5375,
	4217:  0x5D50,
	4218:  0x6B04,
	4219:  0x6FEB,
	4220:  0x85CD,
	4221:  0x862D,
	4222:  0x89A7,
	4223:  0x5229,
	4224:  0x540F,
	4225:  0x5C65,
	4226:  0x674E,
	4227:  0x68A8,
	4228:  0x7406,
	4229:  0x7483,
	4230:  0x75E2,
	4231:  0x88CF,
	4232:  0x88E1,
	4233:  0x91CC,
	4234:  0x96E2,
	4235:  0x9678,
	4236:  0x5F8B,
	4237:  0x7387,
	4238:  0x7ACB,
	4239:  0x844E,
	4240:  0x63A0,
	4241:  0x7565,
	4242:  0x5289,
	4243:  0x6D41,
	4244:  0x6E9C,
	4245:  0x7409,
	4246:  0x7559,
	4247:  0x786B,
	4248:  0x7C92,
	4249:  0x9686,
	4250:  0x7ADC,
	4251:  0x9F8D,
	4252:  0x4FB6,
	4253:  0x616E,
	4254:  0x65C5,
	4255:  0x865C,
	4256:  0x4E86,
	4257:  0x4EAE,
	4258:  0x50DA,
	4259:  0x4E21,
	4260:  0x51CC,
	4261:  0x5BEE,
	4262:  0x6599,
	4263:  0x6881,
	4264:  0x6DBC,
	4265:  0x731F,
	4266:  0x7642,
	4267:  0x77AD,
	4268:  0x7A1C,
	4269:  0x7CE7,
	4270:  0x826F,
	4271:  0x8AD2,
	4272:  0x907C,
	4273:  0x91CF,
	4274:  0x9675,
	4275:  0x9818,
	4276:  0x529B,
	4277:  0x7DD1,
	4278:  0x502B,
	4279:  0x5398,
	4280:  0x6797,
	4281:  0x6DCB,
	4282:  0x71D0,
	4283:  0x7433,
	4284:  0x81E8,
	4285:  0x8F2A,
	4286:  0x96A3,
	4287:  0x9C57,
	4288:  0x9E9F,
	4289:  0x7460,
	4290:  0x5841,
	4291:  0x6D99,
	4292:  0x7D2F,
	4293:  0x985E,
	4294:  0x4EE4,
	4295:  0x4F36,
	4296:  0x4F8B,
	4297:  0x51B7,
	4298:  0x52B1,
	4299:  0x5DBA,
	4300:  0x601C,
	4301:  0x73B2,
	4302:  0x793C,
	4303:  0x82D3,
	4304:  0x9234,
	4305:  0x96B7,
	4306:  0x96F6,
	4307:  0x970A,
	4308:  0x9E97,
	4309:  0x9F62,
	4310:  0x66A6,
	4311:  0x6B74,
	4312:  0x5217,
	4313:  0x52A3,
	4314:  0x70C8,
	4315:  0x88C2,
	4316:  0x5EC9,
	4317:  0x604B,
	4318:  0x6190,
	4319:  0x6F23,
	4320:  0x7149,
	4321:  0x7C3E,
	4322:  0x7DF4,
	4323:  0x806F,
	4324:  0x84EE,
	4325:  0x9023,
	4326:  0x932C,
	4327:  0x5442,
	4328:  0x9B6F,
	4329:  0x6AD3,
	4330:  0x7089,
	4331:  0x8CC2,
	4332:  0x8DEF,
	4333:  0x9732,
	4334:  0x52B4,
	4335:  0x5A41,
	4336:  0x5ECA,
	4337:  0x5F04,
	4338:  0x6717,
	4339:  0x697C,
	4340:  0x6994,
	4341:  0x6D6A,
	4342:  0x6F0F,
	4343:  0x7262,
	4344:  0x72FC,
	4345:  0x7BED,
	4346:  0x8001,
	4347:  0x807E,
	4348:  0x874B,
	4349:  0x90CE,
	4350:  0x516D,
	4351:  0x9E93,
	4352:  0x7984,
	4353:  0x808B,
	4354:  0x9332,
	4355:  0x8AD6,
	4356:  0x502D,
	4357:  0x548C,
	4358:  0x8A71,
	4359:  0x6B6A,
	4360:  0x8CC4,
	4361:  0x8107,
	4362:  0x60D1,
	4363:  0x67A0,
	4364:  0x9DF2,
	4365:  0x4E99,
	4366:  0x4E98,
	4367:  0x9C10,
	4368:  0x8A6B,
	4369:  0x85C1,
	4370:  0x8568,
	4371:  0x6900,
	4372:  0x6E7E,
	4373:  0x7897,
	4374:  0x8155,
	4418:  0x5F0C,
	4419:  0x4E10,
	4420:  0x4E15,
	4421:  0x4E2A,
	4422:  0x4E31,
	4423:  0x4E36,
	4424:  0x4E3C,
	4425:  0x4E3F,
	4426:  0x4E42,
	4427:  0x4E56,
	4428:  0x4E58,
	4429:  0x4E82,
	4430:  0x4E85,
	4431:  0x8C6B,
	4432:  0x4E8A,
	4433:  0x8212,
	4434:  0x5F0D,
	4435:  0x4E8E,
	4436:  0x4E9E,
	4437:  0x4E9F,
	4438:  0x4EA0,
	4439:  0x4EA2,
	4440:  0x4EB0,
	4441:  0x4EB3,
	4442:  0x4EB6,
	4443:  0x4ECE,
	4444:  0x4ECD,
	4445:  0x4EC4,
	4446:  0x4EC6,
	4447:  0x4EC2,
	4448:  0x4ED7,
	4449:  0x4EDE,
	4450:  0x4EED,
	4451:  0x4EDF,
	4452:  0x4EF7,
	4453:  0x4F09,
	4454:  0x4F5A,
	4455:  0x4F30,
	4456:  0x4F5B,
	4457:  0x4F5D,
	4458:  0x4F57,
	4459:  0x4F47,
	4460:  0x4F76,
	4461:  0x4F88,
	4462:  0x4F8F,
	4463:  0x4F98,
	4464:  0x4F7B,
	4465:  0x4F69,
	4466:  0x4F70,
	4467:  0x4F91,
	4468:  0x4F6F,
	4469:  0x4F86,
	4470:  0x4F96,
	4471:  0x5118,
	4472:  0x4FD4,
	4473:  0x4FDF,
	4474:  0x4FCE,
	4475:  0x4FD8,
	4476:  0x4FDB,
	4477:  0x4FD1,
	4478:  0x4FDA,
	4479:  0x4FD0,
	4480:  0x4FE4,
	4481:  0x4FE5,
	4482:  0x501A,
	4483:  0x5028,
	4484:  0x5014,
	4485:  0x502A,
	4486:  0x5025,
	4487:  0x5005,
	4488:  0x4F1C,
	4489:  0x4FF6,
	4490:  0x5021,
	4491:  0x5029,
	4492:  0x502C,
	4493:  0x4FFE,
	4494:  0x4FEF,
	4495:  0x5011,
	4496:  0x5006,
	4497:  0x5043,
	4498:  0x5047,
	4499:  0x6703,
	4500:  0x5055,
	4501:  0x5050,
	4502:  0x5048,
	4503:  0x505A,
	4504:  0x5056,
	4505:  0x506C,
	4506:  0x5078,
	4507:  0x5080,
	4508:  0x509A,
	4509:  0x5085,
	4510:  0x50B4,
	4511:  0x50B2,
	4512:  0x50C9,
	4513:  0x50CA,
	4514:  0x50B3,
	4515:  0x50C2,
	4516:  0x50D6,
	4517:  0x50DE,
	4518:  0x50E5,
	4519:  0x50ED,
	4520:  0x50E3,
	4521:  0x50EE,
	4522:  0x50F9,
	4523:  0x50F5,
	4524:  0x5109,
	4525:  0x5101,
	4526:  0x5102,
	4527:  0x5116,
	4528:  0x5115,
	4529:  0x5114,
	4530:  0x511A,
	4531:  0x5121,
	4532:  0x513A,
	4533:  0x5137,
	4534:  0x513C,
	4535:  0x513B,
	4536:  0x513F,
	4537:  0x5140,
	4538:  0x5152,
	4539:  0x514C,
	4540:  0x5154,
	4541:  0x5162,
	4542:  0x7AF8,
	4543:  0x5169,
	4544:  0x516A,
	4545:  0x516E,
	4546:  0x5180,
	4547:  0x5182,
	4548:  0x56D8,
	4549:  0x518C,
	4550:  0x5189,
	4551:  0x518F,
	4552:  0x5191,
	4553:  0x5193,
	4554:  0x5195,
	4555:  0x5196,
	4556:  0x51A4,
	4557:  0x51A6,
	4558:  0x51A2,
	4559:  0x51A9,
	4560:  0x51AA,
	4561:  0x51AB,
	4562:  0x51B3,
	4563:  0x51B1,
	4564:  0x51B2,
	4565:  0x51B0,
	4566:  0x51B5,
	4567:  0x51BD,
	4568:  0x51C5,
	4569:  0x51C9,
	4570:  0x51DB,
	4571:  0x51E0,
	4572:  0x8655,
	4573:  0x51E9,
	4574:  0x51ED,
	4575:  0x51F0,
	4576:  0x51F5,
	4577:  0x51FE,
	4578:  0x5204,
	4579:  0x520B,
	4580:  0x5214,
	4581:  0x520E,
	4582:  0x5227,
	4583:  0x522A,
	4584:  0x522E,
	4585:  0x5233,
	4586:  0x5239,
	4587:  0x524F,
	4588:  0x5244,
	4589:  0x524B,
	4590:  0x524C,
	4591:  0x525E,
	4592:  0x5254,
	4593:  0x526A,
	4594:  0x5274,
	4595:  0x5269,
	4596:  0x5273,
	4597:  0x527F,
	4598:  0x527D,
	4599:  0x528D,
	4600:  0x5294,
	4601:  0x5292,
	4602:  0x5271,
	4603:  0x5288,
	4604:  0x5291,
	4605:  0x8FA8,
	4606:  0x8FA7,
	4607:  0x52AC,
	4608:  0x52AD,
	4609:  0x52BC,
	4610:  0x52B5,
	4611:  0x52C1,
	4612:  0x52CD,
	4613:  0x52D7,
	4614:  0x52DE,
	4615:  0x52E3,
	4616:  0x52E6,
	4617:  0x98ED,
	4618:  0x52E0,
	4619:  0x52F3,
	4620:  0x52F5,
	4621:  0x52F8,
	4622:  0x52F9,
	4623:  0x5306,
	4624:  0x5308,
	4625:  0x7538,
	4626:  0x530D,
	4627:  0x5310,
	4628:  0x530F,
	4629:  0x5315,
	4630:  0x531A,
	4631:  0x5323,
	4632:  0x532F,
	4633:  0x5331,
	4634:  0x5333,
	4635:  0x5338,
	4636:  0x5340,
	4637:  0x5346,
	4638:  0x5345,
	4639:  0x4E17,
	4640:  0x5349,
	4641:  0x534D,
	4642:  0x51D6,
	4643:  0x535E,
	4644:  0x5369,
	4645:  0x536E,
	4646:  0x5918,
	4647:  0x537B,
	4648:  0x5377,
	4649:  0x5382,
	4650:  0x5396,
	4651:  0x53A0,
	4652:  0x53A6,
	4653:  0x53A5,
	4654:  0x53AE,
	4655:  0x53B0,
	4656:  0x53B6,
	4657:  0x53C3,
	4658:  0x7C12,
	4659:  0x96D9,
	4660:  0x53DF,
	4661:  0x66FC,
	4662:  0x71EE,
	4663:  0x53EE,
	4664:  0x53E8,
	4665:  0x53ED,
	4666:  0x53FA,
	4667:  0x5401,
	4668:  0x543D,
	4669:  0x5440,
	4670:  0x542C,
	4671:  0x542D,
	4672:  0x543C,
	4673:  0x542E,
	4674:  0x5436,
	4675:  0x5429,
	4676:  0x541D,
	4677:  0x544E,
	4678:  0x548F,
	4679:  0x5475,
	4680:  0x548E,
	4681:  0x545F,
	4682:  0x5471,
	4683:  0x5477,
	4684:  0x5470,
	4685:  0x5492,
	4686:  0x547B,
	4687:  0x5480,
	4688:  0x5476,
	4689:  0x5484,
	4690:  0x5490,
	4691:  0x5486,
	4692:  0x54C7,
	4693:  0x54A2,
	4694:  0x54B8,
	4695:  0x54A5,
	4696:  0x54AC,
	4697:  0x54C4,
	4698:  0x54C8,
	4699:  0x54A8,
	4700:  0x54AB,
	4701:  0x54C2,
	4702:  0x54A4,
	4703:  0x54BE,
	4704:  0x54BC,
	4705:  0x54D8,
	4706:  0x54E5,
	4707:  0x54E6,
	4708:  0x550F,
	4709:  0x5514,
	4710:  0x54FD,
	4711:  0x54EE,
	4712:  0x54ED,
	4713:  0x54FA,
	4714:  0x54E2,
	4715:  0x5539,
	4716:  0x5540,
	4717:  0x5563,
	4718:  0x554C,
	4719:  0x552E,
	4720:  0x555C,
	4721:  0x5545,
	4722:  0x5556,
	4723:  0x5557,
	4724:  0x5538,
	4725:  0x5533,
	4726:  0x555D,
	4727:  0x5599,
	4728:  0x5580,
	4729:  0x54AF,
	4730:  0x558A,
	4731:  0x559F,
	4732:  0x557B,
	4733:  0x557E,
	4734:  0x5598,
	4735:  0x559E,
	4736:  0x55AE,
	4737:  0x557C,
	4738:  0x5583,
	4739:  0x55A9,
	4740:  0x5587,
	4741:  0x55A8,
	4742:  0x55DA,
	4743:  0x55C5,
	4744:  0x55DF,
	4745:  0x55C4,
	4746:  0x55DC,
	4747:  0x55E4,
	4748:  0x55D4,
	4749:  0x5614,
	4750:  0x55F7,
	4751:  0x5616,
	4752:  0x55FE,
	4753:  0x55FD,
	4754:  0x561B,
	4755:  0x55F9,
	4756:  0x564E,
	4757:  0x5650,
	4758:  0x71DF,
	4759:  0x5634,
	4760:  0x5636,
	4761:  0x5632,
	4762:  0x5638,
	4763:  0x566B,
	4764:  0x5664,
	4765:  0x562F,
	4766:  0x566C,
	4767:  0x566A,
	4768:  0x5686,
	4769:  0x5680,
	4770:  0x568A,
	4771:  0x56A0,
	4772:  0x5694,
	4773:  0x568F,
	4774:  0x56A5,
	4775:  0x56AE,
	4776:  0x56B6,
	4777:  0x56B4,
	4778:  0x56C2,
	4779:  0x56BC,
	4780:  0x56C1,
	4781:  0x56C3,
	4782:  0x56C0,
	4783:  0x56C8,
	4784:  0x56CE,
	4785:  0x56D1,
	4786:  0x56D3,
	4787:  0x56D7,
	4788:  0x56EE,
	4789:  0x56F9,
	4790:  0x5700,
	4791:  0x56FF,
	4792:  0x5704,
	4793:  0x5709,
	4794:  0x5708,
	4795:  0x570B,
	4796:  0x570D,
	4797:  0x5713,
	4798:  0x5718,
	4799:  0x5716,
	4800:  0x55C7,
	4801:  0x571C,
	4802:  0x5726,
	4803:  0x5737,
	4804:  0x5738,
	4805:  0x574E,
	4806:  0x573B,
	4807:  0x5740,
	4808:  0x574F,
	4809:  0x5769,
	4810:  0x57C0,
	4811:  0x5788,
	4812:  0x5761,
	4813:  0x577F,
	4814:  0x5789,
	4815:  0x5793,
	4816:  0x57A0,
	4817:  0x57B3,
	4818:  0x57A4,
	4819:  0x57AA,
	4820:  0x57B0,
	4821:  0x57C3,
	4822:  0x57C6,
	4823:  0x57D4,
	4824:  0x57D2,
	4825:  0x57D3,
	4826:  0x580A,
	4827:  0x57D6,
	4828:  0x57E3,
	4829:  0x580B,
	4830:  0x5819,
	4831:  0x581D,
	4832:  0x5872,
	4833:  0x5821,
	4834:  0x5862,
	4835:  0x584B,
	4836:  0x5870,
	4837:  0x6BC0,
	4838:  0x5852,
	4839:  0x583D,
	4840:  0x5879,
	4841:  0x5885,
	4842:  0x58B9,
	4843:  0x589F,
	4844:  0x58AB,
	4845:  0x58BA,
	4846:  0x58DE,
	4847:  0x58BB,
	4848:  0x58B8,
	4849:  0x58AE,
	4850:  0x58C5,
	4851:  0x58D3,
	4852:  0x58D1,
	4853:  0x58D7,
	4854:  0x58D9,
	4855:  0x58D8,
	4856:  0x58E5,
	4857:  0x58DC,
	4858:  0x58E4,
	4859:  0x58DF,
	4860:  0x58EF,
	4861:  0x58FA,
	4862:  0x58F9,
	4863:  0x58FB,
	4864:  0x58FC,
	4865:  0x58FD,
	4866:  0x5902,
	4867:  0x590A,
	4868:  0x5910,
	4869:  0x591B,
	4870:  0x68A6,
	4871:  0x5925,
	4872:  0x592C,
	4873:  0x592D,
	4874:  0x5932,
	4875:  0x5938,
	4876:  0x593E,
	4877:  0x7AD2,
	4878:  0x5955,
	4879:  0x5950,
	4880:  0x594E,
	4881:  0x595A,
	4882:  0x5958,
	4883:  0x5962,
	4884:  0x5960,
	4885:  0x5967,
	4886:  0x596C,
	4887:  0x5969,
	4888:  0x5978,
	4889:  0x5981,
	4890:  0x599D,
	4891:  0x4F5E,
	4892:  0x4FAB,
	4893:  0x59A3,
	4894:  0x59B2,
	4895:  0x59C6,
	4896:  0x59E8,
	4897:  0x59DC,
	4898:  0x598D,
	4899:  0x59D9,
	4900:  0x59DA,
	4901:  0x5A25,
	4902:  0x5A1F,
	4903:  0x5A11,
	4904:  0x5A1C,
	4905:  0x5A09,
	4906:  0x5A1A,
	4907:  0x5A40,
	4908:  0x5A6C,
	4909:  0x5A49,
	4910:  0x5A35,
	4911:  0x5A36,
	4912:  0x5A62,
	4913:  0x5A6A,
	4914:  0x5A9A,
	4915:  0x5ABC,
	4916:  0x5ABE,
	4917:  0x5ACB,
	4918:  0x5AC2,
	4919:  0x5ABD,
	4920:  0x5AE3,
	4921:  0x5AD7,
	4922:  0x5AE6,
	4923:  0x5AE9,
	4924:  0x5AD6,
	4925:  0x5AFA,
	4926:  0x5AFB,
	4927:  0x5B0C,
	4928:  0x5B0B,
	4929:  0x5B16,
	4930:  0x5B32,
	4931:  0x5AD0,
	4932:  0x5B2A,
	4933:  0x5B36,
	4934:  0x5B3E,
	4935:  0x5B43,
	4936:  0x5B45,
	4937:  0x5B40,
	4938:  0x5B51,
	4939:  0x5B55,
	4940:  0x5B5A,
	4941:  0x5B5B,
	4942:  0x5B65,
	4943:  0x5B69,
	4944:  0x5B70,
	4945:  0x5B73,
	4946:  0x5B75,
	4947:  0x5B78,
	4948:  0x6588,
	4949:  0x5B7A,
	4950:  0x5B80,
	4951:  0x5B83,
	4952:  0x5BA6,
	4953:  0x5BB8,
	4954:  0x5BC3,
	4955:  0x5BC7,
	4956:  0x5BC9,
	4957:  0x5BD4,
	4958:  0x5BD0,
	4959:  0x5BE4,
	4960:  0x5BE6,
	4961:  0x5BE2,
	4962:  0x5BDE,
	4963:  0x5BE5,
	4964:  0x5BEB,
	4965:  0x5BF0,
	4966:  0x5BF6,
	4967:  0x5BF3,
	4968:  0x5C05,
	4969:  0x5C07,
	4970:  0x5C08,
	4971:  0x5C0D,
	4972:  0x5C13,
	4973:  0x5C20,
	4974:  0x5C22,
	4975:  0x5C28,
	4976:  0x5C38,
	4977:  0x5C39,
	4978:  0x5C41,
	4979:  0x5C46,
	4980:  0x5C4E,
	4981:  0x5C53,
	4982:  0x5C50,
	4983:  0x5C4F,
	4984:  0x5B71,
	4985:  0x5C6C,
	4986:  0x5C6E,
	4987:  0x4E62,
	4988:  0x5C76,
	4989:  0x5C79,
	4990:  0x5C8C,
	4991:  0x5C91,
	4992:  0x5C94,
	4993:  0x599B,
	4994:  0x5CAB,
	4995:  0x5CBB,
	4996:  0x5CB6,
	4997:  0x5CBC,
	4998:  0x5CB7,
	4999:  0x5CC5,
	5000:  0x5CBE,
	5001:  0x5CC7,
	5002:  0x5CD9,
	5003:  0x5CE9,
	5004:  0x5CFD,
	5005:  0x5CFA,
	5006:  0x5CED,
	5007:  0x5D8C,
	5008:  0x5CEA,
	5009:  0x5D0B,
	5010:  0x5D15,
	5011:  0x5D17,
	5012:  0x5D5C,
	5013:  0x5D1F,
	5014:  0x5D1B,
	5015:  0x5D11,
	5016:  0x5D14,
	5017:  0x5D22,
	5018:  0x5D1A,
	5019:  0x5D19,
	5020:  0x5D18,
	5021:  0x5D4C,
	5022:  0x5D52,
	5023:  0x5D4E,
	5024:  0x5D4B,
	5025:  0x5D6C,
	5026:  0x5D73,
	5027:  0x5D76,
	5028:  0x5D87,
	5029:  0x5D84,
	5030:  0x5D82,
	5031:  0x5DA2,
	5032:  0x5D9D,
	5033:  0x5DAC,
	5034:  0x5DAE,
	5035:  0x5DBD,
	5036:  0x5D90,
	5037:  0x5DB7,
	5038:  0x5DBC,
	5039:  0x5DC9,
	5040:  0x5DCD,
	5041:  0x5DD3,
	5042:  0x5DD2,
	5043:  0x5DD6,
	5044:  0x5DDB,
	5045:  0x5DEB,
	5046:  0x5DF2,
	5047:  0x5DF5,
	5048:  0x5E0B,
	5049:  0x5E1A,
	5050:  0x5E19,
	5051:  0x5E11,
	5052:  0x5E1B,
	5053:  0x5E36,
	5054:  0x5E37,
	5055:  0x5E44,
	5056:  0x5E43,
	5057:  0x5E40,
	5058:  0x5E4E,
	5059:  0x5E57,
	5060:  0x5E54,
	5061:  0x5E5F,
	5062:  0x5E62,
	5063:  0x5E64,
	5064:  0x5E47,
	5065:  0x5E75,
	5066:  0x5E76,
	5067:  0x5E7A,
	5068:  0x9EBC,
	5069:  0x5E7F,
	5070:  0x5EA0,
	5071:  0x5EC1,
	5072:  0x5EC2,
	5073:  0x5EC8,
	5074:  0x5ED0,
	5075:  0x5ECF,
	5076:  0x5ED6,
	5077:  0x5EE3,
	5078:  0x5EDD,
	5079:  0x5EDA,
	5080:  0x5EDB,
	5081:  0x5EE2,
	5082:  0x5EE1,
	5083:  0x5EE8,
	5084:  0x5EE9,
	5085:  0x5EEC,
	5086:  0x5EF1,
	5087:  0x5EF3,
	5088:  0x5EF0,
	5089:  0x5EF4,
	5090:  0x5EF8,
	5091:  0x5EFE,
	5092:  0x5F03,
	5093:  0x5F09,
	5094:  0x5F5D,
	5095:  0x5F5C,
	5096:  0x5F0B,
	5097:  0x5F11,
	5098:  0x5F16,
	5099:  0x5F29,
	5100:  0x5F2D,
	5101:  0x5F38,
	5102:  0x5F41,
	5103:  0x5F48,
	5104:  0x5F4C,
	5105:  0x5F4E,
	5106:  0x5F2F,
	5107:  0x5F51,
	5108:  0x5F56,
	5109:  0x5F57,
	5110:  0x5F59,
	5111:  0x5F61,
	5112:  0x5F6D,
	5113:  0x5F73,
	5114:  0x5F77,
	5115:  0x5F83,
	5116:  0x5F82,
	5117:  0x5F7F,
	5118:  0x5F8A,
	5119:  0x5F88,
	5120:  0x5F91,
	5121:  0x5F87,
	5122:  0x5F9E,
	5123:  0x5F99,
	5124:  0x5F98,
	5125:  0x5FA0,
	5126:  0x5FA8,
	5127:  0x5FAD,
	5128:  0x5FBC,
	5129:  0x5FD6,
	5130:  0x5FFB,
	5131:  0x5FE4,
	5132:  0x5FF8,
	5133:  0x5FF1,
	5134:  0x5FDD,
	5135:  0x60B3,
	5136:  0x5FFF,
	5137:  0x6021,
	5138:  0x6060,
	5139:  0x6019,
	5140:  0x6010,
	5141:  0x6029,
	5142:  0x600E,
	5143:  0x6031,
	5144:  0x601B,
	5145:  0x6015,
	5146:  0x602B,
	5147:  0x6026,
	5148:  0x600F,
	5149:  0x603A,
	5150:  0x605A,
	5151:  0x6041,
	5152:  0x606A,
	5153:  0x6077,
	5154:  0x605F,
	5155:  0x604A,
	5156:  0x6046,
	5157:  0x604D,
	5158:  0x6063,
	5159:  0x6043,
	5160:  0x6064,
	5161:  0x6042,
	5162:  0x606C,
	5163:  0x606B,
	5164:  0x6059,
	5165:  0x6081,
	5166:  0x608D,
	5167:  0x60E7,
	5168:  0x6083,
	5169:  0x609A,
	5170:  0x6084,
	5171:  0x609B,
	5172:  0x6096,
	5173:  0x6097,
	5174:  0x6092,
	5175:  0x60A7,
	5176:  0x608B,
	5177:  0x60E1,
	5178:  0x60B8,
	5179:  0x60E0,
	5180:  0x60D3,
	5181:  0x60B4,
	5182:  0x5FF0,
	5183:  0x60BD,
	5184:  0x60C6,
	5185:  0x60B5,
	5186:  0x60D8,
	5187:  0x614D,
	5188:  0x6115,
	5189:  0x6106,
	5190:  0x60F6,
	5191:  0x60F7,
	5192:  0x6100,
	5193:  0x60F4,
	5194:  0x60FA,
	5195:  0x6103,
	5196:  0x6121,
	5197:  0x60FB,
	5198:  0x60F1,
	5199:  0x610D,
	5200:  0x610E,
	5201:  0x6147,
	5202:  0x613E,
	5203:  0x6128,
	5204:  0x6127,
	5205:  0x614A,
	5206:  0x613F,
	5207:  0x613C,
	5208:  0x612C,
	5209:  0x6134,
	5210:  0x613D,
	5211:  0x6142,
	5212:  0x6144,
	5213:  0x6173,
	5214:  0x6177,
	5215:  0x6158,
	5216:  0x6159,
	5217:  0x615A,
	5218:  0x616B,
	5219:  0x6174,
	5220:  0x616F,
	5221:  0x6165,
	5222:  0x6171,
	5223:  0x615F,
	5224:  0x615D,
	5225:  0x6153,
	5226:  0x6175,
	5227:  0x6199,
	5228:  0x6196,
	5229:  0x6187,
	5230:  0x61AC,
	5231:  0x6194,
	5232:  0x619A,
	5233:  0x618A,
	5234:  0x6191,
	5235:  0x61AB,
	5236:  0x61AE,
	5237:  0x61CC,
	5238:  0x61CA,
	5239:  0x61C9,
	5240:  0x61F7,
	5241:  0x61C8,
	5242:  0x61C3,
	5243:  0x61C6,
	5244:  0x61BA,
	5245:  0x61CB,
	5246:  0x7F79,
	5247:  0x61CD,
	5248:  0x61E6,
	5249:  0x61E3,
	5250:  0x61F6,
	5251:  0x61FA,
	5252:  0x61F4,
	5253:  0x61FF,
	5254:  0x61FD,
	5255:  0x61FC,
	5256:  0x61FE,
	5257:  0x6200,
	5258:  0x6208,
	5259:  0x6209,
	5260:  0x620D,
	5261:  0x620C,
	5262:  0x6214,
	5263:  0x621B,
	5264:  0x621E,
	5265:  0x6221,
	5266:  0x622A,
	5267:  0x622E,
	5268:  0x6230,
	5269:  0x6232,
	5270:  0x6233,
	5271:  0x6241,
	5272:  0x624E,
	5273:  0x625E,
	5274:  0x6263,
	5275:  0x625B,
	5276:  0x6260,
	5277:  0x6268,
	5278:  0x627C,
	5279:  0x6282,
	5280:  0x6289,
	5281:  0x627E,
	5282:  0x6292,
	5283:  0x6293,
	5284:  0x6296,
	5285:  0x62D4,
	5286:  0x6283,
	5287:  0x6294,
	5288:  0x62D7,
	5289:  0x62D1,
	5290:  0x62BB,
	5291:  0x62CF,
	5292:  0x62FF,
	5293:  0x62C6,
	5294:  0x64D4,
	5295:  0x62C8,
	5296:  0x62DC,
	5297:  0x62CC,
	5298:  0x62CA,
	5299:  0x62C2,
	5300:  0x62C7,
	5301:  0x629B,
	5302:  0x62C9,
	5303:  0x630C,
	5304:  0x62EE,
	5305:  0x62F1,
	5306:  0x6327,
	5307:  0x6302,
	5308:  0x6308,
	5309:  0x62EF,
	5310:  0x62F5,
	5311:  0x6350,
	5312:  0x633E,
	5313:  0x634D,
	5314:  0x641C,
	5315:  0x634F,
	5316:  0x6396,
	5317:  0x638E,
	5318:  0x6380,
	5319:  0x63AB,
	5320:  0x6376,
	5321:  0x63A3,
	5322:  0x638F,
	5323:  0x6389,
	5324:  0x639F,
	5325:  0x63B5,
	5326:  0x636B,
	5327:  0x6369,
	5328:  0x63BE,
	5329:  0x63E9,
	5330:  0x63C0,
	5331:  0x63C6,
	5332:  0x63E3,
	5333:  0x63C9,
	5334:  0x63D2,
	5335:  0x63F6,
	5336:  0x63C4,
	5337:  0x6416,
	5338:  0x6434,
	5339:  0x6406,
	5340:  0x6413,
	5341:  0x6426,
	5342:  0x6436,
	5343:  0x651D,
	5344:  0x6417,
	5345:  0x6428,
	5346:  0x640F,
	5347:  0x6467,
	5348:  0x646F,
	5349:  0x6476,
	5350:  0x644E,
	5351:  0x652A,
	5352:  0x6495,
	5353:  0x6493,
	5354:  0x64A5,
	5355:  0x64A9,
	5356:  0x6488,
	5357:  0x64BC,
	5358:  0x64DA,
	5359:  0x64D2,
	5360:  0x64C5,
	5361:  0x64C7,
	5362:  0x64BB,
	5363:  0x64D8,
	5364:  0x64C2,
	5365:  0x64F1,
	5366:  0x64E7,
	5367:  0x8209,
	5368:  0x64E0,
	5369:  0x64E1,
	5370:  0x62AC,
	5371:  0x64E3,
	5372:  0x64EF,
	5373:  0x652C,
	5374:  0x64F6,
	5375:  0x64F4,
	5376:  0x64F2,
	5377:  0x64FA,
	5378:  0x6500,
	5379:  0x64FD,
	5380:  0x6518,
	5381:  0x651C,
	5382:  0x6505,
	5383:  0x6524,
	5384:  0x6523,
	5385:  0x652B,
	5386:  0x6534,
	5387:  0x6535,
	5388:  0x6537,
	5389:  0x6536,
	5390:  0x6538,
	5391:  0x754B,
	5392:  0x6548,
	5393:  0x6556,
	5394:  0x6555,
	5395:  0x654D,
	5396:  0x6558,
	5397:  0x655E,
	5398:  0x655D,
	5399:  0x6572,
	5400:  0x6578,
	5401:  0x6582,
	5402:  0x6583,
	5403:  0x8B8A,
	5404:  0x659B,
	5405:  0x659F,
	5406:  0x65AB,
	5407:  0x65B7,
	5408:  0x65C3,
	5409:  0x65C6,
	5410:  0x65C1,
	5411:  0x65C4,
	5412:  0x65CC,
	5413:  0x65D2,
	5414:  0x65DB,
	5415:  0x65D9,
	5416:  0x65E0,
	5417:  0x65E1,
	5418:  0x65F1,
	5419:  0x6772,
	5420:  0x660A,
	5421:  0x6603,
	5422:  0x65FB,
	5423:  0x6773,
	5424:  0x6635,
	5425:  0x6636,
	5426:  0x6634,
	5427:  0x661C,
	5428:  0x664F,
	5429:  0x6644,
	5430:  0x6649,
	5431:  0x6641,
	5432:  0x665E,
	5433:  0x665D,
	5434:  0x6664,
	5435:  0x6667,
	5436:  0x6668,
	5437:  0x665F,
	5438:  0x6662,
	5439:  0x6670,
	5440:  0x6683,
	5441:  0x6688,
	5442:  0x668E,
	5443:  0x6689,
	5444:  0x6684,
	5445:  0x6698,
	5446:  0x669D,
	5447:  0x66C1,
	5448:  0x66B9,
	5449:  0x66C9,
	5450:  0x66BE,
	5451:  0x66BC,
	5452:  0x66C4,
	5453:  0x66B8,
	5454:  0x66D6,
	5455:  0x66DA,
	5456:  0x66E0,
	5457:  0x663F,
	5458:  0x66E6,
	5459:  0x66E9,
	5460:  0x66F0,
	5461:  0x66F5,
	5462:  0x66F7,
	5463:  0x670F,
	5464:  0x6716,
	5465:  0x671E,
	5466:  0x6726,
	5467:  0x6727,
	5468:  0x9738,
	5469:  0x672E,
	5470:  0x673F,
	5471:  0x6736,
	5472:  0x6741,
	5473:  0x6738,
	5474:  0x6737,
	5475:  0x6746,
	5476:  0x675E,
	5477:  0x6760,
	5478:  0x6759,
	5479:  0x6763,
	5480:  0x6764,
	5481:  0x6789,
	5482:  0x6770,
	5483:  0x67A9,
	5484:  0x677C,
	5485:  0x676A,
	5486:  0x678C,
	5487:  0x678B,
	5488:  0x67A6,
	5489:  0x67A1,
	5490:  0x6785,
	5491:  0x67B7,
	5492:  0x67EF,
	5493:  0x67B4,
	5494:  0x67EC,
	5495:  0x67B3,
	5496:  0x67E9,
	5497:  0x67B8,
	5498:  0x67E4,
	5499:  0x67DE,
	5500:  0x67DD,
	5501:  0x67E2,
	5502:  0x67EE,
	5503:  0x67B9,
	5504:  0x67CE,
	5505:  0x67C6,
	5506:  0x67E7,
	5507:  0x6A9C,
	5508:  0x681E,
	5509:  0x6846,
	5510:  0x6829,
	5511:  0x6840,
	5512:  0x684D,
	5513:  0x6832,
	5514:  0x684E,
	5515:  0x68B3,
	5516:  0x682B,
	5517:  0x6859,
	5518:  0x6863,
	5519:  0x6877,
	5520:  0x687F,
	5521:  0x689F,
	5522:  0x688F,
	5523:  0x68AD,
	5524:  0x6894,
	5525:  0x689D,
	5526:  0x689B,
	5527:  0x6883,
	5528:  0x6AAE,
	5529:  0x68B9,
	5530:  0x6874,
	5531:  0x68B5,
	5532:  0x68A0,
	5533:  0x68BA,
	5534:  0x690F,
	5535:  0x688D,
	5536:  0x687E,
	5537:  0x6901,
	5538:  0x68CA,
	5539:  0x6908,
	5540:  0x68D8,
	5541:  0x6922,
	5542:  0x6926,
	5543:  0x68E1,
	5544:  0x690C,
	5545:  0x68CD,
	5546:  0x68D4,
	5547:  0x68E7,
	5548:  0x68D5,
	5549:  0x6936,
	5550:  0x6912,
	5551:  0x6904,
	5552:  0x68D7,
	5553:  0x68E3,
	5554:  0x6925,
	5555:  0x68F9,
	5556:  0x68E0,
	5557:  0x68EF,
	5558:  0x6928,
	5559:  0x692A,
	5560:  0x691A,
	5561:  0x6923,
	5562:  0x6921,
	5563:  0x68C6,
	5564:  0x6979,
	5565:  0x6977,
	5566:  0x695C,
	5567:  0x6978,
	5568:  0x696B,
	5569:  0x6954,
	5570:  0x697E,
	5571:  0x696E,
	5572:  0x6939,
	5573:  0x6974,
	5574:  0x693D,
	5575:  0x6959,
	5576:  0x6930,
	5577:  0x6961,
	5578:  0x695E,
	5579:  0x695D,
	5580:  0x6981,
	5581:  0x696A,
	5582:  0x69B2,
	5583:  0x69AE,
	5584:  0x69D0,
	5585:  0x69BF,
	5586:  0x69C1,
	5587:  0x69D3,
	5588:  0x69BE,
	5589:  0x69CE,
	5590:  0x5BE8,
	5591:  0x69CA,
	5592:  0x69DD,
	5593:  0x69BB,
	5594:  0x69C3,
	5595:  0x69A7,
	5596:  0x6A2E,
	5597:  0x6991,
	5598:  0x69A0,
	5599:  0x699C,
	5600:  0x6995,
	5601:  0x69B4,
	5602:  0x69DE,
	5603:  0x69E8,
	5604:  0x6A02,
	5605:  0x6A1B,
	5606:  0x69FF,
	5607:  0x6B0A,
	5608:  0x69F9,
	5609:  0x69F2,
	5610:  0x69E7,
	5611:  0x6A05,
	5612:  0x69B1,
	5613:  0x6A1E,
	5614:  0x69ED,
	5615:  0x6A14,
	5616:  0x69EB,
	5617:  0x6A0A,
	5618:  0x6A12,
	5619:  0x6AC1,
	5620:  0x6A23,
	5621:  0x6A13,
	5622:  0x6A44,
	5623:  0x6A0C,
	5624:  0x6A72,
	5625:  0x6A36,
	5626:  0x6A78,
	5627:  0x6A47,
	5628:  0x6A62,
	5629:  0x6A59,
	5630:  0x6A66,
	5631:  0x6A48,
	5632:  0x6A38,
	5633:  0x6A22,
	5634:  0x6A90,
	5635:  0x6A8D,
	5636:  0x6AA0,
	5637:  0x6A84,
	5638:  0x6AA2,
	5639:  0x6AA3,
	5640:  0x6A97,
	5641:  0x8617,
	5642:  0x6ABB,
	5643:  0x6AC3,
	5644:  0x6AC2,
	5645:  0x6AB8,
	5646:  0x6AB3,
	5647:  0x6AAC,
	5648:  0x6ADE,
	5649:  0x6AD1,
	5650:  0x6ADF,
	5651:  0x6AAA,
	5652:  0x6ADA,
	5653:  0x6AEA,
	5654:  0x6AFB,
	5655:  0x6B05,
	5656:  0x8616,
	5657:  0x6AFA,
	5658:  0x6B12,
	5659:  0x6B16,
	5660:  0x9B31,
	5661:  0x6B1F,
	5662:  0x6B38,
	5663:  0x6B37,
	5664:  0x76DC,
	5665:  0x6B39,
	5666:  0x98EE,
	5667:  0x6B47,
	5668:  0x6B43,
	5669:  0x6B49,
	5670:  0x6B50,
	5671:  0x6B59,
	5672:  0x6B54,
	5673:  0x6B5B,
	5674:  0x6B5F,
	5675:  0x6B61,
	5676:  0x6B78,
	5677:  0x6B79,
	5678:  0x6B7F,
	5679:  0x6B80,
	5680:  0x6B84,
	5681:  0x6B83,
	5682:  0x6B8D,
	5683:  0x6B98,
	5684:  0x6B95,
	5685:  0x6B9E,
	5686:  0x6BA4,
	5687:  0x6BAA,
	5688:  0x6BAB,
	5689:  0x6BAF,
	5690:  0x6BB2,
	5691:  0x6BB1,
	5692:  0x6BB3,
	5693:  0x6BB7,
	5694:  0x6BBC,
	5695:  0x6BC6,
	5696:  0x6BCB,
	5697:  0x6BD3,
	5698:  0x6BDF,
	5699:  0x6BEC,
	5700:  0x6BEB,
	5701:  0x6BF3,
	5702:  0x6BEF,
	5703:  0x9EBE,
	5704:  0x6C08,
	5705:  0x6C13,
	5706:  0x6C14,
	5707:  0x6C1B,
	5708:  0x6C24,
	5709:  0x6C23,
	5710:  0x6C5E,
	5711:  0x6C55,
	5712:  0x6C62,
	5713:  0x6C6A,
	5714:  0x6C82,
	5715:  0x6C8D,
	5716:  0x6C9A,
	5717:  0x6C81,
	5718:  0x6C9B,
	5719:  0x6C7E,
	5720:  0x6C68,
	5721:  0x6C73,
	5722:  0x6C92,
	5723:  0x6C90,
	5724:  0x6CC4,
	5725:  0x6CF1,
	5726:  0x6CD3,
	5727:  0x6CBD,
	5728:  0x6CD7,
	5729:  0x6CC5,
	5730:  0x6CDD,
	5731:  0x6CAE,
	5732:  0x6CB1,
	5733:  0x6CBE,
	5734:  0x6CBA,
	5735:  0x6CDB,
	5736:  0x6CEF,
	5737:  0x6CD9,
	5738:  0x6CEA,
	5739:  0x6D1F,
	5740:  0x884D,
	5741:  0x6D36,
	5742:  0x6D2B,
	5743:  0x6D3D,
	5744:  0x6D38,
	5745:  0x6D19,
	5746:  0x6D35,
	5747:  0x6D33,
	5748:  0x6D12,
	5749:  0x6D0C,
	5750:  0x6D63,
	5751:  0x6D93,
	5752:  0x6D64,
	5753:  0x6D5A,
	5754:  0x6D79,
	5755:  0x6D59,
	5756:  0x6D8E,
	5757:  0x6D95,
	5758:  0x6FE4,
	5759:  0x6D85,
	5760:  0x6DF9,
	5761:  0x6E15,
	5762:  0x6E0A,
	5763:  0x6DB5,
	5764:  0x6DC7,
	5765:  0x6DE6,
	5766:  0x6DB8,
	5767:  0x6DC6,
	5768:  0x6DEC,
	5769:  0x6DDE,
	5770:  0x6DCC,
	5771:  0x6DE8,
	5772:  0x6DD2,
	5773:  0x6DC5,
	5774:  0x6DFA,
	5775:  0x6DD9,
	5776:  0x6DE4,
	5777:  0x6DD5,
	5778:  0x6DEA,
	5779:  0x6DEE,
	5780:  0x6E2D,
	5781:  0x6E6E,
	5782:  0x6E2E,
	5783:  0x6E19,
	5784:  0x6E72,
	5785:  0x6E5F,
	5786:  0x6E3E,
	5787:  0x6E23,
	5788:  0x6E6B,
	5789:  0x6E2B,
	5790:  0x6E76,
	5791:  0x6E4D,
	5792:  0x6E1F,
	5793:  0x6E43,
	5794:  0x6E3A,
	5795:  0x6E4E,
	5796:  0x6E24,
	5797:  0x6EFF,
	5798:  0x6E1D,
	5799:  0x6E38,
	5800:  0x6E82,
	5801:  0x6EAA,
	5802:  0x6E98,
	5803:  0x6EC9,
	5804:  0x6EB7,
	5805:  0x6ED3,
	5806:  0x6EBD,
	5807:  0x6EAF,
	5808:  0x6EC4,
	5809:  0x6EB2,
	5810:  0x6ED4,
	5811:  0x6ED5,
	5812:  0x6E8F,
	5813:  0x6EA5,
	5814:  0x6EC2,
	5815:  0x6E9F,
	5816:  0x6F41,
	5817:  0x6F11,
	5818:  0x704C,
	5819:  0x6EEC,
	5820:  0x6EF8,
	5821:  0x6EFE,
	5822:  0x6F3F,
	5823:  0x6EF2,
	5824:  0x6F31,
	5825:  0x6EEF,
	5826:  0x6F32,
	5827:  0x6ECC,
	5828:  0x6F3E,
	5829:  0x6F13,
	5830:  0x6EF7,
	5831:  0x6F86,
	5832:  0x6F7A,
	5833:  0x6F78,
	5834:  0x6F81,
	5835:  0x6F80,
	5836:  0x6F6F,
	5837:  0x6F5B,
	5838:  0x6FF3,
	5839:  0x6F6D,
	5840:  0x6F82,
	5841:  0x6F7C,
	5842:  0x6F58,
	5843:  0x6F8E,
	5844:  0x6F91,
	5845:  0x6FC2,
	5846:  0x6F66,
	5847:  0x6FB3,
	5848:  0x6FA3,
	5849:  0x6FA1,
	5850:  0x6FA4,
	5851:  0x6FB9,
	5852:  0x6FC6,
	5853:  0x6FAA,
	5854:  0x6FDF,
	5855:  0x6FD5,
	5856:  0x6FEC,
	5857:  0x6FD4,
	5858:  0x6FD8,
	5859:  0x6FF1,
	5860:  0x6FEE,
	5861:  0x6FDB,
	5862:  0x7009,
	5863:  0x700B,
	5864:  0x6FFA,
	5865:  0x7011,
	5866:  0x7001,
	5867:  0x700F,
	5868:  0x6FFE,
	5869:  0x701B,
	5870:  0x701A,
	5871:  0x6F74,
	5872:  0x701D,
	5873:  0x7018,
	5874:  0x701F,
	5875:  0x7030,
	5876:  0x703E,
	5877:  0x7032,
	5878:  0x7051,
	5879:  0x7063,
	5880:  0x7099,
	5881:  0x7092,
	5882:  0x70AF,
	5883:  0x70F1,
	5884:  0x70AC,
	5885:  0x70B8,
	5886:  0x70B3,
	5887:  0x70AE,
	5888:  0x70DF,
	5889:  0x70CB,
	5890:  0x70DD,
	5891:  0x70D9,
	5892:  0x7109,
	5893:  0x70FD,
	5894:  0x711C,
	5895:  0x7119,
	5896:  0x7165,
	5897:  0x7155,
	5898:  0x7188,
	5899:  0x7166,
	5900:  0x7162,
	5901:  0x714C,
	5902:  0x7156,
	5903:  0x716C,
	5904:  0x718F,
	5905:  0x71FB,
	5906:  0x7184,
	5907:  0x7195,
	5908:  0x71A8,
	5909:  0x71AC,
	5910:  0x71D7,
	5911:  0x71B9,
	5912:  0x71BE,
	5913:  0x71D2,
	5914:  0x71C9,
	5915:  0x71D4,
	5916:  0x71CE,
	5917:  0x71E0,
	5918:  0x71EC,
	5919:  0x71E7,
	5920:  0x71F5,
	5921:  0x71FC,
	5922:  0x71F9,
	5923:  0x71FF,
	5924:  0x720D,
	5925:  0x7210,
	5926:  0x721B,
	5927:  0x7228,
	5928:  0x722D,
	5929:  0x722C,
	5930:  0x7230,
	5931:  0x7232,
	5932:  0x723B,
	5933:  0x723C,
	5934:  0x723F,
	5935:  0x7240,
	5936:  0x7246,
	5937:  0x724B,
	5938:  0x7258,
	5939:  0x7274,
	5940:  0x727E,
	5941:  0x7282,
	5942:  0x7281,
	5943:  0x7287,
	5944:  0x7292,
	5945:  0x7296,
	5946:  0x72A2,
	5947:  0x72A7,
	5948:  0x72B9,
	5949:  0x72B2,
	5950:  0x72C3,
	5951:  0x72C6,
	5952:  0x72C4,
	5953:  0x72CE,
	5954:  0x72D2,
	5955:  0x72E2,
	5956:  0x72E0,
	5957:  0x72E1,
	5958:  0x72F9,
	5959:  0x72F7,
	5960:  0x500F,
	5961:  0x7317,
	5962:  0x730A,
	5963:  0x731C,
	5964:  0x7316,
	5965:  0x731D,
	5966:  0x7334,
	5967:  0x732F,
	5968:  0x7329,
	5969:  0x7325,
	5970:  0x733E,
	5971:  0x734E,
	5972:  0x734F,
	5973:  0x9ED8,
	5974:  0x7357,
	5975:  0x736A,
	5976:  0x7368,
	5977:  0x7370,
	5978:  0x7378,
	5979:  0x7375,
	5980:  0x737B,
	5981:  0x737A,
	5982:  0x73C8,
	5983:  0x73B3,
	5984:  0x73CE,
	5985:  0x73BB,
	5986:  0x73C0,
	5987:  0x73E5,
	5988:  0x73EE,
	5989:  0x73DE,
	5990:  0x74A2,
	5991:  0x7405,
	5992:  0x746F,
	5993:  0x7425,
	5994:  0x73F8,
	5995:  0x7432,
	5996:  0x743A,
	5997:  0x7455,
	5998:  0x743F,
	5999:  0x745F,
	6000:  0x7459,
	6001:  0x7441,
	6002:  0x745C,
	6003:  0x7469,
	6004:  0x7470,
	6005:  0x7463,
	6006:  0x746A,
	6007:  0x7476,
	6008:  0x747E,
	6009:  0x748B,
	6010:  0x749E,
	6011:  0x74A7,
	6012:  0x74CA,
	6013:  0x74CF,
	6014:  0x74D4,
	6015:  0x73F1,
	6016:  0x74E0,
	6017:  0x74E3,
	6018:  0x74E7,
	6019:  0x74E9,
	6020:  0x74EE,
	6021:  0x74F2,
	6022:  0x74F0,
	6023:  0x74F1,
	6024:  0x74F8,
	6025:  0x74F7,
	6026:  0x7504,
	6027:  0x7503,
	6028:  0x7505,
	6029:  0x750C,
	6030:  0x750E,
	6031:  0x750D,
	6032:  0x7515,
	6033:  0x7513,
	6034:  0x751E,
	6035:  0x7526,
	6036:  0x752C,
	6037:  0x753C,
	6038:  0x7544,
	6039:  0x754D,
	6040:  0x754A,
	6041:  0x7549,
	6042:  0x755B,
	6043:  0x7546,
	6044:  0x755A,
	6045:  0x7569,
	6046:  0x7564,
	6047:  0x7567,
	6048:  0x756B,
	6049:  0x756D,
	6050:  0x7578,
	6051:  0x7576,
	6052:  0x7586,
	6053:  0x7587,
	6054:  0x7574,
	6055:  0x758A,
	6056:  0x7589,
	6057:  0x7582,
	6058:  0x7594,
	6059:  0x759A,
	6060:  0x759D,
	6061:  0x75A5,
	6062:  0x75A3,
	6063:  0x75C2,
	6064:  0x75B3,
	6065:  0x75C3,
	6066:  0x75B5,
	6067:  0x75BD,
	6068:  0x75B8,
	6069:  0x75BC,
	6070:  0x75B1,
	6071:  0x75CD,
	6072:  0x75CA,
	6073:  0x75D2,
	6074:  0x75D9,
	6075:  0x75E3,
	6076:  0x75DE,
	6077:  0x75FE,
	6078:  0x75FF,
	6079:  0x75FC,
	6080:  0x7601,
	6081:  0x75F0,
	6082:  0x75FA,
	6083:  0x75F2,
	6084:  0x75F3,
	6085:  0x760B,
	6086:  0x760D,
	6087:  0x7609,
	6088:  0x761F,
	6089:  0x7627,
	6090:  0x7620,
	6091:  0x7621,
	6092:  0x7622,
	6093:  0x7624,
	6094:  0x7634,
	6095:  0x7630,
	6096:  0x763B,
	6097:  0x7647,
	6098:  0x7648,
	6099:  0x7646,
	6100:  0x765C,
	6101:  0x7658,
	6102:  0x7661,
	6103:  0x7662,
	6104:  0x7668,
	6105:  0x7669,
	6106:  0x766A,
	6107:  0x7667,
	6108:  0x766C,
	6109:  0x7670,
	6110:  0x7672,
	6111:  0x7676,
	6112:  0x7678,
	6113:  0x767C,
	6114:  0x7680,
	6115:  0x7683,
	6116:  0x7688,
	6117:  0x768B,
	6118:  0x768E,
	6119:  0x7696,
	6120:  0x7693,
	6121:  0x7699,
	6122:  0x769A,
	6123:  0x76B0,
	6124:  0x76B4,
	6125:  0x76B8,
	6126:  0x76B9,
	6127:  0x76BA,
	6128:  0x76C2,
	6129:  0x76CD,
	6130:  0x76D6,
	6131:  0x76D2,
	6132:  0x76DE,
	6133:  0x76E1,
	6134:  0x76E5,
	6135:  0x76E7,
	6136:  0x76EA,
	6137:  0x862F,
	6138:  0x76FB,
	6139:  0x7708,
	6140:  0x7707,
	6141:  0x7704,
	6142:  0x7729,
	6143:  0x7724,
	6144:  0x771E,
	6145:  0x7725,
	6146:  0x7726,
	6147:  0x771B,
	6148:  0x7737,
	6149:  0x7738,
	6150:  0x7747,
	6151:  0x775A,
	6152:  0x7768,
	6153:  0x776B,
	6154:  0x775B,
	6155:  0x7765,
	6156:  0x777F,
	6157:  0x777E,
	6158:  0x7779,
	6159:  0x778E,
	6160:  0x778B,
	6161:  0x7791,
	6162:  0x77A0,
	6163:  0x779E,
	6164:  0x77B0,
	6165:  0x77B6,
	6166:  0x77B9,
	6167:  0x77BF,
	6168:  0x77BC,
	6169:  0x77BD,
	6170:  0x77BB,
	6171:  0x77C7,
	6172:  0x77CD,
	6173:  0x77D7,
	6174:  0x77DA,
	6175:  0x77DC,
	6176:  0x77E3,
	6177:  0x77EE,
	6178:  0x77FC,
	6179:  0x780C,
	6180:  0x7812,
	6181:  0x7926,
	6182:  0x7820,
	6183:  0x792A,
	6184:  0x7845,
	6185:  0x788E,
	6186:  0x7874,
	6187:  0x7886,
	6188:  0x787C,
	6189:  0x789A,
	6190:  0x788C,
	6191:  0x78A3,
	6192:  0x78B5,
	6193:  0x78AA,
	6194:  0x78AF,
	6195:  0x78D1,
	6196:  0x78C6,
	6197:  0x78CB,
	6198:  0x78D4,
	6199:  0x78BE,
	6200:  0x78BC,
	6201:  0x78C5,
	6202:  0x78CA,
	6203:  0x78EC,
	6204:  0x78E7,
	6205:  0x78DA,
	6206:  0x78FD,
	6207:  0x78F4,
	6208:  0x7907,
	6209:  0x7912,
	6210:  0x7911,
	6211:  0x7919,
	6212:  0x792C,
	6213:  0x792B,
	6214:  0x7940,
	6215:  0x7960,
	6216:  0x7957,
	6217:  0x795F,
	6218:  0x795A,
	6219:  0x7955,
	6220:  0x7953,
	6221:  0x797A,
	6222:  0x797F,
	6223:  0x798A,
	6224:  0x799D,
	6225:  0x79A7,
	6226:  0x9F4B,
	6227:  0x79AA,
	6228:  0x79AE,
	6229:  0x79B3,
	6230:  0x79B9,
	6231:  0x79BA,
	6232:  0x79C9,
	6233:  0x79D5,
	6234:  0x79E7,
	6235:  0x79EC,
	6236:  0x79E1,
	6237:  0x79E3,
	6238:  0x7A08,
	6239:  0x7A0D,
	6240:  0x7A18,
	6241:  0x7A19,
	6242:  0x7A20,
	6243:  0x7A1F,
	6244:  0x7980,
	6245:  0x7A31,
	6246:  0x7A3B,
	6247:  0x7A3E,
	6248:  0x7A37,
	6249:  0x7A43,
	6250:  0x7A57,
	6251:  0x7A49,
	6252:  0x7A61,
	6253:  0x7A62,
	6254:  0x7A69,
	6255:  0x9F9D,
	6256:  0x7A70,
	6257:  0x7A79,
	6258:  0x7A7D,
	6259:  0x7A88,
	6260:  0x7A97,
	6261:  0x7A95,
	6262:  0x7A98,
	6263:  0x7A96,
	6264:  0x7AA9,
	6265:  0x7AC8,
	6266:  0x7AB0,
	6267:  0x7AB6,
	6268:  0x7AC5,
	6269:  0x7AC4,
	6270:  0x7ABF,
	6271:  0x9083,
	6272:  0x7AC7,
	6273:  0x7ACA,
	6274:  0x7ACD,
	6275:  0x7ACF,
	6276:  0x7AD5,
	6277:  0x7AD3,
	6278:  0x7AD9,
	6279:  0x7ADA,
	6280:  0x7ADD,
	6281:  0x7AE1,
	6282:  0x7AE2,
	6283:  0x7AE6,
	6284:  0x7AED,
	6285:  0x7AF0,
	6286:  0x7B02,
	6287:  0x7B0F,
	6288:  0x7B0A,
	6289:  0x7B06,
	6290:  0x7B33,
	6291:  0x7B18,
	6292:  0x7B19,
	6293:  0x7B1E,
	6294:  0x7B35,
	6295:  0x7B28,
	6296:  0x7B36,
	6297:  0x7B50,
	6298:  0x7B7A,
	6299:  0x7B04,
	6300:  0x7B4D,
	6301:  0x7B0B,
	6302:  0x7B4C,
	6303:  0x7B45,
	6304:  0x7B75,
	6305:  0x7B65,
	6306:  0x7B74,
	6307:  0x7B67,
	6308:  0x7B70,
	6309:  0x7B71,
	6310:  0x7B6C,
	6311:  0x7B6E,
	6312:  0x7B9D,
	6313:  0x7B98,
	6314:  0x7B9F,
	6315:  0x7B8D,
	6316:  0x7B9C,
	6317:  0x7B9A,
	6318:  0x7B8B,
	6319:  0x7B92,
	6320:  0x7B8F,
	6321:  0x7B5D,
	6322:  0x7B99,
	6323:  0x7BCB,
	6324:  0x7BC1,
	6325:  0x7BCC,
	6326:  0x7BCF,
	6327:  0x7BB4,
	6328:  0x7BC6,
	6329:  0x7BDD,
	6330:  0x7BE9,
	6331:  0x7C11,
	6332:  0x7C14,
	6333:  0x7BE6,
	6334:  0x7BE5,
	6335:  0x7C60,
	6336:  0x7C00,
	6337:  0x7C07,
	6338:  0x7C13,
	6339:  0x7BF3,
	6340:  0x7BF7,
	6341:  0x7C17,
	6342:  0x7C0D,
	6343:  0x7BF6,
	6344:  0x7C23,
	6345:  0x7C27,
	6346:  0x7C2A,
	6347:  0x7C1F,
	6348:  0x7C37,
	6349:  0x7C2B,
	6350:  0x7C3D,
	6351:  0x7C4C,
	6352:  0x7C43,
	6353:  0x7C54,
	6354:  0x7C4F,
	6355:  0x7C40,
	6356:  0x7C50,
	6357:  0x7C58,
	6358:  0x7C5F,
	6359:  0x7C64,
	6360:  0x7C56,
	6361:  0x7C65,
	6362:  0x7C6C,
	6363:  0x7C75,
	6364:  0x7C83,
	6365:  0x7C90,
	6366:  0x7CA4,
	6367:  0x7CAD,
	6368:  0x7CA2,
	6369:  0x7CAB,
	6370:  0x7CA1,
	6371:  0x7CA8,
	6372:  0x7CB3,
	6373:  0x7CB2,
	6374:  0x7CB1,
	6375:  0x7CAE,
	6376:  0x7CB9,
	6377:  0x7CBD,
	6378:  0x7CC0,
	6379:  0x7CC5,
	6380:  0x7CC2,
	6381:  0x7CD8,
	6382:  0x7CD2,
	6383:  0x7CDC,
	6384:  0x7CE2,
	6385:  0x9B3B,
	6386:  0x7CEF,
	6387:  0x7CF2,
	6388:  0x7CF4,
	6389:  0x7CF6,
	6390:  0x7CFA,
	6391:  0x7D06,
	6392:  0x7D02,
	6393:  0x7D1C,
	6394:  0x7D15,
	6395:  0x7D0A,
	6396:  0x7D45,
	6397:  0x7D4B,
	6398:  0x7D2E,
	6399:  0x7D32,
	6400:  0x7D3F,
	6401:  0x7D35,
	6402:  0x7D46,
	6403:  0x7D73,
	6404:  0x7D56,
	6405:  0x7D4E,
	6406:  0x7D72,
	6407:  0x7D68,
	6408:  0x7D6E,
	6409:  0x7D4F,
	6410:  0x7D63,
	6411:  0x7D93,
	6412:  0x7D89,
	6413:  0x7D5B,
	6414:  0x7D8F,
	6415:  0x7D7D,
	6416:  0x7D9B,
	6417:  0x7DBA,
	6418:  0x7DAE,
	6419:  0x7DA3,
	6420:  0x7DB5,
	6421:  0x7DC7,
	6422:  0x7DBD,
	6423:  0x7DAB,
	6424:  0x7E3D,
	6425:  0x7DA2,
	6426:  0x7DAF,
	6427:  0x7DDC,
	6428:  0x7DB8,
	6429:  0x7D9F,
	6430:  0x7DB0,
	6431:  0x7DD8,
	6432:  0x7DDD,
	6433:  0x7DE4,
	6434:  0x7DDE,
	6435:  0x7DFB,
	6436:  0x7DF2,
	6437:  0x7DE1,
	6438:  0x7E05,
	6439:  0x7E0A,
	6440:  0x7E23,
	6441:  0x7E21,
	6442:  0x7E12,
	6443:  0x7E31,
	6444:  0x7E1F,
	6445:  0x7E09,
	6446:  0x7E0B,
	6447:  0x7E22,
	6448:  0x7E46,
	6449:  0x7E66,
	6450:  0x7E3B,
	6451:  0x7E35,
	6452:  0x7E39,
	6453:  0x7E43,
	6454:  0x7E37,
	6455:  0x7E32,
	6456:  0x7E3A,
	6457:  0x7E67,
	6458:  0x7E5D,
	6459:  0x7E56,
	6460:  0x7E5E,
	6461:  0x7E59,
	6462:  0x7E5A,
	6463:  0x7E79,
	6464:  0x7E6A,
	6465:  0x7E69,
	6466:  0x7E7C,
	6467:  0x7E7B,
	6468:  0x7E83,
	6469:  0x7DD5,
	6470:  0x7E7D,
	6471:  0x8FAE,
	6472:  0x7E7F,
	6473:  0x7E88,
	6474:  0x7E89,
	6475:  0x7E8C,
	6476:  0x7E92,
	6477:  0x7E90,
	6478:  0x7E93,
	6479:  0x7E94,
	6480:  0x7E96,
	6481:  0x7E8E,
	6482:  0x7E9B,
	6483:  0x7E9C,
	6484:  0x7F38,
	6485:  0x7F3A,
	6486:  0x7F45,
	6487:  0x7F4C,
	6488:  0x7F4D,
	6489:  0x7F4E,
	6490:  0x7F50,
	6491:  0x7F51,
	6492:  0x7F55,
	6493:  0x7F54,
	6494:  0x7F58,
	6495:  0x7F5F,
	6496:  0x7F60,
	6497:  0x7F68,
	6498:  0x7F69,
	6499:  0x7F67,
	6500:  0x7F78,
	6501:  0x7F82,
	6502:  0x7F86,
	6503:  0x7F83,
	6504:  0x7F88,
	6505:  0x7F87,
	6506:  0x7F8C,
	6507:  0x7F94,
	6508:  0x7F9E,
	6509:  0x7F9D,
	6510:  0x7F9A,
	6511:  0x7FA3,
	6512:  0x7FAF,
	6513:  0x7FB2,
	6514:  0x7FB9,
	6515:  0x7FAE,
	6516:  0x7FB6,
	6517:  0x7FB8,
	6518:  0x8B71,
	6519:  0x7FC5,
	6520:  0x7FC6,
	6521:  0x7FCA,
	6522:  0x7FD5,
	6523:  0x7FD4,
	6524:  0x7FE1,
	6525:  0x7FE6,
	6526:  0x7FE9,
	6527:  0x7FF3,
	6528:  0x7FF9,
	6529:  0x98DC,
	6530:  0x8006,
	6531:  0x8004,
	6532:  0x800B,
	6533:  0x8012,
	6534:  0x8018,
	6535:  0x8019,
	6536:  0x801C,
	6537:  0x8021,
	6538:  0x8028,
	6539:  0x803F,
	6540:  0x803B,
	6541:  0x804A,
	6542:  0x8046,
	6543:  0x8052,
	6544:  0x8058,
	6545:  0x805A,
	6546:  0x805F,
	6547:  0x8062,
	6548:  0x8068,
	6549:  0x8073,
	6550:  0x8072,
	6551:  0x8070,
	6552:  0x8076,
	6553:  0x8079,
	6554:  0x807D,
	6555:  0x807F,
	6556:  0x8084,
	6557:  0x8086,
	6558:  0x8085,
	6559:  0x809B,
	6560:  0x8093,
	6561:  0x809A,
	6562:  0x80AD,
	6563:  0x5190,
	6564:  0x80AC,
	6565:  0x80DB,
	6566:  0x80E5,
	6567:  0x80D9,
	6568:  0x80DD,
	6569:  0x80C4,
	6570:  0x80DA,
	6571:  0x80D6,
	6572:  0x8109,
	6573:  0x80EF,
	6574:  0x80F1,
	6575:  0x811B,
	6576:  0x8129,
	6577:  0x8123,
	6578:  0x812F,
	6579:  0x814B,
	6580:  0x968B,
	6581:  0x8146,
	6582:  0x813E,
	6583:  0x8153,
	6584:  0x8151,
	6585:  0x80FC,
	6586:  0x8171,
	6587:  0x816E,
	6588:  0x8165,
	6589:  0x8166,
	6590:  0x8174,
	6591:  0x8183,
	6592:  0x8188,
	6593:  0x818A,
	6594:  0x8180,
	6595:  0x8182,
	6596:  0x81A0,
	6597:  0x8195,
	6598:  0x81A4,
	6599:  0x81A3,
	6600:  0x815F,
	6601:  0x8193,
	6602:  0x81A9,
	6603:  0x81B0,
	6604:  0x81B5,
	6605:  0x81BE,
	6606:  0x81B8,
	6607:  0x81BD,
	6608:  0x81C0,
	6609:  0x81C2,
	6610:  0x81BA,
	6611:  0x81C9,
	6612:  0x81CD,
	6613:  0x81D1,
	6614:  0x81D9,
	6615:  0x81D8,
	6616:  0x81C8,
	6617:  0x81DA,
	6618:  0x81DF,
	6619:  0x81E0,
	6620:  0x81E7,
	6621:  0x81FA,
	6622:  0x81FB,
	6623:  0x81FE,
	6624:  0x8201,
	6625:  0x8202,
	6626:  0x8205,
	6627:  0x8207,
	6628:  0x820A,
	6629:  0x820D,
	6630:  0x8210,
	6631:  0x8216,
	6632:  0x8229,
	6633:  0x822B,
	6634:  0x8238,
	6635:  0x8233,
	6636:  0x8240,
	6637:  0x8259,
	6638:  0x8258,
	6639:  0x825D,
	6640:  0x825A,
	6641:  0x825F,
	6642:  0x8264,
	6643:  0x8262,
	6644:  0x8268,
	6645:  0x826A,
	6646:  0x826B,
	6647:  0x822E,
	6648:  0x8271,
	6649:  0x8277,
	6650:  0x8278,
	6651:  0x827E,
	6652:  0x828D,
	6653:  0x8292,
	6654:  0x82AB,
	6655:  0x829F,
	6656:  0x82BB,
	6657:  0x82AC,
	6658:  0x82E1,
	6659:  0x82E3,
	6660:  0x82DF,
	6661:  0x82D2,
	6662:  0x82F4,
	6663:  0x82F3,
	6664:  0x82FA,
	6665:  0x8393,
	6666:  0x8303,
	6667:  0x82FB,
	6668:  0x82F9,
	6669:  0x82DE,
	6670:  0x8306,
	6671:  0x82DC,
	6672:  0x8309,
	6673:  0x82D9,
	6674:  0x8335,
	6675:  0x8334,
	6676:  0x8316,
	6677:  0x8332,
	6678:  0x8331,
	6679:  0x8340,
	6680:  0x8339,
	6681:  0x8350,
	6682:  0x8345,
	6683:  0x832F,
	6684:  0x832B,
	6685:  0x8317,
	6686:  0x8318,
	6687:  0x8385,
	6688:  0x839A,
	6689:  0x83AA,
	6690:  0x839F,
	6691:  0x83A2,
	6692:  0x8396,
	6693:  0x8323,
	6694:  0x838E,
	6695:  0x8387,
	6696:  0x838A,
	6697:  0x837C,
	6698:  0x83B5,
	6699:  0x8373,
	6700:  0x8375,
	6701:  0x83A0,
	6702:  0x8389,
	6703:  0x83A8,
	6704:  0x83F4,
	6705:  0x8413,
	6706:  0x83EB,
	6707:  0x83CE,
	6708:  0x83FD,
	6709:  0x8403,
	6710:  0x83D8,
	6711:  0x840B,
	6712:  0x83C1,
	6713:  0x83F7,
	6714:  0x8407,
	6715:  0x83E0,
	6716:  0x83F2,
	6717:  0x840D,
	6718:  0x8422,
	6719:  0x8420,
	6720:  0x83BD,
	6721:  0x8438,
	6722:  0x8506,
	6723:  0x83FB,
	6724:  0x846D,
	6725:  0x842A,
	6726:  0x843C,
	6727:  0x855A,
	6728:  0x8484,
	6729:  0x8477,
	6730:  0x846B,
	6731:  0x84AD,
	6732:  0x846E,
	6733:  0x8482,
	6734:  0x8469,
	6735:  0x8446,
	6736:  0x842C,
	6737:  0x846F,
	6738:  0x8479,
	6739:  0x8435,
	6740:  0x84CA,
	6741:  0x8462,
	6742:  0x84B9,
	6743:  0x84BF,
	6744:  0x849F,
	6745:  0x84D9,
	6746:  0x84CD,
	6747:  0x84BB,
	6748:  0x84DA,
	6749:  0x84D0,
	6750:  0x84C1,
	6751:  0x84C6,
	6752:  0x84D6,
	6753:  0x84A1,
	6754:  0x8521,
	6755:  0x84FF,
	6756:  0x84F4,
	6757:  0x8517,
	6758:  0x8518,
	6759:  0x852C,
	6760:  0x851F,
	6761:  0x8515,
	6762:  0x8514,
	6763:  0x84FC,
	6764:  0x8540,
	6765:  0x8563,
	6766:  0x8558,
	6767:  0x8548,
	6768:  0x8541,
	6769:  0x8602,
	6770:  0x854B,
	6771:  0x8555,
	6772:  0x8580,
	6773:  0x85A4,
	6774:  0x8588,
	6775:  0x8591,
	6776:  0x858A,
	6777:  0x85A8,
	6778:  0x856D,
	6779:  0x8594,
	6780:  0x859B,
	6781:  0x85EA,
	6782:  0x8587,
	6783:  0x859C,
	6784:  0x8577,
	6785:  0x857E,
	6786:  0x8590,
	6787:  0x85C9,
	6788:  0x85BA,
	6789:  0x85CF,
	6790:  0x85B9,
	6791:  0x85D0,
	6792:  0x85D5,
	6793:  0x85DD,
	6794:  0x85E5,
	6795:  0x85DC,
	6796:  0x85F9,
	6797:  0x860A,
	6798:  0x8613,
	6799:  0x860B,
	6800:  0x85FE,
	6801:  0x85FA,
	6802:  0x8606,
	6803:  0x8622,
	6804:  0x861A,
	6805:  0x8630,
	6806:  0x863F,
	6807:  0x864D,
	6808:  0x4E55,
	6809:  0x8654,
	6810:  0x865F,
	6811:  0x8667,
	6812:  0x8671,
	6813:  0x8693,
	6814:  0x86A3,
	6815:  0x86A9,
	6816:  0x86AA,
	6817:  0x868B,
	6818:  0x868C,
	6819:  0x86B6,
	6820:  0x86AF,
	6821:  0x86C4,
	6822:  0x86C6,
	6823:  0x86B0,
	6824:  0x86C9,
	6825:  0x8823,
	6826:  0x86AB,
	6827:  0x86D4,
	6828:  0x86DE,
	6829:  0x86E9,
	6830:  0x86EC,
	6831:  0x86DF,
	6832:  0x86DB,
	6833:  0x86EF,
	6834:  0x8712,
	6835:  0x8706,
	6836:  0x8708,
	6837:  0x8700,
	6838:  0x8703,
	6839:  0x86FB,
	6840:  0x8711,
	6841:  0x8709,
	6842:  0x870D,
	6843:  0x86F9,
	6844:  0x870A,
	6845:  0x8734,
	6846:  0x873F,
	6847:  0x8737,
	6848:  0x873B,
	6849:  0x8725,
	6850:  0x8729,
	6851:  0x871A,
	6852:  0x8760,
	6853:  0x875F,
	6854:  0x8778,
	6855:  0x874C,
	6856:  0x874E,
	6857:  0x8774,
	6858:  0x8757,
	6859:  0x8768,
	6860:  0x876E,
	6861:  0x8759,
	6862:  0x8753,
	6863:  0x8763,
	6864:  0x876A,
	6865:  0x8805,
	6866:  0x87A2,
	6867:  0x879F,
	6868:  0x8782,
	6869:  0x87AF,
	6870:  0x87CB,
	6871:  0x87BD,
	6872:  0x87C0,
	6873:  0x87D0,
	6874:  0x96D6,
	6875:  0x87AB,
	6876:  0x87C4,
	6877:  0x87B3,
	6878:  0x87C7,
	6879:  0x87C6,
	6880:  0x87BB,
	6881:  0x87EF,
	6882:  0x87F2,
	6883:  0x87E0,
	6884:  0x880F,
	6885:  0x880D,
	6886:  0x87FE,
	6887:  0x87F6,
	6888:  0x87F7,
	6889:  0x880E,
	6890:  0x87D2,
	6891:  0x8811,
	6892:  0x8816,
	6893:  0x8815,
	6894:  0x8822,
	6895:  0x8821,
	6896:  0x8831,
	6897:  0x8836,
	6898:  0x8839,
	6899:  0x8827,
	6900:  0x883B,
	6901:  0x8844,
	6902:  0x8842,
	6903:  0x8852,
	6904:  0x8859,
	6905:  0x885E,
	6906:  0x8862,
	6907:  0x886B,
	6908:  0x8881,
	6909:  0x887E,
	6910:  0x889E,
	6911:  0x8875,
	6912:  0x887D,
	6913:  0x88B5,
	6914:  0x8872,
	6915:  0x8882,
	6916:  0x8897,
	6917:  0x8892,
	6918:  0x88AE,
	6919:  0x8899,
	6920:  0x88A2,
	6921:  0x888D,
	6922:  0x88A4,
	6923:  0x88B0,
	6924:  0x88BF,
	6925:  0x88B1,
	6926:  0x88C3,
	6927:  0x88C4,
	6928:  0x88D4,
	6929:  0x88D8,
	6930:  0x88D9,
	6931:  0x88DD,
	6932:  0x88F9,
	6933:  0x8902,
	6934:  0x88FC,
	6935:  0x88F4,
	6936:  0x88E8,
	6937:  0x88F2,
	6938:  0x8904,
	6939:  0x890C,
	6940:  0x890A,
	6941:  0x8913,
	6942:  0x8943,
	6943:  0x891E,
	6944:  0x8925,
	6945:  0x892A,
	6946:  0x892B,
	6947:  0x8941,
	6948:  0x8944,
	6949:  0x893B,
	6950:  0x8936,
	6951:  0x8938,
	6952:  0x894C,
	6953:  0x891D,
	6954:  0x8960,
	6955:  0x895E,
	6956:  0x8966,
	6957:  0x8964,
	6958:  0x896D,
	6959:  0x896A,
	6960:  0x896F,
	6961:  0x8974,
	6962:  0x8977,
	6963:  0x897E,
	6964:  0x8983,
	6965:  0x8988,
	6966:  0x898A,
	6967:  0x8993,
	6968:  0x8998,
	6969:  0x89A1,
	6970:  0x89A9,
	6971:  0x89A6,
	6972:  0x89AC,
	6973:  0x89AF,
	6974:  0x89B2,
	6975:  0x89BA,
	6976:  0x89BD,
	6977:  0x89BF,
	6978:  0x89C0,
	6979:  0x89DA,
	6980:  0x89DC,
	6981:  0x89DD,
	6982:  0x89E7,
	6983:  0x89F4,
	6984:  0x89F8,
	6985:  0x8A03,
	6986:  0x8A16,
	6987:  0x8A10,
	6988:  0x8A0C,
	6989:  0x8A1B,
	6990:  0x8A1D,
	6991:  0x8A25,
	6992:  0x8A36,
	6993:  0x8A41,
	6994:  0x8A5B,
	6995:  0x8A52,
	6996:  0x8A46,
	6997:  0x8A48,
	6998:  0x8A7C,
	6999:  0x8A6D,
	7000:  0x8A6C,
	7001:  0x8A62,
	7002:  0x8A85,
	7003:  0x8A82,
	7004:  0x8A84,
	7005:  0x8AA8,
	7006:  0x8AA1,
	7007:  0x8A91,
	7008:  0x8AA5,
	7009:  0x8AA6,
	7010:  0x8A9A,
	7011:  0x8AA3,
	7012:  0x8AC4,
	7013:  0x8ACD,
	7014:  0x8AC2,
	7015:  0x8ADA,
	7016:  0x8AEB,
	7017:  0x8AF3,
	7018:  0x8AE7,
	7019:  0x8AE4,
	7020:  0x8AF1,
	7021:  0x8B14,
	7022:  0x8AE0,
	7023:  0x8AE2,
	7024:  0x8AF7,
	7025:  0x8ADE,
	7026:  0x8ADB,
	7027:  0x8B0C,
	7028:  0x8B07,
	7029:  0x8B1A,
	7030:  0x8AE1,
	7031:  0x8B16,
	7032:  0x8B10,
	7033:  0x8B17,
	7034:  0x8B20,
	7035:  0x8B33,
	7036:  0x97AB,
	7037:  0x8B26,
	7038:  0x8B2B,
	7039:  0x8B3E,
	7040:  0x8B28,
	7041:  0x8B41,
	7042:  0x8B4C,
	7043:  0x8B4F,
	7044:  0x8B4E,
	7045:  0x8B49,
	7046:  0x8B56,
	7047:  0x8B5B,
	7048:  0x8B5A,
	7049:  0x8B6B,
	7050:  0x8B5F,
	7051:  0x8B6C,
	7052:  0x8B6F,
	7053:  0x8B74,
	7054:  0x8B7D,
	7055:  0x8B80,
	7056:  0x8B8C,
	7057:  0x8B8E,
	7058:  0x8B92,
	7059:  0x8B93,
	7060:  0x8B96,
	7061:  0x8B99,
	7062:  0x8B9A,
	7063:  0x8C3A,
	7064:  0x8C41,
	7065:  0x8C3F,
	7066:  0x8C48,
	7067:  0x8C4C,
	7068:  0x8C4E,
	7069:  0x8C50,
	7070:  0x8C55,
	7071:  0x8C62,
	7072:  0x8C6C,
	7073:  0x8C78,
	7074:  0x8C7A,
	7075:  0x8C82,
	7076:  0x8C89,
	7077:  0x8C85,
	7078:  0x8C8A,
	7079:  0x8C8D,
	7080:  0x8C8E,
	7081:  0x8C94,
	7082:  0x8C7C,
	7083:  0x8C98,
	7084:  0x621D,
	7085:  0x8CAD,
	7086:  0x8CAA,
	7087:  0x8CBD,
	7088:  0x8CB2,
	7089:  0x8CB3,
	7090:  0x8CAE,
	7091:  0x8CB6,
	7092:  0x8CC8,
	7093:  0x8CC1,
	7094:  0x8CE4,
	7095:  0x8CE3,
	7096:  0x8CDA,
	7097:  0x8CFD,
	7098:  0x8CFA,
	7099:  0x8CFB,
	7100:  0x8D04,
	7101:  0x8D05,
	7102:  0x8D0A,
	7103:  0x8D07,
	7104:  0x8D0F,
	7105:  0x8D0D,
	7106:  0x8D10,
	7107:  0x9F4E,
	7108:  0x8D13,
	7109:  0x8CCD,
	7110:  0x8D14,
	7111:  0x8D16,
	7112:  0x8D67,
	7113:  0x8D6D,
	7114:  0x8D71,
	7115:  0x8D73,
	7116:  0x8D81,
	7117:  0x8D99,
	7118:  0x8DC2,
	7119:  0x8DBE,
	7120:  0x8DBA,
	7121:  0x8DCF,
	7122:  0x8DDA,
	7123:  0x8DD6,
	7124:  0x8DCC,
	7125:  0x8DDB,
	7126:  0x8DCB,
	7127:  0x8DEA,
	7128:  0x8DEB,
	7129:  0x8DDF,
	7130:  0x8DE3,
	7131:  0x8DFC,
	7132:  0x8E08,
	7133:  0x8E09,
	7134:  0x8DFF,
	7135:  0x8E1D,
	7136:  0x8E1E,
	7137:  0x8E10,
	7138:  0x8E1F,
	7139:  0x8E42,
	7140:  0x8E35,
	7141:  0x8E30,
	7142:  0x8E34,
	7143:  0x8E4A,
	7144:  0x8E47,
	7145:  0x8E49,
	7146:  0x8E4C,
	7147:  0x8E50,
	7148:  0x8E48,
	7149:  0x8E59,
	7150:  0x8E64,
	7151:  0x8E60,
	7152:  0x8E2A,
	7153:  0x8E63,
	7154:  0x8E55,
	7155:  0x8E76,
	7156:  0x8E72,
	7157:  0x8E7C,
	7158:  0x8E81,
	7159:  0x8E87,
	7160:  0x8E85,
	7161:  0x8E84,
	7162:  0x8E8B,
	7163:  0x8E8A,
	7164:  0x8E93,
	7165:  0x8E91,
	7166:  0x8E94,
	7167:  0x8E99,
	7168:  0x8EAA,
	7169:  0x8EA1,
	7170:  0x8EAC,
	7171:  0x8EB0,
	7172:  0x8EC6,
	7173:  0x8EB1,
	7174:  0x8EBE,
	7175:  0x8EC5,
	7176:  0x8EC8,
	7177:  0x8ECB,
	7178:  0x8EDB,
	7179:  0x8EE3,
	7180:  0x8EFC,
	7181:  0x8EFB,
	7182:  0x8EEB,
	7183:  0x8EFE,
	7184:  0x8F0A,
	7185:  0x8F05,
	7186:  0x8F15,
	7187:  0x8F12,
	7188:  0x8F19,
	7189:  0x8F13,
	7190:  0x8F1C,
	7191:  0x8F1F,
	7192:  0x8F1B,
	7193:  0x8F0C,
	7194:  0x8F26,
	7195:  0x8F33,
	7196:  0x8F3B,
	7197:  0x8F39,
	7198:  0x8F45,
	7199:  0x8F42,
	7200:  0x8F3E,
	7201:  0x8F4C,
	7202:  0x8F49,
	7203:  0x8F46,
	7204:  0x8F4E,
	7205:  0x8F57,
	7206:  0x8F5C,
	7207:  0x8F62,
	7208:  0x8F63,
	7209:  0x8F64,
	7210:  0x8F9C,
	7211:  0x8F9F,
	7212:  0x8FA3,
	7213:  0x8FAD,
	7214:  0x8FAF,
	7215:  0x8FB7,
	7216:  0x8FDA,
	7217:  0x8FE5,
	7218:  0x8FE2,
	7219:  0x8FEA,
	7220:  0x8FEF,
	7221:  0x9087,
	7222:  0x8FF4,
	7223:  0x9005,
	7224:  0x8FF9,
	7225:  0x8FFA,
	7226:  0x9011,
	7227:  0x9015,
	7228:  0x9021,
	7229:  0x900D,
	7230:  0x901E,
	7231:  0x9016,
	7232:  0x900B,
	7233:  0x9027,
	7234:  0x9036,
	7235:  0x9035,
	7236:  0x9039,
	7237:  0x8FF8,
	7238:  0x904F,
	7239:  0x9050,
	7240:  0x9051,
	7241:  0x9052,
	7242:  0x900E,
	7243:  0x9049,
	7244:  0x903E,
	7245:  0x9056,
	7246:  0x9058,
	7247:  0x905E,
	7248:  0x9068,
	7249:  0x906F,
	7250:  0x9076,
	7251:  0x96A8,
	7252:  0x9072,
	7253:  0x9082,
	7254:  0x907D,
	7255:  0x9081,
	7256:  0x9080,
	7257:  0x908A,
	7258:  0x9089,
	7259:  0x908F,
	7260:  0x90A8,
	7261:  0x90AF,
	7262:  0x90B1,
	7263:  0x90B5,
	7264:  0x90E2,
	7265:  0x90E4,
	7266:  0x6248,
	7267:  0x90DB,
	7268:  0x9102,
	7269:  0x9112,
	7270:  0x9119,
	7271:  0x9132,
	7272:  0x9130,
	7273:  0x914A,
	7274:  0x9156,
	7275:  0x9158,
	7276:  0x9163,
	7277:  0x9165,
	7278:  0x9169,
	7279:  0x9173,
	7280:  0x9172,
	7281:  0x918B,
	7282:  0x9189,
	7283:  0x9182,
	7284:  0x91A2,
	7285:  0x91AB,
	7286:  0x91AF,
	7287:  0x91AA,
	7288:  0x91B5,
	7289:  0x91B4,
	7290:  0x91BA,
	7291:  0x91C0,
	7292:  0x91C1,
	7293:  0x91C9,
	7294:  0x91CB,
	7295:  0x91D0,
	7296:  0x91D6,
	7297:  0x91DF,
	7298:  0x91E1,
	7299:  0x91DB,
	7300:  0x91FC,
	7301:  0x91F5,
	7302:  0x91F6,
	7303:  0x921E,
	7304:  0x91FF,
	7305:  0x9214,
	7306:  0x922C,
	7307:  0x9215,
	7308:  0x9211,
	7309:  0x925E,
	7310:  0x9257,
	7311:  0x9245,
	7312:  0x9249,
	7313:  0x9264,
	7314:  0x9248,
	7315:  0x9295,
	7316:  0x923F,
	7317:  0x924B,
	7318:  0x9250,
	7319:  0x929C,
	7320:  0x9296,
	7321:  0x9293,
	7322:  0x929B,
	7323:  0x925A,
	7324:  0x92CF,
	7325:  0x92B9,
	7326:  0x92B7,
	7327:  0x92E9,
	7328:  0x930F,
	7329:  0x92FA,
	7330:  0x9344,
	7331:  0x932E,
	7332:  0x9319,
	7333:  0x9322,
	7334:  0x931A,
	7335:  0x9323,
	7336:  0x933A,
	7337:  0x9335,
	7338:  0x933B,
	7339:  0x935C,
	7340:  0x9360,
	7341:  0x937C,
	7342:  0x936E,
	7343:  0x9356,
	7344:  0x93B0,
	7345:  0x93AC,
	7346:  0x93AD,
	7347:  0x9394,
	7348:  0x93B9,
	7349:  0x93D6,
	7350:  0x93D7,
	7351:  0x93E8,
	7352:  0x93E5,
	7353:  0x93D8,
	7354:  0x93C3,
	7355:  0x93DD,
	7356:  0x93D0,
	7357:  0x93C8,
	7358:  0x93E4,
	7359:  0x941A,
	7360:  0x9414,
	7361:  0x9413,
	7362:  0x9403,
	7363:  0x9407,
	7364:  0x9410,
	7365:  0x9436,
	7366:  0x942B,
	7367:  0x9435,
	7368:  0x9421,
	7369:  0x943A,
	7370:  0x9441,
	7371:  0x9452,
	7372:  0x9444,
	7373:  0x945B,
	7374:  0x9460,
	7375:  0x9462,
	7376:  0x945E,
	7377:  0x946A,
	7378:  0x9229,
	7379:  0x9470,
	7380:  0x9475,
	7381:  0x9477,
	7382:  0x947D,
	7383:  0x945A,
	7384:  0x947C,
	7385:  0x947E,
	7386:  0x9481,
	7387:  0x947F,
	7388:  0x9582,
	7389:  0x9587,
	7390:  0x958A,
	7391:  0x9594,
	7392:  0x9596,
	7393:  0x9598,
	7394:  0x9599,
	7395:  0x95A0,
	7396:  0x95A8,
	7397:  0x95A7,
	7398:  0x95AD,
	7399:  0x95BC,
	7400:  0x95BB,
	7401:  0x95B9,
	7402:  0x95BE,
	7403:  0x95CA,
	7404:  0x6FF6,
	7405:  0x95C3,
	7406:  0x95CD,
	7407:  0x95CC,
	7408:  0x95D5,
	7409:  0x95D4,
	7410:  0x95D6,
	7411:  0x95DC,
	7412:  0x95E1,
	7413:  0x95E5,
	7414:  0x95E2,
	7415:  0x9621,
	7416:  0x9628,
	7417:  0x962E,
	7418:  0x962F,
	7419:  0x9642,
	7420:  0x964C,
	7421:  0x964F,
	7422:  0x964B,
	7423:  0x9677,
	7424:  0x965C,
	7425:  0x965E,
	7426:  0x965D,
	7427:  0x965F,
	7428:  0x9666,
	7429:  0x9672,
	7430:  0x966C,
	7431:  0x968D,
	7432:  0x9698,
	7433:  0x9695,
	7434:  0x9697,
	7435:  0x96AA,
	7436:  0x96A7,
	7437:  0x96B1,
	7438:  0x96B2,
	7439:  0x96B0,
	7440:  0x96B4,
	7441:  0x96B6,
	7442:  0x96B8,
	7443:  0x96B9,
	7444:  0x96CE,
	7445:  0x96CB,
	7446:  0x96C9,
	7447:  0x96CD,
	7448:  0x894D,
	7449:  0x96DC,
	7450:  0x970D,
	7451:  0x96D5,
	7452:  0x96F9,
	7453:  0x9704,
	7454:  0x9706,
	7455:  0x9708,
	7456:  0x9713,
	7457:  0x970E,
	7458:  0x9711,
	7459:  0x970F,
	7460:  0x9716,
	7461:  0x9719,
	7462:  0x9724,
	7463:  0x972A,
	7464:  0x9730,
	7465:  0x9739,
	7466:  0x973D,
	7467:  0x973E,
	7468:  0x9744,
	7469:  0x9746,
	7470:  0x9748,
	7471:  0x9742,
	7472:  0x9749,
	7473:  0x975C,
	7474:  0x9760,
	7475:  0x9764,
	7476:  0x9766,
	7477:  0x9768,
	7478:  0x52D2,
	7479:  0x976B,
	7480:  0x9771,
	7481:  0x9779,
	7482:  0x9785,
	7483:  0x977C,
	7484:  0x9781,
	7485:  0x977A,
	7486:  0x9786,
	7487:  0x978B,
	7488:  0x978F,
	7489:  0x9790,
	7490:  0x979C,
	7491:  0x97A8,
	7492:  0x97A6,
	7493:  0x97A3,
	7494:  0x97B3,
	7495:  0x97B4,
	7496:  0x97C3,
	7497:  0x97C6,
	7498:  0x97C8,
	7499:  0x97CB,
	7500:  0x97DC,
	7501:  0x97ED,
	7502:  0x9F4F,
	7503:  0x97F2,
	7504:  0x7ADF,
	7505:  0x97F6,
	7506:  0x97F5,
	7507:  0x980F,
	7508:  0x980C,
	7509:  0x9838,
	7510:  0x9824,
	7511:  0x9821,
	7512:  0x9837,
	7513:  0x983D,
	7514:  0x9846,
	7515:  0x984F,
	7516:  0x984B,
	7517:  0x986B,
	7518:  0x986F,
	7519:  0x9870,
	7520:  0x9871,
	7521:  0x9874,
	7522:  0x9873,
	7523:  0x98AA,
	7524:  0x98AF,
	7525:  0x98B1,
	7526:  0x98B6,
	7527:  0x98C4,
	7528:  0x98C3,
	7529:  0x98C6,
	7530:  0x98E9,
	7531:  0x98EB,
	7532:  0x9903,
	7533:  0x9909,
	7534:  0x9912,
	7535:  0x9914,
	7536:  0x9918,
	7537:  0x9921,
	7538:  0x991D,
	7539:  0x991E,
	7540:  0x9924,
	7541:  0x9920,
	7542:  0x992C,
	7543:  0x992E,
	7544:  0x993D,
	7545:  0x993E,
	7546:  0x9942,
	7547:  0x9949,
	7548:  0x9945,
	7549:  0x9950,
	7550:  0x994B,
	7551:  0x9951,
	7552:  0x9952,
	7553:  0x994C,
	7554:  0x9955,
	7555:  0x9997,
	7556:  0x9998,
	7557:  0x99A5,
	7558:  0x99AD,
	7559:  0x99AE,
	7560:  0x99BC,
	7561:  0x99DF,
	7562:  0x99DB,
	7563:  0x99DD,
	7564:  0x99D8,
	7565:  0x99D1,
	7566:  0x99ED,
	7567:  0x99EE,
	7568:  0x99F1,
	7569:  0x99F2,
	7570:  0x99FB,
	7571:  0x99F8,
	7572:  0x9A01,
	7573:  0x9A0F,
	7574:  0x9A05,
	7575:  0x99E2,
	7576:  0x9A19,
	7577:  0x9A2B,
	7578:  0x9A37,
	7579:  0x9A45,
	7580:  0x9A42,
	7581:  0x9A40,
	7582:  0x9A43,
	7583:  0x9A3E,
	7584:  0x9A55,
	7585:  0x9A4D,
	7586:  0x9A5B,
	7587:  0x9A57,
	7588:  0x9A5F,
	7589:  0x9A62,
	7590:  0x9A65,
	7591:  0x9A64,
	7592:  0x9A69,
	7593:  0x9A6B,
	7594:  0x9A6A,
	7595:  0x9AAD,
	7596:  0x9AB0,
	7597:  0x9ABC,
	7598:  0x9AC0,
	7599:  0x9ACF,
	7600:  0x9AD1,
	7601:  0x9AD3,
	7602:  0x9AD4,
	7603:  0x9ADE,
	7604:  0x9ADF,
	7605:  0x9AE2,
	7606:  0x9AE3,
	7607:  0x9AE6,
	7608:  0x9AEF,
	7609:  0x9AEB,
	7610:  0x9AEE,
	7611:  0x9AF4,
	7612:  0x9AF1,
	7613:  0x9AF7,
	7614:  0x9AFB,
	7615:  0x9B06,
	7616:  0x9B18,
	7617:  0x9B1A,
	7618:  0x9B1F,
	7619:  0x9B22,
	7620:  0x9B23,
	7621:  0x9B25,
	7622:  0x9B27,
	7623:  0x9B28,
	7624:  0x9B29,
	7625:  0x9B2A,
	7626:  0x9B2E,
	7627:  0x9B2F,
	7628:  0x9B32,
	7629:  0x9B44,
	7630:  0x9B43,
	7631:  0x9B4F,
	7632:  0x9B4D,
	7633:  0x9B4E,
	7634:  0x9B51,
	7635:  0x9B58,
	7636:  0x9B74,
	7637:  0x9B93,
	7638:  0x9B83,
	7639:  0x9B91,
	7640:  0x9B96,
	7641:  0x9B97,
	7642:  0x9B9F,
	7643:  0x9BA0,
	7644:  0x9BA8,
	7645:  0x9BB4,
	7646:  0x9BC0,
	7647:  0x9BCA,
	7648:  0x9BB9,
	7649:  0x9BC6,
	7650:  0x9BCF,
	7651:  0x9BD1,
	7652:  0x9BD2,
	7653:  0x9BE3,
	7654:  0x9BE2,
	7655:  0x9BE4,
	7656:  0x9BD4,
	7657:  0x9BE1,
	7658:  0x9C3A,
	7659:  0x9BF2,
	7660:  0x9BF1,
	7661:  0x9BF0,
	7662:  0x9C15,
	7663:  0x9C14,
	7664:  0x9C09,
	7665:  0x9C13,
	7666:  0x9C0C,
	7667:  0x9C06,
	7668:  0x9C08,
	7669:  0x9C12,
	7670:  0x9C0A,
	7671:  0x9C04,
	7672:  0x9C2E,
	7673:  0x9C1B,
	7674:  0x9C25,
	7675:  0x9C24,
	7676:  0x9C21,
	7677:  0x9C30,
	7678:  0x9C47,
	7679:  0x9C32,
	7680:  0x9C46,
	7681:  0x9C3E,
	7682:  0x9C5A,
	7683:  0x9C60,
	7684:  0x9C67,
	7685:  0x9C76,
	7686:  0x9C78,
	7687:  0x9CE7,
	7688:  0x9CEC,
	7689:  0x9CF0,
	7690:  0x9D09,
	7691:  0x9D08,
	7692:  0x9CEB,
	7693:  0x9D03,
	7694:  0x9D06,
	7695:  0x9D2A,
	7696:  0x9D26,
	7697:  0x9DAF,
	7698:  0x9D23,
	7699:  0x9D1F,
	7700:  0x9D44,
	7701:  0x9D15,
	7702:  0x9D12,
	7703:  0x9D41,
	7704:  0x9D3F,
	7705:  0x9D3E,
	7706:  0x9D46,
	7707:  0x9D48,
	7708:  0x9D5D,
	7709:  0x9D5E,
	7710:  0x9D64,
	7711:  0x9D51,
	7712:  0x9D50,
	7713:  0x9D59,
	7714:  0x9D72,
	7715:  0x9D89,
	7716:  0x9D87,
	7717:  0x9DAB,
	7718:  0x9D6F,
	7719:  0x9D7A,
	7720:  0x9D9A,
	7721:  0x9DA4,
	7722:  0x9DA9,
	7723:  0x9DB2,
	7724:  0x9DC4,
	7725:  0x9DC1,
	7726:  0x9DBB,
	7727:  0x9DB8,
	7728:  0x9DBA,
	7729:  0x9DC6,
	7730:  0x9DCF,
	7731:  0x9DC2,
	7732:  0x9DD9,
	7733:  0x9DD3,
	7734:  0x9DF8,
	7735:  0x9DE6,
	7736:  0x9DED,
	7737:  0x9DEF,
	7738:  0x9DFD,
	7739:  0x9E1A,
	7740:  0x9E1B,
	7741:  0x9E1E,
	7742:  0x9E75,
	7743:  0x9E79,
	7744:  0x9E7D,
	7745:  0x9E81,
	7746:  0x9E88,
	7747:  0x9E8B,
	7748:  0x9E8C,
	7749:  0x9E92,
	7750:  0x9E95,
	7751:  0x9E91,
	7752:  0x9E9D,
	7753:  0x9EA5,
	7754:  0x9EA9,
	7755:  0x9EB8,
	7756:  0x9EAA,
	7757:  0x9EAD,
	7758:  0x9761,
	7759:  0x9ECC,
	7760:  0x9ECE,
	7761:  0x9ECF,
	7762:  0x9ED0,
	7763:  0x9ED4,
	7764:  0x9EDC,
	7765:  0x9EDE,
	7766:  0x9EDD,
	7767:  0x9EE0,
	7768:  0x9EE5,
	7769:  0x9EE8,
	7770:  0x9EEF,
	7771:  0x9EF4,
	7772:  0x9EF6,
	7773:  0x9EF7,
	7774:  0x9EF9,
	7775:  0x9EFB,
	7776:  0x9EFC,
	7777:  0x9EFD,
	7778:  0x9F07,
	7779:  0x9F08,
	7780:  0x76B7,
	7781:  0x9F15,
	7782:  0x9F21,
	7783:  0x9F2C,
	7784:  0x9F3E,
	7785:  0x9F4A,
	7786:  0x9F52,
	7787:  0x9F54,
	7788:  0x9F63,
	7789:  0x9F5F,
	7790:  0x9F60,
	7791:  0x9F61,
	7792:  0x9F66,
	7793:  0x9F67,
	7794:  0x9F6C,
	7795:  0x9F6A,
	7796:  0x9F77,
	7797:  0x9F72,
	7798:  0x9F76,
	7799:  0x9F95,
	7800:  0x9F9C,
	7801:  0x9FA0,
	7802:  0x582F,
	7803:  0x69C7,
	7804:  0x9059,
	7805:  0x7464,
	7806:  0x51DC,
	7807:  0x7199,
	8272:  0x7E8A,
	8273:  0x891C,
	8274:  0x9348,
	8275:  0x9288,
	8276:  0x84DC,
	8277:  0x4FC9,
	8278:  0x70BB,
	8279:  0x6631,
	8280:  0x68C8,
	8281:  0x92F9,
	8282:  0x66FB,
	8283:  0x5F45,
	8284:  0x4E28,
	8285:  0x4EE1,
	8286:  0x4EFC,
	8287:  0x4F00,
	8288:  0x4F03,
	8289:  0x4F39,
	8290:  0x4F56,
	8291:  0x4F92,
	8292:  0x4F8A,
	8293:  0x4F9A,
	8294:  0x4F94,
	8295:  0x4FCD,
	8296:  0x5040,
	8297:  0x5022,
	8298:  0x4FFF,
	8299:  0x501E,
	8300:  0x5046,
	8301:  0x5070,
	8302:  0x5042,
	8303:  0x5094,
	8304:  0x50F4,
	8305:  0x50D8,
	8306:  0x514A,
	8307:  0x5164,
	8308:  0x519D,
	8309:  0x51BE,
	8310:  0x51EC,
	8311:  0x5215,
	8312:  0x529C,
	8313:  0x52A6,
	8314:  0x52C0,
	8315:  0x52DB,
	8316:  0x5300,
	8317:  0x5307,
	8318:  0x5324,
	8319:  0x5372,
	8320:  0x5393,
	8321:  0x53B2,
	8322:  0x53DD,
	8323:  0xFA0E,
	8324:  0x549C,
	8325:  0x548A,
	8326:  0x54A9,
	8327:  0x54FF,
	8328:  0x5586,
	8329:  0x5759,
	8330:  0x5765,
	8331:  0x57AC,
	8332:  0x57C8,
	8333:  0x57C7,
	8334:  0xFA0F,
	8335:  0xFA10,
	8336:  0x589E,
	8337:  0x58B2,
	8338:  0x590B,
	8339:  0x5953,
	8340:  0x595B,
	8341:  0x595D,
	8342:  0x5963,
	8343:  0x59A4,
	8344:  0x59BA,
	8345:  0x5B56,
	8346:  0x5BC0,
	8347:  0x752F,
	8348:  0x5BD8,
	8349:  0x5BEC,
	8350:  0x5C1E,
	8351:  0x5CA6,
	8352:  0x5CBA,
	8353:  0x5CF5,
	8354:  0x5D27,
	8355:  0x5D53,
	8356:  0xFA11,
	8357:  0x5D42,
	8358:  0x5D6D,
	8359:  0x5DB8,
	8360:  0x5DB9,
	8361:  0x5DD0,
	8362:  0x5F21,
	8363:  0x5F34,
	8364:  0x5F67,
	8365:  0x5FB7,
	8366:  0x5FDE,
	8367:  0x605D,
	8368:  0x6085,
	8369:  0x608A,
	8370:  0x60DE,
	8371:  0x60D5,
	8372:  0x6120,
	8373:  0x60F2,
	8374:  0x6111,
	8375:  0x6137,
	8376:  0x6130,
	8377:  0x6198,
	8378:  0x6213,
	8379:  0x62A6,
	8380:  0x63F5,
	8381:  0x6460,
	8382:  0x649D,
	8383:  0x64CE,
	8384:  0x654E,
	8385:  0x6600,
	8386:  0x6615,
	8387:  0x663B,
	8388:  0x6609,
	8389:  0x662E,
	8390:  0x661E,
	8391:  0x6624,
	8392:  0x6665,
	8393:  0x6657,
	8394:  0x6659,
	8395:  0xFA12,
	8396:  0x6673,
	8397:  0x6699,
	8398:  0x66A0,
	8399:  0x66B2,
	8400:  0x66BF,
	8401:  0x66FA,
	8402:  0x670E,
	8403:  0xF929,
	8404:  0x6766,
	8405:  0x67BB,
	8406:  0x6852,
	8407:  0x67C0,
	8408:  0x6801,
	8409:  0x6844,
	8410:  0x68CF,
	8411:  0xFA13,
	8412:  0x6968,
	8413:  0xFA14,
	8414:  0x6998,
	8415:  0x69E2,
	8416:  0x6A30,
	8417:  0x6A6B,
	8418:  0x6A46,
	8419:  0x6A73,
	8420:  0x6A7E,
	8421:  0x6AE2,
	8422:  0x6AE4,
	8423:  0x6BD6,
	8424:  0x6C3F,
	8425:  0x6C5C,
	8426:  0x6C86,
	8427:  0x6C6F,
	8428:  0x6CDA,
	8429:  0x6D04,
	8430:  0x6D87,
	8431:  0x6D6F,
	8432:  0x6D96,
	8433:  0x6DAC,
	8434:  0x6DCF,
	8435:  0x6DF8,
	8436:  0x6DF2,
	8437:  0x6DFC,
	8438:  0x6E39,
	8439:  0x6E5C,
	8440:  0x6E27,
	8441:  0x6E3C,
	8442:  0x6EBF,
	8443:  0x6F88,
	8444:  0x6FB5,
	8445:  0x6FF5,
	8446:  0x7005,
	8447:  0x7007,
	8448:  0x7028,
	8449:  0x7085,
	8450:  0x70AB,
	8451:  0x710F,
	8452:  0x7104,
	8453:  0x715C,
	8454:  0x7146,
	8455:  0x7147,
	8456:  0xFA15,
	8457:  0x71C1,
	8458:  0x71FE,
	8459:  0x72B1,
	8460:  0x72BE,
	8461:  0x7324,
	8462:  0xFA16,
	8463:  0x7377,
	8464:  0x73BD,
	8465:  0x73C9,
	8466:  0x73D6,
	8467:  0x73E3,
	8468:  0x73D2,
	8469:  0x7407,
	8470:  0x73F5,
	8471:  0x7426,
	8472:  0x742A,
	8473:  0x7429,
	8474:  0x742E,
	8475:  0x7462,
	8476:  0x7489,
	8477:  0x749F,
	8478:  0x7501,
	8479:  0x756F,
	8480:  0x7682,
	8481:  0x769C,
	8482:  0x769E,
	8483:  0x769B,
	8484:  0x76A6,
	8485:  0xFA17,
	8486:  0x7746,
	8487:  0x52AF,
	8488:  0x7821,
	8489:  0x784E,
	8490:  0x7864,
	8491:  0x787A,
	8492:  0x7930,
	8493:  0xFA18,
	8494:  0xFA19,
	8495:  0xFA1A,
	8496:  0x7994,
	8497:  0xFA1B,
	8498:  0x799B,
	8499:  0x7AD1,
	8500:  0x7AE7,
	8501:  0xFA1C,
	8502:  0x7AEB,
	8503:  0x7B9E,
	8504:  0xFA1D,
	8505:  0x7D48,
	8506:  0x7D5C,
	8507:  0x7DB7,
	8508:  0x7DA0,
	8509:  0x7DD6,
	8510:  0x7E52,
	8511:  0x7F47,
	8512:  0x7FA1,
	8513:  0xFA1E,
	8514:  0x8301,
	8515:  0x8362,
	8516:  0x837F,
	8517:  0x83C7,
	8518:  0x83F6,
	8519:  0x8448,
	8520:  0x84B4,
	8521:  0x8553,
	8522:  0x8559,
	8523:  0x856B,
	8524:  0xFA1F,
	8525:  0x85B0,
	8526:  0xFA20,
	8527:  0xFA21,
	8528:  0x8807,
	8529:  0x88F5,
	8530:  0x8A12,
	8531:  0x8A37,
	8532:  0x8A79,
	8533:  0x8AA7,
	8534:  0x8ABE,
	8535:  0x8ADF,
	8536:  0xFA22,
	8537:  0x8AF6,
	8538:  0x8B53,
	8539:  0x8B7F,
	8540:  0x8CF0,
	8541:  0x8CF4,
	8542:  0x8D12,
	8543:  0x8D76,
	8544:  0xFA23,
	8545:  0x8ECF,
	8546:  0xFA24,
	8547:  0xFA25,
	8548:  0x9067,
	8549:  0x90DE,
	8550:  0xFA26,
	8551:  0x9115,
	8552:  0x9127,
	8553:  0x91DA,
	8554:  0x91D7,
	8555:  0x91DE,
	8556:  0x91ED,
	8557:  0x91EE,
	8558:  0x91E4,
	8559:  0x91E5,
	8560:  0x9206,
	8561:  0x9210,
	8562:  0x920A,
	8563:  0x923A,
	8564:  0x9240,
	8565:  0x923C,
	8566:  0x924E,
	8567:  0x9259,
	8568:  0x9251,
	8569:  0x9239,
	8570:  0x9267,
	8571:  0x92A7,
	8572:  0x9277,
	8573:  0x9278,
	8574:  0x92E7,
	8575:  0x92D7,
	8576:  0x92D9,
	8577:  0x92D0,
	8578:  0xFA27,
	8579:  0x92D5,
	8580:  0x92E0,
	8581:  0x92D3,
	8582:  0x9325,
	8583:  0x9321,
	8584:  0x92FB,
	8585:  0xFA28,
	8586:  0x931E,
	8587:  0x92FF,
	8588:  0x931D,
	8589:  0x9302,
	8590:  0x9370,
	8591:  0x9357,
	8592:  0x93A4,
	8593:  0x93C6,
	8594:  0x93DE,
	8595:  0x93F8,
	8596:  0x9431,
	8597:  0x9445,
	8598:  0x9448,
	8599:  0x9592,
	8600:  0xF9DC,
	8601:  0xFA29,
	8602:  0x969D,
	8603:  0x96AF,
	8604:  0x9733,
	8605:  0x973B,
	8606:  0x9743,
	8607:  0x974D,
	8608:  0x974F,
	8609:  0x9751,
	8610:  0x9755,
	8611:  0x9857,
	8612:  0x9865,
	8613:  0xFA2A,
	8614:  0xFA2B,
	8615:  0x9927,
	8616:  0xFA2C,
	8617:  0x999E,
	8618:  0x9A4E,
	8619:  0x9AD9,
	8620:  0x9ADC,
	8621:  0x9B75,
	8622:  0x9B72,
	8623:  0x9B8F,
	8624:  0x9BB1,
	8625:  0x9BBB,
	8626:  0x9C00,
	8627:  0x9D70,
	8628:  0x9D6B,
	8629:  0xFA2D,
	8630:  0x9E19,
	8631:  0x9ED1,
	8634:  0x2170,
	8635:  0x2171,
	8636:  0x2172,
	8637:  0x2173,
	8638:  0x2174,
	8639:  0x2175,
	8640:  0x2176,
	8641:  0x2177,
	8642:  0x2178,
	8643:  0x2179,
	8644:  0xFFE2,
	8645:  0xFFE4,
	8646:  0xFF07,
	8647:  0xFF02,
	10716: 0x2170,
	10717: 0x2171,
	10718: 0x2172,
	10719: 0x2173,
	10720: 0x2174,
	10721: 0x2175,
	10722: 0x2176,
	10723: 0x2177,
	10724: 0x2178,
	10725: 0x2179,
	10726: 0x2160,
	10727: 0x2161,
	10728: 0x2162,
	10729: 0x2163,
	10730: 0x2164,
	10731: 0x2165,
	10732: 0x2166,
	10733: 0x2167,
	10734: 0x2168,
	10735: 0x2169,
	10736: 0xFFE2,
	10737: 0xFFE4,
	10738: 0xFF07,
	10739: 0xFF02,
	10740: 0x3231,
	10741: 0x2116,
	10742: 0x2121,
	10743: 0x2235,
	10744: 0x7E8A,
	10745: 0x891C,
	10746: 0x9348,
	10747: 0x9288,
	10748: 0x84DC,
	10749: 0x4FC9,
	10750: 0x70BB,
	10751: 0x6631,
	10752: 0x68C8,
	10753: 0x92F9,
	10754: 0x66FB,
	10755: 0x5F45,
	10756: 0x4E28,
	10757: 0x4EE1,
	10758: 0x4EFC,
	10759: 0x4F00,
	10760: 0x4F03,
	10761: 0x4F39,
	10762: 0x4F56,
	10763: 0x4F92,
	10764: 0x4F8A,
	10765: 0x4F9A,
	10766: 0x4F94,
	10767: 0x4FCD,
	10768: 0x5040,
	10769: 0x5022,
	10770: 0x4FFF,
	10771: 0x501E,
	10772: 0x5046,
	10773: 0x5070,
	10774: 0x5042,
	10775: 0x5094,
	10776: 0x50F4,
	10777: 0x50D8,
	10778: 0x514A,
	10779: 0x5164,
	10780: 0x519D,
	10781: 0x51BE,
	10782: 0x51EC,
	10783: 0x5215,
	10784: 0x529C,
	10785: 0x52A6,
	10786: 0x52C0,
	10787: 0x52DB,
	10788: 0x5300,
	10789: 0x5307,
	10790: 0x5324,
	10791: 0x5372,
	10792: 0x5393,
	10793: 0x53B2,
	10794: 0x53DD,
	10795: 0xFA0E,
	10796: 0x549C,
	10797: 0x548A,
	10798: 0x54A9,
	10799: 0x54FF,
	10800: 0x5586,
	10801: 0x5759,
	10802: 0x5765,
	10803: 0x57AC,
	10804: 0x57C8,
	10805: 0x57C7,
	10806: 0xFA0F,
	10807: 0xFA10,
	10808: 0x589E,
	10809: 0x58B2,
	10810: 0x590B,
	10811: 0x5953,
	10812: 0x595B,
	10813: 0x595D,
	10814: 0x5963,
	10815: 0x59A4,
	10816: 0x59BA,
	10817: 0x5B56,
	10818: 0x5BC0,
	10819: 0x752F,
	10820: 0x5BD8,
	10821: 0x5BEC,
	10822: 0x5C1E,
	10823: 0x5CA6,
	10824: 0x5CBA,
	10825: 0x5CF5,
	10826: 0x5D27,
	10827: 0x5D53,
	10828: 0xFA11,
	10829: 0x5D42,
	10830: 0x5D6D,
	10831: 0x5DB8,
	10832: 0x5DB9,
	10833: 0x5DD0,
	10834: 0x5F21,
	10835: 0x5F34,
	10836: 0x5F67,
	10837: 0x5FB7,
	10838: 0x5FDE,
	10839: 0x605D,
	10840: 0x6085,
	10841: 0x608A,
	10842: 0x60DE,
	10843: 0x60D5,
	10844: 0x6120,
	10845: 0x60F2,
	10846: 0x6111,
	10847: 0x6137,
	10848: 0x6130,
	10849: 0x6198,
	10850: 0x6213,
	10851: 0x62A6,
	10852: 0x63F5,
	10853: 0x6460,
	10854: 0x649D,
	10855: 0x64CE,
	10856: 0x654E,
	10857: 0x6600,
	10858: 0x6615,
	10859: 0x663B,
	10860: 0x6609,
	10861: 0x662E,
	10862: 0x661E,
	10863: 0x6624,
	10864: 0x6665,
	10865: 0x6657,
	10866: 0x6659,
	10867: 0xFA12,
	10868: 0x6673,
	10869: 0x6699,
	10870: 0x66A0,
	10871: 0x66B2,
	10872: 0x66BF,
	10873: 0x66FA,
	10874: 0x670E,
	10875: 0xF929,
	10876: 0x6766,
	10877: 0x67BB,
	10878: 0x6852,
	10879: 0x67C0,
	10880: 0x6801,
	10881: 0x6844,
	10882: 0x68CF,
	10883: 0xFA13,
	10884: 0x6968,
	10885: 0xFA14,
	10886: 0x6998,
	10887: 0x69E2,
	10888: 0x6A30,
	10889: 0x6A6B,
	10890: 0x6A46,
	10891: 0x6A73,
	10892: 0x6A7E,
	10893: 0x6AE2,
	10894: 0x6AE4,
	10895: 0x6BD6,
	10896: 0x6C3F,
	10897: 0x6C5C,
	10898: 0x6C86,
	10899: 0x6C6F,
	10900: 0x6CDA,
	10901: 0x6D04,
	10902: 0x6D87,
	10903: 0x6D6F,
	10904: 0x6D96,
	10905: 0x6DAC,
	10906: 0x6DCF,
	10907: 0x6DF8,
	10908: 0x6DF2,
	10909: 0x6DFC,
	10910: 0x6E39,
	10911: 0x6E5C,
	10912: 0x6E27,
	10913: 0x6E3C,
	10914: 0x6EBF,
	10915: 0x6F88,
	10916: 0x6FB5,
	10917: 0x6FF5,
	10918: 0x7005,
	10919: 0x7007,
	10920: 0x7028,
	10921: 0x7085,
	10922: 0x70AB,
	10923: 0x710F,
	10924: 0x7104,
	10925: 0x715C,
	10926: 0x7146,
	10927: 0x7147,
	10928: 0xFA15,
	10929: 0x71C1,
	10930: 0x71FE,
	10931: 0x72B1,
	10932: 0x72BE,
	10933: 0x7324,
	10934: 0xFA16,
	10935: 0x7377,
	10936: 0x73BD,
	10937: 0x73C9,
	10938: 0x73D6,
	10939: 0x73E3,
	10940: 0x73D2,
	10941: 0x7407,
	10942: 0x73F5,
	10943: 0x7426,
	10944: 0x742A,
	10945: 0x7429,
	10946: 0x742E,
	10947: 0x7462,
	10948: 0x7489,
	10949: 0x749F,
	10950: 0x7501,
	10951: 0x756F,
	10952: 0x7682,
	10953: 0x769C,
	10954: 0x769E,
	10955: 0x769B,
	10956: 0x76A6,
	10957: 0xFA17,
	10958: 0x7746,
	10959: 0x52AF,
	10960: 0x7821,
	10961: 0x784E,
	10962: 0x7864,
	10963: 0x787A,
	10964: 0x7930,
	10965: 0xFA18,
	10966: 0xFA19,
	10967: 0xFA1A,
	10968: 0x7994,
	10969: 0xFA1B,
	10970: 0x799B,
	10971: 0x7AD1,
	10972: 0x7AE7,
	10973: 0xFA1C,
	10974: 0x7AEB,
	10975: 0x7B9E,
	10976: 0xFA1D,
	10977: 0x7D48,
	10978: 0x7D5C,
	10979: 0x7DB7,
	10980: 0x7DA0,
	10981: 0x7DD6,
	10982: 0x7E52,
	10983: 0x7F47,
	10984: 0x7FA1,
	10985: 0xFA1E,
	10986: 0x8301,
	10987: 0x8362,
	10988: 0x837F,
	10989: 0x83C7,
	10990: 0x83F6,
	10991: 0x8448,
	10992: 0x84B4,
	10993: 0x8553,
	10994: 0x8559,
	10995: 0x856B,
	10996: 0xFA1F,
	10997: 0x85B0,
	10998: 0xFA20,
	10999: 0xFA21,
	11000: 0x8807,
	11001: 0x88F5,
	11002: 0x8A12,
	11003: 0x8A37,
	11004: 0x8A79,
	11005: 0x8AA7,
	11006: 0x8ABE,
	11007: 0x8ADF,
	11008: 0xFA22,
	11009: 0x8AF6,
	11010: 0x8B53,
	11011: 0x8B7F,
	11012: 0x8CF0,
	11013: 0x8CF4,
	11014: 0x8D12,
	11015: 0x8D76,
	11016: 0xFA23,
	11017: 0x8ECF,
	11018: 0xFA24,
	11019: 0xFA25,
	11020: 0x9067,
	11021: 0x90DE,
	11022: 0xFA26,
	11023: 0x9115,
	11024: 0x9127,
	11025: 0x91DA,
	11026: 0x91D7,
	11027: 0x91DE,
	11028: 0x91ED,
	11029: 0x91EE,
	11030: 0x91E4,
	11031: 0x91E5,
	11032: 0x9206,
	11033: 0x9210,
	11034: 0x920A,
	11035: 0x923A,
	11036: 0x9240,
	11037: 0x923C,
	11038: 0x924E,
	11039: 0x9259,
	11040: 0x9251,
	11041: 0x9239,
	11042: 0x9267,
	11043: 0x92A7,
	11044: 0x9277,
	11045: 0x9278,
	11046: 0x92E7,
	11047: 0x92D7,
	11048: 0x92D9,
	11049: 0x92D0,
	11050: 0xFA27,
	11051: 0x92D5,
	11052: 0x92E0,
	11053: 0x92D3,
	11054: 0x9325,
	11055: 0x9321,
	11056: 0x92FB,
	11057: 0xFA28,
	11058: 0x931E,
	11059: 0x92FF,
	11060: 0x931D,
	11061: 0x9302,
	11062: 0x9370,
	11063: 0x9357,
	11064: 0x93A4,
	11065: 0x93C6,
	11066: 0x93DE,
	11067: 0x93F8,
	11068: 0x9431,
	11069: 0x9445,
	11070: 0x9448,
	11071: 0x9592,
	11072: 0xF9DC,
	11073: 0xFA29,
	11074: 0x969D,
	11075: 0x96AF,
	11076: 0x9733,
	11077: 0x973B,
	11078: 0x9743,
	11079: 0x974D,
	11080: 0x974F,
	11081: 0x9751,
	11082: 0x9755,
	11083: 0x9857,
	11084: 0x9865,
	11085: 0xFA2A,
	11086: 0xFA2B,
	11087: 0x9927,
	11088: 0xFA2C,
	11089: 0x999E,
	11090: 0x9A4E,
	11091: 0x9AD9,
	11092: 0x9ADC,
	11093: 0x9B75,
	11094: 0x9B72,
	11095: 0x9B8F,
	11096: 0x9BB1,
	11097: 0x9BBB,
	11098: 0x9C00,
	11099: 0x9D70,
	11100: 0x9D6B,
	11101: 0xFA2D,
	11102: 0x9E19,
	11103: 0x9ED1,
}

// jis0212Decode is the decoding table from JIS 0212 code to Unicode.
// It is defined at http://encoding.spec.whatwg.org/index-jis0212.txt
var jis0212Decode = [...]uint16{
	108:  0x02D8,
	109:  0x02C7,
	110:  0x00B8,
	111:  0x02D9,
	112:  0x02DD,
	113:  0x00AF,
	114:  0x02DB,
	115:  0x02DA,
	116:  0xFF5E,
	117:  0x0384,
	118:  0x0385,
	127:  0x00A1,
	128:  0x00A6,
	129:  0x00BF,
	168:  0x00BA,
	169:  0x00AA,
	170:  0x00A9,
	171:  0x00AE,
	172:  0x2122,
	173:  0x00A4,
	174:  0x2116,
	534:  0x0386,
	535:  0x0388,
	536:  0x0389,
	537:  0x038A,
	538:  0x03AA,
	540:  0x038C,
	542:  0x038E,
	543:  0x03AB,
	545:  0x038F,
	550:  0x03AC,
	551:  0x03AD,
	552:  0x03AE,
	553:  0x03AF,
	554:  0x03CA,
	555:  0x0390,
	556:  0x03CC,
	557:  0x03C2,
	558:  0x03CD,
	559:  0x03CB,
	560:  0x03B0,
	561:  0x03CE,
	597:  0x0402,
	598:  0x0403,
	599:  0x0404,
	600:  0x0405,
	601:  0x0406,
	602:  0x0407,
	603:  0x0408,
	604:  0x0409,
	605:  0x040A,
	606:  0x040B,
	607:  0x040C,
	608:  0x040E,
	609:  0x040F,
	645:  0x0452,
	646:  0x0453,
	647:  0x0454,
	648:  0x0455,
	649:  0x0456,
	650:  0x0457,
	651:  0x0458,
	652:  0x0459,
	653:  0x045A,
	654:  0x045B,
	655:  0x045C,
	656:  0x045E,
	657:  0x045F,
	752:  0x00C6,
	753:  0x0110,
	755:  0x0126,
	757:  0x0132,
	759:  0x0141,
	760:  0x013F,
	762:  0x014A,
	763:  0x00D8,
	764:  0x0152,
	766:  0x0166,
	767:  0x00DE,
	784:  0x00E6,
	785:  0x0111,
	786:  0x00F0,
	787:  0x0127,
	788:  0x0131,
	789:  0x0133,
	790:  0x0138,
	791:  0x0142,
	792:  0x0140,
	793:  0x0149,
	794:  0x014B,
	795:  0x00F8,
	796:  0x0153,
	797:  0x00DF,
	798:  0x0167,
	799:  0x00FE,
	846:  0x00C1,
	847:  0x00C0,
	848:  0x00C4,
	849:  0x00C2,
	850:  0x0102,
	851:  0x01CD,
	852:  0x0100,
	853:  0x0104,
	854:  0x00C5,
	855:  0x00C3,
	856:  0x0106,
	857:  0x0108,
	858:  0x010C,
	859:  0x00C7,
	860:  0x010A,
	861:  0x010E,
	862:  0x00C9,
	863:  0x00C8,
	864:  0x00CB,
	865:  0x00CA,
	866:  0x011A,
	867:  0x0116,
	868:  0x0112,
	869:  0x0118,
	871:  0x011C,
	872:  0x011E,
	873:  0x0122,
	874:  0x0120,
	875:  0x0124,
	876:  0x00CD,
	877:  0x00CC,
	878:  0x00CF,
	879:  0x00CE,
	880:  0x01CF,
	881:  0x0130,
	882:  0x012A,
	883:  0x012E,
	884:  0x0128,
	885:  0x0134,
	886:  0x0136,
	887:  0x0139,
	888:  0x013D,
	889:  0x013B,
	890:  0x0143,
	891:  0x0147,
	892:  0x0145,
	893:  0x00D1,
	894:  0x00D3,
	895:  0x00D2,
	896:  0x00D6,
	897:  0x00D4,
	898:  0x01D1,
	899:  0x0150,
	900:  0x014C,
	901:  0x00D5,
	902:  0x0154,
	903:  0x0158,
	904:  0x0156,
	905:  0x015A,
	906:  0x015C,
	907:  0x0160,
	908:  0x015E,
	909:  0x0164,
	910:  0x0162,
	911:  0x00DA,
	912:  0x00D9,
	913:  0x00DC,
	914:  0x00DB,
	915:  0x016C,
	916:  0x01D3,
	917:  0x0170,
	918:  0x016A,
	919:  0x0172,
	920:  0x016E,
	921:  0x0168,
	922:  0x01D7,
	923:  0x01DB,
	924:  0x01D9,
	925:  0x01D5,
	926:  0x0174,
	927:  0x00DD,
	928:  0x0178,
	929:  0x0176,
	930:  0x0179,
	931:  0x017D,
	932:  0x017B,
	940:  0x00E1,
	941:  0x00E0,
	942:  0x00E4,
	943:  0x00E2,
	944:  0x0103,
	945:  0x01CE,
	946:  0x0101,
	947:  0x0105,
	948:  0x00E5,
	949:  0x00E3,
	950:  0x0107,
	951:  0x0109,
	952:  0x010D,
	953:  0x00E7,
	954:  0x010B,
	955:  0x010F,
	956:  0x00E9,
	957:  0x00E8,
	958:  0x00EB,
	959:  0x00EA,
	960:  0x011B,
	961:  0x0117,
	962:  0x0113,
	963:  0x0119,
	964:  0x01F5,
	965:  0x011D,
	966:  0x011F,
	968:  0x0121,
	969:  0x0125,
	970:  0x00ED,
	971:  0x00EC,
	972:  0x00EF,
	973:  0x00EE,
	974:  0x01D0,
	976:  0x012B,
	977:  0x012F,
	978:  0x0129,
	979:  0x0135,
	980:  0x0137,
	981:  0x013A,
	982:  0x013E,
	983:  0x013C,
	984:  0x0144,
	985:  0x0148,
	986:  0x0146,
	987:  0x00F1,
	988:  0x00F3,
	989:  0x00F2,
	990:  0x00F6,
	991:  0x00F4,
	992:  0x01D2,
	993:  0x0151,
	994:  0x014D,
	995:  0x00F5,
	996:  0x0155,
	997:  0x0159,
	998:  0x0157,
	999:  0x015B,
	1000: 0x015D,
	1001: 0x0161,
	1002: 0x015F,
	1003: 0x0165,
	1004: 0x0163,
	1005: 0x00FA,
	1006: 0x00F9,
	1007: 0x00FC,
	1008: 0x00FB,
	1009: 0x016D,
	1010: 0x01D4,
	1011: 0x0171,
	1012: 0x016B,
	1013: 0x0173,
	1014: 0x016F,
	1015: 0x0169,
	1016: 0x01D8,
	1017: 0x01DC,
	1018: 0x01DA,
	1019: 0x01D6,
	1020: 0x0175,
	1021: 0x00FD,
	1022: 0x00FF,
	1023: 0x0177,
	1024: 0x017A,
	1025: 0x017E,
	1026: 0x017C,
	1410: 0x4E02,
	1411: 0x4E04,
	1412: 0x4E05,
	1413: 0x4E0C,
	1414: 0x4E12,
	1415: 0x4E1F,
	1416: 0x4E23,
	1417: 0x4E24,
	1418: 0x4E28,
	1419: 0x4E2B,
	1420: 0x4E2E,
	1421: 0x4E2F,
	1422: 0x4E30,
	1423: 0x4E35,
	1424: 0x4E40,
	1425: 0x4E41,
	1426: 0x4E44,
	1427: 0x4E47,
	1428: 0x4E51,
	1429: 0x4E5A,
	1430: 0x4E5C,
	1431: 0x4E63,
	1432: 0x4E68,
	1433: 0x4E69,
	1434: 0x4E74,
	1435: 0x4E75,
	1436: 0x4E79,
	1437: 0x4E7F,
	1438: 0x4E8D,
	1439: 0x4E96,
	1440: 0x4E97,
	1441: 0x4E9D,
	1442: 0x4EAF,
	1443: 0x4EB9,
	1444: 0x4EC3,
	1445: 0x4ED0,
	1446: 0x4EDA,
	1447: 0x4EDB,
	1448: 0x4EE0,
	1449: 0x4EE1,
	1450: 0x4EE2,
	1451: 0x4EE8,
	1452: 0x4EEF,
	1453: 0x4EF1,
	1454: 0x4EF3,
	1455: 0x4EF5,
	1456: 0x4EFD,
	1457: 0x4EFE,
	1458: 0x4EFF,
	1459: 0x4F00,
	1460: 0x4F02,
	1461: 0x4F03,
	1462: 0x4F08,
	1463: 0x4F0B,
	1464: 0x4F0C,
	1465: 0x4F12,
	1466: 0x4F15,
	1467: 0x4F16,
	1468: 0x4F17,
	1469: 0x4F19,
	1470: 0x4F2E,
	1471: 0x4F31,
	1472: 0x4F60,
	1473: 0x4F33,
	1474: 0x4F35,
	1475: 0x4F37,
	1476: 0x4F39,
	1477: 0x4F3B,
	1478: 0x4F3E,
	1479: 0x4F40,
	1480: 0x4F42,
	1481: 0x4F48,
	1482: 0x4F49,
	1483: 0x4F4B,
	1484: 0x4F4C,
	1485: 0x4F52,
	1486: 0x4F54,
	1487: 0x4F56,
	1488: 0x4F58,
	1489: 0x4F5F,
	1490: 0x4F63,
	1491: 0x4F6A,
	1492: 0x4F6C,
	1493: 0x4F6E,
	1494: 0x4F71,
	1495: 0x4F77,
	1496: 0x4F78,
	1497: 0x4F79,
	1498: 0x4F7A,
	1499: 0x4F7D,
	1500: 0x4F7E,
	1501: 0x4F81,
	1502: 0x4F82,
	1503: 0x4F84,
	1504: 0x4F85,
	1505: 0x4F89,
	1506: 0x4F8A,
	1507: 0x4F8C,
	1508: 0x4F8E,
	1509: 0x4F90,
	1510: 0x4F92,
	1511: 0x4F93,
	1512: 0x4F94,
	1513: 0x4F97,
	1514: 0x4F99,
	1515: 0x4F9A,
	1516: 0x4F9E,
	1517: 0x4F9F,
	1518: 0x4FB2,
	1519: 0x4FB7,
	1520: 0x4FB9,
	1521: 0x4FBB,
	1522: 0x4FBC,
	1523: 0x4FBD,
	1524: 0x4FBE,
	1525: 0x4FC0,
	1526: 0x4FC1,
	1527: 0x4FC5,
	1528: 0x4FC6,
	1529: 0x4FC8,
	1530: 0x4FC9,
	1531: 0x4FCB,
	1532: 0x4FCC,
	1533: 0x4FCD,
	1534: 0x4FCF,
	1535: 0x4FD2,
	1536: 0x4FDC,
	1537: 0x4FE0,
	1538: 0x4FE2,
	1539: 0x4FF0,
	1540: 0x4FF2,
	1541: 0x4FFC,
	1542: 0x4FFD,
	1543: 0x4FFF,
	1544: 0x5000,
	1545: 0x5001,
	1546: 0x5004,
	1547: 0x5007,
	1548: 0x500A,
	1549: 0x500C,
	1550: 0x500E,
	1551: 0x5010,
	1552: 0x5013,
	1553: 0x5017,
	1554: 0x5018,
	1555: 0x501B,
	1556: 0x501C,
	1557: 0x501D,
	1558: 0x501E,
	1559: 0x5022,
	1560: 0x5027,
	1561: 0x502E,
	1562: 0x5030,
	1563: 0x5032,
	1564: 0x5033,
	1565: 0x5035,
	1566: 0x5040,
	1567: 0x5041,
	1568: 0x5042,
	1569: 0x5045,
	1570: 0x5046,
	1571: 0x504A,
	1572: 0x504C,
	1573: 0x504E,
	1574: 0x5051,
	1575: 0x5052,
	1576: 0x5053,
	1577: 0x5057,
	1578: 0x5059,
	1579: 0x505F,
	1580: 0x5060,
	1581: 0x5062,
	1582: 0x5063,
	1583: 0x5066,
	1584: 0x5067,
	1585: 0x506A,
	1586: 0x506D,
	1587: 0x5070,
	1588: 0x5071,
	1589: 0x503B,
	1590: 0x5081,
	1591: 0x5083,
	1592: 0x5084,
	1593: 0x5086,
	1594: 0x508A,
	1595: 0x508E,
	1596: 0x508F,
	1597: 0x5090,
	1598: 0x5092,
	1599: 0x5093,
	1600: 0x5094,
	1601: 0x5096,
	1602: 0x509B,
	1603: 0x509C,
	1604: 0x509E,
	1605: 0x509F,
	1606: 0x50A0,
	1607: 0x50A1,
	1608: 0x50A2,
	1609: 0x50AA,
	1610: 0x50AF,
	1611: 0x50B0,
	1612: 0x50B9,
	1613: 0x50BA,
	1614: 0x50BD,
	1615: 0x50C0,
	1616: 0x50C3,
	1617: 0x50C4,
	1618: 0x50C7,
	1619: 0x50CC,
	1620: 0x50CE,
	1621: 0x50D0,
	1622: 0x50D3,
	1623: 0x50D4,
	1624: 0x50D8,
	1625: 0x50DC,
	1626: 0x50DD,
	1627: 0x50DF,
	1628: 0x50E2,
	1629: 0x50E4,
	1630: 0x50E6,
	1631: 0x50E8,
	1632: 0x50E9,
	1633: 0x50EF,
	1634: 0x50F1,
	1635: 0x50F6,
	1636: 0x50FA,
	1637: 0x50FE,
	1638: 0x5103,
	1639: 0x5106,
	1640: 0x5107,
	1641: 0x5108,
	1642: 0x510B,
	1643: 0x510C,
	1644: 0x510D,
	1645: 0x510E,
	1646: 0x50F2,
	1647: 0x5110,
	1648: 0x5117,
	1649: 0x5119,
	1650: 0x511B,
	1651: 0x511C,
	1652: 0x511D,
	1653: 0x511E,
	1654: 0x5123,
	1655: 0x5127,
	1656: 0x5128,
	1657: 0x512C,
	1658: 0x512D,
	1659: 0x512F,
	1660: 0x5131,
	1661: 0x5133,
	1662: 0x5134,
	1663: 0x5135,
	1664: 0x5138,
	1665: 0x5139,
	1666: 0x5142,
	1667: 0x514A,
	1668: 0x514F,
	1669: 0x5153,
	1670: 0x5155,
	1671: 0x5157,
	1672: 0x5158,
	1673: 0x515F,
	1674: 0x5164,
	1675: 0x5166,
	1676: 0x517E,
	1677: 0x5183,
	1678: 0x5184,
	1679: 0x518B,
	1680: 0x518E,
	1681: 0x5198,
	1682: 0x519D,
	1683: 0x51A1,
	1684: 0x51A3,
	1685: 0x51AD,
	1686: 0x51B8,
	1687: 0x51BA,
	1688: 0x51BC,
	1689: 0x51BE,
	1690: 0x51BF,
	1691: 0x51C2,
	1692: 0x51C8,
	1693: 0x51CF,
	1694: 0x51D1,
	1695: 0x51D2,
	1696: 0x51D3,
	1697: 0x51D5,
	1698: 0x51D8,
	1699: 0x51DE,
	1700: 0x51E2,
	1701: 0x51E5,
	1702: 0x51EE,
	1703: 0x51F2,
	1704: 0x51F3,
	1705: 0x51F4,
	1706: 0x51F7,
	1707: 0x5201,
	1708: 0x5202,
	1709: 0x5205,
	1710: 0x5212,
	1711: 0x5213,
	1712: 0x5215,
	1713: 0x5216,
	1714: 0x5218,
	1715: 0x5222,
	1716: 0x5228,
	1717: 0x5231,
	1718: 0x5232,
	1719: 0x5235,
	1720: 0x523C,
	1721: 0x5245,
	1722: 0x5249,
	1723: 0x5255,
	1724: 0x5257,
	1725: 0x5258,
	1726: 0x525A,
	1727: 0x525C,
	1728: 0x525F,
	1729: 0x5260,
	1730: 0x5261,
	1731: 0x5266,
	1732: 0x526E,
	1733: 0x5277,
	1734: 0x5278,
	1735: 0x5279,
	1736: 0x5280,
	1737: 0x5282,
	1738: 0x5285,
	1739: 0x528A,
	1740: 0x528C,
	1741: 0x5293,
	1742: 0x5295,
	1743: 0x5296,
	1744: 0x5297,
	1745: 0x5298,
	1746: 0x529A,
	1747: 0x529C,
	1748: 0x52A4,
	1749: 0x52A5,
	1750: 0x52A6,
	1751: 0x52A7,
	1752: 0x52AF,
	1753: 0x52B0,
	1754: 0x52B6,
	1755: 0x52B7,
	1756: 0x52B8,
	1757: 0x52BA,
	1758: 0x52BB,
	1759: 0x52BD,
	1760: 0x52C0,
	1761: 0x52C4,
	1762: 0x52C6,
	1763: 0x52C8,
	1764: 0x52CC,
	1765: 0x52CF,
	1766: 0x52D1,
	1767: 0x52D4,
	1768: 0x52D6,
	1769: 0x52DB,
	1770: 0x52DC,
	1771: 0x52E1,
	1772: 0x52E5,
	1773: 0x52E8,
	1774: 0x52E9,
	1775: 0x52EA,
	1776: 0x52EC,
	1777: 0x52F0,
	1778: 0x52F1,
	1779: 0x52F4,
	1780: 0x52F6,
	1781: 0x52F7,
	1782: 0x5300,
	1783: 0x5303,
	1784: 0x530A,
	1785: 0x530B,
	1786: 0x530C,
	1787: 0x5311,
	1788: 0x5313,
	1789: 0x5318,
	1790: 0x531B,
	1791: 0x531C,
	1792: 0x531E,
	1793: 0x531F,
	1794: 0x5325,
	1795: 0x5327,
	1796: 0x5328,
	1797: 0x5329,
	1798: 0x532B,
	1799: 0x532C,
	1800: 0x532D,
	1801: 0x5330,
	1802: 0x5332,
	1803: 0x5335,
	1804: 0x533C,
	1805: 0x533D,
	1806: 0x533E,
	1807: 0x5342,
	1808: 0x534C,
	1809: 0x534B,
	1810: 0x5359,
	1811: 0x535B,
	1812: 0x5361,
	1813: 0x5363,
	1814: 0x5365,
	1815: 0x536C,
	1816: 0x536D,
	1817: 0x5372,
	1818: 0x5379,
	1819: 0x537E,
	1820: 0x5383,
	1821: 0x5387,
	1822: 0x5388,
	1823: 0x538E,
	1824: 0x5393,
	1825: 0x5394,
	1826: 0x5399,
	1827: 0x539D,
	1828: 0x53A1,
	1829: 0x53A4,
	1830: 0x53AA,
	1831: 0x53AB,
	1832: 0x53AF,
	1833: 0x53B2,
	1834: 0x53B4,
	1835: 0x53B5,
	1836: 0x53B7,
	1837: 0x53B8,
	1838: 0x53BA,
	1839: 0x53BD,
	1840: 0x53C0,
	1841: 0x53C5,
	1842: 0x53CF,
	1843: 0x53D2,
	1844: 0x53D3,
	1845: 0x53D5,
	1846: 0x53DA,
	1847: 0x53DD,
	1848: 0x53DE,
	1849: 0x53E0,
	1850: 0x53E6,
	1851: 0x53E7,
	1852: 0x53F5,
	1853: 0x5402,
	1854: 0x5413,
	1855: 0x541A,
	1856: 0x5421,
	1857: 0x5427,
	1858: 0x5428,
	1859: 0x542A,
	1860: 0x542F,
	1861: 0x5431,
	1862: 0x5434,
	1863: 0x5435,
	1864: 0x5443,
	1865: 0x5444,
	1866: 0x5447,
	1867: 0x544D,
	1868: 0x544F,
	1869: 0x545E,
	1870: 0x5462,
	1871: 0x5464,
	1872: 0x5466,
	1873: 0x5467,
	1874: 0x5469,
	1875: 0x546B,
	1876: 0x546D,
	1877: 0x546E,
	1878: 0x5474,
	1879: 0x547F,
	1880: 0x5481,
	1881: 0x5483,
	1882: 0x5485,
	1883: 0x5488,
	1884: 0x5489,
	1885: 0x548D,
	1886: 0x5491,
	1887: 0x5495,
	1888: 0x5496,
	1889: 0x549C,
	1890: 0x549F,
	1891: 0x54A1,
	1892: 0x54A6,
	1893: 0x54A7,
	1894: 0x54A9,
	1895: 0x54AA,
	1896: 0x54AD,
	1897: 0x54AE,
	1898: 0x54B1,
	1899: 0x54B7,
	1900: 0x54B9,
	1901: 0x54BA,
	1902: 0x54BB,
	1903: 0x54BF,
	1904: 0x54C6,
	1905: 0x54CA,
	1906: 0x54CD,
	1907: 0x54CE,
	1908: 0x54E0,
	1909: 0x54EA,
	1910: 0x54EC,
	1911: 0x54EF,
	1912: 0x54F6,
	1913: 0x54FC,
	1914: 0x54FE,
	1915: 0x54FF,
	1916: 0x5500,
	1917: 0x5501,
	1918: 0x5505,
	1919: 0x5508,
	1920: 0x5509,
	1921: 0x550C,
	1922: 0x550D,
	1923: 0x550E,
	1924: 0x5515,
	1925: 0x552A,
	1926: 0x552B,
	1927: 0x5532,
	1928: 0x5535,
	1929: 0x5536,
	1930: 0x553B,
	1931: 0x553C,
	1932: 0x553D,
	1933: 0x5541,
	1934: 0x5547,
	1935: 0x5549,
	1936: 0x554A,
	1937: 0x554D,
	1938: 0x5550,
	1939: 0x5551,
	1940: 0x5558,
	1941: 0x555A,
	1942: 0x555B,
	1943: 0x555E,
	1944: 0x5560,
	1945: 0x5561,
	1946: 0x5564,
	1947: 0x5566,
	1948: 0x557F,
	1949: 0x5581,
	1950: 0x5582,
	1951: 0x5586,
	1952: 0x5588,
	1953: 0x558E,
	1954: 0x558F,
	1955: 0x5591,
	1956: 0x5592,
	1957: 0x5593,
	1958: 0x5594,
	1959: 0x5597,
	1960: 0x55A3,
	1961: 0x55A4,
	1962: 0x55AD,
	1963: 0x55B2,
	1964: 0x55BF,
	1965: 0x55C1,
	1966: 0x55C3,
	1967: 0x55C6,
	1968: 0x55C9,
	1969: 0x55CB,
	1970: 0x55CC,
	1971: 0x55CE,
	1972: 0x55D1,
	1973: 0x55D2,
	1974: 0x55D3,
	1975: 0x55D7,
	1976: 0x55D8,
	1977: 0x55DB,
	1978: 0x55DE,
	1979: 0x55E2,
	1980: 0x55E9,
	1981: 0x55F6,
	1982: 0x55FF,
	1983: 0x5605,
	1984: 0x5608,
	1985: 0x560A,
	1986: 0x560D,
	1987: 0x560E,
	1988: 0x560F,
	1989: 0x5610,
	1990: 0x5611,
	1991: 0x5612,
	1992: 0x5619,
	1993: 0x562C,
	1994: 0x5630,
	1995: 0x5633,
	1996: 0x5635,
	1997: 0x5637,
	1998: 0x5639,
	1999: 0x563B,
	2000: 0x563C,
	2001: 0x563D,
	2002: 0x563F,
	2003: 0x5640,
	2004: 0x5641,
	2005: 0x5643,
	2006: 0x5644,
	2007: 0x5646,
	2008: 0x5649,
	2009: 0x564B,
	2010: 0x564D,
	2011: 0x564F,
	2012: 0x5654,
	2013: 0x565E,
	2014: 0x5660,
	2015: 0x5661,
	2016: 0x5662,
	2017: 0x5663,
	2018: 0x5666,
	2019: 0x5669,
	2020: 0x566D,
	2021: 0x566F,
	2022: 0x5671,
	2023: 0x5672,
	2024: 0x5675,
	2025: 0x5684,
	2026: 0x5685,
	2027: 0x5688,
	2028: 0x568B,
	2029: 0x568C,
	2030: 0x5695,
	2031: 0x5699,
	2032: 0x569A,
	2033: 0x569D,
	2034: 0x569E,
	2035: 0x569F,
	2036: 0x56A6,
	2037: 0x56A7,
	2038: 0x56A8,
	2039: 0x56A9,
	2040: 0x56AB,
	2041: 0x56AC,
	2042: 0x56AD,
	2043: 0x56B1,
	2044: 0x56B3,
	2045: 0x56B7,
	2046: 0x56BE,
	2047: 0x56C5,
	2048: 0x56C9,
	2049: 0x56CA,
	2050: 0x56CB,
	2051: 0x56CF,
	2052: 0x56D0,
	2053: 0x56CC,
	2054: 0x56CD,
	2055: 0x56D9,
	2056: 0x56DC,
	2057: 0x56DD,
	2058: 0x56DF,
	2059: 0x56E1,
	2060: 0x56E4,
	2061: 0x56E5,
	2062: 0x56E6,
	2063: 0x56E7,
	2064: 0x56E8,
	2065: 0x56F1,
	2066: 0x56EB,
	2067: 0x56ED,
	2068: 0x56F6,
	2069: 0x56F7,
	2070: 0x5701,
	2071: 0x5702,
	2072: 0x5707,
	2073: 0x570A,
	2074: 0x570C,
	2075: 0x5711,
	2076: 0x5715,
	2077: 0x571A,
	2078: 0x571B,
	2079: 0x571D,
	2080: 0x5720,
	2081: 0x5722,
	2082: 0x5723,
	2083: 0x5724,
	2084: 0x5725,
	2085: 0x5729,
	2086: 0x572A,
	2087: 0x572C,
	2088: 0x572E,
	2089: 0x572F,
	2090: 0x5733,
	2091: 0x5734,
	2092: 0x573D,
	2093: 0x573E,
	2094: 0x573F,
	2095: 0x5745,
	2096: 0x5746,
	2097: 0x574C,
	2098: 0x574D,
	2099: 0x5752,
	2100: 0x5762,
	2101: 0x5765,
	2102: 0x5767,
	2103: 0x5768,
	2104: 0x576B,
	2105: 0x576D,
	2106: 0x576E,
	2107: 0x576F,
	2108: 0x5770,
	2109: 0x5771,
	2110: 0x5773,
	2111: 0x5774,
	2112: 0x5775,
	2113: 0x5777,
	2114: 0x5779,
	2115: 0x577A,
	2116: 0x577B,
	2117: 0x577C,
	2118: 0x577E,
	2119: 0x5781,
	2120: 0x5783,
	2121: 0x578C,
	2122: 0x5794,
	2123: 0x5797,
	2124: 0x5799,
	2125: 0x579A,
	2126: 0x579C,
	2127: 0x579D,
	2128: 0x579E,
	2129: 0x579F,
	2130: 0x57A1,
	2131: 0x5795,
	2132: 0x57A7,
	2133: 0x57A8,
	2134: 0x57A9,
	2135: 0x57AC,
	2136: 0x57B8,
	2137: 0x57BD,
	2138: 0x57C7,
	2139: 0x57C8,
	2140: 0x57CC,
	2141: 0x57CF,
	2142: 0x57D5,
	2143: 0x57DD,
	2144: 0x57DE,
	2145: 0x57E4,
	2146: 0x57E6,
	2147: 0x57E7,
	2148: 0x57E9,
	2149: 0x57ED,
	2150: 0x57F0,
	2151: 0x57F5,
	2152: 0x57F6,
	2153: 0x57F8,
	2154: 0x57FD,
	2155: 0x57FE,
	2156: 0x57FF,
	2157: 0x5803,
	2158: 0x5804,
	2159: 0x5808,
	2160: 0x5809,
	2161: 0x57E1,
	2162: 0x580C,
	2163: 0x580D,
	2164: 0x581B,
	2165: 0x581E,
	2166: 0x581F,
	2167: 0x5820,
	2168: 0x5826,
	2169: 0x5827,
	2170: 0x582D,
	2171: 0x5832,
	2172: 0x5839,
	2173: 0x583F,
	2174: 0x5849,
	2175: 0x584C,
	2176: 0x584D,
	2177: 0x584F,
	2178: 0x5850,
	2179: 0x5855,
	2180: 0x585F,
	2181: 0x5861,
	2182: 0x5864,
	2183: 0x5867,
	2184: 0x5868,
	2185: 0x5878,
	2186: 0x587C,
	2187: 0x587F,
	2188: 0x5880,
	2189: 0x5881,
	2190: 0x5887,
	2191: 0x5888,
	2192: 0x5889,
	2193: 0x588A,
	2194: 0x588C,
	2195: 0x588D,
	2196: 0x588F,
	2197: 0x5890,
	2198: 0x5894,
	2199: 0x5896,
	2200: 0x589D,
	2201: 0x58A0,
	2202: 0x58A1,
	2203: 0x58A2,
	2204: 0x58A6,
	2205: 0x58A9,
	2206: 0x58B1,
	2207: 0x58B2,
	2208: 0x58C4,
	2209: 0x58BC,
	2210: 0x58C2,
	2211: 0x58C8,
	2212: 0x58CD,
	2213: 0x58CE,
	2214: 0x58D0,
	2215: 0x58D2,
	2216: 0x58D4,
	2217: 0x58D6,
	2218: 0x58DA,
	2219: 0x58DD,
	2220: 0x58E1,
	2221: 0x58E2,
	2222: 0x58E9,
	2223: 0x58F3,
	2224: 0x5905,
	2225: 0x5906,
	2226: 0x590B,
	2227: 0x590C,
	2228: 0x5912,
	2229: 0x5913,
	2230: 0x5914,
	2231: 0x8641,
	2232: 0x591D,
	2233: 0x5921,
	2234: 0x5923,
	2235: 0x5924,
	2236: 0x5928,
	2237: 0x592F,
	2238: 0x5930,
	2239: 0x5933,
	2240: 0x5935,
	2241: 0x5936,
	2242: 0x593F,
	2243: 0x5943,
	2244: 0x5946,
	2245: 0x5952,
	2246: 0x5953,
	2247: 0x5959,
	2248: 0x595B,
	2249: 0x595D,
	2250: 0x595E,
	2251: 0x595F,
	2252: 0x5961,
	2253: 0x5963,
	2254: 0x596B,
	2255: 0x596D,
	2256: 0x596F,
	2257: 0x5972,
	2258: 0x5975,
	2259: 0x5976,
	2260: 0x5979,
	2261: 0x597B,
	2262: 0x597C,
	2263: 0x598B,
	2264: 0x598C,
	2265: 0x598E,
	2266: 0x5992,
	2267: 0x5995,
	2268: 0x5997,
	2269: 0x599F,
	2270: 0x59A4,
	2271: 0x59A7,
	2272: 0x59AD,
	2273: 0x59AE,
	2274: 0x59AF,
	2275: 0x59B0,
	2276: 0x59B3,
	2277: 0x59B7,
	2278: 0x59BA,
	2279: 0x59BC,
	2280: 0x59C1,
	2281: 0x59C3,
	2282: 0x59C4,
	2283: 0x59C8,
	2284: 0x59CA,
	2285: 0x59CD,
	2286: 0x59D2,
	2287: 0x59DD,
	2288: 0x59DE,
	2289: 0x59DF,
	2290: 0x59E3,
	2291: 0x59E4,
	2292: 0x59E7,
	2293: 0x59EE,
	2294: 0x59EF,
	2295: 0x59F1,
	2296: 0x59F2,
	2297: 0x59F4,
	2298: 0x59F7,
	2299: 0x5A00,
	2300: 0x5A04,
	2301: 0x5A0C,
	2302: 0x5A0D,
	2303: 0x5A0E,
	2304: 0x5A12,
	2305: 0x5A13,
	2306: 0x5A1E,
	2307: 0x5A23,
	2308: 0x5A24,
	2309: 0x5A27,
	2310: 0x5A28,
	2311: 0x5A2A,
	2312: 0x5A2D,
	2313: 0x5A30,
	2314: 0x5A44,
	2315: 0x5A45,
	2316: 0x5A47,
	2317: 0x5A48,
	2318: 0x5A4C,
	2319: 0x5A50,
	2320: 0x5A55,
	2321: 0x5A5E,
	2322: 0x5A63,
	2323: 0x5A65,
	2324: 0x5A67,
	2325: 0x5A6D,
	2326: 0x5A77,
	2327: 0x5A7A,
	2328: 0x5A7B,
	2329: 0x5A7E,
	2330: 0x5A8B,
	2331: 0x5A90,
	2332: 0x5A93,
	2333: 0x5A96,
	2334: 0x5A99,
	2335: 0x5A9C,
	2336: 0x5A9E,
	2337: 0x5A9F,
	2338: 0x5AA0,
	2339: 0x5AA2,
	2340: 0x5AA7,
	2341: 0x5AAC,
	2342: 0x5AB1,
	2343: 0x5AB2,
	2344: 0x5AB3,
	2345: 0x5AB5,
	2346: 0x5AB8,
	2347: 0x5ABA,
	2348: 0x5ABB,
	2349: 0x5ABF,
	2350: 0x5AC4,
	2351: 0x5AC6,
	2352: 0x5AC8,
	2353: 0x5ACF,
	2354: 0x5ADA,
	2355: 0x5ADC,
	2356: 0x5AE0,
	2357: 0x5AE5,
	2358: 0x5AEA,
	2359: 0x5AEE,
	2360: 0x5AF5,
	2361: 0x5AF6,
	2362: 0x5AFD,
	2363: 0x5B00,
	2364: 0x5B01,
	2365: 0x5B08,
	2366: 0x5B17,
	2367: 0x5B34,
	2368: 0x5B19,
	2369: 0x5B1B,
	2370: 0x5B1D,
	2371: 0x5B21,
	2372: 0x5B25,
	2373: 0x5B2D,
	2374: 0x5B38,
	2375: 0x5B41,
	2376: 0x5B4B,
	2377: 0x5B4C,
	2378: 0x5B52,
	2379: 0x5B56,
	2380: 0x5B5E,
	2381: 0x5B68,
	2382: 0x5B6E,
	2383: 0x5B6F,
	2384: 0x5B7C,
	2385: 0x5B7D,
	2386: 0x5B7E,
	2387: 0x5B7F,
	2388: 0x5B81,
	2389: 0x5B84,
	2390: 0x5B86,
	2391: 0x5B8A,
	2392: 0x5B8E,
	2393: 0x5B90,
	2394: 0x5B91,
	2395: 0x5B93,
	2396: 0x5B94,
	2397: 0x5B96,
	2398: 0x5BA8,
	2399: 0x5BA9,
	2400: 0x5BAC,
	2401: 0x5BAD,
	2402: 0x5BAF,
	2403: 0x5BB1,
	2404: 0x5BB2,
	2405: 0x5BB7,
	2406: 0x5BBA,
	2407: 0x5BBC,
	2408: 0x5BC0,
	2409: 0x5BC1,
	2410: 0x5BCD,
	2411: 0x5BCF,
	2412: 0x5BD6,
	2413: 0x5BD7,
	2414: 0x5BD8,
	2415: 0x5BD9,
	2416: 0x5BDA,
	2417: 0x5BE0,
	2418: 0x5BEF,
	2419: 0x5BF1,
	2420: 0x5BF4,
	2421: 0x5BFD,
	2422: 0x5C0C,
	2423: 0x5C17,
	2424: 0x5C1E,
	2425: 0x5C1F,
	2426: 0x5C23,
	2427: 0x5C26,
	2428: 0x5C29,
	2429: 0x5C2B,
	2430: 0x5C2C,
	2431: 0x5C2E,
	2432: 0x5C30,
	2433: 0x5C32,
	2434: 0x5C35,
	2435: 0x5C36,
	2436: 0x5C59,
	2437: 0x5C5A,
	2438: 0x5C5C,
	2439: 0x5C62,
	2440: 0x5C63,
	2441: 0x5C67,
	2442: 0x5C68,
	2443: 0x5C69,
	2444: 0x5C6D,
	2445: 0x5C70,
	2446: 0x5C74,
	2447: 0x5C75,
	2448: 0x5C7A,
	2449: 0x5C7B,
	2450: 0x5C7C,
	2451: 0x5C7D,
	2452: 0x5C87,
	2453: 0x5C88,
	2454: 0x5C8A,
	2455: 0x5C8F,
	2456: 0x5C92,
	2457: 0x5C9D,
	2458: 0x5C9F,
	2459: 0x5CA0,
	2460: 0x5CA2,
	2461: 0x5CA3,
	2462: 0x5CA6,
	2463: 0x5CAA,
	2464: 0x5CB2,
	2465: 0x5CB4,
	2466: 0x5CB5,
	2467: 0x5CBA,
	2468: 0x5CC9,
	2469: 0x5CCB,
	2470: 0x5CD2,
	2471: 0x5CDD,
	2472: 0x5CD7,
	2473: 0x5CEE,
	2474: 0x5CF1,
	2475: 0x5CF2,
	2476: 0x5CF4,
	2477: 0x5D01,
	2478: 0x5D06,
	2479: 0x5D0D,
	2480: 0x5D12,
	2481: 0x5D2B,
	2482: 0x5D23,
	2483: 0x5D24,
	2484: 0x5D26,
	2485: 0x5D27,
	2486: 0x5D31,
	2487: 0x5D34,
	2488: 0x5D39,
	2489: 0x5D3D,
	2490: 0x5D3F,
	2491: 0x5D42,
	2492: 0x5D43,
	2493: 0x5D46,
	2494: 0x5D48,
	2495: 0x5D55,
	2496: 0x5D51,
	2497: 0x5D59,
	2498: 0x5D4A,
	2499: 0x5D5F,
	2500: 0x5D60,
	2501: 0x5D61,
	2502: 0x5D62,
	2503: 0x5D64,
	2504: 0x5D6A,
	2505: 0x5D6D,
	2506: 0x5D70,
	2507: 0x5D79,
	2508: 0x5D7A,
	2509: 0x5D7E,
	2510: 0x5D7F,
	2511: 0x5D81,
	2512: 0x5D83,
	2513: 0x5D88,
	2514: 0x5D8A,
	2515: 0x5D92,
	2516: 0x5D93,
	2517: 0x5D94,
	2518: 0x5D95,
	2519: 0x5D99,
	2520: 0x5D9B,
	2521: 0x5D9F,
	2522: 0x5DA0,
	2523: 0x5DA7,
	2524: 0x5DAB,
	2525: 0x5DB0,
	2526: 0x5DB4,
	2527: 0x5DB8,
	2528: 0x5DB9,
	2529: 0x5DC3,
	2530: 0x5DC7,
	2531: 0x5DCB,
	2532: 0x5DD0,
	2533: 0x5DCE,
	2534: 0x5DD8,
	2535: 0x5DD9,
	2536: 0x5DE0,
	2537: 0x5DE4,
	2538: 0x5DE9,
	2539: 0x5DF8,
	2540: 0x5DF9,
	2541: 0x5E00,
	2542: 0x5E07,
	2543: 0x5E0D,
	2544: 0x5E12,
	2545: 0x5E14,
	2546: 0x5E15,
	2547: 0x5E18,
	2548: 0x5E1F,
	2549: 0x5E20,
	2550: 0x5E2E,
	2551: 0x5E28,
	2552: 0x5E32,
	2553: 0x5E35,
	2554: 0x5E3E,
	2555: 0x5E4B,
	2556: 0x5E50,
	2557: 0x5E49,
	2558: 0x5E51,
	2559: 0x5E56,
	2560: 0x5E58,
	2561: 0x5E5B,
	2562: 0x5E5C,
	2563: 0x5E5E,
	2564: 0x5E68,
	2565: 0x5E6A,
	2566: 0x5E6B,
	2567: 0x5E6C,
	2568: 0x5E6D,
	2569: 0x5E6E,
	2570: 0x5E70,
	2571: 0x5E80,
	2572: 0x5E8B,
	2573: 0x5E8E,
	2574: 0x5EA2,
	2575: 0x5EA4,
	2576: 0x5EA5,
	2577: 0x5EA8,
	2578: 0x5EAA,
	2579: 0x5EAC,
	2580: 0x5EB1,
	2581: 0x5EB3,
	2582: 0x5EBD,
	2583: 0x5EBE,
	2584: 0x5EBF,
	2585: 0x5EC6,
	2586: 0x5ECC,
	2587: 0x5ECB,
	2588: 0x5ECE,
	2589: 0x5ED1,
	2590: 0x5ED2,
	2591: 0x5ED4,
	2592: 0x5ED5,
	2593: 0x5EDC,
	2594: 0x5EDE,
	2595: 0x5EE5,
	2596: 0x5EEB,
	2597: 0x5F02,
	2598: 0x5F06,
	2599: 0x5F07,
	2600: 0x5F08,
	2601: 0x5F0E,
	2602: 0x5F19,
	2603: 0x5F1C,
	2604: 0x5F1D,
	2605: 0x5F21,
	2606: 0x5F22,
	2607: 0x5F23,
	2608: 0x5F24,
	2609: 0x5F28,
	2610: 0x5F2B,
	2611: 0x5F2C,
	2612: 0x5F2E,
	2613: 0x5F30,
	2614: 0x5F34,
	2615: 0x5F36,
	2616: 0x5F3B,
	2617: 0x5F3D,
	2618: 0x5F3F,
	2619: 0x5F40,
	2620: 0x5F44,
	2621: 0x5F45,
	2622: 0x5F47,
	2623: 0x5F4D,
	2624: 0x5F50,
	2625: 0x5F54,
	2626: 0x5F58,
	2627: 0x5F5B,
	2628: 0x5F60,
	2629: 0x5F63,
	2630: 0x5F64,
	2631: 0x5F67,
	2632: 0x5F6F,
	2633: 0x5F72,
	2634: 0x5F74,
	2635: 0x5F75,
	2636: 0x5F78,
	2637: 0x5F7A,
	2638: 0x5F7D,
	2639: 0x5F7E,
	2640: 0x5F89,
	2641: 0x5F8D,
	2642: 0x5F8F,
	2643: 0x5F96,
	2644: 0x5F9C,
	2645: 0x5F9D,
	2646: 0x5FA2,
	2647: 0x5FA7,
	2648: 0x5FAB,
	2649: 0x5FA4,
	2650: 0x5FAC,
	2651: 0x5FAF,
	2652: 0x5FB0,
	2653: 0x5FB1,
	2654: 0x5FB8,
	2655: 0x5FC4,
	2656: 0x5FC7,
	2657: 0x5FC8,
	2658: 0x5FC9,
	2659: 0x5FCB,
	2660: 0x5FD0,
	2661: 0x5FD1,
	2662: 0x5FD2,
	2663: 0x5FD3,
	2664: 0x5FD4,
	2665: 0x5FDE,
	2666: 0x5FE1,
	2667: 0x5FE2,
	2668: 0x5FE8,
	2669: 0x5FE9,
	2670: 0x5FEA,
	2671: 0x5FEC,
	2672: 0x5FED,
	2673: 0x5FEE,
	2674: 0x5FEF,
	2675: 0x5FF2,
	2676: 0x5FF3,
	2677: 0x5FF6,
	2678: 0x5FFA,
	2679: 0x5FFC,
	2680: 0x6007,
	2681: 0x600A,
	2682: 0x600D,
	2683: 0x6013,
	2684: 0x6014,
	2685: 0x6017,
	2686: 0x6018,
	2687: 0x601A,
	2688: 0x601F,
	2689: 0x6024,
	2690: 0x602D,
	2691: 0x6033,
	2692: 0x6035,
	2693: 0x6040,
	2694: 0x6047,
	2695: 0x6048,
	2696: 0x6049,
	2697: 0x604C,
	2698: 0x6051,
	2699: 0x6054,
	2700: 0x6056,
	2701: 0x6057,
	2702: 0x605D,
	2703: 0x6061,
	2704: 0x6067,
	2705: 0x6071,
	2706: 0x607E,
	2707: 0x607F,
	2708: 0x6082,
	2709: 0x6086,
	2710: 0x6088,
	2711: 0x608A,
	2712: 0x608E,
	2713: 0x6091,
	2714: 0x6093,
	2715: 0x6095,
	2716: 0x6098,
	2717: 0x609D,
	2718: 0x609E,
	2719: 0x60A2,
	2720: 0x60A4,
	2721: 0x60A5,
	2722: 0x60A8,
	2723: 0x60B0,
	2724: 0x60B1,
	2725: 0x60B7,
	2726: 0x60BB,
	2727: 0x60BE,
	2728: 0x60C2,
	2729: 0x60C4,
	2730: 0x60C8,
	2731: 0x60C9,
	2732: 0x60CA,
	2733: 0x60CB,
	2734: 0x60CE,
	2735: 0x60CF,
	2736: 0x60D4,
	2737: 0x60D5,
	2738: 0x60D9,
	2739: 0x60DB,
	2740: 0x60DD,
	2741: 0x60DE,
	2742: 0x60E2,
	2743: 0x60E5,
	2744: 0x60F2,
	2745: 0x60F5,
	2746: 0x60F8,
	2747: 0x60FC,
	2748: 0x60FD,
	2749: 0x6102,
	2750: 0x6107,
	2751: 0x610A,
	2752: 0x610C,
	2753: 0x6110,
	2754: 0x6111,
	2755: 0x6112,
	2756: 0x6113,
	2757: 0x6114,
	2758: 0x6116,
	2759: 0x6117,
	2760: 0x6119,
	2761: 0x611C,
	2762: 0x611E,
	2763: 0x6122,
	2764: 0x612A,
	2765: 0x612B,
	2766: 0x6130,
	2767: 0x6131,
	2768: 0x6135,
	2769: 0x6136,
	2770: 0x6137,
	2771: 0x6139,
	2772: 0x6141,
	2773: 0x6145,
	2774: 0x6146,
	2775: 0x6149,
	2776: 0x615E,
	2777: 0x6160,
	2778: 0x616C,
	2779: 0x6172,
	2780: 0x6178,
	2781: 0x617B,
	2782: 0x617C,
	2783: 0x617F,
	2784: 0x6180,
	2785: 0x6181,
	2786: 0x6183,
	2787: 0x6184,
	2788: 0x618B,
	2789: 0x618D,
	2790: 0x6192,
	2791: 0x6193,
	2792: 0x6197,
	2793: 0x6198,
	2794: 0x619C,
	2795: 0x619D,
	2796: 0x619F,
	2797: 0x61A0,
	2798: 0x61A5,
	2799: 0x61A8,
	2800: 0x61AA,
	2801: 0x61AD,
	2802: 0x61B8,
	2803: 0x61B9,
	2804: 0x61BC,
	2805: 0x61C0,
	2806: 0x61C1,
	2807: 0x61C2,
	2808: 0x61CE,
	2809: 0x61CF,
	2810: 0x61D5,
	2811: 0x61DC,
	2812: 0x61DD,
	2813: 0x61DE,
	2814: 0x61DF,
	2815: 0x61E1,
	2816: 0x61E2,
	2817: 0x61E7,
	2818: 0x61E9,
	2819: 0x61E5,
	2820: 0x61EC,
	2821: 0x61ED,
	2822: 0x61EF,
	2823: 0x6201,
	2824: 0x6203,
	2825: 0x6204,
	2826: 0x6207,
	2827: 0x6213,
	2828: 0x6215,
	2829: 0x621C,
	2830: 0x6220,
	2831: 0x6222,
	2832: 0x6223,
	2833: 0x6227,
	2834: 0x6229,
	2835: 0x622B,
	2836: 0x6239,
	2837: 0x623D,
	2838: 0x6242,
	2839: 0x6243,
	2840: 0x6244,
	2841: 0x6246,
	2842: 0x624C,
	2843: 0x6250,
	2844: 0x6251,
	2845: 0x6252,
	2846: 0x6254,
	2847: 0x6256,
	2848: 0x625A,
	2849: 0x625C,
	2850: 0x6264,
	2851: 0x626D,
	2852: 0x626F,
	2853: 0x6273,
	2854: 0x627A,
	2855: 0x627D,
	2856: 0x628D,
	2857: 0x628E,
	2858: 0x628F,
	2859: 0x6290,
	2860: 0x62A6,
	2861: 0x62A8,
	2862: 0x62B3,
	2863: 0x62B6,
	2864: 0x62B7,
	2865: 0x62BA,
	2866: 0x62BE,
	2867: 0x62BF,
	2868: 0x62C4,
	2869: 0x62CE,
	2870: 0x62D5,
	2871: 0x62D6,
	2872: 0x62DA,
	2873: 0x62EA,
	2874: 0x62F2,
	2875: 0x62F4,
	2876: 0x62FC,
	2877: 0x62FD,
	2878: 0x6303,
	2879: 0x6304,
	2880: 0x630A,
	2881: 0x630B,
	2882: 0x630D,
	2883: 0x6310,
	2884: 0x6313,
	2885: 0x6316,
	2886: 0x6318,
	2887: 0x6329,
	2888: 0x632A,
	2889: 0x632D,
	2890: 0x6335,
	2891: 0x6336,
	2892: 0x6339,
	2893: 0x633C,
	2894: 0x6341,
	2895: 0x6342,
	2896: 0x6343,
	2897: 0x6344,
	2898: 0x6346,
	2899: 0x634A,
	2900: 0x634B,
	2901: 0x634E,
	2902: 0x6352,
	2903: 0x6353,
	2904: 0x6354,
	2905: 0x6358,
	2906: 0x635B,
	2907: 0x6365,
	2908: 0x6366,
	2909: 0x636C,
	2910: 0x636D,
	2911: 0x6371,
	2912: 0x6374,
	2913: 0x6375,
	2914: 0x6378,
	2915: 0x637C,
	2916: 0x637D,
	2917: 0x637F,
	2918: 0x6382,
	2919: 0x6384,
	2920: 0x6387,
	2921: 0x638A,
	2922: 0x6390,
	2923: 0x6394,
	2924: 0x6395,
	2925: 0x6399,
	2926: 0x639A,
	2927: 0x639E,
	2928: 0x63A4,
	2929: 0x63A6,
	2930: 0x63AD,
	2931: 0x63AE,
	2932: 0x63AF,
	2933: 0x63BD,
	2934: 0x63C1,
	2935: 0x63C5,
	2936: 0x63C8,
	2937: 0x63CE,
	2938: 0x63D1,
	2939: 0x63D3,
	2940: 0x63D4,
	2941: 0x63D5,
	2942: 0x63DC,
	2943: 0x63E0,
	2944: 0x63E5,
	2945: 0x63EA,
	2946: 0x63EC,
	2947: 0x63F2,
	2948: 0x63F3,
	2949: 0x63F5,
	2950: 0x63F8,
	2951: 0x63F9,
	2952: 0x6409,
	2953: 0x640A,
	2954: 0x6410,
	2955: 0x6412,
	2956: 0x6414,
	2957: 0x6418,
	2958: 0x641E,
	2959: 0x6420,
	2960: 0x6422,
	2961: 0x6424,
	2962: 0x6425,
	2963: 0x6429,
	2964: 0x642A,
	2965: 0x642F,
	2966: 0x6430,
	2967: 0x6435,
	2968: 0x643D,
	2969: 0x643F,
	2970: 0x644B,
	2971: 0x644F,
	2972: 0x6451,
	2973: 0x6452,
	2974: 0x6453,
	2975: 0x6454,
	2976: 0x645A,
	2977: 0x645B,
	2978: 0x645C,
	2979: 0x645D,
	2980: 0x645F,
	2981: 0x6460,
	2982: 0x6461,
	2983: 0x6463,
	2984: 0x646D,
	2985: 0x6473,
	2986: 0x6474,
	2987: 0x647B,
	2988: 0x647D,
	2989: 0x6485,
	2990: 0x6487,
	2991: 0x648F,
	2992: 0x6490,
	2993: 0x6491,
	2994: 0x6498,
	2995: 0x6499,
	2996: 0x649B,
	2997: 0x649D,
	2998: 0x649F,
	2999: 0x64A1,
	3000: 0x64A3,
	3001: 0x64A6,
	3002: 0x64A8,
	3003: 0x64AC,
	3004: 0x64B3,
	3005: 0x64BD,
	3006: 0x64BE,
	3007: 0x64BF,
	3008: 0x64C4,
	3009: 0x64C9,
	3010: 0x64CA,
	3011: 0x64CB,
	3012: 0x64CC,
	3013: 0x64CE,
	3014: 0x64D0,
	3015: 0x64D1,
	3016: 0x64D5,
	3017: 0x64D7,
	3018: 0x64E4,
	3019: 0x64E5,
	3020: 0x64E9,
	3021: 0x64EA,
	3022: 0x64ED,
	3023: 0x64F0,
	3024: 0x64F5,
	3025: 0x64F7,
	3026: 0x64FB,
	3027: 0x64FF,
	3028: 0x6501,
	3029: 0x6504,
	3030: 0x6508,
	3031: 0x6509,
	3032: 0x650A,
	3033: 0x650F,
	3034: 0x6513,
	3035: 0x6514,
	3036: 0x6516,
	3037: 0x6519,
	3038: 0x651B,
	3039: 0x651E,
	3040: 0x651F,
	3041: 0x6522,
	3042: 0x6526,
	3043: 0x6529,
	3044: 0x652E,
	3045: 0x6531,
	3046: 0x653A,
	3047: 0x653C,
	3048: 0x653D,
	3049: 0x6543,
	3050: 0x6547,
	3051: 0x6549,
	3052: 0x6550,
	3053: 0x6552,
	3054: 0x6554,
	3055: 0x655F,
	3056: 0x6560,
	3057: 0x6567,
	3058: 0x656B,
	3059: 0x657A,
	3060: 0x657D,
	3061: 0x6581,
	3062: 0x6585,
	3063: 0x658A,
	3064: 0x6592,
	3065: 0x6595,
	3066: 0x6598,
	3067: 0x659D,
	3068: 0x65A0,
	3069: 0x65A3,
	3070: 0x65A6,
	3071: 0x65AE,
	3072: 0x65B2,
	3073: 0x65B3,
	3074: 0x65B4,
	3075: 0x65BF,
	3076: 0x65C2,
	3077: 0x65C8,
	3078: 0x65C9,
	3079: 0x65CE,
	3080: 0x65D0,
	3081: 0x65D4,
	3082: 0x65D6,
	3083: 0x65D8,
	3084: 0x65DF,
	3085: 0x65F0,
	3086: 0x65F2,
	3087: 0x65F4,
	3088: 0x65F5,
	3089: 0x65F9,
	3090: 0x65FE,
	3091: 0x65FF,
	3092: 0x6600,
	3093: 0x6604,
	3094: 0x6608,
	3095: 0x6609,
	3096: 0x660D,
	3097: 0x6611,
	3098: 0x6612,
	3099: 0x6615,
	3100: 0x6616,
	3101: 0x661D,
	3102: 0x661E,
	3103: 0x6621,
	3104: 0x6622,
	3105: 0x6623,
	3106: 0x6624,
	3107: 0x6626,
	3108: 0x6629,
	3109: 0x662A,
	3110: 0x662B,
	3111: 0x662C,
	3112: 0x662E,
	3113: 0x6630,
	3114: 0x6631,
	3115: 0x6633,
	3116: 0x6639,
	3117: 0x6637,
	3118: 0x6640,
	3119: 0x6645,
	3120: 0x6646,
	3121: 0x664A,
	3122: 0x664C,
	3123: 0x6651,
	3124: 0x664E,
	3125: 0x6657,
	3126: 0x6658,
	3127: 0x6659,
	3128: 0x665B,
	3129: 0x665C,
	3130: 0x6660,
	3131: 0x6661,
	3132: 0x66FB,
	3133: 0x666A,
	3134: 0x666B,
	3135: 0x666C,
	3136: 0x667E,
	3137: 0x6673,
	3138: 0x6675,
	3139: 0x667F,
	3140: 0x6677,
	3141: 0x6678,
	3142: 0x6679,
	3143: 0x667B,
	3144: 0x6680,
	3145: 0x667C,
	3146: 0x668B,
	3147: 0x668C,
	3148: 0x668D,
	3149: 0x6690,
	3150: 0x6692,
	3151: 0x6699,
	3152: 0x669A,
	3153: 0x669B,
	3154: 0x669C,
	3155: 0x669F,
	3156: 0x66A0,
	3157: 0x66A4,
	3158: 0x66AD,
	3159: 0x66B1,
	3160: 0x66B2,
	3161: 0x66B5,
	3162: 0x66BB,
	3163: 0x66BF,
	3164: 0x66C0,
	3165: 0x66C2,
	3166: 0x66C3,
	3167: 0x66C8,
	3168: 0x66CC,
	3169: 0x66CE,
	3170: 0x66CF,
	3171: 0x66D4,
	3172: 0x66DB,
	3173: 0x66DF,
	3174: 0x66E8,
	3175: 0x66EB,
	3176: 0x66EC,
	3177: 0x66EE,
	3178: 0x66FA,
	3179: 0x6705,
	3180: 0x6707,
	3181: 0x670E,
	3182: 0x6713,
	3183: 0x6719,
	3184: 0x671C,
	3185: 0x6720,
	3186: 0x6722,
	3187: 0x6733,
	3188: 0x673E,
	3189: 0x6745,
	3190: 0x6747,
	3191: 0x6748,
	3192: 0x674C,
	3193: 0x6754,
	3194: 0x6755,
	3195: 0x675D,
	3196: 0x6766,
	3197: 0x676C,
	3198: 0x676E,
	3199: 0x6774,
	3200: 0x6776,
	3201: 0x677B,
	3202: 0x6781,
	3203: 0x6784,
	3204: 0x678E,
	3205: 0x678F,
	3206: 0x6791,
	3207: 0x6793,
	3208: 0x6796,
	3209: 0x6798,
	3210: 0x6799,
	3211: 0x679B,
	3212: 0x67B0,
	3213: 0x67B1,
	3214: 0x67B2,
	3215: 0x67B5,
	3216: 0x67BB,
	3217: 0x67BC,
	3218: 0x67BD,
	3219: 0x67F9,
	3220: 0x67C0,
	3221: 0x67C2,
	3222: 0x67C3,
	3223: 0x67C5,
	3224: 0x67C8,
	3225: 0x67C9,
	3226: 0x67D2,
	3227: 0x67D7,
	3228: 0x67D9,
	3229: 0x67DC,
	3230: 0x67E1,
	3231: 0x67E6,
	3232: 0x67F0,
	3233: 0x67F2,
	3234: 0x67F6,
	3235: 0x67F7,
	3236: 0x6852,
	3237: 0x6814,
	3238: 0x6819,
	3239: 0x681D,
	3240: 0x681F,
	3241: 0x6828,
	3242: 0x6827,
	3243: 0x682C,
	3244: 0x682D,
	3245: 0x682F,
	3246: 0x6830,
	3247: 0x6831,
	3248: 0x6833,
	3249: 0x683B,
	3250: 0x683F,
	3251: 0x6844,
	3252: 0x6845,
	3253: 0x684A,
	3254: 0x684C,
	3255: 0x6855,
	3256: 0x6857,
	3257: 0x6858,
	3258: 0x685B,
	3259: 0x686B,
	3260: 0x686E,
	3261: 0x686F,
	3262: 0x6870,
	3263: 0x6871,
	3264: 0x6872,
	3265: 0x6875,
	3266: 0x6879,
	3267: 0x687A,
	3268: 0x687B,
	3269: 0x687C,
	3270: 0x6882,
	3271: 0x6884,
	3272: 0x6886,
	3273: 0x6888,
	3274: 0x6896,
	3275: 0x6898,
	3276: 0x689A,
	3277: 0x689C,
	3278: 0x68A1,
	3279: 0x68A3,
	3280: 0x68A5,
	3281: 0x68A9,
	3282: 0x68AA,
	3283: 0x68AE,
	3284: 0x68B2,
	3285: 0x68BB,
	3286: 0x68C5,
	3287: 0x68C8,
	3288: 0x68CC,
	3289: 0x68CF,
	3290: 0x68D0,
	3291: 0x68D1,
	3292: 0x68D3,
	3293: 0x68D6,
	3294: 0x68D9,
	3295: 0x68DC,
	3296: 0x68DD,
	3297: 0x68E5,
	3298: 0x68E8,
	3299: 0x68EA,
	3300: 0x68EB,
	3301: 0x68EC,
	3302: 0x68ED,
	3303: 0x68F0,
	3304: 0x68F1,
	3305: 0x68F5,
	3306: 0x68F6,
	3307: 0x68FB,
	3308: 0x68FC,
	3309: 0x68FD,
	3310: 0x6906,
	3311: 0x6909,
	3312: 0x690A,
	3313: 0x6910,
	3314: 0x6911,
	3315: 0x6913,
	3316: 0x6916,
	3317: 0x6917,
	3318: 0x6931,
	3319: 0x6933,
	3320: 0x6935,
	3321: 0x6938,
	3322: 0x693B,
	3323: 0x6942,
	3324: 0x6945,
	3325: 0x6949,
	3326: 0x694E,
	3327: 0x6957,
	3328: 0x695B,
	3329: 0x6963,
	3330: 0x6964,
	3331: 0x6965,
	3332: 0x6966,
	3333: 0x6968,
	3334: 0x6969,
	3335: 0x696C,
	3336: 0x6970,
	3337: 0x6971,
	3338: 0x6972,
	3339: 0x697A,
	3340: 0x697B,
	3341: 0x697F,
	3342: 0x6980,
	3343: 0x698D,
	3344: 0x6992,
	3345: 0x6996,
	3346: 0x6998,
	3347: 0x69A1,
	3348: 0x69A5,
	3349: 0x69A6,
	3350: 0x69A8,
	3351: 0x69AB,
	3352: 0x69AD,
	3353: 0x69AF,
	3354: 0x69B7,
	3355: 0x69B8,
	3356: 0x69BA,
	3357: 0x69BC,
	3358: 0x69C5,
	3359: 0x69C8,
	3360: 0x69D1,
	3361: 0x69D6,
	3362: 0x69D7,
	3363: 0x69E2,
	3364: 0x69E5,
	3365: 0x69EE,
	3366: 0x69EF,
	3367: 0x69F1,
	3368: 0x69F3,
	3369: 0x69F5,
	3370: 0x69FE,
	3371: 0x6A00,
	3372: 0x6A01,
	3373: 0x6A03,
	3374: 0x6A0F,
	3375: 0x6A11,
	3376: 0x6A15,
	3377: 0x6A1A,
	3378: 0x6A1D,
	3379: 0x6A20,
	3380: 0x6A24,
	3381: 0x6A28,
	3382: 0x6A30,
	3383: 0x6A32,
	3384: 0x6A34,
	3385: 0x6A37,
	3386: 0x6A3B,
	3387: 0x6A3E,
	3388: 0x6A3F,
	3389: 0x6A45,
	3390: 0x6A46,
	3391: 0x6A49,
	3392: 0x6A4A,
	3393: 0x6A4E,
	3394: 0x6A50,
	3395: 0x6A51,
	3396: 0x6A52,
	3397: 0x6A55,
	3398: 0x6A56,
	3399: 0x6A5B,
	3400: 0x6A64,
	3401: 0x6A67,
	3402: 0x6A6A,
	3403: 0x6A71,
	3404: 0x6A73,
	3405: 0x6A7E,
	3406: 0x6A81,
	3407: 0x6A83,
	3408: 0x6A86,
	3409: 0x6A87,
	3410: 0x6A89,
	3411: 0x6A8B,
	3412: 0x6A91,
	3413: 0x6A9B,
	3414: 0x6A9D,
	3415: 0x6A9E,
	3416: 0x6A9F,
	3417: 0x6AA5,
	3418: 0x6AAB,
	3419: 0x6AAF,
	3420: 0x6AB0,
	3421: 0x6AB1,
	3422: 0x6AB4,
	3423: 0x6ABD,
	3424: 0x6ABE,
	3425: 0x6ABF,
	3426: 0x6AC6,
	3427: 0x6AC9,
	3428: 0x6AC8,
	3429: 0x6ACC,
	3430: 0x6AD0,
	3431: 0x6AD4,
	3432: 0x6AD5,
	3433: 0x6AD6,
	3434: 0x6ADC,
	3435: 0x6ADD,
	3436: 0x6AE4,
	3437: 0x6AE7,
	3438: 0x6AEC,
	3439: 0x6AF0,
	3440: 0x6AF1,
	3441: 0x6AF2,
	3442: 0x6AFC,
	3443: 0x6AFD,
	3444: 0x6B02,
	3445: 0x6B03,
	3446: 0x6B06,
	3447: 0x6B07,
	3448: 0x6B09,
	3449: 0x6B0F,
	3450: 0x6B10,
	3451: 0x6B11,
	3452: 0x6B17,
	3453: 0x6B1B,
	3454: 0x6B1E,
	3455: 0x6B24,
	3456: 0x6B28,
	3457: 0x6B2B,
	3458: 0x6B2C,
	3459: 0x6B2F,
	3460: 0x6B35,
	3461: 0x6B36,
	3462: 0x6B3B,
	3463: 0x6B3F,
	3464: 0x6B46,
	3465: 0x6B4A,
	3466: 0x6B4D,
	3467: 0x6B52,
	3468: 0x6B56,
	3469: 0x6B58,
	3470: 0x6B5D,
	3471: 0x6B60,
	3472: 0x6B67,
	3473: 0x6B6B,
	3474: 0x6B6E,
	3475: 0x6B70,
	3476: 0x6B75,
	3477: 0x6B7D,
	3478: 0x6B7E,
	3479: 0x6B82,
	3480: 0x6B85,
	3481: 0x6B97,
	3482: 0x6B9B,
	3483: 0x6B9F,
	3484: 0x6BA0,
	3485: 0x6BA2,
	3486: 0x6BA3,
	3487: 0x6BA8,
	3488: 0x6BA9,
	3489: 0x6BAC,
	3490: 0x6BAD,
	3491: 0x6BAE,
	3492: 0x6BB0,
	3493: 0x6BB8,
	3494: 0x6BB9,
	3495: 0x6BBD,
	3496: 0x6BBE,
	3497: 0x6BC3,
	3498: 0x6BC4,
	3499: 0x6BC9,
	3500: 0x6BCC,
	3501: 0x6BD6,
	3502: 0x6BDA,
	3503: 0x6BE1,
	3504: 0x6BE3,
	3505: 0x6BE6,
	3506: 0x6BE7,
	3507: 0x6BEE,
	3508: 0x6BF1,
	3509: 0x6BF7,
	3510: 0x6BF9,
	3511: 0x6BFF,
	3512: 0x6C02,
	3513: 0x6C04,
	3514: 0x6C05,
	3515: 0x6C09,
	3516: 0x6C0D,
	3517: 0x6C0E,
	3518: 0x6C10,
	3519: 0x6C12,
	3520: 0x6C19,
	3521: 0x6C1F,
	3522: 0x6C26,
	3523: 0x6C27,
	3524: 0x6C28,
	3525: 0x6C2C,
	3526: 0x6C2E,
	3527: 0x6C33,
	3528: 0x6C35,
	3529: 0x6C36,
	3530: 0x6C3A,
	3531: 0x6C3B,
	3532: 0x6C3F,
	3533: 0x6C4A,
	3534: 0x6C4B,
	3535: 0x6C4D,
	3536: 0x6C4F,
	3537: 0x6C52,
	3538: 0x6C54,
	3539: 0x6C59,
	3540: 0x6C5B,
	3541: 0x6C5C,
	3542: 0x6C6B,
	3543: 0x6C6D,
	3544: 0x6C6F,
	3545: 0x6C74,
	3546: 0x6C76,
	3547: 0x6C78,
	3548: 0x6C79,
	3549: 0x6C7B,
	3550: 0x6C85,
	3551: 0x6C86,
	3552: 0x6C87,
	3553: 0x6C89,
	3554: 0x6C94,
	3555: 0x6C95,
	3556: 0x6C97,
	3557: 0x6C98,
	3558: 0x6C9C,
	3559: 0x6C9F,
	3560: 0x6CB0,
	3561: 0x6CB2,
	3562: 0x6CB4,
	3563: 0x6CC2,
	3564: 0x6CC6,
	3565: 0x6CCD,
	3566: 0x6CCF,
	3567: 0x6CD0,
	3568: 0x6CD1,
	3569: 0x6CD2,
	3570: 0x6CD4,
	3571: 0x6CD6,
	3572: 0x6CDA,
	3573: 0x6CDC,
	3574: 0x6CE0,
	3575: 0x6CE7,
	3576: 0x6CE9,
	3577: 0x6CEB,
	3578: 0x6CEC,
	3579: 0x6CEE,
	3580: 0x6CF2,
	3581: 0x6CF4,
	3582: 0x6D04,
	3583: 0x6D07,
	3584: 0x6D0A,
	3585: 0x6D0E,
	3586: 0x6D0F,
	3587: 0x6D11,
	3588: 0x6D13,
	3589: 0x6D1A,
	3590: 0x6D26,
	3591: 0x6D27,
	3592: 0x6D28,
	3593: 0x6C67,
	3594: 0x6D2E,
	3595: 0x6D2F,
	3596: 0x6D31,
	3597: 0x6D39,
	3598: 0x6D3C,
	3599: 0x6D3F,
	3600: 0x6D57,
	3601: 0x6D5E,
	3602: 0x6D5F,
	3603: 0x6D61,
	3604: 0x6D65,
	3605: 0x6D67,
	3606: 0x6D6F,
	3607: 0x6D70,
	3608: 0x6D7C,
	3609: 0x6D82,
	3610: 0x6D87,
	3611: 0x6D91,
	3612: 0x6D92,
	3613: 0x6D94,
	3614: 0x6D96,
	3615: 0x6D97,
	3616: 0x6D98,
	3617: 0x6DAA,
	3618: 0x6DAC,
	3619: 0x6DB4,
	3620: 0x6DB7,
	3621: 0x6DB9,
	3622: 0x6DBD,
	3623: 0x6DBF,
	3624: 0x6DC4,
	3625: 0x6DC8,
	3626: 0x6DCA,
	3627: 0x6DCE,
	3628: 0x6DCF,
	3629: 0x6DD6,
	3630: 0x6DDB,
	3631: 0x6DDD,
	3632: 0x6DDF,
	3633: 0x6DE0,
	3634: 0x6DE2,
	3635: 0x6DE5,
	3636: 0x6DE9,
	3637: 0x6DEF,
	3638: 0x6DF0,
	3639: 0x6DF4,
	3640: 0x6DF6,
	3641: 0x6DFC,
	3642: 0x6E00,
	3643: 0x6E04,
	3644: 0x6E1E,
	3645: 0x6E22,
	3646: 0x6E27,
	3647: 0x6E32,
	3648: 0x6E36,
	3649: 0x6E39,
	3650: 0x6E3B,
	3651: 0x6E3C,
	3652: 0x6E44,
	3653: 0x6E45,
	3654: 0x6E48,
	3655: 0x6E49,
	3656: 0x6E4B,
	3657: 0x6E4F,
	3658: 0x6E51,
	3659: 0x6E52,
	3660: 0x6E53,
	3661: 0x6E54,
	3662: 0x6E57,
	3663: 0x6E5C,
	3664: 0x6E5D,
	3665: 0x6E5E,
	3666: 0x6E62,
	3667: 0x6E63,
	3668: 0x6E68,
	3669: 0x6E73,
	3670: 0x6E7B,
	3671: 0x6E7D,
	3672: 0x6E8D,
	3673: 0x6E93,
	3674: 0x6E99,
	3675: 0x6EA0,
	3676: 0x6EA7,
	3677: 0x6EAD,
	3678: 0x6EAE,
	3679: 0x6EB1,
	3680: 0x6EB3,
	3681: 0x6EBB,
	3682: 0x6EBF,
	3683: 0x6EC0,
	3684: 0x6EC1,
	3685: 0x6EC3,
	3686: 0x6EC7,
	3687: 0x6EC8,
	3688: 0x6ECA,
	3689: 0x6ECD,
	3690: 0x6ECE,
	3691: 0x6ECF,
	3692: 0x6EEB,
	3693: 0x6EED,
	3694: 0x6EEE,
	3695: 0x6EF9,
	3696: 0x6EFB,
	3697: 0x6EFD,
	3698: 0x6F04,
	3699: 0x6F08,
	3700: 0x6F0A,
	3701: 0x6F0C,
	3702: 0x6F0D,
	3703: 0x6F16,
	3704: 0x6F18,
	3705: 0x6F1A,
	3706: 0x6F1B,
	3707: 0x6F26,
	3708: 0x6F29,
	3709: 0x6F2A,
	3710: 0x6F2F,
	3711: 0x6F30,
	3712: 0x6F33,
	3713: 0x6F36,
	3714: 0x6F3B,
	3715: 0x6F3C,
	3716: 0x6F2D,
	3717: 0x6F4F,
	3718: 0x6F51,
	3719: 0x6F52,
	3720: 0x6F53,
	3721: 0x6F57,
	3722: 0x6F59,
	3723: 0x6F5A,
	3724: 0x6F5D,
	3725: 0x6F5E,
	3726: 0x6F61,
	3727: 0x6F62,
	3728: 0x6F68,
	3729: 0x6F6C,
	3730: 0x6F7D,
	3731: 0x6F7E,
	3732: 0x6F83,
	3733: 0x6F87,
	3734: 0x6F88,
	3735: 0x6F8B,
	3736: 0x6F8C,
	3737: 0x6F8D,
	3738: 0x6F90,
	3739: 0x6F92,
	3740: 0x6F93,
	3741: 0x6F94,
	3742: 0x6F96,
	3743: 0x6F9A,
	3744: 0x6F9F,
	3745: 0x6FA0,
	3746: 0x6FA5,
	3747: 0x6FA6,
	3748: 0x6FA7,
	3749: 0x6FA8,
	3750: 0x6FAE,
	3751: 0x6FAF,
	3752: 0x6FB0,
	3753: 0x6FB5,
	3754: 0x6FB6,
	3755: 0x6FBC,
	3756: 0x6FC5,
	3757: 0x6FC7,
	3758: 0x6FC8,
	3759: 0x6FCA,
	3760: 0x6FDA,
	3761: 0x6FDE,
	3762: 0x6FE8,
	3763: 0x6FE9,
	3764: 0x6FF0,
	3765: 0x6FF5,
	3766: 0x6FF9,
	3767: 0x6FFC,
	3768: 0x6FFD,
	3769: 0x7000,
	3770: 0x7005,
	3771: 0x7006,
	3772: 0x7007,
	3773: 0x700D,
	3774: 0x7017,
	3775: 0x7020,
	3776: 0x7023,
	3777: 0x702F,
	3778: 0x7034,
	3779: 0x7037,
	3780: 0x7039,
	3781: 0x703C,
	3782: 0x7043,
	3783: 0x7044,
	3784: 0x7048,
	3785: 0x7049,
	3786: 0x704A,
	3787: 0x704B,
	3788: 0x7054,
	3789: 0x7055,
	3790: 0x705D,
	3791: 0x705E,
	3792: 0x704E,
	3793: 0x7064,
	3794: 0x7065,
	3795: 0x706C,
	3796: 0x706E,
	3797: 0x7075,
	3798: 0x7076,
	3799: 0x707E,
	3800: 0x7081,
	3801: 0x7085,
	3802: 0x7086,
	3803: 0x7094,
	3804: 0x7095,
	3805: 0x7096,
	3806: 0x7097,
	3807: 0x7098,
	3808: 0x709B,
	3809: 0x70A4,
	3810: 0x70AB,
	3811: 0x70B0,
	3812: 0x70B1,
	3813: 0x70B4,
	3814: 0x70B7,
	3815: 0x70CA,
	3816: 0x70D1,
	3817: 0x70D3,
	3818: 0x70D4,
	3819: 0x70D5,
	3820: 0x70D6,
	3821: 0x70D8,
	3822: 0x70DC,
	3823: 0x70E4,
	3824: 0x70FA,
	3825: 0x7103,
	3826: 0x7104,
	3827: 0x7105,
	3828: 0x7106,
	3829: 0x7107,
	3830: 0x710B,
	3831: 0x710C,
	3832: 0x710F,
	3833: 0x711E,
	3834: 0x7120,
	3835: 0x712B,
	3836: 0x712D,
	3837: 0x712F,
	3838: 0x7130,
	3839: 0x7131,
	3840: 0x7138,
	3841: 0x7141,
	3842: 0x7145,
	3843: 0x7146,
	3844: 0x7147,
	3845: 0x714A,
	3846: 0x714B,
	3847: 0x7150,
	3848: 0x7152,
	3849: 0x7157,
	3850: 0x715A,
	3851: 0x715C,
	3852: 0x715E,
	3853: 0x7160,
	3854: 0x7168,
	3855: 0x7179,
	3856: 0x7180,
	3857: 0x7185,
	3858: 0x7187,
	3859: 0x718C,
	3860: 0x7192,
	3861: 0x719A,
	3862: 0x719B,
	3863: 0x71A0,
	3864: 0x71A2,
	3865: 0x71AF,
	3866: 0x71B0,
	3867: 0x71B2,
	3868: 0x71B3,
	3869: 0x71BA,
	3870: 0x71BF,
	3871: 0x71C0,
	3872: 0x71C1,
	3873: 0x71C4,
	3874: 0x71CB,
	3875: 0x71CC,
	3876: 0x71D3,
	3877: 0x71D6,
	3878: 0x71D9,
	3879: 0x71DA,
	3880: 0x71DC,
	3881: 0x71F8,
	3882: 0x71FE,
	3883: 0x7200,
	3884: 0x7207,
	3885: 0x7208,
	3886: 0x7209,
	3887: 0x7213,
	3888: 0x7217,
	3889: 0x721A,
	3890: 0x721D,
	3891: 0x721F,
	3892: 0x7224,
	3893: 0x722B,
	3894: 0x722F,
	3895: 0x7234,
	3896: 0x7238,
	3897: 0x7239,
	3898: 0x7241,
	3899: 0x7242,
	3900: 0x7243,
	3901: 0x7245,
	3902: 0x724E,
	3903: 0x724F,
	3904: 0x7250,
	3905: 0x7253,
	3906: 0x7255,
	3907: 0x7256,
	3908: 0x725A,
	3909: 0x725C,
	3910: 0x725E,
	3911: 0x7260,
	3912: 0x7263,
	3913: 0x7268,
	3914: 0x726B,
	3915: 0x726E,
	3916: 0x726F,
	3917: 0x7271,
	3918: 0x7277,
	3919: 0x7278,
	3920: 0x727B,
	3921: 0x727C,
	3922: 0x727F,
	3923: 0x7284,
	3924: 0x7289,
	3925: 0x728D,
	3926: 0x728E,
	3927: 0x7293,
	3928: 0x729B,
	3929: 0x72A8,
	3930: 0x72AD,
	3931: 0x72AE,
	3932: 0x72B1,
	3933: 0x72B4,
	3934: 0x72BE,
	3935: 0x72C1,
	3936: 0x72C7,
	3937: 0x72C9,
	3938: 0x72CC,
	3939: 0x72D5,
	3940: 0x72D6,
	3941: 0x72D8,
	3942: 0x72DF,
	3943: 0x72E5,
	3944: 0x72F3,
	3945: 0x72F4,
	3946: 0x72FA,
	3947: 0x72FB,
	3948: 0x72FE,
	3949: 0x7302,
	3950: 0x7304,
	3951: 0x7305,
	3952: 0x7307,
	3953: 0x730B,
	3954: 0x730D,
	3955: 0x7312,
	3956: 0x7313,
	3957: 0x7318,
	3958: 0x7319,
	3959: 0x731E,
	3960: 0x7322,
	3961: 0x7324,
	3962: 0x7327,
	3963: 0x7328,
	3964: 0x732C,
	3965: 0x7331,
	3966: 0x7332,
	3967: 0x7335,
	3968: 0x733A,
	3969: 0x733B,
	3970: 0x733D,
	3971: 0x7343,
	3972: 0x734D,
	3973: 0x7350,
	3974: 0x7352,
	3975: 0x7356,
	3976: 0x7358,
	3977: 0x735D,
	3978: 0x735E,
	3979: 0x735F,
	3980: 0x7360,
	3981: 0x7366,
	3982: 0x7367,
	3983: 0x7369,
	3984: 0x736B,
	3985: 0x736C,
	3986: 0x736E,
	3987: 0x736F,
	3988: 0x7371,
	3989: 0x7377,
	3990: 0x7379,
	3991: 0x737C,
	3992: 0x7380,
	3993: 0x7381,
	3994: 0x7383,
	3995: 0x7385,
	3996: 0x7386,
	3997: 0x738E,
	3998: 0x7390,
	3999: 0x7393,
	4000: 0x7395,
	4001: 0x7397,
	4002: 0x7398,
	4003: 0x739C,
	4004: 0x739E,
	4005: 0x739F,
	4006: 0x73A0,
	4007: 0x73A2,
	4008: 0x73A5,
	4009: 0x73A6,
	4010: 0x73AA,
	4011: 0x73AB,
	4012: 0x73AD,
	4013: 0x73B5,
	4014: 0x73B7,
	4015: 0x73B9,
	4016: 0x73BC,
	4017: 0x73BD,
	4018: 0x73BF,
	4019: 0x73C5,
	4020: 0x73C6,
	4021: 0x73C9,
	4022: 0x73CB,
	4023: 0x73CC,
	4024: 0x73CF,
	4025: 0x73D2,
	4026: 0x73D3,
	4027: 0x73D6,
	4028: 0x73D9,
	4029: 0x73DD,
	4030: 0x73E1,
	4031: 0x73E3,
	4032: 0x73E6,
	4033: 0x73E7,
	4034: 0x73E9,
	4035: 0x73F4,
	4036: 0x73F5,
	4037: 0x73F7,
	4038: 0x73F9,
	4039: 0x73FA,
	4040: 0x73FB,
	4041: 0x73FD,
	4042: 0x73FF,
	4043: 0x7400,
	4044: 0x7401,
	4045: 0x7404,
	4046: 0x7407,
	4047: 0x740A,
	4048: 0x7411,
	4049: 0x741A,
	4050: 0x741B,
	4051: 0x7424,
	4052: 0x7426,
	4053: 0x7428,
	4054: 0x7429,
	4055: 0x742A,
	4056: 0x742B,
	4057: 0x742C,
	4058: 0x742D,
	4059: 0x742E,
	4060: 0x742F,
	4061: 0x7430,
	4062: 0x7431,
	4063: 0x7439,
	4064: 0x7440,
	4065: 0x7443,
	4066: 0x7444,
	4067: 0x7446,
	4068: 0x7447,
	4069: 0x744B,
	4070: 0x744D,
	4071: 0x7451,
	4072: 0x7452,
	4073: 0x7457,
	4074: 0x745D,
	4075: 0x7462,
	4076: 0x7466,
	4077: 0x7467,
	4078: 0x7468,
	4079: 0x746B,
	4080: 0x746D,
	4081: 0x746E,
	4082: 0x7471,
	4083: 0x7472,
	4084: 0x7480,
	4085: 0x7481,
	4086: 0x7485,
	4087: 0x7486,
	4088: 0x7487,
	4089: 0x7489,
	4090: 0x748F,
	4091: 0x7490,
	4092: 0x7491,
	4093: 0x7492,
	4094: 0x7498,
	4095: 0x7499,
	4096: 0x749A,
	4097: 0x749C,
	4098: 0x749F,
	4099: 0x74A0,
	4100: 0x74A1,
	4101: 0x74A3,
	4102: 0x74A6,
	4103: 0x74A8,
	4104: 0x74A9,
	4105: 0x74AA,
	4106: 0x74AB,
	4107: 0x74AE,
	4108: 0x74AF,
	4109: 0x74B1,
	4110: 0x74B2,
	4111: 0x74B5,
	4112: 0x74B9,
	4113: 0x74BB,
	4114: 0x74BF,
	4115: 0x74C8,
	4116: 0x74C9,
	4117: 0x74CC,
	4118: 0x74D0,
	4119: 0x74D3,
	4120: 0x74D8,
	4121: 0x74DA,
	4122: 0x74DB,
	4123: 0x74DE,
	4124: 0x74DF,
	4125: 0x74E4,
	4126: 0x74E8,
	4127: 0x74EA,
	4128: 0x74EB,
	4129: 0x74EF,
	4130: 0x74F4,
	4131: 0x74FA,
	4132: 0x74FB,
	4133: 0x74FC,
	4134: 0x74FF,
	4135: 0x7506,
	4136: 0x7512,
	4137: 0x7516,
	4138: 0x7517,
	4139: 0x7520,
	4140: 0x7521,
	4141: 0x7524,
	4142: 0x7527,
	4143: 0x7529,
	4144: 0x752A,
	4145: 0x752F,
	4146: 0x7536,
	4147: 0x7539,
	4148: 0x753D,
	4149: 0x753E,
	4150: 0x753F,
	4151: 0x7540,
	4152: 0x7543,
	4153: 0x7547,
	4154: 0x7548,
	4155: 0x754E,
	4156: 0x7550,
	4157: 0x7552,
	4158: 0x7557,
	4159: 0x755E,
	4160: 0x755F,
	4161: 0x7561,
	4162: 0x756F,
	4163: 0x7571,
	4164: 0x7579,
	4165: 0x757A,
	4166: 0x757B,
	4167: 0x757C,
	4168: 0x757D,
	4169: 0x757E,
	4170: 0x7581,
	4171: 0x7585,
	4172: 0x7590,
	4173: 0x7592,
	4174: 0x7593,
	4175: 0x7595,
	4176: 0x7599,
	4177: 0x759C,
	4178: 0x75A2,
	4179: 0x75A4,
	4180: 0x75B4,
	4181: 0x75BA,
	4182: 0x75BF,
	4183: 0x75C0,
	4184: 0x75C1,
	4185: 0x75C4,
	4186: 0x75C6,
	4187: 0x75CC,
	4188: 0x75CE,
	4189: 0x75CF,
	4190: 0x75D7,
	4191: 0x75DC,
	4192: 0x75DF,
	4193: 0x75E0,
	4194: 0x75E1,
	4195: 0x75E4,
	4196: 0x75E7,
	4197: 0x75EC,
	4198: 0x75EE,
	4199: 0x75EF,
	4200: 0x75F1,
	4201: 0x75F9,
	4202: 0x7600,
	4203: 0x7602,
	4204: 0x7603,
	4205: 0x7604,
	4206: 0x7607,
	4207: 0x7608,
	4208: 0x760A,
	4209: 0x760C,
	4210: 0x760F,
	4211: 0x7612,
	4212: 0x7613,
	4213: 0x7615,
	4214: 0x7616,
	4215: 0x7619,
	4216: 0x761B,
	4217: 0x761C,
	4218: 0x761D,
	4219: 0x761E,
	4220: 0x7623,
	4221: 0x7625,
	4222: 0x7626,
	4223: 0x7629,
	4224: 0x762D,
	4225: 0x7632,
	4226: 0x7633,
	4227: 0x7635,
	4228: 0x7638,
	4229: 0x7639,
	4230: 0x763A,
	4231: 0x763C,
	4232: 0x764A,
	4233: 0x7640,
	4234: 0x7641,
	4235: 0x7643,
	4236: 0x7644,
	4237: 0x7645,
	4238: 0x7649,
	4239: 0x764B,
	4240: 0x7655,
	4241: 0x7659,
	4242: 0x765F,
	4243: 0x7664,
	4244: 0x7665,
	4245: 0x766D,
	4246: 0x766E,
	4247: 0x766F,
	4248: 0x7671,
	4249: 0x7674,
	4250: 0x7681,
	4251: 0x7685,
	4252: 0x768C,
	4253: 0x768D,
	4254: 0x7695,
	4255: 0x769B,
	4256: 0x769C,
	4257: 0x769D,
	4258: 0x769F,
	4259: 0x76A0,
	4260: 0x76A2,
	4261: 0x76A3,
	4262: 0x76A4,
	4263: 0x76A5,
	4264: 0x76A6,
	4265: 0x76A7,
	4266: 0x76A8,
	4267: 0x76AA,
	4268: 0x76AD,
	4269: 0x76BD,
	4270: 0x76C1,
	4271: 0x76C5,
	4272: 0x76C9,
	4273: 0x76CB,
	4274: 0x76CC,
	4275: 0x76CE,
	4276: 0x76D4,
	4277: 0x76D9,
	4278: 0x76E0,
	4279: 0x76E6,
	4280: 0x76E8,
	4281: 0x76EC,
	4282: 0x76F0,
	4283: 0x76F1,
	4284: 0x76F6,
	4285: 0x76F9,
	4286: 0x76FC,
	4287: 0x7700,
	4288: 0x7706,
	4289: 0x770A,
	4290: 0x770E,
	4291: 0x7712,
	4292: 0x7714,
	4293: 0x7715,
	4294: 0x7717,
	4295: 0x7719,
	4296: 0x771A,
	4297: 0x771C,
	4298: 0x7722,
	4299: 0x7728,
	4300: 0x772D,
	4301: 0x772E,
	4302: 0x772F,
	4303: 0x7734,
	4304: 0x7735,
	4305: 0x7736,
	4306: 0x7739,
	4307: 0x773D,
	4308: 0x773E,
	4309: 0x7742,
	4310: 0x7745,
	4311: 0x7746,
	4312: 0x774A,
	4313: 0x774D,
	4314: 0x774E,
	4315: 0x774F,
	4316: 0x7752,
	4317: 0x7756,
	4318: 0x7757,
	4319: 0x775C,
	4320: 0x775E,
	4321: 0x775F,
	4322: 0x7760,
	4323: 0x7762,
	4324: 0x7764,
	4325: 0x7767,
	4326: 0x776A,
	4327: 0x776C,
	4328: 0x7770,
	4329: 0x7772,
	4330: 0x7773,
	4331: 0x7774,
	4332: 0x777A,
	4333: 0x777D,
	4334: 0x7780,
	4335: 0x7784,
	4336: 0x778C,
	4337: 0x778D,
	4338: 0x7794,
	4339: 0x7795,
	4340: 0x7796,
	4341: 0x779A,
	4342: 0x779F,
	4343: 0x77A2,
	4344: 0x77A7,
	4345: 0x77AA,
	4346: 0x77AE,
	4347: 0x77AF,
	4348: 0x77B1,
	4349: 0x77B5,
	4350: 0x77BE,
	4351: 0x77C3,
	4352: 0x77C9,
	4353: 0x77D1,
	4354: 0x77D2,
	4355: 0x77D5,
	4356: 0x77D9,
	4357: 0x77DE,
	4358: 0x77DF,
	4359: 0x77E0,
	4360: 0x77E4,
	4361: 0x77E6,
	4362: 0x77EA,
	4363: 0x77EC,
	4364: 0x77F0,
	4365: 0x77F1,
	4366: 0x77F4,
	4367: 0x77F8,
	4368: 0x77FB,
	4369: 0x7805,
	4370: 0x7806,
	4371: 0x7809,
	4372: 0x780D,
	4373: 0x780E,
	4374: 0x7811,
	4375: 0x781D,
	4376: 0x7821,
	4377: 0x7822,
	4378: 0x7823,
	4379: 0x782D,
	4380: 0x782E,
	4381: 0x7830,
	4382: 0x7835,
	4383: 0x7837,
	4384: 0x7843,
	4385: 0x7844,
	4386: 0x7847,
	4387: 0x7848,
	4388: 0x784C,
	4389: 0x784E,
	4390: 0x7852,
	4391: 0x785C,
	4392: 0x785E,
	4393: 0x7860,
	4394: 0x7861,
	4395: 0x7863,
	4396: 0x7864,
	4397: 0x7868,
	4398: 0x786A,
	4399: 0x786E,
	4400: 0x787A,
	4401: 0x787E,
	4402: 0x788A,
	4403: 0x788F,
	4404: 0x7894,
	4405: 0x7898,
	4406: 0x78A1,
	4407: 0x789D,
	4408: 0x789E,
	4409: 0x789F,
	4410: 0x78A4,
	4411: 0x78A8,
	4412: 0x78AC,
	4413: 0x78AD,
	4414: 0x78B0,
	4415: 0x78B1,
	4416: 0x78B2,
	4417: 0x78B3,
	4418: 0x78BB,
	4419: 0x78BD,
	4420: 0x78BF,
	4421: 0x78C7,
	4422: 0x78C8,
	4423: 0x78C9,
	4424: 0x78CC,
	4425: 0x78CE,
	4426: 0x78D2,
	4427: 0x78D3,
	4428: 0x78D5,
	4429: 0x78D6,
	4430: 0x78E4,
	4431: 0x78DB,
	4432: 0x78DF,
	4433: 0x78E0,
	4434: 0x78E1,
	4435: 0x78E6,
	4436: 0x78EA,
	4437: 0x78F2,
	4438: 0x78F3,
	4439: 0x7900,
	4440: 0x78F6,
	4441: 0x78F7,
	4442: 0x78FA,
	4443: 0x78FB,
	4444: 0x78FF,
	4445: 0x7906,
	4446: 0x790C,
	4447: 0x7910,
	4448: 0x791A,
	4449: 0x791C,
	4450: 0x791E,
	4451: 0x791F,
	4452: 0x7920,
	4453: 0x7925,
	4454: 0x7927,
	4455: 0x7929,
	4456: 0x792D,
	4457: 0x7931,
	4458: 0x7934,
	4459: 0x7935,
	4460: 0x793B,
	4461: 0x793D,
	4462: 0x793F,
	4463: 0x7944,
	4464: 0x7945,
	4465: 0x7946,
	4466: 0x794A,
	4467: 0x794B,
	4468: 0x794F,
	4469: 0x7951,
	4470: 0x7954,
	4471: 0x7958,
	4472: 0x795B,
	4473: 0x795C,
	4474: 0x7967,
	4475: 0x7969,
	4476: 0x796B,
	4477: 0x7972,
	4478: 0x7979,
	4479: 0x797B,
	4480: 0x797C,
	4481: 0x797E,
	4482: 0x798B,
	4483: 0x798C,
	4484: 0x7991,
	4485: 0x7993,
	4486: 0x7994,
	4487: 0x7995,
	4488: 0x7996,
	4489: 0x7998,
	4490: 0x799B,
	4491: 0x799C,
	4492: 0x79A1,
	4493: 0x79A8,
	4494: 0x79A9,
	4495: 0x79AB,
	4496: 0x79AF,
	4497: 0x79B1,
	4498: 0x79B4,
	4499: 0x79B8,
	4500: 0x79BB,
	4501: 0x79C2,
	4502: 0x79C4,
	4503: 0x79C7,
	4504: 0x79C8,
	4505: 0x79CA,
	4506: 0x79CF,
	4507: 0x79D4,
	4508: 0x79D6,
	4509: 0x79DA,
	4510: 0x79DD,
	4511: 0x79DE,
	4512: 0x79E0,
	4513: 0x79E2,
	4514: 0x79E5,
	4515: 0x79EA,
	4516: 0x79EB,
	4517: 0x79ED,
	4518: 0x79F1,
	4519: 0x79F8,
	4520: 0x79FC,
	4521: 0x7A02,
	4522: 0x7A03,
	4523: 0x7A07,
	4524: 0x7A09,
	4525: 0x7A0A,
	4526: 0x7A0C,
	4527: 0x7A11,
	4528: 0x7A15,
	4529: 0x7A1B,
	4530: 0x7A1E,
	4531: 0x7A21,
	4532: 0x7A27,
	4533: 0x7A2B,
	4534: 0x7A2D,
	4535: 0x7A2F,
	4536: 0x7A30,
	4537: 0x7A34,
	4538: 0x7A35,
	4539: 0x7A38,
	4540: 0x7A39,
	4541: 0x7A3A,
	4542: 0x7A44,
	4543: 0x7A45,
	4544: 0x7A47,
	4545: 0x7A48,
	4546: 0x7A4C,
	4547: 0x7A55,
	4548: 0x7A56,
	4549: 0x7A59,
	4550: 0x7A5C,
	4551: 0x7A5D,
	4552: 0x7A5F,
	4553: 0x7A60,
	4554: 0x7A65,
	4555: 0x7A67,
	4556: 0x7A6A,
	4557: 0x7A6D,
	4558: 0x7A75,
	4559: 0x7A78,
	4560: 0x7A7E,
	4561: 0x7A80,
	4562: 0x7A82,
	4563: 0x7A85,
	4564: 0x7A86,
	4565: 0x7A8A,
	4566: 0x7A8B,
	4567: 0x7A90,
	4568: 0x7A91,
	4569: 0x7A94,
	4570: 0x7A9E,
	4571: 0x7AA0,
	4572: 0x7AA3,
	4573: 0x7AAC,
	4574: 0x7AB3,
	4575: 0x7AB5,
	4576: 0x7AB9,
	4577: 0x7ABB,
	4578: 0x7ABC,
	4579: 0x7AC6,
	4580: 0x7AC9,
	4581: 0x7ACC,
	4582: 0x7ACE,
	4583: 0x7AD1,
	4584: 0x7ADB,
	4585: 0x7AE8,
	4586: 0x7AE9,
	4587: 0x7AEB,
	4588: 0x7AEC,
	4589: 0x7AF1,
	4590: 0x7AF4,
	4591: 0x7AFB,
	4592: 0x7AFD,
	4593: 0x7AFE,
	4594: 0x7B07,
	4595: 0x7B14,
	4596: 0x7B1F,
	4597: 0x7B23,
	4598: 0x7B27,
	4599: 0x7B29,
	4600: 0x7B2A,
	4601: 0x7B2B,
	4602: 0x7B2D,
	4603: 0x7B2E,
	4604: 0x7B2F,
	4605: 0x7B30,
	4606: 0x7B31,
	4607: 0x7B34,
	4608: 0x7B3D,
	4609: 0x7B3F,
	4610: 0x7B40,
	4611: 0x7B41,
	4612: 0x7B47,
	4613: 0x7B4E,
	4614: 0x7B55,
	4615: 0x7B60,
	4616: 0x7B64,
	4617: 0x7B66,
	4618: 0x7B69,
	4619: 0x7B6A,
	4620: 0x7B6D,
	4621: 0x7B6F,
	4622: 0x7B72,
	4623: 0x7B73,
	4624: 0x7B77,
	4625: 0x7B84,
	4626: 0x7B89,
	4627: 0x7B8E,
	4628: 0x7B90,
	4629: 0x7B91,
	4630: 0x7B96,
	4631: 0x7B9B,
	4632: 0x7B9E,
	4633: 0x7BA0,
	4634: 0x7BA5,
	4635: 0x7BAC,
	4636: 0x7BAF,
	4637: 0x7BB0,
	4638: 0x7BB2,
	4639: 0x7BB5,
	4640: 0x7BB6,
	4641: 0x7BBA,
	4642: 0x7BBB,
	4643: 0x7BBC,
	4644: 0x7BBD,
	4645: 0x7BC2,
	4646: 0x7BC5,
	4647: 0x7BC8,
	4648: 0x7BCA,
	4649: 0x7BD4,
	4650: 0x7BD6,
	4651: 0x7BD7,
	4652: 0x7BD9,
	4653: 0x7BDA,
	4654: 0x7BDB,
	4655: 0x7BE8,
	4656: 0x7BEA,
	4657: 0x7BF2,
	4658: 0x7BF4,
	4659: 0x7BF5,
	4660: 0x7BF8,
	4661: 0x7BF9,
	4662: 0x7BFA,
	4663: 0x7BFC,
	4664: 0x7BFE,
	4665: 0x7C01,
	4666: 0x7C02,
	4667: 0x7C03,
	4668: 0x7C04,
	4669: 0x7C06,
	4670: 0x7C09,
	4671: 0x7C0B,
	4672: 0x7C0C,
	4673: 0x7C0E,
	4674: 0x7C0F,
	4675: 0x7C19,
	4676: 0x7C1B,
	4677: 0x7C20,
	4678: 0x7C25,
	4679: 0x7C26,
	4680: 0x7C28,
	4681: 0x7C2C,
	4682: 0x7C31,
	4683: 0x7C33,
	4684: 0x7C34,
	4685: 0x7C36,
	4686: 0x7C39,
	4687: 0x7C3A,
	4688: 0x7C46,
	4689: 0x7C4A,
	4690: 0x7C55,
	4691: 0x7C51,
	4692: 0x7C52,
	4693: 0x7C53,
	4694: 0x7C59,
	4695: 0x7C5A,
	4696: 0x7C5B,
	4697: 0x7C5C,
	4698: 0x7C5D,
	4699: 0x7C5E,
	4700: 0x7C61,
	4701: 0x7C63,
	4702: 0x7C67,
	4703: 0x7C69,
	4704: 0x7C6D,
	4705: 0x7C6E,
	4706: 0x7C70,
	4707: 0x7C72,
	4708: 0x7C79,
	4709: 0x7C7C,
	4710: 0x7C7D,
	4711: 0x7C86,
	4712: 0x7C87,
	4713: 0x7C8F,
	4714: 0x7C94,
	4715: 0x7C9E,
	4716: 0x7CA0,
	4717: 0x7CA6,
	4718: 0x7CB0,
	4719: 0x7CB6,
	4720: 0x7CB7,
	4721: 0x7CBA,
	4722: 0x7CBB,
	4723: 0x7CBC,
	4724: 0x7CBF,
	4725: 0x7CC4,
	4726: 0x7CC7,
	4727: 0x7CC8,
	4728: 0x7CC9,
	4729: 0x7CCD,
	4730: 0x7CCF,
	4731: 0x7CD3,
	4732: 0x7CD4,
	4733: 0x7CD5,
	4734: 0x7CD7,
	4735: 0x7CD9,
	4736: 0x7CDA,
	4737: 0x7CDD,
	4738: 0x7CE6,
	4739: 0x7CE9,
	4740: 0x7CEB,
	4741: 0x7CF5,
	4742: 0x7D03,
	4743: 0x7D07,
	4744: 0x7D08,
	4745: 0x7D09,
	4746: 0x7D0F,
	4747: 0x7D11,
	4748: 0x7D12,
	4749: 0x7D13,
	4750: 0x7D16,
	4751: 0x7D1D,
	4752: 0x7D1E,
	4753: 0x7D23,
	4754: 0x7D26,
	4755: 0x7D2A,
	4756: 0x7D2D,
	4757: 0x7D31,
	4758: 0x7D3C,
	4759: 0x7D3D,
	4760: 0x7D3E,
	4761: 0x7D40,
	4762: 0x7D41,
	4763: 0x7D47,
	4764: 0x7D48,
	4765: 0x7D4D,
	4766: 0x7D51,
	4767: 0x7D53,
	4768: 0x7D57,
	4769: 0x7D59,
	4770: 0x7D5A,
	4771: 0x7D5C,
	4772: 0x7D5D,
	4773: 0x7D65,
	4774: 0x7D67,
	4775: 0x7D6A,
	4776: 0x7D70,
	4777: 0x7D78,
	4778: 0x7D7A,
	4779: 0x7D7B,
	4780: 0x7D7F,
	4781: 0x7D81,
	4782: 0x7D82,
	4783: 0x7D83,
	4784: 0x7D85,
	4785: 0x7D86,
	4786: 0x7D88,
	4787: 0x7D8B,
	4788: 0x7D8C,
	4789: 0x7D8D,
	4790: 0x7D91,
	4791: 0x7D96,
	4792: 0x7D97,
	4793: 0x7D9D,
	4794: 0x7D9E,
	4795: 0x7DA6,
	4796: 0x7DA7,
	4797: 0x7DAA,
	4798: 0x7DB3,
	4799: 0x7DB6,
	4800: 0x7DB7,
	4801: 0x7DB9,
	4802: 0x7DC2,
	4803: 0x7DC3,
	4804: 0x7DC4,
	4805: 0x7DC5,
	4806: 0x7DC6,
	4807: 0x7DCC,
	4808: 0x7DCD,
	4809: 0x7DCE,
	4810: 0x7DD7,
	4811: 0x7DD9,
	4812: 0x7E00,
	4813: 0x7DE2,
	4814: 0x7DE5,
	4815: 0x7DE6,
	4816: 0x7DEA,
	4817: 0x7DEB,
	4818: 0x7DED,
	4819: 0x7DF1,
	4820: 0x7DF5,
	4821: 0x7DF6,
	4822: 0x7DF9,
	4823: 0x7DFA,
	4824: 0x7E08,
	4825: 0x7E10,
	4826: 0x7E11,
	4827: 0x7E15,
	4828: 0x7E17,
	4829: 0x7E1C,
	4830: 0x7E1D,
	4831: 0x7E20,
	4832: 0x7E27,
	4833: 0x7E28,
	4834: 0x7E2C,
	4835: 0x7E2D,
	4836: 0x7E2F,
	4837: 0x7E33,
	4838: 0x7E36,
	4839: 0x7E3F,
	4840: 0x7E44,
	4841: 0x7E45,
	4842: 0x7E47,
	4843: 0x7E4E,
	4844: 0x7E50,
	4845: 0x7E52,
	4846: 0x7E58,
	4847: 0x7E5F,
	4848: 0x7E61,
	4849: 0x7E62,
	4850: 0x7E65,
	4851: 0x7E6B,
	4852: 0x7E6E,
	4853: 0x7E6F,
	4854: 0x7E73,
	4855: 0x7E78,
	4856: 0x7E7E,
	4857: 0x7E81,
	4858: 0x7E86,
	4859: 0x7E87,
	4860: 0x7E8A,
	4861: 0x7E8D,
	4862: 0x7E91,
	4863: 0x7E95,
	4864: 0x7E98,
	4865: 0x7E9A,
	4866: 0x7E9D,
	4867: 0x7E9E,
	4868: 0x7F3C,
	4869: 0x7F3B,
	4870: 0x7F3D,
	4871: 0x7F3E,
	4872: 0x7F3F,
	4873: 0x7F43,
	4874: 0x7F44,
	4875: 0x7F47,
	4876: 0x7F4F,
	4877: 0x7F52,
	4878: 0x7F53,
	4879: 0x7F5B,
	4880: 0x7F5C,
	4881: 0x7F5D,
	4882: 0x7F61,
	4883: 0x7F63,
	4884: 0x7F64,
	4885: 0x7F65,
	4886: 0x7F66,
	4887: 0x7F6D,
	4888: 0x7F71,
	4889: 0x7F7D,
	4890: 0x7F7E,
	4891: 0x7F7F,
	4892: 0x7F80,
	4893: 0x7F8B,
	4894: 0x7F8D,
	4895: 0x7F8F,
	4896: 0x7F90,
	4897: 0x7F91,
	4898: 0x7F96,
	4899: 0x7F97,
	4900: 0x7F9C,
	4901: 0x7FA1,
	4902: 0x7FA2,
	4903: 0x7FA6,
	4904: 0x7FAA,
	4905: 0x7FAD,
	4906: 0x7FB4,
	4907: 0x7FBC,
	4908: 0x7FBF,
	4909: 0x7FC0,
	4910: 0x7FC3,
	4911: 0x7FC8,
	4912: 0x7FCE,
	4913: 0x7FCF,
	4914: 0x7FDB,
	4915: 0x7FDF,
	4916: 0x7FE3,
	4917: 0x7FE5,
	4918: 0x7FE8,
	4919: 0x7FEC,
	4920: 0x7FEE,
	4921: 0x7FEF,
	4922: 0x7FF2,
	4923: 0x7FFA,
	4924: 0x7FFD,
	4925: 0x7FFE,
	4926: 0x7FFF,
	4927: 0x8007,
	4928: 0x8008,
	4929: 0x800A,
	4930: 0x800D,
	4931: 0x800E,
	4932: 0x800F,
	4933: 0x8011,
	4934: 0x8013,
	4935: 0x8014,
	4936: 0x8016,
	4937: 0x801D,
	4938: 0x801E,
	4939: 0x801F,
	4940: 0x8020,
	4941: 0x8024,
	4942: 0x8026,
	4943: 0x802C,
	4944: 0x802E,
	4945: 0x8030,
	4946: 0x8034,
	4947: 0x8035,
	4948: 0x8037,
	4949: 0x8039,
	4950: 0x803A,
	4951: 0x803C,
	4952: 0x803E,
	4953: 0x8040,
	4954: 0x8044,
	4955: 0x8060,
	4956: 0x8064,
	4957: 0x8066,
	4958: 0x806D,
	4959: 0x8071,
	4960: 0x8075,
	4961: 0x8081,
	4962: 0x8088,
	4963: 0x808E,
	4964: 0x809C,
	4965: 0x809E,
	4966: 0x80A6,
	4967: 0x80A7,
	4968: 0x80AB,
	4969: 0x80B8,
	4970: 0x80B9,
	4971: 0x80C8,
	4972: 0x80CD,
	4973: 0x80CF,
	4974: 0x80D2,
	4975: 0x80D4,
	4976: 0x80D5,
	4977: 0x80D7,
	4978: 0x80D8,
	4979: 0x80E0,
	4980: 0x80ED,
	4981: 0x80EE,
	4982: 0x80F0,
	4983: 0x80F2,
	4984: 0x80F3,
	4985: 0x80F6,
	4986: 0x80F9,
	4987: 0x80FA,
	4988: 0x80FE,
	4989: 0x8103,
	4990: 0x810B,
	4991: 0x8116,
	4992: 0x8117,
	4993: 0x8118,
	4994: 0x811C,
	4995: 0x811E,
	4996: 0x8120,
	4997: 0x8124,
	4998: 0x8127,
	4999: 0x812C,
	5000: 0x8130,
	5001: 0x8135,
	5002: 0x813A,
	5003: 0x813C,
	5004: 0x8145,
	5005: 0x8147,
	5006: 0x814A,
	5007: 0x814C,
	5008: 0x8152,
	5009: 0x8157,
	5010: 0x8160,
	5011: 0x8161,
	5012: 0x8167,
	5013: 0x8168,
	5014: 0x8169,
	5015: 0x816D,
	5016: 0x816F,
	5017: 0x8177,
	5018: 0x8181,
	5019: 0x8190,
	5020: 0x8184,
	5021: 0x8185,
	5022: 0x8186,
	5023: 0x818B,
	5024: 0x818E,
	5025: 0x8196,
	5026: 0x8198,
	5027: 0x819B,
	5028: 0x819E,
	5029: 0x81A2,
	5030: 0x81AE,
	5031: 0x81B2,
	5032: 0x81B4,
	5033: 0x81BB,
	5034: 0x81CB,
	5035: 0x81C3,
	5036: 0x81C5,
	5037: 0x81CA,
	5038: 0x81CE,
	5039: 0x81CF,
	5040: 0x81D5,
	5041: 0x81D7,
	5042: 0x81DB,
	5043: 0x81DD,
	5044: 0x81DE,
	5045: 0x81E1,
	5046: 0x81E4,
	5047: 0x81EB,
	5048: 0x81EC,
	5049: 0x81F0,
	5050: 0x81F1,
	5051: 0x81F2,
	5052: 0x81F5,
	5053: 0x81F6,
	5054: 0x81F8,
	5055: 0x81F9,
	5056: 0x81FD,
	5057: 0x81FF,
	5058: 0x8200,
	5059: 0x8203,
	5060: 0x820F,
	5061: 0x8213,
	5062: 0x8214,
	5063: 0x8219,
	5064: 0x821A,
	5065: 0x821D,
	5066: 0x8221,
	5067: 0x8222,
	5068: 0x8228,
	5069: 0x8232,
	5070: 0x8234,
	5071: 0x823A,
	5072: 0x8243,
	5073: 0x8244,
	5074: 0x8245,
	5075: 0x8246,
	5076: 0x824B,
	5077: 0x824E,
	5078: 0x824F,
	5079: 0x8251,
	5080: 0x8256,
	5081: 0x825C,
	5082: 0x8260,
	5083: 0x8263,
	5084: 0x8267,
	5085: 0x826D,
	5086: 0x8274,
	5087: 0x827B,
	5088: 0x827D,
	5089: 0x827F,
	5090: 0x8280,
	5091: 0x8281,
	5092: 0x8283,
	5093: 0x8284,
	5094: 0x8287,
	5095: 0x8289,
	5096: 0x828A,
	5097: 0x828E,
	5098: 0x8291,
	5099: 0x8294,
	5100: 0x8296,
	5101: 0x8298,
	5102: 0x829A,
	5103: 0x829B,
	5104: 0x82A0,
	5105: 0x82A1,
	5106: 0x82A3,
	5107: 0x82A4,
	5108: 0x82A7,
	5109: 0x82A8,
	5110: 0x82A9,
	5111: 0x82AA,
	5112: 0x82AE,
	5113: 0x82B0,
	5114: 0x82B2,
	5115: 0x82B4,
	5116: 0x82B7,
	5117: 0x82BA,
	5118: 0x82BC,
	5119: 0x82BE,
	5120: 0x82BF,
	5121: 0x82C6,
	5122: 0x82D0,
	5123: 0x82D5,
	5124: 0x82DA,
	5125: 0x82E0,
	5126: 0x82E2,
	5127: 0x82E4,
	5128: 0x82E8,
	5129: 0x82EA,
	5130: 0x82ED,
	5131: 0x82EF,
	5132: 0x82F6,
	5133: 0x82F7,
	5134: 0x82FD,
	5135: 0x82FE,
	5136: 0x8300,
	5137: 0x8301,
	5138: 0x8307,
	5139: 0x8308,
	5140: 0x830A,
	5141: 0x830B,
	5142: 0x8354,
	5143: 0x831B,
	5144: 0x831D,
	5145: 0x831E,
	5146: 0x831F,
	5147: 0x8321,
	5148: 0x8322,
	5149: 0x832C,
	5150: 0x832D,
	5151: 0x832E,
	5152: 0x8330,
	5153: 0x8333,
	5154: 0x8337,
	5155: 0x833A,
	5156: 0x833C,
	5157: 0x833D,
	5158: 0x8342,
	5159: 0x8343,
	5160: 0x8344,
	5161: 0x8347,
	5162: 0x834D,
	5163: 0x834E,
	5164: 0x8351,
	5165: 0x8355,
	5166: 0x8356,
	5167: 0x8357,
	5168: 0x8370,
	5169: 0x8378,
	5170: 0x837D,
	5171: 0x837F,
	5172: 0x8380,
	5173: 0x8382,
	5174: 0x8384,
	5175: 0x8386,
	5176: 0x838D,
	5177: 0x8392,
	5178: 0x8394,
	5179: 0x8395,
	5180: 0x8398,
	5181: 0x8399,
	5182: 0x839B,
	5183: 0x839C,
	5184: 0x839D,
	5185: 0x83A6,
	5186: 0x83A7,
	5187: 0x83A9,
	5188: 0x83AC,
	5189: 0x83BE,
	5190: 0x83BF,
	5191: 0x83C0,
	5192: 0x83C7,
	5193: 0x83C9,
	5194: 0x83CF,
	5195: 0x83D0,
	5196: 0x83D1,
	5197: 0x83D4,
	5198: 0x83DD,
	5199: 0x8353,
	5200: 0x83E8,
	5201: 0x83EA,
	5202: 0x83F6,
	5203: 0x83F8,
	5204: 0x83F9,
	5205: 0x83FC,
	5206: 0x8401,
	5207: 0x8406,
	5208: 0x840A,
	5209: 0x840F,
	5210: 0x8411,
	5211: 0x8415,
	5212: 0x8419,
	5213: 0x83AD,
	5214: 0x842F,
	5215: 0x8439,
	5216: 0x8445,
	5217: 0x8447,
	5218: 0x8448,
	5219: 0x844A,
	5220: 0x844D,
	5221: 0x844F,
	5222: 0x8451,
	5223: 0x8452,
	5224: 0x8456,
	5225: 0x8458,
	5226: 0x8459,
	5227: 0x845A,
	5228: 0x845C,
	5229: 0x8460,
	5230: 0x8464,
	5231: 0x8465,
	5232: 0x8467,
	5233: 0x846A,
	5234: 0x8470,
	5235: 0x8473,
	5236: 0x8474,
	5237: 0x8476,
	5238: 0x8478,
	5239: 0x847C,
	5240: 0x847D,
	5241: 0x8481,
	5242: 0x8485,
	5243: 0x8492,
	5244: 0x8493,
	5245: 0x8495,
	5246: 0x849E,
	5247: 0x84A6,
	5248: 0x84A8,
	5249: 0x84A9,
	5250: 0x84AA,
	5251: 0x84AF,
	5252: 0x84B1,
	5253: 0x84B4,
	5254: 0x84BA,
	5255: 0x84BD,
	5256: 0x84BE,
	5257: 0x84C0,
	5258: 0x84C2,
	5259: 0x84C7,
	5260: 0x84C8,
	5261: 0x84CC,
	5262: 0x84CF,
	5263: 0x84D3,
	5264: 0x84DC,
	5265: 0x84E7,
	5266: 0x84EA,
	5267: 0x84EF,
	5268: 0x84F0,
	5269: 0x84F1,
	5270: 0x84F2,
	5271: 0x84F7,
	5272: 0x8532,
	5273: 0x84FA,
	5274: 0x84FB,
	5275: 0x84FD,
	5276: 0x8502,
	5277: 0x8503,
	5278: 0x8507,
	5279: 0x850C,
	5280: 0x850E,
	5281: 0x8510,
	5282: 0x851C,
	5283: 0x851E,
	5284: 0x8522,
	5285: 0x8523,
	5286: 0x8524,
	5287: 0x8525,
	5288: 0x8527,
	5289: 0x852A,
	5290: 0x852B,
	5291: 0x852F,
	5292: 0x8533,
	5293: 0x8534,
	5294: 0x8536,
	5295: 0x853F,
	5296: 0x8546,
	5297: 0x854F,
	5298: 0x8550,
	5299: 0x8551,
	5300: 0x8552,
	5301: 0x8553,
	5302: 0x8556,
	5303: 0x8559,
	5304: 0x855C,
	5305: 0x855D,
	5306: 0x855E,
	5307: 0x855F,
	5308: 0x8560,
	5309: 0x8561,
	5310: 0x8562,
	5311: 0x8564,
	5312: 0x856B,
	5313: 0x856F,
	5314: 0x8579,
	5315: 0x857A,
	5316: 0x857B,
	5317: 0x857D,
	5318: 0x857F,
	5319: 0x8581,
	5320: 0x8585,
	5321: 0x8586,
	5322: 0x8589,
	5323: 0x858B,
	5324: 0x858C,
	5325: 0x858F,
	5326: 0x8593,
	5327: 0x8598,
	5328: 0x859D,
	5329: 0x859F,
	5330: 0x85A0,
	5331: 0x85A2,
	5332: 0x85A5,
	5333: 0x85A7,
	5334: 0x85B4,
	5335: 0x85B6,
	5336: 0x85B7,
	5337: 0x85B8,
	5338: 0x85BC,
	5339: 0x85BD,
	5340: 0x85BE,
	5341: 0x85BF,
	5342: 0x85C2,
	5343: 0x85C7,
	5344: 0x85CA,
	5345: 0x85CB,
	5346: 0x85CE,
	5347: 0x85AD,
	5348: 0x85D8,
	5349: 0x85DA,
	5350: 0x85DF,
	5351: 0x85E0,
	5352: 0x85E6,
	5353: 0x85E8,
	5354: 0x85ED,
	5355: 0x85F3,
	5356: 0x85F6,
	5357: 0x85FC,
	5358: 0x85FF,
	5359: 0x8600,
	5360: 0x8604,
	5361: 0x8605,
	5362: 0x860D,
	5363: 0x860E,
	5364: 0x8610,
	5365: 0x8611,
	5366: 0x8612,
	5367: 0x8618,
	5368: 0x8619,
	5369: 0x861B,
	5370: 0x861E,
	5371: 0x8621,
	5372: 0x8627,
	5373: 0x8629,
	5374: 0x8636,
	5375: 0x8638,
	5376: 0x863A,
	5377: 0x863C,
	5378: 0x863D,
	5379: 0x8640,
	5380: 0x8642,
	5381: 0x8646,
	5382: 0x8652,
	5383: 0x8653,
	5384: 0x8656,
	5385: 0x8657,
	5386: 0x8658,
	5387: 0x8659,
	5388: 0x865D,
	5389: 0x8660,
	5390: 0x8661,
	5391: 0x8662,
	5392: 0x8663,
	5393: 0x8664,
	5394: 0x8669,
	5395: 0x866C,
	5396: 0x866F,
	5397: 0x8675,
	5398: 0x8676,
	5399: 0x8677,
	5400: 0x867A,
	5401: 0x868D,
	5402: 0x8691,
	5403: 0x8696,
	5404: 0x8698,
	5405: 0x869A,
	5406: 0x869C,
	5407: 0x86A1,
	5408: 0x86A6,
	5409: 0x86A7,
	5410: 0x86A8,
	5411: 0x86AD,
	5412: 0x86B1,
	5413: 0x86B3,
	5414: 0x86B4,
	5415: 0x86B5,
	5416: 0x86B7,
	5417: 0x86B8,
	5418: 0x86B9,
	5419: 0x86BF,
	5420: 0x86C0,
	5421: 0x86C1,
	5422: 0x86C3,
	5423: 0x86C5,
	5424: 0x86D1,
	5425: 0x86D2,
	5426: 0x86D5,
	5427: 0x86D7,
	5428: 0x86DA,
	5429: 0x86DC,
	5430: 0x86E0,
	5431: 0x86E3,
	5432: 0x86E5,
	5433: 0x86E7,
	5434: 0x8688,
	5435: 0x86FA,
	5436: 0x86FC,
	5437: 0x86FD,
	5438: 0x8704,
	5439: 0x8705,
	5440: 0x8707,
	5441: 0x870B,
	5442: 0x870E,
	5443: 0x870F,
	5444: 0x8710,
	5445: 0x8713,
	5446: 0x8714,
	5447: 0x8719,
	5448: 0x871E,
	5449: 0x871F,
	5450: 0x8721,
	5451: 0x8723,
	5452: 0x8728,
	5453: 0x872E,
	5454: 0x872F,
	5455: 0x8731,
	5456: 0x8732,
	5457: 0x8739,
	5458: 0x873A,
	5459: 0x873C,
	5460: 0x873D,
	5461: 0x873E,
	5462: 0x8740,
	5463: 0x8743,
	5464: 0x8745,
	5465: 0x874D,
	5466: 0x8758,
	5467: 0x875D,
	5468: 0x8761,
	5469: 0x8764,
	5470: 0x8765,
	5471: 0x876F,
	5472: 0x8771,
	5473: 0x8772,
	5474: 0x877B,
	5475: 0x8783,
	5476: 0x8784,
	5477: 0x8785,
	5478: 0x8786,
	5479: 0x8787,
	5480: 0x8788,
	5481: 0x8789,
	5482: 0x878B,
	5483: 0x878C,
	5484: 0x8790,
	5485: 0x8793,
	5486: 0x8795,
	5487: 0x8797,
	5488: 0x8798,
	5489: 0x8799,
	5490: 0x879E,
	5491: 0x87A0,
	5492: 0x87A3,
	5493: 0x87A7,
	5494: 0x87AC,
	5495: 0x87AD,
	5496: 0x87AE,
	5497: 0x87B1,
	5498: 0x87B5,
	5499: 0x87BE,
	5500: 0x87BF,
	5501: 0x87C1,
	5502: 0x87C8,
	5503: 0x87C9,
	5504: 0x87CA,
	5505: 0x87CE,
	5506: 0x87D5,
	5507: 0x87D6,
	5508: 0x87D9,
	5509: 0x87DA,
	5510: 0x87DC,
	5511: 0x87DF,
	5512: 0x87E2,
	5513: 0x87E3,
	5514: 0x87E4,
	5515: 0x87EA,
	5516: 0x87EB,
	5517: 0x87ED,
	5518: 0x87F1,
	5519: 0x87F3,
	5520: 0x87F8,
	5521: 0x87FA,
	5522: 0x87FF,
	5523: 0x8801,
	5524: 0x8803,
	5525: 0x8806,
	5526: 0x8809,
	5527: 0x880A,
	5528: 0x880B,
	5529: 0x8810,
	5530: 0x8819,
	5531: 0x8812,
	5532: 0x8813,
	5533: 0x8814,
	5534: 0x8818,
	5535: 0x881A,
	5536: 0x881B,
	5537: 0x881C,
	5538: 0x881E,
	5539: 0x881F,
	5540: 0x8828,
	5541: 0x882D,
	5542: 0x882E,
	5543: 0x8830,
	5544: 0x8832,
	5545: 0x8835,
	5546: 0x883A,
	5547: 0x883C,
	5548: 0x8841,
	5549: 0x8843,
	5550: 0x8845,
	5551: 0x8848,
	5552: 0x8849,
	5553: 0x884A,
	5554: 0x884B,
	5555: 0x884E,
	5556: 0x8851,
	5557: 0x8855,
	5558: 0x8856,
	5559: 0x8858,
	5560: 0x885A,
	5561: 0x885C,
	5562: 0x885F,
	5563: 0x8860,
	5564: 0x8864,
	5565: 0x8869,
	5566: 0x8871,
	5567: 0x8879,
	5568: 0x887B,
	5569: 0x8880,
	5570: 0x8898,
	5571: 0x889A,
	5572: 0x889B,
	5573: 0x889C,
	5574: 0x889F,
	5575: 0x88A0,
	5576: 0x88A8,
	5577: 0x88AA,
	5578: 0x88BA,
	5579: 0x88BD,
	5580: 0x88BE,
	5581: 0x88C0,
	5582: 0x88CA,
	5583: 0x88CB,
	5584: 0x88CC,
	5585: 0x88CD,
	5586: 0x88CE,
	5587: 0x88D1,
	5588: 0x88D2,
	5589: 0x88D3,
	5590: 0x88DB,
	5591: 0x88DE,
	5592: 0x88E7,
	5593: 0x88EF,
	5594: 0x88F0,
	5595: 0x88F1,
	5596: 0x88F5,
	5597: 0x88F7,
	5598: 0x8901,
	5599: 0x8906,
	5600: 0x890D,
	5601: 0x890E,
	5602: 0x890F,
	5603: 0x8915,
	5604: 0x8916,
	5605: 0x8918,
	5606: 0x8919,
	5607: 0x891A,
	5608: 0x891C,
	5609: 0x8920,
	5610: 0x8926,
	5611: 0x8927,
	5612: 0x8928,
	5613: 0x8930,
	5614: 0x8931,
	5615: 0x8932,
	5616: 0x8935,
	5617: 0x8939,
	5618: 0x893A,
	5619: 0x893E,
	5620: 0x8940,
	5621: 0x8942,
	5622: 0x8945,
	5623: 0x8946,
	5624: 0x8949,
	5625: 0x894F,
	5626: 0x8952,
	5627: 0x8957,
	5628: 0x895A,
	5629: 0x895B,
	5630: 0x895C,
	5631: 0x8961,
	5632: 0x8962,
	5633: 0x8963,
	5634: 0x896B,
	5635: 0x896E,
	5636: 0x8970,
	5637: 0x8973,
	5638: 0x8975,
	5639: 0x897A,
	5640: 0x897B,
	5641: 0x897C,
	5642: 0x897D,
	5643: 0x8989,
	5644: 0x898D,
	5645: 0x8990,
	5646: 0x8994,
	5647: 0x8995,
	5648: 0x899B,
	5649: 0x899C,
	5650: 0x899F,
	5651: 0x89A0,
	5652: 0x89A5,
	5653: 0x89B0,
	5654: 0x89B4,
	5655: 0x89B5,
	5656: 0x89B6,
	5657: 0x89B7,
	5658: 0x89BC,
	5659: 0x89D4,
	5660: 0x89D5,
	5661: 0x89D6,
	5662: 0x89D7,
	5663: 0x89D8,
	5664: 0x89E5,
	5665: 0x89E9,
	5666: 0x89EB,
	5667: 0x89ED,
	5668: 0x89F1,
	5669: 0x89F3,
	5670: 0x89F6,
	5671: 0x89F9,
	5672: 0x89FD,
	5673: 0x89FF,
	5674: 0x8A04,
	5675: 0x8A05,
	5676: 0x8A07,
	5677: 0x8A0F,
	5678: 0x8A11,
	5679: 0x8A12,
	5680: 0x8A14,
	5681: 0x8A15,
	5682: 0x8A1E,
	5683: 0x8A20,
	5684: 0x8A22,
	5685: 0x8A24,
	5686: 0x8A26,
	5687: 0x8A2B,
	5688: 0x8A2C,
	5689: 0x8A2F,
	5690: 0x8A35,
	5691: 0x8A37,
	5692: 0x8A3D,
	5693: 0x8A3E,
	5694: 0x8A40,
	5695: 0x8A43,
	5696: 0x8A45,
	5697: 0x8A47,
	5698: 0x8A49,
	5699: 0x8A4D,
	5700: 0x8A4E,
	5701: 0x8A53,
	5702: 0x8A56,
	5703: 0x8A57,
	5704: 0x8A58,
	5705: 0x8A5C,
	5706: 0x8A5D,
	5707: 0x8A61,
	5708: 0x8A65,
	5709: 0x8A67,
	5710: 0x8A75,
	5711: 0x8A76,
	5712: 0x8A77,
	5713: 0x8A79,
	5714: 0x8A7A,
	5715: 0x8A7B,
	5716: 0x8A7E,
	5717: 0x8A7F,
	5718: 0x8A80,
	5719: 0x8A83,
	5720: 0x8A86,
	5721: 0x8A8B,
	5722: 0x8A8F,
	5723: 0x8A90,
	5724: 0x8A92,
	5725: 0x8A96,
	5726: 0x8A97,
	5727: 0x8A99,
	5728: 0x8A9F,
	5729: 0x8AA7,
	5730: 0x8AA9,
	5731: 0x8AAE,
	5732: 0x8AAF,
	5733: 0x8AB3,
	5734: 0x8AB6,
	5735: 0x8AB7,
	5736: 0x8ABB,
	5737: 0x8ABE,
	5738: 0x8AC3,
	5739: 0x8AC6,
	5740: 0x8AC8,
	5741: 0x8AC9,
	5742: 0x8ACA,
	5743: 0x8AD1,
	5744: 0x8AD3,
	5745: 0x8AD4,
	5746: 0x8AD5,
	5747: 0x8AD7,
	5748: 0x8ADD,
	5749: 0x8ADF,
	5750: 0x8AEC,
	5751: 0x8AF0,
	5752: 0x8AF4,
	5753: 0x8AF5,
	5754: 0x8AF6,
	5755: 0x8AFC,
	5756: 0x8AFF,
	5757: 0x8B05,
	5758: 0x8B06,
	5759: 0x8B0B,
	5760: 0x8B11,
	5761: 0x8B1C,
	5762: 0x8B1E,
	5763: 0x8B1F,
	5764: 0x8B0A,
	5765: 0x8B2D,
	5766: 0x8B30,
	5767: 0x8B37,
	5768: 0x8B3C,
	5769: 0x8B42,
	5770: 0x8B43,
	5771: 0x8B44,
	5772: 0x8B45,
	5773: 0x8B46,
	5774: 0x8B48,
	5775: 0x8B52,
	5776: 0x8B53,
	5777: 0x8B54,
	5778: 0x8B59,
	5779: 0x8B4D,
	5780: 0x8B5E,
	5781: 0x8B63,
	5782: 0x8B6D,
	5783: 0x8B76,
	5784: 0x8B78,
	5785: 0x8B79,
	5786: 0x8B7C,
	5787: 0x8B7E,
	5788: 0x8B81,
	5789: 0x8B84,
	5790: 0x8B85,
	5791: 0x8B8B,
	5792: 0x8B8D,
	5793: 0x8B8F,
	5794: 0x8B94,
	5795: 0x8B95,
	5796: 0x8B9C,
	5797: 0x8B9E,
	5798: 0x8B9F,
	5799: 0x8C38,
	5800: 0x8C39,
	5801: 0x8C3D,
	5802: 0x8C3E,
	5803: 0x8C45,
	5804: 0x8C47,
	5805: 0x8C49,
	5806: 0x8C4B,
	5807: 0x8C4F,
	5808: 0x8C51,
	5809: 0x8C53,
	5810: 0x8C54,
	5811: 0x8C57,
	5812: 0x8C58,
	5813: 0x8C5B,
	5814: 0x8C5D,
	5815: 0x8C59,
	5816: 0x8C63,
	5817: 0x8C64,
	5818: 0x8C66,
	5819: 0x8C68,
	5820: 0x8C69,
	5821: 0x8C6D,
	5822: 0x8C73,
	5823: 0x8C75,
	5824: 0x8C76,
	5825: 0x8C7B,
	5826: 0x8C7E,
	5827: 0x8C86,
	5828: 0x8C87,
	5829: 0x8C8B,
	5830: 0x8C90,
	5831: 0x8C92,
	5832: 0x8C93,
	5833: 0x8C99,
	5834: 0x8C9B,
	5835: 0x8C9C,
	5836: 0x8CA4,
	5837: 0x8CB9,
	5838: 0x8CBA,
	5839: 0x8CC5,
	5840: 0x8CC6,
	5841: 0x8CC9,
	5842: 0x8CCB,
	5843: 0x8CCF,
	5844: 0x8CD6,
	5845: 0x8CD5,
	5846: 0x8CD9,
	5847: 0x8CDD,
	5848: 0x8CE1,
	5849: 0x8CE8,
	5850: 0x8CEC,
	5851: 0x8CEF,
	5852: 0x8CF0,
	5853: 0x8CF2,
	5854: 0x8CF5,
	5855: 0x8CF7,
	5856: 0x8CF8,
	5857: 0x8CFE,
	5858: 0x8CFF,
	5859: 0x8D01,
	5860: 0x8D03,
	5861: 0x8D09,
	5862: 0x8D12,
	5863: 0x8D17,
	5864: 0x8D1B,
	5865: 0x8D65,
	5866: 0x8D69,
	5867: 0x8D6C,
	5868: 0x8D6E,
	5869: 0x8D7F,
	5870: 0x8D82,
	5871: 0x8D84,
	5872: 0x8D88,
	5873: 0x8D8D,
	5874: 0x8D90,
	5875: 0x8D91,
	5876: 0x8D95,
	5877: 0x8D9E,
	5878: 0x8D9F,
	5879: 0x8DA0,
	5880: 0x8DA6,
	5881: 0x8DAB,
	5882: 0x8DAC,
	5883: 0x8DAF,
	5884: 0x8DB2,
	5885: 0x8DB5,
	5886: 0x8DB7,
	5887: 0x8DB9,
	5888: 0x8DBB,
	5889: 0x8DC0,
	5890: 0x8DC5,
	5891: 0x8DC6,
	5892: 0x8DC7,
	5893: 0x8DC8,
	5894: 0x8DCA,
	5895: 0x8DCE,
	5896: 0x8DD1,
	5897: 0x8DD4,
	5898: 0x8DD5,
	5899: 0x8DD7,
	5900: 0x8DD9,
	5901: 0x8DE4,
	5902: 0x8DE5,
	5903: 0x8DE7,
	5904: 0x8DEC,
	5905: 0x8DF0,
	5906: 0x8DBC,
	5907: 0x8DF1,
	5908: 0x8DF2,
	5909: 0x8DF4,
	5910: 0x8DFD,
	5911: 0x8E01,
	5912: 0x8E04,
	5913: 0x8E05,
	5914: 0x8E06,
	5915: 0x8E0B,
	5916: 0x8E11,
	5917: 0x8E14,
	5918: 0x8E16,
	5919: 0x8E20,
	5920: 0x8E21,
	5921: 0x8E22,
	5922: 0x8E23,
	5923: 0x8E26,
	5924: 0x8E27,
	5925: 0x8E31,
	5926: 0x8E33,
	5927: 0x8E36,
	5928: 0x8E37,
	5929: 0x8E38,
	5930: 0x8E39,
	5931: 0x8E3D,
	5932: 0x8E40,
	5933: 0x8E41,
	5934: 0x8E4B,
	5935: 0x8E4D,
	5936: 0x8E4E,
	5937: 0x8E4F,
	5938: 0x8E54,
	5939: 0x8E5B,
	5940: 0x8E5C,
	5941: 0x8E5D,
	5942: 0x8E5E,
	5943: 0x8E61,
	5944: 0x8E62,
	5945: 0x8E69,
	5946: 0x8E6C,
	5947: 0x8E6D,
	5948: 0x8E6F,
	5949: 0x8E70,
	5950: 0x8E71,
	5951: 0x8E79,
	5952: 0x8E7A,
	5953: 0x8E7B,
	5954: 0x8E82,
	5955: 0x8E83,
	5956: 0x8E89,
	5957: 0x8E90,
	5958: 0x8E92,
	5959: 0x8E95,
	5960: 0x8E9A,
	5961: 0x8E9B,
	5962: 0x8E9D,
	5963: 0x8E9E,
	5964: 0x8EA2,
	5965: 0x8EA7,
	5966: 0x8EA9,
	5967: 0x8EAD,
	5968: 0x8EAE,
	5969: 0x8EB3,
	5970: 0x8EB5,
	5971: 0x8EBA,
	5972: 0x8EBB,
	5973: 0x8EC0,
	5974: 0x8EC1,
	5975: 0x8EC3,
	5976: 0x8EC4,
	5977: 0x8EC7,
	5978: 0x8ECF,
	5979: 0x8ED1,
	5980: 0x8ED4,
	5981: 0x8EDC,
	5982: 0x8EE8,
	5983: 0x8EEE,
	5984: 0x8EF0,
	5985: 0x8EF1,
	5986: 0x8EF7,
	5987: 0x8EF9,
	5988: 0x8EFA,
	5989: 0x8EED,
	5990: 0x8F00,
	5991: 0x8F02,
	5992: 0x8F07,
	5993: 0x8F08,
	5994: 0x8F0F,
	5995: 0x8F10,
	5996: 0x8F16,
	5997: 0x8F17,
	5998: 0x8F18,
	5999: 0x8F1E,
	6000: 0x8F20,
	6001: 0x8F21,
	6002: 0x8F23,
	6003: 0x8F25,
	6004: 0x8F27,
	6005: 0x8F28,
	6006: 0x8F2C,
	6007: 0x8F2D,
	6008: 0x8F2E,
	6009: 0x8F34,
	6010: 0x8F35,
	6011: 0x8F36,
	6012: 0x8F37,
	6013: 0x8F3A,
	6014: 0x8F40,
	6015: 0x8F41,
	6016: 0x8F43,
	6017: 0x8F47,
	6018: 0x8F4F,
	6019: 0x8F51,
	6020: 0x8F52,
	6021: 0x8F53,
	6022: 0x8F54,
	6023: 0x8F55,
	6024: 0x8F58,
	6025: 0x8F5D,
	6026: 0x8F5E,
	6027: 0x8F65,
	6028: 0x8F9D,
	6029: 0x8FA0,
	6030: 0x8FA1,
	6031: 0x8FA4,
	6032: 0x8FA5,
	6033: 0x8FA6,
	6034: 0x8FB5,
	6035: 0x8FB6,
	6036: 0x8FB8,
	6037: 0x8FBE,
	6038: 0x8FC0,
	6039: 0x8FC1,
	6040: 0x8FC6,
	6041: 0x8FCA,
	6042: 0x8FCB,
	6043: 0x8FCD,
	6044: 0x8FD0,
	6045: 0x8FD2,
	6046: 0x8FD3,
	6047: 0x8FD5,
	6048: 0x8FE0,
	6049: 0x8FE3,
	6050: 0x8FE4,
	6051: 0x8FE8,
	6052: 0x8FEE,
	6053: 0x8FF1,
	6054: 0x8FF5,
	6055: 0x8FF6,
	6056: 0x8FFB,
	6057: 0x8FFE,
	6058: 0x9002,
	6059: 0x9004,
	6060: 0x9008,
	6061: 0x900C,
	6062: 0x9018,
	6063: 0x901B,
	6064: 0x9028,
	6065: 0x9029,
	6066: 0x902F,
	6067: 0x902A,
	6068: 0x902C,
	6069: 0x902D,
	6070: 0x9033,
	6071: 0x9034,
	6072: 0x9037,
	6073: 0x903F,
	6074: 0x9043,
	6075: 0x9044,
	6076: 0x904C,
	6077: 0x905B,
	6078: 0x905D,
	6079: 0x9062,
	6080: 0x9066,
	6081: 0x9067,
	6082: 0x906C,
	6083: 0x9070,
	6084: 0x9074,
	6085: 0x9079,
	6086: 0x9085,
	6087: 0x9088,
	6088: 0x908B,
	6089: 0x908C,
	6090: 0x908E,
	6091: 0x9090,
	6092: 0x9095,
	6093: 0x9097,
	6094: 0x9098,
	6095: 0x9099,
	6096: 0x909B,
	6097: 0x90A0,
	6098: 0x90A1,
	6099: 0x90A2,
	6100: 0x90A5,
	6101: 0x90B0,
	6102: 0x90B2,
	6103: 0x90B3,
	6104: 0x90B4,
	6105: 0x90B6,
	6106: 0x90BD,
	6107: 0x90CC,
	6108: 0x90BE,
	6109: 0x90C3,
	6110: 0x90C4,
	6111: 0x90C5,
	6112: 0x90C7,
	6113: 0x90C8,
	6114: 0x90D5,
	6115: 0x90D7,
	6116: 0x90D8,
	6117: 0x90D9,
	6118: 0x90DC,
	6119: 0x90DD,
	6120: 0x90DF,
	6121: 0x90E5,
	6122: 0x90D2,
	6123: 0x90F6,
	6124: 0x90EB,
	6125: 0x90EF,
	6126: 0x90F0,
	6127: 0x90F4,
	6128: 0x90FE,
	6129: 0x90FF,
	6130: 0x9100,
	6131: 0x9104,
	6132: 0x9105,
	6133: 0x9106,
	6134: 0x9108,
	6135: 0x910D,
	6136: 0x9110,
	6137: 0x9114,
	6138: 0x9116,
	6139: 0x9117,
	6140: 0x9118,
	6141: 0x911A,
	6142: 0x911C,
	6143: 0x911E,
	6144: 0x9120,
	6145: 0x9125,
	6146: 0x9122,
	6147: 0x9123,
	6148: 0x9127,
	6149: 0x9129,
	6150: 0x912E,
	6151: 0x912F,
	6152: 0x9131,
	6153: 0x9134,
	6154: 0x9136,
	6155: 0x9137,
	6156: 0x9139,
	6157: 0x913A,
	6158: 0x913C,
	6159: 0x913D,
	6160: 0x9143,
	6161: 0x9147,
	6162: 0x9148,
	6163: 0x914F,
	6164: 0x9153,
	6165: 0x9157,
	6166: 0x9159,
	6167: 0x915A,
	6168: 0x915B,
	6169: 0x9161,
	6170: 0x9164,
	6171: 0x9167,
	6172: 0x916D,
	6173: 0x9174,
	6174: 0x9179,
	6175: 0x917A,
	6176: 0x917B,
	6177: 0x9181,
	6178: 0x9183,
	6179: 0x9185,
	6180: 0x9186,
	6181: 0x918A,
	6182: 0x918E,
	6183: 0x9191,
	6184: 0x9193,
	6185: 0x9194,
	6186: 0x9195,
	6187: 0x9198,
	6188: 0x919E,
	6189: 0x91A1,
	6190: 0x91A6,
	6191: 0x91A8,
	6192: 0x91AC,
	6193: 0x91AD,
	6194: 0x91AE,
	6195: 0x91B0,
	6196: 0x91B1,
	6197: 0x91B2,
	6198: 0x91B3,
	6199: 0x91B6,
	6200: 0x91BB,
	6201: 0x91BC,
	6202: 0x91BD,
	6203: 0x91BF,
	6204: 0x91C2,
	6205: 0x91C3,
	6206: 0x91C5,
	6207: 0x91D3,
	6208: 0x91D4,
	6209: 0x91D7,
	6210: 0x91D9,
	6211: 0x91DA,
	6212: 0x91DE,
	6213: 0x91E4,
	6214: 0x91E5,
	6215: 0x91E9,
	6216: 0x91EA,
	6217: 0x91EC,
	6218: 0x91ED,
	6219: 0x91EE,
	6220: 0x91EF,
	6221: 0x91F0,
	6222: 0x91F1,
	6223: 0x91F7,
	6224: 0x91F9,
	6225: 0x91FB,
	6226: 0x91FD,
	6227: 0x9200,
	6228: 0x9201,
	6229: 0x9204,
	6230: 0x9205,
	6231: 0x9206,
	6232: 0x9207,
	6233: 0x9209,
	6234: 0x920A,
	6235: 0x920C,
	6236: 0x9210,
	6237: 0x9212,
	6238: 0x9213,
	6239: 0x9216,
	6240: 0x9218,
	6241: 0x921C,
	6242: 0x921D,
	6243: 0x9223,
	6244: 0x9224,
	6245: 0x9225,
	6246: 0x9226,
	6247: 0x9228,
	6248: 0x922E,
	6249: 0x922F,
	6250: 0x9230,
	6251: 0x9233,
	6252: 0x9235,
	6253: 0x9236,
	6254: 0x9238,
	6255: 0x9239,
	6256: 0x923A,
	6257: 0x923C,
	6258: 0x923E,
	6259: 0x9240,
	6260: 0x9242,
	6261: 0x9243,
	6262: 0x9246,
	6263: 0x9247,
	6264: 0x924A,
	6265: 0x924D,
	6266: 0x924E,
	6267: 0x924F,
	6268: 0x9251,
	6269: 0x9258,
	6270: 0x9259,
	6271: 0x925C,
	6272: 0x925D,
	6273: 0x9260,
	6274: 0x9261,
	6275: 0x9265,
	6276: 0x9267,
	6277: 0x9268,
	6278: 0x9269,
	6279: 0x926E,
	6280: 0x926F,
	6281: 0x9270,
	6282: 0x9275,
	6283: 0x9276,
	6284: 0x9277,
	6285: 0x9278,
	6286: 0x9279,
	6287: 0x927B,
	6288: 0x927C,
	6289: 0x927D,
	6290: 0x927F,
	6291: 0x9288,
	6292: 0x9289,
	6293: 0x928A,
	6294: 0x928D,
	6295: 0x928E,
	6296: 0x9292,
	6297: 0x9297,
	6298: 0x9299,
	6299: 0x929F,
	6300: 0x92A0,
	6301: 0x92A4,
	6302: 0x92A5,
	6303: 0x92A7,
	6304: 0x92A8,
	6305: 0x92AB,
	6306: 0x92AF,
	6307: 0x92B2,
	6308: 0x92B6,
	6309: 0x92B8,
	6310: 0x92BA,
	6311: 0x92BB,
	6312: 0x92BC,
	6313: 0x92BD,
	6314: 0x92BF,
	6315: 0x92C0,
	6316: 0x92C1,
	6317: 0x92C2,
	6318: 0x92C3,
	6319: 0x92C5,
	6320: 0x92C6,
	6321: 0x92C7,
	6322: 0x92C8,
	6323: 0x92CB,
	6324: 0x92CC,
	6325: 0x92CD,
	6326: 0x92CE,
	6327: 0x92D0,
	6328: 0x92D3,
	6329: 0x92D5,
	6330: 0x92D7,
	6331: 0x92D8,
	6332: 0x92D9,
	6333: 0x92DC,
	6334: 0x92DD,
	6335: 0x92DF,
	6336: 0x92E0,
	6337: 0x92E1,
	6338: 0x92E3,
	6339: 0x92E5,
	6340: 0x92E7,
	6341: 0x92E8,
	6342: 0x92EC,
	6343: 0x92EE,
	6344: 0x92F0,
	6345: 0x92F9,
	6346: 0x92FB,
	6347: 0x92FF,
	6348: 0x9300,
	6349: 0x9302,
	6350: 0x9308,
	6351: 0x930D,
	6352: 0x9311,
	6353: 0x9314,
	6354: 0x9315,
	6355: 0x931C,
	6356: 0x931D,
	6357: 0x931E,
	6358: 0x931F,
	6359: 0x9321,
	6360: 0x9324,
	6361: 0x9325,
	6362: 0x9327,
	6363: 0x9329,
	6364: 0x932A,
	6365: 0x9333,
	6366: 0x9334,
	6367: 0x9336,
	6368: 0x9337,
	6369: 0x9347,
	6370: 0x9348,
	6371: 0x9349,
	6372: 0x9350,
	6373: 0x9351,
	6374: 0x9352,
	6375: 0x9355,
	6376: 0x9357,
	6377: 0x9358,
	6378: 0x935A,
	6379: 0x935E,
	6380: 0x9364,
	6381: 0x9365,
	6382: 0x9367,
	6383: 0x9369,
	6384: 0x936A,
	6385: 0x936D,
	6386: 0x936F,
	6387: 0x9370,
	6388: 0x9371,
	6389: 0x9373,
	6390: 0x9374,
	6391: 0x9376,
	6392: 0x937A,
	6393: 0x937D,
	6394: 0x937F,
	6395: 0x9380,
	6396: 0x9381,
	6397: 0x9382,
	6398: 0x9388,
	6399: 0x938A,
	6400: 0x938B,
	6401: 0x938D,
	6402: 0x938F,
	6403: 0x9392,
	6404: 0x9395,
	6405: 0x9398,
	6406: 0x939B,
	6407: 0x939E,
	6408: 0x93A1,
	6409: 0x93A3,
	6410: 0x93A4,
	6411: 0x93A6,
	6412: 0x93A8,
	6413: 0x93AB,
	6414: 0x93B4,
	6415: 0x93B5,
	6416: 0x93B6,
	6417: 0x93BA,
	6418: 0x93A9,
	6419: 0x93C1,
	6420: 0x93C4,
	6421: 0x93C5,
	6422: 0x93C6,
	6423: 0x93C7,
	6424: 0x93C9,
	6425: 0x93CA,
	6426: 0x93CB,
	6427: 0x93CC,
	6428: 0x93CD,
	6429: 0x93D3,
	6430: 0x93D9,
	6431: 0x93DC,
	6432: 0x93DE,
	6433: 0x93DF,
	6434: 0x93E2,
	6435: 0x93E6,
	6436: 0x93E7,
	6437: 0x93F9,
	6438: 0x93F7,
	6439: 0x93F8,
	6440: 0x93FA,
	6441: 0x93FB,
	6442: 0x93FD,
	6443: 0x9401,
	6444: 0x9402,
	6445: 0x9404,
	6446: 0x9408,
	6447: 0x9409,
	6448: 0x940D,
	6449: 0x940E,
	6450: 0x940F,
	6451: 0x9415,
	6452: 0x9416,
	6453: 0x9417,
	6454: 0x941F,
	6455: 0x942E,
	6456: 0x942F,
	6457: 0x9431,
	6458: 0x9432,
	6459: 0x9433,
	6460: 0x9434,
	6461: 0x943B,
	6462: 0x943F,
	6463: 0x943D,
	6464: 0x9443,
	6465: 0x9445,
	6466: 0x9448,
	6467: 0x944A,
	6468: 0x944C,
	6469: 0x9455,
	6470: 0x9459,
	6471: 0x945C,
	6472: 0x945F,
	6473: 0x9461,
	6474: 0x9463,
	6475: 0x9468,
	6476: 0x946B,
	6477: 0x946D,
	6478: 0x946E,
	6479: 0x946F,
	6480: 0x9471,
	6481: 0x9472,
	6482: 0x9484,
	6483: 0x9483,
	6484: 0x9578,
	6485: 0x9579,
	6486: 0x957E,
	6487: 0x9584,
	6488: 0x9588,
	6489: 0x958C,
	6490: 0x958D,
	6491: 0x958E,
	6492: 0x959D,
	6493: 0x959E,
	6494: 0x959F,
	6495: 0x95A1,
	6496: 0x95A6,
	6497: 0x95A9,
	6498: 0x95AB,
	6499: 0x95AC,
	6500: 0x95B4,
	6501: 0x95B6,
	6502: 0x95BA,
	6503: 0x95BD,
	6504: 0x95BF,
	6505: 0x95C6,
	6506: 0x95C8,
	6507: 0x95C9,
	6508: 0x95CB,
	6509: 0x95D0,
	6510: 0x95D1,
	6511: 0x95D2,
	6512: 0x95D3,
	6513: 0x95D9,
	6514: 0x95DA,
	6515: 0x95DD,
	6516: 0x95DE,
	6517: 0x95DF,
	6518: 0x95E0,
	6519: 0x95E4,
	6520: 0x95E6,
	6521: 0x961D,
	6522: 0x961E,
	6523: 0x9622,
	6524: 0x9624,
	6525: 0x9625,
	6526: 0x9626,
	6527: 0x962C,
	6528: 0x9631,
	6529: 0x9633,
	6530: 0x9637,
	6531: 0x9638,
	6532: 0x9639,
	6533: 0x963A,
	6534: 0x963C,
	6535: 0x963D,
	6536: 0x9641,
	6537: 0x9652,
	6538: 0x9654,
	6539: 0x9656,
	6540: 0x9657,
	6541: 0x9658,
	6542: 0x9661,
	6543: 0x966E,
	6544: 0x9674,
	6545: 0x967B,
	6546: 0x967C,
	6547: 0x967E,
	6548: 0x967F,
	6549: 0x9681,
	6550: 0x9682,
	6551: 0x9683,
	6552: 0x9684,
	6553: 0x9689,
	6554: 0x9691,
	6555: 0x9696,
	6556: 0x969A,
	6557: 0x969D,
	6558: 0x969F,
	6559: 0x96A4,
	6560: 0x96A5,
	6561: 0x96A6,
	6562: 0x96A9,
	6563: 0x96AE,
	6564: 0x96AF,
	6565: 0x96B3,
	6566: 0x96BA,
	6567: 0x96CA,
	6568: 0x96D2,
	6569: 0x5DB2,
	6570: 0x96D8,
	6571: 0x96DA,
	6572: 0x96DD,
	6573: 0x96DE,
	6574: 0x96DF,
	6575: 0x96E9,
	6576: 0x96EF,
	6577: 0x96F1,
	6578: 0x96FA,
	6579: 0x9702,
	6580: 0x9703,
	6581: 0x9705,
	6582: 0x9709,
	6583: 0x971A,
	6584: 0x971B,
	6585: 0x971D,
	6586: 0x9721,
	6587: 0x9722,
	6588: 0x9723,
	6589: 0x9728,
	6590: 0x9731,
	6591: 0x9733,
	6592: 0x9741,
	6593: 0x9743,
	6594: 0x974A,
	6595: 0x974E,
	6596: 0x974F,
	6597: 0x9755,
	6598: 0x9757,
	6599: 0x9758,
	6600: 0x975A,
	6601: 0x975B,
	6602: 0x9763,
	6603: 0x9767,
	6604: 0x976A,
	6605: 0x976E,
	6606: 0x9773,
	6607: 0x9776,
	6608: 0x9777,
	6609: 0x9778,
	6610: 0x977B,
	6611: 0x977D,
	6612: 0x977F,
	6613: 0x9780,
	6614: 0x9789,
	6615: 0x9795,
	6616: 0x9796,
	6617: 0x9797,
	6618: 0x9799,
	6619: 0x979A,
	6620: 0x979E,
	6621: 0x979F,
	6622: 0x97A2,
	6623: 0x97AC,
	6624: 0x97AE,
	6625: 0x97B1,
	6626: 0x97B2,
	6627: 0x97B5,
	6628: 0x97B6,
	6629: 0x97B8,
	6630: 0x97B9,
	6631: 0x97BA,
	6632: 0x97BC,
	6633: 0x97BE,
	6634: 0x97BF,
	6635: 0x97C1,
	6636: 0x97C4,
	6637: 0x97C5,
	6638: 0x97C7,
	6639: 0x97C9,
	6640: 0x97CA,
	6641: 0x97CC,
	6642: 0x97CD,
	6643: 0x97CE,
	6644: 0x97D0,
	6645: 0x97D1,
	6646: 0x97D4,
	6647: 0x97D7,
	6648: 0x97D8,
	6649: 0x97D9,
	6650: 0x97DD,
	6651: 0x97DE,
	6652: 0x97E0,
	6653: 0x97DB,
	6654: 0x97E1,
	6655: 0x97E4,
	6656: 0x97EF,
	6657: 0x97F1,
	6658: 0x97F4,
	6659: 0x97F7,
	6660: 0x97F8,
	6661: 0x97FA,
	6662: 0x9807,
	6663: 0x980A,
	6664: 0x9819,
	6665: 0x980D,
	6666: 0x980E,
	6667: 0x9814,
	6668: 0x9816,
	6669: 0x981C,
	6670: 0x981E,
	6671: 0x9820,
	6672: 0x9823,
	6673: 0x9826,
	6674: 0x982B,
	6675: 0x982E,
	6676: 0x982F,
	6677: 0x9830,
	6678: 0x9832,
	6679: 0x9833,
	6680: 0x9835,
	6681: 0x9825,
	6682: 0x983E,
	6683: 0x9844,
	6684: 0x9847,
	6685: 0x984A,
	6686: 0x9851,
	6687: 0x9852,
	6688: 0x9853,
	6689: 0x9856,
	6690: 0x9857,
	6691: 0x9859,
	6692: 0x985A,
	6693: 0x9862,
	6694: 0x9863,
	6695: 0x9865,
	6696: 0x9866,
	6697: 0x986A,
	6698: 0x986C,
	6699: 0x98AB,
	6700: 0x98AD,
	6701: 0x98AE,
	6702: 0x98B0,
	6703: 0x98B4,
	6704: 0x98B7,
	6705: 0x98B8,
	6706: 0x98BA,
	6707: 0x98BB,
	6708: 0x98BF,
	6709: 0x98C2,
	6710: 0x98C5,
	6711: 0x98C8,
	6712: 0x98CC,
	6713: 0x98E1,
	6714: 0x98E3,
	6715: 0x98E5,
	6716: 0x98E6,
	6717: 0x98E7,
	6718: 0x98EA,
	6719: 0x98F3,
	6720: 0x98F6,
	6721: 0x9902,
	6722: 0x9907,
	6723: 0x9908,
	6724: 0x9911,
	6725: 0x9915,
	6726: 0x9916,
	6727: 0x9917,
	6728: 0x991A,
	6729: 0x991B,
	6730: 0x991C,
	6731: 0x991F,
	6732: 0x9922,
	6733: 0x9926,
	6734: 0x9927,
	6735: 0x992B,
	6736: 0x9931,
	6737: 0x9932,
	6738: 0x9933,
	6739: 0x9934,
	6740: 0x9935,
	6741: 0x9939,
	6742: 0x993A,
	6743: 0x993B,
	6744: 0x993C,
	6745: 0x9940,
	6746: 0x9941,
	6747: 0x9946,
	6748: 0x9947,
	6749: 0x9948,
	6750: 0x994D,
	6751: 0x994E,
	6752: 0x9954,
	6753: 0x9958,
	6754: 0x9959,
	6755: 0x995B,
	6756: 0x995C,
	6757: 0x995E,
	6758: 0x995F,
	6759: 0x9960,
	6760: 0x999B,
	6761: 0x999D,
	6762: 0x999F,
	6763: 0x99A6,
	6764: 0x99B0,
	6765: 0x99B1,
	6766: 0x99B2,
	6767: 0x99B5,
	6768: 0x99B9,
	6769: 0x99BA,
	6770: 0x99BD,
	6771: 0x99BF,
	6772: 0x99C3,
	6773: 0x99C9,
	6774: 0x99D3,
	6775: 0x99D4,
	6776: 0x99D9,
	6777: 0x99DA,
	6778: 0x99DC,
	6779: 0x99DE,
	6780: 0x99E7,
	6781: 0x99EA,
	6782: 0x99EB,
	6783: 0x99EC,
	6784: 0x99F0,
	6785: 0x99F4,
	6786: 0x99F5,
	6787: 0x99F9,
	6788: 0x99FD,
	6789: 0x99FE,
	6790: 0x9A02,
	6791: 0x9A03,
	6792: 0x9A04,
	6793: 0x9A0B,
	6794: 0x9A0C,
	6795: 0x9A10,
	6796: 0x9A11,
	6797: 0x9A16,
	6798: 0x9A1E,
	6799: 0x9A20,
	6800: 0x9A22,
	6801: 0x9A23,
	6802: 0x9A24,
	6803: 0x9A27,
	6804: 0x9A2D,
	6805: 0x9A2E,
	6806: 0x9A33,
	6807: 0x9A35,
	6808: 0x9A36,
	6809: 0x9A38,
	6810: 0x9A47,
	6811: 0x9A41,
	6812: 0x9A44,
	6813: 0x9A4A,
	6814: 0x9A4B,
	6815: 0x9A4C,
	6816: 0x9A4E,
	6817: 0x9A51,
	6818: 0x9A54,
	6819: 0x9A56,
	6820: 0x9A5D,
	6821: 0x9AAA,
	6822: 0x9AAC,
	6823: 0x9AAE,
	6824: 0x9AAF,
	6825: 0x9AB2,
	6826: 0x9AB4,
	6827: 0x9AB5,
	6828: 0x9AB6,
	6829: 0x9AB9,
	6830: 0x9ABB,
	6831: 0x9ABE,
	6832: 0x9ABF,
	6833: 0x9AC1,
	6834: 0x9AC3,
	6835: 0x9AC6,
	6836: 0x9AC8,
	6837: 0x9ACE,
	6838: 0x9AD0,
	6839: 0x9AD2,
	6840: 0x9AD5,
	6841: 0x9AD6,
	6842: 0x9AD7,
	6843: 0x9ADB,
	6844: 0x9ADC,
	6845: 0x9AE0,
	6846: 0x9AE4,
	6847: 0x9AE5,
	6848: 0x9AE7,
	6849: 0x9AE9,
	6850: 0x9AEC,
	6851: 0x9AF2,
	6852: 0x9AF3,
	6853: 0x9AF5,
	6854: 0x9AF9,
	6855: 0x9AFA,
	6856: 0x9AFD,
	6857: 0x9AFF,
	6858: 0x9B00,
	6859: 0x9B01,
	6860: 0x9B02,
	6861: 0x9B03,
	6862: 0x9B04,
	6863: 0x9B05,
	6864: 0x9B08,
	6865: 0x9B09,
	6866: 0x9B0B,
	6867: 0x9B0C,
	6868: 0x9B0D,
	6869: 0x9B0E,
	6870: 0x9B10,
	6871: 0x9B12,
	6872: 0x9B16,
	6873: 0x9B19,
	6874: 0x9B1B,
	6875: 0x9B1C,
	6876: 0x9B20,
	6877: 0x9B26,
	6878: 0x9B2B,
	6879: 0x9B2D,
	6880: 0x9B33,
	6881: 0x9B34,
	6882: 0x9B35,
	6883: 0x9B37,
	6884: 0x9B39,
	6885: 0x9B3A,
	6886: 0x9B3D,
	6887: 0x9B48,
	6888: 0x9B4B,
	6889: 0x9B4C,
	6890: 0x9B55,
	6891: 0x9B56,
	6892: 0x9B57,
	6893: 0x9B5B,
	6894: 0x9B5E,
	6895: 0x9B61,
	6896: 0x9B63,
	6897: 0x9B65,
	6898: 0x9B66,
	6899: 0x9B68,
	6900: 0x9B6A,
	6901: 0x9B6B,
	6902: 0x9B6C,
	6903: 0x9B6D,
	6904: 0x9B6E,
	6905: 0x9B73,
	6906: 0x9B75,
	6907: 0x9B77,
	6908: 0x9B78,
	6909: 0x9B79,
	6910: 0x9B7F,
	6911: 0x9B80,
	6912: 0x9B84,
	6913: 0x9B85,
	6914: 0x9B86,
	6915: 0x9B87,
	6916: 0x9B89,
	6917: 0x9B8A,
	6918: 0x9B8B,
	6919: 0x9B8D,
	6920: 0x9B8F,
	6921: 0x9B90,
	6922: 0x9B94,
	6923: 0x9B9A,
	6924: 0x9B9D,
	6925: 0x9B9E,
	6926: 0x9BA6,
	6927: 0x9BA7,
	6928: 0x9BA9,
	6929: 0x9BAC,
	6930: 0x9BB0,
	6931: 0x9BB1,
	6932: 0x9BB2,
	6933: 0x9BB7,
	6934: 0x9BB8,
	6935: 0x9BBB,
	6936: 0x9BBC,
	6937: 0x9BBE,
	6938: 0x9BBF,
	6939: 0x9BC1,
	6940: 0x9BC7,
	6941: 0x9BC8,
	6942: 0x9BCE,
	6943: 0x9BD0,
	6944: 0x9BD7,
	6945: 0x9BD8,
	6946: 0x9BDD,
	6947: 0x9BDF,
	6948: 0x9BE5,
	6949: 0x9BE7,
	6950: 0x9BEA,
	6951: 0x9BEB,
	6952: 0x9BEF,
	6953: 0x9BF3,
	6954: 0x9BF7,
	6955: 0x9BF8,
	6956: 0x9BF9,
	6957: 0x9BFA,
	6958: 0x9BFD,
	6959: 0x9BFF,
	6960: 0x9C00,
	6961: 0x9C02,
	6962: 0x9C0B,
	6963: 0x9C0F,
	6964: 0x9C11,
	6965: 0x9C16,
	6966: 0x9C18,
	6967: 0x9C19,
	6968: 0x9C1A,
	6969: 0x9C1C,
	6970: 0x9C1E,
	6971: 0x9C22,
	6972: 0x9C23,
	6973: 0x9C26,
	6974: 0x9C27,
	6975: 0x9C28,
	6976: 0x9C29,
	6977: 0x9C2A,
	6978: 0x9C31,
	6979: 0x9C35,
	6980: 0x9C36,
	6981: 0x9C37,
	6982: 0x9C3D,
	6983: 0x9C41,
	6984: 0x9C43,
	6985: 0x9C44,
	6986: 0x9C45,
	6987: 0x9C49,
	6988: 0x9C4A,
	6989: 0x9C4E,
	6990: 0x9C4F,
	6991: 0x9C50,
	6992: 0x9C53,
	6993: 0x9C54,
	6994: 0x9C56,
	6995: 0x9C58,
	6996: 0x9C5B,
	6997: 0x9C5D,
	6998: 0x9C5E,
	6999: 0x9C5F,
	7000: 0x9C63,
	7001: 0x9C69,
	7002: 0x9C6A,
	7003: 0x9C5C,
	7004: 0x9C6B,
	7005: 0x9C68,
	7006: 0x9C6E,
	7007: 0x9C70,
	7008: 0x9C72,
	7009: 0x9C75,
	7010: 0x9C77,
	7011: 0x9C7B,
	7012: 0x9CE6,
	7013: 0x9CF2,
	7014: 0x9CF7,
	7015: 0x9CF9,
	7016: 0x9D0B,
	7017: 0x9D02,
	7018: 0x9D11,
	7019: 0x9D17,
	7020: 0x9D18,
	7021: 0x9D1C,
	7022: 0x9D1D,
	7023: 0x9D1E,
	7024: 0x9D2F,
	7025: 0x9D30,
	7026: 0x9D32,
	7027: 0x9D33,
	7028: 0x9D34,
	7029: 0x9D3A,
	7030: 0x9D3C,
	7031: 0x9D45,
	7032: 0x9D3D,
	7033: 0x9D42,
	7034: 0x9D43,
	7035: 0x9D47,
	7036: 0x9D4A,
	7037: 0x9D53,
	7038: 0x9D54,
	7039: 0x9D5F,
	7040: 0x9D63,
	7041: 0x9D62,
	7042: 0x9D65,
	7043: 0x9D69,
	7044: 0x9D6A,
	7045: 0x9D6B,
	7046: 0x9D70,
	7047: 0x9D76,
	7048: 0x9D77,
	7049: 0x9D7B,
	7050: 0x9D7C,
	7051: 0x9D7E,
	7052: 0x9D83,
	7053: 0x9D84,
	7054: 0x9D86,
	7055: 0x9D8A,
	7056: 0x9D8D,
	7057: 0x9D8E,
	7058: 0x9D92,
	7059: 0x9D93,
	7060: 0x9D95,
	7061: 0x9D96,
	7062: 0x9D97,
	7063: 0x9D98,
	7064: 0x9DA1,
	7065: 0x9DAA,
	7066: 0x9DAC,
	7067: 0x9DAE,
	7068: 0x9DB1,
	7069: 0x9DB5,
	7070: 0x9DB9,
	7071: 0x9DBC,
	7072: 0x9DBF,
	7073: 0x9DC3,
	7074: 0x9DC7,
	7075: 0x9DC9,
	7076: 0x9DCA,
	7077: 0x9DD4,
	7078: 0x9DD5,
	7079: 0x9DD6,
	7080: 0x9DD7,
	7081: 0x9DDA,
	7082: 0x9DDE,
	7083: 0x9DDF,
	7084: 0x9DE0,
	7085: 0x9DE5,
	7086: 0x9DE7,
	7087: 0x9DE9,
	7088: 0x9DEB,
	7089: 0x9DEE,
	7090: 0x9DF0,
	7091: 0x9DF3,
	7092: 0x9DF4,
	7093: 0x9DFE,
	7094: 0x9E0A,
	7095: 0x9E02,
	7096: 0x9E07,
	7097: 0x9E0E,
	7098: 0x9E10,
	7099: 0x9E11,
	7100: 0x9E12,
	7101: 0x9E15,
	7102: 0x9E16,
	7103: 0x9E19,
	7104: 0x9E1C,
	7105: 0x9E1D,
	7106: 0x9E7A,
	7107: 0x9E7B,
	7108: 0x9E7C,
	7109: 0x9E80,
	7110: 0x9E82,
	7111: 0x9E83,
	7112: 0x9E84,
	7113: 0x9E85,
	7114: 0x9E87,
	7115: 0x9E8E,
	7116: 0x9E8F,
	7117: 0x9E96,
	7118: 0x9E98,
	7119: 0x9E9B,
	7120: 0x9E9E,
	7121: 0x9EA4,
	7122: 0x9EA8,
	7123: 0x9EAC,
	7124: 0x9EAE,
	7125: 0x9EAF,
	7126: 0x9EB0,
	7127: 0x9EB3,
	7128: 0x9EB4,
	7129: 0x9EB5,
	7130: 0x9EC6,
	7131: 0x9EC8,
	7132: 0x9ECB,
	7133: 0x9ED5,
	7134: 0x9EDF,
	7135: 0x9EE4,
	7136: 0x9EE7,
	7137: 0x9EEC,
	7138: 0x9EED,
	7139: 0x9EEE,
	7140: 0x9EF0,
	7141: 0x9EF1,
	7142: 0x9EF2,
	7143: 0x9EF5,
	7144: 0x9EF8,
	7145: 0x9EFF,
	7146: 0x9F02,
	7147: 0x9F03,
	7148: 0x9F09,
	7149: 0x9F0F,
	7150: 0x9F10,
	7151: 0x9F11,
	7152: 0x9F12,
	7153: 0x9F14,
	7154: 0x9F16,
	7155: 0x9F17,
	7156: 0x9F19,
	7157: 0x9F1A,
	7158: 0x9F1B,
	7159: 0x9F1F,
	7160: 0x9F22,
	7161: 0x9F26,
	7162: 0x9F2A,
	7163: 0x9F2B,
	7164: 0x9F2F,
	7165: 0x9F31,
	7166: 0x9F32,
	7167: 0x9F34,
	7168: 0x9F37,
	7169: 0x9F39,
	7170: 0x9F3A,
	7171: 0x9F3C,
	7172: 0x9F3D,
	7173: 0x9F3F,
	7174: 0x9F41,
	7175: 0x9F43,
	7176: 0x9F44,
	7177: 0x9F45,
	7178: 0x9F46,
	7179: 0x9F47,
	7180: 0x9F53,
	7181: 0x9F55,
	7182: 0x9F56,
	7183: 0x9F57,
	7184: 0x9F58,
	7185: 0x9F5A,
	7186: 0x9F5D,
	7187: 0x9F5E,
	7188: 0x9F68,
	7189: 0x9F69,
	7190: 0x9F6D,
	7191: 0x9F6E,
	7192: 0x9F6F,
	7193: 0x9F70,
	7194: 0x9F71,
	7195: 0x9F73,
	7196: 0x9F75,
	7197: 0x9F7A,
	7198: 0x9F7D,
	7199: 0x9F8F,
	7200: 0x9F90,
	7201: 0x9F91,
	7202: 0x9F92,
	7203: 0x9F94,
	7204: 0x9F96,
	7205: 0x9F97,
	7206: 0x9F9E,
	7207: 0x9FA1,
	7208: 0x9FA2,
	7209: 0x9FA3,
	7210: 0x9FA5,
}

const (
	jis0208    = 1
	jis0212    = 2
	codeMask   = 0x7f
	codeShift  = 7
	tableShift = 14
)

const numEncodeTables = 6

// encodeX are the encoding tables from Unicode to JIS code,
// sorted by decreasing length.
// encode0: 20902 entries for runes in [19968, 40870).
// encode1:  1632 entries for runes in [ 8208,  9840).
// encode2:   974 entries for runes in [12288, 13262).
// encode3:   959 entries for runes in [  161,  1120).
// encode4:   261 entries for runes in [63785, 64046).
// encode5:   229 entries for runes in [65281, 65510).
//
// The high two bits of the value record whether the JIS code comes from the
// JIS0208 table (high bits == 1) or the JIS0212 table (high bits == 2).
// The low 14 bits are two 7-bit unsigned integers j1 and j2 that form the
// JIS code (94*j1 + j2) within that table.

const encode0Low, encode0High = 19968, 40870

var encode0 = [...]uint16{
	19968 - 19968: jis0208<<14 | 0x0F<<7 | 0x4B,
	19969 - 19968: jis0208<<14 | 0x22<<7 | 0x59,
	19970 - 19968: jis0212<<14 | 0x0F<<7 | 0x00,
	19971 - 19968: jis0208<<14 | 0x1B<<7 | 0x16,
	19972 - 19968: jis0212<<14 | 0x0F<<7 | 0x01,
	19973 - 19968: jis0212<<14 | 0x0F<<7 | 0x02,
	19975 - 19968: jis0208<<14 | 0x2A<<7 | 0x5B,
	19976 - 19968: jis0208<<14 | 0x1D<<7 | 0x45,
	19977 - 19968: jis0208<<14 | 0x1A<<7 | 0x0F,
	19978 - 19968: jis0208<<14 | 0x1D<<7 | 0x44,
	19979 - 19968: jis0208<<14 | 0x11<<7 | 0x1B,
	19980 - 19968: jis0212<<14 | 0x0F<<7 | 0x03,
	19981 - 19968: jis0208<<14 | 0x28<<7 | 0x33,
	19982 - 19968: jis0208<<14 | 0x2C<<7 | 0x1E,
	19984 - 19968: jis0208<<14 | 0x2F<<7 | 0x01,
	19985 - 19968: jis0208<<14 | 0x10<<7 | 0x0E,
	19986 - 19968: jis0212<<14 | 0x0F<<7 | 0x04,
	19988 - 19968: jis0208<<14 | 0x12<<7 | 0x4D,
	19989 - 19968: jis0208<<14 | 0x2F<<7 | 0x02,
	19990 - 19968: jis0208<<14 | 0x1F<<7 | 0x03,
	19991 - 19968: jis0208<<14 | 0x31<<7 | 0x21,
	19992 - 19968: jis0208<<14 | 0x14<<7 | 0x35,
	19993 - 19968: jis0208<<14 | 0x29<<7 | 0x19,
	19998 - 19968: jis0208<<14 | 0x1D<<7 | 0x46,
	19999 - 19968: jis0212<<14 | 0x0F<<7 | 0x05,
	20001 - 19968: jis0208<<14 | 0x2D<<7 | 0x1D,
	20003 - 19968: jis0212<<14 | 0x0F<<7 | 0x06,
	20004 - 19968: jis0212<<14 | 0x0F<<7 | 0x07,
	20006 - 19968: jis0208<<14 | 0x29<<7 | 0x21,
	20008 - 19968: jis0208<<14 | 0x58<<7 | 0x0C,
	20010 - 19968: jis0208<<14 | 0x2F<<7 | 0x03,
	20011 - 19968: jis0212<<14 | 0x0F<<7 | 0x09,
	20013 - 19968: jis0208<<14 | 0x22<<7 | 0x45,
	20014 - 19968: jis0212<<14 | 0x0F<<7 | 0x0A,
	20015 - 19968: jis0212<<14 | 0x0F<<7 | 0x0B,
	20016 - 19968: jis0212<<14 | 0x0F<<7 | 0x0C,
	20017 - 19968: jis0208<<14 | 0x2F<<7 | 0x04,
	20018 - 19968: jis0208<<14 | 0x15<<7 | 0x59,
	20021 - 19968: jis0212<<14 | 0x0F<<7 | 0x0D,
	20022 - 19968: jis0208<<14 | 0x2F<<7 | 0x05,
	20024 - 19968: jis0208<<14 | 0x13<<7 | 0x3C,
	20025 - 19968: jis0208<<14 | 0x22<<7 | 0x0F,
	20027 - 19968: jis0208<<14 | 0x1B<<7 | 0x46,
	20028 - 19968: jis0208<<14 | 0x2F<<7 | 0x06,
	20031 - 19968: jis0208<<14 | 0x2F<<7 | 0x07,
	20032 - 19968: jis0212<<14 | 0x0F<<7 | 0x0E,
	20033 - 19968: jis0212<<14 | 0x0F<<7 | 0x0F,
	20034 - 19968: jis0208<<14 | 0x2F<<7 | 0x08,
	20035 - 19968: jis0208<<14 | 0x26<<7 | 0x14,
	20036 - 19968: jis0212<<14 | 0x0F<<7 | 0x10,
	20037 - 19968: jis0208<<14 | 0x14<<7 | 0x36,
	20039 - 19968: jis0212<<14 | 0x0F<<7 | 0x11,
	20043 - 19968: jis0208<<14 | 0x26<<7 | 0x16,
	20045 - 19968: jis0208<<14 | 0x25<<7 | 0x42,
	20046 - 19968: jis0208<<14 | 0x17<<7 | 0x22,
	20047 - 19968: jis0208<<14 | 0x2A<<7 | 0x12,
	20049 - 19968: jis0212<<14 | 0x0F<<7 | 0x12,
	20053 - 19968: jis0208<<14 | 0x48<<7 | 0x28,
	20054 - 19968: jis0208<<14 | 0x2F<<7 | 0x09,
	20055 - 19968: jis0208<<14 | 0x1D<<7 | 0x47,
	20056 - 19968: jis0208<<14 | 0x2F<<7 | 0x0A,
	20057 - 19968: jis0208<<14 | 0x11<<7 | 0x14,
	20058 - 19968: jis0212<<14 | 0x0F<<7 | 0x13,
	20060 - 19968: jis0212<<14 | 0x0F<<7 | 0x14,
	20061 - 19968: jis0208<<14 | 0x15<<7 | 0x44,
	20062 - 19968: jis0208<<14 | 0x17<<7 | 0x4F,
	20063 - 19968: jis0208<<14 | 0x2B<<7 | 0x48,
	20066 - 19968: jis0208<<14 | 0x35<<7 | 0x05,
	20067 - 19968: jis0212<<14 | 0x0F<<7 | 0x15,
	20072 - 19968: jis0212<<14 | 0x0F<<7 | 0x16,
	20073 - 19968: jis0212<<14 | 0x0F<<7 | 0x17,
	20081 - 19968: jis0208<<14 | 0x2C<<7 | 0x4F,
	20083 - 19968: jis0208<<14 | 0x25<<7 | 0x5C,
	20084 - 19968: jis0212<<14 | 0x0F<<7 | 0x18,
	20085 - 19968: jis0212<<14 | 0x0F<<7 | 0x19,
	20089 - 19968: jis0212<<14 | 0x0F<<7 | 0x1A,
	20094 - 19968: jis0208<<14 | 0x13<<7 | 0x04,
	20095 - 19968: jis0212<<14 | 0x0F<<7 | 0x1B,
	20096 - 19968: jis0208<<14 | 0x14<<7 | 0x14,
	20098 - 19968: jis0208<<14 | 0x2F<<7 | 0x0B,
	20101 - 19968: jis0208<<14 | 0x2F<<7 | 0x0C,
	20102 - 19968: jis0208<<14 | 0x2D<<7 | 0x1A,
	20104 - 19968: jis0208<<14 | 0x2C<<7 | 0x1C,
	20105 - 19968: jis0208<<14 | 0x20<<7 | 0x47,
	20106 - 19968: jis0208<<14 | 0x2F<<7 | 0x0E,
	20107 - 19968: jis0208<<14 | 0x1A<<7 | 0x55,
	20108 - 19968: jis0208<<14 | 0x25<<7 | 0x52,
	20109 - 19968: jis0212<<14 | 0x0F<<7 | 0x1C,
	20110 - 19968: jis0208<<14 | 0x2F<<7 | 0x11,
	20113 - 19968: jis0208<<14 | 0x10<<7 | 0x1D,
	20114 - 19968: jis0208<<14 | 0x17<<7 | 0x3E,
	20116 - 19968: jis0208<<14 | 0x17<<7 | 0x3D,
	20117 - 19968: jis0208<<14 | 0x0F<<7 | 0x45,
	20118 - 19968: jis0212<<14 | 0x0F<<7 | 0x1D,
	20119 - 19968: jis0212<<14 | 0x0F<<7 | 0x1E,
	20120 - 19968: jis0208<<14 | 0x2E<<7 | 0x2A,
	20121 - 19968: jis0208<<14 | 0x2E<<7 | 0x29,
	20123 - 19968: jis0208<<14 | 0x19<<7 | 0x12,
	20124 - 19968: jis0208<<14 | 0x0F<<7 | 0x00,
	20125 - 19968: jis0212<<14 | 0x0F<<7 | 0x1F,
	20126 - 19968: jis0208<<14 | 0x2F<<7 | 0x12,
	20127 - 19968: jis0208<<14 | 0x2F<<7 | 0x13,
	20128 - 19968: jis0208<<14 | 0x2F<<7 | 0x14,
	20129 - 19968: jis0208<<14 | 0x2A<<7 | 0x13,
	20130 - 19968: jis0208<<14 | 0x2F<<7 | 0x15,
	20132 - 19968: jis0208<<14 | 0x17<<7 | 0x51,
	20133 - 19968: jis0208<<14 | 0x0F<<7 | 0x46,
	20134 - 19968: jis0208<<14 | 0x2A<<7 | 0x51,
	20136 - 19968: jis0208<<14 | 0x14<<7 | 0x5B,
	20139 - 19968: jis0208<<14 | 0x14<<7 | 0x5C,
	20140 - 19968: jis0208<<14 | 0x14<<7 | 0x5D,
	20141 - 19968: jis0208<<14 | 0x23<<7 | 0x41,
	20142 - 19968: jis0208<<14 | 0x2D<<7 | 0x1B,
	20143 - 19968: jis0212<<14 | 0x0F<<7 | 0x20,
	20144 - 19968: jis0208<<14 | 0x2F<<7 | 0x16,
	20147 - 19968: jis0208<<14 | 0x2F<<7 | 0x17,
	20150 - 19968: jis0208<<14 | 0x2F<<7 | 0x18,
	20153 - 19968: jis0212<<14 | 0x0F<<7 | 0x21,
	20154 - 19968: jis0208<<14 | 0x1E<<7 | 0x2C,
	20160 - 19968: jis0208<<14 | 0x1C<<7 | 0x19,
	20161 - 19968: jis0208<<14 | 0x1E<<7 | 0x2D,
	20162 - 19968: jis0208<<14 | 0x2F<<7 | 0x1D,
	20163 - 19968: jis0212<<14 | 0x0F<<7 | 0x22,
	20164 - 19968: jis0208<<14 | 0x2F<<7 | 0x1B,
	20166 - 19968: jis0208<<14 | 0x2F<<7 | 0x1C,
	20167 - 19968: jis0208<<14 | 0x14<<7 | 0x37,
	20170 - 19968: jis0208<<14 | 0x19<<7 | 0x02,
	20171 - 19968: jis0208<<14 | 0x11<<7 | 0x4F,
	20173 - 19968: jis0208<<14 | 0x2F<<7 | 0x1A,
	20174 - 19968: jis0208<<14 | 0x2F<<7 | 0x19,
	20175 - 19968: jis0208<<14 | 0x29<<7 | 0x08,
	20176 - 19968: jis0212<<14 | 0x0F<<7 | 0x23,
	20180 - 19968: jis0208<<14 | 0x1A<<7 | 0x25,
	20181 - 19968: jis0208<<14 | 0x1A<<7 | 0x24,
	20182 - 19968: jis0208<<14 | 0x21<<7 | 0x1D,
	20183 - 19968: jis0208<<14 | 0x2F<<7 | 0x1E,
	20184 - 19968: jis0208<<14 | 0x28<<7 | 0x34,
	20185 - 19968: jis0208<<14 | 0x1F<<7 | 0x46,
	20186 - 19968: jis0212<<14 | 0x0F<<7 | 0x24,
	20187 - 19968: jis0212<<14 | 0x0F<<7 | 0x25,
	20189 - 19968: jis0208<<14 | 0x00<<7 | 0x17,
	20190 - 19968: jis0208<<14 | 0x2F<<7 | 0x1F,
	20191 - 19968: jis0208<<14 | 0x2F<<7 | 0x21,
	20192 - 19968: jis0212<<14 | 0x0F<<7 | 0x26,
	20193 - 19968: jis0208<<14 | 0x58<<7 | 0x0D,
	20194 - 19968: jis0212<<14 | 0x0F<<7 | 0x28,
	20195 - 19968: jis0208<<14 | 0x21<<7 | 0x44,
	20196 - 19968: jis0208<<14 | 0x2D<<7 | 0x40,
	20197 - 19968: jis0208<<14 | 0x0F<<7 | 0x29,
	20200 - 19968: jis0212<<14 | 0x0F<<7 | 0x29,
	20205 - 19968: jis0208<<14 | 0x2F<<7 | 0x20,
	20206 - 19968: jis0208<<14 | 0x11<<7 | 0x1D,
	20207 - 19968: jis0212<<14 | 0x0F<<7 | 0x2A,
	20208 - 19968: jis0208<<14 | 0x15<<7 | 0x23,
	20209 - 19968: jis0212<<14 | 0x0F<<7 | 0x2B,
	20210 - 19968: jis0208<<14 | 0x22<<7 | 0x46,
	20211 - 19968: jis0212<<14 | 0x0F<<7 | 0x2C,
	20213 - 19968: jis0212<<14 | 0x0F<<7 | 0x2D,
	20214 - 19968: jis0208<<14 | 0x16<<7 | 0x4E,
	20215 - 19968: jis0208<<14 | 0x2F<<7 | 0x22,
	20219 - 19968: jis0208<<14 | 0x26<<7 | 0x03,
	20220 - 19968: jis0208<<14 | 0x58<<7 | 0x0E,
	20221 - 19968: jis0212<<14 | 0x0F<<7 | 0x2E,
	20222 - 19968: jis0212<<14 | 0x0F<<7 | 0x2F,
	20223 - 19968: jis0212<<14 | 0x0F<<7 | 0x30,
	20224 - 19968: jis0208<<14 | 0x58<<7 | 0x0F,
	20225 - 19968: jis0208<<14 | 0x13<<7 | 0x4A,
	20226 - 19968: jis0212<<14 | 0x0F<<7 | 0x32,
	20227 - 19968: jis0208<<14 | 0x58<<7 | 0x10,
	20232 - 19968: jis0212<<14 | 0x0F<<7 | 0x34,
	20233 - 19968: jis0208<<14 | 0x2F<<7 | 0x23,
	20234 - 19968: jis0208<<14 | 0x0F<<7 | 0x2A,
	20235 - 19968: jis0212<<14 | 0x0F<<7 | 0x35,
	20236 - 19968: jis0212<<14 | 0x0F<<7 | 0x36,
	20237 - 19968: jis0208<<14 | 0x17<<7 | 0x3F,
	20238 - 19968: jis0208<<14 | 0x13<<7 | 0x4B,
	20239 - 19968: jis0208<<14 | 0x28<<7 | 0x59,
	20240 - 19968: jis0208<<14 | 0x27<<7 | 0x11,
	20241 - 19968: jis0208<<14 | 0x14<<7 | 0x38,
	20242 - 19968: jis0212<<14 | 0x0F<<7 | 0x37,
	20245 - 19968: jis0212<<14 | 0x0F<<7 | 0x38,
	20246 - 19968: jis0212<<14 | 0x0F<<7 | 0x39,
	20247 - 19968: jis0212<<14 | 0x0F<<7 | 0x3A,
	20249 - 19968: jis0212<<14 | 0x0F<<7 | 0x3B,
	20250 - 19968: jis0208<<14 | 0x11<<7 | 0x50,
	20252 - 19968: jis0208<<14 | 0x2F<<7 | 0x46,
	20253 - 19968: jis0208<<14 | 0x24<<7 | 0x20,
	20270 - 19968: jis0212<<14 | 0x0F<<7 | 0x3C,
	20271 - 19968: jis0208<<14 | 0x26<<7 | 0x4B,
	20272 - 19968: jis0208<<14 | 0x2F<<7 | 0x25,
	20273 - 19968: jis0212<<14 | 0x0F<<7 | 0x3D,
	20275 - 19968: jis0212<<14 | 0x0F<<7 | 0x3F,
	20276 - 19968: jis0208<<14 | 0x27<<7 | 0x1B,
	20277 - 19968: jis0212<<14 | 0x0F<<7 | 0x40,
	20278 - 19968: jis0208<<14 | 0x2D<<7 | 0x41,
	20279 - 19968: jis0212<<14 | 0x0F<<7 | 0x41,
	20280 - 19968: jis0208<<14 | 0x1E<<7 | 0x0C,
	20281 - 19968: jis0208<<14 | 0x58<<7 | 0x11,
	20282 - 19968: jis0208<<14 | 0x1A<<7 | 0x26,
	20283 - 19968: jis0212<<14 | 0x0F<<7 | 0x43,
	20284 - 19968: jis0208<<14 | 0x1A<<7 | 0x56,
	20285 - 19968: jis0208<<14 | 0x11<<7 | 0x1F,
	20286 - 19968: jis0212<<14 | 0x0F<<7 | 0x44,
	20288 - 19968: jis0212<<14 | 0x0F<<7 | 0x45,
	20290 - 19968: jis0212<<14 | 0x0F<<7 | 0x46,
	20291 - 19968: jis0208<<14 | 0x23<<7 | 0x30,
	20294 - 19968: jis0208<<14 | 0x22<<7 | 0x01,
	20295 - 19968: jis0208<<14 | 0x2F<<7 | 0x29,
	20296 - 19968: jis0212<<14 | 0x0F<<7 | 0x47,
	20297 - 19968: jis0212<<14 | 0x0F<<7 | 0x48,
	20299 - 19968: jis0212<<14 | 0x0F<<7 | 0x49,
	20300 - 19968: jis0212<<14 | 0x0F<<7 | 0x4A,
	20301 - 19968: jis0208<<14 | 0x0F<<7 | 0x2B,
	20302 - 19968: jis0208<<14 | 0x23<<7 | 0x42,
	20303 - 19968: jis0208<<14 | 0x1C<<7 | 0x1A,
	20304 - 19968: jis0208<<14 | 0x19<<7 | 0x13,
	20305 - 19968: jis0208<<14 | 0x2C<<7 | 0x03,
	20306 - 19968: jis0212<<14 | 0x0F<<7 | 0x4B,
	20307 - 19968: jis0208<<14 | 0x21<<7 | 0x2D,
	20308 - 19968: jis0212<<14 | 0x0F<<7 | 0x4C,
	20309 - 19968: jis0208<<14 | 0x11<<7 | 0x1E,
	20310 - 19968: jis0208<<14 | 0x58<<7 | 0x12,
	20311 - 19968: jis0208<<14 | 0x2F<<7 | 0x28,
	20312 - 19968: jis0212<<14 | 0x0F<<7 | 0x4E,
	20313 - 19968: jis0208<<14 | 0x2C<<7 | 0x1D,
	20314 - 19968: jis0208<<14 | 0x2F<<7 | 0x24,
	20315 - 19968: jis0208<<14 | 0x2F<<7 | 0x26,
	20316 - 19968: jis0208<<14 | 0x19<<7 | 0x4D,
	20317 - 19968: jis0208<<14 | 0x2F<<7 | 0x27,
	20318 - 19968: jis0208<<14 | 0x34<<7 | 0x03,
	20319 - 19968: jis0212<<14 | 0x0F<<7 | 0x4F,
	20320 - 19968: jis0212<<14 | 0x0F<<7 | 0x3E,
	20323 - 19968: jis0212<<14 | 0x0F<<7 | 0x50,
	20329 - 19968: jis0208<<14 | 0x2F<<7 | 0x2F,
	20330 - 19968: jis0212<<14 | 0x0F<<7 | 0x51,
	20332 - 19968: jis0212<<14 | 0x0F<<7 | 0x52,
	20334 - 19968: jis0212<<14 | 0x0F<<7 | 0x53,
	20335 - 19968: jis0208<<14 | 0x2F<<7 | 0x32,
	20336 - 19968: jis0208<<14 | 0x2F<<7 | 0x30,
	20337 - 19968: jis0212<<14 | 0x0F<<7 | 0x54,
	20339 - 19968: jis0208<<14 | 0x11<<7 | 0x21,
	20341 - 19968: jis0208<<14 | 0x29<<7 | 0x1A,
	20342 - 19968: jis0208<<14 | 0x2F<<7 | 0x2A,
	20343 - 19968: jis0212<<14 | 0x0F<<7 | 0x55,
	20344 - 19968: jis0212<<14 | 0x0F<<7 | 0x56,
	20345 - 19968: jis0212<<14 | 0x0F<<7 | 0x57,
	20346 - 19968: jis0212<<14 | 0x0F<<7 | 0x58,
	20347 - 19968: jis0208<<14 | 0x2F<<7 | 0x2E,
	20348 - 19968: jis0208<<14 | 0x17<<7 | 0x52,
	20349 - 19968: jis0212<<14 | 0x0F<<7 | 0x59,
	20350 - 19968: jis0212<<14 | 0x0F<<7 | 0x5A,
	20351 - 19968: jis0208<<14 | 0x1A<<7 | 0x27,
	20353 - 19968: jis0212<<14 | 0x0F<<7 | 0x5B,
	20354 - 19968: jis0212<<14 | 0x0F<<7 | 0x5C,
	20355 - 19968: jis0208<<14 | 0x13<<7 | 0x05,
	20356 - 19968: jis0212<<14 | 0x0F<<7 | 0x5D,
	20357 - 19968: jis0212<<14 | 0x10<<7 | 0x00,
	20358 - 19968: jis0208<<14 | 0x2F<<7 | 0x33,
	20360 - 19968: jis0208<<14 | 0x2F<<7 | 0x2B,
	20361 - 19968: jis0212<<14 | 0x10<<7 | 0x01,
	20362 - 19968: jis0208<<14 | 0x58<<7 | 0x14,
	20363 - 19968: jis0208<<14 | 0x2D<<7 | 0x42,
	20364 - 19968: jis0212<<14 | 0x10<<7 | 0x03,
	20365 - 19968: jis0208<<14 | 0x1A<<7 | 0x57,
	20366 - 19968: jis0212<<14 | 0x10<<7 | 0x04,
	20367 - 19968: jis0208<<14 | 0x2F<<7 | 0x2C,
	20368 - 19968: jis0212<<14 | 0x10<<7 | 0x05,
	20369 - 19968: jis0208<<14 | 0x2F<<7 | 0x31,
	20370 - 19968: jis0208<<14 | 0x58<<7 | 0x13,
	20371 - 19968: jis0212<<14 | 0x10<<7 | 0x07,
	20372 - 19968: jis0208<<14 | 0x58<<7 | 0x16,
	20374 - 19968: jis0208<<14 | 0x2F<<7 | 0x34,
	20375 - 19968: jis0212<<14 | 0x10<<7 | 0x09,
	20376 - 19968: jis0208<<14 | 0x2F<<7 | 0x2D,
	20377 - 19968: jis0212<<14 | 0x10<<7 | 0x0A,
	20378 - 19968: jis0208<<14 | 0x58<<7 | 0x15,
	20379 - 19968: jis0208<<14 | 0x15<<7 | 0x00,
	20381 - 19968: jis0208<<14 | 0x0F<<7 | 0x2C,
	20382 - 19968: jis0212<<14 | 0x10<<7 | 0x0C,
	20383 - 19968: jis0212<<14 | 0x10<<7 | 0x0D,
	20384 - 19968: jis0208<<14 | 0x15<<7 | 0x01,
	20385 - 19968: jis0208<<14 | 0x11<<7 | 0x20,
	20395 - 19968: jis0208<<14 | 0x34<<7 | 0x04,
	20397 - 19968: jis0208<<14 | 0x2A<<7 | 0x58,
	20398 - 19968: jis0208<<14 | 0x28<<7 | 0x4D,
	20399 - 19968: jis0208<<14 | 0x17<<7 | 0x53,
	20402 - 19968: jis0212<<14 | 0x10<<7 | 0x0E,
	20405 - 19968: jis0208<<14 | 0x1E<<7 | 0x0E,
	20406 - 19968: jis0208<<14 | 0x2D<<7 | 0x16,
	20407 - 19968: jis0212<<14 | 0x10<<7 | 0x0F,
	20409 - 19968: jis0212<<14 | 0x10<<7 | 0x10,
	20411 - 19968: jis0212<<14 | 0x10<<7 | 0x11,
	20412 - 19968: jis0212<<14 | 0x10<<7 | 0x12,
	20413 - 19968: jis0212<<14 | 0x10<<7 | 0x13,
	20414 - 19968: jis0212<<14 | 0x10<<7 | 0x14,
	20415 - 19968: jis0208<<14 | 0x29<<7 | 0x37,
	20416 - 19968: jis0212<<14 | 0x10<<7 | 0x15,
	20417 - 19968: jis0212<<14 | 0x10<<7 | 0x16,
	20418 - 19968: jis0208<<14 | 0x16<<7 | 0x17,
	20419 - 19968: jis0208<<14 | 0x21<<7 | 0x04,
	20420 - 19968: jis0208<<14 | 0x11<<7 | 0x43,
	20421 - 19968: jis0212<<14 | 0x10<<7 | 0x17,
	20422 - 19968: jis0212<<14 | 0x10<<7 | 0x18,
	20424 - 19968: jis0212<<14 | 0x10<<7 | 0x19,
	20425 - 19968: jis0208<<14 | 0x58<<7 | 0x05,
	20426 - 19968: jis0208<<14 | 0x1C<<7 | 0x32,
	20427 - 19968: jis0212<<14 | 0x10<<7 | 0x1B,
	20428 - 19968: jis0212<<14 | 0x10<<7 | 0x1C,
	20429 - 19968: jis0208<<14 | 0x58<<7 | 0x17,
	20430 - 19968: jis0208<<14 | 0x2F<<7 | 0x38,
	20431 - 19968: jis0212<<14 | 0x10<<7 | 0x1E,
	20432 - 19968: jis0208<<14 | 0x2F<<7 | 0x3D,
	20433 - 19968: jis0208<<14 | 0x2F<<7 | 0x3B,
	20434 - 19968: jis0212<<14 | 0x10<<7 | 0x1F,
	20436 - 19968: jis0208<<14 | 0x2F<<7 | 0x36,
	20439 - 19968: jis0208<<14 | 0x21<<7 | 0x0E,
	20440 - 19968: jis0208<<14 | 0x2F<<7 | 0x39,
	20442 - 19968: jis0208<<14 | 0x2F<<7 | 0x3C,
	20443 - 19968: jis0208<<14 | 0x2F<<7 | 0x3A,
	20444 - 19968: jis0212<<14 | 0x10<<7 | 0x20,
	20445 - 19968: jis0208<<14 | 0x29<<7 | 0x3C,
	20447 - 19968: jis0208<<14 | 0x2F<<7 | 0x37,
	20448 - 19968: jis0212<<14 | 0x10<<7 | 0x21,
	20449 - 19968: jis0208<<14 | 0x1E<<7 | 0x0D,
	20450 - 19968: jis0212<<14 | 0x10<<7 | 0x22,
	20451 - 19968: jis0208<<14 | 0x2A<<7 | 0x52,
	20452 - 19968: jis0208<<14 | 0x2F<<7 | 0x3E,
	20453 - 19968: jis0208<<14 | 0x2F<<7 | 0x3F,
	20462 - 19968: jis0208<<14 | 0x1C<<7 | 0x03,
	20463 - 19968: jis0208<<14 | 0x2F<<7 | 0x4C,
	20464 - 19968: jis0212<<14 | 0x10<<7 | 0x23,
	20466 - 19968: jis0212<<14 | 0x10<<7 | 0x24,
	20467 - 19968: jis0208<<14 | 0x26<<7 | 0x2F,
	20469 - 19968: jis0208<<14 | 0x28<<7 | 0x15,
	20470 - 19968: jis0208<<14 | 0x2F<<7 | 0x47,
	20472 - 19968: jis0208<<14 | 0x29<<7 | 0x4F,
	20474 - 19968: jis0208<<14 | 0x11<<7 | 0x15,
	20476 - 19968: jis0212<<14 | 0x10<<7 | 0x25,
	20477 - 19968: jis0212<<14 | 0x10<<7 | 0x26,
	20478 - 19968: jis0208<<14 | 0x2F<<7 | 0x4B,
	20479 - 19968: jis0208<<14 | 0x58<<7 | 0x1A,
	20480 - 19968: jis0212<<14 | 0x10<<7 | 0x28,
	20481 - 19968: jis0212<<14 | 0x10<<7 | 0x29,
	20484 - 19968: jis0212<<14 | 0x10<<7 | 0x2A,
	20485 - 19968: jis0208<<14 | 0x2F<<7 | 0x45,
	20486 - 19968: jis0208<<14 | 0x2F<<7 | 0x4E,
	20487 - 19968: jis0212<<14 | 0x10<<7 | 0x2B,
	20489 - 19968: jis0208<<14 | 0x20<<7 | 0x31,
	20490 - 19968: jis0212<<14 | 0x10<<7 | 0x2C,
	20491 - 19968: jis0208<<14 | 0x17<<7 | 0x23,
	20492 - 19968: jis0212<<14 | 0x10<<7 | 0x2D,
	20493 - 19968: jis0208<<14 | 0x26<<7 | 0x3B,
	20494 - 19968: jis0212<<14 | 0x10<<7 | 0x2E,
	20495 - 19968: jis0208<<14 | 0x3F<<7 | 0x26,
	20496 - 19968: jis0212<<14 | 0x10<<7 | 0x2F,
	20497 - 19968: jis0208<<14 | 0x2F<<7 | 0x4D,
	20498 - 19968: jis0208<<14 | 0x24<<7 | 0x3C,
	20499 - 19968: jis0212<<14 | 0x10<<7 | 0x30,
	20500 - 19968: jis0208<<14 | 0x2F<<7 | 0x42,
	20502 - 19968: jis0208<<14 | 0x17<<7 | 0x55,
	20503 - 19968: jis0212<<14 | 0x10<<7 | 0x31,
	20504 - 19968: jis0212<<14 | 0x10<<7 | 0x32,
	20505 - 19968: jis0208<<14 | 0x17<<7 | 0x54,
	20506 - 19968: jis0208<<14 | 0x2F<<7 | 0x40,
	20507 - 19968: jis0212<<14 | 0x10<<7 | 0x33,
	20508 - 19968: jis0212<<14 | 0x10<<7 | 0x34,
	20509 - 19968: jis0212<<14 | 0x10<<7 | 0x35,
	20510 - 19968: jis0208<<14 | 0x58<<7 | 0x1B,
	20511 - 19968: jis0208<<14 | 0x1B<<7 | 0x39,
	20513 - 19968: jis0208<<14 | 0x2F<<7 | 0x48,
	20514 - 19968: jis0208<<14 | 0x58<<7 | 0x19,
	20515 - 19968: jis0208<<14 | 0x29<<7 | 0x4E,
	20516 - 19968: jis0208<<14 | 0x22<<7 | 0x2C,
	20517 - 19968: jis0208<<14 | 0x2F<<7 | 0x44,
	20518 - 19968: jis0208<<14 | 0x16<<7 | 0x50,
	20519 - 19968: jis0212<<14 | 0x10<<7 | 0x38,
	20520 - 19968: jis0208<<14 | 0x2F<<7 | 0x41,
	20521 - 19968: jis0208<<14 | 0x2F<<7 | 0x49,
	20522 - 19968: jis0208<<14 | 0x2F<<7 | 0x43,
	20523 - 19968: jis0208<<14 | 0x2D<<7 | 0x30,
	20524 - 19968: jis0208<<14 | 0x2F<<7 | 0x4A,
	20525 - 19968: jis0208<<14 | 0x2E<<7 | 0x20,
	20526 - 19968: jis0212<<14 | 0x10<<7 | 0x39,
	20528 - 19968: jis0212<<14 | 0x10<<7 | 0x3A,
	20530 - 19968: jis0212<<14 | 0x10<<7 | 0x3B,
	20531 - 19968: jis0212<<14 | 0x10<<7 | 0x3C,
	20533 - 19968: jis0212<<14 | 0x10<<7 | 0x3D,
	20534 - 19968: jis0208<<14 | 0x15<<7 | 0x45,
	20537 - 19968: jis0208<<14 | 0x16<<7 | 0x4F,
	20539 - 19968: jis0212<<14 | 0x10<<7 | 0x55,
	20544 - 19968: jis0208<<14 | 0x58<<7 | 0x18,
	20545 - 19968: jis0212<<14 | 0x10<<7 | 0x3F,
	20546 - 19968: jis0208<<14 | 0x58<<7 | 0x1E,
	20547 - 19968: jis0208<<14 | 0x2F<<7 | 0x4F,
	20549 - 19968: jis0212<<14 | 0x10<<7 | 0x41,
	20550 - 19968: jis0208<<14 | 0x58<<7 | 0x1C,
	20551 - 19968: jis0208<<14 | 0x2F<<7 | 0x50,
	20552 - 19968: jis0208<<14 | 0x2F<<7 | 0x54,
	20553 - 19968: jis0208<<14 | 0x0F<<7 | 0x2D,
	20554 - 19968: jis0212<<14 | 0x10<<7 | 0x43,
	20556 - 19968: jis0212<<14 | 0x10<<7 | 0x44,
	20558 - 19968: jis0212<<14 | 0x10<<7 | 0x45,
	20559 - 19968: jis0208<<14 | 0x29<<7 | 0x2F,
	20560 - 19968: jis0208<<14 | 0x2F<<7 | 0x53,
	20561 - 19968: jis0212<<14 | 0x10<<7 | 0x46,
	20562 - 19968: jis0212<<14 | 0x10<<7 | 0x47,
	20563 - 19968: jis0212<<14 | 0x10<<7 | 0x48,
	20565 - 19968: jis0208<<14 | 0x2F<<7 | 0x52,
	20566 - 19968: jis0208<<14 | 0x2F<<7 | 0x56,
	20567 - 19968: jis0212<<14 | 0x10<<7 | 0x49,
	20569 - 19968: jis0212<<14 | 0x10<<7 | 0x4A,
	20570 - 19968: jis0208<<14 | 0x2F<<7 | 0x55,
	20572 - 19968: jis0208<<14 | 0x23<<7 | 0x43,
	20575 - 19968: jis0212<<14 | 0x10<<7 | 0x4B,
	20576 - 19968: jis0212<<14 | 0x10<<7 | 0x4C,
	20578 - 19968: jis0212<<14 | 0x10<<7 | 0x4D,
	20579 - 19968: jis0212<<14 | 0x10<<7 | 0x4E,
	20581 - 19968: jis0208<<14 | 0x16<<7 | 0x51,
	20582 - 19968: jis0212<<14 | 0x10<<7 | 0x4F,
	20583 - 19968: jis0212<<14 | 0x10<<7 | 0x50,
	20586 - 19968: jis0212<<14 | 0x10<<7 | 0x51,
	20588 - 19968: jis0208<<14 | 0x2F<<7 | 0x57,
	20589 - 19968: jis0212<<14 | 0x10<<7 | 0x52,
	20592 - 19968: jis0208<<14 | 0x58<<7 | 0x1D,
	20593 - 19968: jis0212<<14 | 0x10<<7 | 0x54,
	20594 - 19968: jis0208<<14 | 0x1B<<7 | 0x24,
	20596 - 19968: jis0208<<14 | 0x21<<7 | 0x05,
	20597 - 19968: jis0208<<14 | 0x23<<7 | 0x44,
	20598 - 19968: jis0208<<14 | 0x15<<7 | 0x55,
	20600 - 19968: jis0208<<14 | 0x2F<<7 | 0x58,
	20605 - 19968: jis0208<<14 | 0x14<<7 | 0x15,
	20608 - 19968: jis0208<<14 | 0x2F<<7 | 0x59,
	20609 - 19968: jis0212<<14 | 0x10<<7 | 0x56,
	20611 - 19968: jis0212<<14 | 0x10<<7 | 0x57,
	20612 - 19968: jis0212<<14 | 0x10<<7 | 0x58,
	20613 - 19968: jis0208<<14 | 0x2F<<7 | 0x5B,
	20614 - 19968: jis0212<<14 | 0x10<<7 | 0x59,
	20618 - 19968: jis0212<<14 | 0x10<<7 | 0x5A,
	20621 - 19968: jis0208<<14 | 0x2A<<7 | 0x14,
	20622 - 19968: jis0212<<14 | 0x10<<7 | 0x5B,
	20623 - 19968: jis0212<<14 | 0x10<<7 | 0x5C,
	20624 - 19968: jis0212<<14 | 0x10<<7 | 0x5D,
	20625 - 19968: jis0208<<14 | 0x16<<7 | 0x45,
	20626 - 19968: jis0212<<14 | 0x11<<7 | 0x00,
	20627 - 19968: jis0212<<14 | 0x11<<7 | 0x01,
	20628 - 19968: jis0208<<14 | 0x58<<7 | 0x1F,
	20630 - 19968: jis0212<<14 | 0x11<<7 | 0x03,
	20632 - 19968: jis0208<<14 | 0x1A<<7 | 0x10,
	20633 - 19968: jis0208<<14 | 0x27<<7 | 0x56,
	20634 - 19968: jis0208<<14 | 0x2F<<7 | 0x5A,
	20635 - 19968: jis0212<<14 | 0x11<<7 | 0x04,
	20636 - 19968: jis0212<<14 | 0x11<<7 | 0x05,
	20638 - 19968: jis0212<<14 | 0x11<<7 | 0x06,
	20639 - 19968: jis0212<<14 | 0x11<<7 | 0x07,
	20640 - 19968: jis0212<<14 | 0x11<<7 | 0x08,
	20641 - 19968: jis0212<<14 | 0x11<<7 | 0x09,
	20642 - 19968: jis0212<<14 | 0x11<<7 | 0x0A,
	20650 - 19968: jis0212<<14 | 0x11<<7 | 0x0B,
	20652 - 19968: jis0208<<14 | 0x19<<7 | 0x24,
	20653 - 19968: jis0208<<14 | 0x2C<<7 | 0x22,
	20655 - 19968: jis0212<<14 | 0x11<<7 | 0x0C,
	20656 - 19968: jis0212<<14 | 0x11<<7 | 0x0D,
	20658 - 19968: jis0208<<14 | 0x2F<<7 | 0x5D,
	20659 - 19968: jis0208<<14 | 0x30<<7 | 0x02,
	20660 - 19968: jis0208<<14 | 0x2F<<7 | 0x5C,
	20661 - 19968: jis0208<<14 | 0x19<<7 | 0x23,
	20663 - 19968: jis0208<<14 | 0x1C<<7 | 0x5C,
	20665 - 19968: jis0212<<14 | 0x11<<7 | 0x0E,
	20666 - 19968: jis0212<<14 | 0x11<<7 | 0x0F,
	20669 - 19968: jis0212<<14 | 0x11<<7 | 0x10,
	20670 - 19968: jis0208<<14 | 0x16<<7 | 0x18,
	20672 - 19968: jis0212<<14 | 0x11<<7 | 0x11,
	20674 - 19968: jis0208<<14 | 0x30<<7 | 0x03,
	20675 - 19968: jis0212<<14 | 0x11<<7 | 0x12,
	20676 - 19968: jis0212<<14 | 0x11<<7 | 0x13,
	20677 - 19968: jis0208<<14 | 0x15<<7 | 0x2E,
	20679 - 19968: jis0212<<14 | 0x11<<7 | 0x14,
	20681 - 19968: jis0208<<14 | 0x30<<7 | 0x00,
	20682 - 19968: jis0208<<14 | 0x30<<7 | 0x01,
	20684 - 19968: jis0212<<14 | 0x11<<7 | 0x15,
	20685 - 19968: jis0208<<14 | 0x25<<7 | 0x0E,
	20686 - 19968: jis0212<<14 | 0x11<<7 | 0x16,
	20687 - 19968: jis0208<<14 | 0x20<<7 | 0x5B,
	20688 - 19968: jis0212<<14 | 0x11<<7 | 0x17,
	20689 - 19968: jis0208<<14 | 0x15<<7 | 0x02,
	20691 - 19968: jis0212<<14 | 0x11<<7 | 0x18,
	20692 - 19968: jis0212<<14 | 0x11<<7 | 0x19,
	20693 - 19968: jis0208<<14 | 0x2A<<7 | 0x2C,
	20694 - 19968: jis0208<<14 | 0x30<<7 | 0x04,
	20696 - 19968: jis0208<<14 | 0x58<<7 | 0x21,
	20698 - 19968: jis0208<<14 | 0x2D<<7 | 0x1C,
	20700 - 19968: jis0212<<14 | 0x11<<7 | 0x1B,
	20701 - 19968: jis0212<<14 | 0x11<<7 | 0x1C,
	20702 - 19968: jis0208<<14 | 0x30<<7 | 0x05,
	20703 - 19968: jis0212<<14 | 0x11<<7 | 0x1D,
	20706 - 19968: jis0212<<14 | 0x11<<7 | 0x1E,
	20707 - 19968: jis0208<<14 | 0x30<<7 | 0x08,
	20708 - 19968: jis0212<<14 | 0x11<<7 | 0x1F,
	20709 - 19968: jis0208<<14 | 0x30<<7 | 0x06,
	20710 - 19968: jis0212<<14 | 0x11<<7 | 0x20,
	20711 - 19968: jis0208<<14 | 0x20<<7 | 0x2D,
	20712 - 19968: jis0212<<14 | 0x11<<7 | 0x21,
	20713 - 19968: jis0212<<14 | 0x11<<7 | 0x22,
	20717 - 19968: jis0208<<14 | 0x30<<7 | 0x07,
	20718 - 19968: jis0208<<14 | 0x30<<7 | 0x09,
	20719 - 19968: jis0212<<14 | 0x11<<7 | 0x23,
	20721 - 19968: jis0212<<14 | 0x11<<7 | 0x24,
	20722 - 19968: jis0212<<14 | 0x11<<7 | 0x30,
	20724 - 19968: jis0208<<14 | 0x58<<7 | 0x20,
	20725 - 19968: jis0208<<14 | 0x30<<7 | 0x0B,
	20726 - 19968: jis0212<<14 | 0x11<<7 | 0x25,
	20729 - 19968: jis0208<<14 | 0x30<<7 | 0x0A,
	20730 - 19968: jis0212<<14 | 0x11<<7 | 0x26,
	20731 - 19968: jis0208<<14 | 0x29<<7 | 0x27,
	20734 - 19968: jis0212<<14 | 0x11<<7 | 0x27,
	20736 - 19968: jis0208<<14 | 0x14<<7 | 0x16,
	20737 - 19968: jis0208<<14 | 0x30<<7 | 0x0D,
	20738 - 19968: jis0208<<14 | 0x30<<7 | 0x0E,
	20739 - 19968: jis0212<<14 | 0x11<<7 | 0x28,
	20740 - 19968: jis0208<<14 | 0x11<<7 | 0x0E,
	20742 - 19968: jis0212<<14 | 0x11<<7 | 0x29,
	20743 - 19968: jis0212<<14 | 0x11<<7 | 0x2A,
	20744 - 19968: jis0212<<14 | 0x11<<7 | 0x2B,
	20745 - 19968: jis0208<<14 | 0x30<<7 | 0x0C,
	20747 - 19968: jis0212<<14 | 0x11<<7 | 0x2C,
	20748 - 19968: jis0212<<14 | 0x11<<7 | 0x2D,
	20749 - 19968: jis0212<<14 | 0x11<<7 | 0x2E,
	20750 - 19968: jis0212<<14 | 0x11<<7 | 0x2F,
	20752 - 19968: jis0212<<14 | 0x11<<7 | 0x31,
	20754 - 19968: jis0208<<14 | 0x1B<<7 | 0x53,
	20756 - 19968: jis0208<<14 | 0x30<<7 | 0x11,
	20757 - 19968: jis0208<<14 | 0x30<<7 | 0x10,
	20758 - 19968: jis0208<<14 | 0x30<<7 | 0x0F,
	20759 - 19968: jis0212<<14 | 0x11<<7 | 0x32,
	20760 - 19968: jis0208<<14 | 0x2F<<7 | 0x35,
	20761 - 19968: jis0212<<14 | 0x11<<7 | 0x33,
	20762 - 19968: jis0208<<14 | 0x30<<7 | 0x12,
	20763 - 19968: jis0212<<14 | 0x11<<7 | 0x34,
	20764 - 19968: jis0212<<14 | 0x11<<7 | 0x35,
	20765 - 19968: jis0212<<14 | 0x11<<7 | 0x36,
	20766 - 19968: jis0212<<14 | 0x11<<7 | 0x37,
	20767 - 19968: jis0208<<14 | 0x1C<<7 | 0x5D,
	20769 - 19968: jis0208<<14 | 0x30<<7 | 0x13,
	20771 - 19968: jis0212<<14 | 0x11<<7 | 0x38,
	20775 - 19968: jis0212<<14 | 0x11<<7 | 0x39,
	20776 - 19968: jis0212<<14 | 0x11<<7 | 0x3A,
	20778 - 19968: jis0208<<14 | 0x2C<<7 | 0x04,
	20780 - 19968: jis0212<<14 | 0x11<<7 | 0x3B,
	20781 - 19968: jis0212<<14 | 0x11<<7 | 0x3C,
	20783 - 19968: jis0212<<14 | 0x11<<7 | 0x3D,
	20785 - 19968: jis0212<<14 | 0x11<<7 | 0x3E,
	20786 - 19968: jis0208<<14 | 0x2B<<7 | 0x38,
	20787 - 19968: jis0212<<14 | 0x11<<7 | 0x3F,
	20788 - 19968: jis0212<<14 | 0x11<<7 | 0x40,
	20789 - 19968: jis0212<<14 | 0x11<<7 | 0x41,
	20791 - 19968: jis0208<<14 | 0x30<<7 | 0x15,
	20792 - 19968: jis0212<<14 | 0x11<<7 | 0x42,
	20793 - 19968: jis0212<<14 | 0x11<<7 | 0x43,
	20794 - 19968: jis0208<<14 | 0x30<<7 | 0x14,
	20795 - 19968: jis0208<<14 | 0x30<<7 | 0x17,
	20796 - 19968: jis0208<<14 | 0x30<<7 | 0x16,
	20799 - 19968: jis0208<<14 | 0x30<<7 | 0x18,
	20800 - 19968: jis0208<<14 | 0x30<<7 | 0x19,
	20801 - 19968: jis0208<<14 | 0x0F<<7 | 0x53,
	20802 - 19968: jis0212<<14 | 0x11<<7 | 0x44,
	20803 - 19968: jis0208<<14 | 0x17<<7 | 0x14,
	20804 - 19968: jis0208<<14 | 0x16<<7 | 0x1A,
	20805 - 19968: jis0208<<14 | 0x1C<<7 | 0x1B,
	20806 - 19968: jis0208<<14 | 0x22<<7 | 0x5A,
	20807 - 19968: jis0208<<14 | 0x15<<7 | 0x03,
	20808 - 19968: jis0208<<14 | 0x1F<<7 | 0x47,
	20809 - 19968: jis0208<<14 | 0x17<<7 | 0x56,
	20810 - 19968: jis0208<<14 | 0x58<<7 | 0x22,
	20811 - 19968: jis0208<<14 | 0x18<<7 | 0x4D,
	20812 - 19968: jis0208<<14 | 0x30<<7 | 0x1B,
	20813 - 19968: jis0208<<14 | 0x2B<<7 | 0x27,
	20814 - 19968: jis0208<<14 | 0x24<<7 | 0x25,
	20815 - 19968: jis0212<<14 | 0x11<<7 | 0x46,
	20816 - 19968: jis0208<<14 | 0x1A<<7 | 0x58,
	20818 - 19968: jis0208<<14 | 0x30<<7 | 0x1A,
	20819 - 19968: jis0212<<14 | 0x11<<7 | 0x47,
	20820 - 19968: jis0208<<14 | 0x30<<7 | 0x1C,
	20821 - 19968: jis0212<<14 | 0x11<<7 | 0x48,
	20823 - 19968: jis0212<<14 | 0x11<<7 | 0x49,
	20824 - 19968: jis0212<<14 | 0x11<<7 | 0x4A,
	20826 - 19968: jis0208<<14 | 0x24<<7 | 0x3D,
	20828 - 19968: jis0208<<14 | 0x12<<7 | 0x54,
	20831 - 19968: jis0212<<14 | 0x11<<7 | 0x4B,
	20834 - 19968: jis0208<<14 | 0x30<<7 | 0x1D,
	20836 - 19968: jis0208<<14 | 0x58<<7 | 0x23,
	20837 - 19968: jis0208<<14 | 0x25<<7 | 0x5D,
	20838 - 19968: jis0212<<14 | 0x11<<7 | 0x4D,
	20840 - 19968: jis0208<<14 | 0x20<<7 | 0x13,
	20841 - 19968: jis0208<<14 | 0x30<<7 | 0x1F,
	20842 - 19968: jis0208<<14 | 0x30<<7 | 0x20,
	20843 - 19968: jis0208<<14 | 0x27<<7 | 0x0B,
	20844 - 19968: jis0208<<14 | 0x17<<7 | 0x57,
	20845 - 19968: jis0208<<14 | 0x2E<<7 | 0x1A,
	20846 - 19968: jis0208<<14 | 0x30<<7 | 0x21,
	20849 - 19968: jis0208<<14 | 0x15<<7 | 0x05,
	20853 - 19968: jis0208<<14 | 0x29<<7 | 0x1B,
	20854 - 19968: jis0208<<14 | 0x21<<7 | 0x15,
	20855 - 19968: jis0208<<14 | 0x15<<7 | 0x50,
	20856 - 19968: jis0208<<14 | 0x24<<7 | 0x14,
	20860 - 19968: jis0208<<14 | 0x16<<7 | 0x52,
	20862 - 19968: jis0212<<14 | 0x11<<7 | 0x4E,
	20864 - 19968: jis0208<<14 | 0x30<<7 | 0x22,
	20866 - 19968: jis0208<<14 | 0x30<<7 | 0x23,
	20867 - 19968: jis0212<<14 | 0x11<<7 | 0x4F,
	20868 - 19968: jis0212<<14 | 0x11<<7 | 0x50,
	20869 - 19968: jis0208<<14 | 0x25<<7 | 0x41,
	20870 - 19968: jis0208<<14 | 0x10<<7 | 0x3E,
	20873 - 19968: jis0208<<14 | 0x30<<7 | 0x26,
	20874 - 19968: jis0208<<14 | 0x19<<7 | 0x5C,
	20875 - 19968: jis0212<<14 | 0x11<<7 | 0x51,
	20876 - 19968: jis0208<<14 | 0x30<<7 | 0x25,
	20877 - 19968: jis0208<<14 | 0x19<<7 | 0x25,
	20878 - 19968: jis0212<<14 | 0x11<<7 | 0x52,
	20879 - 19968: jis0208<<14 | 0x30<<7 | 0x27,
	20880 - 19968: jis0208<<14 | 0x45<<7 | 0x4D,
	20881 - 19968: jis0208<<14 | 0x30<<7 | 0x28,
	20882 - 19968: jis0208<<14 | 0x2A<<7 | 0x20,
	20883 - 19968: jis0208<<14 | 0x30<<7 | 0x29,
	20885 - 19968: jis0208<<14 | 0x30<<7 | 0x2A,
	20886 - 19968: jis0208<<14 | 0x30<<7 | 0x2B,
	20887 - 19968: jis0208<<14 | 0x1D<<7 | 0x48,
	20888 - 19968: jis0212<<14 | 0x11<<7 | 0x53,
	20889 - 19968: jis0208<<14 | 0x1B<<7 | 0x2B,
	20893 - 19968: jis0208<<14 | 0x58<<7 | 0x24,
	20896 - 19968: jis0208<<14 | 0x13<<7 | 0x06,
	20897 - 19968: jis0212<<14 | 0x11<<7 | 0x55,
	20898 - 19968: jis0208<<14 | 0x30<<7 | 0x2E,
	20899 - 19968: jis0212<<14 | 0x11<<7 | 0x56,
	20900 - 19968: jis0208<<14 | 0x30<<7 | 0x2C,
	20901 - 19968: jis0208<<14 | 0x2B<<7 | 0x1C,
	20902 - 19968: jis0208<<14 | 0x30<<7 | 0x2D,
	20904 - 19968: jis0208<<14 | 0x28<<7 | 0x39,
	20905 - 19968: jis0208<<14 | 0x30<<7 | 0x2F,
	20906 - 19968: jis0208<<14 | 0x30<<7 | 0x30,
	20907 - 19968: jis0208<<14 | 0x30<<7 | 0x31,
	20908 - 19968: jis0208<<14 | 0x24<<7 | 0x3E,
	20909 - 19968: jis0212<<14 | 0x11<<7 | 0x57,
	20912 - 19968: jis0208<<14 | 0x30<<7 | 0x35,
	20913 - 19968: jis0208<<14 | 0x30<<7 | 0x33,
	20914 - 19968: jis0208<<14 | 0x30<<7 | 0x34,
	20915 - 19968: jis0208<<14 | 0x30<<7 | 0x32,
	20916 - 19968: jis0208<<14 | 0x19<<7 | 0x42,
	20917 - 19968: jis0208<<14 | 0x30<<7 | 0x36,
	20918 - 19968: jis0208<<14 | 0x2B<<7 | 0x49,
	20919 - 19968: jis0208<<14 | 0x2D<<7 | 0x43,
	20920 - 19968: jis0212<<14 | 0x11<<7 | 0x58,
	20922 - 19968: jis0212<<14 | 0x11<<7 | 0x59,
	20924 - 19968: jis0212<<14 | 0x11<<7 | 0x5A,
	20925 - 19968: jis0208<<14 | 0x30<<7 | 0x37,
	20926 - 19968: jis0208<<14 | 0x58<<7 | 0x25,
	20927 - 19968: jis0212<<14 | 0x11<<7 | 0x5C,
	20930 - 19968: jis0212<<14 | 0x11<<7 | 0x5D,
	20932 - 19968: jis0208<<14 | 0x1F<<7 | 0x07,
	20933 - 19968: jis0208<<14 | 0x30<<7 | 0x38,
	20934 - 19968: jis0208<<14 | 0x1C<<7 | 0x39,
	20936 - 19968: jis0212<<14 | 0x12<<7 | 0x00,
	20937 - 19968: jis0208<<14 | 0x30<<7 | 0x39,
	20939 - 19968: jis0208<<14 | 0x22<<7 | 0x5B,
	20940 - 19968: jis0208<<14 | 0x2D<<7 | 0x1E,
	20941 - 19968: jis0208<<14 | 0x24<<7 | 0x3F,
	20943 - 19968: jis0212<<14 | 0x12<<7 | 0x01,
	20945 - 19968: jis0212<<14 | 0x12<<7 | 0x02,
	20946 - 19968: jis0212<<14 | 0x12<<7 | 0x03,
	20947 - 19968: jis0212<<14 | 0x12<<7 | 0x04,
	20949 - 19968: jis0212<<14 | 0x12<<7 | 0x05,
	20950 - 19968: jis0208<<14 | 0x31<<7 | 0x24,
	20952 - 19968: jis0212<<14 | 0x12<<7 | 0x06,
	20955 - 19968: jis0208<<14 | 0x30<<7 | 0x3A,
	20956 - 19968: jis0208<<14 | 0x53<<7 | 0x04,
	20957 - 19968: jis0208<<14 | 0x15<<7 | 0x24,
	20958 - 19968: jis0212<<14 | 0x12<<7 | 0x07,
	20960 - 19968: jis0208<<14 | 0x30<<7 | 0x3B,
	20961 - 19968: jis0208<<14 | 0x2A<<7 | 0x3D,
	20962 - 19968: jis0212<<14 | 0x12<<7 | 0x08,
	20965 - 19968: jis0212<<14 | 0x12<<7 | 0x09,
	20966 - 19968: jis0208<<14 | 0x1C<<7 | 0x47,
	20967 - 19968: jis0208<<14 | 0x21<<7 | 0x5B,
	20969 - 19968: jis0208<<14 | 0x30<<7 | 0x3D,
	20970 - 19968: jis0208<<14 | 0x25<<7 | 0x43,
	20972 - 19968: jis0208<<14 | 0x58<<7 | 0x26,
	20973 - 19968: jis0208<<14 | 0x30<<7 | 0x3E,
	20974 - 19968: jis0212<<14 | 0x12<<7 | 0x0A,
	20976 - 19968: jis0208<<14 | 0x30<<7 | 0x3F,
	20977 - 19968: jis0208<<14 | 0x12<<7 | 0x0D,
	20978 - 19968: jis0212<<14 | 0x12<<7 | 0x0B,
	20979 - 19968: jis0212<<14 | 0x12<<7 | 0x0C,
	20980 - 19968: jis0212<<14 | 0x12<<7 | 0x0D,
	20981 - 19968: jis0208<<14 | 0x30<<7 | 0x40,
	20982 - 19968: jis0208<<14 | 0x15<<7 | 0x06,
	20983 - 19968: jis0212<<14 | 0x12<<7 | 0x0E,
	20984 - 19968: jis0208<<14 | 0x25<<7 | 0x2B,
	20985 - 19968: jis0208<<14 | 0x10<<7 | 0x59,
	20986 - 19968: jis0208<<14 | 0x1C<<7 | 0x2F,
	20989 - 19968: jis0208<<14 | 0x27<<7 | 0x00,
	20990 - 19968: jis0208<<14 | 0x30<<7 | 0x41,
	20992 - 19968: jis0208<<14 | 0x24<<7 | 0x40,
	20993 - 19968: jis0212<<14 | 0x12<<7 | 0x0F,
	20994 - 19968: jis0212<<14 | 0x12<<7 | 0x10,
	20995 - 19968: jis0208<<14 | 0x1E<<7 | 0x2E,
	20996 - 19968: jis0208<<14 | 0x30<<7 | 0x42,
	20997 - 19968: jis0212<<14 | 0x12<<7 | 0x11,
	20998 - 19968: jis0208<<14 | 0x29<<7 | 0x0B,
	20999 - 19968: jis0208<<14 | 0x1F<<7 | 0x39,
	21000 - 19968: jis0208<<14 | 0x13<<7 | 0x01,
	21002 - 19968: jis0208<<14 | 0x13<<7 | 0x08,
	21003 - 19968: jis0208<<14 | 0x30<<7 | 0x43,
	21006 - 19968: jis0208<<14 | 0x30<<7 | 0x45,
	21009 - 19968: jis0208<<14 | 0x16<<7 | 0x19,
	21010 - 19968: jis0212<<14 | 0x12<<7 | 0x12,
	21011 - 19968: jis0212<<14 | 0x12<<7 | 0x13,
	21012 - 19968: jis0208<<14 | 0x30<<7 | 0x44,
	21013 - 19968: jis0208<<14 | 0x58<<7 | 0x27,
	21014 - 19968: jis0212<<14 | 0x12<<7 | 0x15,
	21015 - 19968: jis0208<<14 | 0x2D<<7 | 0x52,
	21016 - 19968: jis0212<<14 | 0x12<<7 | 0x16,
	21021 - 19968: jis0208<<14 | 0x1C<<7 | 0x48,
	21026 - 19968: jis0212<<14 | 0x12<<7 | 0x17,
	21028 - 19968: jis0208<<14 | 0x27<<7 | 0x1C,
	21029 - 19968: jis0208<<14 | 0x29<<7 | 0x2B,
	21031 - 19968: jis0208<<14 | 0x30<<7 | 0x46,
	21032 - 19968: jis0212<<14 | 0x12<<7 | 0x18,
	21033 - 19968: jis0208<<14 | 0x2C<<7 | 0x57,
	21034 - 19968: jis0208<<14 | 0x30<<7 | 0x47,
	21038 - 19968: jis0208<<14 | 0x30<<7 | 0x48,
	21040 - 19968: jis0208<<14 | 0x24<<7 | 0x5D,
	21041 - 19968: jis0212<<14 | 0x12<<7 | 0x19,
	21042 - 19968: jis0212<<14 | 0x12<<7 | 0x1A,
	21043 - 19968: jis0208<<14 | 0x30<<7 | 0x49,
	21045 - 19968: jis0212<<14 | 0x12<<7 | 0x1B,
	21046 - 19968: jis0208<<14 | 0x1F<<7 | 0x08,
	21047 - 19968: jis0208<<14 | 0x19<<7 | 0x5D,
	21048 - 19968: jis0208<<14 | 0x16<<7 | 0x53,
	21049 - 19968: jis0208<<14 | 0x30<<7 | 0x4A,
	21050 - 19968: jis0208<<14 | 0x1A<<7 | 0x28,
	21051 - 19968: jis0208<<14 | 0x18<<7 | 0x4E,
	21052 - 19968: jis0212<<14 | 0x12<<7 | 0x1C,
	21059 - 19968: jis0208<<14 | 0x23<<7 | 0x45,
	21060 - 19968: jis0208<<14 | 0x30<<7 | 0x4C,
	21061 - 19968: jis0212<<14 | 0x12<<7 | 0x1D,
	21063 - 19968: jis0208<<14 | 0x21<<7 | 0x06,
	21065 - 19968: jis0212<<14 | 0x12<<7 | 0x1E,
	21066 - 19968: jis0208<<14 | 0x19<<7 | 0x4E,
	21067 - 19968: jis0208<<14 | 0x30<<7 | 0x4D,
	21068 - 19968: jis0208<<14 | 0x30<<7 | 0x4E,
	21069 - 19968: jis0208<<14 | 0x20<<7 | 0x0F,
	21071 - 19968: jis0208<<14 | 0x30<<7 | 0x4B,
	21076 - 19968: jis0208<<14 | 0x30<<7 | 0x50,
	21077 - 19968: jis0212<<14 | 0x12<<7 | 0x1F,
	21078 - 19968: jis0208<<14 | 0x2A<<7 | 0x15,
	21079 - 19968: jis0212<<14 | 0x12<<7 | 0x20,
	21080 - 19968: jis0212<<14 | 0x12<<7 | 0x21,
	21082 - 19968: jis0212<<14 | 0x12<<7 | 0x22,
	21083 - 19968: jis0208<<14 | 0x18<<7 | 0x43,
	21084 - 19968: jis0212<<14 | 0x12<<7 | 0x23,
	21086 - 19968: jis0208<<14 | 0x30<<7 | 0x4F,
	21087 - 19968: jis0212<<14 | 0x12<<7 | 0x24,
	21088 - 19968: jis0212<<14 | 0x12<<7 | 0x25,
	21089 - 19968: jis0212<<14 | 0x12<<7 | 0x26,
	21091 - 19968: jis0208<<14 | 0x16<<7 | 0x54,
	21092 - 19968: jis0208<<14 | 0x19<<7 | 0x3D,
	21093 - 19968: jis0208<<14 | 0x26<<7 | 0x4C,
	21094 - 19968: jis0212<<14 | 0x12<<7 | 0x27,
	21097 - 19968: jis0208<<14 | 0x30<<7 | 0x53,
	21098 - 19968: jis0208<<14 | 0x30<<7 | 0x51,
	21102 - 19968: jis0212<<14 | 0x12<<7 | 0x28,
	21103 - 19968: jis0208<<14 | 0x28<<7 | 0x5A,
	21104 - 19968: jis0208<<14 | 0x1D<<7 | 0x49,
	21105 - 19968: jis0208<<14 | 0x30<<7 | 0x5A,
	21106 - 19968: jis0208<<14 | 0x12<<7 | 0x43,
	21107 - 19968: jis0208<<14 | 0x30<<7 | 0x54,
	21108 - 19968: jis0208<<14 | 0x30<<7 | 0x52,
	21109 - 19968: jis0208<<14 | 0x20<<7 | 0x2E,
	21111 - 19968: jis0212<<14 | 0x12<<7 | 0x29,
	21112 - 19968: jis0212<<14 | 0x12<<7 | 0x2A,
	21113 - 19968: jis0212<<14 | 0x12<<7 | 0x2B,
	21117 - 19968: jis0208<<14 | 0x30<<7 | 0x56,
	21119 - 19968: jis0208<<14 | 0x30<<7 | 0x55,
	21120 - 19968: jis0212<<14 | 0x12<<7 | 0x2C,
	21122 - 19968: jis0212<<14 | 0x12<<7 | 0x2D,
	21123 - 19968: jis0208<<14 | 0x12<<7 | 0x23,
	21125 - 19968: jis0212<<14 | 0x12<<7 | 0x2E,
	21127 - 19968: jis0208<<14 | 0x16<<7 | 0x3F,
	21128 - 19968: jis0208<<14 | 0x30<<7 | 0x5B,
	21129 - 19968: jis0208<<14 | 0x2D<<7 | 0x0C,
	21130 - 19968: jis0212<<14 | 0x12<<7 | 0x2F,
	21132 - 19968: jis0212<<14 | 0x12<<7 | 0x30,
	21133 - 19968: jis0208<<14 | 0x30<<7 | 0x57,
	21137 - 19968: jis0208<<14 | 0x30<<7 | 0x5C,
	21138 - 19968: jis0208<<14 | 0x30<<7 | 0x59,
	21139 - 19968: jis0212<<14 | 0x12<<7 | 0x31,
	21140 - 19968: jis0208<<14 | 0x30<<7 | 0x58,
	21141 - 19968: jis0212<<14 | 0x12<<7 | 0x32,
	21142 - 19968: jis0212<<14 | 0x12<<7 | 0x33,
	21143 - 19968: jis0212<<14 | 0x12<<7 | 0x34,
	21144 - 19968: jis0212<<14 | 0x12<<7 | 0x35,
	21146 - 19968: jis0212<<14 | 0x12<<7 | 0x36,
	21147 - 19968: jis0208<<14 | 0x2D<<7 | 0x2E,
	21148 - 19968: jis0208<<14 | 0x58<<7 | 0x28,
	21151 - 19968: jis0208<<14 | 0x17<<7 | 0x58,
	21152 - 19968: jis0208<<14 | 0x11<<7 | 0x22,
	21155 - 19968: jis0208<<14 | 0x2D<<7 | 0x53,
	21156 - 19968: jis0212<<14 | 0x12<<7 | 0x38,
	21157 - 19968: jis0212<<14 | 0x12<<7 | 0x39,
	21158 - 19968: jis0208<<14 | 0x58<<7 | 0x29,
	21159 - 19968: jis0212<<14 | 0x12<<7 | 0x3B,
	21161 - 19968: jis0208<<14 | 0x1C<<7 | 0x54,
	21162 - 19968: jis0208<<14 | 0x24<<7 | 0x37,
	21163 - 19968: jis0208<<14 | 0x18<<7 | 0x44,
	21164 - 19968: jis0208<<14 | 0x31<<7 | 0x01,
	21165 - 19968: jis0208<<14 | 0x31<<7 | 0x02,
	21167 - 19968: jis0208<<14 | 0x5A<<7 | 0x1B,
	21168 - 19968: jis0212<<14 | 0x12<<7 | 0x3D,
	21169 - 19968: jis0208<<14 | 0x2D<<7 | 0x44,
	21172 - 19968: jis0208<<14 | 0x2E<<7 | 0x0A,
	21173 - 19968: jis0208<<14 | 0x31<<7 | 0x04,
	21174 - 19968: jis0212<<14 | 0x12<<7 | 0x3E,
	21175 - 19968: jis0212<<14 | 0x12<<7 | 0x3F,
	21176 - 19968: jis0212<<14 | 0x12<<7 | 0x40,
	21177 - 19968: jis0208<<14 | 0x17<<7 | 0x59,
	21178 - 19968: jis0212<<14 | 0x12<<7 | 0x41,
	21179 - 19968: jis0212<<14 | 0x12<<7 | 0x42,
	21180 - 19968: jis0208<<14 | 0x31<<7 | 0x03,
	21181 - 19968: jis0212<<14 | 0x12<<7 | 0x43,
	21182 - 19968: jis0208<<14 | 0x12<<7 | 0x0E,
	21184 - 19968: jis0208<<14 | 0x58<<7 | 0x2A,
	21185 - 19968: jis0208<<14 | 0x31<<7 | 0x05,
	21187 - 19968: jis0208<<14 | 0x2A<<7 | 0x35,
	21188 - 19968: jis0212<<14 | 0x12<<7 | 0x45,
	21189 - 19968: jis0208<<14 | 0x23<<7 | 0x1B,
	21190 - 19968: jis0212<<14 | 0x12<<7 | 0x46,
	21191 - 19968: jis0208<<14 | 0x2C<<7 | 0x05,
	21192 - 19968: jis0212<<14 | 0x12<<7 | 0x47,
	21193 - 19968: jis0208<<14 | 0x29<<7 | 0x38,
	21196 - 19968: jis0212<<14 | 0x12<<7 | 0x48,
	21197 - 19968: jis0208<<14 | 0x31<<7 | 0x06,
	21199 - 19968: jis0212<<14 | 0x12<<7 | 0x49,
	21201 - 19968: jis0212<<14 | 0x12<<7 | 0x4A,
	21202 - 19968: jis0208<<14 | 0x4F<<7 | 0x34,
	21204 - 19968: jis0212<<14 | 0x12<<7 | 0x4B,
	21205 - 19968: jis0208<<14 | 0x25<<7 | 0x0F,
	21206 - 19968: jis0212<<14 | 0x12<<7 | 0x4C,
	21207 - 19968: jis0208<<14 | 0x31<<7 | 0x07,
	21208 - 19968: jis0208<<14 | 0x13<<7 | 0x09,
	21209 - 19968: jis0208<<14 | 0x2B<<7 | 0x12,
	21211 - 19968: jis0208<<14 | 0x58<<7 | 0x2B,
	21212 - 19968: jis0212<<14 | 0x12<<7 | 0x4E,
	21213 - 19968: jis0208<<14 | 0x1D<<7 | 0x00,
	21214 - 19968: jis0208<<14 | 0x31<<7 | 0x08,
	21215 - 19968: jis0208<<14 | 0x29<<7 | 0x46,
	21216 - 19968: jis0208<<14 | 0x31<<7 | 0x0C,
	21217 - 19968: jis0212<<14 | 0x12<<7 | 0x4F,
	21218 - 19968: jis0208<<14 | 0x1F<<7 | 0x09,
	21219 - 19968: jis0208<<14 | 0x31<<7 | 0x09,
	21220 - 19968: jis0208<<14 | 0x15<<7 | 0x2F,
	21221 - 19968: jis0212<<14 | 0x12<<7 | 0x50,
	21222 - 19968: jis0208<<14 | 0x31<<7 | 0x0A,
	21223 - 19968: jis0208<<14 | 0x13<<7 | 0x0A,
	21224 - 19968: jis0212<<14 | 0x12<<7 | 0x51,
	21225 - 19968: jis0212<<14 | 0x12<<7 | 0x52,
	21226 - 19968: jis0212<<14 | 0x12<<7 | 0x53,
	21228 - 19968: jis0212<<14 | 0x12<<7 | 0x54,
	21232 - 19968: jis0212<<14 | 0x12<<7 | 0x55,
	21233 - 19968: jis0212<<14 | 0x12<<7 | 0x56,
	21234 - 19968: jis0208<<14 | 0x16<<7 | 0x0D,
	21235 - 19968: jis0208<<14 | 0x31<<7 | 0x0D,
	21236 - 19968: jis0212<<14 | 0x12<<7 | 0x57,
	21237 - 19968: jis0208<<14 | 0x31<<7 | 0x0E,
	21238 - 19968: jis0212<<14 | 0x12<<7 | 0x58,
	21239 - 19968: jis0212<<14 | 0x12<<7 | 0x59,
	21240 - 19968: jis0208<<14 | 0x31<<7 | 0x0F,
	21241 - 19968: jis0208<<14 | 0x31<<7 | 0x10,
	21242 - 19968: jis0208<<14 | 0x1B<<7 | 0x3A,
	21246 - 19968: jis0208<<14 | 0x17<<7 | 0x5A,
	21247 - 19968: jis0208<<14 | 0x2B<<7 | 0x3D,
	21248 - 19968: jis0208<<14 | 0x58<<7 | 0x2C,
	21249 - 19968: jis0208<<14 | 0x2B<<7 | 0x47,
	21250 - 19968: jis0208<<14 | 0x25<<7 | 0x56,
	21251 - 19968: jis0212<<14 | 0x12<<7 | 0x5B,
	21253 - 19968: jis0208<<14 | 0x29<<7 | 0x50,
	21254 - 19968: jis0208<<14 | 0x31<<7 | 0x11,
	21255 - 19968: jis0208<<14 | 0x58<<7 | 0x2D,
	21256 - 19968: jis0208<<14 | 0x31<<7 | 0x12,
	21258 - 19968: jis0212<<14 | 0x12<<7 | 0x5C,
	21259 - 19968: jis0212<<14 | 0x12<<7 | 0x5D,
	21260 - 19968: jis0212<<14 | 0x13<<7 | 0x00,
	21261 - 19968: jis0208<<14 | 0x31<<7 | 0x14,
	21263 - 19968: jis0208<<14 | 0x31<<7 | 0x16,
	21264 - 19968: jis0208<<14 | 0x31<<7 | 0x15,
	21265 - 19968: jis0212<<14 | 0x13<<7 | 0x01,
	21267 - 19968: jis0212<<14 | 0x13<<7 | 0x02,
	21269 - 19968: jis0208<<14 | 0x31<<7 | 0x17,
	21270 - 19968: jis0208<<14 | 0x11<<7 | 0x1C,
	21271 - 19968: jis0208<<14 | 0x2A<<7 | 0x2B,
	21272 - 19968: jis0212<<14 | 0x13<<7 | 0x03,
	21273 - 19968: jis0208<<14 | 0x19<<7 | 0x5B,
	21274 - 19968: jis0208<<14 | 0x31<<7 | 0x18,
	21275 - 19968: jis0212<<14 | 0x13<<7 | 0x04,
	21276 - 19968: jis0212<<14 | 0x13<<7 | 0x05,
	21277 - 19968: jis0208<<14 | 0x20<<7 | 0x38,
	21278 - 19968: jis0212<<14 | 0x13<<7 | 0x06,
	21279 - 19968: jis0212<<14 | 0x13<<7 | 0x07,
	21280 - 19968: jis0208<<14 | 0x1D<<7 | 0x01,
	21281 - 19968: jis0208<<14 | 0x15<<7 | 0x08,
	21283 - 19968: jis0208<<14 | 0x31<<7 | 0x19,
	21284 - 19968: jis0208<<14 | 0x58<<7 | 0x2E,
	21285 - 19968: jis0212<<14 | 0x13<<7 | 0x08,
	21287 - 19968: jis0212<<14 | 0x13<<7 | 0x09,
	21288 - 19968: jis0212<<14 | 0x13<<7 | 0x0A,
	21289 - 19968: jis0212<<14 | 0x13<<7 | 0x0B,
	21290 - 19968: jis0208<<14 | 0x27<<7 | 0x3A,
	21291 - 19968: jis0212<<14 | 0x13<<7 | 0x0C,
	21292 - 19968: jis0212<<14 | 0x13<<7 | 0x0D,
	21293 - 19968: jis0212<<14 | 0x13<<7 | 0x0E,
	21295 - 19968: jis0208<<14 | 0x31<<7 | 0x1A,
	21296 - 19968: jis0212<<14 | 0x13<<7 | 0x0F,
	21297 - 19968: jis0208<<14 | 0x31<<7 | 0x1B,
	21298 - 19968: jis0212<<14 | 0x13<<7 | 0x10,
	21299 - 19968: jis0208<<14 | 0x31<<7 | 0x1C,
	21301 - 19968: jis0212<<14 | 0x13<<7 | 0x11,
	21304 - 19968: jis0208<<14 | 0x31<<7 | 0x1D,
	21305 - 19968: jis0208<<14 | 0x28<<7 | 0x03,
	21306 - 19968: jis0208<<14 | 0x15<<7 | 0x47,
	21307 - 19968: jis0208<<14 | 0x0F<<7 | 0x44,
	21308 - 19968: jis0212<<14 | 0x13<<7 | 0x12,
	21309 - 19968: jis0212<<14 | 0x13<<7 | 0x13,
	21310 - 19968: jis0212<<14 | 0x13<<7 | 0x14,
	21311 - 19968: jis0208<<14 | 0x25<<7 | 0x1E,
	21312 - 19968: jis0208<<14 | 0x31<<7 | 0x1E,
	21313 - 19968: jis0208<<14 | 0x1C<<7 | 0x1C,
	21314 - 19968: jis0212<<14 | 0x13<<7 | 0x15,
	21315 - 19968: jis0208<<14 | 0x1F<<7 | 0x48,
	21317 - 19968: jis0208<<14 | 0x31<<7 | 0x20,
	21318 - 19968: jis0208<<14 | 0x31<<7 | 0x1F,
	21319 - 19968: jis0208<<14 | 0x1D<<7 | 0x02,
	21320 - 19968: jis0208<<14 | 0x17<<7 | 0x40,
	21321 - 19968: jis0208<<14 | 0x31<<7 | 0x22,
	21322 - 19968: jis0208<<14 | 0x27<<7 | 0x1D,
	21323 - 19968: jis0212<<14 | 0x13<<7 | 0x17,
	21324 - 19968: jis0212<<14 | 0x13<<7 | 0x16,
	21325 - 19968: jis0208<<14 | 0x31<<7 | 0x23,
	21329 - 19968: jis0208<<14 | 0x27<<7 | 0x3B,
	21330 - 19968: jis0208<<14 | 0x21<<7 | 0x13,
	21331 - 19968: jis0208<<14 | 0x21<<7 | 0x4D,
	21332 - 19968: jis0208<<14 | 0x15<<7 | 0x07,
	21335 - 19968: jis0208<<14 | 0x25<<7 | 0x4D,
	21336 - 19968: jis0208<<14 | 0x22<<7 | 0x10,
	21337 - 19968: jis0212<<14 | 0x13<<7 | 0x18,
	21338 - 19968: jis0208<<14 | 0x26<<7 | 0x4D,
	21339 - 19968: jis0212<<14 | 0x13<<7 | 0x19,
	21340 - 19968: jis0208<<14 | 0x2A<<7 | 0x2D,
	21342 - 19968: jis0208<<14 | 0x31<<7 | 0x25,
	21344 - 19968: jis0208<<14 | 0x1F<<7 | 0x49,
	21345 - 19968: jis0212<<14 | 0x13<<7 | 0x1A,
	21347 - 19968: jis0212<<14 | 0x13<<7 | 0x1B,
	21349 - 19968: jis0212<<14 | 0x13<<7 | 0x1C,
	21350 - 19968: jis0208<<14 | 0x16<<7 | 0x14,
	21353 - 19968: jis0208<<14 | 0x31<<7 | 0x26,
	21356 - 19968: jis0212<<14 | 0x13<<7 | 0x1D,
	21357 - 19968: jis0212<<14 | 0x13<<7 | 0x1E,
	21358 - 19968: jis0208<<14 | 0x31<<7 | 0x27,
	21359 - 19968: jis0208<<14 | 0x10<<7 | 0x0B,
	21360 - 19968: jis0208<<14 | 0x0F<<7 | 0x54,
	21361 - 19968: jis0208<<14 | 0x13<<7 | 0x4C,
	21362 - 19968: jis0208<<14 | 0x58<<7 | 0x2F,
	21363 - 19968: jis0208<<14 | 0x21<<7 | 0x07,
	21364 - 19968: jis0208<<14 | 0x14<<7 | 0x30,
	21365 - 19968: jis0208<<14 | 0x2C<<7 | 0x50,
	21367 - 19968: jis0208<<14 | 0x31<<7 | 0x2A,
	21368 - 19968: jis0208<<14 | 0x11<<7 | 0x16,
	21369 - 19968: jis0212<<14 | 0x13<<7 | 0x20,
	21371 - 19968: jis0208<<14 | 0x31<<7 | 0x29,
	21374 - 19968: jis0212<<14 | 0x13<<7 | 0x21,
	21375 - 19968: jis0208<<14 | 0x15<<7 | 0x09,
	21378 - 19968: jis0208<<14 | 0x31<<7 | 0x2B,
	21379 - 19968: jis0212<<14 | 0x13<<7 | 0x22,
	21380 - 19968: jis0208<<14 | 0x2B<<7 | 0x50,
	21383 - 19968: jis0212<<14 | 0x13<<7 | 0x23,
	21384 - 19968: jis0212<<14 | 0x13<<7 | 0x24,
	21390 - 19968: jis0212<<14 | 0x13<<7 | 0x25,
	21395 - 19968: jis0208<<14 | 0x58<<7 | 0x30,
	21396 - 19968: jis0212<<14 | 0x13<<7 | 0x27,
	21398 - 19968: jis0208<<14 | 0x31<<7 | 0x2C,
	21400 - 19968: jis0208<<14 | 0x2D<<7 | 0x31,
	21401 - 19968: jis0212<<14 | 0x13<<7 | 0x28,
	21402 - 19968: jis0208<<14 | 0x17<<7 | 0x5B,
	21405 - 19968: jis0212<<14 | 0x13<<7 | 0x29,
	21407 - 19968: jis0208<<14 | 0x17<<7 | 0x15,
	21408 - 19968: jis0208<<14 | 0x31<<7 | 0x2D,
	21409 - 19968: jis0212<<14 | 0x13<<7 | 0x2A,
	21412 - 19968: jis0212<<14 | 0x13<<7 | 0x2B,
	21413 - 19968: jis0208<<14 | 0x31<<7 | 0x2F,
	21414 - 19968: jis0208<<14 | 0x31<<7 | 0x2E,
	21416 - 19968: jis0208<<14 | 0x1E<<7 | 0x3E,
	21417 - 19968: jis0208<<14 | 0x10<<7 | 0x18,
	21418 - 19968: jis0212<<14 | 0x13<<7 | 0x2C,
	21419 - 19968: jis0212<<14 | 0x13<<7 | 0x2D,
	21421 - 19968: jis0208<<14 | 0x10<<7 | 0x3D,
	21422 - 19968: jis0208<<14 | 0x31<<7 | 0x30,
	21423 - 19968: jis0212<<14 | 0x13<<7 | 0x2E,
	21424 - 19968: jis0208<<14 | 0x31<<7 | 0x31,
	21426 - 19968: jis0208<<14 | 0x58<<7 | 0x31,
	21427 - 19968: jis0208<<14 | 0x17<<7 | 0x16,
	21428 - 19968: jis0212<<14 | 0x13<<7 | 0x30,
	21429 - 19968: jis0212<<14 | 0x13<<7 | 0x31,
	21430 - 19968: jis0208<<14 | 0x31<<7 | 0x32,
	21431 - 19968: jis0212<<14 | 0x13<<7 | 0x32,
	21432 - 19968: jis0212<<14 | 0x13<<7 | 0x33,
	21434 - 19968: jis0212<<14 | 0x13<<7 | 0x34,
	21435 - 19968: jis0208<<14 | 0x14<<7 | 0x4D,
	21437 - 19968: jis0212<<14 | 0x13<<7 | 0x35,
	21440 - 19968: jis0212<<14 | 0x13<<7 | 0x36,
	21442 - 19968: jis0208<<14 | 0x1A<<7 | 0x11,
	21443 - 19968: jis0208<<14 | 0x31<<7 | 0x33,
	21445 - 19968: jis0212<<14 | 0x13<<7 | 0x37,
	21448 - 19968: jis0208<<14 | 0x2A<<7 | 0x53,
	21449 - 19968: jis0208<<14 | 0x19<<7 | 0x14,
	21450 - 19968: jis0208<<14 | 0x14<<7 | 0x39,
	21451 - 19968: jis0208<<14 | 0x2C<<7 | 0x06,
	21452 - 19968: jis0208<<14 | 0x20<<7 | 0x2F,
	21453 - 19968: jis0208<<14 | 0x27<<7 | 0x1E,
	21454 - 19968: jis0208<<14 | 0x1B<<7 | 0x5C,
	21455 - 19968: jis0212<<14 | 0x13<<7 | 0x38,
	21458 - 19968: jis0212<<14 | 0x13<<7 | 0x39,
	21459 - 19968: jis0212<<14 | 0x13<<7 | 0x3A,
	21460 - 19968: jis0208<<14 | 0x1C<<7 | 0x26,
	21461 - 19968: jis0212<<14 | 0x13<<7 | 0x3B,
	21462 - 19968: jis0208<<14 | 0x1B<<7 | 0x47,
	21463 - 19968: jis0208<<14 | 0x1B<<7 | 0x54,
	21465 - 19968: jis0208<<14 | 0x1C<<7 | 0x55,
	21466 - 19968: jis0212<<14 | 0x13<<7 | 0x3C,
	21467 - 19968: jis0208<<14 | 0x27<<7 | 0x1F,
	21469 - 19968: jis0208<<14 | 0x58<<7 | 0x32,
	21470 - 19968: jis0212<<14 | 0x13<<7 | 0x3E,
	21471 - 19968: jis0208<<14 | 0x31<<7 | 0x36,
	21472 - 19968: jis0212<<14 | 0x13<<7 | 0x3F,
	21473 - 19968: jis0208<<14 | 0x10<<7 | 0x22,
	21474 - 19968: jis0208<<14 | 0x20<<7 | 0x30,
	21475 - 19968: jis0208<<14 | 0x17<<7 | 0x5C,
	21476 - 19968: jis0208<<14 | 0x17<<7 | 0x24,
	21477 - 19968: jis0208<<14 | 0x15<<7 | 0x46,
	21478 - 19968: jis0212<<14 | 0x13<<7 | 0x40,
	21479 - 19968: jis0212<<14 | 0x13<<7 | 0x41,
	21480 - 19968: jis0208<<14 | 0x31<<7 | 0x3A,
	21481 - 19968: jis0208<<14 | 0x22<<7 | 0x00,
	21482 - 19968: jis0208<<14 | 0x21<<7 | 0x5D,
	21483 - 19968: jis0208<<14 | 0x15<<7 | 0x0A,
	21484 - 19968: jis0208<<14 | 0x1D<<7 | 0x03,
	21485 - 19968: jis0208<<14 | 0x31<<7 | 0x3B,
	21486 - 19968: jis0208<<14 | 0x31<<7 | 0x39,
	21487 - 19968: jis0208<<14 | 0x11<<7 | 0x23,
	21488 - 19968: jis0208<<14 | 0x21<<7 | 0x45,
	21489 - 19968: jis0208<<14 | 0x1B<<7 | 0x17,
	21490 - 19968: jis0208<<14 | 0x1A<<7 | 0x2A,
	21491 - 19968: jis0208<<14 | 0x10<<7 | 0x05,
	21493 - 19968: jis0212<<14 | 0x13<<7 | 0x42,
	21494 - 19968: jis0208<<14 | 0x12<<7 | 0x4F,
	21495 - 19968: jis0208<<14 | 0x18<<7 | 0x45,
	21496 - 19968: jis0208<<14 | 0x1A<<7 | 0x29,
	21498 - 19968: jis0208<<14 | 0x31<<7 | 0x3C,
	21505 - 19968: jis0208<<14 | 0x31<<7 | 0x3D,
	21506 - 19968: jis0212<<14 | 0x13<<7 | 0x43,
	21507 - 19968: jis0208<<14 | 0x14<<7 | 0x28,
	21508 - 19968: jis0208<<14 | 0x12<<7 | 0x25,
	21512 - 19968: jis0208<<14 | 0x18<<7 | 0x46,
	21513 - 19968: jis0208<<14 | 0x14<<7 | 0x27,
	21514 - 19968: jis0208<<14 | 0x23<<7 | 0x3E,
	21515 - 19968: jis0208<<14 | 0x10<<7 | 0x04,
	21516 - 19968: jis0208<<14 | 0x25<<7 | 0x10,
	21517 - 19968: jis0208<<14 | 0x2B<<7 | 0x1D,
	21518 - 19968: jis0208<<14 | 0x18<<7 | 0x00,
	21519 - 19968: jis0208<<14 | 0x2C<<7 | 0x58,
	21520 - 19968: jis0208<<14 | 0x24<<7 | 0x26,
	21521 - 19968: jis0208<<14 | 0x17<<7 | 0x5D,
	21523 - 19968: jis0212<<14 | 0x13<<7 | 0x44,
	21530 - 19968: jis0212<<14 | 0x13<<7 | 0x45,
	21531 - 19968: jis0208<<14 | 0x16<<7 | 0x0E,
	21533 - 19968: jis0208<<14 | 0x31<<7 | 0x46,
	21535 - 19968: jis0208<<14 | 0x15<<7 | 0x42,
	21536 - 19968: jis0208<<14 | 0x2A<<7 | 0x29,
	21537 - 19968: jis0212<<14 | 0x13<<7 | 0x46,
	21542 - 19968: jis0208<<14 | 0x27<<7 | 0x3C,
	21543 - 19968: jis0212<<14 | 0x13<<7 | 0x47,
	21544 - 19968: jis0212<<14 | 0x13<<7 | 0x48,
	21545 - 19968: jis0208<<14 | 0x31<<7 | 0x45,
	21546 - 19968: jis0212<<14 | 0x13<<7 | 0x49,
	21547 - 19968: jis0208<<14 | 0x13<<7 | 0x3D,
	21548 - 19968: jis0208<<14 | 0x31<<7 | 0x40,
	21549 - 19968: jis0208<<14 | 0x31<<7 | 0x41,
	21550 - 19968: jis0208<<14 | 0x31<<7 | 0x43,
	21551 - 19968: jis0212<<14 | 0x13<<7 | 0x4A,
	21553 - 19968: jis0212<<14 | 0x13<<7 | 0x4B,
	21556 - 19968: jis0212<<14 | 0x13<<7 | 0x4C,
	21557 - 19968: jis0212<<14 | 0x13<<7 | 0x4D,
	21558 - 19968: jis0208<<14 | 0x31<<7 | 0x44,
	21560 - 19968: jis0208<<14 | 0x14<<7 | 0x3A,
	21561 - 19968: jis0208<<14 | 0x1E<<7 | 0x40,
	21563 - 19968: jis0208<<14 | 0x29<<7 | 0x0C,
	21564 - 19968: jis0208<<14 | 0x31<<7 | 0x42,
	21565 - 19968: jis0208<<14 | 0x31<<7 | 0x3E,
	21566 - 19968: jis0208<<14 | 0x17<<7 | 0x42,
	21568 - 19968: jis0208<<14 | 0x31<<7 | 0x3F,
	21570 - 19968: jis0208<<14 | 0x2E<<7 | 0x03,
	21571 - 19968: jis0212<<14 | 0x13<<7 | 0x4E,
	21572 - 19968: jis0212<<14 | 0x13<<7 | 0x4F,
	21574 - 19968: jis0208<<14 | 0x29<<7 | 0x51,
	21575 - 19968: jis0212<<14 | 0x13<<7 | 0x50,
	21576 - 19968: jis0208<<14 | 0x23<<7 | 0x47,
	21577 - 19968: jis0208<<14 | 0x17<<7 | 0x41,
	21578 - 19968: jis0208<<14 | 0x18<<7 | 0x4F,
	21581 - 19968: jis0212<<14 | 0x13<<7 | 0x51,
	21582 - 19968: jis0208<<14 | 0x31<<7 | 0x47,
	21583 - 19968: jis0212<<14 | 0x13<<7 | 0x52,
	21585 - 19968: jis0208<<14 | 0x25<<7 | 0x3C,
	21598 - 19968: jis0212<<14 | 0x13<<7 | 0x53,
	21599 - 19968: jis0208<<14 | 0x31<<7 | 0x4B,
	21602 - 19968: jis0212<<14 | 0x13<<7 | 0x54,
	21604 - 19968: jis0212<<14 | 0x13<<7 | 0x55,
	21606 - 19968: jis0212<<14 | 0x13<<7 | 0x56,
	21607 - 19968: jis0212<<14 | 0x13<<7 | 0x57,
	21608 - 19968: jis0208<<14 | 0x1B<<7 | 0x5D,
	21609 - 19968: jis0212<<14 | 0x13<<7 | 0x58,
	21610 - 19968: jis0208<<14 | 0x1B<<7 | 0x55,
	21611 - 19968: jis0212<<14 | 0x13<<7 | 0x59,
	21613 - 19968: jis0212<<14 | 0x13<<7 | 0x5A,
	21614 - 19968: jis0212<<14 | 0x13<<7 | 0x5B,
	21616 - 19968: jis0208<<14 | 0x31<<7 | 0x4E,
	21617 - 19968: jis0208<<14 | 0x31<<7 | 0x4C,
	21619 - 19968: jis0208<<14 | 0x2B<<7 | 0x02,
	21620 - 19968: jis0212<<14 | 0x13<<7 | 0x5C,
	21621 - 19968: jis0208<<14 | 0x31<<7 | 0x49,
	21622 - 19968: jis0208<<14 | 0x31<<7 | 0x52,
	21623 - 19968: jis0208<<14 | 0x31<<7 | 0x4D,
	21627 - 19968: jis0208<<14 | 0x31<<7 | 0x50,
	21628 - 19968: jis0208<<14 | 0x17<<7 | 0x25,
	21629 - 19968: jis0208<<14 | 0x2B<<7 | 0x1E,
	21631 - 19968: jis0212<<14 | 0x13<<7 | 0x5D,
	21632 - 19968: jis0208<<14 | 0x31<<7 | 0x51,
	21633 - 19968: jis0212<<14 | 0x14<<7 | 0x00,
	21635 - 19968: jis0212<<14 | 0x14<<7 | 0x01,
	21636 - 19968: jis0208<<14 | 0x31<<7 | 0x53,
	21637 - 19968: jis0212<<14 | 0x14<<7 | 0x02,
	21638 - 19968: jis0208<<14 | 0x31<<7 | 0x55,
	21640 - 19968: jis0212<<14 | 0x14<<7 | 0x03,
	21641 - 19968: jis0212<<14 | 0x14<<7 | 0x04,
	21642 - 19968: jis0208<<14 | 0x58<<7 | 0x35,
	21643 - 19968: jis0208<<14 | 0x19<<7 | 0x4F,
	21644 - 19968: jis0208<<14 | 0x2E<<7 | 0x21,
	21645 - 19968: jis0212<<14 | 0x14<<7 | 0x05,
	21646 - 19968: jis0208<<14 | 0x31<<7 | 0x4A,
	21647 - 19968: jis0208<<14 | 0x31<<7 | 0x48,
	21648 - 19968: jis0208<<14 | 0x31<<7 | 0x54,
	21649 - 19968: jis0212<<14 | 0x14<<7 | 0x06,
	21650 - 19968: jis0208<<14 | 0x31<<7 | 0x4F,
	21653 - 19968: jis0212<<14 | 0x14<<7 | 0x07,
	21654 - 19968: jis0212<<14 | 0x14<<7 | 0x08,
	21660 - 19968: jis0208<<14 | 0x58<<7 | 0x34,
	21663 - 19968: jis0212<<14 | 0x14<<7 | 0x0A,
	21665 - 19968: jis0212<<14 | 0x14<<7 | 0x0B,
	21666 - 19968: jis0208<<14 | 0x31<<7 | 0x57,
	21668 - 19968: jis0208<<14 | 0x32<<7 | 0x02,
	21669 - 19968: jis0208<<14 | 0x31<<7 | 0x59,
	21670 - 19968: jis0212<<14 | 0x14<<7 | 0x0C,
	21671 - 19968: jis0212<<14 | 0x14<<7 | 0x0D,
	21672 - 19968: jis0208<<14 | 0x31<<7 | 0x5D,
	21673 - 19968: jis0208<<14 | 0x58<<7 | 0x36,
	21674 - 19968: jis0212<<14 | 0x14<<7 | 0x0F,
	21675 - 19968: jis0208<<14 | 0x32<<7 | 0x00,
	21676 - 19968: jis0208<<14 | 0x31<<7 | 0x5A,
	21677 - 19968: jis0212<<14 | 0x14<<7 | 0x10,
	21678 - 19968: jis0212<<14 | 0x14<<7 | 0x11,
	21679 - 19968: jis0208<<14 | 0x32<<7 | 0x1D,
	21681 - 19968: jis0212<<14 | 0x14<<7 | 0x12,
	21682 - 19968: jis0208<<14 | 0x19<<7 | 0x48,
	21683 - 19968: jis0208<<14 | 0x12<<7 | 0x10,
	21687 - 19968: jis0212<<14 | 0x14<<7 | 0x13,
	21688 - 19968: jis0208<<14 | 0x31<<7 | 0x58,
	21689 - 19968: jis0212<<14 | 0x14<<7 | 0x14,
	21690 - 19968: jis0212<<14 | 0x14<<7 | 0x15,
	21691 - 19968: jis0212<<14 | 0x14<<7 | 0x16,
	21692 - 19968: jis0208<<14 | 0x32<<7 | 0x04,
	21693 - 19968: jis0208<<14 | 0x0F<<7 | 0x55,
	21694 - 19968: jis0208<<14 | 0x32<<7 | 0x03,
	21695 - 19968: jis0212<<14 | 0x14<<7 | 0x17,
	21696 - 19968: jis0208<<14 | 0x0F<<7 | 0x04,
	21697 - 19968: jis0208<<14 | 0x28<<7 | 0x29,
	21698 - 19968: jis0208<<14 | 0x32<<7 | 0x01,
	21700 - 19968: jis0208<<14 | 0x31<<7 | 0x5B,
	21702 - 19968: jis0212<<14 | 0x14<<7 | 0x18,
	21703 - 19968: jis0208<<14 | 0x31<<7 | 0x56,
	21704 - 19968: jis0208<<14 | 0x31<<7 | 0x5C,
	21705 - 19968: jis0208<<14 | 0x19<<7 | 0x27,
	21706 - 19968: jis0212<<14 | 0x14<<7 | 0x19,
	21709 - 19968: jis0212<<14 | 0x14<<7 | 0x1A,
	21710 - 19968: jis0212<<14 | 0x14<<7 | 0x1B,
	21720 - 19968: jis0208<<14 | 0x32<<7 | 0x05,
	21728 - 19968: jis0212<<14 | 0x14<<7 | 0x1C,
	21729 - 19968: jis0208<<14 | 0x0F<<7 | 0x56,
	21730 - 19968: jis0208<<14 | 0x32<<7 | 0x0E,
	21733 - 19968: jis0208<<14 | 0x32<<7 | 0x06,
	21734 - 19968: jis0208<<14 | 0x32<<7 | 0x07,
	21736 - 19968: jis0208<<14 | 0x1D<<7 | 0x04,
	21737 - 19968: jis0208<<14 | 0x2A<<7 | 0x48,
	21738 - 19968: jis0212<<14 | 0x14<<7 | 0x1D,
	21740 - 19968: jis0212<<14 | 0x14<<7 | 0x1E,
	21741 - 19968: jis0208<<14 | 0x32<<7 | 0x0C,
	21742 - 19968: jis0208<<14 | 0x32<<7 | 0x0B,
	21743 - 19968: jis0212<<14 | 0x14<<7 | 0x1F,
	21746 - 19968: jis0208<<14 | 0x24<<7 | 0x0E,
	21750 - 19968: jis0212<<14 | 0x14<<7 | 0x20,
	21754 - 19968: jis0208<<14 | 0x32<<7 | 0x0D,
	21756 - 19968: jis0212<<14 | 0x14<<7 | 0x21,
	21757 - 19968: jis0208<<14 | 0x32<<7 | 0x0A,
	21758 - 19968: jis0212<<14 | 0x14<<7 | 0x22,
	21759 - 19968: jis0208<<14 | 0x58<<7 | 0x37,
	21760 - 19968: jis0212<<14 | 0x14<<7 | 0x24,
	21761 - 19968: jis0212<<14 | 0x14<<7 | 0x25,
	21764 - 19968: jis0208<<14 | 0x10<<7 | 0x13,
	21765 - 19968: jis0212<<14 | 0x14<<7 | 0x26,
	21766 - 19968: jis0208<<14 | 0x19<<7 | 0x15,
	21767 - 19968: jis0208<<14 | 0x1E<<7 | 0x0F,
	21768 - 19968: jis0212<<14 | 0x14<<7 | 0x27,
	21769 - 19968: jis0212<<14 | 0x14<<7 | 0x28,
	21772 - 19968: jis0212<<14 | 0x14<<7 | 0x29,
	21773 - 19968: jis0212<<14 | 0x14<<7 | 0x2A,
	21774 - 19968: jis0212<<14 | 0x14<<7 | 0x2B,
	21775 - 19968: jis0208<<14 | 0x32<<7 | 0x08,
	21776 - 19968: jis0208<<14 | 0x24<<7 | 0x41,
	21780 - 19968: jis0208<<14 | 0x32<<7 | 0x09,
	21781 - 19968: jis0212<<14 | 0x14<<7 | 0x2C,
	21782 - 19968: jis0208<<14 | 0x0F<<7 | 0x01,
	21802 - 19968: jis0212<<14 | 0x14<<7 | 0x2D,
	21803 - 19968: jis0212<<14 | 0x14<<7 | 0x2E,
	21806 - 19968: jis0208<<14 | 0x32<<7 | 0x13,
	21807 - 19968: jis0208<<14 | 0x2C<<7 | 0x02,
	21809 - 19968: jis0208<<14 | 0x1D<<7 | 0x06,
	21810 - 19968: jis0212<<14 | 0x14<<7 | 0x2F,
	21811 - 19968: jis0208<<14 | 0x32<<7 | 0x19,
	21813 - 19968: jis0212<<14 | 0x14<<7 | 0x30,
	21814 - 19968: jis0212<<14 | 0x14<<7 | 0x31,
	21816 - 19968: jis0208<<14 | 0x32<<7 | 0x18,
	21817 - 19968: jis0208<<14 | 0x32<<7 | 0x0F,
	21819 - 19968: jis0212<<14 | 0x14<<7 | 0x32,
	21820 - 19968: jis0212<<14 | 0x14<<7 | 0x33,
	21821 - 19968: jis0212<<14 | 0x14<<7 | 0x34,
	21822 - 19968: jis0208<<14 | 0x21<<7 | 0x22,
	21824 - 19968: jis0208<<14 | 0x32<<7 | 0x10,
	21825 - 19968: jis0212<<14 | 0x14<<7 | 0x35,
	21828 - 19968: jis0208<<14 | 0x21<<7 | 0x4E,
	21829 - 19968: jis0208<<14 | 0x32<<7 | 0x15,
	21830 - 19968: jis0208<<14 | 0x1D<<7 | 0x05,
	21831 - 19968: jis0212<<14 | 0x14<<7 | 0x36,
	21833 - 19968: jis0212<<14 | 0x14<<7 | 0x37,
	21834 - 19968: jis0212<<14 | 0x14<<7 | 0x38,
	21836 - 19968: jis0208<<14 | 0x32<<7 | 0x12,
	21837 - 19968: jis0212<<14 | 0x14<<7 | 0x39,
	21839 - 19968: jis0208<<14 | 0x2B<<7 | 0x43,
	21840 - 19968: jis0212<<14 | 0x14<<7 | 0x3A,
	21841 - 19968: jis0212<<14 | 0x14<<7 | 0x3B,
	21843 - 19968: jis0208<<14 | 0x16<<7 | 0x1B,
	21846 - 19968: jis0208<<14 | 0x32<<7 | 0x16,
	21847 - 19968: jis0208<<14 | 0x32<<7 | 0x17,
	21848 - 19968: jis0212<<14 | 0x14<<7 | 0x3C,
	21850 - 19968: jis0212<<14 | 0x14<<7 | 0x3D,
	21851 - 19968: jis0212<<14 | 0x14<<7 | 0x3E,
	21852 - 19968: jis0208<<14 | 0x32<<7 | 0x14,
	21853 - 19968: jis0208<<14 | 0x32<<7 | 0x1A,
	21854 - 19968: jis0212<<14 | 0x14<<7 | 0x3F,
	21856 - 19968: jis0212<<14 | 0x14<<7 | 0x40,
	21857 - 19968: jis0212<<14 | 0x14<<7 | 0x41,
	21859 - 19968: jis0208<<14 | 0x32<<7 | 0x11,
	21860 - 19968: jis0212<<14 | 0x14<<7 | 0x42,
	21862 - 19968: jis0212<<14 | 0x14<<7 | 0x43,
	21883 - 19968: jis0208<<14 | 0x32<<7 | 0x20,
	21884 - 19968: jis0208<<14 | 0x32<<7 | 0x25,
	21886 - 19968: jis0208<<14 | 0x32<<7 | 0x21,
	21887 - 19968: jis0212<<14 | 0x14<<7 | 0x44,
	21888 - 19968: jis0208<<14 | 0x32<<7 | 0x1C,
	21889 - 19968: jis0212<<14 | 0x14<<7 | 0x45,
	21890 - 19968: jis0212<<14 | 0x14<<7 | 0x46,
	21891 - 19968: jis0208<<14 | 0x32<<7 | 0x26,
	21892 - 19968: jis0208<<14 | 0x20<<7 | 0x10,
	21894 - 19968: jis0208<<14 | 0x58<<7 | 0x38,
	21895 - 19968: jis0208<<14 | 0x32<<7 | 0x28,
	21896 - 19968: jis0212<<14 | 0x14<<7 | 0x48,
	21897 - 19968: jis0208<<14 | 0x18<<7 | 0x01,
	21898 - 19968: jis0208<<14 | 0x32<<7 | 0x1E,
	21899 - 19968: jis0208<<14 | 0x22<<7 | 0x5C,
	21902 - 19968: jis0212<<14 | 0x14<<7 | 0x49,
	21903 - 19968: jis0212<<14 | 0x14<<7 | 0x4A,
	21905 - 19968: jis0212<<14 | 0x14<<7 | 0x4B,
	21906 - 19968: jis0212<<14 | 0x14<<7 | 0x4C,
	21907 - 19968: jis0212<<14 | 0x14<<7 | 0x4D,
	21908 - 19968: jis0212<<14 | 0x14<<7 | 0x4E,
	21911 - 19968: jis0212<<14 | 0x14<<7 | 0x4F,
	21912 - 19968: jis0208<<14 | 0x32<<7 | 0x22,
	21913 - 19968: jis0208<<14 | 0x32<<7 | 0x1B,
	21914 - 19968: jis0208<<14 | 0x13<<7 | 0x0C,
	21916 - 19968: jis0208<<14 | 0x13<<7 | 0x4D,
	21917 - 19968: jis0208<<14 | 0x12<<7 | 0x44,
	21918 - 19968: jis0208<<14 | 0x32<<7 | 0x23,
	21919 - 19968: jis0208<<14 | 0x32<<7 | 0x1F,
	21923 - 19968: jis0212<<14 | 0x14<<7 | 0x50,
	21924 - 19968: jis0212<<14 | 0x14<<7 | 0x51,
	21927 - 19968: jis0208<<14 | 0x16<<7 | 0x55,
	21928 - 19968: jis0208<<14 | 0x32<<7 | 0x29,
	21929 - 19968: jis0208<<14 | 0x32<<7 | 0x27,
	21930 - 19968: jis0208<<14 | 0x20<<7 | 0x32,
	21931 - 19968: jis0208<<14 | 0x14<<7 | 0x29,
	21932 - 19968: jis0208<<14 | 0x15<<7 | 0x0B,
	21933 - 19968: jis0212<<14 | 0x14<<7 | 0x52,
	21934 - 19968: jis0208<<14 | 0x32<<7 | 0x24,
	21936 - 19968: jis0208<<14 | 0x15<<7 | 0x53,
	21938 - 19968: jis0212<<14 | 0x14<<7 | 0x53,
	21942 - 19968: jis0208<<14 | 0x10<<7 | 0x23,
	21951 - 19968: jis0212<<14 | 0x14<<7 | 0x54,
	21953 - 19968: jis0212<<14 | 0x14<<7 | 0x55,
	21955 - 19968: jis0212<<14 | 0x14<<7 | 0x56,
	21956 - 19968: jis0208<<14 | 0x32<<7 | 0x2D,
	21957 - 19968: jis0208<<14 | 0x32<<7 | 0x2B,
	21958 - 19968: jis0212<<14 | 0x14<<7 | 0x57,
	21959 - 19968: jis0208<<14 | 0x33<<7 | 0x06,
	21961 - 19968: jis0212<<14 | 0x14<<7 | 0x58,
	21963 - 19968: jis0212<<14 | 0x14<<7 | 0x59,
	21964 - 19968: jis0212<<14 | 0x14<<7 | 0x5A,
	21966 - 19968: jis0212<<14 | 0x14<<7 | 0x5B,
	21969 - 19968: jis0212<<14 | 0x14<<7 | 0x5C,
	21970 - 19968: jis0212<<14 | 0x14<<7 | 0x5D,
	21971 - 19968: jis0212<<14 | 0x15<<7 | 0x00,
	21972 - 19968: jis0208<<14 | 0x32<<7 | 0x30,
	21975 - 19968: jis0212<<14 | 0x15<<7 | 0x01,
	21976 - 19968: jis0212<<14 | 0x15<<7 | 0x02,
	21978 - 19968: jis0208<<14 | 0x32<<7 | 0x2A,
	21979 - 19968: jis0212<<14 | 0x15<<7 | 0x03,
	21980 - 19968: jis0208<<14 | 0x32<<7 | 0x2E,
	21982 - 19968: jis0212<<14 | 0x15<<7 | 0x04,
	21983 - 19968: jis0208<<14 | 0x32<<7 | 0x2C,
	21986 - 19968: jis0212<<14 | 0x15<<7 | 0x05,
	21987 - 19968: jis0208<<14 | 0x1A<<7 | 0x2B,
	21988 - 19968: jis0208<<14 | 0x32<<7 | 0x2F,
	21993 - 19968: jis0212<<14 | 0x15<<7 | 0x06,
	22006 - 19968: jis0212<<14 | 0x15<<7 | 0x07,
	22007 - 19968: jis0208<<14 | 0x32<<7 | 0x32,
	22009 - 19968: jis0208<<14 | 0x32<<7 | 0x37,
	22013 - 19968: jis0208<<14 | 0x32<<7 | 0x35,
	22014 - 19968: jis0208<<14 | 0x32<<7 | 0x34,
	22015 - 19968: jis0212<<14 | 0x15<<7 | 0x08,
	22021 - 19968: jis0212<<14 | 0x15<<7 | 0x09,
	22022 - 19968: jis0208<<14 | 0x22<<7 | 0x11,
	22024 - 19968: jis0212<<14 | 0x15<<7 | 0x0A,
	22025 - 19968: jis0208<<14 | 0x11<<7 | 0x24,
	22026 - 19968: jis0212<<14 | 0x15<<7 | 0x0B,
	22029 - 19968: jis0212<<14 | 0x15<<7 | 0x0C,
	22030 - 19968: jis0212<<14 | 0x15<<7 | 0x0D,
	22031 - 19968: jis0212<<14 | 0x15<<7 | 0x0E,
	22032 - 19968: jis0212<<14 | 0x15<<7 | 0x0F,
	22033 - 19968: jis0212<<14 | 0x15<<7 | 0x10,
	22034 - 19968: jis0212<<14 | 0x15<<7 | 0x11,
	22036 - 19968: jis0208<<14 | 0x32<<7 | 0x31,
	22038 - 19968: jis0208<<14 | 0x32<<7 | 0x33,
	22039 - 19968: jis0208<<14 | 0x1D<<7 | 0x07,
	22040 - 19968: jis0208<<14 | 0x10<<7 | 0x12,
	22041 - 19968: jis0212<<14 | 0x15<<7 | 0x12,
	22043 - 19968: jis0208<<14 | 0x32<<7 | 0x36,
	22057 - 19968: jis0208<<14 | 0x11<<7 | 0x3D,
	22060 - 19968: jis0212<<14 | 0x15<<7 | 0x13,
	22063 - 19968: jis0208<<14 | 0x32<<7 | 0x41,
	22064 - 19968: jis0212<<14 | 0x15<<7 | 0x14,
	22065 - 19968: jis0208<<14 | 0x1D<<7 | 0x5B,
	22066 - 19968: jis0208<<14 | 0x32<<7 | 0x3D,
	22067 - 19968: jis0212<<14 | 0x15<<7 | 0x15,
	22068 - 19968: jis0208<<14 | 0x32<<7 | 0x3B,
	22069 - 19968: jis0212<<14 | 0x15<<7 | 0x16,
	22070 - 19968: jis0208<<14 | 0x32<<7 | 0x3C,
	22071 - 19968: jis0212<<14 | 0x15<<7 | 0x17,
	22072 - 19968: jis0208<<14 | 0x32<<7 | 0x3E,
	22073 - 19968: jis0212<<14 | 0x15<<7 | 0x18,
	22075 - 19968: jis0212<<14 | 0x15<<7 | 0x19,
	22076 - 19968: jis0212<<14 | 0x15<<7 | 0x1A,
	22077 - 19968: jis0212<<14 | 0x15<<7 | 0x1B,
	22079 - 19968: jis0212<<14 | 0x15<<7 | 0x1C,
	22080 - 19968: jis0212<<14 | 0x15<<7 | 0x1D,
	22081 - 19968: jis0212<<14 | 0x15<<7 | 0x1E,
	22082 - 19968: jis0208<<14 | 0x10<<7 | 0x1C,
	22083 - 19968: jis0212<<14 | 0x15<<7 | 0x1F,
	22084 - 19968: jis0212<<14 | 0x15<<7 | 0x20,
	22086 - 19968: jis0212<<14 | 0x15<<7 | 0x21,
	22089 - 19968: jis0212<<14 | 0x15<<7 | 0x22,
	22091 - 19968: jis0212<<14 | 0x15<<7 | 0x23,
	22092 - 19968: jis0208<<14 | 0x20<<7 | 0x18,
	22093 - 19968: jis0212<<14 | 0x15<<7 | 0x24,
	22094 - 19968: jis0208<<14 | 0x32<<7 | 0x38,
	22095 - 19968: jis0212<<14 | 0x15<<7 | 0x25,
	22096 - 19968: jis0208<<14 | 0x32<<7 | 0x39,
	22100 - 19968: jis0212<<14 | 0x15<<7 | 0x26,
	22107 - 19968: jis0208<<14 | 0x12<<7 | 0x59,
	22110 - 19968: jis0212<<14 | 0x15<<7 | 0x27,
	22112 - 19968: jis0212<<14 | 0x15<<7 | 0x28,
	22113 - 19968: jis0212<<14 | 0x15<<7 | 0x29,
	22114 - 19968: jis0212<<14 | 0x15<<7 | 0x2A,
	22115 - 19968: jis0212<<14 | 0x15<<7 | 0x2B,
	22116 - 19968: jis0208<<14 | 0x32<<7 | 0x40,
	22118 - 19968: jis0212<<14 | 0x15<<7 | 0x2C,
	22120 - 19968: jis0208<<14 | 0x13<<7 | 0x4E,
	22121 - 19968: jis0212<<14 | 0x15<<7 | 0x2D,
	22122 - 19968: jis0208<<14 | 0x32<<7 | 0x43,
	22123 - 19968: jis0208<<14 | 0x32<<7 | 0x3F,
	22124 - 19968: jis0208<<14 | 0x32<<7 | 0x42,
	22125 - 19968: jis0212<<14 | 0x15<<7 | 0x2E,
	22127 - 19968: jis0212<<14 | 0x15<<7 | 0x2F,
	22129 - 19968: jis0212<<14 | 0x15<<7 | 0x30,
	22130 - 19968: jis0212<<14 | 0x15<<7 | 0x31,
	22132 - 19968: jis0208<<14 | 0x29<<7 | 0x0D,
	22133 - 19968: jis0212<<14 | 0x15<<7 | 0x32,
	22136 - 19968: jis0208<<14 | 0x25<<7 | 0x34,
	22138 - 19968: jis0208<<14 | 0x27<<7 | 0x17,
	22144 - 19968: jis0208<<14 | 0x32<<7 | 0x45,
	22148 - 19968: jis0212<<14 | 0x15<<7 | 0x33,
	22149 - 19968: jis0212<<14 | 0x15<<7 | 0x34,
	22150 - 19968: jis0208<<14 | 0x32<<7 | 0x44,
	22151 - 19968: jis0208<<14 | 0x12<<7 | 0x24,
	22152 - 19968: jis0212<<14 | 0x15<<7 | 0x35,
	22154 - 19968: jis0208<<14 | 0x32<<7 | 0x46,
	22155 - 19968: jis0212<<14 | 0x15<<7 | 0x36,
	22156 - 19968: jis0212<<14 | 0x15<<7 | 0x37,
	22159 - 19968: jis0208<<14 | 0x32<<7 | 0x49,
	22164 - 19968: jis0208<<14 | 0x32<<7 | 0x48,
	22165 - 19968: jis0212<<14 | 0x15<<7 | 0x38,
	22169 - 19968: jis0212<<14 | 0x15<<7 | 0x39,
	22170 - 19968: jis0212<<14 | 0x15<<7 | 0x3A,
	22173 - 19968: jis0212<<14 | 0x15<<7 | 0x3B,
	22174 - 19968: jis0212<<14 | 0x15<<7 | 0x3C,
	22175 - 19968: jis0212<<14 | 0x15<<7 | 0x3D,
	22176 - 19968: jis0208<<14 | 0x32<<7 | 0x47,
	22178 - 19968: jis0208<<14 | 0x26<<7 | 0x18,
	22181 - 19968: jis0208<<14 | 0x32<<7 | 0x4A,
	22182 - 19968: jis0212<<14 | 0x15<<7 | 0x3E,
	22183 - 19968: jis0212<<14 | 0x15<<7 | 0x3F,
	22184 - 19968: jis0212<<14 | 0x15<<7 | 0x40,
	22185 - 19968: jis0212<<14 | 0x15<<7 | 0x41,
	22187 - 19968: jis0212<<14 | 0x15<<7 | 0x42,
	22188 - 19968: jis0212<<14 | 0x15<<7 | 0x43,
	22189 - 19968: jis0212<<14 | 0x15<<7 | 0x44,
	22190 - 19968: jis0208<<14 | 0x32<<7 | 0x4B,
	22193 - 19968: jis0212<<14 | 0x15<<7 | 0x45,
	22195 - 19968: jis0212<<14 | 0x15<<7 | 0x46,
	22196 - 19968: jis0208<<14 | 0x32<<7 | 0x4D,
	22198 - 19968: jis0208<<14 | 0x32<<7 | 0x4C,
	22199 - 19968: jis0212<<14 | 0x15<<7 | 0x47,
	22204 - 19968: jis0208<<14 | 0x32<<7 | 0x4F,
	22206 - 19968: jis0212<<14 | 0x15<<7 | 0x48,
	22208 - 19968: jis0208<<14 | 0x32<<7 | 0x52,
	22209 - 19968: jis0208<<14 | 0x32<<7 | 0x50,
	22210 - 19968: jis0208<<14 | 0x32<<7 | 0x4E,
	22211 - 19968: jis0208<<14 | 0x32<<7 | 0x51,
	22213 - 19968: jis0212<<14 | 0x15<<7 | 0x49,
	22216 - 19968: jis0208<<14 | 0x32<<7 | 0x53,
	22217 - 19968: jis0212<<14 | 0x15<<7 | 0x4A,
	22218 - 19968: jis0212<<14 | 0x15<<7 | 0x4B,
	22219 - 19968: jis0212<<14 | 0x15<<7 | 0x4C,
	22220 - 19968: jis0212<<14 | 0x15<<7 | 0x4F,
	22221 - 19968: jis0212<<14 | 0x15<<7 | 0x50,
	22222 - 19968: jis0208<<14 | 0x32<<7 | 0x54,
	22223 - 19968: jis0212<<14 | 0x15<<7 | 0x4D,
	22224 - 19968: jis0212<<14 | 0x15<<7 | 0x4E,
	22225 - 19968: jis0208<<14 | 0x32<<7 | 0x55,
	22227 - 19968: jis0208<<14 | 0x32<<7 | 0x56,
	22231 - 19968: jis0208<<14 | 0x32<<7 | 0x57,
	22232 - 19968: jis0208<<14 | 0x30<<7 | 0x24,
	22233 - 19968: jis0212<<14 | 0x15<<7 | 0x51,
	22234 - 19968: jis0208<<14 | 0x1B<<7 | 0x5B,
	22235 - 19968: jis0208<<14 | 0x1A<<7 | 0x2C,
	22236 - 19968: jis0212<<14 | 0x15<<7 | 0x52,
	22237 - 19968: jis0212<<14 | 0x15<<7 | 0x53,
	22238 - 19968: jis0208<<14 | 0x11<<7 | 0x52,
	22239 - 19968: jis0212<<14 | 0x15<<7 | 0x54,
	22240 - 19968: jis0208<<14 | 0x0F<<7 | 0x57,
	22241 - 19968: jis0212<<14 | 0x15<<7 | 0x55,
	22243 - 19968: jis0208<<14 | 0x22<<7 | 0x23,
	22244 - 19968: jis0212<<14 | 0x15<<7 | 0x56,
	22245 - 19968: jis0212<<14 | 0x15<<7 | 0x57,
	22246 - 19968: jis0212<<14 | 0x15<<7 | 0x58,
	22247 - 19968: jis0212<<14 | 0x15<<7 | 0x59,
	22248 - 19968: jis0212<<14 | 0x15<<7 | 0x5A,
	22251 - 19968: jis0212<<14 | 0x15<<7 | 0x5C,
	22253 - 19968: jis0212<<14 | 0x15<<7 | 0x5D,
	22254 - 19968: jis0208<<14 | 0x32<<7 | 0x58,
	22256 - 19968: jis0208<<14 | 0x19<<7 | 0x03,
	22257 - 19968: jis0212<<14 | 0x15<<7 | 0x5B,
	22258 - 19968: jis0208<<14 | 0x0F<<7 | 0x2E,
	22259 - 19968: jis0208<<14 | 0x1E<<7 | 0x3D,
	22262 - 19968: jis0212<<14 | 0x16<<7 | 0x00,
	22263 - 19968: jis0212<<14 | 0x16<<7 | 0x01,
	22265 - 19968: jis0208<<14 | 0x32<<7 | 0x59,
	22266 - 19968: jis0208<<14 | 0x17<<7 | 0x26,
	22269 - 19968: jis0208<<14 | 0x18<<7 | 0x50,
	22271 - 19968: jis0208<<14 | 0x32<<7 | 0x5B,
	22272 - 19968: jis0208<<14 | 0x32<<7 | 0x5A,
	22273 - 19968: jis0212<<14 | 0x16<<7 | 0x02,
	22274 - 19968: jis0212<<14 | 0x16<<7 | 0x03,
	22275 - 19968: jis0208<<14 | 0x29<<7 | 0x3F,
	22276 - 19968: jis0208<<14 | 0x32<<7 | 0x5C,
	22279 - 19968: jis0212<<14 | 0x16<<7 | 0x04,
	22280 - 19968: jis0208<<14 | 0x33<<7 | 0x00,
	22281 - 19968: jis0208<<14 | 0x32<<7 | 0x5D,
	22282 - 19968: jis0212<<14 | 0x16<<7 | 0x05,
	22283 - 19968: jis0208<<14 | 0x33<<7 | 0x01,
	22284 - 19968: jis0212<<14 | 0x16<<7 | 0x06,
	22285 - 19968: jis0208<<14 | 0x33<<7 | 0x02,
	22287 - 19968: jis0208<<14 | 0x16<<7 | 0x56,
	22289 - 19968: jis0212<<14 | 0x16<<7 | 0x07,
	22290 - 19968: jis0208<<14 | 0x10<<7 | 0x3F,
	22291 - 19968: jis0208<<14 | 0x33<<7 | 0x03,
	22293 - 19968: jis0212<<14 | 0x16<<7 | 0x08,
	22294 - 19968: jis0208<<14 | 0x33<<7 | 0x05,
	22296 - 19968: jis0208<<14 | 0x33<<7 | 0x04,
	22298 - 19968: jis0212<<14 | 0x16<<7 | 0x09,
	22299 - 19968: jis0212<<14 | 0x16<<7 | 0x0A,
	22300 - 19968: jis0208<<14 | 0x33<<7 | 0x07,
	22301 - 19968: jis0212<<14 | 0x16<<7 | 0x0B,
	22303 - 19968: jis0208<<14 | 0x24<<7 | 0x39,
	22304 - 19968: jis0212<<14 | 0x16<<7 | 0x0C,
	22306 - 19968: jis0212<<14 | 0x16<<7 | 0x0D,
	22307 - 19968: jis0212<<14 | 0x16<<7 | 0x0E,
	22308 - 19968: jis0212<<14 | 0x16<<7 | 0x0F,
	22309 - 19968: jis0212<<14 | 0x16<<7 | 0x10,
	22310 - 19968: jis0208<<14 | 0x33<<7 | 0x08,
	22311 - 19968: jis0208<<14 | 0x0F<<7 | 0x14,
	22312 - 19968: jis0208<<14 | 0x19<<7 | 0x3E,
	22313 - 19968: jis0212<<14 | 0x16<<7 | 0x11,
	22314 - 19968: jis0212<<14 | 0x16<<7 | 0x12,
	22316 - 19968: jis0212<<14 | 0x16<<7 | 0x13,
	22317 - 19968: jis0208<<14 | 0x16<<7 | 0x1C,
	22318 - 19968: jis0212<<14 | 0x16<<7 | 0x14,
	22319 - 19968: jis0212<<14 | 0x16<<7 | 0x15,
	22320 - 19968: jis0208<<14 | 0x22<<7 | 0x2E,
	22323 - 19968: jis0212<<14 | 0x16<<7 | 0x16,
	22324 - 19968: jis0212<<14 | 0x16<<7 | 0x17,
	22327 - 19968: jis0208<<14 | 0x33<<7 | 0x09,
	22328 - 19968: jis0208<<14 | 0x33<<7 | 0x0A,
	22331 - 19968: jis0208<<14 | 0x33<<7 | 0x0C,
	22333 - 19968: jis0212<<14 | 0x16<<7 | 0x18,
	22334 - 19968: jis0212<<14 | 0x16<<7 | 0x19,
	22335 - 19968: jis0212<<14 | 0x16<<7 | 0x1A,
	22336 - 19968: jis0208<<14 | 0x33<<7 | 0x0D,
	22338 - 19968: jis0208<<14 | 0x19<<7 | 0x43,
	22341 - 19968: jis0212<<14 | 0x16<<7 | 0x1B,
	22342 - 19968: jis0212<<14 | 0x16<<7 | 0x1C,
	22343 - 19968: jis0208<<14 | 0x15<<7 | 0x30,
	22346 - 19968: jis0208<<14 | 0x2A<<7 | 0x16,
	22348 - 19968: jis0212<<14 | 0x16<<7 | 0x1D,
	22349 - 19968: jis0212<<14 | 0x16<<7 | 0x1E,
	22350 - 19968: jis0208<<14 | 0x33<<7 | 0x0B,
	22351 - 19968: jis0208<<14 | 0x33<<7 | 0x0E,
	22352 - 19968: jis0208<<14 | 0x19<<7 | 0x20,
	22353 - 19968: jis0208<<14 | 0x18<<7 | 0x02,
	22354 - 19968: jis0212<<14 | 0x16<<7 | 0x1F,
	22361 - 19968: jis0208<<14 | 0x58<<7 | 0x39,
	22369 - 19968: jis0208<<14 | 0x33<<7 | 0x12,
	22370 - 19968: jis0212<<14 | 0x16<<7 | 0x20,
	22372 - 19968: jis0208<<14 | 0x19<<7 | 0x04,
	22373 - 19968: jis0208<<14 | 0x58<<7 | 0x3A,
	22374 - 19968: jis0208<<14 | 0x22<<7 | 0x12,
	22375 - 19968: jis0212<<14 | 0x16<<7 | 0x22,
	22376 - 19968: jis0212<<14 | 0x16<<7 | 0x23,
	22377 - 19968: jis0208<<14 | 0x33<<7 | 0x0F,
	22378 - 19968: jis0208<<14 | 0x23<<7 | 0x39,
	22379 - 19968: jis0212<<14 | 0x16<<7 | 0x24,
	22381 - 19968: jis0212<<14 | 0x16<<7 | 0x25,
	22382 - 19968: jis0212<<14 | 0x16<<7 | 0x26,
	22383 - 19968: jis0212<<14 | 0x16<<7 | 0x27,
	22384 - 19968: jis0212<<14 | 0x16<<7 | 0x28,
	22385 - 19968: jis0212<<14 | 0x16<<7 | 0x29,
	22387 - 19968: jis0212<<14 | 0x16<<7 | 0x2A,
	22388 - 19968: jis0212<<14 | 0x16<<7 | 0x2B,
	22389 - 19968: jis0212<<14 | 0x16<<7 | 0x2C,
	22391 - 19968: jis0212<<14 | 0x16<<7 | 0x2D,
	22393 - 19968: jis0212<<14 | 0x16<<7 | 0x2E,
	22394 - 19968: jis0212<<14 | 0x16<<7 | 0x2F,
	22395 - 19968: jis0212<<14 | 0x16<<7 | 0x30,
	22396 - 19968: jis0212<<14 | 0x16<<7 | 0x31,
	22398 - 19968: jis0212<<14 | 0x16<<7 | 0x32,
	22399 - 19968: jis0208<<14 | 0x33<<7 | 0x13,
	22401 - 19968: jis0212<<14 | 0x16<<7 | 0x33,
	22402 - 19968: jis0208<<14 | 0x1E<<7 | 0x41,
	22403 - 19968: jis0212<<14 | 0x16<<7 | 0x34,
	22408 - 19968: jis0208<<14 | 0x33<<7 | 0x11,
	22409 - 19968: jis0208<<14 | 0x33<<7 | 0x14,
	22411 - 19968: jis0208<<14 | 0x16<<7 | 0x1E,
	22412 - 19968: jis0212<<14 | 0x16<<7 | 0x35,
	22419 - 19968: jis0208<<14 | 0x33<<7 | 0x15,
	22420 - 19968: jis0212<<14 | 0x16<<7 | 0x36,
	22421 - 19968: jis0212<<14 | 0x16<<7 | 0x3F,
	22423 - 19968: jis0212<<14 | 0x16<<7 | 0x37,
	22425 - 19968: jis0212<<14 | 0x16<<7 | 0x38,
	22426 - 19968: jis0212<<14 | 0x16<<7 | 0x39,
	22428 - 19968: jis0212<<14 | 0x16<<7 | 0x3A,
	22429 - 19968: jis0212<<14 | 0x16<<7 | 0x3B,
	22430 - 19968: jis0212<<14 | 0x16<<7 | 0x3C,
	22431 - 19968: jis0212<<14 | 0x16<<7 | 0x3D,
	22432 - 19968: jis0208<<14 | 0x33<<7 | 0x16,
	22433 - 19968: jis0212<<14 | 0x16<<7 | 0x3E,
	22434 - 19968: jis0208<<14 | 0x18<<7 | 0x03,
	22435 - 19968: jis0208<<14 | 0x12<<7 | 0x1F,
	22436 - 19968: jis0208<<14 | 0x33<<7 | 0x18,
	22439 - 19968: jis0212<<14 | 0x16<<7 | 0x40,
	22440 - 19968: jis0212<<14 | 0x16<<7 | 0x41,
	22441 - 19968: jis0212<<14 | 0x16<<7 | 0x42,
	22442 - 19968: jis0208<<14 | 0x33<<7 | 0x19,
	22444 - 19968: jis0208<<14 | 0x58<<7 | 0x3B,
	22448 - 19968: jis0208<<14 | 0x33<<7 | 0x1A,
	22451 - 19968: jis0208<<14 | 0x33<<7 | 0x17,
	22456 - 19968: jis0212<<14 | 0x16<<7 | 0x44,
	22461 - 19968: jis0212<<14 | 0x16<<7 | 0x45,
	22464 - 19968: jis0208<<14 | 0x33<<7 | 0x10,
	22467 - 19968: jis0208<<14 | 0x33<<7 | 0x1B,
	22470 - 19968: jis0208<<14 | 0x33<<7 | 0x1C,
	22471 - 19968: jis0208<<14 | 0x58<<7 | 0x3D,
	22472 - 19968: jis0208<<14 | 0x58<<7 | 0x3C,
	22475 - 19968: jis0208<<14 | 0x2A<<7 | 0x43,
	22476 - 19968: jis0212<<14 | 0x16<<7 | 0x48,
	22478 - 19968: jis0208<<14 | 0x1D<<7 | 0x4A,
	22479 - 19968: jis0212<<14 | 0x16<<7 | 0x49,
	22482 - 19968: jis0208<<14 | 0x33<<7 | 0x1E,
	22483 - 19968: jis0208<<14 | 0x33<<7 | 0x1F,
	22484 - 19968: jis0208<<14 | 0x33<<7 | 0x1D,
	22485 - 19968: jis0212<<14 | 0x16<<7 | 0x4A,
	22486 - 19968: jis0208<<14 | 0x33<<7 | 0x21,
	22492 - 19968: jis0208<<14 | 0x26<<7 | 0x17,
	22493 - 19968: jis0212<<14 | 0x16<<7 | 0x4B,
	22494 - 19968: jis0212<<14 | 0x16<<7 | 0x4C,
	22495 - 19968: jis0208<<14 | 0x0F<<7 | 0x47,
	22496 - 19968: jis0208<<14 | 0x28<<7 | 0x35,
	22497 - 19968: jis0212<<14 | 0x16<<7 | 0x5D,
	22499 - 19968: jis0208<<14 | 0x33<<7 | 0x22,
	22500 - 19968: jis0212<<14 | 0x16<<7 | 0x4D,
	22502 - 19968: jis0212<<14 | 0x16<<7 | 0x4E,
	22503 - 19968: jis0212<<14 | 0x16<<7 | 0x4F,
	22505 - 19968: jis0212<<14 | 0x16<<7 | 0x50,
	22509 - 19968: jis0212<<14 | 0x16<<7 | 0x51,
	22512 - 19968: jis0212<<14 | 0x16<<7 | 0x52,
	22516 - 19968: jis0208<<14 | 0x1D<<7 | 0x5C,
	22517 - 19968: jis0212<<14 | 0x16<<7 | 0x53,
	22518 - 19968: jis0212<<14 | 0x16<<7 | 0x54,
	22519 - 19968: jis0208<<14 | 0x1B<<7 | 0x18,
	22520 - 19968: jis0212<<14 | 0x16<<7 | 0x55,
	22521 - 19968: jis0208<<14 | 0x26<<7 | 0x3C,
	22522 - 19968: jis0208<<14 | 0x13<<7 | 0x4F,
	22524 - 19968: jis0208<<14 | 0x19<<7 | 0x4A,
	22525 - 19968: jis0212<<14 | 0x16<<7 | 0x56,
	22526 - 19968: jis0212<<14 | 0x16<<7 | 0x57,
	22527 - 19968: jis0212<<14 | 0x16<<7 | 0x58,
	22528 - 19968: jis0208<<14 | 0x2A<<7 | 0x38,
	22530 - 19968: jis0208<<14 | 0x25<<7 | 0x11,
	22531 - 19968: jis0212<<14 | 0x16<<7 | 0x59,
	22532 - 19968: jis0212<<14 | 0x16<<7 | 0x5A,
	22533 - 19968: jis0208<<14 | 0x16<<7 | 0x57,
	22534 - 19968: jis0208<<14 | 0x21<<7 | 0x2E,
	22536 - 19968: jis0212<<14 | 0x16<<7 | 0x5B,
	22537 - 19968: jis0212<<14 | 0x16<<7 | 0x5C,
	22538 - 19968: jis0208<<14 | 0x33<<7 | 0x20,
	22539 - 19968: jis0208<<14 | 0x33<<7 | 0x23,
	22540 - 19968: jis0212<<14 | 0x17<<7 | 0x00,
	22541 - 19968: jis0212<<14 | 0x17<<7 | 0x01,
	22549 - 19968: jis0208<<14 | 0x21<<7 | 0x23,
	22553 - 19968: jis0208<<14 | 0x33<<7 | 0x24,
	22555 - 19968: jis0212<<14 | 0x17<<7 | 0x02,
	22557 - 19968: jis0208<<14 | 0x33<<7 | 0x25,
	22558 - 19968: jis0212<<14 | 0x17<<7 | 0x03,
	22559 - 19968: jis0212<<14 | 0x17<<7 | 0x04,
	22560 - 19968: jis0212<<14 | 0x17<<7 | 0x05,
	22561 - 19968: jis0208<<14 | 0x33<<7 | 0x27,
	22564 - 19968: jis0208<<14 | 0x23<<7 | 0x48,
	22566 - 19968: jis0212<<14 | 0x17<<7 | 0x06,
	22567 - 19968: jis0212<<14 | 0x17<<7 | 0x07,
	22570 - 19968: jis0208<<14 | 0x13<<7 | 0x0D,
	22573 - 19968: jis0212<<14 | 0x17<<7 | 0x08,
	22575 - 19968: jis0208<<14 | 0x53<<7 | 0x00,
	22576 - 19968: jis0208<<14 | 0x10<<7 | 0x40,
	22577 - 19968: jis0208<<14 | 0x29<<7 | 0x52,
	22578 - 19968: jis0212<<14 | 0x17<<7 | 0x09,
	22580 - 19968: jis0208<<14 | 0x1D<<7 | 0x4B,
	22581 - 19968: jis0208<<14 | 0x24<<7 | 0x27,
	22585 - 19968: jis0212<<14 | 0x17<<7 | 0x0A,
	22586 - 19968: jis0208<<14 | 0x19<<7 | 0x45,
	22589 - 19968: jis0208<<14 | 0x33<<7 | 0x2D,
	22591 - 19968: jis0212<<14 | 0x17<<7 | 0x0B,
	22592 - 19968: jis0208<<14 | 0x29<<7 | 0x1C,
	22593 - 19968: jis0208<<14 | 0x2D<<7 | 0x3C,
	22601 - 19968: jis0212<<14 | 0x17<<7 | 0x0C,
	22602 - 19968: jis0208<<14 | 0x11<<7 | 0x53,
	22603 - 19968: jis0208<<14 | 0x33<<7 | 0x29,
	22604 - 19968: jis0212<<14 | 0x17<<7 | 0x0D,
	22605 - 19968: jis0212<<14 | 0x17<<7 | 0x0E,
	22607 - 19968: jis0212<<14 | 0x17<<7 | 0x0F,
	22608 - 19968: jis0212<<14 | 0x17<<7 | 0x10,
	22609 - 19968: jis0208<<14 | 0x20<<7 | 0x19,
	22610 - 19968: jis0208<<14 | 0x33<<7 | 0x2C,
	22612 - 19968: jis0208<<14 | 0x24<<7 | 0x42,
	22613 - 19968: jis0212<<14 | 0x17<<7 | 0x11,
	22615 - 19968: jis0208<<14 | 0x24<<7 | 0x28,
	22616 - 19968: jis0208<<14 | 0x24<<7 | 0x43,
	22617 - 19968: jis0208<<14 | 0x27<<7 | 0x18,
	22618 - 19968: jis0208<<14 | 0x23<<7 | 0x2C,
	22622 - 19968: jis0208<<14 | 0x19<<7 | 0x28,
	22623 - 19968: jis0212<<14 | 0x17<<7 | 0x12,
	22625 - 19968: jis0212<<14 | 0x17<<7 | 0x13,
	22626 - 19968: jis0208<<14 | 0x33<<7 | 0x28,
	22628 - 19968: jis0212<<14 | 0x17<<7 | 0x14,
	22631 - 19968: jis0212<<14 | 0x17<<7 | 0x15,
	22632 - 19968: jis0212<<14 | 0x17<<7 | 0x16,
	22633 - 19968: jis0208<<14 | 0x10<<7 | 0x55,
	22635 - 19968: jis0208<<14 | 0x24<<7 | 0x15,
	22640 - 19968: jis0208<<14 | 0x33<<7 | 0x2A,
	22642 - 19968: jis0208<<14 | 0x33<<7 | 0x26,
	22645 - 19968: jis0208<<14 | 0x1E<<7 | 0x2F,
	22648 - 19968: jis0212<<14 | 0x17<<7 | 0x17,
	22649 - 19968: jis0208<<14 | 0x33<<7 | 0x2E,
	22652 - 19968: jis0212<<14 | 0x17<<7 | 0x18,
	22654 - 19968: jis0208<<14 | 0x1C<<7 | 0x2D,
	22655 - 19968: jis0212<<14 | 0x17<<7 | 0x19,
	22656 - 19968: jis0212<<14 | 0x17<<7 | 0x1A,
	22657 - 19968: jis0212<<14 | 0x17<<7 | 0x1B,
	22659 - 19968: jis0208<<14 | 0x15<<7 | 0x0C,
	22661 - 19968: jis0208<<14 | 0x33<<7 | 0x2F,
	22663 - 19968: jis0212<<14 | 0x17<<7 | 0x1C,
	22664 - 19968: jis0212<<14 | 0x17<<7 | 0x1D,
	22665 - 19968: jis0212<<14 | 0x17<<7 | 0x1E,
	22666 - 19968: jis0212<<14 | 0x17<<7 | 0x1F,
	22668 - 19968: jis0212<<14 | 0x17<<7 | 0x20,
	22669 - 19968: jis0212<<14 | 0x17<<7 | 0x21,
	22671 - 19968: jis0212<<14 | 0x17<<7 | 0x22,
	22672 - 19968: jis0212<<14 | 0x17<<7 | 0x23,
	22675 - 19968: jis0208<<14 | 0x29<<7 | 0x47,
	22676 - 19968: jis0212<<14 | 0x17<<7 | 0x24,
	22678 - 19968: jis0212<<14 | 0x17<<7 | 0x25,
	22679 - 19968: jis0208<<14 | 0x20<<7 | 0x5C,
	22684 - 19968: jis0208<<14 | 0x23<<7 | 0x25,
	22685 - 19968: jis0212<<14 | 0x17<<7 | 0x26,
	22686 - 19968: jis0208<<14 | 0x58<<7 | 0x40,
	22687 - 19968: jis0208<<14 | 0x33<<7 | 0x31,
	22688 - 19968: jis0212<<14 | 0x17<<7 | 0x27,
	22689 - 19968: jis0212<<14 | 0x17<<7 | 0x28,
	22690 - 19968: jis0212<<14 | 0x17<<7 | 0x29,
	22694 - 19968: jis0212<<14 | 0x17<<7 | 0x2A,
	22696 - 19968: jis0208<<14 | 0x2A<<7 | 0x2E,
	22697 - 19968: jis0212<<14 | 0x17<<7 | 0x2B,
	22699 - 19968: jis0208<<14 | 0x33<<7 | 0x32,
	22702 - 19968: jis0208<<14 | 0x33<<7 | 0x37,
	22705 - 19968: jis0212<<14 | 0x17<<7 | 0x2C,
	22706 - 19968: jis0208<<14 | 0x58<<7 | 0x41,
	22707 - 19968: jis0208<<14 | 0x29<<7 | 0x0E,
	22712 - 19968: jis0208<<14 | 0x33<<7 | 0x36,
	22713 - 19968: jis0208<<14 | 0x33<<7 | 0x30,
	22714 - 19968: jis0208<<14 | 0x33<<7 | 0x33,
	22715 - 19968: jis0208<<14 | 0x33<<7 | 0x35,
	22716 - 19968: jis0212<<14 | 0x17<<7 | 0x2F,
	22718 - 19968: jis0208<<14 | 0x19<<7 | 0x05,
	22721 - 19968: jis0208<<14 | 0x29<<7 | 0x28,
	22722 - 19968: jis0212<<14 | 0x17<<7 | 0x30,
	22724 - 19968: jis0212<<14 | 0x17<<7 | 0x2E,
	22725 - 19968: jis0208<<14 | 0x33<<7 | 0x38,
	22727 - 19968: jis0208<<14 | 0x22<<7 | 0x24,
	22728 - 19968: jis0212<<14 | 0x17<<7 | 0x31,
	22730 - 19968: jis0208<<14 | 0x11<<7 | 0x54,
	22732 - 19968: jis0208<<14 | 0x1D<<7 | 0x4C,
	22733 - 19968: jis0212<<14 | 0x17<<7 | 0x32,
	22734 - 19968: jis0212<<14 | 0x17<<7 | 0x33,
	22736 - 19968: jis0212<<14 | 0x17<<7 | 0x34,
	22737 - 19968: jis0208<<14 | 0x33<<7 | 0x3A,
	22738 - 19968: jis0212<<14 | 0x17<<7 | 0x35,
	22739 - 19968: jis0208<<14 | 0x33<<7 | 0x39,
	22740 - 19968: jis0212<<14 | 0x17<<7 | 0x36,
	22741 - 19968: jis0208<<14 | 0x18<<7 | 0x47,
	22742 - 19968: jis0212<<14 | 0x17<<7 | 0x37,
	22743 - 19968: jis0208<<14 | 0x33<<7 | 0x3B,
	22744 - 19968: jis0208<<14 | 0x33<<7 | 0x3D,
	22745 - 19968: jis0208<<14 | 0x33<<7 | 0x3C,
	22746 - 19968: jis0212<<14 | 0x17<<7 | 0x38,
	22748 - 19968: jis0208<<14 | 0x33<<7 | 0x3F,
	22749 - 19968: jis0212<<14 | 0x17<<7 | 0x39,
	22750 - 19968: jis0208<<14 | 0x33<<7 | 0x34,
	22751 - 19968: jis0208<<14 | 0x33<<7 | 0x41,
	22753 - 19968: jis0212<<14 | 0x17<<7 | 0x3A,
	22754 - 19968: jis0212<<14 | 0x17<<7 | 0x3B,
	22756 - 19968: jis0208<<14 | 0x33<<7 | 0x40,
	22757 - 19968: jis0208<<14 | 0x33<<7 | 0x3E,
	22761 - 19968: jis0212<<14 | 0x17<<7 | 0x3C,
	22763 - 19968: jis0208<<14 | 0x1A<<7 | 0x2D,
	22764 - 19968: jis0208<<14 | 0x1E<<7 | 0x30,
	22766 - 19968: jis0208<<14 | 0x20<<7 | 0x33,
	22767 - 19968: jis0208<<14 | 0x33<<7 | 0x42,
	22768 - 19968: jis0208<<14 | 0x1F<<7 | 0x1B,
	22769 - 19968: jis0208<<14 | 0x0F<<7 | 0x4C,
	22770 - 19968: jis0208<<14 | 0x26<<7 | 0x43,
	22771 - 19968: jis0212<<14 | 0x17<<7 | 0x3D,
	22775 - 19968: jis0208<<14 | 0x23<<7 | 0x3A,
	22777 - 19968: jis0208<<14 | 0x33<<7 | 0x44,
	22778 - 19968: jis0208<<14 | 0x33<<7 | 0x43,
	22779 - 19968: jis0208<<14 | 0x33<<7 | 0x45,
	22780 - 19968: jis0208<<14 | 0x33<<7 | 0x46,
	22781 - 19968: jis0208<<14 | 0x33<<7 | 0x47,
	22786 - 19968: jis0208<<14 | 0x33<<7 | 0x48,
	22789 - 19968: jis0212<<14 | 0x17<<7 | 0x3E,
	22790 - 19968: jis0212<<14 | 0x17<<7 | 0x3F,
	22793 - 19968: jis0208<<14 | 0x29<<7 | 0x30,
	22794 - 19968: jis0208<<14 | 0x33<<7 | 0x49,
	22795 - 19968: jis0208<<14 | 0x58<<7 | 0x42,
	22796 - 19968: jis0212<<14 | 0x17<<7 | 0x41,
	22799 - 19968: jis0208<<14 | 0x11<<7 | 0x25,
	22800 - 19968: jis0208<<14 | 0x33<<7 | 0x4A,
	22802 - 19968: jis0212<<14 | 0x17<<7 | 0x42,
	22803 - 19968: jis0212<<14 | 0x17<<7 | 0x43,
	22804 - 19968: jis0212<<14 | 0x17<<7 | 0x44,
	22805 - 19968: jis0208<<14 | 0x2C<<7 | 0x1B,
	22806 - 19968: jis0208<<14 | 0x12<<7 | 0x0F,
	22808 - 19968: jis0208<<14 | 0x31<<7 | 0x28,
	22809 - 19968: jis0208<<14 | 0x1C<<7 | 0x27,
	22810 - 19968: jis0208<<14 | 0x21<<7 | 0x1E,
	22811 - 19968: jis0208<<14 | 0x33<<7 | 0x4B,
	22812 - 19968: jis0208<<14 | 0x2B<<7 | 0x4A,
	22813 - 19968: jis0212<<14 | 0x17<<7 | 0x46,
	22817 - 19968: jis0212<<14 | 0x17<<7 | 0x47,
	22818 - 19968: jis0208<<14 | 0x2B<<7 | 0x13,
	22819 - 19968: jis0212<<14 | 0x17<<7 | 0x48,
	22820 - 19968: jis0212<<14 | 0x17<<7 | 0x49,
	22821 - 19968: jis0208<<14 | 0x33<<7 | 0x4D,
	22823 - 19968: jis0208<<14 | 0x21<<7 | 0x46,
	22824 - 19968: jis0212<<14 | 0x17<<7 | 0x4A,
	22825 - 19968: jis0208<<14 | 0x24<<7 | 0x16,
	22826 - 19968: jis0208<<14 | 0x21<<7 | 0x1F,
	22827 - 19968: jis0208<<14 | 0x28<<7 | 0x36,
	22828 - 19968: jis0208<<14 | 0x33<<7 | 0x4E,
	22829 - 19968: jis0208<<14 | 0x33<<7 | 0x4F,
	22830 - 19968: jis0208<<14 | 0x10<<7 | 0x5A,
	22831 - 19968: jis0212<<14 | 0x17<<7 | 0x4B,
	22832 - 19968: jis0212<<14 | 0x17<<7 | 0x4C,
	22833 - 19968: jis0208<<14 | 0x1B<<7 | 0x19,
	22834 - 19968: jis0208<<14 | 0x33<<7 | 0x50,
	22835 - 19968: jis0212<<14 | 0x17<<7 | 0x4D,
	22837 - 19968: jis0212<<14 | 0x17<<7 | 0x4E,
	22838 - 19968: jis0212<<14 | 0x17<<7 | 0x4F,
	22839 - 19968: jis0208<<14 | 0x0F<<7 | 0x2F,
	22840 - 19968: jis0208<<14 | 0x33<<7 | 0x51,
	22846 - 19968: jis0208<<14 | 0x33<<7 | 0x52,
	22847 - 19968: jis0212<<14 | 0x17<<7 | 0x50,
	22851 - 19968: jis0212<<14 | 0x17<<7 | 0x51,
	22852 - 19968: jis0208<<14 | 0x10<<7 | 0x41,
	22854 - 19968: jis0212<<14 | 0x17<<7 | 0x52,
	22855 - 19968: jis0208<<14 | 0x13<<7 | 0x50,
	22856 - 19968: jis0208<<14 | 0x25<<7 | 0x3F,
	22857 - 19968: jis0208<<14 | 0x29<<7 | 0x53,
	22862 - 19968: jis0208<<14 | 0x33<<7 | 0x56,
	22863 - 19968: jis0208<<14 | 0x20<<7 | 0x34,
	22864 - 19968: jis0208<<14 | 0x33<<7 | 0x55,
	22865 - 19968: jis0208<<14 | 0x16<<7 | 0x1F,
	22866 - 19968: jis0212<<14 | 0x17<<7 | 0x53,
	22867 - 19968: jis0208<<14 | 0x58<<7 | 0x43,
	22868 - 19968: jis0208<<14 | 0x2A<<7 | 0x3A,
	22869 - 19968: jis0208<<14 | 0x33<<7 | 0x54,
	22871 - 19968: jis0208<<14 | 0x24<<7 | 0x44,
	22872 - 19968: jis0208<<14 | 0x33<<7 | 0x58,
	22873 - 19968: jis0212<<14 | 0x17<<7 | 0x55,
	22874 - 19968: jis0208<<14 | 0x33<<7 | 0x57,
	22875 - 19968: jis0208<<14 | 0x58<<7 | 0x44,
	22877 - 19968: jis0208<<14 | 0x58<<7 | 0x45,
	22878 - 19968: jis0212<<14 | 0x17<<7 | 0x58,
	22879 - 19968: jis0212<<14 | 0x17<<7 | 0x59,
	22880 - 19968: jis0208<<14 | 0x33<<7 | 0x5A,
	22881 - 19968: jis0212<<14 | 0x17<<7 | 0x5A,
	22882 - 19968: jis0208<<14 | 0x33<<7 | 0x59,
	22883 - 19968: jis0208<<14 | 0x58<<7 | 0x46,
	22885 - 19968: jis0208<<14 | 0x10<<7 | 0x5B,
	22887 - 19968: jis0208<<14 | 0x33<<7 | 0x5B,
	22888 - 19968: jis0208<<14 | 0x1D<<7 | 0x08,
	22889 - 19968: jis0208<<14 | 0x33<<7 | 0x5D,
	22890 - 19968: jis0208<<14 | 0x22<<7 | 0x04,
	22891 - 19968: jis0212<<14 | 0x17<<7 | 0x5C,
	22892 - 19968: jis0208<<14 | 0x33<<7 | 0x5C,
	22893 - 19968: jis0212<<14 | 0x17<<7 | 0x5D,
	22894 - 19968: jis0208<<14 | 0x29<<7 | 0x12,
	22895 - 19968: jis0212<<14 | 0x18<<7 | 0x00,
	22898 - 19968: jis0212<<14 | 0x18<<7 | 0x01,
	22899 - 19968: jis0208<<14 | 0x1C<<7 | 0x56,
	22900 - 19968: jis0208<<14 | 0x24<<7 | 0x3A,
	22901 - 19968: jis0212<<14 | 0x18<<7 | 0x02,
	22902 - 19968: jis0212<<14 | 0x18<<7 | 0x03,
	22904 - 19968: jis0208<<14 | 0x34<<7 | 0x00,
	22905 - 19968: jis0212<<14 | 0x18<<7 | 0x04,
	22907 - 19968: jis0212<<14 | 0x18<<7 | 0x05,
	22908 - 19968: jis0212<<14 | 0x18<<7 | 0x06,
	22909 - 19968: jis0208<<14 | 0x18<<7 | 0x04,
	22913 - 19968: jis0208<<14 | 0x34<<7 | 0x01,
	22914 - 19968: jis0208<<14 | 0x26<<7 | 0x00,
	22915 - 19968: jis0208<<14 | 0x27<<7 | 0x3D,
	22916 - 19968: jis0208<<14 | 0x2B<<7 | 0x30,
	22922 - 19968: jis0208<<14 | 0x26<<7 | 0x04,
	22923 - 19968: jis0212<<14 | 0x18<<7 | 0x07,
	22924 - 19968: jis0212<<14 | 0x18<<7 | 0x08,
	22925 - 19968: jis0208<<14 | 0x34<<7 | 0x0A,
	22926 - 19968: jis0212<<14 | 0x18<<7 | 0x09,
	22930 - 19968: jis0212<<14 | 0x18<<7 | 0x0A,
	22931 - 19968: jis0208<<14 | 0x14<<7 | 0x17,
	22933 - 19968: jis0212<<14 | 0x18<<7 | 0x0B,
	22934 - 19968: jis0208<<14 | 0x2C<<7 | 0x24,
	22935 - 19968: jis0212<<14 | 0x18<<7 | 0x0C,
	22937 - 19968: jis0208<<14 | 0x2B<<7 | 0x0E,
	22939 - 19968: jis0208<<14 | 0x35<<7 | 0x0B,
	22941 - 19968: jis0208<<14 | 0x34<<7 | 0x02,
	22943 - 19968: jis0212<<14 | 0x18<<7 | 0x0D,
	22947 - 19968: jis0208<<14 | 0x34<<7 | 0x05,
	22948 - 19968: jis0208<<14 | 0x58<<7 | 0x47,
	22949 - 19968: jis0208<<14 | 0x21<<7 | 0x24,
	22951 - 19968: jis0212<<14 | 0x18<<7 | 0x0F,
	22952 - 19968: jis0208<<14 | 0x2A<<7 | 0x17,
	22956 - 19968: jis0208<<14 | 0x24<<7 | 0x29,
	22957 - 19968: jis0212<<14 | 0x18<<7 | 0x10,
	22958 - 19968: jis0212<<14 | 0x18<<7 | 0x11,
	22959 - 19968: jis0212<<14 | 0x18<<7 | 0x12,
	22960 - 19968: jis0212<<14 | 0x18<<7 | 0x13,
	22962 - 19968: jis0208<<14 | 0x34<<7 | 0x06,
	22963 - 19968: jis0212<<14 | 0x18<<7 | 0x14,
	22967 - 19968: jis0212<<14 | 0x18<<7 | 0x15,
	22969 - 19968: jis0208<<14 | 0x2A<<7 | 0x44,
	22970 - 19968: jis0208<<14 | 0x58<<7 | 0x48,
	22971 - 19968: jis0208<<14 | 0x19<<7 | 0x29,
	22972 - 19968: jis0212<<14 | 0x18<<7 | 0x17,
	22974 - 19968: jis0208<<14 | 0x1D<<7 | 0x09,
	22977 - 19968: jis0212<<14 | 0x18<<7 | 0x18,
	22979 - 19968: jis0212<<14 | 0x18<<7 | 0x19,
	22980 - 19968: jis0212<<14 | 0x18<<7 | 0x1A,
	22982 - 19968: jis0208<<14 | 0x34<<7 | 0x07,
	22984 - 19968: jis0212<<14 | 0x18<<7 | 0x1B,
	22985 - 19968: jis0208<<14 | 0x1A<<7 | 0x2F,
	22986 - 19968: jis0212<<14 | 0x18<<7 | 0x1C,
	22987 - 19968: jis0208<<14 | 0x1A<<7 | 0x2E,
	22989 - 19968: jis0212<<14 | 0x18<<7 | 0x1D,
	22992 - 19968: jis0208<<14 | 0x0F<<7 | 0x18,
	22993 - 19968: jis0208<<14 | 0x17<<7 | 0x27,
	22994 - 19968: jis0212<<14 | 0x18<<7 | 0x1E,
	22995 - 19968: jis0208<<14 | 0x1F<<7 | 0x0A,
	22996 - 19968: jis0208<<14 | 0x0F<<7 | 0x30,
	23001 - 19968: jis0208<<14 | 0x34<<7 | 0x0B,
	23002 - 19968: jis0208<<14 | 0x34<<7 | 0x0C,
	23004 - 19968: jis0208<<14 | 0x34<<7 | 0x09,
	23005 - 19968: jis0212<<14 | 0x18<<7 | 0x1F,
	23006 - 19968: jis0212<<14 | 0x18<<7 | 0x20,
	23007 - 19968: jis0212<<14 | 0x18<<7 | 0x21,
	23011 - 19968: jis0212<<14 | 0x18<<7 | 0x22,
	23012 - 19968: jis0212<<14 | 0x18<<7 | 0x23,
	23013 - 19968: jis0208<<14 | 0x10<<7 | 0x17,
	23014 - 19968: jis0208<<14 | 0x13<<7 | 0x0E,
	23015 - 19968: jis0212<<14 | 0x18<<7 | 0x24,
	23016 - 19968: jis0208<<14 | 0x34<<7 | 0x08,
	23018 - 19968: jis0208<<14 | 0x2B<<7 | 0x24,
	23019 - 19968: jis0208<<14 | 0x28<<7 | 0x10,
	23022 - 19968: jis0212<<14 | 0x18<<7 | 0x25,
	23023 - 19968: jis0212<<14 | 0x18<<7 | 0x26,
	23025 - 19968: jis0212<<14 | 0x18<<7 | 0x27,
	23026 - 19968: jis0212<<14 | 0x18<<7 | 0x28,
	23028 - 19968: jis0212<<14 | 0x18<<7 | 0x29,
	23030 - 19968: jis0208<<14 | 0x0F<<7 | 0x07,
	23031 - 19968: jis0212<<14 | 0x18<<7 | 0x2A,
	23035 - 19968: jis0208<<14 | 0x0F<<7 | 0x58,
	23039 - 19968: jis0208<<14 | 0x1A<<7 | 0x30,
	23040 - 19968: jis0212<<14 | 0x18<<7 | 0x2B,
	23041 - 19968: jis0208<<14 | 0x0F<<7 | 0x31,
	23043 - 19968: jis0208<<14 | 0x0F<<7 | 0x02,
	23044 - 19968: jis0212<<14 | 0x18<<7 | 0x2C,
	23049 - 19968: jis0208<<14 | 0x34<<7 | 0x11,
	23052 - 19968: jis0212<<14 | 0x18<<7 | 0x2D,
	23053 - 19968: jis0212<<14 | 0x18<<7 | 0x2E,
	23054 - 19968: jis0212<<14 | 0x18<<7 | 0x2F,
	23057 - 19968: jis0208<<14 | 0x34<<7 | 0x0F,
	23058 - 19968: jis0212<<14 | 0x18<<7 | 0x30,
	23059 - 19968: jis0212<<14 | 0x18<<7 | 0x31,
	23064 - 19968: jis0208<<14 | 0x2B<<7 | 0x1B,
	23066 - 19968: jis0208<<14 | 0x34<<7 | 0x12,
	23068 - 19968: jis0208<<14 | 0x34<<7 | 0x10,
	23070 - 19968: jis0212<<14 | 0x18<<7 | 0x32,
	23071 - 19968: jis0208<<14 | 0x34<<7 | 0x0E,
	23072 - 19968: jis0208<<14 | 0x1E<<7 | 0x10,
	23075 - 19968: jis0212<<14 | 0x18<<7 | 0x33,
	23076 - 19968: jis0212<<14 | 0x18<<7 | 0x34,
	23077 - 19968: jis0208<<14 | 0x34<<7 | 0x0D,
	23079 - 19968: jis0212<<14 | 0x18<<7 | 0x35,
	23080 - 19968: jis0212<<14 | 0x18<<7 | 0x36,
	23081 - 19968: jis0208<<14 | 0x29<<7 | 0x39,
	23082 - 19968: jis0212<<14 | 0x18<<7 | 0x37,
	23085 - 19968: jis0212<<14 | 0x18<<7 | 0x38,
	23087 - 19968: jis0208<<14 | 0x17<<7 | 0x43,
	23088 - 19968: jis0212<<14 | 0x18<<7 | 0x39,
	23093 - 19968: jis0208<<14 | 0x34<<7 | 0x16,
	23094 - 19968: jis0208<<14 | 0x34<<7 | 0x17,
	23100 - 19968: jis0208<<14 | 0x1D<<7 | 0x0A,
	23104 - 19968: jis0208<<14 | 0x34<<7 | 0x13,
	23105 - 19968: jis0208<<14 | 0x2E<<7 | 0x0B,
	23108 - 19968: jis0212<<14 | 0x18<<7 | 0x3A,
	23109 - 19968: jis0212<<14 | 0x18<<7 | 0x3B,
	23110 - 19968: jis0208<<14 | 0x26<<7 | 0x2B,
	23111 - 19968: jis0212<<14 | 0x18<<7 | 0x3C,
	23112 - 19968: jis0212<<14 | 0x18<<7 | 0x3D,
	23113 - 19968: jis0208<<14 | 0x34<<7 | 0x15,
	23116 - 19968: jis0212<<14 | 0x18<<7 | 0x3E,
	23120 - 19968: jis0212<<14 | 0x18<<7 | 0x3F,
	23125 - 19968: jis0212<<14 | 0x18<<7 | 0x40,
	23130 - 19968: jis0208<<14 | 0x19<<7 | 0x06,
	23134 - 19968: jis0212<<14 | 0x18<<7 | 0x41,
	23138 - 19968: jis0208<<14 | 0x34<<7 | 0x18,
	23139 - 19968: jis0212<<14 | 0x18<<7 | 0x42,
	23141 - 19968: jis0212<<14 | 0x18<<7 | 0x43,
	23142 - 19968: jis0208<<14 | 0x28<<7 | 0x37,
	23143 - 19968: jis0212<<14 | 0x18<<7 | 0x44,
	23146 - 19968: jis0208<<14 | 0x34<<7 | 0x19,
	23148 - 19968: jis0208<<14 | 0x34<<7 | 0x14,
	23149 - 19968: jis0212<<14 | 0x18<<7 | 0x45,
	23159 - 19968: jis0212<<14 | 0x18<<7 | 0x46,
	23162 - 19968: jis0212<<14 | 0x18<<7 | 0x47,
	23163 - 19968: jis0212<<14 | 0x18<<7 | 0x48,
	23166 - 19968: jis0212<<14 | 0x18<<7 | 0x49,
	23167 - 19968: jis0208<<14 | 0x2B<<7 | 0x1A,
	23179 - 19968: jis0212<<14 | 0x18<<7 | 0x4A,
	23184 - 19968: jis0212<<14 | 0x18<<7 | 0x4B,
	23186 - 19968: jis0208<<14 | 0x26<<7 | 0x3D,
	23187 - 19968: jis0212<<14 | 0x18<<7 | 0x4C,
	23190 - 19968: jis0212<<14 | 0x18<<7 | 0x4D,
	23193 - 19968: jis0212<<14 | 0x18<<7 | 0x4E,
	23194 - 19968: jis0208<<14 | 0x34<<7 | 0x1A,
	23195 - 19968: jis0208<<14 | 0x28<<7 | 0x11,
	23196 - 19968: jis0212<<14 | 0x18<<7 | 0x4F,
	23198 - 19968: jis0212<<14 | 0x18<<7 | 0x50,
	23199 - 19968: jis0212<<14 | 0x18<<7 | 0x51,
	23200 - 19968: jis0212<<14 | 0x18<<7 | 0x52,
	23202 - 19968: jis0212<<14 | 0x18<<7 | 0x53,
	23207 - 19968: jis0212<<14 | 0x18<<7 | 0x54,
	23212 - 19968: jis0212<<14 | 0x18<<7 | 0x55,
	23217 - 19968: jis0212<<14 | 0x18<<7 | 0x56,
	23218 - 19968: jis0212<<14 | 0x18<<7 | 0x57,
	23219 - 19968: jis0212<<14 | 0x18<<7 | 0x58,
	23221 - 19968: jis0212<<14 | 0x18<<7 | 0x59,
	23224 - 19968: jis0212<<14 | 0x18<<7 | 0x5A,
	23226 - 19968: jis0212<<14 | 0x18<<7 | 0x5B,
	23227 - 19968: jis0212<<14 | 0x18<<7 | 0x5C,
	23228 - 19968: jis0208<<14 | 0x34<<7 | 0x1B,
	23229 - 19968: jis0208<<14 | 0x34<<7 | 0x1F,
	23230 - 19968: jis0208<<14 | 0x34<<7 | 0x1C,
	23231 - 19968: jis0212<<14 | 0x18<<7 | 0x5D,
	23233 - 19968: jis0208<<14 | 0x11<<7 | 0x26,
	23234 - 19968: jis0208<<14 | 0x34<<7 | 0x1E,
	23236 - 19968: jis0212<<14 | 0x19<<7 | 0x00,
	23238 - 19968: jis0212<<14 | 0x19<<7 | 0x01,
	23240 - 19968: jis0212<<14 | 0x19<<7 | 0x02,
	23241 - 19968: jis0208<<14 | 0x1B<<7 | 0x1A,
	23243 - 19968: jis0208<<14 | 0x34<<7 | 0x1D,
	23244 - 19968: jis0208<<14 | 0x16<<7 | 0x58,
	23247 - 19968: jis0212<<14 | 0x19<<7 | 0x03,
	23248 - 19968: jis0208<<14 | 0x34<<7 | 0x2B,
	23254 - 19968: jis0208<<14 | 0x34<<7 | 0x24,
	23255 - 19968: jis0208<<14 | 0x34<<7 | 0x21,
	23258 - 19968: jis0212<<14 | 0x19<<7 | 0x04,
	23260 - 19968: jis0212<<14 | 0x19<<7 | 0x05,
	23264 - 19968: jis0212<<14 | 0x19<<7 | 0x06,
	23265 - 19968: jis0208<<14 | 0x22<<7 | 0x43,
	23267 - 19968: jis0208<<14 | 0x34<<7 | 0x20,
	23269 - 19968: jis0212<<14 | 0x19<<7 | 0x07,
	23270 - 19968: jis0208<<14 | 0x34<<7 | 0x22,
	23273 - 19968: jis0208<<14 | 0x34<<7 | 0x23,
	23274 - 19968: jis0212<<14 | 0x19<<7 | 0x08,
	23278 - 19968: jis0212<<14 | 0x19<<7 | 0x09,
	23285 - 19968: jis0212<<14 | 0x19<<7 | 0x0A,
	23286 - 19968: jis0212<<14 | 0x19<<7 | 0x0B,
	23290 - 19968: jis0208<<14 | 0x34<<7 | 0x25,
	23291 - 19968: jis0208<<14 | 0x34<<7 | 0x26,
	23293 - 19968: jis0212<<14 | 0x19<<7 | 0x0C,
	23296 - 19968: jis0212<<14 | 0x19<<7 | 0x0D,
	23297 - 19968: jis0212<<14 | 0x19<<7 | 0x0E,
	23304 - 19968: jis0212<<14 | 0x19<<7 | 0x0F,
	23305 - 19968: jis0208<<14 | 0x13<<7 | 0x51,
	23307 - 19968: jis0208<<14 | 0x34<<7 | 0x28,
	23308 - 19968: jis0208<<14 | 0x34<<7 | 0x27,
	23318 - 19968: jis0208<<14 | 0x34<<7 | 0x29,
	23319 - 19968: jis0212<<14 | 0x19<<7 | 0x10,
	23321 - 19968: jis0212<<14 | 0x19<<7 | 0x12,
	23323 - 19968: jis0212<<14 | 0x19<<7 | 0x13,
	23325 - 19968: jis0212<<14 | 0x19<<7 | 0x14,
	23329 - 19968: jis0212<<14 | 0x19<<7 | 0x15,
	23330 - 19968: jis0208<<14 | 0x1D<<7 | 0x4D,
	23333 - 19968: jis0212<<14 | 0x19<<7 | 0x16,
	23338 - 19968: jis0208<<14 | 0x34<<7 | 0x2C,
	23340 - 19968: jis0208<<14 | 0x23<<7 | 0x3B,
	23341 - 19968: jis0212<<14 | 0x19<<7 | 0x17,
	23344 - 19968: jis0208<<14 | 0x10<<7 | 0x24,
	23346 - 19968: jis0208<<14 | 0x34<<7 | 0x2A,
	23348 - 19968: jis0212<<14 | 0x19<<7 | 0x11,
	23350 - 19968: jis0208<<14 | 0x34<<7 | 0x2D,
	23352 - 19968: jis0212<<14 | 0x19<<7 | 0x18,
	23358 - 19968: jis0208<<14 | 0x34<<7 | 0x2E,
	23360 - 19968: jis0208<<14 | 0x34<<7 | 0x31,
	23361 - 19968: jis0212<<14 | 0x19<<7 | 0x19,
	23363 - 19968: jis0208<<14 | 0x34<<7 | 0x2F,
	23365 - 19968: jis0208<<14 | 0x34<<7 | 0x30,
	23371 - 19968: jis0212<<14 | 0x19<<7 | 0x1A,
	23372 - 19968: jis0212<<14 | 0x19<<7 | 0x1B,
	23376 - 19968: jis0208<<14 | 0x1A<<7 | 0x31,
	23377 - 19968: jis0208<<14 | 0x34<<7 | 0x32,
	23378 - 19968: jis0212<<14 | 0x19<<7 | 0x1C,
	23380 - 19968: jis0208<<14 | 0x18<<7 | 0x05,
	23381 - 19968: jis0208<<14 | 0x34<<7 | 0x33,
	23382 - 19968: jis0208<<14 | 0x58<<7 | 0x49,
	23383 - 19968: jis0208<<14 | 0x1A<<7 | 0x59,
	23384 - 19968: jis0208<<14 | 0x21<<7 | 0x17,
	23386 - 19968: jis0208<<14 | 0x34<<7 | 0x34,
	23387 - 19968: jis0208<<14 | 0x34<<7 | 0x35,
	23388 - 19968: jis0208<<14 | 0x1A<<7 | 0x39,
	23389 - 19968: jis0208<<14 | 0x18<<7 | 0x06,
	23390 - 19968: jis0212<<14 | 0x19<<7 | 0x1E,
	23391 - 19968: jis0208<<14 | 0x2B<<7 | 0x31,
	23395 - 19968: jis0208<<14 | 0x14<<7 | 0x07,
	23396 - 19968: jis0208<<14 | 0x17<<7 | 0x28,
	23397 - 19968: jis0208<<14 | 0x34<<7 | 0x36,
	23398 - 19968: jis0208<<14 | 0x12<<7 | 0x37,
	23400 - 19968: jis0212<<14 | 0x19<<7 | 0x1F,
	23401 - 19968: jis0208<<14 | 0x34<<7 | 0x37,
	23403 - 19968: jis0208<<14 | 0x21<<7 | 0x18,
	23406 - 19968: jis0212<<14 | 0x19<<7 | 0x20,
	23407 - 19968: jis0212<<14 | 0x19<<7 | 0x21,
	23408 - 19968: jis0208<<14 | 0x34<<7 | 0x38,
	23409 - 19968: jis0208<<14 | 0x35<<7 | 0x02,
	23411 - 19968: jis0208<<14 | 0x34<<7 | 0x39,
	23413 - 19968: jis0208<<14 | 0x34<<7 | 0x3A,
	23416 - 19968: jis0208<<14 | 0x34<<7 | 0x3B,
	23418 - 19968: jis0208<<14 | 0x34<<7 | 0x3D,
	23420 - 19968: jis0212<<14 | 0x19<<7 | 0x22,
	23421 - 19968: jis0212<<14 | 0x19<<7 | 0x23,
	23422 - 19968: jis0212<<14 | 0x19<<7 | 0x24,
	23423 - 19968: jis0212<<14 | 0x19<<7 | 0x25,
	23424 - 19968: jis0208<<14 | 0x34<<7 | 0x3E,
	23425 - 19968: jis0212<<14 | 0x19<<7 | 0x26,
	23427 - 19968: jis0208<<14 | 0x34<<7 | 0x3F,
	23428 - 19968: jis0212<<14 | 0x19<<7 | 0x27,
	23429 - 19968: jis0208<<14 | 0x21<<7 | 0x4F,
	23430 - 19968: jis0212<<14 | 0x19<<7 | 0x28,
	23431 - 19968: jis0208<<14 | 0x10<<7 | 0x06,
	23432 - 19968: jis0208<<14 | 0x1B<<7 | 0x48,
	23433 - 19968: jis0208<<14 | 0x0F<<7 | 0x21,
	23434 - 19968: jis0212<<14 | 0x19<<7 | 0x29,
	23435 - 19968: jis0208<<14 | 0x20<<7 | 0x36,
	23436 - 19968: jis0208<<14 | 0x13<<7 | 0x0F,
	23437 - 19968: jis0208<<14 | 0x1B<<7 | 0x14,
	23438 - 19968: jis0212<<14 | 0x19<<7 | 0x2A,
	23439 - 19968: jis0208<<14 | 0x18<<7 | 0x07,
	23440 - 19968: jis0212<<14 | 0x19<<7 | 0x2B,
	23441 - 19968: jis0212<<14 | 0x19<<7 | 0x2C,
	23443 - 19968: jis0212<<14 | 0x19<<7 | 0x2D,
	23444 - 19968: jis0212<<14 | 0x19<<7 | 0x2E,
	23445 - 19968: jis0208<<14 | 0x24<<7 | 0x45,
	23446 - 19968: jis0212<<14 | 0x19<<7 | 0x2F,
	23447 - 19968: jis0208<<14 | 0x1C<<7 | 0x00,
	23448 - 19968: jis0208<<14 | 0x13<<7 | 0x10,
	23449 - 19968: jis0208<<14 | 0x22<<7 | 0x47,
	23450 - 19968: jis0208<<14 | 0x23<<7 | 0x49,
	23451 - 19968: jis0208<<14 | 0x0F<<7 | 0x17,
	23452 - 19968: jis0208<<14 | 0x14<<7 | 0x18,
	23453 - 19968: jis0208<<14 | 0x29<<7 | 0x54,
	23455 - 19968: jis0208<<14 | 0x1B<<7 | 0x21,
	23458 - 19968: jis0208<<14 | 0x14<<7 | 0x31,
	23459 - 19968: jis0208<<14 | 0x1F<<7 | 0x4A,
	23460 - 19968: jis0208<<14 | 0x1B<<7 | 0x1B,
	23461 - 19968: jis0208<<14 | 0x2C<<7 | 0x07,
	23462 - 19968: jis0208<<14 | 0x34<<7 | 0x40,
	23464 - 19968: jis0212<<14 | 0x19<<7 | 0x30,
	23465 - 19968: jis0212<<14 | 0x19<<7 | 0x31,
	23468 - 19968: jis0212<<14 | 0x19<<7 | 0x32,
	23469 - 19968: jis0212<<14 | 0x19<<7 | 0x33,
	23470 - 19968: jis0208<<14 | 0x14<<7 | 0x3B,
	23471 - 19968: jis0212<<14 | 0x19<<7 | 0x34,
	23472 - 19968: jis0208<<14 | 0x19<<7 | 0x2A,
	23473 - 19968: jis0212<<14 | 0x19<<7 | 0x35,
	23474 - 19968: jis0212<<14 | 0x19<<7 | 0x36,
	23475 - 19968: jis0208<<14 | 0x12<<7 | 0x11,
	23476 - 19968: jis0208<<14 | 0x10<<7 | 0x42,
	23477 - 19968: jis0208<<14 | 0x1D<<7 | 0x0B,
	23478 - 19968: jis0208<<14 | 0x11<<7 | 0x27,
	23479 - 19968: jis0212<<14 | 0x19<<7 | 0x37,
	23480 - 19968: jis0208<<14 | 0x34<<7 | 0x41,
	23481 - 19968: jis0208<<14 | 0x2C<<7 | 0x25,
	23482 - 19968: jis0212<<14 | 0x19<<7 | 0x38,
	23484 - 19968: jis0212<<14 | 0x19<<7 | 0x39,
	23487 - 19968: jis0208<<14 | 0x1C<<7 | 0x28,
	23488 - 19968: jis0208<<14 | 0x58<<7 | 0x4A,
	23489 - 19968: jis0212<<14 | 0x19<<7 | 0x3B,
	23490 - 19968: jis0208<<14 | 0x1B<<7 | 0x43,
	23491 - 19968: jis0208<<14 | 0x34<<7 | 0x42,
	23492 - 19968: jis0208<<14 | 0x13<<7 | 0x52,
	23493 - 19968: jis0208<<14 | 0x25<<7 | 0x31,
	23494 - 19968: jis0208<<14 | 0x2B<<7 | 0x08,
	23495 - 19968: jis0208<<14 | 0x34<<7 | 0x43,
	23497 - 19968: jis0208<<14 | 0x34<<7 | 0x44,
	23500 - 19968: jis0208<<14 | 0x28<<7 | 0x38,
	23501 - 19968: jis0212<<14 | 0x19<<7 | 0x3C,
	23503 - 19968: jis0212<<14 | 0x19<<7 | 0x3D,
	23504 - 19968: jis0208<<14 | 0x34<<7 | 0x46,
	23506 - 19968: jis0208<<14 | 0x13<<7 | 0x07,
	23507 - 19968: jis0208<<14 | 0x15<<7 | 0x56,
	23508 - 19968: jis0208<<14 | 0x34<<7 | 0x45,
	23510 - 19968: jis0212<<14 | 0x19<<7 | 0x3E,
	23511 - 19968: jis0212<<14 | 0x19<<7 | 0x3F,
	23512 - 19968: jis0208<<14 | 0x58<<7 | 0x4C,
	23513 - 19968: jis0212<<14 | 0x19<<7 | 0x41,
	23514 - 19968: jis0212<<14 | 0x19<<7 | 0x42,
	23515 - 19968: jis0208<<14 | 0x13<<7 | 0x11,
	23517 - 19968: jis0208<<14 | 0x1E<<7 | 0x11,
	23518 - 19968: jis0208<<14 | 0x34<<7 | 0x4A,
	23519 - 19968: jis0208<<14 | 0x1A<<7 | 0x00,
	23520 - 19968: jis0212<<14 | 0x19<<7 | 0x43,
	23521 - 19968: jis0208<<14 | 0x11<<7 | 0x28,
	23522 - 19968: jis0208<<14 | 0x34<<7 | 0x49,
	23524 - 19968: jis0208<<14 | 0x34<<7 | 0x47,
	23525 - 19968: jis0208<<14 | 0x34<<7 | 0x4B,
	23526 - 19968: jis0208<<14 | 0x34<<7 | 0x48,
	23527 - 19968: jis0208<<14 | 0x26<<7 | 0x0A,
	23528 - 19968: jis0208<<14 | 0x3B<<7 | 0x2C,
	23529 - 19968: jis0208<<14 | 0x1E<<7 | 0x12,
	23531 - 19968: jis0208<<14 | 0x34<<7 | 0x4C,
	23532 - 19968: jis0208<<14 | 0x58<<7 | 0x4D,
	23534 - 19968: jis0208<<14 | 0x2D<<7 | 0x1F,
	23535 - 19968: jis0212<<14 | 0x19<<7 | 0x44,
	23536 - 19968: jis0208<<14 | 0x34<<7 | 0x4D,
	23537 - 19968: jis0212<<14 | 0x19<<7 | 0x45,
	23539 - 19968: jis0208<<14 | 0x34<<7 | 0x4F,
	23540 - 19968: jis0212<<14 | 0x19<<7 | 0x46,
	23541 - 19968: jis0208<<14 | 0x22<<7 | 0x5D,
	23542 - 19968: jis0208<<14 | 0x34<<7 | 0x4E,
	23544 - 19968: jis0208<<14 | 0x1F<<7 | 0x02,
	23546 - 19968: jis0208<<14 | 0x1A<<7 | 0x5A,
	23549 - 19968: jis0212<<14 | 0x19<<7 | 0x47,
	23550 - 19968: jis0208<<14 | 0x21<<7 | 0x2F,
	23551 - 19968: jis0208<<14 | 0x1B<<7 | 0x56,
	23553 - 19968: jis0208<<14 | 0x28<<7 | 0x54,
	23554 - 19968: jis0208<<14 | 0x1F<<7 | 0x4B,
	23556 - 19968: jis0208<<14 | 0x1B<<7 | 0x2C,
	23557 - 19968: jis0208<<14 | 0x34<<7 | 0x50,
	23558 - 19968: jis0208<<14 | 0x1D<<7 | 0x0C,
	23559 - 19968: jis0208<<14 | 0x34<<7 | 0x51,
	23560 - 19968: jis0208<<14 | 0x34<<7 | 0x52,
	23561 - 19968: jis0208<<14 | 0x0F<<7 | 0x32,
	23562 - 19968: jis0208<<14 | 0x21<<7 | 0x19,
	23563 - 19968: jis0208<<14 | 0x1E<<7 | 0x31,
	23564 - 19968: jis0212<<14 | 0x19<<7 | 0x48,
	23565 - 19968: jis0208<<14 | 0x34<<7 | 0x53,
	23566 - 19968: jis0208<<14 | 0x25<<7 | 0x12,
	23567 - 19968: jis0208<<14 | 0x1D<<7 | 0x0D,
	23569 - 19968: jis0208<<14 | 0x1D<<7 | 0x0E,
	23571 - 19968: jis0208<<14 | 0x34<<7 | 0x54,
	23574 - 19968: jis0208<<14 | 0x1F<<7 | 0x4C,
	23575 - 19968: jis0212<<14 | 0x19<<7 | 0x49,
	23578 - 19968: jis0208<<14 | 0x1D<<7 | 0x0F,
	23582 - 19968: jis0208<<14 | 0x58<<7 | 0x4E,
	23583 - 19968: jis0212<<14 | 0x19<<7 | 0x4B,
	23584 - 19968: jis0208<<14 | 0x34<<7 | 0x55,
	23586 - 19968: jis0208<<14 | 0x34<<7 | 0x56,
	23587 - 19968: jis0212<<14 | 0x19<<7 | 0x4C,
	23588 - 19968: jis0208<<14 | 0x2B<<7 | 0x3F,
	23590 - 19968: jis0212<<14 | 0x19<<7 | 0x4D,
	23592 - 19968: jis0208<<14 | 0x34<<7 | 0x57,
	23593 - 19968: jis0212<<14 | 0x19<<7 | 0x4E,
	23595 - 19968: jis0212<<14 | 0x19<<7 | 0x4F,
	23596 - 19968: jis0212<<14 | 0x19<<7 | 0x50,
	23597 - 19968: jis0208<<14 | 0x15<<7 | 0x25,
	23598 - 19968: jis0212<<14 | 0x19<<7 | 0x51,
	23600 - 19968: jis0212<<14 | 0x19<<7 | 0x52,
	23601 - 19968: jis0208<<14 | 0x1C<<7 | 0x01,
	23602 - 19968: jis0212<<14 | 0x19<<7 | 0x53,
	23605 - 19968: jis0212<<14 | 0x19<<7 | 0x54,
	23606 - 19968: jis0212<<14 | 0x19<<7 | 0x55,
	23608 - 19968: jis0208<<14 | 0x34<<7 | 0x58,
	23609 - 19968: jis0208<<14 | 0x34<<7 | 0x59,
	23610 - 19968: jis0208<<14 | 0x1B<<7 | 0x3B,
	23611 - 19968: jis0208<<14 | 0x1E<<7 | 0x0B,
	23612 - 19968: jis0208<<14 | 0x25<<7 | 0x53,
	23613 - 19968: jis0208<<14 | 0x1E<<7 | 0x33,
	23614 - 19968: jis0208<<14 | 0x27<<7 | 0x57,
	23615 - 19968: jis0208<<14 | 0x26<<7 | 0x01,
	23616 - 19968: jis0208<<14 | 0x15<<7 | 0x28,
	23617 - 19968: jis0208<<14 | 0x34<<7 | 0x5A,
	23621 - 19968: jis0208<<14 | 0x14<<7 | 0x4E,
	23622 - 19968: jis0208<<14 | 0x34<<7 | 0x5B,
	23624 - 19968: jis0208<<14 | 0x15<<7 | 0x5D,
	23626 - 19968: jis0208<<14 | 0x25<<7 | 0x2E,
	23627 - 19968: jis0208<<14 | 0x11<<7 | 0x0F,
	23629 - 19968: jis0208<<14 | 0x1A<<7 | 0x32,
	23630 - 19968: jis0208<<14 | 0x34<<7 | 0x5C,
	23631 - 19968: jis0208<<14 | 0x35<<7 | 0x01,
	23632 - 19968: jis0208<<14 | 0x35<<7 | 0x00,
	23633 - 19968: jis0208<<14 | 0x15<<7 | 0x5C,
	23635 - 19968: jis0208<<14 | 0x34<<7 | 0x5D,
	23637 - 19968: jis0208<<14 | 0x24<<7 | 0x17,
	23641 - 19968: jis0212<<14 | 0x19<<7 | 0x56,
	23642 - 19968: jis0212<<14 | 0x19<<7 | 0x57,
	23644 - 19968: jis0212<<14 | 0x19<<7 | 0x58,
	23646 - 19968: jis0208<<14 | 0x21<<7 | 0x0F,
	23648 - 19968: jis0208<<14 | 0x24<<7 | 0x2A,
	23649 - 19968: jis0208<<14 | 0x1B<<7 | 0x27,
	23650 - 19968: jis0212<<14 | 0x19<<7 | 0x59,
	23651 - 19968: jis0212<<14 | 0x19<<7 | 0x5A,
	23652 - 19968: jis0208<<14 | 0x20<<7 | 0x37,
	23653 - 19968: jis0208<<14 | 0x2C<<7 | 0x59,
	23655 - 19968: jis0212<<14 | 0x19<<7 | 0x5B,
	23656 - 19968: jis0212<<14 | 0x19<<7 | 0x5C,
	23657 - 19968: jis0212<<14 | 0x19<<7 | 0x5D,
	23660 - 19968: jis0208<<14 | 0x35<<7 | 0x03,
	23661 - 19968: jis0212<<14 | 0x1A<<7 | 0x00,
	23662 - 19968: jis0208<<14 | 0x35<<7 | 0x04,
	23663 - 19968: jis0208<<14 | 0x25<<7 | 0x35,
	23664 - 19968: jis0212<<14 | 0x1A<<7 | 0x01,
	23665 - 19968: jis0208<<14 | 0x1A<<7 | 0x12,
	23668 - 19968: jis0212<<14 | 0x1A<<7 | 0x02,
	23669 - 19968: jis0212<<14 | 0x1A<<7 | 0x03,
	23670 - 19968: jis0208<<14 | 0x35<<7 | 0x06,
	23673 - 19968: jis0208<<14 | 0x35<<7 | 0x07,
	23674 - 19968: jis0212<<14 | 0x1A<<7 | 0x04,
	23675 - 19968: jis0212<<14 | 0x1A<<7 | 0x05,
	23676 - 19968: jis0212<<14 | 0x1A<<7 | 0x06,
	23677 - 19968: jis0212<<14 | 0x1A<<7 | 0x07,
	23687 - 19968: jis0212<<14 | 0x1A<<7 | 0x08,
	23688 - 19968: jis0212<<14 | 0x1A<<7 | 0x09,
	23690 - 19968: jis0212<<14 | 0x1A<<7 | 0x0A,
	23692 - 19968: jis0208<<14 | 0x35<<7 | 0x08,
	23695 - 19968: jis0212<<14 | 0x1A<<7 | 0x0B,
	23696 - 19968: jis0208<<14 | 0x13<<7 | 0x53,
	23697 - 19968: jis0208<<14 | 0x35<<7 | 0x09,
	23698 - 19968: jis0212<<14 | 0x1A<<7 | 0x0C,
	23700 - 19968: jis0208<<14 | 0x35<<7 | 0x0A,
	23709 - 19968: jis0212<<14 | 0x1A<<7 | 0x0D,
	23711 - 19968: jis0212<<14 | 0x1A<<7 | 0x0E,
	23712 - 19968: jis0212<<14 | 0x1A<<7 | 0x0F,
	23713 - 19968: jis0208<<14 | 0x11<<7 | 0x0B,
	23714 - 19968: jis0212<<14 | 0x1A<<7 | 0x10,
	23715 - 19968: jis0212<<14 | 0x1A<<7 | 0x11,
	23718 - 19968: jis0208<<14 | 0x58<<7 | 0x4F,
	23720 - 19968: jis0208<<14 | 0x20<<7 | 0x1A,
	23721 - 19968: jis0208<<14 | 0x13<<7 | 0x43,
	23722 - 19968: jis0212<<14 | 0x1A<<7 | 0x13,
	23723 - 19968: jis0208<<14 | 0x35<<7 | 0x0C,
	23724 - 19968: jis0208<<14 | 0x2B<<7 | 0x07,
	23729 - 19968: jis0208<<14 | 0x21<<7 | 0x31,
	23730 - 19968: jis0212<<14 | 0x1A<<7 | 0x14,
	23731 - 19968: jis0208<<14 | 0x12<<7 | 0x38,
	23732 - 19968: jis0212<<14 | 0x1A<<7 | 0x15,
	23733 - 19968: jis0212<<14 | 0x1A<<7 | 0x16,
	23734 - 19968: jis0208<<14 | 0x35<<7 | 0x0E,
	23735 - 19968: jis0208<<14 | 0x35<<7 | 0x10,
	23736 - 19968: jis0208<<14 | 0x13<<7 | 0x3E,
	23738 - 19968: jis0208<<14 | 0x58<<7 | 0x50,
	23739 - 19968: jis0208<<14 | 0x35<<7 | 0x0D,
	23740 - 19968: jis0208<<14 | 0x35<<7 | 0x0F,
	23742 - 19968: jis0208<<14 | 0x35<<7 | 0x12,
	23749 - 19968: jis0208<<14 | 0x35<<7 | 0x11,
	23751 - 19968: jis0208<<14 | 0x35<<7 | 0x13,
	23753 - 19968: jis0212<<14 | 0x1A<<7 | 0x18,
	23755 - 19968: jis0212<<14 | 0x1A<<7 | 0x19,
	23762 - 19968: jis0212<<14 | 0x1A<<7 | 0x1A,
	23767 - 19968: jis0212<<14 | 0x1A<<7 | 0x1C,
	23769 - 19968: jis0208<<14 | 0x35<<7 | 0x14,
	23773 - 19968: jis0212<<14 | 0x1A<<7 | 0x1B,
	23776 - 19968: jis0208<<14 | 0x25<<7 | 0x1C,
	23777 - 19968: jis0208<<14 | 0x15<<7 | 0x0D,
	23784 - 19968: jis0208<<14 | 0x11<<7 | 0x44,
	23785 - 19968: jis0208<<14 | 0x35<<7 | 0x15,
	23786 - 19968: jis0208<<14 | 0x35<<7 | 0x1A,
	23789 - 19968: jis0208<<14 | 0x35<<7 | 0x18,
	23790 - 19968: jis0212<<14 | 0x1A<<7 | 0x1D,
	23791 - 19968: jis0208<<14 | 0x29<<7 | 0x56,
	23792 - 19968: jis0208<<14 | 0x29<<7 | 0x55,
	23793 - 19968: jis0212<<14 | 0x1A<<7 | 0x1E,
	23794 - 19968: jis0212<<14 | 0x1A<<7 | 0x1F,
	23796 - 19968: jis0212<<14 | 0x1A<<7 | 0x20,
	23797 - 19968: jis0208<<14 | 0x58<<7 | 0x51,
	23798 - 19968: jis0208<<14 | 0x24<<7 | 0x46,
	23802 - 19968: jis0208<<14 | 0x35<<7 | 0x17,
	23803 - 19968: jis0208<<14 | 0x1C<<7 | 0x33,
	23805 - 19968: jis0208<<14 | 0x35<<7 | 0x16,
	23809 - 19968: jis0212<<14 | 0x1A<<7 | 0x21,
	23814 - 19968: jis0212<<14 | 0x1A<<7 | 0x22,
	23815 - 19968: jis0208<<14 | 0x1E<<7 | 0x51,
	23819 - 19968: jis0208<<14 | 0x35<<7 | 0x1B,
	23821 - 19968: jis0212<<14 | 0x1A<<7 | 0x23,
	23822 - 19968: jis0208<<14 | 0x19<<7 | 0x49,
	23825 - 19968: jis0208<<14 | 0x35<<7 | 0x21,
	23826 - 19968: jis0212<<14 | 0x1A<<7 | 0x24,
	23828 - 19968: jis0208<<14 | 0x35<<7 | 0x22,
	23829 - 19968: jis0208<<14 | 0x35<<7 | 0x1C,
	23830 - 19968: jis0208<<14 | 0x12<<7 | 0x12,
	23831 - 19968: jis0208<<14 | 0x35<<7 | 0x1D,
	23832 - 19968: jis0208<<14 | 0x35<<7 | 0x26,
	23833 - 19968: jis0208<<14 | 0x35<<7 | 0x25,
	23834 - 19968: jis0208<<14 | 0x35<<7 | 0x24,
	23835 - 19968: jis0208<<14 | 0x35<<7 | 0x20,
	23839 - 19968: jis0208<<14 | 0x35<<7 | 0x1F,
	23842 - 19968: jis0208<<14 | 0x35<<7 | 0x23,
	23843 - 19968: jis0212<<14 | 0x1A<<7 | 0x26,
	23844 - 19968: jis0212<<14 | 0x1A<<7 | 0x27,
	23846 - 19968: jis0212<<14 | 0x1A<<7 | 0x28,
	23847 - 19968: jis0208<<14 | 0x58<<7 | 0x52,
	23849 - 19968: jis0208<<14 | 0x29<<7 | 0x57,
	23851 - 19968: jis0212<<14 | 0x1A<<7 | 0x25,
	23857 - 19968: jis0212<<14 | 0x1A<<7 | 0x2A,
	23860 - 19968: jis0212<<14 | 0x1A<<7 | 0x2B,
	23865 - 19968: jis0212<<14 | 0x1A<<7 | 0x2C,
	23869 - 19968: jis0212<<14 | 0x1A<<7 | 0x2D,
	23871 - 19968: jis0212<<14 | 0x1A<<7 | 0x2E,
	23874 - 19968: jis0208<<14 | 0x58<<7 | 0x55,
	23875 - 19968: jis0212<<14 | 0x1A<<7 | 0x30,
	23878 - 19968: jis0212<<14 | 0x1A<<7 | 0x31,
	23880 - 19968: jis0212<<14 | 0x1A<<7 | 0x32,
	23882 - 19968: jis0212<<14 | 0x1A<<7 | 0x36,
	23883 - 19968: jis0208<<14 | 0x35<<7 | 0x2A,
	23884 - 19968: jis0208<<14 | 0x35<<7 | 0x27,
	23886 - 19968: jis0208<<14 | 0x35<<7 | 0x29,
	23888 - 19968: jis0208<<14 | 0x2C<<7 | 0x51,
	23889 - 19968: jis0212<<14 | 0x1A<<7 | 0x34,
	23890 - 19968: jis0208<<14 | 0x35<<7 | 0x28,
	23891 - 19968: jis0208<<14 | 0x58<<7 | 0x53,
	23893 - 19968: jis0212<<14 | 0x1A<<7 | 0x33,
	23897 - 19968: jis0212<<14 | 0x1A<<7 | 0x35,
	23900 - 19968: jis0208<<14 | 0x35<<7 | 0x1E,
	23903 - 19968: jis0212<<14 | 0x1A<<7 | 0x37,
	23904 - 19968: jis0212<<14 | 0x1A<<7 | 0x38,
	23905 - 19968: jis0212<<14 | 0x1A<<7 | 0x39,
	23906 - 19968: jis0212<<14 | 0x1A<<7 | 0x3A,
	23908 - 19968: jis0212<<14 | 0x1A<<7 | 0x3B,
	23913 - 19968: jis0208<<14 | 0x1E<<7 | 0x52,
	23914 - 19968: jis0212<<14 | 0x1A<<7 | 0x3C,
	23916 - 19968: jis0208<<14 | 0x35<<7 | 0x2B,
	23917 - 19968: jis0208<<14 | 0x58<<7 | 0x56,
	23919 - 19968: jis0208<<14 | 0x19<<7 | 0x16,
	23920 - 19968: jis0212<<14 | 0x1A<<7 | 0x3E,
	23923 - 19968: jis0208<<14 | 0x35<<7 | 0x2C,
	23926 - 19968: jis0208<<14 | 0x35<<7 | 0x2D,
	23929 - 19968: jis0212<<14 | 0x1A<<7 | 0x3F,
	23930 - 19968: jis0212<<14 | 0x1A<<7 | 0x40,
	23934 - 19968: jis0212<<14 | 0x1A<<7 | 0x41,
	23935 - 19968: jis0212<<14 | 0x1A<<7 | 0x42,
	23937 - 19968: jis0212<<14 | 0x1A<<7 | 0x43,
	23938 - 19968: jis0208<<14 | 0x35<<7 | 0x30,
	23939 - 19968: jis0212<<14 | 0x1A<<7 | 0x44,
	23940 - 19968: jis0208<<14 | 0x35<<7 | 0x2F,
	23943 - 19968: jis0208<<14 | 0x35<<7 | 0x2E,
	23944 - 19968: jis0212<<14 | 0x1A<<7 | 0x45,
	23946 - 19968: jis0212<<14 | 0x1A<<7 | 0x46,
	23947 - 19968: jis0208<<14 | 0x24<<7 | 0x47,
	23948 - 19968: jis0208<<14 | 0x35<<7 | 0x19,
	23952 - 19968: jis0208<<14 | 0x35<<7 | 0x36,
	23954 - 19968: jis0212<<14 | 0x1A<<7 | 0x47,
	23955 - 19968: jis0212<<14 | 0x1A<<7 | 0x48,
	23956 - 19968: jis0212<<14 | 0x1A<<7 | 0x49,
	23957 - 19968: jis0212<<14 | 0x1A<<7 | 0x4A,
	23961 - 19968: jis0212<<14 | 0x1A<<7 | 0x4B,
	23963 - 19968: jis0212<<14 | 0x1A<<7 | 0x4C,
	23965 - 19968: jis0208<<14 | 0x35<<7 | 0x32,
	23967 - 19968: jis0212<<14 | 0x1A<<7 | 0x4D,
	23968 - 19968: jis0212<<14 | 0x1A<<7 | 0x4E,
	23970 - 19968: jis0208<<14 | 0x35<<7 | 0x31,
	23975 - 19968: jis0212<<14 | 0x1A<<7 | 0x4F,
	23979 - 19968: jis0212<<14 | 0x1A<<7 | 0x50,
	23980 - 19968: jis0208<<14 | 0x35<<7 | 0x33,
	23982 - 19968: jis0208<<14 | 0x35<<7 | 0x34,
	23984 - 19968: jis0212<<14 | 0x1A<<7 | 0x51,
	23986 - 19968: jis0212<<14 | 0x45<<7 | 0x53,
	23988 - 19968: jis0212<<14 | 0x1A<<7 | 0x52,
	23991 - 19968: jis0208<<14 | 0x35<<7 | 0x37,
	23992 - 19968: jis0208<<14 | 0x58<<7 | 0x57,
	23993 - 19968: jis0208<<14 | 0x58<<7 | 0x58,
	23994 - 19968: jis0208<<14 | 0x2D<<7 | 0x45,
	23996 - 19968: jis0208<<14 | 0x35<<7 | 0x38,
	23997 - 19968: jis0208<<14 | 0x35<<7 | 0x35,
	24003 - 19968: jis0212<<14 | 0x1A<<7 | 0x55,
	24007 - 19968: jis0212<<14 | 0x1A<<7 | 0x56,
	24009 - 19968: jis0208<<14 | 0x35<<7 | 0x39,
	24011 - 19968: jis0212<<14 | 0x1A<<7 | 0x57,
	24012 - 19968: jis0208<<14 | 0x13<<7 | 0x3F,
	24013 - 19968: jis0208<<14 | 0x35<<7 | 0x3A,
	24014 - 19968: jis0212<<14 | 0x1A<<7 | 0x59,
	24016 - 19968: jis0208<<14 | 0x58<<7 | 0x59,
	24018 - 19968: jis0208<<14 | 0x35<<7 | 0x3C,
	24019 - 19968: jis0208<<14 | 0x35<<7 | 0x3B,
	24022 - 19968: jis0208<<14 | 0x35<<7 | 0x3D,
	24024 - 19968: jis0212<<14 | 0x1A<<7 | 0x5A,
	24025 - 19968: jis0212<<14 | 0x1A<<7 | 0x5B,
	24027 - 19968: jis0208<<14 | 0x35<<7 | 0x3E,
	24029 - 19968: jis0208<<14 | 0x1F<<7 | 0x4D,
	24030 - 19968: jis0208<<14 | 0x1C<<7 | 0x02,
	24032 - 19968: jis0212<<14 | 0x1A<<7 | 0x5C,
	24033 - 19968: jis0208<<14 | 0x1C<<7 | 0x43,
	24035 - 19968: jis0208<<14 | 0x20<<7 | 0x42,
	24036 - 19968: jis0212<<14 | 0x1A<<7 | 0x5D,
	24037 - 19968: jis0208<<14 | 0x18<<7 | 0x08,
	24038 - 19968: jis0208<<14 | 0x19<<7 | 0x17,
	24039 - 19968: jis0208<<14 | 0x18<<7 | 0x09,
	24040 - 19968: jis0208<<14 | 0x14<<7 | 0x4F,
	24041 - 19968: jis0212<<14 | 0x1B<<7 | 0x00,
	24043 - 19968: jis0208<<14 | 0x35<<7 | 0x3F,
	24046 - 19968: jis0208<<14 | 0x19<<7 | 0x18,
	24049 - 19968: jis0208<<14 | 0x17<<7 | 0x29,
	24050 - 19968: jis0208<<14 | 0x35<<7 | 0x40,
	24051 - 19968: jis0208<<14 | 0x2B<<7 | 0x05,
	24052 - 19968: jis0208<<14 | 0x26<<7 | 0x22,
	24053 - 19968: jis0208<<14 | 0x35<<7 | 0x41,
	24055 - 19968: jis0208<<14 | 0x18<<7 | 0x0A,
	24056 - 19968: jis0212<<14 | 0x1B<<7 | 0x01,
	24057 - 19968: jis0212<<14 | 0x1B<<7 | 0x02,
	24059 - 19968: jis0208<<14 | 0x13<<7 | 0x0B,
	24061 - 19968: jis0208<<14 | 0x22<<7 | 0x06,
	24062 - 19968: jis0208<<14 | 0x15<<7 | 0x31,
	24064 - 19968: jis0212<<14 | 0x1B<<7 | 0x03,
	24066 - 19968: jis0208<<14 | 0x1A<<7 | 0x33,
	24067 - 19968: jis0208<<14 | 0x28<<7 | 0x3A,
	24070 - 19968: jis0208<<14 | 0x27<<7 | 0x20,
	24071 - 19968: jis0212<<14 | 0x1B<<7 | 0x04,
	24075 - 19968: jis0208<<14 | 0x35<<7 | 0x42,
	24076 - 19968: jis0208<<14 | 0x13<<7 | 0x54,
	24077 - 19968: jis0212<<14 | 0x1B<<7 | 0x05,
	24081 - 19968: jis0208<<14 | 0x35<<7 | 0x45,
	24082 - 19968: jis0212<<14 | 0x1B<<7 | 0x06,
	24084 - 19968: jis0212<<14 | 0x1B<<7 | 0x07,
	24085 - 19968: jis0212<<14 | 0x1B<<7 | 0x08,
	24086 - 19968: jis0208<<14 | 0x23<<7 | 0x00,
	24088 - 19968: jis0212<<14 | 0x1B<<7 | 0x09,
	24089 - 19968: jis0208<<14 | 0x35<<7 | 0x44,
	24090 - 19968: jis0208<<14 | 0x35<<7 | 0x43,
	24091 - 19968: jis0208<<14 | 0x35<<7 | 0x46,
	24093 - 19968: jis0208<<14 | 0x23<<7 | 0x4A,
	24095 - 19968: jis0212<<14 | 0x1B<<7 | 0x0A,
	24096 - 19968: jis0212<<14 | 0x1B<<7 | 0x0B,
	24101 - 19968: jis0208<<14 | 0x1E<<7 | 0x42,
	24104 - 19968: jis0212<<14 | 0x1B<<7 | 0x0D,
	24107 - 19968: jis0208<<14 | 0x1A<<7 | 0x34,
	24109 - 19968: jis0208<<14 | 0x1F<<7 | 0x29,
	24110 - 19968: jis0212<<14 | 0x1B<<7 | 0x0C,
	24111 - 19968: jis0208<<14 | 0x21<<7 | 0x32,
	24112 - 19968: jis0208<<14 | 0x14<<7 | 0x01,
	24114 - 19968: jis0212<<14 | 0x1B<<7 | 0x0E,
	24115 - 19968: jis0208<<14 | 0x23<<7 | 0x01,
	24117 - 19968: jis0212<<14 | 0x1B<<7 | 0x0F,
	24118 - 19968: jis0208<<14 | 0x35<<7 | 0x47,
	24119 - 19968: jis0208<<14 | 0x35<<7 | 0x48,
	24120 - 19968: jis0208<<14 | 0x1D<<7 | 0x4E,
	24125 - 19968: jis0208<<14 | 0x2A<<7 | 0x18,
	24126 - 19968: jis0212<<14 | 0x1B<<7 | 0x10,
	24128 - 19968: jis0208<<14 | 0x35<<7 | 0x4B,
	24131 - 19968: jis0208<<14 | 0x35<<7 | 0x4A,
	24132 - 19968: jis0208<<14 | 0x35<<7 | 0x49,
	24133 - 19968: jis0208<<14 | 0x28<<7 | 0x5C,
	24135 - 19968: jis0208<<14 | 0x35<<7 | 0x52,
	24137 - 19968: jis0212<<14 | 0x1B<<7 | 0x13,
	24139 - 19968: jis0212<<14 | 0x1B<<7 | 0x11,
	24140 - 19968: jis0208<<14 | 0x2A<<7 | 0x39,
	24142 - 19968: jis0208<<14 | 0x35<<7 | 0x4C,
	24144 - 19968: jis0212<<14 | 0x1B<<7 | 0x12,
	24145 - 19968: jis0212<<14 | 0x1B<<7 | 0x14,
	24148 - 19968: jis0208<<14 | 0x35<<7 | 0x4E,
	24149 - 19968: jis0208<<14 | 0x2A<<7 | 0x4A,
	24150 - 19968: jis0212<<14 | 0x1B<<7 | 0x15,
	24151 - 19968: jis0208<<14 | 0x35<<7 | 0x4D,
	24152 - 19968: jis0212<<14 | 0x1B<<7 | 0x16,
	24155 - 19968: jis0212<<14 | 0x1B<<7 | 0x17,
	24156 - 19968: jis0212<<14 | 0x1B<<7 | 0x18,
	24158 - 19968: jis0212<<14 | 0x1B<<7 | 0x19,
	24159 - 19968: jis0208<<14 | 0x35<<7 | 0x4F,
	24161 - 19968: jis0208<<14 | 0x27<<7 | 0x07,
	24162 - 19968: jis0208<<14 | 0x35<<7 | 0x50,
	24163 - 19968: jis0208<<14 | 0x29<<7 | 0x1D,
	24164 - 19968: jis0208<<14 | 0x35<<7 | 0x51,
	24168 - 19968: jis0212<<14 | 0x1B<<7 | 0x1A,
	24170 - 19968: jis0212<<14 | 0x1B<<7 | 0x1B,
	24171 - 19968: jis0212<<14 | 0x1B<<7 | 0x1C,
	24172 - 19968: jis0212<<14 | 0x1B<<7 | 0x1D,
	24173 - 19968: jis0212<<14 | 0x1B<<7 | 0x1E,
	24174 - 19968: jis0212<<14 | 0x1B<<7 | 0x1F,
	24176 - 19968: jis0212<<14 | 0x1B<<7 | 0x20,
	24178 - 19968: jis0208<<14 | 0x13<<7 | 0x12,
	24179 - 19968: jis0208<<14 | 0x29<<7 | 0x1E,
	24180 - 19968: jis0208<<14 | 0x26<<7 | 0x0E,
	24181 - 19968: jis0208<<14 | 0x35<<7 | 0x53,
	24182 - 19968: jis0208<<14 | 0x35<<7 | 0x54,
	24184 - 19968: jis0208<<14 | 0x18<<7 | 0x0B,
	24185 - 19968: jis0208<<14 | 0x13<<7 | 0x13,
	24186 - 19968: jis0208<<14 | 0x35<<7 | 0x55,
	24187 - 19968: jis0208<<14 | 0x17<<7 | 0x17,
	24188 - 19968: jis0208<<14 | 0x2C<<7 | 0x23,
	24189 - 19968: jis0208<<14 | 0x2C<<7 | 0x08,
	24190 - 19968: jis0208<<14 | 0x13<<7 | 0x55,
	24191 - 19968: jis0208<<14 | 0x35<<7 | 0x57,
	24192 - 19968: jis0212<<14 | 0x1B<<7 | 0x21,
	24193 - 19968: jis0208<<14 | 0x23<<7 | 0x02,
	24195 - 19968: jis0208<<14 | 0x18<<7 | 0x0C,
	24196 - 19968: jis0208<<14 | 0x1D<<7 | 0x10,
	24199 - 19968: jis0208<<14 | 0x27<<7 | 0x3E,
	24202 - 19968: jis0208<<14 | 0x1D<<7 | 0x11,
	24203 - 19968: jis0212<<14 | 0x1B<<7 | 0x22,
	24206 - 19968: jis0212<<14 | 0x1B<<7 | 0x23,
	24207 - 19968: jis0208<<14 | 0x1C<<7 | 0x57,
	24213 - 19968: jis0208<<14 | 0x23<<7 | 0x4B,
	24214 - 19968: jis0208<<14 | 0x29<<7 | 0x58,
	24215 - 19968: jis0208<<14 | 0x24<<7 | 0x18,
	24218 - 19968: jis0208<<14 | 0x18<<7 | 0x0D,
	24220 - 19968: jis0208<<14 | 0x28<<7 | 0x3B,
	24224 - 19968: jis0208<<14 | 0x35<<7 | 0x58,
	24226 - 19968: jis0212<<14 | 0x1B<<7 | 0x24,
	24228 - 19968: jis0212<<14 | 0x1B<<7 | 0x25,
	24229 - 19968: jis0212<<14 | 0x1B<<7 | 0x26,
	24230 - 19968: jis0208<<14 | 0x24<<7 | 0x38,
	24231 - 19968: jis0208<<14 | 0x19<<7 | 0x21,
	24232 - 19968: jis0212<<14 | 0x1B<<7 | 0x27,
	24234 - 19968: jis0212<<14 | 0x1B<<7 | 0x28,
	24235 - 19968: jis0208<<14 | 0x17<<7 | 0x2A,
	24236 - 19968: jis0212<<14 | 0x1B<<7 | 0x29,
	24237 - 19968: jis0208<<14 | 0x23<<7 | 0x4C,
	24241 - 19968: jis0212<<14 | 0x1B<<7 | 0x2A,
	24243 - 19968: jis0212<<14 | 0x1B<<7 | 0x2B,
	24245 - 19968: jis0208<<14 | 0x0F<<7 | 0x22,
	24246 - 19968: jis0208<<14 | 0x1C<<7 | 0x4D,
	24247 - 19968: jis0208<<14 | 0x18<<7 | 0x0E,
	24248 - 19968: jis0208<<14 | 0x2C<<7 | 0x26,
	24253 - 19968: jis0212<<14 | 0x1B<<7 | 0x2C,
	24254 - 19968: jis0212<<14 | 0x1B<<7 | 0x2D,
	24255 - 19968: jis0212<<14 | 0x1B<<7 | 0x2E,
	24257 - 19968: jis0208<<14 | 0x35<<7 | 0x59,
	24258 - 19968: jis0208<<14 | 0x35<<7 | 0x5A,
	24259 - 19968: jis0208<<14 | 0x26<<7 | 0x30,
	24262 - 19968: jis0212<<14 | 0x1B<<7 | 0x2F,
	24264 - 19968: jis0208<<14 | 0x35<<7 | 0x5B,
	24265 - 19968: jis0208<<14 | 0x2D<<7 | 0x56,
	24266 - 19968: jis0208<<14 | 0x2E<<7 | 0x0C,
	24267 - 19968: jis0212<<14 | 0x1B<<7 | 0x31,
	24268 - 19968: jis0212<<14 | 0x1B<<7 | 0x30,
	24270 - 19968: jis0212<<14 | 0x1B<<7 | 0x32,
	24271 - 19968: jis0208<<14 | 0x35<<7 | 0x5D,
	24272 - 19968: jis0208<<14 | 0x35<<7 | 0x5C,
	24273 - 19968: jis0212<<14 | 0x1B<<7 | 0x33,
	24274 - 19968: jis0212<<14 | 0x1B<<7 | 0x34,
	24275 - 19968: jis0208<<14 | 0x12<<7 | 0x26,
	24276 - 19968: jis0212<<14 | 0x1B<<7 | 0x35,
	24277 - 19968: jis0212<<14 | 0x1B<<7 | 0x36,
	24278 - 19968: jis0208<<14 | 0x36<<7 | 0x00,
	24282 - 19968: jis0208<<14 | 0x36<<7 | 0x03,
	24283 - 19968: jis0208<<14 | 0x36<<7 | 0x04,
	24284 - 19968: jis0212<<14 | 0x1B<<7 | 0x37,
	24285 - 19968: jis0208<<14 | 0x36<<7 | 0x02,
	24286 - 19968: jis0212<<14 | 0x1B<<7 | 0x38,
	24287 - 19968: jis0208<<14 | 0x28<<7 | 0x1F,
	24288 - 19968: jis0208<<14 | 0x1D<<7 | 0x12,
	24289 - 19968: jis0208<<14 | 0x36<<7 | 0x06,
	24290 - 19968: jis0208<<14 | 0x36<<7 | 0x05,
	24291 - 19968: jis0208<<14 | 0x36<<7 | 0x01,
	24293 - 19968: jis0212<<14 | 0x1B<<7 | 0x39,
	24296 - 19968: jis0208<<14 | 0x36<<7 | 0x07,
	24297 - 19968: jis0208<<14 | 0x36<<7 | 0x08,
	24299 - 19968: jis0212<<14 | 0x1B<<7 | 0x3A,
	24300 - 19968: jis0208<<14 | 0x36<<7 | 0x09,
	24304 - 19968: jis0208<<14 | 0x36<<7 | 0x0C,
	24305 - 19968: jis0208<<14 | 0x36<<7 | 0x0A,
	24307 - 19968: jis0208<<14 | 0x36<<7 | 0x0B,
	24308 - 19968: jis0208<<14 | 0x36<<7 | 0x0D,
	24310 - 19968: jis0208<<14 | 0x10<<7 | 0x43,
	24311 - 19968: jis0208<<14 | 0x23<<7 | 0x4D,
	24312 - 19968: jis0208<<14 | 0x36<<7 | 0x0E,
	24314 - 19968: jis0208<<14 | 0x16<<7 | 0x59,
	24315 - 19968: jis0208<<14 | 0x11<<7 | 0x55,
	24316 - 19968: jis0208<<14 | 0x26<<7 | 0x15,
	24318 - 19968: jis0208<<14 | 0x36<<7 | 0x0F,
	24319 - 19968: jis0208<<14 | 0x25<<7 | 0x5A,
	24321 - 19968: jis0208<<14 | 0x29<<7 | 0x3A,
	24322 - 19968: jis0212<<14 | 0x1B<<7 | 0x3B,
	24323 - 19968: jis0208<<14 | 0x36<<7 | 0x10,
	24324 - 19968: jis0208<<14 | 0x2E<<7 | 0x0D,
	24326 - 19968: jis0212<<14 | 0x1B<<7 | 0x3C,
	24327 - 19968: jis0212<<14 | 0x1B<<7 | 0x3D,
	24328 - 19968: jis0212<<14 | 0x1B<<7 | 0x3E,
	24329 - 19968: jis0208<<14 | 0x36<<7 | 0x11,
	24330 - 19968: jis0208<<14 | 0x29<<7 | 0x1F,
	24331 - 19968: jis0208<<14 | 0x36<<7 | 0x14,
	24332 - 19968: jis0208<<14 | 0x2F<<7 | 0x00,
	24333 - 19968: jis0208<<14 | 0x2F<<7 | 0x10,
	24334 - 19968: jis0212<<14 | 0x1B<<7 | 0x3F,
	24335 - 19968: jis0208<<14 | 0x1B<<7 | 0x0F,
	24336 - 19968: jis0208<<14 | 0x25<<7 | 0x54,
	24337 - 19968: jis0208<<14 | 0x36<<7 | 0x15,
	24339 - 19968: jis0208<<14 | 0x14<<7 | 0x3C,
	24340 - 19968: jis0208<<14 | 0x23<<7 | 0x03,
	24341 - 19968: jis0208<<14 | 0x0F<<7 | 0x59,
	24342 - 19968: jis0208<<14 | 0x36<<7 | 0x16,
	24343 - 19968: jis0208<<14 | 0x29<<7 | 0x05,
	24344 - 19968: jis0208<<14 | 0x18<<7 | 0x0F,
	24345 - 19968: jis0212<<14 | 0x1B<<7 | 0x40,
	24347 - 19968: jis0208<<14 | 0x22<<7 | 0x2F,
	24348 - 19968: jis0212<<14 | 0x1B<<7 | 0x41,
	24349 - 19968: jis0212<<14 | 0x1B<<7 | 0x42,
	24351 - 19968: jis0208<<14 | 0x23<<7 | 0x4E,
	24353 - 19968: jis0208<<14 | 0x58<<7 | 0x5A,
	24354 - 19968: jis0212<<14 | 0x1B<<7 | 0x44,
	24355 - 19968: jis0212<<14 | 0x1B<<7 | 0x45,
	24356 - 19968: jis0212<<14 | 0x1B<<7 | 0x46,
	24357 - 19968: jis0208<<14 | 0x2B<<7 | 0x4E,
	24358 - 19968: jis0208<<14 | 0x17<<7 | 0x18,
	24359 - 19968: jis0208<<14 | 0x17<<7 | 0x2B,
	24360 - 19968: jis0212<<14 | 0x1B<<7 | 0x47,
	24361 - 19968: jis0208<<14 | 0x36<<7 | 0x17,
	24363 - 19968: jis0212<<14 | 0x1B<<7 | 0x48,
	24364 - 19968: jis0212<<14 | 0x1B<<7 | 0x49,
	24365 - 19968: jis0208<<14 | 0x36<<7 | 0x18,
	24366 - 19968: jis0212<<14 | 0x1B<<7 | 0x4A,
	24367 - 19968: jis0208<<14 | 0x36<<7 | 0x1E,
	24368 - 19968: jis0212<<14 | 0x1B<<7 | 0x4B,
	24369 - 19968: jis0208<<14 | 0x1B<<7 | 0x44,
	24372 - 19968: jis0208<<14 | 0x58<<7 | 0x5B,
	24373 - 19968: jis0208<<14 | 0x23<<7 | 0x04,
	24374 - 19968: jis0212<<14 | 0x1B<<7 | 0x4D,
	24375 - 19968: jis0208<<14 | 0x15<<7 | 0x0E,
	24376 - 19968: jis0208<<14 | 0x36<<7 | 0x19,
	24379 - 19968: jis0212<<14 | 0x1B<<7 | 0x4E,
	24380 - 19968: jis0208<<14 | 0x28<<7 | 0x0A,
	24381 - 19968: jis0212<<14 | 0x1B<<7 | 0x4F,
	24382 - 19968: jis0208<<14 | 0x22<<7 | 0x25,
	24383 - 19968: jis0212<<14 | 0x1B<<7 | 0x50,
	24384 - 19968: jis0212<<14 | 0x1B<<7 | 0x51,
	24385 - 19968: jis0208<<14 | 0x36<<7 | 0x1A,
	24388 - 19968: jis0212<<14 | 0x1B<<7 | 0x52,
	24389 - 19968: jis0208<<14 | 0x58<<7 | 0x0B,
	24391 - 19968: jis0212<<14 | 0x1B<<7 | 0x54,
	24392 - 19968: jis0208<<14 | 0x36<<7 | 0x1B,
	24394 - 19968: jis0208<<14 | 0x15<<7 | 0x0F,
	24396 - 19968: jis0208<<14 | 0x36<<7 | 0x1C,
	24397 - 19968: jis0212<<14 | 0x1B<<7 | 0x55,
	24398 - 19968: jis0208<<14 | 0x36<<7 | 0x1D,
	24400 - 19968: jis0212<<14 | 0x1B<<7 | 0x56,
	24401 - 19968: jis0208<<14 | 0x36<<7 | 0x1F,
	24403 - 19968: jis0208<<14 | 0x24<<7 | 0x55,
	24404 - 19968: jis0212<<14 | 0x1B<<7 | 0x57,
	24406 - 19968: jis0208<<14 | 0x36<<7 | 0x20,
	24407 - 19968: jis0208<<14 | 0x36<<7 | 0x21,
	24408 - 19968: jis0212<<14 | 0x1B<<7 | 0x58,
	24409 - 19968: jis0208<<14 | 0x36<<7 | 0x22,
	24411 - 19968: jis0212<<14 | 0x1B<<7 | 0x59,
	24412 - 19968: jis0208<<14 | 0x36<<7 | 0x13,
	24413 - 19968: jis0208<<14 | 0x36<<7 | 0x12,
	24416 - 19968: jis0212<<14 | 0x1B<<7 | 0x5A,
	24417 - 19968: jis0208<<14 | 0x36<<7 | 0x23,
	24418 - 19968: jis0208<<14 | 0x16<<7 | 0x20,
	24419 - 19968: jis0212<<14 | 0x1B<<7 | 0x5B,
	24420 - 19968: jis0212<<14 | 0x1B<<7 | 0x5C,
	24422 - 19968: jis0208<<14 | 0x28<<7 | 0x06,
	24423 - 19968: jis0208<<14 | 0x58<<7 | 0x5C,
	24425 - 19968: jis0208<<14 | 0x19<<7 | 0x2B,
	24426 - 19968: jis0208<<14 | 0x28<<7 | 0x16,
	24427 - 19968: jis0208<<14 | 0x23<<7 | 0x05,
	24428 - 19968: jis0208<<14 | 0x28<<7 | 0x2A,
	24429 - 19968: jis0208<<14 | 0x36<<7 | 0x24,
	24431 - 19968: jis0212<<14 | 0x1C<<7 | 0x00,
	24432 - 19968: jis0208<<14 | 0x1D<<7 | 0x13,
	24433 - 19968: jis0208<<14 | 0x10<<7 | 0x25,
	24434 - 19968: jis0212<<14 | 0x1C<<7 | 0x01,
	24435 - 19968: jis0208<<14 | 0x36<<7 | 0x25,
	24436 - 19968: jis0212<<14 | 0x1C<<7 | 0x02,
	24437 - 19968: jis0212<<14 | 0x1C<<7 | 0x03,
	24439 - 19968: jis0208<<14 | 0x36<<7 | 0x26,
	24440 - 19968: jis0212<<14 | 0x1C<<7 | 0x04,
	24441 - 19968: jis0208<<14 | 0x2B<<7 | 0x51,
	24442 - 19968: jis0212<<14 | 0x1C<<7 | 0x05,
	24444 - 19968: jis0208<<14 | 0x27<<7 | 0x3F,
	24445 - 19968: jis0212<<14 | 0x1C<<7 | 0x06,
	24446 - 19968: jis0212<<14 | 0x1C<<7 | 0x07,
	24447 - 19968: jis0208<<14 | 0x36<<7 | 0x29,
	24448 - 19968: jis0208<<14 | 0x10<<7 | 0x5C,
	24449 - 19968: jis0208<<14 | 0x1F<<7 | 0x0B,
	24450 - 19968: jis0208<<14 | 0x36<<7 | 0x28,
	24451 - 19968: jis0208<<14 | 0x36<<7 | 0x27,
	24452 - 19968: jis0208<<14 | 0x16<<7 | 0x21,
	24453 - 19968: jis0208<<14 | 0x21<<7 | 0x33,
	24455 - 19968: jis0208<<14 | 0x36<<7 | 0x2D,
	24456 - 19968: jis0208<<14 | 0x36<<7 | 0x2B,
	24457 - 19968: jis0212<<14 | 0x1C<<7 | 0x08,
	24458 - 19968: jis0208<<14 | 0x36<<7 | 0x2A,
	24459 - 19968: jis0208<<14 | 0x2D<<7 | 0x06,
	24460 - 19968: jis0208<<14 | 0x17<<7 | 0x44,
	24461 - 19968: jis0212<<14 | 0x1C<<7 | 0x09,
	24463 - 19968: jis0212<<14 | 0x1C<<7 | 0x0A,
	24464 - 19968: jis0208<<14 | 0x1C<<7 | 0x58,
	24465 - 19968: jis0208<<14 | 0x36<<7 | 0x2C,
	24466 - 19968: jis0208<<14 | 0x24<<7 | 0x2B,
	24467 - 19968: jis0208<<14 | 0x1C<<7 | 0x1D,
	24470 - 19968: jis0212<<14 | 0x1C<<7 | 0x0B,
	24471 - 19968: jis0208<<14 | 0x25<<7 | 0x1F,
	24472 - 19968: jis0208<<14 | 0x36<<7 | 0x30,
	24473 - 19968: jis0208<<14 | 0x36<<7 | 0x2F,
	24476 - 19968: jis0212<<14 | 0x1C<<7 | 0x0C,
	24477 - 19968: jis0212<<14 | 0x1C<<7 | 0x0D,
	24478 - 19968: jis0208<<14 | 0x36<<7 | 0x2E,
	24480 - 19968: jis0208<<14 | 0x36<<7 | 0x31,
	24481 - 19968: jis0208<<14 | 0x17<<7 | 0x45,
	24482 - 19968: jis0212<<14 | 0x1C<<7 | 0x0E,
	24484 - 19968: jis0212<<14 | 0x1C<<7 | 0x11,
	24487 - 19968: jis0212<<14 | 0x1C<<7 | 0x0F,
	24488 - 19968: jis0208<<14 | 0x36<<7 | 0x32,
	24489 - 19968: jis0208<<14 | 0x28<<7 | 0x5B,
	24490 - 19968: jis0208<<14 | 0x1C<<7 | 0x3A,
	24491 - 19968: jis0212<<14 | 0x1C<<7 | 0x10,
	24492 - 19968: jis0212<<14 | 0x1C<<7 | 0x12,
	24493 - 19968: jis0208<<14 | 0x36<<7 | 0x33,
	24494 - 19968: jis0208<<14 | 0x27<<7 | 0x58,
	24495 - 19968: jis0212<<14 | 0x1C<<7 | 0x13,
	24496 - 19968: jis0212<<14 | 0x1C<<7 | 0x14,
	24497 - 19968: jis0212<<14 | 0x1C<<7 | 0x15,
	24499 - 19968: jis0208<<14 | 0x25<<7 | 0x20,
	24500 - 19968: jis0208<<14 | 0x23<<7 | 0x06,
	24503 - 19968: jis0208<<14 | 0x58<<7 | 0x5D,
	24504 - 19968: jis0212<<14 | 0x1C<<7 | 0x16,
	24505 - 19968: jis0208<<14 | 0x24<<7 | 0x0F,
	24508 - 19968: jis0208<<14 | 0x36<<7 | 0x34,
	24509 - 19968: jis0208<<14 | 0x14<<7 | 0x0A,
	24515 - 19968: jis0208<<14 | 0x1E<<7 | 0x13,
	24516 - 19968: jis0212<<14 | 0x1C<<7 | 0x17,
	24517 - 19968: jis0208<<14 | 0x28<<7 | 0x0B,
	24519 - 19968: jis0212<<14 | 0x1C<<7 | 0x18,
	24520 - 19968: jis0212<<14 | 0x1C<<7 | 0x19,
	24521 - 19968: jis0212<<14 | 0x1C<<7 | 0x1A,
	24523 - 19968: jis0212<<14 | 0x1C<<7 | 0x1B,
	24524 - 19968: jis0208<<14 | 0x13<<7 | 0x56,
	24525 - 19968: jis0208<<14 | 0x26<<7 | 0x05,
	24528 - 19968: jis0212<<14 | 0x1C<<7 | 0x1C,
	24529 - 19968: jis0212<<14 | 0x1C<<7 | 0x1D,
	24530 - 19968: jis0212<<14 | 0x1C<<7 | 0x1E,
	24531 - 19968: jis0212<<14 | 0x1C<<7 | 0x1F,
	24532 - 19968: jis0212<<14 | 0x1C<<7 | 0x20,
	24534 - 19968: jis0208<<14 | 0x36<<7 | 0x35,
	24535 - 19968: jis0208<<14 | 0x1A<<7 | 0x35,
	24536 - 19968: jis0208<<14 | 0x2A<<7 | 0x19,
	24537 - 19968: jis0208<<14 | 0x2A<<7 | 0x1A,
	24540 - 19968: jis0208<<14 | 0x10<<7 | 0x5D,
	24541 - 19968: jis0208<<14 | 0x36<<7 | 0x3A,
	24542 - 19968: jis0208<<14 | 0x59<<7 | 0x00,
	24544 - 19968: jis0208<<14 | 0x22<<7 | 0x48,
	24545 - 19968: jis0212<<14 | 0x1C<<7 | 0x22,
	24546 - 19968: jis0212<<14 | 0x1C<<7 | 0x23,
	24548 - 19968: jis0208<<14 | 0x36<<7 | 0x37,
	24552 - 19968: jis0212<<14 | 0x1C<<7 | 0x24,
	24553 - 19968: jis0212<<14 | 0x1C<<7 | 0x25,
	24554 - 19968: jis0212<<14 | 0x1C<<7 | 0x26,
	24555 - 19968: jis0208<<14 | 0x11<<7 | 0x56,
	24556 - 19968: jis0212<<14 | 0x1C<<7 | 0x27,
	24557 - 19968: jis0212<<14 | 0x1C<<7 | 0x28,
	24558 - 19968: jis0212<<14 | 0x1C<<7 | 0x29,
	24559 - 19968: jis0212<<14 | 0x1C<<7 | 0x2A,
	24560 - 19968: jis0208<<14 | 0x37<<7 | 0x0C,
	24561 - 19968: jis0208<<14 | 0x36<<7 | 0x39,
	24562 - 19968: jis0212<<14 | 0x1C<<7 | 0x2B,
	24563 - 19968: jis0212<<14 | 0x1C<<7 | 0x2C,
	24565 - 19968: jis0208<<14 | 0x26<<7 | 0x0F,
	24566 - 19968: jis0212<<14 | 0x1C<<7 | 0x2D,
	24568 - 19968: jis0208<<14 | 0x36<<7 | 0x38,
	24570 - 19968: jis0212<<14 | 0x1C<<7 | 0x2E,
	24571 - 19968: jis0208<<14 | 0x36<<7 | 0x36,
	24572 - 19968: jis0212<<14 | 0x1C<<7 | 0x2F,
	24573 - 19968: jis0208<<14 | 0x18<<7 | 0x59,
	24575 - 19968: jis0208<<14 | 0x36<<7 | 0x3C,
	24583 - 19968: jis0212<<14 | 0x1C<<7 | 0x30,
	24586 - 19968: jis0212<<14 | 0x1C<<7 | 0x31,
	24589 - 19968: jis0212<<14 | 0x1C<<7 | 0x32,
	24590 - 19968: jis0208<<14 | 0x36<<7 | 0x42,
	24591 - 19968: jis0208<<14 | 0x36<<7 | 0x48,
	24592 - 19968: jis0208<<14 | 0x36<<7 | 0x40,
	24594 - 19968: jis0208<<14 | 0x24<<7 | 0x3B,
	24595 - 19968: jis0212<<14 | 0x1C<<7 | 0x33,
	24596 - 19968: jis0212<<14 | 0x1C<<7 | 0x34,
	24597 - 19968: jis0208<<14 | 0x36<<7 | 0x45,
	24598 - 19968: jis0208<<14 | 0x28<<7 | 0x3C,
	24599 - 19968: jis0212<<14 | 0x1C<<7 | 0x35,
	24600 - 19968: jis0212<<14 | 0x1C<<7 | 0x36,
	24601 - 19968: jis0208<<14 | 0x36<<7 | 0x3F,
	24602 - 19968: jis0212<<14 | 0x1C<<7 | 0x37,
	24603 - 19968: jis0208<<14 | 0x36<<7 | 0x44,
	24604 - 19968: jis0208<<14 | 0x2D<<7 | 0x46,
	24605 - 19968: jis0208<<14 | 0x1A<<7 | 0x36,
	24607 - 19968: jis0212<<14 | 0x1C<<7 | 0x38,
	24608 - 19968: jis0208<<14 | 0x21<<7 | 0x34,
	24609 - 19968: jis0208<<14 | 0x36<<7 | 0x3D,
	24612 - 19968: jis0212<<14 | 0x1C<<7 | 0x39,
	24613 - 19968: jis0208<<14 | 0x14<<7 | 0x3D,
	24614 - 19968: jis0208<<14 | 0x36<<7 | 0x47,
	24615 - 19968: jis0208<<14 | 0x1F<<7 | 0x0C,
	24616 - 19968: jis0208<<14 | 0x10<<7 | 0x44,
	24617 - 19968: jis0208<<14 | 0x36<<7 | 0x41,
	24618 - 19968: jis0208<<14 | 0x11<<7 | 0x57,
	24619 - 19968: jis0208<<14 | 0x36<<7 | 0x46,
	24621 - 19968: jis0212<<14 | 0x1C<<7 | 0x3A,
	24623 - 19968: jis0208<<14 | 0x15<<7 | 0x10,
	24625 - 19968: jis0208<<14 | 0x36<<7 | 0x43,
	24627 - 19968: jis0212<<14 | 0x1C<<7 | 0x3B,
	24629 - 19968: jis0212<<14 | 0x1C<<7 | 0x3C,
	24634 - 19968: jis0208<<14 | 0x36<<7 | 0x49,
	24640 - 19968: jis0212<<14 | 0x1C<<7 | 0x3D,
	24641 - 19968: jis0208<<14 | 0x36<<7 | 0x4B,
	24642 - 19968: jis0208<<14 | 0x36<<7 | 0x55,
	24643 - 19968: jis0208<<14 | 0x36<<7 | 0x53,
	24646 - 19968: jis0208<<14 | 0x36<<7 | 0x50,
	24647 - 19968: jis0212<<14 | 0x1C<<7 | 0x3E,
	24648 - 19968: jis0212<<14 | 0x1C<<7 | 0x3F,
	24649 - 19968: jis0212<<14 | 0x1C<<7 | 0x40,
	24650 - 19968: jis0208<<14 | 0x36<<7 | 0x4F,
	24651 - 19968: jis0208<<14 | 0x2D<<7 | 0x57,
	24652 - 19968: jis0212<<14 | 0x1C<<7 | 0x41,
	24653 - 19968: jis0208<<14 | 0x36<<7 | 0x51,
	24656 - 19968: jis0208<<14 | 0x15<<7 | 0x11,
	24657 - 19968: jis0212<<14 | 0x1C<<7 | 0x42,
	24658 - 19968: jis0208<<14 | 0x18<<7 | 0x10,
	24660 - 19968: jis0212<<14 | 0x1C<<7 | 0x43,
	24661 - 19968: jis0208<<14 | 0x1C<<7 | 0x59,
	24662 - 19968: jis0212<<14 | 0x1C<<7 | 0x44,
	24663 - 19968: jis0212<<14 | 0x1C<<7 | 0x45,
	24665 - 19968: jis0208<<14 | 0x36<<7 | 0x58,
	24666 - 19968: jis0208<<14 | 0x36<<7 | 0x4A,
	24669 - 19968: jis0208<<14 | 0x59<<7 | 0x01,
	24671 - 19968: jis0208<<14 | 0x36<<7 | 0x4E,
	24672 - 19968: jis0208<<14 | 0x36<<7 | 0x3E,
	24673 - 19968: jis0212<<14 | 0x1C<<7 | 0x47,
	24674 - 19968: jis0208<<14 | 0x11<<7 | 0x59,
	24675 - 19968: jis0208<<14 | 0x36<<7 | 0x52,
	24676 - 19968: jis0208<<14 | 0x36<<7 | 0x54,
	24677 - 19968: jis0208<<14 | 0x22<<7 | 0x30,
	24679 - 19968: jis0212<<14 | 0x1C<<7 | 0x48,
	24680 - 19968: jis0208<<14 | 0x19<<7 | 0x07,
	24681 - 19968: jis0208<<14 | 0x11<<7 | 0x17,
	24682 - 19968: jis0208<<14 | 0x36<<7 | 0x4C,
	24683 - 19968: jis0208<<14 | 0x36<<7 | 0x57,
	24684 - 19968: jis0208<<14 | 0x36<<7 | 0x56,
	24685 - 19968: jis0208<<14 | 0x15<<7 | 0x12,
	24687 - 19968: jis0208<<14 | 0x21<<7 | 0x08,
	24688 - 19968: jis0208<<14 | 0x12<<7 | 0x45,
	24689 - 19968: jis0212<<14 | 0x1C<<7 | 0x49,
	24693 - 19968: jis0208<<14 | 0x16<<7 | 0x22,
	24695 - 19968: jis0208<<14 | 0x36<<7 | 0x4D,
	24702 - 19968: jis0212<<14 | 0x1C<<7 | 0x4A,
	24703 - 19968: jis0212<<14 | 0x1C<<7 | 0x4B,
	24705 - 19968: jis0208<<14 | 0x36<<7 | 0x59,
	24706 - 19968: jis0212<<14 | 0x1C<<7 | 0x4C,
	24707 - 19968: jis0208<<14 | 0x36<<7 | 0x5C,
	24708 - 19968: jis0208<<14 | 0x37<<7 | 0x00,
	24709 - 19968: jis0208<<14 | 0x59<<7 | 0x02,
	24710 - 19968: jis0212<<14 | 0x1C<<7 | 0x4D,
	24712 - 19968: jis0212<<14 | 0x1C<<7 | 0x4E,
	24713 - 19968: jis0208<<14 | 0x1B<<7 | 0x1C,
	24714 - 19968: jis0208<<14 | 0x59<<7 | 0x03,
	24715 - 19968: jis0208<<14 | 0x37<<7 | 0x06,
	24716 - 19968: jis0208<<14 | 0x23<<7 | 0x4F,
	24717 - 19968: jis0208<<14 | 0x36<<7 | 0x5A,
	24718 - 19968: jis0212<<14 | 0x1C<<7 | 0x50,
	24721 - 19968: jis0212<<14 | 0x1C<<7 | 0x51,
	24722 - 19968: jis0208<<14 | 0x37<<7 | 0x04,
	24723 - 19968: jis0212<<14 | 0x1C<<7 | 0x52,
	24724 - 19968: jis0208<<14 | 0x11<<7 | 0x58,
	24725 - 19968: jis0212<<14 | 0x1C<<7 | 0x53,
	24726 - 19968: jis0208<<14 | 0x37<<7 | 0x02,
	24727 - 19968: jis0208<<14 | 0x37<<7 | 0x03,
	24728 - 19968: jis0212<<14 | 0x1C<<7 | 0x54,
	24730 - 19968: jis0208<<14 | 0x36<<7 | 0x5D,
	24731 - 19968: jis0208<<14 | 0x37<<7 | 0x01,
	24733 - 19968: jis0212<<14 | 0x1C<<7 | 0x55,
	24734 - 19968: jis0212<<14 | 0x1C<<7 | 0x56,
	24735 - 19968: jis0208<<14 | 0x17<<7 | 0x46,
	24736 - 19968: jis0208<<14 | 0x2C<<7 | 0x09,
	24738 - 19968: jis0212<<14 | 0x1C<<7 | 0x57,
	24739 - 19968: jis0208<<14 | 0x13<<7 | 0x14,
	24740 - 19968: jis0212<<14 | 0x1C<<7 | 0x58,
	24741 - 19968: jis0212<<14 | 0x1C<<7 | 0x59,
	24742 - 19968: jis0208<<14 | 0x10<<7 | 0x38,
	24743 - 19968: jis0208<<14 | 0x37<<7 | 0x05,
	24744 - 19968: jis0212<<14 | 0x1C<<7 | 0x5A,
	24745 - 19968: jis0208<<14 | 0x26<<7 | 0x19,
	24746 - 19968: jis0208<<14 | 0x0F<<7 | 0x0C,
	24752 - 19968: jis0212<<14 | 0x1C<<7 | 0x5B,
	24753 - 19968: jis0212<<14 | 0x1C<<7 | 0x5C,
	24754 - 19968: jis0208<<14 | 0x27<<7 | 0x40,
	24755 - 19968: jis0208<<14 | 0x36<<7 | 0x3B,
	24756 - 19968: jis0208<<14 | 0x37<<7 | 0x0B,
	24757 - 19968: jis0208<<14 | 0x37<<7 | 0x0F,
	24758 - 19968: jis0208<<14 | 0x2B<<7 | 0x44,
	24759 - 19968: jis0212<<14 | 0x1C<<7 | 0x5D,
	24760 - 19968: jis0208<<14 | 0x37<<7 | 0x08,
	24763 - 19968: jis0212<<14 | 0x1D<<7 | 0x00,
	24764 - 19968: jis0208<<14 | 0x24<<7 | 0x48,
	24765 - 19968: jis0208<<14 | 0x37<<7 | 0x0D,
	24766 - 19968: jis0212<<14 | 0x1D<<7 | 0x01,
	24770 - 19968: jis0212<<14 | 0x1D<<7 | 0x02,
	24772 - 19968: jis0212<<14 | 0x1D<<7 | 0x03,
	24773 - 19968: jis0208<<14 | 0x1D<<7 | 0x4F,
	24774 - 19968: jis0208<<14 | 0x37<<7 | 0x0E,
	24775 - 19968: jis0208<<14 | 0x25<<7 | 0x36,
	24776 - 19968: jis0212<<14 | 0x1D<<7 | 0x04,
	24777 - 19968: jis0212<<14 | 0x1D<<7 | 0x05,
	24778 - 19968: jis0212<<14 | 0x1D<<7 | 0x06,
	24779 - 19968: jis0212<<14 | 0x1D<<7 | 0x07,
	24782 - 19968: jis0212<<14 | 0x1D<<7 | 0x08,
	24783 - 19968: jis0212<<14 | 0x1D<<7 | 0x09,
	24785 - 19968: jis0208<<14 | 0x2E<<7 | 0x26,
	24787 - 19968: jis0208<<14 | 0x37<<7 | 0x0A,
	24788 - 19968: jis0212<<14 | 0x1D<<7 | 0x0A,
	24789 - 19968: jis0208<<14 | 0x59<<7 | 0x05,
	24792 - 19968: jis0208<<14 | 0x37<<7 | 0x10,
	24793 - 19968: jis0212<<14 | 0x1D<<7 | 0x0C,
	24794 - 19968: jis0208<<14 | 0x18<<7 | 0x5A,
	24795 - 19968: jis0212<<14 | 0x1D<<7 | 0x0D,
	24796 - 19968: jis0208<<14 | 0x1F<<7 | 0x2A,
	24797 - 19968: jis0212<<14 | 0x1D<<7 | 0x0E,
	24798 - 19968: jis0208<<14 | 0x59<<7 | 0x04,
	24799 - 19968: jis0208<<14 | 0x0F<<7 | 0x33,
	24800 - 19968: jis0208<<14 | 0x37<<7 | 0x09,
	24801 - 19968: jis0208<<14 | 0x37<<7 | 0x07,
	24802 - 19968: jis0212<<14 | 0x1D<<7 | 0x10,
	24803 - 19968: jis0208<<14 | 0x20<<7 | 0x39,
	24805 - 19968: jis0212<<14 | 0x1D<<7 | 0x11,
	24807 - 19968: jis0208<<14 | 0x36<<7 | 0x5B,
	24808 - 19968: jis0208<<14 | 0x1A<<7 | 0x13,
	24816 - 19968: jis0208<<14 | 0x21<<7 | 0x25,
	24817 - 19968: jis0208<<14 | 0x37<<7 | 0x1C,
	24818 - 19968: jis0208<<14 | 0x59<<7 | 0x07,
	24819 - 19968: jis0208<<14 | 0x20<<7 | 0x3A,
	24820 - 19968: jis0208<<14 | 0x37<<7 | 0x17,
	24821 - 19968: jis0212<<14 | 0x1D<<7 | 0x13,
	24822 - 19968: jis0208<<14 | 0x37<<7 | 0x14,
	24823 - 19968: jis0208<<14 | 0x37<<7 | 0x15,
	24824 - 19968: jis0212<<14 | 0x1D<<7 | 0x14,
	24825 - 19968: jis0208<<14 | 0x1B<<7 | 0x45,
	24826 - 19968: jis0208<<14 | 0x37<<7 | 0x18,
	24827 - 19968: jis0208<<14 | 0x37<<7 | 0x1B,
	24828 - 19968: jis0212<<14 | 0x1D<<7 | 0x15,
	24829 - 19968: jis0212<<14 | 0x1D<<7 | 0x16,
	24832 - 19968: jis0208<<14 | 0x37<<7 | 0x16,
	24833 - 19968: jis0208<<14 | 0x1C<<7 | 0x04,
	24834 - 19968: jis0212<<14 | 0x1D<<7 | 0x17,
	24835 - 19968: jis0208<<14 | 0x37<<7 | 0x19,
	24838 - 19968: jis0208<<14 | 0x37<<7 | 0x13,
	24839 - 19968: jis0212<<14 | 0x1D<<7 | 0x18,
	24840 - 19968: jis0208<<14 | 0x2B<<7 | 0x5B,
	24841 - 19968: jis0208<<14 | 0x2B<<7 | 0x5A,
	24842 - 19968: jis0212<<14 | 0x1D<<7 | 0x19,
	24844 - 19968: jis0212<<14 | 0x1D<<7 | 0x1A,
	24845 - 19968: jis0208<<14 | 0x37<<7 | 0x1D,
	24846 - 19968: jis0208<<14 | 0x37<<7 | 0x1E,
	24847 - 19968: jis0208<<14 | 0x0F<<7 | 0x34,
	24848 - 19968: jis0212<<14 | 0x1D<<7 | 0x1B,
	24849 - 19968: jis0208<<14 | 0x59<<7 | 0x08,
	24850 - 19968: jis0212<<14 | 0x1D<<7 | 0x1D,
	24851 - 19968: jis0212<<14 | 0x1D<<7 | 0x1E,
	24852 - 19968: jis0212<<14 | 0x1D<<7 | 0x1F,
	24853 - 19968: jis0208<<14 | 0x37<<7 | 0x12,
	24854 - 19968: jis0212<<14 | 0x1D<<7 | 0x20,
	24855 - 19968: jis0212<<14 | 0x1D<<7 | 0x21,
	24857 - 19968: jis0212<<14 | 0x1D<<7 | 0x22,
	24858 - 19968: jis0208<<14 | 0x15<<7 | 0x51,
	24859 - 19968: jis0208<<14 | 0x0F<<7 | 0x05,
	24860 - 19968: jis0212<<14 | 0x1D<<7 | 0x23,
	24862 - 19968: jis0212<<14 | 0x1D<<7 | 0x24,
	24863 - 19968: jis0208<<14 | 0x13<<7 | 0x15,
	24864 - 19968: jis0208<<14 | 0x59<<7 | 0x06,
	24865 - 19968: jis0208<<14 | 0x37<<7 | 0x1A,
	24866 - 19968: jis0212<<14 | 0x1D<<7 | 0x25,
	24871 - 19968: jis0208<<14 | 0x37<<7 | 0x22,
	24872 - 19968: jis0208<<14 | 0x37<<7 | 0x21,
	24874 - 19968: jis0212<<14 | 0x1D<<7 | 0x26,
	24875 - 19968: jis0212<<14 | 0x1D<<7 | 0x27,
	24876 - 19968: jis0208<<14 | 0x37<<7 | 0x26,
	24880 - 19968: jis0208<<14 | 0x59<<7 | 0x0A,
	24881 - 19968: jis0212<<14 | 0x1D<<7 | 0x29,
	24884 - 19968: jis0208<<14 | 0x37<<7 | 0x27,
	24885 - 19968: jis0212<<14 | 0x1D<<7 | 0x2A,
	24886 - 19968: jis0212<<14 | 0x1D<<7 | 0x2B,
	24887 - 19968: jis0208<<14 | 0x59<<7 | 0x09,
	24889 - 19968: jis0212<<14 | 0x1D<<7 | 0x2D,
	24892 - 19968: jis0208<<14 | 0x37<<7 | 0x25,
	24893 - 19968: jis0208<<14 | 0x37<<7 | 0x28,
	24894 - 19968: jis0208<<14 | 0x37<<7 | 0x20,
	24895 - 19968: jis0208<<14 | 0x37<<7 | 0x24,
	24897 - 19968: jis0212<<14 | 0x1D<<7 | 0x2E,
	24898 - 19968: jis0208<<14 | 0x37<<7 | 0x29,
	24900 - 19968: jis0208<<14 | 0x37<<7 | 0x2A,
	24901 - 19968: jis0212<<14 | 0x1D<<7 | 0x2F,
	24902 - 19968: jis0212<<14 | 0x1D<<7 | 0x30,
	24903 - 19968: jis0208<<14 | 0x37<<7 | 0x1F,
	24904 - 19968: jis0208<<14 | 0x1A<<7 | 0x5B,
	24905 - 19968: jis0212<<14 | 0x1D<<7 | 0x31,
	24906 - 19968: jis0208<<14 | 0x37<<7 | 0x23,
	24907 - 19968: jis0208<<14 | 0x21<<7 | 0x35,
	24908 - 19968: jis0208<<14 | 0x18<<7 | 0x11,
	24909 - 19968: jis0208<<14 | 0x37<<7 | 0x11,
	24910 - 19968: jis0208<<14 | 0x1E<<7 | 0x14,
	24915 - 19968: jis0208<<14 | 0x37<<7 | 0x37,
	24917 - 19968: jis0208<<14 | 0x29<<7 | 0x48,
	24920 - 19968: jis0208<<14 | 0x37<<7 | 0x2D,
	24921 - 19968: jis0208<<14 | 0x37<<7 | 0x2E,
	24922 - 19968: jis0208<<14 | 0x37<<7 | 0x2F,
	24925 - 19968: jis0208<<14 | 0x37<<7 | 0x36,
	24926 - 19968: jis0212<<14 | 0x1D<<7 | 0x32,
	24927 - 19968: jis0208<<14 | 0x37<<7 | 0x35,
	24928 - 19968: jis0212<<14 | 0x1D<<7 | 0x33,
	24930 - 19968: jis0208<<14 | 0x2A<<7 | 0x5C,
	24931 - 19968: jis0208<<14 | 0x13<<7 | 0x16,
	24933 - 19968: jis0208<<14 | 0x37<<7 | 0x33,
	24935 - 19968: jis0208<<14 | 0x16<<7 | 0x24,
	24936 - 19968: jis0208<<14 | 0x12<<7 | 0x13,
	24939 - 19968: jis0208<<14 | 0x37<<7 | 0x30,
	24940 - 19968: jis0212<<14 | 0x1D<<7 | 0x34,
	24942 - 19968: jis0208<<14 | 0x2D<<7 | 0x17,
	24943 - 19968: jis0208<<14 | 0x37<<7 | 0x32,
	24944 - 19968: jis0208<<14 | 0x0F<<7 | 0x35,
	24945 - 19968: jis0208<<14 | 0x37<<7 | 0x34,
	24946 - 19968: jis0212<<14 | 0x1D<<7 | 0x35,
	24947 - 19968: jis0208<<14 | 0x37<<7 | 0x2B,
	24948 - 19968: jis0208<<14 | 0x37<<7 | 0x31,
	24949 - 19968: jis0208<<14 | 0x37<<7 | 0x38,
	24950 - 19968: jis0208<<14 | 0x16<<7 | 0x23,
	24951 - 19968: jis0208<<14 | 0x37<<7 | 0x2C,
	24952 - 19968: jis0212<<14 | 0x1D<<7 | 0x36,
	24955 - 19968: jis0212<<14 | 0x1D<<7 | 0x37,
	24956 - 19968: jis0212<<14 | 0x1D<<7 | 0x38,
	24958 - 19968: jis0208<<14 | 0x2C<<7 | 0x3C,
	24959 - 19968: jis0212<<14 | 0x1D<<7 | 0x39,
	24960 - 19968: jis0212<<14 | 0x1D<<7 | 0x3A,
	24961 - 19968: jis0212<<14 | 0x1D<<7 | 0x3B,
	24962 - 19968: jis0208<<14 | 0x2C<<7 | 0x0A,
	24963 - 19968: jis0212<<14 | 0x1D<<7 | 0x3C,
	24964 - 19968: jis0212<<14 | 0x1D<<7 | 0x3D,
	24967 - 19968: jis0208<<14 | 0x37<<7 | 0x3B,
	24970 - 19968: jis0208<<14 | 0x37<<7 | 0x3F,
	24971 - 19968: jis0212<<14 | 0x1D<<7 | 0x3E,
	24973 - 19968: jis0212<<14 | 0x1D<<7 | 0x3F,
	24974 - 19968: jis0208<<14 | 0x20<<7 | 0x5D,
	24976 - 19968: jis0208<<14 | 0x2D<<7 | 0x58,
	24977 - 19968: jis0208<<14 | 0x37<<7 | 0x40,
	24978 - 19968: jis0212<<14 | 0x1D<<7 | 0x40,
	24979 - 19968: jis0212<<14 | 0x1D<<7 | 0x41,
	24980 - 19968: jis0208<<14 | 0x37<<7 | 0x3D,
	24982 - 19968: jis0208<<14 | 0x37<<7 | 0x3A,
	24983 - 19968: jis0212<<14 | 0x1D<<7 | 0x42,
	24984 - 19968: jis0208<<14 | 0x59<<7 | 0x0B,
	24985 - 19968: jis0208<<14 | 0x37<<7 | 0x39,
	24986 - 19968: jis0208<<14 | 0x37<<7 | 0x3E,
	24988 - 19968: jis0212<<14 | 0x1D<<7 | 0x44,
	24989 - 19968: jis0212<<14 | 0x1D<<7 | 0x45,
	24991 - 19968: jis0212<<14 | 0x1D<<7 | 0x46,
	24992 - 19968: jis0212<<14 | 0x1D<<7 | 0x47,
	24996 - 19968: jis0208<<14 | 0x29<<7 | 0x0F,
	24997 - 19968: jis0212<<14 | 0x1D<<7 | 0x48,
	24999 - 19968: jis0208<<14 | 0x25<<7 | 0x13,
	25000 - 19968: jis0212<<14 | 0x1D<<7 | 0x49,
	25001 - 19968: jis0208<<14 | 0x16<<7 | 0x25,
	25002 - 19968: jis0212<<14 | 0x1D<<7 | 0x4A,
	25003 - 19968: jis0208<<14 | 0x37<<7 | 0x41,
	25004 - 19968: jis0208<<14 | 0x37<<7 | 0x3C,
	25005 - 19968: jis0212<<14 | 0x1D<<7 | 0x4B,
	25006 - 19968: jis0208<<14 | 0x37<<7 | 0x42,
	25010 - 19968: jis0208<<14 | 0x16<<7 | 0x5A,
	25014 - 19968: jis0208<<14 | 0x11<<7 | 0x10,
	25016 - 19968: jis0212<<14 | 0x1D<<7 | 0x4C,
	25017 - 19968: jis0212<<14 | 0x1D<<7 | 0x4D,
	25018 - 19968: jis0208<<14 | 0x37<<7 | 0x4A,
	25020 - 19968: jis0212<<14 | 0x1D<<7 | 0x4E,
	25022 - 19968: jis0208<<14 | 0x13<<7 | 0x17,
	25024 - 19968: jis0212<<14 | 0x1D<<7 | 0x4F,
	25025 - 19968: jis0212<<14 | 0x1D<<7 | 0x50,
	25026 - 19968: jis0212<<14 | 0x1D<<7 | 0x51,
	25027 - 19968: jis0208<<14 | 0x37<<7 | 0x48,
	25030 - 19968: jis0208<<14 | 0x37<<7 | 0x49,
	25031 - 19968: jis0208<<14 | 0x19<<7 | 0x08,
	25032 - 19968: jis0208<<14 | 0x37<<7 | 0x47,
	25033 - 19968: jis0208<<14 | 0x37<<7 | 0x45,
	25034 - 19968: jis0208<<14 | 0x37<<7 | 0x44,
	25035 - 19968: jis0208<<14 | 0x37<<7 | 0x4B,
	25036 - 19968: jis0208<<14 | 0x37<<7 | 0x43,
	25037 - 19968: jis0208<<14 | 0x37<<7 | 0x4D,
	25038 - 19968: jis0212<<14 | 0x1D<<7 | 0x52,
	25039 - 19968: jis0212<<14 | 0x1D<<7 | 0x53,
	25040 - 19968: jis0208<<14 | 0x11<<7 | 0x5A,
	25045 - 19968: jis0212<<14 | 0x1D<<7 | 0x54,
	25052 - 19968: jis0212<<14 | 0x1D<<7 | 0x55,
	25053 - 19968: jis0212<<14 | 0x1D<<7 | 0x56,
	25054 - 19968: jis0212<<14 | 0x1D<<7 | 0x57,
	25055 - 19968: jis0212<<14 | 0x1D<<7 | 0x58,
	25057 - 19968: jis0212<<14 | 0x1D<<7 | 0x59,
	25058 - 19968: jis0212<<14 | 0x1D<<7 | 0x5A,
	25059 - 19968: jis0208<<14 | 0x37<<7 | 0x4F,
	25061 - 19968: jis0212<<14 | 0x1D<<7 | 0x5D,
	25062 - 19968: jis0208<<14 | 0x37<<7 | 0x4E,
	25063 - 19968: jis0212<<14 | 0x1D<<7 | 0x5B,
	25065 - 19968: jis0212<<14 | 0x1D<<7 | 0x5C,
	25068 - 19968: jis0212<<14 | 0x1E<<7 | 0x00,
	25069 - 19968: jis0212<<14 | 0x1E<<7 | 0x01,
	25071 - 19968: jis0212<<14 | 0x1E<<7 | 0x02,
	25074 - 19968: jis0208<<14 | 0x23<<7 | 0x07,
	25076 - 19968: jis0208<<14 | 0x37<<7 | 0x52,
	25078 - 19968: jis0208<<14 | 0x37<<7 | 0x50,
	25079 - 19968: jis0208<<14 | 0x37<<7 | 0x46,
	25080 - 19968: jis0208<<14 | 0x16<<7 | 0x5B,
	25082 - 19968: jis0208<<14 | 0x37<<7 | 0x51,
	25084 - 19968: jis0208<<14 | 0x37<<7 | 0x55,
	25085 - 19968: jis0208<<14 | 0x37<<7 | 0x54,
	25086 - 19968: jis0208<<14 | 0x37<<7 | 0x56,
	25087 - 19968: jis0208<<14 | 0x37<<7 | 0x53,
	25088 - 19968: jis0208<<14 | 0x37<<7 | 0x57,
	25089 - 19968: jis0212<<14 | 0x1E<<7 | 0x03,
	25091 - 19968: jis0212<<14 | 0x1E<<7 | 0x04,
	25092 - 19968: jis0212<<14 | 0x1E<<7 | 0x05,
	25095 - 19968: jis0212<<14 | 0x1E<<7 | 0x06,
	25096 - 19968: jis0208<<14 | 0x37<<7 | 0x58,
	25097 - 19968: jis0208<<14 | 0x37<<7 | 0x59,
	25098 - 19968: jis0208<<14 | 0x29<<7 | 0x49,
	25100 - 19968: jis0208<<14 | 0x37<<7 | 0x5B,
	25101 - 19968: jis0208<<14 | 0x37<<7 | 0x5A,
	25102 - 19968: jis0208<<14 | 0x1C<<7 | 0x1E,
	25104 - 19968: jis0208<<14 | 0x1F<<7 | 0x0D,
	25105 - 19968: jis0208<<14 | 0x11<<7 | 0x45,
	25106 - 19968: jis0208<<14 | 0x11<<7 | 0x5B,
	25107 - 19968: jis0208<<14 | 0x59<<7 | 0x0C,
	25108 - 19968: jis0208<<14 | 0x37<<7 | 0x5C,
	25109 - 19968: jis0212<<14 | 0x1E<<7 | 0x08,
	25110 - 19968: jis0208<<14 | 0x0F<<7 | 0x1E,
	25114 - 19968: jis0208<<14 | 0x1F<<7 | 0x2B,
	25115 - 19968: jis0208<<14 | 0x37<<7 | 0x5D,
	25116 - 19968: jis0212<<14 | 0x1E<<7 | 0x09,
	25117 - 19968: jis0208<<14 | 0x4B<<7 | 0x22,
	25118 - 19968: jis0208<<14 | 0x38<<7 | 0x00,
	25119 - 19968: jis0208<<14 | 0x16<<7 | 0x40,
	25120 - 19968: jis0212<<14 | 0x1E<<7 | 0x0A,
	25121 - 19968: jis0208<<14 | 0x38<<7 | 0x01,
	25122 - 19968: jis0212<<14 | 0x1E<<7 | 0x0B,
	25123 - 19968: jis0212<<14 | 0x1E<<7 | 0x0C,
	25126 - 19968: jis0208<<14 | 0x1F<<7 | 0x4E,
	25127 - 19968: jis0212<<14 | 0x1E<<7 | 0x0D,
	25129 - 19968: jis0212<<14 | 0x1E<<7 | 0x0E,
	25130 - 19968: jis0208<<14 | 0x38<<7 | 0x02,
	25131 - 19968: jis0212<<14 | 0x1E<<7 | 0x0F,
	25134 - 19968: jis0208<<14 | 0x38<<7 | 0x03,
	25135 - 19968: jis0208<<14 | 0x14<<7 | 0x19,
	25136 - 19968: jis0208<<14 | 0x38<<7 | 0x04,
	25138 - 19968: jis0208<<14 | 0x38<<7 | 0x05,
	25139 - 19968: jis0208<<14 | 0x38<<7 | 0x06,
	25140 - 19968: jis0208<<14 | 0x21<<7 | 0x36,
	25144 - 19968: jis0208<<14 | 0x17<<7 | 0x2C,
	25145 - 19968: jis0212<<14 | 0x1E<<7 | 0x10,
	25147 - 19968: jis0208<<14 | 0x2B<<7 | 0x40,
	25149 - 19968: jis0212<<14 | 0x1E<<7 | 0x11,
	25151 - 19968: jis0208<<14 | 0x2A<<7 | 0x1B,
	25152 - 19968: jis0208<<14 | 0x1C<<7 | 0x49,
	25153 - 19968: jis0208<<14 | 0x38<<7 | 0x07,
	25154 - 19968: jis0212<<14 | 0x1E<<7 | 0x12,
	25155 - 19968: jis0212<<14 | 0x1E<<7 | 0x13,
	25156 - 19968: jis0212<<14 | 0x1E<<7 | 0x14,
	25158 - 19968: jis0212<<14 | 0x1E<<7 | 0x15,
	25159 - 19968: jis0208<<14 | 0x1F<<7 | 0x4F,
	25160 - 19968: jis0208<<14 | 0x4D<<7 | 0x1C,
	25161 - 19968: jis0208<<14 | 0x27<<7 | 0x41,
	25163 - 19968: jis0208<<14 | 0x1B<<7 | 0x49,
	25164 - 19968: jis0212<<14 | 0x1E<<7 | 0x16,
	25165 - 19968: jis0208<<14 | 0x19<<7 | 0x2C,
	25166 - 19968: jis0208<<14 | 0x38<<7 | 0x08,
	25168 - 19968: jis0212<<14 | 0x1E<<7 | 0x17,
	25169 - 19968: jis0212<<14 | 0x1E<<7 | 0x18,
	25170 - 19968: jis0212<<14 | 0x1E<<7 | 0x19,
	25171 - 19968: jis0208<<14 | 0x21<<7 | 0x26,
	25172 - 19968: jis0212<<14 | 0x1E<<7 | 0x1A,
	25173 - 19968: jis0208<<14 | 0x29<<7 | 0x06,
	25174 - 19968: jis0212<<14 | 0x1E<<7 | 0x1B,
	25176 - 19968: jis0208<<14 | 0x21<<7 | 0x50,
	25178 - 19968: jis0212<<14 | 0x1E<<7 | 0x1C,
	25179 - 19968: jis0208<<14 | 0x38<<7 | 0x0B,
	25180 - 19968: jis0212<<14 | 0x1E<<7 | 0x1D,
	25182 - 19968: jis0208<<14 | 0x38<<7 | 0x09,
	25184 - 19968: jis0208<<14 | 0x38<<7 | 0x0C,
	25187 - 19968: jis0208<<14 | 0x38<<7 | 0x0A,
	25188 - 19968: jis0212<<14 | 0x1E<<7 | 0x1E,
	25192 - 19968: jis0208<<14 | 0x38<<7 | 0x0D,
	25197 - 19968: jis0212<<14 | 0x1E<<7 | 0x1F,
	25198 - 19968: jis0208<<14 | 0x29<<7 | 0x10,
	25199 - 19968: jis0212<<14 | 0x1E<<7 | 0x20,
	25201 - 19968: jis0208<<14 | 0x0F<<7 | 0x16,
	25203 - 19968: jis0212<<14 | 0x1E<<7 | 0x21,
	25206 - 19968: jis0208<<14 | 0x28<<7 | 0x3D,
	25209 - 19968: jis0208<<14 | 0x27<<7 | 0x42,
	25210 - 19968: jis0212<<14 | 0x1E<<7 | 0x22,
	25212 - 19968: jis0208<<14 | 0x38<<7 | 0x0E,
	25213 - 19968: jis0212<<14 | 0x1E<<7 | 0x23,
	25214 - 19968: jis0208<<14 | 0x38<<7 | 0x11,
	25215 - 19968: jis0208<<14 | 0x1D<<7 | 0x14,
	25216 - 19968: jis0208<<14 | 0x14<<7 | 0x1A,
	25218 - 19968: jis0208<<14 | 0x38<<7 | 0x0F,
	25219 - 19968: jis0208<<14 | 0x38<<7 | 0x16,
	25220 - 19968: jis0208<<14 | 0x1D<<7 | 0x15,
	25225 - 19968: jis0208<<14 | 0x38<<7 | 0x10,
	25226 - 19968: jis0208<<14 | 0x26<<7 | 0x23,
	25229 - 19968: jis0212<<14 | 0x1E<<7 | 0x24,
	25230 - 19968: jis0212<<14 | 0x1E<<7 | 0x25,
	25231 - 19968: jis0212<<14 | 0x1E<<7 | 0x26,
	25232 - 19968: jis0212<<14 | 0x1E<<7 | 0x27,
	25233 - 19968: jis0208<<14 | 0x2C<<7 | 0x3D,
	25234 - 19968: jis0208<<14 | 0x38<<7 | 0x12,
	25235 - 19968: jis0208<<14 | 0x38<<7 | 0x13,
	25236 - 19968: jis0208<<14 | 0x38<<7 | 0x17,
	25237 - 19968: jis0208<<14 | 0x24<<7 | 0x49,
	25238 - 19968: jis0208<<14 | 0x38<<7 | 0x14,
	25239 - 19968: jis0208<<14 | 0x18<<7 | 0x12,
	25240 - 19968: jis0208<<14 | 0x1F<<7 | 0x3D,
	25243 - 19968: jis0208<<14 | 0x38<<7 | 0x25,
	25244 - 19968: jis0208<<14 | 0x27<<7 | 0x13,
	25246 - 19968: jis0208<<14 | 0x21<<7 | 0x51,
	25254 - 19968: jis0208<<14 | 0x59<<7 | 0x0D,
	25256 - 19968: jis0212<<14 | 0x1E<<7 | 0x29,
	25259 - 19968: jis0208<<14 | 0x27<<7 | 0x43,
	25260 - 19968: jis0208<<14 | 0x39<<7 | 0x0C,
	25265 - 19968: jis0208<<14 | 0x29<<7 | 0x59,
	25267 - 19968: jis0212<<14 | 0x1E<<7 | 0x2A,
	25269 - 19968: jis0208<<14 | 0x23<<7 | 0x50,
	25270 - 19968: jis0212<<14 | 0x1E<<7 | 0x2B,
	25271 - 19968: jis0212<<14 | 0x1E<<7 | 0x2C,
	25273 - 19968: jis0208<<14 | 0x2A<<7 | 0x54,
	25274 - 19968: jis0212<<14 | 0x1E<<7 | 0x2D,
	25275 - 19968: jis0208<<14 | 0x38<<7 | 0x1A,
	25276 - 19968: jis0208<<14 | 0x11<<7 | 0x00,
	25277 - 19968: jis0208<<14 | 0x22<<7 | 0x49,
	25278 - 19968: jis0212<<14 | 0x1E<<7 | 0x2E,
	25279 - 19968: jis0212<<14 | 0x1E<<7 | 0x2F,
	25282 - 19968: jis0208<<14 | 0x38<<7 | 0x23,
	25284 - 19968: jis0212<<14 | 0x1E<<7 | 0x30,
	25285 - 19968: jis0208<<14 | 0x22<<7 | 0x13,
	25286 - 19968: jis0208<<14 | 0x38<<7 | 0x1D,
	25287 - 19968: jis0208<<14 | 0x38<<7 | 0x24,
	25288 - 19968: jis0208<<14 | 0x38<<7 | 0x1F,
	25289 - 19968: jis0208<<14 | 0x38<<7 | 0x26,
	25290 - 19968: jis0208<<14 | 0x38<<7 | 0x22,
	25292 - 19968: jis0208<<14 | 0x38<<7 | 0x21,
	25293 - 19968: jis0208<<14 | 0x26<<7 | 0x4E,
	25294 - 19968: jis0212<<14 | 0x1E<<7 | 0x31,
	25295 - 19968: jis0208<<14 | 0x38<<7 | 0x1B,
	25296 - 19968: jis0208<<14 | 0x11<<7 | 0x5C,
	25297 - 19968: jis0208<<14 | 0x38<<7 | 0x19,
	25298 - 19968: jis0208<<14 | 0x14<<7 | 0x50,
	25299 - 19968: jis0208<<14 | 0x21<<7 | 0x52,
	25300 - 19968: jis0208<<14 | 0x38<<7 | 0x15,
	25301 - 19968: jis0212<<14 | 0x1E<<7 | 0x32,
	25302 - 19968: jis0212<<14 | 0x1E<<7 | 0x33,
	25303 - 19968: jis0208<<14 | 0x38<<7 | 0x18,
	25304 - 19968: jis0208<<14 | 0x18<<7 | 0x13,
	25305 - 19968: jis0208<<14 | 0x1F<<7 | 0x3A,
	25306 - 19968: jis0212<<14 | 0x1E<<7 | 0x34,
	25307 - 19968: jis0208<<14 | 0x1D<<7 | 0x16,
	25308 - 19968: jis0208<<14 | 0x38<<7 | 0x20,
	25309 - 19968: jis0208<<14 | 0x26<<7 | 0x31,
	25312 - 19968: jis0208<<14 | 0x14<<7 | 0x51,
	25313 - 19968: jis0208<<14 | 0x12<<7 | 0x27,
	25322 - 19968: jis0212<<14 | 0x1E<<7 | 0x35,
	25324 - 19968: jis0208<<14 | 0x12<<7 | 0x46,
	25325 - 19968: jis0208<<14 | 0x1E<<7 | 0x00,
	25326 - 19968: jis0208<<14 | 0x38<<7 | 0x28,
	25327 - 19968: jis0208<<14 | 0x38<<7 | 0x2D,
	25329 - 19968: jis0208<<14 | 0x38<<7 | 0x29,
	25330 - 19968: jis0212<<14 | 0x1E<<7 | 0x36,
	25331 - 19968: jis0208<<14 | 0x16<<7 | 0x5C,
	25332 - 19968: jis0212<<14 | 0x1E<<7 | 0x37,
	25333 - 19968: jis0208<<14 | 0x38<<7 | 0x2E,
	25334 - 19968: jis0208<<14 | 0x1A<<7 | 0x01,
	25335 - 19968: jis0208<<14 | 0x18<<7 | 0x48,
	25340 - 19968: jis0212<<14 | 0x1E<<7 | 0x38,
	25341 - 19968: jis0212<<14 | 0x1E<<7 | 0x39,
	25342 - 19968: jis0208<<14 | 0x1C<<7 | 0x05,
	25343 - 19968: jis0208<<14 | 0x38<<7 | 0x1C,
	25345 - 19968: jis0208<<14 | 0x1A<<7 | 0x5C,
	25346 - 19968: jis0208<<14 | 0x38<<7 | 0x2B,
	25347 - 19968: jis0212<<14 | 0x1E<<7 | 0x3A,
	25348 - 19968: jis0212<<14 | 0x1E<<7 | 0x3B,
	25351 - 19968: jis0208<<14 | 0x1A<<7 | 0x37,
	25352 - 19968: jis0208<<14 | 0x38<<7 | 0x2C,
	25353 - 19968: jis0208<<14 | 0x0F<<7 | 0x23,
	25354 - 19968: jis0212<<14 | 0x1E<<7 | 0x3C,
	25355 - 19968: jis0212<<14 | 0x1E<<7 | 0x3D,
	25356 - 19968: jis0208<<14 | 0x38<<7 | 0x27,
	25357 - 19968: jis0212<<14 | 0x1E<<7 | 0x3E,
	25360 - 19968: jis0212<<14 | 0x1E<<7 | 0x3F,
	25361 - 19968: jis0208<<14 | 0x23<<7 | 0x08,
	25363 - 19968: jis0212<<14 | 0x1E<<7 | 0x40,
	25366 - 19968: jis0212<<14 | 0x1E<<7 | 0x41,
	25368 - 19968: jis0212<<14 | 0x1E<<7 | 0x42,
	25369 - 19968: jis0208<<14 | 0x14<<7 | 0x52,
	25375 - 19968: jis0208<<14 | 0x15<<7 | 0x13,
	25383 - 19968: jis0208<<14 | 0x38<<7 | 0x2A,
	25384 - 19968: jis0208<<14 | 0x0F<<7 | 0x06,
	25385 - 19968: jis0212<<14 | 0x1E<<7 | 0x43,
	25386 - 19968: jis0212<<14 | 0x1E<<7 | 0x44,
	25387 - 19968: jis0208<<14 | 0x19<<7 | 0x22,
	25389 - 19968: jis0212<<14 | 0x1E<<7 | 0x45,
	25391 - 19968: jis0208<<14 | 0x1E<<7 | 0x15,
	25397 - 19968: jis0212<<14 | 0x1E<<7 | 0x46,
	25398 - 19968: jis0212<<14 | 0x1E<<7 | 0x47,
	25401 - 19968: jis0212<<14 | 0x1E<<7 | 0x48,
	25402 - 19968: jis0208<<14 | 0x23<<7 | 0x51,
	25404 - 19968: jis0212<<14 | 0x1E<<7 | 0x49,
	25405 - 19968: jis0208<<14 | 0x27<<7 | 0x33,
	25406 - 19968: jis0208<<14 | 0x38<<7 | 0x30,
	25407 - 19968: jis0208<<14 | 0x20<<7 | 0x3D,
	25409 - 19968: jis0212<<14 | 0x1E<<7 | 0x4A,
	25410 - 19968: jis0212<<14 | 0x1E<<7 | 0x4B,
	25411 - 19968: jis0212<<14 | 0x1E<<7 | 0x4C,
	25412 - 19968: jis0212<<14 | 0x1E<<7 | 0x4D,
	25414 - 19968: jis0212<<14 | 0x1E<<7 | 0x4E,
	25417 - 19968: jis0208<<14 | 0x21<<7 | 0x09,
	25418 - 19968: jis0212<<14 | 0x1E<<7 | 0x4F,
	25419 - 19968: jis0212<<14 | 0x1E<<7 | 0x50,
	25420 - 19968: jis0208<<14 | 0x1A<<7 | 0x0A,
	25421 - 19968: jis0208<<14 | 0x38<<7 | 0x31,
	25422 - 19968: jis0212<<14 | 0x1E<<7 | 0x51,
	25423 - 19968: jis0208<<14 | 0x38<<7 | 0x33,
	25424 - 19968: jis0208<<14 | 0x38<<7 | 0x2F,
	25426 - 19968: jis0212<<14 | 0x1E<<7 | 0x52,
	25427 - 19968: jis0212<<14 | 0x1E<<7 | 0x53,
	25428 - 19968: jis0212<<14 | 0x1E<<7 | 0x54,
	25429 - 19968: jis0208<<14 | 0x29<<7 | 0x40,
	25431 - 19968: jis0208<<14 | 0x23<<7 | 0x1C,
	25432 - 19968: jis0212<<14 | 0x1E<<7 | 0x55,
	25435 - 19968: jis0212<<14 | 0x1E<<7 | 0x56,
	25436 - 19968: jis0208<<14 | 0x20<<7 | 0x3B,
	25445 - 19968: jis0212<<14 | 0x1E<<7 | 0x57,
	25446 - 19968: jis0212<<14 | 0x1E<<7 | 0x58,
	25447 - 19968: jis0208<<14 | 0x29<<7 | 0x5A,
	25448 - 19968: jis0208<<14 | 0x1B<<7 | 0x2D,
	25449 - 19968: jis0208<<14 | 0x38<<7 | 0x3F,
	25451 - 19968: jis0208<<14 | 0x38<<7 | 0x3E,
	25452 - 19968: jis0212<<14 | 0x1E<<7 | 0x59,
	25453 - 19968: jis0212<<14 | 0x1E<<7 | 0x5A,
	25454 - 19968: jis0208<<14 | 0x1E<<7 | 0x57,
	25457 - 19968: jis0212<<14 | 0x1E<<7 | 0x5B,
	25458 - 19968: jis0208<<14 | 0x16<<7 | 0x5D,
	25460 - 19968: jis0212<<14 | 0x1E<<7 | 0x5C,
	25461 - 19968: jis0212<<14 | 0x1E<<7 | 0x5D,
	25462 - 19968: jis0208<<14 | 0x38<<7 | 0x38,
	25463 - 19968: jis0208<<14 | 0x1D<<7 | 0x18,
	25464 - 19968: jis0212<<14 | 0x1F<<7 | 0x00,
	25466 - 19968: jis0208<<14 | 0x25<<7 | 0x47,
	25467 - 19968: jis0208<<14 | 0x26<<7 | 0x10,
	25468 - 19968: jis0212<<14 | 0x1F<<7 | 0x01,
	25469 - 19968: jis0212<<14 | 0x1F<<7 | 0x02,
	25471 - 19968: jis0212<<14 | 0x1F<<7 | 0x03,
	25472 - 19968: jis0208<<14 | 0x38<<7 | 0x36,
	25474 - 19968: jis0212<<14 | 0x1F<<7 | 0x04,
	25475 - 19968: jis0208<<14 | 0x20<<7 | 0x3C,
	25476 - 19968: jis0212<<14 | 0x1F<<7 | 0x05,
	25479 - 19968: jis0212<<14 | 0x1F<<7 | 0x06,
	25480 - 19968: jis0208<<14 | 0x1B<<7 | 0x57,
	25481 - 19968: jis0208<<14 | 0x38<<7 | 0x3B,
	25482 - 19968: jis0212<<14 | 0x1F<<7 | 0x07,
	25484 - 19968: jis0208<<14 | 0x1D<<7 | 0x17,
	25486 - 19968: jis0208<<14 | 0x38<<7 | 0x35,
	25487 - 19968: jis0208<<14 | 0x38<<7 | 0x3A,
	25488 - 19968: jis0212<<14 | 0x1F<<7 | 0x08,
	25490 - 19968: jis0208<<14 | 0x26<<7 | 0x32,
	25492 - 19968: jis0212<<14 | 0x1F<<7 | 0x09,
	25493 - 19968: jis0212<<14 | 0x1F<<7 | 0x0A,
	25494 - 19968: jis0208<<14 | 0x38<<7 | 0x34,
	25496 - 19968: jis0208<<14 | 0x16<<7 | 0x00,
	25497 - 19968: jis0212<<14 | 0x1F<<7 | 0x0B,
	25498 - 19968: jis0212<<14 | 0x1F<<7 | 0x0C,
	25499 - 19968: jis0208<<14 | 0x12<<7 | 0x3C,
	25502 - 19968: jis0212<<14 | 0x1F<<7 | 0x0D,
	25503 - 19968: jis0208<<14 | 0x38<<7 | 0x3C,
	25504 - 19968: jis0208<<14 | 0x2D<<7 | 0x0A,
	25505 - 19968: jis0208<<14 | 0x19<<7 | 0x2D,
	25506 - 19968: jis0208<<14 | 0x22<<7 | 0x14,
	25507 - 19968: jis0208<<14 | 0x38<<7 | 0x39,
	25508 - 19968: jis0212<<14 | 0x1F<<7 | 0x0E,
	25509 - 19968: jis0208<<14 | 0x1F<<7 | 0x3B,
	25510 - 19968: jis0212<<14 | 0x1F<<7 | 0x0F,
	25511 - 19968: jis0208<<14 | 0x18<<7 | 0x14,
	25512 - 19968: jis0208<<14 | 0x1E<<7 | 0x43,
	25513 - 19968: jis0208<<14 | 0x10<<7 | 0x45,
	25514 - 19968: jis0208<<14 | 0x20<<7 | 0x1B,
	25515 - 19968: jis0208<<14 | 0x38<<7 | 0x37,
	25516 - 19968: jis0208<<14 | 0x14<<7 | 0x24,
	25517 - 19968: jis0212<<14 | 0x1F<<7 | 0x10,
	25518 - 19968: jis0212<<14 | 0x1F<<7 | 0x11,
	25519 - 19968: jis0212<<14 | 0x1F<<7 | 0x12,
	25522 - 19968: jis0208<<14 | 0x16<<7 | 0x26,
	25524 - 19968: jis0208<<14 | 0x23<<7 | 0x2E,
	25525 - 19968: jis0208<<14 | 0x38<<7 | 0x3D,
	25531 - 19968: jis0208<<14 | 0x20<<7 | 0x3E,
	25533 - 19968: jis0212<<14 | 0x1F<<7 | 0x13,
	25534 - 19968: jis0208<<14 | 0x38<<7 | 0x40,
	25536 - 19968: jis0208<<14 | 0x38<<7 | 0x42,
	25537 - 19968: jis0212<<14 | 0x1F<<7 | 0x14,
	25539 - 19968: jis0208<<14 | 0x21<<7 | 0x16,
	25540 - 19968: jis0208<<14 | 0x38<<7 | 0x48,
	25541 - 19968: jis0212<<14 | 0x1F<<7 | 0x15,
	25542 - 19968: jis0208<<14 | 0x38<<7 | 0x43,
	25544 - 19968: jis0212<<14 | 0x1F<<7 | 0x16,
	25545 - 19968: jis0208<<14 | 0x38<<7 | 0x45,
	25550 - 19968: jis0212<<14 | 0x1F<<7 | 0x17,
	25551 - 19968: jis0208<<14 | 0x28<<7 | 0x20,
	25552 - 19968: jis0208<<14 | 0x23<<7 | 0x52,
	25553 - 19968: jis0212<<14 | 0x1F<<7 | 0x18,
	25554 - 19968: jis0208<<14 | 0x38<<7 | 0x46,
	25555 - 19968: jis0212<<14 | 0x1F<<7 | 0x19,
	25556 - 19968: jis0212<<14 | 0x1F<<7 | 0x1A,
	25557 - 19968: jis0212<<14 | 0x1F<<7 | 0x1B,
	25558 - 19968: jis0208<<14 | 0x2C<<7 | 0x0B,
	25562 - 19968: jis0208<<14 | 0x2C<<7 | 0x27,
	25563 - 19968: jis0208<<14 | 0x13<<7 | 0x18,
	25564 - 19968: jis0212<<14 | 0x1F<<7 | 0x1C,
	25568 - 19968: jis0212<<14 | 0x1F<<7 | 0x1D,
	25569 - 19968: jis0208<<14 | 0x0F<<7 | 0x0D,
	25571 - 19968: jis0208<<14 | 0x38<<7 | 0x44,
	25573 - 19968: jis0212<<14 | 0x1F<<7 | 0x1E,
	25577 - 19968: jis0208<<14 | 0x38<<7 | 0x41,
	25578 - 19968: jis0212<<14 | 0x1F<<7 | 0x1F,
	25580 - 19968: jis0212<<14 | 0x1F<<7 | 0x20,
	25582 - 19968: jis0208<<14 | 0x13<<7 | 0x57,
	25586 - 19968: jis0212<<14 | 0x1F<<7 | 0x21,
	25587 - 19968: jis0212<<14 | 0x1F<<7 | 0x22,
	25588 - 19968: jis0208<<14 | 0x10<<7 | 0x46,
	25589 - 19968: jis0208<<14 | 0x59<<7 | 0x0E,
	25590 - 19968: jis0208<<14 | 0x38<<7 | 0x47,
	25592 - 19968: jis0212<<14 | 0x1F<<7 | 0x24,
	25593 - 19968: jis0212<<14 | 0x1F<<7 | 0x25,
	25594 - 19968: jis0208<<14 | 0x2C<<7 | 0x28,
	25606 - 19968: jis0208<<14 | 0x38<<7 | 0x4B,
	25609 - 19968: jis0212<<14 | 0x1F<<7 | 0x26,
	25610 - 19968: jis0212<<14 | 0x1F<<7 | 0x27,
	25613 - 19968: jis0208<<14 | 0x21<<7 | 0x1A,
	25615 - 19968: jis0208<<14 | 0x38<<7 | 0x52,
	25616 - 19968: jis0212<<14 | 0x1F<<7 | 0x28,
	25618 - 19968: jis0212<<14 | 0x1F<<7 | 0x29,
	25619 - 19968: jis0208<<14 | 0x38<<7 | 0x4C,
	25620 - 19968: jis0212<<14 | 0x1F<<7 | 0x2A,
	25622 - 19968: jis0208<<14 | 0x38<<7 | 0x49,
	25623 - 19968: jis0208<<14 | 0x38<<7 | 0x50,
	25624 - 19968: jis0212<<14 | 0x1F<<7 | 0x2B,
	25628 - 19968: jis0208<<14 | 0x38<<7 | 0x32,
	25630 - 19968: jis0212<<14 | 0x1F<<7 | 0x2C,
	25632 - 19968: jis0212<<14 | 0x1F<<7 | 0x2D,
	25634 - 19968: jis0212<<14 | 0x1F<<7 | 0x2E,
	25636 - 19968: jis0212<<14 | 0x1F<<7 | 0x2F,
	25637 - 19968: jis0212<<14 | 0x1F<<7 | 0x30,
	25638 - 19968: jis0208<<14 | 0x38<<7 | 0x4D,
	25640 - 19968: jis0208<<14 | 0x38<<7 | 0x51,
	25641 - 19968: jis0212<<14 | 0x1F<<7 | 0x31,
	25642 - 19968: jis0212<<14 | 0x1F<<7 | 0x32,
	25644 - 19968: jis0208<<14 | 0x27<<7 | 0x21,
	25645 - 19968: jis0208<<14 | 0x24<<7 | 0x4A,
	25647 - 19968: jis0212<<14 | 0x1F<<7 | 0x33,
	25648 - 19968: jis0212<<14 | 0x1F<<7 | 0x34,
	25652 - 19968: jis0208<<14 | 0x38<<7 | 0x4A,
	25653 - 19968: jis0212<<14 | 0x1F<<7 | 0x35,
	25654 - 19968: jis0208<<14 | 0x38<<7 | 0x4E,
	25658 - 19968: jis0208<<14 | 0x16<<7 | 0x27,
	25661 - 19968: jis0212<<14 | 0x1F<<7 | 0x36,
	25662 - 19968: jis0208<<14 | 0x19<<7 | 0x50,
	25663 - 19968: jis0212<<14 | 0x1F<<7 | 0x37,
	25666 - 19968: jis0208<<14 | 0x1F<<7 | 0x3C,
	25675 - 19968: jis0212<<14 | 0x1F<<7 | 0x38,
	25678 - 19968: jis0208<<14 | 0x38<<7 | 0x56,
	25679 - 19968: jis0212<<14 | 0x1F<<7 | 0x39,
	25681 - 19968: jis0212<<14 | 0x1F<<7 | 0x3A,
	25682 - 19968: jis0212<<14 | 0x1F<<7 | 0x3B,
	25683 - 19968: jis0212<<14 | 0x1F<<7 | 0x3C,
	25684 - 19968: jis0212<<14 | 0x1F<<7 | 0x3D,
	25688 - 19968: jis0208<<14 | 0x24<<7 | 0x05,
	25690 - 19968: jis0212<<14 | 0x1F<<7 | 0x3E,
	25691 - 19968: jis0212<<14 | 0x1F<<7 | 0x3F,
	25692 - 19968: jis0212<<14 | 0x1F<<7 | 0x40,
	25693 - 19968: jis0212<<14 | 0x1F<<7 | 0x41,
	25695 - 19968: jis0212<<14 | 0x1F<<7 | 0x42,
	25696 - 19968: jis0208<<14 | 0x59<<7 | 0x0F,
	25697 - 19968: jis0212<<14 | 0x1F<<7 | 0x44,
	25699 - 19968: jis0212<<14 | 0x1F<<7 | 0x45,
	25703 - 19968: jis0208<<14 | 0x38<<7 | 0x53,
	25705 - 19968: jis0208<<14 | 0x2A<<7 | 0x3F,
	25709 - 19968: jis0212<<14 | 0x1F<<7 | 0x46,
	25711 - 19968: jis0208<<14 | 0x38<<7 | 0x54,
	25715 - 19968: jis0212<<14 | 0x1F<<7 | 0x47,
	25716 - 19968: jis0212<<14 | 0x1F<<7 | 0x48,
	25718 - 19968: jis0208<<14 | 0x38<<7 | 0x55,
	25720 - 19968: jis0208<<14 | 0x2B<<7 | 0x2D,
	25722 - 19968: jis0208<<14 | 0x1F<<7 | 0x01,
	25723 - 19968: jis0212<<14 | 0x1F<<7 | 0x49,
	25725 - 19968: jis0212<<14 | 0x1F<<7 | 0x4A,
	25731 - 19968: jis0208<<14 | 0x16<<7 | 0x41,
	25733 - 19968: jis0212<<14 | 0x1F<<7 | 0x4B,
	25735 - 19968: jis0212<<14 | 0x1F<<7 | 0x4C,
	25736 - 19968: jis0208<<14 | 0x38<<7 | 0x5C,
	25743 - 19968: jis0212<<14 | 0x1F<<7 | 0x4D,
	25744 - 19968: jis0212<<14 | 0x1F<<7 | 0x4E,
	25745 - 19968: jis0212<<14 | 0x1F<<7 | 0x4F,
	25746 - 19968: jis0208<<14 | 0x1A<<7 | 0x14,
	25747 - 19968: jis0208<<14 | 0x38<<7 | 0x59,
	25749 - 19968: jis0208<<14 | 0x38<<7 | 0x58,
	25752 - 19968: jis0212<<14 | 0x1F<<7 | 0x50,
	25753 - 19968: jis0212<<14 | 0x1F<<7 | 0x51,
	25754 - 19968: jis0208<<14 | 0x26<<7 | 0x11,
	25755 - 19968: jis0212<<14 | 0x1F<<7 | 0x52,
	25757 - 19968: jis0208<<14 | 0x59<<7 | 0x10,
	25758 - 19968: jis0208<<14 | 0x25<<7 | 0x14,
	25759 - 19968: jis0212<<14 | 0x1F<<7 | 0x54,
	25761 - 19968: jis0212<<14 | 0x1F<<7 | 0x55,
	25763 - 19968: jis0212<<14 | 0x1F<<7 | 0x56,
	25764 - 19968: jis0208<<14 | 0x24<<7 | 0x10,
	25765 - 19968: jis0208<<14 | 0x38<<7 | 0x5A,
	25766 - 19968: jis0212<<14 | 0x1F<<7 | 0x57,
	25768 - 19968: jis0212<<14 | 0x1F<<7 | 0x58,
	25769 - 19968: jis0208<<14 | 0x38<<7 | 0x5B,
	25771 - 19968: jis0208<<14 | 0x28<<7 | 0x4E,
	25772 - 19968: jis0212<<14 | 0x1F<<7 | 0x59,
	25773 - 19968: jis0208<<14 | 0x26<<7 | 0x24,
	25774 - 19968: jis0208<<14 | 0x1A<<7 | 0x02,
	25776 - 19968: jis0208<<14 | 0x1F<<7 | 0x50,
	25778 - 19968: jis0208<<14 | 0x2A<<7 | 0x2F,
	25779 - 19968: jis0212<<14 | 0x1F<<7 | 0x5A,
	25785 - 19968: jis0208<<14 | 0x12<<7 | 0x28,
	25787 - 19968: jis0208<<14 | 0x39<<7 | 0x04,
	25788 - 19968: jis0208<<14 | 0x38<<7 | 0x5D,
	25789 - 19968: jis0212<<14 | 0x1F<<7 | 0x5B,
	25790 - 19968: jis0212<<14 | 0x1F<<7 | 0x5C,
	25791 - 19968: jis0212<<14 | 0x1F<<7 | 0x5D,
	25793 - 19968: jis0208<<14 | 0x2C<<7 | 0x29,
	25794 - 19968: jis0208<<14 | 0x39<<7 | 0x06,
	25796 - 19968: jis0212<<14 | 0x20<<7 | 0x00,
	25797 - 19968: jis0208<<14 | 0x39<<7 | 0x02,
	25799 - 19968: jis0208<<14 | 0x39<<7 | 0x03,
	25801 - 19968: jis0212<<14 | 0x20<<7 | 0x01,
	25802 - 19968: jis0212<<14 | 0x20<<7 | 0x02,
	25803 - 19968: jis0212<<14 | 0x20<<7 | 0x03,
	25804 - 19968: jis0212<<14 | 0x20<<7 | 0x04,
	25805 - 19968: jis0208<<14 | 0x20<<7 | 0x3F,
	25806 - 19968: jis0208<<14 | 0x59<<7 | 0x11,
	25808 - 19968: jis0212<<14 | 0x20<<7 | 0x06,
	25809 - 19968: jis0212<<14 | 0x20<<7 | 0x07,
	25810 - 19968: jis0208<<14 | 0x39<<7 | 0x01,
	25812 - 19968: jis0208<<14 | 0x38<<7 | 0x1E,
	25813 - 19968: jis0212<<14 | 0x20<<7 | 0x08,
	25815 - 19968: jis0212<<14 | 0x20<<7 | 0x09,
	25816 - 19968: jis0208<<14 | 0x39<<7 | 0x05,
	25818 - 19968: jis0208<<14 | 0x39<<7 | 0x00,
	25824 - 19968: jis0208<<14 | 0x39<<7 | 0x0A,
	25825 - 19968: jis0208<<14 | 0x39<<7 | 0x0B,
	25826 - 19968: jis0208<<14 | 0x24<<7 | 0x06,
	25827 - 19968: jis0208<<14 | 0x39<<7 | 0x0D,
	25828 - 19968: jis0212<<14 | 0x20<<7 | 0x0A,
	25829 - 19968: jis0212<<14 | 0x20<<7 | 0x0B,
	25830 - 19968: jis0208<<14 | 0x1A<<7 | 0x03,
	25831 - 19968: jis0208<<14 | 0x39<<7 | 0x08,
	25833 - 19968: jis0212<<14 | 0x20<<7 | 0x0C,
	25834 - 19968: jis0212<<14 | 0x20<<7 | 0x0D,
	25836 - 19968: jis0208<<14 | 0x14<<7 | 0x1B,
	25837 - 19968: jis0212<<14 | 0x20<<7 | 0x0E,
	25839 - 19968: jis0208<<14 | 0x39<<7 | 0x0E,
	25840 - 19968: jis0212<<14 | 0x20<<7 | 0x0F,
	25841 - 19968: jis0208<<14 | 0x39<<7 | 0x07,
	25842 - 19968: jis0208<<14 | 0x39<<7 | 0x12,
	25844 - 19968: jis0208<<14 | 0x39<<7 | 0x11,
	25845 - 19968: jis0212<<14 | 0x20<<7 | 0x10,
	25846 - 19968: jis0208<<14 | 0x39<<7 | 0x10,
	25847 - 19968: jis0212<<14 | 0x20<<7 | 0x11,
	25850 - 19968: jis0208<<14 | 0x39<<7 | 0x13,
	25851 - 19968: jis0212<<14 | 0x20<<7 | 0x12,
	25853 - 19968: jis0208<<14 | 0x39<<7 | 0x15,
	25854 - 19968: jis0208<<14 | 0x1D<<7 | 0x50,
	25855 - 19968: jis0212<<14 | 0x20<<7 | 0x13,
	25856 - 19968: jis0208<<14 | 0x39<<7 | 0x14,
	25857 - 19968: jis0212<<14 | 0x20<<7 | 0x14,
	25860 - 19968: jis0212<<14 | 0x20<<7 | 0x15,
	25861 - 19968: jis0208<<14 | 0x39<<7 | 0x18,
	25864 - 19968: jis0212<<14 | 0x20<<7 | 0x16,
	25865 - 19968: jis0212<<14 | 0x20<<7 | 0x17,
	25866 - 19968: jis0212<<14 | 0x20<<7 | 0x18,
	25871 - 19968: jis0212<<14 | 0x20<<7 | 0x19,
	25875 - 19968: jis0212<<14 | 0x20<<7 | 0x1A,
	25876 - 19968: jis0212<<14 | 0x20<<7 | 0x1B,
	25878 - 19968: jis0212<<14 | 0x20<<7 | 0x1C,
	25880 - 19968: jis0208<<14 | 0x39<<7 | 0x16,
	25881 - 19968: jis0212<<14 | 0x20<<7 | 0x1D,
	25883 - 19968: jis0212<<14 | 0x20<<7 | 0x1E,
	25884 - 19968: jis0208<<14 | 0x39<<7 | 0x17,
	25885 - 19968: jis0208<<14 | 0x38<<7 | 0x4F,
	25886 - 19968: jis0212<<14 | 0x20<<7 | 0x1F,
	25887 - 19968: jis0212<<14 | 0x20<<7 | 0x20,
	25890 - 19968: jis0212<<14 | 0x20<<7 | 0x21,
	25891 - 19968: jis0208<<14 | 0x39<<7 | 0x1A,
	25892 - 19968: jis0208<<14 | 0x39<<7 | 0x19,
	25894 - 19968: jis0212<<14 | 0x20<<7 | 0x22,
	25897 - 19968: jis0212<<14 | 0x20<<7 | 0x23,
	25898 - 19968: jis0208<<14 | 0x38<<7 | 0x57,
	25899 - 19968: jis0208<<14 | 0x39<<7 | 0x1B,
	25900 - 19968: jis0208<<14 | 0x39<<7 | 0x0F,
	25902 - 19968: jis0212<<14 | 0x20<<7 | 0x24,
	25903 - 19968: jis0208<<14 | 0x1A<<7 | 0x38,
	25905 - 19968: jis0212<<14 | 0x20<<7 | 0x25,
	25908 - 19968: jis0208<<14 | 0x39<<7 | 0x1C,
	25909 - 19968: jis0208<<14 | 0x39<<7 | 0x1D,
	25910 - 19968: jis0208<<14 | 0x39<<7 | 0x1F,
	25911 - 19968: jis0208<<14 | 0x39<<7 | 0x1E,
	25912 - 19968: jis0208<<14 | 0x39<<7 | 0x20,
	25913 - 19968: jis0208<<14 | 0x11<<7 | 0x5D,
	25914 - 19968: jis0212<<14 | 0x20<<7 | 0x26,
	25915 - 19968: jis0208<<14 | 0x18<<7 | 0x15,
	25916 - 19968: jis0212<<14 | 0x20<<7 | 0x27,
	25917 - 19968: jis0212<<14 | 0x20<<7 | 0x28,
	25918 - 19968: jis0208<<14 | 0x29<<7 | 0x5B,
	25919 - 19968: jis0208<<14 | 0x1F<<7 | 0x0E,
	25923 - 19968: jis0212<<14 | 0x20<<7 | 0x29,
	25925 - 19968: jis0208<<14 | 0x17<<7 | 0x2D,
	25927 - 19968: jis0212<<14 | 0x20<<7 | 0x2A,
	25928 - 19968: jis0208<<14 | 0x39<<7 | 0x22,
	25929 - 19968: jis0212<<14 | 0x20<<7 | 0x2B,
	25933 - 19968: jis0208<<14 | 0x39<<7 | 0x25,
	25934 - 19968: jis0208<<14 | 0x59<<7 | 0x12,
	25935 - 19968: jis0208<<14 | 0x28<<7 | 0x31,
	25936 - 19968: jis0212<<14 | 0x20<<7 | 0x2C,
	25937 - 19968: jis0208<<14 | 0x14<<7 | 0x3E,
	25938 - 19968: jis0212<<14 | 0x20<<7 | 0x2D,
	25940 - 19968: jis0212<<14 | 0x20<<7 | 0x2E,
	25941 - 19968: jis0208<<14 | 0x39<<7 | 0x24,
	25942 - 19968: jis0208<<14 | 0x39<<7 | 0x23,
	25943 - 19968: jis0208<<14 | 0x26<<7 | 0x33,
	25944 - 19968: jis0208<<14 | 0x39<<7 | 0x26,
	25945 - 19968: jis0208<<14 | 0x15<<7 | 0x14,
	25949 - 19968: jis0208<<14 | 0x39<<7 | 0x28,
	25950 - 19968: jis0208<<14 | 0x39<<7 | 0x27,
	25951 - 19968: jis0212<<14 | 0x20<<7 | 0x2F,
	25952 - 19968: jis0212<<14 | 0x20<<7 | 0x30,
	25954 - 19968: jis0208<<14 | 0x13<<7 | 0x19,
	25955 - 19968: jis0208<<14 | 0x1A<<7 | 0x15,
	25958 - 19968: jis0208<<14 | 0x25<<7 | 0x37,
	25959 - 19968: jis0212<<14 | 0x20<<7 | 0x31,
	25963 - 19968: jis0212<<14 | 0x20<<7 | 0x32,
	25964 - 19968: jis0208<<14 | 0x16<<7 | 0x28,
	25968 - 19968: jis0208<<14 | 0x1E<<7 | 0x53,
	25970 - 19968: jis0208<<14 | 0x39<<7 | 0x29,
	25972 - 19968: jis0208<<14 | 0x1F<<7 | 0x0F,
	25973 - 19968: jis0208<<14 | 0x24<<7 | 0x07,
	25975 - 19968: jis0208<<14 | 0x28<<7 | 0x3E,
	25976 - 19968: jis0208<<14 | 0x39<<7 | 0x2A,
	25978 - 19968: jis0212<<14 | 0x20<<7 | 0x33,
	25981 - 19968: jis0212<<14 | 0x20<<7 | 0x34,
	25985 - 19968: jis0212<<14 | 0x20<<7 | 0x35,
	25986 - 19968: jis0208<<14 | 0x39<<7 | 0x2B,
	25987 - 19968: jis0208<<14 | 0x39<<7 | 0x2C,
	25989 - 19968: jis0212<<14 | 0x20<<7 | 0x36,
	25991 - 19968: jis0208<<14 | 0x29<<7 | 0x17,
	25992 - 19968: jis0208<<14 | 0x34<<7 | 0x3C,
	25993 - 19968: jis0208<<14 | 0x1F<<7 | 0x25,
	25994 - 19968: jis0212<<14 | 0x20<<7 | 0x37,
	25996 - 19968: jis0208<<14 | 0x28<<7 | 0x2B,
	25998 - 19968: jis0208<<14 | 0x19<<7 | 0x37,
	26000 - 19968: jis0208<<14 | 0x27<<7 | 0x44,
	26001 - 19968: jis0208<<14 | 0x27<<7 | 0x22,
	26002 - 19968: jis0212<<14 | 0x20<<7 | 0x38,
	26005 - 19968: jis0212<<14 | 0x20<<7 | 0x39,
	26007 - 19968: jis0208<<14 | 0x24<<7 | 0x2C,
	26008 - 19968: jis0212<<14 | 0x20<<7 | 0x3A,
	26009 - 19968: jis0208<<14 | 0x2D<<7 | 0x20,
	26011 - 19968: jis0208<<14 | 0x39<<7 | 0x2E,
	26012 - 19968: jis0208<<14 | 0x1B<<7 | 0x2F,
	26013 - 19968: jis0212<<14 | 0x20<<7 | 0x3B,
	26015 - 19968: jis0208<<14 | 0x39<<7 | 0x2F,
	26016 - 19968: jis0212<<14 | 0x20<<7 | 0x3C,
	26017 - 19968: jis0208<<14 | 0x0F<<7 | 0x15,
	26019 - 19968: jis0212<<14 | 0x20<<7 | 0x3D,
	26020 - 19968: jis0208<<14 | 0x15<<7 | 0x33,
	26021 - 19968: jis0208<<14 | 0x1F<<7 | 0x2C,
	26022 - 19968: jis0212<<14 | 0x20<<7 | 0x3E,
	26023 - 19968: jis0208<<14 | 0x28<<7 | 0x3F,
	26027 - 19968: jis0208<<14 | 0x39<<7 | 0x30,
	26028 - 19968: jis0208<<14 | 0x1A<<7 | 0x21,
	26029 - 19968: jis0208<<14 | 0x22<<7 | 0x26,
	26030 - 19968: jis0212<<14 | 0x20<<7 | 0x3F,
	26031 - 19968: jis0208<<14 | 0x1A<<7 | 0x3A,
	26032 - 19968: jis0208<<14 | 0x1E<<7 | 0x16,
	26034 - 19968: jis0212<<14 | 0x20<<7 | 0x40,
	26035 - 19968: jis0212<<14 | 0x20<<7 | 0x41,
	26036 - 19968: jis0212<<14 | 0x20<<7 | 0x42,
	26039 - 19968: jis0208<<14 | 0x39<<7 | 0x31,
	26041 - 19968: jis0208<<14 | 0x29<<7 | 0x5C,
	26044 - 19968: jis0208<<14 | 0x10<<7 | 0x56,
	26045 - 19968: jis0208<<14 | 0x1A<<7 | 0x3B,
	26047 - 19968: jis0212<<14 | 0x20<<7 | 0x43,
	26049 - 19968: jis0208<<14 | 0x39<<7 | 0x34,
	26050 - 19968: jis0212<<14 | 0x20<<7 | 0x44,
	26051 - 19968: jis0208<<14 | 0x39<<7 | 0x32,
	26052 - 19968: jis0208<<14 | 0x39<<7 | 0x35,
	26053 - 19968: jis0208<<14 | 0x2D<<7 | 0x18,
	26054 - 19968: jis0208<<14 | 0x39<<7 | 0x33,
	26056 - 19968: jis0212<<14 | 0x20<<7 | 0x45,
	26057 - 19968: jis0212<<14 | 0x20<<7 | 0x46,
	26059 - 19968: jis0208<<14 | 0x1F<<7 | 0x5A,
	26060 - 19968: jis0208<<14 | 0x39<<7 | 0x36,
	26062 - 19968: jis0212<<14 | 0x20<<7 | 0x47,
	26063 - 19968: jis0208<<14 | 0x21<<7 | 0x11,
	26064 - 19968: jis0212<<14 | 0x20<<7 | 0x48,
	26066 - 19968: jis0208<<14 | 0x39<<7 | 0x37,
	26068 - 19968: jis0212<<14 | 0x20<<7 | 0x49,
	26070 - 19968: jis0212<<14 | 0x20<<7 | 0x4A,
	26071 - 19968: jis0208<<14 | 0x13<<7 | 0x59,
	26072 - 19968: jis0212<<14 | 0x20<<7 | 0x4B,
	26073 - 19968: jis0208<<14 | 0x39<<7 | 0x39,
	26075 - 19968: jis0208<<14 | 0x39<<7 | 0x38,
	26079 - 19968: jis0212<<14 | 0x20<<7 | 0x4C,
	26080 - 19968: jis0208<<14 | 0x39<<7 | 0x3A,
	26081 - 19968: jis0208<<14 | 0x39<<7 | 0x3B,
	26082 - 19968: jis0208<<14 | 0x13<<7 | 0x5A,
	26085 - 19968: jis0208<<14 | 0x25<<7 | 0x5B,
	26086 - 19968: jis0208<<14 | 0x22<<7 | 0x15,
	26087 - 19968: jis0208<<14 | 0x14<<7 | 0x4B,
	26088 - 19968: jis0208<<14 | 0x1A<<7 | 0x3C,
	26089 - 19968: jis0208<<14 | 0x20<<7 | 0x40,
	26092 - 19968: jis0208<<14 | 0x1C<<7 | 0x3B,
	26093 - 19968: jis0208<<14 | 0x0F<<7 | 0x0F,
	26096 - 19968: jis0212<<14 | 0x20<<7 | 0x4D,
	26097 - 19968: jis0208<<14 | 0x39<<7 | 0x3C,
	26098 - 19968: jis0212<<14 | 0x20<<7 | 0x4E,
	26100 - 19968: jis0212<<14 | 0x20<<7 | 0x4F,
	26101 - 19968: jis0212<<14 | 0x20<<7 | 0x50,
	26105 - 19968: jis0212<<14 | 0x20<<7 | 0x51,
	26106 - 19968: jis0208<<14 | 0x11<<7 | 0x01,
	26107 - 19968: jis0208<<14 | 0x39<<7 | 0x40,
	26110 - 19968: jis0212<<14 | 0x20<<7 | 0x52,
	26111 - 19968: jis0212<<14 | 0x20<<7 | 0x53,
	26112 - 19968: jis0208<<14 | 0x59<<7 | 0x13,
	26114 - 19968: jis0208<<14 | 0x18<<7 | 0x16,
	26115 - 19968: jis0208<<14 | 0x39<<7 | 0x3F,
	26116 - 19968: jis0212<<14 | 0x20<<7 | 0x55,
	26118 - 19968: jis0208<<14 | 0x19<<7 | 0x0A,
	26119 - 19968: jis0208<<14 | 0x1D<<7 | 0x19,
	26120 - 19968: jis0212<<14 | 0x20<<7 | 0x56,
	26121 - 19968: jis0208<<14 | 0x59<<7 | 0x16,
	26122 - 19968: jis0208<<14 | 0x39<<7 | 0x3E,
	26124 - 19968: jis0208<<14 | 0x1D<<7 | 0x1A,
	26125 - 19968: jis0212<<14 | 0x20<<7 | 0x58,
	26126 - 19968: jis0208<<14 | 0x2B<<7 | 0x1F,
	26127 - 19968: jis0208<<14 | 0x19<<7 | 0x09,
	26129 - 19968: jis0212<<14 | 0x20<<7 | 0x59,
	26130 - 19968: jis0212<<14 | 0x20<<7 | 0x5A,
	26131 - 19968: jis0208<<14 | 0x0F<<7 | 0x36,
	26132 - 19968: jis0208<<14 | 0x1F<<7 | 0x2D,
	26133 - 19968: jis0208<<14 | 0x59<<7 | 0x14,
	26134 - 19968: jis0212<<14 | 0x20<<7 | 0x5C,
	26140 - 19968: jis0208<<14 | 0x39<<7 | 0x45,
	26141 - 19968: jis0212<<14 | 0x20<<7 | 0x5D,
	26142 - 19968: jis0208<<14 | 0x59<<7 | 0x18,
	26143 - 19968: jis0208<<14 | 0x1F<<7 | 0x10,
	26144 - 19968: jis0208<<14 | 0x10<<7 | 0x26,
	26145 - 19968: jis0212<<14 | 0x21<<7 | 0x01,
	26146 - 19968: jis0212<<14 | 0x21<<7 | 0x02,
	26147 - 19968: jis0212<<14 | 0x21<<7 | 0x03,
	26148 - 19968: jis0208<<14 | 0x59<<7 | 0x19,
	26149 - 19968: jis0208<<14 | 0x1C<<7 | 0x34,
	26150 - 19968: jis0212<<14 | 0x21<<7 | 0x05,
	26151 - 19968: jis0208<<14 | 0x2A<<7 | 0x45,
	26152 - 19968: jis0208<<14 | 0x19<<7 | 0x51,
	26153 - 19968: jis0212<<14 | 0x21<<7 | 0x06,
	26154 - 19968: jis0212<<14 | 0x21<<7 | 0x07,
	26155 - 19968: jis0212<<14 | 0x21<<7 | 0x08,
	26156 - 19968: jis0212<<14 | 0x21<<7 | 0x09,
	26157 - 19968: jis0208<<14 | 0x1D<<7 | 0x1B,
	26158 - 19968: jis0208<<14 | 0x59<<7 | 0x17,
	26159 - 19968: jis0208<<14 | 0x1F<<7 | 0x06,
	26160 - 19968: jis0212<<14 | 0x21<<7 | 0x0B,
	26161 - 19968: jis0208<<14 | 0x58<<7 | 0x07,
	26163 - 19968: jis0212<<14 | 0x21<<7 | 0x0D,
	26164 - 19968: jis0208<<14 | 0x39<<7 | 0x44,
	26165 - 19968: jis0208<<14 | 0x39<<7 | 0x42,
	26166 - 19968: jis0208<<14 | 0x39<<7 | 0x43,
	26167 - 19968: jis0212<<14 | 0x21<<7 | 0x0F,
	26169 - 19968: jis0212<<14 | 0x21<<7 | 0x0E,
	26171 - 19968: jis0208<<14 | 0x59<<7 | 0x15,
	26172 - 19968: jis0208<<14 | 0x22<<7 | 0x4A,
	26175 - 19968: jis0208<<14 | 0x3A<<7 | 0x05,
	26176 - 19968: jis0212<<14 | 0x21<<7 | 0x10,
	26177 - 19968: jis0208<<14 | 0x39<<7 | 0x49,
	26178 - 19968: jis0208<<14 | 0x1A<<7 | 0x5D,
	26179 - 19968: jis0208<<14 | 0x18<<7 | 0x17,
	26180 - 19968: jis0208<<14 | 0x39<<7 | 0x47,
	26181 - 19968: jis0212<<14 | 0x21<<7 | 0x11,
	26182 - 19968: jis0212<<14 | 0x21<<7 | 0x12,
	26185 - 19968: jis0208<<14 | 0x39<<7 | 0x48,
	26186 - 19968: jis0212<<14 | 0x21<<7 | 0x13,
	26187 - 19968: jis0208<<14 | 0x1E<<7 | 0x17,
	26188 - 19968: jis0212<<14 | 0x21<<7 | 0x14,
	26190 - 19968: jis0212<<14 | 0x21<<7 | 0x16,
	26191 - 19968: jis0208<<14 | 0x39<<7 | 0x46,
	26193 - 19968: jis0212<<14 | 0x21<<7 | 0x15,
	26194 - 19968: jis0208<<14 | 0x1A<<7 | 0x0E,
	26199 - 19968: jis0208<<14 | 0x59<<7 | 0x1B,
	26200 - 19968: jis0212<<14 | 0x21<<7 | 0x18,
	26201 - 19968: jis0208<<14 | 0x59<<7 | 0x1C,
	26203 - 19968: jis0212<<14 | 0x21<<7 | 0x1A,
	26204 - 19968: jis0212<<14 | 0x21<<7 | 0x1B,
	26205 - 19968: jis0208<<14 | 0x39<<7 | 0x4B,
	26206 - 19968: jis0208<<14 | 0x39<<7 | 0x4A,
	26207 - 19968: jis0208<<14 | 0x39<<7 | 0x4F,
	26208 - 19968: jis0212<<14 | 0x21<<7 | 0x1C,
	26209 - 19968: jis0212<<14 | 0x21<<7 | 0x1D,
	26210 - 19968: jis0208<<14 | 0x39<<7 | 0x50,
	26212 - 19968: jis0208<<14 | 0x39<<7 | 0x4C,
	26213 - 19968: jis0208<<14 | 0x59<<7 | 0x1A,
	26214 - 19968: jis0208<<14 | 0x12<<7 | 0x01,
	26215 - 19968: jis0208<<14 | 0x39<<7 | 0x4D,
	26216 - 19968: jis0208<<14 | 0x39<<7 | 0x4E,
	26217 - 19968: jis0208<<14 | 0x27<<7 | 0x34,
	26218 - 19968: jis0212<<14 | 0x21<<7 | 0x1F,
	26219 - 19968: jis0212<<14 | 0x21<<7 | 0x20,
	26220 - 19968: jis0212<<14 | 0x21<<7 | 0x21,
	26222 - 19968: jis0208<<14 | 0x28<<7 | 0x40,
	26223 - 19968: jis0208<<14 | 0x16<<7 | 0x29,
	26224 - 19968: jis0208<<14 | 0x39<<7 | 0x51,
	26227 - 19968: jis0208<<14 | 0x59<<7 | 0x1E,
	26228 - 19968: jis0208<<14 | 0x1F<<7 | 0x11,
	26229 - 19968: jis0212<<14 | 0x21<<7 | 0x24,
	26230 - 19968: jis0208<<14 | 0x1D<<7 | 0x1C,
	26231 - 19968: jis0212<<14 | 0x21<<7 | 0x26,
	26232 - 19968: jis0212<<14 | 0x21<<7 | 0x27,
	26233 - 19968: jis0212<<14 | 0x21<<7 | 0x28,
	26234 - 19968: jis0208<<14 | 0x22<<7 | 0x31,
	26235 - 19968: jis0212<<14 | 0x21<<7 | 0x29,
	26236 - 19968: jis0212<<14 | 0x21<<7 | 0x2B,
	26238 - 19968: jis0212<<14 | 0x21<<7 | 0x22,
	26239 - 19968: jis0212<<14 | 0x21<<7 | 0x25,
	26240 - 19968: jis0212<<14 | 0x21<<7 | 0x2A,
	26241 - 19968: jis0208<<14 | 0x15<<7 | 0x26,
	26243 - 19968: jis0208<<14 | 0x39<<7 | 0x52,
	26244 - 19968: jis0208<<14 | 0x39<<7 | 0x56,
	26247 - 19968: jis0208<<14 | 0x11<<7 | 0x2A,
	26248 - 19968: jis0208<<14 | 0x39<<7 | 0x53,
	26249 - 19968: jis0208<<14 | 0x39<<7 | 0x55,
	26251 - 19968: jis0212<<14 | 0x21<<7 | 0x2C,
	26252 - 19968: jis0212<<14 | 0x21<<7 | 0x2D,
	26253 - 19968: jis0212<<14 | 0x21<<7 | 0x2E,
	26254 - 19968: jis0208<<14 | 0x39<<7 | 0x54,
	26256 - 19968: jis0212<<14 | 0x21<<7 | 0x2F,
	26257 - 19968: jis0208<<14 | 0x1C<<7 | 0x4A,
	26258 - 19968: jis0212<<14 | 0x21<<7 | 0x30,
	26262 - 19968: jis0208<<14 | 0x22<<7 | 0x27,
	26263 - 19968: jis0208<<14 | 0x0F<<7 | 0x24,
	26264 - 19968: jis0208<<14 | 0x39<<7 | 0x57,
	26265 - 19968: jis0208<<14 | 0x59<<7 | 0x1F,
	26266 - 19968: jis0212<<14 | 0x21<<7 | 0x32,
	26267 - 19968: jis0212<<14 | 0x21<<7 | 0x33,
	26268 - 19968: jis0212<<14 | 0x21<<7 | 0x34,
	26269 - 19968: jis0208<<14 | 0x39<<7 | 0x58,
	26271 - 19968: jis0212<<14 | 0x21<<7 | 0x35,
	26272 - 19968: jis0208<<14 | 0x59<<7 | 0x20,
	26274 - 19968: jis0208<<14 | 0x23<<7 | 0x09,
	26276 - 19968: jis0212<<14 | 0x21<<7 | 0x37,
	26278 - 19968: jis0208<<14 | 0x2D<<7 | 0x50,
	26283 - 19968: jis0208<<14 | 0x1A<<7 | 0x22,
	26285 - 19968: jis0212<<14 | 0x21<<7 | 0x38,
	26286 - 19968: jis0208<<14 | 0x29<<7 | 0x4A,
	26289 - 19968: jis0212<<14 | 0x21<<7 | 0x39,
	26290 - 19968: jis0208<<14 | 0x59<<7 | 0x21,
	26292 - 19968: jis0208<<14 | 0x2A<<7 | 0x1C,
	26293 - 19968: jis0212<<14 | 0x21<<7 | 0x3B,
	26296 - 19968: jis0208<<14 | 0x3A<<7 | 0x01,
	26297 - 19968: jis0208<<14 | 0x39<<7 | 0x5A,
	26299 - 19968: jis0212<<14 | 0x21<<7 | 0x3C,
	26300 - 19968: jis0208<<14 | 0x39<<7 | 0x5D,
	26302 - 19968: jis0208<<14 | 0x39<<7 | 0x5C,
	26303 - 19968: jis0208<<14 | 0x59<<7 | 0x22,
	26304 - 19968: jis0212<<14 | 0x21<<7 | 0x3E,
	26305 - 19968: jis0208<<14 | 0x39<<7 | 0x59,
	26306 - 19968: jis0212<<14 | 0x21<<7 | 0x3F,
	26307 - 19968: jis0212<<14 | 0x21<<7 | 0x40,
	26308 - 19968: jis0208<<14 | 0x3A<<7 | 0x00,
	26311 - 19968: jis0208<<14 | 0x25<<7 | 0x3D,
	26312 - 19968: jis0212<<14 | 0x21<<7 | 0x41,
	26313 - 19968: jis0208<<14 | 0x39<<7 | 0x5B,
	26316 - 19968: jis0212<<14 | 0x21<<7 | 0x42,
	26318 - 19968: jis0212<<14 | 0x21<<7 | 0x43,
	26319 - 19968: jis0212<<14 | 0x21<<7 | 0x44,
	26324 - 19968: jis0212<<14 | 0x21<<7 | 0x45,
	26326 - 19968: jis0208<<14 | 0x3A<<7 | 0x02,
	26329 - 19968: jis0208<<14 | 0x1C<<7 | 0x4B,
	26330 - 19968: jis0208<<14 | 0x3A<<7 | 0x03,
	26331 - 19968: jis0212<<14 | 0x21<<7 | 0x46,
	26332 - 19968: jis0208<<14 | 0x2C<<7 | 0x2A,
	26333 - 19968: jis0208<<14 | 0x26<<7 | 0x57,
	26335 - 19968: jis0212<<14 | 0x21<<7 | 0x47,
	26336 - 19968: jis0208<<14 | 0x3A<<7 | 0x04,
	26342 - 19968: jis0208<<14 | 0x3A<<7 | 0x06,
	26344 - 19968: jis0212<<14 | 0x21<<7 | 0x48,
	26345 - 19968: jis0208<<14 | 0x3A<<7 | 0x07,
	26347 - 19968: jis0212<<14 | 0x21<<7 | 0x49,
	26348 - 19968: jis0212<<14 | 0x21<<7 | 0x4A,
	26350 - 19968: jis0212<<14 | 0x21<<7 | 0x4B,
	26352 - 19968: jis0208<<14 | 0x3A<<7 | 0x08,
	26354 - 19968: jis0208<<14 | 0x15<<7 | 0x29,
	26355 - 19968: jis0208<<14 | 0x10<<7 | 0x27,
	26356 - 19968: jis0208<<14 | 0x18<<7 | 0x18,
	26357 - 19968: jis0208<<14 | 0x3A<<7 | 0x09,
	26359 - 19968: jis0208<<14 | 0x3A<<7 | 0x0A,
	26360 - 19968: jis0208<<14 | 0x1C<<7 | 0x50,
	26361 - 19968: jis0208<<14 | 0x20<<7 | 0x41,
	26362 - 19968: jis0208<<14 | 0x59<<7 | 0x23,
	26363 - 19968: jis0208<<14 | 0x58<<7 | 0x0A,
	26364 - 19968: jis0208<<14 | 0x31<<7 | 0x37,
	26365 - 19968: jis0208<<14 | 0x20<<7 | 0x1D,
	26366 - 19968: jis0208<<14 | 0x20<<7 | 0x1C,
	26367 - 19968: jis0208<<14 | 0x21<<7 | 0x37,
	26368 - 19968: jis0208<<14 | 0x19<<7 | 0x26,
	26371 - 19968: jis0208<<14 | 0x2F<<7 | 0x51,
	26373 - 19968: jis0212<<14 | 0x21<<7 | 0x4D,
	26375 - 19968: jis0212<<14 | 0x21<<7 | 0x4E,
	26376 - 19968: jis0208<<14 | 0x16<<7 | 0x4D,
	26377 - 19968: jis0208<<14 | 0x2C<<7 | 0x0C,
	26379 - 19968: jis0208<<14 | 0x29<<7 | 0x5D,
	26381 - 19968: jis0208<<14 | 0x28<<7 | 0x5D,
	26382 - 19968: jis0208<<14 | 0x59<<7 | 0x24,
	26383 - 19968: jis0208<<14 | 0x3A<<7 | 0x0B,
	26387 - 19968: jis0212<<14 | 0x21<<7 | 0x50,
	26388 - 19968: jis0208<<14 | 0x19<<7 | 0x52,
	26389 - 19968: jis0208<<14 | 0x23<<7 | 0x1E,
	26390 - 19968: jis0208<<14 | 0x3A<<7 | 0x0C,
	26391 - 19968: jis0208<<14 | 0x2E<<7 | 0x0E,
	26393 - 19968: jis0212<<14 | 0x21<<7 | 0x51,
	26395 - 19968: jis0208<<14 | 0x2A<<7 | 0x1D,
	26396 - 19968: jis0212<<14 | 0x21<<7 | 0x52,
	26397 - 19968: jis0208<<14 | 0x23<<7 | 0x0A,
	26398 - 19968: jis0208<<14 | 0x3A<<7 | 0x0D,
	26399 - 19968: jis0208<<14 | 0x13<<7 | 0x5B,
	26400 - 19968: jis0212<<14 | 0x21<<7 | 0x53,
	26402 - 19968: jis0212<<14 | 0x21<<7 | 0x54,
	26406 - 19968: jis0208<<14 | 0x3A<<7 | 0x0E,
	26407 - 19968: jis0208<<14 | 0x3A<<7 | 0x0F,
	26408 - 19968: jis0208<<14 | 0x2B<<7 | 0x39,
	26410 - 19968: jis0208<<14 | 0x2B<<7 | 0x03,
	26411 - 19968: jis0208<<14 | 0x2A<<7 | 0x55,
	26412 - 19968: jis0208<<14 | 0x2A<<7 | 0x3B,
	26413 - 19968: jis0208<<14 | 0x1A<<7 | 0x04,
	26414 - 19968: jis0208<<14 | 0x3A<<7 | 0x11,
	26417 - 19968: jis0208<<14 | 0x1B<<7 | 0x4A,
	26419 - 19968: jis0212<<14 | 0x21<<7 | 0x55,
	26420 - 19968: jis0208<<14 | 0x2A<<7 | 0x30,
	26422 - 19968: jis0208<<14 | 0x3A<<7 | 0x13,
	26423 - 19968: jis0208<<14 | 0x3A<<7 | 0x16,
	26424 - 19968: jis0208<<14 | 0x3A<<7 | 0x15,
	26426 - 19968: jis0208<<14 | 0x13<<7 | 0x58,
	26429 - 19968: jis0208<<14 | 0x14<<7 | 0x3F,
	26430 - 19968: jis0212<<14 | 0x21<<7 | 0x56,
	26431 - 19968: jis0208<<14 | 0x3A<<7 | 0x12,
	26433 - 19968: jis0208<<14 | 0x3A<<7 | 0x14,
	26437 - 19968: jis0212<<14 | 0x21<<7 | 0x57,
	26438 - 19968: jis0208<<14 | 0x3A<<7 | 0x17,
	26439 - 19968: jis0212<<14 | 0x21<<7 | 0x58,
	26440 - 19968: jis0212<<14 | 0x21<<7 | 0x59,
	26441 - 19968: jis0208<<14 | 0x1E<<7 | 0x58,
	26444 - 19968: jis0212<<14 | 0x21<<7 | 0x5A,
	26446 - 19968: jis0208<<14 | 0x2C<<7 | 0x5A,
	26447 - 19968: jis0208<<14 | 0x0F<<7 | 0x28,
	26448 - 19968: jis0208<<14 | 0x19<<7 | 0x3F,
	26449 - 19968: jis0208<<14 | 0x21<<7 | 0x1B,
	26451 - 19968: jis0208<<14 | 0x1B<<7 | 0x3C,
	26452 - 19968: jis0212<<14 | 0x21<<7 | 0x5B,
	26453 - 19968: jis0212<<14 | 0x21<<7 | 0x5C,
	26454 - 19968: jis0208<<14 | 0x1D<<7 | 0x52,
	26457 - 19968: jis0208<<14 | 0x3A<<7 | 0x1A,
	26460 - 19968: jis0208<<14 | 0x24<<7 | 0x2D,
	26461 - 19968: jis0212<<14 | 0x21<<7 | 0x5D,
	26462 - 19968: jis0208<<14 | 0x3A<<7 | 0x18,
	26463 - 19968: jis0208<<14 | 0x21<<7 | 0x0A,
	26464 - 19968: jis0208<<14 | 0x3A<<7 | 0x19,
	26465 - 19968: jis0208<<14 | 0x1D<<7 | 0x51,
	26466 - 19968: jis0208<<14 | 0x2B<<7 | 0x3C,
	26467 - 19968: jis0208<<14 | 0x3A<<7 | 0x1B,
	26468 - 19968: jis0208<<14 | 0x3A<<7 | 0x1C,
	26469 - 19968: jis0208<<14 | 0x2C<<7 | 0x47,
	26470 - 19968: jis0208<<14 | 0x59<<7 | 0x26,
	26474 - 19968: jis0208<<14 | 0x3A<<7 | 0x21,
	26476 - 19968: jis0212<<14 | 0x22<<7 | 0x01,
	26477 - 19968: jis0208<<14 | 0x18<<7 | 0x19,
	26478 - 19968: jis0212<<14 | 0x22<<7 | 0x02,
	26479 - 19968: jis0208<<14 | 0x26<<7 | 0x34,
	26480 - 19968: jis0208<<14 | 0x3A<<7 | 0x1E,
	26481 - 19968: jis0208<<14 | 0x24<<7 | 0x4B,
	26482 - 19968: jis0208<<14 | 0x39<<7 | 0x3D,
	26483 - 19968: jis0208<<14 | 0x39<<7 | 0x41,
	26484 - 19968: jis0212<<14 | 0x22<<7 | 0x03,
	26485 - 19968: jis0208<<14 | 0x14<<7 | 0x2E,
	26486 - 19968: jis0212<<14 | 0x22<<7 | 0x04,
	26487 - 19968: jis0208<<14 | 0x26<<7 | 0x26,
	26491 - 19968: jis0212<<14 | 0x22<<7 | 0x05,
	26492 - 19968: jis0208<<14 | 0x3A<<7 | 0x20,
	26494 - 19968: jis0208<<14 | 0x1D<<7 | 0x1D,
	26495 - 19968: jis0208<<14 | 0x27<<7 | 0x23,
	26497 - 19968: jis0212<<14 | 0x22<<7 | 0x06,
	26500 - 19968: jis0212<<14 | 0x22<<7 | 0x07,
	26501 - 19968: jis0208<<14 | 0x3A<<7 | 0x26,
	26503 - 19968: jis0208<<14 | 0x27<<7 | 0x59,
	26505 - 19968: jis0208<<14 | 0x3A<<7 | 0x1D,
	26507 - 19968: jis0208<<14 | 0x3A<<7 | 0x23,
	26508 - 19968: jis0208<<14 | 0x3A<<7 | 0x22,
	26510 - 19968: jis0212<<14 | 0x22<<7 | 0x08,
	26511 - 19968: jis0212<<14 | 0x22<<7 | 0x09,
	26512 - 19968: jis0208<<14 | 0x1F<<7 | 0x2E,
	26513 - 19968: jis0212<<14 | 0x22<<7 | 0x0A,
	26515 - 19968: jis0212<<14 | 0x22<<7 | 0x0B,
	26517 - 19968: jis0208<<14 | 0x2A<<7 | 0x4C,
	26518 - 19968: jis0212<<14 | 0x22<<7 | 0x0C,
	26519 - 19968: jis0208<<14 | 0x2D<<7 | 0x32,
	26520 - 19968: jis0212<<14 | 0x22<<7 | 0x0D,
	26521 - 19968: jis0212<<14 | 0x22<<7 | 0x0E,
	26522 - 19968: jis0208<<14 | 0x2A<<7 | 0x46,
	26523 - 19968: jis0212<<14 | 0x22<<7 | 0x0F,
	26524 - 19968: jis0208<<14 | 0x11<<7 | 0x2B,
	26525 - 19968: jis0208<<14 | 0x1A<<7 | 0x3D,
	26528 - 19968: jis0208<<14 | 0x2E<<7 | 0x27,
	26529 - 19968: jis0208<<14 | 0x3A<<7 | 0x25,
	26530 - 19968: jis0208<<14 | 0x1E<<7 | 0x54,
	26534 - 19968: jis0208<<14 | 0x3A<<7 | 0x24,
	26537 - 19968: jis0208<<14 | 0x3A<<7 | 0x1F,
	26543 - 19968: jis0208<<14 | 0x17<<7 | 0x2E,
	26544 - 19968: jis0212<<14 | 0x22<<7 | 0x10,
	26545 - 19968: jis0212<<14 | 0x22<<7 | 0x11,
	26546 - 19968: jis0212<<14 | 0x22<<7 | 0x12,
	26547 - 19968: jis0208<<14 | 0x3A<<7 | 0x2B,
	26548 - 19968: jis0208<<14 | 0x3A<<7 | 0x29,
	26549 - 19968: jis0212<<14 | 0x22<<7 | 0x13,
	26550 - 19968: jis0208<<14 | 0x11<<7 | 0x2C,
	26551 - 19968: jis0208<<14 | 0x3A<<7 | 0x27,
	26552 - 19968: jis0208<<14 | 0x3A<<7 | 0x2D,
	26553 - 19968: jis0208<<14 | 0x3A<<7 | 0x33,
	26555 - 19968: jis0208<<14 | 0x59<<7 | 0x27,
	26556 - 19968: jis0212<<14 | 0x22<<7 | 0x15,
	26557 - 19968: jis0212<<14 | 0x22<<7 | 0x16,
	26560 - 19968: jis0208<<14 | 0x59<<7 | 0x29,
	26561 - 19968: jis0208<<14 | 0x21<<7 | 0x27,
	26562 - 19968: jis0212<<14 | 0x22<<7 | 0x19,
	26563 - 19968: jis0212<<14 | 0x22<<7 | 0x1A,
	26564 - 19968: jis0208<<14 | 0x29<<7 | 0x20,
	26565 - 19968: jis0212<<14 | 0x22<<7 | 0x1B,
	26566 - 19968: jis0208<<14 | 0x3A<<7 | 0x35,
	26568 - 19968: jis0212<<14 | 0x22<<7 | 0x1C,
	26569 - 19968: jis0212<<14 | 0x22<<7 | 0x1D,
	26570 - 19968: jis0208<<14 | 0x28<<7 | 0x01,
	26574 - 19968: jis0208<<14 | 0x3A<<7 | 0x34,
	26575 - 19968: jis0208<<14 | 0x26<<7 | 0x4F,
	26576 - 19968: jis0208<<14 | 0x2A<<7 | 0x1E,
	26577 - 19968: jis0208<<14 | 0x13<<7 | 0x1A,
	26578 - 19968: jis0212<<14 | 0x22<<7 | 0x1E,
	26579 - 19968: jis0208<<14 | 0x1F<<7 | 0x56,
	26580 - 19968: jis0208<<14 | 0x1C<<7 | 0x1F,
	26583 - 19968: jis0212<<14 | 0x22<<7 | 0x1F,
	26584 - 19968: jis0208<<14 | 0x23<<7 | 0x32,
	26585 - 19968: jis0212<<14 | 0x22<<7 | 0x20,
	26586 - 19968: jis0208<<14 | 0x2C<<7 | 0x0D,
	26588 - 19968: jis0212<<14 | 0x22<<7 | 0x21,
	26589 - 19968: jis0208<<14 | 0x3A<<7 | 0x30,
	26590 - 19968: jis0208<<14 | 0x3A<<7 | 0x2F,
	26593 - 19968: jis0212<<14 | 0x22<<7 | 0x22,
	26594 - 19968: jis0208<<14 | 0x3A<<7 | 0x31,
	26596 - 19968: jis0208<<14 | 0x3A<<7 | 0x2E,
	26598 - 19968: jis0212<<14 | 0x22<<7 | 0x23,
	26599 - 19968: jis0208<<14 | 0x3A<<7 | 0x36,
	26601 - 19968: jis0208<<14 | 0x3A<<7 | 0x2C,
	26604 - 19968: jis0208<<14 | 0x3A<<7 | 0x2A,
	26606 - 19968: jis0208<<14 | 0x3A<<7 | 0x32,
	26607 - 19968: jis0208<<14 | 0x3A<<7 | 0x28,
	26608 - 19968: jis0212<<14 | 0x22<<7 | 0x24,
	26609 - 19968: jis0208<<14 | 0x22<<7 | 0x4B,
	26610 - 19968: jis0212<<14 | 0x22<<7 | 0x25,
	26611 - 19968: jis0208<<14 | 0x2B<<7 | 0x57,
	26612 - 19968: jis0208<<14 | 0x1B<<7 | 0x25,
	26613 - 19968: jis0208<<14 | 0x19<<7 | 0x53,
	26614 - 19968: jis0212<<14 | 0x22<<7 | 0x26,
	26615 - 19968: jis0212<<14 | 0x22<<7 | 0x27,
	26617 - 19968: jis0212<<14 | 0x22<<7 | 0x17,
	26619 - 19968: jis0208<<14 | 0x19<<7 | 0x19,
	26622 - 19968: jis0208<<14 | 0x2A<<7 | 0x4E,
	26623 - 19968: jis0208<<14 | 0x12<<7 | 0x20,
	26625 - 19968: jis0208<<14 | 0x59<<7 | 0x2A,
	26626 - 19968: jis0208<<14 | 0x23<<7 | 0x2D,
	26627 - 19968: jis0208<<14 | 0x25<<7 | 0x29,
	26628 - 19968: jis0208<<14 | 0x10<<7 | 0x28,
	26643 - 19968: jis0208<<14 | 0x1F<<7 | 0x51,
	26644 - 19968: jis0212<<14 | 0x22<<7 | 0x29,
	26646 - 19968: jis0208<<14 | 0x1F<<7 | 0x13,
	26647 - 19968: jis0208<<14 | 0x16<<7 | 0x09,
	26649 - 19968: jis0212<<14 | 0x22<<7 | 0x2A,
	26653 - 19968: jis0212<<14 | 0x22<<7 | 0x2B,
	26654 - 19968: jis0208<<14 | 0x3A<<7 | 0x38,
	26655 - 19968: jis0212<<14 | 0x22<<7 | 0x2C,
	26657 - 19968: jis0208<<14 | 0x18<<7 | 0x1A,
	26658 - 19968: jis0208<<14 | 0x12<<7 | 0x5B,
	26663 - 19968: jis0212<<14 | 0x22<<7 | 0x2E,
	26664 - 19968: jis0212<<14 | 0x22<<7 | 0x2D,
	26665 - 19968: jis0208<<14 | 0x3A<<7 | 0x3A,
	26666 - 19968: jis0208<<14 | 0x12<<7 | 0x53,
	26667 - 19968: jis0208<<14 | 0x3A<<7 | 0x40,
	26668 - 19968: jis0212<<14 | 0x22<<7 | 0x2F,
	26669 - 19968: jis0212<<14 | 0x22<<7 | 0x30,
	26671 - 19968: jis0212<<14 | 0x22<<7 | 0x31,
	26672 - 19968: jis0212<<14 | 0x22<<7 | 0x32,
	26673 - 19968: jis0212<<14 | 0x22<<7 | 0x33,
	26674 - 19968: jis0208<<14 | 0x3A<<7 | 0x3D,
	26675 - 19968: jis0212<<14 | 0x22<<7 | 0x34,
	26676 - 19968: jis0208<<14 | 0x1F<<7 | 0x52,
	26680 - 19968: jis0208<<14 | 0x12<<7 | 0x2A,
	26681 - 19968: jis0208<<14 | 0x19<<7 | 0x0B,
	26683 - 19968: jis0212<<14 | 0x22<<7 | 0x35,
	26684 - 19968: jis0208<<14 | 0x12<<7 | 0x29,
	26685 - 19968: jis0208<<14 | 0x19<<7 | 0x2E,
	26687 - 19968: jis0212<<14 | 0x22<<7 | 0x36,
	26688 - 19968: jis0208<<14 | 0x3A<<7 | 0x3B,
	26689 - 19968: jis0208<<14 | 0x16<<7 | 0x44,
	26690 - 19968: jis0208<<14 | 0x16<<7 | 0x2A,
	26691 - 19968: jis0208<<14 | 0x24<<7 | 0x4C,
	26692 - 19968: jis0208<<14 | 0x59<<7 | 0x2B,
	26693 - 19968: jis0212<<14 | 0x22<<7 | 0x38,
	26694 - 19968: jis0208<<14 | 0x3A<<7 | 0x39,
	26696 - 19968: jis0208<<14 | 0x0F<<7 | 0x25,
	26698 - 19968: jis0212<<14 | 0x22<<7 | 0x39,
	26700 - 19968: jis0212<<14 | 0x22<<7 | 0x3A,
	26701 - 19968: jis0208<<14 | 0x3A<<7 | 0x3C,
	26702 - 19968: jis0208<<14 | 0x3A<<7 | 0x3E,
	26704 - 19968: jis0208<<14 | 0x15<<7 | 0x2C,
	26705 - 19968: jis0208<<14 | 0x16<<7 | 0x0B,
	26706 - 19968: jis0208<<14 | 0x59<<7 | 0x28,
	26707 - 19968: jis0208<<14 | 0x13<<7 | 0x1B,
	26708 - 19968: jis0208<<14 | 0x14<<7 | 0x2A,
	26709 - 19968: jis0212<<14 | 0x22<<7 | 0x3B,
	26711 - 19968: jis0212<<14 | 0x22<<7 | 0x3C,
	26712 - 19968: jis0212<<14 | 0x22<<7 | 0x3D,
	26713 - 19968: jis0208<<14 | 0x3A<<7 | 0x41,
	26715 - 19968: jis0212<<14 | 0x22<<7 | 0x3E,
	26716 - 19968: jis0208<<14 | 0x19<<7 | 0x58,
	26717 - 19968: jis0208<<14 | 0x2A<<7 | 0x50,
	26719 - 19968: jis0208<<14 | 0x1A<<7 | 0x16,
	26723 - 19968: jis0208<<14 | 0x3A<<7 | 0x42,
	26727 - 19968: jis0208<<14 | 0x28<<7 | 0x0F,
	26731 - 19968: jis0212<<14 | 0x22<<7 | 0x3F,
	26734 - 19968: jis0212<<14 | 0x22<<7 | 0x40,
	26735 - 19968: jis0212<<14 | 0x22<<7 | 0x41,
	26736 - 19968: jis0212<<14 | 0x22<<7 | 0x42,
	26737 - 19968: jis0212<<14 | 0x22<<7 | 0x43,
	26738 - 19968: jis0212<<14 | 0x22<<7 | 0x44,
	26740 - 19968: jis0208<<14 | 0x3A<<7 | 0x4E,
	26741 - 19968: jis0212<<14 | 0x22<<7 | 0x45,
	26742 - 19968: jis0208<<14 | 0x11<<7 | 0x12,
	26743 - 19968: jis0208<<14 | 0x3A<<7 | 0x43,
	26745 - 19968: jis0212<<14 | 0x22<<7 | 0x46,
	26746 - 19968: jis0212<<14 | 0x22<<7 | 0x47,
	26747 - 19968: jis0212<<14 | 0x22<<7 | 0x48,
	26748 - 19968: jis0212<<14 | 0x22<<7 | 0x49,
	26750 - 19968: jis0208<<14 | 0x3A<<7 | 0x54,
	26751 - 19968: jis0208<<14 | 0x3A<<7 | 0x44,
	26753 - 19968: jis0208<<14 | 0x2D<<7 | 0x21,
	26754 - 19968: jis0212<<14 | 0x22<<7 | 0x4A,
	26755 - 19968: jis0208<<14 | 0x3A<<7 | 0x4B,
	26756 - 19968: jis0212<<14 | 0x22<<7 | 0x4B,
	26757 - 19968: jis0208<<14 | 0x26<<7 | 0x3E,
	26758 - 19968: jis0212<<14 | 0x22<<7 | 0x4C,
	26760 - 19968: jis0212<<14 | 0x22<<7 | 0x4D,
	26765 - 19968: jis0208<<14 | 0x3A<<7 | 0x53,
	26767 - 19968: jis0208<<14 | 0x3A<<7 | 0x46,
	26771 - 19968: jis0208<<14 | 0x0F<<7 | 0x13,
	26772 - 19968: jis0208<<14 | 0x3A<<7 | 0x48,
	26774 - 19968: jis0212<<14 | 0x22<<7 | 0x4E,
	26775 - 19968: jis0208<<14 | 0x18<<7 | 0x1B,
	26776 - 19968: jis0212<<14 | 0x22<<7 | 0x4F,
	26778 - 19968: jis0212<<14 | 0x22<<7 | 0x50,
	26779 - 19968: jis0208<<14 | 0x3A<<7 | 0x4A,
	26780 - 19968: jis0212<<14 | 0x22<<7 | 0x51,
	26781 - 19968: jis0208<<14 | 0x3A<<7 | 0x49,
	26783 - 19968: jis0208<<14 | 0x3A<<7 | 0x45,
	26784 - 19968: jis0208<<14 | 0x3A<<7 | 0x50,
	26785 - 19968: jis0212<<14 | 0x22<<7 | 0x52,
	26786 - 19968: jis0208<<14 | 0x1D<<7 | 0x1E,
	26787 - 19968: jis0212<<14 | 0x22<<7 | 0x53,
	26789 - 19968: jis0212<<14 | 0x22<<7 | 0x54,
	26790 - 19968: jis0208<<14 | 0x33<<7 | 0x4C,
	26791 - 19968: jis0208<<14 | 0x17<<7 | 0x47,
	26792 - 19968: jis0208<<14 | 0x2C<<7 | 0x5B,
	26793 - 19968: jis0212<<14 | 0x22<<7 | 0x55,
	26794 - 19968: jis0212<<14 | 0x22<<7 | 0x56,
	26797 - 19968: jis0208<<14 | 0x3A<<7 | 0x47,
	26798 - 19968: jis0212<<14 | 0x22<<7 | 0x57,
	26799 - 19968: jis0208<<14 | 0x23<<7 | 0x53,
	26800 - 19968: jis0208<<14 | 0x12<<7 | 0x02,
	26801 - 19968: jis0208<<14 | 0x19<<7 | 0x0C,
	26802 - 19968: jis0212<<14 | 0x22<<7 | 0x58,
	26803 - 19968: jis0208<<14 | 0x3A<<7 | 0x3F,
	26805 - 19968: jis0208<<14 | 0x3A<<7 | 0x4F,
	26806 - 19968: jis0208<<14 | 0x12<<7 | 0x40,
	26809 - 19968: jis0208<<14 | 0x3A<<7 | 0x4D,
	26810 - 19968: jis0208<<14 | 0x3A<<7 | 0x51,
	26811 - 19968: jis0212<<14 | 0x22<<7 | 0x59,
	26812 - 19968: jis0208<<14 | 0x24<<7 | 0x4D,
	26820 - 19968: jis0208<<14 | 0x13<<7 | 0x5D,
	26821 - 19968: jis0212<<14 | 0x22<<7 | 0x5A,
	26822 - 19968: jis0208<<14 | 0x3B<<7 | 0x11,
	26824 - 19968: jis0208<<14 | 0x58<<7 | 0x08,
	26825 - 19968: jis0208<<14 | 0x2B<<7 | 0x28,
	26826 - 19968: jis0208<<14 | 0x3A<<7 | 0x56,
	26827 - 19968: jis0208<<14 | 0x13<<7 | 0x5C,
	26828 - 19968: jis0212<<14 | 0x22<<7 | 0x5C,
	26829 - 19968: jis0208<<14 | 0x3A<<7 | 0x5D,
	26831 - 19968: jis0208<<14 | 0x59<<7 | 0x2C,
	26832 - 19968: jis0212<<14 | 0x23<<7 | 0x00,
	26833 - 19968: jis0212<<14 | 0x23<<7 | 0x01,
	26834 - 19968: jis0208<<14 | 0x2A<<7 | 0x1F,
	26835 - 19968: jis0212<<14 | 0x23<<7 | 0x02,
	26836 - 19968: jis0208<<14 | 0x3B<<7 | 0x00,
	26837 - 19968: jis0208<<14 | 0x3B<<7 | 0x02,
	26838 - 19968: jis0212<<14 | 0x23<<7 | 0x03,
	26839 - 19968: jis0208<<14 | 0x3B<<7 | 0x06,
	26840 - 19968: jis0208<<14 | 0x3A<<7 | 0x58,
	26841 - 19968: jis0212<<14 | 0x23<<7 | 0x04,
	26842 - 19968: jis0208<<14 | 0x22<<7 | 0x09,
	26844 - 19968: jis0212<<14 | 0x23<<7 | 0x05,
	26845 - 19968: jis0212<<14 | 0x23<<7 | 0x06,
	26847 - 19968: jis0208<<14 | 0x24<<7 | 0x4E,
	26848 - 19968: jis0208<<14 | 0x3B<<7 | 0x0A,
	26849 - 19968: jis0208<<14 | 0x3A<<7 | 0x5B,
	26851 - 19968: jis0208<<14 | 0x3B<<7 | 0x07,
	26853 - 19968: jis0212<<14 | 0x23<<7 | 0x07,
	26855 - 19968: jis0208<<14 | 0x3B<<7 | 0x01,
	26856 - 19968: jis0212<<14 | 0x23<<7 | 0x08,
	26858 - 19968: jis0212<<14 | 0x23<<7 | 0x09,
	26859 - 19968: jis0212<<14 | 0x23<<7 | 0x0A,
	26860 - 19968: jis0212<<14 | 0x23<<7 | 0x0B,
	26861 - 19968: jis0212<<14 | 0x23<<7 | 0x0C,
	26862 - 19968: jis0208<<14 | 0x1E<<7 | 0x18,
	26863 - 19968: jis0208<<14 | 0x3B<<7 | 0x0B,
	26864 - 19968: jis0212<<14 | 0x23<<7 | 0x0D,
	26865 - 19968: jis0212<<14 | 0x23<<7 | 0x0E,
	26866 - 19968: jis0208<<14 | 0x1F<<7 | 0x12,
	26869 - 19968: jis0212<<14 | 0x23<<7 | 0x0F,
	26870 - 19968: jis0212<<14 | 0x23<<7 | 0x10,
	26873 - 19968: jis0208<<14 | 0x3B<<7 | 0x09,
	26874 - 19968: jis0208<<14 | 0x13<<7 | 0x1C,
	26875 - 19968: jis0212<<14 | 0x23<<7 | 0x11,
	26876 - 19968: jis0212<<14 | 0x23<<7 | 0x12,
	26877 - 19968: jis0212<<14 | 0x23<<7 | 0x13,
	26880 - 19968: jis0208<<14 | 0x2E<<7 | 0x2F,
	26881 - 19968: jis0208<<14 | 0x3A<<7 | 0x55,
	26884 - 19968: jis0208<<14 | 0x3B<<7 | 0x05,
	26885 - 19968: jis0208<<14 | 0x0F<<7 | 0x37,
	26886 - 19968: jis0212<<14 | 0x23<<7 | 0x14,
	26888 - 19968: jis0208<<14 | 0x3A<<7 | 0x57,
	26889 - 19968: jis0212<<14 | 0x23<<7 | 0x15,
	26890 - 19968: jis0212<<14 | 0x23<<7 | 0x16,
	26891 - 19968: jis0208<<14 | 0x2B<<7 | 0x19,
	26892 - 19968: jis0208<<14 | 0x3A<<7 | 0x5C,
	26893 - 19968: jis0208<<14 | 0x1E<<7 | 0x01,
	26894 - 19968: jis0208<<14 | 0x23<<7 | 0x26,
	26895 - 19968: jis0208<<14 | 0x3A<<7 | 0x52,
	26896 - 19968: jis0212<<14 | 0x23<<7 | 0x17,
	26897 - 19968: jis0212<<14 | 0x23<<7 | 0x18,
	26898 - 19968: jis0208<<14 | 0x3B<<7 | 0x04,
	26899 - 19968: jis0212<<14 | 0x23<<7 | 0x19,
	26902 - 19968: jis0212<<14 | 0x23<<7 | 0x1A,
	26903 - 19968: jis0212<<14 | 0x23<<7 | 0x1B,
	26905 - 19968: jis0208<<14 | 0x1E<<7 | 0x59,
	26906 - 19968: jis0208<<14 | 0x3B<<7 | 0x0E,
	26907 - 19968: jis0208<<14 | 0x12<<7 | 0x50,
	26908 - 19968: jis0208<<14 | 0x17<<7 | 0x00,
	26913 - 19968: jis0208<<14 | 0x3B<<7 | 0x10,
	26914 - 19968: jis0208<<14 | 0x3A<<7 | 0x59,
	26915 - 19968: jis0208<<14 | 0x3B<<7 | 0x0F,
	26917 - 19968: jis0208<<14 | 0x3B<<7 | 0x08,
	26918 - 19968: jis0208<<14 | 0x3A<<7 | 0x5A,
	26920 - 19968: jis0208<<14 | 0x3B<<7 | 0x0C,
	26922 - 19968: jis0208<<14 | 0x3B<<7 | 0x0D,
	26928 - 19968: jis0208<<14 | 0x3B<<7 | 0x1E,
	26929 - 19968: jis0212<<14 | 0x23<<7 | 0x1C,
	26931 - 19968: jis0212<<14 | 0x23<<7 | 0x1D,
	26932 - 19968: jis0208<<14 | 0x25<<7 | 0x2D,
	26933 - 19968: jis0212<<14 | 0x23<<7 | 0x1E,
	26934 - 19968: jis0208<<14 | 0x3B<<7 | 0x03,
	26936 - 19968: jis0212<<14 | 0x23<<7 | 0x1F,
	26937 - 19968: jis0208<<14 | 0x3B<<7 | 0x1A,
	26939 - 19968: jis0212<<14 | 0x23<<7 | 0x20,
	26941 - 19968: jis0208<<14 | 0x3B<<7 | 0x1C,
	26943 - 19968: jis0208<<14 | 0x23<<7 | 0x37,
	26946 - 19968: jis0212<<14 | 0x23<<7 | 0x21,
	26949 - 19968: jis0212<<14 | 0x23<<7 | 0x22,
	26953 - 19968: jis0212<<14 | 0x23<<7 | 0x23,
	26954 - 19968: jis0208<<14 | 0x2C<<7 | 0x2B,
	26958 - 19968: jis0212<<14 | 0x23<<7 | 0x24,
	26963 - 19968: jis0208<<14 | 0x28<<7 | 0x55,
	26964 - 19968: jis0208<<14 | 0x3B<<7 | 0x17,
	26965 - 19968: jis0208<<14 | 0x21<<7 | 0x29,
	26967 - 19968: jis0212<<14 | 0x23<<7 | 0x25,
	26969 - 19968: jis0208<<14 | 0x3B<<7 | 0x1D,
	26970 - 19968: jis0208<<14 | 0x20<<7 | 0x1E,
	26971 - 19968: jis0212<<14 | 0x23<<7 | 0x26,
	26972 - 19968: jis0208<<14 | 0x3B<<7 | 0x14,
	26973 - 19968: jis0208<<14 | 0x3B<<7 | 0x21,
	26974 - 19968: jis0208<<14 | 0x3B<<7 | 0x20,
	26976 - 19968: jis0208<<14 | 0x25<<7 | 0x4E,
	26977 - 19968: jis0208<<14 | 0x3B<<7 | 0x1F,
	26978 - 19968: jis0208<<14 | 0x25<<7 | 0x49,
	26979 - 19968: jis0212<<14 | 0x23<<7 | 0x27,
	26980 - 19968: jis0212<<14 | 0x23<<7 | 0x28,
	26981 - 19968: jis0212<<14 | 0x23<<7 | 0x29,
	26982 - 19968: jis0212<<14 | 0x23<<7 | 0x2A,
	26984 - 19968: jis0208<<14 | 0x59<<7 | 0x2E,
	26985 - 19968: jis0212<<14 | 0x23<<7 | 0x2C,
	26986 - 19968: jis0208<<14 | 0x3B<<7 | 0x23,
	26987 - 19968: jis0208<<14 | 0x3B<<7 | 0x16,
	26988 - 19968: jis0212<<14 | 0x23<<7 | 0x2D,
	26989 - 19968: jis0208<<14 | 0x15<<7 | 0x27,
	26990 - 19968: jis0208<<14 | 0x3B<<7 | 0x19,
	26991 - 19968: jis0208<<14 | 0x1C<<7 | 0x3C,
	26992 - 19968: jis0212<<14 | 0x23<<7 | 0x2E,
	26993 - 19968: jis0212<<14 | 0x23<<7 | 0x2F,
	26994 - 19968: jis0212<<14 | 0x23<<7 | 0x30,
	26995 - 19968: jis0208<<14 | 0x26<<7 | 0x3F,
	26996 - 19968: jis0208<<14 | 0x3B<<7 | 0x1B,
	26997 - 19968: jis0208<<14 | 0x15<<7 | 0x2A,
	26999 - 19968: jis0208<<14 | 0x3B<<7 | 0x13,
	27000 - 19968: jis0208<<14 | 0x3B<<7 | 0x15,
	27001 - 19968: jis0208<<14 | 0x3B<<7 | 0x12,
	27002 - 19968: jis0212<<14 | 0x23<<7 | 0x31,
	27003 - 19968: jis0212<<14 | 0x23<<7 | 0x32,
	27004 - 19968: jis0208<<14 | 0x2E<<7 | 0x0F,
	27005 - 19968: jis0208<<14 | 0x12<<7 | 0x39,
	27006 - 19968: jis0208<<14 | 0x3B<<7 | 0x18,
	27007 - 19968: jis0212<<14 | 0x23<<7 | 0x33,
	27008 - 19968: jis0212<<14 | 0x23<<7 | 0x34,
	27009 - 19968: jis0208<<14 | 0x3B<<7 | 0x22,
	27010 - 19968: jis0208<<14 | 0x12<<7 | 0x14,
	27018 - 19968: jis0208<<14 | 0x19<<7 | 0x46,
	27021 - 19968: jis0212<<14 | 0x23<<7 | 0x35,
	27022 - 19968: jis0208<<14 | 0x10<<7 | 0x3C,
	27025 - 19968: jis0208<<14 | 0x3B<<7 | 0x33,
	27026 - 19968: jis0212<<14 | 0x23<<7 | 0x36,
	27028 - 19968: jis0208<<14 | 0x2E<<7 | 0x10,
	27029 - 19968: jis0208<<14 | 0x3B<<7 | 0x36,
	27030 - 19968: jis0212<<14 | 0x23<<7 | 0x37,
	27032 - 19968: jis0208<<14 | 0x59<<7 | 0x30,
	27035 - 19968: jis0208<<14 | 0x1E<<7 | 0x19,
	27036 - 19968: jis0208<<14 | 0x3B<<7 | 0x35,
	27040 - 19968: jis0208<<14 | 0x3B<<7 | 0x34,
	27041 - 19968: jis0212<<14 | 0x23<<7 | 0x39,
	27045 - 19968: jis0212<<14 | 0x23<<7 | 0x3A,
	27046 - 19968: jis0212<<14 | 0x23<<7 | 0x3B,
	27047 - 19968: jis0208<<14 | 0x3B<<7 | 0x31,
	27048 - 19968: jis0212<<14 | 0x23<<7 | 0x3C,
	27051 - 19968: jis0212<<14 | 0x23<<7 | 0x3D,
	27053 - 19968: jis0212<<14 | 0x23<<7 | 0x3E,
	27054 - 19968: jis0208<<14 | 0x3B<<7 | 0x25,
	27055 - 19968: jis0212<<14 | 0x23<<7 | 0x3F,
	27057 - 19968: jis0208<<14 | 0x3B<<7 | 0x42,
	27058 - 19968: jis0208<<14 | 0x3B<<7 | 0x24,
	27060 - 19968: jis0208<<14 | 0x3B<<7 | 0x37,
	27063 - 19968: jis0212<<14 | 0x23<<7 | 0x40,
	27064 - 19968: jis0212<<14 | 0x23<<7 | 0x41,
	27066 - 19968: jis0212<<14 | 0x23<<7 | 0x42,
	27067 - 19968: jis0208<<14 | 0x3B<<7 | 0x2F,
	27068 - 19968: jis0212<<14 | 0x23<<7 | 0x43,
	27070 - 19968: jis0208<<14 | 0x3B<<7 | 0x2A,
	27071 - 19968: jis0208<<14 | 0x3B<<7 | 0x27,
	27073 - 19968: jis0208<<14 | 0x3B<<7 | 0x28,
	27075 - 19968: jis0208<<14 | 0x3B<<7 | 0x30,
	27077 - 19968: jis0212<<14 | 0x23<<7 | 0x44,
	27079 - 19968: jis0208<<14 | 0x53<<7 | 0x01,
	27080 - 19968: jis0212<<14 | 0x23<<7 | 0x45,
	27082 - 19968: jis0208<<14 | 0x3B<<7 | 0x2D,
	27083 - 19968: jis0208<<14 | 0x18<<7 | 0x1C,
	27084 - 19968: jis0208<<14 | 0x23<<7 | 0x27,
	27085 - 19968: jis0208<<14 | 0x20<<7 | 0x43,
	27086 - 19968: jis0208<<14 | 0x3B<<7 | 0x2B,
	27088 - 19968: jis0208<<14 | 0x3B<<7 | 0x26,
	27089 - 19968: jis0212<<14 | 0x23<<7 | 0x46,
	27091 - 19968: jis0208<<14 | 0x3B<<7 | 0x29,
	27094 - 19968: jis0212<<14 | 0x23<<7 | 0x47,
	27095 - 19968: jis0212<<14 | 0x23<<7 | 0x48,
	27096 - 19968: jis0208<<14 | 0x2C<<7 | 0x2C,
	27097 - 19968: jis0208<<14 | 0x2A<<7 | 0x49,
	27101 - 19968: jis0208<<14 | 0x3B<<7 | 0x2E,
	27102 - 19968: jis0208<<14 | 0x3B<<7 | 0x38,
	27106 - 19968: jis0208<<14 | 0x59<<7 | 0x31,
	27109 - 19968: jis0212<<14 | 0x23<<7 | 0x4A,
	27111 - 19968: jis0208<<14 | 0x3B<<7 | 0x40,
	27112 - 19968: jis0208<<14 | 0x3B<<7 | 0x39,
	27115 - 19968: jis0208<<14 | 0x3B<<7 | 0x46,
	27117 - 19968: jis0208<<14 | 0x3B<<7 | 0x44,
	27118 - 19968: jis0212<<14 | 0x23<<7 | 0x4B,
	27119 - 19968: jis0212<<14 | 0x23<<7 | 0x4C,
	27121 - 19968: jis0212<<14 | 0x23<<7 | 0x4D,
	27122 - 19968: jis0208<<14 | 0x3B<<7 | 0x3F,
	27123 - 19968: jis0212<<14 | 0x23<<7 | 0x4E,
	27125 - 19968: jis0212<<14 | 0x23<<7 | 0x4F,
	27129 - 19968: jis0208<<14 | 0x3B<<7 | 0x3E,
	27131 - 19968: jis0208<<14 | 0x23<<7 | 0x2F,
	27133 - 19968: jis0208<<14 | 0x20<<7 | 0x44,
	27134 - 19968: jis0212<<14 | 0x23<<7 | 0x50,
	27135 - 19968: jis0208<<14 | 0x3B<<7 | 0x3C,
	27136 - 19968: jis0212<<14 | 0x23<<7 | 0x51,
	27137 - 19968: jis0212<<14 | 0x23<<7 | 0x52,
	27138 - 19968: jis0208<<14 | 0x3B<<7 | 0x3A,
	27139 - 19968: jis0212<<14 | 0x23<<7 | 0x53,
	27141 - 19968: jis0208<<14 | 0x3B<<7 | 0x41,
	27146 - 19968: jis0208<<14 | 0x3B<<7 | 0x47,
	27147 - 19968: jis0208<<14 | 0x27<<7 | 0x54,
	27148 - 19968: jis0208<<14 | 0x3B<<7 | 0x4D,
	27151 - 19968: jis0212<<14 | 0x23<<7 | 0x54,
	27153 - 19968: jis0212<<14 | 0x23<<7 | 0x55,
	27154 - 19968: jis0208<<14 | 0x3B<<7 | 0x48,
	27155 - 19968: jis0208<<14 | 0x3B<<7 | 0x4B,
	27156 - 19968: jis0208<<14 | 0x3B<<7 | 0x45,
	27157 - 19968: jis0212<<14 | 0x23<<7 | 0x56,
	27159 - 19968: jis0208<<14 | 0x22<<7 | 0x53,
	27161 - 19968: jis0208<<14 | 0x28<<7 | 0x17,
	27162 - 19968: jis0212<<14 | 0x23<<7 | 0x57,
	27163 - 19968: jis0208<<14 | 0x3B<<7 | 0x3B,
	27165 - 19968: jis0212<<14 | 0x23<<7 | 0x58,
	27166 - 19968: jis0208<<14 | 0x3B<<7 | 0x43,
	27167 - 19968: jis0208<<14 | 0x1D<<7 | 0x1F,
	27168 - 19968: jis0212<<14 | 0x23<<7 | 0x59,
	27169 - 19968: jis0208<<14 | 0x2B<<7 | 0x2E,
	27170 - 19968: jis0208<<14 | 0x3B<<7 | 0x57,
	27171 - 19968: jis0208<<14 | 0x3B<<7 | 0x4A,
	27172 - 19968: jis0212<<14 | 0x23<<7 | 0x5A,
	27176 - 19968: jis0212<<14 | 0x23<<7 | 0x5B,
	27177 - 19968: jis0208<<14 | 0x17<<7 | 0x01,
	27178 - 19968: jis0208<<14 | 0x11<<7 | 0x02,
	27179 - 19968: jis0208<<14 | 0x12<<7 | 0x3E,
	27182 - 19968: jis0208<<14 | 0x3B<<7 | 0x32,
	27184 - 19968: jis0208<<14 | 0x59<<7 | 0x32,
	27186 - 19968: jis0212<<14 | 0x23<<7 | 0x5D,
	27188 - 19968: jis0212<<14 | 0x24<<7 | 0x00,
	27189 - 19968: jis0208<<14 | 0x1D<<7 | 0x20,
	27190 - 19968: jis0208<<14 | 0x3B<<7 | 0x4F,
	27191 - 19968: jis0212<<14 | 0x24<<7 | 0x01,
	27192 - 19968: jis0208<<14 | 0x3B<<7 | 0x56,
	27193 - 19968: jis0208<<14 | 0x1B<<7 | 0x58,
	27194 - 19968: jis0208<<14 | 0x12<<7 | 0x51,
	27195 - 19968: jis0212<<14 | 0x24<<7 | 0x02,
	27197 - 19968: jis0208<<14 | 0x22<<7 | 0x0D,
	27198 - 19968: jis0212<<14 | 0x24<<7 | 0x03,
	27199 - 19968: jis0212<<14 | 0x24<<7 | 0x04,
	27204 - 19968: jis0208<<14 | 0x3B<<7 | 0x4C,
	27205 - 19968: jis0212<<14 | 0x24<<7 | 0x05,
	27206 - 19968: jis0208<<14 | 0x59<<7 | 0x34,
	27207 - 19968: jis0208<<14 | 0x3B<<7 | 0x51,
	27208 - 19968: jis0208<<14 | 0x3B<<7 | 0x55,
	27209 - 19968: jis0212<<14 | 0x24<<7 | 0x07,
	27210 - 19968: jis0212<<14 | 0x24<<7 | 0x08,
	27211 - 19968: jis0208<<14 | 0x15<<7 | 0x15,
	27214 - 19968: jis0212<<14 | 0x24<<7 | 0x09,
	27216 - 19968: jis0212<<14 | 0x24<<7 | 0x0A,
	27217 - 19968: jis0212<<14 | 0x24<<7 | 0x0B,
	27218 - 19968: jis0212<<14 | 0x24<<7 | 0x0C,
	27221 - 19968: jis0212<<14 | 0x24<<7 | 0x0D,
	27222 - 19968: jis0212<<14 | 0x24<<7 | 0x0E,
	27224 - 19968: jis0208<<14 | 0x14<<7 | 0x2B,
	27225 - 19968: jis0208<<14 | 0x3B<<7 | 0x53,
	27227 - 19968: jis0212<<14 | 0x24<<7 | 0x0F,
	27231 - 19968: jis0208<<14 | 0x14<<7 | 0x00,
	27233 - 19968: jis0208<<14 | 0x25<<7 | 0x2A,
	27234 - 19968: jis0208<<14 | 0x3B<<7 | 0x52,
	27236 - 19968: jis0212<<14 | 0x24<<7 | 0x10,
	27238 - 19968: jis0208<<14 | 0x3B<<7 | 0x54,
	27239 - 19968: jis0212<<14 | 0x24<<7 | 0x11,
	27242 - 19968: jis0212<<14 | 0x24<<7 | 0x12,
	27243 - 19968: jis0208<<14 | 0x59<<7 | 0x33,
	27249 - 19968: jis0212<<14 | 0x24<<7 | 0x13,
	27250 - 19968: jis0208<<14 | 0x3B<<7 | 0x4E,
	27251 - 19968: jis0208<<14 | 0x59<<7 | 0x35,
	27256 - 19968: jis0208<<14 | 0x3B<<7 | 0x50,
	27262 - 19968: jis0208<<14 | 0x59<<7 | 0x36,
	27263 - 19968: jis0208<<14 | 0x12<<7 | 0x3F,
	27264 - 19968: jis0208<<14 | 0x22<<7 | 0x28,
	27265 - 19968: jis0212<<14 | 0x24<<7 | 0x16,
	27267 - 19968: jis0212<<14 | 0x24<<7 | 0x17,
	27268 - 19968: jis0208<<14 | 0x3B<<7 | 0x5B,
	27270 - 19968: jis0212<<14 | 0x24<<7 | 0x18,
	27271 - 19968: jis0212<<14 | 0x24<<7 | 0x19,
	27273 - 19968: jis0212<<14 | 0x24<<7 | 0x1A,
	27275 - 19968: jis0212<<14 | 0x24<<7 | 0x1B,
	27277 - 19968: jis0208<<14 | 0x3B<<7 | 0x59,
	27278 - 19968: jis0208<<14 | 0x17<<7 | 0x48,
	27280 - 19968: jis0208<<14 | 0x3B<<7 | 0x58,
	27281 - 19968: jis0212<<14 | 0x24<<7 | 0x1C,
	27287 - 19968: jis0208<<14 | 0x3C<<7 | 0x00,
	27291 - 19968: jis0212<<14 | 0x24<<7 | 0x1D,
	27292 - 19968: jis0208<<14 | 0x3A<<7 | 0x37,
	27293 - 19968: jis0212<<14 | 0x24<<7 | 0x1E,
	27294 - 19968: jis0212<<14 | 0x24<<7 | 0x1F,
	27295 - 19968: jis0212<<14 | 0x24<<7 | 0x20,
	27296 - 19968: jis0208<<14 | 0x3B<<7 | 0x5A,
	27298 - 19968: jis0208<<14 | 0x3B<<7 | 0x5C,
	27299 - 19968: jis0208<<14 | 0x3B<<7 | 0x5D,
	27301 - 19968: jis0212<<14 | 0x24<<7 | 0x21,
	27306 - 19968: jis0208<<14 | 0x3C<<7 | 0x0B,
	27307 - 19968: jis0212<<14 | 0x24<<7 | 0x22,
	27308 - 19968: jis0208<<14 | 0x3C<<7 | 0x07,
	27310 - 19968: jis0208<<14 | 0x3A<<7 | 0x4C,
	27311 - 19968: jis0212<<14 | 0x24<<7 | 0x23,
	27312 - 19968: jis0212<<14 | 0x24<<7 | 0x24,
	27313 - 19968: jis0212<<14 | 0x24<<7 | 0x25,
	27315 - 19968: jis0208<<14 | 0x3C<<7 | 0x06,
	27316 - 19968: jis0212<<14 | 0x24<<7 | 0x26,
	27320 - 19968: jis0208<<14 | 0x3C<<7 | 0x05,
	27323 - 19968: jis0208<<14 | 0x3C<<7 | 0x02,
	27325 - 19968: jis0212<<14 | 0x24<<7 | 0x27,
	27326 - 19968: jis0212<<14 | 0x24<<7 | 0x28,
	27327 - 19968: jis0212<<14 | 0x24<<7 | 0x29,
	27329 - 19968: jis0208<<14 | 0x3B<<7 | 0x49,
	27330 - 19968: jis0208<<14 | 0x3C<<7 | 0x04,
	27331 - 19968: jis0208<<14 | 0x3C<<7 | 0x03,
	27334 - 19968: jis0212<<14 | 0x24<<7 | 0x2A,
	27336 - 19968: jis0212<<14 | 0x24<<7 | 0x2C,
	27337 - 19968: jis0212<<14 | 0x24<<7 | 0x2B,
	27340 - 19968: jis0212<<14 | 0x24<<7 | 0x2D,
	27344 - 19968: jis0212<<14 | 0x24<<7 | 0x2E,
	27345 - 19968: jis0208<<14 | 0x3C<<7 | 0x09,
	27347 - 19968: jis0208<<14 | 0x2E<<7 | 0x05,
	27348 - 19968: jis0212<<14 | 0x24<<7 | 0x2F,
	27349 - 19968: jis0212<<14 | 0x24<<7 | 0x30,
	27350 - 19968: jis0212<<14 | 0x24<<7 | 0x31,
	27354 - 19968: jis0208<<14 | 0x3C<<7 | 0x0C,
	27355 - 19968: jis0208<<14 | 0x15<<7 | 0x5A,
	27356 - 19968: jis0212<<14 | 0x24<<7 | 0x32,
	27357 - 19968: jis0212<<14 | 0x24<<7 | 0x33,
	27358 - 19968: jis0208<<14 | 0x3C<<7 | 0x08,
	27359 - 19968: jis0208<<14 | 0x3C<<7 | 0x0A,
	27362 - 19968: jis0208<<14 | 0x59<<7 | 0x37,
	27364 - 19968: jis0208<<14 | 0x59<<7 | 0x38,
	27367 - 19968: jis0212<<14 | 0x24<<7 | 0x35,
	27368 - 19968: jis0208<<14 | 0x27<<7 | 0x06,
	27370 - 19968: jis0208<<14 | 0x3C<<7 | 0x0D,
	27372 - 19968: jis0212<<14 | 0x24<<7 | 0x36,
	27376 - 19968: jis0212<<14 | 0x24<<7 | 0x37,
	27377 - 19968: jis0212<<14 | 0x24<<7 | 0x38,
	27378 - 19968: jis0212<<14 | 0x24<<7 | 0x39,
	27386 - 19968: jis0208<<14 | 0x3C<<7 | 0x11,
	27387 - 19968: jis0208<<14 | 0x3C<<7 | 0x0E,
	27388 - 19968: jis0212<<14 | 0x24<<7 | 0x3A,
	27389 - 19968: jis0212<<14 | 0x24<<7 | 0x3B,
	27394 - 19968: jis0212<<14 | 0x24<<7 | 0x3C,
	27395 - 19968: jis0212<<14 | 0x24<<7 | 0x3D,
	27396 - 19968: jis0208<<14 | 0x2C<<7 | 0x52,
	27397 - 19968: jis0208<<14 | 0x3C<<7 | 0x0F,
	27398 - 19968: jis0212<<14 | 0x24<<7 | 0x3E,
	27399 - 19968: jis0212<<14 | 0x24<<7 | 0x3F,
	27401 - 19968: jis0212<<14 | 0x24<<7 | 0x40,
	27402 - 19968: jis0208<<14 | 0x3B<<7 | 0x3D,
	27407 - 19968: jis0212<<14 | 0x24<<7 | 0x41,
	27408 - 19968: jis0212<<14 | 0x24<<7 | 0x42,
	27409 - 19968: jis0212<<14 | 0x24<<7 | 0x43,
	27410 - 19968: jis0208<<14 | 0x3C<<7 | 0x12,
	27414 - 19968: jis0208<<14 | 0x3C<<7 | 0x13,
	27415 - 19968: jis0212<<14 | 0x24<<7 | 0x44,
	27419 - 19968: jis0212<<14 | 0x24<<7 | 0x45,
	27421 - 19968: jis0208<<14 | 0x10<<7 | 0x14,
	27422 - 19968: jis0212<<14 | 0x24<<7 | 0x46,
	27423 - 19968: jis0208<<14 | 0x3C<<7 | 0x15,
	27424 - 19968: jis0208<<14 | 0x16<<7 | 0x46,
	27425 - 19968: jis0208<<14 | 0x1B<<7 | 0x00,
	27427 - 19968: jis0208<<14 | 0x15<<7 | 0x34,
	27428 - 19968: jis0212<<14 | 0x24<<7 | 0x47,
	27431 - 19968: jis0208<<14 | 0x11<<7 | 0x03,
	27432 - 19968: jis0212<<14 | 0x24<<7 | 0x48,
	27435 - 19968: jis0212<<14 | 0x24<<7 | 0x49,
	27436 - 19968: jis0212<<14 | 0x24<<7 | 0x4A,
	27439 - 19968: jis0212<<14 | 0x24<<7 | 0x4B,
	27442 - 19968: jis0208<<14 | 0x2C<<7 | 0x3E,
	27445 - 19968: jis0212<<14 | 0x24<<7 | 0x4C,
	27446 - 19968: jis0212<<14 | 0x24<<7 | 0x4D,
	27447 - 19968: jis0208<<14 | 0x3C<<7 | 0x17,
	27448 - 19968: jis0208<<14 | 0x3C<<7 | 0x16,
	27449 - 19968: jis0208<<14 | 0x3C<<7 | 0x19,
	27450 - 19968: jis0208<<14 | 0x14<<7 | 0x1C,
	27451 - 19968: jis0212<<14 | 0x24<<7 | 0x4E,
	27453 - 19968: jis0208<<14 | 0x15<<7 | 0x35,
	27454 - 19968: jis0208<<14 | 0x13<<7 | 0x1D,
	27455 - 19968: jis0212<<14 | 0x24<<7 | 0x4F,
	27459 - 19968: jis0208<<14 | 0x3C<<7 | 0x1C,
	27462 - 19968: jis0212<<14 | 0x24<<7 | 0x50,
	27463 - 19968: jis0208<<14 | 0x3C<<7 | 0x1B,
	27465 - 19968: jis0208<<14 | 0x3C<<7 | 0x1D,
	27466 - 19968: jis0212<<14 | 0x24<<7 | 0x51,
	27468 - 19968: jis0208<<14 | 0x11<<7 | 0x2D,
	27469 - 19968: jis0212<<14 | 0x24<<7 | 0x52,
	27470 - 19968: jis0208<<14 | 0x22<<7 | 0x16,
	27472 - 19968: jis0208<<14 | 0x3C<<7 | 0x1E,
	27474 - 19968: jis0212<<14 | 0x24<<7 | 0x53,
	27475 - 19968: jis0208<<14 | 0x13<<7 | 0x1E,
	27476 - 19968: jis0208<<14 | 0x3C<<7 | 0x20,
	27478 - 19968: jis0212<<14 | 0x24<<7 | 0x54,
	27480 - 19968: jis0212<<14 | 0x24<<7 | 0x55,
	27481 - 19968: jis0208<<14 | 0x3C<<7 | 0x1F,
	27483 - 19968: jis0208<<14 | 0x3C<<7 | 0x21,
	27485 - 19968: jis0212<<14 | 0x24<<7 | 0x56,
	27487 - 19968: jis0208<<14 | 0x3C<<7 | 0x22,
	27488 - 19968: jis0212<<14 | 0x24<<7 | 0x57,
	27489 - 19968: jis0208<<14 | 0x3C<<7 | 0x23,
	27490 - 19968: jis0208<<14 | 0x1A<<7 | 0x3E,
	27491 - 19968: jis0208<<14 | 0x1F<<7 | 0x14,
	27492 - 19968: jis0208<<14 | 0x19<<7 | 0x00,
	27494 - 19968: jis0208<<14 | 0x28<<7 | 0x4F,
	27495 - 19968: jis0212<<14 | 0x24<<7 | 0x58,
	27497 - 19968: jis0208<<14 | 0x29<<7 | 0x41,
	27498 - 19968: jis0208<<14 | 0x2E<<7 | 0x23,
	27499 - 19968: jis0212<<14 | 0x24<<7 | 0x59,
	27502 - 19968: jis0212<<14 | 0x24<<7 | 0x5A,
	27503 - 19968: jis0208<<14 | 0x1A<<7 | 0x54,
	27504 - 19968: jis0212<<14 | 0x24<<7 | 0x5B,
	27507 - 19968: jis0208<<14 | 0x19<<7 | 0x2F,
	27508 - 19968: jis0208<<14 | 0x2D<<7 | 0x51,
	27509 - 19968: jis0212<<14 | 0x24<<7 | 0x5C,
	27512 - 19968: jis0208<<14 | 0x3C<<7 | 0x24,
	27513 - 19968: jis0208<<14 | 0x3C<<7 | 0x25,
	27515 - 19968: jis0208<<14 | 0x1A<<7 | 0x3F,
	27517 - 19968: jis0212<<14 | 0x24<<7 | 0x5D,
	27518 - 19968: jis0212<<14 | 0x25<<7 | 0x00,
	27519 - 19968: jis0208<<14 | 0x3C<<7 | 0x26,
	27520 - 19968: jis0208<<14 | 0x3C<<7 | 0x27,
	27522 - 19968: jis0212<<14 | 0x25<<7 | 0x01,
	27523 - 19968: jis0208<<14 | 0x3C<<7 | 0x29,
	27524 - 19968: jis0208<<14 | 0x3C<<7 | 0x28,
	27525 - 19968: jis0212<<14 | 0x25<<7 | 0x02,
	27526 - 19968: jis0208<<14 | 0x2A<<7 | 0x37,
	27529 - 19968: jis0208<<14 | 0x1C<<7 | 0x3D,
	27530 - 19968: jis0208<<14 | 0x1B<<7 | 0x4B,
	27531 - 19968: jis0208<<14 | 0x1A<<7 | 0x23,
	27533 - 19968: jis0208<<14 | 0x3C<<7 | 0x2A,
	27541 - 19968: jis0208<<14 | 0x3C<<7 | 0x2C,
	27542 - 19968: jis0208<<14 | 0x1E<<7 | 0x02,
	27543 - 19968: jis0212<<14 | 0x25<<7 | 0x03,
	27544 - 19968: jis0208<<14 | 0x3C<<7 | 0x2B,
	27547 - 19968: jis0212<<14 | 0x25<<7 | 0x04,
	27550 - 19968: jis0208<<14 | 0x3C<<7 | 0x2D,
	27551 - 19968: jis0212<<14 | 0x25<<7 | 0x05,
	27552 - 19968: jis0212<<14 | 0x25<<7 | 0x06,
	27554 - 19968: jis0212<<14 | 0x25<<7 | 0x07,
	27555 - 19968: jis0212<<14 | 0x25<<7 | 0x08,
	27556 - 19968: jis0208<<14 | 0x3C<<7 | 0x2E,
	27560 - 19968: jis0212<<14 | 0x25<<7 | 0x09,
	27561 - 19968: jis0212<<14 | 0x25<<7 | 0x0A,
	27562 - 19968: jis0208<<14 | 0x3C<<7 | 0x2F,
	27563 - 19968: jis0208<<14 | 0x3C<<7 | 0x30,
	27564 - 19968: jis0212<<14 | 0x25<<7 | 0x0B,
	27565 - 19968: jis0212<<14 | 0x25<<7 | 0x0C,
	27566 - 19968: jis0212<<14 | 0x25<<7 | 0x0D,
	27567 - 19968: jis0208<<14 | 0x3C<<7 | 0x31,
	27568 - 19968: jis0212<<14 | 0x25<<7 | 0x0E,
	27569 - 19968: jis0208<<14 | 0x3C<<7 | 0x33,
	27570 - 19968: jis0208<<14 | 0x3C<<7 | 0x32,
	27571 - 19968: jis0208<<14 | 0x3C<<7 | 0x34,
	27572 - 19968: jis0208<<14 | 0x11<<7 | 0x04,
	27573 - 19968: jis0208<<14 | 0x22<<7 | 0x29,
	27575 - 19968: jis0208<<14 | 0x3C<<7 | 0x35,
	27576 - 19968: jis0212<<14 | 0x25<<7 | 0x0F,
	27577 - 19968: jis0212<<14 | 0x25<<7 | 0x10,
	27578 - 19968: jis0208<<14 | 0x1A<<7 | 0x05,
	27579 - 19968: jis0208<<14 | 0x12<<7 | 0x2B,
	27580 - 19968: jis0208<<14 | 0x3C<<7 | 0x36,
	27581 - 19968: jis0212<<14 | 0x25<<7 | 0x11,
	27582 - 19968: jis0212<<14 | 0x25<<7 | 0x12,
	27583 - 19968: jis0208<<14 | 0x24<<7 | 0x21,
	27584 - 19968: jis0208<<14 | 0x33<<7 | 0x2B,
	27587 - 19968: jis0212<<14 | 0x25<<7 | 0x13,
	27588 - 19968: jis0212<<14 | 0x25<<7 | 0x14,
	27589 - 19968: jis0208<<14 | 0x14<<7 | 0x02,
	27590 - 19968: jis0208<<14 | 0x3C<<7 | 0x37,
	27593 - 19968: jis0212<<14 | 0x25<<7 | 0x15,
	27595 - 19968: jis0208<<14 | 0x3C<<7 | 0x38,
	27596 - 19968: jis0212<<14 | 0x25<<7 | 0x16,
	27597 - 19968: jis0208<<14 | 0x29<<7 | 0x4B,
	27598 - 19968: jis0208<<14 | 0x2A<<7 | 0x47,
	27602 - 19968: jis0208<<14 | 0x25<<7 | 0x26,
	27603 - 19968: jis0208<<14 | 0x3C<<7 | 0x39,
	27604 - 19968: jis0208<<14 | 0x27<<7 | 0x45,
	27606 - 19968: jis0208<<14 | 0x59<<7 | 0x39,
	27608 - 19968: jis0208<<14 | 0x27<<7 | 0x5A,
	27610 - 19968: jis0212<<14 | 0x25<<7 | 0x18,
	27611 - 19968: jis0208<<14 | 0x2B<<7 | 0x32,
	27615 - 19968: jis0208<<14 | 0x3C<<7 | 0x3A,
	27617 - 19968: jis0212<<14 | 0x25<<7 | 0x19,
	27619 - 19968: jis0212<<14 | 0x25<<7 | 0x1A,
	27622 - 19968: jis0212<<14 | 0x25<<7 | 0x1B,
	27623 - 19968: jis0212<<14 | 0x25<<7 | 0x1C,
	27627 - 19968: jis0208<<14 | 0x3C<<7 | 0x3C,
	27628 - 19968: jis0208<<14 | 0x3C<<7 | 0x3B,
	27630 - 19968: jis0212<<14 | 0x25<<7 | 0x1D,
	27631 - 19968: jis0208<<14 | 0x3C<<7 | 0x3E,
	27633 - 19968: jis0212<<14 | 0x25<<7 | 0x1E,
	27635 - 19968: jis0208<<14 | 0x3C<<7 | 0x3D,
	27639 - 19968: jis0212<<14 | 0x25<<7 | 0x1F,
	27641 - 19968: jis0212<<14 | 0x25<<7 | 0x20,
	27647 - 19968: jis0212<<14 | 0x25<<7 | 0x21,
	27650 - 19968: jis0212<<14 | 0x25<<7 | 0x22,
	27652 - 19968: jis0212<<14 | 0x25<<7 | 0x23,
	27653 - 19968: jis0212<<14 | 0x25<<7 | 0x24,
	27656 - 19968: jis0208<<14 | 0x3C<<7 | 0x40,
	27657 - 19968: jis0212<<14 | 0x25<<7 | 0x25,
	27661 - 19968: jis0212<<14 | 0x25<<7 | 0x26,
	27662 - 19968: jis0212<<14 | 0x25<<7 | 0x27,
	27663 - 19968: jis0208<<14 | 0x1A<<7 | 0x40,
	27664 - 19968: jis0212<<14 | 0x25<<7 | 0x28,
	27665 - 19968: jis0208<<14 | 0x2B<<7 | 0x10,
	27666 - 19968: jis0212<<14 | 0x25<<7 | 0x29,
	27667 - 19968: jis0208<<14 | 0x3C<<7 | 0x41,
	27668 - 19968: jis0208<<14 | 0x3C<<7 | 0x42,
	27671 - 19968: jis0208<<14 | 0x14<<7 | 0x03,
	27673 - 19968: jis0212<<14 | 0x25<<7 | 0x2A,
	27675 - 19968: jis0208<<14 | 0x3C<<7 | 0x43,
	27679 - 19968: jis0212<<14 | 0x25<<7 | 0x2B,
	27683 - 19968: jis0208<<14 | 0x3C<<7 | 0x45,
	27684 - 19968: jis0208<<14 | 0x3C<<7 | 0x44,
	27686 - 19968: jis0212<<14 | 0x25<<7 | 0x2C,
	27687 - 19968: jis0212<<14 | 0x25<<7 | 0x2D,
	27688 - 19968: jis0212<<14 | 0x25<<7 | 0x2E,
	27692 - 19968: jis0212<<14 | 0x25<<7 | 0x2F,
	27694 - 19968: jis0212<<14 | 0x25<<7 | 0x30,
	27699 - 19968: jis0212<<14 | 0x25<<7 | 0x31,
	27700 - 19968: jis0208<<14 | 0x1E<<7 | 0x44,
	27701 - 19968: jis0212<<14 | 0x25<<7 | 0x32,
	27702 - 19968: jis0212<<14 | 0x25<<7 | 0x33,
	27703 - 19968: jis0208<<14 | 0x28<<7 | 0x18,
	27704 - 19968: jis0208<<14 | 0x10<<7 | 0x29,
	27706 - 19968: jis0212<<14 | 0x25<<7 | 0x34,
	27707 - 19968: jis0212<<14 | 0x25<<7 | 0x35,
	27710 - 19968: jis0208<<14 | 0x27<<7 | 0x24,
	27711 - 19968: jis0208<<14 | 0x59<<7 | 0x3A,
	27712 - 19968: jis0208<<14 | 0x23<<7 | 0x54,
	27713 - 19968: jis0208<<14 | 0x1C<<7 | 0x20,
	27714 - 19968: jis0208<<14 | 0x14<<7 | 0x40,
	27722 - 19968: jis0212<<14 | 0x25<<7 | 0x37,
	27723 - 19968: jis0212<<14 | 0x25<<7 | 0x38,
	27725 - 19968: jis0212<<14 | 0x25<<7 | 0x39,
	27726 - 19968: jis0208<<14 | 0x27<<7 | 0x25,
	27727 - 19968: jis0212<<14 | 0x25<<7 | 0x3A,
	27728 - 19968: jis0208<<14 | 0x1B<<7 | 0x0D,
	27730 - 19968: jis0212<<14 | 0x25<<7 | 0x3B,
	27732 - 19968: jis0212<<14 | 0x25<<7 | 0x3C,
	27733 - 19968: jis0208<<14 | 0x3C<<7 | 0x47,
	27735 - 19968: jis0208<<14 | 0x13<<7 | 0x1F,
	27737 - 19968: jis0212<<14 | 0x25<<7 | 0x3D,
	27738 - 19968: jis0208<<14 | 0x10<<7 | 0x57,
	27739 - 19968: jis0212<<14 | 0x25<<7 | 0x3E,
	27740 - 19968: jis0208<<14 | 0x59<<7 | 0x3B,
	27741 - 19968: jis0208<<14 | 0x25<<7 | 0x51,
	27742 - 19968: jis0208<<14 | 0x3C<<7 | 0x46,
	27743 - 19968: jis0208<<14 | 0x18<<7 | 0x1D,
	27744 - 19968: jis0208<<14 | 0x22<<7 | 0x32,
	27746 - 19968: jis0208<<14 | 0x3C<<7 | 0x48,
	27751 - 19968: jis0212<<14 | 0x26<<7 | 0x15,
	27752 - 19968: jis0208<<14 | 0x3C<<7 | 0x50,
	27754 - 19968: jis0208<<14 | 0x3C<<7 | 0x49,
	27755 - 19968: jis0212<<14 | 0x25<<7 | 0x40,
	27757 - 19968: jis0212<<14 | 0x25<<7 | 0x41,
	27759 - 19968: jis0208<<14 | 0x59<<7 | 0x3D,
	27760 - 19968: jis0208<<14 | 0x21<<7 | 0x20,
	27762 - 19968: jis0208<<14 | 0x14<<7 | 0x41,
	27763 - 19968: jis0208<<14 | 0x3C<<7 | 0x51,
	27764 - 19968: jis0212<<14 | 0x25<<7 | 0x43,
	27766 - 19968: jis0212<<14 | 0x25<<7 | 0x44,
	27768 - 19968: jis0212<<14 | 0x25<<7 | 0x45,
	27769 - 19968: jis0212<<14 | 0x25<<7 | 0x46,
	27770 - 19968: jis0208<<14 | 0x16<<7 | 0x47,
	27771 - 19968: jis0212<<14 | 0x25<<7 | 0x47,
	27773 - 19968: jis0208<<14 | 0x14<<7 | 0x04,
	27774 - 19968: jis0208<<14 | 0x3C<<7 | 0x4F,
	27777 - 19968: jis0208<<14 | 0x3C<<7 | 0x4D,
	27778 - 19968: jis0208<<14 | 0x3C<<7 | 0x4A,
	27779 - 19968: jis0208<<14 | 0x2C<<7 | 0x3F,
	27781 - 19968: jis0212<<14 | 0x25<<7 | 0x48,
	27782 - 19968: jis0208<<14 | 0x59<<7 | 0x3C,
	27783 - 19968: jis0212<<14 | 0x25<<7 | 0x4A,
	27784 - 19968: jis0208<<14 | 0x23<<7 | 0x1F,
	27785 - 19968: jis0212<<14 | 0x25<<7 | 0x4B,
	27788 - 19968: jis0208<<14 | 0x25<<7 | 0x38,
	27789 - 19968: jis0208<<14 | 0x3C<<7 | 0x4B,
	27792 - 19968: jis0208<<14 | 0x3C<<7 | 0x53,
	27794 - 19968: jis0208<<14 | 0x3C<<7 | 0x52,
	27795 - 19968: jis0208<<14 | 0x16<<7 | 0x02,
	27796 - 19968: jis0212<<14 | 0x25<<7 | 0x4C,
	27797 - 19968: jis0212<<14 | 0x25<<7 | 0x4D,
	27798 - 19968: jis0208<<14 | 0x11<<7 | 0x0C,
	27799 - 19968: jis0212<<14 | 0x25<<7 | 0x4E,
	27800 - 19968: jis0212<<14 | 0x25<<7 | 0x4F,
	27801 - 19968: jis0208<<14 | 0x19<<7 | 0x1A,
	27802 - 19968: jis0208<<14 | 0x3C<<7 | 0x4C,
	27803 - 19968: jis0208<<14 | 0x3C<<7 | 0x4E,
	27804 - 19968: jis0212<<14 | 0x25<<7 | 0x50,
	27807 - 19968: jis0212<<14 | 0x25<<7 | 0x51,
	27809 - 19968: jis0208<<14 | 0x2A<<7 | 0x36,
	27810 - 19968: jis0208<<14 | 0x21<<7 | 0x53,
	27819 - 19968: jis0208<<14 | 0x2A<<7 | 0x56,
	27822 - 19968: jis0208<<14 | 0x3C<<7 | 0x5B,
	27824 - 19968: jis0212<<14 | 0x25<<7 | 0x52,
	27825 - 19968: jis0208<<14 | 0x3C<<7 | 0x5C,
	27826 - 19968: jis0212<<14 | 0x25<<7 | 0x53,
	27827 - 19968: jis0208<<14 | 0x11<<7 | 0x2E,
	27828 - 19968: jis0212<<14 | 0x25<<7 | 0x54,
	27832 - 19968: jis0208<<14 | 0x29<<7 | 0x07,
	27833 - 19968: jis0208<<14 | 0x2B<<7 | 0x5C,
	27834 - 19968: jis0208<<14 | 0x3D<<7 | 0x00,
	27835 - 19968: jis0208<<14 | 0x1B<<7 | 0x02,
	27836 - 19968: jis0208<<14 | 0x1D<<7 | 0x21,
	27837 - 19968: jis0208<<14 | 0x3C<<7 | 0x57,
	27838 - 19968: jis0208<<14 | 0x3C<<7 | 0x5D,
	27839 - 19968: jis0208<<14 | 0x10<<7 | 0x47,
	27841 - 19968: jis0208<<14 | 0x15<<7 | 0x16,
	27842 - 19968: jis0212<<14 | 0x25<<7 | 0x55,
	27844 - 19968: jis0208<<14 | 0x3C<<7 | 0x54,
	27845 - 19968: jis0208<<14 | 0x3C<<7 | 0x59,
	27846 - 19968: jis0212<<14 | 0x25<<7 | 0x56,
	27849 - 19968: jis0208<<14 | 0x1F<<7 | 0x53,
	27850 - 19968: jis0208<<14 | 0x26<<7 | 0x50,
	27852 - 19968: jis0208<<14 | 0x27<<7 | 0x46,
	27853 - 19968: jis0212<<14 | 0x25<<7 | 0x57,
	27855 - 19968: jis0212<<14 | 0x25<<7 | 0x58,
	27856 - 19968: jis0212<<14 | 0x25<<7 | 0x59,
	27857 - 19968: jis0212<<14 | 0x25<<7 | 0x5A,
	27858 - 19968: jis0212<<14 | 0x25<<7 | 0x5B,
	27859 - 19968: jis0208<<14 | 0x3C<<7 | 0x56,
	27860 - 19968: jis0212<<14 | 0x25<<7 | 0x5C,
	27861 - 19968: jis0208<<14 | 0x2A<<7 | 0x00,
	27862 - 19968: jis0212<<14 | 0x25<<7 | 0x5D,
	27863 - 19968: jis0208<<14 | 0x3C<<7 | 0x58,
	27865 - 19968: jis0208<<14 | 0x3D<<7 | 0x03,
	27866 - 19968: jis0208<<14 | 0x59<<7 | 0x3E,
	27867 - 19968: jis0208<<14 | 0x3D<<7 | 0x01,
	27868 - 19968: jis0212<<14 | 0x26<<7 | 0x01,
	27869 - 19968: jis0208<<14 | 0x3C<<7 | 0x5A,
	27872 - 19968: jis0212<<14 | 0x26<<7 | 0x02,
	27873 - 19968: jis0208<<14 | 0x2A<<7 | 0x01,
	27874 - 19968: jis0208<<14 | 0x26<<7 | 0x27,
	27875 - 19968: jis0208<<14 | 0x14<<7 | 0x42,
	27877 - 19968: jis0208<<14 | 0x24<<7 | 0x04,
	27879 - 19968: jis0212<<14 | 0x26<<7 | 0x03,
	27880 - 19968: jis0208<<14 | 0x22<<7 | 0x4C,
	27881 - 19968: jis0212<<14 | 0x26<<7 | 0x04,
	27882 - 19968: jis0208<<14 | 0x3D<<7 | 0x04,
	27883 - 19968: jis0212<<14 | 0x26<<7 | 0x05,
	27884 - 19968: jis0212<<14 | 0x26<<7 | 0x06,
	27886 - 19968: jis0212<<14 | 0x26<<7 | 0x07,
	27887 - 19968: jis0208<<14 | 0x3D<<7 | 0x02,
	27888 - 19968: jis0208<<14 | 0x21<<7 | 0x38,
	27889 - 19968: jis0208<<14 | 0x3C<<7 | 0x55,
	27890 - 19968: jis0212<<14 | 0x26<<7 | 0x08,
	27891 - 19968: jis0208<<14 | 0x10<<7 | 0x2A,
	27892 - 19968: jis0212<<14 | 0x26<<7 | 0x09,
	27908 - 19968: jis0208<<14 | 0x59<<7 | 0x3F,
	27911 - 19968: jis0212<<14 | 0x26<<7 | 0x0B,
	27914 - 19968: jis0212<<14 | 0x26<<7 | 0x0C,
	27915 - 19968: jis0208<<14 | 0x2C<<7 | 0x2D,
	27916 - 19968: jis0208<<14 | 0x3D<<7 | 0x0F,
	27918 - 19968: jis0212<<14 | 0x26<<7 | 0x0D,
	27919 - 19968: jis0212<<14 | 0x26<<7 | 0x0E,
	27921 - 19968: jis0212<<14 | 0x26<<7 | 0x0F,
	27922 - 19968: jis0208<<14 | 0x3D<<7 | 0x0E,
	27923 - 19968: jis0212<<14 | 0x26<<7 | 0x10,
	27927 - 19968: jis0208<<14 | 0x1F<<7 | 0x55,
	27929 - 19968: jis0208<<14 | 0x3D<<7 | 0x0B,
	27930 - 19968: jis0212<<14 | 0x26<<7 | 0x11,
	27931 - 19968: jis0208<<14 | 0x2C<<7 | 0x4B,
	27934 - 19968: jis0208<<14 | 0x25<<7 | 0x15,
	27935 - 19968: jis0208<<14 | 0x3D<<7 | 0x05,
	27941 - 19968: jis0208<<14 | 0x23<<7 | 0x24,
	27942 - 19968: jis0212<<14 | 0x26<<7 | 0x12,
	27943 - 19968: jis0212<<14 | 0x26<<7 | 0x13,
	27944 - 19968: jis0212<<14 | 0x26<<7 | 0x14,
	27945 - 19968: jis0208<<14 | 0x10<<7 | 0x2B,
	27946 - 19968: jis0208<<14 | 0x18<<7 | 0x1E,
	27947 - 19968: jis0208<<14 | 0x3D<<7 | 0x08,
	27950 - 19968: jis0212<<14 | 0x26<<7 | 0x16,
	27951 - 19968: jis0212<<14 | 0x26<<7 | 0x17,
	27953 - 19968: jis0212<<14 | 0x26<<7 | 0x18,
	27954 - 19968: jis0208<<14 | 0x1C<<7 | 0x06,
	27955 - 19968: jis0208<<14 | 0x3D<<7 | 0x0D,
	27957 - 19968: jis0208<<14 | 0x3D<<7 | 0x0C,
	27958 - 19968: jis0208<<14 | 0x3D<<7 | 0x07,
	27960 - 19968: jis0208<<14 | 0x3D<<7 | 0x0A,
	27961 - 19968: jis0212<<14 | 0x26<<7 | 0x19,
	27963 - 19968: jis0208<<14 | 0x12<<7 | 0x47,
	27964 - 19968: jis0212<<14 | 0x26<<7 | 0x1A,
	27965 - 19968: jis0208<<14 | 0x3D<<7 | 0x09,
	27966 - 19968: jis0208<<14 | 0x26<<7 | 0x28,
	27967 - 19968: jis0212<<14 | 0x26<<7 | 0x1B,
	27969 - 19968: jis0208<<14 | 0x2D<<7 | 0x0D,
	27972 - 19968: jis0208<<14 | 0x1D<<7 | 0x53,
	27973 - 19968: jis0208<<14 | 0x1F<<7 | 0x54,
	27991 - 19968: jis0212<<14 | 0x26<<7 | 0x1C,
	27993 - 19968: jis0208<<14 | 0x3D<<7 | 0x15,
	27994 - 19968: jis0208<<14 | 0x3D<<7 | 0x13,
	27996 - 19968: jis0208<<14 | 0x28<<7 | 0x2C,
	27998 - 19968: jis0212<<14 | 0x26<<7 | 0x1D,
	27999 - 19968: jis0212<<14 | 0x26<<7 | 0x1E,
	28001 - 19968: jis0212<<14 | 0x26<<7 | 0x1F,
	28003 - 19968: jis0208<<14 | 0x3D<<7 | 0x10,
	28004 - 19968: jis0208<<14 | 0x3D<<7 | 0x12,
	28005 - 19968: jis0212<<14 | 0x26<<7 | 0x20,
	28006 - 19968: jis0208<<14 | 0x10<<7 | 0x19,
	28007 - 19968: jis0212<<14 | 0x26<<7 | 0x21,
	28009 - 19968: jis0208<<14 | 0x18<<7 | 0x1F,
	28010 - 19968: jis0208<<14 | 0x2E<<7 | 0x11,
	28012 - 19968: jis0208<<14 | 0x12<<7 | 0x1C,
	28014 - 19968: jis0208<<14 | 0x28<<7 | 0x41,
	28015 - 19968: jis0208<<14 | 0x59<<7 | 0x41,
	28016 - 19968: jis0212<<14 | 0x26<<7 | 0x23,
	28020 - 19968: jis0208<<14 | 0x2C<<7 | 0x40,
	28023 - 19968: jis0208<<14 | 0x12<<7 | 0x03,
	28024 - 19968: jis0208<<14 | 0x1E<<7 | 0x1A,
	28025 - 19968: jis0208<<14 | 0x3D<<7 | 0x14,
	28028 - 19968: jis0212<<14 | 0x26<<7 | 0x24,
	28034 - 19968: jis0212<<14 | 0x26<<7 | 0x25,
	28037 - 19968: jis0208<<14 | 0x3D<<7 | 0x19,
	28039 - 19968: jis0208<<14 | 0x59<<7 | 0x40,
	28040 - 19968: jis0208<<14 | 0x1D<<7 | 0x22,
	28044 - 19968: jis0208<<14 | 0x2C<<7 | 0x0F,
	28046 - 19968: jis0208<<14 | 0x3D<<7 | 0x16,
	28049 - 19968: jis0212<<14 | 0x26<<7 | 0x27,
	28050 - 19968: jis0212<<14 | 0x26<<7 | 0x28,
	28051 - 19968: jis0208<<14 | 0x3D<<7 | 0x11,
	28052 - 19968: jis0212<<14 | 0x26<<7 | 0x29,
	28053 - 19968: jis0208<<14 | 0x3D<<7 | 0x17,
	28054 - 19968: jis0208<<14 | 0x59<<7 | 0x42,
	28055 - 19968: jis0212<<14 | 0x26<<7 | 0x2B,
	28056 - 19968: jis0212<<14 | 0x26<<7 | 0x2C,
	28057 - 19968: jis0208<<14 | 0x2D<<7 | 0x3D,
	28059 - 19968: jis0208<<14 | 0x24<<7 | 0x52,
	28060 - 19968: jis0208<<14 | 0x25<<7 | 0x21,
	28074 - 19968: jis0212<<14 | 0x26<<7 | 0x2D,
	28076 - 19968: jis0208<<14 | 0x59<<7 | 0x43,
	28079 - 19968: jis0208<<14 | 0x12<<7 | 0x15,
	28082 - 19968: jis0208<<14 | 0x10<<7 | 0x34,
	28084 - 19968: jis0212<<14 | 0x26<<7 | 0x2F,
	28085 - 19968: jis0208<<14 | 0x3D<<7 | 0x1D,
	28087 - 19968: jis0212<<14 | 0x26<<7 | 0x30,
	28088 - 19968: jis0208<<14 | 0x3D<<7 | 0x20,
	28089 - 19968: jis0212<<14 | 0x26<<7 | 0x31,
	28092 - 19968: jis0208<<14 | 0x2D<<7 | 0x22,
	28093 - 19968: jis0212<<14 | 0x26<<7 | 0x32,
	28095 - 19968: jis0212<<14 | 0x26<<7 | 0x33,
	28096 - 19968: jis0208<<14 | 0x2C<<7 | 0x43,
	28100 - 19968: jis0212<<14 | 0x26<<7 | 0x34,
	28101 - 19968: jis0208<<14 | 0x3D<<7 | 0x27,
	28102 - 19968: jis0208<<14 | 0x3D<<7 | 0x21,
	28103 - 19968: jis0208<<14 | 0x3D<<7 | 0x1E,
	28104 - 19968: jis0212<<14 | 0x26<<7 | 0x35,
	28106 - 19968: jis0212<<14 | 0x26<<7 | 0x36,
	28107 - 19968: jis0208<<14 | 0x2D<<7 | 0x33,
	28108 - 19968: jis0208<<14 | 0x3D<<7 | 0x24,
	28110 - 19968: jis0212<<14 | 0x26<<7 | 0x37,
	28111 - 19968: jis0208<<14 | 0x59<<7 | 0x44,
	28113 - 19968: jis0208<<14 | 0x1C<<7 | 0x29,
	28114 - 19968: jis0208<<14 | 0x3D<<7 | 0x26,
	28117 - 19968: jis0208<<14 | 0x3D<<7 | 0x2B,
	28118 - 19968: jis0212<<14 | 0x26<<7 | 0x39,
	28120 - 19968: jis0208<<14 | 0x24<<7 | 0x50,
	28121 - 19968: jis0208<<14 | 0x3D<<7 | 0x29,
	28123 - 19968: jis0212<<14 | 0x26<<7 | 0x3A,
	28125 - 19968: jis0212<<14 | 0x26<<7 | 0x3B,
	28126 - 19968: jis0208<<14 | 0x3D<<7 | 0x23,
	28127 - 19968: jis0212<<14 | 0x26<<7 | 0x3C,
	28128 - 19968: jis0212<<14 | 0x26<<7 | 0x3D,
	28129 - 19968: jis0208<<14 | 0x22<<7 | 0x17,
	28130 - 19968: jis0212<<14 | 0x26<<7 | 0x3E,
	28132 - 19968: jis0208<<14 | 0x3D<<7 | 0x2A,
	28133 - 19968: jis0212<<14 | 0x26<<7 | 0x3F,
	28134 - 19968: jis0208<<14 | 0x3D<<7 | 0x1F,
	28136 - 19968: jis0208<<14 | 0x3D<<7 | 0x25,
	28137 - 19968: jis0212<<14 | 0x26<<7 | 0x40,
	28138 - 19968: jis0208<<14 | 0x3D<<7 | 0x2C,
	28139 - 19968: jis0208<<14 | 0x0F<<7 | 0x5B,
	28140 - 19968: jis0208<<14 | 0x3D<<7 | 0x22,
	28142 - 19968: jis0208<<14 | 0x3D<<7 | 0x2D,
	28143 - 19968: jis0212<<14 | 0x26<<7 | 0x41,
	28144 - 19968: jis0212<<14 | 0x26<<7 | 0x42,
	28145 - 19968: jis0208<<14 | 0x1E<<7 | 0x1B,
	28146 - 19968: jis0208<<14 | 0x59<<7 | 0x46,
	28147 - 19968: jis0208<<14 | 0x1C<<7 | 0x3E,
	28148 - 19968: jis0212<<14 | 0x26<<7 | 0x43,
	28149 - 19968: jis0208<<14 | 0x29<<7 | 0x04,
	28150 - 19968: jis0212<<14 | 0x26<<7 | 0x44,
	28151 - 19968: jis0208<<14 | 0x19<<7 | 0x0D,
	28152 - 19968: jis0208<<14 | 0x59<<7 | 0x45,
	28153 - 19968: jis0208<<14 | 0x3D<<7 | 0x1A,
	28154 - 19968: jis0208<<14 | 0x3D<<7 | 0x28,
	28155 - 19968: jis0208<<14 | 0x24<<7 | 0x19,
	28156 - 19968: jis0208<<14 | 0x59<<7 | 0x47,
	28160 - 19968: jis0212<<14 | 0x26<<7 | 0x46,
	28164 - 19968: jis0212<<14 | 0x26<<7 | 0x47,
	28165 - 19968: jis0208<<14 | 0x1F<<7 | 0x15,
	28167 - 19968: jis0208<<14 | 0x12<<7 | 0x48,
	28168 - 19968: jis0208<<14 | 0x19<<7 | 0x30,
	28169 - 19968: jis0208<<14 | 0x1D<<7 | 0x23,
	28170 - 19968: jis0208<<14 | 0x3D<<7 | 0x1C,
	28171 - 19968: jis0208<<14 | 0x1C<<7 | 0x21,
	28179 - 19968: jis0208<<14 | 0x16<<7 | 0x2B,
	28181 - 19968: jis0208<<14 | 0x3D<<7 | 0x1B,
	28185 - 19968: jis0208<<14 | 0x3D<<7 | 0x31,
	28186 - 19968: jis0208<<14 | 0x1C<<7 | 0x4C,
	28187 - 19968: jis0208<<14 | 0x17<<7 | 0x19,
	28189 - 19968: jis0208<<14 | 0x3D<<7 | 0x40,
	28190 - 19968: jis0212<<14 | 0x26<<7 | 0x48,
	28191 - 19968: jis0208<<14 | 0x3D<<7 | 0x3A,
	28192 - 19968: jis0208<<14 | 0x14<<7 | 0x53,
	28193 - 19968: jis0208<<14 | 0x24<<7 | 0x2E,
	28194 - 19968: jis0212<<14 | 0x26<<7 | 0x49,
	28195 - 19968: jis0208<<14 | 0x3D<<7 | 0x35,
	28196 - 19968: jis0208<<14 | 0x3D<<7 | 0x3E,
	28197 - 19968: jis0208<<14 | 0x0F<<7 | 0x0E,
	28198 - 19968: jis0208<<14 | 0x10<<7 | 0x11,
	28199 - 19968: jis0208<<14 | 0x59<<7 | 0x4A,
	28201 - 19968: jis0208<<14 | 0x11<<7 | 0x18,
	28203 - 19968: jis0208<<14 | 0x3D<<7 | 0x37,
	28204 - 19968: jis0208<<14 | 0x21<<7 | 0x0B,
	28205 - 19968: jis0208<<14 | 0x3D<<7 | 0x2E,
	28206 - 19968: jis0208<<14 | 0x3D<<7 | 0x30,
	28207 - 19968: jis0208<<14 | 0x18<<7 | 0x20,
	28210 - 19968: jis0212<<14 | 0x26<<7 | 0x4B,
	28214 - 19968: jis0212<<14 | 0x26<<7 | 0x4C,
	28216 - 19968: jis0208<<14 | 0x3D<<7 | 0x41,
	28217 - 19968: jis0208<<14 | 0x59<<7 | 0x48,
	28218 - 19968: jis0208<<14 | 0x3D<<7 | 0x3C,
	28219 - 19968: jis0212<<14 | 0x26<<7 | 0x4E,
	28220 - 19968: jis0208<<14 | 0x59<<7 | 0x4B,
	28222 - 19968: jis0208<<14 | 0x3D<<7 | 0x34,
	28227 - 19968: jis0208<<14 | 0x3D<<7 | 0x3B,
	28228 - 19968: jis0212<<14 | 0x26<<7 | 0x50,
	28229 - 19968: jis0212<<14 | 0x26<<7 | 0x51,
	28232 - 19968: jis0212<<14 | 0x26<<7 | 0x52,
	28233 - 19968: jis0212<<14 | 0x26<<7 | 0x53,
	28234 - 19968: jis0208<<14 | 0x2B<<7 | 0x0A,
	28235 - 19968: jis0212<<14 | 0x26<<7 | 0x54,
	28237 - 19968: jis0208<<14 | 0x3D<<7 | 0x39,
	28238 - 19968: jis0208<<14 | 0x3D<<7 | 0x3D,
	28239 - 19968: jis0212<<14 | 0x26<<7 | 0x55,
	28241 - 19968: jis0212<<14 | 0x26<<7 | 0x56,
	28242 - 19968: jis0212<<14 | 0x26<<7 | 0x57,
	28243 - 19968: jis0212<<14 | 0x26<<7 | 0x58,
	28244 - 19968: jis0212<<14 | 0x26<<7 | 0x59,
	28246 - 19968: jis0208<<14 | 0x17<<7 | 0x2F,
	28247 - 19968: jis0212<<14 | 0x26<<7 | 0x5A,
	28248 - 19968: jis0208<<14 | 0x1D<<7 | 0x24,
	28251 - 19968: jis0208<<14 | 0x22<<7 | 0x18,
	28252 - 19968: jis0208<<14 | 0x59<<7 | 0x49,
	28253 - 19968: jis0212<<14 | 0x26<<7 | 0x5C,
	28254 - 19968: jis0212<<14 | 0x26<<7 | 0x5D,
	28255 - 19968: jis0208<<14 | 0x3D<<7 | 0x33,
	28258 - 19968: jis0212<<14 | 0x27<<7 | 0x00,
	28259 - 19968: jis0212<<14 | 0x27<<7 | 0x01,
	28263 - 19968: jis0208<<14 | 0x2C<<7 | 0x0E,
	28264 - 19968: jis0212<<14 | 0x27<<7 | 0x02,
	28267 - 19968: jis0208<<14 | 0x3D<<7 | 0x36,
	28270 - 19968: jis0208<<14 | 0x3D<<7 | 0x2F,
	28271 - 19968: jis0208<<14 | 0x24<<7 | 0x51,
	28274 - 19968: jis0208<<14 | 0x3D<<7 | 0x32,
	28275 - 19968: jis0212<<14 | 0x27<<7 | 0x03,
	28278 - 19968: jis0208<<14 | 0x3D<<7 | 0x38,
	28283 - 19968: jis0212<<14 | 0x27<<7 | 0x04,
	28285 - 19968: jis0212<<14 | 0x27<<7 | 0x05,
	28286 - 19968: jis0208<<14 | 0x2E<<7 | 0x30,
	28287 - 19968: jis0208<<14 | 0x1B<<7 | 0x1D,
	28288 - 19968: jis0208<<14 | 0x2A<<7 | 0x5D,
	28290 - 19968: jis0208<<14 | 0x3D<<7 | 0x42,
	28300 - 19968: jis0208<<14 | 0x27<<7 | 0x0D,
	28301 - 19968: jis0212<<14 | 0x27<<7 | 0x06,
	28303 - 19968: jis0208<<14 | 0x3D<<7 | 0x4E,
	28304 - 19968: jis0208<<14 | 0x17<<7 | 0x1A,
	28307 - 19968: jis0212<<14 | 0x27<<7 | 0x07,
	28310 - 19968: jis0208<<14 | 0x1C<<7 | 0x3F,
	28312 - 19968: jis0208<<14 | 0x3D<<7 | 0x44,
	28313 - 19968: jis0212<<14 | 0x27<<7 | 0x08,
	28316 - 19968: jis0208<<14 | 0x2D<<7 | 0x0E,
	28317 - 19968: jis0208<<14 | 0x18<<7 | 0x21,
	28319 - 19968: jis0208<<14 | 0x3D<<7 | 0x51,
	28320 - 19968: jis0212<<14 | 0x27<<7 | 0x09,
	28322 - 19968: jis0208<<14 | 0x0F<<7 | 0x4D,
	28325 - 19968: jis0208<<14 | 0x3D<<7 | 0x4F,
	28327 - 19968: jis0212<<14 | 0x27<<7 | 0x0A,
	28330 - 19968: jis0208<<14 | 0x3D<<7 | 0x43,
	28333 - 19968: jis0212<<14 | 0x27<<7 | 0x0B,
	28334 - 19968: jis0212<<14 | 0x27<<7 | 0x0C,
	28335 - 19968: jis0208<<14 | 0x3D<<7 | 0x49,
	28337 - 19968: jis0212<<14 | 0x27<<7 | 0x0D,
	28338 - 19968: jis0208<<14 | 0x3D<<7 | 0x4B,
	28339 - 19968: jis0212<<14 | 0x27<<7 | 0x0E,
	28342 - 19968: jis0208<<14 | 0x2C<<7 | 0x2E,
	28343 - 19968: jis0208<<14 | 0x3D<<7 | 0x46,
	28346 - 19968: jis0208<<14 | 0x24<<7 | 0x0D,
	28347 - 19968: jis0212<<14 | 0x27<<7 | 0x0F,
	28349 - 19968: jis0208<<14 | 0x3D<<7 | 0x48,
	28351 - 19968: jis0208<<14 | 0x59<<7 | 0x4C,
	28352 - 19968: jis0212<<14 | 0x27<<7 | 0x11,
	28353 - 19968: jis0212<<14 | 0x27<<7 | 0x12,
	28354 - 19968: jis0208<<14 | 0x3D<<7 | 0x50,
	28355 - 19968: jis0212<<14 | 0x27<<7 | 0x13,
	28356 - 19968: jis0208<<14 | 0x3D<<7 | 0x4A,
	28357 - 19968: jis0208<<14 | 0x2B<<7 | 0x26,
	28359 - 19968: jis0212<<14 | 0x27<<7 | 0x14,
	28360 - 19968: jis0212<<14 | 0x27<<7 | 0x15,
	28361 - 19968: jis0208<<14 | 0x3D<<7 | 0x45,
	28362 - 19968: jis0212<<14 | 0x27<<7 | 0x16,
	28363 - 19968: jis0208<<14 | 0x1B<<7 | 0x01,
	28364 - 19968: jis0208<<14 | 0x3D<<7 | 0x5D,
	28365 - 19968: jis0212<<14 | 0x27<<7 | 0x17,
	28366 - 19968: jis0212<<14 | 0x27<<7 | 0x18,
	28367 - 19968: jis0212<<14 | 0x27<<7 | 0x19,
	28369 - 19968: jis0208<<14 | 0x12<<7 | 0x49,
	28371 - 19968: jis0208<<14 | 0x3D<<7 | 0x47,
	28372 - 19968: jis0208<<14 | 0x3D<<7 | 0x4C,
	28373 - 19968: jis0208<<14 | 0x3D<<7 | 0x4D,
	28381 - 19968: jis0208<<14 | 0x21<<7 | 0x4B,
	28382 - 19968: jis0208<<14 | 0x21<<7 | 0x39,
	28395 - 19968: jis0212<<14 | 0x27<<7 | 0x1A,
	28396 - 19968: jis0208<<14 | 0x3D<<7 | 0x55,
	28397 - 19968: jis0212<<14 | 0x27<<7 | 0x1B,
	28398 - 19968: jis0212<<14 | 0x27<<7 | 0x1C,
	28399 - 19968: jis0208<<14 | 0x3D<<7 | 0x5B,
	28402 - 19968: jis0208<<14 | 0x3D<<7 | 0x59,
	28404 - 19968: jis0208<<14 | 0x24<<7 | 0x08,
	28407 - 19968: jis0208<<14 | 0x3E<<7 | 0x02,
	28408 - 19968: jis0208<<14 | 0x3D<<7 | 0x56,
	28409 - 19968: jis0212<<14 | 0x27<<7 | 0x1D,
	28411 - 19968: jis0212<<14 | 0x27<<7 | 0x1E,
	28413 - 19968: jis0212<<14 | 0x27<<7 | 0x1F,
	28414 - 19968: jis0208<<14 | 0x3D<<7 | 0x57,
	28415 - 19968: jis0208<<14 | 0x3D<<7 | 0x3F,
	28417 - 19968: jis0208<<14 | 0x14<<7 | 0x58,
	28418 - 19968: jis0208<<14 | 0x28<<7 | 0x19,
	28420 - 19968: jis0212<<14 | 0x27<<7 | 0x20,
	28422 - 19968: jis0208<<14 | 0x1B<<7 | 0x1E,
	28424 - 19968: jis0212<<14 | 0x27<<7 | 0x21,
	28425 - 19968: jis0208<<14 | 0x18<<7 | 0x56,
	28426 - 19968: jis0212<<14 | 0x27<<7 | 0x22,
	28428 - 19968: jis0212<<14 | 0x27<<7 | 0x23,
	28429 - 19968: jis0212<<14 | 0x27<<7 | 0x24,
	28431 - 19968: jis0208<<14 | 0x2E<<7 | 0x12,
	28433 - 19968: jis0208<<14 | 0x3D<<7 | 0x53,
	28435 - 19968: jis0208<<14 | 0x3E<<7 | 0x01,
	28436 - 19968: jis0208<<14 | 0x10<<7 | 0x48,
	28437 - 19968: jis0208<<14 | 0x20<<7 | 0x45,
	28438 - 19968: jis0212<<14 | 0x27<<7 | 0x25,
	28440 - 19968: jis0212<<14 | 0x27<<7 | 0x26,
	28442 - 19968: jis0212<<14 | 0x27<<7 | 0x27,
	28443 - 19968: jis0212<<14 | 0x27<<7 | 0x28,
	28448 - 19968: jis0208<<14 | 0x26<<7 | 0x58,
	28450 - 19968: jis0208<<14 | 0x13<<7 | 0x20,
	28451 - 19968: jis0208<<14 | 0x2D<<7 | 0x59,
	28454 - 19968: jis0212<<14 | 0x27<<7 | 0x29,
	28457 - 19968: jis0212<<14 | 0x27<<7 | 0x2A,
	28458 - 19968: jis0212<<14 | 0x27<<7 | 0x2B,
	28459 - 19968: jis0208<<14 | 0x2B<<7 | 0x00,
	28460 - 19968: jis0208<<14 | 0x23<<7 | 0x31,
	28461 - 19968: jis0212<<14 | 0x27<<7 | 0x32,
	28463 - 19968: jis0212<<14 | 0x27<<7 | 0x2C,
	28464 - 19968: jis0212<<14 | 0x27<<7 | 0x2D,
	28465 - 19968: jis0208<<14 | 0x3D<<7 | 0x5A,
	28466 - 19968: jis0208<<14 | 0x3D<<7 | 0x5C,
	28467 - 19968: jis0212<<14 | 0x27<<7 | 0x2E,
	28470 - 19968: jis0212<<14 | 0x27<<7 | 0x2F,
	28472 - 19968: jis0208<<14 | 0x20<<7 | 0x11,
	28475 - 19968: jis0212<<14 | 0x27<<7 | 0x30,
	28476 - 19968: jis0212<<14 | 0x27<<7 | 0x31,
	28478 - 19968: jis0208<<14 | 0x3E<<7 | 0x00,
	28479 - 19968: jis0208<<14 | 0x3D<<7 | 0x58,
	28481 - 19968: jis0208<<14 | 0x3D<<7 | 0x52,
	28485 - 19968: jis0208<<14 | 0x13<<7 | 0x22,
	28495 - 19968: jis0212<<14 | 0x27<<7 | 0x33,
	28497 - 19968: jis0212<<14 | 0x27<<7 | 0x34,
	28498 - 19968: jis0212<<14 | 0x27<<7 | 0x35,
	28499 - 19968: jis0212<<14 | 0x27<<7 | 0x36,
	28500 - 19968: jis0208<<14 | 0x16<<7 | 0x48,
	28503 - 19968: jis0212<<14 | 0x27<<7 | 0x37,
	28504 - 19968: jis0208<<14 | 0x3E<<7 | 0x0E,
	28505 - 19968: jis0212<<14 | 0x27<<7 | 0x38,
	28506 - 19968: jis0212<<14 | 0x27<<7 | 0x39,
	28507 - 19968: jis0208<<14 | 0x3E<<7 | 0x09,
	28508 - 19968: jis0208<<14 | 0x1F<<7 | 0x57,
	28509 - 19968: jis0212<<14 | 0x27<<7 | 0x3A,
	28510 - 19968: jis0212<<14 | 0x27<<7 | 0x3B,
	28511 - 19968: jis0208<<14 | 0x12<<7 | 0x42,
	28513 - 19968: jis0212<<14 | 0x27<<7 | 0x3C,
	28514 - 19968: jis0212<<14 | 0x27<<7 | 0x3D,
	28516 - 19968: jis0208<<14 | 0x1C<<7 | 0x40,
	28518 - 19968: jis0208<<14 | 0x3E<<7 | 0x12,
	28520 - 19968: jis0212<<14 | 0x27<<7 | 0x3E,
	28524 - 19968: jis0212<<14 | 0x27<<7 | 0x3F,
	28525 - 19968: jis0208<<14 | 0x3E<<7 | 0x0B,
	28526 - 19968: jis0208<<14 | 0x23<<7 | 0x0B,
	28527 - 19968: jis0208<<14 | 0x3E<<7 | 0x08,
	28528 - 19968: jis0208<<14 | 0x23<<7 | 0x38,
	28532 - 19968: jis0208<<14 | 0x3E<<7 | 0x2B,
	28536 - 19968: jis0208<<14 | 0x3E<<7 | 0x05,
	28538 - 19968: jis0208<<14 | 0x3E<<7 | 0x04,
	28540 - 19968: jis0208<<14 | 0x3E<<7 | 0x0D,
	28541 - 19968: jis0212<<14 | 0x27<<7 | 0x40,
	28542 - 19968: jis0212<<14 | 0x27<<7 | 0x41,
	28544 - 19968: jis0208<<14 | 0x3E<<7 | 0x07,
	28545 - 19968: jis0208<<14 | 0x3E<<7 | 0x06,
	28546 - 19968: jis0208<<14 | 0x3E<<7 | 0x0C,
	28547 - 19968: jis0212<<14 | 0x27<<7 | 0x42,
	28548 - 19968: jis0208<<14 | 0x1F<<7 | 0x00,
	28550 - 19968: jis0208<<14 | 0x3E<<7 | 0x03,
	28551 - 19968: jis0212<<14 | 0x27<<7 | 0x43,
	28552 - 19968: jis0208<<14 | 0x59<<7 | 0x4D,
	28555 - 19968: jis0212<<14 | 0x27<<7 | 0x45,
	28556 - 19968: jis0212<<14 | 0x27<<7 | 0x46,
	28557 - 19968: jis0212<<14 | 0x27<<7 | 0x47,
	28558 - 19968: jis0208<<14 | 0x3E<<7 | 0x0F,
	28560 - 19968: jis0212<<14 | 0x27<<7 | 0x48,
	28561 - 19968: jis0208<<14 | 0x3E<<7 | 0x10,
	28562 - 19968: jis0212<<14 | 0x27<<7 | 0x49,
	28563 - 19968: jis0212<<14 | 0x27<<7 | 0x4A,
	28564 - 19968: jis0212<<14 | 0x27<<7 | 0x4B,
	28566 - 19968: jis0212<<14 | 0x27<<7 | 0x4C,
	28567 - 19968: jis0208<<14 | 0x13<<7 | 0x21,
	28570 - 19968: jis0212<<14 | 0x27<<7 | 0x4D,
	28575 - 19968: jis0212<<14 | 0x27<<7 | 0x4E,
	28576 - 19968: jis0212<<14 | 0x27<<7 | 0x4F,
	28577 - 19968: jis0208<<14 | 0x3E<<7 | 0x15,
	28579 - 19968: jis0208<<14 | 0x3E<<7 | 0x14,
	28580 - 19968: jis0208<<14 | 0x3E<<7 | 0x16,
	28581 - 19968: jis0212<<14 | 0x27<<7 | 0x50,
	28582 - 19968: jis0212<<14 | 0x27<<7 | 0x51,
	28583 - 19968: jis0212<<14 | 0x27<<7 | 0x52,
	28584 - 19968: jis0212<<14 | 0x27<<7 | 0x53,
	28586 - 19968: jis0208<<14 | 0x3E<<7 | 0x19,
	28590 - 19968: jis0212<<14 | 0x27<<7 | 0x54,
	28591 - 19968: jis0212<<14 | 0x27<<7 | 0x55,
	28592 - 19968: jis0212<<14 | 0x27<<7 | 0x56,
	28593 - 19968: jis0208<<14 | 0x24<<7 | 0x22,
	28595 - 19968: jis0208<<14 | 0x3E<<7 | 0x13,
	28597 - 19968: jis0208<<14 | 0x59<<7 | 0x4E,
	28598 - 19968: jis0212<<14 | 0x27<<7 | 0x58,
	28601 - 19968: jis0208<<14 | 0x3E<<7 | 0x17,
	28604 - 19968: jis0212<<14 | 0x27<<7 | 0x59,
	28608 - 19968: jis0208<<14 | 0x16<<7 | 0x42,
	28609 - 19968: jis0208<<14 | 0x21<<7 | 0x58,
	28610 - 19968: jis0208<<14 | 0x3E<<7 | 0x11,
	28611 - 19968: jis0208<<14 | 0x26<<7 | 0x1A,
	28613 - 19968: jis0212<<14 | 0x27<<7 | 0x5A,
	28614 - 19968: jis0208<<14 | 0x3E<<7 | 0x18,
	28615 - 19968: jis0212<<14 | 0x27<<7 | 0x5B,
	28616 - 19968: jis0212<<14 | 0x27<<7 | 0x5C,
	28618 - 19968: jis0212<<14 | 0x27<<7 | 0x5D,
	28628 - 19968: jis0208<<14 | 0x3E<<7 | 0x1D,
	28629 - 19968: jis0208<<14 | 0x3E<<7 | 0x1B,
	28632 - 19968: jis0208<<14 | 0x3E<<7 | 0x1E,
	28634 - 19968: jis0212<<14 | 0x28<<7 | 0x00,
	28635 - 19968: jis0208<<14 | 0x3E<<7 | 0x21,
	28638 - 19968: jis0212<<14 | 0x28<<7 | 0x01,
	28639 - 19968: jis0208<<14 | 0x3E<<7 | 0x1A,
	28640 - 19968: jis0208<<14 | 0x18<<7 | 0x49,
	28641 - 19968: jis0208<<14 | 0x26<<7 | 0x07,
	28644 - 19968: jis0208<<14 | 0x3D<<7 | 0x18,
	28648 - 19968: jis0212<<14 | 0x28<<7 | 0x02,
	28649 - 19968: jis0212<<14 | 0x28<<7 | 0x03,
	28651 - 19968: jis0208<<14 | 0x2C<<7 | 0x53,
	28652 - 19968: jis0208<<14 | 0x3E<<7 | 0x1C,
	28654 - 19968: jis0208<<14 | 0x3E<<7 | 0x20,
	28655 - 19968: jis0208<<14 | 0x21<<7 | 0x54,
	28656 - 19968: jis0212<<14 | 0x28<<7 | 0x04,
	28657 - 19968: jis0208<<14 | 0x3E<<7 | 0x1F,
	28659 - 19968: jis0208<<14 | 0x3E<<7 | 0x0A,
	28661 - 19968: jis0208<<14 | 0x59<<7 | 0x4F,
	28662 - 19968: jis0208<<14 | 0x4E<<7 | 0x48,
	28665 - 19968: jis0212<<14 | 0x28<<7 | 0x06,
	28666 - 19968: jis0208<<14 | 0x3E<<7 | 0x24,
	28668 - 19968: jis0212<<14 | 0x28<<7 | 0x07,
	28669 - 19968: jis0212<<14 | 0x28<<7 | 0x08,
	28670 - 19968: jis0208<<14 | 0x3E<<7 | 0x28,
	28672 - 19968: jis0212<<14 | 0x28<<7 | 0x09,
	28673 - 19968: jis0208<<14 | 0x3E<<7 | 0x26,
	28677 - 19968: jis0208<<14 | 0x59<<7 | 0x50,
	28678 - 19968: jis0212<<14 | 0x28<<7 | 0x0B,
	28679 - 19968: jis0208<<14 | 0x59<<7 | 0x51,
	28681 - 19968: jis0208<<14 | 0x3E<<7 | 0x22,
	28683 - 19968: jis0208<<14 | 0x3E<<7 | 0x23,
	28685 - 19968: jis0212<<14 | 0x28<<7 | 0x0D,
	28687 - 19968: jis0208<<14 | 0x3E<<7 | 0x27,
	28689 - 19968: jis0208<<14 | 0x3E<<7 | 0x25,
	28693 - 19968: jis0208<<14 | 0x28<<7 | 0x2D,
	28695 - 19968: jis0212<<14 | 0x28<<7 | 0x0E,
	28696 - 19968: jis0208<<14 | 0x3E<<7 | 0x2D,
	28698 - 19968: jis0208<<14 | 0x3E<<7 | 0x2A,
	28699 - 19968: jis0208<<14 | 0x3E<<7 | 0x29,
	28701 - 19968: jis0208<<14 | 0x3E<<7 | 0x2C,
	28702 - 19968: jis0208<<14 | 0x25<<7 | 0x33,
	28703 - 19968: jis0208<<14 | 0x3E<<7 | 0x2E,
	28704 - 19968: jis0212<<14 | 0x28<<7 | 0x0F,
	28707 - 19968: jis0212<<14 | 0x28<<7 | 0x10,
	28710 - 19968: jis0208<<14 | 0x22<<7 | 0x54,
	28711 - 19968: jis0208<<14 | 0x21<<7 | 0x4C,
	28712 - 19968: jis0208<<14 | 0x59<<7 | 0x52,
	28716 - 19968: jis0208<<14 | 0x1F<<7 | 0x04,
	28719 - 19968: jis0212<<14 | 0x28<<7 | 0x11,
	28720 - 19968: jis0208<<14 | 0x3E<<7 | 0x2F,
	28722 - 19968: jis0208<<14 | 0x3E<<7 | 0x31,
	28724 - 19968: jis0212<<14 | 0x28<<7 | 0x12,
	28727 - 19968: jis0212<<14 | 0x28<<7 | 0x13,
	28729 - 19968: jis0212<<14 | 0x28<<7 | 0x14,
	28732 - 19968: jis0212<<14 | 0x28<<7 | 0x15,
	28734 - 19968: jis0208<<14 | 0x3E<<7 | 0x30,
	28739 - 19968: jis0212<<14 | 0x28<<7 | 0x16,
	28740 - 19968: jis0212<<14 | 0x28<<7 | 0x17,
	28744 - 19968: jis0212<<14 | 0x28<<7 | 0x18,
	28745 - 19968: jis0212<<14 | 0x28<<7 | 0x19,
	28746 - 19968: jis0212<<14 | 0x28<<7 | 0x1A,
	28747 - 19968: jis0212<<14 | 0x28<<7 | 0x1B,
	28748 - 19968: jis0208<<14 | 0x3D<<7 | 0x54,
	28750 - 19968: jis0212<<14 | 0x28<<7 | 0x20,
	28753 - 19968: jis0208<<14 | 0x3E<<7 | 0x32,
	28756 - 19968: jis0212<<14 | 0x28<<7 | 0x1C,
	28757 - 19968: jis0212<<14 | 0x28<<7 | 0x1D,
	28760 - 19968: jis0208<<14 | 0x25<<7 | 0x46,
	28765 - 19968: jis0212<<14 | 0x28<<7 | 0x1E,
	28766 - 19968: jis0212<<14 | 0x28<<7 | 0x1F,
	28771 - 19968: jis0208<<14 | 0x3E<<7 | 0x33,
	28772 - 19968: jis0212<<14 | 0x28<<7 | 0x21,
	28773 - 19968: jis0212<<14 | 0x28<<7 | 0x22,
	28779 - 19968: jis0208<<14 | 0x11<<7 | 0x2F,
	28780 - 19968: jis0212<<14 | 0x28<<7 | 0x23,
	28782 - 19968: jis0212<<14 | 0x28<<7 | 0x24,
	28783 - 19968: jis0208<<14 | 0x24<<7 | 0x53,
	28784 - 19968: jis0208<<14 | 0x12<<7 | 0x04,
	28789 - 19968: jis0212<<14 | 0x28<<7 | 0x25,
	28790 - 19968: jis0212<<14 | 0x28<<7 | 0x26,
	28792 - 19968: jis0208<<14 | 0x14<<7 | 0x43,
	28796 - 19968: jis0208<<14 | 0x1B<<7 | 0x3D,
	28797 - 19968: jis0208<<14 | 0x19<<7 | 0x31,
	28798 - 19968: jis0212<<14 | 0x28<<7 | 0x27,
	28801 - 19968: jis0212<<14 | 0x28<<7 | 0x28,
	28805 - 19968: jis0208<<14 | 0x59<<7 | 0x53,
	28806 - 19968: jis0212<<14 | 0x28<<7 | 0x2A,
	28809 - 19968: jis0208<<14 | 0x2E<<7 | 0x06,
	28810 - 19968: jis0208<<14 | 0x1E<<7 | 0x45,
	28814 - 19968: jis0208<<14 | 0x10<<7 | 0x49,
	28818 - 19968: jis0208<<14 | 0x3E<<7 | 0x35,
	28820 - 19968: jis0212<<14 | 0x28<<7 | 0x2B,
	28821 - 19968: jis0212<<14 | 0x28<<7 | 0x2C,
	28822 - 19968: jis0212<<14 | 0x28<<7 | 0x2D,
	28823 - 19968: jis0212<<14 | 0x28<<7 | 0x2E,
	28824 - 19968: jis0212<<14 | 0x28<<7 | 0x2F,
	28825 - 19968: jis0208<<14 | 0x3E<<7 | 0x34,
	28827 - 19968: jis0212<<14 | 0x28<<7 | 0x30,
	28836 - 19968: jis0212<<14 | 0x28<<7 | 0x31,
	28843 - 19968: jis0208<<14 | 0x59<<7 | 0x54,
	28844 - 19968: jis0208<<14 | 0x3E<<7 | 0x38,
	28845 - 19968: jis0208<<14 | 0x22<<7 | 0x19,
	28846 - 19968: jis0208<<14 | 0x3E<<7 | 0x3B,
	28847 - 19968: jis0208<<14 | 0x3E<<7 | 0x36,
	28848 - 19968: jis0212<<14 | 0x28<<7 | 0x33,
	28849 - 19968: jis0212<<14 | 0x28<<7 | 0x34,
	28851 - 19968: jis0208<<14 | 0x3E<<7 | 0x3A,
	28852 - 19968: jis0212<<14 | 0x28<<7 | 0x35,
	28855 - 19968: jis0212<<14 | 0x28<<7 | 0x36,
	28856 - 19968: jis0208<<14 | 0x3E<<7 | 0x39,
	28857 - 19968: jis0208<<14 | 0x24<<7 | 0x1F,
	28858 - 19968: jis0208<<14 | 0x0F<<7 | 0x38,
	28859 - 19968: jis0208<<14 | 0x58<<7 | 0x06,
	28872 - 19968: jis0208<<14 | 0x2D<<7 | 0x54,
	28874 - 19968: jis0212<<14 | 0x28<<7 | 0x37,
	28875 - 19968: jis0208<<14 | 0x3E<<7 | 0x3D,
	28879 - 19968: jis0208<<14 | 0x10<<7 | 0x07,
	28881 - 19968: jis0212<<14 | 0x28<<7 | 0x38,
	28883 - 19968: jis0212<<14 | 0x28<<7 | 0x39,
	28884 - 19968: jis0212<<14 | 0x28<<7 | 0x3A,
	28885 - 19968: jis0212<<14 | 0x28<<7 | 0x3B,
	28886 - 19968: jis0212<<14 | 0x28<<7 | 0x3C,
	28888 - 19968: jis0212<<14 | 0x28<<7 | 0x3D,
	28889 - 19968: jis0208<<14 | 0x3E<<7 | 0x3F,
	28892 - 19968: jis0212<<14 | 0x28<<7 | 0x3E,
	28893 - 19968: jis0208<<14 | 0x3E<<7 | 0x3E,
	28895 - 19968: jis0208<<14 | 0x3E<<7 | 0x3C,
	28900 - 19968: jis0212<<14 | 0x28<<7 | 0x3F,
	28913 - 19968: jis0208<<14 | 0x3E<<7 | 0x37,
	28921 - 19968: jis0208<<14 | 0x2A<<7 | 0x02,
	28922 - 19968: jis0212<<14 | 0x28<<7 | 0x40,
	28925 - 19968: jis0208<<14 | 0x3E<<7 | 0x41,
	28931 - 19968: jis0212<<14 | 0x28<<7 | 0x41,
	28932 - 19968: jis0208<<14 | 0x59<<7 | 0x56,
	28933 - 19968: jis0212<<14 | 0x28<<7 | 0x43,
	28934 - 19968: jis0212<<14 | 0x28<<7 | 0x44,
	28935 - 19968: jis0212<<14 | 0x28<<7 | 0x45,
	28937 - 19968: jis0208<<14 | 0x3E<<7 | 0x40,
	28939 - 19968: jis0212<<14 | 0x28<<7 | 0x46,
	28940 - 19968: jis0212<<14 | 0x28<<7 | 0x47,
	28943 - 19968: jis0208<<14 | 0x59<<7 | 0x55,
	28948 - 19968: jis0208<<14 | 0x10<<7 | 0x4A,
	28953 - 19968: jis0208<<14 | 0x3E<<7 | 0x43,
	28954 - 19968: jis0208<<14 | 0x29<<7 | 0x11,
	28956 - 19968: jis0208<<14 | 0x3E<<7 | 0x42,
	28958 - 19968: jis0212<<14 | 0x28<<7 | 0x49,
	28960 - 19968: jis0212<<14 | 0x28<<7 | 0x4A,
	28961 - 19968: jis0208<<14 | 0x2B<<7 | 0x14,
	28966 - 19968: jis0208<<14 | 0x1D<<7 | 0x26,
	28971 - 19968: jis0212<<14 | 0x28<<7 | 0x4B,
	28973 - 19968: jis0212<<14 | 0x28<<7 | 0x4C,
	28975 - 19968: jis0212<<14 | 0x28<<7 | 0x4D,
	28976 - 19968: jis0212<<14 | 0x28<<7 | 0x4E,
	28977 - 19968: jis0212<<14 | 0x28<<7 | 0x4F,
	28982 - 19968: jis0208<<14 | 0x20<<7 | 0x12,
	28984 - 19968: jis0212<<14 | 0x28<<7 | 0x50,
	28988 - 19968: jis0208<<14 | 0x1D<<7 | 0x25,
	28993 - 19968: jis0212<<14 | 0x28<<7 | 0x51,
	28997 - 19968: jis0212<<14 | 0x28<<7 | 0x52,
	28998 - 19968: jis0208<<14 | 0x59<<7 | 0x58,
	28999 - 19968: jis0208<<14 | 0x59<<7 | 0x59,
	29001 - 19968: jis0208<<14 | 0x2D<<7 | 0x5A,
	29002 - 19968: jis0212<<14 | 0x28<<7 | 0x55,
	29003 - 19968: jis0212<<14 | 0x28<<7 | 0x56,
	29004 - 19968: jis0208<<14 | 0x3E<<7 | 0x49,
	29006 - 19968: jis0208<<14 | 0x1F<<7 | 0x58,
	29008 - 19968: jis0212<<14 | 0x28<<7 | 0x57,
	29010 - 19968: jis0212<<14 | 0x28<<7 | 0x58,
	29013 - 19968: jis0208<<14 | 0x3E<<7 | 0x45,
	29014 - 19968: jis0208<<14 | 0x3E<<7 | 0x4A,
	29015 - 19968: jis0212<<14 | 0x28<<7 | 0x59,
	29017 - 19968: jis0208<<14 | 0x10<<7 | 0x4B,
	29018 - 19968: jis0212<<14 | 0x28<<7 | 0x5A,
	29020 - 19968: jis0208<<14 | 0x59<<7 | 0x57,
	29022 - 19968: jis0212<<14 | 0x28<<7 | 0x5C,
	29024 - 19968: jis0212<<14 | 0x28<<7 | 0x5D,
	29026 - 19968: jis0208<<14 | 0x3E<<7 | 0x48,
	29028 - 19968: jis0208<<14 | 0x26<<7 | 0x40,
	29029 - 19968: jis0208<<14 | 0x3E<<7 | 0x44,
	29030 - 19968: jis0208<<14 | 0x3E<<7 | 0x47,
	29031 - 19968: jis0208<<14 | 0x1D<<7 | 0x27,
	29032 - 19968: jis0212<<14 | 0x29<<7 | 0x00,
	29033 - 19968: jis0208<<14 | 0x27<<7 | 0x30,
	29036 - 19968: jis0208<<14 | 0x3E<<7 | 0x4B,
	29038 - 19968: jis0208<<14 | 0x1B<<7 | 0x30,
	29049 - 19968: jis0212<<14 | 0x29<<7 | 0x01,
	29053 - 19968: jis0208<<14 | 0x1F<<7 | 0x59,
	29056 - 19968: jis0212<<14 | 0x29<<7 | 0x02,
	29060 - 19968: jis0208<<14 | 0x3E<<7 | 0x4E,
	29061 - 19968: jis0212<<14 | 0x29<<7 | 0x03,
	29063 - 19968: jis0212<<14 | 0x29<<7 | 0x04,
	29064 - 19968: jis0208<<14 | 0x3E<<7 | 0x46,
	29066 - 19968: jis0208<<14 | 0x16<<7 | 0x06,
	29068 - 19968: jis0212<<14 | 0x29<<7 | 0x05,
	29071 - 19968: jis0208<<14 | 0x3E<<7 | 0x4C,
	29074 - 19968: jis0212<<14 | 0x29<<7 | 0x06,
	29076 - 19968: jis0208<<14 | 0x2C<<7 | 0x2F,
	29077 - 19968: jis0208<<14 | 0x3E<<7 | 0x4F,
	29081 - 19968: jis0208<<14 | 0x53<<7 | 0x05,
	29082 - 19968: jis0212<<14 | 0x29<<7 | 0x07,
	29083 - 19968: jis0212<<14 | 0x29<<7 | 0x08,
	29087 - 19968: jis0208<<14 | 0x1C<<7 | 0x2E,
	29088 - 19968: jis0212<<14 | 0x29<<7 | 0x09,
	29090 - 19968: jis0212<<14 | 0x29<<7 | 0x0A,
	29096 - 19968: jis0208<<14 | 0x3E<<7 | 0x50,
	29100 - 19968: jis0208<<14 | 0x3E<<7 | 0x51,
	29103 - 19968: jis0212<<14 | 0x29<<7 | 0x0B,
	29104 - 19968: jis0212<<14 | 0x29<<7 | 0x0C,
	29105 - 19968: jis0208<<14 | 0x26<<7 | 0x0D,
	29106 - 19968: jis0212<<14 | 0x29<<7 | 0x0D,
	29107 - 19968: jis0212<<14 | 0x29<<7 | 0x0E,
	29113 - 19968: jis0208<<14 | 0x3E<<7 | 0x53,
	29114 - 19968: jis0212<<14 | 0x29<<7 | 0x0F,
	29118 - 19968: jis0208<<14 | 0x3E<<7 | 0x54,
	29119 - 19968: jis0212<<14 | 0x29<<7 | 0x10,
	29120 - 19968: jis0212<<14 | 0x29<<7 | 0x11,
	29121 - 19968: jis0208<<14 | 0x59<<7 | 0x5B,
	29123 - 19968: jis0208<<14 | 0x26<<7 | 0x12,
	29124 - 19968: jis0212<<14 | 0x29<<7 | 0x13,
	29128 - 19968: jis0208<<14 | 0x24<<7 | 0x54,
	29129 - 19968: jis0208<<14 | 0x3E<<7 | 0x56,
	29131 - 19968: jis0212<<14 | 0x29<<7 | 0x14,
	29132 - 19968: jis0212<<14 | 0x29<<7 | 0x15,
	29134 - 19968: jis0208<<14 | 0x3E<<7 | 0x58,
	29136 - 19968: jis0208<<14 | 0x2D<<7 | 0x34,
	29138 - 19968: jis0208<<14 | 0x3E<<7 | 0x55,
	29139 - 19968: jis0212<<14 | 0x29<<7 | 0x16,
	29140 - 19968: jis0208<<14 | 0x3E<<7 | 0x57,
	29141 - 19968: jis0208<<14 | 0x10<<7 | 0x4C,
	29142 - 19968: jis0212<<14 | 0x29<<7 | 0x17,
	29143 - 19968: jis0208<<14 | 0x3E<<7 | 0x52,
	29145 - 19968: jis0212<<14 | 0x29<<7 | 0x18,
	29146 - 19968: jis0212<<14 | 0x29<<7 | 0x19,
	29148 - 19968: jis0212<<14 | 0x29<<7 | 0x1A,
	29151 - 19968: jis0208<<14 | 0x32<<7 | 0x3A,
	29152 - 19968: jis0208<<14 | 0x3E<<7 | 0x59,
	29157 - 19968: jis0208<<14 | 0x20<<7 | 0x46,
	29158 - 19968: jis0208<<14 | 0x1A<<7 | 0x17,
	29159 - 19968: jis0208<<14 | 0x3E<<7 | 0x5B,
	29164 - 19968: jis0208<<14 | 0x3E<<7 | 0x5A,
	29165 - 19968: jis0208<<14 | 0x1E<<7 | 0x03,
	29166 - 19968: jis0208<<14 | 0x31<<7 | 0x38,
	29173 - 19968: jis0208<<14 | 0x3E<<7 | 0x5C,
	29176 - 19968: jis0212<<14 | 0x29<<7 | 0x1B,
	29177 - 19968: jis0208<<14 | 0x3F<<7 | 0x00,
	29179 - 19968: jis0208<<14 | 0x3E<<7 | 0x4D,
	29180 - 19968: jis0208<<14 | 0x3E<<7 | 0x5D,
	29182 - 19968: jis0208<<14 | 0x59<<7 | 0x5C,
	29183 - 19968: jis0208<<14 | 0x3F<<7 | 0x01,
	29184 - 19968: jis0212<<14 | 0x29<<7 | 0x1D,
	29190 - 19968: jis0208<<14 | 0x26<<7 | 0x59,
	29191 - 19968: jis0212<<14 | 0x29<<7 | 0x1E,
	29192 - 19968: jis0212<<14 | 0x29<<7 | 0x1F,
	29193 - 19968: jis0212<<14 | 0x29<<7 | 0x20,
	29197 - 19968: jis0208<<14 | 0x3F<<7 | 0x02,
	29200 - 19968: jis0208<<14 | 0x3F<<7 | 0x03,
	29203 - 19968: jis0212<<14 | 0x29<<7 | 0x21,
	29207 - 19968: jis0212<<14 | 0x29<<7 | 0x22,
	29210 - 19968: jis0212<<14 | 0x29<<7 | 0x23,
	29211 - 19968: jis0208<<14 | 0x3F<<7 | 0x04,
	29213 - 19968: jis0212<<14 | 0x29<<7 | 0x24,
	29215 - 19968: jis0212<<14 | 0x29<<7 | 0x25,
	29220 - 19968: jis0212<<14 | 0x29<<7 | 0x26,
	29224 - 19968: jis0208<<14 | 0x3F<<7 | 0x05,
	29226 - 19968: jis0208<<14 | 0x23<<7 | 0x3D,
	29227 - 19968: jis0212<<14 | 0x29<<7 | 0x27,
	29228 - 19968: jis0208<<14 | 0x3F<<7 | 0x07,
	29229 - 19968: jis0208<<14 | 0x3F<<7 | 0x06,
	29231 - 19968: jis0212<<14 | 0x29<<7 | 0x28,
	29232 - 19968: jis0208<<14 | 0x3F<<7 | 0x08,
	29234 - 19968: jis0208<<14 | 0x3F<<7 | 0x09,
	29236 - 19968: jis0212<<14 | 0x29<<7 | 0x29,
	29237 - 19968: jis0208<<14 | 0x1B<<7 | 0x3E,
	29238 - 19968: jis0208<<14 | 0x28<<7 | 0x42,
	29240 - 19968: jis0212<<14 | 0x29<<7 | 0x2A,
	29241 - 19968: jis0212<<14 | 0x29<<7 | 0x2B,
	29242 - 19968: jis0208<<14 | 0x2B<<7 | 0x4B,
	29243 - 19968: jis0208<<14 | 0x3F<<7 | 0x0A,
	29244 - 19968: jis0208<<14 | 0x3F<<7 | 0x0B,
	29245 - 19968: jis0208<<14 | 0x20<<7 | 0x35,
	29246 - 19968: jis0208<<14 | 0x1B<<7 | 0x03,
	29247 - 19968: jis0208<<14 | 0x3F<<7 | 0x0C,
	29248 - 19968: jis0208<<14 | 0x3F<<7 | 0x0D,
	29249 - 19968: jis0212<<14 | 0x29<<7 | 0x2C,
	29250 - 19968: jis0212<<14 | 0x29<<7 | 0x2D,
	29251 - 19968: jis0212<<14 | 0x29<<7 | 0x2E,
	29253 - 19968: jis0212<<14 | 0x29<<7 | 0x2F,
	29254 - 19968: jis0208<<14 | 0x3F<<7 | 0x0E,
	29255 - 19968: jis0208<<14 | 0x29<<7 | 0x31,
	29256 - 19968: jis0208<<14 | 0x27<<7 | 0x26,
	29259 - 19968: jis0208<<14 | 0x3F<<7 | 0x0F,
	29260 - 19968: jis0208<<14 | 0x26<<7 | 0x36,
	29262 - 19968: jis0212<<14 | 0x29<<7 | 0x30,
	29263 - 19968: jis0212<<14 | 0x29<<7 | 0x31,
	29264 - 19968: jis0212<<14 | 0x29<<7 | 0x32,
	29266 - 19968: jis0208<<14 | 0x23<<7 | 0x0C,
	29267 - 19968: jis0212<<14 | 0x29<<7 | 0x33,
	29269 - 19968: jis0212<<14 | 0x29<<7 | 0x34,
	29270 - 19968: jis0212<<14 | 0x29<<7 | 0x35,
	29272 - 19968: jis0208<<14 | 0x3F<<7 | 0x10,
	29273 - 19968: jis0208<<14 | 0x11<<7 | 0x46,
	29274 - 19968: jis0212<<14 | 0x29<<7 | 0x36,
	29275 - 19968: jis0208<<14 | 0x14<<7 | 0x4C,
	29276 - 19968: jis0212<<14 | 0x29<<7 | 0x37,
	29277 - 19968: jis0208<<14 | 0x2B<<7 | 0x25,
	29278 - 19968: jis0212<<14 | 0x29<<7 | 0x38,
	29279 - 19968: jis0208<<14 | 0x2B<<7 | 0x15,
	29280 - 19968: jis0212<<14 | 0x29<<7 | 0x39,
	29281 - 19968: jis0208<<14 | 0x11<<7 | 0x13,
	29282 - 19968: jis0208<<14 | 0x2E<<7 | 0x13,
	29283 - 19968: jis0212<<14 | 0x29<<7 | 0x3A,
	29287 - 19968: jis0208<<14 | 0x2A<<7 | 0x31,
	29288 - 19968: jis0212<<14 | 0x29<<7 | 0x3B,
	29289 - 19968: jis0208<<14 | 0x29<<7 | 0x09,
	29291 - 19968: jis0212<<14 | 0x29<<7 | 0x3C,
	29294 - 19968: jis0212<<14 | 0x29<<7 | 0x3D,
	29295 - 19968: jis0212<<14 | 0x29<<7 | 0x3E,
	29297 - 19968: jis0212<<14 | 0x29<<7 | 0x3F,
	29298 - 19968: jis0208<<14 | 0x1F<<7 | 0x16,
	29300 - 19968: jis0208<<14 | 0x3F<<7 | 0x11,
	29303 - 19968: jis0212<<14 | 0x29<<7 | 0x40,
	29304 - 19968: jis0212<<14 | 0x29<<7 | 0x41,
	29305 - 19968: jis0208<<14 | 0x25<<7 | 0x22,
	29307 - 19968: jis0212<<14 | 0x29<<7 | 0x42,
	29308 - 19968: jis0212<<14 | 0x29<<7 | 0x43,
	29309 - 19968: jis0208<<14 | 0x17<<7 | 0x02,
	29310 - 19968: jis0208<<14 | 0x3F<<7 | 0x12,
	29311 - 19968: jis0212<<14 | 0x29<<7 | 0x44,
	29312 - 19968: jis0208<<14 | 0x19<<7 | 0x33,
	29313 - 19968: jis0208<<14 | 0x3F<<7 | 0x14,
	29314 - 19968: jis0208<<14 | 0x3F<<7 | 0x13,
	29316 - 19968: jis0212<<14 | 0x29<<7 | 0x45,
	29319 - 19968: jis0208<<14 | 0x3F<<7 | 0x15,
	29321 - 19968: jis0212<<14 | 0x29<<7 | 0x46,
	29325 - 19968: jis0212<<14 | 0x29<<7 | 0x47,
	29326 - 19968: jis0212<<14 | 0x29<<7 | 0x48,
	29330 - 19968: jis0208<<14 | 0x3F<<7 | 0x16,
	29331 - 19968: jis0212<<14 | 0x29<<7 | 0x49,
	29334 - 19968: jis0208<<14 | 0x3F<<7 | 0x17,
	29339 - 19968: jis0212<<14 | 0x29<<7 | 0x4A,
	29344 - 19968: jis0208<<14 | 0x14<<7 | 0x1D,
	29346 - 19968: jis0208<<14 | 0x3F<<7 | 0x18,
	29351 - 19968: jis0208<<14 | 0x3F<<7 | 0x19,
	29352 - 19968: jis0212<<14 | 0x29<<7 | 0x4B,
	29356 - 19968: jis0208<<14 | 0x17<<7 | 0x03,
	29357 - 19968: jis0212<<14 | 0x29<<7 | 0x4C,
	29358 - 19968: jis0212<<14 | 0x29<<7 | 0x4D,
	29359 - 19968: jis0208<<14 | 0x27<<7 | 0x27,
	29361 - 19968: jis0208<<14 | 0x59<<7 | 0x5D,
	29362 - 19968: jis0208<<14 | 0x3F<<7 | 0x1B,
	29364 - 19968: jis0212<<14 | 0x29<<7 | 0x4F,
	29366 - 19968: jis0208<<14 | 0x1D<<7 | 0x54,
	29369 - 19968: jis0208<<14 | 0x3F<<7 | 0x1A,
	29374 - 19968: jis0208<<14 | 0x5A<<7 | 0x00,
	29377 - 19968: jis0212<<14 | 0x29<<7 | 0x51,
	29378 - 19968: jis0208<<14 | 0x15<<7 | 0x17,
	29379 - 19968: jis0208<<14 | 0x3F<<7 | 0x1C,
	29380 - 19968: jis0208<<14 | 0x3F<<7 | 0x1E,
	29382 - 19968: jis0208<<14 | 0x3F<<7 | 0x1D,
	29383 - 19968: jis0212<<14 | 0x29<<7 | 0x52,
	29385 - 19968: jis0212<<14 | 0x29<<7 | 0x53,
	29388 - 19968: jis0212<<14 | 0x29<<7 | 0x54,
	29390 - 19968: jis0208<<14 | 0x3F<<7 | 0x1F,
	29392 - 19968: jis0208<<14 | 0x17<<7 | 0x30,
	29394 - 19968: jis0208<<14 | 0x3F<<7 | 0x20,
	29397 - 19968: jis0212<<14 | 0x29<<7 | 0x55,
	29398 - 19968: jis0212<<14 | 0x29<<7 | 0x56,
	29399 - 19968: jis0208<<14 | 0x15<<7 | 0x48,
	29400 - 19968: jis0212<<14 | 0x29<<7 | 0x57,
	29401 - 19968: jis0208<<14 | 0x20<<7 | 0x1F,
	29403 - 19968: jis0208<<14 | 0x18<<7 | 0x5C,
	29407 - 19968: jis0212<<14 | 0x29<<7 | 0x58,
	29408 - 19968: jis0208<<14 | 0x3F<<7 | 0x22,
	29409 - 19968: jis0208<<14 | 0x3F<<7 | 0x23,
	29410 - 19968: jis0208<<14 | 0x3F<<7 | 0x21,
	29413 - 19968: jis0212<<14 | 0x29<<7 | 0x59,
	29417 - 19968: jis0208<<14 | 0x1B<<7 | 0x4C,
	29420 - 19968: jis0208<<14 | 0x25<<7 | 0x27,
	29421 - 19968: jis0208<<14 | 0x15<<7 | 0x18,
	29427 - 19968: jis0212<<14 | 0x29<<7 | 0x5A,
	29428 - 19968: jis0212<<14 | 0x29<<7 | 0x5B,
	29431 - 19968: jis0208<<14 | 0x3F<<7 | 0x25,
	29432 - 19968: jis0208<<14 | 0x22<<7 | 0x0B,
	29433 - 19968: jis0208<<14 | 0x3F<<7 | 0x24,
	29434 - 19968: jis0212<<14 | 0x29<<7 | 0x5C,
	29435 - 19968: jis0212<<14 | 0x29<<7 | 0x5D,
	29436 - 19968: jis0208<<14 | 0x2E<<7 | 0x14,
	29437 - 19968: jis0208<<14 | 0x26<<7 | 0x41,
	29438 - 19968: jis0212<<14 | 0x2A<<7 | 0x00,
	29442 - 19968: jis0212<<14 | 0x2A<<7 | 0x01,
	29444 - 19968: jis0212<<14 | 0x2A<<7 | 0x02,
	29445 - 19968: jis0212<<14 | 0x2A<<7 | 0x03,
	29447 - 19968: jis0212<<14 | 0x2A<<7 | 0x04,
	29450 - 19968: jis0208<<14 | 0x3F<<7 | 0x28,
	29451 - 19968: jis0212<<14 | 0x2A<<7 | 0x05,
	29453 - 19968: jis0212<<14 | 0x2A<<7 | 0x06,
	29458 - 19968: jis0212<<14 | 0x2A<<7 | 0x07,
	29459 - 19968: jis0212<<14 | 0x2A<<7 | 0x08,
	29462 - 19968: jis0208<<14 | 0x3F<<7 | 0x2A,
	29463 - 19968: jis0208<<14 | 0x3F<<7 | 0x27,
	29464 - 19968: jis0212<<14 | 0x2A<<7 | 0x09,
	29465 - 19968: jis0212<<14 | 0x2A<<7 | 0x0A,
	29467 - 19968: jis0208<<14 | 0x2B<<7 | 0x33,
	29468 - 19968: jis0208<<14 | 0x3F<<7 | 0x29,
	29469 - 19968: jis0208<<14 | 0x3F<<7 | 0x2B,
	29470 - 19968: jis0212<<14 | 0x2A<<7 | 0x0B,
	29471 - 19968: jis0208<<14 | 0x2D<<7 | 0x23,
	29474 - 19968: jis0212<<14 | 0x2A<<7 | 0x0C,
	29476 - 19968: jis0208<<14 | 0x5A<<7 | 0x01,
	29477 - 19968: jis0208<<14 | 0x3F<<7 | 0x2F,
	29479 - 19968: jis0212<<14 | 0x2A<<7 | 0x0E,
	29480 - 19968: jis0212<<14 | 0x2A<<7 | 0x0F,
	29481 - 19968: jis0208<<14 | 0x3F<<7 | 0x2E,
	29482 - 19968: jis0208<<14 | 0x22<<7 | 0x55,
	29483 - 19968: jis0208<<14 | 0x26<<7 | 0x0C,
	29484 - 19968: jis0212<<14 | 0x2A<<7 | 0x10,
	29486 - 19968: jis0208<<14 | 0x17<<7 | 0x04,
	29487 - 19968: jis0208<<14 | 0x3F<<7 | 0x2D,
	29489 - 19968: jis0212<<14 | 0x2A<<7 | 0x11,
	29490 - 19968: jis0212<<14 | 0x2A<<7 | 0x12,
	29492 - 19968: jis0208<<14 | 0x3F<<7 | 0x2C,
	29493 - 19968: jis0212<<14 | 0x2A<<7 | 0x13,
	29494 - 19968: jis0208<<14 | 0x2C<<7 | 0x10,
	29495 - 19968: jis0208<<14 | 0x2C<<7 | 0x11,
	29498 - 19968: jis0212<<14 | 0x2A<<7 | 0x14,
	29499 - 19968: jis0212<<14 | 0x2A<<7 | 0x15,
	29501 - 19968: jis0212<<14 | 0x2A<<7 | 0x16,
	29502 - 19968: jis0208<<14 | 0x3F<<7 | 0x30,
	29503 - 19968: jis0208<<14 | 0x10<<7 | 0x4D,
	29507 - 19968: jis0212<<14 | 0x2A<<7 | 0x17,
	29508 - 19968: jis0208<<14 | 0x18<<7 | 0x55,
	29509 - 19968: jis0208<<14 | 0x1A<<7 | 0x41,
	29517 - 19968: jis0212<<14 | 0x2A<<7 | 0x18,
	29518 - 19968: jis0208<<14 | 0x3F<<7 | 0x31,
	29519 - 19968: jis0208<<14 | 0x3F<<7 | 0x32,
	29520 - 19968: jis0212<<14 | 0x2A<<7 | 0x19,
	29522 - 19968: jis0212<<14 | 0x2A<<7 | 0x1A,
	29526 - 19968: jis0212<<14 | 0x2A<<7 | 0x1B,
	29527 - 19968: jis0208<<14 | 0x3F<<7 | 0x34,
	29528 - 19968: jis0212<<14 | 0x2A<<7 | 0x1C,
	29533 - 19968: jis0212<<14 | 0x2A<<7 | 0x1D,
	29534 - 19968: jis0212<<14 | 0x2A<<7 | 0x1E,
	29535 - 19968: jis0212<<14 | 0x2A<<7 | 0x1F,
	29536 - 19968: jis0212<<14 | 0x2A<<7 | 0x20,
	29539 - 19968: jis0208<<14 | 0x1C<<7 | 0x22,
	29542 - 19968: jis0212<<14 | 0x2A<<7 | 0x21,
	29543 - 19968: jis0212<<14 | 0x2A<<7 | 0x22,
	29544 - 19968: jis0208<<14 | 0x3F<<7 | 0x36,
	29545 - 19968: jis0212<<14 | 0x2A<<7 | 0x23,
	29546 - 19968: jis0208<<14 | 0x3F<<7 | 0x35,
	29547 - 19968: jis0212<<14 | 0x2A<<7 | 0x24,
	29548 - 19968: jis0212<<14 | 0x2A<<7 | 0x25,
	29550 - 19968: jis0212<<14 | 0x2A<<7 | 0x26,
	29551 - 19968: jis0212<<14 | 0x2A<<7 | 0x27,
	29552 - 19968: jis0208<<14 | 0x3F<<7 | 0x37,
	29553 - 19968: jis0212<<14 | 0x2A<<7 | 0x28,
	29554 - 19968: jis0208<<14 | 0x12<<7 | 0x2C,
	29557 - 19968: jis0208<<14 | 0x3F<<7 | 0x39,
	29559 - 19968: jis0208<<14 | 0x5A<<7 | 0x03,
	29560 - 19968: jis0208<<14 | 0x3F<<7 | 0x38,
	29561 - 19968: jis0212<<14 | 0x2A<<7 | 0x2A,
	29562 - 19968: jis0208<<14 | 0x3F<<7 | 0x3B,
	29563 - 19968: jis0208<<14 | 0x3F<<7 | 0x3A,
	29564 - 19968: jis0212<<14 | 0x2A<<7 | 0x2B,
	29568 - 19968: jis0212<<14 | 0x2A<<7 | 0x2C,
	29569 - 19968: jis0212<<14 | 0x2A<<7 | 0x2D,
	29571 - 19968: jis0212<<14 | 0x2A<<7 | 0x2E,
	29572 - 19968: jis0208<<14 | 0x17<<7 | 0x1B,
	29573 - 19968: jis0212<<14 | 0x2A<<7 | 0x2F,
	29574 - 19968: jis0212<<14 | 0x2A<<7 | 0x30,
	29575 - 19968: jis0208<<14 | 0x2D<<7 | 0x07,
	29577 - 19968: jis0208<<14 | 0x15<<7 | 0x2B,
	29579 - 19968: jis0208<<14 | 0x11<<7 | 0x05,
	29582 - 19968: jis0212<<14 | 0x2A<<7 | 0x31,
	29584 - 19968: jis0212<<14 | 0x2A<<7 | 0x32,
	29587 - 19968: jis0212<<14 | 0x2A<<7 | 0x33,
	29589 - 19968: jis0212<<14 | 0x2A<<7 | 0x34,
	29590 - 19968: jis0208<<14 | 0x15<<7 | 0x49,
	29591 - 19968: jis0212<<14 | 0x2A<<7 | 0x35,
	29592 - 19968: jis0212<<14 | 0x2A<<7 | 0x36,
	29596 - 19968: jis0212<<14 | 0x2A<<7 | 0x37,
	29598 - 19968: jis0212<<14 | 0x2A<<7 | 0x38,
	29599 - 19968: jis0212<<14 | 0x2A<<7 | 0x39,
	29600 - 19968: jis0212<<14 | 0x2A<<7 | 0x3A,
	29602 - 19968: jis0212<<14 | 0x2A<<7 | 0x3B,
	29605 - 19968: jis0212<<14 | 0x2A<<7 | 0x3C,
	29606 - 19968: jis0212<<14 | 0x2A<<7 | 0x3D,
	29609 - 19968: jis0208<<14 | 0x13<<7 | 0x40,
	29610 - 19968: jis0212<<14 | 0x2A<<7 | 0x3E,
	29611 - 19968: jis0212<<14 | 0x2A<<7 | 0x3F,
	29613 - 19968: jis0212<<14 | 0x2A<<7 | 0x40,
	29618 - 19968: jis0208<<14 | 0x2D<<7 | 0x47,
	29619 - 19968: jis0208<<14 | 0x3F<<7 | 0x3D,
	29621 - 19968: jis0212<<14 | 0x2A<<7 | 0x41,
	29623 - 19968: jis0212<<14 | 0x2A<<7 | 0x42,
	29625 - 19968: jis0212<<14 | 0x2A<<7 | 0x43,
	29627 - 19968: jis0208<<14 | 0x3F<<7 | 0x3F,
	29628 - 19968: jis0212<<14 | 0x2A<<7 | 0x44,
	29629 - 19968: jis0208<<14 | 0x5A<<7 | 0x04,
	29631 - 19968: jis0212<<14 | 0x2A<<7 | 0x46,
	29632 - 19968: jis0208<<14 | 0x3F<<7 | 0x40,
	29634 - 19968: jis0208<<14 | 0x11<<7 | 0x30,
	29637 - 19968: jis0212<<14 | 0x2A<<7 | 0x47,
	29638 - 19968: jis0212<<14 | 0x2A<<7 | 0x48,
	29640 - 19968: jis0208<<14 | 0x3F<<7 | 0x3C,
	29641 - 19968: jis0208<<14 | 0x5A<<7 | 0x05,
	29642 - 19968: jis0208<<14 | 0x1A<<7 | 0x18,
	29643 - 19968: jis0212<<14 | 0x2A<<7 | 0x4A,
	29644 - 19968: jis0212<<14 | 0x2A<<7 | 0x4B,
	29645 - 19968: jis0208<<14 | 0x23<<7 | 0x20,
	29646 - 19968: jis0208<<14 | 0x3F<<7 | 0x3E,
	29647 - 19968: jis0212<<14 | 0x2A<<7 | 0x4C,
	29650 - 19968: jis0208<<14 | 0x5A<<7 | 0x08,
	29651 - 19968: jis0212<<14 | 0x2A<<7 | 0x4E,
	29654 - 19968: jis0208<<14 | 0x5A<<7 | 0x06,
	29657 - 19968: jis0212<<14 | 0x2A<<7 | 0x50,
	29661 - 19968: jis0212<<14 | 0x2A<<7 | 0x51,
	29662 - 19968: jis0208<<14 | 0x3F<<7 | 0x43,
	29664 - 19968: jis0208<<14 | 0x1B<<7 | 0x4D,
	29665 - 19968: jis0212<<14 | 0x2A<<7 | 0x52,
	29667 - 19968: jis0208<<14 | 0x5A<<7 | 0x07,
	29669 - 19968: jis0208<<14 | 0x3F<<7 | 0x41,
	29670 - 19968: jis0212<<14 | 0x2A<<7 | 0x54,
	29671 - 19968: jis0212<<14 | 0x2A<<7 | 0x55,
	29673 - 19968: jis0212<<14 | 0x2A<<7 | 0x56,
	29674 - 19968: jis0208<<14 | 0x16<<7 | 0x1D,
	29677 - 19968: jis0208<<14 | 0x27<<7 | 0x28,
	29678 - 19968: jis0208<<14 | 0x3F<<7 | 0x42,
	29681 - 19968: jis0208<<14 | 0x3F<<7 | 0x5D,
	29684 - 19968: jis0212<<14 | 0x2A<<7 | 0x57,
	29685 - 19968: jis0208<<14 | 0x5A<<7 | 0x0A,
	29687 - 19968: jis0212<<14 | 0x2A<<7 | 0x59,
	29688 - 19968: jis0208<<14 | 0x3F<<7 | 0x48,
	29689 - 19968: jis0212<<14 | 0x2A<<7 | 0x5A,
	29690 - 19968: jis0212<<14 | 0x2A<<7 | 0x5B,
	29691 - 19968: jis0212<<14 | 0x2A<<7 | 0x5C,
	29693 - 19968: jis0212<<14 | 0x2A<<7 | 0x5D,
	29694 - 19968: jis0208<<14 | 0x17<<7 | 0x1C,
	29695 - 19968: jis0212<<14 | 0x2B<<7 | 0x00,
	29696 - 19968: jis0212<<14 | 0x2B<<7 | 0x01,
	29697 - 19968: jis0212<<14 | 0x2B<<7 | 0x02,
	29699 - 19968: jis0208<<14 | 0x14<<7 | 0x44,
	29700 - 19968: jis0212<<14 | 0x2B<<7 | 0x03,
	29701 - 19968: jis0208<<14 | 0x3F<<7 | 0x45,
	29702 - 19968: jis0208<<14 | 0x2C<<7 | 0x5C,
	29703 - 19968: jis0208<<14 | 0x5A<<7 | 0x09,
	29705 - 19968: jis0208<<14 | 0x2D<<7 | 0x0F,
	29706 - 19968: jis0212<<14 | 0x2B<<7 | 0x05,
	29713 - 19968: jis0212<<14 | 0x2B<<7 | 0x06,
	29722 - 19968: jis0212<<14 | 0x2B<<7 | 0x07,
	29723 - 19968: jis0212<<14 | 0x2B<<7 | 0x08,
	29730 - 19968: jis0208<<14 | 0x21<<7 | 0x55,
	29732 - 19968: jis0212<<14 | 0x2B<<7 | 0x09,
	29733 - 19968: jis0208<<14 | 0x3F<<7 | 0x47,
	29734 - 19968: jis0208<<14 | 0x5A<<7 | 0x0B,
	29736 - 19968: jis0212<<14 | 0x2B<<7 | 0x0B,
	29737 - 19968: jis0208<<14 | 0x5A<<7 | 0x0D,
	29738 - 19968: jis0208<<14 | 0x5A<<7 | 0x0C,
	29739 - 19968: jis0212<<14 | 0x2B<<7 | 0x0E,
	29740 - 19968: jis0212<<14 | 0x2B<<7 | 0x0F,
	29741 - 19968: jis0212<<14 | 0x2B<<7 | 0x10,
	29742 - 19968: jis0208<<14 | 0x5A<<7 | 0x0E,
	29743 - 19968: jis0212<<14 | 0x2B<<7 | 0x12,
	29744 - 19968: jis0212<<14 | 0x2B<<7 | 0x13,
	29745 - 19968: jis0212<<14 | 0x2B<<7 | 0x14,
	29746 - 19968: jis0208<<14 | 0x3F<<7 | 0x49,
	29747 - 19968: jis0208<<14 | 0x2D<<7 | 0x35,
	29748 - 19968: jis0208<<14 | 0x15<<7 | 0x36,
	29749 - 19968: jis0208<<14 | 0x27<<7 | 0x5B,
	29750 - 19968: jis0208<<14 | 0x26<<7 | 0x29,
	29753 - 19968: jis0212<<14 | 0x2B<<7 | 0x15,
	29754 - 19968: jis0208<<14 | 0x3F<<7 | 0x4A,
	29759 - 19968: jis0208<<14 | 0x3F<<7 | 0x4C,
	29760 - 19968: jis0212<<14 | 0x2B<<7 | 0x16,
	29761 - 19968: jis0208<<14 | 0x3F<<7 | 0x4F,
	29763 - 19968: jis0212<<14 | 0x2B<<7 | 0x17,
	29764 - 19968: jis0212<<14 | 0x2B<<7 | 0x18,
	29766 - 19968: jis0212<<14 | 0x2B<<7 | 0x19,
	29767 - 19968: jis0212<<14 | 0x2B<<7 | 0x1A,
	29771 - 19968: jis0212<<14 | 0x2B<<7 | 0x1B,
	29773 - 19968: jis0212<<14 | 0x2B<<7 | 0x1C,
	29777 - 19968: jis0212<<14 | 0x2B<<7 | 0x1D,
	29778 - 19968: jis0212<<14 | 0x2B<<7 | 0x1E,
	29781 - 19968: jis0208<<14 | 0x3F<<7 | 0x4B,
	29783 - 19968: jis0212<<14 | 0x2B<<7 | 0x1F,
	29785 - 19968: jis0208<<14 | 0x3F<<7 | 0x4E,
	29786 - 19968: jis0208<<14 | 0x17<<7 | 0x49,
	29787 - 19968: jis0208<<14 | 0x10<<7 | 0x2C,
	29788 - 19968: jis0208<<14 | 0x3F<<7 | 0x50,
	29789 - 19968: jis0212<<14 | 0x2B<<7 | 0x20,
	29790 - 19968: jis0208<<14 | 0x1E<<7 | 0x4F,
	29791 - 19968: jis0208<<14 | 0x3F<<7 | 0x4D,
	29792 - 19968: jis0208<<14 | 0x2D<<7 | 0x3B,
	29794 - 19968: jis0208<<14 | 0x5A<<7 | 0x0F,
	29795 - 19968: jis0208<<14 | 0x3F<<7 | 0x53,
	29796 - 19968: jis0208<<14 | 0x53<<7 | 0x03,
	29798 - 19968: jis0212<<14 | 0x2B<<7 | 0x22,
	29799 - 19968: jis0212<<14 | 0x2B<<7 | 0x23,
	29800 - 19968: jis0212<<14 | 0x2B<<7 | 0x24,
	29801 - 19968: jis0208<<14 | 0x3F<<7 | 0x51,
	29802 - 19968: jis0208<<14 | 0x3F<<7 | 0x54,
	29803 - 19968: jis0212<<14 | 0x2B<<7 | 0x25,
	29805 - 19968: jis0212<<14 | 0x2B<<7 | 0x26,
	29806 - 19968: jis0212<<14 | 0x2B<<7 | 0x27,
	29807 - 19968: jis0208<<14 | 0x3F<<7 | 0x46,
	29808 - 19968: jis0208<<14 | 0x3F<<7 | 0x52,
	29809 - 19968: jis0212<<14 | 0x2B<<7 | 0x28,
	29810 - 19968: jis0212<<14 | 0x2B<<7 | 0x29,
	29811 - 19968: jis0208<<14 | 0x19<<7 | 0x1B,
	29814 - 19968: jis0208<<14 | 0x3F<<7 | 0x55,
	29822 - 19968: jis0208<<14 | 0x3F<<7 | 0x56,
	29824 - 19968: jis0212<<14 | 0x2B<<7 | 0x2A,
	29825 - 19968: jis0212<<14 | 0x2B<<7 | 0x2B,
	29827 - 19968: jis0208<<14 | 0x2C<<7 | 0x5D,
	29829 - 19968: jis0212<<14 | 0x2B<<7 | 0x2C,
	29830 - 19968: jis0212<<14 | 0x2B<<7 | 0x2D,
	29831 - 19968: jis0212<<14 | 0x2B<<7 | 0x2E,
	29833 - 19968: jis0208<<14 | 0x5A<<7 | 0x10,
	29835 - 19968: jis0208<<14 | 0x3F<<7 | 0x57,
	29839 - 19968: jis0212<<14 | 0x2B<<7 | 0x30,
	29840 - 19968: jis0212<<14 | 0x2B<<7 | 0x31,
	29841 - 19968: jis0212<<14 | 0x2B<<7 | 0x32,
	29842 - 19968: jis0212<<14 | 0x2B<<7 | 0x33,
	29848 - 19968: jis0212<<14 | 0x2B<<7 | 0x34,
	29849 - 19968: jis0212<<14 | 0x2B<<7 | 0x35,
	29850 - 19968: jis0212<<14 | 0x2B<<7 | 0x36,
	29852 - 19968: jis0212<<14 | 0x2B<<7 | 0x37,
	29854 - 19968: jis0208<<14 | 0x3F<<7 | 0x58,
	29855 - 19968: jis0208<<14 | 0x5A<<7 | 0x11,
	29856 - 19968: jis0212<<14 | 0x2B<<7 | 0x39,
	29857 - 19968: jis0212<<14 | 0x2B<<7 | 0x3A,
	29858 - 19968: jis0208<<14 | 0x3F<<7 | 0x44,
	29859 - 19968: jis0212<<14 | 0x2B<<7 | 0x3B,
	29862 - 19968: jis0212<<14 | 0x2B<<7 | 0x3C,
	29863 - 19968: jis0208<<14 | 0x3F<<7 | 0x59,
	29864 - 19968: jis0212<<14 | 0x2B<<7 | 0x3D,
	29865 - 19968: jis0212<<14 | 0x2B<<7 | 0x3E,
	29866 - 19968: jis0212<<14 | 0x2B<<7 | 0x3F,
	29867 - 19968: jis0212<<14 | 0x2B<<7 | 0x40,
	29870 - 19968: jis0212<<14 | 0x2B<<7 | 0x41,
	29871 - 19968: jis0212<<14 | 0x2B<<7 | 0x42,
	29872 - 19968: jis0208<<14 | 0x13<<7 | 0x23,
	29873 - 19968: jis0212<<14 | 0x2B<<7 | 0x43,
	29874 - 19968: jis0212<<14 | 0x2B<<7 | 0x44,
	29877 - 19968: jis0212<<14 | 0x2B<<7 | 0x45,
	29881 - 19968: jis0212<<14 | 0x2B<<7 | 0x46,
	29883 - 19968: jis0212<<14 | 0x2B<<7 | 0x47,
	29885 - 19968: jis0208<<14 | 0x1B<<7 | 0x04,
	29887 - 19968: jis0212<<14 | 0x2B<<7 | 0x48,
	29896 - 19968: jis0212<<14 | 0x2B<<7 | 0x49,
	29897 - 19968: jis0212<<14 | 0x2B<<7 | 0x4A,
	29898 - 19968: jis0208<<14 | 0x3F<<7 | 0x5A,
	29900 - 19968: jis0212<<14 | 0x2B<<7 | 0x4B,
	29903 - 19968: jis0208<<14 | 0x3F<<7 | 0x5B,
	29904 - 19968: jis0212<<14 | 0x2B<<7 | 0x4C,
	29907 - 19968: jis0212<<14 | 0x2B<<7 | 0x4D,
	29908 - 19968: jis0208<<14 | 0x3F<<7 | 0x5C,
	29912 - 19968: jis0212<<14 | 0x2B<<7 | 0x4E,
	29914 - 19968: jis0212<<14 | 0x2B<<7 | 0x4F,
	29915 - 19968: jis0212<<14 | 0x2B<<7 | 0x50,
	29916 - 19968: jis0208<<14 | 0x10<<7 | 0x1A,
	29918 - 19968: jis0212<<14 | 0x2B<<7 | 0x51,
	29919 - 19968: jis0212<<14 | 0x2B<<7 | 0x52,
	29920 - 19968: jis0208<<14 | 0x40<<7 | 0x00,
	29922 - 19968: jis0208<<14 | 0x28<<7 | 0x1A,
	29923 - 19968: jis0208<<14 | 0x40<<7 | 0x01,
	29924 - 19968: jis0212<<14 | 0x2B<<7 | 0x53,
	29926 - 19968: jis0208<<14 | 0x13<<7 | 0x03,
	29927 - 19968: jis0208<<14 | 0x40<<7 | 0x02,
	29928 - 19968: jis0212<<14 | 0x2B<<7 | 0x54,
	29929 - 19968: jis0208<<14 | 0x40<<7 | 0x03,
	29930 - 19968: jis0212<<14 | 0x2B<<7 | 0x55,
	29931 - 19968: jis0212<<14 | 0x2B<<7 | 0x56,
	29934 - 19968: jis0208<<14 | 0x40<<7 | 0x04,
	29935 - 19968: jis0212<<14 | 0x2B<<7 | 0x57,
	29936 - 19968: jis0208<<14 | 0x40<<7 | 0x06,
	29937 - 19968: jis0208<<14 | 0x40<<7 | 0x07,
	29938 - 19968: jis0208<<14 | 0x40<<7 | 0x05,
	29940 - 19968: jis0212<<14 | 0x2B<<7 | 0x58,
	29942 - 19968: jis0208<<14 | 0x28<<7 | 0x32,
	29943 - 19968: jis0208<<14 | 0x40<<7 | 0x09,
	29944 - 19968: jis0208<<14 | 0x40<<7 | 0x08,
	29946 - 19968: jis0212<<14 | 0x2B<<7 | 0x59,
	29947 - 19968: jis0212<<14 | 0x2B<<7 | 0x5A,
	29948 - 19968: jis0212<<14 | 0x2B<<7 | 0x5B,
	29951 - 19968: jis0212<<14 | 0x2B<<7 | 0x5C,
	29953 - 19968: jis0208<<14 | 0x5A<<7 | 0x12,
	29955 - 19968: jis0208<<14 | 0x40<<7 | 0x0B,
	29956 - 19968: jis0208<<14 | 0x40<<7 | 0x0A,
	29957 - 19968: jis0208<<14 | 0x40<<7 | 0x0C,
	29958 - 19968: jis0212<<14 | 0x2B<<7 | 0x5D,
	29964 - 19968: jis0208<<14 | 0x40<<7 | 0x0D,
	29965 - 19968: jis0208<<14 | 0x40<<7 | 0x0F,
	29966 - 19968: jis0208<<14 | 0x40<<7 | 0x0E,
	29969 - 19968: jis0208<<14 | 0x18<<7 | 0x58,
	29970 - 19968: jis0212<<14 | 0x2C<<7 | 0x00,
	29971 - 19968: jis0208<<14 | 0x40<<7 | 0x11,
	29973 - 19968: jis0208<<14 | 0x40<<7 | 0x10,
	29974 - 19968: jis0212<<14 | 0x2C<<7 | 0x01,
	29975 - 19968: jis0212<<14 | 0x2C<<7 | 0x02,
	29976 - 19968: jis0208<<14 | 0x13<<7 | 0x24,
	29978 - 19968: jis0208<<14 | 0x1E<<7 | 0x32,
	29980 - 19968: jis0208<<14 | 0x24<<7 | 0x1B,
	29982 - 19968: jis0208<<14 | 0x40<<7 | 0x12,
	29983 - 19968: jis0208<<14 | 0x1F<<7 | 0x17,
	29984 - 19968: jis0212<<14 | 0x2C<<7 | 0x03,
	29985 - 19968: jis0212<<14 | 0x2C<<7 | 0x04,
	29987 - 19968: jis0208<<14 | 0x1A<<7 | 0x19,
	29988 - 19968: jis0212<<14 | 0x2C<<7 | 0x05,
	29989 - 19968: jis0208<<14 | 0x10<<7 | 0x58,
	29990 - 19968: jis0208<<14 | 0x40<<7 | 0x13,
	29991 - 19968: jis0212<<14 | 0x2C<<7 | 0x06,
	29992 - 19968: jis0208<<14 | 0x2C<<7 | 0x30,
	29993 - 19968: jis0212<<14 | 0x2C<<7 | 0x07,
	29994 - 19968: jis0212<<14 | 0x2C<<7 | 0x08,
	29995 - 19968: jis0208<<14 | 0x29<<7 | 0x42,
	29996 - 19968: jis0208<<14 | 0x40<<7 | 0x14,
	29999 - 19968: jis0208<<14 | 0x58<<7 | 0x4B,
	30000 - 19968: jis0208<<14 | 0x24<<7 | 0x23,
	30001 - 19968: jis0208<<14 | 0x2C<<7 | 0x12,
	30002 - 19968: jis0208<<14 | 0x18<<7 | 0x22,
	30003 - 19968: jis0208<<14 | 0x1E<<7 | 0x1C,
	30006 - 19968: jis0212<<14 | 0x2C<<7 | 0x0A,
	30007 - 19968: jis0208<<14 | 0x22<<7 | 0x2A,
	30008 - 19968: jis0208<<14 | 0x31<<7 | 0x13,
	30009 - 19968: jis0212<<14 | 0x2C<<7 | 0x0B,
	30010 - 19968: jis0208<<14 | 0x23<<7 | 0x0D,
	30011 - 19968: jis0208<<14 | 0x11<<7 | 0x47,
	30012 - 19968: jis0208<<14 | 0x40<<7 | 0x15,
	30013 - 19968: jis0212<<14 | 0x2C<<7 | 0x0C,
	30014 - 19968: jis0212<<14 | 0x2C<<7 | 0x0D,
	30015 - 19968: jis0212<<14 | 0x2C<<7 | 0x0E,
	30016 - 19968: jis0212<<14 | 0x2C<<7 | 0x0F,
	30019 - 19968: jis0212<<14 | 0x2C<<7 | 0x10,
	30020 - 19968: jis0208<<14 | 0x40<<7 | 0x16,
	30022 - 19968: jis0208<<14 | 0x40<<7 | 0x1B,
	30023 - 19968: jis0212<<14 | 0x2C<<7 | 0x11,
	30024 - 19968: jis0212<<14 | 0x2C<<7 | 0x12,
	30025 - 19968: jis0208<<14 | 0x40<<7 | 0x19,
	30026 - 19968: jis0208<<14 | 0x40<<7 | 0x18,
	30027 - 19968: jis0208<<14 | 0x39<<7 | 0x21,
	30028 - 19968: jis0208<<14 | 0x12<<7 | 0x05,
	30029 - 19968: jis0208<<14 | 0x40<<7 | 0x17,
	30030 - 19968: jis0212<<14 | 0x2C<<7 | 0x13,
	30031 - 19968: jis0208<<14 | 0x0F<<7 | 0x39,
	30032 - 19968: jis0212<<14 | 0x2C<<7 | 0x14,
	30033 - 19968: jis0208<<14 | 0x27<<7 | 0x09,
	30034 - 19968: jis0212<<14 | 0x2C<<7 | 0x15,
	30036 - 19968: jis0208<<14 | 0x27<<7 | 0x29,
	30039 - 19968: jis0212<<14 | 0x2C<<7 | 0x16,
	30041 - 19968: jis0208<<14 | 0x2D<<7 | 0x10,
	30042 - 19968: jis0208<<14 | 0x40<<7 | 0x1C,
	30043 - 19968: jis0208<<14 | 0x40<<7 | 0x1A,
	30044 - 19968: jis0208<<14 | 0x22<<7 | 0x3B,
	30045 - 19968: jis0208<<14 | 0x1F<<7 | 0x05,
	30046 - 19968: jis0212<<14 | 0x2C<<7 | 0x17,
	30047 - 19968: jis0212<<14 | 0x2C<<7 | 0x18,
	30048 - 19968: jis0208<<14 | 0x27<<7 | 0x0A,
	30049 - 19968: jis0212<<14 | 0x2C<<7 | 0x19,
	30050 - 19968: jis0208<<14 | 0x28<<7 | 0x0C,
	30052 - 19968: jis0208<<14 | 0x40<<7 | 0x1E,
	30053 - 19968: jis0208<<14 | 0x2D<<7 | 0x0B,
	30054 - 19968: jis0208<<14 | 0x16<<7 | 0x2C,
	30055 - 19968: jis0208<<14 | 0x40<<7 | 0x1F,
	30057 - 19968: jis0208<<14 | 0x40<<7 | 0x1D,
	30058 - 19968: jis0208<<14 | 0x27<<7 | 0x35,
	30059 - 19968: jis0208<<14 | 0x40<<7 | 0x20,
	30061 - 19968: jis0208<<14 | 0x40<<7 | 0x21,
	30063 - 19968: jis0208<<14 | 0x5A<<7 | 0x13,
	30064 - 19968: jis0208<<14 | 0x0F<<7 | 0x3A,
	30065 - 19968: jis0212<<14 | 0x2C<<7 | 0x1B,
	30067 - 19968: jis0208<<14 | 0x1D<<7 | 0x55,
	30068 - 19968: jis0208<<14 | 0x40<<7 | 0x26,
	30070 - 19968: jis0208<<14 | 0x40<<7 | 0x23,
	30071 - 19968: jis0208<<14 | 0x25<<7 | 0x4C,
	30072 - 19968: jis0208<<14 | 0x40<<7 | 0x22,
	30073 - 19968: jis0212<<14 | 0x2C<<7 | 0x1C,
	30074 - 19968: jis0212<<14 | 0x2C<<7 | 0x1D,
	30075 - 19968: jis0212<<14 | 0x2C<<7 | 0x1E,
	30076 - 19968: jis0212<<14 | 0x2C<<7 | 0x1F,
	30077 - 19968: jis0212<<14 | 0x2C<<7 | 0x20,
	30078 - 19968: jis0212<<14 | 0x2C<<7 | 0x21,
	30079 - 19968: jis0208<<14 | 0x14<<7 | 0x05,
	30081 - 19968: jis0212<<14 | 0x2C<<7 | 0x22,
	30082 - 19968: jis0208<<14 | 0x40<<7 | 0x29,
	30085 - 19968: jis0212<<14 | 0x2C<<7 | 0x23,
	30086 - 19968: jis0208<<14 | 0x40<<7 | 0x24,
	30087 - 19968: jis0208<<14 | 0x40<<7 | 0x25,
	30089 - 19968: jis0208<<14 | 0x40<<7 | 0x28,
	30090 - 19968: jis0208<<14 | 0x40<<7 | 0x27,
	30091 - 19968: jis0208<<14 | 0x28<<7 | 0x04,
	30094 - 19968: jis0208<<14 | 0x20<<7 | 0x21,
	30095 - 19968: jis0208<<14 | 0x20<<7 | 0x20,
	30096 - 19968: jis0212<<14 | 0x2C<<7 | 0x24,
	30097 - 19968: jis0208<<14 | 0x14<<7 | 0x1E,
	30098 - 19968: jis0212<<14 | 0x2C<<7 | 0x25,
	30099 - 19968: jis0212<<14 | 0x2C<<7 | 0x26,
	30100 - 19968: jis0208<<14 | 0x40<<7 | 0x2A,
	30101 - 19968: jis0212<<14 | 0x2C<<7 | 0x27,
	30105 - 19968: jis0212<<14 | 0x2C<<7 | 0x28,
	30106 - 19968: jis0208<<14 | 0x40<<7 | 0x2B,
	30108 - 19968: jis0212<<14 | 0x2C<<7 | 0x29,
	30109 - 19968: jis0208<<14 | 0x40<<7 | 0x2C,
	30114 - 19968: jis0212<<14 | 0x2C<<7 | 0x2A,
	30115 - 19968: jis0208<<14 | 0x40<<7 | 0x2E,
	30116 - 19968: jis0212<<14 | 0x2C<<7 | 0x2B,
	30117 - 19968: jis0208<<14 | 0x40<<7 | 0x2D,
	30123 - 19968: jis0208<<14 | 0x10<<7 | 0x35,
	30129 - 19968: jis0208<<14 | 0x40<<7 | 0x36,
	30130 - 19968: jis0208<<14 | 0x27<<7 | 0x47,
	30131 - 19968: jis0208<<14 | 0x40<<7 | 0x30,
	30132 - 19968: jis0212<<14 | 0x2C<<7 | 0x2C,
	30133 - 19968: jis0208<<14 | 0x40<<7 | 0x32,
	30136 - 19968: jis0208<<14 | 0x40<<7 | 0x34,
	30137 - 19968: jis0208<<14 | 0x1E<<7 | 0x1D,
	30138 - 19968: jis0212<<14 | 0x2C<<7 | 0x2D,
	30140 - 19968: jis0208<<14 | 0x40<<7 | 0x35,
	30141 - 19968: jis0208<<14 | 0x40<<7 | 0x33,
	30142 - 19968: jis0208<<14 | 0x1B<<7 | 0x1F,
	30143 - 19968: jis0212<<14 | 0x2C<<7 | 0x2E,
	30144 - 19968: jis0212<<14 | 0x2C<<7 | 0x2F,
	30145 - 19968: jis0212<<14 | 0x2C<<7 | 0x30,
	30146 - 19968: jis0208<<14 | 0x40<<7 | 0x2F,
	30147 - 19968: jis0208<<14 | 0x40<<7 | 0x31,
	30148 - 19968: jis0212<<14 | 0x2C<<7 | 0x31,
	30149 - 19968: jis0208<<14 | 0x28<<7 | 0x21,
	30150 - 19968: jis0212<<14 | 0x2C<<7 | 0x32,
	30151 - 19968: jis0208<<14 | 0x1D<<7 | 0x28,
	30154 - 19968: jis0208<<14 | 0x40<<7 | 0x38,
	30156 - 19968: jis0212<<14 | 0x2C<<7 | 0x33,
	30157 - 19968: jis0208<<14 | 0x40<<7 | 0x37,
	30158 - 19968: jis0212<<14 | 0x2C<<7 | 0x34,
	30159 - 19968: jis0212<<14 | 0x2C<<7 | 0x35,
	30162 - 19968: jis0208<<14 | 0x40<<7 | 0x39,
	30164 - 19968: jis0208<<14 | 0x1B<<7 | 0x05,
	30165 - 19968: jis0208<<14 | 0x19<<7 | 0x0E,
	30167 - 19968: jis0212<<14 | 0x2C<<7 | 0x36,
	30168 - 19968: jis0208<<14 | 0x24<<7 | 0x56,
	30169 - 19968: jis0208<<14 | 0x40<<7 | 0x3A,
	30171 - 19968: jis0208<<14 | 0x23<<7 | 0x2A,
	30172 - 19968: jis0212<<14 | 0x2C<<7 | 0x37,
	30174 - 19968: jis0208<<14 | 0x40<<7 | 0x3C,
	30175 - 19968: jis0212<<14 | 0x2C<<7 | 0x38,
	30176 - 19968: jis0212<<14 | 0x2C<<7 | 0x39,
	30177 - 19968: jis0212<<14 | 0x2C<<7 | 0x3A,
	30178 - 19968: jis0208<<14 | 0x2D<<7 | 0x00,
	30179 - 19968: jis0208<<14 | 0x40<<7 | 0x3B,
	30180 - 19968: jis0212<<14 | 0x2C<<7 | 0x3B,
	30183 - 19968: jis0212<<14 | 0x2C<<7 | 0x3C,
	30185 - 19968: jis0208<<14 | 0x20<<7 | 0x48,
	30188 - 19968: jis0212<<14 | 0x2C<<7 | 0x3D,
	30190 - 19968: jis0212<<14 | 0x2C<<7 | 0x3E,
	30191 - 19968: jis0212<<14 | 0x2C<<7 | 0x3F,
	30192 - 19968: jis0208<<14 | 0x40<<7 | 0x41,
	30193 - 19968: jis0212<<14 | 0x2C<<7 | 0x40,
	30194 - 19968: jis0208<<14 | 0x40<<7 | 0x43,
	30195 - 19968: jis0208<<14 | 0x40<<7 | 0x44,
	30196 - 19968: jis0208<<14 | 0x22<<7 | 0x33,
	30201 - 19968: jis0212<<14 | 0x2C<<7 | 0x41,
	30202 - 19968: jis0208<<14 | 0x40<<7 | 0x42,
	30204 - 19968: jis0208<<14 | 0x40<<7 | 0x3F,
	30206 - 19968: jis0208<<14 | 0x40<<7 | 0x3D,
	30207 - 19968: jis0208<<14 | 0x40<<7 | 0x3E,
	30208 - 19968: jis0212<<14 | 0x2C<<7 | 0x42,
	30209 - 19968: jis0208<<14 | 0x40<<7 | 0x40,
	30210 - 19968: jis0212<<14 | 0x2C<<7 | 0x43,
	30211 - 19968: jis0212<<14 | 0x2C<<7 | 0x44,
	30212 - 19968: jis0212<<14 | 0x2C<<7 | 0x45,
	30215 - 19968: jis0212<<14 | 0x2C<<7 | 0x46,
	30216 - 19968: jis0212<<14 | 0x2C<<7 | 0x47,
	30217 - 19968: jis0208<<14 | 0x40<<7 | 0x47,
	30218 - 19968: jis0212<<14 | 0x2C<<7 | 0x48,
	30219 - 19968: jis0208<<14 | 0x40<<7 | 0x45,
	30220 - 19968: jis0212<<14 | 0x2C<<7 | 0x49,
	30221 - 19968: jis0208<<14 | 0x40<<7 | 0x46,
	30223 - 19968: jis0212<<14 | 0x2C<<7 | 0x4A,
	30226 - 19968: jis0212<<14 | 0x2C<<7 | 0x4B,
	30227 - 19968: jis0212<<14 | 0x2C<<7 | 0x4C,
	30229 - 19968: jis0212<<14 | 0x2C<<7 | 0x4D,
	30230 - 19968: jis0212<<14 | 0x2C<<7 | 0x4E,
	30233 - 19968: jis0212<<14 | 0x2C<<7 | 0x4F,
	30235 - 19968: jis0212<<14 | 0x2C<<7 | 0x50,
	30236 - 19968: jis0212<<14 | 0x2C<<7 | 0x51,
	30237 - 19968: jis0212<<14 | 0x2C<<7 | 0x52,
	30238 - 19968: jis0212<<14 | 0x2C<<7 | 0x53,
	30239 - 19968: jis0208<<14 | 0x40<<7 | 0x48,
	30240 - 19968: jis0208<<14 | 0x40<<7 | 0x4A,
	30241 - 19968: jis0208<<14 | 0x40<<7 | 0x4B,
	30242 - 19968: jis0208<<14 | 0x40<<7 | 0x4C,
	30243 - 19968: jis0212<<14 | 0x2C<<7 | 0x54,
	30244 - 19968: jis0208<<14 | 0x40<<7 | 0x4D,
	30245 - 19968: jis0212<<14 | 0x2C<<7 | 0x55,
	30246 - 19968: jis0212<<14 | 0x2C<<7 | 0x56,
	30247 - 19968: jis0208<<14 | 0x40<<7 | 0x49,
	30249 - 19968: jis0212<<14 | 0x2C<<7 | 0x57,
	30253 - 19968: jis0212<<14 | 0x2C<<7 | 0x58,
	30256 - 19968: jis0208<<14 | 0x40<<7 | 0x4F,
	30258 - 19968: jis0212<<14 | 0x2C<<7 | 0x59,
	30259 - 19968: jis0212<<14 | 0x2C<<7 | 0x5A,
	30260 - 19968: jis0208<<14 | 0x40<<7 | 0x4E,
	30261 - 19968: jis0212<<14 | 0x2C<<7 | 0x5B,
	30264 - 19968: jis0212<<14 | 0x2C<<7 | 0x5C,
	30265 - 19968: jis0212<<14 | 0x2C<<7 | 0x5D,
	30266 - 19968: jis0212<<14 | 0x2D<<7 | 0x00,
	30267 - 19968: jis0208<<14 | 0x40<<7 | 0x50,
	30268 - 19968: jis0212<<14 | 0x2D<<7 | 0x01,
	30272 - 19968: jis0212<<14 | 0x2D<<7 | 0x03,
	30273 - 19968: jis0212<<14 | 0x2D<<7 | 0x04,
	30274 - 19968: jis0208<<14 | 0x2D<<7 | 0x24,
	30275 - 19968: jis0212<<14 | 0x2D<<7 | 0x05,
	30276 - 19968: jis0212<<14 | 0x2D<<7 | 0x06,
	30277 - 19968: jis0212<<14 | 0x2D<<7 | 0x07,
	30278 - 19968: jis0208<<14 | 0x40<<7 | 0x53,
	30279 - 19968: jis0208<<14 | 0x40<<7 | 0x51,
	30280 - 19968: jis0208<<14 | 0x40<<7 | 0x52,
	30281 - 19968: jis0212<<14 | 0x2D<<7 | 0x08,
	30282 - 19968: jis0212<<14 | 0x2D<<7 | 0x02,
	30283 - 19968: jis0212<<14 | 0x2D<<7 | 0x09,
	30284 - 19968: jis0208<<14 | 0x13<<7 | 0x41,
	30290 - 19968: jis0208<<14 | 0x2B<<7 | 0x5D,
	30293 - 19968: jis0212<<14 | 0x2D<<7 | 0x0A,
	30294 - 19968: jis0208<<14 | 0x29<<7 | 0x29,
	30296 - 19968: jis0208<<14 | 0x40<<7 | 0x55,
	30297 - 19968: jis0212<<14 | 0x2D<<7 | 0x0B,
	30300 - 19968: jis0208<<14 | 0x40<<7 | 0x54,
	30303 - 19968: jis0212<<14 | 0x2D<<7 | 0x0C,
	30305 - 19968: jis0208<<14 | 0x40<<7 | 0x56,
	30306 - 19968: jis0208<<14 | 0x40<<7 | 0x57,
	30308 - 19968: jis0212<<14 | 0x2D<<7 | 0x0D,
	30309 - 19968: jis0212<<14 | 0x2D<<7 | 0x0E,
	30311 - 19968: jis0208<<14 | 0x40<<7 | 0x5B,
	30312 - 19968: jis0208<<14 | 0x40<<7 | 0x58,
	30313 - 19968: jis0208<<14 | 0x40<<7 | 0x59,
	30314 - 19968: jis0208<<14 | 0x40<<7 | 0x5A,
	30316 - 19968: jis0208<<14 | 0x40<<7 | 0x5C,
	30317 - 19968: jis0212<<14 | 0x2D<<7 | 0x0F,
	30318 - 19968: jis0212<<14 | 0x2D<<7 | 0x10,
	30319 - 19968: jis0212<<14 | 0x2D<<7 | 0x11,
	30320 - 19968: jis0208<<14 | 0x40<<7 | 0x5D,
	30321 - 19968: jis0212<<14 | 0x2D<<7 | 0x12,
	30322 - 19968: jis0208<<14 | 0x41<<7 | 0x00,
	30324 - 19968: jis0212<<14 | 0x2D<<7 | 0x13,
	30326 - 19968: jis0208<<14 | 0x41<<7 | 0x01,
	30328 - 19968: jis0208<<14 | 0x41<<7 | 0x02,
	30330 - 19968: jis0208<<14 | 0x27<<7 | 0x0E,
	30331 - 19968: jis0208<<14 | 0x24<<7 | 0x2F,
	30332 - 19968: jis0208<<14 | 0x41<<7 | 0x03,
	30333 - 19968: jis0208<<14 | 0x26<<7 | 0x51,
	30334 - 19968: jis0208<<14 | 0x28<<7 | 0x13,
	30336 - 19968: jis0208<<14 | 0x41<<7 | 0x04,
	30337 - 19968: jis0212<<14 | 0x2D<<7 | 0x14,
	30338 - 19968: jis0208<<14 | 0x5A<<7 | 0x14,
	30339 - 19968: jis0208<<14 | 0x41<<7 | 0x05,
	30340 - 19968: jis0208<<14 | 0x24<<7 | 0x09,
	30341 - 19968: jis0212<<14 | 0x2D<<7 | 0x15,
	30342 - 19968: jis0208<<14 | 0x12<<7 | 0x06,
	30343 - 19968: jis0208<<14 | 0x18<<7 | 0x23,
	30344 - 19968: jis0208<<14 | 0x41<<7 | 0x06,
	30347 - 19968: jis0208<<14 | 0x41<<7 | 0x07,
	30348 - 19968: jis0212<<14 | 0x2D<<7 | 0x16,
	30349 - 19968: jis0212<<14 | 0x2D<<7 | 0x17,
	30350 - 19968: jis0208<<14 | 0x41<<7 | 0x08,
	30352 - 19968: jis0208<<14 | 0x1A<<7 | 0x08,
	30355 - 19968: jis0208<<14 | 0x41<<7 | 0x0A,
	30357 - 19968: jis0212<<14 | 0x2D<<7 | 0x18,
	30358 - 19968: jis0208<<14 | 0x41<<7 | 0x09,
	30361 - 19968: jis0208<<14 | 0x41<<7 | 0x0B,
	30362 - 19968: jis0208<<14 | 0x41<<7 | 0x0C,
	30363 - 19968: jis0208<<14 | 0x5A<<7 | 0x17,
	30364 - 19968: jis0208<<14 | 0x5A<<7 | 0x15,
	30365 - 19968: jis0212<<14 | 0x2D<<7 | 0x1B,
	30366 - 19968: jis0208<<14 | 0x5A<<7 | 0x16,
	30367 - 19968: jis0212<<14 | 0x2D<<7 | 0x1C,
	30368 - 19968: jis0212<<14 | 0x2D<<7 | 0x1D,
	30370 - 19968: jis0212<<14 | 0x2D<<7 | 0x1E,
	30371 - 19968: jis0212<<14 | 0x2D<<7 | 0x1F,
	30372 - 19968: jis0212<<14 | 0x2D<<7 | 0x20,
	30373 - 19968: jis0212<<14 | 0x2D<<7 | 0x21,
	30374 - 19968: jis0208<<14 | 0x5A<<7 | 0x18,
	30375 - 19968: jis0212<<14 | 0x2D<<7 | 0x23,
	30376 - 19968: jis0212<<14 | 0x2D<<7 | 0x24,
	30378 - 19968: jis0212<<14 | 0x2D<<7 | 0x25,
	30381 - 19968: jis0212<<14 | 0x2D<<7 | 0x26,
	30382 - 19968: jis0208<<14 | 0x27<<7 | 0x48,
	30384 - 19968: jis0208<<14 | 0x41<<7 | 0x0D,
	30388 - 19968: jis0208<<14 | 0x41<<7 | 0x0E,
	30391 - 19968: jis0208<<14 | 0x52<<7 | 0x48,
	30392 - 19968: jis0208<<14 | 0x41<<7 | 0x0F,
	30393 - 19968: jis0208<<14 | 0x41<<7 | 0x10,
	30394 - 19968: jis0208<<14 | 0x41<<7 | 0x11,
	30397 - 19968: jis0212<<14 | 0x2D<<7 | 0x27,
	30399 - 19968: jis0208<<14 | 0x1A<<7 | 0x0D,
	30401 - 19968: jis0212<<14 | 0x2D<<7 | 0x28,
	30402 - 19968: jis0208<<14 | 0x41<<7 | 0x12,
	30403 - 19968: jis0208<<14 | 0x26<<7 | 0x35,
	30405 - 19968: jis0212<<14 | 0x2D<<7 | 0x29,
	30406 - 19968: jis0208<<14 | 0x2A<<7 | 0x3E,
	30408 - 19968: jis0208<<14 | 0x10<<7 | 0x2D,
	30409 - 19968: jis0212<<14 | 0x2D<<7 | 0x2A,
	30410 - 19968: jis0208<<14 | 0x10<<7 | 0x36,
	30411 - 19968: jis0212<<14 | 0x2D<<7 | 0x2B,
	30412 - 19968: jis0212<<14 | 0x2D<<7 | 0x2C,
	30413 - 19968: jis0208<<14 | 0x41<<7 | 0x13,
	30414 - 19968: jis0212<<14 | 0x2D<<7 | 0x2D,
	30418 - 19968: jis0208<<14 | 0x41<<7 | 0x15,
	30420 - 19968: jis0212<<14 | 0x2D<<7 | 0x2E,
	30422 - 19968: jis0208<<14 | 0x41<<7 | 0x14,
	30423 - 19968: jis0208<<14 | 0x24<<7 | 0x4F,
	30425 - 19968: jis0212<<14 | 0x2D<<7 | 0x2F,
	30427 - 19968: jis0208<<14 | 0x1F<<7 | 0x18,
	30428 - 19968: jis0208<<14 | 0x3C<<7 | 0x18,
	30430 - 19968: jis0208<<14 | 0x41<<7 | 0x16,
	30431 - 19968: jis0208<<14 | 0x2B<<7 | 0x20,
	30432 - 19968: jis0212<<14 | 0x2D<<7 | 0x30,
	30433 - 19968: jis0208<<14 | 0x41<<7 | 0x17,
	30435 - 19968: jis0208<<14 | 0x13<<7 | 0x25,
	30436 - 19968: jis0208<<14 | 0x27<<7 | 0x36,
	30437 - 19968: jis0208<<14 | 0x41<<7 | 0x18,
	30438 - 19968: jis0212<<14 | 0x2D<<7 | 0x31,
	30439 - 19968: jis0208<<14 | 0x41<<7 | 0x19,
	30440 - 19968: jis0212<<14 | 0x2D<<7 | 0x32,
	30442 - 19968: jis0208<<14 | 0x41<<7 | 0x1A,
	30444 - 19968: jis0212<<14 | 0x2D<<7 | 0x33,
	30446 - 19968: jis0208<<14 | 0x2B<<7 | 0x3B,
	30448 - 19968: jis0212<<14 | 0x2D<<7 | 0x34,
	30449 - 19968: jis0212<<14 | 0x2D<<7 | 0x35,
	30450 - 19968: jis0208<<14 | 0x2B<<7 | 0x34,
	30452 - 19968: jis0208<<14 | 0x23<<7 | 0x1D,
	30454 - 19968: jis0212<<14 | 0x2D<<7 | 0x36,
	30456 - 19968: jis0208<<14 | 0x20<<7 | 0x49,
	30457 - 19968: jis0212<<14 | 0x2D<<7 | 0x37,
	30459 - 19968: jis0208<<14 | 0x41<<7 | 0x1C,
	30460 - 19968: jis0212<<14 | 0x2D<<7 | 0x38,
	30462 - 19968: jis0208<<14 | 0x1C<<7 | 0x41,
	30464 - 19968: jis0212<<14 | 0x2D<<7 | 0x39,
	30465 - 19968: jis0208<<14 | 0x1D<<7 | 0x29,
	30468 - 19968: jis0208<<14 | 0x41<<7 | 0x1F,
	30470 - 19968: jis0212<<14 | 0x2D<<7 | 0x3A,
	30471 - 19968: jis0208<<14 | 0x41<<7 | 0x1E,
	30472 - 19968: jis0208<<14 | 0x41<<7 | 0x1D,
	30473 - 19968: jis0208<<14 | 0x27<<7 | 0x5C,
	30474 - 19968: jis0212<<14 | 0x2D<<7 | 0x3B,
	30475 - 19968: jis0208<<14 | 0x13<<7 | 0x26,
	30476 - 19968: jis0208<<14 | 0x17<<7 | 0x08,
	30478 - 19968: jis0212<<14 | 0x2D<<7 | 0x3C,
	30482 - 19968: jis0212<<14 | 0x2D<<7 | 0x3D,
	30484 - 19968: jis0212<<14 | 0x2D<<7 | 0x3E,
	30485 - 19968: jis0212<<14 | 0x2D<<7 | 0x3F,
	30487 - 19968: jis0212<<14 | 0x2D<<7 | 0x40,
	30489 - 19968: jis0212<<14 | 0x2D<<7 | 0x41,
	30490 - 19968: jis0212<<14 | 0x2D<<7 | 0x42,
	30491 - 19968: jis0208<<14 | 0x41<<7 | 0x25,
	30492 - 19968: jis0212<<14 | 0x2D<<7 | 0x43,
	30494 - 19968: jis0208<<14 | 0x41<<7 | 0x22,
	30495 - 19968: jis0208<<14 | 0x1E<<7 | 0x1E,
	30496 - 19968: jis0208<<14 | 0x2B<<7 | 0x11,
	30498 - 19968: jis0212<<14 | 0x2D<<7 | 0x44,
	30500 - 19968: jis0208<<14 | 0x41<<7 | 0x21,
	30501 - 19968: jis0208<<14 | 0x41<<7 | 0x23,
	30502 - 19968: jis0208<<14 | 0x41<<7 | 0x24,
	30504 - 19968: jis0212<<14 | 0x2D<<7 | 0x45,
	30505 - 19968: jis0208<<14 | 0x41<<7 | 0x20,
	30509 - 19968: jis0212<<14 | 0x2D<<7 | 0x46,
	30510 - 19968: jis0212<<14 | 0x2D<<7 | 0x47,
	30511 - 19968: jis0212<<14 | 0x2D<<7 | 0x48,
	30516 - 19968: jis0212<<14 | 0x2D<<7 | 0x49,
	30517 - 19968: jis0212<<14 | 0x2D<<7 | 0x4A,
	30518 - 19968: jis0212<<14 | 0x2D<<7 | 0x4B,
	30519 - 19968: jis0208<<14 | 0x41<<7 | 0x26,
	30520 - 19968: jis0208<<14 | 0x41<<7 | 0x27,
	30521 - 19968: jis0212<<14 | 0x2D<<7 | 0x4C,
	30522 - 19968: jis0208<<14 | 0x23<<7 | 0x0E,
	30524 - 19968: jis0208<<14 | 0x13<<7 | 0x42,
	30525 - 19968: jis0212<<14 | 0x2D<<7 | 0x4D,
	30526 - 19968: jis0212<<14 | 0x2D<<7 | 0x4E,
	30528 - 19968: jis0208<<14 | 0x22<<7 | 0x44,
	30530 - 19968: jis0212<<14 | 0x2D<<7 | 0x4F,
	30533 - 19968: jis0212<<14 | 0x2D<<7 | 0x50,
	30534 - 19968: jis0208<<14 | 0x5A<<7 | 0x1A,
	30535 - 19968: jis0208<<14 | 0x41<<7 | 0x28,
	30538 - 19968: jis0212<<14 | 0x2D<<7 | 0x52,
	30541 - 19968: jis0212<<14 | 0x2D<<7 | 0x53,
	30542 - 19968: jis0212<<14 | 0x2D<<7 | 0x54,
	30543 - 19968: jis0212<<14 | 0x2D<<7 | 0x55,
	30546 - 19968: jis0212<<14 | 0x2D<<7 | 0x56,
	30550 - 19968: jis0212<<14 | 0x2D<<7 | 0x57,
	30551 - 19968: jis0212<<14 | 0x2D<<7 | 0x58,
	30554 - 19968: jis0208<<14 | 0x41<<7 | 0x29,
	30555 - 19968: jis0208<<14 | 0x41<<7 | 0x2C,
	30556 - 19968: jis0212<<14 | 0x2D<<7 | 0x59,
	30558 - 19968: jis0212<<14 | 0x2D<<7 | 0x5A,
	30559 - 19968: jis0212<<14 | 0x2D<<7 | 0x5B,
	30560 - 19968: jis0212<<14 | 0x2D<<7 | 0x5C,
	30561 - 19968: jis0208<<14 | 0x1E<<7 | 0x46,
	30562 - 19968: jis0212<<14 | 0x2D<<7 | 0x5D,
	30563 - 19968: jis0208<<14 | 0x25<<7 | 0x23,
	30564 - 19968: jis0212<<14 | 0x2E<<7 | 0x00,
	30565 - 19968: jis0208<<14 | 0x41<<7 | 0x2D,
	30566 - 19968: jis0208<<14 | 0x2A<<7 | 0x32,
	30567 - 19968: jis0212<<14 | 0x2E<<7 | 0x01,
	30568 - 19968: jis0208<<14 | 0x41<<7 | 0x2A,
	30570 - 19968: jis0212<<14 | 0x2E<<7 | 0x02,
	30571 - 19968: jis0208<<14 | 0x41<<7 | 0x2B,
	30572 - 19968: jis0212<<14 | 0x2E<<7 | 0x03,
	30576 - 19968: jis0212<<14 | 0x2E<<7 | 0x04,
	30578 - 19968: jis0212<<14 | 0x2E<<7 | 0x05,
	30579 - 19968: jis0212<<14 | 0x2E<<7 | 0x06,
	30580 - 19968: jis0212<<14 | 0x2E<<7 | 0x07,
	30585 - 19968: jis0208<<14 | 0x41<<7 | 0x30,
	30586 - 19968: jis0212<<14 | 0x2E<<7 | 0x08,
	30589 - 19968: jis0212<<14 | 0x2E<<7 | 0x09,
	30590 - 19968: jis0208<<14 | 0x41<<7 | 0x2F,
	30591 - 19968: jis0208<<14 | 0x41<<7 | 0x2E,
	30592 - 19968: jis0212<<14 | 0x2E<<7 | 0x0A,
	30596 - 19968: jis0212<<14 | 0x2E<<7 | 0x0B,
	30603 - 19968: jis0208<<14 | 0x41<<7 | 0x32,
	30604 - 19968: jis0212<<14 | 0x2E<<7 | 0x0C,
	30605 - 19968: jis0212<<14 | 0x2E<<7 | 0x0D,
	30606 - 19968: jis0208<<14 | 0x41<<7 | 0x31,
	30609 - 19968: jis0208<<14 | 0x41<<7 | 0x33,
	30612 - 19968: jis0212<<14 | 0x2E<<7 | 0x0E,
	30613 - 19968: jis0212<<14 | 0x2E<<7 | 0x0F,
	30614 - 19968: jis0212<<14 | 0x2E<<7 | 0x10,
	30618 - 19968: jis0212<<14 | 0x2E<<7 | 0x11,
	30622 - 19968: jis0208<<14 | 0x41<<7 | 0x35,
	30623 - 19968: jis0212<<14 | 0x2E<<7 | 0x12,
	30624 - 19968: jis0208<<14 | 0x41<<7 | 0x34,
	30626 - 19968: jis0212<<14 | 0x2E<<7 | 0x13,
	30629 - 19968: jis0208<<14 | 0x29<<7 | 0x2C,
	30631 - 19968: jis0212<<14 | 0x2E<<7 | 0x14,
	30634 - 19968: jis0212<<14 | 0x2E<<7 | 0x15,
	30636 - 19968: jis0208<<14 | 0x1C<<7 | 0x35,
	30637 - 19968: jis0208<<14 | 0x2D<<7 | 0x25,
	30638 - 19968: jis0212<<14 | 0x2E<<7 | 0x16,
	30639 - 19968: jis0212<<14 | 0x2E<<7 | 0x17,
	30640 - 19968: jis0208<<14 | 0x41<<7 | 0x36,
	30641 - 19968: jis0212<<14 | 0x2E<<7 | 0x18,
	30643 - 19968: jis0208<<14 | 0x25<<7 | 0x16,
	30645 - 19968: jis0212<<14 | 0x2E<<7 | 0x19,
	30646 - 19968: jis0208<<14 | 0x41<<7 | 0x37,
	30649 - 19968: jis0208<<14 | 0x41<<7 | 0x38,
	30651 - 19968: jis0208<<14 | 0x41<<7 | 0x3C,
	30652 - 19968: jis0208<<14 | 0x41<<7 | 0x3A,
	30653 - 19968: jis0208<<14 | 0x41<<7 | 0x3B,
	30654 - 19968: jis0212<<14 | 0x2E<<7 | 0x1A,
	30655 - 19968: jis0208<<14 | 0x41<<7 | 0x39,
	30659 - 19968: jis0212<<14 | 0x2E<<7 | 0x1B,
	30663 - 19968: jis0208<<14 | 0x41<<7 | 0x3D,
	30665 - 19968: jis0212<<14 | 0x2E<<7 | 0x1C,
	30669 - 19968: jis0208<<14 | 0x41<<7 | 0x3E,
	30673 - 19968: jis0212<<14 | 0x2E<<7 | 0x1D,
	30674 - 19968: jis0212<<14 | 0x2E<<7 | 0x1E,
	30677 - 19968: jis0212<<14 | 0x2E<<7 | 0x1F,
	30679 - 19968: jis0208<<14 | 0x41<<7 | 0x3F,
	30681 - 19968: jis0212<<14 | 0x2E<<7 | 0x20,
	30682 - 19968: jis0208<<14 | 0x41<<7 | 0x40,
	30683 - 19968: jis0208<<14 | 0x2B<<7 | 0x16,
	30684 - 19968: jis0208<<14 | 0x41<<7 | 0x41,
	30686 - 19968: jis0212<<14 | 0x2E<<7 | 0x21,
	30687 - 19968: jis0212<<14 | 0x2E<<7 | 0x22,
	30688 - 19968: jis0212<<14 | 0x2E<<7 | 0x23,
	30690 - 19968: jis0208<<14 | 0x2B<<7 | 0x4F,
	30691 - 19968: jis0208<<14 | 0x41<<7 | 0x42,
	30692 - 19968: jis0212<<14 | 0x2E<<7 | 0x24,
	30693 - 19968: jis0208<<14 | 0x22<<7 | 0x2D,
	30694 - 19968: jis0212<<14 | 0x2E<<7 | 0x25,
	30695 - 19968: jis0208<<14 | 0x26<<7 | 0x49,
	30697 - 19968: jis0208<<14 | 0x15<<7 | 0x4A,
	30698 - 19968: jis0212<<14 | 0x2E<<7 | 0x26,
	30700 - 19968: jis0212<<14 | 0x2E<<7 | 0x27,
	30701 - 19968: jis0208<<14 | 0x22<<7 | 0x1A,
	30702 - 19968: jis0208<<14 | 0x41<<7 | 0x43,
	30703 - 19968: jis0208<<14 | 0x15<<7 | 0x19,
	30704 - 19968: jis0212<<14 | 0x2E<<7 | 0x28,
	30705 - 19968: jis0212<<14 | 0x2E<<7 | 0x29,
	30707 - 19968: jis0208<<14 | 0x1F<<7 | 0x2F,
	30708 - 19968: jis0212<<14 | 0x2E<<7 | 0x2A,
	30712 - 19968: jis0212<<14 | 0x2E<<7 | 0x2B,
	30715 - 19968: jis0212<<14 | 0x2E<<7 | 0x2C,
	30716 - 19968: jis0208<<14 | 0x41<<7 | 0x44,
	30722 - 19968: jis0208<<14 | 0x19<<7 | 0x1C,
	30725 - 19968: jis0212<<14 | 0x2E<<7 | 0x2D,
	30726 - 19968: jis0212<<14 | 0x2E<<7 | 0x2E,
	30729 - 19968: jis0212<<14 | 0x2E<<7 | 0x2F,
	30732 - 19968: jis0208<<14 | 0x41<<7 | 0x45,
	30733 - 19968: jis0212<<14 | 0x2E<<7 | 0x30,
	30734 - 19968: jis0212<<14 | 0x2E<<7 | 0x31,
	30737 - 19968: jis0212<<14 | 0x2E<<7 | 0x32,
	30738 - 19968: jis0208<<14 | 0x41<<7 | 0x46,
	30740 - 19968: jis0208<<14 | 0x17<<7 | 0x05,
	30741 - 19968: jis0208<<14 | 0x19<<7 | 0x34,
	30749 - 19968: jis0212<<14 | 0x2E<<7 | 0x33,
	30752 - 19968: jis0208<<14 | 0x41<<7 | 0x48,
	30753 - 19968: jis0208<<14 | 0x5A<<7 | 0x1C,
	30754 - 19968: jis0212<<14 | 0x2E<<7 | 0x35,
	30755 - 19968: jis0212<<14 | 0x2E<<7 | 0x36,
	30757 - 19968: jis0208<<14 | 0x24<<7 | 0x35,
	30758 - 19968: jis0208<<14 | 0x19<<7 | 0x35,
	30759 - 19968: jis0208<<14 | 0x14<<7 | 0x2D,
	30765 - 19968: jis0212<<14 | 0x2E<<7 | 0x37,
	30766 - 19968: jis0212<<14 | 0x2E<<7 | 0x38,
	30768 - 19968: jis0212<<14 | 0x2E<<7 | 0x39,
	30770 - 19968: jis0208<<14 | 0x2A<<7 | 0x03,
	30772 - 19968: jis0208<<14 | 0x26<<7 | 0x2A,
	30773 - 19968: jis0212<<14 | 0x2E<<7 | 0x3A,
	30775 - 19968: jis0212<<14 | 0x2E<<7 | 0x3B,
	30778 - 19968: jis0208<<14 | 0x24<<7 | 0x36,
	30783 - 19968: jis0208<<14 | 0x18<<7 | 0x3B,
	30787 - 19968: jis0212<<14 | 0x2E<<7 | 0x3C,
	30788 - 19968: jis0212<<14 | 0x2E<<7 | 0x3D,
	30789 - 19968: jis0208<<14 | 0x41<<7 | 0x4A,
	30791 - 19968: jis0212<<14 | 0x2E<<7 | 0x3E,
	30792 - 19968: jis0212<<14 | 0x2E<<7 | 0x3F,
	30796 - 19968: jis0212<<14 | 0x2E<<7 | 0x40,
	30798 - 19968: jis0208<<14 | 0x5A<<7 | 0x1D,
	30802 - 19968: jis0212<<14 | 0x2E<<7 | 0x42,
	30812 - 19968: jis0212<<14 | 0x2E<<7 | 0x43,
	30813 - 19968: jis0208<<14 | 0x1D<<7 | 0x2A,
	30814 - 19968: jis0212<<14 | 0x2E<<7 | 0x44,
	30816 - 19968: jis0212<<14 | 0x2E<<7 | 0x45,
	30817 - 19968: jis0212<<14 | 0x2E<<7 | 0x46,
	30819 - 19968: jis0212<<14 | 0x2E<<7 | 0x47,
	30820 - 19968: jis0208<<14 | 0x5A<<7 | 0x1E,
	30824 - 19968: jis0212<<14 | 0x2E<<7 | 0x49,
	30826 - 19968: jis0212<<14 | 0x2E<<7 | 0x4A,
	30827 - 19968: jis0208<<14 | 0x2D<<7 | 0x11,
	30828 - 19968: jis0208<<14 | 0x18<<7 | 0x24,
	30830 - 19968: jis0212<<14 | 0x2E<<7 | 0x4B,
	30831 - 19968: jis0208<<14 | 0x17<<7 | 0x06,
	30834 - 19968: jis0208<<14 | 0x27<<7 | 0x02,
	30836 - 19968: jis0208<<14 | 0x41<<7 | 0x4C,
	30842 - 19968: jis0208<<14 | 0x5A<<7 | 0x1F,
	30844 - 19968: jis0208<<14 | 0x41<<7 | 0x4E,
	30846 - 19968: jis0212<<14 | 0x2E<<7 | 0x4D,
	30849 - 19968: jis0208<<14 | 0x17<<7 | 0x4A,
	30854 - 19968: jis0208<<14 | 0x41<<7 | 0x4D,
	30855 - 19968: jis0208<<14 | 0x23<<7 | 0x55,
	30858 - 19968: jis0212<<14 | 0x2E<<7 | 0x4E,
	30860 - 19968: jis0208<<14 | 0x41<<7 | 0x50,
	30861 - 19968: jis0208<<14 | 0x12<<7 | 0x16,
	30862 - 19968: jis0208<<14 | 0x41<<7 | 0x4B,
	30863 - 19968: jis0212<<14 | 0x2E<<7 | 0x4F,
	30865 - 19968: jis0208<<14 | 0x27<<7 | 0x49,
	30867 - 19968: jis0208<<14 | 0x10<<7 | 0x0F,
	30868 - 19968: jis0212<<14 | 0x2E<<7 | 0x50,
	30869 - 19968: jis0208<<14 | 0x19<<7 | 0x4B,
	30871 - 19968: jis0208<<14 | 0x2E<<7 | 0x31,
	30872 - 19968: jis0212<<14 | 0x2E<<7 | 0x51,
	30874 - 19968: jis0208<<14 | 0x41<<7 | 0x4F,
	30877 - 19968: jis0212<<14 | 0x2E<<7 | 0x53,
	30878 - 19968: jis0212<<14 | 0x2E<<7 | 0x54,
	30879 - 19968: jis0212<<14 | 0x2E<<7 | 0x55,
	30881 - 19968: jis0212<<14 | 0x2E<<7 | 0x52,
	30883 - 19968: jis0208<<14 | 0x41<<7 | 0x51,
	30884 - 19968: jis0212<<14 | 0x2E<<7 | 0x56,
	30887 - 19968: jis0208<<14 | 0x29<<7 | 0x2A,
	30888 - 19968: jis0212<<14 | 0x2E<<7 | 0x57,
	30889 - 19968: jis0208<<14 | 0x1F<<7 | 0x38,
	30890 - 19968: jis0208<<14 | 0x41<<7 | 0x53,
	30892 - 19968: jis0212<<14 | 0x2E<<7 | 0x58,
	30893 - 19968: jis0212<<14 | 0x2E<<7 | 0x59,
	30895 - 19968: jis0208<<14 | 0x41<<7 | 0x54,
	30896 - 19968: jis0212<<14 | 0x2E<<7 | 0x5A,
	30897 - 19968: jis0212<<14 | 0x2E<<7 | 0x5B,
	30898 - 19968: jis0212<<14 | 0x2E<<7 | 0x5C,
	30899 - 19968: jis0212<<14 | 0x2E<<7 | 0x5D,
	30901 - 19968: jis0208<<14 | 0x41<<7 | 0x52,
	30906 - 19968: jis0208<<14 | 0x12<<7 | 0x2D,
	30907 - 19968: jis0212<<14 | 0x2F<<7 | 0x00,
	30908 - 19968: jis0208<<14 | 0x41<<7 | 0x5A,
	30909 - 19968: jis0212<<14 | 0x2F<<7 | 0x01,
	30910 - 19968: jis0208<<14 | 0x41<<7 | 0x59,
	30911 - 19968: jis0212<<14 | 0x2F<<7 | 0x02,
	30913 - 19968: jis0208<<14 | 0x1B<<7 | 0x06,
	30917 - 19968: jis0208<<14 | 0x41<<7 | 0x5B,
	30918 - 19968: jis0208<<14 | 0x41<<7 | 0x56,
	30919 - 19968: jis0212<<14 | 0x2F<<7 | 0x03,
	30920 - 19968: jis0212<<14 | 0x2F<<7 | 0x04,
	30921 - 19968: jis0212<<14 | 0x2F<<7 | 0x05,
	30922 - 19968: jis0208<<14 | 0x41<<7 | 0x5C,
	30923 - 19968: jis0208<<14 | 0x41<<7 | 0x57,
	30924 - 19968: jis0212<<14 | 0x2F<<7 | 0x06,
	30926 - 19968: jis0212<<14 | 0x2F<<7 | 0x07,
	30928 - 19968: jis0208<<14 | 0x27<<7 | 0x37,
	30929 - 19968: jis0208<<14 | 0x41<<7 | 0x55,
	30930 - 19968: jis0212<<14 | 0x2F<<7 | 0x08,
	30931 - 19968: jis0212<<14 | 0x2F<<7 | 0x09,
	30932 - 19968: jis0208<<14 | 0x41<<7 | 0x58,
	30933 - 19968: jis0212<<14 | 0x2F<<7 | 0x0A,
	30934 - 19968: jis0212<<14 | 0x2F<<7 | 0x0B,
	30938 - 19968: jis0208<<14 | 0x42<<7 | 0x01,
	30939 - 19968: jis0212<<14 | 0x2F<<7 | 0x0D,
	30943 - 19968: jis0212<<14 | 0x2F<<7 | 0x0E,
	30944 - 19968: jis0212<<14 | 0x2F<<7 | 0x0F,
	30945 - 19968: jis0212<<14 | 0x2F<<7 | 0x10,
	30948 - 19968: jis0212<<14 | 0x2F<<7 | 0x0C,
	30950 - 19968: jis0212<<14 | 0x2F<<7 | 0x11,
	30951 - 19968: jis0208<<14 | 0x42<<7 | 0x00,
	30952 - 19968: jis0208<<14 | 0x2A<<7 | 0x40,
	30954 - 19968: jis0212<<14 | 0x2F<<7 | 0x12,
	30956 - 19968: jis0208<<14 | 0x41<<7 | 0x5D,
	30959 - 19968: jis0208<<14 | 0x0F<<7 | 0x4A,
	30962 - 19968: jis0212<<14 | 0x2F<<7 | 0x13,
	30963 - 19968: jis0212<<14 | 0x2F<<7 | 0x14,
	30964 - 19968: jis0208<<14 | 0x42<<7 | 0x03,
	30966 - 19968: jis0212<<14 | 0x2F<<7 | 0x16,
	30967 - 19968: jis0212<<14 | 0x2F<<7 | 0x17,
	30970 - 19968: jis0212<<14 | 0x2F<<7 | 0x18,
	30971 - 19968: jis0212<<14 | 0x2F<<7 | 0x19,
	30973 - 19968: jis0208<<14 | 0x42<<7 | 0x02,
	30975 - 19968: jis0212<<14 | 0x2F<<7 | 0x1A,
	30976 - 19968: jis0212<<14 | 0x2F<<7 | 0x15,
	30977 - 19968: jis0208<<14 | 0x1D<<7 | 0x2B,
	30982 - 19968: jis0212<<14 | 0x2F<<7 | 0x1B,
	30983 - 19968: jis0208<<14 | 0x42<<7 | 0x04,
	30988 - 19968: jis0212<<14 | 0x2F<<7 | 0x1C,
	30990 - 19968: jis0208<<14 | 0x20<<7 | 0x22,
	30992 - 19968: jis0212<<14 | 0x2F<<7 | 0x1D,
	30993 - 19968: jis0208<<14 | 0x42<<7 | 0x06,
	30994 - 19968: jis0208<<14 | 0x42<<7 | 0x05,
	31001 - 19968: jis0208<<14 | 0x42<<7 | 0x07,
	31002 - 19968: jis0212<<14 | 0x2F<<7 | 0x1E,
	31004 - 19968: jis0212<<14 | 0x2F<<7 | 0x1F,
	31006 - 19968: jis0212<<14 | 0x2F<<7 | 0x20,
	31007 - 19968: jis0212<<14 | 0x2F<<7 | 0x21,
	31008 - 19968: jis0212<<14 | 0x2F<<7 | 0x22,
	31013 - 19968: jis0212<<14 | 0x2F<<7 | 0x23,
	31014 - 19968: jis0208<<14 | 0x41<<7 | 0x47,
	31015 - 19968: jis0212<<14 | 0x2F<<7 | 0x24,
	31017 - 19968: jis0212<<14 | 0x2F<<7 | 0x25,
	31018 - 19968: jis0208<<14 | 0x41<<7 | 0x49,
	31019 - 19968: jis0208<<14 | 0x42<<7 | 0x09,
	31020 - 19968: jis0208<<14 | 0x42<<7 | 0x08,
	31021 - 19968: jis0212<<14 | 0x2F<<7 | 0x26,
	31024 - 19968: jis0208<<14 | 0x5A<<7 | 0x20,
	31025 - 19968: jis0212<<14 | 0x2F<<7 | 0x27,
	31028 - 19968: jis0212<<14 | 0x2F<<7 | 0x28,
	31029 - 19968: jis0212<<14 | 0x2F<<7 | 0x29,
	31034 - 19968: jis0208<<14 | 0x1B<<7 | 0x07,
	31035 - 19968: jis0212<<14 | 0x2F<<7 | 0x2A,
	31036 - 19968: jis0208<<14 | 0x2D<<7 | 0x48,
	31037 - 19968: jis0212<<14 | 0x2F<<7 | 0x2B,
	31038 - 19968: jis0208<<14 | 0x1B<<7 | 0x31,
	31039 - 19968: jis0212<<14 | 0x2F<<7 | 0x2C,
	31040 - 19968: jis0208<<14 | 0x42<<7 | 0x0A,
	31041 - 19968: jis0208<<14 | 0x16<<7 | 0x16,
	31044 - 19968: jis0212<<14 | 0x2F<<7 | 0x2D,
	31045 - 19968: jis0212<<14 | 0x2F<<7 | 0x2E,
	31046 - 19968: jis0212<<14 | 0x2F<<7 | 0x2F,
	31047 - 19968: jis0208<<14 | 0x14<<7 | 0x1F,
	31048 - 19968: jis0208<<14 | 0x14<<7 | 0x06,
	31049 - 19968: jis0208<<14 | 0x1A<<7 | 0x42,
	31050 - 19968: jis0212<<14 | 0x2F<<7 | 0x30,
	31051 - 19968: jis0212<<14 | 0x2F<<7 | 0x31,
	31055 - 19968: jis0212<<14 | 0x2F<<7 | 0x32,
	31056 - 19968: jis0208<<14 | 0x2C<<7 | 0x13,
	31057 - 19968: jis0212<<14 | 0x2F<<7 | 0x33,
	31059 - 19968: jis0208<<14 | 0x42<<7 | 0x10,
	31060 - 19968: jis0212<<14 | 0x2F<<7 | 0x34,
	31061 - 19968: jis0208<<14 | 0x42<<7 | 0x0F,
	31062 - 19968: jis0208<<14 | 0x20<<7 | 0x23,
	31063 - 19968: jis0208<<14 | 0x42<<7 | 0x0C,
	31064 - 19968: jis0212<<14 | 0x2F<<7 | 0x35,
	31066 - 19968: jis0208<<14 | 0x42<<7 | 0x0E,
	31067 - 19968: jis0212<<14 | 0x2F<<7 | 0x36,
	31068 - 19968: jis0212<<14 | 0x2F<<7 | 0x37,
	31069 - 19968: jis0208<<14 | 0x1C<<7 | 0x2A,
	31070 - 19968: jis0208<<14 | 0x1E<<7 | 0x1F,
	31071 - 19968: jis0208<<14 | 0x42<<7 | 0x0D,
	31072 - 19968: jis0208<<14 | 0x42<<7 | 0x0B,
	31074 - 19968: jis0208<<14 | 0x26<<7 | 0x09,
	31077 - 19968: jis0208<<14 | 0x1D<<7 | 0x2C,
	31079 - 19968: jis0212<<14 | 0x2F<<7 | 0x38,
	31080 - 19968: jis0208<<14 | 0x28<<7 | 0x1B,
	31081 - 19968: jis0212<<14 | 0x2F<<7 | 0x39,
	31083 - 19968: jis0212<<14 | 0x2F<<7 | 0x3A,
	31085 - 19968: jis0208<<14 | 0x19<<7 | 0x36,
	31090 - 19968: jis0212<<14 | 0x2F<<7 | 0x3B,
	31095 - 19968: jis0208<<14 | 0x24<<7 | 0x57,
	31097 - 19968: jis0212<<14 | 0x2F<<7 | 0x3C,
	31098 - 19968: jis0208<<14 | 0x42<<7 | 0x11,
	31099 - 19968: jis0212<<14 | 0x2F<<7 | 0x3D,
	31100 - 19968: jis0212<<14 | 0x2F<<7 | 0x3E,
	31102 - 19968: jis0212<<14 | 0x2F<<7 | 0x3F,
	31103 - 19968: jis0208<<14 | 0x42<<7 | 0x12,
	31104 - 19968: jis0208<<14 | 0x42<<7 | 0x28,
	31105 - 19968: jis0208<<14 | 0x15<<7 | 0x37,
	31108 - 19968: jis0208<<14 | 0x2E<<7 | 0x1C,
	31109 - 19968: jis0208<<14 | 0x20<<7 | 0x14,
	31114 - 19968: jis0208<<14 | 0x42<<7 | 0x13,
	31115 - 19968: jis0212<<14 | 0x2F<<7 | 0x40,
	31116 - 19968: jis0212<<14 | 0x2F<<7 | 0x41,
	31117 - 19968: jis0208<<14 | 0x11<<7 | 0x31,
	31118 - 19968: jis0208<<14 | 0x23<<7 | 0x56,
	31119 - 19968: jis0208<<14 | 0x29<<7 | 0x00,
	31121 - 19968: jis0212<<14 | 0x2F<<7 | 0x42,
	31123 - 19968: jis0212<<14 | 0x2F<<7 | 0x43,
	31124 - 19968: jis0208<<14 | 0x5A<<7 | 0x24,
	31125 - 19968: jis0212<<14 | 0x2F<<7 | 0x45,
	31126 - 19968: jis0212<<14 | 0x2F<<7 | 0x46,
	31128 - 19968: jis0212<<14 | 0x2F<<7 | 0x47,
	31131 - 19968: jis0208<<14 | 0x5A<<7 | 0x26,
	31132 - 19968: jis0212<<14 | 0x2F<<7 | 0x49,
	31133 - 19968: jis0208<<14 | 0x42<<7 | 0x14,
	31137 - 19968: jis0212<<14 | 0x2F<<7 | 0x4A,
	31142 - 19968: jis0208<<14 | 0x14<<7 | 0x59,
	31143 - 19968: jis0208<<14 | 0x42<<7 | 0x15,
	31144 - 19968: jis0212<<14 | 0x2F<<7 | 0x4B,
	31145 - 19968: jis0212<<14 | 0x2F<<7 | 0x4C,
	31146 - 19968: jis0208<<14 | 0x42<<7 | 0x17,
	31147 - 19968: jis0212<<14 | 0x2F<<7 | 0x4D,
	31150 - 19968: jis0208<<14 | 0x42<<7 | 0x18,
	31151 - 19968: jis0212<<14 | 0x2F<<7 | 0x4E,
	31152 - 19968: jis0208<<14 | 0x26<<7 | 0x08,
	31153 - 19968: jis0212<<14 | 0x2F<<7 | 0x4F,
	31155 - 19968: jis0208<<14 | 0x42<<7 | 0x19,
	31156 - 19968: jis0212<<14 | 0x2F<<7 | 0x50,
	31160 - 19968: jis0212<<14 | 0x2F<<7 | 0x51,
	31161 - 19968: jis0208<<14 | 0x42<<7 | 0x1A,
	31162 - 19968: jis0208<<14 | 0x42<<7 | 0x1B,
	31163 - 19968: jis0212<<14 | 0x2F<<7 | 0x52,
	31165 - 19968: jis0208<<14 | 0x15<<7 | 0x38,
	31166 - 19968: jis0208<<14 | 0x11<<7 | 0x32,
	31167 - 19968: jis0208<<14 | 0x25<<7 | 0x24,
	31168 - 19968: jis0208<<14 | 0x1C<<7 | 0x07,
	31169 - 19968: jis0208<<14 | 0x1A<<7 | 0x43,
	31170 - 19968: jis0212<<14 | 0x2F<<7 | 0x53,
	31172 - 19968: jis0212<<14 | 0x2F<<7 | 0x54,
	31175 - 19968: jis0212<<14 | 0x2F<<7 | 0x55,
	31176 - 19968: jis0212<<14 | 0x2F<<7 | 0x56,
	31177 - 19968: jis0208<<14 | 0x42<<7 | 0x1C,
	31178 - 19968: jis0212<<14 | 0x2F<<7 | 0x57,
	31179 - 19968: jis0208<<14 | 0x1C<<7 | 0x08,
	31183 - 19968: jis0212<<14 | 0x2F<<7 | 0x58,
	31185 - 19968: jis0208<<14 | 0x11<<7 | 0x29,
	31186 - 19968: jis0208<<14 | 0x28<<7 | 0x22,
	31188 - 19968: jis0212<<14 | 0x2F<<7 | 0x59,
	31189 - 19968: jis0208<<14 | 0x42<<7 | 0x1D,
	31190 - 19968: jis0212<<14 | 0x2F<<7 | 0x5A,
	31192 - 19968: jis0208<<14 | 0x27<<7 | 0x4A,
	31194 - 19968: jis0212<<14 | 0x2F<<7 | 0x5B,
	31197 - 19968: jis0212<<14 | 0x2F<<7 | 0x5C,
	31198 - 19968: jis0212<<14 | 0x2F<<7 | 0x5D,
	31199 - 19968: jis0208<<14 | 0x20<<7 | 0x24,
	31200 - 19968: jis0212<<14 | 0x30<<7 | 0x00,
	31201 - 19968: jis0208<<14 | 0x42<<7 | 0x20,
	31202 - 19968: jis0212<<14 | 0x30<<7 | 0x01,
	31203 - 19968: jis0208<<14 | 0x42<<7 | 0x21,
	31204 - 19968: jis0208<<14 | 0x26<<7 | 0x48,
	31205 - 19968: jis0212<<14 | 0x30<<7 | 0x02,
	31206 - 19968: jis0208<<14 | 0x1E<<7 | 0x20,
	31207 - 19968: jis0208<<14 | 0x42<<7 | 0x1E,
	31209 - 19968: jis0208<<14 | 0x22<<7 | 0x40,
	31210 - 19968: jis0212<<14 | 0x30<<7 | 0x03,
	31211 - 19968: jis0212<<14 | 0x30<<7 | 0x04,
	31212 - 19968: jis0208<<14 | 0x42<<7 | 0x1F,
	31213 - 19968: jis0212<<14 | 0x30<<7 | 0x05,
	31216 - 19968: jis0208<<14 | 0x1D<<7 | 0x2D,
	31217 - 19968: jis0212<<14 | 0x30<<7 | 0x06,
	31224 - 19968: jis0212<<14 | 0x30<<7 | 0x07,
	31227 - 19968: jis0208<<14 | 0x0F<<7 | 0x3B,
	31228 - 19968: jis0212<<14 | 0x30<<7 | 0x08,
	31232 - 19968: jis0208<<14 | 0x14<<7 | 0x08,
	31234 - 19968: jis0212<<14 | 0x30<<7 | 0x09,
	31235 - 19968: jis0212<<14 | 0x30<<7 | 0x0A,
	31239 - 19968: jis0212<<14 | 0x30<<7 | 0x0B,
	31240 - 19968: jis0208<<14 | 0x42<<7 | 0x22,
	31241 - 19968: jis0212<<14 | 0x30<<7 | 0x0C,
	31242 - 19968: jis0212<<14 | 0x30<<7 | 0x0D,
	31243 - 19968: jis0208<<14 | 0x23<<7 | 0x57,
	31244 - 19968: jis0212<<14 | 0x30<<7 | 0x0E,
	31245 - 19968: jis0208<<14 | 0x42<<7 | 0x23,
	31246 - 19968: jis0208<<14 | 0x1F<<7 | 0x26,
	31249 - 19968: jis0212<<14 | 0x30<<7 | 0x0F,
	31252 - 19968: jis0208<<14 | 0x2B<<7 | 0x0C,
	31253 - 19968: jis0212<<14 | 0x30<<7 | 0x10,
	31255 - 19968: jis0208<<14 | 0x28<<7 | 0x02,
	31256 - 19968: jis0208<<14 | 0x42<<7 | 0x24,
	31257 - 19968: jis0208<<14 | 0x42<<7 | 0x25,
	31258 - 19968: jis0208<<14 | 0x22<<7 | 0x34,
	31259 - 19968: jis0212<<14 | 0x30<<7 | 0x11,
	31260 - 19968: jis0208<<14 | 0x2D<<7 | 0x26,
	31262 - 19968: jis0212<<14 | 0x30<<7 | 0x12,
	31263 - 19968: jis0208<<14 | 0x42<<7 | 0x27,
	31264 - 19968: jis0208<<14 | 0x42<<7 | 0x26,
	31265 - 19968: jis0212<<14 | 0x30<<7 | 0x13,
	31271 - 19968: jis0212<<14 | 0x30<<7 | 0x14,
	31275 - 19968: jis0212<<14 | 0x30<<7 | 0x15,
	31277 - 19968: jis0212<<14 | 0x30<<7 | 0x16,
	31278 - 19968: jis0208<<14 | 0x1B<<7 | 0x4E,
	31279 - 19968: jis0212<<14 | 0x30<<7 | 0x17,
	31280 - 19968: jis0212<<14 | 0x30<<7 | 0x18,
	31281 - 19968: jis0208<<14 | 0x42<<7 | 0x29,
	31282 - 19968: jis0208<<14 | 0x0F<<7 | 0x4F,
	31284 - 19968: jis0212<<14 | 0x30<<7 | 0x19,
	31285 - 19968: jis0212<<14 | 0x30<<7 | 0x1A,
	31287 - 19968: jis0208<<14 | 0x42<<7 | 0x2C,
	31288 - 19968: jis0212<<14 | 0x30<<7 | 0x1B,
	31289 - 19968: jis0212<<14 | 0x30<<7 | 0x1C,
	31290 - 19968: jis0212<<14 | 0x30<<7 | 0x1D,
	31291 - 19968: jis0208<<14 | 0x42<<7 | 0x2A,
	31292 - 19968: jis0208<<14 | 0x11<<7 | 0x33,
	31293 - 19968: jis0208<<14 | 0x16<<7 | 0x2D,
	31294 - 19968: jis0208<<14 | 0x42<<7 | 0x2B,
	31295 - 19968: jis0208<<14 | 0x18<<7 | 0x25,
	31296 - 19968: jis0208<<14 | 0x18<<7 | 0x51,
	31298 - 19968: jis0208<<14 | 0x29<<7 | 0x45,
	31299 - 19968: jis0208<<14 | 0x42<<7 | 0x2D,
	31300 - 19968: jis0212<<14 | 0x30<<7 | 0x1E,
	31301 - 19968: jis0212<<14 | 0x30<<7 | 0x1F,
	31302 - 19968: jis0208<<14 | 0x2A<<7 | 0x33,
	31303 - 19968: jis0212<<14 | 0x30<<7 | 0x20,
	31304 - 19968: jis0212<<14 | 0x30<<7 | 0x21,
	31305 - 19968: jis0208<<14 | 0x42<<7 | 0x2F,
	31308 - 19968: jis0212<<14 | 0x30<<7 | 0x22,
	31309 - 19968: jis0208<<14 | 0x1F<<7 | 0x30,
	31310 - 19968: jis0208<<14 | 0x10<<7 | 0x2E,
	31311 - 19968: jis0208<<14 | 0x11<<7 | 0x19,
	31312 - 19968: jis0208<<14 | 0x0F<<7 | 0x0B,
	31317 - 19968: jis0212<<14 | 0x30<<7 | 0x23,
	31318 - 19968: jis0212<<14 | 0x30<<7 | 0x24,
	31319 - 19968: jis0208<<14 | 0x42<<7 | 0x2E,
	31321 - 19968: jis0212<<14 | 0x30<<7 | 0x25,
	31324 - 19968: jis0212<<14 | 0x30<<7 | 0x26,
	31325 - 19968: jis0212<<14 | 0x30<<7 | 0x27,
	31327 - 19968: jis0212<<14 | 0x30<<7 | 0x28,
	31328 - 19968: jis0212<<14 | 0x30<<7 | 0x29,
	31329 - 19968: jis0208<<14 | 0x42<<7 | 0x30,
	31330 - 19968: jis0208<<14 | 0x42<<7 | 0x31,
	31331 - 19968: jis0208<<14 | 0x1D<<7 | 0x56,
	31333 - 19968: jis0212<<14 | 0x30<<7 | 0x2A,
	31335 - 19968: jis0212<<14 | 0x30<<7 | 0x2B,
	31337 - 19968: jis0208<<14 | 0x42<<7 | 0x32,
	31338 - 19968: jis0212<<14 | 0x30<<7 | 0x2C,
	31339 - 19968: jis0208<<14 | 0x12<<7 | 0x2E,
	31341 - 19968: jis0212<<14 | 0x30<<7 | 0x2D,
	31344 - 19968: jis0208<<14 | 0x42<<7 | 0x34,
	31348 - 19968: jis0208<<14 | 0x16<<7 | 0x49,
	31349 - 19968: jis0212<<14 | 0x30<<7 | 0x2E,
	31350 - 19968: jis0208<<14 | 0x14<<7 | 0x45,
	31352 - 19968: jis0212<<14 | 0x30<<7 | 0x2F,
	31353 - 19968: jis0208<<14 | 0x42<<7 | 0x35,
	31354 - 19968: jis0208<<14 | 0x15<<7 | 0x54,
	31357 - 19968: jis0208<<14 | 0x42<<7 | 0x36,
	31358 - 19968: jis0212<<14 | 0x30<<7 | 0x30,
	31359 - 19968: jis0208<<14 | 0x1F<<7 | 0x5B,
	31360 - 19968: jis0212<<14 | 0x30<<7 | 0x31,
	31361 - 19968: jis0208<<14 | 0x25<<7 | 0x2C,
	31362 - 19968: jis0212<<14 | 0x30<<7 | 0x32,
	31363 - 19968: jis0208<<14 | 0x1F<<7 | 0x3F,
	31364 - 19968: jis0208<<14 | 0x19<<7 | 0x54,
	31365 - 19968: jis0212<<14 | 0x30<<7 | 0x33,
	31366 - 19968: jis0212<<14 | 0x30<<7 | 0x34,
	31368 - 19968: jis0208<<14 | 0x42<<7 | 0x37,
	31370 - 19968: jis0212<<14 | 0x30<<7 | 0x35,
	31371 - 19968: jis0212<<14 | 0x30<<7 | 0x36,
	31376 - 19968: jis0212<<14 | 0x30<<7 | 0x37,
	31377 - 19968: jis0212<<14 | 0x30<<7 | 0x38,
	31378 - 19968: jis0208<<14 | 0x22<<7 | 0x41,
	31379 - 19968: jis0208<<14 | 0x20<<7 | 0x4A,
	31380 - 19968: jis0212<<14 | 0x30<<7 | 0x39,
	31381 - 19968: jis0208<<14 | 0x42<<7 | 0x39,
	31382 - 19968: jis0208<<14 | 0x42<<7 | 0x3B,
	31383 - 19968: jis0208<<14 | 0x42<<7 | 0x38,
	31384 - 19968: jis0208<<14 | 0x42<<7 | 0x3A,
	31390 - 19968: jis0212<<14 | 0x30<<7 | 0x3A,
	31391 - 19968: jis0208<<14 | 0x16<<7 | 0x01,
	31392 - 19968: jis0212<<14 | 0x30<<7 | 0x3B,
	31395 - 19968: jis0212<<14 | 0x30<<7 | 0x3C,
	31401 - 19968: jis0208<<14 | 0x42<<7 | 0x3C,
	31402 - 19968: jis0208<<14 | 0x16<<7 | 0x05,
	31404 - 19968: jis0212<<14 | 0x30<<7 | 0x3D,
	31406 - 19968: jis0208<<14 | 0x14<<7 | 0x46,
	31407 - 19968: jis0208<<14 | 0x2C<<7 | 0x31,
	31408 - 19968: jis0208<<14 | 0x42<<7 | 0x3E,
	31411 - 19968: jis0212<<14 | 0x30<<7 | 0x3E,
	31413 - 19968: jis0212<<14 | 0x30<<7 | 0x3F,
	31414 - 19968: jis0208<<14 | 0x42<<7 | 0x3F,
	31417 - 19968: jis0212<<14 | 0x30<<7 | 0x40,
	31418 - 19968: jis0208<<14 | 0x10<<7 | 0x0D,
	31419 - 19968: jis0212<<14 | 0x30<<7 | 0x41,
	31420 - 19968: jis0212<<14 | 0x30<<7 | 0x42,
	31423 - 19968: jis0208<<14 | 0x42<<7 | 0x42,
	31427 - 19968: jis0208<<14 | 0x12<<7 | 0x55,
	31428 - 19968: jis0208<<14 | 0x42<<7 | 0x41,
	31429 - 19968: jis0208<<14 | 0x42<<7 | 0x40,
	31430 - 19968: jis0212<<14 | 0x30<<7 | 0x43,
	31431 - 19968: jis0208<<14 | 0x42<<7 | 0x44,
	31432 - 19968: jis0208<<14 | 0x42<<7 | 0x3D,
	31433 - 19968: jis0212<<14 | 0x30<<7 | 0x44,
	31434 - 19968: jis0208<<14 | 0x42<<7 | 0x45,
	31435 - 19968: jis0208<<14 | 0x2D<<7 | 0x08,
	31436 - 19968: jis0212<<14 | 0x30<<7 | 0x45,
	31437 - 19968: jis0208<<14 | 0x42<<7 | 0x46,
	31438 - 19968: jis0212<<14 | 0x30<<7 | 0x46,
	31439 - 19968: jis0208<<14 | 0x42<<7 | 0x47,
	31441 - 19968: jis0208<<14 | 0x5A<<7 | 0x27,
	31442 - 19968: jis0208<<14 | 0x33<<7 | 0x53,
	31443 - 19968: jis0208<<14 | 0x42<<7 | 0x49,
	31445 - 19968: jis0208<<14 | 0x42<<7 | 0x48,
	31449 - 19968: jis0208<<14 | 0x42<<7 | 0x4A,
	31450 - 19968: jis0208<<14 | 0x42<<7 | 0x4B,
	31451 - 19968: jis0212<<14 | 0x30<<7 | 0x48,
	31452 - 19968: jis0208<<14 | 0x2D<<7 | 0x14,
	31453 - 19968: jis0208<<14 | 0x42<<7 | 0x4C,
	31455 - 19968: jis0208<<14 | 0x4F<<7 | 0x4E,
	31456 - 19968: jis0208<<14 | 0x1D<<7 | 0x2E,
	31457 - 19968: jis0208<<14 | 0x42<<7 | 0x4D,
	31458 - 19968: jis0208<<14 | 0x42<<7 | 0x4E,
	31459 - 19968: jis0208<<14 | 0x1C<<7 | 0x36,
	31461 - 19968: jis0208<<14 | 0x25<<7 | 0x17,
	31462 - 19968: jis0208<<14 | 0x42<<7 | 0x4F,
	31463 - 19968: jis0208<<14 | 0x5A<<7 | 0x28,
	31464 - 19968: jis0212<<14 | 0x30<<7 | 0x49,
	31465 - 19968: jis0212<<14 | 0x30<<7 | 0x4A,
	31466 - 19968: jis0208<<14 | 0x22<<7 | 0x07,
	31467 - 19968: jis0208<<14 | 0x5A<<7 | 0x2A,
	31468 - 19968: jis0212<<14 | 0x30<<7 | 0x4C,
	31469 - 19968: jis0208<<14 | 0x42<<7 | 0x50,
	31471 - 19968: jis0208<<14 | 0x22<<7 | 0x1B,
	31472 - 19968: jis0208<<14 | 0x42<<7 | 0x51,
	31473 - 19968: jis0212<<14 | 0x30<<7 | 0x4D,
	31476 - 19968: jis0212<<14 | 0x30<<7 | 0x4E,
	31478 - 19968: jis0208<<14 | 0x15<<7 | 0x04,
	31480 - 19968: jis0208<<14 | 0x30<<7 | 0x1E,
	31481 - 19968: jis0208<<14 | 0x22<<7 | 0x3C,
	31482 - 19968: jis0208<<14 | 0x1B<<7 | 0x12,
	31483 - 19968: jis0212<<14 | 0x30<<7 | 0x4F,
	31485 - 19968: jis0212<<14 | 0x30<<7 | 0x50,
	31486 - 19968: jis0212<<14 | 0x30<<7 | 0x51,
	31487 - 19968: jis0208<<14 | 0x13<<7 | 0x27,
	31490 - 19968: jis0208<<14 | 0x42<<7 | 0x52,
	31492 - 19968: jis0208<<14 | 0x43<<7 | 0x01,
	31494 - 19968: jis0208<<14 | 0x42<<7 | 0x55,
	31495 - 19968: jis0212<<14 | 0x30<<7 | 0x52,
	31496 - 19968: jis0208<<14 | 0x14<<7 | 0x47,
	31498 - 19968: jis0208<<14 | 0x42<<7 | 0x54,
	31499 - 19968: jis0208<<14 | 0x43<<7 | 0x03,
	31503 - 19968: jis0208<<14 | 0x42<<7 | 0x53,
	31505 - 19968: jis0208<<14 | 0x1D<<7 | 0x2F,
	31508 - 19968: jis0212<<14 | 0x30<<7 | 0x53,
	31512 - 19968: jis0208<<14 | 0x42<<7 | 0x57,
	31513 - 19968: jis0208<<14 | 0x42<<7 | 0x58,
	31515 - 19968: jis0208<<14 | 0x24<<7 | 0x0A,
	31518 - 19968: jis0208<<14 | 0x42<<7 | 0x59,
	31519 - 19968: jis0212<<14 | 0x30<<7 | 0x54,
	31520 - 19968: jis0208<<14 | 0x12<<7 | 0x3D,
	31523 - 19968: jis0212<<14 | 0x30<<7 | 0x55,
	31525 - 19968: jis0208<<14 | 0x1E<<7 | 0x39,
	31526 - 19968: jis0208<<14 | 0x28<<7 | 0x43,
	31527 - 19968: jis0212<<14 | 0x30<<7 | 0x56,
	31528 - 19968: jis0208<<14 | 0x42<<7 | 0x5B,
	31529 - 19968: jis0212<<14 | 0x30<<7 | 0x57,
	31530 - 19968: jis0212<<14 | 0x30<<7 | 0x58,
	31531 - 19968: jis0212<<14 | 0x30<<7 | 0x59,
	31532 - 19968: jis0208<<14 | 0x21<<7 | 0x47,
	31533 - 19968: jis0212<<14 | 0x30<<7 | 0x5A,
	31534 - 19968: jis0212<<14 | 0x30<<7 | 0x5B,
	31535 - 19968: jis0212<<14 | 0x30<<7 | 0x5C,
	31536 - 19968: jis0212<<14 | 0x30<<7 | 0x5D,
	31537 - 19968: jis0212<<14 | 0x31<<7 | 0x00,
	31539 - 19968: jis0208<<14 | 0x42<<7 | 0x56,
	31540 - 19968: jis0212<<14 | 0x31<<7 | 0x01,
	31541 - 19968: jis0208<<14 | 0x42<<7 | 0x5A,
	31542 - 19968: jis0208<<14 | 0x42<<7 | 0x5C,
	31545 - 19968: jis0208<<14 | 0x19<<7 | 0x5A,
	31549 - 19968: jis0212<<14 | 0x31<<7 | 0x02,
	31551 - 19968: jis0212<<14 | 0x31<<7 | 0x03,
	31552 - 19968: jis0212<<14 | 0x31<<7 | 0x04,
	31553 - 19968: jis0212<<14 | 0x31<<7 | 0x05,
	31557 - 19968: jis0208<<14 | 0x43<<7 | 0x05,
	31558 - 19968: jis0208<<14 | 0x28<<7 | 0x0D,
	31559 - 19968: jis0212<<14 | 0x31<<7 | 0x06,
	31560 - 19968: jis0208<<14 | 0x27<<7 | 0x05,
	31561 - 19968: jis0208<<14 | 0x24<<7 | 0x58,
	31563 - 19968: jis0208<<14 | 0x15<<7 | 0x39,
	31564 - 19968: jis0208<<14 | 0x43<<7 | 0x04,
	31565 - 19968: jis0208<<14 | 0x43<<7 | 0x02,
	31566 - 19968: jis0212<<14 | 0x31<<7 | 0x07,
	31567 - 19968: jis0208<<14 | 0x27<<7 | 0x14,
	31568 - 19968: jis0208<<14 | 0x42<<7 | 0x5D,
	31569 - 19968: jis0208<<14 | 0x22<<7 | 0x3D,
	31570 - 19968: jis0208<<14 | 0x24<<7 | 0x5A,
	31572 - 19968: jis0208<<14 | 0x24<<7 | 0x59,
	31573 - 19968: jis0212<<14 | 0x31<<7 | 0x08,
	31574 - 19968: jis0208<<14 | 0x19<<7 | 0x55,
	31581 - 19968: jis0208<<14 | 0x43<<7 | 0x17,
	31584 - 19968: jis0212<<14 | 0x31<<7 | 0x09,
	31588 - 19968: jis0212<<14 | 0x31<<7 | 0x0A,
	31589 - 19968: jis0208<<14 | 0x43<<7 | 0x07,
	31590 - 19968: jis0212<<14 | 0x31<<7 | 0x0B,
	31591 - 19968: jis0208<<14 | 0x43<<7 | 0x09,
	31593 - 19968: jis0212<<14 | 0x31<<7 | 0x0C,
	31594 - 19968: jis0212<<14 | 0x31<<7 | 0x0D,
	31596 - 19968: jis0208<<14 | 0x43<<7 | 0x0C,
	31597 - 19968: jis0212<<14 | 0x31<<7 | 0x0E,
	31598 - 19968: jis0208<<14 | 0x43<<7 | 0x0D,
	31599 - 19968: jis0212<<14 | 0x31<<7 | 0x0F,
	31600 - 19968: jis0208<<14 | 0x43<<7 | 0x0A,
	31601 - 19968: jis0208<<14 | 0x43<<7 | 0x0B,
	31602 - 19968: jis0212<<14 | 0x31<<7 | 0x10,
	31603 - 19968: jis0212<<14 | 0x31<<7 | 0x11,
	31604 - 19968: jis0208<<14 | 0x43<<7 | 0x08,
	31605 - 19968: jis0208<<14 | 0x43<<7 | 0x06,
	31607 - 19968: jis0212<<14 | 0x31<<7 | 0x12,
	31610 - 19968: jis0208<<14 | 0x43<<7 | 0x00,
	31620 - 19968: jis0212<<14 | 0x31<<7 | 0x13,
	31622 - 19968: jis0208<<14 | 0x29<<7 | 0x2E,
	31623 - 19968: jis0208<<14 | 0x11<<7 | 0x34,
	31625 - 19968: jis0212<<14 | 0x31<<7 | 0x14,
	31627 - 19968: jis0208<<14 | 0x43<<7 | 0x14,
	31629 - 19968: jis0208<<14 | 0x43<<7 | 0x11,
	31630 - 19968: jis0212<<14 | 0x31<<7 | 0x15,
	31631 - 19968: jis0208<<14 | 0x43<<7 | 0x16,
	31632 - 19968: jis0212<<14 | 0x31<<7 | 0x16,
	31633 - 19968: jis0212<<14 | 0x31<<7 | 0x17,
	31634 - 19968: jis0208<<14 | 0x43<<7 | 0x15,
	31636 - 19968: jis0208<<14 | 0x26<<7 | 0x52,
	31637 - 19968: jis0208<<14 | 0x2B<<7 | 0x06,
	31638 - 19968: jis0212<<14 | 0x31<<7 | 0x18,
	31639 - 19968: jis0208<<14 | 0x1A<<7 | 0x1A,
	31640 - 19968: jis0208<<14 | 0x43<<7 | 0x0F,
	31641 - 19968: jis0208<<14 | 0x43<<7 | 0x18,
	31642 - 19968: jis0208<<14 | 0x43<<7 | 0x13,
	31643 - 19968: jis0212<<14 | 0x31<<7 | 0x19,
	31644 - 19968: jis0208<<14 | 0x43<<7 | 0x12,
	31645 - 19968: jis0208<<14 | 0x43<<7 | 0x0E,
	31646 - 19968: jis0208<<14 | 0x5A<<7 | 0x2B,
	31647 - 19968: jis0208<<14 | 0x43<<7 | 0x10,
	31648 - 19968: jis0212<<14 | 0x31<<7 | 0x1B,
	31649 - 19968: jis0208<<14 | 0x13<<7 | 0x28,
	31653 - 19968: jis0212<<14 | 0x31<<7 | 0x1C,
	31658 - 19968: jis0208<<14 | 0x22<<7 | 0x1C,
	31660 - 19968: jis0212<<14 | 0x31<<7 | 0x1D,
	31661 - 19968: jis0208<<14 | 0x1F<<7 | 0x5C,
	31663 - 19968: jis0212<<14 | 0x31<<7 | 0x1E,
	31664 - 19968: jis0212<<14 | 0x31<<7 | 0x1F,
	31665 - 19968: jis0208<<14 | 0x27<<7 | 0x01,
	31666 - 19968: jis0212<<14 | 0x31<<7 | 0x20,
	31668 - 19968: jis0208<<14 | 0x43<<7 | 0x1D,
	31669 - 19968: jis0212<<14 | 0x31<<7 | 0x21,
	31670 - 19968: jis0212<<14 | 0x31<<7 | 0x22,
	31672 - 19968: jis0208<<14 | 0x27<<7 | 0x03,
	31674 - 19968: jis0212<<14 | 0x31<<7 | 0x23,
	31675 - 19968: jis0212<<14 | 0x31<<7 | 0x24,
	31676 - 19968: jis0212<<14 | 0x31<<7 | 0x25,
	31677 - 19968: jis0212<<14 | 0x31<<7 | 0x26,
	31680 - 19968: jis0208<<14 | 0x1F<<7 | 0x40,
	31681 - 19968: jis0208<<14 | 0x43<<7 | 0x1A,
	31682 - 19968: jis0212<<14 | 0x31<<7 | 0x27,
	31684 - 19968: jis0208<<14 | 0x27<<7 | 0x2E,
	31685 - 19968: jis0212<<14 | 0x31<<7 | 0x28,
	31686 - 19968: jis0208<<14 | 0x43<<7 | 0x1E,
	31687 - 19968: jis0208<<14 | 0x29<<7 | 0x32,
	31688 - 19968: jis0212<<14 | 0x31<<7 | 0x29,
	31689 - 19968: jis0208<<14 | 0x22<<7 | 0x3A,
	31690 - 19968: jis0212<<14 | 0x31<<7 | 0x2A,
	31691 - 19968: jis0208<<14 | 0x43<<7 | 0x19,
	31692 - 19968: jis0208<<14 | 0x43<<7 | 0x1B,
	31695 - 19968: jis0208<<14 | 0x43<<7 | 0x1C,
	31700 - 19968: jis0212<<14 | 0x31<<7 | 0x2B,
	31702 - 19968: jis0212<<14 | 0x31<<7 | 0x2C,
	31703 - 19968: jis0212<<14 | 0x31<<7 | 0x2D,
	31705 - 19968: jis0212<<14 | 0x31<<7 | 0x2E,
	31706 - 19968: jis0212<<14 | 0x31<<7 | 0x2F,
	31707 - 19968: jis0212<<14 | 0x31<<7 | 0x30,
	31709 - 19968: jis0208<<14 | 0x43<<7 | 0x1F,
	31712 - 19968: jis0208<<14 | 0x1B<<7 | 0x23,
	31716 - 19968: jis0208<<14 | 0x25<<7 | 0x25,
	31717 - 19968: jis0208<<14 | 0x43<<7 | 0x24,
	31718 - 19968: jis0208<<14 | 0x43<<7 | 0x23,
	31720 - 19968: jis0212<<14 | 0x31<<7 | 0x31,
	31721 - 19968: jis0208<<14 | 0x43<<7 | 0x20,
	31722 - 19968: jis0212<<14 | 0x31<<7 | 0x32,
	31725 - 19968: jis0208<<14 | 0x2E<<7 | 0x15,
	31730 - 19968: jis0212<<14 | 0x31<<7 | 0x33,
	31731 - 19968: jis0208<<14 | 0x43<<7 | 0x29,
	31732 - 19968: jis0212<<14 | 0x31<<7 | 0x34,
	31733 - 19968: jis0212<<14 | 0x31<<7 | 0x35,
	31734 - 19968: jis0208<<14 | 0x43<<7 | 0x2D,
	31735 - 19968: jis0208<<14 | 0x43<<7 | 0x2A,
	31736 - 19968: jis0212<<14 | 0x31<<7 | 0x36,
	31737 - 19968: jis0212<<14 | 0x31<<7 | 0x37,
	31738 - 19968: jis0212<<14 | 0x31<<7 | 0x38,
	31740 - 19968: jis0212<<14 | 0x31<<7 | 0x39,
	31742 - 19968: jis0212<<14 | 0x31<<7 | 0x3A,
	31744 - 19968: jis0208<<14 | 0x43<<7 | 0x26,
	31745 - 19968: jis0212<<14 | 0x31<<7 | 0x3B,
	31746 - 19968: jis0212<<14 | 0x31<<7 | 0x3C,
	31747 - 19968: jis0212<<14 | 0x31<<7 | 0x3D,
	31748 - 19968: jis0212<<14 | 0x31<<7 | 0x3E,
	31750 - 19968: jis0212<<14 | 0x31<<7 | 0x3F,
	31751 - 19968: jis0208<<14 | 0x43<<7 | 0x27,
	31753 - 19968: jis0212<<14 | 0x31<<7 | 0x40,
	31755 - 19968: jis0212<<14 | 0x31<<7 | 0x41,
	31756 - 19968: jis0212<<14 | 0x31<<7 | 0x42,
	31757 - 19968: jis0208<<14 | 0x43<<7 | 0x2C,
	31758 - 19968: jis0212<<14 | 0x31<<7 | 0x43,
	31759 - 19968: jis0212<<14 | 0x31<<7 | 0x44,
	31761 - 19968: jis0208<<14 | 0x43<<7 | 0x21,
	31762 - 19968: jis0208<<14 | 0x31<<7 | 0x34,
	31763 - 19968: jis0208<<14 | 0x43<<7 | 0x28,
	31764 - 19968: jis0208<<14 | 0x43<<7 | 0x22,
	31767 - 19968: jis0208<<14 | 0x43<<7 | 0x2B,
	31769 - 19968: jis0212<<14 | 0x31<<7 | 0x45,
	31771 - 19968: jis0212<<14 | 0x31<<7 | 0x46,
	31775 - 19968: jis0208<<14 | 0x43<<7 | 0x31,
	31776 - 19968: jis0212<<14 | 0x31<<7 | 0x47,
	31777 - 19968: jis0208<<14 | 0x13<<7 | 0x29,
	31779 - 19968: jis0208<<14 | 0x43<<7 | 0x2E,
	31781 - 19968: jis0212<<14 | 0x31<<7 | 0x48,
	31782 - 19968: jis0212<<14 | 0x31<<7 | 0x49,
	31783 - 19968: jis0208<<14 | 0x43<<7 | 0x2F,
	31784 - 19968: jis0212<<14 | 0x31<<7 | 0x4A,
	31786 - 19968: jis0208<<14 | 0x43<<7 | 0x30,
	31787 - 19968: jis0208<<14 | 0x43<<7 | 0x33,
	31788 - 19968: jis0212<<14 | 0x31<<7 | 0x4B,
	31793 - 19968: jis0212<<14 | 0x31<<7 | 0x4C,
	31795 - 19968: jis0212<<14 | 0x31<<7 | 0x4D,
	31796 - 19968: jis0212<<14 | 0x31<<7 | 0x4E,
	31798 - 19968: jis0212<<14 | 0x31<<7 | 0x4F,
	31799 - 19968: jis0208<<14 | 0x43<<7 | 0x32,
	31800 - 19968: jis0208<<14 | 0x27<<7 | 0x55,
	31801 - 19968: jis0212<<14 | 0x31<<7 | 0x50,
	31802 - 19968: jis0212<<14 | 0x31<<7 | 0x51,
	31805 - 19968: jis0208<<14 | 0x43<<7 | 0x34,
	31806 - 19968: jis0208<<14 | 0x2D<<7 | 0x5B,
	31807 - 19968: jis0208<<14 | 0x29<<7 | 0x4C,
	31808 - 19968: jis0208<<14 | 0x43<<7 | 0x39,
	31811 - 19968: jis0208<<14 | 0x43<<7 | 0x36,
	31814 - 19968: jis0212<<14 | 0x31<<7 | 0x52,
	31818 - 19968: jis0212<<14 | 0x31<<7 | 0x53,
	31820 - 19968: jis0208<<14 | 0x43<<7 | 0x35,
	31821 - 19968: jis0208<<14 | 0x1F<<7 | 0x31,
	31823 - 19968: jis0208<<14 | 0x43<<7 | 0x38,
	31824 - 19968: jis0208<<14 | 0x43<<7 | 0x3A,
	31825 - 19968: jis0212<<14 | 0x31<<7 | 0x55,
	31826 - 19968: jis0212<<14 | 0x31<<7 | 0x56,
	31827 - 19968: jis0212<<14 | 0x31<<7 | 0x57,
	31828 - 19968: jis0208<<14 | 0x43<<7 | 0x37,
	31829 - 19968: jis0212<<14 | 0x31<<7 | 0x54,
	31830 - 19968: jis0208<<14 | 0x43<<7 | 0x3E,
	31832 - 19968: jis0208<<14 | 0x43<<7 | 0x3B,
	31833 - 19968: jis0212<<14 | 0x31<<7 | 0x58,
	31834 - 19968: jis0212<<14 | 0x31<<7 | 0x59,
	31835 - 19968: jis0212<<14 | 0x31<<7 | 0x5A,
	31836 - 19968: jis0212<<14 | 0x31<<7 | 0x5B,
	31837 - 19968: jis0212<<14 | 0x31<<7 | 0x5C,
	31838 - 19968: jis0212<<14 | 0x31<<7 | 0x5D,
	31839 - 19968: jis0208<<14 | 0x43<<7 | 0x3C,
	31840 - 19968: jis0208<<14 | 0x43<<7 | 0x25,
	31841 - 19968: jis0212<<14 | 0x32<<7 | 0x00,
	31843 - 19968: jis0212<<14 | 0x32<<7 | 0x01,
	31844 - 19968: jis0208<<14 | 0x43<<7 | 0x3D,
	31845 - 19968: jis0208<<14 | 0x43<<7 | 0x3F,
	31847 - 19968: jis0212<<14 | 0x32<<7 | 0x02,
	31849 - 19968: jis0212<<14 | 0x32<<7 | 0x03,
	31852 - 19968: jis0208<<14 | 0x43<<7 | 0x40,
	31853 - 19968: jis0212<<14 | 0x32<<7 | 0x04,
	31854 - 19968: jis0212<<14 | 0x32<<7 | 0x05,
	31856 - 19968: jis0212<<14 | 0x32<<7 | 0x06,
	31858 - 19968: jis0212<<14 | 0x32<<7 | 0x07,
	31859 - 19968: jis0208<<14 | 0x29<<7 | 0x25,
	31861 - 19968: jis0208<<14 | 0x43<<7 | 0x41,
	31865 - 19968: jis0212<<14 | 0x32<<7 | 0x08,
	31868 - 19968: jis0212<<14 | 0x32<<7 | 0x09,
	31869 - 19968: jis0212<<14 | 0x32<<7 | 0x0A,
	31870 - 19968: jis0208<<14 | 0x2B<<7 | 0x41,
	31873 - 19968: jis0208<<14 | 0x15<<7 | 0x2D,
	31874 - 19968: jis0208<<14 | 0x16<<7 | 0x08,
	31875 - 19968: jis0208<<14 | 0x43<<7 | 0x42,
	31878 - 19968: jis0212<<14 | 0x32<<7 | 0x0B,
	31879 - 19968: jis0212<<14 | 0x32<<7 | 0x0C,
	31881 - 19968: jis0208<<14 | 0x29<<7 | 0x13,
	31883 - 19968: jis0208<<14 | 0x1E<<7 | 0x47,
	31885 - 19968: jis0208<<14 | 0x2B<<7 | 0x0F,
	31887 - 19968: jis0212<<14 | 0x32<<7 | 0x0D,
	31888 - 19968: jis0208<<14 | 0x43<<7 | 0x43,
	31890 - 19968: jis0208<<14 | 0x2D<<7 | 0x12,
	31892 - 19968: jis0212<<14 | 0x32<<7 | 0x0E,
	31893 - 19968: jis0208<<14 | 0x26<<7 | 0x53,
	31895 - 19968: jis0208<<14 | 0x20<<7 | 0x25,
	31896 - 19968: jis0208<<14 | 0x26<<7 | 0x13,
	31899 - 19968: jis0208<<14 | 0x1C<<7 | 0x2C,
	31902 - 19968: jis0212<<14 | 0x32<<7 | 0x0F,
	31903 - 19968: jis0208<<14 | 0x0F<<7 | 0x1F,
	31904 - 19968: jis0212<<14 | 0x32<<7 | 0x10,
	31905 - 19968: jis0208<<14 | 0x43<<7 | 0x48,
	31906 - 19968: jis0208<<14 | 0x43<<7 | 0x46,
	31908 - 19968: jis0208<<14 | 0x43<<7 | 0x44,
	31909 - 19968: jis0208<<14 | 0x13<<7 | 0x00,
	31910 - 19968: jis0212<<14 | 0x32<<7 | 0x11,
	31911 - 19968: jis0208<<14 | 0x1D<<7 | 0x30,
	31912 - 19968: jis0208<<14 | 0x43<<7 | 0x49,
	31915 - 19968: jis0208<<14 | 0x43<<7 | 0x47,
	31917 - 19968: jis0208<<14 | 0x43<<7 | 0x45,
	31918 - 19968: jis0208<<14 | 0x43<<7 | 0x4D,
	31920 - 19968: jis0212<<14 | 0x32<<7 | 0x12,
	31921 - 19968: jis0208<<14 | 0x43<<7 | 0x4C,
	31922 - 19968: jis0208<<14 | 0x43<<7 | 0x4B,
	31923 - 19968: jis0208<<14 | 0x43<<7 | 0x4A,
	31926 - 19968: jis0212<<14 | 0x32<<7 | 0x13,
	31927 - 19968: jis0212<<14 | 0x32<<7 | 0x14,
	31929 - 19968: jis0208<<14 | 0x43<<7 | 0x4E,
	31930 - 19968: jis0212<<14 | 0x32<<7 | 0x15,
	31931 - 19968: jis0212<<14 | 0x32<<7 | 0x16,
	31932 - 19968: jis0212<<14 | 0x32<<7 | 0x17,
	31933 - 19968: jis0208<<14 | 0x43<<7 | 0x4F,
	31934 - 19968: jis0208<<14 | 0x1F<<7 | 0x19,
	31935 - 19968: jis0212<<14 | 0x32<<7 | 0x18,
	31936 - 19968: jis0208<<14 | 0x43<<7 | 0x50,
	31938 - 19968: jis0208<<14 | 0x43<<7 | 0x52,
	31940 - 19968: jis0212<<14 | 0x32<<7 | 0x19,
	31941 - 19968: jis0208<<14 | 0x43<<7 | 0x51,
	31943 - 19968: jis0212<<14 | 0x32<<7 | 0x1A,
	31944 - 19968: jis0212<<14 | 0x32<<7 | 0x1B,
	31945 - 19968: jis0212<<14 | 0x32<<7 | 0x1C,
	31946 - 19968: jis0208<<14 | 0x17<<7 | 0x31,
	31949 - 19968: jis0212<<14 | 0x32<<7 | 0x1D,
	31950 - 19968: jis0208<<14 | 0x20<<7 | 0x17,
	31951 - 19968: jis0212<<14 | 0x32<<7 | 0x1E,
	31954 - 19968: jis0208<<14 | 0x43<<7 | 0x54,
	31955 - 19968: jis0212<<14 | 0x32<<7 | 0x1F,
	31956 - 19968: jis0212<<14 | 0x32<<7 | 0x20,
	31957 - 19968: jis0212<<14 | 0x32<<7 | 0x21,
	31958 - 19968: jis0208<<14 | 0x24<<7 | 0x5B,
	31959 - 19968: jis0212<<14 | 0x32<<7 | 0x22,
	31960 - 19968: jis0208<<14 | 0x43<<7 | 0x53,
	31961 - 19968: jis0212<<14 | 0x32<<7 | 0x23,
	31962 - 19968: jis0212<<14 | 0x32<<7 | 0x24,
	31964 - 19968: jis0208<<14 | 0x43<<7 | 0x55,
	31965 - 19968: jis0212<<14 | 0x32<<7 | 0x25,
	31966 - 19968: jis0208<<14 | 0x29<<7 | 0x14,
	31967 - 19968: jis0208<<14 | 0x20<<7 | 0x4B,
	31968 - 19968: jis0208<<14 | 0x18<<7 | 0x26,
	31970 - 19968: jis0208<<14 | 0x43<<7 | 0x56,
	31974 - 19968: jis0212<<14 | 0x32<<7 | 0x26,
	31975 - 19968: jis0208<<14 | 0x2D<<7 | 0x27,
	31977 - 19968: jis0212<<14 | 0x32<<7 | 0x27,
	31979 - 19968: jis0212<<14 | 0x32<<7 | 0x28,
	31983 - 19968: jis0208<<14 | 0x43<<7 | 0x58,
	31986 - 19968: jis0208<<14 | 0x43<<7 | 0x59,
	31988 - 19968: jis0208<<14 | 0x43<<7 | 0x5A,
	31989 - 19968: jis0212<<14 | 0x32<<7 | 0x29,
	31990 - 19968: jis0208<<14 | 0x43<<7 | 0x5B,
	31992 - 19968: jis0208<<14 | 0x1A<<7 | 0x44,
	31994 - 19968: jis0208<<14 | 0x43<<7 | 0x5C,
	31995 - 19968: jis0208<<14 | 0x16<<7 | 0x2E,
	31998 - 19968: jis0208<<14 | 0x14<<7 | 0x49,
	32000 - 19968: jis0208<<14 | 0x14<<7 | 0x09,
	32002 - 19968: jis0208<<14 | 0x44<<7 | 0x00,
	32003 - 19968: jis0212<<14 | 0x32<<7 | 0x2A,
	32004 - 19968: jis0208<<14 | 0x2B<<7 | 0x52,
	32005 - 19968: jis0208<<14 | 0x18<<7 | 0x27,
	32006 - 19968: jis0208<<14 | 0x43<<7 | 0x5D,
	32007 - 19968: jis0212<<14 | 0x32<<7 | 0x2B,
	32008 - 19968: jis0212<<14 | 0x32<<7 | 0x2C,
	32009 - 19968: jis0212<<14 | 0x32<<7 | 0x2D,
	32010 - 19968: jis0208<<14 | 0x44<<7 | 0x03,
	32011 - 19968: jis0208<<14 | 0x2B<<7 | 0x45,
	32013 - 19968: jis0208<<14 | 0x26<<7 | 0x1B,
	32015 - 19968: jis0212<<14 | 0x32<<7 | 0x2E,
	32016 - 19968: jis0208<<14 | 0x28<<7 | 0x12,
	32017 - 19968: jis0212<<14 | 0x32<<7 | 0x2F,
	32018 - 19968: jis0212<<14 | 0x32<<7 | 0x30,
	32019 - 19968: jis0212<<14 | 0x32<<7 | 0x31,
	32020 - 19968: jis0208<<14 | 0x1C<<7 | 0x42,
	32021 - 19968: jis0208<<14 | 0x44<<7 | 0x02,
	32022 - 19968: jis0212<<14 | 0x32<<7 | 0x32,
	32023 - 19968: jis0208<<14 | 0x1B<<7 | 0x32,
	32024 - 19968: jis0208<<14 | 0x18<<7 | 0x28,
	32025 - 19968: jis0208<<14 | 0x1A<<7 | 0x45,
	32026 - 19968: jis0208<<14 | 0x14<<7 | 0x48,
	32027 - 19968: jis0208<<14 | 0x29<<7 | 0x15,
	32028 - 19968: jis0208<<14 | 0x44<<7 | 0x01,
	32029 - 19968: jis0212<<14 | 0x32<<7 | 0x33,
	32030 - 19968: jis0212<<14 | 0x32<<7 | 0x34,
	32032 - 19968: jis0208<<14 | 0x20<<7 | 0x26,
	32033 - 19968: jis0208<<14 | 0x2A<<7 | 0x21,
	32034 - 19968: jis0208<<14 | 0x19<<7 | 0x56,
	32035 - 19968: jis0212<<14 | 0x32<<7 | 0x35,
	32038 - 19968: jis0212<<14 | 0x32<<7 | 0x36,
	32042 - 19968: jis0212<<14 | 0x32<<7 | 0x37,
	32043 - 19968: jis0208<<14 | 0x1A<<7 | 0x46,
	32044 - 19968: jis0208<<14 | 0x23<<7 | 0x3C,
	32045 - 19968: jis0212<<14 | 0x32<<7 | 0x38,
	32046 - 19968: jis0208<<14 | 0x44<<7 | 0x06,
	32047 - 19968: jis0208<<14 | 0x2D<<7 | 0x3E,
	32048 - 19968: jis0208<<14 | 0x19<<7 | 0x38,
	32049 - 19968: jis0212<<14 | 0x32<<7 | 0x39,
	32050 - 19968: jis0208<<14 | 0x44<<7 | 0x07,
	32051 - 19968: jis0208<<14 | 0x1E<<7 | 0x21,
	32053 - 19968: jis0208<<14 | 0x44<<7 | 0x09,
	32057 - 19968: jis0208<<14 | 0x1D<<7 | 0x31,
	32058 - 19968: jis0208<<14 | 0x19<<7 | 0x0F,
	32060 - 19968: jis0212<<14 | 0x32<<7 | 0x3A,
	32061 - 19968: jis0212<<14 | 0x32<<7 | 0x3B,
	32062 - 19968: jis0212<<14 | 0x32<<7 | 0x3C,
	32063 - 19968: jis0208<<14 | 0x44<<7 | 0x08,
	32064 - 19968: jis0212<<14 | 0x32<<7 | 0x3D,
	32065 - 19968: jis0212<<14 | 0x32<<7 | 0x3E,
	32066 - 19968: jis0208<<14 | 0x1C<<7 | 0x09,
	32067 - 19968: jis0208<<14 | 0x17<<7 | 0x1D,
	32068 - 19968: jis0208<<14 | 0x20<<7 | 0x27,
	32069 - 19968: jis0208<<14 | 0x44<<7 | 0x04,
	32070 - 19968: jis0208<<14 | 0x44<<7 | 0x0A,
	32071 - 19968: jis0212<<14 | 0x32<<7 | 0x3F,
	32072 - 19968: jis0208<<14 | 0x5A<<7 | 0x2D,
	32075 - 19968: jis0208<<14 | 0x44<<7 | 0x05,
	32076 - 19968: jis0208<<14 | 0x16<<7 | 0x2F,
	32077 - 19968: jis0212<<14 | 0x32<<7 | 0x41,
	32078 - 19968: jis0208<<14 | 0x44<<7 | 0x0D,
	32079 - 19968: jis0208<<14 | 0x44<<7 | 0x11,
	32080 - 19968: jis0208<<14 | 0x16<<7 | 0x4A,
	32081 - 19968: jis0212<<14 | 0x32<<7 | 0x42,
	32083 - 19968: jis0212<<14 | 0x32<<7 | 0x43,
	32086 - 19968: jis0208<<14 | 0x44<<7 | 0x0C,
	32087 - 19968: jis0212<<14 | 0x32<<7 | 0x44,
	32089 - 19968: jis0212<<14 | 0x32<<7 | 0x45,
	32090 - 19968: jis0212<<14 | 0x32<<7 | 0x46,
	32091 - 19968: jis0208<<14 | 0x44<<7 | 0x15,
	32092 - 19968: jis0208<<14 | 0x5A<<7 | 0x2E,
	32093 - 19968: jis0212<<14 | 0x32<<7 | 0x48,
	32094 - 19968: jis0208<<14 | 0x18<<7 | 0x29,
	32097 - 19968: jis0208<<14 | 0x2C<<7 | 0x4C,
	32098 - 19968: jis0208<<14 | 0x0F<<7 | 0x1B,
	32099 - 19968: jis0208<<14 | 0x44<<7 | 0x12,
	32101 - 19968: jis0212<<14 | 0x32<<7 | 0x49,
	32102 - 19968: jis0208<<14 | 0x14<<7 | 0x4A,
	32103 - 19968: jis0212<<14 | 0x32<<7 | 0x4A,
	32104 - 19968: jis0208<<14 | 0x44<<7 | 0x0F,
	32106 - 19968: jis0212<<14 | 0x32<<7 | 0x4B,
	32110 - 19968: jis0208<<14 | 0x44<<7 | 0x10,
	32112 - 19968: jis0212<<14 | 0x32<<7 | 0x4C,
	32113 - 19968: jis0208<<14 | 0x24<<7 | 0x5C,
	32114 - 19968: jis0208<<14 | 0x44<<7 | 0x0E,
	32115 - 19968: jis0208<<14 | 0x44<<7 | 0x0B,
	32117 - 19968: jis0208<<14 | 0x12<<7 | 0x07,
	32118 - 19968: jis0208<<14 | 0x1F<<7 | 0x43,
	32120 - 19968: jis0212<<14 | 0x32<<7 | 0x4D,
	32121 - 19968: jis0208<<14 | 0x17<<7 | 0x07,
	32122 - 19968: jis0212<<14 | 0x32<<7 | 0x4E,
	32123 - 19968: jis0212<<14 | 0x32<<7 | 0x4F,
	32125 - 19968: jis0208<<14 | 0x44<<7 | 0x17,
	32127 - 19968: jis0212<<14 | 0x32<<7 | 0x50,
	32129 - 19968: jis0212<<14 | 0x32<<7 | 0x51,
	32130 - 19968: jis0212<<14 | 0x32<<7 | 0x52,
	32131 - 19968: jis0212<<14 | 0x32<<7 | 0x53,
	32133 - 19968: jis0212<<14 | 0x32<<7 | 0x54,
	32134 - 19968: jis0212<<14 | 0x32<<7 | 0x55,
	32136 - 19968: jis0212<<14 | 0x32<<7 | 0x56,
	32137 - 19968: jis0208<<14 | 0x44<<7 | 0x14,
	32139 - 19968: jis0212<<14 | 0x32<<7 | 0x57,
	32140 - 19968: jis0212<<14 | 0x32<<7 | 0x58,
	32141 - 19968: jis0212<<14 | 0x32<<7 | 0x59,
	32143 - 19968: jis0208<<14 | 0x44<<7 | 0x16,
	32145 - 19968: jis0212<<14 | 0x32<<7 | 0x5A,
	32147 - 19968: jis0208<<14 | 0x44<<7 | 0x13,
	32150 - 19968: jis0212<<14 | 0x32<<7 | 0x5B,
	32151 - 19968: jis0212<<14 | 0x32<<7 | 0x5C,
	32153 - 19968: jis0208<<14 | 0x16<<7 | 0x30,
	32154 - 19968: jis0208<<14 | 0x21<<7 | 0x12,
	32155 - 19968: jis0208<<14 | 0x44<<7 | 0x18,
	32156 - 19968: jis0208<<14 | 0x20<<7 | 0x4D,
	32157 - 19968: jis0212<<14 | 0x32<<7 | 0x5D,
	32158 - 19968: jis0212<<14 | 0x33<<7 | 0x00,
	32159 - 19968: jis0208<<14 | 0x44<<7 | 0x25,
	32160 - 19968: jis0208<<14 | 0x5A<<7 | 0x30,
	32162 - 19968: jis0208<<14 | 0x44<<7 | 0x21,
	32163 - 19968: jis0208<<14 | 0x44<<7 | 0x1B,
	32166 - 19968: jis0212<<14 | 0x33<<7 | 0x01,
	32167 - 19968: jis0212<<14 | 0x33<<7 | 0x02,
	32170 - 19968: jis0212<<14 | 0x33<<7 | 0x03,
	32171 - 19968: jis0208<<14 | 0x44<<7 | 0x1F,
	32172 - 19968: jis0208<<14 | 0x1B<<7 | 0x59,
	32173 - 19968: jis0208<<14 | 0x0F<<7 | 0x3C,
	32174 - 19968: jis0208<<14 | 0x44<<7 | 0x1A,
	32175 - 19968: jis0208<<14 | 0x44<<7 | 0x22,
	32176 - 19968: jis0208<<14 | 0x44<<7 | 0x26,
	32177 - 19968: jis0208<<14 | 0x18<<7 | 0x2A,
	32178 - 19968: jis0208<<14 | 0x2B<<7 | 0x35,
	32179 - 19968: jis0212<<14 | 0x33<<7 | 0x04,
	32180 - 19968: jis0208<<14 | 0x23<<7 | 0x35,
	32181 - 19968: jis0208<<14 | 0x44<<7 | 0x1C,
	32182 - 19968: jis0212<<14 | 0x33<<7 | 0x05,
	32183 - 19968: jis0208<<14 | 0x5A<<7 | 0x2F,
	32184 - 19968: jis0208<<14 | 0x44<<7 | 0x24,
	32185 - 19968: jis0212<<14 | 0x33<<7 | 0x07,
	32186 - 19968: jis0208<<14 | 0x44<<7 | 0x19,
	32187 - 19968: jis0208<<14 | 0x22<<7 | 0x1D,
	32189 - 19968: jis0208<<14 | 0x44<<7 | 0x1E,
	32190 - 19968: jis0208<<14 | 0x0F<<7 | 0x1C,
	32191 - 19968: jis0208<<14 | 0x2B<<7 | 0x29,
	32194 - 19968: jis0212<<14 | 0x33<<7 | 0x08,
	32195 - 19968: jis0212<<14 | 0x33<<7 | 0x09,
	32196 - 19968: jis0212<<14 | 0x33<<7 | 0x0A,
	32197 - 19968: jis0212<<14 | 0x33<<7 | 0x0B,
	32198 - 19968: jis0212<<14 | 0x33<<7 | 0x0C,
	32199 - 19968: jis0208<<14 | 0x44<<7 | 0x1D,
	32202 - 19968: jis0208<<14 | 0x15<<7 | 0x3A,
	32203 - 19968: jis0208<<14 | 0x27<<7 | 0x4B,
	32204 - 19968: jis0212<<14 | 0x33<<7 | 0x0D,
	32205 - 19968: jis0212<<14 | 0x33<<7 | 0x0E,
	32206 - 19968: jis0212<<14 | 0x33<<7 | 0x0F,
	32207 - 19968: jis0208<<14 | 0x20<<7 | 0x4C,
	32209 - 19968: jis0208<<14 | 0x2D<<7 | 0x2F,
	32210 - 19968: jis0208<<14 | 0x1C<<7 | 0x4E,
	32213 - 19968: jis0208<<14 | 0x44<<7 | 0x4D,
	32214 - 19968: jis0208<<14 | 0x5A<<7 | 0x31,
	32215 - 19968: jis0212<<14 | 0x33<<7 | 0x10,
	32216 - 19968: jis0208<<14 | 0x44<<7 | 0x27,
	32217 - 19968: jis0212<<14 | 0x33<<7 | 0x11,
	32218 - 19968: jis0208<<14 | 0x1F<<7 | 0x5D,
	32220 - 19968: jis0208<<14 | 0x44<<7 | 0x23,
	32221 - 19968: jis0208<<14 | 0x44<<7 | 0x28,
	32222 - 19968: jis0208<<14 | 0x44<<7 | 0x2A,
	32224 - 19968: jis0208<<14 | 0x23<<7 | 0x58,
	32225 - 19968: jis0208<<14 | 0x44<<7 | 0x2D,
	32226 - 19968: jis0212<<14 | 0x33<<7 | 0x13,
	32228 - 19968: jis0208<<14 | 0x44<<7 | 0x29,
	32229 - 19968: jis0212<<14 | 0x33<<7 | 0x14,
	32230 - 19968: jis0212<<14 | 0x33<<7 | 0x15,
	32232 - 19968: jis0208<<14 | 0x29<<7 | 0x33,
	32233 - 19968: jis0208<<14 | 0x13<<7 | 0x2A,
	32234 - 19968: jis0212<<14 | 0x33<<7 | 0x16,
	32235 - 19968: jis0212<<14 | 0x33<<7 | 0x17,
	32236 - 19968: jis0208<<14 | 0x2B<<7 | 0x2A,
	32237 - 19968: jis0212<<14 | 0x33<<7 | 0x18,
	32239 - 19968: jis0208<<14 | 0x0F<<7 | 0x3D,
	32241 - 19968: jis0212<<14 | 0x33<<7 | 0x19,
	32242 - 19968: jis0208<<14 | 0x44<<7 | 0x2C,
	32244 - 19968: jis0208<<14 | 0x2D<<7 | 0x5C,
	32245 - 19968: jis0212<<14 | 0x33<<7 | 0x1A,
	32246 - 19968: jis0212<<14 | 0x33<<7 | 0x1B,
	32249 - 19968: jis0212<<14 | 0x33<<7 | 0x1C,
	32250 - 19968: jis0212<<14 | 0x33<<7 | 0x1D,
	32251 - 19968: jis0208<<14 | 0x44<<7 | 0x2B,
	32256 - 19968: jis0212<<14 | 0x33<<7 | 0x12,
	32257 - 19968: jis0208<<14 | 0x10<<7 | 0x4E,
	32260 - 19968: jis0208<<14 | 0x25<<7 | 0x4B,
	32261 - 19968: jis0208<<14 | 0x44<<7 | 0x2E,
	32264 - 19968: jis0212<<14 | 0x33<<7 | 0x1E,
	32265 - 19968: jis0208<<14 | 0x44<<7 | 0x35,
	32266 - 19968: jis0208<<14 | 0x44<<7 | 0x2F,
	32267 - 19968: jis0208<<14 | 0x44<<7 | 0x36,
	32272 - 19968: jis0212<<14 | 0x33<<7 | 0x1F,
	32273 - 19968: jis0212<<14 | 0x33<<7 | 0x20,
	32274 - 19968: jis0208<<14 | 0x44<<7 | 0x32,
	32277 - 19968: jis0212<<14 | 0x33<<7 | 0x21,
	32279 - 19968: jis0212<<14 | 0x33<<7 | 0x22,
	32283 - 19968: jis0208<<14 | 0x26<<7 | 0x5A,
	32284 - 19968: jis0212<<14 | 0x33<<7 | 0x23,
	32285 - 19968: jis0212<<14 | 0x33<<7 | 0x24,
	32286 - 19968: jis0208<<14 | 0x1B<<7 | 0x29,
	32287 - 19968: jis0208<<14 | 0x44<<7 | 0x34,
	32288 - 19968: jis0212<<14 | 0x33<<7 | 0x25,
	32289 - 19968: jis0208<<14 | 0x44<<7 | 0x31,
	32290 - 19968: jis0208<<14 | 0x44<<7 | 0x37,
	32291 - 19968: jis0208<<14 | 0x44<<7 | 0x30,
	32294 - 19968: jis0208<<14 | 0x1C<<7 | 0x23,
	32295 - 19968: jis0212<<14 | 0x33<<7 | 0x26,
	32296 - 19968: jis0212<<14 | 0x33<<7 | 0x27,
	32299 - 19968: jis0208<<14 | 0x2A<<7 | 0x04,
	32300 - 19968: jis0212<<14 | 0x33<<7 | 0x28,
	32301 - 19968: jis0212<<14 | 0x33<<7 | 0x29,
	32302 - 19968: jis0208<<14 | 0x1C<<7 | 0x2B,
	32303 - 19968: jis0212<<14 | 0x33<<7 | 0x2A,
	32305 - 19968: jis0208<<14 | 0x44<<7 | 0x33,
	32306 - 19968: jis0208<<14 | 0x44<<7 | 0x3F,
	32307 - 19968: jis0212<<14 | 0x33<<7 | 0x2B,
	32309 - 19968: jis0208<<14 | 0x44<<7 | 0x3B,
	32310 - 19968: jis0212<<14 | 0x33<<7 | 0x2C,
	32311 - 19968: jis0208<<14 | 0x44<<7 | 0x3E,
	32313 - 19968: jis0208<<14 | 0x44<<7 | 0x3C,
	32314 - 19968: jis0208<<14 | 0x44<<7 | 0x40,
	32315 - 19968: jis0208<<14 | 0x44<<7 | 0x3A,
	32317 - 19968: jis0208<<14 | 0x44<<7 | 0x20,
	32318 - 19968: jis0208<<14 | 0x1F<<7 | 0x32,
	32319 - 19968: jis0212<<14 | 0x33<<7 | 0x2D,
	32321 - 19968: jis0208<<14 | 0x27<<7 | 0x2A,
	32323 - 19968: jis0208<<14 | 0x44<<7 | 0x3D,
	32324 - 19968: jis0212<<14 | 0x33<<7 | 0x2E,
	32325 - 19968: jis0212<<14 | 0x33<<7 | 0x2F,
	32326 - 19968: jis0208<<14 | 0x44<<7 | 0x38,
	32327 - 19968: jis0212<<14 | 0x33<<7 | 0x30,
	32330 - 19968: jis0208<<14 | 0x20<<7 | 0x00,
	32331 - 19968: jis0208<<14 | 0x16<<7 | 0x31,
	32333 - 19968: jis0208<<14 | 0x1C<<7 | 0x0A,
	32334 - 19968: jis0212<<14 | 0x33<<7 | 0x31,
	32336 - 19968: jis0212<<14 | 0x33<<7 | 0x32,
	32338 - 19968: jis0208<<14 | 0x5A<<7 | 0x32,
	32340 - 19968: jis0208<<14 | 0x1E<<7 | 0x04,
	32341 - 19968: jis0208<<14 | 0x20<<7 | 0x15,
	32342 - 19968: jis0208<<14 | 0x44<<7 | 0x43,
	32344 - 19968: jis0212<<14 | 0x33<<7 | 0x34,
	32345 - 19968: jis0208<<14 | 0x44<<7 | 0x45,
	32346 - 19968: jis0208<<14 | 0x44<<7 | 0x46,
	32349 - 19968: jis0208<<14 | 0x44<<7 | 0x42,
	32350 - 19968: jis0208<<14 | 0x44<<7 | 0x44,
	32351 - 19968: jis0212<<14 | 0x33<<7 | 0x35,
	32353 - 19968: jis0212<<14 | 0x33<<7 | 0x36,
	32354 - 19968: jis0212<<14 | 0x33<<7 | 0x37,
	32357 - 19968: jis0212<<14 | 0x33<<7 | 0x38,
	32358 - 19968: jis0208<<14 | 0x44<<7 | 0x39,
	32359 - 19968: jis0208<<14 | 0x44<<7 | 0x41,
	32361 - 19968: jis0208<<14 | 0x44<<7 | 0x49,
	32362 - 19968: jis0208<<14 | 0x44<<7 | 0x48,
	32363 - 19968: jis0212<<14 | 0x33<<7 | 0x39,
	32365 - 19968: jis0208<<14 | 0x2A<<7 | 0x59,
	32366 - 19968: jis0212<<14 | 0x33<<7 | 0x3A,
	32367 - 19968: jis0212<<14 | 0x33<<7 | 0x3B,
	32368 - 19968: jis0208<<14 | 0x16<<7 | 0x0A,
	32371 - 19968: jis0212<<14 | 0x33<<7 | 0x3C,
	32376 - 19968: jis0212<<14 | 0x33<<7 | 0x3D,
	32377 - 19968: jis0208<<14 | 0x44<<7 | 0x47,
	32379 - 19968: jis0208<<14 | 0x44<<7 | 0x4B,
	32380 - 19968: jis0208<<14 | 0x44<<7 | 0x4A,
	32381 - 19968: jis0208<<14 | 0x44<<7 | 0x4E,
	32382 - 19968: jis0212<<14 | 0x33<<7 | 0x3E,
	32383 - 19968: jis0208<<14 | 0x44<<7 | 0x50,
	32385 - 19968: jis0212<<14 | 0x33<<7 | 0x3F,
	32386 - 19968: jis0208<<14 | 0x1A<<7 | 0x1B,
	32387 - 19968: jis0208<<14 | 0x44<<7 | 0x4C,
	32390 - 19968: jis0212<<14 | 0x33<<7 | 0x40,
	32391 - 19968: jis0212<<14 | 0x33<<7 | 0x41,
	32392 - 19968: jis0208<<14 | 0x44<<7 | 0x51,
	32393 - 19968: jis0208<<14 | 0x44<<7 | 0x52,
	32394 - 19968: jis0208<<14 | 0x58<<7 | 0x00,
	32396 - 19968: jis0208<<14 | 0x44<<7 | 0x53,
	32397 - 19968: jis0212<<14 | 0x33<<7 | 0x43,
	32398 - 19968: jis0208<<14 | 0x44<<7 | 0x59,
	32399 - 19968: jis0208<<14 | 0x24<<7 | 0x1A,
	32400 - 19968: jis0208<<14 | 0x44<<7 | 0x55,
	32401 - 19968: jis0212<<14 | 0x33<<7 | 0x44,
	32402 - 19968: jis0208<<14 | 0x44<<7 | 0x54,
	32403 - 19968: jis0208<<14 | 0x44<<7 | 0x56,
	32404 - 19968: jis0208<<14 | 0x44<<7 | 0x57,
	32405 - 19968: jis0212<<14 | 0x33<<7 | 0x45,
	32406 - 19968: jis0208<<14 | 0x44<<7 | 0x58,
	32408 - 19968: jis0212<<14 | 0x33<<7 | 0x46,
	32410 - 19968: jis0212<<14 | 0x33<<7 | 0x47,
	32411 - 19968: jis0208<<14 | 0x44<<7 | 0x5A,
	32412 - 19968: jis0208<<14 | 0x44<<7 | 0x5B,
	32413 - 19968: jis0212<<14 | 0x33<<7 | 0x48,
	32414 - 19968: jis0212<<14 | 0x33<<7 | 0x49,
	32566 - 19968: jis0208<<14 | 0x13<<7 | 0x2B,
	32568 - 19968: jis0208<<14 | 0x44<<7 | 0x5C,
	32570 - 19968: jis0208<<14 | 0x44<<7 | 0x5D,
	32571 - 19968: jis0212<<14 | 0x33<<7 | 0x4B,
	32572 - 19968: jis0212<<14 | 0x33<<7 | 0x4A,
	32573 - 19968: jis0212<<14 | 0x33<<7 | 0x4C,
	32574 - 19968: jis0212<<14 | 0x33<<7 | 0x4D,
	32575 - 19968: jis0212<<14 | 0x33<<7 | 0x4E,
	32579 - 19968: jis0212<<14 | 0x33<<7 | 0x4F,
	32580 - 19968: jis0212<<14 | 0x33<<7 | 0x50,
	32581 - 19968: jis0208<<14 | 0x45<<7 | 0x00,
	32583 - 19968: jis0208<<14 | 0x5A<<7 | 0x33,
	32588 - 19968: jis0208<<14 | 0x45<<7 | 0x01,
	32589 - 19968: jis0208<<14 | 0x45<<7 | 0x02,
	32590 - 19968: jis0208<<14 | 0x45<<7 | 0x03,
	32591 - 19968: jis0212<<14 | 0x33<<7 | 0x52,
	32592 - 19968: jis0208<<14 | 0x45<<7 | 0x04,
	32593 - 19968: jis0208<<14 | 0x45<<7 | 0x05,
	32594 - 19968: jis0212<<14 | 0x33<<7 | 0x53,
	32595 - 19968: jis0212<<14 | 0x33<<7 | 0x54,
	32596 - 19968: jis0208<<14 | 0x45<<7 | 0x07,
	32597 - 19968: jis0208<<14 | 0x45<<7 | 0x06,
	32600 - 19968: jis0208<<14 | 0x45<<7 | 0x08,
	32603 - 19968: jis0212<<14 | 0x33<<7 | 0x55,
	32604 - 19968: jis0212<<14 | 0x33<<7 | 0x56,
	32605 - 19968: jis0212<<14 | 0x33<<7 | 0x57,
	32607 - 19968: jis0208<<14 | 0x45<<7 | 0x09,
	32608 - 19968: jis0208<<14 | 0x45<<7 | 0x0A,
	32609 - 19968: jis0212<<14 | 0x33<<7 | 0x58,
	32611 - 19968: jis0212<<14 | 0x33<<7 | 0x59,
	32612 - 19968: jis0212<<14 | 0x33<<7 | 0x5A,
	32613 - 19968: jis0212<<14 | 0x33<<7 | 0x5B,
	32614 - 19968: jis0212<<14 | 0x33<<7 | 0x5C,
	32615 - 19968: jis0208<<14 | 0x45<<7 | 0x0D,
	32616 - 19968: jis0208<<14 | 0x45<<7 | 0x0B,
	32617 - 19968: jis0208<<14 | 0x45<<7 | 0x0C,
	32618 - 19968: jis0208<<14 | 0x19<<7 | 0x40,
	32619 - 19968: jis0208<<14 | 0x16<<7 | 0x32,
	32621 - 19968: jis0212<<14 | 0x33<<7 | 0x5D,
	32622 - 19968: jis0208<<14 | 0x22<<7 | 0x35,
	32624 - 19968: jis0208<<14 | 0x27<<7 | 0x12,
	32625 - 19968: jis0212<<14 | 0x34<<7 | 0x00,
	32626 - 19968: jis0208<<14 | 0x1C<<7 | 0x4F,
	32629 - 19968: jis0208<<14 | 0x26<<7 | 0x2C,
	32631 - 19968: jis0208<<14 | 0x27<<7 | 0x4C,
	32632 - 19968: jis0208<<14 | 0x45<<7 | 0x0E,
	32633 - 19968: jis0208<<14 | 0x37<<7 | 0x4C,
	32637 - 19968: jis0212<<14 | 0x34<<7 | 0x01,
	32638 - 19968: jis0212<<14 | 0x34<<7 | 0x02,
	32639 - 19968: jis0212<<14 | 0x34<<7 | 0x03,
	32640 - 19968: jis0212<<14 | 0x34<<7 | 0x04,
	32642 - 19968: jis0208<<14 | 0x45<<7 | 0x0F,
	32643 - 19968: jis0208<<14 | 0x45<<7 | 0x11,
	32645 - 19968: jis0208<<14 | 0x2C<<7 | 0x44,
	32646 - 19968: jis0208<<14 | 0x45<<7 | 0x10,
	32647 - 19968: jis0208<<14 | 0x45<<7 | 0x13,
	32648 - 19968: jis0208<<14 | 0x45<<7 | 0x12,
	32650 - 19968: jis0208<<14 | 0x2C<<7 | 0x32,
	32651 - 19968: jis0212<<14 | 0x34<<7 | 0x05,
	32652 - 19968: jis0208<<14 | 0x45<<7 | 0x14,
	32653 - 19968: jis0212<<14 | 0x34<<7 | 0x06,
	32654 - 19968: jis0208<<14 | 0x27<<7 | 0x5D,
	32655 - 19968: jis0212<<14 | 0x34<<7 | 0x07,
	32656 - 19968: jis0212<<14 | 0x34<<7 | 0x08,
	32657 - 19968: jis0212<<14 | 0x34<<7 | 0x09,
	32660 - 19968: jis0208<<14 | 0x45<<7 | 0x15,
	32662 - 19968: jis0212<<14 | 0x34<<7 | 0x0A,
	32663 - 19968: jis0212<<14 | 0x34<<7 | 0x0B,
	32666 - 19968: jis0208<<14 | 0x45<<7 | 0x18,
	32668 - 19968: jis0212<<14 | 0x34<<7 | 0x0C,
	32669 - 19968: jis0208<<14 | 0x45<<7 | 0x17,
	32670 - 19968: jis0208<<14 | 0x45<<7 | 0x16,
	32673 - 19968: jis0208<<14 | 0x5A<<7 | 0x34,
	32674 - 19968: jis0212<<14 | 0x34<<7 | 0x0E,
	32675 - 19968: jis0208<<14 | 0x45<<7 | 0x19,
	32676 - 19968: jis0208<<14 | 0x16<<7 | 0x11,
	32678 - 19968: jis0212<<14 | 0x34<<7 | 0x0F,
	32680 - 19968: jis0208<<14 | 0x20<<7 | 0x01,
	32681 - 19968: jis0208<<14 | 0x14<<7 | 0x20,
	32682 - 19968: jis0212<<14 | 0x34<<7 | 0x10,
	32685 - 19968: jis0212<<14 | 0x34<<7 | 0x11,
	32686 - 19968: jis0208<<14 | 0x45<<7 | 0x1D,
	32687 - 19968: jis0208<<14 | 0x45<<7 | 0x1A,
	32690 - 19968: jis0208<<14 | 0x45<<7 | 0x1B,
	32692 - 19968: jis0212<<14 | 0x34<<7 | 0x12,
	32694 - 19968: jis0208<<14 | 0x45<<7 | 0x1E,
	32696 - 19968: jis0208<<14 | 0x45<<7 | 0x1F,
	32697 - 19968: jis0208<<14 | 0x45<<7 | 0x1C,
	32700 - 19968: jis0212<<14 | 0x34<<7 | 0x13,
	32701 - 19968: jis0208<<14 | 0x10<<7 | 0x08,
	32703 - 19968: jis0212<<14 | 0x34<<7 | 0x14,
	32704 - 19968: jis0212<<14 | 0x34<<7 | 0x15,
	32705 - 19968: jis0208<<14 | 0x11<<7 | 0x06,
	32707 - 19968: jis0212<<14 | 0x34<<7 | 0x16,
	32709 - 19968: jis0208<<14 | 0x45<<7 | 0x21,
	32710 - 19968: jis0208<<14 | 0x45<<7 | 0x22,
	32712 - 19968: jis0212<<14 | 0x34<<7 | 0x17,
	32714 - 19968: jis0208<<14 | 0x45<<7 | 0x23,
	32716 - 19968: jis0208<<14 | 0x2C<<7 | 0x41,
	32718 - 19968: jis0212<<14 | 0x34<<7 | 0x18,
	32719 - 19968: jis0212<<14 | 0x34<<7 | 0x19,
	32722 - 19968: jis0208<<14 | 0x1C<<7 | 0x0B,
	32724 - 19968: jis0208<<14 | 0x45<<7 | 0x25,
	32725 - 19968: jis0208<<14 | 0x45<<7 | 0x24,
	32731 - 19968: jis0212<<14 | 0x34<<7 | 0x1A,
	32735 - 19968: jis0212<<14 | 0x34<<7 | 0x1B,
	32736 - 19968: jis0208<<14 | 0x1E<<7 | 0x48,
	32737 - 19968: jis0208<<14 | 0x45<<7 | 0x26,
	32739 - 19968: jis0212<<14 | 0x34<<7 | 0x1C,
	32741 - 19968: jis0212<<14 | 0x34<<7 | 0x1D,
	32742 - 19968: jis0208<<14 | 0x45<<7 | 0x27,
	32744 - 19968: jis0212<<14 | 0x34<<7 | 0x1E,
	32745 - 19968: jis0208<<14 | 0x45<<7 | 0x28,
	32747 - 19968: jis0208<<14 | 0x13<<7 | 0x44,
	32748 - 19968: jis0212<<14 | 0x34<<7 | 0x1F,
	32750 - 19968: jis0212<<14 | 0x34<<7 | 0x20,
	32751 - 19968: jis0212<<14 | 0x34<<7 | 0x21,
	32752 - 19968: jis0208<<14 | 0x13<<7 | 0x2C,
	32754 - 19968: jis0212<<14 | 0x34<<7 | 0x22,
	32755 - 19968: jis0208<<14 | 0x45<<7 | 0x29,
	32761 - 19968: jis0208<<14 | 0x45<<7 | 0x2A,
	32762 - 19968: jis0212<<14 | 0x34<<7 | 0x23,
	32763 - 19968: jis0208<<14 | 0x2A<<7 | 0x3C,
	32764 - 19968: jis0208<<14 | 0x2C<<7 | 0x42,
	32765 - 19968: jis0212<<14 | 0x34<<7 | 0x24,
	32766 - 19968: jis0212<<14 | 0x34<<7 | 0x25,
	32767 - 19968: jis0212<<14 | 0x34<<7 | 0x26,
	32768 - 19968: jis0208<<14 | 0x2C<<7 | 0x33,
	32769 - 19968: jis0208<<14 | 0x2E<<7 | 0x16,
	32771 - 19968: jis0208<<14 | 0x18<<7 | 0x2C,
	32772 - 19968: jis0208<<14 | 0x45<<7 | 0x2D,
	32773 - 19968: jis0208<<14 | 0x1B<<7 | 0x33,
	32774 - 19968: jis0208<<14 | 0x45<<7 | 0x2C,
	32775 - 19968: jis0212<<14 | 0x34<<7 | 0x27,
	32776 - 19968: jis0212<<14 | 0x34<<7 | 0x28,
	32778 - 19968: jis0212<<14 | 0x34<<7 | 0x29,
	32779 - 19968: jis0208<<14 | 0x45<<7 | 0x2E,
	32780 - 19968: jis0208<<14 | 0x1B<<7 | 0x08,
	32781 - 19968: jis0212<<14 | 0x34<<7 | 0x2A,
	32782 - 19968: jis0212<<14 | 0x34<<7 | 0x2B,
	32783 - 19968: jis0212<<14 | 0x34<<7 | 0x2C,
	32784 - 19968: jis0208<<14 | 0x21<<7 | 0x30,
	32785 - 19968: jis0212<<14 | 0x34<<7 | 0x2D,
	32786 - 19968: jis0208<<14 | 0x45<<7 | 0x2F,
	32787 - 19968: jis0212<<14 | 0x34<<7 | 0x2E,
	32788 - 19968: jis0212<<14 | 0x34<<7 | 0x2F,
	32789 - 19968: jis0208<<14 | 0x18<<7 | 0x2B,
	32790 - 19968: jis0212<<14 | 0x34<<7 | 0x30,
	32791 - 19968: jis0208<<14 | 0x2B<<7 | 0x36,
	32792 - 19968: jis0208<<14 | 0x45<<7 | 0x30,
	32793 - 19968: jis0208<<14 | 0x45<<7 | 0x31,
	32796 - 19968: jis0208<<14 | 0x45<<7 | 0x32,
	32797 - 19968: jis0212<<14 | 0x34<<7 | 0x31,
	32798 - 19968: jis0212<<14 | 0x34<<7 | 0x32,
	32799 - 19968: jis0212<<14 | 0x34<<7 | 0x33,
	32800 - 19968: jis0212<<14 | 0x34<<7 | 0x34,
	32801 - 19968: jis0208<<14 | 0x45<<7 | 0x33,
	32804 - 19968: jis0212<<14 | 0x34<<7 | 0x35,
	32806 - 19968: jis0212<<14 | 0x34<<7 | 0x36,
	32808 - 19968: jis0208<<14 | 0x45<<7 | 0x34,
	32812 - 19968: jis0212<<14 | 0x34<<7 | 0x37,
	32814 - 19968: jis0212<<14 | 0x34<<7 | 0x38,
	32816 - 19968: jis0212<<14 | 0x34<<7 | 0x39,
	32819 - 19968: jis0208<<14 | 0x1B<<7 | 0x09,
	32820 - 19968: jis0212<<14 | 0x34<<7 | 0x3A,
	32821 - 19968: jis0212<<14 | 0x34<<7 | 0x3B,
	32822 - 19968: jis0208<<14 | 0x2B<<7 | 0x4C,
	32823 - 19968: jis0212<<14 | 0x34<<7 | 0x3C,
	32825 - 19968: jis0212<<14 | 0x34<<7 | 0x3D,
	32826 - 19968: jis0212<<14 | 0x34<<7 | 0x3E,
	32827 - 19968: jis0208<<14 | 0x45<<7 | 0x36,
	32828 - 19968: jis0212<<14 | 0x34<<7 | 0x3F,
	32829 - 19968: jis0208<<14 | 0x22<<7 | 0x1E,
	32830 - 19968: jis0212<<14 | 0x34<<7 | 0x40,
	32831 - 19968: jis0208<<14 | 0x45<<7 | 0x35,
	32832 - 19968: jis0212<<14 | 0x34<<7 | 0x41,
	32836 - 19968: jis0212<<14 | 0x34<<7 | 0x42,
	32838 - 19968: jis0208<<14 | 0x45<<7 | 0x38,
	32842 - 19968: jis0208<<14 | 0x45<<7 | 0x37,
	32850 - 19968: jis0208<<14 | 0x45<<7 | 0x39,
	32854 - 19968: jis0208<<14 | 0x1F<<7 | 0x1A,
	32856 - 19968: jis0208<<14 | 0x45<<7 | 0x3A,
	32858 - 19968: jis0208<<14 | 0x45<<7 | 0x3B,
	32862 - 19968: jis0208<<14 | 0x29<<7 | 0x18,
	32863 - 19968: jis0208<<14 | 0x45<<7 | 0x3C,
	32864 - 19968: jis0212<<14 | 0x34<<7 | 0x43,
	32865 - 19968: jis0208<<14 | 0x20<<7 | 0x4E,
	32866 - 19968: jis0208<<14 | 0x45<<7 | 0x3D,
	32868 - 19968: jis0212<<14 | 0x34<<7 | 0x44,
	32870 - 19968: jis0212<<14 | 0x34<<7 | 0x45,
	32872 - 19968: jis0208<<14 | 0x45<<7 | 0x3E,
	32877 - 19968: jis0212<<14 | 0x34<<7 | 0x46,
	32879 - 19968: jis0208<<14 | 0x2D<<7 | 0x5D,
	32880 - 19968: jis0208<<14 | 0x45<<7 | 0x41,
	32881 - 19968: jis0212<<14 | 0x34<<7 | 0x47,
	32882 - 19968: jis0208<<14 | 0x45<<7 | 0x40,
	32883 - 19968: jis0208<<14 | 0x45<<7 | 0x3F,
	32884 - 19968: jis0208<<14 | 0x23<<7 | 0x0F,
	32885 - 19968: jis0212<<14 | 0x34<<7 | 0x48,
	32886 - 19968: jis0208<<14 | 0x45<<7 | 0x42,
	32887 - 19968: jis0208<<14 | 0x1E<<7 | 0x05,
	32889 - 19968: jis0208<<14 | 0x45<<7 | 0x43,
	32893 - 19968: jis0208<<14 | 0x45<<7 | 0x44,
	32894 - 19968: jis0208<<14 | 0x2E<<7 | 0x17,
	32895 - 19968: jis0208<<14 | 0x45<<7 | 0x45,
	32897 - 19968: jis0212<<14 | 0x34<<7 | 0x49,
	32900 - 19968: jis0208<<14 | 0x45<<7 | 0x46,
	32901 - 19968: jis0208<<14 | 0x45<<7 | 0x48,
	32902 - 19968: jis0208<<14 | 0x45<<7 | 0x47,
	32903 - 19968: jis0208<<14 | 0x27<<7 | 0x04,
	32904 - 19968: jis0212<<14 | 0x34<<7 | 0x4A,
	32905 - 19968: jis0208<<14 | 0x25<<7 | 0x58,
	32907 - 19968: jis0208<<14 | 0x2E<<7 | 0x1D,
	32908 - 19968: jis0208<<14 | 0x27<<7 | 0x08,
	32910 - 19968: jis0212<<14 | 0x34<<7 | 0x4B,
	32915 - 19968: jis0208<<14 | 0x45<<7 | 0x4A,
	32918 - 19968: jis0208<<14 | 0x1D<<7 | 0x32,
	32920 - 19968: jis0208<<14 | 0x28<<7 | 0x09,
	32922 - 19968: jis0208<<14 | 0x45<<7 | 0x4B,
	32923 - 19968: jis0208<<14 | 0x45<<7 | 0x49,
	32924 - 19968: jis0212<<14 | 0x34<<7 | 0x4C,
	32925 - 19968: jis0208<<14 | 0x13<<7 | 0x2D,
	32926 - 19968: jis0212<<14 | 0x34<<7 | 0x4D,
	32929 - 19968: jis0208<<14 | 0x17<<7 | 0x33,
	32930 - 19968: jis0208<<14 | 0x1A<<7 | 0x47,
	32933 - 19968: jis0208<<14 | 0x27<<7 | 0x4D,
	32934 - 19968: jis0212<<14 | 0x34<<7 | 0x4E,
	32935 - 19968: jis0212<<14 | 0x34<<7 | 0x4F,
	32937 - 19968: jis0208<<14 | 0x17<<7 | 0x09,
	32938 - 19968: jis0208<<14 | 0x2A<<7 | 0x22,
	32939 - 19968: jis0212<<14 | 0x34<<7 | 0x50,
	32940 - 19968: jis0208<<14 | 0x45<<7 | 0x4E,
	32941 - 19968: jis0208<<14 | 0x45<<7 | 0x4C,
	32943 - 19968: jis0208<<14 | 0x18<<7 | 0x2D,
	32945 - 19968: jis0208<<14 | 0x18<<7 | 0x2E,
	32946 - 19968: jis0208<<14 | 0x0F<<7 | 0x48,
	32948 - 19968: jis0208<<14 | 0x19<<7 | 0x47,
	32952 - 19968: jis0212<<14 | 0x34<<7 | 0x51,
	32953 - 19968: jis0212<<14 | 0x34<<7 | 0x52,
	32954 - 19968: jis0208<<14 | 0x26<<7 | 0x38,
	32963 - 19968: jis0208<<14 | 0x0F<<7 | 0x3E,
	32964 - 19968: jis0208<<14 | 0x45<<7 | 0x53,
	32966 - 19968: jis0208<<14 | 0x22<<7 | 0x1F,
	32968 - 19968: jis0212<<14 | 0x34<<7 | 0x53,
	32972 - 19968: jis0208<<14 | 0x26<<7 | 0x37,
	32973 - 19968: jis0212<<14 | 0x34<<7 | 0x54,
	32974 - 19968: jis0208<<14 | 0x21<<7 | 0x3A,
	32975 - 19968: jis0212<<14 | 0x34<<7 | 0x55,
	32978 - 19968: jis0212<<14 | 0x34<<7 | 0x56,
	32980 - 19968: jis0212<<14 | 0x34<<7 | 0x57,
	32981 - 19968: jis0212<<14 | 0x34<<7 | 0x58,
	32982 - 19968: jis0208<<14 | 0x45<<7 | 0x55,
	32983 - 19968: jis0212<<14 | 0x34<<7 | 0x59,
	32984 - 19968: jis0212<<14 | 0x34<<7 | 0x5A,
	32985 - 19968: jis0208<<14 | 0x45<<7 | 0x51,
	32986 - 19968: jis0208<<14 | 0x45<<7 | 0x54,
	32987 - 19968: jis0208<<14 | 0x45<<7 | 0x4F,
	32989 - 19968: jis0208<<14 | 0x45<<7 | 0x52,
	32990 - 19968: jis0208<<14 | 0x2A<<7 | 0x05,
	32992 - 19968: jis0212<<14 | 0x34<<7 | 0x5B,
	32993 - 19968: jis0208<<14 | 0x17<<7 | 0x34,
	32996 - 19968: jis0208<<14 | 0x0F<<7 | 0x5C,
	32997 - 19968: jis0208<<14 | 0x45<<7 | 0x50,
	33005 - 19968: jis0212<<14 | 0x34<<7 | 0x5C,
	33006 - 19968: jis0212<<14 | 0x34<<7 | 0x5D,
	33007 - 19968: jis0208<<14 | 0x45<<7 | 0x57,
	33008 - 19968: jis0212<<14 | 0x35<<7 | 0x00,
	33009 - 19968: jis0208<<14 | 0x45<<7 | 0x58,
	33010 - 19968: jis0212<<14 | 0x35<<7 | 0x01,
	33011 - 19968: jis0212<<14 | 0x35<<7 | 0x02,
	33012 - 19968: jis0208<<14 | 0x25<<7 | 0x18,
	33014 - 19968: jis0212<<14 | 0x35<<7 | 0x03,
	33016 - 19968: jis0208<<14 | 0x15<<7 | 0x1A,
	33017 - 19968: jis0212<<14 | 0x35<<7 | 0x04,
	33018 - 19968: jis0212<<14 | 0x35<<7 | 0x05,
	33020 - 19968: jis0208<<14 | 0x46<<7 | 0x05,
	33021 - 19968: jis0208<<14 | 0x26<<7 | 0x1C,
	33022 - 19968: jis0212<<14 | 0x35<<7 | 0x06,
	33026 - 19968: jis0208<<14 | 0x1A<<7 | 0x48,
	33027 - 19968: jis0212<<14 | 0x35<<7 | 0x07,
	33029 - 19968: jis0208<<14 | 0x15<<7 | 0x1B,
	33030 - 19968: jis0208<<14 | 0x1F<<7 | 0x27,
	33031 - 19968: jis0208<<14 | 0x2E<<7 | 0x25,
	33032 - 19968: jis0208<<14 | 0x2B<<7 | 0x0D,
	33033 - 19968: jis0208<<14 | 0x45<<7 | 0x56,
	33034 - 19968: jis0208<<14 | 0x1F<<7 | 0x33,
	33035 - 19968: jis0212<<14 | 0x35<<7 | 0x08,
	33046 - 19968: jis0212<<14 | 0x35<<7 | 0x09,
	33047 - 19968: jis0212<<14 | 0x35<<7 | 0x0A,
	33048 - 19968: jis0212<<14 | 0x35<<7 | 0x0B,
	33050 - 19968: jis0208<<14 | 0x14<<7 | 0x32,
	33051 - 19968: jis0208<<14 | 0x45<<7 | 0x59,
	33052 - 19968: jis0212<<14 | 0x35<<7 | 0x0C,
	33054 - 19968: jis0212<<14 | 0x35<<7 | 0x0D,
	33056 - 19968: jis0212<<14 | 0x35<<7 | 0x0E,
	33059 - 19968: jis0208<<14 | 0x45<<7 | 0x5B,
	33060 - 19968: jis0212<<14 | 0x35<<7 | 0x0F,
	33063 - 19968: jis0212<<14 | 0x35<<7 | 0x10,
	33065 - 19968: jis0208<<14 | 0x45<<7 | 0x5A,
	33068 - 19968: jis0212<<14 | 0x35<<7 | 0x11,
	33071 - 19968: jis0208<<14 | 0x45<<7 | 0x5C,
	33072 - 19968: jis0212<<14 | 0x35<<7 | 0x12,
	33073 - 19968: jis0208<<14 | 0x22<<7 | 0x05,
	33075 - 19968: jis0208<<14 | 0x26<<7 | 0x1D,
	33077 - 19968: jis0212<<14 | 0x35<<7 | 0x13,
	33081 - 19968: jis0208<<14 | 0x23<<7 | 0x10,
	33082 - 19968: jis0212<<14 | 0x35<<7 | 0x14,
	33084 - 19968: jis0212<<14 | 0x35<<7 | 0x15,
	33086 - 19968: jis0208<<14 | 0x46<<7 | 0x02,
	33093 - 19968: jis0212<<14 | 0x35<<7 | 0x16,
	33094 - 19968: jis0208<<14 | 0x46<<7 | 0x01,
	33095 - 19968: jis0212<<14 | 0x35<<7 | 0x17,
	33098 - 19968: jis0212<<14 | 0x35<<7 | 0x18,
	33099 - 19968: jis0208<<14 | 0x45<<7 | 0x5D,
	33100 - 19968: jis0212<<14 | 0x35<<7 | 0x19,
	33102 - 19968: jis0208<<14 | 0x1E<<7 | 0x34,
	33104 - 19968: jis0208<<14 | 0x28<<7 | 0x44,
	33105 - 19968: jis0208<<14 | 0x46<<7 | 0x04,
	33106 - 19968: jis0212<<14 | 0x35<<7 | 0x1A,
	33107 - 19968: jis0208<<14 | 0x46<<7 | 0x03,
	33108 - 19968: jis0208<<14 | 0x18<<7 | 0x2F,
	33109 - 19968: jis0208<<14 | 0x2E<<7 | 0x32,
	33111 - 19968: jis0212<<14 | 0x35<<7 | 0x1B,
	33119 - 19968: jis0208<<14 | 0x46<<7 | 0x14,
	33120 - 19968: jis0212<<14 | 0x35<<7 | 0x1C,
	33121 - 19968: jis0212<<14 | 0x35<<7 | 0x1D,
	33125 - 19968: jis0208<<14 | 0x46<<7 | 0x08,
	33126 - 19968: jis0208<<14 | 0x46<<7 | 0x09,
	33127 - 19968: jis0212<<14 | 0x35<<7 | 0x1E,
	33128 - 19968: jis0212<<14 | 0x35<<7 | 0x1F,
	33129 - 19968: jis0212<<14 | 0x35<<7 | 0x20,
	33131 - 19968: jis0208<<14 | 0x1B<<7 | 0x4F,
	33133 - 19968: jis0212<<14 | 0x35<<7 | 0x21,
	33134 - 19968: jis0208<<14 | 0x46<<7 | 0x07,
	33135 - 19968: jis0212<<14 | 0x35<<7 | 0x22,
	33136 - 19968: jis0208<<14 | 0x18<<7 | 0x57,
	33137 - 19968: jis0208<<14 | 0x46<<7 | 0x06,
	33140 - 19968: jis0208<<14 | 0x46<<7 | 0x0A,
	33143 - 19968: jis0212<<14 | 0x35<<7 | 0x23,
	33144 - 19968: jis0208<<14 | 0x23<<7 | 0x11,
	33145 - 19968: jis0208<<14 | 0x29<<7 | 0x01,
	33146 - 19968: jis0208<<14 | 0x20<<7 | 0x02,
	33151 - 19968: jis0208<<14 | 0x21<<7 | 0x3B,
	33152 - 19968: jis0208<<14 | 0x46<<7 | 0x0E,
	33153 - 19968: jis0212<<14 | 0x35<<7 | 0x24,
	33154 - 19968: jis0208<<14 | 0x46<<7 | 0x0F,
	33155 - 19968: jis0208<<14 | 0x46<<7 | 0x0B,
	33156 - 19968: jis0212<<14 | 0x35<<7 | 0x26,
	33157 - 19968: jis0212<<14 | 0x35<<7 | 0x27,
	33158 - 19968: jis0212<<14 | 0x35<<7 | 0x28,
	33160 - 19968: jis0208<<14 | 0x46<<7 | 0x0C,
	33162 - 19968: jis0208<<14 | 0x46<<7 | 0x0D,
	33163 - 19968: jis0212<<14 | 0x35<<7 | 0x29,
	33166 - 19968: jis0212<<14 | 0x35<<7 | 0x2A,
	33167 - 19968: jis0208<<14 | 0x18<<7 | 0x30,
	33168 - 19968: jis0212<<14 | 0x35<<7 | 0x25,
	33171 - 19968: jis0208<<14 | 0x46<<7 | 0x15,
	33173 - 19968: jis0208<<14 | 0x46<<7 | 0x11,
	33174 - 19968: jis0212<<14 | 0x35<<7 | 0x2B,
	33176 - 19968: jis0212<<14 | 0x35<<7 | 0x2C,
	33178 - 19968: jis0208<<14 | 0x28<<7 | 0x45,
	33179 - 19968: jis0212<<14 | 0x35<<7 | 0x2D,
	33180 - 19968: jis0208<<14 | 0x2A<<7 | 0x4B,
	33181 - 19968: jis0208<<14 | 0x28<<7 | 0x07,
	33182 - 19968: jis0212<<14 | 0x35<<7 | 0x2E,
	33184 - 19968: jis0208<<14 | 0x46<<7 | 0x10,
	33186 - 19968: jis0212<<14 | 0x35<<7 | 0x2F,
	33187 - 19968: jis0208<<14 | 0x46<<7 | 0x13,
	33188 - 19968: jis0208<<14 | 0x46<<7 | 0x12,
	33192 - 19968: jis0208<<14 | 0x2A<<7 | 0x23,
	33193 - 19968: jis0208<<14 | 0x46<<7 | 0x16,
	33198 - 19968: jis0212<<14 | 0x35<<7 | 0x30,
	33200 - 19968: jis0208<<14 | 0x46<<7 | 0x17,
	33202 - 19968: jis0212<<14 | 0x35<<7 | 0x31,
	33203 - 19968: jis0208<<14 | 0x20<<7 | 0x16,
	33204 - 19968: jis0212<<14 | 0x35<<7 | 0x32,
	33205 - 19968: jis0208<<14 | 0x46<<7 | 0x18,
	33208 - 19968: jis0208<<14 | 0x46<<7 | 0x1A,
	33210 - 19968: jis0208<<14 | 0x46<<7 | 0x1E,
	33211 - 19968: jis0212<<14 | 0x35<<7 | 0x33,
	33213 - 19968: jis0208<<14 | 0x46<<7 | 0x1B,
	33214 - 19968: jis0208<<14 | 0x46<<7 | 0x19,
	33215 - 19968: jis0208<<14 | 0x26<<7 | 0x1E,
	33216 - 19968: jis0208<<14 | 0x46<<7 | 0x1C,
	33218 - 19968: jis0208<<14 | 0x46<<7 | 0x1D,
	33219 - 19968: jis0212<<14 | 0x35<<7 | 0x35,
	33221 - 19968: jis0212<<14 | 0x35<<7 | 0x36,
	33222 - 19968: jis0208<<14 | 0x11<<7 | 0x11,
	33224 - 19968: jis0208<<14 | 0x46<<7 | 0x24,
	33225 - 19968: jis0208<<14 | 0x46<<7 | 0x1F,
	33226 - 19968: jis0212<<14 | 0x35<<7 | 0x37,
	33227 - 19968: jis0212<<14 | 0x35<<7 | 0x34,
	33229 - 19968: jis0208<<14 | 0x46<<7 | 0x20,
	33230 - 19968: jis0212<<14 | 0x35<<7 | 0x38,
	33231 - 19968: jis0212<<14 | 0x35<<7 | 0x39,
	33233 - 19968: jis0208<<14 | 0x46<<7 | 0x21,
	33235 - 19968: jis0208<<14 | 0x21<<7 | 0x00,
	33237 - 19968: jis0212<<14 | 0x35<<7 | 0x3A,
	33239 - 19968: jis0212<<14 | 0x35<<7 | 0x3B,
	33240 - 19968: jis0208<<14 | 0x46<<7 | 0x23,
	33241 - 19968: jis0208<<14 | 0x46<<7 | 0x22,
	33242 - 19968: jis0208<<14 | 0x46<<7 | 0x25,
	33243 - 19968: jis0212<<14 | 0x35<<7 | 0x3C,
	33245 - 19968: jis0212<<14 | 0x35<<7 | 0x3D,
	33246 - 19968: jis0212<<14 | 0x35<<7 | 0x3E,
	33247 - 19968: jis0208<<14 | 0x46<<7 | 0x26,
	33248 - 19968: jis0208<<14 | 0x46<<7 | 0x27,
	33249 - 19968: jis0212<<14 | 0x35<<7 | 0x3F,
	33251 - 19968: jis0208<<14 | 0x1E<<7 | 0x22,
	33252 - 19968: jis0212<<14 | 0x35<<7 | 0x40,
	33253 - 19968: jis0208<<14 | 0x11<<7 | 0x48,
	33255 - 19968: jis0208<<14 | 0x46<<7 | 0x28,
	33256 - 19968: jis0208<<14 | 0x2D<<7 | 0x36,
	33258 - 19968: jis0208<<14 | 0x1B<<7 | 0x0A,
	33259 - 19968: jis0212<<14 | 0x35<<7 | 0x41,
	33260 - 19968: jis0212<<14 | 0x35<<7 | 0x42,
	33261 - 19968: jis0208<<14 | 0x1C<<7 | 0x0C,
	33264 - 19968: jis0212<<14 | 0x35<<7 | 0x43,
	33265 - 19968: jis0212<<14 | 0x35<<7 | 0x44,
	33266 - 19968: jis0212<<14 | 0x35<<7 | 0x45,
	33267 - 19968: jis0208<<14 | 0x1A<<7 | 0x49,
	33268 - 19968: jis0208<<14 | 0x22<<7 | 0x36,
	33269 - 19968: jis0212<<14 | 0x35<<7 | 0x46,
	33270 - 19968: jis0212<<14 | 0x35<<7 | 0x47,
	33272 - 19968: jis0212<<14 | 0x35<<7 | 0x48,
	33273 - 19968: jis0212<<14 | 0x35<<7 | 0x49,
	33274 - 19968: jis0208<<14 | 0x46<<7 | 0x29,
	33275 - 19968: jis0208<<14 | 0x46<<7 | 0x2A,
	33276 - 19968: jis0208<<14 | 0x10<<7 | 0x10,
	33277 - 19968: jis0212<<14 | 0x35<<7 | 0x4A,
	33278 - 19968: jis0208<<14 | 0x46<<7 | 0x2B,
	33279 - 19968: jis0212<<14 | 0x35<<7 | 0x4B,
	33280 - 19968: jis0212<<14 | 0x35<<7 | 0x4C,
	33281 - 19968: jis0208<<14 | 0x46<<7 | 0x2C,
	33282 - 19968: jis0208<<14 | 0x46<<7 | 0x2D,
	33283 - 19968: jis0212<<14 | 0x35<<7 | 0x4D,
	33285 - 19968: jis0208<<14 | 0x46<<7 | 0x2E,
	33287 - 19968: jis0208<<14 | 0x46<<7 | 0x2F,
	33288 - 19968: jis0208<<14 | 0x15<<7 | 0x1C,
	33289 - 19968: jis0208<<14 | 0x39<<7 | 0x09,
	33290 - 19968: jis0208<<14 | 0x46<<7 | 0x30,
	33292 - 19968: jis0208<<14 | 0x1F<<7 | 0x44,
	33293 - 19968: jis0208<<14 | 0x46<<7 | 0x31,
	33294 - 19968: jis0208<<14 | 0x1B<<7 | 0x2A,
	33295 - 19968: jis0212<<14 | 0x35<<7 | 0x4E,
	33296 - 19968: jis0208<<14 | 0x46<<7 | 0x32,
	33298 - 19968: jis0208<<14 | 0x2F<<7 | 0x0F,
	33299 - 19968: jis0212<<14 | 0x35<<7 | 0x4F,
	33300 - 19968: jis0212<<14 | 0x35<<7 | 0x50,
	33302 - 19968: jis0208<<14 | 0x46<<7 | 0x33,
	33303 - 19968: jis0208<<14 | 0x29<<7 | 0x3D,
	33304 - 19968: jis0208<<14 | 0x13<<7 | 0x3B,
	33305 - 19968: jis0212<<14 | 0x35<<7 | 0x51,
	33306 - 19968: jis0212<<14 | 0x35<<7 | 0x52,
	33307 - 19968: jis0208<<14 | 0x20<<7 | 0x03,
	33308 - 19968: jis0208<<14 | 0x1C<<7 | 0x37,
	33309 - 19968: jis0212<<14 | 0x35<<7 | 0x53,
	33310 - 19968: jis0208<<14 | 0x28<<7 | 0x50,
	33311 - 19968: jis0208<<14 | 0x1C<<7 | 0x0D,
	33313 - 19968: jis0212<<14 | 0x35<<7 | 0x54,
	33314 - 19968: jis0212<<14 | 0x35<<7 | 0x55,
	33320 - 19968: jis0212<<14 | 0x35<<7 | 0x56,
	33321 - 19968: jis0208<<14 | 0x46<<7 | 0x34,
	33322 - 19968: jis0208<<14 | 0x18<<7 | 0x31,
	33323 - 19968: jis0208<<14 | 0x46<<7 | 0x35,
	33324 - 19968: jis0208<<14 | 0x27<<7 | 0x2B,
	33326 - 19968: jis0208<<14 | 0x46<<7 | 0x43,
	33330 - 19968: jis0212<<14 | 0x35<<7 | 0x57,
	33331 - 19968: jis0208<<14 | 0x46<<7 | 0x37,
	33332 - 19968: jis0212<<14 | 0x35<<7 | 0x58,
	33333 - 19968: jis0208<<14 | 0x21<<7 | 0x28,
	33334 - 19968: jis0208<<14 | 0x26<<7 | 0x54,
	33335 - 19968: jis0208<<14 | 0x17<<7 | 0x1E,
	33336 - 19968: jis0208<<14 | 0x46<<7 | 0x36,
	33337 - 19968: jis0208<<14 | 0x20<<7 | 0x04,
	33338 - 19968: jis0212<<14 | 0x35<<7 | 0x59,
	33344 - 19968: jis0208<<14 | 0x46<<7 | 0x38,
	33347 - 19968: jis0212<<14 | 0x35<<7 | 0x5A,
	33348 - 19968: jis0212<<14 | 0x35<<7 | 0x5B,
	33349 - 19968: jis0212<<14 | 0x35<<7 | 0x5C,
	33350 - 19968: jis0212<<14 | 0x35<<7 | 0x5D,
	33351 - 19968: jis0208<<14 | 0x23<<7 | 0x59,
	33355 - 19968: jis0212<<14 | 0x36<<7 | 0x00,
	33358 - 19968: jis0212<<14 | 0x36<<7 | 0x01,
	33359 - 19968: jis0212<<14 | 0x36<<7 | 0x02,
	33361 - 19968: jis0212<<14 | 0x36<<7 | 0x03,
	33366 - 19968: jis0212<<14 | 0x36<<7 | 0x04,
	33368 - 19968: jis0208<<14 | 0x46<<7 | 0x3A,
	33369 - 19968: jis0208<<14 | 0x46<<7 | 0x39,
	33370 - 19968: jis0208<<14 | 0x46<<7 | 0x3C,
	33372 - 19968: jis0212<<14 | 0x36<<7 | 0x05,
	33373 - 19968: jis0208<<14 | 0x46<<7 | 0x3B,
	33375 - 19968: jis0208<<14 | 0x46<<7 | 0x3D,
	33376 - 19968: jis0212<<14 | 0x36<<7 | 0x06,
	33378 - 19968: jis0208<<14 | 0x46<<7 | 0x3F,
	33379 - 19968: jis0212<<14 | 0x36<<7 | 0x07,
	33380 - 19968: jis0208<<14 | 0x46<<7 | 0x3E,
	33382 - 19968: jis0208<<14 | 0x13<<7 | 0x2E,
	33383 - 19968: jis0212<<14 | 0x36<<7 | 0x08,
	33384 - 19968: jis0208<<14 | 0x46<<7 | 0x40,
	33386 - 19968: jis0208<<14 | 0x46<<7 | 0x41,
	33387 - 19968: jis0208<<14 | 0x46<<7 | 0x42,
	33389 - 19968: jis0212<<14 | 0x36<<7 | 0x09,
	33390 - 19968: jis0208<<14 | 0x19<<7 | 0x10,
	33391 - 19968: jis0208<<14 | 0x2D<<7 | 0x28,
	33393 - 19968: jis0208<<14 | 0x46<<7 | 0x44,
	33394 - 19968: jis0208<<14 | 0x1E<<7 | 0x06,
	33396 - 19968: jis0212<<14 | 0x36<<7 | 0x0A,
	33398 - 19968: jis0208<<14 | 0x10<<7 | 0x4F,
	33399 - 19968: jis0208<<14 | 0x46<<7 | 0x45,
	33400 - 19968: jis0208<<14 | 0x46<<7 | 0x46,
	33403 - 19968: jis0212<<14 | 0x36<<7 | 0x0B,
	33405 - 19968: jis0212<<14 | 0x36<<7 | 0x0C,
	33406 - 19968: jis0208<<14 | 0x46<<7 | 0x47,
	33407 - 19968: jis0212<<14 | 0x36<<7 | 0x0D,
	33408 - 19968: jis0212<<14 | 0x36<<7 | 0x0E,
	33409 - 19968: jis0212<<14 | 0x36<<7 | 0x0F,
	33411 - 19968: jis0212<<14 | 0x36<<7 | 0x10,
	33412 - 19968: jis0212<<14 | 0x36<<7 | 0x11,
	33415 - 19968: jis0212<<14 | 0x36<<7 | 0x12,
	33417 - 19968: jis0212<<14 | 0x36<<7 | 0x13,
	33418 - 19968: jis0212<<14 | 0x36<<7 | 0x14,
	33419 - 19968: jis0208<<14 | 0x0F<<7 | 0x51,
	33421 - 19968: jis0208<<14 | 0x46<<7 | 0x48,
	33422 - 19968: jis0212<<14 | 0x36<<7 | 0x15,
	33425 - 19968: jis0212<<14 | 0x36<<7 | 0x16,
	33426 - 19968: jis0208<<14 | 0x46<<7 | 0x49,
	33428 - 19968: jis0212<<14 | 0x36<<7 | 0x17,
	33430 - 19968: jis0212<<14 | 0x36<<7 | 0x18,
	33432 - 19968: jis0212<<14 | 0x36<<7 | 0x19,
	33433 - 19968: jis0208<<14 | 0x28<<7 | 0x46,
	33434 - 19968: jis0212<<14 | 0x36<<7 | 0x1A,
	33435 - 19968: jis0212<<14 | 0x36<<7 | 0x1B,
	33437 - 19968: jis0208<<14 | 0x1B<<7 | 0x26,
	33439 - 19968: jis0208<<14 | 0x46<<7 | 0x4B,
	33440 - 19968: jis0212<<14 | 0x36<<7 | 0x1C,
	33441 - 19968: jis0212<<14 | 0x36<<7 | 0x1D,
	33443 - 19968: jis0212<<14 | 0x36<<7 | 0x1E,
	33444 - 19968: jis0212<<14 | 0x36<<7 | 0x1F,
	33445 - 19968: jis0208<<14 | 0x12<<7 | 0x08,
	33446 - 19968: jis0208<<14 | 0x0F<<7 | 0x11,
	33447 - 19968: jis0212<<14 | 0x36<<7 | 0x20,
	33448 - 19968: jis0212<<14 | 0x36<<7 | 0x21,
	33449 - 19968: jis0212<<14 | 0x36<<7 | 0x22,
	33450 - 19968: jis0212<<14 | 0x36<<7 | 0x23,
	33451 - 19968: jis0208<<14 | 0x46<<7 | 0x4A,
	33452 - 19968: jis0208<<14 | 0x46<<7 | 0x4D,
	33453 - 19968: jis0208<<14 | 0x26<<7 | 0x2D,
	33454 - 19968: jis0212<<14 | 0x36<<7 | 0x24,
	33455 - 19968: jis0208<<14 | 0x1E<<7 | 0x23,
	33456 - 19968: jis0212<<14 | 0x36<<7 | 0x25,
	33457 - 19968: jis0208<<14 | 0x11<<7 | 0x35,
	33458 - 19968: jis0212<<14 | 0x36<<7 | 0x26,
	33459 - 19968: jis0208<<14 | 0x2A<<7 | 0x06,
	33460 - 19968: jis0212<<14 | 0x36<<7 | 0x27,
	33463 - 19968: jis0212<<14 | 0x36<<7 | 0x28,
	33464 - 19968: jis0208<<14 | 0x16<<7 | 0x3C,
	33465 - 19968: jis0208<<14 | 0x15<<7 | 0x3B,
	33466 - 19968: jis0212<<14 | 0x36<<7 | 0x29,
	33467 - 19968: jis0208<<14 | 0x46<<7 | 0x4C,
	33468 - 19968: jis0212<<14 | 0x36<<7 | 0x2A,
	33469 - 19968: jis0208<<14 | 0x11<<7 | 0x49,
	33470 - 19968: jis0212<<14 | 0x36<<7 | 0x2B,
	33471 - 19968: jis0212<<14 | 0x36<<7 | 0x2C,
	33477 - 19968: jis0208<<14 | 0x13<<7 | 0x02,
	33478 - 19968: jis0212<<14 | 0x36<<7 | 0x2D,
	33488 - 19968: jis0212<<14 | 0x36<<7 | 0x2E,
	33489 - 19968: jis0208<<14 | 0x10<<7 | 0x50,
	33490 - 19968: jis0208<<14 | 0x46<<7 | 0x51,
	33491 - 19968: jis0208<<14 | 0x2D<<7 | 0x49,
	33492 - 19968: jis0208<<14 | 0x21<<7 | 0x3C,
	33493 - 19968: jis0212<<14 | 0x36<<7 | 0x2F,
	33495 - 19968: jis0208<<14 | 0x28<<7 | 0x23,
	33497 - 19968: jis0208<<14 | 0x46<<7 | 0x5D,
	33498 - 19968: jis0212<<14 | 0x36<<7 | 0x30,
	33499 - 19968: jis0208<<14 | 0x11<<7 | 0x36,
	33500 - 19968: jis0208<<14 | 0x46<<7 | 0x5B,
	33502 - 19968: jis0208<<14 | 0x46<<7 | 0x59,
	33503 - 19968: jis0208<<14 | 0x46<<7 | 0x50,
	33504 - 19968: jis0212<<14 | 0x36<<7 | 0x31,
	33505 - 19968: jis0208<<14 | 0x46<<7 | 0x4E,
	33506 - 19968: jis0212<<14 | 0x36<<7 | 0x32,
	33507 - 19968: jis0208<<14 | 0x46<<7 | 0x4F,
	33508 - 19968: jis0212<<14 | 0x36<<7 | 0x33,
	33509 - 19968: jis0208<<14 | 0x1B<<7 | 0x42,
	33510 - 19968: jis0208<<14 | 0x15<<7 | 0x4B,
	33511 - 19968: jis0208<<14 | 0x22<<7 | 0x56,
	33512 - 19968: jis0212<<14 | 0x36<<7 | 0x34,
	33514 - 19968: jis0212<<14 | 0x36<<7 | 0x35,
	33515 - 19968: jis0208<<14 | 0x25<<7 | 0x30,
	33517 - 19968: jis0212<<14 | 0x36<<7 | 0x36,
	33519 - 19968: jis0212<<14 | 0x36<<7 | 0x37,
	33521 - 19968: jis0208<<14 | 0x10<<7 | 0x30,
	33523 - 19968: jis0208<<14 | 0x46<<7 | 0x53,
	33524 - 19968: jis0208<<14 | 0x46<<7 | 0x52,
	33526 - 19968: jis0212<<14 | 0x36<<7 | 0x38,
	33527 - 19968: jis0212<<14 | 0x36<<7 | 0x39,
	33529 - 19968: jis0208<<14 | 0x46<<7 | 0x58,
	33530 - 19968: jis0208<<14 | 0x46<<7 | 0x54,
	33531 - 19968: jis0208<<14 | 0x46<<7 | 0x57,
	33533 - 19968: jis0212<<14 | 0x36<<7 | 0x3A,
	33534 - 19968: jis0212<<14 | 0x36<<7 | 0x3B,
	33536 - 19968: jis0212<<14 | 0x36<<7 | 0x3C,
	33537 - 19968: jis0208<<14 | 0x5A<<7 | 0x36,
	33538 - 19968: jis0208<<14 | 0x2B<<7 | 0x2F,
	33539 - 19968: jis0208<<14 | 0x46<<7 | 0x56,
	33540 - 19968: jis0208<<14 | 0x11<<7 | 0x37,
	33541 - 19968: jis0208<<14 | 0x12<<7 | 0x5C,
	33542 - 19968: jis0208<<14 | 0x46<<7 | 0x5A,
	33543 - 19968: jis0212<<14 | 0x36<<7 | 0x3E,
	33544 - 19968: jis0212<<14 | 0x36<<7 | 0x3F,
	33545 - 19968: jis0208<<14 | 0x46<<7 | 0x5C,
	33546 - 19968: jis0212<<14 | 0x36<<7 | 0x40,
	33547 - 19968: jis0212<<14 | 0x36<<7 | 0x41,
	33550 - 19968: jis0208<<14 | 0x16<<7 | 0x33,
	33558 - 19968: jis0208<<14 | 0x47<<7 | 0x02,
	33559 - 19968: jis0208<<14 | 0x47<<7 | 0x0B,
	33560 - 19968: jis0208<<14 | 0x47<<7 | 0x0C,
	33563 - 19968: jis0212<<14 | 0x36<<7 | 0x43,
	33564 - 19968: jis0208<<14 | 0x0F<<7 | 0x0A,
	33565 - 19968: jis0212<<14 | 0x36<<7 | 0x44,
	33566 - 19968: jis0212<<14 | 0x36<<7 | 0x45,
	33567 - 19968: jis0212<<14 | 0x36<<7 | 0x46,
	33569 - 19968: jis0212<<14 | 0x36<<7 | 0x47,
	33570 - 19968: jis0212<<14 | 0x36<<7 | 0x48,
	33571 - 19968: jis0208<<14 | 0x47<<7 | 0x13,
	33576 - 19968: jis0208<<14 | 0x0F<<7 | 0x50,
	33579 - 19968: jis0208<<14 | 0x47<<7 | 0x0A,
	33580 - 19968: jis0212<<14 | 0x36<<7 | 0x49,
	33581 - 19968: jis0212<<14 | 0x36<<7 | 0x4A,
	33582 - 19968: jis0212<<14 | 0x36<<7 | 0x4B,
	33583 - 19968: jis0208<<14 | 0x47<<7 | 0x09,
	33584 - 19968: jis0212<<14 | 0x36<<7 | 0x4C,
	33585 - 19968: jis0208<<14 | 0x47<<7 | 0x04,
	33586 - 19968: jis0208<<14 | 0x47<<7 | 0x03,
	33587 - 19968: jis0212<<14 | 0x36<<7 | 0x4D,
	33588 - 19968: jis0208<<14 | 0x47<<7 | 0x01,
	33589 - 19968: jis0208<<14 | 0x47<<7 | 0x00,
	33590 - 19968: jis0208<<14 | 0x22<<7 | 0x42,
	33591 - 19968: jis0212<<14 | 0x36<<7 | 0x4E,
	33592 - 19968: jis0208<<14 | 0x21<<7 | 0x5A,
	33593 - 19968: jis0208<<14 | 0x47<<7 | 0x06,
	33594 - 19968: jis0212<<14 | 0x36<<7 | 0x4F,
	33596 - 19968: jis0212<<14 | 0x36<<7 | 0x50,
	33597 - 19968: jis0212<<14 | 0x36<<7 | 0x51,
	33600 - 19968: jis0208<<14 | 0x47<<7 | 0x05,
	33602 - 19968: jis0212<<14 | 0x36<<7 | 0x52,
	33603 - 19968: jis0212<<14 | 0x36<<7 | 0x53,
	33604 - 19968: jis0212<<14 | 0x36<<7 | 0x54,
	33605 - 19968: jis0208<<14 | 0x47<<7 | 0x08,
	33607 - 19968: jis0212<<14 | 0x36<<7 | 0x55,
	33609 - 19968: jis0208<<14 | 0x20<<7 | 0x4F,
	33610 - 19968: jis0208<<14 | 0x16<<7 | 0x34,
	33613 - 19968: jis0212<<14 | 0x36<<7 | 0x56,
	33614 - 19968: jis0212<<14 | 0x36<<7 | 0x57,
	33615 - 19968: jis0208<<14 | 0x10<<7 | 0x20,
	33616 - 19968: jis0208<<14 | 0x47<<7 | 0x07,
	33617 - 19968: jis0212<<14 | 0x36<<7 | 0x58,
	33618 - 19968: jis0208<<14 | 0x18<<7 | 0x32,
	33619 - 19968: jis0212<<14 | 0x37<<7 | 0x1D,
	33620 - 19968: jis0212<<14 | 0x36<<7 | 0x42,
	33621 - 19968: jis0212<<14 | 0x36<<7 | 0x59,
	33622 - 19968: jis0212<<14 | 0x36<<7 | 0x5A,
	33623 - 19968: jis0212<<14 | 0x36<<7 | 0x5B,
	33624 - 19968: jis0208<<14 | 0x20<<7 | 0x50,
	33634 - 19968: jis0208<<14 | 0x5A<<7 | 0x37,
	33648 - 19968: jis0212<<14 | 0x36<<7 | 0x5C,
	33651 - 19968: jis0208<<14 | 0x47<<7 | 0x19,
	33653 - 19968: jis0208<<14 | 0x47<<7 | 0x1A,
	33655 - 19968: jis0208<<14 | 0x11<<7 | 0x38,
	33656 - 19968: jis0212<<14 | 0x36<<7 | 0x5D,
	33659 - 19968: jis0208<<14 | 0x11<<7 | 0x0D,
	33660 - 19968: jis0208<<14 | 0x47<<7 | 0x17,
	33661 - 19968: jis0212<<14 | 0x37<<7 | 0x00,
	33663 - 19968: jis0208<<14 | 0x5A<<7 | 0x38,
	33664 - 19968: jis0212<<14 | 0x37<<7 | 0x02,
	33666 - 19968: jis0212<<14 | 0x37<<7 | 0x03,
	33668 - 19968: jis0212<<14 | 0x37<<7 | 0x04,
	33669 - 19968: jis0208<<14 | 0x47<<7 | 0x0D,
	33670 - 19968: jis0212<<14 | 0x37<<7 | 0x05,
	33671 - 19968: jis0208<<14 | 0x47<<7 | 0x15,
	33673 - 19968: jis0208<<14 | 0x47<<7 | 0x1C,
	33674 - 19968: jis0208<<14 | 0x47<<7 | 0x16,
	33677 - 19968: jis0212<<14 | 0x37<<7 | 0x06,
	33678 - 19968: jis0208<<14 | 0x47<<7 | 0x14,
	33682 - 19968: jis0212<<14 | 0x37<<7 | 0x07,
	33683 - 19968: jis0208<<14 | 0x46<<7 | 0x55,
	33684 - 19968: jis0212<<14 | 0x37<<7 | 0x08,
	33685 - 19968: jis0212<<14 | 0x37<<7 | 0x09,
	33686 - 19968: jis0208<<14 | 0x47<<7 | 0x12,
	33688 - 19968: jis0212<<14 | 0x37<<7 | 0x0A,
	33689 - 19968: jis0212<<14 | 0x37<<7 | 0x0B,
	33690 - 19968: jis0208<<14 | 0x47<<7 | 0x0E,
	33691 - 19968: jis0212<<14 | 0x37<<7 | 0x0C,
	33692 - 19968: jis0212<<14 | 0x37<<7 | 0x0D,
	33693 - 19968: jis0212<<14 | 0x37<<7 | 0x0E,
	33694 - 19968: jis0208<<14 | 0x13<<7 | 0x2F,
	33695 - 19968: jis0208<<14 | 0x47<<7 | 0x10,
	33696 - 19968: jis0208<<14 | 0x47<<7 | 0x1B,
	33698 - 19968: jis0208<<14 | 0x47<<7 | 0x11,
	33702 - 19968: jis0212<<14 | 0x37<<7 | 0x0F,
	33703 - 19968: jis0212<<14 | 0x37<<7 | 0x10,
	33704 - 19968: jis0208<<14 | 0x47<<7 | 0x1D,
	33705 - 19968: jis0212<<14 | 0x37<<7 | 0x11,
	33706 - 19968: jis0208<<14 | 0x47<<7 | 0x0F,
	33707 - 19968: jis0208<<14 | 0x26<<7 | 0x5B,
	33708 - 19968: jis0212<<14 | 0x37<<7 | 0x12,
	33709 - 19968: jis0212<<14 | 0x37<<7 | 0x2B,
	33713 - 19968: jis0208<<14 | 0x2C<<7 | 0x48,
	33717 - 19968: jis0208<<14 | 0x47<<7 | 0x18,
	33725 - 19968: jis0208<<14 | 0x47<<7 | 0x2E,
	33726 - 19968: jis0212<<14 | 0x37<<7 | 0x13,
	33727 - 19968: jis0212<<14 | 0x37<<7 | 0x14,
	33728 - 19968: jis0212<<14 | 0x37<<7 | 0x15,
	33729 - 19968: jis0208<<14 | 0x47<<7 | 0x26,
	33733 - 19968: jis0208<<14 | 0x1E<<7 | 0x5A,
	33735 - 19968: jis0208<<14 | 0x5A<<7 | 0x39,
	33737 - 19968: jis0212<<14 | 0x37<<7 | 0x17,
	33738 - 19968: jis0208<<14 | 0x14<<7 | 0x25,
	33740 - 19968: jis0208<<14 | 0x15<<7 | 0x3C,
	33742 - 19968: jis0208<<14 | 0x47<<7 | 0x21,
	33743 - 19968: jis0212<<14 | 0x37<<7 | 0x18,
	33744 - 19968: jis0212<<14 | 0x37<<7 | 0x19,
	33745 - 19968: jis0212<<14 | 0x37<<7 | 0x1A,
	33747 - 19968: jis0208<<14 | 0x11<<7 | 0x3A,
	33748 - 19968: jis0212<<14 | 0x37<<7 | 0x1B,
	33750 - 19968: jis0208<<14 | 0x1D<<7 | 0x33,
	33752 - 19968: jis0208<<14 | 0x47<<7 | 0x24,
	33756 - 19968: jis0208<<14 | 0x19<<7 | 0x39,
	33757 - 19968: jis0212<<14 | 0x37<<7 | 0x1C,
	33759 - 19968: jis0208<<14 | 0x24<<7 | 0x30,
	33760 - 19968: jis0208<<14 | 0x47<<7 | 0x29,
	33768 - 19968: jis0212<<14 | 0x37<<7 | 0x1E,
	33769 - 19968: jis0208<<14 | 0x29<<7 | 0x4D,
	33770 - 19968: jis0212<<14 | 0x37<<7 | 0x1F,
	33771 - 19968: jis0208<<14 | 0x47<<7 | 0x20,
	33775 - 19968: jis0208<<14 | 0x11<<7 | 0x39,
	33776 - 19968: jis0208<<14 | 0x17<<7 | 0x35,
	33777 - 19968: jis0208<<14 | 0x28<<7 | 0x08,
	33778 - 19968: jis0208<<14 | 0x47<<7 | 0x2A,
	33780 - 19968: jis0208<<14 | 0x47<<7 | 0x1E,
	33782 - 19968: jis0208<<14 | 0x5A<<7 | 0x3A,
	33783 - 19968: jis0208<<14 | 0x47<<7 | 0x27,
	33784 - 19968: jis0212<<14 | 0x37<<7 | 0x21,
	33785 - 19968: jis0212<<14 | 0x37<<7 | 0x22,
	33787 - 19968: jis0208<<14 | 0x47<<7 | 0x31,
	33788 - 19968: jis0212<<14 | 0x37<<7 | 0x23,
	33789 - 19968: jis0208<<14 | 0x47<<7 | 0x22,
	33793 - 19968: jis0212<<14 | 0x37<<7 | 0x24,
	33795 - 19968: jis0208<<14 | 0x47<<7 | 0x23,
	33796 - 19968: jis0208<<14 | 0x25<<7 | 0x19,
	33798 - 19968: jis0212<<14 | 0x37<<7 | 0x25,
	33799 - 19968: jis0208<<14 | 0x47<<7 | 0x28,
	33802 - 19968: jis0212<<14 | 0x37<<7 | 0x26,
	33803 - 19968: jis0208<<14 | 0x47<<7 | 0x25,
	33804 - 19968: jis0208<<14 | 0x2A<<7 | 0x07,
	33805 - 19968: jis0208<<14 | 0x47<<7 | 0x2B,
	33806 - 19968: jis0208<<14 | 0x0F<<7 | 0x3F,
	33807 - 19968: jis0212<<14 | 0x37<<7 | 0x27,
	33809 - 19968: jis0212<<14 | 0x37<<7 | 0x28,
	33811 - 19968: jis0208<<14 | 0x47<<7 | 0x1F,
	33813 - 19968: jis0212<<14 | 0x37<<7 | 0x29,
	33817 - 19968: jis0212<<14 | 0x37<<7 | 0x2A,
	33824 - 19968: jis0208<<14 | 0x47<<7 | 0x2D,
	33826 - 19968: jis0208<<14 | 0x47<<7 | 0x2C,
	33833 - 19968: jis0208<<14 | 0x26<<7 | 0x4A,
	33834 - 19968: jis0208<<14 | 0x47<<7 | 0x33,
	33836 - 19968: jis0208<<14 | 0x47<<7 | 0x3E,
	33839 - 19968: jis0212<<14 | 0x37<<7 | 0x2C,
	33841 - 19968: jis0208<<14 | 0x12<<7 | 0x5D,
	33845 - 19968: jis0208<<14 | 0x47<<7 | 0x41,
	33848 - 19968: jis0208<<14 | 0x47<<7 | 0x2F,
	33849 - 19968: jis0212<<14 | 0x37<<7 | 0x2D,
	33852 - 19968: jis0208<<14 | 0x47<<7 | 0x34,
	33853 - 19968: jis0208<<14 | 0x2C<<7 | 0x4D,
	33861 - 19968: jis0212<<14 | 0x37<<7 | 0x2E,
	33862 - 19968: jis0208<<14 | 0x47<<7 | 0x3D,
	33863 - 19968: jis0212<<14 | 0x37<<7 | 0x2F,
	33864 - 19968: jis0208<<14 | 0x5A<<7 | 0x3B,
	33865 - 19968: jis0208<<14 | 0x2C<<7 | 0x34,
	33866 - 19968: jis0212<<14 | 0x37<<7 | 0x31,
	33869 - 19968: jis0212<<14 | 0x37<<7 | 0x32,
	33870 - 19968: jis0208<<14 | 0x2D<<7 | 0x09,
	33871 - 19968: jis0212<<14 | 0x37<<7 | 0x33,
	33873 - 19968: jis0212<<14 | 0x37<<7 | 0x34,
	33874 - 19968: jis0212<<14 | 0x37<<7 | 0x35,
	33878 - 19968: jis0212<<14 | 0x37<<7 | 0x36,
	33879 - 19968: jis0208<<14 | 0x22<<7 | 0x57,
	33880 - 19968: jis0212<<14 | 0x37<<7 | 0x37,
	33881 - 19968: jis0212<<14 | 0x37<<7 | 0x38,
	33882 - 19968: jis0212<<14 | 0x37<<7 | 0x39,
	33883 - 19968: jis0208<<14 | 0x12<<7 | 0x4A,
	33884 - 19968: jis0212<<14 | 0x37<<7 | 0x3A,
	33888 - 19968: jis0212<<14 | 0x37<<7 | 0x3B,
	33889 - 19968: jis0208<<14 | 0x28<<7 | 0x51,
	33890 - 19968: jis0208<<14 | 0x47<<7 | 0x43,
	33891 - 19968: jis0208<<14 | 0x25<<7 | 0x00,
	33892 - 19968: jis0212<<14 | 0x37<<7 | 0x3C,
	33893 - 19968: jis0212<<14 | 0x37<<7 | 0x3D,
	33894 - 19968: jis0208<<14 | 0x0F<<7 | 0x10,
	33895 - 19968: jis0212<<14 | 0x37<<7 | 0x3E,
	33897 - 19968: jis0208<<14 | 0x47<<7 | 0x3C,
	33898 - 19968: jis0212<<14 | 0x37<<7 | 0x3F,
	33899 - 19968: jis0208<<14 | 0x47<<7 | 0x38,
	33900 - 19968: jis0208<<14 | 0x20<<7 | 0x51,
	33901 - 19968: jis0208<<14 | 0x47<<7 | 0x32,
	33902 - 19968: jis0208<<14 | 0x47<<7 | 0x3A,
	33903 - 19968: jis0208<<14 | 0x47<<7 | 0x3F,
	33904 - 19968: jis0212<<14 | 0x37<<7 | 0x40,
	33905 - 19968: jis0208<<14 | 0x26<<7 | 0x0B,
	33907 - 19968: jis0212<<14 | 0x37<<7 | 0x41,
	33908 - 19968: jis0212<<14 | 0x37<<7 | 0x42,
	33909 - 19968: jis0208<<14 | 0x0F<<7 | 0x09,
	33910 - 19968: jis0212<<14 | 0x37<<7 | 0x43,
	33911 - 19968: jis0208<<14 | 0x47<<7 | 0x37,
	33912 - 19968: jis0212<<14 | 0x37<<7 | 0x44,
	33913 - 19968: jis0208<<14 | 0x47<<7 | 0x40,
	33914 - 19968: jis0208<<14 | 0x28<<7 | 0x57,
	33916 - 19968: jis0212<<14 | 0x37<<7 | 0x45,
	33917 - 19968: jis0212<<14 | 0x37<<7 | 0x46,
	33921 - 19968: jis0212<<14 | 0x37<<7 | 0x47,
	33922 - 19968: jis0208<<14 | 0x47<<7 | 0x3B,
	33924 - 19968: jis0208<<14 | 0x47<<7 | 0x36,
	33925 - 19968: jis0212<<14 | 0x37<<7 | 0x48,
	33931 - 19968: jis0208<<14 | 0x1D<<7 | 0x34,
	33936 - 19968: jis0208<<14 | 0x1C<<7 | 0x0E,
	33938 - 19968: jis0212<<14 | 0x37<<7 | 0x49,
	33939 - 19968: jis0212<<14 | 0x37<<7 | 0x4A,
	33940 - 19968: jis0208<<14 | 0x1B<<7 | 0x0B,
	33941 - 19968: jis0212<<14 | 0x37<<7 | 0x4B,
	33945 - 19968: jis0208<<14 | 0x2B<<7 | 0x37,
	33948 - 19968: jis0208<<14 | 0x28<<7 | 0x26,
	33950 - 19968: jis0212<<14 | 0x37<<7 | 0x4C,
	33951 - 19968: jis0208<<14 | 0x47<<7 | 0x46,
	33953 - 19968: jis0208<<14 | 0x47<<7 | 0x4F,
	33958 - 19968: jis0212<<14 | 0x37<<7 | 0x4D,
	33960 - 19968: jis0212<<14 | 0x37<<7 | 0x4E,
	33961 - 19968: jis0212<<14 | 0x37<<7 | 0x4F,
	33962 - 19968: jis0212<<14 | 0x37<<7 | 0x50,
	33965 - 19968: jis0208<<14 | 0x47<<7 | 0x39,
	33967 - 19968: jis0212<<14 | 0x37<<7 | 0x51,
	33969 - 19968: jis0212<<14 | 0x37<<7 | 0x52,
	33970 - 19968: jis0208<<14 | 0x12<<7 | 0x56,
	33972 - 19968: jis0208<<14 | 0x5A<<7 | 0x3C,
	33976 - 19968: jis0208<<14 | 0x1D<<7 | 0x57,
	33977 - 19968: jis0208<<14 | 0x47<<7 | 0x44,
	33978 - 19968: jis0212<<14 | 0x37<<7 | 0x54,
	33979 - 19968: jis0208<<14 | 0x47<<7 | 0x49,
	33980 - 19968: jis0208<<14 | 0x20<<7 | 0x52,
	33981 - 19968: jis0212<<14 | 0x37<<7 | 0x55,
	33982 - 19968: jis0212<<14 | 0x37<<7 | 0x56,
	33983 - 19968: jis0208<<14 | 0x47<<7 | 0x45,
	33984 - 19968: jis0212<<14 | 0x37<<7 | 0x57,
	33985 - 19968: jis0208<<14 | 0x47<<7 | 0x4C,
	33986 - 19968: jis0212<<14 | 0x37<<7 | 0x58,
	33988 - 19968: jis0208<<14 | 0x22<<7 | 0x3E,
	33990 - 19968: jis0208<<14 | 0x47<<7 | 0x4D,
	33991 - 19968: jis0212<<14 | 0x37<<7 | 0x59,
	33992 - 19968: jis0212<<14 | 0x37<<7 | 0x5A,
	33993 - 19968: jis0208<<14 | 0x2C<<7 | 0x35,
	33994 - 19968: jis0208<<14 | 0x47<<7 | 0x42,
	33995 - 19968: jis0208<<14 | 0x12<<7 | 0x17,
	33996 - 19968: jis0212<<14 | 0x37<<7 | 0x5B,
	33997 - 19968: jis0208<<14 | 0x47<<7 | 0x48,
	33999 - 19968: jis0212<<14 | 0x37<<7 | 0x5C,
	34000 - 19968: jis0208<<14 | 0x47<<7 | 0x4B,
	34001 - 19968: jis0208<<14 | 0x2B<<7 | 0x0B,
	34003 - 19968: jis0212<<14 | 0x37<<7 | 0x5D,
	34006 - 19968: jis0208<<14 | 0x47<<7 | 0x4E,
	34009 - 19968: jis0208<<14 | 0x47<<7 | 0x47,
	34010 - 19968: jis0208<<14 | 0x47<<7 | 0x4A,
	34012 - 19968: jis0208<<14 | 0x58<<7 | 0x04,
	34023 - 19968: jis0212<<14 | 0x38<<7 | 0x01,
	34026 - 19968: jis0212<<14 | 0x38<<7 | 0x02,
	34028 - 19968: jis0208<<14 | 0x2A<<7 | 0x08,
	34030 - 19968: jis0208<<14 | 0x2E<<7 | 0x00,
	34031 - 19968: jis0212<<14 | 0x38<<7 | 0x03,
	34032 - 19968: jis0212<<14 | 0x38<<7 | 0x04,
	34033 - 19968: jis0212<<14 | 0x38<<7 | 0x05,
	34034 - 19968: jis0212<<14 | 0x38<<7 | 0x06,
	34036 - 19968: jis0208<<14 | 0x47<<7 | 0x52,
	34039 - 19968: jis0212<<14 | 0x38<<7 | 0x07,
	34042 - 19968: jis0212<<14 | 0x38<<7 | 0x09,
	34043 - 19968: jis0212<<14 | 0x38<<7 | 0x0A,
	34044 - 19968: jis0208<<14 | 0x47<<7 | 0x59,
	34045 - 19968: jis0212<<14 | 0x38<<7 | 0x0B,
	34047 - 19968: jis0208<<14 | 0x47<<7 | 0x51,
	34048 - 19968: jis0208<<14 | 0x1B<<7 | 0x22,
	34050 - 19968: jis0212<<14 | 0x38<<7 | 0x0C,
	34051 - 19968: jis0212<<14 | 0x38<<7 | 0x0D,
	34054 - 19968: jis0208<<14 | 0x47<<7 | 0x30,
	34055 - 19968: jis0212<<14 | 0x38<<7 | 0x0E,
	34060 - 19968: jis0212<<14 | 0x38<<7 | 0x0F,
	34062 - 19968: jis0212<<14 | 0x38<<7 | 0x10,
	34064 - 19968: jis0212<<14 | 0x38<<7 | 0x11,
	34065 - 19968: jis0208<<14 | 0x29<<7 | 0x2D,
	34067 - 19968: jis0208<<14 | 0x2B<<7 | 0x01,
	34068 - 19968: jis0208<<14 | 0x47<<7 | 0x58,
	34069 - 19968: jis0208<<14 | 0x47<<7 | 0x57,
	34071 - 19968: jis0208<<14 | 0x47<<7 | 0x53,
	34072 - 19968: jis0208<<14 | 0x47<<7 | 0x54,
	34074 - 19968: jis0208<<14 | 0x10<<7 | 0x15,
	34076 - 19968: jis0212<<14 | 0x38<<7 | 0x12,
	34078 - 19968: jis0212<<14 | 0x38<<7 | 0x13,
	34079 - 19968: jis0208<<14 | 0x47<<7 | 0x56,
	34081 - 19968: jis0208<<14 | 0x47<<7 | 0x50,
	34082 - 19968: jis0212<<14 | 0x38<<7 | 0x14,
	34083 - 19968: jis0212<<14 | 0x38<<7 | 0x15,
	34084 - 19968: jis0212<<14 | 0x38<<7 | 0x16,
	34085 - 19968: jis0212<<14 | 0x38<<7 | 0x17,
	34086 - 19968: jis0208<<14 | 0x23<<7 | 0x34,
	34087 - 19968: jis0212<<14 | 0x38<<7 | 0x18,
	34090 - 19968: jis0212<<14 | 0x38<<7 | 0x19,
	34091 - 19968: jis0212<<14 | 0x38<<7 | 0x1A,
	34092 - 19968: jis0208<<14 | 0x47<<7 | 0x55,
	34093 - 19968: jis0208<<14 | 0x0F<<7 | 0x5D,
	34095 - 19968: jis0212<<14 | 0x38<<7 | 0x1B,
	34098 - 19968: jis0212<<14 | 0x38<<7 | 0x08,
	34099 - 19968: jis0212<<14 | 0x38<<7 | 0x1C,
	34100 - 19968: jis0212<<14 | 0x38<<7 | 0x1D,
	34101 - 19968: jis0208<<14 | 0x21<<7 | 0x01,
	34102 - 19968: jis0212<<14 | 0x38<<7 | 0x1E,
	34109 - 19968: jis0208<<14 | 0x29<<7 | 0x22,
	34111 - 19968: jis0212<<14 | 0x38<<7 | 0x1F,
	34112 - 19968: jis0208<<14 | 0x47<<7 | 0x5A,
	34113 - 19968: jis0208<<14 | 0x48<<7 | 0x00,
	34115 - 19968: jis0208<<14 | 0x27<<7 | 0x38,
	34118 - 19968: jis0212<<14 | 0x38<<7 | 0x20,
	34120 - 19968: jis0208<<14 | 0x47<<7 | 0x5D,
	34121 - 19968: jis0208<<14 | 0x1D<<7 | 0x35,
	34122 - 19968: jis0208<<14 | 0x1B<<7 | 0x28,
	34123 - 19968: jis0208<<14 | 0x48<<7 | 0x02,
	34126 - 19968: jis0208<<14 | 0x15<<7 | 0x1D,
	34127 - 19968: jis0212<<14 | 0x38<<7 | 0x21,
	34128 - 19968: jis0212<<14 | 0x38<<7 | 0x22,
	34129 - 19968: jis0212<<14 | 0x38<<7 | 0x23,
	34130 - 19968: jis0212<<14 | 0x38<<7 | 0x24,
	34131 - 19968: jis0208<<14 | 0x5A<<7 | 0x3D,
	34133 - 19968: jis0208<<14 | 0x48<<7 | 0x03,
	34134 - 19968: jis0212<<14 | 0x38<<7 | 0x26,
	34135 - 19968: jis0208<<14 | 0x28<<7 | 0x58,
	34136 - 19968: jis0208<<14 | 0x47<<7 | 0x5C,
	34137 - 19968: jis0208<<14 | 0x5A<<7 | 0x3E,
	34138 - 19968: jis0208<<14 | 0x47<<7 | 0x35,
	34140 - 19968: jis0212<<14 | 0x38<<7 | 0x28,
	34141 - 19968: jis0212<<14 | 0x38<<7 | 0x29,
	34142 - 19968: jis0212<<14 | 0x38<<7 | 0x2A,
	34143 - 19968: jis0212<<14 | 0x38<<7 | 0x2B,
	34144 - 19968: jis0212<<14 | 0x38<<7 | 0x2C,
	34145 - 19968: jis0212<<14 | 0x38<<7 | 0x2D,
	34146 - 19968: jis0212<<14 | 0x38<<7 | 0x2E,
	34147 - 19968: jis0208<<14 | 0x47<<7 | 0x5B,
	34148 - 19968: jis0212<<14 | 0x38<<7 | 0x2F,
	34152 - 19968: jis0208<<14 | 0x2E<<7 | 0x2E,
	34153 - 19968: jis0208<<14 | 0x25<<7 | 0x01,
	34154 - 19968: jis0208<<14 | 0x28<<7 | 0x52,
	34155 - 19968: jis0208<<14 | 0x5A<<7 | 0x3F,
	34157 - 19968: jis0208<<14 | 0x48<<7 | 0x0A,
	34159 - 19968: jis0212<<14 | 0x38<<7 | 0x31,
	34167 - 19968: jis0208<<14 | 0x48<<7 | 0x10,
	34169 - 19968: jis0212<<14 | 0x38<<7 | 0x32,
	34170 - 19968: jis0212<<14 | 0x38<<7 | 0x33,
	34171 - 19968: jis0212<<14 | 0x38<<7 | 0x34,
	34173 - 19968: jis0212<<14 | 0x38<<7 | 0x35,
	34174 - 19968: jis0208<<14 | 0x48<<7 | 0x11,
	34175 - 19968: jis0212<<14 | 0x38<<7 | 0x36,
	34176 - 19968: jis0208<<14 | 0x48<<7 | 0x04,
	34177 - 19968: jis0212<<14 | 0x38<<7 | 0x37,
	34180 - 19968: jis0208<<14 | 0x26<<7 | 0x55,
	34181 - 19968: jis0212<<14 | 0x38<<7 | 0x38,
	34182 - 19968: jis0212<<14 | 0x38<<7 | 0x39,
	34183 - 19968: jis0208<<14 | 0x48<<7 | 0x0E,
	34184 - 19968: jis0208<<14 | 0x48<<7 | 0x06,
	34185 - 19968: jis0212<<14 | 0x38<<7 | 0x3A,
	34186 - 19968: jis0208<<14 | 0x48<<7 | 0x08,
	34187 - 19968: jis0212<<14 | 0x38<<7 | 0x3B,
	34188 - 19968: jis0212<<14 | 0x38<<7 | 0x3C,
	34191 - 19968: jis0212<<14 | 0x38<<7 | 0x3D,
	34192 - 19968: jis0208<<14 | 0x48<<7 | 0x12,
	34193 - 19968: jis0208<<14 | 0x48<<7 | 0x07,
	34195 - 19968: jis0212<<14 | 0x38<<7 | 0x3E,
	34196 - 19968: jis0208<<14 | 0x48<<7 | 0x0B,
	34199 - 19968: jis0208<<14 | 0x10<<7 | 0x51,
	34200 - 19968: jis0212<<14 | 0x38<<7 | 0x3F,
	34201 - 19968: jis0208<<14 | 0x25<<7 | 0x44,
	34203 - 19968: jis0208<<14 | 0x48<<7 | 0x0C,
	34204 - 19968: jis0208<<14 | 0x48<<7 | 0x0F,
	34205 - 19968: jis0212<<14 | 0x38<<7 | 0x40,
	34207 - 19968: jis0212<<14 | 0x38<<7 | 0x41,
	34208 - 19968: jis0212<<14 | 0x38<<7 | 0x42,
	34210 - 19968: jis0212<<14 | 0x38<<7 | 0x43,
	34212 - 19968: jis0208<<14 | 0x48<<7 | 0x05,
	34213 - 19968: jis0212<<14 | 0x38<<7 | 0x44,
	34214 - 19968: jis0208<<14 | 0x20<<7 | 0x05,
	34215 - 19968: jis0212<<14 | 0x38<<7 | 0x45,
	34216 - 19968: jis0208<<14 | 0x48<<7 | 0x09,
	34217 - 19968: jis0208<<14 | 0x1A<<7 | 0x06,
	34218 - 19968: jis0208<<14 | 0x1E<<7 | 0x24,
	34219 - 19968: jis0208<<14 | 0x16<<7 | 0x0F,
	34220 - 19968: jis0208<<14 | 0x2B<<7 | 0x53,
	34221 - 19968: jis0212<<14 | 0x38<<7 | 0x53,
	34222 - 19968: jis0208<<14 | 0x2B<<7 | 0x58,
	34223 - 19968: jis0208<<14 | 0x1C<<7 | 0x51,
	34224 - 19968: jis0208<<14 | 0x5A<<7 | 0x41,
	34228 - 19968: jis0212<<14 | 0x38<<7 | 0x46,
	34230 - 19968: jis0212<<14 | 0x38<<7 | 0x47,
	34231 - 19968: jis0212<<14 | 0x38<<7 | 0x48,
	34232 - 19968: jis0212<<14 | 0x38<<7 | 0x49,
	34233 - 19968: jis0208<<14 | 0x48<<7 | 0x16,
	34234 - 19968: jis0208<<14 | 0x48<<7 | 0x14,
	34236 - 19968: jis0212<<14 | 0x38<<7 | 0x4A,
	34237 - 19968: jis0212<<14 | 0x38<<7 | 0x4B,
	34238 - 19968: jis0212<<14 | 0x38<<7 | 0x4C,
	34239 - 19968: jis0212<<14 | 0x38<<7 | 0x4D,
	34241 - 19968: jis0208<<14 | 0x2E<<7 | 0x2D,
	34242 - 19968: jis0212<<14 | 0x38<<7 | 0x4E,
	34247 - 19968: jis0212<<14 | 0x38<<7 | 0x4F,
	34249 - 19968: jis0208<<14 | 0x48<<7 | 0x13,
	34250 - 19968: jis0212<<14 | 0x38<<7 | 0x50,
	34251 - 19968: jis0212<<14 | 0x38<<7 | 0x51,
	34253 - 19968: jis0208<<14 | 0x2C<<7 | 0x54,
	34254 - 19968: jis0212<<14 | 0x38<<7 | 0x52,
	34255 - 19968: jis0208<<14 | 0x48<<7 | 0x15,
	34256 - 19968: jis0208<<14 | 0x48<<7 | 0x17,
	34261 - 19968: jis0208<<14 | 0x48<<7 | 0x18,
	34264 - 19968: jis0212<<14 | 0x38<<7 | 0x54,
	34266 - 19968: jis0212<<14 | 0x38<<7 | 0x55,
	34268 - 19968: jis0208<<14 | 0x48<<7 | 0x1B,
	34269 - 19968: jis0208<<14 | 0x48<<7 | 0x19,
	34271 - 19968: jis0212<<14 | 0x38<<7 | 0x56,
	34272 - 19968: jis0212<<14 | 0x38<<7 | 0x57,
	34276 - 19968: jis0208<<14 | 0x25<<7 | 0x02,
	34277 - 19968: jis0208<<14 | 0x48<<7 | 0x1A,
	34278 - 19968: jis0212<<14 | 0x38<<7 | 0x58,
	34280 - 19968: jis0212<<14 | 0x38<<7 | 0x59,
	34281 - 19968: jis0208<<14 | 0x27<<7 | 0x2C,
	34282 - 19968: jis0208<<14 | 0x48<<7 | 0x0D,
	34285 - 19968: jis0212<<14 | 0x38<<7 | 0x5A,
	34291 - 19968: jis0212<<14 | 0x38<<7 | 0x5B,
	34294 - 19968: jis0212<<14 | 0x38<<7 | 0x5C,
	34295 - 19968: jis0208<<14 | 0x1C<<7 | 0x52,
	34297 - 19968: jis0208<<14 | 0x48<<7 | 0x1C,
	34298 - 19968: jis0208<<14 | 0x48<<7 | 0x21,
	34299 - 19968: jis0208<<14 | 0x20<<7 | 0x53,
	34300 - 19968: jis0212<<14 | 0x38<<7 | 0x5D,
	34302 - 19968: jis0208<<14 | 0x48<<7 | 0x20,
	34303 - 19968: jis0212<<14 | 0x39<<7 | 0x00,
	34304 - 19968: jis0212<<14 | 0x39<<7 | 0x01,
	34306 - 19968: jis0208<<14 | 0x48<<7 | 0x01,
	34308 - 19968: jis0212<<14 | 0x39<<7 | 0x02,
	34309 - 19968: jis0212<<14 | 0x39<<7 | 0x03,
	34310 - 19968: jis0208<<14 | 0x48<<7 | 0x22,
	34311 - 19968: jis0208<<14 | 0x20<<7 | 0x28,
	34314 - 19968: jis0208<<14 | 0x48<<7 | 0x1D,
	34315 - 19968: jis0208<<14 | 0x48<<7 | 0x1F,
	34317 - 19968: jis0212<<14 | 0x39<<7 | 0x04,
	34318 - 19968: jis0212<<14 | 0x39<<7 | 0x05,
	34320 - 19968: jis0212<<14 | 0x39<<7 | 0x06,
	34321 - 19968: jis0212<<14 | 0x39<<7 | 0x07,
	34322 - 19968: jis0212<<14 | 0x39<<7 | 0x08,
	34323 - 19968: jis0208<<14 | 0x48<<7 | 0x1E,
	34326 - 19968: jis0208<<14 | 0x3C<<7 | 0x10,
	34327 - 19968: jis0208<<14 | 0x3C<<7 | 0x01,
	34328 - 19968: jis0212<<14 | 0x39<<7 | 0x09,
	34329 - 19968: jis0212<<14 | 0x39<<7 | 0x0A,
	34330 - 19968: jis0208<<14 | 0x48<<7 | 0x24,
	34331 - 19968: jis0212<<14 | 0x39<<7 | 0x0B,
	34334 - 19968: jis0212<<14 | 0x39<<7 | 0x0C,
	34337 - 19968: jis0212<<14 | 0x39<<7 | 0x0D,
	34338 - 19968: jis0208<<14 | 0x48<<7 | 0x23,
	34343 - 19968: jis0212<<14 | 0x39<<7 | 0x0E,
	34345 - 19968: jis0212<<14 | 0x39<<7 | 0x0F,
	34349 - 19968: jis0208<<14 | 0x2C<<7 | 0x55,
	34351 - 19968: jis0208<<14 | 0x41<<7 | 0x1B,
	34352 - 19968: jis0208<<14 | 0x48<<7 | 0x25,
	34358 - 19968: jis0212<<14 | 0x39<<7 | 0x10,
	34360 - 19968: jis0212<<14 | 0x39<<7 | 0x11,
	34362 - 19968: jis0212<<14 | 0x39<<7 | 0x12,
	34364 - 19968: jis0212<<14 | 0x39<<7 | 0x13,
	34365 - 19968: jis0212<<14 | 0x39<<7 | 0x14,
	34367 - 19968: jis0208<<14 | 0x48<<7 | 0x26,
	34368 - 19968: jis0212<<14 | 0x39<<7 | 0x15,
	34369 - 19968: jis0212<<14 | 0x17<<7 | 0x45,
	34370 - 19968: jis0212<<14 | 0x39<<7 | 0x16,
	34374 - 19968: jis0212<<14 | 0x39<<7 | 0x17,
	34381 - 19968: jis0208<<14 | 0x48<<7 | 0x27,
	34382 - 19968: jis0208<<14 | 0x17<<7 | 0x36,
	34384 - 19968: jis0208<<14 | 0x14<<7 | 0x33,
	34386 - 19968: jis0212<<14 | 0x39<<7 | 0x18,
	34387 - 19968: jis0212<<14 | 0x39<<7 | 0x19,
	34388 - 19968: jis0208<<14 | 0x48<<7 | 0x29,
	34389 - 19968: jis0208<<14 | 0x30<<7 | 0x3C,
	34390 - 19968: jis0212<<14 | 0x39<<7 | 0x1A,
	34391 - 19968: jis0212<<14 | 0x39<<7 | 0x1B,
	34392 - 19968: jis0212<<14 | 0x39<<7 | 0x1C,
	34393 - 19968: jis0212<<14 | 0x39<<7 | 0x1D,
	34394 - 19968: jis0208<<14 | 0x14<<7 | 0x54,
	34396 - 19968: jis0208<<14 | 0x2D<<7 | 0x19,
	34397 - 19968: jis0212<<14 | 0x39<<7 | 0x1E,
	34398 - 19968: jis0208<<14 | 0x15<<7 | 0x52,
	34399 - 19968: jis0208<<14 | 0x48<<7 | 0x2A,
	34400 - 19968: jis0212<<14 | 0x39<<7 | 0x1F,
	34401 - 19968: jis0212<<14 | 0x39<<7 | 0x20,
	34402 - 19968: jis0212<<14 | 0x39<<7 | 0x21,
	34403 - 19968: jis0212<<14 | 0x39<<7 | 0x22,
	34404 - 19968: jis0212<<14 | 0x39<<7 | 0x23,
	34407 - 19968: jis0208<<14 | 0x48<<7 | 0x2B,
	34409 - 19968: jis0212<<14 | 0x39<<7 | 0x24,
	34411 - 19968: jis0208<<14 | 0x22<<7 | 0x4D,
	34412 - 19968: jis0212<<14 | 0x39<<7 | 0x25,
	34415 - 19968: jis0212<<14 | 0x39<<7 | 0x26,
	34417 - 19968: jis0208<<14 | 0x48<<7 | 0x2C,
	34421 - 19968: jis0212<<14 | 0x39<<7 | 0x27,
	34422 - 19968: jis0212<<14 | 0x39<<7 | 0x28,
	34423 - 19968: jis0212<<14 | 0x39<<7 | 0x29,
	34425 - 19968: jis0208<<14 | 0x25<<7 | 0x59,
	34426 - 19968: jis0212<<14 | 0x39<<7 | 0x2A,
	34427 - 19968: jis0208<<14 | 0x0F<<7 | 0x19,
	34440 - 19968: jis0212<<14 | 0x39<<7 | 0x4C,
	34442 - 19968: jis0208<<14 | 0x11<<7 | 0x42,
	34443 - 19968: jis0208<<14 | 0x48<<7 | 0x31,
	34444 - 19968: jis0208<<14 | 0x48<<7 | 0x32,
	34445 - 19968: jis0212<<14 | 0x39<<7 | 0x2B,
	34449 - 19968: jis0212<<14 | 0x39<<7 | 0x2C,
	34451 - 19968: jis0208<<14 | 0x48<<7 | 0x2D,
	34453 - 19968: jis0208<<14 | 0x1A<<7 | 0x1C,
	34454 - 19968: jis0212<<14 | 0x39<<7 | 0x2D,
	34456 - 19968: jis0212<<14 | 0x39<<7 | 0x2E,
	34458 - 19968: jis0212<<14 | 0x39<<7 | 0x2F,
	34460 - 19968: jis0212<<14 | 0x39<<7 | 0x30,
	34465 - 19968: jis0212<<14 | 0x39<<7 | 0x31,
	34467 - 19968: jis0208<<14 | 0x48<<7 | 0x2E,
	34468 - 19968: jis0208<<14 | 0x26<<7 | 0x21,
	34470 - 19968: jis0212<<14 | 0x39<<7 | 0x32,
	34471 - 19968: jis0212<<14 | 0x39<<7 | 0x33,
	34472 - 19968: jis0212<<14 | 0x39<<7 | 0x34,
	34473 - 19968: jis0208<<14 | 0x48<<7 | 0x2F,
	34474 - 19968: jis0208<<14 | 0x48<<7 | 0x30,
	34475 - 19968: jis0208<<14 | 0x48<<7 | 0x3A,
	34477 - 19968: jis0212<<14 | 0x39<<7 | 0x35,
	34479 - 19968: jis0208<<14 | 0x48<<7 | 0x34,
	34480 - 19968: jis0208<<14 | 0x48<<7 | 0x37,
	34481 - 19968: jis0212<<14 | 0x39<<7 | 0x36,
	34483 - 19968: jis0212<<14 | 0x39<<7 | 0x37,
	34484 - 19968: jis0212<<14 | 0x39<<7 | 0x38,
	34485 - 19968: jis0212<<14 | 0x39<<7 | 0x39,
	34486 - 19968: jis0208<<14 | 0x48<<7 | 0x33,
	34487 - 19968: jis0212<<14 | 0x39<<7 | 0x3A,
	34488 - 19968: jis0212<<14 | 0x39<<7 | 0x3B,
	34489 - 19968: jis0212<<14 | 0x39<<7 | 0x3C,
	34495 - 19968: jis0212<<14 | 0x39<<7 | 0x3D,
	34496 - 19968: jis0212<<14 | 0x39<<7 | 0x3E,
	34497 - 19968: jis0212<<14 | 0x39<<7 | 0x3F,
	34499 - 19968: jis0212<<14 | 0x39<<7 | 0x40,
	34500 - 19968: jis0208<<14 | 0x48<<7 | 0x35,
	34501 - 19968: jis0212<<14 | 0x39<<7 | 0x41,
	34502 - 19968: jis0208<<14 | 0x48<<7 | 0x36,
	34503 - 19968: jis0208<<14 | 0x1B<<7 | 0x37,
	34505 - 19968: jis0208<<14 | 0x48<<7 | 0x38,
	34507 - 19968: jis0208<<14 | 0x22<<7 | 0x20,
	34509 - 19968: jis0208<<14 | 0x16<<7 | 0x35,
	34510 - 19968: jis0208<<14 | 0x12<<7 | 0x21,
	34513 - 19968: jis0212<<14 | 0x39<<7 | 0x42,
	34514 - 19968: jis0212<<14 | 0x39<<7 | 0x43,
	34516 - 19968: jis0208<<14 | 0x48<<7 | 0x3B,
	34517 - 19968: jis0212<<14 | 0x39<<7 | 0x44,
	34519 - 19968: jis0212<<14 | 0x39<<7 | 0x45,
	34521 - 19968: jis0208<<14 | 0x12<<7 | 0x1E,
	34522 - 19968: jis0212<<14 | 0x39<<7 | 0x46,
	34523 - 19968: jis0208<<14 | 0x48<<7 | 0x40,
	34524 - 19968: jis0212<<14 | 0x39<<7 | 0x47,
	34526 - 19968: jis0208<<14 | 0x48<<7 | 0x3C,
	34527 - 19968: jis0208<<14 | 0x48<<7 | 0x3F,
	34528 - 19968: jis0212<<14 | 0x39<<7 | 0x48,
	34531 - 19968: jis0212<<14 | 0x39<<7 | 0x49,
	34532 - 19968: jis0208<<14 | 0x27<<7 | 0x19,
	34533 - 19968: jis0212<<14 | 0x39<<7 | 0x4A,
	34535 - 19968: jis0212<<14 | 0x39<<7 | 0x4B,
	34537 - 19968: jis0208<<14 | 0x48<<7 | 0x3D,
	34540 - 19968: jis0208<<14 | 0x48<<7 | 0x3E,
	34541 - 19968: jis0208<<14 | 0x28<<7 | 0x27,
	34542 - 19968: jis0208<<14 | 0x27<<7 | 0x39,
	34543 - 19968: jis0208<<14 | 0x48<<7 | 0x41,
	34552 - 19968: jis0208<<14 | 0x21<<7 | 0x5C,
	34553 - 19968: jis0208<<14 | 0x48<<7 | 0x4B,
	34554 - 19968: jis0212<<14 | 0x39<<7 | 0x4D,
	34555 - 19968: jis0208<<14 | 0x48<<7 | 0x47,
	34556 - 19968: jis0212<<14 | 0x39<<7 | 0x4E,
	34557 - 19968: jis0212<<14 | 0x39<<7 | 0x4F,
	34558 - 19968: jis0208<<14 | 0x11<<7 | 0x4A,
	34560 - 19968: jis0208<<14 | 0x48<<7 | 0x45,
	34562 - 19968: jis0208<<14 | 0x2A<<7 | 0x09,
	34563 - 19968: jis0208<<14 | 0x48<<7 | 0x46,
	34564 - 19968: jis0212<<14 | 0x39<<7 | 0x50,
	34565 - 19968: jis0212<<14 | 0x39<<7 | 0x51,
	34566 - 19968: jis0208<<14 | 0x48<<7 | 0x43,
	34567 - 19968: jis0212<<14 | 0x39<<7 | 0x52,
	34568 - 19968: jis0208<<14 | 0x48<<7 | 0x44,
	34569 - 19968: jis0208<<14 | 0x48<<7 | 0x49,
	34570 - 19968: jis0208<<14 | 0x48<<7 | 0x4C,
	34571 - 19968: jis0212<<14 | 0x39<<7 | 0x53,
	34573 - 19968: jis0208<<14 | 0x48<<7 | 0x4A,
	34574 - 19968: jis0212<<14 | 0x39<<7 | 0x54,
	34575 - 19968: jis0212<<14 | 0x39<<7 | 0x55,
	34576 - 19968: jis0212<<14 | 0x39<<7 | 0x56,
	34577 - 19968: jis0208<<14 | 0x48<<7 | 0x48,
	34578 - 19968: jis0208<<14 | 0x48<<7 | 0x42,
	34579 - 19968: jis0212<<14 | 0x39<<7 | 0x57,
	34580 - 19968: jis0212<<14 | 0x39<<7 | 0x58,
	34584 - 19968: jis0208<<14 | 0x22<<7 | 0x37,
	34585 - 19968: jis0212<<14 | 0x39<<7 | 0x59,
	34586 - 19968: jis0208<<14 | 0x48<<7 | 0x53,
	34588 - 19968: jis0208<<14 | 0x2B<<7 | 0x09,
	34590 - 19968: jis0212<<14 | 0x39<<7 | 0x5A,
	34591 - 19968: jis0212<<14 | 0x39<<7 | 0x5B,
	34593 - 19968: jis0212<<14 | 0x39<<7 | 0x5C,
	34595 - 19968: jis0212<<14 | 0x39<<7 | 0x5D,
	34597 - 19968: jis0208<<14 | 0x48<<7 | 0x51,
	34600 - 19968: jis0212<<14 | 0x3A<<7 | 0x00,
	34601 - 19968: jis0208<<14 | 0x48<<7 | 0x52,
	34606 - 19968: jis0212<<14 | 0x3A<<7 | 0x01,
	34607 - 19968: jis0212<<14 | 0x3A<<7 | 0x02,
	34609 - 19968: jis0212<<14 | 0x3A<<7 | 0x03,
	34610 - 19968: jis0212<<14 | 0x3A<<7 | 0x04,
	34612 - 19968: jis0208<<14 | 0x48<<7 | 0x4D,
	34615 - 19968: jis0208<<14 | 0x48<<7 | 0x4F,
	34617 - 19968: jis0212<<14 | 0x3A<<7 | 0x05,
	34618 - 19968: jis0212<<14 | 0x3A<<7 | 0x06,
	34619 - 19968: jis0208<<14 | 0x48<<7 | 0x50,
	34620 - 19968: jis0212<<14 | 0x3A<<7 | 0x07,
	34621 - 19968: jis0212<<14 | 0x3A<<7 | 0x08,
	34622 - 19968: jis0212<<14 | 0x3A<<7 | 0x09,
	34623 - 19968: jis0208<<14 | 0x48<<7 | 0x4E,
	34624 - 19968: jis0212<<14 | 0x3A<<7 | 0x0A,
	34627 - 19968: jis0212<<14 | 0x3A<<7 | 0x0B,
	34629 - 19968: jis0212<<14 | 0x3A<<7 | 0x0C,
	34633 - 19968: jis0208<<14 | 0x1F<<7 | 0x45,
	34635 - 19968: jis0208<<14 | 0x2E<<7 | 0x18,
	34636 - 19968: jis0208<<14 | 0x48<<7 | 0x57,
	34637 - 19968: jis0212<<14 | 0x3A<<7 | 0x0D,
	34638 - 19968: jis0208<<14 | 0x48<<7 | 0x58,
	34643 - 19968: jis0208<<14 | 0x49<<7 | 0x00,
	34645 - 19968: jis0208<<14 | 0x1E<<7 | 0x09,
	34647 - 19968: jis0208<<14 | 0x48<<7 | 0x5A,
	34648 - 19968: jis0212<<14 | 0x3A<<7 | 0x0E,
	34649 - 19968: jis0208<<14 | 0x48<<7 | 0x5D,
	34653 - 19968: jis0212<<14 | 0x3A<<7 | 0x0F,
	34655 - 19968: jis0208<<14 | 0x48<<7 | 0x55,
	34656 - 19968: jis0208<<14 | 0x48<<7 | 0x54,
	34657 - 19968: jis0212<<14 | 0x3A<<7 | 0x10,
	34659 - 19968: jis0208<<14 | 0x49<<7 | 0x01,
	34660 - 19968: jis0212<<14 | 0x3A<<7 | 0x11,
	34661 - 19968: jis0212<<14 | 0x3A<<7 | 0x12,
	34662 - 19968: jis0208<<14 | 0x11<<7 | 0x3B,
	34664 - 19968: jis0208<<14 | 0x48<<7 | 0x5B,
	34666 - 19968: jis0208<<14 | 0x49<<7 | 0x02,
	34670 - 19968: jis0208<<14 | 0x48<<7 | 0x5C,
	34671 - 19968: jis0212<<14 | 0x3A<<7 | 0x13,
	34673 - 19968: jis0212<<14 | 0x3A<<7 | 0x14,
	34674 - 19968: jis0212<<14 | 0x3A<<7 | 0x15,
	34676 - 19968: jis0208<<14 | 0x48<<7 | 0x59,
	34678 - 19968: jis0208<<14 | 0x23<<7 | 0x12,
	34680 - 19968: jis0208<<14 | 0x48<<7 | 0x56,
	34683 - 19968: jis0212<<14 | 0x3A<<7 | 0x16,
	34687 - 19968: jis0208<<14 | 0x26<<7 | 0x47,
	34690 - 19968: jis0208<<14 | 0x49<<7 | 0x06,
	34691 - 19968: jis0212<<14 | 0x3A<<7 | 0x17,
	34692 - 19968: jis0212<<14 | 0x3A<<7 | 0x18,
	34693 - 19968: jis0212<<14 | 0x3A<<7 | 0x19,
	34694 - 19968: jis0212<<14 | 0x3A<<7 | 0x1A,
	34695 - 19968: jis0212<<14 | 0x3A<<7 | 0x1B,
	34696 - 19968: jis0212<<14 | 0x3A<<7 | 0x1C,
	34697 - 19968: jis0212<<14 | 0x3A<<7 | 0x1D,
	34699 - 19968: jis0212<<14 | 0x3A<<7 | 0x1E,
	34700 - 19968: jis0212<<14 | 0x3A<<7 | 0x1F,
	34701 - 19968: jis0208<<14 | 0x2C<<7 | 0x1A,
	34704 - 19968: jis0212<<14 | 0x3A<<7 | 0x20,
	34707 - 19968: jis0212<<14 | 0x3A<<7 | 0x21,
	34709 - 19968: jis0212<<14 | 0x3A<<7 | 0x22,
	34711 - 19968: jis0212<<14 | 0x3A<<7 | 0x23,
	34712 - 19968: jis0212<<14 | 0x3A<<7 | 0x24,
	34713 - 19968: jis0212<<14 | 0x3A<<7 | 0x25,
	34718 - 19968: jis0212<<14 | 0x3A<<7 | 0x26,
	34719 - 19968: jis0208<<14 | 0x49<<7 | 0x05,
	34720 - 19968: jis0212<<14 | 0x3A<<7 | 0x27,
	34722 - 19968: jis0208<<14 | 0x49<<7 | 0x04,
	34723 - 19968: jis0212<<14 | 0x3A<<7 | 0x28,
	34727 - 19968: jis0212<<14 | 0x3A<<7 | 0x29,
	34731 - 19968: jis0208<<14 | 0x49<<7 | 0x0D,
	34732 - 19968: jis0212<<14 | 0x3A<<7 | 0x2A,
	34733 - 19968: jis0212<<14 | 0x3A<<7 | 0x2B,
	34734 - 19968: jis0212<<14 | 0x3A<<7 | 0x2C,
	34735 - 19968: jis0208<<14 | 0x49<<7 | 0x07,
	34737 - 19968: jis0212<<14 | 0x3A<<7 | 0x2D,
	34739 - 19968: jis0208<<14 | 0x49<<7 | 0x0F,
	34741 - 19968: jis0212<<14 | 0x3A<<7 | 0x2E,
	34746 - 19968: jis0208<<14 | 0x2C<<7 | 0x45,
	34747 - 19968: jis0208<<14 | 0x49<<7 | 0x12,
	34749 - 19968: jis0208<<14 | 0x49<<7 | 0x09,
	34750 - 19968: jis0212<<14 | 0x3A<<7 | 0x2F,
	34751 - 19968: jis0212<<14 | 0x3A<<7 | 0x30,
	34752 - 19968: jis0208<<14 | 0x49<<7 | 0x0A,
	34753 - 19968: jis0212<<14 | 0x3A<<7 | 0x31,
	34756 - 19968: jis0208<<14 | 0x49<<7 | 0x0E,
	34758 - 19968: jis0208<<14 | 0x49<<7 | 0x11,
	34759 - 19968: jis0208<<14 | 0x49<<7 | 0x10,
	34760 - 19968: jis0212<<14 | 0x3A<<7 | 0x32,
	34761 - 19968: jis0212<<14 | 0x3A<<7 | 0x33,
	34762 - 19968: jis0212<<14 | 0x3A<<7 | 0x34,
	34763 - 19968: jis0208<<14 | 0x49<<7 | 0x08,
	34766 - 19968: jis0212<<14 | 0x3A<<7 | 0x35,
	34768 - 19968: jis0208<<14 | 0x49<<7 | 0x0B,
	34770 - 19968: jis0208<<14 | 0x49<<7 | 0x1C,
	34773 - 19968: jis0212<<14 | 0x3A<<7 | 0x36,
	34774 - 19968: jis0212<<14 | 0x3A<<7 | 0x37,
	34777 - 19968: jis0212<<14 | 0x3A<<7 | 0x38,
	34778 - 19968: jis0212<<14 | 0x3A<<7 | 0x39,
	34780 - 19968: jis0212<<14 | 0x3A<<7 | 0x3A,
	34783 - 19968: jis0212<<14 | 0x3A<<7 | 0x3B,
	34784 - 19968: jis0208<<14 | 0x49<<7 | 0x15,
	34786 - 19968: jis0212<<14 | 0x3A<<7 | 0x3C,
	34787 - 19968: jis0212<<14 | 0x3A<<7 | 0x3D,
	34788 - 19968: jis0212<<14 | 0x3A<<7 | 0x3E,
	34794 - 19968: jis0212<<14 | 0x3A<<7 | 0x3F,
	34795 - 19968: jis0212<<14 | 0x3A<<7 | 0x40,
	34797 - 19968: jis0212<<14 | 0x3A<<7 | 0x41,
	34799 - 19968: jis0208<<14 | 0x49<<7 | 0x13,
	34801 - 19968: jis0212<<14 | 0x3A<<7 | 0x42,
	34802 - 19968: jis0208<<14 | 0x49<<7 | 0x14,
	34803 - 19968: jis0212<<14 | 0x3A<<7 | 0x43,
	34806 - 19968: jis0208<<14 | 0x49<<7 | 0x19,
	34807 - 19968: jis0208<<14 | 0x49<<7 | 0x1A,
	34808 - 19968: jis0212<<14 | 0x3A<<7 | 0x44,
	34809 - 19968: jis0208<<14 | 0x12<<7 | 0x09,
	34810 - 19968: jis0212<<14 | 0x3A<<7 | 0x45,
	34811 - 19968: jis0208<<14 | 0x14<<7 | 0x21,
	34814 - 19968: jis0208<<14 | 0x49<<7 | 0x18,
	34815 - 19968: jis0212<<14 | 0x3A<<7 | 0x46,
	34817 - 19968: jis0212<<14 | 0x3A<<7 | 0x47,
	34819 - 19968: jis0212<<14 | 0x3A<<7 | 0x48,
	34821 - 19968: jis0208<<14 | 0x49<<7 | 0x03,
	34822 - 19968: jis0212<<14 | 0x3A<<7 | 0x49,
	34823 - 19968: jis0208<<14 | 0x5A<<7 | 0x44,
	34825 - 19968: jis0212<<14 | 0x3A<<7 | 0x4A,
	34826 - 19968: jis0212<<14 | 0x3A<<7 | 0x4B,
	34827 - 19968: jis0212<<14 | 0x3A<<7 | 0x4C,
	34829 - 19968: jis0208<<14 | 0x49<<7 | 0x17,
	34830 - 19968: jis0208<<14 | 0x49<<7 | 0x1B,
	34831 - 19968: jis0208<<14 | 0x49<<7 | 0x16,
	34832 - 19968: jis0212<<14 | 0x3A<<7 | 0x4D,
	34833 - 19968: jis0208<<14 | 0x49<<7 | 0x1D,
	34834 - 19968: jis0212<<14 | 0x3A<<7 | 0x4F,
	34835 - 19968: jis0212<<14 | 0x3A<<7 | 0x50,
	34836 - 19968: jis0212<<14 | 0x3A<<7 | 0x51,
	34837 - 19968: jis0208<<14 | 0x49<<7 | 0x1F,
	34838 - 19968: jis0208<<14 | 0x49<<7 | 0x1E,
	34840 - 19968: jis0212<<14 | 0x3A<<7 | 0x52,
	34841 - 19968: jis0212<<14 | 0x3A<<7 | 0x4E,
	34842 - 19968: jis0212<<14 | 0x3A<<7 | 0x53,
	34843 - 19968: jis0212<<14 | 0x3A<<7 | 0x54,
	34844 - 19968: jis0212<<14 | 0x3A<<7 | 0x55,
	34846 - 19968: jis0212<<14 | 0x3A<<7 | 0x56,
	34847 - 19968: jis0212<<14 | 0x3A<<7 | 0x57,
	34849 - 19968: jis0208<<14 | 0x49<<7 | 0x21,
	34850 - 19968: jis0208<<14 | 0x49<<7 | 0x20,
	34851 - 19968: jis0208<<14 | 0x48<<7 | 0x39,
	34855 - 19968: jis0208<<14 | 0x49<<7 | 0x25,
	34856 - 19968: jis0212<<14 | 0x3A<<7 | 0x58,
	34861 - 19968: jis0212<<14 | 0x3A<<7 | 0x59,
	34862 - 19968: jis0212<<14 | 0x3A<<7 | 0x5A,
	34864 - 19968: jis0212<<14 | 0x3A<<7 | 0x5B,
	34865 - 19968: jis0208<<14 | 0x49<<7 | 0x22,
	34866 - 19968: jis0212<<14 | 0x3A<<7 | 0x5C,
	34869 - 19968: jis0212<<14 | 0x3A<<7 | 0x5D,
	34870 - 19968: jis0208<<14 | 0x49<<7 | 0x23,
	34873 - 19968: jis0208<<14 | 0x49<<7 | 0x24,
	34874 - 19968: jis0212<<14 | 0x3B<<7 | 0x00,
	34875 - 19968: jis0208<<14 | 0x49<<7 | 0x26,
	34876 - 19968: jis0212<<14 | 0x3B<<7 | 0x01,
	34880 - 19968: jis0208<<14 | 0x16<<7 | 0x4B,
	34881 - 19968: jis0212<<14 | 0x3B<<7 | 0x02,
	34882 - 19968: jis0208<<14 | 0x49<<7 | 0x28,
	34883 - 19968: jis0212<<14 | 0x3B<<7 | 0x03,
	34884 - 19968: jis0208<<14 | 0x49<<7 | 0x27,
	34885 - 19968: jis0212<<14 | 0x3B<<7 | 0x04,
	34886 - 19968: jis0208<<14 | 0x1C<<7 | 0x0F,
	34888 - 19968: jis0212<<14 | 0x3B<<7 | 0x05,
	34889 - 19968: jis0212<<14 | 0x3B<<7 | 0x06,
	34890 - 19968: jis0212<<14 | 0x3B<<7 | 0x07,
	34891 - 19968: jis0212<<14 | 0x3B<<7 | 0x08,
	34892 - 19968: jis0208<<14 | 0x18<<7 | 0x33,
	34893 - 19968: jis0208<<14 | 0x3D<<7 | 0x06,
	34894 - 19968: jis0212<<14 | 0x3B<<7 | 0x09,
	34897 - 19968: jis0212<<14 | 0x3B<<7 | 0x0A,
	34898 - 19968: jis0208<<14 | 0x49<<7 | 0x29,
	34899 - 19968: jis0208<<14 | 0x1C<<7 | 0x30,
	34901 - 19968: jis0212<<14 | 0x3B<<7 | 0x0B,
	34902 - 19968: jis0212<<14 | 0x3B<<7 | 0x0C,
	34903 - 19968: jis0208<<14 | 0x12<<7 | 0x18,
	34904 - 19968: jis0212<<14 | 0x3B<<7 | 0x0D,
	34905 - 19968: jis0208<<14 | 0x49<<7 | 0x2A,
	34906 - 19968: jis0212<<14 | 0x3B<<7 | 0x0E,
	34907 - 19968: jis0208<<14 | 0x10<<7 | 0x31,
	34908 - 19968: jis0212<<14 | 0x3B<<7 | 0x0F,
	34909 - 19968: jis0208<<14 | 0x1D<<7 | 0x36,
	34910 - 19968: jis0208<<14 | 0x49<<7 | 0x2B,
	34911 - 19968: jis0212<<14 | 0x3B<<7 | 0x10,
	34912 - 19968: jis0212<<14 | 0x3B<<7 | 0x11,
	34913 - 19968: jis0208<<14 | 0x18<<7 | 0x34,
	34914 - 19968: jis0208<<14 | 0x49<<7 | 0x2C,
	34915 - 19968: jis0208<<14 | 0x0F<<7 | 0x40,
	34916 - 19968: jis0212<<14 | 0x3B<<7 | 0x12,
	34920 - 19968: jis0208<<14 | 0x28<<7 | 0x1C,
	34921 - 19968: jis0212<<14 | 0x3B<<7 | 0x13,
	34923 - 19968: jis0208<<14 | 0x49<<7 | 0x2D,
	34928 - 19968: jis0208<<14 | 0x1E<<7 | 0x49,
	34929 - 19968: jis0212<<14 | 0x3B<<7 | 0x14,
	34930 - 19968: jis0208<<14 | 0x49<<7 | 0x34,
	34933 - 19968: jis0208<<14 | 0x49<<7 | 0x31,
	34935 - 19968: jis0208<<14 | 0x22<<7 | 0x4E,
	34937 - 19968: jis0212<<14 | 0x3B<<7 | 0x15,
	34939 - 19968: jis0212<<14 | 0x3B<<7 | 0x16,
	34941 - 19968: jis0208<<14 | 0x49<<7 | 0x32,
	34942 - 19968: jis0208<<14 | 0x49<<7 | 0x2F,
	34943 - 19968: jis0208<<14 | 0x15<<7 | 0x3D,
	34944 - 19968: jis0212<<14 | 0x3B<<7 | 0x17,
	34945 - 19968: jis0208<<14 | 0x49<<7 | 0x2E,
	34946 - 19968: jis0208<<14 | 0x49<<7 | 0x35,
	34952 - 19968: jis0208<<14 | 0x16<<7 | 0x15,
	34955 - 19968: jis0208<<14 | 0x21<<7 | 0x3D,
	34957 - 19968: jis0208<<14 | 0x49<<7 | 0x3B,
	34962 - 19968: jis0208<<14 | 0x49<<7 | 0x37,
	34966 - 19968: jis0208<<14 | 0x21<<7 | 0x14,
	34967 - 19968: jis0208<<14 | 0x49<<7 | 0x36,
	34968 - 19968: jis0212<<14 | 0x3B<<7 | 0x18,
	34969 - 19968: jis0208<<14 | 0x49<<7 | 0x39,
	34970 - 19968: jis0212<<14 | 0x3B<<7 | 0x19,
	34971 - 19968: jis0212<<14 | 0x3B<<7 | 0x1A,
	34972 - 19968: jis0212<<14 | 0x3B<<7 | 0x1B,
	34974 - 19968: jis0208<<14 | 0x49<<7 | 0x30,
	34975 - 19968: jis0212<<14 | 0x3B<<7 | 0x1C,
	34976 - 19968: jis0212<<14 | 0x3B<<7 | 0x1D,
	34978 - 19968: jis0208<<14 | 0x49<<7 | 0x3A,
	34980 - 19968: jis0208<<14 | 0x49<<7 | 0x3C,
	34984 - 19968: jis0212<<14 | 0x3B<<7 | 0x1E,
	34986 - 19968: jis0212<<14 | 0x3B<<7 | 0x1F,
	34987 - 19968: jis0208<<14 | 0x27<<7 | 0x4E,
	34990 - 19968: jis0208<<14 | 0x49<<7 | 0x38,
	34992 - 19968: jis0208<<14 | 0x49<<7 | 0x3D,
	34993 - 19968: jis0208<<14 | 0x49<<7 | 0x3F,
	34996 - 19968: jis0208<<14 | 0x17<<7 | 0x32,
	34997 - 19968: jis0208<<14 | 0x49<<7 | 0x33,
	34999 - 19968: jis0208<<14 | 0x0F<<7 | 0x20,
	35002 - 19968: jis0212<<14 | 0x3B<<7 | 0x20,
	35005 - 19968: jis0212<<14 | 0x3B<<7 | 0x21,
	35006 - 19968: jis0212<<14 | 0x3B<<7 | 0x22,
	35007 - 19968: jis0208<<14 | 0x49<<7 | 0x3E,
	35008 - 19968: jis0212<<14 | 0x3B<<7 | 0x23,
	35009 - 19968: jis0208<<14 | 0x19<<7 | 0x3A,
	35010 - 19968: jis0208<<14 | 0x2D<<7 | 0x55,
	35011 - 19968: jis0208<<14 | 0x49<<7 | 0x40,
	35012 - 19968: jis0208<<14 | 0x49<<7 | 0x41,
	35013 - 19968: jis0208<<14 | 0x20<<7 | 0x54,
	35018 - 19968: jis0212<<14 | 0x3B<<7 | 0x24,
	35019 - 19968: jis0212<<14 | 0x3B<<7 | 0x25,
	35020 - 19968: jis0212<<14 | 0x3B<<7 | 0x26,
	35021 - 19968: jis0212<<14 | 0x3B<<7 | 0x27,
	35022 - 19968: jis0212<<14 | 0x3B<<7 | 0x28,
	35023 - 19968: jis0208<<14 | 0x2D<<7 | 0x01,
	35025 - 19968: jis0212<<14 | 0x3B<<7 | 0x29,
	35026 - 19968: jis0212<<14 | 0x3B<<7 | 0x2A,
	35027 - 19968: jis0212<<14 | 0x3B<<7 | 0x2B,
	35028 - 19968: jis0208<<14 | 0x49<<7 | 0x42,
	35029 - 19968: jis0208<<14 | 0x2C<<7 | 0x14,
	35032 - 19968: jis0208<<14 | 0x49<<7 | 0x43,
	35033 - 19968: jis0208<<14 | 0x49<<7 | 0x44,
	35035 - 19968: jis0212<<14 | 0x3B<<7 | 0x2C,
	35036 - 19968: jis0208<<14 | 0x29<<7 | 0x43,
	35037 - 19968: jis0208<<14 | 0x49<<7 | 0x45,
	35038 - 19968: jis0212<<14 | 0x3B<<7 | 0x2D,
	35039 - 19968: jis0208<<14 | 0x19<<7 | 0x1F,
	35041 - 19968: jis0208<<14 | 0x2D<<7 | 0x02,
	35047 - 19968: jis0212<<14 | 0x3B<<7 | 0x2E,
	35048 - 19968: jis0208<<14 | 0x49<<7 | 0x4A,
	35055 - 19968: jis0212<<14 | 0x3B<<7 | 0x2F,
	35056 - 19968: jis0212<<14 | 0x3B<<7 | 0x30,
	35057 - 19968: jis0212<<14 | 0x3B<<7 | 0x31,
	35058 - 19968: jis0208<<14 | 0x49<<7 | 0x4B,
	35059 - 19968: jis0208<<14 | 0x1D<<7 | 0x37,
	35060 - 19968: jis0208<<14 | 0x49<<7 | 0x49,
	35061 - 19968: jis0208<<14 | 0x5A<<7 | 0x45,
	35063 - 19968: jis0212<<14 | 0x3B<<7 | 0x33,
	35064 - 19968: jis0208<<14 | 0x2C<<7 | 0x46,
	35065 - 19968: jis0208<<14 | 0x49<<7 | 0x46,
	35068 - 19968: jis0208<<14 | 0x49<<7 | 0x48,
	35069 - 19968: jis0208<<14 | 0x1F<<7 | 0x1C,
	35070 - 19968: jis0208<<14 | 0x1E<<7 | 0x5D,
	35073 - 19968: jis0212<<14 | 0x3B<<7 | 0x34,
	35074 - 19968: jis0208<<14 | 0x49<<7 | 0x47,
	35076 - 19968: jis0208<<14 | 0x49<<7 | 0x4C,
	35078 - 19968: jis0212<<14 | 0x3B<<7 | 0x35,
	35079 - 19968: jis0208<<14 | 0x29<<7 | 0x02,
	35082 - 19968: jis0208<<14 | 0x49<<7 | 0x4E,
	35084 - 19968: jis0208<<14 | 0x49<<7 | 0x4D,
	35085 - 19968: jis0212<<14 | 0x3B<<7 | 0x36,
	35086 - 19968: jis0212<<14 | 0x3B<<7 | 0x37,
	35087 - 19968: jis0212<<14 | 0x3B<<7 | 0x38,
	35088 - 19968: jis0208<<14 | 0x12<<7 | 0x4B,
	35090 - 19968: jis0208<<14 | 0x2A<<7 | 0x0A,
	35091 - 19968: jis0208<<14 | 0x49<<7 | 0x4F,
	35093 - 19968: jis0212<<14 | 0x3B<<7 | 0x39,
	35094 - 19968: jis0212<<14 | 0x3B<<7 | 0x3A,
	35096 - 19968: jis0212<<14 | 0x3B<<7 | 0x3B,
	35097 - 19968: jis0212<<14 | 0x3B<<7 | 0x3C,
	35098 - 19968: jis0212<<14 | 0x3B<<7 | 0x3D,
	35100 - 19968: jis0208<<14 | 0x58<<7 | 0x01,
	35101 - 19968: jis0208<<14 | 0x49<<7 | 0x5B,
	35102 - 19968: jis0208<<14 | 0x49<<7 | 0x51,
	35104 - 19968: jis0212<<14 | 0x3B<<7 | 0x3F,
	35109 - 19968: jis0208<<14 | 0x49<<7 | 0x52,
	35110 - 19968: jis0212<<14 | 0x3B<<7 | 0x40,
	35111 - 19968: jis0212<<14 | 0x3B<<7 | 0x41,
	35112 - 19968: jis0212<<14 | 0x3B<<7 | 0x42,
	35114 - 19968: jis0208<<14 | 0x49<<7 | 0x53,
	35115 - 19968: jis0208<<14 | 0x49<<7 | 0x54,
	35120 - 19968: jis0212<<14 | 0x3B<<7 | 0x43,
	35121 - 19968: jis0212<<14 | 0x3B<<7 | 0x44,
	35122 - 19968: jis0212<<14 | 0x3B<<7 | 0x45,
	35125 - 19968: jis0212<<14 | 0x3B<<7 | 0x46,
	35126 - 19968: jis0208<<14 | 0x49<<7 | 0x58,
	35128 - 19968: jis0208<<14 | 0x49<<7 | 0x59,
	35129 - 19968: jis0212<<14 | 0x3B<<7 | 0x47,
	35130 - 19968: jis0212<<14 | 0x3B<<7 | 0x48,
	35131 - 19968: jis0208<<14 | 0x49<<7 | 0x57,
	35134 - 19968: jis0212<<14 | 0x3B<<7 | 0x49,
	35136 - 19968: jis0212<<14 | 0x3B<<7 | 0x4A,
	35137 - 19968: jis0208<<14 | 0x49<<7 | 0x55,
	35138 - 19968: jis0212<<14 | 0x3B<<7 | 0x4B,
	35139 - 19968: jis0208<<14 | 0x49<<7 | 0x50,
	35140 - 19968: jis0208<<14 | 0x49<<7 | 0x56,
	35141 - 19968: jis0212<<14 | 0x3B<<7 | 0x4C,
	35142 - 19968: jis0212<<14 | 0x3B<<7 | 0x4D,
	35145 - 19968: jis0212<<14 | 0x3B<<7 | 0x4E,
	35148 - 19968: jis0208<<14 | 0x49<<7 | 0x5A,
	35149 - 19968: jis0208<<14 | 0x4F<<7 | 0x16,
	35151 - 19968: jis0212<<14 | 0x3B<<7 | 0x4F,
	35154 - 19968: jis0212<<14 | 0x3B<<7 | 0x50,
	35158 - 19968: jis0208<<14 | 0x11<<7 | 0x07,
	35159 - 19968: jis0212<<14 | 0x3B<<7 | 0x51,
	35162 - 19968: jis0212<<14 | 0x3B<<7 | 0x52,
	35163 - 19968: jis0212<<14 | 0x3B<<7 | 0x53,
	35164 - 19968: jis0212<<14 | 0x3B<<7 | 0x54,
	35166 - 19968: jis0208<<14 | 0x49<<7 | 0x5D,
	35167 - 19968: jis0208<<14 | 0x15<<7 | 0x3E,
	35168 - 19968: jis0208<<14 | 0x49<<7 | 0x5C,
	35169 - 19968: jis0212<<14 | 0x3B<<7 | 0x55,
	35170 - 19968: jis0212<<14 | 0x3B<<7 | 0x56,
	35171 - 19968: jis0212<<14 | 0x3B<<7 | 0x57,
	35172 - 19968: jis0208<<14 | 0x4A<<7 | 0x01,
	35174 - 19968: jis0208<<14 | 0x4A<<7 | 0x00,
	35178 - 19968: jis0208<<14 | 0x4A<<7 | 0x03,
	35179 - 19968: jis0212<<14 | 0x3B<<7 | 0x58,
	35181 - 19968: jis0208<<14 | 0x4A<<7 | 0x02,
	35182 - 19968: jis0212<<14 | 0x3B<<7 | 0x59,
	35183 - 19968: jis0208<<14 | 0x4A<<7 | 0x04,
	35184 - 19968: jis0212<<14 | 0x3B<<7 | 0x5A,
	35186 - 19968: jis0208<<14 | 0x1C<<7 | 0x10,
	35187 - 19968: jis0212<<14 | 0x3B<<7 | 0x5B,
	35188 - 19968: jis0208<<14 | 0x4A<<7 | 0x05,
	35189 - 19968: jis0212<<14 | 0x3B<<7 | 0x5C,
	35191 - 19968: jis0208<<14 | 0x4A<<7 | 0x06,
	35194 - 19968: jis0212<<14 | 0x3B<<7 | 0x5D,
	35195 - 19968: jis0212<<14 | 0x3C<<7 | 0x00,
	35196 - 19968: jis0212<<14 | 0x3C<<7 | 0x01,
	35197 - 19968: jis0212<<14 | 0x3C<<7 | 0x02,
	35198 - 19968: jis0208<<14 | 0x4A<<7 | 0x07,
	35199 - 19968: jis0208<<14 | 0x1F<<7 | 0x1D,
	35201 - 19968: jis0208<<14 | 0x2C<<7 | 0x36,
	35203 - 19968: jis0208<<14 | 0x4A<<7 | 0x08,
	35206 - 19968: jis0208<<14 | 0x29<<7 | 0x03,
	35207 - 19968: jis0208<<14 | 0x26<<7 | 0x25,
	35208 - 19968: jis0208<<14 | 0x4A<<7 | 0x09,
	35209 - 19968: jis0212<<14 | 0x3C<<7 | 0x03,
	35210 - 19968: jis0208<<14 | 0x4A<<7 | 0x0A,
	35211 - 19968: jis0208<<14 | 0x17<<7 | 0x0A,
	35213 - 19968: jis0212<<14 | 0x3C<<7 | 0x04,
	35215 - 19968: jis0208<<14 | 0x14<<7 | 0x0B,
	35216 - 19968: jis0212<<14 | 0x3C<<7 | 0x05,
	35219 - 19968: jis0208<<14 | 0x4A<<7 | 0x0B,
	35220 - 19968: jis0212<<14 | 0x3C<<7 | 0x06,
	35221 - 19968: jis0212<<14 | 0x3C<<7 | 0x07,
	35222 - 19968: jis0208<<14 | 0x1A<<7 | 0x4A,
	35223 - 19968: jis0208<<14 | 0x26<<7 | 0x20,
	35224 - 19968: jis0208<<14 | 0x4A<<7 | 0x0C,
	35226 - 19968: jis0208<<14 | 0x12<<7 | 0x2F,
	35227 - 19968: jis0212<<14 | 0x3C<<7 | 0x08,
	35228 - 19968: jis0212<<14 | 0x3C<<7 | 0x09,
	35231 - 19968: jis0212<<14 | 0x3C<<7 | 0x0A,
	35232 - 19968: jis0212<<14 | 0x3C<<7 | 0x0B,
	35233 - 19968: jis0208<<14 | 0x4A<<7 | 0x0D,
	35237 - 19968: jis0212<<14 | 0x3C<<7 | 0x0C,
	35238 - 19968: jis0208<<14 | 0x4A<<7 | 0x0F,
	35239 - 19968: jis0208<<14 | 0x2C<<7 | 0x56,
	35241 - 19968: jis0208<<14 | 0x4A<<7 | 0x0E,
	35242 - 19968: jis0208<<14 | 0x1E<<7 | 0x25,
	35244 - 19968: jis0208<<14 | 0x4A<<7 | 0x10,
	35247 - 19968: jis0208<<14 | 0x4A<<7 | 0x11,
	35248 - 19968: jis0212<<14 | 0x3C<<7 | 0x0D,
	35250 - 19968: jis0208<<14 | 0x4A<<7 | 0x12,
	35251 - 19968: jis0208<<14 | 0x13<<7 | 0x30,
	35252 - 19968: jis0212<<14 | 0x3C<<7 | 0x0E,
	35253 - 19968: jis0212<<14 | 0x3C<<7 | 0x0F,
	35254 - 19968: jis0212<<14 | 0x3C<<7 | 0x10,
	35255 - 19968: jis0212<<14 | 0x3C<<7 | 0x11,
	35258 - 19968: jis0208<<14 | 0x4A<<7 | 0x13,
	35260 - 19968: jis0212<<14 | 0x3C<<7 | 0x12,
	35261 - 19968: jis0208<<14 | 0x4A<<7 | 0x14,
	35263 - 19968: jis0208<<14 | 0x4A<<7 | 0x15,
	35264 - 19968: jis0208<<14 | 0x4A<<7 | 0x16,
	35282 - 19968: jis0208<<14 | 0x12<<7 | 0x30,
	35284 - 19968: jis0212<<14 | 0x3C<<7 | 0x13,
	35285 - 19968: jis0212<<14 | 0x3C<<7 | 0x14,
	35286 - 19968: jis0212<<14 | 0x3C<<7 | 0x15,
	35287 - 19968: jis0212<<14 | 0x3C<<7 | 0x16,
	35288 - 19968: jis0212<<14 | 0x3C<<7 | 0x17,
	35290 - 19968: jis0208<<14 | 0x4A<<7 | 0x17,
	35292 - 19968: jis0208<<14 | 0x4A<<7 | 0x18,
	35293 - 19968: jis0208<<14 | 0x4A<<7 | 0x19,
	35299 - 19968: jis0208<<14 | 0x11<<7 | 0x51,
	35301 - 19968: jis0212<<14 | 0x3C<<7 | 0x18,
	35302 - 19968: jis0208<<14 | 0x1E<<7 | 0x07,
	35303 - 19968: jis0208<<14 | 0x4A<<7 | 0x1A,
	35305 - 19968: jis0212<<14 | 0x3C<<7 | 0x19,
	35307 - 19968: jis0212<<14 | 0x3C<<7 | 0x1A,
	35309 - 19968: jis0212<<14 | 0x3C<<7 | 0x1B,
	35313 - 19968: jis0212<<14 | 0x3C<<7 | 0x1C,
	35315 - 19968: jis0212<<14 | 0x3C<<7 | 0x1D,
	35316 - 19968: jis0208<<14 | 0x4A<<7 | 0x1B,
	35318 - 19968: jis0212<<14 | 0x3C<<7 | 0x1E,
	35320 - 19968: jis0208<<14 | 0x4A<<7 | 0x1C,
	35321 - 19968: jis0212<<14 | 0x3C<<7 | 0x1F,
	35325 - 19968: jis0212<<14 | 0x3C<<7 | 0x20,
	35327 - 19968: jis0212<<14 | 0x3C<<7 | 0x21,
	35328 - 19968: jis0208<<14 | 0x17<<7 | 0x1F,
	35330 - 19968: jis0208<<14 | 0x23<<7 | 0x5A,
	35331 - 19968: jis0208<<14 | 0x4A<<7 | 0x1D,
	35332 - 19968: jis0212<<14 | 0x3C<<7 | 0x22,
	35333 - 19968: jis0212<<14 | 0x3C<<7 | 0x23,
	35335 - 19968: jis0212<<14 | 0x3C<<7 | 0x24,
	35336 - 19968: jis0208<<14 | 0x16<<7 | 0x36,
	35338 - 19968: jis0208<<14 | 0x1E<<7 | 0x35,
	35340 - 19968: jis0208<<14 | 0x4A<<7 | 0x20,
	35342 - 19968: jis0208<<14 | 0x25<<7 | 0x03,
	35343 - 19968: jis0212<<14 | 0x3C<<7 | 0x25,
	35344 - 19968: jis0208<<14 | 0x4A<<7 | 0x1F,
	35345 - 19968: jis0212<<14 | 0x3C<<7 | 0x26,
	35346 - 19968: jis0208<<14 | 0x5A<<7 | 0x46,
	35347 - 19968: jis0208<<14 | 0x16<<7 | 0x10,
	35348 - 19968: jis0212<<14 | 0x3C<<7 | 0x28,
	35349 - 19968: jis0212<<14 | 0x3C<<7 | 0x29,
	35350 - 19968: jis0208<<14 | 0x4A<<7 | 0x1E,
	35351 - 19968: jis0208<<14 | 0x21<<7 | 0x56,
	35352 - 19968: jis0208<<14 | 0x14<<7 | 0x0C,
	35355 - 19968: jis0208<<14 | 0x4A<<7 | 0x21,
	35357 - 19968: jis0208<<14 | 0x4A<<7 | 0x22,
	35358 - 19968: jis0212<<14 | 0x3C<<7 | 0x2A,
	35359 - 19968: jis0208<<14 | 0x1D<<7 | 0x38,
	35360 - 19968: jis0212<<14 | 0x3C<<7 | 0x2B,
	35362 - 19968: jis0212<<14 | 0x3C<<7 | 0x2C,
	35363 - 19968: jis0208<<14 | 0x16<<7 | 0x4C,
	35364 - 19968: jis0212<<14 | 0x3C<<7 | 0x2D,
	35365 - 19968: jis0208<<14 | 0x4A<<7 | 0x23,
	35366 - 19968: jis0212<<14 | 0x3C<<7 | 0x2E,
	35370 - 19968: jis0208<<14 | 0x2A<<7 | 0x0B,
	35371 - 19968: jis0212<<14 | 0x3C<<7 | 0x2F,
	35372 - 19968: jis0212<<14 | 0x3C<<7 | 0x30,
	35373 - 19968: jis0208<<14 | 0x1F<<7 | 0x3E,
	35375 - 19968: jis0212<<14 | 0x3C<<7 | 0x31,
	35377 - 19968: jis0208<<14 | 0x14<<7 | 0x55,
	35379 - 19968: jis0208<<14 | 0x2B<<7 | 0x54,
	35380 - 19968: jis0208<<14 | 0x20<<7 | 0x29,
	35381 - 19968: jis0212<<14 | 0x3C<<7 | 0x32,
	35382 - 19968: jis0208<<14 | 0x4A<<7 | 0x24,
	35383 - 19968: jis0208<<14 | 0x5A<<7 | 0x47,
	35386 - 19968: jis0208<<14 | 0x1E<<7 | 0x26,
	35387 - 19968: jis0208<<14 | 0x22<<7 | 0x4F,
	35388 - 19968: jis0208<<14 | 0x1D<<7 | 0x39,
	35389 - 19968: jis0212<<14 | 0x3C<<7 | 0x34,
	35390 - 19968: jis0212<<14 | 0x3C<<7 | 0x35,
	35392 - 19968: jis0212<<14 | 0x3C<<7 | 0x36,
	35393 - 19968: jis0208<<14 | 0x4A<<7 | 0x25,
	35395 - 19968: jis0212<<14 | 0x3C<<7 | 0x37,
	35397 - 19968: jis0212<<14 | 0x3C<<7 | 0x38,
	35398 - 19968: jis0208<<14 | 0x4A<<7 | 0x28,
	35399 - 19968: jis0212<<14 | 0x3C<<7 | 0x39,
	35400 - 19968: jis0208<<14 | 0x4A<<7 | 0x29,
	35401 - 19968: jis0212<<14 | 0x3C<<7 | 0x3A,
	35405 - 19968: jis0212<<14 | 0x3C<<7 | 0x3B,
	35406 - 19968: jis0212<<14 | 0x3C<<7 | 0x3C,
	35408 - 19968: jis0208<<14 | 0x19<<7 | 0x1D,
	35409 - 19968: jis0208<<14 | 0x21<<7 | 0x21,
	35410 - 19968: jis0208<<14 | 0x4A<<7 | 0x27,
	35411 - 19968: jis0212<<14 | 0x3C<<7 | 0x3D,
	35412 - 19968: jis0208<<14 | 0x1D<<7 | 0x3A,
	35413 - 19968: jis0208<<14 | 0x28<<7 | 0x1D,
	35414 - 19968: jis0212<<14 | 0x3C<<7 | 0x3E,
	35415 - 19968: jis0212<<14 | 0x3C<<7 | 0x3F,
	35416 - 19968: jis0212<<14 | 0x3C<<7 | 0x40,
	35419 - 19968: jis0208<<14 | 0x4A<<7 | 0x26,
	35420 - 19968: jis0212<<14 | 0x3C<<7 | 0x41,
	35421 - 19968: jis0212<<14 | 0x3C<<7 | 0x42,
	35422 - 19968: jis0208<<14 | 0x1A<<7 | 0x4B,
	35424 - 19968: jis0208<<14 | 0x10<<7 | 0x32,
	35425 - 19968: jis0212<<14 | 0x3C<<7 | 0x43,
	35426 - 19968: jis0208<<14 | 0x4A<<7 | 0x2D,
	35427 - 19968: jis0208<<14 | 0x16<<7 | 0x37,
	35429 - 19968: jis0212<<14 | 0x3C<<7 | 0x44,
	35430 - 19968: jis0208<<14 | 0x1A<<7 | 0x4D,
	35431 - 19968: jis0212<<14 | 0x3C<<7 | 0x45,
	35433 - 19968: jis0208<<14 | 0x1A<<7 | 0x4C,
	35435 - 19968: jis0208<<14 | 0x2E<<7 | 0x2C,
	35436 - 19968: jis0208<<14 | 0x4A<<7 | 0x2C,
	35437 - 19968: jis0208<<14 | 0x4A<<7 | 0x2B,
	35438 - 19968: jis0208<<14 | 0x20<<7 | 0x06,
	35440 - 19968: jis0208<<14 | 0x14<<7 | 0x2C,
	35441 - 19968: jis0208<<14 | 0x2E<<7 | 0x22,
	35442 - 19968: jis0208<<14 | 0x12<<7 | 0x19,
	35443 - 19968: jis0208<<14 | 0x1D<<7 | 0x3B,
	35445 - 19968: jis0212<<14 | 0x3C<<7 | 0x46,
	35446 - 19968: jis0212<<14 | 0x3C<<7 | 0x47,
	35447 - 19968: jis0212<<14 | 0x3C<<7 | 0x48,
	35449 - 19968: jis0208<<14 | 0x5A<<7 | 0x48,
	35450 - 19968: jis0212<<14 | 0x3C<<7 | 0x4A,
	35451 - 19968: jis0212<<14 | 0x3C<<7 | 0x4B,
	35452 - 19968: jis0208<<14 | 0x4A<<7 | 0x2A,
	35454 - 19968: jis0212<<14 | 0x3C<<7 | 0x4C,
	35455 - 19968: jis0212<<14 | 0x3C<<7 | 0x4D,
	35456 - 19968: jis0212<<14 | 0x3C<<7 | 0x4E,
	35458 - 19968: jis0208<<14 | 0x4A<<7 | 0x2F,
	35459 - 19968: jis0212<<14 | 0x3C<<7 | 0x4F,
	35460 - 19968: jis0208<<14 | 0x4A<<7 | 0x30,
	35461 - 19968: jis0208<<14 | 0x4A<<7 | 0x2E,
	35462 - 19968: jis0212<<14 | 0x3C<<7 | 0x50,
	35463 - 19968: jis0208<<14 | 0x17<<7 | 0x37,
	35465 - 19968: jis0208<<14 | 0x2C<<7 | 0x1F,
	35467 - 19968: jis0212<<14 | 0x3C<<7 | 0x51,
	35468 - 19968: jis0208<<14 | 0x1A<<7 | 0x4E,
	35469 - 19968: jis0208<<14 | 0x26<<7 | 0x06,
	35471 - 19968: jis0212<<14 | 0x3C<<7 | 0x52,
	35472 - 19968: jis0212<<14 | 0x3C<<7 | 0x53,
	35473 - 19968: jis0208<<14 | 0x4A<<7 | 0x33,
	35474 - 19968: jis0212<<14 | 0x3C<<7 | 0x54,
	35475 - 19968: jis0208<<14 | 0x1F<<7 | 0x1F,
	35477 - 19968: jis0208<<14 | 0x22<<7 | 0x21,
	35478 - 19968: jis0212<<14 | 0x3C<<7 | 0x55,
	35479 - 19968: jis0212<<14 | 0x3C<<7 | 0x56,
	35480 - 19968: jis0208<<14 | 0x2C<<7 | 0x15,
	35481 - 19968: jis0212<<14 | 0x3C<<7 | 0x57,
	35482 - 19968: jis0208<<14 | 0x4A<<7 | 0x36,
	35486 - 19968: jis0208<<14 | 0x17<<7 | 0x4B,
	35487 - 19968: jis0212<<14 | 0x3C<<7 | 0x58,
	35488 - 19968: jis0208<<14 | 0x1F<<7 | 0x1E,
	35489 - 19968: jis0208<<14 | 0x4A<<7 | 0x32,
	35491 - 19968: jis0208<<14 | 0x4A<<7 | 0x37,
	35492 - 19968: jis0208<<14 | 0x17<<7 | 0x4C,
	35493 - 19968: jis0208<<14 | 0x4A<<7 | 0x34,
	35494 - 19968: jis0208<<14 | 0x4A<<7 | 0x35,
	35495 - 19968: jis0208<<14 | 0x5A<<7 | 0x49,
	35496 - 19968: jis0208<<14 | 0x4A<<7 | 0x31,
	35497 - 19968: jis0212<<14 | 0x3C<<7 | 0x5A,
	35500 - 19968: jis0208<<14 | 0x1F<<7 | 0x41,
	35501 - 19968: jis0208<<14 | 0x25<<7 | 0x28,
	35502 - 19968: jis0212<<14 | 0x3C<<7 | 0x5B,
	35503 - 19968: jis0212<<14 | 0x3C<<7 | 0x5C,
	35504 - 19968: jis0208<<14 | 0x22<<7 | 0x0E,
	35506 - 19968: jis0208<<14 | 0x11<<7 | 0x3C,
	35507 - 19968: jis0212<<14 | 0x3C<<7 | 0x5D,
	35510 - 19968: jis0212<<14 | 0x3D<<7 | 0x00,
	35511 - 19968: jis0212<<14 | 0x3D<<7 | 0x01,
	35513 - 19968: jis0208<<14 | 0x27<<7 | 0x4F,
	35515 - 19968: jis0212<<14 | 0x3D<<7 | 0x02,
	35516 - 19968: jis0208<<14 | 0x14<<7 | 0x22,
	35518 - 19968: jis0208<<14 | 0x5A<<7 | 0x4A,
	35519 - 19968: jis0208<<14 | 0x23<<7 | 0x13,
	35522 - 19968: jis0208<<14 | 0x4A<<7 | 0x3A,
	35523 - 19968: jis0212<<14 | 0x3D<<7 | 0x04,
	35524 - 19968: jis0208<<14 | 0x4A<<7 | 0x38,
	35526 - 19968: jis0212<<14 | 0x3D<<7 | 0x05,
	35527 - 19968: jis0208<<14 | 0x22<<7 | 0x2B,
	35528 - 19968: jis0212<<14 | 0x3D<<7 | 0x06,
	35529 - 19968: jis0212<<14 | 0x3D<<7 | 0x07,
	35530 - 19968: jis0212<<14 | 0x3D<<7 | 0x08,
	35531 - 19968: jis0208<<14 | 0x1F<<7 | 0x20,
	35532 - 19968: jis0208<<14 | 0x13<<7 | 0x31,
	35533 - 19968: jis0208<<14 | 0x4A<<7 | 0x39,
	35535 - 19968: jis0208<<14 | 0x1E<<7 | 0x3A,
	35537 - 19968: jis0212<<14 | 0x3D<<7 | 0x09,
	35538 - 19968: jis0208<<14 | 0x2D<<7 | 0x29,
	35539 - 19968: jis0212<<14 | 0x3D<<7 | 0x0A,
	35540 - 19968: jis0212<<14 | 0x3D<<7 | 0x0B,
	35541 - 19968: jis0212<<14 | 0x3D<<7 | 0x0C,
	35542 - 19968: jis0208<<14 | 0x2E<<7 | 0x1F,
	35543 - 19968: jis0212<<14 | 0x3D<<7 | 0x0D,
	35546 - 19968: jis0208<<14 | 0x4A<<7 | 0x3B,
	35547 - 19968: jis0208<<14 | 0x4A<<7 | 0x46,
	35548 - 19968: jis0208<<14 | 0x23<<7 | 0x14,
	35549 - 19968: jis0212<<14 | 0x3D<<7 | 0x0E,
	35550 - 19968: jis0208<<14 | 0x4A<<7 | 0x45,
	35551 - 19968: jis0208<<14 | 0x5A<<7 | 0x4B,
	35552 - 19968: jis0208<<14 | 0x4A<<7 | 0x42,
	35553 - 19968: jis0208<<14 | 0x4A<<7 | 0x4A,
	35554 - 19968: jis0208<<14 | 0x4A<<7 | 0x43,
	35556 - 19968: jis0208<<14 | 0x4A<<7 | 0x3F,
	35558 - 19968: jis0208<<14 | 0x23<<7 | 0x5B,
	35559 - 19968: jis0208<<14 | 0x4A<<7 | 0x3E,
	35563 - 19968: jis0208<<14 | 0x4A<<7 | 0x3C,
	35564 - 19968: jis0212<<14 | 0x3D<<7 | 0x10,
	35565 - 19968: jis0208<<14 | 0x2C<<7 | 0x00,
	35566 - 19968: jis0208<<14 | 0x1A<<7 | 0x4F,
	35568 - 19968: jis0212<<14 | 0x3D<<7 | 0x11,
	35569 - 19968: jis0208<<14 | 0x4A<<7 | 0x40,
	35571 - 19968: jis0208<<14 | 0x4A<<7 | 0x3D,
	35572 - 19968: jis0212<<14 | 0x3D<<7 | 0x12,
	35573 - 19968: jis0212<<14 | 0x3D<<7 | 0x13,
	35574 - 19968: jis0208<<14 | 0x5A<<7 | 0x4D,
	35575 - 19968: jis0208<<14 | 0x4A<<7 | 0x44,
	35576 - 19968: jis0208<<14 | 0x1C<<7 | 0x53,
	35578 - 19968: jis0208<<14 | 0x17<<7 | 0x20,
	35580 - 19968: jis0212<<14 | 0x3D<<7 | 0x15,
	35582 - 19968: jis0208<<14 | 0x21<<7 | 0x59,
	35583 - 19968: jis0212<<14 | 0x3D<<7 | 0x16,
	35584 - 19968: jis0208<<14 | 0x2A<<7 | 0x24,
	35585 - 19968: jis0208<<14 | 0x10<<7 | 0x39,
	35586 - 19968: jis0208<<14 | 0x0F<<7 | 0x41,
	35588 - 19968: jis0208<<14 | 0x25<<7 | 0x04,
	35589 - 19968: jis0212<<14 | 0x3D<<7 | 0x17,
	35590 - 19968: jis0212<<14 | 0x3D<<7 | 0x18,
	35591 - 19968: jis0208<<14 | 0x4A<<7 | 0x48,
	35594 - 19968: jis0212<<14 | 0x3D<<7 | 0x1E,
	35595 - 19968: jis0212<<14 | 0x3D<<7 | 0x19,
	35596 - 19968: jis0208<<14 | 0x4A<<7 | 0x47,
	35598 - 19968: jis0208<<14 | 0x25<<7 | 0x45,
	35600 - 19968: jis0208<<14 | 0x4A<<7 | 0x4C,
	35601 - 19968: jis0212<<14 | 0x3D<<7 | 0x1A,
	35604 - 19968: jis0208<<14 | 0x4A<<7 | 0x41,
	35606 - 19968: jis0208<<14 | 0x4A<<7 | 0x4B,
	35607 - 19968: jis0208<<14 | 0x4A<<7 | 0x4D,
	35609 - 19968: jis0208<<14 | 0x17<<7 | 0x0B,
	35610 - 19968: jis0208<<14 | 0x4A<<7 | 0x49,
	35611 - 19968: jis0208<<14 | 0x18<<7 | 0x35,
	35612 - 19968: jis0212<<14 | 0x3D<<7 | 0x1B,
	35613 - 19968: jis0208<<14 | 0x1B<<7 | 0x34,
	35614 - 19968: jis0212<<14 | 0x3D<<7 | 0x1C,
	35615 - 19968: jis0212<<14 | 0x3D<<7 | 0x1D,
	35616 - 19968: jis0208<<14 | 0x4A<<7 | 0x4E,
	35617 - 19968: jis0208<<14 | 0x2C<<7 | 0x37,
	35622 - 19968: jis0208<<14 | 0x4A<<7 | 0x51,
	35624 - 19968: jis0208<<14 | 0x4A<<7 | 0x54,
	35627 - 19968: jis0208<<14 | 0x4A<<7 | 0x52,
	35628 - 19968: jis0208<<14 | 0x28<<7 | 0x14,
	35629 - 19968: jis0212<<14 | 0x3D<<7 | 0x1F,
	35632 - 19968: jis0212<<14 | 0x3D<<7 | 0x20,
	35635 - 19968: jis0208<<14 | 0x4A<<7 | 0x4F,
	35639 - 19968: jis0212<<14 | 0x3D<<7 | 0x21,
	35641 - 19968: jis0208<<14 | 0x15<<7 | 0x3F,
	35644 - 19968: jis0212<<14 | 0x3D<<7 | 0x22,
	35646 - 19968: jis0208<<14 | 0x4A<<7 | 0x53,
	35649 - 19968: jis0208<<14 | 0x4A<<7 | 0x55,
	35650 - 19968: jis0212<<14 | 0x3D<<7 | 0x23,
	35651 - 19968: jis0212<<14 | 0x3D<<7 | 0x24,
	35652 - 19968: jis0212<<14 | 0x3D<<7 | 0x25,
	35653 - 19968: jis0212<<14 | 0x3D<<7 | 0x26,
	35654 - 19968: jis0212<<14 | 0x3D<<7 | 0x27,
	35656 - 19968: jis0212<<14 | 0x3D<<7 | 0x28,
	35657 - 19968: jis0208<<14 | 0x4A<<7 | 0x59,
	35660 - 19968: jis0208<<14 | 0x4A<<7 | 0x56,
	35661 - 19968: jis0212<<14 | 0x3D<<7 | 0x2D,
	35662 - 19968: jis0208<<14 | 0x4A<<7 | 0x58,
	35663 - 19968: jis0208<<14 | 0x4A<<7 | 0x57,
	35666 - 19968: jis0212<<14 | 0x3D<<7 | 0x29,
	35667 - 19968: jis0208<<14 | 0x5A<<7 | 0x4E,
	35668 - 19968: jis0212<<14 | 0x3D<<7 | 0x2B,
	35670 - 19968: jis0208<<14 | 0x4A<<7 | 0x5A,
	35672 - 19968: jis0208<<14 | 0x1B<<7 | 0x10,
	35673 - 19968: jis0212<<14 | 0x3D<<7 | 0x2C,
	35674 - 19968: jis0208<<14 | 0x4A<<7 | 0x5C,
	35675 - 19968: jis0208<<14 | 0x4A<<7 | 0x5B,
	35676 - 19968: jis0208<<14 | 0x28<<7 | 0x47,
	35678 - 19968: jis0212<<14 | 0x3D<<7 | 0x2E,
	35679 - 19968: jis0208<<14 | 0x4B<<7 | 0x00,
	35683 - 19968: jis0212<<14 | 0x3D<<7 | 0x2F,
	35686 - 19968: jis0208<<14 | 0x16<<7 | 0x38,
	35691 - 19968: jis0208<<14 | 0x4A<<7 | 0x5D,
	35692 - 19968: jis0208<<14 | 0x4B<<7 | 0x01,
	35693 - 19968: jis0212<<14 | 0x3D<<7 | 0x30,
	35695 - 19968: jis0208<<14 | 0x4B<<7 | 0x02,
	35696 - 19968: jis0208<<14 | 0x14<<7 | 0x23,
	35697 - 19968: jis0208<<14 | 0x45<<7 | 0x20,
	35698 - 19968: jis0208<<14 | 0x1D<<7 | 0x58,
	35700 - 19968: jis0208<<14 | 0x4B<<7 | 0x03,
	35702 - 19968: jis0212<<14 | 0x3D<<7 | 0x31,
	35703 - 19968: jis0208<<14 | 0x17<<7 | 0x4D,
	35704 - 19968: jis0212<<14 | 0x3D<<7 | 0x32,
	35705 - 19968: jis0212<<14 | 0x3D<<7 | 0x33,
	35708 - 19968: jis0212<<14 | 0x3D<<7 | 0x34,
	35709 - 19968: jis0208<<14 | 0x4B<<7 | 0x04,
	35710 - 19968: jis0212<<14 | 0x3D<<7 | 0x35,
	35711 - 19968: jis0208<<14 | 0x5A<<7 | 0x4F,
	35712 - 19968: jis0208<<14 | 0x4B<<7 | 0x05,
	35713 - 19968: jis0212<<14 | 0x3D<<7 | 0x36,
	35715 - 19968: jis0208<<14 | 0x1A<<7 | 0x1D,
	35716 - 19968: jis0212<<14 | 0x3D<<7 | 0x37,
	35717 - 19968: jis0212<<14 | 0x3D<<7 | 0x38,
	35722 - 19968: jis0208<<14 | 0x39<<7 | 0x2D,
	35723 - 19968: jis0212<<14 | 0x3D<<7 | 0x39,
	35724 - 19968: jis0208<<14 | 0x4B<<7 | 0x06,
	35725 - 19968: jis0212<<14 | 0x3D<<7 | 0x3A,
	35726 - 19968: jis0208<<14 | 0x4B<<7 | 0x07,
	35727 - 19968: jis0212<<14 | 0x3D<<7 | 0x3B,
	35728 - 19968: jis0208<<14 | 0x1C<<7 | 0x11,
	35730 - 19968: jis0208<<14 | 0x4B<<7 | 0x08,
	35731 - 19968: jis0208<<14 | 0x4B<<7 | 0x09,
	35732 - 19968: jis0212<<14 | 0x3D<<7 | 0x3C,
	35733 - 19968: jis0212<<14 | 0x3D<<7 | 0x3D,
	35734 - 19968: jis0208<<14 | 0x4B<<7 | 0x0A,
	35737 - 19968: jis0208<<14 | 0x4B<<7 | 0x0B,
	35738 - 19968: jis0208<<14 | 0x4B<<7 | 0x0C,
	35740 - 19968: jis0212<<14 | 0x3D<<7 | 0x3E,
	35742 - 19968: jis0212<<14 | 0x3D<<7 | 0x3F,
	35743 - 19968: jis0212<<14 | 0x3D<<7 | 0x40,
	35895 - 19968: jis0208<<14 | 0x22<<7 | 0x0A,
	35896 - 19968: jis0212<<14 | 0x3D<<7 | 0x41,
	35897 - 19968: jis0212<<14 | 0x3D<<7 | 0x42,
	35898 - 19968: jis0208<<14 | 0x4B<<7 | 0x0D,
	35901 - 19968: jis0212<<14 | 0x3D<<7 | 0x43,
	35902 - 19968: jis0212<<14 | 0x3D<<7 | 0x44,
	35903 - 19968: jis0208<<14 | 0x4B<<7 | 0x0F,
	35905 - 19968: jis0208<<14 | 0x4B<<7 | 0x0E,
	35909 - 19968: jis0212<<14 | 0x3D<<7 | 0x45,
	35910 - 19968: jis0208<<14 | 0x25<<7 | 0x05,
	35911 - 19968: jis0212<<14 | 0x3D<<7 | 0x46,
	35912 - 19968: jis0208<<14 | 0x4B<<7 | 0x10,
	35913 - 19968: jis0212<<14 | 0x3D<<7 | 0x47,
	35914 - 19968: jis0208<<14 | 0x2A<<7 | 0x0C,
	35915 - 19968: jis0212<<14 | 0x3D<<7 | 0x48,
	35916 - 19968: jis0208<<14 | 0x4B<<7 | 0x11,
	35918 - 19968: jis0208<<14 | 0x4B<<7 | 0x12,
	35919 - 19968: jis0212<<14 | 0x3D<<7 | 0x49,
	35920 - 19968: jis0208<<14 | 0x4B<<7 | 0x13,
	35921 - 19968: jis0212<<14 | 0x3D<<7 | 0x4A,
	35923 - 19968: jis0212<<14 | 0x3D<<7 | 0x4B,
	35924 - 19968: jis0212<<14 | 0x3D<<7 | 0x4C,
	35925 - 19968: jis0208<<14 | 0x4B<<7 | 0x14,
	35927 - 19968: jis0212<<14 | 0x3D<<7 | 0x4D,
	35928 - 19968: jis0212<<14 | 0x3D<<7 | 0x4E,
	35929 - 19968: jis0212<<14 | 0x3D<<7 | 0x51,
	35930 - 19968: jis0208<<14 | 0x25<<7 | 0x39,
	35931 - 19968: jis0212<<14 | 0x3D<<7 | 0x4F,
	35933 - 19968: jis0212<<14 | 0x3D<<7 | 0x50,
	35937 - 19968: jis0208<<14 | 0x1D<<7 | 0x3C,
	35938 - 19968: jis0208<<14 | 0x4B<<7 | 0x15,
	35939 - 19968: jis0212<<14 | 0x3D<<7 | 0x52,
	35940 - 19968: jis0212<<14 | 0x3D<<7 | 0x53,
	35942 - 19968: jis0212<<14 | 0x3D<<7 | 0x54,
	35944 - 19968: jis0212<<14 | 0x3D<<7 | 0x55,
	35945 - 19968: jis0212<<14 | 0x3D<<7 | 0x56,
	35946 - 19968: jis0208<<14 | 0x18<<7 | 0x4A,
	35947 - 19968: jis0208<<14 | 0x2F<<7 | 0x0D,
	35948 - 19968: jis0208<<14 | 0x4B<<7 | 0x16,
	35949 - 19968: jis0212<<14 | 0x3D<<7 | 0x57,
	35955 - 19968: jis0212<<14 | 0x3D<<7 | 0x58,
	35957 - 19968: jis0212<<14 | 0x3D<<7 | 0x59,
	35958 - 19968: jis0212<<14 | 0x3D<<7 | 0x5A,
	35960 - 19968: jis0208<<14 | 0x4B<<7 | 0x17,
	35961 - 19968: jis0208<<14 | 0x28<<7 | 0x1E,
	35962 - 19968: jis0208<<14 | 0x4B<<7 | 0x18,
	35963 - 19968: jis0212<<14 | 0x3D<<7 | 0x5B,
	35964 - 19968: jis0208<<14 | 0x4B<<7 | 0x20,
	35966 - 19968: jis0212<<14 | 0x3D<<7 | 0x5C,
	35970 - 19968: jis0208<<14 | 0x4B<<7 | 0x19,
	35973 - 19968: jis0208<<14 | 0x4B<<7 | 0x1B,
	35974 - 19968: jis0212<<14 | 0x3D<<7 | 0x5D,
	35975 - 19968: jis0212<<14 | 0x3E<<7 | 0x00,
	35977 - 19968: jis0208<<14 | 0x4B<<7 | 0x1A,
	35978 - 19968: jis0208<<14 | 0x4B<<7 | 0x1C,
	35979 - 19968: jis0212<<14 | 0x3E<<7 | 0x01,
	35980 - 19968: jis0208<<14 | 0x2A<<7 | 0x25,
	35981 - 19968: jis0208<<14 | 0x4B<<7 | 0x1D,
	35982 - 19968: jis0208<<14 | 0x4B<<7 | 0x1E,
	35984 - 19968: jis0212<<14 | 0x3E<<7 | 0x02,
	35986 - 19968: jis0212<<14 | 0x3E<<7 | 0x03,
	35987 - 19968: jis0212<<14 | 0x3E<<7 | 0x04,
	35988 - 19968: jis0208<<14 | 0x4B<<7 | 0x1F,
	35992 - 19968: jis0208<<14 | 0x4B<<7 | 0x21,
	35993 - 19968: jis0212<<14 | 0x3E<<7 | 0x05,
	35995 - 19968: jis0212<<14 | 0x3E<<7 | 0x06,
	35996 - 19968: jis0212<<14 | 0x3E<<7 | 0x07,
	35997 - 19968: jis0208<<14 | 0x12<<7 | 0x0C,
	35998 - 19968: jis0208<<14 | 0x23<<7 | 0x46,
	36000 - 19968: jis0208<<14 | 0x28<<7 | 0x48,
	36001 - 19968: jis0208<<14 | 0x19<<7 | 0x41,
	36002 - 19968: jis0208<<14 | 0x18<<7 | 0x36,
	36004 - 19968: jis0212<<14 | 0x3E<<7 | 0x08,
	36007 - 19968: jis0208<<14 | 0x28<<7 | 0x2E,
	36008 - 19968: jis0208<<14 | 0x11<<7 | 0x3E,
	36009 - 19968: jis0208<<14 | 0x27<<7 | 0x2D,
	36010 - 19968: jis0208<<14 | 0x4B<<7 | 0x24,
	36011 - 19968: jis0208<<14 | 0x13<<7 | 0x32,
	36012 - 19968: jis0208<<14 | 0x1F<<7 | 0x34,
	36013 - 19968: jis0208<<14 | 0x4B<<7 | 0x23,
	36014 - 19968: jis0208<<14 | 0x4B<<7 | 0x28,
	36015 - 19968: jis0208<<14 | 0x22<<7 | 0x58,
	36016 - 19968: jis0208<<14 | 0x2B<<7 | 0x42,
	36018 - 19968: jis0208<<14 | 0x4B<<7 | 0x26,
	36019 - 19968: jis0208<<14 | 0x4B<<7 | 0x27,
	36020 - 19968: jis0208<<14 | 0x14<<7 | 0x0D,
	36022 - 19968: jis0208<<14 | 0x4B<<7 | 0x29,
	36023 - 19968: jis0208<<14 | 0x26<<7 | 0x42,
	36024 - 19968: jis0208<<14 | 0x21<<7 | 0x3E,
	36025 - 19968: jis0212<<14 | 0x3E<<7 | 0x09,
	36026 - 19968: jis0212<<14 | 0x3E<<7 | 0x0A,
	36027 - 19968: jis0208<<14 | 0x27<<7 | 0x50,
	36028 - 19968: jis0208<<14 | 0x24<<7 | 0x1C,
	36029 - 19968: jis0208<<14 | 0x4B<<7 | 0x25,
	36031 - 19968: jis0208<<14 | 0x2A<<7 | 0x26,
	36032 - 19968: jis0208<<14 | 0x11<<7 | 0x4B,
	36033 - 19968: jis0208<<14 | 0x4B<<7 | 0x2B,
	36034 - 19968: jis0208<<14 | 0x2E<<7 | 0x07,
	36035 - 19968: jis0208<<14 | 0x23<<7 | 0x21,
	36036 - 19968: jis0208<<14 | 0x2E<<7 | 0x24,
	36037 - 19968: jis0212<<14 | 0x3E<<7 | 0x0B,
	36038 - 19968: jis0212<<14 | 0x3E<<7 | 0x0C,
	36039 - 19968: jis0208<<14 | 0x1A<<7 | 0x50,
	36040 - 19968: jis0208<<14 | 0x4B<<7 | 0x2A,
	36041 - 19968: jis0212<<14 | 0x3E<<7 | 0x0D,
	36042 - 19968: jis0208<<14 | 0x21<<7 | 0x10,
	36043 - 19968: jis0212<<14 | 0x3E<<7 | 0x0E,
	36045 - 19968: jis0208<<14 | 0x4B<<7 | 0x3B,
	36046 - 19968: jis0208<<14 | 0x20<<7 | 0x07,
	36047 - 19968: jis0212<<14 | 0x3E<<7 | 0x0F,
	36049 - 19968: jis0208<<14 | 0x25<<7 | 0x57,
	36051 - 19968: jis0208<<14 | 0x28<<7 | 0x2F,
	36053 - 19968: jis0212<<14 | 0x3E<<7 | 0x11,
	36054 - 19968: jis0212<<14 | 0x3E<<7 | 0x10,
	36057 - 19968: jis0212<<14 | 0x3E<<7 | 0x12,
	36058 - 19968: jis0208<<14 | 0x4B<<7 | 0x2E,
	36059 - 19968: jis0208<<14 | 0x1A<<7 | 0x1E,
	36060 - 19968: jis0208<<14 | 0x1A<<7 | 0x51,
	36061 - 19968: jis0212<<14 | 0x3E<<7 | 0x13,
	36062 - 19968: jis0208<<14 | 0x1D<<7 | 0x3D,
	36064 - 19968: jis0208<<14 | 0x26<<7 | 0x44,
	36065 - 19968: jis0212<<14 | 0x3E<<7 | 0x14,
	36066 - 19968: jis0208<<14 | 0x17<<7 | 0x0C,
	36067 - 19968: jis0208<<14 | 0x4B<<7 | 0x2D,
	36068 - 19968: jis0208<<14 | 0x4B<<7 | 0x2C,
	36070 - 19968: jis0208<<14 | 0x28<<7 | 0x49,
	36072 - 19968: jis0212<<14 | 0x3E<<7 | 0x15,
	36074 - 19968: jis0208<<14 | 0x1B<<7 | 0x20,
	36076 - 19968: jis0212<<14 | 0x3E<<7 | 0x16,
	36077 - 19968: jis0208<<14 | 0x24<<7 | 0x31,
	36079 - 19968: jis0212<<14 | 0x3E<<7 | 0x17,
	36080 - 19968: jis0208<<14 | 0x5A<<7 | 0x50,
	36082 - 19968: jis0212<<14 | 0x3E<<7 | 0x19,
	36084 - 19968: jis0208<<14 | 0x5A<<7 | 0x51,
	36085 - 19968: jis0212<<14 | 0x3E<<7 | 0x1A,
	36087 - 19968: jis0212<<14 | 0x3E<<7 | 0x1B,
	36088 - 19968: jis0212<<14 | 0x3E<<7 | 0x1C,
	36090 - 19968: jis0208<<14 | 0x4B<<7 | 0x30,
	36091 - 19968: jis0208<<14 | 0x4B<<7 | 0x31,
	36092 - 19968: jis0208<<14 | 0x18<<7 | 0x37,
	36093 - 19968: jis0208<<14 | 0x4B<<7 | 0x2F,
	36094 - 19968: jis0212<<14 | 0x3E<<7 | 0x1D,
	36095 - 19968: jis0212<<14 | 0x3E<<7 | 0x1E,
	36097 - 19968: jis0212<<14 | 0x3E<<7 | 0x1F,
	36099 - 19968: jis0212<<14 | 0x3E<<7 | 0x20,
	36100 - 19968: jis0208<<14 | 0x4B<<7 | 0x32,
	36101 - 19968: jis0208<<14 | 0x4B<<7 | 0x33,
	36103 - 19968: jis0208<<14 | 0x4B<<7 | 0x35,
	36104 - 19968: jis0208<<14 | 0x21<<7 | 0x02,
	36105 - 19968: jis0212<<14 | 0x3E<<7 | 0x21,
	36106 - 19968: jis0208<<14 | 0x4B<<7 | 0x34,
	36107 - 19968: jis0208<<14 | 0x13<<7 | 0x45,
	36109 - 19968: jis0208<<14 | 0x4B<<7 | 0x37,
	36111 - 19968: jis0208<<14 | 0x4B<<7 | 0x36,
	36112 - 19968: jis0208<<14 | 0x4B<<7 | 0x38,
	36114 - 19968: jis0208<<14 | 0x5A<<7 | 0x52,
	36115 - 19968: jis0208<<14 | 0x4B<<7 | 0x3A,
	36116 - 19968: jis0208<<14 | 0x4B<<7 | 0x3C,
	36118 - 19968: jis0208<<14 | 0x4B<<7 | 0x3D,
	36119 - 19968: jis0212<<14 | 0x3E<<7 | 0x23,
	36123 - 19968: jis0212<<14 | 0x3E<<7 | 0x24,
	36196 - 19968: jis0208<<14 | 0x1F<<7 | 0x35,
	36197 - 19968: jis0212<<14 | 0x3E<<7 | 0x25,
	36198 - 19968: jis0208<<14 | 0x1B<<7 | 0x2E,
	36199 - 19968: jis0208<<14 | 0x4B<<7 | 0x3E,
	36201 - 19968: jis0212<<14 | 0x3E<<7 | 0x26,
	36203 - 19968: jis0208<<14 | 0x12<<7 | 0x31,
	36204 - 19968: jis0212<<14 | 0x3E<<7 | 0x27,
	36205 - 19968: jis0208<<14 | 0x4B<<7 | 0x3F,
	36206 - 19968: jis0212<<14 | 0x3E<<7 | 0x28,
	36208 - 19968: jis0208<<14 | 0x20<<7 | 0x55,
	36209 - 19968: jis0208<<14 | 0x4B<<7 | 0x40,
	36211 - 19968: jis0208<<14 | 0x4B<<7 | 0x41,
	36212 - 19968: jis0208<<14 | 0x28<<7 | 0x4A,
	36214 - 19968: jis0208<<14 | 0x5A<<7 | 0x53,
	36215 - 19968: jis0208<<14 | 0x14<<7 | 0x0E,
	36223 - 19968: jis0212<<14 | 0x3E<<7 | 0x29,
	36225 - 19968: jis0208<<14 | 0x4B<<7 | 0x42,
	36226 - 19968: jis0212<<14 | 0x3E<<7 | 0x2A,
	36228 - 19968: jis0212<<14 | 0x3E<<7 | 0x2B,
	36229 - 19968: jis0208<<14 | 0x23<<7 | 0x15,
	36232 - 19968: jis0212<<14 | 0x3E<<7 | 0x2C,
	36234 - 19968: jis0208<<14 | 0x10<<7 | 0x3A,
	36237 - 19968: jis0212<<14 | 0x3E<<7 | 0x2D,
	36240 - 19968: jis0212<<14 | 0x3E<<7 | 0x2E,
	36241 - 19968: jis0212<<14 | 0x3E<<7 | 0x2F,
	36245 - 19968: jis0212<<14 | 0x3E<<7 | 0x30,
	36249 - 19968: jis0208<<14 | 0x4B<<7 | 0x43,
	36254 - 19968: jis0212<<14 | 0x3E<<7 | 0x31,
	36255 - 19968: jis0212<<14 | 0x3E<<7 | 0x32,
	36256 - 19968: jis0212<<14 | 0x3E<<7 | 0x33,
	36259 - 19968: jis0208<<14 | 0x1B<<7 | 0x50,
	36262 - 19968: jis0212<<14 | 0x3E<<7 | 0x34,
	36264 - 19968: jis0208<<14 | 0x1E<<7 | 0x55,
	36267 - 19968: jis0212<<14 | 0x3E<<7 | 0x35,
	36268 - 19968: jis0212<<14 | 0x3E<<7 | 0x36,
	36271 - 19968: jis0212<<14 | 0x3E<<7 | 0x37,
	36274 - 19968: jis0212<<14 | 0x3E<<7 | 0x38,
	36275 - 19968: jis0208<<14 | 0x21<<7 | 0x0C,
	36277 - 19968: jis0212<<14 | 0x3E<<7 | 0x39,
	36279 - 19968: jis0212<<14 | 0x3E<<7 | 0x3A,
	36281 - 19968: jis0212<<14 | 0x3E<<7 | 0x3B,
	36282 - 19968: jis0208<<14 | 0x4B<<7 | 0x46,
	36283 - 19968: jis0212<<14 | 0x3E<<7 | 0x3C,
	36284 - 19968: jis0212<<14 | 0x3E<<7 | 0x4E,
	36286 - 19968: jis0208<<14 | 0x4B<<7 | 0x45,
	36288 - 19968: jis0212<<14 | 0x3E<<7 | 0x3D,
	36290 - 19968: jis0208<<14 | 0x4B<<7 | 0x44,
	36293 - 19968: jis0212<<14 | 0x3E<<7 | 0x3E,
	36294 - 19968: jis0212<<14 | 0x3E<<7 | 0x3F,
	36295 - 19968: jis0212<<14 | 0x3E<<7 | 0x40,
	36296 - 19968: jis0212<<14 | 0x3E<<7 | 0x41,
	36298 - 19968: jis0212<<14 | 0x3E<<7 | 0x42,
	36299 - 19968: jis0208<<14 | 0x4B<<7 | 0x4C,
	36300 - 19968: jis0208<<14 | 0x4B<<7 | 0x4A,
	36302 - 19968: jis0212<<14 | 0x3E<<7 | 0x43,
	36303 - 19968: jis0208<<14 | 0x4B<<7 | 0x47,
	36305 - 19968: jis0212<<14 | 0x3E<<7 | 0x44,
	36308 - 19968: jis0212<<14 | 0x3E<<7 | 0x45,
	36309 - 19968: jis0212<<14 | 0x3E<<7 | 0x46,
	36310 - 19968: jis0208<<14 | 0x4B<<7 | 0x49,
	36311 - 19968: jis0212<<14 | 0x3E<<7 | 0x47,
	36313 - 19968: jis0212<<14 | 0x3E<<7 | 0x48,
	36314 - 19968: jis0208<<14 | 0x4B<<7 | 0x48,
	36315 - 19968: jis0208<<14 | 0x4B<<7 | 0x4B,
	36317 - 19968: jis0208<<14 | 0x14<<7 | 0x56,
	36319 - 19968: jis0208<<14 | 0x4B<<7 | 0x4F,
	36321 - 19968: jis0208<<14 | 0x1F<<7 | 0x36,
	36323 - 19968: jis0208<<14 | 0x4B<<7 | 0x50,
	36324 - 19968: jis0212<<14 | 0x3E<<7 | 0x49,
	36325 - 19968: jis0212<<14 | 0x3E<<7 | 0x4A,
	36327 - 19968: jis0212<<14 | 0x3E<<7 | 0x4B,
	36328 - 19968: jis0208<<14 | 0x17<<7 | 0x38,
	36330 - 19968: jis0208<<14 | 0x4B<<7 | 0x4D,
	36331 - 19968: jis0208<<14 | 0x4B<<7 | 0x4E,
	36332 - 19968: jis0212<<14 | 0x3E<<7 | 0x4C,
	36335 - 19968: jis0208<<14 | 0x2E<<7 | 0x08,
	36336 - 19968: jis0212<<14 | 0x3E<<7 | 0x4D,
	36337 - 19968: jis0212<<14 | 0x3E<<7 | 0x4F,
	36338 - 19968: jis0212<<14 | 0x3E<<7 | 0x50,
	36339 - 19968: jis0208<<14 | 0x23<<7 | 0x16,
	36340 - 19968: jis0212<<14 | 0x3E<<7 | 0x51,
	36341 - 19968: jis0208<<14 | 0x20<<7 | 0x08,
	36348 - 19968: jis0208<<14 | 0x4B<<7 | 0x51,
	36349 - 19968: jis0212<<14 | 0x3E<<7 | 0x52,
	36351 - 19968: jis0208<<14 | 0x4B<<7 | 0x54,
	36353 - 19968: jis0212<<14 | 0x3E<<7 | 0x53,
	36356 - 19968: jis0212<<14 | 0x3E<<7 | 0x54,
	36357 - 19968: jis0212<<14 | 0x3E<<7 | 0x55,
	36358 - 19968: jis0212<<14 | 0x3E<<7 | 0x56,
	36360 - 19968: jis0208<<14 | 0x4B<<7 | 0x52,
	36361 - 19968: jis0208<<14 | 0x4B<<7 | 0x53,
	36362 - 19968: jis0208<<14 | 0x2C<<7 | 0x38,
	36363 - 19968: jis0212<<14 | 0x3E<<7 | 0x57,
	36367 - 19968: jis0208<<14 | 0x25<<7 | 0x06,
	36368 - 19968: jis0208<<14 | 0x4B<<7 | 0x57,
	36369 - 19968: jis0212<<14 | 0x3E<<7 | 0x58,
	36372 - 19968: jis0212<<14 | 0x3E<<7 | 0x59,
	36374 - 19968: jis0212<<14 | 0x3E<<7 | 0x5A,
	36381 - 19968: jis0208<<14 | 0x4B<<7 | 0x55,
	36382 - 19968: jis0208<<14 | 0x4B<<7 | 0x56,
	36383 - 19968: jis0208<<14 | 0x4B<<7 | 0x58,
	36384 - 19968: jis0212<<14 | 0x3E<<7 | 0x5B,
	36385 - 19968: jis0212<<14 | 0x3E<<7 | 0x5C,
	36386 - 19968: jis0212<<14 | 0x3E<<7 | 0x5D,
	36387 - 19968: jis0212<<14 | 0x3F<<7 | 0x00,
	36390 - 19968: jis0212<<14 | 0x3F<<7 | 0x01,
	36391 - 19968: jis0212<<14 | 0x3F<<7 | 0x02,
	36394 - 19968: jis0208<<14 | 0x4C<<7 | 0x08,
	36400 - 19968: jis0208<<14 | 0x4B<<7 | 0x5B,
	36401 - 19968: jis0212<<14 | 0x3F<<7 | 0x03,
	36403 - 19968: jis0212<<14 | 0x3F<<7 | 0x04,
	36404 - 19968: jis0208<<14 | 0x4B<<7 | 0x5C,
	36405 - 19968: jis0208<<14 | 0x4B<<7 | 0x5A,
	36406 - 19968: jis0212<<14 | 0x3F<<7 | 0x05,
	36407 - 19968: jis0212<<14 | 0x3F<<7 | 0x06,
	36408 - 19968: jis0212<<14 | 0x3F<<7 | 0x07,
	36409 - 19968: jis0212<<14 | 0x3F<<7 | 0x08,
	36413 - 19968: jis0212<<14 | 0x3F<<7 | 0x09,
	36416 - 19968: jis0212<<14 | 0x3F<<7 | 0x0A,
	36417 - 19968: jis0212<<14 | 0x3F<<7 | 0x0B,
	36418 - 19968: jis0208<<14 | 0x4B<<7 | 0x59,
	36420 - 19968: jis0208<<14 | 0x23<<7 | 0x5C,
	36423 - 19968: jis0208<<14 | 0x4C<<7 | 0x00,
	36424 - 19968: jis0208<<14 | 0x4C<<7 | 0x04,
	36425 - 19968: jis0208<<14 | 0x4C<<7 | 0x01,
	36426 - 19968: jis0208<<14 | 0x4B<<7 | 0x5D,
	36427 - 19968: jis0212<<14 | 0x3F<<7 | 0x0C,
	36428 - 19968: jis0208<<14 | 0x4C<<7 | 0x02,
	36429 - 19968: jis0212<<14 | 0x3F<<7 | 0x0D,
	36430 - 19968: jis0212<<14 | 0x3F<<7 | 0x0E,
	36431 - 19968: jis0212<<14 | 0x3F<<7 | 0x0F,
	36432 - 19968: jis0208<<14 | 0x4C<<7 | 0x03,
	36436 - 19968: jis0212<<14 | 0x3F<<7 | 0x10,
	36437 - 19968: jis0208<<14 | 0x4C<<7 | 0x0A,
	36441 - 19968: jis0208<<14 | 0x4C<<7 | 0x05,
	36443 - 19968: jis0212<<14 | 0x3F<<7 | 0x11,
	36444 - 19968: jis0212<<14 | 0x3F<<7 | 0x12,
	36445 - 19968: jis0212<<14 | 0x3F<<7 | 0x13,
	36446 - 19968: jis0212<<14 | 0x3F<<7 | 0x14,
	36447 - 19968: jis0208<<14 | 0x1F<<7 | 0x37,
	36448 - 19968: jis0208<<14 | 0x4C<<7 | 0x07,
	36449 - 19968: jis0212<<14 | 0x3F<<7 | 0x15,
	36450 - 19968: jis0212<<14 | 0x3F<<7 | 0x16,
	36451 - 19968: jis0208<<14 | 0x4C<<7 | 0x09,
	36452 - 19968: jis0208<<14 | 0x4C<<7 | 0x06,
	36457 - 19968: jis0212<<14 | 0x3F<<7 | 0x17,
	36460 - 19968: jis0212<<14 | 0x3F<<7 | 0x18,
	36461 - 19968: jis0212<<14 | 0x3F<<7 | 0x19,
	36463 - 19968: jis0212<<14 | 0x3F<<7 | 0x1A,
	36464 - 19968: jis0212<<14 | 0x3F<<7 | 0x1B,
	36465 - 19968: jis0212<<14 | 0x3F<<7 | 0x1C,
	36466 - 19968: jis0208<<14 | 0x4C<<7 | 0x0C,
	36468 - 19968: jis0208<<14 | 0x1C<<7 | 0x12,
	36470 - 19968: jis0208<<14 | 0x4C<<7 | 0x0B,
	36473 - 19968: jis0212<<14 | 0x3F<<7 | 0x1D,
	36474 - 19968: jis0212<<14 | 0x3F<<7 | 0x1E,
	36475 - 19968: jis0212<<14 | 0x3F<<7 | 0x1F,
	36476 - 19968: jis0208<<14 | 0x4C<<7 | 0x0D,
	36481 - 19968: jis0208<<14 | 0x4C<<7 | 0x0E,
	36482 - 19968: jis0212<<14 | 0x3F<<7 | 0x20,
	36483 - 19968: jis0212<<14 | 0x3F<<7 | 0x21,
	36484 - 19968: jis0208<<14 | 0x4C<<7 | 0x11,
	36485 - 19968: jis0208<<14 | 0x4C<<7 | 0x10,
	36487 - 19968: jis0208<<14 | 0x4C<<7 | 0x0F,
	36489 - 19968: jis0212<<14 | 0x3F<<7 | 0x22,
	36490 - 19968: jis0208<<14 | 0x4C<<7 | 0x13,
	36491 - 19968: jis0208<<14 | 0x4C<<7 | 0x12,
	36493 - 19968: jis0208<<14 | 0x2B<<7 | 0x55,
	36496 - 19968: jis0212<<14 | 0x3F<<7 | 0x23,
	36497 - 19968: jis0208<<14 | 0x4C<<7 | 0x15,
	36498 - 19968: jis0212<<14 | 0x3F<<7 | 0x24,
	36499 - 19968: jis0208<<14 | 0x4C<<7 | 0x14,
	36500 - 19968: jis0208<<14 | 0x4C<<7 | 0x16,
	36501 - 19968: jis0212<<14 | 0x3F<<7 | 0x25,
	36505 - 19968: jis0208<<14 | 0x4C<<7 | 0x17,
	36506 - 19968: jis0212<<14 | 0x3F<<7 | 0x26,
	36507 - 19968: jis0212<<14 | 0x3F<<7 | 0x27,
	36509 - 19968: jis0212<<14 | 0x3F<<7 | 0x28,
	36510 - 19968: jis0212<<14 | 0x3F<<7 | 0x29,
	36513 - 19968: jis0208<<14 | 0x4C<<7 | 0x19,
	36514 - 19968: jis0212<<14 | 0x3F<<7 | 0x2A,
	36519 - 19968: jis0212<<14 | 0x3F<<7 | 0x2B,
	36521 - 19968: jis0212<<14 | 0x3F<<7 | 0x2C,
	36522 - 19968: jis0208<<14 | 0x4C<<7 | 0x18,
	36523 - 19968: jis0208<<14 | 0x1E<<7 | 0x27,
	36524 - 19968: jis0208<<14 | 0x4C<<7 | 0x1A,
	36525 - 19968: jis0212<<14 | 0x3F<<7 | 0x2D,
	36526 - 19968: jis0212<<14 | 0x3F<<7 | 0x2E,
	36527 - 19968: jis0208<<14 | 0x15<<7 | 0x4C,
	36528 - 19968: jis0208<<14 | 0x4C<<7 | 0x1B,
	36529 - 19968: jis0208<<14 | 0x4C<<7 | 0x1D,
	36531 - 19968: jis0212<<14 | 0x3F<<7 | 0x2F,
	36533 - 19968: jis0212<<14 | 0x3F<<7 | 0x30,
	36538 - 19968: jis0212<<14 | 0x3F<<7 | 0x31,
	36539 - 19968: jis0212<<14 | 0x3F<<7 | 0x32,
	36542 - 19968: jis0208<<14 | 0x4C<<7 | 0x1E,
	36544 - 19968: jis0212<<14 | 0x3F<<7 | 0x33,
	36545 - 19968: jis0212<<14 | 0x3F<<7 | 0x34,
	36547 - 19968: jis0212<<14 | 0x3F<<7 | 0x35,
	36548 - 19968: jis0212<<14 | 0x3F<<7 | 0x36,
	36549 - 19968: jis0208<<14 | 0x4C<<7 | 0x1F,
	36550 - 19968: jis0208<<14 | 0x4C<<7 | 0x1C,
	36551 - 19968: jis0212<<14 | 0x3F<<7 | 0x37,
	36552 - 19968: jis0208<<14 | 0x4C<<7 | 0x20,
	36554 - 19968: jis0208<<14 | 0x1B<<7 | 0x35,
	36555 - 19968: jis0208<<14 | 0x4C<<7 | 0x21,
	36556 - 19968: jis0208<<14 | 0x14<<7 | 0x0F,
	36557 - 19968: jis0208<<14 | 0x16<<7 | 0x12,
	36559 - 19968: jis0208<<14 | 0x5A<<7 | 0x55,
	36561 - 19968: jis0212<<14 | 0x3F<<7 | 0x39,
	36562 - 19968: jis0208<<14 | 0x17<<7 | 0x0D,
	36564 - 19968: jis0212<<14 | 0x3F<<7 | 0x3A,
	36571 - 19968: jis0208<<14 | 0x4C<<7 | 0x22,
	36572 - 19968: jis0212<<14 | 0x3F<<7 | 0x3B,
	36575 - 19968: jis0208<<14 | 0x25<<7 | 0x4F,
	36578 - 19968: jis0208<<14 | 0x24<<7 | 0x1D,
	36579 - 19968: jis0208<<14 | 0x4C<<7 | 0x23,
	36584 - 19968: jis0212<<14 | 0x3F<<7 | 0x3C,
	36587 - 19968: jis0208<<14 | 0x4C<<7 | 0x26,
	36589 - 19968: jis0212<<14 | 0x3F<<7 | 0x43,
	36590 - 19968: jis0212<<14 | 0x3F<<7 | 0x3D,
	36592 - 19968: jis0212<<14 | 0x3F<<7 | 0x3E,
	36593 - 19968: jis0212<<14 | 0x3F<<7 | 0x3F,
	36599 - 19968: jis0212<<14 | 0x3F<<7 | 0x40,
	36600 - 19968: jis0208<<14 | 0x1B<<7 | 0x13,
	36601 - 19968: jis0212<<14 | 0x3F<<7 | 0x41,
	36602 - 19968: jis0212<<14 | 0x3F<<7 | 0x42,
	36603 - 19968: jis0208<<14 | 0x4C<<7 | 0x25,
	36604 - 19968: jis0208<<14 | 0x4C<<7 | 0x24,
	36605 - 19968: jis0208<<14 | 0x16<<7 | 0x39,
	36606 - 19968: jis0208<<14 | 0x4C<<7 | 0x27,
	36608 - 19968: jis0212<<14 | 0x3F<<7 | 0x44,
	36610 - 19968: jis0212<<14 | 0x3F<<7 | 0x45,
	36611 - 19968: jis0208<<14 | 0x12<<7 | 0x32,
	36613 - 19968: jis0208<<14 | 0x4C<<7 | 0x29,
	36615 - 19968: jis0212<<14 | 0x3F<<7 | 0x46,
	36616 - 19968: jis0212<<14 | 0x3F<<7 | 0x47,
	36617 - 19968: jis0208<<14 | 0x19<<7 | 0x3B,
	36618 - 19968: jis0208<<14 | 0x4C<<7 | 0x28,
	36620 - 19968: jis0208<<14 | 0x4C<<7 | 0x31,
	36623 - 19968: jis0212<<14 | 0x3F<<7 | 0x48,
	36624 - 19968: jis0212<<14 | 0x3F<<7 | 0x49,
	36626 - 19968: jis0208<<14 | 0x4C<<7 | 0x2B,
	36627 - 19968: jis0208<<14 | 0x4C<<7 | 0x2D,
	36628 - 19968: jis0208<<14 | 0x29<<7 | 0x44,
	36629 - 19968: jis0208<<14 | 0x4C<<7 | 0x2A,
	36630 - 19968: jis0212<<14 | 0x3F<<7 | 0x4A,
	36631 - 19968: jis0212<<14 | 0x3F<<7 | 0x4B,
	36632 - 19968: jis0212<<14 | 0x3F<<7 | 0x4C,
	36633 - 19968: jis0208<<14 | 0x4C<<7 | 0x2C,
	36635 - 19968: jis0208<<14 | 0x4C<<7 | 0x30,
	36636 - 19968: jis0208<<14 | 0x4C<<7 | 0x2E,
	36637 - 19968: jis0208<<14 | 0x14<<7 | 0x10,
	36638 - 19968: jis0212<<14 | 0x3F<<7 | 0x4D,
	36639 - 19968: jis0208<<14 | 0x4C<<7 | 0x2F,
	36640 - 19968: jis0212<<14 | 0x3F<<7 | 0x4E,
	36641 - 19968: jis0212<<14 | 0x3F<<7 | 0x4F,
	36643 - 19968: jis0212<<14 | 0x3F<<7 | 0x50,
	36645 - 19968: jis0212<<14 | 0x3F<<7 | 0x51,
	36646 - 19968: jis0208<<14 | 0x4C<<7 | 0x32,
	36647 - 19968: jis0212<<14 | 0x3F<<7 | 0x52,
	36648 - 19968: jis0212<<14 | 0x3F<<7 | 0x53,
	36649 - 19968: jis0208<<14 | 0x26<<7 | 0x39,
	36650 - 19968: jis0208<<14 | 0x2D<<7 | 0x37,
	36652 - 19968: jis0212<<14 | 0x3F<<7 | 0x54,
	36653 - 19968: jis0212<<14 | 0x3F<<7 | 0x55,
	36654 - 19968: jis0212<<14 | 0x3F<<7 | 0x56,
	36655 - 19968: jis0208<<14 | 0x1C<<7 | 0x13,
	36659 - 19968: jis0208<<14 | 0x4C<<7 | 0x33,
	36660 - 19968: jis0212<<14 | 0x3F<<7 | 0x57,
	36661 - 19968: jis0212<<14 | 0x3F<<7 | 0x58,
	36662 - 19968: jis0212<<14 | 0x3F<<7 | 0x59,
	36663 - 19968: jis0212<<14 | 0x3F<<7 | 0x5A,
	36664 - 19968: jis0208<<14 | 0x2C<<7 | 0x01,
	36665 - 19968: jis0208<<14 | 0x4C<<7 | 0x35,
	36666 - 19968: jis0212<<14 | 0x3F<<7 | 0x5B,
	36667 - 19968: jis0208<<14 | 0x4C<<7 | 0x34,
	36670 - 19968: jis0208<<14 | 0x4C<<7 | 0x38,
	36671 - 19968: jis0208<<14 | 0x2C<<7 | 0x20,
	36672 - 19968: jis0212<<14 | 0x3F<<7 | 0x5C,
	36673 - 19968: jis0212<<14 | 0x3F<<7 | 0x5D,
	36674 - 19968: jis0208<<14 | 0x4C<<7 | 0x37,
	36675 - 19968: jis0212<<14 | 0x40<<7 | 0x00,
	36676 - 19968: jis0208<<14 | 0x12<<7 | 0x4C,
	36677 - 19968: jis0208<<14 | 0x4C<<7 | 0x36,
	36678 - 19968: jis0208<<14 | 0x4C<<7 | 0x3B,
	36679 - 19968: jis0212<<14 | 0x40<<7 | 0x01,
	36681 - 19968: jis0208<<14 | 0x4C<<7 | 0x3A,
	36684 - 19968: jis0208<<14 | 0x4C<<7 | 0x39,
	36685 - 19968: jis0208<<14 | 0x24<<7 | 0x11,
	36686 - 19968: jis0208<<14 | 0x4C<<7 | 0x3C,
	36687 - 19968: jis0212<<14 | 0x40<<7 | 0x02,
	36689 - 19968: jis0212<<14 | 0x40<<7 | 0x03,
	36690 - 19968: jis0212<<14 | 0x40<<7 | 0x04,
	36691 - 19968: jis0212<<14 | 0x40<<7 | 0x05,
	36692 - 19968: jis0212<<14 | 0x40<<7 | 0x06,
	36693 - 19968: jis0212<<14 | 0x40<<7 | 0x07,
	36695 - 19968: jis0208<<14 | 0x4C<<7 | 0x3D,
	36696 - 19968: jis0212<<14 | 0x40<<7 | 0x08,
	36700 - 19968: jis0208<<14 | 0x4C<<7 | 0x3E,
	36701 - 19968: jis0212<<14 | 0x40<<7 | 0x09,
	36702 - 19968: jis0212<<14 | 0x40<<7 | 0x0A,
	36703 - 19968: jis0208<<14 | 0x18<<7 | 0x4B,
	36705 - 19968: jis0208<<14 | 0x16<<7 | 0x04,
	36706 - 19968: jis0208<<14 | 0x4C<<7 | 0x3F,
	36707 - 19968: jis0208<<14 | 0x4C<<7 | 0x40,
	36708 - 19968: jis0208<<14 | 0x4C<<7 | 0x41,
	36709 - 19968: jis0212<<14 | 0x40<<7 | 0x0B,
	36763 - 19968: jis0208<<14 | 0x1E<<7 | 0x28,
	36764 - 19968: jis0208<<14 | 0x4C<<7 | 0x42,
	36765 - 19968: jis0212<<14 | 0x40<<7 | 0x0C,
	36766 - 19968: jis0208<<14 | 0x1B<<7 | 0x0C,
	36767 - 19968: jis0208<<14 | 0x4C<<7 | 0x43,
	36768 - 19968: jis0212<<14 | 0x40<<7 | 0x0D,
	36769 - 19968: jis0212<<14 | 0x40<<7 | 0x0E,
	36771 - 19968: jis0208<<14 | 0x4C<<7 | 0x44,
	36772 - 19968: jis0212<<14 | 0x40<<7 | 0x0F,
	36773 - 19968: jis0212<<14 | 0x40<<7 | 0x10,
	36774 - 19968: jis0212<<14 | 0x40<<7 | 0x11,
	36775 - 19968: jis0208<<14 | 0x31<<7 | 0x00,
	36776 - 19968: jis0208<<14 | 0x30<<7 | 0x5D,
	36781 - 19968: jis0208<<14 | 0x4C<<7 | 0x45,
	36782 - 19968: jis0208<<14 | 0x44<<7 | 0x4F,
	36783 - 19968: jis0208<<14 | 0x4C<<7 | 0x46,
	36784 - 19968: jis0208<<14 | 0x22<<7 | 0x03,
	36785 - 19968: jis0208<<14 | 0x1E<<7 | 0x0A,
	36786 - 19968: jis0208<<14 | 0x26<<7 | 0x1F,
	36789 - 19968: jis0212<<14 | 0x40<<7 | 0x12,
	36790 - 19968: jis0212<<14 | 0x40<<7 | 0x13,
	36791 - 19968: jis0208<<14 | 0x4C<<7 | 0x47,
	36792 - 19968: jis0212<<14 | 0x40<<7 | 0x14,
	36794 - 19968: jis0208<<14 | 0x29<<7 | 0x34,
	36795 - 19968: jis0208<<14 | 0x23<<7 | 0x33,
	36796 - 19968: jis0208<<14 | 0x18<<7 | 0x5D,
	36798 - 19968: jis0212<<14 | 0x40<<7 | 0x15,
	36799 - 19968: jis0208<<14 | 0x22<<7 | 0x08,
	36800 - 19968: jis0212<<14 | 0x40<<7 | 0x16,
	36801 - 19968: jis0212<<14 | 0x40<<7 | 0x17,
	36802 - 19968: jis0208<<14 | 0x10<<7 | 0x09,
	36804 - 19968: jis0208<<14 | 0x2A<<7 | 0x57,
	36805 - 19968: jis0208<<14 | 0x1E<<7 | 0x36,
	36806 - 19968: jis0212<<14 | 0x40<<7 | 0x18,
	36810 - 19968: jis0212<<14 | 0x40<<7 | 0x19,
	36811 - 19968: jis0212<<14 | 0x40<<7 | 0x1A,
	36813 - 19968: jis0212<<14 | 0x40<<7 | 0x1B,
	36814 - 19968: jis0208<<14 | 0x16<<7 | 0x3D,
	36816 - 19968: jis0212<<14 | 0x40<<7 | 0x1C,
	36817 - 19968: jis0208<<14 | 0x15<<7 | 0x40,
	36818 - 19968: jis0212<<14 | 0x40<<7 | 0x1D,
	36819 - 19968: jis0212<<14 | 0x40<<7 | 0x1E,
	36820 - 19968: jis0208<<14 | 0x29<<7 | 0x35,
	36821 - 19968: jis0212<<14 | 0x40<<7 | 0x1F,
	36826 - 19968: jis0208<<14 | 0x4C<<7 | 0x48,
	36832 - 19968: jis0212<<14 | 0x40<<7 | 0x20,
	36834 - 19968: jis0208<<14 | 0x4C<<7 | 0x4A,
	36835 - 19968: jis0212<<14 | 0x40<<7 | 0x21,
	36836 - 19968: jis0212<<14 | 0x40<<7 | 0x22,
	36837 - 19968: jis0208<<14 | 0x4C<<7 | 0x49,
	36838 - 19968: jis0208<<14 | 0x11<<7 | 0x3F,
	36840 - 19968: jis0212<<14 | 0x40<<7 | 0x23,
	36841 - 19968: jis0208<<14 | 0x25<<7 | 0x55,
	36842 - 19968: jis0208<<14 | 0x4C<<7 | 0x4B,
	36843 - 19968: jis0208<<14 | 0x26<<7 | 0x56,
	36845 - 19968: jis0208<<14 | 0x24<<7 | 0x12,
	36846 - 19968: jis0212<<14 | 0x40<<7 | 0x24,
	36847 - 19968: jis0208<<14 | 0x4C<<7 | 0x4C,
	36848 - 19968: jis0208<<14 | 0x1C<<7 | 0x31,
	36849 - 19968: jis0212<<14 | 0x40<<7 | 0x25,
	36852 - 19968: jis0208<<14 | 0x4C<<7 | 0x4E,
	36853 - 19968: jis0212<<14 | 0x40<<7 | 0x26,
	36854 - 19968: jis0212<<14 | 0x40<<7 | 0x27,
	36855 - 19968: jis0208<<14 | 0x2B<<7 | 0x21,
	36856 - 19968: jis0208<<14 | 0x4C<<7 | 0x5D,
	36857 - 19968: jis0208<<14 | 0x4C<<7 | 0x50,
	36858 - 19968: jis0208<<14 | 0x4C<<7 | 0x51,
	36859 - 19968: jis0212<<14 | 0x40<<7 | 0x28,
	36861 - 19968: jis0208<<14 | 0x23<<7 | 0x28,
	36862 - 19968: jis0212<<14 | 0x40<<7 | 0x29,
	36864 - 19968: jis0208<<14 | 0x21<<7 | 0x3F,
	36865 - 19968: jis0208<<14 | 0x20<<7 | 0x56,
	36866 - 19968: jis0212<<14 | 0x40<<7 | 0x2A,
	36867 - 19968: jis0208<<14 | 0x25<<7 | 0x07,
	36868 - 19968: jis0212<<14 | 0x40<<7 | 0x2B,
	36869 - 19968: jis0208<<14 | 0x4C<<7 | 0x4F,
	36870 - 19968: jis0208<<14 | 0x14<<7 | 0x34,
	36872 - 19968: jis0212<<14 | 0x40<<7 | 0x2C,
	36875 - 19968: jis0208<<14 | 0x4C<<7 | 0x58,
	36876 - 19968: jis0212<<14 | 0x40<<7 | 0x2D,
	36877 - 19968: jis0208<<14 | 0x4C<<7 | 0x55,
	36878 - 19968: jis0208<<14 | 0x4D<<7 | 0x04,
	36879 - 19968: jis0208<<14 | 0x25<<7 | 0x08,
	36880 - 19968: jis0208<<14 | 0x22<<7 | 0x3F,
	36881 - 19968: jis0208<<14 | 0x4C<<7 | 0x52,
	36883 - 19968: jis0208<<14 | 0x23<<7 | 0x5D,
	36884 - 19968: jis0208<<14 | 0x24<<7 | 0x32,
	36885 - 19968: jis0208<<14 | 0x4C<<7 | 0x53,
	36886 - 19968: jis0208<<14 | 0x4C<<7 | 0x57,
	36887 - 19968: jis0208<<14 | 0x1E<<7 | 0x3F,
	36888 - 19968: jis0212<<14 | 0x40<<7 | 0x2E,
	36889 - 19968: jis0208<<14 | 0x26<<7 | 0x46,
	36890 - 19968: jis0208<<14 | 0x23<<7 | 0x2B,
	36891 - 19968: jis0212<<14 | 0x40<<7 | 0x2F,
	36893 - 19968: jis0208<<14 | 0x1F<<7 | 0x21,
	36894 - 19968: jis0208<<14 | 0x4C<<7 | 0x56,
	36895 - 19968: jis0208<<14 | 0x21<<7 | 0x0D,
	36896 - 19968: jis0208<<14 | 0x21<<7 | 0x03,
	36897 - 19968: jis0208<<14 | 0x4C<<7 | 0x54,
	36898 - 19968: jis0208<<14 | 0x0F<<7 | 0x08,
	36899 - 19968: jis0208<<14 | 0x2E<<7 | 0x01,
	36903 - 19968: jis0208<<14 | 0x4C<<7 | 0x59,
	36904 - 19968: jis0212<<14 | 0x40<<7 | 0x30,
	36905 - 19968: jis0212<<14 | 0x40<<7 | 0x31,
	36906 - 19968: jis0212<<14 | 0x40<<7 | 0x33,
	36908 - 19968: jis0212<<14 | 0x40<<7 | 0x34,
	36909 - 19968: jis0212<<14 | 0x40<<7 | 0x35,
	36910 - 19968: jis0208<<14 | 0x21<<7 | 0x40,
	36911 - 19968: jis0212<<14 | 0x40<<7 | 0x32,
	36913 - 19968: jis0208<<14 | 0x1C<<7 | 0x14,
	36914 - 19968: jis0208<<14 | 0x1E<<7 | 0x29,
	36915 - 19968: jis0212<<14 | 0x40<<7 | 0x36,
	36916 - 19968: jis0212<<14 | 0x40<<7 | 0x37,
	36917 - 19968: jis0208<<14 | 0x4C<<7 | 0x5B,
	36918 - 19968: jis0208<<14 | 0x4C<<7 | 0x5A,
	36919 - 19968: jis0212<<14 | 0x40<<7 | 0x38,
	36920 - 19968: jis0208<<14 | 0x0F<<7 | 0x4E,
	36921 - 19968: jis0208<<14 | 0x4C<<7 | 0x5C,
	36924 - 19968: jis0208<<14 | 0x28<<7 | 0x0E,
	36926 - 19968: jis0208<<14 | 0x4D<<7 | 0x06,
	36927 - 19968: jis0212<<14 | 0x40<<7 | 0x39,
	36929 - 19968: jis0208<<14 | 0x25<<7 | 0x3A,
	36930 - 19968: jis0208<<14 | 0x1E<<7 | 0x4A,
	36931 - 19968: jis0212<<14 | 0x40<<7 | 0x3A,
	36932 - 19968: jis0212<<14 | 0x40<<7 | 0x3B,
	36933 - 19968: jis0208<<14 | 0x22<<7 | 0x38,
	36935 - 19968: jis0208<<14 | 0x15<<7 | 0x57,
	36937 - 19968: jis0208<<14 | 0x4D<<7 | 0x05,
	36938 - 19968: jis0208<<14 | 0x2C<<7 | 0x16,
	36939 - 19968: jis0208<<14 | 0x10<<7 | 0x1E,
	36940 - 19968: jis0212<<14 | 0x40<<7 | 0x3C,
	36941 - 19968: jis0208<<14 | 0x29<<7 | 0x36,
	36942 - 19968: jis0208<<14 | 0x11<<7 | 0x40,
	36943 - 19968: jis0208<<14 | 0x4D<<7 | 0x00,
	36944 - 19968: jis0208<<14 | 0x4D<<7 | 0x01,
	36945 - 19968: jis0208<<14 | 0x4D<<7 | 0x02,
	36946 - 19968: jis0208<<14 | 0x4D<<7 | 0x03,
	36947 - 19968: jis0208<<14 | 0x25<<7 | 0x1A,
	36948 - 19968: jis0208<<14 | 0x22<<7 | 0x02,
	36949 - 19968: jis0208<<14 | 0x0F<<7 | 0x42,
	36950 - 19968: jis0208<<14 | 0x4D<<7 | 0x07,
	36952 - 19968: jis0208<<14 | 0x4D<<7 | 0x08,
	36953 - 19968: jis0208<<14 | 0x53<<7 | 0x02,
	36955 - 19968: jis0212<<14 | 0x40<<7 | 0x3D,
	36956 - 19968: jis0208<<14 | 0x21<<7 | 0x1C,
	36957 - 19968: jis0212<<14 | 0x40<<7 | 0x3E,
	36958 - 19968: jis0208<<14 | 0x4D<<7 | 0x09,
	36960 - 19968: jis0208<<14 | 0x10<<7 | 0x52,
	36961 - 19968: jis0208<<14 | 0x20<<7 | 0x2B,
	36962 - 19968: jis0212<<14 | 0x40<<7 | 0x3F,
	36963 - 19968: jis0208<<14 | 0x17<<7 | 0x0E,
	36965 - 19968: jis0208<<14 | 0x2C<<7 | 0x39,
	36966 - 19968: jis0212<<14 | 0x40<<7 | 0x40,
	36967 - 19968: jis0208<<14 | 0x5A<<7 | 0x58,
	36968 - 19968: jis0208<<14 | 0x4D<<7 | 0x0A,
	36969 - 19968: jis0208<<14 | 0x24<<7 | 0x0B,
	36972 - 19968: jis0212<<14 | 0x40<<7 | 0x42,
	36973 - 19968: jis0208<<14 | 0x20<<7 | 0x57,
	36974 - 19968: jis0208<<14 | 0x1B<<7 | 0x36,
	36975 - 19968: jis0208<<14 | 0x4D<<7 | 0x0B,
	36976 - 19968: jis0212<<14 | 0x40<<7 | 0x43,
	36978 - 19968: jis0208<<14 | 0x4D<<7 | 0x0E,
	36980 - 19968: jis0212<<14 | 0x40<<7 | 0x44,
	36981 - 19968: jis0208<<14 | 0x1C<<7 | 0x44,
	36982 - 19968: jis0208<<14 | 0x4D<<7 | 0x0C,
	36983 - 19968: jis0208<<14 | 0x20<<7 | 0x0A,
	36984 - 19968: jis0208<<14 | 0x20<<7 | 0x09,
	36985 - 19968: jis0212<<14 | 0x40<<7 | 0x45,
	36986 - 19968: jis0208<<14 | 0x0F<<7 | 0x43,
	36988 - 19968: jis0208<<14 | 0x2D<<7 | 0x2A,
	36989 - 19968: jis0208<<14 | 0x4D<<7 | 0x10,
	36991 - 19968: jis0208<<14 | 0x27<<7 | 0x51,
	36992 - 19968: jis0208<<14 | 0x4D<<7 | 0x12,
	36993 - 19968: jis0208<<14 | 0x4D<<7 | 0x11,
	36994 - 19968: jis0208<<14 | 0x4D<<7 | 0x0F,
	36995 - 19968: jis0208<<14 | 0x42<<7 | 0x43,
	36996 - 19968: jis0208<<14 | 0x13<<7 | 0x33,
	36997 - 19968: jis0212<<14 | 0x40<<7 | 0x46,
	36999 - 19968: jis0208<<14 | 0x4C<<7 | 0x4D,
	37000 - 19968: jis0212<<14 | 0x40<<7 | 0x47,
	37001 - 19968: jis0208<<14 | 0x4D<<7 | 0x14,
	37002 - 19968: jis0208<<14 | 0x4D<<7 | 0x13,
	37003 - 19968: jis0212<<14 | 0x40<<7 | 0x48,
	37004 - 19968: jis0212<<14 | 0x40<<7 | 0x49,
	37006 - 19968: jis0212<<14 | 0x40<<7 | 0x4A,
	37007 - 19968: jis0208<<14 | 0x4D<<7 | 0x15,
	37008 - 19968: jis0212<<14 | 0x40<<7 | 0x4B,
	37009 - 19968: jis0208<<14 | 0x2C<<7 | 0x17,
	37013 - 19968: jis0212<<14 | 0x40<<7 | 0x4C,
	37015 - 19968: jis0212<<14 | 0x40<<7 | 0x4D,
	37016 - 19968: jis0212<<14 | 0x40<<7 | 0x4E,
	37017 - 19968: jis0212<<14 | 0x40<<7 | 0x4F,
	37019 - 19968: jis0212<<14 | 0x40<<7 | 0x50,
	37024 - 19968: jis0212<<14 | 0x40<<7 | 0x51,
	37025 - 19968: jis0212<<14 | 0x40<<7 | 0x52,
	37026 - 19968: jis0212<<14 | 0x40<<7 | 0x53,
	37027 - 19968: jis0208<<14 | 0x25<<7 | 0x40,
	37029 - 19968: jis0212<<14 | 0x40<<7 | 0x54,
	37030 - 19968: jis0208<<14 | 0x2A<<7 | 0x0D,
	37032 - 19968: jis0208<<14 | 0x4D<<7 | 0x16,
	37034 - 19968: jis0208<<14 | 0x1B<<7 | 0x38,
	37039 - 19968: jis0208<<14 | 0x4D<<7 | 0x17,
	37040 - 19968: jis0212<<14 | 0x40<<7 | 0x55,
	37041 - 19968: jis0208<<14 | 0x4D<<7 | 0x18,
	37042 - 19968: jis0212<<14 | 0x40<<7 | 0x56,
	37043 - 19968: jis0212<<14 | 0x40<<7 | 0x57,
	37044 - 19968: jis0212<<14 | 0x40<<7 | 0x58,
	37045 - 19968: jis0208<<14 | 0x4D<<7 | 0x19,
	37046 - 19968: jis0212<<14 | 0x40<<7 | 0x59,
	37048 - 19968: jis0208<<14 | 0x24<<7 | 0x00,
	37053 - 19968: jis0212<<14 | 0x40<<7 | 0x5A,
	37054 - 19968: jis0212<<14 | 0x40<<7 | 0x5C,
	37057 - 19968: jis0208<<14 | 0x0F<<7 | 0x49,
	37059 - 19968: jis0212<<14 | 0x40<<7 | 0x5D,
	37060 - 19968: jis0212<<14 | 0x41<<7 | 0x00,
	37061 - 19968: jis0212<<14 | 0x41<<7 | 0x01,
	37063 - 19968: jis0212<<14 | 0x41<<7 | 0x02,
	37064 - 19968: jis0212<<14 | 0x41<<7 | 0x03,
	37066 - 19968: jis0208<<14 | 0x18<<7 | 0x38,
	37068 - 19968: jis0212<<14 | 0x40<<7 | 0x5B,
	37070 - 19968: jis0208<<14 | 0x2E<<7 | 0x19,
	37074 - 19968: jis0212<<14 | 0x41<<7 | 0x0C,
	37077 - 19968: jis0212<<14 | 0x41<<7 | 0x04,
	37079 - 19968: jis0212<<14 | 0x41<<7 | 0x05,
	37080 - 19968: jis0212<<14 | 0x41<<7 | 0x06,
	37081 - 19968: jis0212<<14 | 0x41<<7 | 0x07,
	37083 - 19968: jis0208<<14 | 0x4D<<7 | 0x1D,
	37084 - 19968: jis0212<<14 | 0x41<<7 | 0x08,
	37085 - 19968: jis0212<<14 | 0x41<<7 | 0x09,
	37086 - 19968: jis0208<<14 | 0x5A<<7 | 0x59,
	37087 - 19968: jis0212<<14 | 0x41<<7 | 0x0A,
	37089 - 19968: jis0208<<14 | 0x16<<7 | 0x13,
	37090 - 19968: jis0208<<14 | 0x4D<<7 | 0x1A,
	37092 - 19968: jis0208<<14 | 0x4D<<7 | 0x1B,
	37093 - 19968: jis0212<<14 | 0x41<<7 | 0x0B,
	37096 - 19968: jis0208<<14 | 0x28<<7 | 0x53,
	37099 - 19968: jis0212<<14 | 0x41<<7 | 0x0E,
	37101 - 19968: jis0208<<14 | 0x12<<7 | 0x33,
	37103 - 19968: jis0212<<14 | 0x41<<7 | 0x0F,
	37104 - 19968: jis0212<<14 | 0x41<<7 | 0x10,
	37108 - 19968: jis0212<<14 | 0x41<<7 | 0x11,
	37109 - 19968: jis0208<<14 | 0x2C<<7 | 0x18,
	37110 - 19968: jis0212<<14 | 0x41<<7 | 0x0D,
	37111 - 19968: jis0208<<14 | 0x15<<7 | 0x1E,
	37117 - 19968: jis0208<<14 | 0x24<<7 | 0x33,
	37118 - 19968: jis0212<<14 | 0x41<<7 | 0x12,
	37119 - 19968: jis0212<<14 | 0x41<<7 | 0x13,
	37120 - 19968: jis0212<<14 | 0x41<<7 | 0x14,
	37122 - 19968: jis0208<<14 | 0x4D<<7 | 0x1E,
	37124 - 19968: jis0212<<14 | 0x41<<7 | 0x15,
	37125 - 19968: jis0212<<14 | 0x41<<7 | 0x16,
	37126 - 19968: jis0212<<14 | 0x41<<7 | 0x17,
	37128 - 19968: jis0212<<14 | 0x41<<7 | 0x18,
	37133 - 19968: jis0212<<14 | 0x41<<7 | 0x19,
	37136 - 19968: jis0212<<14 | 0x41<<7 | 0x1A,
	37138 - 19968: jis0208<<14 | 0x4D<<7 | 0x1F,
	37140 - 19968: jis0212<<14 | 0x41<<7 | 0x1B,
	37141 - 19968: jis0208<<14 | 0x5A<<7 | 0x5B,
	37142 - 19968: jis0212<<14 | 0x41<<7 | 0x1C,
	37143 - 19968: jis0212<<14 | 0x41<<7 | 0x1D,
	37144 - 19968: jis0212<<14 | 0x41<<7 | 0x1E,
	37145 - 19968: jis0208<<14 | 0x4D<<7 | 0x20,
	37146 - 19968: jis0212<<14 | 0x41<<7 | 0x1F,
	37148 - 19968: jis0212<<14 | 0x41<<7 | 0x20,
	37150 - 19968: jis0212<<14 | 0x41<<7 | 0x21,
	37152 - 19968: jis0212<<14 | 0x41<<7 | 0x22,
	37154 - 19968: jis0212<<14 | 0x41<<7 | 0x24,
	37155 - 19968: jis0212<<14 | 0x41<<7 | 0x25,
	37157 - 19968: jis0212<<14 | 0x41<<7 | 0x23,
	37159 - 19968: jis0208<<14 | 0x5A<<7 | 0x5C,
	37161 - 19968: jis0212<<14 | 0x41<<7 | 0x27,
	37165 - 19968: jis0208<<14 | 0x24<<7 | 0x01,
	37166 - 19968: jis0212<<14 | 0x41<<7 | 0x28,
	37167 - 19968: jis0212<<14 | 0x41<<7 | 0x29,
	37168 - 19968: jis0208<<14 | 0x4D<<7 | 0x22,
	37169 - 19968: jis0212<<14 | 0x41<<7 | 0x2A,
	37170 - 19968: jis0208<<14 | 0x4D<<7 | 0x21,
	37172 - 19968: jis0212<<14 | 0x41<<7 | 0x2B,
	37174 - 19968: jis0212<<14 | 0x41<<7 | 0x2C,
	37175 - 19968: jis0212<<14 | 0x41<<7 | 0x2D,
	37177 - 19968: jis0212<<14 | 0x41<<7 | 0x2E,
	37178 - 19968: jis0212<<14 | 0x41<<7 | 0x2F,
	37180 - 19968: jis0212<<14 | 0x41<<7 | 0x30,
	37181 - 19968: jis0212<<14 | 0x41<<7 | 0x31,
	37187 - 19968: jis0212<<14 | 0x41<<7 | 0x32,
	37191 - 19968: jis0212<<14 | 0x41<<7 | 0x33,
	37192 - 19968: jis0212<<14 | 0x41<<7 | 0x34,
	37193 - 19968: jis0208<<14 | 0x25<<7 | 0x32,
	37194 - 19968: jis0208<<14 | 0x4D<<7 | 0x23,
	37195 - 19968: jis0208<<14 | 0x1C<<7 | 0x15,
	37196 - 19968: jis0208<<14 | 0x1B<<7 | 0x3F,
	37197 - 19968: jis0208<<14 | 0x26<<7 | 0x3A,
	37198 - 19968: jis0208<<14 | 0x22<<7 | 0x50,
	37199 - 19968: jis0212<<14 | 0x41<<7 | 0x35,
	37202 - 19968: jis0208<<14 | 0x1B<<7 | 0x51,
	37203 - 19968: jis0212<<14 | 0x41<<7 | 0x36,
	37204 - 19968: jis0208<<14 | 0x1E<<7 | 0x4B,
	37206 - 19968: jis0208<<14 | 0x4D<<7 | 0x24,
	37207 - 19968: jis0212<<14 | 0x41<<7 | 0x37,
	37208 - 19968: jis0208<<14 | 0x4D<<7 | 0x25,
	37209 - 19968: jis0212<<14 | 0x41<<7 | 0x38,
	37210 - 19968: jis0212<<14 | 0x41<<7 | 0x39,
	37211 - 19968: jis0212<<14 | 0x41<<7 | 0x3A,
	37217 - 19968: jis0212<<14 | 0x41<<7 | 0x3B,
	37218 - 19968: jis0208<<14 | 0x1E<<7 | 0x3C,
	37219 - 19968: jis0208<<14 | 0x4D<<7 | 0x26,
	37220 - 19968: jis0212<<14 | 0x41<<7 | 0x3C,
	37221 - 19968: jis0208<<14 | 0x4D<<7 | 0x27,
	37223 - 19968: jis0212<<14 | 0x41<<7 | 0x3D,
	37225 - 19968: jis0208<<14 | 0x4D<<7 | 0x28,
	37226 - 19968: jis0208<<14 | 0x2C<<7 | 0x4E,
	37228 - 19968: jis0208<<14 | 0x1C<<7 | 0x16,
	37229 - 19968: jis0212<<14 | 0x41<<7 | 0x3E,
	37234 - 19968: jis0208<<14 | 0x4D<<7 | 0x2A,
	37235 - 19968: jis0208<<14 | 0x4D<<7 | 0x29,
	37236 - 19968: jis0212<<14 | 0x41<<7 | 0x3F,
	37237 - 19968: jis0208<<14 | 0x18<<7 | 0x39,
	37239 - 19968: jis0208<<14 | 0x18<<7 | 0x52,
	37240 - 19968: jis0208<<14 | 0x1A<<7 | 0x1F,
	37241 - 19968: jis0212<<14 | 0x41<<7 | 0x40,
	37242 - 19968: jis0212<<14 | 0x41<<7 | 0x41,
	37243 - 19968: jis0212<<14 | 0x41<<7 | 0x42,
	37249 - 19968: jis0212<<14 | 0x41<<7 | 0x43,
	37250 - 19968: jis0208<<14 | 0x4D<<7 | 0x2D,
	37251 - 19968: jis0212<<14 | 0x41<<7 | 0x44,
	37253 - 19968: jis0212<<14 | 0x41<<7 | 0x45,
	37254 - 19968: jis0212<<14 | 0x41<<7 | 0x46,
	37255 - 19968: jis0208<<14 | 0x1C<<7 | 0x45,
	37257 - 19968: jis0208<<14 | 0x4D<<7 | 0x2C,
	37258 - 19968: jis0212<<14 | 0x41<<7 | 0x47,
	37259 - 19968: jis0208<<14 | 0x4D<<7 | 0x2B,
	37261 - 19968: jis0208<<14 | 0x21<<7 | 0x48,
	37262 - 19968: jis0212<<14 | 0x41<<7 | 0x48,
	37264 - 19968: jis0208<<14 | 0x17<<7 | 0x4E,
	37265 - 19968: jis0212<<14 | 0x41<<7 | 0x49,
	37266 - 19968: jis0208<<14 | 0x1F<<7 | 0x22,
	37267 - 19968: jis0212<<14 | 0x41<<7 | 0x4A,
	37268 - 19968: jis0212<<14 | 0x41<<7 | 0x4B,
	37269 - 19968: jis0212<<14 | 0x41<<7 | 0x4C,
	37271 - 19968: jis0208<<14 | 0x27<<7 | 0x0F,
	37272 - 19968: jis0212<<14 | 0x41<<7 | 0x4D,
	37276 - 19968: jis0208<<14 | 0x1C<<7 | 0x18,
	37278 - 19968: jis0212<<14 | 0x41<<7 | 0x4E,
	37281 - 19968: jis0212<<14 | 0x41<<7 | 0x4F,
	37282 - 19968: jis0208<<14 | 0x4D<<7 | 0x2E,
	37284 - 19968: jis0208<<14 | 0x1D<<7 | 0x3E,
	37286 - 19968: jis0212<<14 | 0x41<<7 | 0x50,
	37288 - 19968: jis0212<<14 | 0x41<<7 | 0x51,
	37290 - 19968: jis0208<<14 | 0x4D<<7 | 0x31,
	37291 - 19968: jis0208<<14 | 0x4D<<7 | 0x2F,
	37292 - 19968: jis0212<<14 | 0x41<<7 | 0x52,
	37293 - 19968: jis0212<<14 | 0x41<<7 | 0x53,
	37294 - 19968: jis0212<<14 | 0x41<<7 | 0x54,
	37295 - 19968: jis0208<<14 | 0x4D<<7 | 0x30,
	37296 - 19968: jis0212<<14 | 0x41<<7 | 0x55,
	37297 - 19968: jis0212<<14 | 0x41<<7 | 0x56,
	37298 - 19968: jis0212<<14 | 0x41<<7 | 0x57,
	37299 - 19968: jis0212<<14 | 0x41<<7 | 0x58,
	37300 - 19968: jis0208<<14 | 0x4D<<7 | 0x33,
	37301 - 19968: jis0208<<14 | 0x4D<<7 | 0x32,
	37302 - 19968: jis0212<<14 | 0x41<<7 | 0x59,
	37304 - 19968: jis0208<<14 | 0x1D<<7 | 0x59,
	37306 - 19968: jis0208<<14 | 0x4D<<7 | 0x34,
	37307 - 19968: jis0212<<14 | 0x41<<7 | 0x5A,
	37308 - 19968: jis0212<<14 | 0x41<<7 | 0x5B,
	37309 - 19968: jis0212<<14 | 0x41<<7 | 0x5C,
	37311 - 19968: jis0212<<14 | 0x41<<7 | 0x5D,
	37312 - 19968: jis0208<<14 | 0x4D<<7 | 0x35,
	37313 - 19968: jis0208<<14 | 0x4D<<7 | 0x36,
	37314 - 19968: jis0212<<14 | 0x42<<7 | 0x00,
	37315 - 19968: jis0212<<14 | 0x42<<7 | 0x01,
	37317 - 19968: jis0212<<14 | 0x42<<7 | 0x02,
	37318 - 19968: jis0208<<14 | 0x27<<7 | 0x2F,
	37319 - 19968: jis0208<<14 | 0x19<<7 | 0x32,
	37320 - 19968: jis0208<<14 | 0x1B<<7 | 0x40,
	37321 - 19968: jis0208<<14 | 0x4D<<7 | 0x37,
	37323 - 19968: jis0208<<14 | 0x4D<<7 | 0x38,
	37324 - 19968: jis0208<<14 | 0x2D<<7 | 0x03,
	37325 - 19968: jis0208<<14 | 0x1C<<7 | 0x24,
	37326 - 19968: jis0208<<14 | 0x2B<<7 | 0x4D,
	37327 - 19968: jis0208<<14 | 0x2D<<7 | 0x2B,
	37328 - 19968: jis0208<<14 | 0x4D<<7 | 0x39,
	37329 - 19968: jis0208<<14 | 0x15<<7 | 0x41,
	37331 - 19968: jis0212<<14 | 0x42<<7 | 0x03,
	37332 - 19968: jis0212<<14 | 0x42<<7 | 0x04,
	37334 - 19968: jis0208<<14 | 0x4D<<7 | 0x3A,
	37335 - 19968: jis0208<<14 | 0x5B<<7 | 0x00,
	37336 - 19968: jis0208<<14 | 0x24<<7 | 0x02,
	37337 - 19968: jis0212<<14 | 0x42<<7 | 0x06,
	37338 - 19968: jis0208<<14 | 0x5A<<7 | 0x5D,
	37339 - 19968: jis0208<<14 | 0x4D<<7 | 0x3D,
	37340 - 19968: jis0208<<14 | 0x12<<7 | 0x57,
	37341 - 19968: jis0208<<14 | 0x1E<<7 | 0x2A,
	37342 - 19968: jis0208<<14 | 0x5B<<7 | 0x01,
	37343 - 19968: jis0208<<14 | 0x4D<<7 | 0x3B,
	37345 - 19968: jis0208<<14 | 0x4D<<7 | 0x3C,
	37347 - 19968: jis0208<<14 | 0x23<<7 | 0x3F,
	37348 - 19968: jis0208<<14 | 0x5B<<7 | 0x04,
	37349 - 19968: jis0208<<14 | 0x5B<<7 | 0x05,
	37350 - 19968: jis0208<<14 | 0x2A<<7 | 0x34,
	37351 - 19968: jis0208<<14 | 0x15<<7 | 0x5B,
	37353 - 19968: jis0212<<14 | 0x42<<7 | 0x0B,
	37354 - 19968: jis0212<<14 | 0x42<<7 | 0x0C,
	37356 - 19968: jis0212<<14 | 0x42<<7 | 0x0D,
	37357 - 19968: jis0208<<14 | 0x5B<<7 | 0x02,
	37358 - 19968: jis0208<<14 | 0x5B<<7 | 0x03,
	37359 - 19968: jis0212<<14 | 0x42<<7 | 0x10,
	37360 - 19968: jis0212<<14 | 0x42<<7 | 0x11,
	37361 - 19968: jis0212<<14 | 0x42<<7 | 0x12,
	37365 - 19968: jis0208<<14 | 0x4D<<7 | 0x3F,
	37366 - 19968: jis0208<<14 | 0x4D<<7 | 0x40,
	37367 - 19968: jis0212<<14 | 0x42<<7 | 0x13,
	37369 - 19968: jis0212<<14 | 0x42<<7 | 0x14,
	37371 - 19968: jis0212<<14 | 0x42<<7 | 0x15,
	37372 - 19968: jis0208<<14 | 0x4D<<7 | 0x3E,
	37373 - 19968: jis0212<<14 | 0x42<<7 | 0x16,
	37375 - 19968: jis0208<<14 | 0x4D<<7 | 0x42,
	37376 - 19968: jis0212<<14 | 0x42<<7 | 0x17,
	37377 - 19968: jis0212<<14 | 0x42<<7 | 0x18,
	37380 - 19968: jis0212<<14 | 0x42<<7 | 0x19,
	37381 - 19968: jis0212<<14 | 0x42<<7 | 0x1A,
	37382 - 19968: jis0208<<14 | 0x5B<<7 | 0x06,
	37383 - 19968: jis0212<<14 | 0x42<<7 | 0x1C,
	37385 - 19968: jis0212<<14 | 0x42<<7 | 0x1D,
	37386 - 19968: jis0208<<14 | 0x5B<<7 | 0x08,
	37388 - 19968: jis0212<<14 | 0x42<<7 | 0x1F,
	37389 - 19968: jis0208<<14 | 0x25<<7 | 0x3E,
	37390 - 19968: jis0208<<14 | 0x12<<7 | 0x22,
	37392 - 19968: jis0208<<14 | 0x5B<<7 | 0x07,
	37393 - 19968: jis0208<<14 | 0x4D<<7 | 0x46,
	37394 - 19968: jis0212<<14 | 0x42<<7 | 0x21,
	37395 - 19968: jis0212<<14 | 0x42<<7 | 0x22,
	37396 - 19968: jis0208<<14 | 0x4D<<7 | 0x43,
	37397 - 19968: jis0208<<14 | 0x4D<<7 | 0x45,
	37398 - 19968: jis0212<<14 | 0x42<<7 | 0x23,
	37400 - 19968: jis0212<<14 | 0x42<<7 | 0x24,
	37404 - 19968: jis0212<<14 | 0x42<<7 | 0x25,
	37405 - 19968: jis0212<<14 | 0x42<<7 | 0x26,
	37406 - 19968: jis0208<<14 | 0x4D<<7 | 0x41,
	37411 - 19968: jis0212<<14 | 0x42<<7 | 0x27,
	37412 - 19968: jis0212<<14 | 0x42<<7 | 0x28,
	37413 - 19968: jis0212<<14 | 0x42<<7 | 0x29,
	37414 - 19968: jis0212<<14 | 0x42<<7 | 0x2A,
	37416 - 19968: jis0212<<14 | 0x42<<7 | 0x2B,
	37417 - 19968: jis0208<<14 | 0x4E<<7 | 0x2E,
	37420 - 19968: jis0208<<14 | 0x4D<<7 | 0x44,
	37422 - 19968: jis0212<<14 | 0x42<<7 | 0x2C,
	37423 - 19968: jis0212<<14 | 0x42<<7 | 0x2D,
	37424 - 19968: jis0212<<14 | 0x42<<7 | 0x2E,
	37427 - 19968: jis0212<<14 | 0x42<<7 | 0x2F,
	37428 - 19968: jis0208<<14 | 0x2D<<7 | 0x4A,
	37429 - 19968: jis0212<<14 | 0x42<<7 | 0x30,
	37430 - 19968: jis0212<<14 | 0x42<<7 | 0x31,
	37431 - 19968: jis0208<<14 | 0x17<<7 | 0x39,
	37432 - 19968: jis0212<<14 | 0x42<<7 | 0x32,
	37433 - 19968: jis0208<<14 | 0x5B<<7 | 0x0F,
	37434 - 19968: jis0208<<14 | 0x5B<<7 | 0x09,
	37436 - 19968: jis0208<<14 | 0x5B<<7 | 0x0B,
	37438 - 19968: jis0212<<14 | 0x42<<7 | 0x36,
	37439 - 19968: jis0208<<14 | 0x4D<<7 | 0x4E,
	37440 - 19968: jis0208<<14 | 0x5B<<7 | 0x0A,
	37442 - 19968: jis0212<<14 | 0x42<<7 | 0x38,
	37443 - 19968: jis0212<<14 | 0x42<<7 | 0x39,
	37444 - 19968: jis0208<<14 | 0x24<<7 | 0x13,
	37445 - 19968: jis0208<<14 | 0x4D<<7 | 0x49,
	37446 - 19968: jis0212<<14 | 0x42<<7 | 0x3A,
	37447 - 19968: jis0212<<14 | 0x42<<7 | 0x3B,
	37448 - 19968: jis0208<<14 | 0x4D<<7 | 0x4C,
	37449 - 19968: jis0208<<14 | 0x4D<<7 | 0x4A,
	37450 - 19968: jis0212<<14 | 0x42<<7 | 0x3C,
	37451 - 19968: jis0208<<14 | 0x4D<<7 | 0x4F,
	37453 - 19968: jis0212<<14 | 0x42<<7 | 0x3D,
	37454 - 19968: jis0208<<14 | 0x5B<<7 | 0x0C,
	37455 - 19968: jis0212<<14 | 0x42<<7 | 0x3F,
	37456 - 19968: jis0208<<14 | 0x4D<<7 | 0x50,
	37457 - 19968: jis0208<<14 | 0x5B<<7 | 0x0E,
	37463 - 19968: jis0208<<14 | 0x4D<<7 | 0x48,
	37464 - 19968: jis0212<<14 | 0x42<<7 | 0x41,
	37465 - 19968: jis0208<<14 | 0x5B<<7 | 0x0D,
	37466 - 19968: jis0208<<14 | 0x4D<<7 | 0x55,
	37467 - 19968: jis0208<<14 | 0x10<<7 | 0x53,
	37468 - 19968: jis0212<<14 | 0x42<<7 | 0x43,
	37469 - 19968: jis0212<<14 | 0x42<<7 | 0x44,
	37470 - 19968: jis0208<<14 | 0x4D<<7 | 0x47,
	37472 - 19968: jis0212<<14 | 0x42<<7 | 0x45,
	37473 - 19968: jis0212<<14 | 0x42<<7 | 0x46,
	37474 - 19968: jis0208<<14 | 0x27<<7 | 0x0C,
	37476 - 19968: jis0208<<14 | 0x4D<<7 | 0x4B,
	37477 - 19968: jis0212<<14 | 0x42<<7 | 0x47,
	37478 - 19968: jis0208<<14 | 0x1D<<7 | 0x3F,
	37479 - 19968: jis0208<<14 | 0x5B<<7 | 0x10,
	37480 - 19968: jis0212<<14 | 0x42<<7 | 0x49,
	37481 - 19968: jis0212<<14 | 0x42<<7 | 0x4A,
	37486 - 19968: jis0212<<14 | 0x42<<7 | 0x4B,
	37487 - 19968: jis0212<<14 | 0x42<<7 | 0x4C,
	37488 - 19968: jis0212<<14 | 0x42<<7 | 0x4D,
	37489 - 19968: jis0208<<14 | 0x18<<7 | 0x3A,
	37493 - 19968: jis0212<<14 | 0x42<<7 | 0x4E,
	37494 - 19968: jis0212<<14 | 0x42<<7 | 0x4F,
	37495 - 19968: jis0208<<14 | 0x5B<<7 | 0x12,
	37496 - 19968: jis0208<<14 | 0x5B<<7 | 0x13,
	37497 - 19968: jis0212<<14 | 0x42<<7 | 0x52,
	37499 - 19968: jis0212<<14 | 0x42<<7 | 0x53,
	37500 - 19968: jis0212<<14 | 0x42<<7 | 0x54,
	37501 - 19968: jis0212<<14 | 0x42<<7 | 0x55,
	37502 - 19968: jis0208<<14 | 0x2A<<7 | 0x27,
	37503 - 19968: jis0212<<14 | 0x42<<7 | 0x56,
	37504 - 19968: jis0208<<14 | 0x15<<7 | 0x43,
	37507 - 19968: jis0208<<14 | 0x1C<<7 | 0x25,
	37509 - 19968: jis0208<<14 | 0x25<<7 | 0x1B,
	37512 - 19968: jis0208<<14 | 0x58<<7 | 0x03,
	37513 - 19968: jis0212<<14 | 0x42<<7 | 0x58,
	37514 - 19968: jis0212<<14 | 0x42<<7 | 0x59,
	37517 - 19968: jis0212<<14 | 0x42<<7 | 0x5A,
	37518 - 19968: jis0212<<14 | 0x42<<7 | 0x5B,
	37521 - 19968: jis0208<<14 | 0x20<<7 | 0x0C,
	37522 - 19968: jis0212<<14 | 0x42<<7 | 0x5C,
	37523 - 19968: jis0208<<14 | 0x4D<<7 | 0x53,
	37525 - 19968: jis0208<<14 | 0x4D<<7 | 0x4D,
	37526 - 19968: jis0208<<14 | 0x4D<<7 | 0x52,
	37527 - 19968: jis0212<<14 | 0x42<<7 | 0x5D,
	37528 - 19968: jis0208<<14 | 0x2B<<7 | 0x22,
	37529 - 19968: jis0212<<14 | 0x43<<7 | 0x00,
	37530 - 19968: jis0208<<14 | 0x23<<7 | 0x17,
	37531 - 19968: jis0208<<14 | 0x4D<<7 | 0x54,
	37532 - 19968: jis0208<<14 | 0x4D<<7 | 0x51,
	37535 - 19968: jis0212<<14 | 0x43<<7 | 0x01,
	37536 - 19968: jis0212<<14 | 0x43<<7 | 0x02,
	37540 - 19968: jis0212<<14 | 0x43<<7 | 0x03,
	37541 - 19968: jis0212<<14 | 0x43<<7 | 0x04,
	37543 - 19968: jis0208<<14 | 0x5B<<7 | 0x11,
	37544 - 19968: jis0212<<14 | 0x43<<7 | 0x06,
	37547 - 19968: jis0212<<14 | 0x43<<7 | 0x07,
	37549 - 19968: jis0208<<14 | 0x20<<7 | 0x0B,
	37551 - 19968: jis0212<<14 | 0x43<<7 | 0x08,
	37554 - 19968: jis0212<<14 | 0x43<<7 | 0x09,
	37558 - 19968: jis0212<<14 | 0x43<<7 | 0x0A,
	37559 - 19968: jis0208<<14 | 0x4D<<7 | 0x58,
	37560 - 19968: jis0212<<14 | 0x43<<7 | 0x0B,
	37561 - 19968: jis0208<<14 | 0x4D<<7 | 0x57,
	37562 - 19968: jis0212<<14 | 0x43<<7 | 0x0C,
	37563 - 19968: jis0212<<14 | 0x43<<7 | 0x0D,
	37564 - 19968: jis0212<<14 | 0x43<<7 | 0x0E,
	37565 - 19968: jis0212<<14 | 0x43<<7 | 0x0F,
	37567 - 19968: jis0212<<14 | 0x43<<7 | 0x10,
	37568 - 19968: jis0212<<14 | 0x43<<7 | 0x11,
	37569 - 19968: jis0212<<14 | 0x43<<7 | 0x12,
	37570 - 19968: jis0212<<14 | 0x43<<7 | 0x13,
	37571 - 19968: jis0212<<14 | 0x43<<7 | 0x14,
	37573 - 19968: jis0212<<14 | 0x43<<7 | 0x15,
	37574 - 19968: jis0212<<14 | 0x43<<7 | 0x16,
	37575 - 19968: jis0212<<14 | 0x43<<7 | 0x17,
	37576 - 19968: jis0212<<14 | 0x43<<7 | 0x18,
	37579 - 19968: jis0212<<14 | 0x43<<7 | 0x19,
	37580 - 19968: jis0212<<14 | 0x43<<7 | 0x1A,
	37581 - 19968: jis0212<<14 | 0x43<<7 | 0x1B,
	37582 - 19968: jis0212<<14 | 0x43<<7 | 0x1C,
	37583 - 19968: jis0208<<14 | 0x4D<<7 | 0x56,
	37584 - 19968: jis0208<<14 | 0x5B<<7 | 0x17,
	37586 - 19968: jis0208<<14 | 0x2A<<7 | 0x0E,
	37587 - 19968: jis0208<<14 | 0x5B<<7 | 0x1B,
	37589 - 19968: jis0208<<14 | 0x5B<<7 | 0x19,
	37591 - 19968: jis0208<<14 | 0x5B<<7 | 0x15,
	37592 - 19968: jis0212<<14 | 0x43<<7 | 0x21,
	37593 - 19968: jis0208<<14 | 0x5B<<7 | 0x16,
	37596 - 19968: jis0212<<14 | 0x43<<7 | 0x23,
	37597 - 19968: jis0212<<14 | 0x43<<7 | 0x24,
	37599 - 19968: jis0212<<14 | 0x43<<7 | 0x25,
	37600 - 19968: jis0208<<14 | 0x5B<<7 | 0x1A,
	37601 - 19968: jis0212<<14 | 0x43<<7 | 0x27,
	37603 - 19968: jis0212<<14 | 0x43<<7 | 0x28,
	37604 - 19968: jis0208<<14 | 0x1C<<7 | 0x5A,
	37605 - 19968: jis0212<<14 | 0x43<<7 | 0x29,
	37607 - 19968: jis0208<<14 | 0x5B<<7 | 0x14,
	37608 - 19968: jis0212<<14 | 0x43<<7 | 0x2B,
	37609 - 19968: jis0208<<14 | 0x4D<<7 | 0x59,
	37610 - 19968: jis0208<<14 | 0x29<<7 | 0x3E,
	37612 - 19968: jis0212<<14 | 0x43<<7 | 0x2C,
	37613 - 19968: jis0208<<14 | 0x10<<7 | 0x33,
	37614 - 19968: jis0212<<14 | 0x43<<7 | 0x2D,
	37616 - 19968: jis0212<<14 | 0x43<<7 | 0x2E,
	37618 - 19968: jis0208<<14 | 0x28<<7 | 0x25,
	37619 - 19968: jis0208<<14 | 0x22<<7 | 0x51,
	37624 - 19968: jis0208<<14 | 0x14<<7 | 0x57,
	37625 - 19968: jis0208<<14 | 0x58<<7 | 0x09,
	37626 - 19968: jis0208<<14 | 0x4D<<7 | 0x5B,
	37627 - 19968: jis0208<<14 | 0x5B<<7 | 0x1E,
	37628 - 19968: jis0208<<14 | 0x18<<7 | 0x3C,
	37631 - 19968: jis0208<<14 | 0x5B<<7 | 0x21,
	37632 - 19968: jis0212<<14 | 0x43<<7 | 0x32,
	37634 - 19968: jis0208<<14 | 0x5B<<7 | 0x23,
	37638 - 19968: jis0208<<14 | 0x1A<<7 | 0x0B,
	37640 - 19968: jis0212<<14 | 0x43<<7 | 0x34,
	37645 - 19968: jis0212<<14 | 0x43<<7 | 0x35,
	37647 - 19968: jis0208<<14 | 0x4D<<7 | 0x5A,
	37648 - 19968: jis0208<<14 | 0x1E<<7 | 0x4C,
	37649 - 19968: jis0212<<14 | 0x43<<7 | 0x36,
	37652 - 19968: jis0212<<14 | 0x43<<7 | 0x37,
	37653 - 19968: jis0212<<14 | 0x43<<7 | 0x38,
	37656 - 19968: jis0208<<14 | 0x1E<<7 | 0x4D,
	37657 - 19968: jis0208<<14 | 0x4E<<7 | 0x00,
	37658 - 19968: jis0208<<14 | 0x4E<<7 | 0x02,
	37660 - 19968: jis0212<<14 | 0x43<<7 | 0x39,
	37661 - 19968: jis0208<<14 | 0x5B<<7 | 0x22,
	37662 - 19968: jis0208<<14 | 0x5B<<7 | 0x20,
	37663 - 19968: jis0212<<14 | 0x43<<7 | 0x3C,
	37664 - 19968: jis0208<<14 | 0x1D<<7 | 0x5A,
	37665 - 19968: jis0208<<14 | 0x5B<<7 | 0x1D,
	37666 - 19968: jis0208<<14 | 0x4E<<7 | 0x01,
	37667 - 19968: jis0208<<14 | 0x4E<<7 | 0x03,
	37668 - 19968: jis0212<<14 | 0x43<<7 | 0x3E,
	37669 - 19968: jis0208<<14 | 0x5B<<7 | 0x1C,
	37670 - 19968: jis0208<<14 | 0x15<<7 | 0x32,
	37671 - 19968: jis0212<<14 | 0x43<<7 | 0x40,
	37672 - 19968: jis0208<<14 | 0x28<<7 | 0x24,
	37673 - 19968: jis0212<<14 | 0x43<<7 | 0x41,
	37674 - 19968: jis0212<<14 | 0x43<<7 | 0x42,
	37675 - 19968: jis0208<<14 | 0x1B<<7 | 0x41,
	37676 - 19968: jis0208<<14 | 0x2E<<7 | 0x02,
	37678 - 19968: jis0208<<14 | 0x4D<<7 | 0x5D,
	37679 - 19968: jis0208<<14 | 0x19<<7 | 0x57,
	37682 - 19968: jis0208<<14 | 0x2E<<7 | 0x1E,
	37683 - 19968: jis0212<<14 | 0x43<<7 | 0x43,
	37684 - 19968: jis0212<<14 | 0x43<<7 | 0x44,
	37685 - 19968: jis0208<<14 | 0x4E<<7 | 0x05,
	37686 - 19968: jis0212<<14 | 0x43<<7 | 0x45,
	37687 - 19968: jis0212<<14 | 0x43<<7 | 0x46,
	37690 - 19968: jis0208<<14 | 0x4E<<7 | 0x04,
	37691 - 19968: jis0208<<14 | 0x4E<<7 | 0x06,
	37700 - 19968: jis0208<<14 | 0x4D<<7 | 0x5C,
	37703 - 19968: jis0212<<14 | 0x43<<7 | 0x47,
	37704 - 19968: jis0208<<14 | 0x58<<7 | 0x02,
	37705 - 19968: jis0212<<14 | 0x43<<7 | 0x49,
	37707 - 19968: jis0208<<14 | 0x25<<7 | 0x48,
	37709 - 19968: jis0208<<14 | 0x24<<7 | 0x34,
	37712 - 19968: jis0212<<14 | 0x43<<7 | 0x4A,
	37713 - 19968: jis0212<<14 | 0x43<<7 | 0x4B,
	37714 - 19968: jis0212<<14 | 0x43<<7 | 0x4C,
	37716 - 19968: jis0208<<14 | 0x23<<7 | 0x36,
	37717 - 19968: jis0212<<14 | 0x43<<7 | 0x4D,
	37718 - 19968: jis0208<<14 | 0x4E<<7 | 0x0B,
	37719 - 19968: jis0208<<14 | 0x5B<<7 | 0x25,
	37720 - 19968: jis0212<<14 | 0x43<<7 | 0x4F,
	37722 - 19968: jis0212<<14 | 0x43<<7 | 0x50,
	37723 - 19968: jis0208<<14 | 0x22<<7 | 0x22,
	37724 - 19968: jis0208<<14 | 0x4E<<7 | 0x07,
	37726 - 19968: jis0212<<14 | 0x43<<7 | 0x51,
	37728 - 19968: jis0208<<14 | 0x4E<<7 | 0x08,
	37732 - 19968: jis0212<<14 | 0x43<<7 | 0x52,
	37733 - 19968: jis0212<<14 | 0x43<<7 | 0x53,
	37735 - 19968: jis0212<<14 | 0x43<<7 | 0x54,
	37737 - 19968: jis0212<<14 | 0x43<<7 | 0x55,
	37738 - 19968: jis0212<<14 | 0x43<<7 | 0x56,
	37740 - 19968: jis0208<<14 | 0x16<<7 | 0x0C,
	37741 - 19968: jis0212<<14 | 0x43<<7 | 0x57,
	37742 - 19968: jis0208<<14 | 0x4E<<7 | 0x0A,
	37743 - 19968: jis0212<<14 | 0x43<<7 | 0x58,
	37744 - 19968: jis0208<<14 | 0x5B<<7 | 0x24,
	37745 - 19968: jis0212<<14 | 0x43<<7 | 0x5A,
	37747 - 19968: jis0212<<14 | 0x43<<7 | 0x5B,
	37748 - 19968: jis0212<<14 | 0x43<<7 | 0x5C,
	37749 - 19968: jis0208<<14 | 0x17<<7 | 0x0F,
	37750 - 19968: jis0212<<14 | 0x43<<7 | 0x5D,
	37754 - 19968: jis0212<<14 | 0x44<<7 | 0x00,
	37756 - 19968: jis0208<<14 | 0x4E<<7 | 0x09,
	37757 - 19968: jis0212<<14 | 0x44<<7 | 0x01,
	37758 - 19968: jis0208<<14 | 0x1D<<7 | 0x40,
	37759 - 19968: jis0212<<14 | 0x44<<7 | 0x02,
	37760 - 19968: jis0212<<14 | 0x44<<7 | 0x03,
	37761 - 19968: jis0212<<14 | 0x44<<7 | 0x04,
	37762 - 19968: jis0212<<14 | 0x44<<7 | 0x05,
	37768 - 19968: jis0212<<14 | 0x44<<7 | 0x06,
	37770 - 19968: jis0212<<14 | 0x44<<7 | 0x07,
	37771 - 19968: jis0212<<14 | 0x44<<7 | 0x08,
	37772 - 19968: jis0208<<14 | 0x12<<7 | 0x58,
	37773 - 19968: jis0212<<14 | 0x44<<7 | 0x09,
	37775 - 19968: jis0212<<14 | 0x44<<7 | 0x0A,
	37778 - 19968: jis0212<<14 | 0x44<<7 | 0x0B,
	37780 - 19968: jis0208<<14 | 0x4E<<7 | 0x0F,
	37781 - 19968: jis0212<<14 | 0x44<<7 | 0x0C,
	37782 - 19968: jis0208<<14 | 0x19<<7 | 0x1E,
	37783 - 19968: jis0208<<14 | 0x20<<7 | 0x58,
	37784 - 19968: jis0212<<14 | 0x44<<7 | 0x0D,
	37786 - 19968: jis0208<<14 | 0x23<<7 | 0x29,
	37787 - 19968: jis0212<<14 | 0x44<<7 | 0x0E,
	37790 - 19968: jis0212<<14 | 0x44<<7 | 0x0F,
	37793 - 19968: jis0212<<14 | 0x44<<7 | 0x10,
	37795 - 19968: jis0212<<14 | 0x44<<7 | 0x11,
	37796 - 19968: jis0208<<14 | 0x5B<<7 | 0x26,
	37798 - 19968: jis0212<<14 | 0x44<<7 | 0x13,
	37799 - 19968: jis0208<<14 | 0x12<<7 | 0x1A,
	37800 - 19968: jis0212<<14 | 0x44<<7 | 0x14,
	37801 - 19968: jis0212<<14 | 0x44<<7 | 0x1A,
	37803 - 19968: jis0212<<14 | 0x44<<7 | 0x15,
	37804 - 19968: jis0208<<14 | 0x4E<<7 | 0x0D,
	37805 - 19968: jis0208<<14 | 0x4E<<7 | 0x0E,
	37806 - 19968: jis0208<<14 | 0x23<<7 | 0x22,
	37808 - 19968: jis0208<<14 | 0x4E<<7 | 0x0C,
	37812 - 19968: jis0212<<14 | 0x44<<7 | 0x16,
	37813 - 19968: jis0212<<14 | 0x44<<7 | 0x17,
	37814 - 19968: jis0212<<14 | 0x44<<7 | 0x18,
	37817 - 19968: jis0208<<14 | 0x4E<<7 | 0x10,
	37818 - 19968: jis0212<<14 | 0x44<<7 | 0x19,
	37825 - 19968: jis0212<<14 | 0x44<<7 | 0x1B,
	37827 - 19968: jis0208<<14 | 0x4E<<7 | 0x16,
	37828 - 19968: jis0212<<14 | 0x44<<7 | 0x1C,
	37829 - 19968: jis0212<<14 | 0x44<<7 | 0x1D,
	37830 - 19968: jis0208<<14 | 0x5B<<7 | 0x27,
	37831 - 19968: jis0212<<14 | 0x44<<7 | 0x1F,
	37832 - 19968: jis0208<<14 | 0x4E<<7 | 0x19,
	37833 - 19968: jis0212<<14 | 0x44<<7 | 0x20,
	37834 - 19968: jis0212<<14 | 0x44<<7 | 0x21,
	37835 - 19968: jis0212<<14 | 0x44<<7 | 0x22,
	37836 - 19968: jis0212<<14 | 0x44<<7 | 0x23,
	37837 - 19968: jis0212<<14 | 0x44<<7 | 0x24,
	37840 - 19968: jis0208<<14 | 0x4E<<7 | 0x18,
	37841 - 19968: jis0208<<14 | 0x24<<7 | 0x0C,
	37843 - 19968: jis0212<<14 | 0x44<<7 | 0x25,
	37846 - 19968: jis0208<<14 | 0x4E<<7 | 0x11,
	37847 - 19968: jis0208<<14 | 0x4E<<7 | 0x12,
	37848 - 19968: jis0208<<14 | 0x4E<<7 | 0x15,
	37849 - 19968: jis0212<<14 | 0x44<<7 | 0x26,
	37852 - 19968: jis0212<<14 | 0x44<<7 | 0x27,
	37853 - 19968: jis0208<<14 | 0x4E<<7 | 0x17,
	37854 - 19968: jis0208<<14 | 0x5B<<7 | 0x28,
	37855 - 19968: jis0212<<14 | 0x44<<7 | 0x29,
	37857 - 19968: jis0208<<14 | 0x15<<7 | 0x1F,
	37858 - 19968: jis0212<<14 | 0x44<<7 | 0x2A,
	37860 - 19968: jis0208<<14 | 0x4E<<7 | 0x1A,
	37861 - 19968: jis0208<<14 | 0x4E<<7 | 0x14,
	37862 - 19968: jis0212<<14 | 0x44<<7 | 0x2B,
	37863 - 19968: jis0212<<14 | 0x44<<7 | 0x2C,
	37864 - 19968: jis0208<<14 | 0x4E<<7 | 0x13,
	37879 - 19968: jis0212<<14 | 0x44<<7 | 0x2E,
	37880 - 19968: jis0208<<14 | 0x5B<<7 | 0x29,
	37881 - 19968: jis0212<<14 | 0x44<<7 | 0x2D,
	37882 - 19968: jis0212<<14 | 0x44<<7 | 0x30,
	37883 - 19968: jis0212<<14 | 0x44<<7 | 0x31,
	37885 - 19968: jis0212<<14 | 0x44<<7 | 0x32,
	37889 - 19968: jis0212<<14 | 0x44<<7 | 0x33,
	37890 - 19968: jis0212<<14 | 0x44<<7 | 0x34,
	37891 - 19968: jis0208<<14 | 0x4E<<7 | 0x1E,
	37892 - 19968: jis0212<<14 | 0x44<<7 | 0x35,
	37895 - 19968: jis0208<<14 | 0x4E<<7 | 0x1F,
	37896 - 19968: jis0212<<14 | 0x44<<7 | 0x36,
	37897 - 19968: jis0212<<14 | 0x44<<7 | 0x37,
	37901 - 19968: jis0212<<14 | 0x44<<7 | 0x38,
	37902 - 19968: jis0212<<14 | 0x44<<7 | 0x39,
	37903 - 19968: jis0212<<14 | 0x44<<7 | 0x3A,
	37904 - 19968: jis0208<<14 | 0x4E<<7 | 0x20,
	37907 - 19968: jis0208<<14 | 0x4E<<7 | 0x1D,
	37908 - 19968: jis0208<<14 | 0x4E<<7 | 0x1C,
	37909 - 19968: jis0212<<14 | 0x44<<7 | 0x3B,
	37910 - 19968: jis0212<<14 | 0x44<<7 | 0x3C,
	37911 - 19968: jis0212<<14 | 0x44<<7 | 0x3D,
	37912 - 19968: jis0208<<14 | 0x1D<<7 | 0x41,
	37913 - 19968: jis0208<<14 | 0x25<<7 | 0x09,
	37914 - 19968: jis0208<<14 | 0x4E<<7 | 0x1B,
	37919 - 19968: jis0212<<14 | 0x44<<7 | 0x3E,
	37921 - 19968: jis0208<<14 | 0x4E<<7 | 0x24,
	37931 - 19968: jis0208<<14 | 0x4E<<7 | 0x22,
	37934 - 19968: jis0212<<14 | 0x44<<7 | 0x3F,
	37935 - 19968: jis0212<<14 | 0x44<<7 | 0x40,
	37937 - 19968: jis0208<<14 | 0x5B<<7 | 0x2A,
	37938 - 19968: jis0212<<14 | 0x44<<7 | 0x42,
	37939 - 19968: jis0212<<14 | 0x44<<7 | 0x43,
	37940 - 19968: jis0212<<14 | 0x44<<7 | 0x44,
	37941 - 19968: jis0208<<14 | 0x4E<<7 | 0x23,
	37942 - 19968: jis0208<<14 | 0x4E<<7 | 0x21,
	37944 - 19968: jis0208<<14 | 0x21<<7 | 0x57,
	37946 - 19968: jis0208<<14 | 0x4E<<7 | 0x25,
	37947 - 19968: jis0212<<14 | 0x44<<7 | 0x45,
	37949 - 19968: jis0212<<14 | 0x44<<7 | 0x47,
	37951 - 19968: jis0212<<14 | 0x44<<7 | 0x46,
	37953 - 19968: jis0208<<14 | 0x4E<<7 | 0x26,
	37955 - 19968: jis0212<<14 | 0x44<<7 | 0x48,
	37956 - 19968: jis0208<<14 | 0x4E<<7 | 0x28,
	37957 - 19968: jis0208<<14 | 0x5B<<7 | 0x2B,
	37960 - 19968: jis0208<<14 | 0x5B<<7 | 0x2C,
	37962 - 19968: jis0212<<14 | 0x44<<7 | 0x4B,
	37964 - 19968: jis0212<<14 | 0x44<<7 | 0x4C,
	37969 - 19968: jis0208<<14 | 0x13<<7 | 0x34,
	37970 - 19968: jis0208<<14 | 0x4E<<7 | 0x27,
	37971 - 19968: jis0208<<14 | 0x2B<<7 | 0x59,
	37973 - 19968: jis0212<<14 | 0x44<<7 | 0x4D,
	37977 - 19968: jis0212<<14 | 0x44<<7 | 0x4E,
	37978 - 19968: jis0208<<14 | 0x4E<<7 | 0x33,
	37979 - 19968: jis0208<<14 | 0x4E<<7 | 0x29,
	37980 - 19968: jis0212<<14 | 0x44<<7 | 0x4F,
	37982 - 19968: jis0208<<14 | 0x4E<<7 | 0x2C,
	37983 - 19968: jis0212<<14 | 0x44<<7 | 0x50,
	37984 - 19968: jis0208<<14 | 0x4E<<7 | 0x2A,
	37985 - 19968: jis0212<<14 | 0x44<<7 | 0x51,
	37986 - 19968: jis0208<<14 | 0x4E<<7 | 0x2B,
	37987 - 19968: jis0212<<14 | 0x44<<7 | 0x52,
	37992 - 19968: jis0212<<14 | 0x44<<7 | 0x53,
	37994 - 19968: jis0208<<14 | 0x4E<<7 | 0x2D,
	37995 - 19968: jis0212<<14 | 0x44<<7 | 0x54,
	37997 - 19968: jis0212<<14 | 0x44<<7 | 0x55,
	37998 - 19968: jis0212<<14 | 0x44<<7 | 0x56,
	37999 - 19968: jis0212<<14 | 0x44<<7 | 0x57,
	38000 - 19968: jis0208<<14 | 0x4E<<7 | 0x2F,
	38001 - 19968: jis0212<<14 | 0x44<<7 | 0x58,
	38002 - 19968: jis0212<<14 | 0x44<<7 | 0x59,
	38005 - 19968: jis0208<<14 | 0x4E<<7 | 0x30,
	38007 - 19968: jis0208<<14 | 0x4E<<7 | 0x31,
	38012 - 19968: jis0208<<14 | 0x4E<<7 | 0x34,
	38013 - 19968: jis0208<<14 | 0x4E<<7 | 0x32,
	38014 - 19968: jis0208<<14 | 0x4E<<7 | 0x35,
	38015 - 19968: jis0208<<14 | 0x4E<<7 | 0x37,
	38017 - 19968: jis0208<<14 | 0x4E<<7 | 0x36,
	38019 - 19968: jis0212<<14 | 0x44<<7 | 0x5B,
	38020 - 19968: jis0212<<14 | 0x44<<7 | 0x5A,
	38263 - 19968: jis0208<<14 | 0x23<<7 | 0x18,
	38264 - 19968: jis0212<<14 | 0x44<<7 | 0x5C,
	38265 - 19968: jis0212<<14 | 0x44<<7 | 0x5D,
	38270 - 19968: jis0212<<14 | 0x45<<7 | 0x00,
	38272 - 19968: jis0208<<14 | 0x2B<<7 | 0x46,
	38274 - 19968: jis0208<<14 | 0x4E<<7 | 0x38,
	38275 - 19968: jis0208<<14 | 0x20<<7 | 0x0D,
	38276 - 19968: jis0212<<14 | 0x45<<7 | 0x01,
	38279 - 19968: jis0208<<14 | 0x4E<<7 | 0x39,
	38280 - 19968: jis0212<<14 | 0x45<<7 | 0x02,
	38281 - 19968: jis0208<<14 | 0x29<<7 | 0x23,
	38282 - 19968: jis0208<<14 | 0x4E<<7 | 0x3A,
	38283 - 19968: jis0208<<14 | 0x12<<7 | 0x0A,
	38284 - 19968: jis0212<<14 | 0x45<<7 | 0x03,
	38285 - 19968: jis0212<<14 | 0x45<<7 | 0x04,
	38286 - 19968: jis0212<<14 | 0x45<<7 | 0x05,
	38287 - 19968: jis0208<<14 | 0x10<<7 | 0x1B,
	38289 - 19968: jis0208<<14 | 0x13<<7 | 0x36,
	38290 - 19968: jis0208<<14 | 0x5B<<7 | 0x2D,
	38291 - 19968: jis0208<<14 | 0x13<<7 | 0x35,
	38292 - 19968: jis0208<<14 | 0x4E<<7 | 0x3B,
	38294 - 19968: jis0208<<14 | 0x4E<<7 | 0x3C,
	38296 - 19968: jis0208<<14 | 0x4E<<7 | 0x3D,
	38297 - 19968: jis0208<<14 | 0x4E<<7 | 0x3E,
	38301 - 19968: jis0212<<14 | 0x45<<7 | 0x06,
	38302 - 19968: jis0212<<14 | 0x45<<7 | 0x07,
	38303 - 19968: jis0212<<14 | 0x45<<7 | 0x08,
	38304 - 19968: jis0208<<14 | 0x4E<<7 | 0x3F,
	38305 - 19968: jis0212<<14 | 0x45<<7 | 0x09,
	38306 - 19968: jis0208<<14 | 0x13<<7 | 0x37,
	38307 - 19968: jis0208<<14 | 0x12<<7 | 0x34,
	38308 - 19968: jis0208<<14 | 0x18<<7 | 0x3D,
	38309 - 19968: jis0208<<14 | 0x27<<7 | 0x15,
	38310 - 19968: jis0212<<14 | 0x45<<7 | 0x0A,
	38311 - 19968: jis0208<<14 | 0x4E<<7 | 0x41,
	38312 - 19968: jis0208<<14 | 0x4E<<7 | 0x40,
	38313 - 19968: jis0212<<14 | 0x45<<7 | 0x0B,
	38315 - 19968: jis0212<<14 | 0x45<<7 | 0x0C,
	38316 - 19968: jis0212<<14 | 0x45<<7 | 0x0D,
	38317 - 19968: jis0208<<14 | 0x4E<<7 | 0x42,
	38322 - 19968: jis0208<<14 | 0x10<<7 | 0x3B,
	38324 - 19968: jis0212<<14 | 0x45<<7 | 0x0E,
	38326 - 19968: jis0212<<14 | 0x45<<7 | 0x0F,
	38329 - 19968: jis0208<<14 | 0x4E<<7 | 0x45,
	38330 - 19968: jis0212<<14 | 0x45<<7 | 0x10,
	38331 - 19968: jis0208<<14 | 0x4E<<7 | 0x44,
	38332 - 19968: jis0208<<14 | 0x4E<<7 | 0x43,
	38333 - 19968: jis0212<<14 | 0x45<<7 | 0x11,
	38334 - 19968: jis0208<<14 | 0x4E<<7 | 0x46,
	38335 - 19968: jis0212<<14 | 0x45<<7 | 0x12,
	38339 - 19968: jis0208<<14 | 0x4E<<7 | 0x49,
	38342 - 19968: jis0212<<14 | 0x45<<7 | 0x13,
	38343 - 19968: jis0208<<14 | 0x0F<<7 | 0x26,
	38344 - 19968: jis0212<<14 | 0x45<<7 | 0x14,
	38345 - 19968: jis0212<<14 | 0x45<<7 | 0x15,
	38346 - 19968: jis0208<<14 | 0x4E<<7 | 0x47,
	38347 - 19968: jis0212<<14 | 0x45<<7 | 0x16,
	38348 - 19968: jis0208<<14 | 0x4E<<7 | 0x4B,
	38349 - 19968: jis0208<<14 | 0x4E<<7 | 0x4A,
	38352 - 19968: jis0212<<14 | 0x45<<7 | 0x17,
	38353 - 19968: jis0212<<14 | 0x45<<7 | 0x18,
	38354 - 19968: jis0212<<14 | 0x45<<7 | 0x19,
	38355 - 19968: jis0212<<14 | 0x45<<7 | 0x1A,
	38356 - 19968: jis0208<<14 | 0x4E<<7 | 0x4D,
	38357 - 19968: jis0208<<14 | 0x4E<<7 | 0x4C,
	38358 - 19968: jis0208<<14 | 0x4E<<7 | 0x4E,
	38360 - 19968: jis0208<<14 | 0x25<<7 | 0x0D,
	38361 - 19968: jis0212<<14 | 0x45<<7 | 0x1B,
	38362 - 19968: jis0212<<14 | 0x45<<7 | 0x1C,
	38364 - 19968: jis0208<<14 | 0x4E<<7 | 0x4F,
	38365 - 19968: jis0212<<14 | 0x45<<7 | 0x1D,
	38366 - 19968: jis0212<<14 | 0x45<<7 | 0x1E,
	38367 - 19968: jis0212<<14 | 0x45<<7 | 0x1F,
	38368 - 19968: jis0212<<14 | 0x45<<7 | 0x20,
	38369 - 19968: jis0208<<14 | 0x4E<<7 | 0x50,
	38370 - 19968: jis0208<<14 | 0x4E<<7 | 0x52,
	38372 - 19968: jis0212<<14 | 0x45<<7 | 0x21,
	38373 - 19968: jis0208<<14 | 0x4E<<7 | 0x51,
	38374 - 19968: jis0212<<14 | 0x45<<7 | 0x22,
	38428 - 19968: jis0208<<14 | 0x28<<7 | 0x4B,
	38429 - 19968: jis0212<<14 | 0x45<<7 | 0x23,
	38430 - 19968: jis0212<<14 | 0x45<<7 | 0x24,
	38433 - 19968: jis0208<<14 | 0x4E<<7 | 0x53,
	38434 - 19968: jis0212<<14 | 0x45<<7 | 0x25,
	38436 - 19968: jis0212<<14 | 0x45<<7 | 0x26,
	38437 - 19968: jis0212<<14 | 0x45<<7 | 0x27,
	38438 - 19968: jis0212<<14 | 0x45<<7 | 0x28,
	38440 - 19968: jis0208<<14 | 0x4E<<7 | 0x54,
	38442 - 19968: jis0208<<14 | 0x19<<7 | 0x44,
	38444 - 19968: jis0212<<14 | 0x45<<7 | 0x29,
	38446 - 19968: jis0208<<14 | 0x4E<<7 | 0x55,
	38447 - 19968: jis0208<<14 | 0x4E<<7 | 0x56,
	38449 - 19968: jis0212<<14 | 0x45<<7 | 0x2A,
	38450 - 19968: jis0208<<14 | 0x2A<<7 | 0x28,
	38451 - 19968: jis0212<<14 | 0x45<<7 | 0x2B,
	38455 - 19968: jis0212<<14 | 0x45<<7 | 0x2C,
	38456 - 19968: jis0212<<14 | 0x45<<7 | 0x2D,
	38457 - 19968: jis0212<<14 | 0x45<<7 | 0x2E,
	38458 - 19968: jis0212<<14 | 0x45<<7 | 0x2F,
	38459 - 19968: jis0208<<14 | 0x20<<7 | 0x2A,
	38460 - 19968: jis0212<<14 | 0x45<<7 | 0x30,
	38461 - 19968: jis0212<<14 | 0x45<<7 | 0x31,
	38463 - 19968: jis0208<<14 | 0x0F<<7 | 0x03,
	38464 - 19968: jis0208<<14 | 0x21<<7 | 0x2A,
	38465 - 19968: jis0212<<14 | 0x45<<7 | 0x32,
	38466 - 19968: jis0208<<14 | 0x4E<<7 | 0x57,
	38468 - 19968: jis0208<<14 | 0x28<<7 | 0x4C,
	38475 - 19968: jis0208<<14 | 0x4E<<7 | 0x5A,
	38476 - 19968: jis0208<<14 | 0x4E<<7 | 0x58,
	38477 - 19968: jis0208<<14 | 0x18<<7 | 0x3E,
	38479 - 19968: jis0208<<14 | 0x4E<<7 | 0x59,
	38480 - 19968: jis0208<<14 | 0x17<<7 | 0x21,
	38482 - 19968: jis0212<<14 | 0x45<<7 | 0x33,
	38484 - 19968: jis0212<<14 | 0x45<<7 | 0x34,
	38486 - 19968: jis0212<<14 | 0x45<<7 | 0x35,
	38487 - 19968: jis0212<<14 | 0x45<<7 | 0x36,
	38488 - 19968: jis0212<<14 | 0x45<<7 | 0x37,
	38491 - 19968: jis0208<<14 | 0x29<<7 | 0x24,
	38492 - 19968: jis0208<<14 | 0x4E<<7 | 0x5C,
	38493 - 19968: jis0208<<14 | 0x4F<<7 | 0x00,
	38494 - 19968: jis0208<<14 | 0x4E<<7 | 0x5D,
	38495 - 19968: jis0208<<14 | 0x4F<<7 | 0x01,
	38497 - 19968: jis0212<<14 | 0x45<<7 | 0x38,
	38498 - 19968: jis0208<<14 | 0x10<<7 | 0x00,
	38499 - 19968: jis0208<<14 | 0x1E<<7 | 0x37,
	38500 - 19968: jis0208<<14 | 0x1C<<7 | 0x5B,
	38501 - 19968: jis0208<<14 | 0x13<<7 | 0x38,
	38502 - 19968: jis0208<<14 | 0x4F<<7 | 0x02,
	38506 - 19968: jis0208<<14 | 0x26<<7 | 0x45,
	38508 - 19968: jis0208<<14 | 0x4F<<7 | 0x04,
	38510 - 19968: jis0212<<14 | 0x45<<7 | 0x39,
	38512 - 19968: jis0208<<14 | 0x10<<7 | 0x01,
	38514 - 19968: jis0208<<14 | 0x4F<<7 | 0x03,
	38515 - 19968: jis0208<<14 | 0x23<<7 | 0x23,
	38516 - 19968: jis0212<<14 | 0x45<<7 | 0x3A,
	38517 - 19968: jis0208<<14 | 0x2D<<7 | 0x2C,
	38518 - 19968: jis0208<<14 | 0x25<<7 | 0x0A,
	38519 - 19968: jis0208<<14 | 0x4E<<7 | 0x5B,
	38520 - 19968: jis0208<<14 | 0x2D<<7 | 0x05,
	38522 - 19968: jis0208<<14 | 0x17<<7 | 0x10,
	38523 - 19968: jis0212<<14 | 0x45<<7 | 0x3B,
	38524 - 19968: jis0212<<14 | 0x45<<7 | 0x3C,
	38525 - 19968: jis0208<<14 | 0x2C<<7 | 0x3A,
	38526 - 19968: jis0212<<14 | 0x45<<7 | 0x3D,
	38527 - 19968: jis0212<<14 | 0x45<<7 | 0x3E,
	38529 - 19968: jis0212<<14 | 0x45<<7 | 0x3F,
	38530 - 19968: jis0212<<14 | 0x45<<7 | 0x40,
	38531 - 19968: jis0212<<14 | 0x45<<7 | 0x41,
	38532 - 19968: jis0212<<14 | 0x45<<7 | 0x42,
	38533 - 19968: jis0208<<14 | 0x15<<7 | 0x58,
	38534 - 19968: jis0208<<14 | 0x2D<<7 | 0x13,
	38536 - 19968: jis0208<<14 | 0x16<<7 | 0x07,
	38537 - 19968: jis0212<<14 | 0x45<<7 | 0x43,
	38538 - 19968: jis0208<<14 | 0x21<<7 | 0x41,
	38539 - 19968: jis0208<<14 | 0x46<<7 | 0x00,
	38541 - 19968: jis0208<<14 | 0x4F<<7 | 0x05,
	38542 - 19968: jis0208<<14 | 0x12<<7 | 0x0B,
	38543 - 19968: jis0208<<14 | 0x1E<<7 | 0x4E,
	38545 - 19968: jis0212<<14 | 0x45<<7 | 0x44,
	38548 - 19968: jis0208<<14 | 0x12<<7 | 0x35,
	38549 - 19968: jis0208<<14 | 0x4F<<7 | 0x07,
	38550 - 19968: jis0212<<14 | 0x45<<7 | 0x45,
	38551 - 19968: jis0208<<14 | 0x4F<<7 | 0x08,
	38552 - 19968: jis0208<<14 | 0x4F<<7 | 0x06,
	38553 - 19968: jis0208<<14 | 0x16<<7 | 0x43,
	38554 - 19968: jis0212<<14 | 0x45<<7 | 0x46,
	38555 - 19968: jis0208<<14 | 0x19<<7 | 0x3C,
	38556 - 19968: jis0208<<14 | 0x1D<<7 | 0x42,
	38557 - 19968: jis0208<<14 | 0x5B<<7 | 0x30,
	38559 - 19968: jis0212<<14 | 0x45<<7 | 0x48,
	38560 - 19968: jis0208<<14 | 0x10<<7 | 0x02,
	38563 - 19968: jis0208<<14 | 0x2D<<7 | 0x38,
	38564 - 19968: jis0212<<14 | 0x45<<7 | 0x49,
	38565 - 19968: jis0212<<14 | 0x45<<7 | 0x4A,
	38566 - 19968: jis0212<<14 | 0x45<<7 | 0x4B,
	38567 - 19968: jis0208<<14 | 0x4F<<7 | 0x0A,
	38568 - 19968: jis0208<<14 | 0x4D<<7 | 0x0D,
	38569 - 19968: jis0212<<14 | 0x45<<7 | 0x4C,
	38570 - 19968: jis0208<<14 | 0x4F<<7 | 0x09,
	38574 - 19968: jis0212<<14 | 0x45<<7 | 0x4D,
	38575 - 19968: jis0208<<14 | 0x5B<<7 | 0x31,
	38576 - 19968: jis0208<<14 | 0x4F<<7 | 0x0D,
	38577 - 19968: jis0208<<14 | 0x4F<<7 | 0x0B,
	38578 - 19968: jis0208<<14 | 0x4F<<7 | 0x0C,
	38579 - 19968: jis0212<<14 | 0x45<<7 | 0x4F,
	38580 - 19968: jis0208<<14 | 0x4F<<7 | 0x0E,
	38582 - 19968: jis0208<<14 | 0x4F<<7 | 0x0F,
	38583 - 19968: jis0208<<14 | 0x2D<<7 | 0x4B,
	38584 - 19968: jis0208<<14 | 0x4F<<7 | 0x10,
	38585 - 19968: jis0208<<14 | 0x4F<<7 | 0x11,
	38586 - 19968: jis0212<<14 | 0x45<<7 | 0x50,
	38587 - 19968: jis0208<<14 | 0x1F<<7 | 0x28,
	38588 - 19968: jis0208<<14 | 0x27<<7 | 0x1A,
	38592 - 19968: jis0208<<14 | 0x1E<<7 | 0x5C,
	38593 - 19968: jis0208<<14 | 0x13<<7 | 0x46,
	38596 - 19968: jis0208<<14 | 0x2C<<7 | 0x19,
	38597 - 19968: jis0208<<14 | 0x11<<7 | 0x4C,
	38598 - 19968: jis0208<<14 | 0x1C<<7 | 0x17,
	38599 - 19968: jis0208<<14 | 0x17<<7 | 0x3A,
	38601 - 19968: jis0208<<14 | 0x4F<<7 | 0x14,
	38602 - 19968: jis0212<<14 | 0x45<<7 | 0x51,
	38603 - 19968: jis0208<<14 | 0x4F<<7 | 0x13,
	38604 - 19968: jis0208<<14 | 0x1A<<7 | 0x52,
	38605 - 19968: jis0208<<14 | 0x4F<<7 | 0x15,
	38606 - 19968: jis0208<<14 | 0x4F<<7 | 0x12,
	38609 - 19968: jis0208<<14 | 0x1A<<7 | 0x07,
	38610 - 19968: jis0212<<14 | 0x45<<7 | 0x52,
	38613 - 19968: jis0208<<14 | 0x4F<<7 | 0x19,
	38614 - 19968: jis0208<<14 | 0x49<<7 | 0x0C,
	38616 - 19968: jis0212<<14 | 0x45<<7 | 0x54,
	38617 - 19968: jis0208<<14 | 0x31<<7 | 0x35,
	38618 - 19968: jis0212<<14 | 0x45<<7 | 0x55,
	38619 - 19968: jis0208<<14 | 0x1E<<7 | 0x56,
	38620 - 19968: jis0208<<14 | 0x4F<<7 | 0x17,
	38621 - 19968: jis0212<<14 | 0x45<<7 | 0x56,
	38622 - 19968: jis0212<<14 | 0x45<<7 | 0x57,
	38623 - 19968: jis0212<<14 | 0x45<<7 | 0x58,
	38626 - 19968: jis0208<<14 | 0x2D<<7 | 0x04,
	38627 - 19968: jis0208<<14 | 0x25<<7 | 0x50,
	38632 - 19968: jis0208<<14 | 0x10<<7 | 0x0A,
	38633 - 19968: jis0212<<14 | 0x45<<7 | 0x59,
	38634 - 19968: jis0208<<14 | 0x1F<<7 | 0x42,
	38635 - 19968: jis0208<<14 | 0x1B<<7 | 0x15,
	38639 - 19968: jis0212<<14 | 0x45<<7 | 0x5A,
	38640 - 19968: jis0208<<14 | 0x29<<7 | 0x16,
	38641 - 19968: jis0212<<14 | 0x45<<7 | 0x5B,
	38642 - 19968: jis0208<<14 | 0x10<<7 | 0x1F,
	38646 - 19968: jis0208<<14 | 0x2D<<7 | 0x4C,
	38647 - 19968: jis0208<<14 | 0x2C<<7 | 0x4A,
	38649 - 19968: jis0208<<14 | 0x4F<<7 | 0x1A,
	38650 - 19968: jis0212<<14 | 0x45<<7 | 0x5C,
	38651 - 19968: jis0208<<14 | 0x24<<7 | 0x24,
	38656 - 19968: jis0208<<14 | 0x1B<<7 | 0x5A,
	38658 - 19968: jis0212<<14 | 0x45<<7 | 0x5D,
	38659 - 19968: jis0212<<14 | 0x46<<7 | 0x00,
	38660 - 19968: jis0208<<14 | 0x4F<<7 | 0x1B,
	38661 - 19968: jis0212<<14 | 0x46<<7 | 0x01,
	38662 - 19968: jis0208<<14 | 0x4F<<7 | 0x1C,
	38663 - 19968: jis0208<<14 | 0x1E<<7 | 0x2B,
	38664 - 19968: jis0208<<14 | 0x4F<<7 | 0x1D,
	38665 - 19968: jis0212<<14 | 0x46<<7 | 0x02,
	38666 - 19968: jis0208<<14 | 0x2D<<7 | 0x4D,
	38669 - 19968: jis0208<<14 | 0x4F<<7 | 0x18,
	38670 - 19968: jis0208<<14 | 0x4F<<7 | 0x1F,
	38671 - 19968: jis0208<<14 | 0x4F<<7 | 0x21,
	38673 - 19968: jis0208<<14 | 0x4F<<7 | 0x20,
	38675 - 19968: jis0208<<14 | 0x4F<<7 | 0x1E,
	38678 - 19968: jis0208<<14 | 0x4F<<7 | 0x22,
	38681 - 19968: jis0208<<14 | 0x4F<<7 | 0x23,
	38682 - 19968: jis0212<<14 | 0x46<<7 | 0x03,
	38683 - 19968: jis0212<<14 | 0x46<<7 | 0x04,
	38684 - 19968: jis0208<<14 | 0x20<<7 | 0x59,
	38685 - 19968: jis0212<<14 | 0x46<<7 | 0x05,
	38686 - 19968: jis0208<<14 | 0x11<<7 | 0x41,
	38689 - 19968: jis0212<<14 | 0x46<<7 | 0x06,
	38690 - 19968: jis0212<<14 | 0x46<<7 | 0x07,
	38691 - 19968: jis0212<<14 | 0x46<<7 | 0x08,
	38692 - 19968: jis0208<<14 | 0x4F<<7 | 0x24,
	38695 - 19968: jis0208<<14 | 0x2B<<7 | 0x17,
	38696 - 19968: jis0212<<14 | 0x46<<7 | 0x09,
	38698 - 19968: jis0208<<14 | 0x4F<<7 | 0x25,
	38704 - 19968: jis0208<<14 | 0x4F<<7 | 0x26,
	38705 - 19968: jis0212<<14 | 0x46<<7 | 0x0A,
	38706 - 19968: jis0208<<14 | 0x2E<<7 | 0x09,
	38707 - 19968: jis0208<<14 | 0x5B<<7 | 0x32,
	38712 - 19968: jis0208<<14 | 0x3A<<7 | 0x10,
	38713 - 19968: jis0208<<14 | 0x4F<<7 | 0x27,
	38715 - 19968: jis0208<<14 | 0x5B<<7 | 0x33,
	38717 - 19968: jis0208<<14 | 0x4F<<7 | 0x28,
	38718 - 19968: jis0208<<14 | 0x4F<<7 | 0x29,
	38721 - 19968: jis0212<<14 | 0x46<<7 | 0x0C,
	38722 - 19968: jis0208<<14 | 0x4F<<7 | 0x2D,
	38723 - 19968: jis0208<<14 | 0x5B<<7 | 0x34,
	38724 - 19968: jis0208<<14 | 0x4F<<7 | 0x2A,
	38726 - 19968: jis0208<<14 | 0x4F<<7 | 0x2B,
	38728 - 19968: jis0208<<14 | 0x4F<<7 | 0x2C,
	38729 - 19968: jis0208<<14 | 0x4F<<7 | 0x2E,
	38730 - 19968: jis0212<<14 | 0x46<<7 | 0x0E,
	38733 - 19968: jis0208<<14 | 0x5B<<7 | 0x35,
	38734 - 19968: jis0212<<14 | 0x46<<7 | 0x0F,
	38735 - 19968: jis0208<<14 | 0x5B<<7 | 0x36,
	38737 - 19968: jis0208<<14 | 0x5B<<7 | 0x37,
	38738 - 19968: jis0208<<14 | 0x1F<<7 | 0x23,
	38741 - 19968: jis0208<<14 | 0x5B<<7 | 0x38,
	38742 - 19968: jis0208<<14 | 0x2B<<7 | 0x56,
	38743 - 19968: jis0212<<14 | 0x46<<7 | 0x12,
	38744 - 19968: jis0212<<14 | 0x46<<7 | 0x13,
	38745 - 19968: jis0208<<14 | 0x1F<<7 | 0x24,
	38746 - 19968: jis0212<<14 | 0x46<<7 | 0x14,
	38747 - 19968: jis0212<<14 | 0x46<<7 | 0x15,
	38748 - 19968: jis0208<<14 | 0x4F<<7 | 0x2F,
	38750 - 19968: jis0208<<14 | 0x27<<7 | 0x52,
	38752 - 19968: jis0208<<14 | 0x4F<<7 | 0x30,
	38753 - 19968: jis0208<<14 | 0x52<<7 | 0x32,
	38754 - 19968: jis0208<<14 | 0x2B<<7 | 0x2B,
	38755 - 19968: jis0212<<14 | 0x46<<7 | 0x16,
	38756 - 19968: jis0208<<14 | 0x4F<<7 | 0x31,
	38758 - 19968: jis0208<<14 | 0x4F<<7 | 0x32,
	38759 - 19968: jis0212<<14 | 0x46<<7 | 0x17,
	38760 - 19968: jis0208<<14 | 0x4F<<7 | 0x33,
	38761 - 19968: jis0208<<14 | 0x12<<7 | 0x36,
	38762 - 19968: jis0212<<14 | 0x46<<7 | 0x18,
	38763 - 19968: jis0208<<14 | 0x4F<<7 | 0x35,
	38765 - 19968: jis0208<<14 | 0x1E<<7 | 0x38,
	38766 - 19968: jis0212<<14 | 0x46<<7 | 0x19,
	38769 - 19968: jis0208<<14 | 0x4F<<7 | 0x36,
	38771 - 19968: jis0212<<14 | 0x46<<7 | 0x1A,
	38772 - 19968: jis0208<<14 | 0x16<<7 | 0x03,
	38774 - 19968: jis0212<<14 | 0x46<<7 | 0x1B,
	38775 - 19968: jis0212<<14 | 0x46<<7 | 0x1C,
	38776 - 19968: jis0212<<14 | 0x46<<7 | 0x1D,
	38777 - 19968: jis0208<<14 | 0x4F<<7 | 0x37,
	38778 - 19968: jis0208<<14 | 0x4F<<7 | 0x3B,
	38779 - 19968: jis0212<<14 | 0x46<<7 | 0x1E,
	38780 - 19968: jis0208<<14 | 0x4F<<7 | 0x39,
	38781 - 19968: jis0212<<14 | 0x46<<7 | 0x1F,
	38783 - 19968: jis0212<<14 | 0x46<<7 | 0x20,
	38784 - 19968: jis0212<<14 | 0x46<<7 | 0x21,
	38785 - 19968: jis0208<<14 | 0x4F<<7 | 0x3A,
	38788 - 19968: jis0208<<14 | 0x12<<7 | 0x52,
	38789 - 19968: jis0208<<14 | 0x4F<<7 | 0x38,
	38790 - 19968: jis0208<<14 | 0x4F<<7 | 0x3C,
	38793 - 19968: jis0212<<14 | 0x46<<7 | 0x22,
	38795 - 19968: jis0208<<14 | 0x4F<<7 | 0x3D,
	38797 - 19968: jis0208<<14 | 0x0F<<7 | 0x27,
	38799 - 19968: jis0208<<14 | 0x4F<<7 | 0x3E,
	38800 - 19968: jis0208<<14 | 0x4F<<7 | 0x3F,
	38805 - 19968: jis0212<<14 | 0x46<<7 | 0x23,
	38806 - 19968: jis0212<<14 | 0x46<<7 | 0x24,
	38807 - 19968: jis0212<<14 | 0x46<<7 | 0x25,
	38808 - 19968: jis0208<<14 | 0x1D<<7 | 0x43,
	38809 - 19968: jis0212<<14 | 0x46<<7 | 0x26,
	38810 - 19968: jis0212<<14 | 0x46<<7 | 0x27,
	38812 - 19968: jis0208<<14 | 0x4F<<7 | 0x40,
	38814 - 19968: jis0212<<14 | 0x46<<7 | 0x28,
	38815 - 19968: jis0212<<14 | 0x46<<7 | 0x29,
	38816 - 19968: jis0208<<14 | 0x14<<7 | 0x26,
	38818 - 19968: jis0212<<14 | 0x46<<7 | 0x2A,
	38819 - 19968: jis0208<<14 | 0x4F<<7 | 0x43,
	38822 - 19968: jis0208<<14 | 0x4F<<7 | 0x42,
	38824 - 19968: jis0208<<14 | 0x4F<<7 | 0x41,
	38827 - 19968: jis0208<<14 | 0x4A<<7 | 0x50,
	38828 - 19968: jis0212<<14 | 0x46<<7 | 0x2B,
	38829 - 19968: jis0208<<14 | 0x29<<7 | 0x3B,
	38830 - 19968: jis0212<<14 | 0x46<<7 | 0x2C,
	38833 - 19968: jis0212<<14 | 0x46<<7 | 0x2D,
	38834 - 19968: jis0212<<14 | 0x46<<7 | 0x2E,
	38835 - 19968: jis0208<<14 | 0x4F<<7 | 0x44,
	38836 - 19968: jis0208<<14 | 0x4F<<7 | 0x45,
	38837 - 19968: jis0212<<14 | 0x46<<7 | 0x2F,
	38838 - 19968: jis0212<<14 | 0x46<<7 | 0x30,
	38840 - 19968: jis0212<<14 | 0x46<<7 | 0x31,
	38841 - 19968: jis0212<<14 | 0x46<<7 | 0x32,
	38842 - 19968: jis0212<<14 | 0x46<<7 | 0x33,
	38844 - 19968: jis0212<<14 | 0x46<<7 | 0x34,
	38846 - 19968: jis0212<<14 | 0x46<<7 | 0x35,
	38847 - 19968: jis0212<<14 | 0x46<<7 | 0x36,
	38849 - 19968: jis0212<<14 | 0x46<<7 | 0x37,
	38851 - 19968: jis0208<<14 | 0x4F<<7 | 0x46,
	38852 - 19968: jis0212<<14 | 0x46<<7 | 0x38,
	38853 - 19968: jis0212<<14 | 0x46<<7 | 0x39,
	38854 - 19968: jis0208<<14 | 0x4F<<7 | 0x47,
	38855 - 19968: jis0212<<14 | 0x46<<7 | 0x3A,
	38856 - 19968: jis0208<<14 | 0x4F<<7 | 0x48,
	38857 - 19968: jis0212<<14 | 0x46<<7 | 0x3B,
	38858 - 19968: jis0212<<14 | 0x46<<7 | 0x3C,
	38859 - 19968: jis0208<<14 | 0x4F<<7 | 0x49,
	38860 - 19968: jis0212<<14 | 0x46<<7 | 0x3D,
	38861 - 19968: jis0212<<14 | 0x46<<7 | 0x3E,
	38862 - 19968: jis0212<<14 | 0x46<<7 | 0x3F,
	38864 - 19968: jis0212<<14 | 0x46<<7 | 0x40,
	38865 - 19968: jis0212<<14 | 0x46<<7 | 0x41,
	38867 - 19968: jis0208<<14 | 0x13<<7 | 0x39,
	38868 - 19968: jis0212<<14 | 0x46<<7 | 0x42,
	38871 - 19968: jis0212<<14 | 0x46<<7 | 0x43,
	38872 - 19968: jis0212<<14 | 0x46<<7 | 0x44,
	38873 - 19968: jis0212<<14 | 0x46<<7 | 0x45,
	38875 - 19968: jis0212<<14 | 0x46<<7 | 0x49,
	38876 - 19968: jis0208<<14 | 0x4F<<7 | 0x4A,
	38877 - 19968: jis0212<<14 | 0x46<<7 | 0x46,
	38878 - 19968: jis0212<<14 | 0x46<<7 | 0x47,
	38880 - 19968: jis0212<<14 | 0x46<<7 | 0x48,
	38881 - 19968: jis0212<<14 | 0x46<<7 | 0x4A,
	38884 - 19968: jis0212<<14 | 0x46<<7 | 0x4B,
	38893 - 19968: jis0208<<14 | 0x4F<<7 | 0x4B,
	38894 - 19968: jis0208<<14 | 0x26<<7 | 0x02,
	38895 - 19968: jis0212<<14 | 0x46<<7 | 0x4C,
	38897 - 19968: jis0212<<14 | 0x46<<7 | 0x4D,
	38898 - 19968: jis0208<<14 | 0x4F<<7 | 0x4D,
	38899 - 19968: jis0208<<14 | 0x11<<7 | 0x1A,
	38900 - 19968: jis0212<<14 | 0x46<<7 | 0x4E,
	38901 - 19968: jis0208<<14 | 0x4F<<7 | 0x50,
	38902 - 19968: jis0208<<14 | 0x4F<<7 | 0x4F,
	38903 - 19968: jis0212<<14 | 0x46<<7 | 0x4F,
	38904 - 19968: jis0212<<14 | 0x46<<7 | 0x50,
	38906 - 19968: jis0212<<14 | 0x46<<7 | 0x51,
	38907 - 19968: jis0208<<14 | 0x10<<7 | 0x03,
	38911 - 19968: jis0208<<14 | 0x15<<7 | 0x20,
	38913 - 19968: jis0208<<14 | 0x29<<7 | 0x26,
	38914 - 19968: jis0208<<14 | 0x23<<7 | 0x19,
	38915 - 19968: jis0208<<14 | 0x19<<7 | 0x01,
	38917 - 19968: jis0208<<14 | 0x18<<7 | 0x3F,
	38918 - 19968: jis0208<<14 | 0x1C<<7 | 0x46,
	38919 - 19968: jis0212<<14 | 0x46<<7 | 0x52,
	38920 - 19968: jis0208<<14 | 0x1E<<7 | 0x3B,
	38922 - 19968: jis0212<<14 | 0x46<<7 | 0x53,
	38924 - 19968: jis0208<<14 | 0x4F<<7 | 0x52,
	38925 - 19968: jis0212<<14 | 0x46<<7 | 0x55,
	38926 - 19968: jis0212<<14 | 0x46<<7 | 0x56,
	38927 - 19968: jis0208<<14 | 0x4F<<7 | 0x51,
	38928 - 19968: jis0208<<14 | 0x2C<<7 | 0x21,
	38929 - 19968: jis0208<<14 | 0x13<<7 | 0x47,
	38930 - 19968: jis0208<<14 | 0x27<<7 | 0x31,
	38931 - 19968: jis0208<<14 | 0x25<<7 | 0x3B,
	38932 - 19968: jis0212<<14 | 0x46<<7 | 0x57,
	38934 - 19968: jis0212<<14 | 0x46<<7 | 0x58,
	38935 - 19968: jis0208<<14 | 0x1E<<7 | 0x5B,
	38936 - 19968: jis0208<<14 | 0x2D<<7 | 0x2D,
	38937 - 19968: jis0212<<14 | 0x46<<7 | 0x54,
	38938 - 19968: jis0208<<14 | 0x16<<7 | 0x3A,
	38940 - 19968: jis0212<<14 | 0x46<<7 | 0x59,
	38942 - 19968: jis0212<<14 | 0x46<<7 | 0x5A,
	38944 - 19968: jis0212<<14 | 0x46<<7 | 0x5B,
	38945 - 19968: jis0208<<14 | 0x4F<<7 | 0x55,
	38947 - 19968: jis0212<<14 | 0x46<<7 | 0x5C,
	38948 - 19968: jis0208<<14 | 0x4F<<7 | 0x54,
	38949 - 19968: jis0212<<14 | 0x47<<7 | 0x07,
	38950 - 19968: jis0212<<14 | 0x46<<7 | 0x5D,
	38955 - 19968: jis0212<<14 | 0x47<<7 | 0x00,
	38956 - 19968: jis0208<<14 | 0x2A<<7 | 0x2A,
	38957 - 19968: jis0208<<14 | 0x25<<7 | 0x0B,
	38958 - 19968: jis0212<<14 | 0x47<<7 | 0x01,
	38959 - 19968: jis0212<<14 | 0x47<<7 | 0x02,
	38960 - 19968: jis0212<<14 | 0x47<<7 | 0x03,
	38962 - 19968: jis0212<<14 | 0x47<<7 | 0x04,
	38963 - 19968: jis0212<<14 | 0x47<<7 | 0x05,
	38964 - 19968: jis0208<<14 | 0x10<<7 | 0x2F,
	38965 - 19968: jis0212<<14 | 0x47<<7 | 0x06,
	38967 - 19968: jis0208<<14 | 0x4F<<7 | 0x56,
	38968 - 19968: jis0208<<14 | 0x4F<<7 | 0x53,
	38971 - 19968: jis0208<<14 | 0x28<<7 | 0x30,
	38972 - 19968: jis0208<<14 | 0x2C<<7 | 0x49,
	38973 - 19968: jis0208<<14 | 0x4F<<7 | 0x57,
	38974 - 19968: jis0212<<14 | 0x47<<7 | 0x08,
	38980 - 19968: jis0212<<14 | 0x47<<7 | 0x09,
	38982 - 19968: jis0208<<14 | 0x4F<<7 | 0x58,
	38983 - 19968: jis0212<<14 | 0x47<<7 | 0x0A,
	38986 - 19968: jis0212<<14 | 0x47<<7 | 0x0B,
	38987 - 19968: jis0208<<14 | 0x4F<<7 | 0x5A,
	38988 - 19968: jis0208<<14 | 0x21<<7 | 0x49,
	38989 - 19968: jis0208<<14 | 0x12<<7 | 0x3A,
	38990 - 19968: jis0208<<14 | 0x12<<7 | 0x3B,
	38991 - 19968: jis0208<<14 | 0x4F<<7 | 0x59,
	38993 - 19968: jis0212<<14 | 0x47<<7 | 0x0C,
	38994 - 19968: jis0212<<14 | 0x47<<7 | 0x0D,
	38995 - 19968: jis0212<<14 | 0x47<<7 | 0x0E,
	38996 - 19968: jis0208<<14 | 0x13<<7 | 0x48,
	38997 - 19968: jis0208<<14 | 0x17<<7 | 0x11,
	38998 - 19968: jis0212<<14 | 0x47<<7 | 0x0F,
	38999 - 19968: jis0208<<14 | 0x5B<<7 | 0x39,
	39000 - 19968: jis0208<<14 | 0x13<<7 | 0x49,
	39001 - 19968: jis0212<<14 | 0x47<<7 | 0x11,
	39002 - 19968: jis0212<<14 | 0x47<<7 | 0x12,
	39003 - 19968: jis0208<<14 | 0x24<<7 | 0x1E,
	39006 - 19968: jis0208<<14 | 0x2D<<7 | 0x3F,
	39010 - 19968: jis0212<<14 | 0x47<<7 | 0x13,
	39011 - 19968: jis0212<<14 | 0x47<<7 | 0x14,
	39013 - 19968: jis0208<<14 | 0x5B<<7 | 0x3A,
	39014 - 19968: jis0212<<14 | 0x47<<7 | 0x16,
	39015 - 19968: jis0208<<14 | 0x17<<7 | 0x3B,
	39018 - 19968: jis0212<<14 | 0x47<<7 | 0x17,
	39019 - 19968: jis0208<<14 | 0x4F<<7 | 0x5B,
	39020 - 19968: jis0212<<14 | 0x47<<7 | 0x18,
	39023 - 19968: jis0208<<14 | 0x4F<<7 | 0x5C,
	39024 - 19968: jis0208<<14 | 0x4F<<7 | 0x5D,
	39025 - 19968: jis0208<<14 | 0x50<<7 | 0x00,
	39027 - 19968: jis0208<<14 | 0x50<<7 | 0x02,
	39028 - 19968: jis0208<<14 | 0x50<<7 | 0x01,
	39080 - 19968: jis0208<<14 | 0x28<<7 | 0x56,
	39082 - 19968: jis0208<<14 | 0x50<<7 | 0x03,
	39083 - 19968: jis0212<<14 | 0x47<<7 | 0x19,
	39085 - 19968: jis0212<<14 | 0x47<<7 | 0x1A,
	39086 - 19968: jis0212<<14 | 0x47<<7 | 0x1B,
	39087 - 19968: jis0208<<14 | 0x50<<7 | 0x04,
	39088 - 19968: jis0212<<14 | 0x47<<7 | 0x1C,
	39089 - 19968: jis0208<<14 | 0x50<<7 | 0x05,
	39092 - 19968: jis0212<<14 | 0x47<<7 | 0x1D,
	39094 - 19968: jis0208<<14 | 0x50<<7 | 0x06,
	39095 - 19968: jis0212<<14 | 0x47<<7 | 0x1E,
	39096 - 19968: jis0212<<14 | 0x47<<7 | 0x1F,
	39098 - 19968: jis0212<<14 | 0x47<<7 | 0x20,
	39099 - 19968: jis0212<<14 | 0x47<<7 | 0x21,
	39103 - 19968: jis0212<<14 | 0x47<<7 | 0x22,
	39106 - 19968: jis0212<<14 | 0x47<<7 | 0x23,
	39107 - 19968: jis0208<<14 | 0x50<<7 | 0x08,
	39108 - 19968: jis0208<<14 | 0x50<<7 | 0x07,
	39109 - 19968: jis0212<<14 | 0x47<<7 | 0x24,
	39110 - 19968: jis0208<<14 | 0x50<<7 | 0x09,
	39112 - 19968: jis0212<<14 | 0x47<<7 | 0x25,
	39116 - 19968: jis0212<<14 | 0x47<<7 | 0x26,
	39131 - 19968: jis0208<<14 | 0x27<<7 | 0x53,
	39132 - 19968: jis0208<<14 | 0x45<<7 | 0x2B,
	39135 - 19968: jis0208<<14 | 0x1E<<7 | 0x08,
	39137 - 19968: jis0212<<14 | 0x47<<7 | 0x27,
	39138 - 19968: jis0208<<14 | 0x14<<7 | 0x11,
	39139 - 19968: jis0212<<14 | 0x47<<7 | 0x28,
	39141 - 19968: jis0212<<14 | 0x47<<7 | 0x29,
	39142 - 19968: jis0212<<14 | 0x47<<7 | 0x2A,
	39143 - 19968: jis0212<<14 | 0x47<<7 | 0x2B,
	39145 - 19968: jis0208<<14 | 0x50<<7 | 0x0A,
	39146 - 19968: jis0212<<14 | 0x47<<7 | 0x2C,
	39147 - 19968: jis0208<<14 | 0x50<<7 | 0x0B,
	39149 - 19968: jis0208<<14 | 0x31<<7 | 0x0B,
	39150 - 19968: jis0208<<14 | 0x3C<<7 | 0x1A,
	39151 - 19968: jis0208<<14 | 0x27<<7 | 0x32,
	39154 - 19968: jis0208<<14 | 0x0F<<7 | 0x5A,
	39155 - 19968: jis0212<<14 | 0x47<<7 | 0x2D,
	39156 - 19968: jis0208<<14 | 0x0F<<7 | 0x1A,
	39158 - 19968: jis0212<<14 | 0x47<<7 | 0x2E,
	39164 - 19968: jis0208<<14 | 0x1A<<7 | 0x53,
	39165 - 19968: jis0208<<14 | 0x2A<<7 | 0x0F,
	39166 - 19968: jis0208<<14 | 0x1D<<7 | 0x5D,
	39170 - 19968: jis0212<<14 | 0x47<<7 | 0x2F,
	39171 - 19968: jis0208<<14 | 0x50<<7 | 0x0C,
	39173 - 19968: jis0208<<14 | 0x2B<<7 | 0x3E,
	39175 - 19968: jis0212<<14 | 0x47<<7 | 0x30,
	39176 - 19968: jis0212<<14 | 0x47<<7 | 0x31,
	39177 - 19968: jis0208<<14 | 0x50<<7 | 0x0D,
	39178 - 19968: jis0208<<14 | 0x2C<<7 | 0x3B,
	39180 - 19968: jis0208<<14 | 0x10<<7 | 0x21,
	39184 - 19968: jis0208<<14 | 0x1A<<7 | 0x20,
	39185 - 19968: jis0212<<14 | 0x47<<7 | 0x32,
	39186 - 19968: jis0208<<14 | 0x50<<7 | 0x0E,
	39187 - 19968: jis0208<<14 | 0x11<<7 | 0x4D,
	39188 - 19968: jis0208<<14 | 0x50<<7 | 0x0F,
	39189 - 19968: jis0212<<14 | 0x47<<7 | 0x33,
	39190 - 19968: jis0212<<14 | 0x47<<7 | 0x34,
	39191 - 19968: jis0212<<14 | 0x47<<7 | 0x35,
	39192 - 19968: jis0208<<14 | 0x50<<7 | 0x10,
	39194 - 19968: jis0212<<14 | 0x47<<7 | 0x36,
	39195 - 19968: jis0212<<14 | 0x47<<7 | 0x37,
	39196 - 19968: jis0212<<14 | 0x47<<7 | 0x38,
	39197 - 19968: jis0208<<14 | 0x50<<7 | 0x12,
	39198 - 19968: jis0208<<14 | 0x50<<7 | 0x13,
	39199 - 19968: jis0212<<14 | 0x47<<7 | 0x39,
	39200 - 19968: jis0208<<14 | 0x50<<7 | 0x15,
	39201 - 19968: jis0208<<14 | 0x50<<7 | 0x11,
	39202 - 19968: jis0212<<14 | 0x47<<7 | 0x3A,
	39204 - 19968: jis0208<<14 | 0x50<<7 | 0x14,
	39206 - 19968: jis0212<<14 | 0x47<<7 | 0x3B,
	39207 - 19968: jis0208<<14 | 0x5B<<7 | 0x3D,
	39208 - 19968: jis0208<<14 | 0x13<<7 | 0x3A,
	39211 - 19968: jis0212<<14 | 0x47<<7 | 0x3D,
	39212 - 19968: jis0208<<14 | 0x50<<7 | 0x16,
	39214 - 19968: jis0208<<14 | 0x50<<7 | 0x17,
	39217 - 19968: jis0212<<14 | 0x47<<7 | 0x3E,
	39218 - 19968: jis0212<<14 | 0x47<<7 | 0x3F,
	39219 - 19968: jis0212<<14 | 0x47<<7 | 0x40,
	39220 - 19968: jis0212<<14 | 0x47<<7 | 0x41,
	39221 - 19968: jis0212<<14 | 0x47<<7 | 0x42,
	39225 - 19968: jis0212<<14 | 0x47<<7 | 0x43,
	39226 - 19968: jis0212<<14 | 0x47<<7 | 0x44,
	39227 - 19968: jis0212<<14 | 0x47<<7 | 0x45,
	39228 - 19968: jis0212<<14 | 0x47<<7 | 0x46,
	39229 - 19968: jis0208<<14 | 0x50<<7 | 0x18,
	39230 - 19968: jis0208<<14 | 0x50<<7 | 0x19,
	39232 - 19968: jis0212<<14 | 0x47<<7 | 0x47,
	39233 - 19968: jis0212<<14 | 0x47<<7 | 0x48,
	39234 - 19968: jis0208<<14 | 0x50<<7 | 0x1A,
	39237 - 19968: jis0208<<14 | 0x50<<7 | 0x1C,
	39238 - 19968: jis0212<<14 | 0x47<<7 | 0x49,
	39239 - 19968: jis0212<<14 | 0x47<<7 | 0x4A,
	39240 - 19968: jis0212<<14 | 0x47<<7 | 0x4B,
	39241 - 19968: jis0208<<14 | 0x50<<7 | 0x1B,
	39243 - 19968: jis0208<<14 | 0x50<<7 | 0x1E,
	39244 - 19968: jis0208<<14 | 0x50<<7 | 0x21,
	39245 - 19968: jis0212<<14 | 0x47<<7 | 0x4C,
	39246 - 19968: jis0212<<14 | 0x47<<7 | 0x4D,
	39248 - 19968: jis0208<<14 | 0x50<<7 | 0x1D,
	39249 - 19968: jis0208<<14 | 0x50<<7 | 0x1F,
	39250 - 19968: jis0208<<14 | 0x50<<7 | 0x20,
	39252 - 19968: jis0212<<14 | 0x47<<7 | 0x4E,
	39253 - 19968: jis0208<<14 | 0x50<<7 | 0x22,
	39255 - 19968: jis0208<<14 | 0x15<<7 | 0x21,
	39256 - 19968: jis0212<<14 | 0x47<<7 | 0x4F,
	39257 - 19968: jis0212<<14 | 0x47<<7 | 0x50,
	39259 - 19968: jis0212<<14 | 0x47<<7 | 0x51,
	39260 - 19968: jis0212<<14 | 0x47<<7 | 0x52,
	39262 - 19968: jis0212<<14 | 0x47<<7 | 0x53,
	39263 - 19968: jis0212<<14 | 0x47<<7 | 0x54,
	39264 - 19968: jis0212<<14 | 0x47<<7 | 0x55,
	39318 - 19968: jis0208<<14 | 0x1B<<7 | 0x52,
	39319 - 19968: jis0208<<14 | 0x50<<7 | 0x23,
	39320 - 19968: jis0208<<14 | 0x50<<7 | 0x24,
	39321 - 19968: jis0208<<14 | 0x18<<7 | 0x40,
	39323 - 19968: jis0212<<14 | 0x47<<7 | 0x56,
	39325 - 19968: jis0212<<14 | 0x47<<7 | 0x57,
	39326 - 19968: jis0208<<14 | 0x5B<<7 | 0x3F,
	39327 - 19968: jis0212<<14 | 0x47<<7 | 0x58,
	39333 - 19968: jis0208<<14 | 0x50<<7 | 0x25,
	39334 - 19968: jis0212<<14 | 0x47<<7 | 0x59,
	39336 - 19968: jis0208<<14 | 0x12<<7 | 0x1D,
	39340 - 19968: jis0208<<14 | 0x26<<7 | 0x2E,
	39341 - 19968: jis0208<<14 | 0x50<<7 | 0x26,
	39342 - 19968: jis0208<<14 | 0x50<<7 | 0x27,
	39344 - 19968: jis0212<<14 | 0x47<<7 | 0x5A,
	39345 - 19968: jis0212<<14 | 0x47<<7 | 0x5B,
	39346 - 19968: jis0212<<14 | 0x47<<7 | 0x5C,
	39347 - 19968: jis0208<<14 | 0x22<<7 | 0x39,
	39348 - 19968: jis0208<<14 | 0x25<<7 | 0x4A,
	39349 - 19968: jis0212<<14 | 0x47<<7 | 0x5D,
	39353 - 19968: jis0212<<14 | 0x48<<7 | 0x00,
	39354 - 19968: jis0212<<14 | 0x48<<7 | 0x01,
	39356 - 19968: jis0208<<14 | 0x50<<7 | 0x28,
	39357 - 19968: jis0212<<14 | 0x48<<7 | 0x02,
	39359 - 19968: jis0212<<14 | 0x48<<7 | 0x03,
	39361 - 19968: jis0208<<14 | 0x26<<7 | 0x5C,
	39363 - 19968: jis0212<<14 | 0x48<<7 | 0x04,
	39364 - 19968: jis0208<<14 | 0x21<<7 | 0x2B,
	39365 - 19968: jis0208<<14 | 0x10<<7 | 0x37,
	39366 - 19968: jis0208<<14 | 0x15<<7 | 0x4D,
	39368 - 19968: jis0208<<14 | 0x15<<7 | 0x4E,
	39369 - 19968: jis0212<<14 | 0x48<<7 | 0x05,
	39376 - 19968: jis0208<<14 | 0x22<<7 | 0x52,
	39377 - 19968: jis0208<<14 | 0x50<<7 | 0x2D,
	39378 - 19968: jis0208<<14 | 0x15<<7 | 0x4F,
	39379 - 19968: jis0212<<14 | 0x48<<7 | 0x06,
	39380 - 19968: jis0212<<14 | 0x48<<7 | 0x07,
	39381 - 19968: jis0208<<14 | 0x11<<7 | 0x4E,
	39384 - 19968: jis0208<<14 | 0x50<<7 | 0x2C,
	39385 - 19968: jis0212<<14 | 0x48<<7 | 0x08,
	39386 - 19968: jis0212<<14 | 0x48<<7 | 0x09,
	39387 - 19968: jis0208<<14 | 0x50<<7 | 0x2A,
	39388 - 19968: jis0212<<14 | 0x48<<7 | 0x0A,
	39389 - 19968: jis0208<<14 | 0x50<<7 | 0x2B,
	39390 - 19968: jis0212<<14 | 0x48<<7 | 0x0B,
	39391 - 19968: jis0208<<14 | 0x50<<7 | 0x29,
	39394 - 19968: jis0208<<14 | 0x50<<7 | 0x37,
	39399 - 19968: jis0212<<14 | 0x48<<7 | 0x0C,
	39402 - 19968: jis0212<<14 | 0x48<<7 | 0x0D,
	39403 - 19968: jis0212<<14 | 0x48<<7 | 0x0E,
	39404 - 19968: jis0212<<14 | 0x48<<7 | 0x0F,
	39405 - 19968: jis0208<<14 | 0x50<<7 | 0x2E,
	39406 - 19968: jis0208<<14 | 0x50<<7 | 0x2F,
	39408 - 19968: jis0212<<14 | 0x48<<7 | 0x10,
	39409 - 19968: jis0208<<14 | 0x50<<7 | 0x30,
	39410 - 19968: jis0208<<14 | 0x50<<7 | 0x31,
	39412 - 19968: jis0212<<14 | 0x48<<7 | 0x11,
	39413 - 19968: jis0212<<14 | 0x48<<7 | 0x12,
	39416 - 19968: jis0208<<14 | 0x50<<7 | 0x33,
	39417 - 19968: jis0212<<14 | 0x48<<7 | 0x13,
	39419 - 19968: jis0208<<14 | 0x50<<7 | 0x32,
	39421 - 19968: jis0212<<14 | 0x48<<7 | 0x14,
	39422 - 19968: jis0212<<14 | 0x48<<7 | 0x15,
	39423 - 19968: jis0208<<14 | 0x1C<<7 | 0x38,
	39425 - 19968: jis0208<<14 | 0x50<<7 | 0x34,
	39426 - 19968: jis0212<<14 | 0x48<<7 | 0x16,
	39427 - 19968: jis0212<<14 | 0x48<<7 | 0x17,
	39428 - 19968: jis0212<<14 | 0x48<<7 | 0x18,
	39429 - 19968: jis0208<<14 | 0x50<<7 | 0x36,
	39435 - 19968: jis0212<<14 | 0x48<<7 | 0x19,
	39436 - 19968: jis0212<<14 | 0x48<<7 | 0x1A,
	39438 - 19968: jis0208<<14 | 0x14<<7 | 0x12,
	39439 - 19968: jis0208<<14 | 0x50<<7 | 0x35,
	39440 - 19968: jis0212<<14 | 0x48<<7 | 0x1B,
	39441 - 19968: jis0212<<14 | 0x48<<7 | 0x1C,
	39442 - 19968: jis0208<<14 | 0x20<<7 | 0x5A,
	39443 - 19968: jis0208<<14 | 0x17<<7 | 0x12,
	39446 - 19968: jis0212<<14 | 0x48<<7 | 0x1D,
	39449 - 19968: jis0208<<14 | 0x50<<7 | 0x38,
	39454 - 19968: jis0212<<14 | 0x48<<7 | 0x1E,
	39456 - 19968: jis0212<<14 | 0x48<<7 | 0x1F,
	39458 - 19968: jis0212<<14 | 0x48<<7 | 0x20,
	39459 - 19968: jis0212<<14 | 0x48<<7 | 0x21,
	39460 - 19968: jis0212<<14 | 0x48<<7 | 0x22,
	39463 - 19968: jis0212<<14 | 0x48<<7 | 0x23,
	39464 - 19968: jis0208<<14 | 0x21<<7 | 0x2C,
	39467 - 19968: jis0208<<14 | 0x50<<7 | 0x39,
	39469 - 19968: jis0212<<14 | 0x48<<7 | 0x24,
	39470 - 19968: jis0212<<14 | 0x48<<7 | 0x25,
	39472 - 19968: jis0208<<14 | 0x25<<7 | 0x0C,
	39475 - 19968: jis0212<<14 | 0x48<<7 | 0x26,
	39477 - 19968: jis0212<<14 | 0x48<<7 | 0x27,
	39478 - 19968: jis0212<<14 | 0x48<<7 | 0x28,
	39479 - 19968: jis0208<<14 | 0x50<<7 | 0x3A,
	39480 - 19968: jis0212<<14 | 0x48<<7 | 0x29,
	39486 - 19968: jis0208<<14 | 0x50<<7 | 0x3F,
	39488 - 19968: jis0208<<14 | 0x50<<7 | 0x3D,
	39489 - 19968: jis0212<<14 | 0x48<<7 | 0x2B,
	39490 - 19968: jis0208<<14 | 0x50<<7 | 0x3C,
	39491 - 19968: jis0208<<14 | 0x50<<7 | 0x3E,
	39492 - 19968: jis0212<<14 | 0x48<<7 | 0x2C,
	39493 - 19968: jis0208<<14 | 0x50<<7 | 0x3B,
	39495 - 19968: jis0212<<14 | 0x48<<7 | 0x2A,
	39498 - 19968: jis0212<<14 | 0x48<<7 | 0x2D,
	39499 - 19968: jis0212<<14 | 0x48<<7 | 0x2E,
	39500 - 19968: jis0212<<14 | 0x48<<7 | 0x2F,
	39501 - 19968: jis0208<<14 | 0x50<<7 | 0x41,
	39502 - 19968: jis0208<<14 | 0x5B<<7 | 0x40,
	39505 - 19968: jis0212<<14 | 0x48<<7 | 0x31,
	39508 - 19968: jis0212<<14 | 0x48<<7 | 0x32,
	39509 - 19968: jis0208<<14 | 0x50<<7 | 0x40,
	39510 - 19968: jis0212<<14 | 0x48<<7 | 0x33,
	39511 - 19968: jis0208<<14 | 0x50<<7 | 0x43,
	39514 - 19968: jis0208<<14 | 0x15<<7 | 0x22,
	39515 - 19968: jis0208<<14 | 0x50<<7 | 0x42,
	39517 - 19968: jis0212<<14 | 0x48<<7 | 0x34,
	39519 - 19968: jis0208<<14 | 0x50<<7 | 0x44,
	39522 - 19968: jis0208<<14 | 0x50<<7 | 0x45,
	39524 - 19968: jis0208<<14 | 0x50<<7 | 0x47,
	39525 - 19968: jis0208<<14 | 0x50<<7 | 0x46,
	39529 - 19968: jis0208<<14 | 0x50<<7 | 0x48,
	39530 - 19968: jis0208<<14 | 0x50<<7 | 0x4A,
	39531 - 19968: jis0208<<14 | 0x50<<7 | 0x49,
	39592 - 19968: jis0208<<14 | 0x18<<7 | 0x5B,
	39594 - 19968: jis0212<<14 | 0x48<<7 | 0x35,
	39596 - 19968: jis0212<<14 | 0x48<<7 | 0x36,
	39597 - 19968: jis0208<<14 | 0x50<<7 | 0x4B,
	39598 - 19968: jis0212<<14 | 0x48<<7 | 0x37,
	39599 - 19968: jis0212<<14 | 0x48<<7 | 0x38,
	39600 - 19968: jis0208<<14 | 0x50<<7 | 0x4C,
	39602 - 19968: jis0212<<14 | 0x48<<7 | 0x39,
	39604 - 19968: jis0212<<14 | 0x48<<7 | 0x3A,
	39605 - 19968: jis0212<<14 | 0x48<<7 | 0x3B,
	39606 - 19968: jis0212<<14 | 0x48<<7 | 0x3C,
	39608 - 19968: jis0208<<14 | 0x12<<7 | 0x1B,
	39609 - 19968: jis0212<<14 | 0x48<<7 | 0x3D,
	39611 - 19968: jis0212<<14 | 0x48<<7 | 0x3E,
	39612 - 19968: jis0208<<14 | 0x50<<7 | 0x4D,
	39614 - 19968: jis0212<<14 | 0x48<<7 | 0x3F,
	39615 - 19968: jis0212<<14 | 0x48<<7 | 0x40,
	39616 - 19968: jis0208<<14 | 0x50<<7 | 0x4E,
	39617 - 19968: jis0212<<14 | 0x48<<7 | 0x41,
	39619 - 19968: jis0212<<14 | 0x48<<7 | 0x42,
	39620 - 19968: jis0208<<14 | 0x1E<<7 | 0x50,
	39622 - 19968: jis0212<<14 | 0x48<<7 | 0x43,
	39624 - 19968: jis0212<<14 | 0x48<<7 | 0x44,
	39630 - 19968: jis0212<<14 | 0x48<<7 | 0x45,
	39631 - 19968: jis0208<<14 | 0x50<<7 | 0x4F,
	39632 - 19968: jis0212<<14 | 0x48<<7 | 0x46,
	39633 - 19968: jis0208<<14 | 0x50<<7 | 0x50,
	39634 - 19968: jis0212<<14 | 0x48<<7 | 0x47,
	39635 - 19968: jis0208<<14 | 0x50<<7 | 0x51,
	39636 - 19968: jis0208<<14 | 0x50<<7 | 0x52,
	39637 - 19968: jis0212<<14 | 0x48<<7 | 0x48,
	39638 - 19968: jis0212<<14 | 0x48<<7 | 0x49,
	39639 - 19968: jis0212<<14 | 0x48<<7 | 0x4A,
	39640 - 19968: jis0208<<14 | 0x18<<7 | 0x41,
	39641 - 19968: jis0208<<14 | 0x5B<<7 | 0x41,
	39643 - 19968: jis0212<<14 | 0x48<<7 | 0x4B,
	39644 - 19968: jis0208<<14 | 0x5B<<7 | 0x42,
	39646 - 19968: jis0208<<14 | 0x50<<7 | 0x53,
	39647 - 19968: jis0208<<14 | 0x50<<7 | 0x54,
	39648 - 19968: jis0212<<14 | 0x48<<7 | 0x4D,
	39650 - 19968: jis0208<<14 | 0x50<<7 | 0x55,
	39651 - 19968: jis0208<<14 | 0x50<<7 | 0x56,
	39652 - 19968: jis0212<<14 | 0x48<<7 | 0x4E,
	39653 - 19968: jis0212<<14 | 0x48<<7 | 0x4F,
	39654 - 19968: jis0208<<14 | 0x50<<7 | 0x57,
	39655 - 19968: jis0212<<14 | 0x48<<7 | 0x50,
	39657 - 19968: jis0212<<14 | 0x48<<7 | 0x51,
	39658 - 19968: jis0208<<14 | 0x27<<7 | 0x10,
	39659 - 19968: jis0208<<14 | 0x50<<7 | 0x59,
	39660 - 19968: jis0212<<14 | 0x48<<7 | 0x52,
	39661 - 19968: jis0208<<14 | 0x28<<7 | 0x05,
	39662 - 19968: jis0208<<14 | 0x50<<7 | 0x5A,
	39663 - 19968: jis0208<<14 | 0x50<<7 | 0x58,
	39665 - 19968: jis0208<<14 | 0x50<<7 | 0x5C,
	39666 - 19968: jis0212<<14 | 0x48<<7 | 0x53,
	39667 - 19968: jis0212<<14 | 0x48<<7 | 0x54,
	39668 - 19968: jis0208<<14 | 0x50<<7 | 0x5B,
	39669 - 19968: jis0212<<14 | 0x48<<7 | 0x55,
	39671 - 19968: jis0208<<14 | 0x50<<7 | 0x5D,
	39673 - 19968: jis0212<<14 | 0x48<<7 | 0x56,
	39674 - 19968: jis0212<<14 | 0x48<<7 | 0x57,
	39675 - 19968: jis0208<<14 | 0x51<<7 | 0x00,
	39677 - 19968: jis0212<<14 | 0x48<<7 | 0x58,
	39679 - 19968: jis0212<<14 | 0x48<<7 | 0x59,
	39680 - 19968: jis0212<<14 | 0x48<<7 | 0x5A,
	39681 - 19968: jis0212<<14 | 0x48<<7 | 0x5B,
	39682 - 19968: jis0212<<14 | 0x48<<7 | 0x5C,
	39683 - 19968: jis0212<<14 | 0x48<<7 | 0x5D,
	39684 - 19968: jis0212<<14 | 0x49<<7 | 0x00,
	39685 - 19968: jis0212<<14 | 0x49<<7 | 0x01,
	39686 - 19968: jis0208<<14 | 0x51<<7 | 0x01,
	39688 - 19968: jis0212<<14 | 0x49<<7 | 0x02,
	39689 - 19968: jis0212<<14 | 0x49<<7 | 0x03,
	39691 - 19968: jis0212<<14 | 0x49<<7 | 0x04,
	39692 - 19968: jis0212<<14 | 0x49<<7 | 0x05,
	39693 - 19968: jis0212<<14 | 0x49<<7 | 0x06,
	39694 - 19968: jis0212<<14 | 0x49<<7 | 0x07,
	39696 - 19968: jis0212<<14 | 0x49<<7 | 0x08,
	39698 - 19968: jis0212<<14 | 0x49<<7 | 0x09,
	39702 - 19968: jis0212<<14 | 0x49<<7 | 0x0A,
	39704 - 19968: jis0208<<14 | 0x51<<7 | 0x02,
	39705 - 19968: jis0212<<14 | 0x49<<7 | 0x0B,
	39706 - 19968: jis0208<<14 | 0x51<<7 | 0x03,
	39707 - 19968: jis0212<<14 | 0x49<<7 | 0x0C,
	39708 - 19968: jis0212<<14 | 0x49<<7 | 0x0D,
	39711 - 19968: jis0208<<14 | 0x51<<7 | 0x04,
	39712 - 19968: jis0212<<14 | 0x49<<7 | 0x0E,
	39714 - 19968: jis0208<<14 | 0x51<<7 | 0x05,
	39715 - 19968: jis0208<<14 | 0x51<<7 | 0x06,
	39717 - 19968: jis0208<<14 | 0x51<<7 | 0x07,
	39718 - 19968: jis0212<<14 | 0x49<<7 | 0x0F,
	39719 - 19968: jis0208<<14 | 0x51<<7 | 0x08,
	39720 - 19968: jis0208<<14 | 0x51<<7 | 0x09,
	39721 - 19968: jis0208<<14 | 0x51<<7 | 0x0A,
	39722 - 19968: jis0208<<14 | 0x51<<7 | 0x0B,
	39723 - 19968: jis0212<<14 | 0x49<<7 | 0x10,
	39725 - 19968: jis0212<<14 | 0x49<<7 | 0x11,
	39726 - 19968: jis0208<<14 | 0x51<<7 | 0x0C,
	39727 - 19968: jis0208<<14 | 0x51<<7 | 0x0D,
	39729 - 19968: jis0208<<14 | 0x3C<<7 | 0x14,
	39730 - 19968: jis0208<<14 | 0x51<<7 | 0x0E,
	39731 - 19968: jis0212<<14 | 0x49<<7 | 0x12,
	39732 - 19968: jis0212<<14 | 0x49<<7 | 0x13,
	39733 - 19968: jis0212<<14 | 0x49<<7 | 0x14,
	39735 - 19968: jis0212<<14 | 0x49<<7 | 0x15,
	39737 - 19968: jis0212<<14 | 0x49<<7 | 0x16,
	39738 - 19968: jis0212<<14 | 0x49<<7 | 0x17,
	39739 - 19968: jis0208<<14 | 0x43<<7 | 0x57,
	39740 - 19968: jis0208<<14 | 0x14<<7 | 0x13,
	39741 - 19968: jis0212<<14 | 0x49<<7 | 0x18,
	39745 - 19968: jis0208<<14 | 0x12<<7 | 0x00,
	39746 - 19968: jis0208<<14 | 0x19<<7 | 0x11,
	39747 - 19968: jis0208<<14 | 0x51<<7 | 0x10,
	39748 - 19968: jis0208<<14 | 0x51<<7 | 0x0F,
	39749 - 19968: jis0208<<14 | 0x2B<<7 | 0x04,
	39752 - 19968: jis0212<<14 | 0x49<<7 | 0x19,
	39755 - 19968: jis0212<<14 | 0x49<<7 | 0x1A,
	39756 - 19968: jis0212<<14 | 0x49<<7 | 0x1B,
	39757 - 19968: jis0208<<14 | 0x51<<7 | 0x12,
	39758 - 19968: jis0208<<14 | 0x51<<7 | 0x13,
	39759 - 19968: jis0208<<14 | 0x51<<7 | 0x11,
	39761 - 19968: jis0208<<14 | 0x51<<7 | 0x14,
	39764 - 19968: jis0208<<14 | 0x2A<<7 | 0x41,
	39765 - 19968: jis0212<<14 | 0x49<<7 | 0x1C,
	39766 - 19968: jis0212<<14 | 0x49<<7 | 0x1D,
	39767 - 19968: jis0212<<14 | 0x49<<7 | 0x1E,
	39768 - 19968: jis0208<<14 | 0x51<<7 | 0x15,
	39770 - 19968: jis0208<<14 | 0x14<<7 | 0x5A,
	39771 - 19968: jis0212<<14 | 0x49<<7 | 0x1F,
	39774 - 19968: jis0212<<14 | 0x49<<7 | 0x20,
	39777 - 19968: jis0212<<14 | 0x49<<7 | 0x21,
	39779 - 19968: jis0212<<14 | 0x49<<7 | 0x22,
	39781 - 19968: jis0212<<14 | 0x49<<7 | 0x23,
	39782 - 19968: jis0212<<14 | 0x49<<7 | 0x24,
	39784 - 19968: jis0212<<14 | 0x49<<7 | 0x25,
	39786 - 19968: jis0212<<14 | 0x49<<7 | 0x26,
	39787 - 19968: jis0212<<14 | 0x49<<7 | 0x27,
	39788 - 19968: jis0212<<14 | 0x49<<7 | 0x28,
	39789 - 19968: jis0212<<14 | 0x49<<7 | 0x29,
	39790 - 19968: jis0212<<14 | 0x49<<7 | 0x2A,
	39791 - 19968: jis0208<<14 | 0x2E<<7 | 0x04,
	39794 - 19968: jis0208<<14 | 0x5B<<7 | 0x44,
	39795 - 19968: jis0212<<14 | 0x49<<7 | 0x2B,
	39796 - 19968: jis0208<<14 | 0x51<<7 | 0x16,
	39797 - 19968: jis0208<<14 | 0x5B<<7 | 0x43,
	39799 - 19968: jis0212<<14 | 0x49<<7 | 0x2D,
	39800 - 19968: jis0212<<14 | 0x49<<7 | 0x2E,
	39801 - 19968: jis0212<<14 | 0x49<<7 | 0x2F,
	39807 - 19968: jis0212<<14 | 0x49<<7 | 0x30,
	39808 - 19968: jis0212<<14 | 0x49<<7 | 0x31,
	39811 - 19968: jis0208<<14 | 0x51<<7 | 0x18,
	39812 - 19968: jis0212<<14 | 0x49<<7 | 0x32,
	39813 - 19968: jis0212<<14 | 0x49<<7 | 0x33,
	39814 - 19968: jis0212<<14 | 0x49<<7 | 0x34,
	39815 - 19968: jis0212<<14 | 0x49<<7 | 0x35,
	39817 - 19968: jis0212<<14 | 0x49<<7 | 0x36,
	39818 - 19968: jis0212<<14 | 0x49<<7 | 0x37,
	39819 - 19968: jis0212<<14 | 0x49<<7 | 0x38,
	39821 - 19968: jis0212<<14 | 0x49<<7 | 0x39,
	39822 - 19968: jis0208<<14 | 0x0F<<7 | 0x1D,
	39823 - 19968: jis0208<<14 | 0x5B<<7 | 0x45,
	39824 - 19968: jis0212<<14 | 0x49<<7 | 0x3B,
	39825 - 19968: jis0208<<14 | 0x51<<7 | 0x19,
	39826 - 19968: jis0208<<14 | 0x29<<7 | 0x0A,
	39827 - 19968: jis0208<<14 | 0x51<<7 | 0x17,
	39828 - 19968: jis0212<<14 | 0x49<<7 | 0x3C,
	39830 - 19968: jis0208<<14 | 0x51<<7 | 0x1A,
	39831 - 19968: jis0208<<14 | 0x51<<7 | 0x1B,
	39834 - 19968: jis0212<<14 | 0x49<<7 | 0x3D,
	39837 - 19968: jis0212<<14 | 0x49<<7 | 0x3E,
	39838 - 19968: jis0212<<14 | 0x49<<7 | 0x3F,
	39839 - 19968: jis0208<<14 | 0x51<<7 | 0x1C,
	39840 - 19968: jis0208<<14 | 0x51<<7 | 0x1D,
	39846 - 19968: jis0212<<14 | 0x49<<7 | 0x40,
	39847 - 19968: jis0212<<14 | 0x49<<7 | 0x41,
	39848 - 19968: jis0208<<14 | 0x51<<7 | 0x1E,
	39849 - 19968: jis0212<<14 | 0x49<<7 | 0x42,
	39850 - 19968: jis0208<<14 | 0x2A<<7 | 0x4D,
	39851 - 19968: jis0208<<14 | 0x1A<<7 | 0x0C,
	39852 - 19968: jis0212<<14 | 0x49<<7 | 0x43,
	39853 - 19968: jis0208<<14 | 0x19<<7 | 0x59,
	39854 - 19968: jis0208<<14 | 0x20<<7 | 0x0E,
	39856 - 19968: jis0212<<14 | 0x49<<7 | 0x44,
	39857 - 19968: jis0208<<14 | 0x5B<<7 | 0x46,
	39858 - 19968: jis0212<<14 | 0x49<<7 | 0x46,
	39860 - 19968: jis0208<<14 | 0x51<<7 | 0x1F,
	39863 - 19968: jis0212<<14 | 0x49<<7 | 0x47,
	39864 - 19968: jis0212<<14 | 0x49<<7 | 0x48,
	39865 - 19968: jis0208<<14 | 0x51<<7 | 0x22,
	39867 - 19968: jis0208<<14 | 0x5B<<7 | 0x47,
	39868 - 19968: jis0212<<14 | 0x49<<7 | 0x4A,
	39870 - 19968: jis0212<<14 | 0x49<<7 | 0x4B,
	39871 - 19968: jis0212<<14 | 0x49<<7 | 0x4C,
	39872 - 19968: jis0208<<14 | 0x51<<7 | 0x20,
	39873 - 19968: jis0212<<14 | 0x49<<7 | 0x4D,
	39878 - 19968: jis0208<<14 | 0x51<<7 | 0x23,
	39879 - 19968: jis0212<<14 | 0x49<<7 | 0x4E,
	39880 - 19968: jis0212<<14 | 0x49<<7 | 0x4F,
	39881 - 19968: jis0208<<14 | 0x17<<7 | 0x50,
	39882 - 19968: jis0208<<14 | 0x51<<7 | 0x21,
	39886 - 19968: jis0212<<14 | 0x49<<7 | 0x50,
	39887 - 19968: jis0208<<14 | 0x51<<7 | 0x24,
	39888 - 19968: jis0212<<14 | 0x49<<7 | 0x51,
	39889 - 19968: jis0208<<14 | 0x51<<7 | 0x25,
	39890 - 19968: jis0208<<14 | 0x51<<7 | 0x26,
	39892 - 19968: jis0208<<14 | 0x51<<7 | 0x2A,
	39894 - 19968: jis0208<<14 | 0x1A<<7 | 0x09,
	39895 - 19968: jis0212<<14 | 0x49<<7 | 0x52,
	39896 - 19968: jis0212<<14 | 0x49<<7 | 0x53,
	39899 - 19968: jis0208<<14 | 0x21<<7 | 0x43,
	39901 - 19968: jis0212<<14 | 0x49<<7 | 0x54,
	39903 - 19968: jis0212<<14 | 0x49<<7 | 0x55,
	39905 - 19968: jis0208<<14 | 0x51<<7 | 0x2B,
	39906 - 19968: jis0208<<14 | 0x51<<7 | 0x28,
	39907 - 19968: jis0208<<14 | 0x51<<7 | 0x27,
	39908 - 19968: jis0208<<14 | 0x51<<7 | 0x29,
	39909 - 19968: jis0212<<14 | 0x49<<7 | 0x56,
	39911 - 19968: jis0212<<14 | 0x49<<7 | 0x57,
	39912 - 19968: jis0208<<14 | 0x16<<7 | 0x3E,
	39914 - 19968: jis0212<<14 | 0x49<<7 | 0x58,
	39915 - 19968: jis0212<<14 | 0x49<<7 | 0x59,
	39919 - 19968: jis0212<<14 | 0x49<<7 | 0x5A,
	39920 - 19968: jis0208<<14 | 0x51<<7 | 0x2F,
	39921 - 19968: jis0208<<14 | 0x51<<7 | 0x2E,
	39922 - 19968: jis0208<<14 | 0x51<<7 | 0x2D,
	39923 - 19968: jis0212<<14 | 0x49<<7 | 0x5B,
	39925 - 19968: jis0208<<14 | 0x0F<<7 | 0x12,
	39927 - 19968: jis0212<<14 | 0x49<<7 | 0x5C,
	39928 - 19968: jis0212<<14 | 0x49<<7 | 0x5D,
	39929 - 19968: jis0212<<14 | 0x4A<<7 | 0x00,
	39930 - 19968: jis0212<<14 | 0x4A<<7 | 0x01,
	39933 - 19968: jis0212<<14 | 0x4A<<7 | 0x02,
	39935 - 19968: jis0212<<14 | 0x4A<<7 | 0x03,
	39936 - 19968: jis0208<<14 | 0x5B<<7 | 0x48,
	39938 - 19968: jis0212<<14 | 0x4A<<7 | 0x05,
	39940 - 19968: jis0208<<14 | 0x51<<7 | 0x39,
	39942 - 19968: jis0208<<14 | 0x51<<7 | 0x35,
	39944 - 19968: jis0208<<14 | 0x51<<7 | 0x36,
	39945 - 19968: jis0208<<14 | 0x51<<7 | 0x32,
	39946 - 19968: jis0208<<14 | 0x51<<7 | 0x38,
	39947 - 19968: jis0212<<14 | 0x4A<<7 | 0x06,
	39948 - 19968: jis0208<<14 | 0x51<<7 | 0x34,
	39949 - 19968: jis0208<<14 | 0x12<<7 | 0x41,
	39951 - 19968: jis0212<<14 | 0x4A<<7 | 0x07,
	39952 - 19968: jis0208<<14 | 0x2E<<7 | 0x2B,
	39953 - 19968: jis0212<<14 | 0x4A<<7 | 0x08,
	39954 - 19968: jis0208<<14 | 0x51<<7 | 0x37,
	39955 - 19968: jis0208<<14 | 0x51<<7 | 0x33,
	39956 - 19968: jis0208<<14 | 0x51<<7 | 0x31,
	39957 - 19968: jis0208<<14 | 0x51<<7 | 0x30,
	39958 - 19968: jis0212<<14 | 0x4A<<7 | 0x09,
	39960 - 19968: jis0212<<14 | 0x4A<<7 | 0x0A,
	39961 - 19968: jis0212<<14 | 0x4A<<7 | 0x0B,
	39962 - 19968: jis0212<<14 | 0x4A<<7 | 0x0C,
	39963 - 19968: jis0208<<14 | 0x51<<7 | 0x3B,
	39964 - 19968: jis0212<<14 | 0x4A<<7 | 0x0D,
	39966 - 19968: jis0212<<14 | 0x4A<<7 | 0x0E,
	39969 - 19968: jis0208<<14 | 0x51<<7 | 0x3E,
	39970 - 19968: jis0212<<14 | 0x4A<<7 | 0x0F,
	39971 - 19968: jis0212<<14 | 0x4A<<7 | 0x10,
	39972 - 19968: jis0208<<14 | 0x51<<7 | 0x3D,
	39973 - 19968: jis0208<<14 | 0x51<<7 | 0x3C,
	39974 - 19968: jis0212<<14 | 0x4A<<7 | 0x11,
	39975 - 19968: jis0212<<14 | 0x4A<<7 | 0x12,
	39976 - 19968: jis0212<<14 | 0x4A<<7 | 0x13,
	39977 - 19968: jis0212<<14 | 0x4A<<7 | 0x14,
	39978 - 19968: jis0212<<14 | 0x4A<<7 | 0x15,
	39981 - 19968: jis0208<<14 | 0x28<<7 | 0x28,
	39982 - 19968: jis0208<<14 | 0x51<<7 | 0x3A,
	39983 - 19968: jis0208<<14 | 0x0F<<7 | 0x52,
	39984 - 19968: jis0208<<14 | 0x51<<7 | 0x3F,
	39985 - 19968: jis0212<<14 | 0x4A<<7 | 0x16,
	39986 - 19968: jis0208<<14 | 0x51<<7 | 0x41,
	39989 - 19968: jis0212<<14 | 0x4A<<7 | 0x17,
	39990 - 19968: jis0212<<14 | 0x4A<<7 | 0x18,
	39991 - 19968: jis0212<<14 | 0x4A<<7 | 0x19,
	39993 - 19968: jis0208<<14 | 0x12<<7 | 0x4E,
	39994 - 19968: jis0208<<14 | 0x51<<7 | 0x2C,
	39995 - 19968: jis0208<<14 | 0x10<<7 | 0x16,
	39997 - 19968: jis0212<<14 | 0x4A<<7 | 0x1A,
	39998 - 19968: jis0208<<14 | 0x51<<7 | 0x43,
	40001 - 19968: jis0212<<14 | 0x4A<<7 | 0x1B,
	40003 - 19968: jis0212<<14 | 0x4A<<7 | 0x1C,
	40004 - 19968: jis0212<<14 | 0x4A<<7 | 0x1D,
	40005 - 19968: jis0212<<14 | 0x4A<<7 | 0x1E,
	40006 - 19968: jis0208<<14 | 0x51<<7 | 0x42,
	40007 - 19968: jis0208<<14 | 0x51<<7 | 0x40,
	40008 - 19968: jis0208<<14 | 0x22<<7 | 0x0C,
	40009 - 19968: jis0212<<14 | 0x4A<<7 | 0x1F,
	40010 - 19968: jis0212<<14 | 0x4A<<7 | 0x20,
	40014 - 19968: jis0212<<14 | 0x4A<<7 | 0x21,
	40015 - 19968: jis0212<<14 | 0x4A<<7 | 0x22,
	40016 - 19968: jis0212<<14 | 0x4A<<7 | 0x23,
	40018 - 19968: jis0208<<14 | 0x2A<<7 | 0x4F,
	40019 - 19968: jis0212<<14 | 0x4A<<7 | 0x24,
	40020 - 19968: jis0212<<14 | 0x4A<<7 | 0x25,
	40022 - 19968: jis0212<<14 | 0x4A<<7 | 0x26,
	40023 - 19968: jis0208<<14 | 0x2D<<7 | 0x39,
	40024 - 19968: jis0212<<14 | 0x4A<<7 | 0x27,
	40026 - 19968: jis0208<<14 | 0x51<<7 | 0x44,
	40027 - 19968: jis0212<<14 | 0x4A<<7 | 0x28,
	40028 - 19968: jis0212<<14 | 0x4A<<7 | 0x2F,
	40029 - 19968: jis0212<<14 | 0x4A<<7 | 0x29,
	40030 - 19968: jis0212<<14 | 0x4A<<7 | 0x2A,
	40031 - 19968: jis0212<<14 | 0x4A<<7 | 0x2B,
	40032 - 19968: jis0208<<14 | 0x51<<7 | 0x45,
	40035 - 19968: jis0212<<14 | 0x4A<<7 | 0x2C,
	40039 - 19968: jis0208<<14 | 0x51<<7 | 0x46,
	40040 - 19968: jis0212<<14 | 0x4A<<7 | 0x31,
	40041 - 19968: jis0212<<14 | 0x4A<<7 | 0x2D,
	40042 - 19968: jis0212<<14 | 0x4A<<7 | 0x2E,
	40043 - 19968: jis0212<<14 | 0x4A<<7 | 0x30,
	40046 - 19968: jis0212<<14 | 0x4A<<7 | 0x32,
	40048 - 19968: jis0212<<14 | 0x4A<<7 | 0x33,
	40050 - 19968: jis0212<<14 | 0x4A<<7 | 0x34,
	40053 - 19968: jis0212<<14 | 0x4A<<7 | 0x35,
	40054 - 19968: jis0208<<14 | 0x51<<7 | 0x47,
	40055 - 19968: jis0212<<14 | 0x4A<<7 | 0x36,
	40056 - 19968: jis0208<<14 | 0x51<<7 | 0x48,
	40059 - 19968: jis0212<<14 | 0x4A<<7 | 0x37,
	40165 - 19968: jis0208<<14 | 0x23<<7 | 0x1A,
	40166 - 19968: jis0212<<14 | 0x4A<<7 | 0x38,
	40167 - 19968: jis0208<<14 | 0x51<<7 | 0x49,
	40169 - 19968: jis0208<<14 | 0x27<<7 | 0x16,
	40171 - 19968: jis0208<<14 | 0x51<<7 | 0x4E,
	40172 - 19968: jis0208<<14 | 0x51<<7 | 0x4A,
	40176 - 19968: jis0208<<14 | 0x51<<7 | 0x4B,
	40178 - 19968: jis0212<<14 | 0x4A<<7 | 0x39,
	40179 - 19968: jis0208<<14 | 0x2A<<7 | 0x10,
	40180 - 19968: jis0208<<14 | 0x2B<<7 | 0x23,
	40182 - 19968: jis0208<<14 | 0x25<<7 | 0x2F,
	40183 - 19968: jis0212<<14 | 0x4A<<7 | 0x3A,
	40185 - 19968: jis0212<<14 | 0x4A<<7 | 0x3B,
	40194 - 19968: jis0212<<14 | 0x4A<<7 | 0x3D,
	40195 - 19968: jis0208<<14 | 0x51<<7 | 0x4F,
	40198 - 19968: jis0208<<14 | 0x51<<7 | 0x50,
	40199 - 19968: jis0208<<14 | 0x25<<7 | 0x1D,
	40200 - 19968: jis0208<<14 | 0x51<<7 | 0x4D,
	40201 - 19968: jis0208<<14 | 0x51<<7 | 0x4C,
	40203 - 19968: jis0212<<14 | 0x4A<<7 | 0x3C,
	40206 - 19968: jis0208<<14 | 0x11<<7 | 0x09,
	40209 - 19968: jis0212<<14 | 0x4A<<7 | 0x3E,
	40210 - 19968: jis0208<<14 | 0x51<<7 | 0x58,
	40213 - 19968: jis0208<<14 | 0x51<<7 | 0x57,
	40215 - 19968: jis0212<<14 | 0x4A<<7 | 0x3F,
	40216 - 19968: jis0212<<14 | 0x4A<<7 | 0x40,
	40219 - 19968: jis0208<<14 | 0x10<<7 | 0x54,
	40220 - 19968: jis0212<<14 | 0x4A<<7 | 0x41,
	40221 - 19968: jis0212<<14 | 0x4A<<7 | 0x42,
	40222 - 19968: jis0212<<14 | 0x4A<<7 | 0x43,
	40223 - 19968: jis0208<<14 | 0x51<<7 | 0x55,
	40227 - 19968: jis0208<<14 | 0x51<<7 | 0x54,
	40230 - 19968: jis0208<<14 | 0x51<<7 | 0x52,
	40232 - 19968: jis0208<<14 | 0x12<<7 | 0x5A,
	40234 - 19968: jis0208<<14 | 0x51<<7 | 0x51,
	40235 - 19968: jis0208<<14 | 0x1B<<7 | 0x11,
	40236 - 19968: jis0208<<14 | 0x11<<7 | 0x08,
	40239 - 19968: jis0212<<14 | 0x4A<<7 | 0x44,
	40240 - 19968: jis0212<<14 | 0x4A<<7 | 0x45,
	40242 - 19968: jis0212<<14 | 0x4A<<7 | 0x46,
	40243 - 19968: jis0212<<14 | 0x4A<<7 | 0x47,
	40244 - 19968: jis0212<<14 | 0x4A<<7 | 0x48,
	40250 - 19968: jis0212<<14 | 0x4A<<7 | 0x49,
	40251 - 19968: jis0208<<14 | 0x18<<7 | 0x42,
	40252 - 19968: jis0212<<14 | 0x4A<<7 | 0x4A,
	40253 - 19968: jis0212<<14 | 0x4A<<7 | 0x4C,
	40254 - 19968: jis0208<<14 | 0x51<<7 | 0x5B,
	40255 - 19968: jis0208<<14 | 0x51<<7 | 0x5A,
	40257 - 19968: jis0208<<14 | 0x51<<7 | 0x59,
	40258 - 19968: jis0212<<14 | 0x4A<<7 | 0x4D,
	40259 - 19968: jis0212<<14 | 0x4A<<7 | 0x4E,
	40260 - 19968: jis0208<<14 | 0x51<<7 | 0x56,
	40261 - 19968: jis0212<<14 | 0x4A<<7 | 0x4B,
	40262 - 19968: jis0208<<14 | 0x51<<7 | 0x5C,
	40263 - 19968: jis0212<<14 | 0x4A<<7 | 0x4F,
	40264 - 19968: jis0208<<14 | 0x51<<7 | 0x5D,
	40266 - 19968: jis0212<<14 | 0x4A<<7 | 0x50,
	40272 - 19968: jis0208<<14 | 0x52<<7 | 0x04,
	40273 - 19968: jis0208<<14 | 0x52<<7 | 0x03,
	40275 - 19968: jis0212<<14 | 0x4A<<7 | 0x51,
	40276 - 19968: jis0212<<14 | 0x4A<<7 | 0x52,
	40281 - 19968: jis0208<<14 | 0x52<<7 | 0x05,
	40284 - 19968: jis0208<<14 | 0x10<<7 | 0x0C,
	40285 - 19968: jis0208<<14 | 0x52<<7 | 0x00,
	40286 - 19968: jis0208<<14 | 0x52<<7 | 0x01,
	40287 - 19968: jis0212<<14 | 0x4A<<7 | 0x53,
	40288 - 19968: jis0208<<14 | 0x18<<7 | 0x53,
	40289 - 19968: jis0208<<14 | 0x2B<<7 | 0x18,
	40290 - 19968: jis0212<<14 | 0x4A<<7 | 0x55,
	40291 - 19968: jis0212<<14 | 0x4A<<7 | 0x54,
	40292 - 19968: jis0208<<14 | 0x52<<7 | 0x02,
	40293 - 19968: jis0212<<14 | 0x4A<<7 | 0x56,
	40297 - 19968: jis0212<<14 | 0x4A<<7 | 0x57,
	40298 - 19968: jis0212<<14 | 0x4A<<7 | 0x58,
	40299 - 19968: jis0208<<14 | 0x5B<<7 | 0x4A,
	40300 - 19968: jis0208<<14 | 0x2A<<7 | 0x11,
	40303 - 19968: jis0208<<14 | 0x52<<7 | 0x0A,
	40304 - 19968: jis0208<<14 | 0x5B<<7 | 0x49,
	40306 - 19968: jis0208<<14 | 0x52<<7 | 0x06,
	40310 - 19968: jis0212<<14 | 0x4A<<7 | 0x5B,
	40311 - 19968: jis0212<<14 | 0x4A<<7 | 0x5C,
	40314 - 19968: jis0208<<14 | 0x52<<7 | 0x0B,
	40315 - 19968: jis0212<<14 | 0x4A<<7 | 0x5D,
	40316 - 19968: jis0212<<14 | 0x4B<<7 | 0x00,
	40318 - 19968: jis0212<<14 | 0x4B<<7 | 0x01,
	40323 - 19968: jis0212<<14 | 0x4B<<7 | 0x02,
	40324 - 19968: jis0212<<14 | 0x4B<<7 | 0x03,
	40326 - 19968: jis0212<<14 | 0x4B<<7 | 0x04,
	40327 - 19968: jis0208<<14 | 0x52<<7 | 0x08,
	40329 - 19968: jis0208<<14 | 0x52<<7 | 0x07,
	40330 - 19968: jis0212<<14 | 0x4B<<7 | 0x05,
	40333 - 19968: jis0212<<14 | 0x4B<<7 | 0x06,
	40334 - 19968: jis0212<<14 | 0x4B<<7 | 0x07,
	40335 - 19968: jis0208<<14 | 0x16<<7 | 0x3B,
	40338 - 19968: jis0212<<14 | 0x4B<<7 | 0x08,
	40339 - 19968: jis0212<<14 | 0x4B<<7 | 0x09,
	40341 - 19968: jis0212<<14 | 0x4B<<7 | 0x0A,
	40342 - 19968: jis0212<<14 | 0x4B<<7 | 0x0B,
	40343 - 19968: jis0212<<14 | 0x4B<<7 | 0x0C,
	40344 - 19968: jis0212<<14 | 0x4B<<7 | 0x0D,
	40346 - 19968: jis0208<<14 | 0x52<<7 | 0x0C,
	40353 - 19968: jis0212<<14 | 0x4B<<7 | 0x0E,
	40356 - 19968: jis0208<<14 | 0x52<<7 | 0x0D,
	40361 - 19968: jis0208<<14 | 0x52<<7 | 0x0E,
	40362 - 19968: jis0212<<14 | 0x4B<<7 | 0x0F,
	40363 - 19968: jis0208<<14 | 0x52<<7 | 0x09,
	40364 - 19968: jis0212<<14 | 0x4B<<7 | 0x10,
	40366 - 19968: jis0212<<14 | 0x4B<<7 | 0x11,
	40367 - 19968: jis0208<<14 | 0x51<<7 | 0x53,
	40369 - 19968: jis0212<<14 | 0x4B<<7 | 0x12,
	40370 - 19968: jis0208<<14 | 0x52<<7 | 0x0F,
	40372 - 19968: jis0208<<14 | 0x23<<7 | 0x40,
	40373 - 19968: jis0212<<14 | 0x4B<<7 | 0x13,
	40376 - 19968: jis0208<<14 | 0x52<<7 | 0x13,
	40377 - 19968: jis0212<<14 | 0x4B<<7 | 0x14,
	40378 - 19968: jis0208<<14 | 0x52<<7 | 0x14,
	40379 - 19968: jis0208<<14 | 0x52<<7 | 0x12,
	40380 - 19968: jis0212<<14 | 0x4B<<7 | 0x15,
	40383 - 19968: jis0212<<14 | 0x4B<<7 | 0x16,
	40385 - 19968: jis0208<<14 | 0x52<<7 | 0x11,
	40386 - 19968: jis0208<<14 | 0x52<<7 | 0x17,
	40387 - 19968: jis0212<<14 | 0x4B<<7 | 0x17,
	40388 - 19968: jis0208<<14 | 0x52<<7 | 0x10,
	40390 - 19968: jis0208<<14 | 0x52<<7 | 0x15,
	40391 - 19968: jis0212<<14 | 0x4B<<7 | 0x18,
	40393 - 19968: jis0212<<14 | 0x4B<<7 | 0x19,
	40394 - 19968: jis0212<<14 | 0x4B<<7 | 0x1A,
	40399 - 19968: jis0208<<14 | 0x52<<7 | 0x16,
	40403 - 19968: jis0208<<14 | 0x52<<7 | 0x19,
	40404 - 19968: jis0212<<14 | 0x4B<<7 | 0x1B,
	40405 - 19968: jis0212<<14 | 0x4B<<7 | 0x1C,
	40406 - 19968: jis0212<<14 | 0x4B<<7 | 0x1D,
	40407 - 19968: jis0212<<14 | 0x4B<<7 | 0x1E,
	40409 - 19968: jis0208<<14 | 0x52<<7 | 0x18,
	40410 - 19968: jis0212<<14 | 0x4B<<7 | 0x1F,
	40414 - 19968: jis0212<<14 | 0x4B<<7 | 0x20,
	40415 - 19968: jis0212<<14 | 0x4B<<7 | 0x21,
	40416 - 19968: jis0212<<14 | 0x4B<<7 | 0x22,
	40421 - 19968: jis0212<<14 | 0x4B<<7 | 0x23,
	40422 - 19968: jis0208<<14 | 0x52<<7 | 0x1B,
	40423 - 19968: jis0212<<14 | 0x4B<<7 | 0x24,
	40425 - 19968: jis0212<<14 | 0x4B<<7 | 0x25,
	40427 - 19968: jis0212<<14 | 0x4B<<7 | 0x26,
	40429 - 19968: jis0208<<14 | 0x52<<7 | 0x1C,
	40430 - 19968: jis0212<<14 | 0x4B<<7 | 0x27,
	40431 - 19968: jis0208<<14 | 0x52<<7 | 0x1D,
	40432 - 19968: jis0212<<14 | 0x4B<<7 | 0x28,
	40434 - 19968: jis0208<<14 | 0x2E<<7 | 0x28,
	40435 - 19968: jis0212<<14 | 0x4B<<7 | 0x29,
	40436 - 19968: jis0212<<14 | 0x4B<<7 | 0x2A,
	40440 - 19968: jis0208<<14 | 0x52<<7 | 0x1A,
	40441 - 19968: jis0208<<14 | 0x21<<7 | 0x4A,
	40442 - 19968: jis0208<<14 | 0x19<<7 | 0x4C,
	40445 - 19968: jis0208<<14 | 0x52<<7 | 0x1E,
	40446 - 19968: jis0212<<14 | 0x4B<<7 | 0x2B,
	40450 - 19968: jis0212<<14 | 0x4B<<7 | 0x2D,
	40455 - 19968: jis0212<<14 | 0x4B<<7 | 0x2E,
	40458 - 19968: jis0212<<14 | 0x4B<<7 | 0x2C,
	40462 - 19968: jis0212<<14 | 0x4B<<7 | 0x2F,
	40464 - 19968: jis0212<<14 | 0x4B<<7 | 0x30,
	40465 - 19968: jis0212<<14 | 0x4B<<7 | 0x31,
	40466 - 19968: jis0212<<14 | 0x4B<<7 | 0x32,
	40469 - 19968: jis0212<<14 | 0x4B<<7 | 0x33,
	40470 - 19968: jis0212<<14 | 0x4B<<7 | 0x34,
	40473 - 19968: jis0208<<14 | 0x5B<<7 | 0x4C,
	40474 - 19968: jis0208<<14 | 0x52<<7 | 0x1F,
	40475 - 19968: jis0208<<14 | 0x52<<7 | 0x20,
	40476 - 19968: jis0212<<14 | 0x4B<<7 | 0x36,
	40477 - 19968: jis0212<<14 | 0x4B<<7 | 0x37,
	40478 - 19968: jis0208<<14 | 0x52<<7 | 0x21,
	40565 - 19968: jis0208<<14 | 0x52<<7 | 0x22,
	40568 - 19968: jis0208<<14 | 0x17<<7 | 0x13,
	40569 - 19968: jis0208<<14 | 0x52<<7 | 0x23,
	40570 - 19968: jis0212<<14 | 0x4B<<7 | 0x38,
	40571 - 19968: jis0212<<14 | 0x4B<<7 | 0x39,
	40572 - 19968: jis0212<<14 | 0x4B<<7 | 0x3A,
	40573 - 19968: jis0208<<14 | 0x52<<7 | 0x24,
	40575 - 19968: jis0208<<14 | 0x1B<<7 | 0x0E,
	40576 - 19968: jis0212<<14 | 0x4B<<7 | 0x3B,
	40577 - 19968: jis0208<<14 | 0x52<<7 | 0x25,
	40578 - 19968: jis0212<<14 | 0x4B<<7 | 0x3C,
	40579 - 19968: jis0212<<14 | 0x4B<<7 | 0x3D,
	40580 - 19968: jis0212<<14 | 0x4B<<7 | 0x3E,
	40581 - 19968: jis0212<<14 | 0x4B<<7 | 0x3F,
	40583 - 19968: jis0212<<14 | 0x4B<<7 | 0x40,
	40584 - 19968: jis0208<<14 | 0x52<<7 | 0x26,
	40587 - 19968: jis0208<<14 | 0x52<<7 | 0x27,
	40588 - 19968: jis0208<<14 | 0x52<<7 | 0x28,
	40590 - 19968: jis0212<<14 | 0x4B<<7 | 0x41,
	40591 - 19968: jis0212<<14 | 0x4B<<7 | 0x42,
	40593 - 19968: jis0208<<14 | 0x52<<7 | 0x2B,
	40594 - 19968: jis0208<<14 | 0x52<<7 | 0x29,
	40595 - 19968: jis0208<<14 | 0x2E<<7 | 0x1B,
	40597 - 19968: jis0208<<14 | 0x52<<7 | 0x2A,
	40598 - 19968: jis0212<<14 | 0x4B<<7 | 0x43,
	40599 - 19968: jis0208<<14 | 0x2D<<7 | 0x4E,
	40600 - 19968: jis0212<<14 | 0x4B<<7 | 0x44,
	40603 - 19968: jis0212<<14 | 0x4B<<7 | 0x45,
	40605 - 19968: jis0208<<14 | 0x52<<7 | 0x2C,
	40606 - 19968: jis0212<<14 | 0x4B<<7 | 0x46,
	40607 - 19968: jis0208<<14 | 0x2D<<7 | 0x3A,
	40612 - 19968: jis0212<<14 | 0x4B<<7 | 0x47,
	40613 - 19968: jis0208<<14 | 0x52<<7 | 0x2D,
	40614 - 19968: jis0208<<14 | 0x26<<7 | 0x5D,
	40616 - 19968: jis0212<<14 | 0x4B<<7 | 0x48,
	40617 - 19968: jis0208<<14 | 0x52<<7 | 0x2E,
	40618 - 19968: jis0208<<14 | 0x52<<7 | 0x30,
	40620 - 19968: jis0212<<14 | 0x4B<<7 | 0x49,
	40621 - 19968: jis0208<<14 | 0x52<<7 | 0x31,
	40622 - 19968: jis0212<<14 | 0x4B<<7 | 0x4A,
	40623 - 19968: jis0212<<14 | 0x4B<<7 | 0x4B,
	40624 - 19968: jis0212<<14 | 0x4B<<7 | 0x4C,
	40627 - 19968: jis0212<<14 | 0x4B<<7 | 0x4D,
	40628 - 19968: jis0212<<14 | 0x4B<<7 | 0x4E,
	40629 - 19968: jis0212<<14 | 0x4B<<7 | 0x4F,
	40632 - 19968: jis0208<<14 | 0x52<<7 | 0x2F,
	40633 - 19968: jis0208<<14 | 0x18<<7 | 0x4C,
	40634 - 19968: jis0208<<14 | 0x2B<<7 | 0x2C,
	40635 - 19968: jis0208<<14 | 0x2A<<7 | 0x42,
	40636 - 19968: jis0208<<14 | 0x35<<7 | 0x56,
	40638 - 19968: jis0208<<14 | 0x3C<<7 | 0x3F,
	40639 - 19968: jis0208<<14 | 0x2A<<7 | 0x5A,
	40644 - 19968: jis0208<<14 | 0x11<<7 | 0x0A,
	40646 - 19968: jis0212<<14 | 0x4B<<7 | 0x50,
	40648 - 19968: jis0212<<14 | 0x4B<<7 | 0x51,
	40651 - 19968: jis0212<<14 | 0x4B<<7 | 0x52,
	40652 - 19968: jis0208<<14 | 0x52<<7 | 0x33,
	40653 - 19968: jis0208<<14 | 0x14<<7 | 0x2F,
	40654 - 19968: jis0208<<14 | 0x52<<7 | 0x34,
	40655 - 19968: jis0208<<14 | 0x52<<7 | 0x35,
	40656 - 19968: jis0208<<14 | 0x52<<7 | 0x36,
	40657 - 19968: jis0208<<14 | 0x5B<<7 | 0x4D,
	40658 - 19968: jis0208<<14 | 0x18<<7 | 0x54,
	40660 - 19968: jis0208<<14 | 0x52<<7 | 0x37,
	40661 - 19968: jis0212<<14 | 0x4B<<7 | 0x53,
	40664 - 19968: jis0208<<14 | 0x3F<<7 | 0x33,
	40665 - 19968: jis0208<<14 | 0x2B<<7 | 0x3A,
	40667 - 19968: jis0208<<14 | 0x21<<7 | 0x42,
	40668 - 19968: jis0208<<14 | 0x52<<7 | 0x38,
	40669 - 19968: jis0208<<14 | 0x52<<7 | 0x3A,
	40670 - 19968: jis0208<<14 | 0x52<<7 | 0x39,
	40671 - 19968: jis0212<<14 | 0x4B<<7 | 0x54,
	40672 - 19968: jis0208<<14 | 0x52<<7 | 0x3B,
	40676 - 19968: jis0212<<14 | 0x4B<<7 | 0x55,
	40677 - 19968: jis0208<<14 | 0x52<<7 | 0x3C,
	40679 - 19968: jis0212<<14 | 0x4B<<7 | 0x56,
	40680 - 19968: jis0208<<14 | 0x52<<7 | 0x3D,
	40684 - 19968: jis0212<<14 | 0x4B<<7 | 0x57,
	40685 - 19968: jis0212<<14 | 0x4B<<7 | 0x58,
	40686 - 19968: jis0212<<14 | 0x4B<<7 | 0x59,
	40687 - 19968: jis0208<<14 | 0x52<<7 | 0x3E,
	40688 - 19968: jis0212<<14 | 0x4B<<7 | 0x5A,
	40689 - 19968: jis0212<<14 | 0x4B<<7 | 0x5B,
	40690 - 19968: jis0212<<14 | 0x4B<<7 | 0x5C,
	40692 - 19968: jis0208<<14 | 0x52<<7 | 0x3F,
	40693 - 19968: jis0212<<14 | 0x4B<<7 | 0x5D,
	40694 - 19968: jis0208<<14 | 0x52<<7 | 0x40,
	40695 - 19968: jis0208<<14 | 0x52<<7 | 0x41,
	40696 - 19968: jis0212<<14 | 0x4C<<7 | 0x00,
	40697 - 19968: jis0208<<14 | 0x52<<7 | 0x42,
	40699 - 19968: jis0208<<14 | 0x52<<7 | 0x43,
	40700 - 19968: jis0208<<14 | 0x52<<7 | 0x44,
	40701 - 19968: jis0208<<14 | 0x52<<7 | 0x45,
	40703 - 19968: jis0212<<14 | 0x4C<<7 | 0x01,
	40706 - 19968: jis0212<<14 | 0x4C<<7 | 0x02,
	40707 - 19968: jis0212<<14 | 0x4C<<7 | 0x03,
	40711 - 19968: jis0208<<14 | 0x52<<7 | 0x46,
	40712 - 19968: jis0208<<14 | 0x52<<7 | 0x47,
	40713 - 19968: jis0212<<14 | 0x4C<<7 | 0x04,
	40718 - 19968: jis0208<<14 | 0x24<<7 | 0x03,
	40719 - 19968: jis0212<<14 | 0x4C<<7 | 0x05,
	40720 - 19968: jis0212<<14 | 0x4C<<7 | 0x06,
	40721 - 19968: jis0212<<14 | 0x4C<<7 | 0x07,
	40722 - 19968: jis0212<<14 | 0x4C<<7 | 0x08,
	40723 - 19968: jis0208<<14 | 0x17<<7 | 0x3C,
	40724 - 19968: jis0212<<14 | 0x4C<<7 | 0x09,
	40725 - 19968: jis0208<<14 | 0x52<<7 | 0x49,
	40726 - 19968: jis0212<<14 | 0x4C<<7 | 0x0A,
	40727 - 19968: jis0212<<14 | 0x4C<<7 | 0x0B,
	40729 - 19968: jis0212<<14 | 0x4C<<7 | 0x0C,
	40730 - 19968: jis0212<<14 | 0x4C<<7 | 0x0D,
	40731 - 19968: jis0212<<14 | 0x4C<<7 | 0x0E,
	40735 - 19968: jis0212<<14 | 0x4C<<7 | 0x0F,
	40736 - 19968: jis0208<<14 | 0x20<<7 | 0x2C,
	40737 - 19968: jis0208<<14 | 0x52<<7 | 0x4A,
	40738 - 19968: jis0212<<14 | 0x4C<<7 | 0x10,
	40742 - 19968: jis0212<<14 | 0x4C<<7 | 0x11,
	40746 - 19968: jis0212<<14 | 0x4C<<7 | 0x12,
	40747 - 19968: jis0212<<14 | 0x4C<<7 | 0x13,
	40748 - 19968: jis0208<<14 | 0x52<<7 | 0x4B,
	40751 - 19968: jis0212<<14 | 0x4C<<7 | 0x14,
	40753 - 19968: jis0212<<14 | 0x4C<<7 | 0x15,
	40754 - 19968: jis0212<<14 | 0x4C<<7 | 0x16,
	40756 - 19968: jis0212<<14 | 0x4C<<7 | 0x17,
	40759 - 19968: jis0212<<14 | 0x4C<<7 | 0x18,
	40761 - 19968: jis0212<<14 | 0x4C<<7 | 0x19,
	40762 - 19968: jis0212<<14 | 0x4C<<7 | 0x1A,
	40763 - 19968: jis0208<<14 | 0x28<<7 | 0x00,
	40764 - 19968: jis0212<<14 | 0x4C<<7 | 0x1B,
	40765 - 19968: jis0212<<14 | 0x4C<<7 | 0x1C,
	40766 - 19968: jis0208<<14 | 0x52<<7 | 0x4C,
	40767 - 19968: jis0212<<14 | 0x4C<<7 | 0x1D,
	40769 - 19968: jis0212<<14 | 0x4C<<7 | 0x1E,
	40771 - 19968: jis0212<<14 | 0x4C<<7 | 0x1F,
	40772 - 19968: jis0212<<14 | 0x4C<<7 | 0x20,
	40773 - 19968: jis0212<<14 | 0x4C<<7 | 0x21,
	40774 - 19968: jis0212<<14 | 0x4C<<7 | 0x22,
	40775 - 19968: jis0212<<14 | 0x4C<<7 | 0x23,
	40778 - 19968: jis0208<<14 | 0x52<<7 | 0x4D,
	40779 - 19968: jis0208<<14 | 0x42<<7 | 0x16,
	40782 - 19968: jis0208<<14 | 0x4B<<7 | 0x39,
	40783 - 19968: jis0208<<14 | 0x4F<<7 | 0x4C,
	40786 - 19968: jis0208<<14 | 0x52<<7 | 0x4E,
	40787 - 19968: jis0212<<14 | 0x4C<<7 | 0x24,
	40788 - 19968: jis0208<<14 | 0x52<<7 | 0x4F,
	40789 - 19968: jis0212<<14 | 0x4C<<7 | 0x25,
	40790 - 19968: jis0212<<14 | 0x4C<<7 | 0x26,
	40791 - 19968: jis0212<<14 | 0x4C<<7 | 0x27,
	40792 - 19968: jis0212<<14 | 0x4C<<7 | 0x28,
	40794 - 19968: jis0212<<14 | 0x4C<<7 | 0x29,
	40797 - 19968: jis0212<<14 | 0x4C<<7 | 0x2A,
	40798 - 19968: jis0212<<14 | 0x4C<<7 | 0x2B,
	40799 - 19968: jis0208<<14 | 0x52<<7 | 0x51,
	40800 - 19968: jis0208<<14 | 0x52<<7 | 0x52,
	40801 - 19968: jis0208<<14 | 0x52<<7 | 0x53,
	40802 - 19968: jis0208<<14 | 0x2D<<7 | 0x4F,
	40803 - 19968: jis0208<<14 | 0x52<<7 | 0x50,
	40806 - 19968: jis0208<<14 | 0x52<<7 | 0x54,
	40807 - 19968: jis0208<<14 | 0x52<<7 | 0x55,
	40808 - 19968: jis0212<<14 | 0x4C<<7 | 0x2C,
	40809 - 19968: jis0212<<14 | 0x4C<<7 | 0x2D,
	40810 - 19968: jis0208<<14 | 0x52<<7 | 0x57,
	40812 - 19968: jis0208<<14 | 0x52<<7 | 0x56,
	40813 - 19968: jis0212<<14 | 0x4C<<7 | 0x2E,
	40814 - 19968: jis0212<<14 | 0x4C<<7 | 0x2F,
	40815 - 19968: jis0212<<14 | 0x4C<<7 | 0x30,
	40816 - 19968: jis0212<<14 | 0x4C<<7 | 0x31,
	40817 - 19968: jis0212<<14 | 0x4C<<7 | 0x32,
	40818 - 19968: jis0208<<14 | 0x52<<7 | 0x59,
	40819 - 19968: jis0212<<14 | 0x4C<<7 | 0x33,
	40821 - 19968: jis0212<<14 | 0x4C<<7 | 0x34,
	40822 - 19968: jis0208<<14 | 0x52<<7 | 0x5A,
	40823 - 19968: jis0208<<14 | 0x52<<7 | 0x58,
	40826 - 19968: jis0212<<14 | 0x4C<<7 | 0x35,
	40829 - 19968: jis0212<<14 | 0x4C<<7 | 0x36,
	40845 - 19968: jis0208<<14 | 0x2D<<7 | 0x15,
	40847 - 19968: jis0212<<14 | 0x4C<<7 | 0x37,
	40848 - 19968: jis0212<<14 | 0x4C<<7 | 0x38,
	40849 - 19968: jis0212<<14 | 0x4C<<7 | 0x39,
	40850 - 19968: jis0212<<14 | 0x4C<<7 | 0x3A,
	40852 - 19968: jis0212<<14 | 0x4C<<7 | 0x3B,
	40853 - 19968: jis0208<<14 | 0x52<<7 | 0x5B,
	40854 - 19968: jis0212<<14 | 0x4C<<7 | 0x3C,
	40855 - 19968: jis0212<<14 | 0x4C<<7 | 0x3D,
	40860 - 19968: jis0208<<14 | 0x52<<7 | 0x5C,
	40861 - 19968: jis0208<<14 | 0x42<<7 | 0x33,
	40862 - 19968: jis0212<<14 | 0x4C<<7 | 0x3E,
	40864 - 19968: jis0208<<14 | 0x52<<7 | 0x5D,
	40865 - 19968: jis0212<<14 | 0x4C<<7 | 0x3F,
	40866 - 19968: jis0212<<14 | 0x4C<<7 | 0x40,
	40867 - 19968: jis0212<<14 | 0x4C<<7 | 0x41,
	40869 - 19968: jis0212<<14 | 0x4C<<7 | 0x42,
}

const encode1Low, encode1High = 8208, 9840

var encode1 = [...]uint16{
	8208 - 8208: jis0208<<14 | 0x00<<7 | 0x1D,
	8213 - 8208: jis0208<<14 | 0x00<<7 | 0x1C,
	8216 - 8208: jis0208<<14 | 0x00<<7 | 0x25,
	8217 - 8208: jis0208<<14 | 0x00<<7 | 0x26,
	8220 - 8208: jis0208<<14 | 0x00<<7 | 0x27,
	8221 - 8208: jis0208<<14 | 0x00<<7 | 0x28,
	8224 - 8208: jis0208<<14 | 0x01<<7 | 0x56,
	8225 - 8208: jis0208<<14 | 0x01<<7 | 0x57,
	8229 - 8208: jis0208<<14 | 0x00<<7 | 0x24,
	8230 - 8208: jis0208<<14 | 0x00<<7 | 0x23,
	8240 - 8208: jis0208<<14 | 0x01<<7 | 0x52,
	8242 - 8208: jis0208<<14 | 0x00<<7 | 0x4B,
	8243 - 8208: jis0208<<14 | 0x00<<7 | 0x4C,
	8251 - 8208: jis0208<<14 | 0x01<<7 | 0x07,
	8451 - 8208: jis0208<<14 | 0x00<<7 | 0x4D,
	8470 - 8208: jis0208<<14 | 0x0C<<7 | 0x41,
	8481 - 8208: jis0208<<14 | 0x0C<<7 | 0x43,
	8482 - 8208: jis0212<<14 | 0x01<<7 | 0x4E,
	8491 - 8208: jis0208<<14 | 0x01<<7 | 0x51,
	8544 - 8208: jis0208<<14 | 0x0C<<7 | 0x14,
	8545 - 8208: jis0208<<14 | 0x0C<<7 | 0x15,
	8546 - 8208: jis0208<<14 | 0x0C<<7 | 0x16,
	8547 - 8208: jis0208<<14 | 0x0C<<7 | 0x17,
	8548 - 8208: jis0208<<14 | 0x0C<<7 | 0x18,
	8549 - 8208: jis0208<<14 | 0x0C<<7 | 0x19,
	8550 - 8208: jis0208<<14 | 0x0C<<7 | 0x1A,
	8551 - 8208: jis0208<<14 | 0x0C<<7 | 0x1B,
	8552 - 8208: jis0208<<14 | 0x0C<<7 | 0x1C,
	8553 - 8208: jis0208<<14 | 0x0C<<7 | 0x1D,
	8560 - 8208: jis0208<<14 | 0x5B<<7 | 0x50,
	8561 - 8208: jis0208<<14 | 0x5B<<7 | 0x51,
	8562 - 8208: jis0208<<14 | 0x5B<<7 | 0x52,
	8563 - 8208: jis0208<<14 | 0x5B<<7 | 0x53,
	8564 - 8208: jis0208<<14 | 0x5B<<7 | 0x54,
	8565 - 8208: jis0208<<14 | 0x5B<<7 | 0x55,
	8566 - 8208: jis0208<<14 | 0x5B<<7 | 0x56,
	8567 - 8208: jis0208<<14 | 0x5B<<7 | 0x57,
	8568 - 8208: jis0208<<14 | 0x5B<<7 | 0x58,
	8569 - 8208: jis0208<<14 | 0x5B<<7 | 0x59,
	8592 - 8208: jis0208<<14 | 0x01<<7 | 0x0A,
	8593 - 8208: jis0208<<14 | 0x01<<7 | 0x0B,
	8594 - 8208: jis0208<<14 | 0x01<<7 | 0x09,
	8595 - 8208: jis0208<<14 | 0x01<<7 | 0x0C,
	8658 - 8208: jis0208<<14 | 0x01<<7 | 0x2C,
	8660 - 8208: jis0208<<14 | 0x01<<7 | 0x2D,
	8704 - 8208: jis0208<<14 | 0x01<<7 | 0x2E,
	8706 - 8208: jis0208<<14 | 0x01<<7 | 0x3E,
	8707 - 8208: jis0208<<14 | 0x01<<7 | 0x2F,
	8711 - 8208: jis0208<<14 | 0x01<<7 | 0x3F,
	8712 - 8208: jis0208<<14 | 0x01<<7 | 0x19,
	8715 - 8208: jis0208<<14 | 0x01<<7 | 0x1A,
	8721 - 8208: jis0208<<14 | 0x0C<<7 | 0x53,
	8730 - 8208: jis0208<<14 | 0x01<<7 | 0x44,
	8733 - 8208: jis0208<<14 | 0x01<<7 | 0x46,
	8734 - 8208: jis0208<<14 | 0x00<<7 | 0x46,
	8735 - 8208: jis0208<<14 | 0x0C<<7 | 0x57,
	8736 - 8208: jis0208<<14 | 0x01<<7 | 0x3B,
	8741 - 8208: jis0208<<14 | 0x00<<7 | 0x21,
	8743 - 8208: jis0208<<14 | 0x01<<7 | 0x29,
	8744 - 8208: jis0208<<14 | 0x01<<7 | 0x2A,
	8745 - 8208: jis0208<<14 | 0x01<<7 | 0x20,
	8746 - 8208: jis0208<<14 | 0x01<<7 | 0x1F,
	8747 - 8208: jis0208<<14 | 0x01<<7 | 0x48,
	8748 - 8208: jis0208<<14 | 0x01<<7 | 0x49,
	8750 - 8208: jis0208<<14 | 0x0C<<7 | 0x52,
	8756 - 8208: jis0208<<14 | 0x00<<7 | 0x47,
	8757 - 8208: jis0208<<14 | 0x01<<7 | 0x47,
	8765 - 8208: jis0208<<14 | 0x01<<7 | 0x45,
	8786 - 8208: jis0208<<14 | 0x01<<7 | 0x41,
	8800 - 8208: jis0208<<14 | 0x00<<7 | 0x41,
	8801 - 8208: jis0208<<14 | 0x01<<7 | 0x40,
	8806 - 8208: jis0208<<14 | 0x00<<7 | 0x44,
	8807 - 8208: jis0208<<14 | 0x00<<7 | 0x45,
	8810 - 8208: jis0208<<14 | 0x01<<7 | 0x42,
	8811 - 8208: jis0208<<14 | 0x01<<7 | 0x43,
	8834 - 8208: jis0208<<14 | 0x01<<7 | 0x1D,
	8835 - 8208: jis0208<<14 | 0x01<<7 | 0x1E,
	8838 - 8208: jis0208<<14 | 0x01<<7 | 0x1B,
	8839 - 8208: jis0208<<14 | 0x01<<7 | 0x1C,
	8869 - 8208: jis0208<<14 | 0x01<<7 | 0x3C,
	8895 - 8208: jis0208<<14 | 0x0C<<7 | 0x58,
	8978 - 8208: jis0208<<14 | 0x01<<7 | 0x3D,
	9312 - 8208: jis0208<<14 | 0x0C<<7 | 0x00,
	9313 - 8208: jis0208<<14 | 0x0C<<7 | 0x01,
	9314 - 8208: jis0208<<14 | 0x0C<<7 | 0x02,
	9315 - 8208: jis0208<<14 | 0x0C<<7 | 0x03,
	9316 - 8208: jis0208<<14 | 0x0C<<7 | 0x04,
	9317 - 8208: jis0208<<14 | 0x0C<<7 | 0x05,
	9318 - 8208: jis0208<<14 | 0x0C<<7 | 0x06,
	9319 - 8208: jis0208<<14 | 0x0C<<7 | 0x07,
	9320 - 8208: jis0208<<14 | 0x0C<<7 | 0x08,
	9321 - 8208: jis0208<<14 | 0x0C<<7 | 0x09,
	9322 - 8208: jis0208<<14 | 0x0C<<7 | 0x0A,
	9323 - 8208: jis0208<<14 | 0x0C<<7 | 0x0B,
	9324 - 8208: jis0208<<14 | 0x0C<<7 | 0x0C,
	9325 - 8208: jis0208<<14 | 0x0C<<7 | 0x0D,
	9326 - 8208: jis0208<<14 | 0x0C<<7 | 0x0E,
	9327 - 8208: jis0208<<14 | 0x0C<<7 | 0x0F,
	9328 - 8208: jis0208<<14 | 0x0C<<7 | 0x10,
	9329 - 8208: jis0208<<14 | 0x0C<<7 | 0x11,
	9330 - 8208: jis0208<<14 | 0x0C<<7 | 0x12,
	9331 - 8208: jis0208<<14 | 0x0C<<7 | 0x13,
	9472 - 8208: jis0208<<14 | 0x07<<7 | 0x00,
	9473 - 8208: jis0208<<14 | 0x07<<7 | 0x0B,
	9474 - 8208: jis0208<<14 | 0x07<<7 | 0x01,
	9475 - 8208: jis0208<<14 | 0x07<<7 | 0x0C,
	9484 - 8208: jis0208<<14 | 0x07<<7 | 0x02,
	9487 - 8208: jis0208<<14 | 0x07<<7 | 0x0D,
	9488 - 8208: jis0208<<14 | 0x07<<7 | 0x03,
	9491 - 8208: jis0208<<14 | 0x07<<7 | 0x0E,
	9492 - 8208: jis0208<<14 | 0x07<<7 | 0x05,
	9495 - 8208: jis0208<<14 | 0x07<<7 | 0x10,
	9496 - 8208: jis0208<<14 | 0x07<<7 | 0x04,
	9499 - 8208: jis0208<<14 | 0x07<<7 | 0x0F,
	9500 - 8208: jis0208<<14 | 0x07<<7 | 0x06,
	9501 - 8208: jis0208<<14 | 0x07<<7 | 0x1B,
	9504 - 8208: jis0208<<14 | 0x07<<7 | 0x16,
	9507 - 8208: jis0208<<14 | 0x07<<7 | 0x11,
	9508 - 8208: jis0208<<14 | 0x07<<7 | 0x08,
	9509 - 8208: jis0208<<14 | 0x07<<7 | 0x1D,
	9512 - 8208: jis0208<<14 | 0x07<<7 | 0x18,
	9515 - 8208: jis0208<<14 | 0x07<<7 | 0x13,
	9516 - 8208: jis0208<<14 | 0x07<<7 | 0x07,
	9519 - 8208: jis0208<<14 | 0x07<<7 | 0x17,
	9520 - 8208: jis0208<<14 | 0x07<<7 | 0x1C,
	9523 - 8208: jis0208<<14 | 0x07<<7 | 0x12,
	9524 - 8208: jis0208<<14 | 0x07<<7 | 0x09,
	9527 - 8208: jis0208<<14 | 0x07<<7 | 0x19,
	9528 - 8208: jis0208<<14 | 0x07<<7 | 0x1E,
	9531 - 8208: jis0208<<14 | 0x07<<7 | 0x14,
	9532 - 8208: jis0208<<14 | 0x07<<7 | 0x0A,
	9535 - 8208: jis0208<<14 | 0x07<<7 | 0x1A,
	9538 - 8208: jis0208<<14 | 0x07<<7 | 0x1F,
	9547 - 8208: jis0208<<14 | 0x07<<7 | 0x15,
	9632 - 8208: jis0208<<14 | 0x01<<7 | 0x02,
	9633 - 8208: jis0208<<14 | 0x01<<7 | 0x01,
	9650 - 8208: jis0208<<14 | 0x01<<7 | 0x04,
	9651 - 8208: jis0208<<14 | 0x01<<7 | 0x03,
	9660 - 8208: jis0208<<14 | 0x01<<7 | 0x06,
	9661 - 8208: jis0208<<14 | 0x01<<7 | 0x05,
	9670 - 8208: jis0208<<14 | 0x01<<7 | 0x00,
	9671 - 8208: jis0208<<14 | 0x00<<7 | 0x5D,
	9675 - 8208: jis0208<<14 | 0x00<<7 | 0x5A,
	9678 - 8208: jis0208<<14 | 0x00<<7 | 0x5C,
	9679 - 8208: jis0208<<14 | 0x00<<7 | 0x5B,
	9711 - 8208: jis0208<<14 | 0x01<<7 | 0x5D,
	9733 - 8208: jis0208<<14 | 0x00<<7 | 0x59,
	9734 - 8208: jis0208<<14 | 0x00<<7 | 0x58,
	9792 - 8208: jis0208<<14 | 0x00<<7 | 0x49,
	9794 - 8208: jis0208<<14 | 0x00<<7 | 0x48,
	9834 - 8208: jis0208<<14 | 0x01<<7 | 0x55,
	9837 - 8208: jis0208<<14 | 0x01<<7 | 0x54,
	9839 - 8208: jis0208<<14 | 0x01<<7 | 0x53,
}

const encode2Low, encode2High = 12288, 13262

var encode2 = [...]uint16{
	12288 - 12288: jis0208<<14 | 0x00<<7 | 0x00,
	12289 - 12288: jis0208<<14 | 0x00<<7 | 0x01,
	12290 - 12288: jis0208<<14 | 0x00<<7 | 0x02,
	12291 - 12288: jis0208<<14 | 0x00<<7 | 0x16,
	12293 - 12288: jis0208<<14 | 0x00<<7 | 0x18,
	12294 - 12288: jis0208<<14 | 0x00<<7 | 0x19,
	12295 - 12288: jis0208<<14 | 0x00<<7 | 0x1A,
	12296 - 12288: jis0208<<14 | 0x00<<7 | 0x31,
	12297 - 12288: jis0208<<14 | 0x00<<7 | 0x32,
	12298 - 12288: jis0208<<14 | 0x00<<7 | 0x33,
	12299 - 12288: jis0208<<14 | 0x00<<7 | 0x34,
	12300 - 12288: jis0208<<14 | 0x00<<7 | 0x35,
	12301 - 12288: jis0208<<14 | 0x00<<7 | 0x36,
	12302 - 12288: jis0208<<14 | 0x00<<7 | 0x37,
	12303 - 12288: jis0208<<14 | 0x00<<7 | 0x38,
	12304 - 12288: jis0208<<14 | 0x00<<7 | 0x39,
	12305 - 12288: jis0208<<14 | 0x00<<7 | 0x3A,
	12306 - 12288: jis0208<<14 | 0x01<<7 | 0x08,
	12307 - 12288: jis0208<<14 | 0x01<<7 | 0x0D,
	12308 - 12288: jis0208<<14 | 0x00<<7 | 0x2B,
	12309 - 12288: jis0208<<14 | 0x00<<7 | 0x2C,
	12317 - 12288: jis0208<<14 | 0x0C<<7 | 0x3F,
	12319 - 12288: jis0208<<14 | 0x0C<<7 | 0x40,
	12353 - 12288: jis0208<<14 | 0x03<<7 | 0x00,
	12354 - 12288: jis0208<<14 | 0x03<<7 | 0x01,
	12355 - 12288: jis0208<<14 | 0x03<<7 | 0x02,
	12356 - 12288: jis0208<<14 | 0x03<<7 | 0x03,
	12357 - 12288: jis0208<<14 | 0x03<<7 | 0x04,
	12358 - 12288: jis0208<<14 | 0x03<<7 | 0x05,
	12359 - 12288: jis0208<<14 | 0x03<<7 | 0x06,
	12360 - 12288: jis0208<<14 | 0x03<<7 | 0x07,
	12361 - 12288: jis0208<<14 | 0x03<<7 | 0x08,
	12362 - 12288: jis0208<<14 | 0x03<<7 | 0x09,
	12363 - 12288: jis0208<<14 | 0x03<<7 | 0x0A,
	12364 - 12288: jis0208<<14 | 0x03<<7 | 0x0B,
	12365 - 12288: jis0208<<14 | 0x03<<7 | 0x0C,
	12366 - 12288: jis0208<<14 | 0x03<<7 | 0x0D,
	12367 - 12288: jis0208<<14 | 0x03<<7 | 0x0E,
	12368 - 12288: jis0208<<14 | 0x03<<7 | 0x0F,
	12369 - 12288: jis0208<<14 | 0x03<<7 | 0x10,
	12370 - 12288: jis0208<<14 | 0x03<<7 | 0x11,
	12371 - 12288: jis0208<<14 | 0x03<<7 | 0x12,
	12372 - 12288: jis0208<<14 | 0x03<<7 | 0x13,
	12373 - 12288: jis0208<<14 | 0x03<<7 | 0x14,
	12374 - 12288: jis0208<<14 | 0x03<<7 | 0x15,
	12375 - 12288: jis0208<<14 | 0x03<<7 | 0x16,
	12376 - 12288: jis0208<<14 | 0x03<<7 | 0x17,
	12377 - 12288: jis0208<<14 | 0x03<<7 | 0x18,
	12378 - 12288: jis0208<<14 | 0x03<<7 | 0x19,
	12379 - 12288: jis0208<<14 | 0x03<<7 | 0x1A,
	12380 - 12288: jis0208<<14 | 0x03<<7 | 0x1B,
	12381 - 12288: jis0208<<14 | 0x03<<7 | 0x1C,
	12382 - 12288: jis0208<<14 | 0x03<<7 | 0x1D,
	12383 - 12288: jis0208<<14 | 0x03<<7 | 0x1E,
	12384 - 12288: jis0208<<14 | 0x03<<7 | 0x1F,
	12385 - 12288: jis0208<<14 | 0x03<<7 | 0x20,
	12386 - 12288: jis0208<<14 | 0x03<<7 | 0x21,
	12387 - 12288: jis0208<<14 | 0x03<<7 | 0x22,
	12388 - 12288: jis0208<<14 | 0x03<<7 | 0x23,
	12389 - 12288: jis0208<<14 | 0x03<<7 | 0x24,
	12390 - 12288: jis0208<<14 | 0x03<<7 | 0x25,
	12391 - 12288: jis0208<<14 | 0x03<<7 | 0x26,
	12392 - 12288: jis0208<<14 | 0x03<<7 | 0x27,
	12393 - 12288: jis0208<<14 | 0x03<<7 | 0x28,
	12394 - 12288: jis0208<<14 | 0x03<<7 | 0x29,
	12395 - 12288: jis0208<<14 | 0x03<<7 | 0x2A,
	12396 - 12288: jis0208<<14 | 0x03<<7 | 0x2B,
	12397 - 12288: jis0208<<14 | 0x03<<7 | 0x2C,
	12398 - 12288: jis0208<<14 | 0x03<<7 | 0x2D,
	12399 - 12288: jis0208<<14 | 0x03<<7 | 0x2E,
	12400 - 12288: jis0208<<14 | 0x03<<7 | 0x2F,
	12401 - 12288: jis0208<<14 | 0x03<<7 | 0x30,
	12402 - 12288: jis0208<<14 | 0x03<<7 | 0x31,
	12403 - 12288: jis0208<<14 | 0x03<<7 | 0x32,
	12404 - 12288: jis0208<<14 | 0x03<<7 | 0x33,
	12405 - 12288: jis0208<<14 | 0x03<<7 | 0x34,
	12406 - 12288: jis0208<<14 | 0x03<<7 | 0x35,
	12407 - 12288: jis0208<<14 | 0x03<<7 | 0x36,
	12408 - 12288: jis0208<<14 | 0x03<<7 | 0x37,
	12409 - 12288: jis0208<<14 | 0x03<<7 | 0x38,
	12410 - 12288: jis0208<<14 | 0x03<<7 | 0x39,
	12411 - 12288: jis0208<<14 | 0x03<<7 | 0x3A,
	12412 - 12288: jis0208<<14 | 0x03<<7 | 0x3B,
	12413 - 12288: jis0208<<14 | 0x03<<7 | 0x3C,
	12414 - 12288: jis0208<<14 | 0x03<<7 | 0x3D,
	12415 - 12288: jis0208<<14 | 0x03<<7 | 0x3E,
	12416 - 12288: jis0208<<14 | 0x03<<7 | 0x3F,
	12417 - 12288: jis0208<<14 | 0x03<<7 | 0x40,
	12418 - 12288: jis0208<<14 | 0x03<<7 | 0x41,
	12419 - 12288: jis0208<<14 | 0x03<<7 | 0x42,
	12420 - 12288: jis0208<<14 | 0x03<<7 | 0x43,
	12421 - 12288: jis0208<<14 | 0x03<<7 | 0x44,
	12422 - 12288: jis0208<<14 | 0x03<<7 | 0x45,
	12423 - 12288: jis0208<<14 | 0x03<<7 | 0x46,
	12424 - 12288: jis0208<<14 | 0x03<<7 | 0x47,
	12425 - 12288: jis0208<<14 | 0x03<<7 | 0x48,
	12426 - 12288: jis0208<<14 | 0x03<<7 | 0x49,
	12427 - 12288: jis0208<<14 | 0x03<<7 | 0x4A,
	12428 - 12288: jis0208<<14 | 0x03<<7 | 0x4B,
	12429 - 12288: jis0208<<14 | 0x03<<7 | 0x4C,
	12430 - 12288: jis0208<<14 | 0x03<<7 | 0x4D,
	12431 - 12288: jis0208<<14 | 0x03<<7 | 0x4E,
	12432 - 12288: jis0208<<14 | 0x03<<7 | 0x4F,
	12433 - 12288: jis0208<<14 | 0x03<<7 | 0x50,
	12434 - 12288: jis0208<<14 | 0x03<<7 | 0x51,
	12435 - 12288: jis0208<<14 | 0x03<<7 | 0x52,
	12443 - 12288: jis0208<<14 | 0x00<<7 | 0x0A,
	12444 - 12288: jis0208<<14 | 0x00<<7 | 0x0B,
	12445 - 12288: jis0208<<14 | 0x00<<7 | 0x14,
	12446 - 12288: jis0208<<14 | 0x00<<7 | 0x15,
	12449 - 12288: jis0208<<14 | 0x04<<7 | 0x00,
	12450 - 12288: jis0208<<14 | 0x04<<7 | 0x01,
	12451 - 12288: jis0208<<14 | 0x04<<7 | 0x02,
	12452 - 12288: jis0208<<14 | 0x04<<7 | 0x03,
	12453 - 12288: jis0208<<14 | 0x04<<7 | 0x04,
	12454 - 12288: jis0208<<14 | 0x04<<7 | 0x05,
	12455 - 12288: jis0208<<14 | 0x04<<7 | 0x06,
	12456 - 12288: jis0208<<14 | 0x04<<7 | 0x07,
	12457 - 12288: jis0208<<14 | 0x04<<7 | 0x08,
	12458 - 12288: jis0208<<14 | 0x04<<7 | 0x09,
	12459 - 12288: jis0208<<14 | 0x04<<7 | 0x0A,
	12460 - 12288: jis0208<<14 | 0x04<<7 | 0x0B,
	12461 - 12288: jis0208<<14 | 0x04<<7 | 0x0C,
	12462 - 12288: jis0208<<14 | 0x04<<7 | 0x0D,
	12463 - 12288: jis0208<<14 | 0x04<<7 | 0x0E,
	12464 - 12288: jis0208<<14 | 0x04<<7 | 0x0F,
	12465 - 12288: jis0208<<14 | 0x04<<7 | 0x10,
	12466 - 12288: jis0208<<14 | 0x04<<7 | 0x11,
	12467 - 12288: jis0208<<14 | 0x04<<7 | 0x12,
	12468 - 12288: jis0208<<14 | 0x04<<7 | 0x13,
	12469 - 12288: jis0208<<14 | 0x04<<7 | 0x14,
	12470 - 12288: jis0208<<14 | 0x04<<7 | 0x15,
	12471 - 12288: jis0208<<14 | 0x04<<7 | 0x16,
	12472 - 12288: jis0208<<14 | 0x04<<7 | 0x17,
	12473 - 12288: jis0208<<14 | 0x04<<7 | 0x18,
	12474 - 12288: jis0208<<14 | 0x04<<7 | 0x19,
	12475 - 12288: jis0208<<14 | 0x04<<7 | 0x1A,
	12476 - 12288: jis0208<<14 | 0x04<<7 | 0x1B,
	12477 - 12288: jis0208<<14 | 0x04<<7 | 0x1C,
	12478 - 12288: jis0208<<14 | 0x04<<7 | 0x1D,
	12479 - 12288: jis0208<<14 | 0x04<<7 | 0x1E,
	12480 - 12288: jis0208<<14 | 0x04<<7 | 0x1F,
	12481 - 12288: jis0208<<14 | 0x04<<7 | 0x20,
	12482 - 12288: jis0208<<14 | 0x04<<7 | 0x21,
	12483 - 12288: jis0208<<14 | 0x04<<7 | 0x22,
	12484 - 12288: jis0208<<14 | 0x04<<7 | 0x23,
	12485 - 12288: jis0208<<14 | 0x04<<7 | 0x24,
	12486 - 12288: jis0208<<14 | 0x04<<7 | 0x25,
	12487 - 12288: jis0208<<14 | 0x04<<7 | 0x26,
	12488 - 12288: jis0208<<14 | 0x04<<7 | 0x27,
	12489 - 12288: jis0208<<14 | 0x04<<7 | 0x28,
	12490 - 12288: jis0208<<14 | 0x04<<7 | 0x29,
	12491 - 12288: jis0208<<14 | 0x04<<7 | 0x2A,
	12492 - 12288: jis0208<<14 | 0x04<<7 | 0x2B,
	12493 - 12288: jis0208<<14 | 0x04<<7 | 0x2C,
	12494 - 12288: jis0208<<14 | 0x04<<7 | 0x2D,
	12495 - 12288: jis0208<<14 | 0x04<<7 | 0x2E,
	12496 - 12288: jis0208<<14 | 0x04<<7 | 0x2F,
	12497 - 12288: jis0208<<14 | 0x04<<7 | 0x30,
	12498 - 12288: jis0208<<14 | 0x04<<7 | 0x31,
	12499 - 12288: jis0208<<14 | 0x04<<7 | 0x32,
	12500 - 12288: jis0208<<14 | 0x04<<7 | 0x33,
	12501 - 12288: jis0208<<14 | 0x04<<7 | 0x34,
	12502 - 12288: jis0208<<14 | 0x04<<7 | 0x35,
	12503 - 12288: jis0208<<14 | 0x04<<7 | 0x36,
	12504 - 12288: jis0208<<14 | 0x04<<7 | 0x37,
	12505 - 12288: jis0208<<14 | 0x04<<7 | 0x38,
	12506 - 12288: jis0208<<14 | 0x04<<7 | 0x39,
	12507 - 12288: jis0208<<14 | 0x04<<7 | 0x3A,
	12508 - 12288: jis0208<<14 | 0x04<<7 | 0x3B,
	12509 - 12288: jis0208<<14 | 0x04<<7 | 0x3C,
	12510 - 12288: jis0208<<14 | 0x04<<7 | 0x3D,
	12511 - 12288: jis0208<<14 | 0x04<<7 | 0x3E,
	12512 - 12288: jis0208<<14 | 0x04<<7 | 0x3F,
	12513 - 12288: jis0208<<14 | 0x04<<7 | 0x40,
	12514 - 12288: jis0208<<14 | 0x04<<7 | 0x41,
	12515 - 12288: jis0208<<14 | 0x04<<7 | 0x42,
	12516 - 12288: jis0208<<14 | 0x04<<7 | 0x43,
	12517 - 12288: jis0208<<14 | 0x04<<7 | 0x44,
	12518 - 12288: jis0208<<14 | 0x04<<7 | 0x45,
	12519 - 12288: jis0208<<14 | 0x04<<7 | 0x46,
	12520 - 12288: jis0208<<14 | 0x04<<7 | 0x47,
	12521 - 12288: jis0208<<14 | 0x04<<7 | 0x48,
	12522 - 12288: jis0208<<14 | 0x04<<7 | 0x49,
	12523 - 12288: jis0208<<14 | 0x04<<7 | 0x4A,
	12524 - 12288: jis0208<<14 | 0x04<<7 | 0x4B,
	12525 - 12288: jis0208<<14 | 0x04<<7 | 0x4C,
	12526 - 12288: jis0208<<14 | 0x04<<7 | 0x4D,
	12527 - 12288: jis0208<<14 | 0x04<<7 | 0x4E,
	12528 - 12288: jis0208<<14 | 0x04<<7 | 0x4F,
	12529 - 12288: jis0208<<14 | 0x04<<7 | 0x50,
	12530 - 12288: jis0208<<14 | 0x04<<7 | 0x51,
	12531 - 12288: jis0208<<14 | 0x04<<7 | 0x52,
	12532 - 12288: jis0208<<14 | 0x04<<7 | 0x53,
	12533 - 12288: jis0208<<14 | 0x04<<7 | 0x54,
	12534 - 12288: jis0208<<14 | 0x04<<7 | 0x55,
	12539 - 12288: jis0208<<14 | 0x00<<7 | 0x05,
	12540 - 12288: jis0208<<14 | 0x00<<7 | 0x1B,
	12541 - 12288: jis0208<<14 | 0x00<<7 | 0x12,
	12542 - 12288: jis0208<<14 | 0x00<<7 | 0x13,
	12849 - 12288: jis0208<<14 | 0x0C<<7 | 0x49,
	12850 - 12288: jis0208<<14 | 0x0C<<7 | 0x4A,
	12857 - 12288: jis0208<<14 | 0x0C<<7 | 0x4B,
	12964 - 12288: jis0208<<14 | 0x0C<<7 | 0x44,
	12965 - 12288: jis0208<<14 | 0x0C<<7 | 0x45,
	12966 - 12288: jis0208<<14 | 0x0C<<7 | 0x46,
	12967 - 12288: jis0208<<14 | 0x0C<<7 | 0x47,
	12968 - 12288: jis0208<<14 | 0x0C<<7 | 0x48,
	13059 - 12288: jis0208<<14 | 0x0C<<7 | 0x25,
	13069 - 12288: jis0208<<14 | 0x0C<<7 | 0x29,
	13076 - 12288: jis0208<<14 | 0x0C<<7 | 0x20,
	13080 - 12288: jis0208<<14 | 0x0C<<7 | 0x23,
	13090 - 12288: jis0208<<14 | 0x0C<<7 | 0x21,
	13091 - 12288: jis0208<<14 | 0x0C<<7 | 0x2B,
	13094 - 12288: jis0208<<14 | 0x0C<<7 | 0x2A,
	13095 - 12288: jis0208<<14 | 0x0C<<7 | 0x24,
	13099 - 12288: jis0208<<14 | 0x0C<<7 | 0x2C,
	13110 - 12288: jis0208<<14 | 0x0C<<7 | 0x26,
	13115 - 12288: jis0208<<14 | 0x0C<<7 | 0x2E,
	13129 - 12288: jis0208<<14 | 0x0C<<7 | 0x1F,
	13130 - 12288: jis0208<<14 | 0x0C<<7 | 0x2D,
	13133 - 12288: jis0208<<14 | 0x0C<<7 | 0x22,
	13137 - 12288: jis0208<<14 | 0x0C<<7 | 0x27,
	13143 - 12288: jis0208<<14 | 0x0C<<7 | 0x28,
	13179 - 12288: jis0208<<14 | 0x0C<<7 | 0x3E,
	13180 - 12288: jis0208<<14 | 0x0C<<7 | 0x4E,
	13181 - 12288: jis0208<<14 | 0x0C<<7 | 0x4D,
	13182 - 12288: jis0208<<14 | 0x0C<<7 | 0x4C,
	13198 - 12288: jis0208<<14 | 0x0C<<7 | 0x32,
	13199 - 12288: jis0208<<14 | 0x0C<<7 | 0x33,
	13212 - 12288: jis0208<<14 | 0x0C<<7 | 0x2F,
	13213 - 12288: jis0208<<14 | 0x0C<<7 | 0x30,
	13214 - 12288: jis0208<<14 | 0x0C<<7 | 0x31,
	13217 - 12288: jis0208<<14 | 0x0C<<7 | 0x35,
	13252 - 12288: jis0208<<14 | 0x0C<<7 | 0x34,
	13261 - 12288: jis0208<<14 | 0x0C<<7 | 0x42,
}

const encode3Low, encode3High = 161, 1120

var encode3 = [...]uint16{
	161 - 161:  jis0212<<14 | 0x01<<7 | 0x21,
	164 - 161:  jis0212<<14 | 0x01<<7 | 0x4F,
	166 - 161:  jis0212<<14 | 0x01<<7 | 0x22,
	167 - 161:  jis0208<<14 | 0x00<<7 | 0x57,
	168 - 161:  jis0208<<14 | 0x00<<7 | 0x0E,
	169 - 161:  jis0212<<14 | 0x01<<7 | 0x4C,
	170 - 161:  jis0212<<14 | 0x01<<7 | 0x4B,
	174 - 161:  jis0212<<14 | 0x01<<7 | 0x4D,
	175 - 161:  jis0212<<14 | 0x01<<7 | 0x13,
	176 - 161:  jis0208<<14 | 0x00<<7 | 0x4A,
	177 - 161:  jis0208<<14 | 0x00<<7 | 0x3D,
	180 - 161:  jis0208<<14 | 0x00<<7 | 0x0C,
	182 - 161:  jis0208<<14 | 0x01<<7 | 0x58,
	184 - 161:  jis0212<<14 | 0x01<<7 | 0x10,
	186 - 161:  jis0212<<14 | 0x01<<7 | 0x4A,
	191 - 161:  jis0212<<14 | 0x01<<7 | 0x23,
	192 - 161:  jis0212<<14 | 0x09<<7 | 0x01,
	193 - 161:  jis0212<<14 | 0x09<<7 | 0x00,
	194 - 161:  jis0212<<14 | 0x09<<7 | 0x03,
	195 - 161:  jis0212<<14 | 0x09<<7 | 0x09,
	196 - 161:  jis0212<<14 | 0x09<<7 | 0x02,
	197 - 161:  jis0212<<14 | 0x09<<7 | 0x08,
	198 - 161:  jis0212<<14 | 0x08<<7 | 0x00,
	199 - 161:  jis0212<<14 | 0x09<<7 | 0x0D,
	200 - 161:  jis0212<<14 | 0x09<<7 | 0x11,
	201 - 161:  jis0212<<14 | 0x09<<7 | 0x10,
	202 - 161:  jis0212<<14 | 0x09<<7 | 0x13,
	203 - 161:  jis0212<<14 | 0x09<<7 | 0x12,
	204 - 161:  jis0212<<14 | 0x09<<7 | 0x1F,
	205 - 161:  jis0212<<14 | 0x09<<7 | 0x1E,
	206 - 161:  jis0212<<14 | 0x09<<7 | 0x21,
	207 - 161:  jis0212<<14 | 0x09<<7 | 0x20,
	209 - 161:  jis0212<<14 | 0x09<<7 | 0x2F,
	210 - 161:  jis0212<<14 | 0x09<<7 | 0x31,
	211 - 161:  jis0212<<14 | 0x09<<7 | 0x30,
	212 - 161:  jis0212<<14 | 0x09<<7 | 0x33,
	213 - 161:  jis0212<<14 | 0x09<<7 | 0x37,
	214 - 161:  jis0212<<14 | 0x09<<7 | 0x32,
	215 - 161:  jis0208<<14 | 0x00<<7 | 0x3E,
	216 - 161:  jis0212<<14 | 0x08<<7 | 0x0B,
	217 - 161:  jis0212<<14 | 0x09<<7 | 0x42,
	218 - 161:  jis0212<<14 | 0x09<<7 | 0x41,
	219 - 161:  jis0212<<14 | 0x09<<7 | 0x44,
	220 - 161:  jis0212<<14 | 0x09<<7 | 0x43,
	221 - 161:  jis0212<<14 | 0x09<<7 | 0x51,
	222 - 161:  jis0212<<14 | 0x08<<7 | 0x0F,
	223 - 161:  jis0212<<14 | 0x08<<7 | 0x2D,
	224 - 161:  jis0212<<14 | 0x0A<<7 | 0x01,
	225 - 161:  jis0212<<14 | 0x0A<<7 | 0x00,
	226 - 161:  jis0212<<14 | 0x0A<<7 | 0x03,
	227 - 161:  jis0212<<14 | 0x0A<<7 | 0x09,
	228 - 161:  jis0212<<14 | 0x0A<<7 | 0x02,
	229 - 161:  jis0212<<14 | 0x0A<<7 | 0x08,
	230 - 161:  jis0212<<14 | 0x08<<7 | 0x20,
	231 - 161:  jis0212<<14 | 0x0A<<7 | 0x0D,
	232 - 161:  jis0212<<14 | 0x0A<<7 | 0x11,
	233 - 161:  jis0212<<14 | 0x0A<<7 | 0x10,
	234 - 161:  jis0212<<14 | 0x0A<<7 | 0x13,
	235 - 161:  jis0212<<14 | 0x0A<<7 | 0x12,
	236 - 161:  jis0212<<14 | 0x0A<<7 | 0x1F,
	237 - 161:  jis0212<<14 | 0x0A<<7 | 0x1E,
	238 - 161:  jis0212<<14 | 0x0A<<7 | 0x21,
	239 - 161:  jis0212<<14 | 0x0A<<7 | 0x20,
	240 - 161:  jis0212<<14 | 0x08<<7 | 0x22,
	241 - 161:  jis0212<<14 | 0x0A<<7 | 0x2F,
	242 - 161:  jis0212<<14 | 0x0A<<7 | 0x31,
	243 - 161:  jis0212<<14 | 0x0A<<7 | 0x30,
	244 - 161:  jis0212<<14 | 0x0A<<7 | 0x33,
	245 - 161:  jis0212<<14 | 0x0A<<7 | 0x37,
	246 - 161:  jis0212<<14 | 0x0A<<7 | 0x32,
	247 - 161:  jis0208<<14 | 0x00<<7 | 0x3F,
	248 - 161:  jis0212<<14 | 0x08<<7 | 0x2B,
	249 - 161:  jis0212<<14 | 0x0A<<7 | 0x42,
	250 - 161:  jis0212<<14 | 0x0A<<7 | 0x41,
	251 - 161:  jis0212<<14 | 0x0A<<7 | 0x44,
	252 - 161:  jis0212<<14 | 0x0A<<7 | 0x43,
	253 - 161:  jis0212<<14 | 0x0A<<7 | 0x51,
	254 - 161:  jis0212<<14 | 0x08<<7 | 0x2F,
	255 - 161:  jis0212<<14 | 0x0A<<7 | 0x52,
	256 - 161:  jis0212<<14 | 0x09<<7 | 0x06,
	257 - 161:  jis0212<<14 | 0x0A<<7 | 0x06,
	258 - 161:  jis0212<<14 | 0x09<<7 | 0x04,
	259 - 161:  jis0212<<14 | 0x0A<<7 | 0x04,
	260 - 161:  jis0212<<14 | 0x09<<7 | 0x07,
	261 - 161:  jis0212<<14 | 0x0A<<7 | 0x07,
	262 - 161:  jis0212<<14 | 0x09<<7 | 0x0A,
	263 - 161:  jis0212<<14 | 0x0A<<7 | 0x0A,
	264 - 161:  jis0212<<14 | 0x09<<7 | 0x0B,
	265 - 161:  jis0212<<14 | 0x0A<<7 | 0x0B,
	266 - 161:  jis0212<<14 | 0x09<<7 | 0x0E,
	267 - 161:  jis0212<<14 | 0x0A<<7 | 0x0E,
	268 - 161:  jis0212<<14 | 0x09<<7 | 0x0C,
	269 - 161:  jis0212<<14 | 0x0A<<7 | 0x0C,
	270 - 161:  jis0212<<14 | 0x09<<7 | 0x0F,
	271 - 161:  jis0212<<14 | 0x0A<<7 | 0x0F,
	272 - 161:  jis0212<<14 | 0x08<<7 | 0x01,
	273 - 161:  jis0212<<14 | 0x08<<7 | 0x21,
	274 - 161:  jis0212<<14 | 0x09<<7 | 0x16,
	275 - 161:  jis0212<<14 | 0x0A<<7 | 0x16,
	278 - 161:  jis0212<<14 | 0x09<<7 | 0x15,
	279 - 161:  jis0212<<14 | 0x0A<<7 | 0x15,
	280 - 161:  jis0212<<14 | 0x09<<7 | 0x17,
	281 - 161:  jis0212<<14 | 0x0A<<7 | 0x17,
	282 - 161:  jis0212<<14 | 0x09<<7 | 0x14,
	283 - 161:  jis0212<<14 | 0x0A<<7 | 0x14,
	284 - 161:  jis0212<<14 | 0x09<<7 | 0x19,
	285 - 161:  jis0212<<14 | 0x0A<<7 | 0x19,
	286 - 161:  jis0212<<14 | 0x09<<7 | 0x1A,
	287 - 161:  jis0212<<14 | 0x0A<<7 | 0x1A,
	288 - 161:  jis0212<<14 | 0x09<<7 | 0x1C,
	289 - 161:  jis0212<<14 | 0x0A<<7 | 0x1C,
	290 - 161:  jis0212<<14 | 0x09<<7 | 0x1B,
	292 - 161:  jis0212<<14 | 0x09<<7 | 0x1D,
	293 - 161:  jis0212<<14 | 0x0A<<7 | 0x1D,
	294 - 161:  jis0212<<14 | 0x08<<7 | 0x03,
	295 - 161:  jis0212<<14 | 0x08<<7 | 0x23,
	296 - 161:  jis0212<<14 | 0x09<<7 | 0x26,
	297 - 161:  jis0212<<14 | 0x0A<<7 | 0x26,
	298 - 161:  jis0212<<14 | 0x09<<7 | 0x24,
	299 - 161:  jis0212<<14 | 0x0A<<7 | 0x24,
	302 - 161:  jis0212<<14 | 0x09<<7 | 0x25,
	303 - 161:  jis0212<<14 | 0x0A<<7 | 0x25,
	304 - 161:  jis0212<<14 | 0x09<<7 | 0x23,
	305 - 161:  jis0212<<14 | 0x08<<7 | 0x24,
	306 - 161:  jis0212<<14 | 0x08<<7 | 0x05,
	307 - 161:  jis0212<<14 | 0x08<<7 | 0x25,
	308 - 161:  jis0212<<14 | 0x09<<7 | 0x27,
	309 - 161:  jis0212<<14 | 0x0A<<7 | 0x27,
	310 - 161:  jis0212<<14 | 0x09<<7 | 0x28,
	311 - 161:  jis0212<<14 | 0x0A<<7 | 0x28,
	312 - 161:  jis0212<<14 | 0x08<<7 | 0x26,
	313 - 161:  jis0212<<14 | 0x09<<7 | 0x29,
	314 - 161:  jis0212<<14 | 0x0A<<7 | 0x29,
	315 - 161:  jis0212<<14 | 0x09<<7 | 0x2B,
	316 - 161:  jis0212<<14 | 0x0A<<7 | 0x2B,
	317 - 161:  jis0212<<14 | 0x09<<7 | 0x2A,
	318 - 161:  jis0212<<14 | 0x0A<<7 | 0x2A,
	319 - 161:  jis0212<<14 | 0x08<<7 | 0x08,
	320 - 161:  jis0212<<14 | 0x08<<7 | 0x28,
	321 - 161:  jis0212<<14 | 0x08<<7 | 0x07,
	322 - 161:  jis0212<<14 | 0x08<<7 | 0x27,
	323 - 161:  jis0212<<14 | 0x09<<7 | 0x2C,
	324 - 161:  jis0212<<14 | 0x0A<<7 | 0x2C,
	325 - 161:  jis0212<<14 | 0x09<<7 | 0x2E,
	326 - 161:  jis0212<<14 | 0x0A<<7 | 0x2E,
	327 - 161:  jis0212<<14 | 0x09<<7 | 0x2D,
	328 - 161:  jis0212<<14 | 0x0A<<7 | 0x2D,
	329 - 161:  jis0212<<14 | 0x08<<7 | 0x29,
	330 - 161:  jis0212<<14 | 0x08<<7 | 0x0A,
	331 - 161:  jis0212<<14 | 0x08<<7 | 0x2A,
	332 - 161:  jis0212<<14 | 0x09<<7 | 0x36,
	333 - 161:  jis0212<<14 | 0x0A<<7 | 0x36,
	336 - 161:  jis0212<<14 | 0x09<<7 | 0x35,
	337 - 161:  jis0212<<14 | 0x0A<<7 | 0x35,
	338 - 161:  jis0212<<14 | 0x08<<7 | 0x0C,
	339 - 161:  jis0212<<14 | 0x08<<7 | 0x2C,
	340 - 161:  jis0212<<14 | 0x09<<7 | 0x38,
	341 - 161:  jis0212<<14 | 0x0A<<7 | 0x38,
	342 - 161:  jis0212<<14 | 0x09<<7 | 0x3A,
	343 - 161:  jis0212<<14 | 0x0A<<7 | 0x3A,
	344 - 161:  jis0212<<14 | 0x09<<7 | 0x39,
	345 - 161:  jis0212<<14 | 0x0A<<7 | 0x39,
	346 - 161:  jis0212<<14 | 0x09<<7 | 0x3B,
	347 - 161:  jis0212<<14 | 0x0A<<7 | 0x3B,
	348 - 161:  jis0212<<14 | 0x09<<7 | 0x3C,
	349 - 161:  jis0212<<14 | 0x0A<<7 | 0x3C,
	350 - 161:  jis0212<<14 | 0x09<<7 | 0x3E,
	351 - 161:  jis0212<<14 | 0x0A<<7 | 0x3E,
	352 - 161:  jis0212<<14 | 0x09<<7 | 0x3D,
	353 - 161:  jis0212<<14 | 0x0A<<7 | 0x3D,
	354 - 161:  jis0212<<14 | 0x09<<7 | 0x40,
	355 - 161:  jis0212<<14 | 0x0A<<7 | 0x40,
	356 - 161:  jis0212<<14 | 0x09<<7 | 0x3F,
	357 - 161:  jis0212<<14 | 0x0A<<7 | 0x3F,
	358 - 161:  jis0212<<14 | 0x08<<7 | 0x0E,
	359 - 161:  jis0212<<14 | 0x08<<7 | 0x2E,
	360 - 161:  jis0212<<14 | 0x09<<7 | 0x4B,
	361 - 161:  jis0212<<14 | 0x0A<<7 | 0x4B,
	362 - 161:  jis0212<<14 | 0x09<<7 | 0x48,
	363 - 161:  jis0212<<14 | 0x0A<<7 | 0x48,
	364 - 161:  jis0212<<14 | 0x09<<7 | 0x45,
	365 - 161:  jis0212<<14 | 0x0A<<7 | 0x45,
	366 - 161:  jis0212<<14 | 0x09<<7 | 0x4A,
	367 - 161:  jis0212<<14 | 0x0A<<7 | 0x4A,
	368 - 161:  jis0212<<14 | 0x09<<7 | 0x47,
	369 - 161:  jis0212<<14 | 0x0A<<7 | 0x47,
	370 - 161:  jis0212<<14 | 0x09<<7 | 0x49,
	371 - 161:  jis0212<<14 | 0x0A<<7 | 0x49,
	372 - 161:  jis0212<<14 | 0x09<<7 | 0x50,
	373 - 161:  jis0212<<14 | 0x0A<<7 | 0x50,
	374 - 161:  jis0212<<14 | 0x09<<7 | 0x53,
	375 - 161:  jis0212<<14 | 0x0A<<7 | 0x53,
	376 - 161:  jis0212<<14 | 0x09<<7 | 0x52,
	377 - 161:  jis0212<<14 | 0x09<<7 | 0x54,
	378 - 161:  jis0212<<14 | 0x0A<<7 | 0x54,
	379 - 161:  jis0212<<14 | 0x09<<7 | 0x56,
	380 - 161:  jis0212<<14 | 0x0A<<7 | 0x56,
	381 - 161:  jis0212<<14 | 0x09<<7 | 0x55,
	382 - 161:  jis0212<<14 | 0x0A<<7 | 0x55,
	461 - 161:  jis0212<<14 | 0x09<<7 | 0x05,
	462 - 161:  jis0212<<14 | 0x0A<<7 | 0x05,
	463 - 161:  jis0212<<14 | 0x09<<7 | 0x22,
	464 - 161:  jis0212<<14 | 0x0A<<7 | 0x22,
	465 - 161:  jis0212<<14 | 0x09<<7 | 0x34,
	466 - 161:  jis0212<<14 | 0x0A<<7 | 0x34,
	467 - 161:  jis0212<<14 | 0x09<<7 | 0x46,
	468 - 161:  jis0212<<14 | 0x0A<<7 | 0x46,
	469 - 161:  jis0212<<14 | 0x09<<7 | 0x4F,
	470 - 161:  jis0212<<14 | 0x0A<<7 | 0x4F,
	471 - 161:  jis0212<<14 | 0x09<<7 | 0x4C,
	472 - 161:  jis0212<<14 | 0x0A<<7 | 0x4C,
	473 - 161:  jis0212<<14 | 0x09<<7 | 0x4E,
	474 - 161:  jis0212<<14 | 0x0A<<7 | 0x4E,
	475 - 161:  jis0212<<14 | 0x09<<7 | 0x4D,
	476 - 161:  jis0212<<14 | 0x0A<<7 | 0x4D,
	501 - 161:  jis0212<<14 | 0x0A<<7 | 0x18,
	711 - 161:  jis0212<<14 | 0x01<<7 | 0x0F,
	728 - 161:  jis0212<<14 | 0x01<<7 | 0x0E,
	729 - 161:  jis0212<<14 | 0x01<<7 | 0x11,
	730 - 161:  jis0212<<14 | 0x01<<7 | 0x15,
	731 - 161:  jis0212<<14 | 0x01<<7 | 0x14,
	733 - 161:  jis0212<<14 | 0x01<<7 | 0x12,
	900 - 161:  jis0212<<14 | 0x01<<7 | 0x17,
	901 - 161:  jis0212<<14 | 0x01<<7 | 0x18,
	902 - 161:  jis0212<<14 | 0x05<<7 | 0x40,
	904 - 161:  jis0212<<14 | 0x05<<7 | 0x41,
	905 - 161:  jis0212<<14 | 0x05<<7 | 0x42,
	906 - 161:  jis0212<<14 | 0x05<<7 | 0x43,
	908 - 161:  jis0212<<14 | 0x05<<7 | 0x46,
	910 - 161:  jis0212<<14 | 0x05<<7 | 0x48,
	911 - 161:  jis0212<<14 | 0x05<<7 | 0x4B,
	912 - 161:  jis0212<<14 | 0x05<<7 | 0x55,
	913 - 161:  jis0208<<14 | 0x05<<7 | 0x00,
	914 - 161:  jis0208<<14 | 0x05<<7 | 0x01,
	915 - 161:  jis0208<<14 | 0x05<<7 | 0x02,
	916 - 161:  jis0208<<14 | 0x05<<7 | 0x03,
	917 - 161:  jis0208<<14 | 0x05<<7 | 0x04,
	918 - 161:  jis0208<<14 | 0x05<<7 | 0x05,
	919 - 161:  jis0208<<14 | 0x05<<7 | 0x06,
	920 - 161:  jis0208<<14 | 0x05<<7 | 0x07,
	921 - 161:  jis0208<<14 | 0x05<<7 | 0x08,
	922 - 161:  jis0208<<14 | 0x05<<7 | 0x09,
	923 - 161:  jis0208<<14 | 0x05<<7 | 0x0A,
	924 - 161:  jis0208<<14 | 0x05<<7 | 0x0B,
	925 - 161:  jis0208<<14 | 0x05<<7 | 0x0C,
	926 - 161:  jis0208<<14 | 0x05<<7 | 0x0D,
	927 - 161:  jis0208<<14 | 0x05<<7 | 0x0E,
	928 - 161:  jis0208<<14 | 0x05<<7 | 0x0F,
	929 - 161:  jis0208<<14 | 0x05<<7 | 0x10,
	931 - 161:  jis0208<<14 | 0x05<<7 | 0x11,
	932 - 161:  jis0208<<14 | 0x05<<7 | 0x12,
	933 - 161:  jis0208<<14 | 0x05<<7 | 0x13,
	934 - 161:  jis0208<<14 | 0x05<<7 | 0x14,
	935 - 161:  jis0208<<14 | 0x05<<7 | 0x15,
	936 - 161:  jis0208<<14 | 0x05<<7 | 0x16,
	937 - 161:  jis0208<<14 | 0x05<<7 | 0x17,
	938 - 161:  jis0212<<14 | 0x05<<7 | 0x44,
	939 - 161:  jis0212<<14 | 0x05<<7 | 0x49,
	940 - 161:  jis0212<<14 | 0x05<<7 | 0x50,
	941 - 161:  jis0212<<14 | 0x05<<7 | 0x51,
	942 - 161:  jis0212<<14 | 0x05<<7 | 0x52,
	943 - 161:  jis0212<<14 | 0x05<<7 | 0x53,
	944 - 161:  jis0212<<14 | 0x05<<7 | 0x5A,
	945 - 161:  jis0208<<14 | 0x05<<7 | 0x20,
	946 - 161:  jis0208<<14 | 0x05<<7 | 0x21,
	947 - 161:  jis0208<<14 | 0x05<<7 | 0x22,
	948 - 161:  jis0208<<14 | 0x05<<7 | 0x23,
	949 - 161:  jis0208<<14 | 0x05<<7 | 0x24,
	950 - 161:  jis0208<<14 | 0x05<<7 | 0x25,
	951 - 161:  jis0208<<14 | 0x05<<7 | 0x26,
	952 - 161:  jis0208<<14 | 0x05<<7 | 0x27,
	953 - 161:  jis0208<<14 | 0x05<<7 | 0x28,
	954 - 161:  jis0208<<14 | 0x05<<7 | 0x29,
	955 - 161:  jis0208<<14 | 0x05<<7 | 0x2A,
	956 - 161:  jis0208<<14 | 0x05<<7 | 0x2B,
	957 - 161:  jis0208<<14 | 0x05<<7 | 0x2C,
	958 - 161:  jis0208<<14 | 0x05<<7 | 0x2D,
	959 - 161:  jis0208<<14 | 0x05<<7 | 0x2E,
	960 - 161:  jis0208<<14 | 0x05<<7 | 0x2F,
	961 - 161:  jis0208<<14 | 0x05<<7 | 0x30,
	962 - 161:  jis0212<<14 | 0x05<<7 | 0x57,
	963 - 161:  jis0208<<14 | 0x05<<7 | 0x31,
	964 - 161:  jis0208<<14 | 0x05<<7 | 0x32,
	965 - 161:  jis0208<<14 | 0x05<<7 | 0x33,
	966 - 161:  jis0208<<14 | 0x05<<7 | 0x34,
	967 - 161:  jis0208<<14 | 0x05<<7 | 0x35,
	968 - 161:  jis0208<<14 | 0x05<<7 | 0x36,
	969 - 161:  jis0208<<14 | 0x05<<7 | 0x37,
	970 - 161:  jis0212<<14 | 0x05<<7 | 0x54,
	971 - 161:  jis0212<<14 | 0x05<<7 | 0x59,
	972 - 161:  jis0212<<14 | 0x05<<7 | 0x56,
	973 - 161:  jis0212<<14 | 0x05<<7 | 0x58,
	974 - 161:  jis0212<<14 | 0x05<<7 | 0x5B,
	1025 - 161: jis0208<<14 | 0x06<<7 | 0x06,
	1026 - 161: jis0212<<14 | 0x06<<7 | 0x21,
	1027 - 161: jis0212<<14 | 0x06<<7 | 0x22,
	1028 - 161: jis0212<<14 | 0x06<<7 | 0x23,
	1029 - 161: jis0212<<14 | 0x06<<7 | 0x24,
	1030 - 161: jis0212<<14 | 0x06<<7 | 0x25,
	1031 - 161: jis0212<<14 | 0x06<<7 | 0x26,
	1032 - 161: jis0212<<14 | 0x06<<7 | 0x27,
	1033 - 161: jis0212<<14 | 0x06<<7 | 0x28,
	1034 - 161: jis0212<<14 | 0x06<<7 | 0x29,
	1035 - 161: jis0212<<14 | 0x06<<7 | 0x2A,
	1036 - 161: jis0212<<14 | 0x06<<7 | 0x2B,
	1038 - 161: jis0212<<14 | 0x06<<7 | 0x2C,
	1039 - 161: jis0212<<14 | 0x06<<7 | 0x2D,
	1040 - 161: jis0208<<14 | 0x06<<7 | 0x00,
	1041 - 161: jis0208<<14 | 0x06<<7 | 0x01,
	1042 - 161: jis0208<<14 | 0x06<<7 | 0x02,
	1043 - 161: jis0208<<14 | 0x06<<7 | 0x03,
	1044 - 161: jis0208<<14 | 0x06<<7 | 0x04,
	1045 - 161: jis0208<<14 | 0x06<<7 | 0x05,
	1046 - 161: jis0208<<14 | 0x06<<7 | 0x07,
	1047 - 161: jis0208<<14 | 0x06<<7 | 0x08,
	1048 - 161: jis0208<<14 | 0x06<<7 | 0x09,
	1049 - 161: jis0208<<14 | 0x06<<7 | 0x0A,
	1050 - 161: jis0208<<14 | 0x06<<7 | 0x0B,
	1051 - 161: jis0208<<14 | 0x06<<7 | 0x0C,
	1052 - 161: jis0208<<14 | 0x06<<7 | 0x0D,
	1053 - 161: jis0208<<14 | 0x06<<7 | 0x0E,
	1054 - 161: jis0208<<14 | 0x06<<7 | 0x0F,
	1055 - 161: jis0208<<14 | 0x06<<7 | 0x10,
	1056 - 161: jis0208<<14 | 0x06<<7 | 0x11,
	1057 - 161: jis0208<<14 | 0x06<<7 | 0x12,
	1058 - 161: jis0208<<14 | 0x06<<7 | 0x13,
	1059 - 161: jis0208<<14 | 0x06<<7 | 0x14,
	1060 - 161: jis0208<<14 | 0x06<<7 | 0x15,
	1061 - 161: jis0208<<14 | 0x06<<7 | 0x16,
	1062 - 161: jis0208<<14 | 0x06<<7 | 0x17,
	1063 - 161: jis0208<<14 | 0x06<<7 | 0x18,
	1064 - 161: jis0208<<14 | 0x06<<7 | 0x19,
	1065 - 161: jis0208<<14 | 0x06<<7 | 0x1A,
	1066 - 161: jis0208<<14 | 0x06<<7 | 0x1B,
	1067 - 161: jis0208<<14 | 0x06<<7 | 0x1C,
	1068 - 161: jis0208<<14 | 0x06<<7 | 0x1D,
	1069 - 161: jis0208<<14 | 0x06<<7 | 0x1E,
	1070 - 161: jis0208<<14 | 0x06<<7 | 0x1F,
	1071 - 161: jis0208<<14 | 0x06<<7 | 0x20,
	1072 - 161: jis0208<<14 | 0x06<<7 | 0x30,
	1073 - 161: jis0208<<14 | 0x06<<7 | 0x31,
	1074 - 161: jis0208<<14 | 0x06<<7 | 0x32,
	1075 - 161: jis0208<<14 | 0x06<<7 | 0x33,
	1076 - 161: jis0208<<14 | 0x06<<7 | 0x34,
	1077 - 161: jis0208<<14 | 0x06<<7 | 0x35,
	1078 - 161: jis0208<<14 | 0x06<<7 | 0x37,
	1079 - 161: jis0208<<14 | 0x06<<7 | 0x38,
	1080 - 161: jis0208<<14 | 0x06<<7 | 0x39,
	1081 - 161: jis0208<<14 | 0x06<<7 | 0x3A,
	1082 - 161: jis0208<<14 | 0x06<<7 | 0x3B,
	1083 - 161: jis0208<<14 | 0x06<<7 | 0x3C,
	1084 - 161: jis0208<<14 | 0x06<<7 | 0x3D,
	1085 - 161: jis0208<<14 | 0x06<<7 | 0x3E,
	1086 - 161: jis0208<<14 | 0x06<<7 | 0x3F,
	1087 - 161: jis0208<<14 | 0x06<<7 | 0x40,
	1088 - 161: jis0208<<14 | 0x06<<7 | 0x41,
	1089 - 161: jis0208<<14 | 0x06<<7 | 0x42,
	1090 - 161: jis0208<<14 | 0x06<<7 | 0x43,
	1091 - 161: jis0208<<14 | 0x06<<7 | 0x44,
	1092 - 161: jis0208<<14 | 0x06<<7 | 0x45,
	1093 - 161: jis0208<<14 | 0x06<<7 | 0x46,
	1094 - 161: jis0208<<14 | 0x06<<7 | 0x47,
	1095 - 161: jis0208<<14 | 0x06<<7 | 0x48,
	1096 - 161: jis0208<<14 | 0x06<<7 | 0x49,
	1097 - 161: jis0208<<14 | 0x06<<7 | 0x4A,
	1098 - 161: jis0208<<14 | 0x06<<7 | 0x4B,
	1099 - 161: jis0208<<14 | 0x06<<7 | 0x4C,
	1100 - 161: jis0208<<14 | 0x06<<7 | 0x4D,
	1101 - 161: jis0208<<14 | 0x06<<7 | 0x4E,
	1102 - 161: jis0208<<14 | 0x06<<7 | 0x4F,
	1103 - 161: jis0208<<14 | 0x06<<7 | 0x50,
	1105 - 161: jis0208<<14 | 0x06<<7 | 0x36,
	1106 - 161: jis0212<<14 | 0x06<<7 | 0x51,
	1107 - 161: jis0212<<14 | 0x06<<7 | 0x52,
	1108 - 161: jis0212<<14 | 0x06<<7 | 0x53,
	1109 - 161: jis0212<<14 | 0x06<<7 | 0x54,
	1110 - 161: jis0212<<14 | 0x06<<7 | 0x55,
	1111 - 161: jis0212<<14 | 0x06<<7 | 0x56,
	1112 - 161: jis0212<<14 | 0x06<<7 | 0x57,
	1113 - 161: jis0212<<14 | 0x06<<7 | 0x58,
	1114 - 161: jis0212<<14 | 0x06<<7 | 0x59,
	1115 - 161: jis0212<<14 | 0x06<<7 | 0x5A,
	1116 - 161: jis0212<<14 | 0x06<<7 | 0x5B,
	1118 - 161: jis0212<<14 | 0x06<<7 | 0x5C,
	1119 - 161: jis0212<<14 | 0x06<<7 | 0x5D,
}

const encode4Low, encode4High = 63785, 64046

var encode4 = [...]uint16{
	63785 - 63785: jis0208<<14 | 0x59<<7 | 0x25,
	63964 - 63785: jis0208<<14 | 0x5B<<7 | 0x2E,
	64014 - 63785: jis0208<<14 | 0x58<<7 | 0x33,
	64015 - 63785: jis0208<<14 | 0x58<<7 | 0x3E,
	64016 - 63785: jis0208<<14 | 0x58<<7 | 0x3F,
	64017 - 63785: jis0208<<14 | 0x58<<7 | 0x54,
	64018 - 63785: jis0208<<14 | 0x59<<7 | 0x1D,
	64019 - 63785: jis0208<<14 | 0x59<<7 | 0x2D,
	64020 - 63785: jis0208<<14 | 0x59<<7 | 0x2F,
	64021 - 63785: jis0208<<14 | 0x59<<7 | 0x5A,
	64022 - 63785: jis0208<<14 | 0x5A<<7 | 0x02,
	64023 - 63785: jis0208<<14 | 0x5A<<7 | 0x19,
	64024 - 63785: jis0208<<14 | 0x5A<<7 | 0x21,
	64025 - 63785: jis0208<<14 | 0x5A<<7 | 0x22,
	64026 - 63785: jis0208<<14 | 0x5A<<7 | 0x23,
	64027 - 63785: jis0208<<14 | 0x5A<<7 | 0x25,
	64028 - 63785: jis0208<<14 | 0x5A<<7 | 0x29,
	64029 - 63785: jis0208<<14 | 0x5A<<7 | 0x2C,
	64030 - 63785: jis0208<<14 | 0x5A<<7 | 0x35,
	64031 - 63785: jis0208<<14 | 0x5A<<7 | 0x40,
	64032 - 63785: jis0208<<14 | 0x5A<<7 | 0x42,
	64033 - 63785: jis0208<<14 | 0x5A<<7 | 0x43,
	64034 - 63785: jis0208<<14 | 0x5A<<7 | 0x4C,
	64035 - 63785: jis0208<<14 | 0x5A<<7 | 0x54,
	64036 - 63785: jis0208<<14 | 0x5A<<7 | 0x56,
	64037 - 63785: jis0208<<14 | 0x5A<<7 | 0x57,
	64038 - 63785: jis0208<<14 | 0x5A<<7 | 0x5A,
	64039 - 63785: jis0208<<14 | 0x5B<<7 | 0x18,
	64040 - 63785: jis0208<<14 | 0x5B<<7 | 0x1F,
	64041 - 63785: jis0208<<14 | 0x5B<<7 | 0x2F,
	64042 - 63785: jis0208<<14 | 0x5B<<7 | 0x3B,
	64043 - 63785: jis0208<<14 | 0x5B<<7 | 0x3C,
	64044 - 63785: jis0208<<14 | 0x5B<<7 | 0x3E,
	64045 - 63785: jis0208<<14 | 0x5B<<7 | 0x4B,
}

const encode5Low, encode5High = 65281, 65510

var encode5 = [...]uint16{
	65281 - 65281: jis0208<<14 | 0x00<<7 | 0x09,
	65282 - 65281: jis0208<<14 | 0x5B<<7 | 0x5D,
	65283 - 65281: jis0208<<14 | 0x00<<7 | 0x53,
	65284 - 65281: jis0208<<14 | 0x00<<7 | 0x4F,
	65285 - 65281: jis0208<<14 | 0x00<<7 | 0x52,
	65286 - 65281: jis0208<<14 | 0x00<<7 | 0x54,
	65287 - 65281: jis0208<<14 | 0x5B<<7 | 0x5C,
	65288 - 65281: jis0208<<14 | 0x00<<7 | 0x29,
	65289 - 65281: jis0208<<14 | 0x00<<7 | 0x2A,
	65290 - 65281: jis0208<<14 | 0x00<<7 | 0x55,
	65291 - 65281: jis0208<<14 | 0x00<<7 | 0x3B,
	65292 - 65281: jis0208<<14 | 0x00<<7 | 0x03,
	65293 - 65281: jis0208<<14 | 0x00<<7 | 0x3C,
	65294 - 65281: jis0208<<14 | 0x00<<7 | 0x04,
	65295 - 65281: jis0208<<14 | 0x00<<7 | 0x1E,
	65296 - 65281: jis0208<<14 | 0x02<<7 | 0x0F,
	65297 - 65281: jis0208<<14 | 0x02<<7 | 0x10,
	65298 - 65281: jis0208<<14 | 0x02<<7 | 0x11,
	65299 - 65281: jis0208<<14 | 0x02<<7 | 0x12,
	65300 - 65281: jis0208<<14 | 0x02<<7 | 0x13,
	65301 - 65281: jis0208<<14 | 0x02<<7 | 0x14,
	65302 - 65281: jis0208<<14 | 0x02<<7 | 0x15,
	65303 - 65281: jis0208<<14 | 0x02<<7 | 0x16,
	65304 - 65281: jis0208<<14 | 0x02<<7 | 0x17,
	65305 - 65281: jis0208<<14 | 0x02<<7 | 0x18,
	65306 - 65281: jis0208<<14 | 0x00<<7 | 0x06,
	65307 - 65281: jis0208<<14 | 0x00<<7 | 0x07,
	65308 - 65281: jis0208<<14 | 0x00<<7 | 0x42,
	65309 - 65281: jis0208<<14 | 0x00<<7 | 0x40,
	65310 - 65281: jis0208<<14 | 0x00<<7 | 0x43,
	65311 - 65281: jis0208<<14 | 0x00<<7 | 0x08,
	65312 - 65281: jis0208<<14 | 0x00<<7 | 0x56,
	65313 - 65281: jis0208<<14 | 0x02<<7 | 0x20,
	65314 - 65281: jis0208<<14 | 0x02<<7 | 0x21,
	65315 - 65281: jis0208<<14 | 0x02<<7 | 0x22,
	65316 - 65281: jis0208<<14 | 0x02<<7 | 0x23,
	65317 - 65281: jis0208<<14 | 0x02<<7 | 0x24,
	65318 - 65281: jis0208<<14 | 0x02<<7 | 0x25,
	65319 - 65281: jis0208<<14 | 0x02<<7 | 0x26,
	65320 - 65281: jis0208<<14 | 0x02<<7 | 0x27,
	65321 - 65281: jis0208<<14 | 0x02<<7 | 0x28,
	65322 - 65281: jis0208<<14 | 0x02<<7 | 0x29,
	65323 - 65281: jis0208<<14 | 0x02<<7 | 0x2A,
	65324 - 65281: jis0208<<14 | 0x02<<7 | 0x2B,
	65325 - 65281: jis0208<<14 | 0x02<<7 | 0x2C,
	65326 - 65281: jis0208<<14 | 0x02<<7 | 0x2D,
	65327 - 65281: jis0208<<14 | 0x02<<7 | 0x2E,
	65328 - 65281: jis0208<<14 | 0x02<<7 | 0x2F,
	65329 - 65281: jis0208<<14 | 0x02<<7 | 0x30,
	65330 - 65281: jis0208<<14 | 0x02<<7 | 0x31,
	65331 - 65281: jis0208<<14 | 0x02<<7 | 0x32,
	65332 - 65281: jis0208<<14 | 0x02<<7 | 0x33,
	65333 - 65281: jis0208<<14 | 0x02<<7 | 0x34,
	65334 - 65281: jis0208<<14 | 0x02<<7 | 0x35,
	65335 - 65281: jis0208<<14 | 0x02<<7 | 0x36,
	65336 - 65281: jis0208<<14 | 0x02<<7 | 0x37,
	65337 - 65281: jis0208<<14 | 0x02<<7 | 0x38,
	65338 - 65281: jis0208<<14 | 0x02<<7 | 0x39,
	65339 - 65281: jis0208<<14 | 0x00<<7 | 0x2D,
	65340 - 65281: jis0208<<14 | 0x00<<7 | 0x1F,
	65341 - 65281: jis0208<<14 | 0x00<<7 | 0x2E,
	65342 - 65281: jis0208<<14 | 0x00<<7 | 0x0F,
	65343 - 65281: jis0208<<14 | 0x00<<7 | 0x11,
	65344 - 65281: jis0208<<14 | 0x00<<7 | 0x0D,
	65345 - 65281: jis0208<<14 | 0x02<<7 | 0x40,
	65346 - 65281: jis0208<<14 | 0x02<<7 | 0x41,
	65347 - 65281: jis0208<<14 | 0x02<<7 | 0x42,
	65348 - 65281: jis0208<<14 | 0x02<<7 | 0x43,
	65349 - 65281: jis0208<<14 | 0x02<<7 | 0x44,
	65350 - 65281: jis0208<<14 | 0x02<<7 | 0x45,
	65351 - 65281: jis0208<<14 | 0x02<<7 | 0x46,
	65352 - 65281: jis0208<<14 | 0x02<<7 | 0x47,
	65353 - 65281: jis0208<<14 | 0x02<<7 | 0x48,
	65354 - 65281: jis0208<<14 | 0x02<<7 | 0x49,
	65355 - 65281: jis0208<<14 | 0x02<<7 | 0x4A,
	65356 - 65281: jis0208<<14 | 0x02<<7 | 0x4B,
	65357 - 65281: jis0208<<14 | 0x02<<7 | 0x4C,
	65358 - 65281: jis0208<<14 | 0x02<<7 | 0x4D,
	65359 - 65281: jis0208<<14 | 0x02<<7 | 0x4E,
	65360 - 65281: jis0208<<14 | 0x02<<7 | 0x4F,
	65361 - 65281: jis0208<<14 | 0x02<<7 | 0x50,
	65362 - 65281: jis0208<<14 | 0x02<<7 | 0x51,
	65363 - 65281: jis0208<<14 | 0x02<<7 | 0x52,
	65364 - 65281: jis0208<<14 | 0x02<<7 | 0x53,
	65365 - 65281: jis0208<<14 | 0x02<<7 | 0x54,
	65366 - 65281: jis0208<<14 | 0x02<<7 | 0x55,
	65367 - 65281: jis0208<<14 | 0x02<<7 | 0x56,
	65368 - 65281: jis0208<<14 | 0x02<<7 | 0x57,
	65369 - 65281: jis0208<<14 | 0x02<<7 | 0x58,
	65370 - 65281: jis0208<<14 | 0x02<<7 | 0x59,
	65371 - 65281: jis0208<<14 | 0x00<<7 | 0x2F,
	65372 - 65281: jis0208<<14 | 0x00<<7 | 0x22,
	65373 - 65281: jis0208<<14 | 0x00<<7 | 0x30,
	65374 - 65281: jis0208<<14 | 0x00<<7 | 0x20,
	65504 - 65281: jis0208<<14 | 0x00<<7 | 0x50,
	65505 - 65281: jis0208<<14 | 0x00<<7 | 0x51,
	65506 - 65281: jis0208<<14 | 0x01<<7 | 0x2B,
	65507 - 65281: jis0208<<14 | 0x00<<7 | 0x10,
	65508 - 65281: jis0208<<14 | 0x5B<<7 | 0x5B,
	65509 - 65281: jis0208<<14 | 0x00<<7 | 0x4E,
}
