// generated by go run maketables.go; DO NOT EDIT

// Package simplifiedchinese provides Simplified Chinese encodings such as GBK.
package simplifiedchinese

// gb18030 is the table from http://encoding.spec.whatwg.org/index-gb18030.txt
var gb18030 = [...][2]uint16{
	{0x0000, 0x0080},
	{0x0024, 0x00a5},
	{0x0026, 0x00a9},
	{0x002d, 0x00b2},
	{0x0032, 0x00b8},
	{0x0051, 0x00d8},
	{0x0059, 0x00e2},
	{0x005f, 0x00eb},
	{0x0060, 0x00ee},
	{0x0064, 0x00f4},
	{0x0067, 0x00f8},
	{0x0068, 0x00fb},
	{0x0069, 0x00fd},
	{0x006d, 0x0102},
	{0x007e, 0x0114},
	{0x0085, 0x011c},
	{0x0094, 0x012c},
	{0x00ac, 0x0145},
	{0x00af, 0x0149},
	{0x00b3, 0x014e},
	{0x00d0, 0x016c},
	{0x0132, 0x01cf},
	{0x0133, 0x01d1},
	{0x0134, 0x01d3},
	{0x0135, 0x01d5},
	{0x0136, 0x01d7},
	{0x0137, 0x01d9},
	{0x0138, 0x01db},
	{0x0139, 0x01dd},
	{0x0155, 0x01fa},
	{0x01ac, 0x0252},
	{0x01bb, 0x0262},
	{0x0220, 0x02c8},
	{0x0221, 0x02cc},
	{0x022e, 0x02da},
	{0x02e5, 0x03a2},
	{0x02e6, 0x03aa},
	{0x02ed, 0x03c2},
	{0x02ee, 0x03ca},
	{0x0325, 0x0402},
	{0x0333, 0x0450},
	{0x0334, 0x0452},
	{0x1ef2, 0x2011},
	{0x1ef4, 0x2017},
	{0x1ef5, 0x201a},
	{0x1ef7, 0x201e},
	{0x1efe, 0x2027},
	{0x1f07, 0x2031},
	{0x1f08, 0x2034},
	{0x1f09, 0x2036},
	{0x1f0e, 0x203c},
	{0x1f7e, 0x20ad},
	{0x1fd4, 0x2104},
	{0x1fd5, 0x2106},
	{0x1fd8, 0x210a},
	{0x1fe4, 0x2117},
	{0x1fee, 0x2122},
	{0x202c, 0x216c},
	{0x2030, 0x217a},
	{0x2046, 0x2194},
	{0x2048, 0x219a},
	{0x20b6, 0x2209},
	{0x20bc, 0x2210},
	{0x20bd, 0x2212},
	{0x20c0, 0x2216},
	{0x20c4, 0x221b},
	{0x20c6, 0x2221},
	{0x20c8, 0x2224},
	{0x20c9, 0x2226},
	{0x20ca, 0x222c},
	{0x20cc, 0x222f},
	{0x20d1, 0x2238},
	{0x20d6, 0x223e},
	{0x20e0, 0x2249},
	{0x20e3, 0x224d},
	{0x20e8, 0x2253},
	{0x20f5, 0x2262},
	{0x20f7, 0x2268},
	{0x20fd, 0x2270},
	{0x2122, 0x2296},
	{0x2125, 0x229a},
	{0x2130, 0x22a6},
	{0x2149, 0x22c0},
	{0x219b, 0x2313},
	{0x22e8, 0x246a},
	{0x22f2, 0x249c},
	{0x2356, 0x254c},
	{0x235a, 0x2574},
	{0x2367, 0x2590},
	{0x236a, 0x2596},
	{0x2374, 0x25a2},
	{0x2384, 0x25b4},
	{0x238c, 0x25be},
	{0x2394, 0x25c8},
	{0x2397, 0x25cc},
	{0x2399, 0x25d0},
	{0x23ab, 0x25e6},
	{0x23ca, 0x2607},
	{0x23cc, 0x260a},
	{0x2402, 0x2641},
	{0x2403, 0x2643},
	{0x2c41, 0x2e82},
	{0x2c43, 0x2e85},
	{0x2c46, 0x2e89},
	{0x2c48, 0x2e8d},
	{0x2c52, 0x2e98},
	{0x2c61, 0x2ea8},
	{0x2c63, 0x2eab},
	{0x2c66, 0x2eaf},
	{0x2c6a, 0x2eb4},
	{0x2c6c, 0x2eb8},
	{0x2c6f, 0x2ebc},
	{0x2c7d, 0x2ecb},
	{0x2da2, 0x2ffc},
	{0x2da6, 0x3004},
	{0x2da7, 0x3018},
	{0x2dac, 0x301f},
	{0x2dae, 0x302a},
	{0x2dc2, 0x303f},
	{0x2dc4, 0x3094},
	{0x2dcb, 0x309f},
	{0x2dcd, 0x30f7},
	{0x2dd2, 0x30ff},
	{0x2dd8, 0x312a},
	{0x2ece, 0x322a},
	{0x2ed5, 0x3232},
	{0x2f46, 0x32a4},
	{0x3030, 0x3390},
	{0x303c, 0x339f},
	{0x303e, 0x33a2},
	{0x3060, 0x33c5},
	{0x3069, 0x33cf},
	{0x306b, 0x33d3},
	{0x306d, 0x33d6},
	{0x30de, 0x3448},
	{0x3109, 0x3474},
	{0x3233, 0x359f},
	{0x32a2, 0x360f},
	{0x32ad, 0x361b},
	{0x35aa, 0x3919},
	{0x35ff, 0x396f},
	{0x365f, 0x39d1},
	{0x366d, 0x39e0},
	{0x3700, 0x3a74},
	{0x37da, 0x3b4f},
	{0x38f9, 0x3c6f},
	{0x396a, 0x3ce1},
	{0x3cdf, 0x4057},
	{0x3de7, 0x4160},
	{0x3fbe, 0x4338},
	{0x4032, 0x43ad},
	{0x4036, 0x43b2},
	{0x4061, 0x43de},
	{0x4159, 0x44d7},
	{0x42ce, 0x464d},
	{0x42e2, 0x4662},
	{0x43a3, 0x4724},
	{0x43a8, 0x472a},
	{0x43fa, 0x477d},
	{0x440a, 0x478e},
	{0x45c3, 0x4948},
	{0x45f5, 0x497b},
	{0x45f7, 0x497e},
	{0x45fb, 0x4984},
	{0x45fc, 0x4987},
	{0x4610, 0x499c},
	{0x4613, 0x49a0},
	{0x4629, 0x49b8},
	{0x48e8, 0x4c78},
	{0x490f, 0x4ca4},
	{0x497e, 0x4d1a},
	{0x4a12, 0x4daf},
	{0x4a63, 0x9fa6},
	{0x82bd, 0xe76c},
	{0x82be, 0xe7c8},
	{0x82bf, 0xe7e7},
	{0x82cc, 0xe815},
	{0x82cd, 0xe819},
	{0x82d2, 0xe81f},
	{0x82d9, 0xe827},
	{0x82dd, 0xe82d},
	{0x82e1, 0xe833},
	{0x82e9, 0xe83c},
	{0x82f0, 0xe844},
	{0x8300, 0xe856},
	{0x830e, 0xe865},
	{0x93d5, 0xf92d},
	{0x9421, 0xf97a},
	{0x943c, 0xf996},
	{0x948d, 0xf9e8},
	{0x9496, 0xf9f2},
	{0x94b0, 0xfa10},
	{0x94b1, 0xfa12},
	{0x94b2, 0xfa15},
	{0x94b5, 0xfa19},
	{0x94bb, 0xfa22},
	{0x94bc, 0xfa25},
	{0x94be, 0xfa2a},
	{0x98c4, 0xfe32},
	{0x98c5, 0xfe45},
	{0x98c9, 0xfe53},
	{0x98ca, 0xfe58},
	{0x98cb, 0xfe67},
	{0x98cc, 0xfe6c},
	{0x9961, 0xff5f},
	{0x99e2, 0xffe6},
}

// decode is the decoding table from GBK code to Unicode.
// It is defined at http://encoding.spec.whatwg.org/index-gbk.txt
var decode = [...]uint16{
	0:     0x4E02,
	1:     0x4E04,
	2:     0x4E05,
	3:     0x4E06,
	4:     0x4E0F,
	5:     0x4E12,
	6:     0x4E17,
	7:     0x4E1F,
	8:     0x4E20,
	9:     0x4E21,
	10:    0x4E23,
	11:    0x4E26,
	12:    0x4E29,
	13:    0x4E2E,
	14:    0x4E2F,
	15:    0x4E31,
	16:    0x4E33,
	17:    0x4E35,
	18:    0x4E37,
	19:    0x4E3C,
	20:    0x4E40,
	21:    0x4E41,
	22:    0x4E42,
	23:    0x4E44,
	24:    0x4E46,
	25:    0x4E4A,
	26:    0x4E51,
	27:    0x4E55,
	28:    0x4E57,
	29:    0x4E5A,
	30:    0x4E5B,
	31:    0x4E62,
	32:    0x4E63,
	33:    0x4E64,
	34:    0x4E65,
	35:    0x4E67,
	36:    0x4E68,
	37:    0x4E6A,
	38:    0x4E6B,
	39:    0x4E6C,
	40:    0x4E6D,
	41:    0x4E6E,
	42:    0x4E6F,
	43:    0x4E72,
	44:    0x4E74,
	45:    0x4E75,
	46:    0x4E76,
	47:    0x4E77,
	48:    0x4E78,
	49:    0x4E79,
	50:    0x4E7A,
	51:    0x4E7B,
	52:    0x4E7C,
	53:    0x4E7D,
	54:    0x4E7F,
	55:    0x4E80,
	56:    0x4E81,
	57:    0x4E82,
	58:    0x4E83,
	59:    0x4E84,
	60:    0x4E85,
	61:    0x4E87,
	62:    0x4E8A,
	63:    0x4E90,
	64:    0x4E96,
	65:    0x4E97,
	66:    0x4E99,
	67:    0x4E9C,
	68:    0x4E9D,
	69:    0x4E9E,
	70:    0x4EA3,
	71:    0x4EAA,
	72:    0x4EAF,
	73:    0x4EB0,
	74:    0x4EB1,
	75:    0x4EB4,
	76:    0x4EB6,
	77:    0x4EB7,
	78:    0x4EB8,
	79:    0x4EB9,
	80:    0x4EBC,
	81:    0x4EBD,
	82:    0x4EBE,
	83:    0x4EC8,
	84:    0x4ECC,
	85:    0x4ECF,
	86:    0x4ED0,
	87:    0x4ED2,
	88:    0x4EDA,
	89:    0x4EDB,
	90:    0x4EDC,
	91:    0x4EE0,
	92:    0x4EE2,
	93:    0x4EE6,
	94:    0x4EE7,
	95:    0x4EE9,
	96:    0x4EED,
	97:    0x4EEE,
	98:    0x4EEF,
	99:    0x4EF1,
	100:   0x4EF4,
	101:   0x4EF8,
	102:   0x4EF9,
	103:   0x4EFA,
	104:   0x4EFC,
	105:   0x4EFE,
	106:   0x4F00,
	107:   0x4F02,
	108:   0x4F03,
	109:   0x4F04,
	110:   0x4F05,
	111:   0x4F06,
	112:   0x4F07,
	113:   0x4F08,
	114:   0x4F0B,
	115:   0x4F0C,
	116:   0x4F12,
	117:   0x4F13,
	118:   0x4F14,
	119:   0x4F15,
	120:   0x4F16,
	121:   0x4F1C,
	122:   0x4F1D,
	123:   0x4F21,
	124:   0x4F23,
	125:   0x4F28,
	126:   0x4F29,
	127:   0x4F2C,
	128:   0x4F2D,
	129:   0x4F2E,
	130:   0x4F31,
	131:   0x4F33,
	132:   0x4F35,
	133:   0x4F37,
	134:   0x4F39,
	135:   0x4F3B,
	136:   0x4F3E,
	137:   0x4F3F,
	138:   0x4F40,
	139:   0x4F41,
	140:   0x4F42,
	141:   0x4F44,
	142:   0x4F45,
	143:   0x4F47,
	144:   0x4F48,
	145:   0x4F49,
	146:   0x4F4A,
	147:   0x4F4B,
	148:   0x4F4C,
	149:   0x4F52,
	150:   0x4F54,
	151:   0x4F56,
	152:   0x4F61,
	153:   0x4F62,
	154:   0x4F66,
	155:   0x4F68,
	156:   0x4F6A,
	157:   0x4F6B,
	158:   0x4F6D,
	159:   0x4F6E,
	160:   0x4F71,
	161:   0x4F72,
	162:   0x4F75,
	163:   0x4F77,
	164:   0x4F78,
	165:   0x4F79,
	166:   0x4F7A,
	167:   0x4F7D,
	168:   0x4F80,
	169:   0x4F81,
	170:   0x4F82,
	171:   0x4F85,
	172:   0x4F86,
	173:   0x4F87,
	174:   0x4F8A,
	175:   0x4F8C,
	176:   0x4F8E,
	177:   0x4F90,
	178:   0x4F92,
	179:   0x4F93,
	180:   0x4F95,
	181:   0x4F96,
	182:   0x4F98,
	183:   0x4F99,
	184:   0x4F9A,
	185:   0x4F9C,
	186:   0x4F9E,
	187:   0x4F9F,
	188:   0x4FA1,
	189:   0x4FA2,
	190:   0x4FA4,
	191:   0x4FAB,
	192:   0x4FAD,
	193:   0x4FB0,
	194:   0x4FB1,
	195:   0x4FB2,
	196:   0x4FB3,
	197:   0x4FB4,
	198:   0x4FB6,
	199:   0x4FB7,
	200:   0x4FB8,
	201:   0x4FB9,
	202:   0x4FBA,
	203:   0x4FBB,
	204:   0x4FBC,
	205:   0x4FBD,
	206:   0x4FBE,
	207:   0x4FC0,
	208:   0x4FC1,
	209:   0x4FC2,
	210:   0x4FC6,
	211:   0x4FC7,
	212:   0x4FC8,
	213:   0x4FC9,
	214:   0x4FCB,
	215:   0x4FCC,
	216:   0x4FCD,
	217:   0x4FD2,
	218:   0x4FD3,
	219:   0x4FD4,
	220:   0x4FD5,
	221:   0x4FD6,
	222:   0x4FD9,
	223:   0x4FDB,
	224:   0x4FE0,
	225:   0x4FE2,
	226:   0x4FE4,
	227:   0x4FE5,
	228:   0x4FE7,
	229:   0x4FEB,
	230:   0x4FEC,
	231:   0x4FF0,
	232:   0x4FF2,
	233:   0x4FF4,
	234:   0x4FF5,
	235:   0x4FF6,
	236:   0x4FF7,
	237:   0x4FF9,
	238:   0x4FFB,
	239:   0x4FFC,
	240:   0x4FFD,
	241:   0x4FFF,
	242:   0x5000,
	243:   0x5001,
	244:   0x5002,
	245:   0x5003,
	246:   0x5004,
	247:   0x5005,
	248:   0x5006,
	249:   0x5007,
	250:   0x5008,
	251:   0x5009,
	252:   0x500A,
	253:   0x500B,
	254:   0x500E,
	255:   0x5010,
	256:   0x5011,
	257:   0x5013,
	258:   0x5015,
	259:   0x5016,
	260:   0x5017,
	261:   0x501B,
	262:   0x501D,
	263:   0x501E,
	264:   0x5020,
	265:   0x5022,
	266:   0x5023,
	267:   0x5024,
	268:   0x5027,
	269:   0x502B,
	270:   0x502F,
	271:   0x5030,
	272:   0x5031,
	273:   0x5032,
	274:   0x5033,
	275:   0x5034,
	276:   0x5035,
	277:   0x5036,
	278:   0x5037,
	279:   0x5038,
	280:   0x5039,
	281:   0x503B,
	282:   0x503D,
	283:   0x503F,
	284:   0x5040,
	285:   0x5041,
	286:   0x5042,
	287:   0x5044,
	288:   0x5045,
	289:   0x5046,
	290:   0x5049,
	291:   0x504A,
	292:   0x504B,
	293:   0x504D,
	294:   0x5050,
	295:   0x5051,
	296:   0x5052,
	297:   0x5053,
	298:   0x5054,
	299:   0x5056,
	300:   0x5057,
	301:   0x5058,
	302:   0x5059,
	303:   0x505B,
	304:   0x505D,
	305:   0x505E,
	306:   0x505F,
	307:   0x5060,
	308:   0x5061,
	309:   0x5062,
	310:   0x5063,
	311:   0x5064,
	312:   0x5066,
	313:   0x5067,
	314:   0x5068,
	315:   0x5069,
	316:   0x506A,
	317:   0x506B,
	318:   0x506D,
	319:   0x506E,
	320:   0x506F,
	321:   0x5070,
	322:   0x5071,
	323:   0x5072,
	324:   0x5073,
	325:   0x5074,
	326:   0x5075,
	327:   0x5078,
	328:   0x5079,
	329:   0x507A,
	330:   0x507C,
	331:   0x507D,
	332:   0x5081,
	333:   0x5082,
	334:   0x5083,
	335:   0x5084,
	336:   0x5086,
	337:   0x5087,
	338:   0x5089,
	339:   0x508A,
	340:   0x508B,
	341:   0x508C,
	342:   0x508E,
	343:   0x508F,
	344:   0x5090,
	345:   0x5091,
	346:   0x5092,
	347:   0x5093,
	348:   0x5094,
	349:   0x5095,
	350:   0x5096,
	351:   0x5097,
	352:   0x5098,
	353:   0x5099,
	354:   0x509A,
	355:   0x509B,
	356:   0x509C,
	357:   0x509D,
	358:   0x509E,
	359:   0x509F,
	360:   0x50A0,
	361:   0x50A1,
	362:   0x50A2,
	363:   0x50A4,
	364:   0x50A6,
	365:   0x50AA,
	366:   0x50AB,
	367:   0x50AD,
	368:   0x50AE,
	369:   0x50AF,
	370:   0x50B0,
	371:   0x50B1,
	372:   0x50B3,
	373:   0x50B4,
	374:   0x50B5,
	375:   0x50B6,
	376:   0x50B7,
	377:   0x50B8,
	378:   0x50B9,
	379:   0x50BC,
	380:   0x50BD,
	381:   0x50BE,
	382:   0x50BF,
	383:   0x50C0,
	384:   0x50C1,
	385:   0x50C2,
	386:   0x50C3,
	387:   0x50C4,
	388:   0x50C5,
	389:   0x50C6,
	390:   0x50C7,
	391:   0x50C8,
	392:   0x50C9,
	393:   0x50CA,
	394:   0x50CB,
	395:   0x50CC,
	396:   0x50CD,
	397:   0x50CE,
	398:   0x50D0,
	399:   0x50D1,
	400:   0x50D2,
	401:   0x50D3,
	402:   0x50D4,
	403:   0x50D5,
	404:   0x50D7,
	405:   0x50D8,
	406:   0x50D9,
	407:   0x50DB,
	408:   0x50DC,
	409:   0x50DD,
	410:   0x50DE,
	411:   0x50DF,
	412:   0x50E0,
	413:   0x50E1,
	414:   0x50E2,
	415:   0x50E3,
	416:   0x50E4,
	417:   0x50E5,
	418:   0x50E8,
	419:   0x50E9,
	420:   0x50EA,
	421:   0x50EB,
	422:   0x50EF,
	423:   0x50F0,
	424:   0x50F1,
	425:   0x50F2,
	426:   0x50F4,
	427:   0x50F6,
	428:   0x50F7,
	429:   0x50F8,
	430:   0x50F9,
	431:   0x50FA,
	432:   0x50FC,
	433:   0x50FD,
	434:   0x50FE,
	435:   0x50FF,
	436:   0x5100,
	437:   0x5101,
	438:   0x5102,
	439:   0x5103,
	440:   0x5104,
	441:   0x5105,
	442:   0x5108,
	443:   0x5109,
	444:   0x510A,
	445:   0x510C,
	446:   0x510D,
	447:   0x510E,
	448:   0x510F,
	449:   0x5110,
	450:   0x5111,
	451:   0x5113,
	452:   0x5114,
	453:   0x5115,
	454:   0x5116,
	455:   0x5117,
	456:   0x5118,
	457:   0x5119,
	458:   0x511A,
	459:   0x511B,
	460:   0x511C,
	461:   0x511D,
	462:   0x511E,
	463:   0x511F,
	464:   0x5120,
	465:   0x5122,
	466:   0x5123,
	467:   0x5124,
	468:   0x5125,
	469:   0x5126,
	470:   0x5127,
	471:   0x5128,
	472:   0x5129,
	473:   0x512A,
	474:   0x512B,
	475:   0x512C,
	476:   0x512D,
	477:   0x512E,
	478:   0x512F,
	479:   0x5130,
	480:   0x5131,
	481:   0x5132,
	482:   0x5133,
	483:   0x5134,
	484:   0x5135,
	485:   0x5136,
	486:   0x5137,
	487:   0x5138,
	488:   0x5139,
	489:   0x513A,
	490:   0x513B,
	491:   0x513C,
	492:   0x513D,
	493:   0x513E,
	494:   0x5142,
	495:   0x5147,
	496:   0x514A,
	497:   0x514C,
	498:   0x514E,
	499:   0x514F,
	500:   0x5150,
	501:   0x5152,
	502:   0x5153,
	503:   0x5157,
	504:   0x5158,
	505:   0x5159,
	506:   0x515B,
	507:   0x515D,
	508:   0x515E,
	509:   0x515F,
	510:   0x5160,
	511:   0x5161,
	512:   0x5163,
	513:   0x5164,
	514:   0x5166,
	515:   0x5167,
	516:   0x5169,
	517:   0x516A,
	518:   0x516F,
	519:   0x5172,
	520:   0x517A,
	521:   0x517E,
	522:   0x517F,
	523:   0x5183,
	524:   0x5184,
	525:   0x5186,
	526:   0x5187,
	527:   0x518A,
	528:   0x518B,
	529:   0x518E,
	530:   0x518F,
	531:   0x5190,
	532:   0x5191,
	533:   0x5193,
	534:   0x5194,
	535:   0x5198,
	536:   0x519A,
	537:   0x519D,
	538:   0x519E,
	539:   0x519F,
	540:   0x51A1,
	541:   0x51A3,
	542:   0x51A6,
	543:   0x51A7,
	544:   0x51A8,
	545:   0x51A9,
	546:   0x51AA,
	547:   0x51AD,
	548:   0x51AE,
	549:   0x51B4,
	550:   0x51B8,
	551:   0x51B9,
	552:   0x51BA,
	553:   0x51BE,
	554:   0x51BF,
	555:   0x51C1,
	556:   0x51C2,
	557:   0x51C3,
	558:   0x51C5,
	559:   0x51C8,
	560:   0x51CA,
	561:   0x51CD,
	562:   0x51CE,
	563:   0x51D0,
	564:   0x51D2,
	565:   0x51D3,
	566:   0x51D4,
	567:   0x51D5,
	568:   0x51D6,
	569:   0x51D7,
	570:   0x51D8,
	571:   0x51D9,
	572:   0x51DA,
	573:   0x51DC,
	574:   0x51DE,
	575:   0x51DF,
	576:   0x51E2,
	577:   0x51E3,
	578:   0x51E5,
	579:   0x51E6,
	580:   0x51E7,
	581:   0x51E8,
	582:   0x51E9,
	583:   0x51EA,
	584:   0x51EC,
	585:   0x51EE,
	586:   0x51F1,
	587:   0x51F2,
	588:   0x51F4,
	589:   0x51F7,
	590:   0x51FE,
	591:   0x5204,
	592:   0x5205,
	593:   0x5209,
	594:   0x520B,
	595:   0x520C,
	596:   0x520F,
	597:   0x5210,
	598:   0x5213,
	599:   0x5214,
	600:   0x5215,
	601:   0x521C,
	602:   0x521E,
	603:   0x521F,
	604:   0x5221,
	605:   0x5222,
	606:   0x5223,
	607:   0x5225,
	608:   0x5226,
	609:   0x5227,
	610:   0x522A,
	611:   0x522C,
	612:   0x522F,
	613:   0x5231,
	614:   0x5232,
	615:   0x5234,
	616:   0x5235,
	617:   0x523C,
	618:   0x523E,
	619:   0x5244,
	620:   0x5245,
	621:   0x5246,
	622:   0x5247,
	623:   0x5248,
	624:   0x5249,
	625:   0x524B,
	626:   0x524E,
	627:   0x524F,
	628:   0x5252,
	629:   0x5253,
	630:   0x5255,
	631:   0x5257,
	632:   0x5258,
	633:   0x5259,
	634:   0x525A,
	635:   0x525B,
	636:   0x525D,
	637:   0x525F,
	638:   0x5260,
	639:   0x5262,
	640:   0x5263,
	641:   0x5264,
	642:   0x5266,
	643:   0x5268,
	644:   0x526B,
	645:   0x526C,
	646:   0x526D,
	647:   0x526E,
	648:   0x5270,
	649:   0x5271,
	650:   0x5273,
	651:   0x5274,
	652:   0x5275,
	653:   0x5276,
	654:   0x5277,
	655:   0x5278,
	656:   0x5279,
	657:   0x527A,
	658:   0x527B,
	659:   0x527C,
	660:   0x527E,
	661:   0x5280,
	662:   0x5283,
	663:   0x5284,
	664:   0x5285,
	665:   0x5286,
	666:   0x5287,
	667:   0x5289,
	668:   0x528A,
	669:   0x528B,
	670:   0x528C,
	671:   0x528D,
	672:   0x528E,
	673:   0x528F,
	674:   0x5291,
	675:   0x5292,
	676:   0x5294,
	677:   0x5295,
	678:   0x5296,
	679:   0x5297,
	680:   0x5298,
	681:   0x5299,
	682:   0x529A,
	683:   0x529C,
	684:   0x52A4,
	685:   0x52A5,
	686:   0x52A6,
	687:   0x52A7,
	688:   0x52AE,
	689:   0x52AF,
	690:   0x52B0,
	691:   0x52B4,
	692:   0x52B5,
	693:   0x52B6,
	694:   0x52B7,
	695:   0x52B8,
	696:   0x52B9,
	697:   0x52BA,
	698:   0x52BB,
	699:   0x52BC,
	700:   0x52BD,
	701:   0x52C0,
	702:   0x52C1,
	703:   0x52C2,
	704:   0x52C4,
	705:   0x52C5,
	706:   0x52C6,
	707:   0x52C8,
	708:   0x52CA,
	709:   0x52CC,
	710:   0x52CD,
	711:   0x52CE,
	712:   0x52CF,
	713:   0x52D1,
	714:   0x52D3,
	715:   0x52D4,
	716:   0x52D5,
	717:   0x52D7,
	718:   0x52D9,
	719:   0x52DA,
	720:   0x52DB,
	721:   0x52DC,
	722:   0x52DD,
	723:   0x52DE,
	724:   0x52E0,
	725:   0x52E1,
	726:   0x52E2,
	727:   0x52E3,
	728:   0x52E5,
	729:   0x52E6,
	730:   0x52E7,
	731:   0x52E8,
	732:   0x52E9,
	733:   0x52EA,
	734:   0x52EB,
	735:   0x52EC,
	736:   0x52ED,
	737:   0x52EE,
	738:   0x52EF,
	739:   0x52F1,
	740:   0x52F2,
	741:   0x52F3,
	742:   0x52F4,
	743:   0x52F5,
	744:   0x52F6,
	745:   0x52F7,
	746:   0x52F8,
	747:   0x52FB,
	748:   0x52FC,
	749:   0x52FD,
	750:   0x5301,
	751:   0x5302,
	752:   0x5303,
	753:   0x5304,
	754:   0x5307,
	755:   0x5309,
	756:   0x530A,
	757:   0x530B,
	758:   0x530C,
	759:   0x530E,
	760:   0x5311,
	761:   0x5312,
	762:   0x5313,
	763:   0x5314,
	764:   0x5318,
	765:   0x531B,
	766:   0x531C,
	767:   0x531E,
	768:   0x531F,
	769:   0x5322,
	770:   0x5324,
	771:   0x5325,
	772:   0x5327,
	773:   0x5328,
	774:   0x5329,
	775:   0x532B,
	776:   0x532C,
	777:   0x532D,
	778:   0x532F,
	779:   0x5330,
	780:   0x5331,
	781:   0x5332,
	782:   0x5333,
	783:   0x5334,
	784:   0x5335,
	785:   0x5336,
	786:   0x5337,
	787:   0x5338,
	788:   0x533C,
	789:   0x533D,
	790:   0x5340,
	791:   0x5342,
	792:   0x5344,
	793:   0x5346,
	794:   0x534B,
	795:   0x534C,
	796:   0x534D,
	797:   0x5350,
	798:   0x5354,
	799:   0x5358,
	800:   0x5359,
	801:   0x535B,
	802:   0x535D,
	803:   0x5365,
	804:   0x5368,
	805:   0x536A,
	806:   0x536C,
	807:   0x536D,
	808:   0x5372,
	809:   0x5376,
	810:   0x5379,
	811:   0x537B,
	812:   0x537C,
	813:   0x537D,
	814:   0x537E,
	815:   0x5380,
	816:   0x5381,
	817:   0x5383,
	818:   0x5387,
	819:   0x5388,
	820:   0x538A,
	821:   0x538E,
	822:   0x538F,
	823:   0x5390,
	824:   0x5391,
	825:   0x5392,
	826:   0x5393,
	827:   0x5394,
	828:   0x5396,
	829:   0x5397,
	830:   0x5399,
	831:   0x539B,
	832:   0x539C,
	833:   0x539E,
	834:   0x53A0,
	835:   0x53A1,
	836:   0x53A4,
	837:   0x53A7,
	838:   0x53AA,
	839:   0x53AB,
	840:   0x53AC,
	841:   0x53AD,
	842:   0x53AF,
	843:   0x53B0,
	844:   0x53B1,
	845:   0x53B2,
	846:   0x53B3,
	847:   0x53B4,
	848:   0x53B5,
	849:   0x53B7,
	850:   0x53B8,
	851:   0x53B9,
	852:   0x53BA,
	853:   0x53BC,
	854:   0x53BD,
	855:   0x53BE,
	856:   0x53C0,
	857:   0x53C3,
	858:   0x53C4,
	859:   0x53C5,
	860:   0x53C6,
	861:   0x53C7,
	862:   0x53CE,
	863:   0x53CF,
	864:   0x53D0,
	865:   0x53D2,
	866:   0x53D3,
	867:   0x53D5,
	868:   0x53DA,
	869:   0x53DC,
	870:   0x53DD,
	871:   0x53DE,
	872:   0x53E1,
	873:   0x53E2,
	874:   0x53E7,
	875:   0x53F4,
	876:   0x53FA,
	877:   0x53FE,
	878:   0x53FF,
	879:   0x5400,
	880:   0x5402,
	881:   0x5405,
	882:   0x5407,
	883:   0x540B,
	884:   0x5414,
	885:   0x5418,
	886:   0x5419,
	887:   0x541A,
	888:   0x541C,
	889:   0x5422,
	890:   0x5424,
	891:   0x5425,
	892:   0x542A,
	893:   0x5430,
	894:   0x5433,
	895:   0x5436,
	896:   0x5437,
	897:   0x543A,
	898:   0x543D,
	899:   0x543F,
	900:   0x5441,
	901:   0x5442,
	902:   0x5444,
	903:   0x5445,
	904:   0x5447,
	905:   0x5449,
	906:   0x544C,
	907:   0x544D,
	908:   0x544E,
	909:   0x544F,
	910:   0x5451,
	911:   0x545A,
	912:   0x545D,
	913:   0x545E,
	914:   0x545F,
	915:   0x5460,
	916:   0x5461,
	917:   0x5463,
	918:   0x5465,
	919:   0x5467,
	920:   0x5469,
	921:   0x546A,
	922:   0x546B,
	923:   0x546C,
	924:   0x546D,
	925:   0x546E,
	926:   0x546F,
	927:   0x5470,
	928:   0x5474,
	929:   0x5479,
	930:   0x547A,
	931:   0x547E,
	932:   0x547F,
	933:   0x5481,
	934:   0x5483,
	935:   0x5485,
	936:   0x5487,
	937:   0x5488,
	938:   0x5489,
	939:   0x548A,
	940:   0x548D,
	941:   0x5491,
	942:   0x5493,
	943:   0x5497,
	944:   0x5498,
	945:   0x549C,
	946:   0x549E,
	947:   0x549F,
	948:   0x54A0,
	949:   0x54A1,
	950:   0x54A2,
	951:   0x54A5,
	952:   0x54AE,
	953:   0x54B0,
	954:   0x54B2,
	955:   0x54B5,
	956:   0x54B6,
	957:   0x54B7,
	958:   0x54B9,
	959:   0x54BA,
	960:   0x54BC,
	961:   0x54BE,
	962:   0x54C3,
	963:   0x54C5,
	964:   0x54CA,
	965:   0x54CB,
	966:   0x54D6,
	967:   0x54D8,
	968:   0x54DB,
	969:   0x54E0,
	970:   0x54E1,
	971:   0x54E2,
	972:   0x54E3,
	973:   0x54E4,
	974:   0x54EB,
	975:   0x54EC,
	976:   0x54EF,
	977:   0x54F0,
	978:   0x54F1,
	979:   0x54F4,
	980:   0x54F5,
	981:   0x54F6,
	982:   0x54F7,
	983:   0x54F8,
	984:   0x54F9,
	985:   0x54FB,
	986:   0x54FE,
	987:   0x5500,
	988:   0x5502,
	989:   0x5503,
	990:   0x5504,
	991:   0x5505,
	992:   0x5508,
	993:   0x550A,
	994:   0x550B,
	995:   0x550C,
	996:   0x550D,
	997:   0x550E,
	998:   0x5512,
	999:   0x5513,
	1000:  0x5515,
	1001:  0x5516,
	1002:  0x5517,
	1003:  0x5518,
	1004:  0x5519,
	1005:  0x551A,
	1006:  0x551C,
	1007:  0x551D,
	1008:  0x551E,
	1009:  0x551F,
	1010:  0x5521,
	1011:  0x5525,
	1012:  0x5526,
	1013:  0x5528,
	1014:  0x5529,
	1015:  0x552B,
	1016:  0x552D,
	1017:  0x5532,
	1018:  0x5534,
	1019:  0x5535,
	1020:  0x5536,
	1021:  0x5538,
	1022:  0x5539,
	1023:  0x553A,
	1024:  0x553B,
	1025:  0x553D,
	1026:  0x5540,
	1027:  0x5542,
	1028:  0x5545,
	1029:  0x5547,
	1030:  0x5548,
	1031:  0x554B,
	1032:  0x554C,
	1033:  0x554D,
	1034:  0x554E,
	1035:  0x554F,
	1036:  0x5551,
	1037:  0x5552,
	1038:  0x5553,
	1039:  0x5554,
	1040:  0x5557,
	1041:  0x5558,
	1042:  0x5559,
	1043:  0x555A,
	1044:  0x555B,
	1045:  0x555D,
	1046:  0x555E,
	1047:  0x555F,
	1048:  0x5560,
	1049:  0x5562,
	1050:  0x5563,
	1051:  0x5568,
	1052:  0x5569,
	1053:  0x556B,
	1054:  0x556F,
	1055:  0x5570,
	1056:  0x5571,
	1057:  0x5572,
	1058:  0x5573,
	1059:  0x5574,
	1060:  0x5579,
	1061:  0x557A,
	1062:  0x557D,
	1063:  0x557F,
	1064:  0x5585,
	1065:  0x5586,
	1066:  0x558C,
	1067:  0x558D,
	1068:  0x558E,
	1069:  0x5590,
	1070:  0x5592,
	1071:  0x5593,
	1072:  0x5595,
	1073:  0x5596,
	1074:  0x5597,
	1075:  0x559A,
	1076:  0x559B,
	1077:  0x559E,
	1078:  0x55A0,
	1079:  0x55A1,
	1080:  0x55A2,
	1081:  0x55A3,
	1082:  0x55A4,
	1083:  0x55A5,
	1084:  0x55A6,
	1085:  0x55A8,
	1086:  0x55A9,
	1087:  0x55AA,
	1088:  0x55AB,
	1089:  0x55AC,
	1090:  0x55AD,
	1091:  0x55AE,
	1092:  0x55AF,
	1093:  0x55B0,
	1094:  0x55B2,
	1095:  0x55B4,
	1096:  0x55B6,
	1097:  0x55B8,
	1098:  0x55BA,
	1099:  0x55BC,
	1100:  0x55BF,
	1101:  0x55C0,
	1102:  0x55C1,
	1103:  0x55C2,
	1104:  0x55C3,
	1105:  0x55C6,
	1106:  0x55C7,
	1107:  0x55C8,
	1108:  0x55CA,
	1109:  0x55CB,
	1110:  0x55CE,
	1111:  0x55CF,
	1112:  0x55D0,
	1113:  0x55D5,
	1114:  0x55D7,
	1115:  0x55D8,
	1116:  0x55D9,
	1117:  0x55DA,
	1118:  0x55DB,
	1119:  0x55DE,
	1120:  0x55E0,
	1121:  0x55E2,
	1122:  0x55E7,
	1123:  0x55E9,
	1124:  0x55ED,
	1125:  0x55EE,
	1126:  0x55F0,
	1127:  0x55F1,
	1128:  0x55F4,
	1129:  0x55F6,
	1130:  0x55F8,
	1131:  0x55F9,
	1132:  0x55FA,
	1133:  0x55FB,
	1134:  0x55FC,
	1135:  0x55FF,
	1136:  0x5602,
	1137:  0x5603,
	1138:  0x5604,
	1139:  0x5605,
	1140:  0x5606,
	1141:  0x5607,
	1142:  0x560A,
	1143:  0x560B,
	1144:  0x560D,
	1145:  0x5610,
	1146:  0x5611,
	1147:  0x5612,
	1148:  0x5613,
	1149:  0x5614,
	1150:  0x5615,
	1151:  0x5616,
	1152:  0x5617,
	1153:  0x5619,
	1154:  0x561A,
	1155:  0x561C,
	1156:  0x561D,
	1157:  0x5620,
	1158:  0x5621,
	1159:  0x5622,
	1160:  0x5625,
	1161:  0x5626,
	1162:  0x5628,
	1163:  0x5629,
	1164:  0x562A,
	1165:  0x562B,
	1166:  0x562E,
	1167:  0x562F,
	1168:  0x5630,
	1169:  0x5633,
	1170:  0x5635,
	1171:  0x5637,
	1172:  0x5638,
	1173:  0x563A,
	1174:  0x563C,
	1175:  0x563D,
	1176:  0x563E,
	1177:  0x5640,
	1178:  0x5641,
	1179:  0x5642,
	1180:  0x5643,
	1181:  0x5644,
	1182:  0x5645,
	1183:  0x5646,
	1184:  0x5647,
	1185:  0x5648,
	1186:  0x5649,
	1187:  0x564A,
	1188:  0x564B,
	1189:  0x564F,
	1190:  0x5650,
	1191:  0x5651,
	1192:  0x5652,
	1193:  0x5653,
	1194:  0x5655,
	1195:  0x5656,
	1196:  0x565A,
	1197:  0x565B,
	1198:  0x565D,
	1199:  0x565E,
	1200:  0x565F,
	1201:  0x5660,
	1202:  0x5661,
	1203:  0x5663,
	1204:  0x5665,
	1205:  0x5666,
	1206:  0x5667,
	1207:  0x566D,
	1208:  0x566E,
	1209:  0x566F,
	1210:  0x5670,
	1211:  0x5672,
	1212:  0x5673,
	1213:  0x5674,
	1214:  0x5675,
	1215:  0x5677,
	1216:  0x5678,
	1217:  0x5679,
	1218:  0x567A,
	1219:  0x567D,
	1220:  0x567E,
	1221:  0x567F,
	1222:  0x5680,
	1223:  0x5681,
	1224:  0x5682,
	1225:  0x5683,
	1226:  0x5684,
	1227:  0x5687,
	1228:  0x5688,
	1229:  0x5689,
	1230:  0x568A,
	1231:  0x568B,
	1232:  0x568C,
	1233:  0x568D,
	1234:  0x5690,
	1235:  0x5691,
	1236:  0x5692,
	1237:  0x5694,
	1238:  0x5695,
	1239:  0x5696,
	1240:  0x5697,
	1241:  0x5698,
	1242:  0x5699,
	1243:  0x569A,
	1244:  0x569B,
	1245:  0x569C,
	1246:  0x569D,
	1247:  0x569E,
	1248:  0x569F,
	1249:  0x56A0,
	1250:  0x56A1,
	1251:  0x56A2,
	1252:  0x56A4,
	1253:  0x56A5,
	1254:  0x56A6,
	1255:  0x56A7,
	1256:  0x56A8,
	1257:  0x56A9,
	1258:  0x56AA,
	1259:  0x56AB,
	1260:  0x56AC,
	1261:  0x56AD,
	1262:  0x56AE,
	1263:  0x56B0,
	1264:  0x56B1,
	1265:  0x56B2,
	1266:  0x56B3,
	1267:  0x56B4,
	1268:  0x56B5,
	1269:  0x56B6,
	1270:  0x56B8,
	1271:  0x56B9,
	1272:  0x56BA,
	1273:  0x56BB,
	1274:  0x56BD,
	1275:  0x56BE,
	1276:  0x56BF,
	1277:  0x56C0,
	1278:  0x56C1,
	1279:  0x56C2,
	1280:  0x56C3,
	1281:  0x56C4,
	1282:  0x56C5,
	1283:  0x56C6,
	1284:  0x56C7,
	1285:  0x56C8,
	1286:  0x56C9,
	1287:  0x56CB,
	1288:  0x56CC,
	1289:  0x56CD,
	1290:  0x56CE,
	1291:  0x56CF,
	1292:  0x56D0,
	1293:  0x56D1,
	1294:  0x56D2,
	1295:  0x56D3,
	1296:  0x56D5,
	1297:  0x56D6,
	1298:  0x56D8,
	1299:  0x56D9,
	1300:  0x56DC,
	1301:  0x56E3,
	1302:  0x56E5,
	1303:  0x56E6,
	1304:  0x56E7,
	1305:  0x56E8,
	1306:  0x56E9,
	1307:  0x56EA,
	1308:  0x56EC,
	1309:  0x56EE,
	1310:  0x56EF,
	1311:  0x56F2,
	1312:  0x56F3,
	1313:  0x56F6,
	1314:  0x56F7,
	1315:  0x56F8,
	1316:  0x56FB,
	1317:  0x56FC,
	1318:  0x5700,
	1319:  0x5701,
	1320:  0x5702,
	1321:  0x5705,
	1322:  0x5707,
	1323:  0x570B,
	1324:  0x570C,
	1325:  0x570D,
	1326:  0x570E,
	1327:  0x570F,
	1328:  0x5710,
	1329:  0x5711,
	1330:  0x5712,
	1331:  0x5713,
	1332:  0x5714,
	1333:  0x5715,
	1334:  0x5716,
	1335:  0x5717,
	1336:  0x5718,
	1337:  0x5719,
	1338:  0x571A,
	1339:  0x571B,
	1340:  0x571D,
	1341:  0x571E,
	1342:  0x5720,
	1343:  0x5721,
	1344:  0x5722,
	1345:  0x5724,
	1346:  0x5725,
	1347:  0x5726,
	1348:  0x5727,
	1349:  0x572B,
	1350:  0x5731,
	1351:  0x5732,
	1352:  0x5734,
	1353:  0x5735,
	1354:  0x5736,
	1355:  0x5737,
	1356:  0x5738,
	1357:  0x573C,
	1358:  0x573D,
	1359:  0x573F,
	1360:  0x5741,
	1361:  0x5743,
	1362:  0x5744,
	1363:  0x5745,
	1364:  0x5746,
	1365:  0x5748,
	1366:  0x5749,
	1367:  0x574B,
	1368:  0x5752,
	1369:  0x5753,
	1370:  0x5754,
	1371:  0x5755,
	1372:  0x5756,
	1373:  0x5758,
	1374:  0x5759,
	1375:  0x5762,
	1376:  0x5763,
	1377:  0x5765,
	1378:  0x5767,
	1379:  0x576C,
	1380:  0x576E,
	1381:  0x5770,
	1382:  0x5771,
	1383:  0x5772,
	1384:  0x5774,
	1385:  0x5775,
	1386:  0x5778,
	1387:  0x5779,
	1388:  0x577A,
	1389:  0x577D,
	1390:  0x577E,
	1391:  0x577F,
	1392:  0x5780,
	1393:  0x5781,
	1394:  0x5787,
	1395:  0x5788,
	1396:  0x5789,
	1397:  0x578A,
	1398:  0x578D,
	1399:  0x578E,
	1400:  0x578F,
	1401:  0x5790,
	1402:  0x5791,
	1403:  0x5794,
	1404:  0x5795,
	1405:  0x5796,
	1406:  0x5797,
	1407:  0x5798,
	1408:  0x5799,
	1409:  0x579A,
	1410:  0x579C,
	1411:  0x579D,
	1412:  0x579E,
	1413:  0x579F,
	1414:  0x57A5,
	1415:  0x57A8,
	1416:  0x57AA,
	1417:  0x57AC,
	1418:  0x57AF,
	1419:  0x57B0,
	1420:  0x57B1,
	1421:  0x57B3,
	1422:  0x57B5,
	1423:  0x57B6,
	1424:  0x57B7,
	1425:  0x57B9,
	1426:  0x57BA,
	1427:  0x57BB,
	1428:  0x57BC,
	1429:  0x57BD,
	1430:  0x57BE,
	1431:  0x57BF,
	1432:  0x57C0,
	1433:  0x57C1,
	1434:  0x57C4,
	1435:  0x57C5,
	1436:  0x57C6,
	1437:  0x57C7,
	1438:  0x57C8,
	1439:  0x57C9,
	1440:  0x57CA,
	1441:  0x57CC,
	1442:  0x57CD,
	1443:  0x57D0,
	1444:  0x57D1,
	1445:  0x57D3,
	1446:  0x57D6,
	1447:  0x57D7,
	1448:  0x57DB,
	1449:  0x57DC,
	1450:  0x57DE,
	1451:  0x57E1,
	1452:  0x57E2,
	1453:  0x57E3,
	1454:  0x57E5,
	1455:  0x57E6,
	1456:  0x57E7,
	1457:  0x57E8,
	1458:  0x57E9,
	1459:  0x57EA,
	1460:  0x57EB,
	1461:  0x57EC,
	1462:  0x57EE,
	1463:  0x57F0,
	1464:  0x57F1,
	1465:  0x57F2,
	1466:  0x57F3,
	1467:  0x57F5,
	1468:  0x57F6,
	1469:  0x57F7,
	1470:  0x57FB,
	1471:  0x57FC,
	1472:  0x57FE,
	1473:  0x57FF,
	1474:  0x5801,
	1475:  0x5803,
	1476:  0x5804,
	1477:  0x5805,
	1478:  0x5808,
	1479:  0x5809,
	1480:  0x580A,
	1481:  0x580C,
	1482:  0x580E,
	1483:  0x580F,
	1484:  0x5810,
	1485:  0x5812,
	1486:  0x5813,
	1487:  0x5814,
	1488:  0x5816,
	1489:  0x5817,
	1490:  0x5818,
	1491:  0x581A,
	1492:  0x581B,
	1493:  0x581C,
	1494:  0x581D,
	1495:  0x581F,
	1496:  0x5822,
	1497:  0x5823,
	1498:  0x5825,
	1499:  0x5826,
	1500:  0x5827,
	1501:  0x5828,
	1502:  0x5829,
	1503:  0x582B,
	1504:  0x582C,
	1505:  0x582D,
	1506:  0x582E,
	1507:  0x582F,
	1508:  0x5831,
	1509:  0x5832,
	1510:  0x5833,
	1511:  0x5834,
	1512:  0x5836,
	1513:  0x5837,
	1514:  0x5838,
	1515:  0x5839,
	1516:  0x583A,
	1517:  0x583B,
	1518:  0x583C,
	1519:  0x583D,
	1520:  0x583E,
	1521:  0x583F,
	1522:  0x5840,
	1523:  0x5841,
	1524:  0x5842,
	1525:  0x5843,
	1526:  0x5845,
	1527:  0x5846,
	1528:  0x5847,
	1529:  0x5848,
	1530:  0x5849,
	1531:  0x584A,
	1532:  0x584B,
	1533:  0x584E,
	1534:  0x584F,
	1535:  0x5850,
	1536:  0x5852,
	1537:  0x5853,
	1538:  0x5855,
	1539:  0x5856,
	1540:  0x5857,
	1541:  0x5859,
	1542:  0x585A,
	1543:  0x585B,
	1544:  0x585C,
	1545:  0x585D,
	1546:  0x585F,
	1547:  0x5860,
	1548:  0x5861,
	1549:  0x5862,
	1550:  0x5863,
	1551:  0x5864,
	1552:  0x5866,
	1553:  0x5867,
	1554:  0x5868,
	1555:  0x5869,
	1556:  0x586A,
	1557:  0x586D,
	1558:  0x586E,
	1559:  0x586F,
	1560:  0x5870,
	1561:  0x5871,
	1562:  0x5872,
	1563:  0x5873,
	1564:  0x5874,
	1565:  0x5875,
	1566:  0x5876,
	1567:  0x5877,
	1568:  0x5878,
	1569:  0x5879,
	1570:  0x587A,
	1571:  0x587B,
	1572:  0x587C,
	1573:  0x587D,
	1574:  0x587F,
	1575:  0x5882,
	1576:  0x5884,
	1577:  0x5886,
	1578:  0x5887,
	1579:  0x5888,
	1580:  0x588A,
	1581:  0x588B,
	1582:  0x588C,
	1583:  0x588D,
	1584:  0x588E,
	1585:  0x588F,
	1586:  0x5890,
	1587:  0x5891,
	1588:  0x5894,
	1589:  0x5895,
	1590:  0x5896,
	1591:  0x5897,
	1592:  0x5898,
	1593:  0x589B,
	1594:  0x589C,
	1595:  0x589D,
	1596:  0x58A0,
	1597:  0x58A1,
	1598:  0x58A2,
	1599:  0x58A3,
	1600:  0x58A4,
	1601:  0x58A5,
	1602:  0x58A6,
	1603:  0x58A7,
	1604:  0x58AA,
	1605:  0x58AB,
	1606:  0x58AC,
	1607:  0x58AD,
	1608:  0x58AE,
	1609:  0x58AF,
	1610:  0x58B0,
	1611:  0x58B1,
	1612:  0x58B2,
	1613:  0x58B3,
	1614:  0x58B4,
	1615:  0x58B5,
	1616:  0x58B6,
	1617:  0x58B7,
	1618:  0x58B8,
	1619:  0x58B9,
	1620:  0x58BA,
	1621:  0x58BB,
	1622:  0x58BD,
	1623:  0x58BE,
	1624:  0x58BF,
	1625:  0x58C0,
	1626:  0x58C2,
	1627:  0x58C3,
	1628:  0x58C4,
	1629:  0x58C6,
	1630:  0x58C7,
	1631:  0x58C8,
	1632:  0x58C9,
	1633:  0x58CA,
	1634:  0x58CB,
	1635:  0x58CC,
	1636:  0x58CD,
	1637:  0x58CE,
	1638:  0x58CF,
	1639:  0x58D0,
	1640:  0x58D2,
	1641:  0x58D3,
	1642:  0x58D4,
	1643:  0x58D6,
	1644:  0x58D7,
	1645:  0x58D8,
	1646:  0x58D9,
	1647:  0x58DA,
	1648:  0x58DB,
	1649:  0x58DC,
	1650:  0x58DD,
	1651:  0x58DE,
	1652:  0x58DF,
	1653:  0x58E0,
	1654:  0x58E1,
	1655:  0x58E2,
	1656:  0x58E3,
	1657:  0x58E5,
	1658:  0x58E6,
	1659:  0x58E7,
	1660:  0x58E8,
	1661:  0x58E9,
	1662:  0x58EA,
	1663:  0x58ED,
	1664:  0x58EF,
	1665:  0x58F1,
	1666:  0x58F2,
	1667:  0x58F4,
	1668:  0x58F5,
	1669:  0x58F7,
	1670:  0x58F8,
	1671:  0x58FA,
	1672:  0x58FB,
	1673:  0x58FC,
	1674:  0x58FD,
	1675:  0x58FE,
	1676:  0x58FF,
	1677:  0x5900,
	1678:  0x5901,
	1679:  0x5903,
	1680:  0x5905,
	1681:  0x5906,
	1682:  0x5908,
	1683:  0x5909,
	1684:  0x590A,
	1685:  0x590B,
	1686:  0x590C,
	1687:  0x590E,
	1688:  0x5910,
	1689:  0x5911,
	1690:  0x5912,
	1691:  0x5913,
	1692:  0x5917,
	1693:  0x5918,
	1694:  0x591B,
	1695:  0x591D,
	1696:  0x591E,
	1697:  0x5920,
	1698:  0x5921,
	1699:  0x5922,
	1700:  0x5923,
	1701:  0x5926,
	1702:  0x5928,
	1703:  0x592C,
	1704:  0x5930,
	1705:  0x5932,
	1706:  0x5933,
	1707:  0x5935,
	1708:  0x5936,
	1709:  0x593B,
	1710:  0x593D,
	1711:  0x593E,
	1712:  0x593F,
	1713:  0x5940,
	1714:  0x5943,
	1715:  0x5945,
	1716:  0x5946,
	1717:  0x594A,
	1718:  0x594C,
	1719:  0x594D,
	1720:  0x5950,
	1721:  0x5952,
	1722:  0x5953,
	1723:  0x5959,
	1724:  0x595B,
	1725:  0x595C,
	1726:  0x595D,
	1727:  0x595E,
	1728:  0x595F,
	1729:  0x5961,
	1730:  0x5963,
	1731:  0x5964,
	1732:  0x5966,
	1733:  0x5967,
	1734:  0x5968,
	1735:  0x5969,
	1736:  0x596A,
	1737:  0x596B,
	1738:  0x596C,
	1739:  0x596D,
	1740:  0x596E,
	1741:  0x596F,
	1742:  0x5970,
	1743:  0x5971,
	1744:  0x5972,
	1745:  0x5975,
	1746:  0x5977,
	1747:  0x597A,
	1748:  0x597B,
	1749:  0x597C,
	1750:  0x597E,
	1751:  0x597F,
	1752:  0x5980,
	1753:  0x5985,
	1754:  0x5989,
	1755:  0x598B,
	1756:  0x598C,
	1757:  0x598E,
	1758:  0x598F,
	1759:  0x5990,
	1760:  0x5991,
	1761:  0x5994,
	1762:  0x5995,
	1763:  0x5998,
	1764:  0x599A,
	1765:  0x599B,
	1766:  0x599C,
	1767:  0x599D,
	1768:  0x599F,
	1769:  0x59A0,
	1770:  0x59A1,
	1771:  0x59A2,
	1772:  0x59A6,
	1773:  0x59A7,
	1774:  0x59AC,
	1775:  0x59AD,
	1776:  0x59B0,
	1777:  0x59B1,
	1778:  0x59B3,
	1779:  0x59B4,
	1780:  0x59B5,
	1781:  0x59B6,
	1782:  0x59B7,
	1783:  0x59B8,
	1784:  0x59BA,
	1785:  0x59BC,
	1786:  0x59BD,
	1787:  0x59BF,
	1788:  0x59C0,
	1789:  0x59C1,
	1790:  0x59C2,
	1791:  0x59C3,
	1792:  0x59C4,
	1793:  0x59C5,
	1794:  0x59C7,
	1795:  0x59C8,
	1796:  0x59C9,
	1797:  0x59CC,
	1798:  0x59CD,
	1799:  0x59CE,
	1800:  0x59CF,
	1801:  0x59D5,
	1802:  0x59D6,
	1803:  0x59D9,
	1804:  0x59DB,
	1805:  0x59DE,
	1806:  0x59DF,
	1807:  0x59E0,
	1808:  0x59E1,
	1809:  0x59E2,
	1810:  0x59E4,
	1811:  0x59E6,
	1812:  0x59E7,
	1813:  0x59E9,
	1814:  0x59EA,
	1815:  0x59EB,
	1816:  0x59ED,
	1817:  0x59EE,
	1818:  0x59EF,
	1819:  0x59F0,
	1820:  0x59F1,
	1821:  0x59F2,
	1822:  0x59F3,
	1823:  0x59F4,
	1824:  0x59F5,
	1825:  0x59F6,
	1826:  0x59F7,
	1827:  0x59F8,
	1828:  0x59FA,
	1829:  0x59FC,
	1830:  0x59FD,
	1831:  0x59FE,
	1832:  0x5A00,
	1833:  0x5A02,
	1834:  0x5A0A,
	1835:  0x5A0B,
	1836:  0x5A0D,
	1837:  0x5A0E,
	1838:  0x5A0F,
	1839:  0x5A10,
	1840:  0x5A12,
	1841:  0x5A14,
	1842:  0x5A15,
	1843:  0x5A16,
	1844:  0x5A17,
	1845:  0x5A19,
	1846:  0x5A1A,
	1847:  0x5A1B,
	1848:  0x5A1D,
	1849:  0x5A1E,
	1850:  0x5A21,
	1851:  0x5A22,
	1852:  0x5A24,
	1853:  0x5A26,
	1854:  0x5A27,
	1855:  0x5A28,
	1856:  0x5A2A,
	1857:  0x5A2B,
	1858:  0x5A2C,
	1859:  0x5A2D,
	1860:  0x5A2E,
	1861:  0x5A2F,
	1862:  0x5A30,
	1863:  0x5A33,
	1864:  0x5A35,
	1865:  0x5A37,
	1866:  0x5A38,
	1867:  0x5A39,
	1868:  0x5A3A,
	1869:  0x5A3B,
	1870:  0x5A3D,
	1871:  0x5A3E,
	1872:  0x5A3F,
	1873:  0x5A41,
	1874:  0x5A42,
	1875:  0x5A43,
	1876:  0x5A44,
	1877:  0x5A45,
	1878:  0x5A47,
	1879:  0x5A48,
	1880:  0x5A4B,
	1881:  0x5A4C,
	1882:  0x5A4D,
	1883:  0x5A4E,
	1884:  0x5A4F,
	1885:  0x5A50,
	1886:  0x5A51,
	1887:  0x5A52,
	1888:  0x5A53,
	1889:  0x5A54,
	1890:  0x5A56,
	1891:  0x5A57,
	1892:  0x5A58,
	1893:  0x5A59,
	1894:  0x5A5B,
	1895:  0x5A5C,
	1896:  0x5A5D,
	1897:  0x5A5E,
	1898:  0x5A5F,
	1899:  0x5A60,
	1900:  0x5A61,
	1901:  0x5A63,
	1902:  0x5A64,
	1903:  0x5A65,
	1904:  0x5A66,
	1905:  0x5A68,
	1906:  0x5A69,
	1907:  0x5A6B,
	1908:  0x5A6C,
	1909:  0x5A6D,
	1910:  0x5A6E,
	1911:  0x5A6F,
	1912:  0x5A70,
	1913:  0x5A71,
	1914:  0x5A72,
	1915:  0x5A73,
	1916:  0x5A78,
	1917:  0x5A79,
	1918:  0x5A7B,
	1919:  0x5A7C,
	1920:  0x5A7D,
	1921:  0x5A7E,
	1922:  0x5A80,
	1923:  0x5A81,
	1924:  0x5A82,
	1925:  0x5A83,
	1926:  0x5A84,
	1927:  0x5A85,
	1928:  0x5A86,
	1929:  0x5A87,
	1930:  0x5A88,
	1931:  0x5A89,
	1932:  0x5A8A,
	1933:  0x5A8B,
	1934:  0x5A8C,
	1935:  0x5A8D,
	1936:  0x5A8E,
	1937:  0x5A8F,
	1938:  0x5A90,
	1939:  0x5A91,
	1940:  0x5A93,
	1941:  0x5A94,
	1942:  0x5A95,
	1943:  0x5A96,
	1944:  0x5A97,
	1945:  0x5A98,
	1946:  0x5A99,
	1947:  0x5A9C,
	1948:  0x5A9D,
	1949:  0x5A9E,
	1950:  0x5A9F,
	1951:  0x5AA0,
	1952:  0x5AA1,
	1953:  0x5AA2,
	1954:  0x5AA3,
	1955:  0x5AA4,
	1956:  0x5AA5,
	1957:  0x5AA6,
	1958:  0x5AA7,
	1959:  0x5AA8,
	1960:  0x5AA9,
	1961:  0x5AAB,
	1962:  0x5AAC,
	1963:  0x5AAD,
	1964:  0x5AAE,
	1965:  0x5AAF,
	1966:  0x5AB0,
	1967:  0x5AB1,
	1968:  0x5AB4,
	1969:  0x5AB6,
	1970:  0x5AB7,
	1971:  0x5AB9,
	1972:  0x5ABA,
	1973:  0x5ABB,
	1974:  0x5ABC,
	1975:  0x5ABD,
	1976:  0x5ABF,
	1977:  0x5AC0,
	1978:  0x5AC3,
	1979:  0x5AC4,
	1980:  0x5AC5,
	1981:  0x5AC6,
	1982:  0x5AC7,
	1983:  0x5AC8,
	1984:  0x5ACA,
	1985:  0x5ACB,
	1986:  0x5ACD,
	1987:  0x5ACE,
	1988:  0x5ACF,
	1989:  0x5AD0,
	1990:  0x5AD1,
	1991:  0x5AD3,
	1992:  0x5AD5,
	1993:  0x5AD7,
	1994:  0x5AD9,
	1995:  0x5ADA,
	1996:  0x5ADB,
	1997:  0x5ADD,
	1998:  0x5ADE,
	1999:  0x5ADF,
	2000:  0x5AE2,
	2001:  0x5AE4,
	2002:  0x5AE5,
	2003:  0x5AE7,
	2004:  0x5AE8,
	2005:  0x5AEA,
	2006:  0x5AEC,
	2007:  0x5AED,
	2008:  0x5AEE,
	2009:  0x5AEF,
	2010:  0x5AF0,
	2011:  0x5AF2,
	2012:  0x5AF3,
	2013:  0x5AF4,
	2014:  0x5AF5,
	2015:  0x5AF6,
	2016:  0x5AF7,
	2017:  0x5AF8,
	2018:  0x5AF9,
	2019:  0x5AFA,
	2020:  0x5AFB,
	2021:  0x5AFC,
	2022:  0x5AFD,
	2023:  0x5AFE,
	2024:  0x5AFF,
	2025:  0x5B00,
	2026:  0x5B01,
	2027:  0x5B02,
	2028:  0x5B03,
	2029:  0x5B04,
	2030:  0x5B05,
	2031:  0x5B06,
	2032:  0x5B07,
	2033:  0x5B08,
	2034:  0x5B0A,
	2035:  0x5B0B,
	2036:  0x5B0C,
	2037:  0x5B0D,
	2038:  0x5B0E,
	2039:  0x5B0F,
	2040:  0x5B10,
	2041:  0x5B11,
	2042:  0x5B12,
	2043:  0x5B13,
	2044:  0x5B14,
	2045:  0x5B15,
	2046:  0x5B18,
	2047:  0x5B19,
	2048:  0x5B1A,
	2049:  0x5B1B,
	2050:  0x5B1C,
	2051:  0x5B1D,
	2052:  0x5B1E,
	2053:  0x5B1F,
	2054:  0x5B20,
	2055:  0x5B21,
	2056:  0x5B22,
	2057:  0x5B23,
	2058:  0x5B24,
	2059:  0x5B25,
	2060:  0x5B26,
	2061:  0x5B27,
	2062:  0x5B28,
	2063:  0x5B29,
	2064:  0x5B2A,
	2065:  0x5B2B,
	2066:  0x5B2C,
	2067:  0x5B2D,
	2068:  0x5B2E,
	2069:  0x5B2F,
	2070:  0x5B30,
	2071:  0x5B31,
	2072:  0x5B33,
	2073:  0x5B35,
	2074:  0x5B36,
	2075:  0x5B38,
	2076:  0x5B39,
	2077:  0x5B3A,
	2078:  0x5B3B,
	2079:  0x5B3C,
	2080:  0x5B3D,
	2081:  0x5B3E,
	2082:  0x5B3F,
	2083:  0x5B41,
	2084:  0x5B42,
	2085:  0x5B43,
	2086:  0x5B44,
	2087:  0x5B45,
	2088:  0x5B46,
	2089:  0x5B47,
	2090:  0x5B48,
	2091:  0x5B49,
	2092:  0x5B4A,
	2093:  0x5B4B,
	2094:  0x5B4C,
	2095:  0x5B4D,
	2096:  0x5B4E,
	2097:  0x5B4F,
	2098:  0x5B52,
	2099:  0x5B56,
	2100:  0x5B5E,
	2101:  0x5B60,
	2102:  0x5B61,
	2103:  0x5B67,
	2104:  0x5B68,
	2105:  0x5B6B,
	2106:  0x5B6D,
	2107:  0x5B6E,
	2108:  0x5B6F,
	2109:  0x5B72,
	2110:  0x5B74,
	2111:  0x5B76,
	2112:  0x5B77,
	2113:  0x5B78,
	2114:  0x5B79,
	2115:  0x5B7B,
	2116:  0x5B7C,
	2117:  0x5B7E,
	2118:  0x5B7F,
	2119:  0x5B82,
	2120:  0x5B86,
	2121:  0x5B8A,
	2122:  0x5B8D,
	2123:  0x5B8E,
	2124:  0x5B90,
	2125:  0x5B91,
	2126:  0x5B92,
	2127:  0x5B94,
	2128:  0x5B96,
	2129:  0x5B9F,
	2130:  0x5BA7,
	2131:  0x5BA8,
	2132:  0x5BA9,
	2133:  0x5BAC,
	2134:  0x5BAD,
	2135:  0x5BAE,
	2136:  0x5BAF,
	2137:  0x5BB1,
	2138:  0x5BB2,
	2139:  0x5BB7,
	2140:  0x5BBA,
	2141:  0x5BBB,
	2142:  0x5BBC,
	2143:  0x5BC0,
	2144:  0x5BC1,
	2145:  0x5BC3,
	2146:  0x5BC8,
	2147:  0x5BC9,
	2148:  0x5BCA,
	2149:  0x5BCB,
	2150:  0x5BCD,
	2151:  0x5BCE,
	2152:  0x5BCF,
	2153:  0x5BD1,
	2154:  0x5BD4,
	2155:  0x5BD5,
	2156:  0x5BD6,
	2157:  0x5BD7,
	2158:  0x5BD8,
	2159:  0x5BD9,
	2160:  0x5BDA,
	2161:  0x5BDB,
	2162:  0x5BDC,
	2163:  0x5BE0,
	2164:  0x5BE2,
	2165:  0x5BE3,
	2166:  0x5BE6,
	2167:  0x5BE7,
	2168:  0x5BE9,
	2169:  0x5BEA,
	2170:  0x5BEB,
	2171:  0x5BEC,
	2172:  0x5BED,
	2173:  0x5BEF,
	2174:  0x5BF1,
	2175:  0x5BF2,
	2176:  0x5BF3,
	2177:  0x5BF4,
	2178:  0x5BF5,
	2179:  0x5BF6,
	2180:  0x5BF7,
	2181:  0x5BFD,
	2182:  0x5BFE,
	2183:  0x5C00,
	2184:  0x5C02,
	2185:  0x5C03,
	2186:  0x5C05,
	2187:  0x5C07,
	2188:  0x5C08,
	2189:  0x5C0B,
	2190:  0x5C0C,
	2191:  0x5C0D,
	2192:  0x5C0E,
	2193:  0x5C10,
	2194:  0x5C12,
	2195:  0x5C13,
	2196:  0x5C17,
	2197:  0x5C19,
	2198:  0x5C1B,
	2199:  0x5C1E,
	2200:  0x5C1F,
	2201:  0x5C20,
	2202:  0x5C21,
	2203:  0x5C23,
	2204:  0x5C26,
	2205:  0x5C28,
	2206:  0x5C29,
	2207:  0x5C2A,
	2208:  0x5C2B,
	2209:  0x5C2D,
	2210:  0x5C2E,
	2211:  0x5C2F,
	2212:  0x5C30,
	2213:  0x5C32,
	2214:  0x5C33,
	2215:  0x5C35,
	2216:  0x5C36,
	2217:  0x5C37,
	2218:  0x5C43,
	2219:  0x5C44,
	2220:  0x5C46,
	2221:  0x5C47,
	2222:  0x5C4C,
	2223:  0x5C4D,
	2224:  0x5C52,
	2225:  0x5C53,
	2226:  0x5C54,
	2227:  0x5C56,
	2228:  0x5C57,
	2229:  0x5C58,
	2230:  0x5C5A,
	2231:  0x5C5B,
	2232:  0x5C5C,
	2233:  0x5C5D,
	2234:  0x5C5F,
	2235:  0x5C62,
	2236:  0x5C64,
	2237:  0x5C67,
	2238:  0x5C68,
	2239:  0x5C69,
	2240:  0x5C6A,
	2241:  0x5C6B,
	2242:  0x5C6C,
	2243:  0x5C6D,
	2244:  0x5C70,
	2245:  0x5C72,
	2246:  0x5C73,
	2247:  0x5C74,
	2248:  0x5C75,
	2249:  0x5C76,
	2250:  0x5C77,
	2251:  0x5C78,
	2252:  0x5C7B,
	2253:  0x5C7C,
	2254:  0x5C7D,
	2255:  0x5C7E,
	2256:  0x5C80,
	2257:  0x5C83,
	2258:  0x5C84,
	2259:  0x5C85,
	2260:  0x5C86,
	2261:  0x5C87,
	2262:  0x5C89,
	2263:  0x5C8A,
	2264:  0x5C8B,
	2265:  0x5C8E,
	2266:  0x5C8F,
	2267:  0x5C92,
	2268:  0x5C93,
	2269:  0x5C95,
	2270:  0x5C9D,
	2271:  0x5C9E,
	2272:  0x5C9F,
	2273:  0x5CA0,
	2274:  0x5CA1,
	2275:  0x5CA4,
	2276:  0x5CA5,
	2277:  0x5CA6,
	2278:  0x5CA7,
	2279:  0x5CA8,
	2280:  0x5CAA,
	2281:  0x5CAE,
	2282:  0x5CAF,
	2283:  0x5CB0,
	2284:  0x5CB2,
	2285:  0x5CB4,
	2286:  0x5CB6,
	2287:  0x5CB9,
	2288:  0x5CBA,
	2289:  0x5CBB,
	2290:  0x5CBC,
	2291:  0x5CBE,
	2292:  0x5CC0,
	2293:  0x5CC2,
	2294:  0x5CC3,
	2295:  0x5CC5,
	2296:  0x5CC6,
	2297:  0x5CC7,
	2298:  0x5CC8,
	2299:  0x5CC9,
	2300:  0x5CCA,
	2301:  0x5CCC,
	2302:  0x5CCD,
	2303:  0x5CCE,
	2304:  0x5CCF,
	2305:  0x5CD0,
	2306:  0x5CD1,
	2307:  0x5CD3,
	2308:  0x5CD4,
	2309:  0x5CD5,
	2310:  0x5CD6,
	2311:  0x5CD7,
	2312:  0x5CD8,
	2313:  0x5CDA,
	2314:  0x5CDB,
	2315:  0x5CDC,
	2316:  0x5CDD,
	2317:  0x5CDE,
	2318:  0x5CDF,
	2319:  0x5CE0,
	2320:  0x5CE2,
	2321:  0x5CE3,
	2322:  0x5CE7,
	2323:  0x5CE9,
	2324:  0x5CEB,
	2325:  0x5CEC,
	2326:  0x5CEE,
	2327:  0x5CEF,
	2328:  0x5CF1,
	2329:  0x5CF2,
	2330:  0x5CF3,
	2331:  0x5CF4,
	2332:  0x5CF5,
	2333:  0x5CF6,
	2334:  0x5CF7,
	2335:  0x5CF8,
	2336:  0x5CF9,
	2337:  0x5CFA,
	2338:  0x5CFC,
	2339:  0x5CFD,
	2340:  0x5CFE,
	2341:  0x5CFF,
	2342:  0x5D00,
	2343:  0x5D01,
	2344:  0x5D04,
	2345:  0x5D05,
	2346:  0x5D08,
	2347:  0x5D09,
	2348:  0x5D0A,
	2349:  0x5D0B,
	2350:  0x5D0C,
	2351:  0x5D0D,
	2352:  0x5D0F,
	2353:  0x5D10,
	2354:  0x5D11,
	2355:  0x5D12,
	2356:  0x5D13,
	2357:  0x5D15,
	2358:  0x5D17,
	2359:  0x5D18,
	2360:  0x5D19,
	2361:  0x5D1A,
	2362:  0x5D1C,
	2363:  0x5D1D,
	2364:  0x5D1F,
	2365:  0x5D20,
	2366:  0x5D21,
	2367:  0x5D22,
	2368:  0x5D23,
	2369:  0x5D25,
	2370:  0x5D28,
	2371:  0x5D2A,
	2372:  0x5D2B,
	2373:  0x5D2C,
	2374:  0x5D2F,
	2375:  0x5D30,
	2376:  0x5D31,
	2377:  0x5D32,
	2378:  0x5D33,
	2379:  0x5D35,
	2380:  0x5D36,
	2381:  0x5D37,
	2382:  0x5D38,
	2383:  0x5D39,
	2384:  0x5D3A,
	2385:  0x5D3B,
	2386:  0x5D3C,
	2387:  0x5D3F,
	2388:  0x5D40,
	2389:  0x5D41,
	2390:  0x5D42,
	2391:  0x5D43,
	2392:  0x5D44,
	2393:  0x5D45,
	2394:  0x5D46,
	2395:  0x5D48,
	2396:  0x5D49,
	2397:  0x5D4D,
	2398:  0x5D4E,
	2399:  0x5D4F,
	2400:  0x5D50,
	2401:  0x5D51,
	2402:  0x5D52,
	2403:  0x5D53,
	2404:  0x5D54,
	2405:  0x5D55,
	2406:  0x5D56,
	2407:  0x5D57,
	2408:  0x5D59,
	2409:  0x5D5A,
	2410:  0x5D5C,
	2411:  0x5D5E,
	2412:  0x5D5F,
	2413:  0x5D60,
	2414:  0x5D61,
	2415:  0x5D62,
	2416:  0x5D63,
	2417:  0x5D64,
	2418:  0x5D65,
	2419:  0x5D66,
	2420:  0x5D67,
	2421:  0x5D68,
	2422:  0x5D6A,
	2423:  0x5D6D,
	2424:  0x5D6E,
	2425:  0x5D70,
	2426:  0x5D71,
	2427:  0x5D72,
	2428:  0x5D73,
	2429:  0x5D75,
	2430:  0x5D76,
	2431:  0x5D77,
	2432:  0x5D78,
	2433:  0x5D79,
	2434:  0x5D7A,
	2435:  0x5D7B,
	2436:  0x5D7C,
	2437:  0x5D7D,
	2438:  0x5D7E,
	2439:  0x5D7F,
	2440:  0x5D80,
	2441:  0x5D81,
	2442:  0x5D83,
	2443:  0x5D84,
	2444:  0x5D85,
	2445:  0x5D86,
	2446:  0x5D87,
	2447:  0x5D88,
	2448:  0x5D89,
	2449:  0x5D8A,
	2450:  0x5D8B,
	2451:  0x5D8C,
	2452:  0x5D8D,
	2453:  0x5D8E,
	2454:  0x5D8F,
	2455:  0x5D90,
	2456:  0x5D91,
	2457:  0x5D92,
	2458:  0x5D93,
	2459:  0x5D94,
	2460:  0x5D95,
	2461:  0x5D96,
	2462:  0x5D97,
	2463:  0x5D98,
	2464:  0x5D9A,
	2465:  0x5D9B,
	2466:  0x5D9C,
	2467:  0x5D9E,
	2468:  0x5D9F,
	2469:  0x5DA0,
	2470:  0x5DA1,
	2471:  0x5DA2,
	2472:  0x5DA3,
	2473:  0x5DA4,
	2474:  0x5DA5,
	2475:  0x5DA6,
	2476:  0x5DA7,
	2477:  0x5DA8,
	2478:  0x5DA9,
	2479:  0x5DAA,
	2480:  0x5DAB,
	2481:  0x5DAC,
	2482:  0x5DAD,
	2483:  0x5DAE,
	2484:  0x5DAF,
	2485:  0x5DB0,
	2486:  0x5DB1,
	2487:  0x5DB2,
	2488:  0x5DB3,
	2489:  0x5DB4,
	2490:  0x5DB5,
	2491:  0x5DB6,
	2492:  0x5DB8,
	2493:  0x5DB9,
	2494:  0x5DBA,
	2495:  0x5DBB,
	2496:  0x5DBC,
	2497:  0x5DBD,
	2498:  0x5DBE,
	2499:  0x5DBF,
	2500:  0x5DC0,
	2501:  0x5DC1,
	2502:  0x5DC2,
	2503:  0x5DC3,
	2504:  0x5DC4,
	2505:  0x5DC6,
	2506:  0x5DC7,
	2507:  0x5DC8,
	2508:  0x5DC9,
	2509:  0x5DCA,
	2510:  0x5DCB,
	2511:  0x5DCC,
	2512:  0x5DCE,
	2513:  0x5DCF,
	2514:  0x5DD0,
	2515:  0x5DD1,
	2516:  0x5DD2,
	2517:  0x5DD3,
	2518:  0x5DD4,
	2519:  0x5DD5,
	2520:  0x5DD6,
	2521:  0x5DD7,
	2522:  0x5DD8,
	2523:  0x5DD9,
	2524:  0x5DDA,
	2525:  0x5DDC,
	2526:  0x5DDF,
	2527:  0x5DE0,
	2528:  0x5DE3,
	2529:  0x5DE4,
	2530:  0x5DEA,
	2531:  0x5DEC,
	2532:  0x5DED,
	2533:  0x5DF0,
	2534:  0x5DF5,
	2535:  0x5DF6,
	2536:  0x5DF8,
	2537:  0x5DF9,
	2538:  0x5DFA,
	2539:  0x5DFB,
	2540:  0x5DFC,
	2541:  0x5DFF,
	2542:  0x5E00,
	2543:  0x5E04,
	2544:  0x5E07,
	2545:  0x5E09,
	2546:  0x5E0A,
	2547:  0x5E0B,
	2548:  0x5E0D,
	2549:  0x5E0E,
	2550:  0x5E12,
	2551:  0x5E13,
	2552:  0x5E17,
	2553:  0x5E1E,
	2554:  0x5E1F,
	2555:  0x5E20,
	2556:  0x5E21,
	2557:  0x5E22,
	2558:  0x5E23,
	2559:  0x5E24,
	2560:  0x5E25,
	2561:  0x5E28,
	2562:  0x5E29,
	2563:  0x5E2A,
	2564:  0x5E2B,
	2565:  0x5E2C,
	2566:  0x5E2F,
	2567:  0x5E30,
	2568:  0x5E32,
	2569:  0x5E33,
	2570:  0x5E34,
	2571:  0x5E35,
	2572:  0x5E36,
	2573:  0x5E39,
	2574:  0x5E3A,
	2575:  0x5E3E,
	2576:  0x5E3F,
	2577:  0x5E40,
	2578:  0x5E41,
	2579:  0x5E43,
	2580:  0x5E46,
	2581:  0x5E47,
	2582:  0x5E48,
	2583:  0x5E49,
	2584:  0x5E4A,
	2585:  0x5E4B,
	2586:  0x5E4D,
	2587:  0x5E4E,
	2588:  0x5E4F,
	2589:  0x5E50,
	2590:  0x5E51,
	2591:  0x5E52,
	2592:  0x5E53,
	2593:  0x5E56,
	2594:  0x5E57,
	2595:  0x5E58,
	2596:  0x5E59,
	2597:  0x5E5A,
	2598:  0x5E5C,
	2599:  0x5E5D,
	2600:  0x5E5F,
	2601:  0x5E60,
	2602:  0x5E63,
	2603:  0x5E64,
	2604:  0x5E65,
	2605:  0x5E66,
	2606:  0x5E67,
	2607:  0x5E68,
	2608:  0x5E69,
	2609:  0x5E6A,
	2610:  0x5E6B,
	2611:  0x5E6C,
	2612:  0x5E6D,
	2613:  0x5E6E,
	2614:  0x5E6F,
	2615:  0x5E70,
	2616:  0x5E71,
	2617:  0x5E75,
	2618:  0x5E77,
	2619:  0x5E79,
	2620:  0x5E7E,
	2621:  0x5E81,
	2622:  0x5E82,
	2623:  0x5E83,
	2624:  0x5E85,
	2625:  0x5E88,
	2626:  0x5E89,
	2627:  0x5E8C,
	2628:  0x5E8D,
	2629:  0x5E8E,
	2630:  0x5E92,
	2631:  0x5E98,
	2632:  0x5E9B,
	2633:  0x5E9D,
	2634:  0x5EA1,
	2635:  0x5EA2,
	2636:  0x5EA3,
	2637:  0x5EA4,
	2638:  0x5EA8,
	2639:  0x5EA9,
	2640:  0x5EAA,
	2641:  0x5EAB,
	2642:  0x5EAC,
	2643:  0x5EAE,
	2644:  0x5EAF,
	2645:  0x5EB0,
	2646:  0x5EB1,
	2647:  0x5EB2,
	2648:  0x5EB4,
	2649:  0x5EBA,
	2650:  0x5EBB,
	2651:  0x5EBC,
	2652:  0x5EBD,
	2653:  0x5EBF,
	2654:  0x5EC0,
	2655:  0x5EC1,
	2656:  0x5EC2,
	2657:  0x5EC3,
	2658:  0x5EC4,
	2659:  0x5EC5,
	2660:  0x5EC6,
	2661:  0x5EC7,
	2662:  0x5EC8,
	2663:  0x5ECB,
	2664:  0x5ECC,
	2665:  0x5ECD,
	2666:  0x5ECE,
	2667:  0x5ECF,
	2668:  0x5ED0,
	2669:  0x5ED4,
	2670:  0x5ED5,
	2671:  0x5ED7,
	2672:  0x5ED8,
	2673:  0x5ED9,
	2674:  0x5EDA,
	2675:  0x5EDC,
	2676:  0x5EDD,
	2677:  0x5EDE,
	2678:  0x5EDF,
	2679:  0x5EE0,
	2680:  0x5EE1,
	2681:  0x5EE2,
	2682:  0x5EE3,
	2683:  0x5EE4,
	2684:  0x5EE5,
	2685:  0x5EE6,
	2686:  0x5EE7,
	2687:  0x5EE9,
	2688:  0x5EEB,
	2689:  0x5EEC,
	2690:  0x5EED,
	2691:  0x5EEE,
	2692:  0x5EEF,
	2693:  0x5EF0,
	2694:  0x5EF1,
	2695:  0x5EF2,
	2696:  0x5EF3,
	2697:  0x5EF5,
	2698:  0x5EF8,
	2699:  0x5EF9,
	2700:  0x5EFB,
	2701:  0x5EFC,
	2702:  0x5EFD,
	2703:  0x5F05,
	2704:  0x5F06,
	2705:  0x5F07,
	2706:  0x5F09,
	2707:  0x5F0C,
	2708:  0x5F0D,
	2709:  0x5F0E,
	2710:  0x5F10,
	2711:  0x5F12,
	2712:  0x5F14,
	2713:  0x5F16,
	2714:  0x5F19,
	2715:  0x5F1A,
	2716:  0x5F1C,
	2717:  0x5F1D,
	2718:  0x5F1E,
	2719:  0x5F21,
	2720:  0x5F22,
	2721:  0x5F23,
	2722:  0x5F24,
	2723:  0x5F28,
	2724:  0x5F2B,
	2725:  0x5F2C,
	2726:  0x5F2E,
	2727:  0x5F30,
	2728:  0x5F32,
	2729:  0x5F33,
	2730:  0x5F34,
	2731:  0x5F35,
	2732:  0x5F36,
	2733:  0x5F37,
	2734:  0x5F38,
	2735:  0x5F3B,
	2736:  0x5F3D,
	2737:  0x5F3E,
	2738:  0x5F3F,
	2739:  0x5F41,
	2740:  0x5F42,
	2741:  0x5F43,
	2742:  0x5F44,
	2743:  0x5F45,
	2744:  0x5F46,
	2745:  0x5F47,
	2746:  0x5F48,
	2747:  0x5F49,
	2748:  0x5F4A,
	2749:  0x5F4B,
	2750:  0x5F4C,
	2751:  0x5F4D,
	2752:  0x5F4E,
	2753:  0x5F4F,
	2754:  0x5F51,
	2755:  0x5F54,
	2756:  0x5F59,
	2757:  0x5F5A,
	2758:  0x5F5B,
	2759:  0x5F5C,
	2760:  0x5F5E,
	2761:  0x5F5F,
	2762:  0x5F60,
	2763:  0x5F63,
	2764:  0x5F65,
	2765:  0x5F67,
	2766:  0x5F68,
	2767:  0x5F6B,
	2768:  0x5F6E,
	2769:  0x5F6F,
	2770:  0x5F72,
	2771:  0x5F74,
	2772:  0x5F75,
	2773:  0x5F76,
	2774:  0x5F78,
	2775:  0x5F7A,
	2776:  0x5F7D,
	2777:  0x5F7E,
	2778:  0x5F7F,
	2779:  0x5F83,
	2780:  0x5F86,
	2781:  0x5F8D,
	2782:  0x5F8E,
	2783:  0x5F8F,
	2784:  0x5F91,
	2785:  0x5F93,
	2786:  0x5F94,
	2787:  0x5F96,
	2788:  0x5F9A,
	2789:  0x5F9B,
	2790:  0x5F9D,
	2791:  0x5F9E,
	2792:  0x5F9F,
	2793:  0x5FA0,
	2794:  0x5FA2,
	2795:  0x5FA3,
	2796:  0x5FA4,
	2797:  0x5FA5,
	2798:  0x5FA6,
	2799:  0x5FA7,
	2800:  0x5FA9,
	2801:  0x5FAB,
	2802:  0x5FAC,
	2803:  0x5FAF,
	2804:  0x5FB0,
	2805:  0x5FB1,
	2806:  0x5FB2,
	2807:  0x5FB3,
	2808:  0x5FB4,
	2809:  0x5FB6,
	2810:  0x5FB8,
	2811:  0x5FB9,
	2812:  0x5FBA,
	2813:  0x5FBB,
	2814:  0x5FBE,
	2815:  0x5FBF,
	2816:  0x5FC0,
	2817:  0x5FC1,
	2818:  0x5FC2,
	2819:  0x5FC7,
	2820:  0x5FC8,
	2821:  0x5FCA,
	2822:  0x5FCB,
	2823:  0x5FCE,
	2824:  0x5FD3,
	2825:  0x5FD4,
	2826:  0x5FD5,
	2827:  0x5FDA,
	2828:  0x5FDB,
	2829:  0x5FDC,
	2830:  0x5FDE,
	2831:  0x5FDF,
	2832:  0x5FE2,
	2833:  0x5FE3,
	2834:  0x5FE5,
	2835:  0x5FE6,
	2836:  0x5FE8,
	2837:  0x5FE9,
	2838:  0x5FEC,
	2839:  0x5FEF,
	2840:  0x5FF0,
	2841:  0x5FF2,
	2842:  0x5FF3,
	2843:  0x5FF4,
	2844:  0x5FF6,
	2845:  0x5FF7,
	2846:  0x5FF9,
	2847:  0x5FFA,
	2848:  0x5FFC,
	2849:  0x6007,
	2850:  0x6008,
	2851:  0x6009,
	2852:  0x600B,
	2853:  0x600C,
	2854:  0x6010,
	2855:  0x6011,
	2856:  0x6013,
	2857:  0x6017,
	2858:  0x6018,
	2859:  0x601A,
	2860:  0x601E,
	2861:  0x601F,
	2862:  0x6022,
	2863:  0x6023,
	2864:  0x6024,
	2865:  0x602C,
	2866:  0x602D,
	2867:  0x602E,
	2868:  0x6030,
	2869:  0x6031,
	2870:  0x6032,
	2871:  0x6033,
	2872:  0x6034,
	2873:  0x6036,
	2874:  0x6037,
	2875:  0x6038,
	2876:  0x6039,
	2877:  0x603A,
	2878:  0x603D,
	2879:  0x603E,
	2880:  0x6040,
	2881:  0x6044,
	2882:  0x6045,
	2883:  0x6046,
	2884:  0x6047,
	2885:  0x6048,
	2886:  0x6049,
	2887:  0x604A,
	2888:  0x604C,
	2889:  0x604E,
	2890:  0x604F,
	2891:  0x6051,
	2892:  0x6053,
	2893:  0x6054,
	2894:  0x6056,
	2895:  0x6057,
	2896:  0x6058,
	2897:  0x605B,
	2898:  0x605C,
	2899:  0x605E,
	2900:  0x605F,
	2901:  0x6060,
	2902:  0x6061,
	2903:  0x6065,
	2904:  0x6066,
	2905:  0x606E,
	2906:  0x6071,
	2907:  0x6072,
	2908:  0x6074,
	2909:  0x6075,
	2910:  0x6077,
	2911:  0x607E,
	2912:  0x6080,
	2913:  0x6081,
	2914:  0x6082,
	2915:  0x6085,
	2916:  0x6086,
	2917:  0x6087,
	2918:  0x6088,
	2919:  0x608A,
	2920:  0x608B,
	2921:  0x608E,
	2922:  0x608F,
	2923:  0x6090,
	2924:  0x6091,
	2925:  0x6093,
	2926:  0x6095,
	2927:  0x6097,
	2928:  0x6098,
	2929:  0x6099,
	2930:  0x609C,
	2931:  0x609E,
	2932:  0x60A1,
	2933:  0x60A2,
	2934:  0x60A4,
	2935:  0x60A5,
	2936:  0x60A7,
	2937:  0x60A9,
	2938:  0x60AA,
	2939:  0x60AE,
	2940:  0x60B0,
	2941:  0x60B3,
	2942:  0x60B5,
	2943:  0x60B6,
	2944:  0x60B7,
	2945:  0x60B9,
	2946:  0x60BA,
	2947:  0x60BD,
	2948:  0x60BE,
	2949:  0x60BF,
	2950:  0x60C0,
	2951:  0x60C1,
	2952:  0x60C2,
	2953:  0x60C3,
	2954:  0x60C4,
	2955:  0x60C7,
	2956:  0x60C8,
	2957:  0x60C9,
	2958:  0x60CC,
	2959:  0x60CD,
	2960:  0x60CE,
	2961:  0x60CF,
	2962:  0x60D0,
	2963:  0x60D2,
	2964:  0x60D3,
	2965:  0x60D4,
	2966:  0x60D6,
	2967:  0x60D7,
	2968:  0x60D9,
	2969:  0x60DB,
	2970:  0x60DE,
	2971:  0x60E1,
	2972:  0x60E2,
	2973:  0x60E3,
	2974:  0x60E4,
	2975:  0x60E5,
	2976:  0x60EA,
	2977:  0x60F1,
	2978:  0x60F2,
	2979:  0x60F5,
	2980:  0x60F7,
	2981:  0x60F8,
	2982:  0x60FB,
	2983:  0x60FC,
	2984:  0x60FD,
	2985:  0x60FE,
	2986:  0x60FF,
	2987:  0x6102,
	2988:  0x6103,
	2989:  0x6104,
	2990:  0x6105,
	2991:  0x6107,
	2992:  0x610A,
	2993:  0x610B,
	2994:  0x610C,
	2995:  0x6110,
	2996:  0x6111,
	2997:  0x6112,
	2998:  0x6113,
	2999:  0x6114,
	3000:  0x6116,
	3001:  0x6117,
	3002:  0x6118,
	3003:  0x6119,
	3004:  0x611B,
	3005:  0x611C,
	3006:  0x611D,
	3007:  0x611E,
	3008:  0x6121,
	3009:  0x6122,
	3010:  0x6125,
	3011:  0x6128,
	3012:  0x6129,
	3013:  0x612A,
	3014:  0x612C,
	3015:  0x612D,
	3016:  0x612E,
	3017:  0x612F,
	3018:  0x6130,
	3019:  0x6131,
	3020:  0x6132,
	3021:  0x6133,
	3022:  0x6134,
	3023:  0x6135,
	3024:  0x6136,
	3025:  0x6137,
	3026:  0x6138,
	3027:  0x6139,
	3028:  0x613A,
	3029:  0x613B,
	3030:  0x613C,
	3031:  0x613D,
	3032:  0x613E,
	3033:  0x6140,
	3034:  0x6141,
	3035:  0x6142,
	3036:  0x6143,
	3037:  0x6144,
	3038:  0x6145,
	3039:  0x6146,
	3040:  0x6147,
	3041:  0x6149,
	3042:  0x614B,
	3043:  0x614D,
	3044:  0x614F,
	3045:  0x6150,
	3046:  0x6152,
	3047:  0x6153,
	3048:  0x6154,
	3049:  0x6156,
	3050:  0x6157,
	3051:  0x6158,
	3052:  0x6159,
	3053:  0x615A,
	3054:  0x615B,
	3055:  0x615C,
	3056:  0x615E,
	3057:  0x615F,
	3058:  0x6160,
	3059:  0x6161,
	3060:  0x6163,
	3061:  0x6164,
	3062:  0x6165,
	3063:  0x6166,
	3064:  0x6169,
	3065:  0x616A,
	3066:  0x616B,
	3067:  0x616C,
	3068:  0x616D,
	3069:  0x616E,
	3070:  0x616F,
	3071:  0x6171,
	3072:  0x6172,
	3073:  0x6173,
	3074:  0x6174,
	3075:  0x6176,
	3076:  0x6178,
	3077:  0x6179,
	3078:  0x617A,
	3079:  0x617B,
	3080:  0x617C,
	3081:  0x617D,
	3082:  0x617E,
	3083:  0x617F,
	3084:  0x6180,
	3085:  0x6181,
	3086:  0x6182,
	3087:  0x6183,
	3088:  0x6184,
	3089:  0x6185,
	3090:  0x6186,
	3091:  0x6187,
	3092:  0x6188,
	3093:  0x6189,
	3094:  0x618A,
	3095:  0x618C,
	3096:  0x618D,
	3097:  0x618F,
	3098:  0x6190,
	3099:  0x6191,
	3100:  0x6192,
	3101:  0x6193,
	3102:  0x6195,
	3103:  0x6196,
	3104:  0x6197,
	3105:  0x6198,
	3106:  0x6199,
	3107:  0x619A,
	3108:  0x619B,
	3109:  0x619C,
	3110:  0x619E,
	3111:  0x619F,
	3112:  0x61A0,
	3113:  0x61A1,
	3114:  0x61A2,
	3115:  0x61A3,
	3116:  0x61A4,
	3117:  0x61A5,
	3118:  0x61A6,
	3119:  0x61AA,
	3120:  0x61AB,
	3121:  0x61AD,
	3122:  0x61AE,
	3123:  0x61AF,
	3124:  0x61B0,
	3125:  0x61B1,
	3126:  0x61B2,
	3127:  0x61B3,
	3128:  0x61B4,
	3129:  0x61B5,
	3130:  0x61B6,
	3131:  0x61B8,
	3132:  0x61B9,
	3133:  0x61BA,
	3134:  0x61BB,
	3135:  0x61BC,
	3136:  0x61BD,
	3137:  0x61BF,
	3138:  0x61C0,
	3139:  0x61C1,
	3140:  0x61C3,
	3141:  0x61C4,
	3142:  0x61C5,
	3143:  0x61C6,
	3144:  0x61C7,
	3145:  0x61C9,
	3146:  0x61CC,
	3147:  0x61CD,
	3148:  0x61CE,
	3149:  0x61CF,
	3150:  0x61D0,
	3151:  0x61D3,
	3152:  0x61D5,
	3153:  0x61D6,
	3154:  0x61D7,
	3155:  0x61D8,
	3156:  0x61D9,
	3157:  0x61DA,
	3158:  0x61DB,
	3159:  0x61DC,
	3160:  0x61DD,
	3161:  0x61DE,
	3162:  0x61DF,
	3163:  0x61E0,
	3164:  0x61E1,
	3165:  0x61E2,
	3166:  0x61E3,
	3167:  0x61E4,
	3168:  0x61E5,
	3169:  0x61E7,
	3170:  0x61E8,
	3171:  0x61E9,
	3172:  0x61EA,
	3173:  0x61EB,
	3174:  0x61EC,
	3175:  0x61ED,
	3176:  0x61EE,
	3177:  0x61EF,
	3178:  0x61F0,
	3179:  0x61F1,
	3180:  0x61F2,
	3181:  0x61F3,
	3182:  0x61F4,
	3183:  0x61F6,
	3184:  0x61F7,
	3185:  0x61F8,
	3186:  0x61F9,
	3187:  0x61FA,
	3188:  0x61FB,
	3189:  0x61FC,
	3190:  0x61FD,
	3191:  0x61FE,
	3192:  0x6200,
	3193:  0x6201,
	3194:  0x6202,
	3195:  0x6203,
	3196:  0x6204,
	3197:  0x6205,
	3198:  0x6207,
	3199:  0x6209,
	3200:  0x6213,
	3201:  0x6214,
	3202:  0x6219,
	3203:  0x621C,
	3204:  0x621D,
	3205:  0x621E,
	3206:  0x6220,
	3207:  0x6223,
	3208:  0x6226,
	3209:  0x6227,
	3210:  0x6228,
	3211:  0x6229,
	3212:  0x622B,
	3213:  0x622D,
	3214:  0x622F,
	3215:  0x6230,
	3216:  0x6231,
	3217:  0x6232,
	3218:  0x6235,
	3219:  0x6236,
	3220:  0x6238,
	3221:  0x6239,
	3222:  0x623A,
	3223:  0x623B,
	3224:  0x623C,
	3225:  0x6242,
	3226:  0x6244,
	3227:  0x6245,
	3228:  0x6246,
	3229:  0x624A,
	3230:  0x624F,
	3231:  0x6250,
	3232:  0x6255,
	3233:  0x6256,
	3234:  0x6257,
	3235:  0x6259,
	3236:  0x625A,
	3237:  0x625C,
	3238:  0x625D,
	3239:  0x625E,
	3240:  0x625F,
	3241:  0x6260,
	3242:  0x6261,
	3243:  0x6262,
	3244:  0x6264,
	3245:  0x6265,
	3246:  0x6268,
	3247:  0x6271,
	3248:  0x6272,
	3249:  0x6274,
	3250:  0x6275,
	3251:  0x6277,
	3252:  0x6278,
	3253:  0x627A,
	3254:  0x627B,
	3255:  0x627D,
	3256:  0x6281,
	3257:  0x6282,
	3258:  0x6283,
	3259:  0x6285,
	3260:  0x6286,
	3261:  0x6287,
	3262:  0x6288,
	3263:  0x628B,
	3264:  0x628C,
	3265:  0x628D,
	3266:  0x628E,
	3267:  0x628F,
	3268:  0x6290,
	3269:  0x6294,
	3270:  0x6299,
	3271:  0x629C,
	3272:  0x629D,
	3273:  0x629E,
	3274:  0x62A3,
	3275:  0x62A6,
	3276:  0x62A7,
	3277:  0x62A9,
	3278:  0x62AA,
	3279:  0x62AD,
	3280:  0x62AE,
	3281:  0x62AF,
	3282:  0x62B0,
	3283:  0x62B2,
	3284:  0x62B3,
	3285:  0x62B4,
	3286:  0x62B6,
	3287:  0x62B7,
	3288:  0x62B8,
	3289:  0x62BA,
	3290:  0x62BE,
	3291:  0x62C0,
	3292:  0x62C1,
	3293:  0x62C3,
	3294:  0x62CB,
	3295:  0x62CF,
	3296:  0x62D1,
	3297:  0x62D5,
	3298:  0x62DD,
	3299:  0x62DE,
	3300:  0x62E0,
	3301:  0x62E1,
	3302:  0x62E4,
	3303:  0x62EA,
	3304:  0x62EB,
	3305:  0x62F0,
	3306:  0x62F2,
	3307:  0x62F5,
	3308:  0x62F8,
	3309:  0x62F9,
	3310:  0x62FA,
	3311:  0x62FB,
	3312:  0x6300,
	3313:  0x6303,
	3314:  0x6304,
	3315:  0x6305,
	3316:  0x6306,
	3317:  0x630A,
	3318:  0x630B,
	3319:  0x630C,
	3320:  0x630D,
	3321:  0x630F,
	3322:  0x6310,
	3323:  0x6312,
	3324:  0x6313,
	3325:  0x6314,
	3326:  0x6315,
	3327:  0x6317,
	3328:  0x6318,
	3329:  0x6319,
	3330:  0x631C,
	3331:  0x6326,
	3332:  0x6327,
	3333:  0x6329,
	3334:  0x632C,
	3335:  0x632D,
	3336:  0x632E,
	3337:  0x6330,
	3338:  0x6331,
	3339:  0x6333,
	3340:  0x6334,
	3341:  0x6335,
	3342:  0x6336,
	3343:  0x6337,
	3344:  0x6338,
	3345:  0x633B,
	3346:  0x633C,
	3347:  0x633E,
	3348:  0x633F,
	3349:  0x6340,
	3350:  0x6341,
	3351:  0x6344,
	3352:  0x6347,
	3353:  0x6348,
	3354:  0x634A,
	3355:  0x6351,
	3356:  0x6352,
	3357:  0x6353,
	3358:  0x6354,
	3359:  0x6356,
	3360:  0x6357,
	3361:  0x6358,
	3362:  0x6359,
	3363:  0x635A,
	3364:  0x635B,
	3365:  0x635C,
	3366:  0x635D,
	3367:  0x6360,
	3368:  0x6364,
	3369:  0x6365,
	3370:  0x6366,
	3371:  0x6368,
	3372:  0x636A,
	3373:  0x636B,
	3374:  0x636C,
	3375:  0x636F,
	3376:  0x6370,
	3377:  0x6372,
	3378:  0x6373,
	3379:  0x6374,
	3380:  0x6375,
	3381:  0x6378,
	3382:  0x6379,
	3383:  0x637C,
	3384:  0x637D,
	3385:  0x637E,
	3386:  0x637F,
	3387:  0x6381,
	3388:  0x6383,
	3389:  0x6384,
	3390:  0x6385,
	3391:  0x6386,
	3392:  0x638B,
	3393:  0x638D,
	3394:  0x6391,
	3395:  0x6393,
	3396:  0x6394,
	3397:  0x6395,
	3398:  0x6397,
	3399:  0x6399,
	3400:  0x639A,
	3401:  0x639B,
	3402:  0x639C,
	3403:  0x639D,
	3404:  0x639E,
	3405:  0x639F,
	3406:  0x63A1,
	3407:  0x63A4,
	3408:  0x63A6,
	3409:  0x63AB,
	3410:  0x63AF,
	3411:  0x63B1,
	3412:  0x63B2,
	3413:  0x63B5,
	3414:  0x63B6,
	3415:  0x63B9,
	3416:  0x63BB,
	3417:  0x63BD,
	3418:  0x63BF,
	3419:  0x63C0,
	3420:  0x63C1,
	3421:  0x63C2,
	3422:  0x63C3,
	3423:  0x63C5,
	3424:  0x63C7,
	3425:  0x63C8,
	3426:  0x63CA,
	3427:  0x63CB,
	3428:  0x63CC,
	3429:  0x63D1,
	3430:  0x63D3,
	3431:  0x63D4,
	3432:  0x63D5,
	3433:  0x63D7,
	3434:  0x63D8,
	3435:  0x63D9,
	3436:  0x63DA,
	3437:  0x63DB,
	3438:  0x63DC,
	3439:  0x63DD,
	3440:  0x63DF,
	3441:  0x63E2,
	3442:  0x63E4,
	3443:  0x63E5,
	3444:  0x63E6,
	3445:  0x63E7,
	3446:  0x63E8,
	3447:  0x63EB,
	3448:  0x63EC,
	3449:  0x63EE,
	3450:  0x63EF,
	3451:  0x63F0,
	3452:  0x63F1,
	3453:  0x63F3,
	3454:  0x63F5,
	3455:  0x63F7,
	3456:  0x63F9,
	3457:  0x63FA,
	3458:  0x63FB,
	3459:  0x63FC,
	3460:  0x63FE,
	3461:  0x6403,
	3462:  0x6404,
	3463:  0x6406,
	3464:  0x6407,
	3465:  0x6408,
	3466:  0x6409,
	3467:  0x640A,
	3468:  0x640D,
	3469:  0x640E,
	3470:  0x6411,
	3471:  0x6412,
	3472:  0x6415,
	3473:  0x6416,
	3474:  0x6417,
	3475:  0x6418,
	3476:  0x6419,
	3477:  0x641A,
	3478:  0x641D,
	3479:  0x641F,
	3480:  0x6422,
	3481:  0x6423,
	3482:  0x6424,
	3483:  0x6425,
	3484:  0x6427,
	3485:  0x6428,
	3486:  0x6429,
	3487:  0x642B,
	3488:  0x642E,
	3489:  0x642F,
	3490:  0x6430,
	3491:  0x6431,
	3492:  0x6432,
	3493:  0x6433,
	3494:  0x6435,
	3495:  0x6436,
	3496:  0x6437,
	3497:  0x6438,
	3498:  0x6439,
	3499:  0x643B,
	3500:  0x643C,
	3501:  0x643E,
	3502:  0x6440,
	3503:  0x6442,
	3504:  0x6443,
	3505:  0x6449,
	3506:  0x644B,
	3507:  0x644C,
	3508:  0x644D,
	3509:  0x644E,
	3510:  0x644F,
	3511:  0x6450,
	3512:  0x6451,
	3513:  0x6453,
	3514:  0x6455,
	3515:  0x6456,
	3516:  0x6457,
	3517:  0x6459,
	3518:  0x645A,
	3519:  0x645B,
	3520:  0x645C,
	3521:  0x645D,
	3522:  0x645F,
	3523:  0x6460,
	3524:  0x6461,
	3525:  0x6462,
	3526:  0x6463,
	3527:  0x6464,
	3528:  0x6465,
	3529:  0x6466,
	3530:  0x6468,
	3531:  0x646A,
	3532:  0x646B,
	3533:  0x646C,
	3534:  0x646E,
	3535:  0x646F,
	3536:  0x6470,
	3537:  0x6471,
	3538:  0x6472,
	3539:  0x6473,
	3540:  0x6474,
	3541:  0x6475,
	3542:  0x6476,
	3543:  0x6477,
	3544:  0x647B,
	3545:  0x647C,
	3546:  0x647D,
	3547:  0x647E,
	3548:  0x647F,
	3549:  0x6480,
	3550:  0x6481,
	3551:  0x6483,
	3552:  0x6486,
	3553:  0x6488,
	3554:  0x6489,
	3555:  0x648A,
	3556:  0x648B,
	3557:  0x648C,
	3558:  0x648D,
	3559:  0x648E,
	3560:  0x648F,
	3561:  0x6490,
	3562:  0x6493,
	3563:  0x6494,
	3564:  0x6497,
	3565:  0x6498,
	3566:  0x649A,
	3567:  0x649B,
	3568:  0x649C,
	3569:  0x649D,
	3570:  0x649F,
	3571:  0x64A0,
	3572:  0x64A1,
	3573:  0x64A2,
	3574:  0x64A3,
	3575:  0x64A5,
	3576:  0x64A6,
	3577:  0x64A7,
	3578:  0x64A8,
	3579:  0x64AA,
	3580:  0x64AB,
	3581:  0x64AF,
	3582:  0x64B1,
	3583:  0x64B2,
	3584:  0x64B3,
	3585:  0x64B4,
	3586:  0x64B6,
	3587:  0x64B9,
	3588:  0x64BB,
	3589:  0x64BD,
	3590:  0x64BE,
	3591:  0x64BF,
	3592:  0x64C1,
	3593:  0x64C3,
	3594:  0x64C4,
	3595:  0x64C6,
	3596:  0x64C7,
	3597:  0x64C8,
	3598:  0x64C9,
	3599:  0x64CA,
	3600:  0x64CB,
	3601:  0x64CC,
	3602:  0x64CF,
	3603:  0x64D1,
	3604:  0x64D3,
	3605:  0x64D4,
	3606:  0x64D5,
	3607:  0x64D6,
	3608:  0x64D9,
	3609:  0x64DA,
	3610:  0x64DB,
	3611:  0x64DC,
	3612:  0x64DD,
	3613:  0x64DF,
	3614:  0x64E0,
	3615:  0x64E1,
	3616:  0x64E3,
	3617:  0x64E5,
	3618:  0x64E7,
	3619:  0x64E8,
	3620:  0x64E9,
	3621:  0x64EA,
	3622:  0x64EB,
	3623:  0x64EC,
	3624:  0x64ED,
	3625:  0x64EE,
	3626:  0x64EF,
	3627:  0x64F0,
	3628:  0x64F1,
	3629:  0x64F2,
	3630:  0x64F3,
	3631:  0x64F4,
	3632:  0x64F5,
	3633:  0x64F6,
	3634:  0x64F7,
	3635:  0x64F8,
	3636:  0x64F9,
	3637:  0x64FA,
	3638:  0x64FB,
	3639:  0x64FC,
	3640:  0x64FD,
	3641:  0x64FE,
	3642:  0x64FF,
	3643:  0x6501,
	3644:  0x6502,
	3645:  0x6503,
	3646:  0x6504,
	3647:  0x6505,
	3648:  0x6506,
	3649:  0x6507,
	3650:  0x6508,
	3651:  0x650A,
	3652:  0x650B,
	3653:  0x650C,
	3654:  0x650D,
	3655:  0x650E,
	3656:  0x650F,
	3657:  0x6510,
	3658:  0x6511,
	3659:  0x6513,
	3660:  0x6514,
	3661:  0x6515,
	3662:  0x6516,
	3663:  0x6517,
	3664:  0x6519,
	3665:  0x651A,
	3666:  0x651B,
	3667:  0x651C,
	3668:  0x651D,
	3669:  0x651E,
	3670:  0x651F,
	3671:  0x6520,
	3672:  0x6521,
	3673:  0x6522,
	3674:  0x6523,
	3675:  0x6524,
	3676:  0x6526,
	3677:  0x6527,
	3678:  0x6528,
	3679:  0x6529,
	3680:  0x652A,
	3681:  0x652C,
	3682:  0x652D,
	3683:  0x6530,
	3684:  0x6531,
	3685:  0x6532,
	3686:  0x6533,
	3687:  0x6537,
	3688:  0x653A,
	3689:  0x653C,
	3690:  0x653D,
	3691:  0x6540,
	3692:  0x6541,
	3693:  0x6542,
	3694:  0x6543,
	3695:  0x6544,
	3696:  0x6546,
	3697:  0x6547,
	3698:  0x654A,
	3699:  0x654B,
	3700:  0x654D,
	3701:  0x654E,
	3702:  0x6550,
	3703:  0x6552,
	3704:  0x6553,
	3705:  0x6554,
	3706:  0x6557,
	3707:  0x6558,
	3708:  0x655A,
	3709:  0x655C,
	3710:  0x655F,
	3711:  0x6560,
	3712:  0x6561,
	3713:  0x6564,
	3714:  0x6565,
	3715:  0x6567,
	3716:  0x6568,
	3717:  0x6569,
	3718:  0x656A,
	3719:  0x656D,
	3720:  0x656E,
	3721:  0x656F,
	3722:  0x6571,
	3723:  0x6573,
	3724:  0x6575,
	3725:  0x6576,
	3726:  0x6578,
	3727:  0x6579,
	3728:  0x657A,
	3729:  0x657B,
	3730:  0x657C,
	3731:  0x657D,
	3732:  0x657E,
	3733:  0x657F,
	3734:  0x6580,
	3735:  0x6581,
	3736:  0x6582,
	3737:  0x6583,
	3738:  0x6584,
	3739:  0x6585,
	3740:  0x6586,
	3741:  0x6588,
	3742:  0x6589,
	3743:  0x658A,
	3744:  0x658D,
	3745:  0x658E,
	3746:  0x658F,
	3747:  0x6592,
	3748:  0x6594,
	3749:  0x6595,
	3750:  0x6596,
	3751:  0x6598,
	3752:  0x659A,
	3753:  0x659D,
	3754:  0x659E,
	3755:  0x65A0,
	3756:  0x65A2,
	3757:  0x65A3,
	3758:  0x65A6,
	3759:  0x65A8,
	3760:  0x65AA,
	3761:  0x65AC,
	3762:  0x65AE,
	3763:  0x65B1,
	3764:  0x65B2,
	3765:  0x65B3,
	3766:  0x65B4,
	3767:  0x65B5,
	3768:  0x65B6,
	3769:  0x65B7,
	3770:  0x65B8,
	3771:  0x65BA,
	3772:  0x65BB,
	3773:  0x65BE,
	3774:  0x65BF,
	3775:  0x65C0,
	3776:  0x65C2,
	3777:  0x65C7,
	3778:  0x65C8,
	3779:  0x65C9,
	3780:  0x65CA,
	3781:  0x65CD,
	3782:  0x65D0,
	3783:  0x65D1,
	3784:  0x65D3,
	3785:  0x65D4,
	3786:  0x65D5,
	3787:  0x65D8,
	3788:  0x65D9,
	3789:  0x65DA,
	3790:  0x65DB,
	3791:  0x65DC,
	3792:  0x65DD,
	3793:  0x65DE,
	3794:  0x65DF,
	3795:  0x65E1,
	3796:  0x65E3,
	3797:  0x65E4,
	3798:  0x65EA,
	3799:  0x65EB,
	3800:  0x65F2,
	3801:  0x65F3,
	3802:  0x65F4,
	3803:  0x65F5,
	3804:  0x65F8,
	3805:  0x65F9,
	3806:  0x65FB,
	3807:  0x65FC,
	3808:  0x65FD,
	3809:  0x65FE,
	3810:  0x65FF,
	3811:  0x6601,
	3812:  0x6604,
	3813:  0x6605,
	3814:  0x6607,
	3815:  0x6608,
	3816:  0x6609,
	3817:  0x660B,
	3818:  0x660D,
	3819:  0x6610,
	3820:  0x6611,
	3821:  0x6612,
	3822:  0x6616,
	3823:  0x6617,
	3824:  0x6618,
	3825:  0x661A,
	3826:  0x661B,
	3827:  0x661C,
	3828:  0x661E,
	3829:  0x6621,
	3830:  0x6622,
	3831:  0x6623,
	3832:  0x6624,
	3833:  0x6626,
	3834:  0x6629,
	3835:  0x662A,
	3836:  0x662B,
	3837:  0x662C,
	3838:  0x662E,
	3839:  0x6630,
	3840:  0x6632,
	3841:  0x6633,
	3842:  0x6637,
	3843:  0x6638,
	3844:  0x6639,
	3845:  0x663A,
	3846:  0x663B,
	3847:  0x663D,
	3848:  0x663F,
	3849:  0x6640,
	3850:  0x6642,
	3851:  0x6644,
	3852:  0x6645,
	3853:  0x6646,
	3854:  0x6647,
	3855:  0x6648,
	3856:  0x6649,
	3857:  0x664A,
	3858:  0x664D,
	3859:  0x664E,
	3860:  0x6650,
	3861:  0x6651,
	3862:  0x6658,
	3863:  0x6659,
	3864:  0x665B,
	3865:  0x665C,
	3866:  0x665D,
	3867:  0x665E,
	3868:  0x6660,
	3869:  0x6662,
	3870:  0x6663,
	3871:  0x6665,
	3872:  0x6667,
	3873:  0x6669,
	3874:  0x666A,
	3875:  0x666B,
	3876:  0x666C,
	3877:  0x666D,
	3878:  0x6671,
	3879:  0x6672,
	3880:  0x6673,
	3881:  0x6675,
	3882:  0x6678,
	3883:  0x6679,
	3884:  0x667B,
	3885:  0x667C,
	3886:  0x667D,
	3887:  0x667F,
	3888:  0x6680,
	3889:  0x6681,
	3890:  0x6683,
	3891:  0x6685,
	3892:  0x6686,
	3893:  0x6688,
	3894:  0x6689,
	3895:  0x668A,
	3896:  0x668B,
	3897:  0x668D,
	3898:  0x668E,
	3899:  0x668F,
	3900:  0x6690,
	3901:  0x6692,
	3902:  0x6693,
	3903:  0x6694,
	3904:  0x6695,
	3905:  0x6698,
	3906:  0x6699,
	3907:  0x669A,
	3908:  0x669B,
	3909:  0x669C,
	3910:  0x669E,
	3911:  0x669F,
	3912:  0x66A0,
	3913:  0x66A1,
	3914:  0x66A2,
	3915:  0x66A3,
	3916:  0x66A4,
	3917:  0x66A5,
	3918:  0x66A6,
	3919:  0x66A9,
	3920:  0x66AA,
	3921:  0x66AB,
	3922:  0x66AC,
	3923:  0x66AD,
	3924:  0x66AF,
	3925:  0x66B0,
	3926:  0x66B1,
	3927:  0x66B2,
	3928:  0x66B3,
	3929:  0x66B5,
	3930:  0x66B6,
	3931:  0x66B7,
	3932:  0x66B8,
	3933:  0x66BA,
	3934:  0x66BB,
	3935:  0x66BC,
	3936:  0x66BD,
	3937:  0x66BF,
	3938:  0x66C0,
	3939:  0x66C1,
	3940:  0x66C2,
	3941:  0x66C3,
	3942:  0x66C4,
	3943:  0x66C5,
	3944:  0x66C6,
	3945:  0x66C7,
	3946:  0x66C8,
	3947:  0x66C9,
	3948:  0x66CA,
	3949:  0x66CB,
	3950:  0x66CC,
	3951:  0x66CD,
	3952:  0x66CE,
	3953:  0x66CF,
	3954:  0x66D0,
	3955:  0x66D1,
	3956:  0x66D2,
	3957:  0x66D3,
	3958:  0x66D4,
	3959:  0x66D5,
	3960:  0x66D6,
	3961:  0x66D7,
	3962:  0x66D8,
	3963:  0x66DA,
	3964:  0x66DE,
	3965:  0x66DF,
	3966:  0x66E0,
	3967:  0x66E1,
	3968:  0x66E2,
	3969:  0x66E3,
	3970:  0x66E4,
	3971:  0x66E5,
	3972:  0x66E7,
	3973:  0x66E8,
	3974:  0x66EA,
	3975:  0x66EB,
	3976:  0x66EC,
	3977:  0x66ED,
	3978:  0x66EE,
	3979:  0x66EF,
	3980:  0x66F1,
	3981:  0x66F5,
	3982:  0x66F6,
	3983:  0x66F8,
	3984:  0x66FA,
	3985:  0x66FB,
	3986:  0x66FD,
	3987:  0x6701,
	3988:  0x6702,
	3989:  0x6703,
	3990:  0x6704,
	3991:  0x6705,
	3992:  0x6706,
	3993:  0x6707,
	3994:  0x670C,
	3995:  0x670E,
	3996:  0x670F,
	3997:  0x6711,
	3998:  0x6712,
	3999:  0x6713,
	4000:  0x6716,
	4001:  0x6718,
	4002:  0x6719,
	4003:  0x671A,
	4004:  0x671C,
	4005:  0x671E,
	4006:  0x6720,
	4007:  0x6721,
	4008:  0x6722,
	4009:  0x6723,
	4010:  0x6724,
	4011:  0x6725,
	4012:  0x6727,
	4013:  0x6729,
	4014:  0x672E,
	4015:  0x6730,
	4016:  0x6732,
	4017:  0x6733,
	4018:  0x6736,
	4019:  0x6737,
	4020:  0x6738,
	4021:  0x6739,
	4022:  0x673B,
	4023:  0x673C,
	4024:  0x673E,
	4025:  0x673F,
	4026:  0x6741,
	4027:  0x6744,
	4028:  0x6745,
	4029:  0x6747,
	4030:  0x674A,
	4031:  0x674B,
	4032:  0x674D,
	4033:  0x6752,
	4034:  0x6754,
	4035:  0x6755,
	4036:  0x6757,
	4037:  0x6758,
	4038:  0x6759,
	4039:  0x675A,
	4040:  0x675B,
	4041:  0x675D,
	4042:  0x6762,
	4043:  0x6763,
	4044:  0x6764,
	4045:  0x6766,
	4046:  0x6767,
	4047:  0x676B,
	4048:  0x676C,
	4049:  0x676E,
	4050:  0x6771,
	4051:  0x6774,
	4052:  0x6776,
	4053:  0x6778,
	4054:  0x6779,
	4055:  0x677A,
	4056:  0x677B,
	4057:  0x677D,
	4058:  0x6780,
	4059:  0x6782,
	4060:  0x6783,
	4061:  0x6785,
	4062:  0x6786,
	4063:  0x6788,
	4064:  0x678A,
	4065:  0x678C,
	4066:  0x678D,
	4067:  0x678E,
	4068:  0x678F,
	4069:  0x6791,
	4070:  0x6792,
	4071:  0x6793,
	4072:  0x6794,
	4073:  0x6796,
	4074:  0x6799,
	4075:  0x679B,
	4076:  0x679F,
	4077:  0x67A0,
	4078:  0x67A1,
	4079:  0x67A4,
	4080:  0x67A6,
	4081:  0x67A9,
	4082:  0x67AC,
	4083:  0x67AE,
	4084:  0x67B1,
	4085:  0x67B2,
	4086:  0x67B4,
	4087:  0x67B9,
	4088:  0x67BA,
	4089:  0x67BB,
	4090:  0x67BC,
	4091:  0x67BD,
	4092:  0x67BE,
	4093:  0x67BF,
	4094:  0x67C0,
	4095:  0x67C2,
	4096:  0x67C5,
	4097:  0x67C6,
	4098:  0x67C7,
	4099:  0x67C8,
	4100:  0x67C9,
	4101:  0x67CA,
	4102:  0x67CB,
	4103:  0x67CC,
	4104:  0x67CD,
	4105:  0x67CE,
	4106:  0x67D5,
	4107:  0x67D6,
	4108:  0x67D7,
	4109:  0x67DB,
	4110:  0x67DF,
	4111:  0x67E1,
	4112:  0x67E3,
	4113:  0x67E4,
	4114:  0x67E6,
	4115:  0x67E7,
	4116:  0x67E8,
	4117:  0x67EA,
	4118:  0x67EB,
	4119:  0x67ED,
	4120:  0x67EE,
	4121:  0x67F2,
	4122:  0x67F5,
	4123:  0x67F6,
	4124:  0x67F7,
	4125:  0x67F8,
	4126:  0x67F9,
	4127:  0x67FA,
	4128:  0x67FB,
	4129:  0x67FC,
	4130:  0x67FE,
	4131:  0x6801,
	4132:  0x6802,
	4133:  0x6803,
	4134:  0x6804,
	4135:  0x6806,
	4136:  0x680D,
	4137:  0x6810,
	4138:  0x6812,
	4139:  0x6814,
	4140:  0x6815,
	4141:  0x6818,
	4142:  0x6819,
	4143:  0x681A,
	4144:  0x681B,
	4145:  0x681C,
	4146:  0x681E,
	4147:  0x681F,
	4148:  0x6820,
	4149:  0x6822,
	4150:  0x6823,
	4151:  0x6824,
	4152:  0x6825,
	4153:  0x6826,
	4154:  0x6827,
	4155:  0x6828,
	4156:  0x682B,
	4157:  0x682C,
	4158:  0x682D,
	4159:  0x682E,
	4160:  0x682F,
	4161:  0x6830,
	4162:  0x6831,
	4163:  0x6834,
	4164:  0x6835,
	4165:  0x6836,
	4166:  0x683A,
	4167:  0x683B,
	4168:  0x683F,
	4169:  0x6847,
	4170:  0x684B,
	4171:  0x684D,
	4172:  0x684F,
	4173:  0x6852,
	4174:  0x6856,
	4175:  0x6857,
	4176:  0x6858,
	4177:  0x6859,
	4178:  0x685A,
	4179:  0x685B,
	4180:  0x685C,
	4181:  0x685D,
	4182:  0x685E,
	4183:  0x685F,
	4184:  0x686A,
	4185:  0x686C,
	4186:  0x686D,
	4187:  0x686E,
	4188:  0x686F,
	4189:  0x6870,
	4190:  0x6871,
	4191:  0x6872,
	4192:  0x6873,
	4193:  0x6875,
	4194:  0x6878,
	4195:  0x6879,
	4196:  0x687A,
	4197:  0x687B,
	4198:  0x687C,
	4199:  0x687D,
	4200:  0x687E,
	4201:  0x687F,
	4202:  0x6880,
	4203:  0x6882,
	4204:  0x6884,
	4205:  0x6887,
	4206:  0x6888,
	4207:  0x6889,
	4208:  0x688A,
	4209:  0x688B,
	4210:  0x688C,
	4211:  0x688D,
	4212:  0x688E,
	4213:  0x6890,
	4214:  0x6891,
	4215:  0x6892,
	4216:  0x6894,
	4217:  0x6895,
	4218:  0x6896,
	4219:  0x6898,
	4220:  0x6899,
	4221:  0x689A,
	4222:  0x689B,
	4223:  0x689C,
	4224:  0x689D,
	4225:  0x689E,
	4226:  0x689F,
	4227:  0x68A0,
	4228:  0x68A1,
	4229:  0x68A3,
	4230:  0x68A4,
	4231:  0x68A5,
	4232:  0x68A9,
	4233:  0x68AA,
	4234:  0x68AB,
	4235:  0x68AC,
	4236:  0x68AE,
	4237:  0x68B1,
	4238:  0x68B2,
	4239:  0x68B4,
	4240:  0x68B6,
	4241:  0x68B7,
	4242:  0x68B8,
	4243:  0x68B9,
	4244:  0x68BA,
	4245:  0x68BB,
	4246:  0x68BC,
	4247:  0x68BD,
	4248:  0x68BE,
	4249:  0x68BF,
	4250:  0x68C1,
	4251:  0x68C3,
	4252:  0x68C4,
	4253:  0x68C5,
	4254:  0x68C6,
	4255:  0x68C7,
	4256:  0x68C8,
	4257:  0x68CA,
	4258:  0x68CC,
	4259:  0x68CE,
	4260:  0x68CF,
	4261:  0x68D0,
	4262:  0x68D1,
	4263:  0x68D3,
	4264:  0x68D4,
	4265:  0x68D6,
	4266:  0x68D7,
	4267:  0x68D9,
	4268:  0x68DB,
	4269:  0x68DC,
	4270:  0x68DD,
	4271:  0x68DE,
	4272:  0x68DF,
	4273:  0x68E1,
	4274:  0x68E2,
	4275:  0x68E4,
	4276:  0x68E5,
	4277:  0x68E6,
	4278:  0x68E7,
	4279:  0x68E8,
	4280:  0x68E9,
	4281:  0x68EA,
	4282:  0x68EB,
	4283:  0x68EC,
	4284:  0x68ED,
	4285:  0x68EF,
	4286:  0x68F2,
	4287:  0x68F3,
	4288:  0x68F4,
	4289:  0x68F6,
	4290:  0x68F7,
	4291:  0x68F8,
	4292:  0x68FB,
	4293:  0x68FD,
	4294:  0x68FE,
	4295:  0x68FF,
	4296:  0x6900,
	4297:  0x6902,
	4298:  0x6903,
	4299:  0x6904,
	4300:  0x6906,
	4301:  0x6907,
	4302:  0x6908,
	4303:  0x6909,
	4304:  0x690A,
	4305:  0x690C,
	4306:  0x690F,
	4307:  0x6911,
	4308:  0x6913,
	4309:  0x6914,
	4310:  0x6915,
	4311:  0x6916,
	4312:  0x6917,
	4313:  0x6918,
	4314:  0x6919,
	4315:  0x691A,
	4316:  0x691B,
	4317:  0x691C,
	4318:  0x691D,
	4319:  0x691E,
	4320:  0x6921,
	4321:  0x6922,
	4322:  0x6923,
	4323:  0x6925,
	4324:  0x6926,
	4325:  0x6927,
	4326:  0x6928,
	4327:  0x6929,
	4328:  0x692A,
	4329:  0x692B,
	4330:  0x692C,
	4331:  0x692E,
	4332:  0x692F,
	4333:  0x6931,
	4334:  0x6932,
	4335:  0x6933,
	4336:  0x6935,
	4337:  0x6936,
	4338:  0x6937,
	4339:  0x6938,
	4340:  0x693A,
	4341:  0x693B,
	4342:  0x693C,
	4343:  0x693E,
	4344:  0x6940,
	4345:  0x6941,
	4346:  0x6943,
	4347:  0x6944,
	4348:  0x6945,
	4349:  0x6946,
	4350:  0x6947,
	4351:  0x6948,
	4352:  0x6949,
	4353:  0x694A,
	4354:  0x694B,
	4355:  0x694C,
	4356:  0x694D,
	4357:  0x694E,
	4358:  0x694F,
	4359:  0x6950,
	4360:  0x6951,
	4361:  0x6952,
	4362:  0x6953,
	4363:  0x6955,
	4364:  0x6956,
	4365:  0x6958,
	4366:  0x6959,
	4367:  0x695B,
	4368:  0x695C,
	4369:  0x695F,
	4370:  0x6961,
	4371:  0x6962,
	4372:  0x6964,
	4373:  0x6965,
	4374:  0x6967,
	4375:  0x6968,
	4376:  0x6969,
	4377:  0x696A,
	4378:  0x696C,
	4379:  0x696D,
	4380:  0x696F,
	4381:  0x6970,
	4382:  0x6972,
	4383:  0x6973,
	4384:  0x6974,
	4385:  0x6975,
	4386:  0x6976,
	4387:  0x697A,
	4388:  0x697B,
	4389:  0x697D,
	4390:  0x697E,
	4391:  0x697F,
	4392:  0x6981,
	4393:  0x6983,
	4394:  0x6985,
	4395:  0x698A,
	4396:  0x698B,
	4397:  0x698C,
	4398:  0x698E,
	4399:  0x698F,
	4400:  0x6990,
	4401:  0x6991,
	4402:  0x6992,
	4403:  0x6993,
	4404:  0x6996,
	4405:  0x6997,
	4406:  0x6999,
	4407:  0x699A,
	4408:  0x699D,
	4409:  0x699E,
	4410:  0x699F,
	4411:  0x69A0,
	4412:  0x69A1,
	4413:  0x69A2,
	4414:  0x69A3,
	4415:  0x69A4,
	4416:  0x69A5,
	4417:  0x69A6,
	4418:  0x69A9,
	4419:  0x69AA,
	4420:  0x69AC,
	4421:  0x69AE,
	4422:  0x69AF,
	4423:  0x69B0,
	4424:  0x69B2,
	4425:  0x69B3,
	4426:  0x69B5,
	4427:  0x69B6,
	4428:  0x69B8,
	4429:  0x69B9,
	4430:  0x69BA,
	4431:  0x69BC,
	4432:  0x69BD,
	4433:  0x69BE,
	4434:  0x69BF,
	4435:  0x69C0,
	4436:  0x69C2,
	4437:  0x69C3,
	4438:  0x69C4,
	4439:  0x69C5,
	4440:  0x69C6,
	4441:  0x69C7,
	4442:  0x69C8,
	4443:  0x69C9,
	4444:  0x69CB,
	4445:  0x69CD,
	4446:  0x69CF,
	4447:  0x69D1,
	4448:  0x69D2,
	4449:  0x69D3,
	4450:  0x69D5,
	4451:  0x69D6,
	4452:  0x69D7,
	4453:  0x69D8,
	4454:  0x69D9,
	4455:  0x69DA,
	4456:  0x69DC,
	4457:  0x69DD,
	4458:  0x69DE,
	4459:  0x69E1,
	4460:  0x69E2,
	4461:  0x69E3,
	4462:  0x69E4,
	4463:  0x69E5,
	4464:  0x69E6,
	4465:  0x69E7,
	4466:  0x69E8,
	4467:  0x69E9,
	4468:  0x69EA,
	4469:  0x69EB,
	4470:  0x69EC,
	4471:  0x69EE,
	4472:  0x69EF,
	4473:  0x69F0,
	4474:  0x69F1,
	4475:  0x69F3,
	4476:  0x69F4,
	4477:  0x69F5,
	4478:  0x69F6,
	4479:  0x69F7,
	4480:  0x69F8,
	4481:  0x69F9,
	4482:  0x69FA,
	4483:  0x69FB,
	4484:  0x69FC,
	4485:  0x69FE,
	4486:  0x6A00,
	4487:  0x6A01,
	4488:  0x6A02,
	4489:  0x6A03,
	4490:  0x6A04,
	4491:  0x6A05,
	4492:  0x6A06,
	4493:  0x6A07,
	4494:  0x6A08,
	4495:  0x6A09,
	4496:  0x6A0B,
	4497:  0x6A0C,
	4498:  0x6A0D,
	4499:  0x6A0E,
	4500:  0x6A0F,
	4501:  0x6A10,
	4502:  0x6A11,
	4503:  0x6A12,
	4504:  0x6A13,
	4505:  0x6A14,
	4506:  0x6A15,
	4507:  0x6A16,
	4508:  0x6A19,
	4509:  0x6A1A,
	4510:  0x6A1B,
	4511:  0x6A1C,
	4512:  0x6A1D,
	4513:  0x6A1E,
	4514:  0x6A20,
	4515:  0x6A22,
	4516:  0x6A23,
	4517:  0x6A24,
	4518:  0x6A25,
	4519:  0x6A26,
	4520:  0x6A27,
	4521:  0x6A29,
	4522:  0x6A2B,
	4523:  0x6A2C,
	4524:  0x6A2D,
	4525:  0x6A2E,
	4526:  0x6A30,
	4527:  0x6A32,
	4528:  0x6A33,
	4529:  0x6A34,
	4530:  0x6A36,
	4531:  0x6A37,
	4532:  0x6A38,
	4533:  0x6A39,
	4534:  0x6A3A,
	4535:  0x6A3B,
	4536:  0x6A3C,
	4537:  0x6A3F,
	4538:  0x6A40,
	4539:  0x6A41,
	4540:  0x6A42,
	4541:  0x6A43,
	4542:  0x6A45,
	4543:  0x6A46,
	4544:  0x6A48,
	4545:  0x6A49,
	4546:  0x6A4A,
	4547:  0x6A4B,
	4548:  0x6A4C,
	4549:  0x6A4D,
	4550:  0x6A4E,
	4551:  0x6A4F,
	4552:  0x6A51,
	4553:  0x6A52,
	4554:  0x6A53,
	4555:  0x6A54,
	4556:  0x6A55,
	4557:  0x6A56,
	4558:  0x6A57,
	4559:  0x6A5A,
	4560:  0x6A5C,
	4561:  0x6A5D,
	4562:  0x6A5E,
	4563:  0x6A5F,
	4564:  0x6A60,
	4565:  0x6A62,
	4566:  0x6A63,
	4567:  0x6A64,
	4568:  0x6A66,
	4569:  0x6A67,
	4570:  0x6A68,
	4571:  0x6A69,
	4572:  0x6A6A,
	4573:  0x6A6B,
	4574:  0x6A6C,
	4575:  0x6A6D,
	4576:  0x6A6E,
	4577:  0x6A6F,
	4578:  0x6A70,
	4579:  0x6A72,
	4580:  0x6A73,
	4581:  0x6A74,
	4582:  0x6A75,
	4583:  0x6A76,
	4584:  0x6A77,
	4585:  0x6A78,
	4586:  0x6A7A,
	4587:  0x6A7B,
	4588:  0x6A7D,
	4589:  0x6A7E,
	4590:  0x6A7F,
	4591:  0x6A81,
	4592:  0x6A82,
	4593:  0x6A83,
	4594:  0x6A85,
	4595:  0x6A86,
	4596:  0x6A87,
	4597:  0x6A88,
	4598:  0x6A89,
	4599:  0x6A8A,
	4600:  0x6A8B,
	4601:  0x6A8C,
	4602:  0x6A8D,
	4603:  0x6A8F,
	4604:  0x6A92,
	4605:  0x6A93,
	4606:  0x6A94,
	4607:  0x6A95,
	4608:  0x6A96,
	4609:  0x6A98,
	4610:  0x6A99,
	4611:  0x6A9A,
	4612:  0x6A9B,
	4613:  0x6A9C,
	4614:  0x6A9D,
	4615:  0x6A9E,
	4616:  0x6A9F,
	4617:  0x6AA1,
	4618:  0x6AA2,
	4619:  0x6AA3,
	4620:  0x6AA4,
	4621:  0x6AA5,
	4622:  0x6AA6,
	4623:  0x6AA7,
	4624:  0x6AA8,
	4625:  0x6AAA,
	4626:  0x6AAD,
	4627:  0x6AAE,
	4628:  0x6AAF,
	4629:  0x6AB0,
	4630:  0x6AB1,
	4631:  0x6AB2,
	4632:  0x6AB3,
	4633:  0x6AB4,
	4634:  0x6AB5,
	4635:  0x6AB6,
	4636:  0x6AB7,
	4637:  0x6AB8,
	4638:  0x6AB9,
	4639:  0x6ABA,
	4640:  0x6ABB,
	4641:  0x6ABC,
	4642:  0x6ABD,
	4643:  0x6ABE,
	4644:  0x6ABF,
	4645:  0x6AC0,
	4646:  0x6AC1,
	4647:  0x6AC2,
	4648:  0x6AC3,
	4649:  0x6AC4,
	4650:  0x6AC5,
	4651:  0x6AC6,
	4652:  0x6AC7,
	4653:  0x6AC8,
	4654:  0x6AC9,
	4655:  0x6ACA,
	4656:  0x6ACB,
	4657:  0x6ACC,
	4658:  0x6ACD,
	4659:  0x6ACE,
	4660:  0x6ACF,
	4661:  0x6AD0,
	4662:  0x6AD1,
	4663:  0x6AD2,
	4664:  0x6AD3,
	4665:  0x6AD4,
	4666:  0x6AD5,
	4667:  0x6AD6,
	4668:  0x6AD7,
	4669:  0x6AD8,
	4670:  0x6AD9,
	4671:  0x6ADA,
	4672:  0x6ADB,
	4673:  0x6ADC,
	4674:  0x6ADD,
	4675:  0x6ADE,
	4676:  0x6ADF,
	4677:  0x6AE0,
	4678:  0x6AE1,
	4679:  0x6AE2,
	4680:  0x6AE3,
	4681:  0x6AE4,
	4682:  0x6AE5,
	4683:  0x6AE6,
	4684:  0x6AE7,
	4685:  0x6AE8,
	4686:  0x6AE9,
	4687:  0x6AEA,
	4688:  0x6AEB,
	4689:  0x6AEC,
	4690:  0x6AED,
	4691:  0x6AEE,
	4692:  0x6AEF,
	4693:  0x6AF0,
	4694:  0x6AF1,
	4695:  0x6AF2,
	4696:  0x6AF3,
	4697:  0x6AF4,
	4698:  0x6AF5,
	4699:  0x6AF6,
	4700:  0x6AF7,
	4701:  0x6AF8,
	4702:  0x6AF9,
	4703:  0x6AFA,
	4704:  0x6AFB,
	4705:  0x6AFC,
	4706:  0x6AFD,
	4707:  0x6AFE,
	4708:  0x6AFF,
	4709:  0x6B00,
	4710:  0x6B01,
	4711:  0x6B02,
	4712:  0x6B03,
	4713:  0x6B04,
	4714:  0x6B05,
	4715:  0x6B06,
	4716:  0x6B07,
	4717:  0x6B08,
	4718:  0x6B09,
	4719:  0x6B0A,
	4720:  0x6B0B,
	4721:  0x6B0C,
	4722:  0x6B0D,
	4723:  0x6B0E,
	4724:  0x6B0F,
	4725:  0x6B10,
	4726:  0x6B11,
	4727:  0x6B12,
	4728:  0x6B13,
	4729:  0x6B14,
	4730:  0x6B15,
	4731:  0x6B16,
	4732:  0x6B17,
	4733:  0x6B18,
	4734:  0x6B19,
	4735:  0x6B1A,
	4736:  0x6B1B,
	4737:  0x6B1C,
	4738:  0x6B1D,
	4739:  0x6B1E,
	4740:  0x6B1F,
	4741:  0x6B25,
	4742:  0x6B26,
	4743:  0x6B28,
	4744:  0x6B29,
	4745:  0x6B2A,
	4746:  0x6B2B,
	4747:  0x6B2C,
	4748:  0x6B2D,
	4749:  0x6B2E,
	4750:  0x6B2F,
	4751:  0x6B30,
	4752:  0x6B31,
	4753:  0x6B33,
	4754:  0x6B34,
	4755:  0x6B35,
	4756:  0x6B36,
	4757:  0x6B38,
	4758:  0x6B3B,
	4759:  0x6B3C,
	4760:  0x6B3D,
	4761:  0x6B3F,
	4762:  0x6B40,
	4763:  0x6B41,
	4764:  0x6B42,
	4765:  0x6B44,
	4766:  0x6B45,
	4767:  0x6B48,
	4768:  0x6B4A,
	4769:  0x6B4B,
	4770:  0x6B4D,
	4771:  0x6B4E,
	4772:  0x6B4F,
	4773:  0x6B50,
	4774:  0x6B51,
	4775:  0x6B52,
	4776:  0x6B53,
	4777:  0x6B54,
	4778:  0x6B55,
	4779:  0x6B56,
	4780:  0x6B57,
	4781:  0x6B58,
	4782:  0x6B5A,
	4783:  0x6B5B,
	4784:  0x6B5C,
	4785:  0x6B5D,
	4786:  0x6B5E,
	4787:  0x6B5F,
	4788:  0x6B60,
	4789:  0x6B61,
	4790:  0x6B68,
	4791:  0x6B69,
	4792:  0x6B6B,
	4793:  0x6B6C,
	4794:  0x6B6D,
	4795:  0x6B6E,
	4796:  0x6B6F,
	4797:  0x6B70,
	4798:  0x6B71,
	4799:  0x6B72,
	4800:  0x6B73,
	4801:  0x6B74,
	4802:  0x6B75,
	4803:  0x6B76,
	4804:  0x6B77,
	4805:  0x6B78,
	4806:  0x6B7A,
	4807:  0x6B7D,
	4808:  0x6B7E,
	4809:  0x6B7F,
	4810:  0x6B80,
	4811:  0x6B85,
	4812:  0x6B88,
	4813:  0x6B8C,
	4814:  0x6B8E,
	4815:  0x6B8F,
	4816:  0x6B90,
	4817:  0x6B91,
	4818:  0x6B94,
	4819:  0x6B95,
	4820:  0x6B97,
	4821:  0x6B98,
	4822:  0x6B99,
	4823:  0x6B9C,
	4824:  0x6B9D,
	4825:  0x6B9E,
	4826:  0x6B9F,
	4827:  0x6BA0,
	4828:  0x6BA2,
	4829:  0x6BA3,
	4830:  0x6BA4,
	4831:  0x6BA5,
	4832:  0x6BA6,
	4833:  0x6BA7,
	4834:  0x6BA8,
	4835:  0x6BA9,
	4836:  0x6BAB,
	4837:  0x6BAC,
	4838:  0x6BAD,
	4839:  0x6BAE,
	4840:  0x6BAF,
	4841:  0x6BB0,
	4842:  0x6BB1,
	4843:  0x6BB2,
	4844:  0x6BB6,
	4845:  0x6BB8,
	4846:  0x6BB9,
	4847:  0x6BBA,
	4848:  0x6BBB,
	4849:  0x6BBC,
	4850:  0x6BBD,
	4851:  0x6BBE,
	4852:  0x6BC0,
	4853:  0x6BC3,
	4854:  0x6BC4,
	4855:  0x6BC6,
	4856:  0x6BC7,
	4857:  0x6BC8,
	4858:  0x6BC9,
	4859:  0x6BCA,
	4860:  0x6BCC,
	4861:  0x6BCE,
	4862:  0x6BD0,
	4863:  0x6BD1,
	4864:  0x6BD8,
	4865:  0x6BDA,
	4866:  0x6BDC,
	4867:  0x6BDD,
	4868:  0x6BDE,
	4869:  0x6BDF,
	4870:  0x6BE0,
	4871:  0x6BE2,
	4872:  0x6BE3,
	4873:  0x6BE4,
	4874:  0x6BE5,
	4875:  0x6BE6,
	4876:  0x6BE7,
	4877:  0x6BE8,
	4878:  0x6BE9,
	4879:  0x6BEC,
	4880:  0x6BED,
	4881:  0x6BEE,
	4882:  0x6BF0,
	4883:  0x6BF1,
	4884:  0x6BF2,
	4885:  0x6BF4,
	4886:  0x6BF6,
	4887:  0x6BF7,
	4888:  0x6BF8,
	4889:  0x6BFA,
	4890:  0x6BFB,
	4891:  0x6BFC,
	4892:  0x6BFE,
	4893:  0x6BFF,
	4894:  0x6C00,
	4895:  0x6C01,
	4896:  0x6C02,
	4897:  0x6C03,
	4898:  0x6C04,
	4899:  0x6C08,
	4900:  0x6C09,
	4901:  0x6C0A,
	4902:  0x6C0B,
	4903:  0x6C0C,
	4904:  0x6C0E,
	4905:  0x6C12,
	4906:  0x6C17,
	4907:  0x6C1C,
	4908:  0x6C1D,
	4909:  0x6C1E,
	4910:  0x6C20,
	4911:  0x6C23,
	4912:  0x6C25,
	4913:  0x6C2B,
	4914:  0x6C2C,
	4915:  0x6C2D,
	4916:  0x6C31,
	4917:  0x6C33,
	4918:  0x6C36,
	4919:  0x6C37,
	4920:  0x6C39,
	4921:  0x6C3A,
	4922:  0x6C3B,
	4923:  0x6C3C,
	4924:  0x6C3E,
	4925:  0x6C3F,
	4926:  0x6C43,
	4927:  0x6C44,
	4928:  0x6C45,
	4929:  0x6C48,
	4930:  0x6C4B,
	4931:  0x6C4C,
	4932:  0x6C4D,
	4933:  0x6C4E,
	4934:  0x6C4F,
	4935:  0x6C51,
	4936:  0x6C52,
	4937:  0x6C53,
	4938:  0x6C56,
	4939:  0x6C58,
	4940:  0x6C59,
	4941:  0x6C5A,
	4942:  0x6C62,
	4943:  0x6C63,
	4944:  0x6C65,
	4945:  0x6C66,
	4946:  0x6C67,
	4947:  0x6C6B,
	4948:  0x6C6C,
	4949:  0x6C6D,
	4950:  0x6C6E,
	4951:  0x6C6F,
	4952:  0x6C71,
	4953:  0x6C73,
	4954:  0x6C75,
	4955:  0x6C77,
	4956:  0x6C78,
	4957:  0x6C7A,
	4958:  0x6C7B,
	4959:  0x6C7C,
	4960:  0x6C7F,
	4961:  0x6C80,
	4962:  0x6C84,
	4963:  0x6C87,
	4964:  0x6C8A,
	4965:  0x6C8B,
	4966:  0x6C8D,
	4967:  0x6C8E,
	4968:  0x6C91,
	4969:  0x6C92,
	4970:  0x6C95,
	4971:  0x6C96,
	4972:  0x6C97,
	4973:  0x6C98,
	4974:  0x6C9A,
	4975:  0x6C9C,
	4976:  0x6C9D,
	4977:  0x6C9E,
	4978:  0x6CA0,
	4979:  0x6CA2,
	4980:  0x6CA8,
	4981:  0x6CAC,
	4982:  0x6CAF,
	4983:  0x6CB0,
	4984:  0x6CB4,
	4985:  0x6CB5,
	4986:  0x6CB6,
	4987:  0x6CB7,
	4988:  0x6CBA,
	4989:  0x6CC0,
	4990:  0x6CC1,
	4991:  0x6CC2,
	4992:  0x6CC3,
	4993:  0x6CC6,
	4994:  0x6CC7,
	4995:  0x6CC8,
	4996:  0x6CCB,
	4997:  0x6CCD,
	4998:  0x6CCE,
	4999:  0x6CCF,
	5000:  0x6CD1,
	5001:  0x6CD2,
	5002:  0x6CD8,
	5003:  0x6CD9,
	5004:  0x6CDA,
	5005:  0x6CDC,
	5006:  0x6CDD,
	5007:  0x6CDF,
	5008:  0x6CE4,
	5009:  0x6CE6,
	5010:  0x6CE7,
	5011:  0x6CE9,
	5012:  0x6CEC,
	5013:  0x6CED,
	5014:  0x6CF2,
	5015:  0x6CF4,
	5016:  0x6CF9,
	5017:  0x6CFF,
	5018:  0x6D00,
	5019:  0x6D02,
	5020:  0x6D03,
	5021:  0x6D05,
	5022:  0x6D06,
	5023:  0x6D08,
	5024:  0x6D09,
	5025:  0x6D0A,
	5026:  0x6D0D,
	5027:  0x6D0F,
	5028:  0x6D10,
	5029:  0x6D11,
	5030:  0x6D13,
	5031:  0x6D14,
	5032:  0x6D15,
	5033:  0x6D16,
	5034:  0x6D18,
	5035:  0x6D1C,
	5036:  0x6D1D,
	5037:  0x6D1F,
	5038:  0x6D20,
	5039:  0x6D21,
	5040:  0x6D22,
	5041:  0x6D23,
	5042:  0x6D24,
	5043:  0x6D26,
	5044:  0x6D28,
	5045:  0x6D29,
	5046:  0x6D2C,
	5047:  0x6D2D,
	5048:  0x6D2F,
	5049:  0x6D30,
	5050:  0x6D34,
	5051:  0x6D36,
	5052:  0x6D37,
	5053:  0x6D38,
	5054:  0x6D3A,
	5055:  0x6D3F,
	5056:  0x6D40,
	5057:  0x6D42,
	5058:  0x6D44,
	5059:  0x6D49,
	5060:  0x6D4C,
	5061:  0x6D50,
	5062:  0x6D55,
	5063:  0x6D56,
	5064:  0x6D57,
	5065:  0x6D58,
	5066:  0x6D5B,
	5067:  0x6D5D,
	5068:  0x6D5F,
	5069:  0x6D61,
	5070:  0x6D62,
	5071:  0x6D64,
	5072:  0x6D65,
	5073:  0x6D67,
	5074:  0x6D68,
	5075:  0x6D6B,
	5076:  0x6D6C,
	5077:  0x6D6D,
	5078:  0x6D70,
	5079:  0x6D71,
	5080:  0x6D72,
	5081:  0x6D73,
	5082:  0x6D75,
	5083:  0x6D76,
	5084:  0x6D79,
	5085:  0x6D7A,
	5086:  0x6D7B,
	5087:  0x6D7D,
	5088:  0x6D7E,
	5089:  0x6D7F,
	5090:  0x6D80,
	5091:  0x6D81,
	5092:  0x6D83,
	5093:  0x6D84,
	5094:  0x6D86,
	5095:  0x6D87,
	5096:  0x6D8A,
	5097:  0x6D8B,
	5098:  0x6D8D,
	5099:  0x6D8F,
	5100:  0x6D90,
	5101:  0x6D92,
	5102:  0x6D96,
	5103:  0x6D97,
	5104:  0x6D98,
	5105:  0x6D99,
	5106:  0x6D9A,
	5107:  0x6D9C,
	5108:  0x6DA2,
	5109:  0x6DA5,
	5110:  0x6DAC,
	5111:  0x6DAD,
	5112:  0x6DB0,
	5113:  0x6DB1,
	5114:  0x6DB3,
	5115:  0x6DB4,
	5116:  0x6DB6,
	5117:  0x6DB7,
	5118:  0x6DB9,
	5119:  0x6DBA,
	5120:  0x6DBB,
	5121:  0x6DBC,
	5122:  0x6DBD,
	5123:  0x6DBE,
	5124:  0x6DC1,
	5125:  0x6DC2,
	5126:  0x6DC3,
	5127:  0x6DC8,
	5128:  0x6DC9,
	5129:  0x6DCA,
	5130:  0x6DCD,
	5131:  0x6DCE,
	5132:  0x6DCF,
	5133:  0x6DD0,
	5134:  0x6DD2,
	5135:  0x6DD3,
	5136:  0x6DD4,
	5137:  0x6DD5,
	5138:  0x6DD7,
	5139:  0x6DDA,
	5140:  0x6DDB,
	5141:  0x6DDC,
	5142:  0x6DDF,
	5143:  0x6DE2,
	5144:  0x6DE3,
	5145:  0x6DE5,
	5146:  0x6DE7,
	5147:  0x6DE8,
	5148:  0x6DE9,
	5149:  0x6DEA,
	5150:  0x6DED,
	5151:  0x6DEF,
	5152:  0x6DF0,
	5153:  0x6DF2,
	5154:  0x6DF4,
	5155:  0x6DF5,
	5156:  0x6DF6,
	5157:  0x6DF8,
	5158:  0x6DFA,
	5159:  0x6DFD,
	5160:  0x6DFE,
	5161:  0x6DFF,
	5162:  0x6E00,
	5163:  0x6E01,
	5164:  0x6E02,
	5165:  0x6E03,
	5166:  0x6E04,
	5167:  0x6E06,
	5168:  0x6E07,
	5169:  0x6E08,
	5170:  0x6E09,
	5171:  0x6E0B,
	5172:  0x6E0F,
	5173:  0x6E12,
	5174:  0x6E13,
	5175:  0x6E15,
	5176:  0x6E18,
	5177:  0x6E19,
	5178:  0x6E1B,
	5179:  0x6E1C,
	5180:  0x6E1E,
	5181:  0x6E1F,
	5182:  0x6E22,
	5183:  0x6E26,
	5184:  0x6E27,
	5185:  0x6E28,
	5186:  0x6E2A,
	5187:  0x6E2C,
	5188:  0x6E2E,
	5189:  0x6E30,
	5190:  0x6E31,
	5191:  0x6E33,
	5192:  0x6E35,
	5193:  0x6E36,
	5194:  0x6E37,
	5195:  0x6E39,
	5196:  0x6E3B,
	5197:  0x6E3C,
	5198:  0x6E3D,
	5199:  0x6E3E,
	5200:  0x6E3F,
	5201:  0x6E40,
	5202:  0x6E41,
	5203:  0x6E42,
	5204:  0x6E45,
	5205:  0x6E46,
	5206:  0x6E47,
	5207:  0x6E48,
	5208:  0x6E49,
	5209:  0x6E4A,
	5210:  0x6E4B,
	5211:  0x6E4C,
	5212:  0x6E4F,
	5213:  0x6E50,
	5214:  0x6E51,
	5215:  0x6E52,
	5216:  0x6E55,
	5217:  0x6E57,
	5218:  0x6E59,
	5219:  0x6E5A,
	5220:  0x6E5C,
	5221:  0x6E5D,
	5222:  0x6E5E,
	5223:  0x6E60,
	5224:  0x6E61,
	5225:  0x6E62,
	5226:  0x6E63,
	5227:  0x6E64,
	5228:  0x6E65,
	5229:  0x6E66,
	5230:  0x6E67,
	5231:  0x6E68,
	5232:  0x6E69,
	5233:  0x6E6A,
	5234:  0x6E6C,
	5235:  0x6E6D,
	5236:  0x6E6F,
	5237:  0x6E70,
	5238:  0x6E71,
	5239:  0x6E72,
	5240:  0x6E73,
	5241:  0x6E74,
	5242:  0x6E75,
	5243:  0x6E76,
	5244:  0x6E77,
	5245:  0x6E78,
	5246:  0x6E79,
	5247:  0x6E7A,
	5248:  0x6E7B,
	5249:  0x6E7C,
	5250:  0x6E7D,
	5251:  0x6E80,
	5252:  0x6E81,
	5253:  0x6E82,
	5254:  0x6E84,
	5255:  0x6E87,
	5256:  0x6E88,
	5257:  0x6E8A,
	5258:  0x6E8B,
	5259:  0x6E8C,
	5260:  0x6E8D,
	5261:  0x6E8E,
	5262:  0x6E91,
	5263:  0x6E92,
	5264:  0x6E93,
	5265:  0x6E94,
	5266:  0x6E95,
	5267:  0x6E96,
	5268:  0x6E97,
	5269:  0x6E99,
	5270:  0x6E9A,
	5271:  0x6E9B,
	5272:  0x6E9D,
	5273:  0x6E9E,
	5274:  0x6EA0,
	5275:  0x6EA1,
	5276:  0x6EA3,
	5277:  0x6EA4,
	5278:  0x6EA6,
	5279:  0x6EA8,
	5280:  0x6EA9,
	5281:  0x6EAB,
	5282:  0x6EAC,
	5283:  0x6EAD,
	5284:  0x6EAE,
	5285:  0x6EB0,
	5286:  0x6EB3,
	5287:  0x6EB5,
	5288:  0x6EB8,
	5289:  0x6EB9,
	5290:  0x6EBC,
	5291:  0x6EBE,
	5292:  0x6EBF,
	5293:  0x6EC0,
	5294:  0x6EC3,
	5295:  0x6EC4,
	5296:  0x6EC5,
	5297:  0x6EC6,
	5298:  0x6EC8,
	5299:  0x6EC9,
	5300:  0x6ECA,
	5301:  0x6ECC,
	5302:  0x6ECD,
	5303:  0x6ECE,
	5304:  0x6ED0,
	5305:  0x6ED2,
	5306:  0x6ED6,
	5307:  0x6ED8,
	5308:  0x6ED9,
	5309:  0x6EDB,
	5310:  0x6EDC,
	5311:  0x6EDD,
	5312:  0x6EE3,
	5313:  0x6EE7,
	5314:  0x6EEA,
	5315:  0x6EEB,
	5316:  0x6EEC,
	5317:  0x6EED,
	5318:  0x6EEE,
	5319:  0x6EEF,
	5320:  0x6EF0,
	5321:  0x6EF1,
	5322:  0x6EF2,
	5323:  0x6EF3,
	5324:  0x6EF5,
	5325:  0x6EF6,
	5326:  0x6EF7,
	5327:  0x6EF8,
	5328:  0x6EFA,
	5329:  0x6EFB,
	5330:  0x6EFC,
	5331:  0x6EFD,
	5332:  0x6EFE,
	5333:  0x6EFF,
	5334:  0x6F00,
	5335:  0x6F01,
	5336:  0x6F03,
	5337:  0x6F04,
	5338:  0x6F05,
	5339:  0x6F07,
	5340:  0x6F08,
	5341:  0x6F0A,
	5342:  0x6F0B,
	5343:  0x6F0C,
	5344:  0x6F0D,
	5345:  0x6F0E,
	5346:  0x6F10,
	5347:  0x6F11,
	5348:  0x6F12,
	5349:  0x6F16,
	5350:  0x6F17,
	5351:  0x6F18,
	5352:  0x6F19,
	5353:  0x6F1A,
	5354:  0x6F1B,
	5355:  0x6F1C,
	5356:  0x6F1D,
	5357:  0x6F1E,
	5358:  0x6F1F,
	5359:  0x6F21,
	5360:  0x6F22,
	5361:  0x6F23,
	5362:  0x6F25,
	5363:  0x6F26,
	5364:  0x6F27,
	5365:  0x6F28,
	5366:  0x6F2C,
	5367:  0x6F2E,
	5368:  0x6F30,
	5369:  0x6F32,
	5370:  0x6F34,
	5371:  0x6F35,
	5372:  0x6F37,
	5373:  0x6F38,
	5374:  0x6F39,
	5375:  0x6F3A,
	5376:  0x6F3B,
	5377:  0x6F3C,
	5378:  0x6F3D,
	5379:  0x6F3F,
	5380:  0x6F40,
	5381:  0x6F41,
	5382:  0x6F42,
	5383:  0x6F43,
	5384:  0x6F44,
	5385:  0x6F45,
	5386:  0x6F48,
	5387:  0x6F49,
	5388:  0x6F4A,
	5389:  0x6F4C,
	5390:  0x6F4E,
	5391:  0x6F4F,
	5392:  0x6F50,
	5393:  0x6F51,
	5394:  0x6F52,
	5395:  0x6F53,
	5396:  0x6F54,
	5397:  0x6F55,
	5398:  0x6F56,
	5399:  0x6F57,
	5400:  0x6F59,
	5401:  0x6F5A,
	5402:  0x6F5B,
	5403:  0x6F5D,
	5404:  0x6F5F,
	5405:  0x6F60,
	5406:  0x6F61,
	5407:  0x6F63,
	5408:  0x6F64,
	5409:  0x6F65,
	5410:  0x6F67,
	5411:  0x6F68,
	5412:  0x6F69,
	5413:  0x6F6A,
	5414:  0x6F6B,
	5415:  0x6F6C,
	5416:  0x6F6F,
	5417:  0x6F70,
	5418:  0x6F71,
	5419:  0x6F73,
	5420:  0x6F75,
	5421:  0x6F76,
	5422:  0x6F77,
	5423:  0x6F79,
	5424:  0x6F7B,
	5425:  0x6F7D,
	5426:  0x6F7E,
	5427:  0x6F7F,
	5428:  0x6F80,
	5429:  0x6F81,
	5430:  0x6F82,
	5431:  0x6F83,
	5432:  0x6F85,
	5433:  0x6F86,
	5434:  0x6F87,
	5435:  0x6F8A,
	5436:  0x6F8B,
	5437:  0x6F8F,
	5438:  0x6F90,
	5439:  0x6F91,
	5440:  0x6F92,
	5441:  0x6F93,
	5442:  0x6F94,
	5443:  0x6F95,
	5444:  0x6F96,
	5445:  0x6F97,
	5446:  0x6F98,
	5447:  0x6F99,
	5448:  0x6F9A,
	5449:  0x6F9B,
	5450:  0x6F9D,
	5451:  0x6F9E,
	5452:  0x6F9F,
	5453:  0x6FA0,
	5454:  0x6FA2,
	5455:  0x6FA3,
	5456:  0x6FA4,
	5457:  0x6FA5,
	5458:  0x6FA6,
	5459:  0x6FA8,
	5460:  0x6FA9,
	5461:  0x6FAA,
	5462:  0x6FAB,
	5463:  0x6FAC,
	5464:  0x6FAD,
	5465:  0x6FAE,
	5466:  0x6FAF,
	5467:  0x6FB0,
	5468:  0x6FB1,
	5469:  0x6FB2,
	5470:  0x6FB4,
	5471:  0x6FB5,
	5472:  0x6FB7,
	5473:  0x6FB8,
	5474:  0x6FBA,
	5475:  0x6FBB,
	5476:  0x6FBC,
	5477:  0x6FBD,
	5478:  0x6FBE,
	5479:  0x6FBF,
	5480:  0x6FC1,
	5481:  0x6FC3,
	5482:  0x6FC4,
	5483:  0x6FC5,
	5484:  0x6FC6,
	5485:  0x6FC7,
	5486:  0x6FC8,
	5487:  0x6FCA,
	5488:  0x6FCB,
	5489:  0x6FCC,
	5490:  0x6FCD,
	5491:  0x6FCE,
	5492:  0x6FCF,
	5493:  0x6FD0,
	5494:  0x6FD3,
	5495:  0x6FD4,
	5496:  0x6FD5,
	5497:  0x6FD6,
	5498:  0x6FD7,
	5499:  0x6FD8,
	5500:  0x6FD9,
	5501:  0x6FDA,
	5502:  0x6FDB,
	5503:  0x6FDC,
	5504:  0x6FDD,
	5505:  0x6FDF,
	5506:  0x6FE2,
	5507:  0x6FE3,
	5508:  0x6FE4,
	5509:  0x6FE5,
	5510:  0x6FE6,
	5511:  0x6FE7,
	5512:  0x6FE8,
	5513:  0x6FE9,
	5514:  0x6FEA,
	5515:  0x6FEB,
	5516:  0x6FEC,
	5517:  0x6FED,
	5518:  0x6FF0,
	5519:  0x6FF1,
	5520:  0x6FF2,
	5521:  0x6FF3,
	5522:  0x6FF4,
	5523:  0x6FF5,
	5524:  0x6FF6,
	5525:  0x6FF7,
	5526:  0x6FF8,
	5527:  0x6FF9,
	5528:  0x6FFA,
	5529:  0x6FFB,
	5530:  0x6FFC,
	5531:  0x6FFD,
	5532:  0x6FFE,
	5533:  0x6FFF,
	5534:  0x7000,
	5535:  0x7001,
	5536:  0x7002,
	5537:  0x7003,
	5538:  0x7004,
	5539:  0x7005,
	5540:  0x7006,
	5541:  0x7007,
	5542:  0x7008,
	5543:  0x7009,
	5544:  0x700A,
	5545:  0x700B,
	5546:  0x700C,
	5547:  0x700D,
	5548:  0x700E,
	5549:  0x700F,
	5550:  0x7010,
	5551:  0x7012,
	5552:  0x7013,
	5553:  0x7014,
	5554:  0x7015,
	5555:  0x7016,
	5556:  0x7017,
	5557:  0x7018,
	5558:  0x7019,
	5559:  0x701C,
	5560:  0x701D,
	5561:  0x701E,
	5562:  0x701F,
	5563:  0x7020,
	5564:  0x7021,
	5565:  0x7022,
	5566:  0x7024,
	5567:  0x7025,
	5568:  0x7026,
	5569:  0x7027,
	5570:  0x7028,
	5571:  0x7029,
	5572:  0x702A,
	5573:  0x702B,
	5574:  0x702C,
	5575:  0x702D,
	5576:  0x702E,
	5577:  0x702F,
	5578:  0x7030,
	5579:  0x7031,
	5580:  0x7032,
	5581:  0x7033,
	5582:  0x7034,
	5583:  0x7036,
	5584:  0x7037,
	5585:  0x7038,
	5586:  0x703A,
	5587:  0x703B,
	5588:  0x703C,
	5589:  0x703D,
	5590:  0x703E,
	5591:  0x703F,
	5592:  0x7040,
	5593:  0x7041,
	5594:  0x7042,
	5595:  0x7043,
	5596:  0x7044,
	5597:  0x7045,
	5598:  0x7046,
	5599:  0x7047,
	5600:  0x7048,
	5601:  0x7049,
	5602:  0x704A,
	5603:  0x704B,
	5604:  0x704D,
	5605:  0x704E,
	5606:  0x7050,
	5607:  0x7051,
	5608:  0x7052,
	5609:  0x7053,
	5610:  0x7054,
	5611:  0x7055,
	5612:  0x7056,
	5613:  0x7057,
	5614:  0x7058,
	5615:  0x7059,
	5616:  0x705A,
	5617:  0x705B,
	5618:  0x705C,
	5619:  0x705D,
	5620:  0x705F,
	5621:  0x7060,
	5622:  0x7061,
	5623:  0x7062,
	5624:  0x7063,
	5625:  0x7064,
	5626:  0x7065,
	5627:  0x7066,
	5628:  0x7067,
	5629:  0x7068,
	5630:  0x7069,
	5631:  0x706A,
	5632:  0x706E,
	5633:  0x7071,
	5634:  0x7072,
	5635:  0x7073,
	5636:  0x7074,
	5637:  0x7077,
	5638:  0x7079,
	5639:  0x707A,
	5640:  0x707B,
	5641:  0x707D,
	5642:  0x7081,
	5643:  0x7082,
	5644:  0x7083,
	5645:  0x7084,
	5646:  0x7086,
	5647:  0x7087,
	5648:  0x7088,
	5649:  0x708B,
	5650:  0x708C,
	5651:  0x708D,
	5652:  0x708F,
	5653:  0x7090,
	5654:  0x7091,
	5655:  0x7093,
	5656:  0x7097,
	5657:  0x7098,
	5658:  0x709A,
	5659:  0x709B,
	5660:  0x709E,
	5661:  0x709F,
	5662:  0x70A0,
	5663:  0x70A1,
	5664:  0x70A2,
	5665:  0x70A3,
	5666:  0x70A4,
	5667:  0x70A5,
	5668:  0x70A6,
	5669:  0x70A7,
	5670:  0x70A8,
	5671:  0x70A9,
	5672:  0x70AA,
	5673:  0x70B0,
	5674:  0x70B2,
	5675:  0x70B4,
	5676:  0x70B5,
	5677:  0x70B6,
	5678:  0x70BA,
	5679:  0x70BE,
	5680:  0x70BF,
	5681:  0x70C4,
	5682:  0x70C5,
	5683:  0x70C6,
	5684:  0x70C7,
	5685:  0x70C9,
	5686:  0x70CB,
	5687:  0x70CC,
	5688:  0x70CD,
	5689:  0x70CE,
	5690:  0x70CF,
	5691:  0x70D0,
	5692:  0x70D1,
	5693:  0x70D2,
	5694:  0x70D3,
	5695:  0x70D4,
	5696:  0x70D5,
	5697:  0x70D6,
	5698:  0x70D7,
	5699:  0x70DA,
	5700:  0x70DC,
	5701:  0x70DD,
	5702:  0x70DE,
	5703:  0x70E0,
	5704:  0x70E1,
	5705:  0x70E2,
	5706:  0x70E3,
	5707:  0x70E5,
	5708:  0x70EA,
	5709:  0x70EE,
	5710:  0x70F0,
	5711:  0x70F1,
	5712:  0x70F2,
	5713:  0x70F3,
	5714:  0x70F4,
	5715:  0x70F5,
	5716:  0x70F6,
	5717:  0x70F8,
	5718:  0x70FA,
	5719:  0x70FB,
	5720:  0x70FC,
	5721:  0x70FE,
	5722:  0x70FF,
	5723:  0x7100,
	5724:  0x7101,
	5725:  0x7102,
	5726:  0x7103,
	5727:  0x7104,
	5728:  0x7105,
	5729:  0x7106,
	5730:  0x7107,
	5731:  0x7108,
	5732:  0x710B,
	5733:  0x710C,
	5734:  0x710D,
	5735:  0x710E,
	5736:  0x710F,
	5737:  0x7111,
	5738:  0x7112,
	5739:  0x7114,
	5740:  0x7117,
	5741:  0x711B,
	5742:  0x711C,
	5743:  0x711D,
	5744:  0x711E,
	5745:  0x711F,
	5746:  0x7120,
	5747:  0x7121,
	5748:  0x7122,
	5749:  0x7123,
	5750:  0x7124,
	5751:  0x7125,
	5752:  0x7127,
	5753:  0x7128,
	5754:  0x7129,
	5755:  0x712A,
	5756:  0x712B,
	5757:  0x712C,
	5758:  0x712D,
	5759:  0x712E,
	5760:  0x7132,
	5761:  0x7133,
	5762:  0x7134,
	5763:  0x7135,
	5764:  0x7137,
	5765:  0x7138,
	5766:  0x7139,
	5767:  0x713A,
	5768:  0x713B,
	5769:  0x713C,
	5770:  0x713D,
	5771:  0x713E,
	5772:  0x713F,
	5773:  0x7140,
	5774:  0x7141,
	5775:  0x7142,
	5776:  0x7143,
	5777:  0x7144,
	5778:  0x7146,
	5779:  0x7147,
	5780:  0x7148,
	5781:  0x7149,
	5782:  0x714B,
	5783:  0x714D,
	5784:  0x714F,
	5785:  0x7150,
	5786:  0x7151,
	5787:  0x7152,
	5788:  0x7153,
	5789:  0x7154,
	5790:  0x7155,
	5791:  0x7156,
	5792:  0x7157,
	5793:  0x7158,
	5794:  0x7159,
	5795:  0x715A,
	5796:  0x715B,
	5797:  0x715D,
	5798:  0x715F,
	5799:  0x7160,
	5800:  0x7161,
	5801:  0x7162,
	5802:  0x7163,
	5803:  0x7165,
	5804:  0x7169,
	5805:  0x716A,
	5806:  0x716B,
	5807:  0x716C,
	5808:  0x716D,
	5809:  0x716F,
	5810:  0x7170,
	5811:  0x7171,
	5812:  0x7174,
	5813:  0x7175,
	5814:  0x7176,
	5815:  0x7177,
	5816:  0x7179,
	5817:  0x717B,
	5818:  0x717C,
	5819:  0x717E,
	5820:  0x717F,
	5821:  0x7180,
	5822:  0x7181,
	5823:  0x7182,
	5824:  0x7183,
	5825:  0x7185,
	5826:  0x7186,
	5827:  0x7187,
	5828:  0x7188,
	5829:  0x7189,
	5830:  0x718B,
	5831:  0x718C,
	5832:  0x718D,
	5833:  0x718E,
	5834:  0x7190,
	5835:  0x7191,
	5836:  0x7192,
	5837:  0x7193,
	5838:  0x7195,
	5839:  0x7196,
	5840:  0x7197,
	5841:  0x719A,
	5842:  0x719B,
	5843:  0x719C,
	5844:  0x719D,
	5845:  0x719E,
	5846:  0x71A1,
	5847:  0x71A2,
	5848:  0x71A3,
	5849:  0x71A4,
	5850:  0x71A5,
	5851:  0x71A6,
	5852:  0x71A7,
	5853:  0x71A9,
	5854:  0x71AA,
	5855:  0x71AB,
	5856:  0x71AD,
	5857:  0x71AE,
	5858:  0x71AF,
	5859:  0x71B0,
	5860:  0x71B1,
	5861:  0x71B2,
	5862:  0x71B4,
	5863:  0x71B6,
	5864:  0x71B7,
	5865:  0x71B8,
	5866:  0x71BA,
	5867:  0x71BB,
	5868:  0x71BC,
	5869:  0x71BD,
	5870:  0x71BE,
	5871:  0x71BF,
	5872:  0x71C0,
	5873:  0x71C1,
	5874:  0x71C2,
	5875:  0x71C4,
	5876:  0x71C5,
	5877:  0x71C6,
	5878:  0x71C7,
	5879:  0x71C8,
	5880:  0x71C9,
	5881:  0x71CA,
	5882:  0x71CB,
	5883:  0x71CC,
	5884:  0x71CD,
	5885:  0x71CF,
	5886:  0x71D0,
	5887:  0x71D1,
	5888:  0x71D2,
	5889:  0x71D3,
	5890:  0x71D6,
	5891:  0x71D7,
	5892:  0x71D8,
	5893:  0x71D9,
	5894:  0x71DA,
	5895:  0x71DB,
	5896:  0x71DC,
	5897:  0x71DD,
	5898:  0x71DE,
	5899:  0x71DF,
	5900:  0x71E1,
	5901:  0x71E2,
	5902:  0x71E3,
	5903:  0x71E4,
	5904:  0x71E6,
	5905:  0x71E8,
	5906:  0x71E9,
	5907:  0x71EA,
	5908:  0x71EB,
	5909:  0x71EC,
	5910:  0x71ED,
	5911:  0x71EF,
	5912:  0x71F0,
	5913:  0x71F1,
	5914:  0x71F2,
	5915:  0x71F3,
	5916:  0x71F4,
	5917:  0x71F5,
	5918:  0x71F6,
	5919:  0x71F7,
	5920:  0x71F8,
	5921:  0x71FA,
	5922:  0x71FB,
	5923:  0x71FC,
	5924:  0x71FD,
	5925:  0x71FE,
	5926:  0x71FF,
	5927:  0x7200,
	5928:  0x7201,
	5929:  0x7202,
	5930:  0x7203,
	5931:  0x7204,
	5932:  0x7205,
	5933:  0x7207,
	5934:  0x7208,
	5935:  0x7209,
	5936:  0x720A,
	5937:  0x720B,
	5938:  0x720C,
	5939:  0x720D,
	5940:  0x720E,
	5941:  0x720F,
	5942:  0x7210,
	5943:  0x7211,
	5944:  0x7212,
	5945:  0x7213,
	5946:  0x7214,
	5947:  0x7215,
	5948:  0x7216,
	5949:  0x7217,
	5950:  0x7218,
	5951:  0x7219,
	5952:  0x721A,
	5953:  0x721B,
	5954:  0x721C,
	5955:  0x721E,
	5956:  0x721F,
	5957:  0x7220,
	5958:  0x7221,
	5959:  0x7222,
	5960:  0x7223,
	5961:  0x7224,
	5962:  0x7225,
	5963:  0x7226,
	5964:  0x7227,
	5965:  0x7229,
	5966:  0x722B,
	5967:  0x722D,
	5968:  0x722E,
	5969:  0x722F,
	5970:  0x7232,
	5971:  0x7233,
	5972:  0x7234,
	5973:  0x723A,
	5974:  0x723C,
	5975:  0x723E,
	5976:  0x7240,
	5977:  0x7241,
	5978:  0x7242,
	5979:  0x7243,
	5980:  0x7244,
	5981:  0x7245,
	5982:  0x7246,
	5983:  0x7249,
	5984:  0x724A,
	5985:  0x724B,
	5986:  0x724E,
	5987:  0x724F,
	5988:  0x7250,
	5989:  0x7251,
	5990:  0x7253,
	5991:  0x7254,
	5992:  0x7255,
	5993:  0x7257,
	5994:  0x7258,
	5995:  0x725A,
	5996:  0x725C,
	5997:  0x725E,
	5998:  0x7260,
	5999:  0x7263,
	6000:  0x7264,
	6001:  0x7265,
	6002:  0x7268,
	6003:  0x726A,
	6004:  0x726B,
	6005:  0x726C,
	6006:  0x726D,
	6007:  0x7270,
	6008:  0x7271,
	6009:  0x7273,
	6010:  0x7274,
	6011:  0x7276,
	6012:  0x7277,
	6013:  0x7278,
	6014:  0x727B,
	6015:  0x727C,
	6016:  0x727D,
	6017:  0x7282,
	6018:  0x7283,
	6019:  0x7285,
	6020:  0x7286,
	6021:  0x7287,
	6022:  0x7288,
	6023:  0x7289,
	6024:  0x728C,
	6025:  0x728E,
	6026:  0x7290,
	6027:  0x7291,
	6028:  0x7293,
	6029:  0x7294,
	6030:  0x7295,
	6031:  0x7296,
	6032:  0x7297,
	6033:  0x7298,
	6034:  0x7299,
	6035:  0x729A,
	6036:  0x729B,
	6037:  0x729C,
	6038:  0x729D,
	6039:  0x729E,
	6040:  0x72A0,
	6041:  0x72A1,
	6042:  0x72A2,
	6043:  0x72A3,
	6044:  0x72A4,
	6045:  0x72A5,
	6046:  0x72A6,
	6047:  0x72A7,
	6048:  0x72A8,
	6049:  0x72A9,
	6050:  0x72AA,
	6051:  0x72AB,
	6052:  0x72AE,
	6053:  0x72B1,
	6054:  0x72B2,
	6055:  0x72B3,
	6056:  0x72B5,
	6057:  0x72BA,
	6058:  0x72BB,
	6059:  0x72BC,
	6060:  0x72BD,
	6061:  0x72BE,
	6062:  0x72BF,
	6063:  0x72C0,
	6064:  0x72C5,
	6065:  0x72C6,
	6066:  0x72C7,
	6067:  0x72C9,
	6068:  0x72CA,
	6069:  0x72CB,
	6070:  0x72CC,
	6071:  0x72CF,
	6072:  0x72D1,
	6073:  0x72D3,
	6074:  0x72D4,
	6075:  0x72D5,
	6076:  0x72D6,
	6077:  0x72D8,
	6078:  0x72DA,
	6079:  0x72DB,
	6176:  0x3000,
	6177:  0x3001,
	6178:  0x3002,
	6179:  0x00B7,
	6180:  0x02C9,
	6181:  0x02C7,
	6182:  0x00A8,
	6183:  0x3003,
	6184:  0x3005,
	6185:  0x2014,
	6186:  0xFF5E,
	6187:  0x2016,
	6188:  0x2026,
	6189:  0x2018,
	6190:  0x2019,
	6191:  0x201C,
	6192:  0x201D,
	6193:  0x3014,
	6194:  0x3015,
	6195:  0x3008,
	6196:  0x3009,
	6197:  0x300A,
	6198:  0x300B,
	6199:  0x300C,
	6200:  0x300D,
	6201:  0x300E,
	6202:  0x300F,
	6203:  0x3016,
	6204:  0x3017,
	6205:  0x3010,
	6206:  0x3011,
	6207:  0x00B1,
	6208:  0x00D7,
	6209:  0x00F7,
	6210:  0x2236,
	6211:  0x2227,
	6212:  0x2228,
	6213:  0x2211,
	6214:  0x220F,
	6215:  0x222A,
	6216:  0x2229,
	6217:  0x2208,
	6218:  0x2237,
	6219:  0x221A,
	6220:  0x22A5,
	6221:  0x2225,
	6222:  0x2220,
	6223:  0x2312,
	6224:  0x2299,
	6225:  0x222B,
	6226:  0x222E,
	6227:  0x2261,
	6228:  0x224C,
	6229:  0x2248,
	6230:  0x223D,
	6231:  0x221D,
	6232:  0x2260,
	6233:  0x226E,
	6234:  0x226F,
	6235:  0x2264,
	6236:  0x2265,
	6237:  0x221E,
	6238:  0x2235,
	6239:  0x2234,
	6240:  0x2642,
	6241:  0x2640,
	6242:  0x00B0,
	6243:  0x2032,
	6244:  0x2033,
	6245:  0x2103,
	6246:  0xFF04,
	6247:  0x00A4,
	6248:  0xFFE0,
	6249:  0xFFE1,
	6250:  0x2030,
	6251:  0x00A7,
	6252:  0x2116,
	6253:  0x2606,
	6254:  0x2605,
	6255:  0x25CB,
	6256:  0x25CF,
	6257:  0x25CE,
	6258:  0x25C7,
	6259:  0x25C6,
	6260:  0x25A1,
	6261:  0x25A0,
	6262:  0x25B3,
	6263:  0x25B2,
	6264:  0x203B,
	6265:  0x2192,
	6266:  0x2190,
	6267:  0x2191,
	6268:  0x2193,
	6269:  0x3013,
	6366:  0x2170,
	6367:  0x2171,
	6368:  0x2172,
	6369:  0x2173,
	6370:  0x2174,
	6371:  0x2175,
	6372:  0x2176,
	6373:  0x2177,
	6374:  0x2178,
	6375:  0x2179,
	6382:  0x2488,
	6383:  0x2489,
	6384:  0x248A,
	6385:  0x248B,
	6386:  0x248C,
	6387:  0x248D,
	6388:  0x248E,
	6389:  0x248F,
	6390:  0x2490,
	6391:  0x2491,
	6392:  0x2492,
	6393:  0x2493,
	6394:  0x2494,
	6395:  0x2495,
	6396:  0x2496,
	6397:  0x2497,
	6398:  0x2498,
	6399:  0x2499,
	6400:  0x249A,
	6401:  0x249B,
	6402:  0x2474,
	6403:  0x2475,
	6404:  0x2476,
	6405:  0x2477,
	6406:  0x2478,
	6407:  0x2479,
	6408:  0x247A,
	6409:  0x247B,
	6410:  0x247C,
	6411:  0x247D,
	6412:  0x247E,
	6413:  0x247F,
	6414:  0x2480,
	6415:  0x2481,
	6416:  0x2482,
	6417:  0x2483,
	6418:  0x2484,
	6419:  0x2485,
	6420:  0x2486,
	6421:  0x2487,
	6422:  0x2460,
	6423:  0x2461,
	6424:  0x2462,
	6425:  0x2463,
	6426:  0x2464,
	6427:  0x2465,
	6428:  0x2466,
	6429:  0x2467,
	6430:  0x2468,
	6431:  0x2469,
	6432:  0x20AC,
	6434:  0x3220,
	6435:  0x3221,
	6436:  0x3222,
	6437:  0x3223,
	6438:  0x3224,
	6439:  0x3225,
	6440:  0x3226,
	6441:  0x3227,
	6442:  0x3228,
	6443:  0x3229,
	6446:  0x2160,
	6447:  0x2161,
	6448:  0x2162,
	6449:  0x2163,
	6450:  0x2164,
	6451:  0x2165,
	6452:  0x2166,
	6453:  0x2167,
	6454:  0x2168,
	6455:  0x2169,
	6456:  0x216A,
	6457:  0x216B,
	6555:  0x3000,
	6556:  0xFF01,
	6557:  0xFF02,
	6558:  0xFF03,
	6559:  0xFFE5,
	6560:  0xFF05,
	6561:  0xFF06,
	6562:  0xFF07,
	6563:  0xFF08,
	6564:  0xFF09,
	6565:  0xFF0A,
	6566:  0xFF0B,
	6567:  0xFF0C,
	6568:  0xFF0D,
	6569:  0xFF0E,
	6570:  0xFF0F,
	6571:  0xFF10,
	6572:  0xFF11,
	6573:  0xFF12,
	6574:  0xFF13,
	6575:  0xFF14,
	6576:  0xFF15,
	6577:  0xFF16,
	6578:  0xFF17,
	6579:  0xFF18,
	6580:  0xFF19,
	6581:  0xFF1A,
	6582:  0xFF1B,
	6583:  0xFF1C,
	6584:  0xFF1D,
	6585:  0xFF1E,
	6586:  0xFF1F,
	6587:  0xFF20,
	6588:  0xFF21,
	6589:  0xFF22,
	6590:  0xFF23,
	6591:  0xFF24,
	6592:  0xFF25,
	6593:  0xFF26,
	6594:  0xFF27,
	6595:  0xFF28,
	6596:  0xFF29,
	6597:  0xFF2A,
	6598:  0xFF2B,
	6599:  0xFF2C,
	6600:  0xFF2D,
	6601:  0xFF2E,
	6602:  0xFF2F,
	6603:  0xFF30,
	6604:  0xFF31,
	6605:  0xFF32,
	6606:  0xFF33,
	6607:  0xFF34,
	6608:  0xFF35,
	6609:  0xFF36,
	6610:  0xFF37,
	6611:  0xFF38,
	6612:  0xFF39,
	6613:  0xFF3A,
	6614:  0xFF3B,
	6615:  0xFF3C,
	6616:  0xFF3D,
	6617:  0xFF3E,
	6618:  0xFF3F,
	6619:  0xFF40,
	6620:  0xFF41,
	6621:  0xFF42,
	6622:  0xFF43,
	6623:  0xFF44,
	6624:  0xFF45,
	6625:  0xFF46,
	6626:  0xFF47,
	6627:  0xFF48,
	6628:  0xFF49,
	6629:  0xFF4A,
	6630:  0xFF4B,
	6631:  0xFF4C,
	6632:  0xFF4D,
	6633:  0xFF4E,
	6634:  0xFF4F,
	6635:  0xFF50,
	6636:  0xFF51,
	6637:  0xFF52,
	6638:  0xFF53,
	6639:  0xFF54,
	6640:  0xFF55,
	6641:  0xFF56,
	6642:  0xFF57,
	6643:  0xFF58,
	6644:  0xFF59,
	6645:  0xFF5A,
	6646:  0xFF5B,
	6647:  0xFF5C,
	6648:  0xFF5D,
	6649:  0xFFE3,
	6746:  0x3041,
	6747:  0x3042,
	6748:  0x3043,
	6749:  0x3044,
	6750:  0x3045,
	6751:  0x3046,
	6752:  0x3047,
	6753:  0x3048,
	6754:  0x3049,
	6755:  0x304A,
	6756:  0x304B,
	6757:  0x304C,
	6758:  0x304D,
	6759:  0x304E,
	6760:  0x304F,
	6761:  0x3050,
	6762:  0x3051,
	6763:  0x3052,
	6764:  0x3053,
	6765:  0x3054,
	6766:  0x3055,
	6767:  0x3056,
	6768:  0x3057,
	6769:  0x3058,
	6770:  0x3059,
	6771:  0x305A,
	6772:  0x305B,
	6773:  0x305C,
	6774:  0x305D,
	6775:  0x305E,
	6776:  0x305F,
	6777:  0x3060,
	6778:  0x3061,
	6779:  0x3062,
	6780:  0x3063,
	6781:  0x3064,
	6782:  0x3065,
	6783:  0x3066,
	6784:  0x3067,
	6785:  0x3068,
	6786:  0x3069,
	6787:  0x306A,
	6788:  0x306B,
	6789:  0x306C,
	6790:  0x306D,
	6791:  0x306E,
	6792:  0x306F,
	6793:  0x3070,
	6794:  0x3071,
	6795:  0x3072,
	6796:  0x3073,
	6797:  0x3074,
	6798:  0x3075,
	6799:  0x3076,
	6800:  0x3077,
	6801:  0x3078,
	6802:  0x3079,
	6803:  0x307A,
	6804:  0x307B,
	6805:  0x307C,
	6806:  0x307D,
	6807:  0x307E,
	6808:  0x307F,
	6809:  0x3080,
	6810:  0x3081,
	6811:  0x3082,
	6812:  0x3083,
	6813:  0x3084,
	6814:  0x3085,
	6815:  0x3086,
	6816:  0x3087,
	6817:  0x3088,
	6818:  0x3089,
	6819:  0x308A,
	6820:  0x308B,
	6821:  0x308C,
	6822:  0x308D,
	6823:  0x308E,
	6824:  0x308F,
	6825:  0x3090,
	6826:  0x3091,
	6827:  0x3092,
	6828:  0x3093,
	6936:  0x30A1,
	6937:  0x30A2,
	6938:  0x30A3,
	6939:  0x30A4,
	6940:  0x30A5,
	6941:  0x30A6,
	6942:  0x30A7,
	6943:  0x30A8,
	6944:  0x30A9,
	6945:  0x30AA,
	6946:  0x30AB,
	6947:  0x30AC,
	6948:  0x30AD,
	6949:  0x30AE,
	6950:  0x30AF,
	6951:  0x30B0,
	6952:  0x30B1,
	6953:  0x30B2,
	6954:  0x30B3,
	6955:  0x30B4,
	6956:  0x30B5,
	6957:  0x30B6,
	6958:  0x30B7,
	6959:  0x30B8,
	6960:  0x30B9,
	6961:  0x30BA,
	6962:  0x30BB,
	6963:  0x30BC,
	6964:  0x30BD,
	6965:  0x30BE,
	6966:  0x30BF,
	6967:  0x30C0,
	6968:  0x30C1,
	6969:  0x30C2,
	6970:  0x30C3,
	6971:  0x30C4,
	6972:  0x30C5,
	6973:  0x30C6,
	6974:  0x30C7,
	6975:  0x30C8,
	6976:  0x30C9,
	6977:  0x30CA,
	6978:  0x30CB,
	6979:  0x30CC,
	6980:  0x30CD,
	6981:  0x30CE,
	6982:  0x30CF,
	6983:  0x30D0,
	6984:  0x30D1,
	6985:  0x30D2,
	6986:  0x30D3,
	6987:  0x30D4,
	6988:  0x30D5,
	6989:  0x30D6,
	6990:  0x30D7,
	6991:  0x30D8,
	6992:  0x30D9,
	6993:  0x30DA,
	6994:  0x30DB,
	6995:  0x30DC,
	6996:  0x30DD,
	6997:  0x30DE,
	6998:  0x30DF,
	6999:  0x30E0,
	7000:  0x30E1,
	7001:  0x30E2,
	7002:  0x30E3,
	7003:  0x30E4,
	7004:  0x30E5,
	7005:  0x30E6,
	7006:  0x30E7,
	7007:  0x30E8,
	7008:  0x30E9,
	7009:  0x30EA,
	7010:  0x30EB,
	7011:  0x30EC,
	7012:  0x30ED,
	7013:  0x30EE,
	7014:  0x30EF,
	7015:  0x30F0,
	7016:  0x30F1,
	7017:  0x30F2,
	7018:  0x30F3,
	7019:  0x30F4,
	7020:  0x30F5,
	7021:  0x30F6,
	7126:  0x0391,
	7127:  0x0392,
	7128:  0x0393,
	7129:  0x0394,
	7130:  0x0395,
	7131:  0x0396,
	7132:  0x0397,
	7133:  0x0398,
	7134:  0x0399,
	7135:  0x039A,
	7136:  0x039B,
	7137:  0x039C,
	7138:  0x039D,
	7139:  0x039E,
	7140:  0x039F,
	7141:  0x03A0,
	7142:  0x03A1,
	7143:  0x03A3,
	7144:  0x03A4,
	7145:  0x03A5,
	7146:  0x03A6,
	7147:  0x03A7,
	7148:  0x03A8,
	7149:  0x03A9,
	7158:  0x03B1,
	7159:  0x03B2,
	7160:  0x03B3,
	7161:  0x03B4,
	7162:  0x03B5,
	7163:  0x03B6,
	7164:  0x03B7,
	7165:  0x03B8,
	7166:  0x03B9,
	7167:  0x03BA,
	7168:  0x03BB,
	7169:  0x03BC,
	7170:  0x03BD,
	7171:  0x03BE,
	7172:  0x03BF,
	7173:  0x03C0,
	7174:  0x03C1,
	7175:  0x03C3,
	7176:  0x03C4,
	7177:  0x03C5,
	7178:  0x03C6,
	7179:  0x03C7,
	7180:  0x03C8,
	7181:  0x03C9,
	7189:  0xFE35,
	7190:  0xFE36,
	7191:  0xFE39,
	7192:  0xFE3A,
	7193:  0xFE3F,
	7194:  0xFE40,
	7195:  0xFE3D,
	7196:  0xFE3E,
	7197:  0xFE41,
	7198:  0xFE42,
	7199:  0xFE43,
	7200:  0xFE44,
	7203:  0xFE3B,
	7204:  0xFE3C,
	7205:  0xFE37,
	7206:  0xFE38,
	7207:  0xFE31,
	7209:  0xFE33,
	7210:  0xFE34,
	7316:  0x0410,
	7317:  0x0411,
	7318:  0x0412,
	7319:  0x0413,
	7320:  0x0414,
	7321:  0x0415,
	7322:  0x0401,
	7323:  0x0416,
	7324:  0x0417,
	7325:  0x0418,
	7326:  0x0419,
	7327:  0x041A,
	7328:  0x041B,
	7329:  0x041C,
	7330:  0x041D,
	7331:  0x041E,
	7332:  0x041F,
	7333:  0x0420,
	7334:  0x0421,
	7335:  0x0422,
	7336:  0x0423,
	7337:  0x0424,
	7338:  0x0425,
	7339:  0x0426,
	7340:  0x0427,
	7341:  0x0428,
	7342:  0x0429,
	7343:  0x042A,
	7344:  0x042B,
	7345:  0x042C,
	7346:  0x042D,
	7347:  0x042E,
	7348:  0x042F,
	7364:  0x0430,
	7365:  0x0431,
	7366:  0x0432,
	7367:  0x0433,
	7368:  0x0434,
	7369:  0x0435,
	7370:  0x0451,
	7371:  0x0436,
	7372:  0x0437,
	7373:  0x0438,
	7374:  0x0439,
	7375:  0x043A,
	7376:  0x043B,
	7377:  0x043C,
	7378:  0x043D,
	7379:  0x043E,
	7380:  0x043F,
	7381:  0x0440,
	7382:  0x0441,
	7383:  0x0442,
	7384:  0x0443,
	7385:  0x0444,
	7386:  0x0445,
	7387:  0x0446,
	7388:  0x0447,
	7389:  0x0448,
	7390:  0x0449,
	7391:  0x044A,
	7392:  0x044B,
	7393:  0x044C,
	7394:  0x044D,
	7395:  0x044E,
	7396:  0x044F,
	7410:  0x02CA,
	7411:  0x02CB,
	7412:  0x02D9,
	7413:  0x2013,
	7414:  0x2015,
	7415:  0x2025,
	7416:  0x2035,
	7417:  0x2105,
	7418:  0x2109,
	7419:  0x2196,
	7420:  0x2197,
	7421:  0x2198,
	7422:  0x2199,
	7423:  0x2215,
	7424:  0x221F,
	7425:  0x2223,
	7426:  0x2252,
	7427:  0x2266,
	7428:  0x2267,
	7429:  0x22BF,
	7430:  0x2550,
	7431:  0x2551,
	7432:  0x2552,
	7433:  0x2553,
	7434:  0x2554,
	7435:  0x2555,
	7436:  0x2556,
	7437:  0x2557,
	7438:  0x2558,
	7439:  0x2559,
	7440:  0x255A,
	7441:  0x255B,
	7442:  0x255C,
	7443:  0x255D,
	7444:  0x255E,
	7445:  0x255F,
	7446:  0x2560,
	7447:  0x2561,
	7448:  0x2562,
	7449:  0x2563,
	7450:  0x2564,
	7451:  0x2565,
	7452:  0x2566,
	7453:  0x2567,
	7454:  0x2568,
	7455:  0x2569,
	7456:  0x256A,
	7457:  0x256B,
	7458:  0x256C,
	7459:  0x256D,
	7460:  0x256E,
	7461:  0x256F,
	7462:  0x2570,
	7463:  0x2571,
	7464:  0x2572,
	7465:  0x2573,
	7466:  0x2581,
	7467:  0x2582,
	7468:  0x2583,
	7469:  0x2584,
	7470:  0x2585,
	7471:  0x2586,
	7472:  0x2587,
	7473:  0x2588,
	7474:  0x2589,
	7475:  0x258A,
	7476:  0x258B,
	7477:  0x258C,
	7478:  0x258D,
	7479:  0x258E,
	7480:  0x258F,
	7481:  0x2593,
	7482:  0x2594,
	7483:  0x2595,
	7484:  0x25BC,
	7485:  0x25BD,
	7486:  0x25E2,
	7487:  0x25E3,
	7488:  0x25E4,
	7489:  0x25E5,
	7490:  0x2609,
	7491:  0x2295,
	7492:  0x3012,
	7493:  0x301D,
	7494:  0x301E,
	7506:  0x0101,
	7507:  0x00E1,
	7508:  0x01CE,
	7509:  0x00E0,
	7510:  0x0113,
	7511:  0x00E9,
	7512:  0x011B,
	7513:  0x00E8,
	7514:  0x012B,
	7515:  0x00ED,
	7516:  0x01D0,
	7517:  0x00EC,
	7518:  0x014D,
	7519:  0x00F3,
	7520:  0x01D2,
	7521:  0x00F2,
	7522:  0x016B,
	7523:  0x00FA,
	7524:  0x01D4,
	7525:  0x00F9,
	7526:  0x01D6,
	7527:  0x01D8,
	7528:  0x01DA,
	7529:  0x01DC,
	7530:  0x00FC,
	7531:  0x00EA,
	7532:  0x0251,
	7534:  0x0144,
	7535:  0x0148,
	7536:  0x01F9,
	7537:  0x0261,
	7542:  0x3105,
	7543:  0x3106,
	7544:  0x3107,
	7545:  0x3108,
	7546:  0x3109,
	7547:  0x310A,
	7548:  0x310B,
	7549:  0x310C,
	7550:  0x310D,
	7551:  0x310E,
	7552:  0x310F,
	7553:  0x3110,
	7554:  0x3111,
	7555:  0x3112,
	7556:  0x3113,
	7557:  0x3114,
	7558:  0x3115,
	7559:  0x3116,
	7560:  0x3117,
	7561:  0x3118,
	7562:  0x3119,
	7563:  0x311A,
	7564:  0x311B,
	7565:  0x311C,
	7566:  0x311D,
	7567:  0x311E,
	7568:  0x311F,
	7569:  0x3120,
	7570:  0x3121,
	7571:  0x3122,
	7572:  0x3123,
	7573:  0x3124,
	7574:  0x3125,
	7575:  0x3126,
	7576:  0x3127,
	7577:  0x3128,
	7578:  0x3129,
	7600:  0x3021,
	7601:  0x3022,
	7602:  0x3023,
	7603:  0x3024,
	7604:  0x3025,
	7605:  0x3026,
	7606:  0x3027,
	7607:  0x3028,
	7608:  0x3029,
	7609:  0x32A3,
	7610:  0x338E,
	7611:  0x338F,
	7612:  0x339C,
	7613:  0x339D,
	7614:  0x339E,
	7615:  0x33A1,
	7616:  0x33C4,
	7617:  0x33CE,
	7618:  0x33D1,
	7619:  0x33D2,
	7620:  0x33D5,
	7621:  0xFE30,
	7622:  0xFFE2,
	7623:  0xFFE4,
	7625:  0x2121,
	7626:  0x3231,
	7628:  0x2010,
	7632:  0x30FC,
	7633:  0x309B,
	7634:  0x309C,
	7635:  0x30FD,
	7636:  0x30FE,
	7637:  0x3006,
	7638:  0x309D,
	7639:  0x309E,
	7640:  0xFE49,
	7641:  0xFE4A,
	7642:  0xFE4B,
	7643:  0xFE4C,
	7644:  0xFE4D,
	7645:  0xFE4E,
	7646:  0xFE4F,
	7647:  0xFE50,
	7648:  0xFE51,
	7649:  0xFE52,
	7650:  0xFE54,
	7651:  0xFE55,
	7652:  0xFE56,
	7653:  0xFE57,
	7654:  0xFE59,
	7655:  0xFE5A,
	7656:  0xFE5B,
	7657:  0xFE5C,
	7658:  0xFE5D,
	7659:  0xFE5E,
	7660:  0xFE5F,
	7661:  0xFE60,
	7662:  0xFE61,
	7663:  0xFE62,
	7664:  0xFE63,
	7665:  0xFE64,
	7666:  0xFE65,
	7667:  0xFE66,
	7668:  0xFE68,
	7669:  0xFE69,
	7670:  0xFE6A,
	7671:  0xFE6B,
	7672:  0x303E,
	7673:  0x2FF0,
	7674:  0x2FF1,
	7675:  0x2FF2,
	7676:  0x2FF3,
	7677:  0x2FF4,
	7678:  0x2FF5,
	7679:  0x2FF6,
	7680:  0x2FF7,
	7681:  0x2FF8,
	7682:  0x2FF9,
	7683:  0x2FFA,
	7684:  0x2FFB,
	7685:  0x3007,
	7699:  0x2500,
	7700:  0x2501,
	7701:  0x2502,
	7702:  0x2503,
	7703:  0x2504,
	7704:  0x2505,
	7705:  0x2506,
	7706:  0x2507,
	7707:  0x2508,
	7708:  0x2509,
	7709:  0x250A,
	7710:  0x250B,
	7711:  0x250C,
	7712:  0x250D,
	7713:  0x250E,
	7714:  0x250F,
	7715:  0x2510,
	7716:  0x2511,
	7717:  0x2512,
	7718:  0x2513,
	7719:  0x2514,
	7720:  0x2515,
	7721:  0x2516,
	7722:  0x2517,
	7723:  0x2518,
	7724:  0x2519,
	7725:  0x251A,
	7726:  0x251B,
	7727:  0x251C,
	7728:  0x251D,
	7729:  0x251E,
	7730:  0x251F,
	7731:  0x2520,
	7732:  0x2521,
	7733:  0x2522,
	7734:  0x2523,
	7735:  0x2524,
	7736:  0x2525,
	7737:  0x2526,
	7738:  0x2527,
	7739:  0x2528,
	7740:  0x2529,
	7741:  0x252A,
	7742:  0x252B,
	7743:  0x252C,
	7744:  0x252D,
	7745:  0x252E,
	7746:  0x252F,
	7747:  0x2530,
	7748:  0x2531,
	7749:  0x2532,
	7750:  0x2533,
	7751:  0x2534,
	7752:  0x2535,
	7753:  0x2536,
	7754:  0x2537,
	7755:  0x2538,
	7756:  0x2539,
	7757:  0x253A,
	7758:  0x253B,
	7759:  0x253C,
	7760:  0x253D,
	7761:  0x253E,
	7762:  0x253F,
	7763:  0x2540,
	7764:  0x2541,
	7765:  0x2542,
	7766:  0x2543,
	7767:  0x2544,
	7768:  0x2545,
	7769:  0x2546,
	7770:  0x2547,
	7771:  0x2548,
	7772:  0x2549,
	7773:  0x254A,
	7774:  0x254B,
	7790:  0x72DC,
	7791:  0x72DD,
	7792:  0x72DF,
	7793:  0x72E2,
	7794:  0x72E3,
	7795:  0x72E4,
	7796:  0x72E5,
	7797:  0x72E6,
	7798:  0x72E7,
	7799:  0x72EA,
	7800:  0x72EB,
	7801:  0x72F5,
	7802:  0x72F6,
	7803:  0x72F9,
	7804:  0x72FD,
	7805:  0x72FE,
	7806:  0x72FF,
	7807:  0x7300,
	7808:  0x7302,
	7809:  0x7304,
	7810:  0x7305,
	7811:  0x7306,
	7812:  0x7307,
	7813:  0x7308,
	7814:  0x7309,
	7815:  0x730B,
	7816:  0x730C,
	7817:  0x730D,
	7818:  0x730F,
	7819:  0x7310,
	7820:  0x7311,
	7821:  0x7312,
	7822:  0x7314,
	7823:  0x7318,
	7824:  0x7319,
	7825:  0x731A,
	7826:  0x731F,
	7827:  0x7320,
	7828:  0x7323,
	7829:  0x7324,
	7830:  0x7326,
	7831:  0x7327,
	7832:  0x7328,
	7833:  0x732D,
	7834:  0x732F,
	7835:  0x7330,
	7836:  0x7332,
	7837:  0x7333,
	7838:  0x7335,
	7839:  0x7336,
	7840:  0x733A,
	7841:  0x733B,
	7842:  0x733C,
	7843:  0x733D,
	7844:  0x7340,
	7845:  0x7341,
	7846:  0x7342,
	7847:  0x7343,
	7848:  0x7344,
	7849:  0x7345,
	7850:  0x7346,
	7851:  0x7347,
	7852:  0x7348,
	7853:  0x7349,
	7854:  0x734A,
	7855:  0x734B,
	7856:  0x734C,
	7857:  0x734E,
	7858:  0x734F,
	7859:  0x7351,
	7860:  0x7353,
	7861:  0x7354,
	7862:  0x7355,
	7863:  0x7356,
	7864:  0x7358,
	7865:  0x7359,
	7866:  0x735A,
	7867:  0x735B,
	7868:  0x735C,
	7869:  0x735D,
	7870:  0x735E,
	7871:  0x735F,
	7872:  0x7361,
	7873:  0x7362,
	7874:  0x7363,
	7875:  0x7364,
	7876:  0x7365,
	7877:  0x7366,
	7878:  0x7367,
	7879:  0x7368,
	7880:  0x7369,
	7881:  0x736A,
	7882:  0x736B,
	7883:  0x736E,
	7884:  0x7370,
	7885:  0x7371,
	7980:  0x7372,
	7981:  0x7373,
	7982:  0x7374,
	7983:  0x7375,
	7984:  0x7376,
	7985:  0x7377,
	7986:  0x7378,
	7987:  0x7379,
	7988:  0x737A,
	7989:  0x737B,
	7990:  0x737C,
	7991:  0x737D,
	7992:  0x737F,
	7993:  0x7380,
	7994:  0x7381,
	7995:  0x7382,
	7996:  0x7383,
	7997:  0x7385,
	7998:  0x7386,
	7999:  0x7388,
	8000:  0x738A,
	8001:  0x738C,
	8002:  0x738D,
	8003:  0x738F,
	8004:  0x7390,
	8005:  0x7392,
	8006:  0x7393,
	8007:  0x7394,
	8008:  0x7395,
	8009:  0x7397,
	8010:  0x7398,
	8011:  0x7399,
	8012:  0x739A,
	8013:  0x739C,
	8014:  0x739D,
	8015:  0x739E,
	8016:  0x73A0,
	8017:  0x73A1,
	8018:  0x73A3,
	8019:  0x73A4,
	8020:  0x73A5,
	8021:  0x73A6,
	8022:  0x73A7,
	8023:  0x73A8,
	8024:  0x73AA,
	8025:  0x73AC,
	8026:  0x73AD,
	8027:  0x73B1,
	8028:  0x73B4,
	8029:  0x73B5,
	8030:  0x73B6,
	8031:  0x73B8,
	8032:  0x73B9,
	8033:  0x73BC,
	8034:  0x73BD,
	8035:  0x73BE,
	8036:  0x73BF,
	8037:  0x73C1,
	8038:  0x73C3,
	8039:  0x73C4,
	8040:  0x73C5,
	8041:  0x73C6,
	8042:  0x73C7,
	8043:  0x73CB,
	8044:  0x73CC,
	8045:  0x73CE,
	8046:  0x73D2,
	8047:  0x73D3,
	8048:  0x73D4,
	8049:  0x73D5,
	8050:  0x73D6,
	8051:  0x73D7,
	8052:  0x73D8,
	8053:  0x73DA,
	8054:  0x73DB,
	8055:  0x73DC,
	8056:  0x73DD,
	8057:  0x73DF,
	8058:  0x73E1,
	8059:  0x73E2,
	8060:  0x73E3,
	8061:  0x73E4,
	8062:  0x73E6,
	8063:  0x73E8,
	8064:  0x73EA,
	8065:  0x73EB,
	8066:  0x73EC,
	8067:  0x73EE,
	8068:  0x73EF,
	8069:  0x73F0,
	8070:  0x73F1,
	8071:  0x73F3,
	8072:  0x73F4,
	8073:  0x73F5,
	8074:  0x73F6,
	8075:  0x73F7,
	8170:  0x73F8,
	8171:  0x73F9,
	8172:  0x73FA,
	8173:  0x73FB,
	8174:  0x73FC,
	8175:  0x73FD,
	8176:  0x73FE,
	8177:  0x73FF,
	8178:  0x7400,
	8179:  0x7401,
	8180:  0x7402,
	8181:  0x7404,
	8182:  0x7407,
	8183:  0x7408,
	8184:  0x740B,
	8185:  0x740C,
	8186:  0x740D,
	8187:  0x740E,
	8188:  0x7411,
	8189:  0x7412,
	8190:  0x7413,
	8191:  0x7414,
	8192:  0x7415,
	8193:  0x7416,
	8194:  0x7417,
	8195:  0x7418,
	8196:  0x7419,
	8197:  0x741C,
	8198:  0x741D,
	8199:  0x741E,
	8200:  0x741F,
	8201:  0x7420,
	8202:  0x7421,
	8203:  0x7423,
	8204:  0x7424,
	8205:  0x7427,
	8206:  0x7429,
	8207:  0x742B,
	8208:  0x742D,
	8209:  0x742F,
	8210:  0x7431,
	8211:  0x7432,
	8212:  0x7437,
	8213:  0x7438,
	8214:  0x7439,
	8215:  0x743A,
	8216:  0x743B,
	8217:  0x743D,
	8218:  0x743E,
	8219:  0x743F,
	8220:  0x7440,
	8221:  0x7442,
	8222:  0x7443,
	8223:  0x7444,
	8224:  0x7445,
	8225:  0x7446,
	8226:  0x7447,
	8227:  0x7448,
	8228:  0x7449,
	8229:  0x744A,
	8230:  0x744B,
	8231:  0x744C,
	8232:  0x744D,
	8233:  0x744E,
	8234:  0x744F,
	8235:  0x7450,
	8236:  0x7451,
	8237:  0x7452,
	8238:  0x7453,
	8239:  0x7454,
	8240:  0x7456,
	8241:  0x7458,
	8242:  0x745D,
	8243:  0x7460,
	8244:  0x7461,
	8245:  0x7462,
	8246:  0x7463,
	8247:  0x7464,
	8248:  0x7465,
	8249:  0x7466,
	8250:  0x7467,
	8251:  0x7468,
	8252:  0x7469,
	8253:  0x746A,
	8254:  0x746B,
	8255:  0x746C,
	8256:  0x746E,
	8257:  0x746F,
	8258:  0x7471,
	8259:  0x7472,
	8260:  0x7473,
	8261:  0x7474,
	8262:  0x7475,
	8263:  0x7478,
	8264:  0x7479,
	8265:  0x747A,
	8360:  0x747B,
	8361:  0x747C,
	8362:  0x747D,
	8363:  0x747F,
	8364:  0x7482,
	8365:  0x7484,
	8366:  0x7485,
	8367:  0x7486,
	8368:  0x7488,
	8369:  0x7489,
	8370:  0x748A,
	8371:  0x748C,
	8372:  0x748D,
	8373:  0x748F,
	8374:  0x7491,
	8375:  0x7492,
	8376:  0x7493,
	8377:  0x7494,
	8378:  0x7495,
	8379:  0x7496,
	8380:  0x7497,
	8381:  0x7498,
	8382:  0x7499,
	8383:  0x749A,
	8384:  0x749B,
	8385:  0x749D,
	8386:  0x749F,
	8387:  0x74A0,
	8388:  0x74A1,
	8389:  0x74A2,
	8390:  0x74A3,
	8391:  0x74A4,
	8392:  0x74A5,
	8393:  0x74A6,
	8394:  0x74AA,
	8395:  0x74AB,
	8396:  0x74AC,
	8397:  0x74AD,
	8398:  0x74AE,
	8399:  0x74AF,
	8400:  0x74B0,
	8401:  0x74B1,
	8402:  0x74B2,
	8403:  0x74B3,
	8404:  0x74B4,
	8405:  0x74B5,
	8406:  0x74B6,
	8407:  0x74B7,
	8408:  0x74B8,
	8409:  0x74B9,
	8410:  0x74BB,
	8411:  0x74BC,
	8412:  0x74BD,
	8413:  0x74BE,
	8414:  0x74BF,
	8415:  0x74C0,
	8416:  0x74C1,
	8417:  0x74C2,
	8418:  0x74C3,
	8419:  0x74C4,
	8420:  0x74C5,
	8421:  0x74C6,
	8422:  0x74C7,
	8423:  0x74C8,
	8424:  0x74C9,
	8425:  0x74CA,
	8426:  0x74CB,
	8427:  0x74CC,
	8428:  0x74CD,
	8429:  0x74CE,
	8430:  0x74CF,
	8431:  0x74D0,
	8432:  0x74D1,
	8433:  0x74D3,
	8434:  0x74D4,
	8435:  0x74D5,
	8436:  0x74D6,
	8437:  0x74D7,
	8438:  0x74D8,
	8439:  0x74D9,
	8440:  0x74DA,
	8441:  0x74DB,
	8442:  0x74DD,
	8443:  0x74DF,
	8444:  0x74E1,
	8445:  0x74E5,
	8446:  0x74E7,
	8447:  0x74E8,
	8448:  0x74E9,
	8449:  0x74EA,
	8450:  0x74EB,
	8451:  0x74EC,
	8452:  0x74ED,
	8453:  0x74F0,
	8454:  0x74F1,
	8455:  0x74F2,
	8550:  0x74F3,
	8551:  0x74F5,
	8552:  0x74F8,
	8553:  0x74F9,
	8554:  0x74FA,
	8555:  0x74FB,
	8556:  0x74FC,
	8557:  0x74FD,
	8558:  0x74FE,
	8559:  0x7500,
	8560:  0x7501,
	8561:  0x7502,
	8562:  0x7503,
	8563:  0x7505,
	8564:  0x7506,
	8565:  0x7507,
	8566:  0x7508,
	8567:  0x7509,
	8568:  0x750A,
	8569:  0x750B,
	8570:  0x750C,
	8571:  0x750E,
	8572:  0x7510,
	8573:  0x7512,
	8574:  0x7514,
	8575:  0x7515,
	8576:  0x7516,
	8577:  0x7517,
	8578:  0x751B,
	8579:  0x751D,
	8580:  0x751E,
	8581:  0x7520,
	8582:  0x7521,
	8583:  0x7522,
	8584:  0x7523,
	8585:  0x7524,
	8586:  0x7526,
	8587:  0x7527,
	8588:  0x752A,
	8589:  0x752E,
	8590:  0x7534,
	8591:  0x7536,
	8592:  0x7539,
	8593:  0x753C,
	8594:  0x753D,
	8595:  0x753F,
	8596:  0x7541,
	8597:  0x7542,
	8598:  0x7543,
	8599:  0x7544,
	8600:  0x7546,
	8601:  0x7547,
	8602:  0x7549,
	8603:  0x754A,
	8604:  0x754D,
	8605:  0x7550,
	8606:  0x7551,
	8607:  0x7552,
	8608:  0x7553,
	8609:  0x7555,
	8610:  0x7556,
	8611:  0x7557,
	8612:  0x7558,
	8613:  0x755D,
	8614:  0x755E,
	8615:  0x755F,
	8616:  0x7560,
	8617:  0x7561,
	8618:  0x7562,
	8619:  0x7563,
	8620:  0x7564,
	8621:  0x7567,
	8622:  0x7568,
	8623:  0x7569,
	8624:  0x756B,
	8625:  0x756C,
	8626:  0x756D,
	8627:  0x756E,
	8628:  0x756F,
	8629:  0x7570,
	8630:  0x7571,
	8631:  0x7573,
	8632:  0x7575,
	8633:  0x7576,
	8634:  0x7577,
	8635:  0x757A,
	8636:  0x757B,
	8637:  0x757C,
	8638:  0x757D,
	8639:  0x757E,
	8640:  0x7580,
	8641:  0x7581,
	8642:  0x7582,
	8643:  0x7584,
	8644:  0x7585,
	8645:  0x7587,
	8740:  0x7588,
	8741:  0x7589,
	8742:  0x758A,
	8743:  0x758C,
	8744:  0x758D,
	8745:  0x758E,
	8746:  0x7590,
	8747:  0x7593,
	8748:  0x7595,
	8749:  0x7598,
	8750:  0x759B,
	8751:  0x759C,
	8752:  0x759E,
	8753:  0x75A2,
	8754:  0x75A6,
	8755:  0x75A7,
	8756:  0x75A8,
	8757:  0x75A9,
	8758:  0x75AA,
	8759:  0x75AD,
	8760:  0x75B6,
	8761:  0x75B7,
	8762:  0x75BA,
	8763:  0x75BB,
	8764:  0x75BF,
	8765:  0x75C0,
	8766:  0x75C1,
	8767:  0x75C6,
	8768:  0x75CB,
	8769:  0x75CC,
	8770:  0x75CE,
	8771:  0x75CF,
	8772:  0x75D0,
	8773:  0x75D1,
	8774:  0x75D3,
	8775:  0x75D7,
	8776:  0x75D9,
	8777:  0x75DA,
	8778:  0x75DC,
	8779:  0x75DD,
	8780:  0x75DF,
	8781:  0x75E0,
	8782:  0x75E1,
	8783:  0x75E5,
	8784:  0x75E9,
	8785:  0x75EC,
	8786:  0x75ED,
	8787:  0x75EE,
	8788:  0x75EF,
	8789:  0x75F2,
	8790:  0x75F3,
	8791:  0x75F5,
	8792:  0x75F6,
	8793:  0x75F7,
	8794:  0x75F8,
	8795:  0x75FA,
	8796:  0x75FB,
	8797:  0x75FD,
	8798:  0x75FE,
	8799:  0x7602,
	8800:  0x7604,
	8801:  0x7606,
	8802:  0x7607,
	8803:  0x7608,
	8804:  0x7609,
	8805:  0x760B,
	8806:  0x760D,
	8807:  0x760E,
	8808:  0x760F,
	8809:  0x7611,
	8810:  0x7612,
	8811:  0x7613,
	8812:  0x7614,
	8813:  0x7616,
	8814:  0x761A,
	8815:  0x761C,
	8816:  0x761D,
	8817:  0x761E,
	8818:  0x7621,
	8819:  0x7623,
	8820:  0x7627,
	8821:  0x7628,
	8822:  0x762C,
	8823:  0x762E,
	8824:  0x762F,
	8825:  0x7631,
	8826:  0x7632,
	8827:  0x7636,
	8828:  0x7637,
	8829:  0x7639,
	8830:  0x763A,
	8831:  0x763B,
	8832:  0x763D,
	8833:  0x7641,
	8834:  0x7642,
	8835:  0x7644,
	8930:  0x7645,
	8931:  0x7646,
	8932:  0x7647,
	8933:  0x7648,
	8934:  0x7649,
	8935:  0x764A,
	8936:  0x764B,
	8937:  0x764E,
	8938:  0x764F,
	8939:  0x7650,
	8940:  0x7651,
	8941:  0x7652,
	8942:  0x7653,
	8943:  0x7655,
	8944:  0x7657,
	8945:  0x7658,
	8946:  0x7659,
	8947:  0x765A,
	8948:  0x765B,
	8949:  0x765D,
	8950:  0x765F,
	8951:  0x7660,
	8952:  0x7661,
	8953:  0x7662,
	8954:  0x7664,
	8955:  0x7665,
	8956:  0x7666,
	8957:  0x7667,
	8958:  0x7668,
	8959:  0x7669,
	8960:  0x766A,
	8961:  0x766C,
	8962:  0x766D,
	8963:  0x766E,
	8964:  0x7670,
	8965:  0x7671,
	8966:  0x7672,
	8967:  0x7673,
	8968:  0x7674,
	8969:  0x7675,
	8970:  0x7676,
	8971:  0x7677,
	8972:  0x7679,
	8973:  0x767A,
	8974:  0x767C,
	8975:  0x767F,
	8976:  0x7680,
	8977:  0x7681,
	8978:  0x7683,
	8979:  0x7685,
	8980:  0x7689,
	8981:  0x768A,
	8982:  0x768C,
	8983:  0x768D,
	8984:  0x768F,
	8985:  0x7690,
	8986:  0x7692,
	8987:  0x7694,
	8988:  0x7695,
	8989:  0x7697,
	8990:  0x7698,
	8991:  0x769A,
	8992:  0x769B,
	8993:  0x769C,
	8994:  0x769D,
	8995:  0x769E,
	8996:  0x769F,
	8997:  0x76A0,
	8998:  0x76A1,
	8999:  0x76A2,
	9000:  0x76A3,
	9001:  0x76A5,
	9002:  0x76A6,
	9003:  0x76A7,
	9004:  0x76A8,
	9005:  0x76A9,
	9006:  0x76AA,
	9007:  0x76AB,
	9008:  0x76AC,
	9009:  0x76AD,
	9010:  0x76AF,
	9011:  0x76B0,
	9012:  0x76B3,
	9013:  0x76B5,
	9014:  0x76B6,
	9015:  0x76B7,
	9016:  0x76B8,
	9017:  0x76B9,
	9018:  0x76BA,
	9019:  0x76BB,
	9020:  0x76BC,
	9021:  0x76BD,
	9022:  0x76BE,
	9023:  0x76C0,
	9024:  0x76C1,
	9025:  0x76C3,
	9026:  0x554A,
	9027:  0x963F,
	9028:  0x57C3,
	9029:  0x6328,
	9030:  0x54CE,
	9031:  0x5509,
	9032:  0x54C0,
	9033:  0x7691,
	9034:  0x764C,
	9035:  0x853C,
	9036:  0x77EE,
	9037:  0x827E,
	9038:  0x788D,
	9039:  0x7231,
	9040:  0x9698,
	9041:  0x978D,
	9042:  0x6C28,
	9043:  0x5B89,
	9044:  0x4FFA,
	9045:  0x6309,
	9046:  0x6697,
	9047:  0x5CB8,
	9048:  0x80FA,
	9049:  0x6848,
	9050:  0x80AE,
	9051:  0x6602,
	9052:  0x76CE,
	9053:  0x51F9,
	9054:  0x6556,
	9055:  0x71AC,
	9056:  0x7FF1,
	9057:  0x8884,
	9058:  0x50B2,
	9059:  0x5965,
	9060:  0x61CA,
	9061:  0x6FB3,
	9062:  0x82AD,
	9063:  0x634C,
	9064:  0x6252,
	9065:  0x53ED,
	9066:  0x5427,
	9067:  0x7B06,
	9068:  0x516B,
	9069:  0x75A4,
	9070:  0x5DF4,
	9071:  0x62D4,
	9072:  0x8DCB,
	9073:  0x9776,
	9074:  0x628A,
	9075:  0x8019,
	9076:  0x575D,
	9077:  0x9738,
	9078:  0x7F62,
	9079:  0x7238,
	9080:  0x767D,
	9081:  0x67CF,
	9082:  0x767E,
	9083:  0x6446,
	9084:  0x4F70,
	9085:  0x8D25,
	9086:  0x62DC,
	9087:  0x7A17,
	9088:  0x6591,
	9089:  0x73ED,
	9090:  0x642C,
	9091:  0x6273,
	9092:  0x822C,
	9093:  0x9881,
	9094:  0x677F,
	9095:  0x7248,
	9096:  0x626E,
	9097:  0x62CC,
	9098:  0x4F34,
	9099:  0x74E3,
	9100:  0x534A,
	9101:  0x529E,
	9102:  0x7ECA,
	9103:  0x90A6,
	9104:  0x5E2E,
	9105:  0x6886,
	9106:  0x699C,
	9107:  0x8180,
	9108:  0x7ED1,
	9109:  0x68D2,
	9110:  0x78C5,
	9111:  0x868C,
	9112:  0x9551,
	9113:  0x508D,
	9114:  0x8C24,
	9115:  0x82DE,
	9116:  0x80DE,
	9117:  0x5305,
	9118:  0x8912,
	9119:  0x5265,
	9120:  0x76C4,
	9121:  0x76C7,
	9122:  0x76C9,
	9123:  0x76CB,
	9124:  0x76CC,
	9125:  0x76D3,
	9126:  0x76D5,
	9127:  0x76D9,
	9128:  0x76DA,
	9129:  0x76DC,
	9130:  0x76DD,
	9131:  0x76DE,
	9132:  0x76E0,
	9133:  0x76E1,
	9134:  0x76E2,
	9135:  0x76E3,
	9136:  0x76E4,
	9137:  0x76E6,
	9138:  0x76E7,
	9139:  0x76E8,
	9140:  0x76E9,
	9141:  0x76EA,
	9142:  0x76EB,
	9143:  0x76EC,
	9144:  0x76ED,
	9145:  0x76F0,
	9146:  0x76F3,
	9147:  0x76F5,
	9148:  0x76F6,
	9149:  0x76F7,
	9150:  0x76FA,
	9151:  0x76FB,
	9152:  0x76FD,
	9153:  0x76FF,
	9154:  0x7700,
	9155:  0x7702,
	9156:  0x7703,
	9157:  0x7705,
	9158:  0x7706,
	9159:  0x770A,
	9160:  0x770C,
	9161:  0x770E,
	9162:  0x770F,
	9163:  0x7710,
	9164:  0x7711,
	9165:  0x7712,
	9166:  0x7713,
	9167:  0x7714,
	9168:  0x7715,
	9169:  0x7716,
	9170:  0x7717,
	9171:  0x7718,
	9172:  0x771B,
	9173:  0x771C,
	9174:  0x771D,
	9175:  0x771E,
	9176:  0x7721,
	9177:  0x7723,
	9178:  0x7724,
	9179:  0x7725,
	9180:  0x7727,
	9181:  0x772A,
	9182:  0x772B,
	9183:  0x772C,
	9184:  0x772E,
	9185:  0x7730,
	9186:  0x7731,
	9187:  0x7732,
	9188:  0x7733,
	9189:  0x7734,
	9190:  0x7739,
	9191:  0x773B,
	9192:  0x773D,
	9193:  0x773E,
	9194:  0x773F,
	9195:  0x7742,
	9196:  0x7744,
	9197:  0x7745,
	9198:  0x7746,
	9199:  0x7748,
	9200:  0x7749,
	9201:  0x774A,
	9202:  0x774B,
	9203:  0x774C,
	9204:  0x774D,
	9205:  0x774E,
	9206:  0x774F,
	9207:  0x7752,
	9208:  0x7753,
	9209:  0x7754,
	9210:  0x7755,
	9211:  0x7756,
	9212:  0x7757,
	9213:  0x7758,
	9214:  0x7759,
	9215:  0x775C,
	9216:  0x8584,
	9217:  0x96F9,
	9218:  0x4FDD,
	9219:  0x5821,
	9220:  0x9971,
	9221:  0x5B9D,
	9222:  0x62B1,
	9223:  0x62A5,
	9224:  0x66B4,
	9225:  0x8C79,
	9226:  0x9C8D,
	9227:  0x7206,
	9228:  0x676F,
	9229:  0x7891,
	9230:  0x60B2,
	9231:  0x5351,
	9232:  0x5317,
	9233:  0x8F88,
	9234:  0x80CC,
	9235:  0x8D1D,
	9236:  0x94A1,
	9237:  0x500D,
	9238:  0x72C8,
	9239:  0x5907,
	9240:  0x60EB,
	9241:  0x7119,
	9242:  0x88AB,
	9243:  0x5954,
	9244:  0x82EF,
	9245:  0x672C,
	9246:  0x7B28,
	9247:  0x5D29,
	9248:  0x7EF7,
	9249:  0x752D,
	9250:  0x6CF5,
	9251:  0x8E66,
	9252:  0x8FF8,
	9253:  0x903C,
	9254:  0x9F3B,
	9255:  0x6BD4,
	9256:  0x9119,
	9257:  0x7B14,
	9258:  0x5F7C,
	9259:  0x78A7,
	9260:  0x84D6,
	9261:  0x853D,
	9262:  0x6BD5,
	9263:  0x6BD9,
	9264:  0x6BD6,
	9265:  0x5E01,
	9266:  0x5E87,
	9267:  0x75F9,
	9268:  0x95ED,
	9269:  0x655D,
	9270:  0x5F0A,
	9271:  0x5FC5,
	9272:  0x8F9F,
	9273:  0x58C1,
	9274:  0x81C2,
	9275:  0x907F,
	9276:  0x965B,
	9277:  0x97AD,
	9278:  0x8FB9,
	9279:  0x7F16,
	9280:  0x8D2C,
	9281:  0x6241,
	9282:  0x4FBF,
	9283:  0x53D8,
	9284:  0x535E,
	9285:  0x8FA8,
	9286:  0x8FA9,
	9287:  0x8FAB,
	9288:  0x904D,
	9289:  0x6807,
	9290:  0x5F6A,
	9291:  0x8198,
	9292:  0x8868,
	9293:  0x9CD6,
	9294:  0x618B,
	9295:  0x522B,
	9296:  0x762A,
	9297:  0x5F6C,
	9298:  0x658C,
	9299:  0x6FD2,
	9300:  0x6EE8,
	9301:  0x5BBE,
	9302:  0x6448,
	9303:  0x5175,
	9304:  0x51B0,
	9305:  0x67C4,
	9306:  0x4E19,
	9307:  0x79C9,
	9308:  0x997C,
	9309:  0x70B3,
	9310:  0x775D,
	9311:  0x775E,
	9312:  0x775F,
	9313:  0x7760,
	9314:  0x7764,
	9315:  0x7767,
	9316:  0x7769,
	9317:  0x776A,
	9318:  0x776D,
	9319:  0x776E,
	9320:  0x776F,
	9321:  0x7770,
	9322:  0x7771,
	9323:  0x7772,
	9324:  0x7773,
	9325:  0x7774,
	9326:  0x7775,
	9327:  0x7776,
	9328:  0x7777,
	9329:  0x7778,
	9330:  0x777A,
	9331:  0x777B,
	9332:  0x777C,
	9333:  0x7781,
	9334:  0x7782,
	9335:  0x7783,
	9336:  0x7786,
	9337:  0x7787,
	9338:  0x7788,
	9339:  0x7789,
	9340:  0x778A,
	9341:  0x778B,
	9342:  0x778F,
	9343:  0x7790,
	9344:  0x7793,
	9345:  0x7794,
	9346:  0x7795,
	9347:  0x7796,
	9348:  0x7797,
	9349:  0x7798,
	9350:  0x7799,
	9351:  0x779A,
	9352:  0x779B,
	9353:  0x779C,
	9354:  0x779D,
	9355:  0x779E,
	9356:  0x77A1,
	9357:  0x77A3,
	9358:  0x77A4,
	9359:  0x77A6,
	9360:  0x77A8,
	9361:  0x77AB,
	9362:  0x77AD,
	9363:  0x77AE,
	9364:  0x77AF,
	9365:  0x77B1,
	9366:  0x77B2,
	9367:  0x77B4,
	9368:  0x77B6,
	9369:  0x77B7,
	9370:  0x77B8,
	9371:  0x77B9,
	9372:  0x77BA,
	9373:  0x77BC,
	9374:  0x77BE,
	9375:  0x77C0,
	9376:  0x77C1,
	9377:  0x77C2,
	9378:  0x77C3,
	9379:  0x77C4,
	9380:  0x77C5,
	9381:  0x77C6,
	9382:  0x77C7,
	9383:  0x77C8,
	9384:  0x77C9,
	9385:  0x77CA,
	9386:  0x77CB,
	9387:  0x77CC,
	9388:  0x77CE,
	9389:  0x77CF,
	9390:  0x77D0,
	9391:  0x77D1,
	9392:  0x77D2,
	9393:  0x77D3,
	9394:  0x77D4,
	9395:  0x77D5,
	9396:  0x77D6,
	9397:  0x77D8,
	9398:  0x77D9,
	9399:  0x77DA,
	9400:  0x77DD,
	9401:  0x77DE,
	9402:  0x77DF,
	9403:  0x77E0,
	9404:  0x77E1,
	9405:  0x77E4,
	9406:  0x75C5,
	9407:  0x5E76,
	9408:  0x73BB,
	9409:  0x83E0,
	9410:  0x64AD,
	9411:  0x62E8,
	9412:  0x94B5,
	9413:  0x6CE2,
	9414:  0x535A,
	9415:  0x52C3,
	9416:  0x640F,
	9417:  0x94C2,
	9418:  0x7B94,
	9419:  0x4F2F,
	9420:  0x5E1B,
	9421:  0x8236,
	9422:  0x8116,
	9423:  0x818A,
	9424:  0x6E24,
	9425:  0x6CCA,
	9426:  0x9A73,
	9427:  0x6355,
	9428:  0x535C,
	9429:  0x54FA,
	9430:  0x8865,
	9431:  0x57E0,
	9432:  0x4E0D,
	9433:  0x5E03,
	9434:  0x6B65,
	9435:  0x7C3F,
	9436:  0x90E8,
	9437:  0x6016,
	9438:  0x64E6,
	9439:  0x731C,
	9440:  0x88C1,
	9441:  0x6750,
	9442:  0x624D,
	9443:  0x8D22,
	9444:  0x776C,
	9445:  0x8E29,
	9446:  0x91C7,
	9447:  0x5F69,
	9448:  0x83DC,
	9449:  0x8521,
	9450:  0x9910,
	9451:  0x53C2,
	9452:  0x8695,
	9453:  0x6B8B,
	9454:  0x60ED,
	9455:  0x60E8,
	9456:  0x707F,
	9457:  0x82CD,
	9458:  0x8231,
	9459:  0x4ED3,
	9460:  0x6CA7,
	9461:  0x85CF,
	9462:  0x64CD,
	9463:  0x7CD9,
	9464:  0x69FD,
	9465:  0x66F9,
	9466:  0x8349,
	9467:  0x5395,
	9468:  0x7B56,
	9469:  0x4FA7,
	9470:  0x518C,
	9471:  0x6D4B,
	9472:  0x5C42,
	9473:  0x8E6D,
	9474:  0x63D2,
	9475:  0x53C9,
	9476:  0x832C,
	9477:  0x8336,
	9478:  0x67E5,
	9479:  0x78B4,
	9480:  0x643D,
	9481:  0x5BDF,
	9482:  0x5C94,
	9483:  0x5DEE,
	9484:  0x8BE7,
	9485:  0x62C6,
	9486:  0x67F4,
	9487:  0x8C7A,
	9488:  0x6400,
	9489:  0x63BA,
	9490:  0x8749,
	9491:  0x998B,
	9492:  0x8C17,
	9493:  0x7F20,
	9494:  0x94F2,
	9495:  0x4EA7,
	9496:  0x9610,
	9497:  0x98A4,
	9498:  0x660C,
	9499:  0x7316,
	9500:  0x77E6,
	9501:  0x77E8,
	9502:  0x77EA,
	9503:  0x77EF,
	9504:  0x77F0,
	9505:  0x77F1,
	9506:  0x77F2,
	9507:  0x77F4,
	9508:  0x77F5,
	9509:  0x77F7,
	9510:  0x77F9,
	9511:  0x77FA,
	9512:  0x77FB,
	9513:  0x77FC,
	9514:  0x7803,
	9515:  0x7804,
	9516:  0x7805,
	9517:  0x7806,
	9518:  0x7807,
	9519:  0x7808,
	9520:  0x780A,
	9521:  0x780B,
	9522:  0x780E,
	9523:  0x780F,
	9524:  0x7810,
	9525:  0x7813,
	9526:  0x7815,
	9527:  0x7819,
	9528:  0x781B,
	9529:  0x781E,
	9530:  0x7820,
	9531:  0x7821,
	9532:  0x7822,
	9533:  0x7824,
	9534:  0x7828,
	9535:  0x782A,
	9536:  0x782B,
	9537:  0x782E,
	9538:  0x782F,
	9539:  0x7831,
	9540:  0x7832,
	9541:  0x7833,
	9542:  0x7835,
	9543:  0x7836,
	9544:  0x783D,
	9545:  0x783F,
	9546:  0x7841,
	9547:  0x7842,
	9548:  0x7843,
	9549:  0x7844,
	9550:  0x7846,
	9551:  0x7848,
	9552:  0x7849,
	9553:  0x784A,
	9554:  0x784B,
	9555:  0x784D,
	9556:  0x784F,
	9557:  0x7851,
	9558:  0x7853,
	9559:  0x7854,
	9560:  0x7858,
	9561:  0x7859,
	9562:  0x785A,
	9563:  0x785B,
	9564:  0x785C,
	9565:  0x785E,
	9566:  0x785F,
	9567:  0x7860,
	9568:  0x7861,
	9569:  0x7862,
	9570:  0x7863,
	9571:  0x7864,
	9572:  0x7865,
	9573:  0x7866,
	9574:  0x7867,
	9575:  0x7868,
	9576:  0x7869,
	9577:  0x786F,
	9578:  0x7870,
	9579:  0x7871,
	9580:  0x7872,
	9581:  0x7873,
	9582:  0x7874,
	9583:  0x7875,
	9584:  0x7876,
	9585:  0x7878,
	9586:  0x7879,
	9587:  0x787A,
	9588:  0x787B,
	9589:  0x787D,
	9590:  0x787E,
	9591:  0x787F,
	9592:  0x7880,
	9593:  0x7881,
	9594:  0x7882,
	9595:  0x7883,
	9596:  0x573A,
	9597:  0x5C1D,
	9598:  0x5E38,
	9599:  0x957F,
	9600:  0x507F,
	9601:  0x80A0,
	9602:  0x5382,
	9603:  0x655E,
	9604:  0x7545,
	9605:  0x5531,
	9606:  0x5021,
	9607:  0x8D85,
	9608:  0x6284,
	9609:  0x949E,
	9610:  0x671D,
	9611:  0x5632,
	9612:  0x6F6E,
	9613:  0x5DE2,
	9614:  0x5435,
	9615:  0x7092,
	9616:  0x8F66,
	9617:  0x626F,
	9618:  0x64A4,
	9619:  0x63A3,
	9620:  0x5F7B,
	9621:  0x6F88,
	9622:  0x90F4,
	9623:  0x81E3,
	9624:  0x8FB0,
	9625:  0x5C18,
	9626:  0x6668,
	9627:  0x5FF1,
	9628:  0x6C89,
	9629:  0x9648,
	9630:  0x8D81,
	9631:  0x886C,
	9632:  0x6491,
	9633:  0x79F0,
	9634:  0x57CE,
	9635:  0x6A59,
	9636:  0x6210,
	9637:  0x5448,
	9638:  0x4E58,
	9639:  0x7A0B,
	9640:  0x60E9,
	9641:  0x6F84,
	9642:  0x8BDA,
	9643:  0x627F,
	9644:  0x901E,
	9645:  0x9A8B,
	9646:  0x79E4,
	9647:  0x5403,
	9648:  0x75F4,
	9649:  0x6301,
	9650:  0x5319,
	9651:  0x6C60,
	9652:  0x8FDF,
	9653:  0x5F1B,
	9654:  0x9A70,
	9655:  0x803B,
	9656:  0x9F7F,
	9657:  0x4F88,
	9658:  0x5C3A,
	9659:  0x8D64,
	9660:  0x7FC5,
	9661:  0x65A5,
	9662:  0x70BD,
	9663:  0x5145,
	9664:  0x51B2,
	9665:  0x866B,
	9666:  0x5D07,
	9667:  0x5BA0,
	9668:  0x62BD,
	9669:  0x916C,
	9670:  0x7574,
	9671:  0x8E0C,
	9672:  0x7A20,
	9673:  0x6101,
	9674:  0x7B79,
	9675:  0x4EC7,
	9676:  0x7EF8,
	9677:  0x7785,
	9678:  0x4E11,
	9679:  0x81ED,
	9680:  0x521D,
	9681:  0x51FA,
	9682:  0x6A71,
	9683:  0x53A8,
	9684:  0x8E87,
	9685:  0x9504,
	9686:  0x96CF,
	9687:  0x6EC1,
	9688:  0x9664,
	9689:  0x695A,
	9690:  0x7884,
	9691:  0x7885,
	9692:  0x7886,
	9693:  0x7888,
	9694:  0x788A,
	9695:  0x788B,
	9696:  0x788F,
	9697:  0x7890,
	9698:  0x7892,
	9699:  0x7894,
	9700:  0x7895,
	9701:  0x7896,
	9702:  0x7899,
	9703:  0x789D,
	9704:  0x789E,
	9705:  0x78A0,
	9706:  0x78A2,
	9707:  0x78A4,
	9708:  0x78A6,
	9709:  0x78A8,
	9710:  0x78A9,
	9711:  0x78AA,
	9712:  0x78AB,
	9713:  0x78AC,
	9714:  0x78AD,
	9715:  0x78AE,
	9716:  0x78AF,
	9717:  0x78B5,
	9718:  0x78B6,
	9719:  0x78B7,
	9720:  0x78B8,
	9721:  0x78BA,
	9722:  0x78BB,
	9723:  0x78BC,
	9724:  0x78BD,
	9725:  0x78BF,
	9726:  0x78C0,
	9727:  0x78C2,
	9728:  0x78C3,
	9729:  0x78C4,
	9730:  0x78C6,
	9731:  0x78C7,
	9732:  0x78C8,
	9733:  0x78CC,
	9734:  0x78CD,
	9735:  0x78CE,
	9736:  0x78CF,
	9737:  0x78D1,
	9738:  0x78D2,
	9739:  0x78D3,
	9740:  0x78D6,
	9741:  0x78D7,
	9742:  0x78D8,
	9743:  0x78DA,
	9744:  0x78DB,
	9745:  0x78DC,
	9746:  0x78DD,
	9747:  0x78DE,
	9748:  0x78DF,
	9749:  0x78E0,
	9750:  0x78E1,
	9751:  0x78E2,
	9752:  0x78E3,
	9753:  0x78E4,
	9754:  0x78E5,
	9755:  0x78E6,
	9756:  0x78E7,
	9757:  0x78E9,
	9758:  0x78EA,
	9759:  0x78EB,
	9760:  0x78ED,
	9761:  0x78EE,
	9762:  0x78EF,
	9763:  0x78F0,
	9764:  0x78F1,
	9765:  0x78F3,
	9766:  0x78F5,
	9767:  0x78F6,
	9768:  0x78F8,
	9769:  0x78F9,
	9770:  0x78FB,
	9771:  0x78FC,
	9772:  0x78FD,
	9773:  0x78FE,
	9774:  0x78FF,
	9775:  0x7900,
	9776:  0x7902,
	9777:  0x7903,
	9778:  0x7904,
	9779:  0x7906,
	9780:  0x7907,
	9781:  0x7908,
	9782:  0x7909,
	9783:  0x790A,
	9784:  0x790B,
	9785:  0x790C,
	9786:  0x7840,
	9787:  0x50A8,
	9788:  0x77D7,
	9789:  0x6410,
	9790:  0x89E6,
	9791:  0x5904,
	9792:  0x63E3,
	9793:  0x5DDD,
	9794:  0x7A7F,
	9795:  0x693D,
	9796:  0x4F20,
	9797:  0x8239,
	9798:  0x5598,
	9799:  0x4E32,
	9800:  0x75AE,
	9801:  0x7A97,
	9802:  0x5E62,
	9803:  0x5E8A,
	9804:  0x95EF,
	9805:  0x521B,
	9806:  0x5439,
	9807:  0x708A,
	9808:  0x6376,
	9809:  0x9524,
	9810:  0x5782,
	9811:  0x6625,
	9812:  0x693F,
	9813:  0x9187,
	9814:  0x5507,
	9815:  0x6DF3,
	9816:  0x7EAF,
	9817:  0x8822,
	9818:  0x6233,
	9819:  0x7EF0,
	9820:  0x75B5,
	9821:  0x8328,
	9822:  0x78C1,
	9823:  0x96CC,
	9824:  0x8F9E,
	9825:  0x6148,
	9826:  0x74F7,
	9827:  0x8BCD,
	9828:  0x6B64,
	9829:  0x523A,
	9830:  0x8D50,
	9831:  0x6B21,
	9832:  0x806A,
	9833:  0x8471,
	9834:  0x56F1,
	9835:  0x5306,
	9836:  0x4ECE,
	9837:  0x4E1B,
	9838:  0x51D1,
	9839:  0x7C97,
	9840:  0x918B,
	9841:  0x7C07,
	9842:  0x4FC3,
	9843:  0x8E7F,
	9844:  0x7BE1,
	9845:  0x7A9C,
	9846:  0x6467,
	9847:  0x5D14,
	9848:  0x50AC,
	9849:  0x8106,
	9850:  0x7601,
	9851:  0x7CB9,
	9852:  0x6DEC,
	9853:  0x7FE0,
	9854:  0x6751,
	9855:  0x5B58,
	9856:  0x5BF8,
	9857:  0x78CB,
	9858:  0x64AE,
	9859:  0x6413,
	9860:  0x63AA,
	9861:  0x632B,
	9862:  0x9519,
	9863:  0x642D,
	9864:  0x8FBE,
	9865:  0x7B54,
	9866:  0x7629,
	9867:  0x6253,
	9868:  0x5927,
	9869:  0x5446,
	9870:  0x6B79,
	9871:  0x50A3,
	9872:  0x6234,
	9873:  0x5E26,
	9874:  0x6B86,
	9875:  0x4EE3,
	9876:  0x8D37,
	9877:  0x888B,
	9878:  0x5F85,
	9879:  0x902E,
	9880:  0x790D,
	9881:  0x790E,
	9882:  0x790F,
	9883:  0x7910,
	9884:  0x7911,
	9885:  0x7912,
	9886:  0x7914,
	9887:  0x7915,
	9888:  0x7916,
	9889:  0x7917,
	9890:  0x7918,
	9891:  0x7919,
	9892:  0x791A,
	9893:  0x791B,
	9894:  0x791C,
	9895:  0x791D,
	9896:  0x791F,
	9897:  0x7920,
	9898:  0x7921,
	9899:  0x7922,
	9900:  0x7923,
	9901:  0x7925,
	9902:  0x7926,
	9903:  0x7927,
	9904:  0x7928,
	9905:  0x7929,
	9906:  0x792A,
	9907:  0x792B,
	9908:  0x792C,
	9909:  0x792D,
	9910:  0x792E,
	9911:  0x792F,
	9912:  0x7930,
	9913:  0x7931,
	9914:  0x7932,
	9915:  0x7933,
	9916:  0x7935,
	9917:  0x7936,
	9918:  0x7937,
	9919:  0x7938,
	9920:  0x7939,
	9921:  0x793D,
	9922:  0x793F,
	9923:  0x7942,
	9924:  0x7943,
	9925:  0x7944,
	9926:  0x7945,
	9927:  0x7947,
	9928:  0x794A,
	9929:  0x794B,
	9930:  0x794C,
	9931:  0x794D,
	9932:  0x794E,
	9933:  0x794F,
	9934:  0x7950,
	9935:  0x7951,
	9936:  0x7952,
	9937:  0x7954,
	9938:  0x7955,
	9939:  0x7958,
	9940:  0x7959,
	9941:  0x7961,
	9942:  0x7963,
	9943:  0x7964,
	9944:  0x7966,
	9945:  0x7969,
	9946:  0x796A,
	9947:  0x796B,
	9948:  0x796C,
	9949:  0x796E,
	9950:  0x7970,
	9951:  0x7971,
	9952:  0x7972,
	9953:  0x7973,
	9954:  0x7974,
	9955:  0x7975,
	9956:  0x7976,
	9957:  0x7979,
	9958:  0x797B,
	9959:  0x797C,
	9960:  0x797D,
	9961:  0x797E,
	9962:  0x797F,
	9963:  0x7982,
	9964:  0x7983,
	9965:  0x7986,
	9966:  0x7987,
	9967:  0x7988,
	9968:  0x7989,
	9969:  0x798B,
	9970:  0x798C,
	9971:  0x798D,
	9972:  0x798E,
	9973:  0x7990,
	9974:  0x7991,
	9975:  0x7992,
	9976:  0x6020,
	9977:  0x803D,
	9978:  0x62C5,
	9979:  0x4E39,
	9980:  0x5355,
	9981:  0x90F8,
	9982:  0x63B8,
	9983:  0x80C6,
	9984:  0x65E6,
	9985:  0x6C2E,
	9986:  0x4F46,
	9987:  0x60EE,
	9988:  0x6DE1,
	9989:  0x8BDE,
	9990:  0x5F39,
	9991:  0x86CB,
	9992:  0x5F53,
	9993:  0x6321,
	9994:  0x515A,
	9995:  0x8361,
	9996:  0x6863,
	9997:  0x5200,
	9998:  0x6363,
	9999:  0x8E48,
	10000: 0x5012,
	10001: 0x5C9B,
	10002: 0x7977,
	10003: 0x5BFC,
	10004: 0x5230,
	10005: 0x7A3B,
	10006: 0x60BC,
	10007: 0x9053,
	10008: 0x76D7,
	10009: 0x5FB7,
	10010: 0x5F97,
	10011: 0x7684,
	10012: 0x8E6C,
	10013: 0x706F,
	10014: 0x767B,
	10015: 0x7B49,
	10016: 0x77AA,
	10017: 0x51F3,
	10018: 0x9093,
	10019: 0x5824,
	10020: 0x4F4E,
	10021: 0x6EF4,
	10022: 0x8FEA,
	10023: 0x654C,
	10024: 0x7B1B,
	10025: 0x72C4,
	10026: 0x6DA4,
	10027: 0x7FDF,
	10028: 0x5AE1,
	10029: 0x62B5,
	10030: 0x5E95,
	10031: 0x5730,
	10032: 0x8482,
	10033: 0x7B2C,
	10034: 0x5E1D,
	10035: 0x5F1F,
	10036: 0x9012,
	10037: 0x7F14,
	10038: 0x98A0,
	10039: 0x6382,
	10040: 0x6EC7,
	10041: 0x7898,
	10042: 0x70B9,
	10043: 0x5178,
	10044: 0x975B,
	10045: 0x57AB,
	10046: 0x7535,
	10047: 0x4F43,
	10048: 0x7538,
	10049: 0x5E97,
	10050: 0x60E6,
	10051: 0x5960,
	10052: 0x6DC0,
	10053: 0x6BBF,
	10054: 0x7889,
	10055: 0x53FC,
	10056: 0x96D5,
	10057: 0x51CB,
	10058: 0x5201,
	10059: 0x6389,
	10060: 0x540A,
	10061: 0x9493,
	10062: 0x8C03,
	10063: 0x8DCC,
	10064: 0x7239,
	10065: 0x789F,
	10066: 0x8776,
	10067: 0x8FED,
	10068: 0x8C0D,
	10069: 0x53E0,
	10070: 0x7993,
	10071: 0x7994,
	10072: 0x7995,
	10073: 0x7996,
	10074: 0x7997,
	10075: 0x7998,
	10076: 0x7999,
	10077: 0x799B,
	10078: 0x799C,
	10079: 0x799D,
	10080: 0x799E,
	10081: 0x799F,
	10082: 0x79A0,
	10083: 0x79A1,
	10084: 0x79A2,
	10085: 0x79A3,
	10086: 0x79A4,
	10087: 0x79A5,
	10088: 0x79A6,
	10089: 0x79A8,
	10090: 0x79A9,
	10091: 0x79AA,
	10092: 0x79AB,
	10093: 0x79AC,
	10094: 0x79AD,
	10095: 0x79AE,
	10096: 0x79AF,
	10097: 0x79B0,
	10098: 0x79B1,
	10099: 0x79B2,
	10100: 0x79B4,
	10101: 0x79B5,
	10102: 0x79B6,
	10103: 0x79B7,
	10104: 0x79B8,
	10105: 0x79BC,
	10106: 0x79BF,
	10107: 0x79C2,
	10108: 0x79C4,
	10109: 0x79C5,
	10110: 0x79C7,
	10111: 0x79C8,
	10112: 0x79CA,
	10113: 0x79CC,
	10114: 0x79CE,
	10115: 0x79CF,
	10116: 0x79D0,
	10117: 0x79D3,
	10118: 0x79D4,
	10119: 0x79D6,
	10120: 0x79D7,
	10121: 0x79D9,
	10122: 0x79DA,
	10123: 0x79DB,
	10124: 0x79DC,
	10125: 0x79DD,
	10126: 0x79DE,
	10127: 0x79E0,
	10128: 0x79E1,
	10129: 0x79E2,
	10130: 0x79E5,
	10131: 0x79E8,
	10132: 0x79EA,
	10133: 0x79EC,
	10134: 0x79EE,
	10135: 0x79F1,
	10136: 0x79F2,
	10137: 0x79F3,
	10138: 0x79F4,
	10139: 0x79F5,
	10140: 0x79F6,
	10141: 0x79F7,
	10142: 0x79F9,
	10143: 0x79FA,
	10144: 0x79FC,
	10145: 0x79FE,
	10146: 0x79FF,
	10147: 0x7A01,
	10148: 0x7A04,
	10149: 0x7A05,
	10150: 0x7A07,
	10151: 0x7A08,
	10152: 0x7A09,
	10153: 0x7A0A,
	10154: 0x7A0C,
	10155: 0x7A0F,
	10156: 0x7A10,
	10157: 0x7A11,
	10158: 0x7A12,
	10159: 0x7A13,
	10160: 0x7A15,
	10161: 0x7A16,
	10162: 0x7A18,
	10163: 0x7A19,
	10164: 0x7A1B,
	10165: 0x7A1C,
	10166: 0x4E01,
	10167: 0x76EF,
	10168: 0x53EE,
	10169: 0x9489,
	10170: 0x9876,
	10171: 0x9F0E,
	10172: 0x952D,
	10173: 0x5B9A,
	10174: 0x8BA2,
	10175: 0x4E22,
	10176: 0x4E1C,
	10177: 0x51AC,
	10178: 0x8463,
	10179: 0x61C2,
	10180: 0x52A8,
	10181: 0x680B,
	10182: 0x4F97,
	10183: 0x606B,
	10184: 0x51BB,
	10185: 0x6D1E,
	10186: 0x515C,
	10187: 0x6296,
	10188: 0x6597,
	10189: 0x9661,
	10190: 0x8C46,
	10191: 0x9017,
	10192: 0x75D8,
	10193: 0x90FD,
	10194: 0x7763,
	10195: 0x6BD2,
	10196: 0x728A,
	10197: 0x72EC,
	10198: 0x8BFB,
	10199: 0x5835,
	10200: 0x7779,
	10201: 0x8D4C,
	10202: 0x675C,
	10203: 0x9540,
	10204: 0x809A,
	10205: 0x5EA6,
	10206: 0x6E21,
	10207: 0x5992,
	10208: 0x7AEF,
	10209: 0x77ED,
	10210: 0x953B,
	10211: 0x6BB5,
	10212: 0x65AD,
	10213: 0x7F0E,
	10214: 0x5806,
	10215: 0x5151,
	10216: 0x961F,
	10217: 0x5BF9,
	10218: 0x58A9,
	10219: 0x5428,
	10220: 0x8E72,
	10221: 0x6566,
	10222: 0x987F,
	10223: 0x56E4,
	10224: 0x949D,
	10225: 0x76FE,
	10226: 0x9041,
	10227: 0x6387,
	10228: 0x54C6,
	10229: 0x591A,
	10230: 0x593A,
	10231: 0x579B,
	10232: 0x8EB2,
	10233: 0x6735,
	10234: 0x8DFA,
	10235: 0x8235,
	10236: 0x5241,
	10237: 0x60F0,
	10238: 0x5815,
	10239: 0x86FE,
	10240: 0x5CE8,
	10241: 0x9E45,
	10242: 0x4FC4,
	10243: 0x989D,
	10244: 0x8BB9,
	10245: 0x5A25,
	10246: 0x6076,
	10247: 0x5384,
	10248: 0x627C,
	10249: 0x904F,
	10250: 0x9102,
	10251: 0x997F,
	10252: 0x6069,
	10253: 0x800C,
	10254: 0x513F,
	10255: 0x8033,
	10256: 0x5C14,
	10257: 0x9975,
	10258: 0x6D31,
	10259: 0x4E8C,
	10260: 0x7A1D,
	10261: 0x7A1F,
	10262: 0x7A21,
	10263: 0x7A22,
	10264: 0x7A24,
	10265: 0x7A25,
	10266: 0x7A26,
	10267: 0x7A27,
	10268: 0x7A28,
	10269: 0x7A29,
	10270: 0x7A2A,
	10271: 0x7A2B,
	10272: 0x7A2C,
	10273: 0x7A2D,
	10274: 0x7A2E,
	10275: 0x7A2F,
	10276: 0x7A30,
	10277: 0x7A31,
	10278: 0x7A32,
	10279: 0x7A34,
	10280: 0x7A35,
	10281: 0x7A36,
	10282: 0x7A38,
	10283: 0x7A3A,
	10284: 0x7A3E,
	10285: 0x7A40,
	10286: 0x7A41,
	10287: 0x7A42,
	10288: 0x7A43,
	10289: 0x7A44,
	10290: 0x7A45,
	10291: 0x7A47,
	10292: 0x7A48,
	10293: 0x7A49,
	10294: 0x7A4A,
	10295: 0x7A4B,
	10296: 0x7A4C,
	10297: 0x7A4D,
	10298: 0x7A4E,
	10299: 0x7A4F,
	10300: 0x7A50,
	10301: 0x7A52,
	10302: 0x7A53,
	10303: 0x7A54,
	10304: 0x7A55,
	10305: 0x7A56,
	10306: 0x7A58,
	10307: 0x7A59,
	10308: 0x7A5A,
	10309: 0x7A5B,
	10310: 0x7A5C,
	10311: 0x7A5D,
	10312: 0x7A5E,
	10313: 0x7A5F,
	10314: 0x7A60,
	10315: 0x7A61,
	10316: 0x7A62,
	10317: 0x7A63,
	10318: 0x7A64,
	10319: 0x7A65,
	10320: 0x7A66,
	10321: 0x7A67,
	10322: 0x7A68,
	10323: 0x7A69,
	10324: 0x7A6A,
	10325: 0x7A6B,
	10326: 0x7A6C,
	10327: 0x7A6D,
	10328: 0x7A6E,
	10329: 0x7A6F,
	10330: 0x7A71,
	10331: 0x7A72,
	10332: 0x7A73,
	10333: 0x7A75,
	10334: 0x7A7B,
	10335: 0x7A7C,
	10336: 0x7A7D,
	10337: 0x7A7E,
	10338: 0x7A82,
	10339: 0x7A85,
	10340: 0x7A87,
	10341: 0x7A89,
	10342: 0x7A8A,
	10343: 0x7A8B,
	10344: 0x7A8C,
	10345: 0x7A8E,
	10346: 0x7A8F,
	10347: 0x7A90,
	10348: 0x7A93,
	10349: 0x7A94,
	10350: 0x7A99,
	10351: 0x7A9A,
	10352: 0x7A9B,
	10353: 0x7A9E,
	10354: 0x7AA1,
	10355: 0x7AA2,
	10356: 0x8D30,
	10357: 0x53D1,
	10358: 0x7F5A,
	10359: 0x7B4F,
	10360: 0x4F10,
	10361: 0x4E4F,
	10362: 0x9600,
	10363: 0x6CD5,
	10364: 0x73D0,
	10365: 0x85E9,
	10366: 0x5E06,
	10367: 0x756A,
	10368: 0x7FFB,
	10369: 0x6A0A,
	10370: 0x77FE,
	10371: 0x9492,
	10372: 0x7E41,
	10373: 0x51E1,
	10374: 0x70E6,
	10375: 0x53CD,
	10376: 0x8FD4,
	10377: 0x8303,
	10378: 0x8D29,
	10379: 0x72AF,
	10380: 0x996D,
	10381: 0x6CDB,
	10382: 0x574A,
	10383: 0x82B3,
	10384: 0x65B9,
	10385: 0x80AA,
	10386: 0x623F,
	10387: 0x9632,
	10388: 0x59A8,
	10389: 0x4EFF,
	10390: 0x8BBF,
	10391: 0x7EBA,
	10392: 0x653E,
	10393: 0x83F2,
	10394: 0x975E,
	10395: 0x5561,
	10396: 0x98DE,
	10397: 0x80A5,
	10398: 0x532A,
	10399: 0x8BFD,
	10400: 0x5420,
	10401: 0x80BA,
	10402: 0x5E9F,
	10403: 0x6CB8,
	10404: 0x8D39,
	10405: 0x82AC,
	10406: 0x915A,
	10407: 0x5429,
	10408: 0x6C1B,
	10409: 0x5206,
	10410: 0x7EB7,
	10411: 0x575F,
	10412: 0x711A,
	10413: 0x6C7E,
	10414: 0x7C89,
	10415: 0x594B,
	10416: 0x4EFD,
	10417: 0x5FFF,
	10418: 0x6124,
	10419: 0x7CAA,
	10420: 0x4E30,
	10421: 0x5C01,
	10422: 0x67AB,
	10423: 0x8702,
	10424: 0x5CF0,
	10425: 0x950B,
	10426: 0x98CE,
	10427: 0x75AF,
	10428: 0x70FD,
	10429: 0x9022,
	10430: 0x51AF,
	10431: 0x7F1D,
	10432: 0x8BBD,
	10433: 0x5949,
	10434: 0x51E4,
	10435: 0x4F5B,
	10436: 0x5426,
	10437: 0x592B,
	10438: 0x6577,
	10439: 0x80A4,
	10440: 0x5B75,
	10441: 0x6276,
	10442: 0x62C2,
	10443: 0x8F90,
	10444: 0x5E45,
	10445: 0x6C1F,
	10446: 0x7B26,
	10447: 0x4F0F,
	10448: 0x4FD8,
	10449: 0x670D,
	10450: 0x7AA3,
	10451: 0x7AA4,
	10452: 0x7AA7,
	10453: 0x7AA9,
	10454: 0x7AAA,
	10455: 0x7AAB,
	10456: 0x7AAE,
	10457: 0x7AAF,
	10458: 0x7AB0,
	10459: 0x7AB1,
	10460: 0x7AB2,
	10461: 0x7AB4,
	10462: 0x7AB5,
	10463: 0x7AB6,
	10464: 0x7AB7,
	10465: 0x7AB8,
	10466: 0x7AB9,
	10467: 0x7ABA,
	10468: 0x7ABB,
	10469: 0x7ABC,
	10470: 0x7ABD,
	10471: 0x7ABE,
	10472: 0x7AC0,
	10473: 0x7AC1,
	10474: 0x7AC2,
	10475: 0x7AC3,
	10476: 0x7AC4,
	10477: 0x7AC5,
	10478: 0x7AC6,
	10479: 0x7AC7,
	10480: 0x7AC8,
	10481: 0x7AC9,
	10482: 0x7ACA,
	10483: 0x7ACC,
	10484: 0x7ACD,
	10485: 0x7ACE,
	10486: 0x7ACF,
	10487: 0x7AD0,
	10488: 0x7AD1,
	10489: 0x7AD2,
	10490: 0x7AD3,
	10491: 0x7AD4,
	10492: 0x7AD5,
	10493: 0x7AD7,
	10494: 0x7AD8,
	10495: 0x7ADA,
	10496: 0x7ADB,
	10497: 0x7ADC,
	10498: 0x7ADD,
	10499: 0x7AE1,
	10500: 0x7AE2,
	10501: 0x7AE4,
	10502: 0x7AE7,
	10503: 0x7AE8,
	10504: 0x7AE9,
	10505: 0x7AEA,
	10506: 0x7AEB,
	10507: 0x7AEC,
	10508: 0x7AEE,
	10509: 0x7AF0,
	10510: 0x7AF1,
	10511: 0x7AF2,
	10512: 0x7AF3,
	10513: 0x7AF4,
	10514: 0x7AF5,
	10515: 0x7AF6,
	10516: 0x7AF7,
	10517: 0x7AF8,
	10518: 0x7AFB,
	10519: 0x7AFC,
	10520: 0x7AFE,
	10521: 0x7B00,
	10522: 0x7B01,
	10523: 0x7B02,
	10524: 0x7B05,
	10525: 0x7B07,
	10526: 0x7B09,
	10527: 0x7B0C,
	10528: 0x7B0D,
	10529: 0x7B0E,
	10530: 0x7B10,
	10531: 0x7B12,
	10532: 0x7B13,
	10533: 0x7B16,
	10534: 0x7B17,
	10535: 0x7B18,
	10536: 0x7B1A,
	10537: 0x7B1C,
	10538: 0x7B1D,
	10539: 0x7B1F,
	10540: 0x7B21,
	10541: 0x7B22,
	10542: 0x7B23,
	10543: 0x7B27,
	10544: 0x7B29,
	10545: 0x7B2D,
	10546: 0x6D6E,
	10547: 0x6DAA,
	10548: 0x798F,
	10549: 0x88B1,
	10550: 0x5F17,
	10551: 0x752B,
	10552: 0x629A,
	10553: 0x8F85,
	10554: 0x4FEF,
	10555: 0x91DC,
	10556: 0x65A7,
	10557: 0x812F,
	10558: 0x8151,
	10559: 0x5E9C,
	10560: 0x8150,
	10561: 0x8D74,
	10562: 0x526F,
	10563: 0x8986,
	10564: 0x8D4B,
	10565: 0x590D,
	10566: 0x5085,
	10567: 0x4ED8,
	10568: 0x961C,
	10569: 0x7236,
	10570: 0x8179,
	10571: 0x8D1F,
	10572: 0x5BCC,
	10573: 0x8BA3,
	10574: 0x9644,
	10575: 0x5987,
	10576: 0x7F1A,
	10577: 0x5490,
	10578: 0x5676,
	10579: 0x560E,
	10580: 0x8BE5,
	10581: 0x6539,
	10582: 0x6982,
	10583: 0x9499,
	10584: 0x76D6,
	10585: 0x6E89,
	10586: 0x5E72,
	10587: 0x7518,
	10588: 0x6746,
	10589: 0x67D1,
	10590: 0x7AFF,
	10591: 0x809D,
	10592: 0x8D76,
	10593: 0x611F,
	10594: 0x79C6,
	10595: 0x6562,
	10596: 0x8D63,
	10597: 0x5188,
	10598: 0x521A,
	10599: 0x94A2,
	10600: 0x7F38,
	10601: 0x809B,
	10602: 0x7EB2,
	10603: 0x5C97,
	10604: 0x6E2F,
	10605: 0x6760,
	10606: 0x7BD9,
	10607: 0x768B,
	10608: 0x9AD8,
	10609: 0x818F,
	10610: 0x7F94,
	10611: 0x7CD5,
	10612: 0x641E,
	10613: 0x9550,
	10614: 0x7A3F,
	10615: 0x544A,
	10616: 0x54E5,
	10617: 0x6B4C,
	10618: 0x6401,
	10619: 0x6208,
	10620: 0x9E3D,
	10621: 0x80F3,
	10622: 0x7599,
	10623: 0x5272,
	10624: 0x9769,
	10625: 0x845B,
	10626: 0x683C,
	10627: 0x86E4,
	10628: 0x9601,
	10629: 0x9694,
	10630: 0x94EC,
	10631: 0x4E2A,
	10632: 0x5404,
	10633: 0x7ED9,
	10634: 0x6839,
	10635: 0x8DDF,
	10636: 0x8015,
	10637: 0x66F4,
	10638: 0x5E9A,
	10639: 0x7FB9,
	10640: 0x7B2F,
	10641: 0x7B30,
	10642: 0x7B32,
	10643: 0x7B34,
	10644: 0x7B35,
	10645: 0x7B36,
	10646: 0x7B37,
	10647: 0x7B39,
	10648: 0x7B3B,
	10649: 0x7B3D,
	10650: 0x7B3F,
	10651: 0x7B40,
	10652: 0x7B41,
	10653: 0x7B42,
	10654: 0x7B43,
	10655: 0x7B44,
	10656: 0x7B46,
	10657: 0x7B48,
	10658: 0x7B4A,
	10659: 0x7B4D,
	10660: 0x7B4E,
	10661: 0x7B53,
	10662: 0x7B55,
	10663: 0x7B57,
	10664: 0x7B59,
	10665: 0x7B5C,
	10666: 0x7B5E,
	10667: 0x7B5F,
	10668: 0x7B61,
	10669: 0x7B63,
	10670: 0x7B64,
	10671: 0x7B65,
	10672: 0x7B66,
	10673: 0x7B67,
	10674: 0x7B68,
	10675: 0x7B69,
	10676: 0x7B6A,
	10677: 0x7B6B,
	10678: 0x7B6C,
	10679: 0x7B6D,
	10680: 0x7B6F,
	10681: 0x7B70,
	10682: 0x7B73,
	10683: 0x7B74,
	10684: 0x7B76,
	10685: 0x7B78,
	10686: 0x7B7A,
	10687: 0x7B7C,
	10688: 0x7B7D,
	10689: 0x7B7F,
	10690: 0x7B81,
	10691: 0x7B82,
	10692: 0x7B83,
	10693: 0x7B84,
	10694: 0x7B86,
	10695: 0x7B87,
	10696: 0x7B88,
	10697: 0x7B89,
	10698: 0x7B8A,
	10699: 0x7B8B,
	10700: 0x7B8C,
	10701: 0x7B8E,
	10702: 0x7B8F,
	10703: 0x7B91,
	10704: 0x7B92,
	10705: 0x7B93,
	10706: 0x7B96,
	10707: 0x7B98,
	10708: 0x7B99,
	10709: 0x7B9A,
	10710: 0x7B9B,
	10711: 0x7B9E,
	10712: 0x7B9F,
	10713: 0x7BA0,
	10714: 0x7BA3,
	10715: 0x7BA4,
	10716: 0x7BA5,
	10717: 0x7BAE,
	10718: 0x7BAF,
	10719: 0x7BB0,
	10720: 0x7BB2,
	10721: 0x7BB3,
	10722: 0x7BB5,
	10723: 0x7BB6,
	10724: 0x7BB7,
	10725: 0x7BB9,
	10726: 0x7BBA,
	10727: 0x7BBB,
	10728: 0x7BBC,
	10729: 0x7BBD,
	10730: 0x7BBE,
	10731: 0x7BBF,
	10732: 0x7BC0,
	10733: 0x7BC2,
	10734: 0x7BC3,
	10735: 0x7BC4,
	10736: 0x57C2,
	10737: 0x803F,
	10738: 0x6897,
	10739: 0x5DE5,
	10740: 0x653B,
	10741: 0x529F,
	10742: 0x606D,
	10743: 0x9F9A,
	10744: 0x4F9B,
	10745: 0x8EAC,
	10746: 0x516C,
	10747: 0x5BAB,
	10748: 0x5F13,
	10749: 0x5DE9,
	10750: 0x6C5E,
	10751: 0x62F1,
	10752: 0x8D21,
	10753: 0x5171,
	10754: 0x94A9,
	10755: 0x52FE,
	10756: 0x6C9F,
	10757: 0x82DF,
	10758: 0x72D7,
	10759: 0x57A2,
	10760: 0x6784,
	10761: 0x8D2D,
	10762: 0x591F,
	10763: 0x8F9C,
	10764: 0x83C7,
	10765: 0x5495,
	10766: 0x7B8D,
	10767: 0x4F30,
	10768: 0x6CBD,
	10769: 0x5B64,
	10770: 0x59D1,
	10771: 0x9F13,
	10772: 0x53E4,
	10773: 0x86CA,
	10774: 0x9AA8,
	10775: 0x8C37,
	10776: 0x80A1,
	10777: 0x6545,
	10778: 0x987E,
	10779: 0x56FA,
	10780: 0x96C7,
	10781: 0x522E,
	10782: 0x74DC,
	10783: 0x5250,
	10784: 0x5BE1,
	10785: 0x6302,
	10786: 0x8902,
	10787: 0x4E56,
	10788: 0x62D0,
	10789: 0x602A,
	10790: 0x68FA,
	10791: 0x5173,
	10792: 0x5B98,
	10793: 0x51A0,
	10794: 0x89C2,
	10795: 0x7BA1,
	10796: 0x9986,
	10797: 0x7F50,
	10798: 0x60EF,
	10799: 0x704C,
	10800: 0x8D2F,
	10801: 0x5149,
	10802: 0x5E7F,
	10803: 0x901B,
	10804: 0x7470,
	10805: 0x89C4,
	10806: 0x572D,
	10807: 0x7845,
	10808: 0x5F52,
	10809: 0x9F9F,
	10810: 0x95FA,
	10811: 0x8F68,
	10812: 0x9B3C,
	10813: 0x8BE1,
	10814: 0x7678,
	10815: 0x6842,
	10816: 0x67DC,
	10817: 0x8DEA,
	10818: 0x8D35,
	10819: 0x523D,
	10820: 0x8F8A,
	10821: 0x6EDA,
	10822: 0x68CD,
	10823: 0x9505,
	10824: 0x90ED,
	10825: 0x56FD,
	10826: 0x679C,
	10827: 0x88F9,
	10828: 0x8FC7,
	10829: 0x54C8,
	10830: 0x7BC5,
	10831: 0x7BC8,
	10832: 0x7BC9,
	10833: 0x7BCA,
	10834: 0x7BCB,
	10835: 0x7BCD,
	10836: 0x7BCE,
	10837: 0x7BCF,
	10838: 0x7BD0,
	10839: 0x7BD2,
	10840: 0x7BD4,
	10841: 0x7BD5,
	10842: 0x7BD6,
	10843: 0x7BD7,
	10844: 0x7BD8,
	10845: 0x7BDB,
	10846: 0x7BDC,
	10847: 0x7BDE,
	10848: 0x7BDF,
	10849: 0x7BE0,
	10850: 0x7BE2,
	10851: 0x7BE3,
	10852: 0x7BE4,
	10853: 0x7BE7,
	10854: 0x7BE8,
	10855: 0x7BE9,
	10856: 0x7BEB,
	10857: 0x7BEC,
	10858: 0x7BED,
	10859: 0x7BEF,
	10860: 0x7BF0,
	10861: 0x7BF2,
	10862: 0x7BF3,
	10863: 0x7BF4,
	10864: 0x7BF5,
	10865: 0x7BF6,
	10866: 0x7BF8,
	10867: 0x7BF9,
	10868: 0x7BFA,
	10869: 0x7BFB,
	10870: 0x7BFD,
	10871: 0x7BFF,
	10872: 0x7C00,
	10873: 0x7C01,
	10874: 0x7C02,
	10875: 0x7C03,
	10876: 0x7C04,
	10877: 0x7C05,
	10878: 0x7C06,
	10879: 0x7C08,
	10880: 0x7C09,
	10881: 0x7C0A,
	10882: 0x7C0D,
	10883: 0x7C0E,
	10884: 0x7C10,
	10885: 0x7C11,
	10886: 0x7C12,
	10887: 0x7C13,
	10888: 0x7C14,
	10889: 0x7C15,
	10890: 0x7C17,
	10891: 0x7C18,
	10892: 0x7C19,
	10893: 0x7C1A,
	10894: 0x7C1B,
	10895: 0x7C1C,
	10896: 0x7C1D,
	10897: 0x7C1E,
	10898: 0x7C20,
	10899: 0x7C21,
	10900: 0x7C22,
	10901: 0x7C23,
	10902: 0x7C24,
	10903: 0x7C25,
	10904: 0x7C28,
	10905: 0x7C29,
	10906: 0x7C2B,
	10907: 0x7C2C,
	10908: 0x7C2D,
	10909: 0x7C2E,
	10910: 0x7C2F,
	10911: 0x7C30,
	10912: 0x7C31,
	10913: 0x7C32,
	10914: 0x7C33,
	10915: 0x7C34,
	10916: 0x7C35,
	10917: 0x7C36,
	10918: 0x7C37,
	10919: 0x7C39,
	10920: 0x7C3A,
	10921: 0x7C3B,
	10922: 0x7C3C,
	10923: 0x7C3D,
	10924: 0x7C3E,
	10925: 0x7C42,
	10926: 0x9AB8,
	10927: 0x5B69,
	10928: 0x6D77,
	10929: 0x6C26,
	10930: 0x4EA5,
	10931: 0x5BB3,
	10932: 0x9A87,
	10933: 0x9163,
	10934: 0x61A8,
	10935: 0x90AF,
	10936: 0x97E9,
	10937: 0x542B,
	10938: 0x6DB5,
	10939: 0x5BD2,
	10940: 0x51FD,
	10941: 0x558A,
	10942: 0x7F55,
	10943: 0x7FF0,
	10944: 0x64BC,
	10945: 0x634D,
	10946: 0x65F1,
	10947: 0x61BE,
	10948: 0x608D,
	10949: 0x710A,
	10950: 0x6C57,
	10951: 0x6C49,
	10952: 0x592F,
	10953: 0x676D,
	10954: 0x822A,
	10955: 0x58D5,
	10956: 0x568E,
	10957: 0x8C6A,
	10958: 0x6BEB,
	10959: 0x90DD,
	10960: 0x597D,
	10961: 0x8017,
	10962: 0x53F7,
	10963: 0x6D69,
	10964: 0x5475,
	10965: 0x559D,
	10966: 0x8377,
	10967: 0x83CF,
	10968: 0x6838,
	10969: 0x79BE,
	10970: 0x548C,
	10971: 0x4F55,
	10972: 0x5408,
	10973: 0x76D2,
	10974: 0x8C89,
	10975: 0x9602,
	10976: 0x6CB3,
	10977: 0x6DB8,
	10978: 0x8D6B,
	10979: 0x8910,
	10980: 0x9E64,
	10981: 0x8D3A,
	10982: 0x563F,
	10983: 0x9ED1,
	10984: 0x75D5,
	10985: 0x5F88,
	10986: 0x72E0,
	10987: 0x6068,
	10988: 0x54FC,
	10989: 0x4EA8,
	10990: 0x6A2A,
	10991: 0x8861,
	10992: 0x6052,
	10993: 0x8F70,
	10994: 0x54C4,
	10995: 0x70D8,
	10996: 0x8679,
	10997: 0x9E3F,
	10998: 0x6D2A,
	10999: 0x5B8F,
	11000: 0x5F18,
	11001: 0x7EA2,
	11002: 0x5589,
	11003: 0x4FAF,
	11004: 0x7334,
	11005: 0x543C,
	11006: 0x539A,
	11007: 0x5019,
	11008: 0x540E,
	11009: 0x547C,
	11010: 0x4E4E,
	11011: 0x5FFD,
	11012: 0x745A,
	11013: 0x58F6,
	11014: 0x846B,
	11015: 0x80E1,
	11016: 0x8774,
	11017: 0x72D0,
	11018: 0x7CCA,
	11019: 0x6E56,
	11020: 0x7C43,
	11021: 0x7C44,
	11022: 0x7C45,
	11023: 0x7C46,
	11024: 0x7C47,
	11025: 0x7C48,
	11026: 0x7C49,
	11027: 0x7C4A,
	11028: 0x7C4B,
	11029: 0x7C4C,
	11030: 0x7C4E,
	11031: 0x7C4F,
	11032: 0x7C50,
	11033: 0x7C51,
	11034: 0x7C52,
	11035: 0x7C53,
	11036: 0x7C54,
	11037: 0x7C55,
	11038: 0x7C56,
	11039: 0x7C57,
	11040: 0x7C58,
	11041: 0x7C59,
	11042: 0x7C5A,
	11043: 0x7C5B,
	11044: 0x7C5C,
	11045: 0x7C5D,
	11046: 0x7C5E,
	11047: 0x7C5F,
	11048: 0x7C60,
	11049: 0x7C61,
	11050: 0x7C62,
	11051: 0x7C63,
	11052: 0x7C64,
	11053: 0x7C65,
	11054: 0x7C66,
	11055: 0x7C67,
	11056: 0x7C68,
	11057: 0x7C69,
	11058: 0x7C6A,
	11059: 0x7C6B,
	11060: 0x7C6C,
	11061: 0x7C6D,
	11062: 0x7C6E,
	11063: 0x7C6F,
	11064: 0x7C70,
	11065: 0x7C71,
	11066: 0x7C72,
	11067: 0x7C75,
	11068: 0x7C76,
	11069: 0x7C77,
	11070: 0x7C78,
	11071: 0x7C79,
	11072: 0x7C7A,
	11073: 0x7C7E,
	11074: 0x7C7F,
	11075: 0x7C80,
	11076: 0x7C81,
	11077: 0x7C82,
	11078: 0x7C83,
	11079: 0x7C84,
	11080: 0x7C85,
	11081: 0x7C86,
	11082: 0x7C87,
	11083: 0x7C88,
	11084: 0x7C8A,
	11085: 0x7C8B,
	11086: 0x7C8C,
	11087: 0x7C8D,
	11088: 0x7C8E,
	11089: 0x7C8F,
	11090: 0x7C90,
	11091: 0x7C93,
	11092: 0x7C94,
	11093: 0x7C96,
	11094: 0x7C99,
	11095: 0x7C9A,
	11096: 0x7C9B,
	11097: 0x7CA0,
	11098: 0x7CA1,
	11099: 0x7CA3,
	11100: 0x7CA6,
	11101: 0x7CA7,
	11102: 0x7CA8,
	11103: 0x7CA9,
	11104: 0x7CAB,
	11105: 0x7CAC,
	11106: 0x7CAD,
	11107: 0x7CAF,
	11108: 0x7CB0,
	11109: 0x7CB4,
	11110: 0x7CB5,
	11111: 0x7CB6,
	11112: 0x7CB7,
	11113: 0x7CB8,
	11114: 0x7CBA,
	11115: 0x7CBB,
	11116: 0x5F27,
	11117: 0x864E,
	11118: 0x552C,
	11119: 0x62A4,
	11120: 0x4E92,
	11121: 0x6CAA,
	11122: 0x6237,
	11123: 0x82B1,
	11124: 0x54D7,
	11125: 0x534E,
	11126: 0x733E,
	11127: 0x6ED1,
	11128: 0x753B,
	11129: 0x5212,
	11130: 0x5316,
	11131: 0x8BDD,
	11132: 0x69D0,
	11133: 0x5F8A,
	11134: 0x6000,
	11135: 0x6DEE,
	11136: 0x574F,
	11137: 0x6B22,
	11138: 0x73AF,
	11139: 0x6853,
	11140: 0x8FD8,
	11141: 0x7F13,
	11142: 0x6362,
	11143: 0x60A3,
	11144: 0x5524,
	11145: 0x75EA,
	11146: 0x8C62,
	11147: 0x7115,
	11148: 0x6DA3,
	11149: 0x5BA6,
	11150: 0x5E7B,
	11151: 0x8352,
	11152: 0x614C,
	11153: 0x9EC4,
	11154: 0x78FA,
	11155: 0x8757,
	11156: 0x7C27,
	11157: 0x7687,
	11158: 0x51F0,
	11159: 0x60F6,
	11160: 0x714C,
	11161: 0x6643,
	11162: 0x5E4C,
	11163: 0x604D,
	11164: 0x8C0E,
	11165: 0x7070,
	11166: 0x6325,
	11167: 0x8F89,
	11168: 0x5FBD,
	11169: 0x6062,
	11170: 0x86D4,
	11171: 0x56DE,
	11172: 0x6BC1,
	11173: 0x6094,
	11174: 0x6167,
	11175: 0x5349,
	11176: 0x60E0,
	11177: 0x6666,
	11178: 0x8D3F,
	11179: 0x79FD,
	11180: 0x4F1A,
	11181: 0x70E9,
	11182: 0x6C47,
	11183: 0x8BB3,
	11184: 0x8BF2,
	11185: 0x7ED8,
	11186: 0x8364,
	11187: 0x660F,
	11188: 0x5A5A,
	11189: 0x9B42,
	11190: 0x6D51,
	11191: 0x6DF7,
	11192: 0x8C41,
	11193: 0x6D3B,
	11194: 0x4F19,
	11195: 0x706B,
	11196: 0x83B7,
	11197: 0x6216,
	11198: 0x60D1,
	11199: 0x970D,
	11200: 0x8D27,
	11201: 0x7978,
	11202: 0x51FB,
	11203: 0x573E,
	11204: 0x57FA,
	11205: 0x673A,
	11206: 0x7578,
	11207: 0x7A3D,
	11208: 0x79EF,
	11209: 0x7B95,
	11210: 0x7CBF,
	11211: 0x7CC0,
	11212: 0x7CC2,
	11213: 0x7CC3,
	11214: 0x7CC4,
	11215: 0x7CC6,
	11216: 0x7CC9,
	11217: 0x7CCB,
	11218: 0x7CCE,
	11219: 0x7CCF,
	11220: 0x7CD0,
	11221: 0x7CD1,
	11222: 0x7CD2,
	11223: 0x7CD3,
	11224: 0x7CD4,
	11225: 0x7CD8,
	11226: 0x7CDA,
	11227: 0x7CDB,
	11228: 0x7CDD,
	11229: 0x7CDE,
	11230: 0x7CE1,
	11231: 0x7CE2,
	11232: 0x7CE3,
	11233: 0x7CE4,
	11234: 0x7CE5,
	11235: 0x7CE6,
	11236: 0x7CE7,
	11237: 0x7CE9,
	11238: 0x7CEA,
	11239: 0x7CEB,
	11240: 0x7CEC,
	11241: 0x7CED,
	11242: 0x7CEE,
	11243: 0x7CF0,
	11244: 0x7CF1,
	11245: 0x7CF2,
	11246: 0x7CF3,
	11247: 0x7CF4,
	11248: 0x7CF5,
	11249: 0x7CF6,
	11250: 0x7CF7,
	11251: 0x7CF9,
	11252: 0x7CFA,
	11253: 0x7CFC,
	11254: 0x7CFD,
	11255: 0x7CFE,
	11256: 0x7CFF,
	11257: 0x7D00,
	11258: 0x7D01,
	11259: 0x7D02,
	11260: 0x7D03,
	11261: 0x7D04,
	11262: 0x7D05,
	11263: 0x7D06,
	11264: 0x7D07,
	11265: 0x7D08,
	11266: 0x7D09,
	11267: 0x7D0B,
	11268: 0x7D0C,
	11269: 0x7D0D,
	11270: 0x7D0E,
	11271: 0x7D0F,
	11272: 0x7D10,
	11273: 0x7D11,
	11274: 0x7D12,
	11275: 0x7D13,
	11276: 0x7D14,
	11277: 0x7D15,
	11278: 0x7D16,
	11279: 0x7D17,
	11280: 0x7D18,
	11281: 0x7D19,
	11282: 0x7D1A,
	11283: 0x7D1B,
	11284: 0x7D1C,
	11285: 0x7D1D,
	11286: 0x7D1E,
	11287: 0x7D1F,
	11288: 0x7D21,
	11289: 0x7D23,
	11290: 0x7D24,
	11291: 0x7D25,
	11292: 0x7D26,
	11293: 0x7D28,
	11294: 0x7D29,
	11295: 0x7D2A,
	11296: 0x7D2C,
	11297: 0x7D2D,
	11298: 0x7D2E,
	11299: 0x7D30,
	11300: 0x7D31,
	11301: 0x7D32,
	11302: 0x7D33,
	11303: 0x7D34,
	11304: 0x7D35,
	11305: 0x7D36,
	11306: 0x808C,
	11307: 0x9965,
	11308: 0x8FF9,
	11309: 0x6FC0,
	11310: 0x8BA5,
	11311: 0x9E21,
	11312: 0x59EC,
	11313: 0x7EE9,
	11314: 0x7F09,
	11315: 0x5409,
	11316: 0x6781,
	11317: 0x68D8,
	11318: 0x8F91,
	11319: 0x7C4D,
	11320: 0x96C6,
	11321: 0x53CA,
	11322: 0x6025,
	11323: 0x75BE,
	11324: 0x6C72,
	11325: 0x5373,
	11326: 0x5AC9,
	11327: 0x7EA7,
	11328: 0x6324,
	11329: 0x51E0,
	11330: 0x810A,
	11331: 0x5DF1,
	11332: 0x84DF,
	11333: 0x6280,
	11334: 0x5180,
	11335: 0x5B63,
	11336: 0x4F0E,
	11337: 0x796D,
	11338: 0x5242,
	11339: 0x60B8,
	11340: 0x6D4E,
	11341: 0x5BC4,
	11342: 0x5BC2,
	11343: 0x8BA1,
	11344: 0x8BB0,
	11345: 0x65E2,
	11346: 0x5FCC,
	11347: 0x9645,
	11348: 0x5993,
	11349: 0x7EE7,
	11350: 0x7EAA,
	11351: 0x5609,
	11352: 0x67B7,
	11353: 0x5939,
	11354: 0x4F73,
	11355: 0x5BB6,
	11356: 0x52A0,
	11357: 0x835A,
	11358: 0x988A,
	11359: 0x8D3E,
	11360: 0x7532,
	11361: 0x94BE,
	11362: 0x5047,
	11363: 0x7A3C,
	11364: 0x4EF7,
	11365: 0x67B6,
	11366: 0x9A7E,
	11367: 0x5AC1,
	11368: 0x6B7C,
	11369: 0x76D1,
	11370: 0x575A,
	11371: 0x5C16,
	11372: 0x7B3A,
	11373: 0x95F4,
	11374: 0x714E,
	11375: 0x517C,
	11376: 0x80A9,
	11377: 0x8270,
	11378: 0x5978,
	11379: 0x7F04,
	11380: 0x8327,
	11381: 0x68C0,
	11382: 0x67EC,
	11383: 0x78B1,
	11384: 0x7877,
	11385: 0x62E3,
	11386: 0x6361,
	11387: 0x7B80,
	11388: 0x4FED,
	11389: 0x526A,
	11390: 0x51CF,
	11391: 0x8350,
	11392: 0x69DB,
	11393: 0x9274,
	11394: 0x8DF5,
	11395: 0x8D31,
	11396: 0x89C1,
	11397: 0x952E,
	11398: 0x7BAD,
	11399: 0x4EF6,
	11400: 0x7D37,
	11401: 0x7D38,
	11402: 0x7D39,
	11403: 0x7D3A,
	11404: 0x7D3B,
	11405: 0x7D3C,
	11406: 0x7D3D,
	11407: 0x7D3E,
	11408: 0x7D3F,
	11409: 0x7D40,
	11410: 0x7D41,
	11411: 0x7D42,
	11412: 0x7D43,
	11413: 0x7D44,
	11414: 0x7D45,
	11415: 0x7D46,
	11416: 0x7D47,
	11417: 0x7D48,
	11418: 0x7D49,
	11419: 0x7D4A,
	11420: 0x7D4B,
	11421: 0x7D4C,
	11422: 0x7D4D,
	11423: 0x7D4E,
	11424: 0x7D4F,
	11425: 0x7D50,
	11426: 0x7D51,
	11427: 0x7D52,
	11428: 0x7D53,
	11429: 0x7D54,
	11430: 0x7D55,
	11431: 0x7D56,
	11432: 0x7D57,
	11433: 0x7D58,
	11434: 0x7D59,
	11435: 0x7D5A,
	11436: 0x7D5B,
	11437: 0x7D5C,
	11438: 0x7D5D,
	11439: 0x7D5E,
	11440: 0x7D5F,
	11441: 0x7D60,
	11442: 0x7D61,
	11443: 0x7D62,
	11444: 0x7D63,
	11445: 0x7D64,
	11446: 0x7D65,
	11447: 0x7D66,
	11448: 0x7D67,
	11449: 0x7D68,
	11450: 0x7D69,
	11451: 0x7D6A,
	11452: 0x7D6B,
	11453: 0x7D6C,
	11454: 0x7D6D,
	11455: 0x7D6F,
	11456: 0x7D70,
	11457: 0x7D71,
	11458: 0x7D72,
	11459: 0x7D73,
	11460: 0x7D74,
	11461: 0x7D75,
	11462: 0x7D76,
	11463: 0x7D78,
	11464: 0x7D79,
	11465: 0x7D7A,
	11466: 0x7D7B,
	11467: 0x7D7C,
	11468: 0x7D7D,
	11469: 0x7D7E,
	11470: 0x7D7F,
	11471: 0x7D80,
	11472: 0x7D81,
	11473: 0x7D82,
	11474: 0x7D83,
	11475: 0x7D84,
	11476: 0x7D85,
	11477: 0x7D86,
	11478: 0x7D87,
	11479: 0x7D88,
	11480: 0x7D89,
	11481: 0x7D8A,
	11482: 0x7D8B,
	11483: 0x7D8C,
	11484: 0x7D8D,
	11485: 0x7D8E,
	11486: 0x7D8F,
	11487: 0x7D90,
	11488: 0x7D91,
	11489: 0x7D92,
	11490: 0x7D93,
	11491: 0x7D94,
	11492: 0x7D95,
	11493: 0x7D96,
	11494: 0x7D97,
	11495: 0x7D98,
	11496: 0x5065,
	11497: 0x8230,
	11498: 0x5251,
	11499: 0x996F,
	11500: 0x6E10,
	11501: 0x6E85,
	11502: 0x6DA7,
	11503: 0x5EFA,
	11504: 0x50F5,
	11505: 0x59DC,
	11506: 0x5C06,
	11507: 0x6D46,
	11508: 0x6C5F,
	11509: 0x7586,
	11510: 0x848B,
	11511: 0x6868,
	11512: 0x5956,
	11513: 0x8BB2,
	11514: 0x5320,
	11515: 0x9171,
	11516: 0x964D,
	11517: 0x8549,
	11518: 0x6912,
	11519: 0x7901,
	11520: 0x7126,
	11521: 0x80F6,
	11522: 0x4EA4,
	11523: 0x90CA,
	11524: 0x6D47,
	11525: 0x9A84,
	11526: 0x5A07,
	11527: 0x56BC,
	11528: 0x6405,
	11529: 0x94F0,
	11530: 0x77EB,
	11531: 0x4FA5,
	11532: 0x811A,
	11533: 0x72E1,
	11534: 0x89D2,
	11535: 0x997A,
	11536: 0x7F34,
	11537: 0x7EDE,
	11538: 0x527F,
	11539: 0x6559,
	11540: 0x9175,
	11541: 0x8F7F,
	11542: 0x8F83,
	11543: 0x53EB,
	11544: 0x7A96,
	11545: 0x63ED,
	11546: 0x63A5,
	11547: 0x7686,
	11548: 0x79F8,
	11549: 0x8857,
	11550: 0x9636,
	11551: 0x622A,
	11552: 0x52AB,
	11553: 0x8282,
	11554: 0x6854,
	11555: 0x6770,
	11556: 0x6377,
	11557: 0x776B,
	11558: 0x7AED,
	11559: 0x6D01,
	11560: 0x7ED3,
	11561: 0x89E3,
	11562: 0x59D0,
	11563: 0x6212,
	11564: 0x85C9,
	11565: 0x82A5,
	11566: 0x754C,
	11567: 0x501F,
	11568: 0x4ECB,
	11569: 0x75A5,
	11570: 0x8BEB,
	11571: 0x5C4A,
	11572: 0x5DFE,
	11573: 0x7B4B,
	11574: 0x65A4,
	11575: 0x91D1,
	11576: 0x4ECA,
	11577: 0x6D25,
	11578: 0x895F,
	11579: 0x7D27,
	11580: 0x9526,
	11581: 0x4EC5,
	11582: 0x8C28,
	11583: 0x8FDB,
	11584: 0x9773,
	11585: 0x664B,
	11586: 0x7981,
	11587: 0x8FD1,
	11588: 0x70EC,
	11589: 0x6D78,
	11590: 0x7D99,
	11591: 0x7D9A,
	11592: 0x7D9B,
	11593: 0x7D9C,
	11594: 0x7D9D,
	11595: 0x7D9E,
	11596: 0x7D9F,
	11597: 0x7DA0,
	11598: 0x7DA1,
	11599: 0x7DA2,
	11600: 0x7DA3,
	11601: 0x7DA4,
	11602: 0x7DA5,
	11603: 0x7DA7,
	11604: 0x7DA8,
	11605: 0x7DA9,
	11606: 0x7DAA,
	11607: 0x7DAB,
	11608: 0x7DAC,
	11609: 0x7DAD,
	11610: 0x7DAF,
	11611: 0x7DB0,
	11612: 0x7DB1,
	11613: 0x7DB2,
	11614: 0x7DB3,
	11615: 0x7DB4,
	11616: 0x7DB5,
	11617: 0x7DB6,
	11618: 0x7DB7,
	11619: 0x7DB8,
	11620: 0x7DB9,
	11621: 0x7DBA,
	11622: 0x7DBB,
	11623: 0x7DBC,
	11624: 0x7DBD,
	11625: 0x7DBE,
	11626: 0x7DBF,
	11627: 0x7DC0,
	11628: 0x7DC1,
	11629: 0x7DC2,
	11630: 0x7DC3,
	11631: 0x7DC4,
	11632: 0x7DC5,
	11633: 0x7DC6,
	11634: 0x7DC7,
	11635: 0x7DC8,
	11636: 0x7DC9,
	11637: 0x7DCA,
	11638: 0x7DCB,
	11639: 0x7DCC,
	11640: 0x7DCD,
	11641: 0x7DCE,
	11642: 0x7DCF,
	11643: 0x7DD0,
	11644: 0x7DD1,
	11645: 0x7DD2,
	11646: 0x7DD3,
	11647: 0x7DD4,
	11648: 0x7DD5,
	11649: 0x7DD6,
	11650: 0x7DD7,
	11651: 0x7DD8,
	11652: 0x7DD9,
	11653: 0x7DDA,
	11654: 0x7DDB,
	11655: 0x7DDC,
	11656: 0x7DDD,
	11657: 0x7DDE,
	11658: 0x7DDF,
	11659: 0x7DE0,
	11660: 0x7DE1,
	11661: 0x7DE2,
	11662: 0x7DE3,
	11663: 0x7DE4,
	11664: 0x7DE5,
	11665: 0x7DE6,
	11666: 0x7DE7,
	11667: 0x7DE8,
	11668: 0x7DE9,
	11669: 0x7DEA,
	11670: 0x7DEB,
	11671: 0x7DEC,
	11672: 0x7DED,
	11673: 0x7DEE,
	11674: 0x7DEF,
	11675: 0x7DF0,
	11676: 0x7DF1,
	11677: 0x7DF2,
	11678: 0x7DF3,
	11679: 0x7DF4,
	11680: 0x7DF5,
	11681: 0x7DF6,
	11682: 0x7DF7,
	11683: 0x7DF8,
	11684: 0x7DF9,
	11685: 0x7DFA,
	11686: 0x5C3D,
	11687: 0x52B2,
	11688: 0x8346,
	11689: 0x5162,
	11690: 0x830E,
	11691: 0x775B,
	11692: 0x6676,
	11693: 0x9CB8,
	11694: 0x4EAC,
	11695: 0x60CA,
	11696: 0x7CBE,
	11697: 0x7CB3,
	11698: 0x7ECF,
	11699: 0x4E95,
	11700: 0x8B66,
	11701: 0x666F,
	11702: 0x9888,
	11703: 0x9759,
	11704: 0x5883,
	11705: 0x656C,
	11706: 0x955C,
	11707: 0x5F84,
	11708: 0x75C9,
	11709: 0x9756,
	11710: 0x7ADF,
	11711: 0x7ADE,
	11712: 0x51C0,
	11713: 0x70AF,
	11714: 0x7A98,
	11715: 0x63EA,
	11716: 0x7A76,
	11717: 0x7EA0,
	11718: 0x7396,
	11719: 0x97ED,
	11720: 0x4E45,
	11721: 0x7078,
	11722: 0x4E5D,
	11723: 0x9152,
	11724: 0x53A9,
	11725: 0x6551,
	11726: 0x65E7,
	11727: 0x81FC,
	11728: 0x8205,
	11729: 0x548E,
	11730: 0x5C31,
	11731: 0x759A,
	11732: 0x97A0,
	11733: 0x62D8,
	11734: 0x72D9,
	11735: 0x75BD,
	11736: 0x5C45,
	11737: 0x9A79,
	11738: 0x83CA,
	11739: 0x5C40,
	11740: 0x5480,
	11741: 0x77E9,
	11742: 0x4E3E,
	11743: 0x6CAE,
	11744: 0x805A,
	11745: 0x62D2,
	11746: 0x636E,
	11747: 0x5DE8,
	11748: 0x5177,
	11749: 0x8DDD,
	11750: 0x8E1E,
	11751: 0x952F,
	11752: 0x4FF1,
	11753: 0x53E5,
	11754: 0x60E7,
	11755: 0x70AC,
	11756: 0x5267,
	11757: 0x6350,
	11758: 0x9E43,
	11759: 0x5A1F,
	11760: 0x5026,
	11761: 0x7737,
	11762: 0x5377,
	11763: 0x7EE2,
	11764: 0x6485,
	11765: 0x652B,
	11766: 0x6289,
	11767: 0x6398,
	11768: 0x5014,
	11769: 0x7235,
	11770: 0x89C9,
	11771: 0x51B3,
	11772: 0x8BC0,
	11773: 0x7EDD,
	11774: 0x5747,
	11775: 0x83CC,
	11776: 0x94A7,
	11777: 0x519B,
	11778: 0x541B,
	11779: 0x5CFB,
	11780: 0x7DFB,
	11781: 0x7DFC,
	11782: 0x7DFD,
	11783: 0x7DFE,
	11784: 0x7DFF,
	11785: 0x7E00,
	11786: 0x7E01,
	11787: 0x7E02,
	11788: 0x7E03,
	11789: 0x7E04,
	11790: 0x7E05,
	11791: 0x7E06,
	11792: 0x7E07,
	11793: 0x7E08,
	11794: 0x7E09,
	11795: 0x7E0A,
	11796: 0x7E0B,
	11797: 0x7E0C,
	11798: 0x7E0D,
	11799: 0x7E0E,
	11800: 0x7E0F,
	11801: 0x7E10,
	11802: 0x7E11,
	11803: 0x7E12,
	11804: 0x7E13,
	11805: 0x7E14,
	11806: 0x7E15,
	11807: 0x7E16,
	11808: 0x7E17,
	11809: 0x7E18,
	11810: 0x7E19,
	11811: 0x7E1A,
	11812: 0x7E1B,
	11813: 0x7E1C,
	11814: 0x7E1D,
	11815: 0x7E1E,
	11816: 0x7E1F,
	11817: 0x7E20,
	11818: 0x7E21,
	11819: 0x7E22,
	11820: 0x7E23,
	11821: 0x7E24,
	11822: 0x7E25,
	11823: 0x7E26,
	11824: 0x7E27,
	11825: 0x7E28,
	11826: 0x7E29,
	11827: 0x7E2A,
	11828: 0x7E2B,
	11829: 0x7E2C,
	11830: 0x7E2D,
	11831: 0x7E2E,
	11832: 0x7E2F,
	11833: 0x7E30,
	11834: 0x7E31,
	11835: 0x7E32,
	11836: 0x7E33,
	11837: 0x7E34,
	11838: 0x7E35,
	11839: 0x7E36,
	11840: 0x7E37,
	11841: 0x7E38,
	11842: 0x7E39,
	11843: 0x7E3A,
	11844: 0x7E3C,
	11845: 0x7E3D,
	11846: 0x7E3E,
	11847: 0x7E3F,
	11848: 0x7E40,
	11849: 0x7E42,
	11850: 0x7E43,
	11851: 0x7E44,
	11852: 0x7E45,
	11853: 0x7E46,
	11854: 0x7E48,
	11855: 0x7E49,
	11856: 0x7E4A,
	11857: 0x7E4B,
	11858: 0x7E4C,
	11859: 0x7E4D,
	11860: 0x7E4E,
	11861: 0x7E4F,
	11862: 0x7E50,
	11863: 0x7E51,
	11864: 0x7E52,
	11865: 0x7E53,
	11866: 0x7E54,
	11867: 0x7E55,
	11868: 0x7E56,
	11869: 0x7E57,
	11870: 0x7E58,
	11871: 0x7E59,
	11872: 0x7E5A,
	11873: 0x7E5B,
	11874: 0x7E5C,
	11875: 0x7E5D,
	11876: 0x4FCA,
	11877: 0x7AE3,
	11878: 0x6D5A,
	11879: 0x90E1,
	11880: 0x9A8F,
	11881: 0x5580,
	11882: 0x5496,
	11883: 0x5361,
	11884: 0x54AF,
	11885: 0x5F00,
	11886: 0x63E9,
	11887: 0x6977,
	11888: 0x51EF,
	11889: 0x6168,
	11890: 0x520A,
	11891: 0x582A,
	11892: 0x52D8,
	11893: 0x574E,
	11894: 0x780D,
	11895: 0x770B,
	11896: 0x5EB7,
	11897: 0x6177,
	11898: 0x7CE0,
	11899: 0x625B,
	11900: 0x6297,
	11901: 0x4EA2,
	11902: 0x7095,
	11903: 0x8003,
	11904: 0x62F7,
	11905: 0x70E4,
	11906: 0x9760,
	11907: 0x5777,
	11908: 0x82DB,
	11909: 0x67EF,
	11910: 0x68F5,
	11911: 0x78D5,
	11912: 0x9897,
	11913: 0x79D1,
	11914: 0x58F3,
	11915: 0x54B3,
	11916: 0x53EF,
	11917: 0x6E34,
	11918: 0x514B,
	11919: 0x523B,
	11920: 0x5BA2,
	11921: 0x8BFE,
	11922: 0x80AF,
	11923: 0x5543,
	11924: 0x57A6,
	11925: 0x6073,
	11926: 0x5751,
	11927: 0x542D,
	11928: 0x7A7A,
	11929: 0x6050,
	11930: 0x5B54,
	11931: 0x63A7,
	11932: 0x62A0,
	11933: 0x53E3,
	11934: 0x6263,
	11935: 0x5BC7,
	11936: 0x67AF,
	11937: 0x54ED,
	11938: 0x7A9F,
	11939: 0x82E6,
	11940: 0x9177,
	11941: 0x5E93,
	11942: 0x88E4,
	11943: 0x5938,
	11944: 0x57AE,
	11945: 0x630E,
	11946: 0x8DE8,
	11947: 0x80EF,
	11948: 0x5757,
	11949: 0x7B77,
	11950: 0x4FA9,
	11951: 0x5FEB,
	11952: 0x5BBD,
	11953: 0x6B3E,
	11954: 0x5321,
	11955: 0x7B50,
	11956: 0x72C2,
	11957: 0x6846,
	11958: 0x77FF,
	11959: 0x7736,
	11960: 0x65F7,
	11961: 0x51B5,
	11962: 0x4E8F,
	11963: 0x76D4,
	11964: 0x5CBF,
	11965: 0x7AA5,
	11966: 0x8475,
	11967: 0x594E,
	11968: 0x9B41,
	11969: 0x5080,
	11970: 0x7E5E,
	11971: 0x7E5F,
	11972: 0x7E60,
	11973: 0x7E61,
	11974: 0x7E62,
	11975: 0x7E63,
	11976: 0x7E64,
	11977: 0x7E65,
	11978: 0x7E66,
	11979: 0x7E67,
	11980: 0x7E68,
	11981: 0x7E69,
	11982: 0x7E6A,
	11983: 0x7E6B,
	11984: 0x7E6C,
	11985: 0x7E6D,
	11986: 0x7E6E,
	11987: 0x7E6F,
	11988: 0x7E70,
	11989: 0x7E71,
	11990: 0x7E72,
	11991: 0x7E73,
	11992: 0x7E74,
	11993: 0x7E75,
	11994: 0x7E76,
	11995: 0x7E77,
	11996: 0x7E78,
	11997: 0x7E79,
	11998: 0x7E7A,
	11999: 0x7E7B,
	12000: 0x7E7C,
	12001: 0x7E7D,
	12002: 0x7E7E,
	12003: 0x7E7F,
	12004: 0x7E80,
	12005: 0x7E81,
	12006: 0x7E83,
	12007: 0x7E84,
	12008: 0x7E85,
	12009: 0x7E86,
	12010: 0x7E87,
	12011: 0x7E88,
	12012: 0x7E89,
	12013: 0x7E8A,
	12014: 0x7E8B,
	12015: 0x7E8C,
	12016: 0x7E8D,
	12017: 0x7E8E,
	12018: 0x7E8F,
	12019: 0x7E90,
	12020: 0x7E91,
	12021: 0x7E92,
	12022: 0x7E93,
	12023: 0x7E94,
	12024: 0x7E95,
	12025: 0x7E96,
	12026: 0x7E97,
	12027: 0x7E98,
	12028: 0x7E99,
	12029: 0x7E9A,
	12030: 0x7E9C,
	12031: 0x7E9D,
	12032: 0x7E9E,
	12033: 0x7EAE,
	12034: 0x7EB4,
	12035: 0x7EBB,
	12036: 0x7EBC,
	12037: 0x7ED6,
	12038: 0x7EE4,
	12039: 0x7EEC,
	12040: 0x7EF9,
	12041: 0x7F0A,
	12042: 0x7F10,
	12043: 0x7F1E,
	12044: 0x7F37,
	12045: 0x7F39,
	12046: 0x7F3B,
	12047: 0x7F3C,
	12048: 0x7F3D,
	12049: 0x7F3E,
	12050: 0x7F3F,
	12051: 0x7F40,
	12052: 0x7F41,
	12053: 0x7F43,
	12054: 0x7F46,
	12055: 0x7F47,
	12056: 0x7F48,
	12057: 0x7F49,
	12058: 0x7F4A,
	12059: 0x7F4B,
	12060: 0x7F4C,
	12061: 0x7F4D,
	12062: 0x7F4E,
	12063: 0x7F4F,
	12064: 0x7F52,
	12065: 0x7F53,
	12066: 0x9988,
	12067: 0x6127,
	12068: 0x6E83,
	12069: 0x5764,
	12070: 0x6606,
	12071: 0x6346,
	12072: 0x56F0,
	12073: 0x62EC,
	12074: 0x6269,
	12075: 0x5ED3,
	12076: 0x9614,
	12077: 0x5783,
	12078: 0x62C9,
	12079: 0x5587,
	12080: 0x8721,
	12081: 0x814A,
	12082: 0x8FA3,
	12083: 0x5566,
	12084: 0x83B1,
	12085: 0x6765,
	12086: 0x8D56,
	12087: 0x84DD,
	12088: 0x5A6A,
	12089: 0x680F,
	12090: 0x62E6,
	12091: 0x7BEE,
	12092: 0x9611,
	12093: 0x5170,
	12094: 0x6F9C,
	12095: 0x8C30,
	12096: 0x63FD,
	12097: 0x89C8,
	12098: 0x61D2,
	12099: 0x7F06,
	12100: 0x70C2,
	12101: 0x6EE5,
	12102: 0x7405,
	12103: 0x6994,
	12104: 0x72FC,
	12105: 0x5ECA,
	12106: 0x90CE,
	12107: 0x6717,
	12108: 0x6D6A,
	12109: 0x635E,
	12110: 0x52B3,
	12111: 0x7262,
	12112: 0x8001,
	12113: 0x4F6C,
	12114: 0x59E5,
	12115: 0x916A,
	12116: 0x70D9,
	12117: 0x6D9D,
	12118: 0x52D2,
	12119: 0x4E50,
	12120: 0x96F7,
	12121: 0x956D,
	12122: 0x857E,
	12123: 0x78CA,
	12124: 0x7D2F,
	12125: 0x5121,
	12126: 0x5792,
	12127: 0x64C2,
	12128: 0x808B,
	12129: 0x7C7B,
	12130: 0x6CEA,
	12131: 0x68F1,
	12132: 0x695E,
	12133: 0x51B7,
	12134: 0x5398,
	12135: 0x68A8,
	12136: 0x7281,
	12137: 0x9ECE,
	12138: 0x7BF1,
	12139: 0x72F8,
	12140: 0x79BB,
	12141: 0x6F13,
	12142: 0x7406,
	12143: 0x674E,
	12144: 0x91CC,
	12145: 0x9CA4,
	12146: 0x793C,
	12147: 0x8389,
	12148: 0x8354,
	12149: 0x540F,
	12150: 0x6817,
	12151: 0x4E3D,
	12152: 0x5389,
	12153: 0x52B1,
	12154: 0x783E,
	12155: 0x5386,
	12156: 0x5229,
	12157: 0x5088,
	12158: 0x4F8B,
	12159: 0x4FD0,
	12160: 0x7F56,
	12161: 0x7F59,
	12162: 0x7F5B,
	12163: 0x7F5C,
	12164: 0x7F5D,
	12165: 0x7F5E,
	12166: 0x7F60,
	12167: 0x7F63,
	12168: 0x7F64,
	12169: 0x7F65,
	12170: 0x7F66,
	12171: 0x7F67,
	12172: 0x7F6B,
	12173: 0x7F6C,
	12174: 0x7F6D,
	12175: 0x7F6F,
	12176: 0x7F70,
	12177: 0x7F73,
	12178: 0x7F75,
	12179: 0x7F76,
	12180: 0x7F77,
	12181: 0x7F78,
	12182: 0x7F7A,
	12183: 0x7F7B,
	12184: 0x7F7C,
	12185: 0x7F7D,
	12186: 0x7F7F,
	12187: 0x7F80,
	12188: 0x7F82,
	12189: 0x7F83,
	12190: 0x7F84,
	12191: 0x7F85,
	12192: 0x7F86,
	12193: 0x7F87,
	12194: 0x7F88,
	12195: 0x7F89,
	12196: 0x7F8B,
	12197: 0x7F8D,
	12198: 0x7F8F,
	12199: 0x7F90,
	12200: 0x7F91,
	12201: 0x7F92,
	12202: 0x7F93,
	12203: 0x7F95,
	12204: 0x7F96,
	12205: 0x7F97,
	12206: 0x7F98,
	12207: 0x7F99,
	12208: 0x7F9B,
	12209: 0x7F9C,
	12210: 0x7FA0,
	12211: 0x7FA2,
	12212: 0x7FA3,
	12213: 0x7FA5,
	12214: 0x7FA6,
	12215: 0x7FA8,
	12216: 0x7FA9,
	12217: 0x7FAA,
	12218: 0x7FAB,
	12219: 0x7FAC,
	12220: 0x7FAD,
	12221: 0x7FAE,
	12222: 0x7FB1,
	12223: 0x7FB3,
	12224: 0x7FB4,
	12225: 0x7FB5,
	12226: 0x7FB6,
	12227: 0x7FB7,
	12228: 0x7FBA,
	12229: 0x7FBB,
	12230: 0x7FBE,
	12231: 0x7FC0,
	12232: 0x7FC2,
	12233: 0x7FC3,
	12234: 0x7FC4,
	12235: 0x7FC6,
	12236: 0x7FC7,
	12237: 0x7FC8,
	12238: 0x7FC9,
	12239: 0x7FCB,
	12240: 0x7FCD,
	12241: 0x7FCF,
	12242: 0x7FD0,
	12243: 0x7FD1,
	12244: 0x7FD2,
	12245: 0x7FD3,
	12246: 0x7FD6,
	12247: 0x7FD7,
	12248: 0x7FD9,
	12249: 0x7FDA,
	12250: 0x7FDB,
	12251: 0x7FDC,
	12252: 0x7FDD,
	12253: 0x7FDE,
	12254: 0x7FE2,
	12255: 0x7FE3,
	12256: 0x75E2,
	12257: 0x7ACB,
	12258: 0x7C92,
	12259: 0x6CA5,
	12260: 0x96B6,
	12261: 0x529B,
	12262: 0x7483,
	12263: 0x54E9,
	12264: 0x4FE9,
	12265: 0x8054,
	12266: 0x83B2,
	12267: 0x8FDE,
	12268: 0x9570,
	12269: 0x5EC9,
	12270: 0x601C,
	12271: 0x6D9F,
	12272: 0x5E18,
	12273: 0x655B,
	12274: 0x8138,
	12275: 0x94FE,
	12276: 0x604B,
	12277: 0x70BC,
	12278: 0x7EC3,
	12279: 0x7CAE,
	12280: 0x51C9,
	12281: 0x6881,
	12282: 0x7CB1,
	12283: 0x826F,
	12284: 0x4E24,
	12285: 0x8F86,
	12286: 0x91CF,
	12287: 0x667E,
	12288: 0x4EAE,
	12289: 0x8C05,
	12290: 0x64A9,
	12291: 0x804A,
	12292: 0x50DA,
	12293: 0x7597,
	12294: 0x71CE,
	12295: 0x5BE5,
	12296: 0x8FBD,
	12297: 0x6F66,
	12298: 0x4E86,
	12299: 0x6482,
	12300: 0x9563,
	12301: 0x5ED6,
	12302: 0x6599,
	12303: 0x5217,
	12304: 0x88C2,
	12305: 0x70C8,
	12306: 0x52A3,
	12307: 0x730E,
	12308: 0x7433,
	12309: 0x6797,
	12310: 0x78F7,
	12311: 0x9716,
	12312: 0x4E34,
	12313: 0x90BB,
	12314: 0x9CDE,
	12315: 0x6DCB,
	12316: 0x51DB,
	12317: 0x8D41,
	12318: 0x541D,
	12319: 0x62CE,
	12320: 0x73B2,
	12321: 0x83F1,
	12322: 0x96F6,
	12323: 0x9F84,
	12324: 0x94C3,
	12325: 0x4F36,
	12326: 0x7F9A,
	12327: 0x51CC,
	12328: 0x7075,
	12329: 0x9675,
	12330: 0x5CAD,
	12331: 0x9886,
	12332: 0x53E6,
	12333: 0x4EE4,
	12334: 0x6E9C,
	12335: 0x7409,
	12336: 0x69B4,
	12337: 0x786B,
	12338: 0x998F,
	12339: 0x7559,
	12340: 0x5218,
	12341: 0x7624,
	12342: 0x6D41,
	12343: 0x67F3,
	12344: 0x516D,
	12345: 0x9F99,
	12346: 0x804B,
	12347: 0x5499,
	12348: 0x7B3C,
	12349: 0x7ABF,
	12350: 0x7FE4,
	12351: 0x7FE7,
	12352: 0x7FE8,
	12353: 0x7FEA,
	12354: 0x7FEB,
	12355: 0x7FEC,
	12356: 0x7FED,
	12357: 0x7FEF,
	12358: 0x7FF2,
	12359: 0x7FF4,
	12360: 0x7FF5,
	12361: 0x7FF6,
	12362: 0x7FF7,
	12363: 0x7FF8,
	12364: 0x7FF9,
	12365: 0x7FFA,
	12366: 0x7FFD,
	12367: 0x7FFE,
	12368: 0x7FFF,
	12369: 0x8002,
	12370: 0x8007,
	12371: 0x8008,
	12372: 0x8009,
	12373: 0x800A,
	12374: 0x800E,
	12375: 0x800F,
	12376: 0x8011,
	12377: 0x8013,
	12378: 0x801A,
	12379: 0x801B,
	12380: 0x801D,
	12381: 0x801E,
	12382: 0x801F,
	12383: 0x8021,
	12384: 0x8023,
	12385: 0x8024,
	12386: 0x802B,
	12387: 0x802C,
	12388: 0x802D,
	12389: 0x802E,
	12390: 0x802F,
	12391: 0x8030,
	12392: 0x8032,
	12393: 0x8034,
	12394: 0x8039,
	12395: 0x803A,
	12396: 0x803C,
	12397: 0x803E,
	12398: 0x8040,
	12399: 0x8041,
	12400: 0x8044,
	12401: 0x8045,
	12402: 0x8047,
	12403: 0x8048,
	12404: 0x8049,
	12405: 0x804E,
	12406: 0x804F,
	12407: 0x8050,
	12408: 0x8051,
	12409: 0x8053,
	12410: 0x8055,
	12411: 0x8056,
	12412: 0x8057,
	12413: 0x8059,
	12414: 0x805B,
	12415: 0x805C,
	12416: 0x805D,
	12417: 0x805E,
	12418: 0x805F,
	12419: 0x8060,
	12420: 0x8061,
	12421: 0x8062,
	12422: 0x8063,
	12423: 0x8064,
	12424: 0x8065,
	12425: 0x8066,
	12426: 0x8067,
	12427: 0x8068,
	12428: 0x806B,
	12429: 0x806C,
	12430: 0x806D,
	12431: 0x806E,
	12432: 0x806F,
	12433: 0x8070,
	12434: 0x8072,
	12435: 0x8073,
	12436: 0x8074,
	12437: 0x8075,
	12438: 0x8076,
	12439: 0x8077,
	12440: 0x8078,
	12441: 0x8079,
	12442: 0x807A,
	12443: 0x807B,
	12444: 0x807C,
	12445: 0x807D,
	12446: 0x9686,
	12447: 0x5784,
	12448: 0x62E2,
	12449: 0x9647,
	12450: 0x697C,
	12451: 0x5A04,
	12452: 0x6402,
	12453: 0x7BD3,
	12454: 0x6F0F,
	12455: 0x964B,
	12456: 0x82A6,
	12457: 0x5362,
	12458: 0x9885,
	12459: 0x5E90,
	12460: 0x7089,
	12461: 0x63B3,
	12462: 0x5364,
	12463: 0x864F,
	12464: 0x9C81,
	12465: 0x9E93,
	12466: 0x788C,
	12467: 0x9732,
	12468: 0x8DEF,
	12469: 0x8D42,
	12470: 0x9E7F,
	12471: 0x6F5E,
	12472: 0x7984,
	12473: 0x5F55,
	12474: 0x9646,
	12475: 0x622E,
	12476: 0x9A74,
	12477: 0x5415,
	12478: 0x94DD,
	12479: 0x4FA3,
	12480: 0x65C5,
	12481: 0x5C65,
	12482: 0x5C61,
	12483: 0x7F15,
	12484: 0x8651,
	12485: 0x6C2F,
	12486: 0x5F8B,
	12487: 0x7387,
	12488: 0x6EE4,
	12489: 0x7EFF,
	12490: 0x5CE6,
	12491: 0x631B,
	12492: 0x5B6A,
	12493: 0x6EE6,
	12494: 0x5375,
	12495: 0x4E71,
	12496: 0x63A0,
	12497: 0x7565,
	12498: 0x62A1,
	12499: 0x8F6E,
	12500: 0x4F26,
	12501: 0x4ED1,
	12502: 0x6CA6,
	12503: 0x7EB6,
	12504: 0x8BBA,
	12505: 0x841D,
	12506: 0x87BA,
	12507: 0x7F57,
	12508: 0x903B,
	12509: 0x9523,
	12510: 0x7BA9,
	12511: 0x9AA1,
	12512: 0x88F8,
	12513: 0x843D,
	12514: 0x6D1B,
	12515: 0x9A86,
	12516: 0x7EDC,
	12517: 0x5988,
	12518: 0x9EBB,
	12519: 0x739B,
	12520: 0x7801,
	12521: 0x8682,
	12522: 0x9A6C,
	12523: 0x9A82,
	12524: 0x561B,
	12525: 0x5417,
	12526: 0x57CB,
	12527: 0x4E70,
	12528: 0x9EA6,
	12529: 0x5356,
	12530: 0x8FC8,
	12531: 0x8109,
	12532: 0x7792,
	12533: 0x9992,
	12534: 0x86EE,
	12535: 0x6EE1,
	12536: 0x8513,
	12537: 0x66FC,
	12538: 0x6162,
	12539: 0x6F2B,
	12540: 0x807E,
	12541: 0x8081,
	12542: 0x8082,
	12543: 0x8085,
	12544: 0x8088,
	12545: 0x808A,
	12546: 0x808D,
	12547: 0x808E,
	12548: 0x808F,
	12549: 0x8090,
	12550: 0x8091,
	12551: 0x8092,
	12552: 0x8094,
	12553: 0x8095,
	12554: 0x8097,
	12555: 0x8099,
	12556: 0x809E,
	12557: 0x80A3,
	12558: 0x80A6,
	12559: 0x80A7,
	12560: 0x80A8,
	12561: 0x80AC,
	12562: 0x80B0,
	12563: 0x80B3,
	12564: 0x80B5,
	12565: 0x80B6,
	12566: 0x80B8,
	12567: 0x80B9,
	12568: 0x80BB,
	12569: 0x80C5,
	12570: 0x80C7,
	12571: 0x80C8,
	12572: 0x80C9,
	12573: 0x80CA,
	12574: 0x80CB,
	12575: 0x80CF,
	12576: 0x80D0,
	12577: 0x80D1,
	12578: 0x80D2,
	12579: 0x80D3,
	12580: 0x80D4,
	12581: 0x80D5,
	12582: 0x80D8,
	12583: 0x80DF,
	12584: 0x80E0,
	12585: 0x80E2,
	12586: 0x80E3,
	12587: 0x80E6,
	12588: 0x80EE,
	12589: 0x80F5,
	12590: 0x80F7,
	12591: 0x80F9,
	12592: 0x80FB,
	12593: 0x80FE,
	12594: 0x80FF,
	12595: 0x8100,
	12596: 0x8101,
	12597: 0x8103,
	12598: 0x8104,
	12599: 0x8105,
	12600: 0x8107,
	12601: 0x8108,
	12602: 0x810B,
	12603: 0x810C,
	12604: 0x8115,
	12605: 0x8117,
	12606: 0x8119,
	12607: 0x811B,
	12608: 0x811C,
	12609: 0x811D,
	12610: 0x811F,
	12611: 0x8120,
	12612: 0x8121,
	12613: 0x8122,
	12614: 0x8123,
	12615: 0x8124,
	12616: 0x8125,
	12617: 0x8126,
	12618: 0x8127,
	12619: 0x8128,
	12620: 0x8129,
	12621: 0x812A,
	12622: 0x812B,
	12623: 0x812D,
	12624: 0x812E,
	12625: 0x8130,
	12626: 0x8133,
	12627: 0x8134,
	12628: 0x8135,
	12629: 0x8137,
	12630: 0x8139,
	12631: 0x813A,
	12632: 0x813B,
	12633: 0x813C,
	12634: 0x813D,
	12635: 0x813F,
	12636: 0x8C29,
	12637: 0x8292,
	12638: 0x832B,
	12639: 0x76F2,
	12640: 0x6C13,
	12641: 0x5FD9,
	12642: 0x83BD,
	12643: 0x732B,
	12644: 0x8305,
	12645: 0x951A,
	12646: 0x6BDB,
	12647: 0x77DB,
	12648: 0x94C6,
	12649: 0x536F,
	12650: 0x8302,
	12651: 0x5192,
	12652: 0x5E3D,
	12653: 0x8C8C,
	12654: 0x8D38,
	12655: 0x4E48,
	12656: 0x73AB,
	12657: 0x679A,
	12658: 0x6885,
	12659: 0x9176,
	12660: 0x9709,
	12661: 0x7164,
	12662: 0x6CA1,
	12663: 0x7709,
	12664: 0x5A92,
	12665: 0x9541,
	12666: 0x6BCF,
	12667: 0x7F8E,
	12668: 0x6627,
	12669: 0x5BD0,
	12670: 0x59B9,
	12671: 0x5A9A,
	12672: 0x95E8,
	12673: 0x95F7,
	12674: 0x4EEC,
	12675: 0x840C,
	12676: 0x8499,
	12677: 0x6AAC,
	12678: 0x76DF,
	12679: 0x9530,
	12680: 0x731B,
	12681: 0x68A6,
	12682: 0x5B5F,
	12683: 0x772F,
	12684: 0x919A,
	12685: 0x9761,
	12686: 0x7CDC,
	12687: 0x8FF7,
	12688: 0x8C1C,
	12689: 0x5F25,
	12690: 0x7C73,
	12691: 0x79D8,
	12692: 0x89C5,
	12693: 0x6CCC,
	12694: 0x871C,
	12695: 0x5BC6,
	12696: 0x5E42,
	12697: 0x68C9,
	12698: 0x7720,
	12699: 0x7EF5,
	12700: 0x5195,
	12701: 0x514D,
	12702: 0x52C9,
	12703: 0x5A29,
	12704: 0x7F05,
	12705: 0x9762,
	12706: 0x82D7,
	12707: 0x63CF,
	12708: 0x7784,
	12709: 0x85D0,
	12710: 0x79D2,
	12711: 0x6E3A,
	12712: 0x5E99,
	12713: 0x5999,
	12714: 0x8511,
	12715: 0x706D,
	12716: 0x6C11,
	12717: 0x62BF,
	12718: 0x76BF,
	12719: 0x654F,
	12720: 0x60AF,
	12721: 0x95FD,
	12722: 0x660E,
	12723: 0x879F,
	12724: 0x9E23,
	12725: 0x94ED,
	12726: 0x540D,
	12727: 0x547D,
	12728: 0x8C2C,
	12729: 0x6478,
	12730: 0x8140,
	12731: 0x8141,
	12732: 0x8142,
	12733: 0x8143,
	12734: 0x8144,
	12735: 0x8145,
	12736: 0x8147,
	12737: 0x8149,
	12738: 0x814D,
	12739: 0x814E,
	12740: 0x814F,
	12741: 0x8152,
	12742: 0x8156,
	12743: 0x8157,
	12744: 0x8158,
	12745: 0x815B,
	12746: 0x815C,
	12747: 0x815D,
	12748: 0x815E,
	12749: 0x815F,
	12750: 0x8161,
	12751: 0x8162,
	12752: 0x8163,
	12753: 0x8164,
	12754: 0x8166,
	12755: 0x8168,
	12756: 0x816A,
	12757: 0x816B,
	12758: 0x816C,
	12759: 0x816F,
	12760: 0x8172,
	12761: 0x8173,
	12762: 0x8175,
	12763: 0x8176,
	12764: 0x8177,
	12765: 0x8178,
	12766: 0x8181,
	12767: 0x8183,
	12768: 0x8184,
	12769: 0x8185,
	12770: 0x8186,
	12771: 0x8187,
	12772: 0x8189,
	12773: 0x818B,
	12774: 0x818C,
	12775: 0x818D,
	12776: 0x818E,
	12777: 0x8190,
	12778: 0x8192,
	12779: 0x8193,
	12780: 0x8194,
	12781: 0x8195,
	12782: 0x8196,
	12783: 0x8197,
	12784: 0x8199,
	12785: 0x819A,
	12786: 0x819E,
	12787: 0x819F,
	12788: 0x81A0,
	12789: 0x81A1,
	12790: 0x81A2,
	12791: 0x81A4,
	12792: 0x81A5,
	12793: 0x81A7,
	12794: 0x81A9,
	12795: 0x81AB,
	12796: 0x81AC,
	12797: 0x81AD,
	12798: 0x81AE,
	12799: 0x81AF,
	12800: 0x81B0,
	12801: 0x81B1,
	12802: 0x81B2,
	12803: 0x81B4,
	12804: 0x81B5,
	12805: 0x81B6,
	12806: 0x81B7,
	12807: 0x81B8,
	12808: 0x81B9,
	12809: 0x81BC,
	12810: 0x81BD,
	12811: 0x81BE,
	12812: 0x81BF,
	12813: 0x81C4,
	12814: 0x81C5,
	12815: 0x81C7,
	12816: 0x81C8,
	12817: 0x81C9,
	12818: 0x81CB,
	12819: 0x81CD,
	12820: 0x81CE,
	12821: 0x81CF,
	12822: 0x81D0,
	12823: 0x81D1,
	12824: 0x81D2,
	12825: 0x81D3,
	12826: 0x6479,
	12827: 0x8611,
	12828: 0x6A21,
	12829: 0x819C,
	12830: 0x78E8,
	12831: 0x6469,
	12832: 0x9B54,
	12833: 0x62B9,
	12834: 0x672B,
	12835: 0x83AB,
	12836: 0x58A8,
	12837: 0x9ED8,
	12838: 0x6CAB,
	12839: 0x6F20,
	12840: 0x5BDE,
	12841: 0x964C,
	12842: 0x8C0B,
	12843: 0x725F,
	12844: 0x67D0,
	12845: 0x62C7,
	12846: 0x7261,
	12847: 0x4EA9,
	12848: 0x59C6,
	12849: 0x6BCD,
	12850: 0x5893,
	12851: 0x66AE,
	12852: 0x5E55,
	12853: 0x52DF,
	12854: 0x6155,
	12855: 0x6728,
	12856: 0x76EE,
	12857: 0x7766,
	12858: 0x7267,
	12859: 0x7A46,
	12860: 0x62FF,
	12861: 0x54EA,
	12862: 0x5450,
	12863: 0x94A0,
	12864: 0x90A3,
	12865: 0x5A1C,
	12866: 0x7EB3,
	12867: 0x6C16,
	12868: 0x4E43,
	12869: 0x5976,
	12870: 0x8010,
	12871: 0x5948,
	12872: 0x5357,
	12873: 0x7537,
	12874: 0x96BE,
	12875: 0x56CA,
	12876: 0x6320,
	12877: 0x8111,
	12878: 0x607C,
	12879: 0x95F9,
	12880: 0x6DD6,
	12881: 0x5462,
	12882: 0x9981,
	12883: 0x5185,
	12884: 0x5AE9,
	12885: 0x80FD,
	12886: 0x59AE,
	12887: 0x9713,
	12888: 0x502A,
	12889: 0x6CE5,
	12890: 0x5C3C,
	12891: 0x62DF,
	12892: 0x4F60,
	12893: 0x533F,
	12894: 0x817B,
	12895: 0x9006,
	12896: 0x6EBA,
	12897: 0x852B,
	12898: 0x62C8,
	12899: 0x5E74,
	12900: 0x78BE,
	12901: 0x64B5,
	12902: 0x637B,
	12903: 0x5FF5,
	12904: 0x5A18,
	12905: 0x917F,
	12906: 0x9E1F,
	12907: 0x5C3F,
	12908: 0x634F,
	12909: 0x8042,
	12910: 0x5B7D,
	12911: 0x556E,
	12912: 0x954A,
	12913: 0x954D,
	12914: 0x6D85,
	12915: 0x60A8,
	12916: 0x67E0,
	12917: 0x72DE,
	12918: 0x51DD,
	12919: 0x5B81,
	12920: 0x81D4,
	12921: 0x81D5,
	12922: 0x81D6,
	12923: 0x81D7,
	12924: 0x81D8,
	12925: 0x81D9,
	12926: 0x81DA,
	12927: 0x81DB,
	12928: 0x81DC,
	12929: 0x81DD,
	12930: 0x81DE,
	12931: 0x81DF,
	12932: 0x81E0,
	12933: 0x81E1,
	12934: 0x81E2,
	12935: 0x81E4,
	12936: 0x81E5,
	12937: 0x81E6,
	12938: 0x81E8,
	12939: 0x81E9,
	12940: 0x81EB,
	12941: 0x81EE,
	12942: 0x81EF,
	12943: 0x81F0,
	12944: 0x81F1,
	12945: 0x81F2,
	12946: 0x81F5,
	12947: 0x81F6,
	12948: 0x81F7,
	12949: 0x81F8,
	12950: 0x81F9,
	12951: 0x81FA,
	12952: 0x81FD,
	12953: 0x81FF,
	12954: 0x8203,
	12955: 0x8207,
	12956: 0x8208,
	12957: 0x8209,
	12958: 0x820A,
	12959: 0x820B,
	12960: 0x820E,
	12961: 0x820F,
	12962: 0x8211,
	12963: 0x8213,
	12964: 0x8215,
	12965: 0x8216,
	12966: 0x8217,
	12967: 0x8218,
	12968: 0x8219,
	12969: 0x821A,
	12970: 0x821D,
	12971: 0x8220,
	12972: 0x8224,
	12973: 0x8225,
	12974: 0x8226,
	12975: 0x8227,
	12976: 0x8229,
	12977: 0x822E,
	12978: 0x8232,
	12979: 0x823A,
	12980: 0x823C,
	12981: 0x823D,
	12982: 0x823F,
	12983: 0x8240,
	12984: 0x8241,
	12985: 0x8242,
	12986: 0x8243,
	12987: 0x8245,
	12988: 0x8246,
	12989: 0x8248,
	12990: 0x824A,
	12991: 0x824C,
	12992: 0x824D,
	12993: 0x824E,
	12994: 0x8250,
	12995: 0x8251,
	12996: 0x8252,
	12997: 0x8253,
	12998: 0x8254,
	12999: 0x8255,
	13000: 0x8256,
	13001: 0x8257,
	13002: 0x8259,
	13003: 0x825B,
	13004: 0x825C,
	13005: 0x825D,
	13006: 0x825E,
	13007: 0x8260,
	13008: 0x8261,
	13009: 0x8262,
	13010: 0x8263,
	13011: 0x8264,
	13012: 0x8265,
	13013: 0x8266,
	13014: 0x8267,
	13015: 0x8269,
	13016: 0x62E7,
	13017: 0x6CDE,
	13018: 0x725B,
	13019: 0x626D,
	13020: 0x94AE,
	13021: 0x7EBD,
	13022: 0x8113,
	13023: 0x6D53,
	13024: 0x519C,
	13025: 0x5F04,
	13026: 0x5974,
	13027: 0x52AA,
	13028: 0x6012,
	13029: 0x5973,
	13030: 0x6696,
	13031: 0x8650,
	13032: 0x759F,
	13033: 0x632A,
	13034: 0x61E6,
	13035: 0x7CEF,
	13036: 0x8BFA,
	13037: 0x54E6,
	13038: 0x6B27,
	13039: 0x9E25,
	13040: 0x6BB4,
	13041: 0x85D5,
	13042: 0x5455,
	13043: 0x5076,
	13044: 0x6CA4,
	13045: 0x556A,
	13046: 0x8DB4,
	13047: 0x722C,
	13048: 0x5E15,
	13049: 0x6015,
	13050: 0x7436,
	13051: 0x62CD,
	13052: 0x6392,
	13053: 0x724C,
	13054: 0x5F98,
	13055: 0x6E43,
	13056: 0x6D3E,
	13057: 0x6500,
	13058: 0x6F58,
	13059: 0x76D8,
	13060: 0x78D0,
	13061: 0x76FC,
	13062: 0x7554,
	13063: 0x5224,
	13064: 0x53DB,
	13065: 0x4E53,
	13066: 0x5E9E,
	13067: 0x65C1,
	13068: 0x802A,
	13069: 0x80D6,
	13070: 0x629B,
	13071: 0x5486,
	13072: 0x5228,
	13073: 0x70AE,
	13074: 0x888D,
	13075: 0x8DD1,
	13076: 0x6CE1,
	13077: 0x5478,
	13078: 0x80DA,
	13079: 0x57F9,
	13080: 0x88F4,
	13081: 0x8D54,
	13082: 0x966A,
	13083: 0x914D,
	13084: 0x4F69,
	13085: 0x6C9B,
	13086: 0x55B7,
	13087: 0x76C6,
	13088: 0x7830,
	13089: 0x62A8,
	13090: 0x70F9,
	13091: 0x6F8E,
	13092: 0x5F6D,
	13093: 0x84EC,
	13094: 0x68DA,
	13095: 0x787C,
	13096: 0x7BF7,
	13097: 0x81A8,
	13098: 0x670B,
	13099: 0x9E4F,
	13100: 0x6367,
	13101: 0x78B0,
	13102: 0x576F,
	13103: 0x7812,
	13104: 0x9739,
	13105: 0x6279,
	13106: 0x62AB,
	13107: 0x5288,
	13108: 0x7435,
	13109: 0x6BD7,
	13110: 0x826A,
	13111: 0x826B,
	13112: 0x826C,
	13113: 0x826D,
	13114: 0x8271,
	13115: 0x8275,
	13116: 0x8276,
	13117: 0x8277,
	13118: 0x8278,
	13119: 0x827B,
	13120: 0x827C,
	13121: 0x8280,
	13122: 0x8281,
	13123: 0x8283,
	13124: 0x8285,
	13125: 0x8286,
	13126: 0x8287,
	13127: 0x8289,
	13128: 0x828C,
	13129: 0x8290,
	13130: 0x8293,
	13131: 0x8294,
	13132: 0x8295,
	13133: 0x8296,
	13134: 0x829A,
	13135: 0x829B,
	13136: 0x829E,
	13137: 0x82A0,
	13138: 0x82A2,
	13139: 0x82A3,
	13140: 0x82A7,
	13141: 0x82B2,
	13142: 0x82B5,
	13143: 0x82B6,
	13144: 0x82BA,
	13145: 0x82BB,
	13146: 0x82BC,
	13147: 0x82BF,
	13148: 0x82C0,
	13149: 0x82C2,
	13150: 0x82C3,
	13151: 0x82C5,
	13152: 0x82C6,
	13153: 0x82C9,
	13154: 0x82D0,
	13155: 0x82D6,
	13156: 0x82D9,
	13157: 0x82DA,
	13158: 0x82DD,
	13159: 0x82E2,
	13160: 0x82E7,
	13161: 0x82E8,
	13162: 0x82E9,
	13163: 0x82EA,
	13164: 0x82EC,
	13165: 0x82ED,
	13166: 0x82EE,
	13167: 0x82F0,
	13168: 0x82F2,
	13169: 0x82F3,
	13170: 0x82F5,
	13171: 0x82F6,
	13172: 0x82F8,
	13173: 0x82FA,
	13174: 0x82FC,
	13175: 0x82FD,
	13176: 0x82FE,
	13177: 0x82FF,
	13178: 0x8300,
	13179: 0x830A,
	13180: 0x830B,
	13181: 0x830D,
	13182: 0x8310,
	13183: 0x8312,
	13184: 0x8313,
	13185: 0x8316,
	13186: 0x8318,
	13187: 0x8319,
	13188: 0x831D,
	13189: 0x831E,
	13190: 0x831F,
	13191: 0x8320,
	13192: 0x8321,
	13193: 0x8322,
	13194: 0x8323,
	13195: 0x8324,
	13196: 0x8325,
	13197: 0x8326,
	13198: 0x8329,
	13199: 0x832A,
	13200: 0x832E,
	13201: 0x8330,
	13202: 0x8332,
	13203: 0x8337,
	13204: 0x833B,
	13205: 0x833D,
	13206: 0x5564,
	13207: 0x813E,
	13208: 0x75B2,
	13209: 0x76AE,
	13210: 0x5339,
	13211: 0x75DE,
	13212: 0x50FB,
	13213: 0x5C41,
	13214: 0x8B6C,
	13215: 0x7BC7,
	13216: 0x504F,
	13217: 0x7247,
	13218: 0x9A97,
	13219: 0x98D8,
	13220: 0x6F02,
	13221: 0x74E2,
	13222: 0x7968,
	13223: 0x6487,
	13224: 0x77A5,
	13225: 0x62FC,
	13226: 0x9891,
	13227: 0x8D2B,
	13228: 0x54C1,
	13229: 0x8058,
	13230: 0x4E52,
	13231: 0x576A,
	13232: 0x82F9,
	13233: 0x840D,
	13234: 0x5E73,
	13235: 0x51ED,
	13236: 0x74F6,
	13237: 0x8BC4,
	13238: 0x5C4F,
	13239: 0x5761,
	13240: 0x6CFC,
	13241: 0x9887,
	13242: 0x5A46,
	13243: 0x7834,
	13244: 0x9B44,
	13245: 0x8FEB,
	13246: 0x7C95,
	13247: 0x5256,
	13248: 0x6251,
	13249: 0x94FA,
	13250: 0x4EC6,
	13251: 0x8386,
	13252: 0x8461,
	13253: 0x83E9,
	13254: 0x84B2,
	13255: 0x57D4,
	13256: 0x6734,
	13257: 0x5703,
	13258: 0x666E,
	13259: 0x6D66,
	13260: 0x8C31,
	13261: 0x66DD,
	13262: 0x7011,
	13263: 0x671F,
	13264: 0x6B3A,
	13265: 0x6816,
	13266: 0x621A,
	13267: 0x59BB,
	13268: 0x4E03,
	13269: 0x51C4,
	13270: 0x6F06,
	13271: 0x67D2,
	13272: 0x6C8F,
	13273: 0x5176,
	13274: 0x68CB,
	13275: 0x5947,
	13276: 0x6B67,
	13277: 0x7566,
	13278: 0x5D0E,
	13279: 0x8110,
	13280: 0x9F50,
	13281: 0x65D7,
	13282: 0x7948,
	13283: 0x7941,
	13284: 0x9A91,
	13285: 0x8D77,
	13286: 0x5C82,
	13287: 0x4E5E,
	13288: 0x4F01,
	13289: 0x542F,
	13290: 0x5951,
	13291: 0x780C,
	13292: 0x5668,
	13293: 0x6C14,
	13294: 0x8FC4,
	13295: 0x5F03,
	13296: 0x6C7D,
	13297: 0x6CE3,
	13298: 0x8BAB,
	13299: 0x6390,
	13300: 0x833E,
	13301: 0x833F,
	13302: 0x8341,
	13303: 0x8342,
	13304: 0x8344,
	13305: 0x8345,
	13306: 0x8348,
	13307: 0x834A,
	13308: 0x834B,
	13309: 0x834C,
	13310: 0x834D,
	13311: 0x834E,
	13312: 0x8353,
	13313: 0x8355,
	13314: 0x8356,
	13315: 0x8357,
	13316: 0x8358,
	13317: 0x8359,
	13318: 0x835D,
	13319: 0x8362,
	13320: 0x8370,
	13321: 0x8371,
	13322: 0x8372,
	13323: 0x8373,
	13324: 0x8374,
	13325: 0x8375,
	13326: 0x8376,
	13327: 0x8379,
	13328: 0x837A,
	13329: 0x837E,
	13330: 0x837F,
	13331: 0x8380,
	13332: 0x8381,
	13333: 0x8382,
	13334: 0x8383,
	13335: 0x8384,
	13336: 0x8387,
	13337: 0x8388,
	13338: 0x838A,
	13339: 0x838B,
	13340: 0x838C,
	13341: 0x838D,
	13342: 0x838F,
	13343: 0x8390,
	13344: 0x8391,
	13345: 0x8394,
	13346: 0x8395,
	13347: 0x8396,
	13348: 0x8397,
	13349: 0x8399,
	13350: 0x839A,
	13351: 0x839D,
	13352: 0x839F,
	13353: 0x83A1,
	13354: 0x83A2,
	13355: 0x83A3,
	13356: 0x83A4,
	13357: 0x83A5,
	13358: 0x83A6,
	13359: 0x83A7,
	13360: 0x83AC,
	13361: 0x83AD,
	13362: 0x83AE,
	13363: 0x83AF,
	13364: 0x83B5,
	13365: 0x83BB,
	13366: 0x83BE,
	13367: 0x83BF,
	13368: 0x83C2,
	13369: 0x83C3,
	13370: 0x83C4,
	13371: 0x83C6,
	13372: 0x83C8,
	13373: 0x83C9,
	13374: 0x83CB,
	13375: 0x83CD,
	13376: 0x83CE,
	13377: 0x83D0,
	13378: 0x83D1,
	13379: 0x83D2,
	13380: 0x83D3,
	13381: 0x83D5,
	13382: 0x83D7,
	13383: 0x83D9,
	13384: 0x83DA,
	13385: 0x83DB,
	13386: 0x83DE,
	13387: 0x83E2,
	13388: 0x83E3,
	13389: 0x83E4,
	13390: 0x83E6,
	13391: 0x83E7,
	13392: 0x83E8,
	13393: 0x83EB,
	13394: 0x83EC,
	13395: 0x83ED,
	13396: 0x6070,
	13397: 0x6D3D,
	13398: 0x7275,
	13399: 0x6266,
	13400: 0x948E,
	13401: 0x94C5,
	13402: 0x5343,
	13403: 0x8FC1,
	13404: 0x7B7E,
	13405: 0x4EDF,
	13406: 0x8C26,
	13407: 0x4E7E,
	13408: 0x9ED4,
	13409: 0x94B1,
	13410: 0x94B3,
	13411: 0x524D,
	13412: 0x6F5C,
	13413: 0x9063,
	13414: 0x6D45,
	13415: 0x8C34,
	13416: 0x5811,
	13417: 0x5D4C,
	13418: 0x6B20,
	13419: 0x6B49,
	13420: 0x67AA,
	13421: 0x545B,
	13422: 0x8154,
	13423: 0x7F8C,
	13424: 0x5899,
	13425: 0x8537,
	13426: 0x5F3A,
	13427: 0x62A2,
	13428: 0x6A47,
	13429: 0x9539,
	13430: 0x6572,
	13431: 0x6084,
	13432: 0x6865,
	13433: 0x77A7,
	13434: 0x4E54,
	13435: 0x4FA8,
	13436: 0x5DE7,
	13437: 0x9798,
	13438: 0x64AC,
	13439: 0x7FD8,
	13440: 0x5CED,
	13441: 0x4FCF,
	13442: 0x7A8D,
	13443: 0x5207,
	13444: 0x8304,
	13445: 0x4E14,
	13446: 0x602F,
	13447: 0x7A83,
	13448: 0x94A6,
	13449: 0x4FB5,
	13450: 0x4EB2,
	13451: 0x79E6,
	13452: 0x7434,
	13453: 0x52E4,
	13454: 0x82B9,
	13455: 0x64D2,
	13456: 0x79BD,
	13457: 0x5BDD,
	13458: 0x6C81,
	13459: 0x9752,
	13460: 0x8F7B,
	13461: 0x6C22,
	13462: 0x503E,
	13463: 0x537F,
	13464: 0x6E05,
	13465: 0x64CE,
	13466: 0x6674,
	13467: 0x6C30,
	13468: 0x60C5,
	13469: 0x9877,
	13470: 0x8BF7,
	13471: 0x5E86,
	13472: 0x743C,
	13473: 0x7A77,
	13474: 0x79CB,
	13475: 0x4E18,
	13476: 0x90B1,
	13477: 0x7403,
	13478: 0x6C42,
	13479: 0x56DA,
	13480: 0x914B,
	13481: 0x6CC5,
	13482: 0x8D8B,
	13483: 0x533A,
	13484: 0x86C6,
	13485: 0x66F2,
	13486: 0x8EAF,
	13487: 0x5C48,
	13488: 0x9A71,
	13489: 0x6E20,
	13490: 0x83EE,
	13491: 0x83EF,
	13492: 0x83F3,
	13493: 0x83F4,
	13494: 0x83F5,
	13495: 0x83F6,
	13496: 0x83F7,
	13497: 0x83FA,
	13498: 0x83FB,
	13499: 0x83FC,
	13500: 0x83FE,
	13501: 0x83FF,
	13502: 0x8400,
	13503: 0x8402,
	13504: 0x8405,
	13505: 0x8407,
	13506: 0x8408,
	13507: 0x8409,
	13508: 0x840A,
	13509: 0x8410,
	13510: 0x8412,
	13511: 0x8413,
	13512: 0x8414,
	13513: 0x8415,
	13514: 0x8416,
	13515: 0x8417,
	13516: 0x8419,
	13517: 0x841A,
	13518: 0x841B,
	13519: 0x841E,
	13520: 0x841F,
	13521: 0x8420,
	13522: 0x8421,
	13523: 0x8422,
	13524: 0x8423,
	13525: 0x8429,
	13526: 0x842A,
	13527: 0x842B,
	13528: 0x842C,
	13529: 0x842D,
	13530: 0x842E,
	13531: 0x842F,
	13532: 0x8430,
	13533: 0x8432,
	13534: 0x8433,
	13535: 0x8434,
	13536: 0x8435,
	13537: 0x8436,
	13538: 0x8437,
	13539: 0x8439,
	13540: 0x843A,
	13541: 0x843B,
	13542: 0x843E,
	13543: 0x843F,
	13544: 0x8440,
	13545: 0x8441,
	13546: 0x8442,
	13547: 0x8443,
	13548: 0x8444,
	13549: 0x8445,
	13550: 0x8447,
	13551: 0x8448,
	13552: 0x8449,
	13553: 0x844A,
	13554: 0x844B,
	13555: 0x844C,
	13556: 0x844D,
	13557: 0x844E,
	13558: 0x844F,
	13559: 0x8450,
	13560: 0x8452,
	13561: 0x8453,
	13562: 0x8454,
	13563: 0x8455,
	13564: 0x8456,
	13565: 0x8458,
	13566: 0x845D,
	13567: 0x845E,
	13568: 0x845F,
	13569: 0x8460,
	13570: 0x8462,
	13571: 0x8464,
	13572: 0x8465,
	13573: 0x8466,
	13574: 0x8467,
	13575: 0x8468,
	13576: 0x846A,
	13577: 0x846E,
	13578: 0x846F,
	13579: 0x8470,
	13580: 0x8472,
	13581: 0x8474,
	13582: 0x8477,
	13583: 0x8479,
	13584: 0x847B,
	13585: 0x847C,
	13586: 0x53D6,
	13587: 0x5A36,
	13588: 0x9F8B,
	13589: 0x8DA3,
	13590: 0x53BB,
	13591: 0x5708,
	13592: 0x98A7,
	13593: 0x6743,
	13594: 0x919B,
	13595: 0x6CC9,
	13596: 0x5168,
	13597: 0x75CA,
	13598: 0x62F3,
	13599: 0x72AC,
	13600: 0x5238,
	13601: 0x529D,
	13602: 0x7F3A,
	13603: 0x7094,
	13604: 0x7638,
	13605: 0x5374,
	13606: 0x9E4A,
	13607: 0x69B7,
	13608: 0x786E,
	13609: 0x96C0,
	13610: 0x88D9,
	13611: 0x7FA4,
	13612: 0x7136,
	13613: 0x71C3,
	13614: 0x5189,
	13615: 0x67D3,
	13616: 0x74E4,
	13617: 0x58E4,
	13618: 0x6518,
	13619: 0x56B7,
	13620: 0x8BA9,
	13621: 0x9976,
	13622: 0x6270,
	13623: 0x7ED5,
	13624: 0x60F9,
	13625: 0x70ED,
	13626: 0x58EC,
	13627: 0x4EC1,
	13628: 0x4EBA,
	13629: 0x5FCD,
	13630: 0x97E7,
	13631: 0x4EFB,
	13632: 0x8BA4,
	13633: 0x5203,
	13634: 0x598A,
	13635: 0x7EAB,
	13636: 0x6254,
	13637: 0x4ECD,
	13638: 0x65E5,
	13639: 0x620E,
	13640: 0x8338,
	13641: 0x84C9,
	13642: 0x8363,
	13643: 0x878D,
	13644: 0x7194,
	13645: 0x6EB6,
	13646: 0x5BB9,
	13647: 0x7ED2,
	13648: 0x5197,
	13649: 0x63C9,
	13650: 0x67D4,
	13651: 0x8089,
	13652: 0x8339,
	13653: 0x8815,
	13654: 0x5112,
	13655: 0x5B7A,
	13656: 0x5982,
	13657: 0x8FB1,
	13658: 0x4E73,
	13659: 0x6C5D,
	13660: 0x5165,
	13661: 0x8925,
	13662: 0x8F6F,
	13663: 0x962E,
	13664: 0x854A,
	13665: 0x745E,
	13666: 0x9510,
	13667: 0x95F0,
	13668: 0x6DA6,
	13669: 0x82E5,
	13670: 0x5F31,
	13671: 0x6492,
	13672: 0x6D12,
	13673: 0x8428,
	13674: 0x816E,
	13675: 0x9CC3,
	13676: 0x585E,
	13677: 0x8D5B,
	13678: 0x4E09,
	13679: 0x53C1,
	13680: 0x847D,
	13681: 0x847E,
	13682: 0x847F,
	13683: 0x8480,
	13684: 0x8481,
	13685: 0x8483,
	13686: 0x8484,
	13687: 0x8485,
	13688: 0x8486,
	13689: 0x848A,
	13690: 0x848D,
	13691: 0x848F,
	13692: 0x8490,
	13693: 0x8491,
	13694: 0x8492,
	13695: 0x8493,
	13696: 0x8494,
	13697: 0x8495,
	13698: 0x8496,
	13699: 0x8498,
	13700: 0x849A,
	13701: 0x849B,
	13702: 0x849D,
	13703: 0x849E,
	13704: 0x849F,
	13705: 0x84A0,
	13706: 0x84A2,
	13707: 0x84A3,
	13708: 0x84A4,
	13709: 0x84A5,
	13710: 0x84A6,
	13711: 0x84A7,
	13712: 0x84A8,
	13713: 0x84A9,
	13714: 0x84AA,
	13715: 0x84AB,
	13716: 0x84AC,
	13717: 0x84AD,
	13718: 0x84AE,
	13719: 0x84B0,
	13720: 0x84B1,
	13721: 0x84B3,
	13722: 0x84B5,
	13723: 0x84B6,
	13724: 0x84B7,
	13725: 0x84BB,
	13726: 0x84BC,
	13727: 0x84BE,
	13728: 0x84C0,
	13729: 0x84C2,
	13730: 0x84C3,
	13731: 0x84C5,
	13732: 0x84C6,
	13733: 0x84C7,
	13734: 0x84C8,
	13735: 0x84CB,
	13736: 0x84CC,
	13737: 0x84CE,
	13738: 0x84CF,
	13739: 0x84D2,
	13740: 0x84D4,
	13741: 0x84D5,
	13742: 0x84D7,
	13743: 0x84D8,
	13744: 0x84D9,
	13745: 0x84DA,
	13746: 0x84DB,
	13747: 0x84DC,
	13748: 0x84DE,
	13749: 0x84E1,
	13750: 0x84E2,
	13751: 0x84E4,
	13752: 0x84E7,
	13753: 0x84E8,
	13754: 0x84E9,
	13755: 0x84EA,
	13756: 0x84EB,
	13757: 0x84ED,
	13758: 0x84EE,
	13759: 0x84EF,
	13760: 0x84F1,
	13761: 0x84F2,
	13762: 0x84F3,
	13763: 0x84F4,
	13764: 0x84F5,
	13765: 0x84F6,
	13766: 0x84F7,
	13767: 0x84F8,
	13768: 0x84F9,
	13769: 0x84FA,
	13770: 0x84FB,
	13771: 0x84FD,
	13772: 0x84FE,
	13773: 0x8500,
	13774: 0x8501,
	13775: 0x8502,
	13776: 0x4F1E,
	13777: 0x6563,
	13778: 0x6851,
	13779: 0x55D3,
	13780: 0x4E27,
	13781: 0x6414,
	13782: 0x9A9A,
	13783: 0x626B,
	13784: 0x5AC2,
	13785: 0x745F,
	13786: 0x8272,
	13787: 0x6DA9,
	13788: 0x68EE,
	13789: 0x50E7,
	13790: 0x838E,
	13791: 0x7802,
	13792: 0x6740,
	13793: 0x5239,
	13794: 0x6C99,
	13795: 0x7EB1,
	13796: 0x50BB,
	13797: 0x5565,
	13798: 0x715E,
	13799: 0x7B5B,
	13800: 0x6652,
	13801: 0x73CA,
	13802: 0x82EB,
	13803: 0x6749,
	13804: 0x5C71,
	13805: 0x5220,
	13806: 0x717D,
	13807: 0x886B,
	13808: 0x95EA,
	13809: 0x9655,
	13810: 0x64C5,
	13811: 0x8D61,
	13812: 0x81B3,
	13813: 0x5584,
	13814: 0x6C55,
	13815: 0x6247,
	13816: 0x7F2E,
	13817: 0x5892,
	13818: 0x4F24,
	13819: 0x5546,
	13820: 0x8D4F,
	13821: 0x664C,
	13822: 0x4E0A,
	13823: 0x5C1A,
	13824: 0x88F3,
	13825: 0x68A2,
	13826: 0x634E,
	13827: 0x7A0D,
	13828: 0x70E7,
	13829: 0x828D,
	13830: 0x52FA,
	13831: 0x97F6,
	13832: 0x5C11,
	13833: 0x54E8,
	13834: 0x90B5,
	13835: 0x7ECD,
	13836: 0x5962,
	13837: 0x8D4A,
	13838: 0x86C7,
	13839: 0x820C,
	13840: 0x820D,
	13841: 0x8D66,
	13842: 0x6444,
	13843: 0x5C04,
	13844: 0x6151,
	13845: 0x6D89,
	13846: 0x793E,
	13847: 0x8BBE,
	13848: 0x7837,
	13849: 0x7533,
	13850: 0x547B,
	13851: 0x4F38,
	13852: 0x8EAB,
	13853: 0x6DF1,
	13854: 0x5A20,
	13855: 0x7EC5,
	13856: 0x795E,
	13857: 0x6C88,
	13858: 0x5BA1,
	13859: 0x5A76,
	13860: 0x751A,
	13861: 0x80BE,
	13862: 0x614E,
	13863: 0x6E17,
	13864: 0x58F0,
	13865: 0x751F,
	13866: 0x7525,
	13867: 0x7272,
	13868: 0x5347,
	13869: 0x7EF3,
	13870: 0x8503,
	13871: 0x8504,
	13872: 0x8505,
	13873: 0x8506,
	13874: 0x8507,
	13875: 0x8508,
	13876: 0x8509,
	13877: 0x850A,
	13878: 0x850B,
	13879: 0x850D,
	13880: 0x850E,
	13881: 0x850F,
	13882: 0x8510,
	13883: 0x8512,
	13884: 0x8514,
	13885: 0x8515,
	13886: 0x8516,
	13887: 0x8518,
	13888: 0x8519,
	13889: 0x851B,
	13890: 0x851C,
	13891: 0x851D,
	13892: 0x851E,
	13893: 0x8520,
	13894: 0x8522,
	13895: 0x8523,
	13896: 0x8524,
	13897: 0x8525,
	13898: 0x8526,
	13899: 0x8527,
	13900: 0x8528,
	13901: 0x8529,
	13902: 0x852A,
	13903: 0x852D,
	13904: 0x852E,
	13905: 0x852F,
	13906: 0x8530,
	13907: 0x8531,
	13908: 0x8532,
	13909: 0x8533,
	13910: 0x8534,
	13911: 0x8535,
	13912: 0x8536,
	13913: 0x853E,
	13914: 0x853F,
	13915: 0x8540,
	13916: 0x8541,
	13917: 0x8542,
	13918: 0x8544,
	13919: 0x8545,
	13920: 0x8546,
	13921: 0x8547,
	13922: 0x854B,
	13923: 0x854C,
	13924: 0x854D,
	13925: 0x854E,
	13926: 0x854F,
	13927: 0x8550,
	13928: 0x8551,
	13929: 0x8552,
	13930: 0x8553,
	13931: 0x8554,
	13932: 0x8555,
	13933: 0x8557,
	13934: 0x8558,
	13935: 0x855A,
	13936: 0x855B,
	13937: 0x855C,
	13938: 0x855D,
	13939: 0x855F,
	13940: 0x8560,
	13941: 0x8561,
	13942: 0x8562,
	13943: 0x8563,
	13944: 0x8565,
	13945: 0x8566,
	13946: 0x8567,
	13947: 0x8569,
	13948: 0x856A,
	13949: 0x856B,
	13950: 0x856C,
	13951: 0x856D,
	13952: 0x856E,
	13953: 0x856F,
	13954: 0x8570,
	13955: 0x8571,
	13956: 0x8573,
	13957: 0x8575,
	13958: 0x8576,
	13959: 0x8577,
	13960: 0x8578,
	13961: 0x857C,
	13962: 0x857D,
	13963: 0x857F,
	13964: 0x8580,
	13965: 0x8581,
	13966: 0x7701,
	13967: 0x76DB,
	13968: 0x5269,
	13969: 0x80DC,
	13970: 0x5723,
	13971: 0x5E08,
	13972: 0x5931,
	13973: 0x72EE,
	13974: 0x65BD,
	13975: 0x6E7F,
	13976: 0x8BD7,
	13977: 0x5C38,
	13978: 0x8671,
	13979: 0x5341,
	13980: 0x77F3,
	13981: 0x62FE,
	13982: 0x65F6,
	13983: 0x4EC0,
	13984: 0x98DF,
	13985: 0x8680,
	13986: 0x5B9E,
	13987: 0x8BC6,
	13988: 0x53F2,
	13989: 0x77E2,
	13990: 0x4F7F,
	13991: 0x5C4E,
	13992: 0x9A76,
	13993: 0x59CB,
	13994: 0x5F0F,
	13995: 0x793A,
	13996: 0x58EB,
	13997: 0x4E16,
	13998: 0x67FF,
	13999: 0x4E8B,
	14000: 0x62ED,
	14001: 0x8A93,
	14002: 0x901D,
	14003: 0x52BF,
	14004: 0x662F,
	14005: 0x55DC,
	14006: 0x566C,
	14007: 0x9002,
	14008: 0x4ED5,
	14009: 0x4F8D,
	14010: 0x91CA,
	14011: 0x9970,
	14012: 0x6C0F,
	14013: 0x5E02,
	14014: 0x6043,
	14015: 0x5BA4,
	14016: 0x89C6,
	14017: 0x8BD5,
	14018: 0x6536,
	14019: 0x624B,
	14020: 0x9996,
	14021: 0x5B88,
	14022: 0x5BFF,
	14023: 0x6388,
	14024: 0x552E,
	14025: 0x53D7,
	14026: 0x7626,
	14027: 0x517D,
	14028: 0x852C,
	14029: 0x67A2,
	14030: 0x68B3,
	14031: 0x6B8A,
	14032: 0x6292,
	14033: 0x8F93,
	14034: 0x53D4,
	14035: 0x8212,
	14036: 0x6DD1,
	14037: 0x758F,
	14038: 0x4E66,
	14039: 0x8D4E,
	14040: 0x5B70,
	14041: 0x719F,
	14042: 0x85AF,
	14043: 0x6691,
	14044: 0x66D9,
	14045: 0x7F72,
	14046: 0x8700,
	14047: 0x9ECD,
	14048: 0x9F20,
	14049: 0x5C5E,
	14050: 0x672F,
	14051: 0x8FF0,
	14052: 0x6811,
	14053: 0x675F,
	14054: 0x620D,
	14055: 0x7AD6,
	14056: 0x5885,
	14057: 0x5EB6,
	14058: 0x6570,
	14059: 0x6F31,
	14060: 0x8582,
	14061: 0x8583,
	14062: 0x8586,
	14063: 0x8588,
	14064: 0x8589,
	14065: 0x858A,
	14066: 0x858B,
	14067: 0x858C,
	14068: 0x858D,
	14069: 0x858E,
	14070: 0x8590,
	14071: 0x8591,
	14072: 0x8592,
	14073: 0x8593,
	14074: 0x8594,
	14075: 0x8595,
	14076: 0x8596,
	14077: 0x8597,
	14078: 0x8598,
	14079: 0x8599,
	14080: 0x859A,
	14081: 0x859D,
	14082: 0x859E,
	14083: 0x859F,
	14084: 0x85A0,
	14085: 0x85A1,
	14086: 0x85A2,
	14087: 0x85A3,
	14088: 0x85A5,
	14089: 0x85A6,
	14090: 0x85A7,
	14091: 0x85A9,
	14092: 0x85AB,
	14093: 0x85AC,
	14094: 0x85AD,
	14095: 0x85B1,
	14096: 0x85B2,
	14097: 0x85B3,
	14098: 0x85B4,
	14099: 0x85B5,
	14100: 0x85B6,
	14101: 0x85B8,
	14102: 0x85BA,
	14103: 0x85BB,
	14104: 0x85BC,
	14105: 0x85BD,
	14106: 0x85BE,
	14107: 0x85BF,
	14108: 0x85C0,
	14109: 0x85C2,
	14110: 0x85C3,
	14111: 0x85C4,
	14112: 0x85C5,
	14113: 0x85C6,
	14114: 0x85C7,
	14115: 0x85C8,
	14116: 0x85CA,
	14117: 0x85CB,
	14118: 0x85CC,
	14119: 0x85CD,
	14120: 0x85CE,
	14121: 0x85D1,
	14122: 0x85D2,
	14123: 0x85D4,
	14124: 0x85D6,
	14125: 0x85D7,
	14126: 0x85D8,
	14127: 0x85D9,
	14128: 0x85DA,
	14129: 0x85DB,
	14130: 0x85DD,
	14131: 0x85DE,
	14132: 0x85DF,
	14133: 0x85E0,
	14134: 0x85E1,
	14135: 0x85E2,
	14136: 0x85E3,
	14137: 0x85E5,
	14138: 0x85E6,
	14139: 0x85E7,
	14140: 0x85E8,
	14141: 0x85EA,
	14142: 0x85EB,
	14143: 0x85EC,
	14144: 0x85ED,
	14145: 0x85EE,
	14146: 0x85EF,
	14147: 0x85F0,
	14148: 0x85F1,
	14149: 0x85F2,
	14150: 0x85F3,
	14151: 0x85F4,
	14152: 0x85F5,
	14153: 0x85F6,
	14154: 0x85F7,
	14155: 0x85F8,
	14156: 0x6055,
	14157: 0x5237,
	14158: 0x800D,
	14159: 0x6454,
	14160: 0x8870,
	14161: 0x7529,
	14162: 0x5E05,
	14163: 0x6813,
	14164: 0x62F4,
	14165: 0x971C,
	14166: 0x53CC,
	14167: 0x723D,
	14168: 0x8C01,
	14169: 0x6C34,
	14170: 0x7761,
	14171: 0x7A0E,
	14172: 0x542E,
	14173: 0x77AC,
	14174: 0x987A,
	14175: 0x821C,
	14176: 0x8BF4,
	14177: 0x7855,
	14178: 0x6714,
	14179: 0x70C1,
	14180: 0x65AF,
	14181: 0x6495,
	14182: 0x5636,
	14183: 0x601D,
	14184: 0x79C1,
	14185: 0x53F8,
	14186: 0x4E1D,
	14187: 0x6B7B,
	14188: 0x8086,
	14189: 0x5BFA,
	14190: 0x55E3,
	14191: 0x56DB,
	14192: 0x4F3A,
	14193: 0x4F3C,
	14194: 0x9972,
	14195: 0x5DF3,
	14196: 0x677E,
	14197: 0x8038,
	14198: 0x6002,
	14199: 0x9882,
	14200: 0x9001,
	14201: 0x5B8B,
	14202: 0x8BBC,
	14203: 0x8BF5,
	14204: 0x641C,
	14205: 0x8258,
	14206: 0x64DE,
	14207: 0x55FD,
	14208: 0x82CF,
	14209: 0x9165,
	14210: 0x4FD7,
	14211: 0x7D20,
	14212: 0x901F,
	14213: 0x7C9F,
	14214: 0x50F3,
	14215: 0x5851,
	14216: 0x6EAF,
	14217: 0x5BBF,
	14218: 0x8BC9,
	14219: 0x8083,
	14220: 0x9178,
	14221: 0x849C,
	14222: 0x7B97,
	14223: 0x867D,
	14224: 0x968B,
	14225: 0x968F,
	14226: 0x7EE5,
	14227: 0x9AD3,
	14228: 0x788E,
	14229: 0x5C81,
	14230: 0x7A57,
	14231: 0x9042,
	14232: 0x96A7,
	14233: 0x795F,
	14234: 0x5B59,
	14235: 0x635F,
	14236: 0x7B0B,
	14237: 0x84D1,
	14238: 0x68AD,
	14239: 0x5506,
	14240: 0x7F29,
	14241: 0x7410,
	14242: 0x7D22,
	14243: 0x9501,
	14244: 0x6240,
	14245: 0x584C,
	14246: 0x4ED6,
	14247: 0x5B83,
	14248: 0x5979,
	14249: 0x5854,
	14250: 0x85F9,
	14251: 0x85FA,
	14252: 0x85FC,
	14253: 0x85FD,
	14254: 0x85FE,
	14255: 0x8600,
	14256: 0x8601,
	14257: 0x8602,
	14258: 0x8603,
	14259: 0x8604,
	14260: 0x8606,
	14261: 0x8607,
	14262: 0x8608,
	14263: 0x8609,
	14264: 0x860A,
	14265: 0x860B,
	14266: 0x860C,
	14267: 0x860D,
	14268: 0x860E,
	14269: 0x860F,
	14270: 0x8610,
	14271: 0x8612,
	14272: 0x8613,
	14273: 0x8614,
	14274: 0x8615,
	14275: 0x8617,
	14276: 0x8618,
	14277: 0x8619,
	14278: 0x861A,
	14279: 0x861B,
	14280: 0x861C,
	14281: 0x861D,
	14282: 0x861E,
	14283: 0x861F,
	14284: 0x8620,
	14285: 0x8621,
	14286: 0x8622,
	14287: 0x8623,
	14288: 0x8624,
	14289: 0x8625,
	14290: 0x8626,
	14291: 0x8628,
	14292: 0x862A,
	14293: 0x862B,
	14294: 0x862C,
	14295: 0x862D,
	14296: 0x862E,
	14297: 0x862F,
	14298: 0x8630,
	14299: 0x8631,
	14300: 0x8632,
	14301: 0x8633,
	14302: 0x8634,
	14303: 0x8635,
	14304: 0x8636,
	14305: 0x8637,
	14306: 0x8639,
	14307: 0x863A,
	14308: 0x863B,
	14309: 0x863D,
	14310: 0x863E,
	14311: 0x863F,
	14312: 0x8640,
	14313: 0x8641,
	14314: 0x8642,
	14315: 0x8643,
	14316: 0x8644,
	14317: 0x8645,
	14318: 0x8646,
	14319: 0x8647,
	14320: 0x8648,
	14321: 0x8649,
	14322: 0x864A,
	14323: 0x864B,
	14324: 0x864C,
	14325: 0x8652,
	14326: 0x8653,
	14327: 0x8655,
	14328: 0x8656,
	14329: 0x8657,
	14330: 0x8658,
	14331: 0x8659,
	14332: 0x865B,
	14333: 0x865C,
	14334: 0x865D,
	14335: 0x865F,
	14336: 0x8660,
	14337: 0x8661,
	14338: 0x8663,
	14339: 0x8664,
	14340: 0x8665,
	14341: 0x8666,
	14342: 0x8667,
	14343: 0x8668,
	14344: 0x8669,
	14345: 0x866A,
	14346: 0x736D,
	14347: 0x631E,
	14348: 0x8E4B,
	14349: 0x8E0F,
	14350: 0x80CE,
	14351: 0x82D4,
	14352: 0x62AC,
	14353: 0x53F0,
	14354: 0x6CF0,
	14355: 0x915E,
	14356: 0x592A,
	14357: 0x6001,
	14358: 0x6C70,
	14359: 0x574D,
	14360: 0x644A,
	14361: 0x8D2A,
	14362: 0x762B,
	14363: 0x6EE9,
	14364: 0x575B,
	14365: 0x6A80,
	14366: 0x75F0,
	14367: 0x6F6D,
	14368: 0x8C2D,
	14369: 0x8C08,
	14370: 0x5766,
	14371: 0x6BEF,
	14372: 0x8892,
	14373: 0x78B3,
	14374: 0x63A2,
	14375: 0x53F9,
	14376: 0x70AD,
	14377: 0x6C64,
	14378: 0x5858,
	14379: 0x642A,
	14380: 0x5802,
	14381: 0x68E0,
	14382: 0x819B,
	14383: 0x5510,
	14384: 0x7CD6,
	14385: 0x5018,
	14386: 0x8EBA,
	14387: 0x6DCC,
	14388: 0x8D9F,
	14389: 0x70EB,
	14390: 0x638F,
	14391: 0x6D9B,
	14392: 0x6ED4,
	14393: 0x7EE6,
	14394: 0x8404,
	14395: 0x6843,
	14396: 0x9003,
	14397: 0x6DD8,
	14398: 0x9676,
	14399: 0x8BA8,
	14400: 0x5957,
	14401: 0x7279,
	14402: 0x85E4,
	14403: 0x817E,
	14404: 0x75BC,
	14405: 0x8A8A,
	14406: 0x68AF,
	14407: 0x5254,
	14408: 0x8E22,
	14409: 0x9511,
	14410: 0x63D0,
	14411: 0x9898,
	14412: 0x8E44,
	14413: 0x557C,
	14414: 0x4F53,
	14415: 0x66FF,
	14416: 0x568F,
	14417: 0x60D5,
	14418: 0x6D95,
	14419: 0x5243,
	14420: 0x5C49,
	14421: 0x5929,
	14422: 0x6DFB,
	14423: 0x586B,
	14424: 0x7530,
	14425: 0x751C,
	14426: 0x606C,
	14427: 0x8214,
	14428: 0x8146,
	14429: 0x6311,
	14430: 0x6761,
	14431: 0x8FE2,
	14432: 0x773A,
	14433: 0x8DF3,
	14434: 0x8D34,
	14435: 0x94C1,
	14436: 0x5E16,
	14437: 0x5385,
	14438: 0x542C,
	14439: 0x70C3,
	14440: 0x866D,
	14441: 0x866F,
	14442: 0x8670,
	14443: 0x8672,
	14444: 0x8673,
	14445: 0x8674,
	14446: 0x8675,
	14447: 0x8676,
	14448: 0x8677,
	14449: 0x8678,
	14450: 0x8683,
	14451: 0x8684,
	14452: 0x8685,
	14453: 0x8686,
	14454: 0x8687,
	14455: 0x8688,
	14456: 0x8689,
	14457: 0x868E,
	14458: 0x868F,
	14459: 0x8690,
	14460: 0x8691,
	14461: 0x8692,
	14462: 0x8694,
	14463: 0x8696,
	14464: 0x8697,
	14465: 0x8698,
	14466: 0x8699,
	14467: 0x869A,
	14468: 0x869B,
	14469: 0x869E,
	14470: 0x869F,
	14471: 0x86A0,
	14472: 0x86A1,
	14473: 0x86A2,
	14474: 0x86A5,
	14475: 0x86A6,
	14476: 0x86AB,
	14477: 0x86AD,
	14478: 0x86AE,
	14479: 0x86B2,
	14480: 0x86B3,
	14481: 0x86B7,
	14482: 0x86B8,
	14483: 0x86B9,
	14484: 0x86BB,
	14485: 0x86BC,
	14486: 0x86BD,
	14487: 0x86BE,
	14488: 0x86BF,
	14489: 0x86C1,
	14490: 0x86C2,
	14491: 0x86C3,
	14492: 0x86C5,
	14493: 0x86C8,
	14494: 0x86CC,
	14495: 0x86CD,
	14496: 0x86D2,
	14497: 0x86D3,
	14498: 0x86D5,
	14499: 0x86D6,
	14500: 0x86D7,
	14501: 0x86DA,
	14502: 0x86DC,
	14503: 0x86DD,
	14504: 0x86E0,
	14505: 0x86E1,
	14506: 0x86E2,
	14507: 0x86E3,
	14508: 0x86E5,
	14509: 0x86E6,
	14510: 0x86E7,
	14511: 0x86E8,
	14512: 0x86EA,
	14513: 0x86EB,
	14514: 0x86EC,
	14515: 0x86EF,
	14516: 0x86F5,
	14517: 0x86F6,
	14518: 0x86F7,
	14519: 0x86FA,
	14520: 0x86FB,
	14521: 0x86FC,
	14522: 0x86FD,
	14523: 0x86FF,
	14524: 0x8701,
	14525: 0x8704,
	14526: 0x8705,
	14527: 0x8706,
	14528: 0x870B,
	14529: 0x870C,
	14530: 0x870E,
	14531: 0x870F,
	14532: 0x8710,
	14533: 0x8711,
	14534: 0x8714,
	14535: 0x8716,
	14536: 0x6C40,
	14537: 0x5EF7,
	14538: 0x505C,
	14539: 0x4EAD,
	14540: 0x5EAD,
	14541: 0x633A,
	14542: 0x8247,
	14543: 0x901A,
	14544: 0x6850,
	14545: 0x916E,
	14546: 0x77B3,
	14547: 0x540C,
	14548: 0x94DC,
	14549: 0x5F64,
	14550: 0x7AE5,
	14551: 0x6876,
	14552: 0x6345,
	14553: 0x7B52,
	14554: 0x7EDF,
	14555: 0x75DB,
	14556: 0x5077,
	14557: 0x6295,
	14558: 0x5934,
	14559: 0x900F,
	14560: 0x51F8,
	14561: 0x79C3,
	14562: 0x7A81,
	14563: 0x56FE,
	14564: 0x5F92,
	14565: 0x9014,
	14566: 0x6D82,
	14567: 0x5C60,
	14568: 0x571F,
	14569: 0x5410,
	14570: 0x5154,
	14571: 0x6E4D,
	14572: 0x56E2,
	14573: 0x63A8,
	14574: 0x9893,
	14575: 0x817F,
	14576: 0x8715,
	14577: 0x892A,
	14578: 0x9000,
	14579: 0x541E,
	14580: 0x5C6F,
	14581: 0x81C0,
	14582: 0x62D6,
	14583: 0x6258,
	14584: 0x8131,
	14585: 0x9E35,
	14586: 0x9640,
	14587: 0x9A6E,
	14588: 0x9A7C,
	14589: 0x692D,
	14590: 0x59A5,
	14591: 0x62D3,
	14592: 0x553E,
	14593: 0x6316,
	14594: 0x54C7,
	14595: 0x86D9,
	14596: 0x6D3C,
	14597: 0x5A03,
	14598: 0x74E6,
	14599: 0x889C,
	14600: 0x6B6A,
	14601: 0x5916,
	14602: 0x8C4C,
	14603: 0x5F2F,
	14604: 0x6E7E,
	14605: 0x73A9,
	14606: 0x987D,
	14607: 0x4E38,
	14608: 0x70F7,
	14609: 0x5B8C,
	14610: 0x7897,
	14611: 0x633D,
	14612: 0x665A,
	14613: 0x7696,
	14614: 0x60CB,
	14615: 0x5B9B,
	14616: 0x5A49,
	14617: 0x4E07,
	14618: 0x8155,
	14619: 0x6C6A,
	14620: 0x738B,
	14621: 0x4EA1,
	14622: 0x6789,
	14623: 0x7F51,
	14624: 0x5F80,
	14625: 0x65FA,
	14626: 0x671B,
	14627: 0x5FD8,
	14628: 0x5984,
	14629: 0x5A01,
	14630: 0x8719,
	14631: 0x871B,
	14632: 0x871D,
	14633: 0x871F,
	14634: 0x8720,
	14635: 0x8724,
	14636: 0x8726,
	14637: 0x8727,
	14638: 0x8728,
	14639: 0x872A,
	14640: 0x872B,
	14641: 0x872C,
	14642: 0x872D,
	14643: 0x872F,
	14644: 0x8730,
	14645: 0x8732,
	14646: 0x8733,
	14647: 0x8735,
	14648: 0x8736,
	14649: 0x8738,
	14650: 0x8739,
	14651: 0x873A,
	14652: 0x873C,
	14653: 0x873D,
	14654: 0x8740,
	14655: 0x8741,
	14656: 0x8742,
	14657: 0x8743,
	14658: 0x8744,
	14659: 0x8745,
	14660: 0x8746,
	14661: 0x874A,
	14662: 0x874B,
	14663: 0x874D,
	14664: 0x874F,
	14665: 0x8750,
	14666: 0x8751,
	14667: 0x8752,
	14668: 0x8754,
	14669: 0x8755,
	14670: 0x8756,
	14671: 0x8758,
	14672: 0x875A,
	14673: 0x875B,
	14674: 0x875C,
	14675: 0x875D,
	14676: 0x875E,
	14677: 0x875F,
	14678: 0x8761,
	14679: 0x8762,
	14680: 0x8766,
	14681: 0x8767,
	14682: 0x8768,
	14683: 0x8769,
	14684: 0x876A,
	14685: 0x876B,
	14686: 0x876C,
	14687: 0x876D,
	14688: 0x876F,
	14689: 0x8771,
	14690: 0x8772,
	14691: 0x8773,
	14692: 0x8775,
	14693: 0x8777,
	14694: 0x8778,
	14695: 0x8779,
	14696: 0x877A,
	14697: 0x877F,
	14698: 0x8780,
	14699: 0x8781,
	14700: 0x8784,
	14701: 0x8786,
	14702: 0x8787,
	14703: 0x8789,
	14704: 0x878A,
	14705: 0x878C,
	14706: 0x878E,
	14707: 0x878F,
	14708: 0x8790,
	14709: 0x8791,
	14710: 0x8792,
	14711: 0x8794,
	14712: 0x8795,
	14713: 0x8796,
	14714: 0x8798,
	14715: 0x8799,
	14716: 0x879A,
	14717: 0x879B,
	14718: 0x879C,
	14719: 0x879D,
	14720: 0x879E,
	14721: 0x87A0,
	14722: 0x87A1,
	14723: 0x87A2,
	14724: 0x87A3,
	14725: 0x87A4,
	14726: 0x5DCD,
	14727: 0x5FAE,
	14728: 0x5371,
	14729: 0x97E6,
	14730: 0x8FDD,
	14731: 0x6845,
	14732: 0x56F4,
	14733: 0x552F,
	14734: 0x60DF,
	14735: 0x4E3A,
	14736: 0x6F4D,
	14737: 0x7EF4,
	14738: 0x82C7,
	14739: 0x840E,
	14740: 0x59D4,
	14741: 0x4F1F,
	14742: 0x4F2A,
	14743: 0x5C3E,
	14744: 0x7EAC,
	14745: 0x672A,
	14746: 0x851A,
	14747: 0x5473,
	14748: 0x754F,
	14749: 0x80C3,
	14750: 0x5582,
	14751: 0x9B4F,
	14752: 0x4F4D,
	14753: 0x6E2D,
	14754: 0x8C13,
	14755: 0x5C09,
	14756: 0x6170,
	14757: 0x536B,
	14758: 0x761F,
	14759: 0x6E29,
	14760: 0x868A,
	14761: 0x6587,
	14762: 0x95FB,
	14763: 0x7EB9,
	14764: 0x543B,
	14765: 0x7A33,
	14766: 0x7D0A,
	14767: 0x95EE,
	14768: 0x55E1,
	14769: 0x7FC1,
	14770: 0x74EE,
	14771: 0x631D,
	14772: 0x8717,
	14773: 0x6DA1,
	14774: 0x7A9D,
	14775: 0x6211,
	14776: 0x65A1,
	14777: 0x5367,
	14778: 0x63E1,
	14779: 0x6C83,
	14780: 0x5DEB,
	14781: 0x545C,
	14782: 0x94A8,
	14783: 0x4E4C,
	14784: 0x6C61,
	14785: 0x8BEC,
	14786: 0x5C4B,
	14787: 0x65E0,
	14788: 0x829C,
	14789: 0x68A7,
	14790: 0x543E,
	14791: 0x5434,
	14792: 0x6BCB,
	14793: 0x6B66,
	14794: 0x4E94,
	14795: 0x6342,
	14796: 0x5348,
	14797: 0x821E,
	14798: 0x4F0D,
	14799: 0x4FAE,
	14800: 0x575E,
	14801: 0x620A,
	14802: 0x96FE,
	14803: 0x6664,
	14804: 0x7269,
	14805: 0x52FF,
	14806: 0x52A1,
	14807: 0x609F,
	14808: 0x8BEF,
	14809: 0x6614,
	14810: 0x7199,
	14811: 0x6790,
	14812: 0x897F,
	14813: 0x7852,
	14814: 0x77FD,
	14815: 0x6670,
	14816: 0x563B,
	14817: 0x5438,
	14818: 0x9521,
	14819: 0x727A,
	14820: 0x87A5,
	14821: 0x87A6,
	14822: 0x87A7,
	14823: 0x87A9,
	14824: 0x87AA,
	14825: 0x87AE,
	14826: 0x87B0,
	14827: 0x87B1,
	14828: 0x87B2,
	14829: 0x87B4,
	14830: 0x87B6,
	14831: 0x87B7,
	14832: 0x87B8,
	14833: 0x87B9,
	14834: 0x87BB,
	14835: 0x87BC,
	14836: 0x87BE,
	14837: 0x87BF,
	14838: 0x87C1,
	14839: 0x87C2,
	14840: 0x87C3,
	14841: 0x87C4,
	14842: 0x87C5,
	14843: 0x87C7,
	14844: 0x87C8,
	14845: 0x87C9,
	14846: 0x87CC,
	14847: 0x87CD,
	14848: 0x87CE,
	14849: 0x87CF,
	14850: 0x87D0,
	14851: 0x87D4,
	14852: 0x87D5,
	14853: 0x87D6,
	14854: 0x87D7,
	14855: 0x87D8,
	14856: 0x87D9,
	14857: 0x87DA,
	14858: 0x87DC,
	14859: 0x87DD,
	14860: 0x87DE,
	14861: 0x87DF,
	14862: 0x87E1,
	14863: 0x87E2,
	14864: 0x87E3,
	14865: 0x87E4,
	14866: 0x87E6,
	14867: 0x87E7,
	14868: 0x87E8,
	14869: 0x87E9,
	14870: 0x87EB,
	14871: 0x87EC,
	14872: 0x87ED,
	14873: 0x87EF,
	14874: 0x87F0,
	14875: 0x87F1,
	14876: 0x87F2,
	14877: 0x87F3,
	14878: 0x87F4,
	14879: 0x87F5,
	14880: 0x87F6,
	14881: 0x87F7,
	14882: 0x87F8,
	14883: 0x87FA,
	14884: 0x87FB,
	14885: 0x87FC,
	14886: 0x87FD,
	14887: 0x87FF,
	14888: 0x8800,
	14889: 0x8801,
	14890: 0x8802,
	14891: 0x8804,
	14892: 0x8805,
	14893: 0x8806,
	14894: 0x8807,
	14895: 0x8808,
	14896: 0x8809,
	14897: 0x880B,
	14898: 0x880C,
	14899: 0x880D,
	14900: 0x880E,
	14901: 0x880F,
	14902: 0x8810,
	14903: 0x8811,
	14904: 0x8812,
	14905: 0x8814,
	14906: 0x8817,
	14907: 0x8818,
	14908: 0x8819,
	14909: 0x881A,
	14910: 0x881C,
	14911: 0x881D,
	14912: 0x881E,
	14913: 0x881F,
	14914: 0x8820,
	14915: 0x8823,
	14916: 0x7A00,
	14917: 0x606F,
	14918: 0x5E0C,
	14919: 0x6089,
	14920: 0x819D,
	14921: 0x5915,
	14922: 0x60DC,
	14923: 0x7184,
	14924: 0x70EF,
	14925: 0x6EAA,
	14926: 0x6C50,
	14927: 0x7280,
	14928: 0x6A84,
	14929: 0x88AD,
	14930: 0x5E2D,
	14931: 0x4E60,
	14932: 0x5AB3,
	14933: 0x559C,
	14934: 0x94E3,
	14935: 0x6D17,
	14936: 0x7CFB,
	14937: 0x9699,
	14938: 0x620F,
	14939: 0x7EC6,
	14940: 0x778E,
	14941: 0x867E,
	14942: 0x5323,
	14943: 0x971E,
	14944: 0x8F96,
	14945: 0x6687,
	14946: 0x5CE1,
	14947: 0x4FA0,
	14948: 0x72ED,
	14949: 0x4E0B,
	14950: 0x53A6,
	14951: 0x590F,
	14952: 0x5413,
	14953: 0x6380,
	14954: 0x9528,
	14955: 0x5148,
	14956: 0x4ED9,
	14957: 0x9C9C,
	14958: 0x7EA4,
	14959: 0x54B8,
	14960: 0x8D24,
	14961: 0x8854,
	14962: 0x8237,
	14963: 0x95F2,
	14964: 0x6D8E,
	14965: 0x5F26,
	14966: 0x5ACC,
	14967: 0x663E,
	14968: 0x9669,
	14969: 0x73B0,
	14970: 0x732E,
	14971: 0x53BF,
	14972: 0x817A,
	14973: 0x9985,
	14974: 0x7FA1,
	14975: 0x5BAA,
	14976: 0x9677,
	14977: 0x9650,
	14978: 0x7EBF,
	14979: 0x76F8,
	14980: 0x53A2,
	14981: 0x9576,
	14982: 0x9999,
	14983: 0x7BB1,
	14984: 0x8944,
	14985: 0x6E58,
	14986: 0x4E61,
	14987: 0x7FD4,
	14988: 0x7965,
	14989: 0x8BE6,
	14990: 0x60F3,
	14991: 0x54CD,
	14992: 0x4EAB,
	14993: 0x9879,
	14994: 0x5DF7,
	14995: 0x6A61,
	14996: 0x50CF,
	14997: 0x5411,
	14998: 0x8C61,
	14999: 0x8427,
	15000: 0x785D,
	15001: 0x9704,
	15002: 0x524A,
	15003: 0x54EE,
	15004: 0x56A3,
	15005: 0x9500,
	15006: 0x6D88,
	15007: 0x5BB5,
	15008: 0x6DC6,
	15009: 0x6653,
	15010: 0x8824,
	15011: 0x8825,
	15012: 0x8826,
	15013: 0x8827,
	15014: 0x8828,
	15015: 0x8829,
	15016: 0x882A,
	15017: 0x882B,
	15018: 0x882C,
	15019: 0x882D,
	15020: 0x882E,
	15021: 0x882F,
	15022: 0x8830,
	15023: 0x8831,
	15024: 0x8833,
	15025: 0x8834,
	15026: 0x8835,
	15027: 0x8836,
	15028: 0x8837,
	15029: 0x8838,
	15030: 0x883A,
	15031: 0x883B,
	15032: 0x883D,
	15033: 0x883E,
	15034: 0x883F,
	15035: 0x8841,
	15036: 0x8842,
	15037: 0x8843,
	15038: 0x8846,
	15039: 0x8847,
	15040: 0x8848,
	15041: 0x8849,
	15042: 0x884A,
	15043: 0x884B,
	15044: 0x884E,
	15045: 0x884F,
	15046: 0x8850,
	15047: 0x8851,
	15048: 0x8852,
	15049: 0x8853,
	15050: 0x8855,
	15051: 0x8856,
	15052: 0x8858,
	15053: 0x885A,
	15054: 0x885B,
	15055: 0x885C,
	15056: 0x885D,
	15057: 0x885E,
	15058: 0x885F,
	15059: 0x8860,
	15060: 0x8866,
	15061: 0x8867,
	15062: 0x886A,
	15063: 0x886D,
	15064: 0x886F,
	15065: 0x8871,
	15066: 0x8873,
	15067: 0x8874,
	15068: 0x8875,
	15069: 0x8876,
	15070: 0x8878,
	15071: 0x8879,
	15072: 0x887A,
	15073: 0x887B,
	15074: 0x887C,
	15075: 0x8880,
	15076: 0x8883,
	15077: 0x8886,
	15078: 0x8887,
	15079: 0x8889,
	15080: 0x888A,
	15081: 0x888C,
	15082: 0x888E,
	15083: 0x888F,
	15084: 0x8890,
	15085: 0x8891,
	15086: 0x8893,
	15087: 0x8894,
	15088: 0x8895,
	15089: 0x8897,
	15090: 0x8898,
	15091: 0x8899,
	15092: 0x889A,
	15093: 0x889B,
	15094: 0x889D,
	15095: 0x889E,
	15096: 0x889F,
	15097: 0x88A0,
	15098: 0x88A1,
	15099: 0x88A3,
	15100: 0x88A5,
	15101: 0x88A6,
	15102: 0x88A7,
	15103: 0x88A8,
	15104: 0x88A9,
	15105: 0x88AA,
	15106: 0x5C0F,
	15107: 0x5B5D,
	15108: 0x6821,
	15109: 0x8096,
	15110: 0x5578,
	15111: 0x7B11,
	15112: 0x6548,
	15113: 0x6954,
	15114: 0x4E9B,
	15115: 0x6B47,
	15116: 0x874E,
	15117: 0x978B,
	15118: 0x534F,
	15119: 0x631F,
	15120: 0x643A,
	15121: 0x90AA,
	15122: 0x659C,
	15123: 0x80C1,
	15124: 0x8C10,
	15125: 0x5199,
	15126: 0x68B0,
	15127: 0x5378,
	15128: 0x87F9,
	15129: 0x61C8,
	15130: 0x6CC4,
	15131: 0x6CFB,
	15132: 0x8C22,
	15133: 0x5C51,
	15134: 0x85AA,
	15135: 0x82AF,
	15136: 0x950C,
	15137: 0x6B23,
	15138: 0x8F9B,
	15139: 0x65B0,
	15140: 0x5FFB,
	15141: 0x5FC3,
	15142: 0x4FE1,
	15143: 0x8845,
	15144: 0x661F,
	15145: 0x8165,
	15146: 0x7329,
	15147: 0x60FA,
	15148: 0x5174,
	15149: 0x5211,
	15150: 0x578B,
	15151: 0x5F62,
	15152: 0x90A2,
	15153: 0x884C,
	15154: 0x9192,
	15155: 0x5E78,
	15156: 0x674F,
	15157: 0x6027,
	15158: 0x59D3,
	15159: 0x5144,
	15160: 0x51F6,
	15161: 0x80F8,
	15162: 0x5308,
	15163: 0x6C79,
	15164: 0x96C4,
	15165: 0x718A,
	15166: 0x4F11,
	15167: 0x4FEE,
	15168: 0x7F9E,
	15169: 0x673D,
	15170: 0x55C5,
	15171: 0x9508,
	15172: 0x79C0,
	15173: 0x8896,
	15174: 0x7EE3,
	15175: 0x589F,
	15176: 0x620C,
	15177: 0x9700,
	15178: 0x865A,
	15179: 0x5618,
	15180: 0x987B,
	15181: 0x5F90,
	15182: 0x8BB8,
	15183: 0x84C4,
	15184: 0x9157,
	15185: 0x53D9,
	15186: 0x65ED,
	15187: 0x5E8F,
	15188: 0x755C,
	15189: 0x6064,
	15190: 0x7D6E,
	15191: 0x5A7F,
	15192: 0x7EEA,
	15193: 0x7EED,
	15194: 0x8F69,
	15195: 0x55A7,
	15196: 0x5BA3,
	15197: 0x60AC,
	15198: 0x65CB,
	15199: 0x7384,
	15200: 0x88AC,
	15201: 0x88AE,
	15202: 0x88AF,
	15203: 0x88B0,
	15204: 0x88B2,
	15205: 0x88B3,
	15206: 0x88B4,
	15207: 0x88B5,
	15208: 0x88B6,
	15209: 0x88B8,
	15210: 0x88B9,
	15211: 0x88BA,
	15212: 0x88BB,
	15213: 0x88BD,
	15214: 0x88BE,
	15215: 0x88BF,
	15216: 0x88C0,
	15217: 0x88C3,
	15218: 0x88C4,
	15219: 0x88C7,
	15220: 0x88C8,
	15221: 0x88CA,
	15222: 0x88CB,
	15223: 0x88CC,
	15224: 0x88CD,
	15225: 0x88CF,
	15226: 0x88D0,
	15227: 0x88D1,
	15228: 0x88D3,
	15229: 0x88D6,
	15230: 0x88D7,
	15231: 0x88DA,
	15232: 0x88DB,
	15233: 0x88DC,
	15234: 0x88DD,
	15235: 0x88DE,
	15236: 0x88E0,
	15237: 0x88E1,
	15238: 0x88E6,
	15239: 0x88E7,
	15240: 0x88E9,
	15241: 0x88EA,
	15242: 0x88EB,
	15243: 0x88EC,
	15244: 0x88ED,
	15245: 0x88EE,
	15246: 0x88EF,
	15247: 0x88F2,
	15248: 0x88F5,
	15249: 0x88F6,
	15250: 0x88F7,
	15251: 0x88FA,
	15252: 0x88FB,
	15253: 0x88FD,
	15254: 0x88FF,
	15255: 0x8900,
	15256: 0x8901,
	15257: 0x8903,
	15258: 0x8904,
	15259: 0x8905,
	15260: 0x8906,
	15261: 0x8907,
	15262: 0x8908,
	15263: 0x8909,
	15264: 0x890B,
	15265: 0x890C,
	15266: 0x890D,
	15267: 0x890E,
	15268: 0x890F,
	15269: 0x8911,
	15270: 0x8914,
	15271: 0x8915,
	15272: 0x8916,
	15273: 0x8917,
	15274: 0x8918,
	15275: 0x891C,
	15276: 0x891D,
	15277: 0x891E,
	15278: 0x891F,
	15279: 0x8920,
	15280: 0x8922,
	15281: 0x8923,
	15282: 0x8924,
	15283: 0x8926,
	15284: 0x8927,
	15285: 0x8928,
	15286: 0x8929,
	15287: 0x892C,
	15288: 0x892D,
	15289: 0x892E,
	15290: 0x892F,
	15291: 0x8931,
	15292: 0x8932,
	15293: 0x8933,
	15294: 0x8935,
	15295: 0x8937,
	15296: 0x9009,
	15297: 0x7663,
	15298: 0x7729,
	15299: 0x7EDA,
	15300: 0x9774,
	15301: 0x859B,
	15302: 0x5B66,
	15303: 0x7A74,
	15304: 0x96EA,
	15305: 0x8840,
	15306: 0x52CB,
	15307: 0x718F,
	15308: 0x5FAA,
	15309: 0x65EC,
	15310: 0x8BE2,
	15311: 0x5BFB,
	15312: 0x9A6F,
	15313: 0x5DE1,
	15314: 0x6B89,
	15315: 0x6C5B,
	15316: 0x8BAD,
	15317: 0x8BAF,
	15318: 0x900A,
	15319: 0x8FC5,
	15320: 0x538B,
	15321: 0x62BC,
	15322: 0x9E26,
	15323: 0x9E2D,
	15324: 0x5440,
	15325: 0x4E2B,
	15326: 0x82BD,
	15327: 0x7259,
	15328: 0x869C,
	15329: 0x5D16,
	15330: 0x8859,
	15331: 0x6DAF,
	15332: 0x96C5,
	15333: 0x54D1,
	15334: 0x4E9A,
	15335: 0x8BB6,
	15336: 0x7109,
	15337: 0x54BD,
	15338: 0x9609,
	15339: 0x70DF,
	15340: 0x6DF9,
	15341: 0x76D0,
	15342: 0x4E25,
	15343: 0x7814,
	15344: 0x8712,
	15345: 0x5CA9,
	15346: 0x5EF6,
	15347: 0x8A00,
	15348: 0x989C,
	15349: 0x960E,
	15350: 0x708E,
	15351: 0x6CBF,
	15352: 0x5944,
	15353: 0x63A9,
	15354: 0x773C,
	15355: 0x884D,
	15356: 0x6F14,
	15357: 0x8273,
	15358: 0x5830,
	15359: 0x71D5,
	15360: 0x538C,
	15361: 0x781A,
	15362: 0x96C1,
	15363: 0x5501,
	15364: 0x5F66,
	15365: 0x7130,
	15366: 0x5BB4,
	15367: 0x8C1A,
	15368: 0x9A8C,
	15369: 0x6B83,
	15370: 0x592E,
	15371: 0x9E2F,
	15372: 0x79E7,
	15373: 0x6768,
	15374: 0x626C,
	15375: 0x4F6F,
	15376: 0x75A1,
	15377: 0x7F8A,
	15378: 0x6D0B,
	15379: 0x9633,
	15380: 0x6C27,
	15381: 0x4EF0,
	15382: 0x75D2,
	15383: 0x517B,
	15384: 0x6837,
	15385: 0x6F3E,
	15386: 0x9080,
	15387: 0x8170,
	15388: 0x5996,
	15389: 0x7476,
	15390: 0x8938,
	15391: 0x8939,
	15392: 0x893A,
	15393: 0x893B,
	15394: 0x893C,
	15395: 0x893D,
	15396: 0x893E,
	15397: 0x893F,
	15398: 0x8940,
	15399: 0x8942,
	15400: 0x8943,
	15401: 0x8945,
	15402: 0x8946,
	15403: 0x8947,
	15404: 0x8948,
	15405: 0x8949,
	15406: 0x894A,
	15407: 0x894B,
	15408: 0x894C,
	15409: 0x894D,
	15410: 0x894E,
	15411: 0x894F,
	15412: 0x8950,
	15413: 0x8951,
	15414: 0x8952,
	15415: 0x8953,
	15416: 0x8954,
	15417: 0x8955,
	15418: 0x8956,
	15419: 0x8957,
	15420: 0x8958,
	15421: 0x8959,
	15422: 0x895A,
	15423: 0x895B,
	15424: 0x895C,
	15425: 0x895D,
	15426: 0x8960,
	15427: 0x8961,
	15428: 0x8962,
	15429: 0x8963,
	15430: 0x8964,
	15431: 0x8965,
	15432: 0x8967,
	15433: 0x8968,
	15434: 0x8969,
	15435: 0x896A,
	15436: 0x896B,
	15437: 0x896C,
	15438: 0x896D,
	15439: 0x896E,
	15440: 0x896F,
	15441: 0x8970,
	15442: 0x8971,
	15443: 0x8972,
	15444: 0x8973,
	15445: 0x8974,
	15446: 0x8975,
	15447: 0x8976,
	15448: 0x8977,
	15449: 0x8978,
	15450: 0x8979,
	15451: 0x897A,
	15452: 0x897C,
	15453: 0x897D,
	15454: 0x897E,
	15455: 0x8980,
	15456: 0x8982,
	15457: 0x8984,
	15458: 0x8985,
	15459: 0x8987,
	15460: 0x8988,
	15461: 0x8989,
	15462: 0x898A,
	15463: 0x898B,
	15464: 0x898C,
	15465: 0x898D,
	15466: 0x898E,
	15467: 0x898F,
	15468: 0x8990,
	15469: 0x8991,
	15470: 0x8992,
	15471: 0x8993,
	15472: 0x8994,
	15473: 0x8995,
	15474: 0x8996,
	15475: 0x8997,
	15476: 0x8998,
	15477: 0x8999,
	15478: 0x899A,
	15479: 0x899B,
	15480: 0x899C,
	15481: 0x899D,
	15482: 0x899E,
	15483: 0x899F,
	15484: 0x89A0,
	15485: 0x89A1,
	15486: 0x6447,
	15487: 0x5C27,
	15488: 0x9065,
	15489: 0x7A91,
	15490: 0x8C23,
	15491: 0x59DA,
	15492: 0x54AC,
	15493: 0x8200,
	15494: 0x836F,
	15495: 0x8981,
	15496: 0x8000,
	15497: 0x6930,
	15498: 0x564E,
	15499: 0x8036,
	15500: 0x7237,
	15501: 0x91CE,
	15502: 0x51B6,
	15503: 0x4E5F,
	15504: 0x9875,
	15505: 0x6396,
	15506: 0x4E1A,
	15507: 0x53F6,
	15508: 0x66F3,
	15509: 0x814B,
	15510: 0x591C,
	15511: 0x6DB2,
	15512: 0x4E00,
	15513: 0x58F9,
	15514: 0x533B,
	15515: 0x63D6,
	15516: 0x94F1,
	15517: 0x4F9D,
	15518: 0x4F0A,
	15519: 0x8863,
	15520: 0x9890,
	15521: 0x5937,
	15522: 0x9057,
	15523: 0x79FB,
	15524: 0x4EEA,
	15525: 0x80F0,
	15526: 0x7591,
	15527: 0x6C82,
	15528: 0x5B9C,
	15529: 0x59E8,
	15530: 0x5F5D,
	15531: 0x6905,
	15532: 0x8681,
	15533: 0x501A,
	15534: 0x5DF2,
	15535: 0x4E59,
	15536: 0x77E3,
	15537: 0x4EE5,
	15538: 0x827A,
	15539: 0x6291,
	15540: 0x6613,
	15541: 0x9091,
	15542: 0x5C79,
	15543: 0x4EBF,
	15544: 0x5F79,
	15545: 0x81C6,
	15546: 0x9038,
	15547: 0x8084,
	15548: 0x75AB,
	15549: 0x4EA6,
	15550: 0x88D4,
	15551: 0x610F,
	15552: 0x6BC5,
	15553: 0x5FC6,
	15554: 0x4E49,
	15555: 0x76CA,
	15556: 0x6EA2,
	15557: 0x8BE3,
	15558: 0x8BAE,
	15559: 0x8C0A,
	15560: 0x8BD1,
	15561: 0x5F02,
	15562: 0x7FFC,
	15563: 0x7FCC,
	15564: 0x7ECE,
	15565: 0x8335,
	15566: 0x836B,
	15567: 0x56E0,
	15568: 0x6BB7,
	15569: 0x97F3,
	15570: 0x9634,
	15571: 0x59FB,
	15572: 0x541F,
	15573: 0x94F6,
	15574: 0x6DEB,
	15575: 0x5BC5,
	15576: 0x996E,
	15577: 0x5C39,
	15578: 0x5F15,
	15579: 0x9690,
	15580: 0x89A2,
	15581: 0x89A3,
	15582: 0x89A4,
	15583: 0x89A5,
	15584: 0x89A6,
	15585: 0x89A7,
	15586: 0x89A8,
	15587: 0x89A9,
	15588: 0x89AA,
	15589: 0x89AB,
	15590: 0x89AC,
	15591: 0x89AD,
	15592: 0x89AE,
	15593: 0x89AF,
	15594: 0x89B0,
	15595: 0x89B1,
	15596: 0x89B2,
	15597: 0x89B3,
	15598: 0x89B4,
	15599: 0x89B5,
	15600: 0x89B6,
	15601: 0x89B7,
	15602: 0x89B8,
	15603: 0x89B9,
	15604: 0x89BA,
	15605: 0x89BB,
	15606: 0x89BC,
	15607: 0x89BD,
	15608: 0x89BE,
	15609: 0x89BF,
	15610: 0x89C0,
	15611: 0x89C3,
	15612: 0x89CD,
	15613: 0x89D3,
	15614: 0x89D4,
	15615: 0x89D5,
	15616: 0x89D7,
	15617: 0x89D8,
	15618: 0x89D9,
	15619: 0x89DB,
	15620: 0x89DD,
	15621: 0x89DF,
	15622: 0x89E0,
	15623: 0x89E1,
	15624: 0x89E2,
	15625: 0x89E4,
	15626: 0x89E7,
	15627: 0x89E8,
	15628: 0x89E9,
	15629: 0x89EA,
	15630: 0x89EC,
	15631: 0x89ED,
	15632: 0x89EE,
	15633: 0x89F0,
	15634: 0x89F1,
	15635: 0x89F2,
	15636: 0x89F4,
	15637: 0x89F5,
	15638: 0x89F6,
	15639: 0x89F7,
	15640: 0x89F8,
	15641: 0x89F9,
	15642: 0x89FA,
	15643: 0x89FB,
	15644: 0x89FC,
	15645: 0x89FD,
	15646: 0x89FE,
	15647: 0x89FF,
	15648: 0x8A01,
	15649: 0x8A02,
	15650: 0x8A03,
	15651: 0x8A04,
	15652: 0x8A05,
	15653: 0x8A06,
	15654: 0x8A08,
	15655: 0x8A09,
	15656: 0x8A0A,
	15657: 0x8A0B,
	15658: 0x8A0C,
	15659: 0x8A0D,
	15660: 0x8A0E,
	15661: 0x8A0F,
	15662: 0x8A10,
	15663: 0x8A11,
	15664: 0x8A12,
	15665: 0x8A13,
	15666: 0x8A14,
	15667: 0x8A15,
	15668: 0x8A16,
	15669: 0x8A17,
	15670: 0x8A18,
	15671: 0x8A19,
	15672: 0x8A1A,
	15673: 0x8A1B,
	15674: 0x8A1C,
	15675: 0x8A1D,
	15676: 0x5370,
	15677: 0x82F1,
	15678: 0x6A31,
	15679: 0x5A74,
	15680: 0x9E70,
	15681: 0x5E94,
	15682: 0x7F28,
	15683: 0x83B9,
	15684: 0x8424,
	15685: 0x8425,
	15686: 0x8367,
	15687: 0x8747,
	15688: 0x8FCE,
	15689: 0x8D62,
	15690: 0x76C8,
	15691: 0x5F71,
	15692: 0x9896,
	15693: 0x786C,
	15694: 0x6620,
	15695: 0x54DF,
	15696: 0x62E5,
	15697: 0x4F63,
	15698: 0x81C3,
	15699: 0x75C8,
	15700: 0x5EB8,
	15701: 0x96CD,
	15702: 0x8E0A,
	15703: 0x86F9,
	15704: 0x548F,
	15705: 0x6CF3,
	15706: 0x6D8C,
	15707: 0x6C38,
	15708: 0x607F,
	15709: 0x52C7,
	15710: 0x7528,
	15711: 0x5E7D,
	15712: 0x4F18,
	15713: 0x60A0,
	15714: 0x5FE7,
	15715: 0x5C24,
	15716: 0x7531,
	15717: 0x90AE,
	15718: 0x94C0,
	15719: 0x72B9,
	15720: 0x6CB9,
	15721: 0x6E38,
	15722: 0x9149,
	15723: 0x6709,
	15724: 0x53CB,
	15725: 0x53F3,
	15726: 0x4F51,
	15727: 0x91C9,
	15728: 0x8BF1,
	15729: 0x53C8,
	15730: 0x5E7C,
	15731: 0x8FC2,
	15732: 0x6DE4,
	15733: 0x4E8E,
	15734: 0x76C2,
	15735: 0x6986,
	15736: 0x865E,
	15737: 0x611A,
	15738: 0x8206,
	15739: 0x4F59,
	15740: 0x4FDE,
	15741: 0x903E,
	15742: 0x9C7C,
	15743: 0x6109,
	15744: 0x6E1D,
	15745: 0x6E14,
	15746: 0x9685,
	15747: 0x4E88,
	15748: 0x5A31,
	15749: 0x96E8,
	15750: 0x4E0E,
	15751: 0x5C7F,
	15752: 0x79B9,
	15753: 0x5B87,
	15754: 0x8BED,
	15755: 0x7FBD,
	15756: 0x7389,
	15757: 0x57DF,
	15758: 0x828B,
	15759: 0x90C1,
	15760: 0x5401,
	15761: 0x9047,
	15762: 0x55BB,
	15763: 0x5CEA,
	15764: 0x5FA1,
	15765: 0x6108,
	15766: 0x6B32,
	15767: 0x72F1,
	15768: 0x80B2,
	15769: 0x8A89,
	15770: 0x8A1E,
	15771: 0x8A1F,
	15772: 0x8A20,
	15773: 0x8A21,
	15774: 0x8A22,
	15775: 0x8A23,
	15776: 0x8A24,
	15777: 0x8A25,
	15778: 0x8A26,
	15779: 0x8A27,
	15780: 0x8A28,
	15781: 0x8A29,
	15782: 0x8A2A,
	15783: 0x8A2B,
	15784: 0x8A2C,
	15785: 0x8A2D,
	15786: 0x8A2E,
	15787: 0x8A2F,
	15788: 0x8A30,
	15789: 0x8A31,
	15790: 0x8A32,
	15791: 0x8A33,
	15792: 0x8A34,
	15793: 0x8A35,
	15794: 0x8A36,
	15795: 0x8A37,
	15796: 0x8A38,
	15797: 0x8A39,
	15798: 0x8A3A,
	15799: 0x8A3B,
	15800: 0x8A3C,
	15801: 0x8A3D,
	15802: 0x8A3F,
	15803: 0x8A40,
	15804: 0x8A41,
	15805: 0x8A42,
	15806: 0x8A43,
	15807: 0x8A44,
	15808: 0x8A45,
	15809: 0x8A46,
	15810: 0x8A47,
	15811: 0x8A49,
	15812: 0x8A4A,
	15813: 0x8A4B,
	15814: 0x8A4C,
	15815: 0x8A4D,
	15816: 0x8A4E,
	15817: 0x8A4F,
	15818: 0x8A50,
	15819: 0x8A51,
	15820: 0x8A52,
	15821: 0x8A53,
	15822: 0x8A54,
	15823: 0x8A55,
	15824: 0x8A56,
	15825: 0x8A57,
	15826: 0x8A58,
	15827: 0x8A59,
	15828: 0x8A5A,
	15829: 0x8A5B,
	15830: 0x8A5C,
	15831: 0x8A5D,
	15832: 0x8A5E,
	15833: 0x8A5F,
	15834: 0x8A60,
	15835: 0x8A61,
	15836: 0x8A62,
	15837: 0x8A63,
	15838: 0x8A64,
	15839: 0x8A65,
	15840: 0x8A66,
	15841: 0x8A67,
	15842: 0x8A68,
	15843: 0x8A69,
	15844: 0x8A6A,
	15845: 0x8A6B,
	15846: 0x8A6C,
	15847: 0x8A6D,
	15848: 0x8A6E,
	15849: 0x8A6F,
	15850: 0x8A70,
	15851: 0x8A71,
	15852: 0x8A72,
	15853: 0x8A73,
	15854: 0x8A74,
	15855: 0x8A75,
	15856: 0x8A76,
	15857: 0x8A77,
	15858: 0x8A78,
	15859: 0x8A7A,
	15860: 0x8A7B,
	15861: 0x8A7C,
	15862: 0x8A7D,
	15863: 0x8A7E,
	15864: 0x8A7F,
	15865: 0x8A80,
	15866: 0x6D74,
	15867: 0x5BD3,
	15868: 0x88D5,
	15869: 0x9884,
	15870: 0x8C6B,
	15871: 0x9A6D,
	15872: 0x9E33,
	15873: 0x6E0A,
	15874: 0x51A4,
	15875: 0x5143,
	15876: 0x57A3,
	15877: 0x8881,
	15878: 0x539F,
	15879: 0x63F4,
	15880: 0x8F95,
	15881: 0x56ED,
	15882: 0x5458,
	15883: 0x5706,
	15884: 0x733F,
	15885: 0x6E90,
	15886: 0x7F18,
	15887: 0x8FDC,
	15888: 0x82D1,
	15889: 0x613F,
	15890: 0x6028,
	15891: 0x9662,
	15892: 0x66F0,
	15893: 0x7EA6,
	15894: 0x8D8A,
	15895: 0x8DC3,
	15896: 0x94A5,
	15897: 0x5CB3,
	15898: 0x7CA4,
	15899: 0x6708,
	15900: 0x60A6,
	15901: 0x9605,
	15902: 0x8018,
	15903: 0x4E91,
	15904: 0x90E7,
	15905: 0x5300,
	15906: 0x9668,
	15907: 0x5141,
	15908: 0x8FD0,
	15909: 0x8574,
	15910: 0x915D,
	15911: 0x6655,
	15912: 0x97F5,
	15913: 0x5B55,
	15914: 0x531D,
	15915: 0x7838,
	15916: 0x6742,
	15917: 0x683D,
	15918: 0x54C9,
	15919: 0x707E,
	15920: 0x5BB0,
	15921: 0x8F7D,
	15922: 0x518D,
	15923: 0x5728,
	15924: 0x54B1,
	15925: 0x6512,
	15926: 0x6682,
	15927: 0x8D5E,
	15928: 0x8D43,
	15929: 0x810F,
	15930: 0x846C,
	15931: 0x906D,
	15932: 0x7CDF,
	15933: 0x51FF,
	15934: 0x85FB,
	15935: 0x67A3,
	15936: 0x65E9,
	15937: 0x6FA1,
	15938: 0x86A4,
	15939: 0x8E81,
	15940: 0x566A,
	15941: 0x9020,
	15942: 0x7682,
	15943: 0x7076,
	15944: 0x71E5,
	15945: 0x8D23,
	15946: 0x62E9,
	15947: 0x5219,
	15948: 0x6CFD,
	15949: 0x8D3C,
	15950: 0x600E,
	15951: 0x589E,
	15952: 0x618E,
	15953: 0x66FE,
	15954: 0x8D60,
	15955: 0x624E,
	15956: 0x55B3,
	15957: 0x6E23,
	15958: 0x672D,
	15959: 0x8F67,
	15960: 0x8A81,
	15961: 0x8A82,
	15962: 0x8A83,
	15963: 0x8A84,
	15964: 0x8A85,
	15965: 0x8A86,
	15966: 0x8A87,
	15967: 0x8A88,
	15968: 0x8A8B,
	15969: 0x8A8C,
	15970: 0x8A8D,
	15971: 0x8A8E,
	15972: 0x8A8F,
	15973: 0x8A90,
	15974: 0x8A91,
	15975: 0x8A92,
	15976: 0x8A94,
	15977: 0x8A95,
	15978: 0x8A96,
	15979: 0x8A97,
	15980: 0x8A98,
	15981: 0x8A99,
	15982: 0x8A9A,
	15983: 0x8A9B,
	15984: 0x8A9C,
	15985: 0x8A9D,
	15986: 0x8A9E,
	15987: 0x8A9F,
	15988: 0x8AA0,
	15989: 0x8AA1,
	15990: 0x8AA2,
	15991: 0x8AA3,
	15992: 0x8AA4,
	15993: 0x8AA5,
	15994: 0x8AA6,
	15995: 0x8AA7,
	15996: 0x8AA8,
	15997: 0x8AA9,
	15998: 0x8AAA,
	15999: 0x8AAB,
	16000: 0x8AAC,
	16001: 0x8AAD,
	16002: 0x8AAE,
	16003: 0x8AAF,
	16004: 0x8AB0,
	16005: 0x8AB1,
	16006: 0x8AB2,
	16007: 0x8AB3,
	16008: 0x8AB4,
	16009: 0x8AB5,
	16010: 0x8AB6,
	16011: 0x8AB7,
	16012: 0x8AB8,
	16013: 0x8AB9,
	16014: 0x8ABA,
	16015: 0x8ABB,
	16016: 0x8ABC,
	16017: 0x8ABD,
	16018: 0x8ABE,
	16019: 0x8ABF,
	16020: 0x8AC0,
	16021: 0x8AC1,
	16022: 0x8AC2,
	16023: 0x8AC3,
	16024: 0x8AC4,
	16025: 0x8AC5,
	16026: 0x8AC6,
	16027: 0x8AC7,
	16028: 0x8AC8,
	16029: 0x8AC9,
	16030: 0x8ACA,
	16031: 0x8ACB,
	16032: 0x8ACC,
	16033: 0x8ACD,
	16034: 0x8ACE,
	16035: 0x8ACF,
	16036: 0x8AD0,
	16037: 0x8AD1,
	16038: 0x8AD2,
	16039: 0x8AD3,
	16040: 0x8AD4,
	16041: 0x8AD5,
	16042: 0x8AD6,
	16043: 0x8AD7,
	16044: 0x8AD8,
	16045: 0x8AD9,
	16046: 0x8ADA,
	16047: 0x8ADB,
	16048: 0x8ADC,
	16049: 0x8ADD,
	16050: 0x8ADE,
	16051: 0x8ADF,
	16052: 0x8AE0,
	16053: 0x8AE1,
	16054: 0x8AE2,
	16055: 0x8AE3,
	16056: 0x94E1,
	16057: 0x95F8,
	16058: 0x7728,
	16059: 0x6805,
	16060: 0x69A8,
	16061: 0x548B,
	16062: 0x4E4D,
	16063: 0x70B8,
	16064: 0x8BC8,
	16065: 0x6458,
	16066: 0x658B,
	16067: 0x5B85,
	16068: 0x7A84,
	16069: 0x503A,
	16070: 0x5BE8,
	16071: 0x77BB,
	16072: 0x6BE1,
	16073: 0x8A79,
	16074: 0x7C98,
	16075: 0x6CBE,
	16076: 0x76CF,
	16077: 0x65A9,
	16078: 0x8F97,
	16079: 0x5D2D,
	16080: 0x5C55,
	16081: 0x8638,
	16082: 0x6808,
	16083: 0x5360,
	16084: 0x6218,
	16085: 0x7AD9,
	16086: 0x6E5B,
	16087: 0x7EFD,
	16088: 0x6A1F,
	16089: 0x7AE0,
	16090: 0x5F70,
	16091: 0x6F33,
	16092: 0x5F20,
	16093: 0x638C,
	16094: 0x6DA8,
	16095: 0x6756,
	16096: 0x4E08,
	16097: 0x5E10,
	16098: 0x8D26,
	16099: 0x4ED7,
	16100: 0x80C0,
	16101: 0x7634,
	16102: 0x969C,
	16103: 0x62DB,
	16104: 0x662D,
	16105: 0x627E,
	16106: 0x6CBC,
	16107: 0x8D75,
	16108: 0x7167,
	16109: 0x7F69,
	16110: 0x5146,
	16111: 0x8087,
	16112: 0x53EC,
	16113: 0x906E,
	16114: 0x6298,
	16115: 0x54F2,
	16116: 0x86F0,
	16117: 0x8F99,
	16118: 0x8005,
	16119: 0x9517,
	16120: 0x8517,
	16121: 0x8FD9,
	16122: 0x6D59,
	16123: 0x73CD,
	16124: 0x659F,
	16125: 0x771F,
	16126: 0x7504,
	16127: 0x7827,
	16128: 0x81FB,
	16129: 0x8D1E,
	16130: 0x9488,
	16131: 0x4FA6,
	16132: 0x6795,
	16133: 0x75B9,
	16134: 0x8BCA,
	16135: 0x9707,
	16136: 0x632F,
	16137: 0x9547,
	16138: 0x9635,
	16139: 0x84B8,
	16140: 0x6323,
	16141: 0x7741,
	16142: 0x5F81,
	16143: 0x72F0,
	16144: 0x4E89,
	16145: 0x6014,
	16146: 0x6574,
	16147: 0x62EF,
	16148: 0x6B63,
	16149: 0x653F,
	16150: 0x8AE4,
	16151: 0x8AE5,
	16152: 0x8AE6,
	16153: 0x8AE7,
	16154: 0x8AE8,
	16155: 0x8AE9,
	16156: 0x8AEA,
	16157: 0x8AEB,
	16158: 0x8AEC,
	16159: 0x8AED,
	16160: 0x8AEE,
	16161: 0x8AEF,
	16162: 0x8AF0,
	16163: 0x8AF1,
	16164: 0x8AF2,
	16165: 0x8AF3,
	16166: 0x8AF4,
	16167: 0x8AF5,
	16168: 0x8AF6,
	16169: 0x8AF7,
	16170: 0x8AF8,
	16171: 0x8AF9,
	16172: 0x8AFA,
	16173: 0x8AFB,
	16174: 0x8AFC,
	16175: 0x8AFD,
	16176: 0x8AFE,
	16177: 0x8AFF,
	16178: 0x8B00,
	16179: 0x8B01,
	16180: 0x8B02,
	16181: 0x8B03,
	16182: 0x8B04,
	16183: 0x8B05,
	16184: 0x8B06,
	16185: 0x8B08,
	16186: 0x8B09,
	16187: 0x8B0A,
	16188: 0x8B0B,
	16189: 0x8B0C,
	16190: 0x8B0D,
	16191: 0x8B0E,
	16192: 0x8B0F,
	16193: 0x8B10,
	16194: 0x8B11,
	16195: 0x8B12,
	16196: 0x8B13,
	16197: 0x8B14,
	16198: 0x8B15,
	16199: 0x8B16,
	16200: 0x8B17,
	16201: 0x8B18,
	16202: 0x8B19,
	16203: 0x8B1A,
	16204: 0x8B1B,
	16205: 0x8B1C,
	16206: 0x8B1D,
	16207: 0x8B1E,
	16208: 0x8B1F,
	16209: 0x8B20,
	16210: 0x8B21,
	16211: 0x8B22,
	16212: 0x8B23,
	16213: 0x8B24,
	16214: 0x8B25,
	16215: 0x8B27,
	16216: 0x8B28,
	16217: 0x8B29,
	16218: 0x8B2A,
	16219: 0x8B2B,
	16220: 0x8B2C,
	16221: 0x8B2D,
	16222: 0x8B2E,
	16223: 0x8B2F,
	16224: 0x8B30,
	16225: 0x8B31,
	16226: 0x8B32,
	16227: 0x8B33,
	16228: 0x8B34,
	16229: 0x8B35,
	16230: 0x8B36,
	16231: 0x8B37,
	16232: 0x8B38,
	16233: 0x8B39,
	16234: 0x8B3A,
	16235: 0x8B3B,
	16236: 0x8B3C,
	16237: 0x8B3D,
	16238: 0x8B3E,
	16239: 0x8B3F,
	16240: 0x8B40,
	16241: 0x8B41,
	16242: 0x8B42,
	16243: 0x8B43,
	16244: 0x8B44,
	16245: 0x8B45,
	16246: 0x5E27,
	16247: 0x75C7,
	16248: 0x90D1,
	16249: 0x8BC1,
	16250: 0x829D,
	16251: 0x679D,
	16252: 0x652F,
	16253: 0x5431,
	16254: 0x8718,
	16255: 0x77E5,
	16256: 0x80A2,
	16257: 0x8102,
	16258: 0x6C41,
	16259: 0x4E4B,
	16260: 0x7EC7,
	16261: 0x804C,
	16262: 0x76F4,
	16263: 0x690D,
	16264: 0x6B96,
	16265: 0x6267,
	16266: 0x503C,
	16267: 0x4F84,
	16268: 0x5740,
	16269: 0x6307,
	16270: 0x6B62,
	16271: 0x8DBE,
	16272: 0x53EA,
	16273: 0x65E8,
	16274: 0x7EB8,
	16275: 0x5FD7,
	16276: 0x631A,
	16277: 0x63B7,
	16278: 0x81F3,
	16279: 0x81F4,
	16280: 0x7F6E,
	16281: 0x5E1C,
	16282: 0x5CD9,
	16283: 0x5236,
	16284: 0x667A,
	16285: 0x79E9,
	16286: 0x7A1A,
	16287: 0x8D28,
	16288: 0x7099,
	16289: 0x75D4,
	16290: 0x6EDE,
	16291: 0x6CBB,
	16292: 0x7A92,
	16293: 0x4E2D,
	16294: 0x76C5,
	16295: 0x5FE0,
	16296: 0x949F,
	16297: 0x8877,
	16298: 0x7EC8,
	16299: 0x79CD,
	16300: 0x80BF,
	16301: 0x91CD,
	16302: 0x4EF2,
	16303: 0x4F17,
	16304: 0x821F,
	16305: 0x5468,
	16306: 0x5DDE,
	16307: 0x6D32,
	16308: 0x8BCC,
	16309: 0x7CA5,
	16310: 0x8F74,
	16311: 0x8098,
	16312: 0x5E1A,
	16313: 0x5492,
	16314: 0x76B1,
	16315: 0x5B99,
	16316: 0x663C,
	16317: 0x9AA4,
	16318: 0x73E0,
	16319: 0x682A,
	16320: 0x86DB,
	16321: 0x6731,
	16322: 0x732A,
	16323: 0x8BF8,
	16324: 0x8BDB,
	16325: 0x9010,
	16326: 0x7AF9,
	16327: 0x70DB,
	16328: 0x716E,
	16329: 0x62C4,
	16330: 0x77A9,
	16331: 0x5631,
	16332: 0x4E3B,
	16333: 0x8457,
	16334: 0x67F1,
	16335: 0x52A9,
	16336: 0x86C0,
	16337: 0x8D2E,
	16338: 0x94F8,
	16339: 0x7B51,
	16340: 0x8B46,
	16341: 0x8B47,
	16342: 0x8B48,
	16343: 0x8B49,
	16344: 0x8B4A,
	16345: 0x8B4B,
	16346: 0x8B4C,
	16347: 0x8B4D,
	16348: 0x8B4E,
	16349: 0x8B4F,
	16350: 0x8B50,
	16351: 0x8B51,
	16352: 0x8B52,
	16353: 0x8B53,
	16354: 0x8B54,
	16355: 0x8B55,
	16356: 0x8B56,
	16357: 0x8B57,
	16358: 0x8B58,
	16359: 0x8B59,
	16360: 0x8B5A,
	16361: 0x8B5B,
	16362: 0x8B5C,
	16363: 0x8B5D,
	16364: 0x8B5E,
	16365: 0x8B5F,
	16366: 0x8B60,
	16367: 0x8B61,
	16368: 0x8B62,
	16369: 0x8B63,
	16370: 0x8B64,
	16371: 0x8B65,
	16372: 0x8B67,
	16373: 0x8B68,
	16374: 0x8B69,
	16375: 0x8B6A,
	16376: 0x8B6B,
	16377: 0x8B6D,
	16378: 0x8B6E,
	16379: 0x8B6F,
	16380: 0x8B70,
	16381: 0x8B71,
	16382: 0x8B72,
	16383: 0x8B73,
	16384: 0x8B74,
	16385: 0x8B75,
	16386: 0x8B76,
	16387: 0x8B77,
	16388: 0x8B78,
	16389: 0x8B79,
	16390: 0x8B7A,
	16391: 0x8B7B,
	16392: 0x8B7C,
	16393: 0x8B7D,
	16394: 0x8B7E,
	16395: 0x8B7F,
	16396: 0x8B80,
	16397: 0x8B81,
	16398: 0x8B82,
	16399: 0x8B83,
	16400: 0x8B84,
	16401: 0x8B85,
	16402: 0x8B86,
	16403: 0x8B87,
	16404: 0x8B88,
	16405: 0x8B89,
	16406: 0x8B8A,
	16407: 0x8B8B,
	16408: 0x8B8C,
	16409: 0x8B8D,
	16410: 0x8B8E,
	16411: 0x8B8F,
	16412: 0x8B90,
	16413: 0x8B91,
	16414: 0x8B92,
	16415: 0x8B93,
	16416: 0x8B94,
	16417: 0x8B95,
	16418: 0x8B96,
	16419: 0x8B97,
	16420: 0x8B98,
	16421: 0x8B99,
	16422: 0x8B9A,
	16423: 0x8B9B,
	16424: 0x8B9C,
	16425: 0x8B9D,
	16426: 0x8B9E,
	16427: 0x8B9F,
	16428: 0x8BAC,
	16429: 0x8BB1,
	16430: 0x8BBB,
	16431: 0x8BC7,
	16432: 0x8BD0,
	16433: 0x8BEA,
	16434: 0x8C09,
	16435: 0x8C1E,
	16436: 0x4F4F,
	16437: 0x6CE8,
	16438: 0x795D,
	16439: 0x9A7B,
	16440: 0x6293,
	16441: 0x722A,
	16442: 0x62FD,
	16443: 0x4E13,
	16444: 0x7816,
	16445: 0x8F6C,
	16446: 0x64B0,
	16447: 0x8D5A,
	16448: 0x7BC6,
	16449: 0x6869,
	16450: 0x5E84,
	16451: 0x88C5,
	16452: 0x5986,
	16453: 0x649E,
	16454: 0x58EE,
	16455: 0x72B6,
	16456: 0x690E,
	16457: 0x9525,
	16458: 0x8FFD,
	16459: 0x8D58,
	16460: 0x5760,
	16461: 0x7F00,
	16462: 0x8C06,
	16463: 0x51C6,
	16464: 0x6349,
	16465: 0x62D9,
	16466: 0x5353,
	16467: 0x684C,
	16468: 0x7422,
	16469: 0x8301,
	16470: 0x914C,
	16471: 0x5544,
	16472: 0x7740,
	16473: 0x707C,
	16474: 0x6D4A,
	16475: 0x5179,
	16476: 0x54A8,
	16477: 0x8D44,
	16478: 0x59FF,
	16479: 0x6ECB,
	16480: 0x6DC4,
	16481: 0x5B5C,
	16482: 0x7D2B,
	16483: 0x4ED4,
	16484: 0x7C7D,
	16485: 0x6ED3,
	16486: 0x5B50,
	16487: 0x81EA,
	16488: 0x6E0D,
	16489: 0x5B57,
	16490: 0x9B03,
	16491: 0x68D5,
	16492: 0x8E2A,
	16493: 0x5B97,
	16494: 0x7EFC,
	16495: 0x603B,
	16496: 0x7EB5,
	16497: 0x90B9,
	16498: 0x8D70,
	16499: 0x594F,
	16500: 0x63CD,
	16501: 0x79DF,
	16502: 0x8DB3,
	16503: 0x5352,
	16504: 0x65CF,
	16505: 0x7956,
	16506: 0x8BC5,
	16507: 0x963B,
	16508: 0x7EC4,
	16509: 0x94BB,
	16510: 0x7E82,
	16511: 0x5634,
	16512: 0x9189,
	16513: 0x6700,
	16514: 0x7F6A,
	16515: 0x5C0A,
	16516: 0x9075,
	16517: 0x6628,
	16518: 0x5DE6,
	16519: 0x4F50,
	16520: 0x67DE,
	16521: 0x505A,
	16522: 0x4F5C,
	16523: 0x5750,
	16524: 0x5EA7,
	16530: 0x8C38,
	16531: 0x8C39,
	16532: 0x8C3A,
	16533: 0x8C3B,
	16534: 0x8C3C,
	16535: 0x8C3D,
	16536: 0x8C3E,
	16537: 0x8C3F,
	16538: 0x8C40,
	16539: 0x8C42,
	16540: 0x8C43,
	16541: 0x8C44,
	16542: 0x8C45,
	16543: 0x8C48,
	16544: 0x8C4A,
	16545: 0x8C4B,
	16546: 0x8C4D,
	16547: 0x8C4E,
	16548: 0x8C4F,
	16549: 0x8C50,
	16550: 0x8C51,
	16551: 0x8C52,
	16552: 0x8C53,
	16553: 0x8C54,
	16554: 0x8C56,
	16555: 0x8C57,
	16556: 0x8C58,
	16557: 0x8C59,
	16558: 0x8C5B,
	16559: 0x8C5C,
	16560: 0x8C5D,
	16561: 0x8C5E,
	16562: 0x8C5F,
	16563: 0x8C60,
	16564: 0x8C63,
	16565: 0x8C64,
	16566: 0x8C65,
	16567: 0x8C66,
	16568: 0x8C67,
	16569: 0x8C68,
	16570: 0x8C69,
	16571: 0x8C6C,
	16572: 0x8C6D,
	16573: 0x8C6E,
	16574: 0x8C6F,
	16575: 0x8C70,
	16576: 0x8C71,
	16577: 0x8C72,
	16578: 0x8C74,
	16579: 0x8C75,
	16580: 0x8C76,
	16581: 0x8C77,
	16582: 0x8C7B,
	16583: 0x8C7C,
	16584: 0x8C7D,
	16585: 0x8C7E,
	16586: 0x8C7F,
	16587: 0x8C80,
	16588: 0x8C81,
	16589: 0x8C83,
	16590: 0x8C84,
	16591: 0x8C86,
	16592: 0x8C87,
	16593: 0x8C88,
	16594: 0x8C8B,
	16595: 0x8C8D,
	16596: 0x8C8E,
	16597: 0x8C8F,
	16598: 0x8C90,
	16599: 0x8C91,
	16600: 0x8C92,
	16601: 0x8C93,
	16602: 0x8C95,
	16603: 0x8C96,
	16604: 0x8C97,
	16605: 0x8C99,
	16606: 0x8C9A,
	16607: 0x8C9B,
	16608: 0x8C9C,
	16609: 0x8C9D,
	16610: 0x8C9E,
	16611: 0x8C9F,
	16612: 0x8CA0,
	16613: 0x8CA1,
	16614: 0x8CA2,
	16615: 0x8CA3,
	16616: 0x8CA4,
	16617: 0x8CA5,
	16618: 0x8CA6,
	16619: 0x8CA7,
	16620: 0x8CA8,
	16621: 0x8CA9,
	16622: 0x8CAA,
	16623: 0x8CAB,
	16624: 0x8CAC,
	16625: 0x8CAD,
	16626: 0x4E8D,
	16627: 0x4E0C,
	16628: 0x5140,
	16629: 0x4E10,
	16630: 0x5EFF,
	16631: 0x5345,
	16632: 0x4E15,
	16633: 0x4E98,
	16634: 0x4E1E,
	16635: 0x9B32,
	16636: 0x5B6C,
	16637: 0x5669,
	16638: 0x4E28,
	16639: 0x79BA,
	16640: 0x4E3F,
	16641: 0x5315,
	16642: 0x4E47,
	16643: 0x592D,
	16644: 0x723B,
	16645: 0x536E,
	16646: 0x6C10,
	16647: 0x56DF,
	16648: 0x80E4,
	16649: 0x9997,
	16650: 0x6BD3,
	16651: 0x777E,
	16652: 0x9F17,
	16653: 0x4E36,
	16654: 0x4E9F,
	16655: 0x9F10,
	16656: 0x4E5C,
	16657: 0x4E69,
	16658: 0x4E93,
	16659: 0x8288,
	16660: 0x5B5B,
	16661: 0x556C,
	16662: 0x560F,
	16663: 0x4EC4,
	16664: 0x538D,
	16665: 0x539D,
	16666: 0x53A3,
	16667: 0x53A5,
	16668: 0x53AE,
	16669: 0x9765,
	16670: 0x8D5D,
	16671: 0x531A,
	16672: 0x53F5,
	16673: 0x5326,
	16674: 0x532E,
	16675: 0x533E,
	16676: 0x8D5C,
	16677: 0x5366,
	16678: 0x5363,
	16679: 0x5202,
	16680: 0x5208,
	16681: 0x520E,
	16682: 0x522D,
	16683: 0x5233,
	16684: 0x523F,
	16685: 0x5240,
	16686: 0x524C,
	16687: 0x525E,
	16688: 0x5261,
	16689: 0x525C,
	16690: 0x84AF,
	16691: 0x527D,
	16692: 0x5282,
	16693: 0x5281,
	16694: 0x5290,
	16695: 0x5293,
	16696: 0x5182,
	16697: 0x7F54,
	16698: 0x4EBB,
	16699: 0x4EC3,
	16700: 0x4EC9,
	16701: 0x4EC2,
	16702: 0x4EE8,
	16703: 0x4EE1,
	16704: 0x4EEB,
	16705: 0x4EDE,
	16706: 0x4F1B,
	16707: 0x4EF3,
	16708: 0x4F22,
	16709: 0x4F64,
	16710: 0x4EF5,
	16711: 0x4F25,
	16712: 0x4F27,
	16713: 0x4F09,
	16714: 0x4F2B,
	16715: 0x4F5E,
	16716: 0x4F67,
	16717: 0x6538,
	16718: 0x4F5A,
	16719: 0x4F5D,
	16720: 0x8CAE,
	16721: 0x8CAF,
	16722: 0x8CB0,
	16723: 0x8CB1,
	16724: 0x8CB2,
	16725: 0x8CB3,
	16726: 0x8CB4,
	16727: 0x8CB5,
	16728: 0x8CB6,
	16729: 0x8CB7,
	16730: 0x8CB8,
	16731: 0x8CB9,
	16732: 0x8CBA,
	16733: 0x8CBB,
	16734: 0x8CBC,
	16735: 0x8CBD,
	16736: 0x8CBE,
	16737: 0x8CBF,
	16738: 0x8CC0,
	16739: 0x8CC1,
	16740: 0x8CC2,
	16741: 0x8CC3,
	16742: 0x8CC4,
	16743: 0x8CC5,
	16744: 0x8CC6,
	16745: 0x8CC7,
	16746: 0x8CC8,
	16747: 0x8CC9,
	16748: 0x8CCA,
	16749: 0x8CCB,
	16750: 0x8CCC,
	16751: 0x8CCD,
	16752: 0x8CCE,
	16753: 0x8CCF,
	16754: 0x8CD0,
	16755: 0x8CD1,
	16756: 0x8CD2,
	16757: 0x8CD3,
	16758: 0x8CD4,
	16759: 0x8CD5,
	16760: 0x8CD6,
	16761: 0x8CD7,
	16762: 0x8CD8,
	16763: 0x8CD9,
	16764: 0x8CDA,
	16765: 0x8CDB,
	16766: 0x8CDC,
	16767: 0x8CDD,
	16768: 0x8CDE,
	16769: 0x8CDF,
	16770: 0x8CE0,
	16771: 0x8CE1,
	16772: 0x8CE2,
	16773: 0x8CE3,
	16774: 0x8CE4,
	16775: 0x8CE5,
	16776: 0x8CE6,
	16777: 0x8CE7,
	16778: 0x8CE8,
	16779: 0x8CE9,
	16780: 0x8CEA,
	16781: 0x8CEB,
	16782: 0x8CEC,
	16783: 0x8CED,
	16784: 0x8CEE,
	16785: 0x8CEF,
	16786: 0x8CF0,
	16787: 0x8CF1,
	16788: 0x8CF2,
	16789: 0x8CF3,
	16790: 0x8CF4,
	16791: 0x8CF5,
	16792: 0x8CF6,
	16793: 0x8CF7,
	16794: 0x8CF8,
	16795: 0x8CF9,
	16796: 0x8CFA,
	16797: 0x8CFB,
	16798: 0x8CFC,
	16799: 0x8CFD,
	16800: 0x8CFE,
	16801: 0x8CFF,
	16802: 0x8D00,
	16803: 0x8D01,
	16804: 0x8D02,
	16805: 0x8D03,
	16806: 0x8D04,
	16807: 0x8D05,
	16808: 0x8D06,
	16809: 0x8D07,
	16810: 0x8D08,
	16811: 0x8D09,
	16812: 0x8D0A,
	16813: 0x8D0B,
	16814: 0x8D0C,
	16815: 0x8D0D,
	16816: 0x4F5F,
	16817: 0x4F57,
	16818: 0x4F32,
	16819: 0x4F3D,
	16820: 0x4F76,
	16821: 0x4F74,
	16822: 0x4F91,
	16823: 0x4F89,
	16824: 0x4F83,
	16825: 0x4F8F,
	16826: 0x4F7E,
	16827: 0x4F7B,
	16828: 0x4FAA,
	16829: 0x4F7C,
	16830: 0x4FAC,
	16831: 0x4F94,
	16832: 0x4FE6,
	16833: 0x4FE8,
	16834: 0x4FEA,
	16835: 0x4FC5,
	16836: 0x4FDA,
	16837: 0x4FE3,
	16838: 0x4FDC,
	16839: 0x4FD1,
	16840: 0x4FDF,
	16841: 0x4FF8,
	16842: 0x5029,
	16843: 0x504C,
	16844: 0x4FF3,
	16845: 0x502C,
	16846: 0x500F,
	16847: 0x502E,
	16848: 0x502D,
	16849: 0x4FFE,
	16850: 0x501C,
	16851: 0x500C,
	16852: 0x5025,
	16853: 0x5028,
	16854: 0x507E,
	16855: 0x5043,
	16856: 0x5055,
	16857: 0x5048,
	16858: 0x504E,
	16859: 0x506C,
	16860: 0x507B,
	16861: 0x50A5,
	16862: 0x50A7,
	16863: 0x50A9,
	16864: 0x50BA,
	16865: 0x50D6,
	16866: 0x5106,
	16867: 0x50ED,
	16868: 0x50EC,
	16869: 0x50E6,
	16870: 0x50EE,
	16871: 0x5107,
	16872: 0x510B,
	16873: 0x4EDD,
	16874: 0x6C3D,
	16875: 0x4F58,
	16876: 0x4F65,
	16877: 0x4FCE,
	16878: 0x9FA0,
	16879: 0x6C46,
	16880: 0x7C74,
	16881: 0x516E,
	16882: 0x5DFD,
	16883: 0x9EC9,
	16884: 0x9998,
	16885: 0x5181,
	16886: 0x5914,
	16887: 0x52F9,
	16888: 0x530D,
	16889: 0x8A07,
	16890: 0x5310,
	16891: 0x51EB,
	16892: 0x5919,
	16893: 0x5155,
	16894: 0x4EA0,
	16895: 0x5156,
	16896: 0x4EB3,
	16897: 0x886E,
	16898: 0x88A4,
	16899: 0x4EB5,
	16900: 0x8114,
	16901: 0x88D2,
	16902: 0x7980,
	16903: 0x5B34,
	16904: 0x8803,
	16905: 0x7FB8,
	16906: 0x51AB,
	16907: 0x51B1,
	16908: 0x51BD,
	16909: 0x51BC,
	16910: 0x8D0E,
	16911: 0x8D0F,
	16912: 0x8D10,
	16913: 0x8D11,
	16914: 0x8D12,
	16915: 0x8D13,
	16916: 0x8D14,
	16917: 0x8D15,
	16918: 0x8D16,
	16919: 0x8D17,
	16920: 0x8D18,
	16921: 0x8D19,
	16922: 0x8D1A,
	16923: 0x8D1B,
	16924: 0x8D1C,
	16925: 0x8D20,
	16926: 0x8D51,
	16927: 0x8D52,
	16928: 0x8D57,
	16929: 0x8D5F,
	16930: 0x8D65,
	16931: 0x8D68,
	16932: 0x8D69,
	16933: 0x8D6A,
	16934: 0x8D6C,
	16935: 0x8D6E,
	16936: 0x8D6F,
	16937: 0x8D71,
	16938: 0x8D72,
	16939: 0x8D78,
	16940: 0x8D79,
	16941: 0x8D7A,
	16942: 0x8D7B,
	16943: 0x8D7C,
	16944: 0x8D7D,
	16945: 0x8D7E,
	16946: 0x8D7F,
	16947: 0x8D80,
	16948: 0x8D82,
	16949: 0x8D83,
	16950: 0x8D86,
	16951: 0x8D87,
	16952: 0x8D88,
	16953: 0x8D89,
	16954: 0x8D8C,
	16955: 0x8D8D,
	16956: 0x8D8E,
	16957: 0x8D8F,
	16958: 0x8D90,
	16959: 0x8D92,
	16960: 0x8D93,
	16961: 0x8D95,
	16962: 0x8D96,
	16963: 0x8D97,
	16964: 0x8D98,
	16965: 0x8D99,
	16966: 0x8D9A,
	16967: 0x8D9B,
	16968: 0x8D9C,
	16969: 0x8D9D,
	16970: 0x8D9E,
	16971: 0x8DA0,
	16972: 0x8DA1,
	16973: 0x8DA2,
	16974: 0x8DA4,
	16975: 0x8DA5,
	16976: 0x8DA6,
	16977: 0x8DA7,
	16978: 0x8DA8,
	16979: 0x8DA9,
	16980: 0x8DAA,
	16981: 0x8DAB,
	16982: 0x8DAC,
	16983: 0x8DAD,
	16984: 0x8DAE,
	16985: 0x8DAF,
	16986: 0x8DB0,
	16987: 0x8DB2,
	16988: 0x8DB6,
	16989: 0x8DB7,
	16990: 0x8DB9,
	16991: 0x8DBB,
	16992: 0x8DBD,
	16993: 0x8DC0,
	16994: 0x8DC1,
	16995: 0x8DC2,
	16996: 0x8DC5,
	16997: 0x8DC7,
	16998: 0x8DC8,
	16999: 0x8DC9,
	17000: 0x8DCA,
	17001: 0x8DCD,
	17002: 0x8DD0,
	17003: 0x8DD2,
	17004: 0x8DD3,
	17005: 0x8DD4,
	17006: 0x51C7,
	17007: 0x5196,
	17008: 0x51A2,
	17009: 0x51A5,
	17010: 0x8BA0,
	17011: 0x8BA6,
	17012: 0x8BA7,
	17013: 0x8BAA,
	17014: 0x8BB4,
	17015: 0x8BB5,
	17016: 0x8BB7,
	17017: 0x8BC2,
	17018: 0x8BC3,
	17019: 0x8BCB,
	17020: 0x8BCF,
	17021: 0x8BCE,
	17022: 0x8BD2,
	17023: 0x8BD3,
	17024: 0x8BD4,
	17025: 0x8BD6,
	17026: 0x8BD8,
	17027: 0x8BD9,
	17028: 0x8BDC,
	17029: 0x8BDF,
	17030: 0x8BE0,
	17031: 0x8BE4,
	17032: 0x8BE8,
	17033: 0x8BE9,
	17034: 0x8BEE,
	17035: 0x8BF0,
	17036: 0x8BF3,
	17037: 0x8BF6,
	17038: 0x8BF9,
	17039: 0x8BFC,
	17040: 0x8BFF,
	17041: 0x8C00,
	17042: 0x8C02,
	17043: 0x8C04,
	17044: 0x8C07,
	17045: 0x8C0C,
	17046: 0x8C0F,
	17047: 0x8C11,
	17048: 0x8C12,
	17049: 0x8C14,
	17050: 0x8C15,
	17051: 0x8C16,
	17052: 0x8C19,
	17053: 0x8C1B,
	17054: 0x8C18,
	17055: 0x8C1D,
	17056: 0x8C1F,
	17057: 0x8C20,
	17058: 0x8C21,
	17059: 0x8C25,
	17060: 0x8C27,
	17061: 0x8C2A,
	17062: 0x8C2B,
	17063: 0x8C2E,
	17064: 0x8C2F,
	17065: 0x8C32,
	17066: 0x8C33,
	17067: 0x8C35,
	17068: 0x8C36,
	17069: 0x5369,
	17070: 0x537A,
	17071: 0x961D,
	17072: 0x9622,
	17073: 0x9621,
	17074: 0x9631,
	17075: 0x962A,
	17076: 0x963D,
	17077: 0x963C,
	17078: 0x9642,
	17079: 0x9649,
	17080: 0x9654,
	17081: 0x965F,
	17082: 0x9667,
	17083: 0x966C,
	17084: 0x9672,
	17085: 0x9674,
	17086: 0x9688,
	17087: 0x968D,
	17088: 0x9697,
	17089: 0x96B0,
	17090: 0x9097,
	17091: 0x909B,
	17092: 0x909D,
	17093: 0x9099,
	17094: 0x90AC,
	17095: 0x90A1,
	17096: 0x90B4,
	17097: 0x90B3,
	17098: 0x90B6,
	17099: 0x90BA,
	17100: 0x8DD5,
	17101: 0x8DD8,
	17102: 0x8DD9,
	17103: 0x8DDC,
	17104: 0x8DE0,
	17105: 0x8DE1,
	17106: 0x8DE2,
	17107: 0x8DE5,
	17108: 0x8DE6,
	17109: 0x8DE7,
	17110: 0x8DE9,
	17111: 0x8DED,
	17112: 0x8DEE,
	17113: 0x8DF0,
	17114: 0x8DF1,
	17115: 0x8DF2,
	17116: 0x8DF4,
	17117: 0x8DF6,
	17118: 0x8DFC,
	17119: 0x8DFE,
	17120: 0x8DFF,
	17121: 0x8E00,
	17122: 0x8E01,
	17123: 0x8E02,
	17124: 0x8E03,
	17125: 0x8E04,
	17126: 0x8E06,
	17127: 0x8E07,
	17128: 0x8E08,
	17129: 0x8E0B,
	17130: 0x8E0D,
	17131: 0x8E0E,
	17132: 0x8E10,
	17133: 0x8E11,
	17134: 0x8E12,
	17135: 0x8E13,
	17136: 0x8E15,
	17137: 0x8E16,
	17138: 0x8E17,
	17139: 0x8E18,
	17140: 0x8E19,
	17141: 0x8E1A,
	17142: 0x8E1B,
	17143: 0x8E1C,
	17144: 0x8E20,
	17145: 0x8E21,
	17146: 0x8E24,
	17147: 0x8E25,
	17148: 0x8E26,
	17149: 0x8E27,
	17150: 0x8E28,
	17151: 0x8E2B,
	17152: 0x8E2D,
	17153: 0x8E30,
	17154: 0x8E32,
	17155: 0x8E33,
	17156: 0x8E34,
	17157: 0x8E36,
	17158: 0x8E37,
	17159: 0x8E38,
	17160: 0x8E3B,
	17161: 0x8E3C,
	17162: 0x8E3E,
	17163: 0x8E3F,
	17164: 0x8E43,
	17165: 0x8E45,
	17166: 0x8E46,
	17167: 0x8E4C,
	17168: 0x8E4D,
	17169: 0x8E4E,
	17170: 0x8E4F,
	17171: 0x8E50,
	17172: 0x8E53,
	17173: 0x8E54,
	17174: 0x8E55,
	17175: 0x8E56,
	17176: 0x8E57,
	17177: 0x8E58,
	17178: 0x8E5A,
	17179: 0x8E5B,
	17180: 0x8E5C,
	17181: 0x8E5D,
	17182: 0x8E5E,
	17183: 0x8E5F,
	17184: 0x8E60,
	17185: 0x8E61,
	17186: 0x8E62,
	17187: 0x8E63,
	17188: 0x8E64,
	17189: 0x8E65,
	17190: 0x8E67,
	17191: 0x8E68,
	17192: 0x8E6A,
	17193: 0x8E6B,
	17194: 0x8E6E,
	17195: 0x8E71,
	17196: 0x90B8,
	17197: 0x90B0,
	17198: 0x90CF,
	17199: 0x90C5,
	17200: 0x90BE,
	17201: 0x90D0,
	17202: 0x90C4,
	17203: 0x90C7,
	17204: 0x90D3,
	17205: 0x90E6,
	17206: 0x90E2,
	17207: 0x90DC,
	17208: 0x90D7,
	17209: 0x90DB,
	17210: 0x90EB,
	17211: 0x90EF,
	17212: 0x90FE,
	17213: 0x9104,
	17214: 0x9122,
	17215: 0x911E,
	17216: 0x9123,
	17217: 0x9131,
	17218: 0x912F,
	17219: 0x9139,
	17220: 0x9143,
	17221: 0x9146,
	17222: 0x520D,
	17223: 0x5942,
	17224: 0x52A2,
	17225: 0x52AC,
	17226: 0x52AD,
	17227: 0x52BE,
	17228: 0x54FF,
	17229: 0x52D0,
	17230: 0x52D6,
	17231: 0x52F0,
	17232: 0x53DF,
	17233: 0x71EE,
	17234: 0x77CD,
	17235: 0x5EF4,
	17236: 0x51F5,
	17237: 0x51FC,
	17238: 0x9B2F,
	17239: 0x53B6,
	17240: 0x5F01,
	17241: 0x755A,
	17242: 0x5DEF,
	17243: 0x574C,
	17244: 0x57A9,
	17245: 0x57A1,
	17246: 0x587E,
	17247: 0x58BC,
	17248: 0x58C5,
	17249: 0x58D1,
	17250: 0x5729,
	17251: 0x572C,
	17252: 0x572A,
	17253: 0x5733,
	17254: 0x5739,
	17255: 0x572E,
	17256: 0x572F,
	17257: 0x575C,
	17258: 0x573B,
	17259: 0x5742,
	17260: 0x5769,
	17261: 0x5785,
	17262: 0x576B,
	17263: 0x5786,
	17264: 0x577C,
	17265: 0x577B,
	17266: 0x5768,
	17267: 0x576D,
	17268: 0x5776,
	17269: 0x5773,
	17270: 0x57AD,
	17271: 0x57A4,
	17272: 0x578C,
	17273: 0x57B2,
	17274: 0x57CF,
	17275: 0x57A7,
	17276: 0x57B4,
	17277: 0x5793,
	17278: 0x57A0,
	17279: 0x57D5,
	17280: 0x57D8,
	17281: 0x57DA,
	17282: 0x57D9,
	17283: 0x57D2,
	17284: 0x57B8,
	17285: 0x57F4,
	17286: 0x57EF,
	17287: 0x57F8,
	17288: 0x57E4,
	17289: 0x57DD,
	17290: 0x8E73,
	17291: 0x8E75,
	17292: 0x8E77,
	17293: 0x8E78,
	17294: 0x8E79,
	17295: 0x8E7A,
	17296: 0x8E7B,
	17297: 0x8E7D,
	17298: 0x8E7E,
	17299: 0x8E80,
	17300: 0x8E82,
	17301: 0x8E83,
	17302: 0x8E84,
	17303: 0x8E86,
	17304: 0x8E88,
	17305: 0x8E89,
	17306: 0x8E8A,
	17307: 0x8E8B,
	17308: 0x8E8C,
	17309: 0x8E8D,
	17310: 0x8E8E,
	17311: 0x8E91,
	17312: 0x8E92,
	17313: 0x8E93,
	17314: 0x8E95,
	17315: 0x8E96,
	17316: 0x8E97,
	17317: 0x8E98,
	17318: 0x8E99,
	17319: 0x8E9A,
	17320: 0x8E9B,
	17321: 0x8E9D,
	17322: 0x8E9F,
	17323: 0x8EA0,
	17324: 0x8EA1,
	17325: 0x8EA2,
	17326: 0x8EA3,
	17327: 0x8EA4,
	17328: 0x8EA5,
	17329: 0x8EA6,
	17330: 0x8EA7,
	17331: 0x8EA8,
	17332: 0x8EA9,
	17333: 0x8EAA,
	17334: 0x8EAD,
	17335: 0x8EAE,
	17336: 0x8EB0,
	17337: 0x8EB1,
	17338: 0x8EB3,
	17339: 0x8EB4,
	17340: 0x8EB5,
	17341: 0x8EB6,
	17342: 0x8EB7,
	17343: 0x8EB8,
	17344: 0x8EB9,
	17345: 0x8EBB,
	17346: 0x8EBC,
	17347: 0x8EBD,
	17348: 0x8EBE,
	17349: 0x8EBF,
	17350: 0x8EC0,
	17351: 0x8EC1,
	17352: 0x8EC2,
	17353: 0x8EC3,
	17354: 0x8EC4,
	17355: 0x8EC5,
	17356: 0x8EC6,
	17357: 0x8EC7,
	17358: 0x8EC8,
	17359: 0x8EC9,
	17360: 0x8ECA,
	17361: 0x8ECB,
	17362: 0x8ECC,
	17363: 0x8ECD,
	17364: 0x8ECF,
	17365: 0x8ED0,
	17366: 0x8ED1,
	17367: 0x8ED2,
	17368: 0x8ED3,
	17369: 0x8ED4,
	17370: 0x8ED5,
	17371: 0x8ED6,
	17372: 0x8ED7,
	17373: 0x8ED8,
	17374: 0x8ED9,
	17375: 0x8EDA,
	17376: 0x8EDB,
	17377: 0x8EDC,
	17378: 0x8EDD,
	17379: 0x8EDE,
	17380: 0x8EDF,
	17381: 0x8EE0,
	17382: 0x8EE1,
	17383: 0x8EE2,
	17384: 0x8EE3,
	17385: 0x8EE4,
	17386: 0x580B,
	17387: 0x580D,
	17388: 0x57FD,
	17389: 0x57ED,
	17390: 0x5800,
	17391: 0x581E,
	17392: 0x5819,
	17393: 0x5844,
	17394: 0x5820,
	17395: 0x5865,
	17396: 0x586C,
	17397: 0x5881,
	17398: 0x5889,
	17399: 0x589A,
	17400: 0x5880,
	17401: 0x99A8,
	17402: 0x9F19,
	17403: 0x61FF,
	17404: 0x8279,
	17405: 0x827D,
	17406: 0x827F,
	17407: 0x828F,
	17408: 0x828A,
	17409: 0x82A8,
	17410: 0x8284,
	17411: 0x828E,
	17412: 0x8291,
	17413: 0x8297,
	17414: 0x8299,
	17415: 0x82AB,
	17416: 0x82B8,
	17417: 0x82BE,
	17418: 0x82B0,
	17419: 0x82C8,
	17420: 0x82CA,
	17421: 0x82E3,
	17422: 0x8298,
	17423: 0x82B7,
	17424: 0x82AE,
	17425: 0x82CB,
	17426: 0x82CC,
	17427: 0x82C1,
	17428: 0x82A9,
	17429: 0x82B4,
	17430: 0x82A1,
	17431: 0x82AA,
	17432: 0x829F,
	17433: 0x82C4,
	17434: 0x82CE,
	17435: 0x82A4,
	17436: 0x82E1,
	17437: 0x8309,
	17438: 0x82F7,
	17439: 0x82E4,
	17440: 0x830F,
	17441: 0x8307,
	17442: 0x82DC,
	17443: 0x82F4,
	17444: 0x82D2,
	17445: 0x82D8,
	17446: 0x830C,
	17447: 0x82FB,
	17448: 0x82D3,
	17449: 0x8311,
	17450: 0x831A,
	17451: 0x8306,
	17452: 0x8314,
	17453: 0x8315,
	17454: 0x82E0,
	17455: 0x82D5,
	17456: 0x831C,
	17457: 0x8351,
	17458: 0x835B,
	17459: 0x835C,
	17460: 0x8308,
	17461: 0x8392,
	17462: 0x833C,
	17463: 0x8334,
	17464: 0x8331,
	17465: 0x839B,
	17466: 0x835E,
	17467: 0x832F,
	17468: 0x834F,
	17469: 0x8347,
	17470: 0x8343,
	17471: 0x835F,
	17472: 0x8340,
	17473: 0x8317,
	17474: 0x8360,
	17475: 0x832D,
	17476: 0x833A,
	17477: 0x8333,
	17478: 0x8366,
	17479: 0x8365,
	17480: 0x8EE5,
	17481: 0x8EE6,
	17482: 0x8EE7,
	17483: 0x8EE8,
	17484: 0x8EE9,
	17485: 0x8EEA,
	17486: 0x8EEB,
	17487: 0x8EEC,
	17488: 0x8EED,
	17489: 0x8EEE,
	17490: 0x8EEF,
	17491: 0x8EF0,
	17492: 0x8EF1,
	17493: 0x8EF2,
	17494: 0x8EF3,
	17495: 0x8EF4,
	17496: 0x8EF5,
	17497: 0x8EF6,
	17498: 0x8EF7,
	17499: 0x8EF8,
	17500: 0x8EF9,
	17501: 0x8EFA,
	17502: 0x8EFB,
	17503: 0x8EFC,
	17504: 0x8EFD,
	17505: 0x8EFE,
	17506: 0x8EFF,
	17507: 0x8F00,
	17508: 0x8F01,
	17509: 0x8F02,
	17510: 0x8F03,
	17511: 0x8F04,
	17512: 0x8F05,
	17513: 0x8F06,
	17514: 0x8F07,
	17515: 0x8F08,
	17516: 0x8F09,
	17517: 0x8F0A,
	17518: 0x8F0B,
	17519: 0x8F0C,
	17520: 0x8F0D,
	17521: 0x8F0E,
	17522: 0x8F0F,
	17523: 0x8F10,
	17524: 0x8F11,
	17525: 0x8F12,
	17526: 0x8F13,
	17527: 0x8F14,
	17528: 0x8F15,
	17529: 0x8F16,
	17530: 0x8F17,
	17531: 0x8F18,
	17532: 0x8F19,
	17533: 0x8F1A,
	17534: 0x8F1B,
	17535: 0x8F1C,
	17536: 0x8F1D,
	17537: 0x8F1E,
	17538: 0x8F1F,
	17539: 0x8F20,
	17540: 0x8F21,
	17541: 0x8F22,
	17542: 0x8F23,
	17543: 0x8F24,
	17544: 0x8F25,
	17545: 0x8F26,
	17546: 0x8F27,
	17547: 0x8F28,
	17548: 0x8F29,
	17549: 0x8F2A,
	17550: 0x8F2B,
	17551: 0x8F2C,
	17552: 0x8F2D,
	17553: 0x8F2E,
	17554: 0x8F2F,
	17555: 0x8F30,
	17556: 0x8F31,
	17557: 0x8F32,
	17558: 0x8F33,
	17559: 0x8F34,
	17560: 0x8F35,
	17561: 0x8F36,
	17562: 0x8F37,
	17563: 0x8F38,
	17564: 0x8F39,
	17565: 0x8F3A,
	17566: 0x8F3B,
	17567: 0x8F3C,
	17568: 0x8F3D,
	17569: 0x8F3E,
	17570: 0x8F3F,
	17571: 0x8F40,
	17572: 0x8F41,
	17573: 0x8F42,
	17574: 0x8F43,
	17575: 0x8F44,
	17576: 0x8368,
	17577: 0x831B,
	17578: 0x8369,
	17579: 0x836C,
	17580: 0x836A,
	17581: 0x836D,
	17582: 0x836E,
	17583: 0x83B0,
	17584: 0x8378,
	17585: 0x83B3,
	17586: 0x83B4,
	17587: 0x83A0,
	17588: 0x83AA,
	17589: 0x8393,
	17590: 0x839C,
	17591: 0x8385,
	17592: 0x837C,
	17593: 0x83B6,
	17594: 0x83A9,
	17595: 0x837D,
	17596: 0x83B8,
	17597: 0x837B,
	17598: 0x8398,
	17599: 0x839E,
	17600: 0x83A8,
	17601: 0x83BA,
	17602: 0x83BC,
	17603: 0x83C1,
	17604: 0x8401,
	17605: 0x83E5,
	17606: 0x83D8,
	17607: 0x5807,
	17608: 0x8418,
	17609: 0x840B,
	17610: 0x83DD,
	17611: 0x83FD,
	17612: 0x83D6,
	17613: 0x841C,
	17614: 0x8438,
	17615: 0x8411,
	17616: 0x8406,
	17617: 0x83D4,
	17618: 0x83DF,
	17619: 0x840F,
	17620: 0x8403,
	17621: 0x83F8,
	17622: 0x83F9,
	17623: 0x83EA,
	17624: 0x83C5,
	17625: 0x83C0,
	17626: 0x8426,
	17627: 0x83F0,
	17628: 0x83E1,
	17629: 0x845C,
	17630: 0x8451,
	17631: 0x845A,
	17632: 0x8459,
	17633: 0x8473,
	17634: 0x8487,
	17635: 0x8488,
	17636: 0x847A,
	17637: 0x8489,
	17638: 0x8478,
	17639: 0x843C,
	17640: 0x8446,
	17641: 0x8469,
	17642: 0x8476,
	17643: 0x848C,
	17644: 0x848E,
	17645: 0x8431,
	17646: 0x846D,
	17647: 0x84C1,
	17648: 0x84CD,
	17649: 0x84D0,
	17650: 0x84E6,
	17651: 0x84BD,
	17652: 0x84D3,
	17653: 0x84CA,
	17654: 0x84BF,
	17655: 0x84BA,
	17656: 0x84E0,
	17657: 0x84A1,
	17658: 0x84B9,
	17659: 0x84B4,
	17660: 0x8497,
	17661: 0x84E5,
	17662: 0x84E3,
	17663: 0x850C,
	17664: 0x750D,
	17665: 0x8538,
	17666: 0x84F0,
	17667: 0x8539,
	17668: 0x851F,
	17669: 0x853A,
	17670: 0x8F45,
	17671: 0x8F46,
	17672: 0x8F47,
	17673: 0x8F48,
	17674: 0x8F49,
	17675: 0x8F4A,
	17676: 0x8F4B,
	17677: 0x8F4C,
	17678: 0x8F4D,
	17679: 0x8F4E,
	17680: 0x8F4F,
	17681: 0x8F50,
	17682: 0x8F51,
	17683: 0x8F52,
	17684: 0x8F53,
	17685: 0x8F54,
	17686: 0x8F55,
	17687: 0x8F56,
	17688: 0x8F57,
	17689: 0x8F58,
	17690: 0x8F59,
	17691: 0x8F5A,
	17692: 0x8F5B,
	17693: 0x8F5C,
	17694: 0x8F5D,
	17695: 0x8F5E,
	17696: 0x8F5F,
	17697: 0x8F60,
	17698: 0x8F61,
	17699: 0x8F62,
	17700: 0x8F63,
	17701: 0x8F64,
	17702: 0x8F65,
	17703: 0x8F6A,
	17704: 0x8F80,
	17705: 0x8F8C,
	17706: 0x8F92,
	17707: 0x8F9D,
	17708: 0x8FA0,
	17709: 0x8FA1,
	17710: 0x8FA2,
	17711: 0x8FA4,
	17712: 0x8FA5,
	17713: 0x8FA6,
	17714: 0x8FA7,
	17715: 0x8FAA,
	17716: 0x8FAC,
	17717: 0x8FAD,
	17718: 0x8FAE,
	17719: 0x8FAF,
	17720: 0x8FB2,
	17721: 0x8FB3,
	17722: 0x8FB4,
	17723: 0x8FB5,
	17724: 0x8FB7,
	17725: 0x8FB8,
	17726: 0x8FBA,
	17727: 0x8FBB,
	17728: 0x8FBC,
	17729: 0x8FBF,
	17730: 0x8FC0,
	17731: 0x8FC3,
	17732: 0x8FC6,
	17733: 0x8FC9,
	17734: 0x8FCA,
	17735: 0x8FCB,
	17736: 0x8FCC,
	17737: 0x8FCD,
	17738: 0x8FCF,
	17739: 0x8FD2,
	17740: 0x8FD6,
	17741: 0x8FD7,
	17742: 0x8FDA,
	17743: 0x8FE0,
	17744: 0x8FE1,
	17745: 0x8FE3,
	17746: 0x8FE7,
	17747: 0x8FEC,
	17748: 0x8FEF,
	17749: 0x8FF1,
	17750: 0x8FF2,
	17751: 0x8FF4,
	17752: 0x8FF5,
	17753: 0x8FF6,
	17754: 0x8FFA,
	17755: 0x8FFB,
	17756: 0x8FFC,
	17757: 0x8FFE,
	17758: 0x8FFF,
	17759: 0x9007,
	17760: 0x9008,
	17761: 0x900C,
	17762: 0x900E,
	17763: 0x9013,
	17764: 0x9015,
	17765: 0x9018,
	17766: 0x8556,
	17767: 0x853B,
	17768: 0x84FF,
	17769: 0x84FC,
	17770: 0x8559,
	17771: 0x8548,
	17772: 0x8568,
	17773: 0x8564,
	17774: 0x855E,
	17775: 0x857A,
	17776: 0x77A2,
	17777: 0x8543,
	17778: 0x8572,
	17779: 0x857B,
	17780: 0x85A4,
	17781: 0x85A8,
	17782: 0x8587,
	17783: 0x858F,
	17784: 0x8579,
	17785: 0x85AE,
	17786: 0x859C,
	17787: 0x8585,
	17788: 0x85B9,
	17789: 0x85B7,
	17790: 0x85B0,
	17791: 0x85D3,
	17792: 0x85C1,
	17793: 0x85DC,
	17794: 0x85FF,
	17795: 0x8627,
	17796: 0x8605,
	17797: 0x8629,
	17798: 0x8616,
	17799: 0x863C,
	17800: 0x5EFE,
	17801: 0x5F08,
	17802: 0x593C,
	17803: 0x5941,
	17804: 0x8037,
	17805: 0x5955,
	17806: 0x595A,
	17807: 0x5958,
	17808: 0x530F,
	17809: 0x5C22,
	17810: 0x5C25,
	17811: 0x5C2C,
	17812: 0x5C34,
	17813: 0x624C,
	17814: 0x626A,
	17815: 0x629F,
	17816: 0x62BB,
	17817: 0x62CA,
	17818: 0x62DA,
	17819: 0x62D7,
	17820: 0x62EE,
	17821: 0x6322,
	17822: 0x62F6,
	17823: 0x6339,
	17824: 0x634B,
	17825: 0x6343,
	17826: 0x63AD,
	17827: 0x63F6,
	17828: 0x6371,
	17829: 0x637A,
	17830: 0x638E,
	17831: 0x63B4,
	17832: 0x636D,
	17833: 0x63AC,
	17834: 0x638A,
	17835: 0x6369,
	17836: 0x63AE,
	17837: 0x63BC,
	17838: 0x63F2,
	17839: 0x63F8,
	17840: 0x63E0,
	17841: 0x63FF,
	17842: 0x63C4,
	17843: 0x63DE,
	17844: 0x63CE,
	17845: 0x6452,
	17846: 0x63C6,
	17847: 0x63BE,
	17848: 0x6445,
	17849: 0x6441,
	17850: 0x640B,
	17851: 0x641B,
	17852: 0x6420,
	17853: 0x640C,
	17854: 0x6426,
	17855: 0x6421,
	17856: 0x645E,
	17857: 0x6484,
	17858: 0x646D,
	17859: 0x6496,
	17860: 0x9019,
	17861: 0x901C,
	17862: 0x9023,
	17863: 0x9024,
	17864: 0x9025,
	17865: 0x9027,
	17866: 0x9028,
	17867: 0x9029,
	17868: 0x902A,
	17869: 0x902B,
	17870: 0x902C,
	17871: 0x9030,
	17872: 0x9031,
	17873: 0x9032,
	17874: 0x9033,
	17875: 0x9034,
	17876: 0x9037,
	17877: 0x9039,
	17878: 0x903A,
	17879: 0x903D,
	17880: 0x903F,
	17881: 0x9040,
	17882: 0x9043,
	17883: 0x9045,
	17884: 0x9046,
	17885: 0x9048,
	17886: 0x9049,
	17887: 0x904A,
	17888: 0x904B,
	17889: 0x904C,
	17890: 0x904E,
	17891: 0x9054,
	17892: 0x9055,
	17893: 0x9056,
	17894: 0x9059,
	17895: 0x905A,
	17896: 0x905C,
	17897: 0x905D,
	17898: 0x905E,
	17899: 0x905F,
	17900: 0x9060,
	17901: 0x9061,
	17902: 0x9064,
	17903: 0x9066,
	17904: 0x9067,
	17905: 0x9069,
	17906: 0x906A,
	17907: 0x906B,
	17908: 0x906C,
	17909: 0x906F,
	17910: 0x9070,
	17911: 0x9071,
	17912: 0x9072,
	17913: 0x9073,
	17914: 0x9076,
	17915: 0x9077,
	17916: 0x9078,
	17917: 0x9079,
	17918: 0x907A,
	17919: 0x907B,
	17920: 0x907C,
	17921: 0x907E,
	17922: 0x9081,
	17923: 0x9084,
	17924: 0x9085,
	17925: 0x9086,
	17926: 0x9087,
	17927: 0x9089,
	17928: 0x908A,
	17929: 0x908C,
	17930: 0x908D,
	17931: 0x908E,
	17932: 0x908F,
	17933: 0x9090,
	17934: 0x9092,
	17935: 0x9094,
	17936: 0x9096,
	17937: 0x9098,
	17938: 0x909A,
	17939: 0x909C,
	17940: 0x909E,
	17941: 0x909F,
	17942: 0x90A0,
	17943: 0x90A4,
	17944: 0x90A5,
	17945: 0x90A7,
	17946: 0x90A8,
	17947: 0x90A9,
	17948: 0x90AB,
	17949: 0x90AD,
	17950: 0x90B2,
	17951: 0x90B7,
	17952: 0x90BC,
	17953: 0x90BD,
	17954: 0x90BF,
	17955: 0x90C0,
	17956: 0x647A,
	17957: 0x64B7,
	17958: 0x64B8,
	17959: 0x6499,
	17960: 0x64BA,
	17961: 0x64C0,
	17962: 0x64D0,
	17963: 0x64D7,
	17964: 0x64E4,
	17965: 0x64E2,
	17966: 0x6509,
	17967: 0x6525,
	17968: 0x652E,
	17969: 0x5F0B,
	17970: 0x5FD2,
	17971: 0x7519,
	17972: 0x5F11,
	17973: 0x535F,
	17974: 0x53F1,
	17975: 0x53FD,
	17976: 0x53E9,
	17977: 0x53E8,
	17978: 0x53FB,
	17979: 0x5412,
	17980: 0x5416,
	17981: 0x5406,
	17982: 0x544B,
	17983: 0x5452,
	17984: 0x5453,
	17985: 0x5454,
	17986: 0x5456,
	17987: 0x5443,
	17988: 0x5421,
	17989: 0x5457,
	17990: 0x5459,
	17991: 0x5423,
	17992: 0x5432,
	17993: 0x5482,
	17994: 0x5494,
	17995: 0x5477,
	17996: 0x5471,
	17997: 0x5464,
	17998: 0x549A,
	17999: 0x549B,
	18000: 0x5484,
	18001: 0x5476,
	18002: 0x5466,
	18003: 0x549D,
	18004: 0x54D0,
	18005: 0x54AD,
	18006: 0x54C2,
	18007: 0x54B4,
	18008: 0x54D2,
	18009: 0x54A7,
	18010: 0x54A6,
	18011: 0x54D3,
	18012: 0x54D4,
	18013: 0x5472,
	18014: 0x54A3,
	18015: 0x54D5,
	18016: 0x54BB,
	18017: 0x54BF,
	18018: 0x54CC,
	18019: 0x54D9,
	18020: 0x54DA,
	18021: 0x54DC,
	18022: 0x54A9,
	18023: 0x54AA,
	18024: 0x54A4,
	18025: 0x54DD,
	18026: 0x54CF,
	18027: 0x54DE,
	18028: 0x551B,
	18029: 0x54E7,
	18030: 0x5520,
	18031: 0x54FD,
	18032: 0x5514,
	18033: 0x54F3,
	18034: 0x5522,
	18035: 0x5523,
	18036: 0x550F,
	18037: 0x5511,
	18038: 0x5527,
	18039: 0x552A,
	18040: 0x5567,
	18041: 0x558F,
	18042: 0x55B5,
	18043: 0x5549,
	18044: 0x556D,
	18045: 0x5541,
	18046: 0x5555,
	18047: 0x553F,
	18048: 0x5550,
	18049: 0x553C,
	18050: 0x90C2,
	18051: 0x90C3,
	18052: 0x90C6,
	18053: 0x90C8,
	18054: 0x90C9,
	18055: 0x90CB,
	18056: 0x90CC,
	18057: 0x90CD,
	18058: 0x90D2,
	18059: 0x90D4,
	18060: 0x90D5,
	18061: 0x90D6,
	18062: 0x90D8,
	18063: 0x90D9,
	18064: 0x90DA,
	18065: 0x90DE,
	18066: 0x90DF,
	18067: 0x90E0,
	18068: 0x90E3,
	18069: 0x90E4,
	18070: 0x90E5,
	18071: 0x90E9,
	18072: 0x90EA,
	18073: 0x90EC,
	18074: 0x90EE,
	18075: 0x90F0,
	18076: 0x90F1,
	18077: 0x90F2,
	18078: 0x90F3,
	18079: 0x90F5,
	18080: 0x90F6,
	18081: 0x90F7,
	18082: 0x90F9,
	18083: 0x90FA,
	18084: 0x90FB,
	18085: 0x90FC,
	18086: 0x90FF,
	18087: 0x9100,
	18088: 0x9101,
	18089: 0x9103,
	18090: 0x9105,
	18091: 0x9106,
	18092: 0x9107,
	18093: 0x9108,
	18094: 0x9109,
	18095: 0x910A,
	18096: 0x910B,
	18097: 0x910C,
	18098: 0x910D,
	18099: 0x910E,
	18100: 0x910F,
	18101: 0x9110,
	18102: 0x9111,
	18103: 0x9112,
	18104: 0x9113,
	18105: 0x9114,
	18106: 0x9115,
	18107: 0x9116,
	18108: 0x9117,
	18109: 0x9118,
	18110: 0x911A,
	18111: 0x911B,
	18112: 0x911C,
	18113: 0x911D,
	18114: 0x911F,
	18115: 0x9120,
	18116: 0x9121,
	18117: 0x9124,
	18118: 0x9125,
	18119: 0x9126,
	18120: 0x9127,
	18121: 0x9128,
	18122: 0x9129,
	18123: 0x912A,
	18124: 0x912B,
	18125: 0x912C,
	18126: 0x912D,
	18127: 0x912E,
	18128: 0x9130,
	18129: 0x9132,
	18130: 0x9133,
	18131: 0x9134,
	18132: 0x9135,
	18133: 0x9136,
	18134: 0x9137,
	18135: 0x9138,
	18136: 0x913A,
	18137: 0x913B,
	18138: 0x913C,
	18139: 0x913D,
	18140: 0x913E,
	18141: 0x913F,
	18142: 0x9140,
	18143: 0x9141,
	18144: 0x9142,
	18145: 0x9144,
	18146: 0x5537,
	18147: 0x5556,
	18148: 0x5575,
	18149: 0x5576,
	18150: 0x5577,
	18151: 0x5533,
	18152: 0x5530,
	18153: 0x555C,
	18154: 0x558B,
	18155: 0x55D2,
	18156: 0x5583,
	18157: 0x55B1,
	18158: 0x55B9,
	18159: 0x5588,
	18160: 0x5581,
	18161: 0x559F,
	18162: 0x557E,
	18163: 0x55D6,
	18164: 0x5591,
	18165: 0x557B,
	18166: 0x55DF,
	18167: 0x55BD,
	18168: 0x55BE,
	18169: 0x5594,
	18170: 0x5599,
	18171: 0x55EA,
	18172: 0x55F7,
	18173: 0x55C9,
	18174: 0x561F,
	18175: 0x55D1,
	18176: 0x55EB,
	18177: 0x55EC,
	18178: 0x55D4,
	18179: 0x55E6,
	18180: 0x55DD,
	18181: 0x55C4,
	18182: 0x55EF,
	18183: 0x55E5,
	18184: 0x55F2,
	18185: 0x55F3,
	18186: 0x55CC,
	18187: 0x55CD,
	18188: 0x55E8,
	18189: 0x55F5,
	18190: 0x55E4,
	18191: 0x8F94,
	18192: 0x561E,
	18193: 0x5608,
	18194: 0x560C,
	18195: 0x5601,
	18196: 0x5624,
	18197: 0x5623,
	18198: 0x55FE,
	18199: 0x5600,
	18200: 0x5627,
	18201: 0x562D,
	18202: 0x5658,
	18203: 0x5639,
	18204: 0x5657,
	18205: 0x562C,
	18206: 0x564D,
	18207: 0x5662,
	18208: 0x5659,
	18209: 0x565C,
	18210: 0x564C,
	18211: 0x5654,
	18212: 0x5686,
	18213: 0x5664,
	18214: 0x5671,
	18215: 0x566B,
	18216: 0x567B,
	18217: 0x567C,
	18218: 0x5685,
	18219: 0x5693,
	18220: 0x56AF,
	18221: 0x56D4,
	18222: 0x56D7,
	18223: 0x56DD,
	18224: 0x56E1,
	18225: 0x56F5,
	18226: 0x56EB,
	18227: 0x56F9,
	18228: 0x56FF,
	18229: 0x5704,
	18230: 0x570A,
	18231: 0x5709,
	18232: 0x571C,
	18233: 0x5E0F,
	18234: 0x5E19,
	18235: 0x5E14,
	18236: 0x5E11,
	18237: 0x5E31,
	18238: 0x5E3B,
	18239: 0x5E3C,
	18240: 0x9145,
	18241: 0x9147,
	18242: 0x9148,
	18243: 0x9151,
	18244: 0x9153,
	18245: 0x9154,
	18246: 0x9155,
	18247: 0x9156,
	18248: 0x9158,
	18249: 0x9159,
	18250: 0x915B,
	18251: 0x915C,
	18252: 0x915F,
	18253: 0x9160,
	18254: 0x9166,
	18255: 0x9167,
	18256: 0x9168,
	18257: 0x916B,
	18258: 0x916D,
	18259: 0x9173,
	18260: 0x917A,
	18261: 0x917B,
	18262: 0x917C,
	18263: 0x9180,
	18264: 0x9181,
	18265: 0x9182,
	18266: 0x9183,
	18267: 0x9184,
	18268: 0x9186,
	18269: 0x9188,
	18270: 0x918A,
	18271: 0x918E,
	18272: 0x918F,
	18273: 0x9193,
	18274: 0x9194,
	18275: 0x9195,
	18276: 0x9196,
	18277: 0x9197,
	18278: 0x9198,
	18279: 0x9199,
	18280: 0x919C,
	18281: 0x919D,
	18282: 0x919E,
	18283: 0x919F,
	18284: 0x91A0,
	18285: 0x91A1,
	18286: 0x91A4,
	18287: 0x91A5,
	18288: 0x91A6,
	18289: 0x91A7,
	18290: 0x91A8,
	18291: 0x91A9,
	18292: 0x91AB,
	18293: 0x91AC,
	18294: 0x91B0,
	18295: 0x91B1,
	18296: 0x91B2,
	18297: 0x91B3,
	18298: 0x91B6,
	18299: 0x91B7,
	18300: 0x91B8,
	18301: 0x91B9,
	18302: 0x91BB,
	18303: 0x91BC,
	18304: 0x91BD,
	18305: 0x91BE,
	18306: 0x91BF,
	18307: 0x91C0,
	18308: 0x91C1,
	18309: 0x91C2,
	18310: 0x91C3,
	18311: 0x91C4,
	18312: 0x91C5,
	18313: 0x91C6,
	18314: 0x91C8,
	18315: 0x91CB,
	18316: 0x91D0,
	18317: 0x91D2,
	18318: 0x91D3,
	18319: 0x91D4,
	18320: 0x91D5,
	18321: 0x91D6,
	18322: 0x91D7,
	18323: 0x91D8,
	18324: 0x91D9,
	18325: 0x91DA,
	18326: 0x91DB,
	18327: 0x91DD,
	18328: 0x91DE,
	18329: 0x91DF,
	18330: 0x91E0,
	18331: 0x91E1,
	18332: 0x91E2,
	18333: 0x91E3,
	18334: 0x91E4,
	18335: 0x91E5,
	18336: 0x5E37,
	18337: 0x5E44,
	18338: 0x5E54,
	18339: 0x5E5B,
	18340: 0x5E5E,
	18341: 0x5E61,
	18342: 0x5C8C,
	18343: 0x5C7A,
	18344: 0x5C8D,
	18345: 0x5C90,
	18346: 0x5C96,
	18347: 0x5C88,
	18348: 0x5C98,
	18349: 0x5C99,
	18350: 0x5C91,
	18351: 0x5C9A,
	18352: 0x5C9C,
	18353: 0x5CB5,
	18354: 0x5CA2,
	18355: 0x5CBD,
	18356: 0x5CAC,
	18357: 0x5CAB,
	18358: 0x5CB1,
	18359: 0x5CA3,
	18360: 0x5CC1,
	18361: 0x5CB7,
	18362: 0x5CC4,
	18363: 0x5CD2,
	18364: 0x5CE4,
	18365: 0x5CCB,
	18366: 0x5CE5,
	18367: 0x5D02,
	18368: 0x5D03,
	18369: 0x5D27,
	18370: 0x5D26,
	18371: 0x5D2E,
	18372: 0x5D24,
	18373: 0x5D1E,
	18374: 0x5D06,
	18375: 0x5D1B,
	18376: 0x5D58,
	18377: 0x5D3E,
	18378: 0x5D34,
	18379: 0x5D3D,
	18380: 0x5D6C,
	18381: 0x5D5B,
	18382: 0x5D6F,
	18383: 0x5D5D,
	18384: 0x5D6B,
	18385: 0x5D4B,
	18386: 0x5D4A,
	18387: 0x5D69,
	18388: 0x5D74,
	18389: 0x5D82,
	18390: 0x5D99,
	18391: 0x5D9D,
	18392: 0x8C73,
	18393: 0x5DB7,
	18394: 0x5DC5,
	18395: 0x5F73,
	18396: 0x5F77,
	18397: 0x5F82,
	18398: 0x5F87,
	18399: 0x5F89,
	18400: 0x5F8C,
	18401: 0x5F95,
	18402: 0x5F99,
	18403: 0x5F9C,
	18404: 0x5FA8,
	18405: 0x5FAD,
	18406: 0x5FB5,
	18407: 0x5FBC,
	18408: 0x8862,
	18409: 0x5F61,
	18410: 0x72AD,
	18411: 0x72B0,
	18412: 0x72B4,
	18413: 0x72B7,
	18414: 0x72B8,
	18415: 0x72C3,
	18416: 0x72C1,
	18417: 0x72CE,
	18418: 0x72CD,
	18419: 0x72D2,
	18420: 0x72E8,
	18421: 0x72EF,
	18422: 0x72E9,
	18423: 0x72F2,
	18424: 0x72F4,
	18425: 0x72F7,
	18426: 0x7301,
	18427: 0x72F3,
	18428: 0x7303,
	18429: 0x72FA,
	18430: 0x91E6,
	18431: 0x91E7,
	18432: 0x91E8,
	18433: 0x91E9,
	18434: 0x91EA,
	18435: 0x91EB,
	18436: 0x91EC,
	18437: 0x91ED,
	18438: 0x91EE,
	18439: 0x91EF,
	18440: 0x91F0,
	18441: 0x91F1,
	18442: 0x91F2,
	18443: 0x91F3,
	18444: 0x91F4,
	18445: 0x91F5,
	18446: 0x91F6,
	18447: 0x91F7,
	18448: 0x91F8,
	18449: 0x91F9,
	18450: 0x91FA,
	18451: 0x91FB,
	18452: 0x91FC,
	18453: 0x91FD,
	18454: 0x91FE,
	18455: 0x91FF,
	18456: 0x9200,
	18457: 0x9201,
	18458: 0x9202,
	18459: 0x9203,
	18460: 0x9204,
	18461: 0x9205,
	18462: 0x9206,
	18463: 0x9207,
	18464: 0x9208,
	18465: 0x9209,
	18466: 0x920A,
	18467: 0x920B,
	18468: 0x920C,
	18469: 0x920D,
	18470: 0x920E,
	18471: 0x920F,
	18472: 0x9210,
	18473: 0x9211,
	18474: 0x9212,
	18475: 0x9213,
	18476: 0x9214,
	18477: 0x9215,
	18478: 0x9216,
	18479: 0x9217,
	18480: 0x9218,
	18481: 0x9219,
	18482: 0x921A,
	18483: 0x921B,
	18484: 0x921C,
	18485: 0x921D,
	18486: 0x921E,
	18487: 0x921F,
	18488: 0x9220,
	18489: 0x9221,
	18490: 0x9222,
	18491: 0x9223,
	18492: 0x9224,
	18493: 0x9225,
	18494: 0x9226,
	18495: 0x9227,
	18496: 0x9228,
	18497: 0x9229,
	18498: 0x922A,
	18499: 0x922B,
	18500: 0x922C,
	18501: 0x922D,
	18502: 0x922E,
	18503: 0x922F,
	18504: 0x9230,
	18505: 0x9231,
	18506: 0x9232,
	18507: 0x9233,
	18508: 0x9234,
	18509: 0x9235,
	18510: 0x9236,
	18511: 0x9237,
	18512: 0x9238,
	18513: 0x9239,
	18514: 0x923A,
	18515: 0x923B,
	18516: 0x923C,
	18517: 0x923D,
	18518: 0x923E,
	18519: 0x923F,
	18520: 0x9240,
	18521: 0x9241,
	18522: 0x9242,
	18523: 0x9243,
	18524: 0x9244,
	18525: 0x9245,
	18526: 0x72FB,
	18527: 0x7317,
	18528: 0x7313,
	18529: 0x7321,
	18530: 0x730A,
	18531: 0x731E,
	18532: 0x731D,
	18533: 0x7315,
	18534: 0x7322,
	18535: 0x7339,
	18536: 0x7325,
	18537: 0x732C,
	18538: 0x7338,
	18539: 0x7331,
	18540: 0x7350,
	18541: 0x734D,
	18542: 0x7357,
	18543: 0x7360,
	18544: 0x736C,
	18545: 0x736F,
	18546: 0x737E,
	18547: 0x821B,
	18548: 0x5925,
	18549: 0x98E7,
	18550: 0x5924,
	18551: 0x5902,
	18552: 0x9963,
	18553: 0x9967,
	18554: 0x9968,
	18555: 0x9969,
	18556: 0x996A,
	18557: 0x996B,
	18558: 0x996C,
	18559: 0x9974,
	18560: 0x9977,
	18561: 0x997D,
	18562: 0x9980,
	18563: 0x9984,
	18564: 0x9987,
	18565: 0x998A,
	18566: 0x998D,
	18567: 0x9990,
	18568: 0x9991,
	18569: 0x9993,
	18570: 0x9994,
	18571: 0x9995,
	18572: 0x5E80,
	18573: 0x5E91,
	18574: 0x5E8B,
	18575: 0x5E96,
	18576: 0x5EA5,
	18577: 0x5EA0,
	18578: 0x5EB9,
	18579: 0x5EB5,
	18580: 0x5EBE,
	18581: 0x5EB3,
	18582: 0x8D53,
	18583: 0x5ED2,
	18584: 0x5ED1,
	18585: 0x5EDB,
	18586: 0x5EE8,
	18587: 0x5EEA,
	18588: 0x81BA,
	18589: 0x5FC4,
	18590: 0x5FC9,
	18591: 0x5FD6,
	18592: 0x5FCF,
	18593: 0x6003,
	18594: 0x5FEE,
	18595: 0x6004,
	18596: 0x5FE1,
	18597: 0x5FE4,
	18598: 0x5FFE,
	18599: 0x6005,
	18600: 0x6006,
	18601: 0x5FEA,
	18602: 0x5FED,
	18603: 0x5FF8,
	18604: 0x6019,
	18605: 0x6035,
	18606: 0x6026,
	18607: 0x601B,
	18608: 0x600F,
	18609: 0x600D,
	18610: 0x6029,
	18611: 0x602B,
	18612: 0x600A,
	18613: 0x603F,
	18614: 0x6021,
	18615: 0x6078,
	18616: 0x6079,
	18617: 0x607B,
	18618: 0x607A,
	18619: 0x6042,
	18620: 0x9246,
	18621: 0x9247,
	18622: 0x9248,
	18623: 0x9249,
	18624: 0x924A,
	18625: 0x924B,
	18626: 0x924C,
	18627: 0x924D,
	18628: 0x924E,
	18629: 0x924F,
	18630: 0x9250,
	18631: 0x9251,
	18632: 0x9252,
	18633: 0x9253,
	18634: 0x9254,
	18635: 0x9255,
	18636: 0x9256,
	18637: 0x9257,
	18638: 0x9258,
	18639: 0x9259,
	18640: 0x925A,
	18641: 0x925B,
	18642: 0x925C,
	18643: 0x925D,
	18644: 0x925E,
	18645: 0x925F,
	18646: 0x9260,
	18647: 0x9261,
	18648: 0x9262,
	18649: 0x9263,
	18650: 0x9264,
	18651: 0x9265,
	18652: 0x9266,
	18653: 0x9267,
	18654: 0x9268,
	18655: 0x9269,
	18656: 0x926A,
	18657: 0x926B,
	18658: 0x926C,
	18659: 0x926D,
	18660: 0x926E,
	18661: 0x926F,
	18662: 0x9270,
	18663: 0x9271,
	18664: 0x9272,
	18665: 0x9273,
	18666: 0x9275,
	18667: 0x9276,
	18668: 0x9277,
	18669: 0x9278,
	18670: 0x9279,
	18671: 0x927A,
	18672: 0x927B,
	18673: 0x927C,
	18674: 0x927D,
	18675: 0x927E,
	18676: 0x927F,
	18677: 0x9280,
	18678: 0x9281,
	18679: 0x9282,
	18680: 0x9283,
	18681: 0x9284,
	18682: 0x9285,
	18683: 0x9286,
	18684: 0x9287,
	18685: 0x9288,
	18686: 0x9289,
	18687: 0x928A,
	18688: 0x928B,
	18689: 0x928C,
	18690: 0x928D,
	18691: 0x928F,
	18692: 0x9290,
	18693: 0x9291,
	18694: 0x9292,
	18695: 0x9293,
	18696: 0x9294,
	18697: 0x9295,
	18698: 0x9296,
	18699: 0x9297,
	18700: 0x9298,
	18701: 0x9299,
	18702: 0x929A,
	18703: 0x929B,
	18704: 0x929C,
	18705: 0x929D,
	18706: 0x929E,
	18707: 0x929F,
	18708: 0x92A0,
	18709: 0x92A1,
	18710: 0x92A2,
	18711: 0x92A3,
	18712: 0x92A4,
	18713: 0x92A5,
	18714: 0x92A6,
	18715: 0x92A7,
	18716: 0x606A,
	18717: 0x607D,
	18718: 0x6096,
	18719: 0x609A,
	18720: 0x60AD,
	18721: 0x609D,
	18722: 0x6083,
	18723: 0x6092,
	18724: 0x608C,
	18725: 0x609B,
	18726: 0x60EC,
	18727: 0x60BB,
	18728: 0x60B1,
	18729: 0x60DD,
	18730: 0x60D8,
	18731: 0x60C6,
	18732: 0x60DA,
	18733: 0x60B4,
	18734: 0x6120,
	18735: 0x6126,
	18736: 0x6115,
	18737: 0x6123,
	18738: 0x60F4,
	18739: 0x6100,
	18740: 0x610E,
	18741: 0x612B,
	18742: 0x614A,
	18743: 0x6175,
	18744: 0x61AC,
	18745: 0x6194,
	18746: 0x61A7,
	18747: 0x61B7,
	18748: 0x61D4,
	18749: 0x61F5,
	18750: 0x5FDD,
	18751: 0x96B3,
	18752: 0x95E9,
	18753: 0x95EB,
	18754: 0x95F1,
	18755: 0x95F3,
	18756: 0x95F5,
	18757: 0x95F6,
	18758: 0x95FC,
	18759: 0x95FE,
	18760: 0x9603,
	18761: 0x9604,
	18762: 0x9606,
	18763: 0x9608,
	18764: 0x960A,
	18765: 0x960B,
	18766: 0x960C,
	18767: 0x960D,
	18768: 0x960F,
	18769: 0x9612,
	18770: 0x9615,
	18771: 0x9616,
	18772: 0x9617,
	18773: 0x9619,
	18774: 0x961A,
	18775: 0x4E2C,
	18776: 0x723F,
	18777: 0x6215,
	18778: 0x6C35,
	18779: 0x6C54,
	18780: 0x6C5C,
	18781: 0x6C4A,
	18782: 0x6CA3,
	18783: 0x6C85,
	18784: 0x6C90,
	18785: 0x6C94,
	18786: 0x6C8C,
	18787: 0x6C68,
	18788: 0x6C69,
	18789: 0x6C74,
	18790: 0x6C76,
	18791: 0x6C86,
	18792: 0x6CA9,
	18793: 0x6CD0,
	18794: 0x6CD4,
	18795: 0x6CAD,
	18796: 0x6CF7,
	18797: 0x6CF8,
	18798: 0x6CF1,
	18799: 0x6CD7,
	18800: 0x6CB2,
	18801: 0x6CE0,
	18802: 0x6CD6,
	18803: 0x6CFA,
	18804: 0x6CEB,
	18805: 0x6CEE,
	18806: 0x6CB1,
	18807: 0x6CD3,
	18808: 0x6CEF,
	18809: 0x6CFE,
	18810: 0x92A8,
	18811: 0x92A9,
	18812: 0x92AA,
	18813: 0x92AB,
	18814: 0x92AC,
	18815: 0x92AD,
	18816: 0x92AF,
	18817: 0x92B0,
	18818: 0x92B1,
	18819: 0x92B2,
	18820: 0x92B3,
	18821: 0x92B4,
	18822: 0x92B5,
	18823: 0x92B6,
	18824: 0x92B7,
	18825: 0x92B8,
	18826: 0x92B9,
	18827: 0x92BA,
	18828: 0x92BB,
	18829: 0x92BC,
	18830: 0x92BD,
	18831: 0x92BE,
	18832: 0x92BF,
	18833: 0x92C0,
	18834: 0x92C1,
	18835: 0x92C2,
	18836: 0x92C3,
	18837: 0x92C4,
	18838: 0x92C5,
	18839: 0x92C6,
	18840: 0x92C7,
	18841: 0x92C9,
	18842: 0x92CA,
	18843: 0x92CB,
	18844: 0x92CC,
	18845: 0x92CD,
	18846: 0x92CE,
	18847: 0x92CF,
	18848: 0x92D0,
	18849: 0x92D1,
	18850: 0x92D2,
	18851: 0x92D3,
	18852: 0x92D4,
	18853: 0x92D5,
	18854: 0x92D6,
	18855: 0x92D7,
	18856: 0x92D8,
	18857: 0x92D9,
	18858: 0x92DA,
	18859: 0x92DB,
	18860: 0x92DC,
	18861: 0x92DD,
	18862: 0x92DE,
	18863: 0x92DF,
	18864: 0x92E0,
	18865: 0x92E1,
	18866: 0x92E2,
	18867: 0x92E3,
	18868: 0x92E4,
	18869: 0x92E5,
	18870: 0x92E6,
	18871: 0x92E7,
	18872: 0x92E8,
	18873: 0x92E9,
	18874: 0x92EA,
	18875: 0x92EB,
	18876: 0x92EC,
	18877: 0x92ED,
	18878: 0x92EE,
	18879: 0x92EF,
	18880: 0x92F0,
	18881: 0x92F1,
	18882: 0x92F2,
	18883: 0x92F3,
	18884: 0x92F4,
	18885: 0x92F5,
	18886: 0x92F6,
	18887: 0x92F7,
	18888: 0x92F8,
	18889: 0x92F9,
	18890: 0x92FA,
	18891: 0x92FB,
	18892: 0x92FC,
	18893: 0x92FD,
	18894: 0x92FE,
	18895: 0x92FF,
	18896: 0x9300,
	18897: 0x9301,
	18898: 0x9302,
	18899: 0x9303,
	18900: 0x9304,
	18901: 0x9305,
	18902: 0x9306,
	18903: 0x9307,
	18904: 0x9308,
	18905: 0x9309,
	18906: 0x6D39,
	18907: 0x6D27,
	18908: 0x6D0C,
	18909: 0x6D43,
	18910: 0x6D48,
	18911: 0x6D07,
	18912: 0x6D04,
	18913: 0x6D19,
	18914: 0x6D0E,
	18915: 0x6D2B,
	18916: 0x6D4D,
	18917: 0x6D2E,
	18918: 0x6D35,
	18919: 0x6D1A,
	18920: 0x6D4F,
	18921: 0x6D52,
	18922: 0x6D54,
	18923: 0x6D33,
	18924: 0x6D91,
	18925: 0x6D6F,
	18926: 0x6D9E,
	18927: 0x6DA0,
	18928: 0x6D5E,
	18929: 0x6D93,
	18930: 0x6D94,
	18931: 0x6D5C,
	18932: 0x6D60,
	18933: 0x6D7C,
	18934: 0x6D63,
	18935: 0x6E1A,
	18936: 0x6DC7,
	18937: 0x6DC5,
	18938: 0x6DDE,
	18939: 0x6E0E,
	18940: 0x6DBF,
	18941: 0x6DE0,
	18942: 0x6E11,
	18943: 0x6DE6,
	18944: 0x6DDD,
	18945: 0x6DD9,
	18946: 0x6E16,
	18947: 0x6DAB,
	18948: 0x6E0C,
	18949: 0x6DAE,
	18950: 0x6E2B,
	18951: 0x6E6E,
	18952: 0x6E4E,
	18953: 0x6E6B,
	18954: 0x6EB2,
	18955: 0x6E5F,
	18956: 0x6E86,
	18957: 0x6E53,
	18958: 0x6E54,
	18959: 0x6E32,
	18960: 0x6E25,
	18961: 0x6E44,
	18962: 0x6EDF,
	18963: 0x6EB1,
	18964: 0x6E98,
	18965: 0x6EE0,
	18966: 0x6F2D,
	18967: 0x6EE2,
	18968: 0x6EA5,
	18969: 0x6EA7,
	18970: 0x6EBD,
	18971: 0x6EBB,
	18972: 0x6EB7,
	18973: 0x6ED7,
	18974: 0x6EB4,
	18975: 0x6ECF,
	18976: 0x6E8F,
	18977: 0x6EC2,
	18978: 0x6E9F,
	18979: 0x6F62,
	18980: 0x6F46,
	18981: 0x6F47,
	18982: 0x6F24,
	18983: 0x6F15,
	18984: 0x6EF9,
	18985: 0x6F2F,
	18986: 0x6F36,
	18987: 0x6F4B,
	18988: 0x6F74,
	18989: 0x6F2A,
	18990: 0x6F09,
	18991: 0x6F29,
	18992: 0x6F89,
	18993: 0x6F8D,
	18994: 0x6F8C,
	18995: 0x6F78,
	18996: 0x6F72,
	18997: 0x6F7C,
	18998: 0x6F7A,
	18999: 0x6FD1,
	19000: 0x930A,
	19001: 0x930B,
	19002: 0x930C,
	19003: 0x930D,
	19004: 0x930E,
	19005: 0x930F,
	19006: 0x9310,
	19007: 0x9311,
	19008: 0x9312,
	19009: 0x9313,
	19010: 0x9314,
	19011: 0x9315,
	19012: 0x9316,
	19013: 0x9317,
	19014: 0x9318,
	19015: 0x9319,
	19016: 0x931A,
	19017: 0x931B,
	19018: 0x931C,
	19019: 0x931D,
	19020: 0x931E,
	19021: 0x931F,
	19022: 0x9320,
	19023: 0x9321,
	19024: 0x9322,
	19025: 0x9323,
	19026: 0x9324,
	19027: 0x9325,
	19028: 0x9326,
	19029: 0x9327,
	19030: 0x9328,
	19031: 0x9329,
	19032: 0x932A,
	19033: 0x932B,
	19034: 0x932C,
	19035: 0x932D,
	19036: 0x932E,
	19037: 0x932F,
	19038: 0x9330,
	19039: 0x9331,
	19040: 0x9332,
	19041: 0x9333,
	19042: 0x9334,
	19043: 0x9335,
	19044: 0x9336,
	19045: 0x9337,
	19046: 0x9338,
	19047: 0x9339,
	19048: 0x933A,
	19049: 0x933B,
	19050: 0x933C,
	19051: 0x933D,
	19052: 0x933F,
	19053: 0x9340,
	19054: 0x9341,
	19055: 0x9342,
	19056: 0x9343,
	19057: 0x9344,
	19058: 0x9345,
	19059: 0x9346,
	19060: 0x9347,
	19061: 0x9348,
	19062: 0x9349,
	19063: 0x934A,
	19064: 0x934B,
	19065: 0x934C,
	19066: 0x934D,
	19067: 0x934E,
	19068: 0x934F,
	19069: 0x9350,
	19070: 0x9351,
	19071: 0x9352,
	19072: 0x9353,
	19073: 0x9354,
	19074: 0x9355,
	19075: 0x9356,
	19076: 0x9357,
	19077: 0x9358,
	19078: 0x9359,
	19079: 0x935A,
	19080: 0x935B,
	19081: 0x935C,
	19082: 0x935D,
	19083: 0x935E,
	19084: 0x935F,
	19085: 0x9360,
	19086: 0x9361,
	19087: 0x9362,
	19088: 0x9363,
	19089: 0x9364,
	19090: 0x9365,
	19091: 0x9366,
	19092: 0x9367,
	19093: 0x9368,
	19094: 0x9369,
	19095: 0x936B,
	19096: 0x6FC9,
	19097: 0x6FA7,
	19098: 0x6FB9,
	19099: 0x6FB6,
	19100: 0x6FC2,
	19101: 0x6FE1,
	19102: 0x6FEE,
	19103: 0x6FDE,
	19104: 0x6FE0,
	19105: 0x6FEF,
	19106: 0x701A,
	19107: 0x7023,
	19108: 0x701B,
	19109: 0x7039,
	19110: 0x7035,
	19111: 0x704F,
	19112: 0x705E,
	19113: 0x5B80,
	19114: 0x5B84,
	19115: 0x5B95,
	19116: 0x5B93,
	19117: 0x5BA5,
	19118: 0x5BB8,
	19119: 0x752F,
	19120: 0x9A9E,
	19121: 0x6434,
	19122: 0x5BE4,
	19123: 0x5BEE,
	19124: 0x8930,
	19125: 0x5BF0,
	19126: 0x8E47,
	19127: 0x8B07,
	19128: 0x8FB6,
	19129: 0x8FD3,
	19130: 0x8FD5,
	19131: 0x8FE5,
	19132: 0x8FEE,
	19133: 0x8FE4,
	19134: 0x8FE9,
	19135: 0x8FE6,
	19136: 0x8FF3,
	19137: 0x8FE8,
	19138: 0x9005,
	19139: 0x9004,
	19140: 0x900B,
	19141: 0x9026,
	19142: 0x9011,
	19143: 0x900D,
	19144: 0x9016,
	19145: 0x9021,
	19146: 0x9035,
	19147: 0x9036,
	19148: 0x902D,
	19149: 0x902F,
	19150: 0x9044,
	19151: 0x9051,
	19152: 0x9052,
	19153: 0x9050,
	19154: 0x9068,
	19155: 0x9058,
	19156: 0x9062,
	19157: 0x905B,
	19158: 0x66B9,
	19159: 0x9074,
	19160: 0x907D,
	19161: 0x9082,
	19162: 0x9088,
	19163: 0x9083,
	19164: 0x908B,
	19165: 0x5F50,
	19166: 0x5F57,
	19167: 0x5F56,
	19168: 0x5F58,
	19169: 0x5C3B,
	19170: 0x54AB,
	19171: 0x5C50,
	19172: 0x5C59,
	19173: 0x5B71,
	19174: 0x5C63,
	19175: 0x5C66,
	19176: 0x7FBC,
	19177: 0x5F2A,
	19178: 0x5F29,
	19179: 0x5F2D,
	19180: 0x8274,
	19181: 0x5F3C,
	19182: 0x9B3B,
	19183: 0x5C6E,
	19184: 0x5981,
	19185: 0x5983,
	19186: 0x598D,
	19187: 0x59A9,
	19188: 0x59AA,
	19189: 0x59A3,
	19190: 0x936C,
	19191: 0x936D,
	19192: 0x936E,
	19193: 0x936F,
	19194: 0x9370,
	19195: 0x9371,
	19196: 0x9372,
	19197: 0x9373,
	19198: 0x9374,
	19199: 0x9375,
	19200: 0x9376,
	19201: 0x9377,
	19202: 0x9378,
	19203: 0x9379,
	19204: 0x937A,
	19205: 0x937B,
	19206: 0x937C,
	19207: 0x937D,
	19208: 0x937E,
	19209: 0x937F,
	19210: 0x9380,
	19211: 0x9381,
	19212: 0x9382,
	19213: 0x9383,
	19214: 0x9384,
	19215: 0x9385,
	19216: 0x9386,
	19217: 0x9387,
	19218: 0x9388,
	19219: 0x9389,
	19220: 0x938A,
	19221: 0x938B,
	19222: 0x938C,
	19223: 0x938D,
	19224: 0x938E,
	19225: 0x9390,
	19226: 0x9391,
	19227: 0x9392,
	19228: 0x9393,
	19229: 0x9394,
	19230: 0x9395,
	19231: 0x9396,
	19232: 0x9397,
	19233: 0x9398,
	19234: 0x9399,
	19235: 0x939A,
	19236: 0x939B,
	19237: 0x939C,
	19238: 0x939D,
	19239: 0x939E,
	19240: 0x939F,
	19241: 0x93A0,
	19242: 0x93A1,
	19243: 0x93A2,
	19244: 0x93A3,
	19245: 0x93A4,
	19246: 0x93A5,
	19247: 0x93A6,
	19248: 0x93A7,
	19249: 0x93A8,
	19250: 0x93A9,
	19251: 0x93AA,
	19252: 0x93AB,
	19253: 0x93AC,
	19254: 0x93AD,
	19255: 0x93AE,
	19256: 0x93AF,
	19257: 0x93B0,
	19258: 0x93B1,
	19259: 0x93B2,
	19260: 0x93B3,
	19261: 0x93B4,
	19262: 0x93B5,
	19263: 0x93B6,
	19264: 0x93B7,
	19265: 0x93B8,
	19266: 0x93B9,
	19267: 0x93BA,
	19268: 0x93BB,
	19269: 0x93BC,
	19270: 0x93BD,
	19271: 0x93BE,
	19272: 0x93BF,
	19273: 0x93C0,
	19274: 0x93C1,
	19275: 0x93C2,
	19276: 0x93C3,
	19277: 0x93C4,
	19278: 0x93C5,
	19279: 0x93C6,
	19280: 0x93C7,
	19281: 0x93C8,
	19282: 0x93C9,
	19283: 0x93CB,
	19284: 0x93CC,
	19285: 0x93CD,
	19286: 0x5997,
	19287: 0x59CA,
	19288: 0x59AB,
	19289: 0x599E,
	19290: 0x59A4,
	19291: 0x59D2,
	19292: 0x59B2,
	19293: 0x59AF,
	19294: 0x59D7,
	19295: 0x59BE,
	19296: 0x5A05,
	19297: 0x5A06,
	19298: 0x59DD,
	19299: 0x5A08,
	19300: 0x59E3,
	19301: 0x59D8,
	19302: 0x59F9,
	19303: 0x5A0C,
	19304: 0x5A09,
	19305: 0x5A32,
	19306: 0x5A34,
	19307: 0x5A11,
	19308: 0x5A23,
	19309: 0x5A13,
	19310: 0x5A40,
	19311: 0x5A67,
	19312: 0x5A4A,
	19313: 0x5A55,
	19314: 0x5A3C,
	19315: 0x5A62,
	19316: 0x5A75,
	19317: 0x80EC,
	19318: 0x5AAA,
	19319: 0x5A9B,
	19320: 0x5A77,
	19321: 0x5A7A,
	19322: 0x5ABE,
	19323: 0x5AEB,
	19324: 0x5AB2,
	19325: 0x5AD2,
	19326: 0x5AD4,
	19327: 0x5AB8,
	19328: 0x5AE0,
	19329: 0x5AE3,
	19330: 0x5AF1,
	19331: 0x5AD6,
	19332: 0x5AE6,
	19333: 0x5AD8,
	19334: 0x5ADC,
	19335: 0x5B09,
	19336: 0x5B17,
	19337: 0x5B16,
	19338: 0x5B32,
	19339: 0x5B37,
	19340: 0x5B40,
	19341: 0x5C15,
	19342: 0x5C1C,
	19343: 0x5B5A,
	19344: 0x5B65,
	19345: 0x5B73,
	19346: 0x5B51,
	19347: 0x5B53,
	19348: 0x5B62,
	19349: 0x9A75,
	19350: 0x9A77,
	19351: 0x9A78,
	19352: 0x9A7A,
	19353: 0x9A7F,
	19354: 0x9A7D,
	19355: 0x9A80,
	19356: 0x9A81,
	19357: 0x9A85,
	19358: 0x9A88,
	19359: 0x9A8A,
	19360: 0x9A90,
	19361: 0x9A92,
	19362: 0x9A93,
	19363: 0x9A96,
	19364: 0x9A98,
	19365: 0x9A9B,
	19366: 0x9A9C,
	19367: 0x9A9D,
	19368: 0x9A9F,
	19369: 0x9AA0,
	19370: 0x9AA2,
	19371: 0x9AA3,
	19372: 0x9AA5,
	19373: 0x9AA7,
	19374: 0x7E9F,
	19375: 0x7EA1,
	19376: 0x7EA3,
	19377: 0x7EA5,
	19378: 0x7EA8,
	19379: 0x7EA9,
	19380: 0x93CE,
	19381: 0x93CF,
	19382: 0x93D0,
	19383: 0x93D1,
	19384: 0x93D2,
	19385: 0x93D3,
	19386: 0x93D4,
	19387: 0x93D5,
	19388: 0x93D7,
	19389: 0x93D8,
	19390: 0x93D9,
	19391: 0x93DA,
	19392: 0x93DB,
	19393: 0x93DC,
	19394: 0x93DD,
	19395: 0x93DE,
	19396: 0x93DF,
	19397: 0x93E0,
	19398: 0x93E1,
	19399: 0x93E2,
	19400: 0x93E3,
	19401: 0x93E4,
	19402: 0x93E5,
	19403: 0x93E6,
	19404: 0x93E7,
	19405: 0x93E8,
	19406: 0x93E9,
	19407: 0x93EA,
	19408: 0x93EB,
	19409: 0x93EC,
	19410: 0x93ED,
	19411: 0x93EE,
	19412: 0x93EF,
	19413: 0x93F0,
	19414: 0x93F1,
	19415: 0x93F2,
	19416: 0x93F3,
	19417: 0x93F4,
	19418: 0x93F5,
	19419: 0x93F6,
	19420: 0x93F7,
	19421: 0x93F8,
	19422: 0x93F9,
	19423: 0x93FA,
	19424: 0x93FB,
	19425: 0x93FC,
	19426: 0x93FD,
	19427: 0x93FE,
	19428: 0x93FF,
	19429: 0x9400,
	19430: 0x9401,
	19431: 0x9402,
	19432: 0x9403,
	19433: 0x9404,
	19434: 0x9405,
	19435: 0x9406,
	19436: 0x9407,
	19437: 0x9408,
	19438: 0x9409,
	19439: 0x940A,
	19440: 0x940B,
	19441: 0x940C,
	19442: 0x940D,
	19443: 0x940E,
	19444: 0x940F,
	19445: 0x9410,
	19446: 0x9411,
	19447: 0x9412,
	19448: 0x9413,
	19449: 0x9414,
	19450: 0x9415,
	19451: 0x9416,
	19452: 0x9417,
	19453: 0x9418,
	19454: 0x9419,
	19455: 0x941A,
	19456: 0x941B,
	19457: 0x941C,
	19458: 0x941D,
	19459: 0x941E,
	19460: 0x941F,
	19461: 0x9420,
	19462: 0x9421,
	19463: 0x9422,
	19464: 0x9423,
	19465: 0x9424,
	19466: 0x9425,
	19467: 0x9426,
	19468: 0x9427,
	19469: 0x9428,
	19470: 0x9429,
	19471: 0x942A,
	19472: 0x942B,
	19473: 0x942C,
	19474: 0x942D,
	19475: 0x942E,
	19476: 0x7EAD,
	19477: 0x7EB0,
	19478: 0x7EBE,
	19479: 0x7EC0,
	19480: 0x7EC1,
	19481: 0x7EC2,
	19482: 0x7EC9,
	19483: 0x7ECB,
	19484: 0x7ECC,
	19485: 0x7ED0,
	19486: 0x7ED4,
	19487: 0x7ED7,
	19488: 0x7EDB,
	19489: 0x7EE0,
	19490: 0x7EE1,
	19491: 0x7EE8,
	19492: 0x7EEB,
	19493: 0x7EEE,
	19494: 0x7EEF,
	19495: 0x7EF1,
	19496: 0x7EF2,
	19497: 0x7F0D,
	19498: 0x7EF6,
	19499: 0x7EFA,
	19500: 0x7EFB,
	19501: 0x7EFE,
	19502: 0x7F01,
	19503: 0x7F02,
	19504: 0x7F03,
	19505: 0x7F07,
	19506: 0x7F08,
	19507: 0x7F0B,
	19508: 0x7F0C,
	19509: 0x7F0F,
	19510: 0x7F11,
	19511: 0x7F12,
	19512: 0x7F17,
	19513: 0x7F19,
	19514: 0x7F1C,
	19515: 0x7F1B,
	19516: 0x7F1F,
	19517: 0x7F21,
	19518: 0x7F22,
	19519: 0x7F23,
	19520: 0x7F24,
	19521: 0x7F25,
	19522: 0x7F26,
	19523: 0x7F27,
	19524: 0x7F2A,
	19525: 0x7F2B,
	19526: 0x7F2C,
	19527: 0x7F2D,
	19528: 0x7F2F,
	19529: 0x7F30,
	19530: 0x7F31,
	19531: 0x7F32,
	19532: 0x7F33,
	19533: 0x7F35,
	19534: 0x5E7A,
	19535: 0x757F,
	19536: 0x5DDB,
	19537: 0x753E,
	19538: 0x9095,
	19539: 0x738E,
	19540: 0x7391,
	19541: 0x73AE,
	19542: 0x73A2,
	19543: 0x739F,
	19544: 0x73CF,
	19545: 0x73C2,
	19546: 0x73D1,
	19547: 0x73B7,
	19548: 0x73B3,
	19549: 0x73C0,
	19550: 0x73C9,
	19551: 0x73C8,
	19552: 0x73E5,
	19553: 0x73D9,
	19554: 0x987C,
	19555: 0x740A,
	19556: 0x73E9,
	19557: 0x73E7,
	19558: 0x73DE,
	19559: 0x73BA,
	19560: 0x73F2,
	19561: 0x740F,
	19562: 0x742A,
	19563: 0x745B,
	19564: 0x7426,
	19565: 0x7425,
	19566: 0x7428,
	19567: 0x7430,
	19568: 0x742E,
	19569: 0x742C,
	19570: 0x942F,
	19571: 0x9430,
	19572: 0x9431,
	19573: 0x9432,
	19574: 0x9433,
	19575: 0x9434,
	19576: 0x9435,
	19577: 0x9436,
	19578: 0x9437,
	19579: 0x9438,
	19580: 0x9439,
	19581: 0x943A,
	19582: 0x943B,
	19583: 0x943C,
	19584: 0x943D,
	19585: 0x943F,
	19586: 0x9440,
	19587: 0x9441,
	19588: 0x9442,
	19589: 0x9443,
	19590: 0x9444,
	19591: 0x9445,
	19592: 0x9446,
	19593: 0x9447,
	19594: 0x9448,
	19595: 0x9449,
	19596: 0x944A,
	19597: 0x944B,
	19598: 0x944C,
	19599: 0x944D,
	19600: 0x944E,
	19601: 0x944F,
	19602: 0x9450,
	19603: 0x9451,
	19604: 0x9452,
	19605: 0x9453,
	19606: 0x9454,
	19607: 0x9455,
	19608: 0x9456,
	19609: 0x9457,
	19610: 0x9458,
	19611: 0x9459,
	19612: 0x945A,
	19613: 0x945B,
	19614: 0x945C,
	19615: 0x945D,
	19616: 0x945E,
	19617: 0x945F,
	19618: 0x9460,
	19619: 0x9461,
	19620: 0x9462,
	19621: 0x9463,
	19622: 0x9464,
	19623: 0x9465,
	19624: 0x9466,
	19625: 0x9467,
	19626: 0x9468,
	19627: 0x9469,
	19628: 0x946A,
	19629: 0x946C,
	19630: 0x946D,
	19631: 0x946E,
	19632: 0x946F,
	19633: 0x9470,
	19634: 0x9471,
	19635: 0x9472,
	19636: 0x9473,
	19637: 0x9474,
	19638: 0x9475,
	19639: 0x9476,
	19640: 0x9477,
	19641: 0x9478,
	19642: 0x9479,
	19643: 0x947A,
	19644: 0x947B,
	19645: 0x947C,
	19646: 0x947D,
	19647: 0x947E,
	19648: 0x947F,
	19649: 0x9480,
	19650: 0x9481,
	19651: 0x9482,
	19652: 0x9483,
	19653: 0x9484,
	19654: 0x9491,
	19655: 0x9496,
	19656: 0x9498,
	19657: 0x94C7,
	19658: 0x94CF,
	19659: 0x94D3,
	19660: 0x94D4,
	19661: 0x94DA,
	19662: 0x94E6,
	19663: 0x94FB,
	19664: 0x951C,
	19665: 0x9520,
	19666: 0x741B,
	19667: 0x741A,
	19668: 0x7441,
	19669: 0x745C,
	19670: 0x7457,
	19671: 0x7455,
	19672: 0x7459,
	19673: 0x7477,
	19674: 0x746D,
	19675: 0x747E,
	19676: 0x749C,
	19677: 0x748E,
	19678: 0x7480,
	19679: 0x7481,
	19680: 0x7487,
	19681: 0x748B,
	19682: 0x749E,
	19683: 0x74A8,
	19684: 0x74A9,
	19685: 0x7490,
	19686: 0x74A7,
	19687: 0x74D2,
	19688: 0x74BA,
	19689: 0x97EA,
	19690: 0x97EB,
	19691: 0x97EC,
	19692: 0x674C,
	19693: 0x6753,
	19694: 0x675E,
	19695: 0x6748,
	19696: 0x6769,
	19697: 0x67A5,
	19698: 0x6787,
	19699: 0x676A,
	19700: 0x6773,
	19701: 0x6798,
	19702: 0x67A7,
	19703: 0x6775,
	19704: 0x67A8,
	19705: 0x679E,
	19706: 0x67AD,
	19707: 0x678B,
	19708: 0x6777,
	19709: 0x677C,
	19710: 0x67F0,
	19711: 0x6809,
	19712: 0x67D8,
	19713: 0x680A,
	19714: 0x67E9,
	19715: 0x67B0,
	19716: 0x680C,
	19717: 0x67D9,
	19718: 0x67B5,
	19719: 0x67DA,
	19720: 0x67B3,
	19721: 0x67DD,
	19722: 0x6800,
	19723: 0x67C3,
	19724: 0x67B8,
	19725: 0x67E2,
	19726: 0x680E,
	19727: 0x67C1,
	19728: 0x67FD,
	19729: 0x6832,
	19730: 0x6833,
	19731: 0x6860,
	19732: 0x6861,
	19733: 0x684E,
	19734: 0x6862,
	19735: 0x6844,
	19736: 0x6864,
	19737: 0x6883,
	19738: 0x681D,
	19739: 0x6855,
	19740: 0x6866,
	19741: 0x6841,
	19742: 0x6867,
	19743: 0x6840,
	19744: 0x683E,
	19745: 0x684A,
	19746: 0x6849,
	19747: 0x6829,
	19748: 0x68B5,
	19749: 0x688F,
	19750: 0x6874,
	19751: 0x6877,
	19752: 0x6893,
	19753: 0x686B,
	19754: 0x68C2,
	19755: 0x696E,
	19756: 0x68FC,
	19757: 0x691F,
	19758: 0x6920,
	19759: 0x68F9,
	19760: 0x9527,
	19761: 0x9533,
	19762: 0x953D,
	19763: 0x9543,
	19764: 0x9548,
	19765: 0x954B,
	19766: 0x9555,
	19767: 0x955A,
	19768: 0x9560,
	19769: 0x956E,
	19770: 0x9574,
	19771: 0x9575,
	19772: 0x9577,
	19773: 0x9578,
	19774: 0x9579,
	19775: 0x957A,
	19776: 0x957B,
	19777: 0x957C,
	19778: 0x957D,
	19779: 0x957E,
	19780: 0x9580,
	19781: 0x9581,
	19782: 0x9582,
	19783: 0x9583,
	19784: 0x9584,
	19785: 0x9585,
	19786: 0x9586,
	19787: 0x9587,
	19788: 0x9588,
	19789: 0x9589,
	19790: 0x958A,
	19791: 0x958B,
	19792: 0x958C,
	19793: 0x958D,
	19794: 0x958E,
	19795: 0x958F,
	19796: 0x9590,
	19797: 0x9591,
	19798: 0x9592,
	19799: 0x9593,
	19800: 0x9594,
	19801: 0x9595,
	19802: 0x9596,
	19803: 0x9597,
	19804: 0x9598,
	19805: 0x9599,
	19806: 0x959A,
	19807: 0x959B,
	19808: 0x959C,
	19809: 0x959D,
	19810: 0x959E,
	19811: 0x959F,
	19812: 0x95A0,
	19813: 0x95A1,
	19814: 0x95A2,
	19815: 0x95A3,
	19816: 0x95A4,
	19817: 0x95A5,
	19818: 0x95A6,
	19819: 0x95A7,
	19820: 0x95A8,
	19821: 0x95A9,
	19822: 0x95AA,
	19823: 0x95AB,
	19824: 0x95AC,
	19825: 0x95AD,
	19826: 0x95AE,
	19827: 0x95AF,
	19828: 0x95B0,
	19829: 0x95B1,
	19830: 0x95B2,
	19831: 0x95B3,
	19832: 0x95B4,
	19833: 0x95B5,
	19834: 0x95B6,
	19835: 0x95B7,
	19836: 0x95B8,
	19837: 0x95B9,
	19838: 0x95BA,
	19839: 0x95BB,
	19840: 0x95BC,
	19841: 0x95BD,
	19842: 0x95BE,
	19843: 0x95BF,
	19844: 0x95C0,
	19845: 0x95C1,
	19846: 0x95C2,
	19847: 0x95C3,
	19848: 0x95C4,
	19849: 0x95C5,
	19850: 0x95C6,
	19851: 0x95C7,
	19852: 0x95C8,
	19853: 0x95C9,
	19854: 0x95CA,
	19855: 0x95CB,
	19856: 0x6924,
	19857: 0x68F0,
	19858: 0x690B,
	19859: 0x6901,
	19860: 0x6957,
	19861: 0x68E3,
	19862: 0x6910,
	19863: 0x6971,
	19864: 0x6939,
	19865: 0x6960,
	19866: 0x6942,
	19867: 0x695D,
	19868: 0x6984,
	19869: 0x696B,
	19870: 0x6980,
	19871: 0x6998,
	19872: 0x6978,
	19873: 0x6934,
	19874: 0x69CC,
	19875: 0x6987,
	19876: 0x6988,
	19877: 0x69CE,
	19878: 0x6989,
	19879: 0x6966,
	19880: 0x6963,
	19881: 0x6979,
	19882: 0x699B,
	19883: 0x69A7,
	19884: 0x69BB,
	19885: 0x69AB,
	19886: 0x69AD,
	19887: 0x69D4,
	19888: 0x69B1,
	19889: 0x69C1,
	19890: 0x69CA,
	19891: 0x69DF,
	19892: 0x6995,
	19893: 0x69E0,
	19894: 0x698D,
	19895: 0x69FF,
	19896: 0x6A2F,
	19897: 0x69ED,
	19898: 0x6A17,
	19899: 0x6A18,
	19900: 0x6A65,
	19901: 0x69F2,
	19902: 0x6A44,
	19903: 0x6A3E,
	19904: 0x6AA0,
	19905: 0x6A50,
	19906: 0x6A5B,
	19907: 0x6A35,
	19908: 0x6A8E,
	19909: 0x6A79,
	19910: 0x6A3D,
	19911: 0x6A28,
	19912: 0x6A58,
	19913: 0x6A7C,
	19914: 0x6A91,
	19915: 0x6A90,
	19916: 0x6AA9,
	19917: 0x6A97,
	19918: 0x6AAB,
	19919: 0x7337,
	19920: 0x7352,
	19921: 0x6B81,
	19922: 0x6B82,
	19923: 0x6B87,
	19924: 0x6B84,
	19925: 0x6B92,
	19926: 0x6B93,
	19927: 0x6B8D,
	19928: 0x6B9A,
	19929: 0x6B9B,
	19930: 0x6BA1,
	19931: 0x6BAA,
	19932: 0x8F6B,
	19933: 0x8F6D,
	19934: 0x8F71,
	19935: 0x8F72,
	19936: 0x8F73,
	19937: 0x8F75,
	19938: 0x8F76,
	19939: 0x8F78,
	19940: 0x8F77,
	19941: 0x8F79,
	19942: 0x8F7A,
	19943: 0x8F7C,
	19944: 0x8F7E,
	19945: 0x8F81,
	19946: 0x8F82,
	19947: 0x8F84,
	19948: 0x8F87,
	19949: 0x8F8B,
	19950: 0x95CC,
	19951: 0x95CD,
	19952: 0x95CE,
	19953: 0x95CF,
	19954: 0x95D0,
	19955: 0x95D1,
	19956: 0x95D2,
	19957: 0x95D3,
	19958: 0x95D4,
	19959: 0x95D5,
	19960: 0x95D6,
	19961: 0x95D7,
	19962: 0x95D8,
	19963: 0x95D9,
	19964: 0x95DA,
	19965: 0x95DB,
	19966: 0x95DC,
	19967: 0x95DD,
	19968: 0x95DE,
	19969: 0x95DF,
	19970: 0x95E0,
	19971: 0x95E1,
	19972: 0x95E2,
	19973: 0x95E3,
	19974: 0x95E4,
	19975: 0x95E5,
	19976: 0x95E6,
	19977: 0x95E7,
	19978: 0x95EC,
	19979: 0x95FF,
	19980: 0x9607,
	19981: 0x9613,
	19982: 0x9618,
	19983: 0x961B,
	19984: 0x961E,
	19985: 0x9620,
	19986: 0x9623,
	19987: 0x9624,
	19988: 0x9625,
	19989: 0x9626,
	19990: 0x9627,
	19991: 0x9628,
	19992: 0x9629,
	19993: 0x962B,
	19994: 0x962C,
	19995: 0x962D,
	19996: 0x962F,
	19997: 0x9630,
	19998: 0x9637,
	19999: 0x9638,
	20000: 0x9639,
	20001: 0x963A,
	20002: 0x963E,
	20003: 0x9641,
	20004: 0x9643,
	20005: 0x964A,
	20006: 0x964E,
	20007: 0x964F,
	20008: 0x9651,
	20009: 0x9652,
	20010: 0x9653,
	20011: 0x9656,
	20012: 0x9657,
	20013: 0x9658,
	20014: 0x9659,
	20015: 0x965A,
	20016: 0x965C,
	20017: 0x965D,
	20018: 0x965E,
	20019: 0x9660,
	20020: 0x9663,
	20021: 0x9665,
	20022: 0x9666,
	20023: 0x966B,
	20024: 0x966D,
	20025: 0x966E,
	20026: 0x966F,
	20027: 0x9670,
	20028: 0x9671,
	20029: 0x9673,
	20030: 0x9678,
	20031: 0x9679,
	20032: 0x967A,
	20033: 0x967B,
	20034: 0x967C,
	20035: 0x967D,
	20036: 0x967E,
	20037: 0x967F,
	20038: 0x9680,
	20039: 0x9681,
	20040: 0x9682,
	20041: 0x9683,
	20042: 0x9684,
	20043: 0x9687,
	20044: 0x9689,
	20045: 0x968A,
	20046: 0x8F8D,
	20047: 0x8F8E,
	20048: 0x8F8F,
	20049: 0x8F98,
	20050: 0x8F9A,
	20051: 0x8ECE,
	20052: 0x620B,
	20053: 0x6217,
	20054: 0x621B,
	20055: 0x621F,
	20056: 0x6222,
	20057: 0x6221,
	20058: 0x6225,
	20059: 0x6224,
	20060: 0x622C,
	20061: 0x81E7,
	20062: 0x74EF,
	20063: 0x74F4,
	20064: 0x74FF,
	20065: 0x750F,
	20066: 0x7511,
	20067: 0x7513,
	20068: 0x6534,
	20069: 0x65EE,
	20070: 0x65EF,
	20071: 0x65F0,
	20072: 0x660A,
	20073: 0x6619,
	20074: 0x6772,
	20075: 0x6603,
	20076: 0x6615,
	20077: 0x6600,
	20078: 0x7085,
	20079: 0x66F7,
	20080: 0x661D,
	20081: 0x6634,
	20082: 0x6631,
	20083: 0x6636,
	20084: 0x6635,
	20085: 0x8006,
	20086: 0x665F,
	20087: 0x6654,
	20088: 0x6641,
	20089: 0x664F,
	20090: 0x6656,
	20091: 0x6661,
	20092: 0x6657,
	20093: 0x6677,
	20094: 0x6684,
	20095: 0x668C,
	20096: 0x66A7,
	20097: 0x669D,
	20098: 0x66BE,
	20099: 0x66DB,
	20100: 0x66DC,
	20101: 0x66E6,
	20102: 0x66E9,
	20103: 0x8D32,
	20104: 0x8D33,
	20105: 0x8D36,
	20106: 0x8D3B,
	20107: 0x8D3D,
	20108: 0x8D40,
	20109: 0x8D45,
	20110: 0x8D46,
	20111: 0x8D48,
	20112: 0x8D49,
	20113: 0x8D47,
	20114: 0x8D4D,
	20115: 0x8D55,
	20116: 0x8D59,
	20117: 0x89C7,
	20118: 0x89CA,
	20119: 0x89CB,
	20120: 0x89CC,
	20121: 0x89CE,
	20122: 0x89CF,
	20123: 0x89D0,
	20124: 0x89D1,
	20125: 0x726E,
	20126: 0x729F,
	20127: 0x725D,
	20128: 0x7266,
	20129: 0x726F,
	20130: 0x727E,
	20131: 0x727F,
	20132: 0x7284,
	20133: 0x728B,
	20134: 0x728D,
	20135: 0x728F,
	20136: 0x7292,
	20137: 0x6308,
	20138: 0x6332,
	20139: 0x63B0,
	20140: 0x968C,
	20141: 0x968E,
	20142: 0x9691,
	20143: 0x9692,
	20144: 0x9693,
	20145: 0x9695,
	20146: 0x9696,
	20147: 0x969A,
	20148: 0x969B,
	20149: 0x969D,
	20150: 0x969E,
	20151: 0x969F,
	20152: 0x96A0,
	20153: 0x96A1,
	20154: 0x96A2,
	20155: 0x96A3,
	20156: 0x96A4,
	20157: 0x96A5,
	20158: 0x96A6,
	20159: 0x96A8,
	20160: 0x96A9,
	20161: 0x96AA,
	20162: 0x96AB,
	20163: 0x96AC,
	20164: 0x96AD,
	20165: 0x96AE,
	20166: 0x96AF,
	20167: 0x96B1,
	20168: 0x96B2,
	20169: 0x96B4,
	20170: 0x96B5,
	20171: 0x96B7,
	20172: 0x96B8,
	20173: 0x96BA,
	20174: 0x96BB,
	20175: 0x96BF,
	20176: 0x96C2,
	20177: 0x96C3,
	20178: 0x96C8,
	20179: 0x96CA,
	20180: 0x96CB,
	20181: 0x96D0,
	20182: 0x96D1,
	20183: 0x96D3,
	20184: 0x96D4,
	20185: 0x96D6,
	20186: 0x96D7,
	20187: 0x96D8,
	20188: 0x96D9,
	20189: 0x96DA,
	20190: 0x96DB,
	20191: 0x96DC,
	20192: 0x96DD,
	20193: 0x96DE,
	20194: 0x96DF,
	20195: 0x96E1,
	20196: 0x96E2,
	20197: 0x96E3,
	20198: 0x96E4,
	20199: 0x96E5,
	20200: 0x96E6,
	20201: 0x96E7,
	20202: 0x96EB,
	20203: 0x96EC,
	20204: 0x96ED,
	20205: 0x96EE,
	20206: 0x96F0,
	20207: 0x96F1,
	20208: 0x96F2,
	20209: 0x96F4,
	20210: 0x96F5,
	20211: 0x96F8,
	20212: 0x96FA,
	20213: 0x96FB,
	20214: 0x96FC,
	20215: 0x96FD,
	20216: 0x96FF,
	20217: 0x9702,
	20218: 0x9703,
	20219: 0x9705,
	20220: 0x970A,
	20221: 0x970B,
	20222: 0x970C,
	20223: 0x9710,
	20224: 0x9711,
	20225: 0x9712,
	20226: 0x9714,
	20227: 0x9715,
	20228: 0x9717,
	20229: 0x9718,
	20230: 0x9719,
	20231: 0x971A,
	20232: 0x971B,
	20233: 0x971D,
	20234: 0x971F,
	20235: 0x9720,
	20236: 0x643F,
	20237: 0x64D8,
	20238: 0x8004,
	20239: 0x6BEA,
	20240: 0x6BF3,
	20241: 0x6BFD,
	20242: 0x6BF5,
	20243: 0x6BF9,
	20244: 0x6C05,
	20245: 0x6C07,
	20246: 0x6C06,
	20247: 0x6C0D,
	20248: 0x6C15,
	20249: 0x6C18,
	20250: 0x6C19,
	20251: 0x6C1A,
	20252: 0x6C21,
	20253: 0x6C29,
	20254: 0x6C24,
	20255: 0x6C2A,
	20256: 0x6C32,
	20257: 0x6535,
	20258: 0x6555,
	20259: 0x656B,
	20260: 0x724D,
	20261: 0x7252,
	20262: 0x7256,
	20263: 0x7230,
	20264: 0x8662,
	20265: 0x5216,
	20266: 0x809F,
	20267: 0x809C,
	20268: 0x8093,
	20269: 0x80BC,
	20270: 0x670A,
	20271: 0x80BD,
	20272: 0x80B1,
	20273: 0x80AB,
	20274: 0x80AD,
	20275: 0x80B4,
	20276: 0x80B7,
	20277: 0x80E7,
	20278: 0x80E8,
	20279: 0x80E9,
	20280: 0x80EA,
	20281: 0x80DB,
	20282: 0x80C2,
	20283: 0x80C4,
	20284: 0x80D9,
	20285: 0x80CD,
	20286: 0x80D7,
	20287: 0x6710,
	20288: 0x80DD,
	20289: 0x80EB,
	20290: 0x80F1,
	20291: 0x80F4,
	20292: 0x80ED,
	20293: 0x810D,
	20294: 0x810E,
	20295: 0x80F2,
	20296: 0x80FC,
	20297: 0x6715,
	20298: 0x8112,
	20299: 0x8C5A,
	20300: 0x8136,
	20301: 0x811E,
	20302: 0x812C,
	20303: 0x8118,
	20304: 0x8132,
	20305: 0x8148,
	20306: 0x814C,
	20307: 0x8153,
	20308: 0x8174,
	20309: 0x8159,
	20310: 0x815A,
	20311: 0x8171,
	20312: 0x8160,
	20313: 0x8169,
	20314: 0x817C,
	20315: 0x817D,
	20316: 0x816D,
	20317: 0x8167,
	20318: 0x584D,
	20319: 0x5AB5,
	20320: 0x8188,
	20321: 0x8182,
	20322: 0x8191,
	20323: 0x6ED5,
	20324: 0x81A3,
	20325: 0x81AA,
	20326: 0x81CC,
	20327: 0x6726,
	20328: 0x81CA,
	20329: 0x81BB,
	20330: 0x9721,
	20331: 0x9722,
	20332: 0x9723,
	20333: 0x9724,
	20334: 0x9725,
	20335: 0x9726,
	20336: 0x9727,
	20337: 0x9728,
	20338: 0x9729,
	20339: 0x972B,
	20340: 0x972C,
	20341: 0x972E,
	20342: 0x972F,
	20343: 0x9731,
	20344: 0x9733,
	20345: 0x9734,
	20346: 0x9735,
	20347: 0x9736,
	20348: 0x9737,
	20349: 0x973A,
	20350: 0x973B,
	20351: 0x973C,
	20352: 0x973D,
	20353: 0x973F,
	20354: 0x9740,
	20355: 0x9741,
	20356: 0x9742,
	20357: 0x9743,
	20358: 0x9744,
	20359: 0x9745,
	20360: 0x9746,
	20361: 0x9747,
	20362: 0x9748,
	20363: 0x9749,
	20364: 0x974A,
	20365: 0x974B,
	20366: 0x974C,
	20367: 0x974D,
	20368: 0x974E,
	20369: 0x974F,
	20370: 0x9750,
	20371: 0x9751,
	20372: 0x9754,
	20373: 0x9755,
	20374: 0x9757,
	20375: 0x9758,
	20376: 0x975A,
	20377: 0x975C,
	20378: 0x975D,
	20379: 0x975F,
	20380: 0x9763,
	20381: 0x9764,
	20382: 0x9766,
	20383: 0x9767,
	20384: 0x9768,
	20385: 0x976A,
	20386: 0x976B,
	20387: 0x976C,
	20388: 0x976D,
	20389: 0x976E,
	20390: 0x976F,
	20391: 0x9770,
	20392: 0x9771,
	20393: 0x9772,
	20394: 0x9775,
	20395: 0x9777,
	20396: 0x9778,
	20397: 0x9779,
	20398: 0x977A,
	20399: 0x977B,
	20400: 0x977D,
	20401: 0x977E,
	20402: 0x977F,
	20403: 0x9780,
	20404: 0x9781,
	20405: 0x9782,
	20406: 0x9783,
	20407: 0x9784,
	20408: 0x9786,
	20409: 0x9787,
	20410: 0x9788,
	20411: 0x9789,
	20412: 0x978A,
	20413: 0x978C,
	20414: 0x978E,
	20415: 0x978F,
	20416: 0x9790,
	20417: 0x9793,
	20418: 0x9795,
	20419: 0x9796,
	20420: 0x9797,
	20421: 0x9799,
	20422: 0x979A,
	20423: 0x979B,
	20424: 0x979C,
	20425: 0x979D,
	20426: 0x81C1,
	20427: 0x81A6,
	20428: 0x6B24,
	20429: 0x6B37,
	20430: 0x6B39,
	20431: 0x6B43,
	20432: 0x6B46,
	20433: 0x6B59,
	20434: 0x98D1,
	20435: 0x98D2,
	20436: 0x98D3,
	20437: 0x98D5,
	20438: 0x98D9,
	20439: 0x98DA,
	20440: 0x6BB3,
	20441: 0x5F40,
	20442: 0x6BC2,
	20443: 0x89F3,
	20444: 0x6590,
	20445: 0x9F51,
	20446: 0x6593,
	20447: 0x65BC,
	20448: 0x65C6,
	20449: 0x65C4,
	20450: 0x65C3,
	20451: 0x65CC,
	20452: 0x65CE,
	20453: 0x65D2,
	20454: 0x65D6,
	20455: 0x7080,
	20456: 0x709C,
	20457: 0x7096,
	20458: 0x709D,
	20459: 0x70BB,
	20460: 0x70C0,
	20461: 0x70B7,
	20462: 0x70AB,
	20463: 0x70B1,
	20464: 0x70E8,
	20465: 0x70CA,
	20466: 0x7110,
	20467: 0x7113,
	20468: 0x7116,
	20469: 0x712F,
	20470: 0x7131,
	20471: 0x7173,
	20472: 0x715C,
	20473: 0x7168,
	20474: 0x7145,
	20475: 0x7172,
	20476: 0x714A,
	20477: 0x7178,
	20478: 0x717A,
	20479: 0x7198,
	20480: 0x71B3,
	20481: 0x71B5,
	20482: 0x71A8,
	20483: 0x71A0,
	20484: 0x71E0,
	20485: 0x71D4,
	20486: 0x71E7,
	20487: 0x71F9,
	20488: 0x721D,
	20489: 0x7228,
	20490: 0x706C,
	20491: 0x7118,
	20492: 0x7166,
	20493: 0x71B9,
	20494: 0x623E,
	20495: 0x623D,
	20496: 0x6243,
	20497: 0x6248,
	20498: 0x6249,
	20499: 0x793B,
	20500: 0x7940,
	20501: 0x7946,
	20502: 0x7949,
	20503: 0x795B,
	20504: 0x795C,
	20505: 0x7953,
	20506: 0x795A,
	20507: 0x7962,
	20508: 0x7957,
	20509: 0x7960,
	20510: 0x796F,
	20511: 0x7967,
	20512: 0x797A,
	20513: 0x7985,
	20514: 0x798A,
	20515: 0x799A,
	20516: 0x79A7,
	20517: 0x79B3,
	20518: 0x5FD1,
	20519: 0x5FD0,
	20520: 0x979E,
	20521: 0x979F,
	20522: 0x97A1,
	20523: 0x97A2,
	20524: 0x97A4,
	20525: 0x97A5,
	20526: 0x97A6,
	20527: 0x97A7,
	20528: 0x97A8,
	20529: 0x97A9,
	20530: 0x97AA,
	20531: 0x97AC,
	20532: 0x97AE,
	20533: 0x97B0,
	20534: 0x97B1,
	20535: 0x97B3,
	20536: 0x97B5,
	20537: 0x97B6,
	20538: 0x97B7,
	20539: 0x97B8,
	20540: 0x97B9,
	20541: 0x97BA,
	20542: 0x97BB,
	20543: 0x97BC,
	20544: 0x97BD,
	20545: 0x97BE,
	20546: 0x97BF,
	20547: 0x97C0,
	20548: 0x97C1,
	20549: 0x97C2,
	20550: 0x97C3,
	20551: 0x97C4,
	20552: 0x97C5,
	20553: 0x97C6,
	20554: 0x97C7,
	20555: 0x97C8,
	20556: 0x97C9,
	20557: 0x97CA,
	20558: 0x97CB,
	20559: 0x97CC,
	20560: 0x97CD,
	20561: 0x97CE,
	20562: 0x97CF,
	20563: 0x97D0,
	20564: 0x97D1,
	20565: 0x97D2,
	20566: 0x97D3,
	20567: 0x97D4,
	20568: 0x97D5,
	20569: 0x97D6,
	20570: 0x97D7,
	20571: 0x97D8,
	20572: 0x97D9,
	20573: 0x97DA,
	20574: 0x97DB,
	20575: 0x97DC,
	20576: 0x97DD,
	20577: 0x97DE,
	20578: 0x97DF,
	20579: 0x97E0,
	20580: 0x97E1,
	20581: 0x97E2,
	20582: 0x97E3,
	20583: 0x97E4,
	20584: 0x97E5,
	20585: 0x97E8,
	20586: 0x97EE,
	20587: 0x97EF,
	20588: 0x97F0,
	20589: 0x97F1,
	20590: 0x97F2,
	20591: 0x97F4,
	20592: 0x97F7,
	20593: 0x97F8,
	20594: 0x97F9,
	20595: 0x97FA,
	20596: 0x97FB,
	20597: 0x97FC,
	20598: 0x97FD,
	20599: 0x97FE,
	20600: 0x97FF,
	20601: 0x9800,
	20602: 0x9801,
	20603: 0x9802,
	20604: 0x9803,
	20605: 0x9804,
	20606: 0x9805,
	20607: 0x9806,
	20608: 0x9807,
	20609: 0x9808,
	20610: 0x9809,
	20611: 0x980A,
	20612: 0x980B,
	20613: 0x980C,
	20614: 0x980D,
	20615: 0x980E,
	20616: 0x603C,
	20617: 0x605D,
	20618: 0x605A,
	20619: 0x6067,
	20620: 0x6041,
	20621: 0x6059,
	20622: 0x6063,
	20623: 0x60AB,
	20624: 0x6106,
	20625: 0x610D,
	20626: 0x615D,
	20627: 0x61A9,
	20628: 0x619D,
	20629: 0x61CB,
	20630: 0x61D1,
	20631: 0x6206,
	20632: 0x8080,
	20633: 0x807F,
	20634: 0x6C93,
	20635: 0x6CF6,
	20636: 0x6DFC,
	20637: 0x77F6,
	20638: 0x77F8,
	20639: 0x7800,
	20640: 0x7809,
	20641: 0x7817,
	20642: 0x7818,
	20643: 0x7811,
	20644: 0x65AB,
	20645: 0x782D,
	20646: 0x781C,
	20647: 0x781D,
	20648: 0x7839,
	20649: 0x783A,
	20650: 0x783B,
	20651: 0x781F,
	20652: 0x783C,
	20653: 0x7825,
	20654: 0x782C,
	20655: 0x7823,
	20656: 0x7829,
	20657: 0x784E,
	20658: 0x786D,
	20659: 0x7856,
	20660: 0x7857,
	20661: 0x7826,
	20662: 0x7850,
	20663: 0x7847,
	20664: 0x784C,
	20665: 0x786A,
	20666: 0x789B,
	20667: 0x7893,
	20668: 0x789A,
	20669: 0x7887,
	20670: 0x789C,
	20671: 0x78A1,
	20672: 0x78A3,
	20673: 0x78B2,
	20674: 0x78B9,
	20675: 0x78A5,
	20676: 0x78D4,
	20677: 0x78D9,
	20678: 0x78C9,
	20679: 0x78EC,
	20680: 0x78F2,
	20681: 0x7905,
	20682: 0x78F4,
	20683: 0x7913,
	20684: 0x7924,
	20685: 0x791E,
	20686: 0x7934,
	20687: 0x9F9B,
	20688: 0x9EF9,
	20689: 0x9EFB,
	20690: 0x9EFC,
	20691: 0x76F1,
	20692: 0x7704,
	20693: 0x770D,
	20694: 0x76F9,
	20695: 0x7707,
	20696: 0x7708,
	20697: 0x771A,
	20698: 0x7722,
	20699: 0x7719,
	20700: 0x772D,
	20701: 0x7726,
	20702: 0x7735,
	20703: 0x7738,
	20704: 0x7750,
	20705: 0x7751,
	20706: 0x7747,
	20707: 0x7743,
	20708: 0x775A,
	20709: 0x7768,
	20710: 0x980F,
	20711: 0x9810,
	20712: 0x9811,
	20713: 0x9812,
	20714: 0x9813,
	20715: 0x9814,
	20716: 0x9815,
	20717: 0x9816,
	20718: 0x9817,
	20719: 0x9818,
	20720: 0x9819,
	20721: 0x981A,
	20722: 0x981B,
	20723: 0x981C,
	20724: 0x981D,
	20725: 0x981E,
	20726: 0x981F,
	20727: 0x9820,
	20728: 0x9821,
	20729: 0x9822,
	20730: 0x9823,
	20731: 0x9824,
	20732: 0x9825,
	20733: 0x9826,
	20734: 0x9827,
	20735: 0x9828,
	20736: 0x9829,
	20737: 0x982A,
	20738: 0x982B,
	20739: 0x982C,
	20740: 0x982D,
	20741: 0x982E,
	20742: 0x982F,
	20743: 0x9830,
	20744: 0x9831,
	20745: 0x9832,
	20746: 0x9833,
	20747: 0x9834,
	20748: 0x9835,
	20749: 0x9836,
	20750: 0x9837,
	20751: 0x9838,
	20752: 0x9839,
	20753: 0x983A,
	20754: 0x983B,
	20755: 0x983C,
	20756: 0x983D,
	20757: 0x983E,
	20758: 0x983F,
	20759: 0x9840,
	20760: 0x9841,
	20761: 0x9842,
	20762: 0x9843,
	20763: 0x9844,
	20764: 0x9845,
	20765: 0x9846,
	20766: 0x9847,
	20767: 0x9848,
	20768: 0x9849,
	20769: 0x984A,
	20770: 0x984B,
	20771: 0x984C,
	20772: 0x984D,
	20773: 0x984E,
	20774: 0x984F,
	20775: 0x9850,
	20776: 0x9851,
	20777: 0x9852,
	20778: 0x9853,
	20779: 0x9854,
	20780: 0x9855,
	20781: 0x9856,
	20782: 0x9857,
	20783: 0x9858,
	20784: 0x9859,
	20785: 0x985A,
	20786: 0x985B,
	20787: 0x985C,
	20788: 0x985D,
	20789: 0x985E,
	20790: 0x985F,
	20791: 0x9860,
	20792: 0x9861,
	20793: 0x9862,
	20794: 0x9863,
	20795: 0x9864,
	20796: 0x9865,
	20797: 0x9866,
	20798: 0x9867,
	20799: 0x9868,
	20800: 0x9869,
	20801: 0x986A,
	20802: 0x986B,
	20803: 0x986C,
	20804: 0x986D,
	20805: 0x986E,
	20806: 0x7762,
	20807: 0x7765,
	20808: 0x777F,
	20809: 0x778D,
	20810: 0x777D,
	20811: 0x7780,
	20812: 0x778C,
	20813: 0x7791,
	20814: 0x779F,
	20815: 0x77A0,
	20816: 0x77B0,
	20817: 0x77B5,
	20818: 0x77BD,
	20819: 0x753A,
	20820: 0x7540,
	20821: 0x754E,
	20822: 0x754B,
	20823: 0x7548,
	20824: 0x755B,
	20825: 0x7572,
	20826: 0x7579,
	20827: 0x7583,
	20828: 0x7F58,
	20829: 0x7F61,
	20830: 0x7F5F,
	20831: 0x8A48,
	20832: 0x7F68,
	20833: 0x7F74,
	20834: 0x7F71,
	20835: 0x7F79,
	20836: 0x7F81,
	20837: 0x7F7E,
	20838: 0x76CD,
	20839: 0x76E5,
	20840: 0x8832,
	20841: 0x9485,
	20842: 0x9486,
	20843: 0x9487,
	20844: 0x948B,
	20845: 0x948A,
	20846: 0x948C,
	20847: 0x948D,
	20848: 0x948F,
	20849: 0x9490,
	20850: 0x9494,
	20851: 0x9497,
	20852: 0x9495,
	20853: 0x949A,
	20854: 0x949B,
	20855: 0x949C,
	20856: 0x94A3,
	20857: 0x94A4,
	20858: 0x94AB,
	20859: 0x94AA,
	20860: 0x94AD,
	20861: 0x94AC,
	20862: 0x94AF,
	20863: 0x94B0,
	20864: 0x94B2,
	20865: 0x94B4,
	20866: 0x94B6,
	20867: 0x94B7,
	20868: 0x94B8,
	20869: 0x94B9,
	20870: 0x94BA,
	20871: 0x94BC,
	20872: 0x94BD,
	20873: 0x94BF,
	20874: 0x94C4,
	20875: 0x94C8,
	20876: 0x94C9,
	20877: 0x94CA,
	20878: 0x94CB,
	20879: 0x94CC,
	20880: 0x94CD,
	20881: 0x94CE,
	20882: 0x94D0,
	20883: 0x94D1,
	20884: 0x94D2,
	20885: 0x94D5,
	20886: 0x94D6,
	20887: 0x94D7,
	20888: 0x94D9,
	20889: 0x94D8,
	20890: 0x94DB,
	20891: 0x94DE,
	20892: 0x94DF,
	20893: 0x94E0,
	20894: 0x94E2,
	20895: 0x94E4,
	20896: 0x94E5,
	20897: 0x94E7,
	20898: 0x94E8,
	20899: 0x94EA,
	20900: 0x986F,
	20901: 0x9870,
	20902: 0x9871,
	20903: 0x9872,
	20904: 0x9873,
	20905: 0x9874,
	20906: 0x988B,
	20907: 0x988E,
	20908: 0x9892,
	20909: 0x9895,
	20910: 0x9899,
	20911: 0x98A3,
	20912: 0x98A8,
	20913: 0x98A9,
	20914: 0x98AA,
	20915: 0x98AB,
	20916: 0x98AC,
	20917: 0x98AD,
	20918: 0x98AE,
	20919: 0x98AF,
	20920: 0x98B0,
	20921: 0x98B1,
	20922: 0x98B2,
	20923: 0x98B3,
	20924: 0x98B4,
	20925: 0x98B5,
	20926: 0x98B6,
	20927: 0x98B7,
	20928: 0x98B8,
	20929: 0x98B9,
	20930: 0x98BA,
	20931: 0x98BB,
	20932: 0x98BC,
	20933: 0x98BD,
	20934: 0x98BE,
	20935: 0x98BF,
	20936: 0x98C0,
	20937: 0x98C1,
	20938: 0x98C2,
	20939: 0x98C3,
	20940: 0x98C4,
	20941: 0x98C5,
	20942: 0x98C6,
	20943: 0x98C7,
	20944: 0x98C8,
	20945: 0x98C9,
	20946: 0x98CA,
	20947: 0x98CB,
	20948: 0x98CC,
	20949: 0x98CD,
	20950: 0x98CF,
	20951: 0x98D0,
	20952: 0x98D4,
	20953: 0x98D6,
	20954: 0x98D7,
	20955: 0x98DB,
	20956: 0x98DC,
	20957: 0x98DD,
	20958: 0x98E0,
	20959: 0x98E1,
	20960: 0x98E2,
	20961: 0x98E3,
	20962: 0x98E4,
	20963: 0x98E5,
	20964: 0x98E6,
	20965: 0x98E9,
	20966: 0x98EA,
	20967: 0x98EB,
	20968: 0x98EC,
	20969: 0x98ED,
	20970: 0x98EE,
	20971: 0x98EF,
	20972: 0x98F0,
	20973: 0x98F1,
	20974: 0x98F2,
	20975: 0x98F3,
	20976: 0x98F4,
	20977: 0x98F5,
	20978: 0x98F6,
	20979: 0x98F7,
	20980: 0x98F8,
	20981: 0x98F9,
	20982: 0x98FA,
	20983: 0x98FB,
	20984: 0x98FC,
	20985: 0x98FD,
	20986: 0x98FE,
	20987: 0x98FF,
	20988: 0x9900,
	20989: 0x9901,
	20990: 0x9902,
	20991: 0x9903,
	20992: 0x9904,
	20993: 0x9905,
	20994: 0x9906,
	20995: 0x9907,
	20996: 0x94E9,
	20997: 0x94EB,
	20998: 0x94EE,
	20999: 0x94EF,
	21000: 0x94F3,
	21001: 0x94F4,
	21002: 0x94F5,
	21003: 0x94F7,
	21004: 0x94F9,
	21005: 0x94FC,
	21006: 0x94FD,
	21007: 0x94FF,
	21008: 0x9503,
	21009: 0x9502,
	21010: 0x9506,
	21011: 0x9507,
	21012: 0x9509,
	21013: 0x950A,
	21014: 0x950D,
	21015: 0x950E,
	21016: 0x950F,
	21017: 0x9512,
	21018: 0x9513,
	21019: 0x9514,
	21020: 0x9515,
	21021: 0x9516,
	21022: 0x9518,
	21023: 0x951B,
	21024: 0x951D,
	21025: 0x951E,
	21026: 0x951F,
	21027: 0x9522,
	21028: 0x952A,
	21029: 0x952B,
	21030: 0x9529,
	21031: 0x952C,
	21032: 0x9531,
	21033: 0x9532,
	21034: 0x9534,
	21035: 0x9536,
	21036: 0x9537,
	21037: 0x9538,
	21038: 0x953C,
	21039: 0x953E,
	21040: 0x953F,
	21041: 0x9542,
	21042: 0x9535,
	21043: 0x9544,
	21044: 0x9545,
	21045: 0x9546,
	21046: 0x9549,
	21047: 0x954C,
	21048: 0x954E,
	21049: 0x954F,
	21050: 0x9552,
	21051: 0x9553,
	21052: 0x9554,
	21053: 0x9556,
	21054: 0x9557,
	21055: 0x9558,
	21056: 0x9559,
	21057: 0x955B,
	21058: 0x955E,
	21059: 0x955F,
	21060: 0x955D,
	21061: 0x9561,
	21062: 0x9562,
	21063: 0x9564,
	21064: 0x9565,
	21065: 0x9566,
	21066: 0x9567,
	21067: 0x9568,
	21068: 0x9569,
	21069: 0x956A,
	21070: 0x956B,
	21071: 0x956C,
	21072: 0x956F,
	21073: 0x9571,
	21074: 0x9572,
	21075: 0x9573,
	21076: 0x953A,
	21077: 0x77E7,
	21078: 0x77EC,
	21079: 0x96C9,
	21080: 0x79D5,
	21081: 0x79ED,
	21082: 0x79E3,
	21083: 0x79EB,
	21084: 0x7A06,
	21085: 0x5D47,
	21086: 0x7A03,
	21087: 0x7A02,
	21088: 0x7A1E,
	21089: 0x7A14,
	21090: 0x9908,
	21091: 0x9909,
	21092: 0x990A,
	21093: 0x990B,
	21094: 0x990C,
	21095: 0x990E,
	21096: 0x990F,
	21097: 0x9911,
	21098: 0x9912,
	21099: 0x9913,
	21100: 0x9914,
	21101: 0x9915,
	21102: 0x9916,
	21103: 0x9917,
	21104: 0x9918,
	21105: 0x9919,
	21106: 0x991A,
	21107: 0x991B,
	21108: 0x991C,
	21109: 0x991D,
	21110: 0x991E,
	21111: 0x991F,
	21112: 0x9920,
	21113: 0x9921,
	21114: 0x9922,
	21115: 0x9923,
	21116: 0x9924,
	21117: 0x9925,
	21118: 0x9926,
	21119: 0x9927,
	21120: 0x9928,
	21121: 0x9929,
	21122: 0x992A,
	21123: 0x992B,
	21124: 0x992C,
	21125: 0x992D,
	21126: 0x992F,
	21127: 0x9930,
	21128: 0x9931,
	21129: 0x9932,
	21130: 0x9933,
	21131: 0x9934,
	21132: 0x9935,
	21133: 0x9936,
	21134: 0x9937,
	21135: 0x9938,
	21136: 0x9939,
	21137: 0x993A,
	21138: 0x993B,
	21139: 0x993C,
	21140: 0x993D,
	21141: 0x993E,
	21142: 0x993F,
	21143: 0x9940,
	21144: 0x9941,
	21145: 0x9942,
	21146: 0x9943,
	21147: 0x9944,
	21148: 0x9945,
	21149: 0x9946,
	21150: 0x9947,
	21151: 0x9948,
	21152: 0x9949,
	21153: 0x994A,
	21154: 0x994B,
	21155: 0x994C,
	21156: 0x994D,
	21157: 0x994E,
	21158: 0x994F,
	21159: 0x9950,
	21160: 0x9951,
	21161: 0x9952,
	21162: 0x9953,
	21163: 0x9956,
	21164: 0x9957,
	21165: 0x9958,
	21166: 0x9959,
	21167: 0x995A,
	21168: 0x995B,
	21169: 0x995C,
	21170: 0x995D,
	21171: 0x995E,
	21172: 0x995F,
	21173: 0x9960,
	21174: 0x9961,
	21175: 0x9962,
	21176: 0x9964,
	21177: 0x9966,
	21178: 0x9973,
	21179: 0x9978,
	21180: 0x9979,
	21181: 0x997B,
	21182: 0x997E,
	21183: 0x9982,
	21184: 0x9983,
	21185: 0x9989,
	21186: 0x7A39,
	21187: 0x7A37,
	21188: 0x7A51,
	21189: 0x9ECF,
	21190: 0x99A5,
	21191: 0x7A70,
	21192: 0x7688,
	21193: 0x768E,
	21194: 0x7693,
	21195: 0x7699,
	21196: 0x76A4,
	21197: 0x74DE,
	21198: 0x74E0,
	21199: 0x752C,
	21200: 0x9E20,
	21201: 0x9E22,
	21202: 0x9E28,
	21203: 0x9E29,
	21204: 0x9E2A,
	21205: 0x9E2B,
	21206: 0x9E2C,
	21207: 0x9E32,
	21208: 0x9E31,
	21209: 0x9E36,
	21210: 0x9E38,
	21211: 0x9E37,
	21212: 0x9E39,
	21213: 0x9E3A,
	21214: 0x9E3E,
	21215: 0x9E41,
	21216: 0x9E42,
	21217: 0x9E44,
	21218: 0x9E46,
	21219: 0x9E47,
	21220: 0x9E48,
	21221: 0x9E49,
	21222: 0x9E4B,
	21223: 0x9E4C,
	21224: 0x9E4E,
	21225: 0x9E51,
	21226: 0x9E55,
	21227: 0x9E57,
	21228: 0x9E5A,
	21229: 0x9E5B,
	21230: 0x9E5C,
	21231: 0x9E5E,
	21232: 0x9E63,
	21233: 0x9E66,
	21234: 0x9E67,
	21235: 0x9E68,
	21236: 0x9E69,
	21237: 0x9E6A,
	21238: 0x9E6B,
	21239: 0x9E6C,
	21240: 0x9E71,
	21241: 0x9E6D,
	21242: 0x9E73,
	21243: 0x7592,
	21244: 0x7594,
	21245: 0x7596,
	21246: 0x75A0,
	21247: 0x759D,
	21248: 0x75AC,
	21249: 0x75A3,
	21250: 0x75B3,
	21251: 0x75B4,
	21252: 0x75B8,
	21253: 0x75C4,
	21254: 0x75B1,
	21255: 0x75B0,
	21256: 0x75C3,
	21257: 0x75C2,
	21258: 0x75D6,
	21259: 0x75CD,
	21260: 0x75E3,
	21261: 0x75E8,
	21262: 0x75E6,
	21263: 0x75E4,
	21264: 0x75EB,
	21265: 0x75E7,
	21266: 0x7603,
	21267: 0x75F1,
	21268: 0x75FC,
	21269: 0x75FF,
	21270: 0x7610,
	21271: 0x7600,
	21272: 0x7605,
	21273: 0x760C,
	21274: 0x7617,
	21275: 0x760A,
	21276: 0x7625,
	21277: 0x7618,
	21278: 0x7615,
	21279: 0x7619,
	21280: 0x998C,
	21281: 0x998E,
	21282: 0x999A,
	21283: 0x999B,
	21284: 0x999C,
	21285: 0x999D,
	21286: 0x999E,
	21287: 0x999F,
	21288: 0x99A0,
	21289: 0x99A1,
	21290: 0x99A2,
	21291: 0x99A3,
	21292: 0x99A4,
	21293: 0x99A6,
	21294: 0x99A7,
	21295: 0x99A9,
	21296: 0x99AA,
	21297: 0x99AB,
	21298: 0x99AC,
	21299: 0x99AD,
	21300: 0x99AE,
	21301: 0x99AF,
	21302: 0x99B0,
	21303: 0x99B1,
	21304: 0x99B2,
	21305: 0x99B3,
	21306: 0x99B4,
	21307: 0x99B5,
	21308: 0x99B6,
	21309: 0x99B7,
	21310: 0x99B8,
	21311: 0x99B9,
	21312: 0x99BA,
	21313: 0x99BB,
	21314: 0x99BC,
	21315: 0x99BD,
	21316: 0x99BE,
	21317: 0x99BF,
	21318: 0x99C0,
	21319: 0x99C1,
	21320: 0x99C2,
	21321: 0x99C3,
	21322: 0x99C4,
	21323: 0x99C5,
	21324: 0x99C6,
	21325: 0x99C7,
	21326: 0x99C8,
	21327: 0x99C9,
	21328: 0x99CA,
	21329: 0x99CB,
	21330: 0x99CC,
	21331: 0x99CD,
	21332: 0x99CE,
	21333: 0x99CF,
	21334: 0x99D0,
	21335: 0x99D1,
	21336: 0x99D2,
	21337: 0x99D3,
	21338: 0x99D4,
	21339: 0x99D5,
	21340: 0x99D6,
	21341: 0x99D7,
	21342: 0x99D8,
	21343: 0x99D9,
	21344: 0x99DA,
	21345: 0x99DB,
	21346: 0x99DC,
	21347: 0x99DD,
	21348: 0x99DE,
	21349: 0x99DF,
	21350: 0x99E0,
	21351: 0x99E1,
	21352: 0x99E2,
	21353: 0x99E3,
	21354: 0x99E4,
	21355: 0x99E5,
	21356: 0x99E6,
	21357: 0x99E7,
	21358: 0x99E8,
	21359: 0x99E9,
	21360: 0x99EA,
	21361: 0x99EB,
	21362: 0x99EC,
	21363: 0x99ED,
	21364: 0x99EE,
	21365: 0x99EF,
	21366: 0x99F0,
	21367: 0x99F1,
	21368: 0x99F2,
	21369: 0x99F3,
	21370: 0x99F4,
	21371: 0x99F5,
	21372: 0x99F6,
	21373: 0x99F7,
	21374: 0x99F8,
	21375: 0x99F9,
	21376: 0x761B,
	21377: 0x763C,
	21378: 0x7622,
	21379: 0x7620,
	21380: 0x7640,
	21381: 0x762D,
	21382: 0x7630,
	21383: 0x763F,
	21384: 0x7635,
	21385: 0x7643,
	21386: 0x763E,
	21387: 0x7633,
	21388: 0x764D,
	21389: 0x765E,
	21390: 0x7654,
	21391: 0x765C,
	21392: 0x7656,
	21393: 0x766B,
	21394: 0x766F,
	21395: 0x7FCA,
	21396: 0x7AE6,
	21397: 0x7A78,
	21398: 0x7A79,
	21399: 0x7A80,
	21400: 0x7A86,
	21401: 0x7A88,
	21402: 0x7A95,
	21403: 0x7AA6,
	21404: 0x7AA0,
	21405: 0x7AAC,
	21406: 0x7AA8,
	21407: 0x7AAD,
	21408: 0x7AB3,
	21409: 0x8864,
	21410: 0x8869,
	21411: 0x8872,
	21412: 0x887D,
	21413: 0x887F,
	21414: 0x8882,
	21415: 0x88A2,
	21416: 0x88C6,
	21417: 0x88B7,
	21418: 0x88BC,
	21419: 0x88C9,
	21420: 0x88E2,
	21421: 0x88CE,
	21422: 0x88E3,
	21423: 0x88E5,
	21424: 0x88F1,
	21425: 0x891A,
	21426: 0x88FC,
	21427: 0x88E8,
	21428: 0x88FE,
	21429: 0x88F0,
	21430: 0x8921,
	21431: 0x8919,
	21432: 0x8913,
	21433: 0x891B,
	21434: 0x890A,
	21435: 0x8934,
	21436: 0x892B,
	21437: 0x8936,
	21438: 0x8941,
	21439: 0x8966,
	21440: 0x897B,
	21441: 0x758B,
	21442: 0x80E5,
	21443: 0x76B2,
	21444: 0x76B4,
	21445: 0x77DC,
	21446: 0x8012,
	21447: 0x8014,
	21448: 0x8016,
	21449: 0x801C,
	21450: 0x8020,
	21451: 0x8022,
	21452: 0x8025,
	21453: 0x8026,
	21454: 0x8027,
	21455: 0x8029,
	21456: 0x8028,
	21457: 0x8031,
	21458: 0x800B,
	21459: 0x8035,
	21460: 0x8043,
	21461: 0x8046,
	21462: 0x804D,
	21463: 0x8052,
	21464: 0x8069,
	21465: 0x8071,
	21466: 0x8983,
	21467: 0x9878,
	21468: 0x9880,
	21469: 0x9883,
	21470: 0x99FA,
	21471: 0x99FB,
	21472: 0x99FC,
	21473: 0x99FD,
	21474: 0x99FE,
	21475: 0x99FF,
	21476: 0x9A00,
	21477: 0x9A01,
	21478: 0x9A02,
	21479: 0x9A03,
	21480: 0x9A04,
	21481: 0x9A05,
	21482: 0x9A06,
	21483: 0x9A07,
	21484: 0x9A08,
	21485: 0x9A09,
	21486: 0x9A0A,
	21487: 0x9A0B,
	21488: 0x9A0C,
	21489: 0x9A0D,
	21490: 0x9A0E,
	21491: 0x9A0F,
	21492: 0x9A10,
	21493: 0x9A11,
	21494: 0x9A12,
	21495: 0x9A13,
	21496: 0x9A14,
	21497: 0x9A15,
	21498: 0x9A16,
	21499: 0x9A17,
	21500: 0x9A18,
	21501: 0x9A19,
	21502: 0x9A1A,
	21503: 0x9A1B,
	21504: 0x9A1C,
	21505: 0x9A1D,
	21506: 0x9A1E,
	21507: 0x9A1F,
	21508: 0x9A20,
	21509: 0x9A21,
	21510: 0x9A22,
	21511: 0x9A23,
	21512: 0x9A24,
	21513: 0x9A25,
	21514: 0x9A26,
	21515: 0x9A27,
	21516: 0x9A28,
	21517: 0x9A29,
	21518: 0x9A2A,
	21519: 0x9A2B,
	21520: 0x9A2C,
	21521: 0x9A2D,
	21522: 0x9A2E,
	21523: 0x9A2F,
	21524: 0x9A30,
	21525: 0x9A31,
	21526: 0x9A32,
	21527: 0x9A33,
	21528: 0x9A34,
	21529: 0x9A35,
	21530: 0x9A36,
	21531: 0x9A37,
	21532: 0x9A38,
	21533: 0x9A39,
	21534: 0x9A3A,
	21535: 0x9A3B,
	21536: 0x9A3C,
	21537: 0x9A3D,
	21538: 0x9A3E,
	21539: 0x9A3F,
	21540: 0x9A40,
	21541: 0x9A41,
	21542: 0x9A42,
	21543: 0x9A43,
	21544: 0x9A44,
	21545: 0x9A45,
	21546: 0x9A46,
	21547: 0x9A47,
	21548: 0x9A48,
	21549: 0x9A49,
	21550: 0x9A4A,
	21551: 0x9A4B,
	21552: 0x9A4C,
	21553: 0x9A4D,
	21554: 0x9A4E,
	21555: 0x9A4F,
	21556: 0x9A50,
	21557: 0x9A51,
	21558: 0x9A52,
	21559: 0x9A53,
	21560: 0x9A54,
	21561: 0x9A55,
	21562: 0x9A56,
	21563: 0x9A57,
	21564: 0x9A58,
	21565: 0x9A59,
	21566: 0x9889,
	21567: 0x988C,
	21568: 0x988D,
	21569: 0x988F,
	21570: 0x9894,
	21571: 0x989A,
	21572: 0x989B,
	21573: 0x989E,
	21574: 0x989F,
	21575: 0x98A1,
	21576: 0x98A2,
	21577: 0x98A5,
	21578: 0x98A6,
	21579: 0x864D,
	21580: 0x8654,
	21581: 0x866C,
	21582: 0x866E,
	21583: 0x867F,
	21584: 0x867A,
	21585: 0x867C,
	21586: 0x867B,
	21587: 0x86A8,
	21588: 0x868D,
	21589: 0x868B,
	21590: 0x86AC,
	21591: 0x869D,
	21592: 0x86A7,
	21593: 0x86A3,
	21594: 0x86AA,
	21595: 0x8693,
	21596: 0x86A9,
	21597: 0x86B6,
	21598: 0x86C4,
	21599: 0x86B5,
	21600: 0x86CE,
	21601: 0x86B0,
	21602: 0x86BA,
	21603: 0x86B1,
	21604: 0x86AF,
	21605: 0x86C9,
	21606: 0x86CF,
	21607: 0x86B4,
	21608: 0x86E9,
	21609: 0x86F1,
	21610: 0x86F2,
	21611: 0x86ED,
	21612: 0x86F3,
	21613: 0x86D0,
	21614: 0x8713,
	21615: 0x86DE,
	21616: 0x86F4,
	21617: 0x86DF,
	21618: 0x86D8,
	21619: 0x86D1,
	21620: 0x8703,
	21621: 0x8707,
	21622: 0x86F8,
	21623: 0x8708,
	21624: 0x870A,
	21625: 0x870D,
	21626: 0x8709,
	21627: 0x8723,
	21628: 0x873B,
	21629: 0x871E,
	21630: 0x8725,
	21631: 0x872E,
	21632: 0x871A,
	21633: 0x873E,
	21634: 0x8748,
	21635: 0x8734,
	21636: 0x8731,
	21637: 0x8729,
	21638: 0x8737,
	21639: 0x873F,
	21640: 0x8782,
	21641: 0x8722,
	21642: 0x877D,
	21643: 0x877E,
	21644: 0x877B,
	21645: 0x8760,
	21646: 0x8770,
	21647: 0x874C,
	21648: 0x876E,
	21649: 0x878B,
	21650: 0x8753,
	21651: 0x8763,
	21652: 0x877C,
	21653: 0x8764,
	21654: 0x8759,
	21655: 0x8765,
	21656: 0x8793,
	21657: 0x87AF,
	21658: 0x87A8,
	21659: 0x87D2,
	21660: 0x9A5A,
	21661: 0x9A5B,
	21662: 0x9A5C,
	21663: 0x9A5D,
	21664: 0x9A5E,
	21665: 0x9A5F,
	21666: 0x9A60,
	21667: 0x9A61,
	21668: 0x9A62,
	21669: 0x9A63,
	21670: 0x9A64,
	21671: 0x9A65,
	21672: 0x9A66,
	21673: 0x9A67,
	21674: 0x9A68,
	21675: 0x9A69,
	21676: 0x9A6A,
	21677: 0x9A6B,
	21678: 0x9A72,
	21679: 0x9A83,
	21680: 0x9A89,
	21681: 0x9A8D,
	21682: 0x9A8E,
	21683: 0x9A94,
	21684: 0x9A95,
	21685: 0x9A99,
	21686: 0x9AA6,
	21687: 0x9AA9,
	21688: 0x9AAA,
	21689: 0x9AAB,
	21690: 0x9AAC,
	21691: 0x9AAD,
	21692: 0x9AAE,
	21693: 0x9AAF,
	21694: 0x9AB2,
	21695: 0x9AB3,
	21696: 0x9AB4,
	21697: 0x9AB5,
	21698: 0x9AB9,
	21699: 0x9ABB,
	21700: 0x9ABD,
	21701: 0x9ABE,
	21702: 0x9ABF,
	21703: 0x9AC3,
	21704: 0x9AC4,
	21705: 0x9AC6,
	21706: 0x9AC7,
	21707: 0x9AC8,
	21708: 0x9AC9,
	21709: 0x9ACA,
	21710: 0x9ACD,
	21711: 0x9ACE,
	21712: 0x9ACF,
	21713: 0x9AD0,
	21714: 0x9AD2,
	21715: 0x9AD4,
	21716: 0x9AD5,
	21717: 0x9AD6,
	21718: 0x9AD7,
	21719: 0x9AD9,
	21720: 0x9ADA,
	21721: 0x9ADB,
	21722: 0x9ADC,
	21723: 0x9ADD,
	21724: 0x9ADE,
	21725: 0x9AE0,
	21726: 0x9AE2,
	21727: 0x9AE3,
	21728: 0x9AE4,
	21729: 0x9AE5,
	21730: 0x9AE7,
	21731: 0x9AE8,
	21732: 0x9AE9,
	21733: 0x9AEA,
	21734: 0x9AEC,
	21735: 0x9AEE,
	21736: 0x9AF0,
	21737: 0x9AF1,
	21738: 0x9AF2,
	21739: 0x9AF3,
	21740: 0x9AF4,
	21741: 0x9AF5,
	21742: 0x9AF6,
	21743: 0x9AF7,
	21744: 0x9AF8,
	21745: 0x9AFA,
	21746: 0x9AFC,
	21747: 0x9AFD,
	21748: 0x9AFE,
	21749: 0x9AFF,
	21750: 0x9B00,
	21751: 0x9B01,
	21752: 0x9B02,
	21753: 0x9B04,
	21754: 0x9B05,
	21755: 0x9B06,
	21756: 0x87C6,
	21757: 0x8788,
	21758: 0x8785,
	21759: 0x87AD,
	21760: 0x8797,
	21761: 0x8783,
	21762: 0x87AB,
	21763: 0x87E5,
	21764: 0x87AC,
	21765: 0x87B5,
	21766: 0x87B3,
	21767: 0x87CB,
	21768: 0x87D3,
	21769: 0x87BD,
	21770: 0x87D1,
	21771: 0x87C0,
	21772: 0x87CA,
	21773: 0x87DB,
	21774: 0x87EA,
	21775: 0x87E0,
	21776: 0x87EE,
	21777: 0x8816,
	21778: 0x8813,
	21779: 0x87FE,
	21780: 0x880A,
	21781: 0x881B,
	21782: 0x8821,
	21783: 0x8839,
	21784: 0x883C,
	21785: 0x7F36,
	21786: 0x7F42,
	21787: 0x7F44,
	21788: 0x7F45,
	21789: 0x8210,
	21790: 0x7AFA,
	21791: 0x7AFD,
	21792: 0x7B08,
	21793: 0x7B03,
	21794: 0x7B04,
	21795: 0x7B15,
	21796: 0x7B0A,
	21797: 0x7B2B,
	21798: 0x7B0F,
	21799: 0x7B47,
	21800: 0x7B38,
	21801: 0x7B2A,
	21802: 0x7B19,
	21803: 0x7B2E,
	21804: 0x7B31,
	21805: 0x7B20,
	21806: 0x7B25,
	21807: 0x7B24,
	21808: 0x7B33,
	21809: 0x7B3E,
	21810: 0x7B1E,
	21811: 0x7B58,
	21812: 0x7B5A,
	21813: 0x7B45,
	21814: 0x7B75,
	21815: 0x7B4C,
	21816: 0x7B5D,
	21817: 0x7B60,
	21818: 0x7B6E,
	21819: 0x7B7B,
	21820: 0x7B62,
	21821: 0x7B72,
	21822: 0x7B71,
	21823: 0x7B90,
	21824: 0x7BA6,
	21825: 0x7BA7,
	21826: 0x7BB8,
	21827: 0x7BAC,
	21828: 0x7B9D,
	21829: 0x7BA8,
	21830: 0x7B85,
	21831: 0x7BAA,
	21832: 0x7B9C,
	21833: 0x7BA2,
	21834: 0x7BAB,
	21835: 0x7BB4,
	21836: 0x7BD1,
	21837: 0x7BC1,
	21838: 0x7BCC,
	21839: 0x7BDD,
	21840: 0x7BDA,
	21841: 0x7BE5,
	21842: 0x7BE6,
	21843: 0x7BEA,
	21844: 0x7C0C,
	21845: 0x7BFE,
	21846: 0x7BFC,
	21847: 0x7C0F,
	21848: 0x7C16,
	21849: 0x7C0B,
	21850: 0x9B07,
	21851: 0x9B09,
	21852: 0x9B0A,
	21853: 0x9B0B,
	21854: 0x9B0C,
	21855: 0x9B0D,
	21856: 0x9B0E,
	21857: 0x9B10,
	21858: 0x9B11,
	21859: 0x9B12,
	21860: 0x9B14,
	21861: 0x9B15,
	21862: 0x9B16,
	21863: 0x9B17,
	21864: 0x9B18,
	21865: 0x9B19,
	21866: 0x9B1A,
	21867: 0x9B1B,
	21868: 0x9B1C,
	21869: 0x9B1D,
	21870: 0x9B1E,
	21871: 0x9B20,
	21872: 0x9B21,
	21873: 0x9B22,
	21874: 0x9B24,
	21875: 0x9B25,
	21876: 0x9B26,
	21877: 0x9B27,
	21878: 0x9B28,
	21879: 0x9B29,
	21880: 0x9B2A,
	21881: 0x9B2B,
	21882: 0x9B2C,
	21883: 0x9B2D,
	21884: 0x9B2E,
	21885: 0x9B30,
	21886: 0x9B31,
	21887: 0x9B33,
	21888: 0x9B34,
	21889: 0x9B35,
	21890: 0x9B36,
	21891: 0x9B37,
	21892: 0x9B38,
	21893: 0x9B39,
	21894: 0x9B3A,
	21895: 0x9B3D,
	21896: 0x9B3E,
	21897: 0x9B3F,
	21898: 0x9B40,
	21899: 0x9B46,
	21900: 0x9B4A,
	21901: 0x9B4B,
	21902: 0x9B4C,
	21903: 0x9B4E,
	21904: 0x9B50,
	21905: 0x9B52,
	21906: 0x9B53,
	21907: 0x9B55,
	21908: 0x9B56,
	21909: 0x9B57,
	21910: 0x9B58,
	21911: 0x9B59,
	21912: 0x9B5A,
	21913: 0x9B5B,
	21914: 0x9B5C,
	21915: 0x9B5D,
	21916: 0x9B5E,
	21917: 0x9B5F,
	21918: 0x9B60,
	21919: 0x9B61,
	21920: 0x9B62,
	21921: 0x9B63,
	21922: 0x9B64,
	21923: 0x9B65,
	21924: 0x9B66,
	21925: 0x9B67,
	21926: 0x9B68,
	21927: 0x9B69,
	21928: 0x9B6A,
	21929: 0x9B6B,
	21930: 0x9B6C,
	21931: 0x9B6D,
	21932: 0x9B6E,
	21933: 0x9B6F,
	21934: 0x9B70,
	21935: 0x9B71,
	21936: 0x9B72,
	21937: 0x9B73,
	21938: 0x9B74,
	21939: 0x9B75,
	21940: 0x9B76,
	21941: 0x9B77,
	21942: 0x9B78,
	21943: 0x9B79,
	21944: 0x9B7A,
	21945: 0x9B7B,
	21946: 0x7C1F,
	21947: 0x7C2A,
	21948: 0x7C26,
	21949: 0x7C38,
	21950: 0x7C41,
	21951: 0x7C40,
	21952: 0x81FE,
	21953: 0x8201,
	21954: 0x8202,
	21955: 0x8204,
	21956: 0x81EC,
	21957: 0x8844,
	21958: 0x8221,
	21959: 0x8222,
	21960: 0x8223,
	21961: 0x822D,
	21962: 0x822F,
	21963: 0x8228,
	21964: 0x822B,
	21965: 0x8238,
	21966: 0x823B,
	21967: 0x8233,
	21968: 0x8234,
	21969: 0x823E,
	21970: 0x8244,
	21971: 0x8249,
	21972: 0x824B,
	21973: 0x824F,
	21974: 0x825A,
	21975: 0x825F,
	21976: 0x8268,
	21977: 0x887E,
	21978: 0x8885,
	21979: 0x8888,
	21980: 0x88D8,
	21981: 0x88DF,
	21982: 0x895E,
	21983: 0x7F9D,
	21984: 0x7F9F,
	21985: 0x7FA7,
	21986: 0x7FAF,
	21987: 0x7FB0,
	21988: 0x7FB2,
	21989: 0x7C7C,
	21990: 0x6549,
	21991: 0x7C91,
	21992: 0x7C9D,
	21993: 0x7C9C,
	21994: 0x7C9E,
	21995: 0x7CA2,
	21996: 0x7CB2,
	21997: 0x7CBC,
	21998: 0x7CBD,
	21999: 0x7CC1,
	22000: 0x7CC7,
	22001: 0x7CCC,
	22002: 0x7CCD,
	22003: 0x7CC8,
	22004: 0x7CC5,
	22005: 0x7CD7,
	22006: 0x7CE8,
	22007: 0x826E,
	22008: 0x66A8,
	22009: 0x7FBF,
	22010: 0x7FCE,
	22011: 0x7FD5,
	22012: 0x7FE5,
	22013: 0x7FE1,
	22014: 0x7FE6,
	22015: 0x7FE9,
	22016: 0x7FEE,
	22017: 0x7FF3,
	22018: 0x7CF8,
	22019: 0x7D77,
	22020: 0x7DA6,
	22021: 0x7DAE,
	22022: 0x7E47,
	22023: 0x7E9B,
	22024: 0x9EB8,
	22025: 0x9EB4,
	22026: 0x8D73,
	22027: 0x8D84,
	22028: 0x8D94,
	22029: 0x8D91,
	22030: 0x8DB1,
	22031: 0x8D67,
	22032: 0x8D6D,
	22033: 0x8C47,
	22034: 0x8C49,
	22035: 0x914A,
	22036: 0x9150,
	22037: 0x914E,
	22038: 0x914F,
	22039: 0x9164,
	22040: 0x9B7C,
	22041: 0x9B7D,
	22042: 0x9B7E,
	22043: 0x9B7F,
	22044: 0x9B80,
	22045: 0x9B81,
	22046: 0x9B82,
	22047: 0x9B83,
	22048: 0x9B84,
	22049: 0x9B85,
	22050: 0x9B86,
	22051: 0x9B87,
	22052: 0x9B88,
	22053: 0x9B89,
	22054: 0x9B8A,
	22055: 0x9B8B,
	22056: 0x9B8C,
	22057: 0x9B8D,
	22058: 0x9B8E,
	22059: 0x9B8F,
	22060: 0x9B90,
	22061: 0x9B91,
	22062: 0x9B92,
	22063: 0x9B93,
	22064: 0x9B94,
	22065: 0x9B95,
	22066: 0x9B96,
	22067: 0x9B97,
	22068: 0x9B98,
	22069: 0x9B99,
	22070: 0x9B9A,
	22071: 0x9B9B,
	22072: 0x9B9C,
	22073: 0x9B9D,
	22074: 0x9B9E,
	22075: 0x9B9F,
	22076: 0x9BA0,
	22077: 0x9BA1,
	22078: 0x9BA2,
	22079: 0x9BA3,
	22080: 0x9BA4,
	22081: 0x9BA5,
	22082: 0x9BA6,
	22083: 0x9BA7,
	22084: 0x9BA8,
	22085: 0x9BA9,
	22086: 0x9BAA,
	22087: 0x9BAB,
	22088: 0x9BAC,
	22089: 0x9BAD,
	22090: 0x9BAE,
	22091: 0x9BAF,
	22092: 0x9BB0,
	22093: 0x9BB1,
	22094: 0x9BB2,
	22095: 0x9BB3,
	22096: 0x9BB4,
	22097: 0x9BB5,
	22098: 0x9BB6,
	22099: 0x9BB7,
	22100: 0x9BB8,
	22101: 0x9BB9,
	22102: 0x9BBA,
	22103: 0x9BBB,
	22104: 0x9BBC,
	22105: 0x9BBD,
	22106: 0x9BBE,
	22107: 0x9BBF,
	22108: 0x9BC0,
	22109: 0x9BC1,
	22110: 0x9BC2,
	22111: 0x9BC3,
	22112: 0x9BC4,
	22113: 0x9BC5,
	22114: 0x9BC6,
	22115: 0x9BC7,
	22116: 0x9BC8,
	22117: 0x9BC9,
	22118: 0x9BCA,
	22119: 0x9BCB,
	22120: 0x9BCC,
	22121: 0x9BCD,
	22122: 0x9BCE,
	22123: 0x9BCF,
	22124: 0x9BD0,
	22125: 0x9BD1,
	22126: 0x9BD2,
	22127: 0x9BD3,
	22128: 0x9BD4,
	22129: 0x9BD5,
	22130: 0x9BD6,
	22131: 0x9BD7,
	22132: 0x9BD8,
	22133: 0x9BD9,
	22134: 0x9BDA,
	22135: 0x9BDB,
	22136: 0x9162,
	22137: 0x9161,
	22138: 0x9170,
	22139: 0x9169,
	22140: 0x916F,
	22141: 0x917D,
	22142: 0x917E,
	22143: 0x9172,
	22144: 0x9174,
	22145: 0x9179,
	22146: 0x918C,
	22147: 0x9185,
	22148: 0x9190,
	22149: 0x918D,
	22150: 0x9191,
	22151: 0x91A2,
	22152: 0x91A3,
	22153: 0x91AA,
	22154: 0x91AD,
	22155: 0x91AE,
	22156: 0x91AF,
	22157: 0x91B5,
	22158: 0x91B4,
	22159: 0x91BA,
	22160: 0x8C55,
	22161: 0x9E7E,
	22162: 0x8DB8,
	22163: 0x8DEB,
	22164: 0x8E05,
	22165: 0x8E59,
	22166: 0x8E69,
	22167: 0x8DB5,
	22168: 0x8DBF,
	22169: 0x8DBC,
	22170: 0x8DBA,
	22171: 0x8DC4,
	22172: 0x8DD6,
	22173: 0x8DD7,
	22174: 0x8DDA,
	22175: 0x8DDE,
	22176: 0x8DCE,
	22177: 0x8DCF,
	22178: 0x8DDB,
	22179: 0x8DC6,
	22180: 0x8DEC,
	22181: 0x8DF7,
	22182: 0x8DF8,
	22183: 0x8DE3,
	22184: 0x8DF9,
	22185: 0x8DFB,
	22186: 0x8DE4,
	22187: 0x8E09,
	22188: 0x8DFD,
	22189: 0x8E14,
	22190: 0x8E1D,
	22191: 0x8E1F,
	22192: 0x8E2C,
	22193: 0x8E2E,
	22194: 0x8E23,
	22195: 0x8E2F,
	22196: 0x8E3A,
	22197: 0x8E40,
	22198: 0x8E39,
	22199: 0x8E35,
	22200: 0x8E3D,
	22201: 0x8E31,
	22202: 0x8E49,
	22203: 0x8E41,
	22204: 0x8E42,
	22205: 0x8E51,
	22206: 0x8E52,
	22207: 0x8E4A,
	22208: 0x8E70,
	22209: 0x8E76,
	22210: 0x8E7C,
	22211: 0x8E6F,
	22212: 0x8E74,
	22213: 0x8E85,
	22214: 0x8E8F,
	22215: 0x8E94,
	22216: 0x8E90,
	22217: 0x8E9C,
	22218: 0x8E9E,
	22219: 0x8C78,
	22220: 0x8C82,
	22221: 0x8C8A,
	22222: 0x8C85,
	22223: 0x8C98,
	22224: 0x8C94,
	22225: 0x659B,
	22226: 0x89D6,
	22227: 0x89DE,
	22228: 0x89DA,
	22229: 0x89DC,
	22230: 0x9BDC,
	22231: 0x9BDD,
	22232: 0x9BDE,
	22233: 0x9BDF,
	22234: 0x9BE0,
	22235: 0x9BE1,
	22236: 0x9BE2,
	22237: 0x9BE3,
	22238: 0x9BE4,
	22239: 0x9BE5,
	22240: 0x9BE6,
	22241: 0x9BE7,
	22242: 0x9BE8,
	22243: 0x9BE9,
	22244: 0x9BEA,
	22245: 0x9BEB,
	22246: 0x9BEC,
	22247: 0x9BED,
	22248: 0x9BEE,
	22249: 0x9BEF,
	22250: 0x9BF0,
	22251: 0x9BF1,
	22252: 0x9BF2,
	22253: 0x9BF3,
	22254: 0x9BF4,
	22255: 0x9BF5,
	22256: 0x9BF6,
	22257: 0x9BF7,
	22258: 0x9BF8,
	22259: 0x9BF9,
	22260: 0x9BFA,
	22261: 0x9BFB,
	22262: 0x9BFC,
	22263: 0x9BFD,
	22264: 0x9BFE,
	22265: 0x9BFF,
	22266: 0x9C00,
	22267: 0x9C01,
	22268: 0x9C02,
	22269: 0x9C03,
	22270: 0x9C04,
	22271: 0x9C05,
	22272: 0x9C06,
	22273: 0x9C07,
	22274: 0x9C08,
	22275: 0x9C09,
	22276: 0x9C0A,
	22277: 0x9C0B,
	22278: 0x9C0C,
	22279: 0x9C0D,
	22280: 0x9C0E,
	22281: 0x9C0F,
	22282: 0x9C10,
	22283: 0x9C11,
	22284: 0x9C12,
	22285: 0x9C13,
	22286: 0x9C14,
	22287: 0x9C15,
	22288: 0x9C16,
	22289: 0x9C17,
	22290: 0x9C18,
	22291: 0x9C19,
	22292: 0x9C1A,
	22293: 0x9C1B,
	22294: 0x9C1C,
	22295: 0x9C1D,
	22296: 0x9C1E,
	22297: 0x9C1F,
	22298: 0x9C20,
	22299: 0x9C21,
	22300: 0x9C22,
	22301: 0x9C23,
	22302: 0x9C24,
	22303: 0x9C25,
	22304: 0x9C26,
	22305: 0x9C27,
	22306: 0x9C28,
	22307: 0x9C29,
	22308: 0x9C2A,
	22309: 0x9C2B,
	22310: 0x9C2C,
	22311: 0x9C2D,
	22312: 0x9C2E,
	22313: 0x9C2F,
	22314: 0x9C30,
	22315: 0x9C31,
	22316: 0x9C32,
	22317: 0x9C33,
	22318: 0x9C34,
	22319: 0x9C35,
	22320: 0x9C36,
	22321: 0x9C37,
	22322: 0x9C38,
	22323: 0x9C39,
	22324: 0x9C3A,
	22325: 0x9C3B,
	22326: 0x89E5,
	22327: 0x89EB,
	22328: 0x89EF,
	22329: 0x8A3E,
	22330: 0x8B26,
	22331: 0x9753,
	22332: 0x96E9,
	22333: 0x96F3,
	22334: 0x96EF,
	22335: 0x9706,
	22336: 0x9701,
	22337: 0x9708,
	22338: 0x970F,
	22339: 0x970E,
	22340: 0x972A,
	22341: 0x972D,
	22342: 0x9730,
	22343: 0x973E,
	22344: 0x9F80,
	22345: 0x9F83,
	22346: 0x9F85,
	22347: 0x9F86,
	22348: 0x9F87,
	22349: 0x9F88,
	22350: 0x9F89,
	22351: 0x9F8A,
	22352: 0x9F8C,
	22353: 0x9EFE,
	22354: 0x9F0B,
	22355: 0x9F0D,
	22356: 0x96B9,
	22357: 0x96BC,
	22358: 0x96BD,
	22359: 0x96CE,
	22360: 0x96D2,
	22361: 0x77BF,
	22362: 0x96E0,
	22363: 0x928E,
	22364: 0x92AE,
	22365: 0x92C8,
	22366: 0x933E,
	22367: 0x936A,
	22368: 0x93CA,
	22369: 0x938F,
	22370: 0x943E,
	22371: 0x946B,
	22372: 0x9C7F,
	22373: 0x9C82,
	22374: 0x9C85,
	22375: 0x9C86,
	22376: 0x9C87,
	22377: 0x9C88,
	22378: 0x7A23,
	22379: 0x9C8B,
	22380: 0x9C8E,
	22381: 0x9C90,
	22382: 0x9C91,
	22383: 0x9C92,
	22384: 0x9C94,
	22385: 0x9C95,
	22386: 0x9C9A,
	22387: 0x9C9B,
	22388: 0x9C9E,
	22389: 0x9C9F,
	22390: 0x9CA0,
	22391: 0x9CA1,
	22392: 0x9CA2,
	22393: 0x9CA3,
	22394: 0x9CA5,
	22395: 0x9CA6,
	22396: 0x9CA7,
	22397: 0x9CA8,
	22398: 0x9CA9,
	22399: 0x9CAB,
	22400: 0x9CAD,
	22401: 0x9CAE,
	22402: 0x9CB0,
	22403: 0x9CB1,
	22404: 0x9CB2,
	22405: 0x9CB3,
	22406: 0x9CB4,
	22407: 0x9CB5,
	22408: 0x9CB6,
	22409: 0x9CB7,
	22410: 0x9CBA,
	22411: 0x9CBB,
	22412: 0x9CBC,
	22413: 0x9CBD,
	22414: 0x9CC4,
	22415: 0x9CC5,
	22416: 0x9CC6,
	22417: 0x9CC7,
	22418: 0x9CCA,
	22419: 0x9CCB,
	22420: 0x9C3C,
	22421: 0x9C3D,
	22422: 0x9C3E,
	22423: 0x9C3F,
	22424: 0x9C40,
	22425: 0x9C41,
	22426: 0x9C42,
	22427: 0x9C43,
	22428: 0x9C44,
	22429: 0x9C45,
	22430: 0x9C46,
	22431: 0x9C47,
	22432: 0x9C48,
	22433: 0x9C49,
	22434: 0x9C4A,
	22435: 0x9C4B,
	22436: 0x9C4C,
	22437: 0x9C4D,
	22438: 0x9C4E,
	22439: 0x9C4F,
	22440: 0x9C50,
	22441: 0x9C51,
	22442: 0x9C52,
	22443: 0x9C53,
	22444: 0x9C54,
	22445: 0x9C55,
	22446: 0x9C56,
	22447: 0x9C57,
	22448: 0x9C58,
	22449: 0x9C59,
	22450: 0x9C5A,
	22451: 0x9C5B,
	22452: 0x9C5C,
	22453: 0x9C5D,
	22454: 0x9C5E,
	22455: 0x9C5F,
	22456: 0x9C60,
	22457: 0x9C61,
	22458: 0x9C62,
	22459: 0x9C63,
	22460: 0x9C64,
	22461: 0x9C65,
	22462: 0x9C66,
	22463: 0x9C67,
	22464: 0x9C68,
	22465: 0x9C69,
	22466: 0x9C6A,
	22467: 0x9C6B,
	22468: 0x9C6C,
	22469: 0x9C6D,
	22470: 0x9C6E,
	22471: 0x9C6F,
	22472: 0x9C70,
	22473: 0x9C71,
	22474: 0x9C72,
	22475: 0x9C73,
	22476: 0x9C74,
	22477: 0x9C75,
	22478: 0x9C76,
	22479: 0x9C77,
	22480: 0x9C78,
	22481: 0x9C79,
	22482: 0x9C7A,
	22483: 0x9C7B,
	22484: 0x9C7D,
	22485: 0x9C7E,
	22486: 0x9C80,
	22487: 0x9C83,
	22488: 0x9C84,
	22489: 0x9C89,
	22490: 0x9C8A,
	22491: 0x9C8C,
	22492: 0x9C8F,
	22493: 0x9C93,
	22494: 0x9C96,
	22495: 0x9C97,
	22496: 0x9C98,
	22497: 0x9C99,
	22498: 0x9C9D,
	22499: 0x9CAA,
	22500: 0x9CAC,
	22501: 0x9CAF,
	22502: 0x9CB9,
	22503: 0x9CBE,
	22504: 0x9CBF,
	22505: 0x9CC0,
	22506: 0x9CC1,
	22507: 0x9CC2,
	22508: 0x9CC8,
	22509: 0x9CC9,
	22510: 0x9CD1,
	22511: 0x9CD2,
	22512: 0x9CDA,
	22513: 0x9CDB,
	22514: 0x9CE0,
	22515: 0x9CE1,
	22516: 0x9CCC,
	22517: 0x9CCD,
	22518: 0x9CCE,
	22519: 0x9CCF,
	22520: 0x9CD0,
	22521: 0x9CD3,
	22522: 0x9CD4,
	22523: 0x9CD5,
	22524: 0x9CD7,
	22525: 0x9CD8,
	22526: 0x9CD9,
	22527: 0x9CDC,
	22528: 0x9CDD,
	22529: 0x9CDF,
	22530: 0x9CE2,
	22531: 0x977C,
	22532: 0x9785,
	22533: 0x9791,
	22534: 0x9792,
	22535: 0x9794,
	22536: 0x97AF,
	22537: 0x97AB,
	22538: 0x97A3,
	22539: 0x97B2,
	22540: 0x97B4,
	22541: 0x9AB1,
	22542: 0x9AB0,
	22543: 0x9AB7,
	22544: 0x9E58,
	22545: 0x9AB6,
	22546: 0x9ABA,
	22547: 0x9ABC,
	22548: 0x9AC1,
	22549: 0x9AC0,
	22550: 0x9AC5,
	22551: 0x9AC2,
	22552: 0x9ACB,
	22553: 0x9ACC,
	22554: 0x9AD1,
	22555: 0x9B45,
	22556: 0x9B43,
	22557: 0x9B47,
	22558: 0x9B49,
	22559: 0x9B48,
	22560: 0x9B4D,
	22561: 0x9B51,
	22562: 0x98E8,
	22563: 0x990D,
	22564: 0x992E,
	22565: 0x9955,
	22566: 0x9954,
	22567: 0x9ADF,
	22568: 0x9AE1,
	22569: 0x9AE6,
	22570: 0x9AEF,
	22571: 0x9AEB,
	22572: 0x9AFB,
	22573: 0x9AED,
	22574: 0x9AF9,
	22575: 0x9B08,
	22576: 0x9B0F,
	22577: 0x9B13,
	22578: 0x9B1F,
	22579: 0x9B23,
	22580: 0x9EBD,
	22581: 0x9EBE,
	22582: 0x7E3B,
	22583: 0x9E82,
	22584: 0x9E87,
	22585: 0x9E88,
	22586: 0x9E8B,
	22587: 0x9E92,
	22588: 0x93D6,
	22589: 0x9E9D,
	22590: 0x9E9F,
	22591: 0x9EDB,
	22592: 0x9EDC,
	22593: 0x9EDD,
	22594: 0x9EE0,
	22595: 0x9EDF,
	22596: 0x9EE2,
	22597: 0x9EE9,
	22598: 0x9EE7,
	22599: 0x9EE5,
	22600: 0x9EEA,
	22601: 0x9EEF,
	22602: 0x9F22,
	22603: 0x9F2C,
	22604: 0x9F2F,
	22605: 0x9F39,
	22606: 0x9F37,
	22607: 0x9F3D,
	22608: 0x9F3E,
	22609: 0x9F44,
	22610: 0x9CE3,
	22611: 0x9CE4,
	22612: 0x9CE5,
	22613: 0x9CE6,
	22614: 0x9CE7,
	22615: 0x9CE8,
	22616: 0x9CE9,
	22617: 0x9CEA,
	22618: 0x9CEB,
	22619: 0x9CEC,
	22620: 0x9CED,
	22621: 0x9CEE,
	22622: 0x9CEF,
	22623: 0x9CF0,
	22624: 0x9CF1,
	22625: 0x9CF2,
	22626: 0x9CF3,
	22627: 0x9CF4,
	22628: 0x9CF5,
	22629: 0x9CF6,
	22630: 0x9CF7,
	22631: 0x9CF8,
	22632: 0x9CF9,
	22633: 0x9CFA,
	22634: 0x9CFB,
	22635: 0x9CFC,
	22636: 0x9CFD,
	22637: 0x9CFE,
	22638: 0x9CFF,
	22639: 0x9D00,
	22640: 0x9D01,
	22641: 0x9D02,
	22642: 0x9D03,
	22643: 0x9D04,
	22644: 0x9D05,
	22645: 0x9D06,
	22646: 0x9D07,
	22647: 0x9D08,
	22648: 0x9D09,
	22649: 0x9D0A,
	22650: 0x9D0B,
	22651: 0x9D0C,
	22652: 0x9D0D,
	22653: 0x9D0E,
	22654: 0x9D0F,
	22655: 0x9D10,
	22656: 0x9D11,
	22657: 0x9D12,
	22658: 0x9D13,
	22659: 0x9D14,
	22660: 0x9D15,
	22661: 0x9D16,
	22662: 0x9D17,
	22663: 0x9D18,
	22664: 0x9D19,
	22665: 0x9D1A,
	22666: 0x9D1B,
	22667: 0x9D1C,
	22668: 0x9D1D,
	22669: 0x9D1E,
	22670: 0x9D1F,
	22671: 0x9D20,
	22672: 0x9D21,
	22673: 0x9D22,
	22674: 0x9D23,
	22675: 0x9D24,
	22676: 0x9D25,
	22677: 0x9D26,
	22678: 0x9D27,
	22679: 0x9D28,
	22680: 0x9D29,
	22681: 0x9D2A,
	22682: 0x9D2B,
	22683: 0x9D2C,
	22684: 0x9D2D,
	22685: 0x9D2E,
	22686: 0x9D2F,
	22687: 0x9D30,
	22688: 0x9D31,
	22689: 0x9D32,
	22690: 0x9D33,
	22691: 0x9D34,
	22692: 0x9D35,
	22693: 0x9D36,
	22694: 0x9D37,
	22695: 0x9D38,
	22696: 0x9D39,
	22697: 0x9D3A,
	22698: 0x9D3B,
	22699: 0x9D3C,
	22700: 0x9D3D,
	22701: 0x9D3E,
	22702: 0x9D3F,
	22703: 0x9D40,
	22704: 0x9D41,
	22705: 0x9D42,
	22800: 0x9D43,
	22801: 0x9D44,
	22802: 0x9D45,
	22803: 0x9D46,
	22804: 0x9D47,
	22805: 0x9D48,
	22806: 0x9D49,
	22807: 0x9D4A,
	22808: 0x9D4B,
	22809: 0x9D4C,
	22810: 0x9D4D,
	22811: 0x9D4E,
	22812: 0x9D4F,
	22813: 0x9D50,
	22814: 0x9D51,
	22815: 0x9D52,
	22816: 0x9D53,
	22817: 0x9D54,
	22818: 0x9D55,
	22819: 0x9D56,
	22820: 0x9D57,
	22821: 0x9D58,
	22822: 0x9D59,
	22823: 0x9D5A,
	22824: 0x9D5B,
	22825: 0x9D5C,
	22826: 0x9D5D,
	22827: 0x9D5E,
	22828: 0x9D5F,
	22829: 0x9D60,
	22830: 0x9D61,
	22831: 0x9D62,
	22832: 0x9D63,
	22833: 0x9D64,
	22834: 0x9D65,
	22835: 0x9D66,
	22836: 0x9D67,
	22837: 0x9D68,
	22838: 0x9D69,
	22839: 0x9D6A,
	22840: 0x9D6B,
	22841: 0x9D6C,
	22842: 0x9D6D,
	22843: 0x9D6E,
	22844: 0x9D6F,
	22845: 0x9D70,
	22846: 0x9D71,
	22847: 0x9D72,
	22848: 0x9D73,
	22849: 0x9D74,
	22850: 0x9D75,
	22851: 0x9D76,
	22852: 0x9D77,
	22853: 0x9D78,
	22854: 0x9D79,
	22855: 0x9D7A,
	22856: 0x9D7B,
	22857: 0x9D7C,
	22858: 0x9D7D,
	22859: 0x9D7E,
	22860: 0x9D7F,
	22861: 0x9D80,
	22862: 0x9D81,
	22863: 0x9D82,
	22864: 0x9D83,
	22865: 0x9D84,
	22866: 0x9D85,
	22867: 0x9D86,
	22868: 0x9D87,
	22869: 0x9D88,
	22870: 0x9D89,
	22871: 0x9D8A,
	22872: 0x9D8B,
	22873: 0x9D8C,
	22874: 0x9D8D,
	22875: 0x9D8E,
	22876: 0x9D8F,
	22877: 0x9D90,
	22878: 0x9D91,
	22879: 0x9D92,
	22880: 0x9D93,
	22881: 0x9D94,
	22882: 0x9D95,
	22883: 0x9D96,
	22884: 0x9D97,
	22885: 0x9D98,
	22886: 0x9D99,
	22887: 0x9D9A,
	22888: 0x9D9B,
	22889: 0x9D9C,
	22890: 0x9D9D,
	22891: 0x9D9E,
	22892: 0x9D9F,
	22893: 0x9DA0,
	22894: 0x9DA1,
	22895: 0x9DA2,
	22990: 0x9DA3,
	22991: 0x9DA4,
	22992: 0x9DA5,
	22993: 0x9DA6,
	22994: 0x9DA7,
	22995: 0x9DA8,
	22996: 0x9DA9,
	22997: 0x9DAA,
	22998: 0x9DAB,
	22999: 0x9DAC,
	23000: 0x9DAD,
	23001: 0x9DAE,
	23002: 0x9DAF,
	23003: 0x9DB0,
	23004: 0x9DB1,
	23005: 0x9DB2,
	23006: 0x9DB3,
	23007: 0x9DB4,
	23008: 0x9DB5,
	23009: 0x9DB6,
	23010: 0x9DB7,
	23011: 0x9DB8,
	23012: 0x9DB9,
	23013: 0x9DBA,
	23014: 0x9DBB,
	23015: 0x9DBC,
	23016: 0x9DBD,
	23017: 0x9DBE,
	23018: 0x9DBF,
	23019: 0x9DC0,
	23020: 0x9DC1,
	23021: 0x9DC2,
	23022: 0x9DC3,
	23023: 0x9DC4,
	23024: 0x9DC5,
	23025: 0x9DC6,
	23026: 0x9DC7,
	23027: 0x9DC8,
	23028: 0x9DC9,
	23029: 0x9DCA,
	23030: 0x9DCB,
	23031: 0x9DCC,
	23032: 0x9DCD,
	23033: 0x9DCE,
	23034: 0x9DCF,
	23035: 0x9DD0,
	23036: 0x9DD1,
	23037: 0x9DD2,
	23038: 0x9DD3,
	23039: 0x9DD4,
	23040: 0x9DD5,
	23041: 0x9DD6,
	23042: 0x9DD7,
	23043: 0x9DD8,
	23044: 0x9DD9,
	23045: 0x9DDA,
	23046: 0x9DDB,
	23047: 0x9DDC,
	23048: 0x9DDD,
	23049: 0x9DDE,
	23050: 0x9DDF,
	23051: 0x9DE0,
	23052: 0x9DE1,
	23053: 0x9DE2,
	23054: 0x9DE3,
	23055: 0x9DE4,
	23056: 0x9DE5,
	23057: 0x9DE6,
	23058: 0x9DE7,
	23059: 0x9DE8,
	23060: 0x9DE9,
	23061: 0x9DEA,
	23062: 0x9DEB,
	23063: 0x9DEC,
	23064: 0x9DED,
	23065: 0x9DEE,
	23066: 0x9DEF,
	23067: 0x9DF0,
	23068: 0x9DF1,
	23069: 0x9DF2,
	23070: 0x9DF3,
	23071: 0x9DF4,
	23072: 0x9DF5,
	23073: 0x9DF6,
	23074: 0x9DF7,
	23075: 0x9DF8,
	23076: 0x9DF9,
	23077: 0x9DFA,
	23078: 0x9DFB,
	23079: 0x9DFC,
	23080: 0x9DFD,
	23081: 0x9DFE,
	23082: 0x9DFF,
	23083: 0x9E00,
	23084: 0x9E01,
	23085: 0x9E02,
	23180: 0x9E03,
	23181: 0x9E04,
	23182: 0x9E05,
	23183: 0x9E06,
	23184: 0x9E07,
	23185: 0x9E08,
	23186: 0x9E09,
	23187: 0x9E0A,
	23188: 0x9E0B,
	23189: 0x9E0C,
	23190: 0x9E0D,
	23191: 0x9E0E,
	23192: 0x9E0F,
	23193: 0x9E10,
	23194: 0x9E11,
	23195: 0x9E12,
	23196: 0x9E13,
	23197: 0x9E14,
	23198: 0x9E15,
	23199: 0x9E16,
	23200: 0x9E17,
	23201: 0x9E18,
	23202: 0x9E19,
	23203: 0x9E1A,
	23204: 0x9E1B,
	23205: 0x9E1C,
	23206: 0x9E1D,
	23207: 0x9E1E,
	23208: 0x9E24,
	23209: 0x9E27,
	23210: 0x9E2E,
	23211: 0x9E30,
	23212: 0x9E34,
	23213: 0x9E3B,
	23214: 0x9E3C,
	23215: 0x9E40,
	23216: 0x9E4D,
	23217: 0x9E50,
	23218: 0x9E52,
	23219: 0x9E53,
	23220: 0x9E54,
	23221: 0x9E56,
	23222: 0x9E59,
	23223: 0x9E5D,
	23224: 0x9E5F,
	23225: 0x9E60,
	23226: 0x9E61,
	23227: 0x9E62,
	23228: 0x9E65,
	23229: 0x9E6E,
	23230: 0x9E6F,
	23231: 0x9E72,
	23232: 0x9E74,
	23233: 0x9E75,
	23234: 0x9E76,
	23235: 0x9E77,
	23236: 0x9E78,
	23237: 0x9E79,
	23238: 0x9E7A,
	23239: 0x9E7B,
	23240: 0x9E7C,
	23241: 0x9E7D,
	23242: 0x9E80,
	23243: 0x9E81,
	23244: 0x9E83,
	23245: 0x9E84,
	23246: 0x9E85,
	23247: 0x9E86,
	23248: 0x9E89,
	23249: 0x9E8A,
	23250: 0x9E8C,
	23251: 0x9E8D,
	23252: 0x9E8E,
	23253: 0x9E8F,
	23254: 0x9E90,
	23255: 0x9E91,
	23256: 0x9E94,
	23257: 0x9E95,
	23258: 0x9E96,
	23259: 0x9E97,
	23260: 0x9E98,
	23261: 0x9E99,
	23262: 0x9E9A,
	23263: 0x9E9B,
	23264: 0x9E9C,
	23265: 0x9E9E,
	23266: 0x9EA0,
	23267: 0x9EA1,
	23268: 0x9EA2,
	23269: 0x9EA3,
	23270: 0x9EA4,
	23271: 0x9EA5,
	23272: 0x9EA7,
	23273: 0x9EA8,
	23274: 0x9EA9,
	23275: 0x9EAA,
	23370: 0x9EAB,
	23371: 0x9EAC,
	23372: 0x9EAD,
	23373: 0x9EAE,
	23374: 0x9EAF,
	23375: 0x9EB0,
	23376: 0x9EB1,
	23377: 0x9EB2,
	23378: 0x9EB3,
	23379: 0x9EB5,
	23380: 0x9EB6,
	23381: 0x9EB7,
	23382: 0x9EB9,
	23383: 0x9EBA,
	23384: 0x9EBC,
	23385: 0x9EBF,
	23386: 0x9EC0,
	23387: 0x9EC1,
	23388: 0x9EC2,
	23389: 0x9EC3,
	23390: 0x9EC5,
	23391: 0x9EC6,
	23392: 0x9EC7,
	23393: 0x9EC8,
	23394: 0x9ECA,
	23395: 0x9ECB,
	23396: 0x9ECC,
	23397: 0x9ED0,
	23398: 0x9ED2,
	23399: 0x9ED3,
	23400: 0x9ED5,
	23401: 0x9ED6,
	23402: 0x9ED7,
	23403: 0x9ED9,
	23404: 0x9EDA,
	23405: 0x9EDE,
	23406: 0x9EE1,
	23407: 0x9EE3,
	23408: 0x9EE4,
	23409: 0x9EE6,
	23410: 0x9EE8,
	23411: 0x9EEB,
	23412: 0x9EEC,
	23413: 0x9EED,
	23414: 0x9EEE,
	23415: 0x9EF0,
	23416: 0x9EF1,
	23417: 0x9EF2,
	23418: 0x9EF3,
	23419: 0x9EF4,
	23420: 0x9EF5,
	23421: 0x9EF6,
	23422: 0x9EF7,
	23423: 0x9EF8,
	23424: 0x9EFA,
	23425: 0x9EFD,
	23426: 0x9EFF,
	23427: 0x9F00,
	23428: 0x9F01,
	23429: 0x9F02,
	23430: 0x9F03,
	23431: 0x9F04,
	23432: 0x9F05,
	23433: 0x9F06,
	23434: 0x9F07,
	23435: 0x9F08,
	23436: 0x9F09,
	23437: 0x9F0A,
	23438: 0x9F0C,
	23439: 0x9F0F,
	23440: 0x9F11,
	23441: 0x9F12,
	23442: 0x9F14,
	23443: 0x9F15,
	23444: 0x9F16,
	23445: 0x9F18,
	23446: 0x9F1A,
	23447: 0x9F1B,
	23448: 0x9F1C,
	23449: 0x9F1D,
	23450: 0x9F1E,
	23451: 0x9F1F,
	23452: 0x9F21,
	23453: 0x9F23,
	23454: 0x9F24,
	23455: 0x9F25,
	23456: 0x9F26,
	23457: 0x9F27,
	23458: 0x9F28,
	23459: 0x9F29,
	23460: 0x9F2A,
	23461: 0x9F2B,
	23462: 0x9F2D,
	23463: 0x9F2E,
	23464: 0x9F30,
	23465: 0x9F31,
	23560: 0x9F32,
	23561: 0x9F33,
	23562: 0x9F34,
	23563: 0x9F35,
	23564: 0x9F36,
	23565: 0x9F38,
	23566: 0x9F3A,
	23567: 0x9F3C,
	23568: 0x9F3F,
	23569: 0x9F40,
	23570: 0x9F41,
	23571: 0x9F42,
	23572: 0x9F43,
	23573: 0x9F45,
	23574: 0x9F46,
	23575: 0x9F47,
	23576: 0x9F48,
	23577: 0x9F49,
	23578: 0x9F4A,
	23579: 0x9F4B,
	23580: 0x9F4C,
	23581: 0x9F4D,
	23582: 0x9F4E,
	23583: 0x9F4F,
	23584: 0x9F52,
	23585: 0x9F53,
	23586: 0x9F54,
	23587: 0x9F55,
	23588: 0x9F56,
	23589: 0x9F57,
	23590: 0x9F58,
	23591: 0x9F59,
	23592: 0x9F5A,
	23593: 0x9F5B,
	23594: 0x9F5C,
	23595: 0x9F5D,
	23596: 0x9F5E,
	23597: 0x9F5F,
	23598: 0x9F60,
	23599: 0x9F61,
	23600: 0x9F62,
	23601: 0x9F63,
	23602: 0x9F64,
	23603: 0x9F65,
	23604: 0x9F66,
	23605: 0x9F67,
	23606: 0x9F68,
	23607: 0x9F69,
	23608: 0x9F6A,
	23609: 0x9F6B,
	23610: 0x9F6C,
	23611: 0x9F6D,
	23612: 0x9F6E,
	23613: 0x9F6F,
	23614: 0x9F70,
	23615: 0x9F71,
	23616: 0x9F72,
	23617: 0x9F73,
	23618: 0x9F74,
	23619: 0x9F75,
	23620: 0x9F76,
	23621: 0x9F77,
	23622: 0x9F78,
	23623: 0x9F79,
	23624: 0x9F7A,
	23625: 0x9F7B,
	23626: 0x9F7C,
	23627: 0x9F7D,
	23628: 0x9F7E,
	23629: 0x9F81,
	23630: 0x9F82,
	23631: 0x9F8D,
	23632: 0x9F8E,
	23633: 0x9F8F,
	23634: 0x9F90,
	23635: 0x9F91,
	23636: 0x9F92,
	23637: 0x9F93,
	23638: 0x9F94,
	23639: 0x9F95,
	23640: 0x9F96,
	23641: 0x9F97,
	23642: 0x9F98,
	23643: 0x9F9C,
	23644: 0x9F9D,
	23645: 0x9F9E,
	23646: 0x9FA1,
	23647: 0x9FA2,
	23648: 0x9FA3,
	23649: 0x9FA4,
	23650: 0x9FA5,
	23651: 0xF92C,
	23652: 0xF979,
	23653: 0xF995,
	23654: 0xF9E7,
	23655: 0xF9F1,
	23750: 0xFA0C,
	23751: 0xFA0D,
	23752: 0xFA0E,
	23753: 0xFA0F,
	23754: 0xFA11,
	23755: 0xFA13,
	23756: 0xFA14,
	23757: 0xFA18,
	23758: 0xFA1F,
	23759: 0xFA20,
	23760: 0xFA21,
	23761: 0xFA23,
	23762: 0xFA24,
	23763: 0xFA27,
	23764: 0xFA28,
	23765: 0xFA29,
	23766: 0x2E81,
	23770: 0x2E84,
	23771: 0x3473,
	23772: 0x3447,
	23773: 0x2E88,
	23774: 0x2E8B,
	23776: 0x359E,
	23777: 0x361A,
	23778: 0x360E,
	23779: 0x2E8C,
	23780: 0x2E97,
	23781: 0x396E,
	23782: 0x3918,
	23784: 0x39CF,
	23785: 0x39DF,
	23786: 0x3A73,
	23787: 0x39D0,
	23790: 0x3B4E,
	23791: 0x3C6E,
	23792: 0x3CE0,
	23793: 0x2EA7,
	23796: 0x2EAA,
	23797: 0x4056,
	23798: 0x415F,
	23799: 0x2EAE,
	23800: 0x4337,
	23801: 0x2EB3,
	23802: 0x2EB6,
	23803: 0x2EB7,
	23805: 0x43B1,
	23806: 0x43AC,
	23807: 0x2EBB,
	23808: 0x43DD,
	23809: 0x44D6,
	23810: 0x4661,
	23811: 0x464C,
	23813: 0x4723,
	23814: 0x4729,
	23815: 0x477C,
	23816: 0x478D,
	23817: 0x2ECA,
	23818: 0x4947,
	23819: 0x497A,
	23820: 0x497D,
	23821: 0x4982,
	23822: 0x4983,
	23823: 0x4985,
	23824: 0x4986,
	23825: 0x499F,
	23826: 0x499B,
	23827: 0x49B7,
	23828: 0x49B6,
	23831: 0x4CA3,
	23832: 0x4C9F,
	23833: 0x4CA0,
	23834: 0x4CA1,
	23835: 0x4C77,
	23836: 0x4CA2,
	23837: 0x4D13,
	23838: 0x4D14,
	23839: 0x4D15,
	23840: 0x4D16,
	23841: 0x4D17,
	23842: 0x4D18,
	23843: 0x4D19,
	23844: 0x4DAE,
}

const numEncodeTables = 5

// encodeX are the encoding tables from Unicode to GBK code,
// sorted by decreasing length.
// encode0: 28965 entries for runes in [11905, 40870).
// encode1:  1587 entries for runes in [ 8208,  9795).
// encode2:   942 entries for runes in [  164,  1106).
// encode3:   438 entries for runes in [65072, 65510).
// encode4:   254 entries for runes in [63788, 64042).

const encode0Low, encode0High = 11905, 40870

var encode0 = [...]uint16{
	11905 - 11905: 0xFE50,
	11908 - 11905: 0xFE54,
	11912 - 11905: 0xFE57,
	11915 - 11905: 0xFE58,
	11916 - 11905: 0xFE5D,
	11927 - 11905: 0xFE5E,
	11943 - 11905: 0xFE6B,
	11946 - 11905: 0xFE6E,
	11950 - 11905: 0xFE71,
	11955 - 11905: 0xFE73,
	11958 - 11905: 0xFE74,
	11959 - 11905: 0xFE75,
	11963 - 11905: 0xFE79,
	11978 - 11905: 0xFE84,
	12272 - 11905: 0xA98A,
	12273 - 11905: 0xA98B,
	12274 - 11905: 0xA98C,
	12275 - 11905: 0xA98D,
	12276 - 11905: 0xA98E,
	12277 - 11905: 0xA98F,
	12278 - 11905: 0xA990,
	12279 - 11905: 0xA991,
	12280 - 11905: 0xA992,
	12281 - 11905: 0xA993,
	12282 - 11905: 0xA994,
	12283 - 11905: 0xA995,
	12288 - 11905: 0xA1A1,
	12289 - 11905: 0xA1A2,
	12290 - 11905: 0xA1A3,
	12291 - 11905: 0xA1A8,
	12293 - 11905: 0xA1A9,
	12294 - 11905: 0xA965,
	12295 - 11905: 0xA996,
	12296 - 11905: 0xA1B4,
	12297 - 11905: 0xA1B5,
	12298 - 11905: 0xA1B6,
	12299 - 11905: 0xA1B7,
	12300 - 11905: 0xA1B8,
	12301 - 11905: 0xA1B9,
	12302 - 11905: 0xA1BA,
	12303 - 11905: 0xA1BB,
	12304 - 11905: 0xA1BE,
	12305 - 11905: 0xA1BF,
	12306 - 11905: 0xA893,
	12307 - 11905: 0xA1FE,
	12308 - 11905: 0xA1B2,
	12309 - 11905: 0xA1B3,
	12310 - 11905: 0xA1BC,
	12311 - 11905: 0xA1BD,
	12317 - 11905: 0xA894,
	12318 - 11905: 0xA895,
	12321 - 11905: 0xA940,
	12322 - 11905: 0xA941,
	12323 - 11905: 0xA942,
	12324 - 11905: 0xA943,
	12325 - 11905: 0xA944,
	12326 - 11905: 0xA945,
	12327 - 11905: 0xA946,
	12328 - 11905: 0xA947,
	12329 - 11905: 0xA948,
	12350 - 11905: 0xA989,
	12353 - 11905: 0xA4A1,
	12354 - 11905: 0xA4A2,
	12355 - 11905: 0xA4A3,
	12356 - 11905: 0xA4A4,
	12357 - 11905: 0xA4A5,
	12358 - 11905: 0xA4A6,
	12359 - 11905: 0xA4A7,
	12360 - 11905: 0xA4A8,
	12361 - 11905: 0xA4A9,
	12362 - 11905: 0xA4AA,
	12363 - 11905: 0xA4AB,
	12364 - 11905: 0xA4AC,
	12365 - 11905: 0xA4AD,
	12366 - 11905: 0xA4AE,
	12367 - 11905: 0xA4AF,
	12368 - 11905: 0xA4B0,
	12369 - 11905: 0xA4B1,
	12370 - 11905: 0xA4B2,
	12371 - 11905: 0xA4B3,
	12372 - 11905: 0xA4B4,
	12373 - 11905: 0xA4B5,
	12374 - 11905: 0xA4B6,
	12375 - 11905: 0xA4B7,
	12376 - 11905: 0xA4B8,
	12377 - 11905: 0xA4B9,
	12378 - 11905: 0xA4BA,
	12379 - 11905: 0xA4BB,
	12380 - 11905: 0xA4BC,
	12381 - 11905: 0xA4BD,
	12382 - 11905: 0xA4BE,
	12383 - 11905: 0xA4BF,
	12384 - 11905: 0xA4C0,
	12385 - 11905: 0xA4C1,
	12386 - 11905: 0xA4C2,
	12387 - 11905: 0xA4C3,
	12388 - 11905: 0xA4C4,
	12389 - 11905: 0xA4C5,
	12390 - 11905: 0xA4C6,
	12391 - 11905: 0xA4C7,
	12392 - 11905: 0xA4C8,
	12393 - 11905: 0xA4C9,
	12394 - 11905: 0xA4CA,
	12395 - 11905: 0xA4CB,
	12396 - 11905: 0xA4CC,
	12397 - 11905: 0xA4CD,
	12398 - 11905: 0xA4CE,
	12399 - 11905: 0xA4CF,
	12400 - 11905: 0xA4D0,
	12401 - 11905: 0xA4D1,
	12402 - 11905: 0xA4D2,
	12403 - 11905: 0xA4D3,
	12404 - 11905: 0xA4D4,
	12405 - 11905: 0xA4D5,
	12406 - 11905: 0xA4D6,
	12407 - 11905: 0xA4D7,
	12408 - 11905: 0xA4D8,
	12409 - 11905: 0xA4D9,
	12410 - 11905: 0xA4DA,
	12411 - 11905: 0xA4DB,
	12412 - 11905: 0xA4DC,
	12413 - 11905: 0xA4DD,
	12414 - 11905: 0xA4DE,
	12415 - 11905: 0xA4DF,
	12416 - 11905: 0xA4E0,
	12417 - 11905: 0xA4E1,
	12418 - 11905: 0xA4E2,
	12419 - 11905: 0xA4E3,
	12420 - 11905: 0xA4E4,
	12421 - 11905: 0xA4E5,
	12422 - 11905: 0xA4E6,
	12423 - 11905: 0xA4E7,
	12424 - 11905: 0xA4E8,
	12425 - 11905: 0xA4E9,
	12426 - 11905: 0xA4EA,
	12427 - 11905: 0xA4EB,
	12428 - 11905: 0xA4EC,
	12429 - 11905: 0xA4ED,
	12430 - 11905: 0xA4EE,
	12431 - 11905: 0xA4EF,
	12432 - 11905: 0xA4F0,
	12433 - 11905: 0xA4F1,
	12434 - 11905: 0xA4F2,
	12435 - 11905: 0xA4F3,
	12443 - 11905: 0xA961,
	12444 - 11905: 0xA962,
	12445 - 11905: 0xA966,
	12446 - 11905: 0xA967,
	12449 - 11905: 0xA5A1,
	12450 - 11905: 0xA5A2,
	12451 - 11905: 0xA5A3,
	12452 - 11905: 0xA5A4,
	12453 - 11905: 0xA5A5,
	12454 - 11905: 0xA5A6,
	12455 - 11905: 0xA5A7,
	12456 - 11905: 0xA5A8,
	12457 - 11905: 0xA5A9,
	12458 - 11905: 0xA5AA,
	12459 - 11905: 0xA5AB,
	12460 - 11905: 0xA5AC,
	12461 - 11905: 0xA5AD,
	12462 - 11905: 0xA5AE,
	12463 - 11905: 0xA5AF,
	12464 - 11905: 0xA5B0,
	12465 - 11905: 0xA5B1,
	12466 - 11905: 0xA5B2,
	12467 - 11905: 0xA5B3,
	12468 - 11905: 0xA5B4,
	12469 - 11905: 0xA5B5,
	12470 - 11905: 0xA5B6,
	12471 - 11905: 0xA5B7,
	12472 - 11905: 0xA5B8,
	12473 - 11905: 0xA5B9,
	12474 - 11905: 0xA5BA,
	12475 - 11905: 0xA5BB,
	12476 - 11905: 0xA5BC,
	12477 - 11905: 0xA5BD,
	12478 - 11905: 0xA5BE,
	12479 - 11905: 0xA5BF,
	12480 - 11905: 0xA5C0,
	12481 - 11905: 0xA5C1,
	12482 - 11905: 0xA5C2,
	12483 - 11905: 0xA5C3,
	12484 - 11905: 0xA5C4,
	12485 - 11905: 0xA5C5,
	12486 - 11905: 0xA5C6,
	12487 - 11905: 0xA5C7,
	12488 - 11905: 0xA5C8,
	12489 - 11905: 0xA5C9,
	12490 - 11905: 0xA5CA,
	12491 - 11905: 0xA5CB,
	12492 - 11905: 0xA5CC,
	12493 - 11905: 0xA5CD,
	12494 - 11905: 0xA5CE,
	12495 - 11905: 0xA5CF,
	12496 - 11905: 0xA5D0,
	12497 - 11905: 0xA5D1,
	12498 - 11905: 0xA5D2,
	12499 - 11905: 0xA5D3,
	12500 - 11905: 0xA5D4,
	12501 - 11905: 0xA5D5,
	12502 - 11905: 0xA5D6,
	12503 - 11905: 0xA5D7,
	12504 - 11905: 0xA5D8,
	12505 - 11905: 0xA5D9,
	12506 - 11905: 0xA5DA,
	12507 - 11905: 0xA5DB,
	12508 - 11905: 0xA5DC,
	12509 - 11905: 0xA5DD,
	12510 - 11905: 0xA5DE,
	12511 - 11905: 0xA5DF,
	12512 - 11905: 0xA5E0,
	12513 - 11905: 0xA5E1,
	12514 - 11905: 0xA5E2,
	12515 - 11905: 0xA5E3,
	12516 - 11905: 0xA5E4,
	12517 - 11905: 0xA5E5,
	12518 - 11905: 0xA5E6,
	12519 - 11905: 0xA5E7,
	12520 - 11905: 0xA5E8,
	12521 - 11905: 0xA5E9,
	12522 - 11905: 0xA5EA,
	12523 - 11905: 0xA5EB,
	12524 - 11905: 0xA5EC,
	12525 - 11905: 0xA5ED,
	12526 - 11905: 0xA5EE,
	12527 - 11905: 0xA5EF,
	12528 - 11905: 0xA5F0,
	12529 - 11905: 0xA5F1,
	12530 - 11905: 0xA5F2,
	12531 - 11905: 0xA5F3,
	12532 - 11905: 0xA5F4,
	12533 - 11905: 0xA5F5,
	12534 - 11905: 0xA5F6,
	12540 - 11905: 0xA960,
	12541 - 11905: 0xA963,
	12542 - 11905: 0xA964,
	12549 - 11905: 0xA8C5,
	12550 - 11905: 0xA8C6,
	12551 - 11905: 0xA8C7,
	12552 - 11905: 0xA8C8,
	12553 - 11905: 0xA8C9,
	12554 - 11905: 0xA8CA,
	12555 - 11905: 0xA8CB,
	12556 - 11905: 0xA8CC,
	12557 - 11905: 0xA8CD,
	12558 - 11905: 0xA8CE,
	12559 - 11905: 0xA8CF,
	12560 - 11905: 0xA8D0,
	12561 - 11905: 0xA8D1,
	12562 - 11905: 0xA8D2,
	12563 - 11905: 0xA8D3,
	12564 - 11905: 0xA8D4,
	12565 - 11905: 0xA8D5,
	12566 - 11905: 0xA8D6,
	12567 - 11905: 0xA8D7,
	12568 - 11905: 0xA8D8,
	12569 - 11905: 0xA8D9,
	12570 - 11905: 0xA8DA,
	12571 - 11905: 0xA8DB,
	12572 - 11905: 0xA8DC,
	12573 - 11905: 0xA8DD,
	12574 - 11905: 0xA8DE,
	12575 - 11905: 0xA8DF,
	12576 - 11905: 0xA8E0,
	12577 - 11905: 0xA8E1,
	12578 - 11905: 0xA8E2,
	12579 - 11905: 0xA8E3,
	12580 - 11905: 0xA8E4,
	12581 - 11905: 0xA8E5,
	12582 - 11905: 0xA8E6,
	12583 - 11905: 0xA8E7,
	12584 - 11905: 0xA8E8,
	12585 - 11905: 0xA8E9,
	12832 - 11905: 0xA2E5,
	12833 - 11905: 0xA2E6,
	12834 - 11905: 0xA2E7,
	12835 - 11905: 0xA2E8,
	12836 - 11905: 0xA2E9,
	12837 - 11905: 0xA2EA,
	12838 - 11905: 0xA2EB,
	12839 - 11905: 0xA2EC,
	12840 - 11905: 0xA2ED,
	12841 - 11905: 0xA2EE,
	12849 - 11905: 0xA95A,
	12963 - 11905: 0xA949,
	13198 - 11905: 0xA94A,
	13199 - 11905: 0xA94B,
	13212 - 11905: 0xA94C,
	13213 - 11905: 0xA94D,
	13214 - 11905: 0xA94E,
	13217 - 11905: 0xA94F,
	13252 - 11905: 0xA950,
	13262 - 11905: 0xA951,
	13265 - 11905: 0xA952,
	13266 - 11905: 0xA953,
	13269 - 11905: 0xA954,
	13383 - 11905: 0xFE56,
	13427 - 11905: 0xFE55,
	13726 - 11905: 0xFE5A,
	13838 - 11905: 0xFE5C,
	13850 - 11905: 0xFE5B,
	14616 - 11905: 0xFE60,
	14702 - 11905: 0xFE5F,
	14799 - 11905: 0xFE62,
	14800 - 11905: 0xFE65,
	14815 - 11905: 0xFE63,
	14963 - 11905: 0xFE64,
	15182 - 11905: 0xFE68,
	15470 - 11905: 0xFE69,
	15584 - 11905: 0xFE6A,
	16470 - 11905: 0xFE6F,
	16735 - 11905: 0xFE70,
	17207 - 11905: 0xFE72,
	17324 - 11905: 0xFE78,
	17329 - 11905: 0xFE77,
	17373 - 11905: 0xFE7A,
	17622 - 11905: 0xFE7B,
	17996 - 11905: 0xFE7D,
	18017 - 11905: 0xFE7C,
	18211 - 11905: 0xFE80,
	18217 - 11905: 0xFE81,
	18300 - 11905: 0xFE82,
	18317 - 11905: 0xFE83,
	18759 - 11905: 0xFE85,
	18810 - 11905: 0xFE86,
	18813 - 11905: 0xFE87,
	18818 - 11905: 0xFE88,
	18819 - 11905: 0xFE89,
	18821 - 11905: 0xFE8A,
	18822 - 11905: 0xFE8B,
	18843 - 11905: 0xFE8D,
	18847 - 11905: 0xFE8C,
	18870 - 11905: 0xFE8F,
	18871 - 11905: 0xFE8E,
	19575 - 11905: 0xFE96,
	19615 - 11905: 0xFE93,
	19616 - 11905: 0xFE94,
	19617 - 11905: 0xFE95,
	19618 - 11905: 0xFE97,
	19619 - 11905: 0xFE92,
	19731 - 11905: 0xFE98,
	19732 - 11905: 0xFE99,
	19733 - 11905: 0xFE9A,
	19734 - 11905: 0xFE9B,
	19735 - 11905: 0xFE9C,
	19736 - 11905: 0xFE9D,
	19737 - 11905: 0xFE9E,
	19886 - 11905: 0xFE9F,
	19968 - 11905: 0xD2BB,
	19969 - 11905: 0xB6A1,
	19970 - 11905: 0x8140,
	19971 - 11905: 0xC6DF,
	19972 - 11905: 0x8141,
	19973 - 11905: 0x8142,
	19974 - 11905: 0x8143,
	19975 - 11905: 0xCDF2,
	19976 - 11905: 0xD5C9,
	19977 - 11905: 0xC8FD,
	19978 - 11905: 0xC9CF,
	19979 - 11905: 0xCFC2,
	19980 - 11905: 0xD8A2,
	19981 - 11905: 0xB2BB,
	19982 - 11905: 0xD3EB,
	19983 - 11905: 0x8144,
	19984 - 11905: 0xD8A4,
	19985 - 11905: 0xB3F3,
	19986 - 11905: 0x8145,
	19987 - 11905: 0xD7A8,
	19988 - 11905: 0xC7D2,
	19989 - 11905: 0xD8A7,
	19990 - 11905: 0xCAC0,
	19991 - 11905: 0x8146,
	19992 - 11905: 0xC7F0,
	19993 - 11905: 0xB1FB,
	19994 - 11905: 0xD2B5,
	19995 - 11905: 0xB4D4,
	19996 - 11905: 0xB6AB,
	19997 - 11905: 0xCBBF,
	19998 - 11905: 0xD8A9,
	19999 - 11905: 0x8147,
	20000 - 11905: 0x8148,
	20001 - 11905: 0x8149,
	20002 - 11905: 0xB6AA,
	20003 - 11905: 0x814A,
	20004 - 11905: 0xC1BD,
	20005 - 11905: 0xD1CF,
	20006 - 11905: 0x814B,
	20007 - 11905: 0xC9A5,
	20008 - 11905: 0xD8AD,
	20009 - 11905: 0x814C,
	20010 - 11905: 0xB8F6,
	20011 - 11905: 0xD1BE,
	20012 - 11905: 0xE3DC,
	20013 - 11905: 0xD6D0,
	20014 - 11905: 0x814D,
	20015 - 11905: 0x814E,
	20016 - 11905: 0xB7E1,
	20017 - 11905: 0x814F,
	20018 - 11905: 0xB4AE,
	20019 - 11905: 0x8150,
	20020 - 11905: 0xC1D9,
	20021 - 11905: 0x8151,
	20022 - 11905: 0xD8BC,
	20023 - 11905: 0x8152,
	20024 - 11905: 0xCDE8,
	20025 - 11905: 0xB5A4,
	20026 - 11905: 0xCEAA,
	20027 - 11905: 0xD6F7,
	20028 - 11905: 0x8153,
	20029 - 11905: 0xC0F6,
	20030 - 11905: 0xBED9,
	20031 - 11905: 0xD8AF,
	20032 - 11905: 0x8154,
	20033 - 11905: 0x8155,
	20034 - 11905: 0x8156,
	20035 - 11905: 0xC4CB,
	20036 - 11905: 0x8157,
	20037 - 11905: 0xBEC3,
	20038 - 11905: 0x8158,
	20039 - 11905: 0xD8B1,
	20040 - 11905: 0xC3B4,
	20041 - 11905: 0xD2E5,
	20042 - 11905: 0x8159,
	20043 - 11905: 0xD6AE,
	20044 - 11905: 0xCEDA,
	20045 - 11905: 0xD5A7,
	20046 - 11905: 0xBAF5,
	20047 - 11905: 0xB7A6,
	20048 - 11905: 0xC0D6,
	20049 - 11905: 0x815A,
	20050 - 11905: 0xC6B9,
	20051 - 11905: 0xC5D2,
	20052 - 11905: 0xC7C7,
	20053 - 11905: 0x815B,
	20054 - 11905: 0xB9D4,
	20055 - 11905: 0x815C,
	20056 - 11905: 0xB3CB,
	20057 - 11905: 0xD2D2,
	20058 - 11905: 0x815D,
	20059 - 11905: 0x815E,
	20060 - 11905: 0xD8BF,
	20061 - 11905: 0xBEC5,
	20062 - 11905: 0xC6F2,
	20063 - 11905: 0xD2B2,
	20064 - 11905: 0xCFB0,
	20065 - 11905: 0xCFE7,
	20066 - 11905: 0x815F,
	20067 - 11905: 0x8160,
	20068 - 11905: 0x8161,
	20069 - 11905: 0x8162,
	20070 - 11905: 0xCAE9,
	20071 - 11905: 0x8163,
	20072 - 11905: 0x8164,
	20073 - 11905: 0xD8C0,
	20074 - 11905: 0x8165,
	20075 - 11905: 0x8166,
	20076 - 11905: 0x8167,
	20077 - 11905: 0x8168,
	20078 - 11905: 0x8169,
	20079 - 11905: 0x816A,
	20080 - 11905: 0xC2F2,
	20081 - 11905: 0xC2D2,
	20082 - 11905: 0x816B,
	20083 - 11905: 0xC8E9,
	20084 - 11905: 0x816C,
	20085 - 11905: 0x816D,
	20086 - 11905: 0x816E,
	20087 - 11905: 0x816F,
	20088 - 11905: 0x8170,
	20089 - 11905: 0x8171,
	20090 - 11905: 0x8172,
	20091 - 11905: 0x8173,
	20092 - 11905: 0x8174,
	20093 - 11905: 0x8175,
	20094 - 11905: 0xC7AC,
	20095 - 11905: 0x8176,
	20096 - 11905: 0x8177,
	20097 - 11905: 0x8178,
	20098 - 11905: 0x8179,
	20099 - 11905: 0x817A,
	20100 - 11905: 0x817B,
	20101 - 11905: 0x817C,
	20102 - 11905: 0xC1CB,
	20103 - 11905: 0x817D,
	20104 - 11905: 0xD3E8,
	20105 - 11905: 0xD5F9,
	20106 - 11905: 0x817E,
	20107 - 11905: 0xCAC2,
	20108 - 11905: 0xB6FE,
	20109 - 11905: 0xD8A1,
	20110 - 11905: 0xD3DA,
	20111 - 11905: 0xBFF7,
	20112 - 11905: 0x8180,
	20113 - 11905: 0xD4C6,
	20114 - 11905: 0xBBA5,
	20115 - 11905: 0xD8C1,
	20116 - 11905: 0xCEE5,
	20117 - 11905: 0xBEAE,
	20118 - 11905: 0x8181,
	20119 - 11905: 0x8182,
	20120 - 11905: 0xD8A8,
	20121 - 11905: 0x8183,
	20122 - 11905: 0xD1C7,
	20123 - 11905: 0xD0A9,
	20124 - 11905: 0x8184,
	20125 - 11905: 0x8185,
	20126 - 11905: 0x8186,
	20127 - 11905: 0xD8BD,
	20128 - 11905: 0xD9EF,
	20129 - 11905: 0xCDF6,
	20130 - 11905: 0xBFBA,
	20131 - 11905: 0x8187,
	20132 - 11905: 0xBDBB,
	20133 - 11905: 0xBAA5,
	20134 - 11905: 0xD2E0,
	20135 - 11905: 0xB2FA,
	20136 - 11905: 0xBAE0,
	20137 - 11905: 0xC4B6,
	20138 - 11905: 0x8188,
	20139 - 11905: 0xCFED,
	20140 - 11905: 0xBEA9,
	20141 - 11905: 0xCDA4,
	20142 - 11905: 0xC1C1,
	20143 - 11905: 0x8189,
	20144 - 11905: 0x818A,
	20145 - 11905: 0x818B,
	20146 - 11905: 0xC7D7,
	20147 - 11905: 0xD9F1,
	20148 - 11905: 0x818C,
	20149 - 11905: 0xD9F4,
	20150 - 11905: 0x818D,
	20151 - 11905: 0x818E,
	20152 - 11905: 0x818F,
	20153 - 11905: 0x8190,
	20154 - 11905: 0xC8CB,
	20155 - 11905: 0xD8E9,
	20156 - 11905: 0x8191,
	20157 - 11905: 0x8192,
	20158 - 11905: 0x8193,
	20159 - 11905: 0xD2DA,
	20160 - 11905: 0xCAB2,
	20161 - 11905: 0xC8CA,
	20162 - 11905: 0xD8EC,
	20163 - 11905: 0xD8EA,
	20164 - 11905: 0xD8C6,
	20165 - 11905: 0xBDF6,
	20166 - 11905: 0xC6CD,
	20167 - 11905: 0xB3F0,
	20168 - 11905: 0x8194,
	20169 - 11905: 0xD8EB,
	20170 - 11905: 0xBDF1,
	20171 - 11905: 0xBDE9,
	20172 - 11905: 0x8195,
	20173 - 11905: 0xC8D4,
	20174 - 11905: 0xB4D3,
	20175 - 11905: 0x8196,
	20176 - 11905: 0x8197,
	20177 - 11905: 0xC2D8,
	20178 - 11905: 0x8198,
	20179 - 11905: 0xB2D6,
	20180 - 11905: 0xD7D0,
	20181 - 11905: 0xCACB,
	20182 - 11905: 0xCBFB,
	20183 - 11905: 0xD5CC,
	20184 - 11905: 0xB8B6,
	20185 - 11905: 0xCFC9,
	20186 - 11905: 0x8199,
	20187 - 11905: 0x819A,
	20188 - 11905: 0x819B,
	20189 - 11905: 0xD9DA,
	20190 - 11905: 0xD8F0,
	20191 - 11905: 0xC7AA,
	20192 - 11905: 0x819C,
	20193 - 11905: 0xD8EE,
	20194 - 11905: 0x819D,
	20195 - 11905: 0xB4FA,
	20196 - 11905: 0xC1EE,
	20197 - 11905: 0xD2D4,
	20198 - 11905: 0x819E,
	20199 - 11905: 0x819F,
	20200 - 11905: 0xD8ED,
	20201 - 11905: 0x81A0,
	20202 - 11905: 0xD2C7,
	20203 - 11905: 0xD8EF,
	20204 - 11905: 0xC3C7,
	20205 - 11905: 0x81A1,
	20206 - 11905: 0x81A2,
	20207 - 11905: 0x81A3,
	20208 - 11905: 0xD1F6,
	20209 - 11905: 0x81A4,
	20210 - 11905: 0xD6D9,
	20211 - 11905: 0xD8F2,
	20212 - 11905: 0x81A5,
	20213 - 11905: 0xD8F5,
	20214 - 11905: 0xBCFE,
	20215 - 11905: 0xBCDB,
	20216 - 11905: 0x81A6,
	20217 - 11905: 0x81A7,
	20218 - 11905: 0x81A8,
	20219 - 11905: 0xC8CE,
	20220 - 11905: 0x81A9,
	20221 - 11905: 0xB7DD,
	20222 - 11905: 0x81AA,
	20223 - 11905: 0xB7C2,
	20224 - 11905: 0x81AB,
	20225 - 11905: 0xC6F3,
	20226 - 11905: 0x81AC,
	20227 - 11905: 0x81AD,
	20228 - 11905: 0x81AE,
	20229 - 11905: 0x81AF,
	20230 - 11905: 0x81B0,
	20231 - 11905: 0x81B1,
	20232 - 11905: 0x81B2,
	20233 - 11905: 0xD8F8,
	20234 - 11905: 0xD2C1,
	20235 - 11905: 0x81B3,
	20236 - 11905: 0x81B4,
	20237 - 11905: 0xCEE9,
	20238 - 11905: 0xBCBF,
	20239 - 11905: 0xB7FC,
	20240 - 11905: 0xB7A5,
	20241 - 11905: 0xD0DD,
	20242 - 11905: 0x81B5,
	20243 - 11905: 0x81B6,
	20244 - 11905: 0x81B7,
	20245 - 11905: 0x81B8,
	20246 - 11905: 0x81B9,
	20247 - 11905: 0xD6DA,
	20248 - 11905: 0xD3C5,
	20249 - 11905: 0xBBEF,
	20250 - 11905: 0xBBE1,
	20251 - 11905: 0xD8F1,
	20252 - 11905: 0x81BA,
	20253 - 11905: 0x81BB,
	20254 - 11905: 0xC9A1,
	20255 - 11905: 0xCEB0,
	20256 - 11905: 0xB4AB,
	20257 - 11905: 0x81BC,
	20258 - 11905: 0xD8F3,
	20259 - 11905: 0x81BD,
	20260 - 11905: 0xC9CB,
	20261 - 11905: 0xD8F6,
	20262 - 11905: 0xC2D7,
	20263 - 11905: 0xD8F7,
	20264 - 11905: 0x81BE,
	20265 - 11905: 0x81BF,
	20266 - 11905: 0xCEB1,
	20267 - 11905: 0xD8F9,
	20268 - 11905: 0x81C0,
	20269 - 11905: 0x81C1,
	20270 - 11905: 0x81C2,
	20271 - 11905: 0xB2AE,
	20272 - 11905: 0xB9C0,
	20273 - 11905: 0x81C3,
	20274 - 11905: 0xD9A3,
	20275 - 11905: 0x81C4,
	20276 - 11905: 0xB0E9,
	20277 - 11905: 0x81C5,
	20278 - 11905: 0xC1E6,
	20279 - 11905: 0x81C6,
	20280 - 11905: 0xC9EC,
	20281 - 11905: 0x81C7,
	20282 - 11905: 0xCBC5,
	20283 - 11905: 0x81C8,
	20284 - 11905: 0xCBC6,
	20285 - 11905: 0xD9A4,
	20286 - 11905: 0x81C9,
	20287 - 11905: 0x81CA,
	20288 - 11905: 0x81CB,
	20289 - 11905: 0x81CC,
	20290 - 11905: 0x81CD,
	20291 - 11905: 0xB5E8,
	20292 - 11905: 0x81CE,
	20293 - 11905: 0x81CF,
	20294 - 11905: 0xB5AB,
	20295 - 11905: 0x81D0,
	20296 - 11905: 0x81D1,
	20297 - 11905: 0x81D2,
	20298 - 11905: 0x81D3,
	20299 - 11905: 0x81D4,
	20300 - 11905: 0x81D5,
	20301 - 11905: 0xCEBB,
	20302 - 11905: 0xB5CD,
	20303 - 11905: 0xD7A1,
	20304 - 11905: 0xD7F4,
	20305 - 11905: 0xD3D3,
	20306 - 11905: 0x81D6,
	20307 - 11905: 0xCCE5,
	20308 - 11905: 0x81D7,
	20309 - 11905: 0xBACE,
	20310 - 11905: 0x81D8,
	20311 - 11905: 0xD9A2,
	20312 - 11905: 0xD9DC,
	20313 - 11905: 0xD3E0,
	20314 - 11905: 0xD8FD,
	20315 - 11905: 0xB7F0,
	20316 - 11905: 0xD7F7,
	20317 - 11905: 0xD8FE,
	20318 - 11905: 0xD8FA,
	20319 - 11905: 0xD9A1,
	20320 - 11905: 0xC4E3,
	20321 - 11905: 0x81D9,
	20322 - 11905: 0x81DA,
	20323 - 11905: 0xD3B6,
	20324 - 11905: 0xD8F4,
	20325 - 11905: 0xD9DD,
	20326 - 11905: 0x81DB,
	20327 - 11905: 0xD8FB,
	20328 - 11905: 0x81DC,
	20329 - 11905: 0xC5E5,
	20330 - 11905: 0x81DD,
	20331 - 11905: 0x81DE,
	20332 - 11905: 0xC0D0,
	20333 - 11905: 0x81DF,
	20334 - 11905: 0x81E0,
	20335 - 11905: 0xD1F0,
	20336 - 11905: 0xB0DB,
	20337 - 11905: 0x81E1,
	20338 - 11905: 0x81E2,
	20339 - 11905: 0xBCD1,
	20340 - 11905: 0xD9A6,
	20341 - 11905: 0x81E3,
	20342 - 11905: 0xD9A5,
	20343 - 11905: 0x81E4,
	20344 - 11905: 0x81E5,
	20345 - 11905: 0x81E6,
	20346 - 11905: 0x81E7,
	20347 - 11905: 0xD9AC,
	20348 - 11905: 0xD9AE,
	20349 - 11905: 0x81E8,
	20350 - 11905: 0xD9AB,
	20351 - 11905: 0xCAB9,
	20352 - 11905: 0x81E9,
	20353 - 11905: 0x81EA,
	20354 - 11905: 0x81EB,
	20355 - 11905: 0xD9A9,
	20356 - 11905: 0xD6B6,
	20357 - 11905: 0x81EC,
	20358 - 11905: 0x81ED,
	20359 - 11905: 0x81EE,
	20360 - 11905: 0xB3DE,
	20361 - 11905: 0xD9A8,
	20362 - 11905: 0x81EF,
	20363 - 11905: 0xC0FD,
	20364 - 11905: 0x81F0,
	20365 - 11905: 0xCACC,
	20366 - 11905: 0x81F1,
	20367 - 11905: 0xD9AA,
	20368 - 11905: 0x81F2,
	20369 - 11905: 0xD9A7,
	20370 - 11905: 0x81F3,
	20371 - 11905: 0x81F4,
	20372 - 11905: 0xD9B0,
	20373 - 11905: 0x81F5,
	20374 - 11905: 0x81F6,
	20375 - 11905: 0xB6B1,
	20376 - 11905: 0x81F7,
	20377 - 11905: 0x81F8,
	20378 - 11905: 0x81F9,
	20379 - 11905: 0xB9A9,
	20380 - 11905: 0x81FA,
	20381 - 11905: 0xD2C0,
	20382 - 11905: 0x81FB,
	20383 - 11905: 0x81FC,
	20384 - 11905: 0xCFC0,
	20385 - 11905: 0x81FD,
	20386 - 11905: 0x81FE,
	20387 - 11905: 0xC2C2,
	20388 - 11905: 0x8240,
	20389 - 11905: 0xBDC4,
	20390 - 11905: 0xD5EC,
	20391 - 11905: 0xB2E0,
	20392 - 11905: 0xC7C8,
	20393 - 11905: 0xBFEB,
	20394 - 11905: 0xD9AD,
	20395 - 11905: 0x8241,
	20396 - 11905: 0xD9AF,
	20397 - 11905: 0x8242,
	20398 - 11905: 0xCEEA,
	20399 - 11905: 0xBAEE,
	20400 - 11905: 0x8243,
	20401 - 11905: 0x8244,
	20402 - 11905: 0x8245,
	20403 - 11905: 0x8246,
	20404 - 11905: 0x8247,
	20405 - 11905: 0xC7D6,
	20406 - 11905: 0x8248,
	20407 - 11905: 0x8249,
	20408 - 11905: 0x824A,
	20409 - 11905: 0x824B,
	20410 - 11905: 0x824C,
	20411 - 11905: 0x824D,
	20412 - 11905: 0x824E,
	20413 - 11905: 0x824F,
	20414 - 11905: 0x8250,
	20415 - 11905: 0xB1E3,
	20416 - 11905: 0x8251,
	20417 - 11905: 0x8252,
	20418 - 11905: 0x8253,
	20419 - 11905: 0xB4D9,
	20420 - 11905: 0xB6ED,
	20421 - 11905: 0xD9B4,
	20422 - 11905: 0x8254,
	20423 - 11905: 0x8255,
	20424 - 11905: 0x8256,
	20425 - 11905: 0x8257,
	20426 - 11905: 0xBFA1,
	20427 - 11905: 0x8258,
	20428 - 11905: 0x8259,
	20429 - 11905: 0x825A,
	20430 - 11905: 0xD9DE,
	20431 - 11905: 0xC7CE,
	20432 - 11905: 0xC0FE,
	20433 - 11905: 0xD9B8,
	20434 - 11905: 0x825B,
	20435 - 11905: 0x825C,
	20436 - 11905: 0x825D,
	20437 - 11905: 0x825E,
	20438 - 11905: 0x825F,
	20439 - 11905: 0xCBD7,
	20440 - 11905: 0xB7FD,
	20441 - 11905: 0x8260,
	20442 - 11905: 0xD9B5,
	20443 - 11905: 0x8261,
	20444 - 11905: 0xD9B7,
	20445 - 11905: 0xB1A3,
	20446 - 11905: 0xD3E1,
	20447 - 11905: 0xD9B9,
	20448 - 11905: 0x8262,
	20449 - 11905: 0xD0C5,
	20450 - 11905: 0x8263,
	20451 - 11905: 0xD9B6,
	20452 - 11905: 0x8264,
	20453 - 11905: 0x8265,
	20454 - 11905: 0xD9B1,
	20455 - 11905: 0x8266,
	20456 - 11905: 0xD9B2,
	20457 - 11905: 0xC1A9,
	20458 - 11905: 0xD9B3,
	20459 - 11905: 0x8267,
	20460 - 11905: 0x8268,
	20461 - 11905: 0xBCF3,
	20462 - 11905: 0xD0DE,
	20463 - 11905: 0xB8A9,
	20464 - 11905: 0x8269,
	20465 - 11905: 0xBEE3,
	20466 - 11905: 0x826A,
	20467 - 11905: 0xD9BD,
	20468 - 11905: 0x826B,
	20469 - 11905: 0x826C,
	20470 - 11905: 0x826D,
	20471 - 11905: 0x826E,
	20472 - 11905: 0xD9BA,
	20473 - 11905: 0x826F,
	20474 - 11905: 0xB0B3,
	20475 - 11905: 0x8270,
	20476 - 11905: 0x8271,
	20477 - 11905: 0x8272,
	20478 - 11905: 0xD9C2,
	20479 - 11905: 0x8273,
	20480 - 11905: 0x8274,
	20481 - 11905: 0x8275,
	20482 - 11905: 0x8276,
	20483 - 11905: 0x8277,
	20484 - 11905: 0x8278,
	20485 - 11905: 0x8279,
	20486 - 11905: 0x827A,
	20487 - 11905: 0x827B,
	20488 - 11905: 0x827C,
	20489 - 11905: 0x827D,
	20490 - 11905: 0x827E,
	20491 - 11905: 0x8280,
	20492 - 11905: 0xD9C4,
	20493 - 11905: 0xB1B6,
	20494 - 11905: 0x8281,
	20495 - 11905: 0xD9BF,
	20496 - 11905: 0x8282,
	20497 - 11905: 0x8283,
	20498 - 11905: 0xB5B9,
	20499 - 11905: 0x8284,
	20500 - 11905: 0xBEF3,
	20501 - 11905: 0x8285,
	20502 - 11905: 0x8286,
	20503 - 11905: 0x8287,
	20504 - 11905: 0xCCC8,
	20505 - 11905: 0xBAF2,
	20506 - 11905: 0xD2D0,
	20507 - 11905: 0x8288,
	20508 - 11905: 0xD9C3,
	20509 - 11905: 0x8289,
	20510 - 11905: 0x828A,
	20511 - 11905: 0xBDE8,
	20512 - 11905: 0x828B,
	20513 - 11905: 0xB3AB,
	20514 - 11905: 0x828C,
	20515 - 11905: 0x828D,
	20516 - 11905: 0x828E,
	20517 - 11905: 0xD9C5,
	20518 - 11905: 0xBEEB,
	20519 - 11905: 0x828F,
	20520 - 11905: 0xD9C6,
	20521 - 11905: 0xD9BB,
	20522 - 11905: 0xC4DF,
	20523 - 11905: 0x8290,
	20524 - 11905: 0xD9BE,
	20525 - 11905: 0xD9C1,
	20526 - 11905: 0xD9C0,
	20527 - 11905: 0x8291,
	20528 - 11905: 0x8292,
	20529 - 11905: 0x8293,
	20530 - 11905: 0x8294,
	20531 - 11905: 0x8295,
	20532 - 11905: 0x8296,
	20533 - 11905: 0x8297,
	20534 - 11905: 0x8298,
	20535 - 11905: 0x8299,
	20536 - 11905: 0x829A,
	20537 - 11905: 0x829B,
	20538 - 11905: 0xD5AE,
	20539 - 11905: 0x829C,
	20540 - 11905: 0xD6B5,
	20541 - 11905: 0x829D,
	20542 - 11905: 0xC7E3,
	20543 - 11905: 0x829E,
	20544 - 11905: 0x829F,
	20545 - 11905: 0x82A0,
	20546 - 11905: 0x82A1,
	20547 - 11905: 0xD9C8,
	20548 - 11905: 0x82A2,
	20549 - 11905: 0x82A3,
	20550 - 11905: 0x82A4,
	20551 - 11905: 0xBCD9,
	20552 - 11905: 0xD9CA,
	20553 - 11905: 0x82A5,
	20554 - 11905: 0x82A6,
	20555 - 11905: 0x82A7,
	20556 - 11905: 0xD9BC,
	20557 - 11905: 0x82A8,
	20558 - 11905: 0xD9CB,
	20559 - 11905: 0xC6AB,
	20560 - 11905: 0x82A9,
	20561 - 11905: 0x82AA,
	20562 - 11905: 0x82AB,
	20563 - 11905: 0x82AC,
	20564 - 11905: 0x82AD,
	20565 - 11905: 0xD9C9,
	20566 - 11905: 0x82AE,
	20567 - 11905: 0x82AF,
	20568 - 11905: 0x82B0,
	20569 - 11905: 0x82B1,
	20570 - 11905: 0xD7F6,
	20571 - 11905: 0x82B2,
	20572 - 11905: 0xCDA3,
	20573 - 11905: 0x82B3,
	20574 - 11905: 0x82B4,
	20575 - 11905: 0x82B5,
	20576 - 11905: 0x82B6,
	20577 - 11905: 0x82B7,
	20578 - 11905: 0x82B8,
	20579 - 11905: 0x82B9,
	20580 - 11905: 0x82BA,
	20581 - 11905: 0xBDA1,
	20582 - 11905: 0x82BB,
	20583 - 11905: 0x82BC,
	20584 - 11905: 0x82BD,
	20585 - 11905: 0x82BE,
	20586 - 11905: 0x82BF,
	20587 - 11905: 0x82C0,
	20588 - 11905: 0xD9CC,
	20589 - 11905: 0x82C1,
	20590 - 11905: 0x82C2,
	20591 - 11905: 0x82C3,
	20592 - 11905: 0x82C4,
	20593 - 11905: 0x82C5,
	20594 - 11905: 0x82C6,
	20595 - 11905: 0x82C7,
	20596 - 11905: 0x82C8,
	20597 - 11905: 0x82C9,
	20598 - 11905: 0xC5BC,
	20599 - 11905: 0xCDB5,
	20600 - 11905: 0x82CA,
	20601 - 11905: 0x82CB,
	20602 - 11905: 0x82CC,
	20603 - 11905: 0xD9CD,
	20604 - 11905: 0x82CD,
	20605 - 11905: 0x82CE,
	20606 - 11905: 0xD9C7,
	20607 - 11905: 0xB3A5,
	20608 - 11905: 0xBFFE,
	20609 - 11905: 0x82CF,
	20610 - 11905: 0x82D0,
	20611 - 11905: 0x82D1,
	20612 - 11905: 0x82D2,
	20613 - 11905: 0xB8B5,
	20614 - 11905: 0x82D3,
	20615 - 11905: 0x82D4,
	20616 - 11905: 0xC0FC,
	20617 - 11905: 0x82D5,
	20618 - 11905: 0x82D6,
	20619 - 11905: 0x82D7,
	20620 - 11905: 0x82D8,
	20621 - 11905: 0xB0F8,
	20622 - 11905: 0x82D9,
	20623 - 11905: 0x82DA,
	20624 - 11905: 0x82DB,
	20625 - 11905: 0x82DC,
	20626 - 11905: 0x82DD,
	20627 - 11905: 0x82DE,
	20628 - 11905: 0x82DF,
	20629 - 11905: 0x82E0,
	20630 - 11905: 0x82E1,
	20631 - 11905: 0x82E2,
	20632 - 11905: 0x82E3,
	20633 - 11905: 0x82E4,
	20634 - 11905: 0x82E5,
	20635 - 11905: 0x82E6,
	20636 - 11905: 0x82E7,
	20637 - 11905: 0x82E8,
	20638 - 11905: 0x82E9,
	20639 - 11905: 0x82EA,
	20640 - 11905: 0x82EB,
	20641 - 11905: 0x82EC,
	20642 - 11905: 0x82ED,
	20643 - 11905: 0xB4F6,
	20644 - 11905: 0x82EE,
	20645 - 11905: 0xD9CE,
	20646 - 11905: 0x82EF,
	20647 - 11905: 0xD9CF,
	20648 - 11905: 0xB4A2,
	20649 - 11905: 0xD9D0,
	20650 - 11905: 0x82F0,
	20651 - 11905: 0x82F1,
	20652 - 11905: 0xB4DF,
	20653 - 11905: 0x82F2,
	20654 - 11905: 0x82F3,
	20655 - 11905: 0x82F4,
	20656 - 11905: 0x82F5,
	20657 - 11905: 0x82F6,
	20658 - 11905: 0xB0C1,
	20659 - 11905: 0x82F7,
	20660 - 11905: 0x82F8,
	20661 - 11905: 0x82F9,
	20662 - 11905: 0x82FA,
	20663 - 11905: 0x82FB,
	20664 - 11905: 0x82FC,
	20665 - 11905: 0x82FD,
	20666 - 11905: 0xD9D1,
	20667 - 11905: 0xC9B5,
	20668 - 11905: 0x82FE,
	20669 - 11905: 0x8340,
	20670 - 11905: 0x8341,
	20671 - 11905: 0x8342,
	20672 - 11905: 0x8343,
	20673 - 11905: 0x8344,
	20674 - 11905: 0x8345,
	20675 - 11905: 0x8346,
	20676 - 11905: 0x8347,
	20677 - 11905: 0x8348,
	20678 - 11905: 0x8349,
	20679 - 11905: 0x834A,
	20680 - 11905: 0x834B,
	20681 - 11905: 0x834C,
	20682 - 11905: 0x834D,
	20683 - 11905: 0x834E,
	20684 - 11905: 0x834F,
	20685 - 11905: 0x8350,
	20686 - 11905: 0x8351,
	20687 - 11905: 0xCFF1,
	20688 - 11905: 0x8352,
	20689 - 11905: 0x8353,
	20690 - 11905: 0x8354,
	20691 - 11905: 0x8355,
	20692 - 11905: 0x8356,
	20693 - 11905: 0x8357,
	20694 - 11905: 0xD9D2,
	20695 - 11905: 0x8358,
	20696 - 11905: 0x8359,
	20697 - 11905: 0x835A,
	20698 - 11905: 0xC1C5,
	20699 - 11905: 0x835B,
	20700 - 11905: 0x835C,
	20701 - 11905: 0x835D,
	20702 - 11905: 0x835E,
	20703 - 11905: 0x835F,
	20704 - 11905: 0x8360,
	20705 - 11905: 0x8361,
	20706 - 11905: 0x8362,
	20707 - 11905: 0x8363,
	20708 - 11905: 0x8364,
	20709 - 11905: 0x8365,
	20710 - 11905: 0xD9D6,
	20711 - 11905: 0xC9AE,
	20712 - 11905: 0x8366,
	20713 - 11905: 0x8367,
	20714 - 11905: 0x8368,
	20715 - 11905: 0x8369,
	20716 - 11905: 0xD9D5,
	20717 - 11905: 0xD9D4,
	20718 - 11905: 0xD9D7,
	20719 - 11905: 0x836A,
	20720 - 11905: 0x836B,
	20721 - 11905: 0x836C,
	20722 - 11905: 0x836D,
	20723 - 11905: 0xCBDB,
	20724 - 11905: 0x836E,
	20725 - 11905: 0xBDA9,
	20726 - 11905: 0x836F,
	20727 - 11905: 0x8370,
	20728 - 11905: 0x8371,
	20729 - 11905: 0x8372,
	20730 - 11905: 0x8373,
	20731 - 11905: 0xC6A7,
	20732 - 11905: 0x8374,
	20733 - 11905: 0x8375,
	20734 - 11905: 0x8376,
	20735 - 11905: 0x8377,
	20736 - 11905: 0x8378,
	20737 - 11905: 0x8379,
	20738 - 11905: 0x837A,
	20739 - 11905: 0x837B,
	20740 - 11905: 0x837C,
	20741 - 11905: 0x837D,
	20742 - 11905: 0xD9D3,
	20743 - 11905: 0xD9D8,
	20744 - 11905: 0x837E,
	20745 - 11905: 0x8380,
	20746 - 11905: 0x8381,
	20747 - 11905: 0xD9D9,
	20748 - 11905: 0x8382,
	20749 - 11905: 0x8383,
	20750 - 11905: 0x8384,
	20751 - 11905: 0x8385,
	20752 - 11905: 0x8386,
	20753 - 11905: 0x8387,
	20754 - 11905: 0xC8E5,
	20755 - 11905: 0x8388,
	20756 - 11905: 0x8389,
	20757 - 11905: 0x838A,
	20758 - 11905: 0x838B,
	20759 - 11905: 0x838C,
	20760 - 11905: 0x838D,
	20761 - 11905: 0x838E,
	20762 - 11905: 0x838F,
	20763 - 11905: 0x8390,
	20764 - 11905: 0x8391,
	20765 - 11905: 0x8392,
	20766 - 11905: 0x8393,
	20767 - 11905: 0x8394,
	20768 - 11905: 0x8395,
	20769 - 11905: 0xC0DC,
	20770 - 11905: 0x8396,
	20771 - 11905: 0x8397,
	20772 - 11905: 0x8398,
	20773 - 11905: 0x8399,
	20774 - 11905: 0x839A,
	20775 - 11905: 0x839B,
	20776 - 11905: 0x839C,
	20777 - 11905: 0x839D,
	20778 - 11905: 0x839E,
	20779 - 11905: 0x839F,
	20780 - 11905: 0x83A0,
	20781 - 11905: 0x83A1,
	20782 - 11905: 0x83A2,
	20783 - 11905: 0x83A3,
	20784 - 11905: 0x83A4,
	20785 - 11905: 0x83A5,
	20786 - 11905: 0x83A6,
	20787 - 11905: 0x83A7,
	20788 - 11905: 0x83A8,
	20789 - 11905: 0x83A9,
	20790 - 11905: 0x83AA,
	20791 - 11905: 0x83AB,
	20792 - 11905: 0x83AC,
	20793 - 11905: 0x83AD,
	20794 - 11905: 0x83AE,
	20795 - 11905: 0x83AF,
	20796 - 11905: 0x83B0,
	20797 - 11905: 0x83B1,
	20798 - 11905: 0x83B2,
	20799 - 11905: 0xB6F9,
	20800 - 11905: 0xD8A3,
	20801 - 11905: 0xD4CA,
	20802 - 11905: 0x83B3,
	20803 - 11905: 0xD4AA,
	20804 - 11905: 0xD0D6,
	20805 - 11905: 0xB3E4,
	20806 - 11905: 0xD5D7,
	20807 - 11905: 0x83B4,
	20808 - 11905: 0xCFC8,
	20809 - 11905: 0xB9E2,
	20810 - 11905: 0x83B5,
	20811 - 11905: 0xBFCB,
	20812 - 11905: 0x83B6,
	20813 - 11905: 0xC3E2,
	20814 - 11905: 0x83B7,
	20815 - 11905: 0x83B8,
	20816 - 11905: 0x83B9,
	20817 - 11905: 0xB6D2,
	20818 - 11905: 0x83BA,
	20819 - 11905: 0x83BB,
	20820 - 11905: 0xCDC3,
	20821 - 11905: 0xD9EE,
	20822 - 11905: 0xD9F0,
	20823 - 11905: 0x83BC,
	20824 - 11905: 0x83BD,
	20825 - 11905: 0x83BE,
	20826 - 11905: 0xB5B3,
	20827 - 11905: 0x83BF,
	20828 - 11905: 0xB6B5,
	20829 - 11905: 0x83C0,
	20830 - 11905: 0x83C1,
	20831 - 11905: 0x83C2,
	20832 - 11905: 0x83C3,
	20833 - 11905: 0x83C4,
	20834 - 11905: 0xBEA4,
	20835 - 11905: 0x83C5,
	20836 - 11905: 0x83C6,
	20837 - 11905: 0xC8EB,
	20838 - 11905: 0x83C7,
	20839 - 11905: 0x83C8,
	20840 - 11905: 0xC8AB,
	20841 - 11905: 0x83C9,
	20842 - 11905: 0x83CA,
	20843 - 11905: 0xB0CB,
	20844 - 11905: 0xB9AB,
	20845 - 11905: 0xC1F9,
	20846 - 11905: 0xD9E2,
	20847 - 11905: 0x83CB,
	20848 - 11905: 0xC0BC,
	20849 - 11905: 0xB9B2,
	20850 - 11905: 0x83CC,
	20851 - 11905: 0xB9D8,
	20852 - 11905: 0xD0CB,
	20853 - 11905: 0xB1F8,
	20854 - 11905: 0xC6E4,
	20855 - 11905: 0xBEDF,
	20856 - 11905: 0xB5E4,
	20857 - 11905: 0xD7C8,
	20858 - 11905: 0x83CD,
	20859 - 11905: 0xD1F8,
	20860 - 11905: 0xBCE6,
	20861 - 11905: 0xCADE,
	20862 - 11905: 0x83CE,
	20863 - 11905: 0x83CF,
	20864 - 11905: 0xBCBD,
	20865 - 11905: 0xD9E6,
	20866 - 11905: 0xD8E7,
	20867 - 11905: 0x83D0,
	20868 - 11905: 0x83D1,
	20869 - 11905: 0xC4DA,
	20870 - 11905: 0x83D2,
	20871 - 11905: 0x83D3,
	20872 - 11905: 0xB8D4,
	20873 - 11905: 0xC8BD,
	20874 - 11905: 0x83D4,
	20875 - 11905: 0x83D5,
	20876 - 11905: 0xB2E1,
	20877 - 11905: 0xD4D9,
	20878 - 11905: 0x83D6,
	20879 - 11905: 0x83D7,
	20880 - 11905: 0x83D8,
	20881 - 11905: 0x83D9,
	20882 - 11905: 0xC3B0,
	20883 - 11905: 0x83DA,
	20884 - 11905: 0x83DB,
	20885 - 11905: 0xC3E1,
	20886 - 11905: 0xDAA2,
	20887 - 11905: 0xC8DF,
	20888 - 11905: 0x83DC,
	20889 - 11905: 0xD0B4,
	20890 - 11905: 0x83DD,
	20891 - 11905: 0xBEFC,
	20892 - 11905: 0xC5A9,
	20893 - 11905: 0x83DE,
	20894 - 11905: 0x83DF,
	20895 - 11905: 0x83E0,
	20896 - 11905: 0xB9DA,
	20897 - 11905: 0x83E1,
	20898 - 11905: 0xDAA3,
	20899 - 11905: 0x83E2,
	20900 - 11905: 0xD4A9,
	20901 - 11905: 0xDAA4,
	20902 - 11905: 0x83E3,
	20903 - 11905: 0x83E4,
	20904 - 11905: 0x83E5,
	20905 - 11905: 0x83E6,
	20906 - 11905: 0x83E7,
	20907 - 11905: 0xD9FB,
	20908 - 11905: 0xB6AC,
	20909 - 11905: 0x83E8,
	20910 - 11905: 0x83E9,
	20911 - 11905: 0xB7EB,
	20912 - 11905: 0xB1F9,
	20913 - 11905: 0xD9FC,
	20914 - 11905: 0xB3E5,
	20915 - 11905: 0xBEF6,
	20916 - 11905: 0x83EA,
	20917 - 11905: 0xBFF6,
	20918 - 11905: 0xD2B1,
	20919 - 11905: 0xC0E4,
	20920 - 11905: 0x83EB,
	20921 - 11905: 0x83EC,
	20922 - 11905: 0x83ED,
	20923 - 11905: 0xB6B3,
	20924 - 11905: 0xD9FE,
	20925 - 11905: 0xD9FD,
	20926 - 11905: 0x83EE,
	20927 - 11905: 0x83EF,
	20928 - 11905: 0xBEBB,
	20929 - 11905: 0x83F0,
	20930 - 11905: 0x83F1,
	20931 - 11905: 0x83F2,
	20932 - 11905: 0xC6E0,
	20933 - 11905: 0x83F3,
	20934 - 11905: 0xD7BC,
	20935 - 11905: 0xDAA1,
	20936 - 11905: 0x83F4,
	20937 - 11905: 0xC1B9,
	20938 - 11905: 0x83F5,
	20939 - 11905: 0xB5F2,
	20940 - 11905: 0xC1E8,
	20941 - 11905: 0x83F6,
	20942 - 11905: 0x83F7,
	20943 - 11905: 0xBCF5,
	20944 - 11905: 0x83F8,
	20945 - 11905: 0xB4D5,
	20946 - 11905: 0x83F9,
	20947 - 11905: 0x83FA,
	20948 - 11905: 0x83FB,
	20949 - 11905: 0x83FC,
	20950 - 11905: 0x83FD,
	20951 - 11905: 0x83FE,
	20952 - 11905: 0x8440,
	20953 - 11905: 0x8441,
	20954 - 11905: 0x8442,
	20955 - 11905: 0xC1DD,
	20956 - 11905: 0x8443,
	20957 - 11905: 0xC4FD,
	20958 - 11905: 0x8444,
	20959 - 11905: 0x8445,
	20960 - 11905: 0xBCB8,
	20961 - 11905: 0xB7B2,
	20962 - 11905: 0x8446,
	20963 - 11905: 0x8447,
	20964 - 11905: 0xB7EF,
	20965 - 11905: 0x8448,
	20966 - 11905: 0x8449,
	20967 - 11905: 0x844A,
	20968 - 11905: 0x844B,
	20969 - 11905: 0x844C,
	20970 - 11905: 0x844D,
	20971 - 11905: 0xD9EC,
	20972 - 11905: 0x844E,
	20973 - 11905: 0xC6BE,
	20974 - 11905: 0x844F,
	20975 - 11905: 0xBFAD,
	20976 - 11905: 0xBBCB,
	20977 - 11905: 0x8450,
	20978 - 11905: 0x8451,
	20979 - 11905: 0xB5CA,
	20980 - 11905: 0x8452,
	20981 - 11905: 0xDBC9,
	20982 - 11905: 0xD0D7,
	20983 - 11905: 0x8453,
	20984 - 11905: 0xCDB9,
	20985 - 11905: 0xB0BC,
	20986 - 11905: 0xB3F6,
	20987 - 11905: 0xBBF7,
	20988 - 11905: 0xDBCA,
	20989 - 11905: 0xBAAF,
	20990 - 11905: 0x8454,
	20991 - 11905: 0xD4E4,
	20992 - 11905: 0xB5B6,
	20993 - 11905: 0xB5F3,
	20994 - 11905: 0xD8D6,
	20995 - 11905: 0xC8D0,
	20996 - 11905: 0x8455,
	20997 - 11905: 0x8456,
	20998 - 11905: 0xB7D6,
	20999 - 11905: 0xC7D0,
	21000 - 11905: 0xD8D7,
	21001 - 11905: 0x8457,
	21002 - 11905: 0xBFAF,
	21003 - 11905: 0x8458,
	21004 - 11905: 0x8459,
	21005 - 11905: 0xDBBB,
	21006 - 11905: 0xD8D8,
	21007 - 11905: 0x845A,
	21008 - 11905: 0x845B,
	21009 - 11905: 0xD0CC,
	21010 - 11905: 0xBBAE,
	21011 - 11905: 0x845C,
	21012 - 11905: 0x845D,
	21013 - 11905: 0x845E,
	21014 - 11905: 0xEBBE,
	21015 - 11905: 0xC1D0,
	21016 - 11905: 0xC1F5,
	21017 - 11905: 0xD4F2,
	21018 - 11905: 0xB8D5,
	21019 - 11905: 0xB4B4,
	21020 - 11905: 0x845F,
	21021 - 11905: 0xB3F5,
	21022 - 11905: 0x8460,
	21023 - 11905: 0x8461,
	21024 - 11905: 0xC9BE,
	21025 - 11905: 0x8462,
	21026 - 11905: 0x8463,
	21027 - 11905: 0x8464,
	21028 - 11905: 0xC5D0,
	21029 - 11905: 0x8465,
	21030 - 11905: 0x8466,
	21031 - 11905: 0x8467,
	21032 - 11905: 0xC5D9,
	21033 - 11905: 0xC0FB,
	21034 - 11905: 0x8468,
	21035 - 11905: 0xB1F0,
	21036 - 11905: 0x8469,
	21037 - 11905: 0xD8D9,
	21038 - 11905: 0xB9CE,
	21039 - 11905: 0x846A,
	21040 - 11905: 0xB5BD,
	21041 - 11905: 0x846B,
	21042 - 11905: 0x846C,
	21043 - 11905: 0xD8DA,
	21044 - 11905: 0x846D,
	21045 - 11905: 0x846E,
	21046 - 11905: 0xD6C6,
	21047 - 11905: 0xCBA2,
	21048 - 11905: 0xC8AF,
	21049 - 11905: 0xC9B2,
	21050 - 11905: 0xB4CC,
	21051 - 11905: 0xBFCC,
	21052 - 11905: 0x846F,
	21053 - 11905: 0xB9F4,
	21054 - 11905: 0x8470,
	21055 - 11905: 0xD8DB,
	21056 - 11905: 0xD8DC,
	21057 - 11905: 0xB6E7,
	21058 - 11905: 0xBCC1,
	21059 - 11905: 0xCCEA,
	21060 - 11905: 0x8471,
	21061 - 11905: 0x8472,
	21062 - 11905: 0x8473,
	21063 - 11905: 0x8474,
	21064 - 11905: 0x8475,
	21065 - 11905: 0x8476,
	21066 - 11905: 0xCFF7,
	21067 - 11905: 0x8477,
	21068 - 11905: 0xD8DD,
	21069 - 11905: 0xC7B0,
	21070 - 11905: 0x8478,
	21071 - 11905: 0x8479,
	21072 - 11905: 0xB9D0,
	21073 - 11905: 0xBDA3,
	21074 - 11905: 0x847A,
	21075 - 11905: 0x847B,
	21076 - 11905: 0xCCDE,
	21077 - 11905: 0x847C,
	21078 - 11905: 0xC6CA,
	21079 - 11905: 0x847D,
	21080 - 11905: 0x847E,
	21081 - 11905: 0x8480,
	21082 - 11905: 0x8481,
	21083 - 11905: 0x8482,
	21084 - 11905: 0xD8E0,
	21085 - 11905: 0x8483,
	21086 - 11905: 0xD8DE,
	21087 - 11905: 0x8484,
	21088 - 11905: 0x8485,
	21089 - 11905: 0xD8DF,
	21090 - 11905: 0x8486,
	21091 - 11905: 0x8487,
	21092 - 11905: 0x8488,
	21093 - 11905: 0xB0FE,
	21094 - 11905: 0x8489,
	21095 - 11905: 0xBEE7,
	21096 - 11905: 0x848A,
	21097 - 11905: 0xCAA3,
	21098 - 11905: 0xBCF4,
	21099 - 11905: 0x848B,
	21100 - 11905: 0x848C,
	21101 - 11905: 0x848D,
	21102 - 11905: 0x848E,
	21103 - 11905: 0xB8B1,
	21104 - 11905: 0x848F,
	21105 - 11905: 0x8490,
	21106 - 11905: 0xB8EE,
	21107 - 11905: 0x8491,
	21108 - 11905: 0x8492,
	21109 - 11905: 0x8493,
	21110 - 11905: 0x8494,
	21111 - 11905: 0x8495,
	21112 - 11905: 0x8496,
	21113 - 11905: 0x8497,
	21114 - 11905: 0x8498,
	21115 - 11905: 0x8499,
	21116 - 11905: 0x849A,
	21117 - 11905: 0xD8E2,
	21118 - 11905: 0x849B,
	21119 - 11905: 0xBDCB,
	21120 - 11905: 0x849C,
	21121 - 11905: 0xD8E4,
	21122 - 11905: 0xD8E3,
	21123 - 11905: 0x849D,
	21124 - 11905: 0x849E,
	21125 - 11905: 0x849F,
	21126 - 11905: 0x84A0,
	21127 - 11905: 0x84A1,
	21128 - 11905: 0xC5FC,
	21129 - 11905: 0x84A2,
	21130 - 11905: 0x84A3,
	21131 - 11905: 0x84A4,
	21132 - 11905: 0x84A5,
	21133 - 11905: 0x84A6,
	21134 - 11905: 0x84A7,
	21135 - 11905: 0x84A8,
	21136 - 11905: 0xD8E5,
	21137 - 11905: 0x84A9,
	21138 - 11905: 0x84AA,
	21139 - 11905: 0xD8E6,
	21140 - 11905: 0x84AB,
	21141 - 11905: 0x84AC,
	21142 - 11905: 0x84AD,
	21143 - 11905: 0x84AE,
	21144 - 11905: 0x84AF,
	21145 - 11905: 0x84B0,
	21146 - 11905: 0x84B1,
	21147 - 11905: 0xC1A6,
	21148 - 11905: 0x84B2,
	21149 - 11905: 0xC8B0,
	21150 - 11905: 0xB0EC,
	21151 - 11905: 0xB9A6,
	21152 - 11905: 0xBCD3,
	21153 - 11905: 0xCEF1,
	21154 - 11905: 0xDBBD,
	21155 - 11905: 0xC1D3,
	21156 - 11905: 0x84B3,
	21157 - 11905: 0x84B4,
	21158 - 11905: 0x84B5,
	21159 - 11905: 0x84B6,
	21160 - 11905: 0xB6AF,
	21161 - 11905: 0xD6FA,
	21162 - 11905: 0xC5AC,
	21163 - 11905: 0xBDD9,
	21164 - 11905: 0xDBBE,
	21165 - 11905: 0xDBBF,
	21166 - 11905: 0x84B7,
	21167 - 11905: 0x84B8,
	21168 - 11905: 0x84B9,
	21169 - 11905: 0xC0F8,
	21170 - 11905: 0xBEA2,
	21171 - 11905: 0xC0CD,
	21172 - 11905: 0x84BA,
	21173 - 11905: 0x84BB,
	21174 - 11905: 0x84BC,
	21175 - 11905: 0x84BD,
	21176 - 11905: 0x84BE,
	21177 - 11905: 0x84BF,
	21178 - 11905: 0x84C0,
	21179 - 11905: 0x84C1,
	21180 - 11905: 0x84C2,
	21181 - 11905: 0x84C3,
	21182 - 11905: 0xDBC0,
	21183 - 11905: 0xCAC6,
	21184 - 11905: 0x84C4,
	21185 - 11905: 0x84C5,
	21186 - 11905: 0x84C6,
	21187 - 11905: 0xB2AA,
	21188 - 11905: 0x84C7,
	21189 - 11905: 0x84C8,
	21190 - 11905: 0x84C9,
	21191 - 11905: 0xD3C2,
	21192 - 11905: 0x84CA,
	21193 - 11905: 0xC3E3,
	21194 - 11905: 0x84CB,
	21195 - 11905: 0xD1AB,
	21196 - 11905: 0x84CC,
	21197 - 11905: 0x84CD,
	21198 - 11905: 0x84CE,
	21199 - 11905: 0x84CF,
	21200 - 11905: 0xDBC2,
	21201 - 11905: 0x84D0,
	21202 - 11905: 0xC0D5,
	21203 - 11905: 0x84D1,
	21204 - 11905: 0x84D2,
	21205 - 11905: 0x84D3,
	21206 - 11905: 0xDBC3,
	21207 - 11905: 0x84D4,
	21208 - 11905: 0xBFB1,
	21209 - 11905: 0x84D5,
	21210 - 11905: 0x84D6,
	21211 - 11905: 0x84D7,
	21212 - 11905: 0x84D8,
	21213 - 11905: 0x84D9,
	21214 - 11905: 0x84DA,
	21215 - 11905: 0xC4BC,
	21216 - 11905: 0x84DB,
	21217 - 11905: 0x84DC,
	21218 - 11905: 0x84DD,
	21219 - 11905: 0x84DE,
	21220 - 11905: 0xC7DA,
	21221 - 11905: 0x84DF,
	21222 - 11905: 0x84E0,
	21223 - 11905: 0x84E1,
	21224 - 11905: 0x84E2,
	21225 - 11905: 0x84E3,
	21226 - 11905: 0x84E4,
	21227 - 11905: 0x84E5,
	21228 - 11905: 0x84E6,
	21229 - 11905: 0x84E7,
	21230 - 11905: 0x84E8,
	21231 - 11905: 0x84E9,
	21232 - 11905: 0xDBC4,
	21233 - 11905: 0x84EA,
	21234 - 11905: 0x84EB,
	21235 - 11905: 0x84EC,
	21236 - 11905: 0x84ED,
	21237 - 11905: 0x84EE,
	21238 - 11905: 0x84EF,
	21239 - 11905: 0x84F0,
	21240 - 11905: 0x84F1,
	21241 - 11905: 0xD9E8,
	21242 - 11905: 0xC9D7,
	21243 - 11905: 0x84F2,
	21244 - 11905: 0x84F3,
	21245 - 11905: 0x84F4,
	21246 - 11905: 0xB9B4,
	21247 - 11905: 0xCEF0,
	21248 - 11905: 0xD4C8,
	21249 - 11905: 0x84F5,
	21250 - 11905: 0x84F6,
	21251 - 11905: 0x84F7,
	21252 - 11905: 0x84F8,
	21253 - 11905: 0xB0FC,
	21254 - 11905: 0xB4D2,
	21255 - 11905: 0x84F9,
	21256 - 11905: 0xD0D9,
	21257 - 11905: 0x84FA,
	21258 - 11905: 0x84FB,
	21259 - 11905: 0x84FC,
	21260 - 11905: 0x84FD,
	21261 - 11905: 0xD9E9,
	21262 - 11905: 0x84FE,
	21263 - 11905: 0xDECB,
	21264 - 11905: 0xD9EB,
	21265 - 11905: 0x8540,
	21266 - 11905: 0x8541,
	21267 - 11905: 0x8542,
	21268 - 11905: 0x8543,
	21269 - 11905: 0xD8B0,
	21270 - 11905: 0xBBAF,
	21271 - 11905: 0xB1B1,
	21272 - 11905: 0x8544,
	21273 - 11905: 0xB3D7,
	21274 - 11905: 0xD8CE,
	21275 - 11905: 0x8545,
	21276 - 11905: 0x8546,
	21277 - 11905: 0xD4D1,
	21278 - 11905: 0x8547,
	21279 - 11905: 0x8548,
	21280 - 11905: 0xBDB3,
	21281 - 11905: 0xBFEF,
	21282 - 11905: 0x8549,
	21283 - 11905: 0xCFBB,
	21284 - 11905: 0x854A,
	21285 - 11905: 0x854B,
	21286 - 11905: 0xD8D0,
	21287 - 11905: 0x854C,
	21288 - 11905: 0x854D,
	21289 - 11905: 0x854E,
	21290 - 11905: 0xB7CB,
	21291 - 11905: 0x854F,
	21292 - 11905: 0x8550,
	21293 - 11905: 0x8551,
	21294 - 11905: 0xD8D1,
	21295 - 11905: 0x8552,
	21296 - 11905: 0x8553,
	21297 - 11905: 0x8554,
	21298 - 11905: 0x8555,
	21299 - 11905: 0x8556,
	21300 - 11905: 0x8557,
	21301 - 11905: 0x8558,
	21302 - 11905: 0x8559,
	21303 - 11905: 0x855A,
	21304 - 11905: 0x855B,
	21305 - 11905: 0xC6A5,
	21306 - 11905: 0xC7F8,
	21307 - 11905: 0xD2BD,
	21308 - 11905: 0x855C,
	21309 - 11905: 0x855D,
	21310 - 11905: 0xD8D2,
	21311 - 11905: 0xC4E4,
	21312 - 11905: 0x855E,
	21313 - 11905: 0xCAAE,
	21314 - 11905: 0x855F,
	21315 - 11905: 0xC7A7,
	21316 - 11905: 0x8560,
	21317 - 11905: 0xD8A6,
	21318 - 11905: 0x8561,
	21319 - 11905: 0xC9FD,
	21320 - 11905: 0xCEE7,
	21321 - 11905: 0xBBDC,
	21322 - 11905: 0xB0EB,
	21323 - 11905: 0x8562,
	21324 - 11905: 0x8563,
	21325 - 11905: 0x8564,
	21326 - 11905: 0xBBAA,
	21327 - 11905: 0xD0AD,
	21328 - 11905: 0x8565,
	21329 - 11905: 0xB1B0,
	21330 - 11905: 0xD7E4,
	21331 - 11905: 0xD7BF,
	21332 - 11905: 0x8566,
	21333 - 11905: 0xB5A5,
	21334 - 11905: 0xC2F4,
	21335 - 11905: 0xC4CF,
	21336 - 11905: 0x8567,
	21337 - 11905: 0x8568,
	21338 - 11905: 0xB2A9,
	21339 - 11905: 0x8569,
	21340 - 11905: 0xB2B7,
	21341 - 11905: 0x856A,
	21342 - 11905: 0xB1E5,
	21343 - 11905: 0xDFB2,
	21344 - 11905: 0xD5BC,
	21345 - 11905: 0xBFA8,
	21346 - 11905: 0xC2AC,
	21347 - 11905: 0xD8D5,
	21348 - 11905: 0xC2B1,
	21349 - 11905: 0x856B,
	21350 - 11905: 0xD8D4,
	21351 - 11905: 0xCED4,
	21352 - 11905: 0x856C,
	21353 - 11905: 0xDAE0,
	21354 - 11905: 0x856D,
	21355 - 11905: 0xCEC0,
	21356 - 11905: 0x856E,
	21357 - 11905: 0x856F,
	21358 - 11905: 0xD8B4,
	21359 - 11905: 0xC3AE,
	21360 - 11905: 0xD3A1,
	21361 - 11905: 0xCEA3,
	21362 - 11905: 0x8570,
	21363 - 11905: 0xBCB4,
	21364 - 11905: 0xC8B4,
	21365 - 11905: 0xC2D1,
	21366 - 11905: 0x8571,
	21367 - 11905: 0xBEED,
	21368 - 11905: 0xD0B6,
	21369 - 11905: 0x8572,
	21370 - 11905: 0xDAE1,
	21371 - 11905: 0x8573,
	21372 - 11905: 0x8574,
	21373 - 11905: 0x8575,
	21374 - 11905: 0x8576,
	21375 - 11905: 0xC7E4,
	21376 - 11905: 0x8577,
	21377 - 11905: 0x8578,
	21378 - 11905: 0xB3A7,
	21379 - 11905: 0x8579,
	21380 - 11905: 0xB6F2,
	21381 - 11905: 0xCCFC,
	21382 - 11905: 0xC0FA,
	21383 - 11905: 0x857A,
	21384 - 11905: 0x857B,
	21385 - 11905: 0xC0F7,
	21386 - 11905: 0x857C,
	21387 - 11905: 0xD1B9,
	21388 - 11905: 0xD1E1,
	21389 - 11905: 0xD8C7,
	21390 - 11905: 0x857D,
	21391 - 11905: 0x857E,
	21392 - 11905: 0x8580,
	21393 - 11905: 0x8581,
	21394 - 11905: 0x8582,
	21395 - 11905: 0x8583,
	21396 - 11905: 0x8584,
	21397 - 11905: 0xB2DE,
	21398 - 11905: 0x8585,
	21399 - 11905: 0x8586,
	21400 - 11905: 0xC0E5,
	21401 - 11905: 0x8587,
	21402 - 11905: 0xBAF1,
	21403 - 11905: 0x8588,
	21404 - 11905: 0x8589,
	21405 - 11905: 0xD8C8,
	21406 - 11905: 0x858A,
	21407 - 11905: 0xD4AD,
	21408 - 11905: 0x858B,
	21409 - 11905: 0x858C,
	21410 - 11905: 0xCFE1,
	21411 - 11905: 0xD8C9,
	21412 - 11905: 0x858D,
	21413 - 11905: 0xD8CA,
	21414 - 11905: 0xCFC3,
	21415 - 11905: 0x858E,
	21416 - 11905: 0xB3F8,
	21417 - 11905: 0xBEC7,
	21418 - 11905: 0x858F,
	21419 - 11905: 0x8590,
	21420 - 11905: 0x8591,
	21421 - 11905: 0x8592,
	21422 - 11905: 0xD8CB,
	21423 - 11905: 0x8593,
	21424 - 11905: 0x8594,
	21425 - 11905: 0x8595,
	21426 - 11905: 0x8596,
	21427 - 11905: 0x8597,
	21428 - 11905: 0x8598,
	21429 - 11905: 0x8599,
	21430 - 11905: 0xDBCC,
	21431 - 11905: 0x859A,
	21432 - 11905: 0x859B,
	21433 - 11905: 0x859C,
	21434 - 11905: 0x859D,
	21435 - 11905: 0xC8A5,
	21436 - 11905: 0x859E,
	21437 - 11905: 0x859F,
	21438 - 11905: 0x85A0,
	21439 - 11905: 0xCFD8,
	21440 - 11905: 0x85A1,
	21441 - 11905: 0xC8FE,
	21442 - 11905: 0xB2CE,
	21443 - 11905: 0x85A2,
	21444 - 11905: 0x85A3,
	21445 - 11905: 0x85A4,
	21446 - 11905: 0x85A5,
	21447 - 11905: 0x85A6,
	21448 - 11905: 0xD3D6,
	21449 - 11905: 0xB2E6,
	21450 - 11905: 0xBCB0,
	21451 - 11905: 0xD3D1,
	21452 - 11905: 0xCBAB,
	21453 - 11905: 0xB7B4,
	21454 - 11905: 0x85A7,
	21455 - 11905: 0x85A8,
	21456 - 11905: 0x85A9,
	21457 - 11905: 0xB7A2,
	21458 - 11905: 0x85AA,
	21459 - 11905: 0x85AB,
	21460 - 11905: 0xCAE5,
	21461 - 11905: 0x85AC,
	21462 - 11905: 0xC8A1,
	21463 - 11905: 0xCADC,
	21464 - 11905: 0xB1E4,
	21465 - 11905: 0xD0F0,
	21466 - 11905: 0x85AD,
	21467 - 11905: 0xC5D1,
	21468 - 11905: 0x85AE,
	21469 - 11905: 0x85AF,
	21470 - 11905: 0x85B0,
	21471 - 11905: 0xDBC5,
	21472 - 11905: 0xB5FE,
	21473 - 11905: 0x85B1,
	21474 - 11905: 0x85B2,
	21475 - 11905: 0xBFDA,
	21476 - 11905: 0xB9C5,
	21477 - 11905: 0xBEE4,
	21478 - 11905: 0xC1ED,
	21479 - 11905: 0x85B3,
	21480 - 11905: 0xDFB6,
	21481 - 11905: 0xDFB5,
	21482 - 11905: 0xD6BB,
	21483 - 11905: 0xBDD0,
	21484 - 11905: 0xD5D9,
	21485 - 11905: 0xB0C8,
	21486 - 11905: 0xB6A3,
	21487 - 11905: 0xBFC9,
	21488 - 11905: 0xCCA8,
	21489 - 11905: 0xDFB3,
	21490 - 11905: 0xCAB7,
	21491 - 11905: 0xD3D2,
	21492 - 11905: 0x85B4,
	21493 - 11905: 0xD8CF,
	21494 - 11905: 0xD2B6,
	21495 - 11905: 0xBAC5,
	21496 - 11905: 0xCBBE,
	21497 - 11905: 0xCCBE,
	21498 - 11905: 0x85B5,
	21499 - 11905: 0xDFB7,
	21500 - 11905: 0xB5F0,
	21501 - 11905: 0xDFB4,
	21502 - 11905: 0x85B6,
	21503 - 11905: 0x85B7,
	21504 - 11905: 0x85B8,
	21505 - 11905: 0xD3F5,
	21506 - 11905: 0x85B9,
	21507 - 11905: 0xB3D4,
	21508 - 11905: 0xB8F7,
	21509 - 11905: 0x85BA,
	21510 - 11905: 0xDFBA,
	21511 - 11905: 0x85BB,
	21512 - 11905: 0xBACF,
	21513 - 11905: 0xBCAA,
	21514 - 11905: 0xB5F5,
	21515 - 11905: 0x85BC,
	21516 - 11905: 0xCDAC,
	21517 - 11905: 0xC3FB,
	21518 - 11905: 0xBAF3,
	21519 - 11905: 0xC0F4,
	21520 - 11905: 0xCDC2,
	21521 - 11905: 0xCFF2,
	21522 - 11905: 0xDFB8,
	21523 - 11905: 0xCFC5,
	21524 - 11905: 0x85BD,
	21525 - 11905: 0xC2C0,
	21526 - 11905: 0xDFB9,
	21527 - 11905: 0xC2F0,
	21528 - 11905: 0x85BE,
	21529 - 11905: 0x85BF,
	21530 - 11905: 0x85C0,
	21531 - 11905: 0xBEFD,
	21532 - 11905: 0x85C1,
	21533 - 11905: 0xC1DF,
	21534 - 11905: 0xCDCC,
	21535 - 11905: 0xD2F7,
	21536 - 11905: 0xB7CD,
	21537 - 11905: 0xDFC1,
	21538 - 11905: 0x85C2,
	21539 - 11905: 0xDFC4,
	21540 - 11905: 0x85C3,
	21541 - 11905: 0x85C4,
	21542 - 11905: 0xB7F1,
	21543 - 11905: 0xB0C9,
	21544 - 11905: 0xB6D6,
	21545 - 11905: 0xB7D4,
	21546 - 11905: 0x85C5,
	21547 - 11905: 0xBAAC,
	21548 - 11905: 0xCCFD,
	21549 - 11905: 0xBFD4,
	21550 - 11905: 0xCBB1,
	21551 - 11905: 0xC6F4,
	21552 - 11905: 0x85C6,
	21553 - 11905: 0xD6A8,
	21554 - 11905: 0xDFC5,
	21555 - 11905: 0x85C7,
	21556 - 11905: 0xCEE2,
	21557 - 11905: 0xB3B3,
	21558 - 11905: 0x85C8,
	21559 - 11905: 0x85C9,
	21560 - 11905: 0xCEFC,
	21561 - 11905: 0xB4B5,
	21562 - 11905: 0x85CA,
	21563 - 11905: 0xCEC7,
	21564 - 11905: 0xBAF0,
	21565 - 11905: 0x85CB,
	21566 - 11905: 0xCEE1,
	21567 - 11905: 0x85CC,
	21568 - 11905: 0xD1BD,
	21569 - 11905: 0x85CD,
	21570 - 11905: 0x85CE,
	21571 - 11905: 0xDFC0,
	21572 - 11905: 0x85CF,
	21573 - 11905: 0x85D0,
	21574 - 11905: 0xB4F4,
	21575 - 11905: 0x85D1,
	21576 - 11905: 0xB3CA,
	21577 - 11905: 0x85D2,
	21578 - 11905: 0xB8E6,
	21579 - 11905: 0xDFBB,
	21580 - 11905: 0x85D3,
	21581 - 11905: 0x85D4,
	21582 - 11905: 0x85D5,
	21583 - 11905: 0x85D6,
	21584 - 11905: 0xC4C5,
	21585 - 11905: 0x85D7,
	21586 - 11905: 0xDFBC,
	21587 - 11905: 0xDFBD,
	21588 - 11905: 0xDFBE,
	21589 - 11905: 0xC5BB,
	21590 - 11905: 0xDFBF,
	21591 - 11905: 0xDFC2,
	21592 - 11905: 0xD4B1,
	21593 - 11905: 0xDFC3,
	21594 - 11905: 0x85D8,
	21595 - 11905: 0xC7BA,
	21596 - 11905: 0xCED8,
	21597 - 11905: 0x85D9,
	21598 - 11905: 0x85DA,
	21599 - 11905: 0x85DB,
	21600 - 11905: 0x85DC,
	21601 - 11905: 0x85DD,
	21602 - 11905: 0xC4D8,
	21603 - 11905: 0x85DE,
	21604 - 11905: 0xDFCA,
	21605 - 11905: 0x85DF,
	21606 - 11905: 0xDFCF,
	21607 - 11905: 0x85E0,
	21608 - 11905: 0xD6DC,
	21609 - 11905: 0x85E1,
	21610 - 11905: 0x85E2,
	21611 - 11905: 0x85E3,
	21612 - 11905: 0x85E4,
	21613 - 11905: 0x85E5,
	21614 - 11905: 0x85E6,
	21615 - 11905: 0x85E7,
	21616 - 11905: 0x85E8,
	21617 - 11905: 0xDFC9,
	21618 - 11905: 0xDFDA,
	21619 - 11905: 0xCEB6,
	21620 - 11905: 0x85E9,
	21621 - 11905: 0xBAC7,
	21622 - 11905: 0xDFCE,
	21623 - 11905: 0xDFC8,
	21624 - 11905: 0xC5DE,
	21625 - 11905: 0x85EA,
	21626 - 11905: 0x85EB,
	21627 - 11905: 0xC9EB,
	21628 - 11905: 0xBAF4,
	21629 - 11905: 0xC3FC,
	21630 - 11905: 0x85EC,
	21631 - 11905: 0x85ED,
	21632 - 11905: 0xBED7,
	21633 - 11905: 0x85EE,
	21634 - 11905: 0xDFC6,
	21635 - 11905: 0x85EF,
	21636 - 11905: 0xDFCD,
	21637 - 11905: 0x85F0,
	21638 - 11905: 0xC5D8,
	21639 - 11905: 0x85F1,
	21640 - 11905: 0x85F2,
	21641 - 11905: 0x85F3,
	21642 - 11905: 0x85F4,
	21643 - 11905: 0xD5A6,
	21644 - 11905: 0xBACD,
	21645 - 11905: 0x85F5,
	21646 - 11905: 0xBECC,
	21647 - 11905: 0xD3BD,
	21648 - 11905: 0xB8C0,
	21649 - 11905: 0x85F6,
	21650 - 11905: 0xD6E4,
	21651 - 11905: 0x85F7,
	21652 - 11905: 0xDFC7,
	21653 - 11905: 0xB9BE,
	21654 - 11905: 0xBFA7,
	21655 - 11905: 0x85F8,
	21656 - 11905: 0x85F9,
	21657 - 11905: 0xC1FC,
	21658 - 11905: 0xDFCB,
	21659 - 11905: 0xDFCC,
	21660 - 11905: 0x85FA,
	21661 - 11905: 0xDFD0,
	21662 - 11905: 0x85FB,
	21663 - 11905: 0x85FC,
	21664 - 11905: 0x85FD,
	21665 - 11905: 0x85FE,
	21666 - 11905: 0x8640,
	21667 - 11905: 0xDFDB,
	21668 - 11905: 0xDFE5,
	21669 - 11905: 0x8641,
	21670 - 11905: 0xDFD7,
	21671 - 11905: 0xDFD6,
	21672 - 11905: 0xD7C9,
	21673 - 11905: 0xDFE3,
	21674 - 11905: 0xDFE4,
	21675 - 11905: 0xE5EB,
	21676 - 11905: 0xD2A7,
	21677 - 11905: 0xDFD2,
	21678 - 11905: 0x8642,
	21679 - 11905: 0xBFA9,
	21680 - 11905: 0x8643,
	21681 - 11905: 0xD4DB,
	21682 - 11905: 0x8644,
	21683 - 11905: 0xBFC8,
	21684 - 11905: 0xDFD4,
	21685 - 11905: 0x8645,
	21686 - 11905: 0x8646,
	21687 - 11905: 0x8647,
	21688 - 11905: 0xCFCC,
	21689 - 11905: 0x8648,
	21690 - 11905: 0x8649,
	21691 - 11905: 0xDFDD,
	21692 - 11905: 0x864A,
	21693 - 11905: 0xD1CA,
	21694 - 11905: 0x864B,
	21695 - 11905: 0xDFDE,
	21696 - 11905: 0xB0A7,
	21697 - 11905: 0xC6B7,
	21698 - 11905: 0xDFD3,
	21699 - 11905: 0x864C,
	21700 - 11905: 0xBAE5,
	21701 - 11905: 0x864D,
	21702 - 11905: 0xB6DF,
	21703 - 11905: 0xCDDB,
	21704 - 11905: 0xB9FE,
	21705 - 11905: 0xD4D5,
	21706 - 11905: 0x864E,
	21707 - 11905: 0x864F,
	21708 - 11905: 0xDFDF,
	21709 - 11905: 0xCFEC,
	21710 - 11905: 0xB0A5,
	21711 - 11905: 0xDFE7,
	21712 - 11905: 0xDFD1,
	21713 - 11905: 0xD1C6,
	21714 - 11905: 0xDFD5,
	21715 - 11905: 0xDFD8,
	21716 - 11905: 0xDFD9,
	21717 - 11905: 0xDFDC,
	21718 - 11905: 0x8650,
	21719 - 11905: 0xBBA9,
	21720 - 11905: 0x8651,
	21721 - 11905: 0xDFE0,
	21722 - 11905: 0xDFE1,
	21723 - 11905: 0x8652,
	21724 - 11905: 0xDFE2,
	21725 - 11905: 0xDFE6,
	21726 - 11905: 0xDFE8,
	21727 - 11905: 0xD3B4,
	21728 - 11905: 0x8653,
	21729 - 11905: 0x8654,
	21730 - 11905: 0x8655,
	21731 - 11905: 0x8656,
	21732 - 11905: 0x8657,
	21733 - 11905: 0xB8E7,
	21734 - 11905: 0xC5B6,
	21735 - 11905: 0xDFEA,
	21736 - 11905: 0xC9DA,
	21737 - 11905: 0xC1A8,
	21738 - 11905: 0xC4C4,
	21739 - 11905: 0x8658,
	21740 - 11905: 0x8659,
	21741 - 11905: 0xBFDE,
	21742 - 11905: 0xCFF8,
	21743 - 11905: 0x865A,
	21744 - 11905: 0x865B,
	21745 - 11905: 0x865C,
	21746 - 11905: 0xD5DC,
	21747 - 11905: 0xDFEE,
	21748 - 11905: 0x865D,
	21749 - 11905: 0x865E,
	21750 - 11905: 0x865F,
	21751 - 11905: 0x8660,
	21752 - 11905: 0x8661,
	21753 - 11905: 0x8662,
	21754 - 11905: 0xB2B8,
	21755 - 11905: 0x8663,
	21756 - 11905: 0xBADF,
	21757 - 11905: 0xDFEC,
	21758 - 11905: 0x8664,
	21759 - 11905: 0xDBC1,
	21760 - 11905: 0x8665,
	21761 - 11905: 0xD1E4,
	21762 - 11905: 0x8666,
	21763 - 11905: 0x8667,
	21764 - 11905: 0x8668,
	21765 - 11905: 0x8669,
	21766 - 11905: 0xCBF4,
	21767 - 11905: 0xB4BD,
	21768 - 11905: 0x866A,
	21769 - 11905: 0xB0A6,
	21770 - 11905: 0x866B,
	21771 - 11905: 0x866C,
	21772 - 11905: 0x866D,
	21773 - 11905: 0x866E,
	21774 - 11905: 0x866F,
	21775 - 11905: 0xDFF1,
	21776 - 11905: 0xCCC6,
	21777 - 11905: 0xDFF2,
	21778 - 11905: 0x8670,
	21779 - 11905: 0x8671,
	21780 - 11905: 0xDFED,
	21781 - 11905: 0x8672,
	21782 - 11905: 0x8673,
	21783 - 11905: 0x8674,
	21784 - 11905: 0x8675,
	21785 - 11905: 0x8676,
	21786 - 11905: 0x8677,
	21787 - 11905: 0xDFE9,
	21788 - 11905: 0x8678,
	21789 - 11905: 0x8679,
	21790 - 11905: 0x867A,
	21791 - 11905: 0x867B,
	21792 - 11905: 0xDFEB,
	21793 - 11905: 0x867C,
	21794 - 11905: 0xDFEF,
	21795 - 11905: 0xDFF0,
	21796 - 11905: 0xBBBD,
	21797 - 11905: 0x867D,
	21798 - 11905: 0x867E,
	21799 - 11905: 0xDFF3,
	21800 - 11905: 0x8680,
	21801 - 11905: 0x8681,
	21802 - 11905: 0xDFF4,
	21803 - 11905: 0x8682,
	21804 - 11905: 0xBBA3,
	21805 - 11905: 0x8683,
	21806 - 11905: 0xCADB,
	21807 - 11905: 0xCEA8,
	21808 - 11905: 0xE0A7,
	21809 - 11905: 0xB3AA,
	21810 - 11905: 0x8684,
	21811 - 11905: 0xE0A6,
	21812 - 11905: 0x8685,
	21813 - 11905: 0x8686,
	21814 - 11905: 0x8687,
	21815 - 11905: 0xE0A1,
	21816 - 11905: 0x8688,
	21817 - 11905: 0x8689,
	21818 - 11905: 0x868A,
	21819 - 11905: 0x868B,
	21820 - 11905: 0xDFFE,
	21821 - 11905: 0x868C,
	21822 - 11905: 0xCDD9,
	21823 - 11905: 0xDFFC,
	21824 - 11905: 0x868D,
	21825 - 11905: 0xDFFA,
	21826 - 11905: 0x868E,
	21827 - 11905: 0xBFD0,
	21828 - 11905: 0xD7C4,
	21829 - 11905: 0x868F,
	21830 - 11905: 0xC9CC,
	21831 - 11905: 0x8690,
	21832 - 11905: 0x8691,
	21833 - 11905: 0xDFF8,
	21834 - 11905: 0xB0A1,
	21835 - 11905: 0x8692,
	21836 - 11905: 0x8693,
	21837 - 11905: 0x8694,
	21838 - 11905: 0x8695,
	21839 - 11905: 0x8696,
	21840 - 11905: 0xDFFD,
	21841 - 11905: 0x8697,
	21842 - 11905: 0x8698,
	21843 - 11905: 0x8699,
	21844 - 11905: 0x869A,
	21845 - 11905: 0xDFFB,
	21846 - 11905: 0xE0A2,
	21847 - 11905: 0x869B,
	21848 - 11905: 0x869C,
	21849 - 11905: 0x869D,
	21850 - 11905: 0x869E,
	21851 - 11905: 0x869F,
	21852 - 11905: 0xE0A8,
	21853 - 11905: 0x86A0,
	21854 - 11905: 0x86A1,
	21855 - 11905: 0x86A2,
	21856 - 11905: 0x86A3,
	21857 - 11905: 0xB7C8,
	21858 - 11905: 0x86A4,
	21859 - 11905: 0x86A5,
	21860 - 11905: 0xC6A1,
	21861 - 11905: 0xC9B6,
	21862 - 11905: 0xC0B2,
	21863 - 11905: 0xDFF5,
	21864 - 11905: 0x86A6,
	21865 - 11905: 0x86A7,
	21866 - 11905: 0xC5BE,
	21867 - 11905: 0x86A8,
	21868 - 11905: 0xD8C4,
	21869 - 11905: 0xDFF9,
	21870 - 11905: 0xC4F6,
	21871 - 11905: 0x86A9,
	21872 - 11905: 0x86AA,
	21873 - 11905: 0x86AB,
	21874 - 11905: 0x86AC,
	21875 - 11905: 0x86AD,
	21876 - 11905: 0x86AE,
	21877 - 11905: 0xE0A3,
	21878 - 11905: 0xE0A4,
	21879 - 11905: 0xE0A5,
	21880 - 11905: 0xD0A5,
	21881 - 11905: 0x86AF,
	21882 - 11905: 0x86B0,
	21883 - 11905: 0xE0B4,
	21884 - 11905: 0xCCE4,
	21885 - 11905: 0x86B1,
	21886 - 11905: 0xE0B1,
	21887 - 11905: 0x86B2,
	21888 - 11905: 0xBFA6,
	21889 - 11905: 0xE0AF,
	21890 - 11905: 0xCEB9,
	21891 - 11905: 0xE0AB,
	21892 - 11905: 0xC9C6,
	21893 - 11905: 0x86B3,
	21894 - 11905: 0x86B4,
	21895 - 11905: 0xC0AE,
	21896 - 11905: 0xE0AE,
	21897 - 11905: 0xBAED,
	21898 - 11905: 0xBAB0,
	21899 - 11905: 0xE0A9,
	21900 - 11905: 0x86B5,
	21901 - 11905: 0x86B6,
	21902 - 11905: 0x86B7,
	21903 - 11905: 0xDFF6,
	21904 - 11905: 0x86B8,
	21905 - 11905: 0xE0B3,
	21906 - 11905: 0x86B9,
	21907 - 11905: 0x86BA,
	21908 - 11905: 0xE0B8,
	21909 - 11905: 0x86BB,
	21910 - 11905: 0x86BC,
	21911 - 11905: 0x86BD,
	21912 - 11905: 0xB4AD,
	21913 - 11905: 0xE0B9,
	21914 - 11905: 0x86BE,
	21915 - 11905: 0x86BF,
	21916 - 11905: 0xCFB2,
	21917 - 11905: 0xBAC8,
	21918 - 11905: 0x86C0,
	21919 - 11905: 0xE0B0,
	21920 - 11905: 0x86C1,
	21921 - 11905: 0x86C2,
	21922 - 11905: 0x86C3,
	21923 - 11905: 0x86C4,
	21924 - 11905: 0x86C5,
	21925 - 11905: 0x86C6,
	21926 - 11905: 0x86C7,
	21927 - 11905: 0xD0FA,
	21928 - 11905: 0x86C8,
	21929 - 11905: 0x86C9,
	21930 - 11905: 0x86CA,
	21931 - 11905: 0x86CB,
	21932 - 11905: 0x86CC,
	21933 - 11905: 0x86CD,
	21934 - 11905: 0x86CE,
	21935 - 11905: 0x86CF,
	21936 - 11905: 0x86D0,
	21937 - 11905: 0xE0AC,
	21938 - 11905: 0x86D1,
	21939 - 11905: 0xD4FB,
	21940 - 11905: 0x86D2,
	21941 - 11905: 0xDFF7,
	21942 - 11905: 0x86D3,
	21943 - 11905: 0xC5E7,
	21944 - 11905: 0x86D4,
	21945 - 11905: 0xE0AD,
	21946 - 11905: 0x86D5,
	21947 - 11905: 0xD3F7,
	21948 - 11905: 0x86D6,
	21949 - 11905: 0xE0B6,
	21950 - 11905: 0xE0B7,
	21951 - 11905: 0x86D7,
	21952 - 11905: 0x86D8,
	21953 - 11905: 0x86D9,
	21954 - 11905: 0x86DA,
	21955 - 11905: 0x86DB,
	21956 - 11905: 0xE0C4,
	21957 - 11905: 0xD0E1,
	21958 - 11905: 0x86DC,
	21959 - 11905: 0x86DD,
	21960 - 11905: 0x86DE,
	21961 - 11905: 0xE0BC,
	21962 - 11905: 0x86DF,
	21963 - 11905: 0x86E0,
	21964 - 11905: 0xE0C9,
	21965 - 11905: 0xE0CA,
	21966 - 11905: 0x86E1,
	21967 - 11905: 0x86E2,
	21968 - 11905: 0x86E3,
	21969 - 11905: 0xE0BE,
	21970 - 11905: 0xE0AA,
	21971 - 11905: 0xC9A4,
	21972 - 11905: 0xE0C1,
	21973 - 11905: 0x86E4,
	21974 - 11905: 0xE0B2,
	21975 - 11905: 0x86E5,
	21976 - 11905: 0x86E6,
	21977 - 11905: 0x86E7,
	21978 - 11905: 0x86E8,
	21979 - 11905: 0x86E9,
	21980 - 11905: 0xCAC8,
	21981 - 11905: 0xE0C3,
	21982 - 11905: 0x86EA,
	21983 - 11905: 0xE0B5,
	21984 - 11905: 0x86EB,
	21985 - 11905: 0xCECB,
	21986 - 11905: 0x86EC,
	21987 - 11905: 0xCBC3,
	21988 - 11905: 0xE0CD,
	21989 - 11905: 0xE0C6,
	21990 - 11905: 0xE0C2,
	21991 - 11905: 0x86ED,
	21992 - 11905: 0xE0CB,
	21993 - 11905: 0x86EE,
	21994 - 11905: 0xE0BA,
	21995 - 11905: 0xE0BF,
	21996 - 11905: 0xE0C0,
	21997 - 11905: 0x86EF,
	21998 - 11905: 0x86F0,
	21999 - 11905: 0xE0C5,
	22000 - 11905: 0x86F1,
	22001 - 11905: 0x86F2,
	22002 - 11905: 0xE0C7,
	22003 - 11905: 0xE0C8,
	22004 - 11905: 0x86F3,
	22005 - 11905: 0xE0CC,
	22006 - 11905: 0x86F4,
	22007 - 11905: 0xE0BB,
	22008 - 11905: 0x86F5,
	22009 - 11905: 0x86F6,
	22010 - 11905: 0x86F7,
	22011 - 11905: 0x86F8,
	22012 - 11905: 0x86F9,
	22013 - 11905: 0xCBD4,
	22014 - 11905: 0xE0D5,
	22015 - 11905: 0x86FA,
	22016 - 11905: 0xE0D6,
	22017 - 11905: 0xE0D2,
	22018 - 11905: 0x86FB,
	22019 - 11905: 0x86FC,
	22020 - 11905: 0x86FD,
	22021 - 11905: 0x86FE,
	22022 - 11905: 0x8740,
	22023 - 11905: 0x8741,
	22024 - 11905: 0xE0D0,
	22025 - 11905: 0xBCCE,
	22026 - 11905: 0x8742,
	22027 - 11905: 0x8743,
	22028 - 11905: 0xE0D1,
	22029 - 11905: 0x8744,
	22030 - 11905: 0xB8C2,
	22031 - 11905: 0xD8C5,
	22032 - 11905: 0x8745,
	22033 - 11905: 0x8746,
	22034 - 11905: 0x8747,
	22035 - 11905: 0x8748,
	22036 - 11905: 0x8749,
	22037 - 11905: 0x874A,
	22038 - 11905: 0x874B,
	22039 - 11905: 0x874C,
	22040 - 11905: 0xD0EA,
	22041 - 11905: 0x874D,
	22042 - 11905: 0x874E,
	22043 - 11905: 0xC2EF,
	22044 - 11905: 0x874F,
	22045 - 11905: 0x8750,
	22046 - 11905: 0xE0CF,
	22047 - 11905: 0xE0BD,
	22048 - 11905: 0x8751,
	22049 - 11905: 0x8752,
	22050 - 11905: 0x8753,
	22051 - 11905: 0xE0D4,
	22052 - 11905: 0xE0D3,
	22053 - 11905: 0x8754,
	22054 - 11905: 0x8755,
	22055 - 11905: 0xE0D7,
	22056 - 11905: 0x8756,
	22057 - 11905: 0x8757,
	22058 - 11905: 0x8758,
	22059 - 11905: 0x8759,
	22060 - 11905: 0xE0DC,
	22061 - 11905: 0xE0D8,
	22062 - 11905: 0x875A,
	22063 - 11905: 0x875B,
	22064 - 11905: 0x875C,
	22065 - 11905: 0xD6F6,
	22066 - 11905: 0xB3B0,
	22067 - 11905: 0x875D,
	22068 - 11905: 0xD7EC,
	22069 - 11905: 0x875E,
	22070 - 11905: 0xCBBB,
	22071 - 11905: 0x875F,
	22072 - 11905: 0x8760,
	22073 - 11905: 0xE0DA,
	22074 - 11905: 0x8761,
	22075 - 11905: 0xCEFB,
	22076 - 11905: 0x8762,
	22077 - 11905: 0x8763,
	22078 - 11905: 0x8764,
	22079 - 11905: 0xBAD9,
	22080 - 11905: 0x8765,
	22081 - 11905: 0x8766,
	22082 - 11905: 0x8767,
	22083 - 11905: 0x8768,
	22084 - 11905: 0x8769,
	22085 - 11905: 0x876A,
	22086 - 11905: 0x876B,
	22087 - 11905: 0x876C,
	22088 - 11905: 0x876D,
	22089 - 11905: 0x876E,
	22090 - 11905: 0x876F,
	22091 - 11905: 0x8770,
	22092 - 11905: 0xE0E1,
	22093 - 11905: 0xE0DD,
	22094 - 11905: 0xD2AD,
	22095 - 11905: 0x8771,
	22096 - 11905: 0x8772,
	22097 - 11905: 0x8773,
	22098 - 11905: 0x8774,
	22099 - 11905: 0x8775,
	22100 - 11905: 0xE0E2,
	22101 - 11905: 0x8776,
	22102 - 11905: 0x8777,
	22103 - 11905: 0xE0DB,
	22104 - 11905: 0xE0D9,
	22105 - 11905: 0xE0DF,
	22106 - 11905: 0x8778,
	22107 - 11905: 0x8779,
	22108 - 11905: 0xE0E0,
	22109 - 11905: 0x877A,
	22110 - 11905: 0x877B,
	22111 - 11905: 0x877C,
	22112 - 11905: 0x877D,
	22113 - 11905: 0x877E,
	22114 - 11905: 0xE0DE,
	22115 - 11905: 0x8780,
	22116 - 11905: 0xE0E4,
	22117 - 11905: 0x8781,
	22118 - 11905: 0x8782,
	22119 - 11905: 0x8783,
	22120 - 11905: 0xC6F7,
	22121 - 11905: 0xD8AC,
	22122 - 11905: 0xD4EB,
	22123 - 11905: 0xE0E6,
	22124 - 11905: 0xCAC9,
	22125 - 11905: 0x8784,
	22126 - 11905: 0x8785,
	22127 - 11905: 0x8786,
	22128 - 11905: 0x8787,
	22129 - 11905: 0xE0E5,
	22130 - 11905: 0x8788,
	22131 - 11905: 0x8789,
	22132 - 11905: 0x878A,
	22133 - 11905: 0x878B,
	22134 - 11905: 0xB8C1,
	22135 - 11905: 0x878C,
	22136 - 11905: 0x878D,
	22137 - 11905: 0x878E,
	22138 - 11905: 0x878F,
	22139 - 11905: 0xE0E7,
	22140 - 11905: 0xE0E8,
	22141 - 11905: 0x8790,
	22142 - 11905: 0x8791,
	22143 - 11905: 0x8792,
	22144 - 11905: 0x8793,
	22145 - 11905: 0x8794,
	22146 - 11905: 0x8795,
	22147 - 11905: 0x8796,
	22148 - 11905: 0x8797,
	22149 - 11905: 0xE0E9,
	22150 - 11905: 0xE0E3,
	22151 - 11905: 0x8798,
	22152 - 11905: 0x8799,
	22153 - 11905: 0x879A,
	22154 - 11905: 0x879B,
	22155 - 11905: 0x879C,
	22156 - 11905: 0x879D,
	22157 - 11905: 0x879E,
	22158 - 11905: 0xBABF,
	22159 - 11905: 0xCCE7,
	22160 - 11905: 0x879F,
	22161 - 11905: 0x87A0,
	22162 - 11905: 0x87A1,
	22163 - 11905: 0xE0EA,
	22164 - 11905: 0x87A2,
	22165 - 11905: 0x87A3,
	22166 - 11905: 0x87A4,
	22167 - 11905: 0x87A5,
	22168 - 11905: 0x87A6,
	22169 - 11905: 0x87A7,
	22170 - 11905: 0x87A8,
	22171 - 11905: 0x87A9,
	22172 - 11905: 0x87AA,
	22173 - 11905: 0x87AB,
	22174 - 11905: 0x87AC,
	22175 - 11905: 0x87AD,
	22176 - 11905: 0x87AE,
	22177 - 11905: 0x87AF,
	22178 - 11905: 0x87B0,
	22179 - 11905: 0xCFF9,
	22180 - 11905: 0x87B1,
	22181 - 11905: 0x87B2,
	22182 - 11905: 0x87B3,
	22183 - 11905: 0x87B4,
	22184 - 11905: 0x87B5,
	22185 - 11905: 0x87B6,
	22186 - 11905: 0x87B7,
	22187 - 11905: 0x87B8,
	22188 - 11905: 0x87B9,
	22189 - 11905: 0x87BA,
	22190 - 11905: 0x87BB,
	22191 - 11905: 0xE0EB,
	22192 - 11905: 0x87BC,
	22193 - 11905: 0x87BD,
	22194 - 11905: 0x87BE,
	22195 - 11905: 0x87BF,
	22196 - 11905: 0x87C0,
	22197 - 11905: 0x87C1,
	22198 - 11905: 0x87C2,
	22199 - 11905: 0xC8C2,
	22200 - 11905: 0x87C3,
	22201 - 11905: 0x87C4,
	22202 - 11905: 0x87C5,
	22203 - 11905: 0x87C6,
	22204 - 11905: 0xBDC0,
	22205 - 11905: 0x87C7,
	22206 - 11905: 0x87C8,
	22207 - 11905: 0x87C9,
	22208 - 11905: 0x87CA,
	22209 - 11905: 0x87CB,
	22210 - 11905: 0x87CC,
	22211 - 11905: 0x87CD,
	22212 - 11905: 0x87CE,
	22213 - 11905: 0x87CF,
	22214 - 11905: 0x87D0,
	22215 - 11905: 0x87D1,
	22216 - 11905: 0x87D2,
	22217 - 11905: 0x87D3,
	22218 - 11905: 0xC4D2,
	22219 - 11905: 0x87D4,
	22220 - 11905: 0x87D5,
	22221 - 11905: 0x87D6,
	22222 - 11905: 0x87D7,
	22223 - 11905: 0x87D8,
	22224 - 11905: 0x87D9,
	22225 - 11905: 0x87DA,
	22226 - 11905: 0x87DB,
	22227 - 11905: 0x87DC,
	22228 - 11905: 0xE0EC,
	22229 - 11905: 0x87DD,
	22230 - 11905: 0x87DE,
	22231 - 11905: 0xE0ED,
	22232 - 11905: 0x87DF,
	22233 - 11905: 0x87E0,
	22234 - 11905: 0xC7F4,
	22235 - 11905: 0xCBC4,
	22236 - 11905: 0x87E1,
	22237 - 11905: 0xE0EE,
	22238 - 11905: 0xBBD8,
	22239 - 11905: 0xD8B6,
	22240 - 11905: 0xD2F2,
	22241 - 11905: 0xE0EF,
	22242 - 11905: 0xCDC5,
	22243 - 11905: 0x87E2,
	22244 - 11905: 0xB6DA,
	22245 - 11905: 0x87E3,
	22246 - 11905: 0x87E4,
	22247 - 11905: 0x87E5,
	22248 - 11905: 0x87E6,
	22249 - 11905: 0x87E7,
	22250 - 11905: 0x87E8,
	22251 - 11905: 0xE0F1,
	22252 - 11905: 0x87E9,
	22253 - 11905: 0xD4B0,
	22254 - 11905: 0x87EA,
	22255 - 11905: 0x87EB,
	22256 - 11905: 0xC0A7,
	22257 - 11905: 0xB4D1,
	22258 - 11905: 0x87EC,
	22259 - 11905: 0x87ED,
	22260 - 11905: 0xCEA7,
	22261 - 11905: 0xE0F0,
	22262 - 11905: 0x87EE,
	22263 - 11905: 0x87EF,
	22264 - 11905: 0x87F0,
	22265 - 11905: 0xE0F2,
	22266 - 11905: 0xB9CC,
	22267 - 11905: 0x87F1,
	22268 - 11905: 0x87F2,
	22269 - 11905: 0xB9FA,
	22270 - 11905: 0xCDBC,
	22271 - 11905: 0xE0F3,
	22272 - 11905: 0x87F3,
	22273 - 11905: 0x87F4,
	22274 - 11905: 0x87F5,
	22275 - 11905: 0xC6D4,
	22276 - 11905: 0xE0F4,
	22277 - 11905: 0x87F6,
	22278 - 11905: 0xD4B2,
	22279 - 11905: 0x87F7,
	22280 - 11905: 0xC8A6,
	22281 - 11905: 0xE0F6,
	22282 - 11905: 0xE0F5,
	22283 - 11905: 0x87F8,
	22284 - 11905: 0x87F9,
	22285 - 11905: 0x87FA,
	22286 - 11905: 0x87FB,
	22287 - 11905: 0x87FC,
	22288 - 11905: 0x87FD,
	22289 - 11905: 0x87FE,
	22290 - 11905: 0x8840,
	22291 - 11905: 0x8841,
	22292 - 11905: 0x8842,
	22293 - 11905: 0x8843,
	22294 - 11905: 0x8844,
	22295 - 11905: 0x8845,
	22296 - 11905: 0x8846,
	22297 - 11905: 0x8847,
	22298 - 11905: 0x8848,
	22299 - 11905: 0x8849,
	22300 - 11905: 0xE0F7,
	22301 - 11905: 0x884A,
	22302 - 11905: 0x884B,
	22303 - 11905: 0xCDC1,
	22304 - 11905: 0x884C,
	22305 - 11905: 0x884D,
	22306 - 11905: 0x884E,
	22307 - 11905: 0xCAA5,
	22308 - 11905: 0x884F,
	22309 - 11905: 0x8850,
	22310 - 11905: 0x8851,
	22311 - 11905: 0x8852,
	22312 - 11905: 0xD4DA,
	22313 - 11905: 0xDBD7,
	22314 - 11905: 0xDBD9,
	22315 - 11905: 0x8853,
	22316 - 11905: 0xDBD8,
	22317 - 11905: 0xB9E7,
	22318 - 11905: 0xDBDC,
	22319 - 11905: 0xDBDD,
	22320 - 11905: 0xB5D8,
	22321 - 11905: 0x8854,
	22322 - 11905: 0x8855,
	22323 - 11905: 0xDBDA,
	22324 - 11905: 0x8856,
	22325 - 11905: 0x8857,
	22326 - 11905: 0x8858,
	22327 - 11905: 0x8859,
	22328 - 11905: 0x885A,
	22329 - 11905: 0xDBDB,
	22330 - 11905: 0xB3A1,
	22331 - 11905: 0xDBDF,
	22332 - 11905: 0x885B,
	22333 - 11905: 0x885C,
	22334 - 11905: 0xBBF8,
	22335 - 11905: 0x885D,
	22336 - 11905: 0xD6B7,
	22337 - 11905: 0x885E,
	22338 - 11905: 0xDBE0,
	22339 - 11905: 0x885F,
	22340 - 11905: 0x8860,
	22341 - 11905: 0x8861,
	22342 - 11905: 0x8862,
	22343 - 11905: 0xBEF9,
	22344 - 11905: 0x8863,
	22345 - 11905: 0x8864,
	22346 - 11905: 0xB7BB,
	22347 - 11905: 0x8865,
	22348 - 11905: 0xDBD0,
	22349 - 11905: 0xCCAE,
	22350 - 11905: 0xBFB2,
	22351 - 11905: 0xBBB5,
	22352 - 11905: 0xD7F8,
	22353 - 11905: 0xBFD3,
	22354 - 11905: 0x8866,
	22355 - 11905: 0x8867,
	22356 - 11905: 0x8868,
	22357 - 11905: 0x8869,
	22358 - 11905: 0x886A,
	22359 - 11905: 0xBFE9,
	22360 - 11905: 0x886B,
	22361 - 11905: 0x886C,
	22362 - 11905: 0xBCE1,
	22363 - 11905: 0xCCB3,
	22364 - 11905: 0xDBDE,
	22365 - 11905: 0xB0D3,
	22366 - 11905: 0xCEEB,
	22367 - 11905: 0xB7D8,
	22368 - 11905: 0xD7B9,
	22369 - 11905: 0xC6C2,
	22370 - 11905: 0x886D,
	22371 - 11905: 0x886E,
	22372 - 11905: 0xC0A4,
	22373 - 11905: 0x886F,
	22374 - 11905: 0xCCB9,
	22375 - 11905: 0x8870,
	22376 - 11905: 0xDBE7,
	22377 - 11905: 0xDBE1,
	22378 - 11905: 0xC6BA,
	22379 - 11905: 0xDBE3,
	22380 - 11905: 0x8871,
	22381 - 11905: 0xDBE8,
	22382 - 11905: 0x8872,
	22383 - 11905: 0xC5F7,
	22384 - 11905: 0x8873,
	22385 - 11905: 0x8874,
	22386 - 11905: 0x8875,
	22387 - 11905: 0xDBEA,
	22388 - 11905: 0x8876,
	22389 - 11905: 0x8877,
	22390 - 11905: 0xDBE9,
	22391 - 11905: 0xBFC0,
	22392 - 11905: 0x8878,
	22393 - 11905: 0x8879,
	22394 - 11905: 0x887A,
	22395 - 11905: 0xDBE6,
	22396 - 11905: 0xDBE5,
	22397 - 11905: 0x887B,
	22398 - 11905: 0x887C,
	22399 - 11905: 0x887D,
	22400 - 11905: 0x887E,
	22401 - 11905: 0x8880,
	22402 - 11905: 0xB4B9,
	22403 - 11905: 0xC0AC,
	22404 - 11905: 0xC2A2,
	22405 - 11905: 0xDBE2,
	22406 - 11905: 0xDBE4,
	22407 - 11905: 0x8881,
	22408 - 11905: 0x8882,
	22409 - 11905: 0x8883,
	22410 - 11905: 0x8884,
	22411 - 11905: 0xD0CD,
	22412 - 11905: 0xDBED,
	22413 - 11905: 0x8885,
	22414 - 11905: 0x8886,
	22415 - 11905: 0x8887,
	22416 - 11905: 0x8888,
	22417 - 11905: 0x8889,
	22418 - 11905: 0xC0DD,
	22419 - 11905: 0xDBF2,
	22420 - 11905: 0x888A,
	22421 - 11905: 0x888B,
	22422 - 11905: 0x888C,
	22423 - 11905: 0x888D,
	22424 - 11905: 0x888E,
	22425 - 11905: 0x888F,
	22426 - 11905: 0x8890,
	22427 - 11905: 0xB6E2,
	22428 - 11905: 0x8891,
	22429 - 11905: 0x8892,
	22430 - 11905: 0x8893,
	22431 - 11905: 0x8894,
	22432 - 11905: 0xDBF3,
	22433 - 11905: 0xDBD2,
	22434 - 11905: 0xB9B8,
	22435 - 11905: 0xD4AB,
	22436 - 11905: 0xDBEC,
	22437 - 11905: 0x8895,
	22438 - 11905: 0xBFD1,
	22439 - 11905: 0xDBF0,
	22440 - 11905: 0x8896,
	22441 - 11905: 0xDBD1,
	22442 - 11905: 0x8897,
	22443 - 11905: 0xB5E6,
	22444 - 11905: 0x8898,
	22445 - 11905: 0xDBEB,
	22446 - 11905: 0xBFE5,
	22447 - 11905: 0x8899,
	22448 - 11905: 0x889A,
	22449 - 11905: 0x889B,
	22450 - 11905: 0xDBEE,
	22451 - 11905: 0x889C,
	22452 - 11905: 0xDBF1,
	22453 - 11905: 0x889D,
	22454 - 11905: 0x889E,
	22455 - 11905: 0x889F,
	22456 - 11905: 0xDBF9,
	22457 - 11905: 0x88A0,
	22458 - 11905: 0x88A1,
	22459 - 11905: 0x88A2,
	22460 - 11905: 0x88A3,
	22461 - 11905: 0x88A4,
	22462 - 11905: 0x88A5,
	22463 - 11905: 0x88A6,
	22464 - 11905: 0x88A7,
	22465 - 11905: 0x88A8,
	22466 - 11905: 0xB9A1,
	22467 - 11905: 0xB0A3,
	22468 - 11905: 0x88A9,
	22469 - 11905: 0x88AA,
	22470 - 11905: 0x88AB,
	22471 - 11905: 0x88AC,
	22472 - 11905: 0x88AD,
	22473 - 11905: 0x88AE,
	22474 - 11905: 0x88AF,
	22475 - 11905: 0xC2F1,
	22476 - 11905: 0x88B0,
	22477 - 11905: 0x88B1,
	22478 - 11905: 0xB3C7,
	22479 - 11905: 0xDBEF,
	22480 - 11905: 0x88B2,
	22481 - 11905: 0x88B3,
	22482 - 11905: 0xDBF8,
	22483 - 11905: 0x88B4,
	22484 - 11905: 0xC6D2,
	22485 - 11905: 0xDBF4,
	22486 - 11905: 0x88B5,
	22487 - 11905: 0x88B6,
	22488 - 11905: 0xDBF5,
	22489 - 11905: 0xDBF7,
	22490 - 11905: 0xDBF6,
	22491 - 11905: 0x88B7,
	22492 - 11905: 0x88B8,
	22493 - 11905: 0xDBFE,
	22494 - 11905: 0x88B9,
	22495 - 11905: 0xD3F2,
	22496 - 11905: 0xB2BA,
	22497 - 11905: 0x88BA,
	22498 - 11905: 0x88BB,
	22499 - 11905: 0x88BC,
	22500 - 11905: 0xDBFD,
	22501 - 11905: 0x88BD,
	22502 - 11905: 0x88BE,
	22503 - 11905: 0x88BF,
	22504 - 11905: 0x88C0,
	22505 - 11905: 0x88C1,
	22506 - 11905: 0x88C2,
	22507 - 11905: 0x88C3,
	22508 - 11905: 0x88C4,
	22509 - 11905: 0xDCA4,
	22510 - 11905: 0x88C5,
	22511 - 11905: 0xDBFB,
	22512 - 11905: 0x88C6,
	22513 - 11905: 0x88C7,
	22514 - 11905: 0x88C8,
	22515 - 11905: 0x88C9,
	22516 - 11905: 0xDBFA,
	22517 - 11905: 0x88CA,
	22518 - 11905: 0x88CB,
	22519 - 11905: 0x88CC,
	22520 - 11905: 0xDBFC,
	22521 - 11905: 0xC5E0,
	22522 - 11905: 0xBBF9,
	22523 - 11905: 0x88CD,
	22524 - 11905: 0x88CE,
	22525 - 11905: 0xDCA3,
	22526 - 11905: 0x88CF,
	22527 - 11905: 0x88D0,
	22528 - 11905: 0xDCA5,
	22529 - 11905: 0x88D1,
	22530 - 11905: 0xCCC3,
	22531 - 11905: 0x88D2,
	22532 - 11905: 0x88D3,
	22533 - 11905: 0x88D4,
	22534 - 11905: 0xB6D1,
	22535 - 11905: 0xDDC0,
	22536 - 11905: 0x88D5,
	22537 - 11905: 0x88D6,
	22538 - 11905: 0x88D7,
	22539 - 11905: 0xDCA1,
	22540 - 11905: 0x88D8,
	22541 - 11905: 0xDCA2,
	22542 - 11905: 0x88D9,
	22543 - 11905: 0x88DA,
	22544 - 11905: 0x88DB,
	22545 - 11905: 0xC7B5,
	22546 - 11905: 0x88DC,
	22547 - 11905: 0x88DD,
	22548 - 11905: 0x88DE,
	22549 - 11905: 0xB6E9,
	22550 - 11905: 0x88DF,
	22551 - 11905: 0x88E0,
	22552 - 11905: 0x88E1,
	22553 - 11905: 0xDCA7,
	22554 - 11905: 0x88E2,
	22555 - 11905: 0x88E3,
	22556 - 11905: 0x88E4,
	22557 - 11905: 0x88E5,
	22558 - 11905: 0xDCA6,
	22559 - 11905: 0x88E6,
	22560 - 11905: 0xDCA9,
	22561 - 11905: 0xB1A4,
	22562 - 11905: 0x88E7,
	22563 - 11905: 0x88E8,
	22564 - 11905: 0xB5CC,
	22565 - 11905: 0x88E9,
	22566 - 11905: 0x88EA,
	22567 - 11905: 0x88EB,
	22568 - 11905: 0x88EC,
	22569 - 11905: 0x88ED,
	22570 - 11905: 0xBFB0,
	22571 - 11905: 0x88EE,
	22572 - 11905: 0x88EF,
	22573 - 11905: 0x88F0,
	22574 - 11905: 0x88F1,
	22575 - 11905: 0x88F2,
	22576 - 11905: 0xD1DF,
	22577 - 11905: 0x88F3,
	22578 - 11905: 0x88F4,
	22579 - 11905: 0x88F5,
	22580 - 11905: 0x88F6,
	22581 - 11905: 0xB6C2,
	22582 - 11905: 0x88F7,
	22583 - 11905: 0x88F8,
	22584 - 11905: 0x88F9,
	22585 - 11905: 0x88FA,
	22586 - 11905: 0x88FB,
	22587 - 11905: 0x88FC,
	22588 - 11905: 0x88FD,
	22589 - 11905: 0x88FE,
	22590 - 11905: 0x8940,
	22591 - 11905: 0x8941,
	22592 - 11905: 0x8942,
	22593 - 11905: 0x8943,
	22594 - 11905: 0x8944,
	22595 - 11905: 0x8945,
	22596 - 11905: 0xDCA8,
	22597 - 11905: 0x8946,
	22598 - 11905: 0x8947,
	22599 - 11905: 0x8948,
	22600 - 11905: 0x8949,
	22601 - 11905: 0x894A,
	22602 - 11905: 0x894B,
	22603 - 11905: 0x894C,
	22604 - 11905: 0xCBFA,
	22605 - 11905: 0xEBF3,
	22606 - 11905: 0x894D,
	22607 - 11905: 0x894E,
	22608 - 11905: 0x894F,
	22609 - 11905: 0xCBDC,
	22610 - 11905: 0x8950,
	22611 - 11905: 0x8951,
	22612 - 11905: 0xCBFE,
	22613 - 11905: 0x8952,
	22614 - 11905: 0x8953,
	22615 - 11905: 0x8954,
	22616 - 11905: 0xCCC1,
	22617 - 11905: 0x8955,
	22618 - 11905: 0x8956,
	22619 - 11905: 0x8957,
	22620 - 11905: 0x8958,
	22621 - 11905: 0x8959,
	22622 - 11905: 0xC8FB,
	22623 - 11905: 0x895A,
	22624 - 11905: 0x895B,
	22625 - 11905: 0x895C,
	22626 - 11905: 0x895D,
	22627 - 11905: 0x895E,
	22628 - 11905: 0x895F,
	22629 - 11905: 0xDCAA,
	22630 - 11905: 0x8960,
	22631 - 11905: 0x8961,
	22632 - 11905: 0x8962,
	22633 - 11905: 0x8963,
	22634 - 11905: 0x8964,
	22635 - 11905: 0xCCEE,
	22636 - 11905: 0xDCAB,
	22637 - 11905: 0x8965,
	22638 - 11905: 0x8966,
	22639 - 11905: 0x8967,
	22640 - 11905: 0x8968,
	22641 - 11905: 0x8969,
	22642 - 11905: 0x896A,
	22643 - 11905: 0x896B,
	22644 - 11905: 0x896C,
	22645 - 11905: 0x896D,
	22646 - 11905: 0x896E,
	22647 - 11905: 0x896F,
	22648 - 11905: 0x8970,
	22649 - 11905: 0x8971,
	22650 - 11905: 0x8972,
	22651 - 11905: 0x8973,
	22652 - 11905: 0x8974,
	22653 - 11905: 0x8975,
	22654 - 11905: 0xDBD3,
	22655 - 11905: 0x8976,
	22656 - 11905: 0xDCAF,
	22657 - 11905: 0xDCAC,
	22658 - 11905: 0x8977,
	22659 - 11905: 0xBEB3,
	22660 - 11905: 0x8978,
	22661 - 11905: 0xCAFB,
	22662 - 11905: 0x8979,
	22663 - 11905: 0x897A,
	22664 - 11905: 0x897B,
	22665 - 11905: 0xDCAD,
	22666 - 11905: 0x897C,
	22667 - 11905: 0x897D,
	22668 - 11905: 0x897E,
	22669 - 11905: 0x8980,
	22670 - 11905: 0x8981,
	22671 - 11905: 0x8982,
	22672 - 11905: 0x8983,
	22673 - 11905: 0x8984,
	22674 - 11905: 0xC9CA,
	22675 - 11905: 0xC4B9,
	22676 - 11905: 0x8985,
	22677 - 11905: 0x8986,
	22678 - 11905: 0x8987,
	22679 - 11905: 0x8988,
	22680 - 11905: 0x8989,
	22681 - 11905: 0xC7BD,
	22682 - 11905: 0xDCAE,
	22683 - 11905: 0x898A,
	22684 - 11905: 0x898B,
	22685 - 11905: 0x898C,
	22686 - 11905: 0xD4F6,
	22687 - 11905: 0xD0E6,
	22688 - 11905: 0x898D,
	22689 - 11905: 0x898E,
	22690 - 11905: 0x898F,
	22691 - 11905: 0x8990,
	22692 - 11905: 0x8991,
	22693 - 11905: 0x8992,
	22694 - 11905: 0x8993,
	22695 - 11905: 0x8994,
	22696 - 11905: 0xC4AB,
	22697 - 11905: 0xB6D5,
	22698 - 11905: 0x8995,
	22699 - 11905: 0x8996,
	22700 - 11905: 0x8997,
	22701 - 11905: 0x8998,
	22702 - 11905: 0x8999,
	22703 - 11905: 0x899A,
	22704 - 11905: 0x899B,
	22705 - 11905: 0x899C,
	22706 - 11905: 0x899D,
	22707 - 11905: 0x899E,
	22708 - 11905: 0x899F,
	22709 - 11905: 0x89A0,
	22710 - 11905: 0x89A1,
	22711 - 11905: 0x89A2,
	22712 - 11905: 0x89A3,
	22713 - 11905: 0x89A4,
	22714 - 11905: 0x89A5,
	22715 - 11905: 0x89A6,
	22716 - 11905: 0xDBD4,
	22717 - 11905: 0x89A7,
	22718 - 11905: 0x89A8,
	22719 - 11905: 0x89A9,
	22720 - 11905: 0x89AA,
	22721 - 11905: 0xB1DA,
	22722 - 11905: 0x89AB,
	22723 - 11905: 0x89AC,
	22724 - 11905: 0x89AD,
	22725 - 11905: 0xDBD5,
	22726 - 11905: 0x89AE,
	22727 - 11905: 0x89AF,
	22728 - 11905: 0x89B0,
	22729 - 11905: 0x89B1,
	22730 - 11905: 0x89B2,
	22731 - 11905: 0x89B3,
	22732 - 11905: 0x89B4,
	22733 - 11905: 0x89B5,
	22734 - 11905: 0x89B6,
	22735 - 11905: 0x89B7,
	22736 - 11905: 0x89B8,
	22737 - 11905: 0xDBD6,
	22738 - 11905: 0x89B9,
	22739 - 11905: 0x89BA,
	22740 - 11905: 0x89BB,
	22741 - 11905: 0xBABE,
	22742 - 11905: 0x89BC,
	22743 - 11905: 0x89BD,
	22744 - 11905: 0x89BE,
	22745 - 11905: 0x89BF,
	22746 - 11905: 0x89C0,
	22747 - 11905: 0x89C1,
	22748 - 11905: 0x89C2,
	22749 - 11905: 0x89C3,
	22750 - 11905: 0x89C4,
	22751 - 11905: 0x89C5,
	22752 - 11905: 0x89C6,
	22753 - 11905: 0x89C7,
	22754 - 11905: 0x89C8,
	22755 - 11905: 0x89C9,
	22756 - 11905: 0xC8C0,
	22757 - 11905: 0x89CA,
	22758 - 11905: 0x89CB,
	22759 - 11905: 0x89CC,
	22760 - 11905: 0x89CD,
	22761 - 11905: 0x89CE,
	22762 - 11905: 0x89CF,
	22763 - 11905: 0xCABF,
	22764 - 11905: 0xC8C9,
	22765 - 11905: 0x89D0,
	22766 - 11905: 0xD7B3,
	22767 - 11905: 0x89D1,
	22768 - 11905: 0xC9F9,
	22769 - 11905: 0x89D2,
	22770 - 11905: 0x89D3,
	22771 - 11905: 0xBFC7,
	22772 - 11905: 0x89D4,
	22773 - 11905: 0x89D5,
	22774 - 11905: 0xBAF8,
	22775 - 11905: 0x89D6,
	22776 - 11905: 0x89D7,
	22777 - 11905: 0xD2BC,
	22778 - 11905: 0x89D8,
	22779 - 11905: 0x89D9,
	22780 - 11905: 0x89DA,
	22781 - 11905: 0x89DB,
	22782 - 11905: 0x89DC,
	22783 - 11905: 0x89DD,
	22784 - 11905: 0x89DE,
	22785 - 11905: 0x89DF,
	22786 - 11905: 0xE2BA,
	22787 - 11905: 0x89E0,
	22788 - 11905: 0xB4A6,
	22789 - 11905: 0x89E1,
	22790 - 11905: 0x89E2,
	22791 - 11905: 0xB1B8,
	22792 - 11905: 0x89E3,
	22793 - 11905: 0x89E4,
	22794 - 11905: 0x89E5,
	22795 - 11905: 0x89E6,
	22796 - 11905: 0x89E7,
	22797 - 11905: 0xB8B4,
	22798 - 11905: 0x89E8,
	22799 - 11905: 0xCFC4,
	22800 - 11905: 0x89E9,
	22801 - 11905: 0x89EA,
	22802 - 11905: 0x89EB,
	22803 - 11905: 0x89EC,
	22804 - 11905: 0xD9E7,
	22805 - 11905: 0xCFA6,
	22806 - 11905: 0xCDE2,
	22807 - 11905: 0x89ED,
	22808 - 11905: 0x89EE,
	22809 - 11905: 0xD9ED,
	22810 - 11905: 0xB6E0,
	22811 - 11905: 0x89EF,
	22812 - 11905: 0xD2B9,
	22813 - 11905: 0x89F0,
	22814 - 11905: 0x89F1,
	22815 - 11905: 0xB9BB,
	22816 - 11905: 0x89F2,
	22817 - 11905: 0x89F3,
	22818 - 11905: 0x89F4,
	22819 - 11905: 0x89F5,
	22820 - 11905: 0xE2B9,
	22821 - 11905: 0xE2B7,
	22822 - 11905: 0x89F6,
	22823 - 11905: 0xB4F3,
	22824 - 11905: 0x89F7,
	22825 - 11905: 0xCCEC,
	22826 - 11905: 0xCCAB,
	22827 - 11905: 0xB7F2,
	22828 - 11905: 0x89F8,
	22829 - 11905: 0xD8B2,
	22830 - 11905: 0xD1EB,
	22831 - 11905: 0xBABB,
	22832 - 11905: 0x89F9,
	22833 - 11905: 0xCAA7,
	22834 - 11905: 0x89FA,
	22835 - 11905: 0x89FB,
	22836 - 11905: 0xCDB7,
	22837 - 11905: 0x89FC,
	22838 - 11905: 0x89FD,
	22839 - 11905: 0xD2C4,
	22840 - 11905: 0xBFE4,
	22841 - 11905: 0xBCD0,
	22842 - 11905: 0xB6E1,
	22843 - 11905: 0x89FE,
	22844 - 11905: 0xDEC5,
	22845 - 11905: 0x8A40,
	22846 - 11905: 0x8A41,
	22847 - 11905: 0x8A42,
	22848 - 11905: 0x8A43,
	22849 - 11905: 0xDEC6,
	22850 - 11905: 0xDBBC,
	22851 - 11905: 0x8A44,
	22852 - 11905: 0xD1D9,
	22853 - 11905: 0x8A45,
	22854 - 11905: 0x8A46,
	22855 - 11905: 0xC6E6,
	22856 - 11905: 0xC4CE,
	22857 - 11905: 0xB7EE,
	22858 - 11905: 0x8A47,
	22859 - 11905: 0xB7DC,
	22860 - 11905: 0x8A48,
	22861 - 11905: 0x8A49,
	22862 - 11905: 0xBFFC,
	22863 - 11905: 0xD7E0,
	22864 - 11905: 0x8A4A,
	22865 - 11905: 0xC6F5,
	22866 - 11905: 0x8A4B,
	22867 - 11905: 0x8A4C,
	22868 - 11905: 0xB1BC,
	22869 - 11905: 0xDEC8,
	22870 - 11905: 0xBDB1,
	22871 - 11905: 0xCCD7,
	22872 - 11905: 0xDECA,
	22873 - 11905: 0x8A4D,
	22874 - 11905: 0xDEC9,
	22875 - 11905: 0x8A4E,
	22876 - 11905: 0x8A4F,
	22877 - 11905: 0x8A50,
	22878 - 11905: 0x8A51,
	22879 - 11905: 0x8A52,
	22880 - 11905: 0xB5EC,
	22881 - 11905: 0x8A53,
	22882 - 11905: 0xC9DD,
	22883 - 11905: 0x8A54,
	22884 - 11905: 0x8A55,
	22885 - 11905: 0xB0C2,
	22886 - 11905: 0x8A56,
	22887 - 11905: 0x8A57,
	22888 - 11905: 0x8A58,
	22889 - 11905: 0x8A59,
	22890 - 11905: 0x8A5A,
	22891 - 11905: 0x8A5B,
	22892 - 11905: 0x8A5C,
	22893 - 11905: 0x8A5D,
	22894 - 11905: 0x8A5E,
	22895 - 11905: 0x8A5F,
	22896 - 11905: 0x8A60,
	22897 - 11905: 0x8A61,
	22898 - 11905: 0x8A62,
	22899 - 11905: 0xC5AE,
	22900 - 11905: 0xC5AB,
	22901 - 11905: 0x8A63,
	22902 - 11905: 0xC4CC,
	22903 - 11905: 0x8A64,
	22904 - 11905: 0xBCE9,
	22905 - 11905: 0xCBFD,
	22906 - 11905: 0x8A65,
	22907 - 11905: 0x8A66,
	22908 - 11905: 0x8A67,
	22909 - 11905: 0xBAC3,
	22910 - 11905: 0x8A68,
	22911 - 11905: 0x8A69,
	22912 - 11905: 0x8A6A,
	22913 - 11905: 0xE5F9,
	22914 - 11905: 0xC8E7,
	22915 - 11905: 0xE5FA,
	22916 - 11905: 0xCDFD,
	22917 - 11905: 0x8A6B,
	22918 - 11905: 0xD7B1,
	22919 - 11905: 0xB8BE,
	22920 - 11905: 0xC2E8,
	22921 - 11905: 0x8A6C,
	22922 - 11905: 0xC8D1,
	22923 - 11905: 0x8A6D,
	22924 - 11905: 0x8A6E,
	22925 - 11905: 0xE5FB,
	22926 - 11905: 0x8A6F,
	22927 - 11905: 0x8A70,
	22928 - 11905: 0x8A71,
	22929 - 11905: 0x8A72,
	22930 - 11905: 0xB6CA,
	22931 - 11905: 0xBCCB,
	22932 - 11905: 0x8A73,
	22933 - 11905: 0x8A74,
	22934 - 11905: 0xD1FD,
	22935 - 11905: 0xE6A1,
	22936 - 11905: 0x8A75,
	22937 - 11905: 0xC3EE,
	22938 - 11905: 0x8A76,
	22939 - 11905: 0x8A77,
	22940 - 11905: 0x8A78,
	22941 - 11905: 0x8A79,
	22942 - 11905: 0xE6A4,
	22943 - 11905: 0x8A7A,
	22944 - 11905: 0x8A7B,
	22945 - 11905: 0x8A7C,
	22946 - 11905: 0x8A7D,
	22947 - 11905: 0xE5FE,
	22948 - 11905: 0xE6A5,
	22949 - 11905: 0xCDD7,
	22950 - 11905: 0x8A7E,
	22951 - 11905: 0x8A80,
	22952 - 11905: 0xB7C1,
	22953 - 11905: 0xE5FC,
	22954 - 11905: 0xE5FD,
	22955 - 11905: 0xE6A3,
	22956 - 11905: 0x8A81,
	22957 - 11905: 0x8A82,
	22958 - 11905: 0xC4DD,
	22959 - 11905: 0xE6A8,
	22960 - 11905: 0x8A83,
	22961 - 11905: 0x8A84,
	22962 - 11905: 0xE6A7,
	22963 - 11905: 0x8A85,
	22964 - 11905: 0x8A86,
	22965 - 11905: 0x8A87,
	22966 - 11905: 0x8A88,
	22967 - 11905: 0x8A89,
	22968 - 11905: 0x8A8A,
	22969 - 11905: 0xC3C3,
	22970 - 11905: 0x8A8B,
	22971 - 11905: 0xC6DE,
	22972 - 11905: 0x8A8C,
	22973 - 11905: 0x8A8D,
	22974 - 11905: 0xE6AA,
	22975 - 11905: 0x8A8E,
	22976 - 11905: 0x8A8F,
	22977 - 11905: 0x8A90,
	22978 - 11905: 0x8A91,
	22979 - 11905: 0x8A92,
	22980 - 11905: 0x8A93,
	22981 - 11905: 0x8A94,
	22982 - 11905: 0xC4B7,
	22983 - 11905: 0x8A95,
	22984 - 11905: 0x8A96,
	22985 - 11905: 0x8A97,
	22986 - 11905: 0xE6A2,
	22987 - 11905: 0xCABC,
	22988 - 11905: 0x8A98,
	22989 - 11905: 0x8A99,
	22990 - 11905: 0x8A9A,
	22991 - 11905: 0x8A9B,
	22992 - 11905: 0xBDE3,
	22993 - 11905: 0xB9C3,
	22994 - 11905: 0xE6A6,
	22995 - 11905: 0xD0D5,
	22996 - 11905: 0xCEAF,
	22997 - 11905: 0x8A9C,
	22998 - 11905: 0x8A9D,
	22999 - 11905: 0xE6A9,
	23000 - 11905: 0xE6B0,
	23001 - 11905: 0x8A9E,
	23002 - 11905: 0xD2A6,
	23003 - 11905: 0x8A9F,
	23004 - 11905: 0xBDAA,
	23005 - 11905: 0xE6AD,
	23006 - 11905: 0x8AA0,
	23007 - 11905: 0x8AA1,
	23008 - 11905: 0x8AA2,
	23009 - 11905: 0x8AA3,
	23010 - 11905: 0x8AA4,
	23011 - 11905: 0xE6AF,
	23012 - 11905: 0x8AA5,
	23013 - 11905: 0xC0D1,
	23014 - 11905: 0x8AA6,
	23015 - 11905: 0x8AA7,
	23016 - 11905: 0xD2CC,
	23017 - 11905: 0x8AA8,
	23018 - 11905: 0x8AA9,
	23019 - 11905: 0x8AAA,
	23020 - 11905: 0xBCA7,
	23021 - 11905: 0x8AAB,
	23022 - 11905: 0x8AAC,
	23023 - 11905: 0x8AAD,
	23024 - 11905: 0x8AAE,
	23025 - 11905: 0x8AAF,
	23026 - 11905: 0x8AB0,
	23027 - 11905: 0x8AB1,
	23028 - 11905: 0x8AB2,
	23029 - 11905: 0x8AB3,
	23030 - 11905: 0x8AB4,
	23031 - 11905: 0x8AB5,
	23032 - 11905: 0x8AB6,
	23033 - 11905: 0xE6B1,
	23034 - 11905: 0x8AB7,
	23035 - 11905: 0xD2F6,
	23036 - 11905: 0x8AB8,
	23037 - 11905: 0x8AB9,
	23038 - 11905: 0x8ABA,
	23039 - 11905: 0xD7CB,
	23040 - 11905: 0x8ABB,
	23041 - 11905: 0xCDFE,
	23042 - 11905: 0x8ABC,
	23043 - 11905: 0xCDDE,
	23044 - 11905: 0xC2A6,
	23045 - 11905: 0xE6AB,
	23046 - 11905: 0xE6AC,
	23047 - 11905: 0xBDBF,
	23048 - 11905: 0xE6AE,
	23049 - 11905: 0xE6B3,
	23050 - 11905: 0x8ABD,
	23051 - 11905: 0x8ABE,
	23052 - 11905: 0xE6B2,
	23053 - 11905: 0x8ABF,
	23054 - 11905: 0x8AC0,
	23055 - 11905: 0x8AC1,
	23056 - 11905: 0x8AC2,
	23057 - 11905: 0xE6B6,
	23058 - 11905: 0x8AC3,
	23059 - 11905: 0xE6B8,
	23060 - 11905: 0x8AC4,
	23061 - 11905: 0x8AC5,
	23062 - 11905: 0x8AC6,
	23063 - 11905: 0x8AC7,
	23064 - 11905: 0xC4EF,
	23065 - 11905: 0x8AC8,
	23066 - 11905: 0x8AC9,
	23067 - 11905: 0x8ACA,
	23068 - 11905: 0xC4C8,
	23069 - 11905: 0x8ACB,
	23070 - 11905: 0x8ACC,
	23071 - 11905: 0xBEEA,
	23072 - 11905: 0xC9EF,
	23073 - 11905: 0x8ACD,
	23074 - 11905: 0x8ACE,
	23075 - 11905: 0xE6B7,
	23076 - 11905: 0x8ACF,
	23077 - 11905: 0xB6F0,
	23078 - 11905: 0x8AD0,
	23079 - 11905: 0x8AD1,
	23080 - 11905: 0x8AD2,
	23081 - 11905: 0xC3E4,
	23082 - 11905: 0x8AD3,
	23083 - 11905: 0x8AD4,
	23084 - 11905: 0x8AD5,
	23085 - 11905: 0x8AD6,
	23086 - 11905: 0x8AD7,
	23087 - 11905: 0x8AD8,
	23088 - 11905: 0x8AD9,
	23089 - 11905: 0xD3E9,
	23090 - 11905: 0xE6B4,
	23091 - 11905: 0x8ADA,
	23092 - 11905: 0xE6B5,
	23093 - 11905: 0x8ADB,
	23094 - 11905: 0xC8A2,
	23095 - 11905: 0x8ADC,
	23096 - 11905: 0x8ADD,
	23097 - 11905: 0x8ADE,
	23098 - 11905: 0x8ADF,
	23099 - 11905: 0x8AE0,
	23100 - 11905: 0xE6BD,
	23101 - 11905: 0x8AE1,
	23102 - 11905: 0x8AE2,
	23103 - 11905: 0x8AE3,
	23104 - 11905: 0xE6B9,
	23105 - 11905: 0x8AE4,
	23106 - 11905: 0x8AE5,
	23107 - 11905: 0x8AE6,
	23108 - 11905: 0x8AE7,
	23109 - 11905: 0x8AE8,
	23110 - 11905: 0xC6C5,
	23111 - 11905: 0x8AE9,
	23112 - 11905: 0x8AEA,
	23113 - 11905: 0xCDF1,
	23114 - 11905: 0xE6BB,
	23115 - 11905: 0x8AEB,
	23116 - 11905: 0x8AEC,
	23117 - 11905: 0x8AED,
	23118 - 11905: 0x8AEE,
	23119 - 11905: 0x8AEF,
	23120 - 11905: 0x8AF0,
	23121 - 11905: 0x8AF1,
	23122 - 11905: 0x8AF2,
	23123 - 11905: 0x8AF3,
	23124 - 11905: 0x8AF4,
	23125 - 11905: 0xE6BC,
	23126 - 11905: 0x8AF5,
	23127 - 11905: 0x8AF6,
	23128 - 11905: 0x8AF7,
	23129 - 11905: 0x8AF8,
	23130 - 11905: 0xBBE9,
	23131 - 11905: 0x8AF9,
	23132 - 11905: 0x8AFA,
	23133 - 11905: 0x8AFB,
	23134 - 11905: 0x8AFC,
	23135 - 11905: 0x8AFD,
	23136 - 11905: 0x8AFE,
	23137 - 11905: 0x8B40,
	23138 - 11905: 0xE6BE,
	23139 - 11905: 0x8B41,
	23140 - 11905: 0x8B42,
	23141 - 11905: 0x8B43,
	23142 - 11905: 0x8B44,
	23143 - 11905: 0xE6BA,
	23144 - 11905: 0x8B45,
	23145 - 11905: 0x8B46,
	23146 - 11905: 0xC0B7,
	23147 - 11905: 0x8B47,
	23148 - 11905: 0x8B48,
	23149 - 11905: 0x8B49,
	23150 - 11905: 0x8B4A,
	23151 - 11905: 0x8B4B,
	23152 - 11905: 0x8B4C,
	23153 - 11905: 0x8B4D,
	23154 - 11905: 0x8B4E,
	23155 - 11905: 0x8B4F,
	23156 - 11905: 0xD3A4,
	23157 - 11905: 0xE6BF,
	23158 - 11905: 0xC9F4,
	23159 - 11905: 0xE6C3,
	23160 - 11905: 0x8B50,
	23161 - 11905: 0x8B51,
	23162 - 11905: 0xE6C4,
	23163 - 11905: 0x8B52,
	23164 - 11905: 0x8B53,
	23165 - 11905: 0x8B54,
	23166 - 11905: 0x8B55,
	23167 - 11905: 0xD0F6,
	23168 - 11905: 0x8B56,
	23169 - 11905: 0x8B57,
	23170 - 11905: 0x8B58,
	23171 - 11905: 0x8B59,
	23172 - 11905: 0x8B5A,
	23173 - 11905: 0x8B5B,
	23174 - 11905: 0x8B5C,
	23175 - 11905: 0x8B5D,
	23176 - 11905: 0x8B5E,
	23177 - 11905: 0x8B5F,
	23178 - 11905: 0x8B60,
	23179 - 11905: 0x8B61,
	23180 - 11905: 0x8B62,
	23181 - 11905: 0x8B63,
	23182 - 11905: 0x8B64,
	23183 - 11905: 0x8B65,
	23184 - 11905: 0x8B66,
	23185 - 11905: 0x8B67,
	23186 - 11905: 0xC3BD,
	23187 - 11905: 0x8B68,
	23188 - 11905: 0x8B69,
	23189 - 11905: 0x8B6A,
	23190 - 11905: 0x8B6B,
	23191 - 11905: 0x8B6C,
	23192 - 11905: 0x8B6D,
	23193 - 11905: 0x8B6E,
	23194 - 11905: 0xC3C4,
	23195 - 11905: 0xE6C2,
	23196 - 11905: 0x8B6F,
	23197 - 11905: 0x8B70,
	23198 - 11905: 0x8B71,
	23199 - 11905: 0x8B72,
	23200 - 11905: 0x8B73,
	23201 - 11905: 0x8B74,
	23202 - 11905: 0x8B75,
	23203 - 11905: 0x8B76,
	23204 - 11905: 0x8B77,
	23205 - 11905: 0x8B78,
	23206 - 11905: 0x8B79,
	23207 - 11905: 0x8B7A,
	23208 - 11905: 0x8B7B,
	23209 - 11905: 0x8B7C,
	23210 - 11905: 0xE6C1,
	23211 - 11905: 0x8B7D,
	23212 - 11905: 0x8B7E,
	23213 - 11905: 0x8B80,
	23214 - 11905: 0x8B81,
	23215 - 11905: 0x8B82,
	23216 - 11905: 0x8B83,
	23217 - 11905: 0x8B84,
	23218 - 11905: 0xE6C7,
	23219 - 11905: 0xCFB1,
	23220 - 11905: 0x8B85,
	23221 - 11905: 0xEBF4,
	23222 - 11905: 0x8B86,
	23223 - 11905: 0x8B87,
	23224 - 11905: 0xE6CA,
	23225 - 11905: 0x8B88,
	23226 - 11905: 0x8B89,
	23227 - 11905: 0x8B8A,
	23228 - 11905: 0x8B8B,
	23229 - 11905: 0x8B8C,
	23230 - 11905: 0xE6C5,
	23231 - 11905: 0x8B8D,
	23232 - 11905: 0x8B8E,
	23233 - 11905: 0xBCDE,
	23234 - 11905: 0xC9A9,
	23235 - 11905: 0x8B8F,
	23236 - 11905: 0x8B90,
	23237 - 11905: 0x8B91,
	23238 - 11905: 0x8B92,
	23239 - 11905: 0x8B93,
	23240 - 11905: 0x8B94,
	23241 - 11905: 0xBCB5,
	23242 - 11905: 0x8B95,
	23243 - 11905: 0x8B96,
	23244 - 11905: 0xCFD3,
	23245 - 11905: 0x8B97,
	23246 - 11905: 0x8B98,
	23247 - 11905: 0x8B99,
	23248 - 11905: 0x8B9A,
	23249 - 11905: 0x8B9B,
	23250 - 11905: 0xE6C8,
	23251 - 11905: 0x8B9C,
	23252 - 11905: 0xE6C9,
	23253 - 11905: 0x8B9D,
	23254 - 11905: 0xE6CE,
	23255 - 11905: 0x8B9E,
	23256 - 11905: 0xE6D0,
	23257 - 11905: 0x8B9F,
	23258 - 11905: 0x8BA0,
	23259 - 11905: 0x8BA1,
	23260 - 11905: 0xE6D1,
	23261 - 11905: 0x8BA2,
	23262 - 11905: 0x8BA3,
	23263 - 11905: 0x8BA4,
	23264 - 11905: 0xE6CB,
	23265 - 11905: 0xB5D5,
	23266 - 11905: 0x8BA5,
	23267 - 11905: 0xE6CC,
	23268 - 11905: 0x8BA6,
	23269 - 11905: 0x8BA7,
	23270 - 11905: 0xE6CF,
	23271 - 11905: 0x8BA8,
	23272 - 11905: 0x8BA9,
	23273 - 11905: 0xC4DB,
	23274 - 11905: 0x8BAA,
	23275 - 11905: 0xE6C6,
	23276 - 11905: 0x8BAB,
	23277 - 11905: 0x8BAC,
	23278 - 11905: 0x8BAD,
	23279 - 11905: 0x8BAE,
	23280 - 11905: 0x8BAF,
	23281 - 11905: 0xE6CD,
	23282 - 11905: 0x8BB0,
	23283 - 11905: 0x8BB1,
	23284 - 11905: 0x8BB2,
	23285 - 11905: 0x8BB3,
	23286 - 11905: 0x8BB4,
	23287 - 11905: 0x8BB5,
	23288 - 11905: 0x8BB6,
	23289 - 11905: 0x8BB7,
	23290 - 11905: 0x8BB8,
	23291 - 11905: 0x8BB9,
	23292 - 11905: 0x8BBA,
	23293 - 11905: 0x8BBB,
	23294 - 11905: 0x8BBC,
	23295 - 11905: 0x8BBD,
	23296 - 11905: 0x8BBE,
	23297 - 11905: 0x8BBF,
	23298 - 11905: 0x8BC0,
	23299 - 11905: 0x8BC1,
	23300 - 11905: 0x8BC2,
	23301 - 11905: 0x8BC3,
	23302 - 11905: 0x8BC4,
	23303 - 11905: 0x8BC5,
	23304 - 11905: 0x8BC6,
	23305 - 11905: 0xE6D2,
	23306 - 11905: 0x8BC7,
	23307 - 11905: 0x8BC8,
	23308 - 11905: 0x8BC9,
	23309 - 11905: 0x8BCA,
	23310 - 11905: 0x8BCB,
	23311 - 11905: 0x8BCC,
	23312 - 11905: 0x8BCD,
	23313 - 11905: 0x8BCE,
	23314 - 11905: 0x8BCF,
	23315 - 11905: 0x8BD0,
	23316 - 11905: 0x8BD1,
	23317 - 11905: 0x8BD2,
	23318 - 11905: 0xE6D4,
	23319 - 11905: 0xE6D3,
	23320 - 11905: 0x8BD3,
	23321 - 11905: 0x8BD4,
	23322 - 11905: 0x8BD5,
	23323 - 11905: 0x8BD6,
	23324 - 11905: 0x8BD7,
	23325 - 11905: 0x8BD8,
	23326 - 11905: 0x8BD9,
	23327 - 11905: 0x8BDA,
	23328 - 11905: 0x8BDB,
	23329 - 11905: 0x8BDC,
	23330 - 11905: 0x8BDD,
	23331 - 11905: 0x8BDE,
	23332 - 11905: 0x8BDF,
	23333 - 11905: 0x8BE0,
	23334 - 11905: 0x8BE1,
	23335 - 11905: 0x8BE2,
	23336 - 11905: 0x8BE3,
	23337 - 11905: 0x8BE4,
	23338 - 11905: 0x8BE5,
	23339 - 11905: 0x8BE6,
	23340 - 11905: 0x8BE7,
	23341 - 11905: 0x8BE8,
	23342 - 11905: 0x8BE9,
	23343 - 11905: 0x8BEA,
	23344 - 11905: 0x8BEB,
	23345 - 11905: 0x8BEC,
	23346 - 11905: 0xE6D5,
	23347 - 11905: 0x8BED,
	23348 - 11905: 0xD9F8,
	23349 - 11905: 0x8BEE,
	23350 - 11905: 0x8BEF,
	23351 - 11905: 0xE6D6,
	23352 - 11905: 0x8BF0,
	23353 - 11905: 0x8BF1,
	23354 - 11905: 0x8BF2,
	23355 - 11905: 0x8BF3,
	23356 - 11905: 0x8BF4,
	23357 - 11905: 0x8BF5,
	23358 - 11905: 0x8BF6,
	23359 - 11905: 0x8BF7,
	23360 - 11905: 0xE6D7,
	23361 - 11905: 0x8BF8,
	23362 - 11905: 0x8BF9,
	23363 - 11905: 0x8BFA,
	23364 - 11905: 0x8BFB,
	23365 - 11905: 0x8BFC,
	23366 - 11905: 0x8BFD,
	23367 - 11905: 0x8BFE,
	23368 - 11905: 0x8C40,
	23369 - 11905: 0x8C41,
	23370 - 11905: 0x8C42,
	23371 - 11905: 0x8C43,
	23372 - 11905: 0x8C44,
	23373 - 11905: 0x8C45,
	23374 - 11905: 0x8C46,
	23375 - 11905: 0x8C47,
	23376 - 11905: 0xD7D3,
	23377 - 11905: 0xE6DD,
	23378 - 11905: 0x8C48,
	23379 - 11905: 0xE6DE,
	23380 - 11905: 0xBFD7,
	23381 - 11905: 0xD4D0,
	23382 - 11905: 0x8C49,
	23383 - 11905: 0xD7D6,
	23384 - 11905: 0xB4E6,
	23385 - 11905: 0xCBEF,
	23386 - 11905: 0xE6DA,
	23387 - 11905: 0xD8C3,
	23388 - 11905: 0xD7CE,
	23389 - 11905: 0xD0A2,
	23390 - 11905: 0x8C4A,
	23391 - 11905: 0xC3CF,
	23392 - 11905: 0x8C4B,
	23393 - 11905: 0x8C4C,
	23394 - 11905: 0xE6DF,
	23395 - 11905: 0xBCBE,
	23396 - 11905: 0xB9C2,
	23397 - 11905: 0xE6DB,
	23398 - 11905: 0xD1A7,
	23399 - 11905: 0x8C4D,
	23400 - 11905: 0x8C4E,
	23401 - 11905: 0xBAA2,
	23402 - 11905: 0xC2CF,
	23403 - 11905: 0x8C4F,
	23404 - 11905: 0xD8AB,
	23405 - 11905: 0x8C50,
	23406 - 11905: 0x8C51,
	23407 - 11905: 0x8C52,
	23408 - 11905: 0xCAEB,
	23409 - 11905: 0xE5EE,
	23410 - 11905: 0x8C53,
	23411 - 11905: 0xE6DC,
	23412 - 11905: 0x8C54,
	23413 - 11905: 0xB7F5,
	23414 - 11905: 0x8C55,
	23415 - 11905: 0x8C56,
	23416 - 11905: 0x8C57,
	23417 - 11905: 0x8C58,
	23418 - 11905: 0xC8E6,
	23419 - 11905: 0x8C59,
	23420 - 11905: 0x8C5A,
	23421 - 11905: 0xC4F5,
	23422 - 11905: 0x8C5B,
	23423 - 11905: 0x8C5C,
	23424 - 11905: 0xE5B2,
	23425 - 11905: 0xC4FE,
	23426 - 11905: 0x8C5D,
	23427 - 11905: 0xCBFC,
	23428 - 11905: 0xE5B3,
	23429 - 11905: 0xD5AC,
	23430 - 11905: 0x8C5E,
	23431 - 11905: 0xD3EE,
	23432 - 11905: 0xCAD8,
	23433 - 11905: 0xB0B2,
	23434 - 11905: 0x8C5F,
	23435 - 11905: 0xCBCE,
	23436 - 11905: 0xCDEA,
	23437 - 11905: 0x8C60,
	23438 - 11905: 0x8C61,
	23439 - 11905: 0xBAEA,
	23440 - 11905: 0x8C62,
	23441 - 11905: 0x8C63,
	23442 - 11905: 0x8C64,
	23443 - 11905: 0xE5B5,
	23444 - 11905: 0x8C65,
	23445 - 11905: 0xE5B4,
	23446 - 11905: 0x8C66,
	23447 - 11905: 0xD7DA,
	23448 - 11905: 0xB9D9,
	23449 - 11905: 0xD6E6,
	23450 - 11905: 0xB6A8,
	23451 - 11905: 0xCDF0,
	23452 - 11905: 0xD2CB,
	23453 - 11905: 0xB1A6,
	23454 - 11905: 0xCAB5,
	23455 - 11905: 0x8C67,
	23456 - 11905: 0xB3E8,
	23457 - 11905: 0xC9F3,
	23458 - 11905: 0xBFCD,
	23459 - 11905: 0xD0FB,
	23460 - 11905: 0xCAD2,
	23461 - 11905: 0xE5B6,
	23462 - 11905: 0xBBC2,
	23463 - 11905: 0x8C68,
	23464 - 11905: 0x8C69,
	23465 - 11905: 0x8C6A,
	23466 - 11905: 0xCFDC,
	23467 - 11905: 0xB9AC,
	23468 - 11905: 0x8C6B,
	23469 - 11905: 0x8C6C,
	23470 - 11905: 0x8C6D,
	23471 - 11905: 0x8C6E,
	23472 - 11905: 0xD4D7,
	23473 - 11905: 0x8C6F,
	23474 - 11905: 0x8C70,
	23475 - 11905: 0xBAA6,
	23476 - 11905: 0xD1E7,
	23477 - 11905: 0xCFFC,
	23478 - 11905: 0xBCD2,
	23479 - 11905: 0x8C71,
	23480 - 11905: 0xE5B7,
	23481 - 11905: 0xC8DD,
	23482 - 11905: 0x8C72,
	23483 - 11905: 0x8C73,
	23484 - 11905: 0x8C74,
	23485 - 11905: 0xBFED,
	23486 - 11905: 0xB1F6,
	23487 - 11905: 0xCBDE,
	23488 - 11905: 0x8C75,
	23489 - 11905: 0x8C76,
	23490 - 11905: 0xBCC5,
	23491 - 11905: 0x8C77,
	23492 - 11905: 0xBCC4,
	23493 - 11905: 0xD2FA,
	23494 - 11905: 0xC3DC,
	23495 - 11905: 0xBFDC,
	23496 - 11905: 0x8C78,
	23497 - 11905: 0x8C79,
	23498 - 11905: 0x8C7A,
	23499 - 11905: 0x8C7B,
	23500 - 11905: 0xB8BB,
	23501 - 11905: 0x8C7C,
	23502 - 11905: 0x8C7D,
	23503 - 11905: 0x8C7E,
	23504 - 11905: 0xC3C2,
	23505 - 11905: 0x8C80,
	23506 - 11905: 0xBAAE,
	23507 - 11905: 0xD4A2,
	23508 - 11905: 0x8C81,
	23509 - 11905: 0x8C82,
	23510 - 11905: 0x8C83,
	23511 - 11905: 0x8C84,
	23512 - 11905: 0x8C85,
	23513 - 11905: 0x8C86,
	23514 - 11905: 0x8C87,
	23515 - 11905: 0x8C88,
	23516 - 11905: 0x8C89,
	23517 - 11905: 0xC7DE,
	23518 - 11905: 0xC4AF,
	23519 - 11905: 0xB2EC,
	23520 - 11905: 0x8C8A,
	23521 - 11905: 0xB9D1,
	23522 - 11905: 0x8C8B,
	23523 - 11905: 0x8C8C,
	23524 - 11905: 0xE5BB,
	23525 - 11905: 0xC1C8,
	23526 - 11905: 0x8C8D,
	23527 - 11905: 0x8C8E,
	23528 - 11905: 0xD5AF,
	23529 - 11905: 0x8C8F,
	23530 - 11905: 0x8C90,
	23531 - 11905: 0x8C91,
	23532 - 11905: 0x8C92,
	23533 - 11905: 0x8C93,
	23534 - 11905: 0xE5BC,
	23535 - 11905: 0x8C94,
	23536 - 11905: 0xE5BE,
	23537 - 11905: 0x8C95,
	23538 - 11905: 0x8C96,
	23539 - 11905: 0x8C97,
	23540 - 11905: 0x8C98,
	23541 - 11905: 0x8C99,
	23542 - 11905: 0x8C9A,
	23543 - 11905: 0x8C9B,
	23544 - 11905: 0xB4E7,
	23545 - 11905: 0xB6D4,
	23546 - 11905: 0xCBC2,
	23547 - 11905: 0xD1B0,
	23548 - 11905: 0xB5BC,
	23549 - 11905: 0x8C9C,
	23550 - 11905: 0x8C9D,
	23551 - 11905: 0xCAD9,
	23552 - 11905: 0x8C9E,
	23553 - 11905: 0xB7E2,
	23554 - 11905: 0x8C9F,
	23555 - 11905: 0x8CA0,
	23556 - 11905: 0xC9E4,
	23557 - 11905: 0x8CA1,
	23558 - 11905: 0xBDAB,
	23559 - 11905: 0x8CA2,
	23560 - 11905: 0x8CA3,
	23561 - 11905: 0xCEBE,
	23562 - 11905: 0xD7F0,
	23563 - 11905: 0x8CA4,
	23564 - 11905: 0x8CA5,
	23565 - 11905: 0x8CA6,
	23566 - 11905: 0x8CA7,
	23567 - 11905: 0xD0A1,
	23568 - 11905: 0x8CA8,
	23569 - 11905: 0xC9D9,
	23570 - 11905: 0x8CA9,
	23571 - 11905: 0x8CAA,
	23572 - 11905: 0xB6FB,
	23573 - 11905: 0xE6D8,
	23574 - 11905: 0xBCE2,
	23575 - 11905: 0x8CAB,
	23576 - 11905: 0xB3BE,
	23577 - 11905: 0x8CAC,
	23578 - 11905: 0xC9D0,
	23579 - 11905: 0x8CAD,
	23580 - 11905: 0xE6D9,
	23581 - 11905: 0xB3A2,
	23582 - 11905: 0x8CAE,
	23583 - 11905: 0x8CAF,
	23584 - 11905: 0x8CB0,
	23585 - 11905: 0x8CB1,
	23586 - 11905: 0xDECC,
	23587 - 11905: 0x8CB2,
	23588 - 11905: 0xD3C8,
	23589 - 11905: 0xDECD,
	23590 - 11905: 0x8CB3,
	23591 - 11905: 0xD2A2,
	23592 - 11905: 0x8CB4,
	23593 - 11905: 0x8CB5,
	23594 - 11905: 0x8CB6,
	23595 - 11905: 0x8CB7,
	23596 - 11905: 0xDECE,
	23597 - 11905: 0x8CB8,
	23598 - 11905: 0x8CB9,
	23599 - 11905: 0x8CBA,
	23600 - 11905: 0x8CBB,
	23601 - 11905: 0xBECD,
	23602 - 11905: 0x8CBC,
	23603 - 11905: 0x8CBD,
	23604 - 11905: 0xDECF,
	23605 - 11905: 0x8CBE,
	23606 - 11905: 0x8CBF,
	23607 - 11905: 0x8CC0,
	23608 - 11905: 0xCAAC,
	23609 - 11905: 0xD2FC,
	23610 - 11905: 0xB3DF,
	23611 - 11905: 0xE5EA,
	23612 - 11905: 0xC4E1,
	23613 - 11905: 0xBEA1,
	23614 - 11905: 0xCEB2,
	23615 - 11905: 0xC4F2,
	23616 - 11905: 0xBED6,
	23617 - 11905: 0xC6A8,
	23618 - 11905: 0xB2E3,
	23619 - 11905: 0x8CC1,
	23620 - 11905: 0x8CC2,
	23621 - 11905: 0xBED3,
	23622 - 11905: 0x8CC3,
	23623 - 11905: 0x8CC4,
	23624 - 11905: 0xC7FC,
	23625 - 11905: 0xCCEB,
	23626 - 11905: 0xBDEC,
	23627 - 11905: 0xCEDD,
	23628 - 11905: 0x8CC5,
	23629 - 11905: 0x8CC6,
	23630 - 11905: 0xCABA,
	23631 - 11905: 0xC6C1,
	23632 - 11905: 0xE5EC,
	23633 - 11905: 0xD0BC,
	23634 - 11905: 0x8CC7,
	23635 - 11905: 0x8CC8,
	23636 - 11905: 0x8CC9,
	23637 - 11905: 0xD5B9,
	23638 - 11905: 0x8CCA,
	23639 - 11905: 0x8CCB,
	23640 - 11905: 0x8CCC,
	23641 - 11905: 0xE5ED,
	23642 - 11905: 0x8CCD,
	23643 - 11905: 0x8CCE,
	23644 - 11905: 0x8CCF,
	23645 - 11905: 0x8CD0,
	23646 - 11905: 0xCAF4,
	23647 - 11905: 0x8CD1,
	23648 - 11905: 0xCDC0,
	23649 - 11905: 0xC2C5,
	23650 - 11905: 0x8CD2,
	23651 - 11905: 0xE5EF,
	23652 - 11905: 0x8CD3,
	23653 - 11905: 0xC2C4,
	23654 - 11905: 0xE5F0,
	23655 - 11905: 0x8CD4,
	23656 - 11905: 0x8CD5,
	23657 - 11905: 0x8CD6,
	23658 - 11905: 0x8CD7,
	23659 - 11905: 0x8CD8,
	23660 - 11905: 0x8CD9,
	23661 - 11905: 0x8CDA,
	23662 - 11905: 0xE5F8,
	23663 - 11905: 0xCDCD,
	23664 - 11905: 0x8CDB,
	23665 - 11905: 0xC9BD,
	23666 - 11905: 0x8CDC,
	23667 - 11905: 0x8CDD,
	23668 - 11905: 0x8CDE,
	23669 - 11905: 0x8CDF,
	23670 - 11905: 0x8CE0,
	23671 - 11905: 0x8CE1,
	23672 - 11905: 0x8CE2,
	23673 - 11905: 0xD2D9,
	23674 - 11905: 0xE1A8,
	23675 - 11905: 0x8CE3,
	23676 - 11905: 0x8CE4,
	23677 - 11905: 0x8CE5,
	23678 - 11905: 0x8CE6,
	23679 - 11905: 0xD3EC,
	23680 - 11905: 0x8CE7,
	23681 - 11905: 0xCBEA,
	23682 - 11905: 0xC6F1,
	23683 - 11905: 0x8CE8,
	23684 - 11905: 0x8CE9,
	23685 - 11905: 0x8CEA,
	23686 - 11905: 0x8CEB,
	23687 - 11905: 0x8CEC,
	23688 - 11905: 0xE1AC,
	23689 - 11905: 0x8CED,
	23690 - 11905: 0x8CEE,
	23691 - 11905: 0x8CEF,
	23692 - 11905: 0xE1A7,
	23693 - 11905: 0xE1A9,
	23694 - 11905: 0x8CF0,
	23695 - 11905: 0x8CF1,
	23696 - 11905: 0xE1AA,
	23697 - 11905: 0xE1AF,
	23698 - 11905: 0x8CF2,
	23699 - 11905: 0x8CF3,
	23700 - 11905: 0xB2ED,
	23701 - 11905: 0x8CF4,
	23702 - 11905: 0xE1AB,
	23703 - 11905: 0xB8DA,
	23704 - 11905: 0xE1AD,
	23705 - 11905: 0xE1AE,
	23706 - 11905: 0xE1B0,
	23707 - 11905: 0xB5BA,
	23708 - 11905: 0xE1B1,
	23709 - 11905: 0x8CF5,
	23710 - 11905: 0x8CF6,
	23711 - 11905: 0x8CF7,
	23712 - 11905: 0x8CF8,
	23713 - 11905: 0x8CF9,
	23714 - 11905: 0xE1B3,
	23715 - 11905: 0xE1B8,
	23716 - 11905: 0x8CFA,
	23717 - 11905: 0x8CFB,
	23718 - 11905: 0x8CFC,
	23719 - 11905: 0x8CFD,
	23720 - 11905: 0x8CFE,
	23721 - 11905: 0xD1D2,
	23722 - 11905: 0x8D40,
	23723 - 11905: 0xE1B6,
	23724 - 11905: 0xE1B5,
	23725 - 11905: 0xC1EB,
	23726 - 11905: 0x8D41,
	23727 - 11905: 0x8D42,
	23728 - 11905: 0x8D43,
	23729 - 11905: 0xE1B7,
	23730 - 11905: 0x8D44,
	23731 - 11905: 0xD4C0,
	23732 - 11905: 0x8D45,
	23733 - 11905: 0xE1B2,
	23734 - 11905: 0x8D46,
	23735 - 11905: 0xE1BA,
	23736 - 11905: 0xB0B6,
	23737 - 11905: 0x8D47,
	23738 - 11905: 0x8D48,
	23739 - 11905: 0x8D49,
	23740 - 11905: 0x8D4A,
	23741 - 11905: 0xE1B4,
	23742 - 11905: 0x8D4B,
	23743 - 11905: 0xBFF9,
	23744 - 11905: 0x8D4C,
	23745 - 11905: 0xE1B9,
	23746 - 11905: 0x8D4D,
	23747 - 11905: 0x8D4E,
	23748 - 11905: 0xE1BB,
	23749 - 11905: 0x8D4F,
	23750 - 11905: 0x8D50,
	23751 - 11905: 0x8D51,
	23752 - 11905: 0x8D52,
	23753 - 11905: 0x8D53,
	23754 - 11905: 0x8D54,
	23755 - 11905: 0xE1BE,
	23756 - 11905: 0x8D55,
	23757 - 11905: 0x8D56,
	23758 - 11905: 0x8D57,
	23759 - 11905: 0x8D58,
	23760 - 11905: 0x8D59,
	23761 - 11905: 0x8D5A,
	23762 - 11905: 0xE1BC,
	23763 - 11905: 0x8D5B,
	23764 - 11905: 0x8D5C,
	23765 - 11905: 0x8D5D,
	23766 - 11905: 0x8D5E,
	23767 - 11905: 0x8D5F,
	23768 - 11905: 0x8D60,
	23769 - 11905: 0xD6C5,
	23770 - 11905: 0x8D61,
	23771 - 11905: 0x8D62,
	23772 - 11905: 0x8D63,
	23773 - 11905: 0x8D64,
	23774 - 11905: 0x8D65,
	23775 - 11905: 0x8D66,
	23776 - 11905: 0x8D67,
	23777 - 11905: 0xCFBF,
	23778 - 11905: 0x8D68,
	23779 - 11905: 0x8D69,
	23780 - 11905: 0xE1BD,
	23781 - 11905: 0xE1BF,
	23782 - 11905: 0xC2CD,
	23783 - 11905: 0x8D6A,
	23784 - 11905: 0xB6EB,
	23785 - 11905: 0x8D6B,
	23786 - 11905: 0xD3F8,
	23787 - 11905: 0x8D6C,
	23788 - 11905: 0x8D6D,
	23789 - 11905: 0xC7CD,
	23790 - 11905: 0x8D6E,
	23791 - 11905: 0x8D6F,
	23792 - 11905: 0xB7E5,
	23793 - 11905: 0x8D70,
	23794 - 11905: 0x8D71,
	23795 - 11905: 0x8D72,
	23796 - 11905: 0x8D73,
	23797 - 11905: 0x8D74,
	23798 - 11905: 0x8D75,
	23799 - 11905: 0x8D76,
	23800 - 11905: 0x8D77,
	23801 - 11905: 0x8D78,
	23802 - 11905: 0x8D79,
	23803 - 11905: 0xBEFE,
	23804 - 11905: 0x8D7A,
	23805 - 11905: 0x8D7B,
	23806 - 11905: 0x8D7C,
	23807 - 11905: 0x8D7D,
	23808 - 11905: 0x8D7E,
	23809 - 11905: 0x8D80,
	23810 - 11905: 0xE1C0,
	23811 - 11905: 0xE1C1,
	23812 - 11905: 0x8D81,
	23813 - 11905: 0x8D82,
	23814 - 11905: 0xE1C7,
	23815 - 11905: 0xB3E7,
	23816 - 11905: 0x8D83,
	23817 - 11905: 0x8D84,
	23818 - 11905: 0x8D85,
	23819 - 11905: 0x8D86,
	23820 - 11905: 0x8D87,
	23821 - 11905: 0x8D88,
	23822 - 11905: 0xC6E9,
	23823 - 11905: 0x8D89,
	23824 - 11905: 0x8D8A,
	23825 - 11905: 0x8D8B,
	23826 - 11905: 0x8D8C,
	23827 - 11905: 0x8D8D,
	23828 - 11905: 0xB4DE,
	23829 - 11905: 0x8D8E,
	23830 - 11905: 0xD1C2,
	23831 - 11905: 0x8D8F,
	23832 - 11905: 0x8D90,
	23833 - 11905: 0x8D91,
	23834 - 11905: 0x8D92,
	23835 - 11905: 0xE1C8,
	23836 - 11905: 0x8D93,
	23837 - 11905: 0x8D94,
	23838 - 11905: 0xE1C6,
	23839 - 11905: 0x8D95,
	23840 - 11905: 0x8D96,
	23841 - 11905: 0x8D97,
	23842 - 11905: 0x8D98,
	23843 - 11905: 0x8D99,
	23844 - 11905: 0xE1C5,
	23845 - 11905: 0x8D9A,
	23846 - 11905: 0xE1C3,
	23847 - 11905: 0xE1C2,
	23848 - 11905: 0x8D9B,
	23849 - 11905: 0xB1C0,
	23850 - 11905: 0x8D9C,
	23851 - 11905: 0x8D9D,
	23852 - 11905: 0x8D9E,
	23853 - 11905: 0xD5B8,
	23854 - 11905: 0xE1C4,
	23855 - 11905: 0x8D9F,
	23856 - 11905: 0x8DA0,
	23857 - 11905: 0x8DA1,
	23858 - 11905: 0x8DA2,
	23859 - 11905: 0x8DA3,
	23860 - 11905: 0xE1CB,
	23861 - 11905: 0x8DA4,
	23862 - 11905: 0x8DA5,
	23863 - 11905: 0x8DA6,
	23864 - 11905: 0x8DA7,
	23865 - 11905: 0x8DA8,
	23866 - 11905: 0x8DA9,
	23867 - 11905: 0x8DAA,
	23868 - 11905: 0x8DAB,
	23869 - 11905: 0xE1CC,
	23870 - 11905: 0xE1CA,
	23871 - 11905: 0x8DAC,
	23872 - 11905: 0x8DAD,
	23873 - 11905: 0x8DAE,
	23874 - 11905: 0x8DAF,
	23875 - 11905: 0x8DB0,
	23876 - 11905: 0x8DB1,
	23877 - 11905: 0x8DB2,
	23878 - 11905: 0x8DB3,
	23879 - 11905: 0xEFFA,
	23880 - 11905: 0x8DB4,
	23881 - 11905: 0x8DB5,
	23882 - 11905: 0xE1D3,
	23883 - 11905: 0xE1D2,
	23884 - 11905: 0xC7B6,
	23885 - 11905: 0x8DB6,
	23886 - 11905: 0x8DB7,
	23887 - 11905: 0x8DB8,
	23888 - 11905: 0x8DB9,
	23889 - 11905: 0x8DBA,
	23890 - 11905: 0x8DBB,
	23891 - 11905: 0x8DBC,
	23892 - 11905: 0x8DBD,
	23893 - 11905: 0x8DBE,
	23894 - 11905: 0x8DBF,
	23895 - 11905: 0x8DC0,
	23896 - 11905: 0xE1C9,
	23897 - 11905: 0x8DC1,
	23898 - 11905: 0x8DC2,
	23899 - 11905: 0xE1CE,
	23900 - 11905: 0x8DC3,
	23901 - 11905: 0xE1D0,
	23902 - 11905: 0x8DC4,
	23903 - 11905: 0x8DC5,
	23904 - 11905: 0x8DC6,
	23905 - 11905: 0x8DC7,
	23906 - 11905: 0x8DC8,
	23907 - 11905: 0x8DC9,
	23908 - 11905: 0x8DCA,
	23909 - 11905: 0x8DCB,
	23910 - 11905: 0x8DCC,
	23911 - 11905: 0x8DCD,
	23912 - 11905: 0x8DCE,
	23913 - 11905: 0xE1D4,
	23914 - 11905: 0x8DCF,
	23915 - 11905: 0xE1D1,
	23916 - 11905: 0xE1CD,
	23917 - 11905: 0x8DD0,
	23918 - 11905: 0x8DD1,
	23919 - 11905: 0xE1CF,
	23920 - 11905: 0x8DD2,
	23921 - 11905: 0x8DD3,
	23922 - 11905: 0x8DD4,
	23923 - 11905: 0x8DD5,
	23924 - 11905: 0xE1D5,
	23925 - 11905: 0x8DD6,
	23926 - 11905: 0x8DD7,
	23927 - 11905: 0x8DD8,
	23928 - 11905: 0x8DD9,
	23929 - 11905: 0x8DDA,
	23930 - 11905: 0x8DDB,
	23931 - 11905: 0x8DDC,
	23932 - 11905: 0x8DDD,
	23933 - 11905: 0x8DDE,
	23934 - 11905: 0x8DDF,
	23935 - 11905: 0x8DE0,
	23936 - 11905: 0x8DE1,
	23937 - 11905: 0x8DE2,
	23938 - 11905: 0xE1D6,
	23939 - 11905: 0x8DE3,
	23940 - 11905: 0x8DE4,
	23941 - 11905: 0x8DE5,
	23942 - 11905: 0x8DE6,
	23943 - 11905: 0x8DE7,
	23944 - 11905: 0x8DE8,
	23945 - 11905: 0x8DE9,
	23946 - 11905: 0x8DEA,
	23947 - 11905: 0x8DEB,
	23948 - 11905: 0x8DEC,
	23949 - 11905: 0x8DED,
	23950 - 11905: 0x8DEE,
	23951 - 11905: 0x8DEF,
	23952 - 11905: 0x8DF0,
	23953 - 11905: 0x8DF1,
	23954 - 11905: 0x8DF2,
	23955 - 11905: 0x8DF3,
	23956 - 11905: 0x8DF4,
	23957 - 11905: 0x8DF5,
	23958 - 11905: 0x8DF6,
	23959 - 11905: 0x8DF7,
	23960 - 11905: 0x8DF8,
	23961 - 11905: 0xE1D7,
	23962 - 11905: 0x8DF9,
	23963 - 11905: 0x8DFA,
	23964 - 11905: 0x8DFB,
	23965 - 11905: 0xE1D8,
	23966 - 11905: 0x8DFC,
	23967 - 11905: 0x8DFD,
	23968 - 11905: 0x8DFE,
	23969 - 11905: 0x8E40,
	23970 - 11905: 0x8E41,
	23971 - 11905: 0x8E42,
	23972 - 11905: 0x8E43,
	23973 - 11905: 0x8E44,
	23974 - 11905: 0x8E45,
	23975 - 11905: 0x8E46,
	23976 - 11905: 0x8E47,
	23977 - 11905: 0x8E48,
	23978 - 11905: 0x8E49,
	23979 - 11905: 0x8E4A,
	23980 - 11905: 0x8E4B,
	23981 - 11905: 0x8E4C,
	23982 - 11905: 0x8E4D,
	23983 - 11905: 0x8E4E,
	23984 - 11905: 0x8E4F,
	23985 - 11905: 0x8E50,
	23986 - 11905: 0x8E51,
	23987 - 11905: 0x8E52,
	23988 - 11905: 0x8E53,
	23989 - 11905: 0x8E54,
	23990 - 11905: 0x8E55,
	23991 - 11905: 0xE1DA,
	23992 - 11905: 0x8E56,
	23993 - 11905: 0x8E57,
	23994 - 11905: 0x8E58,
	23995 - 11905: 0x8E59,
	23996 - 11905: 0x8E5A,
	23997 - 11905: 0x8E5B,
	23998 - 11905: 0x8E5C,
	23999 - 11905: 0x8E5D,
	24000 - 11905: 0x8E5E,
	24001 - 11905: 0x8E5F,
	24002 - 11905: 0x8E60,
	24003 - 11905: 0x8E61,
	24004 - 11905: 0x8E62,
	24005 - 11905: 0xE1DB,
	24006 - 11905: 0x8E63,
	24007 - 11905: 0x8E64,
	24008 - 11905: 0x8E65,
	24009 - 11905: 0x8E66,
	24010 - 11905: 0x8E67,
	24011 - 11905: 0x8E68,
	24012 - 11905: 0x8E69,
	24013 - 11905: 0xCEA1,
	24014 - 11905: 0x8E6A,
	24015 - 11905: 0x8E6B,
	24016 - 11905: 0x8E6C,
	24017 - 11905: 0x8E6D,
	24018 - 11905: 0x8E6E,
	24019 - 11905: 0x8E6F,
	24020 - 11905: 0x8E70,
	24021 - 11905: 0x8E71,
	24022 - 11905: 0x8E72,
	24023 - 11905: 0x8E73,
	24024 - 11905: 0x8E74,
	24025 - 11905: 0x8E75,
	24026 - 11905: 0x8E76,
	24027 - 11905: 0xE7DD,
	24028 - 11905: 0x8E77,
	24029 - 11905: 0xB4A8,
	24030 - 11905: 0xD6DD,
	24031 - 11905: 0x8E78,
	24032 - 11905: 0x8E79,
	24033 - 11905: 0xD1B2,
	24034 - 11905: 0xB3B2,
	24035 - 11905: 0x8E7A,
	24036 - 11905: 0x8E7B,
	24037 - 11905: 0xB9A4,
	24038 - 11905: 0xD7F3,
	24039 - 11905: 0xC7C9,
	24040 - 11905: 0xBEDE,
	24041 - 11905: 0xB9AE,
	24042 - 11905: 0x8E7C,
	24043 - 11905: 0xCED7,
	24044 - 11905: 0x8E7D,
	24045 - 11905: 0x8E7E,
	24046 - 11905: 0xB2EE,
	24047 - 11905: 0xDBCF,
	24048 - 11905: 0x8E80,
	24049 - 11905: 0xBCBA,
	24050 - 11905: 0xD2D1,
	24051 - 11905: 0xCBC8,
	24052 - 11905: 0xB0CD,
	24053 - 11905: 0x8E81,
	24054 - 11905: 0x8E82,
	24055 - 11905: 0xCFEF,
	24056 - 11905: 0x8E83,
	24057 - 11905: 0x8E84,
	24058 - 11905: 0x8E85,
	24059 - 11905: 0x8E86,
	24060 - 11905: 0x8E87,
	24061 - 11905: 0xD9E3,
	24062 - 11905: 0xBDED,
	24063 - 11905: 0x8E88,
	24064 - 11905: 0x8E89,
	24065 - 11905: 0xB1D2,
	24066 - 11905: 0xCAD0,
	24067 - 11905: 0xB2BC,
	24068 - 11905: 0x8E8A,
	24069 - 11905: 0xCBA7,
	24070 - 11905: 0xB7AB,
	24071 - 11905: 0x8E8B,
	24072 - 11905: 0xCAA6,
	24073 - 11905: 0x8E8C,
	24074 - 11905: 0x8E8D,
	24075 - 11905: 0x8E8E,
	24076 - 11905: 0xCFA3,
	24077 - 11905: 0x8E8F,
	24078 - 11905: 0x8E90,
	24079 - 11905: 0xE0F8,
	24080 - 11905: 0xD5CA,
	24081 - 11905: 0xE0FB,
	24082 - 11905: 0x8E91,
	24083 - 11905: 0x8E92,
	24084 - 11905: 0xE0FA,
	24085 - 11905: 0xC5C1,
	24086 - 11905: 0xCCFB,
	24087 - 11905: 0x8E93,
	24088 - 11905: 0xC1B1,
	24089 - 11905: 0xE0F9,
	24090 - 11905: 0xD6E3,
	24091 - 11905: 0xB2AF,
	24092 - 11905: 0xD6C4,
	24093 - 11905: 0xB5DB,
	24094 - 11905: 0x8E94,
	24095 - 11905: 0x8E95,
	24096 - 11905: 0x8E96,
	24097 - 11905: 0x8E97,
	24098 - 11905: 0x8E98,
	24099 - 11905: 0x8E99,
	24100 - 11905: 0x8E9A,
	24101 - 11905: 0x8E9B,
	24102 - 11905: 0xB4F8,
	24103 - 11905: 0xD6A1,
	24104 - 11905: 0x8E9C,
	24105 - 11905: 0x8E9D,
	24106 - 11905: 0x8E9E,
	24107 - 11905: 0x8E9F,
	24108 - 11905: 0x8EA0,
	24109 - 11905: 0xCFAF,
	24110 - 11905: 0xB0EF,
	24111 - 11905: 0x8EA1,
	24112 - 11905: 0x8EA2,
	24113 - 11905: 0xE0FC,
	24114 - 11905: 0x8EA3,
	24115 - 11905: 0x8EA4,
	24116 - 11905: 0x8EA5,
	24117 - 11905: 0x8EA6,
	24118 - 11905: 0x8EA7,
	24119 - 11905: 0xE1A1,
	24120 - 11905: 0xB3A3,
	24121 - 11905: 0x8EA8,
	24122 - 11905: 0x8EA9,
	24123 - 11905: 0xE0FD,
	24124 - 11905: 0xE0FE,
	24125 - 11905: 0xC3B1,
	24126 - 11905: 0x8EAA,
	24127 - 11905: 0x8EAB,
	24128 - 11905: 0x8EAC,
	24129 - 11905: 0x8EAD,
	24130 - 11905: 0xC3DD,
	24131 - 11905: 0x8EAE,
	24132 - 11905: 0xE1A2,
	24133 - 11905: 0xB7F9,
	24134 - 11905: 0x8EAF,
	24135 - 11905: 0x8EB0,
	24136 - 11905: 0x8EB1,
	24137 - 11905: 0x8EB2,
	24138 - 11905: 0x8EB3,
	24139 - 11905: 0x8EB4,
	24140 - 11905: 0xBBCF,
	24141 - 11905: 0x8EB5,
	24142 - 11905: 0x8EB6,
	24143 - 11905: 0x8EB7,
	24144 - 11905: 0x8EB8,
	24145 - 11905: 0x8EB9,
	24146 - 11905: 0x8EBA,
	24147 - 11905: 0x8EBB,
	24148 - 11905: 0xE1A3,
	24149 - 11905: 0xC4BB,
	24150 - 11905: 0x8EBC,
	24151 - 11905: 0x8EBD,
	24152 - 11905: 0x8EBE,
	24153 - 11905: 0x8EBF,
	24154 - 11905: 0x8EC0,
	24155 - 11905: 0xE1A4,
	24156 - 11905: 0x8EC1,
	24157 - 11905: 0x8EC2,
	24158 - 11905: 0xE1A5,
	24159 - 11905: 0x8EC3,
	24160 - 11905: 0x8EC4,
	24161 - 11905: 0xE1A6,
	24162 - 11905: 0xB4B1,
	24163 - 11905: 0x8EC5,
	24164 - 11905: 0x8EC6,
	24165 - 11905: 0x8EC7,
	24166 - 11905: 0x8EC8,
	24167 - 11905: 0x8EC9,
	24168 - 11905: 0x8ECA,
	24169 - 11905: 0x8ECB,
	24170 - 11905: 0x8ECC,
	24171 - 11905: 0x8ECD,
	24172 - 11905: 0x8ECE,
	24173 - 11905: 0x8ECF,
	24174 - 11905: 0x8ED0,
	24175 - 11905: 0x8ED1,
	24176 - 11905: 0x8ED2,
	24177 - 11905: 0x8ED3,
	24178 - 11905: 0xB8C9,
	24179 - 11905: 0xC6BD,
	24180 - 11905: 0xC4EA,
	24181 - 11905: 0x8ED4,
	24182 - 11905: 0xB2A2,
	24183 - 11905: 0x8ED5,
	24184 - 11905: 0xD0D2,
	24185 - 11905: 0x8ED6,
	24186 - 11905: 0xE7DB,
	24187 - 11905: 0xBBC3,
	24188 - 11905: 0xD3D7,
	24189 - 11905: 0xD3C4,
	24190 - 11905: 0x8ED7,
	24191 - 11905: 0xB9E3,
	24192 - 11905: 0xE2CF,
	24193 - 11905: 0x8ED8,
	24194 - 11905: 0x8ED9,
	24195 - 11905: 0x8EDA,
	24196 - 11905: 0xD7AF,
	24197 - 11905: 0x8EDB,
	24198 - 11905: 0xC7EC,
	24199 - 11905: 0xB1D3,
	24200 - 11905: 0x8EDC,
	24201 - 11905: 0x8EDD,
	24202 - 11905: 0xB4B2,
	24203 - 11905: 0xE2D1,
	24204 - 11905: 0x8EDE,
	24205 - 11905: 0x8EDF,
	24206 - 11905: 0x8EE0,
	24207 - 11905: 0xD0F2,
	24208 - 11905: 0xC2AE,
	24209 - 11905: 0xE2D0,
	24210 - 11905: 0x8EE1,
	24211 - 11905: 0xBFE2,
	24212 - 11905: 0xD3A6,
	24213 - 11905: 0xB5D7,
	24214 - 11905: 0xE2D2,
	24215 - 11905: 0xB5EA,
	24216 - 11905: 0x8EE2,
	24217 - 11905: 0xC3ED,
	24218 - 11905: 0xB8FD,
	24219 - 11905: 0x8EE3,
	24220 - 11905: 0xB8AE,
	24221 - 11905: 0x8EE4,
	24222 - 11905: 0xC5D3,
	24223 - 11905: 0xB7CF,
	24224 - 11905: 0xE2D4,
	24225 - 11905: 0x8EE5,
	24226 - 11905: 0x8EE6,
	24227 - 11905: 0x8EE7,
	24228 - 11905: 0x8EE8,
	24229 - 11905: 0xE2D3,
	24230 - 11905: 0xB6C8,
	24231 - 11905: 0xD7F9,
	24232 - 11905: 0x8EE9,
	24233 - 11905: 0x8EEA,
	24234 - 11905: 0x8EEB,
	24235 - 11905: 0x8EEC,
	24236 - 11905: 0x8EED,
	24237 - 11905: 0xCDA5,
	24238 - 11905: 0x8EEE,
	24239 - 11905: 0x8EEF,
	24240 - 11905: 0x8EF0,
	24241 - 11905: 0x8EF1,
	24242 - 11905: 0x8EF2,
	24243 - 11905: 0xE2D8,
	24244 - 11905: 0x8EF3,
	24245 - 11905: 0xE2D6,
	24246 - 11905: 0xCAFC,
	24247 - 11905: 0xBFB5,
	24248 - 11905: 0xD3B9,
	24249 - 11905: 0xE2D5,
	24250 - 11905: 0x8EF4,
	24251 - 11905: 0x8EF5,
	24252 - 11905: 0x8EF6,
	24253 - 11905: 0x8EF7,
	24254 - 11905: 0xE2D7,
	24255 - 11905: 0x8EF8,
	24256 - 11905: 0x8EF9,
	24257 - 11905: 0x8EFA,
	24258 - 11905: 0x8EFB,
	24259 - 11905: 0x8EFC,
	24260 - 11905: 0x8EFD,
	24261 - 11905: 0x8EFE,
	24262 - 11905: 0x8F40,
	24263 - 11905: 0x8F41,
	24264 - 11905: 0x8F42,
	24265 - 11905: 0xC1AE,
	24266 - 11905: 0xC0C8,
	24267 - 11905: 0x8F43,
	24268 - 11905: 0x8F44,
	24269 - 11905: 0x8F45,
	24270 - 11905: 0x8F46,
	24271 - 11905: 0x8F47,
	24272 - 11905: 0x8F48,
	24273 - 11905: 0xE2DB,
	24274 - 11905: 0xE2DA,
	24275 - 11905: 0xC0AA,
	24276 - 11905: 0x8F49,
	24277 - 11905: 0x8F4A,
	24278 - 11905: 0xC1CE,
	24279 - 11905: 0x8F4B,
	24280 - 11905: 0x8F4C,
	24281 - 11905: 0x8F4D,
	24282 - 11905: 0x8F4E,
	24283 - 11905: 0xE2DC,
	24284 - 11905: 0x8F4F,
	24285 - 11905: 0x8F50,
	24286 - 11905: 0x8F51,
	24287 - 11905: 0x8F52,
	24288 - 11905: 0x8F53,
	24289 - 11905: 0x8F54,
	24290 - 11905: 0x8F55,
	24291 - 11905: 0x8F56,
	24292 - 11905: 0x8F57,
	24293 - 11905: 0x8F58,
	24294 - 11905: 0x8F59,
	24295 - 11905: 0x8F5A,
	24296 - 11905: 0xE2DD,
	24297 - 11905: 0x8F5B,
	24298 - 11905: 0xE2DE,
	24299 - 11905: 0x8F5C,
	24300 - 11905: 0x8F5D,
	24301 - 11905: 0x8F5E,
	24302 - 11905: 0x8F5F,
	24303 - 11905: 0x8F60,
	24304 - 11905: 0x8F61,
	24305 - 11905: 0x8F62,
	24306 - 11905: 0x8F63,
	24307 - 11905: 0x8F64,
	24308 - 11905: 0xDBC8,
	24309 - 11905: 0x8F65,
	24310 - 11905: 0xD1D3,
	24311 - 11905: 0xCDA2,
	24312 - 11905: 0x8F66,
	24313 - 11905: 0x8F67,
	24314 - 11905: 0xBDA8,
	24315 - 11905: 0x8F68,
	24316 - 11905: 0x8F69,
	24317 - 11905: 0x8F6A,
	24318 - 11905: 0xDEC3,
	24319 - 11905: 0xD8A5,
	24320 - 11905: 0xBFAA,
	24321 - 11905: 0xDBCD,
	24322 - 11905: 0xD2EC,
	24323 - 11905: 0xC6FA,
	24324 - 11905: 0xC5AA,
	24325 - 11905: 0x8F6B,
	24326 - 11905: 0x8F6C,
	24327 - 11905: 0x8F6D,
	24328 - 11905: 0xDEC4,
	24329 - 11905: 0x8F6E,
	24330 - 11905: 0xB1D7,
	24331 - 11905: 0xDFAE,
	24332 - 11905: 0x8F6F,
	24333 - 11905: 0x8F70,
	24334 - 11905: 0x8F71,
	24335 - 11905: 0xCABD,
	24336 - 11905: 0x8F72,
	24337 - 11905: 0xDFB1,
	24338 - 11905: 0x8F73,
	24339 - 11905: 0xB9AD,
	24340 - 11905: 0x8F74,
	24341 - 11905: 0xD2FD,
	24342 - 11905: 0x8F75,
	24343 - 11905: 0xB8A5,
	24344 - 11905: 0xBAEB,
	24345 - 11905: 0x8F76,
	24346 - 11905: 0x8F77,
	24347 - 11905: 0xB3DA,
	24348 - 11905: 0x8F78,
	24349 - 11905: 0x8F79,
	24350 - 11905: 0x8F7A,
	24351 - 11905: 0xB5DC,
	24352 - 11905: 0xD5C5,
	24353 - 11905: 0x8F7B,
	24354 - 11905: 0x8F7C,
	24355 - 11905: 0x8F7D,
	24356 - 11905: 0x8F7E,
	24357 - 11905: 0xC3D6,
	24358 - 11905: 0xCFD2,
	24359 - 11905: 0xBBA1,
	24360 - 11905: 0x8F80,
	24361 - 11905: 0xE5F3,
	24362 - 11905: 0xE5F2,
	24363 - 11905: 0x8F81,
	24364 - 11905: 0x8F82,
	24365 - 11905: 0xE5F4,
	24366 - 11905: 0x8F83,
	24367 - 11905: 0xCDE4,
	24368 - 11905: 0x8F84,
	24369 - 11905: 0xC8F5,
	24370 - 11905: 0x8F85,
	24371 - 11905: 0x8F86,
	24372 - 11905: 0x8F87,
	24373 - 11905: 0x8F88,
	24374 - 11905: 0x8F89,
	24375 - 11905: 0x8F8A,
	24376 - 11905: 0x8F8B,
	24377 - 11905: 0xB5AF,
	24378 - 11905: 0xC7BF,
	24379 - 11905: 0x8F8C,
	24380 - 11905: 0xE5F6,
	24381 - 11905: 0x8F8D,
	24382 - 11905: 0x8F8E,
	24383 - 11905: 0x8F8F,
	24384 - 11905: 0xECB0,
	24385 - 11905: 0x8F90,
	24386 - 11905: 0x8F91,
	24387 - 11905: 0x8F92,
	24388 - 11905: 0x8F93,
	24389 - 11905: 0x8F94,
	24390 - 11905: 0x8F95,
	24391 - 11905: 0x8F96,
	24392 - 11905: 0x8F97,
	24393 - 11905: 0x8F98,
	24394 - 11905: 0x8F99,
	24395 - 11905: 0x8F9A,
	24396 - 11905: 0x8F9B,
	24397 - 11905: 0x8F9C,
	24398 - 11905: 0x8F9D,
	24399 - 11905: 0x8F9E,
	24400 - 11905: 0xE5E6,
	24401 - 11905: 0x8F9F,
	24402 - 11905: 0xB9E9,
	24403 - 11905: 0xB5B1,
	24404 - 11905: 0x8FA0,
	24405 - 11905: 0xC2BC,
	24406 - 11905: 0xE5E8,
	24407 - 11905: 0xE5E7,
	24408 - 11905: 0xE5E9,
	24409 - 11905: 0x8FA1,
	24410 - 11905: 0x8FA2,
	24411 - 11905: 0x8FA3,
	24412 - 11905: 0x8FA4,
	24413 - 11905: 0xD2CD,
	24414 - 11905: 0x8FA5,
	24415 - 11905: 0x8FA6,
	24416 - 11905: 0x8FA7,
	24417 - 11905: 0xE1EA,
	24418 - 11905: 0xD0CE,
	24419 - 11905: 0x8FA8,
	24420 - 11905: 0xCDAE,
	24421 - 11905: 0x8FA9,
	24422 - 11905: 0xD1E5,
	24423 - 11905: 0x8FAA,
	24424 - 11905: 0x8FAB,
	24425 - 11905: 0xB2CA,
	24426 - 11905: 0xB1EB,
	24427 - 11905: 0x8FAC,
	24428 - 11905: 0xB1F2,
	24429 - 11905: 0xC5ED,
	24430 - 11905: 0x8FAD,
	24431 - 11905: 0x8FAE,
	24432 - 11905: 0xD5C3,
	24433 - 11905: 0xD3B0,
	24434 - 11905: 0x8FAF,
	24435 - 11905: 0xE1DC,
	24436 - 11905: 0x8FB0,
	24437 - 11905: 0x8FB1,
	24438 - 11905: 0x8FB2,
	24439 - 11905: 0xE1DD,
	24440 - 11905: 0x8FB3,
	24441 - 11905: 0xD2DB,
	24442 - 11905: 0x8FB4,
	24443 - 11905: 0xB3B9,
	24444 - 11905: 0xB1CB,
	24445 - 11905: 0x8FB5,
	24446 - 11905: 0x8FB6,
	24447 - 11905: 0x8FB7,
	24448 - 11905: 0xCDF9,
	24449 - 11905: 0xD5F7,
	24450 - 11905: 0xE1DE,
	24451 - 11905: 0x8FB8,
	24452 - 11905: 0xBEB6,
	24453 - 11905: 0xB4FD,
	24454 - 11905: 0x8FB9,
	24455 - 11905: 0xE1DF,
	24456 - 11905: 0xBADC,
	24457 - 11905: 0xE1E0,
	24458 - 11905: 0xBBB2,
	24459 - 11905: 0xC2C9,
	24460 - 11905: 0xE1E1,
	24461 - 11905: 0x8FBA,
	24462 - 11905: 0x8FBB,
	24463 - 11905: 0x8FBC,
	24464 - 11905: 0xD0EC,
	24465 - 11905: 0x8FBD,
	24466 - 11905: 0xCDBD,
	24467 - 11905: 0x8FBE,
	24468 - 11905: 0x8FBF,
	24469 - 11905: 0xE1E2,
	24470 - 11905: 0x8FC0,
	24471 - 11905: 0xB5C3,
	24472 - 11905: 0xC5C7,
	24473 - 11905: 0xE1E3,
	24474 - 11905: 0x8FC1,
	24475 - 11905: 0x8FC2,
	24476 - 11905: 0xE1E4,
	24477 - 11905: 0x8FC3,
	24478 - 11905: 0x8FC4,
	24479 - 11905: 0x8FC5,
	24480 - 11905: 0x8FC6,
	24481 - 11905: 0xD3F9,
	24482 - 11905: 0x8FC7,
	24483 - 11905: 0x8FC8,
	24484 - 11905: 0x8FC9,
	24485 - 11905: 0x8FCA,
	24486 - 11905: 0x8FCB,
	24487 - 11905: 0x8FCC,
	24488 - 11905: 0xE1E5,
	24489 - 11905: 0x8FCD,
	24490 - 11905: 0xD1AD,
	24491 - 11905: 0x8FCE,
	24492 - 11905: 0x8FCF,
	24493 - 11905: 0xE1E6,
	24494 - 11905: 0xCEA2,
	24495 - 11905: 0x8FD0,
	24496 - 11905: 0x8FD1,
	24497 - 11905: 0x8FD2,
	24498 - 11905: 0x8FD3,
	24499 - 11905: 0x8FD4,
	24500 - 11905: 0x8FD5,
	24501 - 11905: 0xE1E7,
	24502 - 11905: 0x8FD6,
	24503 - 11905: 0xB5C2,
	24504 - 11905: 0x8FD7,
	24505 - 11905: 0x8FD8,
	24506 - 11905: 0x8FD9,
	24507 - 11905: 0x8FDA,
	24508 - 11905: 0xE1E8,
	24509 - 11905: 0xBBD5,
	24510 - 11905: 0x8FDB,
	24511 - 11905: 0x8FDC,
	24512 - 11905: 0x8FDD,
	24513 - 11905: 0x8FDE,
	24514 - 11905: 0x8FDF,
	24515 - 11905: 0xD0C4,
	24516 - 11905: 0xE2E0,
	24517 - 11905: 0xB1D8,
	24518 - 11905: 0xD2E4,
	24519 - 11905: 0x8FE0,
	24520 - 11905: 0x8FE1,
	24521 - 11905: 0xE2E1,
	24522 - 11905: 0x8FE2,
	24523 - 11905: 0x8FE3,
	24524 - 11905: 0xBCC9,
	24525 - 11905: 0xC8CC,
	24526 - 11905: 0x8FE4,
	24527 - 11905: 0xE2E3,
	24528 - 11905: 0xECFE,
	24529 - 11905: 0xECFD,
	24530 - 11905: 0xDFAF,
	24531 - 11905: 0x8FE5,
	24532 - 11905: 0x8FE6,
	24533 - 11905: 0x8FE7,
	24534 - 11905: 0xE2E2,
	24535 - 11905: 0xD6BE,
	24536 - 11905: 0xCDFC,
	24537 - 11905: 0xC3A6,
	24538 - 11905: 0x8FE8,
	24539 - 11905: 0x8FE9,
	24540 - 11905: 0x8FEA,
	24541 - 11905: 0xE3C3,
	24542 - 11905: 0x8FEB,
	24543 - 11905: 0x8FEC,
	24544 - 11905: 0xD6D2,
	24545 - 11905: 0xE2E7,
	24546 - 11905: 0x8FED,
	24547 - 11905: 0x8FEE,
	24548 - 11905: 0xE2E8,
	24549 - 11905: 0x8FEF,
	24550 - 11905: 0x8FF0,
	24551 - 11905: 0xD3C7,
	24552 - 11905: 0x8FF1,
	24553 - 11905: 0x8FF2,
	24554 - 11905: 0xE2EC,
	24555 - 11905: 0xBFEC,
	24556 - 11905: 0x8FF3,
	24557 - 11905: 0xE2ED,
	24558 - 11905: 0xE2E5,
	24559 - 11905: 0x8FF4,
	24560 - 11905: 0x8FF5,
	24561 - 11905: 0xB3C0,
	24562 - 11905: 0x8FF6,
	24563 - 11905: 0x8FF7,
	24564 - 11905: 0x8FF8,
	24565 - 11905: 0xC4EE,
	24566 - 11905: 0x8FF9,
	24567 - 11905: 0x8FFA,
	24568 - 11905: 0xE2EE,
	24569 - 11905: 0x8FFB,
	24570 - 11905: 0x8FFC,
	24571 - 11905: 0xD0C3,
	24572 - 11905: 0x8FFD,
	24573 - 11905: 0xBAF6,
	24574 - 11905: 0xE2E9,
	24575 - 11905: 0xB7DE,
	24576 - 11905: 0xBBB3,
	24577 - 11905: 0xCCAC,
	24578 - 11905: 0xCBCB,
	24579 - 11905: 0xE2E4,
	24580 - 11905: 0xE2E6,
	24581 - 11905: 0xE2EA,
	24582 - 11905: 0xE2EB,
	24583 - 11905: 0x8FFE,
	24584 - 11905: 0x9040,
	24585 - 11905: 0x9041,
	24586 - 11905: 0xE2F7,
	24587 - 11905: 0x9042,
	24588 - 11905: 0x9043,
	24589 - 11905: 0xE2F4,
	24590 - 11905: 0xD4F5,
	24591 - 11905: 0xE2F3,
	24592 - 11905: 0x9044,
	24593 - 11905: 0x9045,
	24594 - 11905: 0xC5AD,
	24595 - 11905: 0x9046,
	24596 - 11905: 0xD5FA,
	24597 - 11905: 0xC5C2,
	24598 - 11905: 0xB2C0,
	24599 - 11905: 0x9047,
	24600 - 11905: 0x9048,
	24601 - 11905: 0xE2EF,
	24602 - 11905: 0x9049,
	24603 - 11905: 0xE2F2,
	24604 - 11905: 0xC1AF,
	24605 - 11905: 0xCBBC,
	24606 - 11905: 0x904A,
	24607 - 11905: 0x904B,
	24608 - 11905: 0xB5A1,
	24609 - 11905: 0xE2F9,
	24610 - 11905: 0x904C,
	24611 - 11905: 0x904D,
	24612 - 11905: 0x904E,
	24613 - 11905: 0xBCB1,
	24614 - 11905: 0xE2F1,
	24615 - 11905: 0xD0D4,
	24616 - 11905: 0xD4B9,
	24617 - 11905: 0xE2F5,
	24618 - 11905: 0xB9D6,
	24619 - 11905: 0xE2F6,
	24620 - 11905: 0x904F,
	24621 - 11905: 0x9050,
	24622 - 11905: 0x9051,
	24623 - 11905: 0xC7D3,
	24624 - 11905: 0x9052,
	24625 - 11905: 0x9053,
	24626 - 11905: 0x9054,
	24627 - 11905: 0x9055,
	24628 - 11905: 0x9056,
	24629 - 11905: 0xE2F0,
	24630 - 11905: 0x9057,
	24631 - 11905: 0x9058,
	24632 - 11905: 0x9059,
	24633 - 11905: 0x905A,
	24634 - 11905: 0x905B,
	24635 - 11905: 0xD7DC,
	24636 - 11905: 0xEDA1,
	24637 - 11905: 0x905C,
	24638 - 11905: 0x905D,
	24639 - 11905: 0xE2F8,
	24640 - 11905: 0x905E,
	24641 - 11905: 0xEDA5,
	24642 - 11905: 0xE2FE,
	24643 - 11905: 0xCAD1,
	24644 - 11905: 0x905F,
	24645 - 11905: 0x9060,
	24646 - 11905: 0x9061,
	24647 - 11905: 0x9062,
	24648 - 11905: 0x9063,
	24649 - 11905: 0x9064,
	24650 - 11905: 0x9065,
	24651 - 11905: 0xC1B5,
	24652 - 11905: 0x9066,
	24653 - 11905: 0xBBD0,
	24654 - 11905: 0x9067,
	24655 - 11905: 0x9068,
	24656 - 11905: 0xBFD6,
	24657 - 11905: 0x9069,
	24658 - 11905: 0xBAE3,
	24659 - 11905: 0x906A,
	24660 - 11905: 0x906B,
	24661 - 11905: 0xCBA1,
	24662 - 11905: 0x906C,
	24663 - 11905: 0x906D,
	24664 - 11905: 0x906E,
	24665 - 11905: 0xEDA6,
	24666 - 11905: 0xEDA3,
	24667 - 11905: 0x906F,
	24668 - 11905: 0x9070,
	24669 - 11905: 0xEDA2,
	24670 - 11905: 0x9071,
	24671 - 11905: 0x9072,
	24672 - 11905: 0x9073,
	24673 - 11905: 0x9074,
	24674 - 11905: 0xBBD6,
	24675 - 11905: 0xEDA7,
	24676 - 11905: 0xD0F4,
	24677 - 11905: 0x9075,
	24678 - 11905: 0x9076,
	24679 - 11905: 0xEDA4,
	24680 - 11905: 0xBADE,
	24681 - 11905: 0xB6F7,
	24682 - 11905: 0xE3A1,
	24683 - 11905: 0xB6B2,
	24684 - 11905: 0xCCF1,
	24685 - 11905: 0xB9A7,
	24686 - 11905: 0x9077,
	24687 - 11905: 0xCFA2,
	24688 - 11905: 0xC7A1,
	24689 - 11905: 0x9078,
	24690 - 11905: 0x9079,
	24691 - 11905: 0xBFD2,
	24692 - 11905: 0x907A,
	24693 - 11905: 0x907B,
	24694 - 11905: 0xB6F1,
	24695 - 11905: 0x907C,
	24696 - 11905: 0xE2FA,
	24697 - 11905: 0xE2FB,
	24698 - 11905: 0xE2FD,
	24699 - 11905: 0xE2FC,
	24700 - 11905: 0xC4D5,
	24701 - 11905: 0xE3A2,
	24702 - 11905: 0x907D,
	24703 - 11905: 0xD3C1,
	24704 - 11905: 0x907E,
	24705 - 11905: 0x9080,
	24706 - 11905: 0x9081,
	24707 - 11905: 0xE3A7,
	24708 - 11905: 0xC7C4,
	24709 - 11905: 0x9082,
	24710 - 11905: 0x9083,
	24711 - 11905: 0x9084,
	24712 - 11905: 0x9085,
	24713 - 11905: 0xCFA4,
	24714 - 11905: 0x9086,
	24715 - 11905: 0x9087,
	24716 - 11905: 0xE3A9,
	24717 - 11905: 0xBAB7,
	24718 - 11905: 0x9088,
	24719 - 11905: 0x9089,
	24720 - 11905: 0x908A,
	24721 - 11905: 0x908B,
	24722 - 11905: 0xE3A8,
	24723 - 11905: 0x908C,
	24724 - 11905: 0xBBDA,
	24725 - 11905: 0x908D,
	24726 - 11905: 0xE3A3,
	24727 - 11905: 0x908E,
	24728 - 11905: 0x908F,
	24729 - 11905: 0x9090,
	24730 - 11905: 0xE3A4,
	24731 - 11905: 0xE3AA,
	24732 - 11905: 0x9091,
	24733 - 11905: 0xE3A6,
	24734 - 11905: 0x9092,
	24735 - 11905: 0xCEF2,
	24736 - 11905: 0xD3C6,
	24737 - 11905: 0x9093,
	24738 - 11905: 0x9094,
	24739 - 11905: 0xBBBC,
	24740 - 11905: 0x9095,
	24741 - 11905: 0x9096,
	24742 - 11905: 0xD4C3,
	24743 - 11905: 0x9097,
	24744 - 11905: 0xC4FA,
	24745 - 11905: 0x9098,
	24746 - 11905: 0x9099,
	24747 - 11905: 0xEDA8,
	24748 - 11905: 0xD0FC,
	24749 - 11905: 0xE3A5,
	24750 - 11905: 0x909A,
	24751 - 11905: 0xC3F5,
	24752 - 11905: 0x909B,
	24753 - 11905: 0xE3AD,
	24754 - 11905: 0xB1AF,
	24755 - 11905: 0x909C,
	24756 - 11905: 0xE3B2,
	24757 - 11905: 0x909D,
	24758 - 11905: 0x909E,
	24759 - 11905: 0x909F,
	24760 - 11905: 0xBCC2,
	24761 - 11905: 0x90A0,
	24762 - 11905: 0x90A1,
	24763 - 11905: 0xE3AC,
	24764 - 11905: 0xB5BF,
	24765 - 11905: 0x90A2,
	24766 - 11905: 0x90A3,
	24767 - 11905: 0x90A4,
	24768 - 11905: 0x90A5,
	24769 - 11905: 0x90A6,
	24770 - 11905: 0x90A7,
	24771 - 11905: 0x90A8,
	24772 - 11905: 0x90A9,
	24773 - 11905: 0xC7E9,
	24774 - 11905: 0xE3B0,
	24775 - 11905: 0x90AA,
	24776 - 11905: 0x90AB,
	24777 - 11905: 0x90AC,
	24778 - 11905: 0xBEAA,
	24779 - 11905: 0xCDEF,
	24780 - 11905: 0x90AD,
	24781 - 11905: 0x90AE,
	24782 - 11905: 0x90AF,
	24783 - 11905: 0x90B0,
	24784 - 11905: 0x90B1,
	24785 - 11905: 0xBBF3,
	24786 - 11905: 0x90B2,
	24787 - 11905: 0x90B3,
	24788 - 11905: 0x90B4,
	24789 - 11905: 0xCCE8,
	24790 - 11905: 0x90B5,
	24791 - 11905: 0x90B6,
	24792 - 11905: 0xE3AF,
	24793 - 11905: 0x90B7,
	24794 - 11905: 0xE3B1,
	24795 - 11905: 0x90B8,
	24796 - 11905: 0xCFA7,
	24797 - 11905: 0xE3AE,
	24798 - 11905: 0x90B9,
	24799 - 11905: 0xCEA9,
	24800 - 11905: 0xBBDD,
	24801 - 11905: 0x90BA,
	24802 - 11905: 0x90BB,
	24803 - 11905: 0x90BC,
	24804 - 11905: 0x90BD,
	24805 - 11905: 0x90BE,
	24806 - 11905: 0xB5EB,
	24807 - 11905: 0xBEE5,
	24808 - 11905: 0xB2D2,
	24809 - 11905: 0xB3CD,
	24810 - 11905: 0x90BF,
	24811 - 11905: 0xB1B9,
	24812 - 11905: 0xE3AB,
	24813 - 11905: 0xB2D1,
	24814 - 11905: 0xB5AC,
	24815 - 11905: 0xB9DF,
	24816 - 11905: 0xB6E8,
	24817 - 11905: 0x90C0,
	24818 - 11905: 0x90C1,
	24819 - 11905: 0xCFEB,
	24820 - 11905: 0xE3B7,
	24821 - 11905: 0x90C2,
	24822 - 11905: 0xBBCC,
	24823 - 11905: 0x90C3,
	24824 - 11905: 0x90C4,
	24825 - 11905: 0xC8C7,
	24826 - 11905: 0xD0CA,
	24827 - 11905: 0x90C5,
	24828 - 11905: 0x90C6,
	24829 - 11905: 0x90C7,
	24830 - 11905: 0x90C8,
	24831 - 11905: 0x90C9,
	24832 - 11905: 0xE3B8,
	24833 - 11905: 0xB3EE,
	24834 - 11905: 0x90CA,
	24835 - 11905: 0x90CB,
	24836 - 11905: 0x90CC,
	24837 - 11905: 0x90CD,
	24838 - 11905: 0xEDA9,
	24839 - 11905: 0x90CE,
	24840 - 11905: 0xD3FA,
	24841 - 11905: 0xD3E4,
	24842 - 11905: 0x90CF,
	24843 - 11905: 0x90D0,
	24844 - 11905: 0x90D1,
	24845 - 11905: 0xEDAA,
	24846 - 11905: 0xE3B9,
	24847 - 11905: 0xD2E2,
	24848 - 11905: 0x90D2,
	24849 - 11905: 0x90D3,
	24850 - 11905: 0x90D4,
	24851 - 11905: 0x90D5,
	24852 - 11905: 0x90D6,
	24853 - 11905: 0xE3B5,
	24854 - 11905: 0x90D7,
	24855 - 11905: 0x90D8,
	24856 - 11905: 0x90D9,
	24857 - 11905: 0x90DA,
	24858 - 11905: 0xD3DE,
	24859 - 11905: 0x90DB,
	24860 - 11905: 0x90DC,
	24861 - 11905: 0x90DD,
	24862 - 11905: 0x90DE,
	24863 - 11905: 0xB8D0,
	24864 - 11905: 0xE3B3,
	24865 - 11905: 0x90DF,
	24866 - 11905: 0x90E0,
	24867 - 11905: 0xE3B6,
	24868 - 11905: 0xB7DF,
	24869 - 11905: 0x90E1,
	24870 - 11905: 0xE3B4,
	24871 - 11905: 0xC0A2,
	24872 - 11905: 0x90E2,
	24873 - 11905: 0x90E3,
	24874 - 11905: 0x90E4,
	24875 - 11905: 0xE3BA,
	24876 - 11905: 0x90E5,
	24877 - 11905: 0x90E6,
	24878 - 11905: 0x90E7,
	24879 - 11905: 0x90E8,
	24880 - 11905: 0x90E9,
	24881 - 11905: 0x90EA,
	24882 - 11905: 0x90EB,
	24883 - 11905: 0x90EC,
	24884 - 11905: 0x90ED,
	24885 - 11905: 0x90EE,
	24886 - 11905: 0x90EF,
	24887 - 11905: 0x90F0,
	24888 - 11905: 0x90F1,
	24889 - 11905: 0x90F2,
	24890 - 11905: 0x90F3,
	24891 - 11905: 0x90F4,
	24892 - 11905: 0x90F5,
	24893 - 11905: 0x90F6,
	24894 - 11905: 0x90F7,
	24895 - 11905: 0xD4B8,
	24896 - 11905: 0x90F8,
	24897 - 11905: 0x90F9,
	24898 - 11905: 0x90FA,
	24899 - 11905: 0x90FB,
	24900 - 11905: 0x90FC,
	24901 - 11905: 0x90FD,
	24902 - 11905: 0x90FE,
	24903 - 11905: 0x9140,
	24904 - 11905: 0xB4C8,
	24905 - 11905: 0x9141,
	24906 - 11905: 0xE3BB,
	24907 - 11905: 0x9142,
	24908 - 11905: 0xBBC5,
	24909 - 11905: 0x9143,
	24910 - 11905: 0xC9F7,
	24911 - 11905: 0x9144,
	24912 - 11905: 0x9145,
	24913 - 11905: 0xC9E5,
	24914 - 11905: 0x9146,
	24915 - 11905: 0x9147,
	24916 - 11905: 0x9148,
	24917 - 11905: 0xC4BD,
	24918 - 11905: 0x9149,
	24919 - 11905: 0x914A,
	24920 - 11905: 0x914B,
	24921 - 11905: 0x914C,
	24922 - 11905: 0x914D,
	24923 - 11905: 0x914E,
	24924 - 11905: 0x914F,
	24925 - 11905: 0xEDAB,
	24926 - 11905: 0x9150,
	24927 - 11905: 0x9151,
	24928 - 11905: 0x9152,
	24929 - 11905: 0x9153,
	24930 - 11905: 0xC2FD,
	24931 - 11905: 0x9154,
	24932 - 11905: 0x9155,
	24933 - 11905: 0x9156,
	24934 - 11905: 0x9157,
	24935 - 11905: 0xBBDB,
	24936 - 11905: 0xBFAE,
	24937 - 11905: 0x9158,
	24938 - 11905: 0x9159,
	24939 - 11905: 0x915A,
	24940 - 11905: 0x915B,
	24941 - 11905: 0x915C,
	24942 - 11905: 0x915D,
	24943 - 11905: 0x915E,
	24944 - 11905: 0xCEBF,
	24945 - 11905: 0x915F,
	24946 - 11905: 0x9160,
	24947 - 11905: 0x9161,
	24948 - 11905: 0x9162,
	24949 - 11905: 0xE3BC,
	24950 - 11905: 0x9163,
	24951 - 11905: 0xBFB6,
	24952 - 11905: 0x9164,
	24953 - 11905: 0x9165,
	24954 - 11905: 0x9166,
	24955 - 11905: 0x9167,
	24956 - 11905: 0x9168,
	24957 - 11905: 0x9169,
	24958 - 11905: 0x916A,
	24959 - 11905: 0x916B,
	24960 - 11905: 0x916C,
	24961 - 11905: 0x916D,
	24962 - 11905: 0x916E,
	24963 - 11905: 0x916F,
	24964 - 11905: 0x9170,
	24965 - 11905: 0x9171,
	24966 - 11905: 0x9172,
	24967 - 11905: 0x9173,
	24968 - 11905: 0x9174,
	24969 - 11905: 0x9175,
	24970 - 11905: 0x9176,
	24971 - 11905: 0xB1EF,
	24972 - 11905: 0x9177,
	24973 - 11905: 0x9178,
	24974 - 11905: 0xD4F7,
	24975 - 11905: 0x9179,
	24976 - 11905: 0x917A,
	24977 - 11905: 0x917B,
	24978 - 11905: 0x917C,
	24979 - 11905: 0x917D,
	24980 - 11905: 0xE3BE,
	24981 - 11905: 0x917E,
	24982 - 11905: 0x9180,
	24983 - 11905: 0x9181,
	24984 - 11905: 0x9182,
	24985 - 11905: 0x9183,
	24986 - 11905: 0x9184,
	24987 - 11905: 0x9185,
	24988 - 11905: 0x9186,
	24989 - 11905: 0xEDAD,
	24990 - 11905: 0x9187,
	24991 - 11905: 0x9188,
	24992 - 11905: 0x9189,
	24993 - 11905: 0x918A,
	24994 - 11905: 0x918B,
	24995 - 11905: 0x918C,
	24996 - 11905: 0x918D,
	24997 - 11905: 0x918E,
	24998 - 11905: 0x918F,
	24999 - 11905: 0xE3BF,
	25000 - 11905: 0xBAA9,
	25001 - 11905: 0xEDAC,
	25002 - 11905: 0x9190,
	25003 - 11905: 0x9191,
	25004 - 11905: 0xE3BD,
	25005 - 11905: 0x9192,
	25006 - 11905: 0x9193,
	25007 - 11905: 0x9194,
	25008 - 11905: 0x9195,
	25009 - 11905: 0x9196,
	25010 - 11905: 0x9197,
	25011 - 11905: 0x9198,
	25012 - 11905: 0x9199,
	25013 - 11905: 0x919A,
	25014 - 11905: 0x919B,
	25015 - 11905: 0xE3C0,
	25016 - 11905: 0x919C,
	25017 - 11905: 0x919D,
	25018 - 11905: 0x919E,
	25019 - 11905: 0x919F,
	25020 - 11905: 0x91A0,
	25021 - 11905: 0x91A1,
	25022 - 11905: 0xBAB6,
	25023 - 11905: 0x91A2,
	25024 - 11905: 0x91A3,
	25025 - 11905: 0x91A4,
	25026 - 11905: 0xB6AE,
	25027 - 11905: 0x91A5,
	25028 - 11905: 0x91A6,
	25029 - 11905: 0x91A7,
	25030 - 11905: 0x91A8,
	25031 - 11905: 0x91A9,
	25032 - 11905: 0xD0B8,
	25033 - 11905: 0x91AA,
	25034 - 11905: 0xB0C3,
	25035 - 11905: 0xEDAE,
	25036 - 11905: 0x91AB,
	25037 - 11905: 0x91AC,
	25038 - 11905: 0x91AD,
	25039 - 11905: 0x91AE,
	25040 - 11905: 0x91AF,
	25041 - 11905: 0xEDAF,
	25042 - 11905: 0xC0C1,
	25043 - 11905: 0x91B0,
	25044 - 11905: 0xE3C1,
	25045 - 11905: 0x91B1,
	25046 - 11905: 0x91B2,
	25047 - 11905: 0x91B3,
	25048 - 11905: 0x91B4,
	25049 - 11905: 0x91B5,
	25050 - 11905: 0x91B6,
	25051 - 11905: 0x91B7,
	25052 - 11905: 0x91B8,
	25053 - 11905: 0x91B9,
	25054 - 11905: 0x91BA,
	25055 - 11905: 0x91BB,
	25056 - 11905: 0x91BC,
	25057 - 11905: 0x91BD,
	25058 - 11905: 0x91BE,
	25059 - 11905: 0x91BF,
	25060 - 11905: 0x91C0,
	25061 - 11905: 0x91C1,
	25062 - 11905: 0xC5B3,
	25063 - 11905: 0x91C2,
	25064 - 11905: 0x91C3,
	25065 - 11905: 0x91C4,
	25066 - 11905: 0x91C5,
	25067 - 11905: 0x91C6,
	25068 - 11905: 0x91C7,
	25069 - 11905: 0x91C8,
	25070 - 11905: 0x91C9,
	25071 - 11905: 0x91CA,
	25072 - 11905: 0x91CB,
	25073 - 11905: 0x91CC,
	25074 - 11905: 0x91CD,
	25075 - 11905: 0x91CE,
	25076 - 11905: 0x91CF,
	25077 - 11905: 0xE3C2,
	25078 - 11905: 0x91D0,
	25079 - 11905: 0x91D1,
	25080 - 11905: 0x91D2,
	25081 - 11905: 0x91D3,
	25082 - 11905: 0x91D4,
	25083 - 11905: 0x91D5,
	25084 - 11905: 0x91D6,
	25085 - 11905: 0x91D7,
	25086 - 11905: 0x91D8,
	25087 - 11905: 0xDCB2,
	25088 - 11905: 0x91D9,
	25089 - 11905: 0x91DA,
	25090 - 11905: 0x91DB,
	25091 - 11905: 0x91DC,
	25092 - 11905: 0x91DD,
	25093 - 11905: 0x91DE,
	25094 - 11905: 0xEDB0,
	25095 - 11905: 0x91DF,
	25096 - 11905: 0xB8EA,
	25097 - 11905: 0x91E0,
	25098 - 11905: 0xCEEC,
	25099 - 11905: 0xEAA7,
	25100 - 11905: 0xD0E7,
	25101 - 11905: 0xCAF9,
	25102 - 11905: 0xC8D6,
	25103 - 11905: 0xCFB7,
	25104 - 11905: 0xB3C9,
	25105 - 11905: 0xCED2,
	25106 - 11905: 0xBDE4,
	25107 - 11905: 0x91E1,
	25108 - 11905: 0x91E2,
	25109 - 11905: 0xE3DE,
	25110 - 11905: 0xBBF2,
	25111 - 11905: 0xEAA8,
	25112 - 11905: 0xD5BD,
	25113 - 11905: 0x91E3,
	25114 - 11905: 0xC6DD,
	25115 - 11905: 0xEAA9,
	25116 - 11905: 0x91E4,
	25117 - 11905: 0x91E5,
	25118 - 11905: 0x91E6,
	25119 - 11905: 0xEAAA,
	25120 - 11905: 0x91E7,
	25121 - 11905: 0xEAAC,
	25122 - 11905: 0xEAAB,
	25123 - 11905: 0x91E8,
	25124 - 11905: 0xEAAE,
	25125 - 11905: 0xEAAD,
	25126 - 11905: 0x91E9,
	25127 - 11905: 0x91EA,
	25128 - 11905: 0x91EB,
	25129 - 11905: 0x91EC,
	25130 - 11905: 0xBDD8,
	25131 - 11905: 0x91ED,
	25132 - 11905: 0xEAAF,
	25133 - 11905: 0x91EE,
	25134 - 11905: 0xC2BE,
	25135 - 11905: 0x91EF,
	25136 - 11905: 0x91F0,
	25137 - 11905: 0x91F1,
	25138 - 11905: 0x91F2,
	25139 - 11905: 0xB4C1,
	25140 - 11905: 0xB4F7,
	25141 - 11905: 0x91F3,
	25142 - 11905: 0x91F4,
	25143 - 11905: 0xBBA7,
	25144 - 11905: 0x91F5,
	25145 - 11905: 0x91F6,
	25146 - 11905: 0x91F7,
	25147 - 11905: 0x91F8,
	25148 - 11905: 0x91F9,
	25149 - 11905: 0xECE6,
	25150 - 11905: 0xECE5,
	25151 - 11905: 0xB7BF,
	25152 - 11905: 0xCBF9,
	25153 - 11905: 0xB1E2,
	25154 - 11905: 0x91FA,
	25155 - 11905: 0xECE7,
	25156 - 11905: 0x91FB,
	25157 - 11905: 0x91FC,
	25158 - 11905: 0x91FD,
	25159 - 11905: 0xC9C8,
	25160 - 11905: 0xECE8,
	25161 - 11905: 0xECE9,
	25162 - 11905: 0x91FE,
	25163 - 11905: 0xCAD6,
	25164 - 11905: 0xDED0,
	25165 - 11905: 0xB2C5,
	25166 - 11905: 0xD4FA,
	25167 - 11905: 0x9240,
	25168 - 11905: 0x9241,
	25169 - 11905: 0xC6CB,
	25170 - 11905: 0xB0C7,
	25171 - 11905: 0xB4F2,
	25172 - 11905: 0xC8D3,
	25173 - 11905: 0x9242,
	25174 - 11905: 0x9243,
	25175 - 11905: 0x9244,
	25176 - 11905: 0xCDD0,
	25177 - 11905: 0x9245,
	25178 - 11905: 0x9246,
	25179 - 11905: 0xBFB8,
	25180 - 11905: 0x9247,
	25181 - 11905: 0x9248,
	25182 - 11905: 0x9249,
	25183 - 11905: 0x924A,
	25184 - 11905: 0x924B,
	25185 - 11905: 0x924C,
	25186 - 11905: 0x924D,
	25187 - 11905: 0xBFDB,
	25188 - 11905: 0x924E,
	25189 - 11905: 0x924F,
	25190 - 11905: 0xC7A4,
	25191 - 11905: 0xD6B4,
	25192 - 11905: 0x9250,
	25193 - 11905: 0xC0A9,
	25194 - 11905: 0xDED1,
	25195 - 11905: 0xC9A8,
	25196 - 11905: 0xD1EF,
	25197 - 11905: 0xC5A4,
	25198 - 11905: 0xB0E7,
	25199 - 11905: 0xB3B6,
	25200 - 11905: 0xC8C5,
	25201 - 11905: 0x9251,
	25202 - 11905: 0x9252,
	25203 - 11905: 0xB0E2,
	25204 - 11905: 0x9253,
	25205 - 11905: 0x9254,
	25206 - 11905: 0xB7F6,
	25207 - 11905: 0x9255,
	25208 - 11905: 0x9256,
	25209 - 11905: 0xC5FA,
	25210 - 11905: 0x9257,
	25211 - 11905: 0x9258,
	25212 - 11905: 0xB6F3,
	25213 - 11905: 0x9259,
	25214 - 11905: 0xD5D2,
	25215 - 11905: 0xB3D0,
	25216 - 11905: 0xBCBC,
	25217 - 11905: 0x925A,
	25218 - 11905: 0x925B,
	25219 - 11905: 0x925C,
	25220 - 11905: 0xB3AD,
	25221 - 11905: 0x925D,
	25222 - 11905: 0x925E,
	25223 - 11905: 0x925F,
	25224 - 11905: 0x9260,
	25225 - 11905: 0xBEF1,
	25226 - 11905: 0xB0D1,
	25227 - 11905: 0x9261,
	25228 - 11905: 0x9262,
	25229 - 11905: 0x9263,
	25230 - 11905: 0x9264,
	25231 - 11905: 0x9265,
	25232 - 11905: 0x9266,
	25233 - 11905: 0xD2D6,
	25234 - 11905: 0xCAE3,
	25235 - 11905: 0xD7A5,
	25236 - 11905: 0x9267,
	25237 - 11905: 0xCDB6,
	25238 - 11905: 0xB6B6,
	25239 - 11905: 0xBFB9,
	25240 - 11905: 0xD5DB,
	25241 - 11905: 0x9268,
	25242 - 11905: 0xB8A7,
	25243 - 11905: 0xC5D7,
	25244 - 11905: 0x9269,
	25245 - 11905: 0x926A,
	25246 - 11905: 0x926B,
	25247 - 11905: 0xDED2,
	25248 - 11905: 0xBFD9,
	25249 - 11905: 0xC2D5,
	25250 - 11905: 0xC7C0,
	25251 - 11905: 0x926C,
	25252 - 11905: 0xBBA4,
	25253 - 11905: 0xB1A8,
	25254 - 11905: 0x926D,
	25255 - 11905: 0x926E,
	25256 - 11905: 0xC5EA,
	25257 - 11905: 0x926F,
	25258 - 11905: 0x9270,
	25259 - 11905: 0xC5FB,
	25260 - 11905: 0xCCA7,
	25261 - 11905: 0x9271,
	25262 - 11905: 0x9272,
	25263 - 11905: 0x9273,
	25264 - 11905: 0x9274,
	25265 - 11905: 0xB1A7,
	25266 - 11905: 0x9275,
	25267 - 11905: 0x9276,
	25268 - 11905: 0x9277,
	25269 - 11905: 0xB5D6,
	25270 - 11905: 0x9278,
	25271 - 11905: 0x9279,
	25272 - 11905: 0x927A,
	25273 - 11905: 0xC4A8,
	25274 - 11905: 0x927B,
	25275 - 11905: 0xDED3,
	25276 - 11905: 0xD1BA,
	25277 - 11905: 0xB3E9,
	25278 - 11905: 0x927C,
	25279 - 11905: 0xC3F2,
	25280 - 11905: 0x927D,
	25281 - 11905: 0x927E,
	25282 - 11905: 0xB7F7,
	25283 - 11905: 0x9280,
	25284 - 11905: 0xD6F4,
	25285 - 11905: 0xB5A3,
	25286 - 11905: 0xB2F0,
	25287 - 11905: 0xC4B4,
	25288 - 11905: 0xC4E9,
	25289 - 11905: 0xC0AD,
	25290 - 11905: 0xDED4,
	25291 - 11905: 0x9281,
	25292 - 11905: 0xB0E8,
	25293 - 11905: 0xC5C4,
	25294 - 11905: 0xC1E0,
	25295 - 11905: 0x9282,
	25296 - 11905: 0xB9D5,
	25297 - 11905: 0x9283,
	25298 - 11905: 0xBEDC,
	25299 - 11905: 0xCDD8,
	25300 - 11905: 0xB0CE,
	25301 - 11905: 0x9284,
	25302 - 11905: 0xCDCF,
	25303 - 11905: 0xDED6,
	25304 - 11905: 0xBED0,
	25305 - 11905: 0xD7BE,
	25306 - 11905: 0xDED5,
	25307 - 11905: 0xD5D0,
	25308 - 11905: 0xB0DD,
	25309 - 11905: 0x9285,
	25310 - 11905: 0x9286,
	25311 - 11905: 0xC4E2,
	25312 - 11905: 0x9287,
	25313 - 11905: 0x9288,
	25314 - 11905: 0xC2A3,
	25315 - 11905: 0xBCF0,
	25316 - 11905: 0x9289,
	25317 - 11905: 0xD3B5,
	25318 - 11905: 0xC0B9,
	25319 - 11905: 0xC5A1,
	25320 - 11905: 0xB2A6,
	25321 - 11905: 0xD4F1,
	25322 - 11905: 0x928A,
	25323 - 11905: 0x928B,
	25324 - 11905: 0xC0A8,
	25325 - 11905: 0xCAC3,
	25326 - 11905: 0xDED7,
	25327 - 11905: 0xD5FC,
	25328 - 11905: 0x928C,
	25329 - 11905: 0xB9B0,
	25330 - 11905: 0x928D,
	25331 - 11905: 0xC8AD,
	25332 - 11905: 0xCBA9,
	25333 - 11905: 0x928E,
	25334 - 11905: 0xDED9,
	25335 - 11905: 0xBFBD,
	25336 - 11905: 0x928F,
	25337 - 11905: 0x9290,
	25338 - 11905: 0x9291,
	25339 - 11905: 0x9292,
	25340 - 11905: 0xC6B4,
	25341 - 11905: 0xD7A7,
	25342 - 11905: 0xCAB0,
	25343 - 11905: 0xC4C3,
	25344 - 11905: 0x9293,
	25345 - 11905: 0xB3D6,
	25346 - 11905: 0xB9D2,
	25347 - 11905: 0x9294,
	25348 - 11905: 0x9295,
	25349 - 11905: 0x9296,
	25350 - 11905: 0x9297,
	25351 - 11905: 0xD6B8,
	25352 - 11905: 0xEAFC,
	25353 - 11905: 0xB0B4,
	25354 - 11905: 0x9298,
	25355 - 11905: 0x9299,
	25356 - 11905: 0x929A,
	25357 - 11905: 0x929B,
	25358 - 11905: 0xBFE6,
	25359 - 11905: 0x929C,
	25360 - 11905: 0x929D,
	25361 - 11905: 0xCCF4,
	25362 - 11905: 0x929E,
	25363 - 11905: 0x929F,
	25364 - 11905: 0x92A0,
	25365 - 11905: 0x92A1,
	25366 - 11905: 0xCDDA,
	25367 - 11905: 0x92A2,
	25368 - 11905: 0x92A3,
	25369 - 11905: 0x92A4,
	25370 - 11905: 0xD6BF,
	25371 - 11905: 0xC2CE,
	25372 - 11905: 0x92A5,
	25373 - 11905: 0xCECE,
	25374 - 11905: 0xCCA2,
	25375 - 11905: 0xD0AE,
	25376 - 11905: 0xC4D3,
	25377 - 11905: 0xB5B2,
	25378 - 11905: 0xDED8,
	25379 - 11905: 0xD5F5,
	25380 - 11905: 0xBCB7,
	25381 - 11905: 0xBBD3,
	25382 - 11905: 0x92A6,
	25383 - 11905: 0x92A7,
	25384 - 11905: 0xB0A4,
	25385 - 11905: 0x92A8,
	25386 - 11905: 0xC5B2,
	25387 - 11905: 0xB4EC,
	25388 - 11905: 0x92A9,
	25389 - 11905: 0x92AA,
	25390 - 11905: 0x92AB,
	25391 - 11905: 0xD5F1,
	25392 - 11905: 0x92AC,
	25393 - 11905: 0x92AD,
	25394 - 11905: 0xEAFD,
	25395 - 11905: 0x92AE,
	25396 - 11905: 0x92AF,
	25397 - 11905: 0x92B0,
	25398 - 11905: 0x92B1,
	25399 - 11905: 0x92B2,
	25400 - 11905: 0x92B3,
	25401 - 11905: 0xDEDA,
	25402 - 11905: 0xCDA6,
	25403 - 11905: 0x92B4,
	25404 - 11905: 0x92B5,
	25405 - 11905: 0xCDEC,
	25406 - 11905: 0x92B6,
	25407 - 11905: 0x92B7,
	25408 - 11905: 0x92B8,
	25409 - 11905: 0x92B9,
	25410 - 11905: 0xCEE6,
	25411 - 11905: 0xDEDC,
	25412 - 11905: 0x92BA,
	25413 - 11905: 0xCDB1,
	25414 - 11905: 0xC0A6,
	25415 - 11905: 0x92BB,
	25416 - 11905: 0x92BC,
	25417 - 11905: 0xD7BD,
	25418 - 11905: 0x92BD,
	25419 - 11905: 0xDEDB,
	25420 - 11905: 0xB0C6,
	25421 - 11905: 0xBAB4,
	25422 - 11905: 0xC9D3,
	25423 - 11905: 0xC4F3,
	25424 - 11905: 0xBEE8,
	25425 - 11905: 0x92BE,
	25426 - 11905: 0x92BF,
	25427 - 11905: 0x92C0,
	25428 - 11905: 0x92C1,
	25429 - 11905: 0xB2B6,
	25430 - 11905: 0x92C2,
	25431 - 11905: 0x92C3,
	25432 - 11905: 0x92C4,
	25433 - 11905: 0x92C5,
	25434 - 11905: 0x92C6,
	25435 - 11905: 0x92C7,
	25436 - 11905: 0x92C8,
	25437 - 11905: 0x92C9,
	25438 - 11905: 0xC0CC,
	25439 - 11905: 0xCBF0,
	25440 - 11905: 0x92CA,
	25441 - 11905: 0xBCF1,
	25442 - 11905: 0xBBBB,
	25443 - 11905: 0xB5B7,
	25444 - 11905: 0x92CB,
	25445 - 11905: 0x92CC,
	25446 - 11905: 0x92CD,
	25447 - 11905: 0xC5F5,
	25448 - 11905: 0x92CE,
	25449 - 11905: 0xDEE6,
	25450 - 11905: 0x92CF,
	25451 - 11905: 0x92D0,
	25452 - 11905: 0x92D1,
	25453 - 11905: 0xDEE3,
	25454 - 11905: 0xBEDD,
	25455 - 11905: 0x92D2,
	25456 - 11905: 0x92D3,
	25457 - 11905: 0xDEDF,
	25458 - 11905: 0x92D4,
	25459 - 11905: 0x92D5,
	25460 - 11905: 0x92D6,
	25461 - 11905: 0x92D7,
	25462 - 11905: 0xB4B7,
	25463 - 11905: 0xBDDD,
	25464 - 11905: 0x92D8,
	25465 - 11905: 0x92D9,
	25466 - 11905: 0xDEE0,
	25467 - 11905: 0xC4ED,
	25468 - 11905: 0x92DA,
	25469 - 11905: 0x92DB,
	25470 - 11905: 0x92DC,
	25471 - 11905: 0x92DD,
	25472 - 11905: 0xCFC6,
	25473 - 11905: 0x92DE,
	25474 - 11905: 0xB5E0,
	25475 - 11905: 0x92DF,
	25476 - 11905: 0x92E0,
	25477 - 11905: 0x92E1,
	25478 - 11905: 0x92E2,
	25479 - 11905: 0xB6DE,
	25480 - 11905: 0xCADA,
	25481 - 11905: 0xB5F4,
	25482 - 11905: 0xDEE5,
	25483 - 11905: 0x92E3,
	25484 - 11905: 0xD5C6,
	25485 - 11905: 0x92E4,
	25486 - 11905: 0xDEE1,
	25487 - 11905: 0xCCCD,
	25488 - 11905: 0xC6FE,
	25489 - 11905: 0x92E5,
	25490 - 11905: 0xC5C5,
	25491 - 11905: 0x92E6,
	25492 - 11905: 0x92E7,
	25493 - 11905: 0x92E8,
	25494 - 11905: 0xD2B4,
	25495 - 11905: 0x92E9,
	25496 - 11905: 0xBEF2,
	25497 - 11905: 0x92EA,
	25498 - 11905: 0x92EB,
	25499 - 11905: 0x92EC,
	25500 - 11905: 0x92ED,
	25501 - 11905: 0x92EE,
	25502 - 11905: 0x92EF,
	25503 - 11905: 0x92F0,
	25504 - 11905: 0xC2D3,
	25505 - 11905: 0x92F1,
	25506 - 11905: 0xCCBD,
	25507 - 11905: 0xB3B8,
	25508 - 11905: 0x92F2,
	25509 - 11905: 0xBDD3,
	25510 - 11905: 0x92F3,
	25511 - 11905: 0xBFD8,
	25512 - 11905: 0xCDC6,
	25513 - 11905: 0xD1DA,
	25514 - 11905: 0xB4EB,
	25515 - 11905: 0x92F4,
	25516 - 11905: 0xDEE4,
	25517 - 11905: 0xDEDD,
	25518 - 11905: 0xDEE7,
	25519 - 11905: 0x92F5,
	25520 - 11905: 0xEAFE,
	25521 - 11905: 0x92F6,
	25522 - 11905: 0x92F7,
	25523 - 11905: 0xC2B0,
	25524 - 11905: 0xDEE2,
	25525 - 11905: 0x92F8,
	25526 - 11905: 0x92F9,
	25527 - 11905: 0xD6C0,
	25528 - 11905: 0xB5A7,
	25529 - 11905: 0x92FA,
	25530 - 11905: 0xB2F4,
	25531 - 11905: 0x92FB,
	25532 - 11905: 0xDEE8,
	25533 - 11905: 0x92FC,
	25534 - 11905: 0xDEF2,
	25535 - 11905: 0x92FD,
	25536 - 11905: 0x92FE,
	25537 - 11905: 0x9340,
	25538 - 11905: 0x9341,
	25539 - 11905: 0x9342,
	25540 - 11905: 0xDEED,
	25541 - 11905: 0x9343,
	25542 - 11905: 0xDEF1,
	25543 - 11905: 0x9344,
	25544 - 11905: 0x9345,
	25545 - 11905: 0xC8E0,
	25546 - 11905: 0x9346,
	25547 - 11905: 0x9347,
	25548 - 11905: 0x9348,
	25549 - 11905: 0xD7E1,
	25550 - 11905: 0xDEEF,
	25551 - 11905: 0xC3E8,
	25552 - 11905: 0xCCE1,
	25553 - 11905: 0x9349,
	25554 - 11905: 0xB2E5,
	25555 - 11905: 0x934A,
	25556 - 11905: 0x934B,
	25557 - 11905: 0x934C,
	25558 - 11905: 0xD2BE,
	25559 - 11905: 0x934D,
	25560 - 11905: 0x934E,
	25561 - 11905: 0x934F,
	25562 - 11905: 0x9350,
	25563 - 11905: 0x9351,
	25564 - 11905: 0x9352,
	25565 - 11905: 0x9353,
	25566 - 11905: 0xDEEE,
	25567 - 11905: 0x9354,
	25568 - 11905: 0xDEEB,
	25569 - 11905: 0xCED5,
	25570 - 11905: 0x9355,
	25571 - 11905: 0xB4A7,
	25572 - 11905: 0x9356,
	25573 - 11905: 0x9357,
	25574 - 11905: 0x9358,
	25575 - 11905: 0x9359,
	25576 - 11905: 0x935A,
	25577 - 11905: 0xBFAB,
	25578 - 11905: 0xBEBE,
	25579 - 11905: 0x935B,
	25580 - 11905: 0x935C,
	25581 - 11905: 0xBDD2,
	25582 - 11905: 0x935D,
	25583 - 11905: 0x935E,
	25584 - 11905: 0x935F,
	25585 - 11905: 0x9360,
	25586 - 11905: 0xDEE9,
	25587 - 11905: 0x9361,
	25588 - 11905: 0xD4AE,
	25589 - 11905: 0x9362,
	25590 - 11905: 0xDEDE,
	25591 - 11905: 0x9363,
	25592 - 11905: 0xDEEA,
	25593 - 11905: 0x9364,
	25594 - 11905: 0x9365,
	25595 - 11905: 0x9366,
	25596 - 11905: 0x9367,
	25597 - 11905: 0xC0BF,
	25598 - 11905: 0x9368,
	25599 - 11905: 0xDEEC,
	25600 - 11905: 0xB2F3,
	25601 - 11905: 0xB8E9,
	25602 - 11905: 0xC2A7,
	25603 - 11905: 0x9369,
	25604 - 11905: 0x936A,
	25605 - 11905: 0xBDC1,
	25606 - 11905: 0x936B,
	25607 - 11905: 0x936C,
	25608 - 11905: 0x936D,
	25609 - 11905: 0x936E,
	25610 - 11905: 0x936F,
	25611 - 11905: 0xDEF5,
	25612 - 11905: 0xDEF8,
	25613 - 11905: 0x9370,
	25614 - 11905: 0x9371,
	25615 - 11905: 0xB2AB,
	25616 - 11905: 0xB4A4,
	25617 - 11905: 0x9372,
	25618 - 11905: 0x9373,
	25619 - 11905: 0xB4EA,
	25620 - 11905: 0xC9A6,
	25621 - 11905: 0x9374,
	25622 - 11905: 0x9375,
	25623 - 11905: 0x9376,
	25624 - 11905: 0x9377,
	25625 - 11905: 0x9378,
	25626 - 11905: 0x9379,
	25627 - 11905: 0xDEF6,
	25628 - 11905: 0xCBD1,
	25629 - 11905: 0x937A,
	25630 - 11905: 0xB8E3,
	25631 - 11905: 0x937B,
	25632 - 11905: 0xDEF7,
	25633 - 11905: 0xDEFA,
	25634 - 11905: 0x937C,
	25635 - 11905: 0x937D,
	25636 - 11905: 0x937E,
	25637 - 11905: 0x9380,
	25638 - 11905: 0xDEF9,
	25639 - 11905: 0x9381,
	25640 - 11905: 0x9382,
	25641 - 11905: 0x9383,
	25642 - 11905: 0xCCC2,
	25643 - 11905: 0x9384,
	25644 - 11905: 0xB0E1,
	25645 - 11905: 0xB4EE,
	25646 - 11905: 0x9385,
	25647 - 11905: 0x9386,
	25648 - 11905: 0x9387,
	25649 - 11905: 0x9388,
	25650 - 11905: 0x9389,
	25651 - 11905: 0x938A,
	25652 - 11905: 0xE5BA,
	25653 - 11905: 0x938B,
	25654 - 11905: 0x938C,
	25655 - 11905: 0x938D,
	25656 - 11905: 0x938E,
	25657 - 11905: 0x938F,
	25658 - 11905: 0xD0AF,
	25659 - 11905: 0x9390,
	25660 - 11905: 0x9391,
	25661 - 11905: 0xB2EB,
	25662 - 11905: 0x9392,
	25663 - 11905: 0xEBA1,
	25664 - 11905: 0x9393,
	25665 - 11905: 0xDEF4,
	25666 - 11905: 0x9394,
	25667 - 11905: 0x9395,
	25668 - 11905: 0xC9E3,
	25669 - 11905: 0xDEF3,
	25670 - 11905: 0xB0DA,
	25671 - 11905: 0xD2A1,
	25672 - 11905: 0xB1F7,
	25673 - 11905: 0x9396,
	25674 - 11905: 0xCCAF,
	25675 - 11905: 0x9397,
	25676 - 11905: 0x9398,
	25677 - 11905: 0x9399,
	25678 - 11905: 0x939A,
	25679 - 11905: 0x939B,
	25680 - 11905: 0x939C,
	25681 - 11905: 0x939D,
	25682 - 11905: 0xDEF0,
	25683 - 11905: 0x939E,
	25684 - 11905: 0xCBA4,
	25685 - 11905: 0x939F,
	25686 - 11905: 0x93A0,
	25687 - 11905: 0x93A1,
	25688 - 11905: 0xD5AA,
	25689 - 11905: 0x93A2,
	25690 - 11905: 0x93A3,
	25691 - 11905: 0x93A4,
	25692 - 11905: 0x93A5,
	25693 - 11905: 0x93A6,
	25694 - 11905: 0xDEFB,
	25695 - 11905: 0x93A7,
	25696 - 11905: 0x93A8,
	25697 - 11905: 0x93A9,
	25698 - 11905: 0x93AA,
	25699 - 11905: 0x93AB,
	25700 - 11905: 0x93AC,
	25701 - 11905: 0x93AD,
	25702 - 11905: 0x93AE,
	25703 - 11905: 0xB4DD,
	25704 - 11905: 0x93AF,
	25705 - 11905: 0xC4A6,
	25706 - 11905: 0x93B0,
	25707 - 11905: 0x93B1,
	25708 - 11905: 0x93B2,
	25709 - 11905: 0xDEFD,
	25710 - 11905: 0x93B3,
	25711 - 11905: 0x93B4,
	25712 - 11905: 0x93B5,
	25713 - 11905: 0x93B6,
	25714 - 11905: 0x93B7,
	25715 - 11905: 0x93B8,
	25716 - 11905: 0x93B9,
	25717 - 11905: 0x93BA,
	25718 - 11905: 0x93BB,
	25719 - 11905: 0x93BC,
	25720 - 11905: 0xC3FE,
	25721 - 11905: 0xC4A1,
	25722 - 11905: 0xDFA1,
	25723 - 11905: 0x93BD,
	25724 - 11905: 0x93BE,
	25725 - 11905: 0x93BF,
	25726 - 11905: 0x93C0,
	25727 - 11905: 0x93C1,
	25728 - 11905: 0x93C2,
	25729 - 11905: 0x93C3,
	25730 - 11905: 0xC1CC,
	25731 - 11905: 0x93C4,
	25732 - 11905: 0xDEFC,
	25733 - 11905: 0xBEEF,
	25734 - 11905: 0x93C5,
	25735 - 11905: 0xC6B2,
	25736 - 11905: 0x93C6,
	25737 - 11905: 0x93C7,
	25738 - 11905: 0x93C8,
	25739 - 11905: 0x93C9,
	25740 - 11905: 0x93CA,
	25741 - 11905: 0x93CB,
	25742 - 11905: 0x93CC,
	25743 - 11905: 0x93CD,
	25744 - 11905: 0x93CE,
	25745 - 11905: 0xB3C5,
	25746 - 11905: 0xC8F6,
	25747 - 11905: 0x93CF,
	25748 - 11905: 0x93D0,
	25749 - 11905: 0xCBBA,
	25750 - 11905: 0xDEFE,
	25751 - 11905: 0x93D1,
	25752 - 11905: 0x93D2,
	25753 - 11905: 0xDFA4,
	25754 - 11905: 0x93D3,
	25755 - 11905: 0x93D4,
	25756 - 11905: 0x93D5,
	25757 - 11905: 0x93D6,
	25758 - 11905: 0xD7B2,
	25759 - 11905: 0x93D7,
	25760 - 11905: 0x93D8,
	25761 - 11905: 0x93D9,
	25762 - 11905: 0x93DA,
	25763 - 11905: 0x93DB,
	25764 - 11905: 0xB3B7,
	25765 - 11905: 0x93DC,
	25766 - 11905: 0x93DD,
	25767 - 11905: 0x93DE,
	25768 - 11905: 0x93DF,
	25769 - 11905: 0xC1C3,
	25770 - 11905: 0x93E0,
	25771 - 11905: 0x93E1,
	25772 - 11905: 0xC7CB,
	25773 - 11905: 0xB2A5,
	25774 - 11905: 0xB4E9,
	25775 - 11905: 0x93E2,
	25776 - 11905: 0xD7AB,
	25777 - 11905: 0x93E3,
	25778 - 11905: 0x93E4,
	25779 - 11905: 0x93E5,
	25780 - 11905: 0x93E6,
	25781 - 11905: 0xC4EC,
	25782 - 11905: 0x93E7,
	25783 - 11905: 0xDFA2,
	25784 - 11905: 0xDFA3,
	25785 - 11905: 0x93E8,
	25786 - 11905: 0xDFA5,
	25787 - 11905: 0x93E9,
	25788 - 11905: 0xBAB3,
	25789 - 11905: 0x93EA,
	25790 - 11905: 0x93EB,
	25791 - 11905: 0x93EC,
	25792 - 11905: 0xDFA6,
	25793 - 11905: 0x93ED,
	25794 - 11905: 0xC0DE,
	25795 - 11905: 0x93EE,
	25796 - 11905: 0x93EF,
	25797 - 11905: 0xC9C3,
	25798 - 11905: 0x93F0,
	25799 - 11905: 0x93F1,
	25800 - 11905: 0x93F2,
	25801 - 11905: 0x93F3,
	25802 - 11905: 0x93F4,
	25803 - 11905: 0x93F5,
	25804 - 11905: 0x93F6,
	25805 - 11905: 0xB2D9,
	25806 - 11905: 0xC7E6,
	25807 - 11905: 0x93F7,
	25808 - 11905: 0xDFA7,
	25809 - 11905: 0x93F8,
	25810 - 11905: 0xC7DC,
	25811 - 11905: 0x93F9,
	25812 - 11905: 0x93FA,
	25813 - 11905: 0x93FB,
	25814 - 11905: 0x93FC,
	25815 - 11905: 0xDFA8,
	25816 - 11905: 0xEBA2,
	25817 - 11905: 0x93FD,
	25818 - 11905: 0x93FE,
	25819 - 11905: 0x9440,
	25820 - 11905: 0x9441,
	25821 - 11905: 0x9442,
	25822 - 11905: 0xCBD3,
	25823 - 11905: 0x9443,
	25824 - 11905: 0x9444,
	25825 - 11905: 0x9445,
	25826 - 11905: 0xDFAA,
	25827 - 11905: 0x9446,
	25828 - 11905: 0xDFA9,
	25829 - 11905: 0x9447,
	25830 - 11905: 0xB2C1,
	25831 - 11905: 0x9448,
	25832 - 11905: 0x9449,
	25833 - 11905: 0x944A,
	25834 - 11905: 0x944B,
	25835 - 11905: 0x944C,
	25836 - 11905: 0x944D,
	25837 - 11905: 0x944E,
	25838 - 11905: 0x944F,
	25839 - 11905: 0x9450,
	25840 - 11905: 0x9451,
	25841 - 11905: 0x9452,
	25842 - 11905: 0x9453,
	25843 - 11905: 0x9454,
	25844 - 11905: 0x9455,
	25845 - 11905: 0x9456,
	25846 - 11905: 0x9457,
	25847 - 11905: 0x9458,
	25848 - 11905: 0x9459,
	25849 - 11905: 0x945A,
	25850 - 11905: 0x945B,
	25851 - 11905: 0x945C,
	25852 - 11905: 0x945D,
	25853 - 11905: 0x945E,
	25854 - 11905: 0x945F,
	25855 - 11905: 0x9460,
	25856 - 11905: 0xC5CA,
	25857 - 11905: 0x9461,
	25858 - 11905: 0x9462,
	25859 - 11905: 0x9463,
	25860 - 11905: 0x9464,
	25861 - 11905: 0x9465,
	25862 - 11905: 0x9466,
	25863 - 11905: 0x9467,
	25864 - 11905: 0x9468,
	25865 - 11905: 0xDFAB,
	25866 - 11905: 0x9469,
	25867 - 11905: 0x946A,
	25868 - 11905: 0x946B,
	25869 - 11905: 0x946C,
	25870 - 11905: 0x946D,
	25871 - 11905: 0x946E,
	25872 - 11905: 0x946F,
	25873 - 11905: 0x9470,
	25874 - 11905: 0xD4DC,
	25875 - 11905: 0x9471,
	25876 - 11905: 0x9472,
	25877 - 11905: 0x9473,
	25878 - 11905: 0x9474,
	25879 - 11905: 0x9475,
	25880 - 11905: 0xC8C1,
	25881 - 11905: 0x9476,
	25882 - 11905: 0x9477,
	25883 - 11905: 0x9478,
	25884 - 11905: 0x9479,
	25885 - 11905: 0x947A,
	25886 - 11905: 0x947B,
	25887 - 11905: 0x947C,
	25888 - 11905: 0x947D,
	25889 - 11905: 0x947E,
	25890 - 11905: 0x9480,
	25891 - 11905: 0x9481,
	25892 - 11905: 0x9482,
	25893 - 11905: 0xDFAC,
	25894 - 11905: 0x9483,
	25895 - 11905: 0x9484,
	25896 - 11905: 0x9485,
	25897 - 11905: 0x9486,
	25898 - 11905: 0x9487,
	25899 - 11905: 0xBEF0,
	25900 - 11905: 0x9488,
	25901 - 11905: 0x9489,
	25902 - 11905: 0xDFAD,
	25903 - 11905: 0xD6A7,
	25904 - 11905: 0x948A,
	25905 - 11905: 0x948B,
	25906 - 11905: 0x948C,
	25907 - 11905: 0x948D,
	25908 - 11905: 0xEAB7,
	25909 - 11905: 0xEBB6,
	25910 - 11905: 0xCAD5,
	25911 - 11905: 0x948E,
	25912 - 11905: 0xD8FC,
	25913 - 11905: 0xB8C4,
	25914 - 11905: 0x948F,
	25915 - 11905: 0xB9A5,
	25916 - 11905: 0x9490,
	25917 - 11905: 0x9491,
	25918 - 11905: 0xB7C5,
	25919 - 11905: 0xD5FE,
	25920 - 11905: 0x9492,
	25921 - 11905: 0x9493,
	25922 - 11905: 0x9494,
	25923 - 11905: 0x9495,
	25924 - 11905: 0x9496,
	25925 - 11905: 0xB9CA,
	25926 - 11905: 0x9497,
	25927 - 11905: 0x9498,
	25928 - 11905: 0xD0A7,
	25929 - 11905: 0xF4CD,
	25930 - 11905: 0x9499,
	25931 - 11905: 0x949A,
	25932 - 11905: 0xB5D0,
	25933 - 11905: 0x949B,
	25934 - 11905: 0x949C,
	25935 - 11905: 0xC3F4,
	25936 - 11905: 0x949D,
	25937 - 11905: 0xBEC8,
	25938 - 11905: 0x949E,
	25939 - 11905: 0x949F,
	25940 - 11905: 0x94A0,
	25941 - 11905: 0xEBB7,
	25942 - 11905: 0xB0BD,
	25943 - 11905: 0x94A1,
	25944 - 11905: 0x94A2,
	25945 - 11905: 0xBDCC,
	25946 - 11905: 0x94A3,
	25947 - 11905: 0xC1B2,
	25948 - 11905: 0x94A4,
	25949 - 11905: 0xB1D6,
	25950 - 11905: 0xB3A8,
	25951 - 11905: 0x94A5,
	25952 - 11905: 0x94A6,
	25953 - 11905: 0x94A7,
	25954 - 11905: 0xB8D2,
	25955 - 11905: 0xC9A2,
	25956 - 11905: 0x94A8,
	25957 - 11905: 0x94A9,
	25958 - 11905: 0xB6D8,
	25959 - 11905: 0x94AA,
	25960 - 11905: 0x94AB,
	25961 - 11905: 0x94AC,
	25962 - 11905: 0x94AD,
	25963 - 11905: 0xEBB8,
	25964 - 11905: 0xBEB4,
	25965 - 11905: 0x94AE,
	25966 - 11905: 0x94AF,
	25967 - 11905: 0x94B0,
	25968 - 11905: 0xCAFD,
	25969 - 11905: 0x94B1,
	25970 - 11905: 0xC7C3,
	25971 - 11905: 0x94B2,
	25972 - 11905: 0xD5FB,
	25973 - 11905: 0x94B3,
	25974 - 11905: 0x94B4,
	25975 - 11905: 0xB7F3,
	25976 - 11905: 0x94B5,
	25977 - 11905: 0x94B6,
	25978 - 11905: 0x94B7,
	25979 - 11905: 0x94B8,
	25980 - 11905: 0x94B9,
	25981 - 11905: 0x94BA,
	25982 - 11905: 0x94BB,
	25983 - 11905: 0x94BC,
	25984 - 11905: 0x94BD,
	25985 - 11905: 0x94BE,
	25986 - 11905: 0x94BF,
	25987 - 11905: 0x94C0,
	25988 - 11905: 0x94C1,
	25989 - 11905: 0x94C2,
	25990 - 11905: 0x94C3,
	25991 - 11905: 0xCEC4,
	25992 - 11905: 0x94C4,
	25993 - 11905: 0x94C5,
	25994 - 11905: 0x94C6,
	25995 - 11905: 0xD5AB,
	25996 - 11905: 0xB1F3,
	25997 - 11905: 0x94C7,
	25998 - 11905: 0x94C8,
	25999 - 11905: 0x94C9,
	26000 - 11905: 0xECB3,
	26001 - 11905: 0xB0DF,
	26002 - 11905: 0x94CA,
	26003 - 11905: 0xECB5,
	26004 - 11905: 0x94CB,
	26005 - 11905: 0x94CC,
	26006 - 11905: 0x94CD,
	26007 - 11905: 0xB6B7,
	26008 - 11905: 0x94CE,
	26009 - 11905: 0xC1CF,
	26010 - 11905: 0x94CF,
	26011 - 11905: 0xF5FA,
	26012 - 11905: 0xD0B1,
	26013 - 11905: 0x94D0,
	26014 - 11905: 0x94D1,
	26015 - 11905: 0xD5E5,
	26016 - 11905: 0x94D2,
	26017 - 11905: 0xCED3,
	26018 - 11905: 0x94D3,
	26019 - 11905: 0x94D4,
	26020 - 11905: 0xBDEF,
	26021 - 11905: 0xB3E2,
	26022 - 11905: 0x94D5,
	26023 - 11905: 0xB8AB,
	26024 - 11905: 0x94D6,
	26025 - 11905: 0xD5B6,
	26026 - 11905: 0x94D7,
	26027 - 11905: 0xEDBD,
	26028 - 11905: 0x94D8,
	26029 - 11905: 0xB6CF,
	26030 - 11905: 0x94D9,
	26031 - 11905: 0xCBB9,
	26032 - 11905: 0xD0C2,
	26033 - 11905: 0x94DA,
	26034 - 11905: 0x94DB,
	26035 - 11905: 0x94DC,
	26036 - 11905: 0x94DD,
	26037 - 11905: 0x94DE,
	26038 - 11905: 0x94DF,
	26039 - 11905: 0x94E0,
	26040 - 11905: 0x94E1,
	26041 - 11905: 0xB7BD,
	26042 - 11905: 0x94E2,
	26043 - 11905: 0x94E3,
	26044 - 11905: 0xECB6,
	26045 - 11905: 0xCAA9,
	26046 - 11905: 0x94E4,
	26047 - 11905: 0x94E5,
	26048 - 11905: 0x94E6,
	26049 - 11905: 0xC5D4,
	26050 - 11905: 0x94E7,
	26051 - 11905: 0xECB9,
	26052 - 11905: 0xECB8,
	26053 - 11905: 0xC2C3,
	26054 - 11905: 0xECB7,
	26055 - 11905: 0x94E8,
	26056 - 11905: 0x94E9,
	26057 - 11905: 0x94EA,
	26058 - 11905: 0x94EB,
	26059 - 11905: 0xD0FD,
	26060 - 11905: 0xECBA,
	26061 - 11905: 0x94EC,
	26062 - 11905: 0xECBB,
	26063 - 11905: 0xD7E5,
	26064 - 11905: 0x94ED,
	26065 - 11905: 0x94EE,
	26066 - 11905: 0xECBC,
	26067 - 11905: 0x94EF,
	26068 - 11905: 0x94F0,
	26069 - 11905: 0x94F1,
	26070 - 11905: 0xECBD,
	26071 - 11905: 0xC6EC,
	26072 - 11905: 0x94F2,
	26073 - 11905: 0x94F3,
	26074 - 11905: 0x94F4,
	26075 - 11905: 0x94F5,
	26076 - 11905: 0x94F6,
	26077 - 11905: 0x94F7,
	26078 - 11905: 0x94F8,
	26079 - 11905: 0x94F9,
	26080 - 11905: 0xCEDE,
	26081 - 11905: 0x94FA,
	26082 - 11905: 0xBCC8,
	26083 - 11905: 0x94FB,
	26084 - 11905: 0x94FC,
	26085 - 11905: 0xC8D5,
	26086 - 11905: 0xB5A9,
	26087 - 11905: 0xBEC9,
	26088 - 11905: 0xD6BC,
	26089 - 11905: 0xD4E7,
	26090 - 11905: 0x94FD,
	26091 - 11905: 0x94FE,
	26092 - 11905: 0xD1AE,
	26093 - 11905: 0xD0F1,
	26094 - 11905: 0xEAB8,
	26095 - 11905: 0xEAB9,
	26096 - 11905: 0xEABA,
	26097 - 11905: 0xBAB5,
	26098 - 11905: 0x9540,
	26099 - 11905: 0x9541,
	26100 - 11905: 0x9542,
	26101 - 11905: 0x9543,
	26102 - 11905: 0xCAB1,
	26103 - 11905: 0xBFF5,
	26104 - 11905: 0x9544,
	26105 - 11905: 0x9545,
	26106 - 11905: 0xCDFA,
	26107 - 11905: 0x9546,
	26108 - 11905: 0x9547,
	26109 - 11905: 0x9548,
	26110 - 11905: 0x9549,
	26111 - 11905: 0x954A,
	26112 - 11905: 0xEAC0,
	26113 - 11905: 0x954B,
	26114 - 11905: 0xB0BA,
	26115 - 11905: 0xEABE,
	26116 - 11905: 0x954C,
	26117 - 11905: 0x954D,
	26118 - 11905: 0xC0A5,
	26119 - 11905: 0x954E,
	26120 - 11905: 0x954F,
	26121 - 11905: 0x9550,
	26122 - 11905: 0xEABB,
	26123 - 11905: 0x9551,
	26124 - 11905: 0xB2FD,
	26125 - 11905: 0x9552,
	26126 - 11905: 0xC3F7,
	26127 - 11905: 0xBBE8,
	26128 - 11905: 0x9553,
	26129 - 11905: 0x9554,
	26130 - 11905: 0x9555,
	26131 - 11905: 0xD2D7,
	26132 - 11905: 0xCEF4,
	26133 - 11905: 0xEABF,
	26134 - 11905: 0x9556,
	26135 - 11905: 0x9557,
	26136 - 11905: 0x9558,
	26137 - 11905: 0xEABC,
	26138 - 11905: 0x9559,
	26139 - 11905: 0x955A,
	26140 - 11905: 0x955B,
	26141 - 11905: 0xEAC3,
	26142 - 11905: 0x955C,
	26143 - 11905: 0xD0C7,
	26144 - 11905: 0xD3B3,
	26145 - 11905: 0x955D,
	26146 - 11905: 0x955E,
	26147 - 11905: 0x955F,
	26148 - 11905: 0x9560,
	26149 - 11905: 0xB4BA,
	26150 - 11905: 0x9561,
	26151 - 11905: 0xC3C1,
	26152 - 11905: 0xD7F2,
	26153 - 11905: 0x9562,
	26154 - 11905: 0x9563,
	26155 - 11905: 0x9564,
	26156 - 11905: 0x9565,
	26157 - 11905: 0xD5D1,
	26158 - 11905: 0x9566,
	26159 - 11905: 0xCAC7,
	26160 - 11905: 0x9567,
	26161 - 11905: 0xEAC5,
	26162 - 11905: 0x9568,
	26163 - 11905: 0x9569,
	26164 - 11905: 0xEAC4,
	26165 - 11905: 0xEAC7,
	26166 - 11905: 0xEAC6,
	26167 - 11905: 0x956A,
	26168 - 11905: 0x956B,
	26169 - 11905: 0x956C,
	26170 - 11905: 0x956D,
	26171 - 11905: 0x956E,
	26172 - 11905: 0xD6E7,
	26173 - 11905: 0x956F,
	26174 - 11905: 0xCFD4,
	26175 - 11905: 0x9570,
	26176 - 11905: 0x9571,
	26177 - 11905: 0xEACB,
	26178 - 11905: 0x9572,
	26179 - 11905: 0xBBCE,
	26180 - 11905: 0x9573,
	26181 - 11905: 0x9574,
	26182 - 11905: 0x9575,
	26183 - 11905: 0x9576,
	26184 - 11905: 0x9577,
	26185 - 11905: 0x9578,
	26186 - 11905: 0x9579,
	26187 - 11905: 0xBDFA,
	26188 - 11905: 0xC9CE,
	26189 - 11905: 0x957A,
	26190 - 11905: 0x957B,
	26191 - 11905: 0xEACC,
	26192 - 11905: 0x957C,
	26193 - 11905: 0x957D,
	26194 - 11905: 0xC9B9,
	26195 - 11905: 0xCFFE,
	26196 - 11905: 0xEACA,
	26197 - 11905: 0xD4CE,
	26198 - 11905: 0xEACD,
	26199 - 11905: 0xEACF,
	26200 - 11905: 0x957E,
	26201 - 11905: 0x9580,
	26202 - 11905: 0xCDED,
	26203 - 11905: 0x9581,
	26204 - 11905: 0x9582,
	26205 - 11905: 0x9583,
	26206 - 11905: 0x9584,
	26207 - 11905: 0xEAC9,
	26208 - 11905: 0x9585,
	26209 - 11905: 0xEACE,
	26210 - 11905: 0x9586,
	26211 - 11905: 0x9587,
	26212 - 11905: 0xCEEE,
	26213 - 11905: 0x9588,
	26214 - 11905: 0xBBDE,
	26215 - 11905: 0x9589,
	26216 - 11905: 0xB3BF,
	26217 - 11905: 0x958A,
	26218 - 11905: 0x958B,
	26219 - 11905: 0x958C,
	26220 - 11905: 0x958D,
	26221 - 11905: 0x958E,
	26222 - 11905: 0xC6D5,
	26223 - 11905: 0xBEB0,
	26224 - 11905: 0xCEFA,
	26225 - 11905: 0x958F,
	26226 - 11905: 0x9590,
	26227 - 11905: 0x9591,
	26228 - 11905: 0xC7E7,
	26229 - 11905: 0x9592,
	26230 - 11905: 0xBEA7,
	26231 - 11905: 0xEAD0,
	26232 - 11905: 0x9593,
	26233 - 11905: 0x9594,
	26234 - 11905: 0xD6C7,
	26235 - 11905: 0x9595,
	26236 - 11905: 0x9596,
	26237 - 11905: 0x9597,
	26238 - 11905: 0xC1C0,
	26239 - 11905: 0x9598,
	26240 - 11905: 0x9599,
	26241 - 11905: 0x959A,
	26242 - 11905: 0xD4DD,
	26243 - 11905: 0x959B,
	26244 - 11905: 0xEAD1,
	26245 - 11905: 0x959C,
	26246 - 11905: 0x959D,
	26247 - 11905: 0xCFBE,
	26248 - 11905: 0x959E,
	26249 - 11905: 0x959F,
	26250 - 11905: 0x95A0,
	26251 - 11905: 0x95A1,
	26252 - 11905: 0xEAD2,
	26253 - 11905: 0x95A2,
	26254 - 11905: 0x95A3,
	26255 - 11905: 0x95A4,
	26256 - 11905: 0x95A5,
	26257 - 11905: 0xCAEE,
	26258 - 11905: 0x95A6,
	26259 - 11905: 0x95A7,
	26260 - 11905: 0x95A8,
	26261 - 11905: 0x95A9,
	26262 - 11905: 0xC5AF,
	26263 - 11905: 0xB0B5,
	26264 - 11905: 0x95AA,
	26265 - 11905: 0x95AB,
	26266 - 11905: 0x95AC,
	26267 - 11905: 0x95AD,
	26268 - 11905: 0x95AE,
	26269 - 11905: 0xEAD4,
	26270 - 11905: 0x95AF,
	26271 - 11905: 0x95B0,
	26272 - 11905: 0x95B1,
	26273 - 11905: 0x95B2,
	26274 - 11905: 0x95B3,
	26275 - 11905: 0x95B4,
	26276 - 11905: 0x95B5,
	26277 - 11905: 0x95B6,
	26278 - 11905: 0x95B7,
	26279 - 11905: 0xEAD3,
	26280 - 11905: 0xF4DF,
	26281 - 11905: 0x95B8,
	26282 - 11905: 0x95B9,
	26283 - 11905: 0x95BA,
	26284 - 11905: 0x95BB,
	26285 - 11905: 0x95BC,
	26286 - 11905: 0xC4BA,
	26287 - 11905: 0x95BD,
	26288 - 11905: 0x95BE,
	26289 - 11905: 0x95BF,
	26290 - 11905: 0x95C0,
	26291 - 11905: 0x95C1,
	26292 - 11905: 0xB1A9,
	26293 - 11905: 0x95C2,
	26294 - 11905: 0x95C3,
	26295 - 11905: 0x95C4,
	26296 - 11905: 0x95C5,
	26297 - 11905: 0xE5DF,
	26298 - 11905: 0x95C6,
	26299 - 11905: 0x95C7,
	26300 - 11905: 0x95C8,
	26301 - 11905: 0x95C9,
	26302 - 11905: 0xEAD5,
	26303 - 11905: 0x95CA,
	26304 - 11905: 0x95CB,
	26305 - 11905: 0x95CC,
	26306 - 11905: 0x95CD,
	26307 - 11905: 0x95CE,
	26308 - 11905: 0x95CF,
	26309 - 11905: 0x95D0,
	26310 - 11905: 0x95D1,
	26311 - 11905: 0x95D2,
	26312 - 11905: 0x95D3,
	26313 - 11905: 0x95D4,
	26314 - 11905: 0x95D5,
	26315 - 11905: 0x95D6,
	26316 - 11905: 0x95D7,
	26317 - 11905: 0x95D8,
	26318 - 11905: 0x95D9,
	26319 - 11905: 0x95DA,
	26320 - 11905: 0x95DB,
	26321 - 11905: 0x95DC,
	26322 - 11905: 0x95DD,
	26323 - 11905: 0x95DE,
	26324 - 11905: 0x95DF,
	26325 - 11905: 0x95E0,
	26326 - 11905: 0x95E1,
	26327 - 11905: 0x95E2,
	26328 - 11905: 0x95E3,
	26329 - 11905: 0xCAEF,
	26330 - 11905: 0x95E4,
	26331 - 11905: 0xEAD6,
	26332 - 11905: 0xEAD7,
	26333 - 11905: 0xC6D8,
	26334 - 11905: 0x95E5,
	26335 - 11905: 0x95E6,
	26336 - 11905: 0x95E7,
	26337 - 11905: 0x95E8,
	26338 - 11905: 0x95E9,
	26339 - 11905: 0x95EA,
	26340 - 11905: 0x95EB,
	26341 - 11905: 0x95EC,
	26342 - 11905: 0xEAD8,
	26343 - 11905: 0x95ED,
	26344 - 11905: 0x95EE,
	26345 - 11905: 0xEAD9,
	26346 - 11905: 0x95EF,
	26347 - 11905: 0x95F0,
	26348 - 11905: 0x95F1,
	26349 - 11905: 0x95F2,
	26350 - 11905: 0x95F3,
	26351 - 11905: 0x95F4,
	26352 - 11905: 0xD4BB,
	26353 - 11905: 0x95F5,
	26354 - 11905: 0xC7FA,
	26355 - 11905: 0xD2B7,
	26356 - 11905: 0xB8FC,
	26357 - 11905: 0x95F6,
	26358 - 11905: 0x95F7,
	26359 - 11905: 0xEAC2,
	26360 - 11905: 0x95F8,
	26361 - 11905: 0xB2DC,
	26362 - 11905: 0x95F9,
	26363 - 11905: 0x95FA,
	26364 - 11905: 0xC2FC,
	26365 - 11905: 0x95FB,
	26366 - 11905: 0xD4F8,
	26367 - 11905: 0xCCE6,
	26368 - 11905: 0xD7EE,
	26369 - 11905: 0x95FC,
	26370 - 11905: 0x95FD,
	26371 - 11905: 0x95FE,
	26372 - 11905: 0x9640,
	26373 - 11905: 0x9641,
	26374 - 11905: 0x9642,
	26375 - 11905: 0x9643,
	26376 - 11905: 0xD4C2,
	26377 - 11905: 0xD3D0,
	26378 - 11905: 0xEBC3,
	26379 - 11905: 0xC5F3,
	26380 - 11905: 0x9644,
	26381 - 11905: 0xB7FE,
	26382 - 11905: 0x9645,
	26383 - 11905: 0x9646,
	26384 - 11905: 0xEBD4,
	26385 - 11905: 0x9647,
	26386 - 11905: 0x9648,
	26387 - 11905: 0x9649,
	26388 - 11905: 0xCBB7,
	26389 - 11905: 0xEBDE,
	26390 - 11905: 0x964A,
	26391 - 11905: 0xC0CA,
	26392 - 11905: 0x964B,
	26393 - 11905: 0x964C,
	26394 - 11905: 0x964D,
	26395 - 11905: 0xCDFB,
	26396 - 11905: 0x964E,
	26397 - 11905: 0xB3AF,
	26398 - 11905: 0x964F,
	26399 - 11905: 0xC6DA,
	26400 - 11905: 0x9650,
	26401 - 11905: 0x9651,
	26402 - 11905: 0x9652,
	26403 - 11905: 0x9653,
	26404 - 11905: 0x9654,
	26405 - 11905: 0x9655,
	26406 - 11905: 0xEBFC,
	26407 - 11905: 0x9656,
	26408 - 11905: 0xC4BE,
	26409 - 11905: 0x9657,
	26410 - 11905: 0xCEB4,
	26411 - 11905: 0xC4A9,
	26412 - 11905: 0xB1BE,
	26413 - 11905: 0xD4FD,
	26414 - 11905: 0x9658,
	26415 - 11905: 0xCAF5,
	26416 - 11905: 0x9659,
	26417 - 11905: 0xD6EC,
	26418 - 11905: 0x965A,
	26419 - 11905: 0x965B,
	26420 - 11905: 0xC6D3,
	26421 - 11905: 0xB6E4,
	26422 - 11905: 0x965C,
	26423 - 11905: 0x965D,
	26424 - 11905: 0x965E,
	26425 - 11905: 0x965F,
	26426 - 11905: 0xBBFA,
	26427 - 11905: 0x9660,
	26428 - 11905: 0x9661,
	26429 - 11905: 0xD0E0,
	26430 - 11905: 0x9662,
	26431 - 11905: 0x9663,
	26432 - 11905: 0xC9B1,
	26433 - 11905: 0x9664,
	26434 - 11905: 0xD4D3,
	26435 - 11905: 0xC8A8,
	26436 - 11905: 0x9665,
	26437 - 11905: 0x9666,
	26438 - 11905: 0xB8CB,
	26439 - 11905: 0x9667,
	26440 - 11905: 0xE8BE,
	26441 - 11905: 0xC9BC,
	26442 - 11905: 0x9668,
	26443 - 11905: 0x9669,
	26444 - 11905: 0xE8BB,
	26445 - 11905: 0x966A,
	26446 - 11905: 0xC0EE,
	26447 - 11905: 0xD0D3,
	26448 - 11905: 0xB2C4,
	26449 - 11905: 0xB4E5,
	26450 - 11905: 0x966B,
	26451 - 11905: 0xE8BC,
	26452 - 11905: 0x966C,
	26453 - 11905: 0x966D,
	26454 - 11905: 0xD5C8,
	26455 - 11905: 0x966E,
	26456 - 11905: 0x966F,
	26457 - 11905: 0x9670,
	26458 - 11905: 0x9671,
	26459 - 11905: 0x9672,
	26460 - 11905: 0xB6C5,
	26461 - 11905: 0x9673,
	26462 - 11905: 0xE8BD,
	26463 - 11905: 0xCAF8,
	26464 - 11905: 0xB8DC,
	26465 - 11905: 0xCCF5,
	26466 - 11905: 0x9674,
	26467 - 11905: 0x9675,
	26468 - 11905: 0x9676,
	26469 - 11905: 0xC0B4,
	26470 - 11905: 0x9677,
	26471 - 11905: 0x9678,
	26472 - 11905: 0xD1EE,
	26473 - 11905: 0xE8BF,
	26474 - 11905: 0xE8C2,
	26475 - 11905: 0x9679,
	26476 - 11905: 0x967A,
	26477 - 11905: 0xBABC,
	26478 - 11905: 0x967B,
	26479 - 11905: 0xB1AD,
	26480 - 11905: 0xBDDC,
	26481 - 11905: 0x967C,
	26482 - 11905: 0xEABD,
	26483 - 11905: 0xE8C3,
	26484 - 11905: 0x967D,
	26485 - 11905: 0xE8C6,
	26486 - 11905: 0x967E,
	26487 - 11905: 0xE8CB,
	26488 - 11905: 0x9680,
	26489 - 11905: 0x9681,
	26490 - 11905: 0x9682,
	26491 - 11905: 0x9683,
	26492 - 11905: 0xE8CC,
	26493 - 11905: 0x9684,
	26494 - 11905: 0xCBC9,
	26495 - 11905: 0xB0E5,
	26496 - 11905: 0x9685,
	26497 - 11905: 0xBCAB,
	26498 - 11905: 0x9686,
	26499 - 11905: 0x9687,
	26500 - 11905: 0xB9B9,
	26501 - 11905: 0x9688,
	26502 - 11905: 0x9689,
	26503 - 11905: 0xE8C1,
	26504 - 11905: 0x968A,
	26505 - 11905: 0xCDF7,
	26506 - 11905: 0x968B,
	26507 - 11905: 0xE8CA,
	26508 - 11905: 0x968C,
	26509 - 11905: 0x968D,
	26510 - 11905: 0x968E,
	26511 - 11905: 0x968F,
	26512 - 11905: 0xCEF6,
	26513 - 11905: 0x9690,
	26514 - 11905: 0x9691,
	26515 - 11905: 0x9692,
	26516 - 11905: 0x9693,
	26517 - 11905: 0xD5ED,
	26518 - 11905: 0x9694,
	26519 - 11905: 0xC1D6,
	26520 - 11905: 0xE8C4,
	26521 - 11905: 0x9695,
	26522 - 11905: 0xC3B6,
	26523 - 11905: 0x9696,
	26524 - 11905: 0xB9FB,
	26525 - 11905: 0xD6A6,
	26526 - 11905: 0xE8C8,
	26527 - 11905: 0x9697,
	26528 - 11905: 0x9698,
	26529 - 11905: 0x9699,
	26530 - 11905: 0xCAE0,
	26531 - 11905: 0xD4E6,
	26532 - 11905: 0x969A,
	26533 - 11905: 0xE8C0,
	26534 - 11905: 0x969B,
	26535 - 11905: 0xE8C5,
	26536 - 11905: 0xE8C7,
	26537 - 11905: 0x969C,
	26538 - 11905: 0xC7B9,
	26539 - 11905: 0xB7E3,
	26540 - 11905: 0x969D,
	26541 - 11905: 0xE8C9,
	26542 - 11905: 0x969E,
	26543 - 11905: 0xBFDD,
	26544 - 11905: 0xE8D2,
	26545 - 11905: 0x969F,
	26546 - 11905: 0x96A0,
	26547 - 11905: 0xE8D7,
	26548 - 11905: 0x96A1,
	26549 - 11905: 0xE8D5,
	26550 - 11905: 0xBCDC,
	26551 - 11905: 0xBCCF,
	26552 - 11905: 0xE8DB,
	26553 - 11905: 0x96A2,
	26554 - 11905: 0x96A3,
	26555 - 11905: 0x96A4,
	26556 - 11905: 0x96A5,
	26557 - 11905: 0x96A6,
	26558 - 11905: 0x96A7,
	26559 - 11905: 0x96A8,
	26560 - 11905: 0x96A9,
	26561 - 11905: 0xE8DE,
	26562 - 11905: 0x96AA,
	26563 - 11905: 0xE8DA,
	26564 - 11905: 0xB1FA,
	26565 - 11905: 0x96AB,
	26566 - 11905: 0x96AC,
	26567 - 11905: 0x96AD,
	26568 - 11905: 0x96AE,
	26569 - 11905: 0x96AF,
	26570 - 11905: 0x96B0,
	26571 - 11905: 0x96B1,
	26572 - 11905: 0x96B2,
	26573 - 11905: 0x96B3,
	26574 - 11905: 0x96B4,
	26575 - 11905: 0xB0D8,
	26576 - 11905: 0xC4B3,
	26577 - 11905: 0xB8CC,
	26578 - 11905: 0xC6E2,
	26579 - 11905: 0xC8BE,
	26580 - 11905: 0xC8E1,
	26581 - 11905: 0x96B5,
	26582 - 11905: 0x96B6,
	26583 - 11905: 0x96B7,
	26584 - 11905: 0xE8CF,
	26585 - 11905: 0xE8D4,
	26586 - 11905: 0xE8D6,
	26587 - 11905: 0x96B8,
	26588 - 11905: 0xB9F1,
	26589 - 11905: 0xE8D8,
	26590 - 11905: 0xD7F5,
	26591 - 11905: 0x96B9,
	26592 - 11905: 0xC4FB,
	26593 - 11905: 0x96BA,
	26594 - 11905: 0xE8DC,
	26595 - 11905: 0x96BB,
	26596 - 11905: 0x96BC,
	26597 - 11905: 0xB2E9,
	26598 - 11905: 0x96BD,
	26599 - 11905: 0x96BE,
	26600 - 11905: 0x96BF,
	26601 - 11905: 0xE8D1,
	26602 - 11905: 0x96C0,
	26603 - 11905: 0x96C1,
	26604 - 11905: 0xBCED,
	26605 - 11905: 0x96C2,
	26606 - 11905: 0x96C3,
	26607 - 11905: 0xBFC2,
	26608 - 11905: 0xE8CD,
	26609 - 11905: 0xD6F9,
	26610 - 11905: 0x96C4,
	26611 - 11905: 0xC1F8,
	26612 - 11905: 0xB2F1,
	26613 - 11905: 0x96C5,
	26614 - 11905: 0x96C6,
	26615 - 11905: 0x96C7,
	26616 - 11905: 0x96C8,
	26617 - 11905: 0x96C9,
	26618 - 11905: 0x96CA,
	26619 - 11905: 0x96CB,
	26620 - 11905: 0x96CC,
	26621 - 11905: 0xE8DF,
	26622 - 11905: 0x96CD,
	26623 - 11905: 0xCAC1,
	26624 - 11905: 0xE8D9,
	26625 - 11905: 0x96CE,
	26626 - 11905: 0x96CF,
	26627 - 11905: 0x96D0,
	26628 - 11905: 0x96D1,
	26629 - 11905: 0xD5A4,
	26630 - 11905: 0x96D2,
	26631 - 11905: 0xB1EA,
	26632 - 11905: 0xD5BB,
	26633 - 11905: 0xE8CE,
	26634 - 11905: 0xE8D0,
	26635 - 11905: 0xB6B0,
	26636 - 11905: 0xE8D3,
	26637 - 11905: 0x96D3,
	26638 - 11905: 0xE8DD,
	26639 - 11905: 0xC0B8,
	26640 - 11905: 0x96D4,
	26641 - 11905: 0xCAF7,
	26642 - 11905: 0x96D5,
	26643 - 11905: 0xCBA8,
	26644 - 11905: 0x96D6,
	26645 - 11905: 0x96D7,
	26646 - 11905: 0xC6DC,
	26647 - 11905: 0xC0F5,
	26648 - 11905: 0x96D8,
	26649 - 11905: 0x96D9,
	26650 - 11905: 0x96DA,
	26651 - 11905: 0x96DB,
	26652 - 11905: 0x96DC,
	26653 - 11905: 0xE8E9,
	26654 - 11905: 0x96DD,
	26655 - 11905: 0x96DE,
	26656 - 11905: 0x96DF,
	26657 - 11905: 0xD0A3,
	26658 - 11905: 0x96E0,
	26659 - 11905: 0x96E1,
	26660 - 11905: 0x96E2,
	26661 - 11905: 0x96E3,
	26662 - 11905: 0x96E4,
	26663 - 11905: 0x96E5,
	26664 - 11905: 0x96E6,
	26665 - 11905: 0xE8F2,
	26666 - 11905: 0xD6EA,
	26667 - 11905: 0x96E7,
	26668 - 11905: 0x96E8,
	26669 - 11905: 0x96E9,
	26670 - 11905: 0x96EA,
	26671 - 11905: 0x96EB,
	26672 - 11905: 0x96EC,
	26673 - 11905: 0x96ED,
	26674 - 11905: 0xE8E0,
	26675 - 11905: 0xE8E1,
	26676 - 11905: 0x96EE,
	26677 - 11905: 0x96EF,
	26678 - 11905: 0x96F0,
	26679 - 11905: 0xD1F9,
	26680 - 11905: 0xBACB,
	26681 - 11905: 0xB8F9,
	26682 - 11905: 0x96F1,
	26683 - 11905: 0x96F2,
	26684 - 11905: 0xB8F1,
	26685 - 11905: 0xD4D4,
	26686 - 11905: 0xE8EF,
	26687 - 11905: 0x96F3,
	26688 - 11905: 0xE8EE,
	26689 - 11905: 0xE8EC,
	26690 - 11905: 0xB9F0,
	26691 - 11905: 0xCCD2,
	26692 - 11905: 0xE8E6,
	26693 - 11905: 0xCEA6,
	26694 - 11905: 0xBFF2,
	26695 - 11905: 0x96F4,
	26696 - 11905: 0xB0B8,
	26697 - 11905: 0xE8F1,
	26698 - 11905: 0xE8F0,
	26699 - 11905: 0x96F5,
	26700 - 11905: 0xD7C0,
	26701 - 11905: 0x96F6,
	26702 - 11905: 0xE8E4,
	26703 - 11905: 0x96F7,
	26704 - 11905: 0xCDA9,
	26705 - 11905: 0xC9A3,
	26706 - 11905: 0x96F8,
	26707 - 11905: 0xBBB8,
	26708 - 11905: 0xBDDB,
	26709 - 11905: 0xE8EA,
	26710 - 11905: 0x96F9,
	26711 - 11905: 0x96FA,
	26712 - 11905: 0x96FB,
	26713 - 11905: 0x96FC,
	26714 - 11905: 0x96FD,
	26715 - 11905: 0x96FE,
	26716 - 11905: 0x9740,
	26717 - 11905: 0x9741,
	26718 - 11905: 0x9742,
	26719 - 11905: 0x9743,
	26720 - 11905: 0xE8E2,
	26721 - 11905: 0xE8E3,
	26722 - 11905: 0xE8E5,
	26723 - 11905: 0xB5B5,
	26724 - 11905: 0xE8E7,
	26725 - 11905: 0xC7C5,
	26726 - 11905: 0xE8EB,
	26727 - 11905: 0xE8ED,
	26728 - 11905: 0xBDB0,
	26729 - 11905: 0xD7AE,
	26730 - 11905: 0x9744,
	26731 - 11905: 0xE8F8,
	26732 - 11905: 0x9745,
	26733 - 11905: 0x9746,
	26734 - 11905: 0x9747,
	26735 - 11905: 0x9748,
	26736 - 11905: 0x9749,
	26737 - 11905: 0x974A,
	26738 - 11905: 0x974B,
	26739 - 11905: 0x974C,
	26740 - 11905: 0xE8F5,
	26741 - 11905: 0x974D,
	26742 - 11905: 0xCDB0,
	26743 - 11905: 0xE8F6,
	26744 - 11905: 0x974E,
	26745 - 11905: 0x974F,
	26746 - 11905: 0x9750,
	26747 - 11905: 0x9751,
	26748 - 11905: 0x9752,
	26749 - 11905: 0x9753,
	26750 - 11905: 0x9754,
	26751 - 11905: 0x9755,
	26752 - 11905: 0x9756,
	26753 - 11905: 0xC1BA,
	26754 - 11905: 0x9757,
	26755 - 11905: 0xE8E8,
	26756 - 11905: 0x9758,
	26757 - 11905: 0xC3B7,
	26758 - 11905: 0xB0F0,
	26759 - 11905: 0x9759,
	26760 - 11905: 0x975A,
	26761 - 11905: 0x975B,
	26762 - 11905: 0x975C,
	26763 - 11905: 0x975D,
	26764 - 11905: 0x975E,
	26765 - 11905: 0x975F,
	26766 - 11905: 0x9760,
	26767 - 11905: 0xE8F4,
	26768 - 11905: 0x9761,
	26769 - 11905: 0x9762,
	26770 - 11905: 0x9763,
	26771 - 11905: 0xE8F7,
	26772 - 11905: 0x9764,
	26773 - 11905: 0x9765,
	26774 - 11905: 0x9766,
	26775 - 11905: 0xB9A3,
	26776 - 11905: 0x9767,
	26777 - 11905: 0x9768,
	26778 - 11905: 0x9769,
	26779 - 11905: 0x976A,
	26780 - 11905: 0x976B,
	26781 - 11905: 0x976C,
	26782 - 11905: 0x976D,
	26783 - 11905: 0x976E,
	26784 - 11905: 0x976F,
	26785 - 11905: 0x9770,
	26786 - 11905: 0xC9D2,
	26787 - 11905: 0x9771,
	26788 - 11905: 0x9772,
	26789 - 11905: 0x9773,
	26790 - 11905: 0xC3CE,
	26791 - 11905: 0xCEE0,
	26792 - 11905: 0xC0E6,
	26793 - 11905: 0x9774,
	26794 - 11905: 0x9775,
	26795 - 11905: 0x9776,
	26796 - 11905: 0x9777,
	26797 - 11905: 0xCBF3,
	26798 - 11905: 0x9778,
	26799 - 11905: 0xCCDD,
	26800 - 11905: 0xD0B5,
	26801 - 11905: 0x9779,
	26802 - 11905: 0x977A,
	26803 - 11905: 0xCAE1,
	26804 - 11905: 0x977B,
	26805 - 11905: 0xE8F3,
	26806 - 11905: 0x977C,
	26807 - 11905: 0x977D,
	26808 - 11905: 0x977E,
	26809 - 11905: 0x9780,
	26810 - 11905: 0x9781,
	26811 - 11905: 0x9782,
	26812 - 11905: 0x9783,
	26813 - 11905: 0x9784,
	26814 - 11905: 0x9785,
	26815 - 11905: 0x9786,
	26816 - 11905: 0xBCEC,
	26817 - 11905: 0x9787,
	26818 - 11905: 0xE8F9,
	26819 - 11905: 0x9788,
	26820 - 11905: 0x9789,
	26821 - 11905: 0x978A,
	26822 - 11905: 0x978B,
	26823 - 11905: 0x978C,
	26824 - 11905: 0x978D,
	26825 - 11905: 0xC3DE,
	26826 - 11905: 0x978E,
	26827 - 11905: 0xC6E5,
	26828 - 11905: 0x978F,
	26829 - 11905: 0xB9F7,
	26830 - 11905: 0x9790,
	26831 - 11905: 0x9791,
	26832 - 11905: 0x9792,
	26833 - 11905: 0x9793,
	26834 - 11905: 0xB0F4,
	26835 - 11905: 0x9794,
	26836 - 11905: 0x9795,
	26837 - 11905: 0xD7D8,
	26838 - 11905: 0x9796,
	26839 - 11905: 0x9797,
	26840 - 11905: 0xBCAC,
	26841 - 11905: 0x9798,
	26842 - 11905: 0xC5EF,
	26843 - 11905: 0x9799,
	26844 - 11905: 0x979A,
	26845 - 11905: 0x979B,
	26846 - 11905: 0x979C,
	26847 - 11905: 0x979D,
	26848 - 11905: 0xCCC4,
	26849 - 11905: 0x979E,
	26850 - 11905: 0x979F,
	26851 - 11905: 0xE9A6,
	26852 - 11905: 0x97A0,
	26853 - 11905: 0x97A1,
	26854 - 11905: 0x97A2,
	26855 - 11905: 0x97A3,
	26856 - 11905: 0x97A4,
	26857 - 11905: 0x97A5,
	26858 - 11905: 0x97A6,
	26859 - 11905: 0x97A7,
	26860 - 11905: 0x97A8,
	26861 - 11905: 0x97A9,
	26862 - 11905: 0xC9AD,
	26863 - 11905: 0x97AA,
	26864 - 11905: 0xE9A2,
	26865 - 11905: 0xC0E2,
	26866 - 11905: 0x97AB,
	26867 - 11905: 0x97AC,
	26868 - 11905: 0x97AD,
	26869 - 11905: 0xBFC3,
	26870 - 11905: 0x97AE,
	26871 - 11905: 0x97AF,
	26872 - 11905: 0x97B0,
	26873 - 11905: 0xE8FE,
	26874 - 11905: 0xB9D7,
	26875 - 11905: 0x97B1,
	26876 - 11905: 0xE8FB,
	26877 - 11905: 0x97B2,
	26878 - 11905: 0x97B3,
	26879 - 11905: 0x97B4,
	26880 - 11905: 0x97B5,
	26881 - 11905: 0xE9A4,
	26882 - 11905: 0x97B6,
	26883 - 11905: 0x97B7,
	26884 - 11905: 0x97B8,
	26885 - 11905: 0xD2CE,
	26886 - 11905: 0x97B9,
	26887 - 11905: 0x97BA,
	26888 - 11905: 0x97BB,
	26889 - 11905: 0x97BC,
	26890 - 11905: 0x97BD,
	26891 - 11905: 0xE9A3,
	26892 - 11905: 0x97BE,
	26893 - 11905: 0xD6B2,
	26894 - 11905: 0xD7B5,
	26895 - 11905: 0x97BF,
	26896 - 11905: 0xE9A7,
	26897 - 11905: 0x97C0,
	26898 - 11905: 0xBDB7,
	26899 - 11905: 0x97C1,
	26900 - 11905: 0x97C2,
	26901 - 11905: 0x97C3,
	26902 - 11905: 0x97C4,
	26903 - 11905: 0x97C5,
	26904 - 11905: 0x97C6,
	26905 - 11905: 0x97C7,
	26906 - 11905: 0x97C8,
	26907 - 11905: 0x97C9,
	26908 - 11905: 0x97CA,
	26909 - 11905: 0x97CB,
	26910 - 11905: 0x97CC,
	26911 - 11905: 0xE8FC,
	26912 - 11905: 0xE8FD,
	26913 - 11905: 0x97CD,
	26914 - 11905: 0x97CE,
	26915 - 11905: 0x97CF,
	26916 - 11905: 0xE9A1,
	26917 - 11905: 0x97D0,
	26918 - 11905: 0x97D1,
	26919 - 11905: 0x97D2,
	26920 - 11905: 0x97D3,
	26921 - 11905: 0x97D4,
	26922 - 11905: 0x97D5,
	26923 - 11905: 0x97D6,
	26924 - 11905: 0x97D7,
	26925 - 11905: 0xCDD6,
	26926 - 11905: 0x97D8,
	26927 - 11905: 0x97D9,
	26928 - 11905: 0xD2AC,
	26929 - 11905: 0x97DA,
	26930 - 11905: 0x97DB,
	26931 - 11905: 0x97DC,
	26932 - 11905: 0xE9B2,
	26933 - 11905: 0x97DD,
	26934 - 11905: 0x97DE,
	26935 - 11905: 0x97DF,
	26936 - 11905: 0x97E0,
	26937 - 11905: 0xE9A9,
	26938 - 11905: 0x97E1,
	26939 - 11905: 0x97E2,
	26940 - 11905: 0x97E3,
	26941 - 11905: 0xB4AA,
	26942 - 11905: 0x97E4,
	26943 - 11905: 0xB4BB,
	26944 - 11905: 0x97E5,
	26945 - 11905: 0x97E6,
	26946 - 11905: 0xE9AB,
	26947 - 11905: 0x97E7,
	26948 - 11905: 0x97E8,
	26949 - 11905: 0x97E9,
	26950 - 11905: 0x97EA,
	26951 - 11905: 0x97EB,
	26952 - 11905: 0x97EC,
	26953 - 11905: 0x97ED,
	26954 - 11905: 0x97EE,
	26955 - 11905: 0x97EF,
	26956 - 11905: 0x97F0,
	26957 - 11905: 0x97F1,
	26958 - 11905: 0x97F2,
	26959 - 11905: 0x97F3,
	26960 - 11905: 0x97F4,
	26961 - 11905: 0x97F5,
	26962 - 11905: 0x97F6,
	26963 - 11905: 0x97F7,
	26964 - 11905: 0xD0A8,
	26965 - 11905: 0x97F8,
	26966 - 11905: 0x97F9,
	26967 - 11905: 0xE9A5,
	26968 - 11905: 0x97FA,
	26969 - 11905: 0x97FB,
	26970 - 11905: 0xB3FE,
	26971 - 11905: 0x97FC,
	26972 - 11905: 0x97FD,
	26973 - 11905: 0xE9AC,
	26974 - 11905: 0xC0E3,
	26975 - 11905: 0x97FE,
	26976 - 11905: 0xE9AA,
	26977 - 11905: 0x9840,
	26978 - 11905: 0x9841,
	26979 - 11905: 0xE9B9,
	26980 - 11905: 0x9842,
	26981 - 11905: 0x9843,
	26982 - 11905: 0xE9B8,
	26983 - 11905: 0x9844,
	26984 - 11905: 0x9845,
	26985 - 11905: 0x9846,
	26986 - 11905: 0x9847,
	26987 - 11905: 0xE9AE,
	26988 - 11905: 0x9848,
	26989 - 11905: 0x9849,
	26990 - 11905: 0xE8FA,
	26991 - 11905: 0x984A,
	26992 - 11905: 0x984B,
	26993 - 11905: 0xE9A8,
	26994 - 11905: 0x984C,
	26995 - 11905: 0x984D,
	26996 - 11905: 0x984E,
	26997 - 11905: 0x984F,
	26998 - 11905: 0x9850,
	26999 - 11905: 0xBFAC,
	27000 - 11905: 0xE9B1,
	27001 - 11905: 0xE9BA,
	27002 - 11905: 0x9851,
	27003 - 11905: 0x9852,
	27004 - 11905: 0xC2A5,
	27005 - 11905: 0x9853,
	27006 - 11905: 0x9854,
	27007 - 11905: 0x9855,
	27008 - 11905: 0xE9AF,
	27009 - 11905: 0x9856,
	27010 - 11905: 0xB8C5,
	27011 - 11905: 0x9857,
	27012 - 11905: 0xE9AD,
	27013 - 11905: 0x9858,
	27014 - 11905: 0xD3DC,
	27015 - 11905: 0xE9B4,
	27016 - 11905: 0xE9B5,
	27017 - 11905: 0xE9B7,
	27018 - 11905: 0x9859,
	27019 - 11905: 0x985A,
	27020 - 11905: 0x985B,
	27021 - 11905: 0xE9C7,
	27022 - 11905: 0x985C,
	27023 - 11905: 0x985D,
	27024 - 11905: 0x985E,
	27025 - 11905: 0x985F,
	27026 - 11905: 0x9860,
	27027 - 11905: 0x9861,
	27028 - 11905: 0xC0C6,
	27029 - 11905: 0xE9C5,
	27030 - 11905: 0x9862,
	27031 - 11905: 0x9863,
	27032 - 11905: 0xE9B0,
	27033 - 11905: 0x9864,
	27034 - 11905: 0x9865,
	27035 - 11905: 0xE9BB,
	27036 - 11905: 0xB0F1,
	27037 - 11905: 0x9866,
	27038 - 11905: 0x9867,
	27039 - 11905: 0x9868,
	27040 - 11905: 0x9869,
	27041 - 11905: 0x986A,
	27042 - 11905: 0x986B,
	27043 - 11905: 0x986C,
	27044 - 11905: 0x986D,
	27045 - 11905: 0x986E,
	27046 - 11905: 0x986F,
	27047 - 11905: 0xE9BC,
	27048 - 11905: 0xD5A5,
	27049 - 11905: 0x9870,
	27050 - 11905: 0x9871,
	27051 - 11905: 0xE9BE,
	27052 - 11905: 0x9872,
	27053 - 11905: 0xE9BF,
	27054 - 11905: 0x9873,
	27055 - 11905: 0x9874,
	27056 - 11905: 0x9875,
	27057 - 11905: 0xE9C1,
	27058 - 11905: 0x9876,
	27059 - 11905: 0x9877,
	27060 - 11905: 0xC1F1,
	27061 - 11905: 0x9878,
	27062 - 11905: 0x9879,
	27063 - 11905: 0xC8B6,
	27064 - 11905: 0x987A,
	27065 - 11905: 0x987B,
	27066 - 11905: 0x987C,
	27067 - 11905: 0xE9BD,
	27068 - 11905: 0x987D,
	27069 - 11905: 0x987E,
	27070 - 11905: 0x9880,
	27071 - 11905: 0x9881,
	27072 - 11905: 0x9882,
	27073 - 11905: 0xE9C2,
	27074 - 11905: 0x9883,
	27075 - 11905: 0x9884,
	27076 - 11905: 0x9885,
	27077 - 11905: 0x9886,
	27078 - 11905: 0x9887,
	27079 - 11905: 0x9888,
	27080 - 11905: 0x9889,
	27081 - 11905: 0x988A,
	27082 - 11905: 0xE9C3,
	27083 - 11905: 0x988B,
	27084 - 11905: 0xE9B3,
	27085 - 11905: 0x988C,
	27086 - 11905: 0xE9B6,
	27087 - 11905: 0x988D,
	27088 - 11905: 0xBBB1,
	27089 - 11905: 0x988E,
	27090 - 11905: 0x988F,
	27091 - 11905: 0x9890,
	27092 - 11905: 0xE9C0,
	27093 - 11905: 0x9891,
	27094 - 11905: 0x9892,
	27095 - 11905: 0x9893,
	27096 - 11905: 0x9894,
	27097 - 11905: 0x9895,
	27098 - 11905: 0x9896,
	27099 - 11905: 0xBCF7,
	27100 - 11905: 0x9897,
	27101 - 11905: 0x9898,
	27102 - 11905: 0x9899,
	27103 - 11905: 0xE9C4,
	27104 - 11905: 0xE9C6,
	27105 - 11905: 0x989A,
	27106 - 11905: 0x989B,
	27107 - 11905: 0x989C,
	27108 - 11905: 0x989D,
	27109 - 11905: 0x989E,
	27110 - 11905: 0x989F,
	27111 - 11905: 0x98A0,
	27112 - 11905: 0x98A1,
	27113 - 11905: 0x98A2,
	27114 - 11905: 0x98A3,
	27115 - 11905: 0x98A4,
	27116 - 11905: 0x98A5,
	27117 - 11905: 0xE9CA,
	27118 - 11905: 0x98A6,
	27119 - 11905: 0x98A7,
	27120 - 11905: 0x98A8,
	27121 - 11905: 0x98A9,
	27122 - 11905: 0xE9CE,
	27123 - 11905: 0x98AA,
	27124 - 11905: 0x98AB,
	27125 - 11905: 0x98AC,
	27126 - 11905: 0x98AD,
	27127 - 11905: 0x98AE,
	27128 - 11905: 0x98AF,
	27129 - 11905: 0x98B0,
	27130 - 11905: 0x98B1,
	27131 - 11905: 0x98B2,
	27132 - 11905: 0x98B3,
	27133 - 11905: 0xB2DB,
	27134 - 11905: 0x98B4,
	27135 - 11905: 0xE9C8,
	27136 - 11905: 0x98B5,
	27137 - 11905: 0x98B6,
	27138 - 11905: 0x98B7,
	27139 - 11905: 0x98B8,
	27140 - 11905: 0x98B9,
	27141 - 11905: 0x98BA,
	27142 - 11905: 0x98BB,
	27143 - 11905: 0x98BC,
	27144 - 11905: 0x98BD,
	27145 - 11905: 0x98BE,
	27146 - 11905: 0xB7AE,
	27147 - 11905: 0x98BF,
	27148 - 11905: 0x98C0,
	27149 - 11905: 0x98C1,
	27150 - 11905: 0x98C2,
	27151 - 11905: 0x98C3,
	27152 - 11905: 0x98C4,
	27153 - 11905: 0x98C5,
	27154 - 11905: 0x98C6,
	27155 - 11905: 0x98C7,
	27156 - 11905: 0x98C8,
	27157 - 11905: 0x98C9,
	27158 - 11905: 0x98CA,
	27159 - 11905: 0xE9CB,
	27160 - 11905: 0xE9CC,
	27161 - 11905: 0x98CB,
	27162 - 11905: 0x98CC,
	27163 - 11905: 0x98CD,
	27164 - 11905: 0x98CE,
	27165 - 11905: 0x98CF,
	27166 - 11905: 0x98D0,
	27167 - 11905: 0xD5C1,
	27168 - 11905: 0x98D1,
	27169 - 11905: 0xC4A3,
	27170 - 11905: 0x98D2,
	27171 - 11905: 0x98D3,
	27172 - 11905: 0x98D4,
	27173 - 11905: 0x98D5,
	27174 - 11905: 0x98D6,
	27175 - 11905: 0x98D7,
	27176 - 11905: 0xE9D8,
	27177 - 11905: 0x98D8,
	27178 - 11905: 0xBAE1,
	27179 - 11905: 0x98D9,
	27180 - 11905: 0x98DA,
	27181 - 11905: 0x98DB,
	27182 - 11905: 0x98DC,
	27183 - 11905: 0xE9C9,
	27184 - 11905: 0x98DD,
	27185 - 11905: 0xD3A3,
	27186 - 11905: 0x98DE,
	27187 - 11905: 0x98DF,
	27188 - 11905: 0x98E0,
	27189 - 11905: 0xE9D4,
	27190 - 11905: 0x98E1,
	27191 - 11905: 0x98E2,
	27192 - 11905: 0x98E3,
	27193 - 11905: 0x98E4,
	27194 - 11905: 0x98E5,
	27195 - 11905: 0x98E6,
	27196 - 11905: 0x98E7,
	27197 - 11905: 0xE9D7,
	27198 - 11905: 0xE9D0,
	27199 - 11905: 0x98E8,
	27200 - 11905: 0x98E9,
	27201 - 11905: 0x98EA,
	27202 - 11905: 0x98EB,
	27203 - 11905: 0x98EC,
	27204 - 11905: 0xE9CF,
	27205 - 11905: 0x98ED,
	27206 - 11905: 0x98EE,
	27207 - 11905: 0xC7C1,
	27208 - 11905: 0x98EF,
	27209 - 11905: 0x98F0,
	27210 - 11905: 0x98F1,
	27211 - 11905: 0x98F2,
	27212 - 11905: 0x98F3,
	27213 - 11905: 0x98F4,
	27214 - 11905: 0x98F5,
	27215 - 11905: 0x98F6,
	27216 - 11905: 0xE9D2,
	27217 - 11905: 0x98F7,
	27218 - 11905: 0x98F8,
	27219 - 11905: 0x98F9,
	27220 - 11905: 0x98FA,
	27221 - 11905: 0x98FB,
	27222 - 11905: 0x98FC,
	27223 - 11905: 0x98FD,
	27224 - 11905: 0xE9D9,
	27225 - 11905: 0xB3C8,
	27226 - 11905: 0x98FE,
	27227 - 11905: 0xE9D3,
	27228 - 11905: 0x9940,
	27229 - 11905: 0x9941,
	27230 - 11905: 0x9942,
	27231 - 11905: 0x9943,
	27232 - 11905: 0x9944,
	27233 - 11905: 0xCFF0,
	27234 - 11905: 0x9945,
	27235 - 11905: 0x9946,
	27236 - 11905: 0x9947,
	27237 - 11905: 0xE9CD,
	27238 - 11905: 0x9948,
	27239 - 11905: 0x9949,
	27240 - 11905: 0x994A,
	27241 - 11905: 0x994B,
	27242 - 11905: 0x994C,
	27243 - 11905: 0x994D,
	27244 - 11905: 0x994E,
	27245 - 11905: 0x994F,
	27246 - 11905: 0x9950,
	27247 - 11905: 0x9951,
	27248 - 11905: 0x9952,
	27249 - 11905: 0xB3F7,
	27250 - 11905: 0x9953,
	27251 - 11905: 0x9954,
	27252 - 11905: 0x9955,
	27253 - 11905: 0x9956,
	27254 - 11905: 0x9957,
	27255 - 11905: 0x9958,
	27256 - 11905: 0x9959,
	27257 - 11905: 0xE9D6,
	27258 - 11905: 0x995A,
	27259 - 11905: 0x995B,
	27260 - 11905: 0xE9DA,
	27261 - 11905: 0x995C,
	27262 - 11905: 0x995D,
	27263 - 11905: 0x995E,
	27264 - 11905: 0xCCB4,
	27265 - 11905: 0x995F,
	27266 - 11905: 0x9960,
	27267 - 11905: 0x9961,
	27268 - 11905: 0xCFAD,
	27269 - 11905: 0x9962,
	27270 - 11905: 0x9963,
	27271 - 11905: 0x9964,
	27272 - 11905: 0x9965,
	27273 - 11905: 0x9966,
	27274 - 11905: 0x9967,
	27275 - 11905: 0x9968,
	27276 - 11905: 0x9969,
	27277 - 11905: 0x996A,
	27278 - 11905: 0xE9D5,
	27279 - 11905: 0x996B,
	27280 - 11905: 0xE9DC,
	27281 - 11905: 0xE9DB,
	27282 - 11905: 0x996C,
	27283 - 11905: 0x996D,
	27284 - 11905: 0x996E,
	27285 - 11905: 0x996F,
	27286 - 11905: 0x9970,
	27287 - 11905: 0xE9DE,
	27288 - 11905: 0x9971,
	27289 - 11905: 0x9972,
	27290 - 11905: 0x9973,
	27291 - 11905: 0x9974,
	27292 - 11905: 0x9975,
	27293 - 11905: 0x9976,
	27294 - 11905: 0x9977,
	27295 - 11905: 0x9978,
	27296 - 11905: 0xE9D1,
	27297 - 11905: 0x9979,
	27298 - 11905: 0x997A,
	27299 - 11905: 0x997B,
	27300 - 11905: 0x997C,
	27301 - 11905: 0x997D,
	27302 - 11905: 0x997E,
	27303 - 11905: 0x9980,
	27304 - 11905: 0x9981,
	27305 - 11905: 0xE9DD,
	27306 - 11905: 0x9982,
	27307 - 11905: 0xE9DF,
	27308 - 11905: 0xC3CA,
	27309 - 11905: 0x9983,
	27310 - 11905: 0x9984,
	27311 - 11905: 0x9985,
	27312 - 11905: 0x9986,
	27313 - 11905: 0x9987,
	27314 - 11905: 0x9988,
	27315 - 11905: 0x9989,
	27316 - 11905: 0x998A,
	27317 - 11905: 0x998B,
	27318 - 11905: 0x998C,
	27319 - 11905: 0x998D,
	27320 - 11905: 0x998E,
	27321 - 11905: 0x998F,
	27322 - 11905: 0x9990,
	27323 - 11905: 0x9991,
	27324 - 11905: 0x9992,
	27325 - 11905: 0x9993,
	27326 - 11905: 0x9994,
	27327 - 11905: 0x9995,
	27328 - 11905: 0x9996,
	27329 - 11905: 0x9997,
	27330 - 11905: 0x9998,
	27331 - 11905: 0x9999,
	27332 - 11905: 0x999A,
	27333 - 11905: 0x999B,
	27334 - 11905: 0x999C,
	27335 - 11905: 0x999D,
	27336 - 11905: 0x999E,
	27337 - 11905: 0x999F,
	27338 - 11905: 0x99A0,
	27339 - 11905: 0x99A1,
	27340 - 11905: 0x99A2,
	27341 - 11905: 0x99A3,
	27342 - 11905: 0x99A4,
	27343 - 11905: 0x99A5,
	27344 - 11905: 0x99A6,
	27345 - 11905: 0x99A7,
	27346 - 11905: 0x99A8,
	27347 - 11905: 0x99A9,
	27348 - 11905: 0x99AA,
	27349 - 11905: 0x99AB,
	27350 - 11905: 0x99AC,
	27351 - 11905: 0x99AD,
	27352 - 11905: 0x99AE,
	27353 - 11905: 0x99AF,
	27354 - 11905: 0x99B0,
	27355 - 11905: 0x99B1,
	27356 - 11905: 0x99B2,
	27357 - 11905: 0x99B3,
	27358 - 11905: 0x99B4,
	27359 - 11905: 0x99B5,
	27360 - 11905: 0x99B6,
	27361 - 11905: 0x99B7,
	27362 - 11905: 0x99B8,
	27363 - 11905: 0x99B9,
	27364 - 11905: 0x99BA,
	27365 - 11905: 0x99BB,
	27366 - 11905: 0x99BC,
	27367 - 11905: 0x99BD,
	27368 - 11905: 0x99BE,
	27369 - 11905: 0x99BF,
	27370 - 11905: 0x99C0,
	27371 - 11905: 0x99C1,
	27372 - 11905: 0x99C2,
	27373 - 11905: 0x99C3,
	27374 - 11905: 0x99C4,
	27375 - 11905: 0x99C5,
	27376 - 11905: 0x99C6,
	27377 - 11905: 0x99C7,
	27378 - 11905: 0x99C8,
	27379 - 11905: 0x99C9,
	27380 - 11905: 0x99CA,
	27381 - 11905: 0x99CB,
	27382 - 11905: 0x99CC,
	27383 - 11905: 0x99CD,
	27384 - 11905: 0x99CE,
	27385 - 11905: 0x99CF,
	27386 - 11905: 0x99D0,
	27387 - 11905: 0x99D1,
	27388 - 11905: 0x99D2,
	27389 - 11905: 0x99D3,
	27390 - 11905: 0x99D4,
	27391 - 11905: 0x99D5,
	27392 - 11905: 0x99D6,
	27393 - 11905: 0x99D7,
	27394 - 11905: 0x99D8,
	27395 - 11905: 0x99D9,
	27396 - 11905: 0x99DA,
	27397 - 11905: 0x99DB,
	27398 - 11905: 0x99DC,
	27399 - 11905: 0x99DD,
	27400 - 11905: 0x99DE,
	27401 - 11905: 0x99DF,
	27402 - 11905: 0x99E0,
	27403 - 11905: 0x99E1,
	27404 - 11905: 0x99E2,
	27405 - 11905: 0x99E3,
	27406 - 11905: 0x99E4,
	27407 - 11905: 0x99E5,
	27408 - 11905: 0x99E6,
	27409 - 11905: 0x99E7,
	27410 - 11905: 0x99E8,
	27411 - 11905: 0x99E9,
	27412 - 11905: 0x99EA,
	27413 - 11905: 0x99EB,
	27414 - 11905: 0x99EC,
	27415 - 11905: 0x99ED,
	27416 - 11905: 0x99EE,
	27417 - 11905: 0x99EF,
	27418 - 11905: 0x99F0,
	27419 - 11905: 0x99F1,
	27420 - 11905: 0x99F2,
	27421 - 11905: 0x99F3,
	27422 - 11905: 0x99F4,
	27423 - 11905: 0x99F5,
	27424 - 11905: 0xC7B7,
	27425 - 11905: 0xB4CE,
	27426 - 11905: 0xBBB6,
	27427 - 11905: 0xD0C0,
	27428 - 11905: 0xECA3,
	27429 - 11905: 0x99F6,
	27430 - 11905: 0x99F7,
	27431 - 11905: 0xC5B7,
	27432 - 11905: 0x99F8,
	27433 - 11905: 0x99F9,
	27434 - 11905: 0x99FA,
	27435 - 11905: 0x99FB,
	27436 - 11905: 0x99FC,
	27437 - 11905: 0x99FD,
	27438 - 11905: 0x99FE,
	27439 - 11905: 0x9A40,
	27440 - 11905: 0x9A41,
	27441 - 11905: 0x9A42,
	27442 - 11905: 0xD3FB,
	27443 - 11905: 0x9A43,
	27444 - 11905: 0x9A44,
	27445 - 11905: 0x9A45,
	27446 - 11905: 0x9A46,
	27447 - 11905: 0xECA4,
	27448 - 11905: 0x9A47,
	27449 - 11905: 0xECA5,
	27450 - 11905: 0xC6DB,
	27451 - 11905: 0x9A48,
	27452 - 11905: 0x9A49,
	27453 - 11905: 0x9A4A,
	27454 - 11905: 0xBFEE,
	27455 - 11905: 0x9A4B,
	27456 - 11905: 0x9A4C,
	27457 - 11905: 0x9A4D,
	27458 - 11905: 0x9A4E,
	27459 - 11905: 0xECA6,
	27460 - 11905: 0x9A4F,
	27461 - 11905: 0x9A50,
	27462 - 11905: 0xECA7,
	27463 - 11905: 0xD0AA,
	27464 - 11905: 0x9A51,
	27465 - 11905: 0xC7B8,
	27466 - 11905: 0x9A52,
	27467 - 11905: 0x9A53,
	27468 - 11905: 0xB8E8,
	27469 - 11905: 0x9A54,
	27470 - 11905: 0x9A55,
	27471 - 11905: 0x9A56,
	27472 - 11905: 0x9A57,
	27473 - 11905: 0x9A58,
	27474 - 11905: 0x9A59,
	27475 - 11905: 0x9A5A,
	27476 - 11905: 0x9A5B,
	27477 - 11905: 0x9A5C,
	27478 - 11905: 0x9A5D,
	27479 - 11905: 0x9A5E,
	27480 - 11905: 0x9A5F,
	27481 - 11905: 0xECA8,
	27482 - 11905: 0x9A60,
	27483 - 11905: 0x9A61,
	27484 - 11905: 0x9A62,
	27485 - 11905: 0x9A63,
	27486 - 11905: 0x9A64,
	27487 - 11905: 0x9A65,
	27488 - 11905: 0x9A66,
	27489 - 11905: 0x9A67,
	27490 - 11905: 0xD6B9,
	27491 - 11905: 0xD5FD,
	27492 - 11905: 0xB4CB,
	27493 - 11905: 0xB2BD,
	27494 - 11905: 0xCEE4,
	27495 - 11905: 0xC6E7,
	27496 - 11905: 0x9A68,
	27497 - 11905: 0x9A69,
	27498 - 11905: 0xCDE1,
	27499 - 11905: 0x9A6A,
	27500 - 11905: 0x9A6B,
	27501 - 11905: 0x9A6C,
	27502 - 11905: 0x9A6D,
	27503 - 11905: 0x9A6E,
	27504 - 11905: 0x9A6F,
	27505 - 11905: 0x9A70,
	27506 - 11905: 0x9A71,
	27507 - 11905: 0x9A72,
	27508 - 11905: 0x9A73,
	27509 - 11905: 0x9A74,
	27510 - 11905: 0x9A75,
	27511 - 11905: 0x9A76,
	27512 - 11905: 0x9A77,
	27513 - 11905: 0xB4F5,
	27514 - 11905: 0x9A78,
	27515 - 11905: 0xCBC0,
	27516 - 11905: 0xBCDF,
	27517 - 11905: 0x9A79,
	27518 - 11905: 0x9A7A,
	27519 - 11905: 0x9A7B,
	27520 - 11905: 0x9A7C,
	27521 - 11905: 0xE9E2,
	27522 - 11905: 0xE9E3,
	27523 - 11905: 0xD1EA,
	27524 - 11905: 0xE9E5,
	27525 - 11905: 0x9A7D,
	27526 - 11905: 0xB4F9,
	27527 - 11905: 0xE9E4,
	27528 - 11905: 0x9A7E,
	27529 - 11905: 0xD1B3,
	27530 - 11905: 0xCAE2,
	27531 - 11905: 0xB2D0,
	27532 - 11905: 0x9A80,
	27533 - 11905: 0xE9E8,
	27534 - 11905: 0x9A81,
	27535 - 11905: 0x9A82,
	27536 - 11905: 0x9A83,
	27537 - 11905: 0x9A84,
	27538 - 11905: 0xE9E6,
	27539 - 11905: 0xE9E7,
	27540 - 11905: 0x9A85,
	27541 - 11905: 0x9A86,
	27542 - 11905: 0xD6B3,
	27543 - 11905: 0x9A87,
	27544 - 11905: 0x9A88,
	27545 - 11905: 0x9A89,
	27546 - 11905: 0xE9E9,
	27547 - 11905: 0xE9EA,
	27548 - 11905: 0x9A8A,
	27549 - 11905: 0x9A8B,
	27550 - 11905: 0x9A8C,
	27551 - 11905: 0x9A8D,
	27552 - 11905: 0x9A8E,
	27553 - 11905: 0xE9EB,
	27554 - 11905: 0x9A8F,
	27555 - 11905: 0x9A90,
	27556 - 11905: 0x9A91,
	27557 - 11905: 0x9A92,
	27558 - 11905: 0x9A93,
	27559 - 11905: 0x9A94,
	27560 - 11905: 0x9A95,
	27561 - 11905: 0x9A96,
	27562 - 11905: 0xE9EC,
	27563 - 11905: 0x9A97,
	27564 - 11905: 0x9A98,
	27565 - 11905: 0x9A99,
	27566 - 11905: 0x9A9A,
	27567 - 11905: 0x9A9B,
	27568 - 11905: 0x9A9C,
	27569 - 11905: 0x9A9D,
	27570 - 11905: 0x9A9E,
	27571 - 11905: 0xECAF,
	27572 - 11905: 0xC5B9,
	27573 - 11905: 0xB6CE,
	27574 - 11905: 0x9A9F,
	27575 - 11905: 0xD2F3,
	27576 - 11905: 0x9AA0,
	27577 - 11905: 0x9AA1,
	27578 - 11905: 0x9AA2,
	27579 - 11905: 0x9AA3,
	27580 - 11905: 0x9AA4,
	27581 - 11905: 0x9AA5,
	27582 - 11905: 0x9AA6,
	27583 - 11905: 0xB5EE,
	27584 - 11905: 0x9AA7,
	27585 - 11905: 0xBBD9,
	27586 - 11905: 0xECB1,
	27587 - 11905: 0x9AA8,
	27588 - 11905: 0x9AA9,
	27589 - 11905: 0xD2E3,
	27590 - 11905: 0x9AAA,
	27591 - 11905: 0x9AAB,
	27592 - 11905: 0x9AAC,
	27593 - 11905: 0x9AAD,
	27594 - 11905: 0x9AAE,
	27595 - 11905: 0xCEE3,
	27596 - 11905: 0x9AAF,
	27597 - 11905: 0xC4B8,
	27598 - 11905: 0x9AB0,
	27599 - 11905: 0xC3BF,
	27600 - 11905: 0x9AB1,
	27601 - 11905: 0x9AB2,
	27602 - 11905: 0xB6BE,
	27603 - 11905: 0xD8B9,
	27604 - 11905: 0xB1C8,
	27605 - 11905: 0xB1CF,
	27606 - 11905: 0xB1D1,
	27607 - 11905: 0xC5FE,
	27608 - 11905: 0x9AB3,
	27609 - 11905: 0xB1D0,
	27610 - 11905: 0x9AB4,
	27611 - 11905: 0xC3AB,
	27612 - 11905: 0x9AB5,
	27613 - 11905: 0x9AB6,
	27614 - 11905: 0x9AB7,
	27615 - 11905: 0x9AB8,
	27616 - 11905: 0x9AB9,
	27617 - 11905: 0xD5B1,
	27618 - 11905: 0x9ABA,
	27619 - 11905: 0x9ABB,
	27620 - 11905: 0x9ABC,
	27621 - 11905: 0x9ABD,
	27622 - 11905: 0x9ABE,
	27623 - 11905: 0x9ABF,
	27624 - 11905: 0x9AC0,
	27625 - 11905: 0x9AC1,
	27626 - 11905: 0xEBA4,
	27627 - 11905: 0xBAC1,
	27628 - 11905: 0x9AC2,
	27629 - 11905: 0x9AC3,
	27630 - 11905: 0x9AC4,
	27631 - 11905: 0xCCBA,
	27632 - 11905: 0x9AC5,
	27633 - 11905: 0x9AC6,
	27634 - 11905: 0x9AC7,
	27635 - 11905: 0xEBA5,
	27636 - 11905: 0x9AC8,
	27637 - 11905: 0xEBA7,
	27638 - 11905: 0x9AC9,
	27639 - 11905: 0x9ACA,
	27640 - 11905: 0x9ACB,
	27641 - 11905: 0xEBA8,
	27642 - 11905: 0x9ACC,
	27643 - 11905: 0x9ACD,
	27644 - 11905: 0x9ACE,
	27645 - 11905: 0xEBA6,
	27646 - 11905: 0x9ACF,
	27647 - 11905: 0x9AD0,
	27648 - 11905: 0x9AD1,
	27649 - 11905: 0x9AD2,
	27650 - 11905: 0x9AD3,
	27651 - 11905: 0x9AD4,
	27652 - 11905: 0x9AD5,
	27653 - 11905: 0xEBA9,
	27654 - 11905: 0xEBAB,
	27655 - 11905: 0xEBAA,
	27656 - 11905: 0x9AD6,
	27657 - 11905: 0x9AD7,
	27658 - 11905: 0x9AD8,
	27659 - 11905: 0x9AD9,
	27660 - 11905: 0x9ADA,
	27661 - 11905: 0xEBAC,
	27662 - 11905: 0x9ADB,
	27663 - 11905: 0xCACF,
	27664 - 11905: 0xD8B5,
	27665 - 11905: 0xC3F1,
	27666 - 11905: 0x9ADC,
	27667 - 11905: 0xC3A5,
	27668 - 11905: 0xC6F8,
	27669 - 11905: 0xEBAD,
	27670 - 11905: 0xC4CA,
	27671 - 11905: 0x9ADD,
	27672 - 11905: 0xEBAE,
	27673 - 11905: 0xEBAF,
	27674 - 11905: 0xEBB0,
	27675 - 11905: 0xB7D5,
	27676 - 11905: 0x9ADE,
	27677 - 11905: 0x9ADF,
	27678 - 11905: 0x9AE0,
	27679 - 11905: 0xB7FA,
	27680 - 11905: 0x9AE1,
	27681 - 11905: 0xEBB1,
	27682 - 11905: 0xC7E2,
	27683 - 11905: 0x9AE2,
	27684 - 11905: 0xEBB3,
	27685 - 11905: 0x9AE3,
	27686 - 11905: 0xBAA4,
	27687 - 11905: 0xD1F5,
	27688 - 11905: 0xB0B1,
	27689 - 11905: 0xEBB2,
	27690 - 11905: 0xEBB4,
	27691 - 11905: 0x9AE4,
	27692 - 11905: 0x9AE5,
	27693 - 11905: 0x9AE6,
	27694 - 11905: 0xB5AA,
	27695 - 11905: 0xC2C8,
	27696 - 11905: 0xC7E8,
	27697 - 11905: 0x9AE7,
	27698 - 11905: 0xEBB5,
	27699 - 11905: 0x9AE8,
	27700 - 11905: 0xCBAE,
	27701 - 11905: 0xE3DF,
	27702 - 11905: 0x9AE9,
	27703 - 11905: 0x9AEA,
	27704 - 11905: 0xD3C0,
	27705 - 11905: 0x9AEB,
	27706 - 11905: 0x9AEC,
	27707 - 11905: 0x9AED,
	27708 - 11905: 0x9AEE,
	27709 - 11905: 0xD9DB,
	27710 - 11905: 0x9AEF,
	27711 - 11905: 0x9AF0,
	27712 - 11905: 0xCDA1,
	27713 - 11905: 0xD6AD,
	27714 - 11905: 0xC7F3,
	27715 - 11905: 0x9AF1,
	27716 - 11905: 0x9AF2,
	27717 - 11905: 0x9AF3,
	27718 - 11905: 0xD9E0,
	27719 - 11905: 0xBBE3,
	27720 - 11905: 0x9AF4,
	27721 - 11905: 0xBABA,
	27722 - 11905: 0xE3E2,
	27723 - 11905: 0x9AF5,
	27724 - 11905: 0x9AF6,
	27725 - 11905: 0x9AF7,
	27726 - 11905: 0x9AF8,
	27727 - 11905: 0x9AF9,
	27728 - 11905: 0xCFAB,
	27729 - 11905: 0x9AFA,
	27730 - 11905: 0x9AFB,
	27731 - 11905: 0x9AFC,
	27732 - 11905: 0xE3E0,
	27733 - 11905: 0xC9C7,
	27734 - 11905: 0x9AFD,
	27735 - 11905: 0xBAB9,
	27736 - 11905: 0x9AFE,
	27737 - 11905: 0x9B40,
	27738 - 11905: 0x9B41,
	27739 - 11905: 0xD1B4,
	27740 - 11905: 0xE3E1,
	27741 - 11905: 0xC8EA,
	27742 - 11905: 0xB9AF,
	27743 - 11905: 0xBDAD,
	27744 - 11905: 0xB3D8,
	27745 - 11905: 0xCEDB,
	27746 - 11905: 0x9B42,
	27747 - 11905: 0x9B43,
	27748 - 11905: 0xCCC0,
	27749 - 11905: 0x9B44,
	27750 - 11905: 0x9B45,
	27751 - 11905: 0x9B46,
	27752 - 11905: 0xE3E8,
	27753 - 11905: 0xE3E9,
	27754 - 11905: 0xCDF4,
	27755 - 11905: 0x9B47,
	27756 - 11905: 0x9B48,
	27757 - 11905: 0x9B49,
	27758 - 11905: 0x9B4A,
	27759 - 11905: 0x9B4B,
	27760 - 11905: 0xCCAD,
	27761 - 11905: 0x9B4C,
	27762 - 11905: 0xBCB3,
	27763 - 11905: 0x9B4D,
	27764 - 11905: 0xE3EA,
	27765 - 11905: 0x9B4E,
	27766 - 11905: 0xE3EB,
	27767 - 11905: 0x9B4F,
	27768 - 11905: 0x9B50,
	27769 - 11905: 0xD0DA,
	27770 - 11905: 0x9B51,
	27771 - 11905: 0x9B52,
	27772 - 11905: 0x9B53,
	27773 - 11905: 0xC6FB,
	27774 - 11905: 0xB7DA,
	27775 - 11905: 0x9B54,
	27776 - 11905: 0x9B55,
	27777 - 11905: 0xC7DF,
	27778 - 11905: 0xD2CA,
	27779 - 11905: 0xCED6,
	27780 - 11905: 0x9B56,
	27781 - 11905: 0xE3E4,
	27782 - 11905: 0xE3EC,
	27783 - 11905: 0x9B57,
	27784 - 11905: 0xC9F2,
	27785 - 11905: 0xB3C1,
	27786 - 11905: 0x9B58,
	27787 - 11905: 0x9B59,
	27788 - 11905: 0xE3E7,
	27789 - 11905: 0x9B5A,
	27790 - 11905: 0x9B5B,
	27791 - 11905: 0xC6E3,
	27792 - 11905: 0xE3E5,
	27793 - 11905: 0x9B5C,
	27794 - 11905: 0x9B5D,
	27795 - 11905: 0xEDB3,
	27796 - 11905: 0xE3E6,
	27797 - 11905: 0x9B5E,
	27798 - 11905: 0x9B5F,
	27799 - 11905: 0x9B60,
	27800 - 11905: 0x9B61,
	27801 - 11905: 0xC9B3,
	27802 - 11905: 0x9B62,
	27803 - 11905: 0xC5E6,
	27804 - 11905: 0x9B63,
	27805 - 11905: 0x9B64,
	27806 - 11905: 0x9B65,
	27807 - 11905: 0xB9B5,
	27808 - 11905: 0x9B66,
	27809 - 11905: 0xC3BB,
	27810 - 11905: 0x9B67,
	27811 - 11905: 0xE3E3,
	27812 - 11905: 0xC5BD,
	27813 - 11905: 0xC1A4,
	27814 - 11905: 0xC2D9,
	27815 - 11905: 0xB2D7,
	27816 - 11905: 0x9B68,
	27817 - 11905: 0xE3ED,
	27818 - 11905: 0xBBA6,
	27819 - 11905: 0xC4AD,
	27820 - 11905: 0x9B69,
	27821 - 11905: 0xE3F0,
	27822 - 11905: 0xBEDA,
	27823 - 11905: 0x9B6A,
	27824 - 11905: 0x9B6B,
	27825 - 11905: 0xE3FB,
	27826 - 11905: 0xE3F5,
	27827 - 11905: 0xBAD3,
	27828 - 11905: 0x9B6C,
	27829 - 11905: 0x9B6D,
	27830 - 11905: 0x9B6E,
	27831 - 11905: 0x9B6F,
	27832 - 11905: 0xB7D0,
	27833 - 11905: 0xD3CD,
	27834 - 11905: 0x9B70,
	27835 - 11905: 0xD6CE,
	27836 - 11905: 0xD5D3,
	27837 - 11905: 0xB9C1,
	27838 - 11905: 0xD5B4,
	27839 - 11905: 0xD1D8,
	27840 - 11905: 0x9B71,
	27841 - 11905: 0x9B72,
	27842 - 11905: 0x9B73,
	27843 - 11905: 0x9B74,
	27844 - 11905: 0xD0B9,
	27845 - 11905: 0xC7F6,
	27846 - 11905: 0x9B75,
	27847 - 11905: 0x9B76,
	27848 - 11905: 0x9B77,
	27849 - 11905: 0xC8AA,
	27850 - 11905: 0xB2B4,
	27851 - 11905: 0x9B78,
	27852 - 11905: 0xC3DA,
	27853 - 11905: 0x9B79,
	27854 - 11905: 0x9B7A,
	27855 - 11905: 0x9B7B,
	27856 - 11905: 0xE3EE,
	27857 - 11905: 0x9B7C,
	27858 - 11905: 0x9B7D,
	27859 - 11905: 0xE3FC,
	27860 - 11905: 0xE3EF,
	27861 - 11905: 0xB7A8,
	27862 - 11905: 0xE3F7,
	27863 - 11905: 0xE3F4,
	27864 - 11905: 0x9B7E,
	27865 - 11905: 0x9B80,
	27866 - 11905: 0x9B81,
	27867 - 11905: 0xB7BA,
	27868 - 11905: 0x9B82,
	27869 - 11905: 0x9B83,
	27870 - 11905: 0xC5A2,
	27871 - 11905: 0x9B84,
	27872 - 11905: 0xE3F6,
	27873 - 11905: 0xC5DD,
	27874 - 11905: 0xB2A8,
	27875 - 11905: 0xC6FC,
	27876 - 11905: 0x9B85,
	27877 - 11905: 0xC4E0,
	27878 - 11905: 0x9B86,
	27879 - 11905: 0x9B87,
	27880 - 11905: 0xD7A2,
	27881 - 11905: 0x9B88,
	27882 - 11905: 0xC0E1,
	27883 - 11905: 0xE3F9,
	27884 - 11905: 0x9B89,
	27885 - 11905: 0x9B8A,
	27886 - 11905: 0xE3FA,
	27887 - 11905: 0xE3FD,
	27888 - 11905: 0xCCA9,
	27889 - 11905: 0xE3F3,
	27890 - 11905: 0x9B8B,
	27891 - 11905: 0xD3BE,
	27892 - 11905: 0x9B8C,
	27893 - 11905: 0xB1C3,
	27894 - 11905: 0xEDB4,
	27895 - 11905: 0xE3F1,
	27896 - 11905: 0xE3F2,
	27897 - 11905: 0x9B8D,
	27898 - 11905: 0xE3F8,
	27899 - 11905: 0xD0BA,
	27900 - 11905: 0xC6C3,
	27901 - 11905: 0xD4F3,
	27902 - 11905: 0xE3FE,
	27903 - 11905: 0x9B8E,
	27904 - 11905: 0x9B8F,
	27905 - 11905: 0xBDE0,
	27906 - 11905: 0x9B90,
	27907 - 11905: 0x9B91,
	27908 - 11905: 0xE4A7,
	27909 - 11905: 0x9B92,
	27910 - 11905: 0x9B93,
	27911 - 11905: 0xE4A6,
	27912 - 11905: 0x9B94,
	27913 - 11905: 0x9B95,
	27914 - 11905: 0x9B96,
	27915 - 11905: 0xD1F3,
	27916 - 11905: 0xE4A3,
	27917 - 11905: 0x9B97,
	27918 - 11905: 0xE4A9,
	27919 - 11905: 0x9B98,
	27920 - 11905: 0x9B99,
	27921 - 11905: 0x9B9A,
	27922 - 11905: 0xC8F7,
	27923 - 11905: 0x9B9B,
	27924 - 11905: 0x9B9C,
	27925 - 11905: 0x9B9D,
	27926 - 11905: 0x9B9E,
	27927 - 11905: 0xCFB4,
	27928 - 11905: 0x9B9F,
	27929 - 11905: 0xE4A8,
	27930 - 11905: 0xE4AE,
	27931 - 11905: 0xC2E5,
	27932 - 11905: 0x9BA0,
	27933 - 11905: 0x9BA1,
	27934 - 11905: 0xB6B4,
	27935 - 11905: 0x9BA2,
	27936 - 11905: 0x9BA3,
	27937 - 11905: 0x9BA4,
	27938 - 11905: 0x9BA5,
	27939 - 11905: 0x9BA6,
	27940 - 11905: 0x9BA7,
	27941 - 11905: 0xBDF2,
	27942 - 11905: 0x9BA8,
	27943 - 11905: 0xE4A2,
	27944 - 11905: 0x9BA9,
	27945 - 11905: 0x9BAA,
	27946 - 11905: 0xBAE9,
	27947 - 11905: 0xE4AA,
	27948 - 11905: 0x9BAB,
	27949 - 11905: 0x9BAC,
	27950 - 11905: 0xE4AC,
	27951 - 11905: 0x9BAD,
	27952 - 11905: 0x9BAE,
	27953 - 11905: 0xB6FD,
	27954 - 11905: 0xD6DE,
	27955 - 11905: 0xE4B2,
	27956 - 11905: 0x9BAF,
	27957 - 11905: 0xE4AD,
	27958 - 11905: 0x9BB0,
	27959 - 11905: 0x9BB1,
	27960 - 11905: 0x9BB2,
	27961 - 11905: 0xE4A1,
	27962 - 11905: 0x9BB3,
	27963 - 11905: 0xBBEE,
	27964 - 11905: 0xCDDD,
	27965 - 11905: 0xC7A2,
	27966 - 11905: 0xC5C9,
	27967 - 11905: 0x9BB4,
	27968 - 11905: 0x9BB5,
	27969 - 11905: 0xC1F7,
	27970 - 11905: 0x9BB6,
	27971 - 11905: 0xE4A4,
	27972 - 11905: 0x9BB7,
	27973 - 11905: 0xC7B3,
	27974 - 11905: 0xBDAC,
	27975 - 11905: 0xBDBD,
	27976 - 11905: 0xE4A5,
	27977 - 11905: 0x9BB8,
	27978 - 11905: 0xD7C7,
	27979 - 11905: 0xB2E2,
	27980 - 11905: 0x9BB9,
	27981 - 11905: 0xE4AB,
	27982 - 11905: 0xBCC3,
	27983 - 11905: 0xE4AF,
	27984 - 11905: 0x9BBA,
	27985 - 11905: 0xBBEB,
	27986 - 11905: 0xE4B0,
	27987 - 11905: 0xC5A8,
	27988 - 11905: 0xE4B1,
	27989 - 11905: 0x9BBB,
	27990 - 11905: 0x9BBC,
	27991 - 11905: 0x9BBD,
	27992 - 11905: 0x9BBE,
	27993 - 11905: 0xD5E3,
	27994 - 11905: 0xBFA3,
	27995 - 11905: 0x9BBF,
	27996 - 11905: 0xE4BA,
	27997 - 11905: 0x9BC0,
	27998 - 11905: 0xE4B7,
	27999 - 11905: 0x9BC1,
	28000 - 11905: 0xE4BB,
	28001 - 11905: 0x9BC2,
	28002 - 11905: 0x9BC3,
	28003 - 11905: 0xE4BD,
	28004 - 11905: 0x9BC4,
	28005 - 11905: 0x9BC5,
	28006 - 11905: 0xC6D6,
	28007 - 11905: 0x9BC6,
	28008 - 11905: 0x9BC7,
	28009 - 11905: 0xBAC6,
	28010 - 11905: 0xC0CB,
	28011 - 11905: 0x9BC8,
	28012 - 11905: 0x9BC9,
	28013 - 11905: 0x9BCA,
	28014 - 11905: 0xB8A1,
	28015 - 11905: 0xE4B4,
	28016 - 11905: 0x9BCB,
	28017 - 11905: 0x9BCC,
	28018 - 11905: 0x9BCD,
	28019 - 11905: 0x9BCE,
	28020 - 11905: 0xD4A1,
	28021 - 11905: 0x9BCF,
	28022 - 11905: 0x9BD0,
	28023 - 11905: 0xBAA3,
	28024 - 11905: 0xBDFE,
	28025 - 11905: 0x9BD1,
	28026 - 11905: 0x9BD2,
	28027 - 11905: 0x9BD3,
	28028 - 11905: 0xE4BC,
	28029 - 11905: 0x9BD4,
	28030 - 11905: 0x9BD5,
	28031 - 11905: 0x9BD6,
	28032 - 11905: 0x9BD7,
	28033 - 11905: 0x9BD8,
	28034 - 11905: 0xCDBF,
	28035 - 11905: 0x9BD9,
	28036 - 11905: 0x9BDA,
	28037 - 11905: 0xC4F9,
	28038 - 11905: 0x9BDB,
	28039 - 11905: 0x9BDC,
	28040 - 11905: 0xCFFB,
	28041 - 11905: 0xC9E6,
	28042 - 11905: 0x9BDD,
	28043 - 11905: 0x9BDE,
	28044 - 11905: 0xD3BF,
	28045 - 11905: 0x9BDF,
	28046 - 11905: 0xCFD1,
	28047 - 11905: 0x9BE0,
	28048 - 11905: 0x9BE1,
	28049 - 11905: 0xE4B3,
	28050 - 11905: 0x9BE2,
	28051 - 11905: 0xE4B8,
	28052 - 11905: 0xE4B9,
	28053 - 11905: 0xCCE9,
	28054 - 11905: 0x9BE3,
	28055 - 11905: 0x9BE4,
	28056 - 11905: 0x9BE5,
	28057 - 11905: 0x9BE6,
	28058 - 11905: 0x9BE7,
	28059 - 11905: 0xCCCE,
	28060 - 11905: 0x9BE8,
	28061 - 11905: 0xC0D4,
	28062 - 11905: 0xE4B5,
	28063 - 11905: 0xC1B0,
	28064 - 11905: 0xE4B6,
	28065 - 11905: 0xCED0,
	28066 - 11905: 0x9BE9,
	28067 - 11905: 0xBBC1,
	28068 - 11905: 0xB5D3,
	28069 - 11905: 0x9BEA,
	28070 - 11905: 0xC8F3,
	28071 - 11905: 0xBDA7,
	28072 - 11905: 0xD5C7,
	28073 - 11905: 0xC9AC,
	28074 - 11905: 0xB8A2,
	28075 - 11905: 0xE4CA,
	28076 - 11905: 0x9BEB,
	28077 - 11905: 0x9BEC,
	28078 - 11905: 0xE4CC,
	28079 - 11905: 0xD1C4,
	28080 - 11905: 0x9BED,
	28081 - 11905: 0x9BEE,
	28082 - 11905: 0xD2BA,
	28083 - 11905: 0x9BEF,
	28084 - 11905: 0x9BF0,
	28085 - 11905: 0xBAAD,
	28086 - 11905: 0x9BF1,
	28087 - 11905: 0x9BF2,
	28088 - 11905: 0xBAD4,
	28089 - 11905: 0x9BF3,
	28090 - 11905: 0x9BF4,
	28091 - 11905: 0x9BF5,
	28092 - 11905: 0x9BF6,
	28093 - 11905: 0x9BF7,
	28094 - 11905: 0x9BF8,
	28095 - 11905: 0xE4C3,
	28096 - 11905: 0xB5ED,
	28097 - 11905: 0x9BF9,
	28098 - 11905: 0x9BFA,
	28099 - 11905: 0x9BFB,
	28100 - 11905: 0xD7CD,
	28101 - 11905: 0xE4C0,
	28102 - 11905: 0xCFFD,
	28103 - 11905: 0xE4BF,
	28104 - 11905: 0x9BFC,
	28105 - 11905: 0x9BFD,
	28106 - 11905: 0x9BFE,
	28107 - 11905: 0xC1DC,
	28108 - 11905: 0xCCCA,
	28109 - 11905: 0x9C40,
	28110 - 11905: 0x9C41,
	28111 - 11905: 0x9C42,
	28112 - 11905: 0x9C43,
	28113 - 11905: 0xCAE7,
	28114 - 11905: 0x9C44,
	28115 - 11905: 0x9C45,
	28116 - 11905: 0x9C46,
	28117 - 11905: 0x9C47,
	28118 - 11905: 0xC4D7,
	28119 - 11905: 0x9C48,
	28120 - 11905: 0xCCD4,
	28121 - 11905: 0xE4C8,
	28122 - 11905: 0x9C49,
	28123 - 11905: 0x9C4A,
	28124 - 11905: 0x9C4B,
	28125 - 11905: 0xE4C7,
	28126 - 11905: 0xE4C1,
	28127 - 11905: 0x9C4C,
	28128 - 11905: 0xE4C4,
	28129 - 11905: 0xB5AD,
	28130 - 11905: 0x9C4D,
	28131 - 11905: 0x9C4E,
	28132 - 11905: 0xD3D9,
	28133 - 11905: 0x9C4F,
	28134 - 11905: 0xE4C6,
	28135 - 11905: 0x9C50,
	28136 - 11905: 0x9C51,
	28137 - 11905: 0x9C52,
	28138 - 11905: 0x9C53,
	28139 - 11905: 0xD2F9,
	28140 - 11905: 0xB4E3,
	28141 - 11905: 0x9C54,
	28142 - 11905: 0xBBB4,
	28143 - 11905: 0x9C55,
	28144 - 11905: 0x9C56,
	28145 - 11905: 0xC9EE,
	28146 - 11905: 0x9C57,
	28147 - 11905: 0xB4BE,
	28148 - 11905: 0x9C58,
	28149 - 11905: 0x9C59,
	28150 - 11905: 0x9C5A,
	28151 - 11905: 0xBBEC,
	28152 - 11905: 0x9C5B,
	28153 - 11905: 0xD1CD,
	28154 - 11905: 0x9C5C,
	28155 - 11905: 0xCCED,
	28156 - 11905: 0xEDB5,
	28157 - 11905: 0x9C5D,
	28158 - 11905: 0x9C5E,
	28159 - 11905: 0x9C5F,
	28160 - 11905: 0x9C60,
	28161 - 11905: 0x9C61,
	28162 - 11905: 0x9C62,
	28163 - 11905: 0x9C63,
	28164 - 11905: 0x9C64,
	28165 - 11905: 0xC7E5,
	28166 - 11905: 0x9C65,
	28167 - 11905: 0x9C66,
	28168 - 11905: 0x9C67,
	28169 - 11905: 0x9C68,
	28170 - 11905: 0xD4A8,
	28171 - 11905: 0x9C69,
	28172 - 11905: 0xE4CB,
	28173 - 11905: 0xD7D5,
	28174 - 11905: 0xE4C2,
	28175 - 11905: 0x9C6A,
	28176 - 11905: 0xBDA5,
	28177 - 11905: 0xE4C5,
	28178 - 11905: 0x9C6B,
	28179 - 11905: 0x9C6C,
	28180 - 11905: 0xD3E6,
	28181 - 11905: 0x9C6D,
	28182 - 11905: 0xE4C9,
	28183 - 11905: 0xC9F8,
	28184 - 11905: 0x9C6E,
	28185 - 11905: 0x9C6F,
	28186 - 11905: 0xE4BE,
	28187 - 11905: 0x9C70,
	28188 - 11905: 0x9C71,
	28189 - 11905: 0xD3E5,
	28190 - 11905: 0x9C72,
	28191 - 11905: 0x9C73,
	28192 - 11905: 0xC7FE,
	28193 - 11905: 0xB6C9,
	28194 - 11905: 0x9C74,
	28195 - 11905: 0xD4FC,
	28196 - 11905: 0xB2B3,
	28197 - 11905: 0xE4D7,
	28198 - 11905: 0x9C75,
	28199 - 11905: 0x9C76,
	28200 - 11905: 0x9C77,
	28201 - 11905: 0xCEC2,
	28202 - 11905: 0x9C78,
	28203 - 11905: 0xE4CD,
	28204 - 11905: 0x9C79,
	28205 - 11905: 0xCEBC,
	28206 - 11905: 0x9C7A,
	28207 - 11905: 0xB8DB,
	28208 - 11905: 0x9C7B,
	28209 - 11905: 0x9C7C,
	28210 - 11905: 0xE4D6,
	28211 - 11905: 0x9C7D,
	28212 - 11905: 0xBFCA,
	28213 - 11905: 0x9C7E,
	28214 - 11905: 0x9C80,
	28215 - 11905: 0x9C81,
	28216 - 11905: 0xD3CE,
	28217 - 11905: 0x9C82,
	28218 - 11905: 0xC3EC,
	28219 - 11905: 0x9C83,
	28220 - 11905: 0x9C84,
	28221 - 11905: 0x9C85,
	28222 - 11905: 0x9C86,
	28223 - 11905: 0x9C87,
	28224 - 11905: 0x9C88,
	28225 - 11905: 0x9C89,
	28226 - 11905: 0x9C8A,
	28227 - 11905: 0xC5C8,
	28228 - 11905: 0xE4D8,
	28229 - 11905: 0x9C8B,
	28230 - 11905: 0x9C8C,
	28231 - 11905: 0x9C8D,
	28232 - 11905: 0x9C8E,
	28233 - 11905: 0x9C8F,
	28234 - 11905: 0x9C90,
	28235 - 11905: 0x9C91,
	28236 - 11905: 0x9C92,
	28237 - 11905: 0xCDC4,
	28238 - 11905: 0xE4CF,
	28239 - 11905: 0x9C93,
	28240 - 11905: 0x9C94,
	28241 - 11905: 0x9C95,
	28242 - 11905: 0x9C96,
	28243 - 11905: 0xE4D4,
	28244 - 11905: 0xE4D5,
	28245 - 11905: 0x9C97,
	28246 - 11905: 0xBAFE,
	28247 - 11905: 0x9C98,
	28248 - 11905: 0xCFE6,
	28249 - 11905: 0x9C99,
	28250 - 11905: 0x9C9A,
	28251 - 11905: 0xD5BF,
	28252 - 11905: 0x9C9B,
	28253 - 11905: 0x9C9C,
	28254 - 11905: 0x9C9D,
	28255 - 11905: 0xE4D2,
	28256 - 11905: 0x9C9E,
	28257 - 11905: 0x9C9F,
	28258 - 11905: 0x9CA0,
	28259 - 11905: 0x9CA1,
	28260 - 11905: 0x9CA2,
	28261 - 11905: 0x9CA3,
	28262 - 11905: 0x9CA4,
	28263 - 11905: 0x9CA5,
	28264 - 11905: 0x9CA6,
	28265 - 11905: 0x9CA7,
	28266 - 11905: 0x9CA8,
	28267 - 11905: 0xE4D0,
	28268 - 11905: 0x9CA9,
	28269 - 11905: 0x9CAA,
	28270 - 11905: 0xE4CE,
	28271 - 11905: 0x9CAB,
	28272 - 11905: 0x9CAC,
	28273 - 11905: 0x9CAD,
	28274 - 11905: 0x9CAE,
	28275 - 11905: 0x9CAF,
	28276 - 11905: 0x9CB0,
	28277 - 11905: 0x9CB1,
	28278 - 11905: 0x9CB2,
	28279 - 11905: 0x9CB3,
	28280 - 11905: 0x9CB4,
	28281 - 11905: 0x9CB5,
	28282 - 11905: 0x9CB6,
	28283 - 11905: 0x9CB7,
	28284 - 11905: 0x9CB8,
	28285 - 11905: 0x9CB9,
	28286 - 11905: 0xCDE5,
	28287 - 11905: 0xCAAA,
	28288 - 11905: 0x9CBA,
	28289 - 11905: 0x9CBB,
	28290 - 11905: 0x9CBC,
	28291 - 11905: 0xC0A3,
	28292 - 11905: 0x9CBD,
	28293 - 11905: 0xBDA6,
	28294 - 11905: 0xE4D3,
	28295 - 11905: 0x9CBE,
	28296 - 11905: 0x9CBF,
	28297 - 11905: 0xB8C8,
	28298 - 11905: 0x9CC0,
	28299 - 11905: 0x9CC1,
	28300 - 11905: 0x9CC2,
	28301 - 11905: 0x9CC3,
	28302 - 11905: 0x9CC4,
	28303 - 11905: 0xE4E7,
	28304 - 11905: 0xD4B4,
	28305 - 11905: 0x9CC5,
	28306 - 11905: 0x9CC6,
	28307 - 11905: 0x9CC7,
	28308 - 11905: 0x9CC8,
	28309 - 11905: 0x9CC9,
	28310 - 11905: 0x9CCA,
	28311 - 11905: 0x9CCB,
	28312 - 11905: 0xE4DB,
	28313 - 11905: 0x9CCC,
	28314 - 11905: 0x9CCD,
	28315 - 11905: 0x9CCE,
	28316 - 11905: 0xC1EF,
	28317 - 11905: 0x9CCF,
	28318 - 11905: 0x9CD0,
	28319 - 11905: 0xE4E9,
	28320 - 11905: 0x9CD1,
	28321 - 11905: 0x9CD2,
	28322 - 11905: 0xD2E7,
	28323 - 11905: 0x9CD3,
	28324 - 11905: 0x9CD4,
	28325 - 11905: 0xE4DF,
	28326 - 11905: 0x9CD5,
	28327 - 11905: 0xE4E0,
	28328 - 11905: 0x9CD6,
	28329 - 11905: 0x9CD7,
	28330 - 11905: 0xCFAA,
	28331 - 11905: 0x9CD8,
	28332 - 11905: 0x9CD9,
	28333 - 11905: 0x9CDA,
	28334 - 11905: 0x9CDB,
	28335 - 11905: 0xCBDD,
	28336 - 11905: 0x9CDC,
	28337 - 11905: 0xE4DA,
	28338 - 11905: 0xE4D1,
	28339 - 11905: 0x9CDD,
	28340 - 11905: 0xE4E5,
	28341 - 11905: 0x9CDE,
	28342 - 11905: 0xC8DC,
	28343 - 11905: 0xE4E3,
	28344 - 11905: 0x9CDF,
	28345 - 11905: 0x9CE0,
	28346 - 11905: 0xC4E7,
	28347 - 11905: 0xE4E2,
	28348 - 11905: 0x9CE1,
	28349 - 11905: 0xE4E1,
	28350 - 11905: 0x9CE2,
	28351 - 11905: 0x9CE3,
	28352 - 11905: 0x9CE4,
	28353 - 11905: 0xB3FC,
	28354 - 11905: 0xE4E8,
	28355 - 11905: 0x9CE5,
	28356 - 11905: 0x9CE6,
	28357 - 11905: 0x9CE7,
	28358 - 11905: 0x9CE8,
	28359 - 11905: 0xB5E1,
	28360 - 11905: 0x9CE9,
	28361 - 11905: 0x9CEA,
	28362 - 11905: 0x9CEB,
	28363 - 11905: 0xD7CC,
	28364 - 11905: 0x9CEC,
	28365 - 11905: 0x9CED,
	28366 - 11905: 0x9CEE,
	28367 - 11905: 0xE4E6,
	28368 - 11905: 0x9CEF,
	28369 - 11905: 0xBBAC,
	28370 - 11905: 0x9CF0,
	28371 - 11905: 0xD7D2,
	28372 - 11905: 0xCCCF,
	28373 - 11905: 0xEBF8,
	28374 - 11905: 0x9CF1,
	28375 - 11905: 0xE4E4,
	28376 - 11905: 0x9CF2,
	28377 - 11905: 0x9CF3,
	28378 - 11905: 0xB9F6,
	28379 - 11905: 0x9CF4,
	28380 - 11905: 0x9CF5,
	28381 - 11905: 0x9CF6,
	28382 - 11905: 0xD6CD,
	28383 - 11905: 0xE4D9,
	28384 - 11905: 0xE4DC,
	28385 - 11905: 0xC2FA,
	28386 - 11905: 0xE4DE,
	28387 - 11905: 0x9CF7,
	28388 - 11905: 0xC2CB,
	28389 - 11905: 0xC0C4,
	28390 - 11905: 0xC2D0,
	28391 - 11905: 0x9CF8,
	28392 - 11905: 0xB1F5,
	28393 - 11905: 0xCCB2,
	28394 - 11905: 0x9CF9,
	28395 - 11905: 0x9CFA,
	28396 - 11905: 0x9CFB,
	28397 - 11905: 0x9CFC,
	28398 - 11905: 0x9CFD,
	28399 - 11905: 0x9CFE,
	28400 - 11905: 0x9D40,
	28401 - 11905: 0x9D41,
	28402 - 11905: 0x9D42,
	28403 - 11905: 0x9D43,
	28404 - 11905: 0xB5CE,
	28405 - 11905: 0x9D44,
	28406 - 11905: 0x9D45,
	28407 - 11905: 0x9D46,
	28408 - 11905: 0x9D47,
	28409 - 11905: 0xE4EF,
	28410 - 11905: 0x9D48,
	28411 - 11905: 0x9D49,
	28412 - 11905: 0x9D4A,
	28413 - 11905: 0x9D4B,
	28414 - 11905: 0x9D4C,
	28415 - 11905: 0x9D4D,
	28416 - 11905: 0x9D4E,
	28417 - 11905: 0x9D4F,
	28418 - 11905: 0xC6AF,
	28419 - 11905: 0x9D50,
	28420 - 11905: 0x9D51,
	28421 - 11905: 0x9D52,
	28422 - 11905: 0xC6E1,
	28423 - 11905: 0x9D53,
	28424 - 11905: 0x9D54,
	28425 - 11905: 0xE4F5,
	28426 - 11905: 0x9D55,
	28427 - 11905: 0x9D56,
	28428 - 11905: 0x9D57,
	28429 - 11905: 0x9D58,
	28430 - 11905: 0x9D59,
	28431 - 11905: 0xC2A9,
	28432 - 11905: 0x9D5A,
	28433 - 11905: 0x9D5B,
	28434 - 11905: 0x9D5C,
	28435 - 11905: 0xC0EC,
	28436 - 11905: 0xD1DD,
	28437 - 11905: 0xE4EE,
	28438 - 11905: 0x9D5D,
	28439 - 11905: 0x9D5E,
	28440 - 11905: 0x9D5F,
	28441 - 11905: 0x9D60,
	28442 - 11905: 0x9D61,
	28443 - 11905: 0x9D62,
	28444 - 11905: 0x9D63,
	28445 - 11905: 0x9D64,
	28446 - 11905: 0x9D65,
	28447 - 11905: 0x9D66,
	28448 - 11905: 0xC4AE,
	28449 - 11905: 0x9D67,
	28450 - 11905: 0x9D68,
	28451 - 11905: 0x9D69,
	28452 - 11905: 0xE4ED,
	28453 - 11905: 0x9D6A,
	28454 - 11905: 0x9D6B,
	28455 - 11905: 0x9D6C,
	28456 - 11905: 0x9D6D,
	28457 - 11905: 0xE4F6,
	28458 - 11905: 0xE4F4,
	28459 - 11905: 0xC2FE,
	28460 - 11905: 0x9D6E,
	28461 - 11905: 0xE4DD,
	28462 - 11905: 0x9D6F,
	28463 - 11905: 0xE4F0,
	28464 - 11905: 0x9D70,
	28465 - 11905: 0xCAFE,
	28466 - 11905: 0x9D71,
	28467 - 11905: 0xD5C4,
	28468 - 11905: 0x9D72,
	28469 - 11905: 0x9D73,
	28470 - 11905: 0xE4F1,
	28471 - 11905: 0x9D74,
	28472 - 11905: 0x9D75,
	28473 - 11905: 0x9D76,
	28474 - 11905: 0x9D77,
	28475 - 11905: 0x9D78,
	28476 - 11905: 0x9D79,
	28477 - 11905: 0x9D7A,
	28478 - 11905: 0xD1FA,
	28479 - 11905: 0x9D7B,
	28480 - 11905: 0x9D7C,
	28481 - 11905: 0x9D7D,
	28482 - 11905: 0x9D7E,
	28483 - 11905: 0x9D80,
	28484 - 11905: 0x9D81,
	28485 - 11905: 0x9D82,
	28486 - 11905: 0xE4EB,
	28487 - 11905: 0xE4EC,
	28488 - 11905: 0x9D83,
	28489 - 11905: 0x9D84,
	28490 - 11905: 0x9D85,
	28491 - 11905: 0xE4F2,
	28492 - 11905: 0x9D86,
	28493 - 11905: 0xCEAB,
	28494 - 11905: 0x9D87,
	28495 - 11905: 0x9D88,
	28496 - 11905: 0x9D89,
	28497 - 11905: 0x9D8A,
	28498 - 11905: 0x9D8B,
	28499 - 11905: 0x9D8C,
	28500 - 11905: 0x9D8D,
	28501 - 11905: 0x9D8E,
	28502 - 11905: 0x9D8F,
	28503 - 11905: 0x9D90,
	28504 - 11905: 0xC5CB,
	28505 - 11905: 0x9D91,
	28506 - 11905: 0x9D92,
	28507 - 11905: 0x9D93,
	28508 - 11905: 0xC7B1,
	28509 - 11905: 0x9D94,
	28510 - 11905: 0xC2BA,
	28511 - 11905: 0x9D95,
	28512 - 11905: 0x9D96,
	28513 - 11905: 0x9D97,
	28514 - 11905: 0xE4EA,
	28515 - 11905: 0x9D98,
	28516 - 11905: 0x9D99,
	28517 - 11905: 0x9D9A,
	28518 - 11905: 0xC1CA,
	28519 - 11905: 0x9D9B,
	28520 - 11905: 0x9D9C,
	28521 - 11905: 0x9D9D,
	28522 - 11905: 0x9D9E,
	28523 - 11905: 0x9D9F,
	28524 - 11905: 0x9DA0,
	28525 - 11905: 0xCCB6,
	28526 - 11905: 0xB3B1,
	28527 - 11905: 0x9DA1,
	28528 - 11905: 0x9DA2,
	28529 - 11905: 0x9DA3,
	28530 - 11905: 0xE4FB,
	28531 - 11905: 0x9DA4,
	28532 - 11905: 0xE4F3,
	28533 - 11905: 0x9DA5,
	28534 - 11905: 0x9DA6,
	28535 - 11905: 0x9DA7,
	28536 - 11905: 0xE4FA,
	28537 - 11905: 0x9DA8,
	28538 - 11905: 0xE4FD,
	28539 - 11905: 0x9DA9,
	28540 - 11905: 0xE4FC,
	28541 - 11905: 0x9DAA,
	28542 - 11905: 0x9DAB,
	28543 - 11905: 0x9DAC,
	28544 - 11905: 0x9DAD,
	28545 - 11905: 0x9DAE,
	28546 - 11905: 0x9DAF,
	28547 - 11905: 0x9DB0,
	28548 - 11905: 0xB3CE,
	28549 - 11905: 0x9DB1,
	28550 - 11905: 0x9DB2,
	28551 - 11905: 0x9DB3,
	28552 - 11905: 0xB3BA,
	28553 - 11905: 0xE4F7,
	28554 - 11905: 0x9DB4,
	28555 - 11905: 0x9DB5,
	28556 - 11905: 0xE4F9,
	28557 - 11905: 0xE4F8,
	28558 - 11905: 0xC5EC,
	28559 - 11905: 0x9DB6,
	28560 - 11905: 0x9DB7,
	28561 - 11905: 0x9DB8,
	28562 - 11905: 0x9DB9,
	28563 - 11905: 0x9DBA,
	28564 - 11905: 0x9DBB,
	28565 - 11905: 0x9DBC,
	28566 - 11905: 0x9DBD,
	28567 - 11905: 0x9DBE,
	28568 - 11905: 0x9DBF,
	28569 - 11905: 0x9DC0,
	28570 - 11905: 0x9DC1,
	28571 - 11905: 0x9DC2,
	28572 - 11905: 0xC0BD,
	28573 - 11905: 0x9DC3,
	28574 - 11905: 0x9DC4,
	28575 - 11905: 0x9DC5,
	28576 - 11905: 0x9DC6,
	28577 - 11905: 0xD4E8,
	28578 - 11905: 0x9DC7,
	28579 - 11905: 0x9DC8,
	28580 - 11905: 0x9DC9,
	28581 - 11905: 0x9DCA,
	28582 - 11905: 0x9DCB,
	28583 - 11905: 0xE5A2,
	28584 - 11905: 0x9DCC,
	28585 - 11905: 0x9DCD,
	28586 - 11905: 0x9DCE,
	28587 - 11905: 0x9DCF,
	28588 - 11905: 0x9DD0,
	28589 - 11905: 0x9DD1,
	28590 - 11905: 0x9DD2,
	28591 - 11905: 0x9DD3,
	28592 - 11905: 0x9DD4,
	28593 - 11905: 0x9DD5,
	28594 - 11905: 0x9DD6,
	28595 - 11905: 0xB0C4,
	28596 - 11905: 0x9DD7,
	28597 - 11905: 0x9DD8,
	28598 - 11905: 0xE5A4,
	28599 - 11905: 0x9DD9,
	28600 - 11905: 0x9DDA,
	28601 - 11905: 0xE5A3,
	28602 - 11905: 0x9DDB,
	28603 - 11905: 0x9DDC,
	28604 - 11905: 0x9DDD,
	28605 - 11905: 0x9DDE,
	28606 - 11905: 0x9DDF,
	28607 - 11905: 0x9DE0,
	28608 - 11905: 0xBCA4,
	28609 - 11905: 0x9DE1,
	28610 - 11905: 0xE5A5,
	28611 - 11905: 0x9DE2,
	28612 - 11905: 0x9DE3,
	28613 - 11905: 0x9DE4,
	28614 - 11905: 0x9DE5,
	28615 - 11905: 0x9DE6,
	28616 - 11905: 0x9DE7,
	28617 - 11905: 0xE5A1,
	28618 - 11905: 0x9DE8,
	28619 - 11905: 0x9DE9,
	28620 - 11905: 0x9DEA,
	28621 - 11905: 0x9DEB,
	28622 - 11905: 0x9DEC,
	28623 - 11905: 0x9DED,
	28624 - 11905: 0x9DEE,
	28625 - 11905: 0xE4FE,
	28626 - 11905: 0xB1F4,
	28627 - 11905: 0x9DEF,
	28628 - 11905: 0x9DF0,
	28629 - 11905: 0x9DF1,
	28630 - 11905: 0x9DF2,
	28631 - 11905: 0x9DF3,
	28632 - 11905: 0x9DF4,
	28633 - 11905: 0x9DF5,
	28634 - 11905: 0x9DF6,
	28635 - 11905: 0x9DF7,
	28636 - 11905: 0x9DF8,
	28637 - 11905: 0x9DF9,
	28638 - 11905: 0xE5A8,
	28639 - 11905: 0x9DFA,
	28640 - 11905: 0xE5A9,
	28641 - 11905: 0xE5A6,
	28642 - 11905: 0x9DFB,
	28643 - 11905: 0x9DFC,
	28644 - 11905: 0x9DFD,
	28645 - 11905: 0x9DFE,
	28646 - 11905: 0x9E40,
	28647 - 11905: 0x9E41,
	28648 - 11905: 0x9E42,
	28649 - 11905: 0x9E43,
	28650 - 11905: 0x9E44,
	28651 - 11905: 0x9E45,
	28652 - 11905: 0x9E46,
	28653 - 11905: 0x9E47,
	28654 - 11905: 0xE5A7,
	28655 - 11905: 0xE5AA,
	28656 - 11905: 0x9E48,
	28657 - 11905: 0x9E49,
	28658 - 11905: 0x9E4A,
	28659 - 11905: 0x9E4B,
	28660 - 11905: 0x9E4C,
	28661 - 11905: 0x9E4D,
	28662 - 11905: 0x9E4E,
	28663 - 11905: 0x9E4F,
	28664 - 11905: 0x9E50,
	28665 - 11905: 0x9E51,
	28666 - 11905: 0x9E52,
	28667 - 11905: 0x9E53,
	28668 - 11905: 0x9E54,
	28669 - 11905: 0x9E55,
	28670 - 11905: 0x9E56,
	28671 - 11905: 0x9E57,
	28672 - 11905: 0x9E58,
	28673 - 11905: 0x9E59,
	28674 - 11905: 0x9E5A,
	28675 - 11905: 0x9E5B,
	28676 - 11905: 0x9E5C,
	28677 - 11905: 0x9E5D,
	28678 - 11905: 0x9E5E,
	28679 - 11905: 0x9E5F,
	28680 - 11905: 0x9E60,
	28681 - 11905: 0x9E61,
	28682 - 11905: 0x9E62,
	28683 - 11905: 0x9E63,
	28684 - 11905: 0x9E64,
	28685 - 11905: 0x9E65,
	28686 - 11905: 0x9E66,
	28687 - 11905: 0x9E67,
	28688 - 11905: 0x9E68,
	28689 - 11905: 0xC6D9,
	28690 - 11905: 0x9E69,
	28691 - 11905: 0x9E6A,
	28692 - 11905: 0x9E6B,
	28693 - 11905: 0x9E6C,
	28694 - 11905: 0x9E6D,
	28695 - 11905: 0x9E6E,
	28696 - 11905: 0x9E6F,
	28697 - 11905: 0x9E70,
	28698 - 11905: 0xE5AB,
	28699 - 11905: 0xE5AD,
	28700 - 11905: 0x9E71,
	28701 - 11905: 0x9E72,
	28702 - 11905: 0x9E73,
	28703 - 11905: 0x9E74,
	28704 - 11905: 0x9E75,
	28705 - 11905: 0x9E76,
	28706 - 11905: 0x9E77,
	28707 - 11905: 0xE5AC,
	28708 - 11905: 0x9E78,
	28709 - 11905: 0x9E79,
	28710 - 11905: 0x9E7A,
	28711 - 11905: 0x9E7B,
	28712 - 11905: 0x9E7C,
	28713 - 11905: 0x9E7D,
	28714 - 11905: 0x9E7E,
	28715 - 11905: 0x9E80,
	28716 - 11905: 0x9E81,
	28717 - 11905: 0x9E82,
	28718 - 11905: 0x9E83,
	28719 - 11905: 0x9E84,
	28720 - 11905: 0x9E85,
	28721 - 11905: 0x9E86,
	28722 - 11905: 0x9E87,
	28723 - 11905: 0x9E88,
	28724 - 11905: 0x9E89,
	28725 - 11905: 0xE5AF,
	28726 - 11905: 0x9E8A,
	28727 - 11905: 0x9E8B,
	28728 - 11905: 0x9E8C,
	28729 - 11905: 0xE5AE,
	28730 - 11905: 0x9E8D,
	28731 - 11905: 0x9E8E,
	28732 - 11905: 0x9E8F,
	28733 - 11905: 0x9E90,
	28734 - 11905: 0x9E91,
	28735 - 11905: 0x9E92,
	28736 - 11905: 0x9E93,
	28737 - 11905: 0x9E94,
	28738 - 11905: 0x9E95,
	28739 - 11905: 0x9E96,
	28740 - 11905: 0x9E97,
	28741 - 11905: 0x9E98,
	28742 - 11905: 0x9E99,
	28743 - 11905: 0x9E9A,
	28744 - 11905: 0x9E9B,
	28745 - 11905: 0x9E9C,
	28746 - 11905: 0x9E9D,
	28747 - 11905: 0x9E9E,
	28748 - 11905: 0xB9E0,
	28749 - 11905: 0x9E9F,
	28750 - 11905: 0x9EA0,
	28751 - 11905: 0xE5B0,
	28752 - 11905: 0x9EA1,
	28753 - 11905: 0x9EA2,
	28754 - 11905: 0x9EA3,
	28755 - 11905: 0x9EA4,
	28756 - 11905: 0x9EA5,
	28757 - 11905: 0x9EA6,
	28758 - 11905: 0x9EA7,
	28759 - 11905: 0x9EA8,
	28760 - 11905: 0x9EA9,
	28761 - 11905: 0x9EAA,
	28762 - 11905: 0x9EAB,
	28763 - 11905: 0x9EAC,
	28764 - 11905: 0x9EAD,
	28765 - 11905: 0x9EAE,
	28766 - 11905: 0xE5B1,
	28767 - 11905: 0x9EAF,
	28768 - 11905: 0x9EB0,
	28769 - 11905: 0x9EB1,
	28770 - 11905: 0x9EB2,
	28771 - 11905: 0x9EB3,
	28772 - 11905: 0x9EB4,
	28773 - 11905: 0x9EB5,
	28774 - 11905: 0x9EB6,
	28775 - 11905: 0x9EB7,
	28776 - 11905: 0x9EB8,
	28777 - 11905: 0x9EB9,
	28778 - 11905: 0x9EBA,
	28779 - 11905: 0xBBF0,
	28780 - 11905: 0xECE1,
	28781 - 11905: 0xC3F0,
	28782 - 11905: 0x9EBB,
	28783 - 11905: 0xB5C6,
	28784 - 11905: 0xBBD2,
	28785 - 11905: 0x9EBC,
	28786 - 11905: 0x9EBD,
	28787 - 11905: 0x9EBE,
	28788 - 11905: 0x9EBF,
	28789 - 11905: 0xC1E9,
	28790 - 11905: 0xD4EE,
	28791 - 11905: 0x9EC0,
	28792 - 11905: 0xBEC4,
	28793 - 11905: 0x9EC1,
	28794 - 11905: 0x9EC2,
	28795 - 11905: 0x9EC3,
	28796 - 11905: 0xD7C6,
	28797 - 11905: 0x9EC4,
	28798 - 11905: 0xD4D6,
	28799 - 11905: 0xB2D3,
	28800 - 11905: 0xECBE,
	28801 - 11905: 0x9EC5,
	28802 - 11905: 0x9EC6,
	28803 - 11905: 0x9EC7,
	28804 - 11905: 0x9EC8,
	28805 - 11905: 0xEAC1,
	28806 - 11905: 0x9EC9,
	28807 - 11905: 0x9ECA,
	28808 - 11905: 0x9ECB,
	28809 - 11905: 0xC2AF,
	28810 - 11905: 0xB4B6,
	28811 - 11905: 0x9ECC,
	28812 - 11905: 0x9ECD,
	28813 - 11905: 0x9ECE,
	28814 - 11905: 0xD1D7,
	28815 - 11905: 0x9ECF,
	28816 - 11905: 0x9ED0,
	28817 - 11905: 0x9ED1,
	28818 - 11905: 0xB3B4,
	28819 - 11905: 0x9ED2,
	28820 - 11905: 0xC8B2,
	28821 - 11905: 0xBFBB,
	28822 - 11905: 0xECC0,
	28823 - 11905: 0x9ED3,
	28824 - 11905: 0x9ED4,
	28825 - 11905: 0xD6CB,
	28826 - 11905: 0x9ED5,
	28827 - 11905: 0x9ED6,
	28828 - 11905: 0xECBF,
	28829 - 11905: 0xECC1,
	28830 - 11905: 0x9ED7,
	28831 - 11905: 0x9ED8,
	28832 - 11905: 0x9ED9,
	28833 - 11905: 0x9EDA,
	28834 - 11905: 0x9EDB,
	28835 - 11905: 0x9EDC,
	28836 - 11905: 0x9EDD,
	28837 - 11905: 0x9EDE,
	28838 - 11905: 0x9EDF,
	28839 - 11905: 0x9EE0,
	28840 - 11905: 0x9EE1,
	28841 - 11905: 0x9EE2,
	28842 - 11905: 0x9EE3,
	28843 - 11905: 0xECC5,
	28844 - 11905: 0xBEE6,
	28845 - 11905: 0xCCBF,
	28846 - 11905: 0xC5DA,
	28847 - 11905: 0xBEBC,
	28848 - 11905: 0x9EE4,
	28849 - 11905: 0xECC6,
	28850 - 11905: 0x9EE5,
	28851 - 11905: 0xB1FE,
	28852 - 11905: 0x9EE6,
	28853 - 11905: 0x9EE7,
	28854 - 11905: 0x9EE8,
	28855 - 11905: 0xECC4,
	28856 - 11905: 0xD5A8,
	28857 - 11905: 0xB5E3,
	28858 - 11905: 0x9EE9,
	28859 - 11905: 0xECC2,
	28860 - 11905: 0xC1B6,
	28861 - 11905: 0xB3E3,
	28862 - 11905: 0x9EEA,
	28863 - 11905: 0x9EEB,
	28864 - 11905: 0xECC3,
	28865 - 11905: 0xCBB8,
	28866 - 11905: 0xC0C3,
	28867 - 11905: 0xCCFE,
	28868 - 11905: 0x9EEC,
	28869 - 11905: 0x9EED,
	28870 - 11905: 0x9EEE,
	28871 - 11905: 0x9EEF,
	28872 - 11905: 0xC1D2,
	28873 - 11905: 0x9EF0,
	28874 - 11905: 0xECC8,
	28875 - 11905: 0x9EF1,
	28876 - 11905: 0x9EF2,
	28877 - 11905: 0x9EF3,
	28878 - 11905: 0x9EF4,
	28879 - 11905: 0x9EF5,
	28880 - 11905: 0x9EF6,
	28881 - 11905: 0x9EF7,
	28882 - 11905: 0x9EF8,
	28883 - 11905: 0x9EF9,
	28884 - 11905: 0x9EFA,
	28885 - 11905: 0x9EFB,
	28886 - 11905: 0x9EFC,
	28887 - 11905: 0x9EFD,
	28888 - 11905: 0xBAE6,
	28889 - 11905: 0xC0D3,
	28890 - 11905: 0x9EFE,
	28891 - 11905: 0xD6F2,
	28892 - 11905: 0x9F40,
	28893 - 11905: 0x9F41,
	28894 - 11905: 0x9F42,
	28895 - 11905: 0xD1CC,
	28896 - 11905: 0x9F43,
	28897 - 11905: 0x9F44,
	28898 - 11905: 0x9F45,
	28899 - 11905: 0x9F46,
	28900 - 11905: 0xBFBE,
	28901 - 11905: 0x9F47,
	28902 - 11905: 0xB7B3,
	28903 - 11905: 0xC9D5,
	28904 - 11905: 0xECC7,
	28905 - 11905: 0xBBE2,
	28906 - 11905: 0x9F48,
	28907 - 11905: 0xCCCC,
	28908 - 11905: 0xBDFD,
	28909 - 11905: 0xC8C8,
	28910 - 11905: 0x9F49,
	28911 - 11905: 0xCFA9,
	28912 - 11905: 0x9F4A,
	28913 - 11905: 0x9F4B,
	28914 - 11905: 0x9F4C,
	28915 - 11905: 0x9F4D,
	28916 - 11905: 0x9F4E,
	28917 - 11905: 0x9F4F,
	28918 - 11905: 0x9F50,
	28919 - 11905: 0xCDE9,
	28920 - 11905: 0x9F51,
	28921 - 11905: 0xC5EB,
	28922 - 11905: 0x9F52,
	28923 - 11905: 0x9F53,
	28924 - 11905: 0x9F54,
	28925 - 11905: 0xB7E9,
	28926 - 11905: 0x9F55,
	28927 - 11905: 0x9F56,
	28928 - 11905: 0x9F57,
	28929 - 11905: 0x9F58,
	28930 - 11905: 0x9F59,
	28931 - 11905: 0x9F5A,
	28932 - 11905: 0x9F5B,
	28933 - 11905: 0x9F5C,
	28934 - 11905: 0x9F5D,
	28935 - 11905: 0x9F5E,
	28936 - 11905: 0x9F5F,
	28937 - 11905: 0xD1C9,
	28938 - 11905: 0xBAB8,
	28939 - 11905: 0x9F60,
	28940 - 11905: 0x9F61,
	28941 - 11905: 0x9F62,
	28942 - 11905: 0x9F63,
	28943 - 11905: 0x9F64,
	28944 - 11905: 0xECC9,
	28945 - 11905: 0x9F65,
	28946 - 11905: 0x9F66,
	28947 - 11905: 0xECCA,
	28948 - 11905: 0x9F67,
	28949 - 11905: 0xBBC0,
	28950 - 11905: 0xECCB,
	28951 - 11905: 0x9F68,
	28952 - 11905: 0xECE2,
	28953 - 11905: 0xB1BA,
	28954 - 11905: 0xB7D9,
	28955 - 11905: 0x9F69,
	28956 - 11905: 0x9F6A,
	28957 - 11905: 0x9F6B,
	28958 - 11905: 0x9F6C,
	28959 - 11905: 0x9F6D,
	28960 - 11905: 0x9F6E,
	28961 - 11905: 0x9F6F,
	28962 - 11905: 0x9F70,
	28963 - 11905: 0x9F71,
	28964 - 11905: 0x9F72,
	28965 - 11905: 0x9F73,
	28966 - 11905: 0xBDB9,
	28967 - 11905: 0x9F74,
	28968 - 11905: 0x9F75,
	28969 - 11905: 0x9F76,
	28970 - 11905: 0x9F77,
	28971 - 11905: 0x9F78,
	28972 - 11905: 0x9F79,
	28973 - 11905: 0x9F7A,
	28974 - 11905: 0x9F7B,
	28975 - 11905: 0xECCC,
	28976 - 11905: 0xD1E6,
	28977 - 11905: 0xECCD,
	28978 - 11905: 0x9F7C,
	28979 - 11905: 0x9F7D,
	28980 - 11905: 0x9F7E,
	28981 - 11905: 0x9F80,
	28982 - 11905: 0xC8BB,
	28983 - 11905: 0x9F81,
	28984 - 11905: 0x9F82,
	28985 - 11905: 0x9F83,
	28986 - 11905: 0x9F84,
	28987 - 11905: 0x9F85,
	28988 - 11905: 0x9F86,
	28989 - 11905: 0x9F87,
	28990 - 11905: 0x9F88,
	28991 - 11905: 0x9F89,
	28992 - 11905: 0x9F8A,
	28993 - 11905: 0x9F8B,
	28994 - 11905: 0x9F8C,
	28995 - 11905: 0x9F8D,
	28996 - 11905: 0x9F8E,
	28997 - 11905: 0xECD1,
	28998 - 11905: 0x9F8F,
	28999 - 11905: 0x9F90,
	29000 - 11905: 0x9F91,
	29001 - 11905: 0x9F92,
	29002 - 11905: 0xECD3,
	29003 - 11905: 0x9F93,
	29004 - 11905: 0xBBCD,
	29005 - 11905: 0x9F94,
	29006 - 11905: 0xBCE5,
	29007 - 11905: 0x9F95,
	29008 - 11905: 0x9F96,
	29009 - 11905: 0x9F97,
	29010 - 11905: 0x9F98,
	29011 - 11905: 0x9F99,
	29012 - 11905: 0x9F9A,
	29013 - 11905: 0x9F9B,
	29014 - 11905: 0x9F9C,
	29015 - 11905: 0x9F9D,
	29016 - 11905: 0x9F9E,
	29017 - 11905: 0x9F9F,
	29018 - 11905: 0x9FA0,
	29019 - 11905: 0x9FA1,
	29020 - 11905: 0xECCF,
	29021 - 11905: 0x9FA2,
	29022 - 11905: 0xC9B7,
	29023 - 11905: 0x9FA3,
	29024 - 11905: 0x9FA4,
	29025 - 11905: 0x9FA5,
	29026 - 11905: 0x9FA6,
	29027 - 11905: 0x9FA7,
	29028 - 11905: 0xC3BA,
	29029 - 11905: 0x9FA8,
	29030 - 11905: 0xECE3,
	29031 - 11905: 0xD5D5,
	29032 - 11905: 0xECD0,
	29033 - 11905: 0x9FA9,
	29034 - 11905: 0x9FAA,
	29035 - 11905: 0x9FAB,
	29036 - 11905: 0x9FAC,
	29037 - 11905: 0x9FAD,
	29038 - 11905: 0xD6F3,
	29039 - 11905: 0x9FAE,
	29040 - 11905: 0x9FAF,
	29041 - 11905: 0x9FB0,
	29042 - 11905: 0xECD2,
	29043 - 11905: 0xECCE,
	29044 - 11905: 0x9FB1,
	29045 - 11905: 0x9FB2,
	29046 - 11905: 0x9FB3,
	29047 - 11905: 0x9FB4,
	29048 - 11905: 0xECD4,
	29049 - 11905: 0x9FB5,
	29050 - 11905: 0xECD5,
	29051 - 11905: 0x9FB6,
	29052 - 11905: 0x9FB7,
	29053 - 11905: 0xC9BF,
	29054 - 11905: 0x9FB8,
	29055 - 11905: 0x9FB9,
	29056 - 11905: 0x9FBA,
	29057 - 11905: 0x9FBB,
	29058 - 11905: 0x9FBC,
	29059 - 11905: 0x9FBD,
	29060 - 11905: 0xCFA8,
	29061 - 11905: 0x9FBE,
	29062 - 11905: 0x9FBF,
	29063 - 11905: 0x9FC0,
	29064 - 11905: 0x9FC1,
	29065 - 11905: 0x9FC2,
	29066 - 11905: 0xD0DC,
	29067 - 11905: 0x9FC3,
	29068 - 11905: 0x9FC4,
	29069 - 11905: 0x9FC5,
	29070 - 11905: 0x9FC6,
	29071 - 11905: 0xD1AC,
	29072 - 11905: 0x9FC7,
	29073 - 11905: 0x9FC8,
	29074 - 11905: 0x9FC9,
	29075 - 11905: 0x9FCA,
	29076 - 11905: 0xC8DB,
	29077 - 11905: 0x9FCB,
	29078 - 11905: 0x9FCC,
	29079 - 11905: 0x9FCD,
	29080 - 11905: 0xECD6,
	29081 - 11905: 0xCEF5,
	29082 - 11905: 0x9FCE,
	29083 - 11905: 0x9FCF,
	29084 - 11905: 0x9FD0,
	29085 - 11905: 0x9FD1,
	29086 - 11905: 0x9FD2,
	29087 - 11905: 0xCAEC,
	29088 - 11905: 0xECDA,
	29089 - 11905: 0x9FD3,
	29090 - 11905: 0x9FD4,
	29091 - 11905: 0x9FD5,
	29092 - 11905: 0x9FD6,
	29093 - 11905: 0x9FD7,
	29094 - 11905: 0x9FD8,
	29095 - 11905: 0x9FD9,
	29096 - 11905: 0xECD9,
	29097 - 11905: 0x9FDA,
	29098 - 11905: 0x9FDB,
	29099 - 11905: 0x9FDC,
	29100 - 11905: 0xB0BE,
	29101 - 11905: 0x9FDD,
	29102 - 11905: 0x9FDE,
	29103 - 11905: 0x9FDF,
	29104 - 11905: 0x9FE0,
	29105 - 11905: 0x9FE1,
	29106 - 11905: 0x9FE2,
	29107 - 11905: 0xECD7,
	29108 - 11905: 0x9FE3,
	29109 - 11905: 0xECD8,
	29110 - 11905: 0x9FE4,
	29111 - 11905: 0x9FE5,
	29112 - 11905: 0x9FE6,
	29113 - 11905: 0xECE4,
	29114 - 11905: 0x9FE7,
	29115 - 11905: 0x9FE8,
	29116 - 11905: 0x9FE9,
	29117 - 11905: 0x9FEA,
	29118 - 11905: 0x9FEB,
	29119 - 11905: 0x9FEC,
	29120 - 11905: 0x9FED,
	29121 - 11905: 0x9FEE,
	29122 - 11905: 0x9FEF,
	29123 - 11905: 0xC8BC,
	29124 - 11905: 0x9FF0,
	29125 - 11905: 0x9FF1,
	29126 - 11905: 0x9FF2,
	29127 - 11905: 0x9FF3,
	29128 - 11905: 0x9FF4,
	29129 - 11905: 0x9FF5,
	29130 - 11905: 0x9FF6,
	29131 - 11905: 0x9FF7,
	29132 - 11905: 0x9FF8,
	29133 - 11905: 0x9FF9,
	29134 - 11905: 0xC1C7,
	29135 - 11905: 0x9FFA,
	29136 - 11905: 0x9FFB,
	29137 - 11905: 0x9FFC,
	29138 - 11905: 0x9FFD,
	29139 - 11905: 0x9FFE,
	29140 - 11905: 0xECDC,
	29141 - 11905: 0xD1E0,
	29142 - 11905: 0xA040,
	29143 - 11905: 0xA041,
	29144 - 11905: 0xA042,
	29145 - 11905: 0xA043,
	29146 - 11905: 0xA044,
	29147 - 11905: 0xA045,
	29148 - 11905: 0xA046,
	29149 - 11905: 0xA047,
	29150 - 11905: 0xA048,
	29151 - 11905: 0xA049,
	29152 - 11905: 0xECDB,
	29153 - 11905: 0xA04A,
	29154 - 11905: 0xA04B,
	29155 - 11905: 0xA04C,
	29156 - 11905: 0xA04D,
	29157 - 11905: 0xD4EF,
	29158 - 11905: 0xA04E,
	29159 - 11905: 0xECDD,
	29160 - 11905: 0xA04F,
	29161 - 11905: 0xA050,
	29162 - 11905: 0xA051,
	29163 - 11905: 0xA052,
	29164 - 11905: 0xA053,
	29165 - 11905: 0xA054,
	29166 - 11905: 0xDBC6,
	29167 - 11905: 0xA055,
	29168 - 11905: 0xA056,
	29169 - 11905: 0xA057,
	29170 - 11905: 0xA058,
	29171 - 11905: 0xA059,
	29172 - 11905: 0xA05A,
	29173 - 11905: 0xA05B,
	29174 - 11905: 0xA05C,
	29175 - 11905: 0xA05D,
	29176 - 11905: 0xA05E,
	29177 - 11905: 0xECDE,
	29178 - 11905: 0xA05F,
	29179 - 11905: 0xA060,
	29180 - 11905: 0xA061,
	29181 - 11905: 0xA062,
	29182 - 11905: 0xA063,
	29183 - 11905: 0xA064,
	29184 - 11905: 0xA065,
	29185 - 11905: 0xA066,
	29186 - 11905: 0xA067,
	29187 - 11905: 0xA068,
	29188 - 11905: 0xA069,
	29189 - 11905: 0xA06A,
	29190 - 11905: 0xB1AC,
	29191 - 11905: 0xA06B,
	29192 - 11905: 0xA06C,
	29193 - 11905: 0xA06D,
	29194 - 11905: 0xA06E,
	29195 - 11905: 0xA06F,
	29196 - 11905: 0xA070,
	29197 - 11905: 0xA071,
	29198 - 11905: 0xA072,
	29199 - 11905: 0xA073,
	29200 - 11905: 0xA074,
	29201 - 11905: 0xA075,
	29202 - 11905: 0xA076,
	29203 - 11905: 0xA077,
	29204 - 11905: 0xA078,
	29205 - 11905: 0xA079,
	29206 - 11905: 0xA07A,
	29207 - 11905: 0xA07B,
	29208 - 11905: 0xA07C,
	29209 - 11905: 0xA07D,
	29210 - 11905: 0xA07E,
	29211 - 11905: 0xA080,
	29212 - 11905: 0xA081,
	29213 - 11905: 0xECDF,
	29214 - 11905: 0xA082,
	29215 - 11905: 0xA083,
	29216 - 11905: 0xA084,
	29217 - 11905: 0xA085,
	29218 - 11905: 0xA086,
	29219 - 11905: 0xA087,
	29220 - 11905: 0xA088,
	29221 - 11905: 0xA089,
	29222 - 11905: 0xA08A,
	29223 - 11905: 0xA08B,
	29224 - 11905: 0xECE0,
	29225 - 11905: 0xA08C,
	29226 - 11905: 0xD7A6,
	29227 - 11905: 0xA08D,
	29228 - 11905: 0xC5C0,
	29229 - 11905: 0xA08E,
	29230 - 11905: 0xA08F,
	29231 - 11905: 0xA090,
	29232 - 11905: 0xEBBC,
	29233 - 11905: 0xB0AE,
	29234 - 11905: 0xA091,
	29235 - 11905: 0xA092,
	29236 - 11905: 0xA093,
	29237 - 11905: 0xBEF4,
	29238 - 11905: 0xB8B8,
	29239 - 11905: 0xD2AF,
	29240 - 11905: 0xB0D6,
	29241 - 11905: 0xB5F9,
	29242 - 11905: 0xA094,
	29243 - 11905: 0xD8B3,
	29244 - 11905: 0xA095,
	29245 - 11905: 0xCBAC,
	29246 - 11905: 0xA096,
	29247 - 11905: 0xE3DD,
	29248 - 11905: 0xA097,
	29249 - 11905: 0xA098,
	29250 - 11905: 0xA099,
	29251 - 11905: 0xA09A,
	29252 - 11905: 0xA09B,
	29253 - 11905: 0xA09C,
	29254 - 11905: 0xA09D,
	29255 - 11905: 0xC6AC,
	29256 - 11905: 0xB0E6,
	29257 - 11905: 0xA09E,
	29258 - 11905: 0xA09F,
	29259 - 11905: 0xA0A0,
	29260 - 11905: 0xC5C6,
	29261 - 11905: 0xEBB9,
	29262 - 11905: 0xA0A1,
	29263 - 11905: 0xA0A2,
	29264 - 11905: 0xA0A3,
	29265 - 11905: 0xA0A4,
	29266 - 11905: 0xEBBA,
	29267 - 11905: 0xA0A5,
	29268 - 11905: 0xA0A6,
	29269 - 11905: 0xA0A7,
	29270 - 11905: 0xEBBB,
	29271 - 11905: 0xA0A8,
	29272 - 11905: 0xA0A9,
	29273 - 11905: 0xD1C0,
	29274 - 11905: 0xA0AA,
	29275 - 11905: 0xC5A3,
	29276 - 11905: 0xA0AB,
	29277 - 11905: 0xEAF2,
	29278 - 11905: 0xA0AC,
	29279 - 11905: 0xC4B2,
	29280 - 11905: 0xA0AD,
	29281 - 11905: 0xC4B5,
	29282 - 11905: 0xC0CE,
	29283 - 11905: 0xA0AE,
	29284 - 11905: 0xA0AF,
	29285 - 11905: 0xA0B0,
	29286 - 11905: 0xEAF3,
	29287 - 11905: 0xC4C1,
	29288 - 11905: 0xA0B1,
	29289 - 11905: 0xCEEF,
	29290 - 11905: 0xA0B2,
	29291 - 11905: 0xA0B3,
	29292 - 11905: 0xA0B4,
	29293 - 11905: 0xA0B5,
	29294 - 11905: 0xEAF0,
	29295 - 11905: 0xEAF4,
	29296 - 11905: 0xA0B6,
	29297 - 11905: 0xA0B7,
	29298 - 11905: 0xC9FC,
	29299 - 11905: 0xA0B8,
	29300 - 11905: 0xA0B9,
	29301 - 11905: 0xC7A3,
	29302 - 11905: 0xA0BA,
	29303 - 11905: 0xA0BB,
	29304 - 11905: 0xA0BC,
	29305 - 11905: 0xCCD8,
	29306 - 11905: 0xCEFE,
	29307 - 11905: 0xA0BD,
	29308 - 11905: 0xA0BE,
	29309 - 11905: 0xA0BF,
	29310 - 11905: 0xEAF5,
	29311 - 11905: 0xEAF6,
	29312 - 11905: 0xCFAC,
	29313 - 11905: 0xC0E7,
	29314 - 11905: 0xA0C0,
	29315 - 11905: 0xA0C1,
	29316 - 11905: 0xEAF7,
	29317 - 11905: 0xA0C2,
	29318 - 11905: 0xA0C3,
	29319 - 11905: 0xA0C4,
	29320 - 11905: 0xA0C5,
	29321 - 11905: 0xA0C6,
	29322 - 11905: 0xB6BF,
	29323 - 11905: 0xEAF8,
	29324 - 11905: 0xA0C7,
	29325 - 11905: 0xEAF9,
	29326 - 11905: 0xA0C8,
	29327 - 11905: 0xEAFA,
	29328 - 11905: 0xA0C9,
	29329 - 11905: 0xA0CA,
	29330 - 11905: 0xEAFB,
	29331 - 11905: 0xA0CB,
	29332 - 11905: 0xA0CC,
	29333 - 11905: 0xA0CD,
	29334 - 11905: 0xA0CE,
	29335 - 11905: 0xA0CF,
	29336 - 11905: 0xA0D0,
	29337 - 11905: 0xA0D1,
	29338 - 11905: 0xA0D2,
	29339 - 11905: 0xA0D3,
	29340 - 11905: 0xA0D4,
	29341 - 11905: 0xA0D5,
	29342 - 11905: 0xA0D6,
	29343 - 11905: 0xEAF1,
	29344 - 11905: 0xA0D7,
	29345 - 11905: 0xA0D8,
	29346 - 11905: 0xA0D9,
	29347 - 11905: 0xA0DA,
	29348 - 11905: 0xA0DB,
	29349 - 11905: 0xA0DC,
	29350 - 11905: 0xA0DD,
	29351 - 11905: 0xA0DE,
	29352 - 11905: 0xA0DF,
	29353 - 11905: 0xA0E0,
	29354 - 11905: 0xA0E1,
	29355 - 11905: 0xA0E2,
	29356 - 11905: 0xC8AE,
	29357 - 11905: 0xE1EB,
	29358 - 11905: 0xA0E3,
	29359 - 11905: 0xB7B8,
	29360 - 11905: 0xE1EC,
	29361 - 11905: 0xA0E4,
	29362 - 11905: 0xA0E5,
	29363 - 11905: 0xA0E6,
	29364 - 11905: 0xE1ED,
	29365 - 11905: 0xA0E7,
	29366 - 11905: 0xD7B4,
	29367 - 11905: 0xE1EE,
	29368 - 11905: 0xE1EF,
	29369 - 11905: 0xD3CC,
	29370 - 11905: 0xA0E8,
	29371 - 11905: 0xA0E9,
	29372 - 11905: 0xA0EA,
	29373 - 11905: 0xA0EB,
	29374 - 11905: 0xA0EC,
	29375 - 11905: 0xA0ED,
	29376 - 11905: 0xA0EE,
	29377 - 11905: 0xE1F1,
	29378 - 11905: 0xBFF1,
	29379 - 11905: 0xE1F0,
	29380 - 11905: 0xB5D2,
	29381 - 11905: 0xA0EF,
	29382 - 11905: 0xA0F0,
	29383 - 11905: 0xA0F1,
	29384 - 11905: 0xB1B7,
	29385 - 11905: 0xA0F2,
	29386 - 11905: 0xA0F3,
	29387 - 11905: 0xA0F4,
	29388 - 11905: 0xA0F5,
	29389 - 11905: 0xE1F3,
	29390 - 11905: 0xE1F2,
	29391 - 11905: 0xA0F6,
	29392 - 11905: 0xBAFC,
	29393 - 11905: 0xA0F7,
	29394 - 11905: 0xE1F4,
	29395 - 11905: 0xA0F8,
	29396 - 11905: 0xA0F9,
	29397 - 11905: 0xA0FA,
	29398 - 11905: 0xA0FB,
	29399 - 11905: 0xB9B7,
	29400 - 11905: 0xA0FC,
	29401 - 11905: 0xBED1,
	29402 - 11905: 0xA0FD,
	29403 - 11905: 0xA0FE,
	29404 - 11905: 0xAA40,
	29405 - 11905: 0xAA41,
	29406 - 11905: 0xC4FC,
	29407 - 11905: 0xAA42,
	29408 - 11905: 0xBADD,
	29409 - 11905: 0xBDC6,
	29410 - 11905: 0xAA43,
	29411 - 11905: 0xAA44,
	29412 - 11905: 0xAA45,
	29413 - 11905: 0xAA46,
	29414 - 11905: 0xAA47,
	29415 - 11905: 0xAA48,
	29416 - 11905: 0xE1F5,
	29417 - 11905: 0xE1F7,
	29418 - 11905: 0xAA49,
	29419 - 11905: 0xAA4A,
	29420 - 11905: 0xB6C0,
	29421 - 11905: 0xCFC1,
	29422 - 11905: 0xCAA8,
	29423 - 11905: 0xE1F6,
	29424 - 11905: 0xD5F8,
	29425 - 11905: 0xD3FC,
	29426 - 11905: 0xE1F8,
	29427 - 11905: 0xE1FC,
	29428 - 11905: 0xE1F9,
	29429 - 11905: 0xAA4B,
	29430 - 11905: 0xAA4C,
	29431 - 11905: 0xE1FA,
	29432 - 11905: 0xC0EA,
	29433 - 11905: 0xAA4D,
	29434 - 11905: 0xE1FE,
	29435 - 11905: 0xE2A1,
	29436 - 11905: 0xC0C7,
	29437 - 11905: 0xAA4E,
	29438 - 11905: 0xAA4F,
	29439 - 11905: 0xAA50,
	29440 - 11905: 0xAA51,
	29441 - 11905: 0xE1FB,
	29442 - 11905: 0xAA52,
	29443 - 11905: 0xE1FD,
	29444 - 11905: 0xAA53,
	29445 - 11905: 0xAA54,
	29446 - 11905: 0xAA55,
	29447 - 11905: 0xAA56,
	29448 - 11905: 0xAA57,
	29449 - 11905: 0xAA58,
	29450 - 11905: 0xE2A5,
	29451 - 11905: 0xAA59,
	29452 - 11905: 0xAA5A,
	29453 - 11905: 0xAA5B,
	29454 - 11905: 0xC1D4,
	29455 - 11905: 0xAA5C,
	29456 - 11905: 0xAA5D,
	29457 - 11905: 0xAA5E,
	29458 - 11905: 0xAA5F,
	29459 - 11905: 0xE2A3,
	29460 - 11905: 0xAA60,
	29461 - 11905: 0xE2A8,
	29462 - 11905: 0xB2FE,
	29463 - 11905: 0xE2A2,
	29464 - 11905: 0xAA61,
	29465 - 11905: 0xAA62,
	29466 - 11905: 0xAA63,
	29467 - 11905: 0xC3CD,
	29468 - 11905: 0xB2C2,
	29469 - 11905: 0xE2A7,
	29470 - 11905: 0xE2A6,
	29471 - 11905: 0xAA64,
	29472 - 11905: 0xAA65,
	29473 - 11905: 0xE2A4,
	29474 - 11905: 0xE2A9,
	29475 - 11905: 0xAA66,
	29476 - 11905: 0xAA67,
	29477 - 11905: 0xE2AB,
	29478 - 11905: 0xAA68,
	29479 - 11905: 0xAA69,
	29480 - 11905: 0xAA6A,
	29481 - 11905: 0xD0C9,
	29482 - 11905: 0xD6ED,
	29483 - 11905: 0xC3A8,
	29484 - 11905: 0xE2AC,
	29485 - 11905: 0xAA6B,
	29486 - 11905: 0xCFD7,
	29487 - 11905: 0xAA6C,
	29488 - 11905: 0xAA6D,
	29489 - 11905: 0xE2AE,
	29490 - 11905: 0xAA6E,
	29491 - 11905: 0xAA6F,
	29492 - 11905: 0xBAEF,
	29493 - 11905: 0xAA70,
	29494 - 11905: 0xAA71,
	29495 - 11905: 0xE9E0,
	29496 - 11905: 0xE2AD,
	29497 - 11905: 0xE2AA,
	29498 - 11905: 0xAA72,
	29499 - 11905: 0xAA73,
	29500 - 11905: 0xAA74,
	29501 - 11905: 0xAA75,
	29502 - 11905: 0xBBAB,
	29503 - 11905: 0xD4B3,
	29504 - 11905: 0xAA76,
	29505 - 11905: 0xAA77,
	29506 - 11905: 0xAA78,
	29507 - 11905: 0xAA79,
	29508 - 11905: 0xAA7A,
	29509 - 11905: 0xAA7B,
	29510 - 11905: 0xAA7C,
	29511 - 11905: 0xAA7D,
	29512 - 11905: 0xAA7E,
	29513 - 11905: 0xAA80,
	29514 - 11905: 0xAA81,
	29515 - 11905: 0xAA82,
	29516 - 11905: 0xAA83,
	29517 - 11905: 0xE2B0,
	29518 - 11905: 0xAA84,
	29519 - 11905: 0xAA85,
	29520 - 11905: 0xE2AF,
	29521 - 11905: 0xAA86,
	29522 - 11905: 0xE9E1,
	29523 - 11905: 0xAA87,
	29524 - 11905: 0xAA88,
	29525 - 11905: 0xAA89,
	29526 - 11905: 0xAA8A,
	29527 - 11905: 0xE2B1,
	29528 - 11905: 0xAA8B,
	29529 - 11905: 0xAA8C,
	29530 - 11905: 0xAA8D,
	29531 - 11905: 0xAA8E,
	29532 - 11905: 0xAA8F,
	29533 - 11905: 0xAA90,
	29534 - 11905: 0xAA91,
	29535 - 11905: 0xAA92,
	29536 - 11905: 0xE2B2,
	29537 - 11905: 0xAA93,
	29538 - 11905: 0xAA94,
	29539 - 11905: 0xAA95,
	29540 - 11905: 0xAA96,
	29541 - 11905: 0xAA97,
	29542 - 11905: 0xAA98,
	29543 - 11905: 0xAA99,
	29544 - 11905: 0xAA9A,
	29545 - 11905: 0xAA9B,
	29546 - 11905: 0xAA9C,
	29547 - 11905: 0xAA9D,
	29548 - 11905: 0xE2B3,
	29549 - 11905: 0xCCA1,
	29550 - 11905: 0xAA9E,
	29551 - 11905: 0xE2B4,
	29552 - 11905: 0xAA9F,
	29553 - 11905: 0xAAA0,
	29554 - 11905: 0xAB40,
	29555 - 11905: 0xAB41,
	29556 - 11905: 0xAB42,
	29557 - 11905: 0xAB43,
	29558 - 11905: 0xAB44,
	29559 - 11905: 0xAB45,
	29560 - 11905: 0xAB46,
	29561 - 11905: 0xAB47,
	29562 - 11905: 0xAB48,
	29563 - 11905: 0xAB49,
	29564 - 11905: 0xAB4A,
	29565 - 11905: 0xAB4B,
	29566 - 11905: 0xE2B5,
	29567 - 11905: 0xAB4C,
	29568 - 11905: 0xAB4D,
	29569 - 11905: 0xAB4E,
	29570 - 11905: 0xAB4F,
	29571 - 11905: 0xAB50,
	29572 - 11905: 0xD0FE,
	29573 - 11905: 0xAB51,
	29574 - 11905: 0xAB52,
	29575 - 11905: 0xC2CA,
	29576 - 11905: 0xAB53,
	29577 - 11905: 0xD3F1,
	29578 - 11905: 0xAB54,
	29579 - 11905: 0xCDF5,
	29580 - 11905: 0xAB55,
	29581 - 11905: 0xAB56,
	29582 - 11905: 0xE7E0,
	29583 - 11905: 0xAB57,
	29584 - 11905: 0xAB58,
	29585 - 11905: 0xE7E1,
	29586 - 11905: 0xAB59,
	29587 - 11905: 0xAB5A,
	29588 - 11905: 0xAB5B,
	29589 - 11905: 0xAB5C,
	29590 - 11905: 0xBEC1,
	29591 - 11905: 0xAB5D,
	29592 - 11905: 0xAB5E,
	29593 - 11905: 0xAB5F,
	29594 - 11905: 0xAB60,
	29595 - 11905: 0xC2EA,
	29596 - 11905: 0xAB61,
	29597 - 11905: 0xAB62,
	29598 - 11905: 0xAB63,
	29599 - 11905: 0xE7E4,
	29600 - 11905: 0xAB64,
	29601 - 11905: 0xAB65,
	29602 - 11905: 0xE7E3,
	29603 - 11905: 0xAB66,
	29604 - 11905: 0xAB67,
	29605 - 11905: 0xAB68,
	29606 - 11905: 0xAB69,
	29607 - 11905: 0xAB6A,
	29608 - 11905: 0xAB6B,
	29609 - 11905: 0xCDE6,
	29610 - 11905: 0xAB6C,
	29611 - 11905: 0xC3B5,
	29612 - 11905: 0xAB6D,
	29613 - 11905: 0xAB6E,
	29614 - 11905: 0xE7E2,
	29615 - 11905: 0xBBB7,
	29616 - 11905: 0xCFD6,
	29617 - 11905: 0xAB6F,
	29618 - 11905: 0xC1E1,
	29619 - 11905: 0xE7E9,
	29620 - 11905: 0xAB70,
	29621 - 11905: 0xAB71,
	29622 - 11905: 0xAB72,
	29623 - 11905: 0xE7E8,
	29624 - 11905: 0xAB73,
	29625 - 11905: 0xAB74,
	29626 - 11905: 0xE7F4,
	29627 - 11905: 0xB2A3,
	29628 - 11905: 0xAB75,
	29629 - 11905: 0xAB76,
	29630 - 11905: 0xAB77,
	29631 - 11905: 0xAB78,
	29632 - 11905: 0xE7EA,
	29633 - 11905: 0xAB79,
	29634 - 11905: 0xE7E6,
	29635 - 11905: 0xAB7A,
	29636 - 11905: 0xAB7B,
	29637 - 11905: 0xAB7C,
	29638 - 11905: 0xAB7D,
	29639 - 11905: 0xAB7E,
	29640 - 11905: 0xE7EC,
	29641 - 11905: 0xE7EB,
	29642 - 11905: 0xC9BA,
	29643 - 11905: 0xAB80,
	29644 - 11905: 0xAB81,
	29645 - 11905: 0xD5E4,
	29646 - 11905: 0xAB82,
	29647 - 11905: 0xE7E5,
	29648 - 11905: 0xB7A9,
	29649 - 11905: 0xE7E7,
	29650 - 11905: 0xAB83,
	29651 - 11905: 0xAB84,
	29652 - 11905: 0xAB85,
	29653 - 11905: 0xAB86,
	29654 - 11905: 0xAB87,
	29655 - 11905: 0xAB88,
	29656 - 11905: 0xAB89,
	29657 - 11905: 0xE7EE,
	29658 - 11905: 0xAB8A,
	29659 - 11905: 0xAB8B,
	29660 - 11905: 0xAB8C,
	29661 - 11905: 0xAB8D,
	29662 - 11905: 0xE7F3,
	29663 - 11905: 0xAB8E,
	29664 - 11905: 0xD6E9,
	29665 - 11905: 0xAB8F,
	29666 - 11905: 0xAB90,
	29667 - 11905: 0xAB91,
	29668 - 11905: 0xAB92,
	29669 - 11905: 0xE7ED,
	29670 - 11905: 0xAB93,
	29671 - 11905: 0xE7F2,
	29672 - 11905: 0xAB94,
	29673 - 11905: 0xE7F1,
	29674 - 11905: 0xAB95,
	29675 - 11905: 0xAB96,
	29676 - 11905: 0xAB97,
	29677 - 11905: 0xB0E0,
	29678 - 11905: 0xAB98,
	29679 - 11905: 0xAB99,
	29680 - 11905: 0xAB9A,
	29681 - 11905: 0xAB9B,
	29682 - 11905: 0xE7F5,
	29683 - 11905: 0xAB9C,
	29684 - 11905: 0xAB9D,
	29685 - 11905: 0xAB9E,
	29686 - 11905: 0xAB9F,
	29687 - 11905: 0xABA0,
	29688 - 11905: 0xAC40,
	29689 - 11905: 0xAC41,
	29690 - 11905: 0xAC42,
	29691 - 11905: 0xAC43,
	29692 - 11905: 0xAC44,
	29693 - 11905: 0xAC45,
	29694 - 11905: 0xAC46,
	29695 - 11905: 0xAC47,
	29696 - 11905: 0xAC48,
	29697 - 11905: 0xAC49,
	29698 - 11905: 0xAC4A,
	29699 - 11905: 0xC7F2,
	29700 - 11905: 0xAC4B,
	29701 - 11905: 0xC0C5,
	29702 - 11905: 0xC0ED,
	29703 - 11905: 0xAC4C,
	29704 - 11905: 0xAC4D,
	29705 - 11905: 0xC1F0,
	29706 - 11905: 0xE7F0,
	29707 - 11905: 0xAC4E,
	29708 - 11905: 0xAC4F,
	29709 - 11905: 0xAC50,
	29710 - 11905: 0xAC51,
	29711 - 11905: 0xE7F6,
	29712 - 11905: 0xCBF6,
	29713 - 11905: 0xAC52,
	29714 - 11905: 0xAC53,
	29715 - 11905: 0xAC54,
	29716 - 11905: 0xAC55,
	29717 - 11905: 0xAC56,
	29718 - 11905: 0xAC57,
	29719 - 11905: 0xAC58,
	29720 - 11905: 0xAC59,
	29721 - 11905: 0xAC5A,
	29722 - 11905: 0xE8A2,
	29723 - 11905: 0xE8A1,
	29724 - 11905: 0xAC5B,
	29725 - 11905: 0xAC5C,
	29726 - 11905: 0xAC5D,
	29727 - 11905: 0xAC5E,
	29728 - 11905: 0xAC5F,
	29729 - 11905: 0xAC60,
	29730 - 11905: 0xD7C1,
	29731 - 11905: 0xAC61,
	29732 - 11905: 0xAC62,
	29733 - 11905: 0xE7FA,
	29734 - 11905: 0xE7F9,
	29735 - 11905: 0xAC63,
	29736 - 11905: 0xE7FB,
	29737 - 11905: 0xAC64,
	29738 - 11905: 0xE7F7,
	29739 - 11905: 0xAC65,
	29740 - 11905: 0xE7FE,
	29741 - 11905: 0xAC66,
	29742 - 11905: 0xE7FD,
	29743 - 11905: 0xAC67,
	29744 - 11905: 0xE7FC,
	29745 - 11905: 0xAC68,
	29746 - 11905: 0xAC69,
	29747 - 11905: 0xC1D5,
	29748 - 11905: 0xC7D9,
	29749 - 11905: 0xC5FD,
	29750 - 11905: 0xC5C3,
	29751 - 11905: 0xAC6A,
	29752 - 11905: 0xAC6B,
	29753 - 11905: 0xAC6C,
	29754 - 11905: 0xAC6D,
	29755 - 11905: 0xAC6E,
	29756 - 11905: 0xC7ED,
	29757 - 11905: 0xAC6F,
	29758 - 11905: 0xAC70,
	29759 - 11905: 0xAC71,
	29760 - 11905: 0xAC72,
	29761 - 11905: 0xE8A3,
	29762 - 11905: 0xAC73,
	29763 - 11905: 0xAC74,
	29764 - 11905: 0xAC75,
	29765 - 11905: 0xAC76,
	29766 - 11905: 0xAC77,
	29767 - 11905: 0xAC78,
	29768 - 11905: 0xAC79,
	29769 - 11905: 0xAC7A,
	29770 - 11905: 0xAC7B,
	29771 - 11905: 0xAC7C,
	29772 - 11905: 0xAC7D,
	29773 - 11905: 0xAC7E,
	29774 - 11905: 0xAC80,
	29775 - 11905: 0xAC81,
	29776 - 11905: 0xAC82,
	29777 - 11905: 0xAC83,
	29778 - 11905: 0xAC84,
	29779 - 11905: 0xAC85,
	29780 - 11905: 0xAC86,
	29781 - 11905: 0xE8A6,
	29782 - 11905: 0xAC87,
	29783 - 11905: 0xE8A5,
	29784 - 11905: 0xAC88,
	29785 - 11905: 0xE8A7,
	29786 - 11905: 0xBAF7,
	29787 - 11905: 0xE7F8,
	29788 - 11905: 0xE8A4,
	29789 - 11905: 0xAC89,
	29790 - 11905: 0xC8F0,
	29791 - 11905: 0xC9AA,
	29792 - 11905: 0xAC8A,
	29793 - 11905: 0xAC8B,
	29794 - 11905: 0xAC8C,
	29795 - 11905: 0xAC8D,
	29796 - 11905: 0xAC8E,
	29797 - 11905: 0xAC8F,
	29798 - 11905: 0xAC90,
	29799 - 11905: 0xAC91,
	29800 - 11905: 0xAC92,
	29801 - 11905: 0xAC93,
	29802 - 11905: 0xAC94,
	29803 - 11905: 0xAC95,
	29804 - 11905: 0xAC96,
	29805 - 11905: 0xE8A9,
	29806 - 11905: 0xAC97,
	29807 - 11905: 0xAC98,
	29808 - 11905: 0xB9E5,
	29809 - 11905: 0xAC99,
	29810 - 11905: 0xAC9A,
	29811 - 11905: 0xAC9B,
	29812 - 11905: 0xAC9C,
	29813 - 11905: 0xAC9D,
	29814 - 11905: 0xD1FE,
	29815 - 11905: 0xE8A8,
	29816 - 11905: 0xAC9E,
	29817 - 11905: 0xAC9F,
	29818 - 11905: 0xACA0,
	29819 - 11905: 0xAD40,
	29820 - 11905: 0xAD41,
	29821 - 11905: 0xAD42,
	29822 - 11905: 0xE8AA,
	29823 - 11905: 0xAD43,
	29824 - 11905: 0xE8AD,
	29825 - 11905: 0xE8AE,
	29826 - 11905: 0xAD44,
	29827 - 11905: 0xC1A7,
	29828 - 11905: 0xAD45,
	29829 - 11905: 0xAD46,
	29830 - 11905: 0xAD47,
	29831 - 11905: 0xE8AF,
	29832 - 11905: 0xAD48,
	29833 - 11905: 0xAD49,
	29834 - 11905: 0xAD4A,
	29835 - 11905: 0xE8B0,
	29836 - 11905: 0xAD4B,
	29837 - 11905: 0xAD4C,
	29838 - 11905: 0xE8AC,
	29839 - 11905: 0xAD4D,
	29840 - 11905: 0xE8B4,
	29841 - 11905: 0xAD4E,
	29842 - 11905: 0xAD4F,
	29843 - 11905: 0xAD50,
	29844 - 11905: 0xAD51,
	29845 - 11905: 0xAD52,
	29846 - 11905: 0xAD53,
	29847 - 11905: 0xAD54,
	29848 - 11905: 0xAD55,
	29849 - 11905: 0xAD56,
	29850 - 11905: 0xAD57,
	29851 - 11905: 0xAD58,
	29852 - 11905: 0xE8AB,
	29853 - 11905: 0xAD59,
	29854 - 11905: 0xE8B1,
	29855 - 11905: 0xAD5A,
	29856 - 11905: 0xAD5B,
	29857 - 11905: 0xAD5C,
	29858 - 11905: 0xAD5D,
	29859 - 11905: 0xAD5E,
	29860 - 11905: 0xAD5F,
	29861 - 11905: 0xAD60,
	29862 - 11905: 0xAD61,
	29863 - 11905: 0xE8B5,
	29864 - 11905: 0xE8B2,
	29865 - 11905: 0xE8B3,
	29866 - 11905: 0xAD62,
	29867 - 11905: 0xAD63,
	29868 - 11905: 0xAD64,
	29869 - 11905: 0xAD65,
	29870 - 11905: 0xAD66,
	29871 - 11905: 0xAD67,
	29872 - 11905: 0xAD68,
	29873 - 11905: 0xAD69,
	29874 - 11905: 0xAD6A,
	29875 - 11905: 0xAD6B,
	29876 - 11905: 0xAD6C,
	29877 - 11905: 0xAD6D,
	29878 - 11905: 0xAD6E,
	29879 - 11905: 0xAD6F,
	29880 - 11905: 0xAD70,
	29881 - 11905: 0xAD71,
	29882 - 11905: 0xE8B7,
	29883 - 11905: 0xAD72,
	29884 - 11905: 0xAD73,
	29885 - 11905: 0xAD74,
	29886 - 11905: 0xAD75,
	29887 - 11905: 0xAD76,
	29888 - 11905: 0xAD77,
	29889 - 11905: 0xAD78,
	29890 - 11905: 0xAD79,
	29891 - 11905: 0xAD7A,
	29892 - 11905: 0xAD7B,
	29893 - 11905: 0xAD7C,
	29894 - 11905: 0xAD7D,
	29895 - 11905: 0xAD7E,
	29896 - 11905: 0xAD80,
	29897 - 11905: 0xAD81,
	29898 - 11905: 0xAD82,
	29899 - 11905: 0xAD83,
	29900 - 11905: 0xAD84,
	29901 - 11905: 0xAD85,
	29902 - 11905: 0xAD86,
	29903 - 11905: 0xAD87,
	29904 - 11905: 0xAD88,
	29905 - 11905: 0xAD89,
	29906 - 11905: 0xE8B6,
	29907 - 11905: 0xAD8A,
	29908 - 11905: 0xAD8B,
	29909 - 11905: 0xAD8C,
	29910 - 11905: 0xAD8D,
	29911 - 11905: 0xAD8E,
	29912 - 11905: 0xAD8F,
	29913 - 11905: 0xAD90,
	29914 - 11905: 0xAD91,
	29915 - 11905: 0xAD92,
	29916 - 11905: 0xB9CF,
	29917 - 11905: 0xAD93,
	29918 - 11905: 0xF0AC,
	29919 - 11905: 0xAD94,
	29920 - 11905: 0xF0AD,
	29921 - 11905: 0xAD95,
	29922 - 11905: 0xC6B0,
	29923 - 11905: 0xB0EA,
	29924 - 11905: 0xC8BF,
	29925 - 11905: 0xAD96,
	29926 - 11905: 0xCDDF,
	29927 - 11905: 0xAD97,
	29928 - 11905: 0xAD98,
	29929 - 11905: 0xAD99,
	29930 - 11905: 0xAD9A,
	29931 - 11905: 0xAD9B,
	29932 - 11905: 0xAD9C,
	29933 - 11905: 0xAD9D,
	29934 - 11905: 0xCECD,
	29935 - 11905: 0xEAB1,
	29936 - 11905: 0xAD9E,
	29937 - 11905: 0xAD9F,
	29938 - 11905: 0xADA0,
	29939 - 11905: 0xAE40,
	29940 - 11905: 0xEAB2,
	29941 - 11905: 0xAE41,
	29942 - 11905: 0xC6BF,
	29943 - 11905: 0xB4C9,
	29944 - 11905: 0xAE42,
	29945 - 11905: 0xAE43,
	29946 - 11905: 0xAE44,
	29947 - 11905: 0xAE45,
	29948 - 11905: 0xAE46,
	29949 - 11905: 0xAE47,
	29950 - 11905: 0xAE48,
	29951 - 11905: 0xEAB3,
	29952 - 11905: 0xAE49,
	29953 - 11905: 0xAE4A,
	29954 - 11905: 0xAE4B,
	29955 - 11905: 0xAE4C,
	29956 - 11905: 0xD5E7,
	29957 - 11905: 0xAE4D,
	29958 - 11905: 0xAE4E,
	29959 - 11905: 0xAE4F,
	29960 - 11905: 0xAE50,
	29961 - 11905: 0xAE51,
	29962 - 11905: 0xAE52,
	29963 - 11905: 0xAE53,
	29964 - 11905: 0xAE54,
	29965 - 11905: 0xDDF9,
	29966 - 11905: 0xAE55,
	29967 - 11905: 0xEAB4,
	29968 - 11905: 0xAE56,
	29969 - 11905: 0xEAB5,
	29970 - 11905: 0xAE57,
	29971 - 11905: 0xEAB6,
	29972 - 11905: 0xAE58,
	29973 - 11905: 0xAE59,
	29974 - 11905: 0xAE5A,
	29975 - 11905: 0xAE5B,
	29976 - 11905: 0xB8CA,
	29977 - 11905: 0xDFB0,
	29978 - 11905: 0xC9F5,
	29979 - 11905: 0xAE5C,
	29980 - 11905: 0xCCF0,
	29981 - 11905: 0xAE5D,
	29982 - 11905: 0xAE5E,
	29983 - 11905: 0xC9FA,
	29984 - 11905: 0xAE5F,
	29985 - 11905: 0xAE60,
	29986 - 11905: 0xAE61,
	29987 - 11905: 0xAE62,
	29988 - 11905: 0xAE63,
	29989 - 11905: 0xC9FB,
	29990 - 11905: 0xAE64,
	29991 - 11905: 0xAE65,
	29992 - 11905: 0xD3C3,
	29993 - 11905: 0xCBA6,
	29994 - 11905: 0xAE66,
	29995 - 11905: 0xB8A6,
	29996 - 11905: 0xF0AE,
	29997 - 11905: 0xB1C2,
	29998 - 11905: 0xAE67,
	29999 - 11905: 0xE5B8,
	30000 - 11905: 0xCCEF,
	30001 - 11905: 0xD3C9,
	30002 - 11905: 0xBCD7,
	30003 - 11905: 0xC9EA,
	30004 - 11905: 0xAE68,
	30005 - 11905: 0xB5E7,
	30006 - 11905: 0xAE69,
	30007 - 11905: 0xC4D0,
	30008 - 11905: 0xB5E9,
	30009 - 11905: 0xAE6A,
	30010 - 11905: 0xEEAE,
	30011 - 11905: 0xBBAD,
	30012 - 11905: 0xAE6B,
	30013 - 11905: 0xAE6C,
	30014 - 11905: 0xE7DE,
	30015 - 11905: 0xAE6D,
	30016 - 11905: 0xEEAF,
	30017 - 11905: 0xAE6E,
	30018 - 11905: 0xAE6F,
	30019 - 11905: 0xAE70,
	30020 - 11905: 0xAE71,
	30021 - 11905: 0xB3A9,
	30022 - 11905: 0xAE72,
	30023 - 11905: 0xAE73,
	30024 - 11905: 0xEEB2,
	30025 - 11905: 0xAE74,
	30026 - 11905: 0xAE75,
	30027 - 11905: 0xEEB1,
	30028 - 11905: 0xBDE7,
	30029 - 11905: 0xAE76,
	30030 - 11905: 0xEEB0,
	30031 - 11905: 0xCEB7,
	30032 - 11905: 0xAE77,
	30033 - 11905: 0xAE78,
	30034 - 11905: 0xAE79,
	30035 - 11905: 0xAE7A,
	30036 - 11905: 0xC5CF,
	30037 - 11905: 0xAE7B,
	30038 - 11905: 0xAE7C,
	30039 - 11905: 0xAE7D,
	30040 - 11905: 0xAE7E,
	30041 - 11905: 0xC1F4,
	30042 - 11905: 0xDBCE,
	30043 - 11905: 0xEEB3,
	30044 - 11905: 0xD0F3,
	30045 - 11905: 0xAE80,
	30046 - 11905: 0xAE81,
	30047 - 11905: 0xAE82,
	30048 - 11905: 0xAE83,
	30049 - 11905: 0xAE84,
	30050 - 11905: 0xAE85,
	30051 - 11905: 0xAE86,
	30052 - 11905: 0xAE87,
	30053 - 11905: 0xC2D4,
	30054 - 11905: 0xC6E8,
	30055 - 11905: 0xAE88,
	30056 - 11905: 0xAE89,
	30057 - 11905: 0xAE8A,
	30058 - 11905: 0xB7AC,
	30059 - 11905: 0xAE8B,
	30060 - 11905: 0xAE8C,
	30061 - 11905: 0xAE8D,
	30062 - 11905: 0xAE8E,
	30063 - 11905: 0xAE8F,
	30064 - 11905: 0xAE90,
	30065 - 11905: 0xAE91,
	30066 - 11905: 0xEEB4,
	30067 - 11905: 0xAE92,
	30068 - 11905: 0xB3EB,
	30069 - 11905: 0xAE93,
	30070 - 11905: 0xAE94,
	30071 - 11905: 0xAE95,
	30072 - 11905: 0xBBFB,
	30073 - 11905: 0xEEB5,
	30074 - 11905: 0xAE96,
	30075 - 11905: 0xAE97,
	30076 - 11905: 0xAE98,
	30077 - 11905: 0xAE99,
	30078 - 11905: 0xAE9A,
	30079 - 11905: 0xE7DC,
	30080 - 11905: 0xAE9B,
	30081 - 11905: 0xAE9C,
	30082 - 11905: 0xAE9D,
	30083 - 11905: 0xEEB6,
	30084 - 11905: 0xAE9E,
	30085 - 11905: 0xAE9F,
	30086 - 11905: 0xBDAE,
	30087 - 11905: 0xAEA0,
	30088 - 11905: 0xAF40,
	30089 - 11905: 0xAF41,
	30090 - 11905: 0xAF42,
	30091 - 11905: 0xF1E2,
	30092 - 11905: 0xAF43,
	30093 - 11905: 0xAF44,
	30094 - 11905: 0xAF45,
	30095 - 11905: 0xCAE8,
	30096 - 11905: 0xAF46,
	30097 - 11905: 0xD2C9,
	30098 - 11905: 0xF0DA,
	30099 - 11905: 0xAF47,
	30100 - 11905: 0xF0DB,
	30101 - 11905: 0xAF48,
	30102 - 11905: 0xF0DC,
	30103 - 11905: 0xC1C6,
	30104 - 11905: 0xAF49,
	30105 - 11905: 0xB8ED,
	30106 - 11905: 0xBECE,
	30107 - 11905: 0xAF4A,
	30108 - 11905: 0xAF4B,
	30109 - 11905: 0xF0DE,
	30110 - 11905: 0xAF4C,
	30111 - 11905: 0xC5B1,
	30112 - 11905: 0xF0DD,
	30113 - 11905: 0xD1F1,
	30114 - 11905: 0xAF4D,
	30115 - 11905: 0xF0E0,
	30116 - 11905: 0xB0CC,
	30117 - 11905: 0xBDEA,
	30118 - 11905: 0xAF4E,
	30119 - 11905: 0xAF4F,
	30120 - 11905: 0xAF50,
	30121 - 11905: 0xAF51,
	30122 - 11905: 0xAF52,
	30123 - 11905: 0xD2DF,
	30124 - 11905: 0xF0DF,
	30125 - 11905: 0xAF53,
	30126 - 11905: 0xB4AF,
	30127 - 11905: 0xB7E8,
	30128 - 11905: 0xF0E6,
	30129 - 11905: 0xF0E5,
	30130 - 11905: 0xC6A3,
	30131 - 11905: 0xF0E1,
	30132 - 11905: 0xF0E2,
	30133 - 11905: 0xB4C3,
	30134 - 11905: 0xAF54,
	30135 - 11905: 0xAF55,
	30136 - 11905: 0xF0E3,
	30137 - 11905: 0xD5EE,
	30138 - 11905: 0xAF56,
	30139 - 11905: 0xAF57,
	30140 - 11905: 0xCCDB,
	30141 - 11905: 0xBED2,
	30142 - 11905: 0xBCB2,
	30143 - 11905: 0xAF58,
	30144 - 11905: 0xAF59,
	30145 - 11905: 0xAF5A,
	30146 - 11905: 0xF0E8,
	30147 - 11905: 0xF0E7,
	30148 - 11905: 0xF0E4,
	30149 - 11905: 0xB2A1,
	30150 - 11905: 0xAF5B,
	30151 - 11905: 0xD6A2,
	30152 - 11905: 0xD3B8,
	30153 - 11905: 0xBEB7,
	30154 - 11905: 0xC8AC,
	30155 - 11905: 0xAF5C,
	30156 - 11905: 0xAF5D,
	30157 - 11905: 0xF0EA,
	30158 - 11905: 0xAF5E,
	30159 - 11905: 0xAF5F,
	30160 - 11905: 0xAF60,
	30161 - 11905: 0xAF61,
	30162 - 11905: 0xD1F7,
	30163 - 11905: 0xAF62,
	30164 - 11905: 0xD6CC,
	30165 - 11905: 0xBADB,
	30166 - 11905: 0xF0E9,
	30167 - 11905: 0xAF63,
	30168 - 11905: 0xB6BB,
	30169 - 11905: 0xAF64,
	30170 - 11905: 0xAF65,
	30171 - 11905: 0xCDB4,
	30172 - 11905: 0xAF66,
	30173 - 11905: 0xAF67,
	30174 - 11905: 0xC6A6,
	30175 - 11905: 0xAF68,
	30176 - 11905: 0xAF69,
	30177 - 11905: 0xAF6A,
	30178 - 11905: 0xC1A1,
	30179 - 11905: 0xF0EB,
	30180 - 11905: 0xF0EE,
	30181 - 11905: 0xAF6B,
	30182 - 11905: 0xF0ED,
	30183 - 11905: 0xF0F0,
	30184 - 11905: 0xF0EC,
	30185 - 11905: 0xAF6C,
	30186 - 11905: 0xBBBE,
	30187 - 11905: 0xF0EF,
	30188 - 11905: 0xAF6D,
	30189 - 11905: 0xAF6E,
	30190 - 11905: 0xAF6F,
	30191 - 11905: 0xAF70,
	30192 - 11905: 0xCCB5,
	30193 - 11905: 0xF0F2,
	30194 - 11905: 0xAF71,
	30195 - 11905: 0xAF72,
	30196 - 11905: 0xB3D5,
	30197 - 11905: 0xAF73,
	30198 - 11905: 0xAF74,
	30199 - 11905: 0xAF75,
	30200 - 11905: 0xAF76,
	30201 - 11905: 0xB1D4,
	30202 - 11905: 0xAF77,
	30203 - 11905: 0xAF78,
	30204 - 11905: 0xF0F3,
	30205 - 11905: 0xAF79,
	30206 - 11905: 0xAF7A,
	30207 - 11905: 0xF0F4,
	30208 - 11905: 0xF0F6,
	30209 - 11905: 0xB4E1,
	30210 - 11905: 0xAF7B,
	30211 - 11905: 0xF0F1,
	30212 - 11905: 0xAF7C,
	30213 - 11905: 0xF0F7,
	30214 - 11905: 0xAF7D,
	30215 - 11905: 0xAF7E,
	30216 - 11905: 0xAF80,
	30217 - 11905: 0xAF81,
	30218 - 11905: 0xF0FA,
	30219 - 11905: 0xAF82,
	30220 - 11905: 0xF0F8,
	30221 - 11905: 0xAF83,
	30222 - 11905: 0xAF84,
	30223 - 11905: 0xAF85,
	30224 - 11905: 0xF0F5,
	30225 - 11905: 0xAF86,
	30226 - 11905: 0xAF87,
	30227 - 11905: 0xAF88,
	30228 - 11905: 0xAF89,
	30229 - 11905: 0xF0FD,
	30230 - 11905: 0xAF8A,
	30231 - 11905: 0xF0F9,
	30232 - 11905: 0xF0FC,
	30233 - 11905: 0xF0FE,
	30234 - 11905: 0xAF8B,
	30235 - 11905: 0xF1A1,
	30236 - 11905: 0xAF8C,
	30237 - 11905: 0xAF8D,
	30238 - 11905: 0xAF8E,
	30239 - 11905: 0xCEC1,
	30240 - 11905: 0xF1A4,
	30241 - 11905: 0xAF8F,
	30242 - 11905: 0xF1A3,
	30243 - 11905: 0xAF90,
	30244 - 11905: 0xC1F6,
	30245 - 11905: 0xF0FB,
	30246 - 11905: 0xCADD,
	30247 - 11905: 0xAF91,
	30248 - 11905: 0xAF92,
	30249 - 11905: 0xB4F1,
	30250 - 11905: 0xB1F1,
	30251 - 11905: 0xCCB1,
	30252 - 11905: 0xAF93,
	30253 - 11905: 0xF1A6,
	30254 - 11905: 0xAF94,
	30255 - 11905: 0xAF95,
	30256 - 11905: 0xF1A7,
	30257 - 11905: 0xAF96,
	30258 - 11905: 0xAF97,
	30259 - 11905: 0xF1AC,
	30260 - 11905: 0xD5CE,
	30261 - 11905: 0xF1A9,
	30262 - 11905: 0xAF98,
	30263 - 11905: 0xAF99,
	30264 - 11905: 0xC8B3,
	30265 - 11905: 0xAF9A,
	30266 - 11905: 0xAF9B,
	30267 - 11905: 0xAF9C,
	30268 - 11905: 0xF1A2,
	30269 - 11905: 0xAF9D,
	30270 - 11905: 0xF1AB,
	30271 - 11905: 0xF1A8,
	30272 - 11905: 0xF1A5,
	30273 - 11905: 0xAF9E,
	30274 - 11905: 0xAF9F,
	30275 - 11905: 0xF1AA,
	30276 - 11905: 0xAFA0,
	30277 - 11905: 0xB040,
	30278 - 11905: 0xB041,
	30279 - 11905: 0xB042,
	30280 - 11905: 0xB043,
	30281 - 11905: 0xB044,
	30282 - 11905: 0xB045,
	30283 - 11905: 0xB046,
	30284 - 11905: 0xB0A9,
	30285 - 11905: 0xF1AD,
	30286 - 11905: 0xB047,
	30287 - 11905: 0xB048,
	30288 - 11905: 0xB049,
	30289 - 11905: 0xB04A,
	30290 - 11905: 0xB04B,
	30291 - 11905: 0xB04C,
	30292 - 11905: 0xF1AF,
	30293 - 11905: 0xB04D,
	30294 - 11905: 0xF1B1,
	30295 - 11905: 0xB04E,
	30296 - 11905: 0xB04F,
	30297 - 11905: 0xB050,
	30298 - 11905: 0xB051,
	30299 - 11905: 0xB052,
	30300 - 11905: 0xF1B0,
	30301 - 11905: 0xB053,
	30302 - 11905: 0xF1AE,
	30303 - 11905: 0xB054,
	30304 - 11905: 0xB055,
	30305 - 11905: 0xB056,
	30306 - 11905: 0xB057,
	30307 - 11905: 0xD1A2,
	30308 - 11905: 0xB058,
	30309 - 11905: 0xB059,
	30310 - 11905: 0xB05A,
	30311 - 11905: 0xB05B,
	30312 - 11905: 0xB05C,
	30313 - 11905: 0xB05D,
	30314 - 11905: 0xB05E,
	30315 - 11905: 0xF1B2,
	30316 - 11905: 0xB05F,
	30317 - 11905: 0xB060,
	30318 - 11905: 0xB061,
	30319 - 11905: 0xF1B3,
	30320 - 11905: 0xB062,
	30321 - 11905: 0xB063,
	30322 - 11905: 0xB064,
	30323 - 11905: 0xB065,
	30324 - 11905: 0xB066,
	30325 - 11905: 0xB067,
	30326 - 11905: 0xB068,
	30327 - 11905: 0xB069,
	30328 - 11905: 0xB9EF,
	30329 - 11905: 0xB06A,
	30330 - 11905: 0xB06B,
	30331 - 11905: 0xB5C7,
	30332 - 11905: 0xB06C,
	30333 - 11905: 0xB0D7,
	30334 - 11905: 0xB0D9,
	30335 - 11905: 0xB06D,
	30336 - 11905: 0xB06E,
	30337 - 11905: 0xB06F,
	30338 - 11905: 0xD4ED,
	30339 - 11905: 0xB070,
	30340 - 11905: 0xB5C4,
	30341 - 11905: 0xB071,
	30342 - 11905: 0xBDD4,
	30343 - 11905: 0xBBCA,
	30344 - 11905: 0xF0A7,
	30345 - 11905: 0xB072,
	30346 - 11905: 0xB073,
	30347 - 11905: 0xB8DE,
	30348 - 11905: 0xB074,
	30349 - 11905: 0xB075,
	30350 - 11905: 0xF0A8,
	30351 - 11905: 0xB076,
	30352 - 11905: 0xB077,
	30353 - 11905: 0xB0A8,
	30354 - 11905: 0xB078,
	30355 - 11905: 0xF0A9,
	30356 - 11905: 0xB079,
	30357 - 11905: 0xB07A,
	30358 - 11905: 0xCDEE,
	30359 - 11905: 0xB07B,
	30360 - 11905: 0xB07C,
	30361 - 11905: 0xF0AA,
	30362 - 11905: 0xB07D,
	30363 - 11905: 0xB07E,
	30364 - 11905: 0xB080,
	30365 - 11905: 0xB081,
	30366 - 11905: 0xB082,
	30367 - 11905: 0xB083,
	30368 - 11905: 0xB084,
	30369 - 11905: 0xB085,
	30370 - 11905: 0xB086,
	30371 - 11905: 0xB087,
	30372 - 11905: 0xF0AB,
	30373 - 11905: 0xB088,
	30374 - 11905: 0xB089,
	30375 - 11905: 0xB08A,
	30376 - 11905: 0xB08B,
	30377 - 11905: 0xB08C,
	30378 - 11905: 0xB08D,
	30379 - 11905: 0xB08E,
	30380 - 11905: 0xB08F,
	30381 - 11905: 0xB090,
	30382 - 11905: 0xC6A4,
	30383 - 11905: 0xB091,
	30384 - 11905: 0xB092,
	30385 - 11905: 0xD6E5,
	30386 - 11905: 0xF1E4,
	30387 - 11905: 0xB093,
	30388 - 11905: 0xF1E5,
	30389 - 11905: 0xB094,
	30390 - 11905: 0xB095,
	30391 - 11905: 0xB096,
	30392 - 11905: 0xB097,
	30393 - 11905: 0xB098,
	30394 - 11905: 0xB099,
	30395 - 11905: 0xB09A,
	30396 - 11905: 0xB09B,
	30397 - 11905: 0xB09C,
	30398 - 11905: 0xB09D,
	30399 - 11905: 0xC3F3,
	30400 - 11905: 0xB09E,
	30401 - 11905: 0xB09F,
	30402 - 11905: 0xD3DB,
	30403 - 11905: 0xB0A0,
	30404 - 11905: 0xB140,
	30405 - 11905: 0xD6D1,
	30406 - 11905: 0xC5E8,
	30407 - 11905: 0xB141,
	30408 - 11905: 0xD3AF,
	30409 - 11905: 0xB142,
	30410 - 11905: 0xD2E6,
	30411 - 11905: 0xB143,
	30412 - 11905: 0xB144,
	30413 - 11905: 0xEEC1,
	30414 - 11905: 0xB0BB,
	30415 - 11905: 0xD5B5,
	30416 - 11905: 0xD1CE,
	30417 - 11905: 0xBCE0,
	30418 - 11905: 0xBAD0,
	30419 - 11905: 0xB145,
	30420 - 11905: 0xBFF8,
	30421 - 11905: 0xB146,
	30422 - 11905: 0xB8C7,
	30423 - 11905: 0xB5C1,
	30424 - 11905: 0xC5CC,
	30425 - 11905: 0xB147,
	30426 - 11905: 0xB148,
	30427 - 11905: 0xCAA2,
	30428 - 11905: 0xB149,
	30429 - 11905: 0xB14A,
	30430 - 11905: 0xB14B,
	30431 - 11905: 0xC3CB,
	30432 - 11905: 0xB14C,
	30433 - 11905: 0xB14D,
	30434 - 11905: 0xB14E,
	30435 - 11905: 0xB14F,
	30436 - 11905: 0xB150,
	30437 - 11905: 0xEEC2,
	30438 - 11905: 0xB151,
	30439 - 11905: 0xB152,
	30440 - 11905: 0xB153,
	30441 - 11905: 0xB154,
	30442 - 11905: 0xB155,
	30443 - 11905: 0xB156,
	30444 - 11905: 0xB157,
	30445 - 11905: 0xB158,
	30446 - 11905: 0xC4BF,
	30447 - 11905: 0xB6A2,
	30448 - 11905: 0xB159,
	30449 - 11905: 0xEDEC,
	30450 - 11905: 0xC3A4,
	30451 - 11905: 0xB15A,
	30452 - 11905: 0xD6B1,
	30453 - 11905: 0xB15B,
	30454 - 11905: 0xB15C,
	30455 - 11905: 0xB15D,
	30456 - 11905: 0xCFE0,
	30457 - 11905: 0xEDEF,
	30458 - 11905: 0xB15E,
	30459 - 11905: 0xB15F,
	30460 - 11905: 0xC5CE,
	30461 - 11905: 0xB160,
	30462 - 11905: 0xB6DC,
	30463 - 11905: 0xB161,
	30464 - 11905: 0xB162,
	30465 - 11905: 0xCAA1,
	30466 - 11905: 0xB163,
	30467 - 11905: 0xB164,
	30468 - 11905: 0xEDED,
	30469 - 11905: 0xB165,
	30470 - 11905: 0xB166,
	30471 - 11905: 0xEDF0,
	30472 - 11905: 0xEDF1,
	30473 - 11905: 0xC3BC,
	30474 - 11905: 0xB167,
	30475 - 11905: 0xBFB4,
	30476 - 11905: 0xB168,
	30477 - 11905: 0xEDEE,
	30478 - 11905: 0xB169,
	30479 - 11905: 0xB16A,
	30480 - 11905: 0xB16B,
	30481 - 11905: 0xB16C,
	30482 - 11905: 0xB16D,
	30483 - 11905: 0xB16E,
	30484 - 11905: 0xB16F,
	30485 - 11905: 0xB170,
	30486 - 11905: 0xB171,
	30487 - 11905: 0xB172,
	30488 - 11905: 0xB173,
	30489 - 11905: 0xEDF4,
	30490 - 11905: 0xEDF2,
	30491 - 11905: 0xB174,
	30492 - 11905: 0xB175,
	30493 - 11905: 0xB176,
	30494 - 11905: 0xB177,
	30495 - 11905: 0xD5E6,
	30496 - 11905: 0xC3DF,
	30497 - 11905: 0xB178,
	30498 - 11905: 0xEDF3,
	30499 - 11905: 0xB179,
	30500 - 11905: 0xB17A,
	30501 - 11905: 0xB17B,
	30502 - 11905: 0xEDF6,
	30503 - 11905: 0xB17C,
	30504 - 11905: 0xD5A3,
	30505 - 11905: 0xD1A3,
	30506 - 11905: 0xB17D,
	30507 - 11905: 0xB17E,
	30508 - 11905: 0xB180,
	30509 - 11905: 0xEDF5,
	30510 - 11905: 0xB181,
	30511 - 11905: 0xC3D0,
	30512 - 11905: 0xB182,
	30513 - 11905: 0xB183,
	30514 - 11905: 0xB184,
	30515 - 11905: 0xB185,
	30516 - 11905: 0xB186,
	30517 - 11905: 0xEDF7,
	30518 - 11905: 0xBFF4,
	30519 - 11905: 0xBEEC,
	30520 - 11905: 0xEDF8,
	30521 - 11905: 0xB187,
	30522 - 11905: 0xCCF7,
	30523 - 11905: 0xB188,
	30524 - 11905: 0xD1DB,
	30525 - 11905: 0xB189,
	30526 - 11905: 0xB18A,
	30527 - 11905: 0xB18B,
	30528 - 11905: 0xD7C5,
	30529 - 11905: 0xD5F6,
	30530 - 11905: 0xB18C,
	30531 - 11905: 0xEDFC,
	30532 - 11905: 0xB18D,
	30533 - 11905: 0xB18E,
	30534 - 11905: 0xB18F,
	30535 - 11905: 0xEDFB,
	30536 - 11905: 0xB190,
	30537 - 11905: 0xB191,
	30538 - 11905: 0xB192,
	30539 - 11905: 0xB193,
	30540 - 11905: 0xB194,
	30541 - 11905: 0xB195,
	30542 - 11905: 0xB196,
	30543 - 11905: 0xB197,
	30544 - 11905: 0xEDF9,
	30545 - 11905: 0xEDFA,
	30546 - 11905: 0xB198,
	30547 - 11905: 0xB199,
	30548 - 11905: 0xB19A,
	30549 - 11905: 0xB19B,
	30550 - 11905: 0xB19C,
	30551 - 11905: 0xB19D,
	30552 - 11905: 0xB19E,
	30553 - 11905: 0xB19F,
	30554 - 11905: 0xEDFD,
	30555 - 11905: 0xBEA6,
	30556 - 11905: 0xB1A0,
	30557 - 11905: 0xB240,
	30558 - 11905: 0xB241,
	30559 - 11905: 0xB242,
	30560 - 11905: 0xB243,
	30561 - 11905: 0xCBAF,
	30562 - 11905: 0xEEA1,
	30563 - 11905: 0xB6BD,
	30564 - 11905: 0xB244,
	30565 - 11905: 0xEEA2,
	30566 - 11905: 0xC4C0,
	30567 - 11905: 0xB245,
	30568 - 11905: 0xEDFE,
	30569 - 11905: 0xB246,
	30570 - 11905: 0xB247,
	30571 - 11905: 0xBDDE,
	30572 - 11905: 0xB2C7,
	30573 - 11905: 0xB248,
	30574 - 11905: 0xB249,
	30575 - 11905: 0xB24A,
	30576 - 11905: 0xB24B,
	30577 - 11905: 0xB24C,
	30578 - 11905: 0xB24D,
	30579 - 11905: 0xB24E,
	30580 - 11905: 0xB24F,
	30581 - 11905: 0xB250,
	30582 - 11905: 0xB251,
	30583 - 11905: 0xB252,
	30584 - 11905: 0xB253,
	30585 - 11905: 0xB6C3,
	30586 - 11905: 0xB254,
	30587 - 11905: 0xB255,
	30588 - 11905: 0xB256,
	30589 - 11905: 0xEEA5,
	30590 - 11905: 0xD8BA,
	30591 - 11905: 0xEEA3,
	30592 - 11905: 0xEEA6,
	30593 - 11905: 0xB257,
	30594 - 11905: 0xB258,
	30595 - 11905: 0xB259,
	30596 - 11905: 0xC3E9,
	30597 - 11905: 0xB3F2,
	30598 - 11905: 0xB25A,
	30599 - 11905: 0xB25B,
	30600 - 11905: 0xB25C,
	30601 - 11905: 0xB25D,
	30602 - 11905: 0xB25E,
	30603 - 11905: 0xB25F,
	30604 - 11905: 0xEEA7,
	30605 - 11905: 0xEEA4,
	30606 - 11905: 0xCFB9,
	30607 - 11905: 0xB260,
	30608 - 11905: 0xB261,
	30609 - 11905: 0xEEA8,
	30610 - 11905: 0xC2F7,
	30611 - 11905: 0xB262,
	30612 - 11905: 0xB263,
	30613 - 11905: 0xB264,
	30614 - 11905: 0xB265,
	30615 - 11905: 0xB266,
	30616 - 11905: 0xB267,
	30617 - 11905: 0xB268,
	30618 - 11905: 0xB269,
	30619 - 11905: 0xB26A,
	30620 - 11905: 0xB26B,
	30621 - 11905: 0xB26C,
	30622 - 11905: 0xB26D,
	30623 - 11905: 0xEEA9,
	30624 - 11905: 0xEEAA,
	30625 - 11905: 0xB26E,
	30626 - 11905: 0xDEAB,
	30627 - 11905: 0xB26F,
	30628 - 11905: 0xB270,
	30629 - 11905: 0xC6B3,
	30630 - 11905: 0xB271,
	30631 - 11905: 0xC7C6,
	30632 - 11905: 0xB272,
	30633 - 11905: 0xD6F5,
	30634 - 11905: 0xB5C9,
	30635 - 11905: 0xB273,
	30636 - 11905: 0xCBB2,
	30637 - 11905: 0xB274,
	30638 - 11905: 0xB275,
	30639 - 11905: 0xB276,
	30640 - 11905: 0xEEAB,
	30641 - 11905: 0xB277,
	30642 - 11905: 0xB278,
	30643 - 11905: 0xCDAB,
	30644 - 11905: 0xB279,
	30645 - 11905: 0xEEAC,
	30646 - 11905: 0xB27A,
	30647 - 11905: 0xB27B,
	30648 - 11905: 0xB27C,
	30649 - 11905: 0xB27D,
	30650 - 11905: 0xB27E,
	30651 - 11905: 0xD5B0,
	30652 - 11905: 0xB280,
	30653 - 11905: 0xEEAD,
	30654 - 11905: 0xB281,
	30655 - 11905: 0xF6C4,
	30656 - 11905: 0xB282,
	30657 - 11905: 0xB283,
	30658 - 11905: 0xB284,
	30659 - 11905: 0xB285,
	30660 - 11905: 0xB286,
	30661 - 11905: 0xB287,
	30662 - 11905: 0xB288,
	30663 - 11905: 0xB289,
	30664 - 11905: 0xB28A,
	30665 - 11905: 0xB28B,
	30666 - 11905: 0xB28C,
	30667 - 11905: 0xB28D,
	30668 - 11905: 0xB28E,
	30669 - 11905: 0xDBC7,
	30670 - 11905: 0xB28F,
	30671 - 11905: 0xB290,
	30672 - 11905: 0xB291,
	30673 - 11905: 0xB292,
	30674 - 11905: 0xB293,
	30675 - 11905: 0xB294,
	30676 - 11905: 0xB295,
	30677 - 11905: 0xB296,
	30678 - 11905: 0xB297,
	30679 - 11905: 0xB4A3,
	30680 - 11905: 0xB298,
	30681 - 11905: 0xB299,
	30682 - 11905: 0xB29A,
	30683 - 11905: 0xC3AC,
	30684 - 11905: 0xF1E6,
	30685 - 11905: 0xB29B,
	30686 - 11905: 0xB29C,
	30687 - 11905: 0xB29D,
	30688 - 11905: 0xB29E,
	30689 - 11905: 0xB29F,
	30690 - 11905: 0xCAB8,
	30691 - 11905: 0xD2D3,
	30692 - 11905: 0xB2A0,
	30693 - 11905: 0xD6AA,
	30694 - 11905: 0xB340,
	30695 - 11905: 0xEFF2,
	30696 - 11905: 0xB341,
	30697 - 11905: 0xBED8,
	30698 - 11905: 0xB342,
	30699 - 11905: 0xBDC3,
	30700 - 11905: 0xEFF3,
	30701 - 11905: 0xB6CC,
	30702 - 11905: 0xB0AB,
	30703 - 11905: 0xB343,
	30704 - 11905: 0xB344,
	30705 - 11905: 0xB345,
	30706 - 11905: 0xB346,
	30707 - 11905: 0xCAAF,
	30708 - 11905: 0xB347,
	30709 - 11905: 0xB348,
	30710 - 11905: 0xEDB6,
	30711 - 11905: 0xB349,
	30712 - 11905: 0xEDB7,
	30713 - 11905: 0xB34A,
	30714 - 11905: 0xB34B,
	30715 - 11905: 0xB34C,
	30716 - 11905: 0xB34D,
	30717 - 11905: 0xCEF9,
	30718 - 11905: 0xB7AF,
	30719 - 11905: 0xBFF3,
	30720 - 11905: 0xEDB8,
	30721 - 11905: 0xC2EB,
	30722 - 11905: 0xC9B0,
	30723 - 11905: 0xB34E,
	30724 - 11905: 0xB34F,
	30725 - 11905: 0xB350,
	30726 - 11905: 0xB351,
	30727 - 11905: 0xB352,
	30728 - 11905: 0xB353,
	30729 - 11905: 0xEDB9,
	30730 - 11905: 0xB354,
	30731 - 11905: 0xB355,
	30732 - 11905: 0xC6F6,
	30733 - 11905: 0xBFB3,
	30734 - 11905: 0xB356,
	30735 - 11905: 0xB357,
	30736 - 11905: 0xB358,
	30737 - 11905: 0xEDBC,
	30738 - 11905: 0xC5F8,
	30739 - 11905: 0xB359,
	30740 - 11905: 0xD1D0,
	30741 - 11905: 0xB35A,
	30742 - 11905: 0xD7A9,
	30743 - 11905: 0xEDBA,
	30744 - 11905: 0xEDBB,
	30745 - 11905: 0xB35B,
	30746 - 11905: 0xD1E2,
	30747 - 11905: 0xB35C,
	30748 - 11905: 0xEDBF,
	30749 - 11905: 0xEDC0,
	30750 - 11905: 0xB35D,
	30751 - 11905: 0xEDC4,
	30752 - 11905: 0xB35E,
	30753 - 11905: 0xB35F,
	30754 - 11905: 0xB360,
	30755 - 11905: 0xEDC8,
	30756 - 11905: 0xB361,
	30757 - 11905: 0xEDC6,
	30758 - 11905: 0xEDCE,
	30759 - 11905: 0xD5E8,
	30760 - 11905: 0xB362,
	30761 - 11905: 0xEDC9,
	30762 - 11905: 0xB363,
	30763 - 11905: 0xB364,
	30764 - 11905: 0xEDC7,
	30765 - 11905: 0xEDBE,
	30766 - 11905: 0xB365,
	30767 - 11905: 0xB366,
	30768 - 11905: 0xC5E9,
	30769 - 11905: 0xB367,
	30770 - 11905: 0xB368,
	30771 - 11905: 0xB369,
	30772 - 11905: 0xC6C6,
	30773 - 11905: 0xB36A,
	30774 - 11905: 0xB36B,
	30775 - 11905: 0xC9E9,
	30776 - 11905: 0xD4D2,
	30777 - 11905: 0xEDC1,
	30778 - 11905: 0xEDC2,
	30779 - 11905: 0xEDC3,
	30780 - 11905: 0xEDC5,
	30781 - 11905: 0xB36C,
	30782 - 11905: 0xC0F9,
	30783 - 11905: 0xB36D,
	30784 - 11905: 0xB4A1,
	30785 - 11905: 0xB36E,
	30786 - 11905: 0xB36F,
	30787 - 11905: 0xB370,
	30788 - 11905: 0xB371,
	30789 - 11905: 0xB9E8,
	30790 - 11905: 0xB372,
	30791 - 11905: 0xEDD0,
	30792 - 11905: 0xB373,
	30793 - 11905: 0xB374,
	30794 - 11905: 0xB375,
	30795 - 11905: 0xB376,
	30796 - 11905: 0xEDD1,
	30797 - 11905: 0xB377,
	30798 - 11905: 0xEDCA,
	30799 - 11905: 0xB378,
	30800 - 11905: 0xEDCF,
	30801 - 11905: 0xB379,
	30802 - 11905: 0xCEF8,
	30803 - 11905: 0xB37A,
	30804 - 11905: 0xB37B,
	30805 - 11905: 0xCBB6,
	30806 - 11905: 0xEDCC,
	30807 - 11905: 0xEDCD,
	30808 - 11905: 0xB37C,
	30809 - 11905: 0xB37D,
	30810 - 11905: 0xB37E,
	30811 - 11905: 0xB380,
	30812 - 11905: 0xB381,
	30813 - 11905: 0xCFF5,
	30814 - 11905: 0xB382,
	30815 - 11905: 0xB383,
	30816 - 11905: 0xB384,
	30817 - 11905: 0xB385,
	30818 - 11905: 0xB386,
	30819 - 11905: 0xB387,
	30820 - 11905: 0xB388,
	30821 - 11905: 0xB389,
	30822 - 11905: 0xB38A,
	30823 - 11905: 0xB38B,
	30824 - 11905: 0xB38C,
	30825 - 11905: 0xB38D,
	30826 - 11905: 0xEDD2,
	30827 - 11905: 0xC1F2,
	30828 - 11905: 0xD3B2,
	30829 - 11905: 0xEDCB,
	30830 - 11905: 0xC8B7,
	30831 - 11905: 0xB38E,
	30832 - 11905: 0xB38F,
	30833 - 11905: 0xB390,
	30834 - 11905: 0xB391,
	30835 - 11905: 0xB392,
	30836 - 11905: 0xB393,
	30837 - 11905: 0xB394,
	30838 - 11905: 0xB395,
	30839 - 11905: 0xBCEF,
	30840 - 11905: 0xB396,
	30841 - 11905: 0xB397,
	30842 - 11905: 0xB398,
	30843 - 11905: 0xB399,
	30844 - 11905: 0xC5F0,
	30845 - 11905: 0xB39A,
	30846 - 11905: 0xB39B,
	30847 - 11905: 0xB39C,
	30848 - 11905: 0xB39D,
	30849 - 11905: 0xB39E,
	30850 - 11905: 0xB39F,
	30851 - 11905: 0xB3A0,
	30852 - 11905: 0xB440,
	30853 - 11905: 0xB441,
	30854 - 11905: 0xB442,
	30855 - 11905: 0xEDD6,
	30856 - 11905: 0xB443,
	30857 - 11905: 0xB5EF,
	30858 - 11905: 0xB444,
	30859 - 11905: 0xB445,
	30860 - 11905: 0xC2B5,
	30861 - 11905: 0xB0AD,
	30862 - 11905: 0xCBE9,
	30863 - 11905: 0xB446,
	30864 - 11905: 0xB447,
	30865 - 11905: 0xB1AE,
	30866 - 11905: 0xB448,
	30867 - 11905: 0xEDD4,
	30868 - 11905: 0xB449,
	30869 - 11905: 0xB44A,
	30870 - 11905: 0xB44B,
	30871 - 11905: 0xCDEB,
	30872 - 11905: 0xB5E2,
	30873 - 11905: 0xB44C,
	30874 - 11905: 0xEDD5,
	30875 - 11905: 0xEDD3,
	30876 - 11905: 0xEDD7,
	30877 - 11905: 0xB44D,
	30878 - 11905: 0xB44E,
	30879 - 11905: 0xB5FA,
	30880 - 11905: 0xB44F,
	30881 - 11905: 0xEDD8,
	30882 - 11905: 0xB450,
	30883 - 11905: 0xEDD9,
	30884 - 11905: 0xB451,
	30885 - 11905: 0xEDDC,
	30886 - 11905: 0xB452,
	30887 - 11905: 0xB1CC,
	30888 - 11905: 0xB453,
	30889 - 11905: 0xB454,
	30890 - 11905: 0xB455,
	30891 - 11905: 0xB456,
	30892 - 11905: 0xB457,
	30893 - 11905: 0xB458,
	30894 - 11905: 0xB459,
	30895 - 11905: 0xB45A,
	30896 - 11905: 0xC5F6,
	30897 - 11905: 0xBCEE,
	30898 - 11905: 0xEDDA,
	30899 - 11905: 0xCCBC,
	30900 - 11905: 0xB2EA,
	30901 - 11905: 0xB45B,
	30902 - 11905: 0xB45C,
	30903 - 11905: 0xB45D,
	30904 - 11905: 0xB45E,
	30905 - 11905: 0xEDDB,
	30906 - 11905: 0xB45F,
	30907 - 11905: 0xB460,
	30908 - 11905: 0xB461,
	30909 - 11905: 0xB462,
	30910 - 11905: 0xC4EB,
	30911 - 11905: 0xB463,
	30912 - 11905: 0xB464,
	30913 - 11905: 0xB4C5,
	30914 - 11905: 0xB465,
	30915 - 11905: 0xB466,
	30916 - 11905: 0xB467,
	30917 - 11905: 0xB0F5,
	30918 - 11905: 0xB468,
	30919 - 11905: 0xB469,
	30920 - 11905: 0xB46A,
	30921 - 11905: 0xEDDF,
	30922 - 11905: 0xC0DA,
	30923 - 11905: 0xB4E8,
	30924 - 11905: 0xB46B,
	30925 - 11905: 0xB46C,
	30926 - 11905: 0xB46D,
	30927 - 11905: 0xB46E,
	30928 - 11905: 0xC5CD,
	30929 - 11905: 0xB46F,
	30930 - 11905: 0xB470,
	30931 - 11905: 0xB471,
	30932 - 11905: 0xEDDD,
	30933 - 11905: 0xBFC4,
	30934 - 11905: 0xB472,
	30935 - 11905: 0xB473,
	30936 - 11905: 0xB474,
	30937 - 11905: 0xEDDE,
	30938 - 11905: 0xB475,
	30939 - 11905: 0xB476,
	30940 - 11905: 0xB477,
	30941 - 11905: 0xB478,
	30942 - 11905: 0xB479,
	30943 - 11905: 0xB47A,
	30944 - 11905: 0xB47B,
	30945 - 11905: 0xB47C,
	30946 - 11905: 0xB47D,
	30947 - 11905: 0xB47E,
	30948 - 11905: 0xB480,
	30949 - 11905: 0xB481,
	30950 - 11905: 0xB482,
	30951 - 11905: 0xB483,
	30952 - 11905: 0xC4A5,
	30953 - 11905: 0xB484,
	30954 - 11905: 0xB485,
	30955 - 11905: 0xB486,
	30956 - 11905: 0xEDE0,
	30957 - 11905: 0xB487,
	30958 - 11905: 0xB488,
	30959 - 11905: 0xB489,
	30960 - 11905: 0xB48A,
	30961 - 11905: 0xB48B,
	30962 - 11905: 0xEDE1,
	30963 - 11905: 0xB48C,
	30964 - 11905: 0xEDE3,
	30965 - 11905: 0xB48D,
	30966 - 11905: 0xB48E,
	30967 - 11905: 0xC1D7,
	30968 - 11905: 0xB48F,
	30969 - 11905: 0xB490,
	30970 - 11905: 0xBBC7,
	30971 - 11905: 0xB491,
	30972 - 11905: 0xB492,
	30973 - 11905: 0xB493,
	30974 - 11905: 0xB494,
	30975 - 11905: 0xB495,
	30976 - 11905: 0xB496,
	30977 - 11905: 0xBDB8,
	30978 - 11905: 0xB497,
	30979 - 11905: 0xB498,
	30980 - 11905: 0xB499,
	30981 - 11905: 0xEDE2,
	30982 - 11905: 0xB49A,
	30983 - 11905: 0xB49B,
	30984 - 11905: 0xB49C,
	30985 - 11905: 0xB49D,
	30986 - 11905: 0xB49E,
	30987 - 11905: 0xB49F,
	30988 - 11905: 0xB4A0,
	30989 - 11905: 0xB540,
	30990 - 11905: 0xB541,
	30991 - 11905: 0xB542,
	30992 - 11905: 0xB543,
	30993 - 11905: 0xB544,
	30994 - 11905: 0xB545,
	30995 - 11905: 0xEDE4,
	30996 - 11905: 0xB546,
	30997 - 11905: 0xB547,
	30998 - 11905: 0xB548,
	30999 - 11905: 0xB549,
	31000 - 11905: 0xB54A,
	31001 - 11905: 0xB54B,
	31002 - 11905: 0xB54C,
	31003 - 11905: 0xB54D,
	31004 - 11905: 0xB54E,
	31005 - 11905: 0xB54F,
	31006 - 11905: 0xEDE6,
	31007 - 11905: 0xB550,
	31008 - 11905: 0xB551,
	31009 - 11905: 0xB552,
	31010 - 11905: 0xB553,
	31011 - 11905: 0xB554,
	31012 - 11905: 0xEDE5,
	31013 - 11905: 0xB555,
	31014 - 11905: 0xB556,
	31015 - 11905: 0xB557,
	31016 - 11905: 0xB558,
	31017 - 11905: 0xB559,
	31018 - 11905: 0xB55A,
	31019 - 11905: 0xB55B,
	31020 - 11905: 0xB55C,
	31021 - 11905: 0xB55D,
	31022 - 11905: 0xB55E,
	31023 - 11905: 0xB55F,
	31024 - 11905: 0xB560,
	31025 - 11905: 0xB561,
	31026 - 11905: 0xB562,
	31027 - 11905: 0xB563,
	31028 - 11905: 0xEDE7,
	31029 - 11905: 0xB564,
	31030 - 11905: 0xB565,
	31031 - 11905: 0xB566,
	31032 - 11905: 0xB567,
	31033 - 11905: 0xB568,
	31034 - 11905: 0xCABE,
	31035 - 11905: 0xECEA,
	31036 - 11905: 0xC0F1,
	31037 - 11905: 0xB569,
	31038 - 11905: 0xC9E7,
	31039 - 11905: 0xB56A,
	31040 - 11905: 0xECEB,
	31041 - 11905: 0xC6EE,
	31042 - 11905: 0xB56B,
	31043 - 11905: 0xB56C,
	31044 - 11905: 0xB56D,
	31045 - 11905: 0xB56E,
	31046 - 11905: 0xECEC,
	31047 - 11905: 0xB56F,
	31048 - 11905: 0xC6ED,
	31049 - 11905: 0xECED,
	31050 - 11905: 0xB570,
	31051 - 11905: 0xB571,
	31052 - 11905: 0xB572,
	31053 - 11905: 0xB573,
	31054 - 11905: 0xB574,
	31055 - 11905: 0xB575,
	31056 - 11905: 0xB576,
	31057 - 11905: 0xB577,
	31058 - 11905: 0xB578,
	31059 - 11905: 0xECF0,
	31060 - 11905: 0xB579,
	31061 - 11905: 0xB57A,
	31062 - 11905: 0xD7E6,
	31063 - 11905: 0xECF3,
	31064 - 11905: 0xB57B,
	31065 - 11905: 0xB57C,
	31066 - 11905: 0xECF1,
	31067 - 11905: 0xECEE,
	31068 - 11905: 0xECEF,
	31069 - 11905: 0xD7A3,
	31070 - 11905: 0xC9F1,
	31071 - 11905: 0xCBEE,
	31072 - 11905: 0xECF4,
	31073 - 11905: 0xB57D,
	31074 - 11905: 0xECF2,
	31075 - 11905: 0xB57E,
	31076 - 11905: 0xB580,
	31077 - 11905: 0xCFE9,
	31078 - 11905: 0xB581,
	31079 - 11905: 0xECF6,
	31080 - 11905: 0xC6B1,
	31081 - 11905: 0xB582,
	31082 - 11905: 0xB583,
	31083 - 11905: 0xB584,
	31084 - 11905: 0xB585,
	31085 - 11905: 0xBCC0,
	31086 - 11905: 0xB586,
	31087 - 11905: 0xECF5,
	31088 - 11905: 0xB587,
	31089 - 11905: 0xB588,
	31090 - 11905: 0xB589,
	31091 - 11905: 0xB58A,
	31092 - 11905: 0xB58B,
	31093 - 11905: 0xB58C,
	31094 - 11905: 0xB58D,
	31095 - 11905: 0xB5BB,
	31096 - 11905: 0xBBF6,
	31097 - 11905: 0xB58E,
	31098 - 11905: 0xECF7,
	31099 - 11905: 0xB58F,
	31100 - 11905: 0xB590,
	31101 - 11905: 0xB591,
	31102 - 11905: 0xB592,
	31103 - 11905: 0xB593,
	31104 - 11905: 0xD9F7,
	31105 - 11905: 0xBDFB,
	31106 - 11905: 0xB594,
	31107 - 11905: 0xB595,
	31108 - 11905: 0xC2BB,
	31109 - 11905: 0xECF8,
	31110 - 11905: 0xB596,
	31111 - 11905: 0xB597,
	31112 - 11905: 0xB598,
	31113 - 11905: 0xB599,
	31114 - 11905: 0xECF9,
	31115 - 11905: 0xB59A,
	31116 - 11905: 0xB59B,
	31117 - 11905: 0xB59C,
	31118 - 11905: 0xB59D,
	31119 - 11905: 0xB8A3,
	31120 - 11905: 0xB59E,
	31121 - 11905: 0xB59F,
	31122 - 11905: 0xB5A0,
	31123 - 11905: 0xB640,
	31124 - 11905: 0xB641,
	31125 - 11905: 0xB642,
	31126 - 11905: 0xB643,
	31127 - 11905: 0xB644,
	31128 - 11905: 0xB645,
	31129 - 11905: 0xB646,
	31130 - 11905: 0xECFA,
	31131 - 11905: 0xB647,
	31132 - 11905: 0xB648,
	31133 - 11905: 0xB649,
	31134 - 11905: 0xB64A,
	31135 - 11905: 0xB64B,
	31136 - 11905: 0xB64C,
	31137 - 11905: 0xB64D,
	31138 - 11905: 0xB64E,
	31139 - 11905: 0xB64F,
	31140 - 11905: 0xB650,
	31141 - 11905: 0xB651,
	31142 - 11905: 0xB652,
	31143 - 11905: 0xECFB,
	31144 - 11905: 0xB653,
	31145 - 11905: 0xB654,
	31146 - 11905: 0xB655,
	31147 - 11905: 0xB656,
	31148 - 11905: 0xB657,
	31149 - 11905: 0xB658,
	31150 - 11905: 0xB659,
	31151 - 11905: 0xB65A,
	31152 - 11905: 0xB65B,
	31153 - 11905: 0xB65C,
	31154 - 11905: 0xB65D,
	31155 - 11905: 0xECFC,
	31156 - 11905: 0xB65E,
	31157 - 11905: 0xB65F,
	31158 - 11905: 0xB660,
	31159 - 11905: 0xB661,
	31160 - 11905: 0xB662,
	31161 - 11905: 0xD3ED,
	31162 - 11905: 0xD8AE,
	31163 - 11905: 0xC0EB,
	31164 - 11905: 0xB663,
	31165 - 11905: 0xC7DD,
	31166 - 11905: 0xBACC,
	31167 - 11905: 0xB664,
	31168 - 11905: 0xD0E3,
	31169 - 11905: 0xCBBD,
	31170 - 11905: 0xB665,
	31171 - 11905: 0xCDBA,
	31172 - 11905: 0xB666,
	31173 - 11905: 0xB667,
	31174 - 11905: 0xB8D1,
	31175 - 11905: 0xB668,
	31176 - 11905: 0xB669,
	31177 - 11905: 0xB1FC,
	31178 - 11905: 0xB66A,
	31179 - 11905: 0xC7EF,
	31180 - 11905: 0xB66B,
	31181 - 11905: 0xD6D6,
	31182 - 11905: 0xB66C,
	31183 - 11905: 0xB66D,
	31184 - 11905: 0xB66E,
	31185 - 11905: 0xBFC6,
	31186 - 11905: 0xC3EB,
	31187 - 11905: 0xB66F,
	31188 - 11905: 0xB670,
	31189 - 11905: 0xEFF5,
	31190 - 11905: 0xB671,
	31191 - 11905: 0xB672,
	31192 - 11905: 0xC3D8,
	31193 - 11905: 0xB673,
	31194 - 11905: 0xB674,
	31195 - 11905: 0xB675,
	31196 - 11905: 0xB676,
	31197 - 11905: 0xB677,
	31198 - 11905: 0xB678,
	31199 - 11905: 0xD7E2,
	31200 - 11905: 0xB679,
	31201 - 11905: 0xB67A,
	31202 - 11905: 0xB67B,
	31203 - 11905: 0xEFF7,
	31204 - 11905: 0xB3D3,
	31205 - 11905: 0xB67C,
	31206 - 11905: 0xC7D8,
	31207 - 11905: 0xD1ED,
	31208 - 11905: 0xB67D,
	31209 - 11905: 0xD6C8,
	31210 - 11905: 0xB67E,
	31211 - 11905: 0xEFF8,
	31212 - 11905: 0xB680,
	31213 - 11905: 0xEFF6,
	31214 - 11905: 0xB681,
	31215 - 11905: 0xBBFD,
	31216 - 11905: 0xB3C6,
	31217 - 11905: 0xB682,
	31218 - 11905: 0xB683,
	31219 - 11905: 0xB684,
	31220 - 11905: 0xB685,
	31221 - 11905: 0xB686,
	31222 - 11905: 0xB687,
	31223 - 11905: 0xB688,
	31224 - 11905: 0xBDD5,
	31225 - 11905: 0xB689,
	31226 - 11905: 0xB68A,
	31227 - 11905: 0xD2C6,
	31228 - 11905: 0xB68B,
	31229 - 11905: 0xBBE0,
	31230 - 11905: 0xB68C,
	31231 - 11905: 0xB68D,
	31232 - 11905: 0xCFA1,
	31233 - 11905: 0xB68E,
	31234 - 11905: 0xEFFC,
	31235 - 11905: 0xEFFB,
	31236 - 11905: 0xB68F,
	31237 - 11905: 0xB690,
	31238 - 11905: 0xEFF9,
	31239 - 11905: 0xB691,
	31240 - 11905: 0xB692,
	31241 - 11905: 0xB693,
	31242 - 11905: 0xB694,
	31243 - 11905: 0xB3CC,
	31244 - 11905: 0xB695,
	31245 - 11905: 0xC9D4,
	31246 - 11905: 0xCBB0,
	31247 - 11905: 0xB696,
	31248 - 11905: 0xB697,
	31249 - 11905: 0xB698,
	31250 - 11905: 0xB699,
	31251 - 11905: 0xB69A,
	31252 - 11905: 0xEFFE,
	31253 - 11905: 0xB69B,
	31254 - 11905: 0xB69C,
	31255 - 11905: 0xB0DE,
	31256 - 11905: 0xB69D,
	31257 - 11905: 0xB69E,
	31258 - 11905: 0xD6C9,
	31259 - 11905: 0xB69F,
	31260 - 11905: 0xB6A0,
	31261 - 11905: 0xB740,
	31262 - 11905: 0xEFFD,
	31263 - 11905: 0xB741,
	31264 - 11905: 0xB3ED,
	31265 - 11905: 0xB742,
	31266 - 11905: 0xB743,
	31267 - 11905: 0xF6D5,
	31268 - 11905: 0xB744,
	31269 - 11905: 0xB745,
	31270 - 11905: 0xB746,
	31271 - 11905: 0xB747,
	31272 - 11905: 0xB748,
	31273 - 11905: 0xB749,
	31274 - 11905: 0xB74A,
	31275 - 11905: 0xB74B,
	31276 - 11905: 0xB74C,
	31277 - 11905: 0xB74D,
	31278 - 11905: 0xB74E,
	31279 - 11905: 0xB74F,
	31280 - 11905: 0xB750,
	31281 - 11905: 0xB751,
	31282 - 11905: 0xB752,
	31283 - 11905: 0xCEC8,
	31284 - 11905: 0xB753,
	31285 - 11905: 0xB754,
	31286 - 11905: 0xB755,
	31287 - 11905: 0xF0A2,
	31288 - 11905: 0xB756,
	31289 - 11905: 0xF0A1,
	31290 - 11905: 0xB757,
	31291 - 11905: 0xB5BE,
	31292 - 11905: 0xBCDA,
	31293 - 11905: 0xBBFC,
	31294 - 11905: 0xB758,
	31295 - 11905: 0xB8E5,
	31296 - 11905: 0xB759,
	31297 - 11905: 0xB75A,
	31298 - 11905: 0xB75B,
	31299 - 11905: 0xB75C,
	31300 - 11905: 0xB75D,
	31301 - 11905: 0xB75E,
	31302 - 11905: 0xC4C2,
	31303 - 11905: 0xB75F,
	31304 - 11905: 0xB760,
	31305 - 11905: 0xB761,
	31306 - 11905: 0xB762,
	31307 - 11905: 0xB763,
	31308 - 11905: 0xB764,
	31309 - 11905: 0xB765,
	31310 - 11905: 0xB766,
	31311 - 11905: 0xB767,
	31312 - 11905: 0xB768,
	31313 - 11905: 0xF0A3,
	31314 - 11905: 0xB769,
	31315 - 11905: 0xB76A,
	31316 - 11905: 0xB76B,
	31317 - 11905: 0xB76C,
	31318 - 11905: 0xB76D,
	31319 - 11905: 0xCBEB,
	31320 - 11905: 0xB76E,
	31321 - 11905: 0xB76F,
	31322 - 11905: 0xB770,
	31323 - 11905: 0xB771,
	31324 - 11905: 0xB772,
	31325 - 11905: 0xB773,
	31326 - 11905: 0xB774,
	31327 - 11905: 0xB775,
	31328 - 11905: 0xB776,
	31329 - 11905: 0xB777,
	31330 - 11905: 0xB778,
	31331 - 11905: 0xB779,
	31332 - 11905: 0xB77A,
	31333 - 11905: 0xB77B,
	31334 - 11905: 0xB77C,
	31335 - 11905: 0xB77D,
	31336 - 11905: 0xB77E,
	31337 - 11905: 0xB780,
	31338 - 11905: 0xB781,
	31339 - 11905: 0xB782,
	31340 - 11905: 0xB783,
	31341 - 11905: 0xB784,
	31342 - 11905: 0xB785,
	31343 - 11905: 0xB786,
	31344 - 11905: 0xF0A6,
	31345 - 11905: 0xB787,
	31346 - 11905: 0xB788,
	31347 - 11905: 0xB789,
	31348 - 11905: 0xD1A8,
	31349 - 11905: 0xB78A,
	31350 - 11905: 0xBEBF,
	31351 - 11905: 0xC7EE,
	31352 - 11905: 0xF1B6,
	31353 - 11905: 0xF1B7,
	31354 - 11905: 0xBFD5,
	31355 - 11905: 0xB78B,
	31356 - 11905: 0xB78C,
	31357 - 11905: 0xB78D,
	31358 - 11905: 0xB78E,
	31359 - 11905: 0xB4A9,
	31360 - 11905: 0xF1B8,
	31361 - 11905: 0xCDBB,
	31362 - 11905: 0xB78F,
	31363 - 11905: 0xC7D4,
	31364 - 11905: 0xD5AD,
	31365 - 11905: 0xB790,
	31366 - 11905: 0xF1B9,
	31367 - 11905: 0xB791,
	31368 - 11905: 0xF1BA,
	31369 - 11905: 0xB792,
	31370 - 11905: 0xB793,
	31371 - 11905: 0xB794,
	31372 - 11905: 0xB795,
	31373 - 11905: 0xC7CF,
	31374 - 11905: 0xB796,
	31375 - 11905: 0xB797,
	31376 - 11905: 0xB798,
	31377 - 11905: 0xD2A4,
	31378 - 11905: 0xD6CF,
	31379 - 11905: 0xB799,
	31380 - 11905: 0xB79A,
	31381 - 11905: 0xF1BB,
	31382 - 11905: 0xBDD1,
	31383 - 11905: 0xB4B0,
	31384 - 11905: 0xBEBD,
	31385 - 11905: 0xB79B,
	31386 - 11905: 0xB79C,
	31387 - 11905: 0xB79D,
	31388 - 11905: 0xB4DC,
	31389 - 11905: 0xCED1,
	31390 - 11905: 0xB79E,
	31391 - 11905: 0xBFDF,
	31392 - 11905: 0xF1BD,
	31393 - 11905: 0xB79F,
	31394 - 11905: 0xB7A0,
	31395 - 11905: 0xB840,
	31396 - 11905: 0xB841,
	31397 - 11905: 0xBFFA,
	31398 - 11905: 0xF1BC,
	31399 - 11905: 0xB842,
	31400 - 11905: 0xF1BF,
	31401 - 11905: 0xB843,
	31402 - 11905: 0xB844,
	31403 - 11905: 0xB845,
	31404 - 11905: 0xF1BE,
	31405 - 11905: 0xF1C0,
	31406 - 11905: 0xB846,
	31407 - 11905: 0xB847,
	31408 - 11905: 0xB848,
	31409 - 11905: 0xB849,
	31410 - 11905: 0xB84A,
	31411 - 11905: 0xF1C1,
	31412 - 11905: 0xB84B,
	31413 - 11905: 0xB84C,
	31414 - 11905: 0xB84D,
	31415 - 11905: 0xB84E,
	31416 - 11905: 0xB84F,
	31417 - 11905: 0xB850,
	31418 - 11905: 0xB851,
	31419 - 11905: 0xB852,
	31420 - 11905: 0xB853,
	31421 - 11905: 0xB854,
	31422 - 11905: 0xB855,
	31423 - 11905: 0xC1FE,
	31424 - 11905: 0xB856,
	31425 - 11905: 0xB857,
	31426 - 11905: 0xB858,
	31427 - 11905: 0xB859,
	31428 - 11905: 0xB85A,
	31429 - 11905: 0xB85B,
	31430 - 11905: 0xB85C,
	31431 - 11905: 0xB85D,
	31432 - 11905: 0xB85E,
	31433 - 11905: 0xB85F,
	31434 - 11905: 0xB860,
	31435 - 11905: 0xC1A2,
	31436 - 11905: 0xB861,
	31437 - 11905: 0xB862,
	31438 - 11905: 0xB863,
	31439 - 11905: 0xB864,
	31440 - 11905: 0xB865,
	31441 - 11905: 0xB866,
	31442 - 11905: 0xB867,
	31443 - 11905: 0xB868,
	31444 - 11905: 0xB869,
	31445 - 11905: 0xB86A,
	31446 - 11905: 0xCAFA,
	31447 - 11905: 0xB86B,
	31448 - 11905: 0xB86C,
	31449 - 11905: 0xD5BE,
	31450 - 11905: 0xB86D,
	31451 - 11905: 0xB86E,
	31452 - 11905: 0xB86F,
	31453 - 11905: 0xB870,
	31454 - 11905: 0xBEBA,
	31455 - 11905: 0xBEB9,
	31456 - 11905: 0xD5C2,
	31457 - 11905: 0xB871,
	31458 - 11905: 0xB872,
	31459 - 11905: 0xBFA2,
	31460 - 11905: 0xB873,
	31461 - 11905: 0xCDAF,
	31462 - 11905: 0xF1B5,
	31463 - 11905: 0xB874,
	31464 - 11905: 0xB875,
	31465 - 11905: 0xB876,
	31466 - 11905: 0xB877,
	31467 - 11905: 0xB878,
	31468 - 11905: 0xB879,
	31469 - 11905: 0xBDDF,
	31470 - 11905: 0xB87A,
	31471 - 11905: 0xB6CB,
	31472 - 11905: 0xB87B,
	31473 - 11905: 0xB87C,
	31474 - 11905: 0xB87D,
	31475 - 11905: 0xB87E,
	31476 - 11905: 0xB880,
	31477 - 11905: 0xB881,
	31478 - 11905: 0xB882,
	31479 - 11905: 0xB883,
	31480 - 11905: 0xB884,
	31481 - 11905: 0xD6F1,
	31482 - 11905: 0xF3C3,
	31483 - 11905: 0xB885,
	31484 - 11905: 0xB886,
	31485 - 11905: 0xF3C4,
	31486 - 11905: 0xB887,
	31487 - 11905: 0xB8CD,
	31488 - 11905: 0xB888,
	31489 - 11905: 0xB889,
	31490 - 11905: 0xB88A,
	31491 - 11905: 0xF3C6,
	31492 - 11905: 0xF3C7,
	31493 - 11905: 0xB88B,
	31494 - 11905: 0xB0CA,
	31495 - 11905: 0xB88C,
	31496 - 11905: 0xF3C5,
	31497 - 11905: 0xB88D,
	31498 - 11905: 0xF3C9,
	31499 - 11905: 0xCBF1,
	31500 - 11905: 0xB88E,
	31501 - 11905: 0xB88F,
	31502 - 11905: 0xB890,
	31503 - 11905: 0xF3CB,
	31504 - 11905: 0xB891,
	31505 - 11905: 0xD0A6,
	31506 - 11905: 0xB892,
	31507 - 11905: 0xB893,
	31508 - 11905: 0xB1CA,
	31509 - 11905: 0xF3C8,
	31510 - 11905: 0xB894,
	31511 - 11905: 0xB895,
	31512 - 11905: 0xB896,
	31513 - 11905: 0xF3CF,
	31514 - 11905: 0xB897,
	31515 - 11905: 0xB5D1,
	31516 - 11905: 0xB898,
	31517 - 11905: 0xB899,
	31518 - 11905: 0xF3D7,
	31519 - 11905: 0xB89A,
	31520 - 11905: 0xF3D2,
	31521 - 11905: 0xB89B,
	31522 - 11905: 0xB89C,
	31523 - 11905: 0xB89D,
	31524 - 11905: 0xF3D4,
	31525 - 11905: 0xF3D3,
	31526 - 11905: 0xB7FB,
	31527 - 11905: 0xB89E,
	31528 - 11905: 0xB1BF,
	31529 - 11905: 0xB89F,
	31530 - 11905: 0xF3CE,
	31531 - 11905: 0xF3CA,
	31532 - 11905: 0xB5DA,
	31533 - 11905: 0xB8A0,
	31534 - 11905: 0xF3D0,
	31535 - 11905: 0xB940,
	31536 - 11905: 0xB941,
	31537 - 11905: 0xF3D1,
	31538 - 11905: 0xB942,
	31539 - 11905: 0xF3D5,
	31540 - 11905: 0xB943,
	31541 - 11905: 0xB944,
	31542 - 11905: 0xB945,
	31543 - 11905: 0xB946,
	31544 - 11905: 0xF3CD,
	31545 - 11905: 0xB947,
	31546 - 11905: 0xBCE3,
	31547 - 11905: 0xB948,
	31548 - 11905: 0xC1FD,
	31549 - 11905: 0xB949,
	31550 - 11905: 0xF3D6,
	31551 - 11905: 0xB94A,
	31552 - 11905: 0xB94B,
	31553 - 11905: 0xB94C,
	31554 - 11905: 0xB94D,
	31555 - 11905: 0xB94E,
	31556 - 11905: 0xB94F,
	31557 - 11905: 0xF3DA,
	31558 - 11905: 0xB950,
	31559 - 11905: 0xF3CC,
	31560 - 11905: 0xB951,
	31561 - 11905: 0xB5C8,
	31562 - 11905: 0xB952,
	31563 - 11905: 0xBDEE,
	31564 - 11905: 0xF3DC,
	31565 - 11905: 0xB953,
	31566 - 11905: 0xB954,
	31567 - 11905: 0xB7A4,
	31568 - 11905: 0xBFF0,
	31569 - 11905: 0xD6FE,
	31570 - 11905: 0xCDB2,
	31571 - 11905: 0xB955,
	31572 - 11905: 0xB4F0,
	31573 - 11905: 0xB956,
	31574 - 11905: 0xB2DF,
	31575 - 11905: 0xB957,
	31576 - 11905: 0xF3D8,
	31577 - 11905: 0xB958,
	31578 - 11905: 0xF3D9,
	31579 - 11905: 0xC9B8,
	31580 - 11905: 0xB959,
	31581 - 11905: 0xF3DD,
	31582 - 11905: 0xB95A,
	31583 - 11905: 0xB95B,
	31584 - 11905: 0xF3DE,
	31585 - 11905: 0xB95C,
	31586 - 11905: 0xF3E1,
	31587 - 11905: 0xB95D,
	31588 - 11905: 0xB95E,
	31589 - 11905: 0xB95F,
	31590 - 11905: 0xB960,
	31591 - 11905: 0xB961,
	31592 - 11905: 0xB962,
	31593 - 11905: 0xB963,
	31594 - 11905: 0xB964,
	31595 - 11905: 0xB965,
	31596 - 11905: 0xB966,
	31597 - 11905: 0xB967,
	31598 - 11905: 0xF3DF,
	31599 - 11905: 0xB968,
	31600 - 11905: 0xB969,
	31601 - 11905: 0xF3E3,
	31602 - 11905: 0xF3E2,
	31603 - 11905: 0xB96A,
	31604 - 11905: 0xB96B,
	31605 - 11905: 0xF3DB,
	31606 - 11905: 0xB96C,
	31607 - 11905: 0xBFEA,
	31608 - 11905: 0xB96D,
	31609 - 11905: 0xB3EF,
	31610 - 11905: 0xB96E,
	31611 - 11905: 0xF3E0,
	31612 - 11905: 0xB96F,
	31613 - 11905: 0xB970,
	31614 - 11905: 0xC7A9,
	31615 - 11905: 0xB971,
	31616 - 11905: 0xBCF2,
	31617 - 11905: 0xB972,
	31618 - 11905: 0xB973,
	31619 - 11905: 0xB974,
	31620 - 11905: 0xB975,
	31621 - 11905: 0xF3EB,
	31622 - 11905: 0xB976,
	31623 - 11905: 0xB977,
	31624 - 11905: 0xB978,
	31625 - 11905: 0xB979,
	31626 - 11905: 0xB97A,
	31627 - 11905: 0xB97B,
	31628 - 11905: 0xB97C,
	31629 - 11905: 0xB9BF,
	31630 - 11905: 0xB97D,
	31631 - 11905: 0xB97E,
	31632 - 11905: 0xF3E4,
	31633 - 11905: 0xB980,
	31634 - 11905: 0xB981,
	31635 - 11905: 0xB982,
	31636 - 11905: 0xB2AD,
	31637 - 11905: 0xBBFE,
	31638 - 11905: 0xB983,
	31639 - 11905: 0xCBE3,
	31640 - 11905: 0xB984,
	31641 - 11905: 0xB985,
	31642 - 11905: 0xB986,
	31643 - 11905: 0xB987,
	31644 - 11905: 0xF3ED,
	31645 - 11905: 0xF3E9,
	31646 - 11905: 0xB988,
	31647 - 11905: 0xB989,
	31648 - 11905: 0xB98A,
	31649 - 11905: 0xB9DC,
	31650 - 11905: 0xF3EE,
	31651 - 11905: 0xB98B,
	31652 - 11905: 0xB98C,
	31653 - 11905: 0xB98D,
	31654 - 11905: 0xF3E5,
	31655 - 11905: 0xF3E6,
	31656 - 11905: 0xF3EA,
	31657 - 11905: 0xC2E1,
	31658 - 11905: 0xF3EC,
	31659 - 11905: 0xF3EF,
	31660 - 11905: 0xF3E8,
	31661 - 11905: 0xBCFD,
	31662 - 11905: 0xB98E,
	31663 - 11905: 0xB98F,
	31664 - 11905: 0xB990,
	31665 - 11905: 0xCFE4,
	31666 - 11905: 0xB991,
	31667 - 11905: 0xB992,
	31668 - 11905: 0xF3F0,
	31669 - 11905: 0xB993,
	31670 - 11905: 0xB994,
	31671 - 11905: 0xB995,
	31672 - 11905: 0xF3E7,
	31673 - 11905: 0xB996,
	31674 - 11905: 0xB997,
	31675 - 11905: 0xB998,
	31676 - 11905: 0xB999,
	31677 - 11905: 0xB99A,
	31678 - 11905: 0xB99B,
	31679 - 11905: 0xB99C,
	31680 - 11905: 0xB99D,
	31681 - 11905: 0xF3F2,
	31682 - 11905: 0xB99E,
	31683 - 11905: 0xB99F,
	31684 - 11905: 0xB9A0,
	31685 - 11905: 0xBA40,
	31686 - 11905: 0xD7AD,
	31687 - 11905: 0xC6AA,
	31688 - 11905: 0xBA41,
	31689 - 11905: 0xBA42,
	31690 - 11905: 0xBA43,
	31691 - 11905: 0xBA44,
	31692 - 11905: 0xF3F3,
	31693 - 11905: 0xBA45,
	31694 - 11905: 0xBA46,
	31695 - 11905: 0xBA47,
	31696 - 11905: 0xBA48,
	31697 - 11905: 0xF3F1,
	31698 - 11905: 0xBA49,
	31699 - 11905: 0xC2A8,
	31700 - 11905: 0xBA4A,
	31701 - 11905: 0xBA4B,
	31702 - 11905: 0xBA4C,
	31703 - 11905: 0xBA4D,
	31704 - 11905: 0xBA4E,
	31705 - 11905: 0xB8DD,
	31706 - 11905: 0xF3F5,
	31707 - 11905: 0xBA4F,
	31708 - 11905: 0xBA50,
	31709 - 11905: 0xF3F4,
	31710 - 11905: 0xBA51,
	31711 - 11905: 0xBA52,
	31712 - 11905: 0xBA53,
	31713 - 11905: 0xB4DB,
	31714 - 11905: 0xBA54,
	31715 - 11905: 0xBA55,
	31716 - 11905: 0xBA56,
	31717 - 11905: 0xF3F6,
	31718 - 11905: 0xF3F7,
	31719 - 11905: 0xBA57,
	31720 - 11905: 0xBA58,
	31721 - 11905: 0xBA59,
	31722 - 11905: 0xF3F8,
	31723 - 11905: 0xBA5A,
	31724 - 11905: 0xBA5B,
	31725 - 11905: 0xBA5C,
	31726 - 11905: 0xC0BA,
	31727 - 11905: 0xBA5D,
	31728 - 11905: 0xBA5E,
	31729 - 11905: 0xC0E9,
	31730 - 11905: 0xBA5F,
	31731 - 11905: 0xBA60,
	31732 - 11905: 0xBA61,
	31733 - 11905: 0xBA62,
	31734 - 11905: 0xBA63,
	31735 - 11905: 0xC5F1,
	31736 - 11905: 0xBA64,
	31737 - 11905: 0xBA65,
	31738 - 11905: 0xBA66,
	31739 - 11905: 0xBA67,
	31740 - 11905: 0xF3FB,
	31741 - 11905: 0xBA68,
	31742 - 11905: 0xF3FA,
	31743 - 11905: 0xBA69,
	31744 - 11905: 0xBA6A,
	31745 - 11905: 0xBA6B,
	31746 - 11905: 0xBA6C,
	31747 - 11905: 0xBA6D,
	31748 - 11905: 0xBA6E,
	31749 - 11905: 0xBA6F,
	31750 - 11905: 0xBA70,
	31751 - 11905: 0xB4D8,
	31752 - 11905: 0xBA71,
	31753 - 11905: 0xBA72,
	31754 - 11905: 0xBA73,
	31755 - 11905: 0xF3FE,
	31756 - 11905: 0xF3F9,
	31757 - 11905: 0xBA74,
	31758 - 11905: 0xBA75,
	31759 - 11905: 0xF3FC,
	31760 - 11905: 0xBA76,
	31761 - 11905: 0xBA77,
	31762 - 11905: 0xBA78,
	31763 - 11905: 0xBA79,
	31764 - 11905: 0xBA7A,
	31765 - 11905: 0xBA7B,
	31766 - 11905: 0xF3FD,
	31767 - 11905: 0xBA7C,
	31768 - 11905: 0xBA7D,
	31769 - 11905: 0xBA7E,
	31770 - 11905: 0xBA80,
	31771 - 11905: 0xBA81,
	31772 - 11905: 0xBA82,
	31773 - 11905: 0xBA83,
	31774 - 11905: 0xBA84,
	31775 - 11905: 0xF4A1,
	31776 - 11905: 0xBA85,
	31777 - 11905: 0xBA86,
	31778 - 11905: 0xBA87,
	31779 - 11905: 0xBA88,
	31780 - 11905: 0xBA89,
	31781 - 11905: 0xBA8A,
	31782 - 11905: 0xF4A3,
	31783 - 11905: 0xBBC9,
	31784 - 11905: 0xBA8B,
	31785 - 11905: 0xBA8C,
	31786 - 11905: 0xF4A2,
	31787 - 11905: 0xBA8D,
	31788 - 11905: 0xBA8E,
	31789 - 11905: 0xBA8F,
	31790 - 11905: 0xBA90,
	31791 - 11905: 0xBA91,
	31792 - 11905: 0xBA92,
	31793 - 11905: 0xBA93,
	31794 - 11905: 0xBA94,
	31795 - 11905: 0xBA95,
	31796 - 11905: 0xBA96,
	31797 - 11905: 0xBA97,
	31798 - 11905: 0xBA98,
	31799 - 11905: 0xBA99,
	31800 - 11905: 0xF4A4,
	31801 - 11905: 0xBA9A,
	31802 - 11905: 0xBA9B,
	31803 - 11905: 0xBA9C,
	31804 - 11905: 0xBA9D,
	31805 - 11905: 0xBA9E,
	31806 - 11905: 0xBA9F,
	31807 - 11905: 0xB2BE,
	31808 - 11905: 0xF4A6,
	31809 - 11905: 0xF4A5,
	31810 - 11905: 0xBAA0,
	31811 - 11905: 0xBB40,
	31812 - 11905: 0xBB41,
	31813 - 11905: 0xBB42,
	31814 - 11905: 0xBB43,
	31815 - 11905: 0xBB44,
	31816 - 11905: 0xBB45,
	31817 - 11905: 0xBB46,
	31818 - 11905: 0xBB47,
	31819 - 11905: 0xBB48,
	31820 - 11905: 0xBB49,
	31821 - 11905: 0xBCAE,
	31822 - 11905: 0xBB4A,
	31823 - 11905: 0xBB4B,
	31824 - 11905: 0xBB4C,
	31825 - 11905: 0xBB4D,
	31826 - 11905: 0xBB4E,
	31827 - 11905: 0xBB4F,
	31828 - 11905: 0xBB50,
	31829 - 11905: 0xBB51,
	31830 - 11905: 0xBB52,
	31831 - 11905: 0xBB53,
	31832 - 11905: 0xBB54,
	31833 - 11905: 0xBB55,
	31834 - 11905: 0xBB56,
	31835 - 11905: 0xBB57,
	31836 - 11905: 0xBB58,
	31837 - 11905: 0xBB59,
	31838 - 11905: 0xBB5A,
	31839 - 11905: 0xBB5B,
	31840 - 11905: 0xBB5C,
	31841 - 11905: 0xBB5D,
	31842 - 11905: 0xBB5E,
	31843 - 11905: 0xBB5F,
	31844 - 11905: 0xBB60,
	31845 - 11905: 0xBB61,
	31846 - 11905: 0xBB62,
	31847 - 11905: 0xBB63,
	31848 - 11905: 0xBB64,
	31849 - 11905: 0xBB65,
	31850 - 11905: 0xBB66,
	31851 - 11905: 0xBB67,
	31852 - 11905: 0xBB68,
	31853 - 11905: 0xBB69,
	31854 - 11905: 0xBB6A,
	31855 - 11905: 0xBB6B,
	31856 - 11905: 0xBB6C,
	31857 - 11905: 0xBB6D,
	31858 - 11905: 0xBB6E,
	31859 - 11905: 0xC3D7,
	31860 - 11905: 0xD9E1,
	31861 - 11905: 0xBB6F,
	31862 - 11905: 0xBB70,
	31863 - 11905: 0xBB71,
	31864 - 11905: 0xBB72,
	31865 - 11905: 0xBB73,
	31866 - 11905: 0xBB74,
	31867 - 11905: 0xC0E0,
	31868 - 11905: 0xF4CC,
	31869 - 11905: 0xD7D1,
	31870 - 11905: 0xBB75,
	31871 - 11905: 0xBB76,
	31872 - 11905: 0xBB77,
	31873 - 11905: 0xBB78,
	31874 - 11905: 0xBB79,
	31875 - 11905: 0xBB7A,
	31876 - 11905: 0xBB7B,
	31877 - 11905: 0xBB7C,
	31878 - 11905: 0xBB7D,
	31879 - 11905: 0xBB7E,
	31880 - 11905: 0xBB80,
	31881 - 11905: 0xB7DB,
	31882 - 11905: 0xBB81,
	31883 - 11905: 0xBB82,
	31884 - 11905: 0xBB83,
	31885 - 11905: 0xBB84,
	31886 - 11905: 0xBB85,
	31887 - 11905: 0xBB86,
	31888 - 11905: 0xBB87,
	31889 - 11905: 0xF4CE,
	31890 - 11905: 0xC1A3,
	31891 - 11905: 0xBB88,
	31892 - 11905: 0xBB89,
	31893 - 11905: 0xC6C9,
	31894 - 11905: 0xBB8A,
	31895 - 11905: 0xB4D6,
	31896 - 11905: 0xD5B3,
	31897 - 11905: 0xBB8B,
	31898 - 11905: 0xBB8C,
	31899 - 11905: 0xBB8D,
	31900 - 11905: 0xF4D0,
	31901 - 11905: 0xF4CF,
	31902 - 11905: 0xF4D1,
	31903 - 11905: 0xCBDA,
	31904 - 11905: 0xBB8E,
	31905 - 11905: 0xBB8F,
	31906 - 11905: 0xF4D2,
	31907 - 11905: 0xBB90,
	31908 - 11905: 0xD4C1,
	31909 - 11905: 0xD6E0,
	31910 - 11905: 0xBB91,
	31911 - 11905: 0xBB92,
	31912 - 11905: 0xBB93,
	31913 - 11905: 0xBB94,
	31914 - 11905: 0xB7E0,
	31915 - 11905: 0xBB95,
	31916 - 11905: 0xBB96,
	31917 - 11905: 0xBB97,
	31918 - 11905: 0xC1B8,
	31919 - 11905: 0xBB98,
	31920 - 11905: 0xBB99,
	31921 - 11905: 0xC1BB,
	31922 - 11905: 0xF4D3,
	31923 - 11905: 0xBEAC,
	31924 - 11905: 0xBB9A,
	31925 - 11905: 0xBB9B,
	31926 - 11905: 0xBB9C,
	31927 - 11905: 0xBB9D,
	31928 - 11905: 0xBB9E,
	31929 - 11905: 0xB4E2,
	31930 - 11905: 0xBB9F,
	31931 - 11905: 0xBBA0,
	31932 - 11905: 0xF4D4,
	31933 - 11905: 0xF4D5,
	31934 - 11905: 0xBEAB,
	31935 - 11905: 0xBC40,
	31936 - 11905: 0xBC41,
	31937 - 11905: 0xF4D6,
	31938 - 11905: 0xBC42,
	31939 - 11905: 0xBC43,
	31940 - 11905: 0xBC44,
	31941 - 11905: 0xF4DB,
	31942 - 11905: 0xBC45,
	31943 - 11905: 0xF4D7,
	31944 - 11905: 0xF4DA,
	31945 - 11905: 0xBC46,
	31946 - 11905: 0xBAFD,
	31947 - 11905: 0xBC47,
	31948 - 11905: 0xF4D8,
	31949 - 11905: 0xF4D9,
	31950 - 11905: 0xBC48,
	31951 - 11905: 0xBC49,
	31952 - 11905: 0xBC4A,
	31953 - 11905: 0xBC4B,
	31954 - 11905: 0xBC4C,
	31955 - 11905: 0xBC4D,
	31956 - 11905: 0xBC4E,
	31957 - 11905: 0xB8E2,
	31958 - 11905: 0xCCC7,
	31959 - 11905: 0xF4DC,
	31960 - 11905: 0xBC4F,
	31961 - 11905: 0xB2DA,
	31962 - 11905: 0xBC50,
	31963 - 11905: 0xBC51,
	31964 - 11905: 0xC3D3,
	31965 - 11905: 0xBC52,
	31966 - 11905: 0xBC53,
	31967 - 11905: 0xD4E3,
	31968 - 11905: 0xBFB7,
	31969 - 11905: 0xBC54,
	31970 - 11905: 0xBC55,
	31971 - 11905: 0xBC56,
	31972 - 11905: 0xBC57,
	31973 - 11905: 0xBC58,
	31974 - 11905: 0xBC59,
	31975 - 11905: 0xBC5A,
	31976 - 11905: 0xF4DD,
	31977 - 11905: 0xBC5B,
	31978 - 11905: 0xBC5C,
	31979 - 11905: 0xBC5D,
	31980 - 11905: 0xBC5E,
	31981 - 11905: 0xBC5F,
	31982 - 11905: 0xBC60,
	31983 - 11905: 0xC5B4,
	31984 - 11905: 0xBC61,
	31985 - 11905: 0xBC62,
	31986 - 11905: 0xBC63,
	31987 - 11905: 0xBC64,
	31988 - 11905: 0xBC65,
	31989 - 11905: 0xBC66,
	31990 - 11905: 0xBC67,
	31991 - 11905: 0xBC68,
	31992 - 11905: 0xF4E9,
	31993 - 11905: 0xBC69,
	31994 - 11905: 0xBC6A,
	31995 - 11905: 0xCFB5,
	31996 - 11905: 0xBC6B,
	31997 - 11905: 0xBC6C,
	31998 - 11905: 0xBC6D,
	31999 - 11905: 0xBC6E,
	32000 - 11905: 0xBC6F,
	32001 - 11905: 0xBC70,
	32002 - 11905: 0xBC71,
	32003 - 11905: 0xBC72,
	32004 - 11905: 0xBC73,
	32005 - 11905: 0xBC74,
	32006 - 11905: 0xBC75,
	32007 - 11905: 0xBC76,
	32008 - 11905: 0xBC77,
	32009 - 11905: 0xBC78,
	32010 - 11905: 0xCEC9,
	32011 - 11905: 0xBC79,
	32012 - 11905: 0xBC7A,
	32013 - 11905: 0xBC7B,
	32014 - 11905: 0xBC7C,
	32015 - 11905: 0xBC7D,
	32016 - 11905: 0xBC7E,
	32017 - 11905: 0xBC80,
	32018 - 11905: 0xBC81,
	32019 - 11905: 0xBC82,
	32020 - 11905: 0xBC83,
	32021 - 11905: 0xBC84,
	32022 - 11905: 0xBC85,
	32023 - 11905: 0xBC86,
	32024 - 11905: 0xBC87,
	32025 - 11905: 0xBC88,
	32026 - 11905: 0xBC89,
	32027 - 11905: 0xBC8A,
	32028 - 11905: 0xBC8B,
	32029 - 11905: 0xBC8C,
	32030 - 11905: 0xBC8D,
	32031 - 11905: 0xBC8E,
	32032 - 11905: 0xCBD8,
	32033 - 11905: 0xBC8F,
	32034 - 11905: 0xCBF7,
	32035 - 11905: 0xBC90,
	32036 - 11905: 0xBC91,
	32037 - 11905: 0xBC92,
	32038 - 11905: 0xBC93,
	32039 - 11905: 0xBDF4,
	32040 - 11905: 0xBC94,
	32041 - 11905: 0xBC95,
	32042 - 11905: 0xBC96,
	32043 - 11905: 0xD7CF,
	32044 - 11905: 0xBC97,
	32045 - 11905: 0xBC98,
	32046 - 11905: 0xBC99,
	32047 - 11905: 0xC0DB,
	32048 - 11905: 0xBC9A,
	32049 - 11905: 0xBC9B,
	32050 - 11905: 0xBC9C,
	32051 - 11905: 0xBC9D,
	32052 - 11905: 0xBC9E,
	32053 - 11905: 0xBC9F,
	32054 - 11905: 0xBCA0,
	32055 - 11905: 0xBD40,
	32056 - 11905: 0xBD41,
	32057 - 11905: 0xBD42,
	32058 - 11905: 0xBD43,
	32059 - 11905: 0xBD44,
	32060 - 11905: 0xBD45,
	32061 - 11905: 0xBD46,
	32062 - 11905: 0xBD47,
	32063 - 11905: 0xBD48,
	32064 - 11905: 0xBD49,
	32065 - 11905: 0xBD4A,
	32066 - 11905: 0xBD4B,
	32067 - 11905: 0xBD4C,
	32068 - 11905: 0xBD4D,
	32069 - 11905: 0xBD4E,
	32070 - 11905: 0xBD4F,
	32071 - 11905: 0xBD50,
	32072 - 11905: 0xBD51,
	32073 - 11905: 0xBD52,
	32074 - 11905: 0xBD53,
	32075 - 11905: 0xBD54,
	32076 - 11905: 0xBD55,
	32077 - 11905: 0xBD56,
	32078 - 11905: 0xBD57,
	32079 - 11905: 0xBD58,
	32080 - 11905: 0xBD59,
	32081 - 11905: 0xBD5A,
	32082 - 11905: 0xBD5B,
	32083 - 11905: 0xBD5C,
	32084 - 11905: 0xBD5D,
	32085 - 11905: 0xBD5E,
	32086 - 11905: 0xBD5F,
	32087 - 11905: 0xBD60,
	32088 - 11905: 0xBD61,
	32089 - 11905: 0xBD62,
	32090 - 11905: 0xBD63,
	32091 - 11905: 0xBD64,
	32092 - 11905: 0xBD65,
	32093 - 11905: 0xBD66,
	32094 - 11905: 0xBD67,
	32095 - 11905: 0xBD68,
	32096 - 11905: 0xBD69,
	32097 - 11905: 0xBD6A,
	32098 - 11905: 0xBD6B,
	32099 - 11905: 0xBD6C,
	32100 - 11905: 0xBD6D,
	32101 - 11905: 0xBD6E,
	32102 - 11905: 0xBD6F,
	32103 - 11905: 0xBD70,
	32104 - 11905: 0xBD71,
	32105 - 11905: 0xBD72,
	32106 - 11905: 0xBD73,
	32107 - 11905: 0xBD74,
	32108 - 11905: 0xBD75,
	32109 - 11905: 0xBD76,
	32110 - 11905: 0xD0F5,
	32111 - 11905: 0xBD77,
	32112 - 11905: 0xBD78,
	32113 - 11905: 0xBD79,
	32114 - 11905: 0xBD7A,
	32115 - 11905: 0xBD7B,
	32116 - 11905: 0xBD7C,
	32117 - 11905: 0xBD7D,
	32118 - 11905: 0xBD7E,
	32119 - 11905: 0xF4EA,
	32120 - 11905: 0xBD80,
	32121 - 11905: 0xBD81,
	32122 - 11905: 0xBD82,
	32123 - 11905: 0xBD83,
	32124 - 11905: 0xBD84,
	32125 - 11905: 0xBD85,
	32126 - 11905: 0xBD86,
	32127 - 11905: 0xBD87,
	32128 - 11905: 0xBD88,
	32129 - 11905: 0xBD89,
	32130 - 11905: 0xBD8A,
	32131 - 11905: 0xBD8B,
	32132 - 11905: 0xBD8C,
	32133 - 11905: 0xBD8D,
	32134 - 11905: 0xBD8E,
	32135 - 11905: 0xBD8F,
	32136 - 11905: 0xBD90,
	32137 - 11905: 0xBD91,
	32138 - 11905: 0xBD92,
	32139 - 11905: 0xBD93,
	32140 - 11905: 0xBD94,
	32141 - 11905: 0xBD95,
	32142 - 11905: 0xBD96,
	32143 - 11905: 0xBD97,
	32144 - 11905: 0xBD98,
	32145 - 11905: 0xBD99,
	32146 - 11905: 0xBD9A,
	32147 - 11905: 0xBD9B,
	32148 - 11905: 0xBD9C,
	32149 - 11905: 0xBD9D,
	32150 - 11905: 0xBD9E,
	32151 - 11905: 0xBD9F,
	32152 - 11905: 0xBDA0,
	32153 - 11905: 0xBE40,
	32154 - 11905: 0xBE41,
	32155 - 11905: 0xBE42,
	32156 - 11905: 0xBE43,
	32157 - 11905: 0xBE44,
	32158 - 11905: 0xBE45,
	32159 - 11905: 0xBE46,
	32160 - 11905: 0xBE47,
	32161 - 11905: 0xBE48,
	32162 - 11905: 0xBE49,
	32163 - 11905: 0xBE4A,
	32164 - 11905: 0xBE4B,
	32165 - 11905: 0xBE4C,
	32166 - 11905: 0xF4EB,
	32167 - 11905: 0xBE4D,
	32168 - 11905: 0xBE4E,
	32169 - 11905: 0xBE4F,
	32170 - 11905: 0xBE50,
	32171 - 11905: 0xBE51,
	32172 - 11905: 0xBE52,
	32173 - 11905: 0xBE53,
	32174 - 11905: 0xF4EC,
	32175 - 11905: 0xBE54,
	32176 - 11905: 0xBE55,
	32177 - 11905: 0xBE56,
	32178 - 11905: 0xBE57,
	32179 - 11905: 0xBE58,
	32180 - 11905: 0xBE59,
	32181 - 11905: 0xBE5A,
	32182 - 11905: 0xBE5B,
	32183 - 11905: 0xBE5C,
	32184 - 11905: 0xBE5D,
	32185 - 11905: 0xBE5E,
	32186 - 11905: 0xBE5F,
	32187 - 11905: 0xBE60,
	32188 - 11905: 0xBE61,
	32189 - 11905: 0xBE62,
	32190 - 11905: 0xBE63,
	32191 - 11905: 0xBE64,
	32192 - 11905: 0xBE65,
	32193 - 11905: 0xBE66,
	32194 - 11905: 0xBE67,
	32195 - 11905: 0xBE68,
	32196 - 11905: 0xBE69,
	32197 - 11905: 0xBE6A,
	32198 - 11905: 0xBE6B,
	32199 - 11905: 0xBE6C,
	32200 - 11905: 0xBE6D,
	32201 - 11905: 0xBE6E,
	32202 - 11905: 0xBE6F,
	32203 - 11905: 0xBE70,
	32204 - 11905: 0xBE71,
	32205 - 11905: 0xBE72,
	32206 - 11905: 0xBE73,
	32207 - 11905: 0xBE74,
	32208 - 11905: 0xBE75,
	32209 - 11905: 0xBE76,
	32210 - 11905: 0xBE77,
	32211 - 11905: 0xBE78,
	32212 - 11905: 0xBE79,
	32213 - 11905: 0xBE7A,
	32214 - 11905: 0xBE7B,
	32215 - 11905: 0xBE7C,
	32216 - 11905: 0xBE7D,
	32217 - 11905: 0xBE7E,
	32218 - 11905: 0xBE80,
	32219 - 11905: 0xBE81,
	32220 - 11905: 0xBE82,
	32221 - 11905: 0xBE83,
	32222 - 11905: 0xBE84,
	32223 - 11905: 0xBE85,
	32224 - 11905: 0xBE86,
	32225 - 11905: 0xBE87,
	32226 - 11905: 0xBE88,
	32227 - 11905: 0xBE89,
	32228 - 11905: 0xBE8A,
	32229 - 11905: 0xBE8B,
	32230 - 11905: 0xBE8C,
	32231 - 11905: 0xBE8D,
	32232 - 11905: 0xBE8E,
	32233 - 11905: 0xBE8F,
	32234 - 11905: 0xBE90,
	32235 - 11905: 0xBE91,
	32236 - 11905: 0xBE92,
	32237 - 11905: 0xBE93,
	32238 - 11905: 0xBE94,
	32239 - 11905: 0xBE95,
	32240 - 11905: 0xBE96,
	32241 - 11905: 0xBE97,
	32242 - 11905: 0xBE98,
	32243 - 11905: 0xBE99,
	32244 - 11905: 0xBE9A,
	32245 - 11905: 0xBE9B,
	32246 - 11905: 0xBE9C,
	32247 - 11905: 0xBE9D,
	32248 - 11905: 0xBE9E,
	32249 - 11905: 0xBE9F,
	32250 - 11905: 0xBEA0,
	32251 - 11905: 0xBF40,
	32252 - 11905: 0xBF41,
	32253 - 11905: 0xBF42,
	32254 - 11905: 0xBF43,
	32255 - 11905: 0xBF44,
	32256 - 11905: 0xBF45,
	32257 - 11905: 0xBF46,
	32258 - 11905: 0xBF47,
	32259 - 11905: 0xBF48,
	32260 - 11905: 0xBF49,
	32261 - 11905: 0xBF4A,
	32262 - 11905: 0xBF4B,
	32263 - 11905: 0xBF4C,
	32264 - 11905: 0xBF4D,
	32265 - 11905: 0xBF4E,
	32266 - 11905: 0xBF4F,
	32267 - 11905: 0xBF50,
	32268 - 11905: 0xBF51,
	32269 - 11905: 0xBF52,
	32270 - 11905: 0xBF53,
	32271 - 11905: 0xBF54,
	32272 - 11905: 0xBF55,
	32273 - 11905: 0xBF56,
	32274 - 11905: 0xBF57,
	32275 - 11905: 0xBF58,
	32276 - 11905: 0xBF59,
	32277 - 11905: 0xBF5A,
	32278 - 11905: 0xBF5B,
	32279 - 11905: 0xBF5C,
	32280 - 11905: 0xBF5D,
	32281 - 11905: 0xBF5E,
	32282 - 11905: 0xBF5F,
	32283 - 11905: 0xBF60,
	32284 - 11905: 0xBF61,
	32285 - 11905: 0xBF62,
	32286 - 11905: 0xBF63,
	32287 - 11905: 0xBF64,
	32288 - 11905: 0xBF65,
	32289 - 11905: 0xBF66,
	32290 - 11905: 0xBF67,
	32291 - 11905: 0xBF68,
	32292 - 11905: 0xBF69,
	32293 - 11905: 0xBF6A,
	32294 - 11905: 0xBF6B,
	32295 - 11905: 0xBF6C,
	32296 - 11905: 0xBF6D,
	32297 - 11905: 0xBF6E,
	32298 - 11905: 0xBF6F,
	32299 - 11905: 0xBF70,
	32300 - 11905: 0xBF71,
	32301 - 11905: 0xBF72,
	32302 - 11905: 0xBF73,
	32303 - 11905: 0xBF74,
	32304 - 11905: 0xBF75,
	32305 - 11905: 0xBF76,
	32306 - 11905: 0xBF77,
	32307 - 11905: 0xBF78,
	32308 - 11905: 0xBF79,
	32309 - 11905: 0xBF7A,
	32310 - 11905: 0xBF7B,
	32311 - 11905: 0xBF7C,
	32312 - 11905: 0xBF7D,
	32313 - 11905: 0xBF7E,
	32314 - 11905: 0xBF80,
	32315 - 11905: 0xF7E3,
	32316 - 11905: 0xBF81,
	32317 - 11905: 0xBF82,
	32318 - 11905: 0xBF83,
	32319 - 11905: 0xBF84,
	32320 - 11905: 0xBF85,
	32321 - 11905: 0xB7B1,
	32322 - 11905: 0xBF86,
	32323 - 11905: 0xBF87,
	32324 - 11905: 0xBF88,
	32325 - 11905: 0xBF89,
	32326 - 11905: 0xBF8A,
	32327 - 11905: 0xF4ED,
	32328 - 11905: 0xBF8B,
	32329 - 11905: 0xBF8C,
	32330 - 11905: 0xBF8D,
	32331 - 11905: 0xBF8E,
	32332 - 11905: 0xBF8F,
	32333 - 11905: 0xBF90,
	32334 - 11905: 0xBF91,
	32335 - 11905: 0xBF92,
	32336 - 11905: 0xBF93,
	32337 - 11905: 0xBF94,
	32338 - 11905: 0xBF95,
	32339 - 11905: 0xBF96,
	32340 - 11905: 0xBF97,
	32341 - 11905: 0xBF98,
	32342 - 11905: 0xBF99,
	32343 - 11905: 0xBF9A,
	32344 - 11905: 0xBF9B,
	32345 - 11905: 0xBF9C,
	32346 - 11905: 0xBF9D,
	32347 - 11905: 0xBF9E,
	32348 - 11905: 0xBF9F,
	32349 - 11905: 0xBFA0,
	32350 - 11905: 0xC040,
	32351 - 11905: 0xC041,
	32352 - 11905: 0xC042,
	32353 - 11905: 0xC043,
	32354 - 11905: 0xC044,
	32355 - 11905: 0xC045,
	32356 - 11905: 0xC046,
	32357 - 11905: 0xC047,
	32358 - 11905: 0xC048,
	32359 - 11905: 0xC049,
	32360 - 11905: 0xC04A,
	32361 - 11905: 0xC04B,
	32362 - 11905: 0xC04C,
	32363 - 11905: 0xC04D,
	32364 - 11905: 0xC04E,
	32365 - 11905: 0xC04F,
	32366 - 11905: 0xC050,
	32367 - 11905: 0xC051,
	32368 - 11905: 0xC052,
	32369 - 11905: 0xC053,
	32370 - 11905: 0xC054,
	32371 - 11905: 0xC055,
	32372 - 11905: 0xC056,
	32373 - 11905: 0xC057,
	32374 - 11905: 0xC058,
	32375 - 11905: 0xC059,
	32376 - 11905: 0xC05A,
	32377 - 11905: 0xC05B,
	32378 - 11905: 0xC05C,
	32379 - 11905: 0xC05D,
	32380 - 11905: 0xC05E,
	32381 - 11905: 0xC05F,
	32382 - 11905: 0xC060,
	32383 - 11905: 0xC061,
	32384 - 11905: 0xC062,
	32385 - 11905: 0xC063,
	32386 - 11905: 0xD7EB,
	32387 - 11905: 0xC064,
	32388 - 11905: 0xC065,
	32389 - 11905: 0xC066,
	32390 - 11905: 0xC067,
	32391 - 11905: 0xC068,
	32392 - 11905: 0xC069,
	32393 - 11905: 0xC06A,
	32394 - 11905: 0xC06B,
	32395 - 11905: 0xC06C,
	32396 - 11905: 0xC06D,
	32397 - 11905: 0xC06E,
	32398 - 11905: 0xC06F,
	32399 - 11905: 0xC070,
	32400 - 11905: 0xC071,
	32401 - 11905: 0xC072,
	32402 - 11905: 0xC073,
	32403 - 11905: 0xC074,
	32404 - 11905: 0xC075,
	32405 - 11905: 0xC076,
	32406 - 11905: 0xC077,
	32407 - 11905: 0xC078,
	32408 - 11905: 0xC079,
	32409 - 11905: 0xC07A,
	32410 - 11905: 0xC07B,
	32411 - 11905: 0xF4EE,
	32412 - 11905: 0xC07C,
	32413 - 11905: 0xC07D,
	32414 - 11905: 0xC07E,
	32415 - 11905: 0xE6F9,
	32416 - 11905: 0xBEC0,
	32417 - 11905: 0xE6FA,
	32418 - 11905: 0xBAEC,
	32419 - 11905: 0xE6FB,
	32420 - 11905: 0xCFCB,
	32421 - 11905: 0xE6FC,
	32422 - 11905: 0xD4BC,
	32423 - 11905: 0xBCB6,
	32424 - 11905: 0xE6FD,
	32425 - 11905: 0xE6FE,
	32426 - 11905: 0xBCCD,
	32427 - 11905: 0xC8D2,
	32428 - 11905: 0xCEB3,
	32429 - 11905: 0xE7A1,
	32430 - 11905: 0xC080,
	32431 - 11905: 0xB4BF,
	32432 - 11905: 0xE7A2,
	32433 - 11905: 0xC9B4,
	32434 - 11905: 0xB8D9,
	32435 - 11905: 0xC4C9,
	32436 - 11905: 0xC081,
	32437 - 11905: 0xD7DD,
	32438 - 11905: 0xC2DA,
	32439 - 11905: 0xB7D7,
	32440 - 11905: 0xD6BD,
	32441 - 11905: 0xCEC6,
	32442 - 11905: 0xB7C4,
	32443 - 11905: 0xC082,
	32444 - 11905: 0xC083,
	32445 - 11905: 0xC5A6,
	32446 - 11905: 0xE7A3,
	32447 - 11905: 0xCFDF,
	32448 - 11905: 0xE7A4,
	32449 - 11905: 0xE7A5,
	32450 - 11905: 0xE7A6,
	32451 - 11905: 0xC1B7,
	32452 - 11905: 0xD7E9,
	32453 - 11905: 0xC9F0,
	32454 - 11905: 0xCFB8,
	32455 - 11905: 0xD6AF,
	32456 - 11905: 0xD6D5,
	32457 - 11905: 0xE7A7,
	32458 - 11905: 0xB0ED,
	32459 - 11905: 0xE7A8,
	32460 - 11905: 0xE7A9,
	32461 - 11905: 0xC9DC,
	32462 - 11905: 0xD2EF,
	32463 - 11905: 0xBEAD,
	32464 - 11905: 0xE7AA,
	32465 - 11905: 0xB0F3,
	32466 - 11905: 0xC8DE,
	32467 - 11905: 0xBDE1,
	32468 - 11905: 0xE7AB,
	32469 - 11905: 0xC8C6,
	32470 - 11905: 0xC084,
	32471 - 11905: 0xE7AC,
	32472 - 11905: 0xBBE6,
	32473 - 11905: 0xB8F8,
	32474 - 11905: 0xD1A4,
	32475 - 11905: 0xE7AD,
	32476 - 11905: 0xC2E7,
	32477 - 11905: 0xBEF8,
	32478 - 11905: 0xBDCA,
	32479 - 11905: 0xCDB3,
	32480 - 11905: 0xE7AE,
	32481 - 11905: 0xE7AF,
	32482 - 11905: 0xBEEE,
	32483 - 11905: 0xD0E5,
	32484 - 11905: 0xC085,
	32485 - 11905: 0xCBE7,
	32486 - 11905: 0xCCD0,
	32487 - 11905: 0xBCCC,
	32488 - 11905: 0xE7B0,
	32489 - 11905: 0xBCA8,
	32490 - 11905: 0xD0F7,
	32491 - 11905: 0xE7B1,
	32492 - 11905: 0xC086,
	32493 - 11905: 0xD0F8,
	32494 - 11905: 0xE7B2,
	32495 - 11905: 0xE7B3,
	32496 - 11905: 0xB4C2,
	32497 - 11905: 0xE7B4,
	32498 - 11905: 0xE7B5,
	32499 - 11905: 0xC9FE,
	32500 - 11905: 0xCEAC,
	32501 - 11905: 0xC3E0,
	32502 - 11905: 0xE7B7,
	32503 - 11905: 0xB1C1,
	32504 - 11905: 0xB3F1,
	32505 - 11905: 0xC087,
	32506 - 11905: 0xE7B8,
	32507 - 11905: 0xE7B9,
	32508 - 11905: 0xD7DB,
	32509 - 11905: 0xD5C0,
	32510 - 11905: 0xE7BA,
	32511 - 11905: 0xC2CC,
	32512 - 11905: 0xD7BA,
	32513 - 11905: 0xE7BB,
	32514 - 11905: 0xE7BC,
	32515 - 11905: 0xE7BD,
	32516 - 11905: 0xBCEA,
	32517 - 11905: 0xC3E5,
	32518 - 11905: 0xC0C2,
	32519 - 11905: 0xE7BE,
	32520 - 11905: 0xE7BF,
	32521 - 11905: 0xBCA9,
	32522 - 11905: 0xC088,
	32523 - 11905: 0xE7C0,
	32524 - 11905: 0xE7C1,
	32525 - 11905: 0xE7B6,
	32526 - 11905: 0xB6D0,
	32527 - 11905: 0xE7C2,
	32528 - 11905: 0xC089,
	32529 - 11905: 0xE7C3,
	32530 - 11905: 0xE7C4,
	32531 - 11905: 0xBBBA,
	32532 - 11905: 0xB5DE,
	32533 - 11905: 0xC2C6,
	32534 - 11905: 0xB1E0,
	32535 - 11905: 0xE7C5,
	32536 - 11905: 0xD4B5,
	32537 - 11905: 0xE7C6,
	32538 - 11905: 0xB8BF,
	32539 - 11905: 0xE7C8,
	32540 - 11905: 0xE7C7,
	32541 - 11905: 0xB7EC,
	32542 - 11905: 0xC08A,
	32543 - 11905: 0xE7C9,
	32544 - 11905: 0xB2F8,
	32545 - 11905: 0xE7CA,
	32546 - 11905: 0xE7CB,
	32547 - 11905: 0xE7CC,
	32548 - 11905: 0xE7CD,
	32549 - 11905: 0xE7CE,
	32550 - 11905: 0xE7CF,
	32551 - 11905: 0xE7D0,
	32552 - 11905: 0xD3A7,
	32553 - 11905: 0xCBF5,
	32554 - 11905: 0xE7D1,
	32555 - 11905: 0xE7D2,
	32556 - 11905: 0xE7D3,
	32557 - 11905: 0xE7D4,
	32558 - 11905: 0xC9C9,
	32559 - 11905: 0xE7D5,
	32560 - 11905: 0xE7D6,
	32561 - 11905: 0xE7D7,
	32562 - 11905: 0xE7D8,
	32563 - 11905: 0xE7D9,
	32564 - 11905: 0xBDC9,
	32565 - 11905: 0xE7DA,
	32566 - 11905: 0xF3BE,
	32567 - 11905: 0xC08B,
	32568 - 11905: 0xB8D7,
	32569 - 11905: 0xC08C,
	32570 - 11905: 0xC8B1,
	32571 - 11905: 0xC08D,
	32572 - 11905: 0xC08E,
	32573 - 11905: 0xC08F,
	32574 - 11905: 0xC090,
	32575 - 11905: 0xC091,
	32576 - 11905: 0xC092,
	32577 - 11905: 0xC093,
	32578 - 11905: 0xF3BF,
	32579 - 11905: 0xC094,
	32580 - 11905: 0xF3C0,
	32581 - 11905: 0xF3C1,
	32582 - 11905: 0xC095,
	32583 - 11905: 0xC096,
	32584 - 11905: 0xC097,
	32585 - 11905: 0xC098,
	32586 - 11905: 0xC099,
	32587 - 11905: 0xC09A,
	32588 - 11905: 0xC09B,
	32589 - 11905: 0xC09C,
	32590 - 11905: 0xC09D,
	32591 - 11905: 0xC09E,
	32592 - 11905: 0xB9DE,
	32593 - 11905: 0xCDF8,
	32594 - 11905: 0xC09F,
	32595 - 11905: 0xC0A0,
	32596 - 11905: 0xD8E8,
	32597 - 11905: 0xBAB1,
	32598 - 11905: 0xC140,
	32599 - 11905: 0xC2DE,
	32600 - 11905: 0xEEB7,
	32601 - 11905: 0xC141,
	32602 - 11905: 0xB7A3,
	32603 - 11905: 0xC142,
	32604 - 11905: 0xC143,
	32605 - 11905: 0xC144,
	32606 - 11905: 0xC145,
	32607 - 11905: 0xEEB9,
	32608 - 11905: 0xC146,
	32609 - 11905: 0xEEB8,
	32610 - 11905: 0xB0D5,
	32611 - 11905: 0xC147,
	32612 - 11905: 0xC148,
	32613 - 11905: 0xC149,
	32614 - 11905: 0xC14A,
	32615 - 11905: 0xC14B,
	32616 - 11905: 0xEEBB,
	32617 - 11905: 0xD5D6,
	32618 - 11905: 0xD7EF,
	32619 - 11905: 0xC14C,
	32620 - 11905: 0xC14D,
	32621 - 11905: 0xC14E,
	32622 - 11905: 0xD6C3,
	32623 - 11905: 0xC14F,
	32624 - 11905: 0xC150,
	32625 - 11905: 0xEEBD,
	32626 - 11905: 0xCAF0,
	32627 - 11905: 0xC151,
	32628 - 11905: 0xEEBC,
	32629 - 11905: 0xC152,
	32630 - 11905: 0xC153,
	32631 - 11905: 0xC154,
	32632 - 11905: 0xC155,
	32633 - 11905: 0xEEBE,
	32634 - 11905: 0xC156,
	32635 - 11905: 0xC157,
	32636 - 11905: 0xC158,
	32637 - 11905: 0xC159,
	32638 - 11905: 0xEEC0,
	32639 - 11905: 0xC15A,
	32640 - 11905: 0xC15B,
	32641 - 11905: 0xEEBF,
	32642 - 11905: 0xC15C,
	32643 - 11905: 0xC15D,
	32644 - 11905: 0xC15E,
	32645 - 11905: 0xC15F,
	32646 - 11905: 0xC160,
	32647 - 11905: 0xC161,
	32648 - 11905: 0xC162,
	32649 - 11905: 0xC163,
	32650 - 11905: 0xD1F2,
	32651 - 11905: 0xC164,
	32652 - 11905: 0xC7BC,
	32653 - 11905: 0xC165,
	32654 - 11905: 0xC3C0,
	32655 - 11905: 0xC166,
	32656 - 11905: 0xC167,
	32657 - 11905: 0xC168,
	32658 - 11905: 0xC169,
	32659 - 11905: 0xC16A,
	32660 - 11905: 0xB8E1,
	32661 - 11905: 0xC16B,
	32662 - 11905: 0xC16C,
	32663 - 11905: 0xC16D,
	32664 - 11905: 0xC16E,
	32665 - 11905: 0xC16F,
	32666 - 11905: 0xC1E7,
	32667 - 11905: 0xC170,
	32668 - 11905: 0xC171,
	32669 - 11905: 0xF4C6,
	32670 - 11905: 0xD0DF,
	32671 - 11905: 0xF4C7,
	32672 - 11905: 0xC172,
	32673 - 11905: 0xCFDB,
	32674 - 11905: 0xC173,
	32675 - 11905: 0xC174,
	32676 - 11905: 0xC8BA,
	32677 - 11905: 0xC175,
	32678 - 11905: 0xC176,
	32679 - 11905: 0xF4C8,
	32680 - 11905: 0xC177,
	32681 - 11905: 0xC178,
	32682 - 11905: 0xC179,
	32683 - 11905: 0xC17A,
	32684 - 11905: 0xC17B,
	32685 - 11905: 0xC17C,
	32686 - 11905: 0xC17D,
	32687 - 11905: 0xF4C9,
	32688 - 11905: 0xF4CA,
	32689 - 11905: 0xC17E,
	32690 - 11905: 0xF4CB,
	32691 - 11905: 0xC180,
	32692 - 11905: 0xC181,
	32693 - 11905: 0xC182,
	32694 - 11905: 0xC183,
	32695 - 11905: 0xC184,
	32696 - 11905: 0xD9FA,
	32697 - 11905: 0xB8FE,
	32698 - 11905: 0xC185,
	32699 - 11905: 0xC186,
	32700 - 11905: 0xE5F1,
	32701 - 11905: 0xD3F0,
	32702 - 11905: 0xC187,
	32703 - 11905: 0xF4E0,
	32704 - 11905: 0xC188,
	32705 - 11905: 0xCECC,
	32706 - 11905: 0xC189,
	32707 - 11905: 0xC18A,
	32708 - 11905: 0xC18B,
	32709 - 11905: 0xB3E1,
	32710 - 11905: 0xC18C,
	32711 - 11905: 0xC18D,
	32712 - 11905: 0xC18E,
	32713 - 11905: 0xC18F,
	32714 - 11905: 0xF1B4,
	32715 - 11905: 0xC190,
	32716 - 11905: 0xD2EE,
	32717 - 11905: 0xC191,
	32718 - 11905: 0xF4E1,
	32719 - 11905: 0xC192,
	32720 - 11905: 0xC193,
	32721 - 11905: 0xC194,
	32722 - 11905: 0xC195,
	32723 - 11905: 0xC196,
	32724 - 11905: 0xCFE8,
	32725 - 11905: 0xF4E2,
	32726 - 11905: 0xC197,
	32727 - 11905: 0xC198,
	32728 - 11905: 0xC7CC,
	32729 - 11905: 0xC199,
	32730 - 11905: 0xC19A,
	32731 - 11905: 0xC19B,
	32732 - 11905: 0xC19C,
	32733 - 11905: 0xC19D,
	32734 - 11905: 0xC19E,
	32735 - 11905: 0xB5D4,
	32736 - 11905: 0xB4E4,
	32737 - 11905: 0xF4E4,
	32738 - 11905: 0xC19F,
	32739 - 11905: 0xC1A0,
	32740 - 11905: 0xC240,
	32741 - 11905: 0xF4E3,
	32742 - 11905: 0xF4E5,
	32743 - 11905: 0xC241,
	32744 - 11905: 0xC242,
	32745 - 11905: 0xF4E6,
	32746 - 11905: 0xC243,
	32747 - 11905: 0xC244,
	32748 - 11905: 0xC245,
	32749 - 11905: 0xC246,
	32750 - 11905: 0xF4E7,
	32751 - 11905: 0xC247,
	32752 - 11905: 0xBAB2,
	32753 - 11905: 0xB0BF,
	32754 - 11905: 0xC248,
	32755 - 11905: 0xF4E8,
	32756 - 11905: 0xC249,
	32757 - 11905: 0xC24A,
	32758 - 11905: 0xC24B,
	32759 - 11905: 0xC24C,
	32760 - 11905: 0xC24D,
	32761 - 11905: 0xC24E,
	32762 - 11905: 0xC24F,
	32763 - 11905: 0xB7AD,
	32764 - 11905: 0xD2ED,
	32765 - 11905: 0xC250,
	32766 - 11905: 0xC251,
	32767 - 11905: 0xC252,
	32768 - 11905: 0xD2AB,
	32769 - 11905: 0xC0CF,
	32770 - 11905: 0xC253,
	32771 - 11905: 0xBFBC,
	32772 - 11905: 0xEBA3,
	32773 - 11905: 0xD5DF,
	32774 - 11905: 0xEAC8,
	32775 - 11905: 0xC254,
	32776 - 11905: 0xC255,
	32777 - 11905: 0xC256,
	32778 - 11905: 0xC257,
	32779 - 11905: 0xF1F3,
	32780 - 11905: 0xB6F8,
	32781 - 11905: 0xCBA3,
	32782 - 11905: 0xC258,
	32783 - 11905: 0xC259,
	32784 - 11905: 0xC4CD,
	32785 - 11905: 0xC25A,
	32786 - 11905: 0xF1E7,
	32787 - 11905: 0xC25B,
	32788 - 11905: 0xF1E8,
	32789 - 11905: 0xB8FB,
	32790 - 11905: 0xF1E9,
	32791 - 11905: 0xBAC4,
	32792 - 11905: 0xD4C5,
	32793 - 11905: 0xB0D2,
	32794 - 11905: 0xC25C,
	32795 - 11905: 0xC25D,
	32796 - 11905: 0xF1EA,
	32797 - 11905: 0xC25E,
	32798 - 11905: 0xC25F,
	32799 - 11905: 0xC260,
	32800 - 11905: 0xF1EB,
	32801 - 11905: 0xC261,
	32802 - 11905: 0xF1EC,
	32803 - 11905: 0xC262,
	32804 - 11905: 0xC263,
	32805 - 11905: 0xF1ED,
	32806 - 11905: 0xF1EE,
	32807 - 11905: 0xF1EF,
	32808 - 11905: 0xF1F1,
	32809 - 11905: 0xF1F0,
	32810 - 11905: 0xC5D5,
	32811 - 11905: 0xC264,
	32812 - 11905: 0xC265,
	32813 - 11905: 0xC266,
	32814 - 11905: 0xC267,
	32815 - 11905: 0xC268,
	32816 - 11905: 0xC269,
	32817 - 11905: 0xF1F2,
	32818 - 11905: 0xC26A,
	32819 - 11905: 0xB6FA,
	32820 - 11905: 0xC26B,
	32821 - 11905: 0xF1F4,
	32822 - 11905: 0xD2AE,
	32823 - 11905: 0xDEC7,
	32824 - 11905: 0xCBCA,
	32825 - 11905: 0xC26C,
	32826 - 11905: 0xC26D,
	32827 - 11905: 0xB3DC,
	32828 - 11905: 0xC26E,
	32829 - 11905: 0xB5A2,
	32830 - 11905: 0xC26F,
	32831 - 11905: 0xB9A2,
	32832 - 11905: 0xC270,
	32833 - 11905: 0xC271,
	32834 - 11905: 0xC4F4,
	32835 - 11905: 0xF1F5,
	32836 - 11905: 0xC272,
	32837 - 11905: 0xC273,
	32838 - 11905: 0xF1F6,
	32839 - 11905: 0xC274,
	32840 - 11905: 0xC275,
	32841 - 11905: 0xC276,
	32842 - 11905: 0xC1C4,
	32843 - 11905: 0xC1FB,
	32844 - 11905: 0xD6B0,
	32845 - 11905: 0xF1F7,
	32846 - 11905: 0xC277,
	32847 - 11905: 0xC278,
	32848 - 11905: 0xC279,
	32849 - 11905: 0xC27A,
	32850 - 11905: 0xF1F8,
	32851 - 11905: 0xC27B,
	32852 - 11905: 0xC1AA,
	32853 - 11905: 0xC27C,
	32854 - 11905: 0xC27D,
	32855 - 11905: 0xC27E,
	32856 - 11905: 0xC6B8,
	32857 - 11905: 0xC280,
	32858 - 11905: 0xBEDB,
	32859 - 11905: 0xC281,
	32860 - 11905: 0xC282,
	32861 - 11905: 0xC283,
	32862 - 11905: 0xC284,
	32863 - 11905: 0xC285,
	32864 - 11905: 0xC286,
	32865 - 11905: 0xC287,
	32866 - 11905: 0xC288,
	32867 - 11905: 0xC289,
	32868 - 11905: 0xC28A,
	32869 - 11905: 0xC28B,
	32870 - 11905: 0xC28C,
	32871 - 11905: 0xC28D,
	32872 - 11905: 0xC28E,
	32873 - 11905: 0xF1F9,
	32874 - 11905: 0xB4CF,
	32875 - 11905: 0xC28F,
	32876 - 11905: 0xC290,
	32877 - 11905: 0xC291,
	32878 - 11905: 0xC292,
	32879 - 11905: 0xC293,
	32880 - 11905: 0xC294,
	32881 - 11905: 0xF1FA,
	32882 - 11905: 0xC295,
	32883 - 11905: 0xC296,
	32884 - 11905: 0xC297,
	32885 - 11905: 0xC298,
	32886 - 11905: 0xC299,
	32887 - 11905: 0xC29A,
	32888 - 11905: 0xC29B,
	32889 - 11905: 0xC29C,
	32890 - 11905: 0xC29D,
	32891 - 11905: 0xC29E,
	32892 - 11905: 0xC29F,
	32893 - 11905: 0xC2A0,
	32894 - 11905: 0xC340,
	32895 - 11905: 0xEDB2,
	32896 - 11905: 0xEDB1,
	32897 - 11905: 0xC341,
	32898 - 11905: 0xC342,
	32899 - 11905: 0xCBE0,
	32900 - 11905: 0xD2DE,
	32901 - 11905: 0xC343,
	32902 - 11905: 0xCBC1,
	32903 - 11905: 0xD5D8,
	32904 - 11905: 0xC344,
	32905 - 11905: 0xC8E2,
	32906 - 11905: 0xC345,
	32907 - 11905: 0xC0DF,
	32908 - 11905: 0xBCA1,
	32909 - 11905: 0xC346,
	32910 - 11905: 0xC347,
	32911 - 11905: 0xC348,
	32912 - 11905: 0xC349,
	32913 - 11905: 0xC34A,
	32914 - 11905: 0xC34B,
	32915 - 11905: 0xEBC1,
	32916 - 11905: 0xC34C,
	32917 - 11905: 0xC34D,
	32918 - 11905: 0xD0A4,
	32919 - 11905: 0xC34E,
	32920 - 11905: 0xD6E2,
	32921 - 11905: 0xC34F,
	32922 - 11905: 0xB6C7,
	32923 - 11905: 0xB8D8,
	32924 - 11905: 0xEBC0,
	32925 - 11905: 0xB8CE,
	32926 - 11905: 0xC350,
	32927 - 11905: 0xEBBF,
	32928 - 11905: 0xB3A6,
	32929 - 11905: 0xB9C9,
	32930 - 11905: 0xD6AB,
	32931 - 11905: 0xC351,
	32932 - 11905: 0xB7F4,
	32933 - 11905: 0xB7CA,
	32934 - 11905: 0xC352,
	32935 - 11905: 0xC353,
	32936 - 11905: 0xC354,
	32937 - 11905: 0xBCE7,
	32938 - 11905: 0xB7BE,
	32939 - 11905: 0xEBC6,
	32940 - 11905: 0xC355,
	32941 - 11905: 0xEBC7,
	32942 - 11905: 0xB0B9,
	32943 - 11905: 0xBFCF,
	32944 - 11905: 0xC356,
	32945 - 11905: 0xEBC5,
	32946 - 11905: 0xD3FD,
	32947 - 11905: 0xC357,
	32948 - 11905: 0xEBC8,
	32949 - 11905: 0xC358,
	32950 - 11905: 0xC359,
	32951 - 11905: 0xEBC9,
	32952 - 11905: 0xC35A,
	32953 - 11905: 0xC35B,
	32954 - 11905: 0xB7CE,
	32955 - 11905: 0xC35C,
	32956 - 11905: 0xEBC2,
	32957 - 11905: 0xEBC4,
	32958 - 11905: 0xC9F6,
	32959 - 11905: 0xD6D7,
	32960 - 11905: 0xD5CD,
	32961 - 11905: 0xD0B2,
	32962 - 11905: 0xEBCF,
	32963 - 11905: 0xCEB8,
	32964 - 11905: 0xEBD0,
	32965 - 11905: 0xC35D,
	32966 - 11905: 0xB5A8,
	32967 - 11905: 0xC35E,
	32968 - 11905: 0xC35F,
	32969 - 11905: 0xC360,
	32970 - 11905: 0xC361,
	32971 - 11905: 0xC362,
	32972 - 11905: 0xB1B3,
	32973 - 11905: 0xEBD2,
	32974 - 11905: 0xCCA5,
	32975 - 11905: 0xC363,
	32976 - 11905: 0xC364,
	32977 - 11905: 0xC365,
	32978 - 11905: 0xC366,
	32979 - 11905: 0xC367,
	32980 - 11905: 0xC368,
	32981 - 11905: 0xC369,
	32982 - 11905: 0xC5D6,
	32983 - 11905: 0xEBD3,
	32984 - 11905: 0xC36A,
	32985 - 11905: 0xEBD1,
	32986 - 11905: 0xC5DF,
	32987 - 11905: 0xEBCE,
	32988 - 11905: 0xCAA4,
	32989 - 11905: 0xEBD5,
	32990 - 11905: 0xB0FB,
	32991 - 11905: 0xC36B,
	32992 - 11905: 0xC36C,
	32993 - 11905: 0xBAFA,
	32994 - 11905: 0xC36D,
	32995 - 11905: 0xC36E,
	32996 - 11905: 0xD8B7,
	32997 - 11905: 0xF1E3,
	32998 - 11905: 0xC36F,
	32999 - 11905: 0xEBCA,
	33000 - 11905: 0xEBCB,
	33001 - 11905: 0xEBCC,
	33002 - 11905: 0xEBCD,
	33003 - 11905: 0xEBD6,
	33004 - 11905: 0xE6C0,
	33005 - 11905: 0xEBD9,
	33006 - 11905: 0xC370,
	33007 - 11905: 0xBFE8,
	33008 - 11905: 0xD2C8,
	33009 - 11905: 0xEBD7,
	33010 - 11905: 0xEBDC,
	33011 - 11905: 0xB8EC,
	33012 - 11905: 0xEBD8,
	33013 - 11905: 0xC371,
	33014 - 11905: 0xBDBA,
	33015 - 11905: 0xC372,
	33016 - 11905: 0xD0D8,
	33017 - 11905: 0xC373,
	33018 - 11905: 0xB0B7,
	33019 - 11905: 0xC374,
	33020 - 11905: 0xEBDD,
	33021 - 11905: 0xC4DC,
	33022 - 11905: 0xC375,
	33023 - 11905: 0xC376,
	33024 - 11905: 0xC377,
	33025 - 11905: 0xC378,
	33026 - 11905: 0xD6AC,
	33027 - 11905: 0xC379,
	33028 - 11905: 0xC37A,
	33029 - 11905: 0xC37B,
	33030 - 11905: 0xB4E0,
	33031 - 11905: 0xC37C,
	33032 - 11905: 0xC37D,
	33033 - 11905: 0xC2F6,
	33034 - 11905: 0xBCB9,
	33035 - 11905: 0xC37E,
	33036 - 11905: 0xC380,
	33037 - 11905: 0xEBDA,
	33038 - 11905: 0xEBDB,
	33039 - 11905: 0xD4E0,
	33040 - 11905: 0xC6EA,
	33041 - 11905: 0xC4D4,
	33042 - 11905: 0xEBDF,
	33043 - 11905: 0xC5A7,
	33044 - 11905: 0xD9F5,
	33045 - 11905: 0xC381,
	33046 - 11905: 0xB2B1,
	33047 - 11905: 0xC382,
	33048 - 11905: 0xEBE4,
	33049 - 11905: 0xC383,
	33050 - 11905: 0xBDC5,
	33051 - 11905: 0xC384,
	33052 - 11905: 0xC385,
	33053 - 11905: 0xC386,
	33054 - 11905: 0xEBE2,
	33055 - 11905: 0xC387,
	33056 - 11905: 0xC388,
	33057 - 11905: 0xC389,
	33058 - 11905: 0xC38A,
	33059 - 11905: 0xC38B,
	33060 - 11905: 0xC38C,
	33061 - 11905: 0xC38D,
	33062 - 11905: 0xC38E,
	33063 - 11905: 0xC38F,
	33064 - 11905: 0xC390,
	33065 - 11905: 0xC391,
	33066 - 11905: 0xC392,
	33067 - 11905: 0xC393,
	33068 - 11905: 0xEBE3,
	33069 - 11905: 0xC394,
	33070 - 11905: 0xC395,
	33071 - 11905: 0xB8AC,
	33072 - 11905: 0xC396,
	33073 - 11905: 0xCDD1,
	33074 - 11905: 0xEBE5,
	33075 - 11905: 0xC397,
	33076 - 11905: 0xC398,
	33077 - 11905: 0xC399,
	33078 - 11905: 0xEBE1,
	33079 - 11905: 0xC39A,
	33080 - 11905: 0xC1B3,
	33081 - 11905: 0xC39B,
	33082 - 11905: 0xC39C,
	33083 - 11905: 0xC39D,
	33084 - 11905: 0xC39E,
	33085 - 11905: 0xC39F,
	33086 - 11905: 0xC6A2,
	33087 - 11905: 0xC3A0,
	33088 - 11905: 0xC440,
	33089 - 11905: 0xC441,
	33090 - 11905: 0xC442,
	33091 - 11905: 0xC443,
	33092 - 11905: 0xC444,
	33093 - 11905: 0xC445,
	33094 - 11905: 0xCCF3,
	33095 - 11905: 0xC446,
	33096 - 11905: 0xEBE6,
	33097 - 11905: 0xC447,
	33098 - 11905: 0xC0B0,
	33099 - 11905: 0xD2B8,
	33100 - 11905: 0xEBE7,
	33101 - 11905: 0xC448,
	33102 - 11905: 0xC449,
	33103 - 11905: 0xC44A,
	33104 - 11905: 0xB8AF,
	33105 - 11905: 0xB8AD,
	33106 - 11905: 0xC44B,
	33107 - 11905: 0xEBE8,
	33108 - 11905: 0xC7BB,
	33109 - 11905: 0xCDF3,
	33110 - 11905: 0xC44C,
	33111 - 11905: 0xC44D,
	33112 - 11905: 0xC44E,
	33113 - 11905: 0xEBEA,
	33114 - 11905: 0xEBEB,
	33115 - 11905: 0xC44F,
	33116 - 11905: 0xC450,
	33117 - 11905: 0xC451,
	33118 - 11905: 0xC452,
	33119 - 11905: 0xC453,
	33120 - 11905: 0xEBED,
	33121 - 11905: 0xC454,
	33122 - 11905: 0xC455,
	33123 - 11905: 0xC456,
	33124 - 11905: 0xC457,
	33125 - 11905: 0xD0C8,
	33126 - 11905: 0xC458,
	33127 - 11905: 0xEBF2,
	33128 - 11905: 0xC459,
	33129 - 11905: 0xEBEE,
	33130 - 11905: 0xC45A,
	33131 - 11905: 0xC45B,
	33132 - 11905: 0xC45C,
	33133 - 11905: 0xEBF1,
	33134 - 11905: 0xC8F9,
	33135 - 11905: 0xC45D,
	33136 - 11905: 0xD1FC,
	33137 - 11905: 0xEBEC,
	33138 - 11905: 0xC45E,
	33139 - 11905: 0xC45F,
	33140 - 11905: 0xEBE9,
	33141 - 11905: 0xC460,
	33142 - 11905: 0xC461,
	33143 - 11905: 0xC462,
	33144 - 11905: 0xC463,
	33145 - 11905: 0xB8B9,
	33146 - 11905: 0xCFD9,
	33147 - 11905: 0xC4E5,
	33148 - 11905: 0xEBEF,
	33149 - 11905: 0xEBF0,
	33150 - 11905: 0xCCDA,
	33151 - 11905: 0xCDC8,
	33152 - 11905: 0xB0F2,
	33153 - 11905: 0xC464,
	33154 - 11905: 0xEBF6,
	33155 - 11905: 0xC465,
	33156 - 11905: 0xC466,
	33157 - 11905: 0xC467,
	33158 - 11905: 0xC468,
	33159 - 11905: 0xC469,
	33160 - 11905: 0xEBF5,
	33161 - 11905: 0xC46A,
	33162 - 11905: 0xB2B2,
	33163 - 11905: 0xC46B,
	33164 - 11905: 0xC46C,
	33165 - 11905: 0xC46D,
	33166 - 11905: 0xC46E,
	33167 - 11905: 0xB8E0,
	33168 - 11905: 0xC46F,
	33169 - 11905: 0xEBF7,
	33170 - 11905: 0xC470,
	33171 - 11905: 0xC471,
	33172 - 11905: 0xC472,
	33173 - 11905: 0xC473,
	33174 - 11905: 0xC474,
	33175 - 11905: 0xC475,
	33176 - 11905: 0xB1EC,
	33177 - 11905: 0xC476,
	33178 - 11905: 0xC477,
	33179 - 11905: 0xCCC5,
	33180 - 11905: 0xC4A4,
	33181 - 11905: 0xCFA5,
	33182 - 11905: 0xC478,
	33183 - 11905: 0xC479,
	33184 - 11905: 0xC47A,
	33185 - 11905: 0xC47B,
	33186 - 11905: 0xC47C,
	33187 - 11905: 0xEBF9,
	33188 - 11905: 0xC47D,
	33189 - 11905: 0xC47E,
	33190 - 11905: 0xECA2,
	33191 - 11905: 0xC480,
	33192 - 11905: 0xC5F2,
	33193 - 11905: 0xC481,
	33194 - 11905: 0xEBFA,
	33195 - 11905: 0xC482,
	33196 - 11905: 0xC483,
	33197 - 11905: 0xC484,
	33198 - 11905: 0xC485,
	33199 - 11905: 0xC486,
	33200 - 11905: 0xC487,
	33201 - 11905: 0xC488,
	33202 - 11905: 0xC489,
	33203 - 11905: 0xC9C5,
	33204 - 11905: 0xC48A,
	33205 - 11905: 0xC48B,
	33206 - 11905: 0xC48C,
	33207 - 11905: 0xC48D,
	33208 - 11905: 0xC48E,
	33209 - 11905: 0xC48F,
	33210 - 11905: 0xE2DF,
	33211 - 11905: 0xEBFE,
	33212 - 11905: 0xC490,
	33213 - 11905: 0xC491,
	33214 - 11905: 0xC492,
	33215 - 11905: 0xC493,
	33216 - 11905: 0xCDCE,
	33217 - 11905: 0xECA1,
	33218 - 11905: 0xB1DB,
	33219 - 11905: 0xD3B7,
	33220 - 11905: 0xC494,
	33221 - 11905: 0xC495,
	33222 - 11905: 0xD2DC,
	33223 - 11905: 0xC496,
	33224 - 11905: 0xC497,
	33225 - 11905: 0xC498,
	33226 - 11905: 0xEBFD,
	33227 - 11905: 0xC499,
	33228 - 11905: 0xEBFB,
	33229 - 11905: 0xC49A,
	33230 - 11905: 0xC49B,
	33231 - 11905: 0xC49C,
	33232 - 11905: 0xC49D,
	33233 - 11905: 0xC49E,
	33234 - 11905: 0xC49F,
	33235 - 11905: 0xC4A0,
	33236 - 11905: 0xC540,
	33237 - 11905: 0xC541,
	33238 - 11905: 0xC542,
	33239 - 11905: 0xC543,
	33240 - 11905: 0xC544,
	33241 - 11905: 0xC545,
	33242 - 11905: 0xC546,
	33243 - 11905: 0xC547,
	33244 - 11905: 0xC548,
	33245 - 11905: 0xC549,
	33246 - 11905: 0xC54A,
	33247 - 11905: 0xC54B,
	33248 - 11905: 0xC54C,
	33249 - 11905: 0xC54D,
	33250 - 11905: 0xC54E,
	33251 - 11905: 0xB3BC,
	33252 - 11905: 0xC54F,
	33253 - 11905: 0xC550,
	33254 - 11905: 0xC551,
	33255 - 11905: 0xEAB0,
	33256 - 11905: 0xC552,
	33257 - 11905: 0xC553,
	33258 - 11905: 0xD7D4,
	33259 - 11905: 0xC554,
	33260 - 11905: 0xF4AB,
	33261 - 11905: 0xB3F4,
	33262 - 11905: 0xC555,
	33263 - 11905: 0xC556,
	33264 - 11905: 0xC557,
	33265 - 11905: 0xC558,
	33266 - 11905: 0xC559,
	33267 - 11905: 0xD6C1,
	33268 - 11905: 0xD6C2,
	33269 - 11905: 0xC55A,
	33270 - 11905: 0xC55B,
	33271 - 11905: 0xC55C,
	33272 - 11905: 0xC55D,
	33273 - 11905: 0xC55E,
	33274 - 11905: 0xC55F,
	33275 - 11905: 0xD5E9,
	33276 - 11905: 0xBECA,
	33277 - 11905: 0xC560,
	33278 - 11905: 0xF4A7,
	33279 - 11905: 0xC561,
	33280 - 11905: 0xD2A8,
	33281 - 11905: 0xF4A8,
	33282 - 11905: 0xF4A9,
	33283 - 11905: 0xC562,
	33284 - 11905: 0xF4AA,
	33285 - 11905: 0xBECB,
	33286 - 11905: 0xD3DF,
	33287 - 11905: 0xC563,
	33288 - 11905: 0xC564,
	33289 - 11905: 0xC565,
	33290 - 11905: 0xC566,
	33291 - 11905: 0xC567,
	33292 - 11905: 0xC9E0,
	33293 - 11905: 0xC9E1,
	33294 - 11905: 0xC568,
	33295 - 11905: 0xC569,
	33296 - 11905: 0xF3C2,
	33297 - 11905: 0xC56A,
	33298 - 11905: 0xCAE6,
	33299 - 11905: 0xC56B,
	33300 - 11905: 0xCCF2,
	33301 - 11905: 0xC56C,
	33302 - 11905: 0xC56D,
	33303 - 11905: 0xC56E,
	33304 - 11905: 0xC56F,
	33305 - 11905: 0xC570,
	33306 - 11905: 0xC571,
	33307 - 11905: 0xE2B6,
	33308 - 11905: 0xCBB4,
	33309 - 11905: 0xC572,
	33310 - 11905: 0xCEE8,
	33311 - 11905: 0xD6DB,
	33312 - 11905: 0xC573,
	33313 - 11905: 0xF4AD,
	33314 - 11905: 0xF4AE,
	33315 - 11905: 0xF4AF,
	33316 - 11905: 0xC574,
	33317 - 11905: 0xC575,
	33318 - 11905: 0xC576,
	33319 - 11905: 0xC577,
	33320 - 11905: 0xF4B2,
	33321 - 11905: 0xC578,
	33322 - 11905: 0xBABD,
	33323 - 11905: 0xF4B3,
	33324 - 11905: 0xB0E3,
	33325 - 11905: 0xF4B0,
	33326 - 11905: 0xC579,
	33327 - 11905: 0xF4B1,
	33328 - 11905: 0xBDA2,
	33329 - 11905: 0xB2D5,
	33330 - 11905: 0xC57A,
	33331 - 11905: 0xF4B6,
	33332 - 11905: 0xF4B7,
	33333 - 11905: 0xB6E6,
	33334 - 11905: 0xB2B0,
	33335 - 11905: 0xCFCF,
	33336 - 11905: 0xF4B4,
	33337 - 11905: 0xB4AC,
	33338 - 11905: 0xC57B,
	33339 - 11905: 0xF4B5,
	33340 - 11905: 0xC57C,
	33341 - 11905: 0xC57D,
	33342 - 11905: 0xF4B8,
	33343 - 11905: 0xC57E,
	33344 - 11905: 0xC580,
	33345 - 11905: 0xC581,
	33346 - 11905: 0xC582,
	33347 - 11905: 0xC583,
	33348 - 11905: 0xF4B9,
	33349 - 11905: 0xC584,
	33350 - 11905: 0xC585,
	33351 - 11905: 0xCDA7,
	33352 - 11905: 0xC586,
	33353 - 11905: 0xF4BA,
	33354 - 11905: 0xC587,
	33355 - 11905: 0xF4BB,
	33356 - 11905: 0xC588,
	33357 - 11905: 0xC589,
	33358 - 11905: 0xC58A,
	33359 - 11905: 0xF4BC,
	33360 - 11905: 0xC58B,
	33361 - 11905: 0xC58C,
	33362 - 11905: 0xC58D,
	33363 - 11905: 0xC58E,
	33364 - 11905: 0xC58F,
	33365 - 11905: 0xC590,
	33366 - 11905: 0xC591,
	33367 - 11905: 0xC592,
	33368 - 11905: 0xCBD2,
	33369 - 11905: 0xC593,
	33370 - 11905: 0xF4BD,
	33371 - 11905: 0xC594,
	33372 - 11905: 0xC595,
	33373 - 11905: 0xC596,
	33374 - 11905: 0xC597,
	33375 - 11905: 0xF4BE,
	33376 - 11905: 0xC598,
	33377 - 11905: 0xC599,
	33378 - 11905: 0xC59A,
	33379 - 11905: 0xC59B,
	33380 - 11905: 0xC59C,
	33381 - 11905: 0xC59D,
	33382 - 11905: 0xC59E,
	33383 - 11905: 0xC59F,
	33384 - 11905: 0xF4BF,
	33385 - 11905: 0xC5A0,
	33386 - 11905: 0xC640,
	33387 - 11905: 0xC641,
	33388 - 11905: 0xC642,
	33389 - 11905: 0xC643,
	33390 - 11905: 0xF4DE,
	33391 - 11905: 0xC1BC,
	33392 - 11905: 0xBCE8,
	33393 - 11905: 0xC644,
	33394 - 11905: 0xC9AB,
	33395 - 11905: 0xD1DE,
	33396 - 11905: 0xE5F5,
	33397 - 11905: 0xC645,
	33398 - 11905: 0xC646,
	33399 - 11905: 0xC647,
	33400 - 11905: 0xC648,
	33401 - 11905: 0xDCB3,
	33402 - 11905: 0xD2D5,
	33403 - 11905: 0xC649,
	33404 - 11905: 0xC64A,
	33405 - 11905: 0xDCB4,
	33406 - 11905: 0xB0AC,
	33407 - 11905: 0xDCB5,
	33408 - 11905: 0xC64B,
	33409 - 11905: 0xC64C,
	33410 - 11905: 0xBDDA,
	33411 - 11905: 0xC64D,
	33412 - 11905: 0xDCB9,
	33413 - 11905: 0xC64E,
	33414 - 11905: 0xC64F,
	33415 - 11905: 0xC650,
	33416 - 11905: 0xD8C2,
	33417 - 11905: 0xC651,
	33418 - 11905: 0xDCB7,
	33419 - 11905: 0xD3F3,
	33420 - 11905: 0xC652,
	33421 - 11905: 0xC9D6,
	33422 - 11905: 0xDCBA,
	33423 - 11905: 0xDCB6,
	33424 - 11905: 0xC653,
	33425 - 11905: 0xDCBB,
	33426 - 11905: 0xC3A2,
	33427 - 11905: 0xC654,
	33428 - 11905: 0xC655,
	33429 - 11905: 0xC656,
	33430 - 11905: 0xC657,
	33431 - 11905: 0xDCBC,
	33432 - 11905: 0xDCC5,
	33433 - 11905: 0xDCBD,
	33434 - 11905: 0xC658,
	33435 - 11905: 0xC659,
	33436 - 11905: 0xCEDF,
	33437 - 11905: 0xD6A5,
	33438 - 11905: 0xC65A,
	33439 - 11905: 0xDCCF,
	33440 - 11905: 0xC65B,
	33441 - 11905: 0xDCCD,
	33442 - 11905: 0xC65C,
	33443 - 11905: 0xC65D,
	33444 - 11905: 0xDCD2,
	33445 - 11905: 0xBDE6,
	33446 - 11905: 0xC2AB,
	33447 - 11905: 0xC65E,
	33448 - 11905: 0xDCB8,
	33449 - 11905: 0xDCCB,
	33450 - 11905: 0xDCCE,
	33451 - 11905: 0xDCBE,
	33452 - 11905: 0xB7D2,
	33453 - 11905: 0xB0C5,
	33454 - 11905: 0xDCC7,
	33455 - 11905: 0xD0BE,
	33456 - 11905: 0xDCC1,
	33457 - 11905: 0xBBA8,
	33458 - 11905: 0xC65F,
	33459 - 11905: 0xB7BC,
	33460 - 11905: 0xDCCC,
	33461 - 11905: 0xC660,
	33462 - 11905: 0xC661,
	33463 - 11905: 0xDCC6,
	33464 - 11905: 0xDCBF,
	33465 - 11905: 0xC7DB,
	33466 - 11905: 0xC662,
	33467 - 11905: 0xC663,
	33468 - 11905: 0xC664,
	33469 - 11905: 0xD1BF,
	33470 - 11905: 0xDCC0,
	33471 - 11905: 0xC665,
	33472 - 11905: 0xC666,
	33473 - 11905: 0xDCCA,
	33474 - 11905: 0xC667,
	33475 - 11905: 0xC668,
	33476 - 11905: 0xDCD0,
	33477 - 11905: 0xC669,
	33478 - 11905: 0xC66A,
	33479 - 11905: 0xCEAD,
	33480 - 11905: 0xDCC2,
	33481 - 11905: 0xC66B,
	33482 - 11905: 0xDCC3,
	33483 - 11905: 0xDCC8,
	33484 - 11905: 0xDCC9,
	33485 - 11905: 0xB2D4,
	33486 - 11905: 0xDCD1,
	33487 - 11905: 0xCBD5,
	33488 - 11905: 0xC66C,
	33489 - 11905: 0xD4B7,
	33490 - 11905: 0xDCDB,
	33491 - 11905: 0xDCDF,
	33492 - 11905: 0xCCA6,
	33493 - 11905: 0xDCE6,
	33494 - 11905: 0xC66D,
	33495 - 11905: 0xC3E7,
	33496 - 11905: 0xDCDC,
	33497 - 11905: 0xC66E,
	33498 - 11905: 0xC66F,
	33499 - 11905: 0xBFC1,
	33500 - 11905: 0xDCD9,
	33501 - 11905: 0xC670,
	33502 - 11905: 0xB0FA,
	33503 - 11905: 0xB9B6,
	33504 - 11905: 0xDCE5,
	33505 - 11905: 0xDCD3,
	33506 - 11905: 0xC671,
	33507 - 11905: 0xDCC4,
	33508 - 11905: 0xDCD6,
	33509 - 11905: 0xC8F4,
	33510 - 11905: 0xBFE0,
	33511 - 11905: 0xC672,
	33512 - 11905: 0xC673,
	33513 - 11905: 0xC674,
	33514 - 11905: 0xC675,
	33515 - 11905: 0xC9BB,
	33516 - 11905: 0xC676,
	33517 - 11905: 0xC677,
	33518 - 11905: 0xC678,
	33519 - 11905: 0xB1BD,
	33520 - 11905: 0xC679,
	33521 - 11905: 0xD3A2,
	33522 - 11905: 0xC67A,
	33523 - 11905: 0xC67B,
	33524 - 11905: 0xDCDA,
	33525 - 11905: 0xC67C,
	33526 - 11905: 0xC67D,
	33527 - 11905: 0xDCD5,
	33528 - 11905: 0xC67E,
	33529 - 11905: 0xC6BB,
	33530 - 11905: 0xC680,
	33531 - 11905: 0xDCDE,
	33532 - 11905: 0xC681,
	33533 - 11905: 0xC682,
	33534 - 11905: 0xC683,
	33535 - 11905: 0xC684,
	33536 - 11905: 0xC685,
	33537 - 11905: 0xD7C2,
	33538 - 11905: 0xC3AF,
	33539 - 11905: 0xB7B6,
	33540 - 11905: 0xC7D1,
	33541 - 11905: 0xC3A9,
	33542 - 11905: 0xDCE2,
	33543 - 11905: 0xDCD8,
	33544 - 11905: 0xDCEB,
	33545 - 11905: 0xDCD4,
	33546 - 11905: 0xC686,
	33547 - 11905: 0xC687,
	33548 - 11905: 0xDCDD,
	33549 - 11905: 0xC688,
	33550 - 11905: 0xBEA5,
	33551 - 11905: 0xDCD7,
	33552 - 11905: 0xC689,
	33553 - 11905: 0xDCE0,
	33554 - 11905: 0xC68A,
	33555 - 11905: 0xC68B,
	33556 - 11905: 0xDCE3,
	33557 - 11905: 0xDCE4,
	33558 - 11905: 0xC68C,
	33559 - 11905: 0xDCF8,
	33560 - 11905: 0xC68D,
	33561 - 11905: 0xC68E,
	33562 - 11905: 0xDCE1,
	33563 - 11905: 0xDDA2,
	33564 - 11905: 0xDCE7,
	33565 - 11905: 0xC68F,
	33566 - 11905: 0xC690,
	33567 - 11905: 0xC691,
	33568 - 11905: 0xC692,
	33569 - 11905: 0xC693,
	33570 - 11905: 0xC694,
	33571 - 11905: 0xC695,
	33572 - 11905: 0xC696,
	33573 - 11905: 0xC697,
	33574 - 11905: 0xC698,
	33575 - 11905: 0xBCEB,
	33576 - 11905: 0xB4C4,
	33577 - 11905: 0xC699,
	33578 - 11905: 0xC69A,
	33579 - 11905: 0xC3A3,
	33580 - 11905: 0xB2E7,
	33581 - 11905: 0xDCFA,
	33582 - 11905: 0xC69B,
	33583 - 11905: 0xDCF2,
	33584 - 11905: 0xC69C,
	33585 - 11905: 0xDCEF,
	33586 - 11905: 0xC69D,
	33587 - 11905: 0xDCFC,
	33588 - 11905: 0xDCEE,
	33589 - 11905: 0xD2F0,
	33590 - 11905: 0xB2E8,
	33591 - 11905: 0xC69E,
	33592 - 11905: 0xC8D7,
	33593 - 11905: 0xC8E3,
	33594 - 11905: 0xDCFB,
	33595 - 11905: 0xC69F,
	33596 - 11905: 0xDCED,
	33597 - 11905: 0xC6A0,
	33598 - 11905: 0xC740,
	33599 - 11905: 0xC741,
	33600 - 11905: 0xDCF7,
	33601 - 11905: 0xC742,
	33602 - 11905: 0xC743,
	33603 - 11905: 0xDCF5,
	33604 - 11905: 0xC744,
	33605 - 11905: 0xC745,
	33606 - 11905: 0xBEA3,
	33607 - 11905: 0xDCF4,
	33608 - 11905: 0xC746,
	33609 - 11905: 0xB2DD,
	33610 - 11905: 0xC747,
	33611 - 11905: 0xC748,
	33612 - 11905: 0xC749,
	33613 - 11905: 0xC74A,
	33614 - 11905: 0xC74B,
	33615 - 11905: 0xDCF3,
	33616 - 11905: 0xBCF6,
	33617 - 11905: 0xDCE8,
	33618 - 11905: 0xBBC4,
	33619 - 11905: 0xC74C,
	33620 - 11905: 0xC0F3,
	33621 - 11905: 0xC74D,
	33622 - 11905: 0xC74E,
	33623 - 11905: 0xC74F,
	33624 - 11905: 0xC750,
	33625 - 11905: 0xC751,
	33626 - 11905: 0xBCD4,
	33627 - 11905: 0xDCE9,
	33628 - 11905: 0xDCEA,
	33629 - 11905: 0xC752,
	33630 - 11905: 0xDCF1,
	33631 - 11905: 0xDCF6,
	33632 - 11905: 0xDCF9,
	33633 - 11905: 0xB5B4,
	33634 - 11905: 0xC753,
	33635 - 11905: 0xC8D9,
	33636 - 11905: 0xBBE7,
	33637 - 11905: 0xDCFE,
	33638 - 11905: 0xDCFD,
	33639 - 11905: 0xD3AB,
	33640 - 11905: 0xDDA1,
	33641 - 11905: 0xDDA3,
	33642 - 11905: 0xDDA5,
	33643 - 11905: 0xD2F1,
	33644 - 11905: 0xDDA4,
	33645 - 11905: 0xDDA6,
	33646 - 11905: 0xDDA7,
	33647 - 11905: 0xD2A9,
	33648 - 11905: 0xC754,
	33649 - 11905: 0xC755,
	33650 - 11905: 0xC756,
	33651 - 11905: 0xC757,
	33652 - 11905: 0xC758,
	33653 - 11905: 0xC759,
	33654 - 11905: 0xC75A,
	33655 - 11905: 0xBAC9,
	33656 - 11905: 0xDDA9,
	33657 - 11905: 0xC75B,
	33658 - 11905: 0xC75C,
	33659 - 11905: 0xDDB6,
	33660 - 11905: 0xDDB1,
	33661 - 11905: 0xDDB4,
	33662 - 11905: 0xC75D,
	33663 - 11905: 0xC75E,
	33664 - 11905: 0xC75F,
	33665 - 11905: 0xC760,
	33666 - 11905: 0xC761,
	33667 - 11905: 0xC762,
	33668 - 11905: 0xC763,
	33669 - 11905: 0xDDB0,
	33670 - 11905: 0xC6CE,
	33671 - 11905: 0xC764,
	33672 - 11905: 0xC765,
	33673 - 11905: 0xC0F2,
	33674 - 11905: 0xC766,
	33675 - 11905: 0xC767,
	33676 - 11905: 0xC768,
	33677 - 11905: 0xC769,
	33678 - 11905: 0xC9AF,
	33679 - 11905: 0xC76A,
	33680 - 11905: 0xC76B,
	33681 - 11905: 0xC76C,
	33682 - 11905: 0xDCEC,
	33683 - 11905: 0xDDAE,
	33684 - 11905: 0xC76D,
	33685 - 11905: 0xC76E,
	33686 - 11905: 0xC76F,
	33687 - 11905: 0xC770,
	33688 - 11905: 0xDDB7,
	33689 - 11905: 0xC771,
	33690 - 11905: 0xC772,
	33691 - 11905: 0xDCF0,
	33692 - 11905: 0xDDAF,
	33693 - 11905: 0xC773,
	33694 - 11905: 0xDDB8,
	33695 - 11905: 0xC774,
	33696 - 11905: 0xDDAC,
	33697 - 11905: 0xC775,
	33698 - 11905: 0xC776,
	33699 - 11905: 0xC777,
	33700 - 11905: 0xC778,
	33701 - 11905: 0xC779,
	33702 - 11905: 0xC77A,
	33703 - 11905: 0xC77B,
	33704 - 11905: 0xDDB9,
	33705 - 11905: 0xDDB3,
	33706 - 11905: 0xDDAD,
	33707 - 11905: 0xC4AA,
	33708 - 11905: 0xC77C,
	33709 - 11905: 0xC77D,
	33710 - 11905: 0xC77E,
	33711 - 11905: 0xC780,
	33712 - 11905: 0xDDA8,
	33713 - 11905: 0xC0B3,
	33714 - 11905: 0xC1AB,
	33715 - 11905: 0xDDAA,
	33716 - 11905: 0xDDAB,
	33717 - 11905: 0xC781,
	33718 - 11905: 0xDDB2,
	33719 - 11905: 0xBBF1,
	33720 - 11905: 0xDDB5,
	33721 - 11905: 0xD3A8,
	33722 - 11905: 0xDDBA,
	33723 - 11905: 0xC782,
	33724 - 11905: 0xDDBB,
	33725 - 11905: 0xC3A7,
	33726 - 11905: 0xC783,
	33727 - 11905: 0xC784,
	33728 - 11905: 0xDDD2,
	33729 - 11905: 0xDDBC,
	33730 - 11905: 0xC785,
	33731 - 11905: 0xC786,
	33732 - 11905: 0xC787,
	33733 - 11905: 0xDDD1,
	33734 - 11905: 0xC788,
	33735 - 11905: 0xB9BD,
	33736 - 11905: 0xC789,
	33737 - 11905: 0xC78A,
	33738 - 11905: 0xBED5,
	33739 - 11905: 0xC78B,
	33740 - 11905: 0xBEFA,
	33741 - 11905: 0xC78C,
	33742 - 11905: 0xC78D,
	33743 - 11905: 0xBACA,
	33744 - 11905: 0xC78E,
	33745 - 11905: 0xC78F,
	33746 - 11905: 0xC790,
	33747 - 11905: 0xC791,
	33748 - 11905: 0xDDCA,
	33749 - 11905: 0xC792,
	33750 - 11905: 0xDDC5,
	33751 - 11905: 0xC793,
	33752 - 11905: 0xDDBF,
	33753 - 11905: 0xC794,
	33754 - 11905: 0xC795,
	33755 - 11905: 0xC796,
	33756 - 11905: 0xB2CB,
	33757 - 11905: 0xDDC3,
	33758 - 11905: 0xC797,
	33759 - 11905: 0xDDCB,
	33760 - 11905: 0xB2A4,
	33761 - 11905: 0xDDD5,
	33762 - 11905: 0xC798,
	33763 - 11905: 0xC799,
	33764 - 11905: 0xC79A,
	33765 - 11905: 0xDDBE,
	33766 - 11905: 0xC79B,
	33767 - 11905: 0xC79C,
	33768 - 11905: 0xC79D,
	33769 - 11905: 0xC6D0,
	33770 - 11905: 0xDDD0,
	33771 - 11905: 0xC79E,
	33772 - 11905: 0xC79F,
	33773 - 11905: 0xC7A0,
	33774 - 11905: 0xC840,
	33775 - 11905: 0xC841,
	33776 - 11905: 0xDDD4,
	33777 - 11905: 0xC1E2,
	33778 - 11905: 0xB7C6,
	33779 - 11905: 0xC842,
	33780 - 11905: 0xC843,
	33781 - 11905: 0xC844,
	33782 - 11905: 0xC845,
	33783 - 11905: 0xC846,
	33784 - 11905: 0xDDCE,
	33785 - 11905: 0xDDCF,
	33786 - 11905: 0xC847,
	33787 - 11905: 0xC848,
	33788 - 11905: 0xC849,
	33789 - 11905: 0xDDC4,
	33790 - 11905: 0xC84A,
	33791 - 11905: 0xC84B,
	33792 - 11905: 0xC84C,
	33793 - 11905: 0xDDBD,
	33794 - 11905: 0xC84D,
	33795 - 11905: 0xDDCD,
	33796 - 11905: 0xCCD1,
	33797 - 11905: 0xC84E,
	33798 - 11905: 0xDDC9,
	33799 - 11905: 0xC84F,
	33800 - 11905: 0xC850,
	33801 - 11905: 0xC851,
	33802 - 11905: 0xC852,
	33803 - 11905: 0xDDC2,
	33804 - 11905: 0xC3C8,
	33805 - 11905: 0xC6BC,
	33806 - 11905: 0xCEAE,
	33807 - 11905: 0xDDCC,
	33808 - 11905: 0xC853,
	33809 - 11905: 0xDDC8,
	33810 - 11905: 0xC854,
	33811 - 11905: 0xC855,
	33812 - 11905: 0xC856,
	33813 - 11905: 0xC857,
	33814 - 11905: 0xC858,
	33815 - 11905: 0xC859,
	33816 - 11905: 0xDDC1,
	33817 - 11905: 0xC85A,
	33818 - 11905: 0xC85B,
	33819 - 11905: 0xC85C,
	33820 - 11905: 0xDDC6,
	33821 - 11905: 0xC2DC,
	33822 - 11905: 0xC85D,
	33823 - 11905: 0xC85E,
	33824 - 11905: 0xC85F,
	33825 - 11905: 0xC860,
	33826 - 11905: 0xC861,
	33827 - 11905: 0xC862,
	33828 - 11905: 0xD3A9,
	33829 - 11905: 0xD3AA,
	33830 - 11905: 0xDDD3,
	33831 - 11905: 0xCFF4,
	33832 - 11905: 0xC8F8,
	33833 - 11905: 0xC863,
	33834 - 11905: 0xC864,
	33835 - 11905: 0xC865,
	33836 - 11905: 0xC866,
	33837 - 11905: 0xC867,
	33838 - 11905: 0xC868,
	33839 - 11905: 0xC869,
	33840 - 11905: 0xC86A,
	33841 - 11905: 0xDDE6,
	33842 - 11905: 0xC86B,
	33843 - 11905: 0xC86C,
	33844 - 11905: 0xC86D,
	33845 - 11905: 0xC86E,
	33846 - 11905: 0xC86F,
	33847 - 11905: 0xC870,
	33848 - 11905: 0xDDC7,
	33849 - 11905: 0xC871,
	33850 - 11905: 0xC872,
	33851 - 11905: 0xC873,
	33852 - 11905: 0xDDE0,
	33853 - 11905: 0xC2E4,
	33854 - 11905: 0xC874,
	33855 - 11905: 0xC875,
	33856 - 11905: 0xC876,
	33857 - 11905: 0xC877,
	33858 - 11905: 0xC878,
	33859 - 11905: 0xC879,
	33860 - 11905: 0xC87A,
	33861 - 11905: 0xC87B,
	33862 - 11905: 0xDDE1,
	33863 - 11905: 0xC87C,
	33864 - 11905: 0xC87D,
	33865 - 11905: 0xC87E,
	33866 - 11905: 0xC880,
	33867 - 11905: 0xC881,
	33868 - 11905: 0xC882,
	33869 - 11905: 0xC883,
	33870 - 11905: 0xC884,
	33871 - 11905: 0xC885,
	33872 - 11905: 0xC886,
	33873 - 11905: 0xDDD7,
	33874 - 11905: 0xC887,
	33875 - 11905: 0xC888,
	33876 - 11905: 0xC889,
	33877 - 11905: 0xC88A,
	33878 - 11905: 0xC88B,
	33879 - 11905: 0xD6F8,
	33880 - 11905: 0xC88C,
	33881 - 11905: 0xDDD9,
	33882 - 11905: 0xDDD8,
	33883 - 11905: 0xB8F0,
	33884 - 11905: 0xDDD6,
	33885 - 11905: 0xC88D,
	33886 - 11905: 0xC88E,
	33887 - 11905: 0xC88F,
	33888 - 11905: 0xC890,
	33889 - 11905: 0xC6CF,
	33890 - 11905: 0xC891,
	33891 - 11905: 0xB6AD,
	33892 - 11905: 0xC892,
	33893 - 11905: 0xC893,
	33894 - 11905: 0xC894,
	33895 - 11905: 0xC895,
	33896 - 11905: 0xC896,
	33897 - 11905: 0xDDE2,
	33898 - 11905: 0xC897,
	33899 - 11905: 0xBAF9,
	33900 - 11905: 0xD4E1,
	33901 - 11905: 0xDDE7,
	33902 - 11905: 0xC898,
	33903 - 11905: 0xC899,
	33904 - 11905: 0xC89A,
	33905 - 11905: 0xB4D0,
	33906 - 11905: 0xC89B,
	33907 - 11905: 0xDDDA,
	33908 - 11905: 0xC89C,
	33909 - 11905: 0xBFFB,
	33910 - 11905: 0xDDE3,
	33911 - 11905: 0xC89D,
	33912 - 11905: 0xDDDF,
	33913 - 11905: 0xC89E,
	33914 - 11905: 0xDDDD,
	33915 - 11905: 0xC89F,
	33916 - 11905: 0xC8A0,
	33917 - 11905: 0xC940,
	33918 - 11905: 0xC941,
	33919 - 11905: 0xC942,
	33920 - 11905: 0xC943,
	33921 - 11905: 0xC944,
	33922 - 11905: 0xB5D9,
	33923 - 11905: 0xC945,
	33924 - 11905: 0xC946,
	33925 - 11905: 0xC947,
	33926 - 11905: 0xC948,
	33927 - 11905: 0xDDDB,
	33928 - 11905: 0xDDDC,
	33929 - 11905: 0xDDDE,
	33930 - 11905: 0xC949,
	33931 - 11905: 0xBDAF,
	33932 - 11905: 0xDDE4,
	33933 - 11905: 0xC94A,
	33934 - 11905: 0xDDE5,
	33935 - 11905: 0xC94B,
	33936 - 11905: 0xC94C,
	33937 - 11905: 0xC94D,
	33938 - 11905: 0xC94E,
	33939 - 11905: 0xC94F,
	33940 - 11905: 0xC950,
	33941 - 11905: 0xC951,
	33942 - 11905: 0xC952,
	33943 - 11905: 0xDDF5,
	33944 - 11905: 0xC953,
	33945 - 11905: 0xC3C9,
	33946 - 11905: 0xC954,
	33947 - 11905: 0xC955,
	33948 - 11905: 0xCBE2,
	33949 - 11905: 0xC956,
	33950 - 11905: 0xC957,
	33951 - 11905: 0xC958,
	33952 - 11905: 0xC959,
	33953 - 11905: 0xDDF2,
	33954 - 11905: 0xC95A,
	33955 - 11905: 0xC95B,
	33956 - 11905: 0xC95C,
	33957 - 11905: 0xC95D,
	33958 - 11905: 0xC95E,
	33959 - 11905: 0xC95F,
	33960 - 11905: 0xC960,
	33961 - 11905: 0xC961,
	33962 - 11905: 0xC962,
	33963 - 11905: 0xC963,
	33964 - 11905: 0xC964,
	33965 - 11905: 0xC965,
	33966 - 11905: 0xC966,
	33967 - 11905: 0xD8E1,
	33968 - 11905: 0xC967,
	33969 - 11905: 0xC968,
	33970 - 11905: 0xC6D1,
	33971 - 11905: 0xC969,
	33972 - 11905: 0xDDF4,
	33973 - 11905: 0xC96A,
	33974 - 11905: 0xC96B,
	33975 - 11905: 0xC96C,
	33976 - 11905: 0xD5F4,
	33977 - 11905: 0xDDF3,
	33978 - 11905: 0xDDF0,
	33979 - 11905: 0xC96D,
	33980 - 11905: 0xC96E,
	33981 - 11905: 0xDDEC,
	33982 - 11905: 0xC96F,
	33983 - 11905: 0xDDEF,
	33984 - 11905: 0xC970,
	33985 - 11905: 0xDDE8,
	33986 - 11905: 0xC971,
	33987 - 11905: 0xC972,
	33988 - 11905: 0xD0EE,
	33989 - 11905: 0xC973,
	33990 - 11905: 0xC974,
	33991 - 11905: 0xC975,
	33992 - 11905: 0xC976,
	33993 - 11905: 0xC8D8,
	33994 - 11905: 0xDDEE,
	33995 - 11905: 0xC977,
	33996 - 11905: 0xC978,
	33997 - 11905: 0xDDE9,
	33998 - 11905: 0xC979,
	33999 - 11905: 0xC97A,
	34000 - 11905: 0xDDEA,
	34001 - 11905: 0xCBF2,
	34002 - 11905: 0xC97B,
	34003 - 11905: 0xDDED,
	34004 - 11905: 0xC97C,
	34005 - 11905: 0xC97D,
	34006 - 11905: 0xB1CD,
	34007 - 11905: 0xC97E,
	34008 - 11905: 0xC980,
	34009 - 11905: 0xC981,
	34010 - 11905: 0xC982,
	34011 - 11905: 0xC983,
	34012 - 11905: 0xC984,
	34013 - 11905: 0xC0B6,
	34014 - 11905: 0xC985,
	34015 - 11905: 0xBCBB,
	34016 - 11905: 0xDDF1,
	34017 - 11905: 0xC986,
	34018 - 11905: 0xC987,
	34019 - 11905: 0xDDF7,
	34020 - 11905: 0xC988,
	34021 - 11905: 0xDDF6,
	34022 - 11905: 0xDDEB,
	34023 - 11905: 0xC989,
	34024 - 11905: 0xC98A,
	34025 - 11905: 0xC98B,
	34026 - 11905: 0xC98C,
	34027 - 11905: 0xC98D,
	34028 - 11905: 0xC5EE,
	34029 - 11905: 0xC98E,
	34030 - 11905: 0xC98F,
	34031 - 11905: 0xC990,
	34032 - 11905: 0xDDFB,
	34033 - 11905: 0xC991,
	34034 - 11905: 0xC992,
	34035 - 11905: 0xC993,
	34036 - 11905: 0xC994,
	34037 - 11905: 0xC995,
	34038 - 11905: 0xC996,
	34039 - 11905: 0xC997,
	34040 - 11905: 0xC998,
	34041 - 11905: 0xC999,
	34042 - 11905: 0xC99A,
	34043 - 11905: 0xC99B,
	34044 - 11905: 0xDEA4,
	34045 - 11905: 0xC99C,
	34046 - 11905: 0xC99D,
	34047 - 11905: 0xDEA3,
	34048 - 11905: 0xC99E,
	34049 - 11905: 0xC99F,
	34050 - 11905: 0xC9A0,
	34051 - 11905: 0xCA40,
	34052 - 11905: 0xCA41,
	34053 - 11905: 0xCA42,
	34054 - 11905: 0xCA43,
	34055 - 11905: 0xCA44,
	34056 - 11905: 0xCA45,
	34057 - 11905: 0xCA46,
	34058 - 11905: 0xCA47,
	34059 - 11905: 0xCA48,
	34060 - 11905: 0xDDF8,
	34061 - 11905: 0xCA49,
	34062 - 11905: 0xCA4A,
	34063 - 11905: 0xCA4B,
	34064 - 11905: 0xCA4C,
	34065 - 11905: 0xC3EF,
	34066 - 11905: 0xCA4D,
	34067 - 11905: 0xC2FB,
	34068 - 11905: 0xCA4E,
	34069 - 11905: 0xCA4F,
	34070 - 11905: 0xCA50,
	34071 - 11905: 0xD5E1,
	34072 - 11905: 0xCA51,
	34073 - 11905: 0xCA52,
	34074 - 11905: 0xCEB5,
	34075 - 11905: 0xCA53,
	34076 - 11905: 0xCA54,
	34077 - 11905: 0xCA55,
	34078 - 11905: 0xCA56,
	34079 - 11905: 0xDDFD,
	34080 - 11905: 0xCA57,
	34081 - 11905: 0xB2CC,
	34082 - 11905: 0xCA58,
	34083 - 11905: 0xCA59,
	34084 - 11905: 0xCA5A,
	34085 - 11905: 0xCA5B,
	34086 - 11905: 0xCA5C,
	34087 - 11905: 0xCA5D,
	34088 - 11905: 0xCA5E,
	34089 - 11905: 0xCA5F,
	34090 - 11905: 0xCA60,
	34091 - 11905: 0xC4E8,
	34092 - 11905: 0xCADF,
	34093 - 11905: 0xCA61,
	34094 - 11905: 0xCA62,
	34095 - 11905: 0xCA63,
	34096 - 11905: 0xCA64,
	34097 - 11905: 0xCA65,
	34098 - 11905: 0xCA66,
	34099 - 11905: 0xCA67,
	34100 - 11905: 0xCA68,
	34101 - 11905: 0xCA69,
	34102 - 11905: 0xCA6A,
	34103 - 11905: 0xC7BE,
	34104 - 11905: 0xDDFA,
	34105 - 11905: 0xDDFC,
	34106 - 11905: 0xDDFE,
	34107 - 11905: 0xDEA2,
	34108 - 11905: 0xB0AA,
	34109 - 11905: 0xB1CE,
	34110 - 11905: 0xCA6B,
	34111 - 11905: 0xCA6C,
	34112 - 11905: 0xCA6D,
	34113 - 11905: 0xCA6E,
	34114 - 11905: 0xCA6F,
	34115 - 11905: 0xDEAC,
	34116 - 11905: 0xCA70,
	34117 - 11905: 0xCA71,
	34118 - 11905: 0xCA72,
	34119 - 11905: 0xCA73,
	34120 - 11905: 0xDEA6,
	34121 - 11905: 0xBDB6,
	34122 - 11905: 0xC8EF,
	34123 - 11905: 0xCA74,
	34124 - 11905: 0xCA75,
	34125 - 11905: 0xCA76,
	34126 - 11905: 0xCA77,
	34127 - 11905: 0xCA78,
	34128 - 11905: 0xCA79,
	34129 - 11905: 0xCA7A,
	34130 - 11905: 0xCA7B,
	34131 - 11905: 0xCA7C,
	34132 - 11905: 0xCA7D,
	34133 - 11905: 0xCA7E,
	34134 - 11905: 0xDEA1,
	34135 - 11905: 0xCA80,
	34136 - 11905: 0xCA81,
	34137 - 11905: 0xDEA5,
	34138 - 11905: 0xCA82,
	34139 - 11905: 0xCA83,
	34140 - 11905: 0xCA84,
	34141 - 11905: 0xCA85,
	34142 - 11905: 0xDEA9,
	34143 - 11905: 0xCA86,
	34144 - 11905: 0xCA87,
	34145 - 11905: 0xCA88,
	34146 - 11905: 0xCA89,
	34147 - 11905: 0xCA8A,
	34148 - 11905: 0xDEA8,
	34149 - 11905: 0xCA8B,
	34150 - 11905: 0xCA8C,
	34151 - 11905: 0xCA8D,
	34152 - 11905: 0xDEA7,
	34153 - 11905: 0xCA8E,
	34154 - 11905: 0xCA8F,
	34155 - 11905: 0xCA90,
	34156 - 11905: 0xCA91,
	34157 - 11905: 0xCA92,
	34158 - 11905: 0xCA93,
	34159 - 11905: 0xCA94,
	34160 - 11905: 0xCA95,
	34161 - 11905: 0xCA96,
	34162 - 11905: 0xDEAD,
	34163 - 11905: 0xCA97,
	34164 - 11905: 0xD4CC,
	34165 - 11905: 0xCA98,
	34166 - 11905: 0xCA99,
	34167 - 11905: 0xCA9A,
	34168 - 11905: 0xCA9B,
	34169 - 11905: 0xDEB3,
	34170 - 11905: 0xDEAA,
	34171 - 11905: 0xDEAE,
	34172 - 11905: 0xCA9C,
	34173 - 11905: 0xCA9D,
	34174 - 11905: 0xC0D9,
	34175 - 11905: 0xCA9E,
	34176 - 11905: 0xCA9F,
	34177 - 11905: 0xCAA0,
	34178 - 11905: 0xCB40,
	34179 - 11905: 0xCB41,
	34180 - 11905: 0xB1A1,
	34181 - 11905: 0xDEB6,
	34182 - 11905: 0xCB42,
	34183 - 11905: 0xDEB1,
	34184 - 11905: 0xCB43,
	34185 - 11905: 0xCB44,
	34186 - 11905: 0xCB45,
	34187 - 11905: 0xCB46,
	34188 - 11905: 0xCB47,
	34189 - 11905: 0xCB48,
	34190 - 11905: 0xCB49,
	34191 - 11905: 0xDEB2,
	34192 - 11905: 0xCB4A,
	34193 - 11905: 0xCB4B,
	34194 - 11905: 0xCB4C,
	34195 - 11905: 0xCB4D,
	34196 - 11905: 0xCB4E,
	34197 - 11905: 0xCB4F,
	34198 - 11905: 0xCB50,
	34199 - 11905: 0xCB51,
	34200 - 11905: 0xCB52,
	34201 - 11905: 0xCB53,
	34202 - 11905: 0xCB54,
	34203 - 11905: 0xD1A6,
	34204 - 11905: 0xDEB5,
	34205 - 11905: 0xCB55,
	34206 - 11905: 0xCB56,
	34207 - 11905: 0xCB57,
	34208 - 11905: 0xCB58,
	34209 - 11905: 0xCB59,
	34210 - 11905: 0xCB5A,
	34211 - 11905: 0xCB5B,
	34212 - 11905: 0xDEAF,
	34213 - 11905: 0xCB5C,
	34214 - 11905: 0xCB5D,
	34215 - 11905: 0xCB5E,
	34216 - 11905: 0xDEB0,
	34217 - 11905: 0xCB5F,
	34218 - 11905: 0xD0BD,
	34219 - 11905: 0xCB60,
	34220 - 11905: 0xCB61,
	34221 - 11905: 0xCB62,
	34222 - 11905: 0xDEB4,
	34223 - 11905: 0xCAED,
	34224 - 11905: 0xDEB9,
	34225 - 11905: 0xCB63,
	34226 - 11905: 0xCB64,
	34227 - 11905: 0xCB65,
	34228 - 11905: 0xCB66,
	34229 - 11905: 0xCB67,
	34230 - 11905: 0xCB68,
	34231 - 11905: 0xDEB8,
	34232 - 11905: 0xCB69,
	34233 - 11905: 0xDEB7,
	34234 - 11905: 0xCB6A,
	34235 - 11905: 0xCB6B,
	34236 - 11905: 0xCB6C,
	34237 - 11905: 0xCB6D,
	34238 - 11905: 0xCB6E,
	34239 - 11905: 0xCB6F,
	34240 - 11905: 0xCB70,
	34241 - 11905: 0xDEBB,
	34242 - 11905: 0xCB71,
	34243 - 11905: 0xCB72,
	34244 - 11905: 0xCB73,
	34245 - 11905: 0xCB74,
	34246 - 11905: 0xCB75,
	34247 - 11905: 0xCB76,
	34248 - 11905: 0xCB77,
	34249 - 11905: 0xBDE5,
	34250 - 11905: 0xCB78,
	34251 - 11905: 0xCB79,
	34252 - 11905: 0xCB7A,
	34253 - 11905: 0xCB7B,
	34254 - 11905: 0xCB7C,
	34255 - 11905: 0xB2D8,
	34256 - 11905: 0xC3EA,
	34257 - 11905: 0xCB7D,
	34258 - 11905: 0xCB7E,
	34259 - 11905: 0xDEBA,
	34260 - 11905: 0xCB80,
	34261 - 11905: 0xC5BA,
	34262 - 11905: 0xCB81,
	34263 - 11905: 0xCB82,
	34264 - 11905: 0xCB83,
	34265 - 11905: 0xCB84,
	34266 - 11905: 0xCB85,
	34267 - 11905: 0xCB86,
	34268 - 11905: 0xDEBC,
	34269 - 11905: 0xCB87,
	34270 - 11905: 0xCB88,
	34271 - 11905: 0xCB89,
	34272 - 11905: 0xCB8A,
	34273 - 11905: 0xCB8B,
	34274 - 11905: 0xCB8C,
	34275 - 11905: 0xCB8D,
	34276 - 11905: 0xCCD9,
	34277 - 11905: 0xCB8E,
	34278 - 11905: 0xCB8F,
	34279 - 11905: 0xCB90,
	34280 - 11905: 0xCB91,
	34281 - 11905: 0xB7AA,
	34282 - 11905: 0xCB92,
	34283 - 11905: 0xCB93,
	34284 - 11905: 0xCB94,
	34285 - 11905: 0xCB95,
	34286 - 11905: 0xCB96,
	34287 - 11905: 0xCB97,
	34288 - 11905: 0xCB98,
	34289 - 11905: 0xCB99,
	34290 - 11905: 0xCB9A,
	34291 - 11905: 0xCB9B,
	34292 - 11905: 0xCB9C,
	34293 - 11905: 0xCB9D,
	34294 - 11905: 0xCB9E,
	34295 - 11905: 0xCB9F,
	34296 - 11905: 0xCBA0,
	34297 - 11905: 0xCC40,
	34298 - 11905: 0xCC41,
	34299 - 11905: 0xD4E5,
	34300 - 11905: 0xCC42,
	34301 - 11905: 0xCC43,
	34302 - 11905: 0xCC44,
	34303 - 11905: 0xDEBD,
	34304 - 11905: 0xCC45,
	34305 - 11905: 0xCC46,
	34306 - 11905: 0xCC47,
	34307 - 11905: 0xCC48,
	34308 - 11905: 0xCC49,
	34309 - 11905: 0xDEBF,
	34310 - 11905: 0xCC4A,
	34311 - 11905: 0xCC4B,
	34312 - 11905: 0xCC4C,
	34313 - 11905: 0xCC4D,
	34314 - 11905: 0xCC4E,
	34315 - 11905: 0xCC4F,
	34316 - 11905: 0xCC50,
	34317 - 11905: 0xCC51,
	34318 - 11905: 0xCC52,
	34319 - 11905: 0xCC53,
	34320 - 11905: 0xCC54,
	34321 - 11905: 0xC4A2,
	34322 - 11905: 0xCC55,
	34323 - 11905: 0xCC56,
	34324 - 11905: 0xCC57,
	34325 - 11905: 0xCC58,
	34326 - 11905: 0xDEC1,
	34327 - 11905: 0xCC59,
	34328 - 11905: 0xCC5A,
	34329 - 11905: 0xCC5B,
	34330 - 11905: 0xCC5C,
	34331 - 11905: 0xCC5D,
	34332 - 11905: 0xCC5E,
	34333 - 11905: 0xCC5F,
	34334 - 11905: 0xCC60,
	34335 - 11905: 0xCC61,
	34336 - 11905: 0xCC62,
	34337 - 11905: 0xCC63,
	34338 - 11905: 0xCC64,
	34339 - 11905: 0xCC65,
	34340 - 11905: 0xCC66,
	34341 - 11905: 0xCC67,
	34342 - 11905: 0xCC68,
	34343 - 11905: 0xDEBE,
	34344 - 11905: 0xCC69,
	34345 - 11905: 0xDEC0,
	34346 - 11905: 0xCC6A,
	34347 - 11905: 0xCC6B,
	34348 - 11905: 0xCC6C,
	34349 - 11905: 0xCC6D,
	34350 - 11905: 0xCC6E,
	34351 - 11905: 0xCC6F,
	34352 - 11905: 0xCC70,
	34353 - 11905: 0xCC71,
	34354 - 11905: 0xCC72,
	34355 - 11905: 0xCC73,
	34356 - 11905: 0xCC74,
	34357 - 11905: 0xCC75,
	34358 - 11905: 0xCC76,
	34359 - 11905: 0xCC77,
	34360 - 11905: 0xD5BA,
	34361 - 11905: 0xCC78,
	34362 - 11905: 0xCC79,
	34363 - 11905: 0xCC7A,
	34364 - 11905: 0xDEC2,
	34365 - 11905: 0xCC7B,
	34366 - 11905: 0xCC7C,
	34367 - 11905: 0xCC7D,
	34368 - 11905: 0xCC7E,
	34369 - 11905: 0xCC80,
	34370 - 11905: 0xCC81,
	34371 - 11905: 0xCC82,
	34372 - 11905: 0xCC83,
	34373 - 11905: 0xCC84,
	34374 - 11905: 0xCC85,
	34375 - 11905: 0xCC86,
	34376 - 11905: 0xCC87,
	34377 - 11905: 0xCC88,
	34378 - 11905: 0xCC89,
	34379 - 11905: 0xCC8A,
	34380 - 11905: 0xCC8B,
	34381 - 11905: 0xF2AE,
	34382 - 11905: 0xBBA2,
	34383 - 11905: 0xC2B2,
	34384 - 11905: 0xC5B0,
	34385 - 11905: 0xC2C7,
	34386 - 11905: 0xCC8C,
	34387 - 11905: 0xCC8D,
	34388 - 11905: 0xF2AF,
	34389 - 11905: 0xCC8E,
	34390 - 11905: 0xCC8F,
	34391 - 11905: 0xCC90,
	34392 - 11905: 0xCC91,
	34393 - 11905: 0xCC92,
	34394 - 11905: 0xD0E9,
	34395 - 11905: 0xCC93,
	34396 - 11905: 0xCC94,
	34397 - 11905: 0xCC95,
	34398 - 11905: 0xD3DD,
	34399 - 11905: 0xCC96,
	34400 - 11905: 0xCC97,
	34401 - 11905: 0xCC98,
	34402 - 11905: 0xEBBD,
	34403 - 11905: 0xCC99,
	34404 - 11905: 0xCC9A,
	34405 - 11905: 0xCC9B,
	34406 - 11905: 0xCC9C,
	34407 - 11905: 0xCC9D,
	34408 - 11905: 0xCC9E,
	34409 - 11905: 0xCC9F,
	34410 - 11905: 0xCCA0,
	34411 - 11905: 0xB3E6,
	34412 - 11905: 0xF2B0,
	34413 - 11905: 0xCD40,
	34414 - 11905: 0xF2B1,
	34415 - 11905: 0xCD41,
	34416 - 11905: 0xCD42,
	34417 - 11905: 0xCAAD,
	34418 - 11905: 0xCD43,
	34419 - 11905: 0xCD44,
	34420 - 11905: 0xCD45,
	34421 - 11905: 0xCD46,
	34422 - 11905: 0xCD47,
	34423 - 11905: 0xCD48,
	34424 - 11905: 0xCD49,
	34425 - 11905: 0xBAE7,
	34426 - 11905: 0xF2B3,
	34427 - 11905: 0xF2B5,
	34428 - 11905: 0xF2B4,
	34429 - 11905: 0xCBE4,
	34430 - 11905: 0xCFBA,
	34431 - 11905: 0xF2B2,
	34432 - 11905: 0xCAB4,
	34433 - 11905: 0xD2CF,
	34434 - 11905: 0xC2EC,
	34435 - 11905: 0xCD4A,
	34436 - 11905: 0xCD4B,
	34437 - 11905: 0xCD4C,
	34438 - 11905: 0xCD4D,
	34439 - 11905: 0xCD4E,
	34440 - 11905: 0xCD4F,
	34441 - 11905: 0xCD50,
	34442 - 11905: 0xCEC3,
	34443 - 11905: 0xF2B8,
	34444 - 11905: 0xB0F6,
	34445 - 11905: 0xF2B7,
	34446 - 11905: 0xCD51,
	34447 - 11905: 0xCD52,
	34448 - 11905: 0xCD53,
	34449 - 11905: 0xCD54,
	34450 - 11905: 0xCD55,
	34451 - 11905: 0xF2BE,
	34452 - 11905: 0xCD56,
	34453 - 11905: 0xB2CF,
	34454 - 11905: 0xCD57,
	34455 - 11905: 0xCD58,
	34456 - 11905: 0xCD59,
	34457 - 11905: 0xCD5A,
	34458 - 11905: 0xCD5B,
	34459 - 11905: 0xCD5C,
	34460 - 11905: 0xD1C1,
	34461 - 11905: 0xF2BA,
	34462 - 11905: 0xCD5D,
	34463 - 11905: 0xCD5E,
	34464 - 11905: 0xCD5F,
	34465 - 11905: 0xCD60,
	34466 - 11905: 0xCD61,
	34467 - 11905: 0xF2BC,
	34468 - 11905: 0xD4E9,
	34469 - 11905: 0xCD62,
	34470 - 11905: 0xCD63,
	34471 - 11905: 0xF2BB,
	34472 - 11905: 0xF2B6,
	34473 - 11905: 0xF2BF,
	34474 - 11905: 0xF2BD,
	34475 - 11905: 0xCD64,
	34476 - 11905: 0xF2B9,
	34477 - 11905: 0xCD65,
	34478 - 11905: 0xCD66,
	34479 - 11905: 0xF2C7,
	34480 - 11905: 0xF2C4,
	34481 - 11905: 0xF2C6,
	34482 - 11905: 0xCD67,
	34483 - 11905: 0xCD68,
	34484 - 11905: 0xF2CA,
	34485 - 11905: 0xF2C2,
	34486 - 11905: 0xF2C0,
	34487 - 11905: 0xCD69,
	34488 - 11905: 0xCD6A,
	34489 - 11905: 0xCD6B,
	34490 - 11905: 0xF2C5,
	34491 - 11905: 0xCD6C,
	34492 - 11905: 0xCD6D,
	34493 - 11905: 0xCD6E,
	34494 - 11905: 0xCD6F,
	34495 - 11905: 0xCD70,
	34496 - 11905: 0xD6FB,
	34497 - 11905: 0xCD71,
	34498 - 11905: 0xCD72,
	34499 - 11905: 0xCD73,
	34500 - 11905: 0xF2C1,
	34501 - 11905: 0xCD74,
	34502 - 11905: 0xC7F9,
	34503 - 11905: 0xC9DF,
	34504 - 11905: 0xCD75,
	34505 - 11905: 0xF2C8,
	34506 - 11905: 0xB9C6,
	34507 - 11905: 0xB5B0,
	34508 - 11905: 0xCD76,
	34509 - 11905: 0xCD77,
	34510 - 11905: 0xF2C3,
	34511 - 11905: 0xF2C9,
	34512 - 11905: 0xF2D0,
	34513 - 11905: 0xF2D6,
	34514 - 11905: 0xCD78,
	34515 - 11905: 0xCD79,
	34516 - 11905: 0xBBD7,
	34517 - 11905: 0xCD7A,
	34518 - 11905: 0xCD7B,
	34519 - 11905: 0xCD7C,
	34520 - 11905: 0xF2D5,
	34521 - 11905: 0xCDDC,
	34522 - 11905: 0xCD7D,
	34523 - 11905: 0xD6EB,
	34524 - 11905: 0xCD7E,
	34525 - 11905: 0xCD80,
	34526 - 11905: 0xF2D2,
	34527 - 11905: 0xF2D4,
	34528 - 11905: 0xCD81,
	34529 - 11905: 0xCD82,
	34530 - 11905: 0xCD83,
	34531 - 11905: 0xCD84,
	34532 - 11905: 0xB8F2,
	34533 - 11905: 0xCD85,
	34534 - 11905: 0xCD86,
	34535 - 11905: 0xCD87,
	34536 - 11905: 0xCD88,
	34537 - 11905: 0xF2CB,
	34538 - 11905: 0xCD89,
	34539 - 11905: 0xCD8A,
	34540 - 11905: 0xCD8B,
	34541 - 11905: 0xF2CE,
	34542 - 11905: 0xC2F9,
	34543 - 11905: 0xCD8C,
	34544 - 11905: 0xD5DD,
	34545 - 11905: 0xF2CC,
	34546 - 11905: 0xF2CD,
	34547 - 11905: 0xF2CF,
	34548 - 11905: 0xF2D3,
	34549 - 11905: 0xCD8D,
	34550 - 11905: 0xCD8E,
	34551 - 11905: 0xCD8F,
	34552 - 11905: 0xF2D9,
	34553 - 11905: 0xD3BC,
	34554 - 11905: 0xCD90,
	34555 - 11905: 0xCD91,
	34556 - 11905: 0xCD92,
	34557 - 11905: 0xCD93,
	34558 - 11905: 0xB6EA,
	34559 - 11905: 0xCD94,
	34560 - 11905: 0xCAF1,
	34561 - 11905: 0xCD95,
	34562 - 11905: 0xB7E4,
	34563 - 11905: 0xF2D7,
	34564 - 11905: 0xCD96,
	34565 - 11905: 0xCD97,
	34566 - 11905: 0xCD98,
	34567 - 11905: 0xF2D8,
	34568 - 11905: 0xF2DA,
	34569 - 11905: 0xF2DD,
	34570 - 11905: 0xF2DB,
	34571 - 11905: 0xCD99,
	34572 - 11905: 0xCD9A,
	34573 - 11905: 0xF2DC,
	34574 - 11905: 0xCD9B,
	34575 - 11905: 0xCD9C,
	34576 - 11905: 0xCD9D,
	34577 - 11905: 0xCD9E,
	34578 - 11905: 0xD1D1,
	34579 - 11905: 0xF2D1,
	34580 - 11905: 0xCD9F,
	34581 - 11905: 0xCDC9,
	34582 - 11905: 0xCDA0,
	34583 - 11905: 0xCECF,
	34584 - 11905: 0xD6A9,
	34585 - 11905: 0xCE40,
	34586 - 11905: 0xF2E3,
	34587 - 11905: 0xCE41,
	34588 - 11905: 0xC3DB,
	34589 - 11905: 0xCE42,
	34590 - 11905: 0xF2E0,
	34591 - 11905: 0xCE43,
	34592 - 11905: 0xCE44,
	34593 - 11905: 0xC0AF,
	34594 - 11905: 0xF2EC,
	34595 - 11905: 0xF2DE,
	34596 - 11905: 0xCE45,
	34597 - 11905: 0xF2E1,
	34598 - 11905: 0xCE46,
	34599 - 11905: 0xCE47,
	34600 - 11905: 0xCE48,
	34601 - 11905: 0xF2E8,
	34602 - 11905: 0xCE49,
	34603 - 11905: 0xCE4A,
	34604 - 11905: 0xCE4B,
	34605 - 11905: 0xCE4C,
	34606 - 11905: 0xF2E2,
	34607 - 11905: 0xCE4D,
	34608 - 11905: 0xCE4E,
	34609 - 11905: 0xF2E7,
	34610 - 11905: 0xCE4F,
	34611 - 11905: 0xCE50,
	34612 - 11905: 0xF2E6,
	34613 - 11905: 0xCE51,
	34614 - 11905: 0xCE52,
	34615 - 11905: 0xF2E9,
	34616 - 11905: 0xCE53,
	34617 - 11905: 0xCE54,
	34618 - 11905: 0xCE55,
	34619 - 11905: 0xF2DF,
	34620 - 11905: 0xCE56,
	34621 - 11905: 0xCE57,
	34622 - 11905: 0xF2E4,
	34623 - 11905: 0xF2EA,
	34624 - 11905: 0xCE58,
	34625 - 11905: 0xCE59,
	34626 - 11905: 0xCE5A,
	34627 - 11905: 0xCE5B,
	34628 - 11905: 0xCE5C,
	34629 - 11905: 0xCE5D,
	34630 - 11905: 0xCE5E,
	34631 - 11905: 0xD3AC,
	34632 - 11905: 0xF2E5,
	34633 - 11905: 0xB2F5,
	34634 - 11905: 0xCE5F,
	34635 - 11905: 0xCE60,
	34636 - 11905: 0xF2F2,
	34637 - 11905: 0xCE61,
	34638 - 11905: 0xD0AB,
	34639 - 11905: 0xCE62,
	34640 - 11905: 0xCE63,
	34641 - 11905: 0xCE64,
	34642 - 11905: 0xCE65,
	34643 - 11905: 0xF2F5,
	34644 - 11905: 0xCE66,
	34645 - 11905: 0xCE67,
	34646 - 11905: 0xCE68,
	34647 - 11905: 0xBBC8,
	34648 - 11905: 0xCE69,
	34649 - 11905: 0xF2F9,
	34650 - 11905: 0xCE6A,
	34651 - 11905: 0xCE6B,
	34652 - 11905: 0xCE6C,
	34653 - 11905: 0xCE6D,
	34654 - 11905: 0xCE6E,
	34655 - 11905: 0xCE6F,
	34656 - 11905: 0xF2F0,
	34657 - 11905: 0xCE70,
	34658 - 11905: 0xCE71,
	34659 - 11905: 0xF2F6,
	34660 - 11905: 0xF2F8,
	34661 - 11905: 0xF2FA,
	34662 - 11905: 0xCE72,
	34663 - 11905: 0xCE73,
	34664 - 11905: 0xCE74,
	34665 - 11905: 0xCE75,
	34666 - 11905: 0xCE76,
	34667 - 11905: 0xCE77,
	34668 - 11905: 0xCE78,
	34669 - 11905: 0xCE79,
	34670 - 11905: 0xF2F3,
	34671 - 11905: 0xCE7A,
	34672 - 11905: 0xF2F1,
	34673 - 11905: 0xCE7B,
	34674 - 11905: 0xCE7C,
	34675 - 11905: 0xCE7D,
	34676 - 11905: 0xBAFB,
	34677 - 11905: 0xCE7E,
	34678 - 11905: 0xB5FB,
	34679 - 11905: 0xCE80,
	34680 - 11905: 0xCE81,
	34681 - 11905: 0xCE82,
	34682 - 11905: 0xCE83,
	34683 - 11905: 0xF2EF,
	34684 - 11905: 0xF2F7,
	34685 - 11905: 0xF2ED,
	34686 - 11905: 0xF2EE,
	34687 - 11905: 0xCE84,
	34688 - 11905: 0xCE85,
	34689 - 11905: 0xCE86,
	34690 - 11905: 0xF2EB,
	34691 - 11905: 0xF3A6,
	34692 - 11905: 0xCE87,
	34693 - 11905: 0xF3A3,
	34694 - 11905: 0xCE88,
	34695 - 11905: 0xCE89,
	34696 - 11905: 0xF3A2,
	34697 - 11905: 0xCE8A,
	34698 - 11905: 0xCE8B,
	34699 - 11905: 0xF2F4,
	34700 - 11905: 0xCE8C,
	34701 - 11905: 0xC8DA,
	34702 - 11905: 0xCE8D,
	34703 - 11905: 0xCE8E,
	34704 - 11905: 0xCE8F,
	34705 - 11905: 0xCE90,
	34706 - 11905: 0xCE91,
	34707 - 11905: 0xF2FB,
	34708 - 11905: 0xCE92,
	34709 - 11905: 0xCE93,
	34710 - 11905: 0xCE94,
	34711 - 11905: 0xF3A5,
	34712 - 11905: 0xCE95,
	34713 - 11905: 0xCE96,
	34714 - 11905: 0xCE97,
	34715 - 11905: 0xCE98,
	34716 - 11905: 0xCE99,
	34717 - 11905: 0xCE9A,
	34718 - 11905: 0xCE9B,
	34719 - 11905: 0xC3F8,
	34720 - 11905: 0xCE9C,
	34721 - 11905: 0xCE9D,
	34722 - 11905: 0xCE9E,
	34723 - 11905: 0xCE9F,
	34724 - 11905: 0xCEA0,
	34725 - 11905: 0xCF40,
	34726 - 11905: 0xCF41,
	34727 - 11905: 0xCF42,
	34728 - 11905: 0xF2FD,
	34729 - 11905: 0xCF43,
	34730 - 11905: 0xCF44,
	34731 - 11905: 0xF3A7,
	34732 - 11905: 0xF3A9,
	34733 - 11905: 0xF3A4,
	34734 - 11905: 0xCF45,
	34735 - 11905: 0xF2FC,
	34736 - 11905: 0xCF46,
	34737 - 11905: 0xCF47,
	34738 - 11905: 0xCF48,
	34739 - 11905: 0xF3AB,
	34740 - 11905: 0xCF49,
	34741 - 11905: 0xF3AA,
	34742 - 11905: 0xCF4A,
	34743 - 11905: 0xCF4B,
	34744 - 11905: 0xCF4C,
	34745 - 11905: 0xCF4D,
	34746 - 11905: 0xC2DD,
	34747 - 11905: 0xCF4E,
	34748 - 11905: 0xCF4F,
	34749 - 11905: 0xF3AE,
	34750 - 11905: 0xCF50,
	34751 - 11905: 0xCF51,
	34752 - 11905: 0xF3B0,
	34753 - 11905: 0xCF52,
	34754 - 11905: 0xCF53,
	34755 - 11905: 0xCF54,
	34756 - 11905: 0xCF55,
	34757 - 11905: 0xCF56,
	34758 - 11905: 0xF3A1,
	34759 - 11905: 0xCF57,
	34760 - 11905: 0xCF58,
	34761 - 11905: 0xCF59,
	34762 - 11905: 0xF3B1,
	34763 - 11905: 0xF3AC,
	34764 - 11905: 0xCF5A,
	34765 - 11905: 0xCF5B,
	34766 - 11905: 0xCF5C,
	34767 - 11905: 0xCF5D,
	34768 - 11905: 0xCF5E,
	34769 - 11905: 0xF3AF,
	34770 - 11905: 0xF2FE,
	34771 - 11905: 0xF3AD,
	34772 - 11905: 0xCF5F,
	34773 - 11905: 0xCF60,
	34774 - 11905: 0xCF61,
	34775 - 11905: 0xCF62,
	34776 - 11905: 0xCF63,
	34777 - 11905: 0xCF64,
	34778 - 11905: 0xCF65,
	34779 - 11905: 0xF3B2,
	34780 - 11905: 0xCF66,
	34781 - 11905: 0xCF67,
	34782 - 11905: 0xCF68,
	34783 - 11905: 0xCF69,
	34784 - 11905: 0xF3B4,
	34785 - 11905: 0xCF6A,
	34786 - 11905: 0xCF6B,
	34787 - 11905: 0xCF6C,
	34788 - 11905: 0xCF6D,
	34789 - 11905: 0xF3A8,
	34790 - 11905: 0xCF6E,
	34791 - 11905: 0xCF6F,
	34792 - 11905: 0xCF70,
	34793 - 11905: 0xCF71,
	34794 - 11905: 0xF3B3,
	34795 - 11905: 0xCF72,
	34796 - 11905: 0xCF73,
	34797 - 11905: 0xCF74,
	34798 - 11905: 0xF3B5,
	34799 - 11905: 0xCF75,
	34800 - 11905: 0xCF76,
	34801 - 11905: 0xCF77,
	34802 - 11905: 0xCF78,
	34803 - 11905: 0xCF79,
	34804 - 11905: 0xCF7A,
	34805 - 11905: 0xCF7B,
	34806 - 11905: 0xCF7C,
	34807 - 11905: 0xCF7D,
	34808 - 11905: 0xCF7E,
	34809 - 11905: 0xD0B7,
	34810 - 11905: 0xCF80,
	34811 - 11905: 0xCF81,
	34812 - 11905: 0xCF82,
	34813 - 11905: 0xCF83,
	34814 - 11905: 0xF3B8,
	34815 - 11905: 0xCF84,
	34816 - 11905: 0xCF85,
	34817 - 11905: 0xCF86,
	34818 - 11905: 0xCF87,
	34819 - 11905: 0xD9F9,
	34820 - 11905: 0xCF88,
	34821 - 11905: 0xCF89,
	34822 - 11905: 0xCF8A,
	34823 - 11905: 0xCF8B,
	34824 - 11905: 0xCF8C,
	34825 - 11905: 0xCF8D,
	34826 - 11905: 0xF3B9,
	34827 - 11905: 0xCF8E,
	34828 - 11905: 0xCF8F,
	34829 - 11905: 0xCF90,
	34830 - 11905: 0xCF91,
	34831 - 11905: 0xCF92,
	34832 - 11905: 0xCF93,
	34833 - 11905: 0xCF94,
	34834 - 11905: 0xCF95,
	34835 - 11905: 0xF3B7,
	34836 - 11905: 0xCF96,
	34837 - 11905: 0xC8E4,
	34838 - 11905: 0xF3B6,
	34839 - 11905: 0xCF97,
	34840 - 11905: 0xCF98,
	34841 - 11905: 0xCF99,
	34842 - 11905: 0xCF9A,
	34843 - 11905: 0xF3BA,
	34844 - 11905: 0xCF9B,
	34845 - 11905: 0xCF9C,
	34846 - 11905: 0xCF9D,
	34847 - 11905: 0xCF9E,
	34848 - 11905: 0xCF9F,
	34849 - 11905: 0xF3BB,
	34850 - 11905: 0xB4C0,
	34851 - 11905: 0xCFA0,
	34852 - 11905: 0xD040,
	34853 - 11905: 0xD041,
	34854 - 11905: 0xD042,
	34855 - 11905: 0xD043,
	34856 - 11905: 0xD044,
	34857 - 11905: 0xD045,
	34858 - 11905: 0xD046,
	34859 - 11905: 0xD047,
	34860 - 11905: 0xD048,
	34861 - 11905: 0xD049,
	34862 - 11905: 0xD04A,
	34863 - 11905: 0xD04B,
	34864 - 11905: 0xD04C,
	34865 - 11905: 0xD04D,
	34866 - 11905: 0xEEC3,
	34867 - 11905: 0xD04E,
	34868 - 11905: 0xD04F,
	34869 - 11905: 0xD050,
	34870 - 11905: 0xD051,
	34871 - 11905: 0xD052,
	34872 - 11905: 0xD053,
	34873 - 11905: 0xF3BC,
	34874 - 11905: 0xD054,
	34875 - 11905: 0xD055,
	34876 - 11905: 0xF3BD,
	34877 - 11905: 0xD056,
	34878 - 11905: 0xD057,
	34879 - 11905: 0xD058,
	34880 - 11905: 0xD1AA,
	34881 - 11905: 0xD059,
	34882 - 11905: 0xD05A,
	34883 - 11905: 0xD05B,
	34884 - 11905: 0xF4AC,
	34885 - 11905: 0xD0C6,
	34886 - 11905: 0xD05C,
	34887 - 11905: 0xD05D,
	34888 - 11905: 0xD05E,
	34889 - 11905: 0xD05F,
	34890 - 11905: 0xD060,
	34891 - 11905: 0xD061,
	34892 - 11905: 0xD0D0,
	34893 - 11905: 0xD1DC,
	34894 - 11905: 0xD062,
	34895 - 11905: 0xD063,
	34896 - 11905: 0xD064,
	34897 - 11905: 0xD065,
	34898 - 11905: 0xD066,
	34899 - 11905: 0xD067,
	34900 - 11905: 0xCFCE,
	34901 - 11905: 0xD068,
	34902 - 11905: 0xD069,
	34903 - 11905: 0xBDD6,
	34904 - 11905: 0xD06A,
	34905 - 11905: 0xD1C3,
	34906 - 11905: 0xD06B,
	34907 - 11905: 0xD06C,
	34908 - 11905: 0xD06D,
	34909 - 11905: 0xD06E,
	34910 - 11905: 0xD06F,
	34911 - 11905: 0xD070,
	34912 - 11905: 0xD071,
	34913 - 11905: 0xBAE2,
	34914 - 11905: 0xE1E9,
	34915 - 11905: 0xD2C2,
	34916 - 11905: 0xF1C2,
	34917 - 11905: 0xB2B9,
	34918 - 11905: 0xD072,
	34919 - 11905: 0xD073,
	34920 - 11905: 0xB1ED,
	34921 - 11905: 0xF1C3,
	34922 - 11905: 0xD074,
	34923 - 11905: 0xC9C0,
	34924 - 11905: 0xB3C4,
	34925 - 11905: 0xD075,
	34926 - 11905: 0xD9F2,
	34927 - 11905: 0xD076,
	34928 - 11905: 0xCBA5,
	34929 - 11905: 0xD077,
	34930 - 11905: 0xF1C4,
	34931 - 11905: 0xD078,
	34932 - 11905: 0xD079,
	34933 - 11905: 0xD07A,
	34934 - 11905: 0xD07B,
	34935 - 11905: 0xD6D4,
	34936 - 11905: 0xD07C,
	34937 - 11905: 0xD07D,
	34938 - 11905: 0xD07E,
	34939 - 11905: 0xD080,
	34940 - 11905: 0xD081,
	34941 - 11905: 0xF1C5,
	34942 - 11905: 0xF4C0,
	34943 - 11905: 0xF1C6,
	34944 - 11905: 0xD082,
	34945 - 11905: 0xD4AC,
	34946 - 11905: 0xF1C7,
	34947 - 11905: 0xD083,
	34948 - 11905: 0xB0C0,
	34949 - 11905: 0xF4C1,
	34950 - 11905: 0xD084,
	34951 - 11905: 0xD085,
	34952 - 11905: 0xF4C2,
	34953 - 11905: 0xD086,
	34954 - 11905: 0xD087,
	34955 - 11905: 0xB4FC,
	34956 - 11905: 0xD088,
	34957 - 11905: 0xC5DB,
	34958 - 11905: 0xD089,
	34959 - 11905: 0xD08A,
	34960 - 11905: 0xD08B,
	34961 - 11905: 0xD08C,
	34962 - 11905: 0xCCBB,
	34963 - 11905: 0xD08D,
	34964 - 11905: 0xD08E,
	34965 - 11905: 0xD08F,
	34966 - 11905: 0xD0E4,
	34967 - 11905: 0xD090,
	34968 - 11905: 0xD091,
	34969 - 11905: 0xD092,
	34970 - 11905: 0xD093,
	34971 - 11905: 0xD094,
	34972 - 11905: 0xCDE0,
	34973 - 11905: 0xD095,
	34974 - 11905: 0xD096,
	34975 - 11905: 0xD097,
	34976 - 11905: 0xD098,
	34977 - 11905: 0xD099,
	34978 - 11905: 0xF1C8,
	34979 - 11905: 0xD09A,
	34980 - 11905: 0xD9F3,
	34981 - 11905: 0xD09B,
	34982 - 11905: 0xD09C,
	34983 - 11905: 0xD09D,
	34984 - 11905: 0xD09E,
	34985 - 11905: 0xD09F,
	34986 - 11905: 0xD0A0,
	34987 - 11905: 0xB1BB,
	34988 - 11905: 0xD140,
	34989 - 11905: 0xCFAE,
	34990 - 11905: 0xD141,
	34991 - 11905: 0xD142,
	34992 - 11905: 0xD143,
	34993 - 11905: 0xB8A4,
	34994 - 11905: 0xD144,
	34995 - 11905: 0xD145,
	34996 - 11905: 0xD146,
	34997 - 11905: 0xD147,
	34998 - 11905: 0xD148,
	34999 - 11905: 0xF1CA,
	35000 - 11905: 0xD149,
	35001 - 11905: 0xD14A,
	35002 - 11905: 0xD14B,
	35003 - 11905: 0xD14C,
	35004 - 11905: 0xF1CB,
	35005 - 11905: 0xD14D,
	35006 - 11905: 0xD14E,
	35007 - 11905: 0xD14F,
	35008 - 11905: 0xD150,
	35009 - 11905: 0xB2C3,
	35010 - 11905: 0xC1D1,
	35011 - 11905: 0xD151,
	35012 - 11905: 0xD152,
	35013 - 11905: 0xD7B0,
	35014 - 11905: 0xF1C9,
	35015 - 11905: 0xD153,
	35016 - 11905: 0xD154,
	35017 - 11905: 0xF1CC,
	35018 - 11905: 0xD155,
	35019 - 11905: 0xD156,
	35020 - 11905: 0xD157,
	35021 - 11905: 0xD158,
	35022 - 11905: 0xF1CE,
	35023 - 11905: 0xD159,
	35024 - 11905: 0xD15A,
	35025 - 11905: 0xD15B,
	35026 - 11905: 0xD9F6,
	35027 - 11905: 0xD15C,
	35028 - 11905: 0xD2E1,
	35029 - 11905: 0xD4A3,
	35030 - 11905: 0xD15D,
	35031 - 11905: 0xD15E,
	35032 - 11905: 0xF4C3,
	35033 - 11905: 0xC8B9,
	35034 - 11905: 0xD15F,
	35035 - 11905: 0xD160,
	35036 - 11905: 0xD161,
	35037 - 11905: 0xD162,
	35038 - 11905: 0xD163,
	35039 - 11905: 0xF4C4,
	35040 - 11905: 0xD164,
	35041 - 11905: 0xD165,
	35042 - 11905: 0xF1CD,
	35043 - 11905: 0xF1CF,
	35044 - 11905: 0xBFE3,
	35045 - 11905: 0xF1D0,
	35046 - 11905: 0xD166,
	35047 - 11905: 0xD167,
	35048 - 11905: 0xF1D4,
	35049 - 11905: 0xD168,
	35050 - 11905: 0xD169,
	35051 - 11905: 0xD16A,
	35052 - 11905: 0xD16B,
	35053 - 11905: 0xD16C,
	35054 - 11905: 0xD16D,
	35055 - 11905: 0xD16E,
	35056 - 11905: 0xF1D6,
	35057 - 11905: 0xF1D1,
	35058 - 11905: 0xD16F,
	35059 - 11905: 0xC9D1,
	35060 - 11905: 0xC5E1,
	35061 - 11905: 0xD170,
	35062 - 11905: 0xD171,
	35063 - 11905: 0xD172,
	35064 - 11905: 0xC2E3,
	35065 - 11905: 0xB9FC,
	35066 - 11905: 0xD173,
	35067 - 11905: 0xD174,
	35068 - 11905: 0xF1D3,
	35069 - 11905: 0xD175,
	35070 - 11905: 0xF1D5,
	35071 - 11905: 0xD176,
	35072 - 11905: 0xD177,
	35073 - 11905: 0xD178,
	35074 - 11905: 0xB9D3,
	35075 - 11905: 0xD179,
	35076 - 11905: 0xD17A,
	35077 - 11905: 0xD17B,
	35078 - 11905: 0xD17C,
	35079 - 11905: 0xD17D,
	35080 - 11905: 0xD17E,
	35081 - 11905: 0xD180,
	35082 - 11905: 0xF1DB,
	35083 - 11905: 0xD181,
	35084 - 11905: 0xD182,
	35085 - 11905: 0xD183,
	35086 - 11905: 0xD184,
	35087 - 11905: 0xD185,
	35088 - 11905: 0xBAD6,
	35089 - 11905: 0xD186,
	35090 - 11905: 0xB0FD,
	35091 - 11905: 0xF1D9,
	35092 - 11905: 0xD187,
	35093 - 11905: 0xD188,
	35094 - 11905: 0xD189,
	35095 - 11905: 0xD18A,
	35096 - 11905: 0xD18B,
	35097 - 11905: 0xF1D8,
	35098 - 11905: 0xF1D2,
	35099 - 11905: 0xF1DA,
	35100 - 11905: 0xD18C,
	35101 - 11905: 0xD18D,
	35102 - 11905: 0xD18E,
	35103 - 11905: 0xD18F,
	35104 - 11905: 0xD190,
	35105 - 11905: 0xF1D7,
	35106 - 11905: 0xD191,
	35107 - 11905: 0xD192,
	35108 - 11905: 0xD193,
	35109 - 11905: 0xC8EC,
	35110 - 11905: 0xD194,
	35111 - 11905: 0xD195,
	35112 - 11905: 0xD196,
	35113 - 11905: 0xD197,
	35114 - 11905: 0xCDCA,
	35115 - 11905: 0xF1DD,
	35116 - 11905: 0xD198,
	35117 - 11905: 0xD199,
	35118 - 11905: 0xD19A,
	35119 - 11905: 0xD19B,
	35120 - 11905: 0xE5BD,
	35121 - 11905: 0xD19C,
	35122 - 11905: 0xD19D,
	35123 - 11905: 0xD19E,
	35124 - 11905: 0xF1DC,
	35125 - 11905: 0xD19F,
	35126 - 11905: 0xF1DE,
	35127 - 11905: 0xD1A0,
	35128 - 11905: 0xD240,
	35129 - 11905: 0xD241,
	35130 - 11905: 0xD242,
	35131 - 11905: 0xD243,
	35132 - 11905: 0xD244,
	35133 - 11905: 0xD245,
	35134 - 11905: 0xD246,
	35135 - 11905: 0xD247,
	35136 - 11905: 0xD248,
	35137 - 11905: 0xF1DF,
	35138 - 11905: 0xD249,
	35139 - 11905: 0xD24A,
	35140 - 11905: 0xCFE5,
	35141 - 11905: 0xD24B,
	35142 - 11905: 0xD24C,
	35143 - 11905: 0xD24D,
	35144 - 11905: 0xD24E,
	35145 - 11905: 0xD24F,
	35146 - 11905: 0xD250,
	35147 - 11905: 0xD251,
	35148 - 11905: 0xD252,
	35149 - 11905: 0xD253,
	35150 - 11905: 0xD254,
	35151 - 11905: 0xD255,
	35152 - 11905: 0xD256,
	35153 - 11905: 0xD257,
	35154 - 11905: 0xD258,
	35155 - 11905: 0xD259,
	35156 - 11905: 0xD25A,
	35157 - 11905: 0xD25B,
	35158 - 11905: 0xD25C,
	35159 - 11905: 0xD25D,
	35160 - 11905: 0xD25E,
	35161 - 11905: 0xD25F,
	35162 - 11905: 0xD260,
	35163 - 11905: 0xD261,
	35164 - 11905: 0xD262,
	35165 - 11905: 0xD263,
	35166 - 11905: 0xF4C5,
	35167 - 11905: 0xBDF3,
	35168 - 11905: 0xD264,
	35169 - 11905: 0xD265,
	35170 - 11905: 0xD266,
	35171 - 11905: 0xD267,
	35172 - 11905: 0xD268,
	35173 - 11905: 0xD269,
	35174 - 11905: 0xF1E0,
	35175 - 11905: 0xD26A,
	35176 - 11905: 0xD26B,
	35177 - 11905: 0xD26C,
	35178 - 11905: 0xD26D,
	35179 - 11905: 0xD26E,
	35180 - 11905: 0xD26F,
	35181 - 11905: 0xD270,
	35182 - 11905: 0xD271,
	35183 - 11905: 0xD272,
	35184 - 11905: 0xD273,
	35185 - 11905: 0xD274,
	35186 - 11905: 0xD275,
	35187 - 11905: 0xD276,
	35188 - 11905: 0xD277,
	35189 - 11905: 0xD278,
	35190 - 11905: 0xD279,
	35191 - 11905: 0xD27A,
	35192 - 11905: 0xD27B,
	35193 - 11905: 0xD27C,
	35194 - 11905: 0xD27D,
	35195 - 11905: 0xF1E1,
	35196 - 11905: 0xD27E,
	35197 - 11905: 0xD280,
	35198 - 11905: 0xD281,
	35199 - 11905: 0xCEF7,
	35200 - 11905: 0xD282,
	35201 - 11905: 0xD2AA,
	35202 - 11905: 0xD283,
	35203 - 11905: 0xF1FB,
	35204 - 11905: 0xD284,
	35205 - 11905: 0xD285,
	35206 - 11905: 0xB8B2,
	35207 - 11905: 0xD286,
	35208 - 11905: 0xD287,
	35209 - 11905: 0xD288,
	35210 - 11905: 0xD289,
	35211 - 11905: 0xD28A,
	35212 - 11905: 0xD28B,
	35213 - 11905: 0xD28C,
	35214 - 11905: 0xD28D,
	35215 - 11905: 0xD28E,
	35216 - 11905: 0xD28F,
	35217 - 11905: 0xD290,
	35218 - 11905: 0xD291,
	35219 - 11905: 0xD292,
	35220 - 11905: 0xD293,
	35221 - 11905: 0xD294,
	35222 - 11905: 0xD295,
	35223 - 11905: 0xD296,
	35224 - 11905: 0xD297,
	35225 - 11905: 0xD298,
	35226 - 11905: 0xD299,
	35227 - 11905: 0xD29A,
	35228 - 11905: 0xD29B,
	35229 - 11905: 0xD29C,
	35230 - 11905: 0xD29D,
	35231 - 11905: 0xD29E,
	35232 - 11905: 0xD29F,
	35233 - 11905: 0xD2A0,
	35234 - 11905: 0xD340,
	35235 - 11905: 0xD341,
	35236 - 11905: 0xD342,
	35237 - 11905: 0xD343,
	35238 - 11905: 0xD344,
	35239 - 11905: 0xD345,
	35240 - 11905: 0xD346,
	35241 - 11905: 0xD347,
	35242 - 11905: 0xD348,
	35243 - 11905: 0xD349,
	35244 - 11905: 0xD34A,
	35245 - 11905: 0xD34B,
	35246 - 11905: 0xD34C,
	35247 - 11905: 0xD34D,
	35248 - 11905: 0xD34E,
	35249 - 11905: 0xD34F,
	35250 - 11905: 0xD350,
	35251 - 11905: 0xD351,
	35252 - 11905: 0xD352,
	35253 - 11905: 0xD353,
	35254 - 11905: 0xD354,
	35255 - 11905: 0xD355,
	35256 - 11905: 0xD356,
	35257 - 11905: 0xD357,
	35258 - 11905: 0xD358,
	35259 - 11905: 0xD359,
	35260 - 11905: 0xD35A,
	35261 - 11905: 0xD35B,
	35262 - 11905: 0xD35C,
	35263 - 11905: 0xD35D,
	35264 - 11905: 0xD35E,
	35265 - 11905: 0xBCFB,
	35266 - 11905: 0xB9DB,
	35267 - 11905: 0xD35F,
	35268 - 11905: 0xB9E6,
	35269 - 11905: 0xC3D9,
	35270 - 11905: 0xCAD3,
	35271 - 11905: 0xEAE8,
	35272 - 11905: 0xC0C0,
	35273 - 11905: 0xBEF5,
	35274 - 11905: 0xEAE9,
	35275 - 11905: 0xEAEA,
	35276 - 11905: 0xEAEB,
	35277 - 11905: 0xD360,
	35278 - 11905: 0xEAEC,
	35279 - 11905: 0xEAED,
	35280 - 11905: 0xEAEE,
	35281 - 11905: 0xEAEF,
	35282 - 11905: 0xBDC7,
	35283 - 11905: 0xD361,
	35284 - 11905: 0xD362,
	35285 - 11905: 0xD363,
	35286 - 11905: 0xF5FB,
	35287 - 11905: 0xD364,
	35288 - 11905: 0xD365,
	35289 - 11905: 0xD366,
	35290 - 11905: 0xF5FD,
	35291 - 11905: 0xD367,
	35292 - 11905: 0xF5FE,
	35293 - 11905: 0xD368,
	35294 - 11905: 0xF5FC,
	35295 - 11905: 0xD369,
	35296 - 11905: 0xD36A,
	35297 - 11905: 0xD36B,
	35298 - 11905: 0xD36C,
	35299 - 11905: 0xBDE2,
	35300 - 11905: 0xD36D,
	35301 - 11905: 0xF6A1,
	35302 - 11905: 0xB4A5,
	35303 - 11905: 0xD36E,
	35304 - 11905: 0xD36F,
	35305 - 11905: 0xD370,
	35306 - 11905: 0xD371,
	35307 - 11905: 0xF6A2,
	35308 - 11905: 0xD372,
	35309 - 11905: 0xD373,
	35310 - 11905: 0xD374,
	35311 - 11905: 0xF6A3,
	35312 - 11905: 0xD375,
	35313 - 11905: 0xD376,
	35314 - 11905: 0xD377,
	35315 - 11905: 0xECB2,
	35316 - 11905: 0xD378,
	35317 - 11905: 0xD379,
	35318 - 11905: 0xD37A,
	35319 - 11905: 0xD37B,
	35320 - 11905: 0xD37C,
	35321 - 11905: 0xD37D,
	35322 - 11905: 0xD37E,
	35323 - 11905: 0xD380,
	35324 - 11905: 0xD381,
	35325 - 11905: 0xD382,
	35326 - 11905: 0xD383,
	35327 - 11905: 0xD384,
	35328 - 11905: 0xD1D4,
	35329 - 11905: 0xD385,
	35330 - 11905: 0xD386,
	35331 - 11905: 0xD387,
	35332 - 11905: 0xD388,
	35333 - 11905: 0xD389,
	35334 - 11905: 0xD38A,
	35335 - 11905: 0xD9EA,
	35336 - 11905: 0xD38B,
	35337 - 11905: 0xD38C,
	35338 - 11905: 0xD38D,
	35339 - 11905: 0xD38E,
	35340 - 11905: 0xD38F,
	35341 - 11905: 0xD390,
	35342 - 11905: 0xD391,
	35343 - 11905: 0xD392,
	35344 - 11905: 0xD393,
	35345 - 11905: 0xD394,
	35346 - 11905: 0xD395,
	35347 - 11905: 0xD396,
	35348 - 11905: 0xD397,
	35349 - 11905: 0xD398,
	35350 - 11905: 0xD399,
	35351 - 11905: 0xD39A,
	35352 - 11905: 0xD39B,
	35353 - 11905: 0xD39C,
	35354 - 11905: 0xD39D,
	35355 - 11905: 0xD39E,
	35356 - 11905: 0xD39F,
	35357 - 11905: 0xD3A0,
	35358 - 11905: 0xD440,
	35359 - 11905: 0xD441,
	35360 - 11905: 0xD442,
	35361 - 11905: 0xD443,
	35362 - 11905: 0xD444,
	35363 - 11905: 0xD445,
	35364 - 11905: 0xD446,
	35365 - 11905: 0xD447,
	35366 - 11905: 0xD448,
	35367 - 11905: 0xD449,
	35368 - 11905: 0xD44A,
	35369 - 11905: 0xD44B,
	35370 - 11905: 0xD44C,
	35371 - 11905: 0xD44D,
	35372 - 11905: 0xD44E,
	35373 - 11905: 0xD44F,
	35374 - 11905: 0xD450,
	35375 - 11905: 0xD451,
	35376 - 11905: 0xD452,
	35377 - 11905: 0xD453,
	35378 - 11905: 0xD454,
	35379 - 11905: 0xD455,
	35380 - 11905: 0xD456,
	35381 - 11905: 0xD457,
	35382 - 11905: 0xD458,
	35383 - 11905: 0xD459,
	35384 - 11905: 0xD45A,
	35385 - 11905: 0xD45B,
	35386 - 11905: 0xD45C,
	35387 - 11905: 0xD45D,
	35388 - 11905: 0xD45E,
	35389 - 11905: 0xD45F,
	35390 - 11905: 0xF6A4,
	35391 - 11905: 0xD460,
	35392 - 11905: 0xD461,
	35393 - 11905: 0xD462,
	35394 - 11905: 0xD463,
	35395 - 11905: 0xD464,
	35396 - 11905: 0xD465,
	35397 - 11905: 0xD466,
	35398 - 11905: 0xD467,
	35399 - 11905: 0xD468,
	35400 - 11905: 0xEEBA,
	35401 - 11905: 0xD469,
	35402 - 11905: 0xD46A,
	35403 - 11905: 0xD46B,
	35404 - 11905: 0xD46C,
	35405 - 11905: 0xD46D,
	35406 - 11905: 0xD46E,
	35407 - 11905: 0xD46F,
	35408 - 11905: 0xD470,
	35409 - 11905: 0xD471,
	35410 - 11905: 0xD472,
	35411 - 11905: 0xD473,
	35412 - 11905: 0xD474,
	35413 - 11905: 0xD475,
	35414 - 11905: 0xD476,
	35415 - 11905: 0xD477,
	35416 - 11905: 0xD478,
	35417 - 11905: 0xD479,
	35418 - 11905: 0xD47A,
	35419 - 11905: 0xD47B,
	35420 - 11905: 0xD47C,
	35421 - 11905: 0xD47D,
	35422 - 11905: 0xD47E,
	35423 - 11905: 0xD480,
	35424 - 11905: 0xD481,
	35425 - 11905: 0xD482,
	35426 - 11905: 0xD483,
	35427 - 11905: 0xD484,
	35428 - 11905: 0xD485,
	35429 - 11905: 0xD486,
	35430 - 11905: 0xD487,
	35431 - 11905: 0xD488,
	35432 - 11905: 0xD489,
	35433 - 11905: 0xD48A,
	35434 - 11905: 0xD48B,
	35435 - 11905: 0xD48C,
	35436 - 11905: 0xD48D,
	35437 - 11905: 0xD48E,
	35438 - 11905: 0xD48F,
	35439 - 11905: 0xD490,
	35440 - 11905: 0xD491,
	35441 - 11905: 0xD492,
	35442 - 11905: 0xD493,
	35443 - 11905: 0xD494,
	35444 - 11905: 0xD495,
	35445 - 11905: 0xD496,
	35446 - 11905: 0xD497,
	35447 - 11905: 0xD498,
	35448 - 11905: 0xD499,
	35449 - 11905: 0xD5B2,
	35450 - 11905: 0xD49A,
	35451 - 11905: 0xD49B,
	35452 - 11905: 0xD49C,
	35453 - 11905: 0xD49D,
	35454 - 11905: 0xD49E,
	35455 - 11905: 0xD49F,
	35456 - 11905: 0xD4A0,
	35457 - 11905: 0xD540,
	35458 - 11905: 0xD541,
	35459 - 11905: 0xD542,
	35460 - 11905: 0xD543,
	35461 - 11905: 0xD544,
	35462 - 11905: 0xD545,
	35463 - 11905: 0xD546,
	35464 - 11905: 0xD547,
	35465 - 11905: 0xD3FE,
	35466 - 11905: 0xCCDC,
	35467 - 11905: 0xD548,
	35468 - 11905: 0xD549,
	35469 - 11905: 0xD54A,
	35470 - 11905: 0xD54B,
	35471 - 11905: 0xD54C,
	35472 - 11905: 0xD54D,
	35473 - 11905: 0xD54E,
	35474 - 11905: 0xD54F,
	35475 - 11905: 0xCAC4,
	35476 - 11905: 0xD550,
	35477 - 11905: 0xD551,
	35478 - 11905: 0xD552,
	35479 - 11905: 0xD553,
	35480 - 11905: 0xD554,
	35481 - 11905: 0xD555,
	35482 - 11905: 0xD556,
	35483 - 11905: 0xD557,
	35484 - 11905: 0xD558,
	35485 - 11905: 0xD559,
	35486 - 11905: 0xD55A,
	35487 - 11905: 0xD55B,
	35488 - 11905: 0xD55C,
	35489 - 11905: 0xD55D,
	35490 - 11905: 0xD55E,
	35491 - 11905: 0xD55F,
	35492 - 11905: 0xD560,
	35493 - 11905: 0xD561,
	35494 - 11905: 0xD562,
	35495 - 11905: 0xD563,
	35496 - 11905: 0xD564,
	35497 - 11905: 0xD565,
	35498 - 11905: 0xD566,
	35499 - 11905: 0xD567,
	35500 - 11905: 0xD568,
	35501 - 11905: 0xD569,
	35502 - 11905: 0xD56A,
	35503 - 11905: 0xD56B,
	35504 - 11905: 0xD56C,
	35505 - 11905: 0xD56D,
	35506 - 11905: 0xD56E,
	35507 - 11905: 0xD56F,
	35508 - 11905: 0xD570,
	35509 - 11905: 0xD571,
	35510 - 11905: 0xD572,
	35511 - 11905: 0xD573,
	35512 - 11905: 0xD574,
	35513 - 11905: 0xD575,
	35514 - 11905: 0xD576,
	35515 - 11905: 0xD577,
	35516 - 11905: 0xD578,
	35517 - 11905: 0xD579,
	35518 - 11905: 0xD57A,
	35519 - 11905: 0xD57B,
	35520 - 11905: 0xD57C,
	35521 - 11905: 0xD57D,
	35522 - 11905: 0xD57E,
	35523 - 11905: 0xD580,
	35524 - 11905: 0xD581,
	35525 - 11905: 0xD582,
	35526 - 11905: 0xD583,
	35527 - 11905: 0xD584,
	35528 - 11905: 0xD585,
	35529 - 11905: 0xD586,
	35530 - 11905: 0xD587,
	35531 - 11905: 0xD588,
	35532 - 11905: 0xD589,
	35533 - 11905: 0xD58A,
	35534 - 11905: 0xD58B,
	35535 - 11905: 0xD58C,
	35536 - 11905: 0xD58D,
	35537 - 11905: 0xD58E,
	35538 - 11905: 0xD58F,
	35539 - 11905: 0xD590,
	35540 - 11905: 0xD591,
	35541 - 11905: 0xD592,
	35542 - 11905: 0xD593,
	35543 - 11905: 0xD594,
	35544 - 11905: 0xD595,
	35545 - 11905: 0xD596,
	35546 - 11905: 0xD597,
	35547 - 11905: 0xD598,
	35548 - 11905: 0xD599,
	35549 - 11905: 0xD59A,
	35550 - 11905: 0xD59B,
	35551 - 11905: 0xD59C,
	35552 - 11905: 0xD59D,
	35553 - 11905: 0xD59E,
	35554 - 11905: 0xD59F,
	35555 - 11905: 0xD5A0,
	35556 - 11905: 0xD640,
	35557 - 11905: 0xD641,
	35558 - 11905: 0xD642,
	35559 - 11905: 0xD643,
	35560 - 11905: 0xD644,
	35561 - 11905: 0xD645,
	35562 - 11905: 0xD646,
	35563 - 11905: 0xD647,
	35564 - 11905: 0xD648,
	35565 - 11905: 0xD649,
	35566 - 11905: 0xD64A,
	35567 - 11905: 0xD64B,
	35568 - 11905: 0xD64C,
	35569 - 11905: 0xD64D,
	35570 - 11905: 0xD64E,
	35571 - 11905: 0xD64F,
	35572 - 11905: 0xD650,
	35573 - 11905: 0xD651,
	35574 - 11905: 0xD652,
	35575 - 11905: 0xD653,
	35576 - 11905: 0xD654,
	35577 - 11905: 0xD655,
	35578 - 11905: 0xD656,
	35579 - 11905: 0xD657,
	35580 - 11905: 0xD658,
	35581 - 11905: 0xD659,
	35582 - 11905: 0xD65A,
	35583 - 11905: 0xD65B,
	35584 - 11905: 0xD65C,
	35585 - 11905: 0xD65D,
	35586 - 11905: 0xD65E,
	35587 - 11905: 0xD65F,
	35588 - 11905: 0xD660,
	35589 - 11905: 0xD661,
	35590 - 11905: 0xD662,
	35591 - 11905: 0xE5C0,
	35592 - 11905: 0xD663,
	35593 - 11905: 0xD664,
	35594 - 11905: 0xD665,
	35595 - 11905: 0xD666,
	35596 - 11905: 0xD667,
	35597 - 11905: 0xD668,
	35598 - 11905: 0xD669,
	35599 - 11905: 0xD66A,
	35600 - 11905: 0xD66B,
	35601 - 11905: 0xD66C,
	35602 - 11905: 0xD66D,
	35603 - 11905: 0xD66E,
	35604 - 11905: 0xD66F,
	35605 - 11905: 0xD670,
	35606 - 11905: 0xD671,
	35607 - 11905: 0xD672,
	35608 - 11905: 0xD673,
	35609 - 11905: 0xD674,
	35610 - 11905: 0xD675,
	35611 - 11905: 0xD676,
	35612 - 11905: 0xD677,
	35613 - 11905: 0xD678,
	35614 - 11905: 0xD679,
	35615 - 11905: 0xD67A,
	35616 - 11905: 0xD67B,
	35617 - 11905: 0xD67C,
	35618 - 11905: 0xD67D,
	35619 - 11905: 0xD67E,
	35620 - 11905: 0xD680,
	35621 - 11905: 0xD681,
	35622 - 11905: 0xF6A5,
	35623 - 11905: 0xD682,
	35624 - 11905: 0xD683,
	35625 - 11905: 0xD684,
	35626 - 11905: 0xD685,
	35627 - 11905: 0xD686,
	35628 - 11905: 0xD687,
	35629 - 11905: 0xD688,
	35630 - 11905: 0xD689,
	35631 - 11905: 0xD68A,
	35632 - 11905: 0xD68B,
	35633 - 11905: 0xD68C,
	35634 - 11905: 0xD68D,
	35635 - 11905: 0xD68E,
	35636 - 11905: 0xD68F,
	35637 - 11905: 0xD690,
	35638 - 11905: 0xD691,
	35639 - 11905: 0xD692,
	35640 - 11905: 0xD693,
	35641 - 11905: 0xD694,
	35642 - 11905: 0xD695,
	35643 - 11905: 0xD696,
	35644 - 11905: 0xD697,
	35645 - 11905: 0xD698,
	35646 - 11905: 0xD699,
	35647 - 11905: 0xD69A,
	35648 - 11905: 0xD69B,
	35649 - 11905: 0xD69C,
	35650 - 11905: 0xD69D,
	35651 - 11905: 0xD69E,
	35652 - 11905: 0xD69F,
	35653 - 11905: 0xD6A0,
	35654 - 11905: 0xD740,
	35655 - 11905: 0xD741,
	35656 - 11905: 0xD742,
	35657 - 11905: 0xD743,
	35658 - 11905: 0xD744,
	35659 - 11905: 0xD745,
	35660 - 11905: 0xD746,
	35661 - 11905: 0xD747,
	35662 - 11905: 0xD748,
	35663 - 11905: 0xD749,
	35664 - 11905: 0xD74A,
	35665 - 11905: 0xD74B,
	35666 - 11905: 0xD74C,
	35667 - 11905: 0xD74D,
	35668 - 11905: 0xD74E,
	35669 - 11905: 0xD74F,
	35670 - 11905: 0xD750,
	35671 - 11905: 0xD751,
	35672 - 11905: 0xD752,
	35673 - 11905: 0xD753,
	35674 - 11905: 0xD754,
	35675 - 11905: 0xD755,
	35676 - 11905: 0xD756,
	35677 - 11905: 0xD757,
	35678 - 11905: 0xD758,
	35679 - 11905: 0xD759,
	35680 - 11905: 0xD75A,
	35681 - 11905: 0xD75B,
	35682 - 11905: 0xD75C,
	35683 - 11905: 0xD75D,
	35684 - 11905: 0xD75E,
	35685 - 11905: 0xD75F,
	35686 - 11905: 0xBEAF,
	35687 - 11905: 0xD760,
	35688 - 11905: 0xD761,
	35689 - 11905: 0xD762,
	35690 - 11905: 0xD763,
	35691 - 11905: 0xD764,
	35692 - 11905: 0xC6A9,
	35693 - 11905: 0xD765,
	35694 - 11905: 0xD766,
	35695 - 11905: 0xD767,
	35696 - 11905: 0xD768,
	35697 - 11905: 0xD769,
	35698 - 11905: 0xD76A,
	35699 - 11905: 0xD76B,
	35700 - 11905: 0xD76C,
	35701 - 11905: 0xD76D,
	35702 - 11905: 0xD76E,
	35703 - 11905: 0xD76F,
	35704 - 11905: 0xD770,
	35705 - 11905: 0xD771,
	35706 - 11905: 0xD772,
	35707 - 11905: 0xD773,
	35708 - 11905: 0xD774,
	35709 - 11905: 0xD775,
	35710 - 11905: 0xD776,
	35711 - 11905: 0xD777,
	35712 - 11905: 0xD778,
	35713 - 11905: 0xD779,
	35714 - 11905: 0xD77A,
	35715 - 11905: 0xD77B,
	35716 - 11905: 0xD77C,
	35717 - 11905: 0xD77D,
	35718 - 11905: 0xD77E,
	35719 - 11905: 0xD780,
	35720 - 11905: 0xD781,
	35721 - 11905: 0xD782,
	35722 - 11905: 0xD783,
	35723 - 11905: 0xD784,
	35724 - 11905: 0xD785,
	35725 - 11905: 0xD786,
	35726 - 11905: 0xD787,
	35727 - 11905: 0xD788,
	35728 - 11905: 0xD789,
	35729 - 11905: 0xD78A,
	35730 - 11905: 0xD78B,
	35731 - 11905: 0xD78C,
	35732 - 11905: 0xD78D,
	35733 - 11905: 0xD78E,
	35734 - 11905: 0xD78F,
	35735 - 11905: 0xD790,
	35736 - 11905: 0xD791,
	35737 - 11905: 0xD792,
	35738 - 11905: 0xD793,
	35739 - 11905: 0xD794,
	35740 - 11905: 0xD795,
	35741 - 11905: 0xD796,
	35742 - 11905: 0xD797,
	35743 - 11905: 0xD798,
	35744 - 11905: 0xDAA5,
	35745 - 11905: 0xBCC6,
	35746 - 11905: 0xB6A9,
	35747 - 11905: 0xB8BC,
	35748 - 11905: 0xC8CF,
	35749 - 11905: 0xBCA5,
	35750 - 11905: 0xDAA6,
	35751 - 11905: 0xDAA7,
	35752 - 11905: 0xCCD6,
	35753 - 11905: 0xC8C3,
	35754 - 11905: 0xDAA8,
	35755 - 11905: 0xC6FD,
	35756 - 11905: 0xD799,
	35757 - 11905: 0xD1B5,
	35758 - 11905: 0xD2E9,
	35759 - 11905: 0xD1B6,
	35760 - 11905: 0xBCC7,
	35761 - 11905: 0xD79A,
	35762 - 11905: 0xBDB2,
	35763 - 11905: 0xBBE4,
	35764 - 11905: 0xDAA9,
	35765 - 11905: 0xDAAA,
	35766 - 11905: 0xD1C8,
	35767 - 11905: 0xDAAB,
	35768 - 11905: 0xD0ED,
	35769 - 11905: 0xB6EF,
	35770 - 11905: 0xC2DB,
	35771 - 11905: 0xD79B,
	35772 - 11905: 0xCBCF,
	35773 - 11905: 0xB7ED,
	35774 - 11905: 0xC9E8,
	35775 - 11905: 0xB7C3,
	35776 - 11905: 0xBEF7,
	35777 - 11905: 0xD6A4,
	35778 - 11905: 0xDAAC,
	35779 - 11905: 0xDAAD,
	35780 - 11905: 0xC6C0,
	35781 - 11905: 0xD7E7,
	35782 - 11905: 0xCAB6,
	35783 - 11905: 0xD79C,
	35784 - 11905: 0xD5A9,
	35785 - 11905: 0xCBDF,
	35786 - 11905: 0xD5EF,
	35787 - 11905: 0xDAAE,
	35788 - 11905: 0xD6DF,
	35789 - 11905: 0xB4CA,
	35790 - 11905: 0xDAB0,
	35791 - 11905: 0xDAAF,
	35792 - 11905: 0xD79D,
	35793 - 11905: 0xD2EB,
	35794 - 11905: 0xDAB1,
	35795 - 11905: 0xDAB2,
	35796 - 11905: 0xDAB3,
	35797 - 11905: 0xCAD4,
	35798 - 11905: 0xDAB4,
	35799 - 11905: 0xCAAB,
	35800 - 11905: 0xDAB5,
	35801 - 11905: 0xDAB6,
	35802 - 11905: 0xB3CF,
	35803 - 11905: 0xD6EF,
	35804 - 11905: 0xDAB7,
	35805 - 11905: 0xBBB0,
	35806 - 11905: 0xB5AE,
	35807 - 11905: 0xDAB8,
	35808 - 11905: 0xDAB9,
	35809 - 11905: 0xB9EE,
	35810 - 11905: 0xD1AF,
	35811 - 11905: 0xD2E8,
	35812 - 11905: 0xDABA,
	35813 - 11905: 0xB8C3,
	35814 - 11905: 0xCFEA,
	35815 - 11905: 0xB2EF,
	35816 - 11905: 0xDABB,
	35817 - 11905: 0xDABC,
	35818 - 11905: 0xD79E,
	35819 - 11905: 0xBDEB,
	35820 - 11905: 0xCEDC,
	35821 - 11905: 0xD3EF,
	35822 - 11905: 0xDABD,
	35823 - 11905: 0xCEF3,
	35824 - 11905: 0xDABE,
	35825 - 11905: 0xD3D5,
	35826 - 11905: 0xBBE5,
	35827 - 11905: 0xDABF,
	35828 - 11905: 0xCBB5,
	35829 - 11905: 0xCBD0,
	35830 - 11905: 0xDAC0,
	35831 - 11905: 0xC7EB,
	35832 - 11905: 0xD6EE,
	35833 - 11905: 0xDAC1,
	35834 - 11905: 0xC5B5,
	35835 - 11905: 0xB6C1,
	35836 - 11905: 0xDAC2,
	35837 - 11905: 0xB7CC,
	35838 - 11905: 0xBFCE,
	35839 - 11905: 0xDAC3,
	35840 - 11905: 0xDAC4,
	35841 - 11905: 0xCBAD,
	35842 - 11905: 0xDAC5,
	35843 - 11905: 0xB5F7,
	35844 - 11905: 0xDAC6,
	35845 - 11905: 0xC1C2,
	35846 - 11905: 0xD7BB,
	35847 - 11905: 0xDAC7,
	35848 - 11905: 0xCCB8,
	35849 - 11905: 0xD79F,
	35850 - 11905: 0xD2EA,
	35851 - 11905: 0xC4B1,
	35852 - 11905: 0xDAC8,
	35853 - 11905: 0xB5FD,
	35854 - 11905: 0xBBD1,
	35855 - 11905: 0xDAC9,
	35856 - 11905: 0xD0B3,
	35857 - 11905: 0xDACA,
	35858 - 11905: 0xDACB,
	35859 - 11905: 0xCEBD,
	35860 - 11905: 0xDACC,
	35861 - 11905: 0xDACD,
	35862 - 11905: 0xDACE,
	35863 - 11905: 0xB2F7,
	35864 - 11905: 0xDAD1,
	35865 - 11905: 0xDACF,
	35866 - 11905: 0xD1E8,
	35867 - 11905: 0xDAD0,
	35868 - 11905: 0xC3D5,
	35869 - 11905: 0xDAD2,
	35870 - 11905: 0xD7A0,
	35871 - 11905: 0xDAD3,
	35872 - 11905: 0xDAD4,
	35873 - 11905: 0xDAD5,
	35874 - 11905: 0xD0BB,
	35875 - 11905: 0xD2A5,
	35876 - 11905: 0xB0F9,
	35877 - 11905: 0xDAD6,
	35878 - 11905: 0xC7AB,
	35879 - 11905: 0xDAD7,
	35880 - 11905: 0xBDF7,
	35881 - 11905: 0xC3A1,
	35882 - 11905: 0xDAD8,
	35883 - 11905: 0xDAD9,
	35884 - 11905: 0xC3FD,
	35885 - 11905: 0xCCB7,
	35886 - 11905: 0xDADA,
	35887 - 11905: 0xDADB,
	35888 - 11905: 0xC0BE,
	35889 - 11905: 0xC6D7,
	35890 - 11905: 0xDADC,
	35891 - 11905: 0xDADD,
	35892 - 11905: 0xC7B4,
	35893 - 11905: 0xDADE,
	35894 - 11905: 0xDADF,
	35895 - 11905: 0xB9C8,
	35896 - 11905: 0xD840,
	35897 - 11905: 0xD841,
	35898 - 11905: 0xD842,
	35899 - 11905: 0xD843,
	35900 - 11905: 0xD844,
	35901 - 11905: 0xD845,
	35902 - 11905: 0xD846,
	35903 - 11905: 0xD847,
	35904 - 11905: 0xD848,
	35905 - 11905: 0xBBED,
	35906 - 11905: 0xD849,
	35907 - 11905: 0xD84A,
	35908 - 11905: 0xD84B,
	35909 - 11905: 0xD84C,
	35910 - 11905: 0xB6B9,
	35911 - 11905: 0xF4F8,
	35912 - 11905: 0xD84D,
	35913 - 11905: 0xF4F9,
	35914 - 11905: 0xD84E,
	35915 - 11905: 0xD84F,
	35916 - 11905: 0xCDE3,
	35917 - 11905: 0xD850,
	35918 - 11905: 0xD851,
	35919 - 11905: 0xD852,
	35920 - 11905: 0xD853,
	35921 - 11905: 0xD854,
	35922 - 11905: 0xD855,
	35923 - 11905: 0xD856,
	35924 - 11905: 0xD857,
	35925 - 11905: 0xF5B9,
	35926 - 11905: 0xD858,
	35927 - 11905: 0xD859,
	35928 - 11905: 0xD85A,
	35929 - 11905: 0xD85B,
	35930 - 11905: 0xEBE0,
	35931 - 11905: 0xD85C,
	35932 - 11905: 0xD85D,
	35933 - 11905: 0xD85E,
	35934 - 11905: 0xD85F,
	35935 - 11905: 0xD860,
	35936 - 11905: 0xD861,
	35937 - 11905: 0xCFF3,
	35938 - 11905: 0xBBBF,
	35939 - 11905: 0xD862,
	35940 - 11905: 0xD863,
	35941 - 11905: 0xD864,
	35942 - 11905: 0xD865,
	35943 - 11905: 0xD866,
	35944 - 11905: 0xD867,
	35945 - 11905: 0xD868,
	35946 - 11905: 0xBAC0,
	35947 - 11905: 0xD4A5,
	35948 - 11905: 0xD869,
	35949 - 11905: 0xD86A,
	35950 - 11905: 0xD86B,
	35951 - 11905: 0xD86C,
	35952 - 11905: 0xD86D,
	35953 - 11905: 0xD86E,
	35954 - 11905: 0xD86F,
	35955 - 11905: 0xE1D9,
	35956 - 11905: 0xD870,
	35957 - 11905: 0xD871,
	35958 - 11905: 0xD872,
	35959 - 11905: 0xD873,
	35960 - 11905: 0xF5F4,
	35961 - 11905: 0xB1AA,
	35962 - 11905: 0xB2F2,
	35963 - 11905: 0xD874,
	35964 - 11905: 0xD875,
	35965 - 11905: 0xD876,
	35966 - 11905: 0xD877,
	35967 - 11905: 0xD878,
	35968 - 11905: 0xD879,
	35969 - 11905: 0xD87A,
	35970 - 11905: 0xF5F5,
	35971 - 11905: 0xD87B,
	35972 - 11905: 0xD87C,
	35973 - 11905: 0xF5F7,
	35974 - 11905: 0xD87D,
	35975 - 11905: 0xD87E,
	35976 - 11905: 0xD880,
	35977 - 11905: 0xBAD1,
	35978 - 11905: 0xF5F6,
	35979 - 11905: 0xD881,
	35980 - 11905: 0xC3B2,
	35981 - 11905: 0xD882,
	35982 - 11905: 0xD883,
	35983 - 11905: 0xD884,
	35984 - 11905: 0xD885,
	35985 - 11905: 0xD886,
	35986 - 11905: 0xD887,
	35987 - 11905: 0xD888,
	35988 - 11905: 0xF5F9,
	35989 - 11905: 0xD889,
	35990 - 11905: 0xD88A,
	35991 - 11905: 0xD88B,
	35992 - 11905: 0xF5F8,
	35993 - 11905: 0xD88C,
	35994 - 11905: 0xD88D,
	35995 - 11905: 0xD88E,
	35996 - 11905: 0xD88F,
	35997 - 11905: 0xD890,
	35998 - 11905: 0xD891,
	35999 - 11905: 0xD892,
	36000 - 11905: 0xD893,
	36001 - 11905: 0xD894,
	36002 - 11905: 0xD895,
	36003 - 11905: 0xD896,
	36004 - 11905: 0xD897,
	36005 - 11905: 0xD898,
	36006 - 11905: 0xD899,
	36007 - 11905: 0xD89A,
	36008 - 11905: 0xD89B,
	36009 - 11905: 0xD89C,
	36010 - 11905: 0xD89D,
	36011 - 11905: 0xD89E,
	36012 - 11905: 0xD89F,
	36013 - 11905: 0xD8A0,
	36014 - 11905: 0xD940,
	36015 - 11905: 0xD941,
	36016 - 11905: 0xD942,
	36017 - 11905: 0xD943,
	36018 - 11905: 0xD944,
	36019 - 11905: 0xD945,
	36020 - 11905: 0xD946,
	36021 - 11905: 0xD947,
	36022 - 11905: 0xD948,
	36023 - 11905: 0xD949,
	36024 - 11905: 0xD94A,
	36025 - 11905: 0xD94B,
	36026 - 11905: 0xD94C,
	36027 - 11905: 0xD94D,
	36028 - 11905: 0xD94E,
	36029 - 11905: 0xD94F,
	36030 - 11905: 0xD950,
	36031 - 11905: 0xD951,
	36032 - 11905: 0xD952,
	36033 - 11905: 0xD953,
	36034 - 11905: 0xD954,
	36035 - 11905: 0xD955,
	36036 - 11905: 0xD956,
	36037 - 11905: 0xD957,
	36038 - 11905: 0xD958,
	36039 - 11905: 0xD959,
	36040 - 11905: 0xD95A,
	36041 - 11905: 0xD95B,
	36042 - 11905: 0xD95C,
	36043 - 11905: 0xD95D,
	36044 - 11905: 0xD95E,
	36045 - 11905: 0xD95F,
	36046 - 11905: 0xD960,
	36047 - 11905: 0xD961,
	36048 - 11905: 0xD962,
	36049 - 11905: 0xD963,
	36050 - 11905: 0xD964,
	36051 - 11905: 0xD965,
	36052 - 11905: 0xD966,
	36053 - 11905: 0xD967,
	36054 - 11905: 0xD968,
	36055 - 11905: 0xD969,
	36056 - 11905: 0xD96A,
	36057 - 11905: 0xD96B,
	36058 - 11905: 0xD96C,
	36059 - 11905: 0xD96D,
	36060 - 11905: 0xD96E,
	36061 - 11905: 0xD96F,
	36062 - 11905: 0xD970,
	36063 - 11905: 0xD971,
	36064 - 11905: 0xD972,
	36065 - 11905: 0xD973,
	36066 - 11905: 0xD974,
	36067 - 11905: 0xD975,
	36068 - 11905: 0xD976,
	36069 - 11905: 0xD977,
	36070 - 11905: 0xD978,
	36071 - 11905: 0xD979,
	36072 - 11905: 0xD97A,
	36073 - 11905: 0xD97B,
	36074 - 11905: 0xD97C,
	36075 - 11905: 0xD97D,
	36076 - 11905: 0xD97E,
	36077 - 11905: 0xD980,
	36078 - 11905: 0xD981,
	36079 - 11905: 0xD982,
	36080 - 11905: 0xD983,
	36081 - 11905: 0xD984,
	36082 - 11905: 0xD985,
	36083 - 11905: 0xD986,
	36084 - 11905: 0xD987,
	36085 - 11905: 0xD988,
	36086 - 11905: 0xD989,
	36087 - 11905: 0xD98A,
	36088 - 11905: 0xD98B,
	36089 - 11905: 0xD98C,
	36090 - 11905: 0xD98D,
	36091 - 11905: 0xD98E,
	36092 - 11905: 0xD98F,
	36093 - 11905: 0xD990,
	36094 - 11905: 0xD991,
	36095 - 11905: 0xD992,
	36096 - 11905: 0xD993,
	36097 - 11905: 0xD994,
	36098 - 11905: 0xD995,
	36099 - 11905: 0xD996,
	36100 - 11905: 0xD997,
	36101 - 11905: 0xD998,
	36102 - 11905: 0xD999,
	36103 - 11905: 0xD99A,
	36104 - 11905: 0xD99B,
	36105 - 11905: 0xD99C,
	36106 - 11905: 0xD99D,
	36107 - 11905: 0xD99E,
	36108 - 11905: 0xD99F,
	36109 - 11905: 0xD9A0,
	36110 - 11905: 0xDA40,
	36111 - 11905: 0xDA41,
	36112 - 11905: 0xDA42,
	36113 - 11905: 0xDA43,
	36114 - 11905: 0xDA44,
	36115 - 11905: 0xDA45,
	36116 - 11905: 0xDA46,
	36117 - 11905: 0xDA47,
	36118 - 11905: 0xDA48,
	36119 - 11905: 0xDA49,
	36120 - 11905: 0xDA4A,
	36121 - 11905: 0xDA4B,
	36122 - 11905: 0xDA4C,
	36123 - 11905: 0xDA4D,
	36124 - 11905: 0xDA4E,
	36125 - 11905: 0xB1B4,
	36126 - 11905: 0xD5EA,
	36127 - 11905: 0xB8BA,
	36128 - 11905: 0xDA4F,
	36129 - 11905: 0xB9B1,
	36130 - 11905: 0xB2C6,
	36131 - 11905: 0xD4F0,
	36132 - 11905: 0xCFCD,
	36133 - 11905: 0xB0DC,
	36134 - 11905: 0xD5CB,
	36135 - 11905: 0xBBF5,
	36136 - 11905: 0xD6CA,
	36137 - 11905: 0xB7B7,
	36138 - 11905: 0xCCB0,
	36139 - 11905: 0xC6B6,
	36140 - 11905: 0xB1E1,
	36141 - 11905: 0xB9BA,
	36142 - 11905: 0xD6FC,
	36143 - 11905: 0xB9E1,
	36144 - 11905: 0xB7A1,
	36145 - 11905: 0xBCFA,
	36146 - 11905: 0xEADA,
	36147 - 11905: 0xEADB,
	36148 - 11905: 0xCCF9,
	36149 - 11905: 0xB9F3,
	36150 - 11905: 0xEADC,
	36151 - 11905: 0xB4FB,
	36152 - 11905: 0xC3B3,
	36153 - 11905: 0xB7D1,
	36154 - 11905: 0xBAD8,
	36155 - 11905: 0xEADD,
	36156 - 11905: 0xD4F4,
	36157 - 11905: 0xEADE,
	36158 - 11905: 0xBCD6,
	36159 - 11905: 0xBBDF,
	36160 - 11905: 0xEADF,
	36161 - 11905: 0xC1DE,
	36162 - 11905: 0xC2B8,
	36163 - 11905: 0xD4DF,
	36164 - 11905: 0xD7CA,
	36165 - 11905: 0xEAE0,
	36166 - 11905: 0xEAE1,
	36167 - 11905: 0xEAE4,
	36168 - 11905: 0xEAE2,
	36169 - 11905: 0xEAE3,
	36170 - 11905: 0xC9DE,
	36171 - 11905: 0xB8B3,
	36172 - 11905: 0xB6C4,
	36173 - 11905: 0xEAE5,
	36174 - 11905: 0xCAEA,
	36175 - 11905: 0xC9CD,
	36176 - 11905: 0xB4CD,
	36177 - 11905: 0xDA50,
	36178 - 11905: 0xDA51,
	36179 - 11905: 0xE2D9,
	36180 - 11905: 0xC5E2,
	36181 - 11905: 0xEAE6,
	36182 - 11905: 0xC0B5,
	36183 - 11905: 0xDA52,
	36184 - 11905: 0xD7B8,
	36185 - 11905: 0xEAE7,
	36186 - 11905: 0xD7AC,
	36187 - 11905: 0xC8FC,
	36188 - 11905: 0xD8D3,
	36189 - 11905: 0xD8CD,
	36190 - 11905: 0xD4DE,
	36191 - 11905: 0xDA53,
	36192 - 11905: 0xD4F9,
	36193 - 11905: 0xC9C4,
	36194 - 11905: 0xD3AE,
	36195 - 11905: 0xB8D3,
	36196 - 11905: 0xB3E0,
	36197 - 11905: 0xDA54,
	36198 - 11905: 0xC9E2,
	36199 - 11905: 0xF4F6,
	36200 - 11905: 0xDA55,
	36201 - 11905: 0xDA56,
	36202 - 11905: 0xDA57,
	36203 - 11905: 0xBAD5,
	36204 - 11905: 0xDA58,
	36205 - 11905: 0xF4F7,
	36206 - 11905: 0xDA59,
	36207 - 11905: 0xDA5A,
	36208 - 11905: 0xD7DF,
	36209 - 11905: 0xDA5B,
	36210 - 11905: 0xDA5C,
	36211 - 11905: 0xF4F1,
	36212 - 11905: 0xB8B0,
	36213 - 11905: 0xD5D4,
	36214 - 11905: 0xB8CF,
	36215 - 11905: 0xC6F0,
	36216 - 11905: 0xDA5D,
	36217 - 11905: 0xDA5E,
	36218 - 11905: 0xDA5F,
	36219 - 11905: 0xDA60,
	36220 - 11905: 0xDA61,
	36221 - 11905: 0xDA62,
	36222 - 11905: 0xDA63,
	36223 - 11905: 0xDA64,
	36224 - 11905: 0xDA65,
	36225 - 11905: 0xB3C3,
	36226 - 11905: 0xDA66,
	36227 - 11905: 0xDA67,
	36228 - 11905: 0xF4F2,
	36229 - 11905: 0xB3AC,
	36230 - 11905: 0xDA68,
	36231 - 11905: 0xDA69,
	36232 - 11905: 0xDA6A,
	36233 - 11905: 0xDA6B,
	36234 - 11905: 0xD4BD,
	36235 - 11905: 0xC7F7,
	36236 - 11905: 0xDA6C,
	36237 - 11905: 0xDA6D,
	36238 - 11905: 0xDA6E,
	36239 - 11905: 0xDA6F,
	36240 - 11905: 0xDA70,
	36241 - 11905: 0xF4F4,
	36242 - 11905: 0xDA71,
	36243 - 11905: 0xDA72,
	36244 - 11905: 0xF4F3,
	36245 - 11905: 0xDA73,
	36246 - 11905: 0xDA74,
	36247 - 11905: 0xDA75,
	36248 - 11905: 0xDA76,
	36249 - 11905: 0xDA77,
	36250 - 11905: 0xDA78,
	36251 - 11905: 0xDA79,
	36252 - 11905: 0xDA7A,
	36253 - 11905: 0xDA7B,
	36254 - 11905: 0xDA7C,
	36255 - 11905: 0xCCCB,
	36256 - 11905: 0xDA7D,
	36257 - 11905: 0xDA7E,
	36258 - 11905: 0xDA80,
	36259 - 11905: 0xC8A4,
	36260 - 11905: 0xDA81,
	36261 - 11905: 0xDA82,
	36262 - 11905: 0xDA83,
	36263 - 11905: 0xDA84,
	36264 - 11905: 0xDA85,
	36265 - 11905: 0xDA86,
	36266 - 11905: 0xDA87,
	36267 - 11905: 0xDA88,
	36268 - 11905: 0xDA89,
	36269 - 11905: 0xDA8A,
	36270 - 11905: 0xDA8B,
	36271 - 11905: 0xDA8C,
	36272 - 11905: 0xDA8D,
	36273 - 11905: 0xF4F5,
	36274 - 11905: 0xDA8E,
	36275 - 11905: 0xD7E3,
	36276 - 11905: 0xC5BF,
	36277 - 11905: 0xF5C0,
	36278 - 11905: 0xDA8F,
	36279 - 11905: 0xDA90,
	36280 - 11905: 0xF5BB,
	36281 - 11905: 0xDA91,
	36282 - 11905: 0xF5C3,
	36283 - 11905: 0xDA92,
	36284 - 11905: 0xF5C2,
	36285 - 11905: 0xDA93,
	36286 - 11905: 0xD6BA,
	36287 - 11905: 0xF5C1,
	36288 - 11905: 0xDA94,
	36289 - 11905: 0xDA95,
	36290 - 11905: 0xDA96,
	36291 - 11905: 0xD4BE,
	36292 - 11905: 0xF5C4,
	36293 - 11905: 0xDA97,
	36294 - 11905: 0xF5CC,
	36295 - 11905: 0xDA98,
	36296 - 11905: 0xDA99,
	36297 - 11905: 0xDA9A,
	36298 - 11905: 0xDA9B,
	36299 - 11905: 0xB0CF,
	36300 - 11905: 0xB5F8,
	36301 - 11905: 0xDA9C,
	36302 - 11905: 0xF5C9,
	36303 - 11905: 0xF5CA,
	36304 - 11905: 0xDA9D,
	36305 - 11905: 0xC5DC,
	36306 - 11905: 0xDA9E,
	36307 - 11905: 0xDA9F,
	36308 - 11905: 0xDAA0,
	36309 - 11905: 0xDB40,
	36310 - 11905: 0xF5C5,
	36311 - 11905: 0xF5C6,
	36312 - 11905: 0xDB41,
	36313 - 11905: 0xDB42,
	36314 - 11905: 0xF5C7,
	36315 - 11905: 0xF5CB,
	36316 - 11905: 0xDB43,
	36317 - 11905: 0xBEE0,
	36318 - 11905: 0xF5C8,
	36319 - 11905: 0xB8FA,
	36320 - 11905: 0xDB44,
	36321 - 11905: 0xDB45,
	36322 - 11905: 0xDB46,
	36323 - 11905: 0xF5D0,
	36324 - 11905: 0xF5D3,
	36325 - 11905: 0xDB47,
	36326 - 11905: 0xDB48,
	36327 - 11905: 0xDB49,
	36328 - 11905: 0xBFE7,
	36329 - 11905: 0xDB4A,
	36330 - 11905: 0xB9F2,
	36331 - 11905: 0xF5BC,
	36332 - 11905: 0xF5CD,
	36333 - 11905: 0xDB4B,
	36334 - 11905: 0xDB4C,
	36335 - 11905: 0xC2B7,
	36336 - 11905: 0xDB4D,
	36337 - 11905: 0xDB4E,
	36338 - 11905: 0xDB4F,
	36339 - 11905: 0xCCF8,
	36340 - 11905: 0xDB50,
	36341 - 11905: 0xBCF9,
	36342 - 11905: 0xDB51,
	36343 - 11905: 0xF5CE,
	36344 - 11905: 0xF5CF,
	36345 - 11905: 0xF5D1,
	36346 - 11905: 0xB6E5,
	36347 - 11905: 0xF5D2,
	36348 - 11905: 0xDB52,
	36349 - 11905: 0xF5D5,
	36350 - 11905: 0xDB53,
	36351 - 11905: 0xDB54,
	36352 - 11905: 0xDB55,
	36353 - 11905: 0xDB56,
	36354 - 11905: 0xDB57,
	36355 - 11905: 0xDB58,
	36356 - 11905: 0xDB59,
	36357 - 11905: 0xF5BD,
	36358 - 11905: 0xDB5A,
	36359 - 11905: 0xDB5B,
	36360 - 11905: 0xDB5C,
	36361 - 11905: 0xF5D4,
	36362 - 11905: 0xD3BB,
	36363 - 11905: 0xDB5D,
	36364 - 11905: 0xB3EC,
	36365 - 11905: 0xDB5E,
	36366 - 11905: 0xDB5F,
	36367 - 11905: 0xCCA4,
	36368 - 11905: 0xDB60,
	36369 - 11905: 0xDB61,
	36370 - 11905: 0xDB62,
	36371 - 11905: 0xDB63,
	36372 - 11905: 0xF5D6,
	36373 - 11905: 0xDB64,
	36374 - 11905: 0xDB65,
	36375 - 11905: 0xDB66,
	36376 - 11905: 0xDB67,
	36377 - 11905: 0xDB68,
	36378 - 11905: 0xDB69,
	36379 - 11905: 0xDB6A,
	36380 - 11905: 0xDB6B,
	36381 - 11905: 0xF5D7,
	36382 - 11905: 0xBEE1,
	36383 - 11905: 0xF5D8,
	36384 - 11905: 0xDB6C,
	36385 - 11905: 0xDB6D,
	36386 - 11905: 0xCCDF,
	36387 - 11905: 0xF5DB,
	36388 - 11905: 0xDB6E,
	36389 - 11905: 0xDB6F,
	36390 - 11905: 0xDB70,
	36391 - 11905: 0xDB71,
	36392 - 11905: 0xDB72,
	36393 - 11905: 0xB2C8,
	36394 - 11905: 0xD7D9,
	36395 - 11905: 0xDB73,
	36396 - 11905: 0xF5D9,
	36397 - 11905: 0xDB74,
	36398 - 11905: 0xF5DA,
	36399 - 11905: 0xF5DC,
	36400 - 11905: 0xDB75,
	36401 - 11905: 0xF5E2,
	36402 - 11905: 0xDB76,
	36403 - 11905: 0xDB77,
	36404 - 11905: 0xDB78,
	36405 - 11905: 0xF5E0,
	36406 - 11905: 0xDB79,
	36407 - 11905: 0xDB7A,
	36408 - 11905: 0xDB7B,
	36409 - 11905: 0xF5DF,
	36410 - 11905: 0xF5DD,
	36411 - 11905: 0xDB7C,
	36412 - 11905: 0xDB7D,
	36413 - 11905: 0xF5E1,
	36414 - 11905: 0xDB7E,
	36415 - 11905: 0xDB80,
	36416 - 11905: 0xF5DE,
	36417 - 11905: 0xF5E4,
	36418 - 11905: 0xF5E5,
	36419 - 11905: 0xDB81,
	36420 - 11905: 0xCCE3,
	36421 - 11905: 0xDB82,
	36422 - 11905: 0xDB83,
	36423 - 11905: 0xE5BF,
	36424 - 11905: 0xB5B8,
	36425 - 11905: 0xF5E3,
	36426 - 11905: 0xF5E8,
	36427 - 11905: 0xCCA3,
	36428 - 11905: 0xDB84,
	36429 - 11905: 0xDB85,
	36430 - 11905: 0xDB86,
	36431 - 11905: 0xDB87,
	36432 - 11905: 0xDB88,
	36433 - 11905: 0xF5E6,
	36434 - 11905: 0xF5E7,
	36435 - 11905: 0xDB89,
	36436 - 11905: 0xDB8A,
	36437 - 11905: 0xDB8B,
	36438 - 11905: 0xDB8C,
	36439 - 11905: 0xDB8D,
	36440 - 11905: 0xDB8E,
	36441 - 11905: 0xF5BE,
	36442 - 11905: 0xDB8F,
	36443 - 11905: 0xDB90,
	36444 - 11905: 0xDB91,
	36445 - 11905: 0xDB92,
	36446 - 11905: 0xDB93,
	36447 - 11905: 0xDB94,
	36448 - 11905: 0xDB95,
	36449 - 11905: 0xDB96,
	36450 - 11905: 0xDB97,
	36451 - 11905: 0xDB98,
	36452 - 11905: 0xDB99,
	36453 - 11905: 0xDB9A,
	36454 - 11905: 0xB1C4,
	36455 - 11905: 0xDB9B,
	36456 - 11905: 0xDB9C,
	36457 - 11905: 0xF5BF,
	36458 - 11905: 0xDB9D,
	36459 - 11905: 0xDB9E,
	36460 - 11905: 0xB5C5,
	36461 - 11905: 0xB2E4,
	36462 - 11905: 0xDB9F,
	36463 - 11905: 0xF5EC,
	36464 - 11905: 0xF5E9,
	36465 - 11905: 0xDBA0,
	36466 - 11905: 0xB6D7,
	36467 - 11905: 0xDC40,
	36468 - 11905: 0xF5ED,
	36469 - 11905: 0xDC41,
	36470 - 11905: 0xF5EA,
	36471 - 11905: 0xDC42,
	36472 - 11905: 0xDC43,
	36473 - 11905: 0xDC44,
	36474 - 11905: 0xDC45,
	36475 - 11905: 0xDC46,
	36476 - 11905: 0xF5EB,
	36477 - 11905: 0xDC47,
	36478 - 11905: 0xDC48,
	36479 - 11905: 0xB4DA,
	36480 - 11905: 0xDC49,
	36481 - 11905: 0xD4EA,
	36482 - 11905: 0xDC4A,
	36483 - 11905: 0xDC4B,
	36484 - 11905: 0xDC4C,
	36485 - 11905: 0xF5EE,
	36486 - 11905: 0xDC4D,
	36487 - 11905: 0xB3F9,
	36488 - 11905: 0xDC4E,
	36489 - 11905: 0xDC4F,
	36490 - 11905: 0xDC50,
	36491 - 11905: 0xDC51,
	36492 - 11905: 0xDC52,
	36493 - 11905: 0xDC53,
	36494 - 11905: 0xDC54,
	36495 - 11905: 0xF5EF,
	36496 - 11905: 0xF5F1,
	36497 - 11905: 0xDC55,
	36498 - 11905: 0xDC56,
	36499 - 11905: 0xDC57,
	36500 - 11905: 0xF5F0,
	36501 - 11905: 0xDC58,
	36502 - 11905: 0xDC59,
	36503 - 11905: 0xDC5A,
	36504 - 11905: 0xDC5B,
	36505 - 11905: 0xDC5C,
	36506 - 11905: 0xDC5D,
	36507 - 11905: 0xDC5E,
	36508 - 11905: 0xF5F2,
	36509 - 11905: 0xDC5F,
	36510 - 11905: 0xF5F3,
	36511 - 11905: 0xDC60,
	36512 - 11905: 0xDC61,
	36513 - 11905: 0xDC62,
	36514 - 11905: 0xDC63,
	36515 - 11905: 0xDC64,
	36516 - 11905: 0xDC65,
	36517 - 11905: 0xDC66,
	36518 - 11905: 0xDC67,
	36519 - 11905: 0xDC68,
	36520 - 11905: 0xDC69,
	36521 - 11905: 0xDC6A,
	36522 - 11905: 0xDC6B,
	36523 - 11905: 0xC9ED,
	36524 - 11905: 0xB9AA,
	36525 - 11905: 0xDC6C,
	36526 - 11905: 0xDC6D,
	36527 - 11905: 0xC7FB,
	36528 - 11905: 0xDC6E,
	36529 - 11905: 0xDC6F,
	36530 - 11905: 0xB6E3,
	36531 - 11905: 0xDC70,
	36532 - 11905: 0xDC71,
	36533 - 11905: 0xDC72,
	36534 - 11905: 0xDC73,
	36535 - 11905: 0xDC74,
	36536 - 11905: 0xDC75,
	36537 - 11905: 0xDC76,
	36538 - 11905: 0xCCC9,
	36539 - 11905: 0xDC77,
	36540 - 11905: 0xDC78,
	36541 - 11905: 0xDC79,
	36542 - 11905: 0xDC7A,
	36543 - 11905: 0xDC7B,
	36544 - 11905: 0xDC7C,
	36545 - 11905: 0xDC7D,
	36546 - 11905: 0xDC7E,
	36547 - 11905: 0xDC80,
	36548 - 11905: 0xDC81,
	36549 - 11905: 0xDC82,
	36550 - 11905: 0xDC83,
	36551 - 11905: 0xDC84,
	36552 - 11905: 0xDC85,
	36553 - 11905: 0xDC86,
	36554 - 11905: 0xDC87,
	36555 - 11905: 0xDC88,
	36556 - 11905: 0xDC89,
	36557 - 11905: 0xDC8A,
	36558 - 11905: 0xEAA6,
	36559 - 11905: 0xDC8B,
	36560 - 11905: 0xDC8C,
	36561 - 11905: 0xDC8D,
	36562 - 11905: 0xDC8E,
	36563 - 11905: 0xDC8F,
	36564 - 11905: 0xDC90,
	36565 - 11905: 0xDC91,
	36566 - 11905: 0xDC92,
	36567 - 11905: 0xDC93,
	36568 - 11905: 0xDC94,
	36569 - 11905: 0xDC95,
	36570 - 11905: 0xDC96,
	36571 - 11905: 0xDC97,
	36572 - 11905: 0xDC98,
	36573 - 11905: 0xDC99,
	36574 - 11905: 0xDC9A,
	36575 - 11905: 0xDC9B,
	36576 - 11905: 0xDC9C,
	36577 - 11905: 0xDC9D,
	36578 - 11905: 0xDC9E,
	36579 - 11905: 0xDC9F,
	36580 - 11905: 0xDCA0,
	36581 - 11905: 0xDD40,
	36582 - 11905: 0xDD41,
	36583 - 11905: 0xDD42,
	36584 - 11905: 0xDD43,
	36585 - 11905: 0xDD44,
	36586 - 11905: 0xDD45,
	36587 - 11905: 0xDD46,
	36588 - 11905: 0xDD47,
	36589 - 11905: 0xDD48,
	36590 - 11905: 0xDD49,
	36591 - 11905: 0xDD4A,
	36592 - 11905: 0xDD4B,
	36593 - 11905: 0xDD4C,
	36594 - 11905: 0xDD4D,
	36595 - 11905: 0xDD4E,
	36596 - 11905: 0xDD4F,
	36597 - 11905: 0xDD50,
	36598 - 11905: 0xDD51,
	36599 - 11905: 0xDD52,
	36600 - 11905: 0xDD53,
	36601 - 11905: 0xDD54,
	36602 - 11905: 0xDD55,
	36603 - 11905: 0xDD56,
	36604 - 11905: 0xDD57,
	36605 - 11905: 0xDD58,
	36606 - 11905: 0xDD59,
	36607 - 11905: 0xDD5A,
	36608 - 11905: 0xDD5B,
	36609 - 11905: 0xDD5C,
	36610 - 11905: 0xDD5D,
	36611 - 11905: 0xDD5E,
	36612 - 11905: 0xDD5F,
	36613 - 11905: 0xDD60,
	36614 - 11905: 0xDD61,
	36615 - 11905: 0xDD62,
	36616 - 11905: 0xDD63,
	36617 - 11905: 0xDD64,
	36618 - 11905: 0xDD65,
	36619 - 11905: 0xDD66,
	36620 - 11905: 0xDD67,
	36621 - 11905: 0xDD68,
	36622 - 11905: 0xDD69,
	36623 - 11905: 0xDD6A,
	36624 - 11905: 0xDD6B,
	36625 - 11905: 0xDD6C,
	36626 - 11905: 0xDD6D,
	36627 - 11905: 0xDD6E,
	36628 - 11905: 0xDD6F,
	36629 - 11905: 0xDD70,
	36630 - 11905: 0xDD71,
	36631 - 11905: 0xDD72,
	36632 - 11905: 0xDD73,
	36633 - 11905: 0xDD74,
	36634 - 11905: 0xDD75,
	36635 - 11905: 0xDD76,
	36636 - 11905: 0xDD77,
	36637 - 11905: 0xDD78,
	36638 - 11905: 0xDD79,
	36639 - 11905: 0xDD7A,
	36640 - 11905: 0xDD7B,
	36641 - 11905: 0xDD7C,
	36642 - 11905: 0xDD7D,
	36643 - 11905: 0xDD7E,
	36644 - 11905: 0xDD80,
	36645 - 11905: 0xDD81,
	36646 - 11905: 0xDD82,
	36647 - 11905: 0xDD83,
	36648 - 11905: 0xDD84,
	36649 - 11905: 0xDD85,
	36650 - 11905: 0xDD86,
	36651 - 11905: 0xDD87,
	36652 - 11905: 0xDD88,
	36653 - 11905: 0xDD89,
	36654 - 11905: 0xDD8A,
	36655 - 11905: 0xDD8B,
	36656 - 11905: 0xDD8C,
	36657 - 11905: 0xDD8D,
	36658 - 11905: 0xDD8E,
	36659 - 11905: 0xDD8F,
	36660 - 11905: 0xDD90,
	36661 - 11905: 0xDD91,
	36662 - 11905: 0xDD92,
	36663 - 11905: 0xDD93,
	36664 - 11905: 0xDD94,
	36665 - 11905: 0xDD95,
	36666 - 11905: 0xDD96,
	36667 - 11905: 0xDD97,
	36668 - 11905: 0xDD98,
	36669 - 11905: 0xDD99,
	36670 - 11905: 0xDD9A,
	36671 - 11905: 0xDD9B,
	36672 - 11905: 0xDD9C,
	36673 - 11905: 0xDD9D,
	36674 - 11905: 0xDD9E,
	36675 - 11905: 0xDD9F,
	36676 - 11905: 0xDDA0,
	36677 - 11905: 0xDE40,
	36678 - 11905: 0xDE41,
	36679 - 11905: 0xDE42,
	36680 - 11905: 0xDE43,
	36681 - 11905: 0xDE44,
	36682 - 11905: 0xDE45,
	36683 - 11905: 0xDE46,
	36684 - 11905: 0xDE47,
	36685 - 11905: 0xDE48,
	36686 - 11905: 0xDE49,
	36687 - 11905: 0xDE4A,
	36688 - 11905: 0xDE4B,
	36689 - 11905: 0xDE4C,
	36690 - 11905: 0xDE4D,
	36691 - 11905: 0xDE4E,
	36692 - 11905: 0xDE4F,
	36693 - 11905: 0xDE50,
	36694 - 11905: 0xDE51,
	36695 - 11905: 0xDE52,
	36696 - 11905: 0xDE53,
	36697 - 11905: 0xDE54,
	36698 - 11905: 0xDE55,
	36699 - 11905: 0xDE56,
	36700 - 11905: 0xDE57,
	36701 - 11905: 0xDE58,
	36702 - 11905: 0xDE59,
	36703 - 11905: 0xDE5A,
	36704 - 11905: 0xDE5B,
	36705 - 11905: 0xDE5C,
	36706 - 11905: 0xDE5D,
	36707 - 11905: 0xDE5E,
	36708 - 11905: 0xDE5F,
	36709 - 11905: 0xDE60,
	36710 - 11905: 0xB3B5,
	36711 - 11905: 0xD4FE,
	36712 - 11905: 0xB9EC,
	36713 - 11905: 0xD0F9,
	36714 - 11905: 0xDE61,
	36715 - 11905: 0xE9ED,
	36716 - 11905: 0xD7AA,
	36717 - 11905: 0xE9EE,
	36718 - 11905: 0xC2D6,
	36719 - 11905: 0xC8ED,
	36720 - 11905: 0xBAE4,
	36721 - 11905: 0xE9EF,
	36722 - 11905: 0xE9F0,
	36723 - 11905: 0xE9F1,
	36724 - 11905: 0xD6E1,
	36725 - 11905: 0xE9F2,
	36726 - 11905: 0xE9F3,
	36727 - 11905: 0xE9F5,
	36728 - 11905: 0xE9F4,
	36729 - 11905: 0xE9F6,
	36730 - 11905: 0xE9F7,
	36731 - 11905: 0xC7E1,
	36732 - 11905: 0xE9F8,
	36733 - 11905: 0xD4D8,
	36734 - 11905: 0xE9F9,
	36735 - 11905: 0xBDCE,
	36736 - 11905: 0xDE62,
	36737 - 11905: 0xE9FA,
	36738 - 11905: 0xE9FB,
	36739 - 11905: 0xBDCF,
	36740 - 11905: 0xE9FC,
	36741 - 11905: 0xB8A8,
	36742 - 11905: 0xC1BE,
	36743 - 11905: 0xE9FD,
	36744 - 11905: 0xB1B2,
	36745 - 11905: 0xBBD4,
	36746 - 11905: 0xB9F5,
	36747 - 11905: 0xE9FE,
	36748 - 11905: 0xDE63,
	36749 - 11905: 0xEAA1,
	36750 - 11905: 0xEAA2,
	36751 - 11905: 0xEAA3,
	36752 - 11905: 0xB7F8,
	36753 - 11905: 0xBCAD,
	36754 - 11905: 0xDE64,
	36755 - 11905: 0xCAE4,
	36756 - 11905: 0xE0CE,
	36757 - 11905: 0xD4AF,
	36758 - 11905: 0xCFBD,
	36759 - 11905: 0xD5B7,
	36760 - 11905: 0xEAA4,
	36761 - 11905: 0xD5DE,
	36762 - 11905: 0xEAA5,
	36763 - 11905: 0xD0C1,
	36764 - 11905: 0xB9BC,
	36765 - 11905: 0xDE65,
	36766 - 11905: 0xB4C7,
	36767 - 11905: 0xB1D9,
	36768 - 11905: 0xDE66,
	36769 - 11905: 0xDE67,
	36770 - 11905: 0xDE68,
	36771 - 11905: 0xC0B1,
	36772 - 11905: 0xDE69,
	36773 - 11905: 0xDE6A,
	36774 - 11905: 0xDE6B,
	36775 - 11905: 0xDE6C,
	36776 - 11905: 0xB1E6,
	36777 - 11905: 0xB1E7,
	36778 - 11905: 0xDE6D,
	36779 - 11905: 0xB1E8,
	36780 - 11905: 0xDE6E,
	36781 - 11905: 0xDE6F,
	36782 - 11905: 0xDE70,
	36783 - 11905: 0xDE71,
	36784 - 11905: 0xB3BD,
	36785 - 11905: 0xC8E8,
	36786 - 11905: 0xDE72,
	36787 - 11905: 0xDE73,
	36788 - 11905: 0xDE74,
	36789 - 11905: 0xDE75,
	36790 - 11905: 0xE5C1,
	36791 - 11905: 0xDE76,
	36792 - 11905: 0xDE77,
	36793 - 11905: 0xB1DF,
	36794 - 11905: 0xDE78,
	36795 - 11905: 0xDE79,
	36796 - 11905: 0xDE7A,
	36797 - 11905: 0xC1C9,
	36798 - 11905: 0xB4EF,
	36799 - 11905: 0xDE7B,
	36800 - 11905: 0xDE7C,
	36801 - 11905: 0xC7A8,
	36802 - 11905: 0xD3D8,
	36803 - 11905: 0xDE7D,
	36804 - 11905: 0xC6F9,
	36805 - 11905: 0xD1B8,
	36806 - 11905: 0xDE7E,
	36807 - 11905: 0xB9FD,
	36808 - 11905: 0xC2F5,
	36809 - 11905: 0xDE80,
	36810 - 11905: 0xDE81,
	36811 - 11905: 0xDE82,
	36812 - 11905: 0xDE83,
	36813 - 11905: 0xDE84,
	36814 - 11905: 0xD3AD,
	36815 - 11905: 0xDE85,
	36816 - 11905: 0xD4CB,
	36817 - 11905: 0xBDFC,
	36818 - 11905: 0xDE86,
	36819 - 11905: 0xE5C2,
	36820 - 11905: 0xB7B5,
	36821 - 11905: 0xE5C3,
	36822 - 11905: 0xDE87,
	36823 - 11905: 0xDE88,
	36824 - 11905: 0xBBB9,
	36825 - 11905: 0xD5E2,
	36826 - 11905: 0xDE89,
	36827 - 11905: 0xBDF8,
	36828 - 11905: 0xD4B6,
	36829 - 11905: 0xCEA5,
	36830 - 11905: 0xC1AC,
	36831 - 11905: 0xB3D9,
	36832 - 11905: 0xDE8A,
	36833 - 11905: 0xDE8B,
	36834 - 11905: 0xCCF6,
	36835 - 11905: 0xDE8C,
	36836 - 11905: 0xE5C6,
	36837 - 11905: 0xE5C4,
	36838 - 11905: 0xE5C8,
	36839 - 11905: 0xDE8D,
	36840 - 11905: 0xE5CA,
	36841 - 11905: 0xE5C7,
	36842 - 11905: 0xB5CF,
	36843 - 11905: 0xC6C8,
	36844 - 11905: 0xDE8E,
	36845 - 11905: 0xB5FC,
	36846 - 11905: 0xE5C5,
	36847 - 11905: 0xDE8F,
	36848 - 11905: 0xCAF6,
	36849 - 11905: 0xDE90,
	36850 - 11905: 0xDE91,
	36851 - 11905: 0xE5C9,
	36852 - 11905: 0xDE92,
	36853 - 11905: 0xDE93,
	36854 - 11905: 0xDE94,
	36855 - 11905: 0xC3D4,
	36856 - 11905: 0xB1C5,
	36857 - 11905: 0xBCA3,
	36858 - 11905: 0xDE95,
	36859 - 11905: 0xDE96,
	36860 - 11905: 0xDE97,
	36861 - 11905: 0xD7B7,
	36862 - 11905: 0xDE98,
	36863 - 11905: 0xDE99,
	36864 - 11905: 0xCDCB,
	36865 - 11905: 0xCBCD,
	36866 - 11905: 0xCACA,
	36867 - 11905: 0xCCD3,
	36868 - 11905: 0xE5CC,
	36869 - 11905: 0xE5CB,
	36870 - 11905: 0xC4E6,
	36871 - 11905: 0xDE9A,
	36872 - 11905: 0xDE9B,
	36873 - 11905: 0xD1A1,
	36874 - 11905: 0xD1B7,
	36875 - 11905: 0xE5CD,
	36876 - 11905: 0xDE9C,
	36877 - 11905: 0xE5D0,
	36878 - 11905: 0xDE9D,
	36879 - 11905: 0xCDB8,
	36880 - 11905: 0xD6F0,
	36881 - 11905: 0xE5CF,
	36882 - 11905: 0xB5DD,
	36883 - 11905: 0xDE9E,
	36884 - 11905: 0xCDBE,
	36885 - 11905: 0xDE9F,
	36886 - 11905: 0xE5D1,
	36887 - 11905: 0xB6BA,
	36888 - 11905: 0xDEA0,
	36889 - 11905: 0xDF40,
	36890 - 11905: 0xCDA8,
	36891 - 11905: 0xB9E4,
	36892 - 11905: 0xDF41,
	36893 - 11905: 0xCAC5,
	36894 - 11905: 0xB3D1,
	36895 - 11905: 0xCBD9,
	36896 - 11905: 0xD4EC,
	36897 - 11905: 0xE5D2,
	36898 - 11905: 0xB7EA,
	36899 - 11905: 0xDF42,
	36900 - 11905: 0xDF43,
	36901 - 11905: 0xDF44,
	36902 - 11905: 0xE5CE,
	36903 - 11905: 0xDF45,
	36904 - 11905: 0xDF46,
	36905 - 11905: 0xDF47,
	36906 - 11905: 0xDF48,
	36907 - 11905: 0xDF49,
	36908 - 11905: 0xDF4A,
	36909 - 11905: 0xE5D5,
	36910 - 11905: 0xB4FE,
	36911 - 11905: 0xE5D6,
	36912 - 11905: 0xDF4B,
	36913 - 11905: 0xDF4C,
	36914 - 11905: 0xDF4D,
	36915 - 11905: 0xDF4E,
	36916 - 11905: 0xDF4F,
	36917 - 11905: 0xE5D3,
	36918 - 11905: 0xE5D4,
	36919 - 11905: 0xDF50,
	36920 - 11905: 0xD2DD,
	36921 - 11905: 0xDF51,
	36922 - 11905: 0xDF52,
	36923 - 11905: 0xC2DF,
	36924 - 11905: 0xB1C6,
	36925 - 11905: 0xDF53,
	36926 - 11905: 0xD3E2,
	36927 - 11905: 0xDF54,
	36928 - 11905: 0xDF55,
	36929 - 11905: 0xB6DD,
	36930 - 11905: 0xCBEC,
	36931 - 11905: 0xDF56,
	36932 - 11905: 0xE5D7,
	36933 - 11905: 0xDF57,
	36934 - 11905: 0xDF58,
	36935 - 11905: 0xD3F6,
	36936 - 11905: 0xDF59,
	36937 - 11905: 0xDF5A,
	36938 - 11905: 0xDF5B,
	36939 - 11905: 0xDF5C,
	36940 - 11905: 0xDF5D,
	36941 - 11905: 0xB1E9,
	36942 - 11905: 0xDF5E,
	36943 - 11905: 0xB6F4,
	36944 - 11905: 0xE5DA,
	36945 - 11905: 0xE5D8,
	36946 - 11905: 0xE5D9,
	36947 - 11905: 0xB5C0,
	36948 - 11905: 0xDF5F,
	36949 - 11905: 0xDF60,
	36950 - 11905: 0xDF61,
	36951 - 11905: 0xD2C5,
	36952 - 11905: 0xE5DC,
	36953 - 11905: 0xDF62,
	36954 - 11905: 0xDF63,
	36955 - 11905: 0xE5DE,
	36956 - 11905: 0xDF64,
	36957 - 11905: 0xDF65,
	36958 - 11905: 0xDF66,
	36959 - 11905: 0xDF67,
	36960 - 11905: 0xDF68,
	36961 - 11905: 0xDF69,
	36962 - 11905: 0xE5DD,
	36963 - 11905: 0xC7B2,
	36964 - 11905: 0xDF6A,
	36965 - 11905: 0xD2A3,
	36966 - 11905: 0xDF6B,
	36967 - 11905: 0xDF6C,
	36968 - 11905: 0xE5DB,
	36969 - 11905: 0xDF6D,
	36970 - 11905: 0xDF6E,
	36971 - 11905: 0xDF6F,
	36972 - 11905: 0xDF70,
	36973 - 11905: 0xD4E2,
	36974 - 11905: 0xD5DA,
	36975 - 11905: 0xDF71,
	36976 - 11905: 0xDF72,
	36977 - 11905: 0xDF73,
	36978 - 11905: 0xDF74,
	36979 - 11905: 0xDF75,
	36980 - 11905: 0xE5E0,
	36981 - 11905: 0xD7F1,
	36982 - 11905: 0xDF76,
	36983 - 11905: 0xDF77,
	36984 - 11905: 0xDF78,
	36985 - 11905: 0xDF79,
	36986 - 11905: 0xDF7A,
	36987 - 11905: 0xDF7B,
	36988 - 11905: 0xDF7C,
	36989 - 11905: 0xE5E1,
	36990 - 11905: 0xDF7D,
	36991 - 11905: 0xB1DC,
	36992 - 11905: 0xD1FB,
	36993 - 11905: 0xDF7E,
	36994 - 11905: 0xE5E2,
	36995 - 11905: 0xE5E4,
	36996 - 11905: 0xDF80,
	36997 - 11905: 0xDF81,
	36998 - 11905: 0xDF82,
	36999 - 11905: 0xDF83,
	37000 - 11905: 0xE5E3,
	37001 - 11905: 0xDF84,
	37002 - 11905: 0xDF85,
	37003 - 11905: 0xE5E5,
	37004 - 11905: 0xDF86,
	37005 - 11905: 0xDF87,
	37006 - 11905: 0xDF88,
	37007 - 11905: 0xDF89,
	37008 - 11905: 0xDF8A,
	37009 - 11905: 0xD2D8,
	37010 - 11905: 0xDF8B,
	37011 - 11905: 0xB5CB,
	37012 - 11905: 0xDF8C,
	37013 - 11905: 0xE7DF,
	37014 - 11905: 0xDF8D,
	37015 - 11905: 0xDAF5,
	37016 - 11905: 0xDF8E,
	37017 - 11905: 0xDAF8,
	37018 - 11905: 0xDF8F,
	37019 - 11905: 0xDAF6,
	37020 - 11905: 0xDF90,
	37021 - 11905: 0xDAF7,
	37022 - 11905: 0xDF91,
	37023 - 11905: 0xDF92,
	37024 - 11905: 0xDF93,
	37025 - 11905: 0xDAFA,
	37026 - 11905: 0xD0CF,
	37027 - 11905: 0xC4C7,
	37028 - 11905: 0xDF94,
	37029 - 11905: 0xDF95,
	37030 - 11905: 0xB0EE,
	37031 - 11905: 0xDF96,
	37032 - 11905: 0xDF97,
	37033 - 11905: 0xDF98,
	37034 - 11905: 0xD0B0,
	37035 - 11905: 0xDF99,
	37036 - 11905: 0xDAF9,
	37037 - 11905: 0xDF9A,
	37038 - 11905: 0xD3CA,
	37039 - 11905: 0xBAAA,
	37040 - 11905: 0xDBA2,
	37041 - 11905: 0xC7F1,
	37042 - 11905: 0xDF9B,
	37043 - 11905: 0xDAFC,
	37044 - 11905: 0xDAFB,
	37045 - 11905: 0xC9DB,
	37046 - 11905: 0xDAFD,
	37047 - 11905: 0xDF9C,
	37048 - 11905: 0xDBA1,
	37049 - 11905: 0xD7DE,
	37050 - 11905: 0xDAFE,
	37051 - 11905: 0xC1DA,
	37052 - 11905: 0xDF9D,
	37053 - 11905: 0xDF9E,
	37054 - 11905: 0xDBA5,
	37055 - 11905: 0xDF9F,
	37056 - 11905: 0xDFA0,
	37057 - 11905: 0xD3F4,
	37058 - 11905: 0xE040,
	37059 - 11905: 0xE041,
	37060 - 11905: 0xDBA7,
	37061 - 11905: 0xDBA4,
	37062 - 11905: 0xE042,
	37063 - 11905: 0xDBA8,
	37064 - 11905: 0xE043,
	37065 - 11905: 0xE044,
	37066 - 11905: 0xBDBC,
	37067 - 11905: 0xE045,
	37068 - 11905: 0xE046,
	37069 - 11905: 0xE047,
	37070 - 11905: 0xC0C9,
	37071 - 11905: 0xDBA3,
	37072 - 11905: 0xDBA6,
	37073 - 11905: 0xD6A3,
	37074 - 11905: 0xE048,
	37075 - 11905: 0xDBA9,
	37076 - 11905: 0xE049,
	37077 - 11905: 0xE04A,
	37078 - 11905: 0xE04B,
	37079 - 11905: 0xDBAD,
	37080 - 11905: 0xE04C,
	37081 - 11905: 0xE04D,
	37082 - 11905: 0xE04E,
	37083 - 11905: 0xDBAE,
	37084 - 11905: 0xDBAC,
	37085 - 11905: 0xBAC2,
	37086 - 11905: 0xE04F,
	37087 - 11905: 0xE050,
	37088 - 11905: 0xE051,
	37089 - 11905: 0xBFA4,
	37090 - 11905: 0xDBAB,
	37091 - 11905: 0xE052,
	37092 - 11905: 0xE053,
	37093 - 11905: 0xE054,
	37094 - 11905: 0xDBAA,
	37095 - 11905: 0xD4C7,
	37096 - 11905: 0xB2BF,
	37097 - 11905: 0xE055,
	37098 - 11905: 0xE056,
	37099 - 11905: 0xDBAF,
	37100 - 11905: 0xE057,
	37101 - 11905: 0xB9F9,
	37102 - 11905: 0xE058,
	37103 - 11905: 0xDBB0,
	37104 - 11905: 0xE059,
	37105 - 11905: 0xE05A,
	37106 - 11905: 0xE05B,
	37107 - 11905: 0xE05C,
	37108 - 11905: 0xB3BB,
	37109 - 11905: 0xE05D,
	37110 - 11905: 0xE05E,
	37111 - 11905: 0xE05F,
	37112 - 11905: 0xB5A6,
	37113 - 11905: 0xE060,
	37114 - 11905: 0xE061,
	37115 - 11905: 0xE062,
	37116 - 11905: 0xE063,
	37117 - 11905: 0xB6BC,
	37118 - 11905: 0xDBB1,
	37119 - 11905: 0xE064,
	37120 - 11905: 0xE065,
	37121 - 11905: 0xE066,
	37122 - 11905: 0xB6F5,
	37123 - 11905: 0xE067,
	37124 - 11905: 0xDBB2,
	37125 - 11905: 0xE068,
	37126 - 11905: 0xE069,
	37127 - 11905: 0xE06A,
	37128 - 11905: 0xE06B,
	37129 - 11905: 0xE06C,
	37130 - 11905: 0xE06D,
	37131 - 11905: 0xE06E,
	37132 - 11905: 0xE06F,
	37133 - 11905: 0xE070,
	37134 - 11905: 0xE071,
	37135 - 11905: 0xE072,
	37136 - 11905: 0xE073,
	37137 - 11905: 0xE074,
	37138 - 11905: 0xE075,
	37139 - 11905: 0xE076,
	37140 - 11905: 0xE077,
	37141 - 11905: 0xE078,
	37142 - 11905: 0xE079,
	37143 - 11905: 0xE07A,
	37144 - 11905: 0xE07B,
	37145 - 11905: 0xB1C9,
	37146 - 11905: 0xE07C,
	37147 - 11905: 0xE07D,
	37148 - 11905: 0xE07E,
	37149 - 11905: 0xE080,
	37150 - 11905: 0xDBB4,
	37151 - 11905: 0xE081,
	37152 - 11905: 0xE082,
	37153 - 11905: 0xE083,
	37154 - 11905: 0xDBB3,
	37155 - 11905: 0xDBB5,
	37156 - 11905: 0xE084,
	37157 - 11905: 0xE085,
	37158 - 11905: 0xE086,
	37159 - 11905: 0xE087,
	37160 - 11905: 0xE088,
	37161 - 11905: 0xE089,
	37162 - 11905: 0xE08A,
	37163 - 11905: 0xE08B,
	37164 - 11905: 0xE08C,
	37165 - 11905: 0xE08D,
	37166 - 11905: 0xE08E,
	37167 - 11905: 0xDBB7,
	37168 - 11905: 0xE08F,
	37169 - 11905: 0xDBB6,
	37170 - 11905: 0xE090,
	37171 - 11905: 0xE091,
	37172 - 11905: 0xE092,
	37173 - 11905: 0xE093,
	37174 - 11905: 0xE094,
	37175 - 11905: 0xE095,
	37176 - 11905: 0xE096,
	37177 - 11905: 0xDBB8,
	37178 - 11905: 0xE097,
	37179 - 11905: 0xE098,
	37180 - 11905: 0xE099,
	37181 - 11905: 0xE09A,
	37182 - 11905: 0xE09B,
	37183 - 11905: 0xE09C,
	37184 - 11905: 0xE09D,
	37185 - 11905: 0xE09E,
	37186 - 11905: 0xE09F,
	37187 - 11905: 0xDBB9,
	37188 - 11905: 0xE0A0,
	37189 - 11905: 0xE140,
	37190 - 11905: 0xDBBA,
	37191 - 11905: 0xE141,
	37192 - 11905: 0xE142,
	37193 - 11905: 0xD3CF,
	37194 - 11905: 0xF4FA,
	37195 - 11905: 0xC7F5,
	37196 - 11905: 0xD7C3,
	37197 - 11905: 0xC5E4,
	37198 - 11905: 0xF4FC,
	37199 - 11905: 0xF4FD,
	37200 - 11905: 0xF4FB,
	37201 - 11905: 0xE143,
	37202 - 11905: 0xBEC6,
	37203 - 11905: 0xE144,
	37204 - 11905: 0xE145,
	37205 - 11905: 0xE146,
	37206 - 11905: 0xE147,
	37207 - 11905: 0xD0EF,
	37208 - 11905: 0xE148,
	37209 - 11905: 0xE149,
	37210 - 11905: 0xB7D3,
	37211 - 11905: 0xE14A,
	37212 - 11905: 0xE14B,
	37213 - 11905: 0xD4CD,
	37214 - 11905: 0xCCAA,
	37215 - 11905: 0xE14C,
	37216 - 11905: 0xE14D,
	37217 - 11905: 0xF5A2,
	37218 - 11905: 0xF5A1,
	37219 - 11905: 0xBAA8,
	37220 - 11905: 0xF4FE,
	37221 - 11905: 0xCBD6,
	37222 - 11905: 0xE14E,
	37223 - 11905: 0xE14F,
	37224 - 11905: 0xE150,
	37225 - 11905: 0xF5A4,
	37226 - 11905: 0xC0D2,
	37227 - 11905: 0xE151,
	37228 - 11905: 0xB3EA,
	37229 - 11905: 0xE152,
	37230 - 11905: 0xCDAA,
	37231 - 11905: 0xF5A5,
	37232 - 11905: 0xF5A3,
	37233 - 11905: 0xBDB4,
	37234 - 11905: 0xF5A8,
	37235 - 11905: 0xE153,
	37236 - 11905: 0xF5A9,
	37237 - 11905: 0xBDCD,
	37238 - 11905: 0xC3B8,
	37239 - 11905: 0xBFE1,
	37240 - 11905: 0xCBE1,
	37241 - 11905: 0xF5AA,
	37242 - 11905: 0xE154,
	37243 - 11905: 0xE155,
	37244 - 11905: 0xE156,
	37245 - 11905: 0xF5A6,
	37246 - 11905: 0xF5A7,
	37247 - 11905: 0xC4F0,
	37248 - 11905: 0xE157,
	37249 - 11905: 0xE158,
	37250 - 11905: 0xE159,
	37251 - 11905: 0xE15A,
	37252 - 11905: 0xE15B,
	37253 - 11905: 0xF5AC,
	37254 - 11905: 0xE15C,
	37255 - 11905: 0xB4BC,
	37256 - 11905: 0xE15D,
	37257 - 11905: 0xD7ED,
	37258 - 11905: 0xE15E,
	37259 - 11905: 0xB4D7,
	37260 - 11905: 0xF5AB,
	37261 - 11905: 0xF5AE,
	37262 - 11905: 0xE15F,
	37263 - 11905: 0xE160,
	37264 - 11905: 0xF5AD,
	37265 - 11905: 0xF5AF,
	37266 - 11905: 0xD0D1,
	37267 - 11905: 0xE161,
	37268 - 11905: 0xE162,
	37269 - 11905: 0xE163,
	37270 - 11905: 0xE164,
	37271 - 11905: 0xE165,
	37272 - 11905: 0xE166,
	37273 - 11905: 0xE167,
	37274 - 11905: 0xC3D1,
	37275 - 11905: 0xC8A9,
	37276 - 11905: 0xE168,
	37277 - 11905: 0xE169,
	37278 - 11905: 0xE16A,
	37279 - 11905: 0xE16B,
	37280 - 11905: 0xE16C,
	37281 - 11905: 0xE16D,
	37282 - 11905: 0xF5B0,
	37283 - 11905: 0xF5B1,
	37284 - 11905: 0xE16E,
	37285 - 11905: 0xE16F,
	37286 - 11905: 0xE170,
	37287 - 11905: 0xE171,
	37288 - 11905: 0xE172,
	37289 - 11905: 0xE173,
	37290 - 11905: 0xF5B2,
	37291 - 11905: 0xE174,
	37292 - 11905: 0xE175,
	37293 - 11905: 0xF5B3,
	37294 - 11905: 0xF5B4,
	37295 - 11905: 0xF5B5,
	37296 - 11905: 0xE176,
	37297 - 11905: 0xE177,
	37298 - 11905: 0xE178,
	37299 - 11905: 0xE179,
	37300 - 11905: 0xF5B7,
	37301 - 11905: 0xF5B6,
	37302 - 11905: 0xE17A,
	37303 - 11905: 0xE17B,
	37304 - 11905: 0xE17C,
	37305 - 11905: 0xE17D,
	37306 - 11905: 0xF5B8,
	37307 - 11905: 0xE17E,
	37308 - 11905: 0xE180,
	37309 - 11905: 0xE181,
	37310 - 11905: 0xE182,
	37311 - 11905: 0xE183,
	37312 - 11905: 0xE184,
	37313 - 11905: 0xE185,
	37314 - 11905: 0xE186,
	37315 - 11905: 0xE187,
	37316 - 11905: 0xE188,
	37317 - 11905: 0xE189,
	37318 - 11905: 0xE18A,
	37319 - 11905: 0xB2C9,
	37320 - 11905: 0xE18B,
	37321 - 11905: 0xD3D4,
	37322 - 11905: 0xCACD,
	37323 - 11905: 0xE18C,
	37324 - 11905: 0xC0EF,
	37325 - 11905: 0xD6D8,
	37326 - 11905: 0xD2B0,
	37327 - 11905: 0xC1BF,
	37328 - 11905: 0xE18D,
	37329 - 11905: 0xBDF0,
	37330 - 11905: 0xE18E,
	37331 - 11905: 0xE18F,
	37332 - 11905: 0xE190,
	37333 - 11905: 0xE191,
	37334 - 11905: 0xE192,
	37335 - 11905: 0xE193,
	37336 - 11905: 0xE194,
	37337 - 11905: 0xE195,
	37338 - 11905: 0xE196,
	37339 - 11905: 0xE197,
	37340 - 11905: 0xB8AA,
	37341 - 11905: 0xE198,
	37342 - 11905: 0xE199,
	37343 - 11905: 0xE19A,
	37344 - 11905: 0xE19B,
	37345 - 11905: 0xE19C,
	37346 - 11905: 0xE19D,
	37347 - 11905: 0xE19E,
	37348 - 11905: 0xE19F,
	37349 - 11905: 0xE1A0,
	37350 - 11905: 0xE240,
	37351 - 11905: 0xE241,
	37352 - 11905: 0xE242,
	37353 - 11905: 0xE243,
	37354 - 11905: 0xE244,
	37355 - 11905: 0xE245,
	37356 - 11905: 0xE246,
	37357 - 11905: 0xE247,
	37358 - 11905: 0xE248,
	37359 - 11905: 0xE249,
	37360 - 11905: 0xE24A,
	37361 - 11905: 0xE24B,
	37362 - 11905: 0xE24C,
	37363 - 11905: 0xE24D,
	37364 - 11905: 0xE24E,
	37365 - 11905: 0xE24F,
	37366 - 11905: 0xE250,
	37367 - 11905: 0xE251,
	37368 - 11905: 0xE252,
	37369 - 11905: 0xE253,
	37370 - 11905: 0xE254,
	37371 - 11905: 0xE255,
	37372 - 11905: 0xE256,
	37373 - 11905: 0xE257,
	37374 - 11905: 0xE258,
	37375 - 11905: 0xE259,
	37376 - 11905: 0xE25A,
	37377 - 11905: 0xE25B,
	37378 - 11905: 0xE25C,
	37379 - 11905: 0xE25D,
	37380 - 11905: 0xE25E,
	37381 - 11905: 0xE25F,
	37382 - 11905: 0xE260,
	37383 - 11905: 0xE261,
	37384 - 11905: 0xE262,
	37385 - 11905: 0xE263,
	37386 - 11905: 0xE264,
	37387 - 11905: 0xE265,
	37388 - 11905: 0xE266,
	37389 - 11905: 0xE267,
	37390 - 11905: 0xE268,
	37391 - 11905: 0xE269,
	37392 - 11905: 0xE26A,
	37393 - 11905: 0xE26B,
	37394 - 11905: 0xE26C,
	37395 - 11905: 0xE26D,
	37396 - 11905: 0xE26E,
	37397 - 11905: 0xE26F,
	37398 - 11905: 0xE270,
	37399 - 11905: 0xE271,
	37400 - 11905: 0xE272,
	37401 - 11905: 0xE273,
	37402 - 11905: 0xE274,
	37403 - 11905: 0xE275,
	37404 - 11905: 0xE276,
	37405 - 11905: 0xE277,
	37406 - 11905: 0xE278,
	37407 - 11905: 0xE279,
	37408 - 11905: 0xE27A,
	37409 - 11905: 0xE27B,
	37410 - 11905: 0xE27C,
	37411 - 11905: 0xE27D,
	37412 - 11905: 0xE27E,
	37413 - 11905: 0xE280,
	37414 - 11905: 0xE281,
	37415 - 11905: 0xE282,
	37416 - 11905: 0xE283,
	37417 - 11905: 0xE284,
	37418 - 11905: 0xE285,
	37419 - 11905: 0xE286,
	37420 - 11905: 0xE287,
	37421 - 11905: 0xE288,
	37422 - 11905: 0xE289,
	37423 - 11905: 0xE28A,
	37424 - 11905: 0xE28B,
	37425 - 11905: 0xE28C,
	37426 - 11905: 0xE28D,
	37427 - 11905: 0xE28E,
	37428 - 11905: 0xE28F,
	37429 - 11905: 0xE290,
	37430 - 11905: 0xE291,
	37431 - 11905: 0xE292,
	37432 - 11905: 0xE293,
	37433 - 11905: 0xE294,
	37434 - 11905: 0xE295,
	37435 - 11905: 0xE296,
	37436 - 11905: 0xE297,
	37437 - 11905: 0xE298,
	37438 - 11905: 0xE299,
	37439 - 11905: 0xE29A,
	37440 - 11905: 0xE29B,
	37441 - 11905: 0xE29C,
	37442 - 11905: 0xE29D,
	37443 - 11905: 0xE29E,
	37444 - 11905: 0xE29F,
	37445 - 11905: 0xE2A0,
	37446 - 11905: 0xE340,
	37447 - 11905: 0xE341,
	37448 - 11905: 0xE342,
	37449 - 11905: 0xE343,
	37450 - 11905: 0xE344,
	37451 - 11905: 0xE345,
	37452 - 11905: 0xE346,
	37453 - 11905: 0xE347,
	37454 - 11905: 0xE348,
	37455 - 11905: 0xE349,
	37456 - 11905: 0xE34A,
	37457 - 11905: 0xE34B,
	37458 - 11905: 0xE34C,
	37459 - 11905: 0xE34D,
	37460 - 11905: 0xE34E,
	37461 - 11905: 0xE34F,
	37462 - 11905: 0xE350,
	37463 - 11905: 0xE351,
	37464 - 11905: 0xE352,
	37465 - 11905: 0xE353,
	37466 - 11905: 0xE354,
	37467 - 11905: 0xE355,
	37468 - 11905: 0xE356,
	37469 - 11905: 0xE357,
	37470 - 11905: 0xE358,
	37471 - 11905: 0xE359,
	37472 - 11905: 0xE35A,
	37473 - 11905: 0xE35B,
	37474 - 11905: 0xE35C,
	37475 - 11905: 0xE35D,
	37476 - 11905: 0xE35E,
	37477 - 11905: 0xE35F,
	37478 - 11905: 0xE360,
	37479 - 11905: 0xE361,
	37480 - 11905: 0xE362,
	37481 - 11905: 0xE363,
	37482 - 11905: 0xE364,
	37483 - 11905: 0xE365,
	37484 - 11905: 0xE366,
	37485 - 11905: 0xE367,
	37486 - 11905: 0xE368,
	37487 - 11905: 0xE369,
	37488 - 11905: 0xE36A,
	37489 - 11905: 0xE36B,
	37490 - 11905: 0xE36C,
	37491 - 11905: 0xE36D,
	37492 - 11905: 0xBCF8,
	37493 - 11905: 0xE36E,
	37494 - 11905: 0xE36F,
	37495 - 11905: 0xE370,
	37496 - 11905: 0xE371,
	37497 - 11905: 0xE372,
	37498 - 11905: 0xE373,
	37499 - 11905: 0xE374,
	37500 - 11905: 0xE375,
	37501 - 11905: 0xE376,
	37502 - 11905: 0xE377,
	37503 - 11905: 0xE378,
	37504 - 11905: 0xE379,
	37505 - 11905: 0xE37A,
	37506 - 11905: 0xE37B,
	37507 - 11905: 0xE37C,
	37508 - 11905: 0xE37D,
	37509 - 11905: 0xE37E,
	37510 - 11905: 0xE380,
	37511 - 11905: 0xE381,
	37512 - 11905: 0xE382,
	37513 - 11905: 0xE383,
	37514 - 11905: 0xE384,
	37515 - 11905: 0xE385,
	37516 - 11905: 0xE386,
	37517 - 11905: 0xE387,
	37518 - 11905: 0xF6C6,
	37519 - 11905: 0xE388,
	37520 - 11905: 0xE389,
	37521 - 11905: 0xE38A,
	37522 - 11905: 0xE38B,
	37523 - 11905: 0xE38C,
	37524 - 11905: 0xE38D,
	37525 - 11905: 0xE38E,
	37526 - 11905: 0xE38F,
	37527 - 11905: 0xE390,
	37528 - 11905: 0xE391,
	37529 - 11905: 0xE392,
	37530 - 11905: 0xE393,
	37531 - 11905: 0xE394,
	37532 - 11905: 0xE395,
	37533 - 11905: 0xE396,
	37534 - 11905: 0xE397,
	37535 - 11905: 0xE398,
	37536 - 11905: 0xE399,
	37537 - 11905: 0xE39A,
	37538 - 11905: 0xE39B,
	37539 - 11905: 0xE39C,
	37540 - 11905: 0xE39D,
	37541 - 11905: 0xE39E,
	37542 - 11905: 0xE39F,
	37543 - 11905: 0xE3A0,
	37544 - 11905: 0xE440,
	37545 - 11905: 0xE441,
	37546 - 11905: 0xE442,
	37547 - 11905: 0xE443,
	37548 - 11905: 0xE444,
	37549 - 11905: 0xE445,
	37550 - 11905: 0xF6C7,
	37551 - 11905: 0xE446,
	37552 - 11905: 0xE447,
	37553 - 11905: 0xE448,
	37554 - 11905: 0xE449,
	37555 - 11905: 0xE44A,
	37556 - 11905: 0xE44B,
	37557 - 11905: 0xE44C,
	37558 - 11905: 0xE44D,
	37559 - 11905: 0xE44E,
	37560 - 11905: 0xE44F,
	37561 - 11905: 0xE450,
	37562 - 11905: 0xE451,
	37563 - 11905: 0xE452,
	37564 - 11905: 0xE453,
	37565 - 11905: 0xE454,
	37566 - 11905: 0xE455,
	37567 - 11905: 0xE456,
	37568 - 11905: 0xE457,
	37569 - 11905: 0xE458,
	37570 - 11905: 0xE459,
	37571 - 11905: 0xE45A,
	37572 - 11905: 0xE45B,
	37573 - 11905: 0xE45C,
	37574 - 11905: 0xE45D,
	37575 - 11905: 0xE45E,
	37576 - 11905: 0xF6C8,
	37577 - 11905: 0xE45F,
	37578 - 11905: 0xE460,
	37579 - 11905: 0xE461,
	37580 - 11905: 0xE462,
	37581 - 11905: 0xE463,
	37582 - 11905: 0xE464,
	37583 - 11905: 0xE465,
	37584 - 11905: 0xE466,
	37585 - 11905: 0xE467,
	37586 - 11905: 0xE468,
	37587 - 11905: 0xE469,
	37588 - 11905: 0xE46A,
	37589 - 11905: 0xE46B,
	37590 - 11905: 0xE46C,
	37591 - 11905: 0xE46D,
	37592 - 11905: 0xE46E,
	37593 - 11905: 0xE46F,
	37594 - 11905: 0xE470,
	37595 - 11905: 0xE471,
	37596 - 11905: 0xE472,
	37597 - 11905: 0xE473,
	37598 - 11905: 0xE474,
	37599 - 11905: 0xE475,
	37600 - 11905: 0xE476,
	37601 - 11905: 0xE477,
	37602 - 11905: 0xE478,
	37603 - 11905: 0xE479,
	37604 - 11905: 0xE47A,
	37605 - 11905: 0xE47B,
	37606 - 11905: 0xE47C,
	37607 - 11905: 0xE47D,
	37608 - 11905: 0xE47E,
	37609 - 11905: 0xE480,
	37610 - 11905: 0xE481,
	37611 - 11905: 0xE482,
	37612 - 11905: 0xE483,
	37613 - 11905: 0xE484,
	37614 - 11905: 0xE485,
	37615 - 11905: 0xE486,
	37616 - 11905: 0xE487,
	37617 - 11905: 0xE488,
	37618 - 11905: 0xE489,
	37619 - 11905: 0xE48A,
	37620 - 11905: 0xE48B,
	37621 - 11905: 0xE48C,
	37622 - 11905: 0xE48D,
	37623 - 11905: 0xE48E,
	37624 - 11905: 0xE48F,
	37625 - 11905: 0xE490,
	37626 - 11905: 0xE491,
	37627 - 11905: 0xE492,
	37628 - 11905: 0xE493,
	37629 - 11905: 0xE494,
	37630 - 11905: 0xE495,
	37631 - 11905: 0xE496,
	37632 - 11905: 0xE497,
	37633 - 11905: 0xE498,
	37634 - 11905: 0xE499,
	37635 - 11905: 0xE49A,
	37636 - 11905: 0xE49B,
	37637 - 11905: 0xE49C,
	37638 - 11905: 0xE49D,
	37639 - 11905: 0xE49E,
	37640 - 11905: 0xE49F,
	37641 - 11905: 0xE4A0,
	37642 - 11905: 0xE540,
	37643 - 11905: 0xE541,
	37644 - 11905: 0xE542,
	37645 - 11905: 0xE543,
	37646 - 11905: 0xE544,
	37647 - 11905: 0xE545,
	37648 - 11905: 0xE546,
	37649 - 11905: 0xE547,
	37650 - 11905: 0xE548,
	37651 - 11905: 0xE549,
	37652 - 11905: 0xE54A,
	37653 - 11905: 0xE54B,
	37654 - 11905: 0xE54C,
	37655 - 11905: 0xE54D,
	37656 - 11905: 0xE54E,
	37657 - 11905: 0xE54F,
	37658 - 11905: 0xE550,
	37659 - 11905: 0xE551,
	37660 - 11905: 0xE552,
	37661 - 11905: 0xE553,
	37662 - 11905: 0xE554,
	37663 - 11905: 0xE555,
	37664 - 11905: 0xE556,
	37665 - 11905: 0xE557,
	37666 - 11905: 0xE558,
	37667 - 11905: 0xE559,
	37668 - 11905: 0xE55A,
	37669 - 11905: 0xE55B,
	37670 - 11905: 0xE55C,
	37671 - 11905: 0xE55D,
	37672 - 11905: 0xE55E,
	37673 - 11905: 0xE55F,
	37674 - 11905: 0xE560,
	37675 - 11905: 0xE561,
	37676 - 11905: 0xE562,
	37677 - 11905: 0xE563,
	37678 - 11905: 0xE564,
	37679 - 11905: 0xE565,
	37680 - 11905: 0xE566,
	37681 - 11905: 0xE567,
	37682 - 11905: 0xE568,
	37683 - 11905: 0xE569,
	37684 - 11905: 0xE56A,
	37685 - 11905: 0xE56B,
	37686 - 11905: 0xE56C,
	37687 - 11905: 0xE56D,
	37688 - 11905: 0xE56E,
	37689 - 11905: 0xE56F,
	37690 - 11905: 0xE570,
	37691 - 11905: 0xE571,
	37692 - 11905: 0xE572,
	37693 - 11905: 0xE573,
	37694 - 11905: 0xF6C9,
	37695 - 11905: 0xE574,
	37696 - 11905: 0xE575,
	37697 - 11905: 0xE576,
	37698 - 11905: 0xE577,
	37699 - 11905: 0xE578,
	37700 - 11905: 0xE579,
	37701 - 11905: 0xE57A,
	37702 - 11905: 0xE57B,
	37703 - 11905: 0xE57C,
	37704 - 11905: 0xE57D,
	37705 - 11905: 0xE57E,
	37706 - 11905: 0xE580,
	37707 - 11905: 0xE581,
	37708 - 11905: 0xE582,
	37709 - 11905: 0xE583,
	37710 - 11905: 0xE584,
	37711 - 11905: 0xE585,
	37712 - 11905: 0xE586,
	37713 - 11905: 0xE587,
	37714 - 11905: 0xE588,
	37715 - 11905: 0xE589,
	37716 - 11905: 0xE58A,
	37717 - 11905: 0xE58B,
	37718 - 11905: 0xE58C,
	37719 - 11905: 0xE58D,
	37720 - 11905: 0xE58E,
	37721 - 11905: 0xE58F,
	37722 - 11905: 0xE590,
	37723 - 11905: 0xE591,
	37724 - 11905: 0xE592,
	37725 - 11905: 0xE593,
	37726 - 11905: 0xE594,
	37727 - 11905: 0xE595,
	37728 - 11905: 0xE596,
	37729 - 11905: 0xE597,
	37730 - 11905: 0xE598,
	37731 - 11905: 0xE599,
	37732 - 11905: 0xE59A,
	37733 - 11905: 0xE59B,
	37734 - 11905: 0xE59C,
	37735 - 11905: 0xE59D,
	37736 - 11905: 0xE59E,
	37737 - 11905: 0xE59F,
	37738 - 11905: 0xF6CA,
	37739 - 11905: 0xE5A0,
	37740 - 11905: 0xE640,
	37741 - 11905: 0xE641,
	37742 - 11905: 0xE642,
	37743 - 11905: 0xE643,
	37744 - 11905: 0xE644,
	37745 - 11905: 0xE645,
	37746 - 11905: 0xE646,
	37747 - 11905: 0xE647,
	37748 - 11905: 0xE648,
	37749 - 11905: 0xE649,
	37750 - 11905: 0xE64A,
	37751 - 11905: 0xE64B,
	37752 - 11905: 0xE64C,
	37753 - 11905: 0xE64D,
	37754 - 11905: 0xE64E,
	37755 - 11905: 0xE64F,
	37756 - 11905: 0xE650,
	37757 - 11905: 0xE651,
	37758 - 11905: 0xE652,
	37759 - 11905: 0xE653,
	37760 - 11905: 0xE654,
	37761 - 11905: 0xE655,
	37762 - 11905: 0xE656,
	37763 - 11905: 0xE657,
	37764 - 11905: 0xE658,
	37765 - 11905: 0xE659,
	37766 - 11905: 0xE65A,
	37767 - 11905: 0xE65B,
	37768 - 11905: 0xE65C,
	37769 - 11905: 0xE65D,
	37770 - 11905: 0xE65E,
	37771 - 11905: 0xE65F,
	37772 - 11905: 0xE660,
	37773 - 11905: 0xE661,
	37774 - 11905: 0xE662,
	37775 - 11905: 0xF6CC,
	37776 - 11905: 0xE663,
	37777 - 11905: 0xE664,
	37778 - 11905: 0xE665,
	37779 - 11905: 0xE666,
	37780 - 11905: 0xE667,
	37781 - 11905: 0xE668,
	37782 - 11905: 0xE669,
	37783 - 11905: 0xE66A,
	37784 - 11905: 0xE66B,
	37785 - 11905: 0xE66C,
	37786 - 11905: 0xE66D,
	37787 - 11905: 0xE66E,
	37788 - 11905: 0xE66F,
	37789 - 11905: 0xE670,
	37790 - 11905: 0xE671,
	37791 - 11905: 0xE672,
	37792 - 11905: 0xE673,
	37793 - 11905: 0xE674,
	37794 - 11905: 0xE675,
	37795 - 11905: 0xE676,
	37796 - 11905: 0xE677,
	37797 - 11905: 0xE678,
	37798 - 11905: 0xE679,
	37799 - 11905: 0xE67A,
	37800 - 11905: 0xE67B,
	37801 - 11905: 0xE67C,
	37802 - 11905: 0xE67D,
	37803 - 11905: 0xE67E,
	37804 - 11905: 0xE680,
	37805 - 11905: 0xE681,
	37806 - 11905: 0xE682,
	37807 - 11905: 0xE683,
	37808 - 11905: 0xE684,
	37809 - 11905: 0xE685,
	37810 - 11905: 0xE686,
	37811 - 11905: 0xE687,
	37812 - 11905: 0xE688,
	37813 - 11905: 0xE689,
	37814 - 11905: 0xE68A,
	37815 - 11905: 0xE68B,
	37816 - 11905: 0xE68C,
	37817 - 11905: 0xE68D,
	37818 - 11905: 0xE68E,
	37819 - 11905: 0xE68F,
	37820 - 11905: 0xE690,
	37821 - 11905: 0xE691,
	37822 - 11905: 0xE692,
	37823 - 11905: 0xE693,
	37824 - 11905: 0xE694,
	37825 - 11905: 0xE695,
	37826 - 11905: 0xE696,
	37827 - 11905: 0xE697,
	37828 - 11905: 0xE698,
	37829 - 11905: 0xE699,
	37830 - 11905: 0xE69A,
	37831 - 11905: 0xE69B,
	37832 - 11905: 0xE69C,
	37833 - 11905: 0xE69D,
	37834 - 11905: 0xF6CB,
	37835 - 11905: 0xE69E,
	37836 - 11905: 0xE69F,
	37837 - 11905: 0xE6A0,
	37838 - 11905: 0xE740,
	37839 - 11905: 0xE741,
	37840 - 11905: 0xE742,
	37841 - 11905: 0xE743,
	37842 - 11905: 0xE744,
	37843 - 11905: 0xE745,
	37844 - 11905: 0xE746,
	37845 - 11905: 0xE747,
	37846 - 11905: 0xF7E9,
	37847 - 11905: 0xE748,
	37848 - 11905: 0xE749,
	37849 - 11905: 0xE74A,
	37850 - 11905: 0xE74B,
	37851 - 11905: 0xE74C,
	37852 - 11905: 0xE74D,
	37853 - 11905: 0xE74E,
	37854 - 11905: 0xE74F,
	37855 - 11905: 0xE750,
	37856 - 11905: 0xE751,
	37857 - 11905: 0xE752,
	37858 - 11905: 0xE753,
	37859 - 11905: 0xE754,
	37860 - 11905: 0xE755,
	37861 - 11905: 0xE756,
	37862 - 11905: 0xE757,
	37863 - 11905: 0xE758,
	37864 - 11905: 0xE759,
	37865 - 11905: 0xE75A,
	37866 - 11905: 0xE75B,
	37867 - 11905: 0xE75C,
	37868 - 11905: 0xE75D,
	37869 - 11905: 0xE75E,
	37870 - 11905: 0xE75F,
	37871 - 11905: 0xE760,
	37872 - 11905: 0xE761,
	37873 - 11905: 0xE762,
	37874 - 11905: 0xE763,
	37875 - 11905: 0xE764,
	37876 - 11905: 0xE765,
	37877 - 11905: 0xE766,
	37878 - 11905: 0xE767,
	37879 - 11905: 0xE768,
	37880 - 11905: 0xE769,
	37881 - 11905: 0xE76A,
	37882 - 11905: 0xE76B,
	37883 - 11905: 0xE76C,
	37884 - 11905: 0xE76D,
	37885 - 11905: 0xE76E,
	37886 - 11905: 0xE76F,
	37887 - 11905: 0xE770,
	37888 - 11905: 0xE771,
	37889 - 11905: 0xE772,
	37890 - 11905: 0xE773,
	37891 - 11905: 0xE774,
	37892 - 11905: 0xE775,
	37893 - 11905: 0xE776,
	37894 - 11905: 0xE777,
	37895 - 11905: 0xE778,
	37896 - 11905: 0xE779,
	37897 - 11905: 0xE77A,
	37898 - 11905: 0xE77B,
	37899 - 11905: 0xE77C,
	37900 - 11905: 0xE77D,
	37901 - 11905: 0xE77E,
	37902 - 11905: 0xE780,
	37903 - 11905: 0xE781,
	37904 - 11905: 0xE782,
	37905 - 11905: 0xE783,
	37906 - 11905: 0xE784,
	37907 - 11905: 0xE785,
	37908 - 11905: 0xE786,
	37909 - 11905: 0xE787,
	37910 - 11905: 0xE788,
	37911 - 11905: 0xE789,
	37912 - 11905: 0xE78A,
	37913 - 11905: 0xE78B,
	37914 - 11905: 0xE78C,
	37915 - 11905: 0xE78D,
	37916 - 11905: 0xE78E,
	37917 - 11905: 0xE78F,
	37918 - 11905: 0xE790,
	37919 - 11905: 0xE791,
	37920 - 11905: 0xE792,
	37921 - 11905: 0xE793,
	37922 - 11905: 0xE794,
	37923 - 11905: 0xE795,
	37924 - 11905: 0xE796,
	37925 - 11905: 0xE797,
	37926 - 11905: 0xE798,
	37927 - 11905: 0xE799,
	37928 - 11905: 0xE79A,
	37929 - 11905: 0xE79B,
	37930 - 11905: 0xE79C,
	37931 - 11905: 0xE79D,
	37932 - 11905: 0xE79E,
	37933 - 11905: 0xE79F,
	37934 - 11905: 0xE7A0,
	37935 - 11905: 0xE840,
	37936 - 11905: 0xE841,
	37937 - 11905: 0xE842,
	37938 - 11905: 0xE843,
	37939 - 11905: 0xE844,
	37940 - 11905: 0xE845,
	37941 - 11905: 0xE846,
	37942 - 11905: 0xE847,
	37943 - 11905: 0xE848,
	37944 - 11905: 0xE849,
	37945 - 11905: 0xE84A,
	37946 - 11905: 0xE84B,
	37947 - 11905: 0xE84C,
	37948 - 11905: 0xE84D,
	37949 - 11905: 0xE84E,
	37950 - 11905: 0xF6CD,
	37951 - 11905: 0xE84F,
	37952 - 11905: 0xE850,
	37953 - 11905: 0xE851,
	37954 - 11905: 0xE852,
	37955 - 11905: 0xE853,
	37956 - 11905: 0xE854,
	37957 - 11905: 0xE855,
	37958 - 11905: 0xE856,
	37959 - 11905: 0xE857,
	37960 - 11905: 0xE858,
	37961 - 11905: 0xE859,
	37962 - 11905: 0xE85A,
	37963 - 11905: 0xE85B,
	37964 - 11905: 0xE85C,
	37965 - 11905: 0xE85D,
	37966 - 11905: 0xE85E,
	37967 - 11905: 0xE85F,
	37968 - 11905: 0xE860,
	37969 - 11905: 0xE861,
	37970 - 11905: 0xE862,
	37971 - 11905: 0xE863,
	37972 - 11905: 0xE864,
	37973 - 11905: 0xE865,
	37974 - 11905: 0xE866,
	37975 - 11905: 0xE867,
	37976 - 11905: 0xE868,
	37977 - 11905: 0xE869,
	37978 - 11905: 0xE86A,
	37979 - 11905: 0xE86B,
	37980 - 11905: 0xE86C,
	37981 - 11905: 0xE86D,
	37982 - 11905: 0xE86E,
	37983 - 11905: 0xE86F,
	37984 - 11905: 0xE870,
	37985 - 11905: 0xE871,
	37986 - 11905: 0xE872,
	37987 - 11905: 0xE873,
	37988 - 11905: 0xE874,
	37989 - 11905: 0xE875,
	37990 - 11905: 0xE876,
	37991 - 11905: 0xE877,
	37992 - 11905: 0xE878,
	37993 - 11905: 0xE879,
	37994 - 11905: 0xE87A,
	37995 - 11905: 0xF6CE,
	37996 - 11905: 0xE87B,
	37997 - 11905: 0xE87C,
	37998 - 11905: 0xE87D,
	37999 - 11905: 0xE87E,
	38000 - 11905: 0xE880,
	38001 - 11905: 0xE881,
	38002 - 11905: 0xE882,
	38003 - 11905: 0xE883,
	38004 - 11905: 0xE884,
	38005 - 11905: 0xE885,
	38006 - 11905: 0xE886,
	38007 - 11905: 0xE887,
	38008 - 11905: 0xE888,
	38009 - 11905: 0xE889,
	38010 - 11905: 0xE88A,
	38011 - 11905: 0xE88B,
	38012 - 11905: 0xE88C,
	38013 - 11905: 0xE88D,
	38014 - 11905: 0xE88E,
	38015 - 11905: 0xE88F,
	38016 - 11905: 0xE890,
	38017 - 11905: 0xE891,
	38018 - 11905: 0xE892,
	38019 - 11905: 0xE893,
	38020 - 11905: 0xE894,
	38021 - 11905: 0xEEC4,
	38022 - 11905: 0xEEC5,
	38023 - 11905: 0xEEC6,
	38024 - 11905: 0xD5EB,
	38025 - 11905: 0xB6A4,
	38026 - 11905: 0xEEC8,
	38027 - 11905: 0xEEC7,
	38028 - 11905: 0xEEC9,
	38029 - 11905: 0xEECA,
	38030 - 11905: 0xC7A5,
	38031 - 11905: 0xEECB,
	38032 - 11905: 0xEECC,
	38033 - 11905: 0xE895,
	38034 - 11905: 0xB7B0,
	38035 - 11905: 0xB5F6,
	38036 - 11905: 0xEECD,
	38037 - 11905: 0xEECF,
	38038 - 11905: 0xE896,
	38039 - 11905: 0xEECE,
	38040 - 11905: 0xE897,
	38041 - 11905: 0xB8C6,
	38042 - 11905: 0xEED0,
	38043 - 11905: 0xEED1,
	38044 - 11905: 0xEED2,
	38045 - 11905: 0xB6DB,
	38046 - 11905: 0xB3AE,
	38047 - 11905: 0xD6D3,
	38048 - 11905: 0xC4C6,
	38049 - 11905: 0xB1B5,
	38050 - 11905: 0xB8D6,
	38051 - 11905: 0xEED3,
	38052 - 11905: 0xEED4,
	38053 - 11905: 0xD4BF,
	38054 - 11905: 0xC7D5,
	38055 - 11905: 0xBEFB,
	38056 - 11905: 0xCED9,
	38057 - 11905: 0xB9B3,
	38058 - 11905: 0xEED6,
	38059 - 11905: 0xEED5,
	38060 - 11905: 0xEED8,
	38061 - 11905: 0xEED7,
	38062 - 11905: 0xC5A5,
	38063 - 11905: 0xEED9,
	38064 - 11905: 0xEEDA,
	38065 - 11905: 0xC7AE,
	38066 - 11905: 0xEEDB,
	38067 - 11905: 0xC7AF,
	38068 - 11905: 0xEEDC,
	38069 - 11905: 0xB2A7,
	38070 - 11905: 0xEEDD,
	38071 - 11905: 0xEEDE,
	38072 - 11905: 0xEEDF,
	38073 - 11905: 0xEEE0,
	38074 - 11905: 0xEEE1,
	38075 - 11905: 0xD7EA,
	38076 - 11905: 0xEEE2,
	38077 - 11905: 0xEEE3,
	38078 - 11905: 0xBCD8,
	38079 - 11905: 0xEEE4,
	38080 - 11905: 0xD3CB,
	38081 - 11905: 0xCCFA,
	38082 - 11905: 0xB2AC,
	38083 - 11905: 0xC1E5,
	38084 - 11905: 0xEEE5,
	38085 - 11905: 0xC7A6,
	38086 - 11905: 0xC3AD,
	38087 - 11905: 0xE898,
	38088 - 11905: 0xEEE6,
	38089 - 11905: 0xEEE7,
	38090 - 11905: 0xEEE8,
	38091 - 11905: 0xEEE9,
	38092 - 11905: 0xEEEA,
	38093 - 11905: 0xEEEB,
	38094 - 11905: 0xEEEC,
	38095 - 11905: 0xE899,
	38096 - 11905: 0xEEED,
	38097 - 11905: 0xEEEE,
	38098 - 11905: 0xEEEF,
	38099 - 11905: 0xE89A,
	38100 - 11905: 0xE89B,
	38101 - 11905: 0xEEF0,
	38102 - 11905: 0xEEF1,
	38103 - 11905: 0xEEF2,
	38104 - 11905: 0xEEF4,
	38105 - 11905: 0xEEF3,
	38106 - 11905: 0xE89C,
	38107 - 11905: 0xEEF5,
	38108 - 11905: 0xCDAD,
	38109 - 11905: 0xC2C1,
	38110 - 11905: 0xEEF6,
	38111 - 11905: 0xEEF7,
	38112 - 11905: 0xEEF8,
	38113 - 11905: 0xD5A1,
	38114 - 11905: 0xEEF9,
	38115 - 11905: 0xCFB3,
	38116 - 11905: 0xEEFA,
	38117 - 11905: 0xEEFB,
	38118 - 11905: 0xE89D,
	38119 - 11905: 0xEEFC,
	38120 - 11905: 0xEEFD,
	38121 - 11905: 0xEFA1,
	38122 - 11905: 0xEEFE,
	38123 - 11905: 0xEFA2,
	38124 - 11905: 0xB8F5,
	38125 - 11905: 0xC3FA,
	38126 - 11905: 0xEFA3,
	38127 - 11905: 0xEFA4,
	38128 - 11905: 0xBDC2,
	38129 - 11905: 0xD2BF,
	38130 - 11905: 0xB2F9,
	38131 - 11905: 0xEFA5,
	38132 - 11905: 0xEFA6,
	38133 - 11905: 0xEFA7,
	38134 - 11905: 0xD2F8,
	38135 - 11905: 0xEFA8,
	38136 - 11905: 0xD6FD,
	38137 - 11905: 0xEFA9,
	38138 - 11905: 0xC6CC,
	38139 - 11905: 0xE89E,
	38140 - 11905: 0xEFAA,
	38141 - 11905: 0xEFAB,
	38142 - 11905: 0xC1B4,
	38143 - 11905: 0xEFAC,
	38144 - 11905: 0xCFFA,
	38145 - 11905: 0xCBF8,
	38146 - 11905: 0xEFAE,
	38147 - 11905: 0xEFAD,
	38148 - 11905: 0xB3FA,
	38149 - 11905: 0xB9F8,
	38150 - 11905: 0xEFAF,
	38151 - 11905: 0xEFB0,
	38152 - 11905: 0xD0E2,
	38153 - 11905: 0xEFB1,
	38154 - 11905: 0xEFB2,
	38155 - 11905: 0xB7E6,
	38156 - 11905: 0xD0BF,
	38157 - 11905: 0xEFB3,
	38158 - 11905: 0xEFB4,
	38159 - 11905: 0xEFB5,
	38160 - 11905: 0xC8F1,
	38161 - 11905: 0xCCE0,
	38162 - 11905: 0xEFB6,
	38163 - 11905: 0xEFB7,
	38164 - 11905: 0xEFB8,
	38165 - 11905: 0xEFB9,
	38166 - 11905: 0xEFBA,
	38167 - 11905: 0xD5E0,
	38168 - 11905: 0xEFBB,
	38169 - 11905: 0xB4ED,
	38170 - 11905: 0xC3AA,
	38171 - 11905: 0xEFBC,
	38172 - 11905: 0xE89F,
	38173 - 11905: 0xEFBD,
	38174 - 11905: 0xEFBE,
	38175 - 11905: 0xEFBF,
	38176 - 11905: 0xE8A0,
	38177 - 11905: 0xCEFD,
	38178 - 11905: 0xEFC0,
	38179 - 11905: 0xC2E0,
	38180 - 11905: 0xB4B8,
	38181 - 11905: 0xD7B6,
	38182 - 11905: 0xBDF5,
	38183 - 11905: 0xE940,
	38184 - 11905: 0xCFC7,
	38185 - 11905: 0xEFC3,
	38186 - 11905: 0xEFC1,
	38187 - 11905: 0xEFC2,
	38188 - 11905: 0xEFC4,
	38189 - 11905: 0xB6A7,
	38190 - 11905: 0xBCFC,
	38191 - 11905: 0xBEE2,
	38192 - 11905: 0xC3CC,
	38193 - 11905: 0xEFC5,
	38194 - 11905: 0xEFC6,
	38195 - 11905: 0xE941,
	38196 - 11905: 0xEFC7,
	38197 - 11905: 0xEFCF,
	38198 - 11905: 0xEFC8,
	38199 - 11905: 0xEFC9,
	38200 - 11905: 0xEFCA,
	38201 - 11905: 0xC7C2,
	38202 - 11905: 0xEFF1,
	38203 - 11905: 0xB6CD,
	38204 - 11905: 0xEFCB,
	38205 - 11905: 0xE942,
	38206 - 11905: 0xEFCC,
	38207 - 11905: 0xEFCD,
	38208 - 11905: 0xB6C6,
	38209 - 11905: 0xC3BE,
	38210 - 11905: 0xEFCE,
	38211 - 11905: 0xE943,
	38212 - 11905: 0xEFD0,
	38213 - 11905: 0xEFD1,
	38214 - 11905: 0xEFD2,
	38215 - 11905: 0xD5F2,
	38216 - 11905: 0xE944,
	38217 - 11905: 0xEFD3,
	38218 - 11905: 0xC4F7,
	38219 - 11905: 0xE945,
	38220 - 11905: 0xEFD4,
	38221 - 11905: 0xC4F8,
	38222 - 11905: 0xEFD5,
	38223 - 11905: 0xEFD6,
	38224 - 11905: 0xB8E4,
	38225 - 11905: 0xB0F7,
	38226 - 11905: 0xEFD7,
	38227 - 11905: 0xEFD8,
	38228 - 11905: 0xEFD9,
	38229 - 11905: 0xE946,
	38230 - 11905: 0xEFDA,
	38231 - 11905: 0xEFDB,
	38232 - 11905: 0xEFDC,
	38233 - 11905: 0xEFDD,
	38234 - 11905: 0xE947,
	38235 - 11905: 0xEFDE,
	38236 - 11905: 0xBEB5,
	38237 - 11905: 0xEFE1,
	38238 - 11905: 0xEFDF,
	38239 - 11905: 0xEFE0,
	38240 - 11905: 0xE948,
	38241 - 11905: 0xEFE2,
	38242 - 11905: 0xEFE3,
	38243 - 11905: 0xC1CD,
	38244 - 11905: 0xEFE4,
	38245 - 11905: 0xEFE5,
	38246 - 11905: 0xEFE6,
	38247 - 11905: 0xEFE7,
	38248 - 11905: 0xEFE8,
	38249 - 11905: 0xEFE9,
	38250 - 11905: 0xEFEA,
	38251 - 11905: 0xEFEB,
	38252 - 11905: 0xEFEC,
	38253 - 11905: 0xC0D8,
	38254 - 11905: 0xE949,
	38255 - 11905: 0xEFED,
	38256 - 11905: 0xC1AD,
	38257 - 11905: 0xEFEE,
	38258 - 11905: 0xEFEF,
	38259 - 11905: 0xEFF0,
	38260 - 11905: 0xE94A,
	38261 - 11905: 0xE94B,
	38262 - 11905: 0xCFE2,
	38263 - 11905: 0xE94C,
	38264 - 11905: 0xE94D,
	38265 - 11905: 0xE94E,
	38266 - 11905: 0xE94F,
	38267 - 11905: 0xE950,
	38268 - 11905: 0xE951,
	38269 - 11905: 0xE952,
	38270 - 11905: 0xE953,
	38271 - 11905: 0xB3A4,
	38272 - 11905: 0xE954,
	38273 - 11905: 0xE955,
	38274 - 11905: 0xE956,
	38275 - 11905: 0xE957,
	38276 - 11905: 0xE958,
	38277 - 11905: 0xE959,
	38278 - 11905: 0xE95A,
	38279 - 11905: 0xE95B,
	38280 - 11905: 0xE95C,
	38281 - 11905: 0xE95D,
	38282 - 11905: 0xE95E,
	38283 - 11905: 0xE95F,
	38284 - 11905: 0xE960,
	38285 - 11905: 0xE961,
	38286 - 11905: 0xE962,
	38287 - 11905: 0xE963,
	38288 - 11905: 0xE964,
	38289 - 11905: 0xE965,
	38290 - 11905: 0xE966,
	38291 - 11905: 0xE967,
	38292 - 11905: 0xE968,
	38293 - 11905: 0xE969,
	38294 - 11905: 0xE96A,
	38295 - 11905: 0xE96B,
	38296 - 11905: 0xE96C,
	38297 - 11905: 0xE96D,
	38298 - 11905: 0xE96E,
	38299 - 11905: 0xE96F,
	38300 - 11905: 0xE970,
	38301 - 11905: 0xE971,
	38302 - 11905: 0xE972,
	38303 - 11905: 0xE973,
	38304 - 11905: 0xE974,
	38305 - 11905: 0xE975,
	38306 - 11905: 0xE976,
	38307 - 11905: 0xE977,
	38308 - 11905: 0xE978,
	38309 - 11905: 0xE979,
	38310 - 11905: 0xE97A,
	38311 - 11905: 0xE97B,
	38312 - 11905: 0xE97C,
	38313 - 11905: 0xE97D,
	38314 - 11905: 0xE97E,
	38315 - 11905: 0xE980,
	38316 - 11905: 0xE981,
	38317 - 11905: 0xE982,
	38318 - 11905: 0xE983,
	38319 - 11905: 0xE984,
	38320 - 11905: 0xE985,
	38321 - 11905: 0xE986,
	38322 - 11905: 0xE987,
	38323 - 11905: 0xE988,
	38324 - 11905: 0xE989,
	38325 - 11905: 0xE98A,
	38326 - 11905: 0xE98B,
	38327 - 11905: 0xE98C,
	38328 - 11905: 0xE98D,
	38329 - 11905: 0xE98E,
	38330 - 11905: 0xE98F,
	38331 - 11905: 0xE990,
	38332 - 11905: 0xE991,
	38333 - 11905: 0xE992,
	38334 - 11905: 0xE993,
	38335 - 11905: 0xE994,
	38336 - 11905: 0xE995,
	38337 - 11905: 0xE996,
	38338 - 11905: 0xE997,
	38339 - 11905: 0xE998,
	38340 - 11905: 0xE999,
	38341 - 11905: 0xE99A,
	38342 - 11905: 0xE99B,
	38343 - 11905: 0xE99C,
	38344 - 11905: 0xE99D,
	38345 - 11905: 0xE99E,
	38346 - 11905: 0xE99F,
	38347 - 11905: 0xE9A0,
	38348 - 11905: 0xEA40,
	38349 - 11905: 0xEA41,
	38350 - 11905: 0xEA42,
	38351 - 11905: 0xEA43,
	38352 - 11905: 0xEA44,
	38353 - 11905: 0xEA45,
	38354 - 11905: 0xEA46,
	38355 - 11905: 0xEA47,
	38356 - 11905: 0xEA48,
	38357 - 11905: 0xEA49,
	38358 - 11905: 0xEA4A,
	38359 - 11905: 0xEA4B,
	38360 - 11905: 0xEA4C,
	38361 - 11905: 0xEA4D,
	38362 - 11905: 0xEA4E,
	38363 - 11905: 0xEA4F,
	38364 - 11905: 0xEA50,
	38365 - 11905: 0xEA51,
	38366 - 11905: 0xEA52,
	38367 - 11905: 0xEA53,
	38368 - 11905: 0xEA54,
	38369 - 11905: 0xEA55,
	38370 - 11905: 0xEA56,
	38371 - 11905: 0xEA57,
	38372 - 11905: 0xEA58,
	38373 - 11905: 0xEA59,
	38374 - 11905: 0xEA5A,
	38375 - 11905: 0xEA5B,
	38376 - 11905: 0xC3C5,
	38377 - 11905: 0xE3C5,
	38378 - 11905: 0xC9C1,
	38379 - 11905: 0xE3C6,
	38380 - 11905: 0xEA5C,
	38381 - 11905: 0xB1D5,
	38382 - 11905: 0xCECA,
	38383 - 11905: 0xB4B3,
	38384 - 11905: 0xC8F2,
	38385 - 11905: 0xE3C7,
	38386 - 11905: 0xCFD0,
	38387 - 11905: 0xE3C8,
	38388 - 11905: 0xBCE4,
	38389 - 11905: 0xE3C9,
	38390 - 11905: 0xE3CA,
	38391 - 11905: 0xC3C6,
	38392 - 11905: 0xD5A2,
	38393 - 11905: 0xC4D6,
	38394 - 11905: 0xB9EB,
	38395 - 11905: 0xCEC5,
	38396 - 11905: 0xE3CB,
	38397 - 11905: 0xC3F6,
	38398 - 11905: 0xE3CC,
	38399 - 11905: 0xEA5D,
	38400 - 11905: 0xB7A7,
	38401 - 11905: 0xB8F3,
	38402 - 11905: 0xBAD2,
	38403 - 11905: 0xE3CD,
	38404 - 11905: 0xE3CE,
	38405 - 11905: 0xD4C4,
	38406 - 11905: 0xE3CF,
	38407 - 11905: 0xEA5E,
	38408 - 11905: 0xE3D0,
	38409 - 11905: 0xD1CB,
	38410 - 11905: 0xE3D1,
	38411 - 11905: 0xE3D2,
	38412 - 11905: 0xE3D3,
	38413 - 11905: 0xE3D4,
	38414 - 11905: 0xD1D6,
	38415 - 11905: 0xE3D5,
	38416 - 11905: 0xB2FB,
	38417 - 11905: 0xC0BB,
	38418 - 11905: 0xE3D6,
	38419 - 11905: 0xEA5F,
	38420 - 11905: 0xC0AB,
	38421 - 11905: 0xE3D7,
	38422 - 11905: 0xE3D8,
	38423 - 11905: 0xE3D9,
	38424 - 11905: 0xEA60,
	38425 - 11905: 0xE3DA,
	38426 - 11905: 0xE3DB,
	38427 - 11905: 0xEA61,
	38428 - 11905: 0xB8B7,
	38429 - 11905: 0xDAE2,
	38430 - 11905: 0xEA62,
	38431 - 11905: 0xB6D3,
	38432 - 11905: 0xEA63,
	38433 - 11905: 0xDAE4,
	38434 - 11905: 0xDAE3,
	38435 - 11905: 0xEA64,
	38436 - 11905: 0xEA65,
	38437 - 11905: 0xEA66,
	38438 - 11905: 0xEA67,
	38439 - 11905: 0xEA68,
	38440 - 11905: 0xEA69,
	38441 - 11905: 0xEA6A,
	38442 - 11905: 0xDAE6,
	38443 - 11905: 0xEA6B,
	38444 - 11905: 0xEA6C,
	38445 - 11905: 0xEA6D,
	38446 - 11905: 0xC8EE,
	38447 - 11905: 0xEA6E,
	38448 - 11905: 0xEA6F,
	38449 - 11905: 0xDAE5,
	38450 - 11905: 0xB7C0,
	38451 - 11905: 0xD1F4,
	38452 - 11905: 0xD2F5,
	38453 - 11905: 0xD5F3,
	38454 - 11905: 0xBDD7,
	38455 - 11905: 0xEA70,
	38456 - 11905: 0xEA71,
	38457 - 11905: 0xEA72,
	38458 - 11905: 0xEA73,
	38459 - 11905: 0xD7E8,
	38460 - 11905: 0xDAE8,
	38461 - 11905: 0xDAE7,
	38462 - 11905: 0xEA74,
	38463 - 11905: 0xB0A2,
	38464 - 11905: 0xCDD3,
	38465 - 11905: 0xEA75,
	38466 - 11905: 0xDAE9,
	38467 - 11905: 0xEA76,
	38468 - 11905: 0xB8BD,
	38469 - 11905: 0xBCCA,
	38470 - 11905: 0xC2BD,
	38471 - 11905: 0xC2A4,
	38472 - 11905: 0xB3C2,
	38473 - 11905: 0xDAEA,
	38474 - 11905: 0xEA77,
	38475 - 11905: 0xC2AA,
	38476 - 11905: 0xC4B0,
	38477 - 11905: 0xBDB5,
	38478 - 11905: 0xEA78,
	38479 - 11905: 0xEA79,
	38480 - 11905: 0xCFDE,
	38481 - 11905: 0xEA7A,
	38482 - 11905: 0xEA7B,
	38483 - 11905: 0xEA7C,
	38484 - 11905: 0xDAEB,
	38485 - 11905: 0xC9C2,
	38486 - 11905: 0xEA7D,
	38487 - 11905: 0xEA7E,
	38488 - 11905: 0xEA80,
	38489 - 11905: 0xEA81,
	38490 - 11905: 0xEA82,
	38491 - 11905: 0xB1DD,
	38492 - 11905: 0xEA83,
	38493 - 11905: 0xEA84,
	38494 - 11905: 0xEA85,
	38495 - 11905: 0xDAEC,
	38496 - 11905: 0xEA86,
	38497 - 11905: 0xB6B8,
	38498 - 11905: 0xD4BA,
	38499 - 11905: 0xEA87,
	38500 - 11905: 0xB3FD,
	38501 - 11905: 0xEA88,
	38502 - 11905: 0xEA89,
	38503 - 11905: 0xDAED,
	38504 - 11905: 0xD4C9,
	38505 - 11905: 0xCFD5,
	38506 - 11905: 0xC5E3,
	38507 - 11905: 0xEA8A,
	38508 - 11905: 0xDAEE,
	38509 - 11905: 0xEA8B,
	38510 - 11905: 0xEA8C,
	38511 - 11905: 0xEA8D,
	38512 - 11905: 0xEA8E,
	38513 - 11905: 0xEA8F,
	38514 - 11905: 0xDAEF,
	38515 - 11905: 0xEA90,
	38516 - 11905: 0xDAF0,
	38517 - 11905: 0xC1EA,
	38518 - 11905: 0xCCD5,
	38519 - 11905: 0xCFDD,
	38520 - 11905: 0xEA91,
	38521 - 11905: 0xEA92,
	38522 - 11905: 0xEA93,
	38523 - 11905: 0xEA94,
	38524 - 11905: 0xEA95,
	38525 - 11905: 0xEA96,
	38526 - 11905: 0xEA97,
	38527 - 11905: 0xEA98,
	38528 - 11905: 0xEA99,
	38529 - 11905: 0xEA9A,
	38530 - 11905: 0xEA9B,
	38531 - 11905: 0xEA9C,
	38532 - 11905: 0xEA9D,
	38533 - 11905: 0xD3E7,
	38534 - 11905: 0xC2A1,
	38535 - 11905: 0xEA9E,
	38536 - 11905: 0xDAF1,
	38537 - 11905: 0xEA9F,
	38538 - 11905: 0xEAA0,
	38539 - 11905: 0xCBE5,
	38540 - 11905: 0xEB40,
	38541 - 11905: 0xDAF2,
	38542 - 11905: 0xEB41,
	38543 - 11905: 0xCBE6,
	38544 - 11905: 0xD2FE,
	38545 - 11905: 0xEB42,
	38546 - 11905: 0xEB43,
	38547 - 11905: 0xEB44,
	38548 - 11905: 0xB8F4,
	38549 - 11905: 0xEB45,
	38550 - 11905: 0xEB46,
	38551 - 11905: 0xDAF3,
	38552 - 11905: 0xB0AF,
	38553 - 11905: 0xCFB6,
	38554 - 11905: 0xEB47,
	38555 - 11905: 0xEB48,
	38556 - 11905: 0xD5CF,
	38557 - 11905: 0xEB49,
	38558 - 11905: 0xEB4A,
	38559 - 11905: 0xEB4B,
	38560 - 11905: 0xEB4C,
	38561 - 11905: 0xEB4D,
	38562 - 11905: 0xEB4E,
	38563 - 11905: 0xEB4F,
	38564 - 11905: 0xEB50,
	38565 - 11905: 0xEB51,
	38566 - 11905: 0xEB52,
	38567 - 11905: 0xCBED,
	38568 - 11905: 0xEB53,
	38569 - 11905: 0xEB54,
	38570 - 11905: 0xEB55,
	38571 - 11905: 0xEB56,
	38572 - 11905: 0xEB57,
	38573 - 11905: 0xEB58,
	38574 - 11905: 0xEB59,
	38575 - 11905: 0xEB5A,
	38576 - 11905: 0xDAF4,
	38577 - 11905: 0xEB5B,
	38578 - 11905: 0xEB5C,
	38579 - 11905: 0xE3C4,
	38580 - 11905: 0xEB5D,
	38581 - 11905: 0xEB5E,
	38582 - 11905: 0xC1A5,
	38583 - 11905: 0xEB5F,
	38584 - 11905: 0xEB60,
	38585 - 11905: 0xF6BF,
	38586 - 11905: 0xEB61,
	38587 - 11905: 0xEB62,
	38588 - 11905: 0xF6C0,
	38589 - 11905: 0xF6C1,
	38590 - 11905: 0xC4D1,
	38591 - 11905: 0xEB63,
	38592 - 11905: 0xC8B8,
	38593 - 11905: 0xD1E3,
	38594 - 11905: 0xEB64,
	38595 - 11905: 0xEB65,
	38596 - 11905: 0xD0DB,
	38597 - 11905: 0xD1C5,
	38598 - 11905: 0xBCAF,
	38599 - 11905: 0xB9CD,
	38600 - 11905: 0xEB66,
	38601 - 11905: 0xEFF4,
	38602 - 11905: 0xEB67,
	38603 - 11905: 0xEB68,
	38604 - 11905: 0xB4C6,
	38605 - 11905: 0xD3BA,
	38606 - 11905: 0xF6C2,
	38607 - 11905: 0xB3FB,
	38608 - 11905: 0xEB69,
	38609 - 11905: 0xEB6A,
	38610 - 11905: 0xF6C3,
	38611 - 11905: 0xEB6B,
	38612 - 11905: 0xEB6C,
	38613 - 11905: 0xB5F1,
	38614 - 11905: 0xEB6D,
	38615 - 11905: 0xEB6E,
	38616 - 11905: 0xEB6F,
	38617 - 11905: 0xEB70,
	38618 - 11905: 0xEB71,
	38619 - 11905: 0xEB72,
	38620 - 11905: 0xEB73,
	38621 - 11905: 0xEB74,
	38622 - 11905: 0xEB75,
	38623 - 11905: 0xEB76,
	38624 - 11905: 0xF6C5,
	38625 - 11905: 0xEB77,
	38626 - 11905: 0xEB78,
	38627 - 11905: 0xEB79,
	38628 - 11905: 0xEB7A,
	38629 - 11905: 0xEB7B,
	38630 - 11905: 0xEB7C,
	38631 - 11905: 0xEB7D,
	38632 - 11905: 0xD3EA,
	38633 - 11905: 0xF6A7,
	38634 - 11905: 0xD1A9,
	38635 - 11905: 0xEB7E,
	38636 - 11905: 0xEB80,
	38637 - 11905: 0xEB81,
	38638 - 11905: 0xEB82,
	38639 - 11905: 0xF6A9,
	38640 - 11905: 0xEB83,
	38641 - 11905: 0xEB84,
	38642 - 11905: 0xEB85,
	38643 - 11905: 0xF6A8,
	38644 - 11905: 0xEB86,
	38645 - 11905: 0xEB87,
	38646 - 11905: 0xC1E3,
	38647 - 11905: 0xC0D7,
	38648 - 11905: 0xEB88,
	38649 - 11905: 0xB1A2,
	38650 - 11905: 0xEB89,
	38651 - 11905: 0xEB8A,
	38652 - 11905: 0xEB8B,
	38653 - 11905: 0xEB8C,
	38654 - 11905: 0xCEED,
	38655 - 11905: 0xEB8D,
	38656 - 11905: 0xD0E8,
	38657 - 11905: 0xF6AB,
	38658 - 11905: 0xEB8E,
	38659 - 11905: 0xEB8F,
	38660 - 11905: 0xCFF6,
	38661 - 11905: 0xEB90,
	38662 - 11905: 0xF6AA,
	38663 - 11905: 0xD5F0,
	38664 - 11905: 0xF6AC,
	38665 - 11905: 0xC3B9,
	38666 - 11905: 0xEB91,
	38667 - 11905: 0xEB92,
	38668 - 11905: 0xEB93,
	38669 - 11905: 0xBBF4,
	38670 - 11905: 0xF6AE,
	38671 - 11905: 0xF6AD,
	38672 - 11905: 0xEB94,
	38673 - 11905: 0xEB95,
	38674 - 11905: 0xEB96,
	38675 - 11905: 0xC4DE,
	38676 - 11905: 0xEB97,
	38677 - 11905: 0xEB98,
	38678 - 11905: 0xC1D8,
	38679 - 11905: 0xEB99,
	38680 - 11905: 0xEB9A,
	38681 - 11905: 0xEB9B,
	38682 - 11905: 0xEB9C,
	38683 - 11905: 0xEB9D,
	38684 - 11905: 0xCBAA,
	38685 - 11905: 0xEB9E,
	38686 - 11905: 0xCFBC,
	38687 - 11905: 0xEB9F,
	38688 - 11905: 0xEBA0,
	38689 - 11905: 0xEC40,
	38690 - 11905: 0xEC41,
	38691 - 11905: 0xEC42,
	38692 - 11905: 0xEC43,
	38693 - 11905: 0xEC44,
	38694 - 11905: 0xEC45,
	38695 - 11905: 0xEC46,
	38696 - 11905: 0xEC47,
	38697 - 11905: 0xEC48,
	38698 - 11905: 0xF6AF,
	38699 - 11905: 0xEC49,
	38700 - 11905: 0xEC4A,
	38701 - 11905: 0xF6B0,
	38702 - 11905: 0xEC4B,
	38703 - 11905: 0xEC4C,
	38704 - 11905: 0xF6B1,
	38705 - 11905: 0xEC4D,
	38706 - 11905: 0xC2B6,
	38707 - 11905: 0xEC4E,
	38708 - 11905: 0xEC4F,
	38709 - 11905: 0xEC50,
	38710 - 11905: 0xEC51,
	38711 - 11905: 0xEC52,
	38712 - 11905: 0xB0D4,
	38713 - 11905: 0xC5F9,
	38714 - 11905: 0xEC53,
	38715 - 11905: 0xEC54,
	38716 - 11905: 0xEC55,
	38717 - 11905: 0xEC56,
	38718 - 11905: 0xF6B2,
	38719 - 11905: 0xEC57,
	38720 - 11905: 0xEC58,
	38721 - 11905: 0xEC59,
	38722 - 11905: 0xEC5A,
	38723 - 11905: 0xEC5B,
	38724 - 11905: 0xEC5C,
	38725 - 11905: 0xEC5D,
	38726 - 11905: 0xEC5E,
	38727 - 11905: 0xEC5F,
	38728 - 11905: 0xEC60,
	38729 - 11905: 0xEC61,
	38730 - 11905: 0xEC62,
	38731 - 11905: 0xEC63,
	38732 - 11905: 0xEC64,
	38733 - 11905: 0xEC65,
	38734 - 11905: 0xEC66,
	38735 - 11905: 0xEC67,
	38736 - 11905: 0xEC68,
	38737 - 11905: 0xEC69,
	38738 - 11905: 0xC7E0,
	38739 - 11905: 0xF6A6,
	38740 - 11905: 0xEC6A,
	38741 - 11905: 0xEC6B,
	38742 - 11905: 0xBEB8,
	38743 - 11905: 0xEC6C,
	38744 - 11905: 0xEC6D,
	38745 - 11905: 0xBEB2,
	38746 - 11905: 0xEC6E,
	38747 - 11905: 0xB5E5,
	38748 - 11905: 0xEC6F,
	38749 - 11905: 0xEC70,
	38750 - 11905: 0xB7C7,
	38751 - 11905: 0xEC71,
	38752 - 11905: 0xBFBF,
	38753 - 11905: 0xC3D2,
	38754 - 11905: 0xC3E6,
	38755 - 11905: 0xEC72,
	38756 - 11905: 0xEC73,
	38757 - 11905: 0xD8CC,
	38758 - 11905: 0xEC74,
	38759 - 11905: 0xEC75,
	38760 - 11905: 0xEC76,
	38761 - 11905: 0xB8EF,
	38762 - 11905: 0xEC77,
	38763 - 11905: 0xEC78,
	38764 - 11905: 0xEC79,
	38765 - 11905: 0xEC7A,
	38766 - 11905: 0xEC7B,
	38767 - 11905: 0xEC7C,
	38768 - 11905: 0xEC7D,
	38769 - 11905: 0xEC7E,
	38770 - 11905: 0xEC80,
	38771 - 11905: 0xBDF9,
	38772 - 11905: 0xD1A5,
	38773 - 11905: 0xEC81,
	38774 - 11905: 0xB0D0,
	38775 - 11905: 0xEC82,
	38776 - 11905: 0xEC83,
	38777 - 11905: 0xEC84,
	38778 - 11905: 0xEC85,
	38779 - 11905: 0xEC86,
	38780 - 11905: 0xF7B0,
	38781 - 11905: 0xEC87,
	38782 - 11905: 0xEC88,
	38783 - 11905: 0xEC89,
	38784 - 11905: 0xEC8A,
	38785 - 11905: 0xEC8B,
	38786 - 11905: 0xEC8C,
	38787 - 11905: 0xEC8D,
	38788 - 11905: 0xEC8E,
	38789 - 11905: 0xF7B1,
	38790 - 11905: 0xEC8F,
	38791 - 11905: 0xEC90,
	38792 - 11905: 0xEC91,
	38793 - 11905: 0xEC92,
	38794 - 11905: 0xEC93,
	38795 - 11905: 0xD0AC,
	38796 - 11905: 0xEC94,
	38797 - 11905: 0xB0B0,
	38798 - 11905: 0xEC95,
	38799 - 11905: 0xEC96,
	38800 - 11905: 0xEC97,
	38801 - 11905: 0xF7B2,
	38802 - 11905: 0xF7B3,
	38803 - 11905: 0xEC98,
	38804 - 11905: 0xF7B4,
	38805 - 11905: 0xEC99,
	38806 - 11905: 0xEC9A,
	38807 - 11905: 0xEC9B,
	38808 - 11905: 0xC7CA,
	38809 - 11905: 0xEC9C,
	38810 - 11905: 0xEC9D,
	38811 - 11905: 0xEC9E,
	38812 - 11905: 0xEC9F,
	38813 - 11905: 0xECA0,
	38814 - 11905: 0xED40,
	38815 - 11905: 0xED41,
	38816 - 11905: 0xBECF,
	38817 - 11905: 0xED42,
	38818 - 11905: 0xED43,
	38819 - 11905: 0xF7B7,
	38820 - 11905: 0xED44,
	38821 - 11905: 0xED45,
	38822 - 11905: 0xED46,
	38823 - 11905: 0xED47,
	38824 - 11905: 0xED48,
	38825 - 11905: 0xED49,
	38826 - 11905: 0xED4A,
	38827 - 11905: 0xF7B6,
	38828 - 11905: 0xED4B,
	38829 - 11905: 0xB1DE,
	38830 - 11905: 0xED4C,
	38831 - 11905: 0xF7B5,
	38832 - 11905: 0xED4D,
	38833 - 11905: 0xED4E,
	38834 - 11905: 0xF7B8,
	38835 - 11905: 0xED4F,
	38836 - 11905: 0xF7B9,
	38837 - 11905: 0xED50,
	38838 - 11905: 0xED51,
	38839 - 11905: 0xED52,
	38840 - 11905: 0xED53,
	38841 - 11905: 0xED54,
	38842 - 11905: 0xED55,
	38843 - 11905: 0xED56,
	38844 - 11905: 0xED57,
	38845 - 11905: 0xED58,
	38846 - 11905: 0xED59,
	38847 - 11905: 0xED5A,
	38848 - 11905: 0xED5B,
	38849 - 11905: 0xED5C,
	38850 - 11905: 0xED5D,
	38851 - 11905: 0xED5E,
	38852 - 11905: 0xED5F,
	38853 - 11905: 0xED60,
	38854 - 11905: 0xED61,
	38855 - 11905: 0xED62,
	38856 - 11905: 0xED63,
	38857 - 11905: 0xED64,
	38858 - 11905: 0xED65,
	38859 - 11905: 0xED66,
	38860 - 11905: 0xED67,
	38861 - 11905: 0xED68,
	38862 - 11905: 0xED69,
	38863 - 11905: 0xED6A,
	38864 - 11905: 0xED6B,
	38865 - 11905: 0xED6C,
	38866 - 11905: 0xED6D,
	38867 - 11905: 0xED6E,
	38868 - 11905: 0xED6F,
	38869 - 11905: 0xED70,
	38870 - 11905: 0xED71,
	38871 - 11905: 0xED72,
	38872 - 11905: 0xED73,
	38873 - 11905: 0xED74,
	38874 - 11905: 0xED75,
	38875 - 11905: 0xED76,
	38876 - 11905: 0xED77,
	38877 - 11905: 0xED78,
	38878 - 11905: 0xED79,
	38879 - 11905: 0xED7A,
	38880 - 11905: 0xED7B,
	38881 - 11905: 0xED7C,
	38882 - 11905: 0xED7D,
	38883 - 11905: 0xED7E,
	38884 - 11905: 0xED80,
	38885 - 11905: 0xED81,
	38886 - 11905: 0xCEA4,
	38887 - 11905: 0xC8CD,
	38888 - 11905: 0xED82,
	38889 - 11905: 0xBAAB,
	38890 - 11905: 0xE8B8,
	38891 - 11905: 0xE8B9,
	38892 - 11905: 0xE8BA,
	38893 - 11905: 0xBEC2,
	38894 - 11905: 0xED83,
	38895 - 11905: 0xED84,
	38896 - 11905: 0xED85,
	38897 - 11905: 0xED86,
	38898 - 11905: 0xED87,
	38899 - 11905: 0xD2F4,
	38900 - 11905: 0xED88,
	38901 - 11905: 0xD4CF,
	38902 - 11905: 0xC9D8,
	38903 - 11905: 0xED89,
	38904 - 11905: 0xED8A,
	38905 - 11905: 0xED8B,
	38906 - 11905: 0xED8C,
	38907 - 11905: 0xED8D,
	38908 - 11905: 0xED8E,
	38909 - 11905: 0xED8F,
	38910 - 11905: 0xED90,
	38911 - 11905: 0xED91,
	38912 - 11905: 0xED92,
	38913 - 11905: 0xED93,
	38914 - 11905: 0xED94,
	38915 - 11905: 0xED95,
	38916 - 11905: 0xED96,
	38917 - 11905: 0xED97,
	38918 - 11905: 0xED98,
	38919 - 11905: 0xED99,
	38920 - 11905: 0xED9A,
	38921 - 11905: 0xED9B,
	38922 - 11905: 0xED9C,
	38923 - 11905: 0xED9D,
	38924 - 11905: 0xED9E,
	38925 - 11905: 0xED9F,
	38926 - 11905: 0xEDA0,
	38927 - 11905: 0xEE40,
	38928 - 11905: 0xEE41,
	38929 - 11905: 0xEE42,
	38930 - 11905: 0xEE43,
	38931 - 11905: 0xEE44,
	38932 - 11905: 0xEE45,
	38933 - 11905: 0xEE46,
	38934 - 11905: 0xEE47,
	38935 - 11905: 0xEE48,
	38936 - 11905: 0xEE49,
	38937 - 11905: 0xEE4A,
	38938 - 11905: 0xEE4B,
	38939 - 11905: 0xEE4C,
	38940 - 11905: 0xEE4D,
	38941 - 11905: 0xEE4E,
	38942 - 11905: 0xEE4F,
	38943 - 11905: 0xEE50,
	38944 - 11905: 0xEE51,
	38945 - 11905: 0xEE52,
	38946 - 11905: 0xEE53,
	38947 - 11905: 0xEE54,
	38948 - 11905: 0xEE55,
	38949 - 11905: 0xEE56,
	38950 - 11905: 0xEE57,
	38951 - 11905: 0xEE58,
	38952 - 11905: 0xEE59,
	38953 - 11905: 0xEE5A,
	38954 - 11905: 0xEE5B,
	38955 - 11905: 0xEE5C,
	38956 - 11905: 0xEE5D,
	38957 - 11905: 0xEE5E,
	38958 - 11905: 0xEE5F,
	38959 - 11905: 0xEE60,
	38960 - 11905: 0xEE61,
	38961 - 11905: 0xEE62,
	38962 - 11905: 0xEE63,
	38963 - 11905: 0xEE64,
	38964 - 11905: 0xEE65,
	38965 - 11905: 0xEE66,
	38966 - 11905: 0xEE67,
	38967 - 11905: 0xEE68,
	38968 - 11905: 0xEE69,
	38969 - 11905: 0xEE6A,
	38970 - 11905: 0xEE6B,
	38971 - 11905: 0xEE6C,
	38972 - 11905: 0xEE6D,
	38973 - 11905: 0xEE6E,
	38974 - 11905: 0xEE6F,
	38975 - 11905: 0xEE70,
	38976 - 11905: 0xEE71,
	38977 - 11905: 0xEE72,
	38978 - 11905: 0xEE73,
	38979 - 11905: 0xEE74,
	38980 - 11905: 0xEE75,
	38981 - 11905: 0xEE76,
	38982 - 11905: 0xEE77,
	38983 - 11905: 0xEE78,
	38984 - 11905: 0xEE79,
	38985 - 11905: 0xEE7A,
	38986 - 11905: 0xEE7B,
	38987 - 11905: 0xEE7C,
	38988 - 11905: 0xEE7D,
	38989 - 11905: 0xEE7E,
	38990 - 11905: 0xEE80,
	38991 - 11905: 0xEE81,
	38992 - 11905: 0xEE82,
	38993 - 11905: 0xEE83,
	38994 - 11905: 0xEE84,
	38995 - 11905: 0xEE85,
	38996 - 11905: 0xEE86,
	38997 - 11905: 0xEE87,
	38998 - 11905: 0xEE88,
	38999 - 11905: 0xEE89,
	39000 - 11905: 0xEE8A,
	39001 - 11905: 0xEE8B,
	39002 - 11905: 0xEE8C,
	39003 - 11905: 0xEE8D,
	39004 - 11905: 0xEE8E,
	39005 - 11905: 0xEE8F,
	39006 - 11905: 0xEE90,
	39007 - 11905: 0xEE91,
	39008 - 11905: 0xEE92,
	39009 - 11905: 0xEE93,
	39010 - 11905: 0xEE94,
	39011 - 11905: 0xEE95,
	39012 - 11905: 0xEE96,
	39013 - 11905: 0xEE97,
	39014 - 11905: 0xEE98,
	39015 - 11905: 0xEE99,
	39016 - 11905: 0xEE9A,
	39017 - 11905: 0xEE9B,
	39018 - 11905: 0xEE9C,
	39019 - 11905: 0xEE9D,
	39020 - 11905: 0xEE9E,
	39021 - 11905: 0xEE9F,
	39022 - 11905: 0xEEA0,
	39023 - 11905: 0xEF40,
	39024 - 11905: 0xEF41,
	39025 - 11905: 0xEF42,
	39026 - 11905: 0xEF43,
	39027 - 11905: 0xEF44,
	39028 - 11905: 0xEF45,
	39029 - 11905: 0xD2B3,
	39030 - 11905: 0xB6A5,
	39031 - 11905: 0xC7EA,
	39032 - 11905: 0xF1FC,
	39033 - 11905: 0xCFEE,
	39034 - 11905: 0xCBB3,
	39035 - 11905: 0xD0EB,
	39036 - 11905: 0xE7EF,
	39037 - 11905: 0xCDE7,
	39038 - 11905: 0xB9CB,
	39039 - 11905: 0xB6D9,
	39040 - 11905: 0xF1FD,
	39041 - 11905: 0xB0E4,
	39042 - 11905: 0xCBCC,
	39043 - 11905: 0xF1FE,
	39044 - 11905: 0xD4A4,
	39045 - 11905: 0xC2AD,
	39046 - 11905: 0xC1EC,
	39047 - 11905: 0xC6C4,
	39048 - 11905: 0xBEB1,
	39049 - 11905: 0xF2A1,
	39050 - 11905: 0xBCD5,
	39051 - 11905: 0xEF46,
	39052 - 11905: 0xF2A2,
	39053 - 11905: 0xF2A3,
	39054 - 11905: 0xEF47,
	39055 - 11905: 0xF2A4,
	39056 - 11905: 0xD2C3,
	39057 - 11905: 0xC6B5,
	39058 - 11905: 0xEF48,
	39059 - 11905: 0xCDC7,
	39060 - 11905: 0xF2A5,
	39061 - 11905: 0xEF49,
	39062 - 11905: 0xD3B1,
	39063 - 11905: 0xBFC5,
	39064 - 11905: 0xCCE2,
	39065 - 11905: 0xEF4A,
	39066 - 11905: 0xF2A6,
	39067 - 11905: 0xF2A7,
	39068 - 11905: 0xD1D5,
	39069 - 11905: 0xB6EE,
	39070 - 11905: 0xF2A8,
	39071 - 11905: 0xF2A9,
	39072 - 11905: 0xB5DF,
	39073 - 11905: 0xF2AA,
	39074 - 11905: 0xF2AB,
	39075 - 11905: 0xEF4B,
	39076 - 11905: 0xB2FC,
	39077 - 11905: 0xF2AC,
	39078 - 11905: 0xF2AD,
	39079 - 11905: 0xC8A7,
	39080 - 11905: 0xEF4C,
	39081 - 11905: 0xEF4D,
	39082 - 11905: 0xEF4E,
	39083 - 11905: 0xEF4F,
	39084 - 11905: 0xEF50,
	39085 - 11905: 0xEF51,
	39086 - 11905: 0xEF52,
	39087 - 11905: 0xEF53,
	39088 - 11905: 0xEF54,
	39089 - 11905: 0xEF55,
	39090 - 11905: 0xEF56,
	39091 - 11905: 0xEF57,
	39092 - 11905: 0xEF58,
	39093 - 11905: 0xEF59,
	39094 - 11905: 0xEF5A,
	39095 - 11905: 0xEF5B,
	39096 - 11905: 0xEF5C,
	39097 - 11905: 0xEF5D,
	39098 - 11905: 0xEF5E,
	39099 - 11905: 0xEF5F,
	39100 - 11905: 0xEF60,
	39101 - 11905: 0xEF61,
	39102 - 11905: 0xEF62,
	39103 - 11905: 0xEF63,
	39104 - 11905: 0xEF64,
	39105 - 11905: 0xEF65,
	39106 - 11905: 0xEF66,
	39107 - 11905: 0xEF67,
	39108 - 11905: 0xEF68,
	39109 - 11905: 0xEF69,
	39110 - 11905: 0xEF6A,
	39111 - 11905: 0xEF6B,
	39112 - 11905: 0xEF6C,
	39113 - 11905: 0xEF6D,
	39114 - 11905: 0xEF6E,
	39115 - 11905: 0xEF6F,
	39116 - 11905: 0xEF70,
	39117 - 11905: 0xEF71,
	39118 - 11905: 0xB7E7,
	39119 - 11905: 0xEF72,
	39120 - 11905: 0xEF73,
	39121 - 11905: 0xECA9,
	39122 - 11905: 0xECAA,
	39123 - 11905: 0xECAB,
	39124 - 11905: 0xEF74,
	39125 - 11905: 0xECAC,
	39126 - 11905: 0xEF75,
	39127 - 11905: 0xEF76,
	39128 - 11905: 0xC6AE,
	39129 - 11905: 0xECAD,
	39130 - 11905: 0xECAE,
	39131 - 11905: 0xEF77,
	39132 - 11905: 0xEF78,
	39133 - 11905: 0xEF79,
	39134 - 11905: 0xB7C9,
	39135 - 11905: 0xCAB3,
	39136 - 11905: 0xEF7A,
	39137 - 11905: 0xEF7B,
	39138 - 11905: 0xEF7C,
	39139 - 11905: 0xEF7D,
	39140 - 11905: 0xEF7E,
	39141 - 11905: 0xEF80,
	39142 - 11905: 0xEF81,
	39143 - 11905: 0xE2B8,
	39144 - 11905: 0xF7CF,
	39145 - 11905: 0xEF82,
	39146 - 11905: 0xEF83,
	39147 - 11905: 0xEF84,
	39148 - 11905: 0xEF85,
	39149 - 11905: 0xEF86,
	39150 - 11905: 0xEF87,
	39151 - 11905: 0xEF88,
	39152 - 11905: 0xEF89,
	39153 - 11905: 0xEF8A,
	39154 - 11905: 0xEF8B,
	39155 - 11905: 0xEF8C,
	39156 - 11905: 0xEF8D,
	39157 - 11905: 0xEF8E,
	39158 - 11905: 0xEF8F,
	39159 - 11905: 0xEF90,
	39160 - 11905: 0xEF91,
	39161 - 11905: 0xEF92,
	39162 - 11905: 0xEF93,
	39163 - 11905: 0xEF94,
	39164 - 11905: 0xEF95,
	39165 - 11905: 0xEF96,
	39166 - 11905: 0xEF97,
	39167 - 11905: 0xEF98,
	39168 - 11905: 0xEF99,
	39169 - 11905: 0xEF9A,
	39170 - 11905: 0xEF9B,
	39171 - 11905: 0xEF9C,
	39172 - 11905: 0xEF9D,
	39173 - 11905: 0xEF9E,
	39174 - 11905: 0xEF9F,
	39175 - 11905: 0xEFA0,
	39176 - 11905: 0xF040,
	39177 - 11905: 0xF041,
	39178 - 11905: 0xF042,
	39179 - 11905: 0xF043,
	39180 - 11905: 0xF044,
	39181 - 11905: 0xF7D0,
	39182 - 11905: 0xF045,
	39183 - 11905: 0xF046,
	39184 - 11905: 0xB2CD,
	39185 - 11905: 0xF047,
	39186 - 11905: 0xF048,
	39187 - 11905: 0xF049,
	39188 - 11905: 0xF04A,
	39189 - 11905: 0xF04B,
	39190 - 11905: 0xF04C,
	39191 - 11905: 0xF04D,
	39192 - 11905: 0xF04E,
	39193 - 11905: 0xF04F,
	39194 - 11905: 0xF050,
	39195 - 11905: 0xF051,
	39196 - 11905: 0xF052,
	39197 - 11905: 0xF053,
	39198 - 11905: 0xF054,
	39199 - 11905: 0xF055,
	39200 - 11905: 0xF056,
	39201 - 11905: 0xF057,
	39202 - 11905: 0xF058,
	39203 - 11905: 0xF059,
	39204 - 11905: 0xF05A,
	39205 - 11905: 0xF05B,
	39206 - 11905: 0xF05C,
	39207 - 11905: 0xF05D,
	39208 - 11905: 0xF05E,
	39209 - 11905: 0xF05F,
	39210 - 11905: 0xF060,
	39211 - 11905: 0xF061,
	39212 - 11905: 0xF062,
	39213 - 11905: 0xF063,
	39214 - 11905: 0xF7D1,
	39215 - 11905: 0xF064,
	39216 - 11905: 0xF065,
	39217 - 11905: 0xF066,
	39218 - 11905: 0xF067,
	39219 - 11905: 0xF068,
	39220 - 11905: 0xF069,
	39221 - 11905: 0xF06A,
	39222 - 11905: 0xF06B,
	39223 - 11905: 0xF06C,
	39224 - 11905: 0xF06D,
	39225 - 11905: 0xF06E,
	39226 - 11905: 0xF06F,
	39227 - 11905: 0xF070,
	39228 - 11905: 0xF071,
	39229 - 11905: 0xF072,
	39230 - 11905: 0xF073,
	39231 - 11905: 0xF074,
	39232 - 11905: 0xF075,
	39233 - 11905: 0xF076,
	39234 - 11905: 0xF077,
	39235 - 11905: 0xF078,
	39236 - 11905: 0xF079,
	39237 - 11905: 0xF07A,
	39238 - 11905: 0xF07B,
	39239 - 11905: 0xF07C,
	39240 - 11905: 0xF07D,
	39241 - 11905: 0xF07E,
	39242 - 11905: 0xF080,
	39243 - 11905: 0xF081,
	39244 - 11905: 0xF082,
	39245 - 11905: 0xF083,
	39246 - 11905: 0xF084,
	39247 - 11905: 0xF085,
	39248 - 11905: 0xF086,
	39249 - 11905: 0xF087,
	39250 - 11905: 0xF088,
	39251 - 11905: 0xF089,
	39252 - 11905: 0xF7D3,
	39253 - 11905: 0xF7D2,
	39254 - 11905: 0xF08A,
	39255 - 11905: 0xF08B,
	39256 - 11905: 0xF08C,
	39257 - 11905: 0xF08D,
	39258 - 11905: 0xF08E,
	39259 - 11905: 0xF08F,
	39260 - 11905: 0xF090,
	39261 - 11905: 0xF091,
	39262 - 11905: 0xF092,
	39263 - 11905: 0xF093,
	39264 - 11905: 0xF094,
	39265 - 11905: 0xF095,
	39266 - 11905: 0xF096,
	39267 - 11905: 0xE2BB,
	39268 - 11905: 0xF097,
	39269 - 11905: 0xBCA2,
	39270 - 11905: 0xF098,
	39271 - 11905: 0xE2BC,
	39272 - 11905: 0xE2BD,
	39273 - 11905: 0xE2BE,
	39274 - 11905: 0xE2BF,
	39275 - 11905: 0xE2C0,
	39276 - 11905: 0xE2C1,
	39277 - 11905: 0xB7B9,
	39278 - 11905: 0xD2FB,
	39279 - 11905: 0xBDA4,
	39280 - 11905: 0xCACE,
	39281 - 11905: 0xB1A5,
	39282 - 11905: 0xCBC7,
	39283 - 11905: 0xF099,
	39284 - 11905: 0xE2C2,
	39285 - 11905: 0xB6FC,
	39286 - 11905: 0xC8C4,
	39287 - 11905: 0xE2C3,
	39288 - 11905: 0xF09A,
	39289 - 11905: 0xF09B,
	39290 - 11905: 0xBDC8,
	39291 - 11905: 0xF09C,
	39292 - 11905: 0xB1FD,
	39293 - 11905: 0xE2C4,
	39294 - 11905: 0xF09D,
	39295 - 11905: 0xB6F6,
	39296 - 11905: 0xE2C5,
	39297 - 11905: 0xC4D9,
	39298 - 11905: 0xF09E,
	39299 - 11905: 0xF09F,
	39300 - 11905: 0xE2C6,
	39301 - 11905: 0xCFDA,
	39302 - 11905: 0xB9DD,
	39303 - 11905: 0xE2C7,
	39304 - 11905: 0xC0A1,
	39305 - 11905: 0xF0A0,
	39306 - 11905: 0xE2C8,
	39307 - 11905: 0xB2F6,
	39308 - 11905: 0xF140,
	39309 - 11905: 0xE2C9,
	39310 - 11905: 0xF141,
	39311 - 11905: 0xC1F3,
	39312 - 11905: 0xE2CA,
	39313 - 11905: 0xE2CB,
	39314 - 11905: 0xC2F8,
	39315 - 11905: 0xE2CC,
	39316 - 11905: 0xE2CD,
	39317 - 11905: 0xE2CE,
	39318 - 11905: 0xCAD7,
	39319 - 11905: 0xD8B8,
	39320 - 11905: 0xD9E5,
	39321 - 11905: 0xCFE3,
	39322 - 11905: 0xF142,
	39323 - 11905: 0xF143,
	39324 - 11905: 0xF144,
	39325 - 11905: 0xF145,
	39326 - 11905: 0xF146,
	39327 - 11905: 0xF147,
	39328 - 11905: 0xF148,
	39329 - 11905: 0xF149,
	39330 - 11905: 0xF14A,
	39331 - 11905: 0xF14B,
	39332 - 11905: 0xF14C,
	39333 - 11905: 0xF0A5,
	39334 - 11905: 0xF14D,
	39335 - 11905: 0xF14E,
	39336 - 11905: 0xDCB0,
	39337 - 11905: 0xF14F,
	39338 - 11905: 0xF150,
	39339 - 11905: 0xF151,
	39340 - 11905: 0xF152,
	39341 - 11905: 0xF153,
	39342 - 11905: 0xF154,
	39343 - 11905: 0xF155,
	39344 - 11905: 0xF156,
	39345 - 11905: 0xF157,
	39346 - 11905: 0xF158,
	39347 - 11905: 0xF159,
	39348 - 11905: 0xF15A,
	39349 - 11905: 0xF15B,
	39350 - 11905: 0xF15C,
	39351 - 11905: 0xF15D,
	39352 - 11905: 0xF15E,
	39353 - 11905: 0xF15F,
	39354 - 11905: 0xF160,
	39355 - 11905: 0xF161,
	39356 - 11905: 0xF162,
	39357 - 11905: 0xF163,
	39358 - 11905: 0xF164,
	39359 - 11905: 0xF165,
	39360 - 11905: 0xF166,
	39361 - 11905: 0xF167,
	39362 - 11905: 0xF168,
	39363 - 11905: 0xF169,
	39364 - 11905: 0xF16A,
	39365 - 11905: 0xF16B,
	39366 - 11905: 0xF16C,
	39367 - 11905: 0xF16D,
	39368 - 11905: 0xF16E,
	39369 - 11905: 0xF16F,
	39370 - 11905: 0xF170,
	39371 - 11905: 0xF171,
	39372 - 11905: 0xF172,
	39373 - 11905: 0xF173,
	39374 - 11905: 0xF174,
	39375 - 11905: 0xF175,
	39376 - 11905: 0xF176,
	39377 - 11905: 0xF177,
	39378 - 11905: 0xF178,
	39379 - 11905: 0xF179,
	39380 - 11905: 0xF17A,
	39381 - 11905: 0xF17B,
	39382 - 11905: 0xF17C,
	39383 - 11905: 0xF17D,
	39384 - 11905: 0xF17E,
	39385 - 11905: 0xF180,
	39386 - 11905: 0xF181,
	39387 - 11905: 0xF182,
	39388 - 11905: 0xF183,
	39389 - 11905: 0xF184,
	39390 - 11905: 0xF185,
	39391 - 11905: 0xF186,
	39392 - 11905: 0xF187,
	39393 - 11905: 0xF188,
	39394 - 11905: 0xF189,
	39395 - 11905: 0xF18A,
	39396 - 11905: 0xF18B,
	39397 - 11905: 0xF18C,
	39398 - 11905: 0xF18D,
	39399 - 11905: 0xF18E,
	39400 - 11905: 0xF18F,
	39401 - 11905: 0xF190,
	39402 - 11905: 0xF191,
	39403 - 11905: 0xF192,
	39404 - 11905: 0xF193,
	39405 - 11905: 0xF194,
	39406 - 11905: 0xF195,
	39407 - 11905: 0xF196,
	39408 - 11905: 0xF197,
	39409 - 11905: 0xF198,
	39410 - 11905: 0xF199,
	39411 - 11905: 0xF19A,
	39412 - 11905: 0xF19B,
	39413 - 11905: 0xF19C,
	39414 - 11905: 0xF19D,
	39415 - 11905: 0xF19E,
	39416 - 11905: 0xF19F,
	39417 - 11905: 0xF1A0,
	39418 - 11905: 0xF240,
	39419 - 11905: 0xF241,
	39420 - 11905: 0xF242,
	39421 - 11905: 0xF243,
	39422 - 11905: 0xF244,
	39423 - 11905: 0xF245,
	39424 - 11905: 0xF246,
	39425 - 11905: 0xF247,
	39426 - 11905: 0xF248,
	39427 - 11905: 0xF249,
	39428 - 11905: 0xF24A,
	39429 - 11905: 0xF24B,
	39430 - 11905: 0xF24C,
	39431 - 11905: 0xF24D,
	39432 - 11905: 0xF24E,
	39433 - 11905: 0xF24F,
	39434 - 11905: 0xF250,
	39435 - 11905: 0xF251,
	39436 - 11905: 0xF252,
	39437 - 11905: 0xF253,
	39438 - 11905: 0xF254,
	39439 - 11905: 0xF255,
	39440 - 11905: 0xF256,
	39441 - 11905: 0xF257,
	39442 - 11905: 0xF258,
	39443 - 11905: 0xF259,
	39444 - 11905: 0xF25A,
	39445 - 11905: 0xF25B,
	39446 - 11905: 0xF25C,
	39447 - 11905: 0xF25D,
	39448 - 11905: 0xF25E,
	39449 - 11905: 0xF25F,
	39450 - 11905: 0xF260,
	39451 - 11905: 0xF261,
	39452 - 11905: 0xF262,
	39453 - 11905: 0xF263,
	39454 - 11905: 0xF264,
	39455 - 11905: 0xF265,
	39456 - 11905: 0xF266,
	39457 - 11905: 0xF267,
	39458 - 11905: 0xF268,
	39459 - 11905: 0xF269,
	39460 - 11905: 0xF26A,
	39461 - 11905: 0xF26B,
	39462 - 11905: 0xF26C,
	39463 - 11905: 0xF26D,
	39464 - 11905: 0xF26E,
	39465 - 11905: 0xF26F,
	39466 - 11905: 0xF270,
	39467 - 11905: 0xF271,
	39468 - 11905: 0xF272,
	39469 - 11905: 0xF273,
	39470 - 11905: 0xF274,
	39471 - 11905: 0xF275,
	39472 - 11905: 0xF276,
	39473 - 11905: 0xF277,
	39474 - 11905: 0xF278,
	39475 - 11905: 0xF279,
	39476 - 11905: 0xF27A,
	39477 - 11905: 0xF27B,
	39478 - 11905: 0xF27C,
	39479 - 11905: 0xF27D,
	39480 - 11905: 0xF27E,
	39481 - 11905: 0xF280,
	39482 - 11905: 0xF281,
	39483 - 11905: 0xF282,
	39484 - 11905: 0xF283,
	39485 - 11905: 0xF284,
	39486 - 11905: 0xF285,
	39487 - 11905: 0xF286,
	39488 - 11905: 0xF287,
	39489 - 11905: 0xF288,
	39490 - 11905: 0xF289,
	39491 - 11905: 0xF28A,
	39492 - 11905: 0xF28B,
	39493 - 11905: 0xF28C,
	39494 - 11905: 0xF28D,
	39495 - 11905: 0xF28E,
	39496 - 11905: 0xF28F,
	39497 - 11905: 0xF290,
	39498 - 11905: 0xF291,
	39499 - 11905: 0xF292,
	39500 - 11905: 0xF293,
	39501 - 11905: 0xF294,
	39502 - 11905: 0xF295,
	39503 - 11905: 0xF296,
	39504 - 11905: 0xF297,
	39505 - 11905: 0xF298,
	39506 - 11905: 0xF299,
	39507 - 11905: 0xF29A,
	39508 - 11905: 0xF29B,
	39509 - 11905: 0xF29C,
	39510 - 11905: 0xF29D,
	39511 - 11905: 0xF29E,
	39512 - 11905: 0xF29F,
	39513 - 11905: 0xF2A0,
	39514 - 11905: 0xF340,
	39515 - 11905: 0xF341,
	39516 - 11905: 0xF342,
	39517 - 11905: 0xF343,
	39518 - 11905: 0xF344,
	39519 - 11905: 0xF345,
	39520 - 11905: 0xF346,
	39521 - 11905: 0xF347,
	39522 - 11905: 0xF348,
	39523 - 11905: 0xF349,
	39524 - 11905: 0xF34A,
	39525 - 11905: 0xF34B,
	39526 - 11905: 0xF34C,
	39527 - 11905: 0xF34D,
	39528 - 11905: 0xF34E,
	39529 - 11905: 0xF34F,
	39530 - 11905: 0xF350,
	39531 - 11905: 0xF351,
	39532 - 11905: 0xC2ED,
	39533 - 11905: 0xD4A6,
	39534 - 11905: 0xCDD4,
	39535 - 11905: 0xD1B1,
	39536 - 11905: 0xB3DB,
	39537 - 11905: 0xC7FD,
	39538 - 11905: 0xF352,
	39539 - 11905: 0xB2B5,
	39540 - 11905: 0xC2BF,
	39541 - 11905: 0xE6E0,
	39542 - 11905: 0xCABB,
	39543 - 11905: 0xE6E1,
	39544 - 11905: 0xE6E2,
	39545 - 11905: 0xBED4,
	39546 - 11905: 0xE6E3,
	39547 - 11905: 0xD7A4,
	39548 - 11905: 0xCDD5,
	39549 - 11905: 0xE6E5,
	39550 - 11905: 0xBCDD,
	39551 - 11905: 0xE6E4,
	39552 - 11905: 0xE6E6,
	39553 - 11905: 0xE6E7,
	39554 - 11905: 0xC2EE,
	39555 - 11905: 0xF353,
	39556 - 11905: 0xBDBE,
	39557 - 11905: 0xE6E8,
	39558 - 11905: 0xC2E6,
	39559 - 11905: 0xBAA7,
	39560 - 11905: 0xE6E9,
	39561 - 11905: 0xF354,
	39562 - 11905: 0xE6EA,
	39563 - 11905: 0xB3D2,
	39564 - 11905: 0xD1E9,
	39565 - 11905: 0xF355,
	39566 - 11905: 0xF356,
	39567 - 11905: 0xBFA5,
	39568 - 11905: 0xE6EB,
	39569 - 11905: 0xC6EF,
	39570 - 11905: 0xE6EC,
	39571 - 11905: 0xE6ED,
	39572 - 11905: 0xF357,
	39573 - 11905: 0xF358,
	39574 - 11905: 0xE6EE,
	39575 - 11905: 0xC6AD,
	39576 - 11905: 0xE6EF,
	39577 - 11905: 0xF359,
	39578 - 11905: 0xC9A7,
	39579 - 11905: 0xE6F0,
	39580 - 11905: 0xE6F1,
	39581 - 11905: 0xE6F2,
	39582 - 11905: 0xE5B9,
	39583 - 11905: 0xE6F3,
	39584 - 11905: 0xE6F4,
	39585 - 11905: 0xC2E2,
	39586 - 11905: 0xE6F5,
	39587 - 11905: 0xE6F6,
	39588 - 11905: 0xD6E8,
	39589 - 11905: 0xE6F7,
	39590 - 11905: 0xF35A,
	39591 - 11905: 0xE6F8,
	39592 - 11905: 0xB9C7,
	39593 - 11905: 0xF35B,
	39594 - 11905: 0xF35C,
	39595 - 11905: 0xF35D,
	39596 - 11905: 0xF35E,
	39597 - 11905: 0xF35F,
	39598 - 11905: 0xF360,
	39599 - 11905: 0xF361,
	39600 - 11905: 0xF7BB,
	39601 - 11905: 0xF7BA,
	39602 - 11905: 0xF362,
	39603 - 11905: 0xF363,
	39604 - 11905: 0xF364,
	39605 - 11905: 0xF365,
	39606 - 11905: 0xF7BE,
	39607 - 11905: 0xF7BC,
	39608 - 11905: 0xBAA1,
	39609 - 11905: 0xF366,
	39610 - 11905: 0xF7BF,
	39611 - 11905: 0xF367,
	39612 - 11905: 0xF7C0,
	39613 - 11905: 0xF368,
	39614 - 11905: 0xF369,
	39615 - 11905: 0xF36A,
	39616 - 11905: 0xF7C2,
	39617 - 11905: 0xF7C1,
	39618 - 11905: 0xF7C4,
	39619 - 11905: 0xF36B,
	39620 - 11905: 0xF36C,
	39621 - 11905: 0xF7C3,
	39622 - 11905: 0xF36D,
	39623 - 11905: 0xF36E,
	39624 - 11905: 0xF36F,
	39625 - 11905: 0xF370,
	39626 - 11905: 0xF371,
	39627 - 11905: 0xF7C5,
	39628 - 11905: 0xF7C6,
	39629 - 11905: 0xF372,
	39630 - 11905: 0xF373,
	39631 - 11905: 0xF374,
	39632 - 11905: 0xF375,
	39633 - 11905: 0xF7C7,
	39634 - 11905: 0xF376,
	39635 - 11905: 0xCBE8,
	39636 - 11905: 0xF377,
	39637 - 11905: 0xF378,
	39638 - 11905: 0xF379,
	39639 - 11905: 0xF37A,
	39640 - 11905: 0xB8DF,
	39641 - 11905: 0xF37B,
	39642 - 11905: 0xF37C,
	39643 - 11905: 0xF37D,
	39644 - 11905: 0xF37E,
	39645 - 11905: 0xF380,
	39646 - 11905: 0xF381,
	39647 - 11905: 0xF7D4,
	39648 - 11905: 0xF382,
	39649 - 11905: 0xF7D5,
	39650 - 11905: 0xF383,
	39651 - 11905: 0xF384,
	39652 - 11905: 0xF385,
	39653 - 11905: 0xF386,
	39654 - 11905: 0xF7D6,
	39655 - 11905: 0xF387,
	39656 - 11905: 0xF388,
	39657 - 11905: 0xF389,
	39658 - 11905: 0xF38A,
	39659 - 11905: 0xF7D8,
	39660 - 11905: 0xF38B,
	39661 - 11905: 0xF7DA,
	39662 - 11905: 0xF38C,
	39663 - 11905: 0xF7D7,
	39664 - 11905: 0xF38D,
	39665 - 11905: 0xF38E,
	39666 - 11905: 0xF38F,
	39667 - 11905: 0xF390,
	39668 - 11905: 0xF391,
	39669 - 11905: 0xF392,
	39670 - 11905: 0xF393,
	39671 - 11905: 0xF394,
	39672 - 11905: 0xF395,
	39673 - 11905: 0xF7DB,
	39674 - 11905: 0xF396,
	39675 - 11905: 0xF7D9,
	39676 - 11905: 0xF397,
	39677 - 11905: 0xF398,
	39678 - 11905: 0xF399,
	39679 - 11905: 0xF39A,
	39680 - 11905: 0xF39B,
	39681 - 11905: 0xF39C,
	39682 - 11905: 0xF39D,
	39683 - 11905: 0xD7D7,
	39684 - 11905: 0xF39E,
	39685 - 11905: 0xF39F,
	39686 - 11905: 0xF3A0,
	39687 - 11905: 0xF440,
	39688 - 11905: 0xF7DC,
	39689 - 11905: 0xF441,
	39690 - 11905: 0xF442,
	39691 - 11905: 0xF443,
	39692 - 11905: 0xF444,
	39693 - 11905: 0xF445,
	39694 - 11905: 0xF446,
	39695 - 11905: 0xF7DD,
	39696 - 11905: 0xF447,
	39697 - 11905: 0xF448,
	39698 - 11905: 0xF449,
	39699 - 11905: 0xF7DE,
	39700 - 11905: 0xF44A,
	39701 - 11905: 0xF44B,
	39702 - 11905: 0xF44C,
	39703 - 11905: 0xF44D,
	39704 - 11905: 0xF44E,
	39705 - 11905: 0xF44F,
	39706 - 11905: 0xF450,
	39707 - 11905: 0xF451,
	39708 - 11905: 0xF452,
	39709 - 11905: 0xF453,
	39710 - 11905: 0xF454,
	39711 - 11905: 0xF7DF,
	39712 - 11905: 0xF455,
	39713 - 11905: 0xF456,
	39714 - 11905: 0xF457,
	39715 - 11905: 0xF7E0,
	39716 - 11905: 0xF458,
	39717 - 11905: 0xF459,
	39718 - 11905: 0xF45A,
	39719 - 11905: 0xF45B,
	39720 - 11905: 0xF45C,
	39721 - 11905: 0xF45D,
	39722 - 11905: 0xF45E,
	39723 - 11905: 0xF45F,
	39724 - 11905: 0xF460,
	39725 - 11905: 0xF461,
	39726 - 11905: 0xF462,
	39727 - 11905: 0xDBCB,
	39728 - 11905: 0xF463,
	39729 - 11905: 0xF464,
	39730 - 11905: 0xD8AA,
	39731 - 11905: 0xF465,
	39732 - 11905: 0xF466,
	39733 - 11905: 0xF467,
	39734 - 11905: 0xF468,
	39735 - 11905: 0xF469,
	39736 - 11905: 0xF46A,
	39737 - 11905: 0xF46B,
	39738 - 11905: 0xF46C,
	39739 - 11905: 0xE5F7,
	39740 - 11905: 0xB9ED,
	39741 - 11905: 0xF46D,
	39742 - 11905: 0xF46E,
	39743 - 11905: 0xF46F,
	39744 - 11905: 0xF470,
	39745 - 11905: 0xBFFD,
	39746 - 11905: 0xBBEA,
	39747 - 11905: 0xF7C9,
	39748 - 11905: 0xC6C7,
	39749 - 11905: 0xF7C8,
	39750 - 11905: 0xF471,
	39751 - 11905: 0xF7CA,
	39752 - 11905: 0xF7CC,
	39753 - 11905: 0xF7CB,
	39754 - 11905: 0xF472,
	39755 - 11905: 0xF473,
	39756 - 11905: 0xF474,
	39757 - 11905: 0xF7CD,
	39758 - 11905: 0xF475,
	39759 - 11905: 0xCEBA,
	39760 - 11905: 0xF476,
	39761 - 11905: 0xF7CE,
	39762 - 11905: 0xF477,
	39763 - 11905: 0xF478,
	39764 - 11905: 0xC4A7,
	39765 - 11905: 0xF479,
	39766 - 11905: 0xF47A,
	39767 - 11905: 0xF47B,
	39768 - 11905: 0xF47C,
	39769 - 11905: 0xF47D,
	39770 - 11905: 0xF47E,
	39771 - 11905: 0xF480,
	39772 - 11905: 0xF481,
	39773 - 11905: 0xF482,
	39774 - 11905: 0xF483,
	39775 - 11905: 0xF484,
	39776 - 11905: 0xF485,
	39777 - 11905: 0xF486,
	39778 - 11905: 0xF487,
	39779 - 11905: 0xF488,
	39780 - 11905: 0xF489,
	39781 - 11905: 0xF48A,
	39782 - 11905: 0xF48B,
	39783 - 11905: 0xF48C,
	39784 - 11905: 0xF48D,
	39785 - 11905: 0xF48E,
	39786 - 11905: 0xF48F,
	39787 - 11905: 0xF490,
	39788 - 11905: 0xF491,
	39789 - 11905: 0xF492,
	39790 - 11905: 0xF493,
	39791 - 11905: 0xF494,
	39792 - 11905: 0xF495,
	39793 - 11905: 0xF496,
	39794 - 11905: 0xF497,
	39795 - 11905: 0xF498,
	39796 - 11905: 0xF499,
	39797 - 11905: 0xF49A,
	39798 - 11905: 0xF49B,
	39799 - 11905: 0xF49C,
	39800 - 11905: 0xF49D,
	39801 - 11905: 0xF49E,
	39802 - 11905: 0xF49F,
	39803 - 11905: 0xF4A0,
	39804 - 11905: 0xF540,
	39805 - 11905: 0xF541,
	39806 - 11905: 0xF542,
	39807 - 11905: 0xF543,
	39808 - 11905: 0xF544,
	39809 - 11905: 0xF545,
	39810 - 11905: 0xF546,
	39811 - 11905: 0xF547,
	39812 - 11905: 0xF548,
	39813 - 11905: 0xF549,
	39814 - 11905: 0xF54A,
	39815 - 11905: 0xF54B,
	39816 - 11905: 0xF54C,
	39817 - 11905: 0xF54D,
	39818 - 11905: 0xF54E,
	39819 - 11905: 0xF54F,
	39820 - 11905: 0xF550,
	39821 - 11905: 0xF551,
	39822 - 11905: 0xF552,
	39823 - 11905: 0xF553,
	39824 - 11905: 0xF554,
	39825 - 11905: 0xF555,
	39826 - 11905: 0xF556,
	39827 - 11905: 0xF557,
	39828 - 11905: 0xF558,
	39829 - 11905: 0xF559,
	39830 - 11905: 0xF55A,
	39831 - 11905: 0xF55B,
	39832 - 11905: 0xF55C,
	39833 - 11905: 0xF55D,
	39834 - 11905: 0xF55E,
	39835 - 11905: 0xF55F,
	39836 - 11905: 0xF560,
	39837 - 11905: 0xF561,
	39838 - 11905: 0xF562,
	39839 - 11905: 0xF563,
	39840 - 11905: 0xF564,
	39841 - 11905: 0xF565,
	39842 - 11905: 0xF566,
	39843 - 11905: 0xF567,
	39844 - 11905: 0xF568,
	39845 - 11905: 0xF569,
	39846 - 11905: 0xF56A,
	39847 - 11905: 0xF56B,
	39848 - 11905: 0xF56C,
	39849 - 11905: 0xF56D,
	39850 - 11905: 0xF56E,
	39851 - 11905: 0xF56F,
	39852 - 11905: 0xF570,
	39853 - 11905: 0xF571,
	39854 - 11905: 0xF572,
	39855 - 11905: 0xF573,
	39856 - 11905: 0xF574,
	39857 - 11905: 0xF575,
	39858 - 11905: 0xF576,
	39859 - 11905: 0xF577,
	39860 - 11905: 0xF578,
	39861 - 11905: 0xF579,
	39862 - 11905: 0xF57A,
	39863 - 11905: 0xF57B,
	39864 - 11905: 0xF57C,
	39865 - 11905: 0xF57D,
	39866 - 11905: 0xF57E,
	39867 - 11905: 0xF580,
	39868 - 11905: 0xF581,
	39869 - 11905: 0xF582,
	39870 - 11905: 0xF583,
	39871 - 11905: 0xF584,
	39872 - 11905: 0xF585,
	39873 - 11905: 0xF586,
	39874 - 11905: 0xF587,
	39875 - 11905: 0xF588,
	39876 - 11905: 0xF589,
	39877 - 11905: 0xF58A,
	39878 - 11905: 0xF58B,
	39879 - 11905: 0xF58C,
	39880 - 11905: 0xF58D,
	39881 - 11905: 0xF58E,
	39882 - 11905: 0xF58F,
	39883 - 11905: 0xF590,
	39884 - 11905: 0xF591,
	39885 - 11905: 0xF592,
	39886 - 11905: 0xF593,
	39887 - 11905: 0xF594,
	39888 - 11905: 0xF595,
	39889 - 11905: 0xF596,
	39890 - 11905: 0xF597,
	39891 - 11905: 0xF598,
	39892 - 11905: 0xF599,
	39893 - 11905: 0xF59A,
	39894 - 11905: 0xF59B,
	39895 - 11905: 0xF59C,
	39896 - 11905: 0xF59D,
	39897 - 11905: 0xF59E,
	39898 - 11905: 0xF59F,
	39899 - 11905: 0xF5A0,
	39900 - 11905: 0xF640,
	39901 - 11905: 0xF641,
	39902 - 11905: 0xF642,
	39903 - 11905: 0xF643,
	39904 - 11905: 0xF644,
	39905 - 11905: 0xF645,
	39906 - 11905: 0xF646,
	39907 - 11905: 0xF647,
	39908 - 11905: 0xF648,
	39909 - 11905: 0xF649,
	39910 - 11905: 0xF64A,
	39911 - 11905: 0xF64B,
	39912 - 11905: 0xF64C,
	39913 - 11905: 0xF64D,
	39914 - 11905: 0xF64E,
	39915 - 11905: 0xF64F,
	39916 - 11905: 0xF650,
	39917 - 11905: 0xF651,
	39918 - 11905: 0xF652,
	39919 - 11905: 0xF653,
	39920 - 11905: 0xF654,
	39921 - 11905: 0xF655,
	39922 - 11905: 0xF656,
	39923 - 11905: 0xF657,
	39924 - 11905: 0xF658,
	39925 - 11905: 0xF659,
	39926 - 11905: 0xF65A,
	39927 - 11905: 0xF65B,
	39928 - 11905: 0xF65C,
	39929 - 11905: 0xF65D,
	39930 - 11905: 0xF65E,
	39931 - 11905: 0xF65F,
	39932 - 11905: 0xF660,
	39933 - 11905: 0xF661,
	39934 - 11905: 0xF662,
	39935 - 11905: 0xF663,
	39936 - 11905: 0xF664,
	39937 - 11905: 0xF665,
	39938 - 11905: 0xF666,
	39939 - 11905: 0xF667,
	39940 - 11905: 0xF668,
	39941 - 11905: 0xF669,
	39942 - 11905: 0xF66A,
	39943 - 11905: 0xF66B,
	39944 - 11905: 0xF66C,
	39945 - 11905: 0xF66D,
	39946 - 11905: 0xF66E,
	39947 - 11905: 0xF66F,
	39948 - 11905: 0xF670,
	39949 - 11905: 0xF671,
	39950 - 11905: 0xF672,
	39951 - 11905: 0xF673,
	39952 - 11905: 0xF674,
	39953 - 11905: 0xF675,
	39954 - 11905: 0xF676,
	39955 - 11905: 0xF677,
	39956 - 11905: 0xF678,
	39957 - 11905: 0xF679,
	39958 - 11905: 0xF67A,
	39959 - 11905: 0xF67B,
	39960 - 11905: 0xF67C,
	39961 - 11905: 0xF67D,
	39962 - 11905: 0xF67E,
	39963 - 11905: 0xF680,
	39964 - 11905: 0xF681,
	39965 - 11905: 0xF682,
	39966 - 11905: 0xF683,
	39967 - 11905: 0xF684,
	39968 - 11905: 0xF685,
	39969 - 11905: 0xF686,
	39970 - 11905: 0xF687,
	39971 - 11905: 0xF688,
	39972 - 11905: 0xF689,
	39973 - 11905: 0xF68A,
	39974 - 11905: 0xF68B,
	39975 - 11905: 0xF68C,
	39976 - 11905: 0xF68D,
	39977 - 11905: 0xF68E,
	39978 - 11905: 0xF68F,
	39979 - 11905: 0xF690,
	39980 - 11905: 0xF691,
	39981 - 11905: 0xF692,
	39982 - 11905: 0xF693,
	39983 - 11905: 0xF694,
	39984 - 11905: 0xF695,
	39985 - 11905: 0xF696,
	39986 - 11905: 0xF697,
	39987 - 11905: 0xF698,
	39988 - 11905: 0xF699,
	39989 - 11905: 0xF69A,
	39990 - 11905: 0xF69B,
	39991 - 11905: 0xF69C,
	39992 - 11905: 0xF69D,
	39993 - 11905: 0xF69E,
	39994 - 11905: 0xF69F,
	39995 - 11905: 0xF6A0,
	39996 - 11905: 0xF740,
	39997 - 11905: 0xF741,
	39998 - 11905: 0xF742,
	39999 - 11905: 0xF743,
	40000 - 11905: 0xF744,
	40001 - 11905: 0xF745,
	40002 - 11905: 0xF746,
	40003 - 11905: 0xF747,
	40004 - 11905: 0xF748,
	40005 - 11905: 0xF749,
	40006 - 11905: 0xF74A,
	40007 - 11905: 0xF74B,
	40008 - 11905: 0xF74C,
	40009 - 11905: 0xF74D,
	40010 - 11905: 0xF74E,
	40011 - 11905: 0xF74F,
	40012 - 11905: 0xF750,
	40013 - 11905: 0xF751,
	40014 - 11905: 0xF752,
	40015 - 11905: 0xF753,
	40016 - 11905: 0xF754,
	40017 - 11905: 0xF755,
	40018 - 11905: 0xF756,
	40019 - 11905: 0xF757,
	40020 - 11905: 0xF758,
	40021 - 11905: 0xF759,
	40022 - 11905: 0xF75A,
	40023 - 11905: 0xF75B,
	40024 - 11905: 0xF75C,
	40025 - 11905: 0xF75D,
	40026 - 11905: 0xF75E,
	40027 - 11905: 0xF75F,
	40028 - 11905: 0xF760,
	40029 - 11905: 0xF761,
	40030 - 11905: 0xF762,
	40031 - 11905: 0xF763,
	40032 - 11905: 0xF764,
	40033 - 11905: 0xF765,
	40034 - 11905: 0xF766,
	40035 - 11905: 0xF767,
	40036 - 11905: 0xF768,
	40037 - 11905: 0xF769,
	40038 - 11905: 0xF76A,
	40039 - 11905: 0xF76B,
	40040 - 11905: 0xF76C,
	40041 - 11905: 0xF76D,
	40042 - 11905: 0xF76E,
	40043 - 11905: 0xF76F,
	40044 - 11905: 0xF770,
	40045 - 11905: 0xF771,
	40046 - 11905: 0xF772,
	40047 - 11905: 0xF773,
	40048 - 11905: 0xF774,
	40049 - 11905: 0xF775,
	40050 - 11905: 0xF776,
	40051 - 11905: 0xF777,
	40052 - 11905: 0xF778,
	40053 - 11905: 0xF779,
	40054 - 11905: 0xF77A,
	40055 - 11905: 0xF77B,
	40056 - 11905: 0xF77C,
	40057 - 11905: 0xF77D,
	40058 - 11905: 0xF77E,
	40059 - 11905: 0xF780,
	40060 - 11905: 0xD3E3,
	40061 - 11905: 0xF781,
	40062 - 11905: 0xF782,
	40063 - 11905: 0xF6CF,
	40064 - 11905: 0xF783,
	40065 - 11905: 0xC2B3,
	40066 - 11905: 0xF6D0,
	40067 - 11905: 0xF784,
	40068 - 11905: 0xF785,
	40069 - 11905: 0xF6D1,
	40070 - 11905: 0xF6D2,
	40071 - 11905: 0xF6D3,
	40072 - 11905: 0xF6D4,
	40073 - 11905: 0xF786,
	40074 - 11905: 0xF787,
	40075 - 11905: 0xF6D6,
	40076 - 11905: 0xF788,
	40077 - 11905: 0xB1AB,
	40078 - 11905: 0xF6D7,
	40079 - 11905: 0xF789,
	40080 - 11905: 0xF6D8,
	40081 - 11905: 0xF6D9,
	40082 - 11905: 0xF6DA,
	40083 - 11905: 0xF78A,
	40084 - 11905: 0xF6DB,
	40085 - 11905: 0xF6DC,
	40086 - 11905: 0xF78B,
	40087 - 11905: 0xF78C,
	40088 - 11905: 0xF78D,
	40089 - 11905: 0xF78E,
	40090 - 11905: 0xF6DD,
	40091 - 11905: 0xF6DE,
	40092 - 11905: 0xCFCA,
	40093 - 11905: 0xF78F,
	40094 - 11905: 0xF6DF,
	40095 - 11905: 0xF6E0,
	40096 - 11905: 0xF6E1,
	40097 - 11905: 0xF6E2,
	40098 - 11905: 0xF6E3,
	40099 - 11905: 0xF6E4,
	40100 - 11905: 0xC0F0,
	40101 - 11905: 0xF6E5,
	40102 - 11905: 0xF6E6,
	40103 - 11905: 0xF6E7,
	40104 - 11905: 0xF6E8,
	40105 - 11905: 0xF6E9,
	40106 - 11905: 0xF790,
	40107 - 11905: 0xF6EA,
	40108 - 11905: 0xF791,
	40109 - 11905: 0xF6EB,
	40110 - 11905: 0xF6EC,
	40111 - 11905: 0xF792,
	40112 - 11905: 0xF6ED,
	40113 - 11905: 0xF6EE,
	40114 - 11905: 0xF6EF,
	40115 - 11905: 0xF6F0,
	40116 - 11905: 0xF6F1,
	40117 - 11905: 0xF6F2,
	40118 - 11905: 0xF6F3,
	40119 - 11905: 0xF6F4,
	40120 - 11905: 0xBEA8,
	40121 - 11905: 0xF793,
	40122 - 11905: 0xF6F5,
	40123 - 11905: 0xF6F6,
	40124 - 11905: 0xF6F7,
	40125 - 11905: 0xF6F8,
	40126 - 11905: 0xF794,
	40127 - 11905: 0xF795,
	40128 - 11905: 0xF796,
	40129 - 11905: 0xF797,
	40130 - 11905: 0xF798,
	40131 - 11905: 0xC8FA,
	40132 - 11905: 0xF6F9,
	40133 - 11905: 0xF6FA,
	40134 - 11905: 0xF6FB,
	40135 - 11905: 0xF6FC,
	40136 - 11905: 0xF799,
	40137 - 11905: 0xF79A,
	40138 - 11905: 0xF6FD,
	40139 - 11905: 0xF6FE,
	40140 - 11905: 0xF7A1,
	40141 - 11905: 0xF7A2,
	40142 - 11905: 0xF7A3,
	40143 - 11905: 0xF7A4,
	40144 - 11905: 0xF7A5,
	40145 - 11905: 0xF79B,
	40146 - 11905: 0xF79C,
	40147 - 11905: 0xF7A6,
	40148 - 11905: 0xF7A7,
	40149 - 11905: 0xF7A8,
	40150 - 11905: 0xB1EE,
	40151 - 11905: 0xF7A9,
	40152 - 11905: 0xF7AA,
	40153 - 11905: 0xF7AB,
	40154 - 11905: 0xF79D,
	40155 - 11905: 0xF79E,
	40156 - 11905: 0xF7AC,
	40157 - 11905: 0xF7AD,
	40158 - 11905: 0xC1DB,
	40159 - 11905: 0xF7AE,
	40160 - 11905: 0xF79F,
	40161 - 11905: 0xF7A0,
	40162 - 11905: 0xF7AF,
	40163 - 11905: 0xF840,
	40164 - 11905: 0xF841,
	40165 - 11905: 0xF842,
	40166 - 11905: 0xF843,
	40167 - 11905: 0xF844,
	40168 - 11905: 0xF845,
	40169 - 11905: 0xF846,
	40170 - 11905: 0xF847,
	40171 - 11905: 0xF848,
	40172 - 11905: 0xF849,
	40173 - 11905: 0xF84A,
	40174 - 11905: 0xF84B,
	40175 - 11905: 0xF84C,
	40176 - 11905: 0xF84D,
	40177 - 11905: 0xF84E,
	40178 - 11905: 0xF84F,
	40179 - 11905: 0xF850,
	40180 - 11905: 0xF851,
	40181 - 11905: 0xF852,
	40182 - 11905: 0xF853,
	40183 - 11905: 0xF854,
	40184 - 11905: 0xF855,
	40185 - 11905: 0xF856,
	40186 - 11905: 0xF857,
	40187 - 11905: 0xF858,
	40188 - 11905: 0xF859,
	40189 - 11905: 0xF85A,
	40190 - 11905: 0xF85B,
	40191 - 11905: 0xF85C,
	40192 - 11905: 0xF85D,
	40193 - 11905: 0xF85E,
	40194 - 11905: 0xF85F,
	40195 - 11905: 0xF860,
	40196 - 11905: 0xF861,
	40197 - 11905: 0xF862,
	40198 - 11905: 0xF863,
	40199 - 11905: 0xF864,
	40200 - 11905: 0xF865,
	40201 - 11905: 0xF866,
	40202 - 11905: 0xF867,
	40203 - 11905: 0xF868,
	40204 - 11905: 0xF869,
	40205 - 11905: 0xF86A,
	40206 - 11905: 0xF86B,
	40207 - 11905: 0xF86C,
	40208 - 11905: 0xF86D,
	40209 - 11905: 0xF86E,
	40210 - 11905: 0xF86F,
	40211 - 11905: 0xF870,
	40212 - 11905: 0xF871,
	40213 - 11905: 0xF872,
	40214 - 11905: 0xF873,
	40215 - 11905: 0xF874,
	40216 - 11905: 0xF875,
	40217 - 11905: 0xF876,
	40218 - 11905: 0xF877,
	40219 - 11905: 0xF878,
	40220 - 11905: 0xF879,
	40221 - 11905: 0xF87A,
	40222 - 11905: 0xF87B,
	40223 - 11905: 0xF87C,
	40224 - 11905: 0xF87D,
	40225 - 11905: 0xF87E,
	40226 - 11905: 0xF880,
	40227 - 11905: 0xF881,
	40228 - 11905: 0xF882,
	40229 - 11905: 0xF883,
	40230 - 11905: 0xF884,
	40231 - 11905: 0xF885,
	40232 - 11905: 0xF886,
	40233 - 11905: 0xF887,
	40234 - 11905: 0xF888,
	40235 - 11905: 0xF889,
	40236 - 11905: 0xF88A,
	40237 - 11905: 0xF88B,
	40238 - 11905: 0xF88C,
	40239 - 11905: 0xF88D,
	40240 - 11905: 0xF88E,
	40241 - 11905: 0xF88F,
	40242 - 11905: 0xF890,
	40243 - 11905: 0xF891,
	40244 - 11905: 0xF892,
	40245 - 11905: 0xF893,
	40246 - 11905: 0xF894,
	40247 - 11905: 0xF895,
	40248 - 11905: 0xF896,
	40249 - 11905: 0xF897,
	40250 - 11905: 0xF898,
	40251 - 11905: 0xF899,
	40252 - 11905: 0xF89A,
	40253 - 11905: 0xF89B,
	40254 - 11905: 0xF89C,
	40255 - 11905: 0xF89D,
	40256 - 11905: 0xF89E,
	40257 - 11905: 0xF89F,
	40258 - 11905: 0xF8A0,
	40259 - 11905: 0xF940,
	40260 - 11905: 0xF941,
	40261 - 11905: 0xF942,
	40262 - 11905: 0xF943,
	40263 - 11905: 0xF944,
	40264 - 11905: 0xF945,
	40265 - 11905: 0xF946,
	40266 - 11905: 0xF947,
	40267 - 11905: 0xF948,
	40268 - 11905: 0xF949,
	40269 - 11905: 0xF94A,
	40270 - 11905: 0xF94B,
	40271 - 11905: 0xF94C,
	40272 - 11905: 0xF94D,
	40273 - 11905: 0xF94E,
	40274 - 11905: 0xF94F,
	40275 - 11905: 0xF950,
	40276 - 11905: 0xF951,
	40277 - 11905: 0xF952,
	40278 - 11905: 0xF953,
	40279 - 11905: 0xF954,
	40280 - 11905: 0xF955,
	40281 - 11905: 0xF956,
	40282 - 11905: 0xF957,
	40283 - 11905: 0xF958,
	40284 - 11905: 0xF959,
	40285 - 11905: 0xF95A,
	40286 - 11905: 0xF95B,
	40287 - 11905: 0xF95C,
	40288 - 11905: 0xF95D,
	40289 - 11905: 0xF95E,
	40290 - 11905: 0xF95F,
	40291 - 11905: 0xF960,
	40292 - 11905: 0xF961,
	40293 - 11905: 0xF962,
	40294 - 11905: 0xF963,
	40295 - 11905: 0xF964,
	40296 - 11905: 0xF965,
	40297 - 11905: 0xF966,
	40298 - 11905: 0xF967,
	40299 - 11905: 0xF968,
	40300 - 11905: 0xF969,
	40301 - 11905: 0xF96A,
	40302 - 11905: 0xF96B,
	40303 - 11905: 0xF96C,
	40304 - 11905: 0xF96D,
	40305 - 11905: 0xF96E,
	40306 - 11905: 0xF96F,
	40307 - 11905: 0xF970,
	40308 - 11905: 0xF971,
	40309 - 11905: 0xF972,
	40310 - 11905: 0xF973,
	40311 - 11905: 0xF974,
	40312 - 11905: 0xF975,
	40313 - 11905: 0xF976,
	40314 - 11905: 0xF977,
	40315 - 11905: 0xF978,
	40316 - 11905: 0xF979,
	40317 - 11905: 0xF97A,
	40318 - 11905: 0xF97B,
	40319 - 11905: 0xF97C,
	40320 - 11905: 0xF97D,
	40321 - 11905: 0xF97E,
	40322 - 11905: 0xF980,
	40323 - 11905: 0xF981,
	40324 - 11905: 0xF982,
	40325 - 11905: 0xF983,
	40326 - 11905: 0xF984,
	40327 - 11905: 0xF985,
	40328 - 11905: 0xF986,
	40329 - 11905: 0xF987,
	40330 - 11905: 0xF988,
	40331 - 11905: 0xF989,
	40332 - 11905: 0xF98A,
	40333 - 11905: 0xF98B,
	40334 - 11905: 0xF98C,
	40335 - 11905: 0xF98D,
	40336 - 11905: 0xF98E,
	40337 - 11905: 0xF98F,
	40338 - 11905: 0xF990,
	40339 - 11905: 0xF991,
	40340 - 11905: 0xF992,
	40341 - 11905: 0xF993,
	40342 - 11905: 0xF994,
	40343 - 11905: 0xF995,
	40344 - 11905: 0xF996,
	40345 - 11905: 0xF997,
	40346 - 11905: 0xF998,
	40347 - 11905: 0xF999,
	40348 - 11905: 0xF99A,
	40349 - 11905: 0xF99B,
	40350 - 11905: 0xF99C,
	40351 - 11905: 0xF99D,
	40352 - 11905: 0xF99E,
	40353 - 11905: 0xF99F,
	40354 - 11905: 0xF9A0,
	40355 - 11905: 0xFA40,
	40356 - 11905: 0xFA41,
	40357 - 11905: 0xFA42,
	40358 - 11905: 0xFA43,
	40359 - 11905: 0xFA44,
	40360 - 11905: 0xFA45,
	40361 - 11905: 0xFA46,
	40362 - 11905: 0xFA47,
	40363 - 11905: 0xFA48,
	40364 - 11905: 0xFA49,
	40365 - 11905: 0xFA4A,
	40366 - 11905: 0xFA4B,
	40367 - 11905: 0xFA4C,
	40368 - 11905: 0xFA4D,
	40369 - 11905: 0xFA4E,
	40370 - 11905: 0xFA4F,
	40371 - 11905: 0xFA50,
	40372 - 11905: 0xFA51,
	40373 - 11905: 0xFA52,
	40374 - 11905: 0xFA53,
	40375 - 11905: 0xFA54,
	40376 - 11905: 0xFA55,
	40377 - 11905: 0xFA56,
	40378 - 11905: 0xFA57,
	40379 - 11905: 0xFA58,
	40380 - 11905: 0xFA59,
	40381 - 11905: 0xFA5A,
	40382 - 11905: 0xFA5B,
	40383 - 11905: 0xFA5C,
	40384 - 11905: 0xFA5D,
	40385 - 11905: 0xFA5E,
	40386 - 11905: 0xFA5F,
	40387 - 11905: 0xFA60,
	40388 - 11905: 0xFA61,
	40389 - 11905: 0xFA62,
	40390 - 11905: 0xFA63,
	40391 - 11905: 0xFA64,
	40392 - 11905: 0xFA65,
	40393 - 11905: 0xFA66,
	40394 - 11905: 0xFA67,
	40395 - 11905: 0xFA68,
	40396 - 11905: 0xFA69,
	40397 - 11905: 0xFA6A,
	40398 - 11905: 0xFA6B,
	40399 - 11905: 0xFA6C,
	40400 - 11905: 0xFA6D,
	40401 - 11905: 0xFA6E,
	40402 - 11905: 0xFA6F,
	40403 - 11905: 0xFA70,
	40404 - 11905: 0xFA71,
	40405 - 11905: 0xFA72,
	40406 - 11905: 0xFA73,
	40407 - 11905: 0xFA74,
	40408 - 11905: 0xFA75,
	40409 - 11905: 0xFA76,
	40410 - 11905: 0xFA77,
	40411 - 11905: 0xFA78,
	40412 - 11905: 0xFA79,
	40413 - 11905: 0xFA7A,
	40414 - 11905: 0xFA7B,
	40415 - 11905: 0xFA7C,
	40416 - 11905: 0xFA7D,
	40417 - 11905: 0xFA7E,
	40418 - 11905: 0xFA80,
	40419 - 11905: 0xFA81,
	40420 - 11905: 0xFA82,
	40421 - 11905: 0xFA83,
	40422 - 11905: 0xFA84,
	40423 - 11905: 0xFA85,
	40424 - 11905: 0xFA86,
	40425 - 11905: 0xFA87,
	40426 - 11905: 0xFA88,
	40427 - 11905: 0xFA89,
	40428 - 11905: 0xFA8A,
	40429 - 11905: 0xFA8B,
	40430 - 11905: 0xFA8C,
	40431 - 11905: 0xFA8D,
	40432 - 11905: 0xFA8E,
	40433 - 11905: 0xFA8F,
	40434 - 11905: 0xFA90,
	40435 - 11905: 0xFA91,
	40436 - 11905: 0xFA92,
	40437 - 11905: 0xFA93,
	40438 - 11905: 0xFA94,
	40439 - 11905: 0xFA95,
	40440 - 11905: 0xFA96,
	40441 - 11905: 0xFA97,
	40442 - 11905: 0xFA98,
	40443 - 11905: 0xFA99,
	40444 - 11905: 0xFA9A,
	40445 - 11905: 0xFA9B,
	40446 - 11905: 0xFA9C,
	40447 - 11905: 0xFA9D,
	40448 - 11905: 0xFA9E,
	40449 - 11905: 0xFA9F,
	40450 - 11905: 0xFAA0,
	40451 - 11905: 0xFB40,
	40452 - 11905: 0xFB41,
	40453 - 11905: 0xFB42,
	40454 - 11905: 0xFB43,
	40455 - 11905: 0xFB44,
	40456 - 11905: 0xFB45,
	40457 - 11905: 0xFB46,
	40458 - 11905: 0xFB47,
	40459 - 11905: 0xFB48,
	40460 - 11905: 0xFB49,
	40461 - 11905: 0xFB4A,
	40462 - 11905: 0xFB4B,
	40463 - 11905: 0xFB4C,
	40464 - 11905: 0xFB4D,
	40465 - 11905: 0xFB4E,
	40466 - 11905: 0xFB4F,
	40467 - 11905: 0xFB50,
	40468 - 11905: 0xFB51,
	40469 - 11905: 0xFB52,
	40470 - 11905: 0xFB53,
	40471 - 11905: 0xFB54,
	40472 - 11905: 0xFB55,
	40473 - 11905: 0xFB56,
	40474 - 11905: 0xFB57,
	40475 - 11905: 0xFB58,
	40476 - 11905: 0xFB59,
	40477 - 11905: 0xFB5A,
	40478 - 11905: 0xFB5B,
	40479 - 11905: 0xC4F1,
	40480 - 11905: 0xF0AF,
	40481 - 11905: 0xBCA6,
	40482 - 11905: 0xF0B0,
	40483 - 11905: 0xC3F9,
	40484 - 11905: 0xFB5C,
	40485 - 11905: 0xC5B8,
	40486 - 11905: 0xD1BB,
	40487 - 11905: 0xFB5D,
	40488 - 11905: 0xF0B1,
	40489 - 11905: 0xF0B2,
	40490 - 11905: 0xF0B3,
	40491 - 11905: 0xF0B4,
	40492 - 11905: 0xF0B5,
	40493 - 11905: 0xD1BC,
	40494 - 11905: 0xFB5E,
	40495 - 11905: 0xD1EC,
	40496 - 11905: 0xFB5F,
	40497 - 11905: 0xF0B7,
	40498 - 11905: 0xF0B6,
	40499 - 11905: 0xD4A7,
	40500 - 11905: 0xFB60,
	40501 - 11905: 0xCDD2,
	40502 - 11905: 0xF0B8,
	40503 - 11905: 0xF0BA,
	40504 - 11905: 0xF0B9,
	40505 - 11905: 0xF0BB,
	40506 - 11905: 0xF0BC,
	40507 - 11905: 0xFB61,
	40508 - 11905: 0xFB62,
	40509 - 11905: 0xB8EB,
	40510 - 11905: 0xF0BD,
	40511 - 11905: 0xBAE8,
	40512 - 11905: 0xFB63,
	40513 - 11905: 0xF0BE,
	40514 - 11905: 0xF0BF,
	40515 - 11905: 0xBEE9,
	40516 - 11905: 0xF0C0,
	40517 - 11905: 0xB6EC,
	40518 - 11905: 0xF0C1,
	40519 - 11905: 0xF0C2,
	40520 - 11905: 0xF0C3,
	40521 - 11905: 0xF0C4,
	40522 - 11905: 0xC8B5,
	40523 - 11905: 0xF0C5,
	40524 - 11905: 0xF0C6,
	40525 - 11905: 0xFB64,
	40526 - 11905: 0xF0C7,
	40527 - 11905: 0xC5F4,
	40528 - 11905: 0xFB65,
	40529 - 11905: 0xF0C8,
	40530 - 11905: 0xFB66,
	40531 - 11905: 0xFB67,
	40532 - 11905: 0xFB68,
	40533 - 11905: 0xF0C9,
	40534 - 11905: 0xFB69,
	40535 - 11905: 0xF0CA,
	40536 - 11905: 0xF7BD,
	40537 - 11905: 0xFB6A,
	40538 - 11905: 0xF0CB,
	40539 - 11905: 0xF0CC,
	40540 - 11905: 0xF0CD,
	40541 - 11905: 0xFB6B,
	40542 - 11905: 0xF0CE,
	40543 - 11905: 0xFB6C,
	40544 - 11905: 0xFB6D,
	40545 - 11905: 0xFB6E,
	40546 - 11905: 0xFB6F,
	40547 - 11905: 0xF0CF,
	40548 - 11905: 0xBAD7,
	40549 - 11905: 0xFB70,
	40550 - 11905: 0xF0D0,
	40551 - 11905: 0xF0D1,
	40552 - 11905: 0xF0D2,
	40553 - 11905: 0xF0D3,
	40554 - 11905: 0xF0D4,
	40555 - 11905: 0xF0D5,
	40556 - 11905: 0xF0D6,
	40557 - 11905: 0xF0D8,
	40558 - 11905: 0xFB71,
	40559 - 11905: 0xFB72,
	40560 - 11905: 0xD3A5,
	40561 - 11905: 0xF0D7,
	40562 - 11905: 0xFB73,
	40563 - 11905: 0xF0D9,
	40564 - 11905: 0xFB74,
	40565 - 11905: 0xFB75,
	40566 - 11905: 0xFB76,
	40567 - 11905: 0xFB77,
	40568 - 11905: 0xFB78,
	40569 - 11905: 0xFB79,
	40570 - 11905: 0xFB7A,
	40571 - 11905: 0xFB7B,
	40572 - 11905: 0xFB7C,
	40573 - 11905: 0xFB7D,
	40574 - 11905: 0xF5BA,
	40575 - 11905: 0xC2B9,
	40576 - 11905: 0xFB7E,
	40577 - 11905: 0xFB80,
	40578 - 11905: 0xF7E4,
	40579 - 11905: 0xFB81,
	40580 - 11905: 0xFB82,
	40581 - 11905: 0xFB83,
	40582 - 11905: 0xFB84,
	40583 - 11905: 0xF7E5,
	40584 - 11905: 0xF7E6,
	40585 - 11905: 0xFB85,
	40586 - 11905: 0xFB86,
	40587 - 11905: 0xF7E7,
	40588 - 11905: 0xFB87,
	40589 - 11905: 0xFB88,
	40590 - 11905: 0xFB89,
	40591 - 11905: 0xFB8A,
	40592 - 11905: 0xFB8B,
	40593 - 11905: 0xFB8C,
	40594 - 11905: 0xF7E8,
	40595 - 11905: 0xC2B4,
	40596 - 11905: 0xFB8D,
	40597 - 11905: 0xFB8E,
	40598 - 11905: 0xFB8F,
	40599 - 11905: 0xFB90,
	40600 - 11905: 0xFB91,
	40601 - 11905: 0xFB92,
	40602 - 11905: 0xFB93,
	40603 - 11905: 0xFB94,
	40604 - 11905: 0xFB95,
	40605 - 11905: 0xF7EA,
	40606 - 11905: 0xFB96,
	40607 - 11905: 0xF7EB,
	40608 - 11905: 0xFB97,
	40609 - 11905: 0xFB98,
	40610 - 11905: 0xFB99,
	40611 - 11905: 0xFB9A,
	40612 - 11905: 0xFB9B,
	40613 - 11905: 0xFB9C,
	40614 - 11905: 0xC2F3,
	40615 - 11905: 0xFB9D,
	40616 - 11905: 0xFB9E,
	40617 - 11905: 0xFB9F,
	40618 - 11905: 0xFBA0,
	40619 - 11905: 0xFC40,
	40620 - 11905: 0xFC41,
	40621 - 11905: 0xFC42,
	40622 - 11905: 0xFC43,
	40623 - 11905: 0xFC44,
	40624 - 11905: 0xFC45,
	40625 - 11905: 0xFC46,
	40626 - 11905: 0xFC47,
	40627 - 11905: 0xFC48,
	40628 - 11905: 0xF4F0,
	40629 - 11905: 0xFC49,
	40630 - 11905: 0xFC4A,
	40631 - 11905: 0xFC4B,
	40632 - 11905: 0xF4EF,
	40633 - 11905: 0xFC4C,
	40634 - 11905: 0xFC4D,
	40635 - 11905: 0xC2E9,
	40636 - 11905: 0xFC4E,
	40637 - 11905: 0xF7E1,
	40638 - 11905: 0xF7E2,
	40639 - 11905: 0xFC4F,
	40640 - 11905: 0xFC50,
	40641 - 11905: 0xFC51,
	40642 - 11905: 0xFC52,
	40643 - 11905: 0xFC53,
	40644 - 11905: 0xBBC6,
	40645 - 11905: 0xFC54,
	40646 - 11905: 0xFC55,
	40647 - 11905: 0xFC56,
	40648 - 11905: 0xFC57,
	40649 - 11905: 0xD9E4,
	40650 - 11905: 0xFC58,
	40651 - 11905: 0xFC59,
	40652 - 11905: 0xFC5A,
	40653 - 11905: 0xCAF2,
	40654 - 11905: 0xC0E8,
	40655 - 11905: 0xF0A4,
	40656 - 11905: 0xFC5B,
	40657 - 11905: 0xBADA,
	40658 - 11905: 0xFC5C,
	40659 - 11905: 0xFC5D,
	40660 - 11905: 0xC7AD,
	40661 - 11905: 0xFC5E,
	40662 - 11905: 0xFC5F,
	40663 - 11905: 0xFC60,
	40664 - 11905: 0xC4AC,
	40665 - 11905: 0xFC61,
	40666 - 11905: 0xFC62,
	40667 - 11905: 0xF7EC,
	40668 - 11905: 0xF7ED,
	40669 - 11905: 0xF7EE,
	40670 - 11905: 0xFC63,
	40671 - 11905: 0xF7F0,
	40672 - 11905: 0xF7EF,
	40673 - 11905: 0xFC64,
	40674 - 11905: 0xF7F1,
	40675 - 11905: 0xFC65,
	40676 - 11905: 0xFC66,
	40677 - 11905: 0xF7F4,
	40678 - 11905: 0xFC67,
	40679 - 11905: 0xF7F3,
	40680 - 11905: 0xFC68,
	40681 - 11905: 0xF7F2,
	40682 - 11905: 0xF7F5,
	40683 - 11905: 0xFC69,
	40684 - 11905: 0xFC6A,
	40685 - 11905: 0xFC6B,
	40686 - 11905: 0xFC6C,
	40687 - 11905: 0xF7F6,
	40688 - 11905: 0xFC6D,
	40689 - 11905: 0xFC6E,
	40690 - 11905: 0xFC6F,
	40691 - 11905: 0xFC70,
	40692 - 11905: 0xFC71,
	40693 - 11905: 0xFC72,
	40694 - 11905: 0xFC73,
	40695 - 11905: 0xFC74,
	40696 - 11905: 0xFC75,
	40697 - 11905: 0xEDE9,
	40698 - 11905: 0xFC76,
	40699 - 11905: 0xEDEA,
	40700 - 11905: 0xEDEB,
	40701 - 11905: 0xFC77,
	40702 - 11905: 0xF6BC,
	40703 - 11905: 0xFC78,
	40704 - 11905: 0xFC79,
	40705 - 11905: 0xFC7A,
	40706 - 11905: 0xFC7B,
	40707 - 11905: 0xFC7C,
	40708 - 11905: 0xFC7D,
	40709 - 11905: 0xFC7E,
	40710 - 11905: 0xFC80,
	40711 - 11905: 0xFC81,
	40712 - 11905: 0xFC82,
	40713 - 11905: 0xFC83,
	40714 - 11905: 0xFC84,
	40715 - 11905: 0xF6BD,
	40716 - 11905: 0xFC85,
	40717 - 11905: 0xF6BE,
	40718 - 11905: 0xB6A6,
	40719 - 11905: 0xFC86,
	40720 - 11905: 0xD8BE,
	40721 - 11905: 0xFC87,
	40722 - 11905: 0xFC88,
	40723 - 11905: 0xB9C4,
	40724 - 11905: 0xFC89,
	40725 - 11905: 0xFC8A,
	40726 - 11905: 0xFC8B,
	40727 - 11905: 0xD8BB,
	40728 - 11905: 0xFC8C,
	40729 - 11905: 0xDCB1,
	40730 - 11905: 0xFC8D,
	40731 - 11905: 0xFC8E,
	40732 - 11905: 0xFC8F,
	40733 - 11905: 0xFC90,
	40734 - 11905: 0xFC91,
	40735 - 11905: 0xFC92,
	40736 - 11905: 0xCAF3,
	40737 - 11905: 0xFC93,
	40738 - 11905: 0xF7F7,
	40739 - 11905: 0xFC94,
	40740 - 11905: 0xFC95,
	40741 - 11905: 0xFC96,
	40742 - 11905: 0xFC97,
	40743 - 11905: 0xFC98,
	40744 - 11905: 0xFC99,
	40745 - 11905: 0xFC9A,
	40746 - 11905: 0xFC9B,
	40747 - 11905: 0xFC9C,
	40748 - 11905: 0xF7F8,
	40749 - 11905: 0xFC9D,
	40750 - 11905: 0xFC9E,
	40751 - 11905: 0xF7F9,
	40752 - 11905: 0xFC9F,
	40753 - 11905: 0xFCA0,
	40754 - 11905: 0xFD40,
	40755 - 11905: 0xFD41,
	40756 - 11905: 0xFD42,
	40757 - 11905: 0xFD43,
	40758 - 11905: 0xFD44,
	40759 - 11905: 0xF7FB,
	40760 - 11905: 0xFD45,
	40761 - 11905: 0xF7FA,
	40762 - 11905: 0xFD46,
	40763 - 11905: 0xB1C7,
	40764 - 11905: 0xFD47,
	40765 - 11905: 0xF7FC,
	40766 - 11905: 0xF7FD,
	40767 - 11905: 0xFD48,
	40768 - 11905: 0xFD49,
	40769 - 11905: 0xFD4A,
	40770 - 11905: 0xFD4B,
	40771 - 11905: 0xFD4C,
	40772 - 11905: 0xF7FE,
	40773 - 11905: 0xFD4D,
	40774 - 11905: 0xFD4E,
	40775 - 11905: 0xFD4F,
	40776 - 11905: 0xFD50,
	40777 - 11905: 0xFD51,
	40778 - 11905: 0xFD52,
	40779 - 11905: 0xFD53,
	40780 - 11905: 0xFD54,
	40781 - 11905: 0xFD55,
	40782 - 11905: 0xFD56,
	40783 - 11905: 0xFD57,
	40784 - 11905: 0xC6EB,
	40785 - 11905: 0xECB4,
	40786 - 11905: 0xFD58,
	40787 - 11905: 0xFD59,
	40788 - 11905: 0xFD5A,
	40789 - 11905: 0xFD5B,
	40790 - 11905: 0xFD5C,
	40791 - 11905: 0xFD5D,
	40792 - 11905: 0xFD5E,
	40793 - 11905: 0xFD5F,
	40794 - 11905: 0xFD60,
	40795 - 11905: 0xFD61,
	40796 - 11905: 0xFD62,
	40797 - 11905: 0xFD63,
	40798 - 11905: 0xFD64,
	40799 - 11905: 0xFD65,
	40800 - 11905: 0xFD66,
	40801 - 11905: 0xFD67,
	40802 - 11905: 0xFD68,
	40803 - 11905: 0xFD69,
	40804 - 11905: 0xFD6A,
	40805 - 11905: 0xFD6B,
	40806 - 11905: 0xFD6C,
	40807 - 11905: 0xFD6D,
	40808 - 11905: 0xFD6E,
	40809 - 11905: 0xFD6F,
	40810 - 11905: 0xFD70,
	40811 - 11905: 0xFD71,
	40812 - 11905: 0xFD72,
	40813 - 11905: 0xFD73,
	40814 - 11905: 0xFD74,
	40815 - 11905: 0xFD75,
	40816 - 11905: 0xFD76,
	40817 - 11905: 0xFD77,
	40818 - 11905: 0xFD78,
	40819 - 11905: 0xFD79,
	40820 - 11905: 0xFD7A,
	40821 - 11905: 0xFD7B,
	40822 - 11905: 0xFD7C,
	40823 - 11905: 0xFD7D,
	40824 - 11905: 0xFD7E,
	40825 - 11905: 0xFD80,
	40826 - 11905: 0xFD81,
	40827 - 11905: 0xFD82,
	40828 - 11905: 0xFD83,
	40829 - 11905: 0xFD84,
	40830 - 11905: 0xFD85,
	40831 - 11905: 0xB3DD,
	40832 - 11905: 0xF6B3,
	40833 - 11905: 0xFD86,
	40834 - 11905: 0xFD87,
	40835 - 11905: 0xF6B4,
	40836 - 11905: 0xC1E4,
	40837 - 11905: 0xF6B5,
	40838 - 11905: 0xF6B6,
	40839 - 11905: 0xF6B7,
	40840 - 11905: 0xF6B8,
	40841 - 11905: 0xF6B9,
	40842 - 11905: 0xF6BA,
	40843 - 11905: 0xC8A3,
	40844 - 11905: 0xF6BB,
	40845 - 11905: 0xFD88,
	40846 - 11905: 0xFD89,
	40847 - 11905: 0xFD8A,
	40848 - 11905: 0xFD8B,
	40849 - 11905: 0xFD8C,
	40850 - 11905: 0xFD8D,
	40851 - 11905: 0xFD8E,
	40852 - 11905: 0xFD8F,
	40853 - 11905: 0xFD90,
	40854 - 11905: 0xFD91,
	40855 - 11905: 0xFD92,
	40856 - 11905: 0xFD93,
	40857 - 11905: 0xC1FA,
	40858 - 11905: 0xB9A8,
	40859 - 11905: 0xEDE8,
	40860 - 11905: 0xFD94,
	40861 - 11905: 0xFD95,
	40862 - 11905: 0xFD96,
	40863 - 11905: 0xB9EA,
	40864 - 11905: 0xD9DF,
	40865 - 11905: 0xFD97,
	40866 - 11905: 0xFD98,
	40867 - 11905: 0xFD99,
	40868 - 11905: 0xFD9A,
	40869 - 11905: 0xFD9B,
}

const encode1Low, encode1High = 8208, 9795

var encode1 = [...]uint16{
	8208 - 8208: 0xA95C,
	8211 - 8208: 0xA843,
	8212 - 8208: 0xA1AA,
	8213 - 8208: 0xA844,
	8214 - 8208: 0xA1AC,
	8216 - 8208: 0xA1AE,
	8217 - 8208: 0xA1AF,
	8220 - 8208: 0xA1B0,
	8221 - 8208: 0xA1B1,
	8229 - 8208: 0xA845,
	8230 - 8208: 0xA1AD,
	8240 - 8208: 0xA1EB,
	8242 - 8208: 0xA1E4,
	8243 - 8208: 0xA1E5,
	8245 - 8208: 0xA846,
	8251 - 8208: 0xA1F9,
	8364 - 8208: 0xA2E3,
	8451 - 8208: 0xA1E6,
	8453 - 8208: 0xA847,
	8457 - 8208: 0xA848,
	8470 - 8208: 0xA1ED,
	8481 - 8208: 0xA959,
	8544 - 8208: 0xA2F1,
	8545 - 8208: 0xA2F2,
	8546 - 8208: 0xA2F3,
	8547 - 8208: 0xA2F4,
	8548 - 8208: 0xA2F5,
	8549 - 8208: 0xA2F6,
	8550 - 8208: 0xA2F7,
	8551 - 8208: 0xA2F8,
	8552 - 8208: 0xA2F9,
	8553 - 8208: 0xA2FA,
	8554 - 8208: 0xA2FB,
	8555 - 8208: 0xA2FC,
	8560 - 8208: 0xA2A1,
	8561 - 8208: 0xA2A2,
	8562 - 8208: 0xA2A3,
	8563 - 8208: 0xA2A4,
	8564 - 8208: 0xA2A5,
	8565 - 8208: 0xA2A6,
	8566 - 8208: 0xA2A7,
	8567 - 8208: 0xA2A8,
	8568 - 8208: 0xA2A9,
	8569 - 8208: 0xA2AA,
	8592 - 8208: 0xA1FB,
	8593 - 8208: 0xA1FC,
	8594 - 8208: 0xA1FA,
	8595 - 8208: 0xA1FD,
	8598 - 8208: 0xA849,
	8599 - 8208: 0xA84A,
	8600 - 8208: 0xA84B,
	8601 - 8208: 0xA84C,
	8712 - 8208: 0xA1CA,
	8719 - 8208: 0xA1C7,
	8721 - 8208: 0xA1C6,
	8725 - 8208: 0xA84D,
	8730 - 8208: 0xA1CC,
	8733 - 8208: 0xA1D8,
	8734 - 8208: 0xA1DE,
	8735 - 8208: 0xA84E,
	8736 - 8208: 0xA1CF,
	8739 - 8208: 0xA84F,
	8741 - 8208: 0xA1CE,
	8743 - 8208: 0xA1C4,
	8744 - 8208: 0xA1C5,
	8745 - 8208: 0xA1C9,
	8746 - 8208: 0xA1C8,
	8747 - 8208: 0xA1D2,
	8750 - 8208: 0xA1D3,
	8756 - 8208: 0xA1E0,
	8757 - 8208: 0xA1DF,
	8758 - 8208: 0xA1C3,
	8759 - 8208: 0xA1CB,
	8765 - 8208: 0xA1D7,
	8776 - 8208: 0xA1D6,
	8780 - 8208: 0xA1D5,
	8786 - 8208: 0xA850,
	8800 - 8208: 0xA1D9,
	8801 - 8208: 0xA1D4,
	8804 - 8208: 0xA1DC,
	8805 - 8208: 0xA1DD,
	8806 - 8208: 0xA851,
	8807 - 8208: 0xA852,
	8814 - 8208: 0xA1DA,
	8815 - 8208: 0xA1DB,
	8853 - 8208: 0xA892,
	8857 - 8208: 0xA1D1,
	8869 - 8208: 0xA1CD,
	8895 - 8208: 0xA853,
	8978 - 8208: 0xA1D0,
	9312 - 8208: 0xA2D9,
	9313 - 8208: 0xA2DA,
	9314 - 8208: 0xA2DB,
	9315 - 8208: 0xA2DC,
	9316 - 8208: 0xA2DD,
	9317 - 8208: 0xA2DE,
	9318 - 8208: 0xA2DF,
	9319 - 8208: 0xA2E0,
	9320 - 8208: 0xA2E1,
	9321 - 8208: 0xA2E2,
	9332 - 8208: 0xA2C5,
	9333 - 8208: 0xA2C6,
	9334 - 8208: 0xA2C7,
	9335 - 8208: 0xA2C8,
	9336 - 8208: 0xA2C9,
	9337 - 8208: 0xA2CA,
	9338 - 8208: 0xA2CB,
	9339 - 8208: 0xA2CC,
	9340 - 8208: 0xA2CD,
	9341 - 8208: 0xA2CE,
	9342 - 8208: 0xA2CF,
	9343 - 8208: 0xA2D0,
	9344 - 8208: 0xA2D1,
	9345 - 8208: 0xA2D2,
	9346 - 8208: 0xA2D3,
	9347 - 8208: 0xA2D4,
	9348 - 8208: 0xA2D5,
	9349 - 8208: 0xA2D6,
	9350 - 8208: 0xA2D7,
	9351 - 8208: 0xA2D8,
	9352 - 8208: 0xA2B1,
	9353 - 8208: 0xA2B2,
	9354 - 8208: 0xA2B3,
	9355 - 8208: 0xA2B4,
	9356 - 8208: 0xA2B5,
	9357 - 8208: 0xA2B6,
	9358 - 8208: 0xA2B7,
	9359 - 8208: 0xA2B8,
	9360 - 8208: 0xA2B9,
	9361 - 8208: 0xA2BA,
	9362 - 8208: 0xA2BB,
	9363 - 8208: 0xA2BC,
	9364 - 8208: 0xA2BD,
	9365 - 8208: 0xA2BE,
	9366 - 8208: 0xA2BF,
	9367 - 8208: 0xA2C0,
	9368 - 8208: 0xA2C1,
	9369 - 8208: 0xA2C2,
	9370 - 8208: 0xA2C3,
	9371 - 8208: 0xA2C4,
	9472 - 8208: 0xA9A4,
	9473 - 8208: 0xA9A5,
	9474 - 8208: 0xA9A6,
	9475 - 8208: 0xA9A7,
	9476 - 8208: 0xA9A8,
	9477 - 8208: 0xA9A9,
	9478 - 8208: 0xA9AA,
	9479 - 8208: 0xA9AB,
	9480 - 8208: 0xA9AC,
	9481 - 8208: 0xA9AD,
	9482 - 8208: 0xA9AE,
	9483 - 8208: 0xA9AF,
	9484 - 8208: 0xA9B0,
	9485 - 8208: 0xA9B1,
	9486 - 8208: 0xA9B2,
	9487 - 8208: 0xA9B3,
	9488 - 8208: 0xA9B4,
	9489 - 8208: 0xA9B5,
	9490 - 8208: 0xA9B6,
	9491 - 8208: 0xA9B7,
	9492 - 8208: 0xA9B8,
	9493 - 8208: 0xA9B9,
	9494 - 8208: 0xA9BA,
	9495 - 8208: 0xA9BB,
	9496 - 8208: 0xA9BC,
	9497 - 8208: 0xA9BD,
	9498 - 8208: 0xA9BE,
	9499 - 8208: 0xA9BF,
	9500 - 8208: 0xA9C0,
	9501 - 8208: 0xA9C1,
	9502 - 8208: 0xA9C2,
	9503 - 8208: 0xA9C3,
	9504 - 8208: 0xA9C4,
	9505 - 8208: 0xA9C5,
	9506 - 8208: 0xA9C6,
	9507 - 8208: 0xA9C7,
	9508 - 8208: 0xA9C8,
	9509 - 8208: 0xA9C9,
	9510 - 8208: 0xA9CA,
	9511 - 8208: 0xA9CB,
	9512 - 8208: 0xA9CC,
	9513 - 8208: 0xA9CD,
	9514 - 8208: 0xA9CE,
	9515 - 8208: 0xA9CF,
	9516 - 8208: 0xA9D0,
	9517 - 8208: 0xA9D1,
	9518 - 8208: 0xA9D2,
	9519 - 8208: 0xA9D3,
	9520 - 8208: 0xA9D4,
	9521 - 8208: 0xA9D5,
	9522 - 8208: 0xA9D6,
	9523 - 8208: 0xA9D7,
	9524 - 8208: 0xA9D8,
	9525 - 8208: 0xA9D9,
	9526 - 8208: 0xA9DA,
	9527 - 8208: 0xA9DB,
	9528 - 8208: 0xA9DC,
	9529 - 8208: 0xA9DD,
	9530 - 8208: 0xA9DE,
	9531 - 8208: 0xA9DF,
	9532 - 8208: 0xA9E0,
	9533 - 8208: 0xA9E1,
	9534 - 8208: 0xA9E2,
	9535 - 8208: 0xA9E3,
	9536 - 8208: 0xA9E4,
	9537 - 8208: 0xA9E5,
	9538 - 8208: 0xA9E6,
	9539 - 8208: 0xA9E7,
	9540 - 8208: 0xA9E8,
	9541 - 8208: 0xA9E9,
	9542 - 8208: 0xA9EA,
	9543 - 8208: 0xA9EB,
	9544 - 8208: 0xA9EC,
	9545 - 8208: 0xA9ED,
	9546 - 8208: 0xA9EE,
	9547 - 8208: 0xA9EF,
	9552 - 8208: 0xA854,
	9553 - 8208: 0xA855,
	9554 - 8208: 0xA856,
	9555 - 8208: 0xA857,
	9556 - 8208: 0xA858,
	9557 - 8208: 0xA859,
	9558 - 8208: 0xA85A,
	9559 - 8208: 0xA85B,
	9560 - 8208: 0xA85C,
	9561 - 8208: 0xA85D,
	9562 - 8208: 0xA85E,
	9563 - 8208: 0xA85F,
	9564 - 8208: 0xA860,
	9565 - 8208: 0xA861,
	9566 - 8208: 0xA862,
	9567 - 8208: 0xA863,
	9568 - 8208: 0xA864,
	9569 - 8208: 0xA865,
	9570 - 8208: 0xA866,
	9571 - 8208: 0xA867,
	9572 - 8208: 0xA868,
	9573 - 8208: 0xA869,
	9574 - 8208: 0xA86A,
	9575 - 8208: 0xA86B,
	9576 - 8208: 0xA86C,
	9577 - 8208: 0xA86D,
	9578 - 8208: 0xA86E,
	9579 - 8208: 0xA86F,
	9580 - 8208: 0xA870,
	9581 - 8208: 0xA871,
	9582 - 8208: 0xA872,
	9583 - 8208: 0xA873,
	9584 - 8208: 0xA874,
	9585 - 8208: 0xA875,
	9586 - 8208: 0xA876,
	9587 - 8208: 0xA877,
	9601 - 8208: 0xA878,
	9602 - 8208: 0xA879,
	9603 - 8208: 0xA87A,
	9604 - 8208: 0xA87B,
	9605 - 8208: 0xA87C,
	9606 - 8208: 0xA87D,
	9607 - 8208: 0xA87E,
	9608 - 8208: 0xA880,
	9609 - 8208: 0xA881,
	9610 - 8208: 0xA882,
	9611 - 8208: 0xA883,
	9612 - 8208: 0xA884,
	9613 - 8208: 0xA885,
	9614 - 8208: 0xA886,
	9615 - 8208: 0xA887,
	9619 - 8208: 0xA888,
	9620 - 8208: 0xA889,
	9621 - 8208: 0xA88A,
	9632 - 8208: 0xA1F6,
	9633 - 8208: 0xA1F5,
	9650 - 8208: 0xA1F8,
	9651 - 8208: 0xA1F7,
	9660 - 8208: 0xA88B,
	9661 - 8208: 0xA88C,
	9670 - 8208: 0xA1F4,
	9671 - 8208: 0xA1F3,
	9675 - 8208: 0xA1F0,
	9678 - 8208: 0xA1F2,
	9679 - 8208: 0xA1F1,
	9698 - 8208: 0xA88D,
	9699 - 8208: 0xA88E,
	9700 - 8208: 0xA88F,
	9701 - 8208: 0xA890,
	9733 - 8208: 0xA1EF,
	9734 - 8208: 0xA1EE,
	9737 - 8208: 0xA891,
	9792 - 8208: 0xA1E2,
	9794 - 8208: 0xA1E1,
}

const encode2Low, encode2High = 164, 1106

var encode2 = [...]uint16{
	164 - 164:  0xA1E8,
	167 - 164:  0xA1EC,
	168 - 164:  0xA1A7,
	176 - 164:  0xA1E3,
	177 - 164:  0xA1C0,
	183 - 164:  0xA1A4,
	215 - 164:  0xA1C1,
	224 - 164:  0xA8A4,
	225 - 164:  0xA8A2,
	232 - 164:  0xA8A8,
	233 - 164:  0xA8A6,
	234 - 164:  0xA8BA,
	236 - 164:  0xA8AC,
	237 - 164:  0xA8AA,
	242 - 164:  0xA8B0,
	243 - 164:  0xA8AE,
	247 - 164:  0xA1C2,
	249 - 164:  0xA8B4,
	250 - 164:  0xA8B2,
	252 - 164:  0xA8B9,
	257 - 164:  0xA8A1,
	275 - 164:  0xA8A5,
	283 - 164:  0xA8A7,
	299 - 164:  0xA8A9,
	324 - 164:  0xA8BD,
	328 - 164:  0xA8BE,
	333 - 164:  0xA8AD,
	363 - 164:  0xA8B1,
	462 - 164:  0xA8A3,
	464 - 164:  0xA8AB,
	466 - 164:  0xA8AF,
	468 - 164:  0xA8B3,
	470 - 164:  0xA8B5,
	472 - 164:  0xA8B6,
	474 - 164:  0xA8B7,
	476 - 164:  0xA8B8,
	505 - 164:  0xA8BF,
	593 - 164:  0xA8BB,
	609 - 164:  0xA8C0,
	711 - 164:  0xA1A6,
	713 - 164:  0xA1A5,
	714 - 164:  0xA840,
	715 - 164:  0xA841,
	729 - 164:  0xA842,
	913 - 164:  0xA6A1,
	914 - 164:  0xA6A2,
	915 - 164:  0xA6A3,
	916 - 164:  0xA6A4,
	917 - 164:  0xA6A5,
	918 - 164:  0xA6A6,
	919 - 164:  0xA6A7,
	920 - 164:  0xA6A8,
	921 - 164:  0xA6A9,
	922 - 164:  0xA6AA,
	923 - 164:  0xA6AB,
	924 - 164:  0xA6AC,
	925 - 164:  0xA6AD,
	926 - 164:  0xA6AE,
	927 - 164:  0xA6AF,
	928 - 164:  0xA6B0,
	929 - 164:  0xA6B1,
	931 - 164:  0xA6B2,
	932 - 164:  0xA6B3,
	933 - 164:  0xA6B4,
	934 - 164:  0xA6B5,
	935 - 164:  0xA6B6,
	936 - 164:  0xA6B7,
	937 - 164:  0xA6B8,
	945 - 164:  0xA6C1,
	946 - 164:  0xA6C2,
	947 - 164:  0xA6C3,
	948 - 164:  0xA6C4,
	949 - 164:  0xA6C5,
	950 - 164:  0xA6C6,
	951 - 164:  0xA6C7,
	952 - 164:  0xA6C8,
	953 - 164:  0xA6C9,
	954 - 164:  0xA6CA,
	955 - 164:  0xA6CB,
	956 - 164:  0xA6CC,
	957 - 164:  0xA6CD,
	958 - 164:  0xA6CE,
	959 - 164:  0xA6CF,
	960 - 164:  0xA6D0,
	961 - 164:  0xA6D1,
	963 - 164:  0xA6D2,
	964 - 164:  0xA6D3,
	965 - 164:  0xA6D4,
	966 - 164:  0xA6D5,
	967 - 164:  0xA6D6,
	968 - 164:  0xA6D7,
	969 - 164:  0xA6D8,
	1025 - 164: 0xA7A7,
	1040 - 164: 0xA7A1,
	1041 - 164: 0xA7A2,
	1042 - 164: 0xA7A3,
	1043 - 164: 0xA7A4,
	1044 - 164: 0xA7A5,
	1045 - 164: 0xA7A6,
	1046 - 164: 0xA7A8,
	1047 - 164: 0xA7A9,
	1048 - 164: 0xA7AA,
	1049 - 164: 0xA7AB,
	1050 - 164: 0xA7AC,
	1051 - 164: 0xA7AD,
	1052 - 164: 0xA7AE,
	1053 - 164: 0xA7AF,
	1054 - 164: 0xA7B0,
	1055 - 164: 0xA7B1,
	1056 - 164: 0xA7B2,
	1057 - 164: 0xA7B3,
	1058 - 164: 0xA7B4,
	1059 - 164: 0xA7B5,
	1060 - 164: 0xA7B6,
	1061 - 164: 0xA7B7,
	1062 - 164: 0xA7B8,
	1063 - 164: 0xA7B9,
	1064 - 164: 0xA7BA,
	1065 - 164: 0xA7BB,
	1066 - 164: 0xA7BC,
	1067 - 164: 0xA7BD,
	1068 - 164: 0xA7BE,
	1069 - 164: 0xA7BF,
	1070 - 164: 0xA7C0,
	1071 - 164: 0xA7C1,
	1072 - 164: 0xA7D1,
	1073 - 164: 0xA7D2,
	1074 - 164: 0xA7D3,
	1075 - 164: 0xA7D4,
	1076 - 164: 0xA7D5,
	1077 - 164: 0xA7D6,
	1078 - 164: 0xA7D8,
	1079 - 164: 0xA7D9,
	1080 - 164: 0xA7DA,
	1081 - 164: 0xA7DB,
	1082 - 164: 0xA7DC,
	1083 - 164: 0xA7DD,
	1084 - 164: 0xA7DE,
	1085 - 164: 0xA7DF,
	1086 - 164: 0xA7E0,
	1087 - 164: 0xA7E1,
	1088 - 164: 0xA7E2,
	1089 - 164: 0xA7E3,
	1090 - 164: 0xA7E4,
	1091 - 164: 0xA7E5,
	1092 - 164: 0xA7E6,
	1093 - 164: 0xA7E7,
	1094 - 164: 0xA7E8,
	1095 - 164: 0xA7E9,
	1096 - 164: 0xA7EA,
	1097 - 164: 0xA7EB,
	1098 - 164: 0xA7EC,
	1099 - 164: 0xA7ED,
	1100 - 164: 0xA7EE,
	1101 - 164: 0xA7EF,
	1102 - 164: 0xA7F0,
	1103 - 164: 0xA7F1,
	1105 - 164: 0xA7D7,
}

const encode3Low, encode3High = 65072, 65510

var encode3 = [...]uint16{
	65072 - 65072: 0xA955,
	65073 - 65072: 0xA6F2,
	65075 - 65072: 0xA6F4,
	65076 - 65072: 0xA6F5,
	65077 - 65072: 0xA6E0,
	65078 - 65072: 0xA6E1,
	65079 - 65072: 0xA6F0,
	65080 - 65072: 0xA6F1,
	65081 - 65072: 0xA6E2,
	65082 - 65072: 0xA6E3,
	65083 - 65072: 0xA6EE,
	65084 - 65072: 0xA6EF,
	65085 - 65072: 0xA6E6,
	65086 - 65072: 0xA6E7,
	65087 - 65072: 0xA6E4,
	65088 - 65072: 0xA6E5,
	65089 - 65072: 0xA6E8,
	65090 - 65072: 0xA6E9,
	65091 - 65072: 0xA6EA,
	65092 - 65072: 0xA6EB,
	65097 - 65072: 0xA968,
	65098 - 65072: 0xA969,
	65099 - 65072: 0xA96A,
	65100 - 65072: 0xA96B,
	65101 - 65072: 0xA96C,
	65102 - 65072: 0xA96D,
	65103 - 65072: 0xA96E,
	65104 - 65072: 0xA96F,
	65105 - 65072: 0xA970,
	65106 - 65072: 0xA971,
	65108 - 65072: 0xA972,
	65109 - 65072: 0xA973,
	65110 - 65072: 0xA974,
	65111 - 65072: 0xA975,
	65113 - 65072: 0xA976,
	65114 - 65072: 0xA977,
	65115 - 65072: 0xA978,
	65116 - 65072: 0xA979,
	65117 - 65072: 0xA97A,
	65118 - 65072: 0xA97B,
	65119 - 65072: 0xA97C,
	65120 - 65072: 0xA97D,
	65121 - 65072: 0xA97E,
	65122 - 65072: 0xA980,
	65123 - 65072: 0xA981,
	65124 - 65072: 0xA982,
	65125 - 65072: 0xA983,
	65126 - 65072: 0xA984,
	65128 - 65072: 0xA985,
	65129 - 65072: 0xA986,
	65130 - 65072: 0xA987,
	65131 - 65072: 0xA988,
	65281 - 65072: 0xA3A1,
	65282 - 65072: 0xA3A2,
	65283 - 65072: 0xA3A3,
	65284 - 65072: 0xA1E7,
	65285 - 65072: 0xA3A5,
	65286 - 65072: 0xA3A6,
	65287 - 65072: 0xA3A7,
	65288 - 65072: 0xA3A8,
	65289 - 65072: 0xA3A9,
	65290 - 65072: 0xA3AA,
	65291 - 65072: 0xA3AB,
	65292 - 65072: 0xA3AC,
	65293 - 65072: 0xA3AD,
	65294 - 65072: 0xA3AE,
	65295 - 65072: 0xA3AF,
	65296 - 65072: 0xA3B0,
	65297 - 65072: 0xA3B1,
	65298 - 65072: 0xA3B2,
	65299 - 65072: 0xA3B3,
	65300 - 65072: 0xA3B4,
	65301 - 65072: 0xA3B5,
	65302 - 65072: 0xA3B6,
	65303 - 65072: 0xA3B7,
	65304 - 65072: 0xA3B8,
	65305 - 65072: 0xA3B9,
	65306 - 65072: 0xA3BA,
	65307 - 65072: 0xA3BB,
	65308 - 65072: 0xA3BC,
	65309 - 65072: 0xA3BD,
	65310 - 65072: 0xA3BE,
	65311 - 65072: 0xA3BF,
	65312 - 65072: 0xA3C0,
	65313 - 65072: 0xA3C1,
	65314 - 65072: 0xA3C2,
	65315 - 65072: 0xA3C3,
	65316 - 65072: 0xA3C4,
	65317 - 65072: 0xA3C5,
	65318 - 65072: 0xA3C6,
	65319 - 65072: 0xA3C7,
	65320 - 65072: 0xA3C8,
	65321 - 65072: 0xA3C9,
	65322 - 65072: 0xA3CA,
	65323 - 65072: 0xA3CB,
	65324 - 65072: 0xA3CC,
	65325 - 65072: 0xA3CD,
	65326 - 65072: 0xA3CE,
	65327 - 65072: 0xA3CF,
	65328 - 65072: 0xA3D0,
	65329 - 65072: 0xA3D1,
	65330 - 65072: 0xA3D2,
	65331 - 65072: 0xA3D3,
	65332 - 65072: 0xA3D4,
	65333 - 65072: 0xA3D5,
	65334 - 65072: 0xA3D6,
	65335 - 65072: 0xA3D7,
	65336 - 65072: 0xA3D8,
	65337 - 65072: 0xA3D9,
	65338 - 65072: 0xA3DA,
	65339 - 65072: 0xA3DB,
	65340 - 65072: 0xA3DC,
	65341 - 65072: 0xA3DD,
	65342 - 65072: 0xA3DE,
	65343 - 65072: 0xA3DF,
	65344 - 65072: 0xA3E0,
	65345 - 65072: 0xA3E1,
	65346 - 65072: 0xA3E2,
	65347 - 65072: 0xA3E3,
	65348 - 65072: 0xA3E4,
	65349 - 65072: 0xA3E5,
	65350 - 65072: 0xA3E6,
	65351 - 65072: 0xA3E7,
	65352 - 65072: 0xA3E8,
	65353 - 65072: 0xA3E9,
	65354 - 65072: 0xA3EA,
	65355 - 65072: 0xA3EB,
	65356 - 65072: 0xA3EC,
	65357 - 65072: 0xA3ED,
	65358 - 65072: 0xA3EE,
	65359 - 65072: 0xA3EF,
	65360 - 65072: 0xA3F0,
	65361 - 65072: 0xA3F1,
	65362 - 65072: 0xA3F2,
	65363 - 65072: 0xA3F3,
	65364 - 65072: 0xA3F4,
	65365 - 65072: 0xA3F5,
	65366 - 65072: 0xA3F6,
	65367 - 65072: 0xA3F7,
	65368 - 65072: 0xA3F8,
	65369 - 65072: 0xA3F9,
	65370 - 65072: 0xA3FA,
	65371 - 65072: 0xA3FB,
	65372 - 65072: 0xA3FC,
	65373 - 65072: 0xA3FD,
	65374 - 65072: 0xA1AB,
	65504 - 65072: 0xA1E9,
	65505 - 65072: 0xA1EA,
	65506 - 65072: 0xA956,
	65507 - 65072: 0xA3FE,
	65508 - 65072: 0xA957,
	65509 - 65072: 0xA3A4,
}

const encode4Low, encode4High = 63788, 64042

var encode4 = [...]uint16{
	63788 - 63788: 0xFD9C,
	63865 - 63788: 0xFD9D,
	63893 - 63788: 0xFD9E,
	63975 - 63788: 0xFD9F,
	63985 - 63788: 0xFDA0,
	64012 - 63788: 0xFE40,
	64013 - 63788: 0xFE41,
	64014 - 63788: 0xFE42,
	64015 - 63788: 0xFE43,
	64017 - 63788: 0xFE44,
	64019 - 63788: 0xFE45,
	64020 - 63788: 0xFE46,
	64024 - 63788: 0xFE47,
	64031 - 63788: 0xFE48,
	64032 - 63788: 0xFE49,
	64033 - 63788: 0xFE4A,
	64035 - 63788: 0xFE4B,
	64036 - 63788: 0xFE4C,
	64039 - 63788: 0xFE4D,
	64040 - 63788: 0xFE4E,
	64041 - 63788: 0xFE4F,
}
