/*
 * Decompiled with CFR 0.152.
 */
package io.k8s.cassandra;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.utils.FBUtilities;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesSeedProvider.class);
    private List<InetAddress> defaultSeeds = this.createDefaultSeeds();
    private TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private HostnameVerifier trustAllHosts = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public KubernetesSeedProvider(Map<String, String> params) {
    }

    public List<InetAddress> getSeeds() {
        String host = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_PORT_443_TCP_ADDR", "kubernetes.default.svc.cluster.local");
        String port = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_PORT_443_TCP_PORT", "443");
        String serviceName = KubernetesSeedProvider.getEnvOrDefault("CASSANDRA_SERVICE", "cassandra");
        String podNamespace = KubernetesSeedProvider.getEnvOrDefault("POD_NAMESPACE", "default");
        String path = String.format("/api/v1/namespaces/%s/endpoints/", podNamespace);
        String seedSizeVar = KubernetesSeedProvider.getEnvOrDefault("CASSANDRA_SERVICE_NUM_SEEDS", "8");
        Integer seedSize = Integer.valueOf(seedSizeVar);
        String accountToken = KubernetesSeedProvider.getEnvOrDefault("K8S_ACCOUNT_TOKEN", "/var/run/secrets/kubernetes.io/serviceaccount/token");
        ArrayList<InetAddress> seeds = new ArrayList<InetAddress>();
        try {
            String token = KubernetesSeedProvider.getServiceAccountToken(accountToken);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, this.trustAll, new SecureRandom());
            String PROTO = "https://";
            URL url = new URL(PROTO + host + ":" + port + path + serviceName);
            logger.info("Getting endpoints from " + url);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setHostnameVerifier(this.trustAllHosts);
            conn.setSSLSocketFactory(ctx.getSocketFactory());
            conn.addRequestProperty("Authorization", "Bearer " + token);
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(conn.getInputStream(), Endpoints.class);
            if (endpoints != null) {
                if (endpoints.subsets != null && !endpoints.subsets.isEmpty()) {
                    for (Subset subset : endpoints.subsets) {
                        if (subset.addresses == null || subset.addresses.isEmpty()) continue;
                        for (Address address : subset.addresses) {
                            seeds.add(InetAddress.getByName(address.ip));
                            if (seeds.size() < seedSize) continue;
                            logger.info("Available num endpoints: " + seeds.size());
                            return Collections.unmodifiableList(seeds);
                        }
                    }
                }
            } else {
                logger.warn("Endpoints are not available using default seeds in cassandra.yaml");
                return Collections.unmodifiableList(this.defaultSeeds);
            }
            logger.info("Available num endpoints: " + seeds.size());
        }
        catch (Exception ex) {
            logger.warn("Request to kubernetes apiserver failed, using default seeds in cassandra.yaml", (Throwable)ex);
            return Collections.unmodifiableList(this.defaultSeeds);
        }
        if (seeds.size() == 0) {
            logger.warn("Seeds are not available using default seeds in cassandra.yaml");
            return Collections.unmodifiableList(this.defaultSeeds);
        }
        return Collections.unmodifiableList(seeds);
    }

    protected List<InetAddress> createDefaultSeeds() {
        Config conf;
        try {
            conf = KubernetesSeedProvider.loadConfig();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        String[] hosts = ((String)conf.seed_provider.parameters.get("seeds")).split(",", -1);
        ArrayList<InetAddress> seeds = new ArrayList<InetAddress>();
        for (String host : hosts) {
            try {
                seeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host {}", (Object)host);
            }
        }
        if (seeds.size() == 0) {
            try {
                seeds.add(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
                logger.warn("Seed provider couldn't lookup localhost");
            }
        }
        return Collections.unmodifiableList(seeds);
    }

    protected static Config loadConfig() throws ConfigurationException {
        String loaderClass = System.getProperty("cassandra.config.loader");
        YamlConfigurationLoader loader = loaderClass == null ? new YamlConfigurationLoader() : (ConfigurationLoader)FBUtilities.construct((String)loaderClass, (String)"configuration loading");
        return loader.loadConfig();
    }

    private static String getEnvOrDefault(String var, String def) {
        String val = System.getenv(var);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static String getServiceAccountToken(String file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])));
        }
        catch (IOException e) {
            logger.warn("unable to load service account token" + file);
            throw new RuntimeException("Unable to load services account token " + file);
        }
    }

    protected List<InetAddress> getDefaultSeeds() {
        return this.defaultSeeds;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Endpoints {
        public List<Subset> subsets;

        Endpoints() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Subset {
        public List<Address> addresses;

        Subset() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Address {
        public String ip;

        Address() {
        }
    }
}

