// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package datalabeling

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies where is the answer from.
type AnnotationSource int32

const (
	AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED AnnotationSource = 0
	// Answer is provided by a human contributor.
	AnnotationSource_OPERATOR AnnotationSource = 3
)

var AnnotationSource_name = map[int32]string{
	0: "ANNOTATION_SOURCE_UNSPECIFIED",
	3: "OPERATOR",
}

var AnnotationSource_value = map[string]int32{
	"ANNOTATION_SOURCE_UNSPECIFIED": 0,
	"OPERATOR":                      3,
}

func (x AnnotationSource) String() string {
	return proto.EnumName(AnnotationSource_name, int32(x))
}

func (AnnotationSource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{0}
}

type AnnotationSentiment int32

const (
	AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED AnnotationSentiment = 0
	// This annotation describes negatively about the data.
	AnnotationSentiment_NEGATIVE AnnotationSentiment = 1
	// This label describes positively about the data.
	AnnotationSentiment_POSITIVE AnnotationSentiment = 2
)

var AnnotationSentiment_name = map[int32]string{
	0: "ANNOTATION_SENTIMENT_UNSPECIFIED",
	1: "NEGATIVE",
	2: "POSITIVE",
}

var AnnotationSentiment_value = map[string]int32{
	"ANNOTATION_SENTIMENT_UNSPECIFIED": 0,
	"NEGATIVE":                         1,
	"POSITIVE":                         2,
}

func (x AnnotationSentiment) String() string {
	return proto.EnumName(AnnotationSentiment_name, int32(x))
}

func (AnnotationSentiment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{1}
}

type AnnotationType int32

const (
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED AnnotationType = 0
	// Classification annotations in an image.
	AnnotationType_IMAGE_CLASSIFICATION_ANNOTATION AnnotationType = 1
	// Bounding box annotations in an image.
	AnnotationType_IMAGE_BOUNDING_BOX_ANNOTATION AnnotationType = 2
	// Oriented bounding box. The box does not have to be parallel to horizontal
	// line.
	AnnotationType_IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION AnnotationType = 13
	// Bounding poly annotations in an image.
	AnnotationType_IMAGE_BOUNDING_POLY_ANNOTATION AnnotationType = 10
	// Polyline annotations in an image.
	AnnotationType_IMAGE_POLYLINE_ANNOTATION AnnotationType = 11
	// Segmentation annotations in an image.
	AnnotationType_IMAGE_SEGMENTATION_ANNOTATION AnnotationType = 12
	// Classification annotations in video shots.
	AnnotationType_VIDEO_SHOTS_CLASSIFICATION_ANNOTATION AnnotationType = 3
	// Video object tracking annotation.
	AnnotationType_VIDEO_OBJECT_TRACKING_ANNOTATION AnnotationType = 4
	// Video object detection annotation.
	AnnotationType_VIDEO_OBJECT_DETECTION_ANNOTATION AnnotationType = 5
	// Video event annotation.
	AnnotationType_VIDEO_EVENT_ANNOTATION AnnotationType = 6
	// Classification for text.
	AnnotationType_TEXT_CLASSIFICATION_ANNOTATION AnnotationType = 8
	// Entity extraction for text.
	AnnotationType_TEXT_ENTITY_EXTRACTION_ANNOTATION AnnotationType = 9
	// General classification.
	AnnotationType_GENERAL_CLASSIFICATION_ANNOTATION AnnotationType = 14
)

var AnnotationType_name = map[int32]string{
	0:  "ANNOTATION_TYPE_UNSPECIFIED",
	1:  "IMAGE_CLASSIFICATION_ANNOTATION",
	2:  "IMAGE_BOUNDING_BOX_ANNOTATION",
	13: "IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION",
	10: "IMAGE_BOUNDING_POLY_ANNOTATION",
	11: "IMAGE_POLYLINE_ANNOTATION",
	12: "IMAGE_SEGMENTATION_ANNOTATION",
	3:  "VIDEO_SHOTS_CLASSIFICATION_ANNOTATION",
	4:  "VIDEO_OBJECT_TRACKING_ANNOTATION",
	5:  "VIDEO_OBJECT_DETECTION_ANNOTATION",
	6:  "VIDEO_EVENT_ANNOTATION",
	8:  "TEXT_CLASSIFICATION_ANNOTATION",
	9:  "TEXT_ENTITY_EXTRACTION_ANNOTATION",
	14: "GENERAL_CLASSIFICATION_ANNOTATION",
}

var AnnotationType_value = map[string]int32{
	"ANNOTATION_TYPE_UNSPECIFIED":            0,
	"IMAGE_CLASSIFICATION_ANNOTATION":        1,
	"IMAGE_BOUNDING_BOX_ANNOTATION":          2,
	"IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION": 13,
	"IMAGE_BOUNDING_POLY_ANNOTATION":         10,
	"IMAGE_POLYLINE_ANNOTATION":              11,
	"IMAGE_SEGMENTATION_ANNOTATION":          12,
	"VIDEO_SHOTS_CLASSIFICATION_ANNOTATION":  3,
	"VIDEO_OBJECT_TRACKING_ANNOTATION":       4,
	"VIDEO_OBJECT_DETECTION_ANNOTATION":      5,
	"VIDEO_EVENT_ANNOTATION":                 6,
	"TEXT_CLASSIFICATION_ANNOTATION":         8,
	"TEXT_ENTITY_EXTRACTION_ANNOTATION":      9,
	"GENERAL_CLASSIFICATION_ANNOTATION":      14,
}

func (x AnnotationType) String() string {
	return proto.EnumName(AnnotationType_name, int32(x))
}

func (AnnotationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{2}
}

// Annotation for Example. Each example may have one or more annotations. For
// example in image classification problem, each image might have one or more
// labels. We call labels binded with this image an Annotation.
type Annotation struct {
	// Output only. Unique name of this annotation, format is:
	//
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The source of the annotation.
	AnnotationSource AnnotationSource `protobuf:"varint,2,opt,name=annotation_source,json=annotationSource,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSource" json:"annotation_source,omitempty"`
	// Output only. This is the actual annotation value, e.g classification,
	// bounding box values are stored here.
	AnnotationValue *AnnotationValue `protobuf:"bytes,3,opt,name=annotation_value,json=annotationValue,proto3" json:"annotation_value,omitempty"`
	// Output only. Annotation metadata, including information like votes
	// for labels.
	AnnotationMetadata *AnnotationMetadata `protobuf:"bytes,4,opt,name=annotation_metadata,json=annotationMetadata,proto3" json:"annotation_metadata,omitempty"`
	// Output only. Sentiment for this annotation.
	AnnotationSentiment  AnnotationSentiment `protobuf:"varint,6,opt,name=annotation_sentiment,json=annotationSentiment,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSentiment" json:"annotation_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Annotation) Reset()         { *m = Annotation{} }
func (m *Annotation) String() string { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()    {}
func (*Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{0}
}

func (m *Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Annotation.Unmarshal(m, b)
}
func (m *Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Annotation.Marshal(b, m, deterministic)
}
func (m *Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Annotation.Merge(m, src)
}
func (m *Annotation) XXX_Size() int {
	return xxx_messageInfo_Annotation.Size(m)
}
func (m *Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Annotation proto.InternalMessageInfo

func (m *Annotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Annotation) GetAnnotationSource() AnnotationSource {
	if m != nil {
		return m.AnnotationSource
	}
	return AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
}

func (m *Annotation) GetAnnotationValue() *AnnotationValue {
	if m != nil {
		return m.AnnotationValue
	}
	return nil
}

func (m *Annotation) GetAnnotationMetadata() *AnnotationMetadata {
	if m != nil {
		return m.AnnotationMetadata
	}
	return nil
}

func (m *Annotation) GetAnnotationSentiment() AnnotationSentiment {
	if m != nil {
		return m.AnnotationSentiment
	}
	return AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED
}

// Annotation value for an example.
type AnnotationValue struct {
	// Types that are valid to be assigned to ValueType:
	//	*AnnotationValue_ImageClassificationAnnotation
	//	*AnnotationValue_ImageBoundingPolyAnnotation
	//	*AnnotationValue_ImagePolylineAnnotation
	//	*AnnotationValue_ImageSegmentationAnnotation
	//	*AnnotationValue_TextClassificationAnnotation
	//	*AnnotationValue_TextEntityExtractionAnnotation
	//	*AnnotationValue_VideoClassificationAnnotation
	//	*AnnotationValue_VideoObjectTrackingAnnotation
	//	*AnnotationValue_VideoEventAnnotation
	ValueType            isAnnotationValue_ValueType `protobuf_oneof:"value_type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *AnnotationValue) Reset()         { *m = AnnotationValue{} }
func (m *AnnotationValue) String() string { return proto.CompactTextString(m) }
func (*AnnotationValue) ProtoMessage()    {}
func (*AnnotationValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{1}
}

func (m *AnnotationValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotationValue.Unmarshal(m, b)
}
func (m *AnnotationValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotationValue.Marshal(b, m, deterministic)
}
func (m *AnnotationValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotationValue.Merge(m, src)
}
func (m *AnnotationValue) XXX_Size() int {
	return xxx_messageInfo_AnnotationValue.Size(m)
}
func (m *AnnotationValue) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotationValue.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotationValue proto.InternalMessageInfo

type isAnnotationValue_ValueType interface {
	isAnnotationValue_ValueType()
}

type AnnotationValue_ImageClassificationAnnotation struct {
	ImageClassificationAnnotation *ImageClassificationAnnotation `protobuf:"bytes,1,opt,name=image_classification_annotation,json=imageClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_ImageBoundingPolyAnnotation struct {
	ImageBoundingPolyAnnotation *ImageBoundingPolyAnnotation `protobuf:"bytes,2,opt,name=image_bounding_poly_annotation,json=imageBoundingPolyAnnotation,proto3,oneof"`
}

type AnnotationValue_ImagePolylineAnnotation struct {
	ImagePolylineAnnotation *ImagePolylineAnnotation `protobuf:"bytes,8,opt,name=image_polyline_annotation,json=imagePolylineAnnotation,proto3,oneof"`
}

type AnnotationValue_ImageSegmentationAnnotation struct {
	ImageSegmentationAnnotation *ImageSegmentationAnnotation `protobuf:"bytes,9,opt,name=image_segmentation_annotation,json=imageSegmentationAnnotation,proto3,oneof"`
}

type AnnotationValue_TextClassificationAnnotation struct {
	TextClassificationAnnotation *TextClassificationAnnotation `protobuf:"bytes,3,opt,name=text_classification_annotation,json=textClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_TextEntityExtractionAnnotation struct {
	TextEntityExtractionAnnotation *TextEntityExtractionAnnotation `protobuf:"bytes,10,opt,name=text_entity_extraction_annotation,json=textEntityExtractionAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoClassificationAnnotation struct {
	VideoClassificationAnnotation *VideoClassificationAnnotation `protobuf:"bytes,4,opt,name=video_classification_annotation,json=videoClassificationAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoObjectTrackingAnnotation struct {
	VideoObjectTrackingAnnotation *VideoObjectTrackingAnnotation `protobuf:"bytes,5,opt,name=video_object_tracking_annotation,json=videoObjectTrackingAnnotation,proto3,oneof"`
}

type AnnotationValue_VideoEventAnnotation struct {
	VideoEventAnnotation *VideoEventAnnotation `protobuf:"bytes,6,opt,name=video_event_annotation,json=videoEventAnnotation,proto3,oneof"`
}

func (*AnnotationValue_ImageClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImageBoundingPolyAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImagePolylineAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_ImageSegmentationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_TextClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_TextEntityExtractionAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoClassificationAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoObjectTrackingAnnotation) isAnnotationValue_ValueType() {}

func (*AnnotationValue_VideoEventAnnotation) isAnnotationValue_ValueType() {}

func (m *AnnotationValue) GetValueType() isAnnotationValue_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (m *AnnotationValue) GetImageClassificationAnnotation() *ImageClassificationAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_ImageClassificationAnnotation); ok {
		return x.ImageClassificationAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetImageBoundingPolyAnnotation() *ImageBoundingPolyAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_ImageBoundingPolyAnnotation); ok {
		return x.ImageBoundingPolyAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetImagePolylineAnnotation() *ImagePolylineAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_ImagePolylineAnnotation); ok {
		return x.ImagePolylineAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetImageSegmentationAnnotation() *ImageSegmentationAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_ImageSegmentationAnnotation); ok {
		return x.ImageSegmentationAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetTextClassificationAnnotation() *TextClassificationAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_TextClassificationAnnotation); ok {
		return x.TextClassificationAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetTextEntityExtractionAnnotation() *TextEntityExtractionAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_TextEntityExtractionAnnotation); ok {
		return x.TextEntityExtractionAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetVideoClassificationAnnotation() *VideoClassificationAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_VideoClassificationAnnotation); ok {
		return x.VideoClassificationAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetVideoObjectTrackingAnnotation() *VideoObjectTrackingAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_VideoObjectTrackingAnnotation); ok {
		return x.VideoObjectTrackingAnnotation
	}
	return nil
}

func (m *AnnotationValue) GetVideoEventAnnotation() *VideoEventAnnotation {
	if x, ok := m.GetValueType().(*AnnotationValue_VideoEventAnnotation); ok {
		return x.VideoEventAnnotation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AnnotationValue) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AnnotationValue_ImageClassificationAnnotation)(nil),
		(*AnnotationValue_ImageBoundingPolyAnnotation)(nil),
		(*AnnotationValue_ImagePolylineAnnotation)(nil),
		(*AnnotationValue_ImageSegmentationAnnotation)(nil),
		(*AnnotationValue_TextClassificationAnnotation)(nil),
		(*AnnotationValue_TextEntityExtractionAnnotation)(nil),
		(*AnnotationValue_VideoClassificationAnnotation)(nil),
		(*AnnotationValue_VideoObjectTrackingAnnotation)(nil),
		(*AnnotationValue_VideoEventAnnotation)(nil),
	}
}

// Image classification annotation definition.
type ImageClassificationAnnotation struct {
	// Label of image.
	AnnotationSpec       *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ImageClassificationAnnotation) Reset()         { *m = ImageClassificationAnnotation{} }
func (m *ImageClassificationAnnotation) String() string { return proto.CompactTextString(m) }
func (*ImageClassificationAnnotation) ProtoMessage()    {}
func (*ImageClassificationAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{2}
}

func (m *ImageClassificationAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageClassificationAnnotation.Unmarshal(m, b)
}
func (m *ImageClassificationAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageClassificationAnnotation.Marshal(b, m, deterministic)
}
func (m *ImageClassificationAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageClassificationAnnotation.Merge(m, src)
}
func (m *ImageClassificationAnnotation) XXX_Size() int {
	return xxx_messageInfo_ImageClassificationAnnotation.Size(m)
}
func (m *ImageClassificationAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageClassificationAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ImageClassificationAnnotation proto.InternalMessageInfo

func (m *ImageClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

// A vertex represents a 2D point in the image.
// NOTE: the vertex coordinates are in the same scale as the original image.
type Vertex struct {
	// X coordinate.
	X int32 `protobuf:"varint,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    int32    `protobuf:"varint,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Vertex) Reset()         { *m = Vertex{} }
func (m *Vertex) String() string { return proto.CompactTextString(m) }
func (*Vertex) ProtoMessage()    {}
func (*Vertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{3}
}

func (m *Vertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vertex.Unmarshal(m, b)
}
func (m *Vertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vertex.Marshal(b, m, deterministic)
}
func (m *Vertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vertex.Merge(m, src)
}
func (m *Vertex) XXX_Size() int {
	return xxx_messageInfo_Vertex.Size(m)
}
func (m *Vertex) XXX_DiscardUnknown() {
	xxx_messageInfo_Vertex.DiscardUnknown(m)
}

var xxx_messageInfo_Vertex proto.InternalMessageInfo

func (m *Vertex) GetX() int32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *Vertex) GetY() int32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{4}
}

func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (m *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(m, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// A bounding polygon in the image.
type BoundingPoly struct {
	// The bounding polygon vertices.
	Vertices             []*Vertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BoundingPoly) Reset()         { *m = BoundingPoly{} }
func (m *BoundingPoly) String() string { return proto.CompactTextString(m) }
func (*BoundingPoly) ProtoMessage()    {}
func (*BoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{5}
}

func (m *BoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundingPoly.Unmarshal(m, b)
}
func (m *BoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundingPoly.Marshal(b, m, deterministic)
}
func (m *BoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundingPoly.Merge(m, src)
}
func (m *BoundingPoly) XXX_Size() int {
	return xxx_messageInfo_BoundingPoly.Size(m)
}
func (m *BoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_BoundingPoly proto.InternalMessageInfo

func (m *BoundingPoly) GetVertices() []*Vertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Normalized bounding polygon.
type NormalizedBoundingPoly struct {
	// The bounding polygon normalized vertices.
	NormalizedVertices   []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{6}
}

func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(m, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetNormalizedVertices() []*NormalizedVertex {
	if m != nil {
		return m.NormalizedVertices
	}
	return nil
}

// Image bounding poly annotation. It represents a polygon including
// bounding box in the image.
type ImageBoundingPolyAnnotation struct {
	// The region of the polygon. If it is a bounding box, it is guaranteed to be
	// four points.
	//
	// Types that are valid to be assigned to BoundedArea:
	//	*ImageBoundingPolyAnnotation_BoundingPoly
	//	*ImageBoundingPolyAnnotation_NormalizedBoundingPoly
	BoundedArea isImageBoundingPolyAnnotation_BoundedArea `protobuf_oneof:"bounded_area"`
	// Label of object in this bounding polygon.
	AnnotationSpec       *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ImageBoundingPolyAnnotation) Reset()         { *m = ImageBoundingPolyAnnotation{} }
func (m *ImageBoundingPolyAnnotation) String() string { return proto.CompactTextString(m) }
func (*ImageBoundingPolyAnnotation) ProtoMessage()    {}
func (*ImageBoundingPolyAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{7}
}

func (m *ImageBoundingPolyAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageBoundingPolyAnnotation.Unmarshal(m, b)
}
func (m *ImageBoundingPolyAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageBoundingPolyAnnotation.Marshal(b, m, deterministic)
}
func (m *ImageBoundingPolyAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageBoundingPolyAnnotation.Merge(m, src)
}
func (m *ImageBoundingPolyAnnotation) XXX_Size() int {
	return xxx_messageInfo_ImageBoundingPolyAnnotation.Size(m)
}
func (m *ImageBoundingPolyAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageBoundingPolyAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ImageBoundingPolyAnnotation proto.InternalMessageInfo

type isImageBoundingPolyAnnotation_BoundedArea interface {
	isImageBoundingPolyAnnotation_BoundedArea()
}

type ImageBoundingPolyAnnotation_BoundingPoly struct {
	BoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=bounding_poly,json=boundingPoly,proto3,oneof"`
}

type ImageBoundingPolyAnnotation_NormalizedBoundingPoly struct {
	NormalizedBoundingPoly *NormalizedBoundingPoly `protobuf:"bytes,3,opt,name=normalized_bounding_poly,json=normalizedBoundingPoly,proto3,oneof"`
}

func (*ImageBoundingPolyAnnotation_BoundingPoly) isImageBoundingPolyAnnotation_BoundedArea() {}

func (*ImageBoundingPolyAnnotation_NormalizedBoundingPoly) isImageBoundingPolyAnnotation_BoundedArea() {
}

func (m *ImageBoundingPolyAnnotation) GetBoundedArea() isImageBoundingPolyAnnotation_BoundedArea {
	if m != nil {
		return m.BoundedArea
	}
	return nil
}

func (m *ImageBoundingPolyAnnotation) GetBoundingPoly() *BoundingPoly {
	if x, ok := m.GetBoundedArea().(*ImageBoundingPolyAnnotation_BoundingPoly); ok {
		return x.BoundingPoly
	}
	return nil
}

func (m *ImageBoundingPolyAnnotation) GetNormalizedBoundingPoly() *NormalizedBoundingPoly {
	if x, ok := m.GetBoundedArea().(*ImageBoundingPolyAnnotation_NormalizedBoundingPoly); ok {
		return x.NormalizedBoundingPoly
	}
	return nil
}

func (m *ImageBoundingPolyAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImageBoundingPolyAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImageBoundingPolyAnnotation_BoundingPoly)(nil),
		(*ImageBoundingPolyAnnotation_NormalizedBoundingPoly)(nil),
	}
}

// A line with multiple line segments.
type Polyline struct {
	// The polyline vertices.
	Vertices             []*Vertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Polyline) Reset()         { *m = Polyline{} }
func (m *Polyline) String() string { return proto.CompactTextString(m) }
func (*Polyline) ProtoMessage()    {}
func (*Polyline) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{8}
}

func (m *Polyline) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Polyline.Unmarshal(m, b)
}
func (m *Polyline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Polyline.Marshal(b, m, deterministic)
}
func (m *Polyline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Polyline.Merge(m, src)
}
func (m *Polyline) XXX_Size() int {
	return xxx_messageInfo_Polyline.Size(m)
}
func (m *Polyline) XXX_DiscardUnknown() {
	xxx_messageInfo_Polyline.DiscardUnknown(m)
}

var xxx_messageInfo_Polyline proto.InternalMessageInfo

func (m *Polyline) GetVertices() []*Vertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Normalized polyline.
type NormalizedPolyline struct {
	// The normalized polyline vertices.
	NormalizedVertices   []*NormalizedVertex `protobuf:"bytes,1,rep,name=normalized_vertices,json=normalizedVertices,proto3" json:"normalized_vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedPolyline) Reset()         { *m = NormalizedPolyline{} }
func (m *NormalizedPolyline) String() string { return proto.CompactTextString(m) }
func (*NormalizedPolyline) ProtoMessage()    {}
func (*NormalizedPolyline) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{9}
}

func (m *NormalizedPolyline) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedPolyline.Unmarshal(m, b)
}
func (m *NormalizedPolyline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedPolyline.Marshal(b, m, deterministic)
}
func (m *NormalizedPolyline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedPolyline.Merge(m, src)
}
func (m *NormalizedPolyline) XXX_Size() int {
	return xxx_messageInfo_NormalizedPolyline.Size(m)
}
func (m *NormalizedPolyline) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedPolyline.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedPolyline proto.InternalMessageInfo

func (m *NormalizedPolyline) GetNormalizedVertices() []*NormalizedVertex {
	if m != nil {
		return m.NormalizedVertices
	}
	return nil
}

// A polyline for the image annotation.
type ImagePolylineAnnotation struct {
	// Types that are valid to be assigned to Poly:
	//	*ImagePolylineAnnotation_Polyline
	//	*ImagePolylineAnnotation_NormalizedPolyline
	Poly isImagePolylineAnnotation_Poly `protobuf_oneof:"poly"`
	// Label of this polyline.
	AnnotationSpec       *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ImagePolylineAnnotation) Reset()         { *m = ImagePolylineAnnotation{} }
func (m *ImagePolylineAnnotation) String() string { return proto.CompactTextString(m) }
func (*ImagePolylineAnnotation) ProtoMessage()    {}
func (*ImagePolylineAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{10}
}

func (m *ImagePolylineAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImagePolylineAnnotation.Unmarshal(m, b)
}
func (m *ImagePolylineAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImagePolylineAnnotation.Marshal(b, m, deterministic)
}
func (m *ImagePolylineAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImagePolylineAnnotation.Merge(m, src)
}
func (m *ImagePolylineAnnotation) XXX_Size() int {
	return xxx_messageInfo_ImagePolylineAnnotation.Size(m)
}
func (m *ImagePolylineAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ImagePolylineAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ImagePolylineAnnotation proto.InternalMessageInfo

type isImagePolylineAnnotation_Poly interface {
	isImagePolylineAnnotation_Poly()
}

type ImagePolylineAnnotation_Polyline struct {
	Polyline *Polyline `protobuf:"bytes,2,opt,name=polyline,proto3,oneof"`
}

type ImagePolylineAnnotation_NormalizedPolyline struct {
	NormalizedPolyline *NormalizedPolyline `protobuf:"bytes,3,opt,name=normalized_polyline,json=normalizedPolyline,proto3,oneof"`
}

func (*ImagePolylineAnnotation_Polyline) isImagePolylineAnnotation_Poly() {}

func (*ImagePolylineAnnotation_NormalizedPolyline) isImagePolylineAnnotation_Poly() {}

func (m *ImagePolylineAnnotation) GetPoly() isImagePolylineAnnotation_Poly {
	if m != nil {
		return m.Poly
	}
	return nil
}

func (m *ImagePolylineAnnotation) GetPolyline() *Polyline {
	if x, ok := m.GetPoly().(*ImagePolylineAnnotation_Polyline); ok {
		return x.Polyline
	}
	return nil
}

func (m *ImagePolylineAnnotation) GetNormalizedPolyline() *NormalizedPolyline {
	if x, ok := m.GetPoly().(*ImagePolylineAnnotation_NormalizedPolyline); ok {
		return x.NormalizedPolyline
	}
	return nil
}

func (m *ImagePolylineAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImagePolylineAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImagePolylineAnnotation_Polyline)(nil),
		(*ImagePolylineAnnotation_NormalizedPolyline)(nil),
	}
}

// Image segmentation annotation.
type ImageSegmentationAnnotation struct {
	// The mapping between rgb color and annotation spec. The key is the rgb
	// color represented in format of rgb(0, 0, 0). The value is the
	// AnnotationSpec.
	AnnotationColors map[string]*AnnotationSpec `protobuf:"bytes,1,rep,name=annotation_colors,json=annotationColors,proto3" json:"annotation_colors,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Image format.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// A byte string of a full image's color map.
	ImageBytes           []byte   `protobuf:"bytes,3,opt,name=image_bytes,json=imageBytes,proto3" json:"image_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageSegmentationAnnotation) Reset()         { *m = ImageSegmentationAnnotation{} }
func (m *ImageSegmentationAnnotation) String() string { return proto.CompactTextString(m) }
func (*ImageSegmentationAnnotation) ProtoMessage()    {}
func (*ImageSegmentationAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{11}
}

func (m *ImageSegmentationAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageSegmentationAnnotation.Unmarshal(m, b)
}
func (m *ImageSegmentationAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageSegmentationAnnotation.Marshal(b, m, deterministic)
}
func (m *ImageSegmentationAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSegmentationAnnotation.Merge(m, src)
}
func (m *ImageSegmentationAnnotation) XXX_Size() int {
	return xxx_messageInfo_ImageSegmentationAnnotation.Size(m)
}
func (m *ImageSegmentationAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSegmentationAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSegmentationAnnotation proto.InternalMessageInfo

func (m *ImageSegmentationAnnotation) GetAnnotationColors() map[string]*AnnotationSpec {
	if m != nil {
		return m.AnnotationColors
	}
	return nil
}

func (m *ImageSegmentationAnnotation) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *ImageSegmentationAnnotation) GetImageBytes() []byte {
	if m != nil {
		return m.ImageBytes
	}
	return nil
}

// Text classification annotation.
type TextClassificationAnnotation struct {
	// Label of the text.
	AnnotationSpec       *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TextClassificationAnnotation) Reset()         { *m = TextClassificationAnnotation{} }
func (m *TextClassificationAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextClassificationAnnotation) ProtoMessage()    {}
func (*TextClassificationAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{12}
}

func (m *TextClassificationAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextClassificationAnnotation.Unmarshal(m, b)
}
func (m *TextClassificationAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextClassificationAnnotation.Marshal(b, m, deterministic)
}
func (m *TextClassificationAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextClassificationAnnotation.Merge(m, src)
}
func (m *TextClassificationAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextClassificationAnnotation.Size(m)
}
func (m *TextClassificationAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextClassificationAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextClassificationAnnotation proto.InternalMessageInfo

func (m *TextClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

// Text entity extraction annotation.
type TextEntityExtractionAnnotation struct {
	// Label of the text entities.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// Position of the entity.
	SequentialSegment    *SequentialSegment `protobuf:"bytes,2,opt,name=sequential_segment,json=sequentialSegment,proto3" json:"sequential_segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextEntityExtractionAnnotation) Reset()         { *m = TextEntityExtractionAnnotation{} }
func (m *TextEntityExtractionAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextEntityExtractionAnnotation) ProtoMessage()    {}
func (*TextEntityExtractionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{13}
}

func (m *TextEntityExtractionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextEntityExtractionAnnotation.Unmarshal(m, b)
}
func (m *TextEntityExtractionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextEntityExtractionAnnotation.Marshal(b, m, deterministic)
}
func (m *TextEntityExtractionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextEntityExtractionAnnotation.Merge(m, src)
}
func (m *TextEntityExtractionAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextEntityExtractionAnnotation.Size(m)
}
func (m *TextEntityExtractionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextEntityExtractionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextEntityExtractionAnnotation proto.InternalMessageInfo

func (m *TextEntityExtractionAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

func (m *TextEntityExtractionAnnotation) GetSequentialSegment() *SequentialSegment {
	if m != nil {
		return m.SequentialSegment
	}
	return nil
}

// Start and end position in a sequence (e.g. text segment).
type SequentialSegment struct {
	// Start position (inclusive).
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// End position (exclusive).
	End                  int32    `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SequentialSegment) Reset()         { *m = SequentialSegment{} }
func (m *SequentialSegment) String() string { return proto.CompactTextString(m) }
func (*SequentialSegment) ProtoMessage()    {}
func (*SequentialSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{14}
}

func (m *SequentialSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SequentialSegment.Unmarshal(m, b)
}
func (m *SequentialSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SequentialSegment.Marshal(b, m, deterministic)
}
func (m *SequentialSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SequentialSegment.Merge(m, src)
}
func (m *SequentialSegment) XXX_Size() int {
	return xxx_messageInfo_SequentialSegment.Size(m)
}
func (m *SequentialSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_SequentialSegment.DiscardUnknown(m)
}

var xxx_messageInfo_SequentialSegment proto.InternalMessageInfo

func (m *SequentialSegment) GetStart() int32 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SequentialSegment) GetEnd() int32 {
	if m != nil {
		return m.End
	}
	return 0
}

// A time period inside of an example that has a time dimension (e.g. video).
type TimeSegment struct {
	// Start of the time segment (inclusive), represented as the duration since
	// the example start.
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End of the time segment (exclusive), represented as the duration since the
	// example start.
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TimeSegment) Reset()         { *m = TimeSegment{} }
func (m *TimeSegment) String() string { return proto.CompactTextString(m) }
func (*TimeSegment) ProtoMessage()    {}
func (*TimeSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{15}
}

func (m *TimeSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeSegment.Unmarshal(m, b)
}
func (m *TimeSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeSegment.Marshal(b, m, deterministic)
}
func (m *TimeSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSegment.Merge(m, src)
}
func (m *TimeSegment) XXX_Size() int {
	return xxx_messageInfo_TimeSegment.Size(m)
}
func (m *TimeSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSegment proto.InternalMessageInfo

func (m *TimeSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *TimeSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video classification annotation.
type VideoClassificationAnnotation struct {
	// The time segment of the video to which the annotation applies.
	TimeSegment *TimeSegment `protobuf:"bytes,1,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// Label of the segment specified by time_segment.
	AnnotationSpec       *AnnotationSpec `protobuf:"bytes,2,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *VideoClassificationAnnotation) Reset()         { *m = VideoClassificationAnnotation{} }
func (m *VideoClassificationAnnotation) String() string { return proto.CompactTextString(m) }
func (*VideoClassificationAnnotation) ProtoMessage()    {}
func (*VideoClassificationAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{16}
}

func (m *VideoClassificationAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoClassificationAnnotation.Unmarshal(m, b)
}
func (m *VideoClassificationAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoClassificationAnnotation.Marshal(b, m, deterministic)
}
func (m *VideoClassificationAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoClassificationAnnotation.Merge(m, src)
}
func (m *VideoClassificationAnnotation) XXX_Size() int {
	return xxx_messageInfo_VideoClassificationAnnotation.Size(m)
}
func (m *VideoClassificationAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoClassificationAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_VideoClassificationAnnotation proto.InternalMessageInfo

func (m *VideoClassificationAnnotation) GetTimeSegment() *TimeSegment {
	if m != nil {
		return m.TimeSegment
	}
	return nil
}

func (m *VideoClassificationAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

// Video frame level annotation for object detection and tracking.
type ObjectTrackingFrame struct {
	// The bounding box location of this object track for the frame.
	//
	// Types that are valid to be assigned to BoundedArea:
	//	*ObjectTrackingFrame_BoundingPoly
	//	*ObjectTrackingFrame_NormalizedBoundingPoly
	BoundedArea isObjectTrackingFrame_BoundedArea `protobuf_oneof:"bounded_area"`
	// The time offset of this frame relative to the beginning of the video.
	TimeOffset           *duration.Duration `protobuf:"bytes,3,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{17}
}

func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(m, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

type isObjectTrackingFrame_BoundedArea interface {
	isObjectTrackingFrame_BoundedArea()
}

type ObjectTrackingFrame_BoundingPoly struct {
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3,oneof"`
}

type ObjectTrackingFrame_NormalizedBoundingPoly struct {
	NormalizedBoundingPoly *NormalizedBoundingPoly `protobuf:"bytes,2,opt,name=normalized_bounding_poly,json=normalizedBoundingPoly,proto3,oneof"`
}

func (*ObjectTrackingFrame_BoundingPoly) isObjectTrackingFrame_BoundedArea() {}

func (*ObjectTrackingFrame_NormalizedBoundingPoly) isObjectTrackingFrame_BoundedArea() {}

func (m *ObjectTrackingFrame) GetBoundedArea() isObjectTrackingFrame_BoundedArea {
	if m != nil {
		return m.BoundedArea
	}
	return nil
}

func (m *ObjectTrackingFrame) GetBoundingPoly() *BoundingPoly {
	if x, ok := m.GetBoundedArea().(*ObjectTrackingFrame_BoundingPoly); ok {
		return x.BoundingPoly
	}
	return nil
}

func (m *ObjectTrackingFrame) GetNormalizedBoundingPoly() *NormalizedBoundingPoly {
	if x, ok := m.GetBoundedArea().(*ObjectTrackingFrame_NormalizedBoundingPoly); ok {
		return x.NormalizedBoundingPoly
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ObjectTrackingFrame) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ObjectTrackingFrame_BoundingPoly)(nil),
		(*ObjectTrackingFrame_NormalizedBoundingPoly)(nil),
	}
}

// Video object tracking annotation.
type VideoObjectTrackingAnnotation struct {
	// Label of the object tracked in this annotation.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// The time segment of the video to which object tracking applies.
	TimeSegment *TimeSegment `protobuf:"bytes,2,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	// The list of frames where this object track appears.
	ObjectTrackingFrames []*ObjectTrackingFrame `protobuf:"bytes,3,rep,name=object_tracking_frames,json=objectTrackingFrames,proto3" json:"object_tracking_frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *VideoObjectTrackingAnnotation) Reset()         { *m = VideoObjectTrackingAnnotation{} }
func (m *VideoObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*VideoObjectTrackingAnnotation) ProtoMessage()    {}
func (*VideoObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{18}
}

func (m *VideoObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *VideoObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (m *VideoObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoObjectTrackingAnnotation.Merge(m, src)
}
func (m *VideoObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_VideoObjectTrackingAnnotation.Size(m)
}
func (m *VideoObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_VideoObjectTrackingAnnotation proto.InternalMessageInfo

func (m *VideoObjectTrackingAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

func (m *VideoObjectTrackingAnnotation) GetTimeSegment() *TimeSegment {
	if m != nil {
		return m.TimeSegment
	}
	return nil
}

func (m *VideoObjectTrackingAnnotation) GetObjectTrackingFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.ObjectTrackingFrames
	}
	return nil
}

// Video event annotation.
type VideoEventAnnotation struct {
	// Label of the event in this annotation.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// The time segment of the video to which the annotation applies.
	TimeSegment          *TimeSegment `protobuf:"bytes,2,opt,name=time_segment,json=timeSegment,proto3" json:"time_segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VideoEventAnnotation) Reset()         { *m = VideoEventAnnotation{} }
func (m *VideoEventAnnotation) String() string { return proto.CompactTextString(m) }
func (*VideoEventAnnotation) ProtoMessage()    {}
func (*VideoEventAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{19}
}

func (m *VideoEventAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoEventAnnotation.Unmarshal(m, b)
}
func (m *VideoEventAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoEventAnnotation.Marshal(b, m, deterministic)
}
func (m *VideoEventAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoEventAnnotation.Merge(m, src)
}
func (m *VideoEventAnnotation) XXX_Size() int {
	return xxx_messageInfo_VideoEventAnnotation.Size(m)
}
func (m *VideoEventAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoEventAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_VideoEventAnnotation proto.InternalMessageInfo

func (m *VideoEventAnnotation) GetAnnotationSpec() *AnnotationSpec {
	if m != nil {
		return m.AnnotationSpec
	}
	return nil
}

func (m *VideoEventAnnotation) GetTimeSegment() *TimeSegment {
	if m != nil {
		return m.TimeSegment
	}
	return nil
}

// Additional information associated with the annotation.
type AnnotationMetadata struct {
	// Metadata related to human labeling.
	OperatorMetadata     *OperatorMetadata `protobuf:"bytes,2,opt,name=operator_metadata,json=operatorMetadata,proto3" json:"operator_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AnnotationMetadata) Reset()         { *m = AnnotationMetadata{} }
func (m *AnnotationMetadata) String() string { return proto.CompactTextString(m) }
func (*AnnotationMetadata) ProtoMessage()    {}
func (*AnnotationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{20}
}

func (m *AnnotationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotationMetadata.Unmarshal(m, b)
}
func (m *AnnotationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotationMetadata.Marshal(b, m, deterministic)
}
func (m *AnnotationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotationMetadata.Merge(m, src)
}
func (m *AnnotationMetadata) XXX_Size() int {
	return xxx_messageInfo_AnnotationMetadata.Size(m)
}
func (m *AnnotationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotationMetadata proto.InternalMessageInfo

func (m *AnnotationMetadata) GetOperatorMetadata() *OperatorMetadata {
	if m != nil {
		return m.OperatorMetadata
	}
	return nil
}

// General information useful for labels coming from contributors.
type OperatorMetadata struct {
	// Confidence score corresponding to a label. For examle, if 3 contributors
	// have answered the question and 2 of them agree on the final label, the
	// confidence score will be 0.67 (2/3).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// The total number of contributors that answer this question.
	TotalVotes int32 `protobuf:"varint,2,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// The total number of contributors that choose this label.
	LabelVotes int32 `protobuf:"varint,3,opt,name=label_votes,json=labelVotes,proto3" json:"label_votes,omitempty"`
	// Comments from contributors.
	Comments             []string `protobuf:"bytes,4,rep,name=comments,proto3" json:"comments,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperatorMetadata) Reset()         { *m = OperatorMetadata{} }
func (m *OperatorMetadata) String() string { return proto.CompactTextString(m) }
func (*OperatorMetadata) ProtoMessage()    {}
func (*OperatorMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4bb97872d232a7f7, []int{21}
}

func (m *OperatorMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperatorMetadata.Unmarshal(m, b)
}
func (m *OperatorMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperatorMetadata.Marshal(b, m, deterministic)
}
func (m *OperatorMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperatorMetadata.Merge(m, src)
}
func (m *OperatorMetadata) XXX_Size() int {
	return xxx_messageInfo_OperatorMetadata.Size(m)
}
func (m *OperatorMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperatorMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperatorMetadata proto.InternalMessageInfo

func (m *OperatorMetadata) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *OperatorMetadata) GetTotalVotes() int32 {
	if m != nil {
		return m.TotalVotes
	}
	return 0
}

func (m *OperatorMetadata) GetLabelVotes() int32 {
	if m != nil {
		return m.LabelVotes
	}
	return 0
}

func (m *OperatorMetadata) GetComments() []string {
	if m != nil {
		return m.Comments
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.AnnotationSource", AnnotationSource_name, AnnotationSource_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.AnnotationSentiment", AnnotationSentiment_name, AnnotationSentiment_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.AnnotationType", AnnotationType_name, AnnotationType_value)
	proto.RegisterType((*Annotation)(nil), "google.cloud.datalabeling.v1beta1.Annotation")
	proto.RegisterType((*AnnotationValue)(nil), "google.cloud.datalabeling.v1beta1.AnnotationValue")
	proto.RegisterType((*ImageClassificationAnnotation)(nil), "google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation")
	proto.RegisterType((*Vertex)(nil), "google.cloud.datalabeling.v1beta1.Vertex")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.datalabeling.v1beta1.NormalizedVertex")
	proto.RegisterType((*BoundingPoly)(nil), "google.cloud.datalabeling.v1beta1.BoundingPoly")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly")
	proto.RegisterType((*ImageBoundingPolyAnnotation)(nil), "google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation")
	proto.RegisterType((*Polyline)(nil), "google.cloud.datalabeling.v1beta1.Polyline")
	proto.RegisterType((*NormalizedPolyline)(nil), "google.cloud.datalabeling.v1beta1.NormalizedPolyline")
	proto.RegisterType((*ImagePolylineAnnotation)(nil), "google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation")
	proto.RegisterType((*ImageSegmentationAnnotation)(nil), "google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation")
	proto.RegisterMapType((map[string]*AnnotationSpec)(nil), "google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.AnnotationColorsEntry")
	proto.RegisterType((*TextClassificationAnnotation)(nil), "google.cloud.datalabeling.v1beta1.TextClassificationAnnotation")
	proto.RegisterType((*TextEntityExtractionAnnotation)(nil), "google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation")
	proto.RegisterType((*SequentialSegment)(nil), "google.cloud.datalabeling.v1beta1.SequentialSegment")
	proto.RegisterType((*TimeSegment)(nil), "google.cloud.datalabeling.v1beta1.TimeSegment")
	proto.RegisterType((*VideoClassificationAnnotation)(nil), "google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.datalabeling.v1beta1.ObjectTrackingFrame")
	proto.RegisterType((*VideoObjectTrackingAnnotation)(nil), "google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation")
	proto.RegisterType((*VideoEventAnnotation)(nil), "google.cloud.datalabeling.v1beta1.VideoEventAnnotation")
	proto.RegisterType((*AnnotationMetadata)(nil), "google.cloud.datalabeling.v1beta1.AnnotationMetadata")
	proto.RegisterType((*OperatorMetadata)(nil), "google.cloud.datalabeling.v1beta1.OperatorMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/annotation.proto", fileDescriptor_4bb97872d232a7f7)
}

var fileDescriptor_4bb97872d232a7f7 = []byte{
	// 1638 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x5f, 0x6f, 0xdb, 0x46,
	0x12, 0x37, 0x29, 0xdb, 0x90, 0x47, 0x8a, 0x2d, 0xaf, 0x7d, 0x8e, 0x62, 0xc7, 0x8e, 0xcd, 0x4b,
	0x0e, 0x8e, 0x0f, 0x90, 0x10, 0xe7, 0x72, 0x7f, 0x12, 0xe0, 0xee, 0x64, 0x99, 0xb1, 0x75, 0x67,
	0x8b, 0x0a, 0x45, 0xab, 0x49, 0x80, 0x82, 0xa1, 0xa5, 0xb5, 0xca, 0x86, 0x22, 0x55, 0x92, 0x12,
	0xac, 0x14, 0x28, 0x50, 0xa0, 0x7f, 0x80, 0x16, 0x28, 0xd0, 0xa7, 0x7e, 0x8d, 0xa2, 0xe8, 0x63,
	0x5f, 0xfb, 0xda, 0xd7, 0xf6, 0xa1, 0x2f, 0xfd, 0x26, 0xc5, 0x2e, 0x29, 0x69, 0x49, 0xc9, 0x34,
	0xd5, 0xc4, 0x05, 0xfa, 0x46, 0xce, 0xce, 0xfc, 0xe6, 0x37, 0xb3, 0xc3, 0x9d, 0x59, 0xc2, 0x6e,
	0xd3, 0xb2, 0x9a, 0x06, 0xce, 0xd7, 0x0d, 0xab, 0xd3, 0xc8, 0x37, 0x34, 0x57, 0x33, 0xb4, 0x53,
	0x6c, 0xe8, 0x66, 0x33, 0xdf, 0xbd, 0x77, 0x8a, 0x5d, 0xed, 0x5e, 0x5e, 0x33, 0x4d, 0xcb, 0xd5,
	0x5c, 0xdd, 0x32, 0x73, 0x6d, 0xdb, 0x72, 0x2d, 0xb4, 0xe5, 0xd9, 0xe4, 0xa8, 0x4d, 0x8e, 0xb5,
	0xc9, 0xf9, 0x36, 0xab, 0x37, 0x7d, 0x58, 0xad, 0xad, 0x33, 0xf6, 0x8e, 0x07, 0xb0, 0xfa, 0x68,
	0x12, 0xa7, 0xaa, 0xd3, 0xc6, 0x75, 0xd5, 0xc1, 0xae, 0x6f, 0xfc, 0xe0, 0x72, 0x63, 0x22, 0x54,
	0xdb, 0x5a, 0xcf, 0xb0, 0xb4, 0x46, 0xdf, 0xe7, 0x86, 0x6f, 0x46, 0xdf, 0x4e, 0x3b, 0x67, 0xf9,
	0x46, 0xc7, 0x66, 0x82, 0x12, 0xbe, 0x4d, 0x00, 0x14, 0x06, 0x4e, 0x11, 0x82, 0x69, 0x53, 0x6b,
	0xe1, 0x2c, 0xb7, 0xc9, 0x6d, 0xcf, 0xc9, 0xf4, 0x19, 0xbd, 0x80, 0x45, 0x96, 0x96, 0xd5, 0xb1,
	0xeb, 0x38, 0xcb, 0x6f, 0x72, 0xdb, 0xf3, 0xbb, 0xf7, 0x73, 0x97, 0xe6, 0x24, 0x37, 0x44, 0xaf,
	0x52, 0x53, 0x39, 0xa3, 0x85, 0x24, 0xe8, 0x6d, 0x60, 0x64, 0x6a, 0x57, 0x33, 0x3a, 0x38, 0x9b,
	0xd8, 0xe4, 0xb6, 0x53, 0xbb, 0xbb, 0x13, 0x39, 0xa8, 0x11, 0x4b, 0x79, 0x41, 0x0b, 0x0a, 0xd0,
	0x19, 0x2c, 0x31, 0xf0, 0x2d, 0xec, 0x6a, 0x04, 0x27, 0x3b, 0x4d, 0x3d, 0x3c, 0x98, 0xc8, 0xc3,
	0xb1, 0x6f, 0x2c, 0x23, 0x6d, 0x44, 0x86, 0x74, 0x58, 0x66, 0x13, 0x85, 0x4d, 0x57, 0x6f, 0x61,
	0xd3, 0xcd, 0xce, 0xd2, 0x5c, 0xfd, 0x7d, 0xb2, 0x5c, 0xf5, 0xad, 0x65, 0x86, 0xfb, 0x40, 0x28,
	0xfc, 0x3c, 0x07, 0x0b, 0xa1, 0xb8, 0xd1, 0x67, 0x1c, 0xdc, 0xd2, 0x5b, 0x5a, 0x13, 0xab, 0x75,
	0x43, 0x73, 0x1c, 0xfd, 0x4c, 0xaf, 0x7b, 0x4c, 0x86, 0x00, 0x74, 0x5f, 0x53, 0xbb, 0xff, 0x8d,
	0x41, 0xa5, 0x44, 0x90, 0x8a, 0x01, 0xa0, 0xa1, 0xc3, 0xc3, 0x29, 0x79, 0x5d, 0x8f, 0x52, 0x40,
	0x1f, 0x73, 0xb0, 0xe1, 0x91, 0x39, 0xb5, 0x3a, 0x66, 0x43, 0x37, 0x9b, 0x6a, 0xdb, 0x32, 0x7a,
	0x2c, 0x17, 0x9e, 0x72, 0xf9, 0x77, 0x5c, 0x2e, 0x7b, 0x3e, 0x4e, 0xc5, 0x32, 0x7a, 0x01, 0x26,
	0x6b, 0xfa, 0xc5, 0xcb, 0xe8, 0x1c, 0x6e, 0x78, 0x34, 0x88, 0x77, 0x43, 0x37, 0x31, 0xcb, 0x20,
	0x49, 0x19, 0x3c, 0x8c, 0xcb, 0xa0, 0xe2, 0x43, 0x04, 0xbc, 0x5f, 0xd7, 0xc7, 0x2f, 0xa1, 0x8f,
	0x38, 0xf0, 0x72, 0xa4, 0x3a, 0xb8, 0x49, 0x36, 0x6d, 0x64, 0x33, 0xe6, 0x26, 0x4b, 0x40, 0x95,
	0x81, 0x19, 0x93, 0x80, 0xf1, 0xcb, 0xe8, 0x53, 0x0e, 0x36, 0x5c, 0x7c, 0xee, 0x46, 0x14, 0x85,
	0xf7, 0xa9, 0xfd, 0x27, 0x06, 0x0f, 0x05, 0x9f, 0xbb, 0x11, 0x35, 0x71, 0xd3, 0x8d, 0x58, 0x47,
	0x5f, 0x70, 0xb0, 0x45, 0x99, 0x90, 0x2a, 0x76, 0x7b, 0x2a, 0x3e, 0x77, 0x6d, 0xad, 0x1e, 0x26,
	0x03, 0x94, 0x4c, 0x21, 0x26, 0x19, 0x91, 0x42, 0x89, 0x03, 0xa4, 0x00, 0x1d, 0x1a, 0xf7, 0xc5,
	0x1a, 0xf4, 0x83, 0xe9, 0xea, 0x0d, 0x6c, 0x45, 0xe4, 0x66, 0x3a, 0xf6, 0x07, 0x53, 0x23, 0x48,
	0x51, 0x1f, 0x4c, 0x37, 0x4a, 0x01, 0x7d, 0xce, 0xc1, 0xa6, 0x47, 0xc6, 0x3a, 0x7d, 0x17, 0xd7,
	0x5d, 0x95, 0x10, 0x7e, 0x49, 0xbe, 0x1b, 0x86, 0xcd, 0xcc, 0x64, 0x6c, 0x24, 0x8a, 0xa4, 0xf8,
	0x40, 0x63, 0xd8, 0x5c, 0xa4, 0x80, 0x2c, 0x58, 0xf1, 0xc8, 0xe0, 0x2e, 0x36, 0x5d, 0x96, 0xc2,
	0x2c, 0xa5, 0xf0, 0x8f, 0xb8, 0x14, 0x44, 0x62, 0x1f, 0xf0, 0xbc, 0xdc, 0x1d, 0x23, 0xdf, 0x4b,
	0x03, 0xd0, 0x73, 0x5f, 0x75, 0x7b, 0x6d, 0x2c, 0xbc, 0x0f, 0xeb, 0x91, 0xe7, 0x0f, 0x7a, 0x0e,
	0x0b, 0xa1, 0x56, 0xe9, 0x1f, 0x6d, 0xf7, 0x26, 0x3b, 0x65, 0xdb, 0xb8, 0x2e, 0xcf, 0x6b, 0x81,
	0x77, 0xe1, 0x36, 0xcc, 0xd6, 0xb0, 0xed, 0xe2, 0x73, 0x94, 0x06, 0xee, 0x9c, 0xe2, 0xce, 0xc8,
	0x1c, 0x7d, 0xeb, 0xd1, 0x43, 0x6b, 0x46, 0xe6, 0x7a, 0x42, 0x0e, 0x32, 0x65, 0xcb, 0x6e, 0x69,
	0x86, 0xfe, 0x0a, 0x37, 0xc2, 0xfa, 0x7c, 0x40, 0x9f, 0x27, 0xfa, 0x27, 0x90, 0x66, 0x8f, 0x28,
	0x24, 0x42, 0xb2, 0x8b, 0x6d, 0x57, 0xaf, 0x63, 0x27, 0xcb, 0x6d, 0x26, 0xb6, 0x53, 0xbb, 0x77,
	0xe3, 0xe4, 0x94, 0x3a, 0x92, 0x07, 0xa6, 0xc2, 0x07, 0xb0, 0x32, 0xa4, 0x11, 0x70, 0xd0, 0x80,
	0x25, 0x73, 0xb0, 0xa2, 0x86, 0x7c, 0xc5, 0x69, 0xdc, 0xe1, 0xf0, 0x64, 0x64, 0x06, 0x24, 0xd4,
	0xff, 0x4f, 0x3c, 0xac, 0x45, 0x1c, 0xcf, 0xa8, 0x06, 0xd7, 0x02, 0x0d, 0xc0, 0x3f, 0xf5, 0xf3,
	0x31, 0xfc, 0xb3, 0x88, 0x87, 0x53, 0x72, 0xfa, 0x94, 0x8d, 0xae, 0x03, 0x59, 0x26, 0xba, 0xa0,
	0x0b, 0xef, 0x3c, 0xfb, 0xd7, 0x44, 0x21, 0x86, 0x9c, 0xad, 0x98, 0xe3, 0x93, 0x7a, 0x85, 0x75,
	0xb7, 0x37, 0x0f, 0x5e, 0x88, 0xb8, 0xa1, 0x6a, 0x36, 0xd6, 0x84, 0x27, 0x90, 0xec, 0xb7, 0x95,
	0x37, 0x55, 0x2d, 0xaf, 0x00, 0x0d, 0x43, 0x1e, 0x80, 0xff, 0x3e, 0x95, 0xf2, 0x0d, 0x0f, 0xd7,
	0x2f, 0x68, 0xa3, 0xa8, 0x04, 0xc9, 0x7e, 0x7f, 0xf6, 0x0b, 0xe4, 0xaf, 0x31, 0xdc, 0xf6, 0x81,
	0x0e, 0xa7, 0xe4, 0x81, 0x39, 0x7a, 0x27, 0x10, 0xcc, 0x00, 0x35, 0x11, 0x7b, 0xd8, 0x1b, 0x4d,
	0xd0, 0xe1, 0x14, 0x1b, 0xd0, 0x20, 0x6d, 0x57, 0x59, 0x0b, 0xb3, 0x30, 0x4d, 0xa8, 0x0b, 0x3f,
	0xf6, 0x3f, 0xaf, 0x0b, 0xba, 0xfb, 0x87, 0x5c, 0x60, 0x38, 0xaf, 0x5b, 0x86, 0x65, 0xf7, 0x77,
	0x4e, 0x79, 0xbd, 0xc1, 0x82, 0xa1, 0x58, 0xa4, 0xb0, 0xa2, 0xe9, 0xda, 0x3d, 0x76, 0x7a, 0xf7,
	0xc4, 0x68, 0x0d, 0xe6, 0x5a, 0x7a, 0xcb, 0x3b, 0xb9, 0xe9, 0xee, 0xcd, 0xc9, 0x49, 0x22, 0x50,
	0x7a, 0x6d, 0x8c, 0x6e, 0x41, 0xca, 0x1f, 0x03, 0x7b, 0x2e, 0x76, 0xe8, 0x36, 0xa4, 0x65, 0xf0,
	0x26, 0x36, 0x22, 0x59, 0xed, 0xc2, 0x9f, 0xc6, 0x3a, 0x42, 0x19, 0x48, 0xbc, 0xc4, 0x3d, 0xff,
	0x26, 0x42, 0x1e, 0xd1, 0x01, 0xcc, 0x78, 0x77, 0x03, 0xfe, 0xb7, 0xa6, 0xd9, 0xb3, 0x7f, 0xc8,
	0xff, 0x93, 0x13, 0x5e, 0xc1, 0xcd, 0xa8, 0x69, 0xe6, 0x4a, 0x3b, 0xcc, 0x2f, 0x1c, 0x6c, 0x44,
	0x4f, 0x2f, 0x57, 0xe9, 0x1e, 0xd5, 0x01, 0x39, 0xf8, 0xbd, 0x0e, 0x19, 0xc3, 0x34, 0xa3, 0x3f,
	0x9d, 0xfa, 0x49, 0xfd, 0x5b, 0x0c, 0xf8, 0xea, 0xc0, 0xd8, 0xaf, 0x1c, 0x79, 0xd1, 0x09, 0x8b,
	0x84, 0x47, 0xb0, 0x38, 0xa2, 0x87, 0x96, 0x61, 0xc6, 0x71, 0x35, 0xdb, 0xf5, 0x9b, 0xaa, 0xf7,
	0x42, 0x76, 0x1a, 0x9b, 0x0d, 0xbf, 0xb5, 0x92, 0x47, 0xe1, 0x2b, 0x0e, 0x52, 0x8a, 0xde, 0xea,
	0x57, 0x26, 0x12, 0x61, 0x91, 0xaa, 0xaa, 0xe4, 0xfa, 0xa3, 0x5a, 0x67, 0x67, 0x0e, 0x76, 0xfd,
	0x7c, 0xdc, 0xe8, 0x13, 0xee, 0xdf, 0x70, 0x73, 0xfb, 0xfe, 0x0d, 0x57, 0x5e, 0xa0, 0x36, 0x04,
	0x47, 0xa2, 0x16, 0xa8, 0x00, 0x0b, 0xd8, 0x6c, 0x04, 0x40, 0xf8, 0xcb, 0x40, 0xae, 0x61, 0xb3,
	0x31, 0x84, 0x10, 0x7e, 0xe0, 0x60, 0x3d, 0x72, 0xd2, 0x43, 0x4f, 0x20, 0x4d, 0x1d, 0xf4, 0xf3,
	0xea, 0xd1, 0xcc, 0xc5, 0x19, 0x68, 0x87, 0x11, 0xcb, 0x29, 0x97, 0x09, 0x7f, 0x4c, 0x31, 0xf0,
	0x6f, 0xaa, 0x16, 0xbf, 0xe6, 0x61, 0x29, 0x38, 0x06, 0x3e, 0xb6, 0xc9, 0xad, 0x7f, 0xa4, 0x71,
	0x73, 0x57, 0xdf, 0xb8, 0xf9, 0xab, 0x6b, 0xdc, 0x0f, 0x21, 0xc5, 0x6e, 0x7b, 0xe2, 0xb2, 0x6d,
	0x07, 0x77, 0xb0, 0xe7, 0x23, 0x8d, 0xf9, 0x3b, 0xde, 0xaf, 0x81, 0x0b, 0xc7, 0xe7, 0xab, 0xfc,
	0x7a, 0xc3, 0xf5, 0xc5, 0xbf, 0x7e, 0x7d, 0x19, 0xb0, 0x12, 0xbe, 0x74, 0x9c, 0x91, 0x22, 0x20,
	0xe7, 0x35, 0xe9, 0x24, 0x71, 0x7e, 0x5d, 0x8c, 0xa9, 0x21, 0x79, 0xd9, 0x1a, 0x15, 0x3a, 0xc2,
	0xf7, 0x1c, 0x2c, 0x8f, 0xbb, 0x1b, 0xfc, 0xc1, 0xb2, 0x26, 0x74, 0x01, 0x8d, 0xfe, 0x18, 0x42,
	0x2f, 0x60, 0xd1, 0x6a, 0x63, 0x5b, 0x73, 0x2d, 0x7b, 0xf8, 0xab, 0xc9, 0xf3, 0x16, 0x67, 0x94,
	0x92, 0x7c, 0xdb, 0xc1, 0x8f, 0xa6, 0x8c, 0x15, 0x92, 0x08, 0x9f, 0x70, 0x90, 0x09, 0xab, 0xd1,
	0x93, 0xb5, 0x6e, 0xd9, 0xd8, 0xbf, 0x7e, 0x78, 0x2f, 0xa4, 0xfb, 0xba, 0x96, 0xab, 0x19, 0x6a,
	0xd7, 0x22, 0xdd, 0xd7, 0x3b, 0x61, 0x81, 0x8a, 0x6a, 0x44, 0x42, 0x14, 0x28, 0x05, 0x5f, 0x21,
	0xe1, 0x29, 0x50, 0x91, 0xa7, 0xb0, 0x0a, 0xc9, 0xba, 0xd5, 0x22, 0xf1, 0x3a, 0xd9, 0xe9, 0xcd,
	0x04, 0xe9, 0xed, 0xfd, 0xf7, 0x9d, 0x22, 0x64, 0xc2, 0x3f, 0xf7, 0xd0, 0x16, 0xac, 0x17, 0xca,
	0x65, 0x49, 0x29, 0x28, 0x25, 0xa9, 0xac, 0x56, 0xa5, 0x13, 0xb9, 0x28, 0xaa, 0x27, 0xe5, 0x6a,
	0x45, 0x2c, 0x96, 0x1e, 0x97, 0xc4, 0xfd, 0xcc, 0x14, 0x4a, 0x43, 0x52, 0xaa, 0x88, 0x72, 0x41,
	0x91, 0xe4, 0x4c, 0x62, 0xe7, 0x2d, 0x58, 0x1a, 0xf3, 0xd7, 0x0b, 0xdd, 0x86, 0x4d, 0x16, 0x47,
	0x2c, 0x2b, 0xa5, 0x63, 0xb1, 0xac, 0x8c, 0x42, 0x95, 0xc5, 0x83, 0x82, 0x52, 0xaa, 0x89, 0x19,
	0x8e, 0xbc, 0x55, 0xa4, 0x6a, 0x89, 0xbe, 0xf1, 0x3b, 0x5f, 0x4e, 0xc3, 0xfc, 0x10, 0xd9, 0x1f,
	0x46, 0xd6, 0x18, 0x50, 0xe5, 0x59, 0x25, 0x4c, 0xed, 0xcf, 0x70, 0xab, 0x74, 0x5c, 0x38, 0x10,
	0xd5, 0xe2, 0x51, 0xa1, 0x5a, 0x2d, 0x3d, 0x2e, 0x15, 0x3d, 0xd5, 0xa1, 0x55, 0x86, 0x23, 0x21,
	0x7a, 0x4a, 0x7b, 0xd2, 0x49, 0x79, 0xbf, 0x54, 0x3e, 0x50, 0xf7, 0xa4, 0xa7, 0xac, 0x0a, 0x8f,
	0x76, 0xe0, 0x2f, 0x9e, 0x8a, 0x24, 0x97, 0xc4, 0xb2, 0x22, 0xee, 0x5f, 0xa8, 0x7b, 0x0d, 0x09,
	0xb0, 0x11, 0x82, 0xab, 0x48, 0x47, 0xcf, 0x58, 0x1d, 0x40, 0xeb, 0x70, 0xc3, 0xd3, 0x21, 0x4b,
	0x47, 0xa5, 0xb2, 0xc8, 0x2e, 0xa7, 0x86, 0x8c, 0xaa, 0xe2, 0x01, 0xc9, 0xd2, 0x08, 0xe9, 0x34,
	0xba, 0x0b, 0x77, 0x6a, 0xa5, 0x7d, 0x51, 0x52, 0xab, 0x87, 0x92, 0x52, 0x8d, 0x88, 0x2f, 0x41,
	0x52, 0xef, 0xa9, 0x4a, 0x7b, 0xff, 0x13, 0x8b, 0x8a, 0xaa, 0xc8, 0x85, 0xe2, 0xff, 0x09, 0x2f,
	0x46, 0x6b, 0x1a, 0xdd, 0x81, 0xad, 0x80, 0xd6, 0xbe, 0xa8, 0x88, 0xc5, 0x30, 0xd8, 0x0c, 0x5a,
	0x85, 0x15, 0x4f, 0x4d, 0xac, 0x91, 0xed, 0x63, 0xd6, 0x66, 0x49, 0xe4, 0x8a, 0xf8, 0x54, 0x89,
	0x20, 0x93, 0x24, 0x6e, 0xa8, 0x0e, 0x29, 0x00, 0xe5, 0x99, 0x2a, 0x3e, 0x25, 0x6c, 0xc2, 0x6a,
	0x73, 0x44, 0xed, 0x40, 0x2c, 0x8b, 0x72, 0xe1, 0x28, 0x02, 0x6d, 0x7e, 0xef, 0x1c, 0xee, 0xd4,
	0xad, 0xd6, 0xe5, 0x9f, 0x61, 0x85, 0x7b, 0x7e, 0xec, 0x2b, 0x35, 0x2d, 0x43, 0x33, 0x9b, 0x39,
	0xcb, 0x6e, 0xe6, 0x9b, 0xd8, 0xa4, 0x8d, 0x22, 0xef, 0x2d, 0x69, 0x6d, 0xdd, 0x89, 0xf8, 0x1d,
	0xff, 0x88, 0x15, 0x9e, 0xce, 0x52, 0xcb, 0xfb, 0xbf, 0x06, 0x00, 0x00, 0xff, 0xff, 0x65, 0x1e,
	0xc8, 0xba, 0x79, 0x18, 0x00, 0x00,
}
