// Code generated by protoc-gen-go.
// source: loadtest.proto
// DO NOT EDIT!

/*
Package google_pubsub_loadtest is a generated protocol buffer package.

It is generated from these files:
	loadtest.proto

It has these top-level messages:
	StartRequest
	StartResponse
	PubsubOptions
	KafkaOptions
	MessageIdentifier
	CheckRequest
	CheckResponse
	ExecuteRequest
	ExecuteResponse
*/
package google_pubsub_loadtest

import (
	fmt "fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	google_protobuf "github.com/golang/protobuf/ptypes/duration"

	"context"

	google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type StartRequest struct {
	// The GCP project. This must be set even for Kafka, as we use it to export metrics.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// The Pub/Sub or Kafka topic name.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// The number of requests that can be made, each second, per client.
	RequestRate int32 `protobuf:"varint,3,opt,name=request_rate,json=requestRate" json:"request_rate,omitempty"`
	// The size of each user message to publish
	MessageSize int32 `protobuf:"varint,4,opt,name=message_size,json=messageSize" json:"message_size,omitempty"`
	// The maximum outstanding requests, per client.
	MaxOutstandingRequests int32 `protobuf:"varint,5,opt,name=max_outstanding_requests,json=maxOutstandingRequests" json:"max_outstanding_requests,omitempty"`
	// The time at which the load test should start. If this is less than the current time, we start immediately.
	StartTime *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The burn-in duration, before which results should not be reported.
	BurnInDuration *google_protobuf.Duration `protobuf:"bytes,12,opt,name=burn_in_duration,json=burnInDuration" json:"burn_in_duration,omitempty"`
	// The number of user messages of size message_size to publish together.
	PublishBatchSize int32 `protobuf:"varint,11,opt,name=publish_batch_size,json=publishBatchSize" json:"publish_batch_size,omitempty"`
	// The max duration for coalescing a batch of published messages.
	PublishBatchDuration *google_protobuf.Duration `protobuf:"bytes,13,opt,name=publish_batch_duration,json=publishBatchDuration" json:"publish_batch_duration,omitempty"`
	// Types that are valid to be assigned to StopConditions:
	//	*StartRequest_TestDuration
	//	*StartRequest_NumberOfMessages
	StopConditions isStartRequest_StopConditions `protobuf_oneof:"stop_conditions"`
	// Types that are valid to be assigned to Options:
	//	*StartRequest_PubsubOptions
	//	*StartRequest_KafkaOptions
	Options isStartRequest_Options `protobuf_oneof:"options"`
}

func (m *StartRequest) Reset()                    { *m = StartRequest{} }
func (m *StartRequest) String() string            { return proto.CompactTextString(m) }
func (*StartRequest) ProtoMessage()               {}
func (*StartRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isStartRequest_StopConditions interface {
	isStartRequest_StopConditions()
}
type isStartRequest_Options interface {
	isStartRequest_Options()
}

type StartRequest_TestDuration struct {
	TestDuration *google_protobuf.Duration `protobuf:"bytes,7,opt,name=test_duration,json=testDuration,oneof"`
}
type StartRequest_NumberOfMessages struct {
	NumberOfMessages int32 `protobuf:"varint,8,opt,name=number_of_messages,json=numberOfMessages,oneof"`
}
type StartRequest_PubsubOptions struct {
	PubsubOptions *PubsubOptions `protobuf:"bytes,9,opt,name=pubsub_options,json=pubsubOptions,oneof"`
}
type StartRequest_KafkaOptions struct {
	KafkaOptions *KafkaOptions `protobuf:"bytes,10,opt,name=kafka_options,json=kafkaOptions,oneof"`
}

func (*StartRequest_TestDuration) isStartRequest_StopConditions()     {}
func (*StartRequest_NumberOfMessages) isStartRequest_StopConditions() {}
func (*StartRequest_PubsubOptions) isStartRequest_Options()           {}
func (*StartRequest_KafkaOptions) isStartRequest_Options()            {}

func (m *StartRequest) GetStopConditions() isStartRequest_StopConditions {
	if m != nil {
		return m.StopConditions
	}
	return nil
}
func (m *StartRequest) GetOptions() isStartRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *StartRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *StartRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *StartRequest) GetRequestRate() int32 {
	if m != nil {
		return m.RequestRate
	}
	return 0
}

func (m *StartRequest) GetMessageSize() int32 {
	if m != nil {
		return m.MessageSize
	}
	return 0
}

func (m *StartRequest) GetMaxOutstandingRequests() int32 {
	if m != nil {
		return m.MaxOutstandingRequests
	}
	return 0
}

func (m *StartRequest) GetStartTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StartRequest) GetBurnInDuration() *google_protobuf.Duration {
	if m != nil {
		return m.BurnInDuration
	}
	return nil
}

func (m *StartRequest) GetPublishBatchSize() int32 {
	if m != nil {
		return m.PublishBatchSize
	}
	return 0
}

func (m *StartRequest) GetPublishBatchDuration() *google_protobuf.Duration {
	if m != nil {
		return m.PublishBatchDuration
	}
	return nil
}

func (m *StartRequest) GetTestDuration() *google_protobuf.Duration {
	if x, ok := m.GetStopConditions().(*StartRequest_TestDuration); ok {
		return x.TestDuration
	}
	return nil
}

func (m *StartRequest) GetNumberOfMessages() int32 {
	if x, ok := m.GetStopConditions().(*StartRequest_NumberOfMessages); ok {
		return x.NumberOfMessages
	}
	return 0
}

func (m *StartRequest) GetPubsubOptions() *PubsubOptions {
	if x, ok := m.GetOptions().(*StartRequest_PubsubOptions); ok {
		return x.PubsubOptions
	}
	return nil
}

func (m *StartRequest) GetKafkaOptions() *KafkaOptions {
	if x, ok := m.GetOptions().(*StartRequest_KafkaOptions); ok {
		return x.KafkaOptions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StartRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StartRequest_OneofMarshaler, _StartRequest_OneofUnmarshaler, _StartRequest_OneofSizer, []interface{}{
		(*StartRequest_TestDuration)(nil),
		(*StartRequest_NumberOfMessages)(nil),
		(*StartRequest_PubsubOptions)(nil),
		(*StartRequest_KafkaOptions)(nil),
	}
}

func _StartRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StartRequest)
	// stop_conditions
	switch x := m.StopConditions.(type) {
	case *StartRequest_TestDuration:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TestDuration); err != nil {
			return err
		}
	case *StartRequest_NumberOfMessages:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.NumberOfMessages))
	case nil:
	default:
		return fmt.Errorf("StartRequest.StopConditions has unexpected type %T", x)
	}
	// options
	switch x := m.Options.(type) {
	case *StartRequest_PubsubOptions:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PubsubOptions); err != nil {
			return err
		}
	case *StartRequest_KafkaOptions:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KafkaOptions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StartRequest.Options has unexpected type %T", x)
	}
	return nil
}

func _StartRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StartRequest)
	switch tag {
	case 7: // stop_conditions.test_duration
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf.Duration)
		err := b.DecodeMessage(msg)
		m.StopConditions = &StartRequest_TestDuration{msg}
		return true, err
	case 8: // stop_conditions.number_of_messages
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.StopConditions = &StartRequest_NumberOfMessages{int32(x)}
		return true, err
	case 9: // options.pubsub_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PubsubOptions)
		err := b.DecodeMessage(msg)
		m.Options = &StartRequest_PubsubOptions{msg}
		return true, err
	case 10: // options.kafka_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(KafkaOptions)
		err := b.DecodeMessage(msg)
		m.Options = &StartRequest_KafkaOptions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StartRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StartRequest)
	// stop_conditions
	switch x := m.StopConditions.(type) {
	case *StartRequest_TestDuration:
		s := proto.Size(x.TestDuration)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StartRequest_NumberOfMessages:
		n += proto.SizeVarint(8<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.NumberOfMessages))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// options
	switch x := m.Options.(type) {
	case *StartRequest_PubsubOptions:
		s := proto.Size(x.PubsubOptions)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StartRequest_KafkaOptions:
		s := proto.Size(x.KafkaOptions)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StartResponse struct {
}

func (m *StartResponse) Reset()                    { *m = StartResponse{} }
func (m *StartResponse) String() string            { return proto.CompactTextString(m) }
func (*StartResponse) ProtoMessage()               {}
func (*StartResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type PubsubOptions struct {
	// The Cloud Pub/Sub subscription name
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The maximum number of messages to pull which each request.
	MaxMessagesPerPull int32 `protobuf:"varint,2,opt,name=max_messages_per_pull,json=maxMessagesPerPull" json:"max_messages_per_pull,omitempty"`
}

func (m *PubsubOptions) Reset()                    { *m = PubsubOptions{} }
func (m *PubsubOptions) String() string            { return proto.CompactTextString(m) }
func (*PubsubOptions) ProtoMessage()               {}
func (*PubsubOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *PubsubOptions) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *PubsubOptions) GetMaxMessagesPerPull() int32 {
	if m != nil {
		return m.MaxMessagesPerPull
	}
	return 0
}

type KafkaOptions struct {
	// The network address of the Kafka broker.
	Broker string `protobuf:"bytes,1,opt,name=broker" json:"broker,omitempty"`
	// The length of time to poll for.
	PollDuration *google_protobuf.Duration `protobuf:"bytes,2,opt,name=poll_duration,json=pollDuration" json:"poll_duration,omitempty"`
}

func (m *KafkaOptions) Reset()                    { *m = KafkaOptions{} }
func (m *KafkaOptions) String() string            { return proto.CompactTextString(m) }
func (*KafkaOptions) ProtoMessage()               {}
func (*KafkaOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *KafkaOptions) GetBroker() string {
	if m != nil {
		return m.Broker
	}
	return ""
}

func (m *KafkaOptions) GetPollDuration() *google_protobuf.Duration {
	if m != nil {
		return m.PollDuration
	}
	return nil
}

type MessageIdentifier struct {
	// The unique id of the client that published the message.
	PublisherClientId int64 `protobuf:"varint,1,opt,name=publisher_client_id,json=publisherClientId" json:"publisher_client_id,omitempty"`
	// Sequence number of the published message with the given publish_client_id.
	SequenceNumber int32 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber" json:"sequence_number,omitempty"`
}

func (m *MessageIdentifier) Reset()                    { *m = MessageIdentifier{} }
func (m *MessageIdentifier) String() string            { return proto.CompactTextString(m) }
func (*MessageIdentifier) ProtoMessage()               {}
func (*MessageIdentifier) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *MessageIdentifier) GetPublisherClientId() int64 {
	if m != nil {
		return m.PublisherClientId
	}
	return 0
}

func (m *MessageIdentifier) GetSequenceNumber() int32 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

type CheckRequest struct {
	// Duplicate messages that should not be reported for throughput and latency.
	Duplicates []*MessageIdentifier `protobuf:"bytes,1,rep,name=duplicates" json:"duplicates,omitempty"`
}

func (m *CheckRequest) Reset()                    { *m = CheckRequest{} }
func (m *CheckRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()               {}
func (*CheckRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CheckRequest) GetDuplicates() []*MessageIdentifier {
	if m != nil {
		return m.Duplicates
	}
	return nil
}

type CheckResponse struct {
	// Histogram of latencies, each one a delta from the previous CheckResponse sent.
	BucketValues []int64 `protobuf:"varint,1,rep,packed,name=bucket_values,json=bucketValues" json:"bucket_values,omitempty"`
	// The duration from the start of the loadtest to its completion or now if is_finished is false.
	RunningDuration *google_protobuf.Duration `protobuf:"bytes,2,opt,name=running_duration,json=runningDuration" json:"running_duration,omitempty"`
	// True if the load test has finished running.
	IsFinished bool `protobuf:"varint,3,opt,name=is_finished,json=isFinished" json:"is_finished,omitempty"`
	// MessageIdentifiers of all received messages since the last Check
	ReceivedMessages []*MessageIdentifier `protobuf:"bytes,4,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *CheckResponse) Reset()                    { *m = CheckResponse{} }
func (m *CheckResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()               {}
func (*CheckResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CheckResponse) GetBucketValues() []int64 {
	if m != nil {
		return m.BucketValues
	}
	return nil
}

func (m *CheckResponse) GetRunningDuration() *google_protobuf.Duration {
	if m != nil {
		return m.RunningDuration
	}
	return nil
}

func (m *CheckResponse) GetIsFinished() bool {
	if m != nil {
		return m.IsFinished
	}
	return false
}

func (m *CheckResponse) GetReceivedMessages() []*MessageIdentifier {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

type ExecuteRequest struct {
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()               {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type ExecuteResponse struct {
	// Latencies of the completed operations
	Latencies []int64 `protobuf:"varint,1,rep,packed,name=latencies" json:"latencies,omitempty"`
	// MessageIdentifiers of all received messages since the last Execute
	ReceivedMessages []*MessageIdentifier `protobuf:"bytes,2,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()               {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ExecuteResponse) GetLatencies() []int64 {
	if m != nil {
		return m.Latencies
	}
	return nil
}

func (m *ExecuteResponse) GetReceivedMessages() []*MessageIdentifier {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

func init() {
	proto.RegisterType((*StartRequest)(nil), "google.pubsub.loadtest.StartRequest")
	proto.RegisterType((*StartResponse)(nil), "google.pubsub.loadtest.StartResponse")
	proto.RegisterType((*PubsubOptions)(nil), "google.pubsub.loadtest.PubsubOptions")
	proto.RegisterType((*KafkaOptions)(nil), "google.pubsub.loadtest.KafkaOptions")
	proto.RegisterType((*MessageIdentifier)(nil), "google.pubsub.loadtest.MessageIdentifier")
	proto.RegisterType((*CheckRequest)(nil), "google.pubsub.loadtest.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.pubsub.loadtest.CheckResponse")
	proto.RegisterType((*ExecuteRequest)(nil), "google.pubsub.loadtest.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "google.pubsub.loadtest.ExecuteResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Loadtest service

type LoadtestClient interface {
	// Starts a load test
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	// Checks the status of a load test
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
}

type loadtestClient struct {
	cc *grpc.ClientConn
}

func NewLoadtestClient(cc *grpc.ClientConn) LoadtestClient {
	return &loadtestClient{cc}
}

func (c *loadtestClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	out := new(StartResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.loadtest.Loadtest/Start", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loadtestClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.loadtest.Loadtest/Check", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Loadtest service

type LoadtestServer interface {
	// Starts a load test
	Start(context.Context, *StartRequest) (*StartResponse, error)
	// Checks the status of a load test
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
}

func RegisterLoadtestServer(s *grpc.Server, srv LoadtestServer) {
	s.RegisterService(&_Loadtest_serviceDesc, srv)
}

func _Loadtest_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.loadtest.Loadtest/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Loadtest_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.loadtest.Loadtest/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Loadtest_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.loadtest.Loadtest",
	HandlerType: (*LoadtestServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Start",
			Handler:    _Loadtest_Start_Handler,
		},
		{
			MethodName: "Check",
			Handler:    _Loadtest_Check_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "loadtest.proto",
}

// Client API for LoadtestWorker service

type LoadtestWorkerClient interface {
	// Starts a worker
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	// Executes a command on the worker, returning the latencies of the operations. Since some
	// commands consist of multiple operations (i.e. pulls contain many received messages with
	// different end to end latencies) a single command can have multiple latencies returned.
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*ExecuteResponse, error)
}

type loadtestWorkerClient struct {
	cc *grpc.ClientConn
}

func NewLoadtestWorkerClient(cc *grpc.ClientConn) LoadtestWorkerClient {
	return &loadtestWorkerClient{cc}
}

func (c *loadtestWorkerClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	out := new(StartResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.loadtest.LoadtestWorker/Start", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loadtestWorkerClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*ExecuteResponse, error) {
	out := new(ExecuteResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.loadtest.LoadtestWorker/Execute", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for LoadtestWorker service

type LoadtestWorkerServer interface {
	// Starts a worker
	Start(context.Context, *StartRequest) (*StartResponse, error)
	// Executes a command on the worker, returning the latencies of the operations. Since some
	// commands consist of multiple operations (i.e. pulls contain many received messages with
	// different end to end latencies) a single command can have multiple latencies returned.
	Execute(context.Context, *ExecuteRequest) (*ExecuteResponse, error)
}

func RegisterLoadtestWorkerServer(s *grpc.Server, srv LoadtestWorkerServer) {
	s.RegisterService(&_LoadtestWorker_serviceDesc, srv)
}

func _LoadtestWorker_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestWorkerServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.loadtest.LoadtestWorker/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestWorkerServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoadtestWorker_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestWorkerServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.loadtest.LoadtestWorker/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestWorkerServer).Execute(ctx, req.(*ExecuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LoadtestWorker_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.loadtest.LoadtestWorker",
	HandlerType: (*LoadtestWorkerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Start",
			Handler:    _LoadtestWorker_Start_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _LoadtestWorker_Execute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "loadtest.proto",
}

func init() { proto.RegisterFile("loadtest.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 847 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0xae, 0x93, 0x6e, 0x92, 0x3d, 0x6b, 0xef, 0x6e, 0x86, 0x12, 0x99, 0x15, 0xd0, 0x60, 0x28,
	0x0d, 0x12, 0x72, 0x45, 0xb8, 0x81, 0x1b, 0x84, 0x92, 0x82, 0x12, 0x15, 0x9a, 0xc8, 0x8d, 0x8a,
	0xe0, 0x66, 0x34, 0xb6, 0x67, 0x93, 0x61, 0xed, 0x19, 0x33, 0x3f, 0x55, 0xd4, 0x17, 0xe0, 0x8d,
	0x78, 0x00, 0x1e, 0x87, 0x5b, 0x5e, 0x00, 0xcd, 0x78, 0xbc, 0x3f, 0x6d, 0x57, 0x0b, 0x42, 0xbd,
	0x3c, 0xdf, 0xf9, 0xce, 0x37, 0xe7, 0xd7, 0x86, 0x61, 0x25, 0x48, 0xa9, 0xa9, 0xd2, 0x69, 0x23,
	0x85, 0x16, 0xe8, 0xe0, 0x5a, 0x88, 0xeb, 0x8a, 0xa6, 0x8d, 0xc9, 0x95, 0xc9, 0xd3, 0xce, 0x3b,
	0xf9, 0xb0, 0xc5, 0x1f, 0x39, 0x56, 0x6e, 0xa6, 0x8f, 0x4a, 0x23, 0x89, 0x66, 0x82, 0xb7, 0x71,
	0x93, 0xfb, 0xaf, 0xfa, 0x35, 0xab, 0xa9, 0xd2, 0xa4, 0x6e, 0x5a, 0x42, 0xf2, 0x57, 0x0f, 0xc2,
	0x67, 0x9a, 0x48, 0x9d, 0xd1, 0xdf, 0x0c, 0x55, 0x1a, 0xc5, 0xb0, 0xdb, 0x48, 0xf1, 0x2b, 0x2d,
	0x74, 0x1c, 0x1c, 0x06, 0x47, 0xfd, 0xac, 0x33, 0xd1, 0x3d, 0xe8, 0x69, 0xd1, 0xb0, 0x22, 0xde,
	0x72, 0x78, 0x6b, 0xa0, 0x8f, 0x20, 0x94, 0x6d, 0x28, 0x96, 0x44, 0xd3, 0x78, 0xfb, 0x30, 0x38,
	0xea, 0x65, 0x03, 0x8f, 0x65, 0x44, 0x53, 0x4b, 0xa9, 0xa9, 0x52, 0xe4, 0x9a, 0x62, 0xc5, 0x5e,
	0xd2, 0xf8, 0x6e, 0x4b, 0xf1, 0xd8, 0x33, 0xf6, 0x92, 0xa2, 0xaf, 0x20, 0xae, 0xc9, 0x2d, 0x16,
	0x46, 0x2b, 0x4d, 0x78, 0xc9, 0xf8, 0x35, 0xf6, 0x0a, 0x2a, 0xee, 0x39, 0xfa, 0x41, 0x4d, 0x6e,
	0x2f, 0x16, 0x6e, 0x9f, 0xae, 0x42, 0x5f, 0x03, 0x28, 0x9b, 0x3f, 0xb6, 0x95, 0xc5, 0x3b, 0x87,
	0xc1, 0xd1, 0xe0, 0x78, 0x92, 0x76, 0xed, 0xf2, 0x65, 0xa7, 0x57, 0x5d, 0xd9, 0x59, 0xdf, 0xb1,
	0xad, 0x8d, 0x4e, 0x61, 0x9c, 0x1b, 0xc9, 0x31, 0xe3, 0xb8, 0x6b, 0x5b, 0x1c, 0x3a, 0x81, 0xf7,
	0x5e, 0x13, 0x78, 0xec, 0x09, 0xd9, 0xd0, 0x86, 0x9c, 0xf3, 0xce, 0x46, 0x9f, 0x03, 0x6a, 0x4c,
	0x5e, 0x31, 0x75, 0x83, 0x73, 0xa2, 0x8b, 0x9b, 0xb6, 0xc4, 0x81, 0xcb, 0x79, 0xec, 0x3d, 0x27,
	0xd6, 0xe1, 0xea, 0xbc, 0x80, 0x83, 0x55, 0xf6, 0xfc, 0xe1, 0x68, 0xd3, 0xc3, 0xf7, 0x96, 0xc5,
	0xe6, 0xcf, 0x7f, 0x0b, 0x91, 0x5d, 0x84, 0x85, 0xce, 0xee, 0x06, 0x9d, 0xb3, 0x3b, 0x59, 0x68,
	0x23, 0xe6, 0x0a, 0x29, 0x20, 0x6e, 0xea, 0x9c, 0x4a, 0x2c, 0xa6, 0xd8, 0xcf, 0x44, 0xc5, 0x7b,
	0xb6, 0x80, 0xb3, 0x3b, 0xd9, 0xb8, 0xf5, 0x5d, 0x4c, 0x7f, 0xf4, 0x1e, 0xf4, 0x14, 0x86, 0xed,
	0x16, 0x62, 0xd1, 0x58, 0x01, 0x15, 0xf7, 0xdd, 0x93, 0x0f, 0xd2, 0x37, 0xef, 0x68, 0x7a, 0xe9,
	0xec, 0x8b, 0x96, 0x7c, 0x16, 0x64, 0x51, 0xb3, 0x0c, 0xa0, 0x27, 0x10, 0xcd, 0xc8, 0x74, 0x46,
	0xe6, 0x72, 0xe0, 0xe4, 0x3e, 0x59, 0x27, 0xf7, 0xc4, 0x92, 0x17, 0x6a, 0xe1, 0x6c, 0xc9, 0x3e,
	0xd9, 0x87, 0x91, 0xd2, 0xa2, 0xc1, 0x85, 0xe0, 0x25, 0x6b, 0xa1, 0x3e, 0xec, 0x7a, 0xe5, 0x64,
	0x04, 0x91, 0xdf, 0x75, 0xd5, 0x08, 0xae, 0x68, 0x32, 0x85, 0x68, 0x25, 0x3b, 0x94, 0x40, 0xa8,
	0x4c, 0xae, 0x0a, 0xc9, 0x1c, 0xe0, 0x4f, 0x60, 0x05, 0x43, 0x5f, 0xc0, 0xbb, 0x76, 0x57, 0xbb,
	0x56, 0xe1, 0x86, 0x4a, 0xdc, 0x98, 0xaa, 0x72, 0x77, 0xd1, 0xcb, 0x50, 0x4d, 0x6e, 0xbb, 0x66,
	0x5d, 0x52, 0x79, 0x69, 0xaa, 0x2a, 0x99, 0x42, 0xb8, 0x9c, 0x36, 0x3a, 0x80, 0x9d, 0x5c, 0x8a,
	0x19, 0x95, 0xfe, 0x01, 0x6f, 0xa1, 0x6f, 0x20, 0x6a, 0x44, 0x55, 0x2d, 0xa6, 0xb9, 0xb5, 0x69,
	0x2b, 0x42, 0xcb, 0xef, 0xac, 0xa4, 0x82, 0x7d, 0xff, 0xf4, 0x79, 0x49, 0xb9, 0x66, 0x53, 0x46,
	0x25, 0x4a, 0xe1, 0x1d, 0xbf, 0x3a, 0x54, 0xe2, 0xa2, 0x62, 0x94, 0x6b, 0xcc, 0x4a, 0xf7, 0xf2,
	0x76, 0xb6, 0x3f, 0x77, 0x9d, 0x3a, 0xcf, 0x79, 0x89, 0x1e, 0xc2, 0x48, 0xd9, 0xeb, 0xe2, 0x05,
	0xc5, 0xed, 0xf4, 0x7d, 0x65, 0xc3, 0x0e, 0x7e, 0xea, 0xd0, 0xe4, 0x67, 0x08, 0x4f, 0x6f, 0x68,
	0x31, 0xeb, 0x3e, 0x1d, 0xe7, 0x00, 0xa5, 0x69, 0x2a, 0x56, 0x10, 0x4d, 0x55, 0x1c, 0x1c, 0x6e,
	0x1f, 0x0d, 0x8e, 0x3f, 0x5b, 0x37, 0xc6, 0xd7, 0xf2, 0xcc, 0x96, 0x82, 0x93, 0xbf, 0x03, 0x88,
	0xbc, 0x76, 0x3b, 0x2a, 0xf4, 0x31, 0x44, 0xb9, 0x29, 0x66, 0x54, 0xe3, 0x17, 0xa4, 0x32, 0x5e,
	0x7f, 0x3b, 0x0b, 0x5b, 0xf0, 0xb9, 0xc3, 0xd0, 0x63, 0x18, 0x4b, 0xc3, 0xb9, 0xfd, 0x7c, 0xfc,
	0xfb, 0x16, 0x8e, 0x7c, 0xc8, 0xfc, 0x22, 0xee, 0xc3, 0x80, 0x29, 0x3c, 0x65, 0xdc, 0xf6, 0xa5,
	0x74, 0x5f, 0xb4, 0xbd, 0x0c, 0x98, 0xfa, 0xde, 0x23, 0xe8, 0x39, 0xec, 0x4b, 0x5a, 0x50, 0xf6,
	0x82, 0x96, 0x8b, 0x8b, 0xb9, 0xfb, 0x5f, 0xeb, 0x1d, 0x77, 0x1a, 0xdd, 0xb6, 0x24, 0x63, 0x18,
	0x7e, 0x77, 0x4b, 0x0b, 0xa3, 0xa9, 0x6f, 0x69, 0xf2, 0x7b, 0x00, 0xa3, 0x39, 0xe4, 0x3b, 0xf1,
	0x3e, 0xf4, 0x2b, 0xa2, 0x29, 0x2f, 0xd8, 0xbc, 0x0b, 0x0b, 0xe0, 0xcd, 0xb9, 0x6d, 0xfd, 0xef,
	0xdc, 0x8e, 0xff, 0x08, 0x60, 0xef, 0x07, 0x1f, 0x80, 0xae, 0xa0, 0xe7, 0x0e, 0x09, 0xad, 0xbd,
	0xd2, 0xe5, 0x7f, 0xca, 0xe4, 0xc1, 0x06, 0x96, 0x2f, 0xec, 0x0a, 0x7a, 0x6e, 0xe6, 0xeb, 0x55,
	0x97, 0xd7, 0x6d, 0xbd, 0xea, 0xca, 0xe2, 0x1c, 0xff, 0x19, 0xc0, 0xb0, 0x4b, 0xfc, 0x27, 0x21,
	0xed, 0x99, 0xbd, 0x9d, 0xf4, 0x7f, 0x81, 0x5d, 0x3f, 0x2a, 0xf4, 0xe9, 0xba, 0x88, 0xd5, 0xf1,
	0x4e, 0x1e, 0x6e, 0xe4, 0xb5, 0xda, 0x27, 0x29, 0x7c, 0x50, 0x88, 0xfa, 0x15, 0xf6, 0xb4, 0x62,
	0x45, 0x5a, 0x88, 0xba, 0x16, 0xfc, 0x24, 0xea, 0x4a, 0xbc, 0x74, 0xfb, 0xbd, 0xe3, 0xd6, 0xfc,
	0xcb, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0xc4, 0xfc, 0xdc, 0x27, 0x48, 0x08, 0x00, 0x00,
}
