{
  clusterPrometheusOperator+:: $.prometheusOperator {
    // These manifests are generated by kube-prmoetheus, but are not necessary in
    // the cluster-monitoring-operator as  CRDs are registered,
    // updated and migrated by the Prometheus Operator.
    '0alertmanagerCustomResourceDefinition':: {},
    '0prometheusCustomResourceDefinition':: {},
    '0servicemonitorCustomResourceDefinition':: {},
    '0podmonitorCustomResourceDefinition':: {},
    '0prometheusruleCustomResourceDefinition':: {},

    deployment+:
      {
        spec+: {
          template+: {
            spec+: {
              nodeSelector+: {
                'node-role.kubernetes.io/master': '',
              },
              tolerations: [
                {
                  key: 'node-role.kubernetes.io/master',
                  operator: 'Exists',
                  effect: 'NoSchedule',
                },
              ],
              securityContext: {},
              priorityClassName: 'system-cluster-critical',
              containers:
                std.map(
                  function(c) c {
                    args+: [
                      '--namespaces=' + $._config.namespace,
                      '--prometheus-instance-namespaces=' + $._config.namespace,
                      '--alertmanager-instance-namespaces=' + $._config.namespace,
                    ],
                    securityContext: {},
                    resources: {
                      requests: {
                        memory: '60Mi',
                        cpu: '10m',
                      },
                    },
                    terminationMessagePolicy: 'FallbackToLogsOnError',
                  },
                  super.containers,
                ),
            },
          },
        },
      },
  },
}
