local k = import 'ksonnet/ksonnet.beta.3/k.libsonnet';
local service = k.core.v1.service;
local deployment = k.apps.v1beta2.deployment;
local container = deployment.mixin.spec.template.spec.containersType;
local volume = deployment.mixin.spec.template.spec.volumesType;
local containerVolumeMount = container.volumeMountsType;
local tlsVolumeName = 'prometheus-operator-tls';

{
  clusterPrometheusOperator+:: $.prometheusOperator {
    // These manifests are generated by kube-prmoetheus, but are not necessary in
    // the cluster-monitoring-operator as  CRDs are registered,
    // updated and migrated by the Prometheus Operator.
    '0alertmanagerCustomResourceDefinition':: {},
    '0prometheusCustomResourceDefinition':: {},
    '0servicemonitorCustomResourceDefinition':: {},
    '0podmonitorCustomResourceDefinition':: {},
    '0prometheusruleCustomResourceDefinition':: {},
    '0thanosrulerCustomResourceDefinition':: {},

    deployment+: {
        spec+: {
          template+: {
            spec+: {
              nodeSelector+: {
                'node-role.kubernetes.io/master': '',
              },
              tolerations: [
                {
                  key: 'node-role.kubernetes.io/master',
                  operator: 'Exists',
                  effect: 'NoSchedule',
                },
              ],
              securityContext: {},
              priorityClassName: 'system-cluster-critical',
              containers:
                std.map(
                  function(c)
                    if c.name == 'prometheus-operator' then
                      c {
                        args+: [
                          '--namespaces=' + $._config.namespace,
                          '--prometheus-instance-namespaces=' + $._config.namespace,
                          '--thanos-ruler-instance-namespaces=' + $._config.namespace,
                          '--alertmanager-instance-namespaces=' + $._config.namespace,
                          '--config-reloader-cpu=0',
                          '--config-reloader-memory=0',
                        ],
                        securityContext: {},
                        resources: {
                          requests: {
                            memory: '60Mi',
                            cpu: '5m',
                          },
                        },
                        terminationMessagePolicy: 'FallbackToLogsOnError',
                      }
                    else if c.name == 'kube-rbac-proxy' then
                      c {
                        args+: [
                          '--tls-cert-file=/etc/tls/private/tls.crt',
                          '--tls-private-key-file=/etc/tls/private/tls.key',
                        ],
                        terminationMessagePolicy: 'FallbackToLogsOnError',
                        volumeMounts: [
                          containerVolumeMount.new(tlsVolumeName, '/etc/tls/private'),
                        ],
                        securityContext: {},
                        resources: {
                          requests: {
                            memory: '40Mi',
                            cpu: '1m',
                          },
                        },
                      }
                    else
                      c,
                  super.containers,
                ),
              volumes+: [
                volume.fromSecret(tlsVolumeName, 'prometheus-operator-tls'),
              ],
            },
          },
        },
      },
    service+:
      service.mixin.metadata.withAnnotations({
        'service.beta.openshift.io/serving-cert-secret-name': "prometheus-operator-tls",
      }),
    serviceMonitor+: {
      spec+: {
        endpoints: [
          {
            honorLabels: true,
            bearerTokenFile: '/var/run/secrets/kubernetes.io/serviceaccount/token',
            port: 'https',
            scheme: 'https',
            tlsConfig: {
              caFile: '/etc/prometheus/configmaps/serving-certs-ca-bundle/service-ca.crt',
              serverName: 'server-name-replaced-at-runtime',
            },
          },
        ],
      },
    },
  },
}
