package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_ClusterInfo = map[string]string{
	"":                      "ClusterInfo holds information the web console needs to talk to the cluster such as master public URL and metrics public URL",
	"consolePublicURL":      "ConsolePublicURL is where you can find the web console server (TODO do we really need this?)",
	"masterPublicURL":       "MasterPublicURL is how the web console can access the OpenShift v1 server",
	"loggingPublicURL":      "LoggingPublicURL is the public endpoint for logging (optional)",
	"metricsPublicURL":      "MetricsPublicURL is the public endpoint for metrics (optional)",
	"logoutPublicURL":       "LogoutPublicURL is an optional, absolute URL to redirect web browsers to after logging out of the web console. If not specified, the built-in logout page is shown.",
	"adminConsolePublicURL": "AdminConsolePublicURL is an optional, public URL of the OpenShift admin console. If specified, the web console will add a link to the admin console in a context selector in its masthead.",
}

func (ClusterInfo) SwaggerDoc() map[string]string {
	return map_ClusterInfo
}

var map_ExtensionsConfiguration = map[string]string{
	"":               "ExtensionsConfiguration holds custom script, stylesheets, and properties used for web console customization",
	"scriptURLs":     "ScriptURLs are URLs to load as scripts when the Web Console loads. The URLs must be accessible from the browser.",
	"stylesheetURLs": "StylesheetURLs are URLs to load as stylesheets when the Web Console loads. The URLs must be accessible from the browser.",
	"properties":     "Properties are key(string) and value(string) pairs that will be injected into the console under the global variable OPENSHIFT_EXTENSION_PROPERTIES",
}

func (ExtensionsConfiguration) SwaggerDoc() map[string]string {
	return map_ExtensionsConfiguration
}

var map_FeaturesConfiguration = map[string]string{
	"":                                "FeaturesConfiguration defines various feature gates for the web console",
	"inactivityTimeoutMinutes":        "InactivityTimeoutMinutes is the number of minutes of inactivity before you are automatically logged out of the web console (optional). If set to 0, inactivity timeout is disabled.",
	"clusterResourceOverridesEnabled": "ClusterResourceOverridesEnabled indicates that the cluster is configured for overcommit. When set to true, the web console will hide the CPU request, CPU limit, and memory request fields in its editors and skip validation on those fields. The memory limit field will still be displayed.",
}

func (FeaturesConfiguration) SwaggerDoc() map[string]string {
	return map_FeaturesConfiguration
}

var map_WebConsoleConfiguration = map[string]string{
	"":            "WebConsoleConfiguration holds the necessary configuration options for serving the web console",
	"servingInfo": "ServingInfo is the HTTP serving information for these assets",
	"clusterInfo": "ClusterInfo holds information the web console needs to talk to the cluster such as master public URL and metrics public URL",
	"features":    "Features define various feature gates for the web console",
	"extensions":  "Extensions define custom scripts, stylesheets, and properties used for web console customization",
}

func (WebConsoleConfiguration) SwaggerDoc() map[string]string {
	return map_WebConsoleConfiguration
}

// AUTO-GENERATED FUNCTIONS END HERE
