package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AdmissionConfig = map[string]string{
	"enabledPlugins":  "enabledPlugins is a list of admission plugins that must be on in addition to the default list. Some admission plugins are disabled by default, but certain configurations require them.  This is fairly uncommon and can result in performance penalties and unexpected behavior.",
	"disabledPlugins": "disabledPlugins is a list of admission plugins that must be off.  Putting something in this list is almost always a mistake and likely to result in cluster instability.",
}

func (AdmissionConfig) SwaggerDoc() map[string]string {
	return map_AdmissionConfig
}

var map_AdmissionPluginConfig = map[string]string{
	"":              "AdmissionPluginConfig holds the necessary configuration options for admission plugins",
	"location":      "Location is the path to a configuration file that contains the plugin's configuration",
	"configuration": "Configuration is an embedded configuration object to be used as the plugin's configuration. If present, it will be used instead of the path to the configuration file.",
}

func (AdmissionPluginConfig) SwaggerDoc() map[string]string {
	return map_AdmissionPluginConfig
}

var map_AuditConfig = map[string]string{
	"":                         "AuditConfig holds configuration for the audit capabilities",
	"enabled":                  "If this flag is set, audit log will be printed in the logs. The logs contains, method, user and a requested URL.",
	"auditFilePath":            "All requests coming to the apiserver will be logged to this file.",
	"maximumFileRetentionDays": "Maximum number of days to retain old log files based on the timestamp encoded in their filename.",
	"maximumRetainedFiles":     "Maximum number of old log files to retain.",
	"maximumFileSizeMegabytes": "Maximum size in megabytes of the log file before it gets rotated. Defaults to 100MB.",
	"policyFile":               "PolicyFile is a path to the file that defines the audit policy configuration.",
	"policyConfiguration":      "PolicyConfiguration is an embedded policy configuration object to be used as the audit policy configuration. If present, it will be used instead of the path to the policy file.",
	"logFormat":                "Format of saved audits (legacy or json).",
	"webHookKubeConfig":        "Path to a .kubeconfig formatted file that defines the audit webhook configuration.",
	"webHookMode":              "Strategy for sending audit events (block or batch).",
}

func (AuditConfig) SwaggerDoc() map[string]string {
	return map_AuditConfig
}

var map_CertInfo = map[string]string{
	"":         "CertInfo relates a certificate with a private key",
	"certFile": "CertFile is a file containing a PEM-encoded certificate",
	"keyFile":  "KeyFile is a file containing a PEM-encoded private key for the certificate specified by CertFile",
}

func (CertInfo) SwaggerDoc() map[string]string {
	return map_CertInfo
}

var map_ClientConnectionOverrides = map[string]string{
	"acceptContentTypes": "acceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.",
	"contentType":        "contentType is the content type used when sending data to the server from this client.",
	"qps":                "qps controls the number of queries per second allowed for this connection.",
	"burst":              "burst allows extra queries to accumulate when a client is exceeding its rate.",
}

func (ClientConnectionOverrides) SwaggerDoc() map[string]string {
	return map_ClientConnectionOverrides
}

var map_ConfigMapFileReference = map[string]string{
	"":    "ConfigMapFileReference references a config map in a specific namespace. The namespace must be specified at the point of use.",
	"key": "Key allows pointing to a specific key/value inside of the configmap.  This is useful for logical file references.",
}

func (ConfigMapFileReference) SwaggerDoc() map[string]string {
	return map_ConfigMapFileReference
}

var map_ConfigMapNameReference = map[string]string{
	"":     "ConfigMapNameReference references a config map in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced config map",
}

func (ConfigMapNameReference) SwaggerDoc() map[string]string {
	return map_ConfigMapNameReference
}

var map_DelegatedAuthentication = map[string]string{
	"":         "DelegatedAuthentication allows authentication to be disabled.",
	"disabled": "disabled indicates that authentication should be disabled.  By default it will use delegated authentication.",
}

func (DelegatedAuthentication) SwaggerDoc() map[string]string {
	return map_DelegatedAuthentication
}

var map_DelegatedAuthorization = map[string]string{
	"":         "DelegatedAuthorization allows authorization to be disabled.",
	"disabled": "disabled indicates that authorization should be disabled.  By default it will use delegated authorization.",
}

func (DelegatedAuthorization) SwaggerDoc() map[string]string {
	return map_DelegatedAuthorization
}

var map_EtcdConnectionInfo = map[string]string{
	"":     "EtcdConnectionInfo holds information necessary for connecting to an etcd server",
	"urls": "URLs are the URLs for etcd",
	"ca":   "CA is a file containing trusted roots for the etcd server certificates",
}

func (EtcdConnectionInfo) SwaggerDoc() map[string]string {
	return map_EtcdConnectionInfo
}

var map_EtcdStorageConfig = map[string]string{
	"storagePrefix": "StoragePrefix is the path within etcd that the OpenShift resources will be rooted under. This value, if changed, will mean existing objects in etcd will no longer be located.",
}

func (EtcdStorageConfig) SwaggerDoc() map[string]string {
	return map_EtcdStorageConfig
}

var map_GenericAPIServerConfig = map[string]string{
	"":                   "GenericAPIServerConfig is an inline-able struct for aggregated apiservers that need to store data in etcd",
	"servingInfo":        "servingInfo describes how to start serving",
	"corsAllowedOrigins": "corsAllowedOrigins",
	"auditConfig":        "auditConfig describes how to configure audit information",
	"storageConfig":      "storageConfig contains information about how to use",
	"admission":          "admissionConfig holds information about how to configure admission.",
}

func (GenericAPIServerConfig) SwaggerDoc() map[string]string {
	return map_GenericAPIServerConfig
}

var map_GenericControllerConfig = map[string]string{
	"":               "GenericControllerConfig provides information to configure a controller",
	"servingInfo":    "ServingInfo is the HTTP serving information for the controller's endpoints",
	"leaderElection": "leaderElection provides information to elect a leader. Only override this if you have a specific need",
	"authentication": "authentication allows configuration of authentication for the endpoints",
	"authorization":  "authorization allows configuration of authentication for the endpoints",
}

func (GenericControllerConfig) SwaggerDoc() map[string]string {
	return map_GenericControllerConfig
}

var map_HTTPServingInfo = map[string]string{
	"":                      "HTTPServingInfo holds configuration for serving HTTP",
	"maxRequestsInFlight":   "MaxRequestsInFlight is the number of concurrent requests allowed to the server. If zero, no limit.",
	"requestTimeoutSeconds": "RequestTimeoutSeconds is the number of seconds before requests are timed out. The default is 60 minutes, if -1 there is no limit on requests.",
}

func (HTTPServingInfo) SwaggerDoc() map[string]string {
	return map_HTTPServingInfo
}

var map_KubeClientConfig = map[string]string{
	"kubeConfig":          "kubeConfig is a .kubeconfig filename for going to the owning kube-apiserver.  Empty uses an in-cluster-config",
	"connectionOverrides": "connectionOverrides specifies client overrides for system components to loop back to this master.",
}

func (KubeClientConfig) SwaggerDoc() map[string]string {
	return map_KubeClientConfig
}

var map_LeaderElection = map[string]string{
	"":              "LeaderElection provides information to elect a leader",
	"disable":       "disable allows leader election to be suspended while allowing a fully defaulted \"normal\" startup case.",
	"namespace":     "namespace indicates which namespace the resource is in",
	"name":          "name indicates what name to use for the resource",
	"leaseDuration": "leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.",
	"renewDeadline": "renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.",
	"retryPeriod":   "retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.",
}

func (LeaderElection) SwaggerDoc() map[string]string {
	return map_LeaderElection
}

var map_NamedCertificate = map[string]string{
	"":      "NamedCertificate specifies a certificate/key, and the names it should be served for",
	"names": "Names is a list of DNS names this certificate should be used to secure A name can be a normal DNS name, or can contain leading wildcard segments.",
}

func (NamedCertificate) SwaggerDoc() map[string]string {
	return map_NamedCertificate
}

var map_RemoteConnectionInfo = map[string]string{
	"":    "RemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url": "URL is the remote URL to connect to",
	"ca":  "CA is the CA for verifying TLS connections",
}

func (RemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_RemoteConnectionInfo
}

var map_SecretNameReference = map[string]string{
	"":     "SecretNameReference references a secret in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced secret",
}

func (SecretNameReference) SwaggerDoc() map[string]string {
	return map_SecretNameReference
}

var map_ServingInfo = map[string]string{
	"":                  "ServingInfo holds information about serving web pages",
	"bindAddress":       "BindAddress is the ip:port to serve on",
	"bindNetwork":       "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"clientCA":          "ClientCA is the certificate bundle for all the signers that you'll recognize for incoming client certificates",
	"namedCertificates": "NamedCertificates is a list of certificates to use to secure requests to specific hostnames",
	"minTLSVersion":     "MinTLSVersion is the minimum TLS version supported. Values must match version names from https://golang.org/pkg/crypto/tls/#pkg-constants",
	"cipherSuites":      "CipherSuites contains an overridden list of ciphers for the server to support. Values must match cipher suite IDs from https://golang.org/pkg/crypto/tls/#pkg-constants",
}

func (ServingInfo) SwaggerDoc() map[string]string {
	return map_ServingInfo
}

var map_StringSource = map[string]string{
	"": "StringSource allows specifying a string inline, or externally via env var or file. When it contains only a string value, it marshals to a simple JSON string.",
}

func (StringSource) SwaggerDoc() map[string]string {
	return map_StringSource
}

var map_StringSourceSpec = map[string]string{
	"":        "StringSourceSpec specifies a string value, or external location",
	"value":   "Value specifies the cleartext value, or an encrypted value if keyFile is specified.",
	"env":     "Env specifies an envvar containing the cleartext value, or an encrypted value if the keyFile is specified.",
	"file":    "File references a file containing the cleartext value, or an encrypted value if a keyFile is specified.",
	"keyFile": "KeyFile references a file containing the key to use to decrypt the value.",
}

func (StringSourceSpec) SwaggerDoc() map[string]string {
	return map_StringSourceSpec
}

var map_APIServer = map[string]string{
	"": "APIServer holds cluster-wide information about api-servers.  The canonical name is `cluster`",
}

func (APIServer) SwaggerDoc() map[string]string {
	return map_APIServer
}

var map_APIServerNamedServingCert = map[string]string{
	"":                   "APIServerNamedServingCert maps a server DNS name, as understood by a client, to a certificate.",
	"names":              "names is a optional list of explicit DNS names (leading wildcards allowed) that should use this certificate to serve secure traffic. If no names are provided, the implicit names will be extracted from the certificates. Exact names trump over wildcard names. Explicit names defined here trump over extracted implicit names.",
	"servingCertificate": "servingCertificate references a kubernetes.io/tls type secret containing the TLS cert info for serving secure traffic. The secret must exist in the openshift-config namespace and contain the following required fields: - Secret.Data[\"tls.key\"] - TLS private key. - Secret.Data[\"tls.crt\"] - TLS certificate.",
}

func (APIServerNamedServingCert) SwaggerDoc() map[string]string {
	return map_APIServerNamedServingCert
}

var map_APIServerServingCerts = map[string]string{
	"defaultServingCertificate": "defaultServingCertificate references a kubernetes.io/tls type secret containing the default TLS cert info for serving secure traffic. If no named certificates match the server name as understood by a client, this default certificate will be used. If defaultServingCertificate is not specified, then a operator managed certificate will be used. The secret must exist in the openshift-config namespace and contain the following required fields: - Secret.Data[\"tls.key\"] - TLS private key. - Secret.Data[\"tls.crt\"] - TLS certificate.",
	"namedCertificates":         "namedCertificates references secrets containing the TLS cert info for serving secure traffic to specific hostnames. If no named certificates are provided, or no named certificates match the server name as understood by a client, the defaultServingCertificate will be used.",
}

func (APIServerServingCerts) SwaggerDoc() map[string]string {
	return map_APIServerServingCerts
}

var map_APIServerSpec = map[string]string{
	"servingCerts": "servingCert is the TLS cert info for serving secure traffic. If not specified, operator managed certificates will be used for serving secure traffic.",
	"clientCA":     "clientCA references a ConfigMap containing a certificate bundle for the signers that will be recognized for incoming client certificates in addition to the operator managed signers. If this is empty, then only operator managed signers are valid. You usually only have to set this if you have your own PKI you wish to honor client certificates from. The ConfigMap must exist in the openshift-config namespace and contain the following required fields: - ConfigMap.Data[\"ca-bundle.crt\"] - CA bundle.",
}

func (APIServerSpec) SwaggerDoc() map[string]string {
	return map_APIServerSpec
}

var map_Authentication = map[string]string{
	"":         "Authentication holds cluster-wide information about Authentication.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Authentication) SwaggerDoc() map[string]string {
	return map_Authentication
}

var map_AuthenticationList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (AuthenticationList) SwaggerDoc() map[string]string {
	return map_AuthenticationList
}

var map_AuthenticationSpec = map[string]string{
	"type":                       "type identifies the cluster managed, user facing authentication mode in use. Specifically, it manages the component that responds to login attempts. The default is IntegratedOAuth.",
	"oauthMetadata":              "oauthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for an external OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 If oauthMetadata.name is non-empty, this value has precedence over any metadata reference stored in status. The key \"oauthMetadata\" is used to locate the data. If specified and the config map or expected key is not found, no metadata is served. If the specified metadata is not valid, no metadata is served. The namespace for this config map is openshift-config.",
	"webhookTokenAuthenticators": "webhookTokenAuthenticators configures remote token reviewers. These remote authentication webhooks can be used to verify bearer tokens via the tokenreviews.authentication.k8s.io REST API.  This is required to honor bearer tokens that are provisioned by an external authentication service. The namespace for these secrets is openshift-config.",
}

func (AuthenticationSpec) SwaggerDoc() map[string]string {
	return map_AuthenticationSpec
}

var map_AuthenticationStatus = map[string]string{
	"integratedOAuthMetadata": "integratedOAuthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for the in-cluster integrated OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 This contains the observed value based on cluster state. An explicitly set value in spec.oauthMetadata has precedence over this field. This field has no meaning if authentication spec.type is not set to IntegratedOAuth. The key \"oauthMetadata\" is used to locate the data. If the config map or expected key is not found, no metadata is served. If the specified metadata is not valid, no metadata is served. The namespace for this config map is openshift-config-managed.",
}

func (AuthenticationStatus) SwaggerDoc() map[string]string {
	return map_AuthenticationStatus
}

var map_WebhookTokenAuthenticator = map[string]string{
	"":           "webhookTokenAuthenticator holds the necessary configuration options for a remote token authenticator",
	"kubeConfig": "kubeConfig contains kube config file data which describes how to access the remote webhook service. For further details, see: https://kubernetes.io/docs/reference/access-authn-authz/authentication/#webhook-token-authentication The key \"kubeConfig\" is used to locate the data. If the secret or expected key is not found, the webhook is not honored. If the specified kube config data is not valid, the webhook is not honored. The namespace for this secret is determined by the point of use.",
}

func (WebhookTokenAuthenticator) SwaggerDoc() map[string]string {
	return map_WebhookTokenAuthenticator
}

var map_Build = map[string]string{
	"":     "Build holds cluster-wide information on how to handle builds. The canonical name is `cluster`",
	"spec": "Spec holds user-settable values for the build controller configuration",
}

func (Build) SwaggerDoc() map[string]string {
	return map_Build
}

var map_BuildDefaults = map[string]string{
	"defaultProxy": "DefaultProxy contains the default proxy settings for all build operations, including image pull/push and source download.\n\nValues can be overrode by setting the `HTTP_PROXY`, `HTTPS_PROXY`, and `NO_PROXY` environment variables in the build config's strategy.",
	"gitProxy":     "GitProxy contains the proxy settings for git operations only. If set, this will override any Proxy settings for all git commands, such as git clone.\n\nValues that are not set here will be inherited from DefaultProxy.",
	"env":          "Env is a set of default environment variables that will be applied to the build if the specified variables do not exist on the build",
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. User can override a default label by providing a label with the same name in their Build/BuildConfig.",
	"resources":    "Resources defines resource requirements to execute the build.",
}

func (BuildDefaults) SwaggerDoc() map[string]string {
	return map_BuildDefaults
}

var map_BuildList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (BuildList) SwaggerDoc() map[string]string {
	return map_BuildList
}

var map_BuildOverrides = map[string]string{
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. If user provided a label in their Build/BuildConfig with the same name as one in this list, the user's label will be overwritten.",
	"nodeSelector": "NodeSelector is a selector which must be true for the build pod to fit on a node",
	"tolerations":  "Tolerations is a list of Tolerations that will override any existing tolerations set on a build pod.",
}

func (BuildOverrides) SwaggerDoc() map[string]string {
	return map_BuildOverrides
}

var map_BuildSpec = map[string]string{
	"additionalTrustedCA": "AdditionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted for image pushes and pulls during builds. The namespace for this config map is openshift-config.",
	"buildDefaults":       "BuildDefaults controls the default information for Builds",
	"buildOverrides":      "BuildOverrides controls override settings for builds",
}

func (BuildSpec) SwaggerDoc() map[string]string {
	return map_BuildSpec
}

var map_ImageLabel = map[string]string{
	"name":  "Name defines the name of the label. It must have non-zero length.",
	"value": "Value defines the literal value of the label.",
}

func (ImageLabel) SwaggerDoc() map[string]string {
	return map_ImageLabel
}

var map_ClusterOperator = map[string]string{
	"":       "ClusterOperator is the Custom Resource object which holds the current state of an operator. This object is used by operators to convey their state to the rest of the cluster.",
	"spec":   "spec hold the intent of how this operator should behave.",
	"status": "status holds the information about the state of an operator.  It is consistent with status information across the kube ecosystem.",
}

func (ClusterOperator) SwaggerDoc() map[string]string {
	return map_ClusterOperator
}

var map_ClusterOperatorList = map[string]string{
	"": "ClusterOperatorList is a list of OperatorStatus resources.",
}

func (ClusterOperatorList) SwaggerDoc() map[string]string {
	return map_ClusterOperatorList
}

var map_ClusterOperatorSpec = map[string]string{
	"": "ClusterOperatorSpec is empty for now, but you could imagine holding information like \"pause\".",
}

func (ClusterOperatorSpec) SwaggerDoc() map[string]string {
	return map_ClusterOperatorSpec
}

var map_ClusterOperatorStatus = map[string]string{
	"":               "ClusterOperatorStatus provides information about the status of the operator.",
	"conditions":     "conditions describes the state of the operator's reconciliation functionality.",
	"versions":       "versions is a slice of operand version tuples.  Operators which manage multiple operands will have multiple entries in the array.  If an operator is Available, it must have at least one entry.  You must report the version of the operator itself with the name \"operator\".",
	"relatedObjects": "relatedObjects is a list of objects that are \"interesting\" or related to this operator.  Common uses are: 1. the detailed resource driving the operator 2. operator namespaces 3. operand namespaces",
	"extension":      "extension contains any additional status information specific to the operator which owns this status object.",
}

func (ClusterOperatorStatus) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatus
}

var map_ClusterOperatorStatusCondition = map[string]string{
	"":                   "ClusterOperatorStatusCondition represents the state of the operator's reconciliation functionality.",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are CamelCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ClusterOperatorStatusCondition) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatusCondition
}

var map_ObjectReference = map[string]string{
	"":          "ObjectReference contains enough information to let you inspect or modify the referred object.",
	"group":     "group of the referent.",
	"resource":  "resource of the referent.",
	"namespace": "namespace of the referent.",
	"name":      "name of the referent.",
}

func (ObjectReference) SwaggerDoc() map[string]string {
	return map_ObjectReference
}

var map_OperandVersion = map[string]string{
	"name":    "name is the name of the particular operand this version is for.  It usually matches container images, not operators.",
	"version": "version indicates which version of a particular operand is currently being manage.  It must always match the Available condition.  If 1.0.0 is Available, then this must indicate 1.0.0 even if the operator is trying to rollout 1.1.0",
}

func (OperandVersion) SwaggerDoc() map[string]string {
	return map_OperandVersion
}

var map_ClusterVersion = map[string]string{
	"":       "ClusterVersion is the configuration for the ClusterVersionOperator. This is where parameters related to automatic updates can be set.",
	"spec":   "spec is the desired state of the cluster version - the operator will work to ensure that the desired version is applied to the cluster.",
	"status": "status contains information about the available updates and any in-progress updates.",
}

func (ClusterVersion) SwaggerDoc() map[string]string {
	return map_ClusterVersion
}

var map_ClusterVersionList = map[string]string{
	"": "ClusterVersionList is a list of ClusterVersion resources.",
}

func (ClusterVersionList) SwaggerDoc() map[string]string {
	return map_ClusterVersionList
}

var map_ClusterVersionSpec = map[string]string{
	"":              "ClusterVersionSpec is the desired version state of the cluster. It includes the version the cluster should be at, how the cluster is identified, and where the cluster should look for version updates.",
	"clusterID":     "clusterID uniquely identifies this cluster. This is expected to be an RFC4122 UUID value (xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx in hexadecimal values). This is a required field.",
	"desiredUpdate": "desiredUpdate is an optional field that indicates the desired value of the cluster version. Setting this value will trigger an upgrade (if the current version does not match the desired version). The set of recommended update values is listed as part of available updates in status, and setting values outside that range may cause the upgrade to fail. You may specify the version field without setting image if an update exists with that version in the availableUpdates or history.\n\nIf an upgrade fails the operator will halt and report status about the failing component. Setting the desired update value back to the previous version will cause a rollback to be attempted. Not all rollbacks will succeed.",
	"upstream":      "upstream may be used to specify the preferred update server. By default it will use the appropriate update server for the cluster and region.",
	"channel":       "channel is an identifier for explicitly requesting that a non-default set of updates be applied to this cluster. The default channel will be contain stable updates that are appropriate for production clusters.",
	"overrides":     "overrides is list of overides for components that are managed by cluster version operator. Marking a component unmanaged will prevent the operator from creating or updating the object.",
}

func (ClusterVersionSpec) SwaggerDoc() map[string]string {
	return map_ClusterVersionSpec
}

var map_ClusterVersionStatus = map[string]string{
	"":                   "ClusterVersionStatus reports the status of the cluster versioning, including any upgrades that are in progress. The current field will be set to whichever version the cluster is reconciling to, and the conditions array will report whether the update succeeded, is in progress, or is failing.",
	"desired":            "desired is the version that the cluster is reconciling towards. If the cluster is not yet fully initialized desired will be set with the information available, which may be an image or a tag.",
	"history":            "history contains a list of the most recent versions applied to the cluster. This value may be empty during cluster startup, and then will be updated when a new update is being applied. The newest update is first in the list and it is ordered by recency. Updates in the history have state Completed if the rollout completed - if an update was failing or halfway applied the state will be Partial. Only a limited amount of update history is preserved.",
	"observedGeneration": "observedGeneration reports which version of the spec is being synced. If this value is not equal to metadata.generation, then the desired and conditions fields may represent from a previous version.",
	"versionHash":        "versionHash is a fingerprint of the content that the cluster will be updated with. It is used by the operator to avoid unnecessary work and is for internal use only.",
	"conditions":         "conditions provides information about the cluster version. The condition \"Available\" is set to true if the desiredUpdate has been reached. The condition \"Progressing\" is set to true if an update is being applied. The condition \"Degraded\" is set to true if an update is currently blocked by a temporary or permanent error. Conditions are only valid for the current desiredUpdate when metadata.generation is equal to status.generation.",
	"availableUpdates":   "availableUpdates contains the list of updates that are appropriate for this cluster. This list may be empty if no updates are recommended, if the update service is unavailable, or if an invalid channel has been specified.",
}

func (ClusterVersionStatus) SwaggerDoc() map[string]string {
	return map_ClusterVersionStatus
}

var map_ComponentOverride = map[string]string{
	"":          "ComponentOverride allows overriding cluster version operator's behavior for a component.",
	"kind":      "kind indentifies which object to override.",
	"group":     "group identifies the API group that the kind is in.",
	"namespace": "namespace is the component's namespace. If the resource is cluster scoped, the namespace should be empty.",
	"name":      "name is the component's name.",
	"unmanaged": "unmanaged controls if cluster version operator should stop managing the resources in this cluster. Default: false",
}

func (ComponentOverride) SwaggerDoc() map[string]string {
	return map_ComponentOverride
}

var map_Update = map[string]string{
	"":        "Update represents a release of the ClusterVersionOperator, referenced by the Image member.",
	"version": "version is a semantic versioning identifying the update version. When this field is part of spec, version is optional if image is specified.",
	"image":   "image is a container image location that contains the update. When this field is part of spec, image is optional if version is specified and the availableUpdates field contains a matching version.",
	"force":   "force allows an administrator to update to an image that has failed verification, does not appear in the availableUpdates list, or otherwise would be blocked by normal protections on update. This option should only be used when the authenticity of the provided image has been verified out of band because the provided image will run with full administrative access to the cluster. Do not use this flag with images that comes from unknown or potentially malicious sources.\n\nThis flag does not override other forms of consistency checking that are required before a new update is deployed.",
}

func (Update) SwaggerDoc() map[string]string {
	return map_Update
}

var map_UpdateHistory = map[string]string{
	"":               "UpdateHistory is a single attempted update to the cluster.",
	"state":          "state reflects whether the update was fully applied. The Partial state indicates the update is not fully applied, while the Completed state indicates the update was successfully rolled out at least once (all parts of the update successfully applied).",
	"startedTime":    "startedTime is the time at which the update was started.",
	"completionTime": "completionTime, if set, is when the update was fully applied. The update that is currently being applied will have a null completion time. Completion time will always be set for entries that are not the current update (usually to the started time of the next update).",
	"version":        "version is a semantic versioning identifying the update version. If the requested image does not define a version, or if a failure occurs retrieving the image, this value may be empty.",
	"image":          "image is a container image location that contains the update. This value is always populated.",
	"verified":       "verified indicates whether the provided update was properly verified before it was installed. If this is false the cluster may not be trusted.",
}

func (UpdateHistory) SwaggerDoc() map[string]string {
	return map_UpdateHistory
}

var map_Console = map[string]string{
	"":         "Console holds cluster-wide information about Console.  The canonical name is `cluster`.",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Console) SwaggerDoc() map[string]string {
	return map_Console
}

var map_ConsoleAuthentication = map[string]string{
	"":               "ConsoleAuthentication defines a list of optional configuration for console authentication.",
	"logoutRedirect": "An optional, absolute URL to redirect web browsers to after logging out of the console. If not specified, it will redirect to the default login page. This is required when using an identity provider that supports single sign-on (SSO) such as: - OpenID (Keycloak, Azure) - RequestHeader (GSSAPI, SSPI, SAML) - OAuth (GitHub, GitLab, Google) Logging out of the console will destroy the user's token. The logoutRedirect provides the user the option to perform single logout (SLO) through the identity provider to destroy their single sign-on session.",
}

func (ConsoleAuthentication) SwaggerDoc() map[string]string {
	return map_ConsoleAuthentication
}

var map_ConsoleList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ConsoleList) SwaggerDoc() map[string]string {
	return map_ConsoleList
}

var map_ConsoleSpec = map[string]string{
	"": "ConsoleSpec is the specification of the desired behavior of the Console.",
}

func (ConsoleSpec) SwaggerDoc() map[string]string {
	return map_ConsoleSpec
}

var map_ConsoleStatus = map[string]string{
	"":           "ConsoleStatus defines the observed status of the Console.",
	"consoleURL": "The URL for the console. This will be derived from the host for the route that is created for the console.",
}

func (ConsoleStatus) SwaggerDoc() map[string]string {
	return map_ConsoleStatus
}

var map_DNS = map[string]string{
	"":         "DNS holds cluster-wide information about DNS.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (DNS) SwaggerDoc() map[string]string {
	return map_DNS
}

var map_DNSList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (DNSList) SwaggerDoc() map[string]string {
	return map_DNSList
}

var map_DNSSpec = map[string]string{
	"baseDomain":  "baseDomain is the base domain of the cluster. All managed DNS records will be sub-domains of this base.\n\nFor example, given the base domain `openshift.example.com`, an API server DNS record may be created for `cluster-api.openshift.example.com`.",
	"publicZone":  "publicZone is the location where all the DNS records that are publicly accessible to the internet exist. If this field is nil, no public records should be created.",
	"privateZone": "privateZone is the location where all the DNS records that are only available internally to the cluster exist. If this field is nil, no private records should be created.",
}

func (DNSSpec) SwaggerDoc() map[string]string {
	return map_DNSSpec
}

var map_DNSZone = map[string]string{
	"":     "DNSZone is used to define a DNS hosted zone. A zone can be identified by an ID or tags.",
	"id":   "id is the identifier that can be used to find the DNS hosted zone.\n\non AWS zone can be fetched using `ID` as id in [1] on Azure zone can be fetched using `ID` as a pre-determined name in [2], on GCP zone can be fetched using `ID` as a pre-determined name in [3].\n\n[1]: https://docs.aws.amazon.com/cli/latest/reference/route53/get-hosted-zone.html#options [2]: https://docs.microsoft.com/en-us/cli/azure/network/dns/zone?view=azure-cli-latest#az-network-dns-zone-show [3]: https://cloud.google.com/dns/docs/reference/v1/managedZones/get",
	"tags": "tags can be used to query the DNS hosted zone.\n\non AWS, resourcegroupstaggingapi [1] can be used to fetch a zone using `Tags` as tag-filters,\n\n[1]: https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/get-resources.html#options",
}

func (DNSZone) SwaggerDoc() map[string]string {
	return map_DNSZone
}

var map_FeatureGate = map[string]string{
	"":         "Feature holds cluster-wide information about feature gates.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (FeatureGate) SwaggerDoc() map[string]string {
	return map_FeatureGate
}

var map_FeatureGateList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (FeatureGateList) SwaggerDoc() map[string]string {
	return map_FeatureGateList
}

var map_FeatureGateSpec = map[string]string{
	"featureSet": "featureSet changes the list of features in the cluster.  The default is empty.  Be very careful adjusting this setting. Turning on or off features may cause irreversible changes in your cluster which cannot be undone.",
}

func (FeatureGateSpec) SwaggerDoc() map[string]string {
	return map_FeatureGateSpec
}

var map_Image = map[string]string{
	"":         "Image holds cluster-wide information about how to handle images.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Image) SwaggerDoc() map[string]string {
	return map_Image
}

var map_ImageList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ImageList) SwaggerDoc() map[string]string {
	return map_ImageList
}

var map_ImageSpec = map[string]string{
	"allowedRegistriesForImport": "AllowedRegistriesForImport limits the container image registries that normal users may import images from. Set this list to the registries that you trust to contain valid Docker images and that you want applications to be able to import from. Users with permission to create Images or ImageStreamMappings via the API are not affected by this policy - typically only administrators or system integrations will have those permissions.",
	"externalRegistryHostnames":  "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
	"additionalTrustedCA":        "AdditionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted during imagestream import, pod image pull, and imageregistry pullthrough. The namespace for this config map is openshift-config.",
	"registrySources":            "RegistrySources contains configuration that determines how the container runtime should treat individual registries when accessing images for builds+pods. (e.g. whether or not to allow insecure access).  It does not contain configuration for the internal cluster registry.",
}

func (ImageSpec) SwaggerDoc() map[string]string {
	return map_ImageSpec
}

var map_ImageStatus = map[string]string{
	"internalRegistryHostname":  "this value is set by the image registry operator which controls the internal registry hostname InternalRegistryHostname sets the hostname for the default internal image registry. The value must be in \"hostname[:port]\" format. For backward compatibility, users can still use OPENSHIFT_DEFAULT_REGISTRY environment variable but this setting overrides the environment variable.",
	"externalRegistryHostnames": "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
}

func (ImageStatus) SwaggerDoc() map[string]string {
	return map_ImageStatus
}

var map_RegistryLocation = map[string]string{
	"":           "RegistryLocation contains a location of the registry specified by the registry domain name. The domain name might include wildcards, like '*' or '??'.",
	"domainName": "DomainName specifies a domain name for the registry In case the registry use non-standard (80 or 443) port, the port should be included in the domain name as well.",
	"insecure":   "Insecure indicates whether the registry is secure (https) or insecure (http) By default (if not specified) the registry is assumed as secure.",
}

func (RegistryLocation) SwaggerDoc() map[string]string {
	return map_RegistryLocation
}

var map_RegistrySources = map[string]string{
	"":                   "RegistrySources holds cluster-wide information about how to handle the registries config.",
	"insecureRegistries": "InsecureRegistries are registries which do not have a valid TLS certificates or only support HTTP connections.",
	"blockedRegistries":  "BlockedRegistries are blacklisted from image pull/push. All other registries are allowed.\n\nOnly one of BlockedRegistries or AllowedRegistries may be set.",
	"allowedRegistries":  "AllowedRegistries are whitelisted for image pull/push. All other registries are blocked.\n\nOnly one of BlockedRegistries or AllowedRegistries may be set.",
}

func (RegistrySources) SwaggerDoc() map[string]string {
	return map_RegistrySources
}

var map_AWSPlatformStatus = map[string]string{
	"":       "AWSPlatformStatus holds the current status of the Amazon Web Services infrastructure provider.",
	"region": "region holds the default AWS region for new AWS resources created by the cluster.",
}

func (AWSPlatformStatus) SwaggerDoc() map[string]string {
	return map_AWSPlatformStatus
}

var map_Infrastructure = map[string]string{
	"":         "Infrastructure holds cluster-wide information about Infrastructure.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Infrastructure) SwaggerDoc() map[string]string {
	return map_Infrastructure
}

var map_InfrastructureList = map[string]string{
	"":         "InfrastructureList is",
	"metadata": "Standard object's metadata.",
}

func (InfrastructureList) SwaggerDoc() map[string]string {
	return map_InfrastructureList
}

var map_InfrastructureSpec = map[string]string{
	"":            "InfrastructureSpec contains settings that apply to the cluster infrastructure.",
	"cloudConfig": "cloudConfig is a reference to a ConfigMap containing the cloud provider configuration file. This configuration file is used to configure the Kubernetes cloud provider integration when using the built-in cloud provider integration or the external cloud controller manager. The namespace for this config map is openshift-config.",
}

func (InfrastructureSpec) SwaggerDoc() map[string]string {
	return map_InfrastructureSpec
}

var map_InfrastructureStatus = map[string]string{
	"":                     "InfrastructureStatus describes the infrastructure the cluster is leveraging.",
	"infrastructureName":   "infrastructureName uniquely identifies a cluster with a human friendly name. Once set it should not be changed. Must be of max length 27 and must have only alphanumeric or hyphen characters.",
	"platform":             "platform is the underlying infrastructure provider for the cluster.\n\nDeprecated: Use platformStatus.type instead.",
	"platformStatus":       "platformStatus holds status information specific to the underlying infrastructure provider.",
	"etcdDiscoveryDomain":  "etcdDiscoveryDomain is the domain used to fetch the SRV records for discovering etcd servers and clients. For more info: https://github.com/etcd-io/etcd/blob/329be66e8b3f9e2e6af83c123ff89297e49ebd15/Documentation/op-guide/clustering.md#dns-discovery",
	"apiServerURL":         "apiServerURL is a valid URI with scheme(http/https), address and port.  apiServerURL can be used by components like the web console to tell users where to find the Kubernetes API.",
	"apiServerInternalURI": "apiServerInternalURL is a valid URI with scheme(http/https), address and port.  apiServerInternalURL can be used by components like kubelets, to contact the Kubernetes API server using the infrastructure provider rather than Kubernetes networking.",
}

func (InfrastructureStatus) SwaggerDoc() map[string]string {
	return map_InfrastructureStatus
}

var map_PlatformStatus = map[string]string{
	"":     "PlatformStatus holds the current status specific to the underlying infrastructure provider of the current cluster. Since these are used at status-level for the underlying cluster, it is supposed that only one of the status structs is set.",
	"type": "type is the underlying infrastructure provider for the cluster. This value controls whether infrastructure automation such as service load balancers, dynamic volume provisioning, machine creation and deletion, and other integrations are enabled. If None, no infrastructure automation is enabled. Allowed values are \"AWS\", \"Azure\", \"BareMetal\", \"GCP\", \"Libvirt\", \"OpenStack\", \"VSphere\", and \"None\". Individual components may not support all platforms, and must handle unrecognized platforms as None if they do not support that platform.",
	"aws":  "AWS contains settings specific to the Amazon Web Services infrastructure provider.",
}

func (PlatformStatus) SwaggerDoc() map[string]string {
	return map_PlatformStatus
}

var map_Ingress = map[string]string{
	"":         "Ingress holds cluster-wide information about Ingress.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Ingress) SwaggerDoc() map[string]string {
	return map_Ingress
}

var map_IngressList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (IngressList) SwaggerDoc() map[string]string {
	return map_IngressList
}

var map_IngressSpec = map[string]string{
	"domain": "domain is used to generate a default host name for a route when the route's host name is empty.  The generated host name will follow this pattern: \"<route-name>.<route-namespace>.<domain>\".",
}

func (IngressSpec) SwaggerDoc() map[string]string {
	return map_IngressSpec
}

var map_ClusterNetworkEntry = map[string]string{
	"":           "ClusterNetworkEntry is a contiguous block of IP addresses from which pod IPs are allocated.",
	"cidr":       "The complete block for pod IPs.",
	"hostPrefix": "The size (prefix) of block to allocate to each node.",
}

func (ClusterNetworkEntry) SwaggerDoc() map[string]string {
	return map_ClusterNetworkEntry
}

var map_ExternalIPConfig = map[string]string{
	"":                "ExternalIPConfig specifies some IP blocks relevant for the ExternalIP field of a Service resource.",
	"policy":          "policy is a set of restrictions applied to the ExternalIP field. If nil, any value is allowed for an ExternalIP. If the empty/zero policy is supplied, then ExternalIP is not allowed to be set.",
	"autoAssignCIDRs": "autoAssignCIDRs is a list of CIDRs from which to automatically assign Service.ExternalIP. These are assigned when the service is of type LoadBalancer. In general, this is only useful for bare-metal clusters. In Openshift 3.x, this was misleadingly called \"IngressIPs\". Automatically assigned External IPs are not affected by any ExternalIPPolicy rules. Currently, only one entry may be provided.",
}

func (ExternalIPConfig) SwaggerDoc() map[string]string {
	return map_ExternalIPConfig
}

var map_ExternalIPPolicy = map[string]string{
	"":              "ExternalIPPolicy configures exactly which IPs are allowed for the ExternalIP field in a Service. If the zero struct is supplied, then none are permitted. The policy controller always allows automatically assigned external IPs.",
	"allowedCIDRs":  "allowedCIDRs is the list of allowed CIDRs.",
	"rejectedCIDRs": "rejectedCIDRs is the list of disallowed CIDRs. These take precedence over allowedCIDRs.",
}

func (ExternalIPPolicy) SwaggerDoc() map[string]string {
	return map_ExternalIPPolicy
}

var map_Network = map[string]string{
	"":         "Network holds cluster-wide information about Network.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration.",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Network) SwaggerDoc() map[string]string {
	return map_Network
}

var map_NetworkList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (NetworkList) SwaggerDoc() map[string]string {
	return map_NetworkList
}

var map_NetworkSpec = map[string]string{
	"":               "NetworkSpec is the desired network configuration. As a general rule, this SHOULD NOT be read directly. Instead, you should consume the NetworkStatus, as it indicates the currently deployed configuration. Currently, changing ClusterNetwork, ServiceNetwork, or NetworkType after installation is not supported.",
	"clusterNetwork": "IP address pool to use for pod IPs.",
	"serviceNetwork": "IP address pool for services. Currently, we only support a single entry here.",
	"networkType":    "NetworkType is the plugin that is to be deployed (e.g. OpenShiftSDN). This should match a value that the cluster-network-operator understands, or else no networking will be installed. Currently supported values are: - OpenShiftSDN",
	"externalIP":     "externalIP defines configuration for controllers that affect Service.ExternalIP",
}

func (NetworkSpec) SwaggerDoc() map[string]string {
	return map_NetworkSpec
}

var map_NetworkStatus = map[string]string{
	"":                  "NetworkStatus is the current network configuration.",
	"clusterNetwork":    "IP address pool to use for pod IPs.",
	"serviceNetwork":    "IP address pool for services. Currently, we only support a single entry here.",
	"networkType":       "NetworkType is the plugin that is deployed (e.g. OpenShiftSDN).",
	"clusterNetworkMTU": "ClusterNetworkMTU is the MTU for inter-pod networking.",
}

func (NetworkStatus) SwaggerDoc() map[string]string {
	return map_NetworkStatus
}

var map_BasicAuthIdentityProvider = map[string]string{
	"": "BasicAuthPasswordIdentityProvider provides identities for users authenticating using HTTP basic auth credentials",
}

func (BasicAuthIdentityProvider) SwaggerDoc() map[string]string {
	return map_BasicAuthIdentityProvider
}

var map_GitHubIdentityProvider = map[string]string{
	"":              "GitHubIdentityProvider provides identities for users authenticating using GitHub credentials",
	"clientID":      "clientID is the oauth client ID",
	"clientSecret":  "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"organizations": "organizations optionally restricts which organizations are allowed to log in",
	"teams":         "teams optionally restricts which teams are allowed to log in. Format is <org>/<team>.",
	"hostname":      "hostname is the optional domain (e.g. \"mycompany.com\") for use with a hosted instance of GitHub Enterprise. It must match the GitHub Enterprise settings value configured at /setup/settings#hostname.",
	"ca":            "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. This can only be configured when hostname is set to a non-empty value. The namespace for this config map is openshift-config.",
}

func (GitHubIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitHubIdentityProvider
}

var map_GitLabIdentityProvider = map[string]string{
	"":             "GitLabIdentityProvider provides identities for users authenticating using GitLab credentials",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"url":          "url is the oauth server base URL",
	"ca":           "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
}

func (GitLabIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitLabIdentityProvider
}

var map_GoogleIdentityProvider = map[string]string{
	"":             "GoogleIdentityProvider provides identities for users authenticating using Google credentials",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"hostedDomain": "hostedDomain is the optional Google App domain (e.g. \"mycompany.com\") to restrict logins to",
}

func (GoogleIdentityProvider) SwaggerDoc() map[string]string {
	return map_GoogleIdentityProvider
}

var map_HTPasswdIdentityProvider = map[string]string{
	"":         "HTPasswdPasswordIdentityProvider provides identities for users authenticating using htpasswd credentials",
	"fileData": "fileData is a required reference to a secret by name containing the data to use as the htpasswd file. The key \"htpasswd\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. If the specified htpasswd data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
}

func (HTPasswdIdentityProvider) SwaggerDoc() map[string]string {
	return map_HTPasswdIdentityProvider
}

var map_IdentityProvider = map[string]string{
	"":              "IdentityProvider provides identities for users authenticating using credentials",
	"name":          "name is used to qualify the identities returned by this provider. - It MUST be unique and not shared by any other identity provider used - It MUST be a valid path segment: name cannot equal \".\" or \"..\" or contain \"/\" or \"%\" or \":\"\n  Ref: https://godoc.org/github.com/openshift/origin/pkg/user/apis/user/validation#ValidateIdentityProviderName",
	"mappingMethod": "mappingMethod determines how identities from this provider are mapped to users Defaults to \"claim\"",
}

func (IdentityProvider) SwaggerDoc() map[string]string {
	return map_IdentityProvider
}

var map_IdentityProviderConfig = map[string]string{
	"":              "IdentityProviderConfig contains configuration for using a specific identity provider",
	"type":          "type identifies the identity provider type for this entry.",
	"basicAuth":     "basicAuth contains configuration options for the BasicAuth IdP",
	"github":        "github enables user authentication using GitHub credentials",
	"gitlab":        "gitlab enables user authentication using GitLab credentials",
	"google":        "google enables user authentication using Google credentials",
	"htpasswd":      "htpasswd enables user authentication using an HTPasswd file to validate credentials",
	"keystone":      "keystone enables user authentication using keystone password credentials",
	"ldap":          "ldap enables user authentication using LDAP credentials",
	"openID":        "openID enables user authentication using OpenID credentials",
	"requestHeader": "requestHeader enables user authentication using request header credentials",
}

func (IdentityProviderConfig) SwaggerDoc() map[string]string {
	return map_IdentityProviderConfig
}

var map_KeystoneIdentityProvider = map[string]string{
	"":           "KeystonePasswordIdentityProvider provides identities for users authenticating using keystone password credentials",
	"domainName": "domainName is required for keystone v3",
}

func (KeystoneIdentityProvider) SwaggerDoc() map[string]string {
	return map_KeystoneIdentityProvider
}

var map_LDAPAttributeMapping = map[string]string{
	"":                  "LDAPAttributeMapping maps LDAP attributes to OpenShift identity fields",
	"id":                "id is the list of attributes whose values should be used as the user ID. Required. First non-empty attribute is used. At least one attribute is required. If none of the listed attribute have a value, authentication fails. LDAP standard identity attribute is \"dn\"",
	"preferredUsername": "preferredUsername is the list of attributes whose values should be used as the preferred username. LDAP standard login attribute is \"uid\"",
	"name":              "name is the list of attributes whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity LDAP standard display name attribute is \"cn\"",
	"email":             "email is the list of attributes whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (LDAPAttributeMapping) SwaggerDoc() map[string]string {
	return map_LDAPAttributeMapping
}

var map_LDAPIdentityProvider = map[string]string{
	"":             "LDAPPasswordIdentityProvider provides identities for users authenticating using LDAP credentials",
	"url":          "url is an RFC 2255 URL which specifies the LDAP search parameters to use. The syntax of the URL is: ldap://host:port/basedn?attribute?scope?filter",
	"bindDN":       "bindDN is an optional DN to bind with during the search phase.",
	"bindPassword": "bindPassword is an optional reference to a secret by name containing a password to bind with during the search phase. The key \"bindPassword\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"insecure":     "insecure, if true, indicates the connection should not use TLS WARNING: Should not be set to `true` with the URL scheme \"ldaps://\" as \"ldaps://\" URLs always\n         attempt to connect using TLS, even when `insecure` is set to `true`\nWhen `true`, \"ldap://\" URLS connect insecurely. When `false`, \"ldap://\" URLs are upgraded to a TLS connection using StartTLS as specified in https://tools.ietf.org/html/rfc2830.",
	"ca":           "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"attributes":   "attributes maps LDAP attributes to identities",
}

func (LDAPIdentityProvider) SwaggerDoc() map[string]string {
	return map_LDAPIdentityProvider
}

var map_OAuth = map[string]string{
	"": "OAuth holds cluster-wide information about OAuth.  The canonical name is `cluster`. It is used to configure the integrated OAuth server. This configuration is only honored when the top level Authentication config has type set to IntegratedOAuth.",
}

func (OAuth) SwaggerDoc() map[string]string {
	return map_OAuth
}

var map_OAuthRemoteConnectionInfo = map[string]string{
	"":              "OAuthRemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url":           "url is the remote URL to connect to",
	"ca":            "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"tlsClientCert": "tlsClientCert is an optional reference to a secret by name that contains the PEM-encoded TLS client certificate to present when connecting to the server. The key \"tls.crt\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. If the specified certificate data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"tlsClientKey":  "tlsClientKey is an optional reference to a secret by name that contains the PEM-encoded TLS private key for the client certificate referenced in tlsClientCert. The key \"tls.key\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. If the specified certificate data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
}

func (OAuthRemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_OAuthRemoteConnectionInfo
}

var map_OAuthSpec = map[string]string{
	"":                  "OAuthSpec contains desired cluster auth configuration",
	"identityProviders": "identityProviders is an ordered list of ways for a user to identify themselves. When this list is empty, no identities are provisioned for users.",
	"tokenConfig":       "tokenConfig contains options for authorization and access tokens",
	"templates":         "templates allow you to customize pages like the login page.",
}

func (OAuthSpec) SwaggerDoc() map[string]string {
	return map_OAuthSpec
}

var map_OAuthStatus = map[string]string{
	"": "OAuthStatus shows current known state of OAuth server in the cluster",
}

func (OAuthStatus) SwaggerDoc() map[string]string {
	return map_OAuthStatus
}

var map_OAuthTemplates = map[string]string{
	"":                  "OAuthTemplates allow for customization of pages like the login page",
	"login":             "login is the name of a secret that specifies a go template to use to render the login page. The key \"login.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default login page is used. If the specified template is not valid, the default login page is used. If unspecified, the default login page is used. The namespace for this secret is openshift-config.",
	"providerSelection": "providerSelection is the name of a secret that specifies a go template to use to render the provider selection page. The key \"providers.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default provider selection page is used. If the specified template is not valid, the default provider selection page is used. If unspecified, the default provider selection page is used. The namespace for this secret is openshift-config.",
	"error":             "error is the name of a secret that specifies a go template to use to render error pages during the authentication or grant flow. The key \"errors.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default error page is used. If the specified template is not valid, the default error page is used. If unspecified, the default error page is used. The namespace for this secret is openshift-config.",
}

func (OAuthTemplates) SwaggerDoc() map[string]string {
	return map_OAuthTemplates
}

var map_OpenIDClaims = map[string]string{
	"":                  "OpenIDClaims contains a list of OpenID claims to use when authenticating with an OpenID identity provider",
	"preferredUsername": "preferredUsername is the list of claims whose values should be used as the preferred username. If unspecified, the preferred username is determined from the value of the sub claim",
	"name":              "name is the list of claims whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity",
	"email":             "email is the list of claims whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (OpenIDClaims) SwaggerDoc() map[string]string {
	return map_OpenIDClaims
}

var map_OpenIDIdentityProvider = map[string]string{
	"":                         "OpenIDIdentityProvider provides identities for users authenticating using OpenID credentials",
	"clientID":                 "clientID is the oauth client ID",
	"clientSecret":             "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"ca":                       "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"extraScopes":              "extraScopes are any scopes to request in addition to the standard \"openid\" scope.",
	"extraAuthorizeParameters": "extraAuthorizeParameters are any custom parameters to add to the authorize request.",
	"issuer":                   "issuer is the URL that the OpenID Provider asserts as its Issuer Identifier. It must use the https scheme with no query or fragment component.",
	"claims":                   "claims mappings",
}

func (OpenIDIdentityProvider) SwaggerDoc() map[string]string {
	return map_OpenIDIdentityProvider
}

var map_RequestHeaderIdentityProvider = map[string]string{
	"":                         "RequestHeaderIdentityProvider provides identities for users authenticating using request header credentials",
	"loginURL":                 "loginURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect interactive logins will be redirected here ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when login is set to true.",
	"challengeURL":             "challengeURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect WWW-Authenticate challenges will be redirected here. ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when challenge is set to true.",
	"ca":                       "ca is a required reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. Specifically, it allows verification of incoming requests to prevent header spoofing. The key \"ca.crt\" is used to locate the data. If the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. The namespace for this config map is openshift-config.",
	"clientCommonNames":        "clientCommonNames is an optional list of common names to require a match from. If empty, any client certificate validated against the clientCA bundle is considered authoritative.",
	"headers":                  "headers is the set of headers to check for identity information",
	"preferredUsernameHeaders": "preferredUsernameHeaders is the set of headers to check for the preferred username",
	"nameHeaders":              "nameHeaders is the set of headers to check for the display name",
	"emailHeaders":             "emailHeaders is the set of headers to check for the email address",
}

func (RequestHeaderIdentityProvider) SwaggerDoc() map[string]string {
	return map_RequestHeaderIdentityProvider
}

var map_TokenConfig = map[string]string{
	"":                                    "TokenConfig holds the necessary configuration options for authorization and access tokens",
	"accessTokenMaxAgeSeconds":            "accessTokenMaxAgeSeconds defines the maximum age of access tokens",
	"accessTokenInactivityTimeoutSeconds": "accessTokenInactivityTimeoutSeconds defines the default token inactivity timeout for tokens granted by any client. The value represents the maximum amount of time that can occur between consecutive uses of the token. Tokens become invalid if they are not used within this temporal window. The user will need to acquire a new token to regain access once a token times out. Valid values are integer values:\n  x < 0  Tokens time out is enabled but tokens never timeout unless configured per client (e.g. `-1`)\n  x = 0  Tokens time out is disabled (default)\n  x > 0  Tokens time out if there is no activity for x seconds\nThe current minimum allowed value for X is 300 (5 minutes)",
}

func (TokenConfig) SwaggerDoc() map[string]string {
	return map_TokenConfig
}

var map_Project = map[string]string{
	"":         "Project holds cluster-wide information about Project.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Project) SwaggerDoc() map[string]string {
	return map_Project
}

var map_ProjectList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ProjectList) SwaggerDoc() map[string]string {
	return map_ProjectList
}

var map_ProjectSpec = map[string]string{
	"":                       "ProjectSpec holds the project creation configuration.",
	"projectRequestMessage":  "projectRequestMessage is the string presented to a user if they are unable to request a project via the projectrequest api endpoint",
	"projectRequestTemplate": "projectRequestTemplate is the template to use for creating projects in response to projectrequest. This must point to a template in 'openshift-config' namespace. It is optional. If it is not specified, a default template is used.",
}

func (ProjectSpec) SwaggerDoc() map[string]string {
	return map_ProjectSpec
}

var map_TemplateReference = map[string]string{
	"":     "TemplateReference references a template in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced project request template",
}

func (TemplateReference) SwaggerDoc() map[string]string {
	return map_TemplateReference
}

var map_Proxy = map[string]string{
	"":       "Proxy holds cluster-wide information on how to configure default proxies for the cluster. The canonical name is `cluster`",
	"spec":   "Spec holds user-settable values for the proxy configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (Proxy) SwaggerDoc() map[string]string {
	return map_Proxy
}

var map_ProxyList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (ProxyList) SwaggerDoc() map[string]string {
	return map_ProxyList
}

var map_ProxySpec = map[string]string{
	"":           "ProxySpec contains cluster proxy creation configuration.",
	"httpProxy":  "httpProxy is the URL of the proxy for HTTP requests.  Empty means unset and will not result in an env var.",
	"httpsProxy": "httpsProxy is the URL of the proxy for HTTPS requests.  Empty means unset and will not result in an env var.",
	"noProxy":    "noProxy is a comma-separated list of hostnames and/or CIDRs for which the proxy should not be used. Empty means unset and will not result in an env var.",
}

func (ProxySpec) SwaggerDoc() map[string]string {
	return map_ProxySpec
}

var map_ProxyStatus = map[string]string{
	"":           "ProxyStatus shows current known state of the cluster proxy.",
	"httpProxy":  "httpProxy is the URL of the proxy for HTTP requests.",
	"httpsProxy": "httpsProxy is the URL of the proxy for HTTPS requests.",
	"noProxy":    "noProxy is a comma-separated list of hostnames and/or CIDRs for which the proxy should not be used.",
}

func (ProxyStatus) SwaggerDoc() map[string]string {
	return map_ProxyStatus
}

var map_Scheduler = map[string]string{
	"":         "Scheduler holds cluster-wide information about Scheduler.  The canonical name is `cluster`",
	"metadata": "Standard object's metadata.",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Scheduler) SwaggerDoc() map[string]string {
	return map_Scheduler
}

var map_SchedulerList = map[string]string{
	"metadata": "Standard object's metadata.",
}

func (SchedulerList) SwaggerDoc() map[string]string {
	return map_SchedulerList
}

var map_SchedulerSpec = map[string]string{
	"policy":              "policy is a reference to a ConfigMap containing scheduler policy which has user specified predicates and priorities. If this ConfigMap is not available scheduler will default to use DefaultAlgorithmProvider. The namespace for this configmap is openshift-config.",
	"defaultNodeSelector": "defaultNodeSelector helps set the cluster-wide default node selector to restrict pod placement to specific nodes. This is applied to the pods created in all namespaces without a specified nodeSelector value. For example, defaultNodeSelector: \"type=user-node,region=east\" would set nodeSelector field in pod spec to \"type=user-node,region=east\" to all pods created in all namespaces. Namespaces having project-wide node selectors won't be impacted even if this field is set. This adds an annotation section to the namespace. For example, if a new namespace is created with node-selector='type=user-node,region=east', the annotation openshift.io/node-selector: type=user-node,region=east gets added to the project. When the openshift.io/node-selector annotation is set on the project the value is used in preference to the value we are setting for defaultNodeSelector field. For instance, openshift.io/node-selector: \"type=user-node,region=west\" means that the default of \"type=user-node,region=east\" set in defaultNodeSelector would not be applied.",
}

func (SchedulerSpec) SwaggerDoc() map[string]string {
	return map_SchedulerSpec
}

// AUTO-GENERATED FUNCTIONS END HERE
