// +build !ignore_autogenerated

/*
Copyright2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by helpgen. DO NOT EDIT.

package webhook

import (
	"sigs.k8s.io/controller-tools/pkg/markers"
)

func (Config) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "Webhook",
		DetailedHelp: markers.DetailedHelp{
			Summary: "specifies how a webhook should be served. ",
			Details: " It specifies only the details that are intrinsic to the application serving it (e.g. the resources it can handle, or the path it serves on).",
		},
		FieldHelp: map[string]markers.DetailedHelp{
			"Mutating": markers.DetailedHelp{
				Summary: "marks this as a mutating webhook (it's validating only if false) ",
				Details: " Mutating webhooks are allowed to change the object in their response, and are called *after* all validating webhooks.  Mutating webhooks may choose to reject an object, similarly to a validating webhook.",
			},
			"FailurePolicy": markers.DetailedHelp{
				Summary: "specifies what should happen if the API server cannot reach the webhook. ",
				Details: " It may be either \"ignore\" (to skip the webhook and continue on) or \"fail\" (to reject the object in question).",
			},
			"Groups": markers.DetailedHelp{
				Summary: "specifies the API groups that this webhook receives requests for.",
				Details: "",
			},
			"Resources": markers.DetailedHelp{
				Summary: "specifies the API resources that this webhook receives requests for.",
				Details: "",
			},
			"Verbs": markers.DetailedHelp{
				Summary: "specifies the Kubernetes API verbs that this webhook receives requests for. ",
				Details: " Only modification-like verbs may be specified. May be \"create\", \"update\", \"delete\", \"connect\", or \"*\" (for all).",
			},
			"Versions": markers.DetailedHelp{
				Summary: "specifies the API versions that this webhook receives requests for.",
				Details: "",
			},
			"Name": markers.DetailedHelp{
				Summary: "indicates the name of this webhook configuration.",
				Details: "",
			},
			"Path": markers.DetailedHelp{
				Summary: "specifies that path that the API server should connect to this webhook on.",
				Details: "",
			},
		},
	}
}

func (Generator) Help() *markers.DefinitionHelp {
	return &markers.DefinitionHelp{
		Category: "",
		DetailedHelp: markers.DetailedHelp{
			Summary: "generates (partial) {Mutating,Validating}WebhookConfiguration objects.",
			Details: "",
		},
		FieldHelp: map[string]markers.DetailedHelp{},
	}
}
