// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/ad_group.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An ad group.
type AdGroup struct {
	// The resource name of the ad group.
	// Ad group resource names have the form:
	//
	// `customers/{customer_id}/adGroups/{ad_group_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the ad group.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the ad group.
	//
	// This field is required and should not be empty when creating new ad
	// groups.
	//
	// It must contain fewer than 255 UTF-8 full-width characters.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the ad group.
	Status enums.AdGroupStatusEnum_AdGroupStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.AdGroupStatusEnum_AdGroupStatus" json:"status,omitempty"`
	// The type of the ad group.
	Type enums.AdGroupTypeEnum_AdGroupType `protobuf:"varint,12,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.AdGroupTypeEnum_AdGroupType" json:"type,omitempty"`
	// The ad rotation mode of the ad group.
	AdRotationMode enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode `protobuf:"varint,22,opt,name=ad_rotation_mode,json=adRotationMode,proto3,enum=google.ads.googleads.v0.enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode" json:"ad_rotation_mode,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,6,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The campaign to which the ad group belongs.
	Campaign *wrappers.StringValue `protobuf:"bytes,10,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The maximum CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,14,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The maximum CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The target CPA (cost-per-acquisition).
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,27,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// Average amount in micros that the advertiser is willing to pay for every
	// thousand times the ad is shown.
	TargetCpmMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=target_cpm_micros,json=targetCpmMicros,proto3" json:"target_cpm_micros,omitempty"`
	// The target ROAS (return-on-ad-spend) override. If the ad group's campaign
	// bidding strategy is a standard Target ROAS strategy, then this field
	// overrides the target ROAS specified in the campaign's bidding strategy.
	// Otherwise, this value is ignored.
	TargetRoas *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=target_roas,json=targetRoas,proto3" json:"target_roas,omitempty"`
	// The percent cpc bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Settings for the Display Campaign Optimizer, initially termed "Explorer".
	ExplorerAutoOptimizerSetting *common.ExplorerAutoOptimizerSetting `protobuf:"bytes,21,opt,name=explorer_auto_optimizer_setting,json=explorerAutoOptimizerSetting,proto3" json:"explorer_auto_optimizer_setting,omitempty"`
	// Allows advertisers to specify a targeting dimension on which to place
	// absolute bids. This is only applicable for campaigns that target only the
	// display network and not search.
	DisplayCustomBidDimension enums.TargetingDimensionEnum_TargetingDimension `protobuf:"varint,23,opt,name=display_custom_bid_dimension,json=displayCustomBidDimension,proto3,enum=google.ads.googleads.v0.enums.TargetingDimensionEnum_TargetingDimension" json:"display_custom_bid_dimension,omitempty"`
	// URL template for appending params to Final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,24,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,25,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// The effective target CPA (cost-per-acquisition).
	// This field is read-only.
	EffectiveTargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,28,opt,name=effective_target_cpa_micros,json=effectiveTargetCpaMicros,proto3" json:"effective_target_cpa_micros,omitempty"`
	// Source of the effective target CPA.
	// This field is read-only.
	EffectiveTargetCpaSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,29,opt,name=effective_target_cpa_source,json=effectiveTargetCpaSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_target_cpa_source,omitempty"`
	// The effective target ROAS (return-on-ad-spend).
	// This field is read-only.
	EffectiveTargetRoas *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=effective_target_roas,json=effectiveTargetRoas,proto3" json:"effective_target_roas,omitempty"`
	// Source of the effective target ROAS.
	// This field is read-only.
	EffectiveTargetRoasSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,32,opt,name=effective_target_roas_source,json=effectiveTargetRoasSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_target_roas_source,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                              `json:"-"`
	XXX_unrecognized          []byte                                `json:"-"`
	XXX_sizecache             int32                                 `json:"-"`
}

func (m *AdGroup) Reset()         { *m = AdGroup{} }
func (m *AdGroup) String() string { return proto.CompactTextString(m) }
func (*AdGroup) ProtoMessage()    {}
func (*AdGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_772133f79f9a8455, []int{0}
}
func (m *AdGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroup.Unmarshal(m, b)
}
func (m *AdGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroup.Marshal(b, m, deterministic)
}
func (dst *AdGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroup.Merge(dst, src)
}
func (m *AdGroup) XXX_Size() int {
	return xxx_messageInfo_AdGroup.Size(m)
}
func (m *AdGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroup.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroup proto.InternalMessageInfo

func (m *AdGroup) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroup) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *AdGroup) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *AdGroup) GetStatus() enums.AdGroupStatusEnum_AdGroupStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupStatusEnum_UNSPECIFIED
}

func (m *AdGroup) GetType() enums.AdGroupTypeEnum_AdGroupType {
	if m != nil {
		return m.Type
	}
	return enums.AdGroupTypeEnum_UNSPECIFIED
}

func (m *AdGroup) GetAdRotationMode() enums.AdGroupAdRotationModeEnum_AdGroupAdRotationMode {
	if m != nil {
		return m.AdRotationMode
	}
	return enums.AdGroupAdRotationModeEnum_UNSPECIFIED
}

func (m *AdGroup) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroup) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *AdGroup) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *AdGroup) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroup) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *AdGroup) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroup) GetTargetCpmMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpmMicros
	}
	return nil
}

func (m *AdGroup) GetTargetRoas() *wrappers.DoubleValue {
	if m != nil {
		return m.TargetRoas
	}
	return nil
}

func (m *AdGroup) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroup) GetExplorerAutoOptimizerSetting() *common.ExplorerAutoOptimizerSetting {
	if m != nil {
		return m.ExplorerAutoOptimizerSetting
	}
	return nil
}

func (m *AdGroup) GetDisplayCustomBidDimension() enums.TargetingDimensionEnum_TargetingDimension {
	if m != nil {
		return m.DisplayCustomBidDimension
	}
	return enums.TargetingDimensionEnum_UNSPECIFIED
}

func (m *AdGroup) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroup) GetTargetingSetting() *common.TargetingSetting {
	if m != nil {
		return m.TargetingSetting
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveTargetCpaMicros
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetCpaSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveTargetCpaSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroup) GetEffectiveTargetRoas() *wrappers.DoubleValue {
	if m != nil {
		return m.EffectiveTargetRoas
	}
	return nil
}

func (m *AdGroup) GetEffectiveTargetRoasSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveTargetRoasSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*AdGroup)(nil), "google.ads.googleads.v0.resources.AdGroup")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/ad_group.proto", fileDescriptor_ad_group_772133f79f9a8455)
}

var fileDescriptor_ad_group_772133f79f9a8455 = []byte{
	// 941 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0x4f, 0x6f, 0xe3, 0x44,
	0x18, 0xc6, 0x95, 0xb6, 0x14, 0x98, 0x76, 0xd3, 0xae, 0x4b, 0x17, 0xb7, 0x0d, 0xbb, 0x59, 0xd0,
	0x4a, 0x95, 0x90, 0x9c, 0xd0, 0x85, 0x05, 0x05, 0x16, 0xc9, 0x69, 0x97, 0x02, 0xd2, 0x96, 0xc8,
	0xe9, 0xe6, 0xb0, 0x2a, 0xb2, 0x26, 0x9e, 0x89, 0x35, 0xc2, 0xe3, 0xb1, 0x66, 0xc6, 0xa1, 0x45,
	0x42, 0x1c, 0x38, 0xf1, 0x35, 0x38, 0xf2, 0x51, 0xf8, 0x28, 0x5c, 0x39, 0x71, 0x43, 0x9e, 0x3f,
	0x6e, 0x92, 0x36, 0xb5, 0x91, 0xb8, 0xd9, 0x33, 0xef, 0xf3, 0x9b, 0xf7, 0x9d, 0x79, 0x1f, 0x8f,
	0x41, 0x37, 0x66, 0x2c, 0x4e, 0x70, 0x07, 0x22, 0xd1, 0xd1, 0x8f, 0xc5, 0xd3, 0xb4, 0xdb, 0xe1,
	0x58, 0xb0, 0x9c, 0x47, 0x58, 0x74, 0x20, 0x0a, 0x63, 0xce, 0xf2, 0xcc, 0xcb, 0x38, 0x93, 0xcc,
	0x79, 0xac, 0xc3, 0x3c, 0x88, 0x84, 0x57, 0x2a, 0xbc, 0x69, 0xd7, 0x2b, 0x15, 0xfb, 0x9f, 0x2c,
	0x83, 0x46, 0x8c, 0x52, 0x96, 0x76, 0xa2, 0x5c, 0x48, 0x46, 0xc3, 0x0c, 0x72, 0x48, 0xb1, 0xc4,
	0x5c, 0x93, 0xf7, 0x4f, 0x2a, 0x64, 0xf8, 0x32, 0x4b, 0x18, 0xc7, 0x3c, 0x84, 0xb9, 0x64, 0x21,
	0xcb, 0x24, 0xa1, 0xe4, 0x27, 0xcc, 0x43, 0x81, 0xa5, 0x24, 0x69, 0x6c, 0x28, 0xcf, 0x2a, 0x28,
	0x12, 0xf2, 0x18, 0x17, 0xf1, 0x0b, 0xba, 0xe7, 0xcb, 0x74, 0x38, 0xcd, 0xe9, 0xf5, 0x2e, 0x84,
	0x10, 0x85, 0x9c, 0x49, 0x28, 0x09, 0x4b, 0x43, 0xca, 0x10, 0x36, 0xf2, 0xa7, 0x35, 0xe5, 0x42,
	0x42, 0x99, 0x0b, 0x23, 0xfa, 0xa8, 0xa6, 0x48, 0x5e, 0x65, 0x76, 0x9d, 0xa3, 0xbb, 0x25, 0x63,
	0x82, 0x90, 0xaa, 0x4d, 0x1d, 0x85, 0xd1, 0x7c, 0x7a, 0xb7, 0xe6, 0x7a, 0x47, 0x10, 0xa1, 0x38,
	0x15, 0x84, 0xa5, 0x46, 0xf8, 0xd0, 0x08, 0xd5, 0xdb, 0x38, 0x9f, 0x74, 0x7e, 0xe4, 0x30, 0xcb,
	0x30, 0x37, 0xf9, 0xbf, 0xff, 0xf7, 0x16, 0x78, 0xd3, 0x47, 0xa7, 0x45, 0x8e, 0xce, 0x07, 0xe0,
	0x9e, 0xed, 0x80, 0x30, 0x85, 0x14, 0xbb, 0x8d, 0x76, 0xe3, 0xf0, 0xed, 0x60, 0xd3, 0x0e, 0x9e,
	0x41, 0x8a, 0x9d, 0x0f, 0xc1, 0x0a, 0x41, 0xee, 0x6a, 0xbb, 0x71, 0xb8, 0x71, 0x74, 0x60, 0xda,
	0xc7, 0xb3, 0x74, 0xef, 0x9b, 0x54, 0x3e, 0xfb, 0x78, 0x04, 0x93, 0x1c, 0x07, 0x2b, 0x04, 0x39,
	0x5d, 0xb0, 0xa6, 0x40, 0x6b, 0x2a, 0xbc, 0x75, 0x23, 0x7c, 0x28, 0x39, 0x49, 0x63, 0x1d, 0xaf,
	0x22, 0x9d, 0x11, 0x58, 0xd7, 0xfb, 0xeb, 0xbe, 0xd1, 0x6e, 0x1c, 0x36, 0x8f, 0xbe, 0xf4, 0x96,
	0x35, 0xab, 0xaa, 0xdc, 0x33, 0xb9, 0x0f, 0x95, 0xe6, 0x45, 0x9a, 0xd3, 0xf9, 0x91, 0xc0, 0xd0,
	0x9c, 0x33, 0xb0, 0x56, 0x1c, 0x81, 0xbb, 0xa9, 0xa8, 0xbd, 0x7a, 0xd4, 0xf3, 0xab, 0x0c, 0xcf,
	0x32, 0x8b, 0xf7, 0x40, 0x71, 0x9c, 0x4b, 0xb0, 0xbd, 0xd8, 0x46, 0xee, 0x03, 0xc5, 0x3e, 0xab,
	0xc7, 0xf6, 0x51, 0x60, 0xc4, 0x2f, 0x19, 0x9a, 0x5b, 0x65, 0x7e, 0x26, 0x68, 0xc2, 0xb9, 0x77,
	0x67, 0x00, 0x76, 0x25, 0x87, 0xd1, 0x0f, 0xc5, 0x69, 0xe7, 0x3c, 0x09, 0x25, 0xa6, 0x59, 0x02,
	0x25, 0x76, 0xef, 0xd5, 0xd8, 0xe4, 0x1d, 0x2b, 0x7d, 0xc5, 0x93, 0x73, 0x23, 0x74, 0x22, 0xb0,
	0x5b, 0x80, 0x16, 0x3d, 0x2d, 0xdc, 0xf5, 0xf6, 0xea, 0xe1, 0xc6, 0x51, 0x67, 0x69, 0x41, 0xda,
	0x8f, 0xde, 0xb1, 0x12, 0x0e, 0xac, 0x2e, 0xd8, 0xc9, 0x79, 0xb2, 0x30, 0x26, 0x9c, 0xcf, 0xc0,
	0x5b, 0x11, 0xa4, 0x19, 0x24, 0x71, 0xea, 0x82, 0x1a, 0x99, 0x96, 0xd1, 0x8e, 0x0f, 0x9a, 0x51,
	0x16, 0x85, 0x63, 0x82, 0x42, 0x4a, 0x22, 0xce, 0x84, 0xdb, 0xac, 0xee, 0xbe, 0xcd, 0x28, 0x8b,
	0xfa, 0x04, 0xbd, 0x54, 0x02, 0x8d, 0xa0, 0xb3, 0x88, 0xad, 0x5a, 0x08, 0x7a, 0x8d, 0x38, 0x05,
	0xf7, 0xb5, 0xcb, 0xc2, 0x28, 0x83, 0x96, 0x72, 0x50, 0x4d, 0xd9, 0xd2, 0xaa, 0xe3, 0x0c, 0xce,
	0xe6, 0x32, 0x9d, 0xcd, 0xe5, 0x7e, 0xad, 0x5c, 0xa6, 0xb7, 0xe7, 0x42, 0x2d, 0x65, 0xff, 0x3f,
	0xe4, 0x42, 0x0d, 0xe8, 0x39, 0xd8, 0x30, 0x20, 0xce, 0xa0, 0x70, 0x1f, 0x2e, 0x39, 0x97, 0x13,
	0x96, 0x8f, 0x13, 0xac, 0x19, 0x40, 0x0b, 0x02, 0x06, 0x85, 0x33, 0x00, 0x0f, 0x32, 0xcc, 0x23,
	0x9c, 0x16, 0x89, 0xcc, 0x9d, 0xd0, 0x3b, 0xd5, 0xc9, 0xec, 0x18, 0xe9, 0xf1, 0xec, 0x41, 0xfd,
	0xda, 0x00, 0x8f, 0x2a, 0x2e, 0x09, 0x77, 0x57, 0xb1, 0xbf, 0xa8, 0xea, 0xca, 0x17, 0x06, 0xe3,
	0xe7, 0x92, 0x7d, 0x67, 0x21, 0x43, 0xcd, 0x08, 0x5a, 0xf8, 0x8e, 0x59, 0xe7, 0xb7, 0x06, 0x68,
	0x21, 0x22, 0xb2, 0x04, 0x5e, 0x59, 0x57, 0x14, 0xb5, 0x95, 0xdf, 0x56, 0xf7, 0x5d, 0xe5, 0xf4,
	0xaf, 0x2b, 0x9c, 0x7e, 0x6e, 0xbf, 0xca, 0x27, 0x56, 0xa8, 0x6c, 0x7e, 0x73, 0x38, 0xd8, 0x33,
	0xab, 0x69, 0xd7, 0xf4, 0x09, 0x2a, 0xa7, 0x9c, 0xaf, 0xc0, 0xf6, 0x84, 0xa4, 0x30, 0x51, 0x5e,
	0x17, 0xf9, 0x64, 0x42, 0x2e, 0x5d, 0xb7, 0x86, 0x7f, 0x9a, 0x4a, 0xf5, 0x8a, 0x27, 0x43, 0xa5,
	0x71, 0xbe, 0xb7, 0x3d, 0x33, 0x73, 0x6f, 0xba, 0x7b, 0x0a, 0xd4, 0xad, 0xda, 0xca, 0x32, 0x63,
	0xbb, 0x7d, 0xdb, 0x72, 0x61, 0xc4, 0x79, 0x0d, 0x0e, 0xf0, 0x64, 0x82, 0x23, 0x49, 0xa6, 0x38,
	0xbc, 0x69, 0x94, 0x56, 0x75, 0x3f, 0xb8, 0xa5, 0xfe, 0x7c, 0xc1, 0x31, 0x3f, 0x2f, 0x61, 0xeb,
	0x5b, 0xc9, 0x7d, 0xaf, 0xd6, 0x45, 0xd1, 0xd7, 0xd7, 0xea, 0x50, 0x69, 0xd4, 0x39, 0xcc, 0x8d,
	0xdc, 0xb6, 0xbc, 0x9e, 0x29, 0x3e, 0xb8, 0x37, 0x96, 0x57, 0x76, 0x79, 0x54, 0xc3, 0x2e, 0x3b,
	0x0b, 0x58, 0xe5, 0x9b, 0x5f, 0x40, 0xeb, 0x56, 0xa2, 0xad, 0xa8, 0xfd, 0xbf, 0x54, 0xb4, 0x77,
	0xcb, 0xd2, 0x7a, 0xaa, 0xff, 0x4f, 0x03, 0x3c, 0x89, 0x18, 0xf5, 0x2a, 0x7f, 0x04, 0xfb, 0x9b,
	0xe6, 0x52, 0x1a, 0x14, 0xc5, 0x0d, 0x1a, 0xaf, 0xbf, 0x35, 0x92, 0x98, 0x25, 0x30, 0x8d, 0x3d,
	0xc6, 0xe3, 0x4e, 0x8c, 0x53, 0x55, 0xba, 0xfd, 0x31, 0xc9, 0x88, 0xb8, 0xe3, 0x67, 0xf4, 0xf3,
	0xf2, 0xe9, 0xf7, 0x95, 0xd5, 0x53, 0xdf, 0xff, 0x63, 0xe5, 0xf1, 0xa9, 0x46, 0xfa, 0x48, 0x78,
	0xfa, 0xb1, 0x78, 0x1a, 0x75, 0xbd, 0xc0, 0x46, 0xfe, 0x69, 0x63, 0x2e, 0x7c, 0x24, 0x2e, 0xca,
	0x98, 0x8b, 0x51, 0xf7, 0xa2, 0x8c, 0xf9, 0x6b, 0xe5, 0x89, 0x9e, 0xe8, 0xf5, 0x7c, 0x24, 0x7a,
	0xbd, 0x32, 0xaa, 0xd7, 0x1b, 0x75, 0x7b, 0xbd, 0x32, 0x6e, 0xbc, 0xae, 0x92, 0x7d, 0xfa, 0x6f,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x12, 0x7c, 0x78, 0xc5, 0x38, 0x0b, 0x00, 0x00,
}
