// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1p1beta1/image_annotator.proto

package vision // import "google.golang.org/genproto/googleapis/cloud/vision/v1p1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import color "google.golang.org/genproto/googleapis/type/color"
import latlng "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely that the image belongs to the specified vertical.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely that the image belongs to the specified vertical.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible that the image belongs to the specified vertical.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely that the image belongs to the specified vertical.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely that the image belongs to the specified vertical.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{0}
}

// Type of image feature.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run OCR.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// DOCUMENT_TEXT_DETECTION and TEXT_DETECTION are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run computer vision models to compute image safe-search properties.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
)

var Feature_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "FACE_DETECTION",
	2:  "LANDMARK_DETECTION",
	3:  "LOGO_DETECTION",
	4:  "LABEL_DETECTION",
	5:  "TEXT_DETECTION",
	11: "DOCUMENT_TEXT_DETECTION",
	6:  "SAFE_SEARCH_DETECTION",
	7:  "IMAGE_PROPERTIES",
	9:  "CROP_HINTS",
	10: "WEB_DETECTION",
}
var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":        0,
	"FACE_DETECTION":          1,
	"LANDMARK_DETECTION":      2,
	"LOGO_DETECTION":          3,
	"LABEL_DETECTION":         4,
	"TEXT_DETECTION":          5,
	"DOCUMENT_TEXT_DETECTION": 11,
	"SAFE_SEARCH_DETECTION":   6,
	"IMAGE_PROPERTIES":        7,
	"CROP_HINTS":              9,
	"WEB_DETECTION":           10,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}
func (Feature_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{0, 0}
}

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

var FaceAnnotation_Landmark_Type_name = map[int32]string{
	0:  "UNKNOWN_LANDMARK",
	1:  "LEFT_EYE",
	2:  "RIGHT_EYE",
	3:  "LEFT_OF_LEFT_EYEBROW",
	4:  "RIGHT_OF_LEFT_EYEBROW",
	5:  "LEFT_OF_RIGHT_EYEBROW",
	6:  "RIGHT_OF_RIGHT_EYEBROW",
	7:  "MIDPOINT_BETWEEN_EYES",
	8:  "NOSE_TIP",
	9:  "UPPER_LIP",
	10: "LOWER_LIP",
	11: "MOUTH_LEFT",
	12: "MOUTH_RIGHT",
	13: "MOUTH_CENTER",
	14: "NOSE_BOTTOM_RIGHT",
	15: "NOSE_BOTTOM_LEFT",
	16: "NOSE_BOTTOM_CENTER",
	17: "LEFT_EYE_TOP_BOUNDARY",
	18: "LEFT_EYE_RIGHT_CORNER",
	19: "LEFT_EYE_BOTTOM_BOUNDARY",
	20: "LEFT_EYE_LEFT_CORNER",
	21: "RIGHT_EYE_TOP_BOUNDARY",
	22: "RIGHT_EYE_RIGHT_CORNER",
	23: "RIGHT_EYE_BOTTOM_BOUNDARY",
	24: "RIGHT_EYE_LEFT_CORNER",
	25: "LEFT_EYEBROW_UPPER_MIDPOINT",
	26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
	27: "LEFT_EAR_TRAGION",
	28: "RIGHT_EAR_TRAGION",
	29: "LEFT_EYE_PUPIL",
	30: "RIGHT_EYE_PUPIL",
	31: "FOREHEAD_GLABELLA",
	32: "CHIN_GNATHION",
	33: "CHIN_LEFT_GONION",
	34: "CHIN_RIGHT_GONION",
}
var FaceAnnotation_Landmark_Type_value = map[string]int32{
	"UNKNOWN_LANDMARK":             0,
	"LEFT_EYE":                     1,
	"RIGHT_EYE":                    2,
	"LEFT_OF_LEFT_EYEBROW":         3,
	"RIGHT_OF_LEFT_EYEBROW":        4,
	"LEFT_OF_RIGHT_EYEBROW":        5,
	"RIGHT_OF_RIGHT_EYEBROW":       6,
	"MIDPOINT_BETWEEN_EYES":        7,
	"NOSE_TIP":                     8,
	"UPPER_LIP":                    9,
	"LOWER_LIP":                    10,
	"MOUTH_LEFT":                   11,
	"MOUTH_RIGHT":                  12,
	"MOUTH_CENTER":                 13,
	"NOSE_BOTTOM_RIGHT":            14,
	"NOSE_BOTTOM_LEFT":             15,
	"NOSE_BOTTOM_CENTER":           16,
	"LEFT_EYE_TOP_BOUNDARY":        17,
	"LEFT_EYE_RIGHT_CORNER":        18,
	"LEFT_EYE_BOTTOM_BOUNDARY":     19,
	"LEFT_EYE_LEFT_CORNER":         20,
	"RIGHT_EYE_TOP_BOUNDARY":       21,
	"RIGHT_EYE_RIGHT_CORNER":       22,
	"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
	"RIGHT_EYE_LEFT_CORNER":        24,
	"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
	"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
	"LEFT_EAR_TRAGION":             27,
	"RIGHT_EAR_TRAGION":            28,
	"LEFT_EYE_PUPIL":               29,
	"RIGHT_EYE_PUPIL":              30,
	"FOREHEAD_GLABELLA":            31,
	"CHIN_GNATHION":                32,
	"CHIN_LEFT_GONION":             33,
	"CHIN_RIGHT_GONION":            34,
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return proto.EnumName(FaceAnnotation_Landmark_Type_name, int32(x))
}
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{3, 0, 0}
}

// Users describe the type of Google Cloud Vision API tasks to perform over
// images by using *Feature*s. Each Feature indicates a type of image
// detection task to perform. Features encode the Cloud Vision API
// vertical to operate on and the number of top-scoring results to return.
type Feature struct {
	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vision.v1p1beta1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Model to use for the feature.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Feature) Reset()         { *m = Feature{} }
func (m *Feature) String() string { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()    {}
func (*Feature) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{0}
}
func (m *Feature) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feature.Unmarshal(m, b)
}
func (m *Feature) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feature.Marshal(b, m, deterministic)
}
func (dst *Feature) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feature.Merge(dst, src)
}
func (m *Feature) XXX_Size() int {
	return xxx_messageInfo_Feature.Size(m)
}
func (m *Feature) XXX_DiscardUnknown() {
	xxx_messageInfo_Feature.DiscardUnknown(m)
}

var xxx_messageInfo_Feature proto.InternalMessageInfo

func (m *Feature) GetType() Feature_Type {
	if m != nil {
		return m.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (m *Feature) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

func (m *Feature) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// External image source (Google Cloud Storage image location).
type ImageSource struct {
	// NOTE: For new code `image_uri` below is preferred.
	// Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri,proto3" json:"gcs_image_uri,omitempty"`
	// Image URI which supports:
	// 1) Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	// 2) Publicly accessible image HTTP/HTTPS URL.
	// This is preferred over the legacy `gcs_image_uri` above. When both
	// `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri             string   `protobuf:"bytes,2,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageSource) Reset()         { *m = ImageSource{} }
func (m *ImageSource) String() string { return proto.CompactTextString(m) }
func (*ImageSource) ProtoMessage()    {}
func (*ImageSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{1}
}
func (m *ImageSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageSource.Unmarshal(m, b)
}
func (m *ImageSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageSource.Marshal(b, m, deterministic)
}
func (dst *ImageSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSource.Merge(dst, src)
}
func (m *ImageSource) XXX_Size() int {
	return xxx_messageInfo_ImageSource.Size(m)
}
func (m *ImageSource) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSource.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSource proto.InternalMessageInfo

func (m *ImageSource) GetGcsImageUri() string {
	if m != nil {
		return m.GcsImageUri
	}
	return ""
}

func (m *ImageSource) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	// Image content, represented as a stream of bytes.
	// Note: as with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location. If both `content` and `source`
	// are provided for an image, `content` takes precedence and is
	// used to perform the image annotation request.
	Source               *ImageSource `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{2}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (dst *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(dst, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Image) GetSource() *ImageSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale, as returned in `ImageParams`.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly,proto3" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle,proto3" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle,proto3" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle,proto3" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence,proto3" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence,proto3" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood   Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"headwear_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{3}
}
func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (dst *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(dst, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.FdBoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

func (m *FaceAnnotation) GetRollAngle() float32 {
	if m != nil {
		return m.RollAngle
	}
	return 0
}

func (m *FaceAnnotation) GetPanAngle() float32 {
	if m != nil {
		return m.PanAngle
	}
	return 0
}

func (m *FaceAnnotation) GetTiltAngle() float32 {
	if m != nil {
		return m.TiltAngle
	}
	return 0
}

func (m *FaceAnnotation) GetDetectionConfidence() float32 {
	if m != nil {
		return m.DetectionConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if m != nil {
		return m.LandmarkingConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if m != nil {
		return m.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if m != nil {
		return m.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if m != nil {
		return m.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if m != nil {
		return m.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if m != nil {
		return m.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if m != nil {
		return m.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if m != nil {
		return m.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// A face-specific landmark (for example, a face feature).
type FaceAnnotation_Landmark struct {
	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.vision.v1p1beta1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position             *Position `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FaceAnnotation_Landmark) Reset()         { *m = FaceAnnotation_Landmark{} }
func (m *FaceAnnotation_Landmark) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation_Landmark) ProtoMessage()    {}
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{3, 0}
}
func (m *FaceAnnotation_Landmark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation_Landmark.Unmarshal(m, b)
}
func (m *FaceAnnotation_Landmark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation_Landmark.Marshal(b, m, deterministic)
}
func (dst *FaceAnnotation_Landmark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation_Landmark.Merge(dst, src)
}
func (m *FaceAnnotation_Landmark) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation_Landmark.Size(m)
}
func (m *FaceAnnotation_Landmark) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation_Landmark.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation_Landmark proto.InternalMessageInfo

func (m *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if m != nil {
		return m.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (m *FaceAnnotation_Landmark) GetPosition() *Position {
	if m != nil {
		return m.Position
	}
	return nil
}

// Detected entity location information.
type LocationInfo struct {
	// lat/long location coordinates.
	LatLng               *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LocationInfo) Reset()         { *m = LocationInfo{} }
func (m *LocationInfo) String() string { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()    {}
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{4}
}
func (m *LocationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationInfo.Unmarshal(m, b)
}
func (m *LocationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationInfo.Marshal(b, m, deterministic)
}
func (dst *LocationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationInfo.Merge(dst, src)
}
func (m *LocationInfo) XXX_Size() int {
	return xxx_messageInfo_LocationInfo.Size(m)
}
func (m *LocationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LocationInfo proto.InternalMessageInfo

func (m *LocationInfo) GetLatLng() *latlng.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Value of numeric properties.
	Uint64Value          uint64   `protobuf:"varint,3,opt,name=uint64_value,json=uint64Value,proto3" json:"uint64_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}
func (*Property) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{5}
}
func (m *Property) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Property.Unmarshal(m, b)
}
func (m *Property) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Property.Marshal(b, m, deterministic)
}
func (dst *Property) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Property.Merge(dst, src)
}
func (m *Property) XXX_Size() int {
	return xxx_messageInfo_Property.Size(m)
}
func (m *Property) XXX_DiscardUnknown() {
	xxx_messageInfo_Property.DiscardUnknown(m)
}

var xxx_messageInfo_Property proto.InternalMessageInfo

func (m *Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Property) GetUint64Value() uint64 {
	if m != nil {
		return m.Uint64Value
	}
	return 0
}

// Set of detected entity features.
type EntityAnnotation struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale,proto3" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality,proto3" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not produced
	// for `LABEL_DETECTION` features.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations,proto3" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties           []*Property `protobuf:"bytes,9,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EntityAnnotation) Reset()         { *m = EntityAnnotation{} }
func (m *EntityAnnotation) String() string { return proto.CompactTextString(m) }
func (*EntityAnnotation) ProtoMessage()    {}
func (*EntityAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{6}
}
func (m *EntityAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityAnnotation.Unmarshal(m, b)
}
func (m *EntityAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityAnnotation.Marshal(b, m, deterministic)
}
func (dst *EntityAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityAnnotation.Merge(dst, src)
}
func (m *EntityAnnotation) XXX_Size() int {
	return xxx_messageInfo_EntityAnnotation.Size(m)
}
func (m *EntityAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_EntityAnnotation proto.InternalMessageInfo

func (m *EntityAnnotation) GetMid() string {
	if m != nil {
		return m.Mid
	}
	return ""
}

func (m *EntityAnnotation) GetLocale() string {
	if m != nil {
		return m.Locale
	}
	return ""
}

func (m *EntityAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntityAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *EntityAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *EntityAnnotation) GetTopicality() float32 {
	if m != nil {
		return m.Topicality
	}
	return 0
}

func (m *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *EntityAnnotation) GetLocations() []*LocationInfo {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *EntityAnnotation) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	// Represents the adult content likelihood for the image. Adult content may
	// contain elements such as nudity, pornographic images or cartoons, or
	// sexual activities.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood that this image contains violent content.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"violence,omitempty"`
	// Likelihood that the request image contains racy content. Racy content may
	// include (but is not limited to) skimpy or sheer clothing, strategically
	// covered nudity, lewd or provocative poses, or close-ups of sensitive
	// body areas.
	Racy                 Likelihood `protobuf:"varint,9,opt,name=racy,proto3,enum=google.cloud.vision.v1p1beta1.Likelihood" json:"racy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SafeSearchAnnotation) Reset()         { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()    {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{7}
}
func (m *SafeSearchAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SafeSearchAnnotation.Unmarshal(m, b)
}
func (m *SafeSearchAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SafeSearchAnnotation.Marshal(b, m, deterministic)
}
func (dst *SafeSearchAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SafeSearchAnnotation.Merge(dst, src)
}
func (m *SafeSearchAnnotation) XXX_Size() int {
	return xxx_messageInfo_SafeSearchAnnotation.Size(m)
}
func (m *SafeSearchAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_SafeSearchAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_SafeSearchAnnotation proto.InternalMessageInfo

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolence() Likelihood {
	if m != nil {
		return m.Violence
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	// Min lat/long pair.
	MinLatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng,proto3" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng            *latlng.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng,proto3" json:"max_lat_lng,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *LatLongRect) Reset()         { *m = LatLongRect{} }
func (m *LatLongRect) String() string { return proto.CompactTextString(m) }
func (*LatLongRect) ProtoMessage()    {}
func (*LatLongRect) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{8}
}
func (m *LatLongRect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LatLongRect.Unmarshal(m, b)
}
func (m *LatLongRect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LatLongRect.Marshal(b, m, deterministic)
}
func (dst *LatLongRect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LatLongRect.Merge(dst, src)
}
func (m *LatLongRect) XXX_Size() int {
	return xxx_messageInfo_LatLongRect.Size(m)
}
func (m *LatLongRect) XXX_DiscardUnknown() {
	xxx_messageInfo_LatLongRect.DiscardUnknown(m)
}

var xxx_messageInfo_LatLongRect proto.InternalMessageInfo

func (m *LatLongRect) GetMinLatLng() *latlng.LatLng {
	if m != nil {
		return m.MinLatLng
	}
	return nil
}

func (m *LatLongRect) GetMaxLatLng() *latlng.LatLng {
	if m != nil {
		return m.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	// RGB components of the color.
	Color *color.Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction        float32  `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction,proto3" json:"pixel_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ColorInfo) Reset()         { *m = ColorInfo{} }
func (m *ColorInfo) String() string { return proto.CompactTextString(m) }
func (*ColorInfo) ProtoMessage()    {}
func (*ColorInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{9}
}
func (m *ColorInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ColorInfo.Unmarshal(m, b)
}
func (m *ColorInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ColorInfo.Marshal(b, m, deterministic)
}
func (dst *ColorInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ColorInfo.Merge(dst, src)
}
func (m *ColorInfo) XXX_Size() int {
	return xxx_messageInfo_ColorInfo.Size(m)
}
func (m *ColorInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ColorInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ColorInfo proto.InternalMessageInfo

func (m *ColorInfo) GetColor() *color.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *ColorInfo) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *ColorInfo) GetPixelFraction() float32 {
	if m != nil {
		return m.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	// RGB color values with their score and pixel fraction.
	Colors               []*ColorInfo `protobuf:"bytes,1,rep,name=colors,proto3" json:"colors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DominantColorsAnnotation) Reset()         { *m = DominantColorsAnnotation{} }
func (m *DominantColorsAnnotation) String() string { return proto.CompactTextString(m) }
func (*DominantColorsAnnotation) ProtoMessage()    {}
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{10}
}
func (m *DominantColorsAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DominantColorsAnnotation.Unmarshal(m, b)
}
func (m *DominantColorsAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DominantColorsAnnotation.Marshal(b, m, deterministic)
}
func (dst *DominantColorsAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DominantColorsAnnotation.Merge(dst, src)
}
func (m *DominantColorsAnnotation) XXX_Size() int {
	return xxx_messageInfo_DominantColorsAnnotation.Size(m)
}
func (m *DominantColorsAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_DominantColorsAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_DominantColorsAnnotation proto.InternalMessageInfo

func (m *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if m != nil {
		return m.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	// If present, dominant colors completed successfully.
	DominantColors       *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors,proto3" json:"dominant_colors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ImageProperties) Reset()         { *m = ImageProperties{} }
func (m *ImageProperties) String() string { return proto.CompactTextString(m) }
func (*ImageProperties) ProtoMessage()    {}
func (*ImageProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{11}
}
func (m *ImageProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageProperties.Unmarshal(m, b)
}
func (m *ImageProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageProperties.Marshal(b, m, deterministic)
}
func (dst *ImageProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageProperties.Merge(dst, src)
}
func (m *ImageProperties) XXX_Size() int {
	return xxx_messageInfo_ImageProperties.Size(m)
}
func (m *ImageProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageProperties.DiscardUnknown(m)
}

var xxx_messageInfo_ImageProperties proto.InternalMessageInfo

func (m *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if m != nil {
		return m.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale, as returned in `ImageParams`.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction   float32  `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction,proto3" json:"importance_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CropHint) Reset()         { *m = CropHint{} }
func (m *CropHint) String() string { return proto.CompactTextString(m) }
func (*CropHint) ProtoMessage()    {}
func (*CropHint) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{12}
}
func (m *CropHint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHint.Unmarshal(m, b)
}
func (m *CropHint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHint.Marshal(b, m, deterministic)
}
func (dst *CropHint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHint.Merge(dst, src)
}
func (m *CropHint) XXX_Size() int {
	return xxx_messageInfo_CropHint.Size(m)
}
func (m *CropHint) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHint.DiscardUnknown(m)
}

var xxx_messageInfo_CropHint proto.InternalMessageInfo

func (m *CropHint) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *CropHint) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *CropHint) GetImportanceFraction() float32 {
	if m != nil {
		return m.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	// Crop hint results.
	CropHints            []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints,proto3" json:"crop_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CropHintsAnnotation) Reset()         { *m = CropHintsAnnotation{} }
func (m *CropHintsAnnotation) String() string { return proto.CompactTextString(m) }
func (*CropHintsAnnotation) ProtoMessage()    {}
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{13}
}
func (m *CropHintsAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHintsAnnotation.Unmarshal(m, b)
}
func (m *CropHintsAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHintsAnnotation.Marshal(b, m, deterministic)
}
func (dst *CropHintsAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHintsAnnotation.Merge(dst, src)
}
func (m *CropHintsAnnotation) XXX_Size() int {
	return xxx_messageInfo_CropHintsAnnotation.Size(m)
}
func (m *CropHintsAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHintsAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_CropHintsAnnotation proto.InternalMessageInfo

func (m *CropHintsAnnotation) GetCropHints() []*CropHint {
	if m != nil {
		return m.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios         []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios,proto3" json:"aspect_ratios,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CropHintsParams) Reset()         { *m = CropHintsParams{} }
func (m *CropHintsParams) String() string { return proto.CompactTextString(m) }
func (*CropHintsParams) ProtoMessage()    {}
func (*CropHintsParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{14}
}
func (m *CropHintsParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CropHintsParams.Unmarshal(m, b)
}
func (m *CropHintsParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CropHintsParams.Marshal(b, m, deterministic)
}
func (dst *CropHintsParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CropHintsParams.Merge(dst, src)
}
func (m *CropHintsParams) XXX_Size() int {
	return xxx_messageInfo_CropHintsParams.Size(m)
}
func (m *CropHintsParams) XXX_DiscardUnknown() {
	xxx_messageInfo_CropHintsParams.DiscardUnknown(m)
}

var xxx_messageInfo_CropHintsParams proto.InternalMessageInfo

func (m *CropHintsParams) GetAspectRatios() []float32 {
	if m != nil {
		return m.AspectRatios
	}
	return nil
}

// Parameters for web detection request.
type WebDetectionParams struct {
	// Whether to include results derived from the geo information in the image.
	IncludeGeoResults    bool     `protobuf:"varint,2,opt,name=include_geo_results,json=includeGeoResults,proto3" json:"include_geo_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WebDetectionParams) Reset()         { *m = WebDetectionParams{} }
func (m *WebDetectionParams) String() string { return proto.CompactTextString(m) }
func (*WebDetectionParams) ProtoMessage()    {}
func (*WebDetectionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{15}
}
func (m *WebDetectionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebDetectionParams.Unmarshal(m, b)
}
func (m *WebDetectionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebDetectionParams.Marshal(b, m, deterministic)
}
func (dst *WebDetectionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebDetectionParams.Merge(dst, src)
}
func (m *WebDetectionParams) XXX_Size() int {
	return xxx_messageInfo_WebDetectionParams.Size(m)
}
func (m *WebDetectionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_WebDetectionParams.DiscardUnknown(m)
}

var xxx_messageInfo_WebDetectionParams proto.InternalMessageInfo

func (m *WebDetectionParams) GetIncludeGeoResults() bool {
	if m != nil {
		return m.IncludeGeoResults
	}
	return false
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	// lat/long rectangle that specifies the location of the image.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect,proto3" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams,proto3" json:"crop_hints_params,omitempty"`
	// Parameters for web detection.
	WebDetectionParams   *WebDetectionParams `protobuf:"bytes,6,opt,name=web_detection_params,json=webDetectionParams,proto3" json:"web_detection_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImageContext) Reset()         { *m = ImageContext{} }
func (m *ImageContext) String() string { return proto.CompactTextString(m) }
func (*ImageContext) ProtoMessage()    {}
func (*ImageContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{16}
}
func (m *ImageContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageContext.Unmarshal(m, b)
}
func (m *ImageContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageContext.Marshal(b, m, deterministic)
}
func (dst *ImageContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageContext.Merge(dst, src)
}
func (m *ImageContext) XXX_Size() int {
	return xxx_messageInfo_ImageContext.Size(m)
}
func (m *ImageContext) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageContext.DiscardUnknown(m)
}

var xxx_messageInfo_ImageContext proto.InternalMessageInfo

func (m *ImageContext) GetLatLongRect() *LatLongRect {
	if m != nil {
		return m.LatLongRect
	}
	return nil
}

func (m *ImageContext) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *ImageContext) GetCropHintsParams() *CropHintsParams {
	if m != nil {
		return m.CropHintsParams
	}
	return nil
}

func (m *ImageContext) GetWebDetectionParams() *WebDetectionParams {
	if m != nil {
		return m.WebDetectionParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features.
type AnnotateImageRequest struct {
	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext         *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AnnotateImageRequest) Reset()         { *m = AnnotateImageRequest{} }
func (m *AnnotateImageRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateImageRequest) ProtoMessage()    {}
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{17}
}
func (m *AnnotateImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateImageRequest.Unmarshal(m, b)
}
func (m *AnnotateImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateImageRequest.Marshal(b, m, deterministic)
}
func (dst *AnnotateImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateImageRequest.Merge(dst, src)
}
func (m *AnnotateImageRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateImageRequest.Size(m)
}
func (m *AnnotateImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateImageRequest proto.InternalMessageInfo

func (m *AnnotateImageRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *AnnotateImageRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateImageRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations,proto3" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations,proto3" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// If present, text (OCR) detection has completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation,proto3" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation,proto3" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation,proto3" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation,proto3" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection,proto3" json:"web_detection,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AnnotateImageResponse) Reset()         { *m = AnnotateImageResponse{} }
func (m *AnnotateImageResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateImageResponse) ProtoMessage()    {}
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{18}
}
func (m *AnnotateImageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateImageResponse.Unmarshal(m, b)
}
func (m *AnnotateImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateImageResponse.Marshal(b, m, deterministic)
}
func (dst *AnnotateImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateImageResponse.Merge(dst, src)
}
func (m *AnnotateImageResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateImageResponse.Size(m)
}
func (m *AnnotateImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateImageResponse proto.InternalMessageInfo

func (m *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LandmarkAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LogoAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if m != nil {
		return m.FullTextAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if m != nil {
		return m.ImagePropertiesAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if m != nil {
		return m.CropHintsAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if m != nil {
		return m.WebDetection
	}
	return nil
}

func (m *AnnotateImageResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests             []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *BatchAnnotateImagesRequest) Reset()         { *m = BatchAnnotateImagesRequest{} }
func (m *BatchAnnotateImagesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesRequest) ProtoMessage()    {}
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{19}
}
func (m *BatchAnnotateImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Unmarshal(m, b)
}
func (m *BatchAnnotateImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Marshal(b, m, deterministic)
}
func (dst *BatchAnnotateImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateImagesRequest.Merge(dst, src)
}
func (m *BatchAnnotateImagesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateImagesRequest.Size(m)
}
func (m *BatchAnnotateImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateImagesRequest proto.InternalMessageInfo

func (m *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	// Individual responses to image annotation requests within the batch.
	Responses            []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *BatchAnnotateImagesResponse) Reset()         { *m = BatchAnnotateImagesResponse{} }
func (m *BatchAnnotateImagesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesResponse) ProtoMessage()    {}
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_annotator_b9bb1d6b9235c514, []int{20}
}
func (m *BatchAnnotateImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Unmarshal(m, b)
}
func (m *BatchAnnotateImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Marshal(b, m, deterministic)
}
func (dst *BatchAnnotateImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchAnnotateImagesResponse.Merge(dst, src)
}
func (m *BatchAnnotateImagesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchAnnotateImagesResponse.Size(m)
}
func (m *BatchAnnotateImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchAnnotateImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchAnnotateImagesResponse proto.InternalMessageInfo

func (m *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

func init() {
	proto.RegisterType((*Feature)(nil), "google.cloud.vision.v1p1beta1.Feature")
	proto.RegisterType((*ImageSource)(nil), "google.cloud.vision.v1p1beta1.ImageSource")
	proto.RegisterType((*Image)(nil), "google.cloud.vision.v1p1beta1.Image")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.vision.v1p1beta1.FaceAnnotation")
	proto.RegisterType((*FaceAnnotation_Landmark)(nil), "google.cloud.vision.v1p1beta1.FaceAnnotation.Landmark")
	proto.RegisterType((*LocationInfo)(nil), "google.cloud.vision.v1p1beta1.LocationInfo")
	proto.RegisterType((*Property)(nil), "google.cloud.vision.v1p1beta1.Property")
	proto.RegisterType((*EntityAnnotation)(nil), "google.cloud.vision.v1p1beta1.EntityAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.vision.v1p1beta1.SafeSearchAnnotation")
	proto.RegisterType((*LatLongRect)(nil), "google.cloud.vision.v1p1beta1.LatLongRect")
	proto.RegisterType((*ColorInfo)(nil), "google.cloud.vision.v1p1beta1.ColorInfo")
	proto.RegisterType((*DominantColorsAnnotation)(nil), "google.cloud.vision.v1p1beta1.DominantColorsAnnotation")
	proto.RegisterType((*ImageProperties)(nil), "google.cloud.vision.v1p1beta1.ImageProperties")
	proto.RegisterType((*CropHint)(nil), "google.cloud.vision.v1p1beta1.CropHint")
	proto.RegisterType((*CropHintsAnnotation)(nil), "google.cloud.vision.v1p1beta1.CropHintsAnnotation")
	proto.RegisterType((*CropHintsParams)(nil), "google.cloud.vision.v1p1beta1.CropHintsParams")
	proto.RegisterType((*WebDetectionParams)(nil), "google.cloud.vision.v1p1beta1.WebDetectionParams")
	proto.RegisterType((*ImageContext)(nil), "google.cloud.vision.v1p1beta1.ImageContext")
	proto.RegisterType((*AnnotateImageRequest)(nil), "google.cloud.vision.v1p1beta1.AnnotateImageRequest")
	proto.RegisterType((*AnnotateImageResponse)(nil), "google.cloud.vision.v1p1beta1.AnnotateImageResponse")
	proto.RegisterType((*BatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest")
	proto.RegisterType((*BatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse")
	proto.RegisterEnum("google.cloud.vision.v1p1beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.vision.v1p1beta1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1p1beta1.FaceAnnotation_Landmark_Type", FaceAnnotation_Landmark_Type_name, FaceAnnotation_Landmark_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ImageAnnotatorClient is the client API for ImageAnnotator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
}

type imageAnnotatorClient struct {
	cc *grpc.ClientConn
}

func NewImageAnnotatorClient(cc *grpc.ClientConn) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1p1beta1.ImageAnnotator/BatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageAnnotatorServer is the server API for ImageAnnotator service.
type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1p1beta1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1p1beta1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1p1beta1/image_annotator.proto",
}

func init() {
	proto.RegisterFile("google/cloud/vision/v1p1beta1/image_annotator.proto", fileDescriptor_image_annotator_b9bb1d6b9235c514)
}

var fileDescriptor_image_annotator_b9bb1d6b9235c514 = []byte{
	// 2392 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcd, 0x72, 0xe3, 0xc6,
	0xf1, 0x37, 0xa9, 0x2f, 0xb2, 0x49, 0x91, 0xd0, 0x48, 0x2b, 0x73, 0xb5, 0xbb, 0x5e, 0x19, 0xff,
	0xbf, 0x13, 0xc5, 0x71, 0xa8, 0x5a, 0xad, 0xe3, 0x54, 0xd6, 0x49, 0x39, 0x24, 0x05, 0x49, 0x2c,
	0x73, 0x49, 0xd4, 0x90, 0xb2, 0xbc, 0x5b, 0x4e, 0x21, 0x10, 0x38, 0xe4, 0xc2, 0x06, 0x31, 0x30,
	0x00, 0xee, 0x4a, 0x57, 0x5f, 0x73, 0xcc, 0x2d, 0xf7, 0x1c, 0x73, 0x4a, 0x9e, 0xc1, 0x2f, 0x90,
	0x43, 0x1e, 0x20, 0x39, 0xe4, 0x09, 0x52, 0xa9, 0x9c, 0x52, 0xf3, 0x01, 0x70, 0xc0, 0xfd, 0xa0,
	0xb8, 0xa9, 0x9c, 0x88, 0xe9, 0x9e, 0xdf, 0xaf, 0x67, 0xba, 0xa7, 0x67, 0x7a, 0x86, 0xf0, 0x70,
	0x4c, 0xe9, 0xd8, 0x23, 0x87, 0x8e, 0x47, 0xa7, 0xc3, 0xc3, 0xe7, 0x6e, 0xe4, 0x52, 0xff, 0xf0,
	0xf9, 0x83, 0xe0, 0xc1, 0x25, 0x89, 0xed, 0x07, 0x87, 0xee, 0xc4, 0x1e, 0x13, 0xcb, 0xf6, 0x7d,
	0x1a, 0xdb, 0x31, 0x0d, 0xeb, 0x41, 0x48, 0x63, 0x8a, 0xee, 0x09, 0x50, 0x9d, 0x83, 0xea, 0x02,
	0x54, 0x4f, 0x41, 0x7b, 0x77, 0x25, 0xa7, 0x1d, 0xb8, 0x87, 0x12, 0xea, 0x52, 0x3f, 0x12, 0xe0,
	0xbd, 0x8f, 0xde, 0x6c, 0x71, 0x4c, 0xe8, 0x84, 0xc4, 0xe1, 0xb5, 0xec, 0xbd, 0x60, 0x7c, 0x31,
	0xb9, 0x8a, 0xad, 0x99, 0x0d, 0x09, 0x7a, 0xf0, 0x66, 0xd0, 0x0b, 0x72, 0x69, 0x0d, 0x49, 0x4c,
	0x1c, 0x05, 0xf2, 0xae, 0x84, 0x84, 0x81, 0x73, 0x18, 0xc5, 0x76, 0x3c, 0x8d, 0xe6, 0x14, 0xf1,
	0x75, 0x40, 0x0e, 0x1d, 0xea, 0x25, 0x4e, 0xd8, 0xab, 0xa9, 0x0a, 0xcf, 0x8e, 0x3d, 0x7f, 0x2c,
	0x34, 0xfa, 0xbf, 0xf3, 0xb0, 0x71, 0x42, 0xec, 0x78, 0x1a, 0x12, 0xf4, 0x19, 0xac, 0xb2, 0x0e,
	0xb5, 0xdc, 0x7e, 0xee, 0xa0, 0x72, 0xf4, 0xe3, 0xfa, 0x1b, 0x3d, 0x57, 0x97, 0xa8, 0xfa, 0xe0,
	0x3a, 0x20, 0x98, 0x03, 0xd1, 0x7d, 0x28, 0x4d, 0xec, 0x2b, 0x2b, 0x24, 0xd1, 0xd4, 0x8b, 0xa3,
	0x5a, 0x7e, 0x3f, 0x77, 0xb0, 0x86, 0x61, 0x62, 0x5f, 0x61, 0x21, 0x41, 0x3b, 0xb0, 0x36, 0xa1,
	0x43, 0xe2, 0xd5, 0x56, 0xf6, 0x73, 0x07, 0x45, 0x2c, 0x1a, 0xfa, 0x3f, 0x73, 0xb0, 0xca, 0x58,
	0xd0, 0x0e, 0x68, 0x83, 0x27, 0xa6, 0x61, 0x9d, 0x77, 0xfb, 0xa6, 0xd1, 0x6a, 0x9f, 0xb4, 0x8d,
	0x63, 0xed, 0x1d, 0x84, 0xa0, 0x72, 0xd2, 0x68, 0x19, 0xd6, 0xb1, 0x31, 0x30, 0x5a, 0x83, 0x76,
	0xaf, 0xab, 0xe5, 0xd0, 0x2e, 0xa0, 0x4e, 0xa3, 0x7b, 0xfc, 0xb8, 0x81, 0x3f, 0x57, 0xe4, 0x79,
	0xd6, 0xb7, 0xd3, 0x3b, 0xed, 0x29, 0xb2, 0x15, 0xb4, 0x0d, 0xd5, 0x4e, 0xa3, 0x69, 0x74, 0x14,
	0xe1, 0x2a, 0xeb, 0x38, 0x30, 0xbe, 0x1c, 0x28, 0xb2, 0x35, 0x74, 0x07, 0xde, 0x3d, 0xee, 0xb5,
	0xce, 0x1f, 0x1b, 0xdd, 0x81, 0x35, 0xa7, 0x2c, 0xa1, 0xdb, 0x70, 0xab, 0xdf, 0x38, 0x31, 0xac,
	0xbe, 0xd1, 0xc0, 0xad, 0x33, 0x45, 0xb5, 0xce, 0x86, 0xdd, 0x7e, 0xdc, 0x38, 0x35, 0x2c, 0x13,
	0xf7, 0x4c, 0x03, 0x0f, 0xda, 0x46, 0x5f, 0xdb, 0x40, 0x15, 0x80, 0x16, 0xee, 0x99, 0xd6, 0x59,
	0xbb, 0x3b, 0xe8, 0x6b, 0x45, 0xb4, 0x05, 0x9b, 0x17, 0x46, 0x53, 0x01, 0x82, 0xde, 0x85, 0x52,
	0x9b, 0x2d, 0xda, 0x3e, 0x9d, 0x86, 0x0e, 0x41, 0x3a, 0x6c, 0x8e, 0x9d, 0xc8, 0x12, 0xeb, 0x78,
	0x1a, 0xba, 0x3c, 0x10, 0x45, 0x5c, 0x1a, 0x3b, 0x11, 0xef, 0x76, 0x1e, 0xba, 0xe8, 0x0e, 0x14,
	0x67, 0xfa, 0x3c, 0xd7, 0x17, 0x5c, 0xa9, 0xd4, 0x09, 0xac, 0xf1, 0x8e, 0xa8, 0x06, 0x1b, 0x0e,
	0xf5, 0x63, 0xe2, 0xc7, 0x9c, 0xa3, 0x8c, 0x93, 0x26, 0x6a, 0xc2, 0x7a, 0xc4, 0xad, 0x71, 0x70,
	0xe9, 0xe8, 0xc3, 0x05, 0x51, 0x56, 0xc6, 0x87, 0x25, 0x52, 0xff, 0x83, 0x06, 0x95, 0x13, 0xdb,
	0x21, 0x8d, 0x74, 0x2d, 0x23, 0x13, 0x36, 0x2f, 0xe9, 0xd4, 0x1f, 0xba, 0xfe, 0xd8, 0x0a, 0xa8,
	0x77, 0xcd, 0xcd, 0x96, 0x16, 0xae, 0xa1, 0xa6, 0xc4, 0x98, 0xd4, 0xbb, 0xc6, 0xe5, 0x4b, 0xa5,
	0x85, 0xce, 0x41, 0x1b, 0x0d, 0xad, 0x2c, 0x69, 0x7e, 0x79, 0xd2, 0xca, 0x68, 0xa8, 0xb6, 0xd1,
	0x00, 0x8a, 0x9e, 0xed, 0x0f, 0x27, 0x76, 0xf8, 0x4d, 0x54, 0x5b, 0xd9, 0x5f, 0x39, 0x28, 0x1d,
	0x7d, 0xb2, 0x68, 0xa1, 0x67, 0xa6, 0x5a, 0xef, 0x48, 0x38, 0x9e, 0x11, 0xa1, 0x7b, 0x00, 0x21,
	0xf5, 0x3c, 0xcb, 0xf6, 0xc7, 0x1e, 0xa9, 0xad, 0xee, 0xe7, 0x0e, 0xf2, 0xb8, 0xc8, 0x24, 0x0d,
	0x26, 0x60, 0x41, 0x0b, 0x6c, 0x5f, 0x6a, 0xd7, 0xb8, 0xb6, 0x10, 0xd8, 0xbe, 0x50, 0xde, 0x03,
	0x88, 0x5d, 0x2f, 0x96, 0xda, 0x75, 0x81, 0x65, 0x12, 0xa1, 0x7e, 0x00, 0x3b, 0x69, 0xfe, 0x5b,
	0x0e, 0xf5, 0x47, 0xee, 0x90, 0xf8, 0x0e, 0xa9, 0x6d, 0xf0, 0x8e, 0xdb, 0xa9, 0xae, 0x95, 0xaa,
	0xd0, 0x4f, 0x61, 0x37, 0x19, 0x1a, 0x73, 0x9d, 0x02, 0x2a, 0x70, 0xd0, 0x2d, 0x45, 0xab, 0xc0,
	0x4c, 0xa8, 0x7c, 0x4d, 0xaf, 0x2d, 0xcf, 0xfd, 0x86, 0x78, 0xee, 0x33, 0x4a, 0x87, 0xb5, 0x22,
	0xdf, 0x08, 0x7e, 0xb4, 0xc0, 0x3f, 0x9d, 0x14, 0x80, 0x37, 0xbf, 0xa6, 0xd7, 0xb3, 0x26, 0xfa,
	0x02, 0xb6, 0x22, 0x1a, 0x86, 0xf4, 0x85, 0x4a, 0x0a, 0xcb, 0x92, 0x6a, 0x82, 0x43, 0xe1, 0x1d,
	0x80, 0x66, 0xfb, 0x63, 0x12, 0xaa, 0xb4, 0xa5, 0x65, 0x69, 0xab, 0x9c, 0x42, 0x61, 0x7d, 0x0a,
	0xdb, 0xd1, 0x34, 0x0c, 0x42, 0x37, 0x22, 0x2a, 0x71, 0x79, 0x59, 0x62, 0x94, 0xb0, 0x28, 0xdc,
	0x0e, 0xd4, 0xa6, 0xfe, 0x90, 0x84, 0x16, 0xb9, 0x0a, 0x68, 0x44, 0x86, 0xaa, 0x81, 0xcd, 0x65,
	0x0d, 0xec, 0x72, 0x2a, 0x43, 0x30, 0x29, 0x46, 0xbe, 0x04, 0x74, 0xe9, 0x4d, 0xc3, 0x30, 0x4b,
	0x5f, 0x59, 0x96, 0x7e, 0x4b, 0x92, 0x64, 0x5d, 0xf3, 0x8c, 0xd8, 0xc3, 0x17, 0xc4, 0xce, 0xf8,
	0xbc, 0xba, 0xb4, 0x6b, 0x12, 0x96, 0x99, 0x6c, 0xef, 0xaf, 0x1b, 0x50, 0x48, 0x72, 0x0a, 0xf5,
	0xe4, 0x11, 0xb4, 0xc2, 0x99, 0x3f, 0x7d, 0xbb, 0xcc, 0x54, 0x8f, 0xa4, 0x16, 0x14, 0x02, 0x1a,
	0xb9, 0x4c, 0xcf, 0xf3, 0xb2, 0x74, 0xf4, 0xc3, 0x05, 0xa4, 0xa6, 0xec, 0x8e, 0x53, 0xa0, 0xfe,
	0xe7, 0xf5, 0xd9, 0x01, 0x75, 0xde, 0xfd, 0xbc, 0xdb, 0xbb, 0xe8, 0x5a, 0xc9, 0xf1, 0xa3, 0xbd,
	0x83, 0xca, 0x50, 0xe8, 0x18, 0x27, 0x03, 0xcb, 0x78, 0x62, 0x68, 0x39, 0xb4, 0x09, 0x45, 0xdc,
	0x3e, 0x3d, 0x13, 0xcd, 0x3c, 0xaa, 0xc1, 0x0e, 0x57, 0xf6, 0x4e, 0xac, 0xa4, 0x53, 0x13, 0xf7,
	0x2e, 0xb4, 0x15, 0x76, 0xa2, 0x88, 0x8e, 0xf3, 0xaa, 0x55, 0xa6, 0x4a, 0x40, 0x29, 0x17, 0x57,
	0xad, 0xa1, 0x3d, 0xd8, 0x4d, 0x51, 0x59, 0xdd, 0x3a, 0x83, 0x3d, 0x6e, 0x1f, 0x9b, 0xbd, 0x76,
	0x77, 0x60, 0x35, 0x8d, 0xc1, 0x85, 0x61, 0x74, 0x99, 0x96, 0x9d, 0x46, 0x65, 0x28, 0x74, 0x7b,
	0x7d, 0xc3, 0x1a, 0xb4, 0x4d, 0xad, 0xc0, 0xc6, 0x78, 0x6e, 0x9a, 0x06, 0xb6, 0x3a, 0x6d, 0x53,
	0x2b, 0xb2, 0x66, 0xa7, 0x77, 0x21, 0x9b, 0xc0, 0x4e, 0xae, 0xc7, 0xbd, 0xf3, 0xc1, 0x19, 0x1f,
	0x95, 0x56, 0x42, 0x55, 0x28, 0x89, 0x36, 0xb7, 0xa7, 0x95, 0x91, 0x06, 0x65, 0x21, 0x68, 0x19,
	0xdd, 0x81, 0x81, 0xb5, 0x4d, 0x74, 0x0b, 0xb6, 0x38, 0x7d, 0xb3, 0x37, 0x18, 0xf4, 0x1e, 0xcb,
	0x8e, 0x15, 0xe6, 0x2f, 0x55, 0xcc, 0xf9, 0xaa, 0xec, 0xf0, 0x56, 0xa5, 0x92, 0x44, 0x4b, 0x67,
	0x6d, 0x3c, 0x31, 0xac, 0x41, 0xcf, 0xb4, 0x9a, 0xbd, 0xf3, 0xee, 0x71, 0x03, 0x3f, 0xd1, 0xb6,
	0x32, 0x2a, 0x31, 0xeb, 0x56, 0x0f, 0x77, 0x0d, 0xac, 0x21, 0x74, 0x17, 0x6a, 0xa9, 0x4a, 0x32,
	0xa6, 0xc0, 0xed, 0xd4, 0xfd, 0x4c, 0xcb, 0x3f, 0x24, 0x6e, 0x67, 0xe6, 0xc8, 0x97, 0xcc, 0xdd,
	0xca, 0xea, 0x32, 0xf6, 0x76, 0xd1, 0x3d, 0xb8, 0x3d, 0xd3, 0xcd, 0x1b, 0x7c, 0x77, 0x16, 0xd5,
	0x79, 0x8b, 0x35, 0x74, 0x1f, 0xee, 0xa8, 0x71, 0xb6, 0x44, 0x08, 0x92, 0x88, 0x69, 0xb7, 0xd1,
	0x3e, 0xdc, 0xcd, 0x84, 0x74, 0xbe, 0xc7, 0x1e, 0x73, 0xa8, 0xa0, 0x68, 0x60, 0x6b, 0x80, 0x1b,
	0xa7, 0xac, 0x8e, 0xb8, 0xc3, 0xbc, 0x2f, 0x71, 0x8a, 0xf8, 0x2e, 0x2f, 0x86, 0x92, 0xb9, 0x9b,
	0xe7, 0x66, 0xbb, 0xa3, 0xdd, 0x63, 0xc5, 0xd0, 0x6c, 0x78, 0x42, 0xf8, 0x1e, 0xc3, 0x9f, 0xf4,
	0xb0, 0x71, 0x66, 0x34, 0x8e, 0xad, 0x53, 0x5e, 0x2b, 0x75, 0x1a, 0xda, 0x7d, 0x56, 0xb1, 0xb4,
	0xce, 0xda, 0x5d, 0xeb, 0xb4, 0xdb, 0x18, 0x9c, 0x31, 0xca, 0x7d, 0x66, 0x9f, 0x8b, 0x38, 0xef,
	0x69, 0xaf, 0xcb, 0xa4, 0xef, 0x33, 0x3c, 0x97, 0x0a, 0x66, 0x29, 0xd6, 0xf5, 0x5f, 0x40, 0xb9,
	0x43, 0x1d, 0x9e, 0x9b, 0x6d, 0x7f, 0x44, 0xd1, 0x47, 0xb0, 0xe1, 0xd9, 0xb1, 0xe5, 0xf9, 0x63,
	0x59, 0x1e, 0x6c, 0x27, 0xa9, 0xc8, 0x52, 0xb5, 0xde, 0xb1, 0xe3, 0x8e, 0x3f, 0xc6, 0xeb, 0x1e,
	0xff, 0xd5, 0x2f, 0xa0, 0x60, 0x86, 0x34, 0x20, 0x61, 0x7c, 0x8d, 0x10, 0xac, 0xfa, 0xf6, 0x84,
	0xc8, 0x82, 0x88, 0x7f, 0xb3, 0x5a, 0xf2, 0xb9, 0xed, 0x4d, 0x89, 0xac, 0x82, 0x44, 0x03, 0xbd,
	0x0f, 0xe5, 0xa9, 0xeb, 0xc7, 0x9f, 0x7c, 0x6c, 0x09, 0x25, 0xdb, 0x48, 0x56, 0x71, 0x49, 0xc8,
	0xbe, 0x60, 0x22, 0xfd, 0xf7, 0x2b, 0xa0, 0x19, 0x7e, 0xec, 0xc6, 0xd7, 0x4a, 0x01, 0xa3, 0xc1,
	0xca, 0xc4, 0x1d, 0x4a, 0x03, 0xec, 0x13, 0xed, 0xc2, 0xba, 0x47, 0x1d, 0xdb, 0x4b, 0x0c, 0xc8,
	0x16, 0xda, 0x87, 0xd2, 0x90, 0x44, 0x4e, 0xe8, 0x06, 0x7c, 0x53, 0x11, 0x95, 0xac, 0x2a, 0x62,
	0x23, 0x8b, 0x1c, 0x1a, 0x26, 0x85, 0x80, 0x68, 0xa0, 0xf7, 0x00, 0x94, 0x93, 0x58, 0x54, 0x01,
	0x8a, 0x84, 0xe9, 0x63, 0x1a, 0xb8, 0x8e, 0xed, 0xb9, 0xf1, 0xb5, 0xac, 0x03, 0x14, 0xc9, 0xcb,
	0x25, 0xd6, 0xc6, 0x7f, 0x5b, 0x62, 0xb5, 0xa1, 0xe8, 0xc9, 0xf8, 0x44, 0xb5, 0x02, 0xaf, 0x85,
	0x16, 0xb1, 0xa9, 0xf1, 0xc4, 0x33, 0x34, 0x3a, 0x05, 0x08, 0x44, 0xb0, 0x5c, 0x12, 0xd5, 0x8a,
	0x9c, 0x6b, 0xe1, 0x46, 0x2b, 0xa3, 0x8b, 0x15, 0xa8, 0xfe, 0xb7, 0x3c, 0xec, 0xf4, 0xed, 0x11,
	0xe9, 0x13, 0x3b, 0x74, 0x9e, 0x29, 0x01, 0xfa, 0x0c, 0xd6, 0xec, 0xe1, 0xd4, 0x8b, 0xe5, 0xed,
	0x64, 0x89, 0x43, 0x47, 0xe0, 0x18, 0x41, 0x14, 0x50, 0x3a, 0xe2, 0xe1, 0x5c, 0x8e, 0x80, 0xe3,
	0x50, 0x0b, 0x36, 0x26, 0x64, 0xc8, 0xc2, 0x21, 0x8f, 0xa7, 0x25, 0x28, 0x12, 0x24, 0x32, 0xa0,
	0xf0, 0xdc, 0xa5, 0x1e, 0x5f, 0x03, 0xab, 0xcb, 0xb2, 0xa4, 0x50, 0xf4, 0x4b, 0x58, 0x0d, 0x6d,
	0xe7, 0x7a, 0xf9, 0x0a, 0x8d, 0xc3, 0xf4, 0x17, 0x50, 0x62, 0xd9, 0x46, 0xfd, 0x31, 0x26, 0x4e,
	0x8c, 0x1e, 0x42, 0x69, 0xe2, 0xfa, 0xd6, 0x0d, 0x92, 0xb3, 0x38, 0x71, 0x7d, 0xf1, 0xc9, 0x41,
	0xf6, 0x55, 0x0a, 0xca, 0xbf, 0x09, 0x64, 0x5f, 0x89, 0x4f, 0x3d, 0x84, 0x62, 0x8b, 0xdd, 0x4b,
	0xf9, 0x7e, 0x70, 0x00, 0x6b, 0xfc, 0x92, 0x2a, 0x0d, 0xa2, 0x0c, 0x96, 0x77, 0xc3, 0xa2, 0xc3,
	0x2c, 0xa3, 0xf2, 0x6a, 0x46, 0x7d, 0x00, 0x95, 0xc0, 0xbd, 0x22, 0x9e, 0x35, 0x0a, 0x6d, 0x27,
	0x4d, 0xc6, 0x3c, 0xde, 0xe4, 0xd2, 0x13, 0x29, 0xd4, 0xbf, 0x82, 0xda, 0x31, 0x9d, 0xb8, 0xbe,
	0xed, 0xc7, 0x9c, 0x34, 0x52, 0x56, 0xd5, 0xaf, 0x60, 0x9d, 0x5b, 0x88, 0x6a, 0x39, 0xbe, 0x66,
	0x0f, 0x16, 0x78, 0x32, 0x1d, 0x3c, 0x96, 0x38, 0x3d, 0x82, 0x2a, 0xbf, 0x23, 0x99, 0xe9, 0x1a,
	0x46, 0xbf, 0x81, 0xea, 0x50, 0x1a, 0xb4, 0x52, 0x76, 0x36, 0xc3, 0x9f, 0x2d, 0x60, 0x7f, 0xdd,
	0x30, 0x71, 0x65, 0x98, 0xd1, 0xe8, 0x7f, 0xcc, 0x41, 0xa1, 0x15, 0xd2, 0xe0, 0xcc, 0xf5, 0xe3,
	0xff, 0xc1, 0xdd, 0x2b, 0xbb, 0x55, 0xe5, 0x5f, 0xda, 0xaa, 0x0e, 0x61, 0xdb, 0x9d, 0x04, 0x34,
	0x8c, 0x6d, 0xdf, 0x21, 0xf3, 0xde, 0x47, 0x33, 0x55, 0x1a, 0x82, 0x5f, 0xc3, 0x76, 0x32, 0x5c,
	0xd5, 0xfb, 0x27, 0x00, 0x4e, 0x48, 0x03, 0xeb, 0x19, 0x93, 0xcb, 0x08, 0x2c, 0xda, 0x35, 0x12,
	0x1e, 0x5c, 0x74, 0x12, 0x46, 0xfd, 0x13, 0xa8, 0xa6, 0xf4, 0xa6, 0x1d, 0xda, 0x93, 0x08, 0xfd,
	0x1f, 0x6c, 0xda, 0x51, 0x40, 0x9c, 0xd8, 0x0a, 0x99, 0x2d, 0xc1, 0x9e, 0xc7, 0x65, 0x21, 0xc4,
	0x5c, 0xa6, 0x1f, 0x03, 0xba, 0x20, 0x97, 0xc7, 0xc9, 0x15, 0x4a, 0x42, 0xeb, 0xb0, 0xed, 0xfa,
	0x8e, 0x37, 0x1d, 0x12, 0x6b, 0x4c, 0x68, 0xe6, 0x35, 0xa3, 0x80, 0xb7, 0xa4, 0xea, 0x94, 0x50,
	0xf9, 0xa8, 0xa1, 0x7f, 0x9f, 0x87, 0x32, 0x5f, 0x02, 0x2d, 0x76, 0xc7, 0xbe, 0x8a, 0x51, 0x17,
	0x36, 0x79, 0x56, 0x50, 0x7f, 0x6c, 0x85, 0xc4, 0x89, 0x65, 0x40, 0x16, 0x5d, 0xb5, 0x95, 0x8c,
	0xc4, 0x25, 0x4f, 0x49, 0xcf, 0x0f, 0xa0, 0xe2, 0xd9, 0xfe, 0x78, 0xca, 0xae, 0xfd, 0xc2, 0x55,
	0xf9, 0xfd, 0x95, 0x83, 0x22, 0xde, 0x4c, 0xa4, 0x7c, 0xe2, 0xe8, 0x29, 0x6c, 0xcd, 0xbc, 0x69,
	0x05, 0x7c, 0x32, 0xb2, 0xe6, 0xad, 0xdf, 0xd0, 0xa9, 0xd2, 0x7b, 0xb8, 0xea, 0xcc, 0xb9, 0xd3,
	0x81, 0x9d, 0xcc, 0x4b, 0x54, 0x42, 0xbf, 0xce, 0xe9, 0x1f, 0x2c, 0xa0, 0x7f, 0xd9, 0xc9, 0x18,
	0xbd, 0x78, 0x49, 0xa6, 0xff, 0x23, 0x07, 0x3b, 0x72, 0x75, 0x10, 0xee, 0x50, 0x4c, 0xbe, 0x9d,
	0x92, 0x28, 0x46, 0x8f, 0x60, 0x8d, 0xbf, 0x71, 0x48, 0x47, 0xfe, 0xff, 0x4d, 0xde, 0x2c, 0xb0,
	0x80, 0xa0, 0x26, 0x14, 0x46, 0xe2, 0xa5, 0x4a, 0xb8, 0xad, 0x74, 0xf4, 0x83, 0x9b, 0x3d, 0x6c,
	0xe1, 0x14, 0xc7, 0x32, 0x4c, 0x3c, 0xba, 0x38, 0x22, 0xc2, 0x7c, 0xa5, 0x2f, 0xce, 0x30, 0x75,
	0x51, 0xe0, 0xb2, 0xab, 0xb4, 0xf4, 0xdf, 0x16, 0xe0, 0xd6, 0xdc, 0x54, 0xa3, 0x80, 0xfa, 0x11,
	0x41, 0x5f, 0x82, 0x36, 0xb2, 0x1d, 0xa2, 0x3c, 0x14, 0x26, 0x99, 0xf1, 0x93, 0xa5, 0x6e, 0x43,
	0xb8, 0x3a, 0xca, 0xb4, 0x23, 0x74, 0x09, 0x3b, 0xc9, 0xc5, 0x3f, 0xc3, 0x2e, 0xbc, 0x72, 0xb8,
	0x80, 0x7d, 0xbe, 0x62, 0xc2, 0xdb, 0x09, 0x99, 0x6a, 0xe3, 0x29, 0x68, 0x1e, 0x1d, 0xd3, 0x0c,
	0xff, 0xca, 0xdb, 0xf1, 0x57, 0x19, 0x91, 0xca, 0xfd, 0x15, 0x6c, 0x79, 0xf6, 0x25, 0xf1, 0x32,
	0xe4, 0xab, 0x6f, 0x47, 0xae, 0x71, 0xa6, 0xb9, 0x91, 0xcf, 0x3d, 0xd0, 0x46, 0xb5, 0xb5, 0xb7,
	0x1c, 0x39, 0x23, 0x52, 0xb9, 0x2d, 0xd8, 0x19, 0x4d, 0x3d, 0xcf, 0x9a, 0x33, 0xc0, 0x9f, 0x16,
	0x16, 0xc7, 0x75, 0x90, 0x61, 0xc3, 0x88, 0x51, 0x65, 0x65, 0xc8, 0x85, 0xdd, 0xc8, 0x1e, 0x11,
	0x2b, 0xe2, 0x55, 0x93, 0x6a, 0x42, 0x24, 0xe8, 0xc3, 0x05, 0x26, 0x5e, 0x55, 0x71, 0xe1, 0x9d,
	0xe8, 0x55, 0x75, 0x98, 0x0f, 0x77, 0x44, 0x2e, 0xcc, 0x8a, 0x36, 0xd5, 0x5e, 0xe1, 0x46, 0xfb,
	0xcd, 0xdc, 0x89, 0x89, 0x6f, 0xbb, 0x59, 0x81, 0x62, 0x6f, 0x04, 0xb7, 0x94, 0x5d, 0x4d, 0xb1,
	0x54, 0xe2, 0x96, 0x8e, 0x6e, 0xba, 0xb3, 0xa9, 0x2b, 0xd7, 0x79, 0xc5, 0x59, 0x64, 0xc2, 0x66,
	0x66, 0x87, 0xe3, 0xcf, 0x32, 0x8b, 0x73, 0x5c, 0xdd, 0xda, 0x70, 0x59, 0xdd, 0xd4, 0x58, 0x79,
	0x43, 0xc2, 0x90, 0x86, 0xbc, 0x48, 0x53, 0xca, 0x9b, 0x30, 0x70, 0xea, 0x7d, 0xfe, 0x6c, 0x8f,
	0x45, 0x07, 0x7d, 0x02, 0x7b, 0x4d, 0x3b, 0x4e, 0xdd, 0x2c, 0x76, 0x84, 0x28, 0xd9, 0xfd, 0x7a,
	0x50, 0x08, 0xc5, 0x67, 0xb2, 0x13, 0x2c, 0x0a, 0xe7, 0xab, 0x36, 0x51, 0x9c, 0x92, 0xe8, 0xdf,
	0xc2, 0x9d, 0x57, 0x9a, 0x93, 0x3b, 0x10, 0x86, 0x62, 0x28, 0xbf, 0x13, 0x83, 0x1f, 0x2f, 0x67,
	0x50, 0x80, 0xf1, 0x8c, 0xe6, 0x43, 0x02, 0xa0, 0x3c, 0x27, 0x95, 0x60, 0x43, 0x3e, 0xa3, 0x68,
	0xef, 0xb0, 0x5b, 0xe6, 0x17, 0x06, 0x7e, 0x62, 0x9d, 0x77, 0x3b, 0xed, 0xcf, 0x8d, 0xce, 0x13,
	0x2d, 0x87, 0xca, 0x50, 0x48, 0x5b, 0x79, 0xd6, 0x32, 0x7b, 0xfd, 0x7e, 0xbb, 0xd9, 0x31, 0xb4,
	0x15, 0x04, 0xb0, 0x2e, 0x35, 0xab, 0xa8, 0x0a, 0x25, 0x0e, 0x95, 0x82, 0xb5, 0xa3, 0xef, 0x73,
	0x50, 0xe1, 0x63, 0x68, 0x24, 0xff, 0x02, 0xa1, 0x3f, 0xe5, 0x60, 0xfb, 0x15, 0xb3, 0x45, 0x3f,
	0x5f, 0x54, 0x1e, 0xbd, 0x36, 0x20, 0x7b, 0x8f, 0xde, 0x06, 0x2a, 0x3c, 0xa1, 0x7f, 0xf0, 0xdd,
	0x5f, 0xfe, 0xfe, 0xbb, 0xfc, 0x7d, 0x7d, 0x6f, 0xfe, 0x8f, 0xab, 0xe8, 0x91, 0x5c, 0xdb, 0xe4,
	0x51, 0xee, 0xc3, 0xe6, 0x77, 0x39, 0x78, 0xdf, 0xa1, 0x93, 0x37, 0x1b, 0x6a, 0x6e, 0x67, 0xe7,
	0x6a, 0x86, 0x34, 0xa6, 0x66, 0xee, 0x69, 0x4b, 0xa2, 0xc6, 0x94, 0x15, 0x08, 0x75, 0x1a, 0x8e,
	0x0f, 0xc7, 0xc4, 0xe7, 0xff, 0xf7, 0x1c, 0x0a, 0x95, 0x1d, 0xb8, 0xd1, 0x6b, 0xfe, 0x71, 0xfa,
	0x54, 0x08, 0xfe, 0x95, 0xcb, 0x5d, 0xae, 0x73, 0xc8, 0xc3, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff,
	0xb8, 0x10, 0xf5, 0x85, 0x78, 0x1b, 0x00, 0x00,
}
