// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1/cloud_redis.proto

package redis // import "google.golang.org/genproto/googleapis/cloud/redis/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
	// Redis instance is failing over (availability may be affected).
	Instance_FAILING_OVER Instance_State = 9
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "UPDATING",
	4: "DELETING",
	5: "REPAIRING",
	6: "MAINTENANCE",
	9: "FAILING_OVER",
}
var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
	"FAILING_OVER":      9,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}
var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}
func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{0, 1}
}

type FailoverInstanceRequest_DataProtectionMode int32

const (
	FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED FailoverInstanceRequest_DataProtectionMode = 0
	// Instance failover will be protected with data loss control. More
	// specifically, the failover will only be performed if the current
	// replication offset diff between master and replica is under a certain
	// threshold.
	FailoverInstanceRequest_LIMITED_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 1
	// Instance failover will be performed without data loss control.
	FailoverInstanceRequest_FORCE_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 2
)

var FailoverInstanceRequest_DataProtectionMode_name = map[int32]string{
	0: "DATA_PROTECTION_MODE_UNSPECIFIED",
	1: "LIMITED_DATA_LOSS",
	2: "FORCE_DATA_LOSS",
}
var FailoverInstanceRequest_DataProtectionMode_value = map[string]int32{
	"DATA_PROTECTION_MODE_UNSPECIFIED": 0,
	"LIMITED_DATA_LOSS":                1,
	"FORCE_DATA_LOSS":                  2,
}

func (x FailoverInstanceRequest_DataProtectionMode) String() string {
	return proto.EnumName(FailoverInstanceRequest_DataProtectionMode_name, int32(x))
}
func (FailoverInstanceRequest_DataProtectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{7, 0}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id] and
	// [alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. If [alternative_location_id] is also provided, it must be
	// different from [location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used. Updating the
	// version will perform an upgrade/downgrade to the new version. Currently,
	// the supported values are `REDIS_3_2` for Redis 3.2.
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in an authorized network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed Redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. For Basic
	// Tier instances, this will always be the same as the [location_id]
	// provided by the user at creation time. For Standard Tier instances,
	// this can be either [location_id] or [alternative_location_id] and can
	// change after a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//
	//  *   maxmemory-policy
	//  *   notify-keyspace-events
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GiB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork    string   `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{0}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (dst *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(dst, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

// Request for [ListInstances][google.cloud.redis.v1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudRedis.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{1}
}
func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(dst, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for [ListInstances][google.cloud.redis.v1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the "name" field set to a value of
	// the form projects/{project_id}/locations/{location_id}/instances/- and the
	// "status" field set to ERROR and "status_message" field set to "location not
	// available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{2}
}
func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(dst, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.redis.v1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{3}
}
func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(dst, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [CreateInstance][google.cloud.redis.v1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{4}
}
func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(dst, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [UpdateInstance][google.cloud.redis.v1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][CloudRedis.Instance]:
	//
	//  *   `displayName`
	//  *   `labels`
	//  *   `memorySizeGb`
	//  *   `redisConfig`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{5}
}
func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(dst, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [DeleteInstance][google.cloud.redis.v1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{6}
}
func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(dst, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [Failover][google.cloud.redis.v1.CloudRedis.FailoverInstance].
type FailoverInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Available data protection modes that the user can choose. If it's
	// unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
	DataProtectionMode   FailoverInstanceRequest_DataProtectionMode `protobuf:"varint,2,opt,name=data_protection_mode,json=dataProtectionMode,proto3,enum=google.cloud.redis.v1.FailoverInstanceRequest_DataProtectionMode" json:"data_protection_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *FailoverInstanceRequest) Reset()         { *m = FailoverInstanceRequest{} }
func (m *FailoverInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*FailoverInstanceRequest) ProtoMessage()    {}
func (*FailoverInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{7}
}
func (m *FailoverInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailoverInstanceRequest.Unmarshal(m, b)
}
func (m *FailoverInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailoverInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *FailoverInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailoverInstanceRequest.Merge(dst, src)
}
func (m *FailoverInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_FailoverInstanceRequest.Size(m)
}
func (m *FailoverInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FailoverInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FailoverInstanceRequest proto.InternalMessageInfo

func (m *FailoverInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FailoverInstanceRequest) GetDataProtectionMode() FailoverInstanceRequest_DataProtectionMode {
	if m != nil {
		return m.DataProtectionMode
	}
	return FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED
}

// Represents the v1 metadata of the long-running operation.
type OperationMetadata struct {
	// Creation timestamp.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// End timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Operation target.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Operation verb.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Operation status details.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Specifies if cancellation was requested for the operation.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// API version.
	ApiVersion           string   `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{8}
}
func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (dst *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(dst, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *OperationMetadata) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *OperationMetadata) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

func (m *OperationMetadata) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *OperationMetadata) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *OperationMetadata) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{9}
}
func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (dst *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(dst, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_redis_873de735ea398aa9, []int{10}
}
func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (dst *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(dst, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1.DeleteInstanceRequest")
	proto.RegisterType((*FailoverInstanceRequest)(nil), "google.cloud.redis.v1.FailoverInstanceRequest")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.redis.v1.OperationMetadata")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1.ZoneMetadata")
	proto.RegisterEnum("google.cloud.redis.v1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
	proto.RegisterEnum("google.cloud.redis.v1.FailoverInstanceRequest_DataProtectionMode", FailoverInstanceRequest_DataProtectionMode_name, FailoverInstanceRequest_DataProtectionMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc *grpc.ClientConn
}

func NewCloudRedisClient(cc *grpc.ClientConn) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/FailoverInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Failover the master role to current replica node against a specific
	// STANDARD tier redis instance.
	FailoverInstance(context.Context, *FailoverInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_FailoverInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).FailoverInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/FailoverInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).FailoverInstance(ctx, req.(*FailoverInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "FailoverInstance",
			Handler:    _CloudRedis_FailoverInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1/cloud_redis.proto",
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1/cloud_redis.proto", fileDescriptor_cloud_redis_873de735ea398aa9)
}

var fileDescriptor_cloud_redis_873de735ea398aa9 = []byte{
	// 1500 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x57, 0xc1, 0x6e, 0xdb, 0x46,
	0x13, 0xfe, 0x29, 0x5b, 0x8e, 0x35, 0x92, 0x65, 0x7a, 0x63, 0x25, 0x8c, 0xfe, 0x06, 0x56, 0x99,
	0xa4, 0x75, 0x9c, 0x46, 0x82, 0x5d, 0x24, 0x48, 0x6c, 0x04, 0x01, 0x2d, 0xd1, 0x0e, 0x01, 0x5b,
	0x36, 0x28, 0xc5, 0x40, 0x73, 0x21, 0xd6, 0xe2, 0x5a, 0x61, 0x4c, 0x91, 0x2c, 0xb9, 0x52, 0x6b,
	0x17, 0xb9, 0x14, 0xe8, 0xa5, 0x40, 0x81, 0x16, 0xed, 0xb9, 0x68, 0x81, 0x00, 0x7d, 0x99, 0xa2,
	0x97, 0xbe, 0x40, 0x0f, 0x7d, 0x90, 0x62, 0x77, 0x49, 0x5b, 0x92, 0x25, 0xc8, 0xba, 0xed, 0x7c,
	0x33, 0xc3, 0xfd, 0x34, 0xb3, 0xfb, 0xcd, 0x0a, 0x3e, 0x6d, 0xfb, 0x7e, 0xdb, 0x25, 0x95, 0x96,
	0xeb, 0x77, 0xed, 0x4a, 0x48, 0x6c, 0x27, 0xaa, 0xf4, 0xd6, 0x85, 0x69, 0x71, 0xb3, 0x1c, 0x84,
	0x3e, 0xf5, 0x51, 0x41, 0x04, 0x96, 0xb9, 0xa7, 0x2c, 0x3c, 0xbd, 0xf5, 0xe2, 0x47, 0x71, 0x3e,
	0x0e, 0x9c, 0x0a, 0xf6, 0x3c, 0x9f, 0x62, 0xea, 0xf8, 0x5e, 0x9c, 0x54, 0xbc, 0xd3, 0xe7, 0x0d,
	0x49, 0xe4, 0x77, 0xc3, 0x16, 0x89, 0x5d, 0xf7, 0x62, 0x97, 0xeb, 0x7b, 0xed, 0xb0, 0xeb, 0x79,
	0x8e, 0xd7, 0xae, 0xf8, 0x01, 0x09, 0x07, 0xf2, 0x4b, 0x71, 0x10, 0xb7, 0x8e, 0xbb, 0x27, 0x95,
	0x13, 0x87, 0xb8, 0xb6, 0xd5, 0xc1, 0xd1, 0x69, 0x1c, 0xb1, 0x32, 0x1c, 0x41, 0x9d, 0x0e, 0x89,
	0x28, 0xee, 0x04, 0x22, 0x40, 0xfd, 0x6b, 0x1e, 0xe6, 0x0d, 0x2f, 0xa2, 0xd8, 0x6b, 0x11, 0x84,
	0x60, 0xd6, 0xc3, 0x1d, 0xa2, 0x48, 0x25, 0x69, 0x35, 0x63, 0xf2, 0x35, 0xfa, 0x18, 0x72, 0xb6,
	0x13, 0x05, 0x2e, 0x3e, 0xb3, 0xb8, 0x2f, 0xc5, 0x7d, 0xd9, 0x18, 0xab, 0xb3, 0x90, 0x2a, 0xcc,
	0xb9, 0xf8, 0x98, 0xb8, 0x91, 0x32, 0x53, 0x9a, 0x59, 0xcd, 0x6e, 0x3c, 0x2a, 0x8f, 0x2c, 0x46,
	0x39, 0xd9, 0xa7, 0xbc, 0xc7, 0xa3, 0x75, 0x8f, 0x86, 0x67, 0x66, 0x9c, 0x8a, 0x56, 0x20, 0xeb,
	0xfa, 0x2d, 0xfe, 0xf3, 0x2c, 0xc7, 0x56, 0x66, 0xf9, 0x36, 0x90, 0x40, 0x86, 0x8d, 0x9e, 0xc2,
	0x6d, 0xec, 0x52, 0x12, 0x7a, 0x98, 0x3a, 0x3d, 0x62, 0xf5, 0x07, 0xa7, 0x79, 0x70, 0xa1, 0xcf,
	0xbd, 0x77, 0x99, 0x77, 0x0f, 0x16, 0x38, 0x03, 0xab, 0x47, 0xc2, 0xc8, 0xf1, 0x3d, 0xe5, 0x06,
	0x8f, 0xce, 0x71, 0xf0, 0x48, 0x60, 0x68, 0x0d, 0x96, 0x42, 0x12, 0x91, 0xb0, 0x47, 0x6c, 0xcb,
	0x09, 0xac, 0x10, 0x7b, 0x6d, 0xa2, 0x64, 0x78, 0xe0, 0x62, 0xe2, 0x30, 0x02, 0x93, 0xc1, 0xac,
	0x4a, 0x6f, 0xfd, 0x88, 0x2a, 0x20, 0xaa, 0xc4, 0xd6, 0x0c, 0x0b, 0xfc, 0x90, 0x2a, 0xd9, 0x92,
	0xb4, 0x9a, 0x36, 0xf9, 0x1a, 0x95, 0xe1, 0x66, 0xab, 0x1b, 0x86, 0xc4, 0xa3, 0x03, 0x64, 0x73,
	0x3c, 0x6d, 0x29, 0x76, 0xf5, 0x11, 0xdd, 0x82, 0x6c, 0x2b, 0x24, 0x98, 0x12, 0x8b, 0x35, 0x49,
	0x59, 0x28, 0x49, 0xab, 0xd9, 0x8d, 0x62, 0x52, 0xcb, 0xa4, 0x83, 0xe5, 0x66, 0xd2, 0x41, 0x13,
	0x44, 0x38, 0x03, 0xd0, 0x16, 0xa4, 0x23, 0x8a, 0x29, 0x51, 0xf2, 0x25, 0x69, 0x35, 0xbf, 0xf1,
	0x60, 0x52, 0x0b, 0x1a, 0x2c, 0xd8, 0x14, 0x39, 0xe8, 0x01, 0xe4, 0xd9, 0xa2, 0x1b, 0x59, 0x1d,
	0x12, 0x45, 0xb8, 0x4d, 0x94, 0x45, 0x4e, 0x72, 0x41, 0xa0, 0xfb, 0x02, 0x44, 0x47, 0x49, 0x25,
	0x5b, 0xbe, 0x77, 0xe2, 0xb4, 0x23, 0x45, 0xe6, 0xed, 0x5e, 0x9f, 0xb4, 0x97, 0xc9, 0x90, 0xaa,
	0xc8, 0x11, 0x4d, 0x17, 0xc5, 0x8f, 0x21, 0xf4, 0x0c, 0x66, 0xa9, 0x43, 0x42, 0x65, 0x89, 0x53,
	0xbf, 0x3f, 0xe9, 0x73, 0x4d, 0x87, 0x84, 0x26, 0xcf, 0x40, 0xf7, 0x21, 0xdf, 0x21, 0x1d, 0x3f,
	0x3c, 0xb3, 0x22, 0xe7, 0x9c, 0x58, 0xed, 0x63, 0x05, 0xf1, 0x06, 0xe4, 0x04, 0xda, 0x70, 0xce,
	0xc9, 0xee, 0x31, 0x7a, 0x0c, 0x08, 0x77, 0xe9, 0x5b, 0x3f, 0x74, 0xce, 0x89, 0x6d, 0x79, 0x84,
	0x7e, 0xe5, 0x87, 0xa7, 0xca, 0xb2, 0xe8, 0xc3, 0xa5, 0xa7, 0x2e, 0x1c, 0xc5, 0xe7, 0x90, 0xed,
	0x3b, 0xa0, 0x48, 0x86, 0x99, 0x53, 0x72, 0x16, 0xdf, 0x09, 0xb6, 0x44, 0xcb, 0x90, 0xee, 0x61,
	0xb7, 0x9b, 0xdc, 0x05, 0x61, 0x6c, 0xa6, 0x9e, 0x49, 0xc5, 0x97, 0xb0, 0x74, 0xe5, 0xc7, 0x4e,
	0xf3, 0x01, 0xf5, 0x3b, 0x09, 0xd2, 0xbc, 0x35, 0xa8, 0x00, 0x4b, 0x8d, 0xa6, 0xd6, 0xd4, 0xad,
	0xd7, 0xf5, 0xc6, 0xa1, 0x5e, 0x35, 0x76, 0x0c, 0xbd, 0x26, 0xff, 0x0f, 0xe5, 0x60, 0xbe, 0x6a,
	0xea, 0x5a, 0xd3, 0xa8, 0xef, 0xca, 0x12, 0xca, 0x40, 0xda, 0xd4, 0xb5, 0xda, 0x17, 0x72, 0x8a,
	0x39, 0x5e, 0x1f, 0xd6, 0x84, 0x63, 0x86, 0x59, 0x35, 0x7d, 0x4f, 0xe7, 0xd6, 0x2c, 0x5a, 0x80,
	0x8c, 0xa9, 0x1f, 0x6a, 0x86, 0xc9, 0xcc, 0x34, 0x5a, 0x84, 0xec, 0xbe, 0x66, 0xd4, 0x9b, 0x7a,
	0x5d, 0xab, 0x57, 0x75, 0x79, 0x0e, 0xc9, 0x90, 0xdb, 0xd1, 0x8c, 0x3d, 0xa3, 0xbe, 0x6b, 0x1d,
	0x1c, 0xe9, 0xa6, 0x9c, 0x51, 0x9f, 0xc1, 0x2c, 0x2b, 0x33, 0x5a, 0x06, 0xb9, 0x69, 0xe8, 0xe6,
	0x10, 0x89, 0x0c, 0xa4, 0xb7, 0xb5, 0x86, 0x51, 0x95, 0x25, 0xf6, 0xad, 0x46, 0x53, 0xab, 0xd7,
	0x34, 0xb3, 0x66, 0xbd, 0xd2, 0xe4, 0x19, 0xf5, 0x1d, 0x2c, 0xef, 0x39, 0x11, 0x4d, 0xba, 0x15,
	0x99, 0xe4, 0xcb, 0x2e, 0x89, 0x28, 0xba, 0x05, 0x73, 0x01, 0x66, 0x27, 0x3e, 0x2e, 0x44, 0x6c,
	0xa1, 0xff, 0x43, 0x26, 0xc0, 0x6d, 0xc2, 0x1b, 0xc8, 0xeb, 0x91, 0x36, 0xe7, 0x19, 0xc0, 0x7a,
	0x87, 0xee, 0x02, 0x70, 0x27, 0xf5, 0x4f, 0x89, 0xa7, 0xcc, 0xf0, 0x44, 0x1e, 0xde, 0x64, 0x80,
	0xfa, 0x9b, 0x04, 0x85, 0xa1, 0xcd, 0xa2, 0xc0, 0xf7, 0x22, 0x82, 0x5e, 0x40, 0xc6, 0x49, 0x40,
	0x45, 0xe2, 0xc7, 0x74, 0x65, 0xc2, 0xb9, 0x32, 0x2f, 0x33, 0xd0, 0x27, 0xb0, 0xe8, 0x91, 0xaf,
	0xa9, 0xd5, 0xb7, 0xb9, 0x68, 0xd5, 0x02, 0x83, 0x0f, 0x13, 0x02, 0xa8, 0x04, 0xd9, 0xae, 0x17,
	0x12, 0xdc, 0x7a, 0x8b, 0x8f, 0x5d, 0xc2, 0xe5, 0x2f, 0x63, 0xf6, 0x43, 0xea, 0x2a, 0xa0, 0x5d,
	0x72, 0x41, 0x30, 0x29, 0xc6, 0x08, 0xa1, 0x55, 0x7f, 0x90, 0xa0, 0x50, 0xe5, 0x17, 0x7a, 0x38,
	0x7a, 0x5c, 0xe9, 0x56, 0x20, 0x9b, 0x50, 0x66, 0xc2, 0x22, 0x18, 0x42, 0x02, 0x71, 0x45, 0x99,
	0x4f, 0x2c, 0x5e, 0xbc, 0x6b, 0x14, 0xe1, 0x22, 0x41, 0xfd, 0x49, 0x82, 0xc2, 0xeb, 0xc0, 0x1e,
	0xc1, 0x67, 0x0b, 0xb2, 0x5d, 0xee, 0xe0, 0x93, 0x86, 0x93, 0x1a, 0x25, 0x54, 0x3b, 0x6c, 0x18,
	0xed, 0xe3, 0xe8, 0xd4, 0x04, 0x11, 0xce, 0xd6, 0x03, 0x9c, 0x52, 0xd3, 0x72, 0x7a, 0x04, 0x85,
	0x1a, 0x71, 0xc9, 0x55, 0x4a, 0xa3, 0x0a, 0xfa, 0x7d, 0x0a, 0x6e, 0xef, 0x60, 0xc7, 0xf5, 0x7b,
	0x24, 0xbc, 0x46, 0x3c, 0x8a, 0x60, 0xd9, 0xc6, 0x14, 0x5b, 0xec, 0x07, 0x90, 0x16, 0x97, 0xeb,
	0x8e, 0x6f, 0x0b, 0x96, 0xf9, 0x0d, 0x6d, 0x0c, 0xcb, 0x31, 0x3b, 0x94, 0x6b, 0x98, 0xe2, 0xc3,
	0x8b, 0x2f, 0xed, 0xfb, 0x36, 0x31, 0x91, 0x7d, 0x05, 0x53, 0x4f, 0x00, 0x5d, 0x8d, 0x44, 0xf7,
	0xa1, 0x54, 0xd3, 0x9a, 0x9a, 0x75, 0x68, 0x1e, 0x34, 0xf5, 0x6a, 0xd3, 0x38, 0xa8, 0x5b, 0xfb,
	0x07, 0xb5, 0x61, 0x2d, 0x28, 0xc0, 0xd2, 0x9e, 0xb1, 0x6f, 0x34, 0xf5, 0x9a, 0xc5, 0xa3, 0xf7,
	0x0e, 0x1a, 0x0d, 0x59, 0x42, 0x37, 0x61, 0x71, 0xe7, 0xc0, 0xac, 0xea, 0x7d, 0x60, 0x4a, 0xfd,
	0x90, 0x82, 0xa5, 0x83, 0xe4, 0xfd, 0xb0, 0x4f, 0x28, 0x66, 0x5c, 0x86, 0x47, 0x8e, 0x34, 0xd5,
	0xc8, 0x79, 0x02, 0xf3, 0xc4, 0xb3, 0x45, 0x66, 0x6a, 0x62, 0xe6, 0x0d, 0xe2, 0xd9, 0x3c, 0xed,
	0x16, 0xcc, 0x51, 0x1c, 0xb6, 0x09, 0x8d, 0xef, 0x73, 0x6c, 0xb1, 0x96, 0xf4, 0x48, 0x78, 0x1c,
	0x4f, 0x7e, 0xbe, 0x66, 0xb3, 0x3b, 0x1e, 0x4c, 0x36, 0xa1, 0xd8, 0x71, 0xe3, 0x49, 0x9f, 0x13,
	0x60, 0x8d, 0x63, 0xe8, 0x21, 0xc8, 0x2d, 0x56, 0x79, 0xd7, 0x0a, 0x45, 0xed, 0x89, 0xad, 0xcc,
	0x95, 0xa4, 0xd5, 0x79, 0x73, 0x51, 0xe0, 0x66, 0x02, 0xb3, 0x1b, 0x83, 0x03, 0x67, 0xe8, 0x25,
	0x00, 0x38, 0x70, 0xe2, 0x77, 0x80, 0xfa, 0x8f, 0x04, 0x72, 0x32, 0x92, 0x2f, 0xaa, 0x64, 0xc3,
	0x22, 0xee, 0x61, 0xc7, 0x65, 0x17, 0xda, 0x3a, 0xf7, 0xbd, 0x0b, 0x49, 0xd9, 0x1a, 0x73, 0x26,
	0x86, 0xbf, 0x50, 0xd6, 0x92, 0xf4, 0x37, 0x2c, 0x5b, 0xcc, 0xc0, 0x3c, 0x1e, 0x00, 0x8b, 0x27,
	0x70, 0x73, 0x44, 0xd8, 0x88, 0xe9, 0xf1, 0xbc, 0x7f, 0x7a, 0x64, 0x37, 0xee, 0x8d, 0x21, 0xc1,
	0xbe, 0x91, 0x10, 0xe8, 0x1f, 0x31, 0x79, 0xc8, 0xf5, 0xbb, 0x36, 0xfe, 0xbc, 0x01, 0x50, 0x65,
	0xa9, 0x7c, 0x72, 0xa1, 0xdf, 0x25, 0x58, 0x18, 0xd0, 0x54, 0x34, 0xee, 0x39, 0x37, 0x4a, 0xe6,
	0x8b, 0x9f, 0x5d, 0x2f, 0x58, 0xc8, 0xb4, 0xfa, 0xe4, 0xdb, 0xbf, 0xff, 0xfd, 0x39, 0x55, 0x41,
	0x8f, 0xd9, 0xa3, 0xfa, 0x1b, 0x21, 0x6b, 0x2f, 0x82, 0xd0, 0x7f, 0x47, 0x5a, 0x34, 0xaa, 0xac,
	0x55, 0x92, 0x77, 0x53, 0x54, 0x59, 0x7b, 0x5f, 0xb9, 0x94, 0xe7, 0x1f, 0x25, 0xc8, 0xf6, 0xa9,
	0x2a, 0x7a, 0x38, 0x66, 0xd3, 0xab, 0xca, 0x5b, 0x9c, 0x24, 0x36, 0x43, 0x94, 0x98, 0x30, 0x8c,
	0x21, 0x74, 0xc9, 0xa7, 0xb2, 0xf6, 0x1e, 0xfd, 0x2a, 0x41, 0x7e, 0x50, 0xbd, 0xd1, 0xb8, 0x52,
	0x8c, 0x14, 0xf9, 0xe2, 0xdd, 0x24, 0xba, 0xef, 0xc5, 0x5f, 0xbe, 0xb8, 0xb1, 0xea, 0x4b, 0x4e,
	0xeb, 0xb9, 0x3a, 0x5d, 0xa5, 0x36, 0x2f, 0xa4, 0x13, 0xfd, 0x21, 0x41, 0x7e, 0x50, 0xce, 0xc7,
	0x12, 0x1c, 0xa9, 0xfa, 0x93, 0x08, 0xbe, 0xe2, 0x04, 0xb7, 0x37, 0x9e, 0x72, 0x82, 0xc9, 0xb6,
	0xe5, 0xeb, 0x16, 0xb0, 0x8f, 0xe9, 0x07, 0x09, 0xe4, 0x61, 0x55, 0x45, 0xe5, 0xe9, 0xe4, 0x77,
	0x12, 0x5b, 0x8d, 0xb3, 0xdd, 0x52, 0x9f, 0x4e, 0xd5, 0xe5, 0xcd, 0x93, 0x78, 0xb7, 0x4d, 0x69,
	0x0d, 0xfd, 0x22, 0x41, 0x7e, 0x70, 0x18, 0x8d, 0x2d, 0xe8, 0xc8, 0x99, 0x35, 0x89, 0x62, 0x7c,
	0x10, 0xd7, 0xa6, 0x3b, 0x88, 0xdb, 0x11, 0xdc, 0x69, 0xf9, 0x9d, 0xd1, 0x44, 0xb6, 0x95, 0xcb,
	0x8b, 0xde, 0x20, 0x61, 0xcf, 0x69, 0x91, 0xa3, 0x75, 0x36, 0x7a, 0xfc, 0x43, 0xe9, 0xcd, 0x66,
	0x9c, 0xd2, 0xf6, 0x5d, 0xec, 0xb5, 0xcb, 0x7e, 0xd8, 0xae, 0xb4, 0x89, 0xc7, 0x95, 0xbc, 0x22,
	0x5c, 0x38, 0x70, 0xa2, 0xa1, 0x7f, 0xc2, 0x5b, 0x7c, 0x71, 0x3c, 0xc7, 0xc3, 0x3e, 0xff, 0x2f,
	0x00, 0x00, 0xff, 0xff, 0xd9, 0x50, 0x6a, 0xff, 0x2f, 0x0f, 0x00, 0x00,
}
