package certstore

/*
#include <windows.h>
#include <bcrypt.h>
#include <ncrypt.h>

//
// Go complains about LPCWSTR constants not being defined, so we define getter
// methods for a bunch of constants we might want.
//

// Store name
LPCSTR GET_CERT_STORE_PROV_SYSTEM_W() { return CERT_STORE_PROV_SYSTEM_W; }

// NCRYPT Object Property Names
LPCWSTR GET_NCRYPT_ALGORITHM_GROUP_PROPERTY() { return NCRYPT_ALGORITHM_GROUP_PROPERTY; }
LPCWSTR GET_NCRYPT_ALGORITHM_PROPERTY() { return NCRYPT_ALGORITHM_PROPERTY; }
LPCWSTR GET_NCRYPT_BLOCK_LENGTH_PROPERTY() { return NCRYPT_BLOCK_LENGTH_PROPERTY; }
LPCWSTR GET_NCRYPT_CERTIFICATE_PROPERTY() { return NCRYPT_CERTIFICATE_PROPERTY; }
LPCWSTR GET_NCRYPT_DH_PARAMETERS_PROPERTY() { return NCRYPT_DH_PARAMETERS_PROPERTY; }
LPCWSTR GET_NCRYPT_EXPORT_POLICY_PROPERTY() { return NCRYPT_EXPORT_POLICY_PROPERTY; }
LPCWSTR GET_NCRYPT_IMPL_TYPE_PROPERTY() { return NCRYPT_IMPL_TYPE_PROPERTY; }
LPCWSTR GET_NCRYPT_KEY_TYPE_PROPERTY() { return NCRYPT_KEY_TYPE_PROPERTY; }
LPCWSTR GET_NCRYPT_KEY_USAGE_PROPERTY() { return NCRYPT_KEY_USAGE_PROPERTY; }
LPCWSTR GET_NCRYPT_LAST_MODIFIED_PROPERTY() { return NCRYPT_LAST_MODIFIED_PROPERTY; }
LPCWSTR GET_NCRYPT_LENGTH_PROPERTY() { return NCRYPT_LENGTH_PROPERTY; }
LPCWSTR GET_NCRYPT_LENGTHS_PROPERTY() { return NCRYPT_LENGTHS_PROPERTY; }
LPCWSTR GET_NCRYPT_MAX_NAME_LENGTH_PROPERTY() { return NCRYPT_MAX_NAME_LENGTH_PROPERTY; }
LPCWSTR GET_NCRYPT_NAME_PROPERTY() { return NCRYPT_NAME_PROPERTY; }
LPCWSTR GET_NCRYPT_PIN_PROMPT_PROPERTY() { return NCRYPT_PIN_PROMPT_PROPERTY; }
LPCWSTR GET_NCRYPT_PIN_PROPERTY() { return NCRYPT_PIN_PROPERTY; }
LPCWSTR GET_NCRYPT_PROVIDER_HANDLE_PROPERTY() { return NCRYPT_PROVIDER_HANDLE_PROPERTY; }
LPCWSTR GET_NCRYPT_READER_PROPERTY() { return NCRYPT_READER_PROPERTY; }
LPCWSTR GET_NCRYPT_ROOT_CERTSTORE_PROPERTY() { return NCRYPT_ROOT_CERTSTORE_PROPERTY; }
LPCWSTR GET_NCRYPT_SECURE_PIN_PROPERTY() { return NCRYPT_SECURE_PIN_PROPERTY; }
LPCWSTR GET_NCRYPT_SECURITY_DESCR_PROPERTY() { return NCRYPT_SECURITY_DESCR_PROPERTY; }
LPCWSTR GET_NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY() { return NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY; }
LPCWSTR GET_NCRYPT_SMARTCARD_GUID_PROPERTY() { return NCRYPT_SMARTCARD_GUID_PROPERTY; }
LPCWSTR GET_NCRYPT_UI_POLICY_PROPERTY() { return NCRYPT_UI_POLICY_PROPERTY; }
LPCWSTR GET_NCRYPT_UNIQUE_NAME_PROPERTY() { return NCRYPT_UNIQUE_NAME_PROPERTY; }
LPCWSTR GET_NCRYPT_USE_CONTEXT_PROPERTY() { return NCRYPT_USE_CONTEXT_PROPERTY; }
LPCWSTR GET_NCRYPT_USE_COUNT_ENABLED_PROPERTY() { return NCRYPT_USE_COUNT_ENABLED_PROPERTY; }
LPCWSTR GET_NCRYPT_USE_COUNT_PROPERTY() { return NCRYPT_USE_COUNT_PROPERTY; }
LPCWSTR GET_NCRYPT_USER_CERTSTORE_PROPERTY() { return NCRYPT_USER_CERTSTORE_PROPERTY; }
LPCWSTR GET_NCRYPT_VERSION_PROPERTY() { return NCRYPT_VERSION_PROPERTY; }
LPCWSTR GET_NCRYPT_WINDOW_HANDLE_PROPERTY() { return NCRYPT_WINDOW_HANDLE_PROPERTY; }

// BCRYPT BLOB Types
LPCWSTR GET_BCRYPT_DH_PRIVATE_BLOB() { return BCRYPT_DH_PRIVATE_BLOB; }
LPCWSTR GET_BCRYPT_DH_PUBLIC_BLOB() { return BCRYPT_DH_PUBLIC_BLOB; }
LPCWSTR GET_BCRYPT_DSA_PRIVATE_BLOB() { return BCRYPT_DSA_PRIVATE_BLOB; }
LPCWSTR GET_BCRYPT_DSA_PUBLIC_BLOB() { return BCRYPT_DSA_PUBLIC_BLOB; }
LPCWSTR GET_BCRYPT_ECCPRIVATE_BLOB() { return BCRYPT_ECCPRIVATE_BLOB; }
LPCWSTR GET_BCRYPT_ECCPUBLIC_BLOB() { return BCRYPT_ECCPUBLIC_BLOB; }
LPCWSTR GET_BCRYPT_PUBLIC_KEY_BLOB() { return BCRYPT_PUBLIC_KEY_BLOB; }
LPCWSTR GET_BCRYPT_PRIVATE_KEY_BLOB() { return BCRYPT_PRIVATE_KEY_BLOB; }
LPCWSTR GET_BCRYPT_RSAFULLPRIVATE_BLOB() { return BCRYPT_RSAFULLPRIVATE_BLOB; }
LPCWSTR GET_BCRYPT_RSAPRIVATE_BLOB() { return BCRYPT_RSAPRIVATE_BLOB; }
LPCWSTR GET_BCRYPT_RSAPUBLIC_BLOB() { return BCRYPT_RSAPUBLIC_BLOB; }

// BCRYPT Algorithm Names
LPCWSTR GET_BCRYPT_3DES_ALGORITHM() { return BCRYPT_3DES_ALGORITHM; }
LPCWSTR GET_BCRYPT_3DES_112_ALGORITHM() { return BCRYPT_3DES_112_ALGORITHM; }
LPCWSTR GET_BCRYPT_AES_ALGORITHM() { return BCRYPT_AES_ALGORITHM; }
LPCWSTR GET_BCRYPT_AES_CMAC_ALGORITHM() { return BCRYPT_AES_CMAC_ALGORITHM; }
LPCWSTR GET_BCRYPT_AES_GMAC_ALGORITHM() { return BCRYPT_AES_GMAC_ALGORITHM; }
LPCWSTR GET_BCRYPT_CAPI_KDF_ALGORITHM() { return BCRYPT_CAPI_KDF_ALGORITHM; }
LPCWSTR GET_BCRYPT_DES_ALGORITHM() { return BCRYPT_DES_ALGORITHM; }
LPCWSTR GET_BCRYPT_DESX_ALGORITHM() { return BCRYPT_DESX_ALGORITHM; }
LPCWSTR GET_BCRYPT_DH_ALGORITHM() { return BCRYPT_DH_ALGORITHM; }
LPCWSTR GET_BCRYPT_DSA_ALGORITHM() { return BCRYPT_DSA_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDH_P256_ALGORITHM() { return BCRYPT_ECDH_P256_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDH_P384_ALGORITHM() { return BCRYPT_ECDH_P384_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDH_P521_ALGORITHM() { return BCRYPT_ECDH_P521_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDSA_P256_ALGORITHM() { return BCRYPT_ECDSA_P256_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDSA_P384_ALGORITHM() { return BCRYPT_ECDSA_P384_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDSA_P521_ALGORITHM() { return BCRYPT_ECDSA_P521_ALGORITHM; }
LPCWSTR GET_BCRYPT_MD2_ALGORITHM() { return BCRYPT_MD2_ALGORITHM; }
LPCWSTR GET_BCRYPT_MD4_ALGORITHM() { return BCRYPT_MD4_ALGORITHM; }
LPCWSTR GET_BCRYPT_MD5_ALGORITHM() { return BCRYPT_MD5_ALGORITHM; }
LPCWSTR GET_BCRYPT_RC2_ALGORITHM() { return BCRYPT_RC2_ALGORITHM; }
LPCWSTR GET_BCRYPT_RC4_ALGORITHM() { return BCRYPT_RC4_ALGORITHM; }
LPCWSTR GET_BCRYPT_RNG_ALGORITHM() { return BCRYPT_RNG_ALGORITHM; }
LPCWSTR GET_BCRYPT_RNG_DUAL_EC_ALGORITHM() { return BCRYPT_RNG_DUAL_EC_ALGORITHM; }
LPCWSTR GET_BCRYPT_RNG_FIPS186_DSA_ALGORITHM() { return BCRYPT_RNG_FIPS186_DSA_ALGORITHM; }
LPCWSTR GET_BCRYPT_RSA_ALGORITHM() { return BCRYPT_RSA_ALGORITHM; }
LPCWSTR GET_BCRYPT_RSA_SIGN_ALGORITHM() { return BCRYPT_RSA_SIGN_ALGORITHM; }
LPCWSTR GET_BCRYPT_SHA1_ALGORITHM() { return BCRYPT_SHA1_ALGORITHM; }
LPCWSTR GET_BCRYPT_SHA256_ALGORITHM() { return BCRYPT_SHA256_ALGORITHM; }
LPCWSTR GET_BCRYPT_SHA384_ALGORITHM() { return BCRYPT_SHA384_ALGORITHM; }
LPCWSTR GET_BCRYPT_SHA512_ALGORITHM() { return BCRYPT_SHA512_ALGORITHM; }
LPCWSTR GET_BCRYPT_SP800108_CTR_HMAC_ALGORITHM() { return BCRYPT_SP800108_CTR_HMAC_ALGORITHM; }
LPCWSTR GET_BCRYPT_SP80056A_CONCAT_ALGORITHM() { return BCRYPT_SP80056A_CONCAT_ALGORITHM; }
LPCWSTR GET_BCRYPT_PBKDF2_ALGORITHM() { return BCRYPT_PBKDF2_ALGORITHM; }

//
// These may be missing from bcrypt.h if (NTDDI_VERSION >= NTDDI_WINTHRESHOLD)
// Not sure what that really means...
//

#ifndef BCRYPT_ECDSA_ALGORITHM
#define BCRYPT_ECDSA_ALGORITHM L"ECDSA"
#endif

#ifndef BCRYPT_ECDH_ALGORITHM
#define BCRYPT_ECDH_ALGORITHM L"ECDH"
#endif

#ifndef BCRYPT_XTS_AES_ALGORITHM
#define BCRYPT_XTS_AES_ALGORITHM L"XTS-AES"
#endif

LPCWSTR GET_BCRYPT_ECDSA_ALGORITHM() { return BCRYPT_ECDSA_ALGORITHM; }
LPCWSTR GET_BCRYPT_ECDH_ALGORITHM() { return BCRYPT_ECDH_ALGORITHM; }
LPCWSTR GET_BCRYPT_XTS_AES_ALGORITHM() { return BCRYPT_XTS_AES_ALGORITHM; }
*/
import "C"

var (
	// Store name
	CERT_STORE_PROV_SYSTEM_W = C.GET_CERT_STORE_PROV_SYSTEM_W()

	// NCRYPT Object Property Names
	NCRYPT_ALGORITHM_GROUP_PROPERTY        = C.GET_NCRYPT_ALGORITHM_GROUP_PROPERTY()
	NCRYPT_ALGORITHM_PROPERTY              = C.GET_NCRYPT_ALGORITHM_PROPERTY()
	NCRYPT_BLOCK_LENGTH_PROPERTY           = C.GET_NCRYPT_BLOCK_LENGTH_PROPERTY()
	NCRYPT_CERTIFICATE_PROPERTY            = C.GET_NCRYPT_CERTIFICATE_PROPERTY()
	NCRYPT_DH_PARAMETERS_PROPERTY          = C.GET_NCRYPT_DH_PARAMETERS_PROPERTY()
	NCRYPT_EXPORT_POLICY_PROPERTY          = C.GET_NCRYPT_EXPORT_POLICY_PROPERTY()
	NCRYPT_IMPL_TYPE_PROPERTY              = C.GET_NCRYPT_IMPL_TYPE_PROPERTY()
	NCRYPT_KEY_TYPE_PROPERTY               = C.GET_NCRYPT_KEY_TYPE_PROPERTY()
	NCRYPT_KEY_USAGE_PROPERTY              = C.GET_NCRYPT_KEY_USAGE_PROPERTY()
	NCRYPT_LAST_MODIFIED_PROPERTY          = C.GET_NCRYPT_LAST_MODIFIED_PROPERTY()
	NCRYPT_LENGTH_PROPERTY                 = C.GET_NCRYPT_LENGTH_PROPERTY()
	NCRYPT_LENGTHS_PROPERTY                = C.GET_NCRYPT_LENGTHS_PROPERTY()
	NCRYPT_MAX_NAME_LENGTH_PROPERTY        = C.GET_NCRYPT_MAX_NAME_LENGTH_PROPERTY()
	NCRYPT_NAME_PROPERTY                   = C.GET_NCRYPT_NAME_PROPERTY()
	NCRYPT_PIN_PROMPT_PROPERTY             = C.GET_NCRYPT_PIN_PROMPT_PROPERTY()
	NCRYPT_PIN_PROPERTY                    = C.GET_NCRYPT_PIN_PROPERTY()
	NCRYPT_PROVIDER_HANDLE_PROPERTY        = C.GET_NCRYPT_PROVIDER_HANDLE_PROPERTY()
	NCRYPT_READER_PROPERTY                 = C.GET_NCRYPT_READER_PROPERTY()
	NCRYPT_ROOT_CERTSTORE_PROPERTY         = C.GET_NCRYPT_ROOT_CERTSTORE_PROPERTY()
	NCRYPT_SECURE_PIN_PROPERTY             = C.GET_NCRYPT_SECURE_PIN_PROPERTY()
	NCRYPT_SECURITY_DESCR_PROPERTY         = C.GET_NCRYPT_SECURITY_DESCR_PROPERTY()
	NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY = C.GET_NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY()
	NCRYPT_SMARTCARD_GUID_PROPERTY         = C.GET_NCRYPT_SMARTCARD_GUID_PROPERTY()
	NCRYPT_UI_POLICY_PROPERTY              = C.GET_NCRYPT_UI_POLICY_PROPERTY()
	NCRYPT_UNIQUE_NAME_PROPERTY            = C.GET_NCRYPT_UNIQUE_NAME_PROPERTY()
	NCRYPT_USE_CONTEXT_PROPERTY            = C.GET_NCRYPT_USE_CONTEXT_PROPERTY()
	NCRYPT_USE_COUNT_ENABLED_PROPERTY      = C.GET_NCRYPT_USE_COUNT_ENABLED_PROPERTY()
	NCRYPT_USE_COUNT_PROPERTY              = C.GET_NCRYPT_USE_COUNT_PROPERTY()
	NCRYPT_USER_CERTSTORE_PROPERTY         = C.GET_NCRYPT_USER_CERTSTORE_PROPERTY()
	NCRYPT_VERSION_PROPERTY                = C.GET_NCRYPT_VERSION_PROPERTY()
	NCRYPT_WINDOW_HANDLE_PROPERTY          = C.GET_NCRYPT_WINDOW_HANDLE_PROPERTY()

	// BCRYPT BLOB Types
	BCRYPT_DH_PRIVATE_BLOB     = C.GET_BCRYPT_DH_PRIVATE_BLOB()
	BCRYPT_DH_PUBLIC_BLOB      = C.GET_BCRYPT_DH_PUBLIC_BLOB()
	BCRYPT_DSA_PRIVATE_BLOB    = C.GET_BCRYPT_DSA_PRIVATE_BLOB()
	BCRYPT_DSA_PUBLIC_BLOB     = C.GET_BCRYPT_DSA_PUBLIC_BLOB()
	BCRYPT_ECCPRIVATE_BLOB     = C.GET_BCRYPT_ECCPRIVATE_BLOB()
	BCRYPT_ECCPUBLIC_BLOB      = C.GET_BCRYPT_ECCPUBLIC_BLOB()
	BCRYPT_PUBLIC_KEY_BLOB     = C.GET_BCRYPT_PUBLIC_KEY_BLOB()
	BCRYPT_PRIVATE_KEY_BLOB    = C.GET_BCRYPT_PRIVATE_KEY_BLOB()
	BCRYPT_RSAFULLPRIVATE_BLOB = C.GET_BCRYPT_RSAFULLPRIVATE_BLOB()
	BCRYPT_RSAPRIVATE_BLOB     = C.GET_BCRYPT_RSAPRIVATE_BLOB()
	BCRYPT_RSAPUBLIC_BLOB      = C.GET_BCRYPT_RSAPUBLIC_BLOB()

	// BCRYPT Algorithm Names
	BCRYPT_3DES_ALGORITHM              = C.GET_BCRYPT_3DES_ALGORITHM()
	BCRYPT_3DES_112_ALGORITHM          = C.GET_BCRYPT_3DES_112_ALGORITHM()
	BCRYPT_AES_ALGORITHM               = C.GET_BCRYPT_AES_ALGORITHM()
	BCRYPT_AES_CMAC_ALGORITHM          = C.GET_BCRYPT_AES_CMAC_ALGORITHM()
	BCRYPT_AES_GMAC_ALGORITHM          = C.GET_BCRYPT_AES_GMAC_ALGORITHM()
	BCRYPT_CAPI_KDF_ALGORITHM          = C.GET_BCRYPT_CAPI_KDF_ALGORITHM()
	BCRYPT_DES_ALGORITHM               = C.GET_BCRYPT_DES_ALGORITHM()
	BCRYPT_DESX_ALGORITHM              = C.GET_BCRYPT_DESX_ALGORITHM()
	BCRYPT_DH_ALGORITHM                = C.GET_BCRYPT_DH_ALGORITHM()
	BCRYPT_DSA_ALGORITHM               = C.GET_BCRYPT_DSA_ALGORITHM()
	BCRYPT_ECDH_P256_ALGORITHM         = C.GET_BCRYPT_ECDH_P256_ALGORITHM()
	BCRYPT_ECDH_P384_ALGORITHM         = C.GET_BCRYPT_ECDH_P384_ALGORITHM()
	BCRYPT_ECDH_P521_ALGORITHM         = C.GET_BCRYPT_ECDH_P521_ALGORITHM()
	BCRYPT_ECDSA_P256_ALGORITHM        = C.GET_BCRYPT_ECDSA_P256_ALGORITHM()
	BCRYPT_ECDSA_P384_ALGORITHM        = C.GET_BCRYPT_ECDSA_P384_ALGORITHM()
	BCRYPT_ECDSA_P521_ALGORITHM        = C.GET_BCRYPT_ECDSA_P521_ALGORITHM()
	BCRYPT_MD2_ALGORITHM               = C.GET_BCRYPT_MD2_ALGORITHM()
	BCRYPT_MD4_ALGORITHM               = C.GET_BCRYPT_MD4_ALGORITHM()
	BCRYPT_MD5_ALGORITHM               = C.GET_BCRYPT_MD5_ALGORITHM()
	BCRYPT_RC2_ALGORITHM               = C.GET_BCRYPT_RC2_ALGORITHM()
	BCRYPT_RC4_ALGORITHM               = C.GET_BCRYPT_RC4_ALGORITHM()
	BCRYPT_RNG_ALGORITHM               = C.GET_BCRYPT_RNG_ALGORITHM()
	BCRYPT_RNG_DUAL_EC_ALGORITHM       = C.GET_BCRYPT_RNG_DUAL_EC_ALGORITHM()
	BCRYPT_RNG_FIPS186_DSA_ALGORITHM   = C.GET_BCRYPT_RNG_FIPS186_DSA_ALGORITHM()
	BCRYPT_RSA_ALGORITHM               = C.GET_BCRYPT_RSA_ALGORITHM()
	BCRYPT_RSA_SIGN_ALGORITHM          = C.GET_BCRYPT_RSA_SIGN_ALGORITHM()
	BCRYPT_SHA1_ALGORITHM              = C.GET_BCRYPT_SHA1_ALGORITHM()
	BCRYPT_SHA256_ALGORITHM            = C.GET_BCRYPT_SHA256_ALGORITHM()
	BCRYPT_SHA384_ALGORITHM            = C.GET_BCRYPT_SHA384_ALGORITHM()
	BCRYPT_SHA512_ALGORITHM            = C.GET_BCRYPT_SHA512_ALGORITHM()
	BCRYPT_SP800108_CTR_HMAC_ALGORITHM = C.GET_BCRYPT_SP800108_CTR_HMAC_ALGORITHM()
	BCRYPT_SP80056A_CONCAT_ALGORITHM   = C.GET_BCRYPT_SP80056A_CONCAT_ALGORITHM()
	BCRYPT_PBKDF2_ALGORITHM            = C.GET_BCRYPT_PBKDF2_ALGORITHM()
	BCRYPT_ECDSA_ALGORITHM             = C.GET_BCRYPT_ECDSA_ALGORITHM()
	BCRYPT_ECDH_ALGORITHM              = C.GET_BCRYPT_ECDH_ALGORITHM()
	BCRYPT_XTS_AES_ALGORITHM           = C.GET_BCRYPT_XTS_AES_ALGORITHM()
)
